// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Latvian (`lv`).
class SLv extends S {
  SLv([String locale = 'lv']) : super(locale);

  @override
  String get appName => 'Dzirnavas';

  @override
  String get welcome => 'Laipni lūdzam';

  @override
  String get yes => 'Jā';

  @override
  String get no => 'Nē';

  @override
  String get game => 'Spēle';

  @override
  String get humanVsAi => 'Cilvēks vs. AI';

  @override
  String get humanVsHuman => 'Cilvēks pret cilvēku';

  @override
  String get aiVsAi => 'AI vs. AI';

  @override
  String get humanVsCloud => 'Cilvēks pret mākoni';

  @override
  String get humanVsLAN => 'Cilvēks pret LAN';

  @override
  String get testViaLAN => 'Tests, izmantojot LAN';

  @override
  String get move => 'Pārvietot';

  @override
  String get showMoveList => 'Pārvietojumu saraksts';

  @override
  String get moveList => 'Pārvietojumu saraksts';

  @override
  String get noGameRecord => 'Nav ieraksta';

  @override
  String get ok => 'LABI';

  @override
  String get confirm => 'Apstiprināt';

  @override
  String get cancel => 'Atcelt';

  @override
  String get tipSelectWrong => 'Izvēlieties nepareizu gabalu.';

  @override
  String get tipPlace => 'Ievietojiet savus gabalus.';

  @override
  String get tipBanPlace => 'Šeit to nevar ievietot.';

  @override
  String get tipPlaced => 'Jūs ievietojāt.';

  @override
  String get tipRemove => 'Noņemiet kādu gabaliņu.';

  @override
  String get tipBanRemove => 'Jūs to nevarat noņemt.';

  @override
  String get tipRemoved => 'Jūs noņēmāt.';

  @override
  String get tipMove => 'Pārvietot figūru.';

  @override
  String get tipCannotPlace => 'Jūs nevarat šeit novietot savu figūru.';

  @override
  String get tipCannotMove => 'Jūs nevarat pārvietot savu figūru šeit.';

  @override
  String get tipMill => 'Dzirnavas! Paņem pretinieka figūru.';

  @override
  String get tipContinueMill => 'Turpiniet ņemt pretinieka figūru.';

  @override
  String get tipSelectOpponentsPiece =>
      'Izvēlieties vienu no pretinieka figūrām.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Jūs nevarat izņemt figūru no dzirnavām.';

  @override
  String get tipCanMoveOnePoint => 'Figūra var pārvietoties par 1 punktu.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Jūs nevarat pārvietot pretinieka figūru.';

  @override
  String get tipSelectPieceToMove => 'Izvēlieties savu figūru, ko pārvietot.';

  @override
  String get tipHaveThreePiecesLeft => 'Jums ir palikušas trīs figūras.';

  @override
  String get tipCanMoveToAnyPoint =>
      'Jūs varat pārvietoties uz jebkuru punktu.';

  @override
  String tipToMove(Object player) {
    return '$player, lai pārvietotos.';
  }

  @override
  String get whiteWin => 'Uzvar 1. spēlētājs!';

  @override
  String get blackWin => '2. spēlētājs uzvar!';

  @override
  String get won => 'Uzvarēja';

  @override
  String get lost => 'Zaudēts';

  @override
  String get thinking => 'Domājot…';

  @override
  String get newGame => 'Jauna spēle';

  @override
  String get importGame => 'Importēt spēli';

  @override
  String get exportGame => 'Eksportēt spēli';

  @override
  String get gameImported => 'Spēle importēta.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Nevar importēt $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'Kustības un noteikumi nesakrīt.';

  @override
  String get pleaseWait => 'Lūdzu, uzgaidiet.';

  @override
  String get restartGame => 'Restartēt pašreizējo spēli?';

  @override
  String get restart => 'Restartēt';

  @override
  String get gameStarted => 'Spēle ir uzsākta, lūdzu, ievietojiet.';

  @override
  String get analyzing => 'Analizē…';

  @override
  String error(Object message) {
    return 'Kļūda: $message';
  }

  @override
  String get winRate => 'Uzvaras koeficients';

  @override
  String get score => 'Rezultāts:';

  @override
  String get white => 'Spēlētājs 1';

  @override
  String get black => 'Spēlētājs 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player gabalu skaits ir mazāks par trim.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player atkāpšanās.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player vairs nav kā iet.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Dēlis ir pilns, un $player vairs nav kur iet.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Laiks ir beidzies, $player zaudēts.';
  }

  @override
  String get drawReasonRule50 =>
      'Pārvietošanas fāzē pēdējā noteiktajā gājienu skaitā nav izņemta neviena figūra.';

  @override
  String get drawReasonBoardIsFull => 'Tas ir neizšķirts, jo tāfele ir pilna.';

  @override
  String get drawReasonThreefoldRepetition =>
      'Tas ir neizšķirts trīskāršas atkārtošanās dēļ.';

  @override
  String get gameOverUnknownReason => 'Spēle ir beigusies! Nav zināms iemesls.';

  @override
  String get gameOver => 'Spēles beigas';

  @override
  String get youWin => 'Jūs uzvarējāt! Apsveicam!';

  @override
  String challengeHarderLevel(int level) {
    return 'Izaicinājums grūtāks līmenis? Jaunais līmenis būs $level!';
  }

  @override
  String get youLose => 'Jūs zaudējat!';

  @override
  String get analyze => 'Analizēt';

  @override
  String get about => 'Par';

  @override
  String version(Object versionNumber) {
    return 'Versija: $versionNumber';
  }

  @override
  String get thanks => 'Paldies';

  @override
  String get settings => 'Iestatījumi';

  @override
  String get options => 'Iespējas';

  @override
  String get generalSettings => 'Vispārīgie iestatījumi';

  @override
  String get skillLevel => 'Grūtības līmenis';

  @override
  String get moveTime => 'Mākslīgā intelekta domāšanas laiks';

  @override
  String get difficulty => 'Grūtības';

  @override
  String get playSounds => 'Skaņas efekti';

  @override
  String get playSoundsInTheGame => 'Spēlē atskaņot skaņas';

  @override
  String get keepMuteWhenTakingBack =>
      'Atgriešanās laikā saglabāt izslēgtu skaņu';

  @override
  String get tone => 'Toni';

  @override
  String get whoMovesFirst => 'Pirmais gājiens';

  @override
  String get human => 'Cilvēks';

  @override
  String get ai => 'MĀKSLĪGAIS INTELEKTS';

  @override
  String get alternate => 'Alternatīva';

  @override
  String get isAutoRestart =>
      'Automātiska spēles atsākšana, kad spēle ir beigusies';

  @override
  String get isAutoChangeFirstMove => 'Automātiski mainīt pirmo gājienu';

  @override
  String get shufflingEnabled => 'Nejaušs gājiens';

  @override
  String get misc => 'Dažādi';

  @override
  String get rules => 'Noteikumi';

  @override
  String get piecesCount => 'Katra spēlētāja figūru skaits';

  @override
  String get piecesCount_Detail => 'Cik figūru ir katram spēlētājam?';

  @override
  String get flyPieceCount => 'Lidojošās figūras numurs';

  @override
  String get flyPieceCount_Detail =>
      'Ja ir ieslēgta funkcija \"Lidojošā figūra\", kad spēlētāja figūru skaits ir samazināts līdz noteiktam skaitlim, viņa figūras var brīvi pārvietoties uz jebkuru neaizņemtu punktu, nevis tikai uz blakus esošiem punktiem, kā tas ir pārējā spēles laikā.';

  @override
  String get piecesAtLeastCount => 'Vismazākais figūru skaits';

  @override
  String get hasDiagonalLines => 'Diagonālās līnijas';

  @override
  String get hasDiagonalLines_Detail =>
      'Pievienojiet laukumam četras diagonālās līnijas.';

  @override
  String get isDefenderMoveFirst => 'Otrais spēlētājs pārvietojas pirmais';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Spēlētājs, kurš izvietošanas fāzē pārvietojas otrais, pārvietošanas fāzē pārvietojas pirmais.';

  @override
  String get mayRemoveMultiple => 'Vairākkārtēja pārvietošana';

  @override
  String get mayRemoveMultiple_Detail =>
      'Ja spēlētājs noslēdz vairāk nekā vienu dzirnaviņu vienlaicīgi, viņš noņems tik dzirnaviņu, cik viņš noslēdzis.';

  @override
  String get mayRemoveFromMillsAlways => 'Iznīcināt dzirnavas';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Pēc noklusējuma spēlētājiem vispirms ir jānoņem visas citas figūras, pirms noņemt figūru no izveidotajām dzirnavām. Ieslēdziet šo opciju, lai atspējotu šo ierobežojumu.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Otrais spēlētājs zaudē, kad tāfele ir pilna';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Ja izvietošanas fāzes beigās dēlis ir pilns, zaudē tā puse, kas pirmā izvieto figūru. Pretējā gadījumā spēle ir neizšķirta.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Zaudēt, ja nav likumīgu gājienu';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Spēlētājs zaudē, ja pretinieks bloķē tā, ka to nevar pārvietot. Ja šī opcija ir atspējota, mainiet pusi, lai pārvietotos.';

  @override
  String get mayFly => 'Skrējiens';

  @override
  String get mayFly_Detail =>
      'Ja spēlētājam ir palikušas tikai trīs vai četras (konfigurējamas) figūras, viņš var pārvietot figūru uz jebkuru brīvu punktu.';

  @override
  String get nMoveRule => 'N gājienu noteikums';

  @override
  String get nMoveRule_Detail =>
      'Spēle tiek izlozēta, ja katrs spēlētājs noteiktā gājienu skaitā nav izdarījis nevienu gājienu.';

  @override
  String get rollback => 'Atgriešanās';

  @override
  String get pleaseSelect => 'Lūdzu, izvēlieties';

  @override
  String get copy => 'Kopēt';

  @override
  String get moveHistoryCopied =>
      'Pārvietojumu vēsture tiek kopēta uz starpliktuvi.';

  @override
  String get help => 'Palīdzība';

  @override
  String get feedback => 'Atsauksmes';

  @override
  String get exit => 'Iziet no';

  @override
  String get ruleSettings => 'Noteikumi';

  @override
  String get color => 'Krāsa';

  @override
  String get boardColor => 'Dēļa krāsa';

  @override
  String get pieceColor => 'Gabala krāsa';

  @override
  String get backgroundColor => 'Fona krāsa';

  @override
  String get lineColor => 'Borta līnijas krāsa';

  @override
  String get whitePieceColor => 'Spēlētāja 1 figūras krāsa';

  @override
  String get blackPieceColor => 'Spēlētāja 2 figūras krāsa';

  @override
  String get messageColor => 'Ziņojuma krāsa';

  @override
  String get isPieceCountInHandShown => 'Rādīt rokā esošo figūru skaitu';

  @override
  String get isNotationsShown => 'Rādīt uzrakstus uz tāfeles';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Rādīt vēstures navigācijas rīkjoslu';

  @override
  String get display => 'Rādīt';

  @override
  String get boardBorderLineWidth => 'Borta robežas platums';

  @override
  String get boardInnerLineWidth => 'Borta iekšējās līnijas platums';

  @override
  String get pieceWidth => 'Gabala platums';

  @override
  String get fontSize => 'Fonta lielums';

  @override
  String get standardNotation => 'WMD pieraksts';

  @override
  String get restore => 'Atjaunot';

  @override
  String get restoreDefaultSettings => 'Atjaunot noklusējuma iestatījumus';

  @override
  String pick(Object element) {
    return 'Izvēlieties $element';
  }

  @override
  String get info => 'Info';

  @override
  String get hint => 'Padoms';

  @override
  String get player => 'spēlētājs';

  @override
  String get player1 => 'Spēlētājs 1';

  @override
  String get player2 => 'Spēlētājs 2';

  @override
  String get howToPlay => 'Kā spēlēt';

  @override
  String get toPlacePiece =>
      'Pieskarieties jebkuram pieejamajam punktam, lai novietotu figūru.';

  @override
  String get toSelectPiece => 'Pieskarieties figūrai, lai to pārvietotu.';

  @override
  String get toMovePiece =>
      'Pieskarieties punktam, kas savienots ar figūru, lai to pārvietotu.';

  @override
  String get toRemovePiece =>
      'Pieskarieties pretinieka vienai figūrai, lai to noņemtu.';

  @override
  String get needToCreateMillFirst =>
      'Pirms figūras noņemšanas vispirms ir jāizveido dzirnavas.';

  @override
  String get needToPlayWithOwnPieces => 'Jums ir jāspēlē ar figūrām.';

  @override
  String get statistics => 'Statistika';

  @override
  String get totalGames => 'Kopējais spēļu skaits';

  @override
  String get results => 'Rezultāti';

  @override
  String get left => 'pa kreisi';

  @override
  String get privacyPolicy => 'Privātuma politika';

  @override
  String get privacyPolicy_Detail_1 =>
      'Lūdzu, uzmanīgi izlasiet un pārliecinieties, ka pilnībā to saprotat un piekrītat. ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Ja nepiekrītat šai politikai, lūdzu, nelietojiet šo lietotni. Lietojot lietotni, jūs piekrītat šiem noteikumiem.';

  @override
  String get and => ' un ';

  @override
  String get accept => 'Piekrītu';

  @override
  String get takeBack => 'Atgriezt';

  @override
  String get takingBack => 'Atgriešanās…';

  @override
  String get waiting => 'Gaidīšana…';

  @override
  String get stepForward => 'Solis uz priekšu';

  @override
  String get takeBackAll => 'Atgriezt visu';

  @override
  String get stepForwardAll => 'Solis uz priekšu visi';

  @override
  String get moveNow => 'Pārvietot tagad';

  @override
  String get done => 'Paveikts.';

  @override
  String get crackMill => 'Plaisu dzirnavas';

  @override
  String get crackMill_Detail =>
      'Ja spēlētājam ir tikai gabali dzirnavās, dzirnavās esošie gabali netiks bloķēti, lai tos noņemtu.';

  @override
  String get animationDuration => 'Animācijas ilgums';

  @override
  String get none => 'Nav';

  @override
  String get theme => 'Tēma';

  @override
  String get helpContent =>
      'Spēles mērķis ir atstāt pretinieku ar mazāk nekā trim figūrām vai bez likumīgiem gājieniem.\n\nSpēle automātiski tiek izlozēta, ja kāda pozīcija rodas trešo reizi vai ja pēdējo 100 (konfigurējamu) gājienu laikā nav izdarīts neviens gājiens.\n\nSpēle norisinās trīs posmos:\n\n1. Figūru novietošana uz brīvajiem punktiem\n2. Figūru pārvietošana uz blakus punktiem\n3. (fakultatīvs posms) figūru pārvietošana uz jebkuru brīvo punktu, kad spēlētājs ir samazinājies līdz trim figūrām.\n\nNovietošana\n\nSpēle sākas ar tukšu galdu, kas sastāv no režģa ar divdesmit četriem punktiem. Spēlētāji pēc kārtas izvieto savas figūras uz brīvajiem punktiem, līdz katrs spēlētājs ir izvietojis visas figūras uz galda. Ja spēlētājs var novietot trīs savas figūras taisni, viņam ir \"dzirnaviņas\", un viņš var noņemt vienu pretinieka figūru no dēļa.\n\nDažos noteikumos ir noteikts, ka spēlētājiem vispirms ir jānoņem visas citas figūras, pirms noņemt figūru no izveidotās dzirnaviņas.\n\nDažos noteikumos izvietošanas fāzē figūriņas vairs nevar novietot līdz noņemtās figūriņas punktiem.\n\nKad visas figūriņas ir izmantotas, spēlētāji pēc kārtas sāk kustību.\n\nPārvietošanās\n\nLai pārvietotos, spēlētājs pārvieto vienu no savām figūrām pa dēļa līniju uz brīvo blakus esošo punktu. Ja viņš to nevar izdarīt, viņš ir zaudējis spēli. Tāpat kā izvietošanas fāzē, spēlētājam, kurš izlīdzina trīs savas figūras uz dēļa līnijas, ir dzirnaviņas un viņš var noņemt vienu no pretinieka figūrām. Jebkuram spēlētājam, kurš samazinās līdz divām figūrām, nav iespējas veidot jaunas dzirnaviņas, un tādējādi viņš zaudē spēli. Spēlētājs var zaudēt arī tad, ja ir vairāk nekā trīs figūras, ja pretinieks bloķē to kustību.\n\nLidojošās\n\nDažos noteikumu variantos, kad spēlētājam ir palikušas tikai trīs figūras, viņa figūras var lidot, lēkt vai lēkt uz jebkuriem brīviem punktiem, ne tikai uz blakus esošajiem.';

  @override
  String get versionInfo => 'Informācija par versiju';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'Licence';

  @override
  String get sourceCode => 'Avota kods';

  @override
  String get appVersion => 'Lietotnes versija';

  @override
  String get general => 'Vispārīgi';

  @override
  String get advanced => 'Uzlabots';

  @override
  String get placing => 'Ievietošana';

  @override
  String get moving => 'Pārvietošana';

  @override
  String get removing => 'Noņemšana';

  @override
  String get gameOverCondition => 'Spēles beigu stāvoklis';

  @override
  String get aisPlayStyle => 'Mākslīgā intelekta spēles stils';

  @override
  String get passive => 'Pasīvais';

  @override
  String get timeout => 'Laika pārtraukums';

  @override
  String get appearance => 'Izskats';

  @override
  String get drawOnHumanExperience => 'Izmanto cilvēka pieredzi';

  @override
  String get considerMobility => 'Ņemiet vērā elementu mobilitāti';

  @override
  String get pieceCount => 'Gabalu skaits:';

  @override
  String inHand(Object player, int count) {
    return '$player rokā: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player uz borta: $count';
  }

  @override
  String get boardTop => 'Dēlis nobīdīts no augšas';

  @override
  String get notAIsTurn => 'Mākslīgais intelekts nav uz rindas.';

  @override
  String get aiIsNotThinking => 'Mākslīgais intelekts nedomā.';

  @override
  String get atEnd => 'Jūs esat gājienu saraksta beigās.';

  @override
  String get tapBackAgainToLeave => 'Pieskarieties atpakaļ, lai izietu.';

  @override
  String get more => 'Vairāk';

  @override
  String get experimental => 'Šī ir eksperimentāla funkcija.';

  @override
  String get experiments => 'Eksperimenti';

  @override
  String get ossLicenses => 'Atvērtā pirmkoda licences';

  @override
  String get language => 'Valoda';

  @override
  String get defaultLanguage => 'Noklusējuma valoda';

  @override
  String get mayMoveInPlacingPhase =>
      'Figūriņas var pārvietoties izvietošanas fāzē';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Nav atšķirīgu novietošanas un pārvietošanas fāžu, t. i., spēlētāji katrā gājienā var izlemt, vai viņi vēlas novietot figūru uz galda vai pārvietot kādu no savām figūrām (ja vien viņiem ir atlikušas figūras, ko novietot).';

  @override
  String get drawerColor => 'Izvēlnes krāsa';

  @override
  String get drawerTextColor => 'Izvēlnes teksta krāsa';

  @override
  String get drawerHighlightItemColor => 'Izvēlnes izcelšanas vienuma krāsa';

  @override
  String get mainToolbarBackgroundColor => 'Galvenās rīkjoslas fona krāsa';

  @override
  String get mainToolbarIconColor => 'Galvenās rīkjoslas ikonas krāsa';

  @override
  String get navigationToolbarBackgroundColor =>
      'Navigācijas rīkjoslas fona krāsa';

  @override
  String get navigationToolbarIconColor => 'Navigācijas rīkjoslas ikonas krāsa';

  @override
  String get autoHideToolbar => 'Automātiski paslēpt rīkjoslu';

  @override
  String get toolbarLocationOnScreen => 'Rīkjoslas atrašanās vieta ekrānā';

  @override
  String get top => 'Tops';

  @override
  String get bottom => 'Apakšā';

  @override
  String get center => 'Centrs';

  @override
  String get solidColor => 'Vienkrāsaina';

  @override
  String get picture => 'Bilde';

  @override
  String get chooseYourPicture => 'Izvēlieties savu attēlu';

  @override
  String get light => 'Gaisma';

  @override
  String get dark => 'Tumšs';

  @override
  String get themes => 'Tēmas';

  @override
  String get currentTheme => 'Pašreizējā tēma';

  @override
  String get saveTheme => 'Saglabāt motīvu';

  @override
  String get showAnalysisGraph => 'Rādīt analīzes grafiku';

  @override
  String get analysis => 'Analīze';

  @override
  String get saveGame => 'Saglabā spēli';

  @override
  String get loadGame => 'Ielādēt spēli';

  @override
  String get setupPosition => 'Iestatīšanas pozīcija';

  @override
  String get showLegalMoves => 'Rādīt likumīgus gājienus';

  @override
  String get showLastMove => 'Rādīt pēdējo kustību';

  @override
  String get showArrows => 'Rādīt bultiņas';

  @override
  String get pieces => 'Gabali';

  @override
  String get showAnalysis => 'Rādīt analīzi';

  @override
  String get threads => 'Vītnes';

  @override
  String get getInvolved => 'Iesaistīties';

  @override
  String get helpImproveTranslate => 'Palīdziet uzlabot tulkošanu';

  @override
  String get tutorial => 'Apmācība';

  @override
  String get classicMill => 'Klasiskās dzirnavas';

  @override
  String get mixedMill => 'Jauktās dzirnavas';

  @override
  String get ceylonMill => 'Ceilonas dzirnavas';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Dzirnavas var būt salauztas un atkārtoti pārtaisītas';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Ja spēlētājs pārtrauc dzirnavas, lai nekavējoties izveidotu jaunu dzirnavu, šāds spēlētājs var nākamajā gabalā pārvietot šo gabalu atpakaļ uz sākotnējo krustojumu, ja tas izveido jaunu dzirnavu.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Spēle tiek izlozēta, ja spēlētājam ir trīs figūras un pēc desmit kustībām neviens spēlētājs nenoņem pretinieka figūras';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Kad spēlētājs ir nonācis līdz trim figūrām un neviens spēlētājs nevar noņemt pretinieka gabalu desmit gājienu laikā, spēle ir neizšķirta.';

  @override
  String get close => 'Aizvērt';

  @override
  String get whitePiece => 'Balts gabals';

  @override
  String get blackPiece => 'Melns gabals';

  @override
  String get emptyPoint => 'Tukšs punkts';

  @override
  String get noPoint => 'Nav jēgas';

  @override
  String get placingPhase => 'Ievietošanas fāze';

  @override
  String get movingPhase => 'Pārvietošanās fāze';

  @override
  String get flyingPhase => 'Lidošanas fāze';

  @override
  String sideToMove(Object player) {
    return 'Pārvietojama puse: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Pēdējais gājiens: $move';
  }

  @override
  String get selected => 'Atlasīts';

  @override
  String get accessibility => 'Pieejamība';

  @override
  String get screenReaderSupport => 'Ekrāna lasītāja atbalsts';

  @override
  String get isDraw => 'Tas ir neizšķirts!';

  @override
  String get draw => 'Zīmēt';

  @override
  String get pieceHighlightColor => 'Gabalu izceltā krāsa';

  @override
  String get algorithm => 'Algoritms';

  @override
  String get endgameNMoveRule => 'Beigu spēles N-Move noteikums';

  @override
  String get endgameNMoveRule_Detail =>
      'Ja kādam no spēlētājiem ir tikai trīs gabali un neviens no spēlētājiem neizņem gabalu konkrētu kustību ietvaros, spēle tiek izlozēta.';

  @override
  String get drawReasonEndgameRule50 =>
      'Katram spēlētājam ir tikai trīs gabali, un neviens no spēlētājiem neizņem gabalu noteiktos gājienos.';

  @override
  String get threefoldRepetitionRule => 'Trīskāršs atkārtošanas noteikums';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Spēle tiek izlozēta, ja pozīcija rodas trešo reizi.';

  @override
  String get continueToMakeMove => 'Dzirnavas! Turpiniet veikt kustību.';

  @override
  String get pointStyle => 'Punkta stils';

  @override
  String get pointWidth => 'Punkta platums';

  @override
  String get solid => 'Ciets';

  @override
  String get hollow => 'Dobis';

  @override
  String get languageName => 'Latviešu';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Kustības',
      one: '$count Pārvietot',
      zero: 'Pārvietot',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Ielāde neizdevās.';

  @override
  String get filename => 'Faila nosaukums';

  @override
  String get browse => 'Pārlūkot…';

  @override
  String get gameFiles => 'Spēļu faili';

  @override
  String get gameSavedTo => 'Spēle ir saglabāta';

  @override
  String get empty => 'Tukšs';

  @override
  String get noMove => 'Nekādas kustības.';

  @override
  String get restoredPosition => 'Atjaunota sākotnējā pozīcija.';

  @override
  String get clean => 'Tīrs';

  @override
  String get cleanedUp => 'Satīrīts.';

  @override
  String get remove => 'Noņemt';

  @override
  String get noPiecesCanBeRemoved => 'Nevienu gabalu nevar noņemt.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count pieces',
      one: '$count piece',
      zero: 'Piece',
    );
    return '$_temp0 ir jānoņem.';
  }

  @override
  String placedCount(int count) {
    return 'Izvietots ($count)';
  }

  @override
  String get placedPieceCount => 'Nolikto gabalu skaits izvietošanas fāzē.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'Pašreizējais spēlētājs ir ievietojis $count figūras.';
  }

  @override
  String get notPlacingPhase => 'Nenovieto fāzi, nevar to mainīt.';

  @override
  String get paste => 'Ielīmēt';

  @override
  String get pasteDone => 'Pasta ir gatava.';

  @override
  String get cannotPaste => 'Nevar ielīmēt.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Rādīt nenovietotos un noņemtos gabalus';

  @override
  String get fullScreen => 'Pilnekrāna režīms';

  @override
  String get reopenToTakeEffect =>
      'Izejiet un atkārtoti atveriet lietotni, lai iestatījumi stātos spēkā.';

  @override
  String get forest => 'Mežs';

  @override
  String get desktopImage => 'Darbvirsmas attēls';

  @override
  String get invalidPosition => 'Nederīga pozīcija.';

  @override
  String get shareGIF => 'Kopīgojiet GIF';

  @override
  String get pixelRatio => 'Pikseļu attiecība';

  @override
  String get duration => 'Ilgums';

  @override
  String get gameScreenRecorder => 'Spēles ekrāna ierakstītājs';

  @override
  String get previous => 'Iepriekšējais';

  @override
  String get next => 'Nākamais';

  @override
  String get skip => 'Izlaist';

  @override
  String get gotIt => 'Sapratu';

  @override
  String get youCanModifyRules =>
      'Noteikumu iestatījumos varat mainīt spēles noteikumus.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Varat izmantot peles ritenīti, lai mainītu atlasītāja vērtību.';

  @override
  String get noTimeLimitForThinking =>
      'AI Domāšanas laiks, kas iestatīts uz 0, nozīmē, ka domāšanai nav laika ierobežojumu.';

  @override
  String get whatIsMtdf =>
      'MTD(f) ir alfa-beta meklēšanas algoritma modificēts veids, kura mērķis ir uzlabot efektivitāti, atkārtoti izmantojot starpposma meklēšanas rezultātus un izmantojot labu sākotnējo minējumu, lai sašaurinātu meklēšanas vietu.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Lūdzu, ņemiet vērā, ka AI domāšanas laika pielāgošana var nebūt pilnīgi precīza. Faktiskais domāšanas laiks var būt īsāks, ja grūtības līmenis ir iestatīts uz zemāku vērtību, un var būt garāks, ja AI ir vidējas domāšanas laiks, kad laiks beidzas.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Ja iestatāt augstu grūtības pakāpi, bet nepalielināt AI domāšanas laiku, domāšanas laika ierobežojuma dēļ faktiskais grūtības līmenis var būt ierobežots līdz zemākam. Faktiskā vērtība var atšķirties atkarībā no iekārtas veiktspējas.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) ir meklēšanas algoritms, lai atrastu labāko kustību noteiktā pozīcijā. Tas ir alfa-beta algoritma uzlabojums un izmanto nulles vai nulles logu meklēšanu, lai apstiprinātu, ka kustība ir sliktāka vai nav sliktāka par jau drošu rezultātu no galvenās variācijas. PVS koncentrējas uz daudzsološākajiem gājieniem un izvairās no nevajadzīgas suboptimālo zaru meklēšanas, kas palīdz uzlabot meklēšanas efektivitāti.';

  @override
  String get whatIsAlphaBeta =>
      'Alfa-beta algoritms ir meklēšanas algoritms, lai atrastu labāko kustību. Tas izmanto minimax principu un divas vērtības — alfa un beta, lai apgrieztu meklēšanas koku un palielinātu efektivitāti. Alfa ir minimālais rezultāts, par kuru dators ir pārliecināts, ka tas var iegūt, bet beta ir maksimālais rezultāts, ko var iegūt pretinieks. Algoritms palīdz datoram pieņemt gudrus un efektīvus lēmumus spēlē.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Saskaņā ar cilvēku pieredzi, ja jūs mēģināt uzvarēt, jūs zaudējat. Tā vietā tiecieties uz neizšķirtu kā savu mērķi un izvairieties zaudēt spēli. Vērojiet pretinieku un viegli ieviliniet viņu tādā stāvoklī, kurā viņi var kļūdīties. Kad viņi izrāda vājumu, izmantojiet iespēju un maigi spiediet uz uzvaru. Tādā veidā jūs varat uzvarēt spēli.';

  @override
  String get firstMoveDetail =>
      'Šajā spēlē otrajam spēlētājam ir vieglāk uzvarēt, salīdzinot ar pirmo spēlētāju.';

  @override
  String get passiveDetail =>
      'Pasīvās opcijas iespējošana liks AI atslābt, kad tam ir priekšrocības attiecīgajā pozīcijā, nevis agresīvi mēģināt uzvarēt pēc iespējas ātrāk.';

  @override
  String get moveRandomlyDetail =>
      'Šīs opcijas iespējošana palielina spēles nejaušību un jautrību, savukārt tās atspējošana var palīdzēt izpētīt veidus, kā pārspēt AI.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Ja mākslīgais intelekts ņem vērā savu figūru mobilitāti, tā mērķis būs ne tikai pēc iespējas ātrāk notvert pretinieka figūras, bet arī apsvērt iespēju bloķēt pretinieka kustības un neļaut viņiem darīt to pašu.';

  @override
  String get whenBoardIsFull => 'Kad dēlis ir pilns';

  @override
  String get whenBoardIsFull_Detail =>
      'Izvietošanas fāzes beigās, pirms pārvietošanās fāzes sākuma, darbība seko, ja dēlis ir pilns ar figūrām.';

  @override
  String get sideToMoveRemovePiece =>
      'Spēlētājs, kurš kustības fāzē kustas pirmais, noņem vienu no pretinieka figūrām.';

  @override
  String get agreeToDraw => 'Abas puses vienojas par neizšķirtu.';

  @override
  String get takeOpponentsPiece => 'Paņemiet vienu no pretinieka figūrām.';

  @override
  String get firstPlayerLose => 'Pirmais spēlētājs zaudē spēli.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Pirmais un otrais spēlētājs noņem vienu no pretinieka figūrām.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Otrais un pirmais spēlētājs noņem vienu no pretinieka figūrām.';

  @override
  String get enteredFlyingPhase =>
      'Tagad iegājis lidošanas fāzē, pretinieka figūras var pārlēkt uz jebkuru tukšu punktu uz galda. Lidošanas kārtulu varat izslēgt sadaļā \"Noteikumu iestatījumi\".';

  @override
  String get whenStalemate => 'Kad strupceļš';

  @override
  String get whenStalemate_Detail =>
      'Kāda darbība notiek, ja nevienu gabalu nevar pārvietot?';

  @override
  String get endWithStalemateLoss => 'Beidziet ar strupceļa zaudējumu.';

  @override
  String get changeSideToMove => 'Mainiet pusi, lai pārvietotos.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Noņemiet vienu no pretinieka figūrām un veiciet nākamo gājienu.';

  @override
  String get endWithStalemateDraw => 'Beidziet ar strupceļa neizšķirtu.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Noņemiet vienu no pretinieka figūrām un mainiet pusi, lai pārvietotos.';

  @override
  String get aiResponseDelayTime => 'AI reakcijas aizkaves laiks';

  @override
  String get aiIsDelaying =>
      'AI pašlaik ir aizkavētas reakcijas fāzē. Pirms turpināt, lūdzu, uzgaidiet kādu laiku.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Jūs nevarat noņemt blakus esošo gabalu.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'Ja ir strupceļš, pretinieka figūras, kas atrodas blakus jums, var tikt noņemtas neatkarīgi no dzirnavu veidošanās.';

  @override
  String get whatIsMcts =>
      'MCTS ir iesācējiem draudzīgs algoritms, kas pieņem lēmumus, pētot un novērtējot dažādas kustības, izmantojot simulācijas.';

  @override
  String get goldenJade => 'Zelta skuķis';

  @override
  String get forestWood => 'Meža koksne';

  @override
  String get darkMystery => 'Tumšais noslēpums';

  @override
  String get midnightBlue => 'Pusnakts zila';

  @override
  String get greenForest => 'Zaļais mežs';

  @override
  String get greenMeadow => 'Zaļā pļava';

  @override
  String get stonyPath => 'Akmeņains ceļš';

  @override
  String get pastelPink => 'Pastels rozā';

  @override
  String get turquoiseSea => 'Tirkīza jūra';

  @override
  String get violetDream => 'Violetais sapnis';

  @override
  String get mintChocolate => 'Piparmētru šokolāde';

  @override
  String get skyBlue => 'Debesu zils';

  @override
  String get playfulGarden => 'Rotaļīgs dārzs';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Retrogrādās analīzes algoritms izmanto daudzvērtīgu retrogrādo analīzi, lai izveidotu beigu datu bāzi no dažādām sākuma pozīcijām, un pēc tam izmanto šo datu bāzi, lai optimizētu spēli. Šī pieeja ietilpst īpaši spēcīgu risinājumu kategorijā.';

  @override
  String get viewAlgorithmGuide =>
      'Vai vēlaties skatīt šī algoritma lietotāja rokasgrāmatu?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Rādīt pozīcijas priekšrocības indikatoru';

  @override
  String get usePerfectDatabase => 'Izmantojiet perfektu datu bāzi';

  @override
  String get perfectDatabaseDescription =>
      'Iespējojiet šo opciju, lai izmantotu nevainojamu spēļu datu bāzi, kas izveidota, izmantojot progresīvus algoritmus. Šī funkcija apvieno gan spēles sākuma, gan beigu stratēģijas, lai ieteiktu optimālas kustības. Šī ir vēlamā izvēle spēlētājiem, kuri meklē visaugstāko spēles precizitātes līmeni. Datubāze, kas izveidota, izmantojot rūpīgas skaitļošanas metodes, ir izstrādāta, lai piedāvātu gandrīz ideālus spēļu risinājumus.\n\nPiezīme. Ja mākslīgais intelekts nevar piekļūt datu bāzei, tas izmantos parastos algoritmus, lai pieņemtu lēmumus par spēli. Kad datu bāze ir pieejama, “Grūtības līmenis” kļūst praktiski nepārspējams, un “AI domāšanas laiks” krasi samazinās. Daudzi iestatījumi \'AI\'s play style\' opcijās tiks ignorēti, jo datu bāzes rezultātiem ir visaugstākā prioritāte.\n\nLai iegūtu norādījumus par to, kā maksimāli izmantot šo nevainojamo datubāzi, noklikšķiniet šeit.';

  @override
  String get backgroundImage => 'Fona attēls';

  @override
  String get whatIsRandom =>
      'Ja opcija “Izmantot perfektu datu bāzi” nav iespējota, iestatījums “Nejaušs” liek AI nejauši pārvietot gabalus, neizmantojot pārvietošanas atlases algoritmus. Tas parasti rada ievērojami vājāku spēli. Un otrādi, ja ir iespējota opcija “Izmantot perfektu datu bāzi”, AI lēmumu pieņemšanā paļaujas tikai uz ideālo datu bāzi, nevis sajauc to ar tradicionālajiem AI algoritmiem. Šajā režīmā AI darbības ir pilnībā balstītas uz datu bāzes saturu, izvairoties no paļaušanās uz reāllaika aprēķiniem vai meklēšanas algoritmiem.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Noņem pretinieka figūru(-as) no rokas; tad pretinieka gājiens novietot.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Veidojot dzirnavas izvietošanas fāzes laikā';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Noņem pretinieka figūru(-as) no galda.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Noņem pretinieka figūru(-as) no galda; tad pretinieka gājiens novietot figūru.';

  @override
  String get opponentRemovesOwnPiece =>
      'Pretinieks noņem no galda pats savu figūru(-as).';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Tavā gājiena vietā pretinieks izvēlas un noņem no galda pats savu figūru (-as), faktiski veicot sev kaitīgu darbību.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Noņem pretinieka figūru(-as) no viņa rokas; tad ir tavs gājiens.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Noņem figūru(-as) no pretinieka rokas. Ja saskaņā ar iestatījumu “Vairāku figūru noņemšana” ir jānoņem vairākas figūras un pretiniekam rokā vairs nav figūru, turpini noņemt pretinieka figūras no galda. Pēc tam ir tavs gājiens. Ja turpini veidot dzirnavas, tu vari turpināt noņemt pretinieka figūras.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Noņem figūru(-as) no pretinieka rokas. Ja saskaņā ar iestatījumu “Vairāku figūru noņemšana” ir jānoņem vairākas figūras un pretiniekam rokā vairs nav figūru, turpini noņemt pretinieka figūras no galda. Pēc tam ir pretinieka gājiens.';

  @override
  String get markAndDelayRemovingPieces =>
      'Atzīmēt un aizkavēt figūru noņemšanu.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Izvietošanas fāzes laikā noņemamās figūras tiek atzīmētas, un abi spēlētāji nevar novietot jaunas figūras uz šiem punktiem. Sākoties kustību fāzei, šīs atzīmētās figūras tiek noņemtas visas uzreiz, un spēlētāji pēc tam var pārvietot savas figūras uz šiem tagad tukšajiem punktiem.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Darbības, kas veicamas, veidojot dzirnavas izvietošanas posmā.';

  @override
  String get marked => 'Označeno';

  @override
  String get menu => 'Izvēlne';

  @override
  String get monochrome => 'Monohroms';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Jūs varat iespējot ekrāna lasītāja atbalstu pieejamības iestatījumos Vispārīgajos iestatījumos.';

  @override
  String get showNumbersOnPieces => 'Rādīt numurus uz figūrām';

  @override
  String get saveImage => 'Saglabāt attēlu';

  @override
  String get isAnalysisToolbarShown => 'Parādīt analīzes rīkjoslu';

  @override
  String get analysisToolbarBackgroundColor => 'Analīzes rīkjoslas fona krāsa';

  @override
  String get analysisToolbarIconColor => 'Analīzes rīkjoslas ikonas krāsa';

  @override
  String get transformed => 'Transformēts.';

  @override
  String get cannotTransform => 'Nevar pārveidot.';

  @override
  String get rotate => 'Pagriezt';

  @override
  String get horizontalFlip => 'H Apgriezt';

  @override
  String get verticalFlip => 'V Apgriezt';

  @override
  String get innerOuterFlip => 'IO Apgriezt';

  @override
  String get transparentCanvas => 'Caurspīdīgs Audekls';

  @override
  String get restrictRepeatedMillsFormation =>
      'Ierobežot atkārtotu dzirnaviņu veidošanos';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Figūra, kas pārvietota no viena dzirnavām uz citām, nevar nekavējoties atgriezties sākotnējā punktā nākamajā gājienā, lai atkal veidotu dzirnavas. Vispirms ir nepieciešams cits gājiens.';

  @override
  String get oneTimeUseMill => 'Vienreiz lietojama dzirnavas';

  @override
  String get oneTimeUseMill_Detail =>
      'Katra dzirnava var noņemt tikai vienu pretinieka gabalu. Jūs varat to atkārtoti izveidot, bet to nevar izmantot papildu noņemšanai.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Pašreizējiem noteikumiem, ko esat iestatījis, nav atbilstošas ideālās datubāzes. Lai iegūtu vairāk informācijas par ideālo datubāzi, lūdzu, noklikšķiniet šeit.';

  @override
  String get focusOnBlockingPaths => 'Koncentrējieties uz ceļu bloķēšanu';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Prioritizējiet pretinieka kustību bloķēšanu, nevis dzirnavu veidošanu. Tā vietā, lai koncentrētos uz figūru noņemšanu, pabeidzot dzirnavas, AI cenšas ieslodzīt pretinieku, padarot viņu nespējīgu kustēties un nodrošinot uzvaru ar izturību, nevis agresīvu spēli. Šī stratēģija aktīvi nebloķē pretinieka dzirnavas.';

  @override
  String get pieceImage => 'Figūras attēls';

  @override
  String get importColorSettings => 'Importēt krāsu iestatījumus';

  @override
  String get exportColorSettings => 'Eksportēt krāsu iestatījumus';

  @override
  String get import => 'Importēt';

  @override
  String get export => 'Eksportēt';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Lūdzu, vispirms nokopējiet JSON formāta iestatījumus starpliktuvē.';

  @override
  String get copiedToClipboard => 'Nokopēts starpliktuvē.';

  @override
  String get imported => 'Importēts.';

  @override
  String get boardImage => 'Dēļa attēls';

  @override
  String get autumnLeaves => 'Rudens lapas';

  @override
  String get legendaryLand => 'Leģendārā zeme';

  @override
  String get vignetteEffect => 'Vinjete efekts';

  @override
  String get promptMakeToolbarTransparent =>
      'Vai vēlaties padarīt rīku jos pilnīgi caurspīdīgu, kad ir iestatīta dēļa fona attēls?';

  @override
  String get vibration => 'Iespējot vibrāciju spēlē';

  @override
  String get soundTheme => 'Skaņas tēma';

  @override
  String get ball => 'Bumba';

  @override
  String get liquid => 'Šķidrums';

  @override
  String get wood => 'Koks';

  @override
  String get placeEffectAnimation => 'Figūras novietošanas animācijas efekts';

  @override
  String get removeEffectAnimation => 'Figūras noņemšanas animācijas efekts';

  @override
  String get isToolbarAtBottom => 'Rādīt rīkjoslu apakšā';

  @override
  String get boardCornerRadius => 'Dēļa stūra rādiuss';

  @override
  String get useOpeningBook => 'Izmantojiet atvēršanas grāmatu';

  @override
  String get currentRule => 'Pašreizējais';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Noteikumu kopa';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'One-Time Mill';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'Ļaujiet AI izmantot atklāšanas gājienus, ko bieži izmanto profesionālie cilvēku spēlētāji spēles sākumā. Piezīme: Šī funkcija pašlaik ir pieejama tikai konkrētiem noteikumu kopumiem.';

  @override
  String get showAdvantageGraph => 'Parādīt priekšrocību grafiku';

  @override
  String get advantageGraphHint =>
      'Priekšrocību grafiks tiks uzzīmēts tikai pēc tam, kad MI veiks gājienu. Tas netiks uzzīmēts, kad gājienu veiks cilvēka spēlētājs.';

  @override
  String get removalBasedOnMillCounts =>
      'Atspējot noņemšanu, līdz visas figūras ir novietotas. Spēlētāji noņem figūras, pamatojoties uz to dzirnavu skaitu.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Atspējot noņemšanu, līdz visas figūras ir novietotas. Spēlētāji noņem figūras, pamatojoties uz dzirnavu skaitu: ja skaits ir vienāds, abi noņem vienādu skaitu figūru; ja vienam ir vairāk, tas noņem vienu papildu figūru, saglabājot starpību vienas figūras apjomā. Ja tikai viens spēlētājs izveido dzirnavas, viņš noņem divas figūras, bet otrs noņem vienu. Ja neviens neizveido dzirnavas, abi noņem pa vienai figūrai.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Izvēlies vienu no savām figūrām.';

  @override
  String get notYourTurn => 'Nav tava kārta.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Piezīmju rīkjoslas fona krāsa';

  @override
  String get annotationToolbarIconColor => 'Piezīmju rīkjoslas ikonu krāsa';

  @override
  String get isAnnotationToolbarShown => 'Rādīt piezīmju rīkjoslu';

  @override
  String get enterAnnotationMode => 'Ieeiet piezīmju režīmā';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Vai tiešām vēlaties notīrīt visas piezīmes?';

  @override
  String get llmPromptCopiedToClipboard => 'LLM uzvedne nokopēta starpliktuvē.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Savienojums noraidīts, serveris var būt izslēgts.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Atklāšana veiksmīga, gaida savienojumu...';

  @override
  String get noLanConnection => 'Nav LAN savienojuma';

  @override
  String get takeScreenshot => 'Uzņem ekrānuzņēmumu';

  @override
  String get disconnectedFromOpponent => 'Atvienots no pretinieka.';

  @override
  String get takeBackRequest => 'Atkāpšanās pieprasījums';

  @override
  String get nothingToShow => 'Nav ko parādīt.';

  @override
  String get stopHosting => 'Pārtraukt spēles vadīšanu';

  @override
  String get connectionResetByPeer => 'Savienojumu atiestatīja pretējā puse.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Savienojums zaudēts sirdsdarbības laika pārsniegšanas dēļ. Lūdzu, atjaunojiet savienojumu.';

  @override
  String get startHosting => 'Sākt spēles vadīšanu';

  @override
  String get restartRequestRejected => 'Pārstartēšanas pieprasījums noraidīts.';

  @override
  String get notConnectedToLanOpponent => 'Nav savienojuma ar LAN pretinieku.';

  @override
  String get llmPrompt => 'LLM uzvedne';

  @override
  String get gameRestarted => 'Spēle restartēta.';

  @override
  String get takeBackRejected => 'Atkāpšanās noraidīta.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Vai tiešām vēlaties padoties no šīs spēles?';

  @override
  String get opponentResignedYouWin => 'Pretinieks ir padojies. Jūs uzvarējāt!';

  @override
  String get clearAllAnnotations => 'Notīrīt visas piezīmes';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Savienots, gaida pretinieka gājienu...';

  @override
  String get networkStatusDisconnected => 'Tīkla statuss: Atvienots';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Atkāpšanās pieprasījums nosūtīts pretiniekam.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'Pretinieks varbūt ir atstājis spēli';

  @override
  String get connectedToHostSuccessfully =>
      'Veiksmīgi savienots ar spēles vadītāju.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Savienojums zaudēts: sirdsdarbības laika pārsniegšana';

  @override
  String get noHostDiscovered => 'Nav atrasts spēles vadītājs.';

  @override
  String get confirmResignation => 'Apstiprināt padīšanos';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Spēles rīkošana uzsākta, gaida spēlētāju pievienošanos...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Savienojuma laiks beidzies, tīkla savienojums ir nestabils.';

  @override
  String get noLlmPromptAvailable => 'Nav pieejama LLM uzvedne.';

  @override
  String get youResignedGameOver => 'Jūs padojāties. Spēle beigusies.';

  @override
  String get serverIp => 'Servera IP';

  @override
  String get confirmClear => 'Apstiprināt notīrīšanu';

  @override
  String get opponentSTurn => 'Pretinieka kārta.';

  @override
  String get waitingAClientConnection => 'Gaida klienta savienojumu...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Atkāpšanās pieprasījums tika noraidīts vai neizdevās.';

  @override
  String get addText => 'Pievienot tekstu';

  @override
  String get exitAnnotationMode => 'Iziet no piezīmju režīma';

  @override
  String get typeYourAnnotation => 'Ierakstiet savu piezīmi';

  @override
  String get attemptingToReconnect => 'Mēģina atjaunot savienojumu...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Pārstartēšanas pieprasījums nosūtīts. Gaida pretinieka atbildi...';

  @override
  String get serverIsStopped => 'Serveris ir apturēts.';

  @override
  String get restartRequest => 'Pārstartēšanas pieprasījums';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Nevar pieprasīt atkāpšanos, kad nav tava kārta.';

  @override
  String get takeBackAccepted => 'Atkāpšanās pieņemta.';

  @override
  String get localNetworkSettings => 'Vietējās tīkla iestatījumi';

  @override
  String get reconnectedSuccessfully => 'Savienojums veiksmīgi atjaunots!';

  @override
  String get failedToSaveImageToGallery =>
      'Neizdevās saglabāt attēlu galerijā.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Pretinieks pieprasīja spēles pārstartēšanu. Vai piekrītat?';

  @override
  String get yourTurn => 'Tava kārta.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Nevar atjaunot savienojumu, lūdzu, restartējiet spēli.';

  @override
  String get host => 'Spēles vadītājs';

  @override
  String get join => 'Pievienoties';

  @override
  String get port => 'Ports';

  @override
  String get invalidIpAddress => 'Nederīga IP adrese.';

  @override
  String get invalidPort => 'Nederīgs ports.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Savienojamies: Mēģinājums $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Neizdevās savienoties: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Neizdevās uzsākt spēles vadīšanu: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Spēles vadītājs atrasts: $ip:$port';
  }

  @override
  String get stop => 'Apturēt';

  @override
  String get discover => 'Atklāt';

  @override
  String get connect => 'Savienoties';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Klients pievienojies: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Meklē: $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Atjaunojam savienojumu ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Savienots';

  @override
  String get delete => 'Dzēst';

  @override
  String get ancientEgypt => 'Senā Ēģipte';

  @override
  String get gothicIce => 'Gotiskais Ledus';

  @override
  String get riceField => 'Rīsu Lauks';

  @override
  String get chinesePorcelain => 'Ķīnas Porcelāns';

  @override
  String get desertDusk => 'Tuksneša Krēsla';

  @override
  String get precisionCraft => 'Precīza Amatniecība';

  @override
  String get folkEmbroidery => 'Tautas Izšuvumi';

  @override
  String get carpathianHeritage => 'Karpatu Mantojums';

  @override
  String get imperialGrandeur => 'Impērijas Diženumu';

  @override
  String get bohemianCrystal => 'Bohēmijas Kristāls';

  @override
  String get savannaSunrise => 'Savannas Saullēkts';

  @override
  String get harmonyBalance => 'Harmonija un Līdzsvars';

  @override
  String get cinnamonSpice => 'Kanēļa Garšviela';

  @override
  String get anatolianMosaic => 'Anatolijas Mozaīka';

  @override
  String get carnivalSpirit => 'Karnevāla Gars';

  @override
  String get custom => 'Pasūtījuma';

  @override
  String get spiceMarket => 'Garšvielu tirgus';

  @override
  String get swipeToRevealTheDrawer => 'Pavelciet, lai atvērtu atvilktni';

  @override
  String get showGameInfoOnScreenshots =>
      'Rādīt spēles informāciju ekrānuzņēmumos';

  @override
  String get humanMoveTime => 'Cilvēka laika limits';

  @override
  String get noTimeLimitForHumanMoves =>
      'Cilvēka gājieniem nav laika ierobežojuma';

  @override
  String get timeoutLoseWillBeApplied =>
      'Cilvēka spēlētājam tiks piemērots zaudējums laika limita pārsniegšanas dēļ';

  @override
  String get identifyingBoard => 'Spēles dēļa identificēšana…';

  @override
  String get youCanEnterAnyModelName =>
      'Jūs varat ievadīt jebkuru modeļa nosaukumu.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Spēles dēļa pozīcija pielietota. FEN nokopēts starpliktuvē.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Ieteikums: mēģiniet nofotografēt dēli skaidrāk.';

  @override
  String get llmPromptTemplate => 'LLM prompt veidne';

  @override
  String get noValidBoardDetected => 'Nederīgs spēles dēlis netika atrasts.';

  @override
  String get selectingImageFromAlbum => 'Attēla atlase no albuma…';

  @override
  String get configurePromptTemplate => 'Konfigurēt prompt veidni';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Rediģēt prompt veidni LLM analīzei';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Neizdevās ģenerēt FEN no atpazītā dēļa.';

  @override
  String get outputInCurrentLanguage => 'Izvade pašreizējā valodā';

  @override
  String get commonBaseUrls => 'Bieži izmantotie Base URL';

  @override
  String get viewCommonModels => 'Skatīt bieži izmantotos modeļus';

  @override
  String get recognitionParametersUpdated =>
      'Atpazīšanas parametri atjaunināti.';

  @override
  String get whiteSMove => 'Baltā gājiens';

  @override
  String get resetToDefaults => 'Atiestatīt pēc noklusējuma';

  @override
  String get photoShoot => 'Fotografēšana';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Neizdevās lietot atpazīto dēļa pozīciju.';

  @override
  String get llmPromptContent => 'LLM prompt saturs';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM nav konfigurēts. Lūdzu, pārbaudiet iestatījumus.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Iestatīt pakalpojumu sniedzēju, modeli, API Key un Base URL';

  @override
  String get llmConfiguration => 'LLM konfigurācija';

  @override
  String get configureLlmProvider => 'Konfigurēt LLM pakalpojumu sniedzēju';

  @override
  String get llmPromptTemplateHeader => 'LLM prompt veidnes galvene';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Attēlā netika atpazītas nevienas figūras. Lūdzu, mēģiniet vēlreiz.';

  @override
  String get recognizeBoardFromImage => 'Atpazīt dēli no attēla';

  @override
  String get viewTips => 'Skatīt padomus';

  @override
  String get applyToBoard => 'Lietot uz dēļa';

  @override
  String get adjustBoardArea => 'Regulēt dēļa laukumu';

  @override
  String get viewCommonUrls => 'Skatīt bieži izmantotos URL';

  @override
  String get colorAnalysisFailed => 'Krāsu analīze neizdevās!';

  @override
  String get analyzingGameBoardImage => 'Analizējam spēles dēļa attēlu…';

  @override
  String get selectFromAlbum => 'Izvēlēties no albuma';

  @override
  String get noBoardPointDetected => 'Dēļa punkts netika noteikts!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Ja atstāts tukšs, tiks izmantota noklusējuma veidne';

  @override
  String get llmConfig => 'LLM konfigurācija';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Vai tiešām vēlaties atiestatīt prompt veidnes uz noklusējuma vērtībām?';

  @override
  String get llmPromptTemplateFooter => 'LLM prompt veidnes kājene';

  @override
  String get loadingResponse => 'Ielādē atbildi…';

  @override
  String get applyThisResultToBoard => 'Lietot šo rezultātu uz dēļa';

  @override
  String get takingPicture => 'Fotografē…';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Lūdzu, izvēlieties spēles dēļa attēlu atpazīšanai';

  @override
  String get identificationResults => 'Identifikācijas rezultāti';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Analizēt gājienus un sniegt ieskatus.';

  @override
  String get getApiKey => 'Iegūt API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Viss atpazīšanas process neizdevās pabeigt.';

  @override
  String get boardRecognitionResult => 'Dēļa atpazīšanas rezultāts';

  @override
  String get askLlm => 'Jautāt LLM';

  @override
  String get boardDetectionFailed => 'Dēļa noteikšana neizdevās!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Dēļa punkti netika noteikti, figūru nevar atpazīt!';

  @override
  String get copyFen => 'Kopēt FEN';

  @override
  String get commonlyUsedModels => 'Bieži izmantotie modeļi';

  @override
  String get apiKeyOptional => 'API Key (pēc izvēles)';

  @override
  String get noImageSelected => 'Nav izvēlēts attēls';

  @override
  String get blackSMove => 'Melnā gājiens';

  @override
  String get llm => 'Liels valodas modelis';

  @override
  String get llmProvider => 'Piegādātājs';

  @override
  String get baseUrl => 'Bāzes URL';

  @override
  String get model => 'Modelis';

  @override
  String get temperature => 'Temperatūra';

  @override
  String get llmCommandReceivedProcessing => 'Komanda saņemta! AI apstrādā...';

  @override
  String get llmDeepThinkingWait =>
      'Notiek dziļa domāšana, lūdzu, uzgaidiet...';

  @override
  String get llmPresentingSoon => 'Drīzumā tiks prezentēts...';

  @override
  String get recognitionParameters => 'Atpazīšanas parametri';

  @override
  String get adjustParamsDesc =>
      'Pielāgojiet parametrus, lai uzlabotu atpazīšanas precizitāti';

  @override
  String get saveParameters => 'Saglabāt parametrus';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Nevar sākt attēla atpazīšanu: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Attēla atpazīšana neizdevās: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Pielietota pozīcija ar $whiteCount baltām un $blackCount melnām figūrām';
  }

  @override
  String get fenCopiedToClipboard => '(FEN nokopēts uz starpliktuvi)';

  @override
  String recognitionFailed(String error) {
    return 'Atpazīšana neizdevās: $error';
  }

  @override
  String get myRating => 'Mans vērtējums';

  @override
  String get gamesPlayed => 'Spēlētās spēles';

  @override
  String get wins => 'Uzvaras';

  @override
  String get losses => 'Zaudējumi';

  @override
  String get draws => 'Neizšķirti';

  @override
  String get lastUpdated => 'Pēdējo reizi atjaunināts';

  @override
  String get format => 'Formāts:';

  @override
  String get resetStatistics => 'Atiestatīt statistiku';

  @override
  String get drawRate => 'Neizšķirtu īpatsvars';

  @override
  String get lossRate => 'Zaudējumu īpatsvars';

  @override
  String get aiStatistics => 'MI statistika';

  @override
  String get enableStatistics => 'Iespējot statistiku';

  @override
  String get enableStatistics_Detail =>
      'Kad iespējots, spēļu rezultāti tiks reģistrēti statistikā. Tomēr spēles, kas ietver gājienu atcelšanu, netiks reģistrētas. Kad atspējots, statistikas vākšana tiek apturēta.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Tiks atiestatīta visa spēļu statistika. Šo darbību nevar atsaukt.';

  @override
  String get boardInnerRingSize => 'Dēļa iekšējā gredzena izmērs';

  @override
  String get boardShadowEnabled => 'Dēļa ēna';

  @override
  String get trapAwareness => 'Slazdu noteikšana';

  @override
  String get trapAwarenessDescription =>
      'Analīzes laikā izcel slazdu gājienus ar trekniem apļiem un bultām.';

  @override
  String trapExists(String trapMoves) {
    return 'Pastāv slazds. Slazdu gājieni: $trapMoves';
  }

  @override
  String get custodianCapture => 'Sānu tveršana';

  @override
  String get custodianCaptureDescription =>
      'Ievietojiet vienu no pretinieka gabaliem starp diviem jūsu taisnā līnijā, lai to uztvertu.';

  @override
  String get custodianCaptureEnable => 'Ļaujiet sānu uztveršanu';

  @override
  String get interventionCapture => 'Iejaukšanās';

  @override
  String get interventionCaptureDescription =>
      'Pārvietojieties tukšā punktā starp diviem pretinieka gabaliem, lai tos abus uztvertu.';

  @override
  String get interventionCaptureEnable => 'Ļaujiet uztvert intervenci';

  @override
  String get leapCapture => 'Lēciena uztveršana';

  @override
  String get leapCaptureDescription =>
      'Uztveriet, pārlecot virs blakus esošā pretinieka gabala tukšajā punktā ārpus tā.';

  @override
  String get leapCaptureEnable => 'Ļaujiet lēciena uztveršanai';

  @override
  String get captureApplicableLines => 'Piemērojamās līnijas';

  @override
  String get captureSquareEdges => 'Gar laukuma malām';

  @override
  String get captureCrossLines =>
      'Gar ortogonālām līnijām, kas šķērso kvadrātu';

  @override
  String get captureDiagonalLines =>
      'Gar diagonālām līnijām, kas šķērso kvadrātu';

  @override
  String get captureExecutionPhases => 'Izpildes posmi';

  @override
  String get capturePiecesCondition =>
      'Pieejamība kustīgajā fāzē, pamatojoties uz atlikušajiem gabaliem';

  @override
  String get capturePiecesConditionUnlimited => 'Nav ierobežojuma';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Pieejams, kad jums ir trīs vai mazāk';
}
