// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Lithuanian (`lt`).
class SLt extends S {
  SLt([String locale = 'lt']) : super(locale);

  @override
  String get appName => 'Malūnas';

  @override
  String get welcome => 'Sveiki atvykę';

  @override
  String get yes => 'Taip';

  @override
  String get no => 'Ne';

  @override
  String get game => 'Žaidimas';

  @override
  String get humanVsAi => 'Žmogus vs. AI';

  @override
  String get humanVsHuman => 'Žmogus prieš žmogų';

  @override
  String get aiVsAi => 'AI prieš AI';

  @override
  String get humanVsCloud => 'Žmogus prieš debesį';

  @override
  String get humanVsLAN => 'Žmogus prieš LAN';

  @override
  String get testViaLAN => 'Bandymas per LAN';

  @override
  String get move => 'Perkelti';

  @override
  String get showMoveList => 'Judesių sąrašas';

  @override
  String get moveList => 'Judesių sąrašas';

  @override
  String get noGameRecord => 'Nėra įrašo';

  @override
  String get ok => 'GERAI';

  @override
  String get confirm => 'Patvirtinti';

  @override
  String get cancel => 'Atšaukti';

  @override
  String get tipSelectWrong => 'Pasirinktas netinkamas elementas.';

  @override
  String get tipPlace => 'Padėkite savo dalis.';

  @override
  String get tipBanPlace => 'Čia negalima įdėti.';

  @override
  String get tipPlaced => 'Jūs įdėjote.';

  @override
  String get tipRemove => 'Pašalinkite figūrėlę.';

  @override
  String get tipBanRemove => 'Jūs negalite jos pašalinti.';

  @override
  String get tipRemoved => 'Jūs pašalinote.';

  @override
  String get tipMove => 'Perkelkite figūrėlę.';

  @override
  String get tipCannotPlace => 'Jūs negalite čia padėti figūrėlės.';

  @override
  String get tipCannotMove => 'Jūs negalite perkelti savo figūrėlės čia.';

  @override
  String get tipMill => 'Malūnas! Paimkite priešininko figūrėlę.';

  @override
  String get tipContinueMill => 'Toliau imkite priešininko figūrą.';

  @override
  String get tipSelectOpponentsPiece =>
      'Pasirinkite vieną iš priešininko figūrų.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Negalite paimti figūros iš malūno.';

  @override
  String get tipCanMoveOnePoint => 'Figūra gali judėti 1 tašku.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Negalite judinti priešininko figūrų.';

  @override
  String get tipSelectPieceToMove =>
      'Pasirinkite figūrėlę, kurią norite perkelti.';

  @override
  String get tipHaveThreePiecesLeft => 'Jums liko trys figūrėlės.';

  @override
  String get tipCanMoveToAnyPoint => 'Galite judėti į bet kurį norimą tašką.';

  @override
  String tipToMove(Object player) {
    return '$player, kad judėtumėte.';
  }

  @override
  String get whiteWin => 'Laimi 1 žaidėjas!';

  @override
  String get blackWin => 'Laimi 2 žaidėjas!';

  @override
  String get won => 'Laimėjo';

  @override
  String get lost => 'Pralaimėta';

  @override
  String get thinking => 'Galvoju…';

  @override
  String get newGame => 'Naujas žaidimas';

  @override
  String get importGame => 'Importuoti žaidimą';

  @override
  String get exportGame => 'Eksportuoti žaidimą';

  @override
  String get gameImported => 'Žaidimas importuotas.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Negalima importuoti $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'Judesiai ir taisyklės nesutampa.';

  @override
  String get pleaseWait => 'Palaukite.';

  @override
  String get restartGame => 'Iš naujo paleisti dabartinį žaidimą?';

  @override
  String get restart => 'Iš naujo paleisti';

  @override
  String get gameStarted => 'Žaidimas pradėtas, padėkite.';

  @override
  String get analyzing => 'Analizuojant…';

  @override
  String error(Object message) {
    return 'Klaida: $message';
  }

  @override
  String get winRate => 'Laimėjimo rodiklis';

  @override
  String get score => 'Rezultatas:';

  @override
  String get white => '1 žaidėjas';

  @override
  String get black => '2 žaidėjas';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player vienetų skaičius yra mažesnis nei trys.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player atsistatydino.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player nebėra kelio.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Lenta pilna, o $player nebėra kelio.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Laikas baigėsi, $player prarastas.';
  }

  @override
  String get drawReasonRule50 =>
      'Judėjimo fazėje per paskutinį tam tikrą ėjimų skaičių nebuvo pašalinta nė viena figūra.';

  @override
  String get drawReasonBoardIsFull => 'Tai yra lygiosios, nes lenta yra pilna.';

  @override
  String get drawReasonThreefoldRepetition =>
      'Tai yra lygiosios, nes kartojasi triskart.';

  @override
  String get gameOverUnknownReason => 'Žaidimas baigtas! Nežinoma priežastis.';

  @override
  String get gameOver => 'Žaidimas baigtas';

  @override
  String get youWin => 'Jūs laimėjote! Sveikiname!';

  @override
  String challengeHarderLevel(int level) {
    return 'Iššūkis sunkesnis lygis? Naujas lygis bus $level lygis!';
  }

  @override
  String get youLose => 'Jūs pralaimėjote!';

  @override
  String get analyze => 'Analizuokite';

  @override
  String get about => 'Apie';

  @override
  String version(Object versionNumber) {
    return 'Versija: $versionNumber';
  }

  @override
  String get thanks => 'Ačiū';

  @override
  String get settings => 'Nustatymai';

  @override
  String get options => 'Parinktys';

  @override
  String get generalSettings => 'Bendrieji nustatymai';

  @override
  String get skillLevel => 'Sudėtingumo lygis';

  @override
  String get moveTime => 'AI mąstymo laikas';

  @override
  String get difficulty => 'Sudėtingumas';

  @override
  String get playSounds => 'Garso efektai';

  @override
  String get playSoundsInTheGame => 'Garsų atkūrimas žaidime';

  @override
  String get keepMuteWhenTakingBack =>
      'Išlaikykite garsą išjungtą, kai grįžtate atgal';

  @override
  String get tone => 'Tonas';

  @override
  String get whoMovesFirst => 'Pirmas ėjimas';

  @override
  String get human => 'Žmogus';

  @override
  String get ai => 'AI';

  @override
  String get alternate => 'Pakaitinis';

  @override
  String get isAutoRestart =>
      'Automatinis žaidimo paleidimas iš naujo, kai žaidimas baigiamas';

  @override
  String get isAutoChangeFirstMove => 'Automatinis pirmojo ėjimo keitimas';

  @override
  String get shufflingEnabled => 'Atsitiktinis ėjimas';

  @override
  String get misc => 'Įvairūs';

  @override
  String get rules => 'Taisyklės';

  @override
  String get piecesCount => 'Kiekvieno žaidėjo turimų figūrų skaičius';

  @override
  String get piecesCount_Detail => 'Kiek figūrų turi kiekvienas žaidėjas?';

  @override
  String get flyPieceCount => 'Skrendančios figūrėlės numeris';

  @override
  String get flyPieceCount_Detail =>
      'Jei įjungtas skraidančios figūrėlės režimas, kai žaidėjo figūrėlių skaičius sumažėja iki tam tikro skaičiaus, jo figūrėlės gali laisvai judėti į bet kurį laisvą tašką, o ne apsiriboti gretimais taškais, kaip likusioje žaidimo dalyje.';

  @override
  String get piecesAtLeastCount => 'Mažiausiai figūrų';

  @override
  String get hasDiagonalLines => 'Įstrižainės linijos';

  @override
  String get hasDiagonalLines_Detail =>
      'Pridėkite prie lentos keturias įstrižas linijas.';

  @override
  String get isDefenderMoveFirst => 'Antrasis žaidėjas juda pirmas';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Žaidėjas, kuris padėjimo fazėje juda antras, judėjimo fazėje juda pirmas.';

  @override
  String get mayRemoveMultiple => 'Daugkartinis perkėlimas';

  @override
  String get mayRemoveMultiple_Detail =>
      'Jei žaidėjas vienu metu uždaro daugiau nei vieną malūnėlį, jis pašalina tiek malūnėlių, kiek jų uždarė.';

  @override
  String get mayRemoveFromMillsAlways => 'Naikinti malūnus';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Pagal numatytuosius nustatymus, prieš pašalindami figūrą iš suformuoto malūno, žaidėjai pirmiausia turi pašalinti visas kitas figūras. Įjunkite šią parinktį, kad šis apribojimas būtų išjungtas.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Antrasis žaidėjas pralaimi, kai lenta yra pilna';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Kai dėjimo etapo pabaigoje lenta būna pilna, šalis, kuri deda pirma, pralaimi žaidimą. Priešingu atveju žaidimas laikomas lygiosiomis.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Pralaimi, kai nėra teisėtų ėjimų';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Žaidėjas pralaimi, jei jo priešininkas juos užblokuoja taip, kad jų negalima judinti. Pakeiskite pusę, kad galėtumėte judėti, jei ši parinktis išjungta.';

  @override
  String get mayFly => 'Skrenda';

  @override
  String get mayFly_Detail =>
      'Jei žaidėjui liko tik trys arba keturios (konfigūruojamos) figūrėlės, jis gali perkelti figūrėlę į bet kurį laisvą tašką.';

  @override
  String get nMoveRule => 'N ėjimų taisyklė';

  @override
  String get nMoveRule_Detail =>
      'Žaidimas sužaidžiamas lygiosiomis, jei per tam tikrą skaičių ėjimų kiekvienas žaidėjas nepašalino nė vienos figūros.';

  @override
  String get rollback => 'Atbulinis ėjimas';

  @override
  String get pleaseSelect => 'Pasirinkite';

  @override
  String get copy => 'Kopijuoti';

  @override
  String get moveHistoryCopied => 'Ėjimų istorija nukopijuojama į iškarpinę.';

  @override
  String get help => 'Pagalba';

  @override
  String get feedback => 'Atsiliepimai';

  @override
  String get exit => 'Išeiti iš';

  @override
  String get ruleSettings => 'Taisyklės';

  @override
  String get color => 'Spalva';

  @override
  String get boardColor => 'Lentos spalva';

  @override
  String get pieceColor => 'Figūrėlės spalva';

  @override
  String get backgroundColor => 'Fono spalva';

  @override
  String get lineColor => 'Lentos linijos spalva';

  @override
  String get whitePieceColor => 'Žaidėjo 1 figūrėlės spalva';

  @override
  String get blackPieceColor => 'Žaidėjo 2 figūrėlės spalva';

  @override
  String get messageColor => 'Pranešimo spalva';

  @override
  String get isPieceCountInHandShown => 'Rodyti turimų figūrų skaičių';

  @override
  String get isNotationsShown => 'Rodyti užrašus ant lentos';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Rodyti istorijos naršymo įrankių juostą';

  @override
  String get display => 'Rodyti';

  @override
  String get boardBorderLineWidth => 'Lentos ribų plotis';

  @override
  String get boardInnerLineWidth => 'Lentos vidinės linijos plotis';

  @override
  String get pieceWidth => 'Gabalo plotis';

  @override
  String get fontSize => 'Šrifto dydis';

  @override
  String get standardNotation => 'WMD užrašas';

  @override
  String get restore => 'Atkurti';

  @override
  String get restoreDefaultSettings => 'Atkurti numatytuosius nustatymus';

  @override
  String pick(Object element) {
    return 'Pasirinkite $element';
  }

  @override
  String get info => 'Informacija';

  @override
  String get hint => 'Patarimas';

  @override
  String get player => 'žaidėjas';

  @override
  String get player1 => '1 žaidėjas';

  @override
  String get player2 => '2 žaidėjas';

  @override
  String get howToPlay => 'Kaip žaisti';

  @override
  String get toPlacePiece =>
      'Bakstelėkite bet kurį galimą tašką, kad padėtumėte figūrėlę.';

  @override
  String get toSelectPiece => 'Bakstelėkite figūrėlę, kad ją perkeltumėte.';

  @override
  String get toMovePiece =>
      'Bakstelėkite tašką, prijungtą prie figūrėlės, kad ją perkeltumėte.';

  @override
  String get toRemovePiece =>
      'Bakstelėkite vieną priešininko figūrėlę, kad pašalintumėte.';

  @override
  String get needToCreateMillFirst =>
      'Prieš pašalindami figūrėlę pirmiausia turite sukurti malūną.';

  @override
  String get needToPlayWithOwnPieces => 'Turite žaisti su savo figūrėlėmis.';

  @override
  String get statistics => 'Statistika';

  @override
  String get totalGames => 'Iš viso žaidimų';

  @override
  String get results => 'Rezultatai';

  @override
  String get left => 'palikta';

  @override
  String get privacyPolicy => 'Privatumo politika';

  @override
  String get privacyPolicy_Detail_1 =>
      'Atidžiai perskaitykite ir įsitikinkite, kad visiškai suprantate ir sutinkate su šia ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Jei nesutinkate su šia politika, nesinaudokite šia programėle. Naudojimasis programėle reiškia, kad sutinkate su šiomis sąlygomis.';

  @override
  String get and => ' ir . ';

  @override
  String get accept => 'Priimti';

  @override
  String get takeBack => 'Grįžti atgal';

  @override
  String get takingBack => 'Grįžimas atgal…';

  @override
  String get waiting => 'Laukimas…';

  @override
  String get stepForward => 'Žingsnis į priekį';

  @override
  String get takeBackAll => 'Atsiimti viską atgal';

  @override
  String get stepForwardAll => 'Žingsnis į priekį visi';

  @override
  String get moveNow => 'Judėti dabar';

  @override
  String get done => 'Atlikta.';

  @override
  String get crackMill => 'Krekingo malūnas';

  @override
  String get crackMill_Detail =>
      'Jei žaidėjas turi tik malūnuose esančias figūrėles, malūnuose esančios figūrėlės nebus užrakintos, kad būtų pašalintos.';

  @override
  String get animationDuration => 'Animacijos trukmė';

  @override
  String get none => 'Nėra';

  @override
  String get theme => 'Tema';

  @override
  String get helpContent =>
      'Žaidimo tikslas - palikti priešininką su mažiau nei trimis figūromis arba neturėti jokių teisėtų ėjimų.\n\nŽaidimas automatiškai sužaidžiamas lygiosiomis, jei pozicija pasitaiko trečią kartą arba per paskutinius 100 (konfigūruojamų) ėjimų nėra pašalinama.\n\nŽaidimas vyksta trimis etapais:\n\n1. Figūrų statymas į laisvus taškus\n2. Figūrėlių perkėlimas į gretimus taškus\n3. (neprivalomas etapas) Figūrėlių perkėlimas į bet kurį laisvą tašką, kai žaidėjas turi mažiau nei tris figūrėles\n\nDėliojimas\n\nŽaidimas pradedamas tuščia lenta, kurią sudaro tinklelis su dvidešimt keturiais taškais. Žaidėjai paeiliui deda savo figūrėles į laisvus taškus, kol kiekvienas žaidėjas padeda visas figūrėles ant lentos. Jei žaidėjas gali pastatyti tris savo figūrėles tiesiai, jis turi \"malūnėlį\" ir gali pašalinti nuo lentos vieną priešininko figūrėlę.\n\nPagal kai kurias taisykles žaidėjai, prieš pašalindami figūrėlę iš suformuoto malūno, pirmiausia turi pašalinti visas kitas figūrėles.\n\nKai kuriose taisyklėse negalima vėl dėti figūrų į pašalintų figūrų taškus dėjimo etape.\n\nPanaudoję visas figūrėles, žaidėjai juda paeiliui.\n\nJudėjimas\n\nNorėdamas judėti, žaidėjas perkelia vieną savo figūrėlę išilgai lentos linijos į laisvą gretimą tašką. Jei jam nepavyksta to padaryti, jis pralaimėjo žaidimą. Kaip ir padėjimo etape, žaidėjas, kuris ant lentos linijos pastato tris savo figūrėles, turi malūną ir gali pašalinti vieną iš priešininko figūrėlių. Bet kuris žaidėjas, sumažinęs savo figūrų skaičių iki dviejų, neturi galimybės suformuoti naujų malūnų, todėl pralaimi žaidimą. Žaidėjas taip pat gali pralaimėti, kai turi daugiau nei tris figūrėles, jei priešininkas blokuoja jų judėjimą.\n\nSkraidantys\n\nKai kuriuose taisyklių variantuose, kai žaidėjui lieka tik trys figūrėlės, jo figūrėlės gali skristi, šokinėti ar šokinėti į bet kuriuos laisvus taškus, ne tik į gretimus.\n';

  @override
  String get versionInfo => 'Informacija apie versiją';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'Licencija';

  @override
  String get sourceCode => 'Šaltinio kodas';

  @override
  String get appVersion => 'Programėlės versija';

  @override
  String get general => 'Bendra';

  @override
  String get advanced => 'Išplėstinė';

  @override
  String get placing => 'talpinimas';

  @override
  String get moving => 'Perkėlimas';

  @override
  String get removing => 'Pašalinimas';

  @override
  String get gameOverCondition => 'Žaidimo pabaigos sąlyga';

  @override
  String get aisPlayStyle => 'AI žaidimo stilius';

  @override
  String get passive => 'Pasyvus';

  @override
  String get timeout => 'Laiko limitas';

  @override
  String get appearance => 'Išvaizda';

  @override
  String get drawOnHumanExperience => 'Remkitės žmogaus patirtimi';

  @override
  String get considerMobility => 'Atsižvelkite į dalių mobilumą';

  @override
  String get pieceCount => 'Gabalėlių skaičius:';

  @override
  String inHand(Object player, int count) {
    return '$player rankoje: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player laive: $count';
  }

  @override
  String get boardTop => 'lentos poslinkis nuo viršaus';

  @override
  String get notAIsTurn => 'Tai nėra dirbtinio intelekto ėjimas.';

  @override
  String get aiIsNotThinking => 'AI nemąsto.';

  @override
  String get atEnd => 'Esate ėjimų sąrašo pabaigoje.';

  @override
  String get tapBackAgainToLeave =>
      'Dar kartą bakstelėkite atgal, kad išeitumėte.';

  @override
  String get more => 'Daugiau';

  @override
  String get experimental => 'Tai eksperimentinė funkcija.';

  @override
  String get experiments => 'Eksperimentai';

  @override
  String get ossLicenses => 'Atvirojo kodo licencijos';

  @override
  String get language => 'Kalba';

  @override
  String get defaultLanguage => 'Numatytoji kalba';

  @override
  String get mayMoveInPlacingPhase => 'Figūrėlės gali judėti dėjimo etape';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Nėra atskirų dėliojimo ir judėjimo fazių, t. y. kiekvieno ėjimo metu žaidėjai gali nuspręsti, ar jie nori dėti figūrą ant lentos, ar perkelti vieną iš savo figūrų (jei tik turi likusių figūrų, kurias galima dėti).';

  @override
  String get drawerColor => 'Meniu spalva';

  @override
  String get drawerTextColor => 'Meniu teksto spalva';

  @override
  String get drawerHighlightItemColor => 'Meniu paryškinti elemento spalvą';

  @override
  String get mainToolbarBackgroundColor =>
      'Pagrindinės įrankių juostos fono spalva';

  @override
  String get mainToolbarIconColor =>
      'Pagrindinės įrankių juostos piktogramos spalva';

  @override
  String get navigationToolbarBackgroundColor =>
      'Naršymo įrankių juostos fono spalva';

  @override
  String get navigationToolbarIconColor =>
      'Naršymo įrankių juostos piktogramos spalva';

  @override
  String get autoHideToolbar => 'Automatiškai slėpti įrankių juostą';

  @override
  String get toolbarLocationOnScreen => 'Įrankių juostos vieta ekrane';

  @override
  String get top => 'Į viršų';

  @override
  String get bottom => 'Apačia';

  @override
  String get center => 'Centras';

  @override
  String get solidColor => 'Vienoda spalva';

  @override
  String get picture => 'Paveikslėlis';

  @override
  String get chooseYourPicture => 'Pasirinkite savo paveikslėlį';

  @override
  String get light => 'Šviesa';

  @override
  String get dark => 'Tamsu';

  @override
  String get themes => 'Temos';

  @override
  String get currentTheme => 'Dabartinė tema';

  @override
  String get saveTheme => 'Išsaugoti temą';

  @override
  String get showAnalysisGraph => 'Rodyti analizės grafiką';

  @override
  String get analysis => 'Analizė';

  @override
  String get saveGame => 'Išsaugoti žaidimą';

  @override
  String get loadGame => 'Užkrauti žaidimą';

  @override
  String get setupPosition => 'Sąrankos padėtis';

  @override
  String get showLegalMoves => 'Rodyti teisėtus judesius';

  @override
  String get showLastMove => 'Rodyti paskutinį žingsnį';

  @override
  String get showArrows => 'Rodyti rodykles';

  @override
  String get pieces => 'Pjesės';

  @override
  String get showAnalysis => 'Rodyti analizę';

  @override
  String get threads => 'Siūlai';

  @override
  String get getInvolved => 'Įsitraukite';

  @override
  String get helpImproveTranslate => 'Padėkite tobulinti vertimą';

  @override
  String get tutorial => 'Pamoka';

  @override
  String get classicMill => 'Klasikinis malūnas';

  @override
  String get mixedMill => 'Mišrus malūnas';

  @override
  String get ceylonMill => 'Ceilono malūnas';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Malūnas gali būti sulaužytas ir pakartotinai perdarytas';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Jei žaidėjas sulaužo malūną ir nedelsdamas sukuria naują malūną, toks žaidėjas gali perkelti tokį kūrinį atgal į pradinę sankryžą kitame savo žingsnyje, jei jis padarys naują malūną.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Žaidimas yra lygus, jei žaidėjas turi tris figūras ir po dešimties judesių nė vienas žaidėjas nepašalina varžovo figūrų';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Kai žaidėjas nesiekia trijų dalių ir nė vienas žaidėjas negali pašalinti priešininko figūros per dešimt ėjimų, žaidimas yra lygus.';

  @override
  String get close => 'Uždaryti';

  @override
  String get whitePiece => 'Baltas gabalas';

  @override
  String get blackPiece => 'Juodas gabalas';

  @override
  String get emptyPoint => 'Tuščias taškas';

  @override
  String get noPoint => 'Nėra prasmės';

  @override
  String get placingPhase => 'Įdėjimo fazė';

  @override
  String get movingPhase => 'Judėjimo fazė';

  @override
  String get flyingPhase => 'Skraidymo fazė';

  @override
  String sideToMove(Object player) {
    return 'Perkeliama pusė: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Paskutinis žingsnis: $move';
  }

  @override
  String get selected => 'Pasirinkta';

  @override
  String get accessibility => 'Prieinamumas';

  @override
  String get screenReaderSupport => 'Ekrano skaitytuvo palaikymas';

  @override
  String get isDraw => 'Tai Lygiosios!';

  @override
  String get draw => 'Lygiosios';

  @override
  String get pieceHighlightColor => 'Kūrinio paryškinimo spalva';

  @override
  String get algorithm => 'Algoritmas';

  @override
  String get endgameNMoveRule => '„Endgame N-Move“ taisyklė';

  @override
  String get endgameNMoveRule_Detail =>
      'Jei kuris nors žaidėjas turi tik tris figūras ir nė vienas žaidėjas nepaima gabalo per tam tikrus judesius, žaidimas ištraukiamas.';

  @override
  String get drawReasonEndgameRule50 =>
      'Bet kuris žaidėjas turi tik tris gabalus ir nė vienas žaidėjas nepašalina gabalo per tam tikrus judesius.';

  @override
  String get threefoldRepetitionRule => 'Trijų kartų pasikartojimo taisyklė';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Žaidimas ištraukiamas, jei pozicija įvyksta trečią kartą.';

  @override
  String get continueToMakeMove => 'Malūnas! Tęskite žingsnį.';

  @override
  String get pointStyle => 'Taškinis stilius';

  @override
  String get pointWidth => 'Taško plotis';

  @override
  String get solid => 'Tvirtas';

  @override
  String get hollow => 'Tuščiaviduriai';

  @override
  String get languageName => 'Lietuvių';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Juda',
      one: '$count Perkelti',
      zero: 'Move',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Įkelti nepavyko.';

  @override
  String get filename => 'Failo pavadinimas';

  @override
  String get browse => 'Naršyti…';

  @override
  String get gameFiles => 'Žaidimų failai';

  @override
  String get gameSavedTo => 'Žaidimas išsaugotas';

  @override
  String get empty => 'Tuščia';

  @override
  String get noMove => 'Jokio judesio.';

  @override
  String get restoredPosition => 'Atkurta pradinė padėtis.';

  @override
  String get clean => 'Švarus';

  @override
  String get cleanedUp => 'Išvalyta.';

  @override
  String get remove => 'Pašalinti';

  @override
  String get noPiecesCanBeRemoved => 'Negalima pašalinti jokių gabalų.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count gabalus',
      one: '$count piece',
      zero: 'Piece',
    );
    return '$_temp0 reikia pašalinti.';
  }

  @override
  String placedCount(int count) {
    return 'Įdėta ($count)';
  }

  @override
  String get placedPieceCount => 'Padėtų vienetų skaičius dėjimo fazėje.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'Dabartinis žaidėjas įdėjo $count figūras.';
  }

  @override
  String get notPlacingPhase => 'Nededa fazės, negali jos pakeisti.';

  @override
  String get paste => 'Įklijuoti';

  @override
  String get pasteDone => 'Pasta baigta.';

  @override
  String get cannotPaste => 'Negalima įklijuoti.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Rodyti nepadėtas ir pašalintas dalis';

  @override
  String get fullScreen => 'Per visą ekraną';

  @override
  String get reopenToTakeEffect =>
      'Išeikite ir iš naujo atidarykite programą, kad nustatymai įsigaliotų.';

  @override
  String get forest => 'Miškas';

  @override
  String get desktopImage => 'Darbalaukio vaizdas';

  @override
  String get invalidPosition => 'Neteisinga pozicija.';

  @override
  String get shareGIF => 'Bendrinkite GIF';

  @override
  String get pixelRatio => 'Pikselių santykis';

  @override
  String get duration => 'Trukmė';

  @override
  String get gameScreenRecorder => 'Žaidimo ekrano įrašymo įrenginys';

  @override
  String get previous => 'Ankstesnis';

  @override
  String get next => 'Kitas';

  @override
  String get skip => 'Praleisti';

  @override
  String get gotIt => 'Supratau';

  @override
  String get youCanModifyRules =>
      'Žaidimo taisykles galite keisti taisyklių nustatymuose.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Galite naudoti pelės ratuką, norėdami pakeisti rinkiklio vertę.';

  @override
  String get noTimeLimitForThinking =>
      'AI Jei mąstymo laikas nustatytas į 0, tai reiškia, kad mąstymui nėra laiko apribojimų.';

  @override
  String get whatIsMtdf =>
      'MTD(f) yra modifikuota alfa-beta paieškos algoritmo forma, kuria siekiama pagerinti efektyvumą pakartotinai naudojant tarpinius paieškos rezultatus ir naudojant gerą pradinį spėjimą susiaurinti paieškos erdvę.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Atminkite, kad AI mąstymo laiko koregavimas gali būti ne visai tikslus. Tikrasis mąstymo laikas gali būti trumpesnis, kai sunkumo lygis nustatytas į mažesnę reikšmę, ir gali būti ilgesnis, kai AI yra vidutinio mąstymo, kai laikas baigiasi.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Jei nustatysite aukštą sudėtingumo lygį, bet nepadidinsite AI mąstymo laiko, tikrasis sunkumo lygis gali būti apribotas iki mažesnės vertės dėl mąstymo laiko apribojimo. Tikroji vertė gali skirtis priklausomai nuo mašinos veikimo.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) yra paieškos algoritmas, leidžiantis rasti geriausią žingsnį tam tikroje pozicijoje. Tai alfa-beta algoritmo patobulinimas ir naudoja nulio arba nulio langų paieškas, kad patvirtintų, jog žingsnis yra blogesnis ar ne blogesnis nei jau saugus pagrindinio varianto balas. PVS orientuojasi į perspektyviausius žingsnius ir vengia nereikalingų neoptimalių šakų paieškų, o tai padeda pagerinti paieškos efektyvumą.';

  @override
  String get whatIsAlphaBeta =>
      'Alfa-beta algoritmas yra paieškos algoritmas, skirtas rasti geriausią žingsnį. Jis naudoja minimalaus maksimalaus principą ir dvi vertes – alfa ir beta, kad apkarpytų paieškos medį ir padidintų efektyvumą. Alfa reiškia mažiausią balą, kuriuo kompiuteris yra įsitikinęs, kad gali gauti, o beta – didžiausią rezultatą, kurį gali gauti jo priešininkas. Algoritmas padeda kompiuteriui priimti protingus ir efektyvius žaidimo sprendimus.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Remiantis žmonių patirtimi, jei bandysi laimėti, pralaimėsi. Vietoj to siekite lygiosiomis ir nepralaimėkite žaidimo. Stebėkite savo priešininką ir švelniai pritraukite jį į tokią padėtį, kurioje jie gali klysti. Kai jie parodo silpnumą, pasinaudokite proga ir švelniai stumkite pergalę. Tokiu būdu galite laimėti žaidimą.';

  @override
  String get firstMoveDetail =>
      'Šiame žaidime antrajam žaidėjui lengviau laimėti nei pirmajam.';

  @override
  String get passiveDetail =>
      'Įjungus pasyvų parinktį AI atsipalaiduos, kai turės pranašumą pozicijoje, o ne agresyviai bandys laimėti kuo greičiau.';

  @override
  String get moveRandomlyDetail =>
      'Įjungus šią parinktį padidėja žaidimo atsitiktinumas ir linksmumas, o išjungus ją galima ištirti būdus, kaip įveikti AI.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Jei dirbtinis intelektas atsižvelgs į savo figūrų mobilumą, jis ne tik sieks kuo greičiau užfiksuoti priešininko figūras, bet ir apsvarstys galimybę blokuoti priešininko judesius ir neleisti jiems daryti to paties.';

  @override
  String get whenBoardIsFull => 'Kai lenta pilna';

  @override
  String get whenBoardIsFull_Detail =>
      'Pasibaigus dėjimo fazei, prieš prasidedant judėjimo fazei, įvyksta veiksmas, jei lenta yra pilna figūrėlių.';

  @override
  String get sideToMoveRemovePiece =>
      'Žaidėjas, kuris juda pirmas, pašalina vieną iš priešininko figūrų.';

  @override
  String get agreeToDraw => 'Abi pusės susitaria dėl lygiųjų.';

  @override
  String get takeOpponentsPiece => 'Paimkite vieną iš savo priešininko figūrų.';

  @override
  String get firstPlayerLose => 'Pirmasis žaidėjas pralaimi žaidimą.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Pirmasis ir antrasis žaidėjai pašalina vieną iš priešininko figūrų.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Antrasis ir pirmasis žaidėjai pašalina vieną iš priešininko figūrų.';

  @override
  String get enteredFlyingPhase =>
      'Įėjus į skraidymo fazę, priešininko figūros gali šokti į bet kurį tuščią lentos tašką. Skrydžio taisyklę galite išjungti „Taisyklių nustatymuose“.';

  @override
  String get whenStalemate => 'Kai aklavietė';

  @override
  String get whenStalemate_Detail =>
      'Kokie veiksmai atliekami, kai negalima perkelti nė vienos dalies?';

  @override
  String get endWithStalemateLoss => 'Baigti su aklavietės praradimu.';

  @override
  String get changeSideToMove => 'Norėdami judėti, pakeiskite šoną.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Pašalinkite vieną iš priešininko figūrų ir atlikite kitą ėjimą.';

  @override
  String get endWithStalemateDraw => 'Baigti aklavietės lygiosiomis.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Pašalinkite vieną iš priešininko figūrų ir pakeiskite šoną, kad galėtumėte judėti.';

  @override
  String get aiResponseDelayTime => 'AI atsako delsos laikas';

  @override
  String get aiIsDelaying =>
      'AI šiuo metu yra atidėto atsako fazėje. Prieš tęsdami palaukite šiek tiek.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Negalite pašalinti gretimos dalies.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'Jei atsidursite aklavietėje, priešininko figūros, esančios šalia jūsų, gali būti pašalintos, neatsižvelgiant į malūno formavimąsi.';

  @override
  String get whatIsMcts =>
      'MCTS yra pradedantiesiems patogus algoritmas, kuris priima sprendimus tyrinėdamas ir įvertindamas įvairius judesius per modeliavimą.';

  @override
  String get goldenJade => 'Auksinis nefritas';

  @override
  String get forestWood => 'Miško mediena';

  @override
  String get darkMystery => 'Tamsioji paslaptis';

  @override
  String get midnightBlue => 'Vidurnakčio mėlyna';

  @override
  String get greenForest => 'Žalias miškas';

  @override
  String get greenMeadow => 'Žalioji pieva';

  @override
  String get stonyPath => 'Akmenuotas takas';

  @override
  String get pastelPink => 'Pastelinė rožinė';

  @override
  String get turquoiseSea => 'Turkio jūra';

  @override
  String get violetDream => 'Violetinė svajonė';

  @override
  String get mintChocolate => 'Mėtų šokoladas';

  @override
  String get skyBlue => 'Dangaus mėlynumo';

  @override
  String get playfulGarden => 'Žaismingas sodas';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Retrogradinės analizės algoritmas naudoja kelių reikšmių retrogradinę analizę, kad sukurtų žaidimo pabaigos duomenų bazę iš skirtingų pradžios pozicijų, tada pritaiko šią duomenų bazę, kad optimizuotų žaidimą. Šis metodas priklauso ypač stiprių sprendimų kategorijai.';

  @override
  String get viewAlgorithmGuide =>
      'Ar norėtumėte peržiūrėti šio algoritmo vartotojo vadovą?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Rodyti padėties pranašumo indikatorių';

  @override
  String get usePerfectDatabase => 'Naudokite tobulą duomenų bazę';

  @override
  String get perfectDatabaseDescription =>
      'Įjunkite šią parinktį, kad galėtumėte naudoti nepriekaištingą žaidimų duomenų bazę, sukurtą naudojant pažangiausius algoritmus. Ši funkcija integruoja ir žaidimo pradžios, ir pabaigos strategijas, kad pasiūlytų optimalius judesius. Tai yra tinkamiausias pasirinkimas žaidėjams, kurie siekia aukščiausio lygio žaidimo tikslumo. Sukurta naudojant kruopščius skaičiavimo metodus, duomenų bazė skirta pasiūlyti beveik tobulus žaidimo sprendimus.\n\nPastaba: jei AI nepavyks pasiekti duomenų bazės, jis priims įprastinius žaidimo sprendimų algoritmus. Kai duomenų bazė yra prieinama, „Sunkumo lygis“ tampa beveik neįveikiamas, o „AI mąstymo laikas“ smarkiai sumažėja. Daugelis „AI\'s play style“ parinkčių nustatymų bus nepaisyti, nes duomenų bazės rezultatai turi didžiausią prioritetą.\n\nNorėdami gauti patarimų, kaip maksimaliai išnaudoti šią nepriekaištingą duomenų bazę, spustelėkite čia.';

  @override
  String get backgroundImage => 'Fono paveikslėlis';

  @override
  String get whatIsRandom =>
      'Kai parinktis „Naudoti tobulą duomenų bazę“ neįjungta, „Atsitiktinis“ nustatymas priverčia AI atsitiktinai perkelti gabalus, nenaudodamas perkėlimo pasirinkimo algoritmų. Tai paprastai lemia žymiai silpnesnį žaidimo eigą. Ir atvirkščiai, kai įjungta parinktis „Naudoti tobulą duomenų bazę“, AI priimdamas sprendimus pasikliauja tik „Tobula duomenų baze“, o ne derina ją su tradiciniais AI algoritmais. Šiuo režimu AI judesiai yra visiškai pagrįsti duomenų bazės turiniu, vengiant pasikliauti realaus laiko skaičiavimais ar paieškos algoritmais.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Pašalinkite priešininko figūrą(-as) iš jo rankos; tada priešininko ėjimas pastatyti figūrą.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Formuojant malūnus statymo fazės metu:';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Pašalinkite priešininko figūrą(-as) nuo lentos.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Pašalinkite priešininko figūrą(-as) nuo lentos; tada priešininko ėjimas pastatyti figūrą.';

  @override
  String get opponentRemovesOwnPiece =>
      'Priešininkas pašalina savo figūrą (-as) nuo lentos.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Užuot jums ėjus, priešininkas pasirenka ir pašalina savo figūrą (-as) nuo lentos, iš esmės atlikdamas sau žalingą veiksmą.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Pašalinkite priešininko figūrą(-as) iš jo rankos; tada jūsų ėjimas judėti.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Pašalinkite figūrą (-as) iš priešininko rankos. Jei „Multi-remove“ nustatymas reikalauja pašalinti kelias figūras, o priešininkas savo rankoje neturi daugiau figūrų, toliau šalinkite priešininko figūras nuo lentos. Tada jūsų ėjimas judėti. Jei ir toliau formuojate malūnus, galite pašalinti daugiau priešininko figūrų.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Pašalinkite figūrą (-as) iš priešininko rankos. Jei „Multi-remove“ nustatymas reikalauja pašalinti kelias figūras, o priešininkas savo rankoje neturi daugiau figūrų, toliau šalinkite priešininko figūras nuo lentos. Tada priešininko ėjimas judėti.';

  @override
  String get markAndDelayRemovingPieces =>
      'Pažymėkite figūras ir atidėkite jų pašalinimą.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Statymo fazės metu pašalinamos figūros yra pažymimos ir joks žaidėjas negali statyti naujų figūrų ant šių taškų. Prasidedant ėjimo fazei, šios pažymėtos figūros yra pašalinamos vienu metu, o žaidėjai savo figūras gali perkelti į dabar tuščius taškus.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Veiksmai, kuriuos galima atlikti formuojant malūnus išdėstymo etape.';

  @override
  String get marked => 'Pažymėtas';

  @override
  String get menu => 'Meniu';

  @override
  String get monochrome => 'Monochrominė';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Ekrano skaitytuvo palaikymą galite įjungti Prieinamumo nustatymuose, esančiuose Bendruosiuose nustatymuose.';

  @override
  String get showNumbersOnPieces => 'Rodyti numerius ant figūrų';

  @override
  String get saveImage => 'Įrašyti paveikslėlį';

  @override
  String get isAnalysisToolbarShown => 'Rodyti analizės įrankių juostą';

  @override
  String get analysisToolbarBackgroundColor =>
      'Analizės įrankių juostos fono spalva';

  @override
  String get analysisToolbarIconColor =>
      'Analizės įrankių juostos piktogramos spalva';

  @override
  String get transformed => 'Paversta.';

  @override
  String get cannotTransform => 'Negalima transformuoti.';

  @override
  String get rotate => 'Pasukti';

  @override
  String get horizontalFlip => 'H. Apsv.';

  @override
  String get verticalFlip => 'V. Apsv.';

  @override
  String get innerOuterFlip => 'IO Apsv.';

  @override
  String get transparentCanvas => 'Permatomas Drobė';

  @override
  String get restrictRepeatedMillsFormation =>
      'Apriboti pasikartojantį malūnų formavimą';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Figūra perkelta iš vieno malūno į kitą negali iškart grįžti į pradinį tašką kito ėjimo metu, kad vėl sudarytų malūną. Pirmiausia reikia atlikti kitą judesį.';

  @override
  String get oneTimeUseMill => 'Vienkartinis malūnas';

  @override
  String get oneTimeUseMill_Detail =>
      'Kiekvienas malūnas gali pašalinti tik vieną priešininko figūrą. Jūs galite jį suformuoti dar kartą, tačiau negalite jo naudoti papildomam pašalinimui.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Jūsų nustatytos dabartinės taisyklės neturi atitinkamos tobulos duomenų bazės. Norėdami gauti daugiau informacijos apie tobulą duomenų bazę, spustelėkite čia.';

  @override
  String get focusOnBlockingPaths => 'Susikoncentruokite į kelio blokavimą';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Pirmenybę teikite priešininko judesių blokavimui, o ne malūnų formavimui. Vietoj to, kad sutelktumėte dėmesį į figūrų pašalinimą užbaigiant malūnus, AI siekia užblokuoti priešininką, padaryti jį nejudriu ir užtikrinti pergalę per išsekimą, o ne agresyvų žaidimą. Ši strategija neblokuoja aktyviai priešininko malūnų.';

  @override
  String get pieceImage => 'Figūros vaizdas';

  @override
  String get importColorSettings => 'Importuoti spalvų nustatymus';

  @override
  String get exportColorSettings => 'Eksportuoti spalvų nustatymus';

  @override
  String get import => 'Importuoti';

  @override
  String get export => 'Eksportuoti';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Prašome pirmiausia nukopijuoti JSON formato nustatymus į iškarpinę.';

  @override
  String get copiedToClipboard => 'Nukopijuota į iškarpinę.';

  @override
  String get imported => 'Importuota.';

  @override
  String get boardImage => 'Lentos vaizdas';

  @override
  String get autumnLeaves => 'Rudeniniai lapai';

  @override
  String get legendaryLand => 'Legendinė Žemė';

  @override
  String get vignetteEffect => 'Vinetės efektas';

  @override
  String get promptMakeToolbarTransparent =>
      'Ar norite padaryti įrankių juostą visiškai permatomą, kai nustatoma lentos fono paveikslėlis?';

  @override
  String get vibration => 'Įjungti vibraciją žaidime';

  @override
  String get soundTheme => 'Garso tema';

  @override
  String get ball => 'Aritė';

  @override
  String get liquid => 'Skystis';

  @override
  String get wood => 'Mediena';

  @override
  String get placeEffectAnimation => 'Figūros padėjimo animacijos efektas';

  @override
  String get removeEffectAnimation => 'Figūros pašalinimo animacijos efektas';

  @override
  String get isToolbarAtBottom => 'Rodyti įrankių juostą apačioje';

  @override
  String get boardCornerRadius => 'Lentos kampo spindulys';

  @override
  String get useOpeningBook => 'Naudokite atidarymo knygą';

  @override
  String get currentRule => 'Dabartinis';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Taisyklių rinkinys';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'One-Time Mill';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'Leiskite AI naudoti atidarymo ėjimus, kuriuos dažnai naudoja profesionalūs žmogaus žaidėjai ankstyvosiose žaidimo stadijose. Pastaba: Šiuo metu ši funkcija galima tik tam tikrose taisyklių rinkiniuose.';

  @override
  String get showAdvantageGraph => 'Rodyti pranašumo grafiką';

  @override
  String get advantageGraphHint =>
      'Pranašumo grafikas bus nubraižytas tik po to, kai DI atliks ėjimą. Jis nebus nubraižytas, kai ėjimą atliks žmogus.';

  @override
  String get removalBasedOnMillCounts =>
      'Išjunkite šalinimą, kol visi žetonai bus padėti. Žaidėjai šalina žetonus pagal suformuotų malūnų skaičių.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Išjunkite šalinimą, kol visi žetonai bus padėti. Žaidėjai šalina žetonus pagal suformuotų malūnų skaičių: jei skaičius vienodas, abu pašalina tiek pat žetonų; jei vienas turi daugiau, pašalina vienu daugiau, išlaikydamas vieno žetono skirtumą. Jei tik vienas žaidėjas suformuoja malūną, jis pašalina du žetonus, o kitas – vieną. Jei nei vienas nesuformuoja malūno, abu pašalina po vieną žetoną.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Pasirinkite vieną iš savo figūrų.';

  @override
  String get notYourTurn => 'Dabar ne tavo eilė.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Anotacijų įrankių juostos fono spalva';

  @override
  String get annotationToolbarIconColor =>
      'Anotacijų įrankių juostos piktogramų spalva';

  @override
  String get isAnnotationToolbarShown => 'Rodyti anotacijų įrankių juostą';

  @override
  String get enterAnnotationMode => 'Įjungti anotacijų režimą';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Ar tikrai norite išvalyti visas anotacijas?';

  @override
  String get llmPromptCopiedToClipboard =>
      'LLM užklausa nukopijuota į iškarpinę.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Prisijungimas atmestas, serveris gali būti išjungtas.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Aptikimas sėkmingas, laukiama prisijungimo...';

  @override
  String get noLanConnection => 'Nėra LAN ryšio';

  @override
  String get takeScreenshot => 'Daryti ekrano nuotrauką';

  @override
  String get disconnectedFromOpponent => 'Atsijungta nuo priešininko.';

  @override
  String get takeBackRequest => 'Atšaukimo užklausa';

  @override
  String get nothingToShow => 'Nėra ką rodyti.';

  @override
  String get stopHosting => 'Nutraukti talpinimą';

  @override
  String get connectionResetByPeer => 'Ryšys atstatytas kito vartotojo.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Ryšys nutrūko dėl laiko limito. Prisijunkite iš naujo.';

  @override
  String get startHosting => 'Pradėti talpinimą';

  @override
  String get restartRequestRejected => 'Paleidimo iš naujo užklausa atmesta.';

  @override
  String get notConnectedToLanOpponent => 'Neprisijungta prie LAN priešininko.';

  @override
  String get llmPrompt => 'LLM užklausa';

  @override
  String get gameRestarted => 'Žaidimas paleistas iš naujo.';

  @override
  String get takeBackRejected => 'Atšaukimas atmestas.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Ar tikrai norite pasiduoti šiame žaidime?';

  @override
  String get opponentResignedYouWin => 'Priešininkas pasidavė. Jūs laimėjote!';

  @override
  String get clearAllAnnotations => 'Išvalyti visas anotacijas';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Prisijungta, laukiama priešininko ėjimo...';

  @override
  String get networkStatusDisconnected => 'Tinklo būsena: atjungta';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Atšaukimo užklausa išsiųsta priešininkui.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'Priešininkas galėjo išeiti iš žaidimo.';

  @override
  String get connectedToHostSuccessfully =>
      'Sėkmingai prisijungta prie talpinimo.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Ryšys nutrūko: laiko limitas pasibaigė';

  @override
  String get noHostDiscovered => 'Talpinimas neaptiktas.';

  @override
  String get confirmResignation => 'Patvirtinti pasidavimą';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Žaidimas pradėtas, laukiama žaidėjų prisijungimo...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Ryšio laiko limitas pasibaigė, tinklas nestabilus.';

  @override
  String get noLlmPromptAvailable => 'Nėra prieinamos LLM užklausos.';

  @override
  String get youResignedGameOver => 'Jūs pasidavėte. Žaidimas baigtas.';

  @override
  String get serverIp => 'Serverio IP';

  @override
  String get confirmClear => 'Patvirtinti išvalymą';

  @override
  String get opponentSTurn => 'Priešininko ėjimas.';

  @override
  String get waitingAClientConnection => 'Laukiama kliento prisijungimo...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Atšaukimo užklausa buvo atmesta arba nepavyko.';

  @override
  String get addText => 'Pridėti tekstą';

  @override
  String get exitAnnotationMode => 'Išeiti iš anotacijų režimo';

  @override
  String get typeYourAnnotation => 'Įveskite savo anotaciją';

  @override
  String get attemptingToReconnect => 'Bandoma prisijungti iš naujo...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Paleidimo iš naujo užklausa išsiųsta. Laukiama priešininko atsakymo...';

  @override
  String get serverIsStopped => 'Serveris sustabdytas.';

  @override
  String get restartRequest => 'Paleidimo iš naujo užklausa';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Negalima prašyti atšaukimo, kai ne jūsų eilė.';

  @override
  String get takeBackAccepted => 'Atšaukimas priimtas.';

  @override
  String get localNetworkSettings => 'Vietinio tinklo nustatymai';

  @override
  String get reconnectedSuccessfully => 'Sėkmingai prisijungta iš naujo!';

  @override
  String get failedToSaveImageToGallery =>
      'Nepavyko išsaugoti vaizdo galerijoje.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Priešininkas paprašė paleisti žaidimą iš naujo. Ar sutinkate?';

  @override
  String get yourTurn => 'Tavo eilė.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Nepavyko prisijungti iš naujo, paleiskite žaidimą iš naujo.';

  @override
  String get host => 'Talpintojas';

  @override
  String get join => 'Prisijungti';

  @override
  String get port => 'Prievadas';

  @override
  String get invalidIpAddress => 'Netinkamas IP adresas.';

  @override
  String get invalidPort => 'Netinkamas prievadas.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Jungiamasi: bandymas $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Nepavyko prisijungti: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Nepavyko pradėti talpinimo: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Talpintojas aptiktas: $ip:$port';
  }

  @override
  String get stop => 'Stabdyti';

  @override
  String get discover => 'Aptikti';

  @override
  String get connect => 'Prisijungti';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Klientas prisijungė: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Aptikimas: $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Prisijungiama iš naujo ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Prisijungta';

  @override
  String get delete => 'Ištrinti';

  @override
  String get ancientEgypt => 'Senovės Egiptas';

  @override
  String get gothicIce => 'Gotikinis Ledas';

  @override
  String get riceField => 'Ryžių Laukas';

  @override
  String get chinesePorcelain => 'Kinijos Porcelianas';

  @override
  String get desertDusk => 'Dykumos Prieblanda';

  @override
  String get precisionCraft => 'Tikslus Amatas';

  @override
  String get folkEmbroidery => 'Liaudies Siuvinėjimas';

  @override
  String get carpathianHeritage => 'Karpatų Paveldas';

  @override
  String get imperialGrandeur => 'Imperatoriškas Didumas';

  @override
  String get bohemianCrystal => 'Bohemijos Krištolas';

  @override
  String get savannaSunrise => 'Savanos Saulėtekis';

  @override
  String get harmonyBalance => 'Harmonija ir Balansas';

  @override
  String get cinnamonSpice => 'Cinamono Prieskonis';

  @override
  String get anatolianMosaic => 'Anatolijos Mozaika';

  @override
  String get carnivalSpirit => 'Karnavalo Dvasia';

  @override
  String get custom => 'Paprotys';

  @override
  String get spiceMarket => 'Prieskonių turgus';

  @override
  String get swipeToRevealTheDrawer => 'Braukite, kad atidarytumėte stalčių';

  @override
  String get showGameInfoOnScreenshots =>
      'Rodyti žaidimo informaciją ekrano nuotraukose';

  @override
  String get humanMoveTime => 'Žmogaus laiko limitas';

  @override
  String get noTimeLimitForHumanMoves => 'Žmogaus ėjimams laiko limito nėra';

  @override
  String get timeoutLoseWillBeApplied =>
      'Žmogui žaidėjui bus taikomas pralaimėjimas dėl laiko viršijimo';

  @override
  String get identifyingBoard => 'Nustatoma žaidimo lenta…';

  @override
  String get youCanEnterAnyModelName =>
      'Galite įvesti bet kokį modelio pavadinimą.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Lentos padėtis pritaikyta. FEN nukopijuotas į iškarpinę.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Patarimas: pabandykite nufotografuoti aiškesnę lentos nuotrauką.';

  @override
  String get llmPromptTemplate => 'LLM užklausos šablonas';

  @override
  String get noValidBoardDetected => 'Galiojančios lentos nerasta.';

  @override
  String get selectingImageFromAlbum => 'Pasirenkama nuotrauka iš albumo…';

  @override
  String get configurePromptTemplate => 'Konfigūruoti užklausos šabloną';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Redaguoti užklausos šabloną LLM analizei';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Nepavyko sugeneruoti FEN iš atpažintos lentos.';

  @override
  String get outputInCurrentLanguage => 'Išvestis esama kalba';

  @override
  String get commonBaseUrls => 'Dažnai naudojamos Base URL';

  @override
  String get viewCommonModels => 'Peržiūrėti dažnai naudojamus modelius';

  @override
  String get recognitionParametersUpdated =>
      'Atnaujinti atpažinimo parametrai.';

  @override
  String get whiteSMove => 'Baltųjų ėjimas';

  @override
  String get resetToDefaults => 'Atstatyti numatytuosius nustatymus';

  @override
  String get photoShoot => 'Fotosesija';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Nepavyko pritaikyti atpažintos lentos padėties.';

  @override
  String get llmPromptContent => 'LLM užklausos turinys';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM nėra sukonfigūruotas. Patikrinkite nustatymus.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Nustatyti tiekėją, modelį, API Key ir Base URL';

  @override
  String get llmConfiguration => 'LLM konfigūracija';

  @override
  String get configureLlmProvider => 'Konfigūruoti LLM tiekėją';

  @override
  String get llmPromptTemplateHeader => 'LLM užklausos šablono antraštė';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Nepavyko atpažinti figūrų paveikslėlyje. Bandykite dar kartą.';

  @override
  String get recognizeBoardFromImage => 'Atpažinti lentą iš paveikslėlio';

  @override
  String get viewTips => 'Peržiūrėti patarimus';

  @override
  String get applyToBoard => 'Pritaikyti lentelei';

  @override
  String get adjustBoardArea => 'Koreguoti lentos sritį';

  @override
  String get viewCommonUrls => 'Peržiūrėti dažnai naudojamus URL';

  @override
  String get colorAnalysisFailed => 'Spalvų analizė nepavyko!';

  @override
  String get analyzingGameBoardImage =>
      'Analizuojamas žaidimo lentos paveikslėlis…';

  @override
  String get selectFromAlbum => 'Pasirinkti iš albumo';

  @override
  String get noBoardPointDetected => 'Lentos taškas nerastas!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Jei palikta tuščia, bus naudojamas numatytasis šablonas';

  @override
  String get llmConfig => 'LLM konfigūracija';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Ar tikrai norite atstatyti užklausos šablonus į numatytąsias reikšmes?';

  @override
  String get llmPromptTemplateFooter => 'LLM užklausos šablono poraštė';

  @override
  String get loadingResponse => 'Kraunamas atsakymas…';

  @override
  String get applyThisResultToBoard => 'Pritaikyti šį rezultatą lentelei';

  @override
  String get takingPicture => 'Daroma nuotrauka…';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Pasirinkite žaidimo lentos paveikslėlį, kurį norite atpažinti';

  @override
  String get identificationResults => 'Atpažinimo rezultatai';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Analizuokite ėjimus ir pateikite įžvalgas.';

  @override
  String get getApiKey => 'Gauti API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Visas atpažinimo procesas nebuvo užbaigtas.';

  @override
  String get boardRecognitionResult => 'Lentos atpažinimo rezultatas';

  @override
  String get askLlm => 'Klausti LLM';

  @override
  String get boardDetectionFailed => 'Lentos aptikimas nepavyko!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Lentos taško nerasta, negalima atpažinti figūros!';

  @override
  String get copyFen => 'Kopijuoti FEN';

  @override
  String get commonlyUsedModels => 'Dažnai naudojami modeliai';

  @override
  String get apiKeyOptional => 'API Key (pasirinktinai)';

  @override
  String get noImageSelected => 'Vaizdas nepasirinktas';

  @override
  String get blackSMove => 'Juodųjų ėjimas';

  @override
  String get llm => 'Didelis kalbos modelis';

  @override
  String get llmProvider => 'Tiekėjas';

  @override
  String get baseUrl => 'Bazinė URL';

  @override
  String get model => 'Modelis';

  @override
  String get temperature => 'Temperatūra';

  @override
  String get llmCommandReceivedProcessing => 'Komanda gauta! AI apdoroja...';

  @override
  String get llmDeepThinkingWait => 'Vyksta gilus mąstymas, palaukite...';

  @override
  String get llmPresentingSoon => 'Greitai bus pristatyta...';

  @override
  String get recognitionParameters => 'Atpažinimo parametrai';

  @override
  String get adjustParamsDesc =>
      'Reguliuokite parametrus, kad pagerintumėte atpažinimo tikslumą';

  @override
  String get saveParameters => 'Išsaugoti parametrus';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Nepavyko paleisti vaizdo atpažinimo: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Vaizdo atpažinimas nepavyko: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Pritaikyta padėtis su $whiteCount baltais ir $blackCount juodaisiais kauliukais';
  }

  @override
  String get fenCopiedToClipboard => '(FEN nukopijuotas į iškarpinę)';

  @override
  String recognitionFailed(String error) {
    return 'Atpažinimas nepavyko: $error';
  }

  @override
  String get myRating => 'Mano įvertinimas';

  @override
  String get gamesPlayed => 'Sužaista žaidimų';

  @override
  String get wins => 'Pergalės';

  @override
  String get losses => 'Pralaimėjimai';

  @override
  String get draws => 'Lygiosios';

  @override
  String get lastUpdated => 'Paskutinį kartą atnaujinta';

  @override
  String get format => 'Formatas:';

  @override
  String get resetStatistics => 'Nustatyti statistiką iš naujo';

  @override
  String get drawRate => 'Lygiosiomis baigtų žaidimų rodiklis';

  @override
  String get lossRate => 'Pralaimėjimų rodiklis';

  @override
  String get aiStatistics => 'DI statistika';

  @override
  String get enableStatistics => 'Įjungti statistiką';

  @override
  String get enableStatistics_Detail =>
      'Kai įjungta, žaidimų rezultatai bus įrašomi į statistiką. Tačiau žaidimai, kuriuose buvo atšauktų ėjimų, nebus įrašomi. Kai išjungta, statistikos rinkimas pristabdomas.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Tai nustatys visą žaidimų statistiką iš naujo. Šio veiksmo negalima anuliuoti.';

  @override
  String get boardInnerRingSize => 'Vidinio lentos žiedo dydis';

  @override
  String get boardShadowEnabled => 'Lentos šešėlis';

  @override
  String get trapAwareness => 'Spąstų atpažinimas';

  @override
  String get trapAwarenessDescription =>
      'Analizės metu paryškinkite spąstų ėjimus storais apskritimais ir rodyklėmis.';

  @override
  String trapExists(String trapMoves) {
    return 'Yra spąstai. Spąstų ėjimai: $trapMoves';
  }

  @override
  String get custodianCapture => 'Flanking gaudymas';

  @override
  String get custodianCaptureDescription =>
      'Pridėkite vieną iš savo priešininko gabalų tarp dviejų jūsų tiesia linija, kad jį užfiksuotumėte.';

  @override
  String get custodianCaptureEnable => 'Leiskite fiksuoti';

  @override
  String get interventionCapture => 'Intervencijos fiksavimas';

  @override
  String get interventionCaptureDescription =>
      'Pereikite į tuščią tašką tarp dviejų priešininko gabalų, kad užfiksuotumėte juos abu.';

  @override
  String get interventionCaptureEnable => 'Leiskite užfiksuoti intervenciją';

  @override
  String get leapCapture => 'Šuolio fiksavimas';

  @override
  String get leapCaptureDescription =>
      'Užfiksuokite šokinėdami virš gretimo priešininko gabalo į tuščią tašką.';

  @override
  String get leapCaptureEnable => 'Leiskite šuolio fiksavimui';

  @override
  String get captureApplicableLines => 'Taikomos eilutės';

  @override
  String get captureSquareEdges => 'Palei aikštės kraštus';

  @override
  String get captureCrossLines =>
      'Išilgai stačiakampių linijų, kertančių aikštę';

  @override
  String get captureDiagonalLines =>
      'Išilgai įstrižainių linijų, kertančių aikštę';

  @override
  String get captureExecutionPhases => 'Vykdymo etapai';

  @override
  String get capturePiecesCondition =>
      'Prieinamumas judančios fazės metu, remiantis likusiais gabalėliais';

  @override
  String get capturePiecesConditionUnlimited => 'Jokio apribojimo';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Galima, kai turite tris ar mažiau gabalų';
}
