// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Korean (`ko`).
class SKo extends S {
  SKo([String locale = 'ko']) : super(locale);

  @override
  String get appName => '참고누';

  @override
  String get welcome => '어서오세요';

  @override
  String get yes => '예';

  @override
  String get no => '아니오';

  @override
  String get game => '게임';

  @override
  String get humanVsAi => '인간 대 AI';

  @override
  String get humanVsHuman => '두 인 대결';

  @override
  String get aiVsAi => 'AI 끼리 대결';

  @override
  String get humanVsCloud => '클라우드에 도전';

  @override
  String get humanVsLAN => '온라인 대결';

  @override
  String get testViaLAN => 'LAN을 통한 테스트';

  @override
  String get move => '이동';

  @override
  String get showMoveList => '기보 보기';

  @override
  String get moveList => '기보';

  @override
  String get noGameRecord => '아직 기록이 없습니다';

  @override
  String get ok => '확인';

  @override
  String get confirm => '확인';

  @override
  String get cancel => '취소';

  @override
  String get tipSelectWrong => '잘못된 말을 선택했습니다.';

  @override
  String get tipPlace => '말을 배치하세요.';

  @override
  String get tipBanPlace => '거기엔 둘 수 없습니다.';

  @override
  String get tipPlaced => '이미 놓았습니다.';

  @override
  String get tipRemove => '말을 제거하세요.';

  @override
  String get tipBanRemove => '그 말은 지울 수 없습니다.';

  @override
  String get tipRemoved => '이미 제거했습니다.';

  @override
  String get tipMove => '말을 이동시키세요.';

  @override
  String get tipCannotPlace => '당신의 말은 그곳에 둘 수 없습니다.';

  @override
  String get tipCannotMove => '당신의 말을 그곳으로 이동시킬 수 없습니다.';

  @override
  String get tipMill => '곤! 상대의 말을 제거하세요';

  @override
  String get tipContinueMill => '상대의 말을 계속 제거하세요.';

  @override
  String get tipSelectOpponentsPiece => '상대방의 말을 선택하세요.';

  @override
  String get tipCannotRemovePieceFromMill => '곤 상태의 말은 먹을 수 없습니다.';

  @override
  String get tipCanMoveOnePoint => '말을 한 칸 이동할 수 있습니다.';

  @override
  String get tipCannotMoveOpponentsPieces => '상대의 말은 움직일 수 없습니다.';

  @override
  String get tipSelectPieceToMove => '움직일 말을 선택하세요.';

  @override
  String get tipHaveThreePiecesLeft => '말이 세 개 남았습니다.';

  @override
  String get tipCanMoveToAnyPoint => '원하는 방향으로 이동하세요.';

  @override
  String tipToMove(Object player) {
    return '$player 의 말 이동 차례입니다.';
  }

  @override
  String get whiteWin => '플레이어 1 승리!';

  @override
  String get blackWin => '플레이어 2 승리!';

  @override
  String get won => '승리';

  @override
  String get lost => '패배';

  @override
  String get thinking => '생각중…';

  @override
  String get newGame => '새 게임';

  @override
  String get importGame => '게임 불러오기';

  @override
  String get exportGame => '게임 내보내기';

  @override
  String get gameImported => '게임을 불러왔습니다.';

  @override
  String cannotImport(Object invalidMove) {
    return '$invalidMove 으로 게임을 불러올 수 없습니다.';
  }

  @override
  String get movesAndRulesNotMatch => '불러온 게임이 현재 규칙과 맞지 않습니다.';

  @override
  String get pleaseWait => '잠시만 기다려주세요.';

  @override
  String get restartGame => '현재 게임을 다시 시작하시겠습니까?';

  @override
  String get restart => '재시작';

  @override
  String get gameStarted => '게임이 시작되었습니다. 말을 배치해주세요.';

  @override
  String get analyzing => '분석중…';

  @override
  String error(Object message) {
    return '오류: $message';
  }

  @override
  String get winRate => '승률';

  @override
  String get score => '점수:';

  @override
  String get white => '플레이어 1';

  @override
  String get black => '플레이어 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player 의 말 개수가 3개 미만입보다 적습니다.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player가 기권했습니다.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player 의 말이 어디로도 갈 수 없습니다.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return '판이 가득 차서 $player 의 말이 어디로도 갈 수 없습니다.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return '시간이 초과되어 $player가 졌습니다.';
  }

  @override
  String get drawReasonRule50 =>
      '이동 단계에서 지정된 연속된 수의 움직임 동안 아무 말도 제거되지 않았으므로, 규정에 따라 무승부로 판정됩니다.';

  @override
  String get drawReasonBoardIsFull => '판이 꽉 차서 더 이상 이동할 수 없습니다. 비겼습니다.';

  @override
  String get drawReasonThreefoldRepetition => '삼중 반복으로 인해 무승부입니다.';

  @override
  String get gameOverUnknownReason => '이유는 알 수 없지만 어쨌든, 게임 오버!';

  @override
  String get gameOver => '게임 오버';

  @override
  String get youWin => '당신이 승리했습니다! 축하합니다!';

  @override
  String challengeHarderLevel(int level) {
    return '더 어려운 레벨에 도전하시겠습니까? 새로운 레벨은 $level 레벨입니다!';
  }

  @override
  String get youLose => '당신의 패배입니다!';

  @override
  String get analyze => '분석';

  @override
  String get about => '소개';

  @override
  String version(Object versionNumber) {
    return 'Version: $versionNumber';
  }

  @override
  String get thanks => '도움을 준 사람들';

  @override
  String get settings => '개인설정';

  @override
  String get options => '옵션';

  @override
  String get generalSettings => '일반 설정';

  @override
  String get skillLevel => '난이도';

  @override
  String get moveTime => 'AI의 연산 시간';

  @override
  String get difficulty => '난이도 설정';

  @override
  String get playSounds => '소리 설정';

  @override
  String get playSoundsInTheGame => '게임 내에서 소리 재생';

  @override
  String get keepMuteWhenTakingBack => '되돌리기를 할 때 음소거';

  @override
  String get tone => '톤';

  @override
  String get whoMovesFirst => '첫 이동';

  @override
  String get human => '플레이어';

  @override
  String get ai => 'AI';

  @override
  String get alternate => '번갈아 가며';

  @override
  String get isAutoRestart => '게임 오버시에 자동으로 재시작';

  @override
  String get isAutoChangeFirstMove => '첫 수 자동 변경';

  @override
  String get shufflingEnabled => '무작위로 이동';

  @override
  String get misc => '기타 설정';

  @override
  String get rules => '규칙';

  @override
  String get piecesCount => '각 플레이어가 가지는 말의 수';

  @override
  String get piecesCount_Detail => '각 플레이어가 시작할 때 가지는 말의 개수를 설정합니다.';

  @override
  String get flyPieceCount => '플라잉을 활성화 시킬 말 개수';

  @override
  String get flyPieceCount_Detail =>
      '플라잉이 활성화 될 시, 특정 수까지 말이 줄어들면 인접한 위치로 이동하는 대신 비어있는 어떤 위치로도 말을 이동시킬 수 있게 됩니다.';

  @override
  String get piecesAtLeastCount => '최소 말의 수, 이하면 게임에서 패배';

  @override
  String get hasDiagonalLines => '대각선 추가';

  @override
  String get hasDiagonalLines_Detail => '보드에 대각선을 추가합니다.';

  @override
  String get isDefenderMoveFirst => '첫 이동 순서 교차';

  @override
  String get isDefenderMoveFirst_Detail =>
      '말이 전부 배치되고 이동시킬 때, 말을 두 번째로 배치하기 시작한 사람이 먼저 이동하도록 합.';

  @override
  String get mayRemoveMultiple => '여러 말 제거';

  @override
  String get mayRemoveMultiple_Detail =>
      '곤이 교차되어 여러 개가 한 번에 생겼을 때, 곤의 숫자만큼 상대의 말도 여러 개 제거합니다.';

  @override
  String get mayRemoveFromMillsAlways => '곤 파괴';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      '기본설정에서는 곤을 이루는 말을 제거하기 위해서는 일단 곤이 아닌 다른 말들을 먼저 제거해야하지만, 이 설정을 켜면 그 제한이 없어집니다.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull => '판이 가득찰 시 두 번째 플레이어 패배';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      '배치 단계에서 판이 가득 찰 경우, 먼저 놓는 쪽이 패배하는 걸로 합니다. 비활성화 되어있다면 비기는 게임이 됩니다.';

  @override
  String get isLoseButNotChangeSideWhenNoWay => '의미 있는 수가 없을 시 패배';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      '상대방에게 막혀 더 이상 이동할 수 없을 때 패배하도록 합니다. 비활성화된 경우 상대방에게 막혀 이동할 수 없을 때 이동에 제한이 없어집니다.';

  @override
  String get mayFly => '플라잉';

  @override
  String get mayFly_Detail =>
      '플레이어가 3 개 혹은 4 개의 말만을 가지고 있을 때, 말을 어느 위치로든 이동시킬 수 있습니다.';

  @override
  String get nMoveRule => 'N--이동 규칙';

  @override
  String get nMoveRule_Detail => '특정 수의 이동 후에 어떤 말도 제거되지 않으면 게임은 무승부로 합니다.';

  @override
  String get rollback => '되돌리기';

  @override
  String get pleaseSelect => '선택하세요';

  @override
  String get copy => '복사';

  @override
  String get moveHistoryCopied => '이동 기록이 클립 보드에 복사되었습니다.';

  @override
  String get help => '이용안내';

  @override
  String get feedback => '피드백';

  @override
  String get exit => '완전종료';

  @override
  String get ruleSettings => '규칙 설정';

  @override
  String get color => '색상';

  @override
  String get boardColor => '판 색상';

  @override
  String get pieceColor => '말 색상';

  @override
  String get backgroundColor => '배경 색';

  @override
  String get lineColor => '보드 선 색상';

  @override
  String get whitePieceColor => '플레이어 1의 말 색상';

  @override
  String get blackPieceColor => '플레이어 2의 말 색상';

  @override
  String get messageColor => '메시지 색';

  @override
  String get isPieceCountInHandShown => '배치되지 않은 말의 수 표시';

  @override
  String get isNotationsShown => '판에 좌표 표시';

  @override
  String get isHistoryNavigationToolbarShown => '이동 기록 툴바 표시';

  @override
  String get display => '화면 설정';

  @override
  String get boardBorderLineWidth => '판의 외각선 두께';

  @override
  String get boardInnerLineWidth => '판의 내부 선의 두께';

  @override
  String get pieceWidth => '말의 크기';

  @override
  String get fontSize => '글꼴 크기';

  @override
  String get standardNotation => 'WMD 기록 형식';

  @override
  String get restore => '초기화';

  @override
  String get restoreDefaultSettings => '기본 설정으로 복원';

  @override
  String pick(Object element) {
    return '$element 선택';
  }

  @override
  String get info => '정보';

  @override
  String get hint => '힌트';

  @override
  String get player => '플레이어';

  @override
  String get player1 => '플레이어 1';

  @override
  String get player2 => '플레이어 2';

  @override
  String get howToPlay => '게임 방법';

  @override
  String get toPlacePiece => '보드의 빈 교차점을 탭하여 말을 놓으세요.';

  @override
  String get toSelectPiece => '이동할 말을 탭하세요.';

  @override
  String get toMovePiece => '말을 이동하려면 해당 말에 연결된 점을 탭하세요.';

  @override
  String get toRemovePiece => '상대방의 말 중 하나를 탭하여 제거하세요.';

  @override
  String get needToCreateMillFirst => '말을 제거하기 전에 먼저 곤을 만들어야 합니다.';

  @override
  String get needToPlayWithOwnPieces => '자신의 말로 플레이해야 합니다.';

  @override
  String get statistics => '통계 자료';

  @override
  String get totalGames => '전체 게임 수';

  @override
  String get results => '결과';

  @override
  String get left => '남음';

  @override
  String get privacyPolicy => '개인 정보 정책';

  @override
  String get privacyPolicy_Detail_1 =>
      '다음을 포함하되 이에 국한되지 않는 \"사용자 계약\"및 \"개인 정보 보호 정책\"의 조건을주의 깊게 읽고 완전히 이해하십시오.\n당사가 귀하에게 제공하는 서비스를 개선하기 위해 귀하의 명시 적 승인에 따라 당사는 귀하의 장치 모델, 진단 데이터, 이메일 주소 등과 같은 정보를 얻을 수 있습니다. 귀하는 승인을 거부하거나 취소 할 권리가 있습니다. 진단 데이터 전송을 요청할 때마다 팝업 창을 통해 귀하의 명시 적 동의를 얻습니다.\n당신은 읽을 수있다 \" ';

  @override
  String get privacyPolicy_Detail_2 =>
      '\"더 알아보기. 동의하면 \"동의\"를 클릭하여 서비스 수락을 시작하십시오.';

  @override
  String get and => ' \"및\" ';

  @override
  String get accept => '동의하기';

  @override
  String get takeBack => '되돌리기';

  @override
  String get takingBack => '되돌리는 중…';

  @override
  String get waiting => '기다리는 중…';

  @override
  String get stepForward => '한 단계 앞으로';

  @override
  String get takeBackAll => '모두 되돌리기';

  @override
  String get stepForwardAll => '모두 앞으로 가기';

  @override
  String get moveNow => '지금 이동하기';

  @override
  String get done => '완료.';

  @override
  String get crackMill => '연속된 곤을 파괴할 수 없습니다';

  @override
  String get crackMill_Detail => '플레이어가 곤에 있는 말만 가지고 있다면, 그 곤의 말들은 제거가 안됩니다.';

  @override
  String get animationDuration => '애니메이션 지속 시간';

  @override
  String get none => '없음';

  @override
  String get theme => '테마';

  @override
  String get helpContent =>
      '참고누는 매우 오래된 지적 게임으로, 게임의 목표는 상대방의 말을 3개 미만으로 만드는 것입니다.\n\n위치가 세 번 반복되거나 100번 연속 이동해도 \'꼰\'이 만들어지지 않으면 무승부로 판정됩니다.\n\n게임은 두 단계로 나뉩니다:\n\n1. 배치 단계: 빈 자리에 말을 두는 단계;\n2. 이동 단계: 말을 인접한 빈 위치로 이동하는 단계.\n\n배치 단계에서는 체스판에 24개의 빈 자리가 있습니다. 플레이어는 번갈아 가며 말을 빈 위치에 놓습니다. 한 쪽이 자신의 말을 세 개 연속으로 놓아 \'꼰\'을 형성하면, 상대방의 말 하나를 제거할 수 있습니다.\n\n배치 단계에서, 상대방 말을 제거하여 표시된 위치에는 이동 단계가 시작될 때까지 다시 말을 둘 수 없습니다. 양측이 말을 번갈아 가며 놓은 후, 모든 표시된 말을 제거하고 이동 단계로 넘어갑니다.\n\n이동 단계에서, 플레이어는 자신의 말을 인접한 빈 자리로 이동할 수 있습니다. 이동할 말이 없으면 패배합니다. 마찬가지로 \'꼰\'을 형성할 때 상대방의 말을 제거할 수 있습니다. 한 쪽이 말이 두 개만 남은 경우, 그 쪽은 패배하며 게임은 종료됩니다. 체스판에 3개 이상의 말이 있지만 이동할 말이 없는 경우에도 패배로 간주됩니다.\n';

  @override
  String get versionInfo => '버전 정보';

  @override
  String get eula => '최종 사용자 사용권 계약';

  @override
  String get license => '라이선스';

  @override
  String get sourceCode => '소스 코드';

  @override
  String get appVersion => '앱 버전';

  @override
  String get general => '일반';

  @override
  String get advanced => '고급';

  @override
  String get placing => '말 놓기';

  @override
  String get moving => '이동';

  @override
  String get removing => '말 제거';

  @override
  String get gameOverCondition => '게임 종료 조건';

  @override
  String get aisPlayStyle => 'AI의 플레이 스타일';

  @override
  String get passive => '수동적';

  @override
  String get timeout => '시간 초과';

  @override
  String get appearance => '외관 설정';

  @override
  String get drawOnHumanExperience => '인간 경험을 바탕으로';

  @override
  String get considerMobility => '말의 이동성 고려';

  @override
  String get pieceCount => '말의 수:';

  @override
  String inHand(Object player, int count) {
    return '$player의 손에: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player 보드 위에: $count';
  }

  @override
  String get boardTop => '보드 상단으로부터의 오프셋';

  @override
  String get notAIsTurn => 'AI의 차례가 아닙니다.';

  @override
  String get aiIsNotThinking => 'AI가 생각하고 있지 않습니다.';

  @override
  String get atEnd => '기보의 끝입니다.';

  @override
  String get tapBackAgainToLeave => '뒤로 버튼을 한 번 더 탭하여 나가기.';

  @override
  String get more => '더 보기';

  @override
  String get experimental => '실험적인 기능입니다.';

  @override
  String get experiments => '실험';

  @override
  String get ossLicenses => '오픈 소스 라이선스';

  @override
  String get language => '언어';

  @override
  String get defaultLanguage => '기본 언어';

  @override
  String get mayMoveInPlacingPhase => '말은 놓는 단계에서도 움직일 수 있습니다';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      '유 각기와 보행기 사이에는 엄격한 경계가 없습니다. 즉, 플레이어는 움직일 때마다 움직일 것인지 움직일 것인지 결정할 수 있습니다 (움직일 수있는 조각이 남아있는 한).';

  @override
  String get drawerColor => '메뉴 색상';

  @override
  String get drawerTextColor => '메뉴 텍스트 색상';

  @override
  String get drawerHighlightItemColor => '메뉴 강조 항목 색상';

  @override
  String get mainToolbarBackgroundColor => '주 도구모음 배경색';

  @override
  String get mainToolbarIconColor => '주 도구모음 아이콘 색상';

  @override
  String get navigationToolbarBackgroundColor => '탐색 도구모음 배경색';

  @override
  String get navigationToolbarIconColor => '탐색 도구모음 아이콘 색상';

  @override
  String get autoHideToolbar => '도구모음 자동 숨김';

  @override
  String get toolbarLocationOnScreen => '화면 상의 도구모음 위치';

  @override
  String get top => '상단';

  @override
  String get bottom => '하단';

  @override
  String get center => '중앙';

  @override
  String get solidColor => '단색';

  @override
  String get picture => '그림';

  @override
  String get chooseYourPicture => '사진 선택';

  @override
  String get light => '밝은';

  @override
  String get dark => '어두운';

  @override
  String get themes => '테마';

  @override
  String get currentTheme => '현재 테마';

  @override
  String get saveTheme => '테마 저장';

  @override
  String get showAnalysisGraph => '분석 그래프 보기';

  @override
  String get analysis => '분석';

  @override
  String get saveGame => '게임 저장';

  @override
  String get loadGame => '게임 로드';

  @override
  String get setupPosition => '배치 설정';

  @override
  String get showLegalMoves => '합법적 움직임 표시';

  @override
  String get showLastMove => '마지막 이동 표시';

  @override
  String get showArrows => '화살표 보기';

  @override
  String get pieces => '말들';

  @override
  String get showAnalysis => '분석 보기';

  @override
  String get threads => '스레드';

  @override
  String get getInvolved => '참여하기';

  @override
  String get helpImproveTranslate => '번역 개선 돕기';

  @override
  String get tutorial => '튜토리얼';

  @override
  String get classicMill => '클래식 참고누';

  @override
  String get mixedMill => '혼합 참고누';

  @override
  String get ceylonMill => '셀론 참고누';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      '\'곤\'이 부서졌다가 반복적으로 다시 만들어질 수 있습니다';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      '플레이어가 즉시 새 \'꼰\'을 만들기 위해 \'꼰\'을 부수는 경우, 그러한 플레이어는 새 \'꼰\'을 만드는 경우 다음 이동에서 그러한 말을 원래 위치로 다시 이동할 수 있습니다.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      '10번의 이동 후 양쪽 플레이어 모두 상대방 말을 제거하지 못하고 플레이어가 3개의 말을 가지고 있으면 게임은 무승부입니다';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      '플레이어가 말이 3개로 줄어들고 양쪽 모두 10번의 이동 안에 상대 말을 제거할 수 없는 경우, 게임은 무승부입니다.';

  @override
  String get close => '닫기';

  @override
  String get whitePiece => '흰색 말';

  @override
  String get blackPiece => '검은 말';

  @override
  String get emptyPoint => '비어 있는 점';

  @override
  String get noPoint => '점 없음';

  @override
  String get placingPhase => '말 놓기 단계';

  @override
  String get movingPhase => '이동 단계';

  @override
  String get flyingPhase => '날아다니기 단계';

  @override
  String sideToMove(Object player) {
    return '이동할 차례: $player';
  }

  @override
  String lastMove(Object move) {
    return '마지막 이동: $move';
  }

  @override
  String get selected => '선택됨';

  @override
  String get accessibility => '접근성';

  @override
  String get screenReaderSupport => '스크린 리더 지원';

  @override
  String get isDraw => '무승부입니다!';

  @override
  String get draw => '무승부';

  @override
  String get pieceHighlightColor => '말 하이라이트 색상';

  @override
  String get algorithm => '알고리즘';

  @override
  String get endgameNMoveRule => '엔드게임 N-무브 규칙';

  @override
  String get endgameNMoveRule_Detail =>
      '최소 한 편이 말이 세 개만 남았을 때, 양측이 연속으로 여러 번 움직여도 아무 말도 잡지 않으면, 무승부로 판정한다.';

  @override
  String get drawReasonEndgameRule50 =>
      '최소한 한 쪽이 말이 세 개만 남고, 양측이 여러 차례 연속으로 움직여도 아무 말도 잡지 않았다.';

  @override
  String get threefoldRepetitionRule => '삼중 반복 규칙';

  @override
  String get threefoldRepetitionRule_Detail =>
      '같은 배치가 세 번 발생하면 게임은 무승부로 선언됩니다.';

  @override
  String get continueToMakeMove => '곤! 계속해서 움직임을 실행하세요.';

  @override
  String get pointStyle => '교차점 스타일';

  @override
  String get pointWidth => '교차점의 크기';

  @override
  String get solid => '단단한';

  @override
  String get hollow => '구멍';

  @override
  String get languageName => '한국어';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 이동',
      one: '$count 이동',
      zero: '이동 없음',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => '불러오기 실패.';

  @override
  String get filename => '파일 이름';

  @override
  String get browse => '찾아보기…';

  @override
  String get gameFiles => '게임 파일';

  @override
  String get gameSavedTo => '게임이 저장됨';

  @override
  String get empty => '비어 있음';

  @override
  String get noMove => '이동 없음.';

  @override
  String get restoredPosition => '초기 위치 복원됨.';

  @override
  String get clean => '깨끗한';

  @override
  String get cleanedUp => '정돈됨.';

  @override
  String get remove => '제거하다';

  @override
  String get noPiecesCanBeRemoved => '말을 제거할 수 없습니다.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count개의 말',
      one: '$count개의 말',
      zero: 'Piece',
    );
    return '$_temp0을 제거해야 합니다.';
  }

  @override
  String placedCount(int count) {
    return '배치됨($count)';
  }

  @override
  String get placedPieceCount => '놓기 단계에서 놓인 말의 수입니다.';

  @override
  String hasPlacedPieceCount(int count) {
    return '현재 플레이어가 놓은 말의 수: $count';
  }

  @override
  String get notPlacingPhase => '말 놓기 단계가 아니므로 변경할 수 없습니다.';

  @override
  String get paste => '붙여넣기';

  @override
  String get pasteDone => '붙여넣기 완료.';

  @override
  String get cannotPaste => '붙여넣기 불가능.';

  @override
  String get isUnplacedAndRemovedPiecesShown => '놓이지 않은 말과 제거된 말 표시';

  @override
  String get fullScreen => '전체 화면';

  @override
  String get reopenToTakeEffect => '설정을 적용하려면 앱을 종료한 후 다시 시작하세요.';

  @override
  String get forest => '숲';

  @override
  String get desktopImage => '데스크탑 이미지';

  @override
  String get invalidPosition => '유효하지 않은 위치입니다.';

  @override
  String get shareGIF => 'GIF 공유하기';

  @override
  String get pixelRatio => '픽셀 비율';

  @override
  String get duration => '지속 시간';

  @override
  String get gameScreenRecorder => '게임 화면 녹화기';

  @override
  String get previous => '이전';

  @override
  String get next => '다음';

  @override
  String get skip => '건너뛰기';

  @override
  String get gotIt => '이해했습니다';

  @override
  String get youCanModifyRules => '규칙 설정에서 게임 규칙을 수정할 수 있습니다.';

  @override
  String get youCanUseMouseWheelInPicker => '선택기에서 마우스 휠로 값을 변경할 수 있습니다.';

  @override
  String get noTimeLimitForThinking => 'AI 생각 시간을 0으로 설정하면 생각할 시간 제한이 없습니다.';

  @override
  String get whatIsMtdf =>
      'MTD(f)는 중간 검색 결과를 재사용하고 좋은 초기 추정을 사용하여 검색 범위를 좁힘으로써 효율성을 향상시키려는 알파-베타 검색 알고리즘의 변형입니다.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'AI 사고 시간 조정이 완전히 정확하지 않을 수 있음을 유의하십시오. 실제 생각하는 시간은 난이도가 낮은 값으로 설정되어 있을 때 더 짧을 수 있고 시간이 다 되어 AI가 중간 생각일 때 더 길어질 수 있습니다.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      '난이도를 높게 설정했지만 AI 생각 시간을 늘리지 않으면 생각 시간 제약으로 인해 실제 난이도가 더 낮은 값으로 제한될 수 있습니다. 실제 값은 기계의 성능에 따라 다를 수 있습니다.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) 는 주어진 위치에서 최상의 움직임을 찾는 검색 알고리즘입니다. 이것은 알파-베타 알고리즘의 향상이며 null 또는 0 창 검색을 사용하여 이동이 기본 변동에서 이미 안전한 점수보다 더 나쁜지 또는 나쁘지 않은지 확인합니다. PVS는 가장 유망한 움직임에 집중하고 최적이 아닌 분기의 불필요한 검색을 피하여 검색의 효율성을 향상시킵니다.';

  @override
  String get whatIsAlphaBeta =>
      'Alpha-beta 알고리즘은 최상의 움직임을 찾는 검색 알고리즘입니다. 검색 트리를 가지치기하고 효율성을 높이기 위해 minimax 원리와 두 값(alpha와 beta)을 사용합니다. Alpha는 컴퓨터가 얻을 수 있다고 확신하는 최소 점수를 나타내고, beta는 상대방이 얻을 수 있는 최대 점수를 나타냅니다. 이 알고리즘은 컴퓨터가 게임에서 현명하고 효율적인 결정을 내리는 데 도움이 됩니다.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      '인간의 경험에 따르면 이기려고 하면 지게 됩니다. 대신 무승부를 목표로 삼고 게임에서 지지 않도록 하십시오. 상대방을 관찰하고 실수할 수 있는 위치로 부드럽게 유인합니다. 그들이 약점을 보일 때 기회를 잡고 부드럽게 승리를 위해 밀어붙입니다. 이런 식으로 게임에서 이길 수 있습니다.';

  @override
  String get firstMoveDetail => '이 게임에서 선수에 비해 후수가 승리하기가 더 쉽습니다.';

  @override
  String get passiveDetail =>
      '패시브 옵션을 활성화하면 AI가 유리한 위치에 있을 때 서두르기보다는 여유를 가지게 됩니다.';

  @override
  String get moveRandomlyDetail =>
      '이 옵션을 활성화하면 게임의 임의성과 재미가 증가하지만, 비활성화하면 AI를 이기는 방법을 연구하는 데 도움이 됩니다.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'AI가 자신의 말의 이동성을 고려하면 상대 말을 빠르게 잡으려고만 하는 것이 아니라 상대의 움직임을 차단하고 상대가 같은 것을 하는 것을 방지하는 것도 고려합니다.';

  @override
  String get whenBoardIsFull => '보드가 가득 차 있을 때';

  @override
  String get whenBoardIsFull_Detail =>
      '말 놓기 단계가 끝나고 이동 단계가 시작되기 전에 보드가 말로 가득 차 있다면, 다음 단계가 이어집니다.';

  @override
  String get sideToMoveRemovePiece => '이동 단계에서 먼저 움직이는 플레이어가 상대의 말 하나를 제거합니다.';

  @override
  String get agreeToDraw => '양쪽 모두 무승부에 동의합니다.';

  @override
  String get takeOpponentsPiece => '상대방의 말 하나를 가져옵니다.';

  @override
  String get firstPlayerLose => '첫 번째 플레이어가 게임에서 졌습니다.';

  @override
  String get firstAndSecondPlayerRemovePiece => '선수와 후수 모두 상대방의 말 하나를 제거합니다.';

  @override
  String get secondAndFirstPlayerRemovePiece => '후수와 선수 모두 상대방의 말 하나를 제거합니다.';

  @override
  String get enteredFlyingPhase =>
      '비행 단계에 접어들어 상대방의 말은 보드 어디든 빈 자리로 점프할 수 있습니다. \"규칙 설정\"에서 비행 규칙을 비활성화할 수 있습니다.';

  @override
  String get whenStalemate => '교착 상태일 때';

  @override
  String get whenStalemate_Detail => '말을 움직일 수 없을 때 어떤 조치가 이어지나요?';

  @override
  String get endWithStalemateLoss => '막힌 쪽은 교착 상태로 인해 패배로 끝납니다.';

  @override
  String get changeSideToMove => '이동할 면을 변경합니다.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      '상대방의 말 하나를 제거하고 다음 수를 둡니다.';

  @override
  String get endWithStalemateDraw => '무승부로 끝납니다.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      '상대방의 말 하나를 제거한 다음 상대방이 계속해서 말을 움직입니다.';

  @override
  String get aiResponseDelayTime => 'AI 응답 지연 시간';

  @override
  String get aiIsDelaying => 'AI가 현재 응답 지연 단계에 있으니, 진행하기 전에 잠시 기다려 주십시오.';

  @override
  String get tipCanNotRemoveNonadjacent => '인접하지 않은 말은 제거할 수 없습니다.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      '교착 상태일 경우, 곤 형성 여부와 상관없이 당신의 말과 인접한 상대 말을 제거할 수 있습니다.';

  @override
  String get whatIsMcts =>
      'MCTS는 시뮬레이션을 통해 다양한 수를 탐색하고 평가하여 결정을 내리는 초보자에게 친화적인 알고리즘입니다.';

  @override
  String get goldenJade => '골든 제이드';

  @override
  String get forestWood => '포레스트 우드';

  @override
  String get darkMystery => '다크 미스테리';

  @override
  String get midnightBlue => '자정 블루';

  @override
  String get greenForest => '초록 숲';

  @override
  String get greenMeadow => '녹색 초원';

  @override
  String get stonyPath => '돌길';

  @override
  String get pastelPink => '파스텔 핑크';

  @override
  String get turquoiseSea => '터키석 바다';

  @override
  String get violetDream => '바이올렛 드림';

  @override
  String get mintChocolate => '민트 초콜릿';

  @override
  String get skyBlue => '하늘색';

  @override
  String get playfulGarden => '장난기 많은 정원';

  @override
  String get whatIsRetrogradeAnalysis =>
      '역행 분석 알고리즘은 다중 값 역행 분석을 사용하여 다양한 시작 위치에서 최종 게임 데이터베이스를 구축한 다음 이 데이터베이스를 적용하여 게임 플레이를 최적화합니다. 이 접근 방식은 울트라 스트롱 솔루션 범주에 속합니다.';

  @override
  String get viewAlgorithmGuide => '이 알고리즘의 사용자 가이드를 보시겠습니까?';

  @override
  String get showPositionalAdvantageIndicator => '위치 우위 지시기 보기';

  @override
  String get usePerfectDatabase => '완벽한 데이터베이스 사용';

  @override
  String get perfectDatabaseDescription =>
      '이 옵션을 활성화하면 첨단 알고리즘을 통해 생성된 결점 없는 게임 데이터베이스를 사용할 수 있습니다. 이 기능은 개빈과 엔드게임 전략을 통합하여 최적의 수를 제안합니다. 게임플레이에서 최고 수준의 정확성을 추구하는 플레이어에게 이상적인 선택입니다. 세밀한 계산 기술을 통해 생성된 이 데이터베이스는 거의 완벽한 게임 솔루션을 제공하도록 설계되었습니다.\n\n주의: AI가 데이터베이스에 액세스하지 못할 경우, 게임플레이 결정을 위해 기존 알고리즘을 사용하게 됩니다. 데이터베이스가 사용 가능할 때 \'난이도 레벨\'은 사실상 이길 수 없는 수준이 되며, \'AI 생각 시간\'은 크게 줄어듭니다. \'AI의 플레이 스타일\' 옵션 내의 많은 설정이 데이터베이스 결과가 가장 높은 우선순위를 가지기 때문에 덮어쓰여집니다.\n\n이 완벽한 데이터베이스를 최대한 활용하는 방법에 대한 지침은 여기를 클릭하십시오.';

  @override
  String get backgroundImage => '배경 이미지';

  @override
  String get whatIsRandom =>
      '‘완벽한 데이터베이스 사용’ 옵션이 활성화되지 않았을 때, ‘랜덤’ 설정은 AI가 이동 선택 알고리즘을 사용하지 않고 임의로 말을 움직이게 합니다. 이는 일반적으로 훨씬 약한 게임 플레이를 초래합니다. 반대로 ‘완벽한 데이터베이스 사용’이 활성화되면 AI는 전통적인 AI 알고리즘과 혼합하는 대신 오로지 ‘완벽한 데이터베이스’에만 의존하여 결정을 내립니다. 이 모드에서 AI의 움직임은 데이터베이스의 내용에 전적으로 기반을 두고 있으며, 실시간 계산이나 검색 알고리즘에 의존하지 않습니다.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      '상대의 말을 손에서 제거한 후, 상대의 차례로 넘어갑니다.';

  @override
  String get whenFormingMillsDuringPlacingPhase => '배치 단계에서 참고누를 형성할 때';

  @override
  String get removeOpponentsPieceFromBoard => '보드에서 상대의 말을 제거합니다.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      '보드에서 상대의 말을 제거한 후, 상대의 차례로 넘어갑니다.';

  @override
  String get opponentRemovesOwnPiece => '상대는 보드에서 자신의 말을 제거합니다.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      '당신이 조치를 취하는 대신, 상대는 보드에서 자신의 말을 선택하여 제거함으로써 스스로에게 불리한 조치를 취합니다.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      '상대의 말을 손에서 제거한 후, 당신의 차례로 넘어갑니다.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      '상대의 손에서 말을 제거합니다. Multi-remove 설정에 따라 여러 말을 제거해야 하고 상대가 손에 남은 말이 없다면, 계속해서 보드에서 상대의 말을 제거합니다. 그 후, 당신의 차례로 넘어갑니다. 참고누를 계속 형성한다면, 계속해서 상대의 말을 제거할 수 있습니다.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      '상대의 손에서 말을 제거합니다. Multi-remove 설정에 따라 여러 말을 제거해야 하고 상대가 손에 남은 말이 없다면, 계속해서 보드에서 상대의 말을 제거합니다. 그 후, 상대의 차례로 넘어갑니다.';

  @override
  String get markAndDelayRemovingPieces => '말을 표시하고 제거를 지연합니다.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      '배치 단계에서 제거될 말은 표시되며, 두 플레이어 모두 이러한 점에 새로운 말을 놓을 수 없습니다. 이동 단계로 들어가면 이 표시된 말은 모두 함께 제거되며, 플레이어는 그 후 이제 비어 있는 점으로 말을 이동할 수 있습니다.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      '배치 단계에서 참고누를 형성할 때 취할 수 있는 조치들.';

  @override
  String get marked => '표시됨';

  @override
  String get menu => '메뉴';

  @override
  String get monochrome => '흑백의 세계';

  @override
  String get youCanEnableScreenReaderSupport =>
      '일반 설정의 접근성 구성에서 화면 읽기 지원을 켤 수 있습니다。';

  @override
  String get showNumbersOnPieces => '조각에 숫자 표시';

  @override
  String get saveImage => '이미지 저장';

  @override
  String get isAnalysisToolbarShown => '분석 툴바 표시';

  @override
  String get analysisToolbarBackgroundColor => '분석 툴바 배경색';

  @override
  String get analysisToolbarIconColor => '분석 툴바 아이콘 색상';

  @override
  String get transformed => '변환되었습니다.';

  @override
  String get cannotTransform => '변환할 수 없습니다.';

  @override
  String get rotate => '회전';

  @override
  String get horizontalFlip => '상하';

  @override
  String get verticalFlip => '좌우';

  @override
  String get innerOuterFlip => '내외';

  @override
  String get transparentCanvas => '투명 캔버스';

  @override
  String get restrictRepeatedMillsFormation => '반복적인 참고누 형성 제한';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      '한 참고누에서 다른 참고누를 형성하기 위해 움직인 말은 다음 턴에서 원래 지점으로 즉시 돌아와 다시 참고누를 형성할 수 없습니다. 먼저 다른 움직임이 필요합니다.';

  @override
  String get oneTimeUseMill => '일회용 참고누';

  @override
  String get oneTimeUseMill_Detail =>
      '각 참고누는 상대의 조각을 한 번만 제거할 수 있습니다. 다시 형성할 수 있지만 추가 제거에는 사용할 수 없습니다.';

  @override
  String get currentRulesNoPerfectDatabase =>
      '설정한 현재 규칙에 해당하는 완벽한 데이터베이스가 없습니다. 완벽한 데이터베이스에 대한 자세한 정보는 여기를 클릭하십시오.';

  @override
  String get focusOnBlockingPaths => '차단 경로에 집중';

  @override
  String get focusOnBlockingPaths_Detail =>
      '게임의 특정 단계에서는 참고누를 형성하는 것보다 상대방의 움직임을 방해하는 것을 우선시합니다. 참고누를 완성하여 조각을 제거하는 데 집중하는 대신, 이 단계에서 AI는 상대를 함정에 빠뜨리고 움직이지 못하게 하여 공격적인 플레이보다는 소모전을 통해 승리를 확보하는 것을 목표로 합니다. 이 단계별 전략은 상대의 참고누를 적극적으로 막지 않습니다.';

  @override
  String get pieceImage => '체스 말 이미지';

  @override
  String get importColorSettings => '색상 설정 가져오기';

  @override
  String get exportColorSettings => '색상 설정 내보내기';

  @override
  String get import => '가져오기';

  @override
  String get export => '내보내기';

  @override
  String get pleaseCopyJsonToClipboard => '먼저 JSON 형식 설정을 클립보드에 복사하십시오.';

  @override
  String get copiedToClipboard => '클립보드에 복사되었습니다.';

  @override
  String get imported => '가져왔습니다.';

  @override
  String get boardImage => '보드 이미지';

  @override
  String get autumnLeaves => '가을 잎';

  @override
  String get legendaryLand => '전설의 땅';

  @override
  String get vignetteEffect => '비네팅 효과';

  @override
  String get promptMakeToolbarTransparent =>
      '보드 배경 이미지가 설정되었을 때 도구 모음을 완전히 투명하게 만들겠습니까?';

  @override
  String get vibration => '게임에서 진동 활성화';

  @override
  String get soundTheme => '사운드 테마';

  @override
  String get ball => '공';

  @override
  String get liquid => '액체';

  @override
  String get wood => '목재';

  @override
  String get placeEffectAnimation => '말 놓기 애니메이션 효과';

  @override
  String get removeEffectAnimation => '말 제거 애니메이션 효과';

  @override
  String get isToolbarAtBottom => '도구 모음을 아래에 표시';

  @override
  String get boardCornerRadius => '보드 코너 반지름';

  @override
  String get useOpeningBook => '오프닝 북 사용';

  @override
  String get currentRule => '현재의';

  @override
  String get nineMensMorris => '나인 멘스 모리스';

  @override
  String get twelveMensMorris => '트웰브 멘스 모리스';

  @override
  String get morabaraba => '모라바라바';

  @override
  String get dooz => '두즈';

  @override
  String get chamGonu => '참고누';

  @override
  String get zhiQi => '직치';

  @override
  String get chengSanQi => '성삼치';

  @override
  String get mulMulan => '물뮬란';

  @override
  String get nerenchi => '네렌치';

  @override
  String get ruleSet => '규칙 세트';

  @override
  String get laskerMorris => '라스커 모리스';

  @override
  String get oneTimeMill => '원타임 밀';

  @override
  String get daSanQi => '다삼치';

  @override
  String get useOpeningBook_Detail =>
      '인공지능이 초기 게임에서 전문적인 인간 플레이어가 흔히 사용하는 오프닝 무브를 사용하도록 허용합니다. 참고: 이 기능은 현재 특정 규칙 세트에서만 사용 가능합니다.';

  @override
  String get showAdvantageGraph => '이점 그래프 표시';

  @override
  String get advantageGraphHint =>
      '장점 그래프는 AI가 수를 둔 후에만 그려집니다. 인간 플레이어가 수를 둘 때는 그려지지 않습니다.';

  @override
  String get removalBasedOnMillCounts =>
      '모든 말을 배치할 때까지 제거를 비활성화하십시오. 플레이어는 참고누 개수에 따라 말을 제거합니다.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      '모든 말을 배치할 때까지 제거를 비활성화하십시오. 플레이어는 참고누 개수에 따라 말을 제거합니다. 개수가 같다면, 두 플레이어 모두 동일한 수의 말을 제거합니다. 한 쪽이 더 많다면, 한 말을 추가로 제거하여 말의 차이를 하나로 유지합니다. 한 플레이어만 참고누를 만들었다면, 그 플레이어는 두 말을 제거하고 다른 쪽은 한 말을 제거합니다. 둘 다 참고누를 만들지 못했다면, 둘 다 한 말을 제거합니다.';

  @override
  String get elfilja => '엘 필자';

  @override
  String get tipSelectOwnPiece => '당신의 말 중 하나를 선택하세요.';

  @override
  String get notYourTurn => '당신의 차례가 아닙니다.';

  @override
  String get annotationToolbarBackgroundColor => '주석 도구 모음 배경색';

  @override
  String get annotationToolbarIconColor => '주석 도구 모음 아이콘 색상';

  @override
  String get isAnnotationToolbarShown => '주석 도구 모음 표시';

  @override
  String get enterAnnotationMode => '주석 모드로 들어가기';

  @override
  String get areYouSureYouWantToClearAllAnnotations => '모든 주석을 삭제하시겠습니까?';

  @override
  String get llmPromptCopiedToClipboard => 'LLM 프롬프트가 클립보드에 복사되었습니다.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      '연결이 거부되었습니다. 서버가 다운되었을 수 있습니다.';

  @override
  String get discoverySuccessfulAwaitingConnection => '검색 성공, 연결 대기 중...';

  @override
  String get noLanConnection => 'LAN 연결 없음';

  @override
  String get takeScreenshot => '스크린샷 찍기';

  @override
  String get disconnectedFromOpponent => '상대와의 연결이 끊어졌습니다.';

  @override
  String get takeBackRequest => '되돌리기 요청';

  @override
  String get nothingToShow => '표시할 내용이 없습니다.';

  @override
  String get stopHosting => '호스팅 중지';

  @override
  String get connectionResetByPeer => '연결이 상대방에 의해 초기화되었습니다.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      '하트비트 시간 초과로 연결이 끊어졌습니다. 다시 연결해주세요.';

  @override
  String get startHosting => '호스팅 시작';

  @override
  String get restartRequestRejected => '재시작 요청이 거부되었습니다.';

  @override
  String get notConnectedToLanOpponent => 'LAN 상대와 연결되지 않았습니다.';

  @override
  String get llmPrompt => 'LLM 프롬프트';

  @override
  String get gameRestarted => '게임이 재시작되었습니다.';

  @override
  String get takeBackRejected => '되돌리기 요청이 거부되었습니다.';

  @override
  String get areYouSureYouWantToResignThisGame => '이 게임에서 기권하시겠습니까?';

  @override
  String get opponentResignedYouWin => '상대가 기권했습니다. 당신이 이겼습니다!';

  @override
  String get clearAllAnnotations => '모든 주석 삭제';

  @override
  String get connectedWaitingForOpponentSMove => '연결됨, 상대의 수를 기다리는 중...';

  @override
  String get networkStatusDisconnected => '네트워크 상태: 연결 끊김';

  @override
  String get takeBackRequestSentToTheOpponent => '되돌리기 요청을 상대에게 보냈습니다.';

  @override
  String get theOpponentMayHaveLeftTheGame => '상대가 게임을 나갔을 수 있습니다.';

  @override
  String get connectedToHostSuccessfully => '호스트에 성공적으로 연결되었습니다.';

  @override
  String get connectionLostHeartbeatTimeout => '연결 끊김: 하트비트 시간 초과';

  @override
  String get noHostDiscovered => '검색된 호스트 없음.';

  @override
  String get confirmResignation => '기권 확인';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      '게임 호스팅 시작, 플레이어 참여 대기 중...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      '연결 시간이 초과되었습니다. 네트워크 연결이 불안정합니다.';

  @override
  String get noLlmPromptAvailable => '사용 가능한 LLM 프롬프트 없음.';

  @override
  String get youResignedGameOver => '당신이 기권했습니다. 게임 오버.';

  @override
  String get serverIp => '서버 IP';

  @override
  String get confirmClear => '삭제 확인';

  @override
  String get opponentSTurn => '상대의 차례입니다.';

  @override
  String get waitingAClientConnection => '클라이언트 연결 대기 중...';

  @override
  String get takeBackRequestWasRejectedOrFailed => '되돌리기 요청이 거부되었거나 실패했습니다.';

  @override
  String get addText => '텍스트 추가';

  @override
  String get exitAnnotationMode => '주석 모드 종료';

  @override
  String get typeYourAnnotation => '주석 입력';

  @override
  String get attemptingToReconnect => '다시 연결 시도 중...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      '재시작 요청 보냄. 상대의 응답 대기 중...';

  @override
  String get serverIsStopped => '서버가 중지되었습니다.';

  @override
  String get restartRequest => '재시작 요청';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      '당신의 차례가 아닐 때는 되돌리기를 요청할 수 없습니다.';

  @override
  String get takeBackAccepted => '되돌리기 요청이 승인되었습니다.';

  @override
  String get localNetworkSettings => '로컬 네트워크 설정';

  @override
  String get reconnectedSuccessfully => '성공적으로 다시 연결되었습니다!';

  @override
  String get failedToSaveImageToGallery => '이미지를 갤러리에 저장하는 데 실패했습니다.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      '상대가 게임 재시작을 요청했습니다. 수락하시겠습니까?';

  @override
  String get yourTurn => '당신의 차례입니다.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      '다시 연결할 수 없습니다. 게임을 재시작해주세요.';

  @override
  String get host => '호스트';

  @override
  String get join => '참여';

  @override
  String get port => '포트';

  @override
  String get invalidIpAddress => '잘못된 IP 주소입니다.';

  @override
  String get invalidPort => '잘못된 포트입니다.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return '연결 중: 시도 $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return '연결 실패: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return '호스팅 시작 실패: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return '호스트 발견: $ip:$port';
  }

  @override
  String get stop => '중지';

  @override
  String get discover => '검색';

  @override
  String get connect => '연결';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return '클라이언트 연결됨: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return '검색 중: $seconds초';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return '다시 연결 중 ($attempt/$maxAttempts)';
  }

  @override
  String get connected => '연결됨';

  @override
  String get delete => '삭제';

  @override
  String get ancientEgypt => '고구려의 신비';

  @override
  String get gothicIce => '설경의 고딕';

  @override
  String get riceField => '벼밭의 파도';

  @override
  String get chinesePorcelain => '청자의 운치';

  @override
  String get desertDusk => '모래언덕의 황혼';

  @override
  String get precisionCraft => '금세공의 정교';

  @override
  String get folkEmbroidery => '민화 자수';

  @override
  String get carpathianHeritage => '백두산의 숨결';

  @override
  String get imperialGrandeur => '왕실의 위용';

  @override
  String get bohemianCrystal => '조선 수정';

  @override
  String get savannaSunrise => '초원의 햇살';

  @override
  String get harmonyBalance => '음양의 조화';

  @override
  String get cinnamonSpice => '계피 향기';

  @override
  String get anatolianMosaic => '모란 모자이크';

  @override
  String get carnivalSpirit => '풍물 흥';

  @override
  String get custom => '관습';

  @override
  String get spiceMarket => '향신료 마을';

  @override
  String get swipeToRevealTheDrawer => '서랍을 표시하려면 스와이프하세요';

  @override
  String get showGameInfoOnScreenshots => '스크린샷에 게임 정보 표시';

  @override
  String get humanMoveTime => '사람 시간 제한';

  @override
  String get noTimeLimitForHumanMoves => '사람의 이동에는 시간 제한이 없습니다';

  @override
  String get timeoutLoseWillBeApplied => '사람 플레이어에게 시간 초과 패배가 적용됩니다';

  @override
  String get identifyingBoard => '보드를 식별하는 중…';

  @override
  String get youCanEnterAnyModelName => '원하는 모델 이름을 입력할 수 있습니다.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      '보드 위치가 적용되었습니다. FEN이 클립보드에 복사되었습니다.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      '제안: 보드의 더 선명한 사진을 찍어 보세요.';

  @override
  String get llmPromptTemplate => 'LLM 프롬프트 템플릿';

  @override
  String get noValidBoardDetected => '유효한 보드가 감지되지 않았습니다.';

  @override
  String get selectingImageFromAlbum => '앨범에서 이미지 선택 중…';

  @override
  String get configurePromptTemplate => '프롬프트 템플릿 구성';

  @override
  String get editPromptTemplateForLlmAnalysis => 'LLM 분석용 프롬프트 템플릿 수정';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      '인식된 보드에서 FEN 생성에 실패했습니다.';

  @override
  String get outputInCurrentLanguage => '현재 언어로 출력';

  @override
  String get commonBaseUrls => '자주 사용하는 Base URL';

  @override
  String get viewCommonModels => '자주 사용하는 모델 보기';

  @override
  String get recognitionParametersUpdated => '인식 매개변수가 업데이트되었습니다.';

  @override
  String get whiteSMove => '백의 차례';

  @override
  String get resetToDefaults => '기본값으로 재설정';

  @override
  String get photoShoot => '사진 촬영';

  @override
  String get failedToApplyRecognizedBoardPosition => '인식된 보드 위치 적용에 실패했습니다.';

  @override
  String get llmPromptContent => 'LLM 프롬프트 내용';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM이 구성되지 않았습니다. 설정을 확인하세요.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      '공급자, 모델, API Key 및 Base URL 설정';

  @override
  String get llmConfiguration => 'LLM 구성';

  @override
  String get configureLlmProvider => 'LLM 공급자 구성';

  @override
  String get llmPromptTemplateHeader => 'LLM 프롬프트 템플릿 헤더';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      '이미지에서 말을 인식하지 못했습니다. 다시 시도하세요.';

  @override
  String get recognizeBoardFromImage => '이미지에서 보드 인식';

  @override
  String get viewTips => '팁 보기';

  @override
  String get applyToBoard => '보드에 적용';

  @override
  String get adjustBoardArea => '보드 영역 조정';

  @override
  String get viewCommonUrls => '자주 사용하는 URL 보기';

  @override
  String get colorAnalysisFailed => '색상 분석 실패!';

  @override
  String get analyzingGameBoardImage => '게임 보드 이미지를 분석 중…';

  @override
  String get selectFromAlbum => '앨범에서 선택';

  @override
  String get noBoardPointDetected => '보드 포인트를 감지하지 못했습니다!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed => '비워두면 기본 템플릿이 사용됩니다';

  @override
  String get llmConfig => 'LLM 구성';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      '프롬프트 템플릿을 기본값으로 재설정하시겠습니까?';

  @override
  String get llmPromptTemplateFooter => 'LLM 프롬프트 템플릿 푸터';

  @override
  String get loadingResponse => '응답을 불러오는 중…';

  @override
  String get applyThisResultToBoard => '이 결과를 보드에 적용';

  @override
  String get takingPicture => '사진을 찍는 중…';

  @override
  String get pleaseSelectAGameBoardImageToIdentify => '식별할 게임 보드 이미지를 선택하세요';

  @override
  String get identificationResults => '식별 결과';

  @override
  String get analyzeTheMovesAndProvideInsights => '수들을 분석하고 인사이트를 제공하세요.';

  @override
  String get getApiKey => 'API Key 받기';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      '전체 인식 프로세스를 완료하지 못했습니다.';

  @override
  String get boardRecognitionResult => '보드 인식 결과';

  @override
  String get askLlm => 'LLM에 문의';

  @override
  String get boardDetectionFailed => '보드 감지에 실패했습니다!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      '보드 포인트를 감지하지 못해 말을 식별할 수 없습니다!';

  @override
  String get copyFen => 'FEN 복사';

  @override
  String get commonlyUsedModels => '자주 사용하는 모델';

  @override
  String get apiKeyOptional => 'API Key(선택 사항)';

  @override
  String get noImageSelected => '선택된 이미지가 없습니다';

  @override
  String get blackSMove => '흑의 차례';

  @override
  String get llm => '대규모 언어 모델';

  @override
  String get llmProvider => '제공자';

  @override
  String get baseUrl => '기본 URL';

  @override
  String get model => '모델';

  @override
  String get temperature => '온도';

  @override
  String get llmCommandReceivedProcessing => '명령을 받았습니다! AI가 처리 중...';

  @override
  String get llmDeepThinkingWait => '심층 사고 진행 중입니다. 잠시만 기다려주세요...';

  @override
  String get llmPresentingSoon => '곧 표시됩니다...';

  @override
  String get recognitionParameters => '인식 매개변수';

  @override
  String get adjustParamsDesc => '인식 정확도를 높이려면 매개변수를 조정하세요';

  @override
  String get saveParameters => '매개변수 저장';

  @override
  String unableToStartImageRecognition(String error) {
    return '이미지 인식을 시작할 수 없습니다: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return '이미지 인식이 실패했습니다: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return '$whiteCount개의 흰 돌과 $blackCount개의 검은 돌이 있는 위치를 적용했습니다';
  }

  @override
  String get fenCopiedToClipboard => '(FEN이 클립보드에 복사됨)';

  @override
  String recognitionFailed(String error) {
    return '인식 실패: $error';
  }

  @override
  String get myRating => '내 평점';

  @override
  String get gamesPlayed => '플레이한 게임';

  @override
  String get wins => '승리';

  @override
  String get losses => '패배';

  @override
  String get draws => '무승부';

  @override
  String get lastUpdated => '마지막 업데이트';

  @override
  String get format => '형식:';

  @override
  String get resetStatistics => '통계 초기화';

  @override
  String get drawRate => '무승부율';

  @override
  String get lossRate => '패배율';

  @override
  String get aiStatistics => 'AI 통계';

  @override
  String get enableStatistics => '통계 사용';

  @override
  String get enableStatistics_Detail =>
      '활성화하면 게임 결과가 통계에 기록됩니다. 단, 무르기가 포함된 게임은 기록되지 않습니다. 비활성화하면 통계 수집이 일시 중지됩니다.';

  @override
  String get thisWillResetAllGameStatistics =>
      '이렇게 하면 모든 게임 통계가 초기화됩니다. 이 작업은 취소할 수 없습니다.';

  @override
  String get boardInnerRingSize => '보드 내부 링 크기';

  @override
  String get boardShadowEnabled => '보드 그림자';

  @override
  String get trapAwareness => '함정 감지';

  @override
  String get trapAwarenessDescription => '분석 중 굵은 원과 화살표로 함정 수를 강조 표시합니다.';

  @override
  String trapExists(String trapMoves) {
    return '함정이 있습니다. 함정 수: $trapMoves';
  }

  @override
  String get custodianCapture => '측면 캡처';

  @override
  String get custodianCaptureDescription =>
      '상대방의 작품 중 하나를 둘 사이의 조각 중 하나를 직선으로 동봉하여 캡처하십시오.';

  @override
  String get custodianCaptureEnable => '측면 캡처를 허용하십시오';

  @override
  String get interventionCapture => '중재 캡처';

  @override
  String get interventionCaptureDescription =>
      '상대방의 두 조각 사이의 빈 지점으로 이동하여 둘 다 포착하십시오.';

  @override
  String get interventionCaptureEnable => '중재 캡처를 허용하십시오';

  @override
  String get leapCapture => '점프 캡처';

  @override
  String get leapCaptureDescription => '인접한 상대의 조각을 빈 지점 너머로 점프하여 캡처하십시오.';

  @override
  String get leapCaptureEnable => '점프 캡처를 허용하십시오';

  @override
  String get captureApplicableLines => '해당 라인';

  @override
  String get captureSquareEdges => '광장의 가장자리를 따라';

  @override
  String get captureCrossLines => '정사각형을 가로 지르는 직교 라인을 따라';

  @override
  String get captureDiagonalLines => '정사각형을 가로 지르는 대각선을 따라';

  @override
  String get captureExecutionPhases => '실행 단계';

  @override
  String get capturePiecesCondition => '남은 조각을 기준으로 이동 단계에서 가용성';

  @override
  String get capturePiecesConditionUnlimited => '제한이 없습니다';

  @override
  String get capturePiecesConditionSelfLeqThree => '3 개 이하의 조각이있을 때 사용할 수 있습니다';
}
