// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Kannada (`kn`).
class SKn extends S {
  SKn([String locale = 'kn']) : super(locale);

  @override
  String get appName => 'ನವಕಂಕರಿ';

  @override
  String get welcome => 'ಸ್ವಾಗತ';

  @override
  String get yes => 'ಹೌದು';

  @override
  String get no => 'ಇಲ್ಲ';

  @override
  String get game => 'ಆಟ';

  @override
  String get humanVsAi => 'ಯಂತ್ರವನ್ನು ಸವಾಲು ಮಾಡಿ';

  @override
  String get humanVsHuman => 'ಇಬ್ಬರು ಆಟಗಾರರ ಯುದ್ಧ';

  @override
  String get aiVsAi => 'ಯಂತ್ರದಿಂದ ಯಂತ್ರ';

  @override
  String get humanVsCloud => 'ಹ್ಯೂಮನ್ Vs. ಮೇಘ';

  @override
  String get humanVsLAN => 'ಹ್ಯೂಮನ್ Vs. ಲ್ಯಾನ್';

  @override
  String get testViaLAN => 'LAN ಮೂಲಕ ಪರೀಕ್ಷಿಸಿ';

  @override
  String get move => 'ಸರಿಸಿ';

  @override
  String get showMoveList => 'ಪಟ್ಟಿಯನ್ನು ಸರಿಸಿ';

  @override
  String get moveList => 'ಪಟ್ಟಿಯನ್ನು ಸರಿಸಿ';

  @override
  String get noGameRecord => 'ಯಾವುದೇ ದಾಖಲೆ ಇಲ್ಲ';

  @override
  String get ok => 'ಸರಿ';

  @override
  String get confirm => 'ದೃಢೀಕರಿಸಿ';

  @override
  String get cancel => 'ರದ್ದುಮಾಡಿ';

  @override
  String get tipSelectWrong => 'ತಪ್ಪು ತುಂಡು ಆಯ್ಕೆಮಾಡಿ.';

  @override
  String get tipPlace => 'ನಿಮ್ಮ ತುಣುಕುಗಳನ್ನು ಇರಿಸಿ.';

  @override
  String get tipBanPlace => 'ನೀವು ಅದನ್ನು ಇಲ್ಲಿ ಇರಿಸಲು ಸಾಧ್ಯವಿಲ್ಲ.';

  @override
  String get tipPlaced => 'ನೀವು ಇರಿಸಿದ್ದೀರಿ.';

  @override
  String get tipRemove => 'ತುಂಡು ತೆಗೆದುಹಾಕಿ.';

  @override
  String get tipBanRemove => 'ನೀವು ಅದನ್ನು ತೆಗೆದುಹಾಕಲು ಸಾಧ್ಯವಿಲ್ಲ.';

  @override
  String get tipRemoved => 'ನೀವು ತೆಗೆದುಹಾಕಿದ್ದೀರಿ.';

  @override
  String get tipMove => 'ತುಂಡು ಸರಿಸಿ.';

  @override
  String get tipCannotPlace => 'ನಿಮ್ಮ ತುಂಡನ್ನು ಇಲ್ಲಿ ಇರಿಸಲು ಸಾಧ್ಯವಿಲ್ಲ.';

  @override
  String get tipCannotMove => 'ನಿಮ್ಮ ತುಂಡನ್ನು ಇಲ್ಲಿಗೆ ಸರಿಸಲು ಸಾಧ್ಯವಿಲ್ಲ.';

  @override
  String get tipMill => 'ಮಿಲ್! ನಿಮ್ಮ ಎದುರಾಳಿಯ ತುಂಡನ್ನು ತೆಗೆದುಕೊಳ್ಳಿ.';

  @override
  String get tipContinueMill =>
      'ನಿಮ್ಮ ಎದುರಾಳಿಯ ತುಣುಕನ್ನು ತೆಗೆದುಕೊಳ್ಳುವುದನ್ನು ಮುಂದುವರಿಸಿ.';

  @override
  String get tipSelectOpponentsPiece =>
      'ನಿಮ್ಮ ಎದುರಾಳಿಯ ತುಣುಕುಗಳಲ್ಲಿ ಒಂದನ್ನು ಆಯ್ಕೆಮಾಡಿ.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'ನೀವು ಗಿರಣಿಯಿಂದ ತುಂಡನ್ನು ತೆಗೆದುಹಾಕಲು ಸಾಧ್ಯವಿಲ್ಲ.';

  @override
  String get tipCanMoveOnePoint => 'ಒಂದು ತುಂಡು 1 ಬಿಂದುವನ್ನು ಚಲಿಸಬಹುದು.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'ನಿಮ್ಮ ಎದುರಾಳಿಯ ತುಣುಕುಗಳನ್ನು ನೀವು ಸರಿಸಲು ಸಾಧ್ಯವಿಲ್ಲ.';

  @override
  String get tipSelectPieceToMove => 'ಸರಿಸಲು ನಿಮ್ಮ ತುಣುಕು ಆಯ್ಕೆಮಾಡಿ.';

  @override
  String get tipHaveThreePiecesLeft => 'ನಿಮ್ಮ ಬಳಿ ಮೂರು ತುಂಡುಗಳು ಉಳಿದಿವೆ.';

  @override
  String get tipCanMoveToAnyPoint =>
      'ನೀವು ಇಷ್ಟಪಡುವ ಯಾವುದೇ ಹಂತಕ್ಕೆ ನೀವು ಚಲಿಸಬಹುದು.';

  @override
  String tipToMove(Object player) {
    return 'ಸರಿಸಲು $player.';
  }

  @override
  String get whiteWin => 'ಆಟಗಾರ 1 ಗೆಲುವುಗಳು!';

  @override
  String get blackWin => 'ಆಟಗಾರ 2 ಗೆಲುವುಗಳು!';

  @override
  String get won => 'ಗೆದ್ದಿದೆ';

  @override
  String get lost => 'ಕಳೆದುಹೋಯಿತು';

  @override
  String get thinking => 'ಆಲೋಚನೆ…';

  @override
  String get newGame => 'ಹೊಸ ಆಟ';

  @override
  String get importGame => 'ಆಟವನ್ನು ಆಮದು ಮಾಡಿ';

  @override
  String get exportGame => 'ರಫ್ತು ಆಟ';

  @override
  String get gameImported => 'ಆಟವನ್ನು ಆಮದು ಮಾಡಲಾಗಿದೆ.';

  @override
  String cannotImport(Object invalidMove) {
    return 'ಆಮದು ಮಾಡಲು ಸಾಧ್ಯವಿಲ್ಲ $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch =>
      'ಚಲನೆಗಳು ಮತ್ತು ನಿಯಮಗಳು ಹೊಂದಿಕೆಯಾಗುವುದಿಲ್ಲ.';

  @override
  String get pleaseWait => 'ದಯಮಾಡಿ ನಿರೀಕ್ಷಿಸಿ.';

  @override
  String get restartGame => 'ಪ್ರಸ್ತುತ ಆಟವನ್ನು ಮರುಪ್ರಾರಂಭಿಸುವುದೇ?';

  @override
  String get restart => 'ಪುನರಾರಂಭದ';

  @override
  String get gameStarted => 'ಆಟ ಪ್ರಾರಂಭವಾಯಿತು, ದಯವಿಟ್ಟು ಇರಿಸಿ.';

  @override
  String get analyzing => 'ವಿಶ್ಲೇಷಿಸಲಾಗುತ್ತಿದೆ…';

  @override
  String error(Object message) {
    return 'ದೋಷ: $message';
  }

  @override
  String get winRate => 'ಗೆಲುವಿನ ದರ';

  @override
  String get score => 'ಸ್ಕೋರ್:';

  @override
  String get white => 'ಆಟಗಾರ 1';

  @override
  String get black => 'ಆಟಗಾರ 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player ತುಂಡು ಎಣಿಕೆ ಮೂರಕ್ಕಿಂತ ಕಡಿಮೆ.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player ರಾಜೀನಾಮೆ.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player ಹೋಗಲು ಯಾವುದೇ ಮಾರ್ಗವಿಲ್ಲ.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'ಬೋರ್ಡ್ ತುಂಬಿದೆ ಮತ್ತು $player ಹೋಗಲು ಯಾವುದೇ ಮಾರ್ಗವಿಲ್ಲ.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'ಸಮಯ ಮುಗಿದಿದೆ, $player ಕಳೆದುಹೋಗಿದೆ.';
  }

  @override
  String get drawReasonRule50 =>
      'ಚಲಿಸುವ ಹಂತದಲ್ಲಿ, ಕೊನೆಯ ನಿರ್ದಿಷ್ಟ ಸಂಖ್ಯೆಯ ಚಲನೆಗಳಲ್ಲಿ ಯಾವುದೇ ತುಣುಕನ್ನು ತೆಗೆದುಹಾಕಲಾಗಿಲ್ಲ.';

  @override
  String get drawReasonBoardIsFull => 'ಬೋರ್ಡ್ ತುಂಬಿರುವುದರಿಂದ ಇದು ಡ್ರಾ ಆಗಿದೆ.';

  @override
  String get drawReasonThreefoldRepetition =>
      'ಮೂರು ಪಟ್ಟು ಪುನರಾವರ್ತನೆಯಿಂದಾಗಿ ಇದು ಡ್ರಾ ಆಗಿದೆ.';

  @override
  String get gameOverUnknownReason => 'ಗೇಮ್ ಓವರ್! ಅಜ್ಞಾತ ಕಾರಣ.';

  @override
  String get gameOver => 'ಗೇಮ್ ಓವರ್';

  @override
  String get youWin => 'ನೀವು ಗೆಲ್ಲುತ್ತೀರಿ! ಅಭಿನಂದನೆಗಳು!';

  @override
  String challengeHarderLevel(int level) {
    return 'ಕಠಿಣ ಮಟ್ಟದ ಸವಾಲು? ಹೊಸ ಹಂತವು $level ಮಟ್ಟವಾಗಿರುತ್ತದೆ!';
  }

  @override
  String get youLose => 'ನೀವು ಕಳೆದುಕೊಳ್ಳುತ್ತೀರಿ!';

  @override
  String get analyze => 'ವಿಶ್ಲೇಷಿಸಿ';

  @override
  String get about => 'ಬಗ್ಗೆ';

  @override
  String version(Object versionNumber) {
    return 'ಆವೃತ್ತಿ: $versionNumber';
  }

  @override
  String get thanks => 'ಧನ್ಯವಾದಗಳು';

  @override
  String get settings => 'ಸಂಯೋಜನೆಗಳು';

  @override
  String get options => 'ಆಯ್ಕೆಗಳು';

  @override
  String get generalSettings => 'ಸಾಮಾನ್ಯ ಸೆಟ್ಟಿಂಗ್ಗಳು';

  @override
  String get skillLevel => 'ತೊಂದರೆ ಮಟ್ಟ';

  @override
  String get moveTime => 'AI ಆಲೋಚನಾ ಸಮಯ';

  @override
  String get difficulty => 'ತೊಂದರೆ';

  @override
  String get playSounds => 'ಧ್ವನಿ ಪರಿಣಾಮಗಳು';

  @override
  String get playSoundsInTheGame => 'ಆಟದಲ್ಲಿ ಶಬ್ದಗಳನ್ನು ಪ್ಲೇ ಮಾಡಿ';

  @override
  String get keepMuteWhenTakingBack => 'ಹಿಂತಿರುಗುವಾಗ ಮ್ಯೂಟ್ ಮಾಡಿ';

  @override
  String get tone => 'ಸ್ವರ';

  @override
  String get whoMovesFirst => 'ಮೊದಲ ನಡೆ';

  @override
  String get human => 'ಮಾನವ';

  @override
  String get ai => 'ಎಐ';

  @override
  String get alternate => 'ಪರ್ಯಾಯ';

  @override
  String get isAutoRestart => 'ಆಟ ಮುಗಿದ ನಂತರ ಆಟವನ್ನು ಮರುಪ್ರಾರಂಭಿಸಿ';

  @override
  String get isAutoChangeFirstMove => 'ಸ್ವಯಂ ಬದಲಾವಣೆ ಮೊದಲ ಚಲನೆ';

  @override
  String get shufflingEnabled => 'ಯಾದೃಚ್ ly ಿಕವಾಗಿ ಸರಿಸಿ';

  @override
  String get misc => 'ವಿವಿಧ';

  @override
  String get rules => 'ನಿಯಮಗಳು';

  @override
  String get piecesCount => 'ಪ್ರತಿ ಆಟಗಾರನು ಹೊಂದಿರುವ ತುಣುಕುಗಳ ಸಂಖ್ಯೆ';

  @override
  String get piecesCount_Detail => 'ಪ್ರತಿ ಆಟಗಾರನಿಗೆ ಎಷ್ಟು ತುಣುಕುಗಳಿವೆ?';

  @override
  String get flyPieceCount => 'ಹಾರುವ ತುಂಡುಗಳ ಸಂಖ್ಯೆ';

  @override
  String get flyPieceCount_Detail =>
      'ಫ್ಲೈಯಿಂಗ್ ಅನ್ನು ಸಕ್ರಿಯಗೊಳಿಸಿದ್ದರೆ, ಆಟಗಾರನನ್ನು ನಿರ್ದಿಷ್ಟ ತುಂಡು ಎಣಿಕೆಗೆ ಇಳಿಸಿದಾಗ, ಆಕೆಯ ತುಣುಕುಗಳು ಆಟದ ಉಳಿದ ಭಾಗಗಳಂತೆ ಪಕ್ಕದ ಬಿಂದುಗಳಿಗೆ ಸೀಮಿತವಾಗುವ ಬದಲು ಯಾವುದೇ ಖಾಲಿ ಇಲ್ಲದ ಸ್ಥಳಕ್ಕೆ ಹೋಗಲು ಮುಕ್ತವಾಗಿರುತ್ತದೆ.';

  @override
  String get piecesAtLeastCount => 'ಕನಿಷ್ಠ ತುಣುಕುಗಳು';

  @override
  String get hasDiagonalLines => 'ಕರ್ಣೀಯ ರೇಖೆಗಳು';

  @override
  String get hasDiagonalLines_Detail =>
      'ಬೋರ್ಡ್‌ಗೆ ನಾಲ್ಕು ಕರ್ಣೀಯ ರೇಖೆಗಳನ್ನು ಸೇರಿಸಿ.';

  @override
  String get isDefenderMoveFirst => 'ಎರಡನೇ ಆಟಗಾರನು ಮೊದಲು ಚಲಿಸುತ್ತಾನೆ';

  @override
  String get isDefenderMoveFirst_Detail =>
      'ಇರಿಸುವ ಹಂತದಲ್ಲಿ ಎರಡನೇ ಸ್ಥಾನಕ್ಕೆ ಚಲಿಸುವ ಆಟಗಾರನು ಚಲಿಸುವ ಹಂತದಲ್ಲಿ ಮೊದಲು ಚಲಿಸುತ್ತಾನೆ.';

  @override
  String get mayRemoveMultiple => 'ಬಹು-ತೆಗೆದುಹಾಕಿ';

  @override
  String get mayRemoveMultiple_Detail =>
      'ಒಬ್ಬ ಆಟಗಾರನು ಒಂದಕ್ಕಿಂತ ಹೆಚ್ಚು ಗಿರಣಿಗಳನ್ನು ಏಕಕಾಲದಲ್ಲಿ ಮುಚ್ಚಿದರೆ, ಅವಳು ಮುಚ್ಚಿದ ಗಿರಣಿಗಳ ಸಂಖ್ಯೆಯನ್ನು ಅವಳು ತೆಗೆದುಹಾಕುತ್ತಾಳೆ.';

  @override
  String get mayRemoveFromMillsAlways => 'ಗಿರಣಿಗಳನ್ನು ನಾಶಮಾಡಿ';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'ಪೂರ್ವನಿಯೋಜಿತವಾಗಿ, ರೂಪುಗೊಂಡ ಗಿರಣಿಯಿಂದ ತುಂಡನ್ನು ತೆಗೆದುಹಾಕುವ ಮೊದಲು ಆಟಗಾರರು ಮೊದಲು ಬೇರೆ ಯಾವುದೇ ತುಣುಕುಗಳನ್ನು ತೆಗೆದುಹಾಕಬೇಕು. ಮಿತಿಯನ್ನು ನಿಷ್ಕ್ರಿಯಗೊಳಿಸಲು ಈ ಆಯ್ಕೆಯನ್ನು ಸಕ್ರಿಯಗೊಳಿಸಿ.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'ಬೋರ್ಡ್ ತುಂಬಿದಾಗ ಎರಡನೇ ಆಟಗಾರನು ಕಳೆದುಕೊಳ್ಳುತ್ತಾನೆ';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'ಇರಿಸುವ ಹಂತದ ಕೊನೆಯಲ್ಲಿ ಬೋರ್ಡ್ ತುಂಬಿದಾಗ, ಮೊದಲು ಇಡುವ ಭಾಗವು ಆಟವನ್ನು ಕಳೆದುಕೊಳ್ಳುತ್ತದೆ. ಇಲ್ಲದಿದ್ದರೆ, ಆಟವು ಡ್ರಾ ಆಗಿದೆ.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'ಯಾವುದೇ ಕಾನೂನು ಕ್ರಮಗಳಿಲ್ಲದಿದ್ದಾಗ ಕಳೆದುಕೊಳ್ಳಿ';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'ಅವರ ಎದುರಾಳಿಯು ಅವರನ್ನು ಸರಿಸಲಾಗದಂತೆ ನಿರ್ಬಂಧಿಸಿದರೆ ಆಟಗಾರನು ಕಳೆದುಕೊಳ್ಳುತ್ತಾನೆ. ಈ ಆಯ್ಕೆಯನ್ನು ನಿಷ್ಕ್ರಿಯಗೊಳಿಸಿದ್ದರೆ ಸರಿಸಲು ಸೈಡ್ ಬದಲಾಯಿಸಿ.';

  @override
  String get mayFly => 'ಹಾರುವ';

  @override
  String get mayFly_Detail =>
      'ಆಟಗಾರನಿಗೆ ಕೇವಲ ಮೂರು ಅಥವಾ ನಾಲ್ಕು (ಕಾನ್ಫಿಗರ್ ಮಾಡಬಹುದಾದ) ತುಣುಕುಗಳು ಮಾತ್ರ ಉಳಿದಿದ್ದರೆ, ಅವಳು ಆ ತುಂಡನ್ನು ಯಾವುದೇ ಉಚಿತ ಬಿಂದುವಿಗೆ ಸರಿಸಬಹುದು.';

  @override
  String get nMoveRule => 'ಎನ್-ಮೂವ್ ನಿಯಮ';

  @override
  String get nMoveRule_Detail =>
      'ನಿರ್ದಿಷ್ಟ ಸಂಖ್ಯೆಯ ಚಲನೆಗಳಲ್ಲಿ ಯಾವುದೇ ತೆಗೆದುಹಾಕುವಿಕೆ ಇಲ್ಲದಿದ್ದರೆ ಆಟವನ್ನು ಎಳೆಯಲಾಗುತ್ತದೆ.';

  @override
  String get rollback => 'ರೋಲ್ಬ್ಯಾಕ್';

  @override
  String get pleaseSelect => 'ದಯವಿಟ್ಟು ಆಯ್ಕೆ ಮಾಡು';

  @override
  String get copy => 'ನಕಲಿಸಿ';

  @override
  String get moveHistoryCopied => 'ಕ್ಲಿಪ್‌ಬೋರ್ಡ್‌ಗೆ ನಕಲಿಸಿದ ಇತಿಹಾಸವನ್ನು ಸರಿಸಿ.';

  @override
  String get help => 'ಸಹಾಯ';

  @override
  String get feedback => 'ಪ್ರತಿಕ್ರಿಯೆ';

  @override
  String get exit => 'ನಿರ್ಗಮಿಸಿ';

  @override
  String get ruleSettings => 'ನಿಯಮಗಳು';

  @override
  String get color => 'ಬಣ್ಣ';

  @override
  String get boardColor => 'ಬೋರ್ಡ್ ಬಣ್ಣ';

  @override
  String get pieceColor => 'ತುಂಡು ಬಣ್ಣ';

  @override
  String get backgroundColor => 'ಹಿನ್ನೆಲೆ ಬಣ್ಣ';

  @override
  String get lineColor => 'ಬೋರ್ಡ್ ಲೈನ್ ಬಣ್ಣ';

  @override
  String get whitePieceColor => 'ಪ್ಲೇಯರ್ 1 ತುಂಡು ಬಣ್ಣ';

  @override
  String get blackPieceColor => 'ಪ್ಲೇಯರ್ 2 ತುಂಡು ಬಣ್ಣ';

  @override
  String get messageColor => 'ಸಂದೇಶದ ಬಣ್ಣ';

  @override
  String get isPieceCountInHandShown => 'ಕೈಯಲ್ಲಿರುವ ತುಂಡುಗಳ ಸಂಖ್ಯೆಯನ್ನು ತೋರಿಸಿ';

  @override
  String get isNotationsShown => 'ಸಂಕೇತಗಳನ್ನು ಮಂಡಳಿಯಲ್ಲಿ ತೋರಿಸಿ';

  @override
  String get isHistoryNavigationToolbarShown =>
      'ಇತಿಹಾಸ ನ್ಯಾವಿಗೇಷನ್ ಟೂಲ್‌ಬಾರ್ ತೋರಿಸಿ';

  @override
  String get display => 'ಪ್ರದರ್ಶನ';

  @override
  String get boardBorderLineWidth => 'ಬೋರ್ಡ್ ಗಡಿರೇಖೆಯ ಅಗಲ';

  @override
  String get boardInnerLineWidth => 'ಬೋರ್ಡ್ ಆಂತರಿಕ ರೇಖೆಯ ಅಗಲ';

  @override
  String get pieceWidth => 'ತುಂಡು ಅಗಲ';

  @override
  String get fontSize => 'ಅಕ್ಷರ ಗಾತ್ರ';

  @override
  String get standardNotation => 'WMD ಸಂಕೇತ';

  @override
  String get restore => 'ಮರುಸ್ಥಾಪಿಸಿ';

  @override
  String get restoreDefaultSettings => 'ಡೀಫಾಲ್ಟ್ ಸೆಟ್ಟಿಂಗ್‌ಗಳನ್ನು ಮರುಸ್ಥಾಪಿಸಿ';

  @override
  String pick(Object element) {
    return '$element ಅನ್ನು ಆರಿಸಿ';
  }

  @override
  String get info => 'ಮಾಹಿತಿ';

  @override
  String get hint => 'ಸುಳಿವು';

  @override
  String get player => 'ಆಟಗಾರ';

  @override
  String get player1 => 'ಆಟಗಾರ 1';

  @override
  String get player2 => 'ಆಟಗಾರ 2';

  @override
  String get howToPlay => 'ಹೇಗೆ ಆಡುವುದು';

  @override
  String get toPlacePiece =>
      'ತುಂಡು ಇರಿಸಲು ಲಭ್ಯವಿರುವ ಯಾವುದೇ ಬಿಂದುವನ್ನು ಟ್ಯಾಪ್ ಮಾಡಿ.';

  @override
  String get toSelectPiece => 'ತುಂಡು ಸರಿಸಲು ಅದನ್ನು ಟ್ಯಾಪ್ ಮಾಡಿ.';

  @override
  String get toMovePiece =>
      'ತುಂಡನ್ನು ಸರಿಸಲು ಅದನ್ನು ಸಂಪರ್ಕಿಸಿರುವ ಬಿಂದುವನ್ನು ಟ್ಯಾಪ್ ಮಾಡಿ.';

  @override
  String get toRemovePiece => 'ತೆಗೆದುಹಾಕಲು ಎದುರಾಳಿಯ ಒಂದು ತುಂಡು ಟ್ಯಾಪ್ ಮಾಡಿ.';

  @override
  String get needToCreateMillFirst =>
      'ನೀವು ತುಂಡನ್ನು ತೆಗೆದುಹಾಕುವ ಮೊದಲು ನೀವು ಮೊದಲು ಗಿರಣಿಯನ್ನು ರಚಿಸಬೇಕಾಗಿದೆ.';

  @override
  String get needToPlayWithOwnPieces => 'ನಿಮ್ಮ ತುಣುಕುಗಳೊಂದಿಗೆ ನೀವು ಆಡಬೇಕಾಗಿದೆ.';

  @override
  String get statistics => 'ಅಂಕಿಅಂಶಗಳು';

  @override
  String get totalGames => 'ಒಟ್ಟು ಆಟಗಳು';

  @override
  String get results => 'ಫಲಿತಾಂಶಗಳು';

  @override
  String get left => 'ಎಡ';

  @override
  String get privacyPolicy => 'ಗೌಪ್ಯತಾ ನೀತಿ';

  @override
  String get privacyPolicy_Detail_1 =>
      'ದಯವಿಟ್ಟು ಎಚ್ಚರಿಕೆಯಿಂದ ಓದಿ ಮತ್ತು ನೀವು ಇದನ್ನು ಸಂಪೂರ್ಣವಾಗಿ ಅರ್ಥಮಾಡಿಕೊಂಡಿದ್ದೀರಿ ಮತ್ತು ಒಪ್ಪುತ್ತೀರಿ ಎಂದು ಖಚಿತಪಡಿಸಿಕೊಳ್ಳಿ ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. ಈ ನೀತಿಯನ್ನು ನೀವು ಒಪ್ಪದಿದ್ದರೆ, ದಯವಿಟ್ಟು ಈ ಅಪ್ಲಿಕೇಶನ್ ಅನ್ನು ಬಳಸಬೇಡಿ. ಅಪ್ಲಿಕೇಶನ್ ಬಳಸುವುದರಿಂದ ನೀವು ಈ ನಿಯಮಗಳನ್ನು ಒಪ್ಪುತ್ತೀರಿ ಎಂದು ಸೂಚಿಸುತ್ತದೆ.';

  @override
  String get and => ' ಮತ್ತು ';

  @override
  String get accept => 'ಒಪ್ಪಿಕೊಳ್ಳಿ';

  @override
  String get takeBack => 'ಹಿಂಪಡೆ ಹಿಂದಕ್ಕೆ ಪಡೆ';

  @override
  String get takingBack => 'ಹಿಂದಕ್ಕೆ ತೆಗೆದುಕೊಳ್ಳುವುದು…';

  @override
  String get waiting => 'ಕಾಯಲಾಗುತ್ತಿದೆ…';

  @override
  String get stepForward => 'ಮುಂದೆ ಹೆಜ್ಜೆ ಹಾಕಿ';

  @override
  String get takeBackAll => 'ಎಲ್ಲವನ್ನೂ ಹಿಂದಕ್ಕೆ ತೆಗೆದುಕೊಳ್ಳಿ';

  @override
  String get stepForwardAll => 'ಎಲ್ಲವನ್ನು ಮುಂದಕ್ಕೆ ಇರಿಸಿ';

  @override
  String get moveNow => 'ಈಗ ಸರಿಸಿ';

  @override
  String get done => 'ಮುಗಿದಿದೆ.';

  @override
  String get crackMill => 'ಕ್ರ್ಯಾಕ್-ಗಿರಣಿ';

  @override
  String get crackMill_Detail =>
      'ಆಟಗಾರನು ಗಿರಣಿಗಳಲ್ಲಿ ಮಾತ್ರ ತುಣುಕುಗಳನ್ನು ಹೊಂದಿದ್ದರೆ, ಗಿರಣಿಗಳಲ್ಲಿನ ತುಣುಕುಗಳನ್ನು ತೆಗೆದುಹಾಕಲು ಲಾಕ್ ಆಗುವುದಿಲ್ಲ.';

  @override
  String get animationDuration => 'ಅನಿಮೇಷನ್ ಅವಧಿ';

  @override
  String get none => 'ಯಾವುದೂ';

  @override
  String get theme => 'ಥೀಮ್';

  @override
  String get helpContent =>
      'ಆಟದ ಎದುರಾಳಿಯನ್ನು ಮೂರು ತುಣುಕುಗಳಿಗಿಂತ ಕಡಿಮೆ ಅಥವಾ ಯಾವುದೇ ಕಾನೂನು ಕ್ರಮಗಳಿಲ್ಲದೆ ಬಿಡುವ ಗುರಿ ಹೊಂದಿದೆ.\n\nಸ್ಥಾನವು ಮೂರನೇ ಬಾರಿಗೆ ಸಂಭವಿಸಿದಲ್ಲಿ ಅಥವಾ ಕೊನೆಯ 100 (ಕಾನ್ಫಿಗರ್ ಮಾಡಬಹುದಾದ) ಚಲನೆಗಳಲ್ಲಿ ಯಾವುದೇ ತೆಗೆದುಹಾಕದಿದ್ದಲ್ಲಿ ಆಟವು ಸ್ವಯಂಚಾಲಿತವಾಗಿ ಸೆಳೆಯುತ್ತದೆ.\n\nಆಟವು ಮೂರು ಹಂತಗಳಲ್ಲಿ ಮುಂದುವರಿಯುತ್ತದೆ:\n\n1. ಖಾಲಿ ಇರುವ ಸ್ಥಳಗಳಲ್ಲಿ ತುಂಡುಗಳನ್ನು ಇಡುವುದು\n2. ತುಂಡುಗಳನ್ನು ಪಕ್ಕದ ಬಿಂದುಗಳಿಗೆ ಸರಿಸುವುದು\n3. (ಐಚ್ al ಿಕ ಹಂತ) ಆಟಗಾರನನ್ನು ಮೂರು ತುಂಡುಗಳಾಗಿ ಕಡಿಮೆ ಮಾಡುವಾಗ ಯಾವುದೇ ಖಾಲಿ ಬಿಂದುವಿಗೆ ತುಂಡುಗಳನ್ನು ಚಲಿಸುವುದು\n\nಇಡುವುದು\n\nಆಟವು ಖಾಲಿ ಬೋರ್ಡ್‌ನೊಂದಿಗೆ ಪ್ರಾರಂಭವಾಗುತ್ತದೆ, ಇದು ಇಪ್ಪತ್ನಾಲ್ಕು ಅಂಕಗಳನ್ನು ಹೊಂದಿರುವ ಗ್ರಿಡ್ ಅನ್ನು ಹೊಂದಿರುತ್ತದೆ. ಪ್ರತಿ ಆಟಗಾರನು ಎಲ್ಲಾ ತುಣುಕುಗಳನ್ನು ಬೋರ್ಡ್‌ನಲ್ಲಿ ಇರಿಸುವವರೆಗೆ ಆಟಗಾರರು ತಮ್ಮ ತುಣುಕುಗಳನ್ನು ಖಾಲಿ ಬಿಂದುಗಳಲ್ಲಿ ಇರಿಸುವ ತಿರುವುಗಳನ್ನು ತೆಗೆದುಕೊಳ್ಳುತ್ತಾರೆ. ಒಬ್ಬ ಆಟಗಾರನು ತನ್ನ ಮೂರು ತುಣುಕುಗಳನ್ನು ನೇರವಾಗಿ ಹಾಕಲು ಸಾಧ್ಯವಾದರೆ, ಅವನಿಗೆ \"ಗಿರಣಿ\" ಇದೆ ಮತ್ತು ಅವನ ಎದುರಾಳಿಯ ಒಂದು ತುಂಡನ್ನು ಮಂಡಳಿಯಿಂದ ತೆಗೆದುಹಾಕಬಹುದು.\n\nಕೆಲವು ನಿಯಮಗಳಲ್ಲಿ, ರೂಪುಗೊಂಡ ಗಿರಣಿಯಿಂದ ತುಂಡನ್ನು ತೆಗೆದುಹಾಕುವ ಮೊದಲು ಆಟಗಾರರು ಮೊದಲು ಬೇರೆ ಯಾವುದೇ ತುಣುಕುಗಳನ್ನು ತೆಗೆದುಹಾಕಬೇಕು.\n\nತೆಗೆದ ತುಣುಕುಗಳ ಬಿಂದುಗಳಿಗೆ ನೀವು ಮತ್ತೆ ಕೆಲವು ನಿಯಮಗಳಲ್ಲಿ ಇರಿಸುವ ಹಂತದಲ್ಲಿ ಇರಿಸಲು ಸಾಧ್ಯವಿಲ್ಲ.\n\nಎಲ್ಲಾ ತುಣುಕುಗಳನ್ನು ಒಮ್ಮೆ ಬಳಸಿದ ನಂತರ, ಆಟಗಾರರು ಚಲಿಸುವ ತಿರುವುಗಳನ್ನು ತೆಗೆದುಕೊಳ್ಳುತ್ತಾರೆ.\n\nಚಲಿಸುತ್ತಿದೆ\n\nಸರಿಸಲು, ಆಟಗಾರನು ತನ್ನ ಒಂದು ತುಣುಕನ್ನು ಬೋರ್ಡ್ ರೇಖೆಯ ಉದ್ದಕ್ಕೂ ಖಾಲಿ ಪಕ್ಕದ ಬಿಂದುವಿಗೆ ಚಲಿಸುತ್ತಾನೆ. ಅವರು ಹಾಗೆ ಮಾಡಲು ಸಾಧ್ಯವಾಗದಿದ್ದರೆ, ಅವರು ಆಟವನ್ನು ಕಳೆದುಕೊಂಡಿದ್ದಾರೆ. ಬೋರ್ಡ್ ಸಾಲಿನಲ್ಲಿ ತನ್ನ ಮೂರು ತುಣುಕುಗಳನ್ನು ಜೋಡಿಸುವ ಆಟಗಾರನು ಗಿರಣಿಯನ್ನು ಹೊಂದಿರುತ್ತಾನೆ ಮತ್ತು ಇರಿಸುವ ಹಂತದಂತೆಯೇ ತನ್ನ ಎದುರಾಳಿಯ ತುಣುಕುಗಳಲ್ಲಿ ಒಂದನ್ನು ತೆಗೆದುಹಾಕಬಹುದು. ಯಾವುದೇ ಆಟಗಾರನು ಎರಡು ತುಂಡುಗಳಾಗಿ ಕಡಿಮೆಯಾಗುತ್ತಾನೆ, ಹೊಸ ಗಿರಣಿಗಳನ್ನು ರೂಪಿಸಲು ಯಾವುದೇ ಆಯ್ಕೆಯಿಲ್ಲ, ಮತ್ತು ಆದ್ದರಿಂದ ಆಟವನ್ನು ಕಳೆದುಕೊಳ್ಳುತ್ತಾನೆ. ತನ್ನ ಎದುರಾಳಿಯು ಚಲಿಸದಂತೆ ನಿರ್ಬಂಧಿಸಿದರೆ ಆಟಗಾರನು ಮೂರು ತುಣುಕುಗಳಿಗಿಂತ ಹೆಚ್ಚು ಕಳೆದುಕೊಂಡಾಗ ಕಳೆದುಕೊಳ್ಳಬಹುದು.\n\nಹಾರುವ\n\nನಿಯಮಗಳ ಕೆಲವು ರೂಪಾಂತರಗಳಲ್ಲಿ, ಆಟಗಾರನು ಕೇವಲ ಮೂರು ತುಣುಕುಗಳನ್ನು ಮಾತ್ರ ಉಳಿದಿದ್ದರೆ, ಅವನ ತುಣುಕುಗಳು ಪಕ್ಕದವುಗಳನ್ನು ಮಾತ್ರವಲ್ಲದೆ ಯಾವುದೇ ಖಾಲಿ ಬಿಂದುಗಳಿಗೆ ಹಾರಬಲ್ಲವು, ಹಾಪ್ ಮಾಡಬಹುದು ಅಥವಾ ಹೋಗಬಹುದು.';

  @override
  String get versionInfo => 'ಆವೃತ್ತಿ ಮಾಹಿತಿ';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'ಪರವಾನಗಿ';

  @override
  String get sourceCode => 'ಮೂಲ ಕೋಡ್';

  @override
  String get appVersion => 'ಅಪ್ಲಿಕೇಶನ್ ಆವೃತ್ತಿ';

  @override
  String get general => 'ಜನರಲ್';

  @override
  String get advanced => 'ಸುಧಾರಿತ';

  @override
  String get placing => 'ಇಡುವುದು';

  @override
  String get moving => 'ಚಲಿಸುತ್ತಿದೆ';

  @override
  String get removing => 'ತೆಗೆದುಹಾಕಲಾಗುತ್ತಿದೆ';

  @override
  String get gameOverCondition => 'ಸ್ಥಿತಿಯ ಮೇಲೆ ಆಟ';

  @override
  String get aisPlayStyle => 'AI ನ ಪ್ಲೇಸ್ಟೈಲ್';

  @override
  String get passive => 'ನಿಷ್ಕ್ರಿಯ';

  @override
  String get timeout => 'ಸಮಯ ಮೀರಿದೆ';

  @override
  String get appearance => 'ಗೋಚರತೆ';

  @override
  String get drawOnHumanExperience => 'ಮಾನವ ಅನುಭವವನ್ನು ಸೆಳೆಯಿರಿ';

  @override
  String get considerMobility => 'ತುಣುಕುಗಳ ಚಲನಶೀಲತೆಯನ್ನು ಪರಿಗಣಿಸಿ';

  @override
  String get pieceCount => 'ಪೀಸ್ ಎಣಿಕೆ:';

  @override
  String inHand(Object player, int count) {
    return '$player ಕೈಯಲ್ಲಿ: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player ಬೋರ್ಡ್‌ನಲ್ಲಿ: $count';
  }

  @override
  String get boardTop => 'ಮೇಲಿನಿಂದ ಬೋರ್ಡ್ ಆಫ್‌ಸೆಟ್';

  @override
  String get notAIsTurn => 'ಇದು ಎಐನ ಸರದಿ ಅಲ್ಲ.';

  @override
  String get aiIsNotThinking => 'ಎಐ ಯೋಚಿಸುತ್ತಿಲ್ಲ.';

  @override
  String get atEnd => 'ನೀವು ಚಲಿಸುವ ಪಟ್ಟಿಯ ಕೊನೆಯಲ್ಲಿದ್ದೀರಿ.';

  @override
  String get tapBackAgainToLeave => 'ಬಿಡಲು ಮತ್ತೆ ಟ್ಯಾಪ್ ಮಾಡಿ.';

  @override
  String get more => 'ಇನ್ನಷ್ಟು';

  @override
  String get experimental => 'ಇದು ಪ್ರಾಯೋಗಿಕ ಲಕ್ಷಣವಾಗಿದೆ.';

  @override
  String get experiments => 'ಪ್ರಯೋಗಗಳು';

  @override
  String get ossLicenses => 'ಮುಕ್ತ ಮೂಲ ಪರವಾನಗಿಗಳು';

  @override
  String get language => 'ಭಾಷೆ';

  @override
  String get defaultLanguage => 'ಡೀಫಾಲ್ಟ್ ಭಾಷೆ';

  @override
  String get mayMoveInPlacingPhase => 'ತುಣುಕುಗಳು ಇರಿಸುವ ಹಂತದಲ್ಲಿ ಚಲಿಸಬಹುದು';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'ಯಾವುದೇ ವಿಶಿಷ್ಟವಾದ ಇರಿಸುವ ಮತ್ತು ಚಲಿಸುವ ಹಂತಗಳಿಲ್ಲ, ಅಂದರೆ, ಆಟಗಾರರು ಪ್ರತಿ ಚಲನೆಯಲ್ಲೂ ಒಂದು ತುಂಡನ್ನು ಬೋರ್ಡ್‌ನಲ್ಲಿ ಇಡಬೇಕೆ ಅಥವಾ ಅವರ ಒಂದು ತುಣುಕನ್ನು ಚಲಿಸಬೇಕೆ ಎಂದು ನಿರ್ಧರಿಸಬಹುದು (ಅವರು ಉಳಿದಿರುವ ತುಣುಕುಗಳನ್ನು ಇಡುವವರೆಗೆ).';

  @override
  String get drawerColor => 'ಮೆನು ಬಣ್ಣ';

  @override
  String get drawerTextColor => 'ಮೆನು ಪಠ್ಯ ಬಣ್ಣ';

  @override
  String get drawerHighlightItemColor => 'ಮೆನು ಐಟಂ ಬಣ್ಣವನ್ನು ಹೈಲೈಟ್ ಮಾಡುತ್ತದೆ';

  @override
  String get mainToolbarBackgroundColor => 'ಮುಖ್ಯ ಟೂಲ್‌ಬಾರ್ ಹಿನ್ನೆಲೆ ಬಣ್ಣ';

  @override
  String get mainToolbarIconColor => 'ಮುಖ್ಯ ಟೂಲ್‌ಬಾರ್ ಐಕಾನ್ ಬಣ್ಣ';

  @override
  String get navigationToolbarBackgroundColor =>
      'ನ್ಯಾವಿಗೇಷನ್ ಟೂಲ್‌ಬಾರ್ ಹಿನ್ನೆಲೆ ಬಣ್ಣ';

  @override
  String get navigationToolbarIconColor => 'ನ್ಯಾವಿಗೇಷನ್ ಟೂಲ್‌ಬಾರ್ ಐಕಾನ್ ಬಣ್ಣ';

  @override
  String get autoHideToolbar => 'ಟೂಲ್‌ಬಾರ್ ಅನ್ನು ಸ್ವಯಂಚಾಲಿತವಾಗಿ ಮರೆಮಾಡಿ';

  @override
  String get toolbarLocationOnScreen => 'ಪರದೆಯ ಮೇಲೆ ಟೂಲ್‌ಬಾರ್ ಸ್ಥಳ';

  @override
  String get top => 'ಟಾಪ್';

  @override
  String get bottom => 'ಕೆಳಗೆ';

  @override
  String get center => 'ಕೇಂದ್ರ';

  @override
  String get solidColor => 'ಗಾಢ ಬಣ್ಣ';

  @override
  String get picture => 'ಚಿತ್ರ';

  @override
  String get chooseYourPicture => 'ನಿಮ್ಮ ಚಿತ್ರವನ್ನು ಆರಿಸಿ';

  @override
  String get light => 'ಬೆಳಕು';

  @override
  String get dark => 'ಡಾರ್ಕ್';

  @override
  String get themes => 'ಥೀಮ್ಗಳು';

  @override
  String get currentTheme => 'ಪ್ರಸ್ತುತ ಥೀಮ್';

  @override
  String get saveTheme => 'ಥೀಮ್ ಉಳಿಸಿ';

  @override
  String get showAnalysisGraph => 'ವಿಶ್ಲೇಷಣೆ ಗ್ರಾಫ್ ತೋರಿಸಿ';

  @override
  String get analysis => 'ವಿಶ್ಲೇಷಣೆ';

  @override
  String get saveGame => 'ಆಟ ಉಳಿಸು';

  @override
  String get loadGame => 'ಆಟವನ್ನು ಲೋಡ್ ಮಾಡಿ';

  @override
  String get setupPosition => 'ಸೆಟಪ್ ಸ್ಥಾನ';

  @override
  String get showLegalMoves => 'ಕಾನೂನು ಕ್ರಮಗಳನ್ನು ತೋರಿಸಿ';

  @override
  String get showLastMove => 'ಕೊನೆಯ ನಡೆಯನ್ನು ತೋರಿಸಿ';

  @override
  String get showArrows => 'ಬಾಣಗಳನ್ನು ತೋರಿಸಿ';

  @override
  String get pieces => 'ತುಣುಕುಗಳು';

  @override
  String get showAnalysis => 'ವಿಶ್ಲೇಷಣೆಯನ್ನು ತೋರಿಸಿ';

  @override
  String get threads => 'ಎಳೆಗಳು';

  @override
  String get getInvolved => 'ತೊಡಗಿಸಿಕೊಳ್ಳಿ';

  @override
  String get helpImproveTranslate => 'ಅನುವಾದವನ್ನು ಸುಧಾರಿಸಲು ಸಹಾಯ ಮಾಡಿ';

  @override
  String get tutorial => 'ಟ್ಯುಟೋರಿಯಲ್';

  @override
  String get classicMill => 'ಕ್ಲಾಸಿಕ್ ಮಿಲ್';

  @override
  String get mixedMill => 'ಮಿಶ್ರ ಮಿಲ್';

  @override
  String get ceylonMill => 'ಸಿಲೋನ್ ಮಿಲ್';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'ಮಿಲ್ ಅನ್ನು ಮುರಿಯಬಹುದು ಮತ್ತು ಪದೇ ಪದೇ ಮರುಮಾಡಬಹುದು';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'ಹೊಸ ಗಿರಣಿಯನ್ನು ರಚಿಸಲು ಆಟಗಾರನು ಗಿರಣಿಯನ್ನು ಮುರಿದರೆ, ಅಂತಹ ಆಟಗಾರನು ಹೊಸ ಗಿರಣಿಯನ್ನು ಮಾಡಿದರೆ ಅಂತಹ ತುಣುಕನ್ನು ತನ್ನ ಮುಂದಿನ ನಡೆಯಲ್ಲಿ ಮೂಲ ಜಂಕ್ಷನ್‌ಗೆ ಹಿಂತಿರುಗಿಸಬಹುದು.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'ಆಟಗಾರನು ಮೂರು ತುಣುಕುಗಳನ್ನು ಹೊಂದಿದ್ದರೆ ಮತ್ತು ಹತ್ತು ಚಲನೆಗಳ ನಂತರ ಯಾವುದೇ ಆಟಗಾರನು ಎದುರಾಳಿಯ ತುಣುಕುಗಳನ್ನು ತೆಗೆದುಹಾಕದಿದ್ದರೆ ಆಟವನ್ನು ಎಳೆಯಲಾಗುತ್ತದೆ';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'ಒಬ್ಬ ಆಟಗಾರನು ಮೂರು ತುಣುಕುಗಳಿಗೆ ಇಳಿದಾಗ, ಮತ್ತು ಯಾವುದೇ ಆಟಗಾರನು ಹತ್ತು ಚಲನೆಗಳ ಒಳಗೆ ಎದುರಾಳಿಯ ತುಂಡನ್ನು ತೆಗೆದುಹಾಕಲು ಸಾಧ್ಯವಿಲ್ಲ, ಆಟವು ಡ್ರಾ ಆಗಿದೆ.';

  @override
  String get close => 'ಮುಚ್ಚಿ';

  @override
  String get whitePiece => 'ಬಿಳಿ ತುಂಡು';

  @override
  String get blackPiece => 'ಕಪ್ಪು ತುಂಡು';

  @override
  String get emptyPoint => 'ಖಾಲಿ ಬಿಂದು';

  @override
  String get noPoint => 'ಯಾವುದೇ ಅರ್ಥವಿಲ್ಲ';

  @override
  String get placingPhase => 'ಇರಿಸುವ ಹಂತ';

  @override
  String get movingPhase => 'ಚಲಿಸುವ ಹಂತ';

  @override
  String get flyingPhase => 'ಹಾರುವ ಹಂತ';

  @override
  String sideToMove(Object player) {
    return 'ಸರಿಸಲು ಬದಿ: $player';
  }

  @override
  String lastMove(Object move) {
    return 'ಕೊನೆಯ ಚಲನೆ: $move';
  }

  @override
  String get selected => 'ಆಯ್ಕೆ ಮಾಡಲಾಗಿದೆ';

  @override
  String get accessibility => 'ಪ್ರವೇಶಿಸುವಿಕೆ';

  @override
  String get screenReaderSupport => 'ಸ್ಕ್ರೀನ್ ರೀಡರ್ ಬೆಂಬಲ';

  @override
  String get isDraw => 'ಇದು ಡ್ರಾ ಆಗಿದೆ!';

  @override
  String get draw => 'ಡ್ರಾ';

  @override
  String get pieceHighlightColor => 'ಪೀಸ್ ಹೈಲೈಟ್ ಬಣ್ಣ';

  @override
  String get algorithm => 'ಅಲ್ಗಾರಿದಮ್';

  @override
  String get endgameNMoveRule => 'ಎಂಡ್‌ಗೇಮ್ ಎನ್-ಮೂವ್ ನಿಯಮ';

  @override
  String get endgameNMoveRule_Detail =>
      'ಯಾವುದೇ ಆಟಗಾರನು ಕೇವಲ ಮೂರು ತುಣುಕುಗಳನ್ನು ಹೊಂದಿದ್ದರೆ ಮತ್ತು ಯಾವುದೇ ಆಟಗಾರನು ನಿರ್ದಿಷ್ಟ ಚಲನೆಗಳಲ್ಲಿ ಒಂದು ತುಂಡನ್ನು ತೆಗೆಯದಿದ್ದರೆ, ಆಟವನ್ನು ಡ್ರಾ ಮಾಡಲಾಗುತ್ತದೆ.';

  @override
  String get drawReasonEndgameRule50 =>
      'ಒಬ್ಬ ಆಟಗಾರನು ಕೇವಲ ಮೂರು ತುಣುಕುಗಳನ್ನು ಹೊಂದಿರುತ್ತಾನೆ ಮತ್ತು ಯಾವುದೇ ಆಟಗಾರನು ನಿರ್ದಿಷ್ಟ ಚಲನೆಗಳಲ್ಲಿ ಒಂದು ತುಂಡನ್ನು ತೆಗೆಯುವುದಿಲ್ಲ.';

  @override
  String get threefoldRepetitionRule => 'ಮೂರು ಪಟ್ಟು ಪುನರಾವರ್ತಿಸುವ ನಿಯಮ';

  @override
  String get threefoldRepetitionRule_Detail =>
      'ಒಂದು ಸ್ಥಾನವು ಮೂರನೇ ಬಾರಿಗೆ ಸಂಭವಿಸಿದಲ್ಲಿ ಆಟವನ್ನು ಡ್ರಾ ಮಾಡಲಾಗುತ್ತದೆ.';

  @override
  String get continueToMakeMove => 'ಗಿರಣಿ! ಒಂದು ಚಲನೆಯನ್ನು ಮುಂದುವರಿಸಿ.';

  @override
  String get pointStyle => 'ಪಾಯಿಂಟ್ ಶೈಲಿ';

  @override
  String get pointWidth => 'ಪಾಯಿಂಟ್ ಅಗಲ';

  @override
  String get solid => 'ಘನ';

  @override
  String get hollow => 'ಟೊಳ್ಳು';

  @override
  String get languageName => 'ಕನ್ನಡ';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ಚಲನೆಗಳು',
      one: '$count ಸರಿಸಿ',
      zero: 'ಮೂವ್',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'ಲೋಡ್ ವಿಫಲವಾಗಿದೆ.';

  @override
  String get filename => 'ಕಡತದ ಹೆಸರು';

  @override
  String get browse => 'ಬ್ರೌಸ್…';

  @override
  String get gameFiles => 'ಆಟದ ಫೈಲ್‌ಗಳು';

  @override
  String get gameSavedTo => 'ಆಟವನ್ನು ಉಳಿಸಲಾಗಿದೆ';

  @override
  String get empty => 'ಖಾಲಿ';

  @override
  String get noMove => 'ಯಾವುದೇ ಚಲನೆ ಇಲ್ಲ.';

  @override
  String get restoredPosition => 'ಆರಂಭಿಕ ಸ್ಥಾನವನ್ನು ಮರುಸ್ಥಾಪಿಸಲಾಗಿದೆ.';

  @override
  String get clean => 'ಕ್ಲೀನ್';

  @override
  String get cleanedUp => 'ಸ್ವಚ್ಛಗೊಳಿಸಲಾಗಿದೆ.';

  @override
  String get remove => 'ತೆಗೆದುಹಾಕಿ';

  @override
  String get noPiecesCanBeRemoved => 'ಯಾವುದೇ ತುಣುಕುಗಳನ್ನು ತೆಗೆಯಲಾಗುವುದಿಲ್ಲ.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ತುಣುಕುಗಳು',
      one: '$count ತುಣುಕು',
      zero: 'ಪೀಸ್',
    );
    return '$_temp0 ತೆಗೆದುಹಾಕಬೇಕಾಗಿದೆ.';
  }

  @override
  String placedCount(int count) {
    return 'ಇರಿಸಿ ($count)';
  }

  @override
  String get placedPieceCount => 'ಇರಿಸುವ ಹಂತದಲ್ಲಿ ತುಂಡು ಎಣಿಕೆಯನ್ನು ಇರಿಸಲಾಗಿದೆ.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'ಪ್ರಸ್ತುತ ಆಟಗಾರನು $count ತುಣುಕುಗಳನ್ನು ಇರಿಸಿದ್ದಾನೆ.';
  }

  @override
  String get notPlacingPhase =>
      'ಹಂತವನ್ನು ಇಡುವುದಿಲ್ಲ, ಅದನ್ನು ಬದಲಾಯಿಸಲು ಸಾಧ್ಯವಿಲ್ಲ.';

  @override
  String get paste => 'ಅಂಟಿಸಿ';

  @override
  String get pasteDone => 'ಪೇಸ್ಟ್ ಮಾಡಲಾಗುತ್ತದೆ.';

  @override
  String get cannotPaste => 'ಅಂಟಿಸಲು ಸಾಧ್ಯವಿಲ್ಲ.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'ಇರಿಸದ ಮತ್ತು ತೆಗೆದುಹಾಕಲಾದ ತುಣುಕುಗಳನ್ನು ತೋರಿಸಿ';

  @override
  String get fullScreen => 'ಪೂರ್ಣ ಪರದೆ';

  @override
  String get reopenToTakeEffect =>
      'ಸೆಟ್ಟಿಂಗ್‌ಗಳು ಕಾರ್ಯರೂಪಕ್ಕೆ ಬರಲು ಅಪ್ಲಿಕೇಶನ್‌ನಿಂದ ನಿರ್ಗಮಿಸಿ ಮತ್ತು ಪುನಃ ತೆರೆಯಿರಿ.';

  @override
  String get forest => 'ಅರಣ್ಯ';

  @override
  String get desktopImage => 'ಡೆಸ್ಕ್‌ಟಾಪ್ ಚಿತ್ರ';

  @override
  String get invalidPosition => 'ಅಮಾನ್ಯ ಸ್ಥಾನ.';

  @override
  String get shareGIF => 'GIF ಹಂಚಿಕೊಳ್ಳಿ';

  @override
  String get pixelRatio => 'ಪಿಕ್ಸೆಲ್ ಅನುಪಾತ';

  @override
  String get duration => 'ಅವಧಿ';

  @override
  String get gameScreenRecorder => 'ಗೇಮ್ ಸ್ಕ್ರೀನ್ ರೆಕಾರ್ಡರ್';

  @override
  String get previous => 'ಹಿಂದಿನ';

  @override
  String get next => 'ಮುಂದೆ';

  @override
  String get skip => 'ಬಿಟ್ಟುಬಿಡಿ';

  @override
  String get gotIt => 'ಅರ್ಥವಾಯಿತು';

  @override
  String get youCanModifyRules =>
      'ನಿಯಮ ಸೆಟ್ಟಿಂಗ್‌ಗಳಲ್ಲಿ ನೀವು ಆಟದ ನಿಯಮಗಳನ್ನು ಮಾರ್ಪಡಿಸಬಹುದು.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'ಪಿಕ್ಕರ್‌ನಲ್ಲಿ ಮೌಲ್ಯವನ್ನು ಬದಲಾಯಿಸಲು ನೀವು ಮೌಸ್ ಚಕ್ರವನ್ನು ಬಳಸಬಹುದು.';

  @override
  String get noTimeLimitForThinking =>
      'AI ಥಿಂಕಿಂಗ್ ಸಮಯವನ್ನು 0 ಗೆ ಹೊಂದಿಸಲಾಗಿದೆ ಎಂದರೆ ಯೋಚಿಸಲು ಯಾವುದೇ ಸಮಯದ ಮಿತಿಯಿಲ್ಲ.';

  @override
  String get whatIsMtdf =>
      'MTD(f) ಎಂಬುದು ಆಲ್ಫಾ-ಬೀಟಾ ಹುಡುಕಾಟ ಅಲ್ಗಾರಿದಮ್‌ನ ಮಾರ್ಪಡಿಸಿದ ರೂಪವಾಗಿದ್ದು, ಮಧ್ಯಂತರ ಹುಡುಕಾಟ ಫಲಿತಾಂಶಗಳನ್ನು ಮರುಬಳಕೆ ಮಾಡುವ ಮೂಲಕ ಮತ್ತು ಹುಡುಕಾಟ ಸ್ಥಳವನ್ನು ಕಿರಿದಾಗಿಸಲು ಉತ್ತಮ ಆರಂಭಿಕ ಊಹೆಯನ್ನು ಬಳಸುವ ಮೂಲಕ ದಕ್ಷತೆಯನ್ನು ಸುಧಾರಿಸುವ ಗುರಿಯನ್ನು ಹೊಂದಿದೆ.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'AI ಚಿಂತನೆಯ ಸಮಯದ ಹೊಂದಾಣಿಕೆಯು ಸಂಪೂರ್ಣವಾಗಿ ನಿಖರವಾಗಿಲ್ಲದಿರಬಹುದು ಎಂಬುದನ್ನು ದಯವಿಟ್ಟು ತಿಳಿದಿರಲಿ. ತೊಂದರೆಯ ಮಟ್ಟವನ್ನು ಕಡಿಮೆ ಮೌಲ್ಯಕ್ಕೆ ಹೊಂದಿಸಿದಾಗ ನಿಜವಾದ ಆಲೋಚನಾ ಸಮಯವು ಚಿಕ್ಕದಾಗಿರಬಹುದು ಮತ್ತು ಸಮಯ ಮುಗಿದಾಗ AI ಮಧ್ಯದಲ್ಲಿ ಯೋಚಿಸಿದಾಗ ದೀರ್ಘವಾಗಿರುತ್ತದೆ.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'ನೀವು ಕಷ್ಟದ ಮಟ್ಟವನ್ನು ಹೆಚ್ಚು ಹೊಂದಿಸಿದರೆ ಆದರೆ AI ಚಿಂತನೆಯ ಸಮಯವನ್ನು ಹೆಚ್ಚಿಸದಿದ್ದರೆ, ಚಿಂತನೆಯ ಸಮಯದ ನಿರ್ಬಂಧದ ಕಾರಣದಿಂದಾಗಿ ನಿಜವಾದ ತೊಂದರೆ ಮಟ್ಟವು ಕಡಿಮೆ ಮೌಲ್ಯಕ್ಕೆ ಸೀಮಿತವಾಗಿರುತ್ತದೆ. ಯಂತ್ರದ ಕಾರ್ಯಕ್ಷಮತೆಯ ಆಧಾರದ ಮೇಲೆ ನಿಜವಾದ ಮೌಲ್ಯವು ಬದಲಾಗಬಹುದು.';

  @override
  String get whatIsPvs =>
      'PVS (ಪ್ರಿನ್ಸಿಪಲ್ ವೇರಿಯೇಶನ್ ಸರ್ಚ್) ಎಂಬುದು ಒಂದು ನಿರ್ದಿಷ್ಟ ಸ್ಥಾನದಲ್ಲಿ ಉತ್ತಮ ಚಲನೆಯನ್ನು ಕಂಡುಹಿಡಿಯಲು ಹುಡುಕಾಟ ಅಲ್ಗಾರಿದಮ್ ಆಗಿದೆ. ಇದು ಆಲ್ಫಾ-ಬೀಟಾ ಅಲ್ಗಾರಿದಮ್‌ನ ವರ್ಧನೆಯಾಗಿದೆ ಮತ್ತು ಪ್ರಮುಖ ಬದಲಾವಣೆಯಿಂದ ಈಗಾಗಲೇ ಸುರಕ್ಷಿತ ಸ್ಕೋರ್‌ಗಿಂತ ಕ್ರಮವು ಕೆಟ್ಟದಾಗಿದೆ ಅಥವಾ ಕೆಟ್ಟದ್ದಲ್ಲ ಎಂದು ಖಚಿತಪಡಿಸಲು ಶೂನ್ಯ ಅಥವಾ ಶೂನ್ಯ ವಿಂಡೋ ಹುಡುಕಾಟಗಳನ್ನು ಬಳಸುತ್ತದೆ. PVS ಅತ್ಯಂತ ಭರವಸೆಯ ಚಲನೆಗಳ ಮೇಲೆ ಕೇಂದ್ರೀಕರಿಸುತ್ತದೆ ಮತ್ತು ಸಬ್‌ಪ್ಟಿಮಲ್ ಶಾಖೆಗಳ ಅನಗತ್ಯ ಹುಡುಕಾಟಗಳನ್ನು ತಪ್ಪಿಸುತ್ತದೆ, ಇದು ಹುಡುಕಾಟದ ದಕ್ಷತೆಯನ್ನು ಸುಧಾರಿಸಲು ಸಹಾಯ ಮಾಡುತ್ತದೆ.';

  @override
  String get whatIsAlphaBeta =>
      'ಆಲ್ಫಾ-ಬೀಟಾ ಅಲ್ಗಾರಿದಮ್ ಉತ್ತಮ ಚಲನೆಯನ್ನು ಕಂಡುಹಿಡಿಯಲು ಹುಡುಕಾಟ ಅಲ್ಗಾರಿದಮ್ ಆಗಿದೆ. ಹುಡುಕಾಟ ಮರವನ್ನು ಕತ್ತರಿಸಲು ಮತ್ತು ದಕ್ಷತೆಯನ್ನು ಹೆಚ್ಚಿಸಲು ಇದು ಮಿನಿಮ್ಯಾಕ್ಸ್ ತತ್ವ ಮತ್ತು ಆಲ್ಫಾ ಮತ್ತು ಬೀಟಾ ಎಂಬ ಎರಡು ಮೌಲ್ಯಗಳನ್ನು ಬಳಸುತ್ತದೆ. ಆಲ್ಫಾ ಕಂಪ್ಯೂಟರ್ ಪಡೆಯಬಹುದಾದ ಕನಿಷ್ಠ ಸ್ಕೋರ್ ಅನ್ನು ಪ್ರತಿನಿಧಿಸುತ್ತದೆ, ಆದರೆ ಬೀಟಾ ತನ್ನ ಎದುರಾಳಿ ಪಡೆಯಬಹುದಾದ ಗರಿಷ್ಠ ಸ್ಕೋರ್ ಅನ್ನು ಪ್ರತಿನಿಧಿಸುತ್ತದೆ. ಆಟದಲ್ಲಿ ಸ್ಮಾರ್ಟ್, ಸಮರ್ಥ ನಿರ್ಧಾರಗಳನ್ನು ತೆಗೆದುಕೊಳ್ಳಲು ಅಲ್ಗಾರಿದಮ್ ಕಂಪ್ಯೂಟರ್‌ಗೆ ಸಹಾಯ ಮಾಡುತ್ತದೆ.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'ಮಾನವ ಅನುಭವದ ಪ್ರಕಾರ, ನೀವು ಗೆಲ್ಲಲು ಪ್ರಯತ್ನಿಸಿದರೆ, ನೀವು ಸೋಲುತ್ತೀರಿ. ಬದಲಾಗಿ, ನಿಮ್ಮ ಗುರಿಯಾಗಿ ಡ್ರಾವನ್ನು ಗುರಿಯಾಗಿರಿಸಿ ಮತ್ತು ಆಟದಲ್ಲಿ ಸೋಲುವುದನ್ನು ತಪ್ಪಿಸಿ. ನಿಮ್ಮ ಎದುರಾಳಿಯನ್ನು ಗಮನಿಸಿ ಮತ್ತು ಅವರು ತಪ್ಪುಗಳನ್ನು ಮಾಡಬಹುದಾದ ಸ್ಥಾನಕ್ಕೆ ಅವರನ್ನು ನಿಧಾನವಾಗಿ ಆಕರ್ಷಿಸಿ. ಅವರು ದೌರ್ಬಲ್ಯವನ್ನು ತೋರಿಸಿದಾಗ, ಅವಕಾಶವನ್ನು ಬಳಸಿಕೊಳ್ಳಿ ಮತ್ತು ಗೆಲುವಿಗೆ ನಿಧಾನವಾಗಿ ತಳ್ಳಿರಿ. ಈ ರೀತಿಯಾಗಿ, ನೀವು ಆಟವನ್ನು ಗೆಲ್ಲಬಹುದು.';

  @override
  String get firstMoveDetail =>
      'ಈ ಆಟದಲ್ಲಿ, ಮೊದಲ ಆಟಗಾರನಿಗೆ ಹೋಲಿಸಿದರೆ ಎರಡನೇ ಆಟಗಾರನಿಗೆ ಗೆಲ್ಲುವುದು ಸುಲಭ.';

  @override
  String get passiveDetail =>
      'ನಿಷ್ಕ್ರಿಯ ಆಯ್ಕೆಯನ್ನು ಸಕ್ರಿಯಗೊಳಿಸುವುದರಿಂದ AI ತನ್ನ ಸ್ಥಾನದಲ್ಲಿ ಪ್ರಯೋಜನವನ್ನು ಹೊಂದಿರುವಾಗ ವಿಶ್ರಾಂತಿ ಪಡೆಯಲು ಕಾರಣವಾಗುತ್ತದೆ, ಬದಲಿಗೆ ಆಕ್ರಮಣಕಾರಿಯಾಗಿ ಸಾಧ್ಯವಾದಷ್ಟು ಬೇಗ ಗೆಲ್ಲಲು ಪ್ರಯತ್ನಿಸುತ್ತದೆ.';

  @override
  String get moveRandomlyDetail =>
      'ಈ ಆಯ್ಕೆಯನ್ನು ಸಕ್ರಿಯಗೊಳಿಸುವುದರಿಂದ ಆಟದ ಯಾದೃಚ್ಛಿಕತೆ ಮತ್ತು ವಿನೋದವನ್ನು ಹೆಚ್ಚಿಸುತ್ತದೆ ಅದನ್ನು ನಿಷ್ಕ್ರಿಯಗೊಳಿಸುವಾಗ AI ಅನ್ನು ಸೋಲಿಸುವ ವಿಧಾನಗಳನ್ನು ಅಧ್ಯಯನ ಮಾಡಲು ಸಹಾಯ ಮಾಡುತ್ತದೆ.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'AI ತನ್ನ ತುಣುಕುಗಳ ಚಲನಶೀಲತೆಯನ್ನು ಪರಿಗಣಿಸಿದರೆ, ಅದು ಎದುರಾಳಿಯ ತುಣುಕುಗಳನ್ನು ಸಾಧ್ಯವಾದಷ್ಟು ಬೇಗ ಸೆರೆಹಿಡಿಯುವ ಗುರಿಯನ್ನು ಹೊಂದಿರುವುದಿಲ್ಲ, ಆದರೆ ಎದುರಾಳಿಯ ಚಲನವಲನಗಳನ್ನು ನಿರ್ಬಂಧಿಸುವುದನ್ನು ಮತ್ತು ಅದೇ ರೀತಿ ಮಾಡುವುದನ್ನು ತಡೆಯುವುದನ್ನು ಪರಿಗಣಿಸುತ್ತದೆ.';

  @override
  String get whenBoardIsFull => 'ಬೋರ್ಡ್ ತುಂಬಿದಾಗ';

  @override
  String get whenBoardIsFull_Detail =>
      'ಇರಿಸುವ ಹಂತದ ಕೊನೆಯಲ್ಲಿ, ಚಲಿಸುವ ಹಂತವು ಪ್ರಾರಂಭವಾಗುವ ಮೊದಲು, ಬೋರ್ಡ್ ತುಂಡುಗಳಿಂದ ತುಂಬಿದ್ದರೆ ಕ್ರಿಯೆಯು ಅನುಸರಿಸುತ್ತದೆ.';

  @override
  String get sideToMoveRemovePiece =>
      'ಚಲಿಸುವ ಹಂತದಲ್ಲಿ ಮೊದಲು ಚಲಿಸುವ ಆಟಗಾರನು ಎದುರಾಳಿಯ ತುಂಡುಗಳಲ್ಲಿ ಒಂದನ್ನು ತೆಗೆದುಹಾಕುತ್ತಾನೆ.';

  @override
  String get agreeToDraw => 'ಎರಡೂ ಕಡೆಯವರು ಡ್ರಾಗೆ ಒಪ್ಪಿದ್ದಾರೆ.';

  @override
  String get takeOpponentsPiece =>
      'ನಿಮ್ಮ ಎದುರಾಳಿಯ ತುಂಡುಗಳಲ್ಲಿ ಒಂದನ್ನು ತೆಗೆದುಕೊಳ್ಳಿ.';

  @override
  String get firstPlayerLose => 'ಮೊದಲ ಆಟಗಾರನು ಆಟವನ್ನು ಕಳೆದುಕೊಳ್ಳುತ್ತಾನೆ.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'ಮೊದಲ ಮತ್ತು ಎರಡನೆಯ ಆಟಗಾರರು ಎದುರಾಳಿಯ ತುಂಡುಗಳಲ್ಲಿ ಒಂದನ್ನು ತೆಗೆದುಹಾಕುತ್ತಾರೆ.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'ಎರಡನೇ ಮತ್ತು ಮೊದಲ ಆಟಗಾರರು ಎದುರಾಳಿಯ ತುಂಡುಗಳಲ್ಲಿ ಒಂದನ್ನು ತೆಗೆದುಹಾಕುತ್ತಾರೆ.';

  @override
  String get enteredFlyingPhase =>
      'ಈಗ ಹಾರುವ ಹಂತವನ್ನು ಪ್ರವೇಶಿಸಿದೆ, ಎದುರಾಳಿಯ ತುಣುಕುಗಳು ಬೋರ್ಡ್‌ನಲ್ಲಿ ಯಾವುದೇ ಖಾಲಿ ಬಿಂದುವಿಗೆ ಹೋಗಬಹುದು. ನೀವು \"ನಿಯಮ ಸೆಟ್ಟಿಂಗ್‌ಗಳು\" ನಲ್ಲಿ ಹಾರುವ ನಿಯಮವನ್ನು ಆಫ್ ಮಾಡಬಹುದು.';

  @override
  String get whenStalemate => 'ಸ್ಥಗಿತಗೊಂಡಾಗ';

  @override
  String get whenStalemate_Detail =>
      'ಯಾವುದೇ ತುಂಡನ್ನು ಸರಿಸಲು ಸಾಧ್ಯವಾಗದಿದ್ದಾಗ ಯಾವ ಕ್ರಮ ಅನುಸರಿಸುತ್ತದೆ?';

  @override
  String get endWithStalemateLoss => 'ಸ್ಥಬ್ದ ನಷ್ಟದೊಂದಿಗೆ ಕೊನೆಗೊಳ್ಳುತ್ತದೆ.';

  @override
  String get changeSideToMove => 'ಸರಿಸಲು ಬದಿಯನ್ನು ಬದಲಾಯಿಸಿ.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'ಎದುರಾಳಿಯ ತುಂಡುಗಳಲ್ಲಿ ಒಂದನ್ನು ತೆಗೆದುಹಾಕಿ ಮತ್ತು ಮುಂದಿನ ನಡೆಯನ್ನು ಮಾಡಿ.';

  @override
  String get endWithStalemateDraw => 'ಸ್ಥಬ್ದ ಡ್ರಾದೊಂದಿಗೆ ಕೊನೆಗೊಳ್ಳುತ್ತದೆ.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'ಎದುರಾಳಿಯ ತುಂಡುಗಳಲ್ಲಿ ಒಂದನ್ನು ತೆಗೆದುಹಾಕಿ ಮತ್ತು ಸರಿಸಲು ಬದಿಯನ್ನು ಬದಲಾಯಿಸಿ.';

  @override
  String get aiResponseDelayTime => 'AI ಪ್ರತಿಕ್ರಿಯೆ ವಿಳಂಬ ಸಮಯ';

  @override
  String get aiIsDelaying =>
      'AI ಪ್ರಸ್ತುತ ವಿಳಂಬವಾದ ಪ್ರತಿಕ್ರಿಯೆ ಹಂತದಲ್ಲಿದೆ. ಮುಂದುವರಿಯುವ ಮೊದಲು ದಯವಿಟ್ಟು ಸ್ವಲ್ಪ ಸಮಯ ಕಾಯಿರಿ.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'ನೀವು ಪಕ್ಕದಲ್ಲಿಲ್ಲದ ತುಂಡನ್ನು ತೆಗೆದುಹಾಕಲಾಗುವುದಿಲ್ಲ.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'ಸ್ಥಗಿತಗೊಂಡರೆ, ಗಿರಣಿ ರಚನೆಯನ್ನು ಲೆಕ್ಕಿಸದೆಯೇ ನಿಮ್ಮ ಪಕ್ಕದಲ್ಲಿರುವ ಎದುರಾಳಿಯ ತುಂಡುಗಳನ್ನು ತೆಗೆದುಹಾಕಬಹುದು.';

  @override
  String get whatIsMcts =>
      'MCTS ಒಂದು ಹರಿಕಾರ-ಸ್ನೇಹಿ ಅಲ್ಗಾರಿದಮ್ ಆಗಿದ್ದು ಅದು ಸಿಮ್ಯುಲೇಶನ್‌ಗಳ ಮೂಲಕ ವಿಭಿನ್ನ ಚಲನೆಗಳನ್ನು ಅನ್ವೇಷಿಸುವ ಮತ್ತು ಮೌಲ್ಯಮಾಪನ ಮಾಡುವ ಮೂಲಕ ನಿರ್ಧಾರಗಳನ್ನು ತೆಗೆದುಕೊಳ್ಳುತ್ತದೆ.';

  @override
  String get goldenJade => 'ಗೋಲ್ಡನ್ ಜೇಡ್';

  @override
  String get forestWood => 'ಅರಣ್ಯ ಮರ';

  @override
  String get darkMystery => 'ಡಾರ್ಕ್ ಮಿಸ್ಟರಿ';

  @override
  String get midnightBlue => 'ಮಧ್ಯರಾತ್ರಿ ನೀಲಿ';

  @override
  String get greenForest => 'ಹಸಿರು ಅರಣ್ಯ';

  @override
  String get greenMeadow => 'ಹಸಿರು ಹುಲ್ಲುಗಾವಲು';

  @override
  String get stonyPath => 'ಸ್ಟೋನಿ ಪಾತ್';

  @override
  String get pastelPink => 'ನೀಲಿಬಣ್ಣದ ಗುಲಾಬಿ';

  @override
  String get turquoiseSea => 'ವೈಡೂರ್ಯದ ಸಮುದ್ರ';

  @override
  String get violetDream => 'ವೈಲೆಟ್ ಡ್ರೀಮ್';

  @override
  String get mintChocolate => 'ಮಿಂಟ್ ಚಾಕೊಲೇಟ್';

  @override
  String get skyBlue => 'ಆಕಾಶ ನೀಲಿ';

  @override
  String get playfulGarden => 'ತಮಾಷೆಯ ಉದ್ಯಾನ';

  @override
  String get whatIsRetrogradeAnalysis =>
      'ರೆಟ್ರೊಗ್ರೇಡ್ ಅನಾಲಿಸಿಸ್ ಅಲ್ಗಾರಿದಮ್ ವಿವಿಧ ಆರಂಭದ ಸ್ಥಾನಗಳಿಂದ ಎಂಡ್‌ಗೇಮ್ ಡೇಟಾಬೇಸ್ ಅನ್ನು ನಿರ್ಮಿಸಲು ಬಹು-ಮೌಲ್ಯದ ರೆಟ್ರೋಗ್ರೇಡ್ ವಿಶ್ಲೇಷಣೆಯನ್ನು ಬಳಸುತ್ತದೆ, ನಂತರ ಗೇಮ್‌ಪ್ಲೇಯನ್ನು ಅತ್ಯುತ್ತಮವಾಗಿಸಲು ಈ ಡೇಟಾಬೇಸ್ ಅನ್ನು ಅನ್ವಯಿಸುತ್ತದೆ. ಈ ವಿಧಾನವು ಅಲ್ಟ್ರಾ-ಸ್ಟ್ರಾಂಗ್ ಪರಿಹಾರಗಳ ವರ್ಗದ ಅಡಿಯಲ್ಲಿ ಬರುತ್ತದೆ.';

  @override
  String get viewAlgorithmGuide =>
      'ಈ ಅಲ್ಗಾರಿದಮ್‌ಗಾಗಿ ಬಳಕೆದಾರ ಮಾರ್ಗದರ್ಶಿಯನ್ನು ವೀಕ್ಷಿಸಲು ನೀವು ಬಯಸುವಿರಾ?';

  @override
  String get showPositionalAdvantageIndicator =>
      'ಸ್ಥಾನಿಕ ಅನುಕೂಲ ಸೂಚಕವನ್ನು ತೋರಿಸಿ';

  @override
  String get usePerfectDatabase => 'ಪರಿಪೂರ್ಣ ಡೇಟಾಬೇಸ್ ಬಳಸಿ';

  @override
  String get perfectDatabaseDescription =>
      'ಅತ್ಯಾಧುನಿಕ ಅಲ್ಗಾರಿದಮ್‌ಗಳ ಮೂಲಕ ರಚಿಸಲಾದ ದೋಷರಹಿತ ಆಟದ ಡೇಟಾಬೇಸ್ ಅನ್ನು ಬಳಸಲು ಈ ಆಯ್ಕೆಯನ್ನು ಸಕ್ರಿಯಗೊಳಿಸಿ. ಈ ವೈಶಿಷ್ಟ್ಯವು ಅತ್ಯುತ್ತಮ ಚಲನೆಗಳನ್ನು ಸೂಚಿಸಲು ಆರಂಭಿಕ ಮತ್ತು ಅಂತ್ಯದ ಆಟದ ತಂತ್ರಗಳನ್ನು ಸಂಯೋಜಿಸುತ್ತದೆ. ಆಟದಲ್ಲಿ ಅತ್ಯುನ್ನತ ಮಟ್ಟದ ನಿಖರತೆಯನ್ನು ಬಯಸುವ ಆಟಗಾರರಿಗೆ ಇದು ಆದ್ಯತೆಯ ಆಯ್ಕೆಯಾಗಿದೆ. ನಿಖರವಾದ ಕಂಪ್ಯೂಟೇಶನಲ್ ತಂತ್ರಗಳ ಮೂಲಕ ರಚಿಸಲಾಗಿದೆ, ಡೇಟಾಬೇಸ್ ಅನ್ನು ಪರಿಪೂರ್ಣವಾದ ಆಟದ ಪರಿಹಾರಗಳನ್ನು ನೀಡಲು ವಿನ್ಯಾಸಗೊಳಿಸಲಾಗಿದೆ.\n\nಗಮನಿಸಿ: ಡೇಟಾಬೇಸ್ ಅನ್ನು ಪ್ರವೇಶಿಸಲು AI ವಿಫಲವಾದರೆ, ಇದು ಆಟದ ನಿರ್ಧಾರಗಳಿಗಾಗಿ ಸಾಂಪ್ರದಾಯಿಕ ಅಲ್ಗಾರಿದಮ್‌ಗಳಿಗೆ ತಿರುಗುತ್ತದೆ. ಡೇಟಾಬೇಸ್ ಲಭ್ಯವಿದ್ದಾಗ, \'ಡಿಫಿಕಲ್ಟಿ ಲೆವೆಲ್\' ವಾಸ್ತವಿಕವಾಗಿ ಅಜೇಯವಾಗುತ್ತದೆ ಮತ್ತು \'AI ಥಿಂಕಿಂಗ್ ಟೈಮ್\' ತೀವ್ರ ಕಡಿತವನ್ನು ಅನುಭವಿಸುತ್ತದೆ. ಡೇಟಾಬೇಸ್ ಫಲಿತಾಂಶಗಳು ಹೆಚ್ಚಿನ ಆದ್ಯತೆಯನ್ನು ಹೊಂದಿರುವ ಕಾರಣ \'AI\'s play style\' ಆಯ್ಕೆಗಳಲ್ಲಿ ಹಲವು ಸೆಟ್ಟಿಂಗ್‌ಗಳನ್ನು ಅತಿಕ್ರಮಿಸಲಾಗುತ್ತದೆ.\n\nಈ ದೋಷರಹಿತ ಡೇಟಾಬೇಸ್‌ನಿಂದ ಹೆಚ್ಚಿನದನ್ನು ಹೇಗೆ ಮಾಡುವುದು ಎಂಬುದರ ಕುರಿತು ಮಾರ್ಗದರ್ಶನಕ್ಕಾಗಿ, ಇಲ್ಲಿ ಕ್ಲಿಕ್ ಮಾಡಿ.';

  @override
  String get backgroundImage => 'ಹಿನ್ನೆಲೆ ಚಿತ್ರ';

  @override
  String get whatIsRandom =>
      'ಯಾವಾಗ \'ಪರ್ಫೆಕ್ಟ್ ಡೇಟಾಬೇಸ್ ಬಳಸು\' ಆಯ್ಕೆ ಸಕ್ರಿಯಗೊಳಿಸಿಲ್ಲವೋ, ಆಗ \'ರ್ಯಾಂಡಮ್\' ಸೆಟ್ಟಿಂಗ್‌ನಿಂದ ಎಐ ಚಲನೆಯ ಆಯ್ಕೆಗೆ ಯಾವುದೇ ಅಲ್ಗೊರಿದಮ್‌ಗಳನ್ನು ಬಳಸದೆ ಕಾಯಗಳನ್ನು ಯಾದೃಚ್ಛಿಕವಾಗಿ ಸರಿಸುತ್ತದೆ. ಇದು ಸಾಮಾನ್ಯವಾಗಿ ಆಟದ ದಕ್ಷತೆಯನ್ನು ಗಣನೀಯವಾಗಿ ಕಡಿಮೆ ಮಾಡುತ್ತದೆ. ವಿಪರ್ಯಾಸವಾಗಿ, ಯಾವಾಗ \'ಪರ್ಫೆಕ್ಟ್ ಡೇಟಾಬೇಸ್ ಬಳಸು\' ಆಯ್ಕೆ ಸಕ್ರಿಯಗೊಂಡಿದೆಯೋ, ಆಗ ಎಐ ನಿರ್ಧಾರಗಳನ್ನು ಮಾಡಲು ಕೇವಲ \'ಪರ್ಫೆಕ್ಟ್ ಡೇಟಾಬೇಸ್\' ಅನ್ನು ಮಾತ್ರ ಅವಲಂಬಿಸುತ್ತದೆ, ಸಾಂಪ್ರದಾಯಿಕ ಎಐ ಅಲ್ಗೊರಿದಮ್‌ಗಳೊಂದಿಗೆ ಮಿಶ್ರಣ ಮಾಡುವ ಬದಲು. ಈ ಮೋಡ್‌ನಲ್ಲಿ, ಎಐ ನಡೆಸುವ ಕಾಯಗಳು ಪೂರ್ತಿಯಾಗಿ ಡೇಟಾಬೇಸ್‌ನ ವಿಷಯವಸ್ತುಗಳ ಮೇಲೆ ಆಧಾರಿತವಾಗಿದ್ದು, ನೈಜಕಾಲಿಕ ಲೆಕ್ಕಾಚಾರಗಳು ಅಥವಾ ಹುಡುಕಾಟ ಅಲ್ಗೊರಿದಮ್‌ಗಳ ಮೇಲೆ ನಿರ್ಭರತೆಯನ';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'ಎದುರಾಳಿಯ ಕಾಯಿ(ಗಳನ್ನು) ಅವರ ಕೈಯಿಂದ ತೆಗೆದುಹಾಕಿ; ನಂತರ ಅದು ಎದುರಾಳಿಯ ಸರದಿ ಇರುತ್ತದೆ.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'ಸ್ಥಾಪನಾ ಹಂತದಲ್ಲಿ ಮಿಲ್ಸ್ ರಚಿಸುವಾಗ';

  @override
  String get removeOpponentsPieceFromBoard =>
      'ಫಲಕದಿಂದ ಎದುರಾಳಿಯ ಕಾಯಿ(ಗಳನ್ನು) ತೆಗೆದುಹಾಕಿ.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'ಫಲಕದಿಂದ ಎದುರಾಳಿಯ ಕಾಯಿ(ಗಳನ್ನು) ತೆಗೆದುಹಾಕಿ; ನಂತರ ಅದು ಎದುರಾಳಿಯ ಸರದಿ ಇರುತ್ತದೆ.';

  @override
  String get opponentRemovesOwnPiece =>
      'ಎದುರಾಳಿ ತಮ್ಮ ಸ್ವಂತ ಕಾಯಿ(ಗಳನ್ನು) ಫಲಕದಿಂದ ತೆಗೆದುಹಾಕುತ್ತಾರೆ.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'ನೀವು ಕ್ರಮ ಕೈಗೊಳ್ಳುವ ಬದಲು, ಎದುರಾಳಿ ತಮ್ಮ ಸ್ವಂತ ಕಾಯಿ(ಗಳನ್ನು) ಆಯ್ಕೆ ಮಾಡಿ ಫಲಕದಿಂದ ತೆಗೆದುಹಾಕುತ್ತಾರೆ, ಇದು ಅವರಿಗೆ ಹಾನಿಕಾರಕವಾದ ಕ್ರಮವಾಗುತ್ತದೆ.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'ಎದುರಾಳಿಯ ಕಾಯಿ(ಗಳನ್ನು) ಅವರ ಕೈಯಿಂದ ತೆಗೆದುಹಾಕಿ; ನಂತರ ನಿಮ್ಮ ಸರದಿ ಬರುತ್ತದೆ.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'ಎದುರಾಳಿಯ ಕೈಯಿಂದ ಕಾಯಿ(ಗಳನ್ನು) ತೆಗೆದುಹಾಕಿ. ಮಲ್ಟಿ-ರಿಮೂವ್ ಸೆಟ್ಟಿಂಗ್ ಪ್ರಕಾರ, ಬಹು ಕಾಯಿಗಳನ್ನು ತೆಗೆದುಹಾಕಬೇಕಾಗಿದ್ದರೆ ಮತ್ತು ಎದುರಾಳಿಗೆ ಕೈಯಲ್ಲಿ ಯಾವುದೇ ಕಾಯಿಗಳಿಲ್ಲದಿದ್ದರೆ, ಫಲಕದಿಂದ ಎದುರಾಳಿಯ ಕಾಯಿಗಳನ್ನು ಮುಂದುವರಿಸಿ ತೆಗೆದುಹಾಕಿ. ನಂತರ, ನಿಮ್ಮ ಸರದಿ ಬರುತ್ತದೆ. ನೀವು ಮಿಲ್ಸ್ ರಚಿಸುತ್ತಲೇ ಇದ್ದರೆ, ನೀವು ಎದುರಾಳಿಯ ಕಾಯಿಗಳನ್ನು ತೆಗೆದುಹಾಕುತ್ತಲೇ ಇರಬಹುದು.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'ಎದುರಾಳಿಯ ಕೈಯಿಂದ ಕಾಯಿ(ಗಳನ್ನು) ತೆಗೆದುಹಾಕಿ. ಮಲ್ಟಿ-ರಿಮೂವ್ ಸೆಟ್ಟಿಂಗ್ ಪ್ರಕಾರ, ಬಹು ಕಾಯಿಗಳನ್ನು ತೆಗೆದುಹಾಕಬೇಕಾಗಿದ್ದರೆ ಮತ್ತು ಎದುರಾಳಿಗೆ ಕೈಯಲ್ಲಿ ಯಾವುದೇ ಕಾಯಿಗಳಿಲ್ಲದಿದ್ದರೆ, ಫಲಕದಿಂದ ಎದುರಾಳಿಯ ಕಾಯಿಗಳನ್ನು ಮುಂದುವರಿಸಿ ತೆಗೆದುಹಾಕಿ. ನಂತರ, ಅದು ಎದುರಾಳಿಯ ಸರದಿ ಇರುತ್ತದೆ.';

  @override
  String get markAndDelayRemovingPieces =>
      'ಕಾಯಿಗಳನ್ನು ಗುರುತಿಸಿ ಮತ್ತು ತೆಗೆದುಹಾಕುವುದನ್ನು ವಿಳಂಬಗೊಳಿಸಿ.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'ಸ್ಥಾಪನಾ ಹಂತದಲ್ಲಿ, ತೆಗೆದುಹಾಕಬೇಕಾದ ಕಾಯಿಗಳನ್ನು ಗುರುತಿಸಲಾಗುತ್ತದೆ, ಮತ್ತು ಎರಡೂ ಆಟಗಾರರು ಈ ಬಿಂದುಗಳಲ್ಲಿ ಹೊಸ ಕಾಯಿಗಳನ್ನು ಇಡಲು ಸಾಧ್ಯವಿಲ್ಲ. ಚಲನೆಯ ಹಂತಕ್ಕೆ ಪ್ರವೇಶಿಸಿದಾಗ, ಈ ಗುರುತಿಸಲಾದ ಕಾಯಿಗಳನ್ನು ಎಲ್ಲವನ್ನೂ ಒಟ್ಟಾಗಿ ತೆಗೆದುಹಾಕಲಾಗುತ್ತದೆ, ಮತ್ತು ಆಟಗಾರರು ನಂತರ ಈಗ ಖಾಲಿಯಾದ ಬಿಂದುಗಳಿಗೆ ತಮ್ಮ ಕಾಯಿಗಳನ್ನು ಸರಿಸಬಹುದು.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'ಜಾಗದ ಹಂತದಲ್ಲಿ ಗಿರಣಿಗಳನ್ನು ರೂಪಿಸುವಾಗ ಕೈಗೊಳ್ಳಬಹುದಾದ ಕ್ರಿಯೆಗಳು.';

  @override
  String get marked => 'ಗುರುತಿಸಲಾಗಿದೆ';

  @override
  String get menu => 'ಮೆನು';

  @override
  String get monochrome => 'ಏಕವರ್ಣ';

  @override
  String get youCanEnableScreenReaderSupport =>
      'ನೀವು ಸಾಮಾನ್ಯ ಸೆಟ್ಟಿಂಗ್ಗಳಲ್ಲಿ ಪ್ರಾಪ್ಯತೆ ಸಂರಚನೆಯಲ್ಲಿ ಸ್ಕ್ರೀನ್ ರೀಡರ್ ಬೆಂಬಲವನ್ನು ಆನ್ ಮಾಡಬಹುದು.';

  @override
  String get showNumbersOnPieces => 'ಕಾಯಿಗಳಲ್ಲಿ ಸಂಖ್ಯೆಗಳನ್ನು ತೋರಿಸಿ';

  @override
  String get saveImage => 'ಚಿತ್ರವನ್ನು ಉಳಿಸಿ';

  @override
  String get isAnalysisToolbarShown => 'ವಿಶ್ಲೇಷಣೆ ಟೂಲ್‌ಬಾರ್ ತೋರಿಸಲಾಗುತ್ತಿದೆ';

  @override
  String get analysisToolbarBackgroundColor =>
      'ವಿಶ್ಲೇಷಣೆ ಟೂಲ್‌ಬಾರ್ ಹಿನ್ನೆಲೆ ಬಣ್ಣ';

  @override
  String get analysisToolbarIconColor => 'ವಿಶ್ಲೇಷಣೆ ಟೂಲ್‌ಬಾರ್ ಐಕಾನ್ ಬಣ್ಣ';

  @override
  String get transformed => 'ಬದಲಾಗಿದ.';

  @override
  String get cannotTransform => 'ಬದಲಾಯಿಸಲಾಗದು.';

  @override
  String get rotate => 'ತಿರುಗು';

  @override
  String get horizontalFlip => 'ಹಾ. ತಿ.';

  @override
  String get verticalFlip => 'ವರ್. ತಿ.';

  @override
  String get innerOuterFlip => 'ಆಂ/ಬಾ ತಿ.';

  @override
  String get transparentCanvas => 'ಪಾರದರ್ಶಕ ಕ್ಯಾನ್ವಾಸ್';

  @override
  String get restrictRepeatedMillsFormation =>
      'ಪುನರಾವರ್ತಿತ ಮಿಲ್ ರಚನೆಯನ್ನು ನಿರ್ಬಂಧಿಸಿ';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'ಒಂದು ಮಿಲ್ಲಿನಿಂದ ಮತ್ತೊಂದು ಮಿಲ್ಲನ್ನು ರಚಿಸಲು ಸಾಗಿಸಿದ ಕಾಯವು ಮುಂದಿನ ಸುತ್ತಿನಲ್ಲಿ ತಕ್ಷಣ ಮೂಲ ಬಿಂದುವಿಗೆ ಮರಳಿ ಮತ್ತೊಮ್ಮೆ ಮಿಲ್ ರಚಿಸಲು ಹೋಗಬಾರದು. ಮೊದಲು ಬೇರೆ ನಡೆ ಅಗತ್ಯವಿದೆ.';

  @override
  String get oneTimeUseMill => 'ಒಂದು ಬಾರಿಗೆ ಬಳಸುವ ಮಿಲ್';

  @override
  String get oneTimeUseMill_Detail =>
      'ಪ್ರತಿ ಮಿಲ್ ಒಂದೇ ಬಾರಿಗೆ ವಿರುದ್ಧದ ಟುಕ್ಕನ್ನು ತೆಗೆದುಹಾಕುತ್ತದೆ. ನೀವು ಅದನ್ನು ಮತ್ತೆ ರೂಪಿಸಬಹುದು, ಆದರೆ ಅದು ಹೆಚ್ಚುವರಿ ತೆಗೆದುಹಾಕಲು ಬಳಸಲಾಗುವುದಿಲ್ಲ.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'ನೀವು ಹೊಂದಿಸಿರುವ ಪ್ರಸ್ತುತ ನಿಯಮಗಳಿಗೆ ಹೊಂದಿಕೆಯಾಗುವ ಪರಿಪೂರ್ಣ ಡೇಟಾಬೇಸ್ ಇಲ್ಲ. ಪರಿಪೂರ್ಣ ಡೇಟಾಬೇಸ್ ಬಗ್ಗೆ ಹೆಚ್ಚಿನ ಮಾಹಿತಿಗಾಗಿ, ದಯವಿಟ್ಟು ಇಲ್ಲಿ ಕ್ಲಿಕ್ ಮಾಡಿ.';

  @override
  String get focusOnBlockingPaths => 'ತಡೆಯುವ ಹಾದಿಗಳ ಮೇಲೆ ಗಮನ ಕೊಡಿ';

  @override
  String get focusOnBlockingPaths_Detail =>
      'ಮಿಲ್ಲುಗಳನ್ನು ರಚಿಸುವುದಕ್ಕಿಂತ ಎದುರಾಳಿಯ ಚಲನೆಗಳನ್ನು ಅಡ್ಡಿಪಡಿಸುವುದಕ್ಕೆ ಪ್ರಾಮುಖ್ಯತೆ ನೀಡಲು. ಮಿಲ್ಲುಗಳನ್ನು ಪೂರ್ಣಗೊಳಿಸುವ ಮೂಲಕ ತುಣುಕುಗಳನ್ನು ತೆಗೆದುಹಾಕುವುದಕ್ಕೆ ಬದಲು, AI ಎದುರಾಳಿಯನ್ನು ಒರೆಹಾಕಲು ಪ್ರಯತ್ನಿಸುತ್ತದೆ, ಅವರನ್ನು ಚಲಿಸದಂತೆ ಮಾಡುತ್ತದೆ ಮತ್ತು ಆಕ್ರಮಣಾತ್ಮಕ ಆಟದ ಬದಲು ಆರೋಹಣದ ಮೂಲಕ ಜಯವನ್ನು ಭದ್ರಪಡಿಸುತ್ತದೆ. ಈ ತಂತ್ರ ನಿಖರವಾಗಿ ಎದುರಾಳಿಯ ಮಿಲ್ಲುಗಳನ್ನು ತಡೆಯುವುದಿಲ್ಲ.';

  @override
  String get pieceImage => 'ಚೆಸ್ ಆಕೃತಿ ಚಿತ್ರ';

  @override
  String get importColorSettings => 'ಬಣ್ಣ ಸೆಟ್ಟಿಂಗ್‌ಗಳನ್ನು ಆಮದುಮಾಡಿ';

  @override
  String get exportColorSettings => 'ಬಣ್ಣ ಸೆಟ್ಟಿಂಗ್‌ಗಳನ್ನು ರಫ್ತುಮಾಡಿ';

  @override
  String get import => 'ಆಮದು';

  @override
  String get export => 'ರಫ್ತು';

  @override
  String get pleaseCopyJsonToClipboard =>
      'ದಯವಿಟ್ಟು ಮೊದಲು JSON ಸ್ವರೂಪದ ಸೆಟ್ಟಿಂಗ್‌ಗಳನ್ನು ಕ್ಲಿಪ್‌ಬೋರ್ಡ್‌ಗೆ ನಕಲಿಸಿ.';

  @override
  String get copiedToClipboard => 'ಕ್ಲಿಪ್‌ಬೋರ್ಡ್‌ಗೆ ನಕಲಿಸಲಾಗಿದೆ.';

  @override
  String get imported => 'ಆಮದು ಮಾಡಲಾಗಿದೆ.';

  @override
  String get boardImage => 'ಬೋರ್ಡ್ ಚಿತ್ರ';

  @override
  String get autumnLeaves => 'ಶರದಪಾತದ ಎಲೆಗಳು';

  @override
  String get legendaryLand => 'ಪೌರಾಣಿಕ ನೆಲ';

  @override
  String get vignetteEffect => 'ವಿನ್ಯೆಟ್ ಪರಿಣಾಮ';

  @override
  String get promptMakeToolbarTransparent =>
      'ಬೋರ್ಡ್ ಹಿನ್ನೆಲೆಯ ಚಿತ್ರವನ್ನು ಸೆಟ್ ಮಾಡಿದಾಗ ಟೂಲ್ಬಾರ್ ಅನ್ನು ಸಂಪೂರ್ಣವಾಗಿ ಪಾರದರ್ಶಕಗೊಳಿಸಲು ಬಯಸುವಿರಾ?';

  @override
  String get vibration => 'ಆಟದಲ್ಲಿ ಸ್ಪಂದನವನ್ನು ಸಕ್ರಿಯಗೊಳಿಸಿ';

  @override
  String get soundTheme => 'ಧ್ವನಿ ಥೀಮ್';

  @override
  String get ball => 'ಗುಡ್ಡ';

  @override
  String get liquid => 'ದ್ರವ';

  @override
  String get wood => 'ಮರ';

  @override
  String get placeEffectAnimation => 'ಮುಗ್ದವನ್ನು ಇರಿಸುವ ಅನಿಮೇಷನ್ ಪರಿಣಾಮ';

  @override
  String get removeEffectAnimation => 'ಮುಗ್ದವನ್ನು ತೆಗೆದುಹಾಕುವ ಅನಿಮೇಷನ್ ಪರಿಣಾಮ';

  @override
  String get isToolbarAtBottom => 'ಕೆಳಗೆ ಸಾಧನಪಟ್ಟಿಯನ್ನು ತೋರಿಸಿ';

  @override
  String get boardCornerRadius => 'ಬೋರ್ಡ್‌ನ ಮೂಲೆಯ ತ್ರಿಜ್ಯ';

  @override
  String get useOpeningBook => 'ಓಪನಿಂಗ್ ಬುಕ್ ಬಳಸಿ';

  @override
  String get currentRule => 'ಪ್ರಸ್ತುತ';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'ನಿಯಮಗಳ ಗುಂಪು';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'One-Time Mill';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'ಆರಂಭಿಕ ಆಟದಲ್ಲಿ ವೃತ್ತಿಪರ ಮಾನವ ಆಟಗಾರರು ಸಾಮಾನ್ಯವಾಗಿ ಬಳಸುವ ಓಪನಿಂಗ್ ಚಲನೆಗಳನ್ನು AI ಬಳಸಲು ಅನುಮತಿಸಿ. ಗಮನಿಸಿ: ಈ ವೈಶಿಷ್ಟ್ಯ ಪ್ರಸ್ತುತ ಕೆಲವು ನಿಯಮ ಸೆಟ್ಗಳಿಗೆ ಮಾತ್ರ ಲಭ್ಯವಿದೆ.';

  @override
  String get showAdvantageGraph => 'ಅಧಿಕ್ಯ ಗ್ರಾಫ್ ತೋರಿಸಿ';

  @override
  String get advantageGraphHint =>
      'AI ಚಲನೆಯನ್ನು ಮಾಡಿದ ನಂತರ ಮಾತ್ರ ಪ್ರಯೋಜನ ಗ್ರಾಫ್ ರಚಿಸಲಾಗುತ್ತದೆ. ಮಾನವ ಆಟಗಾರ ಚಲನೆಯನ್ನು ಮಾಡಿದಾಗ ಇದು ರಚಿಸಲಾಗದು.';

  @override
  String get removalBasedOnMillCounts =>
      'ಎಲ್ಲ ಟೋಕೆನ್‍ಗಳು ಹೊರಪಡಿಸಿಕೊಳ್ಳುವವರೆಗೂ ತೆಗೆದುಹಾಕುವ ಕ್ರಿಯೆಯನ್ನು ನಿಲ್ಲಿಸಿ. ಪ್ಲೇಯರ್‍ಗಳು ಮಿಲ್ ಎಣಿಕೆಯ ಆಧാരದಲ್ಲಿ ಟೋಕೆನ್‍ಗಳನ್ನು ತೆಗೆದುಹಾಕುತ್ತಾರೆ.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'ಎಲ್ಲ ಟೋಕೆನ್‍ಗಳು ಹೊರಪಡಿಸಿಕೊಳ್ಳುವವರೆಗೂ ತೆಗೆದುಹಾಕುವ ಕ್ರಿಯೆಯನ್ನು ನಿಲ್ಲಿಸಿ. ಪ್ಲೇಯರ್‍ಗಳು ಮಿಲ್ ಎಣಿಕೆಯ ಆಧಾರದಿಂದ ಟೋಕೆನ್‍ಗಳನ್ನು ತೆಗೆದುಹಾಕುತ್ತಾರೆ: ಎಣಿಕೆ ಸಮನಾಗಿದ್ದರೆ, ಇಬ್ಬರೂ ಸಮಾನ ಸಂಖ್ಯೆಯ ಟೋಕೆನ್‍ಗಳನ್ನು ತೆಗೆಯುತ್ತಾರೆ; ಒಬ್ಬರ ಬಳಿ ಹೆಚ್ಚು ಇದ್ದರೆ, ಅವನು ಒಂದು ಹೆಚ್ಚುವರಿ ಟೋಕೆನ್ ತೆಗೆಯುತ್ತಾನೆ ಹಾಗೂ ಒಂದು ಟೋಕೆನ್ ಅಂತರವನ್ನು ಉಳಿಸುತ್ತದೆ. ಒಬ್ಬವನು ಮಾತ್ರ ಮಿಲ್ ನಿರ್ಮಿಸಿದರೆ, ಅವನು ಎರಡು ಟೋಕೆನ್‍ಗಳನ್ನು ತೆಗೆಯುತ್ತಾನೆ, ಇನ್ನೊಬ್ಬನು ಒಂದು ಟೋಕೆನ್ ತೆಗೆಯುತ್ತಾನೆ. ಯಾರೂ ಮಿಲ್ ನಿರ್ಮಿಸದರೆ, ಇಬ್ಬರೂ ಒಂದು ಟೋಕೆನ್ ತೆಗೆಯುತ್ತಾರೆ.';

  @override
  String get elfilja => 'ಎಲ್ ಫಿಲ್ಜಾ';

  @override
  String get tipSelectOwnPiece => 'ನಿಮ್ಮ ಗೋಟಿಗಳಲ್ಲಿ ಒಂದನ್ನು ಆಯ್ಕೆಮಾಡಿ.';

  @override
  String get notYourTurn => 'ಇದು ನಿಮ್ಮ ಸರದಿ ಅಲ್ಲ.';

  @override
  String get annotationToolbarBackgroundColor =>
      'ಟಿಪ್ಪಣಿ ಉಪಕರಣಪಟ್ಟಿಯ ಹಿನ್ನೆಲೆ ಬಣ್ಣ';

  @override
  String get annotationToolbarIconColor => 'ಟಿಪ್ಪಣಿ ಉಪಕರಣಪಟ್ಟಿಯ ಐಕಾನ್ ಬಣ್ಣ';

  @override
  String get isAnnotationToolbarShown => 'ಟಿಪ್ಪಣಿ ಉಪಕರಣಪಟ್ಟಿಯನ್ನು ತೋರಿಸಿ';

  @override
  String get enterAnnotationMode => 'ಟಿಪ್ಪಣಿ ಮೋಡ್‌ಗೆ ಪ್ರವೇಶಿಸಿ';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'ನೀವು ಎಲ್ಲಾ ಟಿಪ್ಪಣಿಗಳನ್ನು ಅಳಿಸಲು ಖಚಿತವಾಗಿ ಬಯಸುತ್ತೀರಾ?';

  @override
  String get llmPromptCopiedToClipboard =>
      'LLM ಪ್ರಾಂಪ್ಟ್ ಕ್ಲಿಪ್‌ಬೋರ್ಡ್‌ಗೆ ನಕಲಿಸಲಾಗಿದೆ.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'ಸಂಪರ್ಕ ನಿರಾಕರಿಸಲಾಗಿದೆ, ಸರ್ವರ್ ಡೌನ್ ಆಗಿರಬಹುದು.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'ಶೋಧನೆ ಯಶಸ್ವಿಯಾಗಿದೆ, ಸಂಪರ್ಕಕ್ಕಾಗಿ ನಿರೀಕ್ಷಿಸಲಾಗುತ್ತಿದೆ...';

  @override
  String get noLanConnection => 'LAN ಸಂಪರ್ಕವಿಲ್ಲ';

  @override
  String get takeScreenshot => 'ಸ್ಕ್ರೀನ್‌ಶಾಟ್ ತೆಗೆದುಕೊಳ್ಳಿ';

  @override
  String get disconnectedFromOpponent => 'ಪ್ರತಿಸ್ಪರ್ಧಿಯಿಂದ ಸಂಪರ್ಕ ಕಡಿದುಹೋಗಿದೆ.';

  @override
  String get takeBackRequest => 'ಹಿಂದಿನ ಚಲನೆಯನ್ನು ರದ್ದುಗೊಳಿಸುವ ವಿನಂತಿ';

  @override
  String get nothingToShow => 'ತೋರಿಸಲು ಏನೂ ಇಲ್ಲ.';

  @override
  String get stopHosting => 'ಹೋಸ್ಟಿಂಗ್ ನಿಲ್ಲಿಸಿ';

  @override
  String get connectionResetByPeer => 'ಪೀರ್ ಮೂಲಕ ಸಂಪರ್ಕ ಮರುಹೊಂದಿಸಲಾಗಿದೆ.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'ಹಾರ್ಟ್‌ಬೀಟ್ ಟೈಮ್‌ಔಟ್‌ನಿಂದ ಸಂಪರ್ಕ ಕಳೆದುಹೋಗಿದೆ. ದಯವಿಟ್ಟು ಮರುಸಂಪರ್ಕಿಸಿ.';

  @override
  String get startHosting => 'ಹೋಸ್ಟಿಂಗ್ ಪ್ರಾರಂಭಿಸಿ';

  @override
  String get restartRequestRejected => 'ಮರುಪ್ರಾರಂಭದ ವಿನಂತಿ ತಿರಸ್ಕರಿಸಲಾಗಿದೆ.';

  @override
  String get notConnectedToLanOpponent => 'LAN ಪ್ರತಿಸ್ಪರ್ಧಿಗೆ ಸಂಪರ್ಕಗೊಂಡಿಲ್ಲ.';

  @override
  String get llmPrompt => 'LLM ಪ್ರಾಂಪ್ಟ್';

  @override
  String get gameRestarted => 'ಆಟ ಮರುಪ್ರಾರಂಭಿಸಲಾಗಿದೆ.';

  @override
  String get takeBackRejected => 'ಹಿಂದಿನ ಚಲನೆಯ ರದ್ದು ತಿರಸ್ಕರಿಸಲಾಗಿದೆ.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'ನೀವು ಈ ಆಟವನ್ನು ತ್ಯಜಿಸಲು ಖಚಿತವಾಗಿ ಬಯಸುತ್ತೀರಾ?';

  @override
  String get opponentResignedYouWin =>
      'ಪ್ರತಿಸ್ಪರ್ಧಿ ತ್ಯಜಿಸಿದ್ದಾರೆ. ನೀವು ಗೆದ್ದಿದ್ದೀರಿ!';

  @override
  String get clearAllAnnotations => 'ಎಲ್ಲಾ ಟಿಪ್ಪಣಿಗಳನ್ನು ಅಳಿಸಿ';

  @override
  String get connectedWaitingForOpponentSMove =>
      'ಸಂಪರ್ಕಗೊಂಡಿದೆ, ಪ್ರತಿಸ್ಪರ್ಧಿಯ ಚಲನೆಗಾಗಿ ನಿರೀಕ್ಷಿಸಲಾಗುತ್ತಿದೆ...';

  @override
  String get networkStatusDisconnected =>
      'ನೆಟ್‌ವರ್ಕ್ ಸ್ಥಿತಿ: ಸಂಪರ್ಕ ಕಡಿದುಹೋಗಿದೆ';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'ಹಿಂದಿನ ಚಲನೆಯನ್ನು ರದ್ದುಗೊಳಿಸುವ ವಿನಂತಿ ಪ್ರತಿಸ್ಪರ್ಧಿಗೆ ಕಳುಹಿಸಲಾಗಿದೆ.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'ಪ್ರತಿಸ್ಪರ್ಧಿ ಆಟವನ್ನು ಬಿಟ್ಟಿರಬಹುದು';

  @override
  String get connectedToHostSuccessfully =>
      'ಹೋಸ್ಟ್‌ಗೆ ಯಶಸ್ವಿಯಾಗಿ ಸಂಪರ್ಕಗೊಂಡಿದೆ.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'ಸಂಪರ್ಕ ಕಳೆದುಹೋಗಿದೆ: ಹಾರ್ಟ್‌ಬೀಟ್ ಟೈಮ್‌ಔಟ್';

  @override
  String get noHostDiscovered => 'ಯಾವುದೇ ಹೋಸ್ಟ್ ಕಂಡುಬಂದಿಲ್ಲ.';

  @override
  String get confirmResignation => 'ತ್ಯಜಿಸುವಿಕೆಯನ್ನು ದೃಢೀಕರಿಸಿ';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'ಆಟ ಹೋಸ್ಟಿಂಗ್ ಪ್ರಾರಂಭಿಸಲಾಗಿದೆ, ಆಟಗಾರರು ಸೇರಲು ನಿರೀಕ್ಷಿಸಲಾಗುತ್ತಿದೆ...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'ಸಂಪರ್ಕ ಟೈಮ್‌ಔಟ್ ಆಗಿದೆ, ನೆಟ್‌ವರ್ಕ್ ಸಂಪರ್ಕ ಅಸ್ಥಿರವಾಗಿದೆ.';

  @override
  String get noLlmPromptAvailable => 'ಯಾವುದೇ LLM ಪ್ರಾಂಪ್ಟ್ ಲಭ್ಯವಿಲ್ಲ.';

  @override
  String get youResignedGameOver => 'ನೀವು ತ್ಯಜಿಸಿದ್ದೀರಿ. ಆಟ ಮುಗಿದಿದೆ.';

  @override
  String get serverIp => 'ಸರ್ವರ್ IP';

  @override
  String get confirmClear => 'ಅಳಿಸುವಿಕೆಯನ್ನು ದೃಢೀಕರಿಸಿ';

  @override
  String get opponentSTurn => 'ಪ್ರತಿಸ್ಪರ್ಧಿಯ ಸರದಿ.';

  @override
  String get waitingAClientConnection =>
      'ಕ್ಲೈಂಟ್ ಸಂಪರ್ಕಕ್ಕಾಗಿ ನಿರೀಕ್ಷಿಸಲಾಗುತ್ತಿದೆ...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'ಹಿಂದಿನ ಚಲನೆಯ ರದ್ದು ವಿನಂತಿ ತಿರಸ್ಕರಿಸಲಾಗಿದೆ ಅಥವಾ ವಿಫಲವಾಗಿದೆ.';

  @override
  String get addText => 'ಪಠ್ಯವನ್ನು ಸೇರಿಸಿ';

  @override
  String get exitAnnotationMode => 'ಟಿಪ್ಪಣಿ ಮೋಡ್‌ನಿಂದ ನಿರ್ಗಮಿಸಿ';

  @override
  String get typeYourAnnotation => 'ನಿಮ್ಮ ಟಿಪ್ಪಣಿಯನ್ನು ಟೈಪ್ ಮಾಡಿ';

  @override
  String get attemptingToReconnect => 'ಮರುಸಂಪರ್ಕಿಸಲು ಪ್ರಯತ್ನಿಸಲಾಗುತ್ತಿದೆ...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'ಮರುಪ್ರಾರಂಭದ ವಿನಂತಿ ಕಳುಹಿಸಲಾಗಿದೆ. ಪ್ರತಿಸ್ಪರ್ಧಿಯ ಪ್ರತಿಕ್ರಿಯೆಗಾಗಿ ನಿರೀಕ್ಷಿಸಲಾಗುತ್ತಿದೆ...';

  @override
  String get serverIsStopped => 'ಸರ್ವರ್ ನಿಲ್ಲಿಸಲಾಗಿದೆ.';

  @override
  String get restartRequest => 'ಮರುಪ್ರಾರಂಭದ ವಿನಂತಿ';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'ಇದು ನಿಮ್ಮ ಸರದಿ ಅಲ್ಲದಿದ್ದಾಗ ಹಿಂದಿನ ಚಲನೆಯನ್ನು ರದ್ದುಗೊಳಿಸುವ ವಿನಂತಿ ಮಾಡಲು ಸಾಧ್ಯವಿಲ್ಲ.';

  @override
  String get takeBackAccepted => 'ಹಿಂದಿನ ಚಲನೆಯ ರದ್ದು ಸ್ವೀಕರಿಸಲಾಗಿದೆ.';

  @override
  String get localNetworkSettings => 'ಸ್ಥಳೀಯ ನೆಟ್‌ವರ್ಕ್ ಸೆಟ್ಟಿಂಗ್‌ಗಳು';

  @override
  String get reconnectedSuccessfully => 'ಯಶಸ್ವಿಯಾಗಿ ಮರುಸಂಪರ್ಕಗೊಂಡಿದೆ!';

  @override
  String get failedToSaveImageToGallery =>
      'ಚಿತ್ರವನ್ನು ಗ್ಯಾಲರಿಗೆ ಉಳಿಸಲು ವಿಫಲವಾಗಿದೆ.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'ಪ್ರತಿಸ್ಪರ್ಧಿ ಆಟವನ್ನು ಮರುಪ್ರಾರಂಭಿಸಲು ವಿನಂತಿಸಿದ್ದಾರೆ. ನೀವು ಸ್ವೀಕರಿಸುತ್ತೀರಾ?';

  @override
  String get yourTurn => 'ನಿಮ್ಮ ಸರದಿ.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'ಮರುಸಂಪರ್ಕಿಸಲು ಸಾಧ್ಯವಾಗಿಲ್ಲ, ದಯವಿಟ್ಟು ಆಟವನ್ನು ಮರುಪ್ರಾರಂಭಿಸಿ.';

  @override
  String get host => 'ಹೋಸ್ಟ್';

  @override
  String get join => 'ಸೇರಿ';

  @override
  String get port => 'ಪೋರ್ಟ್';

  @override
  String get invalidIpAddress => 'ಅಮಾನ್ಯ IP ವಿಳಾಸ.';

  @override
  String get invalidPort => 'ಅಮಾನ್ಯ ಪೋರ್ಟ್.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'ಸಂಪರ್ಕಿಸಲಾಗುತ್ತಿದೆ: ಪ್ರಯತ್ನ $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'ಸಂಪರ್ಕಿಸಲು ವಿಫಲವಾಗಿದೆ: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'ಹೋಸ್ಟಿಂಗ್ ಪ್ರಾರಂಭಿಸಲು ವಿಫಲವಾಗಿದೆ: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'ಹೋಸ್ಟ್ ಕಂಡುಬಂದಿದೆ: $ip:$port';
  }

  @override
  String get stop => 'ನಿಲ್ಲಿಸಿ';

  @override
  String get discover => 'ಶೋಧಿಸಿ';

  @override
  String get connect => 'ಸಂಪರ್ಕಿಸಿ';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'ಕ್ಲೈಂಟ್ ಸಂಪರ್ಕಗೊಂಡಿದೆ: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'ಶೋಧಿಸಲಾಗುತ್ತಿದೆ: $seconds ಸೆ';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'ಮರುಸಂಪರ್ಕಿಸಲಾಗುತ್ತಿದೆ ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'ಸಂಪರ್ಕಗೊಂಡಿದೆ';

  @override
  String get delete => 'ಅಳಿಸಿ';

  @override
  String get ancientEgypt => 'ಪ್ರಾಚೀನ ಈಜಿಪ್ಟ್';

  @override
  String get gothicIce => 'ಗೋಥಿಕ್ ಮಂಜುಗಡ್ಡೆ';

  @override
  String get riceField => 'ಭತ್ತದ ಗದ್ದೆ';

  @override
  String get chinesePorcelain => 'ಚೀನೀ ಮಣ್ಣಿನ ಪಾತ್ರೆ';

  @override
  String get desertDusk => 'ಮರಳುಗಾಡಿನ ಸಂಜೆ';

  @override
  String get precisionCraft => 'ನಿಖರ ಕರಕುಶಲತೆ';

  @override
  String get folkEmbroidery => 'ಜಾನಪದ ಕಸೂತಿ';

  @override
  String get carpathianHeritage => 'ಕಾರ್ಪೇಥಿಯನ್ ಪರಂಪರೆ';

  @override
  String get imperialGrandeur => 'ಸಾಮ್ರಾಜ್ಯದ ವೈಭವ';

  @override
  String get bohemianCrystal => 'ಬೊಹೀಮಿಯನ್ ಸ್ಫಟಿಕ';

  @override
  String get savannaSunrise => 'ಸವಾನಾ ಸೂರ್ಯೋದಯ';

  @override
  String get harmonyBalance => 'ಸಾಮರಸ್ಯ ಸಮತೋಲನ';

  @override
  String get cinnamonSpice => 'ದಾಲ್ಚಿನ್ನಿ ಮಸಾಲೆ';

  @override
  String get anatolianMosaic => 'ಅನಾಟೋಲಿಯನ್ ಮೊಸಾಯಿಕ್';

  @override
  String get carnivalSpirit => 'ಕಾರ್ನಿವಲ್ ಆತ್ಮ';

  @override
  String get custom => 'ಪದ್ಧತಿ';

  @override
  String get spiceMarket => 'ಮಸಾಲೆ ಮಾರುಕಟ್ಟೆ';

  @override
  String get swipeToRevealTheDrawer => 'ಡ್ರಾಯರ್ ತೋರಿಸಲು ಸ್ವೈಪ್ ಮಾಡಿ';

  @override
  String get showGameInfoOnScreenshots =>
      'ಸ್ಕ್ರೀನ್‌ಶಾಟ್‌ಗಳಲ್ಲಿ ಆಟದ ಮಾಹಿತಿಯನ್ನು ತೋರಿಸು';

  @override
  String get humanMoveTime => 'ಮಾನವ ಸಮಯ ಮಿತಿ';

  @override
  String get noTimeLimitForHumanMoves => 'ಮಾನವ ಚಲನೆಗಳಿಗೆ ಸಮಯ ಮಿತಿ ಇಲ್ಲ';

  @override
  String get timeoutLoseWillBeApplied =>
      'ಮಾನವ ಆಟಗಾರನಿಗೆ ಸಮಯ ಮೀರುವಿಕೆ ಸೋಲು ಅನ್ವಯಿಸಲಾಗುತ್ತದೆ';

  @override
  String get identifyingBoard => 'ಗೇಮ್ ಫಲಕವನ್ನು ಗುರುತಿಸಲಾಗುತ್ತಿದೆ…';

  @override
  String get youCanEnterAnyModelName =>
      'ನೀವು ಯಾವುದೇ ಮಾದರಿ ಹೆಸರನ್ನು ನಮೂದಿಸಬಹುದು.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'ಫಲಕದ ಸ್ಥಿತಿಯನ್ನು ಅನ್ವಯಿಸಲಾಯಿತು. FEN ಕ್ಲಿಪ್‌ಬೋರ್ಡ್‌ಗೆ ನಕಲಿಸಲಾಯಿತು.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'ಸಲಹೆ: ಫಲಕದ ಸ್ಪಷ್ಟವಾದ ಚಿತ್ರವನ್ನು ತೆಗೆದುಕೊಳ್ಳಿ.';

  @override
  String get llmPromptTemplate => 'LLM ಪ್ರಾಂಪ್‌ಟ್ ಟೆಂಪ್ಲೇಟ್';

  @override
  String get noValidBoardDetected => 'ಯಾವುದೇ ಮಾನ್ಯ ಫಲಕ ಕಂಡುಬಂದಿಲ್ಲ.';

  @override
  String get selectingImageFromAlbum =>
      'ಆಲ്ബಮ್‌ನಿಂದ ಚಿತ್ರ ಆಯ್ಕೆ ಮಾಡಲಾಗುತ್ತಿದೆ…';

  @override
  String get configurePromptTemplate => 'ಪ್ರಾಂಪ್‌ಟ್ ಟೆಂಪ್ಲೇಟ್ ಸಂರಚಿಸಿ';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'LLM ವಿಶ್ಲೇಷಣೆಗೆ ಪ್ರಾಂಪ್‌ಟ್ ಟೆಂಪ್ಲೇಟ್ ಸಂಪಾದಿಸಿ';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'ಗುರುತಿಸಲಾದ ಫಲಕದಿಂದ FEN ರಚಿಸಲು ವಿಫಲವಾಯಿತು.';

  @override
  String get outputInCurrentLanguage => 'ಪ್ರಸ್ತುತ ಭಾಷೆಯಲ್ಲಿ ಔಟ್‌ಪುಟ್';

  @override
  String get commonBaseUrls => 'ಸಾಮಾನ್ಯ ಬೇಸ್ URL‌ಗಳು';

  @override
  String get viewCommonModels => 'ಸಾಮಾನ್ಯ ಮಾದರಿಗಳನ್ನು ವೀಕ್ಷಿಸಿ';

  @override
  String get recognitionParametersUpdated =>
      'ಗುರುತಿಸುವ ಪರಾಮೀಟರ್ಗಳು ನವೀಕರಿಸಲ್ಪಟ್ಟಿವೆ.';

  @override
  String get whiteSMove => 'ಬಿಳಿಯರ ಚಲನೆ';

  @override
  String get resetToDefaults => 'ಪೂರ್ವನಿಯೋಜಿತ ಮೌಲ್ಯಗಳಿಗೆ ಮರುಹೊಂದಿಸಿ';

  @override
  String get photoShoot => 'ಛಾಯಾಚಿತ್ರ ಸೆಷನ್';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'ಗುರುತಿಸಲಾದ ಫಲಕ ಸ್ಥಿತಿಯನ್ನು ಅನ್ವಯಿಸಲು ವಿಫಲವಾಯಿತು.';

  @override
  String get llmPromptContent => 'LLM ಪ್ರಾಂಪ್‌ಟ್ ವಿಷಯ';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM ಸಂರಚಿಸಲಾಗಿಲ್ಲ. ದಯವಿಟ್ಟು ಸೆಟ್ಟಿಂಗ್‌ಗಳನ್ನು ಪರಿಶೀಲಿಸಿ.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'ಪ್ರದಾತ, ಮಾದರಿ, API Key ಮತ್ತು Base URL ಅನ್ನು ಹೊಂದಿಸಿ';

  @override
  String get llmConfiguration => 'LLM ಸಂರಚನೆ';

  @override
  String get configureLlmProvider => 'LLM ಪ್ರದಾತೆಯನ್ನು ಸಂರಚಿಸಿ';

  @override
  String get llmPromptTemplateHeader => 'LLM ಪ್ರಾಂಪ್‌ಟ್ ಟೆಂಪ್ಲೇಟ್ ಶಿರೋನಾಮೆ';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'ಚಿತ್ರದಲ್ಲಿ ಯಾವುದೇ ತುಂಡು ಗುರುತಿಸಲ್ಪಡಲಿಲ್ಲ. ದಯವಿಟ್ಟು ಮತ್ತೆ ಪ್ರಯತ್ನಿಸಿ.';

  @override
  String get recognizeBoardFromImage => 'ಚಿತ್ರದಿಂದ ಫಲಕವನ್ನು ಗುರುತಿಸಿ';

  @override
  String get viewTips => 'ಸೂಚನೆಗಳನ್ನು ವೀಕ್ಷಿಸಿ';

  @override
  String get applyToBoard => 'ಫಲಕಕ್ಕೆ ಅನ್ವಯಿಸಿ';

  @override
  String get adjustBoardArea => 'ಫಲಕ ಪ್ರದೇಶವನ್ನು ಹೊಂದಿಸಿ';

  @override
  String get viewCommonUrls => 'ಸಾಮಾನ್ಯ URLಗಳನ್ನು ವೀಕ್ಷಿಸಿ';

  @override
  String get colorAnalysisFailed => 'ಬಣ್ಣ ವಿಶ್ಲೇಷಣೆ ವಿಫಲವಾಯಿತು!';

  @override
  String get analyzingGameBoardImage =>
      'ಗೇಮ್ ಫಲಕದ ಚಿತ್ರವನ್ನು ವಿಶ್ಲೇಷಿಸಲಾಗುತ್ತಿದೆ…';

  @override
  String get selectFromAlbum => 'ಆಲ್ಬಮ್‌ದಿಂದ ಆಯ್ಕೆಮಾಡಿ';

  @override
  String get noBoardPointDetected => 'ಯಾವುದೇ ಫಲಕ ಬಿಂದುವನ್ನು ಪತ್ತೆಮಾಡಲಾಗಲಿಲ್ಲ!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'ಖಾಲಿಯಾಗಿದ್ದರೆ, ಪೂರ್ವನಿಯೋಜಿತ ಟೆಂಪ್ಲೇಟ್ ಬಳಸಲಾಗುತ್ತದೆ';

  @override
  String get llmConfig => 'LLM ಸಂರಚನೆ';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'ಪ್ರಾಂಪ್‌ಟ್ ಟೆಂಪ್ಲೇಟ್ಗಳನ್ನು ಪೂರ್ವನಿಯೋಜಿತ ಮೌಲ್ಯಗಳಿಗೆ ಮರುಹೊಂದಿಸಲು ಖಚಿತರಾ?';

  @override
  String get llmPromptTemplateFooter => 'LLM ಪ್ರಾಂಪ್‌ಟ್ ಟೆಂಪ್ಲೇಟ್ ಪಾದಲೇಖೆ';

  @override
  String get loadingResponse => 'ಪ್ರತಿಕ್ರಿಯೆಯನ್ನು ಲೋಡ್ ಮಾಡಲಾಗುತ್ತಿದೆ…';

  @override
  String get applyThisResultToBoard => 'ಈ ಫಲಿತಾಂಶವನ್ನು ಫಲಕಕ್ಕೆ ಅನ್ವಯಿಸಿ';

  @override
  String get takingPicture => 'ಚಿತ್ರ ತೆಗೆದುಕೊಳ್ಳಲಾಗುತ್ತಿದೆ…';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'ಗುರುತಿಸಲು ದಯವಿಟ್ಟು ಗೇಮ್ ಫಲಕದ ಚಿತ್ರವನ್ನು ಆಯ್ಕೆಮಾಡಿ';

  @override
  String get identificationResults => 'ಗುರುತಿನ ಫಲಿತಾಂಶಗಳು';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'ಚಲನೆಗಳನ್ನು ವಿಶ್ಲೇಷಿಸಿ ಮತ್ತು ಅಂತರದೃಷ್ಟಿ ನೀಡಿ.';

  @override
  String get getApiKey => 'API Key ಪಡೆಯಿರಿ';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'ಗುರುತಿ ಪ್ರಕ್ರಿಯೆ ಸಂಪೂರ್ಣವಾಗಿ ಪೂರ್ಣಗೊಳ್ಳಲಿಲ್ಲ.';

  @override
  String get boardRecognitionResult => 'ಫಲಕ ಗುರುತಿನ ಫಲಿತಾಂಶ';

  @override
  String get askLlm => 'LLMಗೆ ಕೇಳಿ';

  @override
  String get boardDetectionFailed => 'ಫಲಕ ಪತ್ತೆ ವಿಫಲವಾಯಿತು!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'ಯಾವುದೇ ಫಲಕ ಬಿಂದುವೂ ಪತ್ತೆಯಾಗಲಿಲ್ಲ, ತುಂಡನ್ನು ಗುರುತಿಸಲು ಸಾಧ್ಯವಿಲ್ಲ!';

  @override
  String get copyFen => 'FEN ನಕಲಿಸಿ';

  @override
  String get commonlyUsedModels => 'ಸಾಮಾನ್ಯವಾಗಿ ಬಳಸುವ ಮಾದರಿಗಳು';

  @override
  String get apiKeyOptional => 'API Key (ಐಚ್ಛಿಕ)';

  @override
  String get noImageSelected => 'ಯಾವುದೇ ಚಿತ್ರ ಆಯ್ಕೆಮಾಡಲಾಗಿಲ್ಲ';

  @override
  String get blackSMove => 'ಕಪ್ಪುಬಣ್ಣದ ಚಲನೆ';

  @override
  String get llm => 'ದೊಡ್ಡ ಭಾಷಾ ಮಾದರಿ';

  @override
  String get llmProvider => 'ಪೂರೈಕೆದಾರ';

  @override
  String get baseUrl => 'ಮೂಲ URL';

  @override
  String get model => 'ಮಾಡೆಲ್';

  @override
  String get temperature => 'ತಾಪಮಾನ';

  @override
  String get llmCommandReceivedProcessing =>
      'ಆಜ್ಞೆ ಸ್ವೀಕರಿಸಲಾಗಿದೆ! AI ಪ್ರಕ್ರಿಯೆಗೊಳಗಾಗುತ್ತಿದೆ...';

  @override
  String get llmDeepThinkingWait =>
      'ಗಾಢವಾಗಿ ಚಿಂತಿಸಲಾಗುತ್ತಿದೆ, ದಯವಿಟ್ಟು ಕಾಯಿರಿ...';

  @override
  String get llmPresentingSoon => 'ಶೀಘ್ರದಲ್ಲೇ ಪ್ರಸ್ತುತಪಡಿಸಲಾಗುವುದು...';

  @override
  String get recognitionParameters => 'ಗುರುತಿಸುವ ಪ್ಯಾರಾಮೀಟರ್‌ಗಳು';

  @override
  String get adjustParamsDesc =>
      'ಗುರುತಿಸುವ ನಿಖರತೆ ಹೆಚ್ಚಿಸಲು ಪ್ಯಾರಾಮೀಟರ್‌ಗಳನ್ನು ಹೊಂದಿಸು';

  @override
  String get saveParameters => 'ಪ್ಯಾರಾಮೀಟರ್‌ಗಳನ್ನು ಉಳಿಸು';

  @override
  String unableToStartImageRecognition(String error) {
    return 'ಚಿತ್ರ ಗುರುತಿಸುವಿಕೆಯನ್ನು ಪ್ರಾರಂಭಿಸಲು ಸಾಧ್ಯವಾಗಲಿಲ್ಲ: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'ಚಿತ್ರ ಗುರುತಿಸುವಿಕೆ ವಿಫಲವಾಯಿತು: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return '$whiteCount ಬಿಳಿ ಹಾಗೂ $blackCount ಕಪ್ಪು ಗುಂಡುಗಳೊಂದಿಗೆ ಸ್ಥಾನ ಅನ್ವಯಿಸಲಾಗಿದೆ';
  }

  @override
  String get fenCopiedToClipboard => '(FEN ಕ್ಲಿಪ್‌ಬೋರ್ಡಿಗೆ ನಕಲಿಸಲಾಗಿದೆ)';

  @override
  String recognitionFailed(String error) {
    return 'ಗುರುತಿಸುವಿಕೆ ವಿಫಲವಾಯಿತು: $error';
  }

  @override
  String get myRating => 'ನನ್ನ ರೇಟಿಂಗ್';

  @override
  String get gamesPlayed => 'ಆಡಿದ ಆಟಗಳು';

  @override
  String get wins => 'ಗೆಲುವುಗಳು';

  @override
  String get losses => 'ಸೋಲುಗಳು';

  @override
  String get draws => 'ಡ್ರಾಗಳು';

  @override
  String get lastUpdated => 'ಕೊನೆಯದಾಗಿ ನವೀಕರಿಸಲಾಗಿದೆ';

  @override
  String get format => 'ಫಾರ್ಮ್ಯಾಟ್:';

  @override
  String get resetStatistics => 'ಅಂಕಿಅಂಶಗಳನ್ನು ಮರುಹೊಂದಿಸಿ';

  @override
  String get drawRate => 'ಡ್ರಾ ದರ';

  @override
  String get lossRate => 'ಸೋಲಿನ ದರ';

  @override
  String get aiStatistics => 'AI ಅಂಕಿಅಂಶಗಳು';

  @override
  String get enableStatistics => 'ಅಂಕಿಅಂಶಗಳನ್ನು ಸಕ್ರಿಯಗೊಳಿಸಿ';

  @override
  String get enableStatistics_Detail =>
      'ಸಕ್ರಿಯಗೊಳಿಸಿದಾಗ, ಆಟದ ಫಲಿತಾಂಶಗಳನ್ನು ಅಂಕಿಅಂಶಗಳಲ್ಲಿ ದಾಖಲಿಸಲಾಗುತ್ತದೆ. ಆದಾಗ್ಯೂ, ಟೇಕ್-ಬ್ಯಾಕ್‌ಗಳನ್ನು ಒಳಗೊಂಡಿರುವ ಆಟಗಳನ್ನು ದಾಖಲಿಸಲಾಗುವುದಿಲ್ಲ. ನಿಷ್ಕ್ರಿಯಗೊಳಿಸಿದಾಗ, ಅಂಕಿಅಂಶಗಳ ಸಂಗ್ರಹಣೆಯನ್ನು ವಿರಾಮಗೊಳಿಸಲಾಗುತ್ತದೆ.';

  @override
  String get thisWillResetAllGameStatistics =>
      'ಇದು ಎಲ್ಲಾ ಆಟದ ಅಂಕಿಅಂಶಗಳನ್ನು ಮರುಹೊಂದಿಸುತ್ತದೆ. ಈ ಕ್ರಿಯೆಯನ್ನು ರದ್ದುಗೊಳಿಸಲಾಗುವುದಿಲ್ಲ.';

  @override
  String get boardInnerRingSize => 'ಬೋರ್ಡ್‌ನ ಆಂತರಿಕ ವೃತ್ತದ ಗಾತ್ರ';

  @override
  String get boardShadowEnabled => 'ಬೋರ್ಡ್ ನೆರಳು';

  @override
  String get trapAwareness => 'ಬಲೆ ಗುರುತಿಸುವಿಕೆ';

  @override
  String get trapAwarenessDescription =>
      'ವಿಶ್ಲೇಷಣೆ ಸಮಯದಲ್ಲಿ ದಪ್ಪ ವೃತ್ತಗಳು ಮತ್ತು ಬಾಣಗಳೊಂದಿಗೆ ಬಲೆಯ ಚಲನೆಗಳನ್ನು ಹೈಲೈಟ್ ಮಾಡಿ.';

  @override
  String trapExists(String trapMoves) {
    return 'ಬಲೆ ಇದೆ. ಬಲೆಯ ಚಲನೆಗಳು: $trapMoves';
  }

  @override
  String get custodianCapture => 'ಸುತ್ತಾಟ';

  @override
  String get custodianCaptureDescription =>
      'ಅದನ್ನು ಸೆರೆಹಿಡಿಯಲು ನಿಮ್ಮ ಎದುರಾಳಿಯ ತುಣುಕುಗಳಲ್ಲಿ ಒಂದನ್ನು ನಿಮ್ಮ ಎರಡು ನಡುವೆ ಸರಳ ಸಾಲಿನಲ್ಲಿ ಸುತ್ತಿಕೊಳ್ಳಿ.';

  @override
  String get custodianCaptureEnable => 'ಪಾರ್ಶ್ವ ಸೆರೆಹಿಡಿಯಲು ಅನುಮತಿಸಿ';

  @override
  String get interventionCapture => 'ಹಸ್ತಕ್ಷೇಪ';

  @override
  String get interventionCaptureDescription =>
      'ಎರಡನ್ನೂ ಸೆರೆಹಿಡಿಯಲು ನಿಮ್ಮ ಎರಡು ಎದುರಾಳಿಯ ತುಣುಕುಗಳ ನಡುವೆ ಖಾಲಿ ಬಿಂದುವಿಗೆ ಸರಿಸಿ.';

  @override
  String get interventionCaptureEnable => 'ಹಸ್ತಕ್ಷೇಪ ಸೆರೆಹಿಡಿಯಲು ಅನುಮತಿಸಿ';

  @override
  String get leapCapture => 'ಜಿಗಿತದ ಸೆರೆಹಿಡಿಯುವಿಕೆ';

  @override
  String get leapCaptureDescription =>
      'ಪಕ್ಕದ ಎದುರಾಳಿಯ ತುಣುಕನ್ನು ಖಾಲಿ ಬಿಂದುವಿಗೆ ಹಾರಿ ಸೆರೆಹಿಡಿಯಿರಿ.';

  @override
  String get leapCaptureEnable => 'ಜಂಪ್ ಕ್ಯಾಪ್ಚರ್ ಅನ್ನು ಅನುಮತಿಸಿ';

  @override
  String get captureApplicableLines => 'ಅನ್ವಯಿಸುವ ರೇಖೆಗಳು';

  @override
  String get captureSquareEdges => 'ಚೌಕದ ಅಂಚುಗಳ ಉದ್ದಕ್ಕೂ';

  @override
  String get captureCrossLines => 'ಚೌಕವನ್ನು ದಾಟುವ ಆರ್ಥೋಗೋನಲ್ ರೇಖೆಗಳ ಉದ್ದಕ್ಕೂ';

  @override
  String get captureDiagonalLines => 'ಚೌಕವನ್ನು ದಾಟುವ ಕರ್ಣೀಯ ರೇಖೆಗಳ ಉದ್ದಕ್ಕೂ';

  @override
  String get captureExecutionPhases => 'ಮರಣದಂಡನೆ ಹಂತಗಳು';

  @override
  String get capturePiecesCondition =>
      'ಉಳಿದ ತುಣುಕುಗಳ ಆಧಾರದ ಮೇಲೆ ಚಲಿಸುವ ಹಂತದಲ್ಲಿ ಲಭ್ಯತೆ';

  @override
  String get capturePiecesConditionUnlimited => 'ಯಾವುದೇ ನಿರ್ಬಂಧವಿಲ್ಲ';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'ನೀವು ಮೂರು ಅಥವಾ ಕಡಿಮೆ ತುಣುಕುಗಳನ್ನು ಹೊಂದಿರುವಾಗ ಲಭ್ಯವಿದೆ';
}
