// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Khmer Central Khmer (`km`).
class SKm extends S {
  SKm([String locale = 'km']) : super(locale);

  @override
  String get appName => 'មីល';

  @override
  String get welcome => 'សូមស្វាគមន៍';

  @override
  String get yes => 'បាទ/ចាស';

  @override
  String get no => 'ទេ';

  @override
  String get game => 'ហ្គេម';

  @override
  String get humanVsAi => 'មនុស្ស Vs. AI';

  @override
  String get humanVsHuman => 'មនុស្ស Vs. មនុស្ស';

  @override
  String get aiVsAi => 'AI Vs. AI';

  @override
  String get humanVsCloud => 'មនុស្ស Vs. Cloud';

  @override
  String get humanVsLAN => 'មនុស្ស Vs. LAN';

  @override
  String get testViaLAN => 'សាកល្បងតាម LAN';

  @override
  String get move => 'ផ្លាស់ទី';

  @override
  String get showMoveList => 'បញ្ជីចលនា';

  @override
  String get moveList => 'បញ្ជីចលនា';

  @override
  String get noGameRecord => 'គ្មានកំណត់ត្រា';

  @override
  String get ok => 'យល់ព្រម';

  @override
  String get confirm => 'បញ្ជាក់';

  @override
  String get cancel => 'បោះបង់';

  @override
  String get tipSelectWrong => 'ជ្រើសរើសកូនអុកខុស។';

  @override
  String get tipPlace => 'ដាក់កូនអុករបស់អ្នក។';

  @override
  String get tipBanPlace => 'អ្នកមិនអាចដាក់វានៅទីនេះបានទេ។';

  @override
  String get tipPlaced => 'បានដាក់កូនអុកហើយ។';

  @override
  String get tipRemove => 'ដកកូនអុកចេញ។';

  @override
  String get tipBanRemove => 'អ្នកមិនអាចដកវាចេញបានទេ។';

  @override
  String get tipRemoved => 'បានដកកូនអុកចេញហើយ។';

  @override
  String get tipMove => 'ផ្លាស់ទីកូនអុក។';

  @override
  String get tipCannotPlace => 'អ្នកមិនអាចដាក់កូនអុករបស់អ្នកនៅទីនេះបានទេ។';

  @override
  String get tipCannotMove => 'អ្នកមិនអាចផ្លាស់ទីកូនអុករបស់អ្នកនៅទីនេះបានទេ។';

  @override
  String get tipMill => 'មីល! ដកកូនអុករបស់គូប្រកួតចេញ។';

  @override
  String get tipContinueMill => 'បន្តដកកូនអុករបស់គូប្រកួតចេញ។';

  @override
  String get tipSelectOpponentsPiece => 'ជ្រើសរើសកូនអុកមួយរបស់គូប្រកួត។';

  @override
  String get tipCannotRemovePieceFromMill => 'អ្នកមិនអាចដកកូនអុកចេញពីមីលបានទេ។';

  @override
  String get tipCanMoveOnePoint => 'កូនអុកអាចផ្លាស់ទីបាន 1 ចំណុច។';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'អ្នកមិនអាចផ្លាស់ទីកូនអុករបស់គូប្រកួតបានទេ។';

  @override
  String get tipSelectPieceToMove => 'ជ្រើសរើសកូនអុករបស់អ្នកដើម្បីផ្លាស់ទី។';

  @override
  String get tipHaveThreePiecesLeft => 'អ្នកនៅសល់កូនអុកបី។';

  @override
  String get tipCanMoveToAnyPoint =>
      'អ្នកអាចផ្លាស់ទីទៅចំណុចណាក៏បានដែលអ្នកចូលចិត្ត។';

  @override
  String tipToMove(Object player) {
    return 'ដល់វេន $player លេង។';
  }

  @override
  String get whiteWin => 'អ្នកលេង 1 ឈ្នះ!';

  @override
  String get blackWin => 'អ្នកលេង 2 ឈ្នះ!';

  @override
  String get won => 'ឈ្នះ';

  @override
  String get lost => 'ចាញ់';

  @override
  String get thinking => 'កំពុងគិត…';

  @override
  String get newGame => 'ហ្គេមថ្មី';

  @override
  String get importGame => 'នាំចូលហ្គេម';

  @override
  String get exportGame => 'នាំចេញហ្គេម';

  @override
  String get gameImported => 'បាននាំចូលហ្គេម។';

  @override
  String cannotImport(Object invalidMove) {
    return 'មិនអាចនាំចូល $invalidMove បានទេ';
  }

  @override
  String get movesAndRulesNotMatch => 'ចលនា និងច្បាប់មិនត្រូវគ្នាទេ។';

  @override
  String get pleaseWait => 'សូម​រង់ចាំ។';

  @override
  String get restartGame => 'ចាប់ផ្តើមហ្គេមបច្ចុប្បន្នឡើងវិញ?';

  @override
  String get restart => 'ចាប់ផ្តើមឡើងវិញ';

  @override
  String get gameStarted => 'ហ្គេមបានចាប់ផ្តើម សូមដាក់កូនអុក។';

  @override
  String get analyzing => 'កំពុងវិភាគ…';

  @override
  String error(Object message) {
    return 'កំហុស៖ $message';
  }

  @override
  String get winRate => 'អត្រាឈ្នះ';

  @override
  String get score => 'ពិន្ទុ៖';

  @override
  String get white => 'អ្នកលេង 1';

  @override
  String get black => 'អ្នកលេង 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return 'ចំនួនកូនអុករបស់ $player តិចជាងបី។';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player បានលះបង់។';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player គ្មាន​ទឹក​ដើរ។';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'ក្តារពេញហើយ ហើយ $player គ្មានផ្លូវដើរទេ។';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'អស់ម៉ោងហើយ $player ចាញ់។';
  }

  @override
  String get drawReasonRule50 =>
      'ក្នុងដំណាក់កាលផ្លាស់ទី គ្មានកូនអុកណាមួយត្រូវបានដកចេញក្នុងចំនួនចលនាជាក់លាក់ចុងក្រោយ។';

  @override
  String get drawReasonBoardIsFull => 'ស្មើគ្នាព្រោះក្តារពេញ។';

  @override
  String get drawReasonThreefoldRepetition => 'ស្មើគ្នាដោយសារការកើតឡើងវិញបីដង។';

  @override
  String get gameOverUnknownReason => 'ចប់ហ្គេម! ហេតុផលមិនស្គាល់។';

  @override
  String get gameOver => 'ចប់ហ្គេម';

  @override
  String get youWin => 'អ្នកឈ្នះ! សូមអបអរសាទរ!';

  @override
  String challengeHarderLevel(int level) {
    return 'ប្រកួតប្រជែងកម្រិតពិបាកជាងនេះ? កម្រិតថ្មីនឹងជាកម្រិត $level!';
  }

  @override
  String get youLose => 'អ្នកចាញ់!';

  @override
  String get analyze => 'វិភាគ';

  @override
  String get about => 'អំពី';

  @override
  String version(Object versionNumber) {
    return 'កំណែ៖ $versionNumber';
  }

  @override
  String get thanks => 'សូមអរគុណ';

  @override
  String get settings => 'ការកំណត់';

  @override
  String get options => 'ជម្រើស';

  @override
  String get generalSettings => 'ការកំណត់ទូទៅ';

  @override
  String get skillLevel => 'កម្រិតលំបាក';

  @override
  String get moveTime => 'ពេលវេលាគិតរបស់ AI';

  @override
  String get difficulty => 'កម្រិតលំបាក';

  @override
  String get playSounds => 'បែបផែនសំឡេង';

  @override
  String get playSoundsInTheGame => 'ចាក់សំឡេងក្នុងហ្គេម';

  @override
  String get keepMuteWhenTakingBack => 'រក្សាភាពស្ងៀមស្ងាត់ពេលដកថយ';

  @override
  String get tone => 'សម្លេង';

  @override
  String get whoMovesFirst => 'អ្នកលេងមុន';

  @override
  String get human => 'មនុស្ស';

  @override
  String get ai => 'AI';

  @override
  String get alternate => 'ឆ្លាស់គ្នា';

  @override
  String get isAutoRestart =>
      'ចាប់ផ្តើមហ្គេមឡើងវិញដោយស្វ័យប្រវត្តិនៅពេលចប់ហ្គេម';

  @override
  String get isAutoChangeFirstMove => 'ផ្លាស់ប្តូរចលនាដំបូងដោយស្វ័យប្រវត្តិ';

  @override
  String get shufflingEnabled => 'ផ្លាស់ទីដោយចៃដន្យ';

  @override
  String get misc => 'ផ្សេងៗ';

  @override
  String get rules => 'ច្បាប់';

  @override
  String get piecesCount => 'ចំនួនកូនអុកដែលអ្នកលេងម្នាក់ៗមាន';

  @override
  String get piecesCount_Detail => 'តើអ្នកលេងម្នាក់ៗមានកូនអុកប៉ុន្មាន?';

  @override
  String get flyPieceCount => 'ចំនួនកូនអុកហោះ';

  @override
  String get flyPieceCount_Detail =>
      'ប្រសិនបើការហោះត្រូវបានបើក នៅពេលដែលចំនួនកូនអុករបស់អ្នកលេងធ្លាក់ចុះក្រោមដែនកំណត់ជាក់លាក់ កូនអុករបស់ពួកគេមានសេរីភាពក្នុងការផ្លាស់ទីទៅចំណុចណាមួយដែលមិនទាន់មានកូនអុក ជំនួសឱ្យការត្រូវបានដាក់កម្រិតត្រឹមចំណុចជាប់គ្នាដូចក្នុងហ្គេមដែលនៅសល់។';

  @override
  String get piecesAtLeastCount => 'ចំនួនកូនអុកយ៉ាងតិច';

  @override
  String get hasDiagonalLines => 'បន្ទាត់អង្កត់ទ្រូង';

  @override
  String get hasDiagonalLines_Detail =>
      'បន្ថែមបន្ទាត់អង្កត់ទ្រូងចំនួនបួនទៅក្តារ។';

  @override
  String get isDefenderMoveFirst => 'អ្នកលេងទីពីរផ្លាស់ទីមុនគេ';

  @override
  String get isDefenderMoveFirst_Detail =>
      'អ្នកលេងដែលផ្លាស់ទីទីពីរក្នុងដំណាក់កាលដាក់កូនអុក ផ្លាស់ទីមុនគេក្នុងដំណាក់កាលផ្លាស់ទី។';

  @override
  String get mayRemoveMultiple => 'ដកចេញច្រើន';

  @override
  String get mayRemoveMultiple_Detail =>
      'ប្រសិនបើអ្នកលេងបិទមីលច្រើនជាងមួយក្នុងពេលតែមួយ នាងនឹងដកចេញចំនួនមីលដែលនាងបានបិទ។';

  @override
  String get mayRemoveFromMillsAlways => 'អាចដកកូនអុកពីមីលបានដោយមិនមានកំណត់';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'តាមលំនាំដើម អ្នកលេងត្រូវតែដកកូនអុកផ្សេងទៀតចេញជាមុនសិន មុននឹងដកកូនអុកចេញពីមីលដែលបានបង្កើត។ បើកជម្រើសនេះដើម្បីបិទការដាក់កម្រិត។';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'អ្នកលេងទីពីរចាញ់នៅពេលក្តារពេញ';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'នៅពេលក្តារពេញនៅចុងបញ្ចប់នៃដំណាក់កាលដាក់កូនអុក ភាគីដែលដាក់មុនគេចាញ់ហ្គេម។ បើមិនដូច្នោះទេ ហ្គេមគឺស្មើគ្នា។';

  @override
  String get isLoseButNotChangeSideWhenNoWay => 'ចាញ់នៅពេលគ្មានចលនាស្របច្បាប់';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'អ្នកលេងនឹងចាញ់ ប្រសិនបើគូប្រកួតរបស់ពួកគេរារាំងពួកគេ ដូច្នេះពួកគេមិនអាចផ្លាស់ទីបាន។ ប្រសិនបើជម្រើសនេះត្រូវបានបិទ សូមប្តូរវេនផ្លាស់ទីជំនួសឱ្យការប្រកាសចាញ់។';

  @override
  String get mayFly => 'ហោះ';

  @override
  String get mayFly_Detail =>
      'ប្រសិនបើអ្នកលេងនៅសល់តែកូនអុកបី ឬបួន (អាចកំណត់រចនាសម្ព័ន្ធបាន) នាងអាចផ្លាស់ទីកូនអុកទៅចំណុចទំនេរណាមួយ។';

  @override
  String get nMoveRule => 'ច្បាប់ N-ចលនា';

  @override
  String get nMoveRule_Detail =>
      'ហ្គេមត្រូវបានស្មើ ប្រសិនបើគ្មានការដកចេញក្នុងចំនួនចលនាជាក់លាក់ណាមួយ។';

  @override
  String get rollback => 'មិនធ្វើវិញ';

  @override
  String get pleaseSelect => 'សូមជ្រើសរើស';

  @override
  String get copy => 'ចម្លង';

  @override
  String get moveHistoryCopied => 'ប្រវត្តិចលនាត្រូវបានចម្លងទៅឃ្លីបបត។';

  @override
  String get help => 'ជំនួយ';

  @override
  String get feedback => 'មតិកែលម្អ';

  @override
  String get exit => 'ចាកចេញ';

  @override
  String get ruleSettings => 'ការកំណត់ច្បាប់';

  @override
  String get color => 'ពណ៌';

  @override
  String get boardColor => 'ពណ៌ក្តារ';

  @override
  String get pieceColor => 'ពណ៌កូនអុក';

  @override
  String get backgroundColor => 'ពណ៌ផ្ទៃខាងក្រោយ';

  @override
  String get lineColor => 'ពណ៌បន្ទាត់ក្តារ';

  @override
  String get whitePieceColor => 'ពណ៌កូនអុកអ្នកលេង 1';

  @override
  String get blackPieceColor => 'ពណ៌កូនអុកអ្នកលេង 2';

  @override
  String get messageColor => 'ពណ៌សារ';

  @override
  String get isPieceCountInHandShown => 'បង្ហាញចំនួនកូនអុកដែលមិនទាន់ដាក់';

  @override
  String get isNotationsShown => 'បង្ហាញសញ្ញាណនៅលើក្តារ';

  @override
  String get isHistoryNavigationToolbarShown => 'បង្ហាញរបារឧបករណ៍រុករកប្រវត្តិ';

  @override
  String get display => 'បង្ហាញ';

  @override
  String get boardBorderLineWidth => 'ទទឹងបន្ទាត់ព្រំដែនក្តារ';

  @override
  String get boardInnerLineWidth => 'ទទឹងបន្ទាត់ខាងក្នុងក្តារ';

  @override
  String get pieceWidth => 'ទទឹងកូនអុក';

  @override
  String get fontSize => 'ទំហំពុម្ពអក្សរ';

  @override
  String get standardNotation => 'សញ្ញាណ WMD';

  @override
  String get restore => 'ស្តារឡើងវិញ';

  @override
  String get restoreDefaultSettings => 'ស្តារការកំណត់លំនាំដើមឡើងវិញ';

  @override
  String pick(Object element) {
    return 'ជ្រើសរើស $element';
  }

  @override
  String get info => 'ព័ត៌មាន';

  @override
  String get hint => 'ជំនួយ';

  @override
  String get player => 'អ្នកលេង';

  @override
  String get player1 => 'អ្នកលេង 1';

  @override
  String get player2 => 'អ្នកលេង 2';

  @override
  String get howToPlay => 'របៀបលេង';

  @override
  String get toPlacePiece => 'ប៉ះលើចំណុចទំនេរណាមួយដើម្បីដាក់កូនអុក។';

  @override
  String get toSelectPiece => 'ប៉ះលើកូនអុកដើម្បីផ្លាស់ទីវា។';

  @override
  String get toMovePiece => 'ប៉ះលើចំណុចដែលភ្ជាប់ទៅនឹងកូនអុកដើម្បីផ្លាស់ទីវា។';

  @override
  String get toRemovePiece => 'ប៉ះលើកូនអុកមួយរបស់គូប្រកួតដើម្បីដកវាចេញ។';

  @override
  String get needToCreateMillFirst =>
      'អ្នកត្រូវបង្កើតមីលជាមុនសិន មុនពេលអ្នកអាចដកកូនអុកចេញបាន។';

  @override
  String get needToPlayWithOwnPieces => 'អ្នកត្រូវលេងជាមួយកូនអុករបស់អ្នក។';

  @override
  String get statistics => 'ស្ថិតិ';

  @override
  String get totalGames => 'ហ្គេមសរុប';

  @override
  String get results => 'លទ្ធផល';

  @override
  String get left => 'នៅសល់';

  @override
  String get privacyPolicy => 'គោលការណ៍ឯកជនភាព';

  @override
  String get privacyPolicy_Detail_1 =>
      'សូមអានដោយយកចិត្តទុកដាក់ និងធ្វើឱ្យប្រាកដថាអ្នកយល់ច្បាស់ និងយល់ព្រមជាមួយ ';

  @override
  String get privacyPolicy_Detail_2 =>
      'នេះ។ ប្រសិនបើអ្នកមិនយល់ព្រមតាមគោលការណ៍នេះទេ សូមកុំប្រើកម្មវិធីនេះ។ ការប្រើប្រាស់កម្មវិធីបញ្ជាក់ថាអ្នកទទួលយកលក្ខខណ្ឌទាំងនេះ។';

  @override
  String get and => ' និង ';

  @override
  String get accept => 'ទទួលយក';

  @override
  String get takeBack => 'ដកថយ';

  @override
  String get takingBack => 'កំពុងដកថយ…';

  @override
  String get waiting => 'កំពុងរង់ចាំ…';

  @override
  String get stepForward => 'បោះជំហានទៅមុខ';

  @override
  String get takeBackAll => 'ដកថយទាំងអស់';

  @override
  String get stepForwardAll => 'បោះជំហានទៅមុខទាំងអស់';

  @override
  String get moveNow => 'ផ្លាស់ទីឥឡូវនេះ';

  @override
  String get done => 'រួចរាល់។';

  @override
  String get crackMill => 'Crack-mill';

  @override
  String get crackMill_Detail =>
      'ប្រសិនបើអ្នកលេងមានតែកូនអុកនៅក្នុងមីល កូនអុកនៅក្នុងមីលនឹងមិនចាក់សោដើម្បីដកចេញទេ។';

  @override
  String get animationDuration => 'រយៈពេលចលនា';

  @override
  String get none => 'គ្មាន';

  @override
  String get theme => 'ស្បែក';

  @override
  String get helpContent =>
      'គោលបំណងនៃហ្គេមគឺធ្វើឱ្យគូប្រកួតនៅសល់កូនអុកតិចជាងបី ឬគ្មានចលនាស្របច្បាប់។\n\nហ្គេមនឹងស្មើដោយស្វ័យប្រវត្តិ ប្រសិនបើទីតាំងណាមួយកើតឡើងជាលើកទីបី ឬមិនមានការដកចេញក្នុង 100 (អាចកំណត់រចនាសម្ព័ន្ធបាន) ចលនាចុងក្រោយ។\n\nហ្គេមដំណើរការជាបីដំណាក់កាល៖\n\n1. ការដាក់កូនអុកលើចំណុចទំនេរ\n2. ការផ្លាស់ទីកូនអុកទៅចំណុចជាប់គ្នា\n3. (ដំណាក់កាលស្រេចចិត្ត) ការផ្លាស់ទីកូនអុកទៅចំណុចទំនេរណាមួយនៅពេលកាត់បន្ថយអ្នកលេងឱ្យនៅសល់កូនអុកបី\n\nការដាក់\n\nហ្គេមចាប់ផ្តើមដោយក្តារទទេ ដែលមានក្រឡាចត្រង្គម្ភៃបួនចំណុច។ អ្នកលេងផ្លាស់វេនគ្នាដាក់កូនអុករបស់ពួកគេលើចំណុចទំនេរ រហូតដល់អ្នកលេងម្នាក់ៗបានដាក់កូនអុកទាំងអស់នៅលើក្តារ។ ប្រសិនបើអ្នកលេងអាចដាក់កូនអុករបស់គាត់បីជាប់គ្នា គាត់មាន \"មីល\" ហើយអាចដកកូនអុកមួយរបស់គូប្រកួតចេញពីក្តារ។\n\nនៅក្នុងសំណុំច្បាប់មួយចំនួន អ្នកលេងត្រូវតែដកកូនអុកផ្សេងទៀតចេញជាមុនសិន មុននឹងដកកូនអុកចេញពីមីលដែលបានបង្កើត។\n\nក្រោមច្បាប់ជាក់លាក់ អ្នកមិនអាចដាក់កូនអុកម្តងទៀតលើចំណុចដែលកូនអុកត្រូវបានដកចេញទេ។\n\nនៅពេលដែលកូនអុកទាំងអស់ត្រូវបានដាក់ អ្នកលេងផ្លាស់វេនគ្នាផ្លាស់ទីពួកវា។\n\nការផ្លាស់ទី\n\nដើម្បីផ្លាស់ទី អ្នកលេងផ្លាស់ទីកូនអុកមួយរបស់គាត់តាមបណ្តោយបន្ទាត់ក្តារទៅចំណុចទំនេរជាប់គ្នា។ ប្រសិនបើគាត់មិនអាចធ្វើបាន គាត់ចាញ់ហ្គេម។ អ្នកលេងដែលតម្រឹមកូនអុករបស់គាត់បីនៅលើបន្ទាត់ក្តារមានមីល ហើយអាចដកកូនអុកមួយរបស់គូប្រកួតចេញដូចក្នុងដំណាក់កាលដាក់។ ប្រសិនបើអ្នកលេងត្រូវបានកាត់បន្ថយឱ្យនៅសល់កូនអុកពីរ គ្មានជម្រើសដើម្បីបង្កើតមីលថ្មី ហើយដូច្នេះចាញ់ហ្គេម។ អ្នកលេងក៏អាចចាញ់នៅពេលមានកូនអុកច្រើនជាងបី ប្រសិនបើគូប្រកួតរបស់គាត់រារាំងពួកគេមិនឱ្យផ្លាស់ទី។\n\nការហោះ\n\nនៅក្នុងវ៉ារ្យ៉ង់មួយចំនួននៃច្បាប់ នៅពេលដែលអ្នកលេងនៅសល់តែកូនអុកបី កូនអុករបស់ពួកគេអាចហោះ លោត ឬលោតទៅចំណុចទំនេរណាមួយ មិនត្រឹមតែចំណុចជាប់គ្នាប៉ុណ្ណោះទេ។\n';

  @override
  String get versionInfo => 'ព័ត៌មានកំណែ';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'អាជ្ញាប័ណ្ណ';

  @override
  String get sourceCode => 'កូដប្រភព';

  @override
  String get appVersion => 'កំណែកម្មវិធី';

  @override
  String get general => 'ទូទៅ';

  @override
  String get advanced => 'កម្រិតខ្ពស់';

  @override
  String get placing => 'ការដាក់';

  @override
  String get moving => 'ការផ្លាស់ទី';

  @override
  String get removing => 'ការដកចេញ';

  @override
  String get gameOverCondition => 'លក្ខខណ្ឌចប់ហ្គេម';

  @override
  String get aisPlayStyle => 'របៀបលេងរបស់ AI';

  @override
  String get passive => 'អសកម្ម';

  @override
  String get timeout => 'អស់ពេល';

  @override
  String get appearance => 'រូបរាង';

  @override
  String get drawOnHumanExperience => 'ពឹងផ្អែកលើបទពិសោធន៍មនុស្ស';

  @override
  String get considerMobility => 'ពិចារណាលើការចល័តកូនអុក';

  @override
  String get pieceCount => 'ចំនួនកូនអុក៖';

  @override
  String inHand(Object player, int count) {
    return '$player នៅក្នុងដៃ៖ $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player នៅលើក្តារ៖ $count';
  }

  @override
  String get boardTop => 'គម្លាតក្តារពីខាងលើ';

  @override
  String get notAIsTurn => 'វាមិនមែនជាវេនរបស់ AI ទេ។';

  @override
  String get aiIsNotThinking => 'AI មិនកំពុងគិតទេ។';

  @override
  String get atEnd => 'អ្នកនៅចុងបញ្ចប់នៃបញ្ជីចលនា។';

  @override
  String get tapBackAgainToLeave => 'ប៉ះ ថយក្រោយ ម្តងទៀតដើម្បីចាកចេញ។';

  @override
  String get more => 'ច្រើនទៀត';

  @override
  String get experimental => 'វាជាមុខងារពិសោធន៍។';

  @override
  String get experiments => 'ការពិសោធន៍';

  @override
  String get ossLicenses => 'អាជ្ញាប័ណ្ណប្រភពបើកចំហ';

  @override
  String get language => 'ភាសា';

  @override
  String get defaultLanguage => 'ភាសាលំនាំដើម';

  @override
  String get mayMoveInPlacingPhase => 'កូនអុកអាចផ្លាស់ទីក្នុងដំណាក់កាលដាក់';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'មិនមានដំណាក់កាលដាក់ និងផ្លាស់ទីដាច់ដោយឡែកទេ ពោលគឺអ្នកលេងអាចសម្រេចចិត្តនៅគ្រប់ចលនាថាតើពួកគេចង់ដាក់កូនអុកនៅលើក្តារ ឬផ្លាស់ទីកូនអុកមួយរបស់ពួកគេ (ដរាបណាពួកគេនៅសល់កូនអុកដើម្បីដាក់)។';

  @override
  String get drawerColor => 'ពណ៌ម៉ឺនុយ';

  @override
  String get drawerTextColor => 'ពណ៌អក្សរម៉ឺនុយ';

  @override
  String get drawerHighlightItemColor => 'ពណ៌ធាតុបន្លិចម៉ឺនុយ';

  @override
  String get mainToolbarBackgroundColor => 'ពណ៌ផ្ទៃខាងក្រោយរបារឧបករណ៍ចម្បង';

  @override
  String get mainToolbarIconColor => 'ពណ៌រូបតំណាងរបារឧបករណ៍ចម្បង';

  @override
  String get navigationToolbarBackgroundColor =>
      'ពណ៌ផ្ទៃខាងក្រោយរបារឧបករណ៍រុករក';

  @override
  String get navigationToolbarIconColor => 'ពណ៌រូបតំណាងរបារឧបករណ៍រុករក';

  @override
  String get autoHideToolbar => 'លាក់របារឧបករណ៍ដោយស្វ័យប្រវត្តិ';

  @override
  String get toolbarLocationOnScreen => 'ទីតាំងរបារឧបករណ៍នៅលើអេក្រង់';

  @override
  String get top => 'ខាងលើ';

  @override
  String get bottom => 'ខាងក្រោម';

  @override
  String get center => 'កណ្តាល';

  @override
  String get solidColor => 'ពណ៌រឹង';

  @override
  String get picture => 'រូបភាព';

  @override
  String get chooseYourPicture => 'ជ្រើសរើសរូបភាពរបស់អ្នក';

  @override
  String get light => 'ភ្លឺ';

  @override
  String get dark => 'ងងឹត';

  @override
  String get themes => 'ស្បែក';

  @override
  String get currentTheme => 'ស្បែកបច្ចុប្បន្ន';

  @override
  String get saveTheme => 'រក្សាទុកស្បែក';

  @override
  String get showAnalysisGraph => 'បង្ហាញក្រាហ្វវិភាគ';

  @override
  String get analysis => 'ការវិភាគ';

  @override
  String get saveGame => 'រក្សាទុកហ្គេម';

  @override
  String get loadGame => 'ផ្ទុកហ្គេម';

  @override
  String get setupPosition => 'រៀបចំទីតាំង';

  @override
  String get showLegalMoves => 'បង្ហាញចលនាស្របច្បាប់';

  @override
  String get showLastMove => 'បង្ហាញចលនាចុងក្រោយ';

  @override
  String get showArrows => 'បង្ហាញព្រួញ';

  @override
  String get pieces => 'កូនអុក';

  @override
  String get showAnalysis => 'បង្ហាញការវិភាគ';

  @override
  String get threads => 'ខ្សែស្រឡាយ';

  @override
  String get getInvolved => 'ចូលរួម';

  @override
  String get helpImproveTranslate => 'ជួយកែលម្អការបកប្រែ';

  @override
  String get tutorial => 'ការបង្រៀន';

  @override
  String get classicMill => 'មីលបុរាណ';

  @override
  String get mixedMill => 'មីលចម្រុះ';

  @override
  String get ceylonMill => 'មីលសីឡុន';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'មីលអាចត្រូវបានបំបែក និងបង្កើតឡើងវិញម្តងហើយម្តងទៀត';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'ប្រសិនបើអ្នកលេងបំបែកមីលដើម្បីបង្កើតមីលថ្មីភ្លាមៗ ពួកគេអាចផ្លាស់ទីកូនអុកនោះត្រឡប់ទៅចំណុចដើមវិញក្នុងចលនាបន្ទាប់របស់ពួកគេ ប្រសិនបើវាបង្កើតមីលថ្មីមួយទៀត។';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'ហ្គេមត្រូវបានស្មើ ប្រសិនបើអ្នកលេងមានកូនអុកបី ហើយបន្ទាប់ពីដប់ចលនា គ្មានអ្នកលេងណាម្នាក់ដកកូនអុករបស់គូប្រកួតចេញទេ';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'នៅពេលអ្នកលេងនៅសល់កូនអុកបី ហើយគ្មានអ្នកលេងណាម្នាក់អាចដកកូនអុករបស់គូប្រកួតចេញក្នុងរយៈពេលដប់ចលនាទេ ហ្គេមគឺស្មើគ្នា។';

  @override
  String get close => 'បិទ';

  @override
  String get whitePiece => 'កូនអុកស';

  @override
  String get blackPiece => 'កូនអុកខ្មៅ';

  @override
  String get emptyPoint => 'ចំណុចទទេ';

  @override
  String get noPoint => 'គ្មានចំណុច';

  @override
  String get placingPhase => 'ដំណាក់កាលដាក់';

  @override
  String get movingPhase => 'ដំណាក់កាលផ្លាស់ទី';

  @override
  String get flyingPhase => 'ដំណាក់កាលហោះ';

  @override
  String sideToMove(Object player) {
    return 'វេនផ្លាស់ទី៖ $player';
  }

  @override
  String lastMove(Object move) {
    return 'ចលនាចុងក្រោយ៖ $move';
  }

  @override
  String get selected => 'បានជ្រើសរើស';

  @override
  String get accessibility => 'ភាពងាយស្រួល';

  @override
  String get screenReaderSupport => 'ការគាំទ្រកម្មវិធីអានអេក្រង់';

  @override
  String get isDraw => 'ស្មើគ្នា!';

  @override
  String get draw => 'ស្មើ';

  @override
  String get pieceHighlightColor => 'ពណ៌បន្លិចកូនអុក';

  @override
  String get algorithm => 'ក្បួនដោះស្រាយ';

  @override
  String get endgameNMoveRule => 'ច្បាប់ N-ចលនា ចុងហ្គេម';

  @override
  String get endgameNMoveRule_Detail =>
      'ហ្គេមត្រូវបានស្មើ ប្រសិនបើអ្នកលេងណាម្នាក់មានតែកូនអុកបី ហើយគ្មានអ្នកលេងណាម្នាក់ដកកូនអុកចេញក្នុងចលនាជាក់លាក់ណាមួយ។';

  @override
  String get drawReasonEndgameRule50 =>
      'អ្នកលេងណាម្នាក់មានតែកូនអុកបី ហើយគ្មានអ្នកលេងណាម្នាក់ដកកូនអុកចេញក្នុងចលនាជាក់លាក់ណាមួយ។';

  @override
  String get threefoldRepetitionRule => 'ច្បាប់កើតឡើងវិញបីដង';

  @override
  String get threefoldRepetitionRule_Detail =>
      'ហ្គេមត្រូវបានស្មើ ប្រសិនបើទីតាំងណាមួយកើតឡើងជាលើកទីបី។';

  @override
  String get continueToMakeMove => 'មីល! បន្តធ្វើចលនា។';

  @override
  String get pointStyle => 'រចនាប័ទ្មចំណុច';

  @override
  String get pointWidth => 'ទទឹងចំណុច';

  @override
  String get solid => 'រឹង';

  @override
  String get hollow => 'ប្រហោង';

  @override
  String get languageName => 'ខ្មែរ';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ចលនា',
      one: '$count ចលនា',
      zero: 'ចលនា',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'ការផ្ទុកបរាជ័យ។';

  @override
  String get filename => 'ឈ្មោះឯកសារ';

  @override
  String get browse => 'រកមើល…';

  @override
  String get gameFiles => 'ឯកសារហ្គេម';

  @override
  String get gameSavedTo => 'ហ្គេមត្រូវបានរក្សាទុកទៅ';

  @override
  String get empty => 'ទទេ';

  @override
  String get noMove => 'គ្មានចលនា។';

  @override
  String get restoredPosition => 'បានស្តារទីតាំងដំបូងឡើងវិញ។';

  @override
  String get clean => 'សម្អាត';

  @override
  String get cleanedUp => 'បានសម្អាត។';

  @override
  String get remove => 'ដកចេញ';

  @override
  String get noPiecesCanBeRemoved => 'គ្មានកូនអុកណាមួយអាចត្រូវបានដកចេញទេ។';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count កូនអុក',
      one: '$count កូនអុក',
      zero: 'កូនអុក',
    );
    return '$_temp0 ត្រូវការដកចេញ។';
  }

  @override
  String placedCount(int count) {
    return 'បានដាក់ ($count)';
  }

  @override
  String get placedPieceCount => 'ចំនួនកូនអុកដែលបានដាក់ក្នុងដំណាក់កាលដាក់។';

  @override
  String hasPlacedPieceCount(int count) {
    return 'អ្នកលេងបច្ចុប្បន្នបានដាក់ $count កូនអុក។';
  }

  @override
  String get notPlacingPhase =>
      'មិនមែនដំណាក់កាលដាក់ទេ មិនអាចផ្លាស់ប្តូរវាបានទេ។';

  @override
  String get paste => 'បិទភ្ជាប់';

  @override
  String get pasteDone => 'ការបិទភ្ជាប់រួចរាល់។';

  @override
  String get cannotPaste => 'មិនអាចបិទភ្ជាប់បានទេ។';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'បង្ហាញកូនអុកដែលមិនទាន់ដាក់ និងដកចេញ';

  @override
  String get fullScreen => 'ពេញអេក្រង់';

  @override
  String get reopenToTakeEffect =>
      'ចាកចេញ និងបើកកម្មវិធីឡើងវិញដើម្បីឱ្យការកំណត់មានប្រសិទ្ធភាព។';

  @override
  String get forest => 'ព្រៃ';

  @override
  String get desktopImage => 'រូបភាពផ្ទៃតុ';

  @override
  String get invalidPosition => 'ទីតាំងមិនត្រឹមត្រូវ។';

  @override
  String get shareGIF => 'ចែករំលែក GIF';

  @override
  String get pixelRatio => 'សមាមាត្រភីកសែល';

  @override
  String get duration => 'រយៈពេល';

  @override
  String get gameScreenRecorder => 'កម្មវិធីថតអេក្រង់ហ្គេម';

  @override
  String get previous => 'មុន';

  @override
  String get next => 'បន្ទាប់';

  @override
  String get skip => 'រំលង';

  @override
  String get gotIt => 'យល់ហើយ';

  @override
  String get youCanModifyRules =>
      'អ្នកអាចកែប្រែច្បាប់នៃហ្គេមនៅក្នុងការកំណត់ច្បាប់។';

  @override
  String get youCanUseMouseWheelInPicker =>
      'អ្នកអាចប្រើកង់កណ្ដុរដើម្បីកែតម្រូវតម្លៃនៅក្នុងកម្មវិធីជ្រើសរើស។';

  @override
  String get noTimeLimitForThinking =>
      'ពេលវេលាគិតរបស់ AI កំណត់ទៅ 0 មានន័យថាមិនមានដែនកំណត់ពេលវេលាសម្រាប់ការគិត។';

  @override
  String get whatIsMtdf =>
      'MTD(f) គឺជាទម្រង់កែប្រែនៃក្បួនដោះស្រាយស្វែងរក alpha-beta ដែលមានគោលបំណងកែលម្អប្រសិទ្ធភាពដោយការប្រើឡើងវិញនូវលទ្ធផលស្វែងរកកម្រិតមធ្យម និងប្រើការទស្សន៍ទាយដំបូងដ៏ល្អដើម្បីបង្រួមទំហំស្វែងរក។';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'សូមជ្រាបថាការកែតម្រូវពេលវេលាគិតរបស់ AI ប្រហែលជាមិនជាក់លាក់ទាំងស្រុងទេ។ ពេលវេលាគិតជាក់ស្តែងអាចខ្លីជាងនៅពេលកម្រិតលំបាកត្រូវបានកំណត់ទៅតម្លៃទាបជាង ហើយអាចយូរជាងនៅពេល AI កំពុងគិតនៅពេលពេលវេលាអស់។';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'ប្រសិនបើអ្នកកំណត់កម្រិតលំបាកខ្ពស់ ប៉ុន្តែមិនបង្កើនពេលវេលាគិតរបស់ AI ទេ កម្រិតលំបាកជាក់ស្តែងអាចត្រូវបានកំណត់ត្រឹមកម្រិតទាបជាងដោយសារតែការដាក់កម្រិតពេលវេលាគិត។ តម្លៃជាក់ស្តែងអាចប្រែប្រួលអាស្រ័យលើដំណើរការរបស់ម៉ាស៊ីន។';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) គឺជាក្បួនដោះស្រាយស្វែងរកដើម្បីស្វែងរកចលនាល្អបំផុតនៅក្នុងទីតាំងដែលបានផ្តល់ឱ្យ។ វាគឺជាការបង្កើនប្រសិទ្ធភាពនៃក្បួនដោះស្រាយ alpha-beta ហើយប្រើការស្វែងរកបង្អួច null ឬសូន្យដើម្បីបញ្ជាក់ថាចលនាមួយគឺអាក្រក់ជាង ឬមិនអាក្រក់ជាងពិន្ទុដែលមានសុវត្ថិភាពរួចហើយពីបំរែបំរួលចម្បង។ PVS ផ្តោតលើចលនាដែលមានសក្តានុពលបំផុត និងជៀសវាងការស្វែងរកសាខាដែលមិនល្អប្រសើរដែលមិនចាំបាច់ ដែលជួយកែលម្អប្រសិទ្ធភាពនៃការស្វែងរក។';

  @override
  String get whatIsAlphaBeta =>
      'ក្បួនដោះស្រាយ alpha-beta គឺជាក្បួនដោះស្រាយស្វែងរកដើម្បីស្វែងរកចលនាល្អបំផុត។ វាប្រើគោលការណ៍ minimax និងតម្លៃពីរគឺ alpha និង beta ដើម្បីកាត់បន្ថយមែកធាងស្វែងរក និងបង្កើនប្រសិទ្ធភាព។ Alpha តំណាងឱ្យពិន្ទុអប្បបរមាដែលកុំព្យូទ័រប្រាកដថាវាអាចទទួលបាន ខណៈពេលដែល beta តំណាងឱ្យពិន្ទុអតិបរមាដែលគូប្រកួតរបស់វាអាចទទួលបាន។ ក្បួនដោះស្រាយជួយកុំព្យូទ័រធ្វើការសម្រេចចិត្តឆ្លាតវៃ និងមានប្រសិទ្ធភាពក្នុងហ្គេម។';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'យោងតាមបទពិសោធន៍របស់មនុស្ស ប្រសិនបើអ្នកព្យាយាមឈ្នះ អ្នកនឹងចាញ់។ ផ្ទុយទៅវិញ ចូរមានគោលដៅស្មើជាគោលដៅរបស់អ្នក ហើយជៀសវាងការចាញ់ហ្គេម។ សង្កេតមើលគូប្រកួតរបស់អ្នក ហើយទាក់ទាញពួកគេដោយថ្នមៗទៅកាន់ទីតាំងដែលពួកគេអាចធ្វើខុស។ នៅពេលពួកគេបង្ហាញភាពទន់ខ្សោយ ចាប់យកឱកាស ហើយជំរុញថ្នមៗដើម្បីឈ្នះ។ តាមវិធីនេះ អ្នកអាចឈ្នះហ្គេម។';

  @override
  String get firstMoveDetail =>
      'នៅក្នុងហ្គេមនេះ វាមានភាពងាយស្រួលសម្រាប់អ្នកលេងទីពីរក្នុងការឈ្នះ បើប្រៀបធៀបទៅនឹងអ្នកលេងទីមួយ។';

  @override
  String get passiveDetail =>
      'ការបើកជម្រើសអសកម្មនឹងធ្វើឱ្យ AI បន្ធូរអារម្មណ៍នៅពេលវាមានគុណសម្បត្តិក្នុងទីតាំង ជាជាងព្យាយាមឈ្នះឱ្យបានលឿនតាមដែលអាចធ្វើទៅបាន។';

  @override
  String get moveRandomlyDetail =>
      'ការបើកជម្រើសនេះបង្កើនភាពចៃដន្យ និងភាពសប្បាយរីករាយនៃហ្គេម ខណៈពេលដែលការបិទវាអាចជួយសិក្សាពីវិធីដើម្បីយកឈ្នះ AI ។';

  @override
  String get considerMobilityOfPiecesDetail =>
      'ប្រសិនបើ AI ពិចារណាលើការចល័តកូនអុករបស់វា វានឹងមិនត្រឹមតែមានគោលបំណងចាប់យកកូនអុករបស់គូប្រកួតឱ្យបានលឿនតាមដែលអាចធ្វើទៅបានប៉ុណ្ណោះទេ ប៉ុន្តែថែមទាំងពិចារណាលើការរារាំងចលនារបស់គូប្រកួត និងរារាំងពួកគេមិនឱ្យធ្វើដូចគ្នា។';

  @override
  String get whenBoardIsFull => 'នៅពេលក្តារពេញ';

  @override
  String get whenBoardIsFull_Detail =>
      'នៅចុងបញ្ចប់នៃដំណាក់កាលដាក់ មុនពេលដំណាក់កាលផ្លាស់ទីចាប់ផ្តើម សកម្មភាពនឹងកើតឡើងប្រសិនបើក្តារពេញដោយកូនអុក។';

  @override
  String get sideToMoveRemovePiece =>
      'អ្នកលេងដែលផ្លាស់ទីមុនគេក្នុងដំណាក់កាលផ្លាស់ទី ដកកូនអុកមួយរបស់គូប្រកួតចេញ។';

  @override
  String get agreeToDraw => 'ភាគីទាំងពីរយល់ព្រមស្មើគ្នា។';

  @override
  String get takeOpponentsPiece => 'យកកូនអុកមួយរបស់គូប្រកួតអ្នក។';

  @override
  String get firstPlayerLose => 'អ្នកលេងទីមួយចាញ់ហ្គេម។';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'អ្នកលេងទីមួយ និងទីពីរដកកូនអុកមួយរបស់គូប្រកួតចេញ។';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'អ្នកលេងទីពីរ និងទីមួយដកកូនអុកមួយរបស់គូប្រកួតចេញ។';

  @override
  String get enteredFlyingPhase =>
      'ឥឡូវនេះបានចូលដល់ដំណាក់កាលហោះហើយ កូនអុករបស់គូប្រកួតអាចលោតទៅចំណុចទទេណាមួយនៅលើក្តារ។ អ្នកអាចបិទច្បាប់ហោះនៅក្នុង \"ការកំណត់ច្បាប់\"។';

  @override
  String get whenStalemate => 'នៅពេលជាប់គាំង';

  @override
  String get whenStalemate_Detail =>
      'តើសកម្មភាពអ្វីកើតឡើងនៅពេលគ្មានកូនអុកណាមួយអាចផ្លាស់ទីបាន?';

  @override
  String get endWithStalemateLoss =>
      'បញ្ចប់ដោយការចាញ់ដោយជាប់គាំងសម្រាប់ភាគីដែលត្រូវបានរារាំង។';

  @override
  String get changeSideToMove => 'ប្តូរវេនផ្លាស់ទី។';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'ដកកូនអុកមួយរបស់គូប្រកួតចេញ ហើយធ្វើចលនាបន្ទាប់។';

  @override
  String get endWithStalemateDraw => 'បញ្ចប់ដោយស្មើដោយជាប់គាំង។';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'ដកកូនអុកមួយរបស់គូប្រកួតចេញ ហើយប្តូរវេនផ្លាស់ទី។';

  @override
  String get aiResponseDelayTime => 'ពេលវេលាពន្យារការឆ្លើយតបរបស់ AI';

  @override
  String get aiIsDelaying =>
      'AI បច្ចុប្បន្នកំពុងស្ថិតក្នុងដំណាក់កាលឆ្លើយតបយឺត។ សូមរង់ចាំមួយភ្លែតមុននឹងបន្ត។';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'អ្នកមិនអាចដកកូនអុកដែលមិនជាប់គ្នាបានទេ។';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'ក្នុងស្ថានភាពជាប់គាំង អ្នកអាចដកកូនអុករបស់គូប្រកួតដែលនៅជាប់នឹងរបស់អ្នក ដោយមិនគិតពីការបង្កើតមីល។';

  @override
  String get whatIsMcts =>
      'MCTS គឺជាក្បួនដោះស្រាយដែលងាយស្រួលសម្រាប់អ្នកចាប់ផ្តើមដំបូង ដែលធ្វើការសម្រេចចិត្តដោយការរុករក និងវាយតម្លៃចលនាផ្សេងៗតាមរយៈការក្លែងធ្វើ។';

  @override
  String get goldenJade => 'ត្បូងថ្មមាស';

  @override
  String get forestWood => 'ឈើព្រៃ';

  @override
  String get darkMystery => 'អាថ៌កំបាំងងងឹត';

  @override
  String get midnightBlue => 'ខៀវពាក់កណ្តាលអធ្រាត្រ';

  @override
  String get greenForest => 'ព្រៃបៃតង';

  @override
  String get greenMeadow => 'វាលស្មៅបៃតង';

  @override
  String get stonyPath => 'ផ្លូវថ្ម';

  @override
  String get pastelPink => 'ផ្កាឈូកស្រាល';

  @override
  String get turquoiseSea => 'សមុទ្រមុជទឹក';

  @override
  String get violetDream => 'សុបិនពណ៌ស្វាយ';

  @override
  String get mintChocolate => 'សូកូឡាជីអង្កាម';

  @override
  String get skyBlue => 'ខៀវមេឃ';

  @override
  String get playfulGarden => 'សួនច្បាររីករាយ';

  @override
  String get whatIsRetrogradeAnalysis =>
      'ក្បួនដោះស្រាយការវិភាគថយក្រោយប្រើការវិភាគថយក្រោយពហុតម្លៃដើម្បីបង្កើតមូលដ្ឋានទិន្នន័យចុងហ្គេមពីទីតាំងចាប់ផ្តើមផ្សេងៗ បន្ទាប់មកអនុវត្តមូលដ្ឋានទិន្នន័យនេះដើម្បីបង្កើនប្រសិទ្ធភាពការលេងហ្គេម។ វិធីសាស្រ្តនេះស្ថិតនៅក្រោមប្រភេទនៃដំណោះស្រាយ Ultra-Strong ។';

  @override
  String get viewAlgorithmGuide =>
      'តើអ្នកចង់មើលមគ្គុទ្ទេសក៍អ្នកប្រើសម្រាប់ក្បួនដោះស្រាយនេះទេ?';

  @override
  String get showPositionalAdvantageIndicator =>
      'បង្ហាញសូចនាករគុណសម្បត្តិទីតាំង';

  @override
  String get usePerfectDatabase => 'ប្រើមូលដ្ឋានទិន្នន័យល្អឥតខ្ចោះ';

  @override
  String get perfectDatabaseDescription =>
      'បើកជម្រើសនេះដើម្បីប្រើមូលដ្ឋានទិន្នន័យហ្គេមដែលគ្មានកំហុស ដែលបង្កើតឡើងតាមរយៈក្បួនដោះស្រាយទំនើប។ មុខងារនេះរួមបញ្ចូលទាំងយុទ្ធសាស្ត្របើក និងចុងហ្គេម ដើម្បីណែនាំចលនាដ៏ល្អប្រសើរ។ នេះគឺជាជម្រើសដែលពេញចិត្តសម្រាប់អ្នកលេងដែលស្វែងរកកម្រិតភាពជាក់លាក់ខ្ពស់បំផុតក្នុងការលេងហ្គេម។ បង្កើតឡើងតាមរយៈបច្ចេកទេសគណនាដ៏ល្អិតល្អន់ មូលដ្ឋានទិន្នន័យត្រូវបានរចនាឡើងដើម្បីផ្តល់នូវដំណោះស្រាយហ្គេមដែលជិតល្អឥតខ្ចោះ។\n\nចំណាំ៖ ប្រសិនបើ AI បរាជ័យក្នុងការចូលប្រើមូលដ្ឋានទិន្នន័យ វានឹងងាកទៅរកក្បួនដោះស្រាយធម្មតាសម្រាប់ការសម្រេចចិត្តលេងហ្គេម។ នៅពេលមូលដ្ឋានទិន្នន័យមាន \'កម្រិតលំបាក\' ក្លាយជាស្ទើរតែមិនអាចយកឈ្នះបាន ហើយ \'ពេលវេលាគិតរបស់ AI\' ជួបប្រទះនឹងការកាត់បន្ថយយ៉ាងខ្លាំង។ ការកំណត់ជាច្រើននៅក្នុងជម្រើស \'របៀបលេងរបស់ AI\' នឹងត្រូវបានបដិសេធ ដោយសារលទ្ធផលមូលដ្ឋានទិន្នន័យមានអាទិភាពខ្ពស់បំផុត។\n\nសម្រាប់ការណែនាំអំពីរបៀបប្រើប្រាស់មូលដ្ឋានទិន្នន័យដែលគ្មានកំហុសនេះឱ្យបានច្រើនបំផុត សូមចុចទីនេះ។';

  @override
  String get backgroundImage => 'រូបភាពផ្ទៃខាងក្រោយ';

  @override
  String get whatIsRandom =>
      'នៅពេលជម្រើស \'ប្រើមូលដ្ឋានទិន្នន័យល្អឥតខ្ចោះ\' មិនត្រូវបានបើក ការកំណត់ \'ចៃដន្យ\' បណ្តាលឱ្យ AI ផ្លាស់ទីកូនអុកដោយចៃដន្យដោយមិនប្រើក្បួនដោះស្រាយណាមួយសម្រាប់ការជ្រើសរើសចលនា។ ជាធម្មតាវានាំឱ្យការលេងហ្គេមខ្សោយជាងមុន។ ផ្ទុយទៅវិញ នៅពេល \'ប្រើមូលដ្ឋានទិន្នន័យល្អឥតខ្ចោះ\' ត្រូវបានបើក AI ពឹងផ្អែកទាំងស្រុងលើ \'មូលដ្ឋានទិន្នន័យល្អឥតខ្ចោះ\' សម្រាប់ការសម្រេចចិត្ត ជំនួសឱ្យការលាយវាជាមួយក្បួនដោះស្រាយ AI បែបបុរាណ។ នៅក្នុងរបៀបនេះ ចលនារបស់ AI គឺផ្អែកទាំងស្រុងលើខ្លឹមសារនៃមូលដ្ឋានទិន្នន័យ ដោយជៀសវាងការពឹងផ្អែកលើការគណនាតាមពេលវេលាជាក់ស្តែង ឬក្បួនដោះស្រាយស្វែងរក។';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'ដកកូនអុករបស់គូប្រកួតចេញពីដៃរបស់ពួកគេ បន្ទាប់មកវាជាវេនរបស់គូប្រកួតដើម្បីដាក់។';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'នៅពេលបង្កើតមីលក្នុងដំណាក់កាលដាក់';

  @override
  String get removeOpponentsPieceFromBoard => 'ដកកូនអុករបស់គូប្រកួតចេញពីក្តារ។';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'ដកកូនអុករបស់គូប្រកួតចេញពីក្តារ បន្ទាប់មកវាជាវេនរបស់គូប្រកួតដើម្បីដាក់។';

  @override
  String get opponentRemovesOwnPiece => 'គូប្រកួតដកកូនអុករបស់ខ្លួនចេញពីក្តារ។';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'ជំនួសឱ្យអ្នកចាត់វិធានការ គូប្រកួតជ្រើសរើស និងដកកូនអុករបស់ខ្លួនចេញពីក្តារ ដែលមានប្រសិទ្ធភាពជាសកម្មភាពដែលបង្កគ្រោះថ្នាក់ដល់ខ្លួនឯង។';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'ដកកូនអុករបស់គូប្រកួតចេញពីដៃរបស់ពួកគេ បន្ទាប់មកវាជាវេនរបស់អ្នកដើម្បីផ្លាស់ទី។';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'ដកកូនអុកចេញពីដៃរបស់គូប្រកួត។ ប្រសិនបើ យោងតាមការកំណត់ Multi-remove កូនអុកច្រើនត្រូវដកចេញ ហើយគូប្រកួតគ្មានកូនអុកនៅសល់ក្នុងដៃ បន្តដកកូនអុករបស់គូប្រកួតចេញពីក្តារ។ បន្ទាប់មក វាជាវេនរបស់អ្នកដើម្បីផ្លាស់ទី។ ប្រសិនបើអ្នកបន្តបង្កើតមីល អ្នកអាចបន្តដកកូនអុករបស់គូប្រកួតចេញ។';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'ដកកូនអុកចេញពីដៃរបស់គូប្រកួត។ ប្រសិនបើ យោងតាមការកំណត់ Multi-remove កូនអុកច្រើនត្រូវដកចេញ ហើយគូប្រកួតគ្មានកូនអុកនៅសល់ក្នុងដៃ បន្តដកកូនអុករបស់គូប្រកួតចេញពីក្តារ។ បន្ទាប់មក វាជាវេនរបស់គូប្រកួតដើម្បីផ្លាស់ទី។';

  @override
  String get markAndDelayRemovingPieces => 'សម្គាល់ និងពន្យារពេលដកកូនអុកចេញ។';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'ក្នុងអំឡុងពេលដំណាក់កាលដាក់ កូនអុកដែលត្រូវដកចេញត្រូវបានសម្គាល់ ហើយសម្រាប់អ្នកលេងទាំងពីរ គ្មានកូនអុកថ្មីណាមួយអាចត្រូវបានដាក់នៅលើចំណុចទាំងនេះទេ។ នៅពេលចូលដល់ដំណាក់កាលផ្លាស់ទី កូនអុកដែលបានសម្គាល់ទាំងនេះត្រូវបានដកចេញទាំងអស់គ្នា ហើយអ្នកលេងបន្ទាប់មកអាចផ្លាស់ទីកូនអុករបស់ពួកគេទៅចំណុចដែលទទេឥឡូវនេះ។';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'សកម្មភាពដែលអាចធ្វើបាននៅពេលបង្កើតមីលក្នុងដំណាក់កាលដាក់។';

  @override
  String get marked => 'បានសម្គាល់';

  @override
  String get menu => 'ម៉ឺនុយ';

  @override
  String get monochrome => 'សខ្មៅ';

  @override
  String get youCanEnableScreenReaderSupport =>
      'អ្នកអាចបើកកុងតាក់ការគាំទ្រកម្មវិធីអានអេក្រង់នៅក្នុងការកំណត់រចនាសម្ព័ន្ធភាពងាយស្រួលក្នុងការកំណត់ទូទៅ។';

  @override
  String get showNumbersOnPieces => 'បង្ហាញលេខនៅលើកូនអុក';

  @override
  String get saveImage => 'រក្សាទុករូបភាព';

  @override
  String get isAnalysisToolbarShown => 'បង្ហាញរបារឧបករណ៍វិភាគ';

  @override
  String get analysisToolbarBackgroundColor => 'ពណ៌ផ្ទៃខាងក្រោយរបារឧបករណ៍វិភាគ';

  @override
  String get analysisToolbarIconColor => 'ពណ៌រូបតំណាងរបារឧបករណ៍វិភាគ';

  @override
  String get transformed => 'បានផ្លាស់ប្តូរ។';

  @override
  String get cannotTransform => 'មិនអាចផ្លាស់ប្តូរបានទេ។';

  @override
  String get rotate => 'បង្វិល';

  @override
  String get horizontalFlip => 'ត្រឡប់ផ្ដេក';

  @override
  String get verticalFlip => 'ត្រឡប់បញ្ឈរ';

  @override
  String get innerOuterFlip => 'ត្រឡប់ក្នុងក្រៅ';

  @override
  String get transparentCanvas => 'ផ្ទាំងក្រណាត់ថ្លា';

  @override
  String get restrictRepeatedMillsFormation =>
      'ដាក់កម្រិតការបង្កើតមីលម្តងហើយម្តងទៀត';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'កូនអុកដែលផ្លាស់ទីពីមីលមួយដើម្បីបង្កើតមីលមួយទៀត មិនអាចត្រឡប់ទៅចំណុចដើមវិញភ្លាមៗនៅវេនបន្ទាប់ដើម្បីបង្កើតមីលម្តងទៀតទេ។ ចលនាផ្សេងគ្នាគឺចាំបាច់ជាមុនសិន។';

  @override
  String get oneTimeUseMill => 'មីលប្រើម្តង';

  @override
  String get oneTimeUseMill_Detail =>
      'មីលនីមួយៗអាចដកកូនអុករបស់គូប្រកួតចេញបានតែម្តងគត់។ អ្នកអាចបង្កើតវាឡើងវិញបាន ប៉ុន្តែវាមិនអាចប្រើសម្រាប់ការដកចេញបន្ថែមទៀតទេ។';

  @override
  String get currentRulesNoPerfectDatabase =>
      'ច្បាប់បច្ចុប្បន្នដែលអ្នកបានកំណត់មិនមានមូលដ្ឋានទិន្នន័យល្អឥតខ្ចោះដែលត្រូវគ្នាទេ។ សម្រាប់ព័ត៌មានបន្ថែមអំពីមូលដ្ឋានទិន្នន័យល្អឥតខ្ចោះ សូមចុចទីនេះ។';

  @override
  String get focusOnBlockingPaths => 'ផ្តោតលើការរារាំងផ្លូវ';

  @override
  String get focusOnBlockingPaths_Detail =>
      'ក្នុងដំណាក់កាលជាក់លាក់នៃហ្គេម ត្រូវផ្តល់អាទិភាពដល់ការរារាំងចលនារបស់គូប្រកួត លើសពីការបង្កើតមីល។ ជំនួសឱ្យការផ្តោតលើការដកកូនអុកចេញដោយការបំពេញមីល AI មានគោលបំណងចាប់គូប្រកួតក្នុងដំណាក់កាលទាំងនេះ ធ្វើឱ្យពួកគេមិនអាចផ្លាស់ទីបាន និងធានាបាននូវជ័យជម្នះតាមរយៈការធ្វើឱ្យចុះខ្សោយ ជាជាងការលេងបែបឈ្លានពាន។ យុទ្ធសាស្ត្រជាក់លាក់តាមដំណាក់កាលនេះមិនរារាំងមីលរបស់គូប្រកួតយ៉ាងសកម្មទេ។';

  @override
  String get pieceImage => 'រូបភាពកូនអុក';

  @override
  String get importColorSettings => 'នាំចូលការកំណត់ពណ៌';

  @override
  String get exportColorSettings => 'នាំចេញការកំណត់ពណ៌';

  @override
  String get import => 'នាំចូល';

  @override
  String get export => 'នាំចេញ';

  @override
  String get pleaseCopyJsonToClipboard =>
      'សូមចម្លងការកំណត់ទម្រង់ JSON ទៅឃ្លីបបតជាមុនសិន។';

  @override
  String get copiedToClipboard => 'បានចម្លងទៅឃ្លីបបត។';

  @override
  String get imported => 'បាននាំចូល។';

  @override
  String get boardImage => 'រូបភាពក្តារ';

  @override
  String get autumnLeaves => 'ស្លឹកឈើជ្រុះ';

  @override
  String get legendaryLand => 'ទឹកដីរឿងព្រេងនិទាន';

  @override
  String get vignetteEffect => 'បែបផែនគែមងងឹត';

  @override
  String get promptMakeToolbarTransparent =>
      'តើអ្នកចង់ធ្វើឱ្យរបារឧបករណ៍ថ្លាទាំងស្រុងនៅពេលរូបភាពផ្ទៃខាងក្រោយក្តារត្រូវបានកំណត់ទេ?';

  @override
  String get vibration => 'បើករំញ័រក្នុងហ្គេម';

  @override
  String get soundTheme => 'ស្បែកសំឡេង';

  @override
  String get ball => 'បាល់';

  @override
  String get liquid => 'រាវ';

  @override
  String get wood => 'ឈើ';

  @override
  String get placeEffectAnimation => 'បែបផែនចលនាដាក់កូនអុក';

  @override
  String get removeEffectAnimation => 'បែបផែនចលនាដកកូនអុក';

  @override
  String get isToolbarAtBottom => 'បង្ហាញរបារឧបករណ៍នៅខាងក្រោម';

  @override
  String get boardCornerRadius => 'កាំជ្រុងក្តារ';

  @override
  String get useOpeningBook => 'ប្រើក្បួនបើកឆាក';

  @override
  String get currentRule => 'បច្ចុប្បន្ន';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'សំណុំច្បាប់';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'One-Time Mill';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'អនុញ្ញាតឱ្យ AI ប្រើក្បួនបើកឆាកដែលត្រូវបានប្រើជាទូទៅដោយអ្នកលេងមនុស្សអាជីពក្នុងអំឡុងពេលដើមហ្គេម។ ចំណាំ៖ មុខងារនេះបច្ចុប្បន្នមានសម្រាប់តែសំណុំច្បាប់ជាក់លាក់ប៉ុណ្ណោះ។';

  @override
  String get showAdvantageGraph => 'បង្ហាញក្រាហ្វគុណសម្បត្តិ';

  @override
  String get advantageGraphHint =>
      'ក្រាហ្វគុណសម្បត្តិនឹងត្រូវបានគូរបន្ទាប់ពី AI ធ្វើចលនាប៉ុណ្ណោះ។ វានឹងមិនត្រូវបានគូរនៅពេលអ្នកលេងមនុស្សធ្វើចលនាទេ។';

  @override
  String get removalBasedOnMillCounts =>
      'បិទការដកចេញរហូតដល់កូនអុកទាំងអស់ត្រូវបានដាក់ បន្ទាប់មកដកកូនអុកចេញដោយផ្អែកលើចំនួនមីល។';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'បិទការដកចេញរហូតដល់កូនអុកទាំងអស់ត្រូវបានដាក់ បន្ទាប់មកដកកូនអុកចេញដោយផ្អែកលើចំនួនមីល៖ ប្រសិនបើពួកវាស្មើគ្នា ទាំងពីរដកចំនួនដូចគ្នា ប្រសិនបើមួយមានច្រើនជាង ពួកគេដកមួយបន្ថែម រក្សាភាពខុសគ្នាមួយកូនអុក។ ប្រសិនបើមានតែមួយបង្កើតមីល ពួកគេដកកូនអុកពីរ ហើយមួយទៀតដកមួយ។ ប្រសិនបើគ្មាននរណាម្នាក់បង្កើតមីល ទាំងពីរដកកូនអុកមួយរបស់ខ្លួន។';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'ជ្រើសរើសកូនអុកមួយរបស់អ្នក។';

  @override
  String get notYourTurn => 'វាមិនមែនជាវេនរបស់អ្នកទេ។';

  @override
  String get annotationToolbarBackgroundColor =>
      'ពណ៌ផ្ទៃខាងក្រោយរបារឧបករណ៍ចំណារពន្យល់';

  @override
  String get annotationToolbarIconColor => 'ពណ៌រូបតំណាងរបារឧបករណ៍ចំណារពន្យល់';

  @override
  String get isAnnotationToolbarShown => 'បង្ហាញរបារឧបករណ៍ចំណារពន្យល់';

  @override
  String get enterAnnotationMode => 'ចូលរបៀបចំណារពន្យល់';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'តើអ្នកប្រាកដថាចង់លុបចំណារពន្យល់ទាំងអស់ទេ?';

  @override
  String get llmPromptCopiedToClipboard =>
      'ប្រអប់បញ្ចូល LLM ត្រូវបានចម្លងទៅឃ្លីបបត។';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'ការតភ្ជាប់ត្រូវបានបដិសេធ ម៉ាស៊ីនមេអាចនឹងធ្លាក់។';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'ការរកឃើញជោគជ័យ កំពុងរង់ចាំការតភ្ជាប់...';

  @override
  String get noLanConnection => 'គ្មានការតភ្ជាប់ LAN';

  @override
  String get takeScreenshot => 'ថតរូបអេក្រង់';

  @override
  String get disconnectedFromOpponent => 'បានផ្តាច់ចេញពីគូប្រកួត។';

  @override
  String get takeBackRequest => 'សំណើដកថយ';

  @override
  String get nothingToShow => 'គ្មានអ្វីត្រូវបង្ហាញទេ។';

  @override
  String get stopHosting => 'បញ្ឈប់ការបង្ហោះ';

  @override
  String get connectionResetByPeer => 'ការតភ្ជាប់ត្រូវបានកំណត់ឡើងវិញដោយ peer ។';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'ការតភ្ជាប់បានបាត់បង់ដោយសារតែការអស់ពេល heartbeat ។ សូមតភ្ជាប់ឡើងវិញ។';

  @override
  String get startHosting => 'ចាប់ផ្តើមបង្ហោះ';

  @override
  String get restartRequestRejected => 'សំណើចាប់ផ្តើមឡើងវិញត្រូវបានបដិសេធ។';

  @override
  String get notConnectedToLanOpponent => 'មិនបានតភ្ជាប់ទៅគូប្រកួត LAN ទេ។';

  @override
  String get llmPrompt => 'ប្រអប់បញ្ចូល LLM';

  @override
  String get gameRestarted => 'ហ្គេមបានចាប់ផ្តើមឡើងវិញ។';

  @override
  String get takeBackRejected => 'ការដកថយត្រូវបានបដិសេធ។';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'តើអ្នកប្រាកដថាចង់ចុះចាញ់ហ្គេមនេះទេ?';

  @override
  String get opponentResignedYouWin => 'គូប្រកួតបានលះបង់។ អ្នកឈ្នះ!';

  @override
  String get clearAllAnnotations => 'លុបចំណារពន្យល់ទាំងអស់';

  @override
  String get connectedWaitingForOpponentSMove =>
      'បានតភ្ជាប់ កំពុងរង់ចាំចលនារបស់គូប្រកួត...';

  @override
  String get networkStatusDisconnected => 'ស្ថានភាពបណ្តាញ៖ បានផ្តាច់';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'សំណើដកថយត្រូវបានផ្ញើទៅគូប្រកួត។';

  @override
  String get theOpponentMayHaveLeftTheGame => 'គូប្រកួតអាចនឹងបានចាកចេញពីហ្គេម';

  @override
  String get connectedToHostSuccessfully => 'បានតភ្ជាប់ទៅម៉ាស៊ីនមេដោយជោគជ័យ។';

  @override
  String get connectionLostHeartbeatTimeout =>
      'ការតភ្ជាប់បានបាត់បង់៖ ការអស់ពេល heartbeat';

  @override
  String get noHostDiscovered => 'រកមិនឃើញម៉ាស៊ីនមេទេ។';

  @override
  String get confirmResignation => 'បញ្ជាក់ការលះបង់';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'បានចាប់ផ្តើមបង្ហោះហ្គេម កំពុងរង់ចាំអ្នកលេងចូលរួម...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'ការតភ្ជាប់អស់ពេល ការតភ្ជាប់បណ្តាញមិនស្ថិតស្ថេរ។';

  @override
  String get noLlmPromptAvailable => 'គ្មានប្រអប់បញ្ចូល LLM ទេ។';

  @override
  String get youResignedGameOver => 'អ្នកបានលះបង់។ ចប់ហ្គេម។';

  @override
  String get serverIp => 'IP ម៉ាស៊ីនមេ';

  @override
  String get confirmClear => 'បញ្ជាក់ការលុប';

  @override
  String get opponentSTurn => 'វេនរបស់គូប្រកួត។';

  @override
  String get waitingAClientConnection => 'កំពុងរង់ចាំការតភ្ជាប់ម៉ាស៊ីនភ្ញៀវ...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'សំណើដកថយត្រូវបានបដិសេធ ឬបរាជ័យ។';

  @override
  String get addText => 'បន្ថែមអត្ថបទ';

  @override
  String get exitAnnotationMode => 'ចាកចេញពីរបៀបចំណារពន្យល់';

  @override
  String get typeYourAnnotation => 'វាយចំណារពន្យល់របស់អ្នក';

  @override
  String get attemptingToReconnect => 'កំពុងព្យាយាមតភ្ជាប់ឡើងវិញ...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'សំណើចាប់ផ្តើមឡើងវិញត្រូវបានផ្ញើ។ កំពុងរង់ចាំការឆ្លើយតបរបស់គូប្រកួត...';

  @override
  String get serverIsStopped => 'ម៉ាស៊ីនមេត្រូវបានបញ្ឈប់។';

  @override
  String get restartRequest => 'សំណើចាប់ផ្តើមឡើងវិញ';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'មិនអាចស្នើសុំដកថយនៅពេលវាមិនមែនជាវេនរបស់អ្នកទេ។';

  @override
  String get takeBackAccepted => 'ការដកថយត្រូវបានទទួលយក។';

  @override
  String get localNetworkSettings => 'ការកំណត់បណ្តាញមូលដ្ឋាន';

  @override
  String get reconnectedSuccessfully => 'បានតភ្ជាប់ឡើងវិញដោយជោគជ័យ!';

  @override
  String get failedToSaveImageToGallery =>
      'បរាជ័យក្នុងការរក្សាទុករូបភាពទៅវិចិត្រសាល។';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'គូប្រកួតបានស្នើសុំចាប់ផ្តើមហ្គេមឡើងវិញ។ តើអ្នកយល់ព្រមទេ?';

  @override
  String get yourTurn => 'វេន​របស់​អ្នក។';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'មិនអាចតភ្ជាប់ឡើងវិញបានទេ សូមចាប់ផ្តើមហ្គេមឡើងវិញ។';

  @override
  String get host => 'ម៉ាស៊ីនមេ';

  @override
  String get join => 'ចូលរួម';

  @override
  String get port => 'ច្រក';

  @override
  String get invalidIpAddress => 'អាសយដ្ឋាន IP មិនត្រឹមត្រូវ។';

  @override
  String get invalidPort => 'ច្រកមិនត្រឹមត្រូវ។';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'កំពុងតភ្ជាប់៖ ព្យាយាម $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'មិនអាចតភ្ជាប់បានទេ៖ $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'មិនអាចចាប់ផ្តើមបង្ហោះបានទេ៖ $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'បានរកឃើញម៉ាស៊ីនមេ៖ $ip:$port';
  }

  @override
  String get stop => 'បញ្ឈប់';

  @override
  String get discover => 'រកឃើញ';

  @override
  String get connect => 'តភ្ជាប់';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'ម៉ាស៊ីនភ្ញៀវបានភ្ជាប់៖ $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'កំពុងរកឃើញ៖ $seconds វិនាទី';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'កំពុងតភ្ជាប់ឡើងវិញ ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'បានតភ្ជាប់';

  @override
  String get delete => 'លុប';

  @override
  String get ancientEgypt => 'អេហ្ស៊ីបបុរាណ';

  @override
  String get gothicIce => 'ទឹកកកហ្គោធិក';

  @override
  String get riceField => 'វាលស្រែ';

  @override
  String get chinesePorcelain => 'ប៉សឺឡែនចិន';

  @override
  String get desertDusk => 'សន្ធិយាវាលខ្សាច់';

  @override
  String get precisionCraft => 'សិប្បកម្មជាក់លាក់';

  @override
  String get folkEmbroidery => 'សិល្បៈកាត់តែងដៃប្រពៃណី';

  @override
  String get carpathianHeritage => 'អាថ៌កំបាំងបាយ័ន';

  @override
  String get imperialGrandeur => 'ភាពអស្ចារ្យរបស់អធិរាជ';

  @override
  String get bohemianCrystal => 'គ្រីស្តាល់';

  @override
  String get savannaSunrise => 'ព្រះអាទិត្យរះ Savanna';

  @override
  String get harmonyBalance => 'តុល្យភាពសុខដុម';

  @override
  String get cinnamonSpice => 'គ្រឿងទេសឈើអែម';

  @override
  String get anatolianMosaic => 'ម៉ូសាយអាណាតូលី';

  @override
  String get carnivalSpirit => 'ស្មារតីពិធីបុណ្យ';

  @override
  String get custom => 'ផ្ទាល់ខ្លួន';

  @override
  String get spiceMarket => 'ផ្សារគ្រឿងទេស';

  @override
  String get swipeToRevealTheDrawer => 'អូសដើម្បីបង្ហាញម៉ឺនុយ';

  @override
  String get showGameInfoOnScreenshots => 'បង្ហាញព័ត៌មានហ្គេមនៅលើរូបថតអេក្រង់';

  @override
  String get humanMoveTime => 'ដែនកំណត់ពេលវេលារបស់មនុស្ស';

  @override
  String get noTimeLimitForHumanMoves =>
      'គ្មានដែនកំណត់ពេលវេលាសម្រាប់ការដើររបស់មនុស្សទេ';

  @override
  String get timeoutLoseWillBeApplied =>
      'ការចាញ់ដោយអស់ពេលនឹងត្រូវបានអនុវត្តសម្រាប់អ្នកលេងជាមនុស្ស';

  @override
  String get identifyingBoard => 'កំពុងស្គាល់ផ្ទាំងហ្គេម…';

  @override
  String get youCanEnterAnyModelName => 'អ្នកអាចបញ្ចូលឈ្មោះម៉ូឌែលណាមួយ។';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'ទីតាំងផ្ទាំងបានអនុវត្ត។ FEN បានចម្លងទៅ clipboard។';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'យោបល់៖ សូមព្យាយាមយករូបថតដែលច្បាស់ជាងនៃផ្ទាំង។';

  @override
  String get llmPromptTemplate => 'គំរូសំណើ LLM';

  @override
  String get noValidBoardDetected =>
      'មិនមានផ្ទាំងត្រឹមត្រូវណាមួយត្រូវបានរកឃើញទេ។';

  @override
  String get selectingImageFromAlbum => 'កំពុងជ្រើសរូបភាពពីអាល់ប៊ុម…';

  @override
  String get configurePromptTemplate => 'កំណត់រចនាសម្ព័ន្ធគំរូសំណើ';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'កែប្រែគំរូសំណើសម្រាប់វិភាគ LLM';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'បរាជ័យក្នុងការបង្កើត FEN ពីផ្ទាំងដែលបានស្គាល់។';

  @override
  String get outputInCurrentLanguage => 'លទ្ធផលក្នុងភាសាបច្ចុប្បន្ន';

  @override
  String get commonBaseUrls => 'URL មូលដ្ឋានទូទៅ';

  @override
  String get viewCommonModels => 'មើលម៉ូឌែលទូទៅ';

  @override
  String get recognitionParametersUpdated => 'ប៉ារ៉ាម៉ែត្រស្គាល់បានកែប្រែ។';

  @override
  String get whiteSMove => 'ជំហានអ្នកលេងពណ៌ស';

  @override
  String get resetToDefaults => 'កំណត់ឡើងវិញទៅតម្លៃលំនាំដើម';

  @override
  String get photoShoot => 'ថតរូប';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'បរាជ័យក្នុងការអនុវត្តទីតាំងផ្ទាំងដែលបានស្គាល់។';

  @override
  String get llmPromptContent => 'មាតិការនៃសំណើ LLM';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM មិនបានកំណត់ឡើយ។ សូមពិនិត្យការកំណត់របស់អ្នក។';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'កំណត់អ្នកផ្ដល់សេវា ម៉ូឌែល API Key និង Base URL';

  @override
  String get llmConfiguration => 'ការកំណត់របស់ LLM';

  @override
  String get configureLlmProvider => 'កំណត់អ្នកផ្ដល់សេវា LLM';

  @override
  String get llmPromptTemplateHeader => 'ក្បាលគំរូសំណើ LLM';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'មិនមានឯកតា(pieces)ណាមួយត្រូវបានស្គាល់នៅក្នុងរូបភាពទេ។ សូមព្យាយាមម្តងទៀត។';

  @override
  String get recognizeBoardFromImage => 'ស្គាល់ផ្ទាំងពីរូបភាព';

  @override
  String get viewTips => 'មើលគន្លឹះ';

  @override
  String get applyToBoard => 'អនុវត្តទៅផ្ទាំង';

  @override
  String get adjustBoardArea => 'សម្រួលទំហំផ្ទាំង';

  @override
  String get viewCommonUrls => 'មើល URL ទូទៅ';

  @override
  String get colorAnalysisFailed => 'វិភាគពណ៌បរាជ័យ!';

  @override
  String get analyzingGameBoardImage => 'កំពុងវិភាគរូបភាពផ្ទាំងហ្គេម…';

  @override
  String get selectFromAlbum => 'ជ្រើសពីអាល់ប៊ុម';

  @override
  String get noBoardPointDetected => 'មិនរកឃើញចំណុចផ្ទាំងទេ!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'បើទុកទទេ គំរូលំនាំដើមនឹងត្រូវបានប្រើ';

  @override
  String get llmConfig => 'ការកំណត់របស់ LLM';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'តើអ្នកប្រាកដថាចង់កំណត់គំរូសំណើឡើងវិញទៅតម្លៃលំនាំដើមឬទេ?';

  @override
  String get llmPromptTemplateFooter => 'ជើងគំរូសំណើ LLM';

  @override
  String get loadingResponse => 'កំពុងផ្ទុកចម្លើយ…';

  @override
  String get applyThisResultToBoard => 'អនុវត្តលទ្ធផលនេះទៅផ្ទាំង';

  @override
  String get takingPicture => 'កំពុងថតរូប…';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'សូមជ្រើសរូបភាពផ្ទាំងហ្គេមសម្រាប់ស្គាល់';

  @override
  String get identificationResults => 'លទ្ធផលការស្គាល់';

  @override
  String get analyzeTheMovesAndProvideInsights => 'វិភាគចលនា និងផ្តល់ទស្សនៈ។';

  @override
  String get getApiKey => 'ទទួលបាន API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'ដំណើរការស្គាល់ទាំងមូលបរាជ័យក្នុងការបញ្ចប់។';

  @override
  String get boardRecognitionResult => 'លទ្ធផលស្គាល់ផ្ទាំង';

  @override
  String get askLlm => 'សួរទៅកាន់ LLM';

  @override
  String get boardDetectionFailed => 'ការរកឃើញផ្ទាំងបរាជ័យ!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'មិនឃើញចំណុចផ្ទាំងទេ មិនអាចស្គាល់ធាតុហ្គេមបានទេ!';

  @override
  String get copyFen => 'ចម្លង FEN';

  @override
  String get commonlyUsedModels => 'ម៉ូឌែលដែលប្រើទូទៅ';

  @override
  String get apiKeyOptional => 'API Key (ជាជម្រើស)';

  @override
  String get noImageSelected => 'មិនមានរូបភាពជ្រើសរើស';

  @override
  String get blackSMove => 'ជំហានអ្នកលេងពណ៌ខ្មៅ';

  @override
  String get llm => 'ម៉ូឌែលភាសធំ';

  @override
  String get llmProvider => 'អ្នកផ្តល់សេវា';

  @override
  String get baseUrl => 'URL គោល';

  @override
  String get model => 'ម៉ូឌែល';

  @override
  String get temperature => 'សីតុណ្ហភាព';

  @override
  String get llmCommandReceivedProcessing =>
      'បញ្ជាបានទទួល! បញ្ញាសិប្បនិម្មិតកំពុងដំណើរការ...';

  @override
  String get llmDeepThinkingWait => 'កំពុងគិតជ្រៅ សូមរង់ចាំ...';

  @override
  String get llmPresentingSoon => 'នឹងបង្ហាញក្នុងពេលឆាប់ៗនេះ...';

  @override
  String get recognitionParameters => 'ប៉ារ៉ាម៉ែត្រការទទួលស្គាល់';

  @override
  String get adjustParamsDesc =>
      'កែតំរូវប៉ារ៉ាម៉ែត្រដើម្បីបង្កើនភាពត្រឹមត្រូវនៃការទទួលស្គាល់';

  @override
  String get saveParameters => 'រក្សាទុកប៉ារ៉ាម៉ែត្រ';

  @override
  String unableToStartImageRecognition(String error) {
    return 'មិនអាចចាប់ផ្តើមការទទួលស្គាល់រូបភាពបានទេ៖ $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'ការទទួលស្គាល់រូបភាពបរាជ័យ៖ $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'បានអនុវត្តស្ថានភាពដែលមានដុំស $whiteCount និងដុំខ្មៅ $blackCount';
  }

  @override
  String get fenCopiedToClipboard => '(FEN ត្រូវបានចម្លងទៅក្តារតម្រៀប)';

  @override
  String recognitionFailed(String error) {
    return 'ការទទួលស្គាល់បរាជ័យ៖ $error';
  }

  @override
  String get myRating => 'ការវាយតម្លៃរបស់ខ្ញុំ';

  @override
  String get gamesPlayed => 'ហ្គេមបានលេង';

  @override
  String get wins => 'ឈ្នះ';

  @override
  String get losses => 'ចាញ់';

  @override
  String get draws => 'ស្មើ';

  @override
  String get lastUpdated => 'បានធ្វើបច្ចុប្បន្នភាពចុងក្រោយ';

  @override
  String get format => 'ទ្រង់ទ្រាយ៖';

  @override
  String get resetStatistics => 'កំណត់ស្ថិតិឡើងវិញ';

  @override
  String get drawRate => 'អត្រាស្មើ';

  @override
  String get lossRate => 'អត្រាចាញ់';

  @override
  String get aiStatistics => 'ស្ថិតិ AI';

  @override
  String get enableStatistics => 'បើកស្ថិតិ';

  @override
  String get enableStatistics_Detail =>
      'នៅពេលបើក លទ្ធផលហ្គេមនឹងត្រូវបានកត់ត្រាក្នុងស្ថិតិ។ ទោះយ៉ាងណាក៏ដោយ ហ្គេមដែលពាក់ព័ន្ធនឹងការដកថយនឹងមិនត្រូវបានកត់ត្រាទេ។ នៅពេលបិទ ការប្រមូលស្ថិតិត្រូវបានផ្អាក។';

  @override
  String get thisWillResetAllGameStatistics =>
      'វានឹងកំណត់ស្ថិតិហ្គេមទាំងអស់ឡើងវិញ។ សកម្មភាពនេះមិនអាចមិនធ្វើវិញបានទេ។';

  @override
  String get boardInnerRingSize => 'ទំហំរង្វង់ខាងក្នុងបន្ទះ';

  @override
  String get boardShadowEnabled => 'ស្រមោលផ្ទាំង';

  @override
  String get trapAwareness => 'រកឃើញអន្ទាក់';

  @override
  String get trapAwarenessDescription =>
      'រំលេចចលនាអន្ទាក់ដោយរង្វង់ និងព្រួញដ៏ដិត ក្នុងអំឡុងការវិភាគ.';

  @override
  String trapExists(String trapMoves) {
    return 'មានអន្ទាក់។ ចលនាអន្ទាក់: $trapMoves';
  }

  @override
  String get custodianCapture => 'ការចាប់យក';

  @override
  String get custodianCaptureDescription =>
      'ព័ទ្ធជុំវិញបំណែករបស់គូប្រជែងរបស់អ្នកមួយរវាងពីររបស់អ្នកក្នុងបន្ទាត់ត្រង់ដើម្បីចាប់យកវា។';

  @override
  String get custodianCaptureEnable => 'អនុញ្ញាតឱ្យការចាប់យកអណ្តូង';

  @override
  String get interventionCapture => 'ការចាប់យកអន្តរាគមន៍';

  @override
  String get interventionCaptureDescription =>
      'ផ្លាស់ទីទៅចំណុចទទេរវាងបំណែករបស់គូប្រជែងពីររបស់អ្នកដើម្បីចាប់យកពួកគេទាំងពីរ។';

  @override
  String get interventionCaptureEnable =>
      'អនុញ្ញាតឱ្យការចាប់អន្តរាគមន៍អន្តរាគមន៍';

  @override
  String get leapCapture => 'លោតលោត';

  @override
  String get leapCaptureDescription =>
      'ចាប់យកដោយលោតលើបំណែករបស់គូប្រជែងដែលនៅជាប់នឹងចំនុចទទេលើស។';

  @override
  String get leapCaptureEnable => 'អនុញ្ញាតឱ្យលោតលោត';

  @override
  String get captureApplicableLines => 'បន្ទាត់ដែលអាចអនុវត្តបាន';

  @override
  String get captureSquareEdges => 'នៅតាមគែមការ៉េ';

  @override
  String get captureCrossLines => 'នៅតាមបណ្តោយបន្ទាត់អ័ក្សអ័រអ័រឆ្លងកាត់ការេ';

  @override
  String get captureDiagonalLines => 'តាមទ្រនុងអង្កត់ទ្រូងឆ្លងកាត់ការ៉េ';

  @override
  String get captureExecutionPhases => 'ដំណាក់កាលប្រតិបត្តិ';

  @override
  String get capturePiecesCondition =>
      'ភាពអាចរកបានក្នុងដំណាក់កាលផ្លាស់ប្តូរផ្អែកលើបំណែកដែលនៅសល់';

  @override
  String get capturePiecesConditionUnlimited => 'គ្មានការដាក់កម្រិត';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'មាននៅពេលអ្នកមានបំណែកបីឬតិចជាងនេះ';
}
