// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Japanese (`ja`).
class SJa extends S {
  SJa([String locale = 'ja']) : super(locale);

  @override
  String get appName => 'モリス';

  @override
  String get welcome => 'いらっしゃいませ';

  @override
  String get yes => 'はい';

  @override
  String get no => 'いいえ';

  @override
  String get game => '遊戲';

  @override
  String get humanVsAi => '人間対機';

  @override
  String get humanVsHuman => '人対人戦';

  @override
  String get aiVsAi => '機対機戦';

  @override
  String get humanVsCloud => '人間対雲';

  @override
  String get humanVsLAN => '局域双戦';

  @override
  String get testViaLAN => 'LAN経由でテスト';

  @override
  String get move => '棋譜';

  @override
  String get showMoveList => '棋譜リスト';

  @override
  String get moveList => '棋譜リスト';

  @override
  String get noGameRecord => '記録なし';

  @override
  String get ok => 'OK';

  @override
  String get confirm => '確認';

  @override
  String get cancel => '取り消し';

  @override
  String get tipSelectWrong => '誤ったピースが選択されました。';

  @override
  String get tipPlace => 'ピースを配置してください。';

  @override
  String get tipBanPlace => 'ここには配置できません。';

  @override
  String get tipPlaced => '配置されました。';

  @override
  String get tipRemove => '駒を1つ取り除く。';

  @override
  String get tipBanRemove => '削除することはできません。';

  @override
  String get tipRemoved => '削除されました。';

  @override
  String get tipMove => 'ピースを移動します。';

  @override
  String get tipCannotPlace => 'ここに駒を置くことはできません。';

  @override
  String get tipCannotMove => 'ここに駒を移動することはできません。';

  @override
  String get tipMill => 'ミル成立！相手の駒を取ってください。';

  @override
  String get tipContinueMill => '相手の駒を取り続けます。';

  @override
  String get tipSelectOpponentsPiece => '相手の駒を1枚選ぶ。';

  @override
  String get tipCannotRemovePieceFromMill => 'ミルから駒を取り除くことはできません。';

  @override
  String get tipCanMoveOnePoint => '駒は1ポイント移動できます。';

  @override
  String get tipCannotMoveOpponentsPieces => '相手の駒を動かすことはできません。';

  @override
  String get tipSelectPieceToMove => '移動する駒を選択します。';

  @override
  String get tipHaveThreePiecesLeft => '残り3枚です。';

  @override
  String get tipCanMoveToAnyPoint => '好きなポイントに移動できます。';

  @override
  String tipToMove(Object player) {
    return '$player移動します。';
  }

  @override
  String get whiteWin => 'プレーヤー 1 の勝利です。';

  @override
  String get blackWin => 'プレイヤー 2 の勝利です。';

  @override
  String get won => '勝利した';

  @override
  String get lost => '失った';

  @override
  String get thinking => '考え…';

  @override
  String get newGame => '新しいゲーム';

  @override
  String get importGame => 'ゲームのインポート';

  @override
  String get exportGame => 'ゲームのエクスポート';

  @override
  String get gameImported => 'ゲームがインポートされました。';

  @override
  String cannotImport(Object invalidMove) {
    return '$invalidMove をインポートできません';
  }

  @override
  String get movesAndRulesNotMatch => '指し手とルールが一致しません。';

  @override
  String get pleaseWait => 'お待ちください。';

  @override
  String get restartGame => '現在のゲームをやり直しますか？';

  @override
  String get restart => '再起動';

  @override
  String get gameStarted => 'ゲームが開始されました。配置してください。';

  @override
  String get analyzing => '分析中…';

  @override
  String error(Object message) {
    return 'エラー: $message';
  }

  @override
  String get winRate => '勝率';

  @override
  String get score => 'スコア：';

  @override
  String get white => 'プレ1';

  @override
  String get black => 'プレ2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player 個数が 3 個未満です。';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player 辞任しました。';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$playerは行く方法がありません。';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'ボードはいっぱいで、$player は行き場がありません。';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return '時は過ぎ、$playerは失われました。';
  }

  @override
  String get drawReasonRule50 => '移動フェーズでは、最後の特定の数の移動で駒が取り除かれていません。';

  @override
  String get drawReasonBoardIsFull => 'ボードがいっぱいなので引き分けです。';

  @override
  String get drawReasonThreefoldRepetition => '3回繰り返しのため引き分けです。';

  @override
  String get gameOverUnknownReason => 'ゲームオーバー！原因不明。';

  @override
  String get gameOver => 'ゲームオーバー';

  @override
  String get youWin => 'あなたは勝ちました！おめでとうございます！';

  @override
  String challengeHarderLevel(int level) {
    return 'より難しいレベルに挑戦しますか？新しいレベルはレベル $level になります!';
  }

  @override
  String get youLose => 'あなたは負けました。';

  @override
  String get analyze => '分析する';

  @override
  String get about => '情報';

  @override
  String version(Object versionNumber) {
    return 'バージョン: $versionNumber';
  }

  @override
  String get thanks => 'ありがとう';

  @override
  String get settings => '個人設定';

  @override
  String get options => '設定';

  @override
  String get generalSettings => '一般設定';

  @override
  String get skillLevel => '難易度';

  @override
  String get moveTime => 'AI思考時間';

  @override
  String get difficulty => '難易度';

  @override
  String get playSounds => '音響効果';

  @override
  String get playSoundsInTheGame => 'ゲームでサウンドを再生する';

  @override
  String get keepMuteWhenTakingBack => '手戻り中はミュート';

  @override
  String get tone => '音色';

  @override
  String get whoMovesFirst => '最初の一手';

  @override
  String get human => '人間';

  @override
  String get ai => 'AI';

  @override
  String get alternate => '交互';

  @override
  String get isAutoRestart => 'ゲームオーバー時に自動でやり直す';

  @override
  String get isAutoChangeFirstMove => '先手を自動変更';

  @override
  String get shufflingEnabled => 'ランダムに移動';

  @override
  String get misc => 'その他';

  @override
  String get rules => 'ルール';

  @override
  String get piecesCount => '各プレイヤーが持っている駒の数';

  @override
  String get piecesCount_Detail => '各プレイヤーは何個のピースを持っていますか?';

  @override
  String get flyPieceCount => '飛び駒の数';

  @override
  String get flyPieceCount_Detail =>
      'フライングが有効になっている場合、プレーヤーが特定のピース数に減ると、ゲームの残りの部分のように隣接するポイントに制限されるのではなく、空いているポイントに自由に移動できます。';

  @override
  String get piecesAtLeastCount => '最低駒数';

  @override
  String get hasDiagonalLines => '対角線';

  @override
  String get hasDiagonalLines_Detail => 'ボードに 4 本の対角線を追加します。';

  @override
  String get isDefenderMoveFirst => '2番目のプレーヤーが最初に移動します';

  @override
  String get isDefenderMoveFirst_Detail =>
      '配置フェイズで 2 番目に移動したプレイヤーが、移動フェイズで最初に移動します。';

  @override
  String get mayRemoveMultiple => 'マルチリムーブ';

  @override
  String get mayRemoveMultiple_Detail =>
      'プレーヤーが一度に複数のミルを完成させた場合、完成させたミルの数だけ駒を取り除けます。';

  @override
  String get mayRemoveFromMillsAlways => 'ミルを破壊する';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'デフォルトでは、プレーヤーは形成されたミルから駒を取り除く前に、他の駒を最初に取り除く必要があります。制限を無効にするには、このオプションを有効にします。';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'ボードがいっぱいになると、2 番目のプレイヤーが負けます';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      '配置フェーズの終了時にボードがいっぱいになると、最初に配置した側がゲームに負けます。それ以外の場合、ゲームは引き分けです。';

  @override
  String get isLoseButNotChangeSideWhenNoWay => '正当な手がなければ負け';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'このオプションが無効になっている場合は、手番を交代します。';

  @override
  String get mayFly => '飛行';

  @override
  String get mayFly_Detail =>
      'プレイヤーが 3 つまたは 4 つの (構成可能な) ピースしか残っていない場合、そのピースを任意のフリー ポイントに移動できます。';

  @override
  String get nMoveRule => 'N手ルール';

  @override
  String get nMoveRule_Detail => 'ゲームは、特定の数の手で除去がなかった場合に引き分けになります。';

  @override
  String get rollback => 'ロールバック';

  @override
  String get pleaseSelect => '選んでください';

  @override
  String get copy => 'コピー';

  @override
  String get moveHistoryCopied => '移動履歴をクリップボードにコピーしました。';

  @override
  String get help => '利用案内';

  @override
  String get feedback => '意見';

  @override
  String get exit => '遊戯終了';

  @override
  String get ruleSettings => '棋規設定';

  @override
  String get color => '色';

  @override
  String get boardColor => 'ボードの色';

  @override
  String get pieceColor => 'ピースの色';

  @override
  String get backgroundColor => '背景色';

  @override
  String get lineColor => 'ボードラインの色';

  @override
  String get whitePieceColor => 'プレイヤー1の駒の色';

  @override
  String get blackPieceColor => 'プレイヤー2の駒の色';

  @override
  String get messageColor => 'メッセージカラー';

  @override
  String get isPieceCountInHandShown => '配置されていないピースの数を表示';

  @override
  String get isNotationsShown => 'ボード上の表記を表示';

  @override
  String get isHistoryNavigationToolbarShown => '履歴ナビゲーション ツールバーを表示';

  @override
  String get display => '表示';

  @override
  String get boardBorderLineWidth => '盤の境界線の幅';

  @override
  String get boardInnerLineWidth => '盤内線幅';

  @override
  String get pieceWidth => 'ピース幅';

  @override
  String get fontSize => 'フォントサイズ';

  @override
  String get standardNotation => 'WMD表記';

  @override
  String get restore => '戻す';

  @override
  String get restoreDefaultSettings => 'デフォルト設定の復元';

  @override
  String pick(Object element) {
    return '$element を選択';
  }

  @override
  String get info => '情報';

  @override
  String get hint => 'ヒント';

  @override
  String get player => 'プレーヤー';

  @override
  String get player1 => 'プレ1';

  @override
  String get player2 => 'プレ2';

  @override
  String get howToPlay => '遊戲方法';

  @override
  String get toPlacePiece => '利用可能なポイントをタップしてピースを配置します。';

  @override
  String get toSelectPiece => '駒をタップして動かします。';

  @override
  String get toMovePiece => 'ピースに接続されたポイントをタップして移動します。';

  @override
  String get toRemovePiece => '相手の駒を1つタップして取り除きます。';

  @override
  String get needToCreateMillFirst => 'ピースを削除する前に、ミルを作成する必要があります。';

  @override
  String get needToPlayWithOwnPieces => '自分の駒でプレイする必要があります。';

  @override
  String get statistics => '統計資料';

  @override
  String get totalGames => '総ゲーム数';

  @override
  String get results => '結果';

  @override
  String get left => '左';

  @override
  String get privacyPolicy => 'プライバシーポリシー';

  @override
  String get privacyPolicy_Detail_1 => 'よくお読みいただき、内容を十分にご理解・ご同意の上、 ';

  @override
  String get privacyPolicy_Detail_2 =>
      '.このポリシーに同意しない場合は、このアプリを使用しないでください。アプリを使用することは、これらの条件に同意することを意味します。';

  @override
  String get and => ' と ';

  @override
  String get accept => '受け入れる';

  @override
  String get takeBack => '待った';

  @override
  String get takingBack => '取り戻す…';

  @override
  String get waiting => '待っている…';

  @override
  String get stepForward => '踏み出す';

  @override
  String get takeBackAll => '全手戻り';

  @override
  String get stepForwardAll => '最後まで進む';

  @override
  String get moveNow => '今すぐ移動';

  @override
  String get done => '終わり。';

  @override
  String get crackMill => 'クラックミル';

  @override
  String get crackMill_Detail => 'プレーヤーがミルに駒しかない場合、ミルの駒はロックされずに削除されます。';

  @override
  String get animationDuration => 'アニメーションの長さ';

  @override
  String get none => 'なし';

  @override
  String get theme => 'テーマ';

  @override
  String get helpContent =>
      'ゲームの目的は、対戦相手の駒を 3 つ未満にするか、正当な動きをなくすことです。\n\n局面が 3 回目に発生するか、最後の 100 回 (設定可能) の動きで削除しない場合、ゲームは自動的に引き分けます。\n\nゲームは次の 3 つのフェーズで進行します。\n\n1.空いた場所に駒を置く\n2. ピースを隣接するポイントに移動する\n3. (オプションのフェーズ) プレイヤーを 3 ピースに減らすときに、空いているポイントにピースを移動する\n\n配置する\n\nゲームは、24 ポイントのグリッドで構成される空のボードから始まります。プレイヤーは、各プレイヤーがすべての駒をボードに配置するまで、空いているポイントに順番に駒を配置します。プレイヤーが自分の駒を 3 つ並べることができる場合、そのプレイヤーは「ミル」を持ち、対戦相手の駒の 1 つをボードから取り除くことができます。\n\n一部のルールでは、プレーヤーは形成されたミルから駒を取り除く前に、他の駒を最初に取り除く必要があります。\n\nルールによっては、配置フェイズで取り除いた駒のポイントに駒を再配置できない場合があります。\n\nすべての駒を使用すると、プレーヤーは交代で移動します。\n\n移動中\n\n移動するには、プレイヤーは駒の 1 つをボード ラインに沿って空いている隣接ポイントに移動します。それができない場合、彼はゲームに負けたことになります。ボード ライン上に自分の駒を 3 つ並べたプレーヤーはミルを持ち、配置フェイズと同様に対戦相手の駒の 1 つを取り除くことができます。どのプレーヤーも 2 駒に減り、新しいミルを形成する選択肢がないため、ゲームに負けます。対戦相手が移動をブロックした場合、プレーヤーは 3 個以上の駒を失うこともあります。\n\n飛行\n\nルールのいくつかのバリエーションでは、プレイヤーが駒を 3 つしか残せなくなると、その駒は、隣接するポイントだけでなく、空いているポイントに飛んだり、ホップしたり、ジャンプしたりできます。\n';

  @override
  String get versionInfo => 'バージョン情報';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'ライセンス';

  @override
  String get sourceCode => 'ソースコード';

  @override
  String get appVersion => 'アプリのバージョン';

  @override
  String get general => '一般';

  @override
  String get advanced => '高度';

  @override
  String get placing => '配置段階';

  @override
  String get moving => '移動段階';

  @override
  String get removing => '駒取り段階';

  @override
  String get gameOverCondition => 'ゲーム終了条件';

  @override
  String get aisPlayStyle => 'AIのプレイスタイル';

  @override
  String get passive => '受け身';

  @override
  String get timeout => 'タイムアウト';

  @override
  String get appearance => '外観設定';

  @override
  String get drawOnHumanExperience => '人間の経験を活かす';

  @override
  String get considerMobility => 'ピースの可動性を考慮する';

  @override
  String get pieceCount => 'ピース数:';

  @override
  String inHand(Object player, int count) {
    return '$player 手札: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player 盤上: $count';
  }

  @override
  String get boardTop => '上からのボード オフセット';

  @override
  String get notAIsTurn => 'AIの番ではありません。';

  @override
  String get aiIsNotThinking => 'AIは考えていません。';

  @override
  String get atEnd => 'あなたは移動リストの最後にいます。';

  @override
  String get tapBackAgainToLeave => '戻るにはもう一度タップします。';

  @override
  String get more => 'もっと';

  @override
  String get experimental => 'これは実験的な機能です。';

  @override
  String get experiments => '実験';

  @override
  String get ossLicenses => 'オープンソース ライセンス';

  @override
  String get language => '言語';

  @override
  String get defaultLanguage => '既定の言語';

  @override
  String get mayMoveInPlacingPhase => 'ピースは配置フェーズで移動できます';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      '明確な配置フェーズと移動フェーズはありません。つまり、プレーヤーは、ボードにピースを配置するか、ピースの 1 つを移動するか (配置するピースが残っている限り) を移動するたびに決定できます。';

  @override
  String get drawerColor => 'メニューの色';

  @override
  String get drawerTextColor => 'メニューの文字色';

  @override
  String get drawerHighlightItemColor => 'メニューのハイライト項目の色';

  @override
  String get mainToolbarBackgroundColor => 'メイン ツールバーの背景色';

  @override
  String get mainToolbarIconColor => 'メイン ツールバーのアイコンの色';

  @override
  String get navigationToolbarBackgroundColor => 'ナビゲーション ツールバーの背景色';

  @override
  String get navigationToolbarIconColor => 'ナビゲーション ツールバーのアイコンの色';

  @override
  String get autoHideToolbar => 'ツールバーを自動的に非表示にする';

  @override
  String get toolbarLocationOnScreen => '画面上のツールバーの場所';

  @override
  String get top => '上';

  @override
  String get bottom => '下';

  @override
  String get center => '中心';

  @override
  String get solidColor => 'ソリッドカラー';

  @override
  String get picture => '写真';

  @override
  String get chooseYourPicture => 'あなたの写真を選択してください';

  @override
  String get light => 'ライト';

  @override
  String get dark => 'ダーク';

  @override
  String get themes => 'テーマ';

  @override
  String get currentTheme => '現在のテーマ';

  @override
  String get saveTheme => 'テーマを保存';

  @override
  String get showAnalysisGraph => '分析グラフを表示';

  @override
  String get analysis => '分析';

  @override
  String get saveGame => 'ゲームを保存する';

  @override
  String get loadGame => 'ゲームをロード';

  @override
  String get setupPosition => '局面設定';

  @override
  String get showLegalMoves => '有効な手を表示';

  @override
  String get showLastMove => '最後の動きを表示';

  @override
  String get showArrows => '矢印を表示';

  @override
  String get pieces => 'ピース';

  @override
  String get showAnalysis => '分析を表示';

  @override
  String get threads => 'スレッド';

  @override
  String get getInvolved => '参加する';

  @override
  String get helpImproveTranslate => '翻訳の改善にご協力ください';

  @override
  String get tutorial => 'チュートリアル';

  @override
  String get classicMill => 'クラシックミル';

  @override
  String get mixedMill => 'ミックスミル';

  @override
  String get ceylonMill => 'セイロンミル';

  @override
  String get mayBreakAndRemakeMillRepeatedly => 'ミルは壊してすぐに別のミルを作ってもよい';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'そのプレーヤーは、新しいミルを作る場合、次の手でその駒を元の点に戻すことができます。';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'プレーヤーが 3 つのピースを持っていて、10 回の移動後にどちらのプレーヤーも対戦相手のピースを削除しない場合、ゲームは引き分けになります。';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'いずれかの駒が 3 個になり、どちらのプレーヤーも 10 手以内に相手の駒を取り除くことができない場合、ゲームは引き分けになります。';

  @override
  String get close => '閉じる';

  @override
  String get whitePiece => 'ホワイトピース';

  @override
  String get blackPiece => 'ブラックピース';

  @override
  String get emptyPoint => '空のポイント';

  @override
  String get noPoint => 'ポイントなし';

  @override
  String get placingPhase => '配置段階';

  @override
  String get movingPhase => '移動段階';

  @override
  String get flyingPhase => '飛行段階';

  @override
  String sideToMove(Object player) {
    return '移動する側: $player';
  }

  @override
  String lastMove(Object move) {
    return '最後の一手：$move';
  }

  @override
  String get selected => '選択済み';

  @override
  String get accessibility => 'アクセシビリティ';

  @override
  String get screenReaderSupport => 'スクリーン リーダーのサポート';

  @override
  String get isDraw => 'ドローです！';

  @override
  String get draw => '引き分け';

  @override
  String get pieceHighlightColor => 'ピースハイライトカラー';

  @override
  String get algorithm => 'アルゴリズム';

  @override
  String get endgameNMoveRule => 'エンドゲーム N-Move ルール';

  @override
  String get endgameNMoveRule_Detail =>
      'いずれかのプレーヤーが 3 つの駒しか持っておらず、どちらのプレーヤーも特定の移動内で駒を削除しない場合、ゲームは引き分けになります。';

  @override
  String get drawReasonEndgameRule50 =>
      'どちらのプレーヤーも駒を 3 つしか持っておらず、どちらのプレーヤーも特定の移動内で駒を削除しません。';

  @override
  String get threefoldRepetitionRule => '3回繰り返しルール';

  @override
  String get threefoldRepetitionRule_Detail => '局面が3回同じになった場合、引き分けになります。';

  @override
  String get continueToMakeMove => 'ミル成立！さらに動きを続けてください。';

  @override
  String get pointStyle => 'ポイントスタイル';

  @override
  String get pointWidth => 'ポイント幅';

  @override
  String get solid => '塗りつぶし';

  @override
  String get hollow => '中空';

  @override
  String get languageName => '日本語';

  @override
  String moveNumber(int count) {
    return '$count手';
  }

  @override
  String get loadFailed => '読み込みに失敗しました。';

  @override
  String get filename => 'ファイル名';

  @override
  String get browse => 'ブラウズ…';

  @override
  String get gameFiles => 'ゲームファイル';

  @override
  String get gameSavedTo => 'ゲームは次の場所に保存されます';

  @override
  String get empty => '空';

  @override
  String get noMove => '指し手なし';

  @override
  String get restoredPosition => '初期位置を復元しました。';

  @override
  String get clean => 'クリア';

  @override
  String get cleanedUp => 'クリーンアップ。';

  @override
  String get remove => '削除';

  @override
  String get noPiecesCanBeRemoved => 'ピースは削除できません。';

  @override
  String pieceCountNeedToRemove(int count) {
    return '$count個の駒を削除する必要があります。';
  }

  @override
  String placedCount(int count) {
    return '配置 ($count)';
  }

  @override
  String get placedPieceCount => '配置フェーズで配置された個数。';

  @override
  String hasPlacedPieceCount(int count) {
    return '現在のプレイヤーは $count 個の駒を配置しました。';
  }

  @override
  String get notPlacingPhase => '配置フェーズではありません。変更できません。';

  @override
  String get paste => '貼り付け';

  @override
  String get pasteDone => '貼り付け完了です。';

  @override
  String get cannotPaste => '貼り付けできません。';

  @override
  String get isUnplacedAndRemovedPiecesShown => '未配置および削除されたピースを表示';

  @override
  String get fullScreen => '全画面表示';

  @override
  String get reopenToTakeEffect => '設定を有効にするには、アプリを終了して再度開きます。';

  @override
  String get forest => '森';

  @override
  String get desktopImage => 'デスクトップ画像';

  @override
  String get invalidPosition => '位置が無効です。';

  @override
  String get shareGIF => 'GIF を共有';

  @override
  String get pixelRatio => 'ピクセル比';

  @override
  String get duration => '時間';

  @override
  String get gameScreenRecorder => 'ゲームスクリーンレコーダー';

  @override
  String get previous => '前';

  @override
  String get next => '次';

  @override
  String get skip => 'スキップ';

  @override
  String get gotIt => 'とった';

  @override
  String get youCanModifyRules => 'ルール設定でゲームのルールを変更できます。';

  @override
  String get youCanUseMouseWheelInPicker => 'マウス ホイールを使用して、ピッカーの値を変更できます。';

  @override
  String get noTimeLimitForThinking => 'AI 思考時間を 0 に設定すると、思考の時間制限がなくなります。';

  @override
  String get whatIsMtdf =>
      'MTD(f) は、中間検索結果を再利用し、適切な初期推定を使用して検索スペースを狭めることによって効率を向上させることを目的とした、アルファ ベータ検索アルゴリズムの修正された形式です。';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'AIの思考時間の調整は完全に正確ではない可能性があることに注意してください。実際の思考時間は、難易度を低く設定すると短くなり、時間切れでAIが思考中の場合は長くなる場合があります。';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      '難易度を高く設定してもAIの思考時間を増やさないと、思考時間の制約により、実際の難易度は低い値に制限される場合があります。実際の値は、マシンのパフォーマンスによって異なる場合があります。';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) は、特定の位置で最適な動きを見つけるための検索アルゴリズムです。これは alpha-beta アルゴリズムの拡張であり、ヌルまたはゼロのウィンドウ検索を使用して、主要なバリエーションからの既に安全なスコアよりも動きが悪いかそうでないかを確認します。 PVS は、最も有望な動きに焦点を当て、次善のブランチの不要な検索を回避します。これにより、検索の効率が向上します。';

  @override
  String get whatIsAlphaBeta =>
      'alpha-beta アルゴリズムは、最良の動きを見つけるための検索アルゴリズムです。これは、ミニマックスの原理と、アルファとベータの 2 つの値を使用して、検索ツリーを剪定し、効率を高めます。アルファはコンピューターが獲得できると確信している最小スコアを表し、ベータは対戦相手が獲得できる最大スコアを表します。このアルゴリズムは、コンピューターがゲームでスマートで効率的な決定を下すのに役立ちます。';

  @override
  String get drawOnTheHumanExperienceDetail =>
      '人間の経験によれば、勝とうとすると負けます。代わりに、目標として引き分けを目指し、ゲームに負けないようにしてください。相手を観察し、相手がミスをしそうな位置にそっと誘い込みます。彼らが弱みを見せたときは、チャンスをつかみ、勝利を目指して優しくプッシュしてください。このようにして、ゲームに勝つことができます。';

  @override
  String get firstMoveDetail => 'このゲームでは、最初のプレーヤーよりも 2 番目のプレーヤーの方が勝ちやすいです。';

  @override
  String get passiveDetail =>
      'パッシブ オプションを有効にすると、AI は、積極的にできるだけ早く勝とうとするのではなく、有利な立場にあるときにリラックスします。';

  @override
  String get moveRandomlyDetail =>
      'このオプションを有効にすると、ゲームのランダム性と楽しさが増しますが、無効にすると、AI を打ち負かす方法を研究するのに役立ちます。';

  @override
  String get considerMobilityOfPiecesDetail =>
      'AIが駒の機動性を考慮すれば、相手の駒をできるだけ早く捕らえることを目指すだけでなく、相手の動きをブロックして阻止することも考慮します。';

  @override
  String get whenBoardIsFull => 'ボードがいっぱいになったら';

  @override
  String get whenBoardIsFull_Detail =>
      '配置フェーズの終了時、移動フェーズが始まる前に、ボードがピースでいっぱいになっている場合、アクションが続きます。';

  @override
  String get sideToMoveRemovePiece => '移動フェイズで先に動いたプレイヤーは、相手の駒を1つ取り除きます。';

  @override
  String get agreeToDraw => '双方が引き分けに同意します。';

  @override
  String get takeOpponentsPiece => '相手の駒を1枚取る。';

  @override
  String get firstPlayerLose => '最初のプレーヤーがゲームに負けます。';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      '最初と 2 番目のプレーヤーは、対戦相手の駒の 1 つを削除します。';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      '2 番目と 1 番目のプレーヤーは、対戦相手の駒を 1 つ取り除きます。';

  @override
  String get enteredFlyingPhase =>
      '飛行フェイズに入ると、対戦相手の駒はボード上の空いている場所にジャンプできます。 「ルール設定」で飛行ルールをオフにすることができます。';

  @override
  String get whenStalemate => '膠着状態のとき';

  @override
  String get whenStalemate_Detail => '駒を動かせない場合の次のアクションは?';

  @override
  String get endWithStalemateLoss => 'ブロックされた側のステイルメイトによる負けで終了します。';

  @override
  String get changeSideToMove => '手番を交代します。';

  @override
  String get removeOpponentsPieceAndMakeNextMove => '対戦相手の駒を1つ取り除き、次の動きをします。';

  @override
  String get endWithStalemateDraw => '膠着状態の引き分けで終了。';

  @override
  String get removeOpponentsPieceAndChangeSideToMove => '相手の駒を1つ取り除き、手番を交代します。';

  @override
  String get aiResponseDelayTime => 'AI 応答遅延時間';

  @override
  String get aiIsDelaying => 'AI は現在、遅延応答段階にあります。続行する前に、しばらくお待ちください。';

  @override
  String get tipCanNotRemoveNonadjacent => '隣接していないピースを削除することはできません。';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      '膠着状態の場合、ミルのフォーメーションに関係なく、自分の駒に隣接する相手の駒を取り除くことができます。';

  @override
  String get whatIsMcts =>
      'MCTS は、シミュレーションを通じてさまざまな動きを調査および評価することによって決定を下す、初心者に優しいアルゴリズムです。';

  @override
  String get goldenJade => 'ゴールデンジェイド';

  @override
  String get forestWood => 'フォレストウッド';

  @override
  String get darkMystery => 'ダークミステリー';

  @override
  String get midnightBlue => 'ミッドナイトブルー';

  @override
  String get greenForest => '緑の森';

  @override
  String get greenMeadow => '緑の牧草地';

  @override
  String get stonyPath => '石の道';

  @override
  String get pastelPink => 'パステルピンク';

  @override
  String get turquoiseSea => 'ターコイズ ブルーの海';

  @override
  String get violetDream => '紫の夢';

  @override
  String get mintChocolate => 'ミントチョコレート';

  @override
  String get skyBlue => '空色';

  @override
  String get playfulGarden => '遊び心のある庭';

  @override
  String get whatIsRetrogradeAnalysis =>
      '逆行分析アルゴリズムは、多値逆行分析を使用してさまざまな開始位置からエンドゲーム データベースを構築し、このデータベースを適用してゲームプレイを最適化します。このアプローチは、超強力ソリューションのカテゴリーに分類されます。';

  @override
  String get viewAlgorithmGuide => 'このアルゴリズムのユーザー ガイドを参照しますか?';

  @override
  String get showPositionalAdvantageIndicator => '局面の有利不利インジケーターを表示';

  @override
  String get usePerfectDatabase => '完璧なデータベースを使用する';

  @override
  String get perfectDatabaseDescription =>
      'このオプションを有効にすると、最先端のアルゴリズムによって生成された完璧なゲームデータベースが使用されます。この機能は、オープニングとエンドゲームの戦略を統合して、最適な手を提案します。ゲームプレイにおいて最高レベルの精度を求めるプレイヤーにとって、これは優先される選択肢です。厳密な計算技術を通じて作成されたこのデータベースは、ほぼ完璧なゲームソリューションを提供するよう設計されています。\n\n注意：AIがデータベースにアクセスできない場合は、ゲームプレイの決定のために従来のアルゴリズムに切り替わります。データベースが利用可能な場合、「難易度レベル」は事実上無敵になり、「AIの思考時間」は大幅に短縮されます。\'AIのプレイスタイル\' オプション内の多くの設定も上書きされるでしょう、なぜならデータベースの結果が最優先されるからです。\n\nこの完璧なデータベースを最大限に活用する方法については、こちらをクリックしてください。';

  @override
  String get backgroundImage => '背景画像';

  @override
  String get whatIsRandom =>
      '「完璧なデータベースを使用する」というオプションが有効になっていない場合、「ランダム」という設定によってAIは、手の選択のためのアルゴリズムを使用せずに駒をランダムに動かします。これは通常、かなり弱いゲームプレイをもたらします。逆に、「完璧なデータベースを使用する」が有効になると、AIは従来のAIアルゴリズムと組み合わせるのではなく、「完璧なデータベース」だけに完全に依存して意思決定を行います。このモードでは、AIの手は完全にデータベースの内容に基づいており、リアルタイムの計算や検索アルゴリズムには依存しません。';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      '相手の手札からコマを取り除く。その後、相手の手番になる。';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      '配置フェーズ中にミル（縦・横・斜め3つ並び）を作るとき';

  @override
  String get removeOpponentsPieceFromBoard => 'ボードから相手のコマを取り除く。';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'ボードから相手のコマを取り除く。その後、相手の手番になる。';

  @override
  String get opponentRemovesOwnPiece => '相手が自らボードから自分のコマを取り除く。';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      '自分がアクションを起こす代わりに、相手が自らコマを選び、ボードから取り除くことで、結果的に自分に不利なアクションを起こす。';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      '相手の手札からコマを取り除く。その後、自分の手番になる。';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      '相手の手札からコマを取り除く。マルチ除去の設定に従い、複数のコマを取り除く必要がある場合で、相手の手札にコマが残っていない場合は、ボードから相手のコマを取り除き続ける。その後、自分の手番になる。ミルを作り続けることができれば、相手のコマを取り除き続けられる。';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      '相手の手札からコマを取り除く。マルチ除去の設定に従い、複数のコマを取り除く必要がある場合で、相手の手札にコマが残っていない場合は、ボードから相手のコマを取り除き続ける。その後、相手の手番になる。';

  @override
  String get markAndDelayRemovingPieces => 'コマの取り除きをマークして遅延させる。';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      '配置フェーズの間、取り除かれるコマにはマークが付けられ、両方のプレイヤーはこれらのポイントに新しいコマを配置できなくなる。移動フェーズに入ると、マークされたコマはすべて取り除かれ、プレイヤーはその空いたポイントにコマを移動できるようになる。';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      '配置フェーズでミルを形成する際に取ることができるアクション。';

  @override
  String get marked => 'マークされた';

  @override
  String get menu => 'メニュー';

  @override
  String get monochrome => '黒と白';

  @override
  String get youCanEnableScreenReaderSupport =>
      '一般設定のアクセシビリティ設定でスクリーンリーダーサポートをオンにすることができます。';

  @override
  String get showNumbersOnPieces => '駒に番号を表示';

  @override
  String get saveImage => '画像を保存';

  @override
  String get isAnalysisToolbarShown => '解析ツールバーを表示する';

  @override
  String get analysisToolbarBackgroundColor => '解析ツールバーの背景色';

  @override
  String get analysisToolbarIconColor => '解析ツールバーのアイコンの色';

  @override
  String get transformed => '変換されました。';

  @override
  String get cannotTransform => '変換できません。';

  @override
  String get rotate => '回転';

  @override
  String get horizontalFlip => '横反';

  @override
  String get verticalFlip => '縦反';

  @override
  String get innerOuterFlip => '内外反';

  @override
  String get transparentCanvas => '透明キャンバス';

  @override
  String get restrictRepeatedMillsFormation => '繰り返しミル形成の制限';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      '一つのミルから別のミルを形成するために移動した駒は、次のターンで元の点にすぐに戻って再びミルを形成することはできません。まず別の動きが必要です。';

  @override
  String get oneTimeUseMill => '一度限り使用できるミル';

  @override
  String get oneTimeUseMill_Detail =>
      '各ミルは対戦相手のピースを一度だけ取り除くことができます。再形成することはできますが、追加の除去には使用できません。';

  @override
  String get currentRulesNoPerfectDatabase =>
      '設定した現在のルールには、対応する完全なデータベースがありません。完全なデータベースの詳細については、ここをクリックしてください。';

  @override
  String get focusOnBlockingPaths => 'ブロッキングパスに集中する';

  @override
  String get focusOnBlockingPaths_Detail =>
      'ミルの形成よりも対戦相手の動きを妨害することを優先します。ミルを完成させてピースを取り除くことに焦点を当てるのではなく、AIは対戦相手を罠にかけ、動けなくして、攻撃的なプレイではなく消耗戦を通じて勝利を確保します。この戦略は、対戦相手のミルを積極的にブロックするものではありません。';

  @override
  String get pieceImage => '駒の画像';

  @override
  String get importColorSettings => 'カラー設定をインポート';

  @override
  String get exportColorSettings => 'カラー設定をエクスポート';

  @override
  String get import => 'インポート';

  @override
  String get export => 'エクスポート';

  @override
  String get pleaseCopyJsonToClipboard => '最初に JSON 形式の設定をクリップボードにコピーしてください。';

  @override
  String get copiedToClipboard => 'クリップボードにコピーされました。';

  @override
  String get imported => 'インポートされました。';

  @override
  String get boardImage => 'ボード画像';

  @override
  String get autumnLeaves => '秋の葉';

  @override
  String get legendaryLand => '伝説の地';

  @override
  String get vignetteEffect => 'ビネット効果';

  @override
  String get promptMakeToolbarTransparent =>
      'ボードの背景画像が設定されたときに、ツールバーを完全に透明にしますか？';

  @override
  String get vibration => 'ゲーム内でバイブレーションを有効にする';

  @override
  String get soundTheme => 'サウンドテーマ';

  @override
  String get ball => 'ボール';

  @override
  String get liquid => '液体';

  @override
  String get wood => '木';

  @override
  String get placeEffectAnimation => '駒を置くアニメーション効果';

  @override
  String get removeEffectAnimation => '駒を取り除くアニメーション効果';

  @override
  String get isToolbarAtBottom => 'ツールバーを下部に表示';

  @override
  String get boardCornerRadius => 'ボードの角の半径';

  @override
  String get useOpeningBook => 'オープニングブックを使用する';

  @override
  String get currentRule => '現在のルール';

  @override
  String get nineMensMorris => 'ナイン・メンズ・モリス';

  @override
  String get twelveMensMorris => 'トゥエルブ・メンズ・モリス';

  @override
  String get morabaraba => 'モラバラバ';

  @override
  String get dooz => 'ドゥズ';

  @override
  String get chamGonu => '朝鮮モリス';

  @override
  String get zhiQi => '中国モリス (ジーチー)';

  @override
  String get chengSanQi => '中国モリスバリエーション 1 (チェンサンチー)';

  @override
  String get mulMulan => 'インドネシアモリス';

  @override
  String get nerenchi => 'スリランカモリス';

  @override
  String get ruleSet => 'ルールセット';

  @override
  String get laskerMorris => 'ラスカー・モリス';

  @override
  String get oneTimeMill => 'ワンタイムミル';

  @override
  String get daSanQi => '中国モリスバリエーション 2 (ダーサンチー)';

  @override
  String get useOpeningBook_Detail =>
      '初期ゲームでプロの人間プレーヤーが一般的に使用するオープニングムーブをAIが使用するようにします。注: この機能は現在、特定のルールセットでのみ利用可能です。';

  @override
  String get showAdvantageGraph => '有利グラフを表示';

  @override
  String get advantageGraphHint =>
      '有利度グラフはAIが手を打った後にのみ描画されます。人間のプレイヤーが手を打つときには描画されません。';

  @override
  String get removalBasedOnMillCounts =>
      'すべての駒が配置されるまで駒の除去を無効にします。プレイヤーはミルの数に基づいて駒を取り除きます。';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'すべての駒が配置されるまで駒の除去を無効にします。プレイヤーはミルの数に基づいて駒を取り除きます。同数であれば、両者は同じ数の駒を取り除きます。一方が多い場合は、一つ余分に取り除き、駒の差を一つに保ちます。一方のみがミルを形成した場合、そのプレイヤーは二つの駒を取り除き、もう一方は一つの駒を取り除きます。どちらもミルを形成しない場合は、両者とも一つずつ取り除きます。';

  @override
  String get elfilja => 'エル・フィルジャ';

  @override
  String get tipSelectOwnPiece => '自分のコマを1つ選んでください。';

  @override
  String get notYourTurn => 'あなたのターンではありません。';

  @override
  String get annotationToolbarBackgroundColor => '注釈ツールバーの背景色';

  @override
  String get annotationToolbarIconColor => '注釈ツールバーのアイコン色';

  @override
  String get isAnnotationToolbarShown => '注釈ツールバーを表示';

  @override
  String get enterAnnotationMode => '注釈モードに入る';

  @override
  String get areYouSureYouWantToClearAllAnnotations => 'すべての注釈をクリアしてもよろしいですか？';

  @override
  String get llmPromptCopiedToClipboard => 'LLMプロンプトがクリップボードにコピーされました。';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      '接続が拒否されました。サーバーがダウンしている可能性があります。';

  @override
  String get discoverySuccessfulAwaitingConnection => '検出に成功しました。接続を待機中...';

  @override
  String get noLanConnection => 'LAN接続がありません';

  @override
  String get takeScreenshot => 'スクリーンショットを撮る';

  @override
  String get disconnectedFromOpponent => '対戦相手との接続が切断されました。';

  @override
  String get takeBackRequest => '「待った」の要求';

  @override
  String get nothingToShow => '表示するものがありません。';

  @override
  String get stopHosting => 'ホスティングを停止';

  @override
  String get connectionResetByPeer => 'ピアによって接続がリセットされました。';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'ハートビートタイムアウトにより接続が失われました。再接続してください。';

  @override
  String get startHosting => 'ホスティングを開始';

  @override
  String get restartRequestRejected => '再起動リクエストが拒否されました。';

  @override
  String get notConnectedToLanOpponent => 'LANの対戦相手に接続されていません。';

  @override
  String get llmPrompt => 'LLMプロンプト';

  @override
  String get gameRestarted => 'ゲームをやり直しました。';

  @override
  String get takeBackRejected => '「待った」は拒否されました。';

  @override
  String get areYouSureYouWantToResignThisGame => 'このゲームを投了しますか？';

  @override
  String get opponentResignedYouWin => '相手が投了しました。あなたの勝ちです！';

  @override
  String get clearAllAnnotations => 'すべての注釈をクリア';

  @override
  String get connectedWaitingForOpponentSMove => '接続されました。対戦相手の動きを待っています...';

  @override
  String get networkStatusDisconnected => 'ネットワークステータス：切断';

  @override
  String get takeBackRequestSentToTheOpponent => '「待った」の要求を相手に送信しました。';

  @override
  String get theOpponentMayHaveLeftTheGame => '対戦相手がゲームを離れた可能性があります';

  @override
  String get connectedToHostSuccessfully => 'ホストに正常に接続しました。';

  @override
  String get connectionLostHeartbeatTimeout => '接続が失われました：ハートビートタイムアウト';

  @override
  String get noHostDiscovered => 'ホストが見つかりませんでした。';

  @override
  String get confirmResignation => '投了の確認';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'ゲームのホスティングを開始しました。プレイヤーの参加を待っています...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      '接続がタイムアウトしました。ネットワーク接続が不安定です。';

  @override
  String get noLlmPromptAvailable => 'LLMプロンプトが利用できません。';

  @override
  String get youResignedGameOver => 'あなたが投了しました。ゲームオーバー。';

  @override
  String get serverIp => 'サーバーIP';

  @override
  String get confirmClear => 'クリアの確認';

  @override
  String get opponentSTurn => '対戦相手のターン。';

  @override
  String get waitingAClientConnection => 'クライアントの接続を待っています...';

  @override
  String get takeBackRequestWasRejectedOrFailed => '「待った」の要求は拒否されたか、失敗しました。';

  @override
  String get addText => 'テキストを追加';

  @override
  String get exitAnnotationMode => '注釈モードを終了';

  @override
  String get typeYourAnnotation => '注釈を入力してください';

  @override
  String get attemptingToReconnect => '再接続を試みています...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      '再起動リクエストが送信されました。対戦相手の応答を待っています...';

  @override
  String get serverIsStopped => 'サーバーが停止しています。';

  @override
  String get restartRequest => '再起動リクエスト';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      '自分の手番でない時に「待った」はできません。';

  @override
  String get takeBackAccepted => '「待った」が承認されました。';

  @override
  String get localNetworkSettings => 'ローカルネットワーク設定';

  @override
  String get reconnectedSuccessfully => '再接続に成功しました！';

  @override
  String get failedToSaveImageToGallery => 'ギャラリーに画像を保存できませんでした。';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      '対戦相手がゲームの再起動をリクエストしました。受け入れますか？';

  @override
  String get yourTurn => 'あなたのターン。';

  @override
  String get unableToReconnectPleaseRestartTheGame => '再接続できません。ゲームを再起動してください。';

  @override
  String get host => 'ホスト';

  @override
  String get join => '参加';

  @override
  String get port => 'ポート';

  @override
  String get invalidIpAddress => '無効なIPアドレス。';

  @override
  String get invalidPort => '無効なポート。';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return '接続中: 試行 $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return '接続に失敗しました: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'ホスティングの開始に失敗しました: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'ホストが見つかりました: $ip:$port';
  }

  @override
  String get stop => '停止';

  @override
  String get discover => '検出';

  @override
  String get connect => '接続';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'クライアントが接続しました: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return '検出中: $seconds 秒';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return '再接続中 ($attempt/$maxAttempts)';
  }

  @override
  String get connected => '接続済み';

  @override
  String get delete => '削除';

  @override
  String get ancientEgypt => '洛霞';

  @override
  String get gothicIce => '氷紋縹';

  @override
  String get riceField => '里海霧';

  @override
  String get chinesePorcelain => '九谷雅';

  @override
  String get desertDusk => '砂暮焔';

  @override
  String get precisionCraft => '金糸細工';

  @override
  String get folkEmbroidery => '民芸絵';

  @override
  String get carpathianHeritage => '山姥遺産';

  @override
  String get imperialGrandeur => '紫宸輝';

  @override
  String get bohemianCrystal => '江戸切子光';

  @override
  String get savannaSunrise => '野焼原';

  @override
  String get harmonyBalance => '調和は鏡';

  @override
  String get cinnamonSpice => '木蘭香';

  @override
  String get anatolianMosaic => '螺鈿瑍';

  @override
  String get carnivalSpirit => '祭嵐';

  @override
  String get custom => 'カスタム';

  @override
  String get spiceMarket => '唐辛子市';

  @override
  String get swipeToRevealTheDrawer => 'スワイプしてドロワーを表示';

  @override
  String get showGameInfoOnScreenshots => 'スクリーンショットにゲーム情報を表示';

  @override
  String get humanMoveTime => '人間の制限時間';

  @override
  String get noTimeLimitForHumanMoves => '人間の手番に時間制限はありません';

  @override
  String get timeoutLoseWillBeApplied => '人間プレイヤーには時間切れによる負けが適用されます';

  @override
  String get identifyingBoard => '盤面を認識しています…';

  @override
  String get youCanEnterAnyModelName => '任意のモデル名を入力できます。';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      '盤面の配置を適用しました。FEN がクリップボードにコピーされました。';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      '提案：盤面の写真をもっと鮮明に撮影してみてください。';

  @override
  String get llmPromptTemplate => 'LLM プロンプト テンプレート';

  @override
  String get noValidBoardDetected => '有効な盤面が検出されませんでした。';

  @override
  String get selectingImageFromAlbum => 'アルバムから画像を選択中…';

  @override
  String get configurePromptTemplate => 'プロンプト テンプレートを設定';

  @override
  String get editPromptTemplateForLlmAnalysis => 'LLM 分析のためのプロンプト テンプレートを編集';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      '認識した盤面から FEN の生成に失敗しました。';

  @override
  String get outputInCurrentLanguage => '現在の言語で出力';

  @override
  String get commonBaseUrls => '一般的な Base URL';

  @override
  String get viewCommonModels => 'よく使われるモデルを見る';

  @override
  String get recognitionParametersUpdated => '認識パラメータが更新されました。';

  @override
  String get whiteSMove => '白の手番';

  @override
  String get resetToDefaults => 'デフォルトにリセット';

  @override
  String get photoShoot => '写真撮影';

  @override
  String get failedToApplyRecognizedBoardPosition => '認識した盤面配置の適用に失敗しました。';

  @override
  String get llmPromptContent => 'LLM プロンプト内容';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM が設定されていません。設定を確認してください。';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'プロバイダー、モデル、API Key、Base URL を設定';

  @override
  String get llmConfiguration => 'LLM 設定';

  @override
  String get configureLlmProvider => 'LLM プロバイダーを設定';

  @override
  String get llmPromptTemplateHeader => 'LLM プロンプト テンプレート ヘッダー';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      '画像から駒が認識されませんでした。もう一度お試しください。';

  @override
  String get recognizeBoardFromImage => '画像から盤面を認識';

  @override
  String get viewTips => 'ヒントを見る';

  @override
  String get applyToBoard => '盤面に適用';

  @override
  String get adjustBoardArea => '盤面領域を調整';

  @override
  String get viewCommonUrls => '一般的な URL を表示';

  @override
  String get colorAnalysisFailed => '色解析に失敗しました！';

  @override
  String get analyzingGameBoardImage => '盤面画像を解析中…';

  @override
  String get selectFromAlbum => 'アルバムから選択';

  @override
  String get noBoardPointDetected => '盤面のポイントが検出されませんでした！';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      '未入力の場合はデフォルトテンプレートが使用されます';

  @override
  String get llmConfig => 'LLM 設定';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'プロンプト テンプレートをデフォルト値にリセットしてもよろしいですか？';

  @override
  String get llmPromptTemplateFooter => 'LLM プロンプト テンプレート フッター';

  @override
  String get loadingResponse => '応答を読み込み中…';

  @override
  String get applyThisResultToBoard => 'この結果を盤面に適用';

  @override
  String get takingPicture => '撮影中…';

  @override
  String get pleaseSelectAGameBoardImageToIdentify => '識別する盤面画像を選択してください';

  @override
  String get identificationResults => '識別結果';

  @override
  String get analyzeTheMovesAndProvideInsights => '手順を分析し、洞察を提供します。';

  @override
  String get getApiKey => 'API Key を取得';

  @override
  String get entireRecognitionProcessFailedToComplete => '認識プロセス全体の完了に失敗しました。';

  @override
  String get boardRecognitionResult => '盤面認識の結果';

  @override
  String get askLlm => 'LLM に質問';

  @override
  String get boardDetectionFailed => '盤面の検出に失敗しました！';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      '盤面ポイントが検出されず、駒を特定できません！';

  @override
  String get copyFen => 'FEN をコピー';

  @override
  String get commonlyUsedModels => 'よく使用されるモデル';

  @override
  String get apiKeyOptional => 'API Key（オプション）';

  @override
  String get noImageSelected => '画像が選択されていません';

  @override
  String get blackSMove => '黒の手番';

  @override
  String get llm => '大規模言語モデル';

  @override
  String get llmProvider => 'プロバイダー';

  @override
  String get baseUrl => 'ベースURL';

  @override
  String get model => 'モデル';

  @override
  String get temperature => '温度';

  @override
  String get llmCommandReceivedProcessing => 'コマンドを受信しました！ AIが処理中です...';

  @override
  String get llmDeepThinkingWait => '深い思考を進行中です。しばらくお待ちください...';

  @override
  String get llmPresentingSoon => 'まもなく表示します...';

  @override
  String get recognitionParameters => '認識パラメータ';

  @override
  String get adjustParamsDesc => '認識精度を向上させるためにパラメータを調整します';

  @override
  String get saveParameters => 'パラメータを保存';

  @override
  String unableToStartImageRecognition(String error) {
    return '画像認識を開始できません: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return '画像認識に失敗しました: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return '$whiteCount 個の白石と $blackCount 個の黒石で配置を適用しました';
  }

  @override
  String get fenCopiedToClipboard => '（FEN をクリップボードにコピーしました）';

  @override
  String recognitionFailed(String error) {
    return '認識に失敗しました: $error';
  }

  @override
  String get myRating => '自分のレーティング';

  @override
  String get gamesPlayed => 'プレイしたゲーム数';

  @override
  String get wins => '勝利数';

  @override
  String get losses => '敗北数';

  @override
  String get draws => '引き分け数';

  @override
  String get lastUpdated => '最終更新';

  @override
  String get format => '形式:';

  @override
  String get resetStatistics => '統計をリセット';

  @override
  String get drawRate => '引き分け率';

  @override
  String get lossRate => '敗北率';

  @override
  String get aiStatistics => 'AI統計';

  @override
  String get enableStatistics => '統計を有効にする';

  @override
  String get enableStatistics_Detail =>
      '有効にすると、ゲーム結果が統計に記録されます。ただし、待ったを含むゲームは記録されません。無効にすると、統計の収集は一時停止されます。';

  @override
  String get thisWillResetAllGameStatistics =>
      'これにより、すべてのゲーム統計がリセットされます。この操作は元に戻せません。';

  @override
  String get boardInnerRingSize => '盤の内側リングのサイズ';

  @override
  String get boardShadowEnabled => 'ボードの影';

  @override
  String get trapAwareness => '罠認識';

  @override
  String get trapAwarenessDescription => '解析中に太い円と矢印で罠の手を強調表示する。';

  @override
  String trapExists(String trapMoves) {
    return '罠が存在します。罠の手: $trapMoves';
  }

  @override
  String get custodianCapture => '隣接するキャプチャ';

  @override
  String get custodianCaptureDescription => '対戦相手のピースの1つを直線で囲み、それをキャプチャします。';

  @override
  String get custodianCaptureEnable => '隣接キャプチャを許可します';

  @override
  String get interventionCapture => '介入キャプチャ';

  @override
  String get interventionCaptureDescription =>
      '相手の2つのピースの間の空のポイントに移動して、両方をキャプチャします。';

  @override
  String get interventionCaptureEnable => '介入キャプチャを許可します';

  @override
  String get leapCapture => 'ジャンプキャプチャ';

  @override
  String get leapCaptureDescription => '隣接する相手のピースを飛び越えて、向こうの空のポイントにキャプチャします。';

  @override
  String get leapCaptureEnable => 'ジャンプキャプチャを許可します';

  @override
  String get captureApplicableLines => '該当する行';

  @override
  String get captureSquareEdges => '正方形の端に沿って';

  @override
  String get captureCrossLines => '正方形を横切る直交線に沿って';

  @override
  String get captureDiagonalLines => '正方形を横切る斜めの線に沿って';

  @override
  String get captureExecutionPhases => '実行フェーズ';

  @override
  String get capturePiecesCondition => '残りのピースに基づく移動段階での可用性';

  @override
  String get capturePiecesConditionUnlimited => '制限なし';

  @override
  String get capturePiecesConditionSelfLeqThree => '3つ以下のピースがある場合に利用できます';
}
