// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Italian (`it`).
class SIt extends S {
  SIt([String locale = 'it']) : super(locale);

  @override
  String get appName => 'Mulino';

  @override
  String get welcome => 'Benvenuto';

  @override
  String get yes => 'Sì';

  @override
  String get no => 'No';

  @override
  String get game => 'Gioco';

  @override
  String get humanVsAi => 'Umano Vs AI';

  @override
  String get humanVsHuman => 'Umano contro umano';

  @override
  String get aiVsAi => 'AI contro AI';

  @override
  String get humanVsCloud => 'Umano contro Cloud';

  @override
  String get humanVsLAN => 'Umano contro LAN';

  @override
  String get testViaLAN => 'Test via LAN';

  @override
  String get move => 'Spostare';

  @override
  String get showMoveList => 'Elenco mosse';

  @override
  String get moveList => 'Lista dei movimenti';

  @override
  String get noGameRecord => 'Nessun record';

  @override
  String get ok => 'OK';

  @override
  String get confirm => 'Conferma';

  @override
  String get cancel => 'Annulla';

  @override
  String get tipSelectWrong => 'Seleziona il pezzo sbagliato.';

  @override
  String get tipPlace => 'Posiziona i tuoi pezzi.';

  @override
  String get tipBanPlace => 'Non è possibile posizionarlo qui.';

  @override
  String get tipPlaced => 'Posizionato.';

  @override
  String get tipRemove => 'Rimuovi un pezzo.';

  @override
  String get tipBanRemove => 'Non può essere rimosso.';

  @override
  String get tipRemoved => 'Rimosso.';

  @override
  String get tipMove => 'Sposta un pezzo.';

  @override
  String get tipCannotPlace => 'Non puoi piazzare il tuo pezzo qui.';

  @override
  String get tipCannotMove => 'Non puoi spostare il tuo pezzo qui.';

  @override
  String get tipMill => 'Mulino! Rimuovete un pezzo dell\'avversario.';

  @override
  String get tipContinueMill =>
      'Continuate a prendere il pezzo del vostro avversario.';

  @override
  String get tipSelectOpponentsPiece =>
      'Scegliete uno dei pezzi del vostro avversario.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Non è possibile rimuovere un pezzo da un mulino.';

  @override
  String get tipCanMoveOnePoint => 'Un pezzo può muovere di 1 punto.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Non potete muovere i pezzi del vostro avversario.';

  @override
  String get tipSelectPieceToMove => 'Selezionate il vostro pezzo da muovere.';

  @override
  String get tipHaveThreePiecesLeft => 'Vi rimangono 3 pezzi.';

  @override
  String get tipCanMoveToAnyPoint =>
      'Potete muovere in qualsiasi punto vogliate.';

  @override
  String tipToMove(Object player) {
    return '$player per muoversi.';
  }

  @override
  String get whiteWin => 'Il giocatore 1 vince!';

  @override
  String get blackWin => 'Il giocatore 2 vince!';

  @override
  String get won => 'Vinto';

  @override
  String get lost => 'Perso';

  @override
  String get thinking => 'Pensare…';

  @override
  String get newGame => 'Nuovo gioco';

  @override
  String get importGame => 'Importazione gioco';

  @override
  String get exportGame => 'Esportazione gioco';

  @override
  String get gameImported => 'Gioco importato.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Impossibile importare $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'Le mosse e le regole non corrispondono.';

  @override
  String get pleaseWait => 'Si prega di attendere...';

  @override
  String get restartGame => 'Riavviare il gioco attuale?';

  @override
  String get restart => 'Riavvia';

  @override
  String get gameStarted => 'Gioco iniziato, si prega di posizionare.';

  @override
  String get analyzing => 'Analisi…';

  @override
  String error(Object message) {
    return 'Errore: $message';
  }

  @override
  String get winRate => 'Tasso di vittoria';

  @override
  String get score => 'Punteggio:';

  @override
  String get white => 'Giocatore 1';

  @override
  String get black => 'Giocatore 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player il conteggio dei pezzi è inferiore a tre.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player si è arreso.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player non ha mosse disponibili.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Il tabellone è pieno e $player non ha modo di andare.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Il tempo è finito, $player ha perso.';
  }

  @override
  String get drawReasonRule50 =>
      'Nella fase di movimento, nessun pezzo è stato rimosso nell\'ultimo numero specifico di mosse.';

  @override
  String get drawReasonBoardIsFull =>
      'È una patta perché la scacchiera è piena.';

  @override
  String get drawReasonThreefoldRepetition =>
      'È un pareggio a causa della triplice ripetizione.';

  @override
  String get gameOverUnknownReason => 'Game Over! Ragione sconosciuta.';

  @override
  String get gameOver => 'Gioco finito';

  @override
  String get youWin => 'Hai vinto! Congratulazioni!';

  @override
  String challengeHarderLevel(int level) {
    return 'Sfida livello più difficile? Il nuovo livello sarà il livello $level!';
  }

  @override
  String get youLose => 'Hai perso!';

  @override
  String get analyze => 'Analizza';

  @override
  String get about => 'Informazioni su';

  @override
  String version(Object versionNumber) {
    return 'Versione: $versionNumber';
  }

  @override
  String get thanks => 'Grazie';

  @override
  String get settings => 'Impostazioni';

  @override
  String get options => 'Opzioni';

  @override
  String get generalSettings => 'Impostazioni generali';

  @override
  String get skillLevel => 'Livello di difficoltà';

  @override
  String get moveTime => 'Tempo di riflessione dell\'IA';

  @override
  String get difficulty => 'Difficoltà';

  @override
  String get playSounds => 'Effetti sonori';

  @override
  String get playSoundsInTheGame => 'Riprodurre suoni nel gioco';

  @override
  String get keepMuteWhenTakingBack => 'Mantenere il muto quando si riprende';

  @override
  String get tone => 'Tono';

  @override
  String get whoMovesFirst => 'Prima mossa';

  @override
  String get human => 'Umano';

  @override
  String get ai => 'AI';

  @override
  String get alternate => 'Alternare';

  @override
  String get isAutoRestart =>
      'Riavvio automatico del gioco al termine della partita';

  @override
  String get isAutoChangeFirstMove => 'Cambio automatico della prima mossa';

  @override
  String get shufflingEnabled => 'Mossa casuale';

  @override
  String get misc => 'Varie';

  @override
  String get rules => 'Regole';

  @override
  String get piecesCount => 'Il numero di pezzi che ogni giocatore ha';

  @override
  String get piecesCount_Detail => 'Quanti pezzi ha ogni giocatore?';

  @override
  String get flyPieceCount => 'Il numero del pezzo volante';

  @override
  String get flyPieceCount_Detail =>
      'Se Volare è abilitato, quando un giocatore è ridotto a un determinato numero di pezzi, i suoi pezzi sono liberi di muoversi verso qualsiasi punto non occupato, invece di essere limitati ai punti adiacenti come nel resto del gioco.';

  @override
  String get piecesAtLeastCount => 'Pezzi al minimo';

  @override
  String get hasDiagonalLines => 'Linee diagonali';

  @override
  String get hasDiagonalLines_Detail =>
      'Aggiungi quattro linee diagonali alla scacchiera.';

  @override
  String get isDefenderMoveFirst => 'Il secondo giocatore muove per primo';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Il giocatore che muove per secondo nella fase di piazzamento muove per primo nella fase di spostamento.';

  @override
  String get mayRemoveMultiple => 'Multi-rimozione';

  @override
  String get mayRemoveMultiple_Detail =>
      'Se un giocatore chiude più di un mulino alla volta, potrà rimuovere il numero di mulini che ha chiuso.';

  @override
  String get mayRemoveFromMillsAlways => 'Distruggere i mulini';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Per impostazione predefinita, i giocatori devono rimuovere qualsiasi altro pezzo prima di rimuovere un pezzo da un mulino formato. Abilita questa opzione per disabilitare la limitazione.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Il secondo giocatore perde quando il tabellone è pieno';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Alla fine della fase di piazzamento, quando la scacchiera è piena, il lato che piazza per primo perde la partita, altrimenti la partita è un pareggio.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Perdere quando non ci sono mosse legali';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Il giocatore perde se il suo avversario lo blocca in modo che non possa essere mosso. Cambia lato per muovere se questa opzione è disabilitata.';

  @override
  String get mayFly => 'Volare';

  @override
  String get mayFly_Detail =>
      'Se un giocatore ha solo tre o quattro pezzi (configurabili) rimasti, può spostare il pezzo in qualsiasi punto libero.';

  @override
  String get nMoveRule => 'Regola delle N mosse';

  @override
  String get nMoveRule_Detail =>
      'La partita è patta se non c\'è stata alcuna rimozione in un determinato numero di mosse da parte di ciascun giocatore.';

  @override
  String get rollback => 'Replica';

  @override
  String get pleaseSelect => 'Selezionare';

  @override
  String get copy => 'Copia';

  @override
  String get moveHistoryCopied => 'Storia delle mosse copiata negli appunti.';

  @override
  String get help => 'Aiuto';

  @override
  String get feedback => 'Risposta';

  @override
  String get exit => 'Esci';

  @override
  String get ruleSettings => 'Regole';

  @override
  String get color => 'Colore';

  @override
  String get boardColor => 'Colore della scheda';

  @override
  String get pieceColor => 'Colore del pezzo';

  @override
  String get backgroundColor => 'Colore dello sfondo';

  @override
  String get lineColor => 'Colore della linea del tabellone';

  @override
  String get whitePieceColor => 'Colore del pezzo del giocatore 1';

  @override
  String get blackPieceColor => 'Colore del pezzo del giocatore 2';

  @override
  String get messageColor => 'Colore del messaggio';

  @override
  String get isPieceCountInHandShown => 'Mostra il conteggio dei pezzi in mano';

  @override
  String get isNotationsShown => 'Mostra le annotazioni sulla tavola';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Mostra la barra di navigazione della storia';

  @override
  String get display => 'Mostra';

  @override
  String get boardBorderLineWidth =>
      'Larghezza della linea di confine della scacchiera';

  @override
  String get boardInnerLineWidth =>
      'Larghezza della linea interna della scacchiera';

  @override
  String get pieceWidth => 'Larghezza del pezzo';

  @override
  String get fontSize => 'Dimensione del carattere';

  @override
  String get standardNotation => 'Notazione WMD';

  @override
  String get restore => 'Ripristinare';

  @override
  String get restoreDefaultSettings => 'Ripristina le impostazioni predefinite';

  @override
  String pick(Object element) {
    return 'Scegli $element';
  }

  @override
  String get info => 'Info';

  @override
  String get hint => 'Suggerimento';

  @override
  String get player => 'giocatore';

  @override
  String get player1 => 'Giocatore 1';

  @override
  String get player2 => 'Giocatore 2';

  @override
  String get howToPlay => 'Come giocare';

  @override
  String get toPlacePiece =>
      'Tocca qualsiasi punto disponibile per posizionare il pezzo.';

  @override
  String get toSelectPiece => 'Tocca un pezzo per spostarlo.';

  @override
  String get toMovePiece => 'Tocca il punto collegato al pezzo per spostarlo.';

  @override
  String get toRemovePiece => 'Tocca un pezzo dell\'avversario per rimuoverlo.';

  @override
  String get needToCreateMillFirst =>
      'È necessario creare un mulino prima di poter rimuovere un pezzo.';

  @override
  String get needToPlayWithOwnPieces => 'Devi giocare con i tuoi pezzi.';

  @override
  String get statistics => 'Statistiche';

  @override
  String get totalGames => 'Totale partite';

  @override
  String get results => 'Risultati';

  @override
  String get left => 'sinistra';

  @override
  String get privacyPolicy => 'Informativa sulla privacy';

  @override
  String get privacyPolicy_Detail_1 =>
      'Si prega di leggere attentamente e assicurarsi di aver compreso e accettato questo ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Se non siete d\'accordo con questa politica, vi preghiamo di non utilizzare questa app. L\'utilizzo dell\'app implica l\'accettazione di questi termini.';

  @override
  String get and => ' e ';

  @override
  String get accept => 'Accetta';

  @override
  String get takeBack => 'Riprendere';

  @override
  String get takingBack => 'Riprendere…';

  @override
  String get waiting => 'Aspettare…';

  @override
  String get stepForward => 'Passi avanti';

  @override
  String get takeBackAll => 'Riprendere tutto';

  @override
  String get stepForwardAll => 'Fare un passo avanti tutti';

  @override
  String get moveNow => 'Muoversi ora';

  @override
  String get done => 'Fatto.';

  @override
  String get crackMill => 'Crepa-mill';

  @override
  String get crackMill_Detail =>
      'Se un giocatore ha solo pezzi nei mulini, i pezzi nei mulini non si bloccano per rimuovere.';

  @override
  String get animationDuration => 'Durata dell\'animazione';

  @override
  String get none => 'Nessuna';

  @override
  String get theme => 'Tema';

  @override
  String get helpContent =>
      'Il gioco mira a lasciare l\'avversario con meno di tre pezzi o senza mosse legali.\n\nLa partita viene automaticamente sorteggiata se una posizione si verifica per la terza volta, o se non è stata fatta alcuna rimozione nelle ultime 100 mosse (configurabili).\n\nIl gioco procede in tre fasi:\n\n1. Posizionamento dei pezzi sui punti liberi\n2. Spostamento dei pezzi su punti adiacenti\n3. (fase opzionale) Spostare i pezzi in qualsiasi punto libero quando il giocatore è stato ridotto a tre pezzi\n\nPosizionamento di\n\nLa partita inizia con una tavola vuota, che consiste in una griglia con ventiquattro punti. I giocatori a turno piazzano i loro pezzi sui punti liberi fino a quando ogni giocatore ha piazzato tutti i pezzi sulla tavola. Se un giocatore riesce a piazzare tre dei suoi pezzi in linea retta, ha un «mulino» e può rimuovere uno dei pezzi del suo avversario dalla tavola.\n\nIn alcune varianti di regole, i giocatori devono rimuovere qualsiasi altro pezzo prima di rimuovere un pezzo da un mulino formato.\n\nIn alcune varianti di regole, tutti i punti dei pezzi rimossi non possono essere piazzati di nuovo nella fase di piazzamento.\n\nUna volta che tutti i pezzi sono stati usati, i giocatori si muovono a turno.\n\nSpostamento\n\nPer muovere, un giocatore muove uno dei suoi pezzi lungo una linea del tabellone verso un punto adiacente libero. Se non ci riesce, ha perso la partita. Come nella fase di piazzamento, un giocatore che allinea tre dei suoi pezzi su una linea di bordo ha un mulino e può rimuovere uno dei pezzi del suo avversario. Qualsiasi giocatore si riduce a due pezzi e non ha la possibilità di formare nuovi mulini, e quindi perde la partita. Un giocatore può anche perdere con più di tre pezzi se il suo avversario li blocca in modo che non possano essere mossi.\n\nVolare\n\nIn alcune varianti delle regole, una volta che un giocatore ha solo tre pezzi rimasti, i suoi pezzi possono «volare» o «saltare» verso qualsiasi punto libero, non solo quelli adiacenti.\n';

  @override
  String get versionInfo => 'Informazioni sulla versione';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'Licenza';

  @override
  String get sourceCode => 'Codice sorgente';

  @override
  String get appVersion => 'Versione dell\'applicazione';

  @override
  String get general => 'Generale';

  @override
  String get advanced => 'Avanzate';

  @override
  String get placing => 'Posizionare';

  @override
  String get moving => 'Spostamento';

  @override
  String get removing => 'Rimozione';

  @override
  String get gameOverCondition => 'Condizione di game over';

  @override
  String get aisPlayStyle => 'Stile di gioco dell\'IA';

  @override
  String get passive => 'Passivo';

  @override
  String get timeout => 'Tempo scaduto';

  @override
  String get appearance => 'Aspetto esteriore';

  @override
  String get drawOnHumanExperience => 'Attingere all\'esperienza umana';

  @override
  String get considerMobility => 'Considerare la mobilità dei pezzi';

  @override
  String get pieceCount => 'Conteggio dei pezzi:';

  @override
  String inHand(Object player, int count) {
    return '$player in mano: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player a bordo: $count';
  }

  @override
  String get boardTop => 'Sfalsamento della tavola dall\'alto';

  @override
  String get notAIsTurn => 'Non è il turno dell\'IA.';

  @override
  String get aiIsNotThinking => 'L\'IA non sta pensando.';

  @override
  String get atEnd => 'Alla fine della lista delle mosse.';

  @override
  String get tapBackAgainToLeave => 'Tocca di nuovo per uscire.';

  @override
  String get more => 'Più';

  @override
  String get experimental => 'Questa è una caratteristica sperimentale.';

  @override
  String get experiments => 'Esperimenti';

  @override
  String get ossLicenses => 'Licenze open source';

  @override
  String get language => 'Lingua';

  @override
  String get defaultLanguage => 'Lingua predefinita';

  @override
  String get mayMoveInPlacingPhase =>
      'I pezzi possono muoversi nella fase di piazzamento';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Non ci sono fasi di piazzamento e di spostamento distinte, cioè i giocatori possono decidere ad ogni mossa se vogliono piazzare un pezzo sulla tavola o muovere uno dei loro pezzi (finché hanno pezzi rimanenti da piazzare).';

  @override
  String get drawerColor => 'Colore del menu';

  @override
  String get drawerTextColor => 'Colore del testo del menu';

  @override
  String get drawerHighlightItemColor => 'Colore voce evidenziazione menu';

  @override
  String get mainToolbarBackgroundColor =>
      'Colore di sfondo della barra degli strumenti principale';

  @override
  String get mainToolbarIconColor =>
      'Colore dell\'icona della barra degli strumenti principale';

  @override
  String get navigationToolbarBackgroundColor =>
      'Colore di sfondo della barra di navigazione';

  @override
  String get navigationToolbarIconColor =>
      'Colore dell\'icona della barra degli strumenti di navigazione';

  @override
  String get autoHideToolbar =>
      'Nascondi automaticamente la barra degli strumenti';

  @override
  String get toolbarLocationOnScreen =>
      'Posizione della barra degli strumenti sullo schermo';

  @override
  String get top => 'Superiore';

  @override
  String get bottom => 'Parte inferiore';

  @override
  String get center => 'Centro';

  @override
  String get solidColor => 'Tinta unita';

  @override
  String get picture => 'Immagine';

  @override
  String get chooseYourPicture => 'Scegli la tua foto';

  @override
  String get light => 'Chiaro';

  @override
  String get dark => 'Scuro';

  @override
  String get themes => 'Temi';

  @override
  String get currentTheme => 'Tema attuale';

  @override
  String get saveTheme => 'Salva tema';

  @override
  String get showAnalysisGraph => 'Mostra grafico di analisi';

  @override
  String get analysis => 'Analisi';

  @override
  String get saveGame => 'Salva il gioco';

  @override
  String get loadGame => 'Carica gioco';

  @override
  String get setupPosition => 'Posizione di installazione';

  @override
  String get showLegalMoves => 'Mostra mosse legali';

  @override
  String get showLastMove => 'Mostra l\'ultima mossa';

  @override
  String get showArrows => 'Mostra frecce';

  @override
  String get pieces => 'Pezzi';

  @override
  String get showAnalysis => 'Mostra analisi';

  @override
  String get threads => 'Discussioni';

  @override
  String get getInvolved => 'Mettersi in gioco';

  @override
  String get helpImproveTranslate => 'Aiutaci a migliorare la traduzione';

  @override
  String get tutorial => 'Tutorial';

  @override
  String get classicMill => 'Mulino Classico';

  @override
  String get mixedMill => 'Mulino Misto';

  @override
  String get ceylonMill => 'Mulino di Ceylon';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Il mulino può essere rotto e rifatto ripetutamente';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Se un giocatore rompe un mulino per creare immediatamente un nuovo mulino, tale giocatore può riportare tale pezzo all\'incrocio originale nella sua prossima mossa se fa un nuovo mulino.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'La partita è patta se un giocatore ha tre pezzi e dopo dieci mosse nessun giocatore rimuove i pezzi dell\'avversario';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Quando un giocatore ha tre pezzi e nessuno dei due giocatori può rimuovere il pezzo di un avversario entro dieci mosse, la partita è patta.';

  @override
  String get close => 'Chiudere';

  @override
  String get whitePiece => 'pezzo bianco';

  @override
  String get blackPiece => 'pezzo nero';

  @override
  String get emptyPoint => 'Punto vuoto';

  @override
  String get noPoint => 'Nessun punto';

  @override
  String get placingPhase => 'Fase di posizionamento';

  @override
  String get movingPhase => 'Fase in movimento';

  @override
  String get flyingPhase => 'Fase di volo';

  @override
  String sideToMove(Object player) {
    return 'Lato da spostare: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Ultima mossa: $move';
  }

  @override
  String get selected => 'Selezionato';

  @override
  String get accessibility => 'Accessibilità';

  @override
  String get screenReaderSupport => 'Supporto per lettori di schermo';

  @override
  String get isDraw => 'È un pareggio!';

  @override
  String get draw => 'Disegno';

  @override
  String get pieceHighlightColor => 'Colore evidenziazione pezzo';

  @override
  String get algorithm => 'Algoritmo';

  @override
  String get endgameNMoveRule => 'Regola N-Move di fine partita';

  @override
  String get endgameNMoveRule_Detail =>
      'Se uno dei giocatori ha solo tre pezzi e nessuno dei due rimuove un pezzo all\'interno di una mossa specifica, la partita è patta.';

  @override
  String get drawReasonEndgameRule50 =>
      'Entrambi i giocatori hanno solo tre pezzi e nessuno dei due rimuove un pezzo all\'interno di una mossa specifica.';

  @override
  String get threefoldRepetitionRule => 'Triplice regola della ripetizione';

  @override
  String get threefoldRepetitionRule_Detail =>
      'La partita è patta se una posizione si verifica per la terza volta.';

  @override
  String get continueToMakeMove => 'Mulino! Continua a fare una mossa.';

  @override
  String get pointStyle => 'Stile punto';

  @override
  String get pointWidth => 'Larghezza del punto';

  @override
  String get solid => 'Solido';

  @override
  String get hollow => 'Vuoto';

  @override
  String get languageName => 'Italiano';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count movimenti',
      one: '$count movimento',
      zero: 'movimento',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Caricamento non riuscito.';

  @override
  String get filename => 'Nome del file';

  @override
  String get browse => 'Navigare…';

  @override
  String get gameFiles => 'File di gioco';

  @override
  String get gameSavedTo => 'Il gioco viene salvato in';

  @override
  String get empty => 'Vuoto';

  @override
  String get noMove => 'Nessuna mossa.';

  @override
  String get restoredPosition => 'Posizione iniziale ripristinata.';

  @override
  String get clean => 'Pulire';

  @override
  String get cleanedUp => 'Pulito.';

  @override
  String get remove => 'Rimuovere';

  @override
  String get noPiecesCanBeRemoved => 'Nessun pezzo può essere rimosso.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count pieces',
      one: '$count piece',
      zero: 'Piece',
    );
    return '$_temp0 devono essere rimossi.';
  }

  @override
  String placedCount(int count) {
    return 'Posiz. ($count)';
  }

  @override
  String get placedPieceCount =>
      'Conteggio pezzi piazzati nella fase di piazzamento.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'Il giocatore attuale ha piazzato $count.';
  }

  @override
  String get notPlacingPhase => 'Non posizionare la fase, non può cambiarla.';

  @override
  String get paste => 'Incolla';

  @override
  String get pasteDone => 'Incollaggio completato.';

  @override
  String get cannotPaste => 'Impossibile incollare.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Mostra i pezzi non posizionati e rimossi';

  @override
  String get fullScreen => 'A schermo intero';

  @override
  String get reopenToTakeEffect =>
      'Esci e riapri l\'app per rendere effettive le impostazioni.';

  @override
  String get forest => 'foresta';

  @override
  String get desktopImage => 'Immagine del desktop';

  @override
  String get invalidPosition => 'Posizione non valida.';

  @override
  String get shareGIF => 'Condividi GIF';

  @override
  String get pixelRatio => 'Rapporto pixel';

  @override
  String get duration => 'Durata';

  @override
  String get gameScreenRecorder => 'Registratore dello schermo di gioco';

  @override
  String get previous => 'Precedente';

  @override
  String get next => 'Prossimo';

  @override
  String get skip => 'Saltare';

  @override
  String get gotIt => 'Fatto';

  @override
  String get youCanModifyRules =>
      'Puoi modificare le regole del gioco nelle impostazioni delle regole.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'È possibile utilizzare la rotellina del mouse per modificare il valore nel selettore.';

  @override
  String get noTimeLimitForThinking =>
      'Tempo di pensiero AI impostato su 0 significa che non c\'è limite di tempo per pensare.';

  @override
  String get whatIsMtdf =>
      'MTD(f) è una forma modificata dell\'algoritmo di ricerca alfa-beta che mira a migliorare l\'efficienza riutilizzando i risultati di ricerca intermedi e utilizzando una buona ipotesi iniziale per restringere lo spazio di ricerca.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Tieni presente che la regolazione del tempo di pensiero dell\'IA potrebbe non essere del tutto precisa. Il tempo di pensiero effettivo può essere più breve quando il livello di difficoltà è impostato su un valore inferiore e può essere più lungo quando l\'IA è a metà pensiero allo scadere del tempo.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Se si imposta il livello di difficoltà alto ma non si aumenta il tempo di riflessione dell\'IA, il livello di difficoltà effettivo potrebbe essere limitato a un valore inferiore a causa del vincolo del tempo di riflessione. Il valore effettivo può variare in base alle prestazioni della macchina.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) è un algoritmo di ricerca per trovare la mossa migliore in una data posizione. È un miglioramento dell\'algoritmo alfa-beta e utilizza ricerche di finestre nulle o nulle per confermare che una mossa è peggiore o non peggiore di un punteggio già sicuro dalla variazione principale. PVS si concentra sulle mosse più promettenti ed evita ricerche non necessarie di rami non ottimali, il che aiuta a migliorare l\'efficienza della ricerca.';

  @override
  String get whatIsAlphaBeta =>
      'L\'algoritmo alpha-beta è un algoritmo di ricerca per trovare la mossa migliore. Utilizza il principio minimax e due valori, alfa e beta, per sfoltire l\'albero di ricerca e aumentare l\'efficienza. Alpha rappresenta il punteggio minimo che il computer è sicuro di poter ottenere, mentre beta rappresenta il punteggio massimo che il suo avversario può ottenere. L\'algoritmo aiuta il computer a prendere decisioni intelligenti ed efficienti in un gioco.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Secondo l\'esperienza umana, se provi a vincere, perderai. Punta invece al pareggio come obiettivo ed evita di perdere la partita. Osserva il tuo avversario e attiralo delicatamente in una posizione in cui potrebbe commettere errori. Quando mostrano debolezza, cogli l\'opportunità e spingi delicatamente per la vittoria. In questo modo, puoi vincere la partita.';

  @override
  String get firstMoveDetail =>
      'In questo gioco, è più facile vincere per il secondo giocatore rispetto al primo giocatore.';

  @override
  String get passiveDetail =>
      'Abilitando l\'opzione Passiva, l\'IA si rilasserà quando ha un vantaggio nella posizione, piuttosto che tentare aggressivamente di vincere il più rapidamente possibile.';

  @override
  String get moveRandomlyDetail =>
      'Abilitare questa opzione aumenta la casualità e il divertimento del gioco mentre disabilitarla può aiutare a studiare modi per battere l\'IA.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Se l\'IA considera la mobilità dei suoi pezzi, non mirerà solo a catturare i pezzi dell\'avversario il più rapidamente possibile, ma considererà anche di bloccare i movimenti dell\'avversario e impedire loro di fare lo stesso.';

  @override
  String get whenBoardIsFull => 'Quando il tabellone è pieno';

  @override
  String get whenBoardIsFull_Detail =>
      'Alla fine della fase di piazzamento, prima che inizi la fase di spostamento, l\'azione segue se la scacchiera è piena di pezzi.';

  @override
  String get sideToMoveRemovePiece =>
      'Il giocatore che muove per primo nella fase di movimento rimuove uno dei pezzi dell\'avversario.';

  @override
  String get agreeToDraw => 'Entrambe le parti accettano un pareggio.';

  @override
  String get takeOpponentsPiece => 'Prendi uno dei pezzi del tuo avversario.';

  @override
  String get firstPlayerLose => 'Il primo giocatore perde la partita.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Il primo e il secondo giocatore rimuovono uno dei pezzi dell\'avversario.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Il secondo e il primo giocatore rimuovono uno dei pezzi dell\'avversario.';

  @override
  String get enteredFlyingPhase =>
      'Entrati ora nella fase di volo, i pezzi dell\'avversario possono saltare in qualsiasi punto vuoto della scacchiera. Puoi disattivare la regola di volo nelle \"Impostazioni regole\".';

  @override
  String get whenStalemate => 'Quando stallo';

  @override
  String get whenStalemate_Detail =>
      'Quale azione segue quando nessun pezzo può essere mosso?';

  @override
  String get endWithStalemateLoss => 'Termina con una perdita di stallo.';

  @override
  String get changeSideToMove => 'Cambia il lato per muoverti.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Rimuovi uno dei pezzi dell\'avversario e fai la mossa successiva.';

  @override
  String get endWithStalemateDraw => 'Termina con un pareggio di stallo.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Rimuovi uno dei pezzi dell\'avversario e cambia il lato da muovere.';

  @override
  String get aiResponseDelayTime => 'Tempo di ritardo della risposta AI';

  @override
  String get aiIsDelaying =>
      'AI è attualmente in una fase di risposta ritardata. Si prega di attendere un po\' prima di procedere.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Non puoi rimuovere un pezzo non adiacente.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'In caso di stallo, i pezzi dell\'avversario adiacenti ai tuoi possono essere rimossi, indipendentemente dalla formazione del mulino.';

  @override
  String get whatIsMcts =>
      'MCTS è un algoritmo adatto ai principianti che prende decisioni esplorando e valutando diverse mosse attraverso simulazioni.';

  @override
  String get goldenJade => 'Giada d\'oro';

  @override
  String get forestWood => 'Legno della foresta';

  @override
  String get darkMystery => 'Mistero oscuro';

  @override
  String get midnightBlue => 'Blu notte';

  @override
  String get greenForest => 'Foresta verde';

  @override
  String get greenMeadow => 'Prato Verde';

  @override
  String get stonyPath => 'Sentiero pietroso';

  @override
  String get pastelPink => 'Rosa pastello';

  @override
  String get turquoiseSea => 'Mare Turchese';

  @override
  String get violetDream => 'Sogno Viola';

  @override
  String get mintChocolate => 'Cioccolato alla menta';

  @override
  String get skyBlue => 'Cielo blu';

  @override
  String get playfulGarden => 'Giardino giocoso';

  @override
  String get whatIsRetrogradeAnalysis =>
      'L\'algoritmo di analisi retrograda utilizza l\'analisi retrograda multivalore per creare un database finale da diverse posizioni di partenza, quindi applica questo database per ottimizzare il gioco. Questo approccio rientra nella categoria delle soluzioni Ultra-Strong.';

  @override
  String get viewAlgorithmGuide =>
      'Vuoi visualizzare la guida per l\'utente di questo algoritmo?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Mostra l\'indicatore del vantaggio di posizione';

  @override
  String get usePerfectDatabase => 'Utilizza il database perfetto';

  @override
  String get perfectDatabaseDescription =>
      'Abilita questa opzione per utilizzare un database di giochi impeccabile generato tramite algoritmi all\'avanguardia. Questa funzionalità integra sia le strategie di apertura che quelle di fine gioco per suggerire le mosse ottimali. Questa è la scelta preferita per i giocatori che cercano il massimo livello di precisione nel gioco. Creato attraverso meticolose tecniche computazionali, il database è progettato per offrire soluzioni di gioco quasi perfette.\n\nNota: se l\'IA non riesce ad accedere al database, si rivolgerà ad algoritmi convenzionali per le decisioni di gioco. Quando il database è disponibile, il \"Livello di difficoltà\" diventa praticamente imbattibile e il \"Tempo di riflessione dell\'IA\" subisce una drastica riduzione. Molte impostazioni all\'interno delle opzioni \"Stile di gioco dell\'IA\" verranno sovrascritte, poiché i risultati del database hanno la massima priorità.\n\nPer indicazioni su come sfruttare al meglio questo database impeccabile, fare clic qui.';

  @override
  String get backgroundImage => 'Immagine di sfondo';

  @override
  String get whatIsRandom =>
      'Quando l\'opzione \"Usa database perfetto\" non è abilitata, l\'impostazione \"Casuale\" fa sì che l\'IA sposti i pezzi in modo casuale senza utilizzare alcun algoritmo per la selezione delle mosse. Ciò in genere si traduce in un gameplay significativamente più debole. Al contrario, quando è abilitato \"Utilizza database perfetto\", l\'intelligenza artificiale si affida esclusivamente al \"database perfetto\" per prendere decisioni, invece di fonderlo con gli algoritmi IA tradizionali. In questa modalità, le mosse dell\'IA sono interamente basate sul contenuto del database, evitando di fare affidamento su calcoli in tempo reale o algoritmi di ricerca.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Rimuovi la pedina (o le pedine) dell\'avversario dalla sua mano; poi è il turno dell\'avversario di piazzare.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Quando si formano mulini durante la fase di piazzamento';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Rimuovi la pedina (o le pedine) dell\'avversario dalla plancia.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Rimuovi la pedina (o le pedine) dell\'avversario dalla plancia; poi è il turno dell\'avversario di piazzare.';

  @override
  String get opponentRemovesOwnPiece =>
      'L\'avversario rimuove la sua pedina (o le sue pedine) dalla plancia.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Invece di farti agire, l\'avversario sceglie e rimuove la propria pedina (o le proprie pedine) dalla plancia, compiendo effettivamente un\'azione che è dannosa per se stesso.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Rimuovi la pedina (o le pedine) dell\'avversario dalla sua mano; poi è il tuo turno di muovere.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Rimuovi la pedina (o le pedine) dalla mano dell\'avversario. Se, in base all\'impostazione di rimozione multipla, è necessario rimuovere più pedine e l\'avversario non ha più pedine in mano, continua a rimuovere le pedine dell\'avversario dalla plancia. Poi è il tuo turno di muovere. Se continui a formare mulini, puoi continuare a rimuovere le pedine dell\'avversario.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Rimuovi la pedina (o le pedine) dalla mano dell\'avversario. Se, in base all\'impostazione di rimozione multipla, è necessario rimuovere più pedine e l\'avversario non ha più pedine in mano, continua a rimuovere le pedine dell\'avversario dalla plancia. Poi è il turno dell\'avversario di muovere.';

  @override
  String get markAndDelayRemovingPieces =>
      'Contrassegna e ritarda la rimozione delle pedine.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Durante la fase di piazzamento, le pedine da rimuovere vengono contrassegnate e, per entrambi i giocatori, nessun nuovo pezzo può essere piazzato su questi punti. All\'inizio della fase di movimento, queste pedine contrassegnate vengono rimosse completamente e i giocatori possono quindi spostare le loro pedine su questi punti ora vuoti.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Le azioni che possono essere intraprese durante la formazione dei mulini nella fase di posizionamento.';

  @override
  String get marked => 'Contrassegnato';

  @override
  String get menu => 'Menu';

  @override
  String get monochrome => 'Monocromatico';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Puoi attivare il supporto per il lettore di schermo nelle impostazioni di Accessibilità nelle Impostazioni generali.';

  @override
  String get showNumbersOnPieces => 'Mostra numeri sui pezzi';

  @override
  String get saveImage => 'Salva immagine';

  @override
  String get isAnalysisToolbarShown =>
      'Mostra barra degli strumenti di analisi';

  @override
  String get analysisToolbarBackgroundColor =>
      'Colore di sfondo della barra degli strumenti di analisi';

  @override
  String get analysisToolbarIconColor =>
      'Colore dell\'icona della barra degli strumenti di analisi';

  @override
  String get transformed => 'Trasformato.';

  @override
  String get cannotTransform => 'Impossibile trasformare.';

  @override
  String get rotate => 'Ruota';

  @override
  String get horizontalFlip => 'Cap. O.';

  @override
  String get verticalFlip => 'Cap. V.';

  @override
  String get innerOuterFlip => 'Cap. I/E';

  @override
  String get transparentCanvas => 'Tela Trasparente';

  @override
  String get restrictRepeatedMillsFormation =>
      'Limita la formazione ripetuta di mulini';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Un pezzo spostato da un mulino per formarne un altro non può immediatamente ritornare al punto originale nel turno successivo per formare di nuovo un mulino. È richiesta prima una mossa diversa.';

  @override
  String get oneTimeUseMill => 'Mulino monouso';

  @override
  String get oneTimeUseMill_Detail =>
      'Ogni mulino può rimuovere un pezzo dell\'avversario una sola volta. Puoi riformarlo di nuovo, ma non può essere utilizzato per rimozioni aggiuntive.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Le regole attuali che hai impostato non hanno un database perfetto corrispondente. Per ulteriori informazioni sul database perfetto, clicca qui.';

  @override
  String get focusOnBlockingPaths => 'Concentrati sul bloccare i percorsi';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Dai priorità all\'ostruzione dei movimenti dell\'avversario piuttosto che alla formazione dei mulini. Invece di concentrarsi sulla rimozione dei pezzi completando i mulini, l\'IA mira a intrappolare l\'avversario, rendendolo incapace di muoversi e garantendo una vittoria per logoramento piuttosto che per gioco aggressivo. Questa strategia non blocca attivamente i mulini dell\'avversario.';

  @override
  String get pieceImage => 'Immagine del pezzo';

  @override
  String get importColorSettings => 'Importa impostazioni colore';

  @override
  String get exportColorSettings => 'Esporta impostazioni colore';

  @override
  String get import => 'Importa';

  @override
  String get export => 'Esporta';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Si prega di copiare prima le impostazioni del formato JSON negli appunti.';

  @override
  String get copiedToClipboard => 'Copiato negli appunti.';

  @override
  String get imported => 'Importato.';

  @override
  String get boardImage => 'Immagine della tavola';

  @override
  String get autumnLeaves => 'Foglie d\'Autunno';

  @override
  String get legendaryLand => 'Terra Leggendaria';

  @override
  String get vignetteEffect => 'Effetto vignettatura';

  @override
  String get promptMakeToolbarTransparent =>
      'Vuoi rendere la barra degli strumenti completamente trasparente quando viene impostata un\'immagine di sfondo della tavola?';

  @override
  String get vibration => 'Attiva la vibrazione nel gioco';

  @override
  String get soundTheme => 'Tema del suono';

  @override
  String get ball => 'Palla';

  @override
  String get liquid => 'Liquido';

  @override
  String get wood => 'Legno';

  @override
  String get placeEffectAnimation =>
      'Effetto animazione di posizionamento pezzo';

  @override
  String get removeEffectAnimation => 'Effetto animazione di rimozione pezzo';

  @override
  String get isToolbarAtBottom => 'Mostra la barra degli strumenti in basso';

  @override
  String get boardCornerRadius => 'Raggio dell\'angolo della tavola';

  @override
  String get useOpeningBook => 'Usa libro di apertura';

  @override
  String get currentRule => 'Corrente';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Insieme di regole';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'One-Time Mill';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'Consenti all\'IA di utilizzare mosse di apertura comunemente impiegate dai giocatori umani professionisti durante le prime fasi del gioco. Nota: questa funzione è attualmente disponibile solo per specifici insiemi di regole.';

  @override
  String get showAdvantageGraph => 'Mostra grafico del vantaggio';

  @override
  String get advantageGraphHint =>
      'Il grafico del vantaggio verrà disegnato solo dopo che l\'IA effettua una mossa. Non verrà disegnato quando il giocatore umano effettua una mossa.';

  @override
  String get removalBasedOnMillCounts =>
      'Disabilita la rimozione finché tutti i pezzi non sono posizionati. I giocatori rimuovono i pezzi in base al numero di mulini formati.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Disabilita la rimozione finché tutti i pezzi non sono posizionati. I giocatori rimuovono i pezzi in base al numero di mulini: se il numero è uguale, entrambi rimuovono lo stesso numero di pezzi; se uno ne ha di più, rimuove un pezzo in più, mantenendo la differenza di un solo pezzo. Se solo uno forma un mulino, rimuove due pezzi mentre l\'altro ne rimuove uno. Se nessuno forma un mulino, entrambi rimuovono un pezzo.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Seleziona uno dei tuoi pezzi.';

  @override
  String get notYourTurn => 'Non è il tuo turno.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Colore di sfondo della barra degli strumenti di annotazione';

  @override
  String get annotationToolbarIconColor =>
      'Colore delle icone della barra degli strumenti di annotazione';

  @override
  String get isAnnotationToolbarShown =>
      'Mostra la barra degli strumenti di annotazione';

  @override
  String get enterAnnotationMode => 'Entra in modalità annotazione';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Sei sicuro di voler cancellare tutte le annotazioni?';

  @override
  String get llmPromptCopiedToClipboard => 'Prompt LLM copiato negli appunti.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Connessione rifiutata, il server potrebbe essere inattivo.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Rilevamento riuscito, in attesa di connessione...';

  @override
  String get noLanConnection => 'Nessuna connessione LAN';

  @override
  String get takeScreenshot => 'Cattura screenshot';

  @override
  String get disconnectedFromOpponent => 'Disconnesso dall\'avversario.';

  @override
  String get takeBackRequest => 'Richiesta di ritiro mossa';

  @override
  String get nothingToShow => 'Niente da mostrare.';

  @override
  String get stopHosting => 'Interrompi hosting';

  @override
  String get connectionResetByPeer => 'Connessione resettata dal peer.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Connessione persa a causa del timeout dell\'heartbeat. Riconnettiti.';

  @override
  String get startHosting => 'Avvia hosting';

  @override
  String get restartRequestRejected => 'Richiesta di riavvio respinta.';

  @override
  String get notConnectedToLanOpponent => 'Non connesso all\'avversario LAN.';

  @override
  String get llmPrompt => 'Prompt LLM';

  @override
  String get gameRestarted => 'Gioco riavviato.';

  @override
  String get takeBackRejected => 'Ritiro mossa respinto.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Sei sicuro di voler abbandonare questa partita?';

  @override
  String get opponentResignedYouWin =>
      'L\'avversario ha abbandonato. Hai vinto!';

  @override
  String get clearAllAnnotations => 'Cancella tutte le annotazioni';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Connesso, in attesa della mossa dell\'avversario...';

  @override
  String get networkStatusDisconnected => 'Stato della rete: Disconnesso';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Richiesta di ritiro mossa inviata all\'avversario.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'L\'avversario potrebbe aver lasciato la partita';

  @override
  String get connectedToHostSuccessfully => 'Connesso all\'host con successo.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Connessione persa: timeout dell\'heartbeat';

  @override
  String get noHostDiscovered => 'Nessun host rilevato.';

  @override
  String get confirmResignation => 'Conferma abbandono';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Avviato hosting del gioco, in attesa che i giocatori si uniscano...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Connessione scaduta, connessione di rete instabile.';

  @override
  String get noLlmPromptAvailable => 'Nessun prompt LLM disponibile.';

  @override
  String get youResignedGameOver => 'Hai abbandonato. Partita terminata.';

  @override
  String get serverIp => 'IP del server';

  @override
  String get confirmClear => 'Conferma cancellazione';

  @override
  String get opponentSTurn => 'Turno dell\'avversario.';

  @override
  String get waitingAClientConnection =>
      'In attesa di una connessione client...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Richiesta di ritiro mossa respinta o fallita.';

  @override
  String get addText => 'Aggiungi testo';

  @override
  String get exitAnnotationMode => 'Esci dalla modalità annotazione';

  @override
  String get typeYourAnnotation => 'Digita la tua annotazione';

  @override
  String get attemptingToReconnect => 'Tentativo di riconnessione...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Richiesta di riavvio inviata. In attesa della risposta dell\'avversario...';

  @override
  String get serverIsStopped => 'Il server è fermo.';

  @override
  String get restartRequest => 'Richiesta di riavvio';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Non puoi richiedere un ritiro mossa quando non è il tuo turno.';

  @override
  String get takeBackAccepted => 'Ritiro mossa accettato.';

  @override
  String get localNetworkSettings => 'Impostazioni di rete locale';

  @override
  String get reconnectedSuccessfully => 'Riconnesso con successo!';

  @override
  String get failedToSaveImageToGallery =>
      'Impossibile salvare l\'immagine nella galleria.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'L\'avversario ha richiesto di riavviare la partita. Accetti?';

  @override
  String get yourTurn => 'Il tuo turno.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Impossibile riconnettersi, riavvia il gioco.';

  @override
  String get host => 'Host';

  @override
  String get join => 'Unisciti';

  @override
  String get port => 'Porta';

  @override
  String get invalidIpAddress => 'Indirizzo IP non valido.';

  @override
  String get invalidPort => 'Porta non valida.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Connessione: Tentativo $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Connessione fallita: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Avvio hosting fallito: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Host rilevato: $ip:$port';
  }

  @override
  String get stop => 'Ferma';

  @override
  String get discover => 'Rileva';

  @override
  String get connect => 'Connetti';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Client connesso: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Rilevamento: $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Riconnessione ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Connesso';

  @override
  String get delete => 'Elimina';

  @override
  String get ancientEgypt => 'Antico Egitto';

  @override
  String get gothicIce => 'Ghiaccio Gotico';

  @override
  String get riceField => 'Campo di Riso';

  @override
  String get chinesePorcelain => 'Porcellana Cinese';

  @override
  String get desertDusk => 'Tramonto del Deserto';

  @override
  String get precisionCraft => 'Artigianato di Precisione';

  @override
  String get folkEmbroidery => 'Ricamo Folkloristico';

  @override
  String get carpathianHeritage => 'Eredità dei Carpazi';

  @override
  String get imperialGrandeur => 'Grandezza Imperiale';

  @override
  String get bohemianCrystal => 'Cristallo Boemo';

  @override
  String get savannaSunrise => 'Alba nella Savana';

  @override
  String get harmonyBalance => 'Armonia ed Equilibrio';

  @override
  String get cinnamonSpice => 'Spezia di Cannella';

  @override
  String get anatolianMosaic => 'Mosaico Anatolico';

  @override
  String get carnivalSpirit => 'Spirito del Carnevale';

  @override
  String get custom => 'Costume';

  @override
  String get spiceMarket => 'Mercato delle spezie';

  @override
  String get swipeToRevealTheDrawer => 'Scorri per mostrare il cassetto';

  @override
  String get showGameInfoOnScreenshots =>
      'Mostra le informazioni di gioco negli screenshot';

  @override
  String get humanMoveTime => 'Limite di tempo umano';

  @override
  String get noTimeLimitForHumanMoves =>
      'Nessun limite di tempo per le mosse umane';

  @override
  String get timeoutLoseWillBeApplied =>
      'La sconfitta per timeout verrà applicata al giocatore umano';

  @override
  String get identifyingBoard => 'Identificazione del tabellone...';

  @override
  String get youCanEnterAnyModelName =>
      'Puoi inserire qualsiasi nome di modello.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Posizione del tabellone applicata. FEN copiata negli appunti.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Suggerimento: prova a scattare una foto più nitida del tabellone.';

  @override
  String get llmPromptTemplate => 'Modello di prompt LLM';

  @override
  String get noValidBoardDetected => 'Nessun tabellone valido rilevato.';

  @override
  String get selectingImageFromAlbum => 'Selezione immagine dall’album...';

  @override
  String get configurePromptTemplate => 'Configura modello di prompt';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Modifica il modello di prompt per l’analisi LLM';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Impossibile generare la FEN dal tabellone riconosciuto.';

  @override
  String get outputInCurrentLanguage => 'Output nella lingua corrente';

  @override
  String get commonBaseUrls => 'URL di base comuni';

  @override
  String get viewCommonModels => 'Visualizza modelli comuni';

  @override
  String get recognitionParametersUpdated =>
      'Parametri di riconoscimento aggiornati.';

  @override
  String get whiteSMove => 'Mossa del Bianco';

  @override
  String get resetToDefaults => 'Reimposta ai valori predefiniti';

  @override
  String get photoShoot => 'Scatto fotografico';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Impossibile applicare la posizione del tabellone riconosciuta.';

  @override
  String get llmPromptContent => 'Contenuto del prompt LLM';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM non configurato. Controlla le impostazioni.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Imposta provider, modello, API Key e Base URL';

  @override
  String get llmConfiguration => 'Configurazione LLM';

  @override
  String get configureLlmProvider => 'Configura provider LLM';

  @override
  String get llmPromptTemplateHeader => 'Intestazione modello di prompt LLM';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Nessun pezzo riconosciuto nell’immagine. Riprova.';

  @override
  String get recognizeBoardFromImage => 'Riconosci tabellone dall’immagine';

  @override
  String get viewTips => 'Visualizza suggerimenti';

  @override
  String get applyToBoard => 'Applica al tabellone';

  @override
  String get adjustBoardArea => 'Regola area del tabellone';

  @override
  String get viewCommonUrls => 'Visualizza URL comuni';

  @override
  String get colorAnalysisFailed => 'Analisi del colore fallita!';

  @override
  String get analyzingGameBoardImage =>
      'Analisi dell’immagine del tabellone in corso...';

  @override
  String get selectFromAlbum => 'Seleziona dall’album';

  @override
  String get noBoardPointDetected => 'Nessun punto del tabellone rilevato!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Se lasciato vuoto, verrà utilizzato il modello predefinito';

  @override
  String get llmConfig => 'Configurazione LLM';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Sei sicuro di voler reimpostare i modelli di prompt ai valori predefiniti?';

  @override
  String get llmPromptTemplateFooter => 'Piè di pagina modello di prompt LLM';

  @override
  String get loadingResponse => 'Caricamento della risposta...';

  @override
  String get applyThisResultToBoard => 'Applica questo risultato al tabellone';

  @override
  String get takingPicture => 'Scatto foto in corso...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Seleziona un’immagine del tabellone da identificare';

  @override
  String get identificationResults => 'Risultati dell’identificazione';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Analizza le mosse e fornisci approfondimenti.';

  @override
  String get getApiKey => 'Ottieni API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'L’intero processo di riconoscimento non è riuscito a completarsi.';

  @override
  String get boardRecognitionResult =>
      'Risultato del riconoscimento del tabellone';

  @override
  String get askLlm => 'Chiedi all’LLM';

  @override
  String get boardDetectionFailed => 'Rilevamento del tabellone fallito!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Nessun punto del tabellone rilevato, impossibile identificare il pezzo!';

  @override
  String get copyFen => 'Copia FEN';

  @override
  String get commonlyUsedModels => 'Modelli più comuni';

  @override
  String get apiKeyOptional => 'API Key (opzionale)';

  @override
  String get noImageSelected => 'Nessuna immagine selezionata';

  @override
  String get blackSMove => 'Mossa del Nero';

  @override
  String get llm => 'Grande Modello Linguistico';

  @override
  String get llmProvider => 'Fornitore';

  @override
  String get baseUrl => 'URL di base';

  @override
  String get model => 'Modello';

  @override
  String get temperature => 'Temperatura';

  @override
  String get llmCommandReceivedProcessing =>
      'Comando ricevuto! L\'IA sta elaborando...';

  @override
  String get llmDeepThinkingWait =>
      'Elaborazione profonda in corso, attendere prego...';

  @override
  String get llmPresentingSoon => 'In arrivo a breve...';

  @override
  String get recognitionParameters => 'Parametri di riconoscimento';

  @override
  String get adjustParamsDesc =>
      'Regola i parametri per migliorare la precisione del riconoscimento';

  @override
  String get saveParameters => 'Salva parametri';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Impossibile avviare il riconoscimento delle immagini: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Riconoscimento delle immagini non riuscito: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Posizione applicata con $whiteCount pedine bianche e $blackCount pedine nere';
  }

  @override
  String get fenCopiedToClipboard => '(FEN copiato negli appunti)';

  @override
  String recognitionFailed(String error) {
    return 'Riconoscimento non riuscito: $error';
  }

  @override
  String get myRating => 'La mia valutazione';

  @override
  String get gamesPlayed => 'Partite giocate';

  @override
  String get wins => 'Vittorie';

  @override
  String get losses => 'Sconfitte';

  @override
  String get draws => 'Pareggi';

  @override
  String get lastUpdated => 'Ultimo aggiornamento';

  @override
  String get format => 'Formato:';

  @override
  String get resetStatistics => 'Reimposta statistiche';

  @override
  String get drawRate => 'Tasso di pareggio';

  @override
  String get lossRate => 'Tasso di sconfitta';

  @override
  String get aiStatistics => 'Statistiche IA';

  @override
  String get enableStatistics => 'Abilita statistiche';

  @override
  String get enableStatistics_Detail =>
      'Se abilitato, i risultati delle partite verranno registrati nelle statistiche. Tuttavia, le partite che comportano l\'annullamento di mosse non verranno registrate. Se disabilitato, la raccolta delle statistiche viene sospesa.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Questo reimposterà tutte le statistiche di gioco. Questa azione non può essere annullata.';

  @override
  String get boardInnerRingSize =>
      'Dimensione dell\'anello interno della tavola';

  @override
  String get boardShadowEnabled => 'Ombra del tavoliere';

  @override
  String get trapAwareness => 'Rilevamento trappole';

  @override
  String get trapAwarenessDescription =>
      'Evidenzia le mosse trappola con cerchi e frecce in grassetto durante l\'analisi.';

  @override
  String trapExists(String trapMoves) {
    return 'Esiste una trappola. Mosse trappola: $trapMoves';
  }

  @override
  String get custodianCapture => 'Cattura fiancheggiata';

  @override
  String get custodianCaptureDescription =>
      'Allega uno dei pezzi del tuo avversario tra due dei tuoi in linea retta per catturarlo.';

  @override
  String get custodianCaptureEnable => 'Consenti la cattura di fianco';

  @override
  String get interventionCapture => 'Cattura di intervento';

  @override
  String get interventionCaptureDescription =>
      'Spostati nel punto vuoto tra due dei pezzi del tuo avversario per catturarli entrambi.';

  @override
  String get interventionCaptureEnable =>
      'Consentire l\'acquisizione di interventi';

  @override
  String get leapCapture => 'Saltare la cattura';

  @override
  String get leapCaptureDescription =>
      'Cattura saltando sopra il pezzo di un avversario adiacente nel punto vuoto oltre.';

  @override
  String get leapCaptureEnable => 'Consenti la cattura del salto';

  @override
  String get captureApplicableLines => 'Linee applicabili';

  @override
  String get captureSquareEdges => 'Lungo i bordi della piazza';

  @override
  String get captureCrossLines =>
      'Lungo le linee ortogonali che attraversano il quadrato';

  @override
  String get captureDiagonalLines =>
      'Lungo le linee diagonali che attraversano il quadrato';

  @override
  String get captureExecutionPhases => 'Fasi di esecuzione';

  @override
  String get capturePiecesCondition =>
      'Disponibilità durante la fase mobile in base ai pezzi rimanenti';

  @override
  String get capturePiecesConditionUnlimited => 'Nessuna restrizione';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Disponibile quando hai tre o meno pezzi';
}
