// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Icelandic (`is`).
class SIs extends S {
  SIs([String locale = 'is']) : super(locale);

  @override
  String get appName => 'Mill';

  @override
  String get welcome => 'Velkominn';

  @override
  String get yes => 'Já';

  @override
  String get no => 'Nei';

  @override
  String get game => 'Leikur';

  @override
  String get humanVsAi => 'Mannlegur vs. AI';

  @override
  String get humanVsHuman => 'Mannlegur vs. Mannlegur';

  @override
  String get aiVsAi => 'AI vs. AI';

  @override
  String get humanVsCloud => 'Mannlegur vs. Ský';

  @override
  String get humanVsLAN => 'Mannlegur vs. LAN';

  @override
  String get testViaLAN => 'Prófaðu í gegnum LAN';

  @override
  String get move => 'Færa';

  @override
  String get showMoveList => 'Færa listi';

  @override
  String get moveList => 'Færa listi';

  @override
  String get noGameRecord => 'Ekkert met';

  @override
  String get ok => 'Allt í lagi';

  @override
  String get confirm => 'Staðfesta';

  @override
  String get cancel => 'Hætta við';

  @override
  String get tipSelectWrong => 'Veldu ranga stykkið.';

  @override
  String get tipPlace => 'Settu stykkið þitt.';

  @override
  String get tipBanPlace => 'Þú getur ekki sett stykkið þitt hér.';

  @override
  String get tipPlaced => 'Þú settir stykkið.';

  @override
  String get tipRemove => 'Fjarlægðu stykkið.';

  @override
  String get tipBanRemove => 'Þú getur ekki fjarlægt stykkið.';

  @override
  String get tipRemoved => 'Þú fjarlægðir stykkið.';

  @override
  String get tipMove => 'Færðu stykkið.';

  @override
  String get tipCannotPlace => 'Þú getur ekki sett stykkið þitt hér.';

  @override
  String get tipCannotMove => 'Þú getur ekki fært stykkið þitt á þennan punkt.';

  @override
  String get tipMill => 'Mill! Taktu stykki andstæðingsins.';

  @override
  String get tipContinueMill => 'Haltu áfram að taka stykki andstæðingsins.';

  @override
  String get tipSelectOpponentsPiece => 'Veldu eitt af stykki andstæðingsins.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Þú getur ekki fjarlægt stykkið úr myllu.';

  @override
  String get tipCanMoveOnePoint => 'Stykkið getur færst um 1 punkt.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Þú getur ekki fært stykki andstæðingsins.';

  @override
  String get tipSelectPieceToMove => 'Veldu stykkið þitt til að færa.';

  @override
  String get tipHaveThreePiecesLeft => 'Þú átt þrjú stykki eftir.';

  @override
  String get tipCanMoveToAnyPoint =>
      'Þú getur fært stykkið á hvaða punkt sem er.';

  @override
  String tipToMove(Object player) {
    return '$player til að færa.';
  }

  @override
  String get whiteWin => 'Leikmaður 1 vinnur!';

  @override
  String get blackWin => 'Leikmaður 2 vinnur!';

  @override
  String get won => 'Vann';

  @override
  String get lost => 'Týndur';

  @override
  String get thinking => 'Er að hugsa…';

  @override
  String get newGame => 'Nýr leikur';

  @override
  String get importGame => 'Innflutningsleikur';

  @override
  String get exportGame => 'Flytja út leik';

  @override
  String get gameImported => 'Leikur fluttur inn.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Get ekki flutt inn $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'Hreyfingar og reglur passa ekki saman.';

  @override
  String get pleaseWait => 'Vinsamlegast bíðið.';

  @override
  String get restartGame => 'Endurræsa núverandi leik?';

  @override
  String get restart => 'Endurræsa';

  @override
  String get gameStarted => 'Leikurinn byrjaði, vinsamlegast settu.';

  @override
  String get analyzing => 'Er að greina…';

  @override
  String error(Object message) {
    return 'Villa: $message';
  }

  @override
  String get winRate => 'Vinningshlutfall';

  @override
  String get score => 'Mark:';

  @override
  String get white => 'Leikmaður 1';

  @override
  String get black => 'Leikmaður 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player stykkjafjöldi er minna en þrjú.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player sagði af sér.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player á enga leið að fara.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Spjaldið er fullt og $player á enga leið að fara.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Tíminn er liðinn, $player glataður.';
  }

  @override
  String get drawReasonRule50 =>
      'Í hreyfistiginu hefur ekkert stykki verið fjarlægt í síðasta tiltekna fjölda hreyfinga.';

  @override
  String get drawReasonBoardIsFull => 'Það er jafntefli því borðið er fullt.';

  @override
  String get drawReasonThreefoldRepetition =>
      'Það er jafntefli vegna þrefaldrar endurtekningar.';

  @override
  String get gameOverUnknownReason => 'Leik lokið! Óþekkt ástæða.';

  @override
  String get gameOver => 'Leik lokið';

  @override
  String get youWin => 'Þú vinnur! Til hamingju!';

  @override
  String challengeHarderLevel(int level) {
    return 'Áskorun erfiðara stig? Nýja stigið verður stig $level!';
  }

  @override
  String get youLose => 'Þú tapar!';

  @override
  String get analyze => 'Greina';

  @override
  String get about => 'Um';

  @override
  String version(Object versionNumber) {
    return 'Útgáfa: $versionNumber';
  }

  @override
  String get thanks => 'Takk';

  @override
  String get settings => 'Stillingar';

  @override
  String get options => 'Valm.';

  @override
  String get generalSettings => 'Almennar stillingar';

  @override
  String get skillLevel => 'Erfiðleikastig';

  @override
  String get moveTime => 'AI hugsunartími';

  @override
  String get difficulty => 'Erfiðleikar';

  @override
  String get playSounds => 'Hljóðbrellur';

  @override
  String get playSoundsInTheGame => 'Spilaðu hljóð í leiknum';

  @override
  String get keepMuteWhenTakingBack => 'Haltu hljóði þegar þú tekur til baka';

  @override
  String get tone => 'Tónn';

  @override
  String get whoMovesFirst => 'Fyrsta hreyfing';

  @override
  String get human => 'Mannlegur';

  @override
  String get ai => 'AI';

  @override
  String get alternate => 'Varamaður';

  @override
  String get isAutoRestart =>
      'Endurræstu leikinn sjálfkrafa þegar leiknum er lokið';

  @override
  String get isAutoChangeFirstMove => 'Sjálfvirk breyting á fyrstu hreyfingu';

  @override
  String get shufflingEnabled => 'Færðu af handahófi';

  @override
  String get misc => 'Ýmislegt';

  @override
  String get rules => 'Reglur';

  @override
  String get piecesCount => 'Fjöldi stykki sem hver leikmaður hefur';

  @override
  String get piecesCount_Detail => 'Hversu mörg stykki á hver leikmaður?';

  @override
  String get flyPieceCount => 'Númer fljúgandi stykkisins';

  @override
  String get flyPieceCount_Detail =>
      'Ef kveikt er á fljúgandi, þegar leikmanni er fækkað niður í ákveðna stykkisfjölda, er stykki hennar frjálst að fara á hvaða stað sem er óupptekinn í stað þess að vera bundinn við aðliggjandi stig eins og í restinni af leiknum.';

  @override
  String get piecesAtLeastCount => 'Hlutar að minnsta kosti';

  @override
  String get hasDiagonalLines => 'Hvíaðar línur';

  @override
  String get hasDiagonalLines_Detail => 'Bættu fjórum skálínum við borðið.';

  @override
  String get isDefenderMoveFirst => 'Annar leikmaður færir sig fyrstur';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Leikmaðurinn sem færist í öðru sæti í staðsetningarfasanum færist fyrstur í hreyfifasanum.';

  @override
  String get mayRemoveMultiple => 'Fjölfjarlægja';

  @override
  String get mayRemoveMultiple_Detail =>
      'Ef leikmaður lokar fleiri en einni myllu í einu mun hún fjarlægja fjölda myllna sem hún lokaði.';

  @override
  String get mayRemoveFromMillsAlways => 'Eyðileggja myllur';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Sjálfgefið er að leikmenn verða að fjarlægja öll önnur stykki fyrst áður en stykki er fjarlægt úr myndaðri myllu. Virkjaðu þennan valkost til að slökkva á takmörkuninni.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Annar leikmaður tapar þegar borðið er fullt';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Þegar borðið er fullt í lok staðsetningarfasans tapar sú hlið sem kemur fyrst leiknum. Að öðru leyti er leikurinn jafntefli.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Tapa þegar engar löglegar hreyfingar';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Leikmaðurinn mun tapa ef andstæðingur hans hindrar þá þannig að ekki er hægt að færa þá. Breyttu hlið til að færa ef þessi valkostur er óvirkur.';

  @override
  String get mayFly => 'Fljúga';

  @override
  String get mayFly_Detail =>
      'Ef leikmaður á aðeins þrjá eða fjóra (stillanlega) búta eftir, getur hann fært verkið á hvaða frípunkt sem er.';

  @override
  String get nMoveRule => 'N-hreyfa regla';

  @override
  String get nMoveRule_Detail =>
      'Dregið er í leiknum ef ekkert hefur verið fjarlægt í tilteknum fjölda færa.';

  @override
  String get rollback => 'Til baka';

  @override
  String get pleaseSelect => 'Vinsamlegast veldu';

  @override
  String get copy => 'Afrita';

  @override
  String get moveHistoryCopied => 'Færa feril afrituð á klippiborð.';

  @override
  String get help => 'Hjálp';

  @override
  String get feedback => 'Endurgjöf';

  @override
  String get exit => 'Hætta';

  @override
  String get ruleSettings => 'Reglustillingar';

  @override
  String get color => 'Litur';

  @override
  String get boardColor => 'Litur borðs';

  @override
  String get pieceColor => 'Litur stykkisins';

  @override
  String get backgroundColor => 'Bakgrunns litur';

  @override
  String get lineColor => 'Litur borðlínu';

  @override
  String get whitePieceColor => 'Leikmaður 1 stykki litur';

  @override
  String get blackPieceColor => 'Leikmaður 2 stykki litur';

  @override
  String get messageColor => 'Litur skilaboða';

  @override
  String get isPieceCountInHandShown => 'Sýnið fjölda ósettra bita';

  @override
  String get isNotationsShown => 'Sýna merkingar um borð';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Sýna tækjastiku söguleiðsagnar';

  @override
  String get display => 'Skjár';

  @override
  String get boardBorderLineWidth => 'Breidd borðs';

  @override
  String get boardInnerLineWidth => 'Innri línubreidd borðs';

  @override
  String get pieceWidth => 'Stykkjabreidd';

  @override
  String get fontSize => 'Leturstærð';

  @override
  String get standardNotation => 'WMD merking';

  @override
  String get restore => 'Endurheimta';

  @override
  String get restoreDefaultSettings => 'Endurheimta sjálfgefnar stillingar';

  @override
  String pick(Object element) {
    return 'Veldu $element';
  }

  @override
  String get info => 'Upplýsingar';

  @override
  String get hint => 'Vísbending';

  @override
  String get player => 'leikmaður';

  @override
  String get player1 => 'Leikmaður 1';

  @override
  String get player2 => 'Leikmaður 2';

  @override
  String get howToPlay => 'Hvernig á að spila';

  @override
  String get toPlacePiece =>
      'Pikkaðu á hvaða lausan punkt sem er til að setja stykkið.';

  @override
  String get toSelectPiece => 'Bankaðu á stykki til að færa það.';

  @override
  String get toMovePiece =>
      'Bankaðu á punkt sem er tengdur við verk til að færa hann.';

  @override
  String get toRemovePiece =>
      'Bankaðu á eitt stykki andstæðingsins til að fjarlægja.';

  @override
  String get needToCreateMillFirst =>
      'Þú þarft að búa til myllu fyrst áður en þú getur fjarlægt stykki.';

  @override
  String get needToPlayWithOwnPieces => 'Þú þarft að spila með verkin þín.';

  @override
  String get statistics => 'Tölfræði';

  @override
  String get totalGames => 'Samtals leikir';

  @override
  String get results => 'Niðurstöður';

  @override
  String get left => 'vinstri';

  @override
  String get privacyPolicy => 'Friðhelgisstefna';

  @override
  String get privacyPolicy_Detail_1 =>
      'Vinsamlegast lestu vandlega og vertu viss um að þú skiljir þetta til fulls og samþykkir þetta ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Ef þú samþykkir ekki þessa stefnu skaltu ekki nota þetta forrit. Notkun appsins þýðir að þú samþykkir þessa skilmála.';

  @override
  String get and => ' og ';

  @override
  String get accept => 'Samþykkja';

  @override
  String get takeBack => 'Taka aftur';

  @override
  String get takingBack => 'Tekur til baka…';

  @override
  String get waiting => 'Bíður…';

  @override
  String get stepForward => 'Stígðu fram';

  @override
  String get takeBackAll => 'Taktu allt til baka';

  @override
  String get stepForwardAll => 'Stígðu fram öll';

  @override
  String get moveNow => 'Færðu þig núna';

  @override
  String get done => 'Búið.';

  @override
  String get crackMill => 'Sprunga-mylla';

  @override
  String get crackMill_Detail =>
      'Ef leikmaður hefur aðeins búta í myllum, þá læsast ekki bitarnir í myllunum til að fjarlægja.';

  @override
  String get animationDuration => 'Lengd hreyfimynda';

  @override
  String get none => 'Enginn';

  @override
  String get theme => 'Þema';

  @override
  String get helpContent =>
      'Leikurinn miðar að því að skilja andstæðinginn eftir með færri en þrjú stykki eða engin lögleg hreyfing.\n\nLeikurinn gerir sjálfkrafa jafntefli ef staða kemur upp í þriðja sinn eða tekur ekki af í síðustu 100 (stillanlegu) hreyfingum.\n\nLeikurinn fer fram í þremur áföngum:\n\n1. Setja stykki á lausa punkta\n2. Færa stykki á aðliggjandi punkta\n3. (valfrjáls áfangi) Að færa stykki á hvaða lausa stað sem er þegar leikmaðurinn er minnkaður í þrjú stykki\n\nStaðsetning\n\nLeikurinn hefst á tómu borði sem samanstendur af rist með tuttugu og fjórum stigum. Leikmenn skiptast á að setja verkin sín á lausa punkta þar til hver leikmaður hefur sett alla bitana á borðið. Ef leikmaður getur sett þrjá af kubbana sínum beint, hefur hann „mill“ og má taka einn af stykki andstæðings síns af borðinu.\n\nÍ sumum reglum verða leikmenn að fjarlægja alla aðra búta fyrst áður en þeir taka bút úr myndaðri myllu.\n\nÍ sumum reglum er ekki hægt að setja stykkin á punkta á fjarlægðum stykki aftur í staðsetningarfasa.\n\nÞegar þú hefur notað öll verkin skiptast leikmenn á að hreyfa sig.\n\nAð flytja\n\nTil að hreyfa sig færir leikmaður einn af verkunum sínum eftir borðlínu á lausan aðliggjandi punkt. Ef hann getur það ekki hefur hann tapað leiknum. Leikmaður sem stillir þremur kubba sínum á borðlínu hefur myllu og má fjarlægja einn af stykki andstæðings síns eins og í lagningarfasanum. Sérhver leikmaður minnkar niður í tvö stykki, hefur engan möguleika á að mynda nýjar myllur og tapar þar með leiknum. Leikmaður getur líka tapað þegar fleiri en þrír boltar eru ef andstæðingur hans hindrar hreyfingu þeirra.\n\nFljúga\n\nÍ sumum afbrigðum reglnanna, þegar leikmaður hefur aðeins þrjú stykki eftir, geta stykkin hans flogið, hoppað eða hoppað á hvaða lausa punkta sem er, ekki aðeins aðliggjandi.\n';

  @override
  String get versionInfo => 'Upplýsingar um útgáfu';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'Leyfi';

  @override
  String get sourceCode => 'Upprunakóði';

  @override
  String get appVersion => 'App útgáfa';

  @override
  String get general => 'Almennt';

  @override
  String get advanced => 'Ítarlegri';

  @override
  String get placing => 'Staðsetning';

  @override
  String get moving => 'Að flytja';

  @override
  String get removing => 'Fjarlægir';

  @override
  String get gameOverCondition => 'Leik lokið ástand';

  @override
  String get aisPlayStyle => 'Leikstíll gervigreindar';

  @override
  String get passive => 'Hlutlaus';

  @override
  String get timeout => 'Hlé';

  @override
  String get appearance => 'Útlit';

  @override
  String get drawOnHumanExperience => 'Notaðu mannlega reynslu';

  @override
  String get considerMobility => 'Íhuga hreyfanleika stykki';

  @override
  String get pieceCount => 'Stykkjafjöldi:';

  @override
  String inHand(Object player, int count) {
    return '$player í hendi: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player um borð: $count';
  }

  @override
  String get boardTop => 'Borð á móti ofan frá';

  @override
  String get notAIsTurn => 'Það er ekki röðin að gervigreindinni.';

  @override
  String get aiIsNotThinking => 'AI er ekki að hugsa.';

  @override
  String get atEnd => 'Þú ert í lok flutningslistans.';

  @override
  String get tapBackAgainToLeave => 'Bankaðu aftur til baka til að fara.';

  @override
  String get more => 'Meira';

  @override
  String get experimental => 'Það er tilraunaeiginleiki.';

  @override
  String get experiments => 'Tilraunir';

  @override
  String get ossLicenses => 'Opinn uppspretta leyfi';

  @override
  String get language => 'Tungumál';

  @override
  String get defaultLanguage => 'Sjálfgefið tungumál';

  @override
  String get mayMoveInPlacingPhase =>
      'Hlutarnir geta hreyfst í staðsetningarfasa';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Það eru engir aðgreindir staðsetningar- og hreyfingar, þ.e.a.s. spilarar geta ákveðið í hverri hreyfingu hvort þeir vilji setja stykki á borðið eða færa einn kubba (svo framarlega sem þeir eiga eftir af stykki til að setja).';

  @override
  String get drawerColor => 'Litur á matseðli';

  @override
  String get drawerTextColor => 'Litur texta valmyndar';

  @override
  String get drawerHighlightItemColor => 'Valmynd hápunktur hlutur litur';

  @override
  String get mainToolbarBackgroundColor => 'Bakgrunnslitur aðaltækjastikunnar';

  @override
  String get mainToolbarIconColor => 'Litur aðaltáknstikunnar';

  @override
  String get navigationToolbarBackgroundColor =>
      'Bakgrunnslitur tækjastikunnar';

  @override
  String get navigationToolbarIconColor => 'Litur á tækjastiku fyrir siglingar';

  @override
  String get autoHideToolbar => 'Fela tækjastikuna sjálfkrafa';

  @override
  String get toolbarLocationOnScreen => 'Staðsetning tækjastikunnar á skjánum';

  @override
  String get top => 'Efst';

  @override
  String get bottom => 'Neðst';

  @override
  String get center => 'Miðja';

  @override
  String get solidColor => 'Einlitt';

  @override
  String get picture => 'Mynd';

  @override
  String get chooseYourPicture => 'Veldu myndina þína';

  @override
  String get light => 'Ljós';

  @override
  String get dark => 'Myrkur';

  @override
  String get themes => 'Þemu';

  @override
  String get currentTheme => 'Núverandi þema';

  @override
  String get saveTheme => 'Vista þema';

  @override
  String get showAnalysisGraph => 'Sýna greiningargraf';

  @override
  String get analysis => 'Greining';

  @override
  String get saveGame => 'Vista leik';

  @override
  String get loadGame => 'Hlaða leik';

  @override
  String get setupPosition => 'Uppsetningarstaða';

  @override
  String get showLegalMoves => 'Sýndu löglegar hreyfingar';

  @override
  String get showLastMove => 'Sýndu síðustu hreyfingu';

  @override
  String get showArrows => 'Sýndu örvar';

  @override
  String get pieces => 'Stykki';

  @override
  String get showAnalysis => 'Sýna greiningu';

  @override
  String get threads => 'Þræðir';

  @override
  String get getInvolved => 'Taka þátt';

  @override
  String get helpImproveTranslate => 'Hjálpaðu til við að bæta þýðingar';

  @override
  String get tutorial => 'Kennsla';

  @override
  String get classicMill => 'Klassísk Mill';

  @override
  String get mixedMill => 'Blandað Mill';

  @override
  String get ceylonMill => 'Ceylon Mjöl';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Mylla getur verið brotin og endurgerð ítrekað';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Ef leikmaður brýtur myllu til að búa til nýja myllu strax, getur hann fært slíkan hlut aftur á upphaflega mótið í næstu hreyfingu sinni ef hann gerir nýja myllu.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Leikurinn er jafntefli ef leikmaður er með þrjú stykki og eftir tíu hreyfingar tekur hvorugur leikmaður stykki andstæðingsins';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Þegar leikmaður er kominn niður í þrjú stykki og hvorugur leikmaðurinn getur fjarlægt stykki andstæðings innan tíu leikja, er leikurinn jafntefli.';

  @override
  String get close => 'Loka';

  @override
  String get whitePiece => 'Hvítt stykki';

  @override
  String get blackPiece => 'Svart stykki';

  @override
  String get emptyPoint => 'Tómur punktur';

  @override
  String get noPoint => 'Ekkert mál';

  @override
  String get placingPhase => 'Staðsetningarfasi';

  @override
  String get movingPhase => 'Hreyfifasi';

  @override
  String get flyingPhase => 'Flugáfangi';

  @override
  String sideToMove(Object player) {
    return 'Hlið til að hreyfa: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Síðasta hreyfing: $move';
  }

  @override
  String get selected => 'Valið';

  @override
  String get accessibility => 'Aðgengi';

  @override
  String get screenReaderSupport => 'Stuðningur við skjálesara';

  @override
  String get isDraw => 'Það er jafntefli!';

  @override
  String get draw => 'Jafntefli';

  @override
  String get pieceHighlightColor => 'Hápunktur litur stykkisins';

  @override
  String get algorithm => 'Reiknirit';

  @override
  String get endgameNMoveRule => 'Endgame N-Move regla';

  @override
  String get endgameNMoveRule_Detail =>
      'Leikurinn er jafntefli ef annar hvor leikmaðurinn hefur aðeins þrjú stykki og hvorugur leikmaðurinn fjarlægir stykki innan ákveðinna hreyfinga.';

  @override
  String get drawReasonEndgameRule50 =>
      'Hvor leikmaðurinn á aðeins þrjú stykki og hvorugur leikmaðurinn fjarlægir stykki innan ákveðinna hreyfinga.';

  @override
  String get threefoldRepetitionRule => 'Þríþætt endurtekningarregla';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Dregið er í leiknum ef staðan er í þriðja sinn.';

  @override
  String get continueToMakeMove => 'Mill! Haltu áfram að hreyfa þig.';

  @override
  String get pointStyle => 'Punktastíll';

  @override
  String get pointWidth => 'Point breidd';

  @override
  String get solid => 'þéttur hringur';

  @override
  String get hollow => 'Holur';

  @override
  String get languageName => 'Íslenska';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Moves',
      one: '$count Færa',
      zero: 'Move',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Hleðsla mistókst.';

  @override
  String get filename => 'Skráarnafn';

  @override
  String get browse => 'Skoða…';

  @override
  String get gameFiles => 'Leikjaskrár';

  @override
  String get gameSavedTo => 'Leikurinn er vistaður í';

  @override
  String get empty => 'Tómt';

  @override
  String get noMove => 'Engin hreyfing.';

  @override
  String get restoredPosition => 'Endurheimt upphafsstaða.';

  @override
  String get clean => 'Hreint';

  @override
  String get cleanedUp => 'Hreinsað.';

  @override
  String get remove => 'Fjarlægja';

  @override
  String get noPiecesCanBeRemoved => 'Enga bita má fjarlægja.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count pieces',
      one: '$count piece',
      zero: 'Piece',
    );
    return '$_temp0 þarf að fjarlægja.';
  }

  @override
  String placedCount(int count) {
    return 'Sett ($count)';
  }

  @override
  String get placedPieceCount => 'Fjöldi settra stykkja í uppsetningarfasa.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'Núverandi leikmaður hefur sett $count stykki.';
  }

  @override
  String get notPlacingPhase => 'Ekki setja fasa, getur ekki breytt því.';

  @override
  String get paste => 'Líma';

  @override
  String get pasteDone => 'Deigið er búið.';

  @override
  String get cannotPaste => 'Ekki hægt að líma.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Sýndu ósetta og fjarlægða hluti';

  @override
  String get fullScreen => 'Fullur skjár';

  @override
  String get reopenToTakeEffect =>
      'Lokaðu og opnaðu forritið aftur til að stillingar taki gildi.';

  @override
  String get forest => 'Skógur';

  @override
  String get desktopImage => 'Skrifborðsmynd';

  @override
  String get invalidPosition => 'Ógild staða.';

  @override
  String get shareGIF => 'Deildu GIF';

  @override
  String get pixelRatio => 'Pixel hlutfall';

  @override
  String get duration => 'Lengd';

  @override
  String get gameScreenRecorder => 'Skjáupptökutæki fyrir leik';

  @override
  String get previous => 'Fyrri';

  @override
  String get next => 'Næst';

  @override
  String get skip => 'Sleppa';

  @override
  String get gotIt => 'Náði því';

  @override
  String get youCanModifyRules =>
      'Þú getur breytt leikreglunum í reglustillingunum.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Þú getur notað músarhjólið til að breyta gildinu í veljarann.';

  @override
  String get noTimeLimitForThinking =>
      'AI hugsunartími stilltur á 0 þýðir að það er engin tímamörk fyrir hugsun.';

  @override
  String get whatIsMtdf =>
      'MTD(f) er breytt form af alfa-beta leitarreikniritinu sem miðar að því að bæta skilvirkni með því að endurnýta millileitarniðurstöður og nota góða fyrstu getgátu til að þrengja leitarrýmið.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Vinsamlegast hafðu í huga að tímastilling gervigreindarhugsunar er kannski ekki alveg nákvæm. Raunverulegur umhugsunartími getur verið styttri þegar erfiðleikastigið er stillt á lægra gildi og getur verið lengri þegar gervigreindin er miðlungs hugsun þegar tíminn rennur út.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Ef þú stillir erfiðleikastigið hátt en eykur ekki AI-hugsunartímann, getur raunverulegt erfiðleikastig verið takmarkað við lægra gildi vegna þvingunar á hugsunartíma. Raunverulegt gildi getur verið mismunandi eftir afköstum vélarinnar.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) er leitarreiknirit til að finna bestu hreyfingu í tiltekinni stöðu. Það er aukning á alfa-beta reikniritinu og notar núll eða núll gluggaleit til að staðfesta að hreyfing sé verri eða ekki verri en þegar öruggt stig frá aðalafbrigðinu. PVS leggur áherslu á vænlegustu hreyfingarnar og forðast óþarfa leit á óhagkvæmum greinum, sem hjálpar til við að bæta skilvirkni leitarinnar.';

  @override
  String get whatIsAlphaBeta =>
      'Alfa-beta reikniritið er leitarreiknirit til að finna bestu hreyfinguna. Það notar minimax meginregluna og tvö gildi, alfa og beta, til að klippa leitartréð og auka skilvirkni. Alfa táknar lágmarkseinkunn sem tölvan er viss um að hún geti fengið, en beta táknar hámarkseinkunn sem andstæðingur hennar getur fengið. Reikniritið hjálpar tölvunni að taka snjallar og skilvirkar ákvarðanir í leik.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Samkvæmt mannlegri reynslu taparðu ef þú reynir að vinna. Stefni í staðinn að jafntefli sem markmið þitt og forðastu að tapa leiknum. Fylgstu með andstæðingnum þínum og tældu hann varlega í stöðu þar sem hann gæti gert mistök. Þegar þeir sýna veikleika, gríptu tækifærið og ýttu varlega á sigur. Þannig geturðu unnið leikinn.';

  @override
  String get firstMoveDetail =>
      'Í þessum leik er auðveldara fyrir seinni spilarann að vinna samanborið við þann fyrsta.';

  @override
  String get passiveDetail =>
      'Með því að virkja Passive valmöguleikann mun gervigreindin slaka á þegar hún hefur yfirburði í stöðunni, frekar en að reyna árásargjarnt að vinna eins fljótt og auðið er.';

  @override
  String get moveRandomlyDetail =>
      'Að virkja þennan valkost eykur handahófi og skemmtun leiksins á meðan slökkt er á honum getur hjálpað til við að rannsaka leiðir til að vinna bug á gervigreindinni.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Ef gervigreindin veltir fyrir sér hreyfanleika bita sinna mun það ekki aðeins stefna að því að fanga bita andstæðingsins eins fljótt og auðið er, heldur einnig að íhuga að hindra hreyfingar andstæðingsins og koma í veg fyrir að þeir geri slíkt hið sama.';

  @override
  String get whenBoardIsFull => 'Þegar borðið er fullt';

  @override
  String get whenBoardIsFull_Detail =>
      'Í lok staðsetningarfasans, áður en flutningsfasinn hefst, fylgir aðgerðin ef borðið er fullt af bitum.';

  @override
  String get sideToMoveRemovePiece =>
      'Leikmaðurinn sem hreyfir sig fyrstur í flutningsfasanum fjarlægir einn af stykki andstæðingsins.';

  @override
  String get agreeToDraw => 'Bæði lið eru sammála um jafntefli.';

  @override
  String get takeOpponentsPiece => 'Taktu eitt af verkum andstæðingsins.';

  @override
  String get firstPlayerLose => 'Fyrsti leikmaðurinn tapar leiknum.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Fyrsti og annar leikmaðurinn fjarlægir einn af stykki andstæðingsins.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Annar og fyrsti leikmaðurinn fjarlægir einn af stykki andstæðingsins.';

  @override
  String get enteredFlyingPhase =>
      'Nú þegar komið er inn í fljúgandi áfanga, geta stykki andstæðingsins hoppað á hvaða tóma stað sem er á borðinu. Þú getur slökkt á flugreglunni í „Reglunarstillingum“.';

  @override
  String get whenStalemate => 'Þegar pattstaða';

  @override
  String get whenStalemate_Detail =>
      'Hvaða aðgerð fylgir þegar ekki er hægt að færa neinn bita?';

  @override
  String get endWithStalemateLoss =>
      'Enda með pattstöðu tapi fyrir hliðina sem er læst.';

  @override
  String get changeSideToMove => 'Skiptu um hlið til að færa.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Fjarlægðu einn af stykki andstæðingsins og gerðu næstu hreyfingu.';

  @override
  String get endWithStalemateDraw => 'Enda með jafntefli.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Fjarlægðu einn af stykki andstæðingsins og skiptu um hlið til að færa.';

  @override
  String get aiResponseDelayTime => 'AI svarseinkun';

  @override
  String get aiIsDelaying =>
      'Gervigreind er sem stendur í seinkaðri viðbragðsfasa. Vinsamlegast bíddu í smá stund áður en þú heldur áfram.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Þú getur ekki fjarlægt stykki sem ekki er aðliggjandi.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'Ef pattstaða er, er hægt að fjarlægja stykki andstæðingsins, sem liggja að þínum, burt, óháð myllumyndun.';

  @override
  String get whatIsMcts =>
      'MCTS er byrjendavænt reiknirit sem tekur ákvarðanir með því að kanna og meta mismunandi hreyfingar í gegnum uppgerð.';

  @override
  String get goldenJade => 'Gullin Jade';

  @override
  String get forestWood => 'Skógartre';

  @override
  String get darkMystery => 'Dökk Leynd';

  @override
  String get midnightBlue => 'Miðnæturblár';

  @override
  String get greenForest => 'Grænn skógur';

  @override
  String get greenMeadow => 'Grænt tún';

  @override
  String get stonyPath => 'Steinunn slóð';

  @override
  String get pastelPink => 'Pastel bleikur';

  @override
  String get turquoiseSea => 'Túrkísblátt hafið';

  @override
  String get violetDream => 'Fjólublá draumur';

  @override
  String get mintChocolate => 'Myntu súkkulaði';

  @override
  String get skyBlue => 'Himinblátt';

  @override
  String get playfulGarden => 'Fjörugur Garður';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Retrograde Analysis reikniritið notar marggilda retrograde greiningu til að byggja upp lokagagnagrunn úr mismunandi upphafsstöðum og notar síðan þennan gagnagrunn til að hámarka spilun. Þessi nálgun fellur undir flokkinn Ultra-Strong lausnir.';

  @override
  String get viewAlgorithmGuide =>
      'Viltu skoða notendahandbókina fyrir þetta reiknirit?';

  @override
  String get showPositionalAdvantageIndicator => 'Sýna stöðuávinningsvísi';

  @override
  String get usePerfectDatabase => 'Notaðu fullkominn gagnagrunn';

  @override
  String get perfectDatabaseDescription =>
      'Virkjaðu þennan valkost til að nota gallalausan leikjagagnagrunn sem er búinn til með nýjustu reikniritum. Þessi eiginleiki samþættir bæði opnunar- og lokaaðferðir til að stinga upp á bestu hreyfingum. Þetta er ákjósanlegur kostur fyrir leikmenn sem sækjast eftir hæsta stigi nákvæmni í spilun. Gagnagrunnurinn er búinn til með nákvæmri tölvutækni og er hannaður til að bjóða upp á næstum fullkomnar leikjalausnir.\n\nAthugið: Ef gervigreind nær ekki aðgangi að gagnagrunninum mun það snúa sér að hefðbundnum reikniritum fyrir ákvarðanir um spilun. Þegar gagnagrunnurinn er tiltækur verður „Erfiðleikastigið“ nánast óviðjafnanlegt og „AI Thinking Time“ minnkar verulega. Mörgum stillingum innan valmöguleika \'AI\'s play style\' verður hnekkt, þar sem niðurstöður gagnagrunnsins hafa hæsta forgang.\n\nTil að fá leiðbeiningar um hvernig á að nýta þennan gallalausa gagnagrunn sem best, smelltu hér.';

  @override
  String get backgroundImage => 'Bakgrunnsmynd';

  @override
  String get whatIsRandom =>
      'Þegar valÞegar valmöguleikinn „Notaðu fullkominn gagnagrunn“ er ekki virkur, veldur „Random“ stillingin gervigreind til að færa stykki af handahófi án þess að nota nokkur reiknirit fyrir val á hreyfingu. Þetta leiðir venjulega til verulega veikara spilunar. Aftur á móti, þegar „Notaðu fullkominn gagnagrunn“ er virkt, treystir gervigreindin eingöngu á „fullkomna gagnagrunninn“ til að taka ákvarðanir, í stað þess að blanda honum saman við hefðbundin gervigreind reiknirit. Í þessum ham eru hreyfingar gervigreindar algjörlega byggðar á innihaldi gagnagrunnsins og forðast að treysta á rauntímaútreikninga eða leitarreiknirit.möguleikinn „Notaðu fullkominn gagnagrunn“ er ekki virkur, veldur „Random“ stillingin gervigreind til að færa stykki af handahófi án þess að nota nokkur reiknirit fyrir val á hreyfingu. Þetta leiðir venjulega til verulega veikara spilunar. Aftur á móti, þegar „Notaðu fullkominn gagnagrunn“ er virkt, treystir gervigreindin eingöngu á „fullkomna gagnagrunninn“ til að taka ákvarðanir, í stað þess að blanda honum saman við hefðbundin gervigreind reiknirit. Í þessum ham eru hreyfingar gervigreindar algjörlega byggðar á innihaldi gagnagrunnsins og forðast að treysta á rauntímaútreikninga eða leitarreiknirit.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Fjarlægðu bríki andstæðingsins úr hendinni á þeim; þá er það kominn að andstæðingnum að setja niður.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Þegar mylla er mynduð í uppsetningarlotunni';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Fjarlægðu bríki andstæðingsins af spilaborðinu.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Fjarlægðu bríki andstæðingsins af spilaborðinu; þá er það kominn að andstæðingnum að setja niður.';

  @override
  String get opponentRemovesOwnPiece =>
      'Andstæðingurinn fjarlægir eigin bríki af spilaborðinu.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Í stað þess að þú grípir til aðgerða, þá velur andstæðingurinn að fjarlægja eigin bríki af spilaborðinu, sem er í reynd aðgerð sem er skaðleg fyrir hann sjálfan.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Fjarlægðu bríki andstæðingsins úr hendinni á þeim; þá er það þinn tími til að hreyfa þig.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Fjarlægðu bríki af hendi andstæðingsins. Ef samkvæmt stillingunni fyrir fjölda til að fjarlægja skal fjarlægja margar bríkur og andstæðingurinn hefur engar bríkur eftir í hendi, skaltu halda áfram að fjarlægja bríkur andstæðingsins af spilaborðinu. Þá er það þinn tími til að hreyfa þig. Ef þú heldur áfram að mynda myllur, þá geturðu haldið áfram að fjarlægja bríkur andstæðingsins.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Fjarlægðu bríki af hendi andstæðingsins. Ef samkvæmt stillingunni fyrir fjölda til að fjarlægja skal fjarlægja margar bríkur og andstæðingurinn hefur engar bríkur eftir í hendi, skaltu halda áfram að fjarlægja bríkur andstæðingsins af spilaborðinu. Þá er það kominn að andstæðingnum að hreyfa sig.';

  @override
  String get markAndDelayRemovingPieces => 'Merktu seinkaða fjarlægingu bríka.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Í uppsetningarlotunni eru bríkur sem á að fjarlægja merktar og hvorugur leikmaður getur sett niður nýjar bríkur á þessum stöðum. Þegar komið er í færslulotuna eru þessar merktar bríkur fjarlægðar að fullu og leikmenn geta þá færst með bríkur sínar á þessar nú tómu stöður.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Aðgerðir sem hægt er að grípa til þegar mylla er mynduð á staðsetningarstigi.';

  @override
  String get marked => 'Merkt';

  @override
  String get menu => 'Valmynd';

  @override
  String get monochrome => 'Einslitur';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Þú getur virkjað stuðning við skjálesara í aðgengisstillingum í Almennar stillingar.';

  @override
  String get showNumbersOnPieces => 'Sýna númer á peðum';

  @override
  String get saveImage => 'Vista mynd';

  @override
  String get isAnalysisToolbarShown => 'Sýna greiningartækni';

  @override
  String get analysisToolbarBackgroundColor => 'Bakgrunnslitur greiningartækni';

  @override
  String get analysisToolbarIconColor => 'Litir ikóna greiningartækni';

  @override
  String get transformed => 'Breytist.';

  @override
  String get cannotTransform => 'Ekki hægt að breyta.';

  @override
  String get rotate => 'Snúa';

  @override
  String get horizontalFlip => 'L.S.';

  @override
  String get verticalFlip => 'V.S.';

  @override
  String get innerOuterFlip => 'I/Y S.';

  @override
  String get transparentCanvas => 'Gegnsætt Striga';

  @override
  String get restrictRepeatedMillsFormation =>
      'Takmarka endurtekna myndun myllu';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Stykki sem fært er úr einum myllu í aðra getur ekki strax snúið aftur á upphafspunktinn í næsta leik til að mynda myllu aftur. Fyrst þarf annað skref.';

  @override
  String get oneTimeUseMill => 'Eingang notkun mylla';

  @override
  String get oneTimeUseMill_Detail =>
      'Hver mylla getur aðeins fjarlægt eitt stykki andstæðingsins einu sinni. Þú getur endurmyndað það, en það er ekki hægt að nota það til að fjarlægja aðra.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Núverandi reglur sem þú hefur sett hafa ekki samsvarandi fullkominn gagnagrunn. Fyrir frekari upplýsingar um hinn fullkomna gagnagrunn, vinsamlegast smelltu hér.';

  @override
  String get focusOnBlockingPaths => 'Einbeitið ykkur að því að loka leiðum';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Forgangsröð að hindra hreyfingar andstæðingsins fram yfir að mynda möllur. Í stað þess að einbeita sér að því að fjarlægja stykki með því að ljúka möllum, miðar AI að því að loka andstæðingnum, gera þeim ófært að hreyfa sig og tryggja sigur með úthaldsleik frekar en árásargjarnri leik. Þessi stefna lokar ekki virkan möllum andstæðingsins.';

  @override
  String get pieceImage => 'Skákmanna mynd';

  @override
  String get importColorSettings => 'Flytja inn litastillingar';

  @override
  String get exportColorSettings => 'Flytja út litastillingar';

  @override
  String get import => 'Flytja inn';

  @override
  String get export => 'Flytja út';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Vinsamlegast afritaðu JSON stillingarnar á klemmuspjald fyrst.';

  @override
  String get copiedToClipboard => 'Afritað á klemmuspjald.';

  @override
  String get imported => 'Flutt inn.';

  @override
  String get boardImage => 'Borðmynd';

  @override
  String get autumnLeaves => 'Haustlauf';

  @override
  String get legendaryLand => 'Goðsagnir Land';

  @override
  String get vignetteEffect => 'Vignettingaráhrif';

  @override
  String get promptMakeToolbarTransparent =>
      'Viltu gera verkstjólastikuna alveg gegnsæa þegar bakgrunnsmynd fyrir borð er stillt?';

  @override
  String get vibration => 'Virkjaðu titring í leiknum';

  @override
  String get soundTheme => 'Hljóðtema';

  @override
  String get ball => 'Kúla';

  @override
  String get liquid => 'Vökvi';

  @override
  String get wood => 'Tré';

  @override
  String get placeEffectAnimation =>
      'Hreyfimyndaráhrif við að setja niður taflmann';

  @override
  String get removeEffectAnimation =>
      'Hreyfimyndaráhrif við að fjarlægja taflmann';

  @override
  String get isToolbarAtBottom => 'Sýna tækjastiku neðst';

  @override
  String get boardCornerRadius => 'Horngeisli spjalds';

  @override
  String get useOpeningBook => 'Notaðu opnunarbók';

  @override
  String get currentRule => 'Núverandi';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Regluset';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'One-Time Mill';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'Leyfðu gervigreindinni að nota opnunaráð sem faglegir mannlegir leikmenn nota oft í upphafi leiks. Athugið: Þessi eiginleiki er núna aðeins í boði fyrir ákveðin regluset.';

  @override
  String get showAdvantageGraph => 'Sýna forskotslínurit';

  @override
  String get advantageGraphHint =>
      'Forðagröf mun aðeins vera teiknuð eftir að gervigreindin gerir leik. Hún verður ekki teiknuð þegar mannlegur spilari gerir leik.';

  @override
  String get removalBasedOnMillCounts =>
      'Slökktu á fjarlægingu þar til öllum pönnum hefur verið komið fyrir. Spilarar fjarlægja peð út frá fjölda myllu sem myndast.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Slökktu á fjarlægingu þar til öllum pönnum hefur verið komið fyrir. Spilarar fjarlægja peð út frá fjölda myllu: ef fjöldinn er sá sami, fjarlægja báðir jafnmörg peð; ef annar hefur fleiri, fjarlægir hann eitt auka peð og viðheldur mismuni upp á eitt peð. Ef aðeins einn býr til myllu, fjarlægir hann tvö peð en hinn eitt. Ef hvorugur býr til myllu, fjarlægja báðir eitt peð.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Veldu einn af þínum peðum.';

  @override
  String get notYourTurn => 'Þetta er ekki þín umferð.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Bakgrunnslitur athugasemda tólastiku';

  @override
  String get annotationToolbarIconColor =>
      'Litir táknmynda athugasemda tólastiku';

  @override
  String get isAnnotationToolbarShown => 'Sýna athugasemda tólastiku';

  @override
  String get enterAnnotationMode => 'Fara í athugasemda ham';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Ertu viss um að þú viljir hreinsa allar athugasemdir?';

  @override
  String get llmPromptCopiedToClipboard => 'LLM boðorð afritað á klippiborð.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Tenging hafnað, þjónninn gæti verið niðri.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Uppgötvun tókst, bíð eftir tengingu...';

  @override
  String get noLanConnection => 'Engin staðarnetstenging';

  @override
  String get takeScreenshot => 'Taka skjáskot';

  @override
  String get disconnectedFromOpponent => 'Aftengt frá andstæðingi.';

  @override
  String get takeBackRequest => 'Taka til baka beiðni';

  @override
  String get nothingToShow => 'Ekkert til að sýna.';

  @override
  String get stopHosting => 'Hætta að hýsa';

  @override
  String get connectionResetByPeer => 'Tenging endurstillt af jafningja.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Tenging tapað vegna hjartsláttar tímatakmarks. Vinsamlegast tengdu aftur.';

  @override
  String get startHosting => 'Byrja að hýsa';

  @override
  String get restartRequestRejected => 'Endurræsing beiðni hafnað.';

  @override
  String get notConnectedToLanOpponent =>
      'Ekki tengdur við staðarnet andstæðing.';

  @override
  String get llmPrompt => 'LLM boðorð';

  @override
  String get gameRestarted => 'Leikur endurræstur.';

  @override
  String get takeBackRejected => 'Taka til baka hafnað.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Ertu viss um að þú viljir gefast upp á þessum leik?';

  @override
  String get opponentResignedYouWin => 'Andstæðingurinn gafst upp. Þú vinnur!';

  @override
  String get clearAllAnnotations => 'Hreinsa allar athugasemdir';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Tengdur, bíð eftir hreyfingu andstæðings...';

  @override
  String get networkStatusDisconnected => 'Netstaða: Aftengt';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Taka til baka beiðni send til andstæðings.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'Andstæðingurinn gæti hafa yfirgefið leikinn';

  @override
  String get connectedToHostSuccessfully =>
      'Tengdur við hýsinguna með góðum árangri.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Tenging tapað: hjartsláttar tímatakmark';

  @override
  String get noHostDiscovered => 'Engin hýsing uppgötvuð.';

  @override
  String get confirmResignation => 'Staðfesta uppgjöf';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Byrjaði að hýsa leik, bíð eftir leikmönnum til að taka þátt...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Tenging tímatakmark, netstenging óstöðug.';

  @override
  String get noLlmPromptAvailable => 'Ekkert LLM boðorð í boði.';

  @override
  String get youResignedGameOver => 'Þú gafst upp. Leikur lokið.';

  @override
  String get serverIp => 'Þjónn IP';

  @override
  String get confirmClear => 'Staðfesta hreinsun';

  @override
  String get opponentSTurn => 'Umferð andstæðings.';

  @override
  String get waitingAClientConnection => 'Bíð eftir tengingu viðskiptavinar...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Taka til baka beiðni var hafnað eða mistókst.';

  @override
  String get addText => 'Bæta við texta';

  @override
  String get exitAnnotationMode => 'Hætta úr athugasemda ham';

  @override
  String get typeYourAnnotation => 'Sláðu inn athugasemd þína';

  @override
  String get attemptingToReconnect => 'Reyni að tengjast aftur...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Endurræsing beiðni send. Bíð eftir svari andstæðings...';

  @override
  String get serverIsStopped => 'Þjónninn er stoppaður.';

  @override
  String get restartRequest => 'Endurræsing beiðni';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Getur ekki beðið um að taka til baka þegar það er ekki þín umferð.';

  @override
  String get takeBackAccepted => 'Taka til baka samþykkt.';

  @override
  String get localNetworkSettings => 'Stillingar staðarnet';

  @override
  String get reconnectedSuccessfully => 'Tengdur aftur með góðum árangri!';

  @override
  String get failedToSaveImageToGallery => 'Mistókst að vista mynd í gallerí.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Andstæðingurinn bað um að endurræsa leikinn. Samþykkir þú?';

  @override
  String get yourTurn => 'Þín umferð.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Get ekki tengst aftur, vinsamlegast endurræstu leikinn.';

  @override
  String get host => 'Hýsing';

  @override
  String get join => 'Taka þátt';

  @override
  String get port => 'Hafn';

  @override
  String get invalidIpAddress => 'Ógilt IP tala.';

  @override
  String get invalidPort => 'Ógilt hafn.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Tengist: Tilraun $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Mistókst að tengjast: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Mistókst að byrja að hýsa: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Hýsing uppgötvuð: $ip:$port';
  }

  @override
  String get stop => 'Stöðva';

  @override
  String get discover => 'Uppgötva';

  @override
  String get connect => 'Tengjast';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Viðskiptavinur tengdur: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Uppgötvar: $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Tengist aftur ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Tengdur';

  @override
  String get delete => 'Eyða';

  @override
  String get ancientEgypt => 'Forn-Egyptaland';

  @override
  String get gothicIce => 'Gotneskur Ís';

  @override
  String get riceField => 'Hrísgrjónaakur';

  @override
  String get chinesePorcelain => 'Kínverskt Postulín';

  @override
  String get desertDusk => 'Eyðimerkurrokkr';

  @override
  String get precisionCraft => 'Nákvæmnisverk';

  @override
  String get folkEmbroidery => 'Þjóðbúningasaumur';

  @override
  String get carpathianHeritage => 'Karpatískar Erfðir';

  @override
  String get imperialGrandeur => 'Keisaralegur Dýrð';

  @override
  String get bohemianCrystal => 'Bæheimskur Kristall';

  @override
  String get savannaSunrise => 'Savanna Sólarupprás';

  @override
  String get harmonyBalance => 'Samhljómur og Jafnvægi';

  @override
  String get cinnamonSpice => 'Kanill Krydd';

  @override
  String get anatolianMosaic => 'Anatólískt Mósaík';

  @override
  String get carnivalSpirit => 'Karnival Andi';

  @override
  String get custom => 'Sérsniðin';

  @override
  String get spiceMarket => 'Kryddmarkaður';

  @override
  String get swipeToRevealTheDrawer => 'Strjúktu til að sýna skúffuna';

  @override
  String get showGameInfoOnScreenshots =>
      'Sýna upplýsingar um leik á skjámyndum';

  @override
  String get humanMoveTime => 'Tímamörk manna';

  @override
  String get noTimeLimitForHumanMoves => 'Engin tímamörk fyrir mannlega leiki';

  @override
  String get timeoutLoseWillBeApplied =>
      'Tímamarkatap verður beitt fyrir mannlegan spilara';

  @override
  String get identifyingBoard => 'Að bera kennsl á leikborðið...';

  @override
  String get youCanEnterAnyModelName =>
      'Þú getur slegið inn hvaða nafn líkans sem er.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Staða leikborðsins beitt. FEN afrituð í úrklippuborð.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Tillaga: reyndu að taka skarpari mynd af leikborðinu.';

  @override
  String get llmPromptTemplate => 'LLM prompt‑sniðmát';

  @override
  String get noValidBoardDetected => 'Ekkert gilt leikborð fannst.';

  @override
  String get selectingImageFromAlbum => 'Velja mynd úr albúmi...';

  @override
  String get configurePromptTemplate => 'Stilla prompt‑sniðmát';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Breyta prompt‑sniðmáti fyrir LLM greiningu';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Mistókst að búa til FEN úr viðurkenndu leikborði.';

  @override
  String get outputInCurrentLanguage => 'Úttak á núverandi tungumáli';

  @override
  String get commonBaseUrls => 'Algengar Base URL‑ur';

  @override
  String get viewCommonModels => 'Skoða algeng líkön';

  @override
  String get recognitionParametersUpdated =>
      'Viðurkenningarparametrar uppfærðir.';

  @override
  String get whiteSMove => 'Hvítur á leik';

  @override
  String get resetToDefaults => 'Endurstilla í sjálfgefin gildi';

  @override
  String get photoShoot => 'Ljósmyndun';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Mistókst að beita viðurkenndri stöðu á leikborði.';

  @override
  String get llmPromptContent => 'LLM prompt‑efni';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM ekki stillt. Athugaðu stillingarnar þínar.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Stilla veitanda, líkan, API Key og Base URL';

  @override
  String get llmConfiguration => 'LLM stillingar';

  @override
  String get configureLlmProvider => 'Stilla LLM veitanda';

  @override
  String get llmPromptTemplateHeader => 'Yfirskrift LLM prompt‑sniðmáts';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Engir steinar greindust í myndinni. Reyndu aftur.';

  @override
  String get recognizeBoardFromImage => 'Greina leikborð úr mynd';

  @override
  String get viewTips => 'Skoða ráð';

  @override
  String get applyToBoard => 'Beita á leikborð';

  @override
  String get adjustBoardArea => 'Stilla svæði á leikborði';

  @override
  String get viewCommonUrls => 'Skoða algengar URL‑ur';

  @override
  String get colorAnalysisFailed => 'Litagreining mistókst!';

  @override
  String get analyzingGameBoardImage => 'Greini mynd af leikborði...';

  @override
  String get selectFromAlbum => 'Velja úr albúmi';

  @override
  String get noBoardPointDetected => 'Enginn leikborðspunktur fannst!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Ef skilið autt, verður sjálfgefið sniðmát notað';

  @override
  String get llmConfig => 'LLM stillingar';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Ertu viss um að þú viljir endurstilla prompt‑sniðmát í sjálfgefin gildi?';

  @override
  String get llmPromptTemplateFooter => 'LLM prompt‑sniðmát fótur';

  @override
  String get loadingResponse => 'Sæki svarið...';

  @override
  String get applyThisResultToBoard => 'Beita þessari niðurstöðu á leikborðið';

  @override
  String get takingPicture => 'Taka mynd...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Vinsamlegast veldu mynd af leikborði til greiningar';

  @override
  String get identificationResults => 'Niðurstöður greiningar';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Greindu leikskrefin og gefðu innsýn.';

  @override
  String get getApiKey => 'Sækja API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Allur greiningarferillinn mistókst að ljúka.';

  @override
  String get boardRecognitionResult => 'Niðurstaða greiningar á leikborði';

  @override
  String get askLlm => 'Spyrðu LLM';

  @override
  String get boardDetectionFailed => 'Uppgötvun leikborðs mistókst!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Enginn punktur á leikborði fannst, ekki er hægt að bera kennsl á steina!';

  @override
  String get copyFen => 'Afrita FEN';

  @override
  String get commonlyUsedModels => 'Algeng líkön';

  @override
  String get apiKeyOptional => 'API Key (valfrjálst)';

  @override
  String get noImageSelected => 'Engin mynd valin';

  @override
  String get blackSMove => 'Svartur á leik';

  @override
  String get llm => 'Stórt tungumálalíkan';

  @override
  String get llmProvider => 'Þjónustuaðili';

  @override
  String get baseUrl => 'Grunnslóð';

  @override
  String get model => 'Líkan';

  @override
  String get temperature => 'Hitastig';

  @override
  String get llmCommandReceivedProcessing =>
      'Skipun móttekin! Gervigreind vinnur...';

  @override
  String get llmDeepThinkingWait =>
      'Djúp hugsun í gangi, vinsamlegast bíðið...';

  @override
  String get llmPresentingSoon => 'Verður kynnt bráðlega...';

  @override
  String get recognitionParameters => 'Viðurkenningarbreytur';

  @override
  String get adjustParamsDesc =>
      'Stilltu breytur til að bæta nákvæmni viðurkenningar';

  @override
  String get saveParameters => 'Vista breytur';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Ekki tókst að ræsa myndgreiningu: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Myndgreining mistókst: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Staða sett með $whiteCount hvítum og $blackCount svörtum peðum';
  }

  @override
  String get fenCopiedToClipboard => '(FEN afritað á klippiborðið)';

  @override
  String recognitionFailed(String error) {
    return 'Viðurkenning mistókst: $error';
  }

  @override
  String get myRating => 'Mín einkunn';

  @override
  String get gamesPlayed => 'Spilaðir leikir';

  @override
  String get wins => 'Sigrar';

  @override
  String get losses => 'Töp';

  @override
  String get draws => 'Jafntefli';

  @override
  String get lastUpdated => 'Síðast uppfært';

  @override
  String get format => 'Snið:';

  @override
  String get resetStatistics => 'Endurstilla tölfræði';

  @override
  String get drawRate => 'Jafnteflishlutfall';

  @override
  String get lossRate => 'Taphlutfall';

  @override
  String get aiStatistics => 'Gervigreindartölfræði';

  @override
  String get enableStatistics => 'Virkja tölfræði';

  @override
  String get enableStatistics_Detail =>
      'Þegar virkjað er verða niðurstöður leikja skráðar í tölfræði. Leikir sem fela í sér að taka til baka leiki verða þó ekki skráðir. Þegar óvirkjað er er söfnun tölfræðinnar í bið.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Þetta mun endurstilla alla leikjatölfræði. Ekki er hægt að afturkalla þessa aðgerð.';

  @override
  String get boardInnerRingSize => 'Stærð innri hrings borðsins';

  @override
  String get boardShadowEnabled => 'Borðskuggi';

  @override
  String get trapAwareness => 'Gildruvitund';

  @override
  String get trapAwarenessDescription =>
      'Lýstu gildruhreyfingum með þykkum hringjum og örvum meðan á greiningu stendur.';

  @override
  String trapExists(String trapMoves) {
    return 'Gildra er til staðar. Gildruhreyfingar: $trapMoves';
  }

  @override
  String get custodianCapture => 'Flanking handtaka';

  @override
  String get custodianCaptureDescription =>
      'Lokaðu einum af verkum andstæðingsins á milli tveggja ykkar í beinni línu til að fanga það.';

  @override
  String get custodianCaptureEnable => 'Leyfa flanking';

  @override
  String get interventionCapture => 'Íhlutun handtaka';

  @override
  String get interventionCaptureDescription =>
      'Farðu inn í tóma punktinn milli tveggja stykki andstæðingsins til að fanga þá báða.';

  @override
  String get interventionCaptureEnable => 'Leyfa íhlutun';

  @override
  String get leapCapture => 'Handtaka með því að stökkva';

  @override
  String get leapCaptureDescription =>
      'Handtaka með því að hoppa yfir stykki aðliggjandi andstæðings í tóma punktinn handan.';

  @override
  String get leapCaptureEnable => 'Leyfa stökkupptöku';

  @override
  String get captureApplicableLines => 'Viðeigandi línur';

  @override
  String get captureSquareEdges => 'Meðfram brúnum torgsins';

  @override
  String get captureCrossLines =>
      'Meðfram rétthyrndum línum sem fara yfir torgið';

  @override
  String get captureDiagonalLines => 'Meðfram ská línum sem fara yfir torgið';

  @override
  String get captureExecutionPhases => 'Framkvæmd stig';

  @override
  String get capturePiecesCondition =>
      'Framboð á hreyfingunni sem byggist á verkum sem eftir eru';

  @override
  String get capturePiecesConditionUnlimited => 'Engin takmörkun';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Í boði þegar þú ert með þrjú eða færri stykki';
}
