// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Indonesian (`id`).
class SId extends S {
  SId([String locale = 'id']) : super(locale);

  @override
  String get appName => 'Mul-mulan';

  @override
  String get welcome => 'Selamat datang';

  @override
  String get yes => 'Iya';

  @override
  String get no => 'Tidak';

  @override
  String get game => 'Permainan';

  @override
  String get humanVsAi => 'Manusia Vs. AI';

  @override
  String get humanVsHuman => 'Manusia Vs. Manusia';

  @override
  String get aiVsAi => 'AI Vs. AI';

  @override
  String get humanVsCloud => 'Manusia Vs. Cloud';

  @override
  String get humanVsLAN => 'Manusia Vs. LAN';

  @override
  String get testViaLAN => 'Tes Melalui LAN';

  @override
  String get move => 'Pindah';

  @override
  String get showMoveList => 'Daftar gerakan';

  @override
  String get moveList => 'Daftar gerakan';

  @override
  String get noGameRecord => 'Tidak ada catatan';

  @override
  String get ok => 'OK';

  @override
  String get confirm => 'Konfirmasi';

  @override
  String get cancel => 'Batalkan';

  @override
  String get tipSelectWrong => 'Pilih bagian yang salah.';

  @override
  String get tipPlace => 'Tempatkan potongan Anda.';

  @override
  String get tipBanPlace => 'Anda tidak dapat menempatkannya di sini.';

  @override
  String get tipPlaced => 'Telah ditempatkan.';

  @override
  String get tipRemove => 'Hapus satu bidak.';

  @override
  String get tipBanRemove => 'Anda tidak dapat menghapusnya.';

  @override
  String get tipRemoved => 'Telah dihapus.';

  @override
  String get tipMove => 'Pindahkan sepotong.';

  @override
  String get tipCannotPlace =>
      'Anda tidak dapat menempatkan bagian Anda di sini.';

  @override
  String get tipCannotMove =>
      'Anda tidak dapat memindahkan bagian Anda di sini.';

  @override
  String get tipMill => 'Mul! Ambil bidak lawan.';

  @override
  String get tipContinueMill => 'Lanjutkan mengambil bidak lawan.';

  @override
  String get tipSelectOpponentsPiece => 'Pilih salah satu bidak lawan.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Anda tidak dapat menghapus sepotong dari penggilingan.';

  @override
  String get tipCanMoveOnePoint => 'Sebuah bidak dapat bergerak 1 poin.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Anda tidak dapat memindahkan bidak lawan.';

  @override
  String get tipSelectPieceToMove => 'Pilih bidak Anda untuk dipindahkan.';

  @override
  String get tipHaveThreePiecesLeft => 'Anda memiliki tiga potong tersisa.';

  @override
  String get tipCanMoveToAnyPoint =>
      'Anda dapat pindah ke titik mana pun yang Anda suka.';

  @override
  String tipToMove(Object player) {
    return '$player bergerak.';
  }

  @override
  String get whiteWin => 'Player 1 menang!';

  @override
  String get blackWin => 'Player 2 menang!';

  @override
  String get won => 'Menang';

  @override
  String get lost => 'Kalah';

  @override
  String get thinking => 'Berpikir…';

  @override
  String get newGame => 'Permainan baru';

  @override
  String get importGame => 'Impor game';

  @override
  String get exportGame => 'Ekspor game';

  @override
  String get gameImported => 'Permainan diimpor.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Tidak dapat mengimpor $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'Gerakan dan aturan tidak cocok.';

  @override
  String get pleaseWait => 'Tunggu sebentar.';

  @override
  String get restartGame => 'Mulai ulang game saat ini?';

  @override
  String get restart => 'Mulai Ulang';

  @override
  String get gameStarted => 'Permainan dimulai, silakan tempat.';

  @override
  String get analyzing => 'Menganalisa…';

  @override
  String error(Object message) {
    return 'Error: $message';
  }

  @override
  String get winRate => 'Tingkat Kemenangan';

  @override
  String get score => 'Skor:';

  @override
  String get white => 'Pemain 1';

  @override
  String get black => 'Pemain 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player jumlah potongan kurang dari tiga.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player menyerah.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player tidak ada jalan lain.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Papan sudah penuh, dan $player tidak ada jalan lagi.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Waktu telah berakhir, $player kalah.';
  }

  @override
  String get drawReasonRule50 =>
      'Dalam fase bergerak, tidak ada bidak yang dikeluarkan dalam jumlah gerakan spesifik terakhir.';

  @override
  String get drawReasonBoardIsFull => 'Ini adalah Seri karena papan penuh.';

  @override
  String get drawReasonThreefoldRepetition =>
      'Ini adalah Seri karena pengulangan tiga kali lipat.';

  @override
  String get gameOverUnknownReason =>
      'Permainan berakhir! Alasannya tidak diketahui.';

  @override
  String get gameOver => 'Permainan telah berakhir';

  @override
  String get youWin => 'Kamu menang! Selamat!';

  @override
  String challengeHarderLevel(int level) {
    return 'Tantang level yang lebih sulit? Level baru akan menjadi level $level!';
  }

  @override
  String get youLose => 'Kamu kalah!';

  @override
  String get analyze => 'Menganalisa';

  @override
  String get about => 'Tentang';

  @override
  String version(Object versionNumber) {
    return 'Versi: $versionNumber';
  }

  @override
  String get thanks => 'Terima kasih';

  @override
  String get settings => 'Pengaturan';

  @override
  String get options => 'Opsi';

  @override
  String get generalSettings => 'Pengaturan Umum';

  @override
  String get skillLevel => 'Tingkat kesulitan';

  @override
  String get moveTime => 'waktu berpikir AI';

  @override
  String get difficulty => 'Kesulitan';

  @override
  String get playSounds => 'Efek suara';

  @override
  String get playSoundsInTheGame => 'Mainkan suara dalam permainan';

  @override
  String get keepMuteWhenTakingBack => 'Tetap bisu saat mengambil kembali';

  @override
  String get tone => 'Nada';

  @override
  String get whoMovesFirst => 'Langkah pertama';

  @override
  String get human => 'Manusia';

  @override
  String get ai => 'AI';

  @override
  String get alternate => 'Alternatif';

  @override
  String get isAutoRestart =>
      'Mulai ulang permainan secara otomatis saat permainan berakhir';

  @override
  String get isAutoChangeFirstMove => 'Ubah Otomatis Langkah Pertama';

  @override
  String get shufflingEnabled => 'Gerakan acak';

  @override
  String get misc => 'Lainnya';

  @override
  String get rules => 'Aturan';

  @override
  String get piecesCount => 'Jumlah bidak yang dimiliki setiap pemain';

  @override
  String get piecesCount_Detail => 'Berapa bagian yang dimiliki setiap pemain?';

  @override
  String get flyPieceCount => 'Jumlah potongan terbang';

  @override
  String get flyPieceCount_Detail =>
      'Jika Terbang diaktifkan, ketika seorang pemain dikurangi menjadi jumlah bidak tertentu, bidaknya bebas untuk berpindah ke titik kosong mana pun alih-alih dibatasi ke poin yang berdekatan seperti di sisa permainan.';

  @override
  String get piecesAtLeastCount => 'Potongan Setidaknya';

  @override
  String get hasDiagonalLines => 'Garis diagonal';

  @override
  String get hasDiagonalLines_Detail =>
      'Tambahkan empat garis diagonal ke papan.';

  @override
  String get isDefenderMoveFirst => 'Pemain kedua bergerak terlebih dahulu';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Pemain yang bergerak kedua di fase penempatan bergerak pertama di fase bergerak.';

  @override
  String get mayRemoveMultiple => 'Multi-hapus';

  @override
  String get mayRemoveMultiple_Detail =>
      'Jika seorang pemain menutup lebih dari satu penggilingan sekaligus, dia akan menghapus jumlah penggilingan yang dia tutup.';

  @override
  String get mayRemoveFromMillsAlways => 'Hancurkan mul';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Secara default, pemain harus mengeluarkan bidak lain terlebih dahulu sebelum mengeluarkan bidak dari penggilingan yang terbentuk. Aktifkan opsi ini untuk menonaktifkan batasan.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Pemain kedua kalah saat papan penuh';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Ketika papan penuh pada akhir fase penempatan, pihak yang menempatkan pertama kalah dalam permainan. Jika tidak, permainannya seri.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Kalah ketika tidak ada langkah hukum';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Pemain akan kalah jika lawannya menghalanginya sehingga tidak bisa digerakkan. Ubah sisi untuk bergerak jika opsi ini dinonaktifkan.';

  @override
  String get mayFly => 'Penerbangan';

  @override
  String get mayFly_Detail =>
      'Jika seorang pemain hanya memiliki tiga atau empat bidak (yang dapat dikonfigurasi), dia dapat memindahkan bidak tersebut ke titik bebas mana pun.';

  @override
  String get nMoveRule => 'Aturan gerakan-N';

  @override
  String get nMoveRule_Detail =>
      'Permainan ditarik jika tidak ada penghapusan dalam jumlah gerakan tertentu oleh setiap pemain.';

  @override
  String get rollback => 'Kembalikan';

  @override
  String get pleaseSelect => 'Silahkan pilih';

  @override
  String get copy => 'Salin';

  @override
  String get moveHistoryCopied =>
      'Riwayat gerakan telah disalin ke papan klip.';

  @override
  String get help => 'Tolong';

  @override
  String get feedback => 'Umpan balik';

  @override
  String get exit => 'keluar';

  @override
  String get ruleSettings => 'Pengaturan Aturan';

  @override
  String get color => 'Warna';

  @override
  String get boardColor => 'Warna papan';

  @override
  String get pieceColor => 'Warna potongan';

  @override
  String get backgroundColor => 'Warna latar belakang';

  @override
  String get lineColor => 'Warna garis papan';

  @override
  String get whitePieceColor => 'Pemain 1 buah warna';

  @override
  String get blackPieceColor => 'Warna pemain 2 buah';

  @override
  String get messageColor => 'Warna pesan';

  @override
  String get isPieceCountInHandShown => 'Tunjukkan jumlah potongan di tangan';

  @override
  String get isNotationsShown => 'Tampilkan notasi di papan';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Tampilkan bilah alat navigasi riwayat';

  @override
  String get display => 'Tampilan';

  @override
  String get boardBorderLineWidth => 'Lebar garis batas papan';

  @override
  String get boardInnerLineWidth => 'Lebar garis dalam papan Board';

  @override
  String get pieceWidth => 'Lebar potongan';

  @override
  String get fontSize => 'Ukuran huruf';

  @override
  String get standardNotation => 'notasi WMD';

  @override
  String get restore => 'Mengembalikan';

  @override
  String get restoreDefaultSettings => 'Kembalikan pengaturan default';

  @override
  String pick(Object element) {
    return 'Pilih $element';
  }

  @override
  String get info => 'Info';

  @override
  String get hint => 'Petunjuk';

  @override
  String get player => 'pemain';

  @override
  String get player1 => 'Pemain 1';

  @override
  String get player2 => 'Pemain 2';

  @override
  String get howToPlay => 'Cara bermain';

  @override
  String get toPlacePiece =>
      'Ketuk titik mana pun yang tersedia untuk menempatkan potongan.';

  @override
  String get toSelectPiece => 'Ketuk sepotong untuk memindahkannya.';

  @override
  String get toMovePiece =>
      'Ketuk titik yang terhubung ke bagian untuk memindahkannya.';

  @override
  String get toRemovePiece => 'Ketuk salah satu bagian lawan untuk menghapus.';

  @override
  String get needToCreateMillFirst =>
      'Anda perlu membuat gilingan terlebih dahulu sebelum Anda dapat menghapus sepotong.';

  @override
  String get needToPlayWithOwnPieces => 'Anda harus bermain dengan bidak Anda.';

  @override
  String get statistics => 'Statistik';

  @override
  String get totalGames => 'Total permainan';

  @override
  String get results => 'Hasil';

  @override
  String get left => 'kiri';

  @override
  String get privacyPolicy => 'Kebijakan pribadi';

  @override
  String get privacyPolicy_Detail_1 =>
      'Harap baca dengan seksama dan pastikan Anda sepenuhnya memahami dan setuju dengan ini ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Jika Anda tidak setuju dengan Kebijakan ini, jangan gunakan Aplikasi ini. Menggunakan Aplikasi menyiratkan bahwa Anda menerima persyaratan ini.';

  @override
  String get and => ' dan ';

  @override
  String get accept => 'Menerima';

  @override
  String get takeBack => 'Ambil kembali';

  @override
  String get takingBack => 'Mengambil kembali…';

  @override
  String get waiting => 'Menunggu…';

  @override
  String get stepForward => 'Maju';

  @override
  String get takeBackAll => 'Ambil kembali semua';

  @override
  String get stepForwardAll => 'Maju semua';

  @override
  String get moveNow => 'Pindah sekarang';

  @override
  String get done => 'Selesai.';

  @override
  String get crackMill => 'Crack-mill';

  @override
  String get crackMill_Detail =>
      'Jika pemain hanya memiliki bidak di penggilingan, bidak di penggilingan tidak akan terkunci untuk dilepas.';

  @override
  String get animationDuration => 'Durasi animasi';

  @override
  String get none => 'Tidak ada';

  @override
  String get theme => 'Tema';

  @override
  String get helpContent =>
      'Permainan ini bertujuan untuk meninggalkan lawan dengan kurang dari tiga potong atau tidak ada gerakan hukum.\n\nPermainan secara otomatis menarik jika posisi terjadi untuk ketiga kalinya atau tidak menghapus dalam 100 gerakan terakhir (yang dapat dikonfigurasi).\n\nPermainan berlangsung dalam tiga fase:\n\n1. Menempatkan potongan di titik kosong\n2. Memindahkan potongan ke titik yang berdekatan\n3. (fase opsional) Memindahkan bidak ke titik kosong mana pun saat mengurangi pemain menjadi tiga bidak\n\nPenempatan\n\nPermainan dimulai dengan papan kosong, yang terdiri dari kotak dengan dua puluh empat poin. Pemain bergiliran menempatkan bidak mereka di titik kosong sampai setiap pemain menempatkan semua bidak di papan. Jika seorang pemain dapat menempatkan tiga bidaknya secara lurus, ia memiliki \"mill\" dan dapat mengeluarkan salah satu bidak lawannya dari papan.\n\nDalam beberapa aturan, pemain harus mengeluarkan bidak lain terlebih dahulu sebelum mengeluarkan bidak dari penggilingan yang terbentuk.\n\nAnda tidak dapat menempatkan potongan ke titik potongan yang dihapus lagi dalam fase penempatan dalam beberapa aturan.\n\nSetelah menggunakan semua bidak, pemain bergiliran bergerak.\n\nBergerak\n\nUntuk bergerak, seorang pemain memindahkan salah satu bidaknya di sepanjang garis papan ke titik kosong yang berdekatan. Jika dia tidak bisa melakukannya, dia kalah dalam permainan. Seperti pada fase penempatan, seorang pemain yang menyejajarkan tiga bidaknya pada garis papan memiliki gilingan dan boleh mengeluarkan salah satu bidak lawannya. Setiap pemain mengurangi menjadi dua bagian, tidak memiliki pilihan untuk membentuk mul baru, dan dengan demikian kehilangan permainan. Seorang pemain juga bisa kalah ketika lebih dari tiga buah jika lawannya menghalangi mereka untuk bergerak.\n\nPenerbangan\n\nDalam beberapa varian aturan, setelah pemain hanya memiliki tiga bidak yang tersisa, bidaknya dapat terbang, melompat, atau melompat ke titik kosong mana pun, tidak hanya yang berdekatan.';

  @override
  String get versionInfo => 'Informasi versi';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'Lisensi';

  @override
  String get sourceCode => 'Kode sumber';

  @override
  String get appVersion => 'Versi Aplikasi';

  @override
  String get general => 'Umum';

  @override
  String get advanced => 'Maju';

  @override
  String get placing => 'Penempatan';

  @override
  String get moving => 'Bergerak';

  @override
  String get removing => 'Menghapus';

  @override
  String get gameOverCondition => 'Kondisi game over';

  @override
  String get aisPlayStyle => 'Gaya bermain AI';

  @override
  String get passive => 'Pasif';

  @override
  String get timeout => 'Waktu habis';

  @override
  String get appearance => 'Penampilan';

  @override
  String get drawOnHumanExperience => 'Menggambar pada pengalaman manusia';

  @override
  String get considerMobility => 'Pertimbangkan mobilitas potongan';

  @override
  String get pieceCount => 'Jumlah potongan:';

  @override
  String inHand(Object player, int count) {
    return '$player di tangan: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player di pesawat: $count';
  }

  @override
  String get boardTop => 'Papan offset dari atas';

  @override
  String get notAIsTurn => 'Ini bukan giliran AI.';

  @override
  String get aiIsNotThinking => 'AI tidak berpikir.';

  @override
  String get atEnd => 'Anda berada di akhir daftar pemindahan.';

  @override
  String get tapBackAgainToLeave => 'Ketuk kembali lagi untuk pergi.';

  @override
  String get more => 'Lebih';

  @override
  String get experimental => 'Ini adalah fitur eksperimental.';

  @override
  String get experiments => 'Eksperimen';

  @override
  String get ossLicenses => 'Lisensi sumber terbuka';

  @override
  String get language => 'Bahasa';

  @override
  String get defaultLanguage => 'Bahasa default';

  @override
  String get mayMoveInPlacingPhase =>
      'Potongan dapat bergerak dalam fase penempatan';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Tidak ada fase penempatan dan pemindahan yang berbeda, yaitu, para pemain dapat memutuskan pada setiap gerakan apakah mereka ingin menempatkan bidak di papan atau memindahkan salah satu bidak mereka (selama mereka memiliki bidak yang tersisa untuk ditempatkan).';

  @override
  String get drawerColor => 'Warna menu';

  @override
  String get drawerTextColor => 'Warna teks menu';

  @override
  String get drawerHighlightItemColor => 'Warna item sorotan menu';

  @override
  String get mainToolbarBackgroundColor =>
      'Warna latar belakang bilah alat utama';

  @override
  String get mainToolbarIconColor => 'Warna ikon bilah alat utama';

  @override
  String get navigationToolbarBackgroundColor =>
      'Warna latar belakang bilah alat navigasi';

  @override
  String get navigationToolbarIconColor => 'Warna ikon bilah alat navigasi';

  @override
  String get autoHideToolbar => 'Sembunyikan bilah alat secara otomatis';

  @override
  String get toolbarLocationOnScreen => 'Lokasi bilah alat di layar';

  @override
  String get top => 'Puncak';

  @override
  String get bottom => 'Bawah';

  @override
  String get center => 'Pusat';

  @override
  String get solidColor => 'Warna solid';

  @override
  String get picture => 'Gambar';

  @override
  String get chooseYourPicture => 'Pilih gambar Anda';

  @override
  String get light => 'Cahaya';

  @override
  String get dark => 'Gelap';

  @override
  String get themes => 'Tema';

  @override
  String get currentTheme => 'Tema saat ini';

  @override
  String get saveTheme => 'Simpan tema';

  @override
  String get showAnalysisGraph => 'Tampilkan grafik analisis';

  @override
  String get analysis => 'Analisis';

  @override
  String get saveGame => 'Simpan permainan';

  @override
  String get loadGame => 'Muat permainan';

  @override
  String get setupPosition => 'Posisi pengaturan';

  @override
  String get showLegalMoves => 'Tunjukkan langkah hukum';

  @override
  String get showLastMove => 'Tampilkan gerakan terakhir';

  @override
  String get showArrows => 'Tampilkan panah';

  @override
  String get pieces => 'Potongan';

  @override
  String get showAnalysis => 'Tampilkan analisis';

  @override
  String get threads => 'Utas';

  @override
  String get getInvolved => 'Terlibat';

  @override
  String get helpImproveTranslate => 'Bantu tingkatkan terjemahan';

  @override
  String get tutorial => 'tutorial';

  @override
  String get classicMill => 'Pabrik mul';

  @override
  String get mixedMill => 'mul Campuran';

  @override
  String get ceylonMill => 'mul Ceylon';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Mul mungkin rusak dan dibuat ulang berulang kali';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Jika seorang pemain memecahkan gilingan untuk segera membuat gilingan baru, pemain tersebut dapat memindahkan potongan tersebut kembali ke persimpangan awal pada langkah berikutnya jika pemain tersebut membuat gilingan baru.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Permainan dinyatakan seri jika seorang pemain memiliki tiga buah bidak dan setelah sepuluh gerakan tidak ada pemain yang mengambil bidak lawan';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Ketika seorang pemain turun menjadi tiga bagian, dan tidak ada pemain yang dapat menghapus bagian lawan dalam sepuluh gerakan, permainannya seri.';

  @override
  String get close => 'Menutup';

  @override
  String get whitePiece => 'Potongan putih';

  @override
  String get blackPiece => 'potongan hitam';

  @override
  String get emptyPoint => 'titik kosong';

  @override
  String get noPoint => 'Tidak ada poin';

  @override
  String get placingPhase => 'Menempatkan fase';

  @override
  String get movingPhase => 'Fase bergerak';

  @override
  String get flyingPhase => 'Fase terbang';

  @override
  String sideToMove(Object player) {
    return 'Sisi untuk bergerak: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Langkah terakhir: $move';
  }

  @override
  String get selected => 'Terpilih';

  @override
  String get accessibility => 'Aksesibilitas';

  @override
  String get screenReaderSupport => 'Dukungan pembaca layar';

  @override
  String get isDraw => 'Ini adalah undian!';

  @override
  String get draw => 'Seri';

  @override
  String get pieceHighlightColor => 'Warna sorot potongan';

  @override
  String get algorithm => 'algoritma';

  @override
  String get endgameNMoveRule => 'Aturan N-Move Endgame';

  @override
  String get endgameNMoveRule_Detail =>
      'Jika salah satu pemain hanya memiliki tiga bidak dan tidak ada pemain yang mengeluarkan bidak dalam gerakan tertentu, permainan dinyatakan seri.';

  @override
  String get drawReasonEndgameRule50 =>
      'Salah satu pemain hanya memiliki tiga bidak dan tidak ada pemain yang mengeluarkan bidak dalam gerakan tertentu.';

  @override
  String get threefoldRepetitionRule => 'Aturan pengulangan tiga kali lipat';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Permainan dinyatakan seri jika terjadi posisi untuk ketiga kalinya.';

  @override
  String get continueToMakeMove => 'Mul! Terus lakukan gerakan.';

  @override
  String get pointStyle => 'Gaya titik';

  @override
  String get pointWidth => 'Lebar titik';

  @override
  String get solid => 'Padat';

  @override
  String get hollow => 'Kosong';

  @override
  String get languageName => 'Indonesia';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count bergerak',
      one: '$count bergerak',
      zero: 'bergerak',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Pemuatan gagal.';

  @override
  String get filename => 'Nama file';

  @override
  String get browse => 'Jelajahi…';

  @override
  String get gameFiles => 'File permainan';

  @override
  String get gameSavedTo => 'Permainan disimpan ke';

  @override
  String get empty => 'Kosong';

  @override
  String get noMove => 'Tidak bergerak.';

  @override
  String get restoredPosition => 'Posisi awal dipulihkan.';

  @override
  String get clean => 'Membersihkan';

  @override
  String get cleanedUp => 'Dibersihkan.';

  @override
  String get remove => 'Menghapus';

  @override
  String get noPiecesCanBeRemoved =>
      'Tidak ada potongan yang bisa dihilangkan.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count pieces',
      one: '$count piece',
      zero: 'Piece',
    );
    return '$_temp0 perlu dihapus.';
  }

  @override
  String placedCount(int count) {
    return 'Ditemp. ($count)';
  }

  @override
  String get placedPieceCount =>
      'Jumlah potongan yang ditempatkan dalam fase penempatan.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'Pemain saat ini telah menempatkan bidak $count.';
  }

  @override
  String get notPlacingPhase =>
      'Tidak menempatkan fase, tidak dapat mengubahnya.';

  @override
  String get paste => 'Tempel';

  @override
  String get pasteDone => 'Pasta selesai.';

  @override
  String get cannotPaste => 'Tidak dapat menempel.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Tampilkan potongan yang tidak ditempatkan dan dihapus';

  @override
  String get fullScreen => 'Layar penuh';

  @override
  String get reopenToTakeEffect =>
      'Keluar dan buka kembali aplikasi agar pengaturan diterapkan.';

  @override
  String get forest => 'Hutan';

  @override
  String get desktopImage => 'Gambar Desktop';

  @override
  String get invalidPosition => 'Posisi tidak valid.';

  @override
  String get shareGIF => 'Bagikan GIF';

  @override
  String get pixelRatio => 'Rasio piksel';

  @override
  String get duration => 'Durasi';

  @override
  String get gameScreenRecorder => 'Perekam layar permainan';

  @override
  String get previous => 'Sebelumnya';

  @override
  String get next => 'Lanjut';

  @override
  String get skip => 'Melewati';

  @override
  String get gotIt => 'Mengerti';

  @override
  String get youCanModifyRules =>
      'Anda dapat mengubah aturan permainan di pengaturan aturan.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Anda dapat menggunakan roda tetikus untuk mengubah nilai di pemilih.';

  @override
  String get noTimeLimitForThinking =>
      'Waktu berpikir AI diatur ke 0 berarti tidak ada batasan waktu untuk berpikir.';

  @override
  String get whatIsMtdf =>
      'MTD(f) adalah bentuk modifikasi dari algoritme pencarian alfa-beta yang bertujuan untuk meningkatkan efisiensi dengan menggunakan kembali hasil pencarian antara dan menggunakan tebakan awal yang baik untuk mempersempit ruang pencarian.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Perlu diketahui bahwa penyesuaian waktu berpikir AI mungkin tidak sepenuhnya tepat. Waktu berpikir yang sebenarnya mungkin lebih pendek saat tingkat kesulitan diatur ke nilai yang lebih rendah dan mungkin lebih lama saat AI sedang berpikir saat waktu habis.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Jika Anda menyetel tingkat kesulitan tinggi tetapi tidak menambah waktu berpikir AI, tingkat kesulitan sebenarnya mungkin dibatasi ke nilai yang lebih rendah karena batasan waktu berpikir. Nilai sebenarnya dapat bervariasi berdasarkan performa mesin.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) adalah algoritma pencarian untuk menemukan langkah terbaik pada posisi tertentu. Ini adalah peningkatan algoritme alfa-beta dan menggunakan pencarian jendela nol atau nol untuk mengonfirmasi bahwa suatu langkah lebih buruk atau tidak lebih buruk daripada skor yang sudah aman dari variasi utama. PVS berfokus pada gerakan yang paling menjanjikan dan menghindari pencarian cabang suboptimal yang tidak perlu, yang membantu meningkatkan efisiensi pencarian.';

  @override
  String get whatIsAlphaBeta =>
      'Algoritma alpha-beta adalah algoritma pencarian untuk menemukan langkah terbaik. Ia menggunakan prinsip minimax dan dua nilai, alfa dan beta, untuk memangkas pohon pencarian dan meningkatkan efisiensi. Alpha mewakili skor minimum yang bisa didapat komputer, sedangkan beta mewakili skor maksimum yang bisa didapat lawannya. Algoritme membantu komputer membuat keputusan yang cerdas dan efisien dalam sebuah game.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Menurut pengalaman manusia, jika Anda mencoba untuk menang, Anda akan kalah. Alih-alih, bidik hasil imbang sebagai tujuan Anda dan hindari kekalahan. Amati lawan Anda dan dengan lembut pancing mereka ke posisi di mana mereka bisa membuat kesalahan. Ketika mereka menunjukkan kelemahan, raih kesempatan itu dan dorong dengan lembut untuk menang. Dengan cara ini, Anda bisa memenangkan permainan.';

  @override
  String get firstMoveDetail =>
      'Dalam permainan ini, pemain kedua lebih mudah menang dibandingkan dengan pemain pertama.';

  @override
  String get passiveDetail =>
      'Mengaktifkan opsi Pasif akan menyebabkan AI menjadi santai ketika memiliki keunggulan dalam posisinya, daripada secara agresif mencoba untuk menang secepat mungkin.';

  @override
  String get moveRandomlyDetail =>
      'Mengaktifkan opsi ini meningkatkan keacakan dan kesenangan game sambil menonaktifkannya dapat membantu mempelajari cara untuk mengalahkan AI.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Jika AI mempertimbangkan mobilitas bidaknya, itu tidak hanya bertujuan untuk menangkap bidak lawan secepat mungkin, tetapi juga mempertimbangkan untuk memblokir gerakan lawan dan mencegah mereka melakukan hal yang sama.';

  @override
  String get whenBoardIsFull => 'Saat papan penuh';

  @override
  String get whenBoardIsFull_Detail =>
      'Di akhir fase penempatan, sebelum fase bergerak dimulai, tindakan akan mengikuti jika papan sudah penuh dengan bidak.';

  @override
  String get sideToMoveRemovePiece =>
      'Pemain yang bergerak lebih dulu dalam fase bergerak menghilangkan salah satu bidak lawan.';

  @override
  String get agreeToDraw => 'Kedua belah pihak setuju untuk seri.';

  @override
  String get takeOpponentsPiece => 'Ambil salah satu bidak lawan.';

  @override
  String get firstPlayerLose => 'Pemain pertama kalah dalam permainan.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Pemain pertama dan kedua membuang salah satu bidak lawan.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Pemain kedua dan pertama membuang salah satu bidak lawan.';

  @override
  String get enteredFlyingPhase =>
      'Sekarang memasuki fase terbang, bidak lawan bisa melompat ke titik kosong mana pun di papan. Anda dapat mematikan aturan terbang di \"Pengaturan Aturan\".';

  @override
  String get whenStalemate => 'Ketika kebuntuan';

  @override
  String get whenStalemate_Detail =>
      'Tindakan apa yang terjadi jika tidak ada bagian yang dapat dipindahkan?';

  @override
  String get endWithStalemateLoss => 'Berakhir dengan kekalahan telak.';

  @override
  String get changeSideToMove => 'Ubah sisi untuk bergerak.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Hapus salah satu bidak lawan dan lakukan langkah selanjutnya.';

  @override
  String get endWithStalemateDraw => 'Berakhir dengan hasil imbang.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Hapus salah satu bidak lawan dan ubah sisi untuk bergerak.';

  @override
  String get aiResponseDelayTime => 'Waktu tunda respons AI';

  @override
  String get aiIsDelaying =>
      'AI saat ini sedang dalam fase respons tertunda. Harap tunggu beberapa saat sebelum melanjutkan.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Anda tidak dapat menghapus bagian yang tidak berdekatan.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'Jika menemui jalan buntu, bidak lawan yang berdekatan dengan milik Anda dapat dihilangkan, terlepas dari formasi gilingan.';

  @override
  String get whatIsMcts =>
      'MCTS adalah algoritme ramah-pemula yang membuat keputusan dengan menjelajahi dan mengevaluasi berbagai gerakan melalui simulasi.';

  @override
  String get goldenJade => 'Giok Emas';

  @override
  String get forestWood => 'Kayu Hutan';

  @override
  String get darkMystery => 'Misteri Gelap';

  @override
  String get midnightBlue => 'Biru Tengah Malam';

  @override
  String get greenForest => 'Hutan hijau';

  @override
  String get greenMeadow => 'Padang Rumput Hijau';

  @override
  String get stonyPath => 'Jalan berbatu';

  @override
  String get pastelPink => 'Merah Muda Pastel';

  @override
  String get turquoiseSea => 'Laut pirus';

  @override
  String get violetDream => 'Mimpi Ungu';

  @override
  String get mintChocolate => 'Cokelat Mint';

  @override
  String get skyBlue => 'Langit biru';

  @override
  String get playfulGarden => 'Taman Bermain';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Algoritme Analisis Retrograde menggunakan analisis retrograde multi-nilai untuk membangun database endgame dari berbagai posisi awal, lalu menerapkan database ini untuk mengoptimalkan gameplay. Pendekatan ini termasuk dalam kategori solusi Ultra-Kuat.';

  @override
  String get viewAlgorithmGuide =>
      'Apakah Anda ingin melihat panduan pengguna untuk algoritme ini?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Tampilkan indikator keunggulan posisi';

  @override
  String get usePerfectDatabase => 'Gunakan basis data yang sempurna';

  @override
  String get perfectDatabaseDescription =>
      'Aktifkan opsi ini untuk menggunakan database game sempurna yang dihasilkan melalui algoritma mutakhir. Fitur ini mengintegrasikan strategi pembukaan dan akhir permainan untuk menyarankan gerakan optimal. Ini adalah pilihan yang lebih disukai bagi pemain yang mencari tingkat presisi tertinggi dalam gameplay. Dibuat melalui teknik komputasi yang cermat, database ini dirancang untuk menawarkan solusi permainan yang hampir sempurna.\n\nCatatan: Jika AI gagal mengakses database, AI akan beralih ke algoritma konvensional untuk mengambil keputusan gameplay. Ketika database tersedia, \'Tingkat Kesulitan\' menjadi tidak ada duanya, dan \'Waktu Berpikir AI\' mengalami pengurangan drastis. Banyak pengaturan dalam opsi \'Gaya Bermain AI\' akan diganti, karena hasil database memiliki prioritas tertinggi.\n\nUntuk panduan tentang cara memanfaatkan database sempurna ini, klik di sini.';

  @override
  String get backgroundImage => 'Gambar latar belakang';

  @override
  String get whatIsRandom =>
      'Jika opsi \'Gunakan database sempurna\' tidak diaktifkan, pengaturan \'Acak\' menyebabkan AI memindahkan bidak secara acak tanpa menggunakan algoritme apa pun untuk memilih gerakan. Hal ini biasanya menghasilkan gameplay yang jauh lebih lemah. Sebaliknya, ketika \'Gunakan database sempurna\' diaktifkan, AI secara eksklusif mengandalkan \'Database Sempurna\' untuk mengambil keputusan, alih-alih memadukannya dengan algoritma AI tradisional. Dalam mode ini, pergerakan AI sepenuhnya didasarkan pada konten database, menghindari ketergantungan pada perhitungan real-time atau algoritma pencarian.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Singkirkan bidak lawan dari tangan mereka; lalu giliran lawan untuk menempatkan.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Saat membentuk mill selama tahap penempatan';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Singkirkan bidak lawan dari papan.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Singkirkan bidak lawan dari papan; lalu giliran lawan untuk menempatkan.';

  @override
  String get opponentRemovesOwnPiece =>
      'Lawan menyingkirkan bidaknya sendiri dari papan.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Alih-alih Anda mengambil tindakan, lawan memilih dan menyingkirkan bidaknya sendiri dari papan, secara efektif mengambil tindakan yang merugikan diri mereka sendiri.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Singkirkan bidak lawan dari tangan mereka; lalu giliran Anda untuk bergerak.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Singkirkan bidak dari tangan lawan. Jika, menurut pengaturan Multi-remove, beberapa bidak harus disingkirkan dan lawan tidak memiliki bidak yang tersisa di tangan, lanjutkan menyingkirkan bidak lawan dari papan. Lalu, giliran Anda untuk bergerak. Jika Anda terus membentuk mill, Anda dapat terus menyingkirkan bidak lawan.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Singkirkan bidak dari tangan lawan. Jika, menurut pengaturan Multi-remove, beberapa bidak harus disingkirkan dan lawan tidak memiliki bidak yang tersisa di tangan, lanjutkan menyingkirkan bidak lawan dari papan. Lalu giliran lawan untuk bergerak.';

  @override
  String get markAndDelayRemovingPieces =>
      'Tandai dan tunda penyingkiran bidak.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Selama tahap penempatan, bidak yang akan disingkirkan ditandai, dan untuk kedua pemain, tidak ada bidak baru yang dapat ditempatkan di titik-titik ini. Saat memasuki fase bergerak, bidak yang ditandai ini akan disingkirkan seluruhnya, dan pemain kemudian dapat memindahkan bidaknya ke titik-titik yang sekarang kosong ini.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Tindakan yang dapat diambil saat membentuk Mul-mulan selama fase penempatan.';

  @override
  String get marked => 'Ditandai';

  @override
  String get menu => 'Menu';

  @override
  String get monochrome => 'Monokrom';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Anda dapat mengaktifkan dukungan pembaca layar di pengaturan Aksesibilitas dalam Pengaturan Umum.';

  @override
  String get showNumbersOnPieces => 'Tampilkan angka pada bidak';

  @override
  String get saveImage => 'Simpan gambar';

  @override
  String get isAnalysisToolbarShown => 'Tampilkan Toolbar Analisis';

  @override
  String get analysisToolbarBackgroundColor =>
      'Warna Latar Belakang Toolbar Analisis';

  @override
  String get analysisToolbarIconColor => 'Warna Ikon Toolbar Analisis';

  @override
  String get transformed => 'Berubah.';

  @override
  String get cannotTransform => 'Tidak dapat mentransformasi.';

  @override
  String get rotate => 'Putar';

  @override
  String get horizontalFlip => 'H Balik';

  @override
  String get verticalFlip => 'V Balik';

  @override
  String get innerOuterFlip => 'IO Balik';

  @override
  String get transparentCanvas => 'Kanvas Transparan';

  @override
  String get restrictRepeatedMillsFormation =>
      'Batasi Pembentukan Mul-mulan Berulang';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Sebuah bidak yang dipindahkan dari satu Mul-mulan untuk membentuk Mul-mulan lain tidak bisa langsung kembali ke titik asal di giliran berikutnya untuk membentuk Mul-mulan lagi. Langkah yang berbeda diperlukan terlebih dahulu.';

  @override
  String get oneTimeUseMill => 'Penggunaan sekali waktu Mul-mulan';

  @override
  String get oneTimeUseMill_Detail =>
      'Setiap Mul-mulan dapat menghapus satu bagian lawan hanya sekali. Anda dapat membentuknya lagi, tetapi tidak dapat digunakan untuk penghapusan tambahan.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Aturan saat ini yang Anda tetapkan tidak memiliki database sempurna yang sesuai. Untuk informasi lebih lanjut tentang database sempurna, silakan klik di sini.';

  @override
  String get focusOnBlockingPaths => 'Fokus pada memblokir jalur';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Prioritaskan untuk menghalangi pergerakan lawan daripada membentuk kincir. Alih-alih fokus pada menghilangkan bidak dengan menyelesaikan kincir, AI bertujuan untuk menjebak lawan, membuat mereka tidak dapat bergerak dan memastikan kemenangan melalui keletihan daripada permainan agresif. Strategi ini tidak secara aktif menghalangi kincir lawan.';

  @override
  String get pieceImage => 'Gambar bidak';

  @override
  String get importColorSettings => 'Impor pengaturan warna';

  @override
  String get exportColorSettings => 'Ekspor pengaturan warna';

  @override
  String get import => 'Impor';

  @override
  String get export => 'Ekspor';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Silakan salin pengaturan format JSON ke clipboard terlebih dahulu.';

  @override
  String get copiedToClipboard => 'Disalin ke clipboard.';

  @override
  String get imported => 'Diimpor.';

  @override
  String get boardImage => 'Gambar papan';

  @override
  String get autumnLeaves => 'Daun-daun Musim Gugur';

  @override
  String get legendaryLand => 'Tanah Legendaris';

  @override
  String get vignetteEffect => 'Efek vinyet';

  @override
  String get promptMakeToolbarTransparent =>
      'Apakah Anda ingin membuat bilah alat sepenuhnya transparan ketika gambar latar belakang papan diatur?';

  @override
  String get vibration => 'Aktifkan getaran di dalam permainan';

  @override
  String get soundTheme => 'Tema suara';

  @override
  String get ball => 'Bola';

  @override
  String get liquid => 'Cairan';

  @override
  String get wood => 'Kayu';

  @override
  String get placeEffectAnimation => 'Efek animasi penempatan bidak';

  @override
  String get removeEffectAnimation => 'Efek animasi penghapusan bidak';

  @override
  String get isToolbarAtBottom => 'Tampilkan bilah alat di bagian bawah';

  @override
  String get boardCornerRadius => 'Radius sudut papan';

  @override
  String get useOpeningBook => 'Gunakan buku pembuka';

  @override
  String get currentRule => 'Saat ini';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Set peraturan';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'One-Time Mill';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'Izinkan AI menggunakan gerakan pembukaan yang biasa digunakan oleh pemain manusia profesional selama awal permainan. Catatan: Fitur ini saat ini hanya tersedia untuk set aturan tertentu.';

  @override
  String get showAdvantageGraph => 'Tampilkan grafik keunggulan';

  @override
  String get advantageGraphHint =>
      'Grafik keunggulan hanya akan digambar setelah AI membuat langkah. Grafik tidak akan digambar ketika pemain manusia membuat langkah.';

  @override
  String get removalBasedOnMillCounts =>
      'Nonaktifkan penghapusan hingga semua bidak ditempatkan. Pemain menghapus bidak berdasarkan jumlah Mul-mulan.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Nonaktifkan penghapusan hingga semua bidak ditempatkan. Pemain menghapus bidak berdasarkan jumlah Mul-mulan: jika sama, keduanya menghapus jumlah bidak yang sama; jika salah satu memiliki lebih, dia menghapus satu bidak tambahan, sehingga selisih tetap satu bidak. Jika hanya satu pemain yang membentuk Mul-mulan, dia menghapus dua bidak, sedangkan pemain lain menghapus satu. Jika tidak ada yang membentuk Mul-mulan, keduanya menghapus satu bidak.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Pilih salah satu bidak kamu.';

  @override
  String get notYourTurn => 'Bukan giliran Anda.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Warna latar belakang bilah alat anotasi';

  @override
  String get annotationToolbarIconColor => 'Warna ikon bilah alat anotasi';

  @override
  String get isAnnotationToolbarShown => 'Tampilkan bilah alat anotasi';

  @override
  String get enterAnnotationMode => 'Masuk mode anotasi';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Apakah Anda yakin ingin menghapus semua anotasi?';

  @override
  String get llmPromptCopiedToClipboard => 'Prompt LLM disalin ke clipboard.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Koneksi ditolak, server mungkin sedang down.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Penemuan berhasil, menunggu koneksi...';

  @override
  String get noLanConnection => 'Tidak ada koneksi LAN';

  @override
  String get takeScreenshot => 'Ambil Screenshot';

  @override
  String get disconnectedFromOpponent => 'Terputus dari lawan.';

  @override
  String get takeBackRequest => 'Permintaan Menarik Kembali';

  @override
  String get nothingToShow => 'Tidak ada yang ditampilkan.';

  @override
  String get stopHosting => 'Berhenti Menjadi Host';

  @override
  String get connectionResetByPeer => 'Koneksi direset oleh lawan.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Koneksi terputus karena timeout heartbeat. Silakan sambungkan kembali.';

  @override
  String get startHosting => 'Mulai Menjadi Host';

  @override
  String get restartRequestRejected => 'Permintaan restart ditolak.';

  @override
  String get notConnectedToLanOpponent => 'Tidak terhubung ke lawan LAN.';

  @override
  String get llmPrompt => 'Prompt LLM';

  @override
  String get gameRestarted => 'Permainan dimulai ulang.';

  @override
  String get takeBackRejected => 'Permintaan menarik kembali ditolak.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Apakah Anda yakin ingin mengundurkan diri dari permainan ini?';

  @override
  String get opponentResignedYouWin => 'Lawan mengundurkan diri. Anda menang!';

  @override
  String get clearAllAnnotations => 'Hapus semua anotasi';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Terhubung, menunggu langkah lawan...';

  @override
  String get networkStatusDisconnected => 'Status jaringan: Terputus';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Permintaan menarik kembali dikirim ke lawan.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'Lawan mungkin telah meninggalkan permainan';

  @override
  String get connectedToHostSuccessfully => 'Terhubung ke host berhasil.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Koneksi terputus: timeout heartbeat';

  @override
  String get noHostDiscovered => 'Tidak ada host yang ditemukan.';

  @override
  String get confirmResignation => 'Konfirmasi pengunduran diri';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Mulai menjadi host permainan, menunggu pemain untuk bergabung...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Koneksi habis waktu, koneksi jaringan tidak stabil.';

  @override
  String get noLlmPromptAvailable => 'Tidak ada prompt LLM yang tersedia.';

  @override
  String get youResignedGameOver =>
      'Anda mengundurkan diri. Permainan selesai.';

  @override
  String get serverIp => 'IP Server';

  @override
  String get confirmClear => 'Konfirmasi hapus';

  @override
  String get opponentSTurn => 'Giliran lawan.';

  @override
  String get waitingAClientConnection => 'Menunggu koneksi klien...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Permintaan menarik kembali ditolak atau gagal.';

  @override
  String get addText => 'Tambahkan teks';

  @override
  String get exitAnnotationMode => 'Keluar mode anotasi';

  @override
  String get typeYourAnnotation => 'Ketik anotasi Anda';

  @override
  String get attemptingToReconnect => 'Mencoba menyambungkan kembali...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Permintaan restart dikirim. Menunggu respons lawan...';

  @override
  String get serverIsStopped => 'Server dihentikan.';

  @override
  String get restartRequest => 'Permintaan restart';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Tidak dapat meminta menarik kembali saat bukan giliran Anda.';

  @override
  String get takeBackAccepted => 'Permintaan menarik kembali diterima.';

  @override
  String get localNetworkSettings => 'Pengaturan jaringan lokal';

  @override
  String get reconnectedSuccessfully => 'Berhasil menyambungkan kembali!';

  @override
  String get failedToSaveImageToGallery => 'Gagal menyimpan gambar ke Galeri.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Lawan meminta untuk memulai ulang permainan. Apakah Anda setuju?';

  @override
  String get yourTurn => 'Giliran Anda.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Tidak dapat menyambungkan kembali, silakan mulai ulang permainan.';

  @override
  String get host => 'Host';

  @override
  String get join => 'Bergabung';

  @override
  String get port => 'Port';

  @override
  String get invalidIpAddress => 'Alamat IP tidak valid.';

  @override
  String get invalidPort => 'Port tidak valid.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Menyambungkan: Percobaan $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Gagal menyambungkan: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Gagal memulai menjadi host: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Host ditemukan: $ip:$port';
  }

  @override
  String get stop => 'Berhenti';

  @override
  String get discover => 'Temukan';

  @override
  String get connect => 'Sambungkan';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Klien terhubung: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Mencari: $seconds d';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Menyambungkan kembali ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Terhubung';

  @override
  String get delete => 'Hapus';

  @override
  String get ancientEgypt => 'Mesir Kuno';

  @override
  String get gothicIce => 'Es Gotik';

  @override
  String get riceField => 'Ladang Padi';

  @override
  String get chinesePorcelain => 'Porselen Tiongkok';

  @override
  String get desertDusk => 'Senja Gurun';

  @override
  String get precisionCraft => 'Kerajinan Presisi';

  @override
  String get folkEmbroidery => 'Sulaman Rakyat';

  @override
  String get carpathianHeritage => 'Warisan Karpatia';

  @override
  String get imperialGrandeur => 'Kemegahan Kekaisaran';

  @override
  String get bohemianCrystal => 'Kristal Bohemia';

  @override
  String get savannaSunrise => 'Matahari Terbit Savana';

  @override
  String get harmonyBalance => 'Harmoni dan Keseimbangan';

  @override
  String get cinnamonSpice => 'Rempah Kayu Manis';

  @override
  String get anatolianMosaic => 'Mozaik Anatolia';

  @override
  String get carnivalSpirit => 'Semangat Karnaval';

  @override
  String get custom => 'Kebiasaan';

  @override
  String get spiceMarket => 'Pasar Rempah';

  @override
  String get swipeToRevealTheDrawer => 'Geser untuk membuka Laci';

  @override
  String get showGameInfoOnScreenshots =>
      'Tampilkan info permainan di tangkapan layar';

  @override
  String get humanMoveTime => 'Batas waktu manusia';

  @override
  String get noTimeLimitForHumanMoves =>
      'Tidak ada batas waktu untuk gerakan manusia';

  @override
  String get timeoutLoseWillBeApplied =>
      'Kalah karena batas waktu akan diterapkan untuk pemain manusia';

  @override
  String get identifyingBoard => 'Mengidentifikasi papan permainan...';

  @override
  String get youCanEnterAnyModelName =>
      'Anda dapat memasukkan nama model apa pun.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Posisi papan diterapkan. FEN disalin ke clipboard.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Saran: coba ambil foto papan permainan yang lebih jelas.';

  @override
  String get llmPromptTemplate => 'Template prompt LLM';

  @override
  String get noValidBoardDetected =>
      'Tidak ada papan permainan yang valid terdeteksi.';

  @override
  String get selectingImageFromAlbum => 'Memilih gambar dari album...';

  @override
  String get configurePromptTemplate => 'Konfigurasi template prompt';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Edit template prompt untuk analisis LLM';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Gagal menghasilkan FEN dari papan yang dikenali.';

  @override
  String get outputInCurrentLanguage => 'Keluaran dalam bahasa saat ini';

  @override
  String get commonBaseUrls => 'Base URL umum';

  @override
  String get viewCommonModels => 'Lihat model umum';

  @override
  String get recognitionParametersUpdated => 'Parameter pengenalan diperbarui.';

  @override
  String get whiteSMove => 'Giliran putih';

  @override
  String get resetToDefaults => 'Setel ulang ke default';

  @override
  String get photoShoot => 'Pemotretan';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Gagal menerapkan posisi papan yang dikenali.';

  @override
  String get llmPromptContent => 'Konten prompt LLM';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM belum dikonfigurasi. Periksa pengaturan Anda.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Atur penyedia, model, API Key, dan Base URL';

  @override
  String get llmConfiguration => 'Konfigurasi LLM';

  @override
  String get configureLlmProvider => 'Konfigurasi penyedia LLM';

  @override
  String get llmPromptTemplateHeader => 'Header template prompt LLM';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Tidak ada bidak yang dikenali dalam gambar. Silakan coba lagi.';

  @override
  String get recognizeBoardFromImage => 'Kenali papan permainan dari gambar';

  @override
  String get viewTips => 'Lihat tips';

  @override
  String get applyToBoard => 'Terapkan ke papan';

  @override
  String get adjustBoardArea => 'Sesuaikan area papan';

  @override
  String get viewCommonUrls => 'Lihat URL umum';

  @override
  String get colorAnalysisFailed => 'Analisis warna gagal!';

  @override
  String get analyzingGameBoardImage =>
      'Menganalisis gambar papan permainan...';

  @override
  String get selectFromAlbum => 'Pilih dari album';

  @override
  String get noBoardPointDetected => 'Tidak ada titik papan terdeteksi!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Jika dikosongkan, template default akan digunakan';

  @override
  String get llmConfig => 'Konfigurasi LLM';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Apakah Anda yakin ingin mengatur ulang template prompt ke nilai default?';

  @override
  String get llmPromptTemplateFooter => 'Footer template prompt LLM';

  @override
  String get loadingResponse => 'Memuat respons...';

  @override
  String get applyThisResultToBoard => 'Terapkan hasil ini ke papan';

  @override
  String get takingPicture => 'Mengambil gambar...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Silakan pilih gambar papan permainan untuk diidentifikasi';

  @override
  String get identificationResults => 'Hasil identifikasi';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Analisis langkah-langkah dan berikan wawasan.';

  @override
  String get getApiKey => 'Dapatkan API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Keseluruhan proses pengenalan gagal diselesaikan.';

  @override
  String get boardRecognitionResult => 'Hasil pengenalan papan';

  @override
  String get askLlm => 'Tanya LLM';

  @override
  String get boardDetectionFailed => 'Deteksi papan gagal!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Tidak ada titik papan terdeteksi, tidak dapat mengidentifikasi bidak!';

  @override
  String get copyFen => 'Salin FEN';

  @override
  String get commonlyUsedModels => 'Model yang sering digunakan';

  @override
  String get apiKeyOptional => 'API Key (opsional)';

  @override
  String get noImageSelected => 'Tidak ada gambar dipilih';

  @override
  String get blackSMove => 'Giliran hitam';

  @override
  String get llm => 'Model Bahasa Besar';

  @override
  String get llmProvider => 'Penyedia';

  @override
  String get baseUrl => 'URL Dasar';

  @override
  String get model => 'Model';

  @override
  String get temperature => 'Temperatur';

  @override
  String get llmCommandReceivedProcessing =>
      'Perintah diterima! AI sedang memproses...';

  @override
  String get llmDeepThinkingWait => 'Sedang berpikir mendalam, harap tunggu...';

  @override
  String get llmPresentingSoon => 'Akan segera ditampilkan...';

  @override
  String get recognitionParameters => 'Parameter pengenalan';

  @override
  String get adjustParamsDesc =>
      'Sesuaikan parameter untuk meningkatkan akurasi pengenalan';

  @override
  String get saveParameters => 'Simpan parameter';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Tidak dapat memulai pengenalan gambar: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Pengenalan gambar gagal: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Posisi diterapkan dengan $whiteCount bidak putih dan $blackCount bidak hitam';
  }

  @override
  String get fenCopiedToClipboard => '(FEN disalin ke papan klip)';

  @override
  String recognitionFailed(String error) {
    return 'Pengenalan gagal: $error';
  }

  @override
  String get myRating => 'Peringkat saya';

  @override
  String get gamesPlayed => 'Game dimainkan';

  @override
  String get wins => 'Menang';

  @override
  String get losses => 'Kalah';

  @override
  String get draws => 'Seri';

  @override
  String get lastUpdated => 'Terakhir diperbarui';

  @override
  String get format => 'Format:';

  @override
  String get resetStatistics => 'Setel ulang statistik';

  @override
  String get drawRate => 'Tingkat seri';

  @override
  String get lossRate => 'Tingkat kalah';

  @override
  String get aiStatistics => 'Statistik AI';

  @override
  String get enableStatistics => 'Aktifkan statistik';

  @override
  String get enableStatistics_Detail =>
      'Saat diaktifkan, hasil game akan dicatat dalam statistik. Namun, game yang melibatkan pengambilan kembali langkah tidak akan dicatat. Saat dinonaktifkan, pengumpulan statistik dijeda.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Ini akan menyetel ulang semua statistik game. Tindakan ini tidak dapat diurungkan.';

  @override
  String get boardInnerRingSize => 'Ukuran cincin dalam papan';

  @override
  String get boardShadowEnabled => 'Bayangan papan';

  @override
  String get trapAwareness => 'Deteksi jebakan';

  @override
  String get trapAwarenessDescription =>
      'Sorot langkah jebakan dengan lingkaran dan panah tebal saat analisis.';

  @override
  String trapExists(String trapMoves) {
    return 'Ada jebakan. Langkah jebakan: $trapMoves';
  }

  @override
  String get custodianCapture => 'Mengapit penangkapan';

  @override
  String get custodianCaptureDescription =>
      'Lampirkan salah satu bagian lawan Anda di antara dua Anda dalam garis lurus untuk menangkapnya.';

  @override
  String get custodianCaptureEnable => 'Izinkan penangkapan mengapit';

  @override
  String get interventionCapture => 'Gotong';

  @override
  String get interventionCaptureDescription =>
      'Letakkan atau geser bidak Anda ke titik kosong di antara dua bidak lawan dalam satu garis (vertikal, horizontal, atau diagonal) untuk menangkap keduanya.';

  @override
  String get interventionCaptureEnable => 'Izinkan penangkapan gotong';

  @override
  String get leapCapture => 'Lompat penangkapan';

  @override
  String get leapCaptureDescription =>
      'Tangkap dengan melompati bagian lawan yang berdekatan ke titik kosong di luar.';

  @override
  String get leapCaptureEnable => 'Izinkan penangkapan lompatan';

  @override
  String get captureApplicableLines => 'Baris yang berlaku';

  @override
  String get captureSquareEdges => 'Di sepanjang tepi alun -alun';

  @override
  String get captureCrossLines =>
      'Di sepanjang garis ortogonal melintasi alun -alun';

  @override
  String get captureDiagonalLines =>
      'Sepanjang garis diagonal melintasi alun -alun';

  @override
  String get captureExecutionPhases => 'Fase eksekusi';

  @override
  String get capturePiecesCondition =>
      'Ketersediaan selama fase bergerak berdasarkan potongan yang tersisa';

  @override
  String get capturePiecesConditionUnlimited => 'Tidak ada batasan';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Tersedia saat Anda memiliki tiga atau lebih sedikit keping';
}
