// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Armenian (`hy`).
class SHy extends S {
  SHy([String locale = 'hy']) : super(locale);

  @override
  String get appName => 'Ջրաղաց';

  @override
  String get welcome => 'Բարի գալուստ';

  @override
  String get yes => 'Այո՛';

  @override
  String get no => 'Ոչ';

  @override
  String get game => 'Խաղ';

  @override
  String get humanVsAi => 'Մարդն ընդդեմ. AI';

  @override
  String get humanVsHuman => 'Մարդն ընդդեմ. Մարդ';

  @override
  String get aiVsAi => 'AI ընդդեմ. AI';

  @override
  String get humanVsCloud => 'Մարդն ընդդեմ. Ամպ';

  @override
  String get humanVsLAN => 'Մարդն ընդդեմ. LAN';

  @override
  String get testViaLAN => 'Փորձարկել LAN-ի միջոցով';

  @override
  String get move => 'Քայլ';

  @override
  String get showMoveList => 'Տեղափոխել ցուցակը';

  @override
  String get moveList => 'Տեղափոխել ցուցակը';

  @override
  String get noGameRecord => 'Ոչ մի գրառում';

  @override
  String get ok => 'լավ';

  @override
  String get confirm => 'Հաստատել';

  @override
  String get cancel => 'Չեղարկել';

  @override
  String get tipSelectWrong => 'Ընտրեք սխալ խաղաքարը:';

  @override
  String get tipPlace => 'Տեղադրեք ձեր խաղաքարերը:';

  @override
  String get tipBanPlace => 'Դուք չեք կարող այն այստեղ տեղադրել:';

  @override
  String get tipPlaced => 'Տեղադրված է:';

  @override
  String get tipRemove => 'Հեռացրեք մի խաղաքար:';

  @override
  String get tipBanRemove => 'Դուք չեք կարող այն հեռացնել:';

  @override
  String get tipRemoved => 'Հեռացվել է:';

  @override
  String get tipMove => 'Տեղափոխեք մի խաղաքար:';

  @override
  String get tipCannotPlace => 'Դուք չեք կարող տեղադրել ձեր կտորը այստեղ:';

  @override
  String get tipCannotMove => 'Դուք չեք կարող ձեր կտորն այստեղ տեղափոխել:';

  @override
  String get tipMill => 'Ջրաղաց: Վերցրեք հակառակորդի խաղաքարը:';

  @override
  String get tipContinueMill => 'Շարունակեք վերցնել հակառակորդի խաղաքարը:';

  @override
  String get tipSelectOpponentsPiece => 'Ընտրեք հակառակորդի խաղաքարերից մեկը:';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Դուք չեք կարող խաղաքար հեռացնել ջրաղացից:';

  @override
  String get tipCanMoveOnePoint => 'Խաղաքարը կարող է շարժվել 1 կետ:';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Դուք չեք կարող շարժել ձեր հակառակորդի խաղաքարերը:';

  @override
  String get tipSelectPieceToMove => 'Ընտրեք ձեր խաղաքարը տեղաշարժելու համար:';

  @override
  String get tipHaveThreePiecesLeft => 'Ձեզ մնացել է երեք խաղաքար:';

  @override
  String get tipCanMoveToAnyPoint => 'Դուք կարող եք տեղափոխվել ցանկացած կետ:';

  @override
  String tipToMove(Object player) {
    return '$player տեղափոխվելու համար:';
  }

  @override
  String get whiteWin => 'Խաղացող 1-ը հաղթում է:';

  @override
  String get blackWin => 'Խաղացող 2-ը հաղթում է:';

  @override
  String get won => 'Հաղթեց';

  @override
  String get lost => 'Կորած';

  @override
  String get thinking => 'Մտածում…';

  @override
  String get newGame => 'Նոր խաղ';

  @override
  String get importGame => 'Ներմուծման խաղ';

  @override
  String get exportGame => 'Արտահանման խաղ';

  @override
  String get gameImported => 'Խաղը ներմուծված է.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Հնարավոր չէ ներմուծել $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'Շարժումները և կանոնները չեն համընկնում:';

  @override
  String get pleaseWait => 'Խնդրում ենք սպասել.';

  @override
  String get restartGame => 'Վերսկսե՞լ ընթացիկ խաղը:';

  @override
  String get restart => 'Վերսկսել';

  @override
  String get gameStarted => 'Խաղը սկսվեց, խնդրում եմ տեղադրել:';

  @override
  String get analyzing => 'Վերլուծվում է…';

  @override
  String error(Object message) {
    return 'Սխալ՝ $message';
  }

  @override
  String get winRate => 'Հաղթելու տոկոսադրույքը';

  @override
  String get score => 'Գնահատականը:';

  @override
  String get white => 'Խաղացող 1';

  @override
  String get black => 'Խաղացող 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player կտորների քանակը երեքից պակաս է:';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player-ը հրաժարական տվեց:';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player-ը ճանապարհ չունի գնալու:';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Տախտակը լիքն է, և $player-ը ճանապարհ չունի գնալու:';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Ժամանակն ավարտվել է, $player կորցրել է:';
  }

  @override
  String get drawReasonRule50 =>
      'Շարժվող փուլում ոչ մի կտոր չի հեռացվել վերջին կոնկրետ քանակի շարժումներում:';

  @override
  String get drawReasonBoardIsFull => 'Դա ոչ-ոքի է, քանի որ տախտակը լիքն է:';

  @override
  String get drawReasonThreefoldRepetition =>
      'Ոչ-ոքի է եռակի կրկնության պատճառով:';

  @override
  String get gameOverUnknownReason => 'Խաղն ավարտված է! Անհայտ պատճառ.';

  @override
  String get gameOver => 'Խաղն ավարտված է';

  @override
  String get youWin => 'Դու հաղթեցիր! Շնորհավորում եմ:';

  @override
  String challengeHarderLevel(int level) {
    return 'մարտահրավեր նետե՞լ ավելի դժվար մակարդակին: Նոր մակարդակը կլինի մակարդակը $level:';
  }

  @override
  String get youLose => 'Դու պարտվեցիր!';

  @override
  String get analyze => 'Վերլուծել';

  @override
  String get about => 'Մասին';

  @override
  String version(Object versionNumber) {
    return 'Տարբերակ՝ $versionNumber';
  }

  @override
  String get thanks => 'Շնորհակալություն';

  @override
  String get settings => 'Կարգավորումներ';

  @override
  String get options => 'Ընտրանք';

  @override
  String get generalSettings => 'Ընդհանուր կարգավորումներ';

  @override
  String get skillLevel => 'Դժվարության մակարդակ';

  @override
  String get moveTime => 'AI մտածելու ժամանակ';

  @override
  String get difficulty => 'Դժվարություն';

  @override
  String get playSounds => 'Ձայնային էֆեկտներ';

  @override
  String get playSoundsInTheGame => 'Խաղացեք հնչյուններ խաղի մեջ';

  @override
  String get keepMuteWhenTakingBack => 'Հետ վերցնելիս լռեք';

  @override
  String get tone => 'Տոն';

  @override
  String get whoMovesFirst => 'Առաջին քայլը';

  @override
  String get human => 'Մարդ';

  @override
  String get ai => 'AI';

  @override
  String get alternate => 'Այլընտրանքային';

  @override
  String get isAutoRestart => 'Ավտոմատ վերսկսել խաղը, երբ խաղն ավարտվի';

  @override
  String get isAutoChangeFirstMove => 'Ավտոմատ փոխել առաջին քայլը';

  @override
  String get shufflingEnabled => 'Տեղափոխեք պատահականորեն';

  @override
  String get misc => 'Տարբեր';

  @override
  String get rules => 'Կանոններ';

  @override
  String get piecesCount => 'Յուրաքանչյուր խաղացողի խաղաքարերի քանակը';

  @override
  String get piecesCount_Detail =>
      'Քանի հատ էլեմենտներ ունի յուրաքանչյուր խաղացողը՞:';

  @override
  String get flyPieceCount => 'Թռչող կտորի համարը';

  @override
  String get flyPieceCount_Detail =>
      'Եթե Flying-ը միացված է, երբ խաղացողը կրճատվում է որոշակի խաղաքարերի քանակով, նրա խաղաքարերը կարող են ազատ տեղաշարժվել դեպի ցանկացած չզբաղեցված կետ, այլ ոչ թե սահմանափակվել հարակից կետերով, ինչպես մնացած խաղում:';

  @override
  String get piecesAtLeastCount => 'Կտորներ Առնվազն';

  @override
  String get hasDiagonalLines => 'Շեղանկյուն գծեր';

  @override
  String get hasDiagonalLines_Detail =>
      'Գրատախտակին ավելացրեք չորս անկյունագծեր:';

  @override
  String get isDefenderMoveFirst => 'Երկրորդ խաղացողը առաջինը շարժվում է';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Խաղացողը, ով տեղափոխվում է երկրորդը տեղակայման փուլում, շարժվում է առաջինը շարժման փուլում:';

  @override
  String get mayRemoveMultiple => 'Բազմակի հեռացում';

  @override
  String get mayRemoveMultiple_Detail =>
      'Եթե խաղացողը միանգամից փակում է մեկից ավելի ջրաղաց, նա կհեռացնի իր փակած ջրաղացների քանակը:';

  @override
  String get mayRemoveFromMillsAlways => 'Ոչնչացնել ջրաղացները';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Լռելյայնորեն, խաղացողները պետք է նախ հանեն ցանկացած այլ կտոր, նախքան ձևավորված ջրաղացից կտորը հեռացնելը: Միացրեք այս տարբերակը՝ սահմանափակումն անջատելու համար:';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Երկրորդ խաղացողը պարտվում է, երբ խաղատախտակը լի է';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Երբ տեղադրման փուլի վերջում տախտակը լցվում է, այն կողմը, որը առաջինը տեղադրում է, պարտվում է խաղը: Հակառակ դեպքում խաղը ոչ-ոքի է:';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Պարտվել, երբ ոչ մի օրինական քայլ';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Խաղացողը կպարտվի, եթե հակառակորդը արգելափակի նրանց այնպես, որ նրանք չկարողանան տեղաշարժվել: Փոխեք կողմը՝ տեղափոխելու համար, եթե այս տարբերակն անջատված է:';

  @override
  String get mayFly => 'Թռիչք';

  @override
  String get mayFly_Detail =>
      'Եթե խաղացողը ունի ընդամենը երեք կամ չորս (կարգավորելի) կտոր, նա կարող է տեղափոխել խաղաքարը ցանկացած ազատ կետ:';

  @override
  String get nMoveRule => 'N-շարժման կանոն';

  @override
  String get nMoveRule_Detail =>
      'Խաղը ոչ-ոքի է անցկացվում, եթե որոշակի քանակությամբ շարժումներում հեռացում չի եղել:';

  @override
  String get rollback => 'Վերադարձ';

  @override
  String get pleaseSelect => 'Խնդրում ենք ընտրել';

  @override
  String get copy => 'Պատճենել';

  @override
  String get moveHistoryCopied =>
      'Պատճենված պատմությունը տեղափոխել սեղմատախտակ:';

  @override
  String get help => 'Օգնություն';

  @override
  String get feedback => 'Հետադարձ կապ';

  @override
  String get exit => 'Ելք';

  @override
  String get ruleSettings => 'Կանոններ';

  @override
  String get color => 'Գույն';

  @override
  String get boardColor => 'Տախտակի գույնը';

  @override
  String get pieceColor => 'Կտորի գույն';

  @override
  String get backgroundColor => 'Ֆոնի գույնը';

  @override
  String get lineColor => 'Տախտակի գծի գույնը';

  @override
  String get whitePieceColor => 'Խաղացող 1 հատ գույն';

  @override
  String get blackPieceColor => 'Խաղացող 2 հատ գույն';

  @override
  String get messageColor => 'Հաղորդագրության գույնը';

  @override
  String get isPieceCountInHandShown => 'Ցույց տալ չտեղադրված կտորների քանակը';

  @override
  String get isNotationsShown => 'Ցույց տալ նշումները տախտակի վրա';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Ցույց տալ պատմության նավիգացիոն գործիքագոտին';

  @override
  String get display => 'Ցուցադրել';

  @override
  String get boardBorderLineWidth => 'Տախտակի սահմանագծի լայնությունը';

  @override
  String get boardInnerLineWidth => 'Տախտակի ներքին գծի լայնությունը';

  @override
  String get pieceWidth => 'Կտոր լայնությունը';

  @override
  String get fontSize => 'Տառատեսակի չափը';

  @override
  String get standardNotation => 'WMD նշում';

  @override
  String get restore => 'Վերականգնել';

  @override
  String get restoreDefaultSettings => 'Վերականգնել լռելյայն կարգավորումները';

  @override
  String pick(Object element) {
    return 'Ընտրեք $element';
  }

  @override
  String get info => 'Ինֆո';

  @override
  String get hint => 'Հուշում';

  @override
  String get player => 'խաղացող';

  @override
  String get player1 => 'Խաղացող 1';

  @override
  String get player2 => 'Խաղացող 2';

  @override
  String get howToPlay => 'Ինչպես խաղալ';

  @override
  String get toPlacePiece =>
      'Հպեք ցանկացած հասանելի կետի՝ կտորը տեղադրելու համար:';

  @override
  String get toSelectPiece => 'Հպեք մի կտորի՝ այն տեղափոխելու համար:';

  @override
  String get toMovePiece =>
      'Հպեք մի կետի վրա, որը միացված է կտորին՝ այն տեղափոխելու համար:';

  @override
  String get toRemovePiece => 'Հպեք հակառակորդի մեկ կտորին՝ հեռացնելու համար:';

  @override
  String get needToCreateMillFirst =>
      'Նախքան կտորը հեռացնելու համար նախ պետք է ջրաղաց ստեղծեք:';

  @override
  String get needToPlayWithOwnPieces => 'Դուք պետք է խաղաք ձեր խաղաքարերով:';

  @override
  String get statistics => 'Վիճակագրություն';

  @override
  String get totalGames => 'Ընդհանուր խաղեր';

  @override
  String get results => 'Արդյունքներ';

  @override
  String get left => 'ձախ';

  @override
  String get privacyPolicy => 'Գաղտնիության քաղաքականություն';

  @override
  String get privacyPolicy_Detail_1 =>
      'Խնդրում ենք ուշադիր կարդալ և համոզվել, որ դուք լիովին հասկանում և համաձայն եք սա ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Եթե համաձայն չեք այս քաղաքականությանը, խնդրում ենք մի օգտագործեք այս հավելվածը: Հավելվածի օգտագործումը ենթադրում է, որ դուք ընդունում եք այս պայմանները:';

  @override
  String get and => ' և ';

  @override
  String get accept => 'Ընդունել';

  @override
  String get takeBack => 'Հետ վերցնել';

  @override
  String get takingBack => 'Հետ վերցնելով…';

  @override
  String get waiting => 'Սպասում է…';

  @override
  String get stepForward => 'Քայլ առաջ';

  @override
  String get takeBackAll => 'Վերցրեք բոլորը';

  @override
  String get stepForwardAll => 'Քայլ առաջ բոլորը';

  @override
  String get moveNow => 'Շարժվեք հիմա';

  @override
  String get done => 'Կատարած.';

  @override
  String get crackMill => 'Crack-mill';

  @override
  String get crackMill_Detail =>
      'Եթե խաղացողն ունի միայն կտորներ ջրաղացներում, ապա ջրաղացների կտորները չեն կողպվի հանելու համար:';

  @override
  String get animationDuration => 'Անիմացիայի տևողությունը';

  @override
  String get none => 'Ոչ ոք';

  @override
  String get theme => 'Թեմա';

  @override
  String get helpContent =>
      'Խաղը նպատակ ունի մրցակցին թողնել երեքից պակաս խաղաքարով կամ առանց օրինական քայլերի:\n\nԽաղն ինքնաբերաբար ոչ-ոքի է անցնում, եթե դիրքը տեղի է ունենում երրորդ անգամ կամ չի հեռացվում վերջին 100 (կարգավորելի) քայլերում:\n\nԽաղն ընթանում է երեք փուլով.\n\n1. Կտորների տեղադրում թափուր կետերի վրա\n2. Կտորների տեղափոխում հարակից կետեր\n3. (ըստ ցանկության փուլ) Ֆիգուրների տեղափոխում ցանկացած թափուր կետ, երբ խաղացողը կրճատվում է երեք կտորով\n\nՏեղադրում\n\nԽաղը սկսվում է դատարկ տախտակով, որը բաղկացած է քսանչորս միավոր ունեցող ցանցից: Խաղացողները հերթով դնում են իրենց խաղաքարերը թափուր կետերի վրա, մինչև յուրաքանչյուր խաղացող բոլոր խաղաքարերը տեղադրի խաղատախտակի վրա: Եթե խաղացողը կարող է ուղիղ դնել իր ֆիգուրներից երեքը, ապա նա ունի «ջրաղաց» և կարող է խաղատախտակից հեռացնել մրցակցի խաղաքարերից մեկը:\n\nՈրոշ կանոնների համաձայն, խաղացողները պետք է նախ հանեն ցանկացած այլ կտոր, նախքան ձևավորված ջրաղացից կտորը հանելը:\n\nՈրոշ կանոններով դուք չեք կարող կտորները տեղադրել հանված կտորների կետերում կրկին տեղադրման փուլում:\n\nԲոլոր խաղաքարերն օգտագործելուց հետո խաղացողները հերթով շարժվում են:\n\nՇարժվող\n\nՏեղափոխվելու համար խաղացողը իր խաղաքարերից մեկը տեղափոխում է տախտակի գծի երկայնքով դատարկ հարակից կետ: Եթե նա չի կարող դա անել, նա պարտվել է խաղը: Խաղացողը, ով իր խաղաքարերից երեքը հավասարեցնում է տախտակի գծի վրա, ունի ջրաղաց և կարող է հեռացնել իր հակառակորդի խաղաքարերից մեկը, ինչպես տեղաբաշխման փուլում: Ցանկացած խաղացող նվազեցնում է երկու կտոր, չունի նոր գործարաններ ստեղծելու հնարավորություն և այդպիսով պարտվում է խաղը: Խաղացողը կարող է նաև պարտվել, երբ ավելի քան երեք խաղաքարեր, եթե նրա հակառակորդը խոչընդոտի նրանց շարժմանը:\n\nԹռիչք\n\nԿանոնների որոշ տարբերակներում, երբ խաղացողին մնում է ընդամենը երեք խաղ, նրա խաղաքարերը կարող են թռչել, թռչել կամ ցատկել դեպի ցանկացած թափուր կետ, ոչ միայն հարակից կետերը:\n';

  @override
  String get versionInfo => 'Տարբերակի տեղեկություններ';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'Լիցենզիա';

  @override
  String get sourceCode => 'Աղբյուրի կոդը';

  @override
  String get appVersion => 'Հավելվածի տարբերակը';

  @override
  String get general => 'Գեներալ';

  @override
  String get advanced => 'Ընդլայնված';

  @override
  String get placing => 'Տեղադրում';

  @override
  String get moving => 'Շարժվող';

  @override
  String get removing => 'Հեռացնելով';

  @override
  String get gameOverCondition => 'Խաղը գերազանցում է վիճակը';

  @override
  String get aisPlayStyle => 'AI-ի խաղաոճը';

  @override
  String get passive => 'Պասիվ';

  @override
  String get timeout => 'Ընդմիջում';

  @override
  String get appearance => 'Արտաքին տեսք';

  @override
  String get drawOnHumanExperience => 'Նկարիր մարդկային փորձի վրա';

  @override
  String get considerMobility => 'Հաշվի առեք կտորների շարժունակությունը';

  @override
  String get pieceCount => 'Կտորների քանակը՝';

  @override
  String inHand(Object player, int count) {
    return '$player ձեռքին՝ $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player նավի վրա՝ $count';
  }

  @override
  String get boardTop => 'Տախտակի օֆսեթ վերևից';

  @override
  String get notAIsTurn => 'Հերթը AI-ին չէ.';

  @override
  String get aiIsNotThinking => 'AI-ն չի մտածում.';

  @override
  String get atEnd => 'Դուք շարժման ցուցակի վերջում եք:';

  @override
  String get tapBackAgainToLeave => 'Կրկին հպեք հետ՝ հեռանալու համար:';

  @override
  String get more => 'Ավելին';

  @override
  String get experimental => 'Դա փորձարարական հատկանիշ է:';

  @override
  String get experiments => 'Փորձարկումներ';

  @override
  String get ossLicenses => 'Բաց կոդով լիցենզիաներ';

  @override
  String get language => 'Լեզու';

  @override
  String get defaultLanguage => 'Կանխադրված լեզու';

  @override
  String get mayMoveInPlacingPhase =>
      'Կտորները կարող են շարժվել տեղադրման փուլում';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Չկան տեղաբաշխման և շարժման հստակ փուլեր, այսինքն՝ խաղացողները կարող են յուրաքանչյուր քայլի ժամանակ որոշել՝ արդյոք ցանկանում են խաղատախտակին մի կտոր տեղադրել, թե տեղափոխել իրենց խաղաքարերից մեկը (քանի դեռ նրանք ունեն մնացած խաղաքարերը տեղադրելու համար):';

  @override
  String get drawerColor => 'Ցանկի գույնը';

  @override
  String get drawerTextColor => 'Ցանկի տեքստի գույնը';

  @override
  String get drawerHighlightItemColor => 'Ցանկի ընդգծված տարրի գույնը';

  @override
  String get mainToolbarBackgroundColor => 'Հիմնական գործիքագոտու ֆոնի գույնը';

  @override
  String get mainToolbarIconColor => 'Հիմնական գործիքագոտու պատկերակի գույնը';

  @override
  String get navigationToolbarBackgroundColor =>
      'Նավիգացիոն գործիքագոտու ֆոնի գույնը';

  @override
  String get navigationToolbarIconColor =>
      'Նավիգացիոն գործիքագոտու պատկերակի գույնը';

  @override
  String get autoHideToolbar => 'Ավտոմատ թաքցնել գործիքագոտին';

  @override
  String get toolbarLocationOnScreen => 'Գործիքադարակի գտնվելու վայրը էկրանին';

  @override
  String get top => 'Գագաթ';

  @override
  String get bottom => 'Ներքևում';

  @override
  String get center => 'Կենտրոն';

  @override
  String get solidColor => 'Հոծ գույն';

  @override
  String get picture => 'Նկար';

  @override
  String get chooseYourPicture => 'Ընտրեք ձեր նկարը';

  @override
  String get light => 'Լույս';

  @override
  String get dark => 'Մութ';

  @override
  String get themes => 'Թեմաներ';

  @override
  String get currentTheme => 'Ընթացիկ թեմա';

  @override
  String get saveTheme => 'Պահպանել թեման';

  @override
  String get showAnalysisGraph => 'Ցույց տալ վերլուծության գրաֆիկը';

  @override
  String get analysis => 'Վերլուծություն';

  @override
  String get saveGame => 'Պահպանել խաղը';

  @override
  String get loadGame => 'Բեռնել խաղը';

  @override
  String get setupPosition => 'Կարգավորման դիրքը';

  @override
  String get showLegalMoves => 'Ցույց տալ օրինական քայլերը';

  @override
  String get showLastMove => 'Ցույց տալ վերջին քայլը';

  @override
  String get showArrows => 'Ցույց տալ սլաքները';

  @override
  String get pieces => 'Կտորներ';

  @override
  String get showAnalysis => 'Ցույց տալ վերլուծությունը';

  @override
  String get threads => 'Թերեւներ';

  @override
  String get getInvolved => 'Զբաղվել';

  @override
  String get helpImproveTranslate => 'Օգնեք բարելավել թարգմանությունը';

  @override
  String get tutorial => 'Ուսուցողական';

  @override
  String get classicMill => 'Դասական ջրաղաց';

  @override
  String get mixedMill => 'Խառը ջրաղաց';

  @override
  String get ceylonMill => 'Ցեյլոնի ջրաղաց';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Ջրաղացը կարող է կոտրվել և բազմիցս վերանորոգվել';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Եթե խաղացողը ջարդում է ջրաղացը, որպեսզի անմիջապես ստեղծի նոր ջրաղաց, այդպիսի խաղացողը կարող է իր հաջորդ քայլում նման կտորը հետ տեղափոխել սկզբնական հանգույց, եթե այն պատրաստի նոր ջրաղաց:';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Խաղը ոչ-ոքի է անցկացվում, եթե խաղացողն ունի երեք ֆիգուր, իսկ տասը քայլից ոչ մեկը չի հանում հակառակորդի խաղաքարերը';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Երբ խաղացողը զիջում է երեք խաղաքարի, և ոչ մի խաղացող չի կարող հեռացնել հակառակորդի խաղաքարը տասը քայլի ընթացքում, խաղը ոչ-ոքի է:';

  @override
  String get close => 'փակել';

  @override
  String get whitePiece => 'Սպիտակ կտոր';

  @override
  String get blackPiece => 'Սև կտոր';

  @override
  String get emptyPoint => 'Դատարկ կետ';

  @override
  String get noPoint => 'Ոչ մի կետ';

  @override
  String get placingPhase => 'Տեղադրման փուլ';

  @override
  String get movingPhase => 'Շարժվող փուլ';

  @override
  String get flyingPhase => 'Թռիչքի փուլ';

  @override
  String sideToMove(Object player) {
    return 'Շարժվող կողմը՝ $player';
  }

  @override
  String lastMove(Object move) {
    return 'Վերջին քայլը՝ $move';
  }

  @override
  String get selected => 'Ընտրված է';

  @override
  String get accessibility => 'Մատչելիություն';

  @override
  String get screenReaderSupport => 'Էկրանի ընթերցողի աջակցություն';

  @override
  String get isDraw => 'Դա ոչ-ոքի է:';

  @override
  String get draw => 'Ոչ ոքի';

  @override
  String get pieceHighlightColor => 'Կտորի ընդգծման գույնը';

  @override
  String get algorithm => 'Ալգորիթմ';

  @override
  String get endgameNMoveRule => 'Endgame N-Move կանոն';

  @override
  String get endgameNMoveRule_Detail =>
      'Խաղը ոչ-ոքի է ավարտվում, եթե խաղացողներից որևէ մեկն ունի ընդամենը երեք խաղաքար, և ոչ մի խաղացող չի հանում խաղաքարը որոշակի քայլերի ընթացքում:';

  @override
  String get drawReasonEndgameRule50 =>
      'Խաղացողներից յուրաքանչյուրն ունի ընդամենը երեք ֆիգուր, և խաղացողներից ոչ մեկը չի հեռացնում խաղաքարը կոնկրետ քայլերի ընթացքում:';

  @override
  String get threefoldRepetitionRule => 'Եռակի կրկնության կանոն';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Խաղը ոչ-ոքի է ավարտվում, եթե դիրքը տեղի է ունենում երրորդ անգամ:';

  @override
  String get continueToMakeMove => 'Ջրաղաց! Շարունակեք քայլ կատարել:';

  @override
  String get pointStyle => 'Կետերի ոճը';

  @override
  String get pointWidth => 'Կետի լայնությունը';

  @override
  String get solid => 'Պինդ';

  @override
  String get hollow => 'Խոռոչ';

  @override
  String get languageName => 'Հայերեն';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Շարժումներ',
      one: '$count Տեղափոխել',
      zero: 'Տեղափոխել',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Չհաջողվեց բեռնել:';

  @override
  String get filename => 'Ֆայլի անունը';

  @override
  String get browse => 'Թերթիր…';

  @override
  String get gameFiles => 'Խաղի ֆայլեր';

  @override
  String get gameSavedTo => 'Խաղը պահված է';

  @override
  String get empty => 'Դատարկ';

  @override
  String get noMove => 'Ոչ մի քայլ:';

  @override
  String get restoredPosition => 'Վերականգնված նախնական դիրքը:';

  @override
  String get clean => 'Մաքուր';

  @override
  String get cleanedUp => 'Մաքրվել է.';

  @override
  String get remove => 'Հեռացնել';

  @override
  String get noPiecesCanBeRemoved => 'Ոչ մի կտոր չի կարելի հեռացնել:';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count կտոր',
      one: '$count կտոր',
      zero: 'Piece',
    );
    return '$_temp0 պետք է հեռացնել:';
  }

  @override
  String placedCount(int count) {
    return 'Տեղադր. ($count)';
  }

  @override
  String get placedPieceCount =>
      'Տեղադրված կտորների հաշվարկը տեղադրման փուլում:';

  @override
  String hasPlacedPieceCount(int count) {
    return 'Ներկայիս խաղացողը տեղադրել է $count կտոր:';
  }

  @override
  String get notPlacingPhase => 'Չի տեղադրում փուլը, այն չի կարող փոխել:';

  @override
  String get paste => 'Կպցնել';

  @override
  String get pasteDone => 'Կպցնելը ավարտվեց:';

  @override
  String get cannotPaste => 'Հնարավոր չէ տեղադրել:';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Ցույց տալ չտեղադրված և հեռացված կտորները';

  @override
  String get fullScreen => 'Ամբողջ էկրանով';

  @override
  String get reopenToTakeEffect =>
      'Դուրս եկեք և նորից բացեք հավելվածը, որպեսզի կարգավորումներն ուժի մեջ մտնեն:';

  @override
  String get forest => 'Անտառ';

  @override
  String get desktopImage => 'Աշխատասեղանի պատկեր';

  @override
  String get invalidPosition => 'Անվավեր դիրք:';

  @override
  String get shareGIF => 'Կիսվեք GIF-ով';

  @override
  String get pixelRatio => 'Պիքսելների հարաբերակցությունը';

  @override
  String get duration => 'Տեւողությունը';

  @override
  String get gameScreenRecorder => 'Խաղի էկրանի ձայնագրիչ';

  @override
  String get previous => 'Նախորդ';

  @override
  String get next => 'Հաջորդը';

  @override
  String get skip => 'Բաց թողնել';

  @override
  String get gotIt => 'Հասկացա';

  @override
  String get youCanModifyRules =>
      'Դուք կարող եք փոփոխել խաղի կանոնները կանոնների կարգավորումներում:';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Դուք կարող եք օգտագործել մկնիկի անիվը ընտրիչի արժեքը փոխելու համար:';

  @override
  String get noTimeLimitForThinking =>
      'AI Մտածողության ժամանակը սահմանվել է 0-ին, նշանակում է, որ մտածելու ժամանակի սահմանափակում չկա:';

  @override
  String get whatIsMtdf =>
      'MTD(f)-ը ալֆա-բետա որոնման ալգորիթմի փոփոխված ձև է, որի նպատակն է բարելավել արդյունավետությունը՝ վերօգտագործելով որոնման միջանկյալ արդյունքները և օգտագործելով լավ նախնական գուշակություն՝ որոնման տարածքը նեղացնելու համար:';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Խնդրում ենք տեղյակ լինել, որ AI մտածողության ժամանակի ճշգրտումը կարող է ամբողջովին ճշգրիտ չլինել: Մտածելու իրական ժամանակը կարող է ավելի կարճ լինել, երբ դժվարության մակարդակը սահմանվում է ավելի ցածր արժեքի և կարող է ավելի երկար լինել, երբ AI-ն միջին մտածողության մեջ է, երբ ժամանակը սպառվում է:';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Եթե դուք բարձր եք դնում դժվարության մակարդակը, բայց չեք ավելացնում AI մտածելու ժամանակը, ապա իրական դժվարության մակարդակը կարող է սահմանափակվել ավելի ցածր արժեքով՝ մտածելու ժամանակի սահմանափակման պատճառով: Փաստացի արժեքը կարող է տարբեր լինել՝ կախված մեքենայի աշխատանքի վրա:';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) որոնման ալգորիթմ է՝ գտնելու լավագույն քայլը տվյալ դիրքում: Այն ալֆա-բետա ալգորիթմի բարելավումն է և օգտագործում է զրոյական կամ զրոյական պատուհանների որոնումներ՝ հաստատելու, որ քայլն ավելի վատ է կամ ոչ ավելի վատ, քան հիմնական տարբերակից ստացված արդեն ապահով գնահատականը: PVS-ը կենտրոնանում է ամենախոստումնալից քայլերի վրա և խուսափում է ոչ օպտիմալ ճյուղերի անհարկի որոնումներից, ինչը օգնում է բարելավել որոնման արդյունավետությունը:';

  @override
  String get whatIsAlphaBeta =>
      'Ալֆա-բետա ալգորիթմը որոնման ալգորիթմ է լավագույն քայլը գտնելու համար: Այն օգտագործում է minimax սկզբունքը և երկու արժեք՝ ալֆա և բետա, որոնման ծառը կտրելու և արդյունավետությունը բարձրացնելու համար: Ալֆան ներկայացնում է նվազագույն միավորը, որը համակարգիչը վստահ է, որ կարող է ստանալ, մինչդեռ բետա-ն ներկայացնում է առավելագույն միավորը, որը կարող է ստանալ նրա հակառակորդը: Ալգորիթմն օգնում է համակարգչին խելացի, արդյունավետ որոշումներ կայացնել խաղի ընթացքում:';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Ըստ մարդկային փորձի՝ եթե փորձես հաղթել, կպարտվես: Փոխարենը նպատակ դրեք ոչ-ոքիին և խուսափեք պարտությունից: Դիտեք ձեր հակառակորդին և նրբորեն հրապուրեք նրան այնպիսի դիրքի, որտեղ նրանք կարող են սխալվել: Երբ նրանք թուլություն են ցույց տալիս, օգտվեք հնարավորությունից և նրբորեն մղեք հաղթանակի: Այսպիսով, դուք կարող եք հաղթել խաղը:';

  @override
  String get firstMoveDetail =>
      'Այս խաղում երկրորդ խաղացողի համար ավելի հեշտ է հաղթել առաջին խաղացողի համեմատ:';

  @override
  String get passiveDetail =>
      'Պասիվ տարբերակի ակտիվացումը կհանգեցնի AI-ի թուլացմանը, երբ այն առավելություն ունի դիրքում, այլ ոչ թե ագրեսիվ կերպով փորձում է հնարավորինս արագ հաղթել:';

  @override
  String get moveRandomlyDetail =>
      'Այս ընտրանքի ակտիվացումը մեծացնում է խաղի պատահականությունն ու զվարճությունը, մինչդեռ այն անջատելը կարող է օգնել ուսումնասիրել արհեստական ինտելեկտը հաղթահարելու ուղիները:';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Եթե AI-ն հաշվի առնի իր խաղաքարերի շարժունակությունը, ապա այն ոչ միայն նպատակ կունենա հնարավորինս արագ գրավել մրցակցի խաղաքարերը, այլ նաև կքննարկի հակառակորդի շարժումները արգելափակելու և նույնը թույլ չտալու մասին:';

  @override
  String get whenBoardIsFull => 'Երբ տախտակը լցված է';

  @override
  String get whenBoardIsFull_Detail =>
      'Տեղադրման փուլի վերջում, մինչ շարժման փուլը սկսվելը, գործողությունը հաջորդում է, եթե տախտակը լի է կտորներով:';

  @override
  String get sideToMoveRemovePiece =>
      'Շարժվող փուլում առաջինը շարժվող խաղացողը հեռացնում է հակառակորդի խաղաքարերից մեկը:';

  @override
  String get agreeToDraw => 'Երկու կողմերն էլ համաձայն են ոչ-ոքիի:';

  @override
  String get takeOpponentsPiece => 'Վերցրեք ձեր հակառակորդի խաղաքարերից մեկը:';

  @override
  String get firstPlayerLose => 'Առաջին խաղացողը պարտվում է խաղը:';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Առաջին և երկրորդ խաղացողները հեռացնում են մրցակցի խաղաքարերից մեկը:';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Երկրորդ և առաջին խաղացողները հեռացնում են հակառակորդի խաղաքարերից մեկը:';

  @override
  String get enteredFlyingPhase =>
      'Այժմ մտել է թռիչքի փուլ, հակառակորդի խաղաքարերը կարող են ցատկել խաղատախտակի ցանկացած դատարկ կետ: Դուք կարող եք անջատել թռիչքի կանոնը «Կանոնների կարգավորումներում»:';

  @override
  String get whenStalemate => 'Երբ փակուղում';

  @override
  String get whenStalemate_Detail =>
      'Ի՞նչ գործողություն է հաջորդում, երբ ոչ մի կտոր հնարավոր չէ տեղափոխել:';

  @override
  String get endWithStalemateLoss =>
      'Ավարտեք փակուղային կորուստով այն կողմի համար, որը արգելափակված է:';

  @override
  String get changeSideToMove => 'Փոխեք կողմը շարժվելու համար:';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Հեռացրեք հակառակորդի խաղաքարերից մեկը և կատարեք հաջորդ քայլը:';

  @override
  String get endWithStalemateDraw => 'Ավարտեք փակուղային ոչ-ոքիով:';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Հեռացրեք մրցակցի խաղաքարերից մեկը և փոխեք կողմը՝ շարժվելու համար:';

  @override
  String get aiResponseDelayTime => 'AI արձագանքման հետաձգման ժամանակը';

  @override
  String get aiIsDelaying =>
      'AI-ն ներկայումս գտնվում է հետաձգված արձագանքման փուլում: Խնդրում ենք մի քիչ սպասել՝ շարունակելուց առաջ:';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Դուք չեք կարող հեռացնել ոչ հարակից կտորը:';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'Եթե փակուղում է, հակառակորդի խաղաքարերը, որոնք կից ձերն են, կարող են հեռացվել՝ անկախ ջրաղացների ձևավորումից:';

  @override
  String get whatIsMcts =>
      'MCTS-ը սկսնակների համար հարմար ալգորիթմ է, որը որոշումներ է կայացնում՝ ուսումնասիրելով և գնահատելով տարբեր քայլերը սիմուլյացիաների միջոցով:';

  @override
  String get goldenJade => 'Ոսկե Jade';

  @override
  String get forestWood => 'Անտառային փայտ';

  @override
  String get darkMystery => 'Մութ առեղծված';

  @override
  String get midnightBlue => 'կեսգիշերային կապույտ';

  @override
  String get greenForest => 'Կանաչ անտառ';

  @override
  String get greenMeadow => 'Կանաչ մարգագետնում';

  @override
  String get stonyPath => 'Քարե արահետ';

  @override
  String get pastelPink => 'Պաստել վարդագույն';

  @override
  String get turquoiseSea => 'Փիրուզագույն ծով';

  @override
  String get violetDream => 'Վիոլետ Երազ';

  @override
  String get mintChocolate => 'Անանուխի շոկոլադ';

  @override
  String get skyBlue => 'Երկնագույն';

  @override
  String get playfulGarden => 'Ուրախ այգի';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Հետադիմական վերլուծության ալգորիթմը օգտագործում է բազմարժեք հետադիմական վերլուծություն՝ տարբեր մեկնարկային դիրքերից վերջնական խաղի տվյալների բազա ստեղծելու համար, այնուհետև կիրառում է այս տվյալների բազան՝ խաղը օպտիմալացնելու համար: Այս մոտեցումը պատկանում է Ultra-Strong լուծումների կատեգորիային:';

  @override
  String get viewAlgorithmGuide =>
      'Ցանկանու՞մ եք դիտել այս ալգորիթմի օգտագործման ուղեցույցը:';

  @override
  String get showPositionalAdvantageIndicator =>
      'Ցույց տալ դիրքային առավելությունների ցուցիչը';

  @override
  String get usePerfectDatabase => 'Օգտագործեք կատարյալ տվյալների բազա';

  @override
  String get perfectDatabaseDescription =>
      'Միացրեք այս տարբերակը՝ նորագույն ալգորիթմների միջոցով ստեղծված խաղերի անթերի տվյալների բազա օգտագործելու համար: Այս հատկությունը միավորում է ինչպես բացման, այնպես էլ վերջնախաղի ռազմավարությունները՝ օպտիմալ քայլեր առաջարկելու համար: Սա նախընտրելի ընտրությունն է այն խաղացողների համար, ովքեր ձգտում են խաղի ամենաբարձր մակարդակի ճշգրտության: Մանրակրկիտ հաշվարկային տեխնիկայի միջոցով ստեղծված տվյալների բազան նախատեսված է խաղային գրեթե կատարյալ լուծումներ առաջարկելու համար:\n\nՆշում. Եթե AI-ն չկարողանա մուտք գործել տվյալների շտեմարան, այն կդիմի սովորական ալգորիթմներին՝ խաղի որոշումների համար: Երբ տվյալների բազան հասանելի է, «Դժվարության մակարդակը» դառնում է գործնականում անգերազանցելի, և «AI Thinking Time»-ը կտրուկ նվազում է ապրում: «AI\'s play style» ընտրանքների շատ կարգավորումներ կչեղարկվեն, քանի որ տվյալների բազայի արդյունքները ամենաբարձր առաջնահերթությունն են:\n\nԱյս անթերի տվյալների բազայից առավելագույնս օգտվելու վերաբերյալ ուղեցույցի համար սեղմեք այստեղ:';

  @override
  String get backgroundImage => 'Ֆոնական պատկեր';

  @override
  String get whatIsRandom =>
      'Երբ «Օգտագործել կատարյալ տվյալների բազա» տարբերակը միացված չէ, «Պատահական» պարամետրը ստիպում է AI-ին պատահականորեն տեղափոխել կտորները՝ առանց շարժման ընտրության ալգորիթմներ օգտագործելու: Սա սովորաբար հանգեցնում է զգալիորեն ավելի թույլ խաղի: Ընդհակառակը, երբ «Օգտագործեք կատարյալ տվյալների բազան» միացված է, AI-ն որոշումներ կայացնելու համար բացառապես հիմնվում է «Կատարյալ տվյալների բազայի» վրա՝ այն ավանդական AI ալգորիթմների հետ խառնելու փոխարեն: Այս ռեժիմում AI-ի քայլերն ամբողջությամբ հիմնված են տվյալների բազայի բովանդակության վրա՝ խուսափելով իրական ժամանակի հաշվարկներից կամ որոնման ալգորիթմներից կախվածությունից:';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Հեռացրեք հակառակորդի խաղաքար(եր)ը նրա ձեռքից, ապա հակառակորդի հերթն է տեղադրելու:';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Երբ ձևավորվում են ջրաղացներ տեղադրման փուլում';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Հեռացրեք հակառակորդի խաղաքար(եր)ը տախտակից:';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Հեռացրեք հակառակորդի խաղաքար(եր)ը տախտակից, ապա հակառակորդի հերթն է տեղադրելու:';

  @override
  String get opponentRemovesOwnPiece =>
      'Հակառակորդը հեռացնում է իր սեփական խաղաքար(եր)ը տախտակից:';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Ձեր գործողություն կատարելու փոխարեն, հակառակորդն ինքն է ընտրում և հեռացնում իր սեփական խաղաքար(եր)ը տախտակից՝ փաստացի կատարելով գործողություն, որը վնասակար է իր համար:';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Հեռացրեք հակառակորդի խաղաքար(եր)ը նրա ձեռքից, ապա ձեր հերթն է շարժվելու:';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Հեռացրեք խաղաքար(եր)ը հակառակորդի ձեռքից: Եթե, ըստ Բազմակի-հեռացման կարգավորման, պետք է հեռացվեն մի քանի խաղաքարեր, և հակառակորդի ձեռքում այլևս խաղաքարեր չեն մնացել, շարունակեք հեռացնել հակառակորդի խաղաքարերը տախտակից: Ապա ձեր հերթն է շարժվելու: Եթե դուք շարունակում եք ձևավորել ջրաղացներ, կարող եք շարունակել հեռացնել հակառակորդի խաղաքարերը:';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Հեռացրեք խաղաքար(եր)ը հակառակորդի ձեռքից: Եթե, ըստ Բազմակի-հեռացման կարգավորման, պետք է հեռացվեն մի քանի խաղաքարեր, և հակառակորդի ձեռքում այլևս խաղաքարեր չեն մնացել, շարունակեք հեռացնել հակառակորդի խաղաքարերը տախտակից: Ապա հակառակորդի հերթն է շարժվելու:';

  @override
  String get markAndDelayRemovingPieces =>
      'Նշեք և հետաձգեք խաղաքարերի հեռացումը:';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Տեղադրման փուլի ընթացքում նշվում են հեռացվելիք խաղաքարերը, և երկու խաղացողների համար էլ այդ կետերում նոր խաղաքարեր չեն կարող տեղադրվել: Մտնելով շարժման փուլ՝ այդ նշված խաղաքարերը միասին հեռացվում են, և խաղացողները կարող են իրենց խաղաքարերը տեղափոխել այդ դատարկված կետերը:';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Միլլեր ձևավորելու ընթացքում տեղադրման փուլում կարող ենթակա լինելու գործողությունները:';

  @override
  String get marked => 'Նշված';

  @override
  String get menu => 'Ցանկ';

  @override
  String get monochrome => 'Մոնոխրոմ';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Դուք կարող եք միացնել էկրանի ընթերցիչի աջակցությունը Ընդհանուր կարգավորումների մեջ Անհատականության կոնֆիգուրացիայում:';

  @override
  String get showNumbersOnPieces => 'Ցուցադրել թվերը քարերի վրա';

  @override
  String get saveImage => 'Պահպանել պատկերը';

  @override
  String get isAnalysisToolbarShown =>
      'Անալիզիզիայի գործիքային գոտին ցուցադրվում է';

  @override
  String get analysisToolbarBackgroundColor =>
      'Անալիզիզիայի գործիքային գոտի ետնագույն գույնը';

  @override
  String get analysisToolbarIconColor =>
      'Անալիզիզիայի գործիքային գոտին նշանակի գույնը';

  @override
  String get transformed => 'Վերևում է';

  @override
  String get cannotTransform => 'Անհնար է փոխել';

  @override
  String get rotate => 'Շրջել';

  @override
  String get horizontalFlip => 'H Փոխել';

  @override
  String get verticalFlip => 'V Փոխել';

  @override
  String get innerOuterFlip => 'IO Փոխել';

  @override
  String get transparentCanvas => 'Թափանցիկ կտոր';

  @override
  String get restrictRepeatedMillsFormation =>
      'Սահմանափակել կրկնվող ջրաղացների ձևավորումը';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Մի քառակուսին, որը տեղափոխվել է մեկ հարթակից մյուսը, չի կարող անմիջապես վերադառնալ սկզբնական կետը հաջորդ հարվածում՝ նորից հարթակ ձևավորելու համար: Սկզբում պետք է կատարել այլ շարժ:';

  @override
  String get oneTimeUseMill => 'Մեկանգամյա օգտագործման ջրաղաց';

  @override
  String get oneTimeUseMill_Detail =>
      'Յուրաքանչյուր ջրաղաց կարող է հեռացնել հակառակորդի կտորը միայն մեկ անգամ: Դուք կարող եք այն նորից ձևավորել, բայց չի կարող օգտագործվել լրացուցիչ հեռացման համար:';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Ընթացիկ կարգավորած կանոնները չունեն համապատասխան իդեալական տվյալների բազա: Լրացուցիչ տեղեկությունների համար իդեալական տվյալների բազայի մասին սեղմեք այստեղ:';

  @override
  String get focusOnBlockingPaths => 'Հաստատեք արգելքների ուղիները';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Անհրաժեշտ է առաջնահերթ ուշադրություն դարձնել մրցակցի շարժումների խոչընդոտմանը՝ քան կազմելով եռյակը: Փոխարենը կենտրոնանալով մասերը հեռացնելու վրա՝ եռյակը լրացնելու միջոցով, արհեստական ինտելեկտը նպատակ ունի խափանել մրցակցին, դարձնելով նրանց շարժունակությունը նվազեցնելով և ապահովելով հաղթանակը խիստ խաղի միջոցով: Այս ռազմավարությունը չի արգելափակում ակտիվորեն մրցակցի եռյակը:';

  @override
  String get pieceImage => 'Շախմատային նկարը';

  @override
  String get importColorSettings => 'Ներմուծել գույնի կարգավորումները';

  @override
  String get exportColorSettings => 'Արտահանել գույնի կարգավորումները';

  @override
  String get import => 'Ներմուծում';

  @override
  String get export => 'Արտահանում';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Խնդրում ենք նախ պատճենել JSON ձևաչափի կարգավորումները Clipboard-ին:';

  @override
  String get copiedToClipboard => 'Պատճենվել է Clipboard-ին:';

  @override
  String get imported => 'Ներմուծված է:';

  @override
  String get boardImage => 'Տախտակի պատկեր';

  @override
  String get autumnLeaves => 'Աշնանային տերևներ';

  @override
  String get legendaryLand => 'Լեգենդար երկիր';

  @override
  String get vignetteEffect => 'Վինյետ ազդեցություն';

  @override
  String get promptMakeToolbarTransparent =>
      'Ցանկանու՞մ եք գործիքը ամբողջովին празնատուն դարձնել, երբ կահույքի պատուհանի պատկերն է կարգավորվում:';

  @override
  String get vibration => 'Միացնել թրթռոցը խաղում';

  @override
  String get soundTheme => 'Ցունքի թեմա';

  @override
  String get ball => 'գնդակ';

  @override
  String get liquid => 'ցուցակ';

  @override
  String get wood => 'փայտ';

  @override
  String get placeEffectAnimation => 'Խաղաքար դնելու անիմացիոն էֆեկտ';

  @override
  String get removeEffectAnimation => 'Խաղաքար հանելու անիմացիոն էֆեկտ';

  @override
  String get isToolbarAtBottom => 'Ցույց տալ գործիքագոտին ներքեւում';

  @override
  String get boardCornerRadius => 'Տախտակի անկյունային շառավիղ';

  @override
  String get useOpeningBook => 'Օգտագործեք բացման գիրք';

  @override
  String get currentRule => 'Ընթացիկ';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Մորաբարաբա';

  @override
  String get dooz => 'Դուզ';

  @override
  String get chamGonu => 'Չամգոնու';

  @override
  String get zhiQi => 'Ժիչի';

  @override
  String get chengSanQi => 'Չենսանցի';

  @override
  String get mulMulan => 'Մուլ-Մուլան';

  @override
  String get nerenchi => 'Ներենչի';

  @override
  String get ruleSet => 'Կանոնափաթեթ';

  @override
  String get laskerMorris => 'Լասկեր Մորիս';

  @override
  String get oneTimeMill => 'Միանգամյա Ջրաղաց';

  @override
  String get daSanQi => 'Դասանցի';

  @override
  String get useOpeningBook_Detail =>
      'Թույլատրեք AI-ին օգտագործել բացման քայլերը, որոնք հաճախ կիրառվում են մարզիկ մարդկանց կողմից խաղի վաղ փուլերում: Նշում՝ այս հատկությունը այժմ մատչելի է միայն որոշակի կանոնակարգերի համար:';

  @override
  String get showAdvantageGraph => 'Ցուցադրել առավելության գրաֆիկը';

  @override
  String get advantageGraphHint =>
      'Առավելության գրաֆը կնկարված լինի միայն այն բանից հետո, երբ ԱԲ-ն կատարի քայլը։ Այն չի նկարվի, երբ մարդու խաղացողը կատարի քայլը։';

  @override
  String get removalBasedOnMillCounts =>
      'Գործողության հեռացումը անջատեք մինչև բոլոր քարերը տեղադրվեն։ Խաղացողները հեռացնում են քարերը աղացների քանակի հիման վրա։';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Գործողության հեռացումը անջատեք մինչև բոլոր քարերը տեղադրվեն։ Խաղացողները հեռացնում են քարերը աղացների քանակի հիման վրա։ Եթե քանակը հավասար է, ապա երկուսն էլ հեռացնում են նույն քանակի քարեր։ Եթե մեկի մոտ քանակը ավելի է, նա հեռացնում է մեկ լրացուցիչ քար՝ պահելով մեկ քարի տարբերությունը։ Եթե միայն մեկը կազմավորում է աղաց, նա հեռացնում է երկու քար, իսկ մյուսը՝ մեկ քար։ Եթե ոչ մեկը աղաց չի կազմում, ապա երկուսն էլ հեռացնում են մեկական քար։';

  @override
  String get elfilja => 'Էլ Ֆիլջա';

  @override
  String get tipSelectOwnPiece => 'Ընտրեք ձեր քարերից մեկը։';

  @override
  String get notYourTurn => 'Դուք չեք խաղում։';

  @override
  String get annotationToolbarBackgroundColor =>
      'Նշումների գործիքների ֆոնի գույն';

  @override
  String get annotationToolbarIconColor => 'Նշումների գործիքների պատկերի գույն';

  @override
  String get isAnnotationToolbarShown => 'Ցուցադրել նշումների գործիքները';

  @override
  String get enterAnnotationMode => 'Մուտքագրել նշումների ռեժիմ';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Դուք վստահ եք, որ ցանկանում եք մաքրել բոլոր նշումները։';

  @override
  String get llmPromptCopiedToClipboard =>
      'LLM հուշումը պատճենվել է clipboard-ում։';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Միացումը մերժվել է, սերվերը կարող է անջատված լինել։';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Հայտնաբերումը հաջողվել է, սպասում է միացմանը...';

  @override
  String get noLanConnection => 'Ոչ LAN միացում';

  @override
  String get takeScreenshot => 'Վերցնել էկրանի նկար';

  @override
  String get disconnectedFromOpponent => 'Անջատվել է հակառակորդից։';

  @override
  String get takeBackRequest => 'Վերադարձի խնդրանք';

  @override
  String get nothingToShow => 'Ոչինչ ցուցադրելու համար։';

  @override
  String get stopHosting => 'Դադարեցնել հոսթինգը';

  @override
  String get connectionResetByPeer => 'Միացումը վերականգնվել է peer-ի կողմից։';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Միացումը կորել է heartbeat timeout-ի պատճառով։ Խնդրում ենք վերամիացնել։';

  @override
  String get startHosting => 'Սկսել հոսթինգը';

  @override
  String get restartRequestRejected => 'Վերագործարկման խնդրանքը մերժվել է։';

  @override
  String get notConnectedToLanOpponent => 'Ոչ միացված LAN հակառակորդին։';

  @override
  String get llmPrompt => 'LLM հուշում';

  @override
  String get gameRestarted => 'Խաղը վերագործարկվել է։';

  @override
  String get takeBackRejected => 'Վերադարձը մերժվել է։';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Դուք վստահ եք, որ ցանկանում եք հրաժարվել այս խաղից։';

  @override
  String get opponentResignedYouWin =>
      'Հակառակորդը հրաժարվել է։ Դուք հաղթել եք։';

  @override
  String get clearAllAnnotations => 'Մաքրել բոլոր նշումները';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Միացված, սպասում է հակառակորդի քայլին...';

  @override
  String get networkStatusDisconnected => 'Ցանցի կարգավիճակը՝ անջատված';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Վերադարձի խնդրանքը ուղարկվել է հակառակորդին։';

  @override
  String get theOpponentMayHaveLeftTheGame => 'Հակառակորդը կարող է լքել խաղը';

  @override
  String get connectedToHostSuccessfully => 'Հաջողությամբ միացված է հոսթին։';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Միացումը կորել է՝ heartbeat timeout';

  @override
  String get noHostDiscovered => 'Ոչ մի հոսթ հայտնաբերված։';

  @override
  String get confirmResignation => 'Հաստատել հրաժարումը';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Սկսել է հոսթինգը, սպասում է խաղացողների միացմանը...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Միացումը ժամանակի սպառվել է, ցանցի միացումը անկայուն է։';

  @override
  String get noLlmPromptAvailable => 'Ոչ LLM հուշում հասանելի։';

  @override
  String get youResignedGameOver => 'Դուք հրաժարվել եք։ Խաղը ավարտվել է։';

  @override
  String get serverIp => 'Սերվերի IP';

  @override
  String get confirmClear => 'Հաստատել մաքրումը';

  @override
  String get opponentSTurn => 'Հակառակորդի հերթը։';

  @override
  String get waitingAClientConnection => 'Սպասում է client-ի միացմանը...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Վերադարձի խնդրանքը մերժվել է կամ ձախողվել է։';

  @override
  String get addText => 'Ավելացնել տեքստ';

  @override
  String get exitAnnotationMode => 'Դուրս գալ նշումների ռեժիմից';

  @override
  String get typeYourAnnotation => 'Մուտքագրեք ձեր նշումը';

  @override
  String get attemptingToReconnect => 'Փորձում է վերամիացնել...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Վերագործարկման խնդրանքը ուղարկվել է։ Սպասում է հակառակորդի պատասխանին...';

  @override
  String get serverIsStopped => 'Սերվերը դադարեցված է։';

  @override
  String get restartRequest => 'Վերագործարկման խնդրանք';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Դուք չեք կարող խնդրել վերադարձ, երբ դա ձեր հերթը չէ։';

  @override
  String get takeBackAccepted => 'Վերադարձը ընդունված է։';

  @override
  String get localNetworkSettings => 'Տեղական ցանցի կարգավորումներ';

  @override
  String get reconnectedSuccessfully => 'Հաջողությամբ վերամիացված է։';

  @override
  String get failedToSaveImageToGallery =>
      'Չհաջողվեց պահպանել պատկերը Gallery-ում։';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Հակառակորդը խնդրել է վերագործարկել խաղը։ Դուք ընդունում եք։';

  @override
  String get yourTurn => 'Ձեր հերթը։';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Չհաջողվեց վերամիացնել, խնդրում ենք վերագործարկել խաղը։';

  @override
  String get host => 'Հոսթ';

  @override
  String get join => 'Միանալ';

  @override
  String get port => 'Պորտ';

  @override
  String get invalidIpAddress => 'Անվավեր IP հասցե։';

  @override
  String get invalidPort => 'Անվավեր պորտ։';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Միացում՝ փորձ $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Չհաջողվեց միացնել՝ $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Չհաջողվեց սկսել հոսթինգը՝ $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Հոսթ հայտնաբերվել է՝ $ip:$port';
  }

  @override
  String get stop => 'Դադարեցնել';

  @override
  String get discover => 'Հայտնաբերել';

  @override
  String get connect => 'Միացնել';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Client-ը միացված է՝ $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Հայտնաբերում՝ $seconds վ';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Վերամիացում ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Միացված';

  @override
  String get delete => 'Ջնջել';

  @override
  String get ancientEgypt => 'Հին Եգիպտոս';

  @override
  String get gothicIce => 'Գոթական Սառույց';

  @override
  String get riceField => 'Բրնձի Դաշտ';

  @override
  String get chinesePorcelain => 'Չինական Հախճապակի';

  @override
  String get desertDusk => 'Անապատի Մթնշաղ';

  @override
  String get precisionCraft => 'Ճշգրիտ Արհեստ';

  @override
  String get folkEmbroidery => 'Ժողովրդական Ասեղնագործություն';

  @override
  String get carpathianHeritage => 'Կարպատյան Ժառանգություն';

  @override
  String get imperialGrandeur => 'Կայսերական Հոյակապություն';

  @override
  String get bohemianCrystal => 'Բոհեմական Բյուրեղ';

  @override
  String get savannaSunrise => 'Սավաննայի Արևածագ';

  @override
  String get harmonyBalance => 'Հաշտություն և Հավասարակշռություն';

  @override
  String get cinnamonSpice => 'Դարչինի Համեմունք';

  @override
  String get anatolianMosaic => 'Անատոլիական Խճանկար';

  @override
  String get carnivalSpirit => 'Կառնավալի Հոգի';

  @override
  String get custom => 'Սովորություն';

  @override
  String get spiceMarket => 'Համեմունքի շուկա';

  @override
  String get swipeToRevealTheDrawer => 'Սահեցրեք՝ դարակը բացելու համար';

  @override
  String get showGameInfoOnScreenshots =>
      'Ցուցադրել խաղի տեղեկությունները նկարված էկրանների վրա';

  @override
  String get humanMoveTime => 'Մարդու քայլի ժամանակի սահմանափակում';

  @override
  String get noTimeLimitForHumanMoves =>
      'Մարդու քայլերի համար ժամանակի սահմանափակում չկա';

  @override
  String get timeoutLoseWillBeApplied =>
      'Մարդ խաղացողի համար կկիրառվի ժամանակի սպառման պարտություն';

  @override
  String get identifyingBoard => 'Խաղի տախտակի նույնացում...';

  @override
  String get youCanEnterAnyModelName =>
      'Դուք կարող եք մուտքագրել ցանկացած մոդելի անուն։';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Խաղի տախտակի դիրքը կիրառվեց. FEN-ն պատճենվել է Clipboard-ում.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Առաջարկություն՝ փորձեք լուսանկարել խաղի տախտակը ավելի հստակ։';

  @override
  String get llmPromptTemplate => 'LLM prompt ձևանմուշ';

  @override
  String get noValidBoardDetected => 'Չգտնվեց վավեր խաղի տախտակ։';

  @override
  String get selectingImageFromAlbum => 'Պատկեր ընտրվում է ալբոմից...';

  @override
  String get configurePromptTemplate => 'Prompt ձևանմուշի կարգավորում';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Փոփոխել Prompt ձևանմուշը LLM վերլուծության համար';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Չհաջողվեց FEN ստեղծել ճանաչված խաղի տախտակից։';

  @override
  String get outputInCurrentLanguage => 'Ելք ընթացիկ լեզվով։';

  @override
  String get commonBaseUrls => 'Հաճախ օգտագործվող Base URL-ներ';

  @override
  String get viewCommonModels => 'Դիտել հաճախ օգտագործվող մոդելները';

  @override
  String get recognitionParametersUpdated =>
      'ճանաչման պարամետրերը թարմացվեցին։';

  @override
  String get whiteSMove => 'Սպիտակի հերթը';

  @override
  String get resetToDefaults => 'Վերականգնել սկզբնական արժեքները';

  @override
  String get photoShoot => 'Լուսանկարահանություն';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Չհաջողվեց կիրառել ճանաչված խաղի տախտակի դիրքը։';

  @override
  String get llmPromptContent => 'LLM prompt-ի բովանդակությունը';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM չի կազմաձևված։ Ստուգեք ձեր կարգավորումները։';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Սահմանեք մատակարարին, մոդելը, API Key-ը և Base URL-ը։';

  @override
  String get llmConfiguration => 'LLM կազմաձևում';

  @override
  String get configureLlmProvider => 'LLM մատակարարի կարգավորում';

  @override
  String get llmPromptTemplateHeader => 'LLM prompt ձևանմուշի վերնագիր';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Պատկերում ոչ մի քար չի ճանաչվել. Խնդրում ենք կրկին փորձել։';

  @override
  String get recognizeBoardFromImage => 'Խաղի տախտակի ճանաչում պատկերից';

  @override
  String get viewTips => 'Խորհուրդներ դիտել';

  @override
  String get applyToBoard => 'Կիրառել խաղի տախտակին';

  @override
  String get adjustBoardArea => 'Խաղի տախտակի տարածքի ճշգրտում';

  @override
  String get viewCommonUrls => 'Հաճախ օգտագործվող URL-ներ դիտել';

  @override
  String get colorAnalysisFailed => 'Գույնի վերլուծությունը ձախողվեց!';

  @override
  String get analyzingGameBoardImage =>
      'Խաղի տախտակի պատկերի վերլուծություն...';

  @override
  String get selectFromAlbum => 'Ընտրել ալբոմից';

  @override
  String get noBoardPointDetected => 'Տախտակի կետ չի հայտնաբերվել!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Եթե դատարկ թողնեք, կկիրառվի կանխադրված ձևանմուշը';

  @override
  String get llmConfig => 'LLM կազմաձև';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Համոզվա՞ծ եք, որ ցանկանում եք վերականգնել prompt ձևանմուշները կանխադրված արժեքներին։';

  @override
  String get llmPromptTemplateFooter => 'LLM prompt ձևանմուշի ստորին մասը';

  @override
  String get loadingResponse => 'Պատասխանի բեռնում...';

  @override
  String get applyThisResultToBoard => 'Կիրառել այս արդյունքը խաղի տախտակին';

  @override
  String get takingPicture => 'Լուսանկարվում է...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Խնդրում ենք ընտրել խաղի տախտակի պատկերը նույնացնելու համար';

  @override
  String get identificationResults => 'ճանաչման արդյունքներ';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Վերլուծեք քայլերը և առաջարկեք դիտարկումներ';

  @override
  String get getApiKey => 'Ստանալ API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Ճանաչման ամբողջ գործընթացը չհաջողվեց ավարտել։';

  @override
  String get boardRecognitionResult => 'Խաղի տախտակի ճանաչման արդյունք';

  @override
  String get askLlm => 'Հարցրեք LLM-ին';

  @override
  String get boardDetectionFailed => 'Խաղի տախտակի հայտնաբերումը անհաջողվեց!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Տախտակի կետ չի հայտնաբերվել, հնարավոր չէ նույնականացնել քարերը։';

  @override
  String get copyFen => 'Պատճենել FEN';

  @override
  String get commonlyUsedModels => 'Հաճախ օգտագործվող մոդելներ';

  @override
  String get apiKeyOptional => 'API Key (ընտրովի)';

  @override
  String get noImageSelected => 'Պատկեր չի ընտրվել';

  @override
  String get blackSMove => 'Սևի հերթը';

  @override
  String get llm => 'Մեծ լեզվային մոդել';

  @override
  String get llmProvider => 'Մատակարար';

  @override
  String get baseUrl => 'Հիմնական URL';

  @override
  String get model => 'Մոդել';

  @override
  String get temperature => 'Ջերմաստիճան';

  @override
  String get llmCommandReceivedProcessing => 'Հրամանն ստացվեց․ ԱԲ մշակում է...';

  @override
  String get llmDeepThinkingWait =>
      'Խորը մտածման գործընթաց է, խնդրում ենք սպասել...';

  @override
  String get llmPresentingSoon => 'Շուտով կներկայացվի...';

  @override
  String get recognitionParameters => 'Ճանաչման պարամետրեր';

  @override
  String get adjustParamsDesc =>
      'Կարգավորեք պարամետրերը՝ ճանաչման ճշգրտությունը բարելավելու համար';

  @override
  String get saveParameters => 'Պահպանել պարամետրերը';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Չհաջողվեց մեկնարկել պատկերի ճանաչումը: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Պատկերի ճանաչումը ձախողվեց: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Կիրառված դիրք՝ $whiteCount սպիտակ և $blackCount սև քարերով';
  }

  @override
  String get fenCopiedToClipboard => '(FEN-ը պատճենվել է սեղմատախտակին)';

  @override
  String recognitionFailed(String error) {
    return 'Ճանաչումը ձախողվեց: $error';
  }

  @override
  String get myRating => 'Իմ վարկանիշը';

  @override
  String get gamesPlayed => 'Խաղացված խաղեր';

  @override
  String get wins => 'Հաղթանակներ';

  @override
  String get losses => 'Պարտություններ';

  @override
  String get draws => 'Ոչ-ոքիներ';

  @override
  String get lastUpdated => 'Վերջին թարմացում';

  @override
  String get format => 'Ձևաչափ՝';

  @override
  String get resetStatistics => 'Վերականգնել վիճակագրությունը';

  @override
  String get drawRate => 'Ոչ-ոքիների տոկոս';

  @override
  String get lossRate => 'Պարտությունների տոկոս';

  @override
  String get aiStatistics => 'ԱԲ վիճակագրություն';

  @override
  String get enableStatistics => 'Միացնել վիճակագրությունը';

  @override
  String get enableStatistics_Detail =>
      'Միացված լինելու դեպքում խաղի արդյունքները կարձանագրվեն վիճակագրության մեջ։ Սակայն հետքայլեր պարունակող խաղերը չեն արձանագրվի։ Անջատված լինելու դեպքում վիճակագրության հավաքագրումը կդադարեցվի։';

  @override
  String get thisWillResetAllGameStatistics =>
      'Սա կվերականգնի խաղի ամբողջ վիճակագրությունը։ Այս գործողությունը հնարավոր չէ հետարկել։';

  @override
  String get boardInnerRingSize => 'Տախտակի ներքին օղակի չափը';

  @override
  String get boardShadowEnabled => 'Տախտակի ստվեր';

  @override
  String get trapAwareness => 'Որոգայթների հայտնաբերում';

  @override
  String get trapAwarenessDescription =>
      'Վերլուծության ընթացքում ընդգծել որոգայթի քայլերը հաստ շրջաններով և սլաքներով.';

  @override
  String trapExists(String trapMoves) {
    return 'Կա որոգայթ։ Որոգայթի քայլեր՝ $trapMoves';
  }

  @override
  String get custodianCapture => 'Փայլուն գրավում';

  @override
  String get custodianCaptureDescription =>
      'Կցեք ձեր հակառակորդի կտորներից մեկին ձեր երկու-ի միջեւ ուղիղ գծով `այն գրավելու համար:';

  @override
  String get custodianCaptureEnable => 'Թույլ տվեք Flanking Capture';

  @override
  String get interventionCapture => 'Միջամտության գրավում';

  @override
  String get interventionCaptureDescription =>
      'Տեղափոխեք ձեր հակառակորդի երկու մասի դատարկ կետի մեջ, երկուսն էլ գրավելու համար:';

  @override
  String get interventionCaptureEnable => 'Թույլատրել միջամտության գրավումը';

  @override
  String get leapCapture => 'Անցնել գրավում';

  @override
  String get leapCaptureDescription =>
      'Սեւեռել, հարակից մրցակիցի կտորի վրա նետվելով դեպի դատարկ կետը:';

  @override
  String get leapCaptureEnable => 'Թույլ տվեք ցատկել գրավումը';

  @override
  String get captureApplicableLines => 'Կիրառելի գծեր';

  @override
  String get captureSquareEdges => 'Հրապարակի եզրերի երկայնքով';

  @override
  String get captureCrossLines => 'Քառակուսի հատող օրթոգոնալ գծերի երկայնքով';

  @override
  String get captureDiagonalLines =>
      'Հրապարակը հատող անկյունագծային գծերի երկայնքով';

  @override
  String get captureExecutionPhases => 'Կատարման փուլեր';

  @override
  String get capturePiecesCondition =>
      'Մնացած կտորների հիման վրա շարժվող փուլում առկայություն';

  @override
  String get capturePiecesConditionUnlimited => 'Ոչ մի սահմանափակություն';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Մատչելի է, երբ ունեք երեք կամ ավելի քիչ կտոր';
}
