// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Hungarian (`hu`).
class SHu extends S {
  SHu([String locale = 'hu']) : super(locale);

  @override
  String get appName => 'Malom';

  @override
  String get welcome => 'Üdvözöljük!';

  @override
  String get yes => 'Igen';

  @override
  String get no => 'Nem';

  @override
  String get game => 'Játék';

  @override
  String get humanVsAi => 'Ember a gép ellen';

  @override
  String get humanVsHuman => 'Ember ember ellen';

  @override
  String get aiVsAi => 'Gép a gép ellen';

  @override
  String get humanVsCloud => 'Ember a felhő ellen';

  @override
  String get humanVsLAN => 'Ember a helyi hálózat ellen';

  @override
  String get testViaLAN => 'Tesztelés LAN-on keresztül';

  @override
  String get move => 'Lépés';

  @override
  String get showMoveList => 'Lépéslista áttekintése';

  @override
  String get moveList => 'Lépéslista';

  @override
  String get noGameRecord => 'Nincs feljegyzés';

  @override
  String get ok => 'Rendben';

  @override
  String get confirm => 'Jóváhagy';

  @override
  String get cancel => 'Mégsem';

  @override
  String get tipSelectWrong => 'Válassza ki a rossz helyen lévő korongot!';

  @override
  String get tipPlace => 'Rakjon le egy korongot.';

  @override
  String get tipBanPlace => 'A korongot nem lehet odarakni.';

  @override
  String get tipPlaced => 'Lerakott egy korongot.';

  @override
  String get tipRemove => 'Távolítson el egy korongot.';

  @override
  String get tipBanRemove => 'Nem lehet eltávolítani.';

  @override
  String get tipRemoved => 'Eltávolítva.';

  @override
  String get tipMove => 'Lépjen egy koronggal.';

  @override
  String get tipCannotPlace => 'Korongod nem rakható ide.';

  @override
  String get tipCannotMove => 'Nem léphet ide.';

  @override
  String get tipMill => 'Malom! Levehet egy ellenfél-korongot.';

  @override
  String get tipContinueMill =>
      'Folytassa az ellenfél korongjainak eltávolítását.';

  @override
  String get tipSelectOpponentsPiece =>
      'Válasszon egyet az ellenfél korongjaiból.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Malomból nem lehet korongot levenni.';

  @override
  String get tipCanMoveOnePoint =>
      'Egy korong vonal mentén csakis a következő mezőre léphet.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Nem mozgathatja az ellenfél korongjait.';

  @override
  String get tipSelectPieceToMove => 'Válasszon lépéshez egy korongot.';

  @override
  String get tipHaveThreePiecesLeft => 'Három korongja maradt.';

  @override
  String get tipCanMoveToAnyPoint =>
      'Bármely tetszőleges szabad mezőre léphet.';

  @override
  String tipToMove(Object player) {
    return '$player a mozgáshoz.';
  }

  @override
  String get whiteWin => '1-es játékos nyer!';

  @override
  String get blackWin => '2-es játékos nyer!';

  @override
  String get won => 'Nyert';

  @override
  String get lost => 'Veszített';

  @override
  String get thinking => 'Gondolkodás…';

  @override
  String get newGame => 'Új játék';

  @override
  String get importGame => 'Játék importálása';

  @override
  String get exportGame => 'Játék exportálása';

  @override
  String get gameImported => 'Játék importálva.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Nem lehet importálni $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'A lépések és a szabályok nem egyeznek.';

  @override
  String get pleaseWait => 'Kérem várjon...';

  @override
  String get restartGame => 'Indítsa újra az aktuális játékot?';

  @override
  String get restart => 'Újraindítás';

  @override
  String get gameStarted => 'A játék indul, kérjük, rakjon.';

  @override
  String get analyzing => 'Elemzés…';

  @override
  String error(Object message) {
    return 'Hiba: $message';
  }

  @override
  String get winRate => 'Nyerési arány';

  @override
  String get score => 'Eredmény:';

  @override
  String get white => 'J1';

  @override
  String get black => 'J2';

  @override
  String loseReasonlessThanThree(Object player) {
    return 'Az $player darabszám kevesebb, mint három.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player lemondott.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return 'Az $player-nek nincs más útja.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'A tábla megtelt, és az $player-nek nincs útja.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Az idő lejárt, $player elveszett.';
  }

  @override
  String get drawReasonRule50 =>
      'Az utolsó N lépés során egyetlen korong sem lett eltávolítva.';

  @override
  String get drawReasonBoardIsFull => 'Ez egy döntetlen, mert a tábla megtelt.';

  @override
  String get drawReasonThreefoldRepetition =>
      'Ez egy döntetlen a háromszoros ismétlés miatt.';

  @override
  String get gameOverUnknownReason => 'Játék vége! Ismeretlen ok.';

  @override
  String get gameOver => 'Játék vége';

  @override
  String get youWin => 'Nyert! Gratulálunk!';

  @override
  String challengeHarderLevel(int level) {
    return 'Kihívás nehezebb szinten? Az új szint az $level szint lesz!';
  }

  @override
  String get youLose => 'Vesztített!';

  @override
  String get analyze => 'Elemezés';

  @override
  String get about => 'Az alkalmazásról';

  @override
  String version(Object versionNumber) {
    return 'Verzió: $versionNumber';
  }

  @override
  String get thanks => 'Köszönet';

  @override
  String get settings => 'Beállítások';

  @override
  String get options => 'Opciók';

  @override
  String get generalSettings => 'Általános beállítások';

  @override
  String get skillLevel => 'Nehézségi szint';

  @override
  String get moveTime => 'AI gondolkodási ideje';

  @override
  String get difficulty => 'Nehézség';

  @override
  String get playSounds => 'Hanghatások';

  @override
  String get playSoundsInTheGame => 'Hangok lejátszása játék közben';

  @override
  String get keepMuteWhenTakingBack => 'Visszanézéskor tartsa a némítást';

  @override
  String get tone => 'Hang';

  @override
  String get whoMovesFirst => 'Első lépés';

  @override
  String get human => 'Személy';

  @override
  String get ai => 'AI';

  @override
  String get alternate => 'Váltakozó';

  @override
  String get isAutoRestart => 'Automatikus újraindítás, játék végén';

  @override
  String get isAutoChangeFirstMove =>
      'Automatikusan cserélődik az első játékos a játék végén';

  @override
  String get shufflingEnabled => 'Véletlenszerű lépés';

  @override
  String get misc => 'Vegyes';

  @override
  String get rules => 'Szabályok';

  @override
  String get piecesCount => 'Játékosra eső korongszám';

  @override
  String get piecesCount_Detail => 'Hány korongja van minden játékosnak?';

  @override
  String get flyPieceCount => 'Az ugrálható (flying) korongok száma';

  @override
  String get flyPieceCount_Detail =>
      'Ha az ugrálás (Flying) aktiválva van és a játékos korongjainak száma előre meghatározott értékre csökkentek, ezek bármely szabad mezőre ugorhatnak.';

  @override
  String get piecesAtLeastCount => 'Legkevesebb korong';

  @override
  String get hasDiagonalLines => 'Átlós vonalak';

  @override
  String get hasDiagonalLines_Detail =>
      'Kösse össze négy átlóssal a játéktábla három koncentrikus négyszögének csúcsait.';

  @override
  String get isDefenderMoveFirst => 'A második játékos lép először';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Az a játékos, aki a második a lerakásban, lépésben első lesz.';

  @override
  String get mayRemoveMultiple => 'Többszörös eltávolítás';

  @override
  String get mayRemoveMultiple_Detail =>
      'Ha egy játékos ugyanazzal a koronggal egyszerre több malmot hoz létre, akkor a létrehozott malmok számának megfelelő számú ellenfél-korongot távolíthat el.';

  @override
  String get mayRemoveFromMillsAlways => 'Pusztítsd a malmokat';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Alapértelmezés szerint a játékosok az ellenfél malmából nem vehetnek el korongot, kivéve ha az ellenfél minden korongja malomban áll. Engedélyezze ezt a lehetőséget a korlátozás kikapcsolásával.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'A második játékos veszít, ha a tábla megtelt';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Ha a lerakási szakasz végén, megtelik a tábla, az elsőként lerakó lesz a vesztes (nem tud lépni), helyezett játékos veszíti el a játékot, különben a játék döntetlen lenne.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Vesztes, ha nincs érvényes lépési lehetősége';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'A játékos veszít, ha ellenfele blokkolja összes korongjainak lépési lehetőségét. Ha az opció ki van kapcsolva, akkor változtasson.';

  @override
  String get mayFly => 'Ugrás';

  @override
  String get mayFly_Detail =>
      'Ha egy játékosnak csak három vagy négy (konfigurálható) korongja marad, akkor ezekkel bármelyik szabad mezőre ugrálhat.';

  @override
  String get nMoveRule => 'N lépéses szabály';

  @override
  String get nMoveRule_Detail =>
      'A játék sorsolásra kerül, ha az egyes játékosok nem hajtottak végre bizonyos számú mozdulatot.';

  @override
  String get rollback => 'Visszaállítás';

  @override
  String get pleaseSelect => 'Kérem, válasszon';

  @override
  String get copy => 'Másolat';

  @override
  String get moveHistoryCopied => 'Az előzmények vágólapra vannak másolva.';

  @override
  String get help => 'Segítség';

  @override
  String get feedback => 'Visszajelzés';

  @override
  String get exit => 'Kilépés';

  @override
  String get ruleSettings => 'Szabálybeállítások';

  @override
  String get color => 'Szín';

  @override
  String get boardColor => 'Tábla színe';

  @override
  String get pieceColor => 'Korongszín';

  @override
  String get backgroundColor => 'Háttérszín';

  @override
  String get lineColor => 'Tábla vonalszíne';

  @override
  String get whitePieceColor => '1-es játékos korongszíne';

  @override
  String get blackPieceColor => '2-es játékos korongszíne';

  @override
  String get messageColor => 'Üzenet színe';

  @override
  String get isPieceCountInHandShown =>
      'A kézben lévő korongszám megjelenítése';

  @override
  String get isNotationsShown => 'Jelölések megjelenítése a fedélzeten';

  @override
  String get isHistoryNavigationToolbarShown =>
      'A navigációs előzmények eszköztárának megjelenítése';

  @override
  String get display => 'Kijelző';

  @override
  String get boardBorderLineWidth => 'A játéktábla határvonalának szélessége';

  @override
  String get boardInnerLineWidth => 'A tábla belső vonalainak szélessége';

  @override
  String get pieceWidth => 'Korongszélesség';

  @override
  String get fontSize => 'Betűméret';

  @override
  String get standardNotation => 'WMD jelölés';

  @override
  String get restore => 'Visszaállítás';

  @override
  String get restoreDefaultSettings =>
      'Visszaállítja az alapértelmezett beállításokat';

  @override
  String pick(Object element) {
    return 'Válasszon $element';
  }

  @override
  String get info => 'Info';

  @override
  String get hint => 'Célzás';

  @override
  String get player => 'játékos';

  @override
  String get player1 => '1. játékos';

  @override
  String get player2 => '2. játékos';

  @override
  String get howToPlay => 'Hogyan kell játszani';

  @override
  String get toPlacePiece =>
      'Érintse meg a rendelkezésre álló mezőt a korong elhelyezése végett.';

  @override
  String get toSelectPiece => 'Érintse meg a korongot annak mozgatásához.';

  @override
  String get toMovePiece =>
      'Érintse meg a mezőt amelyhez csatlakoztatni akarja a korongot.';

  @override
  String get toRemovePiece =>
      'Eltávolítás végett érintse meg az ellenfél egy korongját.';

  @override
  String get needToCreateMillFirst =>
      'Malmot kell alkotnia, mielőtt eltávolíthatna egy korongot.';

  @override
  String get needToPlayWithOwnPieces => 'Saját korongjaival kell játszania.';

  @override
  String get statistics => 'Statisztika';

  @override
  String get totalGames => 'Összes játék';

  @override
  String get results => 'Eredmények';

  @override
  String get left => 'bal';

  @override
  String get privacyPolicy => 'Adatvédelmi irányelvek';

  @override
  String get privacyPolicy_Detail_1 =>
      'Kérjük, olvassa el figyelmesen, és győződjön meg róla, hogy teljes mértékben megértette és egyetért ezzel ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Ha nem ért egyet ezzel az irányelvvel, kérjük, ne használja ezt az alkalmazást. Az alkalmazás használata kötelezi ezen feltételek elfogadására.';

  @override
  String get and => ' és ';

  @override
  String get accept => 'Elfogad';

  @override
  String get takeBack => 'Visszavesz';

  @override
  String get takingBack => 'Visszavenni…';

  @override
  String get waiting => 'Várakozás…';

  @override
  String get stepForward => 'Lépjen előre';

  @override
  String get takeBackAll => 'Vissza mindent';

  @override
  String get stepForwardAll => 'Lépjen előre mindenek előtt';

  @override
  String get moveNow => 'Most lépjen';

  @override
  String get done => 'Kész.';

  @override
  String get crackMill => 'Nyitott malom';

  @override
  String get crackMill_Detail =>
      'Ha egy játékos össszes korongja malomot alkot, ez nem jelenti, hogy ezek nem távolíthatóak el.';

  @override
  String get animationDuration => 'Az animáció időtartama';

  @override
  String get none => 'Egyik sem';

  @override
  String get theme => 'Téma';

  @override
  String get helpContent =>
      'A játék célja, hogy az ellenfélnek kevesebb, mint három korongja maradjon, vagy beszoruljon, azaz ne tudjon legálisan lépni egyetlen koronggal sem.\n\nA játék automatikusan felfüggesztődik, ha egymás után háromszor ismétlődik ugyanaz a lépés, vagy ha 100 (konfigurálható) lépés alatt nem történik korongeltávolítás.\n\nA játék három szakaszban halad:\n\n1. Korongok felrakása a tábla üres mezőire\n2. Korongok lépegetése a táblán \n3. (opcionális szakasz) Ugrálás a táblán bármely üres mezőre, ha a játékosnak csak három korongja maradt.\n\nFelrakás\n\nA játék egy üres táblával kezdődik, amelyen egy huszonnégy mezőből álló rács van. A játékosok felváltva rakják a korongjaikat az üres mezőkre, amíg azok el nem fogynak. Ha egy játékos három korongját képes egyvonalba helyezni, akkor \"Malom\" van, és eltávolíthatja a tábláról ellenfelének egyik korongját.\n\nA szabályok egyes változataiban a játékosok az ellenfél malmából nem vehetnek el korongot, kivéve ha az ellenfél minden korongja malomban áll.\n\nA szabályok egyes változataiban az eltávolított korongok, ugyanazon játék közben, nem rakhatók vissza a táblára.\n\nMiután az összes korong felrakódott, a játékosok felváltva lépegetnek.\n\nLépegetés\n\nLépegetéskor a játékos az egyik korongját egy vonal mentén csakis a közvetlenül mellette levő üres mezőre tolhatja. Ha ezt egyetlen koronggal sem teheti, akkor beszorult és elveszítette a játékot. Akárcsak a felrakási fázisban, malmot létesít az a játékos is, akinek lépegetéssel egyvonalba sikerül elhelyezni három korongot, s így ezúttal is eltávolíthatja az ellenfél egyik korongját. Ha bármelyik játékosnak csak két korongja marad, tehát nincs lehetősége malmot létrehozni, elveszítette a játékot. Egy játékos háromnál több darabbal is veszíthet, ha ellenfele lezárja, azaz egyetlen koronggal sem léphet.\n\nUgrálás\n\nA szabályok egyes változataiban, ha egy játékosnak csak három korongja marad, akkor ezekkel nemcsak szomszédos, hanem bármely üres mezőre ugorhat.\n';

  @override
  String get versionInfo => 'Verzió információ';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'Licenc';

  @override
  String get sourceCode => 'Forráskód';

  @override
  String get appVersion => 'App verzió';

  @override
  String get general => 'Általánosság';

  @override
  String get advanced => 'Haladó';

  @override
  String get placing => 'Felrakás';

  @override
  String get moving => 'Lépés';

  @override
  String get removing => 'Eltávolítás';

  @override
  String get gameOverCondition => 'Játékvég feltétel';

  @override
  String get aisPlayStyle => 'AI játékstílusa';

  @override
  String get passive => 'Passzív';

  @override
  String get timeout => 'Időszünet';

  @override
  String get appearance => 'Megjelenés';

  @override
  String get drawOnHumanExperience => 'Használja a személyes tapasztalatokat';

  @override
  String get considerMobility => 'Fontolja meg a korongok mobilitását';

  @override
  String get pieceCount => 'Korongszám:';

  @override
  String inHand(Object player, int count) {
    return '$player kézben: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player a fedélzeten: $count';
  }

  @override
  String get boardTop => 'A tábla eltolása felülről';

  @override
  String get notAIsTurn => 'Nem AI van soron.';

  @override
  String get aiIsNotThinking => 'AI nem gondolkodik.';

  @override
  String get atEnd => 'A lépegetés lista végén.';

  @override
  String get tapBackAgainToLeave => 'Koppintson újra a távozáshoz.';

  @override
  String get more => 'Több';

  @override
  String get experimental => 'Ez egy kísérleti jellemző.';

  @override
  String get experiments => 'Kísérletek';

  @override
  String get ossLicenses => 'Nyílt forráskódú licencek';

  @override
  String get language => 'Nyelv';

  @override
  String get defaultLanguage => 'Alapértelmezett nyelv';

  @override
  String get mayMoveInPlacingPhase =>
      'A darabok mozoghatnak az elhelyezési fázisban';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Nincs külön elhelyezési és mozgási fázis, azaz a játékosok minden lépésnél eldönthetik, hogy egy bábut akarnak-e elhelyezni a táblán, vagy pedig az egyik bábujukat akarják-e mozgatni (amíg van még elhelyezendő bábujuk).';

  @override
  String get drawerColor => 'A menü színe';

  @override
  String get drawerTextColor => 'A menü szövegének színe';

  @override
  String get drawerHighlightItemColor => 'A menü kiemelésének színe';

  @override
  String get mainToolbarBackgroundColor => 'A fő eszköztár háttérszíne';

  @override
  String get mainToolbarIconColor => 'Fő eszköztár ikon színe';

  @override
  String get navigationToolbarBackgroundColor =>
      'A navigációs eszköztár háttérszíne';

  @override
  String get navigationToolbarIconColor =>
      'A navigációs eszköztár ikonjának színe';

  @override
  String get autoHideToolbar => 'Az eszköztár automatikus elrejtése';

  @override
  String get toolbarLocationOnScreen => 'Az eszköztár helye a képernyőn';

  @override
  String get top => 'Felül';

  @override
  String get bottom => 'Alsó';

  @override
  String get center => 'Központ';

  @override
  String get solidColor => 'Szolid szín';

  @override
  String get picture => 'Kép';

  @override
  String get chooseYourPicture => 'Válassza ki a képét';

  @override
  String get light => 'Fény';

  @override
  String get dark => 'Sötét';

  @override
  String get themes => 'Témák';

  @override
  String get currentTheme => 'Aktuális téma';

  @override
  String get saveTheme => 'Téma mentése';

  @override
  String get showAnalysisGraph => 'Elemzési grafikon megjelenítése';

  @override
  String get analysis => 'Elemzés';

  @override
  String get saveGame => 'Játék mentése';

  @override
  String get loadGame => 'Játék betöltése';

  @override
  String get setupPosition => 'Beállítási helyzet';

  @override
  String get showLegalMoves => 'Jogi lépések megjelenítése';

  @override
  String get showLastMove => 'Az utolsó lépés megjelenítése';

  @override
  String get showArrows => 'Nyilak megjelenítése';

  @override
  String get pieces => 'Darabok';

  @override
  String get showAnalysis => 'Elemzés megjelenítése';

  @override
  String get threads => 'Szálak';

  @override
  String get getInvolved => 'Részt venni';

  @override
  String get helpImproveTranslate => 'Segítsen javítani a fordítást';

  @override
  String get tutorial => 'Bemutató';

  @override
  String get classicMill => 'Klasszikus Malom';

  @override
  String get mixedMill => 'Vegyes malom';

  @override
  String get ceylonMill => 'Ceiloni malom';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Lehet, hogy a malom megszakad, és többször átdolgozik';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Ha egy játékos megtöri a malmot, hogy azonnal új malmot hozzon létre, akkor az ilyen darabot a következő lépésével visszahelyezheti az eredeti kereszteződésbe, ha új malmot készít.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'A játék sorsolásra kerül, ha egy játékosnak három darabja van, és tíz mozdulat után egyik játékos sem távolítja el az ellenfél darabjait';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Ha egy játékos három darabból áll, és egyik játékos sem tudja eltávolítani az ellenfél darabját tíz mozdulaton belül, akkor a játék döntetlen.';

  @override
  String get close => 'Bezárás';

  @override
  String get whitePiece => 'Fehér darab';

  @override
  String get blackPiece => 'Fekete darab';

  @override
  String get emptyPoint => 'Üres pont';

  @override
  String get noPoint => 'Nincs értelme';

  @override
  String get placingPhase => 'Helyezési fázis';

  @override
  String get movingPhase => 'Mozgó fázis';

  @override
  String get flyingPhase => 'Repülő fázis';

  @override
  String sideToMove(Object player) {
    return 'Oldal mozgatandó: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Utolsó lépés: $move';
  }

  @override
  String get selected => 'Kiválasztott';

  @override
  String get accessibility => 'Megközelíthetőség';

  @override
  String get screenReaderSupport => 'Képernyőolvasó támogatás';

  @override
  String get isDraw => 'Ez egy döntetlen!';

  @override
  String get draw => 'Húz';

  @override
  String get pieceHighlightColor => 'A lemez kiemelésének színe';

  @override
  String get algorithm => 'Algoritmus';

  @override
  String get endgameNMoveRule => 'Végjáték N lépéses szabály';

  @override
  String get endgameNMoveRule_Detail =>
      'Ha bármelyik játékosnak csak három korongja van, és egyik játékos sem vesz ki korongot egy adott lépésen belül, a játék döntetlenre végződik.';

  @override
  String get drawReasonEndgameRule50 =>
      'Bármelyik játékosnak csak három korongja van, és egyik játékos sem távolít el korongot egy adott lépésen belül.';

  @override
  String get threefoldRepetitionRule => 'Háromszoros ismétlési szabály';

  @override
  String get threefoldRepetitionRule_Detail =>
      'A játék döntetlenre végződik, ha egy pozíció harmadszor is előfordul.';

  @override
  String get continueToMakeMove => 'Malom! Folytassa a lépést.';

  @override
  String get pointStyle => 'Pont stílus';

  @override
  String get pointWidth => 'Pont szélessége';

  @override
  String get solid => 'Szilárd';

  @override
  String get hollow => 'Üreges';

  @override
  String get languageName => 'Magyar';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Mozdul',
      one: '$count Mozog',
      zero: 'Mozog',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'A betöltés nem sikerült.';

  @override
  String get filename => 'Fájl név';

  @override
  String get browse => 'Tallózás…';

  @override
  String get gameFiles => 'Játékfájlok';

  @override
  String get gameSavedTo => 'A játék el lett mentve ide';

  @override
  String get empty => 'Üres';

  @override
  String get noMove => 'Nincs mozgás.';

  @override
  String get restoredPosition => 'Kiinduló helyzet visszaállítva.';

  @override
  String get clean => 'Tiszta';

  @override
  String get cleanedUp => 'Feltakarítva.';

  @override
  String get remove => 'Távolít.';

  @override
  String get noPiecesCanBeRemoved => 'Egyetlen darab sem távolítható el.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count darab',
      one: '$count piece',
      zero: 'Piece',
    );
    return '$_temp0 el kell távolítani.';
  }

  @override
  String placedCount(int count) {
    return 'Elhz. ($count)';
  }

  @override
  String get placedPieceCount =>
      'Elhelyezett darabszám az elhelyezési fázisban.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'Az aktuális játékos $count figurát helyezett el.';
  }

  @override
  String get notPlacingPhase =>
      'Nem az elhelyezési fázisban van, nem módosítható.';

  @override
  String get paste => 'Paszta';

  @override
  String get pasteDone => 'A beillesztés megtörtént.';

  @override
  String get cannotPaste => 'Nem lehet beilleszteni.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Az el nem helyezett és eltávolított darabok megjelenítése';

  @override
  String get fullScreen => 'Teljes képernyő';

  @override
  String get reopenToTakeEffect =>
      'Lépjen ki, majd nyissa meg újra az alkalmazást, hogy a beállítások érvénybe lépjenek.';

  @override
  String get forest => 'Erdő';

  @override
  String get desktopImage => 'Asztali kép';

  @override
  String get invalidPosition => 'Érvénytelen pozíció.';

  @override
  String get shareGIF => 'GIF megosztása';

  @override
  String get pixelRatio => 'Pixel arány';

  @override
  String get duration => 'Időtartam';

  @override
  String get gameScreenRecorder => 'Játék képernyő felvevő';

  @override
  String get previous => 'Előző';

  @override
  String get next => 'Következő';

  @override
  String get skip => 'Kihagyás';

  @override
  String get gotIt => 'Megvan';

  @override
  String get youCanModifyRules =>
      'A játékszabályokat a szabálybeállításokban módosíthatja.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Az egérgörgővel módosíthatja az értéket a kiválasztóban.';

  @override
  String get noTimeLimitForThinking =>
      'A 0-ra beállított AI gondolkodási idő azt jelenti, hogy a gondolkodásnak nincs időkorlátja.';

  @override
  String get whatIsMtdf =>
      'Az MTD(f) az alfa-béta keresési algoritmus egy módosított formája, amelynek célja a hatékonyság javítása a közbenső keresési eredmények újrafelhasználásával és egy jó kezdeti találgatással a keresési tér szűkítésére.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Kérjük, vegye figyelembe, hogy az AI gondolkodási idő beállítása nem feltétlenül teljesen pontos. A tényleges gondolkodási idő rövidebb lehet, ha a nehézségi szint alacsonyabb értékre van állítva, és hosszabb lehet, ha az AI középen gondolkodik, amikor lejár az idő.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Ha magasra állítja a nehézségi szintet, de nem növeli az AI gondolkodási idejét, a tényleges nehézségi szint alacsonyabb értékre korlátozódhat a gondolkodási idő korlátja miatt. A tényleges érték a gép teljesítményétől függően változhat.';

  @override
  String get whatIsPvs =>
      'A PVS (Principal Variation Search) egy keresési algoritmus az adott pozícióban a legjobb lépés megtalálására. Ez az alfa-béta algoritmus továbbfejlesztése, és nulla vagy nulla ablakban történő keresést használ annak megerősítésére, hogy egy lépés rosszabb vagy nem rosszabb, mint a fő variáció már biztonságos pontszáma. A PVS a legígéretesebb lépésekre összpontosít, és elkerüli a szuboptimális ágak szükségtelen keresését, ami javítja a keresés hatékonyságát.';

  @override
  String get whatIsAlphaBeta =>
      'Az alfa-béta algoritmus egy keresési algoritmus a legjobb lépés megtalálására. A minimax elvet és két értéket, az alfa és a béta értéket használja a keresési fa metszéséhez és a hatékonyság növeléséhez. Az alfa azt a minimális pontszámot jelenti, amelyet a számítógép biztosan el tud érni, míg a béta azt a maximális pontszámot jelenti, amelyet az ellenfél elérhet. Az algoritmus segít a számítógépnek okos, hatékony döntések meghozatalában a játék során.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Az emberi tapasztalatok szerint, ha megpróbálsz nyerni, akkor veszítesz. Ehelyett célozzon döntetlent, és kerülje el a játék elvesztését. Figyeld meg ellenfeledet, és finoman csald olyan helyzetbe, ahol hibázhatnak. Amikor gyengeséget mutatnak, ragadja meg a lehetőséget, és finoman nyomja meg a győzelmet. Ily módon megnyerheti a játékot.';

  @override
  String get firstMoveDetail =>
      'Ebben a játékban a második játékos könnyebben nyer, mint az első játékos.';

  @override
  String get passiveDetail =>
      'A Passzív opció engedélyezése azt eredményezi, hogy a mesterséges intelligencia ellazul, amikor előnyben van a pozícióban, ahelyett, hogy agresszíven próbálna nyerni a lehető leggyorsabban.';

  @override
  String get moveRandomlyDetail =>
      'Ennek az opciónak az engedélyezése növeli a játék véletlenszerűségét és szórakozását, míg letiltása segíthet a mesterséges intelligencia legyőzésének módjainak tanulmányozásában.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Ha az AI figyelembe veszi bábui mozgékonyságát, akkor nemcsak az ellenfél bábuinak mielőbbi elfogására törekszik, hanem azt is fontolóra veszi, hogy blokkolja az ellenfél mozgását, és megakadályozza, hogy ugyanezt tegye.';

  @override
  String get whenBoardIsFull => 'Amikor megtelt a tábla';

  @override
  String get whenBoardIsFull_Detail =>
      'Az elhelyezési fázis végén, mielőtt a mozgó fázis elkezdődne, az akció következik, ha a tábla tele van figurákkal.';

  @override
  String get sideToMoveRemovePiece =>
      'Az a játékos, aki először mozog a mozgási fázisban, eltávolítja az ellenfél egyik bábuját.';

  @override
  String get agreeToDraw => 'Mindkét fél döntetlenben állapodik meg.';

  @override
  String get takeOpponentsPiece => 'Vedd el ellenfeled egyik bábuját.';

  @override
  String get firstPlayerLose => 'Az első játékos elveszíti a játékot.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Az első és a második játékos eltávolítja az ellenfél egyik bábuját.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'A második és az első játékos eltávolítja az ellenfél egyik bábuját.';

  @override
  String get enteredFlyingPhase =>
      'A repülési fázisba lépve az ellenfeled bármely korongja a tábla bármely üres mezőjére ugorhat.';

  @override
  String get whenStalemate => 'Amikor patthelyzet';

  @override
  String get whenStalemate_Detail =>
      'Mi történik, ha egyetlen darabot sem lehet mozgatni?';

  @override
  String get endWithStalemateLoss =>
      'Vége a blokkolt oldal patthelyzeti veszteségével.';

  @override
  String get changeSideToMove => 'Változtassa meg az oldalt a mozgáshoz.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Távolítsd el az ellenfél egyik bábuját, és tedd meg a következő lépést.';

  @override
  String get endWithStalemateDraw => 'Patthelyzet döntetlennel fejezzük be.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Távolítsd el az ellenfél egyik bábuját, és változtasd meg az oldalt a mozgáshoz.';

  @override
  String get aiResponseDelayTime => 'AI válasz késleltetési ideje';

  @override
  String get aiIsDelaying =>
      'A mesterséges intelligencia jelenleg egy késleltetett válaszfázisban van. Kérjük, várjon egy kicsit a folytatás előtt.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Nem távolíthat el egy nem szomszédos darabot.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'Patthelyzet esetén az ellenfél a tieddel szomszédos bábuit el lehet távolítani, függetlenül a malomfelállástól.';

  @override
  String get whatIsMcts =>
      'Az MCTS egy kezdőbarát algoritmus, amely a különböző mozgások szimulációkon keresztüli feltárásával és értékelésével hoz döntéseket.';

  @override
  String get goldenJade => 'Arany Jade';

  @override
  String get forestWood => 'Forest Wood';

  @override
  String get darkMystery => 'Sötét rejtély';

  @override
  String get midnightBlue => 'Éjkék';

  @override
  String get greenForest => 'Zöld erdő';

  @override
  String get greenMeadow => 'Zöld rét';

  @override
  String get stonyPath => 'Köves ösvény';

  @override
  String get pastelPink => 'Pasztell rózsaszín';

  @override
  String get turquoiseSea => 'Türkiz tenger';

  @override
  String get violetDream => 'Ibolya álom';

  @override
  String get mintChocolate => 'Mentás csokoládé';

  @override
  String get skyBlue => 'Égszínkék';

  @override
  String get playfulGarden => 'Játékos kert';

  @override
  String get whatIsRetrogradeAnalysis =>
      'A Retrográd Analysis algoritmus többértékű retrográd elemzést használ a végjáték-adatbázis felépítéséhez különböző kezdőpozíciókból, majd ezt az adatbázist alkalmazza a játékmenet optimalizálására. Ez a megközelítés az Ultra-Strong megoldások kategóriájába tartozik.';

  @override
  String get viewAlgorithmGuide =>
      'Szeretné megtekinteni az algoritmus felhasználói útmutatóját?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Helyzetelőny jelző megjelenítése';

  @override
  String get usePerfectDatabase => 'Használjon tökéletes adatbázist';

  @override
  String get perfectDatabaseDescription =>
      'Engedélyezze ezt az opciót a hibátlan játékadatbázis használatához, amelyet a legmodernebb algoritmusok generálnak. Ez a funkció integrálja a nyitó és záró stratégiákat az optimális lépések javaslatához. Ez az elsődleges választás azoknak a játékosoknak, akik a játékban a legnagyobb pontosságot keresik. Az adatbázis gondos számítási technikák segítségével készült, és közel tökéletes játékmegoldásokat kínál.\n\nMegjegyzés: Ha az MI nem tud hozzáférni az adatbázishoz, akkor hagyományos algoritmusokhoz fordul a játék döntések meghozatalához. Amikor az adatbázis elérhető, a \'Nehézségi Szint\' gyakorlatilag legyőzhetetlenné válik, és az \'MI Gondolkodási Ideje\' drasztikusan csökken. Az \'MI Játékstílusa\' beállítások közül sokat felülír az adatbázis, mivel az eredményeknek a legmagasabb prioritása van.\n\nTovábbi útmutatóért arra vonatkozóan, hogy hogyan használja ki leginkább ezt a hibátlan adatbázist, kattintson ide.';

  @override
  String get backgroundImage => 'Háttérkép';

  @override
  String get whatIsRandom =>
      'Amikor a \'Használja a tökéletes adatbázist\' opció nincs engedélyezve, a \'Véletlenszerű\' beállítás az AI-t arra készteti, hogy véletlenszerűen mozgassa a bábukat anélkül, hogy bármilyen algoritmust használna a lépések kiválasztására. Ez általában jelentősen gyengébb játékmenetet eredményez. Ezzel szemben, amikor a \'Használja a tökéletes adatbázist\' opció engedélyezve van, az AI kizárólag a \'Tökéletes Adatbázisra\' támaszkodik a döntéshozatal során, ahelyett, hogy azt hagyományos AI algoritmusokkal keverné. Ebben a módban az AI lépései teljes mértékben az adatbázis tartalmán alapulnak, elkerülve a valós idejű számításokra vagy keresési algoritmusokra való támaszkodást.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Vedd ki az ellenfél korongját(korongjait) a kezéből; aztán az ellenfél következik, hogy helyezzen.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Malomképződéskor a helyezési fázisban';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Vedd ki az ellenfél korongját(korongjait) a tábláról.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Vedd ki az ellenfél korongját(korongjait) a tábláról; aztán az ellenfél következik, hogy helyezzen.';

  @override
  String get opponentRemovesOwnPiece =>
      'Az ellenfél eltávolítja saját korongját(korongjait) a tábláról.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Helyetted az ellenfél választja ki és távolítja el saját korongját(korongjait) a tábláról, ezzel hatékonyan olyan lépést végez, ami hátrányos saját magára nézve.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Vedd ki az ellenfél korongját(korongjait) a kezéből; aztán te jössz, hogy mozogj.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Vedd ki a korongot(korongokat) az ellenfél kezéből. Ha a többszörös eltávolítás beállítása szerint több korongot kell eltávolítani és az ellenfélnek nincs több korongja a kezében, folytasd az ellenfél korongjainak eltávolítását a tábláról. Aztán te jössz, hogy mozogj. Ha folytatod a malomképzést, továbbra is eltávolíthatod az ellenfél korongjait.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Vedd ki a korongot(korongokat) az ellenfél kezéből. Ha a többszörös eltávolítás beállítása szerint több korongot kell eltávolítani és az ellenfélnek nincs több korongja a kezében, folytasd az ellenfél korongjainak eltávolítását a tábláról. Aztán az ellenfél következik, hogy mozogjon.';

  @override
  String get markAndDelayRemovingPieces =>
      'Jelölj meg és késleltesd a korongok eltávolítását.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'A helyezési fázisban a korongokat, amelyeket el kell távolítani, megjelölik, és mindkét játékos számára tilos új korongokat helyezni ezekre a pontokra. A mozgási fázisba lépéskor ezeket a megjelölt korongokat egyszerre távolítják el, és a játékosok ezután mozgathatják a korongjaikat ezekre a most üres pontokra.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'A lépések, amelyek meghozhatóak a malomképződés során a helyezési fázisban.';

  @override
  String get marked => 'Megjelölt';

  @override
  String get menu => 'Menü';

  @override
  String get monochrome => 'Monokróm';

  @override
  String get youCanEnableScreenReaderSupport =>
      'A Képernyőolvasó támogatását az Általános beállításoknál a Hozzáférhetőségi beállítások között kapcsolhatja be.';

  @override
  String get showNumbersOnPieces => 'Számok megjelenítése a korongokon';

  @override
  String get saveImage => 'Kép mentése';

  @override
  String get isAnalysisToolbarShown => 'Elemzési eszköztár megjelenítése';

  @override
  String get analysisToolbarBackgroundColor =>
      'Elemzési eszköztár hátterének színe';

  @override
  String get analysisToolbarIconColor => 'Elemzési eszköztár ikonjának színe';

  @override
  String get transformed => 'Átalakítva.';

  @override
  String get cannotTransform => 'Nem lehet átalakítani.';

  @override
  String get rotate => 'Forgat';

  @override
  String get horizontalFlip => 'HF';

  @override
  String get verticalFlip => 'VF';

  @override
  String get innerOuterFlip => 'IOF';

  @override
  String get transparentCanvas => 'Átlátszó Vászon';

  @override
  String get restrictRepeatedMillsFormation =>
      'Ismételt malmok kialakulásának korlátozása';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Egy egyik malomból a másikba áthelyezett bábu nem térhet vissza azonnal az eredeti pontra a következő körben, hogy újra malom alakuljon ki. Először egy másik lépés szükséges.';

  @override
  String get oneTimeUseMill => 'Egyszeri használatú malom';

  @override
  String get oneTimeUseMill_Detail =>
      'Minden malom csak egyszer távolíthatja el az ellenfél egy darabját. Újra megformázhatja, de további eltávolításokhoz nem használható.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'A beállított jelenlegi szabályoknak nincs megfelelő tökéletes adatbázisa. A tökéletes adatbázisról további információkért kattintson ide.';

  @override
  String get focusOnBlockingPaths =>
      'Összpontosítson az útvonalak blokkolására';

  @override
  String get focusOnBlockingPaths_Detail =>
      'A játék bizonyos fázisaiban részesítse előnyben az ellenfél mozgásának akadályozását a malmok kialakításával szemben. Ahelyett, hogy a malmok befejezésével eltávolítaná a darabokat, az MI ezekben a fázisokban törekszik az ellenfél csapdába ejtésére, mozgásképtelenné téve őket és biztosítva a győzelmet kopással, nem pedig agresszív játékkal. Ez a fázisspecifikus stratégia nem akadályozza aktívan az ellenfél malmait.';

  @override
  String get pieceImage => 'Bábuképek';

  @override
  String get importColorSettings => 'Színbeállítások importálása';

  @override
  String get exportColorSettings => 'Színbeállítások exportálása';

  @override
  String get import => 'Importálás';

  @override
  String get export => 'Exportálás';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Kérjük, először másolja a JSON formátumú beállításokat a vágólapra.';

  @override
  String get copiedToClipboard => 'Vágólapra másolva.';

  @override
  String get imported => 'Importálva.';

  @override
  String get boardImage => 'Tábla kép';

  @override
  String get autumnLeaves => 'Őszi levelek';

  @override
  String get legendaryLand => 'Legendás Föld';

  @override
  String get vignetteEffect => 'Vignetta hatás';

  @override
  String get promptMakeToolbarTransparent =>
      'Szeretné a felső eszköztárat teljesen átlátszóvá tenni, amikor egy tábla háttérkép van beállítva?';

  @override
  String get vibration => 'Engedélyezze a rezgést a játékban';

  @override
  String get soundTheme => 'Hang téma';

  @override
  String get ball => 'Labda';

  @override
  String get liquid => 'Folyadék';

  @override
  String get wood => 'Fa';

  @override
  String get placeEffectAnimation => 'Bábu elhelyezési animációs effektus';

  @override
  String get removeEffectAnimation => 'Bábu eltávolítási animációs effektus';

  @override
  String get isToolbarAtBottom => 'Eszköztár megjelenítése alul';

  @override
  String get boardCornerRadius => 'Tábla sarkának sugara';

  @override
  String get useOpeningBook => 'Használja a nyitókönyvet';

  @override
  String get currentRule => 'Jelenlegi';

  @override
  String get nineMensMorris => 'Malom';

  @override
  String get twelveMensMorris => 'Tizenkét férfi Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Szabálykészlet';

  @override
  String get laskerMorris => 'Lasker-malom';

  @override
  String get oneTimeMill => 'Egyszeri Malom';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'Engedje meg az AI-nak, hogy az első játékszakaszban a profi emberi játékosok által gyakran használt nyitómozdulatokat alkalmazza. Megjegyzés: Ez a funkció jelenleg csak bizonyos szabálykészletekhez érhető el.';

  @override
  String get showAdvantageGraph => 'Mutassa az előny grafikonját';

  @override
  String get advantageGraphHint =>
      'Az előnygráf csak akkor kerül megrajzolásra, miután a mesterséges intelligencia lépést tett. Nem kerül megrajzolásra, amikor az emberi játékos lép.';

  @override
  String get removalBasedOnMillCounts =>
      'Tiltsd meg a bábuk eltávolítását, amíg minden bábu a táblára nem kerül, majd a malmok száma alapján távolíts el bábukat.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Tiltsd meg a bábuk eltávolítását, amíg minden bábu a táblára nem kerül, majd a malmok száma alapján távolíts el bábukat: ha megegyezik, mindkét fél ugyanannyi bábut távolít el; ha az egyiknek több van, akkor egy bábuval többet távolít el, hogy megmaradjon az egy bábu különbség. Ha csak az egyik alakít ki malmokat, akkor ő két bábut távolít el, a másik pedig egyet. Ha egyik sem alakít ki malmot, mindkét fél egy-egy bábut távolít el.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Válassz egyet a bábuid közül.';

  @override
  String get notYourTurn => 'Nem te következel.';

  @override
  String get annotationToolbarBackgroundColor => 'Megjegyzősáv háttérszíne';

  @override
  String get annotationToolbarIconColor => 'Megjegyzősáv ikon színe';

  @override
  String get isAnnotationToolbarShown => 'Megjegyzősáv megjelenítése';

  @override
  String get enterAnnotationMode => 'Lépj be a megjegyzési módba';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Biztosan törölni akarod az összes megjegyzést?';

  @override
  String get llmPromptCopiedToClipboard => 'LLM prompt vágólapra másolva.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Kapcsolat megtagadva, a szerver esetleg leállt.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Felderítés sikeres, várakozás a kapcsolatra...';

  @override
  String get noLanConnection => 'Nincs LAN-kapcsolat';

  @override
  String get takeScreenshot => 'Képernyőkép készítése';

  @override
  String get disconnectedFromOpponent =>
      'Megszakadt a kapcsolat az ellenféllel.';

  @override
  String get takeBackRequest => 'Visszalépési kérelem';

  @override
  String get nothingToShow => 'Nincs megjeleníthető tartalom.';

  @override
  String get stopHosting => 'Hosztolás leállítása';

  @override
  String get connectionResetByPeer => 'A kapcsolatot a peer visszaállította.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'A kapcsolat szívverés-időtúllépés miatt megszakadt. Kérjük, csatlakozz újra.';

  @override
  String get startHosting => 'Hosztolás indítása';

  @override
  String get restartRequestRejected => 'Az újraindítási kérés elutasítva.';

  @override
  String get notConnectedToLanOpponent => 'Nincs kapcsolat LAN-ellenféllel.';

  @override
  String get llmPrompt => 'LLM prompt';

  @override
  String get gameRestarted => 'A játék újraindult.';

  @override
  String get takeBackRejected => 'Visszalépés elutasítva.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Biztosan feladod ezt a játékot?';

  @override
  String get opponentResignedYouWin => 'Az ellenfél feladta. Győztél!';

  @override
  String get clearAllAnnotations => 'Összes megjegyzés törlése';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Csatlakozva, várjuk az ellenfél lépését...';

  @override
  String get networkStatusDisconnected => 'Hálózati állapot: kapcsolat bontva';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Visszalépési kérés elküldve az ellenfélnek.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'Lehet, hogy az ellenfél kilépett a játékból';

  @override
  String get connectedToHostSuccessfully =>
      'Sikeresen csatlakoztál a hoszthoz.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'A kapcsolat megszakadt: heartbeat-timeout';

  @override
  String get noHostDiscovered => 'Nem található hoszt.';

  @override
  String get confirmResignation => 'Feladás megerősítése';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'A játék hosztolása elindult, várjuk a csatlakozó játékosokat...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Időtúllépés, instabil hálózati kapcsolat.';

  @override
  String get noLlmPromptAvailable => 'Nincs elérhető LLM prompt.';

  @override
  String get youResignedGameOver => 'Feladtad. Véget ért a játék.';

  @override
  String get serverIp => 'Szerver IP';

  @override
  String get confirmClear => 'Törlés megerősítése';

  @override
  String get opponentSTurn => 'Az ellenfél következik.';

  @override
  String get waitingAClientConnection => 'Várakozás klienskapcsolatra...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'A visszalépési kérés elutasítva vagy sikertelen.';

  @override
  String get addText => 'Szöveg hozzáadása';

  @override
  String get exitAnnotationMode => 'Kilépés a megjegyzési módból';

  @override
  String get typeYourAnnotation => 'Írd be a megjegyzésedet';

  @override
  String get attemptingToReconnect => 'Újracsatlakozás folyamatban...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Újraindítási kérelem elküldve. Várakozás az ellenfél válaszára...';

  @override
  String get serverIsStopped => 'A szerver le van állítva.';

  @override
  String get restartRequest => 'Újraindítási kérelem';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Nem kérhetsz visszalépést, ha nem te következel.';

  @override
  String get takeBackAccepted => 'A visszalépés elfogadva.';

  @override
  String get localNetworkSettings => 'Helyi hálózati beállítások';

  @override
  String get reconnectedSuccessfully => 'Sikeresen újrakapcsolódva!';

  @override
  String get failedToSaveImageToGallery =>
      'A kép mentése a galériába sikertelen.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Az ellenfél kérte a játék újraindítását. Elfogadod?';

  @override
  String get yourTurn => 'Te következel.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Nem sikerült újracsatlakozni, kérjük, indítsd újra a játékot.';

  @override
  String get host => 'Hoszt';

  @override
  String get join => 'Csatlakozás';

  @override
  String get port => 'Port';

  @override
  String get invalidIpAddress => 'Érvénytelen IP-cím.';

  @override
  String get invalidPort => 'Érvénytelen port.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Csatlakozás: próbálkozás $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Nem sikerült csatlakozni: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Nem sikerült elindítani a hosztolást: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Hoszt felfedezve: $ip:$port';
  }

  @override
  String get stop => 'Leállítás';

  @override
  String get discover => 'Felfedezés';

  @override
  String get connect => 'Csatlakozás';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Kliens csatlakozott: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Felfedezés: $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Újracsatlakozás ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Csatlakozva';

  @override
  String get delete => 'Törlés';

  @override
  String get ancientEgypt => 'Árpád-kori Örökség';

  @override
  String get gothicIce => 'Mátyás-kori Gótika';

  @override
  String get riceField => 'Búzamező';

  @override
  String get chinesePorcelain => 'Herendi Porcelán';

  @override
  String get desertDusk => 'Pusztai Alkony';

  @override
  String get precisionCraft => 'Kézműves Elegancia';

  @override
  String get folkEmbroidery => 'Matyó Hímzés';

  @override
  String get carpathianHeritage => 'Kárpát Örökség';

  @override
  String get imperialGrandeur => 'Monarchikus Pompa';

  @override
  String get bohemianCrystal => 'Ajka Kristály';

  @override
  String get savannaSunrise => 'Pusztai Hajnal';

  @override
  String get harmonyBalance => 'Harmónia és Egyensúly';

  @override
  String get cinnamonSpice => 'Paprikás Fűszer';

  @override
  String get anatolianMosaic => 'Zsolnay Mozaik';

  @override
  String get carnivalSpirit => 'Busójárás Szellem';

  @override
  String get custom => 'Sajátos';

  @override
  String get spiceMarket => 'Paprika Piac';

  @override
  String get swipeToRevealTheDrawer => 'Húzd el az ujjad a fiók megnyitásához';

  @override
  String get showGameInfoOnScreenshots =>
      'Játékadatok megjelenítése a képernyőképeken';

  @override
  String get humanMoveTime => 'Emberi időkorlát';

  @override
  String get noTimeLimitForHumanMoves => 'Nincs időkorlát az emberi lépésekre';

  @override
  String get timeoutLoseWillBeApplied =>
      'Időtúllépéses vesztés lesz alkalmazva az emberi játékosra';

  @override
  String get identifyingBoard => 'Játéktábla azonosítása...';

  @override
  String get youCanEnterAnyModelName => 'Bármilyen modell nevét megadhatod.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'A játéktábla pozíciója alkalmazva. A FEN a vágólapra másolva.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Javaslat: próbálj élesebb képet készíteni a játéktábláról.';

  @override
  String get llmPromptTemplate => 'LLM prompt sablon';

  @override
  String get noValidBoardDetected => 'Nem található érvényes játéktábla.';

  @override
  String get selectingImageFromAlbum => 'Kép kiválasztása az albumból...';

  @override
  String get configurePromptTemplate => 'Prompt-sablon konfigurálása';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Prompt-sablon szerkesztése LLM elemzéshez';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'A felismert játéktáblából nem sikerült FEN-t generálni.';

  @override
  String get outputInCurrentLanguage => 'Kimenet a jelenlegi nyelven';

  @override
  String get commonBaseUrls => 'Gyakori Base URL‑ek';

  @override
  String get viewCommonModels => 'Gyakori modellek megtekintése';

  @override
  String get recognitionParametersUpdated =>
      'A felismerési paraméterek frissítve.';

  @override
  String get whiteSMove => 'Fehér következik';

  @override
  String get resetToDefaults => 'Alapértékek visszaállítása';

  @override
  String get photoShoot => 'Fotózás';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Nem sikerült alkalmazni a felismert játéktábla‑pozíciót.';

  @override
  String get llmPromptContent => 'LLM prompt tartalma';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'Az LLM nincs konfigurálva. Kérlek, ellenőrizd a beállításaidat.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Szolgáltató, modell, API Key és Base URL beállítása';

  @override
  String get llmConfiguration => 'LLM konfiguráció';

  @override
  String get configureLlmProvider => 'LLM szolgáltató konfigurálása';

  @override
  String get llmPromptTemplateHeader => 'LLM prompt sablon fejléc';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'A képen egy bábú sem ismerhető fel. Kérlek, próbáld újra.';

  @override
  String get recognizeBoardFromImage => 'Játéktábla felismerése képből';

  @override
  String get viewTips => 'Tippek megtekintése';

  @override
  String get applyToBoard => 'Játéktáblára alkalmaz';

  @override
  String get adjustBoardArea => 'Játéktábla területének beállítása';

  @override
  String get viewCommonUrls => 'Gyakori URL‑ek megtekintése';

  @override
  String get colorAnalysisFailed => 'Színanalízis sikertelen!';

  @override
  String get analyzingGameBoardImage => 'Játéktábla képének elemzése...';

  @override
  String get selectFromAlbum => 'Kiválasztás az albumból';

  @override
  String get noBoardPointDetected => 'Nem észlelhető játéktábla pont!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Ha üresen hagyod, az alapértelmezett sablon kerül használatra';

  @override
  String get llmConfig => 'LLM konfiguráció';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Biztosan vissza szeretnéd állítani a prompt‑sablonokat az alapértelmezett értékekre?';

  @override
  String get llmPromptTemplateFooter => 'LLM prompt sablon lábléc';

  @override
  String get loadingResponse => 'Válasz betöltése...';

  @override
  String get applyThisResultToBoard => 'Eredmény alkalmazása játéktáblára';

  @override
  String get takingPicture => 'Kép készítése...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Kérlek, válassz ki egy játéktábla képét azonosításhoz.';

  @override
  String get identificationResults => 'Azonosítás eredményei';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Elemezd a lépéseket és adj betekintést.';

  @override
  String get getApiKey => 'API Key beszerzése';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Az egész felismerési folyamat nem fejeződött be.';

  @override
  String get boardRecognitionResult => 'Játéktábla felismerési eredménye';

  @override
  String get askLlm => 'Kérdezz az LLM‑től';

  @override
  String get boardDetectionFailed => 'A játéktábla észlelése sikertelen!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Nem észlelhető egyetlen játéktábla pont sem, nem lehet azonosítani a bábut!';

  @override
  String get copyFen => 'FEN másolása';

  @override
  String get commonlyUsedModels => 'Gyakran használt modellek';

  @override
  String get apiKeyOptional => 'API Key (opcionális)';

  @override
  String get noImageSelected => 'Nincs kép kiválasztva';

  @override
  String get blackSMove => 'Fekete következik';

  @override
  String get llm => 'Nagy nyelvi modell';

  @override
  String get llmProvider => 'Szolgáltató';

  @override
  String get baseUrl => 'Alap URL';

  @override
  String get model => 'Modell';

  @override
  String get temperature => 'Hőmérséklet';

  @override
  String get llmCommandReceivedProcessing =>
      'Parancs fogadva! A mesterséges intelligencia feldolgoz...';

  @override
  String get llmDeepThinkingWait =>
      'Mély gondolkodás folyamatban, kérjük, várjon...';

  @override
  String get llmPresentingSoon => 'Hamarosan bemutatjuk...';

  @override
  String get recognitionParameters => 'Felismerési paraméterek';

  @override
  String get adjustParamsDesc =>
      'Paraméterek beállítása a felismerés pontosságának javításához';

  @override
  String get saveParameters => 'Paraméterek mentése';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Nem sikerült elindítani a képfelismerést: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'A képfelismerés sikertelen: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Alkalmazott állás $whiteCount fehér és $blackCount fekete bábuval';
  }

  @override
  String get fenCopiedToClipboard => '(FEN a vágólapra másolva)';

  @override
  String recognitionFailed(String error) {
    return 'A felismerés sikertelen: $error';
  }

  @override
  String get myRating => 'Értékelésem';

  @override
  String get gamesPlayed => 'Játszott játékok';

  @override
  String get wins => 'Győzelmek';

  @override
  String get losses => 'Vesztések';

  @override
  String get draws => 'Döntetlenek';

  @override
  String get lastUpdated => 'Utoljára frissítve';

  @override
  String get format => 'Formátum:';

  @override
  String get resetStatistics => 'Statisztika visszaállítása';

  @override
  String get drawRate => 'Döntetlen arány';

  @override
  String get lossRate => 'Vesztési arány';

  @override
  String get aiStatistics => 'MI statisztika';

  @override
  String get enableStatistics => 'Statisztika engedélyezése';

  @override
  String get enableStatistics_Detail =>
      'Engedélyezés esetén a játékeredmények rögzítésre kerülnek a statisztikában. A visszalépést tartalmazó játékok azonban nem kerülnek rögzítésre. Letiltás esetén a statisztikagyűjtés szünetel.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Ez visszaállítja az összes játékstatisztikát. Ez a művelet nem vonható vissza.';

  @override
  String get boardInnerRingSize => 'A tábla belső gyűrűjének mérete';

  @override
  String get boardShadowEnabled => 'Tábla árnyéka';

  @override
  String get trapAwareness => 'Csapdaészlelés';

  @override
  String get trapAwarenessDescription =>
      'Elemzés közben emeld ki a csapdalépéseket vastag körökkel és nyilakkal.';

  @override
  String trapExists(String trapMoves) {
    return 'Csapda van. Csapdalépések: $trapMoves';
  }

  @override
  String get custodianCapture => 'Szomorú elfogás';

  @override
  String get custodianCaptureDescription =>
      'Csatlakoztassa az ellenfél egyik darabját kettő között egyenes vonalban, hogy elfogja.';

  @override
  String get custodianCaptureEnable => 'Engedje meg a szélsőséges elfogást';

  @override
  String get interventionCapture => 'Beavatkozás';

  @override
  String get interventionCaptureDescription =>
      'Haladjon az ellenfél két darabja közötti üres pontba, hogy mindkettőt elfogja.';

  @override
  String get interventionCaptureEnable => 'Engedélyezze a beavatkozást';

  @override
  String get leapCapture => 'Ugrásfogás';

  @override
  String get leapCaptureDescription =>
      'Fogja meg azáltal, hogy átugor egy szomszédos ellenfél darabját az üres pontba.';

  @override
  String get leapCaptureEnable => 'Engedje meg az ugrás elfogását';

  @override
  String get captureApplicableLines => 'Alkalmazható vonalak';

  @override
  String get captureSquareEdges => 'A tér szélén';

  @override
  String get captureCrossLines =>
      'Az ortogonális vonalak mentén átlépve a négyzetet';

  @override
  String get captureDiagonalLines =>
      'Átlós vonalak mentén, átlépve a négyzetet';

  @override
  String get captureExecutionPhases => 'Végrehajtási szakasz';

  @override
  String get capturePiecesCondition =>
      'Elérhetőség a mozgó szakaszban a fennmaradó darabok alapján';

  @override
  String get capturePiecesConditionUnlimited => 'Nincs korlátozás';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Elérhető, ha három vagy kevesebb darabja van';
}
