// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Croatian (`hr`).
class SHr extends S {
  SHr([String locale = 'hr']) : super(locale);

  @override
  String get appName => 'Mlin';

  @override
  String get welcome => 'Dobro došli';

  @override
  String get yes => 'Da';

  @override
  String get no => 'Ne';

  @override
  String get game => 'Igra';

  @override
  String get humanVsAi => 'Čovjek protiv UI-a';

  @override
  String get humanVsHuman => 'Čovjek protiv čovjeka';

  @override
  String get aiVsAi => 'UI protiv UI-a';

  @override
  String get humanVsCloud => 'Čovjek protiv oblaka';

  @override
  String get humanVsLAN => 'Čovjek protiv LAN-a';

  @override
  String get testViaLAN => 'Test putem LAN-a';

  @override
  String get move => 'Potez';

  @override
  String get showMoveList => 'Popis poteza';

  @override
  String get moveList => 'Popis poteza';

  @override
  String get noGameRecord => 'Nema zapisa';

  @override
  String get ok => 'U redu';

  @override
  String get confirm => 'Potvrdi';

  @override
  String get cancel => 'Odustani';

  @override
  String get tipSelectWrong => 'Odaberite pogrešnu figuru.';

  @override
  String get tipPlace => 'Postavite svoje figure.';

  @override
  String get tipBanPlace => 'Ovdje je ne možete postaviti.';

  @override
  String get tipPlaced => 'Figura je postavljena.';

  @override
  String get tipRemove => 'Uklonite jednu figuru.';

  @override
  String get tipBanRemove => 'Ne možete je ukloniti.';

  @override
  String get tipRemoved => 'Figura je uklonjena.';

  @override
  String get tipMove => 'Pomaknite jednu figuru.';

  @override
  String get tipCannotPlace => 'Ovdje ne možete postaviti svoju figuru.';

  @override
  String get tipCannotMove => 'Ovamo ne možete pomaknuti svoju figuru.';

  @override
  String get tipMill => 'Mlin! Uzmite protivničku figuru.';

  @override
  String get tipContinueMill => 'Nastavite uzimati protivničku figuru.';

  @override
  String get tipSelectOpponentsPiece => 'Odaberite jednu protivničku figuru.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Ne možete ukloniti figuru iz mlina.';

  @override
  String get tipCanMoveOnePoint => 'Figura se može pomaknuti za jedno mjesto.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Ne možete pomicati protivničke figure.';

  @override
  String get tipSelectPieceToMove => 'Odaberite svoj figuru za pomicanje.';

  @override
  String get tipHaveThreePiecesLeft => 'Preostale su vam tri figure.';

  @override
  String get tipCanMoveToAnyPoint => 'Možete se pomaknuti na bilo koje mjesto.';

  @override
  String tipToMove(Object player) {
    return '$player je na potezu.';
  }

  @override
  String get whiteWin => 'Igrač 1 pobjeđuje!';

  @override
  String get blackWin => 'Igrač 2 pobjeđuje!';

  @override
  String get won => 'Pobijedio';

  @override
  String get lost => 'Izgubio';

  @override
  String get thinking => 'Razmišljam …';

  @override
  String get newGame => 'Nova igra';

  @override
  String get importGame => 'Uvezi igru';

  @override
  String get exportGame => 'Izvezi igru';

  @override
  String get gameImported => 'Igra uvezena.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Nije moguće uvesti $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'Potezi i pravila se ne podudaraju.';

  @override
  String get pleaseWait => 'Pričekajte.';

  @override
  String get restartGame => 'Ponovo pokrenuti trenutačnu igru?';

  @override
  String get restart => 'Pokreni ponovo';

  @override
  String get gameStarted => 'Igra je počela, postavite figuru.';

  @override
  String get analyzing => 'Analiziranje …';

  @override
  String error(Object message) {
    return 'Pogreška: $message';
  }

  @override
  String get winRate => 'Stopa pobjeda';

  @override
  String get score => 'Rezultat:';

  @override
  String get white => 'Igrač 1';

  @override
  String get black => 'Igrač 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player ima manje od tri figure.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player se predao.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player ne može pomaknuti nijednu figuru.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Ploča je puna i $player ne može pomaknuti nijednu figuru.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Vrijeme je prošlo, $player je izgubio.';
  }

  @override
  String get drawReasonRule50 =>
      'U fazi pomicanja nijedna figura nije uklonjena u zadnjih određenih broja poteza.';

  @override
  String get drawReasonBoardIsFull => 'Neodlučeno jer je ploča puna.';

  @override
  String get drawReasonThreefoldRepetition =>
      'Neodlučeno zbog trostrukog ponavljanja.';

  @override
  String get gameOverUnknownReason => 'Igra je gotova! Nepoznat razlog.';

  @override
  String get gameOver => 'Igra je gotova';

  @override
  String get youWin => 'Pobjedili ste! Čestitamo!';

  @override
  String challengeHarderLevel(int level) {
    return 'Odigrati težu razinu? Nova razina bit će razina $level!';
  }

  @override
  String get youLose => 'Izgubili ste!';

  @override
  String get analyze => 'Analizirajte';

  @override
  String get about => 'O aplikaciji';

  @override
  String version(Object versionNumber) {
    return 'Verzija: $versionNumber';
  }

  @override
  String get thanks => 'Hvala';

  @override
  String get settings => 'Postavke';

  @override
  String get options => 'Opcije';

  @override
  String get generalSettings => 'Opće postavke';

  @override
  String get skillLevel => 'Razina složenosti';

  @override
  String get moveTime => 'Vrijeme razmišljanja UI-a';

  @override
  String get difficulty => 'Složenost';

  @override
  String get playSounds => 'Zvučni efekti';

  @override
  String get playSoundsInTheGame => 'Sviraj zvukove u igri';

  @override
  String get keepMuteWhenTakingBack =>
      'Bez zvuka pri vraćanju figure na prethodno mjesto';

  @override
  String get tone => 'Ton';

  @override
  String get whoMovesFirst => 'Prvi potez';

  @override
  String get human => 'Čovjek';

  @override
  String get ai => 'UI (umjetna inteligencija)';

  @override
  String get alternate => 'Naizmjence';

  @override
  String get isAutoRestart =>
      'Automatski ponovo pokreni igru kad je igra gotova';

  @override
  String get isAutoChangeFirstMove =>
      'Automatski zamijeni igrače s pravom prvog poteza';

  @override
  String get shufflingEnabled => 'Slučajno pomicanje';

  @override
  String get misc => 'Razno';

  @override
  String get rules => 'Pravila';

  @override
  String get piecesCount => 'Broj figura za svakog igrača';

  @override
  String get piecesCount_Detail => 'Koliko figura ima svaki igrač?';

  @override
  String get flyPieceCount => 'Broj figura za skakanje';

  @override
  String get flyPieceCount_Detail =>
      'Ako je skakanje uključeno, kada igraču preostane određeni broj figura, one se mogu pomaknuti na bilo koje nezauzeto mjesto. Pomicanje nije ograničeno samo na susjedna mjesta kao inače u igri.';

  @override
  String get piecesAtLeastCount => 'Najmanji broj figura';

  @override
  String get hasDiagonalLines => 'Dijagonalne linije';

  @override
  String get hasDiagonalLines_Detail =>
      'Ploči dodaj četiri dijagonalne linije.';

  @override
  String get isDefenderMoveFirst => 'Drugi igrač ima pravo prvog poteza';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Drugi igrač u fazi postavljanja je prvi na redu u fazi pomicanja.';

  @override
  String get mayRemoveMultiple => 'Višestruko uklanjanje';

  @override
  String get mayRemoveMultiple_Detail =>
      'Ako igrač zatvori više od jednog mlina odjednom, može ukloniti isti broj figura protivnika.';

  @override
  String get mayRemoveFromMillsAlways => 'Uništi mlinove';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Standardno je postavljeno da igrači moraju najprije ukloniti bilo koje druge figure prije uklanjanja figura iz formiranog mlina. Uključite ovu opciju za isključivanje ograničenja.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Drugi igrač gubi kada je ploča puna';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Kada je ploča na kraju faze postavljanja puna, igrač koji prvi postavlja figure gubi igru. Inače igra završava neodlučeno.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Izgubi kada ne postoji mogućnost pomicanja';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Igrač će izgubiti ako ga protivnik blokira tako da ne može pomaknuti figure. Ako je ova opcija isključena, promijenite stranu micanja umjesto da objavite gubitak igre.';

  @override
  String get mayFly => 'Skakanje';

  @override
  String get mayFly_Detail =>
      'Ako igrač ima samo tri ili četiri (podesivo) figure, igrač smije pomaknuti figuru na bilo koje slobodno mjesto.';

  @override
  String get nMoveRule => 'Pravilo broja poteza';

  @override
  String get nMoveRule_Detail =>
      'Igra završava neodlučeno ako nijedna figura nije uklonjena u određenom broju poteza.';

  @override
  String get rollback => 'Vraćanje unatrag';

  @override
  String get pleaseSelect => 'Odaberite';

  @override
  String get copy => 'Kopiraj';

  @override
  String get moveHistoryCopied => 'Povijest poteza je kopirana u međuspremnik.';

  @override
  String get help => 'Pomoć';

  @override
  String get feedback => 'Povratne informacije';

  @override
  String get exit => 'Zatvori';

  @override
  String get ruleSettings => 'Postavke pravila';

  @override
  String get color => 'Boja';

  @override
  String get boardColor => 'Boja ploče';

  @override
  String get pieceColor => 'Boja figure';

  @override
  String get backgroundColor => 'Boja pozadine';

  @override
  String get lineColor => 'Boja linija ploče';

  @override
  String get whitePieceColor => 'Boja figura igrača 1';

  @override
  String get blackPieceColor => 'Boja figura igrača 2';

  @override
  String get messageColor => 'Boja poruka';

  @override
  String get isPieceCountInHandShown => 'Prikaži broj nepostavljenih figura';

  @override
  String get isNotationsShown => 'Prikaži notacije na ploči';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Prikaži alatnu traku za navigaciju kroz povijest';

  @override
  String get display => 'Prikaz';

  @override
  String get boardBorderLineWidth => 'Širina rubne linije ploče';

  @override
  String get boardInnerLineWidth => 'Širina unutarnjih linija ploče';

  @override
  String get pieceWidth => 'Širina figure';

  @override
  String get fontSize => 'Veličina fonta';

  @override
  String get standardNotation => 'WMD notacija';

  @override
  String get restore => 'Obnovi';

  @override
  String get restoreDefaultSettings => 'Obnovi standardne postavke';

  @override
  String pick(Object element) {
    return 'Odaberite $element';
  }

  @override
  String get info => 'Info';

  @override
  String get hint => 'Savjet';

  @override
  String get player => 'igrač';

  @override
  String get player1 => 'Igrač 1';

  @override
  String get player2 => 'Igrač 2';

  @override
  String get howToPlay => 'Kako igrati';

  @override
  String get toPlacePiece =>
      'Dodirnite bilo koje dostupno mjesto za postavljanje figure.';

  @override
  String get toSelectPiece => 'Dodirnite figuru da biste je premjestili.';

  @override
  String get toMovePiece =>
      'Dodirnite susjedno slobodno mjesto da biste premjestili figuru.';

  @override
  String get toRemovePiece =>
      'Dodirnite jednu protivničku figuru da biste je uklonili.';

  @override
  String get needToCreateMillFirst =>
      'Za uklanjanje figure najprije morate stvoriti mlin.';

  @override
  String get needToPlayWithOwnPieces => 'Morate igrati s vlastitim figurama.';

  @override
  String get statistics => 'Statistika';

  @override
  String get totalGames => 'Ukupni broj igri';

  @override
  String get results => 'Rezultati';

  @override
  String get left => 'lijevo';

  @override
  String get privacyPolicy => 'Politika privatnosti';

  @override
  String get privacyPolicy_Detail_1 =>
      'Pažljivo pročitajte i budite sigurni da u potpunosti razumijete te da se slažete se s ovom ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Ako se ne slažete s ovom politikom nemojte koristiti ovu aplikaciju. Korištenje aplikacije podrazumijeva da prihvaćate ove uvjete.';

  @override
  String get and => ' i ';

  @override
  String get accept => 'Prihvati';

  @override
  String get takeBack => 'Vrati figuru natrag';

  @override
  String get takingBack => 'Vraćanje figure na prethodno mjesto …';

  @override
  String get waiting => 'Čekanje …';

  @override
  String get stepForward => 'Pomakni figuru naprijed';

  @override
  String get takeBackAll => 'Vrati sve figure na početak';

  @override
  String get stepForwardAll => 'Pomakni sve figure na kraj';

  @override
  String get moveNow => 'Pomakni sada';

  @override
  String get done => 'Gotovo.';

  @override
  String get crackMill => 'Višebrojni mlinovi';

  @override
  String get crackMill_Detail =>
      'Ako igrač ima figure samo u mlinovima, figure u mlinovima će se moći ukloniti.';

  @override
  String get animationDuration => 'Trajanje animacije';

  @override
  String get none => 'Bez';

  @override
  String get theme => 'Tema';

  @override
  String get helpContent =>
      'Cilj igre je ostaviti protivnika s manje od tri figure ili mu onemogućiti pomicanje figura.\n\nIgra automatski završava neodlučeno ako se pozicija dogodi po treći put ili ako se nijedna figura ne ukloni u zadnjih 100 (podesivo) poteza.\n\nIgra se odvija u tri faze:\n\n1. Postavljanje figura na slobodna mjesta\n2. Pomicanje figura na susjedna mjesta\n3. (opcionalna faza) Premještanje figura na bilo koje slobodno mjesto kada igrač ima samo još tri figure\n\nPostavljanje\n\nIgra započinje praznom pločom koja se sastoji od rešetke s dvadeset četiri mjesta. Igrači naizmjence postavljaju svoje figure na slobodna mjesta sve dok svaki igrač ne postavi sve svoje figure na ploču. Igrač koji uspije postaviti tri figure u nizu ima „mlin” i smije ukloniti jednu protivničku figuru s ploče.\n\nU nekim pravilima igrači moraju najprije ukloniti bilo koji drugu figuru prije uklanjanja figura iz formiranog mlina.\n\nU nekim pravilima u fazi postavljanja se mjesta uklonjenih figura ne mogu ponovo zauzeti.\n\nNakon postavljanja svih figura igrači naizmjence pomiču svoje figure.\n\nPomicanje\n\nIgrač pomiče jednu od svojih figura duž linije na slobodno susjedno mjesto. Ako to ne može učiniti gubi igru. Kao u fazi postavljanja, Igrač koji uspije postaviti tri figure u nizu ima „mlin” i smije ukloniti jednu protivničku figuru. Igrač koji ima samo još dvije figure ne može sastaviti novi mlin i gubi igru. Igrač također gubi igru kada ima više od tri figure, ako protivnik blokira njihovo pomicanje.\n\nSkakanje\n\nU nekim varijantama pravila, kada jednom igraču ostanu samo tri figure, igrač može skakati na bilo koja prazna mjesta, ne samo na susjedna.\n';

  @override
  String get versionInfo => 'Informacije o verziji';

  @override
  String get eula => 'Licencni ugovor (EULA)';

  @override
  String get license => 'Licenca';

  @override
  String get sourceCode => 'Izvorni kod';

  @override
  String get appVersion => 'Verzija aplikacije';

  @override
  String get general => 'Općenito';

  @override
  String get advanced => 'Napredno';

  @override
  String get placing => 'Postavljanje';

  @override
  String get moving => 'Pomicanje';

  @override
  String get removing => 'Uklanjanje';

  @override
  String get gameOverCondition => 'Uvjet kraja igre';

  @override
  String get aisPlayStyle => 'Stil igre UI-a';

  @override
  String get passive => 'Pasivno';

  @override
  String get timeout => 'Pauza';

  @override
  String get appearance => 'Izgled';

  @override
  String get drawOnHumanExperience => 'Koristi ljudsko iskustvo za poteze';

  @override
  String get considerMobility => 'Uzmi u obzir pokretljivost figura';

  @override
  String get pieceCount => 'Broj figura:';

  @override
  String inHand(Object player, int count) {
    return '$player u ruci: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player na ploči: $count';
  }

  @override
  String get boardTop => 'Gornji odmak ploče';

  @override
  String get notAIsTurn => 'UI nije na redu.';

  @override
  String get aiIsNotThinking => 'UI ne razmišlja.';

  @override
  String get atEnd => 'Dosegnuli ste kraj popisa poteza.';

  @override
  String get tapBackAgainToLeave =>
      'Zatvorite aplikaciju ponovnim dodirnom na gumb za natrag.';

  @override
  String get more => 'Više';

  @override
  String get experimental => 'Ovo je eksperimentalna funkcija.';

  @override
  String get experiments => 'Eksperimenti';

  @override
  String get ossLicenses => 'Licence otvorenog koda';

  @override
  String get language => 'Jezik';

  @override
  String get defaultLanguage => 'Standardni jezik';

  @override
  String get mayMoveInPlacingPhase =>
      'Figure se mogu pomicati u fazi postavljanja';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Ne postoje zasebne faze postavljanja i pomicanja. To znači da igrači mogu pri svakom potezu odlučiti žele li postaviti figuru na ploču ili pomaknuti jednu od svojih figura (sve dok imaju figure za postavljanje).';

  @override
  String get drawerColor => 'Boja izbornika';

  @override
  String get drawerTextColor => 'Boja teksta izbornika';

  @override
  String get drawerHighlightItemColor => 'Boja isticanja elementa izbornika';

  @override
  String get mainToolbarBackgroundColor => 'Boja pozadine glavne alatne trake';

  @override
  String get mainToolbarIconColor => 'Boja ikona glavne alatne trake';

  @override
  String get navigationToolbarBackgroundColor =>
      'Boja pozadine alatne trake navigacije';

  @override
  String get navigationToolbarIconColor => 'Boja ikona alatne trake navigacije';

  @override
  String get autoHideToolbar => 'Automatski sakrij alatnu traku';

  @override
  String get toolbarLocationOnScreen => 'Mjesto alatne trake na ekranu';

  @override
  String get top => 'Gore';

  @override
  String get bottom => 'Dolje';

  @override
  String get center => 'Središte';

  @override
  String get solidColor => 'Puna boja';

  @override
  String get picture => 'Slika';

  @override
  String get chooseYourPicture => 'Odaberite svoju sliku';

  @override
  String get light => 'Svijetla';

  @override
  String get dark => 'Tamna';

  @override
  String get themes => 'Teme';

  @override
  String get currentTheme => 'Trenutna tema';

  @override
  String get saveTheme => 'Spremi temu';

  @override
  String get showAnalysisGraph => 'Prikaži grafikon analize';

  @override
  String get analysis => 'Analiza';

  @override
  String get saveGame => 'Spremi igru';

  @override
  String get loadGame => 'Učitaj igru';

  @override
  String get setupPosition => 'Pozicija postavljanja';

  @override
  String get showLegalMoves => 'Prikaži dozvoljene poteze';

  @override
  String get showLastMove => 'Prikaži zadnji potez';

  @override
  String get showArrows => 'Prikaži strelice';

  @override
  String get pieces => 'Figure';

  @override
  String get showAnalysis => 'Prikaži analizu';

  @override
  String get threads => 'Tematske poruke';

  @override
  String get getInvolved => 'Uključite se';

  @override
  String get helpImproveTranslate => 'Pomognite poboljšati prijevod';

  @override
  String get tutorial => 'Vježbe';

  @override
  String get classicMill => 'Klasični mlin';

  @override
  String get mixedMill => 'Miješani mlin';

  @override
  String get ceylonMill => 'Šri Lankanski mlin';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Mlin se može više puta razbiti i ponovo stvoriti';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Ako igrač razbije mlin da bi odmah stvorio novi mlin, igrač može vratiti svoju figuru natrag na izvorni čvor u svom sljedećem potezu ako na taj način stvori novi mlin.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Igra završava neodlučeno ako jedan igrač ima tri figure i ako nakon deset poteza niti jedan igrač ne ukloni protivničke figure';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Kada jedan igrač ima samo još tri figure i ako nijedan igrač ne može ukloniti jednu protivničku figuru u deset poteza, igra završava neodlučeno.';

  @override
  String get close => 'Zatvori';

  @override
  String get whitePiece => 'Bijela figura';

  @override
  String get blackPiece => 'Crna figura';

  @override
  String get emptyPoint => 'Prazno mjesto';

  @override
  String get noPoint => 'Nema mjesta';

  @override
  String get placingPhase => 'Faza postavljanja';

  @override
  String get movingPhase => 'Faza pomicanja';

  @override
  String get flyingPhase => 'Faza skakanja';

  @override
  String sideToMove(Object player) {
    return 'Strana za pomicanje: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Zadnji potez: $move';
  }

  @override
  String get selected => 'Odabrano';

  @override
  String get accessibility => 'Pristupačnost';

  @override
  String get screenReaderSupport => 'Podrška čitača ekrana';

  @override
  String get isDraw => 'Neodlučeno!';

  @override
  String get draw => 'Neodlučeno';

  @override
  String get pieceHighlightColor => 'Boja isticanja figure';

  @override
  String get algorithm => 'Algoritam';

  @override
  String get endgameNMoveRule => 'Pravilo broja poteza za završavanje igre';

  @override
  String get endgameNMoveRule_Detail =>
      'Igra završava neodlučeno ako jedan od igrača ima tri figure i ako nijedan igrač ne ukloni jednu figuru unutar određenog broja poteza.';

  @override
  String get drawReasonEndgameRule50 =>
      'Jedan igrač ima samo tri figure i nijedan igrač ne uklanja figuru u određenom broju poteza.';

  @override
  String get threefoldRepetitionRule => 'Pravilo trostrukog ponavljanja';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Igra završava neodlučeno ako se pozicija pojavi po treći put.';

  @override
  String get continueToMakeMove => 'Mlin! Nastavite s pomicanjem.';

  @override
  String get pointStyle => 'Stil mjesta';

  @override
  String get pointWidth => 'Širina mjesta';

  @override
  String get solid => 'Obojeno';

  @override
  String get hollow => 'Šuplje';

  @override
  String get languageName => 'Hrvatski';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count poteza',
      few: '$count poteza',
      one: '$count potez',
      zero: 'Move',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Učitavanje nije uspjelo.';

  @override
  String get filename => 'Ime datoteke';

  @override
  String get browse => 'Pretraži …';

  @override
  String get gameFiles => 'Datoteke igri';

  @override
  String get gameSavedTo => 'Igra je spremljena u';

  @override
  String get empty => 'Prazno';

  @override
  String get noMove => 'Nema pomaka.';

  @override
  String get restoredPosition => 'Obnovljen početni položaj.';

  @override
  String get clean => 'Očisti';

  @override
  String get cleanedUp => 'Očišćeno.';

  @override
  String get remove => 'Ukloni';

  @override
  String get noPiecesCanBeRemoved => 'Nijedna figura se ne može ukloniti.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count figura',
      few: '$count figure',
      one: '$count figura',
      zero: 'Piece',
    );
    return '$_temp0 treba ukloniti.';
  }

  @override
  String placedCount(int count) {
    return 'Post. ($count)';
  }

  @override
  String get placedPieceCount =>
      'Broj postavljenih figura u fazi postavljanja.';

  @override
  String hasPlacedPieceCount(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Trenutačni igrač je postavio $count figura.',
      few: 'Trenutačni igrač je postavio $count figure.',
      one: 'Trenutačni igrač je postavio jednu figuru.',
      zero: 'Trenutačni igrač nije postavio nijednu figuru.',
    );
    return '$_temp0';
  }

  @override
  String get notPlacingPhase =>
      'Nije faza postavljanja, ne može se promijeniti.';

  @override
  String get paste => 'Zalijepi';

  @override
  String get pasteDone => 'Lijepljenje je gotovo.';

  @override
  String get cannotPaste => 'Nije moguće zalijepiti.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Prikaži nepostavljene i uklonjene figure';

  @override
  String get fullScreen => 'Cjeloekranski prikaz';

  @override
  String get reopenToTakeEffect =>
      'Zatvorite i ponovo otvorite aplikaciju kako bi postavke stupile na snagu.';

  @override
  String get forest => 'Šuma';

  @override
  String get desktopImage => 'Slika radne površine';

  @override
  String get invalidPosition => 'Nevažeći položaj.';

  @override
  String get shareGIF => 'Dijeli GIF';

  @override
  String get pixelRatio => 'Omjer piksela';

  @override
  String get duration => 'Trajanje';

  @override
  String get gameScreenRecorder => 'Snimač ekrana igre';

  @override
  String get previous => 'Prethodna';

  @override
  String get next => 'Sljedeća';

  @override
  String get skip => 'Preskoči';

  @override
  String get gotIt => 'Razumijem';

  @override
  String get youCanModifyRules =>
      'Pravila igre možeš mijenjati u postavkama pravila.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Za prilagođavanje vrijednosti u biraču možete koristiti kotačić miša.';

  @override
  String get noTimeLimitForThinking =>
      'Vrijeme razmišljanja UI-a postavljeno na 0 znači da nema vremenskog ograničenja za razmišljanje.';

  @override
  String get whatIsMtdf =>
      'MTD(f) je modificirani oblik alfa-beta algoritma pretraživanja koji ima za cilj poboljšati učinkovitost ponovnim korištenjem posrednih rezultata pretrage i korištenjem dobrog početnog pogađanja za sužavanje prostora pretrage.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Imajte na umu da prilagodba vremena razmišljanja UI-a možda neće biti sasvim precizna. Stvarno vrijeme razmišljanja može biti kraće kada je razina složenosti postavljena na nižu vrijednost i može biti duže kada je UI usred razmišljanja kada vrijeme istekne.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Ako postavite visoku razinu složenosti, ali ne povećate vrijeme razmišljanja UI-a, stvarna razina složenosti može biti ograničena na nižu vrijednost zbog vremenskog ograničenja razmišljanja. Stvarna vrijednost može varirati ovisno o performansama uređaja.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) je algoritam pretraživanja za pronalaženje najboljeg poteza u određenoj poziciji. To je poboljšanje alfa-beta algoritma i koristi pretragu s nultim prozorom (zero-window) za potvrdu da je potez lošiji ili nije lošiji od već sigurnog rezultata iz glavne varijante. PVS se fokusira na poteze koji najviše obećavaju i izbjegava nepotrebne pretrage suboptimalnih grana, što pomaže u poboljšanju učinkovitosti pretrage.';

  @override
  String get whatIsAlphaBeta =>
      'Alfa-beta algoritam je algoritam pretraživanja za pronalaženje najboljeg poteza. Koristi minimax princip i dvije vrijednosti, alfa i beta, za smanjenje stabla pretraživanja i povećanje učinkovitosti. Alfa predstavlja minimalni rezultat za koji je računalo sigurno da može dobiti, dok beta predstavlja maksimalni rezultat koji protivnik može dobiti. Algoritam pomaže računalu donositi pametne i učinkovite odluke u igri.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Prema ljudskom iskustvu, ako pokušate pobijediti, izgubit ćete. Umjesto toga, ciljajte na neodlučeno kao svoj cilj i izbjegnite gubljenje igre. Promatrajte svog protivnika i namamite ga u poziciju u kojoj bi mogao pogriješiti. Kada pokaže slabost, zgrabite priliku i nježno gurnite za pobjedu. Na taj način možete pobijediti igru.';

  @override
  String get firstMoveDetail =>
      'U ovoj igri drugi igrač lakše pobjeđuje nego prvi igrač.';

  @override
  String get passiveDetail =>
      'Uključivanjem pasivne opcije će se UI opustiti kada ima prednost u poziciji, umjesto da agresivno pokušava pobijediti što je brže moguće.';

  @override
  String get moveRandomlyDetail =>
      'Uključivanje ove opcije povećava slučajnost i zabavu igre, dok njezino isključivanje može pomoći u proučavanju načina da se UI pobijedi.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Ako umjetna inteligencija uzme u obzir pokretljivost svojih figura, neće nastojati samo uzimati protivničke figure što je brže moguće, već će također razmotriti blokiranje protivničkih poteza i spriječiti da protivnik učini isto.';

  @override
  String get whenBoardIsFull => 'Kad je ploča puna';

  @override
  String get whenBoardIsFull_Detail =>
      'Na kraju faze postavljanja, prije početka faze pomicanja, slijedi akcija ako je ploča puna figura.';

  @override
  String get sideToMoveRemovePiece =>
      'Igrač koji prvi pomiče figure u fazi pomicanja uklanja jednu od protivničkih figura.';

  @override
  String get agreeToDraw => 'Obje strane pristaju na neodlučeno.';

  @override
  String get takeOpponentsPiece => 'Uzmite jednu od protivničkih figura.';

  @override
  String get firstPlayerLose => 'Prvi igrač gubi igru.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Prvi i drugi igrač uklanjaju jednu protivničku figuru.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Drugi i prvi igrač uklanjaju jednu protivničku figuru.';

  @override
  String get enteredFlyingPhase =>
      'Sada kada smo ušli u fazu skakanja, protivničke figure mogu skakati na bilo koje prazno mjesto na ploči. Pravilo skakanja se može isključiti u „Postavke pravila”.';

  @override
  String get whenStalemate => 'Pat situacija';

  @override
  String get whenStalemate_Detail =>
      'Koja radnja slijedi kada se nijedna figura ne može pomaknuti?';

  @override
  String get endWithStalemateLoss =>
      'Završite s izgubljenim patom za stranu koja je blokirana.';

  @override
  String get changeSideToMove => 'Promijenite stranu za pomicanje.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Uklonite jednu od protivničkih figura i napravite sljedeći potez.';

  @override
  String get endWithStalemateDraw =>
      'Završite igru neodlučeno zbog pat situacije.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Uklonite jednu od protivničkih figura i promijenite stranu kretanja.';

  @override
  String get aiResponseDelayTime => 'Vrijeme odgode odgovora za UI';

  @override
  String get aiIsDelaying =>
      'UI je trenutačno u fazi odgođenog odgovora. Pričekajte neko vrijeme prije nastavljanja.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Ne možete ukloniti nesusjednu figuru.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'Ako dođe do pat pozicije, možete ukloniti protivničke figure pored vaših bez obzira na formaciju mlina.';

  @override
  String get whatIsMcts =>
      'MCTS je algoritam prilagođen početnicima koji donosi odluke istražujući i procjenjujući različite poteze kroz simulacije.';

  @override
  String get goldenJade => 'Zlatni žad';

  @override
  String get forestWood => 'Šumsko drvo';

  @override
  String get darkMystery => 'Tamna misterija';

  @override
  String get midnightBlue => 'Ponoćno plava';

  @override
  String get greenForest => 'Zelena šuma';

  @override
  String get greenMeadow => 'Zelena livada';

  @override
  String get stonyPath => 'Kameniti put';

  @override
  String get pastelPink => 'Pastelno ružičasta';

  @override
  String get turquoiseSea => 'Tirkizno more';

  @override
  String get violetDream => 'Ljubičasti san';

  @override
  String get mintChocolate => 'Mint čokolada';

  @override
  String get skyBlue => 'Nebesko plava';

  @override
  String get playfulGarden => 'Razigrani vrt';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Algoritam retrogradne analize koristi viševrijednu retrogradnu analizu za izgradnju baze podataka završetka igre s različitih početnih pozicija, a zatim primjenjuje tu bazu podataka za optimizaciju igranja. Ovaj pristup spada u kategoriju ultra jakog rješenja.';

  @override
  String get viewAlgorithmGuide =>
      'Želite li vidjeti korisnički priručnik za ovaj algoritam?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Prikaži indikator položajne prednosti';

  @override
  String get usePerfectDatabase => 'Koristi savršenu bazu podataka';

  @override
  String get perfectDatabaseDescription =>
      'Uključite ovu opciju za korištenje besprijekorne baze podataka igara generirane pomoću najsuvremenijih algoritama. Ova značajka integrira strategije otvaranja i završnice kako bi predložila optimalne poteze. Ovo je preferirani izbor za igrače koji traže najvišu razinu preciznosti u igri. Stvorena pomoću detaljnih računalnih tehnika, baza podataka dizajnirana je da ponudi gotovo savršena rješenja za igre.\n\nNapomena: Ako UI ne uspije pristupiti bazi podataka, obratit će se konvencionalnim algoritmima za donošenje odluka u igri. Kada je baza podataka dostupna, „Razina složenosti” postaje gotovo nepobjediva, a „Vrijeme razmišljanja UI-a” doživljava drastično smanjenje. Mnoge postavke unutar opcija „Stil igre UI-a” bit će poništene jer rezultati baze podataka imaju najveći prioritet.\n\nZa smjernice o tome kako najbolje iskoristiti ovu besprijekornu bazu podataka, kliknite ovdje.';

  @override
  String get backgroundImage => 'Pozadinska slika';

  @override
  String get whatIsRandom =>
      'Kada opcija \'Koristi savršenu bazu podataka\' nije uključena, postavka \'Slučajno\' uzrokuje da UI pomiče dijelove slučajno bez korištenja algoritama za odabir poteza. To obično rezultira znatno slabijim igranjem. Nasuprot tome, kada je opcija \"Koristi savršenu bazu podataka\" uključena, UI se za donošenje odluka isključivo oslanja na sadržaj u \"Savršena baza podataka\", umjesto da je miješa s tradicionalnim algoritmima umjetne inteligencije. U ovom načinu rada, potezi umjetne inteligencije u potpunosti se temelje na sadržaju baze podataka, izbjegavajući oslanjanje na kalkulacije u stvarnom vremenu ili algoritme pretraživanja.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Uklonite protivničke figure iz njegove ruke; zatim je protivnik na redu da postavi figuru.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Kada se formiraju mlinovi tijekom faze postavljanja';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Uklonite protivničke figure s ploče.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Uklonite protivničku figure s ploče; zatim je protivnik na redu da postavi figuru.';

  @override
  String get opponentRemovesOwnPiece =>
      'Protivnik uklanja svoje figure s ploče.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Umjesto da vi poduzmete akciju, protivnik bira i uklanja svoje figure s ploče, čime poduzima akciju koja njemu šteti.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Uklonite protivničke figure iz njegove ruke; zatim ste vi na potezu.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Uklonite figure iz protivničke ruke. Ako prema postavci višestrukog uklanjanja treba ukloniti više figura, a protivnik nema više figura u ruci, nastavi uklanjati protivničke figure s ploče. Zatim ste vi na potezu. Ako nastavite formirati mlinove, možete nastaviti uklanjati protivničke figure.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Uklonite figure iz protivničke ruke. Ako prema postavci višestrukog uklanjanja treba ukloniti više figura, a protivnik nema više figura u ruci, nastavite uklanjati protivničke figure s ploče. Zatim je protivnik na potezu.';

  @override
  String get markAndDelayRemovingPieces => 'Označi i odgodi uklanjanje figura.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Tijekom faze postavljanja, figure koje treba ukloniti se označavaju i nijedan jedan igrač ne može postaviti nove figure na ova mjesta. Po ulasku u fazu pomicanja, ove se označene figure potpuno uklanjaju, a igrači tada mogu svoje figure pomaknuti na ova sada prazna mjesta.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Radnje koje se mogu poduzeti prilikom formiranja mlinova u fazi postavljanja.';

  @override
  String get marked => 'Označeno';

  @override
  String get menu => 'Izbornik';

  @override
  String get monochrome => 'Jednobojno';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Podrška za čitač ekrana se može uključiti u konfiguraciji pristupačnosti u „Opće postavke”.';

  @override
  String get showNumbersOnPieces => 'Prikaži brojeve na figurama';

  @override
  String get saveImage => 'Spremi sliku';

  @override
  String get isAnalysisToolbarShown => 'Prikaži alatnu traku za analizu';

  @override
  String get analysisToolbarBackgroundColor =>
      'Boja pozadine alatne trake za analizu';

  @override
  String get analysisToolbarIconColor => 'Boja ikone alatne trake za analizu';

  @override
  String get transformed => 'Transformirano.';

  @override
  String get cannotTransform => 'Nije moguće transformirati.';

  @override
  String get rotate => 'Okreni';

  @override
  String get horizontalFlip => 'Vod. okret';

  @override
  String get verticalFlip => 'Okom. okret';

  @override
  String get innerOuterFlip => 'U/V okret';

  @override
  String get transparentCanvas => 'Prozirno platno';

  @override
  String get restrictRepeatedMillsFormation =>
      'Ograniči ponavljano formiranje mlinova';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Figura koja se pomakne iz jednog mlina za formiranje jednog drugog mlina se ne može odmah vratiti na izvorno mjesto u sljedećem potezu kako bi ponovo formirala mlin. Najprije se mora odigrati jedan drugi potez.';

  @override
  String get oneTimeUseMill => 'Jednokratna uporaba mlina';

  @override
  String get oneTimeUseMill_Detail =>
      'Svaki mlin može ukloniti samo jednu protivničku figuru. Mlin možete ponovo formirati, ali se ne može koristiti za dodatna uklanjanja.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Trenutačno postavljena pravila nemaju odgovarajuću savršenu bazu podataka. Za više informacija o savršenoj bazi podataka kliknite ovdje.';

  @override
  String get focusOnBlockingPaths => 'Prioriziraj blokiranje kretanja';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Tijekom određenih faza igre priorizirajte ometanje protivnika u pomicanju figura umjesto formiranja mlinova. Umjesto da se usredotoči na uklanjanje figura sastavljanjem mlinova, UI nastoji uhvatiti protivnika u zamku, onemogućiti mu pomicanje figura i osigurati pobjedu iscrpljivanjem, a ne agresivnom igrom. Ova strategija ne blokira aktivno protivničke mlinove.';

  @override
  String get pieceImage => 'Slika figure';

  @override
  String get importColorSettings => 'Uvezi postavke boja';

  @override
  String get exportColorSettings => 'Izvezi postavke boja';

  @override
  String get import => 'Uvezi';

  @override
  String get export => 'Izvezi';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Najprije kopirajte postavke JSON formata u međuspremnik.';

  @override
  String get copiedToClipboard => 'Kopirano u međuspremnik.';

  @override
  String get imported => 'Uvezeno.';

  @override
  String get boardImage => 'Slika ploče';

  @override
  String get autumnLeaves => 'Jesensko lišće';

  @override
  String get legendaryLand => 'Legendarna zemlja';

  @override
  String get vignetteEffect => 'Efekt vinjete';

  @override
  String get promptMakeToolbarTransparent =>
      'Želite li koristiti potpuno prozirnu alatnu traku kada je postavljena pozadinska slika ploče?';

  @override
  String get vibration => 'Uključi vibraciju u igri';

  @override
  String get soundTheme => 'Tema zvuka';

  @override
  String get ball => 'Lopta';

  @override
  String get liquid => 'Tekućina';

  @override
  String get wood => 'Drvo';

  @override
  String get placeEffectAnimation => 'Animacijski efekt postavljanja figure';

  @override
  String get removeEffectAnimation => 'Animacijski efekt uklanjanja figure';

  @override
  String get isToolbarAtBottom => 'Prikaži alatnu traku dolje';

  @override
  String get boardCornerRadius => 'Polumjer kuta ploče';

  @override
  String get useOpeningBook => 'Koristi knjigu postavljanja figura';

  @override
  String get currentRule => 'Trenutačno';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Skup pravila';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'Jednokratni mlin';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'Dopustite UI-u da koristi otvarajuće poteze koje profesionalni ljudski igrači uobičajeno koriste u početku igre. Napomena: Ova je funkcija trenutačno dostupna samo za određene skupove pravila.';

  @override
  String get showAdvantageGraph => 'Prikaži graf prednosti';

  @override
  String get advantageGraphHint =>
      'Graf prednosti će se nacrtati samo nakon što UI napravi potez. Neće se nacrtati kada ljudski igrač napravi potez.';

  @override
  String get removalBasedOnMillCounts =>
      'Onemogućite uklanjanje dok sve figure nisu postavljene, zatim uklonite figure na temelju broja mlinova.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Onemogućite uklanjanje dok sve figure nisu postavljene, zatim uklonite figure na temelju broja mlinova: ako je broj jednak, oba igrača uklanjaju isti broj figura; ako netko ima više, uklanja dodatnu figuru i održava razliku od jedne figure. Ako samo jedan igrač formira mlin, on uklanja dvije figure, a drugi igrač jednu. Ako nijedan igrača ne formira mlin, oba igrača uklanjaju jednu vlastitu figuru.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Odaberite jednu svoju figuru.';

  @override
  String get notYourTurn => 'Nije vaš potez.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Boja pozadine alatne trake za bilješke';

  @override
  String get annotationToolbarIconColor =>
      'Boja ikone alatne trake za bilješke';

  @override
  String get isAnnotationToolbarShown => 'Prikaži alatnu traku za bilješke';

  @override
  String get enterAnnotationMode => 'Uđi u način bilješki';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Jeste li sigurni da želite ukloniti sve bilješke?';

  @override
  String get llmPromptCopiedToClipboard =>
      'LLM upit je kopiran u međuspremnik.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Veza je odbijena, poslužitelj možda ne radi.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Otkrivanje je uspjelo, čeka se veza...';

  @override
  String get noLanConnection => 'Nema LAN veze';

  @override
  String get takeScreenshot => 'Snimite snimku zaslona';

  @override
  String get disconnectedFromOpponent => 'Veza s protivnikom je prekinuta.';

  @override
  String get takeBackRequest => 'Zahtjev za povrat poteza';

  @override
  String get nothingToShow => 'Ništa za prikaz.';

  @override
  String get stopHosting => 'Prekinite hostanje';

  @override
  String get connectionResetByPeer =>
      'Veza je resetirana od strane suprotne strane.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Veza izgubljena zbog isteka vremena za heartbeat. Ponovo se povežite.';

  @override
  String get startHosting => 'Započnite hostanje';

  @override
  String get restartRequestRejected =>
      'Zahtjev za ponovno pokretanje je odbijen.';

  @override
  String get notConnectedToLanOpponent => 'Niste povezani s LAN protivnikom.';

  @override
  String get llmPrompt => 'LLM upit';

  @override
  String get gameRestarted => 'Igra je ponovo pokrenuta.';

  @override
  String get takeBackRejected => 'Povrat poteza je odbijen.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Jeste li sigurni da želite predati ovu igru?';

  @override
  String get opponentResignedYouWin => 'Protivnik se predao. Pobjeđujete!';

  @override
  String get clearAllAnnotations => 'Obrišite sve bilješke';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Povezano, čeka se protivnikov potez...';

  @override
  String get networkStatusDisconnected => 'Status mreže: Prekinuta veza';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Zahtjev za povrat poteza poslan protivniku.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'Protivnik je možda napustio igru';

  @override
  String get connectedToHostSuccessfully => 'Uspješno povezano s hostom.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Veza je izgubljena: istek vremena za heartbeat';

  @override
  String get noHostDiscovered => 'Nema pronađenih hostova.';

  @override
  String get confirmResignation => 'Potvrdi predaju';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Počelo hostanje igre, čeka se da se igrači pridruže...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Veza je istekla, mrežna veza je nestabilna.';

  @override
  String get noLlmPromptAvailable => 'Nema dostupnog LLM upita.';

  @override
  String get youResignedGameOver => 'Predali ste se. Kraj igre.';

  @override
  String get serverIp => 'IP poslužitelja';

  @override
  String get confirmClear => 'Potvrdi brisanje';

  @override
  String get opponentSTurn => 'Protivnikov potez.';

  @override
  String get waitingAClientConnection => 'Čeka se veza klijenta...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Zahtjev za povrat poteza je odbijen ili nije uspio.';

  @override
  String get addText => 'Dodaj tekst';

  @override
  String get exitAnnotationMode => 'Izađi iz načina bilješki';

  @override
  String get typeYourAnnotation => 'Upišite svoju bilješku';

  @override
  String get attemptingToReconnect => 'Ponovno povezivanje u tijeku…';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Zahtjev za ponovno pokretanje poslan. Čeka se odgovor protivnika...';

  @override
  String get serverIsStopped => 'Poslužitelj je zaustavljen.';

  @override
  String get restartRequest => 'Zahtjev za ponovno pokretanje';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Ne možete zatražiti povrat poteza kada nije vaš potez.';

  @override
  String get takeBackAccepted => 'Povrat poteza je prihvaćen.';

  @override
  String get localNetworkSettings => 'Postavke lokalne mreže';

  @override
  String get reconnectedSuccessfully => 'Ponovno povezivanje je uspjelo!';

  @override
  String get failedToSaveImageToGallery =>
      'Spremanje slike u galeriju nije uspjelo.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Protivnik je zatražio ponovno pokretanje igre. Prihvaćate li?';

  @override
  String get yourTurn => 'Vaš potez.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Nije moguće ponovo se povezati, ponovo pokrenite igru.';

  @override
  String get host => 'Host';

  @override
  String get join => 'Pridruži se';

  @override
  String get port => 'Port';

  @override
  String get invalidIpAddress => 'Nevažeća IP adresa.';

  @override
  String get invalidPort => 'Nevažeći port.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Povezivanje: pokušaj $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Povezivanje nije uspjelo: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Pokretanje hostanja nije uspjelo: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Otkriven host: $ip:$port';
  }

  @override
  String get stop => 'Zaustavi';

  @override
  String get discover => 'Otkrij';

  @override
  String get connect => 'Poveži se';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Klijent se povezao: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Otkrivanje: $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Ponovno povezivanje ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Povezano';

  @override
  String get delete => 'Izbriši';

  @override
  String get ancientEgypt => 'Drevni Egipat';

  @override
  String get gothicIce => 'Gotski Led';

  @override
  String get riceField => 'Rižino Polje';

  @override
  String get chinesePorcelain => 'Kineski Porculan';

  @override
  String get desertDusk => 'Pustinjski Sumrak';

  @override
  String get precisionCraft => 'Precizni Zanat';

  @override
  String get folkEmbroidery => 'Narodni Vez';

  @override
  String get carpathianHeritage => 'Karpatsko Nasljeđe';

  @override
  String get imperialGrandeur => 'Carigradska Veličanstvenost';

  @override
  String get bohemianCrystal => 'Boemski Kristal';

  @override
  String get savannaSunrise => 'Savanski Izlazak Sunca';

  @override
  String get harmonyBalance => 'Harmonija i Ravnoteža';

  @override
  String get cinnamonSpice => 'Cimetni Začin';

  @override
  String get anatolianMosaic => 'Anatolijski Mozaik';

  @override
  String get carnivalSpirit => 'Karnevalski Duh';

  @override
  String get custom => 'Prilagođen';

  @override
  String get spiceMarket => 'Tržnica začina';

  @override
  String get swipeToRevealTheDrawer => 'Prijeđite prstom za prikaz ladice';

  @override
  String get showGameInfoOnScreenshots =>
      'Prikaži informacije o igri na snimkama zaslona';

  @override
  String get humanMoveTime => 'Vremensko ograničenje za ljudski potez';

  @override
  String get noTimeLimitForHumanMoves =>
      'Nema vremenskog ograničenja za ljudske poteze';

  @override
  String get timeoutLoseWillBeApplied =>
      'Gubitak zbog isteka vremena primijenit će se za ljudskog igrača';

  @override
  String get identifyingBoard => 'Prepoznavanje ploče...';

  @override
  String get youCanEnterAnyModelName => 'Možete unijeti bilo koje ime modela.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Položaj ploče primijenjen. FEN je kopiran u međuspremnik.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Prijedlog: pokušajte snimiti jasniju sliku ploče.';

  @override
  String get llmPromptTemplate => 'Predložak LLM upita';

  @override
  String get noValidBoardDetected => 'Nije otkrivena valjana ploča.';

  @override
  String get selectingImageFromAlbum => 'Odabir slike iz albuma...';

  @override
  String get configurePromptTemplate => 'Konfiguriraj predložak upita';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Uredi predložak upita za LLM analizu';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Neuspješno generiranje FEN-a iz prepoznate ploče.';

  @override
  String get outputInCurrentLanguage => 'Ispis na trenutnom jeziku';

  @override
  String get commonBaseUrls => 'Uobičajeni Base URL-ovi';

  @override
  String get viewCommonModels => 'Prikaži uobičajene modele';

  @override
  String get recognitionParametersUpdated =>
      'Parametri prepoznavanja ažurirani.';

  @override
  String get whiteSMove => 'Bijeli na potezu';

  @override
  String get resetToDefaults => 'Vrati na zadano';

  @override
  String get photoShoot => 'Fotografiranje';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Neuspješno primjenjivanje prepoznate pozicije ploče.';

  @override
  String get llmPromptContent => 'Sadržaj LLM upita';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM nije konfiguriran. Provjerite postavke.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Postavi provider, model, API Key i Base URL';

  @override
  String get llmConfiguration => 'LLM konfiguracija';

  @override
  String get configureLlmProvider => 'Konfiguriraj LLM providera';

  @override
  String get llmPromptTemplateHeader => 'Zaglavlje predloška LLM upita';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'U slici nisu prepoznate figure. Pokušajte ponovo.';

  @override
  String get recognizeBoardFromImage => 'Prepoznaj ploču sa slike';

  @override
  String get viewTips => 'Prikaži savjete';

  @override
  String get applyToBoard => 'Primijeni na ploču';

  @override
  String get adjustBoardArea => 'Prilagodi područje ploče';

  @override
  String get viewCommonUrls => 'Prikaži uobičajene URL-ove';

  @override
  String get colorAnalysisFailed => 'Analiza boja neuspjela!';

  @override
  String get analyzingGameBoardImage => 'Analizira se slika ploče...';

  @override
  String get selectFromAlbum => 'Odaberite iz albuma';

  @override
  String get noBoardPointDetected =>
      'Niti jedna točka na ploči nije pronađena!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Ako ostane prazno, koristit će se zadani predložak';

  @override
  String get llmConfig => 'LLM konfiguracija';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Jeste li sigurni da želite resetirati predloške upita na zadane vrijednosti?';

  @override
  String get llmPromptTemplateFooter => 'Podnožje predloška LLM upita';

  @override
  String get loadingResponse => 'Učitavanje odgovora...';

  @override
  String get applyThisResultToBoard => 'Primijeni ovaj rezultat na ploču';

  @override
  String get takingPicture => 'Snimanje slike…';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Odaberite sliku ploče za prepoznavanje';

  @override
  String get identificationResults => 'Rezultati prepoznavanja';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Analizirajte poteze i pružite uvide.';

  @override
  String get getApiKey => 'Preuzmi API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Cijeli proces prepoznavanja nije dovršen.';

  @override
  String get boardRecognitionResult => 'Rezultat prepoznavanja ploče';

  @override
  String get askLlm => 'Pitaj LLM';

  @override
  String get boardDetectionFailed => 'Detekcija ploče neuspjela!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Nije pronađena nijedna točka ploče, nije moguće prepoznati figuru!';

  @override
  String get copyFen => 'Kopiraj FEN';

  @override
  String get commonlyUsedModels => 'Često korišteni modeli';

  @override
  String get apiKeyOptional => 'API Key (neobavezno)';

  @override
  String get noImageSelected => 'Nijedna slika nije odabrana';

  @override
  String get blackSMove => 'Crni na potezu';

  @override
  String get llm => 'Veliki jezični model';

  @override
  String get llmProvider => 'Pružatelj';

  @override
  String get baseUrl => 'Osnovni URL';

  @override
  String get model => 'Model';

  @override
  String get temperature => 'Temperatura';

  @override
  String get llmCommandReceivedProcessing =>
      'Naredba primljena! UI obrađuje...';

  @override
  String get llmDeepThinkingWait =>
      'Duboko razmišljanje u tijeku, pričekajte...';

  @override
  String get llmPresentingSoon => 'Uskoro će se prikazati…';

  @override
  String get recognitionParameters => 'Parametri prepoznavanja';

  @override
  String get adjustParamsDesc =>
      'Prilagodite parametre kako biste poboljšali točnost prepoznavanja';

  @override
  String get saveParameters => 'Spremi parametre';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Nije moguće pokrenuti prepoznavanje slike: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Prepoznavanje slike nije uspjelo: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Primijenjen položaj s $whiteCount bijelih i $blackCount crnih kamenčića';
  }

  @override
  String get fenCopiedToClipboard => '(FEN kopiran u međuspremnik)';

  @override
  String recognitionFailed(String error) {
    return 'Prepoznavanje nije uspjelo: $error';
  }

  @override
  String get myRating => 'Moja ocjena';

  @override
  String get gamesPlayed => 'Odigrane igre';

  @override
  String get wins => 'Pobjede';

  @override
  String get losses => 'Porazi';

  @override
  String get draws => 'Neriješeno';

  @override
  String get lastUpdated => 'Posljednje ažuriranje';

  @override
  String get format => 'Format:';

  @override
  String get resetStatistics => 'Poništi statistiku';

  @override
  String get drawRate => 'Stopa neriješenih';

  @override
  String get lossRate => 'Stopa poraza';

  @override
  String get aiStatistics => 'Statistika UI-a';

  @override
  String get enableStatistics => 'Uključi statistiku';

  @override
  String get enableStatistics_Detail =>
      'Kada je uključeno, rezultati igre bilježit će se u statistici. Međutim, igre koje uključuju vraćanje poteza neće se bilježiti. Kada je isključeno, prikupljanje statistike je pauzirano.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Ovo će poništiti svu statistiku igre. Ovu radnju nije moguće poništiti.';

  @override
  String get boardInnerRingSize => 'Veličina unutarnjeg prstena ploče';

  @override
  String get boardShadowEnabled => 'Sjena ploče';

  @override
  String get trapAwareness => 'Prepoznavanje zamki';

  @override
  String get trapAwarenessDescription =>
      'Istakni poteze zamke podebljanim krugovima i strelicama tijekom analize.';

  @override
  String trapExists(String trapMoves) {
    return 'Postoji zamka. Potezi zamke: $trapMoves';
  }

  @override
  String get custodianCapture => 'Bočno hvatanje';

  @override
  String get custodianCaptureDescription =>
      'Priložite jedan od vašeg protivnika između dva vašeg u ravnoj liniji da biste ga uhvatili.';

  @override
  String get custodianCaptureEnable => 'Ostavite bočno hvatanje';

  @override
  String get interventionCapture => 'Intervencija hvatanje';

  @override
  String get interventionCaptureDescription =>
      'Pomaknite se u praznu točku između dva komada protivnika kako biste ih oboje uhvatili.';

  @override
  String get interventionCaptureEnable => 'Omogućite hvatanje intervencije';

  @override
  String get leapCapture => 'Skok hvatanje';

  @override
  String get leapCaptureDescription =>
      'Uhvatite skokom preko susjednog protivnika u praznu točku izvan.';

  @override
  String get leapCaptureEnable => 'Omogući snimanje skoka';

  @override
  String get captureApplicableLines => 'Primjenjive linije';

  @override
  String get captureSquareEdges => 'Uz rubove trga';

  @override
  String get captureCrossLines => 'Duž ortogonalnih linija prelazeći kvadrat';

  @override
  String get captureDiagonalLines =>
      'Duž dijagonalnih linija koje prelaze kvadrat';

  @override
  String get captureExecutionPhases => 'Faze izvršenja';

  @override
  String get capturePiecesCondition =>
      'Dostupnost tijekom faze pokreta na temelju preostalih komada';

  @override
  String get capturePiecesConditionUnlimited => 'Nema ograničenja';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Dostupno kad imate tri ili manje komada';
}
