// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Hindi (`hi`).
class SHi extends S {
  SHi([String locale = 'hi']) : super(locale);

  @override
  String get appName => 'चर भर';

  @override
  String get welcome => 'स्वागत है';

  @override
  String get yes => 'हाँ';

  @override
  String get no => 'नहीं';

  @override
  String get game => 'खेल';

  @override
  String get humanVsAi => 'मानव बनाम एआई';

  @override
  String get humanVsHuman => 'मानव बनाम मानव';

  @override
  String get aiVsAi => 'एआई बनाम एआई';

  @override
  String get humanVsCloud => 'मानव बनाम क्लाउड';

  @override
  String get humanVsLAN => 'मानव बनाम लैन';

  @override
  String get testViaLAN => 'लैन के माध्यम से परीक्षण करें';

  @override
  String get move => 'चाल';

  @override
  String get showMoveList => 'सूची ले जाएँ';

  @override
  String get moveList => 'सूची ले जाएँ';

  @override
  String get noGameRecord => 'कोई रिकॉर्ड नहीं';

  @override
  String get ok => 'ठीक है';

  @override
  String get confirm => 'पुष्टि करें';

  @override
  String get cancel => 'रद्द करना';

  @override
  String get tipSelectWrong => 'गलत टुकड़ा चुनें।';

  @override
  String get tipPlace => 'अपने टुकड़े रखें।';

  @override
  String get tipBanPlace => 'इसे यहां नहीं रख सकते।';

  @override
  String get tipPlaced => 'रखा हे।';

  @override
  String get tipRemove => 'एक टुकड़ा निकालें।';

  @override
  String get tipBanRemove => 'हटा नहीं सकता।';

  @override
  String get tipRemoved => 'हटा दिया।';

  @override
  String get tipMove => 'एक टुकड़ा ले जाएँ।';

  @override
  String get tipCannotPlace => 'आप अपना टुकड़ा यहाँ नहीं रख सकते।';

  @override
  String get tipCannotMove => 'आप अपना टुकड़ा यहां नहीं ले जा सकते।';

  @override
  String get tipMill => 'चक्की! अपने प्रतिद्वंद्वी का टुकड़ा ले लो।';

  @override
  String get tipContinueMill => 'अपने प्रतिद्वंद्वी का टुकड़ा लेना जारी रखें।';

  @override
  String get tipSelectOpponentsPiece =>
      'अपने प्रतिद्वंद्वी के टुकड़ों में से एक का चयन करें।';

  @override
  String get tipCannotRemovePieceFromMill =>
      'आप चक्की से एक टुकड़ा नहीं निकाल सकते।';

  @override
  String get tipCanMoveOnePoint => 'एक टुकड़ा 1 बिंदु आगे बढ़ सकता है।';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'आप अपने प्रतिद्वंद्वी के टुकड़े नहीं हिला सकते।';

  @override
  String get tipSelectPieceToMove =>
      'स्थानांतरित करने के लिए अपने टुकड़े का चयन करें।';

  @override
  String get tipHaveThreePiecesLeft => 'आपके पास 3 टुकड़े बचे हैं।';

  @override
  String get tipCanMoveToAnyPoint =>
      'आप अपनी पसंद के किसी भी बिंदु पर जा सकते हैं।';

  @override
  String tipToMove(Object player) {
    return '$player स्थानांतरित करने के लिए।';
  }

  @override
  String get whiteWin => 'खिलाड़ी 1 जीतता है!';

  @override
  String get blackWin => 'खिलाड़ी 2 जीतता है!';

  @override
  String get won => 'जीत लिया';

  @override
  String get lost => 'खो गया';

  @override
  String get thinking => 'विचारधारा…';

  @override
  String get newGame => 'नया खेल';

  @override
  String get importGame => 'आयात खेल';

  @override
  String get exportGame => 'निर्यात खेल';

  @override
  String get gameImported => 'खेल आयातित।';

  @override
  String cannotImport(Object invalidMove) {
    return 'आयात नहीं कर सकता $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'चाल और नियम मेल नहीं खाते।';

  @override
  String get pleaseWait => 'कृपया प्रतीक्षा करें...';

  @override
  String get restartGame => 'मौजूदा गेम को फिर से शुरू करें?';

  @override
  String get restart => 'पुनः आरंभ करें';

  @override
  String get gameStarted => 'खेल शुरू हुआ, कृपया जगह दें.';

  @override
  String get analyzing => 'विश्लेषण कर रहा है…';

  @override
  String error(Object message) {
    return 'त्रुटि: $message';
  }

  @override
  String get winRate => 'जीत की दर';

  @override
  String get score => 'स्कोर:';

  @override
  String get white => 'खिलाड़ी १';

  @override
  String get black => 'खिलाड़ी २';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player टुकड़ों की संख्या तीन से कम है।';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player ने इस्तीफा दे दिया।';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player जाने का कोई रास्ता नहीं है।';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'बोर्ड भरा हुआ है, और $player के पास जाने का कोई रास्ता नहीं है।';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'समय समाप्त हो गया, $player खो गया।';
  }

  @override
  String get drawReasonRule50 =>
      'चलती चरण में, अंतिम विशिष्ट संख्या में चालों में कोई टुकड़ा नहीं हटाया गया है।';

  @override
  String get drawReasonBoardIsFull => 'यह एक ड्रा है क्योंकि बोर्ड भरा हुआ है.';

  @override
  String get drawReasonThreefoldRepetition =>
      'यह तीन गुना दोहराव के कारण ड्रा है।';

  @override
  String get gameOverUnknownReason => 'खेल खत्म! अज्ञात कारण।';

  @override
  String get gameOver => 'खेल खत्म';

  @override
  String get youWin => 'आप जीतते हैं! बधाई हो!';

  @override
  String challengeHarderLevel(int level) {
    return 'कठिन स्तर को चुनौती दें? नया स्तर स्तर $level होगा!';
  }

  @override
  String get youLose => 'आप हार गए!';

  @override
  String get analyze => 'विश्लेषण';

  @override
  String get about => 'के बारे में';

  @override
  String version(Object versionNumber) {
    return 'संस्करण: $versionNumber';
  }

  @override
  String get thanks => 'धन्यवाद';

  @override
  String get settings => 'समायोजन';

  @override
  String get options => 'विकल्प';

  @override
  String get generalSettings => 'सामान्य सेटिंग्स';

  @override
  String get skillLevel => 'कठिनाई स्तर';

  @override
  String get moveTime => 'एआई सोचने का समय';

  @override
  String get difficulty => 'कठिनाई';

  @override
  String get playSounds => 'ध्वनि प्रभाव';

  @override
  String get playSoundsInTheGame => 'खेल में ध्वनियां बजाएं';

  @override
  String get keepMuteWhenTakingBack => 'वापस लेते समय मौन रहें';

  @override
  String get tone => 'सुर';

  @override
  String get whoMovesFirst => 'पहला कदम';

  @override
  String get human => 'मानव';

  @override
  String get ai => 'एआई';

  @override
  String get alternate => 'वैकल्पिक';

  @override
  String get isAutoRestart => 'गेम खत्म होने पर ऑटो-रिस्टार्ट गेम';

  @override
  String get isAutoChangeFirstMove => 'ऑटो चेंज फर्स्ट मूव';

  @override
  String get shufflingEnabled => 'यादृच्छिक चाल';

  @override
  String get misc => 'विविध';

  @override
  String get rules => 'नियमों';

  @override
  String get piecesCount => 'प्रत्येक खिलाड़ी के पास टुकड़ों की संख्या';

  @override
  String get piecesCount_Detail =>
      'प्रत्येक खिलाड़ी के पास कितने टुकड़े होते हैं?';

  @override
  String get flyPieceCount => 'उड़ने वाले टुकड़े की संख्या';

  @override
  String get flyPieceCount_Detail =>
      'यदि फ्लाइंग सक्षम है, जब एक खिलाड़ी को एक विशिष्ट पीस काउंट तक कम कर दिया जाता है, तो उसके टुकड़े किसी भी खाली स्थान पर जाने के लिए स्वतंत्र होते हैं, बजाय बाकी गेम की तरह आसन्न बिंदुओं तक सीमित होने के।';

  @override
  String get piecesAtLeastCount => 'टुकड़े कम से कम';

  @override
  String get hasDiagonalLines => 'विकर्ण रेखाएं';

  @override
  String get hasDiagonalLines_Detail => 'बोर्ड में चार विकर्ण रेखाएँ जोड़ें।';

  @override
  String get isDefenderMoveFirst => 'दूसरा खिलाड़ी पहले चलता है';

  @override
  String get isDefenderMoveFirst_Detail =>
      'जो खिलाड़ी प्लेसिंग फेज में सेकेंड मूव करता है वह मूविंग फेज में पहले मूव करता है।';

  @override
  String get mayRemoveMultiple => 'बहु-निकालें';

  @override
  String get mayRemoveMultiple_Detail =>
      'यदि कोई खिलाड़ी एक बार में एक से अधिक मिलों को बंद कर देता है, तो वह बंद की गई मिलों की संख्या को निकालने में सक्षम होगी।';

  @override
  String get mayRemoveFromMillsAlways => 'मिलों को नष्ट करें';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'डिफ़ॉल्ट रूप से, खिलाड़ियों को एक गठित मिल से एक टुकड़ा निकालने से पहले किसी भी अन्य टुकड़े को हटाना होगा। सीमा को अक्षम करने के लिए इस विकल्प को सक्षम करें।';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'बोर्ड भर जाने पर दूसरा खिलाड़ी हार जाता है';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'प्लेसमेंट चरण के अंत में, जब बोर्ड भर जाता है, तो जो पक्ष पहले रखता है वह खेल खो देता है, अन्यथा, खेल ड्रॉ होता है।';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'कोई कानूनी कदम न होने पर हारें';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'खिलाड़ी हार जाएगा यदि उसका प्रतिद्वंद्वी उन्हें ब्लॉक कर देता है ताकि उन्हें स्थानांतरित नहीं किया जा सके। यदि यह विकल्प अक्षम है, तो स्थानांतरित करने के लिए पक्ष बदलें।';

  @override
  String get mayFly => 'फ्लाइंग';

  @override
  String get mayFly_Detail =>
      'यदि किसी खिलाड़ी के पास केवल तीन या चार (कॉन्फ़िगर करने योग्य) टुकड़े बचे हैं, तो वह टुकड़े को किसी भी मुक्त बिंदु पर ले जा सकता है।';

  @override
  String get nMoveRule => 'एन-चाल नियम';

  @override
  String get nMoveRule_Detail =>
      'यदि प्रत्येक खिलाड़ी द्वारा चालों की एक निश्चित संख्या में कोई निष्कासन नहीं किया गया है तो खेल ड्रा हो जाता है।';

  @override
  String get rollback => 'रोलबैक';

  @override
  String get pleaseSelect => 'कृपया चुने';

  @override
  String get copy => 'प्रतिलिपि';

  @override
  String get moveHistoryCopied =>
      'कॉपी किए गए इतिहास को क्लिपबोर्ड पर ले जाएं.';

  @override
  String get help => 'मदद';

  @override
  String get feedback => 'प्रतिपुष्टि';

  @override
  String get exit => 'बाहर जाएं';

  @override
  String get ruleSettings => 'नियम सेटिंग्स';

  @override
  String get color => 'रंग';

  @override
  String get boardColor => 'बोर्ड का रंग';

  @override
  String get pieceColor => 'टुकड़ा रंग';

  @override
  String get backgroundColor => 'पीछे का रंग';

  @override
  String get lineColor => 'बोर्ड लाइन रंग';

  @override
  String get whitePieceColor => 'प्लेयर 1 पीस कलर';

  @override
  String get blackPieceColor => 'प्लेयर 2 पीस कलर';

  @override
  String get messageColor => 'संदेश का रंग';

  @override
  String get isPieceCountInHandShown => 'हाथ में टुकड़ों की गिनती दिखाओ';

  @override
  String get isNotationsShown => 'बोर्ड पर नोटेशन दिखाएं';

  @override
  String get isHistoryNavigationToolbarShown => 'इतिहास नेविगेशन टूलबार दिखाएं';

  @override
  String get display => 'प्रदर्शन';

  @override
  String get boardBorderLineWidth => 'बोर्ड सीमा रेखा चौड़ाई';

  @override
  String get boardInnerLineWidth => 'बोर्ड इनर लाइन चौड़ाई';

  @override
  String get pieceWidth => 'टुकड़ा चौड़ाई';

  @override
  String get fontSize => 'फ़ॉन्ट आकार';

  @override
  String get standardNotation => 'WMD संकेतन';

  @override
  String get restore => 'पुनर्स्थापित';

  @override
  String get restoreDefaultSettings => 'डिफ़ॉल्ट सेटिंग्स को पुनर्स्थापित करें';

  @override
  String pick(Object element) {
    return '$element चुनें';
  }

  @override
  String get info => 'जानकारी';

  @override
  String get hint => 'संकेत';

  @override
  String get player => 'खिलाड़ी';

  @override
  String get player1 => 'खिलाड़ी १';

  @override
  String get player2 => 'खिलाड़ी २';

  @override
  String get howToPlay => 'कैसे खेलें';

  @override
  String get toPlacePiece =>
      'टुकड़ा रखने के लिए किसी भी उपलब्ध बिंदु पर टैप करें।';

  @override
  String get toSelectPiece =>
      'टुकड़े को स्थानांतरित करने के लिए उस पर टैप करें।';

  @override
  String get toMovePiece =>
      'इसे स्थानांतरित करने के लिए टुकड़े से जुड़े बिंदु पर टैप करें।';

  @override
  String get toRemovePiece =>
      'हटाने के लिए प्रतिद्वंद्वी के एक टुकड़े पर टैप करें।';

  @override
  String get needToCreateMillFirst =>
      'किसी टुकड़े को निकालने से पहले आपको पहले एक चक्की बनानी होगी।';

  @override
  String get needToPlayWithOwnPieces =>
      'आपको अपने टुकड़ों के साथ खेलने की जरूरत है।';

  @override
  String get statistics => 'आंकड़े';

  @override
  String get totalGames => 'कुल खेल';

  @override
  String get results => 'परिणाम';

  @override
  String get left => 'बाएं';

  @override
  String get privacyPolicy => 'गोपनीयता नीति';

  @override
  String get privacyPolicy_Detail_1 =>
      'कृपया ध्यान से पढ़ें और सुनिश्चित करें कि आप इसे पूरी तरह समझते हैं और इससे सहमत हैं ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. यदि आप इस नीति से सहमत नहीं हैं, तो कृपया इस ऐप का उपयोग न करें। ऐप का उपयोग करने का तात्पर्य है कि आप इन शर्तों को स्वीकार करते हैं।';

  @override
  String get and => ' तथा ';

  @override
  String get accept => 'स्वीकार करना';

  @override
  String get takeBack => 'वापस लेलो';

  @override
  String get takingBack => 'वापस ले रही है…';

  @override
  String get waiting => 'इंतज़ार कर रही…';

  @override
  String get stepForward => 'आगे कदम';

  @override
  String get takeBackAll => 'सभी वापस ले लो';

  @override
  String get stepForwardAll => 'सभी आगे बढ़ें';

  @override
  String get moveNow => 'अब चलो';

  @override
  String get done => 'किया हुआ।';

  @override
  String get crackMill => 'क्रैक-मिल';

  @override
  String get crackMill_Detail =>
      'यदि किसी खिलाड़ी के पास मिलों में केवल टुकड़े हैं, तो मिलों के टुकड़े निकालने के लिए लॉक नहीं होंगे।';

  @override
  String get animationDuration => 'एनिमेशन अवधि';

  @override
  String get none => 'कोई नहीं';

  @override
  String get theme => 'विषय';

  @override
  String get helpContent =>
      'खेल का लक्ष्य प्रतिद्वंद्वी को तीन से कम टुकड़े या कोई कानूनी चाल नहीं छोड़ना है।\n\nयदि कोई स्थिति तीसरी बार होती है, या यदि अंतिम 100 (कॉन्फ़िगर करने योग्य) चालों में कोई निष्कासन नहीं किया गया है, तो खेल स्वचालित रूप से ड्रा हो जाता है।\n\nखेल तीन चरणों में आगे बढ़ता है:\n\n1. खाली जगहों पर टुकड़े करना\n2. टुकड़ों को आसन्न बिंदुओं पर ले जाना\n3. (वैकल्पिक चरण) किसी भी खाली बिंदु पर टुकड़ों को स्थानांतरित करना जब खिलाड़ी को तीन टुकड़ों में घटा दिया गया हो\n\nलगाना\n\nखेल एक खाली बोर्ड से शुरू होता है, जिसमें चौबीस अंकों वाला एक ग्रिड होता है। खिलाड़ी बारी-बारी से अपने टुकड़ों को खाली बिंदुओं पर रखते हैं जब तक कि प्रत्येक खिलाड़ी बोर्ड पर सभी टुकड़े नहीं रख देता। यदि कोई खिलाड़ी अपने तीन टुकड़ों को एक सीधी रेखा में रख सकता है, तो उसके पास एक \"मिल\" है और वह अपने प्रतिद्वंद्वी के टुकड़ों में से एक को बोर्ड से हटा सकता है।\n\nनियमों के कुछ रूपों में, खिलाड़ियों को एक गठित मिल से एक टुकड़ा निकालने से पहले किसी भी अन्य टुकड़े को हटाना होगा।\n\nनियमों के कुछ रूपों में, हटाए गए टुकड़ों के सभी बिंदुओं को फिर से रखने के चरण में नहीं रखा जा सकता है।\n\nएक बार सभी टुकड़ों का उपयोग हो जाने के बाद, खिलाड़ी आगे बढ़ते हैं।\n\nचलती\n\nस्थानांतरित करने के लिए, एक खिलाड़ी अपने एक टुकड़े को बोर्ड लाइन के साथ एक खाली आसन्न बिंदु पर ले जाता है। यदि वह ऐसा नहीं कर पाता है तो वह खेल हार गया है। प्लेसमेंट चरण की तरह, एक खिलाड़ी जो अपने तीन टुकड़ों को एक बोर्ड लाइन पर संरेखित करता है, उसके पास एक चक्की होती है और वह अपने प्रतिद्वंद्वी के टुकड़ों में से एक को हटा सकता है। कोई भी खिलाड़ी दो टुकड़ों में सिमट जाता है और उसके पास नई मिलें बनाने का कोई विकल्प नहीं होता है, और इस तरह वह खेल खो देता है। एक खिलाड़ी तीन से अधिक टुकड़ों के साथ भी हार सकता है यदि उसका प्रतिद्वंद्वी उन्हें ब्लॉक कर देता है ताकि उन्हें स्थानांतरित नहीं किया जा सके।\n\nफ्लाइंग\n\nनियमों के कुछ रूपों में, एक बार जब खिलाड़ी के पास केवल तीन टुकड़े बचे होते हैं, तो उसके टुकड़े किसी भी खाली बिंदु पर \"उड़\", \"हॉप\" या \"कूद\" सकते हैं, न कि केवल आसन्न वाले।';

  @override
  String get versionInfo => 'संस्करण की जानकारी';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'लाइसेंस';

  @override
  String get sourceCode => 'सोर्स कोड';

  @override
  String get appVersion => 'एप्लिकेशन वेरीज़न';

  @override
  String get general => 'आम';

  @override
  String get advanced => 'उन्नत';

  @override
  String get placing => 'लगाना';

  @override
  String get moving => 'चलती';

  @override
  String get removing => 'निकाला जा रहा है';

  @override
  String get gameOverCondition => 'गेम ओवर कंडीशन';

  @override
  String get aisPlayStyle => 'एआई की खेल शैली';

  @override
  String get passive => 'निष्क्रिय';

  @override
  String get timeout => 'समय समाप्त';

  @override
  String get appearance => 'दिखावट';

  @override
  String get drawOnHumanExperience => 'मानव अनुभव पर ड्रा करें';

  @override
  String get considerMobility => 'टुकड़ों की गतिशीलता पर विचार करें';

  @override
  String get pieceCount => 'टुकड़ा गिनती:';

  @override
  String inHand(Object player, int count) {
    return '$player हाथ में: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player बोर्ड पर: $count';
  }

  @override
  String get boardTop => 'ऊपर से बोर्ड ऑफ़सेट';

  @override
  String get notAIsTurn => 'यह एआई की बारी नहीं है।';

  @override
  String get aiIsNotThinking => 'एआई नहीं सोच रहा है।';

  @override
  String get atEnd => 'चाल सूची के अंत में।';

  @override
  String get tapBackAgainToLeave => 'जाने के लिए फिर से टैप करें।';

  @override
  String get more => 'अधिक';

  @override
  String get experimental => 'यह एक प्रायोगिक विशेषता है।';

  @override
  String get experiments => 'प्रयोगों';

  @override
  String get ossLicenses => 'ओपन सोर्स लाइसेंस';

  @override
  String get language => 'भाषा';

  @override
  String get defaultLanguage => 'डिफ़ॉल्ट भाषा';

  @override
  String get mayMoveInPlacingPhase => 'टुकड़े चरण रखने में आगे बढ़ सकते हैं';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'कोई अलग प्लेसमेंट और मूविंग चरण नहीं हैं, यानी खिलाड़ी हर कदम पर यह तय कर सकते हैं कि वे बोर्ड पर एक टुकड़ा रखना चाहते हैं या अपने एक टुकड़े को स्थानांतरित करना चाहते हैं (जब तक कि उनके पास शेष टुकड़े हों)।';

  @override
  String get drawerColor => 'मेनू रंग';

  @override
  String get drawerTextColor => 'मेनू टेक्स्ट का रंग';

  @override
  String get drawerHighlightItemColor => 'मेनू हाइलाइट आइटम रंग';

  @override
  String get mainToolbarBackgroundColor => 'मुख्य टूलबार पृष्ठभूमि रंग';

  @override
  String get mainToolbarIconColor => 'मुख्य टूलबार आइकन रंग';

  @override
  String get navigationToolbarBackgroundColor =>
      'नेविगेशन टूलबार पृष्ठभूमि का रंग';

  @override
  String get navigationToolbarIconColor => 'नेविगेशन टूलबार आइकन रंग';

  @override
  String get autoHideToolbar => 'टूलबार को स्वचालित रूप से छुपाएं';

  @override
  String get toolbarLocationOnScreen => 'स्क्रीन पर टूलबार का स्थान';

  @override
  String get top => 'ऊपर';

  @override
  String get bottom => 'तल';

  @override
  String get center => 'केन्द्र';

  @override
  String get solidColor => 'ठोस रंग';

  @override
  String get picture => 'चित्र';

  @override
  String get chooseYourPicture => 'अपनी तस्वीर चुनें';

  @override
  String get light => 'रोशनी';

  @override
  String get dark => 'अंधेरा';

  @override
  String get themes => 'विषयों';

  @override
  String get currentTheme => 'वर्तमान विषय';

  @override
  String get saveTheme => 'विषय सहेजें';

  @override
  String get showAnalysisGraph => 'विश्लेषण ग्राफ दिखाएं';

  @override
  String get analysis => 'विश्लेषण';

  @override
  String get saveGame => 'खेल को सेव करें';

  @override
  String get loadGame => 'खेल लोड करें';

  @override
  String get setupPosition => 'सेटअप स्थिति';

  @override
  String get showLegalMoves => 'कानूनी कदम दिखाएं';

  @override
  String get showLastMove => 'अंतिम चाल दिखाएं';

  @override
  String get showArrows => 'तीर दिखाएं';

  @override
  String get pieces => 'टुकड़े';

  @override
  String get showAnalysis => 'विश्लेषण दिखाएं';

  @override
  String get threads => 'धागे';

  @override
  String get getInvolved => 'उलझना';

  @override
  String get helpImproveTranslate => 'अनुवाद को बेहतर बनाने में मदद करें';

  @override
  String get tutorial => 'ट्यूटोरियल';

  @override
  String get classicMill => 'क्लासिक मिल';

  @override
  String get mixedMill => 'मिश्रित मिल';

  @override
  String get ceylonMill => 'सीलोन मिल';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'मिल को तोड़ा जा सकता है और बार-बार बनाया जा सकता है';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'यदि कोई खिलाड़ी तुरंत एक नई मिल बनाने के लिए एक मिल तोड़ता है, तो ऐसा खिलाड़ी अपनी अगली चाल में इस तरह के टुकड़े को मूल जंक्शन पर वापस ले जा सकता है यदि वह एक नई मिल बनाता है।';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'यदि किसी खिलाड़ी के तीन टुकड़े हों और दस चालों के बाद कोई भी खिलाड़ी प्रतिद्वंद्वी के टुकड़ों को नहीं हटाता है तो खेल ड्रा हो जाता है';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'जब एक खिलाड़ी के तीन टुकड़े हो जाते हैं, और कोई भी खिलाड़ी दस चालों के भीतर प्रतिद्वंद्वी के टुकड़े को नहीं हटा सकता है, तो खेल ड्रॉ होता है।';

  @override
  String get close => 'बंद करे';

  @override
  String get whitePiece => 'सफेद टुकड़ा';

  @override
  String get blackPiece => 'काला टुकड़ा';

  @override
  String get emptyPoint => 'खाली बिंदु';

  @override
  String get noPoint => 'कोई फायदा नहीं';

  @override
  String get placingPhase => 'चरण रखना';

  @override
  String get movingPhase => 'मूविंग फेज';

  @override
  String get flyingPhase => 'उड़ान चरण';

  @override
  String sideToMove(Object player) {
    return 'स्थानांतरित करने के लिए पक्ष: $player';
  }

  @override
  String lastMove(Object move) {
    return 'अंतिम चाल: $move';
  }

  @override
  String get selected => 'गिने चुने';

  @override
  String get accessibility => 'सरल उपयोग';

  @override
  String get screenReaderSupport => 'स्क्रीन रीडर समर्थन';

  @override
  String get isDraw => 'यह एक ड्रा . है!';

  @override
  String get draw => 'खींचना';

  @override
  String get pieceHighlightColor => 'टुकड़ा हाइलाइट रंग';

  @override
  String get algorithm => 'कलन विधि';

  @override
  String get endgameNMoveRule => 'एंडगेम एन-मूव रूल';

  @override
  String get endgameNMoveRule_Detail =>
      'यदि किसी खिलाड़ी के पास केवल तीन टुकड़े हैं और कोई भी खिलाड़ी किसी विशिष्ट चाल के भीतर एक टुकड़ा नहीं हटाता है, तो खेल ड्रा हो जाता है।';

  @override
  String get drawReasonEndgameRule50 =>
      'किसी भी खिलाड़ी के पास केवल तीन टुकड़े होते हैं और न ही खिलाड़ी एक विशिष्ट चाल के भीतर एक टुकड़ा निकालता है।';

  @override
  String get threefoldRepetitionRule => 'तीन गुना दोहराव नियम';

  @override
  String get threefoldRepetitionRule_Detail =>
      'यदि कोई स्थिति तीसरी बार आती है तो खेल ड्रा हो जाता है।';

  @override
  String get continueToMakeMove => 'चक्की! एक चाल चलना जारी रखें।';

  @override
  String get pointStyle => 'बिंदु शैली';

  @override
  String get pointWidth => 'बिंदु चौड़ाई';

  @override
  String get solid => 'ठोस';

  @override
  String get hollow => 'खोखला';

  @override
  String get languageName => 'हिंदी';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count मूव्स',
      one: '$count मूव',
      zero: 'मूव',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'लोड विफल हो गया।';

  @override
  String get filename => 'फ़ाइल का नाम';

  @override
  String get browse => 'ब्राउज़ करें…';

  @override
  String get gameFiles => 'खेल फ़ाइलें';

  @override
  String get gameSavedTo => 'खेल सहेजा गया है';

  @override
  String get empty => 'खाली';

  @override
  String get noMove => 'कोई चाल नहीं।';

  @override
  String get restoredPosition => 'प्रारंभिक स्थिति बहाल।';

  @override
  String get clean => 'स्वच्छ';

  @override
  String get cleanedUp => 'सफाई की।';

  @override
  String get remove => 'हटाना';

  @override
  String get noPiecesCanBeRemoved => 'कोई टुकड़ा नहीं हटाया जा सकता है।';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count टुकड़े',
      one: '$count टुकड़ा',
      zero: 'टुकड़ा',
    );
    return '$_temp0 को निकालने की जरूरत है।';
  }

  @override
  String placedCount(int count) {
    return 'रखा गया ($count)';
  }

  @override
  String get placedPieceCount => 'रखने के चरण में रखा टुकड़ा गिनती।';

  @override
  String hasPlacedPieceCount(int count) {
    return 'वर्तमान खिलाड़ी ने $count पीस रखे हैं।';
  }

  @override
  String get notPlacingPhase => 'चरण नहीं रखना, इसे बदल नहीं सकता।';

  @override
  String get paste => 'पेस्ट करें';

  @override
  String get pasteDone => 'पेस्ट बन चुका है।';

  @override
  String get cannotPaste => 'चिपकाया नहीं जा सकता।';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'हटाए गए और हटाए गए टुकड़े दिखाएं';

  @override
  String get fullScreen => 'पूर्ण स्क्रीन';

  @override
  String get reopenToTakeEffect =>
      'सेटिंग्स के लिए एप्लिकेशन को बाहर निकालें और फिर से खोलना।';

  @override
  String get forest => 'जंगल';

  @override
  String get desktopImage => 'डेस्कटॉप छवि';

  @override
  String get invalidPosition => 'अमान्य स्थिति।';

  @override
  String get shareGIF => 'जीआईएफ साझा करें';

  @override
  String get pixelRatio => 'पिक्सेल अनुपात';

  @override
  String get duration => 'अवधि';

  @override
  String get gameScreenRecorder => 'गेम स्क्रीन रिकॉर्डर';

  @override
  String get previous => 'पिछला';

  @override
  String get next => 'अगला';

  @override
  String get skip => 'छोड़ें';

  @override
  String get gotIt => 'समझ गया';

  @override
  String get youCanModifyRules =>
      'आप नियम सेटिंग्स में खेल के नियमों को संशोधित कर सकते हैं।';

  @override
  String get youCanUseMouseWheelInPicker =>
      'पिकर में मान बदलने के लिए आप माउस व्हील का उपयोग कर सकते हैं।';

  @override
  String get noTimeLimitForThinking =>
      'एआई थिंकिंग टाइम 0 पर सेट होने का मतलब है कि सोचने की कोई समय सीमा नहीं है।';

  @override
  String get whatIsMtdf =>
      'एमटीडी (एफ) अल्फा-बीटा खोज एल्गोरिदम का एक संशोधित रूप है जिसका उद्देश्य मध्यवर्ती खोज परिणामों का पुन: उपयोग करके और खोज स्थान को कम करने के लिए एक अच्छे प्रारंभिक अनुमान का उपयोग करके दक्षता में सुधार करना है।';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'कृपया ध्यान रखें कि एआई सोच समय समायोजन पूरी तरह से सटीक नहीं हो सकता है। वास्तविक सोच समय कम हो सकता है जब कठिनाई का स्तर कम मान पर सेट होता है और जब समय समाप्त हो जाता है तो एआई मध्य-विचार होने पर लंबा हो सकता है।';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'यदि आप कठिनाई स्तर को उच्च सेट करते हैं लेकिन एआई सोच समय में वृद्धि नहीं करते हैं, तो वास्तविक कठिनाई स्तर सोचने के समय की कमी के कारण कम मूल्य तक सीमित हो सकता है। मशीन के प्रदर्शन के आधार पर वास्तविक मूल्य भिन्न हो सकता है।';

  @override
  String get whatIsPvs =>
      'PVS (प्रिंसिपल वैरिएशन सर्च) किसी दिए गए स्थान में सर्वश्रेष्ठ चाल खोजने के लिए एक खोज एल्गोरिथम है। यह अल्फा-बीटा एल्गोरिथ्म का एक संवर्द्धन है और यह पुष्टि करने के लिए शून्य या शून्य विंडो खोजों का उपयोग करता है कि मुख्य बदलाव से पहले से सुरक्षित स्कोर की तुलना में चाल खराब है या खराब नहीं है। पीवीएस सबसे आशाजनक कदमों पर ध्यान केंद्रित करता है और उप-इष्टतम शाखाओं की अनावश्यक खोजों से बचता है, जो खोज की दक्षता में सुधार करने में मदद करता है।';

  @override
  String get whatIsAlphaBeta =>
      'अल्फ़ा-बीटा एल्गोरिद्म सर्वश्रेष्ठ चाल खोजने के लिए एक खोज एल्गोरिद्म है। यह सर्च ट्री को कम करने और दक्षता बढ़ाने के लिए मिनिमैक्स सिद्धांत और दो मानों, अल्फा और बीटा का उपयोग करता है। अल्फा उस न्यूनतम स्कोर का प्रतिनिधित्व करता है जिसे कंप्यूटर निश्चित रूप से प्राप्त कर सकता है, जबकि बीटा अधिकतम स्कोर का प्रतिनिधित्व करता है जो उसके प्रतिद्वंद्वी को मिल सकता है। एल्गोरिदम कंप्यूटर को गेम में स्मार्ट, कुशल निर्णय लेने में मदद करता है।';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'मानव अनुभव के अनुसार यदि आप जीतने का प्रयास करेंगे तो आप हार जाएंगे। इसके बजाय, अपने लक्ष्य के रूप में ड्रॉ का लक्ष्य रखें और खेल को खोने से बचें। अपने प्रतिद्वंद्वी का निरीक्षण करें और धीरे से उन्हें ऐसी स्थिति में फुसलाएं जहां वे गलतियां कर सकते हैं। जब वे कमजोरी दिखाते हैं, अवसर को जब्त करें और जीत के लिए धीरे-धीरे धक्का दें। इस तरह आप गेम जीत सकते हैं।';

  @override
  String get firstMoveDetail =>
      'इस खेल में पहले खिलाड़ी की तुलना में दूसरे खिलाड़ी के लिए जीतना आसान होता है।';

  @override
  String get passiveDetail =>
      'निष्क्रिय विकल्प को सक्षम करने से एआई आराम कर सकता है जब स्थिति में लाभ होता है, बजाय आक्रामक रूप से जितनी जल्दी हो सके जीतने की कोशिश कर रहा है।';

  @override
  String get moveRandomlyDetail =>
      'इस विकल्प को सक्षम करने से खेल की यादृच्छिकता और मज़ा बढ़ जाता है जबकि इसे अक्षम करने से एआई को मात देने के तरीकों का अध्ययन करने में मदद मिल सकती है।';

  @override
  String get considerMobilityOfPiecesDetail =>
      'यदि एआई अपने टुकड़ों की गतिशीलता पर विचार करता है, तो यह न केवल प्रतिद्वंद्वी के टुकड़ों को जितनी जल्दी हो सके कब्जा करने का लक्ष्य रखेगा, बल्कि प्रतिद्वंद्वी के आंदोलनों को अवरुद्ध करने और उन्हें ऐसा करने से रोकने पर भी विचार करेगा।';

  @override
  String get whenBoardIsFull => 'जब बोर्ड भरा हुआ है';

  @override
  String get whenBoardIsFull_Detail =>
      'रखने के चरण के अंत में, गतिमान चरण शुरू होने से पहले, यदि बोर्ड टुकड़ों से भरा हुआ है तो कार्रवाई होती है।';

  @override
  String get sideToMoveRemovePiece =>
      'मूविंग फेज में जो खिलाड़ी सबसे पहले चलता है वह प्रतिद्वंद्वी के टुकड़ों में से एक को हटा देता है।';

  @override
  String get agreeToDraw => 'दोनों पक्ष ड्रा के लिए सहमत हैं।';

  @override
  String get takeOpponentsPiece =>
      'अपने प्रतिद्वंद्वी के टुकड़ों में से एक लें।';

  @override
  String get firstPlayerLose => 'पहला खिलाड़ी खेल हार जाता है।';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'पहले और दूसरे खिलाड़ी प्रतिद्वंद्वी के टुकड़ों में से एक को हटा देते हैं।';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'दूसरे और पहले खिलाड़ी प्रतिद्वंद्वी के टुकड़ों में से एक को हटा देते हैं।';

  @override
  String get enteredFlyingPhase =>
      'अब उड़ान चरण में प्रवेश कर चुके हैं, प्रतिद्वंद्वी के गोटियां बोर्ड पर किसी भी खाली बिंदु पर कूद सकती हैं। आप \"नियम सेटिंग्स\" में उड़ान नियम को बंद कर सकते हैं।';

  @override
  String get whenStalemate => 'जब गतिरोध';

  @override
  String get whenStalemate_Detail =>
      'जब कोई टुकड़ा नहीं ले जाया जा सकता है तो क्या कार्रवाई होती है?';

  @override
  String get endWithStalemateLoss => 'गतिरोध हार के साथ समाप्त करें।';

  @override
  String get changeSideToMove => 'स्थानांतरित करने के लिए पक्ष बदलें।';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'विरोधी की एक गोटी हटाएं और अगली चाल चलें।';

  @override
  String get endWithStalemateDraw => 'एक गतिरोध ड्रा के साथ समाप्त करें।';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'प्रतिद्वंद्वी के टुकड़ों में से एक को हटाएं और स्थानांतरित करने के लिए पक्ष बदलें।';

  @override
  String get aiResponseDelayTime => 'एआई प्रतिक्रिया विलंब समय';

  @override
  String get aiIsDelaying =>
      'एआई वर्तमान में विलंबित प्रतिक्रिया चरण में है। कृपया आगे बढ़ने से पहले कुछ देर प्रतीक्षा करें।';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'आप एक असन्निकट टुकड़ा नहीं निकाल सकते।';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'यदि गतिरोध होता है, तो मिल के गठन की परवाह किए बिना, आपके आस-पास के प्रतिद्वंद्वी के टुकड़ों को हटाया जा सकता है।';

  @override
  String get whatIsMcts =>
      'एमसीटीएस शुरुआती-अनुकूल एल्गोरिदम है जो सिमुलेशन के माध्यम से विभिन्न चालों की खोज और मूल्यांकन करके निर्णय लेता है।';

  @override
  String get goldenJade => 'गोल्डन जेड';

  @override
  String get forestWood => 'जंगल की लकड़ी';

  @override
  String get darkMystery => 'डार्क मिस्ट्री';

  @override
  String get midnightBlue => 'मिडनाइट ब्लू';

  @override
  String get greenForest => 'हरे जंगल';

  @override
  String get greenMeadow => 'हरी घास का मैदान';

  @override
  String get stonyPath => 'पथरीला रास्ता';

  @override
  String get pastelPink => 'पेस्टल पिंक';

  @override
  String get turquoiseSea => 'फ़िरोज़ा सागर';

  @override
  String get violetDream => 'वायलेट ड्रीम';

  @override
  String get mintChocolate => 'मिंट चॉकलेट';

  @override
  String get skyBlue => 'आसमानी नीला';

  @override
  String get playfulGarden => 'चंचल उद्यान';

  @override
  String get whatIsRetrogradeAnalysis =>
      'रेट्रोग्रेड एनालिसिस एल्गोरिथम अलग-अलग स्टार्ट पोजीशन से एंडगेम डेटाबेस बनाने के लिए मल्टी-वैल्यूड रेट्रोग्रेड एनालिसिस का उपयोग करता है, फिर गेमप्ले को ऑप्टिमाइज़ करने के लिए इस डेटाबेस को लागू करता है। यह दृष्टिकोण अल्ट्रा-स्ट्रॉन्ग सॉल्यूशंस की श्रेणी में आता है।';

  @override
  String get viewAlgorithmGuide =>
      'क्या आप इस एल्गोरिथ्म के लिए उपयोगकर्ता मार्गदर्शिका देखना चाहेंगे?';

  @override
  String get showPositionalAdvantageIndicator => 'स्थितीय लाभ सूचक दिखाएँ';

  @override
  String get usePerfectDatabase => 'उत्तम डेटाबेस का उपयोग करें';

  @override
  String get perfectDatabaseDescription =>
      'अत्याधुनिक एल्गोरिदम के माध्यम से उत्पन्न दोषरहित गेम डेटाबेस का उपयोग करने के लिए इस विकल्प को सक्षम करें। यह सुविधा इष्टतम चालों का सुझाव देने के लिए शुरुआती और अंतिम गेम दोनों रणनीतियों को एकीकृत करती है। यह उन खिलाड़ियों के लिए पसंदीदा विकल्प है जो गेमप्ले में उच्चतम स्तर की सटीकता चाहते हैं। सावधानीपूर्वक कम्प्यूटेशनल तकनीकों के माध्यम से बनाया गया, डेटाबेस को बिल्कुल सही गेम समाधान प्रदान करने के लिए डिज़ाइन किया गया है।\n\nनोट: यदि एआई डेटाबेस तक पहुंचने में विफल रहता है, तो यह गेमप्ले निर्णयों के लिए पारंपरिक एल्गोरिदम की ओर रुख करेगा। जब डेटाबेस उपलब्ध होता है, तो \'कठिनाई स्तर\' वस्तुतः अपराजेय हो जाता है, और \'एआई थिंकिंग टाइम\' में भारी कमी का अनुभव होता है। \'एआई के प्लेस्टाइल\' विकल्पों के भीतर कई सेटिंग्स ओवरराइड हो जाएंगी, क्योंकि डेटाबेस परिणाम सर्वोच्च प्राथमिकता रखते हैं।\n\nइस दोषरहित डेटाबेस का अधिकतम लाभ कैसे उठाया जाए, इस पर मार्गदर्शन के लिए यहां क्लिक करें।';

  @override
  String get backgroundImage => 'पृष्ठभूमि छवि';

  @override
  String get whatIsRandom =>
      'जब \'परफेक्ट डेटाबेस का उपयोग करें\' विकल्प सक्षम नहीं होता है, तब \'रैंडम\' सेटिंग के कारण AI बिना किसी एल्गोरिदम का उपयोग किए यादृच्छिक रूप से मोहरे हिलाता है। इससे आमतौर पर गेमप्ले काफी कमजोर हो जाता है। इसके विपरीत, जब \'परफेक्ट डेटाबेस का उपयोग करें\' सक्षम होता है, तो AI केवल \'परफेक्ट डेटाबेस\' पर निर्भर करता है निर्णय लेने के लिए, पारंपरिक AI एल्गोरिदम के साथ मिश्रण नहीं करता है। इस मोड में, AI की चालें पूरी तरह से डेटाबेस की सामग्री पर आधारित होती हैं, वास्तविक समय की गणना या खोज एल्गोरिदम पर निर्भरता से बचती हैं।';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'विरोधी के मोहरे (मोहरों) को उनके हाथ से हटाएँ; फिर विरोधी की बारी है।';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'प्लेसिंग फेज़ के दौरान मिल बनाते समय';

  @override
  String get removeOpponentsPieceFromBoard =>
      'विरोधी के मोहरे (मोहरों) को बोर्ड से हटा दें।';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'विरोधी के मोहरे (मोहरों) को बोर्ड से हटा दें; फिर विरोधी की बारी है।';

  @override
  String get opponentRemovesOwnPiece =>
      'विरोधी अपने मोहरे (मोहरों) को बोर्ड से हटा देता है।';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'आपके द्वारा कार्रवाई करने के बजाय, विरोधी अपने मोहरे (मोहरों) को बोर्ड से चुनता और हटाता है, जिससे वह अपने लिए हानिकारक कदम उठाता है।';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'विरोधी के मोहरे (मोहरों) को उनके हाथ से हटाएँ; फिर आपकी बारी है।';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'विरोधी के हाथ से मोहरे (मोहरों) को हटाएँ। यदि, मल्टी-रिमूव सेटिंग के अनुसार, कई मोहरों को हटाना है और विरोधी के हाथ में कोईमोहरा नहीं बचा है, तो बोर्ड से विरोधी के मोहरों को हटाना जारी रखें।फिर, आपकी बारी है। यदि आप मिल बनाना जारी रखते हैं, तो आप विरोधी के मोहरों को हटाना जारी रख सकते हैं।';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'विरोधी के हाथ से मोहरे (मोहरों) को हटाएँ। यदि, मल्टी-रिमूव सेटिंग के अनुसार, कई मोहरों को हटाना है और विरोधी के हाथ में कोई मोहरा नहीं बचा है, तो बोर्ड से विरोधी के मोहरों को हटाना जारी रखें। फिर, विरोधी की बारी है।';

  @override
  String get markAndDelayRemovingPieces =>
      'मोहरों को हटाने में देरी और उन्हें चिह्नित करें।';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'मोहरोंको रखने के फ़ेज़ के दौरान,आने वाले मोहरों को हटाने के लिए चिह्नित किया जाता है, और दोनों खिलाड़ियों केलिए, इन पॉइंट्स पर कोई नया मोहरा नहीं रखा जा सकता है। चलने के फ़ेज़ में प्रवेश करने पर, इन चिह्नितमोहरों को पूरी तरह से हटा दिया जाता है, और फिर खिलाड़ी अपने मोहरों को इन खाली पॉइंट्स पर動か सकते हैं।';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'स्थापना चरण के दौरान मिल्स बनाते समय किए जा सकने वाले कार्य।';

  @override
  String get marked => 'चिह्नित';

  @override
  String get menu => 'मेन्यू';

  @override
  String get monochrome => 'एकरंगी';

  @override
  String get youCanEnableScreenReaderSupport =>
      'आप सामान्य सेटिंग्स की एक्सेसिबिलिटी कॉन्फ़िगरेशन में स्क्रीन रीडर सपोर्ट को चालू कर सकते हैं।';

  @override
  String get showNumbersOnPieces => 'मोहरों पर संख्याएँ दिखाएँ';

  @override
  String get saveImage => 'छवि सहेजें';

  @override
  String get isAnalysisToolbarShown => 'विश्लेषण टूलबार दिखाई दे रहा है';

  @override
  String get analysisToolbarBackgroundColor =>
      'विश्लेषण टूलबार का पृष्ठभूमि रंग';

  @override
  String get analysisToolbarIconColor => 'विश्लेषण टूलबार आइकन रंग';

  @override
  String get transformed => 'परिवर्तित किया गया।';

  @override
  String get cannotTransform => 'परिवर्तन नहीं किया जा सकता।';

  @override
  String get rotate => 'घुमाएँ';

  @override
  String get horizontalFlip => 'एच फ्लिप';

  @override
  String get verticalFlip => 'वी फ्लिप';

  @override
  String get innerOuterFlip => 'आईओ फ्लिप';

  @override
  String get transparentCanvas => 'पारदर्शी कैनवस';

  @override
  String get restrictRepeatedMillsFormation =>
      'दोहराए गए मिल के गठन को प्रतिबंधित करें';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'एक मिल से दूसरी मिल बनाने के लिए चलाई गई मोहरा अगली बारी में तुरंत मूल बिंदु पर वापस नहीं जा सकती है। पहले एक अलग चाल की आवश्यकता होती है।';

  @override
  String get oneTimeUseMill => 'एक बार उपयोग मिल';

  @override
  String get oneTimeUseMill_Detail =>
      'प्रत्येक मिल केवल एक बार प्रतिद्वंद्वी का एक टुकड़ा हटा सकता है। आप इसे फिर से बना सकते हैं, लेकिन इसे अतिरिक्त हटाने के लिए उपयोग नहीं किया जा सकता है।';

  @override
  String get currentRulesNoPerfectDatabase =>
      'आपके द्वारा सेट किए गए वर्तमान नियमों में संबंधित संपूर्ण डेटाबेस नहीं है। संपूर्ण डेटाबेस के बारे में अधिक जानकारी के लिए कृपया यहां क्लिक करें।';

  @override
  String get focusOnBlockingPaths => 'अवरुद्ध पथों पर ध्यान केंद्रित करें';

  @override
  String get focusOnBlockingPaths_Detail =>
      'मिल्स बनाने की बजाय प्रतिद्वंद्वी की चालों को अवरुद्ध करने को प्राथमिकता दें। मिल्स पूरा करके टुकड़ों को हटाने पर ध्यान केंद्रित करने के बजाय, एआई प्रतिद्वंद्वी को फँसाने का लक्ष्य रखता है, जिससे वे हिलने-डुलने में असमर्थ हो जाते हैं और आक्रामक खेल के बजाय थकावट के माध्यम से जीत सुनिश्चित करते हैं। यह रणनीति प्रतिद्वंद्वी के मिल्स को सक्रिय रूप से अवरुद्ध नहीं करती है।';

  @override
  String get pieceImage => 'शतरंज की तस्वीर';

  @override
  String get importColorSettings => 'रंग सेटिंग्स आयात करें';

  @override
  String get exportColorSettings => 'रंग सेटिंग्स निर्यात करें';

  @override
  String get import => 'आयात';

  @override
  String get export => 'निर्यात';

  @override
  String get pleaseCopyJsonToClipboard =>
      'कृपया पहले JSON प्रारूप में सेटिंग्स को क्लिपबोर्ड पर कॉपी करें।';

  @override
  String get copiedToClipboard => 'क्लिपबोर्ड पर कॉपी किया गया।';

  @override
  String get imported => 'आयात किया गया।';

  @override
  String get boardImage => 'बोर्ड छवि';

  @override
  String get autumnLeaves => 'पतझड़ के पत्ते';

  @override
  String get legendaryLand => 'पौराणिक भूमि';

  @override
  String get vignetteEffect => 'विगनेट प्रभाव';

  @override
  String get promptMakeToolbarTransparent =>
      'क्या आप बोर्ड पृष्ठभूमि छवि सेट करने पर टूलबार को पूरी तरह से पारदर्शी बनाना चाहेंगे?';

  @override
  String get vibration => 'गेम में वाइब्रेशन सक्षम करें';

  @override
  String get soundTheme => 'ध्वनि विषय';

  @override
  String get ball => 'गेंद';

  @override
  String get liquid => 'तरल';

  @override
  String get wood => 'लकड़ी';

  @override
  String get placeEffectAnimation => 'गोटी रखने का एनीमेशन प्रभाव';

  @override
  String get removeEffectAnimation => 'गोटी हटाने का एनीमेशन प्रभाव';

  @override
  String get isToolbarAtBottom => 'टूलबार को नीचे दिखाएं';

  @override
  String get boardCornerRadius => 'बोर्ड के कोने की त्रिज्या';

  @override
  String get useOpeningBook => 'ओपनिंग बुक का उपयोग करें';

  @override
  String get currentRule => 'वर्तमान';

  @override
  String get nineMensMorris => 'नौ आदमी का खेल';

  @override
  String get twelveMensMorris => 'बारह आदमी का खेल';

  @override
  String get morabaraba => 'मोराबराबा';

  @override
  String get dooz => 'डूज़';

  @override
  String get chamGonu => 'चामगोनू';

  @override
  String get zhiQi => 'झीची';

  @override
  String get chengSanQi => 'चेंगसांची';

  @override
  String get mulMulan => 'मुल-मुलान';

  @override
  String get nerenchi => 'नेरेनची';

  @override
  String get ruleSet => 'नियम सेट';

  @override
  String get laskerMorris => 'लैस्कर मॉरिस';

  @override
  String get oneTimeMill => 'मेलनित्सा';

  @override
  String get daSanQi => 'दा सानची';

  @override
  String get useOpeningBook_Detail =>
      'एआई को शुरुआती खेल के दौरान पेशेवर मानव खिलाड़ियों द्वारा आमतौर पर इस्तेमाल किए जाने वाले ओपनिंग मूव्स का उपयोग करने दें। ध्यान दें: यह सुविधा वर्तमान में केवल विशिष्ट नियम सेटों के लिए उपलब्ध है।';

  @override
  String get showAdvantageGraph => 'लाभ ग्राफ़ दिखाएँ';

  @override
  String get advantageGraphHint =>
      'एडवांटेज ग्राफ़ केवल तभी बनाया जाएगा जब एआई चाल चल चुकी हो। जब मानव खिलाड़ी चाल चलेगा तो यह नहीं बनाया जाएगा।';

  @override
  String get removalBasedOnMillCounts =>
      'जब तक सभी मोहरें रखी न जाएँ, हटाने की क्रिया को निष्क्रिय करें। खिलाड़ी अपने मिल की संख्या के आधार पर मोहरें हटाते हैं।';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'जब तक सभी मोहरें रखी न जाएँ, हटाने को निष्क्रिय रखें। खिलाड़ी अपने मिल की संख्या के आधार पर मोहरें हटाते हैं: यदि संख्या बराबर है, तो दोनों समान संख्या में मोहरें हटाते हैं; यदि किसी एक के पास अधिक हैं, तो वह एक अतिरिक्त मोहरा हटाता है, जिससे अंतर एक मोहरे का बना रहता है। यदि केवल एक ही मिल बनाता है, तो वह दो मोहरें हटाता है और दूसरा एक हटाता है। यदि कोई भी मिल नहीं बनाता, तो दोनों एक-एक मोहरा हटाते हैं।';

  @override
  String get elfilja => 'एल फिल्ज़ा';

  @override
  String get tipSelectOwnPiece => 'अपनी गोटियों में से एक का चयन करें।';

  @override
  String get notYourTurn => 'यह आपकी बारी नहीं है।';

  @override
  String get annotationToolbarBackgroundColor => 'एनोटेशन टूलबार पृष्ठभूमि रंग';

  @override
  String get annotationToolbarIconColor => 'एनोटेशन टूलबार आइकन रंग';

  @override
  String get isAnnotationToolbarShown => 'एनोटेशन टूलबार दिखाएँ';

  @override
  String get enterAnnotationMode => 'एनोटेशन मोड में प्रवेश करें';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'क्या आप वाकई सभी एनोटेशन साफ़ करना चाहते हैं?';

  @override
  String get llmPromptCopiedToClipboard =>
      'LLM प्रॉम्प्ट क्लिपबोर्ड पर कॉपी किया गया।';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'कनेक्शन अस्वीकृत, सर्वर शायद बंद है।';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'खोज सफल, कनेक्शन की प्रतीक्षा कर रहा है...';

  @override
  String get noLanConnection => 'कोई LAN कनेक्शन नहीं';

  @override
  String get takeScreenshot => 'स्क्रीनशॉट लें';

  @override
  String get disconnectedFromOpponent => 'प्रतिद्वंद्वी से डिस्कनेक्ट हो गया।';

  @override
  String get takeBackRequest => 'वापस लेने का अनुरोध';

  @override
  String get nothingToShow => 'दिखाने के लिए कुछ नहीं।';

  @override
  String get stopHosting => 'होस्टिंग बंद करें';

  @override
  String get connectionResetByPeer => 'पीयर द्वारा कनेक्शन रीसेट किया गया।';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'हार्टबीट टाइमआउट के कारण कनेक्शन खो गया। कृपया पुनः कनेक्ट करें।';

  @override
  String get startHosting => 'होस्टिंग शुरू करें';

  @override
  String get restartRequestRejected => 'पुनरारंभ अनुरोध अस्वीकृत।';

  @override
  String get notConnectedToLanOpponent =>
      'LAN प्रतिद्वंद्वी से कनेक्ट नहीं है।';

  @override
  String get llmPrompt => 'LLM प्रॉम्प्ट';

  @override
  String get gameRestarted => 'खेल पुनरारंभ किया गया।';

  @override
  String get takeBackRejected => 'वापस लेना अस्वीकृत।';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'क्या आप वाकई इस खेल में हार मानना चाहते हैं?';

  @override
  String get opponentResignedYouWin =>
      'प्रतिद्वंद्वी ने हार मान ली। आप जीत गए!';

  @override
  String get clearAllAnnotations => 'सभी एनोटेशन साफ़ करें';

  @override
  String get connectedWaitingForOpponentSMove =>
      'कनेक्टेड, प्रतिद्वंद्वी की चाल की प्रतीक्षा कर रहा है...';

  @override
  String get networkStatusDisconnected => 'नेटवर्क स्थिति: डिस्कनेक्टेड';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'वापस लेने का अनुरोध प्रतिद्वंद्वी को भेजा गया।';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'प्रतिद्वंद्वी ने शायद खेल छोड़ दिया है';

  @override
  String get connectedToHostSuccessfully =>
      'होस्ट से सफलतापूर्वक कनेक्ट हो गया।';

  @override
  String get connectionLostHeartbeatTimeout =>
      'कनेक्शन खो गया: हार्टबीट टाइमआउट';

  @override
  String get noHostDiscovered => 'कोई होस्ट नहीं मिला।';

  @override
  String get confirmResignation => 'हार मानने की पुष्टि करें';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'खेल होस्टिंग शुरू की गई, खिलाड़ियों के जुड़ने की प्रतीक्षा कर रहा है...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'कनेक्शन का समय समाप्त, नेटवर्क कनेक्शन अस्थिर।';

  @override
  String get noLlmPromptAvailable => 'कोई LLM प्रॉम्प्ट उपलब्ध नहीं है।';

  @override
  String get youResignedGameOver => 'आपने हार मान ली। खेल समाप्त।';

  @override
  String get serverIp => 'सर्वर IP';

  @override
  String get confirmClear => 'साफ़ करने की पुष्टि करें';

  @override
  String get opponentSTurn => 'प्रतिद्वंद्वी की बारी।';

  @override
  String get waitingAClientConnection =>
      'क्लाइंट कनेक्शन की प्रतीक्षा कर रहा है...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'वापस लेने का अनुरोध अस्वीकृत या विफल रहा।';

  @override
  String get addText => 'पाठ जोड़ें';

  @override
  String get exitAnnotationMode => 'एनोटेशन मोड से बाहर निकलें';

  @override
  String get typeYourAnnotation => 'अपना एनोटेशन टाइप करें';

  @override
  String get attemptingToReconnect => 'पुनः कनेक्ट करने का प्रयास कर रहा है...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'पुनरारंभ अनुरोध भेजा गया। प्रतिद्वंद्वी के उत्तर की प्रतीक्षा कर रहा है...';

  @override
  String get serverIsStopped => 'सर्वर बंद है।';

  @override
  String get restartRequest => 'पुनरारंभ अनुरोध';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'जब आपकी बारी नहीं है तो वापस लेने का अनुरोध नहीं कर सकते।';

  @override
  String get takeBackAccepted => 'वापस लेना स्वीकार किया गया।';

  @override
  String get localNetworkSettings => 'स्थानीय नेटवर्क सेटिंग्स';

  @override
  String get reconnectedSuccessfully => 'सफलतापूर्वक पुनः कनेक्ट हो गया!';

  @override
  String get failedToSaveImageToGallery => 'गैलरी में छवि सहेजने में विफल।';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'प्रतिद्वंद्वी ने खेल पुनरारंभ करने का अनुरोध किया है। क्या आप स्वीकार करते हैं?';

  @override
  String get yourTurn => 'आपकी बारी।';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'पुनः कनेक्ट करने में असमर्थ, कृपया खेल पुनरारंभ करें।';

  @override
  String get host => 'होस्ट';

  @override
  String get join => 'जुड़ें';

  @override
  String get port => 'पोर्ट';

  @override
  String get invalidIpAddress => 'अमान्य IP पता।';

  @override
  String get invalidPort => 'अमान्य पोर्ट।';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'कनेक्ट कर रहा है: प्रयास $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'कनेक्ट करने में विफल: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'होस्टिंग शुरू करने में विफल: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'होस्ट मिला: $ip:$port';
  }

  @override
  String get stop => 'रोकें';

  @override
  String get discover => 'खोजें';

  @override
  String get connect => 'कनेक्ट करें';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'क्लाइंट कनेक्टेड: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'खोज रहा है: $seconds सेकंड';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'पुनः कनेक्ट कर रहा है ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'कनेक्टेड';

  @override
  String get delete => 'हटाएँ';

  @override
  String get ancientEgypt => 'प्राचीन मिस्र';

  @override
  String get gothicIce => 'गॉथिक बर्फ';

  @override
  String get riceField => 'चावल का खेत';

  @override
  String get chinesePorcelain => 'चीनी चीनी मिट्टी';

  @override
  String get desertDusk => 'रेगिस्तान का संध्या';

  @override
  String get precisionCraft => 'सटीक शिल्प';

  @override
  String get folkEmbroidery => 'लोक कढ़ाई';

  @override
  String get carpathianHeritage => 'कार्पेथियन विरासत';

  @override
  String get imperialGrandeur => 'शाही वैभव';

  @override
  String get bohemianCrystal => 'बोहेमियन क्रिस्टल';

  @override
  String get savannaSunrise => 'सवाना सूर्योदय';

  @override
  String get harmonyBalance => 'सामंजस्य संतुलन';

  @override
  String get cinnamonSpice => 'दालचीनी मसाला';

  @override
  String get anatolianMosaic => 'अनातोलियन मोज़ेक';

  @override
  String get carnivalSpirit => 'कार्निवल आत्मा';

  @override
  String get custom => 'रिवाज़';

  @override
  String get spiceMarket => 'मसाला बाज़ार';

  @override
  String get swipeToRevealTheDrawer => 'ड्रॉअर दिखाने के लिए स्वाइप करें';

  @override
  String get showGameInfoOnScreenshots => 'स्क्रीनशॉट्स पर गेम जानकारी दिखाएँ';

  @override
  String get humanMoveTime => 'मानव समय सीमा';

  @override
  String get noTimeLimitForHumanMoves => 'मानव चालों के लिए कोई समय सीमा नहीं';

  @override
  String get timeoutLoseWillBeApplied =>
      'मानव खिलाड़ी के लिए टाइमआउट हार लागू होगी';

  @override
  String get identifyingBoard => 'बोर्ड की पहचान की जा रही है…';

  @override
  String get youCanEnterAnyModelName => 'आप कोई भी मॉडल नाम दर्ज कर सकते हैं।';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'बोर्ड पोजिशन लागू किया गया। FEN क्लिपबोर्ड पर कॉपी किया गया।';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'सुझाव: बोर्ड की एक स्पष्ट तस्वीर लें।';

  @override
  String get llmPromptTemplate => 'LLM प्रॉम्प्ट टेम्पलेट';

  @override
  String get noValidBoardDetected => 'कोई वैध बोर्ड नहीं मिला।';

  @override
  String get selectingImageFromAlbum => 'एल्बम से छवि चुनी जा रही है…';

  @override
  String get configurePromptTemplate => 'प्रॉम्प्ट टेम्पलेट कॉन्फ़िगर करें';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'LLM विश्लेषण के लिए प्रॉम्प्ट टेम्पलेट संपादित करें';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'पहचाने गए बोर्ड से FEN जेनरेट करने में विफल।';

  @override
  String get outputInCurrentLanguage => 'वर्तमान भाषा में आउटपुट';

  @override
  String get commonBaseUrls => 'सामान्य Base URL';

  @override
  String get viewCommonModels => 'सामान्य मॉडल देखें';

  @override
  String get recognitionParametersUpdated => 'पहचान पैरामीटर अपडेट किए गए।';

  @override
  String get whiteSMove => 'सफेद की चाल';

  @override
  String get resetToDefaults => 'डिफ़ॉल्ट पर रीसेट करें';

  @override
  String get photoShoot => 'फ़ोटो शूट';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'पहचानी गई बोर्ड स्थिति लागू करने में विफल।';

  @override
  String get llmPromptContent => 'LLM प्रॉम्प्ट सामग्री';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM कॉन्फ़िगर नहीं है। कृपया अपनी सेटिंग्स जांचें।';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'प्रोवाइडर, मॉडल, API Key, और Base URL सेट करें';

  @override
  String get llmConfiguration => 'LLM कॉन्फ़िगरेशन';

  @override
  String get configureLlmProvider => 'LLM प्रोवाइडर कॉन्फ़िगर करें';

  @override
  String get llmPromptTemplateHeader => 'LLM प्रॉम्प्ट टेम्पलेट हेडर';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'छवि में कोई पीस नहीं पहचाना गया। कृपया पुन: प्रयास करें।';

  @override
  String get recognizeBoardFromImage => 'छवि से बोर्ड पहचानें';

  @override
  String get viewTips => 'टिप्स देखें';

  @override
  String get applyToBoard => 'बोर्ड पर लागू करें';

  @override
  String get adjustBoardArea => 'बोर्ड क्षेत्र समायोजित करें';

  @override
  String get viewCommonUrls => 'सामान्य URLs देखें';

  @override
  String get colorAnalysisFailed => 'रंग विश्लेषण विफल!';

  @override
  String get analyzingGameBoardImage => 'गेम बोर्ड छवि का विश्लेषण हो रहा है…';

  @override
  String get selectFromAlbum => 'एल्बम से चुनें';

  @override
  String get noBoardPointDetected => 'कोई बोर्ड बिंदु नहीं मिला!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'खाली छोड़ने पर डिफ़ॉल्ट टेम्पलेट का उपयोग किया जाएगा';

  @override
  String get llmConfig => 'LLM कॉन्फ़िगरेशन';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'क्या आप वाकई प्रॉम्प्ट टेम्पलेट्स को डिफ़ॉल्ट मूल्यों पर रीसेट करना चाहते हैं?';

  @override
  String get llmPromptTemplateFooter => 'LLM प्रॉम्प्ट टेम्पलेट फुटर';

  @override
  String get loadingResponse => 'प्रतिक्रिया लोड हो रही है…';

  @override
  String get applyThisResultToBoard => 'इस परिणाम को बोर्ड पर लागू करें';

  @override
  String get takingPicture => 'तस्वीर ली जा रही है…';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'कृपया पहचानने के लिए गेम बोर्ड छवि चुनें';

  @override
  String get identificationResults => 'पहचान परिणाम';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'चालों का विश्लेषण करें और अंतर्दृष्टि प्रदान करें।';

  @override
  String get getApiKey => 'API Key प्राप्त करें';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'पूरी पहचान प्रक्रिया पूरी करने में विफल रही।';

  @override
  String get boardRecognitionResult => 'बोर्ड पहचान परिणाम';

  @override
  String get askLlm => 'LLM से पूछें';

  @override
  String get boardDetectionFailed => 'बोर्ड का पता लगाने में विफल!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'कोई बोर्ड बिंदु नहीं मिला, टुकड़ा पहचानने में असमर्थ!';

  @override
  String get copyFen => 'FEN कॉपी करें';

  @override
  String get commonlyUsedModels => 'सामान्यतया इस्तेमाल किए जाने वाले मॉडल';

  @override
  String get apiKeyOptional => 'API Key (वैकल्पिक)';

  @override
  String get noImageSelected => 'कोई छवि चयनित नहीं';

  @override
  String get blackSMove => 'काले की चाल';

  @override
  String get llm => 'बड़ा भाषा मॉडल';

  @override
  String get llmProvider => 'प्रदाता';

  @override
  String get baseUrl => 'बेस URL';

  @override
  String get model => 'मॉडल';

  @override
  String get temperature => 'तापमान';

  @override
  String get llmCommandReceivedProcessing =>
      'आदेश प्राप्त! AI प्रोसेस कर रहा है...';

  @override
  String get llmDeepThinkingWait => 'गहन सोच जारी है, कृपया प्रतीक्षा करें...';

  @override
  String get llmPresentingSoon => 'शीघ्र प्रस्तुत किया जाएगा...';

  @override
  String get recognitionParameters => 'पहचान पैरामीटर';

  @override
  String get adjustParamsDesc =>
      'पहचान की सटीकता बढ़ाने के लिए पैरामीटर समायोजित करें';

  @override
  String get saveParameters => 'पैरामीटर सहेजें';

  @override
  String unableToStartImageRecognition(String error) {
    return 'छवि पहचान प्रारंभ करने में असमर्थ: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'छवि पहचान विफल हुई: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'लागू स्थिति में $whiteCount सफेद और $blackCount काले मोहरे';
  }

  @override
  String get fenCopiedToClipboard => '(FEN क्लिपबोर्ड पर कॉपी किया गया)';

  @override
  String recognitionFailed(String error) {
    return 'पहचान विफल हुई: $error';
  }

  @override
  String get myRating => 'मेरी रेटिंग';

  @override
  String get gamesPlayed => 'खेले गए गेम';

  @override
  String get wins => 'जीत';

  @override
  String get losses => 'हार';

  @override
  String get draws => 'ड्रॉ';

  @override
  String get lastUpdated => 'पिछला अपडेट';

  @override
  String get format => 'प्रारूप:';

  @override
  String get resetStatistics => 'आँकड़े रीसेट करें';

  @override
  String get drawRate => 'ड्रॉ दर';

  @override
  String get lossRate => 'हार दर';

  @override
  String get aiStatistics => 'AI आँकड़े';

  @override
  String get enableStatistics => 'आँकड़े सक्षम करें';

  @override
  String get enableStatistics_Detail =>
      'सक्षम होने पर, गेम के नतीजे आँकड़ों में दर्ज किए जाएँगे। हालाँकि, टेक-बैक वाले गेम दर्ज नहीं किए जाएँगे। अक्षम होने पर, आँकड़ों का संग्रह रोक दिया जाता है।';

  @override
  String get thisWillResetAllGameStatistics =>
      'यह सभी गेम आँकड़ों को रीसेट कर देगा। यह कार्रवाई पूर्ववत नहीं की जा सकती।';

  @override
  String get boardInnerRingSize => 'बोर्ड की भीतरी रिंग का आकार';

  @override
  String get boardShadowEnabled => 'बोर्ड की छाया';

  @override
  String get trapAwareness => 'फंदा पहचान';

  @override
  String get trapAwarenessDescription =>
      'विश्लेषण के दौरान मोटे वृत्त और तीरों से फंदे वाली चालों को हाइलाइट करें।';

  @override
  String trapExists(String trapMoves) {
    return 'फंदा मौजूद है। फंदे वाली चालें: $trapMoves';
  }

  @override
  String get custodianCapture => 'झिलमिलाहट पर कब्जा';

  @override
  String get custodianCaptureDescription =>
      'अपने प्रतिद्वंद्वी के टुकड़ों में से एक को अपने दो के बीच एक सीधी रेखा में पकड़ने के लिए संलग्न करें।';

  @override
  String get custodianCaptureEnable => 'फ्लैंकिंग कैप्चर की अनुमति दें';

  @override
  String get interventionCapture => 'हस्तक्षेप कब्जा';

  @override
  String get interventionCaptureDescription =>
      'उन दोनों को पकड़ने के लिए अपने दो प्रतिद्वंद्वी के टुकड़ों के बीच खाली बिंदु में जाएं।';

  @override
  String get interventionCaptureEnable =>
      'हस्तक्षेप पर कब्जा करने की अनुमति दें';

  @override
  String get leapCapture => 'कूद कब्जा';

  @override
  String get leapCaptureDescription =>
      'एक आसन्न प्रतिद्वंद्वी के टुकड़े को खाली बिंदु से परे पर कूदकर कैप्चर करें।';

  @override
  String get leapCaptureEnable => 'कूद पकड़ने की अनुमति दें';

  @override
  String get captureApplicableLines => 'लागू लाइनें';

  @override
  String get captureSquareEdges => 'वर्ग के किनारों के साथ';

  @override
  String get captureCrossLines =>
      'वर्ग को पार करने वाले ऑर्थोगोनल लाइनों के साथ';

  @override
  String get captureDiagonalLines => 'विकर्ण लाइनों के साथ वर्ग को पार करना';

  @override
  String get captureExecutionPhases => 'निष्पादन चरण';

  @override
  String get capturePiecesCondition =>
      'शेष टुकड़ों के आधार पर चलती चरण के दौरान उपलब्धता';

  @override
  String get capturePiecesConditionUnlimited => 'प्रतिबंध नहीं';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'जब आपके पास तीन या उससे कम टुकड़े हों तो उपलब्ध';
}
