// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Hebrew (`he`).
class SHe extends S {
  SHe([String locale = 'he']) : super(locale);

  @override
  String get appName => 'טחנה';

  @override
  String get welcome => 'ברוך הבא';

  @override
  String get yes => 'כן';

  @override
  String get no => 'לא';

  @override
  String get game => 'מִשְׂחָק';

  @override
  String get humanVsAi => 'האדם נגד AI';

  @override
  String get humanVsHuman => 'האדם נגד בן אנוש';

  @override
  String get aiVsAi => 'AI לעומת AI';

  @override
  String get humanVsCloud => 'האדם נגד ענן';

  @override
  String get humanVsLAN => 'האדם נגד LAN';

  @override
  String get testViaLAN => 'בדוק באמצעות LAN';

  @override
  String get move => 'מהלך';

  @override
  String get showMoveList => 'רשימת העברה';

  @override
  String get moveList => 'רשימת העברה';

  @override
  String get noGameRecord => 'אין תיעוד';

  @override
  String get ok => 'בסדר';

  @override
  String get confirm => 'לְאַשֵׁר';

  @override
  String get cancel => 'לְבַטֵל';

  @override
  String get tipSelectWrong => 'בחר את היצירה הלא נכונה.';

  @override
  String get tipPlace => 'הנח את החלקים שלך.';

  @override
  String get tipBanPlace => 'אתה לא יכול למקם את זה כאן.';

  @override
  String get tipPlaced => 'אתה הנחת.';

  @override
  String get tipRemove => 'הסר חתיכה.';

  @override
  String get tipBanRemove => 'אתה לא יכול להסיר אותו.';

  @override
  String get tipRemoved => 'הסרת.';

  @override
  String get tipMove => 'הזיזו חתיכה.';

  @override
  String get tipCannotPlace => 'אתה לא יכול למקם את היצירה שלך כאן.';

  @override
  String get tipCannotMove => 'אתה לא יכול להעביר את היצירה שלך לכאן.';

  @override
  String get tipMill => 'טחנה! קח את החתיכה של היריב שלך.';

  @override
  String get tipContinueMill => 'המשך לקחת את החלק של היריב שלך.';

  @override
  String get tipSelectOpponentsPiece => 'בחר אחד מהכלים של היריב שלך.';

  @override
  String get tipCannotRemovePieceFromMill => 'אתה לא יכול להסיר חתיכה מטחנה.';

  @override
  String get tipCanMoveOnePoint => 'חתיכה יכולה להזיז נקודה אחת.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'אתה לא יכול להזיז את הכלים של היריב שלך.';

  @override
  String get tipSelectPieceToMove => 'בחר את היצירה שלך להזזה.';

  @override
  String get tipHaveThreePiecesLeft => 'נשארו לך שלושה חלקים.';

  @override
  String get tipCanMoveToAnyPoint => 'אתה יכול לעבור לכל נקודה שתרצה.';

  @override
  String tipToMove(Object player) {
    return '$player כדי לזוז.';
  }

  @override
  String get whiteWin => 'שחקן 1 מנצח!';

  @override
  String get blackWin => 'שחקן 2 מנצח!';

  @override
  String get won => 'זכית';

  @override
  String get lost => 'אָבֵד';

  @override
  String get thinking => 'חושב…';

  @override
  String get newGame => 'משחק חדש';

  @override
  String get importGame => 'ייבוא משחק';

  @override
  String get exportGame => 'ייצוא משחק';

  @override
  String get gameImported => 'המשחק מיובא.';

  @override
  String cannotImport(Object invalidMove) {
    return 'לא ניתן לייבא $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'המהלכים והכללים אינם תואמים.';

  @override
  String get pleaseWait => 'המתן בבקשה.';

  @override
  String get restartGame => 'להפעיל מחדש את המשחק הנוכחי?';

  @override
  String get restart => 'איתחול';

  @override
  String get gameStarted => 'המשחק התחיל, נא למקם.';

  @override
  String get analyzing => 'מנתח…';

  @override
  String error(Object message) {
    return 'שגיאה: $message';
  }

  @override
  String get winRate => 'שיעור זכייה';

  @override
  String get score => 'ציון:';

  @override
  String get white => 'שחקן 1';

  @override
  String get black => 'שחקן 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player ספירת חתיכות היא פחות משלוש.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player התפטר.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return 'ל-$player אין דרך ללכת.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'הלוח מלא, ול-$player אין דרך ללכת.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'הזמן נגמר, $player אבוד.';
  }

  @override
  String get drawReasonRule50 =>
      'בשלב התנועה, אף חלק לא הוסר במספר המהלכים הספציפי האחרון.';

  @override
  String get drawReasonBoardIsFull => 'זה תיקו כי הלוח מלא.';

  @override
  String get drawReasonThreefoldRepetition => 'זה תיקו בגלל חזרה משולשת.';

  @override
  String get gameOverUnknownReason => 'סוף המשחק! סיבה לא ידועה.';

  @override
  String get gameOver => 'סוף המשחק';

  @override
  String get youWin => 'ניצחת! מזל טוב!';

  @override
  String challengeHarderLevel(int level) {
    return 'לאתגר ברמה קשה יותר? הרמה החדשה תהיה רמה $level!';
  }

  @override
  String get youLose => 'הפסדת!';

  @override
  String get analyze => 'לְנַתֵחַ';

  @override
  String get about => 'על אודות';

  @override
  String version(Object versionNumber) {
    return 'גרסה: $versionNumber';
  }

  @override
  String get thanks => 'תודה';

  @override
  String get settings => 'הגדרות';

  @override
  String get options => 'אפשרויות';

  @override
  String get generalSettings => 'הגדרות כלליות';

  @override
  String get skillLevel => 'רמת קושי';

  @override
  String get moveTime => 'זמן חשיבה בינה מלאכותית';

  @override
  String get difficulty => 'קושי';

  @override
  String get playSounds => 'אפקטים קוליים';

  @override
  String get playSoundsInTheGame => 'השמעת צלילים במשחק';

  @override
  String get keepMuteWhenTakingBack => 'שמור על השתק בעת ההחזרה';

  @override
  String get tone => 'טוֹן';

  @override
  String get whoMovesFirst => 'צעד ראשון';

  @override
  String get human => 'בן אנוש';

  @override
  String get ai => 'AI';

  @override
  String get alternate => 'לְהַחלִיף';

  @override
  String get isAutoRestart => 'הפעלה מחדש אוטומטית של המשחק כאשר המשחק נגמר';

  @override
  String get isAutoChangeFirstMove => 'שינוי אוטומטי מהלך ראשון';

  @override
  String get shufflingEnabled => 'זז באקראי';

  @override
  String get misc => 'שונות';

  @override
  String get rules => 'כללים';

  @override
  String get piecesCount => 'מספר החלקים שיש לכל שחקן';

  @override
  String get piecesCount_Detail => 'כמה חלקים יש לכל שחקן?';

  @override
  String get flyPieceCount => 'המספר של החתיכה המעופפת';

  @override
  String get flyPieceCount_Detail =>
      'אם טיסה מופעלת, כאשר שחקן מצטמצם לספירת כלים ספציפית, הכלים שלו חופשיים לעבור לכל נקודה לא תפוסה במקום להיות מוגבל לנקודות סמוכות כמו בשאר המשחק.';

  @override
  String get piecesAtLeastCount => 'חתיכות לפחות';

  @override
  String get hasDiagonalLines => 'קווים אלכסוניים';

  @override
  String get hasDiagonalLines_Detail => 'הוסף ארבעה קווים אלכסוניים ללוח.';

  @override
  String get isDefenderMoveFirst => 'השחקן השני זז ראשון';

  @override
  String get isDefenderMoveFirst_Detail =>
      'השחקן שזז שני בשלב ההצבה זז ראשון בשלב התנועה.';

  @override
  String get mayRemoveMultiple => 'הסרה מרובה';

  @override
  String get mayRemoveMultiple_Detail =>
      'אם שחקן סוגר יותר ממפעל אחד בבת אחת, היא תסיר את מספר הטחנות שסגרה.';

  @override
  String get mayRemoveFromMillsAlways => 'להרוס טחנות';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'כברירת מחדל, שחקנים חייבים להסיר תחילה כל חלק אחר לפני הסרת חתיכה מטחנה שנוצרה. אפשר אפשרות זו כדי להשבית את המגבלה.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'השחקן השני מפסיד כשהלוח מלא';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'כאשר הלוח מלא בסוף שלב ההצבה, הצד שממקם ראשון מפסיד במשחק. אחרת, המשחק הוא תיקו.';

  @override
  String get isLoseButNotChangeSideWhenNoWay => 'להפסיד כשאין מהלכים חוקיים';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'השחקן יפסיד אם יריבו יחסום אותם כך שלא ניתן להזיז אותם. שנה צד כדי להזיז אם אפשרות זו מושבתת.';

  @override
  String get mayFly => 'עַף';

  @override
  String get mayFly_Detail =>
      'אם לשחקן נותרו רק שלושה או ארבעה חלקים (ניתנים להגדרה), היא יכולה להעביר את הכלי לכל נקודה פנויה.';

  @override
  String get nMoveRule => 'כלל N-move';

  @override
  String get nMoveRule_Detail =>
      'המשחק מוגרל אם לא הייתה הסרה במספר מסוים של מהלכים.';

  @override
  String get rollback => 'גלגל לאחור';

  @override
  String get pleaseSelect => 'בבקשה תבחר';

  @override
  String get copy => 'עותק';

  @override
  String get moveHistoryCopied => 'העבר את ההיסטוריה שהועתקה ללוח.';

  @override
  String get help => 'עֶזרָה';

  @override
  String get feedback => 'מָשׁוֹב';

  @override
  String get exit => 'יְצִיאָה';

  @override
  String get ruleSettings => 'הגדרות כללים';

  @override
  String get color => 'צֶבַע';

  @override
  String get boardColor => 'צבע לוח';

  @override
  String get pieceColor => 'צבע החתיכה';

  @override
  String get backgroundColor => 'צבע רקע';

  @override
  String get lineColor => 'צבע קו הלוח';

  @override
  String get whitePieceColor => 'צבע שחקן 1 חתיכה';

  @override
  String get blackPieceColor => 'צבע שחקן 2 חלקים';

  @override
  String get messageColor => 'צבע ההודעה';

  @override
  String get isPieceCountInHandShown => 'הצג את ספירת החלקים שלא הוצבו';

  @override
  String get isNotationsShown => 'הצג סימון על הסיפון';

  @override
  String get isHistoryNavigationToolbarShown =>
      'הצג את סרגל הכלים של ניווט בהיסטוריה';

  @override
  String get display => 'לְהַצִיג';

  @override
  String get boardBorderLineWidth => 'רוחב קו גבולי של הלוח';

  @override
  String get boardInnerLineWidth => 'רוחב הקו הפנימי של הלוח';

  @override
  String get pieceWidth => 'רוחב חתיכה';

  @override
  String get fontSize => 'גודל גופן';

  @override
  String get standardNotation => 'סימון WMD';

  @override
  String get restore => 'לשחזר';

  @override
  String get restoreDefaultSettings => 'שחזר הגדרות ברירת מחדל';

  @override
  String pick(Object element) {
    return 'בחר $element';
  }

  @override
  String get info => 'מידע';

  @override
  String get hint => 'רֶמֶז';

  @override
  String get player => 'שחקן';

  @override
  String get player1 => 'שחקן 1';

  @override
  String get player2 => 'שחקן 2';

  @override
  String get howToPlay => 'איך לשחק';

  @override
  String get toPlacePiece => 'הקש על כל נקודה זמינה כדי למקם את היצירה.';

  @override
  String get toSelectPiece => 'הקש על חלק כדי להזיז אותו.';

  @override
  String get toMovePiece => 'הקש על נקודה המחוברת ליצירה כדי להזיז אותה.';

  @override
  String get toRemovePiece => 'הקש על החלק האחד של היריב כדי להסיר.';

  @override
  String get needToCreateMillFirst =>
      'תחילה עליך ליצור טחנה לפני שתוכל להסיר חתיכה.';

  @override
  String get needToPlayWithOwnPieces => 'אתה צריך לשחק עם הכלים שלך.';

  @override
  String get statistics => 'סטָטִיסטִיקָה';

  @override
  String get totalGames => 'סך הכל משחקים';

  @override
  String get results => 'תוצאות';

  @override
  String get left => 'שמאלה';

  @override
  String get privacyPolicy => 'מדיניות הפרטיות';

  @override
  String get privacyPolicy_Detail_1 =>
      'אנא קרא בעיון וודא שאתה מבין לחלוטין ומסכים לכך ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. אם אינך מסכים למדיניות זו, אנא אל תשתמש באפליקציה זו. השימוש באפליקציה מעיד על הסכמתך לתנאים אלה.';

  @override
  String get and => ' ו ';

  @override
  String get accept => 'לְקַבֵּל';

  @override
  String get takeBack => 'קח בחזרה';

  @override
  String get takingBack => 'לוקח חזרה…';

  @override
  String get waiting => 'הַמתָנָה…';

  @override
  String get stepForward => 'צעד קדימה';

  @override
  String get takeBackAll => 'קח בחזרה הכל';

  @override
  String get stepForwardAll => 'צעד קדימה כולם';

  @override
  String get moveNow => 'זוז עכשיו';

  @override
  String get done => 'בוצע.';

  @override
  String get crackMill => 'קראק-מיל';

  @override
  String get crackMill_Detail =>
      'אם לשחקן יש רק חלקים בטחנות, החלקים בטחנות לא יינעלו להסרה.';

  @override
  String get animationDuration => 'משך הנפשה';

  @override
  String get none => 'אף אחד';

  @override
  String get theme => 'נושא';

  @override
  String get helpContent =>
      'המשחק נועד להשאיר את היריב עם פחות משלושה כלים או ללא מהלכים חוקיים.\n\nהמשחק מושך אוטומטית אם עמדה מתרחשת בפעם השלישית או לא מבצעת הסרה ב-100 המהלכים האחרונים (ניתנים להגדרה).\n\nהמשחק מתקדם בשלושה שלבים:\n\n1. הנחת חלקים על נקודות פנויות\n2. העברת חלקים לנקודות סמוכות\n3. (שלב אופציונלי) העברת כלים לכל נקודה פנויה בעת צמצום השחקן לשלושה כלים\n\nהַצָבָה\n\nהמשחק מתחיל עם לוח ריק, המורכב מרשת עם עשרים וארבע נקודות. שחקנים מתחלפים ומניחים את הכלים שלהם בנקודות פנויות עד שכל שחקן הניח את כל הכלים על הלוח. אם שחקן יכול לשים שלוש מהכלים שלו ישר, יש לו \"טחנה\" והוא רשאי להסיר את אחת הכלים של יריבו מהלוח.\n\nבחוקים מסוימים, שחקנים חייבים להסיר תחילה כל חלק אחר לפני הסרת חתיכה מטחנה שנוצרה.\n\nאתה לא יכול למקם את החלקים לנקודות של החלקים שהוסרו שוב בשלב ההצבה בחוקים מסוימים.\n\nלאחר השימוש בכל החלקים, השחקנים מתחלפים בתנועה.\n\nמעבר דירה\n\nכדי לזוז, שחקן מזיז את אחד הכלים שלו לאורך קו לוח לנקודה סמוכה פנויה. אם הוא לא יכול לעשות זאת, הוא הפסיד במשחק. לשחקן שמיישר שלוש מהכלים שלו על קו לוח יש טחנה והוא רשאי להסיר את אחת מהכלים של יריבו כמו בשלב ההצבה. כל שחקן מפחית לשני חלקים, אין לו אפשרות ליצור טחנות חדשות, ובכך מפסיד את המשחק. שחקן יכול גם להפסיד כאשר יותר משלושה כלים אם היריב שלו חוסם אותם מלנוע.\n\nעַף\n\nבגרסאות מסוימות של הכללים, ברגע שלשחקן נותרו רק שלושה חלקים, הכלים שלו יכולים לעוף, לקפוץ או לקפוץ לכל נקודה פנויה, לא רק לסמוכות.\n';

  @override
  String get versionInfo => 'מידע על גרסה';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'רישיון';

  @override
  String get sourceCode => 'קוד מקור';

  @override
  String get appVersion => 'גרסת האפליקציה';

  @override
  String get general => 'כללי';

  @override
  String get advanced => 'מִתקַדֵם';

  @override
  String get placing => 'הַצָבָה';

  @override
  String get moving => 'מעבר דירה';

  @override
  String get removing => 'מסיר';

  @override
  String get gameOverCondition => 'מצב המשחק מעל';

  @override
  String get aisPlayStyle => 'סגנון המשחק של AI';

  @override
  String get passive => 'פַּסִיבִי';

  @override
  String get timeout => 'פסק זמן';

  @override
  String get appearance => 'מראה חיצוני';

  @override
  String get drawOnHumanExperience => 'הציבו את החוויה האנושית';

  @override
  String get considerMobility => 'שקול ניידות של חלקים';

  @override
  String get pieceCount => 'ספירת חתיכות:';

  @override
  String inHand(Object player, int count) {
    return '$player ביד: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player על הסיפון: $count';
  }

  @override
  String get boardTop => 'קיזוז לוח מלמעלה';

  @override
  String get notAIsTurn => 'זה לא תורו של ה-AI.';

  @override
  String get aiIsNotThinking => 'AI לא חושב.';

  @override
  String get atEnd => 'אתה בסוף רשימת המהלכים.';

  @override
  String get tapBackAgainToLeave => 'הקש שוב אחורה כדי לצאת.';

  @override
  String get more => 'יותר';

  @override
  String get experimental => 'זוהי תכונה ניסיונית.';

  @override
  String get experiments => 'ניסויים';

  @override
  String get ossLicenses => 'רישיונות קוד פתוח';

  @override
  String get language => 'שפה';

  @override
  String get defaultLanguage => 'שפת ברירת מחדל';

  @override
  String get mayMoveInPlacingPhase => 'החלקים יכולים לנוע בשלב ההצבה';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'אין שלבי מיקום ותנועה ברורים, כלומר, השחקנים יכולים להחליט בכל מהלך אם הם רוצים להניח כלים על הלוח או להזיז את אחד הכלים שלהם (כל עוד יש להם כלים שנותרו למקם).';

  @override
  String get drawerColor => 'צבע התפריט';

  @override
  String get drawerTextColor => 'צבע טקסט בתפריט';

  @override
  String get drawerHighlightItemColor => 'הדגשת צבע הפריט בתפריט';

  @override
  String get mainToolbarBackgroundColor => 'צבע רקע של סרגל הכלים הראשי';

  @override
  String get mainToolbarIconColor => 'צבע סמל סרגל הכלים הראשי';

  @override
  String get navigationToolbarBackgroundColor =>
      'צבע רקע של סרגל הכלים של ניווט';

  @override
  String get navigationToolbarIconColor => 'צבע סמל סרגל הניווט';

  @override
  String get autoHideToolbar => 'הסתר אוטומטית את סרגל הכלים';

  @override
  String get toolbarLocationOnScreen => 'מיקום סרגל הכלים על המסך';

  @override
  String get top => 'חלק עליון';

  @override
  String get bottom => 'תַחתִית';

  @override
  String get center => 'מֶרְכָּז';

  @override
  String get solidColor => 'צבע אחיד';

  @override
  String get picture => 'תְמוּנָה';

  @override
  String get chooseYourPicture => 'בחר את התמונה שלך';

  @override
  String get light => 'אוֹר';

  @override
  String get dark => 'אפל';

  @override
  String get themes => 'ערכות נושא';

  @override
  String get currentTheme => 'נושא נוכחי';

  @override
  String get saveTheme => 'שמור עיצוב';

  @override
  String get showAnalysisGraph => 'הצג גרף ניתוח';

  @override
  String get analysis => 'אָנָלִיזָה';

  @override
  String get saveGame => 'שמור משחק';

  @override
  String get loadGame => 'טוען משחק';

  @override
  String get setupPosition => 'מיקום הגדרה';

  @override
  String get showLegalMoves => 'הצג מהלכים חוקיים';

  @override
  String get showLastMove => 'הצג את המהלך האחרון';

  @override
  String get showArrows => 'הצג חיצים';

  @override
  String get pieces => 'חתיכות';

  @override
  String get showAnalysis => 'הצג ניתוח';

  @override
  String get threads => 'חוטים';

  @override
  String get getInvolved => 'להתערב';

  @override
  String get helpImproveTranslate => 'עזור לשפר את התרגום';

  @override
  String get tutorial => 'הדרכה';

  @override
  String get classicMill => 'מיל קלאסי';

  @override
  String get mixedMill => 'מיל מעורבת';

  @override
  String get ceylonMill => 'טחנת ציילון';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'טחנה עשויה להישבר ולעשות מחדש שוב ושוב';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'אם שחקן שובר טחנה כדי ליצור טחנת חדשה באופן מיידי, שחקן כזה יכול להזיז את החלק הזה בחזרה לצומת המקורי בצעד הבא שלו אם הוא עושה טחנת חדשה.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'המשחק מוגרל אם לשחקן יש שלושה כלים ואחרי עשרה מהלכים אף אחד מהשחקנים לא מסיר את הכלים של היריב';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'כאשר השחקן ירד לשלושה חלקים, ואף אחד מהשחקנים לא יכול להסיר את הכלי של היריב תוך עשרה מהלכים, המשחק הוא תיקו.';

  @override
  String get close => 'סגור';

  @override
  String get whitePiece => 'חתיכה לבנה';

  @override
  String get blackPiece => 'חתיכה שחורה';

  @override
  String get emptyPoint => 'נקודה ריקה';

  @override
  String get noPoint => 'אין פואנטה';

  @override
  String get placingPhase => 'שלב ההשמה';

  @override
  String get movingPhase => 'שלב נע';

  @override
  String get flyingPhase => 'שלב הטיסה';

  @override
  String sideToMove(Object player) {
    return 'צד להזזה: $player';
  }

  @override
  String lastMove(Object move) {
    return 'מהלך אחרון: $move';
  }

  @override
  String get selected => 'נבחר';

  @override
  String get accessibility => 'נְגִישׁוּת';

  @override
  String get screenReaderSupport => 'תמיכה בקורא מסך';

  @override
  String get isDraw => 'זה תיקו!';

  @override
  String get draw => 'לצייר';

  @override
  String get pieceHighlightColor => 'צבע הדגשה של היצירה';

  @override
  String get algorithm => 'אַלגוֹרִיתְם';

  @override
  String get endgameNMoveRule => 'סוף המשחק N-Move כלל';

  @override
  String get endgameNMoveRule_Detail =>
      'המשחק מוגרל אם לכל אחד מהשחקנים יש רק שלושה כלים ואף אחד מהשחקנים לא מסיר כל חלק בתוך מהלכים ספציפיים.';

  @override
  String get drawReasonEndgameRule50 =>
      'לכל אחד מהשחקנים יש רק שלושה כלים, ואף אחד מהשחקנים לא מסיר כל חלק בתוך מהלכים ספציפיים.';

  @override
  String get threefoldRepetitionRule => 'כלל חזרה משולשת';

  @override
  String get threefoldRepetitionRule_Detail =>
      'המשחק יוגרל אם מתרחשת עמדה בפעם השלישית.';

  @override
  String get continueToMakeMove => 'טחנה! המשך לעשות מהלך.';

  @override
  String get pointStyle => 'סגנון נקודתי';

  @override
  String get pointWidth => 'רוחב נקודה';

  @override
  String get solid => 'מוצק';

  @override
  String get hollow => 'חָלוּל';

  @override
  String get languageName => 'עברית';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count מהלכים',
      one: 'מהלך אחד',
      zero: 'אין מהלכים',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'טעינה נכשלה.';

  @override
  String get filename => 'שם קובץ';

  @override
  String get browse => 'לְדַפדֵף…';

  @override
  String get gameFiles => 'קבצי משחק';

  @override
  String get gameSavedTo => 'המשחק נשמר ב';

  @override
  String get empty => 'ריק';

  @override
  String get noMove => 'אין מהלך.';

  @override
  String get restoredPosition => 'מיקום התחלתי משוחזר.';

  @override
  String get clean => 'לְנַקוֹת';

  @override
  String get cleanedUp => 'ניקה.';

  @override
  String get remove => 'לְהַסִיר';

  @override
  String get noPiecesCanBeRemoved => 'לא ניתן להסיר חלקים.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count pieces',
      one: '$count piece',
      zero: 'Piece',
    );
    return 'יש להסיר $_temp0.';
  }

  @override
  String placedCount(int count) {
    return 'ממוקם ($count)';
  }

  @override
  String get placedPieceCount => 'ספירת חתיכות מוצבת בשלב ההצבה.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'השחקן הנוכחי הניח $count חלקים.';
  }

  @override
  String get notPlacingPhase => 'לא מציב שלב, לא יכול לשנות אותו.';

  @override
  String get paste => 'לְהַדבִּיק';

  @override
  String get pasteDone => 'ההדבקה מוכנה.';

  @override
  String get cannotPaste => 'לא ניתן להדביק.';

  @override
  String get isUnplacedAndRemovedPiecesShown => 'הצג חלקים שלא ממוקמים והוסרו';

  @override
  String get fullScreen => 'מסך מלא';

  @override
  String get reopenToTakeEffect =>
      'צא ופתח מחדש את האפליקציה כדי שההגדרות ייכנסו לתוקף.';

  @override
  String get forest => 'יַעַר';

  @override
  String get desktopImage => 'תמונת שולחן העבודה';

  @override
  String get invalidPosition => 'עמדה לא חוקית.';

  @override
  String get shareGIF => 'שתף GIF';

  @override
  String get pixelRatio => 'יחס פיקסלים';

  @override
  String get duration => 'מֶשֶׁך';

  @override
  String get gameScreenRecorder => 'מקליט מסך משחק';

  @override
  String get previous => 'קודם';

  @override
  String get next => 'הַבָּא';

  @override
  String get skip => 'לדלג';

  @override
  String get gotIt => 'הבנת';

  @override
  String get youCanModifyRules =>
      'אתה יכול לשנות את כללי המשחק בהגדרות הכללים.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'אתה יכול להשתמש בגלגל העכבר כדי לשנות את הערך בבורר.';

  @override
  String get noTimeLimitForThinking =>
      'זמן חשיבה בינה מלאכותית מוגדר ל-0 אומר שאין מגבלת זמן לחשיבה.';

  @override
  String get whatIsMtdf =>
      'MTD(f) הוא צורה שונה של אלגוריתם החיפוש אלפא-ביתא שמטרתה לשפר את היעילות על ידי שימוש חוזר בתוצאות חיפוש ביניים ושימוש בניחוש ראשוני טוב כדי לצמצם את מרחב החיפוש.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'אנא שים לב שהתאמת זמן החשיבה של AI עשויה להיות לא מדויקת לחלוטין. זמן החשיבה בפועל עשוי להיות קצר יותר כאשר רמת הקושי מוגדרת לערך נמוך יותר ועשוי להיות ארוך יותר כאשר ה-AI נמצא באמצע המחשבה כאשר הזמן אוזל.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'אם תגדיר את רמת הקושי גבוה אך לא תגדיל את זמן החשיבה של AI, רמת הקושי בפועל עשויה להיות מוגבלת לערך נמוך יותר בגלל אילוץ זמן החשיבה. הערך בפועל עשוי להשתנות בהתאם לביצועי המכשיר.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) הוא אלגוריתם חיפוש למציאת המהלך הטוב ביותר בעמדה נתונה. זהו שיפור של אלגוריתם אלפא-ביתא ומשתמש בחיפושי חלון null או אפס כדי לאשר שהמהלך גרוע או לא גרוע יותר מאשר ציון בטוח כבר מהווריאציה הראשית. PVS מתמקדת במהלכים המבטיחים ביותר ונמנעת מחיפושים מיותרים של סניפים לא אופטימליים, מה שעוזר לשפר את יעילות החיפוש.';

  @override
  String get whatIsAlphaBeta =>
      'אלגוריתם אלפא ביתא הוא אלגוריתם חיפוש למציאת המהלך הטוב ביותר. הוא משתמש בעקרון המינימקס ובשני ערכים, אלפא ובטא, כדי לגזום את עץ החיפוש ולהגביר את היעילות. אלפא מייצג את הציון המינימלי שהמחשב בטוח שהוא יכול לקבל, בעוד שבטא מייצגת את הציון המקסימלי שיריבו יכול לקבל. האלגוריתם עוזר למחשב לקבל החלטות חכמות ויעילות במשחק.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'לפי הניסיון האנושי, אם תנסה לנצח, תפסיד. במקום זאת, כוון לתיקו כמטרה שלך והימנע מהפסד במשחק. התבונן ביריב שלך ופתה אותם בעדינות למצב שבו הם עלולים לעשות טעויות. כשהם מראים חולשה, נצלו את ההזדמנות ודחפו בעדינות לניצחון. בדרך זו, אתה יכול לנצח את המשחק.';

  @override
  String get firstMoveDetail =>
      'במשחק זה, קל יותר לשחקן השני לנצח בהשוואה לשחקן הראשון.';

  @override
  String get passiveDetail =>
      'הפעלת האפשרות הפסיבית תגרום ל-AI להירגע כאשר יש לו יתרון בעמדה, במקום לנסות באגרסיביות לנצח כמה שיותר מהר.';

  @override
  String get moveRandomlyDetail =>
      'הפעלת אפשרות זו מגבירה את האקראיות והכיף של המשחק, בעוד שהשבתה יכולה לעזור ללמוד דרכים לנצח את הבינה המלאכותית.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'אם ה-AI מחשיב את הניידות של הכלים שלו, הוא לא רק ישאף ללכוד את הכלים של היריב כמה שיותר מהר, אלא גם ישקול לחסום את התנועות של היריב ולמנוע מהם לעשות את אותו הדבר.';

  @override
  String get whenBoardIsFull => 'כשהלוח מלא';

  @override
  String get whenBoardIsFull_Detail =>
      'בסוף שלב ההצבה, לפני תחילת שלב ההזזה, הפעולה תופיע אם הלוח מלא בחלקים.';

  @override
  String get sideToMoveRemovePiece =>
      'השחקן שזז ראשון בשלב התנועה מסיר את אחד הכלים של היריב.';

  @override
  String get agreeToDraw => 'שני הצדדים מסכימים לתיקו.';

  @override
  String get takeOpponentsPiece => 'קח את אחד הכלים של היריב שלך.';

  @override
  String get firstPlayerLose => 'השחקן הראשון מפסיד במשחק.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'השחקן הראשון והשני מסירים את אחד הכלים של היריב.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'השחקן השני והראשון מסירים את אחד הכלים של היריב.';

  @override
  String get enteredFlyingPhase =>
      'כעת נכנסו לשלב הטיסה, הכלים של היריב יכולים לקפוץ לכל נקודה ריקה על הלוח. אתה יכול לבטל את כלל המעוף ב\"הגדרות כללים\".';

  @override
  String get whenStalemate => 'כאשר קיפאון';

  @override
  String get whenStalemate_Detail =>
      'איזו פעולה תופיע כאשר לא ניתן להזיז כל חלק?';

  @override
  String get endWithStalemateLoss => 'סיים עם הפסד קיפאון לצד שנחסם.';

  @override
  String get changeSideToMove => 'שנה את הצד כדי לזוז.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'הסר את אחד הכלים של היריב ועשה את המהלך הבא.';

  @override
  String get endWithStalemateDraw => 'סיים בתיקו מבוי סתום.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'הסר את אחד הכלים של היריב ושנה את הצד לזוז.';

  @override
  String get aiResponseDelayTime => 'זמן עיכוב תגובת AI';

  @override
  String get aiIsDelaying =>
      'AI נמצא כעת בשלב תגובה מושהה. אנא המתן זמן מה לפני שתמשיך.';

  @override
  String get tipCanNotRemoveNonadjacent => 'לא ניתן להסיר חלק לא סמוך.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'במקרה של קיפאון, ניתן להסיר את החלקים של היריב הסמוכים לשלך, ללא קשר להיווצרות הטחנה.';

  @override
  String get whatIsMcts =>
      'MCTS הוא אלגוריתם ידידותי למתחילים שמקבל החלטות על ידי חקירה והערכה של מהלכים שונים באמצעות סימולציות.';

  @override
  String get goldenJade => 'ירקן הזהב';

  @override
  String get forestWood => 'יער עץ';

  @override
  String get darkMystery => 'תעלומה אפלה';

  @override
  String get midnightBlue => 'כחול חצות';

  @override
  String get greenForest => 'יער ירוק';

  @override
  String get greenMeadow => 'אחו ירוק';

  @override
  String get stonyPath => 'נתיב אבן';

  @override
  String get pastelPink => 'ורוד פסטל';

  @override
  String get turquoiseSea => 'ים טורקיז';

  @override
  String get violetDream => 'חלום ויולט';

  @override
  String get mintChocolate => 'שוקולד מנטה';

  @override
  String get skyBlue => 'שמים כחולים';

  @override
  String get playfulGarden => 'גן שובב';

  @override
  String get whatIsRetrogradeAnalysis =>
      'האלגוריתם של ניתוח רטרוגרדי משתמש בניתוח רטרוגרדי רב ערכים כדי לבנות מסד נתונים של משחק סוף מעמדות התחלה שונות, ולאחר מכן מיישם את מסד הנתונים הזה כדי לייעל את המשחק. גישה זו נכללת בקטגוריה של פתרונות Ultra-Strong.';

  @override
  String get viewAlgorithmGuide =>
      'האם תרצה לראות את המדריך למשתמש עבור אלגוריתם זה?';

  @override
  String get showPositionalAdvantageIndicator => 'הצג מחוון יתרון מיקום';

  @override
  String get usePerfectDatabase => 'השתמש במסד נתונים מושלם';

  @override
  String get perfectDatabaseDescription =>
      'אפשר אפשרות זו כדי להשתמש במסד נתונים ללא רבב של משחקים שנוצר באמצעות אלגוריתמים חדשניים. תכונה זו משלבת גם אסטרטגיות פתיחה וגם אסטרטגיות סיום כדי להציע מהלכים אופטימליים. זוהי הבחירה המועדפת על שחקנים שמחפשים את רמת הדיוק הגבוהה ביותר במשחק. נוצר באמצעות טכניקות חישוב מדוקדקות, מסד הנתונים נועד להציע פתרונות משחק כמעט מושלמים.\n\nהערה: אם הבינה המלאכותית לא מצליחה לגשת למסד הנתונים, היא תפנה לאלגוריתמים קונבנציונליים להחלטות משחק. כאשר מסד הנתונים זמין, \'רמת הקושי\' הופכת כמעט ללא תחרות, ו-\'AI Thinking Time\' חווה ירידה דרסטית. הגדרות רבות באפשרויות \'סגנון המשחק של AI\' יעקפו, מכיוון שתוצאות מסד הנתונים הן בעדיפות הגבוהה ביותר.\n\nלהדרכה כיצד להפיק את המרב ממסד הנתונים ללא רבב זה, לחץ כאן.';

  @override
  String get backgroundImage => 'תמונת רקע';

  @override
  String get whatIsRandom =>
      'כאשר האפשרות \'השתמש במסד נתונים מושלם\' אינה מופעלת, ההגדרה \'אקראי\' גורמת ל-AI להזיז חלקים באופן אקראי מבלי להשתמש באלגוריתמים כלשהם לבחירת מהלך. זה בדרך כלל מביא למשחק חלש משמעותית. לעומת זאת, כאשר \'השתמש במסד נתונים מושלם\' מופעל, ה-AI מסתמך באופן בלעדי על \'מסד הנתונים המושלם\' לקבלת החלטות, במקום לשלב אותו עם אלגוריתמים מסורתיים של AI. במצב זה, המהלכים של ה-AI מבוססים לחלוטין על תוכן מסד הנתונים, תוך הימנעות מהסתמכות על חישובים בזמן אמת או אלגוריתמי חיפוש.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'הסר את הכלכלי(ים) של היריב מהיד שלו; לאחר מכן זהו תורו של היריב להציב.';

  @override
  String get whenFormingMillsDuringPlacingPhase => 'בעת יצירת טחנות בשלב ההצבה';

  @override
  String get removeOpponentsPieceFromBoard => 'הסר את כלי היריב מהלוח.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'הסר את הלחי(ים) של היריב מהלוח; אז תורו של היריב להציב.';

  @override
  String get opponentRemovesOwnPiece => 'היריב מסיר את הכלי(ים) שלו מהלוח.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'במקום שאתה תבצע פעולה, היריב בוחר ומסיר את הכלי(ים) שלו מהלוח, ובכך מבצעצע מהלך שמזיק לעצמו.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'הסר את הלחי(ים) של היריב מהיד שלו; לאחר מכן זה תורך להזיז.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'הסר כלי(ים) מהיד של היריב. אם, לפי הגדרת ה-Multi-remove, יש להסיר מספר כלים וליריב לא נשארו כלים ביד, המשך להסיר את הכלים של היריב מהלוח. לאחר מכן, תורך להזיז. אם תמשיך ליצור טחנות, תוכל להמשיך להסיר את הכלים של היריב.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'הסר כלי(ים) מהיד של היריב. אם, לפי הגדרת ה-Multi-remove, יש להסיר מספר כלים וליריב לא נשארו כלים ביד, המשך להסיר את הכלים של היריב מהלוח. לאחר מכן, תור היריב להזיז.';

  @override
  String get markAndDelayRemovingPieces => 'סמן והשהה את הסרת הכלים.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'במהלך שלב ההצבה, הכלים שיש להסיר מסומנים, ושני השחקנים לא יכולים להציב כלים חדדשים בנקודות האלה. עם הכניסה לשלב התנועה, הכלים המסומנים האלה מוסרים לחלוטין, ואז השחקנים יכולים להזיז את הכלים שלהם לנקודות הריקות האלה.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'הפעולות שניתן לבצע בעת יצירת טחנות בשלב ההנחה.';

  @override
  String get marked => 'מסומן';

  @override
  String get menu => 'תַפְרִיט';

  @override
  String get monochrome => 'מונוכרום';

  @override
  String get youCanEnableScreenReaderSupport =>
      'תוכל להפעיל את תמיכת קורא המסך בהגדרות הנגישות בהגדרות הכלליות.';

  @override
  String get showNumbersOnPieces => 'הצג מספרים על הקלטות';

  @override
  String get saveImage => 'שמור תמונה';

  @override
  String get isAnalysisToolbarShown => 'הצג סרגל כלים לניתוח';

  @override
  String get analysisToolbarBackgroundColor => 'צבע רקע של סרגל הכלים לניתוח';

  @override
  String get analysisToolbarIconColor => 'צבע הסמל של סרגל הכלים לניתוח';

  @override
  String get transformed => 'הופך';

  @override
  String get cannotTransform => 'לא ניתן להפוך';

  @override
  String get rotate => 'סובב';

  @override
  String get horizontalFlip => 'היפוך אופקי';

  @override
  String get verticalFlip => 'היפוך אנכי';

  @override
  String get innerOuterFlip => 'היפוך פנים/חוץ';

  @override
  String get transparentCanvas => 'בד שקוף';

  @override
  String get restrictRepeatedMillsFormation => 'הגבל יצירה חוזרת של טחנות';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'חלק שהועבר מטחנה אחת למשנה לא יכול לחזור מיד לנקודה המקורית בתור הבא כדי ליצור שוב טחנה. דרושה תנועה אחרת תחילה.';

  @override
  String get oneTimeUseMill => 'טחנה לשימוש חד פעמי';

  @override
  String get oneTimeUseMill_Detail =>
      'כל טחנה יכולה להסיר חתיכה אחת של היריב רק פעם אחת. אתה יכול ליצור אותו מחדש, אבל לא ניתן להשתמש בו להסרות נוספות.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'לכללים הנוכחיים שהגדרת אין בסיס נתונים מושלם תואם. למידע נוסף על בסיס הנתונים המושלם, אנא לחץ כאן.';

  @override
  String get focusOnBlockingPaths => 'התמקד בחסימת נתיבים';

  @override
  String get focusOnBlockingPaths_Detail =>
      'עדיף להפריע לתנועת היריב על פני יצירת תחנות רוח. במקום להתמקד בהסרת חלקים על ידי השלמת תחנות רוח, ה-AI מכוון ללכוד את היריב, ולמנוע ממנו לזוז ולהבטיח ניצחון באמצעות שחיקה ולא באמצעות משחק אגרסיבי. אסטרטגיה זו אינה חוסמת באופן פעיל את תחנות הרוח של היריב.';

  @override
  String get pieceImage => 'תמונה של כלי שחמט';

  @override
  String get importColorSettings => 'ייבוא ​​הגדרות צבע';

  @override
  String get exportColorSettings => 'ייצוא הגדרות צבע';

  @override
  String get import => 'ייבוא';

  @override
  String get export => 'ייצוא';

  @override
  String get pleaseCopyJsonToClipboard =>
      'אנא העתק תחילה את הגדרות תבנית ה-JSON ללוח.';

  @override
  String get copiedToClipboard => 'הועתק ללוח.';

  @override
  String get imported => 'יובא.';

  @override
  String get boardImage => 'תמונת לוח';

  @override
  String get autumnLeaves => 'עלים של סתיו';

  @override
  String get legendaryLand => 'ארץ אגדות';

  @override
  String get vignetteEffect => 'אפקט ויגנט';

  @override
  String get promptMakeToolbarTransparent =>
      'אתה רוצה להפוך את סרגל הכלים לשקוף לחלוטין כאשר תמונת רקע ללוח מוגדרת?';

  @override
  String get vibration => 'הפעל רטט במשחק';

  @override
  String get soundTheme => 'ערכת צלילים';

  @override
  String get ball => 'כדור';

  @override
  String get liquid => 'נוזל';

  @override
  String get wood => 'עץ';

  @override
  String get placeEffectAnimation => 'אפקט אנימציה של הנחת כלי';

  @override
  String get removeEffectAnimation => 'אפקט אנימציה של הסרת כלי';

  @override
  String get isToolbarAtBottom => 'הצג את סרגל הכלים בתחתית';

  @override
  String get boardCornerRadius => 'רדיוס פינת הלוח';

  @override
  String get useOpeningBook => 'השתמש בספר פתיחה';

  @override
  String get currentRule => 'נוכחי';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'דוז';

  @override
  String get chamGonu => 'צ\'אמגונו';

  @override
  String get zhiQi => 'ג\'יצ\'י';

  @override
  String get chengSanQi => 'צ\'נסאנצ\'י';

  @override
  String get mulMulan => 'מול-מולאן';

  @override
  String get nerenchi => 'נרנצ\'י';

  @override
  String get ruleSet => 'קבוצת כללים';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'טחנת זמן אחד';

  @override
  String get daSanQi => 'דאסאנצ\'י';

  @override
  String get useOpeningBook_Detail =>
      'אפשר לבינה המלאכותית להשתמש במהלכי פתיחה שמקובלים על ידי שחקנים מקצועיים בשלב המוקדם של המשחק. הערה: תכונה זו זמינה כעת רק עבור ערכות חוקים מסוימות.';

  @override
  String get showAdvantageGraph => 'הצג גרף יתרון';

  @override
  String get advantageGraphHint =>
      'הגרף המציג יתרון יצויר רק לאחר שהבינה המלאכותית מבצעת מהלך. הוא לא יצויר כאשר השחקן האנושי מבצע מהלך.';

  @override
  String get removalBasedOnMillCounts =>
      'השבת הסרת חלקים עד שכל החלקים ימוקמו. השחקנים מסירים חלקים בהתאם למספר המטחנות שנוצרו.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'השבת הסרת חלקים עד שכל החלקים ימוקמו. השחקנים מסירים חלקים בהתאם למספר המטחנות: אם המספר שווה, שניהם מסירים אותה כמות חלקים; אם לאחד יש יותר, הוא מסיר חלק נוסף ובכך שומר על הפרש של חלק אחד. אם רק אחד יוצר מטחנה, הוא מסיר שני חלקים, בעוד השני מסיר חלק אחד. אם אף אחד לא יוצר מטחנה, שניהם מסירים חלק אחד כל אחד.';

  @override
  String get elfilja => 'אל פילג’ה';

  @override
  String get tipSelectOwnPiece => 'בחר באחד מהחיילים שלך.';

  @override
  String get notYourTurn => 'לא תורך.';

  @override
  String get annotationToolbarBackgroundColor => 'צבע רקע של סרגל ההערות';

  @override
  String get annotationToolbarIconColor => 'צבע אייקון של סרגל ההערות';

  @override
  String get isAnnotationToolbarShown => 'הצג סרגל הערות';

  @override
  String get enterAnnotationMode => 'היכנס למצב הערות';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'האם אתה בטוח שברצונך למחוק את כל ההערות?';

  @override
  String get llmPromptCopiedToClipboard => 'הנחיית LLM הועתקה ללוח.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'החיבור נדחה, ייתכן שהשרת מושבת.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'הגילוי הצליח, ממתין לחיבור...';

  @override
  String get noLanConnection => 'אין חיבור LAN';

  @override
  String get takeScreenshot => 'צלם מסך';

  @override
  String get disconnectedFromOpponent => 'מנותק מהיריב.';

  @override
  String get takeBackRequest => 'בקשת חזרה';

  @override
  String get nothingToShow => 'אין מה להציג.';

  @override
  String get stopHosting => 'הפסק לארח';

  @override
  String get connectionResetByPeer => 'החיבור אופס על ידי העמית.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'החיבור אבד עקב פסק זמן של פעימות לב. אנא התחבר מחדש.';

  @override
  String get startHosting => 'התחל לארח';

  @override
  String get restartRequestRejected => 'בקשת אתחול נדחתה.';

  @override
  String get notConnectedToLanOpponent => 'לא מחובר ליריב ב-LAN.';

  @override
  String get llmPrompt => 'הנחיית LLM';

  @override
  String get gameRestarted => 'המשחק הופעל מחדש.';

  @override
  String get takeBackRejected => 'החזרה נדחתה.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'האם אתה בטוח שברצונך לוותר על המשחק הזה?';

  @override
  String get opponentResignedYouWin => 'היריב ויתר. ניצחת!';

  @override
  String get clearAllAnnotations => 'מחק את כל ההערות';

  @override
  String get connectedWaitingForOpponentSMove =>
      'מחובר, ממתין למהלך של היריב...';

  @override
  String get networkStatusDisconnected => 'מצב רשת: מנותק';

  @override
  String get takeBackRequestSentToTheOpponent => 'בקשת חזרה נשלחה ליריב.';

  @override
  String get theOpponentMayHaveLeftTheGame => 'ייתכן שהיריב עזב את המשחק';

  @override
  String get connectedToHostSuccessfully => 'התחברות למארח בהצלחה.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'החיבור אבד: פסק זמן של פעימות לב';

  @override
  String get noHostDiscovered => 'לא נמצא מארח.';

  @override
  String get confirmResignation => 'אשר ויתור';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'התחלת אירוח משחק, ממתין לשחקנים שיצטרפו...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'פסק זמן בחיבור, חיבור הרשת אינו יציב.';

  @override
  String get noLlmPromptAvailable => 'אין הנחיית LLM זמינה.';

  @override
  String get youResignedGameOver => 'ויתרת. המשחק נגמר.';

  @override
  String get serverIp => 'כתובת IP של השרת';

  @override
  String get confirmClear => 'אשר מחיקה';

  @override
  String get opponentSTurn => 'תור היריב.';

  @override
  String get waitingAClientConnection => 'ממתין לחיבור לקוח...';

  @override
  String get takeBackRequestWasRejectedOrFailed => 'בקשת החזרה נדחתה או נכשלה.';

  @override
  String get addText => 'הוסף טקסט';

  @override
  String get exitAnnotationMode => 'צא ממצב הערות';

  @override
  String get typeYourAnnotation => 'הקלד את ההערה שלך';

  @override
  String get attemptingToReconnect => 'מנסה להתחבר מחדש...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'בקשת אתחול נשלחה. ממתין לתגובת היריב...';

  @override
  String get serverIsStopped => 'השרת מושבת.';

  @override
  String get restartRequest => 'בקשת אתחול';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'לא ניתן לבקש חזרה כשזה לא תורך.';

  @override
  String get takeBackAccepted => 'החזרה התקבלה.';

  @override
  String get localNetworkSettings => 'הגדרות רשת מקומית';

  @override
  String get reconnectedSuccessfully => 'התחברות מחדש הצליחה!';

  @override
  String get failedToSaveImageToGallery => 'שמירת התמונה לגלריה נכשלה.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'היריב ביקש לאתחל את המשחק. האם אתה מסכים?';

  @override
  String get yourTurn => 'תורך.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'לא ניתן להתחבר מחדש, אנא אתחל את המשחק.';

  @override
  String get host => 'מארח';

  @override
  String get join => 'הצטרף';

  @override
  String get port => 'פורט';

  @override
  String get invalidIpAddress => 'כתובת IP לא חוקית.';

  @override
  String get invalidPort => 'פורט לא חוקי.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'מתחבר: ניסיון $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'החיבור נכשל: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'התחלת האירוח נכשלה: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'מארח נמצא: $ip:$port';
  }

  @override
  String get stop => 'עצור';

  @override
  String get discover => 'גלה';

  @override
  String get connect => 'התחבר';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'לקוח מחובר: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'מגלה: $seconds שניות';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'מתחבר מחדש ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'מחובר';

  @override
  String get delete => 'מחק';

  @override
  String get ancientEgypt => 'מצרים העתיקה';

  @override
  String get gothicIce => 'קרח גותי';

  @override
  String get riceField => 'שדה אורז';

  @override
  String get chinesePorcelain => 'פורצלן סיני';

  @override
  String get desertDusk => 'דמדומי המדבר';

  @override
  String get precisionCraft => 'מלאכת דיוק';

  @override
  String get folkEmbroidery => 'רקמה עממית';

  @override
  String get carpathianHeritage => 'מורשת הקרפטים';

  @override
  String get imperialGrandeur => 'פאר אימפריאלי';

  @override
  String get bohemianCrystal => 'קריסטל בוהמי';

  @override
  String get savannaSunrise => 'זריחת הסוואנה';

  @override
  String get harmonyBalance => 'הרמוניה ואיזון';

  @override
  String get cinnamonSpice => 'תבלין קינמון';

  @override
  String get anatolianMosaic => 'פסיפס אנטולי';

  @override
  String get carnivalSpirit => 'רוח הקרנבל';

  @override
  String get custom => 'המותאם אישית';

  @override
  String get spiceMarket => 'שוק התבלינים';

  @override
  String get swipeToRevealTheDrawer => 'החלק כדי לחשוף את המגירה';

  @override
  String get showGameInfoOnScreenshots => 'הצג מידע על המשחק בצילומי מסך';

  @override
  String get humanMoveTime => 'מגבלת זמן אנושית';

  @override
  String get noTimeLimitForHumanMoves => 'אין מגבלת זמן למהלכים אנושיים';

  @override
  String get timeoutLoseWillBeApplied => 'הפסד עקב פסק זמן יחול על שחקן אנושי';

  @override
  String get identifyingBoard => 'מזהה את הלוח…';

  @override
  String get youCanEnterAnyModelName => 'ניתן להזין כל שם של מודל.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'מיקום הלוח יושם. FEN הועתק ללוח.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'הצעה: נסה לצלם תמונה ברורה יותר של הלוח.';

  @override
  String get llmPromptTemplate => 'תבנית פרומפט ל-LLM';

  @override
  String get noValidBoardDetected => 'לא אותר לוח תקין.';

  @override
  String get selectingImageFromAlbum => 'מבחר תמונה מאלבום…';

  @override
  String get configurePromptTemplate => 'הגדר תבנית פרומפט';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'ערוך את תבנית הפרומפט לניתוח ע\"י LLM';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'נכשלה יצירת FEN מהלוח שזוהה.';

  @override
  String get outputInCurrentLanguage => 'הצג בשפה הנוכחית';

  @override
  String get commonBaseUrls => 'כתובות Base URL נפוצות';

  @override
  String get viewCommonModels => 'צפייה במודלים נפוצים';

  @override
  String get recognitionParametersUpdated => 'פרמטרי הזיהוי עודכנו.';

  @override
  String get whiteSMove => 'מהלך הלבן';

  @override
  String get resetToDefaults => 'שחזר לברירת מחדל';

  @override
  String get photoShoot => 'צילום';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'נכשל ביישום מיקום הלוח שזוהה.';

  @override
  String get llmPromptContent => 'תוכן פרומפט LLM';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM לא מוגדר. אנא בדוק את ההגדרות שלך.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'הגדר ספק, מודל, API Key ו-Base URL';

  @override
  String get llmConfiguration => 'הגדרות LLM';

  @override
  String get configureLlmProvider => 'הגדר ספק LLM';

  @override
  String get llmPromptTemplateHeader => 'כותרת עליונה של תבנית הפרומפט ל-LLM';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'לא זוהו כלי משחק בתמונה. אנא נסה שוב.';

  @override
  String get recognizeBoardFromImage => 'זהה לוח מהתמונה';

  @override
  String get viewTips => 'הצג טיפים';

  @override
  String get applyToBoard => 'החל על הלוח';

  @override
  String get adjustBoardArea => 'התאם את אזור הלוח';

  @override
  String get viewCommonUrls => 'הצג כתובות URL נפוצות';

  @override
  String get colorAnalysisFailed => 'הניתוח הצבעוני נכשל!';

  @override
  String get analyzingGameBoardImage => 'מנתח את תמונת לוח המשחק…';

  @override
  String get selectFromAlbum => 'בחר מאלבום';

  @override
  String get noBoardPointDetected => 'לא זוהה נקודה בלוח!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'אם תשאיר ריק, תשתמש תבנית ברירת המחדל';

  @override
  String get llmConfig => 'תצורת LLM';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'האם אתה בטוח שברצונך לאפס את תבניות הפרומפט לברירות המחדל?';

  @override
  String get llmPromptTemplateFooter => 'כותרת תחתונה של תבנית הפרומפט ל-LLM';

  @override
  String get loadingResponse => 'טוען תשובה…';

  @override
  String get applyThisResultToBoard => 'החל תוצאה זו על הלוח';

  @override
  String get takingPicture => 'לוקח תמונה…';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'אנא בחר תמונת לוח משחק לזיהוי';

  @override
  String get identificationResults => 'תוצאות הזיהוי';

  @override
  String get analyzeTheMovesAndProvideInsights => 'נתח את המהלכים וספק תובנות.';

  @override
  String get getApiKey => 'קבל API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'תהליך ההזיהוי כולו נכשל להשלמה.';

  @override
  String get boardRecognitionResult => 'תוצאות הזיהוי של הלוח';

  @override
  String get askLlm => 'שאל את LLM';

  @override
  String get boardDetectionFailed => 'זיהוי הלוח נכשל!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'לא זוהתה נקודה בלוח, לא ניתן לזהות את הכלי!';

  @override
  String get copyFen => 'העתק FEN';

  @override
  String get commonlyUsedModels => 'מודלים בשימוש נפוץ';

  @override
  String get apiKeyOptional => 'API Key (אופציונלי)';

  @override
  String get noImageSelected => 'לא נבחרה תמונה';

  @override
  String get blackSMove => 'מהלך השחור';

  @override
  String get llm => 'מודל שפה גדול';

  @override
  String get llmProvider => 'ספק';

  @override
  String get baseUrl => 'כתובת בסיס';

  @override
  String get model => 'מודל';

  @override
  String get temperature => 'טמפרטורה';

  @override
  String get llmCommandReceivedProcessing =>
      'הפקודה התקבלה! הבינה המלאכותית מעבדת...';

  @override
  String get llmDeepThinkingWait => 'חשיבה מעמיקה בעיצומה, אנא המתן...';

  @override
  String get llmPresentingSoon => 'יידווח בקרוב...';

  @override
  String get recognitionParameters => 'פרמטרי זיהוי';

  @override
  String get adjustParamsDesc => 'התאם את הפרמטרים כדי לשפר את דיוק הזיהוי';

  @override
  String get saveParameters => 'שמור פרמטרים';

  @override
  String unableToStartImageRecognition(String error) {
    return 'לא ניתן להתחיל זיהוי תמונה: ‎$error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'זיהוי התמונה נכשל: ‎$error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'הוחלה עמדה עם ‎$whiteCount אבנים לבנות ו‑$blackCount אבנים שחורות';
  }

  @override
  String get fenCopiedToClipboard => '(‏FEN הועתק ללוח)';

  @override
  String recognitionFailed(String error) {
    return 'הזיהוי נכשל: ‎$error';
  }

  @override
  String get myRating => 'הדירוג שלי';

  @override
  String get gamesPlayed => 'משחקים ששוחקו';

  @override
  String get wins => 'ניצחונות';

  @override
  String get losses => 'הפסדים';

  @override
  String get draws => 'תיקו';

  @override
  String get lastUpdated => 'עודכן לאחרונה';

  @override
  String get format => 'פורמט:';

  @override
  String get resetStatistics => 'איפוס סטטיסטיקות';

  @override
  String get drawRate => 'שיעור תיקו';

  @override
  String get lossRate => 'שיעור הפסדים';

  @override
  String get aiStatistics => 'סטטיסטיקות AI';

  @override
  String get enableStatistics => 'הפעל סטטיסטיקות';

  @override
  String get enableStatistics_Detail =>
      'כאשר מופעל, תוצאות המשחק יתועדו בסטטיסטיקה. עם זאת, משחקים הכוללים החזרת מהלכים לא יתועדו. כאשר מושבת, איסוף הסטטיסטיקות מושהה.';

  @override
  String get thisWillResetAllGameStatistics =>
      'פעולה זו תאפס את כל סטטיסטיקות המשחק. לא ניתן לבטל פעולה זו.';

  @override
  String get boardInnerRingSize => 'גודל הטבעת הפנימית של הלוח';

  @override
  String get boardShadowEnabled => 'צל הלוח';

  @override
  String get trapAwareness => 'זיהוי מלכודות';

  @override
  String get trapAwarenessDescription =>
      'הדגש מהלכי מלכודת בעזרת עיגולים וחצים מודגשים במהלך הניתוח.';

  @override
  String trapExists(String trapMoves) {
    return 'קיימת מלכודת. מהלכי מלכודת: $trapMoves';
  }

  @override
  String get custodianCapture => 'לכידת צנרת';

  @override
  String get custodianCaptureDescription =>
      'סגר את אחד מחתיכות היריב שלך בין שניים משלך בקו ישר כדי לתפוס אותו.';

  @override
  String get custodianCaptureEnable => 'אפשר לכידת אגרוף';

  @override
  String get interventionCapture => 'לכידת התערבות';

  @override
  String get interventionCaptureDescription =>
      'לעבור לנקודה הריקה בין שניים מקטעי היריב שלך כדי לתפוס את שניהם.';

  @override
  String get interventionCaptureEnable => 'אפשר לכידת התערבות';

  @override
  String get leapCapture => 'לכידת קפיצה';

  @override
  String get leapCaptureDescription =>
      'לכידת על ידי קפיצה מעל חתיכתו של יריב סמוך לנקודה הריקה שמעבר.';

  @override
  String get leapCaptureEnable => 'אפשר לכידת קפיצה';

  @override
  String get captureApplicableLines => 'קווים רלוונטיים';

  @override
  String get captureSquareEdges => 'לאורך קצוות הכיכר';

  @override
  String get captureCrossLines => 'לאורך קווים אורתוגונליים החוצים את הכיכר';

  @override
  String get captureDiagonalLines => 'לאורך קווים אלכסוניים חוצים את הכיכר';

  @override
  String get captureExecutionPhases => 'שלבי ביצוע';

  @override
  String get capturePiecesCondition =>
      'זמינות בשלב ההנעה על בסיס חתיכות הנותרים';

  @override
  String get capturePiecesConditionUnlimited => 'אין הגבלה';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'זמין כשיש לך שלוש חתיכות או פחות';
}
