// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Gujarati (`gu`).
class SGu extends S {
  SGu([String locale = 'gu']) : super(locale);

  @override
  String get appName => 'નવ કાકરી';

  @override
  String get welcome => 'સ્વાગત છે';

  @override
  String get yes => 'હા';

  @override
  String get no => 'ના';

  @override
  String get game => 'રમત';

  @override
  String get humanVsAi => 'માનવ વિ એ';

  @override
  String get humanVsHuman => 'માનવ વિ માનવ';

  @override
  String get aiVsAi => 'એઆઈ વિ એઆઈ';

  @override
  String get humanVsCloud => 'માનવ વિ મેઘ';

  @override
  String get humanVsLAN => 'હ્યુમન વિ લ LANન';

  @override
  String get testViaLAN => 'LAN દ્વારા પરીક્ષણ કરો';

  @override
  String get move => 'ચાલ';

  @override
  String get showMoveList => 'સૂચિ ખસેડો';

  @override
  String get moveList => 'સૂચિ ખસેડો';

  @override
  String get noGameRecord => 'કોઈ રેકોર્ડ નથી';

  @override
  String get ok => 'બરાબર';

  @override
  String get confirm => 'પુષ્ટિ કરો';

  @override
  String get cancel => 'રદ કરો';

  @override
  String get tipSelectWrong => 'ખોટો ટુકડો પસંદ થયો.';

  @override
  String get tipPlace => 'ટુકડાઓ મૂકી.';

  @override
  String get tipBanPlace => 'અહીં મૂકી શકાતું નથી.';

  @override
  String get tipPlaced => 'મૂકી દીધું.';

  @override
  String get tipRemove => 'એક ટુકડો દૂર કરો.';

  @override
  String get tipBanRemove => 'દૂર કરવામાં આવી શકતું નથી.';

  @override
  String get tipRemoved => 'દૂર કરવામાં આવ્યું.';

  @override
  String get tipMove => 'એક ભાગ ખસેડો.';

  @override
  String get tipCannotPlace => 'અહીં ટુકડો મૂકી શકાતો નથી.';

  @override
  String get tipCannotMove => 'અહીં ટુકડો ખસેડી શકાતો નથી.';

  @override
  String get tipMill => 'મિલ! વિરોધીના ટુકડો દૂર કરો.';

  @override
  String get tipContinueMill => 'વિરોધીના ટુકડો લઈવાનું ચાલુ રાખો.';

  @override
  String get tipSelectOpponentsPiece => 'વિરોધીના ટુકડાઓમાંથી એક પસંદ કરો.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'મિલમાંથી ટુકડો દૂર કરી શકાતો નથી.';

  @override
  String get tipCanMoveOnePoint => 'એક ભાગ 1 પોઇન્ટ ખસેડી શકે છે.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'તમે તમારા વિરોધીના ટુકડાઓ ખસેડી શકતા નથી.';

  @override
  String get tipSelectPieceToMove => 'ખસેડવા માટે તમારા ભાગને પસંદ કરો.';

  @override
  String get tipHaveThreePiecesLeft => 'ત્રણ ટુકડાઓ બાકી.';

  @override
  String get tipCanMoveToAnyPoint => 'ગમે તે બિંદુ પર જઈ શકાય છે.';

  @override
  String tipToMove(Object player) {
    return '$player ખસેડવા માટે.';
  }

  @override
  String get whiteWin => 'પ્લેયર 1 જીતે!';

  @override
  String get blackWin => 'ખેલાડી 2 જીત્યો!';

  @override
  String get won => 'જીત્યો';

  @override
  String get lost => 'હાર્યો';

  @override
  String get thinking => 'વિચારી રહ્યું છે…';

  @override
  String get newGame => 'નવી રમત';

  @override
  String get importGame => 'આયાત રમત';

  @override
  String get exportGame => 'રમત નિકાસ કરો';

  @override
  String get gameImported => 'રમત આયાત કરવામાં આવી.';

  @override
  String cannotImport(Object invalidMove) {
    return '$invalidMove આયાત કરી શકાતી નથી.';
  }

  @override
  String get movesAndRulesNotMatch => 'ચાલ અને નિયમો મેળ ખાતા નથી.';

  @override
  String get pleaseWait => 'મહેરબાની કરી રાહ જુવો.';

  @override
  String get restartGame => 'વર્તમાન રમતને ફરીથી પ્રારંભ કરો?';

  @override
  String get restart => 'ફરી થી શરૂ કરવું';

  @override
  String get gameStarted => 'રમત શરૂ થઈ, કૃપા કરીને મૂકો.';

  @override
  String get analyzing => 'વિશ્લેષણ કરી રહ્યું છે…';

  @override
  String error(Object message) {
    return 'ભૂલ: $message';
  }

  @override
  String get winRate => 'વિન રેટ';

  @override
  String get score => 'સ્કોર:';

  @override
  String get white => 'ખેલાડી 1';

  @override
  String get black => 'ખેલાડી 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player પાસે ત્રણ કરતાં ઓછી સંખ્યામાં ટુકડાઓ.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player રાજીનામું.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player માટે આગળ વધવાની કોઈ રીત નથી.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'બોર્ડ ભરાઈ ગયું છે, $player માટે આગળ વધવાની કોઈ રીત નથી.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'સમય પૂરો, $player હારી ગયો.';
  }

  @override
  String get drawReasonRule50 =>
      'ચાલતા તબક્કામાં, ચાલની છેલ્લી વિશિષ્ટ સંખ્યામાં કોઈ ભાગ કા pieceી નાખ્યો નથી.';

  @override
  String get drawReasonBoardIsFull => 'તે ડ્રો છે કારણ કે બોર્ડ ભરેલું છે.';

  @override
  String get drawReasonThreefoldRepetition =>
      'તે ત્રિકોણ પુનરાવર્તનને કારણે દોરો છે.';

  @override
  String get gameOverUnknownReason => 'ખેલ ખતમ! અજ્ઞાત કારણ.';

  @override
  String get gameOver => 'ખેલ ખતમ';

  @override
  String get youWin => 'તમે જીતી ગયા! અભિનંદન!';

  @override
  String challengeHarderLevel(int level) {
    return 'કઠણ સ્તરને પડકારો? નવું સ્તર લેવલ $level હશે!';
  }

  @override
  String get youLose => 'હારી ગયા!';

  @override
  String get analyze => 'વિશ્લેષણ કરો';

  @override
  String get about => 'વિશે';

  @override
  String version(Object versionNumber) {
    return 'સંસ્કરણ: $versionNumber';
  }

  @override
  String get thanks => 'આભાર';

  @override
  String get settings => 'સેટિંગ્સ';

  @override
  String get options => 'વિકલ્પો';

  @override
  String get generalSettings => 'સામાન્ય સુયોજનો';

  @override
  String get skillLevel => 'મુશ્કેલી સ્તર';

  @override
  String get moveTime => 'એઆઈ વિચારવાનો સમય';

  @override
  String get difficulty => 'મુશ્કેલી';

  @override
  String get playSounds => 'ધ્વનિ અસરો';

  @override
  String get playSoundsInTheGame => 'રમતમાં અવાજો ચલાવો';

  @override
  String get keepMuteWhenTakingBack => 'પાછા લેતી વખતે મ્યૂટ રાખો';

  @override
  String get tone => 'સ્વર';

  @override
  String get whoMovesFirst => 'પ્રથમ ચાલ';

  @override
  String get human => 'માનવ';

  @override
  String get ai => 'એઆઈ';

  @override
  String get alternate => 'વૈકલ્પિક';

  @override
  String get isAutoRestart =>
      'જ્યારે રમત સમાપ્ત થાય ત્યારે રમતને ફરીથી પ્રારંભ કરો';

  @override
  String get isAutoChangeFirstMove => 'ઓટો ચેન્જ ફર્સ્ટ મૂવ';

  @override
  String get shufflingEnabled => 'રેન્ડમ ચાલ';

  @override
  String get misc => 'પરચુરણ';

  @override
  String get rules => 'નિયમો';

  @override
  String get piecesCount => 'દરેક ખેલાડીના ટુકડાઓની સંખ્યા';

  @override
  String get piecesCount_Detail => 'દરેક ખેલાડીના કેટલા ટુકડાઓ છે?';

  @override
  String get flyPieceCount => 'ઉડતી ભાગની સંખ્યા';

  @override
  String get flyPieceCount_Detail =>
      'જો ફ્લાઇંગ સક્ષમ કરવામાં આવે છે, જ્યારે કોઈ ખેલાડીને કોઈ વિશિષ્ટ ભાગની ગણતરી કરવામાં આવે છે, ત્યારે તેના ટુકડાઓ બાકીની રમતની જેમ અડીને આવેલા બિંદુઓ સુધી મર્યાદિત રહેવાને બદલે કોઈપણ અનકiedપિડ પોઇન્ટ પર જવા માટે મુક્ત છે.';

  @override
  String get piecesAtLeastCount => 'ઓછામાં ઓછા ટુકડાઓ';

  @override
  String get hasDiagonalLines => 'કર્ણ રેખાઓ';

  @override
  String get hasDiagonalLines_Detail => 'બોર્ડમાં ચાર કર્ણ રેખાઓ ઉમેરો.';

  @override
  String get isDefenderMoveFirst => 'બીજો ખેલાડી પહેલા આગળ વધે છે';

  @override
  String get isDefenderMoveFirst_Detail =>
      'પ્લેસિંગ જે પ્લેસિંગ તબક્કામાં બીજા સ્થાને આવે છે તે ચાલતા તબક્કામાં પહેલા ફરે છે.';

  @override
  String get mayRemoveMultiple => 'બહુ-દૂર કરો';

  @override
  String get mayRemoveMultiple_Detail =>
      'જો કોઈ ખેલાડી એક સાથે એક મિલ કરતાં વધુ બંધ કરે છે, તો તેણી બંધ કરેલી મિલોની સંખ્યા દૂર કરશે.';

  @override
  String get mayRemoveFromMillsAlways => 'મિલોનો નાશ કરો';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'ડિફ defaultલ્ટ રૂપે, રચાયેલી મિલમાંથી કોઈ ભાગ કા removingતા પહેલા ખેલાડીઓએ પહેલા કોઈપણ અન્ય ટુકડાઓ કા mustવા જ જોઈએ. મર્યાદાને અક્ષમ કરવા માટે આ વિકલ્પને સક્ષમ કરો.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'જ્યારે બોર્ડ ભરાતું હોય ત્યારે બીજો ખેલાડી ગુમાવે છે';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'જ્યારે બોર્ડ પ્લેસિંગના તબક્કે પૂર્ણ થાય છે, ત્યારે બાજુ જે રમતને પહેરે છે તે રમતને ગુમાવે છે. નહિંતર, રમત ડ્રો છે.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'કોઈ કાનૂની ચાલ નહીં ત્યારે ગુમાવો';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'ખેલાડી હારી જશે જો તેના વિરોધી તેમને અવરોધિત કરે છે જેથી તેઓ ખસેડી ન શકાય. જો આ વિકલ્પ અક્ષમ હોય તો ખસેડવા માટે બાજુ બદલો.';

  @override
  String get mayFly => 'ઉડતી';

  @override
  String get mayFly_Detail =>
      'જો કોઈ ખેલાડી પાસે ફક્ત ત્રણ કે ચાર (રૂપરેખાંકિત) ટુકડાઓ બાકી હોય, તો તે ભાગને કોઈપણ મુક્ત સ્થાને ખસેડી શકે છે.';

  @override
  String get nMoveRule => 'એન-મૂવ નિયમ';

  @override
  String get nMoveRule_Detail =>
      'આ રમત દોરવામાં આવે છે જો દરેક ખેલાડી દ્વારા વિશિષ્ટ સંખ્યામાં ચાલમાં કોઈ દૂર કરવામાં આવ્યું નથી.';

  @override
  String get rollback => 'રોલબેક';

  @override
  String get pleaseSelect => 'કૃપા કરી પસંદ કરો';

  @override
  String get copy => 'નકલ કરો';

  @override
  String get moveHistoryCopied =>
      'ક્લિપબોર્ડ પર ક historyપિ કરેલો ઇતિહાસ ખસેડો.';

  @override
  String get help => 'સહાય કરો';

  @override
  String get feedback => 'પ્રતિસાદ';

  @override
  String get exit => 'બહાર નીકળો';

  @override
  String get ruleSettings => 'નિયમ સેટિંગ્સ';

  @override
  String get color => 'રંગ';

  @override
  String get boardColor => 'બોર્ડનો રંગ';

  @override
  String get pieceColor => 'પીસ રંગ';

  @override
  String get backgroundColor => 'પૃષ્ઠભૂમિ રંગ';

  @override
  String get lineColor => 'બોર્ડ લાઇન રંગ';

  @override
  String get whitePieceColor => 'પ્લેયર 1 પીસ રંગ';

  @override
  String get blackPieceColor => 'પ્લેયર 2 પીસ રંગ';

  @override
  String get messageColor => 'સંદેશનો રંગ';

  @override
  String get isPieceCountInHandShown => 'હાથમાં ટુકડાઓ ગણતરી બતાવો';

  @override
  String get isNotationsShown => 'બોર્ડ પર સૂચનો બતાવો';

  @override
  String get isHistoryNavigationToolbarShown => 'ઇતિહાસ સંશોધક ટૂલબાર બતાવો';

  @override
  String get display => 'દર્શાવો';

  @override
  String get boardBorderLineWidth => 'બોર્ડર બોર્ડરલાઈનની પહોળાઈ';

  @override
  String get boardInnerLineWidth => 'બોર્ડની આંતરિક લાઇન પહોળાઈ';

  @override
  String get pieceWidth => 'પીસ પહોળાઈ';

  @override
  String get fontSize => 'અક્ષર ની જાડાઈ';

  @override
  String get standardNotation => 'ડબલ્યુએમડી નોટેશન';

  @override
  String get restore => 'પુનઃસ્થાપિત';

  @override
  String get restoreDefaultSettings =>
      'ડિફ defaultલ્ટ સેટિંગ્સને પુનર્સ્થાપિત કરો';

  @override
  String pick(Object element) {
    return 'ચૂંટો $element';
  }

  @override
  String get info => 'માહિતી';

  @override
  String get hint => 'ઈશારો';

  @override
  String get player => 'ખેલાડી';

  @override
  String get player1 => 'ખેલાડી 1';

  @override
  String get player2 => 'ખેલાડી 2';

  @override
  String get howToPlay => 'કેમનું રમવાનું';

  @override
  String get toPlacePiece => 'ભાગ મૂકવા માટે કોઈપણ ઉપલબ્ધ બિંદુ પર ટેપ કરો.';

  @override
  String get toSelectPiece => 'તેને ખસેડવા માટે ટુકડા પર ટેપ કરો.';

  @override
  String get toMovePiece => 'તેને ખસેડવા માટે ભાગથી જોડાયેલા બિંદુ પર ટેપ કરો.';

  @override
  String get toRemovePiece => 'દૂર કરવા માટે વિરોધીના એક ટુકડા પર ટેપ કરો.';

  @override
  String get needToCreateMillFirst =>
      'તમે કોઈ ભાગ કા canી શકો તે પહેલાં તમારે પહેલા મિલ બનાવવાની જરૂર છે.';

  @override
  String get needToPlayWithOwnPieces =>
      'તમારે તમારા ટુકડાઓ સાથે રમવાની જરૂર છે.';

  @override
  String get statistics => 'આંકડા';

  @override
  String get totalGames => 'કુલ રમતો';

  @override
  String get results => 'પરિણામો';

  @override
  String get left => 'ડાબી';

  @override
  String get privacyPolicy => 'ગોપનીયતા નીતિ';

  @override
  String get privacyPolicy_Detail_1 =>
      'કૃપા કરીને કાળજીપૂર્વક વાંચો અને ખાતરી કરો કે તમે આને સમજો છો અને તેની સાથે સંમત છો ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. જો તમે આ નીતિથી સંમત નથી, તો કૃપા કરીને આ એપ્લિકેશનનો ઉપયોગ કરશો નહીં. એપ્લિકેશનનો ઉપયોગ સૂચિત કરે છે કે તમે આ શરતો સ્વીકારો છો.';

  @override
  String get and => ' અને ';

  @override
  String get accept => 'સ્વીકારો';

  @override
  String get takeBack => 'પાછા લેવા';

  @override
  String get takingBack => 'પાછા લઈ રહ્યા છે…';

  @override
  String get waiting => 'રાહ જોવી…';

  @override
  String get stepForward => 'આગળ વધવુ';

  @override
  String get takeBackAll => 'બધા પાછા લો';

  @override
  String get stepForwardAll => 'બધા આગળ વધો';

  @override
  String get moveNow => 'હવે ખસેડો';

  @override
  String get done => 'થઈ ગયું.';

  @override
  String get crackMill => 'ક્રેક-મિલ';

  @override
  String get crackMill_Detail =>
      'જો કોઈ ખેલાડીના મિલમાં ફક્ત ટુકડાઓ હોય, તો મિલોના ટુકડાઓ દૂર કરવા માટે લ notક કરવામાં આવશે નહીં.';

  @override
  String get animationDuration => 'એનિમેશન અવધિ';

  @override
  String get none => 'કંઈ નહીં';

  @override
  String get theme => 'થીમ';

  @override
  String get helpContent =>
      'રમતનો હેતુ ત્રણથી ઓછા ટુકડાઓ અથવા કોઈ કાનૂની ચાલ વિના વિરોધીને છોડવાનો છે.\n\nરમત આપોઆપ ખેંચે છે જો કોઈ સ્થિતિ ત્રીજી વખત આવે અથવા છેલ્લા 100 (રૂપરેખાંકિત) ચાલમાં કોઈ દૂર ન કરે.\n\nઆ રમત ત્રણ તબક્કામાં આગળ વધે છે:\n\n1. ખાલી પોઇન્ટ્સ પર ટુકડાઓ મૂકીને\n2. ટુકડાઓ અડીને આવેલા બિંદુઓ પર ખસેડવું\n(. (વૈકલ્પિક તબક્કો) જ્યારે ખાલી ખેલાડીને ત્રણ ટુકડાઓમાં ઘટાડે ત્યારે કોઈપણ ખાલી પોઇન્ટ પર ટુકડાઓ ખસેડવું\n\nમૂકીને\n\nરમત ખાલી બોર્ડથી શરૂ થાય છે, જેમાં ચોવીસ પોઇન્ટ સાથે ગ્રીડનો સમાવેશ થાય છે. ખેલાડીઓ ખાલી પોઇન્ટ પર તેમના ટુકડાઓ મૂકી વળાંક લે છે ત્યાં સુધી દરેક ખેલાડીએ બોર્ડ પર તમામ ટુકડાઓ મૂક્યા ન હોય. જો કોઈ ખેલાડી તેના ત્રણ ટુકડાઓ સીધા મૂકી શકે છે, તો તેની પાસે \"મિલ\" છે અને તે તેના વિરોધીના ટુકડાને બોર્ડમાંથી કા .ી શકે છે.\n\nકેટલાક નિયમોમાં, ખેલાડીઓએ બનેલી મીલમાંથી કોઈ ટુકડો દૂર કરતા પહેલા પહેલા કોઈપણ અન્ય ટુકડાઓ કા removeવા જ જોઇએ.\n\nતમે કેટલાક નિયમોમાં પ્લેસિંગ તબક્કામાં ફરીથી કા piecesેલા ટુકડાઓનાં બિંદુઓ પર ટુકડાઓ મૂકી શકતા નથી.\n\nએકવાર બધા ટુકડાઓનો ઉપયોગ કર્યા પછી, ખેલાડીઓ ફરતા વારા લે છે.\n\nખસેડવું\n\nખસેડવા માટે, એક ખેલાડી તેના એક ટુકડાને બોર્ડ લાઇન સાથે ખાલી અડીને આવેલા સ્થાને લઈ જાય છે. જો તે આમ ન કરી શકે, તો તે રમત હારી ગયો છે. પ્લેસિંગ ફેઝની જેમ, એક પ્લેયર જે તેના ત્રણ ટુકડાઓ બોર્ડ લાઇન પર ગોઠવે છે તેની મિલ હોય છે અને તે તેના વિરોધીના ટુકડાઓમાંથી એક કા removeી શકે છે. કોઈપણ ખેલાડી બે ટુકડાઓ ઘટાડે છે, નવી મિલો બનાવવાનો કોઈ વિકલ્પ નથી, અને આ રીતે તે રમત ગુમાવે છે. જો તેના વિરોધી તેમને ખસેડવામાં અવરોધે છે ત્યારે ત્રણ કરતાં વધુ ટુકડાઓ જ્યારે પણ ખેલાડી ગુમાવી શકે છે.\n\nઉડતી\n\nનિયમોના કેટલાક પ્રકારોમાં, એકવાર જ્યારે ખેલાડી પાસે ફક્ત ત્રણ ટુકડાઓ બાકી હોય, તો તેના ટુકડાઓ ઉડી શકે છે, હોપ કરી શકે છે અથવા કોઈપણ ખાલી બિંદુઓ પર જઇ શકે છે, ફક્ત અડીને જ નહીં.';

  @override
  String get versionInfo => 'સંસ્કરણ માહિતી';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'લાઇસન્સ';

  @override
  String get sourceCode => 'સ્ત્રોત કોડ';

  @override
  String get appVersion => 'એપ્લિકેશન સંસ્કરણ';

  @override
  String get general => 'જનરલ';

  @override
  String get advanced => 'અદ્યતન';

  @override
  String get placing => 'મૂકીને';

  @override
  String get moving => 'ખસેડવું';

  @override
  String get removing => 'દૂર કરી રહ્યું છે';

  @override
  String get gameOverCondition => 'શરત રમત';

  @override
  String get aisPlayStyle => 'એઆઈની પ્લેસ્ટાઇલ';

  @override
  String get passive => 'નિષ્ક્રીય';

  @override
  String get timeout => 'સમયસમાપ્તિ';

  @override
  String get appearance => 'દેખાવ';

  @override
  String get drawOnHumanExperience => 'માનવ અનુભવ દોરો';

  @override
  String get considerMobility => 'ટુકડાઓની ગતિશીલતા ધ્યાનમાં લો';

  @override
  String get pieceCount => 'પીસ ગણતરી:';

  @override
  String inHand(Object player, int count) {
    return '$player હાથમાં: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return 'બોર્ડ પર $player: $count';
  }

  @override
  String get boardTop => 'ટોચ પરથી બોર્ડ ઓફસેટ';

  @override
  String get notAIsTurn => 'એઆઈનો વારો નથી.';

  @override
  String get aiIsNotThinking => 'એઆઈ વિચારી રહ્યો નથી.';

  @override
  String get atEnd => 'તમે ચાલ સૂચિના અંતમાં છો.';

  @override
  String get tapBackAgainToLeave => 'જવા માટે ફરીથી ટેપ કરો.';

  @override
  String get more => 'વધુ';

  @override
  String get experimental => 'તે એક પ્રાયોગિક સુવિધા છે.';

  @override
  String get experiments => 'પ્રયોગો';

  @override
  String get ossLicenses => 'ખુલ્લા સ્રોત લાઇસેંસિસ';

  @override
  String get language => 'ભાષા';

  @override
  String get defaultLanguage => 'ડિફોલ્ટ ભાષા';

  @override
  String get mayMoveInPlacingPhase => 'ટુકડાઓ પ્લેસિંગ તબક્કામાં ખસેડી શકે છે';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'ત્યાં કોઈ વિશિષ્ટ પ્લેસિંગ અને મૂવિંગ તબક્કાઓ નથી, એટલે કે, ખેલાડીઓ દરેક ચાલ પર નિર્ણય લઈ શકે છે કે શું તેઓ બોર્ડ પર કોઈ ભાગ મૂકવા માંગે છે અથવા તેમના ટુકડાઓમાંથી એક ખસેડવા માંગે છે (જ્યાં સુધી તેમની પાસે બાકીના ટુકડાઓ મૂકવા બાકી છે).';

  @override
  String get drawerColor => 'મેનુ રંગ';

  @override
  String get drawerTextColor => 'મેનુ ટેક્સ્ટ રંગ';

  @override
  String get drawerHighlightItemColor => 'મેનુ પ્રકાશિત આઇટમનો રંગ';

  @override
  String get mainToolbarBackgroundColor => 'મુખ્ય ટૂલબાર પૃષ્ઠભૂમિ રંગ';

  @override
  String get mainToolbarIconColor => 'મુખ્ય ટૂલબાર ચિહ્ન રંગ';

  @override
  String get navigationToolbarBackgroundColor =>
      'નેવિગેશન ટૂલબાર પૃષ્ઠભૂમિ રંગ';

  @override
  String get navigationToolbarIconColor => 'નેવિગેશન ટૂલબાર આયકન રંગ';

  @override
  String get autoHideToolbar => 'ટૂલબારને આપમેળે છુપાવો';

  @override
  String get toolbarLocationOnScreen => 'સ્ક્રીન પર ટૂલબાર સ્થાન';

  @override
  String get top => 'ટોચ';

  @override
  String get bottom => 'નીચે';

  @override
  String get center => 'કેન્દ્ર';

  @override
  String get solidColor => 'પાકો રંગ';

  @override
  String get picture => 'ચિત્ર';

  @override
  String get chooseYourPicture => 'તમારું ચિત્ર પસંદ કરો';

  @override
  String get light => 'પ્રકાશ';

  @override
  String get dark => 'શ્યામ';

  @override
  String get themes => 'થીમ્સ';

  @override
  String get currentTheme => 'વર્તમાન થીમ';

  @override
  String get saveTheme => 'થીમ સાચવો';

  @override
  String get showAnalysisGraph => 'વિશ્લેષણ ગ્રાફ બતાવો';

  @override
  String get analysis => 'વિશ્લેષણ';

  @override
  String get saveGame => 'રમત સાચવો';

  @override
  String get loadGame => 'રમત લોડ કરો';

  @override
  String get setupPosition => 'સેટઅપ પોઝિશન';

  @override
  String get showLegalMoves => 'કાનૂની ચાલ બતાવો';

  @override
  String get showLastMove => 'છેલ્લી ચાલ બતાવો';

  @override
  String get showArrows => 'તીર બતાવો';

  @override
  String get pieces => 'ટુકડાઓ';

  @override
  String get showAnalysis => 'વિશ્લેષણ બતાવો';

  @override
  String get threads => 'થ્રેડો';

  @override
  String get getInvolved => 'સામેલ કરો';

  @override
  String get helpImproveTranslate => 'ભાષાંતર સુધારવામાં સહાય કરો';

  @override
  String get tutorial => 'ટ્યુટોરિયલ';

  @override
  String get classicMill => 'ઉત્તમ નમૂનાના મિલ';

  @override
  String get mixedMill => 'મિશ્રિત મિલ';

  @override
  String get ceylonMill => 'સિલોન મિલ';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'મીલ તૂટી શકે છે અને ફરીથી રિમેડ થઈ શકે છે';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'જો કોઈ ખેલાડી તરત જ નવી મિલ બનાવવા માટે મિલ તોડી નાખે છે, તો આવી ખેલાડી જો નવી મિલ બનાવે છે, તો તે આગળની ચાલમાં આવા ભાગને પાછલા મૂળ જંકશન પર ખસેડી શકે છે.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'રમત દોરવામાં આવે છે જો કોઈ ખેલાડી પાસે ત્રણ ટુકડાઓ હોય અને દસ ચાલ પછી કોઈ પણ ખેલાડી વિરોધીના ટુકડાને દૂર કરે નહીં';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'જ્યારે કોઈ ખેલાડી ત્રણ ટુકડાઓ નીચે હોય, અને કોઈ પણ ખેલાડી દસ ચાલની અંદર વિરોધીનો ભાગ કા .ી શકે નહીં, ત્યારે રમત ડ્રો છે.';

  @override
  String get close => 'બંધ';

  @override
  String get whitePiece => 'સફેદ ટુકડો';

  @override
  String get blackPiece => 'કાળો ટુકડો';

  @override
  String get emptyPoint => 'ખાલી બિંદુ';

  @override
  String get noPoint => 'કોઈ મુદ્દો નથી';

  @override
  String get placingPhase => 'મૂકવાનો તબક્કો';

  @override
  String get movingPhase => 'ખસેડવાનો તબક્કો';

  @override
  String get flyingPhase => 'ઉડવાનો તબક્કો';

  @override
  String sideToMove(Object player) {
    return 'ખસેડવા માટે બાજુ: $player';
  }

  @override
  String lastMove(Object move) {
    return 'છેલ્લી ચાલ: $move';
  }

  @override
  String get selected => 'પસંદ કરેલ';

  @override
  String get accessibility => 'ઉપલ્બધતા';

  @override
  String get screenReaderSupport => 'સ્ક્રીન રીડર સપોર્ટ';

  @override
  String get isDraw => 'તે એક ડ્રો છે!';

  @override
  String get draw => 'દોરો';

  @override
  String get pieceHighlightColor => 'પીસ હાઇલાઇટ કલર';

  @override
  String get algorithm => 'અલ્ગોરિધમ';

  @override
  String get endgameNMoveRule => 'એન્ડગેમ એન-મૂવ નિયમ';

  @override
  String get endgameNMoveRule_Detail =>
      'જો કોઈ પણ ખેલાડી પાસે માત્ર ત્રણ ટુકડા હોય અને કોઈ પણ ખેલાડી કોઈ ચોક્કસ ચાલની અંદર એક ટુકડો કાી નાંખે તો રમત દોરવામાં આવે છે.';

  @override
  String get drawReasonEndgameRule50 =>
      'ક્યાં તો ખેલાડી પાસે માત્ર ત્રણ ટુકડાઓ હોય છે અને ન તો ખેલાડી ચોક્કસ ચાલની અંદર એક ભાગને દૂર કરે છે.';

  @override
  String get threefoldRepetitionRule => 'ત્રણ ગણો પુનરાવર્તન નિયમ';

  @override
  String get threefoldRepetitionRule_Detail =>
      'જો ત્રીજી વખત પોઝિશન આવે તો રમત ડ્રો થાય છે.';

  @override
  String get continueToMakeMove => 'મિલ! ચાલ ચાલુ રાખો.';

  @override
  String get pointStyle => 'પોઇન્ટ શૈલી';

  @override
  String get pointWidth => 'પોઇન્ટ પહોળાઈ';

  @override
  String get solid => 'ઘન';

  @override
  String get hollow => 'હોલો';

  @override
  String get languageName => 'ગુજરાતી';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ચાલ',
      one: '$count ખસેડો',
      zero: 'ખસેડો',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'લોડ નિષ્ફળ થયું.';

  @override
  String get filename => 'ફાઈલનું નામ';

  @override
  String get browse => 'બ્રાઉઝ કરો…';

  @override
  String get gameFiles => 'રમત ફાઇલો';

  @override
  String get gameSavedTo => 'આ રમત માટે સાચવવામાં આવે છે';

  @override
  String get empty => 'ખાલી';

  @override
  String get noMove => 'કોઈ ચાલ.';

  @override
  String get restoredPosition => 'પુનઃસ્થાપિત પ્રારંભિક સ્થિતિ.';

  @override
  String get clean => 'ચોખ્ખો';

  @override
  String get cleanedUp => 'સ્વચ્છ કરેલ.';

  @override
  String get remove => 'દૂર કરો';

  @override
  String get noPiecesCanBeRemoved => 'કોઈ ટુકડાઓ દૂર કરી શકાતા નથી.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ટુકડા',
      one: '$count piece',
      zero: 'Piece',
    );
    return '$_temp0 દૂર કરવાની જરૂર છે.';
  }

  @override
  String placedCount(int count) {
    return 'મૂકેલ ($count)';
  }

  @override
  String get placedPieceCount =>
      'મૂકવાના તબક્કામાં મૂકવામાં આવેલા ટુકડાઓની ગણતરી.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'વર્તમાન ખેલાડીએ $count ટુકડા મૂક્યા છે.';
  }

  @override
  String get notPlacingPhase => 'તબક્કો મૂકતો નથી, તેને બદલી શકતો નથી.';

  @override
  String get paste => 'પેસ્ટ કરો';

  @override
  String get pasteDone => 'પેસ્ટ થઈ ગઈ છે.';

  @override
  String get cannotPaste => 'પેસ્ટ કરી શકાતું નથી.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'સ્થાનાંતરિત અને દૂર કરેલા ટુકડાઓ બતાવો';

  @override
  String get fullScreen => 'પૂર્ણ - પટ, આખો પડદો';

  @override
  String get reopenToTakeEffect =>
      'સેટિંગ્સને પ્રભાવિત કરવા માટે બહાર નીકળો અને એપ્લિકેશનને ફરીથી ખોલો.';

  @override
  String get forest => 'વન';

  @override
  String get desktopImage => 'ડેસ્કટૉપ છબી';

  @override
  String get invalidPosition => 'અમાન્ય સ્થિતિ.';

  @override
  String get shareGIF => 'GIF શેર કરો';

  @override
  String get pixelRatio => 'પિક્સેલ રેશિયો';

  @override
  String get duration => 'અવધિ';

  @override
  String get gameScreenRecorder => 'ગેમ સ્ક્રીન રેકોર્ડર';

  @override
  String get previous => 'અગાઉના';

  @override
  String get next => 'આગળ';

  @override
  String get skip => 'છોડો';

  @override
  String get gotIt => 'જાણ્યું';

  @override
  String get youCanModifyRules =>
      'તમે નિયમ સેટિંગ્સમાં રમતના નિયમોમાં ફેરફાર કરી શકો છો.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'પીકરમાં મૂલ્ય બદલવા માટે તમે માઉસ વ્હીલનો ઉપયોગ કરી શકો છો.';

  @override
  String get noTimeLimitForThinking =>
      'AI થિંકિંગ ટાઈમ 0 પર સેટ કરેલ છે એટલે વિચારવા માટે કોઈ સમય મર્યાદા નથી.';

  @override
  String get whatIsMtdf =>
      'MTD(f) એ આલ્ફા-બીટા શોધ અલ્ગોરિધમનું સંશોધિત સ્વરૂપ છે જેનો હેતુ મધ્યવર્તી શોધ પરિણામોનો પુનઃઉપયોગ કરીને અને શોધ જગ્યાને સાંકડી કરવા માટે સારા પ્રારંભિક અનુમાનનો ઉપયોગ કરીને કાર્યક્ષમતામાં સુધારો કરવાનો છે.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'કૃપા કરીને ધ્યાન રાખો કે AI વિચારસરણી સમય ગોઠવણ સંપૂર્ણપણે ચોક્કસ ન હોઈ શકે. જ્યારે મુશ્કેલી સ્તર નીચા મૂલ્ય પર સેટ હોય ત્યારે વાસ્તવિક વિચારવાનો સમય ઓછો હોઈ શકે છે અને જ્યારે સમય સમાપ્ત થઈ જાય ત્યારે AI મધ્ય-વિચારમાં હોય ત્યારે તે લાંબો હોઈ શકે છે.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'જો તમે મુશ્કેલી સ્તર ઊંચું સેટ કરો છો પરંતુ AI વિચારવાનો સમય વધારતા નથી, તો વાસ્તવિક મુશ્કેલી સ્તર વિચાર સમયની મર્યાદાને કારણે ઓછા મૂલ્ય સુધી મર્યાદિત હોઈ શકે છે. મશીનની કામગીરીના આધારે વાસ્તવિક મૂલ્ય બદલાઈ શકે છે.';

  @override
  String get whatIsPvs =>
      'PVS (પ્રિન્સિપલ વેરિએશન સર્ચ) એ આપેલ સ્થિતિમાં શ્રેષ્ઠ ચાલ શોધવા માટે એક સર્ચ અલ્ગોરિધમ છે. તે આલ્ફા-બીટા અલ્ગોરિધમનું ઉન્નતીકરણ છે અને મુખ્ય ભિન્નતાથી ચાલતા પહેલાથી સુરક્ષિત સ્કોર કરતાં વધુ ખરાબ અથવા ખરાબ નથી તેની પુષ્ટિ કરવા માટે નલ અથવા ઝીરો વિન્ડો શોધનો ઉપયોગ કરે છે. PVS સૌથી આશાસ્પદ ચાલ પર ધ્યાન કેન્દ્રિત કરે છે અને સબઓપ્ટીમલ શાખાઓની બિનજરૂરી શોધને ટાળે છે, જે શોધની કાર્યક્ષમતામાં સુધારો કરવામાં મદદ કરે છે.';

  @override
  String get whatIsAlphaBeta =>
      'આલ્ફા-બીટા અલ્ગોરિધમ એ શ્રેષ્ઠ ચાલ શોધવા માટે શોધ અલ્ગોરિધમ છે. તે શોધ વૃક્ષને કાપવા અને કાર્યક્ષમતા વધારવા માટે મિનિમેક્સ સિદ્ધાંત અને બે મૂલ્યો, આલ્ફા અને બીટાનો ઉપયોગ કરે છે. આલ્ફા એ ન્યુનત્તમ સ્કોરનું પ્રતિનિધિત્વ કરે છે જે કમ્પ્યુટરને ખાતરી છે કે તે મેળવી શકે છે, જ્યારે બીટા તેના પ્રતિસ્પર્ધીને પ્રાપ્ત કરી શકે તેવા મહત્તમ સ્કોરનું પ્રતિનિધિત્વ કરે છે. એલ્ગોરિધમ કમ્પ્યુટરને રમતમાં સ્માર્ટ, કાર્યક્ષમ નિર્ણયો લેવામાં મદદ કરે છે.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'માનવીય અનુભવ મુજબ, જો તમે જીતવાનો પ્રયત્ન કરશો, તો તમે હારશો. તેના બદલે, તમારા ધ્યેય તરીકે ડ્રોનું લક્ષ્ય રાખો અને રમત ગુમાવવાનું ટાળો. તમારા પ્રતિસ્પર્ધીનું અવલોકન કરો અને ધીમેધીમે તેમને એવી સ્થિતિમાં આકર્ષિત કરો જ્યાં તેઓ ભૂલો કરી શકે. જ્યારે તેઓ નબળાઈ બતાવે છે, ત્યારે તકનો લાભ લો અને જીત માટે હળવાશથી દબાણ કરો. આ રીતે, તમે રમત જીતી શકો છો.';

  @override
  String get firstMoveDetail =>
      'આ રમતમાં, પ્રથમ ખેલાડીની તુલનામાં બીજા ખેલાડી માટે જીતવું સરળ છે.';

  @override
  String get passiveDetail =>
      'નિષ્ક્રિય વિકલ્પને સક્ષમ કરવાથી AI જ્યારે શક્ય તેટલી ઝડપથી જીતવા માટે આક્રમક રીતે પ્રયાસ કરવાને બદલે જ્યારે તેને સ્થિતિમાં ફાયદો હોય ત્યારે આરામ મળશે.';

  @override
  String get moveRandomlyDetail =>
      'આ વિકલ્પને સક્ષમ કરવાથી રમતની અવ્યવસ્થિતતા અને આનંદ વધે છે જ્યારે તેને અક્ષમ કરવાથી AI ને હરાવવાની રીતોનો અભ્યાસ કરવામાં મદદ મળી શકે છે.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'જો AI તેના ટુકડાઓની ગતિશીલતાને ધ્યાનમાં લે છે, તો તે માત્ર વિરોધીના ટુકડાને શક્ય તેટલી ઝડપથી પકડવાનું લક્ષ્ય રાખશે નહીં, પરંતુ વિરોધીની હિલચાલને અવરોધિત કરવાનું અને તેમને તે જ કરતા અટકાવવાનું પણ વિચારશે.';

  @override
  String get whenBoardIsFull => 'જ્યારે બોર્ડ ભરાઈ જાય છે';

  @override
  String get whenBoardIsFull_Detail =>
      'મૂકવાના તબક્કાના અંતે, મૂવિંગ તબક્કો શરૂ થાય તે પહેલાં, જો બોર્ડ ટુકડાઓથી ભરેલું હોય તો ક્રિયા અનુસરે છે.';

  @override
  String get sideToMoveRemovePiece =>
      'ખેલાડી જે મૂવિંગ તબક્કામાં પ્રથમ જાય છે તે વિરોધીના ટુકડામાંથી એકને દૂર કરે છે.';

  @override
  String get agreeToDraw => 'બંને પક્ષો ડ્રો માટે સંમત છે.';

  @override
  String get takeOpponentsPiece => 'તમારા વિરોધીના ટુકડામાંથી એક લો.';

  @override
  String get firstPlayerLose => 'પ્રથમ ખેલાડી રમત ગુમાવે છે.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'પ્રથમ અને બીજા ખેલાડીઓ વિરોધીના ટુકડામાંથી એકને દૂર કરે છે.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'બીજા અને પ્રથમ ખેલાડીઓ વિરોધીના ટુકડામાંથી એકને દૂર કરે છે.';

  @override
  String get enteredFlyingPhase =>
      'હવે ઉડતા તબક્કામાં પ્રવેશ કર્યો છે, વિરોધીના ટુકડાઓ બોર્ડ પરના કોઈપણ ખાલી બિંદુ પર કૂદી શકે છે. તમે \"નિયમ સેટિંગ્સ\" માં ફ્લાઇંગ નિયમને બંધ કરી શકો છો.';

  @override
  String get whenStalemate => 'જ્યારે મડાગાંઠ';

  @override
  String get whenStalemate_Detail =>
      'જ્યારે કોઈ ભાગ ખસેડી શકાતો નથી ત્યારે કઈ ક્રિયા થાય છે?';

  @override
  String get endWithStalemateLoss => 'મડાગાંઠની ખોટ સાથે અંત.';

  @override
  String get changeSideToMove => 'ખસેડવા માટે બાજુ બદલો.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'વિરોધીના ટુકડામાંથી એકને દૂર કરો અને આગળની ચાલ કરો.';

  @override
  String get endWithStalemateDraw => 'સ્ટેલમેટ ડ્રો સાથે અંત.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'વિરોધીના ટુકડામાંથી એકને દૂર કરો અને ખસેડવા માટે બાજુ બદલો.';

  @override
  String get aiResponseDelayTime => 'AI પ્રતિભાવમાં વિલંબનો સમય';

  @override
  String get aiIsDelaying =>
      'AI હાલમાં વિલંબિત પ્રતિભાવ તબક્કામાં છે. કૃપા કરીને આગળ વધતા પહેલા થોડીવાર રાહ જુઓ.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'તમે અડીને આવેલા ભાગને દૂર કરી શકતા નથી.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'જો મડાગાંઠ હોય, તો મિલની રચનાને ધ્યાનમાં લીધા વિના, તમારી બાજુના વિરોધીના ટુકડાઓ દૂર કરી શકાય છે.';

  @override
  String get whatIsMcts =>
      'MCTS એ શિખાઉ માણસ-મૈત્રીપૂર્ણ અલ્ગોરિધમ છે જે સિમ્યુલેશન દ્વારા વિવિધ ચાલોનું અન્વેષણ અને મૂલ્યાંકન કરીને નિર્ણયો લે છે.';

  @override
  String get goldenJade => 'ગોલ્ડન જેડ';

  @override
  String get forestWood => 'વન વુડ';

  @override
  String get darkMystery => 'ડાર્ક મિસ્ટ્રી';

  @override
  String get midnightBlue => 'મધરાત વાદળી';

  @override
  String get greenForest => 'લીલું વન';

  @override
  String get greenMeadow => 'ગ્રીન મેડોવ';

  @override
  String get stonyPath => 'સ્ટોની પાથ';

  @override
  String get pastelPink => 'પેસ્ટલ પિંક';

  @override
  String get turquoiseSea => 'પીરોજ સમુદ્ર';

  @override
  String get violetDream => 'વાયોલેટ ડ્રીમ';

  @override
  String get mintChocolate => 'મિન્ટ ચોકલેટ';

  @override
  String get skyBlue => 'વાદળી';

  @override
  String get playfulGarden => 'રમતિયાળ ગાર્ડન';

  @override
  String get whatIsRetrogradeAnalysis =>
      'રેટ્રોગ્રેડ એનાલિસિસ એલ્ગોરિધમ વિવિધ સ્ટાર્ટ પોઝિશનમાંથી એન્ડગેમ ડેટાબેઝ બનાવવા માટે બહુ-મૂલ્યવાળું રેટ્રોગ્રેડ એનાલિસિસનો ઉપયોગ કરે છે, પછી ગેમપ્લેને ઑપ્ટિમાઇઝ કરવા માટે આ ડેટાબેઝને લાગુ કરે છે. આ અભિગમ અલ્ટ્રા-સ્ટ્રોંગ સોલ્યુશન્સની શ્રેણીમાં આવે છે.';

  @override
  String get viewAlgorithmGuide =>
      'શું તમે આ અલ્ગોરિધમ માટે વપરાશકર્તા માર્ગદર્શિકા જોવા માંગો છો?';

  @override
  String get showPositionalAdvantageIndicator => 'સ્થિતિકીય લાભ સૂચક બતાવો';

  @override
  String get usePerfectDatabase => 'સંપૂર્ણ ડેટાબેઝનો ઉપયોગ કરો';

  @override
  String get perfectDatabaseDescription =>
      'કટીંગ-એજ એલ્ગોરિધમ્સ દ્વારા જનરેટ થયેલ દોષરહિત ગેમ ડેટાબેઝનો ઉપયોગ કરવા માટે આ વિકલ્પને સક્ષમ કરો. શ્રેષ્ઠ ચાલ સૂચવવા માટે આ સુવિધા ઓપનિંગ અને એન્ડગેમ બંને વ્યૂહરચનાઓને એકીકૃત કરે છે. જે ખેલાડીઓ ગેમપ્લેમાં ઉચ્ચતમ સ્તરની ચોકસાઇ શોધે છે તેમના માટે આ પસંદગીની પસંદગી છે. ઝીણવટભરી કોમ્પ્યુટેશનલ તકનીકો દ્વારા બનાવવામાં આવેલ, ડેટાબેઝ નજીકના-સંપૂર્ણ રમત ઉકેલો પ્રદાન કરવા માટે રચાયેલ છે.\n\nનોંધ: જો AI ડેટાબેઝને ઍક્સેસ કરવામાં નિષ્ફળ જાય, તો તે ગેમપ્લેના નિર્ણયો માટે પરંપરાગત અલ્ગોરિધમ્સ તરફ વળશે. જ્યારે ડેટાબેઝ ઉપલબ્ધ હોય છે, ત્યારે \'મુશ્કેલીનું સ્તર\' વર્ચ્યુઅલ રીતે અજેય બની જાય છે અને \'AI થિંકિંગ ટાઈમ\'માં ભારે ઘટાડો થાય છે. \'AI\'s play style\' વિકલ્પોની અંદર ઘણી સેટિંગ્સ ઓવરરાઇડ કરવામાં આવશે, કારણ કે ડેટાબેઝના પરિણામો સર્વોચ્ચ અગ્રતા ધરાવે છે.\n\nઆ દોષરહિત ડેટાબેઝનો મહત્તમ ઉપયોગ કેવી રીતે કરવો તેના માર્ગદર્શન માટે, અહીં ક્લિક કરો.';

  @override
  String get backgroundImage => 'બેકગ્રાઉન્ડ ઇમેજ';

  @override
  String get whatIsRandom =>
      'જ્યારે \'પરફેક્ટ ડેટાબેઝનો ઉપયોગ કરો\' વિકલ્પ સક્ષમ ન હોય, ત્યારે \'રેન્ડમ\' સેટિંગ એઆઈને મૂવ સિલેક્શન માટે કોઈપણ અલ્ગોરિધમનો ઉપયોગ કર્યા વિના ટુકડાઓને રેન્ડમ રીતે ખસેડવાનું કારણ બને છે. આ સામાન્ય રીતે નોંધપાત્ર રીતે નબળા ગેમપ્લેમાં પરિણમે છે. તેનાથી વિપરિત, જ્યારે \'પરફેક્ટ ડેટાબેઝનો ઉપયોગ કરો\' સક્ષમ હોય છે, ત્યારે AI પરંપરાગત AI અલ્ગોરિધમ્સ સાથે મિશ્રણ કરવાને બદલે, નિર્ણયો લેવા માટે ફક્ત \'પરફેક્ટ ડેટાબેઝ\' પર આધાર રાખે છે. આ મોડમાં, AI ની ચાલ સંપૂર્ણપણે ડેટાબેઝની સામગ્રી પર આધારિત છે, વાસ્તવિક સમયની ગણતરીઓ અથવા શોધ અલ્ગોરિધમ્સ પર નિર્ભરતાને ટાળીને.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'પ્રતિસ્પર્ધીનો ટુકડો(ઓ) તેમના હાથમાંથી દૂર કરો; પછી પ્રતિસ્પર્ધીનો વારો આવે છે.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'સ્થાપન તબક્કામાં મિલ્સ બનાવતી વખતે';

  @override
  String get removeOpponentsPieceFromBoard =>
      'બોર્ડથી પ્રતિસ્પર્ધીનો ટુકડો(ઓ) દૂર કરો.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'બોર્ડથી પ્રતિસ્પર્ધીનો ટુકડો(ઓ) દૂર કરો; પછી પ્રતિસ્પર્ધીનો વારો આવે છે.';

  @override
  String get opponentRemovesOwnPiece =>
      'પ્રતિસ્પર્ધી પોતાનો ટુકડો(ઓ) બોર્ડથી દૂર કરે છે.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'તમારી ક્રિયા લેવાને બદલે, પ્રતિસ્પર્ધી પોતાનો ટુકડો(ઓ) પસંદ કરીને બોર્ડથી દૂર કરે છે, અસરકારક રીતે પોતાની જાતને નુકસાનકારક ક્રિયા લે છે.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'પ્રતિસ્પર્ધીનો ટુકડો(ઓ) તેમના હાથમાંથી દૂર કરો; પછી તમારો વારો આવે છે.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'પ્રતિસ્પર્ધીના હાથમાંથી ટુકડો(ઓ) દૂર કરો. જો Multi-remove સેટિંગ મુજબ, અનેક ટુકડાઓ દૂર કરવાના હોય અને પ્રતિસ્પર્ધીના હાથમાં કોઈ ટુકડાઓ ન હોય, તો બોર્ડથી પ્રતિસ્પર્ધીના ટુકડાઓ ચાલુ રાખો. પછી, તમારો વારો આવે છે. જો તમે ચાલુ રીતે મિલ્સ બનાવતા રહો છો, તો તમે પ્રતિસ્પર્ધીના ટુકડાઓ દૂર કરતા રહી શકો છો.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'પ્રતિસ્પર્ધીના હાથમાંથી ટુકડો(ઓ) દૂર કરો. જો Multi-remove સેટિંગ મુજબ, અનેક ટુકડાઓ દૂર કરવાના હોય અને પ્રતિસ્પર્ધીના હાથમાં કોઈ ટુકડાઓ ન હોય, તો બોર્ડથી પ્રતિસ્પર્ધીના ટુકડાઓ ચાલુ રાખો. પછી, પ્રતિસ્પર્ધીનો વારો આવે છે.';

  @override
  String get markAndDelayRemovingPieces =>
      'ટુકડાઓને ચિહ્નિત કરો અને તેમને દૂર કરવામાં વિલંબ કરો.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'સ્થાપન તબક્કામાં, દૂર કરવાના ટુકડાઓને ચિહ્નિત કરવામાં આવે છે, અને બંને ખેલાડીઓ માટે, આ બિંદુઓ પર કોઈ નવા ટુકડાઓ મૂકી શકાતા નથી. ચલણ તબક્કામાં પ્રવેશીને, આ ચિહ્નિત ટુકડાઓને સમૂહમાં દૂર કરવામાં આવે છે, અને પછી ખેલાડીઓ તેમના ટુકડાઓને આ હવે ખાલી બિંદુઓ પર ખસેડી શકે છે.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'પ્લેસિંગ ફેઝ દરમિયાન મિલ્સ બનાવતી વખતે લેવાયેલા પગલાં.';

  @override
  String get marked => 'ચિહ્નિત';

  @override
  String get menu => 'મેનૂ';

  @override
  String get monochrome => 'મોનોક્રોમ';

  @override
  String get youCanEnableScreenReaderSupport =>
      'તમે સામાન્ય સેટિંગ્સમાં એક્સેસિબિલિટી કન્ફિગ્યુરેશનમાં સ્ક્રીન રીડર સપોર્ટ ચાલુ કરી શકો છો.';

  @override
  String get showNumbersOnPieces => 'પીસ પર નંબરો બતાવો';

  @override
  String get saveImage => 'છબી સાચવો';

  @override
  String get isAnalysisToolbarShown => 'વિશ્લેષણ ટૂલબાર બતાવો';

  @override
  String get analysisToolbarBackgroundColor =>
      'વિશ્લેષણ ટૂલબારની બેકગ્રાઉન્ડ કલર';

  @override
  String get analysisToolbarIconColor => 'વિશ્લેષણ ટૂલબારની આઇકન કલર';

  @override
  String get transformed => 'ફેરફાર થયું.';

  @override
  String get cannotTransform => 'ફેરફાર કરી શકાતું નથી.';

  @override
  String get rotate => 'ઘૂમાવો';

  @override
  String get horizontalFlip => 'H ફ્લિપ';

  @override
  String get verticalFlip => 'V ફ્લિપ';

  @override
  String get innerOuterFlip => 'IO ફ્લિપ';

  @override
  String get transparentCanvas => 'પારદર્શક કેનવાસ';

  @override
  String get restrictRepeatedMillsFormation =>
      'પુનરાવર્તિત મિલની રચનાને પ્રતિબંધિત કરો';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'એક મિલથી બીજી મિલ બનાવવા માટે ખસેડવામાં આવેલ ટુકડો તરત જ આગળની વારીમાં મૂળ બિંદુ પર પાછો ફરી શકતો નથી જેથી ફરીથી મિલ બનાવી શકે. પહેલાં અલગ ચાલની જરૂર છે.';

  @override
  String get oneTimeUseMill => 'એક વખત ઉપયોગ મિલ';

  @override
  String get oneTimeUseMill_Detail =>
      'દરેક મિલ માત્ર એક જ વખત પ્રત્યાર્થીની એક પીસ દૂર કરી શકે છે. તમે તેને ફરીથી બનાવો છો, પરંતુ તે વધારાની દૂરીઓ માટે ઉપયોગમાં લેવામાં નથી આવી શકતું.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'તમે સેટ કરેલા વર્તમાન નિયમો પાસે અનુરૂપ પરિપૂર્ણ ડેટાબેઝ નથી. પરિપૂર્ણ ડેટાબેઝ વિશે વધુ માહિતી માટે, કૃપા કરીને અહીં ક્લિક કરો.';

  @override
  String get focusOnBlockingPaths => 'અવરોધન પથો પર ધ્યાન કેન્દ્રિત કરો';

  @override
  String get focusOnBlockingPaths_Detail =>
      'મિલ્સ બનાવવાના બદલે પ્રતિકુલતા માર્ગ અવરોધિત કરવા પર પ્રાથમિકતા આપો. મિલ્સ પૂર્ણ કરીને ભાગોને દૂર કરવા પર ધ્યાન કેન્દ્રિત કરવાનો બદલે, AI પ્રતિકુલતાને ફસાવવાનો હેતુ ધરાવે છે, જેથી તેઓ હલનચલન ન કરી શકે અને આક્રમક રમણાના બદલે ઘસારા દ્વારા વિજય પ્રાપ્ત કરે. આ વ્યૂહરચના પ્રતિકુલતાની મિલ્સને સક્રિય રીતે અવરોધિત કરતી નથી.';

  @override
  String get pieceImage => 'ચેસના પિયાનો ચિત્ર';

  @override
  String get importColorSettings => 'રંગ સેટિંગ્સ આયાત કરો';

  @override
  String get exportColorSettings => 'રંગ સેટિંગ્સ નિકાસ કરો';

  @override
  String get import => 'આયાત';

  @override
  String get export => 'નિકાસ';

  @override
  String get pleaseCopyJsonToClipboard =>
      'મહેરબાની કરી JSON ફોર્મેટ સેટિંગ્સને પહેલાં ક્લિપબોર્ડ પર કૉપિ કરો.';

  @override
  String get copiedToClipboard => 'ક્લિપબોર્ડ પર કૉપિ કરવામાં આવ્યું.';

  @override
  String get imported => 'આયાત કરાયું.';

  @override
  String get boardImage => 'બોર્ડ છબી';

  @override
  String get autumnLeaves => 'શરદ પતરી';

  @override
  String get legendaryLand => 'દંતકથા ધરતી';

  @override
  String get vignetteEffect => 'વિનેટ અસર';

  @override
  String get promptMakeToolbarTransparent =>
      'તબ્લો પાછળની છબી સેટ કરાય ત્યારે ટૂલબારને સંપૂર્ણપણે પારદર્શક બનાવશો?';

  @override
  String get vibration => 'રમતમાં વાઇબ્રેશન સક્રિય કરો';

  @override
  String get soundTheme => 'શબ્દ વિષય';

  @override
  String get ball => 'બૉલ';

  @override
  String get liquid => 'તરસ';

  @override
  String get wood => 'લાકડું';

  @override
  String get placeEffectAnimation => 'પતાની મૂકાશની એનિમેશન અસર';

  @override
  String get removeEffectAnimation => 'પતાની દૂર કરવાની એનિમેશન અસર';

  @override
  String get isToolbarAtBottom => 'ટૂલબાર નીચે બતાવો';

  @override
  String get boardCornerRadius => 'બોર્ડની ખૂણાની ત્રિજ્યા';

  @override
  String get useOpeningBook => 'ઓપનિંગ બુક ઉપયોગ કરો';

  @override
  String get currentRule => 'વર્તમાન';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'નિયમ સેટ';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'One-Time Mill';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'પ્રારંભિક રમત દરમિયાન વ્યાવસાયિક માનવ ખેલાડીઓ દ્વારા સામાન્ય રીતે ઉપયોગમાં લેવાતા પ્રારંભિક ચાલો એઆઈને ઉપયોગ કરવા દો. નોંધ: આ સુવિધા હાલમાં કેટલાક વિશિષ્ટ નિયમ સમૂહો માટે જ ઉપલબ્ધ છે.';

  @override
  String get showAdvantageGraph => 'લાભ ગ્રાફ બતાવો';

  @override
  String get advantageGraphHint =>
      'AI ચાલ કર્યા પછી જ અગ્રતા ગ્રાફ દોરવામાં આવશે. માનવ ખેલાડી ચાલ કરે ત્યારે તે દોરવામાં નહીં આવે.';

  @override
  String get removalBasedOnMillCounts =>
      'તમામ ભાગ들을 મૂકાઈ ગયા સુધી ભાગોને દૂર કરવાની પ્રક્રિયા અસ્થાયી રીતે બંધ કરો. ખેલાડીઓ તેમના મિલ ગણતરીના આધારે ભાગોને દૂર કરે છે.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'તમામ ભાગ들을 મૂકાઈ ગયા સુધી ભાગોને દૂર કરવાની પ્રક્રિયા અસ્થાયી બંધ રાખો. ખેલાડીઓ તેમના મિલ ગણતરી અનુસાર ભાગોને દૂર કરે છે: જો ગણતરી સમાન હોય, તો બંનેેય સમાન સંખ્યામાં ભાગોએ દૂર કરે છે; જો એક તરફ વધુ હોય, તો તે એક વધારાનું ભાગ દૂર કરીને એક ભાગનો તફાવત રાખે છે. જો માત્ર એક ખેલાડી મિલ બનાવે છે, તો તે બે ભાગોએ દૂર કરે છે જ્યારે બીજો એક ભાગ દૂર કરે છે. જો કોઈપણ મિલ બનાવતો નહીં હોય, તો બંને એક ભાગneze દૂર કરે છે.';

  @override
  String get elfilja => 'એલ ફિલ્જા';

  @override
  String get tipSelectOwnPiece => 'તમારા ગોટાઓમાંથી એક પસંદ કરો.';

  @override
  String get notYourTurn => 'તમારો વારો નથી.';

  @override
  String get annotationToolbarBackgroundColor => 'એનોટેશન ટૂલબાર પૃષ્ઠભૂમિ રંગ';

  @override
  String get annotationToolbarIconColor => 'એનોટેશન ટૂલબાર આઇકન રંગ';

  @override
  String get isAnnotationToolbarShown => 'એનોટેશન ટૂલબાર બતાવો';

  @override
  String get enterAnnotationMode => 'એનોટેશન મોડમાં પ્રવેશ કરો';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'શું તમે ખરેખર બધા એનોટેશન્સ સાફ કરવા માંગો છો?';

  @override
  String get llmPromptCopiedToClipboard =>
      'LLM પ્રોમ્પ્ટ ક્લિપબોર્ડ પર નકલ કરાયું.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'કનેક્શન નકારવામાં આવ્યું, સર્વર ડાઉન હોઈ શકે.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'શોધ સફળ, કનેક્શનની રાહ જોઈ રહ્યું...';

  @override
  String get noLanConnection => 'કોઈ LAN કનેક્શન નથી';

  @override
  String get takeScreenshot => 'સ્ક્રીનશોટ લો';

  @override
  String get disconnectedFromOpponent => 'પ્રતિસ્પર્ધીથી ડિસ્કનેક્ટ થયું.';

  @override
  String get takeBackRequest => 'પાછા લેવાની વિનંતી';

  @override
  String get nothingToShow => 'બતાવવા માટે કંઈ નથી.';

  @override
  String get stopHosting => 'હોસ્ટિંગ બંધ કરો';

  @override
  String get connectionResetByPeer =>
      'પીઅર દ્વારા કનેક્શન રીસેટ કરવામાં આવ્યું.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'હાર્ટબીટ ટાઈમઆઉટને કારણે કનેક્શન ખોવાઈ ગયું. કૃપા કરીને પુનઃ જોડાણ કરો.';

  @override
  String get startHosting => 'હોસ્ટિંગ શરૂ કરો';

  @override
  String get restartRequestRejected => 'પુનઃ શરૂ કરવાની વિનંતી નકારવામાં આવી.';

  @override
  String get notConnectedToLanOpponent => 'LAN પ્રતિસ્પર્ધી સાથે જોડાયેલ નથી.';

  @override
  String get llmPrompt => 'LLM પ્રોમ્પ્ટ';

  @override
  String get gameRestarted => 'ગેમ પુનઃ શરૂ થઈ.';

  @override
  String get takeBackRejected => 'પાછા લેવાની વિનંતી નકારવામાં આવી.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'શું તમે ખરેખર આ ગેમમાંથી રાજીનામું આપવા માંગો છો?';

  @override
  String get opponentResignedYouWin =>
      'પ્રતિસ્પર્ધીએ રાજીનામું આપ્યું. તમે જીત્યા!';

  @override
  String get clearAllAnnotations => 'બધા એનોટેશન્સ સાફ કરો';

  @override
  String get connectedWaitingForOpponentSMove =>
      'જોડાયેલ, પ્રતિસ્પર્ધીની ચાલની રાહ જોઈ રહ્યું...';

  @override
  String get networkStatusDisconnected => 'નેટવર્ક સ્થિતિ: ડિસ્કનેક્ટેડ';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'પાછા લેવાની વિનંતી પ્રતિસ્પર્ધીને મોકલવામાં આવી.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'પ્રતિસ્પર્ધીએ ગેમ છોડી દીધી હોઈ શકે';

  @override
  String get connectedToHostSuccessfully => 'હોસ્ટ સાથે સફળતાપૂર્વક જોડાયેલ.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'કનેક્શન ખોવાઈ ગયું: હાર્ટબીટ ટાઈમઆઉટ';

  @override
  String get noHostDiscovered => 'કોઈ હોસ્ટ મળ્યું નથી.';

  @override
  String get confirmResignation => 'રાજીનામુંની પુષ્ટિ કરો';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'ગેમ હોસ્ટિંગ શરૂ કર્યું, ખેલાડીઓના જોડાવાની રાહ જોઈ રહ્યું...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'કનેક્શન ટાઈમઆઉટ થયું, નેટવર્ક કનેક્શન અસ્થિર.';

  @override
  String get noLlmPromptAvailable => 'કોઈ LLM પ્રોમ્પ્ટ ઉપલબ્ધ નથી.';

  @override
  String get youResignedGameOver => 'તમે રાજીનામું આપ્યું. ગેમ સમાપ્ત.';

  @override
  String get serverIp => 'સર્વર IP';

  @override
  String get confirmClear => 'સાફ કરવાની પુષ્ટિ કરો';

  @override
  String get opponentSTurn => 'પ્રતિસ્પર્ધીનો વારો.';

  @override
  String get waitingAClientConnection => 'ક્લાયન્ટ કનેક્શનની રાહ જોઈ રહ્યું...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'પાછા લેવાની વિનંતી નકારવામાં આવી અથવા નિષ્ફળ રહી.';

  @override
  String get addText => 'લખાણ ઉમેરો';

  @override
  String get exitAnnotationMode => 'એનોટેશન મોડમાંથી બહાર નીકળો';

  @override
  String get typeYourAnnotation => 'તમારું એનોટેશન લખો';

  @override
  String get attemptingToReconnect => 'પુનઃ જોડાણનો પ્રયાસ કરી રહ્યું...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'પુનઃ શરૂ કરવાની વિનંતી મોકલવામાં આવી. પ્રતિસ્પર્ધીના પ્રતિસાદની રાહ જોઈ રહ્યું...';

  @override
  String get serverIsStopped => 'સર્વર બંધ છે.';

  @override
  String get restartRequest => 'પુનઃ શરૂ કરવાની વિનંતી';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'જ્યારે તમારો વારો નથી ત્યારે પાછા લેવાની વિનંતી કરી શકાતી નથી.';

  @override
  String get takeBackAccepted => 'પાછા લેવાની વિનંતી સ્વીકારવામાં આવી.';

  @override
  String get localNetworkSettings => 'સ્થાનિક નેટવર્ક સેટિંગ્સ';

  @override
  String get reconnectedSuccessfully => 'સફળતાપૂર્વક પુનઃ જોડાયેલ!';

  @override
  String get failedToSaveImageToGallery => 'ગેલેરીમાં ઈમેજ સાચવવામાં નિષ્ફળ.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'પ્રતિસ્પર્ધીએ ગેમ પુનઃ શરૂ કરવાની વિનંતી કરી છે. શું તમે સ્વીકારો છો?';

  @override
  String get yourTurn => 'તમારો વારો.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'પુનઃ જોડાણ કરવામાં અસમર્થ, કૃપા કરીને ગેમ પુનઃ શરૂ કરો.';

  @override
  String get host => 'હોસ્ટ';

  @override
  String get join => 'જોડાઓ';

  @override
  String get port => 'પોર્ટ';

  @override
  String get invalidIpAddress => 'અમાન્ય IP સરનામું.';

  @override
  String get invalidPort => 'અમાન્ય પોર્ટ.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'જોડાણ: પ્રયાસ $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'જોડાણ નિષ્ફળ: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'હોસ્ટિંગ શરૂ કરવામાં નિષ્ફળ: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'હોસ્ટ મળ્યું: $ip:$port';
  }

  @override
  String get stop => 'બંધ કરો';

  @override
  String get discover => 'શોધો';

  @override
  String get connect => 'જોડાઓ';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'ક્લાયન્ટ જોડાયેલ: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'શોધી રહ્યું: $seconds સે';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'પુનઃ જોડાણ ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'જોડાયેલ';

  @override
  String get delete => 'કાઢી નાખો';

  @override
  String get ancientEgypt => 'પ્રાચીન ઇજિપ્ત';

  @override
  String get gothicIce => 'ગોથિક બરફ';

  @override
  String get riceField => 'ચોખાનું ખેતર';

  @override
  String get chinesePorcelain => 'ચીની પોર્સેલિન';

  @override
  String get desertDusk => 'રણનું સંધ્યાકાળ';

  @override
  String get precisionCraft => 'ચોકસાઈ કારીગરી';

  @override
  String get folkEmbroidery => 'લોક ભરતકામ';

  @override
  String get carpathianHeritage => 'કાર્પેથિયન વારસો';

  @override
  String get imperialGrandeur => 'શાહી ભવ્યતા';

  @override
  String get bohemianCrystal => 'બોહેમિયન ક્રિસ્ટલ';

  @override
  String get savannaSunrise => 'સવાના સૂર્યોદય';

  @override
  String get harmonyBalance => 'સંનાદ અને સંતુલન';

  @override
  String get cinnamonSpice => 'તજ મસાલો';

  @override
  String get anatolianMosaic => 'અનાતોલિયન મોઝેક';

  @override
  String get carnivalSpirit => 'કાર્નિવલ આત્મા';

  @override
  String get custom => 'કસ્ટમ';

  @override
  String get spiceMarket => 'મસાલા બજાર';

  @override
  String get swipeToRevealTheDrawer => 'ડ્રોઅર દર્શાવવા માટે સ્વાઇપ કરો';

  @override
  String get showGameInfoOnScreenshots => 'સ્ક્રીનશૉટમાં ગેમ માહિતી બતાવો';

  @override
  String get humanMoveTime => 'માનવ સમય મર્યાદા';

  @override
  String get noTimeLimitForHumanMoves => 'માનવ ચાલ માટે કોઈ સમય મર્યાદા નથી';

  @override
  String get timeoutLoseWillBeApplied =>
      'માનવ ખેલાડી માટે સમયસમાપ્તિ હાર લાગુ કરવામાં આવશે';

  @override
  String get identifyingBoard => 'બોર્ડ ઓળખી રહ્યું છે...';

  @override
  String get youCanEnterAnyModelName => 'તમે કોઈપણ મોડેલ નામ દાખલ કરી શકો છો.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'બોર્ડ સ્થિતિ લાગુ થઈ. FEN ક્લિપબોર્ડ પર નકલ થઈ.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'સૂચન: બોર્ડનો વધુ સ્પષ્ટ ફોટો લેવા પ્રયત્ન કરો.';

  @override
  String get llmPromptTemplate => 'LLM પ્રોમ્પ્ટ ટેમ્પલેટ';

  @override
  String get noValidBoardDetected => 'કોઈ માન્ય બોર્ડ શોધવામાં આવ્યો નથી.';

  @override
  String get selectingImageFromAlbum => 'એલબમમાંથી છબી પસંદ કરી રહ્યું છે...';

  @override
  String get configurePromptTemplate => 'પ્રોમ્પ્ટ ટેમ્પલેટ રૂપરેખાંકિત કરો';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'LLM વિશ્લેષણ માટે પ્રોમ્પ્ટ ટેમ્પલેટ સંપાદિત કરો';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'ઓળખાયેલા બોર્ડમાંથી FEN જનરેટ કરવામાં નિષ્ફળ.';

  @override
  String get outputInCurrentLanguage => 'વર્તમાન ભાષામાં આઉટપુટ';

  @override
  String get commonBaseUrls => 'સામાન્ય બેઝ URLs';

  @override
  String get viewCommonModels => 'સામાન્ય મોડેલો જુઓ';

  @override
  String get recognitionParametersUpdated => 'ઓળખાણ પેરામીટર્સ અપડેટ થઈ ગયા.';

  @override
  String get whiteSMove => 'સફેદની ચાલ';

  @override
  String get resetToDefaults => 'ડિફોલ્ટ્સ પર પુનઃસેટ કરો';

  @override
  String get photoShoot => 'ફોટો શૂટ';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'ઓળખાયેલ બોર્ડ સ્થિતિ લાગુ કરવામાં નિષ્ફળ.';

  @override
  String get llmPromptContent => 'LLM પ્રોમ્પ્ટ સામગ્રી';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM રૂપરેખાંકિત નથી. કૃપા કરી તમારી સેટિંગ્સ તપાસો.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'પ્રદાતા, મોડેલ, API Key અને Base URL સેટ કરો';

  @override
  String get llmConfiguration => 'LLM રૂપરેખાંકન';

  @override
  String get configureLlmProvider => 'LLM પ્રદાતા રૂપરેખાંકિત કરો';

  @override
  String get llmPromptTemplateHeader => 'LLM પ્રોમ્પ્ટ ટેમ્પલેટ હેડર';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'છબીમાં કોઈ પીસ ઓળખાઇ નથી. કૃપા કરી ફરી પ્રયત્ન કરો.';

  @override
  String get recognizeBoardFromImage => 'છબીમાંથી બોર્ડ ઓળખો';

  @override
  String get viewTips => 'સૂચનો જુઓ';

  @override
  String get applyToBoard => 'બોર્ડ પર લાગુ કરો';

  @override
  String get adjustBoardArea => 'બોર્ડ વિસ્તાર સમાયોજિત કરો';

  @override
  String get viewCommonUrls => 'સામાન્ય URLs જુઓ';

  @override
  String get colorAnalysisFailed => 'રંગ વિશ્લેષણ નિષ્ફળ ગયું!';

  @override
  String get analyzingGameBoardImage =>
      'ગેમબોર્ડ છબી વિશ્લેષણ કરી રહ્યું છે...';

  @override
  String get selectFromAlbum => 'એલબમમાંથી પસંદ કરો';

  @override
  String get noBoardPointDetected => 'કોઈ પણ બોર્ડ પોઈન્ટ શોધવામાં આવ્યું નથી!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'ખાલી મૂકવામાં આવે તો ડિફોલ્ટ ટેમ્પલેટ વાપરાશે';

  @override
  String get llmConfig => 'LLM રૂપરેખાંકન';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'શું તમે ખરેખર પ્રોમ્પ્ટ ટેમ્પલેટ્સને ડિફોલ્ટ મૂલ્યો પર પુનઃસેટ કરવા માંગો છો?';

  @override
  String get llmPromptTemplateFooter => 'LLM પ્રોમ્પ્ટ ટેમ્પલેટ ફૂટર';

  @override
  String get loadingResponse => 'જવાબ લોડ કરી રહ્યું છે...';

  @override
  String get applyThisResultToBoard => 'આ પરિણામ બોર્ડ પર લાગુ કરો';

  @override
  String get takingPicture => 'ફોટો લઈ રહ્યું છે...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'ઓળખવા માટે ગેમબોર્ડ છબી પસંદ કરો';

  @override
  String get identificationResults => 'ઓળખાણ પરિણામો';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'ચાલ વિશ્લેષણ કરો અને અંદાજપત્ર પ્રદાન કરો.';

  @override
  String get getApiKey => 'API Key મેળવો';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'સંપૂર્ણ ઓળખ પ્રક્રિયા પૂર્ણ કરવામાં નિષ્ફળ.';

  @override
  String get boardRecognitionResult => 'બોર્ડ ઓળખ પરિણામ';

  @override
  String get askLlm => 'LLMને પૂછો';

  @override
  String get boardDetectionFailed => 'બોર્ડ શોધવામાં નિષ્ફળ!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'કોઈ બોર્ડ પોઈન્ટ મળી શક્યો નથી, પીસ ઓળખી શકાતી નથી!';

  @override
  String get copyFen => 'FEN નકલ કરો';

  @override
  String get commonlyUsedModels => 'સામાન્ય રીતે વપરાતા મોડેલો';

  @override
  String get apiKeyOptional => 'API Key (વૈકલ્પિક)';

  @override
  String get noImageSelected => 'કોઈ છબી પસંદ નથી';

  @override
  String get blackSMove => 'કાળાની ચાલ';

  @override
  String get llm => 'મોટું ભાષા મોડેલ';

  @override
  String get llmProvider => 'પ્રદાતા';

  @override
  String get baseUrl => 'બેઝ URL';

  @override
  String get model => 'મોડેલ';

  @override
  String get temperature => 'તાપમાન';

  @override
  String get llmCommandReceivedProcessing =>
      'આદેશ મળ્યો! AI પ્રક્રિયા માં છે...';

  @override
  String get llmDeepThinkingWait =>
      'ડીપ વિચારો ચાલી રહ્યું છે, કૃપા કરી રાહ જુઓ...';

  @override
  String get llmPresentingSoon => 'જલ્દી રજૂ થશે...';

  @override
  String get recognitionParameters => 'ઓળખ પરિમાણો';

  @override
  String get adjustParamsDesc =>
      'ઓળಖની ચોકસાઈ સુધારવા માટે પરિમાણો સમાયોજિત કરો';

  @override
  String get saveParameters => 'પરિમાણો સંગ્રહો';

  @override
  String unableToStartImageRecognition(String error) {
    return 'ચિત્ર ઓળખ શરૂ કરી શકતા નથી: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'ચિત્ર ઓળખ નિષ્ફળ ગઈ: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'લાગુ કરાયેલ સ્થિતિમાં $whiteCount સફેદ અને $blackCount કાળી ગોટીઓ';
  }

  @override
  String get fenCopiedToClipboard => '(FEN ક્લિપબોર્ડમાં નકલ થયેલ)';

  @override
  String recognitionFailed(String error) {
    return 'ઓળખ નિષ્ફળ ગઈ: $error';
  }

  @override
  String get myRating => 'મારું રેટિંગ';

  @override
  String get gamesPlayed => 'રમાયેલી રમતો';

  @override
  String get wins => 'જીત';

  @override
  String get losses => 'હાર';

  @override
  String get draws => 'ડ્રો';

  @override
  String get lastUpdated => 'છેલ્લે અપડેટ કર્યું';

  @override
  String get format => 'ફોર્મેટ:';

  @override
  String get resetStatistics => 'આંકડા રીસેટ કરો';

  @override
  String get drawRate => 'ડ્રો રેટ';

  @override
  String get lossRate => 'હારનો દર';

  @override
  String get aiStatistics => 'AI આંકડા';

  @override
  String get enableStatistics => 'આંકડા સક્ષમ કરો';

  @override
  String get enableStatistics_Detail =>
      'જ્યારે સક્ષમ હોય, ત્યારે રમતના પરિણામો આંકડામાં રેકોર્ડ કરવામાં આવશે. જોકે, ટેક-બેકનો સમાવેશ કરતી રમતો રેકોર્ડ કરવામાં આવશે નહીં. જ્યારે અક્ષમ હોય, ત્યારે આંકડા સંગ્રહ થોભાવવામાં આવે છે.';

  @override
  String get thisWillResetAllGameStatistics =>
      'આ તમામ રમતના આંકડા રીસેટ કરશે. આ ક્રિયાને પૂર્વવત્ કરી શકાતી નથી.';

  @override
  String get boardInnerRingSize => 'બોર્ડની અંદરની રિંગનું કદ';

  @override
  String get boardShadowEnabled => 'બોર્ડનો છાયો';

  @override
  String get trapAwareness => 'ફાંસાની જાગૃતિ';

  @override
  String get trapAwarenessDescription =>
      'વિશ્લેષણ દરમિયાન જાડા વર્તુળો અને તીરો સાથે ફાંસાના ચાલોને હાઇલાઇટ કરો।';

  @override
  String trapExists(String trapMoves) {
    return 'ફાંસો હાજર છે. ફાંસાના ચાલ: $trapMoves';
  }

  @override
  String get custodianCapture => 'ક captથર';

  @override
  String get custodianCaptureDescription =>
      'તમારા વિરોધીના ટુકડાઓમાંથી એકને તમારા બે વચ્ચે સીધી લાઇનમાં બંધ કરો.';

  @override
  String get custodianCaptureEnable => 'Flanking કેપ્ચરને મંજૂરી આપો';

  @override
  String get interventionCapture => 'હસ્તક્ષેપ';

  @override
  String get interventionCaptureDescription =>
      'તે બંનેને કેપ્ચર કરવા માટે તમારા વિરોધીના બે ટુકડાઓ વચ્ચે ખાલી બિંદુમાં જાઓ.';

  @override
  String get interventionCaptureEnable => 'હસ્તક્ષેપ કેપ્ચર કરવાની મંજૂરી આપો';

  @override
  String get leapCapture => 'કૂદવું';

  @override
  String get leapCaptureDescription =>
      'નજીકના વિરોધીના ટુકડા ઉપરથી ખાલી બિંદુમાં કૂદીને કેપ્ચર કરો.';

  @override
  String get leapCaptureEnable => 'જમ્પ કેપ્ચરને મંજૂરી આપો';

  @override
  String get captureApplicableLines => 'લાગુ પડતી રેખાઓ';

  @override
  String get captureSquareEdges => 'ચોરસ ધાર સાથે';

  @override
  String get captureCrossLines => 'ચોરસને પાર કરતી ઓર્થોગોનલ રેખાઓ સાથે';

  @override
  String get captureDiagonalLines => 'ચોરસને પાર કરતી કર્ણ રેખાઓ સાથે';

  @override
  String get captureExecutionPhases => 'અમલના તબક્કાઓ';

  @override
  String get capturePiecesCondition =>
      'બાકીના ટુકડાઓના આધારે ફરતા તબક્કા દરમિયાન ઉપલબ્ધતા';

  @override
  String get capturePiecesConditionUnlimited => 'કોઈ પ્રતિબંધ નથી';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'જ્યારે તમારી પાસે ત્રણ અથવા ઓછા ટુકડાઓ હોય ત્યારે ઉપલબ્ધ';
}
