// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for French (`fr`).
class SFr extends S {
  SFr([String locale = 'fr']) : super(locale);

  @override
  String get appName => 'Moulin';

  @override
  String get welcome => 'Bienvenue';

  @override
  String get yes => 'Oui';

  @override
  String get no => 'Non';

  @override
  String get game => 'Jeu';

  @override
  String get humanVsAi => 'Humain vs IA';

  @override
  String get humanVsHuman => 'Humain vs humain';

  @override
  String get aiVsAi => 'IA vs IA';

  @override
  String get humanVsCloud => 'Humain vs Cloud';

  @override
  String get humanVsLAN => 'Humain vs Réseau local';

  @override
  String get testViaLAN => 'Test via Réseau local';

  @override
  String get move => 'Mvt.';

  @override
  String get showMoveList => 'Liste des mouvements';

  @override
  String get moveList => 'Liste des mouvements';

  @override
  String get noGameRecord => 'Aucun enregistrement';

  @override
  String get ok => 'OK';

  @override
  String get confirm => 'Confirmer';

  @override
  String get cancel => 'Annuler';

  @override
  String get tipSelectWrong => 'Pièce incorrecte sélectionnée.';

  @override
  String get tipPlace => 'Placez vos pièces.';

  @override
  String get tipBanPlace => 'Impossible de la placer ici.';

  @override
  String get tipPlaced => 'Pièce placée.';

  @override
  String get tipRemove => 'Retirez une pièce.';

  @override
  String get tipBanRemove => 'Impossible de la retirer.';

  @override
  String get tipRemoved => 'Pièce retirée.';

  @override
  String get tipMove => 'Déplacez une pièce.';

  @override
  String get tipCannotPlace => 'Vous ne pouvez pas placer votre pièce ici.';

  @override
  String get tipCannotMove => 'Vous ne pouvez pas déplacer votre pièce ici.';

  @override
  String get tipMill => 'Moulin ! Prenez la pièce de votre adversaire.';

  @override
  String get tipContinueMill =>
      'Continuez pour prendre la pièce de votre adversaire.';

  @override
  String get tipSelectOpponentsPiece =>
      'Sélectionnez une des pièces de votre adversaire.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Vous ne pouvez pas retirer une pièce d\'un moulin.';

  @override
  String get tipCanMoveOnePoint => 'Une pièce peut se déplacer de 1 point.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Vous ne pouvez pas déplacer les pièces de votre adversaire.';

  @override
  String get tipSelectPieceToMove => 'Sélectionnez votre pièce à déplacer.';

  @override
  String get tipHaveThreePiecesLeft => 'Il vous reste trois pièces.';

  @override
  String get tipCanMoveToAnyPoint =>
      'Vous pouvez vous déplacer vers le point de votre choix.';

  @override
  String tipToMove(Object player) {
    return 'C’est au tour de $player de jouer.';
  }

  @override
  String get whiteWin => 'Joueur 1 gagne !';

  @override
  String get blackWin => 'Joueur 2 gagne !';

  @override
  String get won => 'Gagné';

  @override
  String get lost => 'Perdu';

  @override
  String get thinking => 'Réfléchit…';

  @override
  String get newGame => 'Nouvelle partie';

  @override
  String get importGame => 'Importer une partie';

  @override
  String get exportGame => 'Exporter une partie';

  @override
  String get gameImported => 'Jeu importé.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Impossible d\'importer $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch =>
      'Les déplacements et les règles ne correspondent pas.';

  @override
  String get pleaseWait => 'Veuillez patienter...';

  @override
  String get restartGame => 'Recommencer la partie en cours ?';

  @override
  String get restart => 'Recommencer';

  @override
  String get gameStarted => 'Partie commencée, veuillez placer vos pièces.';

  @override
  String get analyzing => 'Analyse…';

  @override
  String error(Object message) {
    return 'Erreur : $message';
  }

  @override
  String get winRate => 'Taux de victoire';

  @override
  String get score => 'Score :';

  @override
  String get white => 'Joueur 1';

  @override
  String get black => 'Joueur 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return 'Le nombre de pièces de $player est inférieur à trois.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player abandonne.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player n\'a nulle part où aller.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Le tableau est plein et $player n\'a nulle part où aller.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Le temps est écoulé, $player a perdu.';
  }

  @override
  String get drawReasonRule50 =>
      'Dans la phase de déplacement, aucune pièce n\'a été retirée au cours du dernier nombre spécifique de coups.';

  @override
  String get drawReasonBoardIsFull =>
      'C\'est un match nul car le plateau est plein.';

  @override
  String get drawReasonThreefoldRepetition =>
      'C\'est un match nul suite à une triple répétition.';

  @override
  String get gameOverUnknownReason => 'Fin de la partie ! Raison inconnue.';

  @override
  String get gameOver => 'Fin de la partie';

  @override
  String get youWin => 'Vous avez gagné ! Félicitations !';

  @override
  String challengeHarderLevel(int level) {
    return 'Défier un niveau plus difficile ? Le nouveau niveau sera le niveau $level !';
  }

  @override
  String get youLose => 'Vous avez perdu !';

  @override
  String get analyze => 'Analyser';

  @override
  String get about => 'À propos de';

  @override
  String version(Object versionNumber) {
    return 'Version : $versionNumber';
  }

  @override
  String get thanks => 'Remerciements';

  @override
  String get settings => 'Paramètres';

  @override
  String get options => 'Options';

  @override
  String get generalSettings => 'Paramètres généraux';

  @override
  String get skillLevel => 'Niveau de difficulté';

  @override
  String get moveTime => 'Temps de réflexion de l\'IA';

  @override
  String get difficulty => 'Difficulté';

  @override
  String get playSounds => 'Effets sonores';

  @override
  String get playSoundsInTheGame => 'Jouer des sons dans le jeu';

  @override
  String get keepMuteWhenTakingBack => 'Rester muet lors de la reprise';

  @override
  String get tone => 'Tonalité';

  @override
  String get whoMovesFirst => 'Premier mouvement';

  @override
  String get human => 'Humain';

  @override
  String get ai => 'IA';

  @override
  String get alternate => 'Alterner';

  @override
  String get isAutoRestart =>
      'Relancer automatiquement la partie lorsqu\'elle est terminée';

  @override
  String get isAutoChangeFirstMove => 'Changement automatique du premier coup';

  @override
  String get shufflingEnabled => 'Déplacement aléatoire';

  @override
  String get misc => 'Divers';

  @override
  String get rules => 'Règles';

  @override
  String get piecesCount => 'Le nombre de pièces dont dispose chaque joueur';

  @override
  String get piecesCount_Detail => 'Combien de pièces possède chaque joueur ?';

  @override
  String get flyPieceCount => 'Le numéro de la pièce volante';

  @override
  String get flyPieceCount_Detail =>
      'Si l\'option de vol est activée, lorsqu\'un joueur est réduit à un nombre spécifique de pièces, ses pièces sont libres de se déplacer vers n\'importe quel point inoccupé, au lieu d\'être limitées aux points adjacents comme dans le reste du jeu.';

  @override
  String get piecesAtLeastCount => 'Pièces minimum';

  @override
  String get hasDiagonalLines => 'Lignes diagonales';

  @override
  String get hasDiagonalLines_Detail =>
      'Ajoute quatre lignes diagonales au plateau.';

  @override
  String get isDefenderMoveFirst => 'Le deuxième joueur se déplace en premier';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Le joueur qui se déplace en second lors de la phase de placement se déplace en premier lors de la phase de déplacement.';

  @override
  String get mayRemoveMultiple => 'Suppression multiple';

  @override
  String get mayRemoveMultiple_Detail =>
      'Si un joueur ferme plus d\'un moulin à la fois, il pourra retirer le nombre de moulins qu\'il a fermés.';

  @override
  String get mayRemoveFromMillsAlways => 'Détruire les moulins';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Par défaut, les joueurs doivent d\'abord retirer toute autre pièce avant de retirer une pièce d\'un moulin formé. Activez cette option pour désactiver cette limitation.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Le deuxième joueur perd lorsque le plateau est plein';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'À la fin de la phase de placement, lorsque le plateau est plein, le camp qui a placé le premier perd la partie, sinon, la partie est nulle.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Perdre en l\'absence de mouvements légaux';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Le joueur perd si son adversaire le bloque de sorte qu\'il ne peut pas être déplacé. Si cette option est désactivée, le tour passe à l\'autre joueur au lieu de déclarer une défaite.';

  @override
  String get mayFly => 'Vol';

  @override
  String get mayFly_Detail =>
      'Si un joueur n\'a plus que trois ou quatre pièces (configurable), il peut déplacer la pièce vers n\'importe quel point libre.';

  @override
  String get nMoveRule => 'Règle du mouvement N';

  @override
  String get nMoveRule_Detail =>
      'La partie est nulle s\'il n\'y a pas eu de retrait dans un nombre spécifique de coups par chaque joueur.';

  @override
  String get rollback => 'Retour en arrière';

  @override
  String get pleaseSelect => 'Veuillez sélectionner';

  @override
  String get copy => 'Copier';

  @override
  String get moveHistoryCopied =>
      'L\'historique des coups a été copié dans le presse-papiers.';

  @override
  String get help => 'Aide';

  @override
  String get feedback => 'Commentaires';

  @override
  String get exit => 'Quitter';

  @override
  String get ruleSettings => 'Paramètres des règles';

  @override
  String get color => 'Couleur';

  @override
  String get boardColor => 'Couleur du plateau';

  @override
  String get pieceColor => 'Couleur des pièces';

  @override
  String get backgroundColor => 'Couleur de l\'arrière-plan';

  @override
  String get lineColor => 'Couleur de la ligne du plateau';

  @override
  String get whitePieceColor => 'Couleur des pièces du Joueur 1';

  @override
  String get blackPieceColor => 'Couleur des pièces du Joueur 2';

  @override
  String get messageColor => 'Couleur des messages';

  @override
  String get isPieceCountInHandShown => 'Afficher le nombre de pièces en main';

  @override
  String get isNotationsShown => 'Afficher les notations sur le plateau';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Afficher la barre d\'outils de navigation de l\'historique';

  @override
  String get display => 'Affichage';

  @override
  String get boardBorderLineWidth => 'Largeur du bord de l\'échiquier';

  @override
  String get boardInnerLineWidth =>
      'Largeur de la ligne intérieure de l\'échiquier';

  @override
  String get pieceWidth => 'Largeur des pièces';

  @override
  String get fontSize => 'Taille de la police';

  @override
  String get standardNotation => 'Notation WMD';

  @override
  String get restore => 'Restaurer';

  @override
  String get restoreDefaultSettings => 'Restaurer les paramètres par défaut';

  @override
  String pick(Object element) {
    return 'Choisissez $element';
  }

  @override
  String get info => 'Infos';

  @override
  String get hint => 'Indice';

  @override
  String get player => 'joueur';

  @override
  String get player1 => 'Joueur 1';

  @override
  String get player2 => 'Joueur 2';

  @override
  String get howToPlay => 'Comment jouer';

  @override
  String get toPlacePiece =>
      'Tapez sur n\'importe quel point disponible pour placer la pièce.';

  @override
  String get toSelectPiece => 'Tapez sur une pièce pour la déplacer.';

  @override
  String get toMovePiece =>
      'Tapez sur un point connecté à une pièce pour la déplacer.';

  @override
  String get toRemovePiece =>
      'Tapez sur une pièce de l\'adversaire pour la retirer.';

  @override
  String get needToCreateMillFirst =>
      'Vous devez d\'abord créer un moulin avant de pouvoir retirer une pièce.';

  @override
  String get needToPlayWithOwnPieces => 'Vous devez jouer avec vos pièces.';

  @override
  String get statistics => 'Statistiques';

  @override
  String get totalGames => 'Parties totales';

  @override
  String get results => 'Résultats';

  @override
  String get left => 'gauche';

  @override
  String get privacyPolicy => 'Politique de confidentialité';

  @override
  String get privacyPolicy_Detail_1 =>
      'Veuillez lire attentivement et vous assurer que vous comprenez et acceptez cette politique de confidentialité. ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Si vous n\'êtes pas d\'accord avec cette politique, veuillez ne pas utiliser cette application. L\'utilisation de l\'application implique que vous acceptez ces conditions.';

  @override
  String get and => ' et ';

  @override
  String get accept => 'Accepter';

  @override
  String get takeBack => 'Reprendre';

  @override
  String get takingBack => 'Reprise…';

  @override
  String get waiting => 'En attente…';

  @override
  String get stepForward => 'Avancer';

  @override
  String get takeBackAll => 'Tout reprendre';

  @override
  String get stepForwardAll => 'Tout avancer';

  @override
  String get moveNow => 'Déplacer maintenant';

  @override
  String get done => 'Terminé.';

  @override
  String get crackMill => 'Moulin à fissures';

  @override
  String get crackMill_Detail =>
      'Si un joueur n\'a que des pièces dans des moulins, les pièces dans les moulins ne se verrouilleront pas pour être retirées.';

  @override
  String get animationDuration => 'Durée de l\'animation';

  @override
  String get none => 'Aucune';

  @override
  String get theme => 'Thème';

  @override
  String get helpContent =>
      'Le jeu vise à laisser l\'adversaire avec moins de trois pièces ou aucun coup légal.\n\nLa partie est automatiquement nulle si une position se produit pour la troisième fois, ou si aucun retrait n\'a été effectué au cours des 100 derniers coups (configurables).\n\nLe jeu se déroule en trois phases :\n\n1. Placement des pièces sur les points vacants\n2. Déplacement des pièces vers les points adjacents\n3. (Phase optionnelle) Déplacement des pièces vers n\'importe quel point vacant lorsque le joueur a été réduit à trois pièces.\n\nPlacement\n\nLe jeu commence avec un plateau vide, qui consiste en une grille de vingt-quatre points. Les joueurs placent à tour de rôle leurs pièces sur les points vacants jusqu\'à ce que chaque joueur ait placé toutes ses pièces sur le plateau. Si un joueur peut placer trois de ses pièces en ligne droite, il a un « moulin » et peut retirer une des pièces de son adversaire du plateau.\n\nDans certaines variantes des règles, les joueurs doivent d\'abord retirer toutes les autres pièces avant de retirer une pièce d\'un moulin formé.\n\nDans certaines variantes des règles, tous les points des pièces retirées ne peuvent pas être replacés lors de la phase de placement.\n\nUne fois que toutes les pièces ont été utilisées, les joueurs se déplacent à tour de rôle.\n\nDéplacement\n\nPour se déplacer, un joueur déplace une de ses pièces le long d\'une ligne du plateau jusqu\'à un point adjacent vacant. S\'il ne peut pas le faire, il a perdu la partie. Comme dans la phase de placement, un joueur qui aligne trois de ses pièces sur une ligne du plateau dispose d\'un moulin et peut retirer une des pièces de son adversaire. Tout joueur réduit à deux pièces n\'ayant pas la possibilité de former de nouveaux moulins perd donc la partie. Un joueur peut également perdre avec plus de trois pièces si son adversaire les bloque de manière à ce qu\'elles ne puissent pas être déplacées.\n\nVol\n\nDans certaines variantes des règles, lorsqu\'un joueur n\'a plus que trois pièces, ses pièces peuvent « voler », « sauter » ou « bondir » vers n\'importe quel point vacant, et pas seulement vers des points adjacents.\n';

  @override
  String get versionInfo => 'Informations de version';

  @override
  String get eula => 'CLUF';

  @override
  String get license => 'Licence';

  @override
  String get sourceCode => 'Code source';

  @override
  String get appVersion => 'Version de l\'application';

  @override
  String get general => 'Général';

  @override
  String get advanced => 'Avancé';

  @override
  String get placing => 'Plac.';

  @override
  String get moving => 'Dépl.';

  @override
  String get removing => 'Suppression';

  @override
  String get gameOverCondition => 'Condition de fin de partie';

  @override
  String get aisPlayStyle => 'Style de jeu de l\'IA';

  @override
  String get passive => 'Passif';

  @override
  String get timeout => 'Temps écoulé';

  @override
  String get appearance => 'Apparence';

  @override
  String get drawOnHumanExperience => 'S\'inspirer de l\'expérience humaine';

  @override
  String get considerMobility => 'Tenir compte de la mobilité des pièces';

  @override
  String get pieceCount => 'Nombre de pièces :';

  @override
  String inHand(Object player, int count) {
    return 'Main de $player : $count';
  }

  @override
  String onBoard(Object player, int count) {
    return 'Plateau de $player : $count';
  }

  @override
  String get boardTop => 'Décalage du plateau par rapport au haut';

  @override
  String get notAIsTurn => 'Ce n\'est pas le tour de l\'IA.';

  @override
  String get aiIsNotThinking => 'L\'IA ne réfléchit pas.';

  @override
  String get atEnd => 'Vous êtes à la fin de la liste des mouvements.';

  @override
  String get tapBackAgainToLeave =>
      'Appuyez à nouveau sur Retour pour quitter.';

  @override
  String get more => 'En savoir plus';

  @override
  String get experimental => 'Il s\'agit d\'une fonctionnalité expérimentale.';

  @override
  String get experiments => 'Expériences';

  @override
  String get ossLicenses => 'Licences open-source';

  @override
  String get language => 'Langue';

  @override
  String get defaultLanguage => 'Langue par défaut';

  @override
  String get mayMoveInPlacingPhase =>
      'Les pièces peuvent se déplacer dans la phase de placement';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Il n\'y a pas de phases distinctes de placement et de déplacement, c\'est-à-dire que les joueurs peuvent décider à chaque déplacement s\'ils veulent placer une pièce sur le plateau ou déplacer une de leurs pièces (tant qu\'il leur reste des pièces à placer).';

  @override
  String get drawerColor => 'Couleur des menus';

  @override
  String get drawerTextColor => 'Couleur du texte des menus';

  @override
  String get drawerHighlightItemColor => 'Couleur d\'accentuation des menus';

  @override
  String get mainToolbarBackgroundColor =>
      'Couleur d\'arrière-plan de la barre d\'outils principale';

  @override
  String get mainToolbarIconColor =>
      'Couleur de l\'icône de la barre d\'outils principale';

  @override
  String get navigationToolbarBackgroundColor =>
      'Couleur d\'arrière-plan de la barre d\'outils de navigation';

  @override
  String get navigationToolbarIconColor =>
      'Couleur de l\'icône de la barre d\'outils de navigation';

  @override
  String get autoHideToolbar => 'Masquer automatiquement la barre d\'outils';

  @override
  String get toolbarLocationOnScreen =>
      'Emplacement de la barre d\'outils sur l\'écran';

  @override
  String get top => 'Haut';

  @override
  String get bottom => 'Bas';

  @override
  String get center => 'Centre';

  @override
  String get solidColor => 'Couleur unie';

  @override
  String get picture => 'Photo';

  @override
  String get chooseYourPicture => 'Choisissez votre image';

  @override
  String get light => 'Clair';

  @override
  String get dark => 'Sombre';

  @override
  String get themes => 'Thèmes';

  @override
  String get currentTheme => 'Thème actuel';

  @override
  String get saveTheme => 'Enregistrer le thème';

  @override
  String get showAnalysisGraph => 'Afficher le graphique d\'analyse';

  @override
  String get analysis => 'Analyse';

  @override
  String get saveGame => 'Sauvegarder la partie';

  @override
  String get loadGame => 'Chargement de la partie';

  @override
  String get setupPosition => 'Position d\'installation';

  @override
  String get showLegalMoves => 'Afficher les coups autorisés';

  @override
  String get showLastMove => 'Afficher le dernier coup';

  @override
  String get showArrows => 'Afficher les flèches';

  @override
  String get pieces => 'Pièces';

  @override
  String get showAnalysis => 'Afficher l\'analyse';

  @override
  String get threads => 'Fils';

  @override
  String get getInvolved => 'Contribuer';

  @override
  String get helpImproveTranslate => 'Aidez à améliorer la traduction';

  @override
  String get tutorial => 'Didacticiel';

  @override
  String get classicMill => 'Moulin classique';

  @override
  String get mixedMill => 'Moulin mixte';

  @override
  String get ceylonMill => 'Moulin de Ceylan';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Le moulin peut être cassé et créé à plusieurs reprises';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Si un joueur casse un moulin pour en former un nouveau immédiatement, il peut redéplacer cette pièce vers le point d\'origine lors de son prochain coup si cela forme un autre nouveau moulin.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Le jeu est nul si un joueur a trois pièces et après dix coups aucun joueur ne retire les pièces de l\'adversaire';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Lorsqu\'un joueur n\'a plus que trois pièces et qu\'aucun des deux joueurs ne peut retirer la pièce d\'un adversaire en dix coups, le jeu nul.';

  @override
  String get close => 'Fermer';

  @override
  String get whitePiece => 'Pièce blanche';

  @override
  String get blackPiece => 'Pièce noire';

  @override
  String get emptyPoint => 'Point vide';

  @override
  String get noPoint => 'Aucun point';

  @override
  String get placingPhase => 'Phase de placement';

  @override
  String get movingPhase => 'Phase de déplacement';

  @override
  String get flyingPhase => 'Phase de vol';

  @override
  String sideToMove(Object player) {
    return 'Au tour de : $player';
  }

  @override
  String lastMove(Object move) {
    return 'Dernier coup : $move';
  }

  @override
  String get selected => 'Sélectionné';

  @override
  String get accessibility => 'Accessibilité';

  @override
  String get screenReaderSupport => 'Lecteur d\'écran';

  @override
  String get isDraw => 'Match nul !';

  @override
  String get draw => 'Match nul';

  @override
  String get pieceHighlightColor => 'Couleur d\'accentuation des pièces';

  @override
  String get algorithm => 'Algorithme';

  @override
  String get endgameNMoveRule => 'Règle des mouvements N de fin de partie';

  @override
  String get endgameNMoveRule_Detail =>
      'Si l\'un des joueurs n\'a que trois pièces et qu\'aucun des deux joueurs n\'enlève une pièce au cours d\'un mouvement spécifique, le jeu est nul.';

  @override
  String get drawReasonEndgameRule50 =>
      'Chaque joueur n\'a que trois pièces et aucun des deux joueurs n\'enlève une pièce dans un mouvement spécifique.';

  @override
  String get threefoldRepetitionRule => 'Règle de la triple répétition';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Le jeu est nul si une position se produit pour la troisième fois.';

  @override
  String get continueToMakeMove =>
      'Moulin ! Continuez pour effecter un déplacement.';

  @override
  String get pointStyle => 'Style de point';

  @override
  String get pointWidth => 'Largeur de point';

  @override
  String get solid => 'Solide';

  @override
  String get hollow => 'Creux';

  @override
  String get languageName => 'Français';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count mouvements',
      one: '$count mouvement',
      zero: 'mouvement',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Échec du chargement.';

  @override
  String get filename => 'Nom du fichier';

  @override
  String get browse => 'Parcourir…';

  @override
  String get gameFiles => 'Fichiers de jeu';

  @override
  String get gameSavedTo => 'La partie est sauvegardée dans';

  @override
  String get empty => 'Vide';

  @override
  String get noMove => 'Ne bouge pas.';

  @override
  String get restoredPosition => 'Position initiale restaurée.';

  @override
  String get clean => 'Nettoyer';

  @override
  String get cleanedUp => 'Nettoyé.';

  @override
  String get remove => 'Retirer';

  @override
  String get noPiecesCanBeRemoved => 'Aucune pièce ne peut être retirée.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count pieces',
      one: '$count piece',
      zero: 'Piece',
    );
    return '$_temp0 doivent être supprimés.';
  }

  @override
  String placedCount(int count) {
    return 'Placées ($count)';
  }

  @override
  String get placedPieceCount =>
      'Décompte des pièces placées lors de la phase de placement.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'Le joueur actuel a placé $count pièces.';
  }

  @override
  String get notPlacingPhase =>
      'Ne pas placer la phase, ne peut pas la changer.';

  @override
  String get paste => 'Coller';

  @override
  String get pasteDone => 'Collage terminé.';

  @override
  String get cannotPaste => 'Impossible de coller.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Afficher les pièces non placées et supprimées';

  @override
  String get fullScreen => 'Plein écran';

  @override
  String get reopenToTakeEffect =>
      'Quittez et rouvrez l\'application pour que les paramètres prennent effet.';

  @override
  String get forest => 'Forêt';

  @override
  String get desktopImage => 'Image de bureau';

  @override
  String get invalidPosition => 'Position invalide.';

  @override
  String get shareGIF => 'Partager GIF';

  @override
  String get pixelRatio => 'Rapport de pixels';

  @override
  String get duration => 'Durée';

  @override
  String get gameScreenRecorder => 'Enregistreur d\'écran de jeu';

  @override
  String get previous => 'Précédent';

  @override
  String get next => 'Prochain';

  @override
  String get skip => 'Sauter';

  @override
  String get gotIt => 'J\'ai compris';

  @override
  String get youCanModifyRules =>
      'Vous pouvez modifier les règles du jeu dans les paramètres de règles.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Vous pouvez utiliser la molette de la souris pour modifier la valeur dans le sélecteur.';

  @override
  String get noTimeLimitForThinking =>
      'Le temps de réflexion AI défini sur 0 signifie qu\'il n\'y a pas de limite de temps pour la réflexion.';

  @override
  String get whatIsMtdf =>
      'MTD(f) est une forme modifiée de l\'algorithme de recherche alpha-bêta qui vise à améliorer l\'efficacité en réutilisant les résultats de recherche intermédiaires et en utilisant une bonne estimation initiale pour réduire l\'espace de recherche.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Veuillez noter que l\'ajustement du temps de réflexion de l\'IA peut ne pas être tout à fait précis. Le temps de réflexion réel peut être plus court lorsque le niveau de difficulté est défini sur une valeur inférieure et peut être plus long lorsque l\'IA est à mi-réflexion lorsque le temps est écoulé.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Si vous définissez un niveau de difficulté élevé mais n\'augmentez pas le temps de réflexion de l\'IA, le niveau de difficulté réel peut être limité à une valeur inférieure en raison de la contrainte de temps de réflexion. La valeur réelle peut varier en fonction des performances de la machine.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) est un algorithme de recherche pour trouver le meilleur coup dans une position donnée. Il s\'agit d\'une amélioration de l\'algorithme alpha-bêta et utilise des recherches de fenêtre nulle ou nulle pour confirmer qu\'un mouvement est pire ou pas pire qu\'un score déjà sûr de la variation principale. PVS se concentre sur les mouvements les plus prometteurs et évite les recherches inutiles de branches sous-optimales, ce qui contribue à améliorer l\'efficacité de la recherche.';

  @override
  String get whatIsAlphaBeta =>
      'L\'algorithme alpha-bêta est un algorithme de recherche pour trouver le meilleur coup. Il utilise le principe minimax et deux valeurs, alpha et bêta, pour élaguer l\'arbre de recherche et augmenter l\'efficacité. Alpha représente le score minimum que l\'ordinateur est sûr de pouvoir obtenir, tandis que bêta représente le score maximum que son adversaire peut obtenir. L\'algorithme aide l\'ordinateur à prendre des décisions intelligentes et efficaces dans un jeu.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Selon l\'expérience humaine, si vous essayez de gagner, vous perdrez. Au lieu de cela, visez un match nul comme objectif et évitez de perdre la partie. Observez votre adversaire et attirez-le doucement dans une position où il pourrait faire des erreurs. Quand il montre de la faiblesse, saisissez l\'opportunité et poussez doucement pour la victoire. De cette façon, vous pouvez gagner la partie.';

  @override
  String get firstMoveDetail =>
      'Dans ce jeu, il est plus facile pour le deuxième joueur de gagner que pour le premier joueur.';

  @override
  String get passiveDetail =>
      'L\'activation de l\'option Passive amènera l\'IA à se détendre lorsqu\'elle a un avantage dans la position, plutôt que d\'essayer agressivement de gagner le plus rapidement possible.';

  @override
  String get moveRandomlyDetail =>
      'L\'activation de cette option augmente le caractère aléatoire et le plaisir du jeu, tandis que la désactiver peut aider à étudier les moyens de battre l\'IA.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Si l\'IA considère la mobilité de ses pièces, elle visera non seulement à capturer les pièces de l\'adversaire le plus rapidement possible, mais envisagera également de bloquer les mouvements de l\'adversaire et de l\'empêcher de faire de même.';

  @override
  String get whenBoardIsFull => 'Quand le plateau est plein';

  @override
  String get whenBoardIsFull_Detail =>
      'À la fin de la phase de placement, avant le début de la phase de déplacement, cette action se dénoule si le plateau est plein de pièces.';

  @override
  String get sideToMoveRemovePiece =>
      'Le joueur qui se déplace en premier dans la phase de déplacement retire une des pièces de l\'adversaire.';

  @override
  String get agreeToDraw => 'Les deux camps conviennent d\'un match nul.';

  @override
  String get takeOpponentsPiece => 'Prenez une des pièces de votre adversaire.';

  @override
  String get firstPlayerLose => 'Le premier joueur perd la partie.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Les premier et deuxième joueurs retirent une des pièces de l\'adversaire.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Les deuxième et premier joueurs enlèvent une des pièces de l\'adversaire.';

  @override
  String get enteredFlyingPhase =>
      'Maintenant la phase de vol débutée, les pièces de l\'adversaire peuvent sauter vers n\'importe quel point vide du plateau. Vous pouvez désactiver la règle de vol dans les \"Paramètres de règle\".';

  @override
  String get whenStalemate => 'Quand il y a impasse';

  @override
  String get whenStalemate_Detail =>
      'Quelle action effectuer lorsqu\'aucune pièce ne peut être déplacée ?';

  @override
  String get endWithStalemateLoss =>
      'Terminez par une défaite par impasse pour le camp qui est bloqué.';

  @override
  String get changeSideToMove => 'Changez de côté pour vous déplacer.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Retirez l\'une des pièces de l\'adversaire et effectuez le coup suivant.';

  @override
  String get endWithStalemateDraw => 'Terminez par un match nul.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Retirez l\'une des pièces de l\'adversaire et changez de côté pour vous déplacer.';

  @override
  String get aiResponseDelayTime => 'Délai de réponse de l\'IA';

  @override
  String get aiIsDelaying =>
      'L\'IA est actuellement en phase de réponse différée. Veuillez patienter un moment avant de continuer.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Vous ne pouvez pas retirer une pièce non adjacente.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'En cas d\'impasse, les pièces de l\'adversaire adjacentes aux vôtres peuvent être retirées, quelle que soit la formation du moulin.';

  @override
  String get whatIsMcts =>
      'MCTS est un algorithme adapté aux débutants qui prend des décisions en explorant et en évaluant différents mouvements à travers des simulations.';

  @override
  String get goldenJade => 'Jade dorée';

  @override
  String get forestWood => 'Bois de la forêt';

  @override
  String get darkMystery => 'Sombre mystère';

  @override
  String get midnightBlue => 'Bleu nuit';

  @override
  String get greenForest => 'Forêt verte';

  @override
  String get greenMeadow => 'Prairie verte';

  @override
  String get stonyPath => 'Chemin pierreux';

  @override
  String get pastelPink => 'Rose pastel';

  @override
  String get turquoiseSea => 'Mer turquoise';

  @override
  String get violetDream => 'Rêve violet';

  @override
  String get mintChocolate => 'Chocolat à la menthe';

  @override
  String get skyBlue => 'Bleu ciel';

  @override
  String get playfulGarden => 'Jardin joueur';

  @override
  String get whatIsRetrogradeAnalysis =>
      'L\'algorithme d\'Analyse Rétrograde utilise une analyse rétrograde à plusieurs valeurs pour créer une base de données de fin de partie à partir de différentes positions de départ, puis applique cette base de données pour optimiser le gameplay. Cette approche entre dans la catégorie des solutions Ultra-Fortes.';

  @override
  String get viewAlgorithmGuide =>
      'Souhaitez-vous consulter le guide d\'utilisation de cet algorithme ?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Afficher l\'indicateur d\'avantage positionnel';

  @override
  String get usePerfectDatabase => 'Utilisez la base de données parfaite';

  @override
  String get perfectDatabaseDescription =>
      'Activez cette option pour utiliser une base de données de jeu impeccable générée par des algorithmes de pointe. Cette fonctionnalité intègre à la fois des stratégies d\'ouverture et de fin de partie pour suggérer les meilleurs mouvements. C\'est le choix préféré pour les joueurs qui recherchent le plus haut niveau de précision dans le gameplay. Créée grâce à des techniques de calcul minutieuses, la base de données est conçue pour offrir des solutions de jeu pratiquement parfaites.\n\nNote : Si l\'IA ne parvient pas à accéder à la base de données, elle se tournera vers des algorithmes conventionnels pour les décisions de jeu. Lorsque la base de données est disponible, le \'Niveau de difficulté\' devient pratiquement imbattable, et le \'Temps de réflexion de l\'IA\' connaît une réduction drastique. De nombreux paramètres dans les options \'Style de jeu de l\'IA\' seront également écrasés, car les résultats de la base de données ont la priorité la plus élevée.\n\nPour des conseils sur la façon d\'exploiter au mieux cette base de données impeccable, cliquez ici.';

  @override
  String get backgroundImage => 'Image d\'arrière-plan';

  @override
  String get whatIsRandom =>
      'Lorsque l\'option \'Utiliser la base de données parfaite\' n\'est pas activée, le réglage \'Aléatoire\' entraîne des déplacements aléatoires des pièces par l\'IA, sans utiliser d\'algorithme de sélection de mouvement. Cela entraîne généralement un jeu nettement moins performant. En revanche, lorsque l\'option \'Utiliser la base de données parfaite\' est activée, l\'IA se base exclusivement sur la \'Base de Données Parfaite\' pour prendre des décisions, au lieu de la combiner avec des algorithmes d\'IA traditionnels. Dans ce mode, les mouvements de l\'IA sont entièrement basés sur le contenu de la base de données, évitant ainsi de dépendre de calculs en temps réel ou d\'algorithmes de recherche.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Retirez la/les pièce(s) de l\'adversaire de sa main ; puis c\'est au tour de l\'adversaire de placer.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Lors de la formation de moulins pendant la phase de placement';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Retirez la/les pièce(s) de l\'adversaire du plateau.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Retirez la/les pièce(s) de l\'adversaire du plateau ; puis c\'est au tour de l\'adversaire de placer.';

  @override
  String get opponentRemovesOwnPiece =>
      'L\'adversaire retire sa/ses propre(s) pièce(s) du plateau.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Au lieu que vous agissiez, l\'adversaire choisit et retire sa/ses propre(s) pièce(s) du plateau, effectuant ainsi une action qui lui est préjudiciable.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Retirez la/les pièce(s) de l\'adversaire de sa main ; puis c\'est à votre tour de jouer.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Retirez la/les pièce(s) de la main de l\'adversaire. Si, selon le réglage Multi-retrait, plusieurs pièces doivent être retirées et que l\'adversaire n\'a plus de pièces en main, continuez à retirer les pièces de l\'adversaire du plateau. Ensuite, c\'est à votre tour de jouer. Si vous continuez à former des moulins, vous pouvez continuer à retirer les pièces de l\'adversaire.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Retirez la/les pièce(s) de la main de l\'adversaire. Si, selon le réglage Multi-retrait, plusieurs pièces doivent être retirées et que l\'adversaire n\'a plus de pièces en main, continuez à retirer les pièces de l\'adversaire du plateau. Ensuite, c\'est au tour de l\'adversaire de jouer.';

  @override
  String get markAndDelayRemovingPieces =>
      'Marquez et retardez le retrait des pièces.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Pendant la phase de placement, les pièces à retirer sont marquées et, pour les deux joueurs, aucune nouvelle pièce ne peut être placée sur ces points. En entrant dans la phase de déplacement, ces pièces marquées sont retirées ensemble, et les joueurs peuvent alors déplacer leurs pièces sur ces points maintenant vides.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Les actions qui peuvent être prises lors de la formation des moulins pendant la phase de placement.';

  @override
  String get marked => 'Marqué';

  @override
  String get menu => 'Menu';

  @override
  String get monochrome => 'Monochrome';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Vous pouvez activer le support du lecteur d\'écran dans les réglages d\'Accessibilité des Paramètres généraux.';

  @override
  String get showNumbersOnPieces => 'Afficher les numéros sur les pièces';

  @override
  String get saveImage => 'Enregistrer l\'image';

  @override
  String get isAnalysisToolbarShown => 'Afficher la barre d\'outils d\'analyse';

  @override
  String get analysisToolbarBackgroundColor =>
      'Couleur d\'arrière-plan de la barre d\'outils d\'analyse';

  @override
  String get analysisToolbarIconColor =>
      'Couleur de l\'icône de la barre d\'outils d\'analyse';

  @override
  String get transformed => 'Transformé.';

  @override
  String get cannotTransform => 'Impossible de transformer.';

  @override
  String get rotate => 'Rotation';

  @override
  String get horizontalFlip => 'Ret. H';

  @override
  String get verticalFlip => 'Ret. V';

  @override
  String get innerOuterFlip => 'Ret. I/E';

  @override
  String get transparentCanvas => 'Toile Transparente';

  @override
  String get restrictRepeatedMillsFormation =>
      'Restreindre la formation répétée de moulins';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Une pièce déplacée d\'un moulin pour en former un autre ne peut pas immédiatement retourner au point original au tour suivant pour former à nouveau un moulin. Un autre mouvement est requis d\'abord.';

  @override
  String get oneTimeUseMill => 'Moulin à usage unique';

  @override
  String get oneTimeUseMill_Detail =>
      'Chaque moulin peut retirer une pièce de l\'adversaire une seule fois. Vous pouvez le reformer à nouveau, mais il ne peut pas être utilisé pour des suppressions supplémentaires.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Les règles actuelles que vous avez définies n\'ont pas de base de données parfaite correspondante. Pour plus d\'informations sur la base de données parfaite, veuillez cliquer ici.';

  @override
  String get focusOnBlockingPaths =>
      'Concentrez-vous sur le blocage des chemins';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Durant des phases spécifiques du jeu, privilégiez l\'obstruction des mouvements de l\'adversaire plutôt que la formation de moulins. Au lieu de se concentrer sur le retrait des pièces en complétant des moulins, l\'IA vise à piéger l\'adversaire pendant ces phases, le rendant incapable de se déplacer et assurant une victoire par attrition plutôt que par un jeu agressif. Cette stratégie spécifique à certaines phases ne bloque pas activement les moulins de l\'adversaire.';

  @override
  String get pieceImage => 'Image de pièce';

  @override
  String get importColorSettings => 'Importer les paramètres de couleur';

  @override
  String get exportColorSettings => 'Exporter les paramètres de couleur';

  @override
  String get import => 'Importer';

  @override
  String get export => 'Exporter';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Veuillez d\'abord copier les paramètres du format JSON dans le presse-papiers.';

  @override
  String get copiedToClipboard => 'Copié dans le presse-papiers.';

  @override
  String get imported => 'Importé.';

  @override
  String get boardImage => 'Image du plateau';

  @override
  String get autumnLeaves => 'Feuilles d\'Automne';

  @override
  String get legendaryLand => 'Terre Légendaire';

  @override
  String get vignetteEffect => 'Effet de vignettage';

  @override
  String get promptMakeToolbarTransparent =>
      'Souhaitez-vous rendre la barre d\'outils complètement transparente lorsqu\'une image de fond du plateau est définie?';

  @override
  String get vibration => 'Activer la vibration dans le jeu';

  @override
  String get soundTheme => 'Thème sonore';

  @override
  String get ball => 'Balle';

  @override
  String get liquid => 'Liquide';

  @override
  String get wood => 'Bois';

  @override
  String get placeEffectAnimation =>
      'Effet d\'animation lors du placement de la pièce';

  @override
  String get removeEffectAnimation =>
      'Effet d\'animation lors du retrait de la pièce';

  @override
  String get isToolbarAtBottom => 'Afficher la barre d\'outils en bas';

  @override
  String get boardCornerRadius => 'Rayon de coin du plateau';

  @override
  String get useOpeningBook => 'Utiliser le livre d\'ouverture';

  @override
  String get currentRule => 'Actuel';

  @override
  String get nineMensMorris => 'Morris neuf hommes';

  @override
  String get twelveMensMorris => 'Morris douze hommes';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Douz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Ensemble de règles';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'Moulin unique';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'Permettez à l\'IA d\'utiliser des mouvements d\'ouverture couramment employés par les joueurs humains professionnels au début du jeu. Remarque: Cette fonctionnalité est actuellement disponible uniquement pour certains ensembles de règles.';

  @override
  String get showAdvantageGraph => 'Afficher le graphique d’avantage';

  @override
  String get advantageGraphHint =>
      'Le graphique d\'avantage ne sera tracé qu\'après que l\'IA aura effectué un mouvement. Il ne sera pas tracé lorsque le joueur humain effectuera un mouvement.';

  @override
  String get removalBasedOnMillCounts =>
      'La suppression est interdite jusqu’à ce que toutes les pièces aient été placées, puis les joueurs retirent des pièces en fonction du nombre de moulins formés.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'La suppression est interdite jusqu’à ce que toutes les pièces aient été placées, puis les joueurs retirent des pièces en fonction du nombre de moulins formés : si les nombres sont égaux, les deux retirent le même nombre de pièces ; si l’un d’eux a formé plus de moulins, il retire une pièce supplémentaire, maintenant ainsi une différence d’une seule pièce. Si un seul joueur forme des moulins, il retire deux pièces tandis que l’autre en retire une. Si aucun des deux ne forme de moulins, chacun retire l’une de ses propres pièces.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Sélectionnez l’un de vos pions.';

  @override
  String get notYourTurn => 'Ce n\'est pas votre tour.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Couleur d\'arrière-plan de la barre d\'outils d\'annotation';

  @override
  String get annotationToolbarIconColor =>
      'Couleur des icônes de la barre d\'outils d\'annotation';

  @override
  String get isAnnotationToolbarShown =>
      'Afficher la barre d\'outils d\'annotation';

  @override
  String get enterAnnotationMode => 'Entrer en mode annotation';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Êtes-vous sûr de vouloir effacer toutes les annotations ?';

  @override
  String get llmPromptCopiedToClipboard =>
      'Invite LLM copiée dans le presse-papiers.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Connexion refusée, le serveur peut être hors ligne.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Découverte réussie, en attente de connexion...';

  @override
  String get noLanConnection => 'Aucune connexion LAN';

  @override
  String get takeScreenshot => 'Prendre une capture d\'écran';

  @override
  String get disconnectedFromOpponent => 'Déconnecté de l\'adversaire.';

  @override
  String get takeBackRequest => 'Demande de retour en arrière';

  @override
  String get nothingToShow => 'Rien à afficher.';

  @override
  String get stopHosting => 'Arrêter l\'hébergement';

  @override
  String get connectionResetByPeer =>
      'Connexion réinitialisée par l\'hôte distant.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Connexion perdue en raison d\'un délai d\'attente du signal de vie. Veuillez vous reconnecter.';

  @override
  String get startHosting => 'Démarrer l\'hébergement';

  @override
  String get restartRequestRejected => 'Demande de redémarrage rejetée.';

  @override
  String get notConnectedToLanOpponent => 'Pas connecté à un adversaire LAN.';

  @override
  String get llmPrompt => 'Invite LLM';

  @override
  String get gameRestarted => 'Partie relancée.';

  @override
  String get takeBackRejected => 'Retour en arrière refusé.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Êtes-vous sûr de vouloir abandonner cette partie ?';

  @override
  String get opponentResignedYouWin =>
      'L\'adversaire a abandonné. Vous gagnez !';

  @override
  String get clearAllAnnotations => 'Effacer toutes les annotations';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Connecté, en attente du coup de l\'adversaire...';

  @override
  String get networkStatusDisconnected => 'État du réseau : Déconnecté';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Demande de retour en arrière envoyée à l\'adversaire.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'L\'adversaire a peut-être quitté la partie';

  @override
  String get connectedToHostSuccessfully => 'Connecté à l\'hôte avec succès.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Connexion perdue : délai d\'attente du signal de vie';

  @override
  String get noHostDiscovered => 'Aucun hôte découvert.';

  @override
  String get confirmResignation => 'Confirmer l\'abandon';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Hébergement de la partie démarré, en attente de joueurs...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Délai de connexion dépassé, connexion réseau instable.';

  @override
  String get noLlmPromptAvailable => 'Aucune invite LLM disponible.';

  @override
  String get youResignedGameOver => 'Vous avez abandonné. Fin de la partie.';

  @override
  String get serverIp => 'IP du serveur';

  @override
  String get confirmClear => 'Confirmer l\'effacement';

  @override
  String get opponentSTurn => 'C\'est le tour de l\'adversaire.';

  @override
  String get waitingAClientConnection =>
      'En attente d\'une connexion client...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'La demande de retour en arrière a été refusée ou a échoué.';

  @override
  String get addText => 'Ajouter du texte';

  @override
  String get exitAnnotationMode => 'Quitter le mode annotation';

  @override
  String get typeYourAnnotation => 'Tapez votre annotation';

  @override
  String get attemptingToReconnect => 'Tentative de reconnexion...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Demande de redémarrage envoyée. En attente de la réponse de l\'adversaire...';

  @override
  String get serverIsStopped => 'Le serveur est arrêté.';

  @override
  String get restartRequest => 'Demande de redémarrage';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Impossible de demander un retour en arrière quand ce n\'est pas votre tour.';

  @override
  String get takeBackAccepted => 'Retour en arrière accepté.';

  @override
  String get localNetworkSettings => 'Paramètres du réseau local';

  @override
  String get reconnectedSuccessfully => 'Reconnexion réussie !';

  @override
  String get failedToSaveImageToGallery =>
      'Échec de l\'enregistrement de l\'image dans la galerie.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'L\'adversaire demande à redémarrer la partie. Acceptez-vous ?';

  @override
  String get yourTurn => 'C\'est votre tour.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Impossible de se reconnecter, veuillez redémarrer la partie.';

  @override
  String get host => 'Héberger';

  @override
  String get join => 'Rejoindre';

  @override
  String get port => 'Port';

  @override
  String get invalidIpAddress => 'Adresse IP invalide.';

  @override
  String get invalidPort => 'Port invalide.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Connexion : tentative $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Échec de la connexion : $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Échec du démarrage de l\'hébergement : $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Hôte découvert : $ip:$port';
  }

  @override
  String get stop => 'Arrêter';

  @override
  String get discover => 'Découvrir';

  @override
  String get connect => 'Se connecter';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Client connecté : $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Découverte : $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Reconnexion ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Connecté';

  @override
  String get delete => 'Supprimer';

  @override
  String get ancientEgypt => 'Égypte ancienne';

  @override
  String get gothicIce => 'Glace gothique';

  @override
  String get riceField => 'Champ de riz';

  @override
  String get chinesePorcelain => 'Porcelaine chinoise';

  @override
  String get desertDusk => 'Crépuscule du désert';

  @override
  String get precisionCraft => 'Artisanat de précision';

  @override
  String get folkEmbroidery => 'Broderie folklorique';

  @override
  String get carpathianHeritage => 'Héritage des Carpates';

  @override
  String get imperialGrandeur => 'Grandeur impériale';

  @override
  String get bohemianCrystal => 'Cristal de Bohême';

  @override
  String get savannaSunrise => 'Lever de soleil dans la savane';

  @override
  String get harmonyBalance => 'Harmonie et équilibre';

  @override
  String get cinnamonSpice => 'Épice de cannelle';

  @override
  String get anatolianMosaic => 'Mosaïque anatolienne';

  @override
  String get carnivalSpirit => 'Esprit de carnaval';

  @override
  String get custom => 'Personnalisé';

  @override
  String get spiceMarket => 'Marché aux épices';

  @override
  String get swipeToRevealTheDrawer => 'Faites glisser pour révéler le tiroir';

  @override
  String get showGameInfoOnScreenshots =>
      'Afficher les informations de jeu sur les captures d\'écran';

  @override
  String get humanMoveTime => 'Limite de temps humain';

  @override
  String get noTimeLimitForHumanMoves =>
      'Pas de limite de temps pour les coups humains';

  @override
  String get timeoutLoseWillBeApplied =>
      'La perte par dépassement de temps sera appliquée pour le joueur humain';

  @override
  String get identifyingBoard => 'Identification du plateau...';

  @override
  String get youCanEnterAnyModelName =>
      'Vous pouvez saisir n\'importe quel nom de modèle.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Position du plateau appliquée. FEN copié dans le presse-papiers.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Suggestion : essayez de prendre une photo plus nette du plateau.';

  @override
  String get llmPromptTemplate => 'Modèle de prompt LLM';

  @override
  String get noValidBoardDetected => 'Aucun plateau valide détecté.';

  @override
  String get selectingImageFromAlbum =>
      'Sélection d\'une image depuis l\'album...';

  @override
  String get configurePromptTemplate => 'Configurer le modèle de prompt';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Modifier le modèle de prompt pour l\'analyse LLM';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Échec de la génération du FEN à partir du plateau reconnu.';

  @override
  String get outputInCurrentLanguage => 'Sortie dans la langue actuelle';

  @override
  String get commonBaseUrls => 'Base URL communes';

  @override
  String get viewCommonModels => 'Voir les modèles courants';

  @override
  String get recognitionParametersUpdated =>
      'Paramètres de reconnaissance mis à jour.';

  @override
  String get whiteSMove => 'Coup des blancs';

  @override
  String get resetToDefaults => 'Réinitialiser aux valeurs par défaut';

  @override
  String get photoShoot => 'Séance photo';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Échec de l\'application de la position reconnue du plateau.';

  @override
  String get llmPromptContent => 'Contenu du prompt LLM';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM non configuré. Veuillez vérifier vos paramètres.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Définir le fournisseur, le modèle, l\'API Key et le Base URL';

  @override
  String get llmConfiguration => 'Configuration LLM';

  @override
  String get configureLlmProvider => 'Configurer le fournisseur LLM';

  @override
  String get llmPromptTemplateHeader => 'En-tête du modèle de prompt LLM';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Aucune pièce n\'a été détectée sur l\'image. Veuillez réessayer.';

  @override
  String get recognizeBoardFromImage =>
      'Reconnaître le plateau à partir de l\'image';

  @override
  String get viewTips => 'Voir les conseils';

  @override
  String get applyToBoard => 'Appliquer au plateau';

  @override
  String get adjustBoardArea => 'Ajuster la zone du plateau';

  @override
  String get viewCommonUrls => 'Voir les URL communes';

  @override
  String get colorAnalysisFailed => 'Échec de l\'analyse des couleurs !';

  @override
  String get analyzingGameBoardImage =>
      'Analyse de l\'image du plateau de jeu...';

  @override
  String get selectFromAlbum => 'Sélectionner depuis l\'album';

  @override
  String get noBoardPointDetected => 'Aucun point du plateau détecté !';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Si laissé vide, le modèle par défaut sera utilisé';

  @override
  String get llmConfig => 'Configuration LLM';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Êtes-vous sûr de vouloir réinitialiser les modèles de prompt aux valeurs par défaut ?';

  @override
  String get llmPromptTemplateFooter => 'Pied de page du modèle de prompt LLM';

  @override
  String get loadingResponse => 'Chargement de la réponse...';

  @override
  String get applyThisResultToBoard => 'Appliquer ce résultat au plateau';

  @override
  String get takingPicture => 'Prise de vue...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Veuillez sélectionner une image du plateau de jeu à identifier';

  @override
  String get identificationResults => 'Résultats de l\'identification';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Analysez les coups et fournissez des informations.';

  @override
  String get getApiKey => 'Obtenir l\'API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Le processus complet de reconnaissance n\'a pas pu être terminé.';

  @override
  String get boardRecognitionResult =>
      'Résultat de la reconnaissance du plateau';

  @override
  String get askLlm => 'Interroger LLM';

  @override
  String get boardDetectionFailed => 'Échec de la détection du plateau !';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Aucun point du plateau détecté, impossible d\'identifier une pièce !';

  @override
  String get copyFen => 'Copier le FEN';

  @override
  String get commonlyUsedModels => 'Modèles couramment utilisés';

  @override
  String get apiKeyOptional => 'API Key (optionnelle)';

  @override
  String get noImageSelected => 'Aucune image sélectionnée';

  @override
  String get blackSMove => 'Coup des noirs';

  @override
  String get llm => 'Grand Modèle de Langage';

  @override
  String get llmProvider => 'Fournisseur';

  @override
  String get baseUrl => 'URL de base';

  @override
  String get model => 'Modèle';

  @override
  String get temperature => 'Température';

  @override
  String get llmCommandReceivedProcessing => 'Commande reçue ! L\'IA traite...';

  @override
  String get llmDeepThinkingWait =>
      'Réflexion approfondie en cours, veuillez patienter...';

  @override
  String get llmPresentingSoon => 'Présentation imminente...';

  @override
  String get recognitionParameters => 'Paramètres de reconnaissance';

  @override
  String get adjustParamsDesc =>
      'Ajustez les paramètres pour améliorer la précision de la reconnaissance';

  @override
  String get saveParameters => 'Enregistrer les paramètres';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Impossible de démarrer la reconnaissance d\'image : $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Échec de la reconnaissance d\'image : $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Position appliquée avec $whiteCount pions blancs et $blackCount pions noirs';
  }

  @override
  String get fenCopiedToClipboard => '(FEN copié dans le presse‑papiers)';

  @override
  String recognitionFailed(String error) {
    return 'Échec de la reconnaissance : $error';
  }

  @override
  String get myRating => 'Mon classement';

  @override
  String get gamesPlayed => 'Parties jouées';

  @override
  String get wins => 'Victoires';

  @override
  String get losses => 'Défaites';

  @override
  String get draws => 'Matchs nuls';

  @override
  String get lastUpdated => 'Dernière mise à jour';

  @override
  String get format => 'Format :';

  @override
  String get resetStatistics => 'Réinitialiser les statistiques';

  @override
  String get drawRate => 'Taux de matchs nuls';

  @override
  String get lossRate => 'Taux de défaites';

  @override
  String get aiStatistics => 'Statistiques de l\'IA';

  @override
  String get enableStatistics => 'Activer les statistiques';

  @override
  String get enableStatistics_Detail =>
      'Lorsque cette option est activée, les résultats des parties sont enregistrés dans les statistiques. Cependant, les parties impliquant des retours en arrière ne sont pas enregistrées. Lorsque cette option est désactivée, la collecte des statistiques est suspendue.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Cela réinitialisera toutes les statistiques du jeu. Cette action est irréversible.';

  @override
  String get boardInnerRingSize => 'Taille de l\'anneau intérieur du plateau';

  @override
  String get boardShadowEnabled => 'Ombre du plateau';

  @override
  String get trapAwareness => 'Détection des pièges';

  @override
  String get trapAwarenessDescription =>
      'Mettre en évidence les coups piège avec des cercles et des flèches en gras pendant l\'analyse.';

  @override
  String trapExists(String trapMoves) {
    return 'Un piège existe. Coups piège : $trapMoves';
  }

  @override
  String get custodianCapture => 'Capture flanquante';

  @override
  String get custodianCaptureDescription =>
      'Enclopez l\'une des pièces de votre adversaire entre deux de la vôtre en ligne droite pour la capturer.';

  @override
  String get custodianCaptureEnable => 'Laisser flanquer une capture';

  @override
  String get interventionCapture => 'Capture d\'intervention';

  @override
  String get interventionCaptureDescription =>
      'Déplacez-vous dans le point vide entre deux des pièces de votre adversaire pour les capturer tous les deux.';

  @override
  String get interventionCaptureEnable =>
      'Autoriser la capture d\'intervention';

  @override
  String get leapCapture => 'Capture de saut';

  @override
  String get leapCaptureDescription =>
      'Capturez en sautant par-dessus la pièce d\'un adversaire adjacent dans le point vide au-delà.';

  @override
  String get leapCaptureEnable => 'Laisser la capture de saut';

  @override
  String get captureApplicableLines => 'Lignes applicables';

  @override
  String get captureSquareEdges => 'Le long des bords du carré';

  @override
  String get captureCrossLines =>
      'Le long des lignes orthogonales traversant le carré';

  @override
  String get captureDiagonalLines =>
      'Le long des lignes diagonales traversant le carré';

  @override
  String get captureExecutionPhases => 'Phases d\'exécution';

  @override
  String get capturePiecesCondition =>
      'Disponibilité pendant la phase mobile basée sur les pièces restantes';

  @override
  String get capturePiecesConditionUnlimited => 'Aucune restriction';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Disponible lorsque vous avez trois pièces ou moins';
}
