// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Finnish (`fi`).
class SFi extends S {
  SFi([String locale = 'fi']) : super(locale);

  @override
  String get appName => 'Mylly';

  @override
  String get welcome => 'Tervetuloa';

  @override
  String get yes => 'Kyllä';

  @override
  String get no => 'Ei';

  @override
  String get game => 'Peli';

  @override
  String get humanVsAi => 'Ihminen vs. tekoäly';

  @override
  String get humanVsHuman => 'Ihminen vs. ihmisen';

  @override
  String get aiVsAi => 'Tekoäly vs. tekoäly';

  @override
  String get humanVsCloud => 'Ihminen vs. pilvi';

  @override
  String get humanVsLAN => 'Ihminen vs. LAN';

  @override
  String get testViaLAN => 'Testi LAN:n kautta';

  @override
  String get move => 'Siirrä';

  @override
  String get showMoveList => 'Siirtolista';

  @override
  String get moveList => 'Siirtolista';

  @override
  String get noGameRecord => 'Ei tietuetta';

  @override
  String get ok => 'Hyvä on';

  @override
  String get confirm => 'Vahvista';

  @override
  String get cancel => 'Peruuta';

  @override
  String get tipSelectWrong => 'Valitsit väärän nappulan.';

  @override
  String get tipPlace => 'Sijoita nappulasi paikoilleen.';

  @override
  String get tipBanPlace => 'Et voi sijoittaa sitä tähän.';

  @override
  String get tipPlaced => 'Asetit nappulan.';

  @override
  String get tipRemove => 'Poista nappula.';

  @override
  String get tipBanRemove => 'Et voi poistaa sitä.';

  @override
  String get tipRemoved => 'Poistit nappulan.';

  @override
  String get tipMove => 'Siirrä nappula.';

  @override
  String get tipCannotPlace => 'Et voi sijoittaa nappulaa tähän.';

  @override
  String get tipCannotMove => 'Et voi siirtää nappulaa tähän.';

  @override
  String get tipMill => 'Mylly! Ota vastustajan nappula.';

  @override
  String get tipContinueMill => 'Jatka vastustajan nappulan ottamista.';

  @override
  String get tipSelectOpponentsPiece => 'Valitse yksi vastustajan nappuloista.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Et voi poistaa nappulaa myllystä.';

  @override
  String get tipCanMoveOnePoint => 'Nappula voi liikkua yhden pisteen.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Et voi siirtää vastustajan nappuloita.';

  @override
  String get tipSelectPieceToMove => 'Valitse siirrettävä nappula.';

  @override
  String get tipHaveThreePiecesLeft => 'Sinulla on kolme nappulaa jäljellä.';

  @override
  String get tipCanMoveToAnyPoint => 'Voit liikkua mihin tahansa kohtaan.';

  @override
  String tipToMove(Object player) {
    return 'Siirrettävä $player.';
  }

  @override
  String get whiteWin => 'Pelaaja 1 voittaa!';

  @override
  String get blackWin => 'Pelaaja 2 voittaa!';

  @override
  String get won => 'Voitti';

  @override
  String get lost => 'Hävinnyt';

  @override
  String get thinking => 'Ajattelemassa…';

  @override
  String get newGame => 'Uusi peli';

  @override
  String get importGame => 'Tuo peli';

  @override
  String get exportGame => 'Vie peli';

  @override
  String get gameImported => 'Peli tuotu.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Ei voi tuoda $invalidMove:a';
  }

  @override
  String get movesAndRulesNotMatch => 'Siirrot ja säännöt eivät täsmää.';

  @override
  String get pleaseWait => 'Odota.';

  @override
  String get restartGame => 'Käynnistetäänkö nykyinen peli uudelleen?';

  @override
  String get restart => 'Käynnistä uudelleen';

  @override
  String get gameStarted => 'Peli alkoi; sijoita.';

  @override
  String get analyzing => 'Analysoidaan…';

  @override
  String error(Object message) {
    return 'Virhe: $message';
  }

  @override
  String get winRate => 'Voittosuhde';

  @override
  String get score => 'Pisteet:';

  @override
  String get white => 'Pelaaja 1';

  @override
  String get black => 'Pelaaja 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player:n nappuloiden määrä on alle kolme.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player erosi.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player:lla ei ole keinoa mennä.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Lauta on täynnä, ja $player:lla ei ole keinoa mennä.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Aika on ohi, $player hävisi.';
  }

  @override
  String get drawReasonRule50 =>
      'Siirtovaiheessa yhtään nappulaa ei ole poistettu viimeisen tietyn siirtomäärän aikana.';

  @override
  String get drawReasonBoardIsFull => 'Se on tasapeli, koska lauta on täynnä.';

  @override
  String get drawReasonThreefoldRepetition =>
      'Se on tasapeli kolminkertaisen toiston vuoksi.';

  @override
  String get gameOverUnknownReason => 'Peli on ohi! Tuntematon syy.';

  @override
  String get gameOver => 'Peli ohi';

  @override
  String get youWin => 'Sinä voitit! Onnittelut!';

  @override
  String challengeHarderLevel(int level) {
    return 'Haasta kovempi taso? Uusi taso on taso $level!';
  }

  @override
  String get youLose => 'Hävisit!';

  @override
  String get analyze => 'Analysoi';

  @override
  String get about => 'Tietoja';

  @override
  String version(Object versionNumber) {
    return 'Versio: $versionNumber';
  }

  @override
  String get thanks => 'Kiitos';

  @override
  String get settings => 'Asetukset';

  @override
  String get options => 'Asetukset';

  @override
  String get generalSettings => 'Yleiset asetukset';

  @override
  String get skillLevel => 'Vaikeustaso';

  @override
  String get moveTime => 'Tekoälyn ajatteluaika';

  @override
  String get difficulty => 'Vaikeustaso';

  @override
  String get playSounds => 'Äänitehosteet';

  @override
  String get playSoundsInTheGame => 'Äänien toistaminen pelissä';

  @override
  String get keepMuteWhenTakingBack => 'Pidä mykkä, kun otat takaisin';

  @override
  String get tone => 'Ääni';

  @override
  String get whoMovesFirst => 'Ensimmäinen siirto';

  @override
  String get human => 'Ihminen';

  @override
  String get ai => 'AI';

  @override
  String get alternate => 'Vaihtoehtoinen';

  @override
  String get isAutoRestart =>
      'Automaattinen pelin uudelleenkäynnistys, kun peli on ohi';

  @override
  String get isAutoChangeFirstMove =>
      'Vaihda ensimmäinen siirto automaattisesti';

  @override
  String get shufflingEnabled => 'Satunnainen siirto';

  @override
  String get misc => 'Sekalaista';

  @override
  String get rules => 'Säännöt';

  @override
  String get piecesCount => 'Kunkin pelaajan nappuloiden määrä';

  @override
  String get piecesCount_Detail =>
      'Kuinka monta nappulaa kullakin pelaajalla on?';

  @override
  String get flyPieceCount => 'Lentävän nappulan numero';

  @override
  String get flyPieceCount_Detail =>
      'Jos lentäminen on käytössä, kun pelaajan nappulamäärä vähenee tiettyyn lukumäärään, hänen nappulansa voivat vapaasti siirtyä mihin tahansa tyhjään pisteeseen sen sijaan, että ne olisivat rajoitettuja viereisiin pisteisiin, kuten muussa pelissä.';

  @override
  String get piecesAtLeastCount => 'Vähintään nappuloita';

  @override
  String get hasDiagonalLines => 'Diagonaaliviivat';

  @override
  String get hasDiagonalLines_Detail => 'Lisää pelilaudalle neljä vinoviivaa.';

  @override
  String get isDefenderMoveFirst => 'Toinen pelaaja siirtyy ensin';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Pelaaja, joka liikkuu toisena sijoitusvaiheessa, liikkuu ensimmäisenä siirtovaiheessa.';

  @override
  String get mayRemoveMultiple => 'Monta poistoa';

  @override
  String get mayRemoveMultiple_Detail =>
      'Jos pelaaja sulkee useamman kuin yhden myllyn kerralla, hän poistaa suljettujen myllyjen määrän.';

  @override
  String get mayRemoveFromMillsAlways => 'Myllyjen tuhoaminen';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Oletusarvoisesti pelaajien on ensin poistettava kaikki muut nappulat ennen nappulan poistamista muodostetusta myllystä. Ota tämä vaihtoehto käyttöön, jos haluat poistaa rajoituksen käytöstä.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Toinen pelaaja häviää, kun lauta on täynnä';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Kun lauta on täynnä sijoitusvaiheen lopussa, ensimmäisenä sijoittava osapuoli häviää pelin. Muussa tapauksessa peli on tasapeli.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Häviää, kun ei ole laillisia siirtoja';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Pelaaja häviää, jos hänen vastustajansa estää ne niin, ettei niitä voi siirtää. Vaihda puoli siirtoon, jos tämä vaihtoehto on poistettu käytöstä.';

  @override
  String get mayFly => 'Lentävä';

  @override
  String get mayFly_Detail =>
      'Jos pelaajalla on jäljellä vain kolme tai neljä (määritettävissä olevaa) nappulaa, hän voi siirtää nappulan mihin tahansa vapaaseen pisteeseen.';

  @override
  String get nMoveRule => 'N-siirron sääntö';

  @override
  String get nMoveRule_Detail =>
      'Peli päättyy tasapeliin, jos kumpikaan pelaaja ei ole poistanut nappulaa tietyn määrän siirtoja aikana.';

  @override
  String get rollback => 'Palautus';

  @override
  String get pleaseSelect => 'Valitse';

  @override
  String get copy => 'Kopioi';

  @override
  String get moveHistoryCopied => 'Siirtohistoria kopioidaan leikepöydälle.';

  @override
  String get help => 'Ohje';

  @override
  String get feedback => 'Palaute';

  @override
  String get exit => 'Poistu';

  @override
  String get ruleSettings => 'Sääntöasetukset';

  @override
  String get color => 'Väri';

  @override
  String get boardColor => 'Taulun väri';

  @override
  String get pieceColor => 'Kappaleen väri';

  @override
  String get backgroundColor => 'Taustan väri';

  @override
  String get lineColor => 'Pelilaudan viivan väri';

  @override
  String get whitePieceColor => 'Pelaajan 1 palan väri';

  @override
  String get blackPieceColor => 'Pelaajan 2 palan väri';

  @override
  String get messageColor => 'Viestin väri';

  @override
  String get isPieceCountInHandShown =>
      'Näytä kädessä olevien nappuloiden määrä';

  @override
  String get isNotationsShown => 'Näytä merkinnät laudalla';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Näytä historian navigointityökalurivi';

  @override
  String get display => 'Näytä';

  @override
  String get boardBorderLineWidth => 'Laudan reunaviivan leveys';

  @override
  String get boardInnerLineWidth => 'Laudan sisäisen viivan leveys';

  @override
  String get pieceWidth => 'Kappaleen leveys';

  @override
  String get fontSize => 'Fontin koko';

  @override
  String get standardNotation => 'WMD-merkintä';

  @override
  String get restore => 'Palauta';

  @override
  String get restoreDefaultSettings => 'Palauta oletusasetukset';

  @override
  String pick(Object element) {
    return 'Valitse $element';
  }

  @override
  String get info => 'Info';

  @override
  String get hint => 'Vihje';

  @override
  String get player => 'pelaaja';

  @override
  String get player1 => 'Pelaaja 1';

  @override
  String get player2 => 'Pelaaja 2';

  @override
  String get howToPlay => 'Pelaaminen';

  @override
  String get toPlacePiece =>
      'Aseta nappula paikalleen napauttamalla mitä tahansa käytettävissä olevaa pistettä.';

  @override
  String get toSelectPiece => 'Siirrä nappulaa napauttamalla sitä.';

  @override
  String get toMovePiece =>
      'Siirrä nappulaa napauttamalla nappulaan liittyvää pistettä.';

  @override
  String get toRemovePiece =>
      'Napauta vastustajan yhtä nappulaa poistaaksesi sen.';

  @override
  String get needToCreateMillFirst =>
      'Sinun on ensin luotava mylly, ennen kuin voit poistaa kappaleen.';

  @override
  String get needToPlayWithOwnPieces => 'Sinun on pelattava kappaleillasi.';

  @override
  String get statistics => 'Tilastot';

  @override
  String get totalGames => 'Pelejä yhteensä';

  @override
  String get results => 'Tulokset';

  @override
  String get left => 'vasen';

  @override
  String get privacyPolicy => 'Yksityisyyden suoja';

  @override
  String get privacyPolicy_Detail_1 =>
      'Lue huolellisesti ja varmista, että ymmärrät tämän täysin ja hyväksyt sen ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Jos et hyväksy tätä käytäntöä, älä käytä tätä sovellusta. Sovelluksen käyttäminen tarkoittaa, että hyväksyt nämä ehdot.';

  @override
  String get and => ' ja ';

  @override
  String get accept => 'Hyväksyn';

  @override
  String get takeBack => 'Ota takaisin';

  @override
  String get takingBack => 'Takaisin ottaminen…';

  @override
  String get waiting => 'Odottaminen…';

  @override
  String get stepForward => 'Astu eteenpäin';

  @override
  String get takeBackAll => 'Ota kaikki takaisin';

  @override
  String get stepForwardAll => 'Vaihe eteenpäin kaikki';

  @override
  String get moveNow => 'Siirtykää nyt';

  @override
  String get done => 'Valmis.';

  @override
  String get crackMill => 'Crack-mylly';

  @override
  String get crackMill_Detail =>
      'Jos pelaajalla on vain paloja myllyissä, myllyissä olevat palat eivät lukitu poistettaviksi.';

  @override
  String get animationDuration => 'Animaation kesto';

  @override
  String get none => 'Ei ole';

  @override
  String get theme => 'Teema';

  @override
  String get helpContent =>
      'Pelin tavoitteena on jättää vastustajalle vähemmän kuin kolme nappulaa tai ei yhtään laillista siirtoa.\n\nPeli päättyy automaattisesti tasapeliin, jos asema esiintyy kolmannen kerran tai ei poista viimeisen 100 (määritettävissä olevan) siirron aikana.\n\nPeli etenee kolmessa vaiheessa:\n\n1. Asetetaan nappuloita vapaisiin pisteisiin.\n2. Kappaleiden siirtäminen viereisiin pisteisiin\n3. (valinnainen vaihe) nappuloiden siirtäminen mihin tahansa tyhjään pisteeseen, kun pelaaja on vähentänyt pelaajamääränsä kolmeen nappulaan.\n\nSijoittaminen\n\nPeli alkaa tyhjällä pelilaudalla, joka koostuu ruudukosta, jossa on kaksikymmentäneljä pistettä. Pelaajat asettavat vuorotellen nappulansa tyhjiin pisteisiin, kunnes jokainen pelaaja on asettanut kaikki nappulat pelilaudalle. Jos pelaaja saa asetettua kolme nappulaansa suoraan, hänellä on \"\"mylly\"\" ja hän voi poistaa yhden vastustajan nappulan pelilaudalta.\n\nJoissakin säännöissä pelaajien on ensin poistettava kaikki muut nappulat, ennen kuin he voivat poistaa nappulan muodostuneesta myllystä.\n\nJoissakin säännöissä ei voi sijoitusvaiheessa sijoittaa kappaleita uudelleen poistettujen kappaleiden pisteisiin.\n\nKun olet käyttänyt kaikki palat, pelaajat siirtyvät vuorotellen.\n\nLiikkuminen\n\nSiirtääkseen pelaaja siirtää yhden nappulansa laudan linjaa pitkin vapaaseen viereiseen pisteeseen. Jos hän ei pysty tähän, hän on hävinnyt pelin. Kuten sijoitusvaiheessa, pelaaja, joka asettaa kolme nappulaansa pelilaudan linjalle, saa myllyn ja voi poistaa yhden vastustajan nappulan. Jos pelaajalla on vain kaksi nappulaa, hänellä ei ole mahdollisuutta muodostaa uusia myllyjä ja hän häviää pelin. Pelaaja voi hävitä myös silloin, kun hänellä on enemmän kuin kolme nappulaa, jos hänen vastustajansa estää häntä liikkumasta.\n\nLentävä\n\nJoissakin sääntömuunnelmissa, kun pelaajalla on enää kolme nappulaa jäljellä, hänen nappulansa voivat lentää, hyppiä tai hypätä mihin tahansa vapaaseen pisteeseen, ei vain vierekkäisiin pisteisiin.\n';

  @override
  String get versionInfo => 'Versiotiedot';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'Lisenssi';

  @override
  String get sourceCode => 'Lähdekoodi';

  @override
  String get appVersion => 'Sovelluksen versio';

  @override
  String get general => 'Yleinen';

  @override
  String get advanced => 'Pitkälle kehittynyt';

  @override
  String get placing => 'Sijoittaminen';

  @override
  String get moving => 'Siirtäminen';

  @override
  String get removing => 'Poistaminen';

  @override
  String get gameOverCondition => 'Pelin loppuminen';

  @override
  String get aisPlayStyle => 'Tekoälyn pelityyli';

  @override
  String get passive => 'Passiivinen';

  @override
  String get timeout => 'Aikakatkaisu';

  @override
  String get appearance => 'Ulkonäkö';

  @override
  String get drawOnHumanExperience => 'Hyödynnä inhimillistä kokemusta';

  @override
  String get considerMobility => 'Ota huomioon kappaleiden liikkuvuus';

  @override
  String get pieceCount => 'Palojen määrä:';

  @override
  String inHand(Object player, int count) {
    return '$player kädessä: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player laivalla: $count';
  }

  @override
  String get boardTop => 'Laudan etäisyys yläreunasta';

  @override
  String get notAIsTurn => 'Nyt ei ole tekoälyn vuoro.';

  @override
  String get aiIsNotThinking => 'Tekoäly ei ajattele.';

  @override
  String get atEnd => 'Olet siirtolistasi lopussa.';

  @override
  String get tapBackAgainToLeave => 'Poistu napauttamalla uudelleen takaisin.';

  @override
  String get more => 'Lisää';

  @override
  String get experimental => 'Se on kokeellinen ominaisuus.';

  @override
  String get experiments => 'Kokeilut';

  @override
  String get ossLicenses => 'Avoimen lähdekoodin lisenssit';

  @override
  String get language => 'Kieli';

  @override
  String get defaultLanguage => 'Oletuskieli';

  @override
  String get mayMoveInPlacingPhase =>
      'Kappaleet voivat liikkua sijoitusvaiheessa';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Pelissä ei ole erillisiä sijoitus- ja siirtovaiheita, eli pelaajat voivat jokaisella siirrolla päättää, haluavatko he sijoittaa nappulan pelilaudalle vai siirtää yhden nappulansa (kunhan heillä on jäljellä nappuloita sijoitettavaksi).';

  @override
  String get drawerColor => 'Valikon väri';

  @override
  String get drawerTextColor => 'Valikon tekstin väri';

  @override
  String get drawerHighlightItemColor => 'Valikon kohokohdan väri';

  @override
  String get mainToolbarBackgroundColor => 'Päätyökalurivin taustaväri';

  @override
  String get mainToolbarIconColor => 'Päätyökalurivin kuvakkeen väri';

  @override
  String get navigationToolbarBackgroundColor =>
      'Navigointityökalurivin taustaväri';

  @override
  String get navigationToolbarIconColor =>
      'Navigointityökalurivin kuvakkeen väri';

  @override
  String get autoHideToolbar => 'Piilota työkalurivi automaattisesti';

  @override
  String get toolbarLocationOnScreen => 'Työkalupalkin sijainti näytöllä';

  @override
  String get top => 'Alkuun';

  @override
  String get bottom => 'Pohja';

  @override
  String get center => 'Keskusta';

  @override
  String get solidColor => 'Yksivärinen';

  @override
  String get picture => 'Kuva';

  @override
  String get chooseYourPicture => 'Valitse kuvasi';

  @override
  String get light => 'Kevyt';

  @override
  String get dark => 'Tumma';

  @override
  String get themes => 'Teemat';

  @override
  String get currentTheme => 'Nykyinen teema';

  @override
  String get saveTheme => 'Tallenna teema';

  @override
  String get showAnalysisGraph => 'Näytä analyysikaavio';

  @override
  String get analysis => 'Analyysi';

  @override
  String get saveGame => 'Tallentaa pelin';

  @override
  String get loadGame => 'Lataa peli';

  @override
  String get setupPosition => 'Asennusasento';

  @override
  String get showLegalMoves => 'Näytä lailliset siirrot';

  @override
  String get showLastMove => 'Näytä viimeinen siirto';

  @override
  String get showArrows => 'Näytä nuolet';

  @override
  String get pieces => 'Kappaleita';

  @override
  String get showAnalysis => 'Näytä analyysi';

  @override
  String get threads => 'Langat';

  @override
  String get getInvolved => 'Ota mukaan';

  @override
  String get helpImproveTranslate => 'Auta parantamaan käännöksiä';

  @override
  String get tutorial => 'Opetusohjelma';

  @override
  String get classicMill => 'Klassinen mylly';

  @override
  String get mixedMill => 'Sekoitettu mylly';

  @override
  String get ceylonMill => 'Ceylonin tehdas';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Mylly voidaan rikkoa ja tehdä uudelleen toistuvasti';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Jos pelaaja rikkoo myllyn uuden myllyn luomiseksi välittömästi, pelaaja voi siirtää tällaisen kappaleen takaisin alkuperäiseen risteykseen seuraavalla liikkeellään, jos se tekee uuden myllyn.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Peli vedetään, jos pelaajalla on kolme nappulaa ja kymmenen siirron jälkeen kumpikaan pelaaja ei poista vastustajan nappuloita';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Kun pelaaja on pudonnut kolmeen nappulaan eikä kumpikaan pelaaja voi poistaa vastustajan nappulaa kymmenen siirron sisällä, peli on tasapeli.';

  @override
  String get close => 'kiinni';

  @override
  String get whitePiece => 'Valkoinen pala';

  @override
  String get blackPiece => 'Musta pala';

  @override
  String get emptyPoint => 'Tyhjä kohta';

  @override
  String get noPoint => 'Ei järkeä';

  @override
  String get placingPhase => 'Sijoitusvaihe';

  @override
  String get movingPhase => 'Muuttovaihe';

  @override
  String get flyingPhase => 'Lentävä vaihe';

  @override
  String sideToMove(Object player) {
    return 'Siirrettävä puoli: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Viimeisin siirto: $move';
  }

  @override
  String get selected => 'Valittu';

  @override
  String get accessibility => 'Esteettömyys';

  @override
  String get screenReaderSupport => 'Näytönlukuohjelman tuki';

  @override
  String get isDraw => 'Se on tasapeli!';

  @override
  String get draw => 'Tasapeli';

  @override
  String get pieceHighlightColor => 'Kappaleen korostusväri';

  @override
  String get algorithm => 'Algoritmi';

  @override
  String get endgameNMoveRule => 'Loppupelin N-Move-sääntö';

  @override
  String get endgameNMoveRule_Detail =>
      'Jos kummallakin pelaajalla on vain kolme palaa ja kumpikaan pelaaja ei poista palaa tietyn liikkeen sisällä, peli arvotaan.';

  @override
  String get drawReasonEndgameRule50 =>
      'Kummallakin pelaajalla on vain kolme palaa, eikä kumpikaan pelaaja poista palaa tietyn liikkeen sisällä.';

  @override
  String get threefoldRepetitionRule => 'Kolminkertainen toistosääntö';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Peli arvotaan, jos asema sijoittuu kolmatta kertaa.';

  @override
  String get continueToMakeMove => 'Mill! Jatka liikkeen tekemistä.';

  @override
  String get pointStyle => 'Point -tyyli';

  @override
  String get pointWidth => 'Pisteen leveys';

  @override
  String get solid => 'Kiinteä';

  @override
  String get hollow => 'Ontto';

  @override
  String get languageName => 'Suomi';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count siirtoa',
      one: '$count siirto',
      zero: 'siirto',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Lataus epäonnistui.';

  @override
  String get filename => 'Tiedoston nimi';

  @override
  String get browse => 'Selaa…';

  @override
  String get gameFiles => 'Pelitiedostot';

  @override
  String get gameSavedTo => 'Peli on tallennettu kohteeseen';

  @override
  String get empty => 'Tyhjä';

  @override
  String get noMove => 'Ei liikettä.';

  @override
  String get restoredPosition => 'Alkuasento palautettu.';

  @override
  String get clean => 'Puhdas';

  @override
  String get cleanedUp => 'Siivottu.';

  @override
  String get remove => 'Poista';

  @override
  String get noPiecesCanBeRemoved => 'Yhtään nappulaa ei voi poistaa.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count pieces',
      one: '$count piece',
      zero: 'Piece',
    );
    return '$_temp0 on poistettava.';
  }

  @override
  String placedCount(int count) {
    return 'Sijoitettu ($count)';
  }

  @override
  String get placedPieceCount =>
      'Sijoitetun kappaleen määrä sijoitusvaiheessa.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'Nykyinen pelaaja on asettanut $count nappuloita.';
  }

  @override
  String get notPlacingPhase => 'Ei aseta vaihetta, ei voi muuttaa sitä.';

  @override
  String get paste => 'Liitä';

  @override
  String get pasteDone => 'Tahna on valmis.';

  @override
  String get cannotPaste => 'Liittäminen ei onnistu.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Näytä sijoittamattomat ja poistetut osat';

  @override
  String get fullScreen => 'Koko näyttö';

  @override
  String get reopenToTakeEffect =>
      'Poistu ja avaa sovellus uudelleen, jotta asetukset tulevat voimaan.';

  @override
  String get forest => 'Metsä';

  @override
  String get desktopImage => 'Työpöytäkuva';

  @override
  String get invalidPosition => 'Virheellinen sijainti.';

  @override
  String get shareGIF => 'Jaa GIF';

  @override
  String get pixelRatio => 'Pikselisuhde';

  @override
  String get duration => 'Kesto';

  @override
  String get gameScreenRecorder => 'Pelin näytön nauhoitin';

  @override
  String get previous => 'Edellinen';

  @override
  String get next => 'Seuraava';

  @override
  String get skip => 'Ohita';

  @override
  String get gotIt => 'Sain sen';

  @override
  String get youCanModifyRules =>
      'Voit muokata pelin sääntöjä sääntöasetuksissa.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Voit muuttaa arvoa poimijassa hiiren rullalla.';

  @override
  String get noTimeLimitForThinking =>
      'AI Ajatteluajaksi asetettu 0:ksi tarkoittaa, että ajattelulle ei ole aikarajaa.';

  @override
  String get whatIsMtdf =>
      'MTD(f) on alfabeta-hakualgoritmin muunneltu muoto, jonka tavoitteena on parantaa tehokkuutta käyttämällä uudelleen välihakutuloksia ja käyttämällä hyvää alkuarvausta hakutilan kaventamiseksi.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Huomaa, että tekoälyn ajatteluajan säätö ei välttämättä ole täysin tarkka. Todellinen ajatteluaika voi olla lyhyempi, kun vaikeustaso on asetettu pienemmälle arvolle, ja voi olla pidempi, kun tekoäly on puoliajattelu, kun aika loppuu.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Jos asetat vaikeustason korkeaksi, mutta et lisää tekoälyn ajatteluaikaa, todellinen vaikeustaso voi rajoittua pienempään arvoon ajatteluaikarajoituksen vuoksi. Todellinen arvo voi vaihdella koneen suorituskyvyn mukaan.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) on hakualgoritmi parhaan liikkeen löytämiseksi tietyssä paikassa. Se on alfa-beta-algoritmin parannus ja käyttää nolla- tai nollaikkunahakuja varmistaakseen, että liike on huonompi tai ei huonompi kuin päämuunnelman jo turvallinen pistemäärä. PVS keskittyy lupaavimpiin liikkeisiin ja välttää tarpeettomia etsintää alioptimaalisista haaroista, mikä auttaa parantamaan haun tehokkuutta.';

  @override
  String get whatIsAlphaBeta =>
      'Alfa-beta-algoritmi on hakualgoritmi parhaan liikkeen löytämiseksi. Se käyttää minimax-periaatetta ja kahta arvoa, alfaa ja betaa, karsimaan hakupuuta ja lisäämään tehokkuutta. Alfa edustaa vähimmäispistemäärää, jonka tietokone on varma, että se voi saada, kun taas beta edustaa vastustajansa enimmäispistemäärää. Algoritmi auttaa tietokonetta tekemään älykkäitä ja tehokkaita päätöksiä pelissä.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Ihmiskokemuksen mukaan jos yrität voittaa, häviät. Pyri sen sijaan tasapeliin ja vältä pelin häviämistä. Tarkkaile vastustajaasi ja houkuttele hellästi asentoon, jossa he voivat tehdä virheitä. Kun he osoittavat heikkoutta, tartu tilaisuuteen ja työnnä hellästi voittoon. Tällä tavalla voit voittaa pelin.';

  @override
  String get firstMoveDetail =>
      'Tässä pelissä toisen pelaajan on helpompi voittaa ensimmäiseen verrattuna.';

  @override
  String get passiveDetail =>
      'Passiivisen vaihtoehdon ottaminen käyttöön saa tekoälyn rentoutumaan, kun sillä on asemassa etua, sen sijaan, että se yrittäisi aggressiivisesti voittaa mahdollisimman nopeasti.';

  @override
  String get moveRandomlyDetail =>
      'Tämän vaihtoehdon ottaminen käyttöön lisää pelin satunnaisuutta ja hauskuutta, kun taas sen poistaminen käytöstä voi auttaa tutkimaan tapoja voittaa tekoäly.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Jos tekoäly ottaa huomioon nappuloidensa liikkuvuuden, se ei ainoastaan pyri vangitsemaan vastustajan nappuloita mahdollisimman nopeasti, vaan myös harkitsemaan vastustajan liikkeiden estämistä ja estämistä heidän tekemästä samoin.';

  @override
  String get whenBoardIsFull => 'Kun lauta on täynnä';

  @override
  String get whenBoardIsFull_Detail =>
      'Sijoitusvaiheen lopussa, ennen siirtovaiheen alkamista, toiminta seuraa, jos lauta on täynnä nappuloita.';

  @override
  String get sideToMoveRemovePiece =>
      'Ensimmäisenä liikkuvassa vaiheessa liikkuva pelaaja poistaa yhden vastustajan nappuloista.';

  @override
  String get agreeToDraw => 'Molemmat osapuolet sopivat tasapeliin.';

  @override
  String get takeOpponentsPiece => 'Ota yksi vastustajasi nappuloista.';

  @override
  String get firstPlayerLose => 'Ensimmäinen pelaaja häviää pelin.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Ensimmäinen ja toinen pelaaja poistavat yhden vastustajan nappuloista.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Toinen ja ensimmäinen pelaaja poistavat yhden vastustajan nappuloista.';

  @override
  String get enteredFlyingPhase =>
      'Nyt lentovaiheessa vastustajan nappulat voivat hypätä mihin tahansa tyhjään kohtaan laudalla. Voit kytkeä lentosäännön pois päältä \"Sääntöasetuksissa\".';

  @override
  String get whenStalemate => 'Kun pattitilantessa';

  @override
  String get whenStalemate_Detail =>
      'Mitä toimia seuraa kun yhtäkään nappulaa ei voi siirtää?';

  @override
  String get endWithStalemateLoss => 'Loppu umpikujaan.';

  @override
  String get changeSideToMove => 'Vaihda puolta liikkuaksesi.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Poista yksi vastustajan nappuloista ja tee seuraava siirto.';

  @override
  String get endWithStalemateDraw => 'Päätä tasapeliin.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Poista yksi vastustajan nappuloista ja vaihda puolta liikkuaksesi.';

  @override
  String get aiResponseDelayTime => 'Tekoälyn vasteviive';

  @override
  String get aiIsDelaying =>
      'Tekoäly on tällä hetkellä viivästyneen vasteen vaiheessa. Odota hetki ennen kuin jatkat.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Et voi poistaa vierekkäistä nappulaa.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'Pattitilanteessa vastustajan nappulat, jotka ovat sinun vieressäsi, voidaan poistaa myllymuodostuksesta riippumatta.';

  @override
  String get whatIsMcts =>
      'MCTS on aloittelijaystävällinen algoritmi, joka tekee päätöksiä tutkimalla ja arvioimalla erilaisia liikkeitä simulaatioiden avulla.';

  @override
  String get goldenJade => 'Kultainen Jade';

  @override
  String get forestWood => 'Metsä Puu';

  @override
  String get darkMystery => 'Tumma Mysteeri';

  @override
  String get midnightBlue => 'Yönsininen';

  @override
  String get greenForest => 'Vihreä metsä';

  @override
  String get greenMeadow => 'Vihreä Niitty';

  @override
  String get stonyPath => 'Kivinen Polku';

  @override
  String get pastelPink => 'Pastelli Pinkki';

  @override
  String get turquoiseSea => 'Turkoosi Meri';

  @override
  String get violetDream => 'Violetti Unelma';

  @override
  String get mintChocolate => 'Minttu-Suklaa';

  @override
  String get skyBlue => 'Taivaansininen';

  @override
  String get playfulGarden => 'Leikkisä Puutarha';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Retrograde Analysis -algoritmi käyttää moniarvoista retrogradista analyysiä loppupelitietokannan rakentamiseen eri aloituspaikoista ja käyttää sitten tätä tietokantaa pelin optimoimiseksi. Tämä lähestymistapa kuuluu Ultra-Strong-ratkaisujen luokkaan.';

  @override
  String get viewAlgorithmGuide =>
      'Haluatko nähdä tämän algoritmin käyttöoppaan?';

  @override
  String get showPositionalAdvantageIndicator => 'Näytä sijaintiedun osoitin';

  @override
  String get usePerfectDatabase => 'Käytä täydellistä tietokantaa';

  @override
  String get perfectDatabaseDescription =>
      'Ota tämä vaihtoehto käyttöön, jos haluat käyttää virheetöntä pelitietokantaa, joka on luotu huippuluokan algoritmeilla. Tämä ominaisuus integroi sekä avaus- että lopetusstrategiat optimaalisten liikkeiden ehdottamiseksi. Tämä on suositeltu valinta pelaajille, jotka etsivät korkeinta tarkkuutta pelaamisessa. Huolellisen laskentatekniikan avulla luotu tietokanta on suunniteltu tarjoamaan lähes täydellisiä peliratkaisuja.\n\nHuomautus: Jos tekoäly ei pääse käsiksi tietokantaan, se käyttää tavanomaisia algoritmeja pelipäätöksissä. Kun tietokanta on saatavilla, \"Vaikeustaso\" muuttuu käytännössä lyömättömäksi, ja \"AI Thinking Time\" kokee rajusti lyhenemisen. Monet \'AI\'s play style\' -asetusten asetukset ohitetaan, koska tietokannan tuloksilla on korkein prioriteetti.\n\nNapsauta tästä saadaksesi ohjeita tämän virheettömän tietokannan hyödyntämiseen.';

  @override
  String get backgroundImage => 'Taustakuva';

  @override
  String get whatIsRandom =>
      'Kun \'Käytä täydellistä tietokantaa\' -vaihtoehto ei ole käytössä, \'Satunnainen\'-asetus saa tekoälyn siirtämään nappuloita satunnaisesti käyttämättä siirtovalinnan algoritmeja. Tämä johtaa yleensä huomattavasti heikompaan peliin. Toisaalta, kun \"Käytä täydellistä tietokantaa\" on käytössä, tekoäly luottaa yksinomaan \"Täydelliseen tietokantaan\" päätösten tekemisessä sen sijaan, että se yhdisteisi sitä perinteisten tekoälyalgoritmien kanssa. Tässä tilassa tekoälyn liikkeet perustuvat täysin tietokannan sisältöön välttäen luottamuksen reaaliaikaisiin laskelmiin tai hakualgoritmeihin.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Poista vastustajan nappula(t) tämän kädestä, sitten on vastustajan vuoro sijoittaa.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Kun muodostat myllyjä sijoitusvaiheen aikana';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Poista vastustajan nappula(t) laudalta.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Poista vastustajan nappula(t) laudalta, sitten on vastustajan vuoro sijoittaa.';

  @override
  String get opponentRemovesOwnPiece =>
      'Vastustaja poistaa oman nappulansa laudalta.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Sen sijaan, että sinä toimisit, vastustaja valitsee ja poistaa oman nappulansa laudalta, mikä on käytännössä vahingollinen teko häntä itseään kohtaan.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Poista vastustajan nappula(t) tämän kädestä, sitten on sinun vuorosi siirtyä.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Poista nappula(t) vastustajan kädestä. Jos monipoistoasetuksen mukaan on poistettava useita nappuloita eikä vastustajalla ole enää nappuloita kädessä, jatka vastustajan nappuloiden poistamista laudalta. Sitten on sinun vuorosi siirtyä. Jos jatkat myllyjen muodostamista, voit jatkaa poistaa vastustajan nappuloita.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Poista nappula(t) vastustajan kädestä. Jos monipoistoasetuksen mukaan on poistettava useita nappuloita eikä vastustajalla ole enää nappuloita kädessä, jatka vastustajan nappuloiden poistamista laudalta. Sitten on vastustajan vuoro siirtyä.';

  @override
  String get markAndDelayRemovingPieces =>
      'Merkitse ja viivytä nappuloiden poistamista.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Sijoitusvaiheen aikana poistettavat nappulat merkitään, ja kumpikaan pelaaja ei voi sijoittaa uusia nappuloita näihin kohtiin. Liikkumisvaiheeseen siirryttäessä nämä merkityt nappulat poistetaan kokona, ja pelaajat voivat sitten siirtää nappuloitaan näihin nyt tyhjiin kohtiin.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Toimenpiteet, jotka voidaan ottaa myllyjen muodostamisen aikana sijoitusvaiheessa.';

  @override
  String get marked => 'Merkitty';

  @override
  String get menu => 'Valikko';

  @override
  String get monochrome => 'Monokromaattinen';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Voit ottaa näytönlukijatuen käyttöön Yleiset asetukset -osion Saavutettavuus-asetuksista.';

  @override
  String get showNumbersOnPieces => 'Näytä numerot nappuloissa';

  @override
  String get saveImage => 'Tallenna kuva';

  @override
  String get isAnalysisToolbarShown => 'Näytä analyysityökalupalkki';

  @override
  String get analysisToolbarBackgroundColor =>
      'Analyysityökalupalkin taustaväri';

  @override
  String get analysisToolbarIconColor => 'Analyysityökalupalkin kuvakkeen väri';

  @override
  String get transformed => 'Muunnettu.';

  @override
  String get cannotTransform => 'Ei voi muuntaa.';

  @override
  String get rotate => 'Kierrä';

  @override
  String get horizontalFlip => 'H Kääntö';

  @override
  String get verticalFlip => 'V Kääntö';

  @override
  String get innerOuterFlip => 'IO Kääntö';

  @override
  String get transparentCanvas => 'Läpinäkyvä Kangas';

  @override
  String get restrictRepeatedMillsFormation =>
      'Rajoita toistuvaa myllyjen muodostamista';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Nappula, joka siirretään yhdestä myllystä toiseen, ei voi välittömästi palata alkuperäiseen pisteeseen seuraavalla vuorolla muodostaakseen jälleen myllyn. Ensin tarvitaan erilainen siirto.';

  @override
  String get oneTimeUseMill => 'Kertakäyttöinen mylly';

  @override
  String get oneTimeUseMill_Detail =>
      'Jokainen mylly voi poistaa vastustajan palan vain kerran. Voit muodostaa sen uudelleen, mutta sitä ei voi käyttää lisäpoistoihin.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Asettamillasi nykyisillä säännöillä ei ole vastaavaa täydellistä tietokantaa. Lisätietoja täydellisestä tietokannasta saat napsauttamalla tästä.';

  @override
  String get focusOnBlockingPaths => 'Keskity estämään reittejä';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Priorisoi vastustajan liikkeiden estäminen myllyjen muodostamisen sijaan. Sen sijaan, että keskittyisi poistamaan kappaleita täydentämällä myllyjä, AI pyrkii ansaan vastustajan, estäen heitä liikkumasta ja varmistaa voiton kulutuksella eikä aggressiivisella pelillä. Tämä strategia ei aktiivisesti estä vastustajan myllyjä.';

  @override
  String get pieceImage => 'Palakuva';

  @override
  String get importColorSettings => 'Tuo väriasetukset';

  @override
  String get exportColorSettings => 'Vie väriasetukset';

  @override
  String get import => 'Tuo';

  @override
  String get export => 'Vie';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Kopioi ensin JSON-muodon asetukset leikepöydälle.';

  @override
  String get copiedToClipboard => 'Kopioitu leikepöydälle.';

  @override
  String get imported => 'Tuotu.';

  @override
  String get boardImage => 'Laudan kuva';

  @override
  String get autumnLeaves => 'Syksyn lehdet';

  @override
  String get legendaryLand => 'Legendaarinen Maa';

  @override
  String get vignetteEffect => 'Vignetointi-efekti';

  @override
  String get promptMakeToolbarTransparent =>
      'Haluatko tehdä työkalupalkin täysin läpinäkyväksi, kun lautakuvan taustakuva on asetettu?';

  @override
  String get vibration => 'Ota värinä käyttöön pelissä';

  @override
  String get soundTheme => 'Äniteema';

  @override
  String get ball => 'Pallo';

  @override
  String get liquid => 'Neste';

  @override
  String get wood => 'Puu';

  @override
  String get placeEffectAnimation => 'Nappulan asettamisen animaatioefekti';

  @override
  String get removeEffectAnimation => 'Nappulan poistamisen animaatioefekti';

  @override
  String get isToolbarAtBottom => 'Näytä työkalupalkki alhaalla';

  @override
  String get boardCornerRadius => 'Lautan kulman säde';

  @override
  String get useOpeningBook => 'Käytä avausteosta';

  @override
  String get currentRule => 'Nykyinen';

  @override
  String get nineMensMorris => 'Yhdeksän Miesten Morris';

  @override
  String get twelveMensMorris => 'Kahdentoista Miesten Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Sääntökokoelma';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'Kertakäyttöinen Mylly';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'Anna tekoälyn käyttää aloitusliikkeitä, joita ammattilaiset ihmispelaajat yleisesti käyttävät pelin alussa. Huomautus: Tämä toiminto on tällä hetkellä saatavilla vain tietyille sääntöjoukoille.';

  @override
  String get showAdvantageGraph => 'Näytä etugraafi';

  @override
  String get advantageGraphHint =>
      'Etulyöntikaavio piirretään vasta sen jälkeen, kun tekoäly on tehnyt siirtonsa. Sitä ei piirretä, kun ihmispelaaja tekee siirron.';

  @override
  String get removalBasedOnMillCounts =>
      'Poista nappuloiden poistaminen käytöstä, kunnes kaikki nappulat on asetettu. Pelaajat poistavat nappuloita myllyjen määrän perusteella.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Poista nappuloiden poistaminen käytöstä, kunnes kaikki nappulat on asetettu. Pelaajat poistavat nappuloita myllyjen määrän perusteella: jos ne ovat yhtäsuuret, molemmat poistavat saman määrän nappuloita; jos toisella on enemmän, hän poistaa yhden ylimääräisen nappulan, pitäen eron yhdessä nappulassa. Jos vain yksi muodostaa myllyn, hän poistaa kaksi nappulaa ja toinen poistaa yhden. Jos kumpikaan ei muodosta myllyä, molemmat poistavat yhden nappulan.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Valitse yksi omista nappuloistasi.';

  @override
  String get notYourTurn => 'Ei ole sinun vuorosi.';

  @override
  String get annotationToolbarBackgroundColor => 'Annotointipalkin taustaväri';

  @override
  String get annotationToolbarIconColor => 'Annotointipalkin kuvakkeiden väri';

  @override
  String get isAnnotationToolbarShown => 'Näytä annotointipalkki';

  @override
  String get enterAnnotationMode => 'Siirry annotointitilaan';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Haluatko varmasti poistaa kaikki merkinnät?';

  @override
  String get llmPromptCopiedToClipboard => 'LLM-kehote kopioitu leikepöydälle.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Yhteys estetty, palvelin saattaa olla alhaalla.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Haku onnistui, odotetaan yhteyttä...';

  @override
  String get noLanConnection => 'Ei LAN-yhteyttä';

  @override
  String get takeScreenshot => 'Ota kuvakaappaus';

  @override
  String get disconnectedFromOpponent => 'Yhteys vastustajaan katkaistu.';

  @override
  String get takeBackRequest => 'Pyydä siirron peruuttamista';

  @override
  String get nothingToShow => 'Ei mitään näytettävää.';

  @override
  String get stopHosting => 'Lopeta isännöinti';

  @override
  String get connectionResetByPeer => 'Yhteys nollattiin vastapuolelta.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Yhteys katkesi yhteydenvalvonnan aikakatkaisun vuoksi. Yritä yhdistää uudelleen.';

  @override
  String get startHosting => 'Aloita isännöinti';

  @override
  String get restartRequestRejected => 'Uudelleenkäynnistyspyyntö hylätty.';

  @override
  String get notConnectedToLanOpponent => 'Ei yhteyttä LAN-vastustajaan.';

  @override
  String get llmPrompt => 'LLM-kehote';

  @override
  String get gameRestarted => 'Peli käynnistettiin uudelleen.';

  @override
  String get takeBackRejected => 'Siirron peruutus hylättiin.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Haluatko varmasti luovuttaa tämän pelin?';

  @override
  String get opponentResignedYouWin => 'Vastustaja luovutti. Sinä voitit!';

  @override
  String get clearAllAnnotations => 'Poista kaikki merkinnät';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Yhdistetty, odotetaan vastustajan siirtoa...';

  @override
  String get networkStatusDisconnected => 'Verkkotila: Ei yhteyttä';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Pyyntö siirron peruutuksesta lähetetty vastustajalle.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'Vastustaja on saattanut poistua pelistä';

  @override
  String get connectedToHostSuccessfully => 'Yhteys isäntään onnistui.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Yhteys katkaistu: yhteydenvalvonnan aikakatkaisu';

  @override
  String get noHostDiscovered => 'Isäntää ei löytynyt.';

  @override
  String get confirmResignation => 'Vahvista luovutus';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Isännöinti aloitettu, odotetaan pelaajien liittymistä...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Yhteys aikakatkaistiin, verkkoyhteys epävakaa.';

  @override
  String get noLlmPromptAvailable => 'Ei LLM-kehotetta saatavilla.';

  @override
  String get youResignedGameOver => 'Luovutit. Peli ohi.';

  @override
  String get serverIp => 'Palvelimen IP';

  @override
  String get confirmClear => 'Vahvista tyhjennys';

  @override
  String get opponentSTurn => 'Vastustajan vuoro.';

  @override
  String get waitingAClientConnection => 'Odotetaan asiakkaan yhteyttä...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Siirron peruutuspyyntö hylättiin tai epäonnistui.';

  @override
  String get addText => 'Lisää teksti';

  @override
  String get exitAnnotationMode => 'Poistu annotointitilasta';

  @override
  String get typeYourAnnotation => 'Kirjoita merkintäsi';

  @override
  String get attemptingToReconnect => 'Yritetään yhdistää uudelleen...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Uudelleenkäynnistyspyyntö lähetetty. Odotetaan vastustajan vastausta...';

  @override
  String get serverIsStopped => 'Palvelin on pysäytetty.';

  @override
  String get restartRequest => 'Uudelleenkäynnistyspyyntö';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Et voi pyytää siirron peruuttamista, kun ei ole sinun vuorosi.';

  @override
  String get takeBackAccepted => 'Siirron peruutus hyväksyttiin.';

  @override
  String get localNetworkSettings => 'Paikallisverkon asetukset';

  @override
  String get reconnectedSuccessfully => 'Uudelleen yhdistäminen onnistui!';

  @override
  String get failedToSaveImageToGallery =>
      'Kuvan tallennus Galleriaan epäonnistui.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Vastustaja pyysi aloittamaan pelin uudelleen. Hyväksytkö?';

  @override
  String get yourTurn => 'Sinun vuorosi.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Uudelleenyhdistäminen epäonnistui, käynnistä peli uudelleen.';

  @override
  String get host => 'Isäntä';

  @override
  String get join => 'Liity';

  @override
  String get port => 'Portti';

  @override
  String get invalidIpAddress => 'Virheellinen IP-osoite.';

  @override
  String get invalidPort => 'Virheellinen portti.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Yhdistetään: yritys $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Yhdistäminen epäonnistui: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Isännöinnin aloittaminen epäonnistui: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Isäntä löydetty: $ip:$port';
  }

  @override
  String get stop => 'Lopeta';

  @override
  String get discover => 'Etsi';

  @override
  String get connect => 'Yhdistä';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Asiakas yhdistettiin: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Etsitään: $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Yhdistetään uudelleen ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Yhdistetty';

  @override
  String get delete => 'Poista';

  @override
  String get ancientEgypt => 'Muinainen Egypti';

  @override
  String get gothicIce => 'Goottilainen Jää';

  @override
  String get riceField => 'Riisipelto';

  @override
  String get chinesePorcelain => 'Kiinalainen Posliini';

  @override
  String get desertDusk => 'Aavikon Hämärä';

  @override
  String get precisionCraft => 'Tarkkuuskäsityö';

  @override
  String get folkEmbroidery => 'Kansankirjonta';

  @override
  String get carpathianHeritage => 'Karpaattien Perintö';

  @override
  String get imperialGrandeur => 'Keisarillinen Loisto';

  @override
  String get bohemianCrystal => 'Böömiläinen Kristalli';

  @override
  String get savannaSunrise => 'Savannin Auringonnousu';

  @override
  String get harmonyBalance => 'Harmonia ja Tasapaino';

  @override
  String get cinnamonSpice => 'Kanelimauste';

  @override
  String get anatolianMosaic => 'Anatolialainen Mosaiikki';

  @override
  String get carnivalSpirit => 'Karnevaalihenki';

  @override
  String get custom => 'Mukautettu';

  @override
  String get spiceMarket => 'Maustemarkkinat';

  @override
  String get swipeToRevealTheDrawer => 'Pyyhkäise avataksesi laatikon';

  @override
  String get showGameInfoOnScreenshots => 'Näytä pelitiedot kuvakaappauksissa';

  @override
  String get humanMoveTime => 'Ihmisen aikaraja';

  @override
  String get noTimeLimitForHumanMoves => 'Ei aikarajaa ihmisen siirroille';

  @override
  String get timeoutLoseWillBeApplied =>
      'Aikarajan ylitys aiheuttaa häviön ihmispelaajalle';

  @override
  String get identifyingBoard => 'Tunnistetaan pelilautaa...';

  @override
  String get youCanEnterAnyModelName =>
      'Voit syöttää minkä tahansa mallin nimen.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Laudan asettelu sovellettiin. FEN kopioitiin leikepöydälle.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Ehdotus: yritä ottaa selkeämpi kuva laudasta.';

  @override
  String get llmPromptTemplate => 'LLM-kehotemalli';

  @override
  String get noValidBoardDetected => 'Kelvollista lautaa ei havaittu.';

  @override
  String get selectingImageFromAlbum => 'Valitaan kuva albumista...';

  @override
  String get configurePromptTemplate => 'Määritä kehotemalli';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Muokkaa kehotemallia LLM-analyysiä varten';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'FENin luominen tunnistetusta laudasta epäonnistui.';

  @override
  String get outputInCurrentLanguage => 'Tulostus nykyisellä kielellä';

  @override
  String get commonBaseUrls => 'Yleiset Base URL -osoitteet';

  @override
  String get viewCommonModels => 'Näytä yleiset mallit';

  @override
  String get recognitionParametersUpdated => 'Tunnistusparametrit päivitetty.';

  @override
  String get whiteSMove => 'Valkean siirto';

  @override
  String get resetToDefaults => 'Palauta oletusasetuksiin';

  @override
  String get photoShoot => 'Valokuvaus';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Tunnistetun laudan asettelun soveltaminen epäonnistui.';

  @override
  String get llmPromptContent => 'LLM-kehotteen sisältö';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM ei ole määritetty. Tarkista asetuksesi.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Määritä palveluntarjoaja, malli, API Key ja Base URL';

  @override
  String get llmConfiguration => 'LLM-asetukset';

  @override
  String get configureLlmProvider => 'Määritä LLM-palveluntarjoaja';

  @override
  String get llmPromptTemplateHeader => 'LLM-kehotemallin otsikko';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Kuvasta ei tunnistettu yhtään nappulaa. Yritä uudelleen.';

  @override
  String get recognizeBoardFromImage => 'Tunnista lauta kuvasta';

  @override
  String get viewTips => 'Näytä vinkit';

  @override
  String get applyToBoard => 'Sovella lautaan';

  @override
  String get adjustBoardArea => 'Säädä laudan aluetta';

  @override
  String get viewCommonUrls => 'Näytä yleiset URL-osoitteet';

  @override
  String get colorAnalysisFailed => 'Värianalyysi epäonnistui!';

  @override
  String get analyzingGameBoardImage => 'Analysoidaan pelilaudan kuvaa...';

  @override
  String get selectFromAlbum => 'Valitse albumista';

  @override
  String get noBoardPointDetected => 'Yhtään laudan pistettä ei tunnistettu!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Jos jätetään tyhjäksi, käytetään oletuspohjaa';

  @override
  String get llmConfig => 'LLM-asetukset';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Haluatko varmasti palauttaa kehotemallit oletusarvoihin?';

  @override
  String get llmPromptTemplateFooter => 'LLM-kehotemallin alatunniste';

  @override
  String get loadingResponse => 'Ladataan vastausta...';

  @override
  String get applyThisResultToBoard => 'Sovella tämä tulos laudalle';

  @override
  String get takingPicture => 'Otetaan kuva...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Valitse pelilaudan kuva tunnistettavaksi';

  @override
  String get identificationResults => 'Tunnistustulokset';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Analysoi siirrot ja tarjoa näkemyksiä.';

  @override
  String get getApiKey => 'Hanki API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Koko tunnistusprosessi epäonnistui.';

  @override
  String get boardRecognitionResult => 'Laudan tunnistustulos';

  @override
  String get askLlm => 'Kysy LLM:ltä';

  @override
  String get boardDetectionFailed => 'Laudan tunnistus epäonnistui!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Laudan pistettä ei tunnistettu, nappulaa ei voida tunnistaa!';

  @override
  String get copyFen => 'Kopioi FEN';

  @override
  String get commonlyUsedModels => 'Yleisesti käytetyt mallit';

  @override
  String get apiKeyOptional => 'API Key (valinnainen)';

  @override
  String get noImageSelected => 'Ei kuvaa valittu';

  @override
  String get blackSMove => 'Mustan siirto';

  @override
  String get llm => 'Suuri kielimalli';

  @override
  String get llmProvider => 'Palveluntarjoaja';

  @override
  String get baseUrl => 'Perus-URL';

  @override
  String get model => 'Malli';

  @override
  String get temperature => 'Lämpötila';

  @override
  String get llmCommandReceivedProcessing =>
      'Komento vastaanotettu! AI käsittelee...';

  @override
  String get llmDeepThinkingWait =>
      'Syvällinen ajattelu käynnissä, odota hetki...';

  @override
  String get llmPresentingSoon => 'Esitys tulossa pian...';

  @override
  String get recognitionParameters => 'Tunnistusparametrit';

  @override
  String get adjustParamsDesc =>
      'Säädä parametreja parantaaksesi tunnistuksen tarkkuutta';

  @override
  String get saveParameters => 'Tallenna parametrit';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Kuvantunnistusta ei voi käynnistää: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Kuvantunnistus epäonnistui: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Asetettu asema, $whiteCount valkoista ja $blackCount mustaa nappia';
  }

  @override
  String get fenCopiedToClipboard => '(FEN kopioitu leikepöydälle)';

  @override
  String recognitionFailed(String error) {
    return 'Tunnistus epäonnistui: $error';
  }

  @override
  String get myRating => 'Oma luokitus';

  @override
  String get gamesPlayed => 'Pelatut pelit';

  @override
  String get wins => 'Voitot';

  @override
  String get losses => 'Häviöt';

  @override
  String get draws => 'Tasapelit';

  @override
  String get lastUpdated => 'Viimeksi päivitetty';

  @override
  String get format => 'Muoto:';

  @override
  String get resetStatistics => 'Nollaa tilastot';

  @override
  String get drawRate => 'Tasapeliprosentti';

  @override
  String get lossRate => 'Häviöprosentti';

  @override
  String get aiStatistics => 'Tekoälyn tilastot';

  @override
  String get enableStatistics => 'Ota tilastot käyttöön';

  @override
  String get enableStatistics_Detail =>
      'Kun tämä on käytössä, pelitulokset tallennetaan tilastoihin. Siirtojen peruutuksia sisältäviä pelejä ei kuitenkaan tallenneta. Kun tämä ei ole käytössä, tilastojen kerääminen keskeytetään.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Tämä nollaa kaikki pelitilastot. Toimintoa ei voi kumota.';

  @override
  String get boardInnerRingSize => 'Laudan sisemmän renkaan koko';

  @override
  String get boardShadowEnabled => 'Laudan varjo';

  @override
  String get trapAwareness => 'Ansojen tunnistus';

  @override
  String get trapAwarenessDescription =>
      'Korosta ansasiirrot paksuilla ympyröillä ja nuolilla analyysin aikana.';

  @override
  String trapExists(String trapMoves) {
    return 'Ansa havaittu. Ansasiirrot: $trapMoves';
  }

  @override
  String get custodianCapture => 'Reunustava sieppaus';

  @override
  String get custodianCaptureDescription =>
      'Liitä yksi vastustajasi kappaleista kahden sinun välittömässä linjassa sen sieppaamiseksi.';

  @override
  String get custodianCaptureEnable => 'Salli reunustavan sieppauksen';

  @override
  String get interventionCapture => 'Interventiokaappaus';

  @override
  String get interventionCaptureDescription =>
      'Siirry tyhjään pisteeseen kahden vastustajan kappaleen välillä vangitaksesi ne molemmat.';

  @override
  String get interventionCaptureEnable => 'Salli intervention sieppaus';

  @override
  String get leapCapture => 'Kaappaus';

  @override
  String get leapCaptureDescription =>
      'Kaapata hyppäämällä viereisen vastustajan kappaleen yli tyhjään pisteeseen sen jälkeen.';

  @override
  String get leapCaptureEnable => 'Anna hyppykaappauksen';

  @override
  String get captureApplicableLines => 'Soveltuvat rivit';

  @override
  String get captureSquareEdges => 'Neliön reunat';

  @override
  String get captureCrossLines => 'Ortogonaalisia viivoja ylittäen neliön';

  @override
  String get captureDiagonalLines =>
      'Viagonaalilinjoja pitkin, jotka ylittävät neliön';

  @override
  String get captureExecutionPhases => 'Suoritusvaiheet';

  @override
  String get capturePiecesCondition =>
      'Saatavuus liikkuvan vaiheen aikana jäljellä olevien kappaleiden perusteella';

  @override
  String get capturePiecesConditionUnlimited => 'Ei rajoitusta';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Saatavana, kun sinulla on kolme tai vähemmän kappaletta';
}
