// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Persian (`fa`).
class SFa extends S {
  SFa([String locale = 'fa']) : super(locale);

  @override
  String get appName => 'دوز';

  @override
  String get welcome => 'خوش آمدید';

  @override
  String get yes => 'بله';

  @override
  String get no => 'نه';

  @override
  String get game => 'بازی';

  @override
  String get humanVsAi => 'انسان در برابر رایانه';

  @override
  String get humanVsHuman => 'انسان در برابر انسان';

  @override
  String get aiVsAi => 'رایانه در برابر رایانه';

  @override
  String get humanVsCloud => 'انسان در برابر فضای ابری';

  @override
  String get humanVsLAN => 'بازی شبکه داخلی';

  @override
  String get testViaLAN => 'تست از طریق شبکه';

  @override
  String get move => 'حرکت';

  @override
  String get showMoveList => 'لیست حرکت';

  @override
  String get moveList => 'لیست حرکت';

  @override
  String get noGameRecord => 'بدون سابقه';

  @override
  String get ok => 'خوب';

  @override
  String get confirm => 'تایید';

  @override
  String get cancel => 'لغو';

  @override
  String get tipSelectWrong => 'شما مهره اشتباهی را انتخاب کرده‌اید.';

  @override
  String get tipPlace => 'مهره‌های خود را قرار دهید.';

  @override
  String get tipBanPlace => 'نمی‌توان در اینجا قرار داد.';

  @override
  String get tipPlaced => 'قرار داده شده.';

  @override
  String get tipRemove => 'یک مهره را بردارید.';

  @override
  String get tipBanRemove => 'قابل حذف نیست.';

  @override
  String get tipRemoved => 'حذف شده.';

  @override
  String get tipMove => 'یک مهره را حرکت دهید.';

  @override
  String get tipCannotPlace => 'نمی توانید مهره خود را اینجا قرار دهید.';

  @override
  String get tipCannotMove => 'نمی توانید مهره خود را به اینجا منتقل کنید.';

  @override
  String get tipMill => 'دوز! یک مهره حریف خود را بردارید.';

  @override
  String get tipContinueMill => 'برای برداشتن مهره حریف ادامه دهید.';

  @override
  String get tipSelectOpponentsPiece =>
      'یکی از مهره های حریف خود را انتخاب کنید.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'نمی‌توانید مهره‌ای از یک دوز را بردارید.';

  @override
  String get tipCanMoveOnePoint => 'میتوانید مهره‌ای را یک خانه حرکت دهید.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'نمی‌توانید مهره های حریف را حرکت دهید.';

  @override
  String get tipSelectPieceToMove => 'مهره‌ای برای حرکت‌دادن انتخاب کنید.';

  @override
  String get tipHaveThreePiecesLeft => 'فقط ۳ مهره برای شما باقیمانده.';

  @override
  String get tipCanMoveToAnyPoint =>
      'می توانید به هر خانه‌ای که دوست دارید بروید.';

  @override
  String tipToMove(Object player) {
    return 'نوبت حرکت $player';
  }

  @override
  String get whiteWin => 'بازیکن ۱ برنده است!';

  @override
  String get blackWin => 'بازیکن ۲ برنده است!';

  @override
  String get won => 'برنده شد';

  @override
  String get lost => 'باخت';

  @override
  String get thinking => 'در حال فکر کردن...';

  @override
  String get newGame => 'بازی جدید';

  @override
  String get importGame => 'وارد کردن بازی';

  @override
  String get exportGame => 'صادر کردن بازی';

  @override
  String get gameImported => 'بازی وارد شد';

  @override
  String cannotImport(Object invalidMove) {
    return 'نمی‌تواند $invalidMove را وارد کند.';
  }

  @override
  String get movesAndRulesNotMatch => 'حرکات و قوانین با هم مطابقت ندارند.';

  @override
  String get pleaseWait => 'شکیبا باشید...';

  @override
  String get restartGame => 'راه‌اندازی مجدد بازی فعلی؟';

  @override
  String get restart => 'راه اندازی مجدد';

  @override
  String get gameStarted => 'بازی شروع شده است ، لطفا مهره‌ای را قرار دهید.';

  @override
  String get analyzing => 'در حال تحلیل…';

  @override
  String error(Object message) {
    return 'خطا: $message';
  }

  @override
  String get winRate => 'درصد برد';

  @override
  String get score => 'امتیاز:';

  @override
  String get white => 'بازیکن ۱';

  @override
  String get black => 'بازیکن ۲';

  @override
  String loseReasonlessThanThree(Object player) {
    return 'تعداد مهره‌های $player کمتر از سه است';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player استعفا داد.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player راهی برای رفتن ندارد.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'تخته پر است و $player راهی برای رفتن ندارد.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'زمان تمام شد، $player باخت.';
  }

  @override
  String get drawReasonRule50 =>
      'در مرحله حرکت کردن ، هیچ مهره‌ای در آخرین تعداد حرکت خاص حذف نشده است.';

  @override
  String get drawReasonBoardIsFull => 'نتیجه مساوی است.چون تخته پر است.';

  @override
  String get drawReasonThreefoldRepetition =>
      'نتیجه مساوی است به دلیل سه بار تکرار.';

  @override
  String get gameOverUnknownReason => 'بازی تمام شد! دلیل ناشناخته.';

  @override
  String get gameOver => 'بازی تمام شد';

  @override
  String get youWin => 'تبریک! شما برنده شدید!';

  @override
  String challengeHarderLevel(int level) {
    return 'سطح سخت تر را به چالش بکشید؟ سطح جدید سطح $level خواهد بود!';
  }

  @override
  String get youLose => 'شما باختید!';

  @override
  String get analyze => 'تجزیه و تحلیل';

  @override
  String get about => 'درباره';

  @override
  String version(Object versionNumber) {
    return 'نسخه: $versionNumber';
  }

  @override
  String get thanks => 'با تشکر';

  @override
  String get settings => 'تنظیمات';

  @override
  String get options => 'گزینه‌ها';

  @override
  String get generalSettings => 'تنظیمات عمومی';

  @override
  String get skillLevel => 'سطح دشواری';

  @override
  String get moveTime => 'زمان تفکر رایانه‌ای';

  @override
  String get difficulty => 'دشواری';

  @override
  String get playSounds => 'جلوه‌های صوتی';

  @override
  String get playSoundsInTheGame => 'پخش صداها در بازی';

  @override
  String get keepMuteWhenTakingBack => 'حفظ حالت بی صدا هنگام بازگشت به عقب';

  @override
  String get tone => 'لحن';

  @override
  String get whoMovesFirst => 'حرکت اول';

  @override
  String get human => 'انسان';

  @override
  String get ai => 'هوش مصنوعی';

  @override
  String get alternate => 'جایگزین';

  @override
  String get isAutoRestart =>
      'راه‌اندازی دوباره بازی بصورت خودکار وقتی بازی تمام شد';

  @override
  String get isAutoChangeFirstMove => 'تغییر خودکار حرکت اول';

  @override
  String get shufflingEnabled => 'حرکت تصادفی';

  @override
  String get misc => 'متفرقه';

  @override
  String get rules => 'قوانین';

  @override
  String get piecesCount => 'تعداد مهره‌های هر بازیکن';

  @override
  String get piecesCount_Detail => 'هر بازیکن چند مهره دارد؟';

  @override
  String get flyPieceCount => 'تعداد مهره‌های پروازی';

  @override
  String get flyPieceCount_Detail =>
      'اگر پرواز کردن فعال باشد ، هنگامی که مهره‌های بازیکن به تعداد خاصی کاهش یابد ، مهره‌های او آزاد هستند و به جای محدود شدن به نقاط مجاور ، می توانند به هر نقطه اشغال نشده منتقل شوند.';

  @override
  String get piecesAtLeastCount => 'حداقل مهره‌ها';

  @override
  String get hasDiagonalLines => 'خطوط مورب';

  @override
  String get hasDiagonalLines_Detail => 'افزودن چهار خط مورب به تخته بازی.';

  @override
  String get isDefenderMoveFirst => 'بازیکن دوم ابتدا حرکت می کند';

  @override
  String get isDefenderMoveFirst_Detail =>
      'بازیکنی که در مرحله جای‌گذاری مهره‌ها در نوبت دوم حرکت می کند در مرحله حرکت دادن مهره‌ها اول حرکت می کند.';

  @override
  String get mayRemoveMultiple => 'حذف چندگانه مهره‌ها';

  @override
  String get mayRemoveMultiple_Detail =>
      'اگر یک بازیکن یکباره بیش از یک دوز را حاصل شود ، می تواند به تعداد دوزهایی که حاصل شده، مهره‌های حریف را بردارد.';

  @override
  String get mayRemoveFromMillsAlways => 'نابودسازی دوزها';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'فعال کردن این گزینه به بازیکنان اجازه می‌دهد حتی اگر مهره‌های دیگری خارج از دوز وجود داشته باشد، مستقیماً مهره‌ای را از دوز حریف حذف کنند.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'هنگامی که تخته پر میشود بازیکن دوم می‌بازد';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'در پایان مرحله جای‌گذاری مهره‌ها ، وقتی تخته پر است ، طرفی که ابتدا مهره‌ای قرار می‌دهد بازی را می‌بازد ، در غیر این صورت بازی مساوی است.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'وقتی حرکت مجاز وجود ندارد می‌بازید';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'بازیکن در صورتی که حریف تمام حرکات قانونی او را مسدود کند، می‌بازد. اگر این گزینه غیرفعال باشد، به جای اعلام باخت، نوبت حرکت به حریف واگذار می‌شود.';

  @override
  String get mayFly => 'پرواز کردن';

  @override
  String get mayFly_Detail =>
      'اگر بازیکن فقط سه یا چهار مهره (با قابلیت تنظیم) باقی داشته باشد ، می تواند مهره را به هر نقطه آزاد منتقل کند.';

  @override
  String get nMoveRule => 'قانون N حرکت';

  @override
  String get nMoveRule_Detail =>
      'چنانچه در شمار خاصی از حرکات، مهره‌ای از سوی هر یک از بازیکنان حذف نشده باشد ، بازی مساوی می شود.';

  @override
  String get rollback => 'بازگشت به عقب';

  @override
  String get pleaseSelect => 'لطفا انتخاب کنید';

  @override
  String get copy => 'کپی';

  @override
  String get moveHistoryCopied => 'تاریخچه حرکات در کلیپ‌بورد کپی شد.';

  @override
  String get help => 'کمک';

  @override
  String get feedback => 'بازخورد';

  @override
  String get exit => 'خروج';

  @override
  String get ruleSettings => 'تنظیمات قوانین';

  @override
  String get color => 'رنگ';

  @override
  String get boardColor => 'رنگ تخته';

  @override
  String get pieceColor => 'رنگ مهره';

  @override
  String get backgroundColor => 'رنگ پس زمینه';

  @override
  String get lineColor => 'رنگ خطوط تخته';

  @override
  String get whitePieceColor => 'رنگ مهره بازیکن ۱';

  @override
  String get blackPieceColor => 'رنگ مهره بازیکن ۲';

  @override
  String get messageColor => 'رنگ پیام';

  @override
  String get isPieceCountInHandShown => 'نشان‌دادن تعداد مهره‌های موجود در دست';

  @override
  String get isNotationsShown => 'نمایش مختصات';

  @override
  String get isHistoryNavigationToolbarShown =>
      'نمایش نوار ابزار پیمایش تاریخچه';

  @override
  String get display => 'نمایش دادن';

  @override
  String get boardBorderLineWidth => 'عرض خطوط مرزی تخته';

  @override
  String get boardInnerLineWidth => 'عرض خطوط داخلی تخته';

  @override
  String get pieceWidth => 'عرض مهره';

  @override
  String get fontSize => 'اندازه قلم';

  @override
  String get standardNotation => 'علامت‌گذاری استاندارد';

  @override
  String get restore => 'بازگرداندن';

  @override
  String get restoreDefaultSettings => 'بازیابی تنظیمات پیشفرض';

  @override
  String pick(Object element) {
    return 'انتخاب $element';
  }

  @override
  String get info => 'اطلاعات';

  @override
  String get hint => 'راهنمایی';

  @override
  String get player => 'بازیکن';

  @override
  String get player1 => 'بازیکن ۱';

  @override
  String get player2 => 'بازیکن ۲';

  @override
  String get howToPlay => 'آموزش بازی';

  @override
  String get toPlacePiece =>
      'برای قرار دادن مهره ، روی هر خانه(نقطه) موجود ضربه بزنید.';

  @override
  String get toSelectPiece => 'برای حرکت دادن یک مهره روی آن ضربه بزنید.';

  @override
  String get toMovePiece =>
      'برای حرکت دادن یک مهره روی خانه(نقطه) مجاور ضربه بزنید.';

  @override
  String get toRemovePiece => 'برای حذف کردن مهره حریف روی آن ضربه بزنید.';

  @override
  String get needToCreateMillFirst =>
      'قبل از اینکه بتوانید مهره ای را حذف کنید ، ابتدا باید یک دوز ایجاد کنید.';

  @override
  String get needToPlayWithOwnPieces =>
      'شما باید با مهره‌های خودتان بازی کنید.';

  @override
  String get statistics => 'آمار';

  @override
  String get totalGames => 'کل بازی‌های انجام شده';

  @override
  String get results => 'نتایج';

  @override
  String get left => 'ترک کرد';

  @override
  String get privacyPolicy => 'سیاست حفظ حریم خصوصی';

  @override
  String get privacyPolicy_Detail_1 =>
      'لطفاً با دقت مطالعه کنید و اطمینان حاصل کنید که آن را کاملاً درک کرده و با آن موافق هستید ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. اگر با این سیاست موافق نیستید ، لطفاً از این برنامه استفاده نکنید. استفاده از برنامه به معنای پذیرفتن این شرایط است.';

  @override
  String get and => ' و ';

  @override
  String get accept => 'پذیرفتن';

  @override
  String get takeBack => 'پس گرفتن';

  @override
  String get takingBack => 'در حال پس گرفتن…';

  @override
  String get waiting => 'در حال انتظار…';

  @override
  String get stepForward => 'قدم به جلو';

  @override
  String get takeBackAll => 'پس گرفتن همه';

  @override
  String get stepForwardAll => 'جلو رفتن تا انتها';

  @override
  String get moveNow => 'حالا حرکت کن';

  @override
  String get done => 'انجام شده.';

  @override
  String get crackMill => 'دوز را در هم بشکنید';

  @override
  String get crackMill_Detail =>
      'اگر بازیکنی فقط مهره‌هایی در دوزها داشته باشد، مهره‌های موجود در دوز برای حذف شدن قفل نمی‌شوند.';

  @override
  String get animationDuration => 'مدت زمان انیمیشن';

  @override
  String get none => 'هیچ‌یک';

  @override
  String get theme => 'پوسته';

  @override
  String get helpContent =>
      'هدف بازی این است که بازی کن حریف را با کمتر از سه مهره بازی یا بدون هیچ راهی برای حرکت، شکست دهد.\n\nاگر در آخرین ۱۰۰ حرکت باقی مانده هیچ مهره ای حذف نشود یا یک محل سه بار پیش بیاید، بازی به طور اتوماتیک مساوی می‌شود\n\nاین بازی سه فاز دارد:\n۱. مهره ها روی نقاط خالی قرار میگیرند\n۲. مهره ها به نقاط کنارشان قابل حرکتند\n۳. (اختیاری) حرکت مهره ها به هریک از نقاط خالی در هنگام کم کردن مهره های حریف\n\nگذاشتن مهره ها:\nبازی با یک تخته خالی شروع می‌شود که شامل یک جدول با ۲۴ نقطه است\nبازیکن ها به ترتیب مهره های خود را روی نقاط خالی میگذارند تا تمامی مهره هایشان رو تخته باشد. اگر بازی کنی بتواند سه تا از مهره هایش را به طور خط مستقیم قرار دهد شانس برداشتن یکی از مهره های حریف را به دست میاورد که به اصطلاح دوز می‌گیرد \n\nبازیکن ابتدا باید مهره‌های دیگر حریف را که خارج از دوز هستند حذف کند، مگر اینکه هیچ مهره دیگری خارج از دوز وجود نداشته باشد.\n\nدر بعضی شرایط نمیتوانید مهره هایتان را در نقاطی قرار دهید که قبلا رویشان مهره دیگری بوده\n\nبعد از این که تمامی مهره ها رو تخته قرار گیرد بازیکنان به ترتیب می‌توانند مهره هایشان را حرکت بدهند\n\nحرکت دادن\nبرای حرکت دادن بازی کن باید مهره خود را در در نقطه خالی که توسط یک خط به نقطه خودش وصل است منتقل کند\nاگر نتواند بازی را باخته است\nبازیکنی که سه تا از مهره هایش را کنار هم روی یک خط قرار دهد دوز می‌گیرد در فاز مهره گذاری و می‌تواند یکی از مهره های حریف را حذف کند \nهر بازی کنی که مهره هایش به دو عدد برسد دیگر شانس دوز کردن ندارد و در نتیجه بازی را میبازد\nبازیکنانی که سه مهره دارند ولی بازیکن دیگری جلوی حرکت مهره هایشان را گرفته باشد هم بازی را میبازد\n\nپرواز\n\nدر بعضی موارد بازی، اگر برای بازیکنی فقط سه مهره باقی مانده باشد، مهره هایش می‌توانند پرواز کنند یا روی هر نقطه خالی بپرند حتی اگر نقاط خالی کنارشان نباشد';

  @override
  String get versionInfo => 'اطلاعات نسخه';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'مجوز';

  @override
  String get sourceCode => 'کد منبع';

  @override
  String get appVersion => 'نسخه برنامه';

  @override
  String get general => 'عمومی';

  @override
  String get advanced => 'پیشرفته';

  @override
  String get placing => 'جای‌گذاری';

  @override
  String get moving => 'حرکت';

  @override
  String get removing => 'حذف کردن';

  @override
  String get gameOverCondition => 'شرایط Game Over';

  @override
  String get aisPlayStyle => 'سبک بازی هوش مصنوعی';

  @override
  String get passive => 'انفعالی';

  @override
  String get timeout => 'مهلت زمانی';

  @override
  String get appearance => 'ظاهر';

  @override
  String get drawOnHumanExperience => 'استفاده از تجربه انسان';

  @override
  String get considerMobility => 'در نظر گرفتن تحرک مهره‌ها';

  @override
  String get pieceCount => 'تعداد مهره‌ها:';

  @override
  String inHand(Object player, int count) {
    return '$player در دست: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player روی تخته: $count';
  }

  @override
  String get boardTop => 'فاصله تخته بازی از بالا';

  @override
  String get notAIsTurn => 'نوبت هوش مصنوعی نیست.';

  @override
  String get aiIsNotThinking => 'هوش مصنوعی در حال فکر کردن نیست.';

  @override
  String get atEnd => 'در پایان لیست حرکت‌ها قرار دارید.';

  @override
  String get tapBackAgainToLeave =>
      'برای خروج از برنامه ، دوباره روی دکمه برگشت ضربه بزنید.';

  @override
  String get more => 'بیشتر';

  @override
  String get experimental => 'این یک ویژگی تجربی است.';

  @override
  String get experiments => 'آزمایش';

  @override
  String get ossLicenses => 'مجوزهای منبع آزاد';

  @override
  String get language => 'زبان';

  @override
  String get defaultLanguage => 'زبان پیش فرض';

  @override
  String get mayMoveInPlacingPhase =>
      'مهره‌ها می توانند در مرحله جای‌گذاری حرکت کنند';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'هیچ مرحله مشخصی برای قرار دادن و حرکت وجود ندارد ، به عنوان مثال بازیکنان می توانند در هر حرکت تصمیم بگیرند که آیا می خواهند مهره ای را روی صفحه قرار دهند یا یکی از مهره‌های خود را حرکت دهند (به شرط اینکه مهره‌هایی برای قرار دادن باقی مانده باشد).';

  @override
  String get drawerColor => 'رنگ منو';

  @override
  String get drawerTextColor => 'رنگ متن منو';

  @override
  String get drawerHighlightItemColor => 'رنگ مورد برجسته منو';

  @override
  String get mainToolbarBackgroundColor => 'رنگ زمینه اصلی نوار ابزار';

  @override
  String get mainToolbarIconColor => 'رنگ نماد نوار ابزار اصلی';

  @override
  String get navigationToolbarBackgroundColor => 'رنگ زمینه نوار ابزار پیمایش';

  @override
  String get navigationToolbarIconColor => 'رنگ نماد نوار ابزار پیمایش';

  @override
  String get autoHideToolbar => 'به طور خودکار نوار ابزار را مخفی کنید';

  @override
  String get toolbarLocationOnScreen => 'مکان نوار ابزار روی صفحه';

  @override
  String get top => 'بالا';

  @override
  String get bottom => 'پایین';

  @override
  String get center => 'مرکز';

  @override
  String get solidColor => 'رنگ جامد';

  @override
  String get picture => 'تصویر';

  @override
  String get chooseYourPicture => 'عکس خود را انتخاب کنید';

  @override
  String get light => 'روشن';

  @override
  String get dark => 'تاریک';

  @override
  String get themes => 'پوسته‌ها';

  @override
  String get currentTheme => 'پوسته فعلی';

  @override
  String get saveTheme => 'ذخیره پوسته';

  @override
  String get showAnalysisGraph => 'نمودار تجزیه و تحلیل را نشان دهید';

  @override
  String get analysis => 'تحلیل و بررسی';

  @override
  String get saveGame => 'ذخیره بازی';

  @override
  String get loadGame => 'بازی را بارگذاری کنید';

  @override
  String get setupPosition => 'موقعیت راه اندازی';

  @override
  String get showLegalMoves => 'حرکات قانونی را نشان دهید';

  @override
  String get showLastMove => 'آخرین حرکت را نشان دهید';

  @override
  String get showArrows => 'پیکان‌ها را نشان دهید';

  @override
  String get pieces => 'مهره‌ها';

  @override
  String get showAnalysis => 'تجزیه و تحلیل را نشان دهید';

  @override
  String get threads => 'رشته‌ها';

  @override
  String get getInvolved => 'مشارکت کنید';

  @override
  String get helpImproveTranslate => 'به بهبود ترجمه کمک کنید';

  @override
  String get tutorial => 'آموزش';

  @override
  String get classicMill => 'آسیاب کلاسیک';

  @override
  String get mixedMill => 'آسیاب مخلوط';

  @override
  String get ceylonMill => 'آسیاب سیلان';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'آسیاب ممکن است بارها شکسته و دوباره ساخته شود';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'اگر بازیکنی آسیاب را بشکند تا بلافاصله آسیاب جدیدی ایجاد کند ، اگر یک آسیاب جدید ایجاد کند ، در حرکت بعدی خود می تواند آن مهره را به محل اصلی برگرداند.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'اگر بازیکنی سه مهره داشته باشد و پس از ده حرکت هیچ بازیکنی مهره‌های حریف را برندارد بازی به تساوی می‌رسد';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'هنگامی که یک بازیکن به سه مهره کاهش می یابد و هیچ یک از بازیکنان نمی توانند در طی ده حرکت مهره حریف را بردارند ، بازی مساوی است.';

  @override
  String get close => 'بستن';

  @override
  String get whitePiece => 'مهره سفید';

  @override
  String get blackPiece => 'مهره مشکی';

  @override
  String get emptyPoint => 'نقطه خالی';

  @override
  String get noPoint => 'نقطه معتبر نیست';

  @override
  String get placingPhase => 'فاز قرار دادن';

  @override
  String get movingPhase => 'فاز حرکت';

  @override
  String get flyingPhase => 'فاز پرواز';

  @override
  String sideToMove(Object player) {
    return 'نوبت حرکت: $player';
  }

  @override
  String lastMove(Object move) {
    return 'آخرین حرکت: $move';
  }

  @override
  String get selected => 'انتخاب شد';

  @override
  String get accessibility => 'دسترس‌پذیری';

  @override
  String get screenReaderSupport => 'پشتیبانی از صفحه خوان';

  @override
  String get isDraw => 'مساوی است!';

  @override
  String get draw => 'مساوی';

  @override
  String get pieceHighlightColor => 'رنگ برجسته مهره';

  @override
  String get algorithm => 'الگوریتم';

  @override
  String get endgameNMoveRule => 'قانون N حرکت در پایان بازی';

  @override
  String get endgameNMoveRule_Detail =>
      'اگر هریک از بازیکنان فقط سه مهره داشته باشد و هیچ یک از بازیکنان مهره ای را در حرکات خاص حذف نکنند ، بازی مساوی می شود.';

  @override
  String get drawReasonEndgameRule50 =>
      'هر یک از بازیکنان فقط سه مهره دارد و هیچ یک از بازیکنان مهره ای را در حرکات خاص بر نمی دارد.';

  @override
  String get threefoldRepetitionRule => 'قانون تکرار سه گانه';

  @override
  String get threefoldRepetitionRule_Detail =>
      'اگر موقعیتی برای سومین بار رخ دهد ، بازی مساوی می شود.';

  @override
  String get continueToMakeMove => 'دوز! به حرکت خود ادامه دهید.';

  @override
  String get pointStyle => 'سبک نقطه';

  @override
  String get pointWidth => 'عرض نقطه';

  @override
  String get solid => 'جامد';

  @override
  String get hollow => 'توخالی';

  @override
  String get languageName => 'فارسی';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count حرکت می کند',
      one: '$count حرکت',
      zero: 'حرکت',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'بارگیری انجام نشد.';

  @override
  String get filename => 'نام فایل';

  @override
  String get browse => 'مرور کردن…';

  @override
  String get gameFiles => 'فایل‌های بازی';

  @override
  String get gameSavedTo => 'بازی ذخیره شد در:';

  @override
  String get empty => 'خالی';

  @override
  String get noMove => 'بدون حرکت.';

  @override
  String get restoredPosition => 'موقعیت اولیه بازیابی شد.';

  @override
  String get clean => 'پاک کردن';

  @override
  String get cleanedUp => 'پاک شد.';

  @override
  String get remove => 'برداشتن';

  @override
  String get noPiecesCanBeRemoved => 'هیچ مهره‌ای را نمی توان حذف کرد.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count مهره',
      one: '$count مهره',
      zero: 'مهره',
    );
    return '$_temp0 باید حذف شود.';
  }

  @override
  String placedCount(int count) {
    return 'قرار داده شده ($count)';
  }

  @override
  String get placedPieceCount =>
      'تعداد مهره‌ها قرار داده شده در مرحله قرار دادن.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'بازیکن فعلی $count مهره‌ها را قرار داده است.';
  }

  @override
  String get notPlacingPhase =>
      'مرحله جای‌گذاری نیست، نمی‌توان آن را تغییر داد.';

  @override
  String get paste => 'چسباندن';

  @override
  String get pasteDone => 'عملیات چسباندن انجام شد.';

  @override
  String get cannotPaste => 'نمی توان چسباند.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'نشان دادن مهره‌های جای‌گذاری نشده و حذف شده';

  @override
  String get fullScreen => 'تمام صفحه';

  @override
  String get reopenToTakeEffect =>
      'برای اعمال تنظیمات از برنامه خارج شده و دوباره باز کنید.';

  @override
  String get forest => 'جنگل';

  @override
  String get desktopImage => 'تصویر دسکتاپ';

  @override
  String get invalidPosition => 'موقعیت نامعتبر';

  @override
  String get shareGIF => 'GIF را به اشتراک بگذارید';

  @override
  String get pixelRatio => 'نسبت پیکسل';

  @override
  String get duration => 'مدت زمان';

  @override
  String get gameScreenRecorder => 'ضبط کننده صفحه بازی';

  @override
  String get previous => 'قبلی';

  @override
  String get next => 'بعد';

  @override
  String get skip => 'پرش کنید';

  @override
  String get gotIt => 'فهمیدم';

  @override
  String get youCanModifyRules =>
      'می توانید قوانین بازی را در تنظیمات قوانین تغییر دهید.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'می توانید از چرخ ماوس برای تغییر مقدار در انتخابگر استفاده کنید.';

  @override
  String get noTimeLimitForThinking =>
      'زمان تفکر هوش مصنوعی روی 0 تنظیم شده است به این معنی که محدودیت زمانی برای فکر کردن وجود ندارد.';

  @override
  String get whatIsMtdf =>
      'MTD(f) شکل اصلاح شده ای از الگوریتم جستجوی آلفا-بتا است که هدف آن بهبود کارایی با استفاده مجدد از نتایج جستجوی میانی و استفاده از حدس اولیه خوب برای محدود کردن فضای جستجو است.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'لطفاً توجه داشته باشید که تنظیم زمان تفکر هوش مصنوعی ممکن است کاملاً دقیق نباشد. زمانی که سطح دشواری روی مقدار کمتری تنظیم می‌شود، ممکن است زمان واقعی فکر کوتاه‌تر باشد و وقتی زمان تمام می‌شود، ممکن است زمانی طولانی‌تر شود.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'اگر سطح دشواری را بالا تنظیم کنید اما زمان تفکر هوش مصنوعی را افزایش ندهید، سطح دشواری واقعی ممکن است به مقدار کمتری به دلیل محدودیت زمان تفکر محدود شود. مقدار واقعی ممکن است بر اساس عملکرد دستگاه متفاوت باشد.';

  @override
  String get whatIsPvs =>
      'PVS (جستجوی تغییرات اصلی) یک الگوریتم جستجو برای یافتن بهترین حرکت در یک موقعیت خاص است. این یک بهبود یافته از الگوریتم آلفا-بتا است و از جستجوهای پنجره صفر یا تهی برای تأیید اینکه یک حرکت بدتر یا بدتر از نمره ایمن قبلی از تغییرات اصلی است استفاده می کند. PVS روی امیدوارکننده‌ترین حرکت‌ها تمرکز می‌کند و از جستجوهای غیرضروری در شاخه‌های غیربهینه اجتناب می‌کند، که به بهبود کارایی جستجو کمک می‌کند.';

  @override
  String get whatIsAlphaBeta =>
      'الگوریتم آلفا بتا یک الگوریتم جستجو برای یافتن بهترین حرکت است. از اصل minimax و دو مقدار آلفا و بتا برای هرس درخت جستجو و افزایش کارایی استفاده می کند. آلفا نشان دهنده حداقل امتیازی است که رایانه مطمئن است می تواند کسب کند، در حالی که بتا نشان دهنده حداکثر امتیازی است که حریف می تواند کسب کند. این الگوریتم به رایانه کمک می کند تا تصمیمات هوشمندانه و کارآمد را در یک بازی بگیرد.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'با توجه به تجربه بشر، اگر برای بردن تلاش کنید، بازنده خواهید شد. در عوض، تساوی را هدف خود قرار دهید و از باختن بازی اجتناب کنید. حریف خود را مشاهده کنید و به آرامی آنها را در موقعیتی قرار دهید که ممکن است اشتباه کنند. وقتی ضعف نشان می دهند، فرصت را غنیمت شمرده و به آرامی برای پیروزی فشار بیاورید. به این ترتیب می توانید برنده بازی شوید.';

  @override
  String get firstMoveDetail =>
      'در این بازی برنده شدن بازیکن دوم نسبت به بازیکن اول راحت تر است.';

  @override
  String get passiveDetail =>
      'فعال کردن گزینه Passive باعث می‌شود هوش مصنوعی زمانی که در موقعیت مزیتی دارد، به جای تلاش تهاجمی برای برنده شدن در سریع‌ترین زمان ممکن، آرام شود.';

  @override
  String get moveRandomlyDetail =>
      'فعال کردن این گزینه تصادفی بودن و سرگرمی بازی را افزایش می دهد در حالی که غیرفعال کردن آن می تواند به مطالعه راه های شکست هوش مصنوعی کمک کند.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'اگر هوش مصنوعی تحرک مهره های خود را در نظر بگیرد، نه تنها به دنبال گرفتن مهره های حریف در سریع ترین زمان ممکن است، بلکه به فکر جلوگیری از حرکات حریف و جلوگیری از انجام همین کار خواهد بود.';

  @override
  String get whenBoardIsFull => 'وقتی تخته پر شد';

  @override
  String get whenBoardIsFull_Detail =>
      'در پایان مرحله قرار دادن، قبل از شروع فاز حرکت، اگر تخته پر از مهره باشد، عمل انجام می شود.';

  @override
  String get sideToMoveRemovePiece =>
      'بازیکنی که در مرحله حرکت اول حرکت می کند یکی از مهره‌های حریف را برمی دارد.';

  @override
  String get agreeToDraw => 'هر دو طرف موافق تساوی هستند.';

  @override
  String get takeOpponentsPiece => 'یکی از مهره‌های حریف را بردارید.';

  @override
  String get firstPlayerLose => 'بازیکن اول بازی را می بازد.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'بازیکن اول و دوم یکی از مهره‌های حریف را برمی دارند.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'بازیکنان دوم و اول یکی از مهره‌های حریف را برمی دارند.';

  @override
  String get enteredFlyingPhase =>
      'حالا که وارد فاز پرواز شده، مهره‌های حریف می توانند به هر نقطه خالی روی تخته بپرند. می توانید قانون پرواز را در \"تنظیمات قانون\" خاموش کنید.';

  @override
  String get whenStalemate => 'وقتی بن بست';

  @override
  String get whenStalemate_Detail =>
      'وقتی هیچ مهره‌ای قابل جابجایی نباشد چه عملی انجام می شود؟';

  @override
  String get endWithStalemateLoss =>
      'با یک باخت در بن بست برای طرفی که مسدود شده است پایان دهید.';

  @override
  String get changeSideToMove => 'سمت را برای حرکت تغییر دهید.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'یکی از مهره‌های حریف را بردارید و حرکت بعدی را انجام دهید.';

  @override
  String get endWithStalemateDraw => 'با تساوی بن بست پایان دهید.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'یکی از مهره‌های حریف را بردارید و طرف را برای حرکت تغییر دهید.';

  @override
  String get aiResponseDelayTime => 'زمان تاخیر پاسخ هوش مصنوعی';

  @override
  String get aiIsDelaying =>
      'هوش مصنوعی در حال حاضر در مرحله پاسخ تاخیری قرار دارد. لطفاً قبل از ادامه مدتی صبر کنید.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'شما نمی توانید یک مهره غیر مجاور را بردارید.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'در صورت بن بست، مهره‌های حریف در مجاورت مهره شما بدون توجه به شکل گیری آسیاب می توانند حذف شوند.';

  @override
  String get whatIsMcts =>
      'MCTS یک الگوریتم مبتدی دوست است که با کاوش و ارزیابی حرکات مختلف از طریق شبیه سازی، تصمیم می گیرد.';

  @override
  String get goldenJade => 'یشم طلایی';

  @override
  String get forestWood => 'جنگل چوب';

  @override
  String get darkMystery => 'رمز و راز تاریک';

  @override
  String get midnightBlue => 'آبی نیمه شب';

  @override
  String get greenForest => 'جنگل سبز';

  @override
  String get greenMeadow => 'سبزه زار';

  @override
  String get stonyPath => 'مسیر سنگی';

  @override
  String get pastelPink => 'صورتی پاستلی';

  @override
  String get turquoiseSea => 'دریای فیروزه';

  @override
  String get violetDream => 'رویای بنفش';

  @override
  String get mintChocolate => 'شکلات نعنا';

  @override
  String get skyBlue => 'آبی آسمانی';

  @override
  String get playfulGarden => 'باغ بازیگوش';

  @override
  String get whatIsRetrogradeAnalysis =>
      'الگوریتم تحلیل رتروگراد از تحلیل رتروگراد چند ارزشی برای ساخت یک پایگاه داده پایان بازی از موقعیت های مختلف شروع استفاده می کند، سپس این پایگاه داده را برای بهینه سازی گیم پلی اعمال می کند. این رویکرد در دسته راه حل های فوق العاده قوی قرار می گیرد.';

  @override
  String get viewAlgorithmGuide =>
      'آیا می خواهید راهنمای کاربر این الگوریتم را مشاهده کنید؟';

  @override
  String get showPositionalAdvantageIndicator =>
      'نشانگر مزیت موقعیتی را نشان دهید';

  @override
  String get usePerfectDatabase => 'با استفاده از پایگاه داده کامل';

  @override
  String get perfectDatabaseDescription =>
      'این گزینه را فعال کنید تا از یک پایگاه داده بازی بی‌عیب و نقص که توسط الگوریتم‌های پیشرفته ایجاد شده است، استفاده کنید. این ویژگی استراتژی‌های ابتدایی و پایانی بازی را یکپارچه می‌کند تا حرکات بهینه را پیشنهاد دهد. این گزینه برای بازیکنانی که به دنبال بالاترین سطح دقت در بازی هستند، انتخاب اول است. این پایگاه داده توسط تکنیک‌های محاسباتی دقیق ایجاد شده و به منظور ارائه راه‌حل‌های تقریباً کامل برای بازی طراحی شده است.\n\nتوجه: در صورتی که هوش مصنوعی نتواند به پایگاه داده دسترسی پیدا کند، از الگوریتم‌های سنتی برای تصمیم‌گیری در بازی استفاده خواهد کرد. هنگامی که پایگاه داده در دسترس است، \'سطح دشواری\' تقریباً ناپشتیبانی‌پذیر می‌شود و \'زمان تفکر هوش مصنوعی\' به طور قابل توجهی کاهش می‌یابد. تنظیمات زیادی در گزینه‌های \'سبک بازی هوش مصنوعی\' نیز دور زده خواهند شد، زیرا نتایج پایگاه داده بالاترین اولویت را دارند.\n\nبرای راهنمایی در مورد چگونگی بهره‌برداری بهینه از این پایگاه داده بی‌عیب و نقص، اینجا کلیک کنید.';

  @override
  String get backgroundImage => 'تصویر پس‌زمینه';

  @override
  String get whatIsRandom =>
      'زمانی که گزینه \'استفاده از پایگاه داده کامل\' فعال نیست، تنظیم \'تصادفی\' باعث می‌شود که هوش مصنوعی قطعات را بدون استفاده از هیچ الگوریتمی برای انتخاب حرکت، به طور تصادفی جابجا کند. این معمولاً منجر به بازی ضعیف‌تر می‌شود. در مقابل، زمانی که گزینه \'استفاده از پایگاه داده کامل\' فعال است، هوش مصنوعی صرفاً برای تصمیم‌گیری به \'پایگاه داده کامل\' متکی است، به جای ترکیب آن با الگوریتم‌های سنتی هوش مصنوعی. در این حالت، حرکات هوش مصنوعی کاملاً بر اساس محتوای پایگاه داده است و از تکیه بر محاسبات زمان واقعی یا الگوریتم‌های جستجو خودداری می‌کند.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'مهره(های) حریف را از دستشان بردارید؛ سپس نوبت حریف برای قرار دادن است.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'هنگام تشکیل دوز در مرحله قرار دادن';

  @override
  String get removeOpponentsPieceFromBoard =>
      'مهره(های) حریف را از صفحه بردارید.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'مهره(های) حریف را از صفحه بردارید؛ سپس نوبت حریف برای قرار دادن است.';

  @override
  String get opponentRemovesOwnPiece =>
      'حریف مهره(های) خود را از صفحه برمی‌دارد.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'به جای اینکه شما اقدام کنید، حریف مهره(های) خود را از صفحه انتخاب کرده و برمی‌دارد، که این اقدام به طور مؤثری به ضرر خودش است.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'مهره(های) حریف را از دستشان بردارید؛ سپس نوبت شما برای حرکت است.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'مهره(ها) را از دست حریف بردارید. اگر طبق تنظیمات حذف چندگانه، قرار است چندین مهره برداشته شود و حریف هیچ مهره‌ای در دست نداشته باشد، ادامه دهید تا مهره‌های حریف را از صفحه بردارید. سپس نوبت شما برای حرکت است. اگر به تشکیل دوز ادامه دهید، می‌توانید مهره‌های حریف را برداشتن ادامه دهید.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'مهره(ها) را از دست حریف بردارید. اگر طبق تنظیمات حذف چندگانه، قرار است چندین مهره برداشته شود و حریف هیچ مهره‌ای در دست نداشته باشد، ادامه دهید تا مهره‌های حریف را از صفحه بردارید. سپس نوبت حریف برای حرکت است.';

  @override
  String get markAndDelayRemovingPieces =>
      'مهره‌ها را علامت‌گذاری کرده و تاخیر در برداشتن آن‌ها ایجاد کنید.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'در مرحله قرار دادن، مهره‌هایی که قرار است برداشته شوند علامت‌گذاری می‌شوند و برای هر دو بازیکن، امکان قرار دادن مهره‌های جدید در این نقاط وجود ندارد. هنگام ورود به مرحله حرکت، این مهره‌های علامت‌دار به طور کامل برداشته می‌شوند و بازیکنان سپس می‌توانند مهره‌های خود را به این نقاط اکنون خالی حرکت دهند.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'اقداماتی که هنگام تشکیل دوزها در فاز قرار دادن می‌توان انجام داد.';

  @override
  String get marked => 'علامت‌گذاری شده';

  @override
  String get menu => 'منو';

  @override
  String get monochrome => 'تک‌رنگ';

  @override
  String get youCanEnableScreenReaderSupport =>
      'شما می‌توانید پشتیبانی از خواننده صفحه را در تنظیمات دسترس‌پذیری در تنظیمات عمومی فعال کنید.';

  @override
  String get showNumbersOnPieces => 'نمایش اعداد روی مهره‌ها';

  @override
  String get saveImage => 'تصویر را ذخیره کنید';

  @override
  String get isAnalysisToolbarShown => 'نمایش نوار ابزار تحلیل';

  @override
  String get analysisToolbarBackgroundColor => 'رنگ پس زمینه نوار ابزار تحلیل';

  @override
  String get analysisToolbarIconColor => 'رنگ آیکون نوار ابزار تحلیل';

  @override
  String get transformed => 'تبدیل شد.';

  @override
  String get cannotTransform => 'نمی‌توان تبدیل کرد.';

  @override
  String get rotate => 'چرخش';

  @override
  String get horizontalFlip => 'افقی فلیپ';

  @override
  String get verticalFlip => 'عمودی فلیپ';

  @override
  String get innerOuterFlip => 'IO فلیپ';

  @override
  String get transparentCanvas => 'بوم شفاف';

  @override
  String get restrictRepeatedMillsFormation => 'محدود کردن تشکیل دوزهای تکراری';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'یک مهره که از یک دوز به دوز دیگر منتقل شده است نمی‌تواند بلافاصله به نقطه اصلی در دور بعدی بازگردد تا دوباره دوز تشکیل دهد. ابتدا نیاز به حرکتی متفاوت است.';

  @override
  String get oneTimeUseMill => 'دوز یک‌بار مصرف';

  @override
  String get oneTimeUseMill_Detail =>
      'هر دوز فقط یک بار می‌تواند مهره‌ای از حریف را حذف کند. شما می‌توانید دوباره آن را بازسازی کنید، اما نمی‌توان از آن برای حذف‌های اضافی استفاده کرد.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'قوانین فعلی که تنظیم کرده‌اید، پایگاه داده کاملی ندارند. برای کسب اطلاعات بیشتر در مورد پایگاه داده کامل، لطفاً اینجا کلیک کنید.';

  @override
  String get focusOnBlockingPaths => 'تمرکز بر روی مسدود کردن مسیرها';

  @override
  String get focusOnBlockingPaths_Detail =>
      'در مراحل خاصی از بازی، به جای تشکیل دوز، اولویت به مسدود کردن حرکت حریف دهید. به جای تمرکز بر حذف مهره‌ها با تکدوز دوز، هوش مصنوعی هدف دارد که در این مراحل حریف را به دام بیندازد، او را ناتوان از حرکت کند و از طریق فرسایش به جای بازی تهاجمی، پیروزی را تضمین کند. این استراتژی که مختص به مراحلی خاص است، به‌طور فعال دوز‌های حریف را مسدود نمی‌کند.';

  @override
  String get pieceImage => 'تصویر مهره';

  @override
  String get importColorSettings => 'وارد کردن تنظیمات رنگ';

  @override
  String get exportColorSettings => 'صادر کردن تنظیمات رنگ';

  @override
  String get import => 'وارد کردن';

  @override
  String get export => 'صادر کردن';

  @override
  String get pleaseCopyJsonToClipboard =>
      'لطفاً ابتدا تنظیمات قالب JSON را به کلیپ بورد کپی کنید.';

  @override
  String get copiedToClipboard => 'به کلیپ بورد کپی شد.';

  @override
  String get imported => 'وارد شد.';

  @override
  String get boardImage => 'تصویر تخته';

  @override
  String get autumnLeaves => 'برگ‌های پاییزی';

  @override
  String get legendaryLand => 'سرزمین افسانه‌ای';

  @override
  String get vignetteEffect => 'افکت وینیت';

  @override
  String get promptMakeToolbarTransparent =>
      'آیا می‌خواهید نوار ابزار کاملاً شفاف شود وقتی تصویر پس‌زمینه‌ی تخته تنظیم شده است؟';

  @override
  String get vibration => 'فعال کردن لرزش در بازی';

  @override
  String get soundTheme => 'تم صدا';

  @override
  String get ball => 'توپ';

  @override
  String get liquid => 'مایع';

  @override
  String get wood => 'چوب';

  @override
  String get placeEffectAnimation => 'اثر انیمیشن قرار دادن مهره';

  @override
  String get removeEffectAnimation => 'اثر انیمیشن حذف مهره';

  @override
  String get isToolbarAtBottom => 'نمایش نوار ابزار در پایین';

  @override
  String get boardCornerRadius => 'شعاع گوشه تخته';

  @override
  String get useOpeningBook => 'از کتاب افتتاحیه استفاده کنید';

  @override
  String get currentRule => 'فعلی';

  @override
  String get nineMensMorris => 'موریس نه مردانه';

  @override
  String get twelveMensMorris => 'موریس دوازده مرد';

  @override
  String get morabaraba => 'مورابارابا';

  @override
  String get dooz => 'دوز';

  @override
  String get chamGonu => 'چامگونو';

  @override
  String get zhiQi => 'ژیه چی';

  @override
  String get chengSanQi => 'چنگ سان چی';

  @override
  String get mulMulan => 'مول-مولان';

  @override
  String get nerenchi => 'نرنچی';

  @override
  String get ruleSet => 'مجموعه قوانین';

  @override
  String get laskerMorris => 'لاسکر موریس';

  @override
  String get oneTimeMill => 'ملنیتسا';

  @override
  String get daSanQi => 'دا سان چی';

  @override
  String get useOpeningBook_Detail =>
      'به هوش مصنوعی اجازه دهید از حرکات افتتاحیه که به طور معمول توسط بازیکنان حرفه‌ای انسانی در ابتدای بازی استفاده می‌شود، استفاده کند. توجه: این ویژگی در حال حاضر فقط برای مجموعه‌های قوانین خاص در دسترس است.';

  @override
  String get showAdvantageGraph => 'نمودار مزیت را نشان دهید';

  @override
  String get advantageGraphHint =>
      'نمودار برتری تنها پس از انجام حرکت توسط هوش مصنوعی رسم می‌شود. هنگامی که بازیکن انسانی حرکت می‌کند، رسم نخواهد شد.';

  @override
  String get removalBasedOnMillCounts =>
      'حذف مهره‌ها را تا زمانی که همه قرار داده شوند غیرفعال کنید. بازیکنان بر اساس تعداد دوز مهره‌ها را حذف می‌کنند.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'حذف مهره‌ها را تا زمانی که همه قرار داده شوند غیرفعال کنید. بازیکنان بر اساس تعداد دوز مهره‌ها را حذف می‌کنند: اگر تعداد مساوی باشد، هر دو به همان میزان مهره حذف می‌کنند؛ اگر یکی تعداد بیشتری داشته باشد، یک مهره اضافه حذف کرده و اختلاف را در یک مهره نگه می‌دارد. اگر فقط یکی دوز تشکیل دهد، دو مهره حذف می‌کند و دیگری یک مهره را حذف می‌کند. اگر هیچ‌کدام دوز تشکیل ندهند، هر دو یک مهره حذف می‌کنند.';

  @override
  String get elfilja => 'الفلجة';

  @override
  String get tipSelectOwnPiece => 'یکی از مهره‌های خود را انتخاب کنید.';

  @override
  String get notYourTurn => 'نوبت شما نیست.';

  @override
  String get annotationToolbarBackgroundColor =>
      'رنگ پس‌زمینهٔ نوار ابزار حاشیه‌نویسی';

  @override
  String get annotationToolbarIconColor => 'رنگ آیکن نوار ابزار حاشیه‌نویسی';

  @override
  String get isAnnotationToolbarShown => 'نمایش نوار ابزار حاشیه‌نویسی';

  @override
  String get enterAnnotationMode => 'ورود به حالت حاشیه‌نویسی';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'آیا مطمئن هستید که می‌خواهید همهٔ حاشیه‌نویسی‌ها را پاک کنید؟';

  @override
  String get llmPromptCopiedToClipboard => 'پیام LLM در کلیپ‌بورد کپی شد.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'اتصال رد شد، ممکن است سرور خاموش باشد.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'جستجو موفقیت‌آمیز بود، در انتظار اتصال...';

  @override
  String get noLanConnection => 'هیچ ارتباط LAN وجود ندارد';

  @override
  String get takeScreenshot => 'گرفتن اسکرین‌شات';

  @override
  String get disconnectedFromOpponent => 'ارتباط با حریف قطع شد.';

  @override
  String get takeBackRequest => 'درخواست بازگرداندن حرکت';

  @override
  String get nothingToShow => 'چیزی برای نمایش وجود ندارد.';

  @override
  String get stopHosting => 'توقف میزبانی';

  @override
  String get connectionResetByPeer => 'اتصال توسط طرف مقابل بازنشانی شد.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'اتصال به دلیل پایان زمان ضربان از دست رفت. لطفاً دوباره متصل شوید.';

  @override
  String get startHosting => 'شروع میزبانی';

  @override
  String get restartRequestRejected => 'درخواست راه‌اندازی مجدد رد شد.';

  @override
  String get notConnectedToLanOpponent => 'به حریف در شبکه محلی متصل نیستید.';

  @override
  String get llmPrompt => 'پیام LLM';

  @override
  String get gameRestarted => 'بازی مجدداً آغاز شد.';

  @override
  String get takeBackRejected => 'درخواست بازگرداندن حرکت رد شد.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'آیا مطمئن هستید می‌خواهید از این بازی کناره‌گیری کنید؟';

  @override
  String get opponentResignedYouWin => 'حریف کناره‌گیری کرد. شما برنده‌اید!';

  @override
  String get clearAllAnnotations => 'پاک کردن همهٔ حاشیه‌نویسی‌ها';

  @override
  String get connectedWaitingForOpponentSMove =>
      'متصل شد، در انتظار حرکت حریف...';

  @override
  String get networkStatusDisconnected => 'وضعیت شبکه: قطع';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'درخواست بازگرداندن حرکت به حریف ارسال شد.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'ممکن است حریف بازی را ترک کرده باشد';

  @override
  String get connectedToHostSuccessfully => 'با موفقیت به میزبان متصل شد.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'اتصال از دست رفت: پایان زمان ضربان';

  @override
  String get noHostDiscovered => 'هیچ میزبانی یافت نشد.';

  @override
  String get confirmResignation => 'تأیید کناره‌گیری';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'میزبانی بازی آغاز شد، در انتظار پیوستن بازیکنان...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'اتصال منقضی شد، اتصال شبکه ناپایدار است.';

  @override
  String get noLlmPromptAvailable => 'هیچ پیام LLM در دسترس نیست.';

  @override
  String get youResignedGameOver => 'شما کناره‌گیری کردید. بازی پایان یافت.';

  @override
  String get serverIp => 'آی‌پی سرور';

  @override
  String get confirmClear => 'تأیید پاک کردن';

  @override
  String get opponentSTurn => 'نوبت حریف است.';

  @override
  String get waitingAClientConnection => 'در انتظار اتصال مشتری...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'درخواست بازگرداندن حرکت رد شد یا ناموفق بود.';

  @override
  String get addText => 'افزودن متن';

  @override
  String get exitAnnotationMode => 'خروج از حالت حاشیه‌نویسی';

  @override
  String get typeYourAnnotation => 'حاشیه‌نویسی خود را بنویسید';

  @override
  String get attemptingToReconnect => 'در حال تلاش برای اتصال مجدد...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'درخواست راه‌اندازی مجدد ارسال شد. در انتظار پاسخ حریف...';

  @override
  String get serverIsStopped => 'سرور متوقف شده است.';

  @override
  String get restartRequest => 'درخواست راه‌اندازی مجدد';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'نمی‌توانید هنگامی که نوبت شما نیست درخواست بازگرداندن حرکت کنید.';

  @override
  String get takeBackAccepted => 'درخواست بازگرداندن حرکت پذیرفته شد.';

  @override
  String get localNetworkSettings => 'تنظیمات شبکه محلی';

  @override
  String get reconnectedSuccessfully => 'با موفقیت مجدداً متصل شدید!';

  @override
  String get failedToSaveImageToGallery => 'ذخیره تصویر در گالری ناموفق بود.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'حریف درخواست راه‌اندازی مجدد بازی را دارد. آیا می‌پذیرید؟';

  @override
  String get yourTurn => 'نوبت شماست.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'امکان اتصال مجدد وجود ندارد، لطفاً بازی را دوباره شروع کنید.';

  @override
  String get host => 'میزبان';

  @override
  String get join => 'پیوستن';

  @override
  String get port => 'پورت';

  @override
  String get invalidIpAddress => 'آدرس آی‌پی نامعتبر است.';

  @override
  String get invalidPort => 'پورت نامعتبر است.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'در حال اتصال: تلاش $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'اتصال ناموفق: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'شروع میزبانی ناموفق بود: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'میزبان شناسایی شد: $ip:$port';
  }

  @override
  String get stop => 'توقف';

  @override
  String get discover => 'جستجو';

  @override
  String get connect => 'اتصال';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'مشتری متصل شد: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'در حال جستجو: $seconds ثانیه';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'در حال اتصال مجدد ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'متصل';

  @override
  String get delete => 'حذف';

  @override
  String get ancientEgypt => 'ایران باستان';

  @override
  String get gothicIce => 'یخچال خشتی';

  @override
  String get riceField => 'شالیزار گیلان';

  @override
  String get chinesePorcelain => 'چینی پرسلان';

  @override
  String get desertDusk => 'غروب کویر';

  @override
  String get precisionCraft => 'ظرافت قلمزنی';

  @override
  String get folkEmbroidery => 'سوزن‌دوزی بلوچی';

  @override
  String get carpathianHeritage => 'میراث هندوکش';

  @override
  String get imperialGrandeur => 'عظمت امپراتوری';

  @override
  String get bohemianCrystal => 'بلور اصفهان';

  @override
  String get savannaSunrise => 'طلوع خراسان';

  @override
  String get harmonyBalance => 'اعتدال و توازن';

  @override
  String get cinnamonSpice => 'عطر زعفران';

  @override
  String get anatolianMosaic => 'کاشی‌کاری ایرانی';

  @override
  String get carnivalSpirit => 'شور نوروز';

  @override
  String get custom => 'سفارشی';

  @override
  String get spiceMarket => 'بازار ادویه کابل';

  @override
  String get swipeToRevealTheDrawer => 'برای نمایش کشو بکشید';

  @override
  String get showGameInfoOnScreenshots => 'نمایش اطلاعات بازی در اسکرین‌شات‌ها';

  @override
  String get humanMoveTime => 'محدودیت زمانی حرکت انسان';

  @override
  String get noTimeLimitForHumanMoves =>
      'محدودیت زمانی برای حرکات انسان وجود ندارد';

  @override
  String get timeoutLoseWillBeApplied =>
      'باخت به دلیل اتمام زمان برای بازیکن انسانی اعمال خواهد شد';

  @override
  String get identifyingBoard => 'در حال شناسایی صفحهٔ بازی...';

  @override
  String get youCanEnterAnyModelName => 'می‌توانید هر نام مدلی را وارد کنید.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'وضعیت صفحه اعمال شد. FEN در کلیپ‌بورد کپی شد.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'پیشنهاد: سعی کنید عکس واضح‌تری از صفحه بازی بگیرید.';

  @override
  String get llmPromptTemplate => 'قالب پرامپت LLM';

  @override
  String get noValidBoardDetected => 'هیچ صفحه معتبری شناسایی نشد.';

  @override
  String get selectingImageFromAlbum => 'در حال انتخاب تصویر از آلبوم...';

  @override
  String get configurePromptTemplate => 'پیکربندی قالب پرامپت';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'ویرایش قالب پرامپت برای تحلیل LLM';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'ایجاد FEN از صفحه شناسایی‌شده ناموفق بود.';

  @override
  String get outputInCurrentLanguage => 'خروجی به زبان فعلی';

  @override
  String get commonBaseUrls => 'Base URLهای رایج';

  @override
  String get viewCommonModels => 'مشاهده مدل‌های متداول';

  @override
  String get recognitionParametersUpdated => 'پارامترهای شناسایی به‌روز شد.';

  @override
  String get whiteSMove => 'نوبت سفید';

  @override
  String get resetToDefaults => 'بازنشانی به مقادیر پیش‌فرض';

  @override
  String get photoShoot => 'عکسبرداری';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'اعمال وضعیت شناسایی‌شده صفحه ناموفق بود.';

  @override
  String get llmPromptContent => 'محتوای پرامپت LLM';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM پیکربندی نشده است. لطفاً تنظیمات خود را بررسی کنید.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'تنظیم ارائه‌دهنده، مدل، API Key و Base URL';

  @override
  String get llmConfiguration => 'پیکربندی LLM';

  @override
  String get configureLlmProvider => 'پیکربندی ارائه‌دهنده LLM';

  @override
  String get llmPromptTemplateHeader => 'هدر قالب پرامپت LLM';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'هیچ مهره‌ای در تصویر شناسایی نشد. لطفاً دوباره تلاش کنید.';

  @override
  String get recognizeBoardFromImage => 'شناسایی صفحه از تصویر';

  @override
  String get viewTips => 'مشاهده نکات';

  @override
  String get applyToBoard => 'اعمال به صفحه';

  @override
  String get adjustBoardArea => 'تنظیم ناحیه صفحه';

  @override
  String get viewCommonUrls => 'مشاهده URLهای متداول';

  @override
  String get colorAnalysisFailed => 'تحلیل رنگ ناموفق بود!';

  @override
  String get analyzingGameBoardImage =>
      'در حال تجزیه و تحلیل تصویر صفحه بازی...';

  @override
  String get selectFromAlbum => 'انتخاب از آلبوم';

  @override
  String get noBoardPointDetected => 'هیچ نقطه‌ای از صفحه شناسایی نشد!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'اگر خالی رها شود، قالب پیش‌فرض استفاده می‌شود';

  @override
  String get llmConfig => 'پیکربندی LLM';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'آیا مطمئن هستید که می‌خواهید قالب‌های پرامپت را به مقادیر پیش‌فرض بازنشانی کنید؟';

  @override
  String get llmPromptTemplateFooter => 'فوتر قالب پرامپت LLM';

  @override
  String get loadingResponse => 'در حال بارگذاری پاسخ...';

  @override
  String get applyThisResultToBoard => 'اعمال این نتیجه به صفحه';

  @override
  String get takingPicture => 'در حال عکسبرداری...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'لطفاً یک تصویر از صفحه بازی برای شناسایی انتخاب کنید';

  @override
  String get identificationResults => 'نتایج شناسایی';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'حرکات را تحلیل کرده و دیدگاه ارائه دهید.';

  @override
  String get getApiKey => 'دریافت API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'کل فرآیند شناسایی تکمیل نشد.';

  @override
  String get boardRecognitionResult => 'نتیجه شناسایی صفحه';

  @override
  String get askLlm => 'پرسش از LLM';

  @override
  String get boardDetectionFailed => 'شناسایی صفحه ناموفق بود!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'هیچ نقطه‌ای از صفحه شناسایی نشد، قادر به شناسایی مهره نیست!';

  @override
  String get copyFen => 'کپی FEN';

  @override
  String get commonlyUsedModels => 'مدل‌های متداول';

  @override
  String get apiKeyOptional => 'API Key (اختیاری)';

  @override
  String get noImageSelected => 'هیچ تصویری انتخاب نشده است';

  @override
  String get blackSMove => 'نوبت سیاه';

  @override
  String get llm => 'مدل زبانی بزرگ';

  @override
  String get llmProvider => 'ارائه‌دهنده';

  @override
  String get baseUrl => 'نشانی پایه';

  @override
  String get model => 'مدل';

  @override
  String get temperature => 'دما';

  @override
  String get llmCommandReceivedProcessing =>
      'دستور دریافت شد! هوش مصنوعی در حال پردازش است...';

  @override
  String get llmDeepThinkingWait =>
      'تفکر عمیق در حال انجام است، لطفاً صبر کنید...';

  @override
  String get llmPresentingSoon => 'به زودی ارائه می‌شود...';

  @override
  String get recognitionParameters => 'پارامترهای تشخیص';

  @override
  String get adjustParamsDesc => 'پارامترها را برای بهبود دقت تشخیص تنظیم کنید';

  @override
  String get saveParameters => 'ذخیره پارامترها';

  @override
  String unableToStartImageRecognition(String error) {
    return 'شروع تشخیص تصویر ممکن نیست: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'تشخیص تصویر ناموفق بود: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'وضعیت اعمال‌شده با $whiteCount مهره سفید و $blackCount مهره سیاه';
  }

  @override
  String get fenCopiedToClipboard => '(‏FEN در کلیپ‌بورد کپی شد)';

  @override
  String recognitionFailed(String error) {
    return 'تشخیص ناموفق بود: $error';
  }

  @override
  String get myRating => 'امتیاز من';

  @override
  String get gamesPlayed => 'بازی‌های انجام شده';

  @override
  String get wins => 'بردها';

  @override
  String get losses => 'باخت‌ها';

  @override
  String get draws => 'مساوی‌ها';

  @override
  String get lastUpdated => 'آخرین به‌روزرسانی';

  @override
  String get format => 'قالب:';

  @override
  String get resetStatistics => 'بازنشانی آمار';

  @override
  String get drawRate => 'نرخ مساوی';

  @override
  String get lossRate => 'نرخ باخت';

  @override
  String get aiStatistics => 'آمار هوش مصنوعی';

  @override
  String get enableStatistics => 'فعال کردن آمار';

  @override
  String get enableStatistics_Detail =>
      'در صورت فعال بودن، نتایج بازی در آمار ثبت می‌شود. با این حال، بازی‌هایی که شامل بازپس‌گیری حرکت هستند، ثبت نخواهند شد. در صورت غیرفعال بودن، جمع‌آوری آمار متوقف می‌شود.';

  @override
  String get thisWillResetAllGameStatistics =>
      'این کار تمام آمار بازی را بازنشانی می‌کند. این عمل قابل لغو نیست.';

  @override
  String get boardInnerRingSize => 'اندازه حلقه داخلی صفحه';

  @override
  String get boardShadowEnabled => 'سایه صفحه';

  @override
  String get trapAwareness => 'تشخیص تله';

  @override
  String get trapAwarenessDescription =>
      'در طول تحلیل، حرکات تله را با دایره‌ها و پیکان‌های پررنگ برجسته کن.';

  @override
  String trapExists(String trapMoves) {
    return 'تله وجود دارد. حرکات تله: $trapMoves';
  }

  @override
  String get custodianCapture => 'دستگیری در کنار هم';

  @override
  String get custodianCaptureDescription =>
      'یکی از قطعات حریف خود را بین دو مورد از شما در یک خط مستقیم محصور کنید تا آن را ضبط کنید.';

  @override
  String get custodianCaptureEnable => 'اجازه ضبط پهلو را دهید';

  @override
  String get interventionCapture => 'ضبط مداخله';

  @override
  String get interventionCaptureDescription =>
      'به نقطه خالی بین دو قطعه حریف خود بروید تا هر دو آنها را ضبط کنید.';

  @override
  String get interventionCaptureEnable => 'اجازه مداخله را اجازه دهید';

  @override
  String get leapCapture => 'ضبط پرش';

  @override
  String get leapCaptureDescription =>
      'با پریدن از روی قطعه حریف مجاور به نقطه خالی فراتر از آن ، ضبط کنید.';

  @override
  String get leapCaptureEnable => 'اجازه دادن به پرش را اجازه دهید';

  @override
  String get captureApplicableLines => 'خطوط قابل اجرا';

  @override
  String get captureSquareEdges => 'در امتداد لبه های میدان';

  @override
  String get captureCrossLines =>
      'در امتداد خطوط متعامد که از میدان عبور می کنند';

  @override
  String get captureDiagonalLines =>
      'در امتداد خطوط مورب که از مربع عبور می کنند';

  @override
  String get captureExecutionPhases => 'مراحل اعدام';

  @override
  String get capturePiecesCondition =>
      'در دسترس بودن در مرحله متحرک بر اساس قطعات باقی مانده';

  @override
  String get capturePiecesConditionUnlimited => 'بدون محدودیت';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'در صورت داشتن سه یا کمتر قطعه موجود است';
}
