// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Estonian (`et`).
class SEt extends S {
  SEt([String locale = 'et']) : super(locale);

  @override
  String get appName => 'Veskimäng';

  @override
  String get welcome => 'Tere tulemast';

  @override
  String get yes => 'Jah';

  @override
  String get no => 'Ei';

  @override
  String get game => 'Mäng';

  @override
  String get humanVsAi => 'Inimene vs. AI';

  @override
  String get humanVsHuman => 'Inimene vs. Inimene';

  @override
  String get aiVsAi => 'AI vs. AI';

  @override
  String get humanVsCloud => 'Inimene vs. pilv';

  @override
  String get humanVsLAN => 'Inimene vs LAN';

  @override
  String get testViaLAN => 'Test LANi kaudu';

  @override
  String get move => 'Liikumine';

  @override
  String get showMoveList => 'Liikumise nimekiri';

  @override
  String get moveList => 'Liigutuste nimekiri';

  @override
  String get noGameRecord => 'Puudub kirje';

  @override
  String get ok => 'OK';

  @override
  String get confirm => 'Kinnita';

  @override
  String get cancel => 'Tühista';

  @override
  String get tipSelectWrong => 'Valige vale tükk.';

  @override
  String get tipPlace => 'Asetage oma tükid.';

  @override
  String get tipBanPlace => 'Te ei saa seda siia paigutada.';

  @override
  String get tipPlaced => 'Sa paigutasid.';

  @override
  String get tipRemove => 'Eemaldage tükk.';

  @override
  String get tipBanRemove => 'Te ei saa seda eemaldada.';

  @override
  String get tipRemoved => 'Sa eemaldasid.';

  @override
  String get tipMove => 'Liiguta tükk.';

  @override
  String get tipCannotPlace => 'Sa ei saa oma tükki siia paigutada.';

  @override
  String get tipCannotMove => 'Sa ei saa oma mänguasja siia liigutada.';

  @override
  String get tipMill => 'Veski! Võta oma vastasmängija tükk.';

  @override
  String get tipContinueMill => 'Jätka oma vastase tüki võtmist.';

  @override
  String get tipSelectOpponentsPiece => 'Vali üks oma vastase mängujoontest.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Te ei saa eemaldada mängujooni veskist.';

  @override
  String get tipCanMoveOnePoint => 'Üks tükk võib liikuda 1 punktiga.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Sa ei saa liigutada oma vastase tükki.';

  @override
  String get tipSelectPieceToMove => 'Valige oma tükk, mida liigutada.';

  @override
  String get tipHaveThreePiecesLeft => 'Sul on kolm tükki alles.';

  @override
  String get tipCanMoveToAnyPoint =>
      'Sa võid liikuda ükskõik millisesse punkti.';

  @override
  String tipToMove(Object player) {
    return '$player liikumiseks.';
  }

  @override
  String get whiteWin => 'Mängija 1 võidab!';

  @override
  String get blackWin => 'Mängija 2 võidab!';

  @override
  String get won => 'Võitis';

  @override
  String get lost => 'Kaotatud';

  @override
  String get thinking => 'Mõtlemine…';

  @override
  String get newGame => 'Uus mäng';

  @override
  String get importGame => 'Impordi mäng';

  @override
  String get exportGame => 'Ekspordi mäng';

  @override
  String get gameImported => 'Mäng imporditud.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Ei saa importida $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'Liigutused ja reeglid ei vasta.';

  @override
  String get pleaseWait => 'Palun oodake.';

  @override
  String get restartGame => 'Käivitate praeguse mängu uuesti?';

  @override
  String get restart => 'Restart';

  @override
  String get gameStarted => 'Mäng algas, palun asetage.';

  @override
  String get analyzing => 'Analüüsides…';

  @override
  String error(Object message) {
    return 'Viga: $message';
  }

  @override
  String get winRate => 'Võitmise määr';

  @override
  String get score => 'Tulemus:';

  @override
  String get white => 'Mängija 1';

  @override
  String get black => 'Mängija 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player tükkide arv on väiksem kui kolm.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player loobuda.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player-l pole enam teed.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Tahvel on täis ja $player-l pole enam teed.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Aeg on möödas, $player kadunud.';
  }

  @override
  String get drawReasonRule50 =>
      'Liikumisfaasis ei ole viimase kindla arvu käikude jooksul ühtegi tükki eemaldatud.';

  @override
  String get drawReasonBoardIsFull => 'See on viik, sest laud on täis.';

  @override
  String get drawReasonThreefoldRepetition =>
      'See on viik, sest kolmekordne kordus.';

  @override
  String get gameOverUnknownReason => 'Mängu lõpp! Teadmata põhjusel.';

  @override
  String get gameOver => 'Mängu lõpp';

  @override
  String get youWin => 'Te võitsite! Palju õnne!';

  @override
  String challengeHarderLevel(int level) {
    return 'Kas väljakutse raskem tase? Uueks tasemeks on $level tase!';
  }

  @override
  String get youLose => 'Sa kaotad!';

  @override
  String get analyze => 'Analüüsi';

  @override
  String get about => 'Umbes';

  @override
  String version(Object versionNumber) {
    return 'Versioon: $versionNumber';
  }

  @override
  String get thanks => 'Tänu';

  @override
  String get settings => 'Seaded';

  @override
  String get options => 'Valikud';

  @override
  String get generalSettings => 'üldised seaded';

  @override
  String get skillLevel => 'Raskuse tase';

  @override
  String get moveTime => 'AI mõtlemisaeg';

  @override
  String get difficulty => 'Raskusaste';

  @override
  String get playSounds => 'Heliefektid';

  @override
  String get playSoundsInTheGame => 'Mängu helide esitamine';

  @override
  String get keepMuteWhenTakingBack => 'Tagasivõtmise ajal mute\'i hoidmine';

  @override
  String get tone => 'Toon';

  @override
  String get whoMovesFirst => 'Esimene käik';

  @override
  String get human => 'Inimene';

  @override
  String get ai => 'AI';

  @override
  String get alternate => 'Alternatiiv';

  @override
  String get isAutoRestart =>
      'Automaatne mängu taaskäivitamine, kui mäng on lõppenud';

  @override
  String get isAutoChangeFirstMove => 'Automaatne esimese käigu muutmine';

  @override
  String get shufflingEnabled => 'Juhuslik liikumine';

  @override
  String get misc => 'Mitmesugused';

  @override
  String get rules => 'Reeglid';

  @override
  String get piecesCount => 'Iga mängija mängus olevate mängujoonte arv';

  @override
  String get piecesCount_Detail => 'Mitu tükki on igal mängijal?';

  @override
  String get flyPieceCount => 'Lendava tüki arv';

  @override
  String get flyPieceCount_Detail =>
      'Kui lendamine on lubatud, siis kui mängija arv on vähenenud teatavale arvule, võivad tema mängujooned vabalt liikuda mis tahes vabasse punkti, selle asemel, et olla piiratud naaberpunktidega, nagu ülejäänud mängus.';

  @override
  String get piecesAtLeastCount => 'Vähemalt tükid';

  @override
  String get hasDiagonalLines => 'Diagonaaljooned';

  @override
  String get hasDiagonalLines_Detail => 'Lisage lauale neli diagonaaljoont.';

  @override
  String get isDefenderMoveFirst => 'Teine mängija liigub esimesena';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Mängija, kes liigub paigutusfaasis teisena, liigub liikumisfaasis esimesena.';

  @override
  String get mayRemoveMultiple => 'Mitmekordne eemaldamine';

  @override
  String get mayRemoveMultiple_Detail =>
      'Kui mängija sulgeb korraga rohkem kui ühe veski, eemaldab ta nii mitu veskit, kui mitu veskit ta sulges.';

  @override
  String get mayRemoveFromMillsAlways => 'Veskite hävitamine';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Vaikimisi peavad mängijad enne moodustatud veski eemaldamist esmalt eemaldama kõik teised tükid. Selle piirangu väljalülitamiseks lülitage see valik sisse.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Teine mängija kaotab, kui laud on täis';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Kui laud on paigutusfaasi lõpus täis, kaotab mängu see pool, kes paigutab esimesena. Vastasel juhul on mäng võrdne.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Kaotab, kui seaduslikke käike ei ole';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Mängija kaotab, kui vastane blokeerib neid nii, et neid ei saa liigutada. Vahetage poole, kui see valik on keelatud.';

  @override
  String get mayFly => 'Lendamine';

  @override
  String get mayFly_Detail =>
      'Kui mängijal on alles ainult kolm või neli (seadistatavat) mänguasja, võib ta liigutada mänguasja suvalisse vabasse punkti.';

  @override
  String get nMoveRule => 'N-liikumise reegel';

  @override
  String get nMoveRule_Detail =>
      'Mäng on loositud, kui kumbki mängija ei ole teatud arvu käikude jooksul eemaldanud ühtegi tükki.';

  @override
  String get rollback => 'Tagasipöördumine';

  @override
  String get pleaseSelect => 'Palun valige';

  @override
  String get copy => 'Kopeeri';

  @override
  String get moveHistoryCopied =>
      'Liigutuste ajalugu kopeeritakse lõikelauale.';

  @override
  String get help => 'Abi';

  @override
  String get feedback => 'Tagasiside';

  @override
  String get exit => 'Väljumine';

  @override
  String get ruleSettings => 'Reeglite seaded';

  @override
  String get color => 'Värv';

  @override
  String get boardColor => 'Tahvli värvus';

  @override
  String get pieceColor => 'Tüki värvus';

  @override
  String get backgroundColor => 'Taustavärv';

  @override
  String get lineColor => 'Laua joone värvus';

  @override
  String get whitePieceColor => 'Mängija 1 tüki värv';

  @override
  String get blackPieceColor => 'Mängija 2 tüki värvus';

  @override
  String get messageColor => 'Sõnumi värv';

  @override
  String get isPieceCountInHandShown => 'Näita käes olevate tükikeste arvu';

  @override
  String get isNotationsShown => 'Näita märkmeid laual';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Näita ajaloo navigeerimise tööriistariba';

  @override
  String get display => 'Näita';

  @override
  String get boardBorderLineWidth => 'Laua piiride laius';

  @override
  String get boardInnerLineWidth => 'Laua sisemise joone laius';

  @override
  String get pieceWidth => 'Tüki laius';

  @override
  String get fontSize => 'Kirjasõna suurus';

  @override
  String get standardNotation => 'WMD märkimine';

  @override
  String get restore => 'Taastada';

  @override
  String get restoreDefaultSettings => 'Taastada vaikimisi seaded';

  @override
  String pick(Object element) {
    return 'Valige $element';
  }

  @override
  String get info => 'Info';

  @override
  String get hint => 'Vihje';

  @override
  String get player => 'mängija';

  @override
  String get player1 => 'Mängija 1';

  @override
  String get player2 => 'Mängija 2';

  @override
  String get howToPlay => 'Kuidas mängida';

  @override
  String get toPlacePiece =>
      'Puudutage ükskõik millist olemasolevat punkti, et paigutada tükk.';

  @override
  String get toSelectPiece => 'Puudutage kujukest, et seda liigutada.';

  @override
  String get toMovePiece =>
      'Puudutage tükiga seotud punkti, et seda liigutada.';

  @override
  String get toRemovePiece =>
      'Puudutage vastase ühte tükki, et seda eemaldada.';

  @override
  String get needToCreateMillFirst =>
      'Sa pead esmalt looma veski, enne kui saad tüki eemaldada.';

  @override
  String get needToPlayWithOwnPieces => 'Sa pead mängima oma tükkidega.';

  @override
  String get statistics => 'Statistika';

  @override
  String get totalGames => 'Mängud kokku';

  @override
  String get results => 'Tulemused';

  @override
  String get left => 'vasakule';

  @override
  String get privacyPolicy => 'Privaatsuspoliitika';

  @override
  String get privacyPolicy_Detail_1 =>
      'Palun lugege hoolikalt ja veenduge, et olete sellest täielikult aru saanud ja sellega nõus ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Kui te ei nõustu selle poliitikaga, ärge kasutage seda rakendust. Rakenduse kasutamine tähendab, et nõustute nende tingimustega.';

  @override
  String get and => ' ja ';

  @override
  String get accept => 'Nõustun';

  @override
  String get takeBack => 'Võtke tagasi';

  @override
  String get takingBack => 'Tagasi võtmine…';

  @override
  String get waiting => 'Ootamine…';

  @override
  String get stepForward => 'Samm edasi';

  @override
  String get takeBackAll => 'Võtke kõik tagasi';

  @override
  String get stepForwardAll => 'Samm edasi kõik';

  @override
  String get moveNow => 'Liigu nüüd';

  @override
  String get done => 'Valmis.';

  @override
  String get crackMill => 'Crack-veski';

  @override
  String get crackMill_Detail =>
      'Kui mängijal on ainult tükid veskites, ei lukustu veskites olevad tükid eemaldamiseks.';

  @override
  String get animationDuration => 'Animatsiooni kestus';

  @override
  String get none => 'Puudub';

  @override
  String get theme => 'Teema';

  @override
  String get helpContent =>
      'Mängu eesmärk on jätta vastasele vähem kui kolm tükki või mitte ühtegi seaduslikku käiku.\n\nMängus tehakse automaatselt viik, kui positsioon tekib kolmandat korda või ei eemaldata viimase 100 (konfigureeritava) käigu jooksul.\n\nMäng kulgeb kolmes etapis:\n\n1. Mängijate paigutamine vabadele punktidele\n2. Mänguosade liigutamine naaberpunktidesse.\n3. (valikuline etapp) Mängijate arvu vähendamisel kolmele mängujoonele mängujoonte liigutamine mis tahes vabale punktile.\n\npaigutamine.\n\nMäng algab tühja lauaga, mis koosneb kahekümne nelja punktiga ruudustikust. Mängijad paigutavad kordamööda oma mänguasju vabadele punktidele, kuni iga mängija on paigutanud kõik mänguasjad lauale. Kui mängija suudab panna kolm oma tükki otse, on tal \"veski\" ja ta võib ühe oma vastasmängija tükki laualt eemaldada.\n\nMõnede reeglite kohaselt peavad mängijad enne moodustatud veski eemaldamist esmalt eemaldama kõik teised tükid.\n\nMõne reegli puhul ei saa paigutusfaasis eemaldatud tükke uuesti punktidesse paigutada.\n\nKui kasutada kõik tükid, liiguvad mängijad kordamööda.\n\nLiikumine\n\nLiigutamiseks liigutab mängija ühe oma mänguasja piki lauajooni vabasse naaberpunkti. Kui ta ei saa seda teha, on ta mängu kaotanud. Nagu ka asetamisfaasis, on mängijal, kes paigutab kolm oma mänguasja lauajoonele, veski ja ta võib eemaldada ühe oma vastasmängija mänguasja. Iga mängija, kes vähendab oma mängujoonte arvu kahele tükile, ei saa moodustada uusi veskeid ja kaotab seega mängu. Mängija võib kaotada ka siis, kui rohkem kui kolm tükki, kui vastane blokeerib nende liikumise.\n\nLendavad\n\nMõne reegli variandi puhul võivad mängija, kui tal on alles jäänud ainult kolm tükki, tema tükid lennata, hüpata või hüpata mis tahes vabadesse punktidesse, mitte ainult kõrvuti asuvatesse punktidesse.\n';

  @override
  String get versionInfo => 'Versiooni info';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'Litsents';

  @override
  String get sourceCode => 'Lähtekood';

  @override
  String get appVersion => 'Rakenduse versioon';

  @override
  String get general => 'Üldine';

  @override
  String get advanced => 'Täiustatud';

  @override
  String get placing => 'Paigutamine';

  @override
  String get moving => 'Liikumine';

  @override
  String get removing => 'Eemaldamine';

  @override
  String get gameOverCondition => 'Mängu lõpptingimus';

  @override
  String get aisPlayStyle => 'AI mängustiil';

  @override
  String get passive => 'Passiivne';

  @override
  String get timeout => 'Aeg maha';

  @override
  String get appearance => 'Välimus';

  @override
  String get drawOnHumanExperience => 'Toetudes inimkogemusele';

  @override
  String get considerMobility => 'Arvestage osade liikuvust';

  @override
  String get pieceCount => 'Tükkide arv:';

  @override
  String inHand(Object player, int count) {
    return '$player käes: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player pardal: $count';
  }

  @override
  String get boardTop => 'Laua nihkumine ülevalt alla';

  @override
  String get notAIsTurn => 'See ei ole AI kord.';

  @override
  String get aiIsNotThinking => 'AI ei mõtle.';

  @override
  String get atEnd => 'Olete käikude nimekirja lõpus.';

  @override
  String get tapBackAgainToLeave => 'Koputage uuesti tagasi, et lahkuda.';

  @override
  String get more => 'Rohkem';

  @override
  String get experimental => 'Tegemist on eksperimentaalse funktsiooniga.';

  @override
  String get experiments => 'Eksperimendid';

  @override
  String get ossLicenses => 'Avatud lähtekoodiga litsentsid';

  @override
  String get language => 'Keel';

  @override
  String get defaultLanguage => 'Vaikimisi keel';

  @override
  String get mayMoveInPlacingPhase => 'Tükid võivad liikuda paigutamise faasis';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Puuduvad eraldi paigutus- ja liikumisfaasid, st mängijad võivad igal käigul otsustada, kas nad soovivad paigutada mängulauale ühe mängukivi või liigutada ühte oma mängukivi (niikaua kui neil on allesjäänud mängukivid, mida paigutada).';

  @override
  String get drawerColor => 'Menüü värv';

  @override
  String get drawerTextColor => 'Menüü teksti värv';

  @override
  String get drawerHighlightItemColor => 'Izvēlnes izcelšanas vienuma krāsa';

  @override
  String get mainToolbarBackgroundColor => 'Galvenās rīkjoslas fona krāsa';

  @override
  String get mainToolbarIconColor => 'Galvenās rīkjoslas ikonas krāsa';

  @override
  String get navigationToolbarBackgroundColor =>
      'Navigācijas rīkjoslas fona krāsa';

  @override
  String get navigationToolbarIconColor => 'Navigācijas rīkjoslas ikonas krāsa';

  @override
  String get autoHideToolbar => 'Automātiski paslēpt rīkjoslu';

  @override
  String get toolbarLocationOnScreen => 'Rīkjoslas atrašanās vieta ekrānā';

  @override
  String get top => 'Tops';

  @override
  String get bottom => 'Apakšā';

  @override
  String get center => 'Centrs';

  @override
  String get solidColor => 'Vienkrāsaina';

  @override
  String get picture => 'Bilde';

  @override
  String get chooseYourPicture => 'Izvēlieties savu attēlu';

  @override
  String get light => 'Gaisma';

  @override
  String get dark => 'Tumšs';

  @override
  String get themes => 'Tēmas';

  @override
  String get currentTheme => 'Pašreizējā tēma';

  @override
  String get saveTheme => 'Saglabāt motīvu';

  @override
  String get showAnalysisGraph => 'Rādīt analīzes grafiku';

  @override
  String get analysis => 'Analīze';

  @override
  String get saveGame => 'Saglabā spēli';

  @override
  String get loadGame => 'Ielādēt spēli';

  @override
  String get setupPosition => 'Iestatīšanas pozīcija';

  @override
  String get showLegalMoves => 'Rādīt likumīgus gājienus';

  @override
  String get showLastMove => 'Rādīt pēdējo kustību';

  @override
  String get showArrows => 'Rādīt bultiņas';

  @override
  String get pieces => 'Gabali';

  @override
  String get showAnalysis => 'Rādīt analīzi';

  @override
  String get threads => 'Vītnes';

  @override
  String get getInvolved => 'Iesaistīties';

  @override
  String get helpImproveTranslate => 'Palīdziet uzlabot tulkošanu';

  @override
  String get tutorial => 'Apmācība';

  @override
  String get classicMill => 'Κλασικό μύλο';

  @override
  String get mixedMill => 'Μικτός Μύλος';

  @override
  String get ceylonMill => 'Μύλος Κεϋλάνης';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Dzirnavas var būt salauztas un atkārtoti pārtaisītas';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Ja spēlētājs pārtrauc dzirnavas, lai nekavējoties izveidotu jaunu dzirnavu, šāds spēlētājs var nākamajā gabalā pārvietot šo gabalu atpakaļ uz sākotnējo krustojumu, ja tas izveido jaunu dzirnavu.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Spēle tiek izlozēta, ja spēlētājam ir trīs figūras un pēc desmit kustībām neviens spēlētājs nenoņem pretinieka figūras';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Kad spēlētājs ir nonācis līdz trim figūrām un neviens spēlētājs nevar noņemt pretinieka gabalu desmit gājienu laikā, spēle ir neizšķirta.';

  @override
  String get close => 'Sulge';

  @override
  String get whitePiece => 'Valge tükk';

  @override
  String get blackPiece => 'Must tükk';

  @override
  String get emptyPoint => 'Tühi punkt';

  @override
  String get noPoint => 'Pole mõtet';

  @override
  String get placingPhase => 'Asetamise faas';

  @override
  String get movingPhase => 'Liikuv faas';

  @override
  String get flyingPhase => 'Lendav faas';

  @override
  String sideToMove(Object player) {
    return 'Liigutatav külg: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Viimane käik: $move';
  }

  @override
  String get selected => 'Valitud';

  @override
  String get accessibility => 'Juurdepääsetavus';

  @override
  String get screenReaderSupport => 'Ekraanilugeja tugi';

  @override
  String get isDraw => 'See on viik!';

  @override
  String get draw => 'Joonista';

  @override
  String get pieceHighlightColor => 'Tükk esiletõstetud värv';

  @override
  String get algorithm => 'Algoritm';

  @override
  String get endgameNMoveRule => 'Endgame N-Move reegel';

  @override
  String get endgameNMoveRule_Detail =>
      'Kui kummalgi mängijal on ainult kolm tükki ja kumbki mängija ei eemalda tükki kindla käigu jooksul, loositakse mäng välja.';

  @override
  String get drawReasonEndgameRule50 =>
      'Mõlemal mängijal on ainult kolm tükki ja kumbki mängija ei eemalda tükki kindla käigu jooksul.';

  @override
  String get threefoldRepetitionRule => 'Kolmekordne kordamise reegel';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Mäng loositakse, kui positsioon tekib kolmandat korda.';

  @override
  String get continueToMakeMove => 'Veski! Jätkake käigu tegemist.';

  @override
  String get pointStyle => 'Punkti stiil';

  @override
  String get pointWidth => 'Punkti laius';

  @override
  String get solid => 'Tahke';

  @override
  String get hollow => 'Õõnes';

  @override
  String get languageName => 'Eesti';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Liigutused',
      one: '$count Teisalda',
      zero: 'Move',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Laadimine ebaõnnestus.';

  @override
  String get filename => 'Faili nimi';

  @override
  String get browse => 'Sirvi…';

  @override
  String get gameFiles => 'Mängu failid';

  @override
  String get gameSavedTo => 'Mäng salvestatakse asukohta';

  @override
  String get empty => 'Tühi';

  @override
  String get noMove => 'Ei mingit liigutust.';

  @override
  String get restoredPosition => 'Algasend taastatud.';

  @override
  String get clean => 'Puhas';

  @override
  String get cleanedUp => 'Koristatud.';

  @override
  String get remove => 'Eemalda';

  @override
  String get noPiecesCanBeRemoved => 'Ühtegi tükki ei saa eemaldada.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count tükki',
      one: '$count piece',
      zero: 'Piece',
    );
    return '$_temp0 tuleb eemaldada.';
  }

  @override
  String placedCount(int count) {
    return 'Paigut. ($count)';
  }

  @override
  String get placedPieceCount => 'Paigutatud tükkide arv paigutusfaasis.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'Praegune mängija on asetanud $count nuppe.';
  }

  @override
  String get notPlacingPhase => 'Ei pane faasi, ei saa seda muuta.';

  @override
  String get paste => 'Kleebi';

  @override
  String get pasteDone => 'Pasta on valmis.';

  @override
  String get cannotPaste => 'Ei saa kleepida.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Näita asetamata ja eemaldatud tükke';

  @override
  String get fullScreen => 'Täisekraan';

  @override
  String get reopenToTakeEffect =>
      'Väljuge ja avage rakendus uuesti, et seaded jõustuksid.';

  @override
  String get forest => 'Mets';

  @override
  String get desktopImage => 'Töölaua pilt';

  @override
  String get invalidPosition => 'Kehtetu positsioon.';

  @override
  String get shareGIF => 'Jagage GIF-i';

  @override
  String get pixelRatio => 'Pikslite suhe';

  @override
  String get duration => 'Kestus';

  @override
  String get gameScreenRecorder => 'Mängu ekraani salvestaja';

  @override
  String get previous => 'Eelmine';

  @override
  String get next => 'Edasi';

  @override
  String get skip => 'Vahele jätma';

  @override
  String get gotIt => 'Sain aru';

  @override
  String get youCanModifyRules =>
      'Mängu reegleid saate muuta reeglite seadetes.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Väärtuse muutmiseks valijas saate kasutada hiire ratast.';

  @override
  String get noTimeLimitForThinking =>
      'AI Kui mõtlemisaeg on seatud väärtusele 0, siis mõtlemisel pole ajalimiiti.';

  @override
  String get whatIsMtdf =>
      'MTD(f) on alfa-beeta otsingualgoritmi muudetud vorm, mille eesmärk on parandada tõhusust, kasutades vahepealseid otsingutulemusi ja kasutades otsinguruumi kitsendamiseks head esialgset oletust.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Pange tähele, et AI mõtlemisaja reguleerimine ei pruugi olla täiesti täpne. Tegelik mõtlemisaeg võib olla lühem, kui raskusaste on seatud madalamale väärtusele, ja võib olla pikem, kui AI on keskmise mõtteviisiga, kui aeg otsa saab.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Kui seate raskusastme kõrgeks, kuid ei suurenda tehisintellekti mõtlemisaega, võib tegelik raskusaste piirduda mõtlemisaja piirangu tõttu madalama väärtusega. Tegelik väärtus võib olenevalt masina jõudlusest erineda.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) on otsingualgoritm, mis võimaldab leida antud positsioonil parima käigu. See on alfa-beeta-algoritmi täiustus ja kasutab null- või nullaknaotsingut, et kinnitada, kas käik on halvem või mitte halvem kui peamise variatsiooni juba ohutu skoor. PVS keskendub kõige paljutõotavamatele käikudele ja väldib ebavajalikke otsinguid suboptimaalsetest harudest, mis aitab parandada otsingu efektiivsust.';

  @override
  String get whatIsAlphaBeta =>
      'Alfa-beeta algoritm on otsingualgoritm parima käigu leidmiseks. See kasutab otsingupuu kärpimiseks ja tõhususe suurendamiseks minimaxi põhimõtet ja kahte väärtust, alfa ja beeta. Alfa esindab minimaalset punktisummat, milleni arvuti on kindel, et ta saab, samas kui beeta esindab maksimaalset punktisummat, mille vastane võib saada. Algoritm aitab arvutil teha mängus nutikaid ja tõhusaid otsuseid.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Inimkogemuse järgi, kui üritad võita, siis kaotad. Selle asemel seadke oma eesmärgiks viik ja vältige mängu kaotamist. Jälgige oma vastast ja meelitage ta õrnalt asendisse, kus nad võivad vigu teha. Kui nad näitavad nõrkust, kasutage võimalust ja suruge õrnalt võidu poole. Sel viisil võite mängu võita.';

  @override
  String get firstMoveDetail =>
      'Selles mängus on teisel mängijal lihtsam võita võrreldes esimese mängijaga.';

  @override
  String get passiveDetail =>
      'Suvandi Passiivne lubamine paneb tehisintellekti lõõgastuma, kui tal on positsioonil eelis, selle asemel, et püüda agressiivselt võita võimalikult kiiresti.';

  @override
  String get moveRandomlyDetail =>
      'Selle valiku lubamine suurendab mängu juhuslikkust ja lõbusust, samas kui selle keelamine võib aidata uurida viise, kuidas AI-d ületada.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Kui tehisintellekt arvestab oma nuppude liikuvust, ei ole selle eesmärk mitte ainult vastase nuppude võimalikult kiire tabamine, vaid kaalub ka vastase liikumiste blokeerimist ja takistamist neil sama tegemast.';

  @override
  String get whenBoardIsFull => 'Kui laud on täis';

  @override
  String get whenBoardIsFull_Detail =>
      'Paigutamisfaasi lõpus, enne liikumisfaasi algust, järgneb tegevus, kui laud on tükke täis.';

  @override
  String get sideToMoveRemovePiece =>
      'Mängija, kes liigub liikumise faasis esimesena, eemaldab ühe vastase nupu.';

  @override
  String get agreeToDraw => 'Mõlemad pooled nõustuvad viigiga.';

  @override
  String get takeOpponentsPiece => 'Võtke üks vastase nuppe.';

  @override
  String get firstPlayerLose => 'Esimene mängija kaotab mängu.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Esimene ja teine mängija eemaldavad ühe vastase nupu.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Teine ja esimene mängija eemaldavad ühe vastase nupu.';

  @override
  String get enteredFlyingPhase =>
      'Nüüd lendamisfaasi sisenedes võivad vastase nupud hüpata suvalisse tühja punkti laual. Lennureegli saate välja lülitada jaotises \"Reegli seaded\".';

  @override
  String get whenStalemate => 'Kui ummikseisus';

  @override
  String get whenStalemate_Detail =>
      'Mis toiming järgneb, kui ühtegi tükki ei saa liigutada?';

  @override
  String get endWithStalemateLoss => 'Lõpeta ummikkaotusega.';

  @override
  String get changeSideToMove => 'Muutke liikumiseks külge.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Eemaldage üks vastase nuppudest ja tehke järgmine käik.';

  @override
  String get endWithStalemateDraw => 'Lõpeta ummikseisuga.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Eemaldage üks vastase nupp ja muutke liikumiseks külge.';

  @override
  String get aiResponseDelayTime => 'AI reageerimise viivitusaeg';

  @override
  String get aiIsDelaying =>
      'AI on praegu viivitatud reageerimise faasis. Enne jätkamist oodake veidi.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Te ei saa eemaldada mittekülgnevat tükki.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'Kui ummikseisus on, saab sinu omadega külgnevad vastase nupud eemaldada, olenemata veski moodustamisest.';

  @override
  String get whatIsMcts =>
      'MCTS on algajasõbralik algoritm, mis teeb otsuseid simulatsioonide abil erinevaid käike uurides ja hinnates.';

  @override
  String get goldenJade => 'Kuldne Jade';

  @override
  String get forestWood => 'Metsa puit';

  @override
  String get darkMystery => 'Tume müsteerium';

  @override
  String get midnightBlue => 'Kesköösinine';

  @override
  String get greenForest => 'Roheline mets';

  @override
  String get greenMeadow => 'Roheline heinamaa';

  @override
  String get stonyPath => 'Kivi tee';

  @override
  String get pastelPink => 'Pastelne roosa';

  @override
  String get turquoiseSea => 'Türkiissinine meri';

  @override
  String get violetDream => 'Violetne unistus';

  @override
  String get mintChocolate => 'Mündi šokolaad';

  @override
  String get skyBlue => 'Taevasinine';

  @override
  String get playfulGarden => 'Mänguline aed';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Retrograadse analüüsi algoritm kasutab mitme väärtusega retrograadset analüüsi, et luua erinevatest alguspositsioonidest lõppmängu andmebaas, seejärel rakendab see andmebaas mängu optimeerimiseks. See lähenemisviis kuulub ülitugevate lahenduste kategooriasse.';

  @override
  String get viewAlgorithmGuide =>
      'Kas soovite vaadata selle algoritmi kasutusjuhendit?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Näita positsioonieelise indikaatorit';

  @override
  String get usePerfectDatabase => 'Kasutage täiuslikku andmebaasi';

  @override
  String get perfectDatabaseDescription =>
      'Lubage see suvand, et kasutada tipptasemel algoritmide abil loodud veatut mängude andmebaasi. See funktsioon integreerib nii mängu ava- kui ka lõpustrateegiad, et soovitada optimaalseid käike. See on eelistatud valik mängijatele, kes otsivad mängus kõrgeimat täpsust. Põhjalike arvutustehnikate abil loodud andmebaas on loodud pakkuma peaaegu täiuslikke mängulahendusi.\n\nMärkus. Kui AI-l ei õnnestu andmebaasile juurde pääseda, kasutab see mänguotsuste tegemiseks tavalisi algoritme. Kui andmebaas on saadaval, muutub raskusaste peaaegu ületamatuks ja AI mõtlemisaeg väheneb drastiliselt. Paljud AI\'s play style\'i valikute sätted tühistatakse, kuna andmebaasi tulemused on kõige olulisemad.\n\nJuhiste saamiseks selle veatu andmebaasi maksimaalse kasutamise kohta klõpsake siin.';

  @override
  String get backgroundImage => 'Taustapilt';

  @override
  String get whatIsRandom =>
      'Kui suvand \"Kasuta täiuslikku andmebaasi\" pole lubatud, paneb seade \"Juhuslik\" AI-l tükke juhuslikult liigutama, kasutamata käiguvalikuks mingeid algoritme. Selle tulemuseks on tavaliselt oluliselt nõrgem mäng. Ja vastupidi, kui „Kasuta täiuslikku andmebaasi” on lubatud, tugineb AI otsuste tegemisel eranditult „Täiuslikule andmebaasile”, selle asemel, et seda traditsiooniliste AI-algoritmidega segada. Selles režiimis põhinevad AI käigud täielikult andmebaasi sisul, vältides reaalajas arvutusi või otsingualgoritme.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Eemalda vastase käest nupp (nupud); siis on vastase kord paigutada.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Paigutusfaasis veskite moodustamisel';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Eemalda vastase nupp (nupud) laualt.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Eemalda vastase nupp (nupud) laualt; siis on vastase kord paigutada.';

  @override
  String get opponentRemovesOwnPiece =>
      'Vastane eemaldab enda nupu (nupud) laualt.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Selle asemel, et sina midagi ette võtaksid, valib vastane oma nupu (nupud) tahvlilt ja eemaldab selle, tehes sisuliselt endale kahjuliku käigu.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Eemalda vastase käest nupp (nupud); siis on sinu kord käia.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Eemalda nupp (nupud) vastase käest. Kui vastavalt Multi-remove seadele tuleb eemaldada mitu nuppu ja vastasel pole enam käes nuppe, jätka vastase nuppude eemaldamist laualt. Siis on sinu kord käia. Kui jätkad veskite moodustamist, võid jätkata vastase nuppude eemaldamist.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Eemalda nupp (nupud) vastase käest. Kui vastavalt Multi-remove seadele tuleb eemaldada mitu nuppu ja vastasel pole enam käes nuppe, jätka vastase nuppude eemaldamist laualt. Siis on vastase kord käia.';

  @override
  String get markAndDelayRemovingPieces =>
      'Märgi ja viivita nuppude eemaldamisega.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Paigutusfaasi ajal märgitakse eemaldatavad nupud ära ja mõlemad mängijad ei saa nendele punktidele uusi nuppe paigutada. Liikumisfaasi sisenedes eemaldatakse need märgitud nupud täielikult ja seejärel saavad mängijad oma nuppe nendele nüüd tühjadele punktidele liigutada.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Tegevused, mida saab võtta veskite moodustamisel paigutamise faasis.';

  @override
  String get marked => 'Märgitud';

  @override
  String get menu => 'Menüü';

  @override
  String get monochrome => 'Monokroomne';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Ekraanilugeja tuge saate sisse lülitada Üldseadete all Otsipääsetavuse seadetes.';

  @override
  String get showNumbersOnPieces => 'Näita numbreid nuppudel';

  @override
  String get saveImage => 'Salvesta pilt';

  @override
  String get isAnalysisToolbarShown => 'Kuva analüüsiriistariba';

  @override
  String get analysisToolbarBackgroundColor => 'Analüüsiriistariba taustavärv';

  @override
  String get analysisToolbarIconColor => 'Analüüsiriistariba ikooni värv';

  @override
  String get transformed => 'Transformeeritud.';

  @override
  String get cannotTransform => 'Ei saa transformeerida.';

  @override
  String get rotate => 'Pööra';

  @override
  String get horizontalFlip => 'H Pööre';

  @override
  String get verticalFlip => 'V Pööre';

  @override
  String get innerOuterFlip => 'IO Pööre';

  @override
  String get transparentCanvas => 'Läbipaistev Lõuend';

  @override
  String get restrictRepeatedMillsFormation =>
      'Piira korduvat veskite moodustamist';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Nupp, mis on liigutatud ühest veskist teise, ei saa järgmisel käigul kohe algpunkti tagasi minna, et uuesti veskit moodustada. Esiteks on vajalik teistsugune liigutus.';

  @override
  String get oneTimeUseMill => 'Ühekordne kasutus veski';

  @override
  String get oneTimeUseMill_Detail =>
      'Iga veski saab eemaldada ainult ühe vastase tüki. Saate selle uuesti kujundada, kuid seda ei saa kasutada täiendavate eemaldamiste jaoks.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Praegustel seadistatud reeglitel puudub vastav ideaalne andmebaas. Täiusliku andmebaasi kohta lisateabe saamiseks klõpsake siin.';

  @override
  String get focusOnBlockingPaths => 'Keskendu teede blokeerimisele';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Prioriteerige vastase liikumise takistamist, mitte veskite moodustamist. Selle asemel, et keskenduda veskite täitmisega tükkide eemaldamisele, püüab tehisintellekt vastast lõksu püüda, takistades neil liikumist ja tagades võidu kurnamise, mitte agressiivse mänguga. See strateegia ei blokeeri aktiivselt vastase veskeid.';

  @override
  String get pieceImage => 'Maletüki pilt';

  @override
  String get importColorSettings => 'Impordi värviseaded';

  @override
  String get exportColorSettings => 'Ekspordi värviseaded';

  @override
  String get import => 'Impordi';

  @override
  String get export => 'Ekspordi';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Palun kopeerige kõigepealt JSON-vormingu sätted lõikelauale.';

  @override
  String get copiedToClipboard => 'Kopeeritud lõikelauale.';

  @override
  String get imported => 'Imporditud.';

  @override
  String get boardImage => 'Laua pilt';

  @override
  String get autumnLeaves => 'Sügise lehed';

  @override
  String get legendaryLand => 'Legendaarne Maa';

  @override
  String get vignetteEffect => 'Vinjett-efekt';

  @override
  String get promptMakeToolbarTransparent =>
      'Kas soovite tööriistariba täiesti läbipaistvaks muuta, kui laudade taustapilt on seatud?';

  @override
  String get vibration => 'Luba vibratsioon mängus';

  @override
  String get soundTheme => 'Heliteema';

  @override
  String get ball => 'Pall';

  @override
  String get liquid => 'Vedelik';

  @override
  String get wood => 'Puit';

  @override
  String get placeEffectAnimation => 'Nupu paigutamise animatsiooni efekt';

  @override
  String get removeEffectAnimation => 'Nupu eemaldamise animatsiooni efekt';

  @override
  String get isToolbarAtBottom => 'Kuva tööriistariba all';

  @override
  String get boardCornerRadius => 'Laua nurga raadius';

  @override
  String get useOpeningBook => 'Kasuta avamisraamatut';

  @override
  String get currentRule => 'Praegune';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Reeglistik';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'One-Time Mill';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'Lubage AI-l kasutada avakäike, mida kasutavad tavaliselt professionaalsed inimmängijad varajases mängus. Märkus: See funktsioon on hetkel saadaval ainult teatud reeglistike jaoks.';

  @override
  String get showAdvantageGraph => 'Kuva eelise graafik';

  @override
  String get advantageGraphHint =>
      'Eelisgraafik joonistatakse ainult pärast seda, kui tehisintellekt on käigu teinud. Seda ei joonistata, kui käigu teeb inimmängija.';

  @override
  String get removalBasedOnMillCounts =>
      'Keela eemaldamine, kuni kõik nupud on paigutatud. Mängijad eemaldavad nuppe vastavalt veskite arvule.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Keela eemaldamine, kuni kõik nupud on paigutatud. Mängijad eemaldavad nuppe vastavalt veskite arvule: kui arv on võrdne, eemaldavad mõlemad sama palju; kui ühel on rohkem, eemaldab ta ühe nupu lisaks, hoides vahet ühe nupu jagu. Kui veski moodustab ainult üks mängija, eemaldab ta kaks nuppu, teine aga ühe. Kui kumbki ei moodusta veskit, eemaldavad mõlemad ühe nupu.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Vali üks oma nuppudest.';

  @override
  String get notYourTurn => 'Pole sinu käik.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Kommentaaritööriista taustavärv';

  @override
  String get annotationToolbarIconColor => 'Kommentaaritööriista ikoonivärv';

  @override
  String get isAnnotationToolbarShown => 'Kuva kommentaaritööriist';

  @override
  String get enterAnnotationMode => 'Lülitu kommentaarirežiimi';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Kas oled kindel, et soovid kõik kommentaarid kustutada?';

  @override
  String get llmPromptCopiedToClipboard => 'LLM päring kopeeritud lõikelauale.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Ühendus keelduti, server võib olla maas.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Avastamine õnnestus, ootab ühendust...';

  @override
  String get noLanConnection => 'Ühtegi LAN-ühendust pole.';

  @override
  String get takeScreenshot => 'Võta ekraanipilt';

  @override
  String get disconnectedFromOpponent => 'Ühendus vastasega katkestatud.';

  @override
  String get takeBackRequest => 'Tagasivõtmise taotlus';

  @override
  String get nothingToShow => 'Pole midagi näidata.';

  @override
  String get stopHosting => 'Peata hostimine';

  @override
  String get connectionResetByPeer =>
      'Ühendus lähtestati teise osapoole poolt.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Ühendus kadus heartbeat aja ületuse tõttu. Palun ühendu uuesti.';

  @override
  String get startHosting => 'Alusta hostimist';

  @override
  String get restartRequestRejected => 'Taaskäivitamise taotlus lükati tagasi.';

  @override
  String get notConnectedToLanOpponent => 'Ei ole ühendatud LAN-vastasega.';

  @override
  String get llmPrompt => 'LLM päring';

  @override
  String get gameRestarted => 'Mäng taaskäivitatud.';

  @override
  String get takeBackRejected => 'Tagasivõtmist lükati tagasi.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Kas oled kindel, et soovid sellest mängust loobuda?';

  @override
  String get opponentResignedYouWin => 'Vastane loobus. Sa võidad!';

  @override
  String get clearAllAnnotations => 'Kustuta kõik kommentaarid';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Ühendatud, ootab vastase käiku...';

  @override
  String get networkStatusDisconnected => 'Võrguseisund: Ühendus puudub';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Tagasivõtmise taotlus saadetud vastasele.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'Vastane võib olla mängust lahkunud.';

  @override
  String get connectedToHostSuccessfully => 'Ühendus hostiga õnnestus.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Ühendus kadus: heartbeat aegumisaeg.';

  @override
  String get noHostDiscovered => 'Hosti ei leitud.';

  @override
  String get confirmResignation => 'Kinnita loobumine';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Mängu hostimine alustatud, ootab mängijate liitumist...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Ühendus aegus, võrguühendus on ebastabiilne.';

  @override
  String get noLlmPromptAvailable => 'LLM päringut pole saadaval.';

  @override
  String get youResignedGameOver => 'Loobusid. Mäng läbi.';

  @override
  String get serverIp => 'Serveri IP';

  @override
  String get confirmClear => 'Kinnita kustutamine';

  @override
  String get opponentSTurn => 'Vastase käik.';

  @override
  String get waitingAClientConnection => 'Ootab kliendi ühendust...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Tagasivõtmise taotlus lükati tagasi või see ebaõnnestus.';

  @override
  String get addText => 'Lisa tekst';

  @override
  String get exitAnnotationMode => 'Välju kommentaarirežiimist';

  @override
  String get typeYourAnnotation => 'Kirjuta oma kommentaar';

  @override
  String get attemptingToReconnect => 'Üritab uuesti ühendada...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Taaskäivitamise taotlus saadetud. Ootab vastase vastust...';

  @override
  String get serverIsStopped => 'Server on peatatud.';

  @override
  String get restartRequest => 'Taaskäivitamise taotlus';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Tagasivõtmise taotlust ei saa esitada, kui pole sinu käik.';

  @override
  String get takeBackAccepted => 'Tagasivõtmine aktsepteeritud.';

  @override
  String get localNetworkSettings => 'Kohaliku võrgu seaded';

  @override
  String get reconnectedSuccessfully => 'Ühendus taastati edukalt!';

  @override
  String get failedToSaveImageToGallery =>
      'Pildi salvestamine galerii ebaõnnestus.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Vastane palus mängu taaskäivitamist. Kas nõustud?';

  @override
  String get yourTurn => 'Sinu käik.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Ühendust ei õnnestunud taastada, palun alusta mäng uuesti.';

  @override
  String get host => 'Host';

  @override
  String get join => 'Liitu';

  @override
  String get port => 'Port';

  @override
  String get invalidIpAddress => 'Vigane IP-aadress.';

  @override
  String get invalidPort => 'Vigane port.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Ühendamine: katse $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Ühendamine ebaõnnestus: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Hostimise alustamine ebaõnnestus: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Host leitud: $ip:$port';
  }

  @override
  String get stop => 'Peata';

  @override
  String get discover => 'Avasta';

  @override
  String get connect => 'Ühenda';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Klient ühendas: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Avastamine: $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Üritab uuesti ühendada ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Ühendatud';

  @override
  String get delete => 'Kustuta';

  @override
  String get ancientEgypt => 'Vana-Egiptus';

  @override
  String get gothicIce => 'Gooti Jää';

  @override
  String get riceField => 'Riisipõld';

  @override
  String get chinesePorcelain => 'Hiina Portselan';

  @override
  String get desertDusk => 'Kõrbe Hämarik';

  @override
  String get precisionCraft => 'Täpsus Käsitöö';

  @override
  String get folkEmbroidery => 'Rahvakirjandus';

  @override
  String get carpathianHeritage => 'Karpaatide Pärand';

  @override
  String get imperialGrandeur => 'Keiserlik Suursugusus';

  @override
  String get bohemianCrystal => 'Böömimaa Kristall';

  @override
  String get savannaSunrise => 'Savanni Päikesetõus';

  @override
  String get harmonyBalance => 'Harmoonia Tasakaal';

  @override
  String get cinnamonSpice => 'Kaneeli Vürts';

  @override
  String get anatolianMosaic => 'Anatoolia Mosaiik';

  @override
  String get carnivalSpirit => 'Karnevali Vaim';

  @override
  String get custom => 'Kohandatud';

  @override
  String get spiceMarket => 'Vürtsiturg';

  @override
  String get swipeToRevealTheDrawer => 'Pühkige, et avada sahtel';

  @override
  String get showGameInfoOnScreenshots => 'Kuva mänguteave ekraanipiltidel';

  @override
  String get humanMoveTime => 'Inimkäigu ajalimiit';

  @override
  String get noTimeLimitForHumanMoves => 'Inimkäikudel ajalimiiti pole';

  @override
  String get timeoutLoseWillBeApplied =>
      'Inimmängija puhul rakendatakse ajaületamise kaotust';

  @override
  String get identifyingBoard => 'Mängulaua tuvastamine...';

  @override
  String get youCanEnterAnyModelName =>
      'Saate sisestada mis tahes mudeli nime.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Laua asukoht rakendatud. FEN on lõikelauale kopeeritud.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Soovitus: proovige teha mängulauast selgemat pilti.';

  @override
  String get llmPromptTemplate => 'LLM-päringu mall';

  @override
  String get noValidBoardDetected => 'Kehtivat mängulauda ei tuvastatud.';

  @override
  String get selectingImageFromAlbum => 'Valin pilti albumist...';

  @override
  String get configurePromptTemplate => 'Päringu malli seadistamine';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Redigeeri päringu malli LLM-analüüsiks';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'FEN-i genereerimine tuvastatud mängulauast nurjus.';

  @override
  String get outputInCurrentLanguage => 'Väljund praeguses keeles';

  @override
  String get commonBaseUrls => 'Levinud Base URL-id';

  @override
  String get viewCommonModels => 'Vaata levinud mudeleid';

  @override
  String get recognitionParametersUpdated => 'Tuvastamisparameetrid uuendatud.';

  @override
  String get whiteSMove => 'Valge käik';

  @override
  String get resetToDefaults => 'Lähtesta vaikeväärtustele';

  @override
  String get photoShoot => 'Pildistamine';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Tuvastatud mängulaua asukohta ei õnnestunud rakendada.';

  @override
  String get llmPromptContent => 'LLM päringu sisu';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM pole seadistatud. Palun kontrollige oma sätteid.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Määra teenusepakkuja, mudel, API Key ja Base URL';

  @override
  String get llmConfiguration => 'LLM konfiguratsioon';

  @override
  String get configureLlmProvider => 'Seadista LLM-pakkuja';

  @override
  String get llmPromptTemplateHeader => 'LLM päringu malli päis';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Ühtegi nuppu pildil ei tuvastatud. Palun proovige uuesti.';

  @override
  String get recognizeBoardFromImage => 'Tuvasta mängulaud pildilt';

  @override
  String get viewTips => 'Vaata näpunäiteid';

  @override
  String get applyToBoard => 'Rakenda mängulauale';

  @override
  String get adjustBoardArea => 'Kohanda mängulaua piirkonda';

  @override
  String get viewCommonUrls => 'Vaata levinud URL-e';

  @override
  String get colorAnalysisFailed => 'Värvianalüüs nurjus!';

  @override
  String get analyzingGameBoardImage => 'Analüüsin mängulaua pilti...';

  @override
  String get selectFromAlbum => 'Vali albumist';

  @override
  String get noBoardPointDetected => 'Mängulaua punkti ei tuvastatud!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Kui jätta tühjaks, kasutatakse vaikemalli';

  @override
  String get llmConfig => 'LLM konfiguratsioon';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Kas olete kindel, et soovite päringumallid lähtestada vaikeväärtustele?';

  @override
  String get llmPromptTemplateFooter => 'LLM päringu malli jalus';

  @override
  String get loadingResponse => 'Laen vastust...';

  @override
  String get applyThisResultToBoard => 'Rakenda see tulemus mängulauale';

  @override
  String get takingPicture => 'Pildistamine...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Palun valige mängulaua pilt tuvastamiseks';

  @override
  String get identificationResults => 'Tuvastamise tulemused';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Analüüsi käike ja anna ülevaade.';

  @override
  String get getApiKey => 'Hangi API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Tervet tuvastusprotsessi ei õnnestunud lõpule viia.';

  @override
  String get boardRecognitionResult => 'Mängulaua tuvastamise tulemus';

  @override
  String get askLlm => 'Küsi LLM-ilt';

  @override
  String get boardDetectionFailed => 'Mängulaua tuvastamine nurjus!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Mängulaua punkti ei tuvastatud, nuppu ei saa tuvastada!';

  @override
  String get copyFen => 'Kopeeri FEN';

  @override
  String get commonlyUsedModels => 'Levinud mudelid';

  @override
  String get apiKeyOptional => 'API Key (valikuline)';

  @override
  String get noImageSelected => 'Ühtegi pilti valitud pole.';

  @override
  String get blackSMove => 'Musta käik';

  @override
  String get llm => 'Suur keelemudel';

  @override
  String get llmProvider => 'Pakkuja';

  @override
  String get baseUrl => 'Baas-URL';

  @override
  String get model => 'Mudel';

  @override
  String get temperature => 'Temperatuur';

  @override
  String get llmCommandReceivedProcessing => 'Käsk kätte saadud! AI töötleb...';

  @override
  String get llmDeepThinkingWait => 'Sügav mõtlemine käib, palun oota...';

  @override
  String get llmPresentingSoon => 'Peatselt esitletakse...';

  @override
  String get recognitionParameters => 'Tuvastusparameetrid';

  @override
  String get adjustParamsDesc =>
      'Kohanda parameetreid, et parandada tuvastuse täpsust';

  @override
  String get saveParameters => 'Salvesta parameetrid';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Pildi tuvastust ei saa käivitada: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Pildituvastus ebaõnnestus: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Rakendatud seisuga $whiteCount valget ja $blackCount musta nuppu';
  }

  @override
  String get fenCopiedToClipboard => '(FEN kopeeriti lõikelauale)';

  @override
  String recognitionFailed(String error) {
    return 'Tuvastus ebaõnnestus: $error';
  }

  @override
  String get myRating => 'Minu reiting';

  @override
  String get gamesPlayed => 'Mängitud mängud';

  @override
  String get wins => 'Võidud';

  @override
  String get losses => 'Kaotused';

  @override
  String get draws => 'Viigid';

  @override
  String get lastUpdated => 'Viimati uuendatud';

  @override
  String get format => 'Formaat:';

  @override
  String get resetStatistics => 'Lähtesta statistika';

  @override
  String get drawRate => 'Viikide määr';

  @override
  String get lossRate => 'Kaotuste määr';

  @override
  String get aiStatistics => 'Tehisintellekti statistika';

  @override
  String get enableStatistics => 'Luba statistika';

  @override
  String get enableStatistics_Detail =>
      'Kui see on lubatud, salvestatakse mängutulemused statistikasse. Tagasivõtmisi sisaldavaid mänge aga ei salvestata. Kui see on keelatud, peatatakse statistika kogumine.';

  @override
  String get thisWillResetAllGameStatistics =>
      'See lähtestab kogu mängustatistika. Seda toimingut ei saa tagasi võtta.';

  @override
  String get boardInnerRingSize => 'Laua sisemise rõnga suurus';

  @override
  String get boardShadowEnabled => 'Laua vari';

  @override
  String get trapAwareness => 'Lõksude tuvastamine';

  @override
  String get trapAwarenessDescription =>
      'Tõsta analüüsi ajal lõksukäigud esile paksude ringide ja nooltega.';

  @override
  String trapExists(String trapMoves) {
    return 'Lõks on olemas. Lõksukäigud: $trapMoves';
  }

  @override
  String get custodianCapture => 'Külgnev tabamine';

  @override
  String get custodianCaptureDescription =>
      'Lisage üks teie vastase tükki kahe teie vahel sirgjooneliselt, et see jäädvustada.';

  @override
  String get custodianCaptureEnable => 'Luba külgneval jäädvustamisel';

  @override
  String get interventionCapture => 'Sekkumisvõitlus';

  @override
  String get interventionCaptureDescription =>
      'Liikuge tühja punkti kahe oma vastase tüki vahel, et neid mõlemad jäädvustada.';

  @override
  String get interventionCaptureEnable => 'Luba sekkumise püüdmine';

  @override
  String get leapCapture => 'Hüppamine';

  @override
  String get leapCaptureDescription =>
      'Jäädvustage, hüpates üle külgneva vastase tüki tühja punkti kaugemale.';

  @override
  String get leapCaptureEnable => 'Luba hüppe jäädvustamine';

  @override
  String get captureApplicableLines => 'Kohaldatavad read';

  @override
  String get captureSquareEdges => 'Mööda väljaku servi';

  @override
  String get captureCrossLines => 'Mööda ruudu ületavaid ortogonaalseid jooni';

  @override
  String get captureDiagonalLines => 'Mööda ruudu ületavat diagonaaljooni';

  @override
  String get captureExecutionPhases => 'Täitmisfaasid';

  @override
  String get capturePiecesCondition =>
      'Saadavus liikuva etapi ajal, mis põhineb ülejäänud tükkidel';

  @override
  String get capturePiecesConditionUnlimited => 'Piiranguid pole';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Saadaval, kui teil on kolm või vähem tükki';
}
