// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Spanish Castilian (`es`).
class SEs extends S {
  SEs([String locale = 'es']) : super(locale);

  @override
  String get appName => 'Molino';

  @override
  String get welcome => 'Bienvenido';

  @override
  String get yes => 'Sí';

  @override
  String get no => 'No';

  @override
  String get game => 'Juego';

  @override
  String get humanVsAi => 'Humano contra IA';

  @override
  String get humanVsHuman => 'Humano contra Humano';

  @override
  String get aiVsAi => 'IA contra IA';

  @override
  String get humanVsCloud => 'Humano contra la nube';

  @override
  String get humanVsLAN => 'Humano contra LAN';

  @override
  String get testViaLAN => 'Prueba a través de LAN';

  @override
  String get move => 'Mover';

  @override
  String get showMoveList => 'Lista de movimientos';

  @override
  String get moveList => 'Lista de movimientos';

  @override
  String get noGameRecord => 'Sin registro';

  @override
  String get ok => 'Aceptar';

  @override
  String get confirm => 'Confirmar';

  @override
  String get cancel => 'Cancelar';

  @override
  String get tipSelectWrong => 'Ha seleccionado la pieza equivocada.';

  @override
  String get tipPlace => 'Coloque sus piezas.';

  @override
  String get tipBanPlace => 'No se puede colocar aquí.';

  @override
  String get tipPlaced => 'Pieza colocada.';

  @override
  String get tipRemove => 'Retire una pieza.';

  @override
  String get tipBanRemove => 'No se puede retirar.';

  @override
  String get tipRemoved => 'Pieza retirada.';

  @override
  String get tipMove => 'Mueva una pieza.';

  @override
  String get tipCannotPlace => 'No puede colocar su pieza aquí.';

  @override
  String get tipCannotMove => 'No puede mover su pieza aquí.';

  @override
  String get tipMill => '¡Molino! Tome la pieza de su oponente.';

  @override
  String get tipContinueMill => 'Continúe tomando la pieza del oponente.';

  @override
  String get tipSelectOpponentsPiece =>
      'Seleccione una de las piezas de su oponente.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'No puede retirar una pieza de un molino.';

  @override
  String get tipCanMoveOnePoint => 'Una pieza puede moverse 1 punto.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'No puede mover las piezas de su oponente.';

  @override
  String get tipSelectPieceToMove => 'Seleccione su pieza para moverla.';

  @override
  String get tipHaveThreePiecesLeft => 'Le quedan 3 piezas.';

  @override
  String get tipCanMoveToAnyPoint =>
      'Puede moverse a cualquier punto que prefiera.';

  @override
  String tipToMove(Object player) {
    return 'Le toca mover a $player.';
  }

  @override
  String get whiteWin => '¡El Jugador 1 gana!';

  @override
  String get blackWin => '¡El Jugador 2 gana!';

  @override
  String get won => 'Victoria';

  @override
  String get lost => 'Derrota';

  @override
  String get thinking => 'Pensando…';

  @override
  String get newGame => 'Nuevo juego';

  @override
  String get importGame => 'Importar juego';

  @override
  String get exportGame => 'Exportar juego';

  @override
  String get gameImported => 'Juego importado.';

  @override
  String cannotImport(Object invalidMove) {
    return 'No se puede importar $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch =>
      'Los movimientos y las reglas no coinciden.';

  @override
  String get pleaseWait => 'Por favor, espere...';

  @override
  String get restartGame => '¿Reiniciar el juego actual?';

  @override
  String get restart => 'Reiniciar';

  @override
  String get gameStarted =>
      'El juego ha comenzado, por favor coloque una pieza.';

  @override
  String get analyzing => 'Analizando…';

  @override
  String error(Object message) {
    return 'Error: $message';
  }

  @override
  String get winRate => 'Tasa de victoria';

  @override
  String get score => 'Puntuación:';

  @override
  String get white => 'Jugador 1';

  @override
  String get black => 'Jugador 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player tiene menos de tres piezas.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player se rindió.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player no puede moverse.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'El tablero está lleno y $player no puede moverse.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Se acabó el tiempo, $player ha perdido.';
  }

  @override
  String get drawReasonRule50 =>
      'En la fase de movimiento, no se ha retirado ninguna pieza en el último número específico de movimientos.';

  @override
  String get drawReasonBoardIsFull =>
      'Es un Empate porque el tablero está lleno.';

  @override
  String get drawReasonThreefoldRepetition =>
      'Es un Empate debido a la triple repetición.';

  @override
  String get gameOverUnknownReason => '¡Se acabó el juego! Razón desconocida.';

  @override
  String get gameOver => 'Se acabó el juego';

  @override
  String get youWin => 'Ha ganado. ¡Enhorabuena!';

  @override
  String challengeHarderLevel(int level) {
    return '¿Desea jugar un nivel más difícil? ¡El nuevo nivel será el nivel $level!';
  }

  @override
  String get youLose => 'Ha perdido!';

  @override
  String get analyze => 'Analizar';

  @override
  String get about => 'Acerca de';

  @override
  String version(Object versionNumber) {
    return 'Versión: $versionNumber';
  }

  @override
  String get thanks => 'Agradecimientos';

  @override
  String get settings => 'Ajustes';

  @override
  String get options => 'Opciones';

  @override
  String get generalSettings => 'Parámetros generales';

  @override
  String get skillLevel => 'Nivel de dificultad';

  @override
  String get moveTime => 'Tiempo de razonamiento de la IA';

  @override
  String get difficulty => 'Dificultad';

  @override
  String get playSounds => 'Efectos de sonido';

  @override
  String get playSoundsInTheGame => 'Reproducir sonidos en el juego';

  @override
  String get keepMuteWhenTakingBack => 'Mantener el silencio al retroceder';

  @override
  String get tone => 'Tono';

  @override
  String get whoMovesFirst => 'Primer movimiento';

  @override
  String get human => 'Humano';

  @override
  String get ai => 'IA';

  @override
  String get alternate => 'Alternar';

  @override
  String get isAutoRestart => 'Autoreiniciar del juego al terminar la partida';

  @override
  String get isAutoChangeFirstMove => 'Autocambiar el primer movimiento';

  @override
  String get shufflingEnabled => 'Mover al azar';

  @override
  String get misc => 'Varios';

  @override
  String get rules => 'Reglas';

  @override
  String get piecesCount => 'El número de piezas que tiene cada jugador';

  @override
  String get piecesCount_Detail => '¿Cuántas piezas tiene cada jugador?';

  @override
  String get flyPieceCount => 'El número de la pieza voladora';

  @override
  String get flyPieceCount_Detail =>
      'Si la función de \'volar\' está activada, cuando un jugador se reduce a un número específico de piezas, sus piezas son libres de moverse a cualquier punto desocupado, en lugar de estar restringidas a puntos adyacentes como en el resto del juego.';

  @override
  String get piecesAtLeastCount => 'Mínimo de piezas';

  @override
  String get hasDiagonalLines => 'Líneas diagonales';

  @override
  String get hasDiagonalLines_Detail =>
      'Añade cuatro líneas diagonales al tablero.';

  @override
  String get isDefenderMoveFirst => 'El segundo jugador mueve primero';

  @override
  String get isDefenderMoveFirst_Detail =>
      'El jugador que mueve en segundo lugar en la fase de colocación mueve primero en la fase de movimiento.';

  @override
  String get mayRemoveMultiple => 'Remoción múltiple';

  @override
  String get mayRemoveMultiple_Detail =>
      'Si una jugadora cierra más de un molino a la vez, podrá retirar el número de molinos que haya cerrado.';

  @override
  String get mayRemoveFromMillsAlways => 'Destruir molinos';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Por defecto, los jugadores deben remover primero cualquier otra pieza antes de retirar una pieza de un molino formado. Activa esta opción para desactivar la limitación.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'El segundo jugador pierde cuando el tablero está lleno';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Al final de la fase de colocación, cuando el tablero está lleno, el bando que coloque primero pierde la partida, de lo contrario, la partida es un empate.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Pierde cuando no hay movimientos legales';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'El jugador perderá si su oponente lo bloquea de manera que no pueda moverse. Si esta opción está desactivada, se cambia el turno en lugar de declarar una derrota.';

  @override
  String get mayFly => 'Vuelo';

  @override
  String get mayFly_Detail =>
      'Si a un jugador le quedan sólo tres o cuatro piezas (configurables), puede mover la pieza a cualquier punto libre.';

  @override
  String get nMoveRule => 'Regla de N movimientos';

  @override
  String get nMoveRule_Detail =>
      'La partida se empata si no ha habido ninguna retirada en un número determinado de movimientos por cada jugador.';

  @override
  String get rollback => 'Retroceso';

  @override
  String get pleaseSelect => 'Seleccione';

  @override
  String get copy => 'Copiar';

  @override
  String get moveHistoryCopied =>
      'El historial de movimientos se ha copiado al portapapeles.';

  @override
  String get help => 'Ayuda';

  @override
  String get feedback => 'Comentarios';

  @override
  String get exit => 'Salir';

  @override
  String get ruleSettings => 'Ajustes del reglamento';

  @override
  String get color => 'Color';

  @override
  String get boardColor => 'Color del tablero';

  @override
  String get pieceColor => 'Color de la pieza';

  @override
  String get backgroundColor => 'Color del fondo';

  @override
  String get lineColor => 'Color de la línea del tablero';

  @override
  String get whitePieceColor => 'Color de la pieza del jugador 1';

  @override
  String get blackPieceColor => 'Color de la pieza del jugador 2';

  @override
  String get messageColor => 'Color del mensaje';

  @override
  String get isPieceCountInHandShown =>
      'Mostrar el número de piezas en la mano';

  @override
  String get isNotationsShown => 'Mostrar anotaciones en el tablero';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Mostrar la barra de navegación del historial';

  @override
  String get display => 'Mostrar';

  @override
  String get boardBorderLineWidth => 'Anchura del borde del tablero';

  @override
  String get boardInnerLineWidth => 'Ancho de la línea interior del tablero';

  @override
  String get pieceWidth => 'Ancho de la pieza';

  @override
  String get fontSize => 'Tamaño de la fuente';

  @override
  String get standardNotation => 'Notación WMD';

  @override
  String get restore => 'Restaurar';

  @override
  String get restoreDefaultSettings => 'Restaurar la configuración por defecto';

  @override
  String pick(Object element) {
    return 'Elija $element';
  }

  @override
  String get info => 'Info';

  @override
  String get hint => 'Sugerencia';

  @override
  String get player => 'jugador';

  @override
  String get player1 => 'Jugador 1';

  @override
  String get player2 => 'Jugador 2';

  @override
  String get howToPlay => 'Cómo jugar';

  @override
  String get toPlacePiece =>
      'Toque en cualquier punto disponible para colocar la pieza.';

  @override
  String get toSelectPiece => 'Pulse sobre una pieza para moverla.';

  @override
  String get toMovePiece =>
      'Pulse sobre un punto conectado a una pieza para moverla.';

  @override
  String get toRemovePiece => 'Toque en la pieza del oponente para removerla.';

  @override
  String get needToCreateMillFirst =>
      'Para poder remover una pieza es necesario crear un molino.';

  @override
  String get needToPlayWithOwnPieces => 'Tiene que jugar con sus piezas.';

  @override
  String get statistics => 'Estadísticas';

  @override
  String get totalGames => 'Total de partidas';

  @override
  String get results => 'Resultados';

  @override
  String get left => 'izquierda';

  @override
  String get privacyPolicy => 'Política de privacidad';

  @override
  String get privacyPolicy_Detail_1 =>
      'Por favor, lea atentamente y asegúrese de que entiende y está de acuerdo con esto ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Si no está de acuerdo con esta Política, por favor no utilice esta App. El uso de la App implica que usted acepta estos términos.';

  @override
  String get and => ' y ';

  @override
  String get accept => 'Aceptar';

  @override
  String get takeBack => 'Retroceder';

  @override
  String get takingBack => 'Retrocediendo…';

  @override
  String get waiting => 'Espere…';

  @override
  String get stepForward => 'Adelantar';

  @override
  String get takeBackAll => 'Retroceder todo';

  @override
  String get stepForwardAll => 'Adelantar todo';

  @override
  String get moveNow => 'Mover ahora';

  @override
  String get done => 'Hecho.';

  @override
  String get crackMill => 'Molino de grietas';

  @override
  String get crackMill_Detail =>
      'Si un jugador sólo tiene piezas en molinos, las piezas en los molinos no se bloquearán para ser removidas.';

  @override
  String get animationDuration => 'Duración de la animación';

  @override
  String get none => 'Ninguna';

  @override
  String get theme => 'Tema';

  @override
  String get helpContent =>
      'El objetivo del juego es dejar al adversario con menos de tres piezas o sin movimientos legales.\n\nEl juego empata automáticamente si una posición se produce por tercera vez o no hace ninguna retirada en los últimos 100 movimientos (configurables).\n\nEl juego se desarrolla en tres fases:\n\n1. Colocación de las piezas en los puntos vacantes\n2. Mover piezas a puntos adyacentes\n3. (fase opcional) Mover las piezas a cualquier punto vacío al reducir el jugador a tres piezas\n\nColocación\n\nEl juego comienza con un tablero vacío, que consiste en una cuadrícula con veinticuatro puntos. Los jugadores se turnan para colocar las piezas en los puntos vacantes hasta que cada jugador haya colocado todas las piezas en el tablero. Si un jugador consigue colocar tres de las piezas en línea recta, tiene un \"molino\" y puede retirar del tablero una de las piezas del adversario.\n\nEn algunas reglas, los jugadores deben retirar primero cualquier otra pieza antes de retirar una pieza de un molino formado.\n\nEn algunas reglas no se pueden volver a colocar las piezas en los puntos de las piezas retiradas en la fase de colocación.\n\nUna vez utilizadas todas las piezas, los jugadores se mueven por turnos.\n\nMover\n\nPara mover, un jugador mueve una de sus piezas a lo largo de una línea del tablero hasta un punto adyacente libre. Si no puedes hacerlo, has perdido la partida. Un jugador que alinea tres de sus piezas en una línea del tablero tiene un molino y puede eliminar una de las piezas de su adversario como en la fase de colocación. Si un jugador se reduce a dos piezas, no tiene opción de formar nuevos molinos y, por tanto, pierde la partida. Un jugador también puede perder cuando tiene más de tres piezas si el adversario bloquea el movimiento.\n\nVolar\n\nEn algunas variantes de las reglas, una vez que a un jugador silo le quedan tres piezas, sus piezas pueden volar, saltar o brincar a cualquier punto libre, no solo a los adyacentes.\n';

  @override
  String get versionInfo => 'Información sobre la versión';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'Licencia';

  @override
  String get sourceCode => 'Código fuente';

  @override
  String get appVersion => 'Versión de la aplicación';

  @override
  String get general => 'General';

  @override
  String get advanced => 'Avanzado';

  @override
  String get placing => 'Colocar';

  @override
  String get moving => 'Mover';

  @override
  String get removing => 'Retirado';

  @override
  String get gameOverCondition => 'Condición de fin de juego';

  @override
  String get aisPlayStyle => 'Estilo de juego de la IA';

  @override
  String get passive => 'Pasivo';

  @override
  String get timeout => 'Tiempo de espera';

  @override
  String get appearance => 'Aspecto';

  @override
  String get drawOnHumanExperience => 'Basarse en la experiencia humana';

  @override
  String get considerMobility => 'Considerar la movilidad de las piezas';

  @override
  String get pieceCount => 'Recuento de piezas:';

  @override
  String inHand(Object player, int count) {
    return '$player: $count en mano';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player: $count en el tablero';
  }

  @override
  String get boardTop => 'Desplazamiento del tablero desde la parte superior';

  @override
  String get notAIsTurn => 'No es el turno de la IA.';

  @override
  String get aiIsNotThinking => 'La IA no está razonando.';

  @override
  String get atEnd => 'Está al final de la lista de movimientos.';

  @override
  String get tapBackAgainToLeave => 'Toque atrás de nuevo para salir.';

  @override
  String get more => 'Más';

  @override
  String get experimental => 'Esta es una función experimental.';

  @override
  String get experiments => 'Experimentos';

  @override
  String get ossLicenses => 'Licencias de código abierto';

  @override
  String get language => 'Idioma';

  @override
  String get defaultLanguage => 'Idioma predeterminado';

  @override
  String get mayMoveInPlacingPhase =>
      'Las piezas pueden moverse en la fase de colocación';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'No hay fases distintas de colocación y movimiento, es decir, los jugadores pueden decidir en cada movimiento si quieren colocar una pieza en el tablero o mover una de sus piezas (siempre que les queden piezas por colocar).';

  @override
  String get drawerColor => 'Color del menú';

  @override
  String get drawerTextColor => 'Color del texto del menú';

  @override
  String get drawerHighlightItemColor =>
      'Color del elemento resaltado del menú';

  @override
  String get mainToolbarBackgroundColor =>
      'Color de fondo de la barra de herramientas principal';

  @override
  String get mainToolbarIconColor => 'Color del icono de la barra principal';

  @override
  String get navigationToolbarBackgroundColor =>
      'Color de fondo de la barra de herramientas de navegación';

  @override
  String get navigationToolbarIconColor =>
      'Color del icono de la barra de herramientas de navegación';

  @override
  String get autoHideToolbar =>
      'Ocultar automáticamente la barra de herramientas';

  @override
  String get toolbarLocationOnScreen =>
      'Ubicación de la barra de herramientas en la pantalla';

  @override
  String get top => 'Cima';

  @override
  String get bottom => 'Fondo';

  @override
  String get center => 'Centrar';

  @override
  String get solidColor => 'Color sólido';

  @override
  String get picture => 'Imagen';

  @override
  String get chooseYourPicture => 'Elige tu foto';

  @override
  String get light => 'Luz';

  @override
  String get dark => 'Oscuro';

  @override
  String get themes => 'Temas';

  @override
  String get currentTheme => 'Tema actual';

  @override
  String get saveTheme => 'Guardar tema';

  @override
  String get showAnalysisGraph => 'Mostrar gráfico de análisis';

  @override
  String get analysis => 'Análisis';

  @override
  String get saveGame => 'Guardar partida';

  @override
  String get loadGame => 'Cargar juego';

  @override
  String get setupPosition => 'Preparar el escenario';

  @override
  String get showLegalMoves => 'Mostrar movimientos legales';

  @override
  String get showLastMove => 'Mostrar último movimiento';

  @override
  String get showArrows => 'Mostrar flechas';

  @override
  String get pieces => 'Piezas';

  @override
  String get showAnalysis => 'Mostrar análisis';

  @override
  String get threads => 'Hilos';

  @override
  String get getInvolved => 'Involucrarse';

  @override
  String get helpImproveTranslate => 'Ayuda a mejorar la traducción';

  @override
  String get tutorial => 'Tutorial';

  @override
  String get classicMill => 'Molino Clásico';

  @override
  String get mixedMill => 'Molino Mixto';

  @override
  String get ceylonMill => 'Molino de Ceilán';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'El molino puede romperse y rehacerse repetidamente';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Si un jugador rompe un molino para crear un nuevo molino inmediatamente, dicho jugador puede mover esa pieza de regreso a la unión original en su próximo movimiento si hace un nuevo molino.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'El juego se empata si un jugador tiene tres piezas y después de diez movimientos ninguno de los jugadores quita las piezas del oponente';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Cuando un jugador tiene tres piezas y ninguno de los jugadores puede quitar una pieza del oponente en diez movimientos, el juego es un empate.';

  @override
  String get close => 'Cerrar';

  @override
  String get whitePiece => 'Pieza blanca';

  @override
  String get blackPiece => 'Pieza negra';

  @override
  String get emptyPoint => 'Punto vacio';

  @override
  String get noPoint => 'No tiene sentido';

  @override
  String get placingPhase => 'Fase de colocación';

  @override
  String get movingPhase => 'Fase móvil';

  @override
  String get flyingPhase => 'Fase de vuelo';

  @override
  String sideToMove(Object player) {
    return 'Mover hacía: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Último movimiento: $move';
  }

  @override
  String get selected => 'Seleccionado';

  @override
  String get accessibility => 'Accesibilidad';

  @override
  String get screenReaderSupport => 'Soporte de lector de pantalla';

  @override
  String get isDraw => 'Es un empate!';

  @override
  String get draw => 'Empate';

  @override
  String get pieceHighlightColor => 'Color de resaltado de la pieza';

  @override
  String get algorithm => 'Algoritmo';

  @override
  String get endgameNMoveRule => 'Regla N-Move de Endgame';

  @override
  String get endgameNMoveRule_Detail =>
      'Si alguno de los jugadores tiene solo tres piezas y ninguno de los jugadores quita una pieza dentro de un movimiento específico, el juego se empata.';

  @override
  String get drawReasonEndgameRule50 =>
      'Cualquiera de los jugadores tiene solo tres piezas y ninguno de los jugadores quita una pieza dentro de un movimiento específico.';

  @override
  String get threefoldRepetitionRule => 'Regla de repetición triple';

  @override
  String get threefoldRepetitionRule_Detail =>
      'El juego se empata si se produce una posición por tercera vez.';

  @override
  String get continueToMakeMove => '¡Molino! Continúe haciendo un movimiento.';

  @override
  String get pointStyle => 'Estilo de punto';

  @override
  String get pointWidth => 'Ancho de punta';

  @override
  String get solid => 'Sólido';

  @override
  String get hollow => 'Hueco';

  @override
  String get languageName => 'Español';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Movimientos',
      one: '$count Movimiento',
      zero: 'Movimiento',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Falló al cargar.';

  @override
  String get filename => 'Nombre del archivo';

  @override
  String get browse => 'Explorar…';

  @override
  String get gameFiles => 'Archivos del juego';

  @override
  String get gameSavedTo => 'La partida se guarda en';

  @override
  String get empty => 'Vacío';

  @override
  String get noMove => 'No hay movimientos.';

  @override
  String get restoredPosition => 'Restablecida la posición inicial.';

  @override
  String get clean => 'Limpiar';

  @override
  String get cleanedUp => 'Limpio.';

  @override
  String get remove => 'Quitar';

  @override
  String get noPiecesCanBeRemoved => 'No se pueden retirar las piezas.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count fichas',
      one: '$count ficha',
      zero: 'ficha',
    );
    return 'Hay que retirar $_temp0.';
  }

  @override
  String placedCount(int count) {
    return 'Sit. ($count)';
  }

  @override
  String get placedPieceCount =>
      'Número de piezas colocadas en la fase de colocación.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'El jugador actual ha colocado $count piezas.';
  }

  @override
  String get notPlacingPhase =>
      'No es la fase de colocación, no se puede cambiar.';

  @override
  String get paste => 'Pegar';

  @override
  String get pasteDone => 'Se ha pegado.';

  @override
  String get cannotPaste => 'No se puede pegar.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Mostrar las piezas no colocadas y retiradas';

  @override
  String get fullScreen => 'A pantalla completa';

  @override
  String get reopenToTakeEffect =>
      'Salga y vuelva a abrir la aplicación para que los ajustes surtan efecto.';

  @override
  String get forest => 'Bosque';

  @override
  String get desktopImage => 'Imagen del escritorio';

  @override
  String get invalidPosition => 'Posición no válida.';

  @override
  String get shareGIF => 'Compartir un GIF';

  @override
  String get pixelRatio => 'Proporción de los píxeles';

  @override
  String get duration => 'Duración';

  @override
  String get gameScreenRecorder => 'Grabador para las pantalla de los juegos';

  @override
  String get previous => 'Anterior';

  @override
  String get next => 'Próximo';

  @override
  String get skip => 'Omitir';

  @override
  String get gotIt => 'Entiendo';

  @override
  String get youCanModifyRules =>
      'Puedes modificar las reglas del juego en la configuración de las reglas.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Puede usar la rueda del ratón para cambiar el valor en el selector.';

  @override
  String get noTimeLimitForThinking =>
      'El tiempo de pensamiento de la IA establecido en 0 significa que no hay límite de tiempo para pensar.';

  @override
  String get whatIsMtdf =>
      'MTD(f) es una forma modificada del algoritmo de búsqueda alfa-beta que pretende mejorar la eficiencia reutilizando los resultados intermedios de la búsqueda y utilizando una buena conjetura inicial para reducir el tiempo de búsqueda.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Por favor, tenga en cuenta que el ajuste del tiempo de pensamiento de la IA puede no ser del todo preciso. El tiempo real de pensamiento puede ser más corto si la dificultad se establece en un valor más bajo, y puede ser más largo si la IA está pensando cuando se acaba el tiempo.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Si establece la dificultad alta pero no aumenta el tiempo de pensamiento de la IA, la dificultad real puede limitarse a un valor más bajo debido a la limitación del tiempo de pensamiento. El valor real puede variar dependiendo del rendimiento de la máquina.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) es un algoritmo de búsqueda para encontrar el mejor movimiento en una posición dada. Es una mejora del algoritmo alfa-beta y utiliza búsquedas de ventana nula o cero para confirmar que un movimiento es peor o no peor que una puntuación ya segura de la variación principal. PVS se enfoca en los movimientos más prometedores y evita búsquedas innecesarias de sucursales subóptimas, lo que ayuda a mejorar la eficiencia de la búsqueda.';

  @override
  String get whatIsAlphaBeta =>
      'El algoritmo alfa-beta es un algoritmo de búsqueda para encontrar la mejor jugada. Utiliza el principio minimax y dos valores, alfa y beta, para acortar el abanico de las búsquedas y aumentar la eficiencia. Alfa representa la puntuación mínima que el ordenador está seguro de obtener, mientras que beta representa la puntuación máxima que puede obtener su oponente. El algoritmo ayuda al ordenador a tomar decisiones inteligentes y eficientes en una partida.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Según la experiencia humana, si intentas ganar, perderás. En lugar de eso, busca el empate como objetivo y evita perder la partida. Observa a tu oponente y llévalo suavemente a una posición en la que pueda cometer errores. Cuando muestren debilidad, aprovecha la oportunidad y presiona suavemente para ganar. De este modo, podrás ganar la partida.';

  @override
  String get firstMoveDetail =>
      'En este juego, es más fácil que el segundo jugador gane que el primero.';

  @override
  String get passiveDetail =>
      'Activar la opción Pasiva hará que la IA se relaje cuando tenga ventaja en la posición, en lugar de intentar ganar agresivamente lo más rápido posible.';

  @override
  String get moveRandomlyDetail =>
      'Activar esta opción aumenta la aleatoriedad y la diversión del juego, mientras que desactivarla puede ayudar a estudiar las formas de vencer a la IA.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Si la IA tiene en cuenta la movilidad de sus piezas, no sólo intentará capturar las piezas del oponente lo más rápido posible, sino que también bloqueará los movimientos del oponente y evitará que haga lo mismo.';

  @override
  String get whenBoardIsFull => 'Cuando el tablero está lleno';

  @override
  String get whenBoardIsFull_Detail =>
      'Al final de la fase de preparación, antes del inicio de la fase de movimiento, sigue una acción si el tablero está lleno de figuras.';

  @override
  String get sideToMoveRemovePiece =>
      'El jugador que mueve primero en la fase de movimiento elimina una de las piezas del adversario.';

  @override
  String get agreeToDraw => 'Ambas partes acuerdan un empate.';

  @override
  String get takeOpponentsPiece => 'Toma una de las piezas del oponente.';

  @override
  String get firstPlayerLose => 'El jugador uno pierde la partida.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'El jugador uno y dos retiran una de las piezas del adversario.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'El segundo y el primer jugador retiran una de las piezas del oponente.';

  @override
  String get enteredFlyingPhase =>
      'Ahora que hemos entrado en la fase de salto, las piezas contrarias pueden saltar a cualquier espacio vacío del tablero. Puede desactivar la regla de rebote en \"Configuración de reglas\".';

  @override
  String get whenStalemate => 'Cuando está atascado';

  @override
  String get whenStalemate_Detail =>
      '¿Qué pasa si no se puede mover ninguna pieza?';

  @override
  String get endWithStalemateLoss =>
      'Termina con una derrota por empate para el bando bloqueado.';

  @override
  String get changeSideToMove => 'Cambia el lado a mover.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Elimina una de las piezas del adversari@ y realiza el siguiente movimiento.';

  @override
  String get endWithStalemateDraw => 'Termina con un empate.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Elimina una de las piezas del adversari@ y cambia el lado para mover.';

  @override
  String get aiResponseDelayTime => 'Tiempo de respuesta de la IA';

  @override
  String get aiIsDelaying =>
      'La IA se encuentra actualmente en respuesta retardada. Por favor, espere un poco antes de continuar.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'No se puede eliminar una pieza no adyacente.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'En caso de empate, se pueden eliminar las piezas del adversari@ adyacentes a las tuyas, independientemente de la formación del molino.';

  @override
  String get whatIsMcts =>
      'MCTS es un algoritmo fácil de usar para principiantes que toma decisiones explorando y evaluando diferentes movimientos mediante simulaciones.';

  @override
  String get goldenJade => 'Jade de oro';

  @override
  String get forestWood => 'Madera del bosque';

  @override
  String get darkMystery => 'Misterio oscuro';

  @override
  String get midnightBlue => 'Azul medianoche';

  @override
  String get greenForest => 'Bosque verde';

  @override
  String get greenMeadow => 'Pradera Verde';

  @override
  String get stonyPath => 'Camino de Piedra';

  @override
  String get pastelPink => 'Rosa pastel';

  @override
  String get turquoiseSea => 'Agua del mar turquesa';

  @override
  String get violetDream => 'Sueño Violeta';

  @override
  String get mintChocolate => 'Chocolate con menta';

  @override
  String get skyBlue => 'Cielo azul';

  @override
  String get playfulGarden => 'Jardín lúdico';

  @override
  String get whatIsRetrogradeAnalysis =>
      'El algoritmo de análisis retrógrado utiliza un análisis retrógrado de valores múltiples para crear una base de datos de finales desde diferentes posiciones iniciales y luego aplica esta base de datos para optimizar el juego. Este enfoque se incluye en la categoría de soluciones ultrafuertes.';

  @override
  String get viewAlgorithmGuide =>
      '¿Desea consultar la guía del usuario de este algoritmo?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Visualización del indicador de la ventaja de la posición';

  @override
  String get usePerfectDatabase => 'Utilizar una base de datos perfecta';

  @override
  String get perfectDatabaseDescription =>
      'Active esta opción para utilizar una base de datos de partidas impecable generada mediante algoritmos de última generación. Esta función integra estrategias de apertura y finales para sugerir jugadas óptimas. Es la opción preferida por los jugadores que buscan el máximo nivel de precisión en el juego. Creada mediante meticulosas técnicas computacionales, la base de datos está diseñada para ofrecer soluciones de juego casi perfectas.\n\nNota: Si la IA no puede acceder a la base de datos, recurrirá a los algoritmos convencionales para tomar decisiones de juego. Cuando la base de datos está disponible, el \"Nivel de Dificultad\" se vuelve virtualmente imbatible, y el \"Tiempo de Pensamiento de la IA\" experimenta una drástica reducción. Muchos ajustes de las opciones de \"Estilo de juego de la IA\" quedarán anulados, ya que los resultados de la base de datos tienen la máxima prioridad.\n\nPara saber cómo sacar el máximo partido a esta impecable base de datos, haz clic aquí.';

  @override
  String get backgroundImage => 'Imagen de fondo';

  @override
  String get whatIsRandom =>
      'Cuando la opción \"Usar base de datos perfecta\" no está activada, el ajuste \"Aleatorio\" hace que la IA mueva las piezas al azar sin usar ningún algoritmo para la selección de movimientos. El resultado suele ser un juego mucho más débil. Por el contrario, cuando la opción \"Usar base de datos perfecta\" está activada, la IA se basa exclusivamente en la \"Base de datos perfecta\" para tomar decisiones, en lugar de combinarla con los algoritmos tradicionales de la IA. En este modo, los movimientos de la IA se basan por completo en el contenido de la base de datos, evitando los cálculos en tiempo real o los algoritmos de búsqueda.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Quita la(s) pieza(s) del oponente de su mano; luego es el turno del oponente para colocar.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Al formar molinos durante la fase de colocación';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Quita la(s) pieza(s) del oponente del tablero.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Quita la(s) pieza(s) del oponente del tablero; luego es el turno del oponente para colocar.';

  @override
  String get opponentRemovesOwnPiece =>
      'El oponente quita su(s) propia(s) pieza(s) del tablero.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'En lugar de que tú actúes, el oponente elige y quita su(s) propia(s) pieza(s) del tablero, tomando efectivamente una acción que es perjudicial para sí mismo.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Quita la(s) pieza(s) del oponente de su mano; luego es tu turno de mover.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Quita pieza(s) de la mano del oponente. Si, de acuerdo con la configuración de Multi-quitar, se deben quitar múltiples piezas y el oponente no tiene piezas restantes en la mano, continúa quitando las piezas del oponente del tablero. Luego, es tu turno de mover. Si continúas formando molinos, puedes seguir quitando las piezas del oponente.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Quita pieza(s) de la mano del oponente. Si, de acuerdo con la configuración de Multi-quitar, se deben quitar múltiples piezas y el oponente no tiene piezas restantes en la mano, continúa quitando las piezas del oponente del tablero. Luego, es el turno del oponente para mover.';

  @override
  String get markAndDelayRemovingPieces =>
      'Marca y retrasa la eliminación de piezas.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Durante la fase de colocación, las piezas a ser removidas se marcan, y para ambos jugadores, no se pueden colocar nuevas piezas en estos puntos. Al entrar en la fase de movimiento, estas piezas marcadas se quitan todas juntas, y los jugadores pueden entonces mover sus piezas a estos puntos ahora vacíos.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Las acciones que se pueden tomar al formar molinos durante la fase de colocación.';

  @override
  String get marked => 'Marcado';

  @override
  String get menu => 'Menú';

  @override
  String get monochrome => 'Monocromo';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Puede habilitar el botón de compatibilidad con lectores de pantalla en la configuración de Accesibilidad en Configuración general.';

  @override
  String get showNumbersOnPieces => 'Mostrar números en piezas';

  @override
  String get saveImage => 'Guardar la imagen';

  @override
  String get isAnalysisToolbarShown => 'Mostrar la barra de análisis';

  @override
  String get analysisToolbarBackgroundColor =>
      'Color de fondo de la barra de herramientas de análisis';

  @override
  String get analysisToolbarIconColor =>
      'Color del icono de la barra de herramientas de análisis';

  @override
  String get transformed => 'Transformado.';

  @override
  String get cannotTransform => 'No se puede transformar.';

  @override
  String get rotate => 'Rotar';

  @override
  String get horizontalFlip => 'Volteo H';

  @override
  String get verticalFlip => 'Volteo V';

  @override
  String get innerOuterFlip => 'Volteo IO';

  @override
  String get transparentCanvas => 'Lienzo transparente';

  @override
  String get restrictRepeatedMillsFormation =>
      'Restringir la formación repetida de molinos';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Una pieza movida de un molino para formar otro no puede volver inmediatamente al punto original en el siguiente turno para volver a formar un molino. Se requiere primero un movimiento diferente.';

  @override
  String get oneTimeUseMill => 'Molino desechable';

  @override
  String get oneTimeUseMill_Detail =>
      'Cada molino puede eliminar una pieza del adversario sólo una vez. Puedes reformarlo de nuevo, pero no puede utilizarse para eliminaciones adicionales.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Las reglas actuales que ha establecido no tienen una base de datos perfecta correspondiente. Para obtener más información sobre la base de datos perfecta, por favor haga clic aquí.';

  @override
  String get focusOnBlockingPaths => 'Concéntrese en bloquear caminos';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Durante fases específicas del juego, da prioridad a obstruir el movimiento del oponente sobre la formación de molinos. En lugar de centrarse en eliminar piezas completando molinos, la IA intenta atrapar al oponente durante estas fases, incapacitándole para moverse y asegurándose la victoria mediante el desgaste en lugar de mediante el juego agresivo. Esta estrategia específica para cada fase no bloquea activamente los molinos del adversario.';

  @override
  String get pieceImage => 'Imagen de la pieza';

  @override
  String get importColorSettings => 'Importar ajustes del color';

  @override
  String get exportColorSettings => 'Exportar ajustes del color';

  @override
  String get import => 'Importar';

  @override
  String get export => 'Exportar';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Por favor, copie primero los ajustes del formato JSON en el portapapeles.';

  @override
  String get copiedToClipboard => 'Copiado al portapapeles.';

  @override
  String get imported => 'Importado.';

  @override
  String get boardImage => 'Imagen del tablero';

  @override
  String get autumnLeaves => 'Hojas en otoño';

  @override
  String get legendaryLand => 'Tierra legendaria';

  @override
  String get vignetteEffect => 'Efecto viñeta';

  @override
  String get promptMakeToolbarTransparent =>
      '¿Quieres que la barra de herramientas sea completamente transparente cuando se establece una imagen de fondo?';

  @override
  String get vibration => 'Activar vibración en el juego';

  @override
  String get soundTheme => 'Tema de sonido';

  @override
  String get ball => 'Pelota';

  @override
  String get liquid => 'Líquido';

  @override
  String get wood => 'Madera';

  @override
  String get placeEffectAnimation => 'Efecto de animación al colocar la pieza';

  @override
  String get removeEffectAnimation =>
      'Efecto de animación al eliminar las piezas';

  @override
  String get isToolbarAtBottom =>
      'Mostrar barra de herramientas en la parte inferior';

  @override
  String get boardCornerRadius => 'Radio de esquina del tablero';

  @override
  String get useOpeningBook => 'Usar libro de apertura';

  @override
  String get currentRule => 'Actual';

  @override
  String get nineMensMorris => 'Alquerque de Nueve';

  @override
  String get twelveMensMorris => 'Juego del Molino con Doce Piezas';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Duz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhíqi';

  @override
  String get chengSanQi => 'Chéngsānqí';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Conjunto de reglas';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'Molino de una sola vez';

  @override
  String get daSanQi => 'Dǎsānqí';

  @override
  String get useOpeningBook_Detail =>
      'Permita que la IA use movimientos de apertura que comúnmente emplean los jugadores humanos profesionales durante el juego inicial. Nota: Esta característica está disponible actualmente solo para conjuntos de reglas específicos.';

  @override
  String get showAdvantageGraph => 'Mostrar gráfico de ventaja';

  @override
  String get advantageGraphHint =>
      'El gráfico de ventaja solo se dibujará después de que la IA haga un movimiento. No se dibujará cuando el jugador humano haga un movimiento.';

  @override
  String get removalBasedOnMillCounts =>
      'Deshabilita la eliminación hasta que todas las piezas estén colocadas. Luego retira las piezas según la cantidad de molinos formados.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Deshabilita la eliminación hasta que todas las piezas estén colocadas. Luego retira las piezas según la cantidad de molinos formados: si son iguales, ambos retiran la misma cantidad; si uno tiene más, retira una adicional, manteniendo así una diferencia de solo una pieza. Si solo uno forma molinos, retira dos piezas, y el otro retira una. Si ninguno forma molinos, ambos retiran una de sus propias piezas.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Selecciona una de tus piezas.';

  @override
  String get notYourTurn => 'No es tu turno.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Color de fondo de la barra de herramientas de anotación';

  @override
  String get annotationToolbarIconColor =>
      'Color del icono de la barra de herramientas de anotación';

  @override
  String get isAnnotationToolbarShown =>
      'Mostrar barra de herramientas de anotación';

  @override
  String get enterAnnotationMode => 'Entrar en modo de anotación';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      '¿Estás seguro de que quieres borrar todas las anotaciones?';

  @override
  String get llmPromptCopiedToClipboard =>
      'Prompt de LLM copiado al portapapeles.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Conexión rechazada, el servidor puede estar caído.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Descubrimiento exitoso, esperando conexión...';

  @override
  String get noLanConnection => 'Sin conexión LAN';

  @override
  String get takeScreenshot => 'Tomar captura de pantalla';

  @override
  String get disconnectedFromOpponent => 'Desconectado del oponente.';

  @override
  String get takeBackRequest => 'Solicitud de deshacer';

  @override
  String get nothingToShow => 'Nada que mostrar.';

  @override
  String get stopHosting => 'Dejar de alojar';

  @override
  String get connectionResetByPeer => 'Conexión reiniciada por el par.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Conexión perdida debido a tiempo de espera de latido. Por favor, reconecta.';

  @override
  String get startHosting => 'Comenzar a alojar';

  @override
  String get restartRequestRejected => 'Solicitud de reinicio rechazada.';

  @override
  String get notConnectedToLanOpponent => 'No conectado al oponente LAN.';

  @override
  String get llmPrompt => 'Prompt de LLM';

  @override
  String get gameRestarted => 'Juego reiniciado.';

  @override
  String get takeBackRejected => 'Deshacer rechazado.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      '¿Estás seguro de que quieres renunciar a este juego?';

  @override
  String get opponentResignedYouWin => 'El oponente renunció. ¡Tú ganas!';

  @override
  String get clearAllAnnotations => 'Borrar todas las anotaciones';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Conectado, esperando el movimiento del oponente...';

  @override
  String get networkStatusDisconnected => 'Estado de la red: Desconectado';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Solicitud de deshacer enviada al oponente.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'El oponente puede haber dejado el juego';

  @override
  String get connectedToHostSuccessfully => 'Conectado al host exitosamente.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Conexión perdida: tiempo de espera de latido';

  @override
  String get noHostDiscovered => 'No se descubrió ningún host.';

  @override
  String get confirmResignation => 'Confirmar renuncia';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Comenzó a alojar el juego, esperando que los jugadores se unan...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Tiempo de conexión agotado, conexión de red inestable.';

  @override
  String get noLlmPromptAvailable => 'No hay prompt de LLM disponible.';

  @override
  String get youResignedGameOver => 'Renunciaste. Fin del juego.';

  @override
  String get serverIp => 'IP del servidor';

  @override
  String get confirmClear => 'Confirmar borrado';

  @override
  String get opponentSTurn => 'Turno del oponente.';

  @override
  String get waitingAClientConnection => 'Esperando una conexión de cliente...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'La solicitud de deshacer fue rechazada o falló.';

  @override
  String get addText => 'Agregar texto';

  @override
  String get exitAnnotationMode => 'Salir del modo de anotación';

  @override
  String get typeYourAnnotation => 'Escribe tu anotación';

  @override
  String get attemptingToReconnect => 'Intentando reconectar...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Solicitud de reinicio enviada. Esperando la respuesta del oponente...';

  @override
  String get serverIsStopped => 'El servidor está detenido.';

  @override
  String get restartRequest => 'Solicitud de reinicio';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'No puedes solicitar un deshacer cuando no es tu turno.';

  @override
  String get takeBackAccepted => 'Deshacer aceptado.';

  @override
  String get localNetworkSettings => 'Configuración de red local';

  @override
  String get reconnectedSuccessfully => '¡Reconectado exitosamente!';

  @override
  String get failedToSaveImageToGallery =>
      'No se pudo guardar la imagen en la galería.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'El oponente solicitó reiniciar el juego. ¿Acepta?';

  @override
  String get yourTurn => 'Tu turno.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'No se puede reconectar, por favor reinicia el juego.';

  @override
  String get host => 'Anfitrión';

  @override
  String get join => 'Unirse';

  @override
  String get port => 'Puerto';

  @override
  String get invalidIpAddress => 'Dirección IP inválida.';

  @override
  String get invalidPort => 'Puerto inválido.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Conectando: Intento $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Error al conectar: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Error al iniciar el alojamiento: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Anfitrión descubierto: $ip:$port';
  }

  @override
  String get stop => 'Detener';

  @override
  String get discover => 'Descubrir';

  @override
  String get connect => 'Conectar';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Cliente conectado: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Descubriendo: $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Reconectando ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Conectado';

  @override
  String get delete => 'Eliminar';

  @override
  String get ancientEgypt => 'Antiguo Egipto';

  @override
  String get gothicIce => 'Hielo Gótico';

  @override
  String get riceField => 'Campo de Arroz';

  @override
  String get chinesePorcelain => 'Porcelana China';

  @override
  String get desertDusk => 'Atardecer del Desierto';

  @override
  String get precisionCraft => 'Artesanía de Precisión';

  @override
  String get folkEmbroidery => 'Bordado Folclórico';

  @override
  String get carpathianHeritage => 'Herencia de los Cárpatos';

  @override
  String get imperialGrandeur => 'Grandeza Imperial';

  @override
  String get bohemianCrystal => 'Cristal de Bohemia';

  @override
  String get savannaSunrise => 'Amanecer en la Sabana';

  @override
  String get harmonyBalance => 'Armonía y Equilibrio';

  @override
  String get cinnamonSpice => 'Especia de Canela';

  @override
  String get anatolianMosaic => 'Mosaico de Anatolia';

  @override
  String get carnivalSpirit => 'Espíritu de Carnaval';

  @override
  String get custom => 'Personalizado';

  @override
  String get spiceMarket => 'Mercado de especias';

  @override
  String get swipeToRevealTheDrawer => 'Deslice para mostrar el cajón.';

  @override
  String get showGameInfoOnScreenshots =>
      'Mostrar información del juego en capturas de pantalla';

  @override
  String get humanMoveTime => 'Límite de tiempo humano';

  @override
  String get noTimeLimitForHumanMoves =>
      'Sin límite de tiempo para los movimientos humanos';

  @override
  String get timeoutLoseWillBeApplied =>
      'Se aplicará la pérdida por tiempo de espera para el jugador humano';

  @override
  String get identifyingBoard => 'Identificando el tablero...';

  @override
  String get youCanEnterAnyModelName =>
      'Puedes introducir cualquier nombre de modelo.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Posición del tablero aplicada. FEN copiada al portapapeles.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Sugerencia: intenta tomar una foto más nítida del tablero.';

  @override
  String get llmPromptTemplate => 'Plantilla de prompt de LLM';

  @override
  String get noValidBoardDetected => 'No se detectó ningún tablero válido.';

  @override
  String get selectingImageFromAlbum => 'Seleccionando imagen del álbum...';

  @override
  String get configurePromptTemplate => 'Configurar plantilla de prompt';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Editar plantilla de prompt para el análisis de LLM';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'No se pudo generar la FEN a partir del tablero reconocido.';

  @override
  String get outputInCurrentLanguage => 'Salida en el idioma actual';

  @override
  String get commonBaseUrls => 'URLs Base comunes';

  @override
  String get viewCommonModels => 'Ver modelos comunes';

  @override
  String get recognitionParametersUpdated =>
      'Parámetros de reconocimiento actualizados.';

  @override
  String get whiteSMove => 'Turno de las blancas';

  @override
  String get resetToDefaults => 'Restablecer a valores predeterminados';

  @override
  String get photoShoot => 'Sesión de fotos';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'No se pudo aplicar la posición del tablero reconocida.';

  @override
  String get llmPromptContent => 'Contenido del prompt de LLM';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM no configurado. Por favor, revisa tu configuración.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Configurar proveedor, modelo, API Key y Base URL';

  @override
  String get llmConfiguration => 'Configuración de LLM';

  @override
  String get configureLlmProvider => 'Configurar proveedor de LLM';

  @override
  String get llmPromptTemplateHeader =>
      'Encabezado de la plantilla de prompt de LLM';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'No se reconocieron piezas en la imagen. Por favor, inténtalo de nuevo.';

  @override
  String get recognizeBoardFromImage => 'Reconocer tablero desde la imagen';

  @override
  String get viewTips => 'Ver consejos';

  @override
  String get applyToBoard => 'Aplicar al tablero';

  @override
  String get adjustBoardArea => 'Ajustar área del tablero';

  @override
  String get viewCommonUrls => 'Ver URLs comunes';

  @override
  String get colorAnalysisFailed => '¡Análisis de color fallido!';

  @override
  String get analyzingGameBoardImage =>
      'Analizando imagen del tablero de juego...';

  @override
  String get selectFromAlbum => 'Seleccionar del álbum';

  @override
  String get noBoardPointDetected => '¡No se detectó ningún punto del tablero!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Si lo dejas vacío, se usará la plantilla predeterminada.';

  @override
  String get llmConfig => 'Configuración de LLM';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      '¿Estás seguro de que quieres restablecer las plantillas de prompt a los valores predeterminados?';

  @override
  String get llmPromptTemplateFooter => 'Pie de la plantilla de prompt de LLM';

  @override
  String get loadingResponse => 'Cargando respuesta...';

  @override
  String get applyThisResultToBoard => 'Aplicar este resultado al tablero';

  @override
  String get takingPicture => 'Tomando foto...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Por favor, selecciona una imagen del tablero de juego para identificar';

  @override
  String get identificationResults => 'Resultados de la identificación';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Analiza las jugadas y proporciona observaciones.';

  @override
  String get getApiKey => 'Obtener API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'No se pudo completar todo el proceso de reconocimiento.';

  @override
  String get boardRecognitionResult =>
      'Resultado del reconocimiento del tablero';

  @override
  String get askLlm => 'Preguntar a LLM';

  @override
  String get boardDetectionFailed => '¡No se pudo detectar el tablero!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      '¡No se detectó ningún punto del tablero, no se puede identificar la pieza!';

  @override
  String get copyFen => 'Copiar FEN';

  @override
  String get commonlyUsedModels => 'Modelos más usados';

  @override
  String get apiKeyOptional => 'API Key (opcional)';

  @override
  String get noImageSelected => 'No se seleccionó ninguna imagen';

  @override
  String get blackSMove => 'Turno de las negras';

  @override
  String get llm => 'Modelo de Lenguaje Grande';

  @override
  String get llmProvider => 'Proveedor';

  @override
  String get baseUrl => 'URL base';

  @override
  String get model => 'Modelo';

  @override
  String get temperature => 'Temperatura';

  @override
  String get llmCommandReceivedProcessing =>
      '¡Comando recibido! La IA está procesando...';

  @override
  String get llmDeepThinkingWait =>
      'Pensamiento profundo en progreso, por favor espera...';

  @override
  String get llmPresentingSoon => 'Pronto se presentará...';

  @override
  String get recognitionParameters => 'Parámetros de reconocimiento';

  @override
  String get adjustParamsDesc =>
      'Ajusta los parámetros para mejorar la precisión del reconocimiento';

  @override
  String get saveParameters => 'Guardar parámetros';

  @override
  String unableToStartImageRecognition(String error) {
    return 'No se puede iniciar el reconocimiento de imágenes: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'El reconocimiento de imágenes falló: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Posición aplicada con $whiteCount piezas blancas y $blackCount negras';
  }

  @override
  String get fenCopiedToClipboard => '(FEN copiado al portapapeles)';

  @override
  String recognitionFailed(String error) {
    return 'El reconocimiento falló: $error';
  }

  @override
  String get myRating => 'Mi puntuación';

  @override
  String get gamesPlayed => 'Partidas jugadas';

  @override
  String get wins => 'Victorias';

  @override
  String get losses => 'Derrotas';

  @override
  String get draws => 'Empates';

  @override
  String get lastUpdated => 'Última actualización';

  @override
  String get format => 'Formato:';

  @override
  String get resetStatistics => 'Restablecer estadísticas';

  @override
  String get drawRate => 'Tasa de empates';

  @override
  String get lossRate => 'Tasa de derrotas';

  @override
  String get aiStatistics => 'Estadísticas de IA';

  @override
  String get enableStatistics => 'Habilitar estadísticas';

  @override
  String get enableStatistics_Detail =>
      'Cuando está habilitado, los resultados de los juegos se registrarán en las estadísticas. Sin embargo, los juegos que impliquen retrocesos no se registrarán. Cuando está deshabilitado, la recopilación de estadísticas se pausa.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Esto restablecerá todas las estadísticas del juego. Esta acción no se puede deshacer.';

  @override
  String get boardInnerRingSize => 'Tamaño del anillo interior del tablero';

  @override
  String get boardShadowEnabled => 'Sombra del tablero';

  @override
  String get trapAwareness => 'Detección de trampas';

  @override
  String get trapAwarenessDescription =>
      'Resalta los movimientos trampa con círculos y flechas en negrita durante el análisis.';

  @override
  String trapExists(String trapMoves) {
    return 'Existe una trampa. Movimientos trampa: $trapMoves';
  }

  @override
  String get custodianCapture => 'Captura flanqueante';

  @override
  String get custodianCaptureDescription =>
      'Adjunte una de las piezas de tu oponente entre dos de las tuyas en línea recta para capturarlo.';

  @override
  String get custodianCaptureEnable => 'Permitir captura flanqueante';

  @override
  String get interventionCapture => 'Captura de intervención';

  @override
  String get interventionCaptureDescription =>
      'Muévete al punto vacío entre dos de las piezas de tu oponente para capturarlas a las dos.';

  @override
  String get interventionCaptureEnable => 'Permitir la captura de intervención';

  @override
  String get leapCapture => 'Captura de salto';

  @override
  String get leapCaptureDescription =>
      'Captura saltando sobre la pieza de un oponente adyacente en el punto vacío más allá.';

  @override
  String get leapCaptureEnable => 'Permitir captura de salto';

  @override
  String get captureApplicableLines => 'Líneas aplicables';

  @override
  String get captureSquareEdges => 'A lo largo de los bordes de la plaza';

  @override
  String get captureCrossLines =>
      'A lo largo de líneas ortogonales que cruzan la plaza';

  @override
  String get captureDiagonalLines =>
      'A lo largo de líneas diagonales que cruzan el cuadrado';

  @override
  String get captureExecutionPhases => 'Fases de ejecución';

  @override
  String get capturePiecesCondition =>
      'Disponibilidad durante la fase móvil basada en las piezas restantes';

  @override
  String get capturePiecesConditionUnlimited => 'Sin restricción';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Disponible cuando tienes tres o menos piezas';
}
