// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for English (`en`).
class SEn extends S {
  SEn([String locale = 'en']) : super(locale);

  @override
  String get appName => 'Mill';

  @override
  String get welcome => 'Welcome';

  @override
  String get yes => 'Yes';

  @override
  String get no => 'No';

  @override
  String get game => 'Game';

  @override
  String get humanVsAi => 'Human Vs. AI';

  @override
  String get humanVsHuman => 'Human Vs. Human';

  @override
  String get aiVsAi => 'AI Vs. AI';

  @override
  String get humanVsCloud => 'Human Vs. Cloud';

  @override
  String get humanVsLAN => 'Human Vs. LAN';

  @override
  String get testViaLAN => 'Test Via LAN';

  @override
  String get move => 'Move';

  @override
  String get showMoveList => 'Move list';

  @override
  String get moveList => 'Move list';

  @override
  String get noGameRecord => 'No record';

  @override
  String get ok => 'OK';

  @override
  String get confirm => 'Confirm';

  @override
  String get cancel => 'Cancel';

  @override
  String get tipSelectWrong => 'Select the wrong piece.';

  @override
  String get tipPlace => 'Place your pieces.';

  @override
  String get tipBanPlace => 'You cannot place it here.';

  @override
  String get tipPlaced => 'Piece placed.';

  @override
  String get tipRemove => 'Remove a piece.';

  @override
  String get tipBanRemove => 'You cannot remove it.';

  @override
  String get tipRemoved => 'Piece removed.';

  @override
  String get tipMove => 'Move a piece.';

  @override
  String get tipCannotPlace => 'You can\'t place your piece here.';

  @override
  String get tipCannotMove => 'You can\'t move your piece here.';

  @override
  String get tipMill => 'Mill! Take your opponent\'s piece.';

  @override
  String get tipContinueMill => 'Continue to take your opponent\'s piece.';

  @override
  String get tipSelectOpponentsPiece =>
      'Select one of your opponent\'s pieces.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'You cannot remove a piece from a mill.';

  @override
  String get tipCanMoveOnePoint => 'A piece can move 1 point.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'You can\'t move your opponent\'s pieces.';

  @override
  String get tipSelectPieceToMove => 'Select your piece to move.';

  @override
  String get tipHaveThreePiecesLeft => 'You have three pieces left.';

  @override
  String get tipCanMoveToAnyPoint => 'You can move to any point you like.';

  @override
  String tipToMove(Object player) {
    return '$player to move.';
  }

  @override
  String get whiteWin => 'Player 1 wins!';

  @override
  String get blackWin => 'Player 2 wins!';

  @override
  String get won => 'Won';

  @override
  String get lost => 'Lost';

  @override
  String get thinking => 'Thinking…';

  @override
  String get newGame => 'New game';

  @override
  String get importGame => 'Import game';

  @override
  String get exportGame => 'Export game';

  @override
  String get gameImported => 'Game imported.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Cannot import $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'Moves and rules do not match.';

  @override
  String get pleaseWait => 'Please wait.';

  @override
  String get restartGame => 'Restart the current game?';

  @override
  String get restart => 'Restart';

  @override
  String get gameStarted => 'The game started, please place.';

  @override
  String get analyzing => 'Analyzing…';

  @override
  String error(Object message) {
    return 'Error: $message';
  }

  @override
  String get winRate => 'Win Rate';

  @override
  String get score => 'Score:';

  @override
  String get white => 'Player 1';

  @override
  String get black => 'Player 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player piece count is less than three.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player resigned.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player has no way to go.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'The board is full, and $player has no way to go.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Time is over, $player lost.';
  }

  @override
  String get drawReasonRule50 =>
      'In the moving phase, no piece has been removed in the last specific number of moves.';

  @override
  String get drawReasonBoardIsFull => 'It is a Draw because the board is full.';

  @override
  String get drawReasonThreefoldRepetition =>
      'It is a Draw because of threefold repetition.';

  @override
  String get gameOverUnknownReason => 'Game Over! Unknown reason.';

  @override
  String get gameOver => 'Game Over';

  @override
  String get youWin => 'You win! Congratulations!';

  @override
  String challengeHarderLevel(int level) {
    return 'Challenge harder level? The new level will be level $level!';
  }

  @override
  String get youLose => 'You Lose!';

  @override
  String get analyze => 'Analyze';

  @override
  String get about => 'About';

  @override
  String version(Object versionNumber) {
    return 'Version: $versionNumber';
  }

  @override
  String get thanks => 'Thanks';

  @override
  String get settings => 'Settings';

  @override
  String get options => 'Options';

  @override
  String get generalSettings => 'General Settings';

  @override
  String get skillLevel => 'Difficulty level';

  @override
  String get moveTime => 'AI thinking time';

  @override
  String get difficulty => 'Difficulty';

  @override
  String get playSounds => 'Sound effects';

  @override
  String get playSoundsInTheGame => 'Play sounds in the game';

  @override
  String get keepMuteWhenTakingBack => 'Keep mute when taking back';

  @override
  String get tone => 'Tone';

  @override
  String get whoMovesFirst => 'First move';

  @override
  String get human => 'Human';

  @override
  String get ai => 'AI';

  @override
  String get alternate => 'Alternate';

  @override
  String get isAutoRestart => 'Auto-restart game when game over';

  @override
  String get isAutoChangeFirstMove => 'Auto Change First Move';

  @override
  String get shufflingEnabled => 'Move randomly';

  @override
  String get misc => 'Miscellaneous';

  @override
  String get rules => 'Rules';

  @override
  String get piecesCount => 'The number of pieces each player has';

  @override
  String get piecesCount_Detail => 'How many pieces does each player have?';

  @override
  String get flyPieceCount => 'The number of the flying piece';

  @override
  String get flyPieceCount_Detail =>
      'If Flying is enabled, when a player\'s piece count falls below a certain threshold, their pieces are free to move to any unoccupied point instead of being restricted to adjacent points as in the rest of the game.';

  @override
  String get piecesAtLeastCount => 'Pieces At Least';

  @override
  String get hasDiagonalLines => 'Diagonal lines';

  @override
  String get hasDiagonalLines_Detail => 'Add four diagonal lines to the board.';

  @override
  String get isDefenderMoveFirst => 'The second player moves first';

  @override
  String get isDefenderMoveFirst_Detail =>
      'The player who moves second in the placing phase moves first in the moving phase.';

  @override
  String get mayRemoveMultiple => 'Multi-remove';

  @override
  String get mayRemoveMultiple_Detail =>
      'If a player closes more than one mill at once, she will remove the number of mills she closed.';

  @override
  String get mayRemoveFromMillsAlways => 'Destroy mills';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'By default, players must remove any other pieces first before removing a piece from a formed mill. Enable this option to disable the limitation.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'The second player loses when the board is full';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'When the board is full at the end of the placing phase, the side that places first loses the game. Otherwise, the game is a draw.';

  @override
  String get isLoseButNotChangeSideWhenNoWay => 'Lose when no legal moves';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'The player will lose if his opponent blocks them so that they cannot be moved. If this option is disabled, switch the side to move instead of declaring a loss.';

  @override
  String get mayFly => 'Flying';

  @override
  String get mayFly_Detail =>
      'If a player has only three or four (configurable) pieces left, she can move the piece to any free point.';

  @override
  String get nMoveRule => 'N-move rule';

  @override
  String get nMoveRule_Detail =>
      'The game is drawn if there has been no removal in a specific number of moves.';

  @override
  String get rollback => 'Rollback';

  @override
  String get pleaseSelect => 'Please select';

  @override
  String get copy => 'Copy';

  @override
  String get moveHistoryCopied => 'Move history copied to clipboard.';

  @override
  String get help => 'Help';

  @override
  String get feedback => 'Feedback';

  @override
  String get exit => 'Exit';

  @override
  String get ruleSettings => 'Rule Settings';

  @override
  String get color => 'Color';

  @override
  String get boardColor => 'Board color';

  @override
  String get pieceColor => 'Piece color';

  @override
  String get backgroundColor => 'Background color';

  @override
  String get lineColor => 'Board line color';

  @override
  String get whitePieceColor => 'Player 1 piece color';

  @override
  String get blackPieceColor => 'Player 2 piece color';

  @override
  String get messageColor => 'Message color';

  @override
  String get isPieceCountInHandShown => 'Show count of unplaced pieces';

  @override
  String get isNotationsShown => 'Show notations on board';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Show history navigation toolbar';

  @override
  String get display => 'Display';

  @override
  String get boardBorderLineWidth => 'Board borderline width';

  @override
  String get boardInnerLineWidth => 'Board inner line width';

  @override
  String get pieceWidth => 'Piece width';

  @override
  String get fontSize => 'Font size';

  @override
  String get standardNotation => 'WMD notation';

  @override
  String get restore => 'Restore';

  @override
  String get restoreDefaultSettings => 'Restore default settings';

  @override
  String pick(Object element) {
    return 'Pick $element';
  }

  @override
  String get info => 'Info';

  @override
  String get hint => 'Hint';

  @override
  String get player => 'player';

  @override
  String get player1 => 'Player 1';

  @override
  String get player2 => 'Player 2';

  @override
  String get howToPlay => 'How to Play';

  @override
  String get toPlacePiece => 'Tap on any available point to place the piece.';

  @override
  String get toSelectPiece => 'Tap on a piece to move it.';

  @override
  String get toMovePiece => 'Tap on a point connected to a piece to move it.';

  @override
  String get toRemovePiece =>
      'Tap on one of the opponent\'s pieces to remove it.';

  @override
  String get needToCreateMillFirst =>
      'You need to create a mill first before you can remove a piece.';

  @override
  String get needToPlayWithOwnPieces => 'You need to play with your pieces.';

  @override
  String get statistics => 'Statistics';

  @override
  String get totalGames => 'Total games';

  @override
  String get results => 'Results';

  @override
  String get left => 'left';

  @override
  String get privacyPolicy => 'Privacy Policy';

  @override
  String get privacyPolicy_Detail_1 =>
      'Please read carefully and make sure you fully understand and agree with this ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. If you do not agree to this Policy, please do not use this app. Using the app implies that you accept these terms.';

  @override
  String get and => ' and ';

  @override
  String get accept => 'Accept';

  @override
  String get takeBack => 'Take back';

  @override
  String get takingBack => 'Taking back…';

  @override
  String get waiting => 'Waiting…';

  @override
  String get stepForward => 'Step forward';

  @override
  String get takeBackAll => 'Take back all';

  @override
  String get stepForwardAll => 'Step forward all';

  @override
  String get moveNow => 'Move now';

  @override
  String get done => 'Done.';

  @override
  String get crackMill => 'Crack-mill';

  @override
  String get crackMill_Detail =>
      'If a player has only pieces in mills, the pieces in the mills will not lock to remove.';

  @override
  String get animationDuration => 'Animation duration';

  @override
  String get none => 'None';

  @override
  String get theme => 'Theme';

  @override
  String get helpContent =>
      'The game aims to leave the opponent with fewer than three pieces or no legal moves.\n\nThe game automatically draws if a position occurs for the third time or makes no remove in the last 100 (configurable) moves.\n\nThe game proceeds in three phases:\n\n1. Placing pieces on vacant points\n2. Moving pieces to adjacent points\n3. (optional phase) Moving pieces to any vacant point when reducing the player to three pieces\n\nPlacing\n\nThe game begins with an empty board, which consists of a grid with twenty-four points. Players take turns placing their pieces on vacant points until each player has placed all pieces on the board. If a player can put three of his pieces straight, he has a \"mill\" and may remove one of his opponent\'s pieces from the board.\n\nIn some rule sets, players must remove any other pieces first before removing a piece from a formed mill.\n\nUnder certain rules, you cannot place pieces again on points where pieces have been removed.\n\nOnce all pieces have been placed, players take turns moving them.\n\nMoving\n\nTo move, a player moves one of his pieces along a board line to a vacant adjacent point. If he cannot, he loses the game. A player who aligns three of his pieces on a board line has a mill and may remove one of his opponent\'s pieces as in the placing phase. If a player is reduced to two pieces, has no option to form new mills, and thus loses the game. A player can also lose when more than three pieces if his opponent blocks them from moving.\n\nFlying\n\nIn some variants of the rules, once a player has only three pieces left, their pieces can fly, hop, or jump to any vacant points, not only adjacent ones.\n';

  @override
  String get versionInfo => 'Version info';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'License';

  @override
  String get sourceCode => 'Source code';

  @override
  String get appVersion => 'App Version';

  @override
  String get general => 'General';

  @override
  String get advanced => 'Advanced';

  @override
  String get placing => 'Placing';

  @override
  String get moving => 'Moving';

  @override
  String get removing => 'Removing';

  @override
  String get gameOverCondition => 'Game over condition';

  @override
  String get aisPlayStyle => 'AI\'s play style';

  @override
  String get passive => 'Passive';

  @override
  String get timeout => 'Timeout';

  @override
  String get appearance => 'Appearance';

  @override
  String get drawOnHumanExperience => 'Draw on the human experience';

  @override
  String get considerMobility => 'Consider mobility of pieces';

  @override
  String get pieceCount => 'Piece count:';

  @override
  String inHand(Object player, int count) {
    return '$player in hand: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player on board: $count';
  }

  @override
  String get boardTop => 'Board offset from the top';

  @override
  String get notAIsTurn => 'It is not the AI\'s turn.';

  @override
  String get aiIsNotThinking => 'AI is not thinking.';

  @override
  String get atEnd => 'You are at the end of the move list.';

  @override
  String get tapBackAgainToLeave => 'Tap Back again to exit.';

  @override
  String get more => 'More';

  @override
  String get experimental => 'It is an experimental feature.';

  @override
  String get experiments => 'Experiments';

  @override
  String get ossLicenses => 'Open-source licenses';

  @override
  String get language => 'Language';

  @override
  String get defaultLanguage => 'Default language';

  @override
  String get mayMoveInPlacingPhase =>
      'The pieces can move in the placing phase';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'There are no distinct placing and moving phases, i.e., the players can decide at every move whether they want to place a piece on the board or move one of their pieces (as long as they have remaining pieces to place).';

  @override
  String get drawerColor => 'Menu color';

  @override
  String get drawerTextColor => 'Menu text color';

  @override
  String get drawerHighlightItemColor => 'Menu highlight item color';

  @override
  String get mainToolbarBackgroundColor => 'Main toolbar background color';

  @override
  String get mainToolbarIconColor => 'Main toolbar icon color';

  @override
  String get navigationToolbarBackgroundColor =>
      'Navigation toolbar background color';

  @override
  String get navigationToolbarIconColor => 'Navigation toolbar icon color';

  @override
  String get autoHideToolbar => 'Automatically hide the toolbar';

  @override
  String get toolbarLocationOnScreen => 'Toolbar location on screen';

  @override
  String get top => 'Top';

  @override
  String get bottom => 'Bottom';

  @override
  String get center => 'Center';

  @override
  String get solidColor => 'Solid color';

  @override
  String get picture => 'Picture';

  @override
  String get chooseYourPicture => 'Choose your picture';

  @override
  String get light => 'Light';

  @override
  String get dark => 'Dark';

  @override
  String get themes => 'Themes';

  @override
  String get currentTheme => 'Current theme';

  @override
  String get saveTheme => 'Save theme';

  @override
  String get showAnalysisGraph => 'Show analysis graph';

  @override
  String get analysis => 'Analysis';

  @override
  String get saveGame => 'Save game';

  @override
  String get loadGame => 'Load game';

  @override
  String get setupPosition => 'Setup Position';

  @override
  String get showLegalMoves => 'Show legal moves';

  @override
  String get showLastMove => 'Show last move';

  @override
  String get showArrows => 'Show arrows';

  @override
  String get pieces => 'Pieces';

  @override
  String get showAnalysis => 'Show analysis';

  @override
  String get threads => 'Threads';

  @override
  String get getInvolved => 'Get Involved';

  @override
  String get helpImproveTranslate => 'Help improve translate';

  @override
  String get tutorial => 'Tutorial';

  @override
  String get classicMill => 'Classic Mill';

  @override
  String get mixedMill => 'Mixed Mill';

  @override
  String get ceylonMill => 'Ceylon Mill';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Mill may be broken and remade repeatedly';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'If a player breaks a mill to immediately form a new one, they can move that piece back to the original point in their next move if it forms another new mill.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'The game is drawn if a player has three pieces and after ten moves neither player removes the opponent\'s pieces';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'When a player is down to three pieces, and neither player can remove an opponent\'s piece within ten moves, the game is a draw.';

  @override
  String get close => 'Close';

  @override
  String get whitePiece => 'White piece';

  @override
  String get blackPiece => 'Black piece';

  @override
  String get emptyPoint => 'Empty point';

  @override
  String get noPoint => 'No point';

  @override
  String get placingPhase => 'Placing phase';

  @override
  String get movingPhase => 'Moving phase';

  @override
  String get flyingPhase => 'Flying phase';

  @override
  String sideToMove(Object player) {
    return 'Side to move: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Last move: $move';
  }

  @override
  String get selected => 'Selected';

  @override
  String get accessibility => 'Accessibility';

  @override
  String get screenReaderSupport => 'Screen reader support';

  @override
  String get isDraw => 'It is a Draw!';

  @override
  String get draw => 'Draw';

  @override
  String get pieceHighlightColor => 'Piece highlight color';

  @override
  String get algorithm => 'Algorithm';

  @override
  String get endgameNMoveRule => 'Endgame N-Move rule';

  @override
  String get endgameNMoveRule_Detail =>
      'The game is drawn if either player has only three pieces and neither player removes a piece within specific moves.';

  @override
  String get drawReasonEndgameRule50 =>
      'Either player has only three pieces, and neither player removes a piece within specific moves.';

  @override
  String get threefoldRepetitionRule => 'Threefold repetition rule';

  @override
  String get threefoldRepetitionRule_Detail =>
      'The game is drawn if a position occurs for the third time.';

  @override
  String get continueToMakeMove => 'Mill! Continue to make a move.';

  @override
  String get pointStyle => 'Point style';

  @override
  String get pointWidth => 'Point width';

  @override
  String get solid => 'Solid';

  @override
  String get hollow => 'Hollow';

  @override
  String get languageName => 'English';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Moves',
      one: '$count Move',
      zero: 'Move',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Load failed.';

  @override
  String get filename => 'File name';

  @override
  String get browse => 'Browse…';

  @override
  String get gameFiles => 'Game files';

  @override
  String get gameSavedTo => 'The game is saved to';

  @override
  String get empty => 'Empty';

  @override
  String get noMove => 'No move.';

  @override
  String get restoredPosition => 'Restored initial position.';

  @override
  String get clean => 'Clean';

  @override
  String get cleanedUp => 'Cleaned up.';

  @override
  String get remove => 'Remove';

  @override
  String get noPiecesCanBeRemoved => 'No pieces can be removed.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count pieces',
      one: '$count piece',
      zero: 'Piece',
    );
    return '$_temp0 need to remove.';
  }

  @override
  String placedCount(int count) {
    return 'Placed ($count)';
  }

  @override
  String get placedPieceCount => 'Placed piece count in the placing phase.';

  @override
  String hasPlacedPieceCount(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'The current player has placed $count pieces.',
      one: 'The current player has placed one piece.',
      zero: 'The current player has placed no pieces.',
    );
    return '$_temp0';
  }

  @override
  String get notPlacingPhase => 'Not placing phase, cannot change it.';

  @override
  String get paste => 'Paste';

  @override
  String get pasteDone => 'The paste is done.';

  @override
  String get cannotPaste => 'Cannot paste.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Show unplaced and removed pieces';

  @override
  String get fullScreen => 'Full screen';

  @override
  String get reopenToTakeEffect =>
      'Exit and reopen app for settings to take effect.';

  @override
  String get forest => 'Forest';

  @override
  String get desktopImage => 'Desktop Image';

  @override
  String get invalidPosition => 'Invalid position.';

  @override
  String get shareGIF => 'Share GIF';

  @override
  String get pixelRatio => 'Pixel ratio';

  @override
  String get duration => 'Duration';

  @override
  String get gameScreenRecorder => 'Game screen recorder';

  @override
  String get previous => 'Previous';

  @override
  String get next => 'Next';

  @override
  String get skip => 'Skip';

  @override
  String get gotIt => 'Got it';

  @override
  String get youCanModifyRules =>
      'You can modify the rules of the game in the rule settings.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'You can use the mouse wheel to adjust the value in the picker.';

  @override
  String get noTimeLimitForThinking =>
      'AI Thinking time set to 0 means there is no time limit for thinking.';

  @override
  String get whatIsMtdf =>
      'MTD(f) is a modified form of the alpha-beta search algorithm that aims to improve efficiency by reusing intermediate search results and using a good initial guess to narrow the search space.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Please be aware that the AI thinking time adjustment may not be entirely precise. The actual thinking time may be shorter when the difficulty level is set to a lower value and may be longer when the AI is mid-thought when the time runs out.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'If you set the difficulty level high but do not increase the AI thinking time, the actual difficulty level may be limited to a lower value due to the thinking time constraint. The actual value may vary based on the machine\'s performance.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) is a search algorithm to find the best move in a given position. It is an enhancement of the alpha-beta algorithm and uses null or zero window searches to confirm that a move is worse or not worse than an already safe score from the principal variation. PVS focuses on the most promising moves and avoids unnecessary searches of suboptimal branches, which helps improve the efficiency of the search.';

  @override
  String get whatIsAlphaBeta =>
      'The alpha-beta algorithm is a search algorithm to find the best move. It uses the minimax principle and two values, alpha and beta, to prune the search tree and increase efficiency. Alpha represents the minimum score the computer is sure it can get, while beta represents the maximum score its opponent can get. The algorithm helps the computer make smart, efficient decisions in a game.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'According to human experience, if you try to win, you will lose. Instead, aim for a draw as your goal and avoid losing the game. Observe your opponent and gently lure them into a position where they may make mistakes. When they show weakness, seize the opportunity and gently push for the win. In this way, you can win the game.';

  @override
  String get firstMoveDetail =>
      'In this game, it is easier for the second player to win compared to the first player.';

  @override
  String get passiveDetail =>
      'Enabling the Passive option will cause the AI to relax when it has an advantage in the position, rather than aggressively trying to win as quickly as possible.';

  @override
  String get moveRandomlyDetail =>
      'Enabling this option increases the randomness and fun of the game while disabling it can help study ways to beat the AI.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'If the AI considers the mobility of its pieces, it will not only aim to capture the opponent\'s pieces as quickly as possible, but also consider blocking the opponent\'s movements and preventing them from doing the same.';

  @override
  String get whenBoardIsFull => 'When the board is full';

  @override
  String get whenBoardIsFull_Detail =>
      'At the end of the placing phase, before the moving phase begins, the action follows if the board is full of pieces.';

  @override
  String get sideToMoveRemovePiece =>
      'The player who moves first in the moving phase removes one of the opponent\'s pieces.';

  @override
  String get agreeToDraw => 'Both sides agree to a draw.';

  @override
  String get takeOpponentsPiece => 'Take one of your opponent\'s pieces.';

  @override
  String get firstPlayerLose => 'The first player loses the game.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'The first and second players remove one of the opponent\'s pieces.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'The second and first players remove one of the opponent\'s pieces.';

  @override
  String get enteredFlyingPhase =>
      'Now entered the flying phase, the opponent\'s pieces can jump to any empty point on the board. You can turn off the flying rule in the \"Rule Settings\".';

  @override
  String get whenStalemate => 'When stalemate';

  @override
  String get whenStalemate_Detail =>
      'What action follows when no piece can be moved?';

  @override
  String get endWithStalemateLoss =>
      'End with a stalemate loss for the side that is blocked.';

  @override
  String get changeSideToMove => 'Change the side to move.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Remove one of the opponent\'s pieces and make the next move.';

  @override
  String get endWithStalemateDraw => 'End with a stalemate draw.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Remove one of the opponent\'s pieces and change the side to move.';

  @override
  String get aiResponseDelayTime => 'AI response delay time';

  @override
  String get aiIsDelaying =>
      'AI is currently in a delayed response phase. Please wait for a while before proceeding.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'You cannot remove a nonadjacent piece.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'In a stalemate, you can remove the opponent\'s pieces adjacent to yours, regardless of mill formation.';

  @override
  String get whatIsMcts =>
      'MCTS is a beginner-friendly algorithm that makes decisions by exploring and evaluating different moves through simulations.';

  @override
  String get goldenJade => 'Golden Jade';

  @override
  String get forestWood => 'Forest Wood';

  @override
  String get darkMystery => 'Dark Mystery';

  @override
  String get midnightBlue => 'Midnight Blue';

  @override
  String get greenForest => 'Green Forest';

  @override
  String get greenMeadow => 'Green Meadow';

  @override
  String get stonyPath => 'Stony Path';

  @override
  String get pastelPink => 'Pastel Pink';

  @override
  String get turquoiseSea => 'Turquoise Sea';

  @override
  String get violetDream => 'Violet Dream';

  @override
  String get mintChocolate => 'Mint Chocolate';

  @override
  String get skyBlue => 'Sky Blue';

  @override
  String get playfulGarden => 'Playful Garden';

  @override
  String get whatIsRetrogradeAnalysis =>
      'The Retrograde Analysis algorithm uses multi-valued retrograde analysis to build an endgame database from different start positions, then applies this database to optimize gameplay. This approach falls under the category of Ultra-Strong solutions.';

  @override
  String get viewAlgorithmGuide =>
      'Would you like to view the user guide for this algorithm?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Show positional advantage indicator';

  @override
  String get usePerfectDatabase => 'Use perfect database';

  @override
  String get perfectDatabaseDescription =>
      'Enable this option to use a flawless game database generated through cutting-edge algorithms. This feature integrates both opening and endgame strategies to suggest optimal moves. This is the preferred choice for players who seek the highest level of precision in gameplay. Created through meticulous computational techniques, the database is designed to offer near-perfect game solutions.\n\nNote: Should the AI fail to access the database, it will turn to conventional algorithms for gameplay decisions. When the database is available, the \'Difficulty Level\' becomes virtually unbeatable, and \'AI Thinking Time\' experiences a drastic reduction. Many settings within \'AI\'s play style\' options will be overridden, as the database outcomes hold the highest priority.\n\nFor guidance on how to make the most of this flawless database, click here.';

  @override
  String get backgroundImage => 'Background image';

  @override
  String get whatIsRandom =>
      'When the \'Use perfect database\' option is not enabled, the \'Random\' setting causes the AI to move pieces randomly without using any algorithms for move selection. This typically results in significantly weaker gameplay. Conversely, when \'Use perfect database\' is enabled, the AI exclusively relies on the \'Perfect Database\' for making decisions, instead of blending it with traditional AI algorithms. In this mode, the AI\'s moves are entirely based on the database\'s content, eschewing reliance on real-time calculations or search algorithms.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Remove the opponent\'s piece(s) from their hand; then it\'s the opponent\'s turn to place.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'When forming mills during the placing phase';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Remove opponent\'s piece(s) from the board.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Remove the opponent\'s piece(s) from the board; then it\'s the opponent\'s turn to place.';

  @override
  String get opponentRemovesOwnPiece =>
      'The opponent removes their own piece(s) from the board.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Instead of you taking action, the opponent chooses and removes their own piece(s) from the board, effectively taking an action that is detrimental to themselves.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Remove the opponent\'s piece(s) from their hand, then it\'s your turn to move.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Remove piece(s) from the opponent\'s hand. If, according to the Multi-remove setting, multiple pieces are to be removed and the opponent has no pieces left in hand, continue removing the opponent\'s pieces from the board. Then, it\'s your turn to move. If you continue to form mills, you may keep removing the opponent\'s pieces.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Remove piece(s) from the opponent\'s hand. If, according to the Multi-remove setting, multiple pieces are to be removed and the opponent has no pieces left in hand, continue removing the opponent\'s pieces from the board. Then, it\'s the opponent\'s turn to move.';

  @override
  String get markAndDelayRemovingPieces => 'Mark and delay removing pieces.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'During the placing phase, the pieces to be removed are marked, and for both players, no new pieces can be placed on these points. Upon entering the moving phase, these marked pieces are removed altogether, and players can then move their pieces to these now-empty points.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'The actions that can be taken when forming mills during the placing phase.';

  @override
  String get marked => 'Marked';

  @override
  String get menu => 'Menu';

  @override
  String get monochrome => 'Monochrome';

  @override
  String get youCanEnableScreenReaderSupport =>
      'You can enable the Screen reader support switch in the Accessibility configuration in General Settings.';

  @override
  String get showNumbersOnPieces => 'Show numbers on pieces';

  @override
  String get saveImage => 'Save Image';

  @override
  String get isAnalysisToolbarShown => 'Show analysis toolbar';

  @override
  String get analysisToolbarBackgroundColor =>
      'Analysis toolbar background color';

  @override
  String get analysisToolbarIconColor => 'Analysis toolbar icon color';

  @override
  String get transformed => 'Transformed.';

  @override
  String get cannotTransform => 'Cannot transform.';

  @override
  String get rotate => 'Rotate';

  @override
  String get horizontalFlip => 'H Flip';

  @override
  String get verticalFlip => 'V Flip';

  @override
  String get innerOuterFlip => 'IO Flip';

  @override
  String get transparentCanvas => 'Transparent Canvas';

  @override
  String get restrictRepeatedMillsFormation =>
      'Restrict repeated mills formation';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'A piece moved from one mill to form another cannot immediately return to the original point on the next turn to form a mill again. A different move is required first.';

  @override
  String get oneTimeUseMill => 'One-time use mill';

  @override
  String get oneTimeUseMill_Detail =>
      'Each mill can remove an opponent\'s piece only once. You can reform it again, but it cannot be used for additional removals.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'The current rules you have set do not have a corresponding perfect database. For more information about the perfect database, please click here.';

  @override
  String get focusOnBlockingPaths => 'Focus on blocking paths';

  @override
  String get focusOnBlockingPaths_Detail =>
      'During specific phases of the game, prioritize obstructing the opponent\'s movement over forming mills. Instead of focusing on removing pieces by completing mills, the AI aims to trap the opponent during these phases, rendering them unable to move and securing a win through attrition rather than aggressive play. This phase-specific strategy does not actively block the opponent\'s mills.';

  @override
  String get pieceImage => 'Piece image';

  @override
  String get importColorSettings => 'Import color settings';

  @override
  String get exportColorSettings => 'Export color settings';

  @override
  String get import => 'Import';

  @override
  String get export => 'Export';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Please copy the JSON format settings to the clipboard first.';

  @override
  String get copiedToClipboard => 'Copied to clipboard.';

  @override
  String get imported => 'Imported.';

  @override
  String get boardImage => 'Board image';

  @override
  String get autumnLeaves => 'Autumn Leaves';

  @override
  String get legendaryLand => 'Legendary Land';

  @override
  String get vignetteEffect => 'Vignette effect';

  @override
  String get promptMakeToolbarTransparent =>
      'Would you like to make the toolbar fully transparent when a board background image is set?';

  @override
  String get vibration => 'Enable vibration in the game';

  @override
  String get soundTheme => 'Sound theme';

  @override
  String get ball => 'Ball';

  @override
  String get liquid => 'Liquid';

  @override
  String get wood => 'Wood';

  @override
  String get placeEffectAnimation => 'Piece placing animation effect';

  @override
  String get removeEffectAnimation => 'Piece removing animation effect';

  @override
  String get isToolbarAtBottom => 'Show toolbar at bottom';

  @override
  String get boardCornerRadius => 'Board corner radius';

  @override
  String get useOpeningBook => 'Use opening book';

  @override
  String get currentRule => 'Current';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Rule set';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'One-Time Mill';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'Let the AI use opening moves commonly employed by professional human players during the early game. Note: This feature is currently available only for specific rule sets.';

  @override
  String get showAdvantageGraph => 'Show advantage graph';

  @override
  String get advantageGraphHint =>
      'Advantage graph will only be drawn after the AI makes a move. It will not be drawn when the human player makes a move.';

  @override
  String get removalBasedOnMillCounts =>
      'Disable removal until all pieces have been placed, then remove pieces based on mill counts.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Disable removal until all pieces have been placed, then remove pieces based on mill counts: if they are equal, both remove the same number; if one has more, they remove one extra, keeping a one-piece difference. If only one forms mills, they remove two pieces, and the other removes one. If neither forms mills, both remove one of their own pieces.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Select one of your pieces.';

  @override
  String get notYourTurn => 'It\'s not your turn.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Annotation toolbar background color';

  @override
  String get annotationToolbarIconColor => 'Annotation toolbar icon color';

  @override
  String get isAnnotationToolbarShown => 'Show annotation toolbar';

  @override
  String get enterAnnotationMode => 'Enter annotation mode';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Are you sure you want to clear all annotations?';

  @override
  String get llmPromptCopiedToClipboard => 'LLM prompt copied to clipboard.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Connection refused, the server may be down.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Discovery successful, awaiting connection...';

  @override
  String get noLanConnection => 'No LAN connection';

  @override
  String get takeScreenshot => 'Take Screenshot';

  @override
  String get disconnectedFromOpponent => 'Disconnected from opponent.';

  @override
  String get takeBackRequest => 'Take Back Request';

  @override
  String get nothingToShow => 'Nothing to show.';

  @override
  String get stopHosting => 'Stop Hosting';

  @override
  String get connectionResetByPeer => 'Connection reset by peer.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Connection lost due to heartbeat timeout. Please reconnect.';

  @override
  String get startHosting => 'Start Hosting';

  @override
  String get restartRequestRejected => 'Restart request rejected.';

  @override
  String get notConnectedToLanOpponent => 'Not connected to LAN opponent.';

  @override
  String get llmPrompt => 'LLM prompt';

  @override
  String get gameRestarted => 'Game restarted.';

  @override
  String get takeBackRejected => 'Take back rejected.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Are you sure you want to resign this game?';

  @override
  String get opponentResignedYouWin => 'Opponent resigned. You win!';

  @override
  String get clearAllAnnotations => 'Clear all annotations';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Connected, waiting for opponent\'s move...';

  @override
  String get networkStatusDisconnected => 'Network status: Disconnected';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Take back request sent to the opponent.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'The opponent may have left the game';

  @override
  String get connectedToHostSuccessfully => 'Connected to host successfully.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Connection lost: heartbeat timeout';

  @override
  String get noHostDiscovered => 'No host discovered.';

  @override
  String get confirmResignation => 'Confirm resignation';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Started hosting game, waiting for players to join...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Connection timed out, network connection unstable.';

  @override
  String get noLlmPromptAvailable => 'No LLM prompt available.';

  @override
  String get youResignedGameOver => 'You resigned. Game over.';

  @override
  String get serverIp => 'Server IP';

  @override
  String get confirmClear => 'Confirm clear';

  @override
  String get opponentSTurn => 'Opponent\'s turn.';

  @override
  String get waitingAClientConnection => 'Waiting a client connection...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Take back request was rejected or failed.';

  @override
  String get addText => 'Add text';

  @override
  String get exitAnnotationMode => 'Exit annotation mode';

  @override
  String get typeYourAnnotation => 'Type your annotation';

  @override
  String get attemptingToReconnect => 'Attempting to reconnect...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Restart request sent. Waiting for opponent\'s response...';

  @override
  String get serverIsStopped => 'Server is stopped.';

  @override
  String get restartRequest => 'Restart request';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Cannot request a take back when it\'s not your turn.';

  @override
  String get takeBackAccepted => 'Take back accepted.';

  @override
  String get localNetworkSettings => 'Local network settings';

  @override
  String get reconnectedSuccessfully => 'Reconnected successfully!';

  @override
  String get failedToSaveImageToGallery => 'Failed to save image to Gallery.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Opponent requested to restart the game. Do you accept?';

  @override
  String get yourTurn => 'Your turn.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Unable to reconnect, please restart the game.';

  @override
  String get host => 'Host';

  @override
  String get join => 'Join';

  @override
  String get port => 'Port';

  @override
  String get invalidIpAddress => 'Invalid IP address.';

  @override
  String get invalidPort => 'Invalid port.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Connecting: Attempt $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Failed to connect: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Failed to start hosting: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Host discovered: $ip:$port';
  }

  @override
  String get stop => 'Stop';

  @override
  String get discover => 'Discover';

  @override
  String get connect => 'Connect';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Client connected: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Discovering: $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Reconnecting ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Connected';

  @override
  String get delete => 'Delete';

  @override
  String get ancientEgypt => 'Ancient Egypt';

  @override
  String get gothicIce => 'Gothic Ice';

  @override
  String get riceField => 'Rice Field';

  @override
  String get chinesePorcelain => 'Chinese Porcelain';

  @override
  String get desertDusk => 'Desert Dusk';

  @override
  String get precisionCraft => 'Precision Craft';

  @override
  String get folkEmbroidery => 'Folk Embroidery';

  @override
  String get carpathianHeritage => 'Carpathian Heritage';

  @override
  String get imperialGrandeur => 'Imperial Grandeur';

  @override
  String get bohemianCrystal => 'Bohemian Crystal';

  @override
  String get savannaSunrise => 'Savanna Sunrise';

  @override
  String get harmonyBalance => 'Harmony Balance';

  @override
  String get cinnamonSpice => 'Cinnamon Spice';

  @override
  String get anatolianMosaic => 'Anatolian Mosaic';

  @override
  String get carnivalSpirit => 'Carnival Spirit';

  @override
  String get custom => 'Custom';

  @override
  String get spiceMarket => 'Spice Market';

  @override
  String get swipeToRevealTheDrawer => 'Swipe to reveal the Drawer';

  @override
  String get showGameInfoOnScreenshots => 'Show game info on screenshots';

  @override
  String get humanMoveTime => 'Human time limit';

  @override
  String get noTimeLimitForHumanMoves => 'No time limit for human moves';

  @override
  String get timeoutLoseWillBeApplied =>
      'Timeout lose will be applied for human player';

  @override
  String get identifyingBoard => 'Identifying board...';

  @override
  String get youCanEnterAnyModelName => 'You can enter any model name.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Board position applied. FEN copied to clipboard.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Suggestion: try taking a clearer picture of the board.';

  @override
  String get llmPromptTemplate => 'LLM prompt template';

  @override
  String get noValidBoardDetected => 'No valid board detected.';

  @override
  String get selectingImageFromAlbum => 'Selecting image from album...';

  @override
  String get configurePromptTemplate => 'Configure prompt template';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Edit prompt template for LLM analysis';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Failed to generate FEN from recognized board.';

  @override
  String get outputInCurrentLanguage => 'Output in current language';

  @override
  String get commonBaseUrls => 'Common base URLs';

  @override
  String get viewCommonModels => 'View common models';

  @override
  String get recognitionParametersUpdated => 'Recognition parameters updated.';

  @override
  String get whiteSMove => 'White\'s move';

  @override
  String get resetToDefaults => 'Reset to defaults';

  @override
  String get photoShoot => 'Photo shoot';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Failed to apply recognized board position.';

  @override
  String get llmPromptContent => 'LLM prompt content';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM not configured. Please check your settings.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Set provider, model, API Key, and Base URL';

  @override
  String get llmConfiguration => 'LLM configuration';

  @override
  String get configureLlmProvider => 'Configure LLM provider';

  @override
  String get llmPromptTemplateHeader => 'LLM prompt template header';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'No pieces were recognized in the image. Please try again.';

  @override
  String get recognizeBoardFromImage => 'Recognize board from image';

  @override
  String get viewTips => 'View tips';

  @override
  String get applyToBoard => 'Apply to board';

  @override
  String get adjustBoardArea => 'Adjust board area';

  @override
  String get viewCommonUrls => 'View common URLs';

  @override
  String get colorAnalysisFailed => 'Color analysis failed!';

  @override
  String get analyzingGameBoardImage => 'Analyzing game board image...';

  @override
  String get selectFromAlbum => 'Select from album';

  @override
  String get noBoardPointDetected => 'No board point detected!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'If left empty, default template will be used';

  @override
  String get llmConfig => 'LLM configuration';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Are you sure you want to reset the prompt templates to default values?';

  @override
  String get llmPromptTemplateFooter => 'LLM prompt template footer';

  @override
  String get loadingResponse => 'Loading response...';

  @override
  String get applyThisResultToBoard => 'Apply this result to board';

  @override
  String get takingPicture => 'Taking picture...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Please select a game board image to identify';

  @override
  String get identificationResults => 'Identification results';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Analyze the moves and provide insights.';

  @override
  String get getApiKey => 'Get API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Entire recognition process failed to complete.';

  @override
  String get boardRecognitionResult => 'Board recognition result';

  @override
  String get askLlm => 'Ask LLM';

  @override
  String get boardDetectionFailed => 'Board detection failed!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'No board point detected, cannot identify piece!';

  @override
  String get copyFen => 'Copy FEN';

  @override
  String get commonlyUsedModels => 'Commonly used models';

  @override
  String get apiKeyOptional => 'API Key (optional)';

  @override
  String get noImageSelected => 'No image selected';

  @override
  String get blackSMove => 'Black\'s move';

  @override
  String get llm => 'Large Language Model';

  @override
  String get llmProvider => 'Provider';

  @override
  String get baseUrl => 'Base URL';

  @override
  String get model => 'Model';

  @override
  String get temperature => 'Temperature';

  @override
  String get llmCommandReceivedProcessing =>
      'Command received! AI is processing...';

  @override
  String get llmDeepThinkingWait => 'Deep thinking in progress, please wait...';

  @override
  String get llmPresentingSoon => 'Presenting soon...';

  @override
  String get recognitionParameters => 'Recognition parameters';

  @override
  String get adjustParamsDesc =>
      'Adjust parameters to improve recognition accuracy';

  @override
  String get saveParameters => 'Save parameters';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Unable to start image recognition: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Image recognition failed: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Applied position with $whiteCount white and $blackCount black pieces';
  }

  @override
  String get fenCopiedToClipboard => '(FEN copied to clipboard)';

  @override
  String recognitionFailed(String error) {
    return 'Recognition failed: $error';
  }

  @override
  String get myRating => 'My rating';

  @override
  String get gamesPlayed => 'Games played';

  @override
  String get wins => 'Wins';

  @override
  String get losses => 'Losses';

  @override
  String get draws => 'Draws';

  @override
  String get lastUpdated => 'Last updated';

  @override
  String get format => 'Format:';

  @override
  String get resetStatistics => 'Reset statistics';

  @override
  String get drawRate => 'Draw rate';

  @override
  String get lossRate => 'Loss rate';

  @override
  String get aiStatistics => 'AI statistics';

  @override
  String get enableStatistics => 'Enable statistics';

  @override
  String get enableStatistics_Detail =>
      'When enabled, game results will be recorded in statistics. However, games involving take-backs will not be recorded. When disabled, statistics collection is paused.';

  @override
  String get thisWillResetAllGameStatistics =>
      'This will reset all game statistics. This action cannot be undone.';

  @override
  String get boardInnerRingSize => 'Board inner ring size';

  @override
  String get boardShadowEnabled => 'Board shadow';

  @override
  String get trapAwareness => 'Trap awareness';

  @override
  String get trapAwarenessDescription =>
      'Highlight trap moves with bold circles and arrows during analysis.';

  @override
  String trapExists(String trapMoves) {
    return 'Trap exists. Trap moves: $trapMoves';
  }

  @override
  String get custodianCapture => 'Custodian capture';

  @override
  String get custodianCaptureDescription =>
      'Bracket one of your opponent\'s pieces between two of yours along a line to remove it.';

  @override
  String get custodianCaptureEnable => 'Allow custodian capture';

  @override
  String get interventionCapture => 'Intervention capture';

  @override
  String get interventionCaptureDescription =>
      'Move into the empty point between two of your opponent\'s pieces to remove them both.';

  @override
  String get interventionCaptureEnable => 'Allow intervention capture';

  @override
  String get leapCapture => 'Leap capture';

  @override
  String get leapCaptureDescription =>
      'Capture by leaping over an adjacent opponent\'s piece into the empty point beyond.';

  @override
  String get leapCaptureEnable => 'Allow leap capture';

  @override
  String get captureApplicableLines => 'Applicable lines';

  @override
  String get captureSquareEdges => 'Along the square\'s edges';

  @override
  String get captureCrossLines => 'Along orthogonal lines crossing the square';

  @override
  String get captureDiagonalLines => 'Along diagonal lines crossing the square';

  @override
  String get captureExecutionPhases => 'Execution phases';

  @override
  String get capturePiecesCondition =>
      'Piece-based availability during moving phase';

  @override
  String get capturePiecesConditionUnlimited => 'No restriction';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Available when you have 3 or fewer pieces';
}
