// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Modern Greek (`el`).
class SEl extends S {
  SEl([String locale = 'el']) : super(locale);

  @override
  String get appName => 'Μύλος';

  @override
  String get welcome => 'Καλώς ήρθατε';

  @override
  String get yes => 'Ναι';

  @override
  String get no => 'Όχι';

  @override
  String get game => 'Παιχνίδι';

  @override
  String get humanVsAi => 'Άνθρωπος vs AI';

  @override
  String get humanVsHuman => 'Δύο άνθρωποι';

  @override
  String get aiVsAi => 'AI vs AI';

  @override
  String get humanVsCloud => 'Άνθρωπος vs Cloud';

  @override
  String get humanVsLAN => 'Άνθρωπος vs LAN';

  @override
  String get testViaLAN => 'Δοκιμή μέσω LAN';

  @override
  String get move => 'Μετακίνηση';

  @override
  String get showMoveList => 'Λίστα κινήσεων';

  @override
  String get moveList => 'Λίστα κινήσεων';

  @override
  String get noGameRecord => 'Δεν υπάρχει εγγραφή';

  @override
  String get ok => 'OK';

  @override
  String get confirm => 'Επιβεβαίωση';

  @override
  String get cancel => 'Ακύρωση';

  @override
  String get tipSelectWrong => 'Έχετε επιλέξει λάθος κομμάτι.';

  @override
  String get tipPlace => 'Τοποθετήστε τα κομμάτια σας.';

  @override
  String get tipBanPlace => 'Δεν μπορείτε να το τοποθετήσετε εδώ.';

  @override
  String get tipPlaced => 'Τοποθετήσατε.';

  @override
  String get tipRemove => 'Αφαιρέστε ένα κομμάτι.';

  @override
  String get tipBanRemove => 'Δεν μπορείτε να το αφαιρέσετε.';

  @override
  String get tipRemoved => 'Αφαιρέσατε.';

  @override
  String get tipMove => 'Μετακινήστε ένα κομμάτι.';

  @override
  String get tipCannotPlace =>
      'Δεν μπορείτε να τοποθετήσετε το κομμάτι σας εδώ.';

  @override
  String get tipCannotMove =>
      'Δεν μπορείτε να μετακινήσετε το κομμάτι σας εδώ.';

  @override
  String get tipMill => 'Μύλος! Αφαιρέστε ένα κομμάτι του αντιπάλου.';

  @override
  String get tipContinueMill =>
      'Συνεχίστε να παίρνετε το κομμάτι του αντιπάλου σας.';

  @override
  String get tipSelectOpponentsPiece =>
      'Επιλέξτε ένα από τα κομμάτια του αντιπάλου σας.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Δεν μπορείτε να αφαιρέσετε ένα κομμάτι από ένα μύλο.';

  @override
  String get tipCanMoveOnePoint =>
      'Ένα κομμάτι μπορεί να μετακινηθεί κατά 1 πόντο.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Δεν μπορείτε να μετακινήσετε τα κομμάτια του αντιπάλου σας.';

  @override
  String get tipSelectPieceToMove =>
      'Επιλέξτε το κομμάτι που θέλετε να μετακινήσετε.';

  @override
  String get tipHaveThreePiecesLeft => 'Σας απομένουν τρία κομμάτια.';

  @override
  String get tipCanMoveToAnyPoint =>
      'Μπορείς να μετακινηθείς σε όποιο σημείο θέλεις.';

  @override
  String tipToMove(Object player) {
    return '$player για μετακίνηση.';
  }

  @override
  String get whiteWin => 'Ο παίκτης 1 κερδίζει!';

  @override
  String get blackWin => 'Ο παίκτης 2 κερδίζει!';

  @override
  String get won => 'Κέρδισε';

  @override
  String get lost => 'Χάθηκε';

  @override
  String get thinking => 'Σκέφτομαι…';

  @override
  String get newGame => 'Νέο παιχνίδι';

  @override
  String get importGame => 'Εισαγωγή παιχνιδιού';

  @override
  String get exportGame => 'Εξαγωγή παιχνιδιού';

  @override
  String get gameImported => 'Εισαγωγή παιχνιδιού.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Δεν είναι δυνατή η εισαγωγή $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch =>
      'Οι κινήσεις και οι κανόνες δεν ταιριάζουν.';

  @override
  String get pleaseWait => 'Παρακαλώ περιμένετε.';

  @override
  String get restartGame => 'Επανεκκίνηση του τρέχοντος παιχνιδιού;';

  @override
  String get restart => 'Επανεκκίνηση';

  @override
  String get gameStarted =>
      'Το παιχνίδι ξεκίνησε. Παρακαλούμε τοποθετήστε τα κομμάτια σας.';

  @override
  String get analyzing => 'Ανάλυση…';

  @override
  String error(Object message) {
    return 'Σφάλμα: $message';
  }

  @override
  String get winRate => 'Ποσοστό νίκης';

  @override
  String get score => 'Βαθμολογία:';

  @override
  String get white => 'Παίκτης 1';

  @override
  String get black => 'Παίκτης 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player ο αριθμός τεμαχίων είναι μικρότερος από τρία.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player παραιτήθηκε.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return 'Ο $player δεν έχει καμία διαθέσιμη κίνηση.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Το ταμπλό είναι γεμάτο και ο $player δεν μπορεί να κινηθεί.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Ο χρόνος τελείωσε, το $player έχασε.';
  }

  @override
  String get drawReasonRule50 =>
      'Στη φάση της μετακίνησης, κανένα κομμάτι δεν έχει αφαιρεθεί στον τελευταίο συγκεκριμένο αριθμό κινήσεων.';

  @override
  String get drawReasonBoardIsFull =>
      'Είναι ισοπαλία επειδή το ταμπλό είναι γεμάτο.';

  @override
  String get drawReasonThreefoldRepetition =>
      'Είναι Ισοπαλία λόγω τριπλής επανάληψης.';

  @override
  String get gameOverUnknownReason => 'Τέλος παιχνιδιού! Άγνωστος λόγος.';

  @override
  String get gameOver => 'Τέλος παιχνιδιού';

  @override
  String get youWin => 'Κερδίσατε! Συγχαρητήρια!';

  @override
  String challengeHarderLevel(int level) {
    return 'Πρόκληση πιο δύσκολο επίπεδο; Το νέο επίπεδο θα είναι επίπεδο $level!';
  }

  @override
  String get youLose => 'Χάνετε!';

  @override
  String get analyze => 'Αναλύστε το';

  @override
  String get about => 'Σχετικά με το';

  @override
  String version(Object versionNumber) {
    return 'Έκδοση: $versionNumber';
  }

  @override
  String get thanks => 'Ευχαριστώ';

  @override
  String get settings => 'Ρυθμίσεις';

  @override
  String get options => 'Επιλογές';

  @override
  String get generalSettings => 'Γενικές ρυθμίσεις';

  @override
  String get skillLevel => 'Επίπεδο δυσκολίας';

  @override
  String get moveTime => 'Χρόνος σκέψης AI';

  @override
  String get difficulty => 'Δυσκολία';

  @override
  String get playSounds => 'Ηχητικά εφέ';

  @override
  String get playSoundsInTheGame => 'Αναπαραγωγή ήχων στο παιχνίδι';

  @override
  String get keepMuteWhenTakingBack =>
      'Διατηρήστε τη σίγαση όταν παίρνετε πίσω';

  @override
  String get tone => 'Ήχος';

  @override
  String get whoMovesFirst => 'Πρώτη κίνηση';

  @override
  String get human => 'Ανθρώπινο';

  @override
  String get ai => 'AI';

  @override
  String get alternate => 'Εναλλακτική';

  @override
  String get isAutoRestart =>
      'Αυτόματη επανεκκίνηση του παιχνιδιού όταν τελειώσει το παιχνίδι';

  @override
  String get isAutoChangeFirstMove => 'Αυτόματη αλλαγή πρώτης κίνησης';

  @override
  String get shufflingEnabled => 'Τυχαία κίνηση';

  @override
  String get misc => 'Διάφορα';

  @override
  String get rules => 'Κανόνες';

  @override
  String get piecesCount => 'Ο αριθμός των κομματιών που έχει κάθε παίκτης';

  @override
  String get piecesCount_Detail => 'Πόσα κομμάτια έχει κάθε παίκτης;';

  @override
  String get flyPieceCount => 'Ο αριθμός του ιπτάμενου κομματιού';

  @override
  String get flyPieceCount_Detail =>
      'Εάν είναι ενεργοποιημένο το Ιπτάμενο κομμάτι, όταν ένας παίκτης μειωθεί σε έναν συγκεκριμένο αριθμό κομματιών, τα κομμάτια του είναι ελεύθερα να μετακινηθούν σε οποιοδήποτε μη κατειλημμένο σημείο αντί να περιορίζονται σε γειτονικά σημεία όπως στο υπόλοιπο παιχνίδι.';

  @override
  String get piecesAtLeastCount => 'Κομμάτια Τουλάχιστον';

  @override
  String get hasDiagonalLines => 'Διαγώνιες γραμμές';

  @override
  String get hasDiagonalLines_Detail =>
      'Προσθέστε τέσσερις διαγώνιες γραμμές στο ταμπλό.';

  @override
  String get isDefenderMoveFirst => 'Ο δεύτερος παίκτης κινείται πρώτος';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Ο παίκτης που κινείται δεύτερος στη φάση τοποθέτησης κινείται πρώτος στη φάση μετακίνησης.';

  @override
  String get mayRemoveMultiple => 'Πολλαπλή αφαίρεση';

  @override
  String get mayRemoveMultiple_Detail =>
      'Εάν ένας παίκτης κλείσει περισσότερους από έναν μύλους ταυτόχρονα, θα αφαιρέσει τον αριθμό των μύλων που έκλεισε.';

  @override
  String get mayRemoveFromMillsAlways => 'Καταστροφή μύλων';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Από προεπιλογή, οι παίκτες πρέπει να αφαιρέσουν άλλα κομμάτια πριν αφαιρέσουν ένα από έναν σχηματισμένο μύλο. Ενεργοποιήστε αυτή την επιλογή για να καταργήσετε αυτόν τον περιορισμό.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Ο δεύτερος παίκτης χάνει όταν το ταμπλό είναι γεμάτο';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Όταν το ταμπλό είναι γεμάτο στο τέλος της φάσης τοποθέτησης, η πλευρά που τοποθετεί πρώτη χάνει το παιχνίδι. Διαφορετικά, το παιχνίδι είναι ισόπαλο.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Χάνει όταν δεν υπάρχουν νόμιμες κινήσεις';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Ο παίκτης χάνει αν ο αντίπαλός του τους μπλοκάρει έτσι ώστε να μην μπορούν να μετακινηθούν. Αλλάξτε πλευρά για να μετακινηθείτε αν αυτή η επιλογή είναι απενεργοποιημένη.';

  @override
  String get mayFly => 'Ιπτάμενο';

  @override
  String get mayFly_Detail =>
      'Εάν ένας παίκτης έχει μόνο τρία ή τέσσερα (διαμορφώσιμα) κομμάτια, μπορεί να μετακινήσει το κομμάτι σε οποιοδήποτε ελεύθερο σημείο.';

  @override
  String get nMoveRule => 'Κανόνας Ν-κίνησης';

  @override
  String get nMoveRule_Detail =>
      'Το παιχνίδι λήγει αν δεν έχει γίνει καμία αφαίρεση σε συγκεκριμένο αριθμό κινήσεων από κάθε παίκτη.';

  @override
  String get rollback => 'Επαναφορά';

  @override
  String get pleaseSelect => 'Παρακαλώ επιλέξτε';

  @override
  String get copy => 'Αντιγραφή';

  @override
  String get moveHistoryCopied =>
      'Το ιστορικό κινήσεων αντιγράφεται στο πρόχειρο.';

  @override
  String get help => 'Βοήθεια';

  @override
  String get feedback => 'Ανατροφοδότηση';

  @override
  String get exit => 'Έξοδος';

  @override
  String get ruleSettings => 'Ρυθμίσεις κανόνων';

  @override
  String get color => 'Χρώμα';

  @override
  String get boardColor => 'Χρώμα πίνακα';

  @override
  String get pieceColor => 'Χρώμα κομματιού';

  @override
  String get backgroundColor => 'Χρώμα φόντου';

  @override
  String get lineColor => 'Χρώμα γραμμής ταμπλό';

  @override
  String get whitePieceColor => 'Χρώμα κομματιού παίκτη 1';

  @override
  String get blackPieceColor => 'Χρώμα κομματιού παίκτη 2';

  @override
  String get messageColor => 'Χρώμα μηνύματος';

  @override
  String get isPieceCountInHandShown =>
      'Εμφάνιση του αριθμού των κομματιών στο χέρι';

  @override
  String get isNotationsShown => 'Εμφάνιση σημειώσεων στο ταμπλό';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Εμφάνιση γραμμής εργαλείων πλοήγησης ιστορικού';

  @override
  String get display => 'Εμφάνιση';

  @override
  String get boardBorderLineWidth => 'Πλάτος ορίων σκακιέρας';

  @override
  String get boardInnerLineWidth => 'Πλάτος εσωτερικής γραμμής του ταμπλό';

  @override
  String get pieceWidth => 'Πλάτος τεμαχίου';

  @override
  String get fontSize => 'Μέγεθος γραμματοσειράς';

  @override
  String get standardNotation => 'Σημειώσεις WMD';

  @override
  String get restore => 'Επαναφορά';

  @override
  String get restoreDefaultSettings => 'Επαναφορά προεπιλεγμένων ρυθμίσεων';

  @override
  String pick(Object element) {
    return 'Επιλέξτε $element';
  }

  @override
  String get info => 'Πληρ.';

  @override
  String get hint => 'Υπόδειξη';

  @override
  String get player => 'παίκτης';

  @override
  String get player1 => 'Παίκτης 1';

  @override
  String get player2 => 'Παίκτης 2';

  @override
  String get howToPlay => 'Πώς να παίξετε';

  @override
  String get toPlacePiece =>
      'Πατήστε σε οποιοδήποτε διαθέσιμο σημείο για να τοποθετήσετε το κομμάτι.';

  @override
  String get toSelectPiece => 'Πατήστε σε ένα κομμάτι για να το μετακινήσετε.';

  @override
  String get toMovePiece =>
      'Πατήστε σε σημείο που συνδέεται με κομμάτι για να το μετακινήσετε.';

  @override
  String get toRemovePiece =>
      'Πατήστε σε ένα κομμάτι του αντιπάλου για να το αφαιρέσετε.';

  @override
  String get needToCreateMillFirst =>
      'Πρέπει πρώτα να δημιουργήσετε έναν μύλο πριν μπορέσετε να αφαιρέσετε ένα κομμάτι.';

  @override
  String get needToPlayWithOwnPieces => 'Πρέπει να παίξετε με τα κομμάτια σας.';

  @override
  String get statistics => 'Στατιστικά στοιχεία';

  @override
  String get totalGames => 'Σύνολο παιχνιδιών';

  @override
  String get results => 'Αποτελέσματα';

  @override
  String get left => 'αριστερά';

  @override
  String get privacyPolicy => 'Πολιτική απορρήτου';

  @override
  String get privacyPolicy_Detail_1 =>
      'Παρακαλούμε διαβάστε προσεκτικά και βεβαιωθείτε ότι έχετε κατανοήσει πλήρως και συμφωνείτε με αυτό ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Εάν δεν συμφωνείτε με την παρούσα Πολιτική, παρακαλούμε μην χρησιμοποιείτε αυτή την εφαρμογή. Η χρήση της Εφαρμογής συνεπάγεται ότι αποδέχεστε αυτούς τους όρους.';

  @override
  String get and => ' και ';

  @override
  String get accept => 'Αποδέχομαι το';

  @override
  String get takeBack => 'Πάρτε πίσω';

  @override
  String get takingBack => 'Λήψη πίσω…';

  @override
  String get waiting => 'Αναμονή…';

  @override
  String get stepForward => 'Βήμα προς τα εμπρός';

  @override
  String get takeBackAll => 'Πάρτε τα όλα πίσω';

  @override
  String get stepForwardAll => 'Βήμα προς τα εμπρός όλοι';

  @override
  String get moveNow => 'Προχωρήστε τώρα';

  @override
  String get done => 'Έγινε.';

  @override
  String get crackMill => 'Κρακ-μύλος';

  @override
  String get crackMill_Detail =>
      'Εάν ένας παίκτης έχει μόνο κομμάτια σε μύλους, τα κομμάτια στους μύλους δεν θα κλειδώσουν για να αφαιρεθούν.';

  @override
  String get animationDuration => 'Διάρκεια κίνησης';

  @override
  String get none => 'Καμία';

  @override
  String get theme => 'Θέμα';

  @override
  String get helpContent =>
      'Στόχος του παιχνιδιού είναι να αφήσετε τον αντίπαλο με λιγότερα από τρία κομμάτια ή χωρίς νόμιμες κινήσεις.\n\nΤο παιχνίδι λήγει αυτόματα αν μια θέση εμφανιστεί για τρίτη φορά ή αν δεν γίνει καμία αφαίρεση στις τελευταίες 100 (διαμορφώσιμες) κινήσεις.\n\nΤο παιχνίδι εξελίσσεται σε τρεις φάσεις:\n\n1. Τοποθέτηση κομματιών σε κενά σημεία\n2. Μετακίνηση κομματιών σε γειτονικά σημεία\n3. (προαιρετική φάση) Μετακίνηση κομματιών σε οποιοδήποτε κενό σημείο όταν ο παίκτης μειώνεται σε τρία κομμάτια.\n\nΤοποθέτηση\n\nΤο παιχνίδι ξεκινά με ένα άδειο ταμπλό, το οποίο αποτελείται από ένα πλέγμα με είκοσι τέσσερα σημεία. Οι παίκτες τοποθετούν εναλλάξ τα κομμάτια τους στα κενά σημεία μέχρι κάθε παίκτης να τοποθετήσει όλα τα κομμάτια του στο ταμπλό. Εάν ένας παίκτης μπορεί να τοποθετήσει τρία από τα κομμάτια του στην ευθεία, έχει \"μύλο\" και μπορεί να αφαιρέσει ένα από τα κομμάτια του αντιπάλου του από το ταμπλό.\n\nΣε ορισμένους κανόνες, οι παίκτες πρέπει να αφαιρέσουν πρώτα όλα τα άλλα κομμάτια πριν αφαιρέσουν ένα κομμάτι από ένα σχηματισμένο μύλο.\n\nΣε ορισμένους κανόνες δεν μπορείτε να τοποθετήσετε ξανά τα κομμάτια στα σημεία των αφαιρεθέντων κομματιών στη φάση τοποθέτησης.\n\nΑφού χρησιμοποιήσετε όλα τα κομμάτια, οι παίκτες κινούνται εναλλάξ.\n\nΜετακίνηση\n\nΓια να μετακινηθεί, ένας παίκτης μετακινεί ένα από τα κομμάτια του κατά μήκος μιας γραμμής του ταμπλό σε ένα κενό γειτονικό σημείο. Αν δεν μπορεί να το κάνει αυτό, έχει χάσει το παιχνίδι. Όπως και στη φάση τοποθέτησης, ο παίκτης που ευθυγραμμίζει τρία από τα κομμάτια του σε μια γραμμή του ταμπλό έχει ένα μύλο και μπορεί να αφαιρέσει ένα από τα κομμάτια του αντιπάλου του. Οποιοσδήποτε παίκτης μειώσει σε δύο κομμάτια, δεν έχει τη δυνατότητα να σχηματίσει νέους μύλους και έτσι χάνει το παιχνίδι. Ένας παίκτης μπορεί επίσης να χάσει όταν έχει περισσότερα από τρία κομμάτια, αν ο αντίπαλός του τα εμποδίσει να κινηθούν.\n\nΠετώντας\n\nΣε ορισμένες παραλλαγές των κανόνων, όταν ένας παίκτης έχει μόνο τρία κομμάτια, τα κομμάτια του μπορούν να πετάξουν, να πηδήξουν ή να πηδήξουν σε οποιαδήποτε κενά σημεία, όχι μόνο σε γειτονικά.';

  @override
  String get versionInfo => 'Πληροφορίες έκδοσης';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'Άδεια χρήσης';

  @override
  String get sourceCode => 'Πηγαίος κώδικας';

  @override
  String get appVersion => 'Έκδοση εφαρμογής';

  @override
  String get general => 'Γενικά';

  @override
  String get advanced => 'Προηγμένη';

  @override
  String get placing => 'Τοποθέτηση';

  @override
  String get moving => 'Μετακίνηση';

  @override
  String get removing => 'Αφαίρεση';

  @override
  String get gameOverCondition => 'Κατάσταση λήξης παιχνιδιού';

  @override
  String get aisPlayStyle => 'Στυλ παιχνιδιού της AI';

  @override
  String get passive => 'Παθητικό';

  @override
  String get timeout => 'Τέλος χρόνου';

  @override
  String get appearance => 'Εμφάνιση';

  @override
  String get drawOnHumanExperience => 'Αξιοποίηση της ανθρώπινης εμπειρίας';

  @override
  String get considerMobility => 'Εξετάστε την κινητικότητα των κομματιών';

  @override
  String get pieceCount => 'Αριθμός κομματιών:';

  @override
  String inHand(Object player, int count) {
    return '$player στο χέρι: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player επί του σκάφους: $count';
  }

  @override
  String get boardTop => 'Μετατόπιση του ταμπλό από την κορυφή';

  @override
  String get notAIsTurn => 'Δεν είναι η σειρά της ΤΝ.';

  @override
  String get aiIsNotThinking => 'Η ΤΝ δεν σκέφτεται.';

  @override
  String get atEnd => 'Βρίσκεστε στο τέλος της λίστας κινήσεων.';

  @override
  String get tapBackAgainToLeave => 'Πατήστε ξανά πίσω για να φύγετε.';

  @override
  String get more => 'Περισσότερα';

  @override
  String get experimental => 'Πρόκειται για μια πειραματική λειτουργία.';

  @override
  String get experiments => 'Πειράματα';

  @override
  String get ossLicenses => 'Άδειες χρήσης ανοικτού κώδικα';

  @override
  String get language => 'Γλώσσα';

  @override
  String get defaultLanguage => 'Προεπιλεγμένη γλώσσα';

  @override
  String get mayMoveInPlacingPhase =>
      'Τα κομμάτια μπορούν να μετακινηθούν στη φάση τοποθέτησης';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Δεν υπάρχουν διακριτές φάσεις τοποθέτησης και μετακίνησης, δηλαδή, οι παίκτες μπορούν να αποφασίζουν σε κάθε κίνηση αν θέλουν να τοποθετήσουν ένα κομμάτι στο ταμπλό ή να μετακινήσουν ένα από τα κομμάτια τους (εφόσον έχουν εναπομείναντα κομμάτια για τοποθέτηση).';

  @override
  String get drawerColor => 'Χρώμα μενού';

  @override
  String get drawerTextColor => 'Χρώμα κειμένου μενού';

  @override
  String get drawerHighlightItemColor => 'Χρώμα στοιχείου επισήμανσης μενού';

  @override
  String get mainToolbarBackgroundColor =>
      'Χρώμα φόντου κύριας γραμμής εργαλείων';

  @override
  String get mainToolbarIconColor =>
      'χρώμα εικονιδίου κύριας γραμμής εργαλείων';

  @override
  String get navigationToolbarBackgroundColor =>
      'Χρώμα φόντου στη γραμμή εργαλείων πλοήγησης';

  @override
  String get navigationToolbarIconColor =>
      'Χρώμα εικονιδίου γραμμής εργαλείων πλοήγησης';

  @override
  String get autoHideToolbar => 'Κρύψτε αυτόματα τη γραμμή εργαλείων';

  @override
  String get toolbarLocationOnScreen =>
      'Τοποθεσία γραμμής εργαλείων στην οθόνη';

  @override
  String get top => 'Μπλουζα';

  @override
  String get bottom => 'Κάτω μέρος';

  @override
  String get center => 'Κέντρο';

  @override
  String get solidColor => 'Στερεό χρώμα';

  @override
  String get picture => 'Εικόνα';

  @override
  String get chooseYourPicture => 'Επιλέξτε την εικόνα σας';

  @override
  String get light => 'Φως';

  @override
  String get dark => 'Σκοτάδι';

  @override
  String get themes => 'Θέματα';

  @override
  String get currentTheme => 'Τρέχον θέμα';

  @override
  String get saveTheme => 'Αποθήκευση θέματος';

  @override
  String get showAnalysisGraph => 'Εμφάνιση γραφήματος ανάλυσης';

  @override
  String get analysis => 'Ανάλυση';

  @override
  String get saveGame => 'Αποθήκευση παιχνιδιού';

  @override
  String get loadGame => 'Φόρτωσε το παιχνίδι';

  @override
  String get setupPosition => 'Ορισμός διάταξης';

  @override
  String get showLegalMoves => 'Εμφάνιση νομικών κινήσεων';

  @override
  String get showLastMove => 'Εμφάνιση τελευταίας κίνησης';

  @override
  String get showArrows => 'Εμφάνιση βελών';

  @override
  String get pieces => 'Κομμάτια';

  @override
  String get showAnalysis => 'Εμφάνιση ανάλυσης';

  @override
  String get threads => 'Νήματα';

  @override
  String get getInvolved => 'Εμπλέκομαι';

  @override
  String get helpImproveTranslate => 'Βοηθήστε στη βελτίωση της μετάφρασης';

  @override
  String get tutorial => 'Φροντιστήριο';

  @override
  String get classicMill => 'Κλασικό μύλο';

  @override
  String get mixedMill => 'Μικτός Μύλος';

  @override
  String get ceylonMill => 'Μύλος Κεϋλάνης';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Ο μύλος μπορεί να σπάσει και να ξανακατασκευαστεί';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Εάν ένας παίκτης σπάσει ένα μύλο για να δημιουργήσει ένα νέο μύλο αμέσως, ένας τέτοιος παίκτης μπορεί να μετακινήσει ένα τέτοιο κομμάτι πίσω στην αρχική διασταύρωση στην επόμενη κίνηση του, αν κάνει ένα νέο μύλο.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Το παιχνίδι τραβιέται αν ένας παίκτης έχει τρία κομμάτια και μετά από δέκα κινήσεις κανένας παίκτης δεν αφαιρεί τα κομμάτια του αντιπάλου';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Όταν ένας παίκτης είναι κάτω από τρία κομμάτια και κανένας παίκτης δεν μπορεί να αφαιρέσει ένα κομμάτι ενός αντιπάλου μέσα σε δέκα κινήσεις, το παιχνίδι είναι ισοπαλία.';

  @override
  String get close => 'Κλείσε';

  @override
  String get whitePiece => 'Λευκό κομμάτι';

  @override
  String get blackPiece => 'Μαύρο κομμάτι';

  @override
  String get emptyPoint => 'Κενό σημείο';

  @override
  String get noPoint => 'Κανένα σημείο';

  @override
  String get placingPhase => 'Φάση τοποθέτησης';

  @override
  String get movingPhase => 'Μετακινούμενη φάση';

  @override
  String get flyingPhase => 'Φάση πτήσης';

  @override
  String sideToMove(Object player) {
    return 'Πλευρά για κίνηση: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Τελευταία κίνηση: $move';
  }

  @override
  String get selected => 'Επιλεγμένο';

  @override
  String get accessibility => 'Προσιτότητα';

  @override
  String get screenReaderSupport => 'Υποστήριξη αναγνώστη οθόνης';

  @override
  String get isDraw => 'Είναι Κλήρωση!';

  @override
  String get draw => 'Σχεδιάζω';

  @override
  String get pieceHighlightColor => 'Χρώμα φωτισμού κομμάτι';

  @override
  String get algorithm => 'Αλγόριθμος';

  @override
  String get endgameNMoveRule => 'Κανόνας N-Move Endgame';

  @override
  String get endgameNMoveRule_Detail =>
      'Εάν ένας παίκτης έχει μόνο τρία κομμάτια και κανένας παίκτης δεν αφαιρέσει ένα κομμάτι μέσα σε μια συγκεκριμένη κίνηση, το παιχνίδι κληρώνεται.';

  @override
  String get drawReasonEndgameRule50 =>
      'Ο κάθε παίκτης έχει μόνο τρία κομμάτια και κανένας παίκτης δεν αφαιρεί ένα κομμάτι μέσα σε μια συγκεκριμένη κίνηση.';

  @override
  String get threefoldRepetitionRule => 'Τριπλός κανόνας επανάληψης';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Το παιχνίδι κληρώνεται εάν μια θέση εμφανιστεί για τρίτη φορά.';

  @override
  String get continueToMakeMove => 'Μύλος! Συνεχίστε να κάνετε μια κίνηση.';

  @override
  String get pointStyle => 'Στυλ σημείου';

  @override
  String get pointWidth => 'Πλάτος σημείου';

  @override
  String get solid => 'Στερεός';

  @override
  String get hollow => 'Κοίλος';

  @override
  String get languageName => 'Ελληνικά';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count κινήσεις',
      one: '$count κίνηση',
      zero: 'Καμία κίνηση',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Η φόρτωση απέτυχε.';

  @override
  String get filename => 'Ονομα αρχείου';

  @override
  String get browse => 'Ξεφυλλίζω…';

  @override
  String get gameFiles => 'Αρχεία παιχνιδιών';

  @override
  String get gameSavedTo => 'Το παιχνίδι αποθηκεύεται στο';

  @override
  String get empty => 'Αδειάζω';

  @override
  String get noMove => 'Καμία κίνηση.';

  @override
  String get restoredPosition => 'Αποκαταστάθηκε η αρχική θέση.';

  @override
  String get clean => 'ΚΑΘΑΡΗ';

  @override
  String get cleanedUp => 'Καθαρισμένο.';

  @override
  String get remove => 'Αφαιρώ';

  @override
  String get noPiecesCanBeRemoved => 'Κανένα κομμάτι δεν μπορεί να αφαιρεθεί.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count κομμάτια',
      one: '$count piece',
      zero: 'Piece',
    );
    return '$_temp0 πρέπει να αφαιρεθεί.';
  }

  @override
  String placedCount(int count) {
    return 'Τοποθ. ($count)';
  }

  @override
  String get placedPieceCount =>
      'Καταμέτρηση τοποθετημένων κομματιών στη φάση τοποθέτησης.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'Ο τρέχων παίκτης έχει τοποθετήσει κομμάτια $count.';
  }

  @override
  String get notPlacingPhase => 'Δεν τοποθετώ φάση, δεν μπορώ να την αλλάξω.';

  @override
  String get paste => 'Επικόλληση';

  @override
  String get pasteDone => 'Η πάστα έχει γίνει.';

  @override
  String get cannotPaste => 'Δεν είναι δυνατή η επικόλληση.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Εμφάνιση τεμαχίων που δεν έχουν τοποθετηθεί και αφαιρεθεί';

  @override
  String get fullScreen => 'ΠΛΗΡΗΣ ΟΘΟΝΗ';

  @override
  String get reopenToTakeEffect =>
      'Βγείτε και ανοίξτε ξανά την εφαρμογή για να τεθούν σε ισχύ οι ρυθμίσεις.';

  @override
  String get forest => 'Δάσος';

  @override
  String get desktopImage => 'Εικόνα επιφάνειας εργασίας';

  @override
  String get invalidPosition => 'Μη έγκυρη θέση.';

  @override
  String get shareGIF => 'Κοινή χρήση GIF';

  @override
  String get pixelRatio => 'Αναλογία εικονοστοιχείων';

  @override
  String get duration => 'Διάρκεια';

  @override
  String get gameScreenRecorder => 'Εγγραφή οθόνης παιχνιδιού';

  @override
  String get previous => 'Προηγούμενος';

  @override
  String get next => 'Επόμενο';

  @override
  String get skip => 'Παραλείπω';

  @override
  String get gotIt => 'Το έπιασα';

  @override
  String get youCanModifyRules =>
      'Μπορείτε να τροποποιήσετε τους κανόνες του παιχνιδιού στις ρυθμίσεις κανόνων.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Μπορείτε να χρησιμοποιήσετε τον τροχό του ποντικιού για να αλλάξετε την τιμή στον επιλογέα.';

  @override
  String get noTimeLimitForThinking =>
      'Ο καθορισμός του χρόνου σκέψης της AI σε 0 σημαίνει ότι δεν υπάρχει χρονικό όριο για σκέψη.';

  @override
  String get whatIsMtdf =>
      'Το MTD(f) είναι μια τροποποιημένη μορφή του αλγορίθμου αναζήτησης άλφα-βήτα που στοχεύει στη βελτίωση της αποτελεσματικότητας επαναχρησιμοποιώντας ενδιάμεσα αποτελέσματα αναζήτησης και χρησιμοποιώντας μια καλή αρχική εικασία για να περιορίσει τον χώρο αναζήτησης.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Λάβετε υπόψη ότι η προσαρμογή του χρόνου σκέψης AI μπορεί να μην είναι απολύτως ακριβής. Ο πραγματικός χρόνος σκέψης μπορεί να είναι μικρότερος όταν το επίπεδο δυσκολίας έχει ρυθμιστεί σε χαμηλότερη τιμή και μπορεί να είναι μεγαλύτερος όταν η τεχνητή νοημοσύνη είναι στη μέση της σκέψης όταν ο χρόνος τελειώσει.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Εάν ορίσετε το επίπεδο δυσκολίας υψηλό αλλά δεν αυξήσετε τον χρόνο σκέψης AI, το πραγματικό επίπεδο δυσκολίας μπορεί να περιοριστεί σε χαμηλότερη τιμή λόγω του περιορισμού χρόνου σκέψης. Η πραγματική τιμή μπορεί να διαφέρει ανάλογα με την απόδοση του μηχανήματος.';

  @override
  String get whatIsPvs =>
      'Το PVS (Principal Variation Search) είναι ένας αλγόριθμος αναζήτησης για την εύρεση της καλύτερης κίνησης σε μια δεδομένη θέση. Είναι μια βελτίωση του αλγορίθμου άλφα-βήτα και χρησιμοποιεί μηδενικές ή μηδενικές αναζητήσεις παραθύρων για να επιβεβαιώσει ότι μια κίνηση είναι χειρότερη ή όχι χειρότερη από μια ήδη ασφαλή βαθμολογία από την κύρια παραλλαγή. Το PVS εστιάζει στις πιο υποσχόμενες κινήσεις και αποφεύγει τις περιττές αναζητήσεις μη βέλτιστων υποκαταστημάτων, γεγονός που συμβάλλει στη βελτίωση της αποτελεσματικότητας της αναζήτησης.';

  @override
  String get whatIsAlphaBeta =>
      'Ο αλγόριθμος άλφα-βήτα είναι ένας αλγόριθμος αναζήτησης για την εύρεση της καλύτερης κίνησης. Χρησιμοποιεί την αρχή minimax και δύο τιμές, άλφα και βήτα, για να κλαδέψει το δέντρο αναζήτησης και να αυξήσει την απόδοση. Το Alpha αντιπροσωπεύει την ελάχιστη βαθμολογία που ο υπολογιστής είναι σίγουρος ότι μπορεί να πάρει, ενώ η βήτα αντιπροσωπεύει τη μέγιστη βαθμολογία που μπορεί να πάρει ο αντίπαλός του. Ο αλγόριθμος βοηθά τον υπολογιστή να λάβει έξυπνες, αποτελεσματικές αποφάσεις σε ένα παιχνίδι.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Σύμφωνα με την ανθρώπινη εμπειρία, αν προσπαθήσεις να κερδίσεις, θα χάσεις. Αντίθετα, βάλτε στόχο την ισοπαλία και αποφύγετε να χάσετε το παιχνίδι. Παρατηρήστε τον αντίπαλό σας και παρασύρετέ τον απαλά σε μια θέση όπου μπορεί να κάνει λάθη. Όταν δείχνουν αδυναμία, αρπάξτε την ευκαιρία και πιέστε απαλά για τη νίκη. Με αυτόν τον τρόπο, μπορείτε να κερδίσετε το παιχνίδι.';

  @override
  String get firstMoveDetail =>
      'Σε αυτό το παιχνίδι, είναι πιο εύκολο για τον δεύτερο παίκτη να κερδίσει σε σύγκριση με τον πρώτο παίκτη.';

  @override
  String get passiveDetail =>
      'Η ενεργοποίηση της Παθητικής επιλογής θα κάνει το AI να χαλαρώσει όταν έχει πλεονέκτημα στη θέση, αντί να προσπαθεί επιθετικά να κερδίσει όσο το δυνατόν γρηγορότερα.';

  @override
  String get moveRandomlyDetail =>
      'Η ενεργοποίηση αυτής της επιλογής αυξάνει την τυχαιότητα και τη διασκέδαση του παιχνιδιού, ενώ η απενεργοποίησή της μπορεί να βοηθήσει στη μελέτη τρόπων για να νικήσετε την τεχνητή νοημοσύνη.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Εάν η τεχνητή νοημοσύνη εξετάσει την κινητικότητα των κομματιών της, δεν θα στοχεύει μόνο να συλλάβει τα κομμάτια του αντιπάλου όσο το δυνατόν γρηγορότερα, αλλά θα εξετάσει επίσης το ενδεχόμενο να μπλοκάρει τις κινήσεις του αντιπάλου και να τον εμποδίσει να κάνει το ίδιο.';

  @override
  String get whenBoardIsFull => 'Όταν ο πίνακας είναι γεμάτος';

  @override
  String get whenBoardIsFull_Detail =>
      'Στο τέλος της φάσης τοποθέτησης, πριν ξεκινήσει η φάση μετακίνησης, ακολουθεί η δράση εάν ο πίνακας είναι γεμάτος κομμάτια.';

  @override
  String get sideToMoveRemovePiece =>
      'Ο παίκτης που κινείται πρώτος στη φάση κίνησης αφαιρεί ένα από τα κομμάτια του αντιπάλου.';

  @override
  String get agreeToDraw => 'Και οι δύο πλευρές συμφωνούν στην ισοπαλία.';

  @override
  String get takeOpponentsPiece =>
      'Πάρτε ένα από τα κομμάτια του αντιπάλου σας.';

  @override
  String get firstPlayerLose => 'Ο πρώτος παίκτης χάνει το παιχνίδι.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Ο πρώτος και ο δεύτερος παίκτης αφαιρούν ένα από τα κομμάτια του αντιπάλου.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Ο δεύτερος και ο πρώτος παίκτης αφαιρούν ένα από τα κομμάτια του αντιπάλου.';

  @override
  String get enteredFlyingPhase =>
      'Τώρα που μπήκε στη φάση πτήσης, τα πιόνια του αντιπάλου μπορούν να πηδήξουν σε οποιοδήποτε κενό σημείο του ταμπλό. Μπορείτε να απενεργοποιήσετε τον κανόνα πτήσης στις \"Ρυθμίσεις κανόνων\".';

  @override
  String get whenStalemate => 'Όταν βρίσκεται σε αδιέξοδο';

  @override
  String get whenStalemate_Detail =>
      'Ποια ενέργεια ακολουθεί όταν κανένα κομμάτι δεν μπορεί να μετακινηθεί;';

  @override
  String get endWithStalemateLoss => 'Τέλος με αδιέξοδο απώλεια.';

  @override
  String get changeSideToMove => 'Αλλάξτε την πλευρά για να μετακινηθείτε.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Αφαιρέστε ένα από τα κομμάτια του αντιπάλου και κάντε την επόμενη κίνηση.';

  @override
  String get endWithStalemateDraw => 'Τέλος με ισοπαλία.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Αφαιρέστε ένα από τα κομμάτια του αντιπάλου και αλλάξτε την πλευρά για να μετακινηθείτε.';

  @override
  String get aiResponseDelayTime => 'Χρόνος καθυστέρησης απόκρισης AI';

  @override
  String get aiIsDelaying =>
      'Η τεχνητή νοημοσύνη βρίσκεται επί του παρόντος σε φάση καθυστερημένης απόκρισης. Περιμένετε λίγο πριν συνεχίσετε.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Δεν μπορείτε να αφαιρέσετε ένα μη γειτονικό κομμάτι.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'Σε περίπτωση αδιεξόδου, τα κομμάτια του αντιπάλου που βρίσκονται δίπλα στο δικό σας μπορούν να αφαιρεθούν, ανεξάρτητα από τον σχηματισμό μύλου.';

  @override
  String get whatIsMcts =>
      'Το MCTS είναι ένας φιλικός προς τους αρχάριους αλγόριθμος που λαμβάνει αποφάσεις εξερευνώντας και αξιολογώντας διαφορετικές κινήσεις μέσω προσομοιώσεων.';

  @override
  String get goldenJade => 'Golden Jade';

  @override
  String get forestWood => 'Δασικό Ξύλο';

  @override
  String get darkMystery => 'Σκοτεινό Μυστήριο';

  @override
  String get midnightBlue => 'Midnight Blue';

  @override
  String get greenForest => 'Πράσινο δάσος';

  @override
  String get greenMeadow => 'Πράσινο Λιβάδι';

  @override
  String get stonyPath => 'Stony Path';

  @override
  String get pastelPink => 'Παστέλ Ροζ';

  @override
  String get turquoiseSea => 'Τυρκουάζ Θάλασσα';

  @override
  String get violetDream => 'Βιολετί Όνειρο';

  @override
  String get mintChocolate => 'Σοκολάτα μέντας';

  @override
  String get skyBlue => 'Μπλε του ουρανού';

  @override
  String get playfulGarden => 'Παιχνιδιάρικο κήπο';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Ο αλγόριθμος Ανάδρομης Ανάλυσης χρησιμοποιεί ανάδρομη ανάλυση πολλαπλών τιμών για τη δημιουργία μιας βάσης δεδομένων τέλους παιχνιδιού από διαφορετικές θέσεις έναρξης και, στη συνέχεια, εφαρμόζει αυτήν τη βάση δεδομένων για τη βελτιστοποίηση του παιχνιδιού. Αυτή η προσέγγιση εμπίπτει στην κατηγορία των Ultra-Strong λύσεων.';

  @override
  String get viewAlgorithmGuide =>
      'Θα θέλατε να δείτε τον οδηγό χρήστη για αυτόν τον αλγόριθμο;';

  @override
  String get showPositionalAdvantageIndicator =>
      'Εμφάνιση δείκτη πλεονεκτήματος θέσης';

  @override
  String get usePerfectDatabase => 'Χρησιμοποιήστε τέλεια βάση δεδομένων';

  @override
  String get perfectDatabaseDescription =>
      'Ενεργοποιήστε αυτήν την επιλογή για να χρησιμοποιήσετε μια άψογη βάση δεδομένων παιχνιδιών που δημιουργείται μέσω αλγορίθμων αιχμής. Αυτή η δυνατότητα ενσωματώνει στρατηγικές ανοίγματος και τέλους παιχνιδιού για να προτείνει βέλτιστες κινήσεις. Αυτή είναι η προτιμώμενη επιλογή για παίκτες που αναζητούν το υψηλότερο επίπεδο ακρίβειας στο παιχνίδι. Δημιουργημένη μέσω σχολαστικών υπολογιστικών τεχνικών, η βάση δεδομένων έχει σχεδιαστεί για να προσφέρει σχεδόν τέλειες λύσεις παιχνιδιών.\n\nΣημείωση: Εάν το AI αποτύχει να αποκτήσει πρόσβαση στη βάση δεδομένων, θα στραφεί σε συμβατικούς αλγόριθμους για αποφάσεις παιχνιδιού. Όταν η βάση δεδομένων είναι διαθέσιμη, το «Επίπεδο δυσκολίας» γίνεται ουσιαστικά ασυναγώνιστο και ο «χρόνος σκέψης AI» μειώνεται δραστικά. Πολλές ρυθμίσεις εντός των επιλογών «Προϊόν παιχνιδιού AI» θα παρακαμφθούν, καθώς τα αποτελέσματα της βάσης δεδομένων έχουν την υψηλότερη προτεραιότητα.\n\nΓια οδηγίες σχετικά με το πώς να αξιοποιήσετε στο έπακρο αυτήν την άψογη βάση δεδομένων, κάντε κλικ εδώ.';

  @override
  String get backgroundImage => 'Εικόνα φόντου';

  @override
  String get whatIsRandom =>
      'Όταν η επιλογή «Χρήση τέλειας βάσης δεδομένων» δεν είναι ενεργοποιημένη, η ρύθμιση «Τυχαία» κάνει το AI να μετακινεί τυχαία κομμάτια χωρίς τη χρήση αλγορίθμων για την επιλογή μετακίνησης. Αυτό συνήθως οδηγεί σε σημαντικά πιο αδύναμο παιχνίδι. Αντίθετα, όταν είναι ενεργοποιημένη η «Χρήση τέλειας βάσης δεδομένων», η τεχνητή νοημοσύνη βασίζεται αποκλειστικά στην «Τέλεια βάση δεδομένων» για τη λήψη αποφάσεων, αντί να τη συνδυάζει με παραδοσιακούς αλγόριθμους τεχνητής νοημοσύνης. Σε αυτήν τη λειτουργία, οι κινήσεις του AI βασίζονται εξ ολοκλήρου στο περιεχόμενο της βάσης δεδομένων, αποφεύγοντας την εξάρτηση από υπολογισμούς σε πραγματικό χρόνο ή αλγόριθμους αναζήτησης.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Αφαιρέστε τα κομμάτια του αντιπάλου από το χέρι τους. Στη συνέχεια, είναι η σειρά του αντιπάλου να τοποθετήσει.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Κατά το σχηματισμό μύλων κατά τη φάση τοποθέτησης';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Αφαιρέστε το(α) κομμάτι(α) του αντιπάλου από το ταμπλό.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Αφαιρέστε τα κομμάτια του αντιπάλου από το ταμπλό. Στη συνέχεια, είναι η σειρά του αντιπάλου να τοποθετήσει.';

  @override
  String get opponentRemovesOwnPiece =>
      'Ο αντίπαλος αφαιρεί τα δικά του κομμάτια από το ταμπλό.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Αντί να αναλάβετε εσείς δράση, ο αντίπαλος επιλέγει και αφαιρεί τα δικά του κομμάτια από το ταμπλό, κάνοντας στην ουσία μια ενέργεια που τον βλάπτει.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Αφαιρέστε τα κομμάτια του αντιπάλου από το χέρι τους. Στη συνέχεια, είναι η σειρά σας να κινηθείτε.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Αφαιρέστε κομμάτια από το χέρι του αντιπάλου. Αν, σύμφωνα με τη ρύθμιση Πολλαπλής αφαίρεσης, πρόκειται να αφαιρεθούν πολλά κομμάτια και ο αντίπαλος δεν έχει άλλα κομμάτια στο χέρι, συνεχίστε να αφαιρείτε τα κομμάτια του αντιπάλου από το ταμπλό. Στη συνέχεια, είναι η σειρά σας να κινηθείτε. Αν συνεχίσετε να σχηματίζετε μύλους, μπορείτε να συνεχίσετε να αφαιρείτε τα κομμάτια του αντιπάλου.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Αφαιρέστε κομμάτια από το χέρι του αντιπάλου. Αν, σύμφωνα με τη ρύθμιση Πολλαπλής αφαίρεσης, πρόκειται να αφαιρεθούν πολλά κομμάτια και ο αντίπαλος δεν έχει άλλα κομμάτια στο χέρι, συνεχίστε να αφαιρείτε τα κομμάτια του αντιπάλου από το ταμπλό. Στη συνέχεια, είναι η σειρά του αντιπάλου να κινηθεί.';

  @override
  String get markAndDelayRemovingPieces =>
      'Σημαδέψτε και καθυστερήστε την αφαίρεση των κομματιών.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Κατά τη διάρκεια της φάσης τοποθέτησης, τα κομμάτια που πρόκειται να αφαιρεθούν επισημαίνονται και κανένας από τους δύο παίκτες δεν μπορεί να τοποθετήσει νέα κομμάτια σε αυτά τα σημεία. Κατά την είσοδο στη φάση κίνησης, αυτά τα σημειωμένα κομμάτια αφαιρούνται εντελώς και στη συνέχεια οι παίκτες μπορούν να μετακινήσουν τα κομμάτια τους σε αυτά τα πλέον κενά σημεία.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Οι ενέργειες που μπορούν να ληφθούν κατά τη διάρκεια της δημιουργίας μύλων στη φάση τοποθέτησης.';

  @override
  String get marked => 'Σημειωμένο';

  @override
  String get menu => 'Μενού';

  @override
  String get monochrome => 'Μονόχρωμο';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Μπορείτε να ενεργοποιήσετε την υποστήριξη αναγνώστη οθόνης στις ρυθμίσεις προσβασιμότητας στις Γενικές Ρυθμίσεις.';

  @override
  String get showNumbersOnPieces => 'Εμφάνιση αριθμών στα κομμάτια';

  @override
  String get saveImage => 'Αποθήκευση εικόνας';

  @override
  String get isAnalysisToolbarShown => 'Εμφάνιση γραμμής εργαλείων ανάλυσης';

  @override
  String get analysisToolbarBackgroundColor =>
      'Χρώμα φόντου γραμμής εργαλείων ανάλυσης';

  @override
  String get analysisToolbarIconColor =>
      'Χρώμα εικονιδίου γραμμής εργαλείων ανάλυσης';

  @override
  String get transformed => 'Μετασχηματισμένο.';

  @override
  String get cannotTransform => 'Αδύνατον να μετασχηματιστεί.';

  @override
  String get rotate => 'Περιστροφή';

  @override
  String get horizontalFlip => 'Ορ. Αν.';

  @override
  String get verticalFlip => 'Κατ. Αν.';

  @override
  String get innerOuterFlip => 'Εσ./Εξ. Αν.';

  @override
  String get transparentCanvas => 'Διαφανής Καμβάς';

  @override
  String get restrictRepeatedMillsFormation =>
      'Περιορισμός Επαναλαμβανόμενου Σχηματισμού Μύλων';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Ένα κομμάτι που μετακινήθηκε από ένα μύλο σε έναν άλλο δεν μπορεί να επιστρέψει αμέσως στο αρχικό σημείο στον επόμενο γύρο για να σχηματίσει ξανά μύλο. Απαιτείται πρώτα μια διαφορετική κίνηση.';

  @override
  String get oneTimeUseMill => 'Μύλος μιας χρήσης';

  @override
  String get oneTimeUseMill_Detail =>
      'Κάθε μύλος μπορεί να αφαιρέσει ένα κομμάτι του αντιπάλου μόνο μία φορά. Μπορείτε να το ξαναδημιουργήσετε, αλλά δεν μπορεί να χρησιμοποιηθεί για επιπλέον αφαιρέσεις.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Οι τρέχοντες κανόνες που έχετε ορίσει δεν έχουν αντίστοιχη τέλεια βάση δεδομένων. Για περισσότερες πληροφορίες σχετικά με την τέλεια βάση δεδομένων, κάντε κλικ εδώ.';

  @override
  String get focusOnBlockingPaths => 'Εστιάστε στην αποκλεισμό διαδρομών';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Δώστε προτεραιότητα στην παρεμπόδιση της κίνησης του αντιπάλου παρά στον σχηματισμό μύλων. Αντί να εστιάζει στην αφαίρεση κομματιών ολοκληρώνοντας μύλους, η AI στοχεύει να παγιδεύσει τον αντίπαλο, καθιστώντας τον ανίκανο να κινηθεί και εξασφαλίζοντας τη νίκη μέσω φθοράς παρά μέσω επιθετικού παιχνιδιού. Αυτή η στρατηγική δεν μπλοκάρει ενεργά τους μύλους του αντιπάλου.';

  @override
  String get pieceImage => 'Εικόνα πιόνι';

  @override
  String get importColorSettings => 'Εισαγωγή ρυθμίσεων χρώματος';

  @override
  String get exportColorSettings => 'Εξαγωγή ρυθμίσεων χρώματος';

  @override
  String get import => 'Εισαγωγή';

  @override
  String get export => 'Εξαγωγή';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Αντιγράψτε πρώτα τις ρυθμίσεις μορφής JSON στο πρόχειρο.';

  @override
  String get copiedToClipboard => 'Αντιγράφηκε στο πρόχειρο.';

  @override
  String get imported => 'Εισήχθη.';

  @override
  String get boardImage => 'Εικόνα ταμπλό';

  @override
  String get autumnLeaves => 'Φθινοπωρινά φύλλα';

  @override
  String get legendaryLand => 'Θρυλική γη';

  @override
  String get vignetteEffect => 'Εφέ βινιέτας';

  @override
  String get promptMakeToolbarTransparent =>
      'Θα θέλατε να κάνετε τη γραμμή εργαλείων εντελώς διαφανή όταν ορίζεται μια εικόνα φόντου πίνακα;';

  @override
  String get vibration => 'Ενεργοποίηση δόνησης στο παιχνίδι';

  @override
  String get soundTheme => 'Θέμα ήχου';

  @override
  String get ball => 'Μπάλα';

  @override
  String get liquid => 'Υγρό';

  @override
  String get wood => 'Ξύλο';

  @override
  String get placeEffectAnimation => 'Εφέ κίνησης τοποθέτησης πιόνιου';

  @override
  String get removeEffectAnimation => 'Εφέ κίνησης αφαίρεσης πιόνιου';

  @override
  String get isToolbarAtBottom =>
      'Εμφάνιση της γραμμής εργαλείων στο κάτω μέρος';

  @override
  String get boardCornerRadius => 'Ακτίνα γωνίας ταμπλό';

  @override
  String get useOpeningBook => 'Χρησιμοποιήστε βιβλίο ανοίγματος';

  @override
  String get currentRule => 'Τρέχον';

  @override
  String get nineMensMorris => 'Μύλος';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Ντους';

  @override
  String get chamGonu => 'Τσαμγκόνου';

  @override
  String get zhiQi => 'Τζιτσί';

  @override
  String get chengSanQi => 'Τσενγκσάντσι';

  @override
  String get mulMulan => 'Μουλ-Μουλάν';

  @override
  String get nerenchi => 'Νερέντσι';

  @override
  String get ruleSet => 'Σύνολο κανόνων';

  @override
  String get laskerMorris => 'Λάσκερ Μόρις';

  @override
  String get oneTimeMill => 'Μύλος μιας χρήσης';

  @override
  String get daSanQi => 'Ντασάντσι';

  @override
  String get useOpeningBook_Detail =>
      'Επιτρέψτε στην AI να χρησιμοποιεί κινήσεις ανοίγματος που συνηθίζονται από επαγγελματίες ανθρώπινους παίκτες κατά το πρώιμο στάδιο του παιχνιδιού. Σημείωση: Αυτή η δυνατότητα είναι διαθέσιμη επί του παρόντος μόνο για συγκεκριμένα σετ κανόνων.';

  @override
  String get showAdvantageGraph => 'Εμφάνιση γραφήματος πλεονεκτήματος';

  @override
  String get advantageGraphHint =>
      'Το διάγραμμα πλεονεκτήματος θα σχεδιαστεί μόνο μετά την κίνηση της ΤΝ. Δεν θα σχεδιαστεί όταν ο ανθρώπινος παίκτης κάνει μια κίνηση.';

  @override
  String get removalBasedOnMillCounts =>
      'Απενεργοποιήστε την αφαίρεση έως ότου τοποθετηθούν όλα τα πιόνια. Οι παίκτες αφαιρούν πιόνια με βάση τον αριθμό των μύλων που δημιουργούνται.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Απενεργοποιήστε την αφαίρεση έως ότου τοποθετηθούν όλα τα πιόνια. Οι παίκτες αφαιρούν πιόνια με βάση τον αριθμό των μύλων: αν είναι ίσος, και οι δύο αφαιρούν τον ίδιο αριθμό· αν κάποιος έχει περισσότερους, αφαιρεί ένα επιπλέον πιόνι, διατηρώντας τη διαφορά σε ένα πιόνι. Αν μόνο ένας παίκτης σχηματίσει μύλο, αφαιρεί δύο πιόνια, ενώ ο άλλος αφαιρεί ένα. Αν κανείς δεν σχηματίσει μύλο, και οι δύο αφαιρούν από ένα πιόνι.';

  @override
  String get elfilja => 'Ελ Φίλτζα';

  @override
  String get tipSelectOwnPiece => 'Επέλεξε ένα από τα πιόνια σου.';

  @override
  String get notYourTurn => 'Δεν είναι η σειρά σας.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Χρώμα φόντου της εργαλειοθήκης σχολίων';

  @override
  String get annotationToolbarIconColor =>
      'Χρώμα εικονιδίου της εργαλειοθήκης σχολίων';

  @override
  String get isAnnotationToolbarShown => 'Εμφάνιση εργαλειοθήκης σχολίων';

  @override
  String get enterAnnotationMode => 'Εισαγωγή στη λειτουργία σχολιασμού';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Είστε σίγουρος ότι θέλετε να διαγράψετε όλους τους σχολιασμούς;';

  @override
  String get llmPromptCopiedToClipboard =>
      'Το LLM prompt αντιγράφηκε στο πρόχειρο.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Η σύνδεση απορρίφθηκε, ο διακομιστής μπορεί να είναι εκτός λειτουργίας.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Η εύρεση ήταν επιτυχής, αναμονή σύνδεσης...';

  @override
  String get noLanConnection => 'Δεν υπάρχει σύνδεση LAN';

  @override
  String get takeScreenshot => 'Λήψη στιγμιότυπου οθόνης';

  @override
  String get disconnectedFromOpponent => 'Αποσυνδεθήκατε από τον αντίπαλο.';

  @override
  String get takeBackRequest => 'Αίτημα αναίρεσης';

  @override
  String get nothingToShow => 'Δεν υπάρχει τίποτα για εμφάνιση.';

  @override
  String get stopHosting => 'Διακοπή φιλοξενίας';

  @override
  String get connectionResetByPeer =>
      'Η σύνδεση επαναφέρθηκε από τον αντίπαλο.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Η σύνδεση διακόπηκε λόγω λήξης χρονικού ορίου του heartbeat. Παρακαλώ επανασυνδεθείτε.';

  @override
  String get startHosting => 'Έναρξη φιλοξενίας';

  @override
  String get restartRequestRejected => 'Το αίτημα επανεκκίνησης απορρίφθηκε.';

  @override
  String get notConnectedToLanOpponent =>
      'Δεν υπάρχει σύνδεση με αντίπαλο στο LAN.';

  @override
  String get llmPrompt => 'LLM prompt';

  @override
  String get gameRestarted => 'Το παιχνίδι επανεκκινήθηκε.';

  @override
  String get takeBackRejected => 'Η αναίρεση απορρίφθηκε.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Είστε σίγουρος ότι θέλετε να παραιτηθείτε από αυτό το παιχνίδι;';

  @override
  String get opponentResignedYouWin => 'Ο αντίπαλος παραιτήθηκε. Κερδίζετε!';

  @override
  String get clearAllAnnotations => 'Διαγραφή όλων των σχολιασμών';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Συνδεδεμένο, αναμονή για κίνηση του αντιπάλου...';

  @override
  String get networkStatusDisconnected => 'Κατάσταση δικτύου: Αποσυνδεδεμένο';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Το αίτημα αναίρεσης στάλθηκε στον αντίπαλο.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'Ο αντίπαλος μπορεί να έχει αποχωρήσει από το παιχνίδι';

  @override
  String get connectedToHostSuccessfully =>
      'Συνδεθήκατε επιτυχώς με τον διακομιστή.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Η σύνδεση διακόπηκε: λήξη χρονικού ορίου heartbeat';

  @override
  String get noHostDiscovered => 'Δεν εντοπίστηκε διακομιστής.';

  @override
  String get confirmResignation => 'Επιβεβαίωση παραίτησης';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Ξεκίνησε η φιλοξενία του παιχνιδιού, αναμονή για παίκτες να συνδεθούν...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Η σύνδεση έληξε, η σύνδεση δικτύου είναι ασταθής.';

  @override
  String get noLlmPromptAvailable => 'Δεν υπάρχει διαθέσιμο LLM prompt.';

  @override
  String get youResignedGameOver => 'Παραιτήκατε. Το παιχνίδι τελείωσε.';

  @override
  String get serverIp => 'IP διακομιστή';

  @override
  String get confirmClear => 'Επιβεβαίωση διαγραφής';

  @override
  String get opponentSTurn => 'Η σειρά του αντιπάλου.';

  @override
  String get waitingAClientConnection => 'Αναμονή σύνδεσης πελάτη...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Το αίτημα αναίρεσης απορρίφθηκε ή απέτυχε.';

  @override
  String get addText => 'Προσθήκη κειμένου';

  @override
  String get exitAnnotationMode => 'Έξοδος από τη λειτουργία σχολιασμού';

  @override
  String get typeYourAnnotation => 'Πληκτρολογήστε τον σχολιασμό σας';

  @override
  String get attemptingToReconnect => 'Προσπάθεια επανασύνδεσης...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Το αίτημα επανεκκίνησης στάλθηκε. Αναμονή για την απάντηση του αντιπάλου...';

  @override
  String get serverIsStopped => 'Ο διακομιστής είναι σταματημένος.';

  @override
  String get restartRequest => 'Αίτημα επανεκκίνησης';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Δεν μπορείτε να ζητήσετε αναίρεση όταν δεν είναι η σειρά σας.';

  @override
  String get takeBackAccepted => 'Η αναίρεση έγινε αποδεκτή.';

  @override
  String get localNetworkSettings => 'Ρυθμίσεις τοπικού δικτύου';

  @override
  String get reconnectedSuccessfully => 'Επανασυνδεθήκατε επιτυχώς!';

  @override
  String get failedToSaveImageToGallery =>
      'Αποτυχία αποθήκευσης εικόνας στη γκαλερί.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Ο αντίπαλος ζήτησε να επανεκκινήσει το παιχνίδι. Αποδέχεστε;';

  @override
  String get yourTurn => 'Η σειρά σας.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Αποτυχία επανασύνδεσης, παρακαλώ επανεκκινήστε το παιχνίδι.';

  @override
  String get host => 'Διακομιστής';

  @override
  String get join => 'Σύνδεση';

  @override
  String get port => 'Θύρα';

  @override
  String get invalidIpAddress => 'Μη έγκυρη διεύθυνση IP.';

  @override
  String get invalidPort => 'Μη έγκυρη θύρα.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Σύνδεση: Προσπάθεια $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Αποτυχία σύνδεσης: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Αποτυχία έναρξης φιλοξενίας: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Βρέθηκε διακομιστής: $ip:$port';
  }

  @override
  String get stop => 'Διακοπή';

  @override
  String get discover => 'Αναζήτηση';

  @override
  String get connect => 'Σύνδεση';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Ο πελάτης συνδέθηκε: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Αναζήτηση: $seconds δευτερόλεπτα';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Επανασύνδεση ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Συνδεδεμένο';

  @override
  String get delete => 'Διαγραφή';

  @override
  String get ancientEgypt => 'Αρχαία Αίγυπτος';

  @override
  String get gothicIce => 'Γοτθικός Πάγος';

  @override
  String get riceField => 'Ρυζοχώραφο';

  @override
  String get chinesePorcelain => 'Κινεζική Πορσελάνη';

  @override
  String get desertDusk => 'Έρημος Σούρουπο';

  @override
  String get precisionCraft => 'Ακρίβεια Τέχνη';

  @override
  String get folkEmbroidery => 'Λαϊκή Κεντητική';

  @override
  String get carpathianHeritage => 'Καρπαθική Κληρονομιά';

  @override
  String get imperialGrandeur => 'Αυτοκρατορική Μεγαλοπρέπεια';

  @override
  String get bohemianCrystal => 'Βοημικό Κρύσταλλο';

  @override
  String get savannaSunrise => 'Σαβάνα Ανατολή';

  @override
  String get harmonyBalance => 'Αρμονία Ισορροπία';

  @override
  String get cinnamonSpice => 'Κανέλα Μπαχαρικό';

  @override
  String get anatolianMosaic => 'Ανατολικό Μωσαϊκό';

  @override
  String get carnivalSpirit => 'Καρναβαλικό Πνεύμα';

  @override
  String get custom => 'Έθιμο';

  @override
  String get spiceMarket => 'Αγορά Μπαχαρικών';

  @override
  String get swipeToRevealTheDrawer => 'Σαρώστε για να εμφανίσετε το συρτάρι';

  @override
  String get showGameInfoOnScreenshots =>
      'Εμφάνιση πληροφοριών παιχνιδιού στα στιγμιότυπα οθόνης';

  @override
  String get humanMoveTime => 'Χρονικό όριο ανθρώπινης κίνησης';

  @override
  String get noTimeLimitForHumanMoves =>
      'Δεν υπάρχει χρονικό όριο για τις ανθρώπινες κινήσεις';

  @override
  String get timeoutLoseWillBeApplied =>
      'Η απώλεια λόγω λήξης χρόνου θα εφαρμοστεί για τον ανθρώπινο παίκτη';

  @override
  String get identifyingBoard => 'Αναγνώριση πίνακα...';

  @override
  String get youCanEnterAnyModelName =>
      'Μπορείτε να εισάγετε οποιοδήποτε όνομα μοντέλου';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Η θέση του πίνακα εφαρμόστηκε. Το FEN αντιγράφηκε στο πρόχειρο.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Πρόταση: Δοκιμάστε να τραβήξετε μια πιο καθαρή εικόνα του πίνακα';

  @override
  String get llmPromptTemplate => 'Πρότυπο προτροπής LLM';

  @override
  String get noValidBoardDetected => 'Δεν εντοπίστηκε έγκυρος πίνακας';

  @override
  String get selectingImageFromAlbum => 'Επιλογή εικόνας από άλμπουμ...';

  @override
  String get configurePromptTemplate => 'Ρύθμιση προτύπου προτροπής';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Επεξεργασία προτύπου προτροπής για ανάλυση LLM';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Αποτυχία δημιουργίας FEN από τον αναγνωρισμένο πίνακα';

  @override
  String get outputInCurrentLanguage => 'Έξοδος στην τρέχουσα γλώσσα';

  @override
  String get commonBaseUrls => 'Κοινές Base URLs';

  @override
  String get viewCommonModels => 'Προβολή κοινών μοντέλων';

  @override
  String get recognitionParametersUpdated =>
      'Ενημερώθηκαν οι παράμετροι αναγνώρισης';

  @override
  String get whiteSMove => 'Κίνηση των λευκών';

  @override
  String get resetToDefaults => 'Επαναφορά στις προεπιλεγμένες ρυθμίσεις';

  @override
  String get photoShoot => 'Λήψη φωτογραφίας';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Αποτυχία εφαρμογής της αναγνωρισμένης θέσης του πίνακα';

  @override
  String get llmPromptContent => 'Περιεχόμενο προτροπής LLM';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'Το LLM δεν έχει ρυθμιστεί. Ελέγξτε τις ρυθμίσεις σας.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Ορισμός παρόχου, μοντέλου, API Key και Base URL';

  @override
  String get llmConfiguration => 'Ρύθμιση LLM';

  @override
  String get configureLlmProvider => 'Ρύθμιση παρόχου LLM';

  @override
  String get llmPromptTemplateHeader => 'Κεφαλίδα προτύπου προτροπής LLM';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Δεν αναγνωρίστηκαν κομμάτια στην εικόνα. Παρακαλώ δοκιμάστε ξανά.';

  @override
  String get recognizeBoardFromImage => 'Αναγνώριση πίνακα από εικόνα';

  @override
  String get viewTips => 'Προβολή συμβουλών';

  @override
  String get applyToBoard => 'Εφαρμογή στον πίνακα';

  @override
  String get adjustBoardArea => 'Ρύθμιση περιοχής πίνακα';

  @override
  String get viewCommonUrls => 'Προβολή κοινών URLs';

  @override
  String get colorAnalysisFailed => 'Αποτυχία ανάλυσης χρώματος!';

  @override
  String get analyzingGameBoardImage => 'Ανάλυση εικόνας πίνακα παιχνιδιού...';

  @override
  String get selectFromAlbum => 'Επιλογή από άλμπουμ';

  @override
  String get noBoardPointDetected => 'Δεν εντοπίστηκε κανένα σημείο πίνακα!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Εάν παραμείνει κενό, θα χρησιμοποιηθεί το προεπιλεγμένο πρότυπο';

  @override
  String get llmConfig => 'Ρύθμιση LLM';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Είστε βέβαιοι ότι θέλετε να επαναφέρετε τα πρότυπα προτροπής στις προεπιλεγμένες τιμές;';

  @override
  String get llmPromptTemplateFooter => 'Υποσέλιδο προτύπου προτροπής LLM';

  @override
  String get loadingResponse => 'Φόρτωση απάντησης...';

  @override
  String get applyThisResultToBoard =>
      'Εφαρμογή αυτού του αποτελέσματος στον πίνακα';

  @override
  String get takingPicture => 'Λήψη φωτογραφίας...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Παρακαλώ επιλέξτε μια εικόνα πίνακα παιχνιδιού για αναγνώριση';

  @override
  String get identificationResults => 'Αποτελέσματα αναγνώρισης';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Αναλύστε τις κινήσεις και παρέχετε χρήσιμες παρατηρήσεις.';

  @override
  String get getApiKey => 'Απόκτηση API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Η διαδικασία αναγνώρισης απέτυχε να ολοκληρωθεί';

  @override
  String get boardRecognitionResult => 'Αποτέλεσμα αναγνώρισης πίνακα';

  @override
  String get askLlm => 'Ρωτήστε το LLM';

  @override
  String get boardDetectionFailed => 'Αποτυχία ανίχνευσης πίνακα!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Δεν εντοπίστηκε σημείο πίνακα, δεν μπορεί να αναγνωριστεί κομμάτι!';

  @override
  String get copyFen => 'Αντιγραφή FEN';

  @override
  String get commonlyUsedModels => 'Συχνά χρησιμοποιούμενα μοντέλα';

  @override
  String get apiKeyOptional => 'API Key (Προαιρετικό)';

  @override
  String get noImageSelected => 'Δεν έχει επιλεγεί εικόνα';

  @override
  String get blackSMove => 'Κίνηση των μαύρων';

  @override
  String get llm => 'Μεγάλο Γλωσσικό Μοντέλο';

  @override
  String get llmProvider => 'Πάροχος';

  @override
  String get baseUrl => 'Βασικό URL';

  @override
  String get model => 'Μοντέλο';

  @override
  String get temperature => 'Θερμοκρασία';

  @override
  String get llmCommandReceivedProcessing =>
      'Η εντολή ελήφθη! Η ΤΝ επεξεργάζεται...';

  @override
  String get llmDeepThinkingWait =>
      'Βαθιά σκέψη σε εξέλιξη, παρακαλώ περιμένετε...';

  @override
  String get llmPresentingSoon => 'Σύντομα θα παρουσιαστεί...';

  @override
  String get recognitionParameters => 'Παράμετροι αναγνώρισης';

  @override
  String get adjustParamsDesc =>
      'Ρυθμίστε τις παραμέτρους για καλύτερη ακρίβεια αναγνώρισης';

  @override
  String get saveParameters => 'Αποθήκευση παραμέτρων';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Αδυναμία εκκίνησης αναγνώρισης εικόνας: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Η αναγνώριση εικόνας απέτυχε: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Εφαρμόστηκε θέση με $whiteCount λευκά και $blackCount μαύρα πιόνια';
  }

  @override
  String get fenCopiedToClipboard => '(Το FEN αντιγράφηκε στο πρόχειρο)';

  @override
  String recognitionFailed(String error) {
    return 'Η αναγνώριση απέτυχε: $error';
  }

  @override
  String get myRating => 'Η βαθμολογία μου';

  @override
  String get gamesPlayed => 'Παιχνίδια που παίχτηκαν';

  @override
  String get wins => 'Νίκες';

  @override
  String get losses => 'Ήττες';

  @override
  String get draws => 'Ισοπαλίες';

  @override
  String get lastUpdated => 'Τελευταία ενημέρωση';

  @override
  String get format => 'Μορφή:';

  @override
  String get resetStatistics => 'Επαναφορά στατιστικών';

  @override
  String get drawRate => 'Ποσοστό ισοπαλιών';

  @override
  String get lossRate => 'Ποσοστό ηττών';

  @override
  String get aiStatistics => 'Στατιστικά AI';

  @override
  String get enableStatistics => 'Ενεργοποίηση στατιστικών';

  @override
  String get enableStatistics_Detail =>
      'Όταν είναι ενεργοποιημένο, τα αποτελέσματα των παιχνιδιών θα καταγράφονται στα στατιστικά. Ωστόσο, τα παιχνίδια που περιλαμβάνουν επαναφορά κινήσεων δεν θα καταγράφονται. Όταν είναι απενεργοποιημένο, η συλλογή στατιστικών τίθεται σε παύση.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Αυτό θα επαναφέρει όλα τα στατιστικά του παιχνιδιού. Αυτή η ενέργεια δεν μπορεί να αναιρεθεί.';

  @override
  String get boardInnerRingSize =>
      'Μέγεθος του εσωτερικού δακτυλίου του ταμπλό';

  @override
  String get boardShadowEnabled => 'Σκιά ταμπλό';

  @override
  String get trapAwareness => 'Εντοπισμός παγίδων';

  @override
  String get trapAwarenessDescription =>
      'Επισήμανση κινήσεων παγίδας με έντονους κύκλους και βέλη κατά την ανάλυση.';

  @override
  String trapExists(String trapMoves) {
    return 'Υπάρχει παγίδα. Κινήσεις παγίδας: $trapMoves';
  }

  @override
  String get custodianCapture => 'Πλευρική σύλληψη';

  @override
  String get custodianCaptureDescription =>
      'Επισυνάψτε ένα από τα κομμάτια του αντιπάλου σας ανάμεσα σε δύο δικά σας σε μια ευθεία γραμμή για να το συλλάβετε.';

  @override
  String get custodianCaptureEnable => 'Επιτρέψτε τη σύλληψη πλευρικής';

  @override
  String get interventionCapture => 'Σύλληψη παρέμβασης';

  @override
  String get interventionCaptureDescription =>
      'Μετακινηθείτε στο κενό σημείο ανάμεσα σε δύο από τα κομμάτια του αντιπάλου σας για να τα συλλάβετε και τα δύο.';

  @override
  String get interventionCaptureEnable => 'Επιτρέψτε τη σύλληψη παρέμβασης';

  @override
  String get leapCapture => 'Άλμα';

  @override
  String get leapCaptureDescription =>
      'Συλλέξτε το άλμα πάνω από ένα παρακείμενο κομμάτι του αντιπάλου στο άδειο σημείο πέρα.';

  @override
  String get leapCaptureEnable => 'Αφήστε τη σύλληψη άλματος';

  @override
  String get captureApplicableLines => 'Εφαρμόσιμες γραμμές';

  @override
  String get captureSquareEdges => 'Κατά μήκος των άκρων της πλατείας';

  @override
  String get captureCrossLines =>
      'Κατά μήκος ορθογώνιων γραμμών που διασχίζουν την πλατεία';

  @override
  String get captureDiagonalLines =>
      'Κατά μήκος διαγώνιων γραμμών που διασχίζουν την πλατεία';

  @override
  String get captureExecutionPhases => 'Φάσεις εκτέλεσης';

  @override
  String get capturePiecesCondition =>
      'Διαθεσιμότητα κατά τη διάρκεια της μετακινούμενης φάσης με βάση τα υπόλοιπα κομμάτια';

  @override
  String get capturePiecesConditionUnlimited => 'Δεν υπάρχει περιορισμός';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Διατίθεται όταν έχετε τρία ή λιγότερα κομμάτια';
}
