// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for German (`de`).
class SDe extends S {
  SDe([String locale = 'de']) : super(locale);

  @override
  String get appName => 'Mühle';

  @override
  String get welcome => 'Herzlich willkommen';

  @override
  String get yes => 'Ja';

  @override
  String get no => 'Nein';

  @override
  String get game => 'Spiel';

  @override
  String get humanVsAi => 'Mensch gegen Computer';

  @override
  String get humanVsHuman => 'Mensch gegen Mensch';

  @override
  String get aiVsAi => 'Computer gegen Computer';

  @override
  String get humanVsCloud => 'Mensch gegen Cloud';

  @override
  String get humanVsLAN => 'Mensch gegen LAN';

  @override
  String get testViaLAN => 'Test über LAN';

  @override
  String get move => 'Ziehen';

  @override
  String get showMoveList => 'Zugliste';

  @override
  String get moveList => 'Zugliste';

  @override
  String get noGameRecord => 'Keine Aufzeichnung';

  @override
  String get ok => 'OK';

  @override
  String get confirm => 'Bestätigen';

  @override
  String get cancel => 'Abbrechen';

  @override
  String get tipSelectWrong => 'Falscher Stein ausgewählt.';

  @override
  String get tipPlace => 'Setze deinen Stein.';

  @override
  String get tipBanPlace => 'Hier kannst du nicht hinsetzen.';

  @override
  String get tipPlaced => 'Platziert';

  @override
  String get tipRemove => 'Nimm einen Stein weg.';

  @override
  String get tipBanRemove => 'Kann nicht wegnehmen.';

  @override
  String get tipRemoved => 'Weggenommen.';

  @override
  String get tipMove => 'Ziehe einen Stein.';

  @override
  String get tipCannotPlace => 'Du kannst deinen Stein nicht dahin setzen.';

  @override
  String get tipCannotMove => 'Du kannst deinen Stein nicht dahin ziehen.';

  @override
  String get tipMill => 'Mühle! Nimm einen gegnerischen Stein.';

  @override
  String get tipContinueMill => 'Nimm noch einen gegnerischen Stein.';

  @override
  String get tipSelectOpponentsPiece => 'Wähle einen gegnerischen Stein.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Du kannst keinen Stein aus einer Mühle nehmen.';

  @override
  String get tipCanMoveOnePoint =>
      'Ein Stein kann nur 1 Feld weit gezogen werden.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Du kannst die gegnerischen Steine nicht bewegen.';

  @override
  String get tipSelectPieceToMove => 'Wähle deinen Stein zum Ziehen.';

  @override
  String get tipHaveThreePiecesLeft => 'Du hast noch 3 Steine übrig.';

  @override
  String get tipCanMoveToAnyPoint =>
      'Du kannst an jede beliebige Position springen.';

  @override
  String tipToMove(Object player) {
    return '$player ist an der Reihe zu ziehen.';
  }

  @override
  String get whiteWin => 'Spieler 1 gewinnt!';

  @override
  String get blackWin => 'Spieler 2 gewinnt!';

  @override
  String get won => 'Gewonnen';

  @override
  String get lost => 'Verloren';

  @override
  String get thinking => 'Denke nach…';

  @override
  String get newGame => 'Neues Spiel';

  @override
  String get importGame => 'Spiel importieren';

  @override
  String get exportGame => 'Spiel exportieren';

  @override
  String get gameImported => 'Spiel importiert.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Kann $invalidMove nicht importieren';
  }

  @override
  String get movesAndRulesNotMatch => 'Regeln und Züge stimmen nicht überein.';

  @override
  String get pleaseWait => 'Warten Sie mal...';

  @override
  String get restartGame => 'Spiel neu beginnen?';

  @override
  String get restart => 'Neustart';

  @override
  String get gameStarted => 'Spiel begonnen, bitte Stein platzieren.';

  @override
  String get analyzing => 'Analysiere…';

  @override
  String error(Object message) {
    return 'Fehler: $message';
  }

  @override
  String get winRate => 'Gewinnquote';

  @override
  String get score => 'Punkte:';

  @override
  String get white => 'Spieler 1';

  @override
  String get black => 'Spieler 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player Stückzahl ist kleiner als drei.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player hat aufgegeben.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player hat keine Möglichkeit zu gehen.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Das Board ist voll und $player hat keine Möglichkeit sich zu bewegen.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Die Zeit ist vorbei, $player hat verloren.';
  }

  @override
  String get drawReasonRule50 =>
      'In der Bewegungsphase wurde in der letzten bestimmten Anzahl von Zügen kein Stein entfernt.';

  @override
  String get drawReasonBoardIsFull => 'Unentschieden weil das Brett voll ist.';

  @override
  String get drawReasonThreefoldRepetition =>
      'Unentschieden wegen dreimaliger Wiederholung.';

  @override
  String get gameOverUnknownReason => 'Spiel vorbei! Unbekannter Grund.';

  @override
  String get gameOver => 'Spiel vorbei';

  @override
  String get youWin => 'Glückwunsch, du hast gewonnen!';

  @override
  String challengeHarderLevel(int level) {
    return 'Willst du ein schwierigeres Level wählen? Das neue Level wird Level $level sein!';
  }

  @override
  String get youLose => 'Du hast verloren!';

  @override
  String get analyze => 'Analysiere';

  @override
  String get about => 'Über';

  @override
  String version(Object versionNumber) {
    return 'Version: $versionNumber';
  }

  @override
  String get thanks => 'Danksagung';

  @override
  String get settings => 'Einstellungen';

  @override
  String get options => 'Optionen';

  @override
  String get generalSettings => 'Allgemeine Einstellungen';

  @override
  String get skillLevel => 'Schwierigkeitsstufe';

  @override
  String get moveTime => 'Bedenkzeit Computer';

  @override
  String get difficulty => 'Schwierigkeit';

  @override
  String get playSounds => 'Töne';

  @override
  String get playSoundsInTheGame => 'Töne beim Spielen abspielen';

  @override
  String get keepMuteWhenTakingBack => 'Beim Zurücknehmen stumm bleiben';

  @override
  String get tone => 'Ton';

  @override
  String get whoMovesFirst => 'Erster Zug';

  @override
  String get human => 'Mensch';

  @override
  String get ai => 'Computer';

  @override
  String get alternate => 'Abwechselnd';

  @override
  String get isAutoRestart => 'Nach Spielende automatisch neustarten';

  @override
  String get isAutoChangeFirstMove => 'Ersten Zug automatisch ändern';

  @override
  String get shufflingEnabled => 'Zufällige Züge';

  @override
  String get misc => 'Verschiedenes';

  @override
  String get rules => 'Regeln';

  @override
  String get piecesCount => 'Anzahl Steine für jeden Spieler';

  @override
  String get piecesCount_Detail => 'Wie viele Steine hat jeder Spieler?';

  @override
  String get flyPieceCount => 'Anzahl der fliegenden Steine';

  @override
  String get flyPieceCount_Detail =>
      'Wenn Fliegen aktiviert ist und ein Spieler auf eine bestimmte Steinzahl reduziert wird, können sich seine Steine frei zu jedem unbesetzten Punkt bewegen, anstatt wie im Rest des Spiels auf benachbarte Punkte beschränkt zu sein.';

  @override
  String get piecesAtLeastCount => 'Steine mindestens';

  @override
  String get hasDiagonalLines => 'Diagonale Linien';

  @override
  String get hasDiagonalLines_Detail =>
      'Vier diagonale Linien zum Brett hinzufügen.';

  @override
  String get isDefenderMoveFirst => 'Der zweite Spieler zieht zuerst';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Der in der Setzphase zweite Spieler zieht in der Zugphase zuerst.';

  @override
  String get mayRemoveMultiple => 'Mehrfaches Entfernen';

  @override
  String get mayRemoveMultiple_Detail =>
      'Wenn ein Spieler mehr als eine Mühle gleichzeitig schließt, darf er entsprechend viele Steine entfernen.';

  @override
  String get mayRemoveFromMillsAlways => 'Mühlen zerstören';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Normalerweise müssen Spieler alle freien Steine entfernen, bevor Steine aus einer Mühle entfernt werden dürfen. Diese Option hebt diese Beschränkung auf.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Zweiter Spieler verliert wenn das Brett voll ist';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Wenn das Brett am Ende der Setzphase voll ist, verliert der Spieler, der zuerst gezogen hat. Sonst unentschieden.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Verlieren wenn kein Zug möglich ist';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Der Spieler verliert, wenn der Gegner ihn so blockiert, daß er keinen Steine mehr bewegen kann. Wenn die Option deaktiviert ist wird die Seite gewechselt.';

  @override
  String get mayFly => 'Fliegen';

  @override
  String get mayFly_Detail =>
      'Wenn ein Spieler nur noch drei Steine hat, darf ein Stein an beliebige Punkte gezogen werden.';

  @override
  String get nMoveRule => 'N-Züge-Regel';

  @override
  String get nMoveRule_Detail =>
      'Das Spiel ist unentschieden, wenn in einer bestimmten Anzahl von Zügen von jedem Spieler keine Entfernung erfolgt ist.';

  @override
  String get rollback => 'Zurücksetzen';

  @override
  String get pleaseSelect => 'Bitte auswählen';

  @override
  String get copy => 'Kopieren';

  @override
  String get moveHistoryCopied =>
      'Zugverlauf wurde in die Zwischenablage kopiert.';

  @override
  String get help => 'Hilfe';

  @override
  String get feedback => 'Rückmeldung';

  @override
  String get exit => 'Beenden';

  @override
  String get ruleSettings => 'Regeln';

  @override
  String get color => 'Farben';

  @override
  String get boardColor => 'Brettfarbe';

  @override
  String get pieceColor => 'Steinfarbe';

  @override
  String get backgroundColor => 'Hintergrundfarbe';

  @override
  String get lineColor => 'Linienfarbe';

  @override
  String get whitePieceColor => 'Steinfarbe Spieler 1';

  @override
  String get blackPieceColor => 'Steinfarbe Spieler 2';

  @override
  String get messageColor => 'Nachrichtenfarbe';

  @override
  String get isPieceCountInHandShown =>
      'Anzahl an Steinen auf der Hand anzeigen';

  @override
  String get isNotationsShown => 'Notizen auf dem Brett anzeigen';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Symbolleiste für die Verlaufsnavigation anzeigen';

  @override
  String get display => 'Darstellung';

  @override
  String get boardBorderLineWidth => 'Linienbreite Spielbrettrand';

  @override
  String get boardInnerLineWidth => 'Innere Linienbreite des Spielbrettes';

  @override
  String get pieceWidth => 'Steingröße';

  @override
  String get fontSize => 'Schriftgröße';

  @override
  String get standardNotation => 'WMD-Notation';

  @override
  String get restore => 'Wiederherstellen';

  @override
  String get restoreDefaultSettings => 'Standardeinstellungen wiederherstellen';

  @override
  String pick(Object element) {
    return '$element nehmen';
  }

  @override
  String get info => 'Info';

  @override
  String get hint => 'Hinweis';

  @override
  String get player => 'Spieler';

  @override
  String get player1 => 'Spieler 1';

  @override
  String get player2 => 'Spieler 2';

  @override
  String get howToPlay => 'Spielanleitung';

  @override
  String get toPlacePiece =>
      'Tippe auf einen freien Punkt, um den Stein zu setzen.';

  @override
  String get toSelectPiece => 'Tippe auf einen Stein, um ihn zu ziehen.';

  @override
  String get toMovePiece =>
      'Tippe auf einen mit einem Stein verbundenen Punkt, um ihn zu ziehen.';

  @override
  String get toRemovePiece =>
      'Tippe auf einen gegnerischen Stein, um ihn zu entfernen.';

  @override
  String get needToCreateMillFirst =>
      'Du musst erst eine Mühle machen, bevor du einen Stein entfernen kannst.';

  @override
  String get needToPlayWithOwnPieces =>
      'Du musst mit deinen eigenen Steinen spielen.';

  @override
  String get statistics => 'Statistiken';

  @override
  String get totalGames => 'Gesamtzahl Spiele';

  @override
  String get results => 'Ergebnisse';

  @override
  String get left => 'links';

  @override
  String get privacyPolicy => 'Datenschutzerklärung';

  @override
  String get privacyPolicy_Detail_1 =>
      'Bitte lies sorgfältig und stelle sicher, daß du alles verstanden hast und zustimmst ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Wenn du den Bestimmungen nicht zustimmst, darfst du diese App nicht benutzen. Die Benutzung der App impliziert, dass du diesen Bestimmungen zustimmst.';

  @override
  String get and => ' und ';

  @override
  String get accept => 'Akzeptieren';

  @override
  String get takeBack => 'Zurücknehmen';

  @override
  String get takingBack => 'Nehme zurück…';

  @override
  String get waiting => 'Warte…';

  @override
  String get stepForward => 'Schritt vorwärts';

  @override
  String get takeBackAll => 'Alles zurücknehmen';

  @override
  String get stepForwardAll => 'Alles wiederholen';

  @override
  String get moveNow => 'Jetzt ziehen';

  @override
  String get done => 'Fertig.';

  @override
  String get crackMill => 'Crack-Mühle';

  @override
  String get crackMill_Detail =>
      'Wenn ein Spieler nur Steine in Mühlen hat, können diese Steine entfernt werden.';

  @override
  String get animationDuration => 'Animationsdauer';

  @override
  String get none => 'Kein';

  @override
  String get theme => 'Thema';

  @override
  String get helpContent =>
      'Das Ziel des Spiels ist es, dass der Gegner weniger als drei Steine hat oder sich nicht mehr bewegen kann.\n\nDas Spiel endet automatisch unentschieden, wenn eine Spielposition das dritte Mal auftritt, oder wenn in den letzten 100 (konfigurierbar) Zügen kein Stein entfernt wurde.\n\nDas Spiel läuft in drei Phasen ab:\n\n1. Steine auf freie Punkte setzen\n2. Steine auf angrenzende Punkte schieben\n3. (optionale Phase) Steine auf beliebige freie Punkte setzen wenn der Spieler nur noch drei Steine hat\n\nSetzphase\n\nDas Spiel beginnt mit einem leeren Spielbrett, das aus einem Gitter mit vierundzwanzig Punkten besteht. Die Spieler setzen abwechselnd Steine auf freie Punkte, bis jeder Spieler alle Steine gesetzt hat. Wenn ein Spieler drei Steine in einer geraden Linie setzt, dann hat er eine „Mühle“ und darf einen gegnerischen Stein vom Spielbrett nehmen.\n\nIn einigen Regelvarianten müssen die Spieler alle anderen Steine entfernen, bevor ein Stein aus einer Mühle genommen werden kann.\n\nIn einigen Regelvarianten dürfen Steine in der Setzphase nicht wieder auf Punkte gesetzt werden, von denen bereits Steine genommen wurden.\n\nWenn alle Steine gesetzt worden sind, ziehen die Spieler abwechselnd einen Stein.\n\nZugphase\n\nBeim Ziehen bewegt ein Spieler einen seiner Steine entlang einer Linie zum nächsten freien Punkt. Wenn er das nicht kann, hat er verloren. Genau wie in der Setzphase führen drei Steine in einer Linie zu einer Mühle, und der Spieler darf einen der gegnerischen Steine entfernen. Ein Spieler mit nur zwei Steinen kann keine Mühlen mehr bekommen und verliert deshalb. Ein Spieler kann auch mit mehr als drei Steinen verlieren, wenn sein Gegner ihn so blockiert hat, dass er seine Steine nicht mehr bewegen kann.\n\nEndphase\n\nIn einigen Regelvarianten kann ein Spieler, dem nur noch drei Steine verbleiben, mit seinen Steinen auf jeden freien Punkt „fliegen“, „hüpfen“ oder „springen“, nicht nur auf benachbarte.\n';

  @override
  String get versionInfo => 'Versionsinformationen';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'Lizenz';

  @override
  String get sourceCode => 'Quellcode';

  @override
  String get appVersion => 'App-Version';

  @override
  String get general => 'Generell';

  @override
  String get advanced => 'Fortgeschritten';

  @override
  String get placing => 'Setze';

  @override
  String get moving => 'Bewege';

  @override
  String get removing => 'Entferne';

  @override
  String get gameOverCondition => 'Spielendebedingung';

  @override
  String get aisPlayStyle => 'Spielstil des Computers';

  @override
  String get passive => 'Passiv';

  @override
  String get timeout => 'Zeitlimit';

  @override
  String get appearance => 'Aussehen';

  @override
  String get drawOnHumanExperience => 'Auf menschliche Erfahrung zurückgreifen';

  @override
  String get considerMobility => 'Verbessern Sie die Beweglichkeit von Steinen';

  @override
  String get pieceCount => 'Anzahl Steine:';

  @override
  String inHand(Object player, int count) {
    return '$player in der Hand: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player auf dem Bord: $count';
  }

  @override
  String get boardTop => 'Abstand Spielbrett von oben';

  @override
  String get notAIsTurn => 'Der Computer ist nicht am Zug.';

  @override
  String get aiIsNotThinking => 'Computer denkt nicht.';

  @override
  String get atEnd => 'Am Ende der Spielzugliste.';

  @override
  String get tapBackAgainToLeave => 'Nochmal drücken, um zu beenden.';

  @override
  String get more => 'Mehr';

  @override
  String get experimental => 'Dies ist eine experimentelle Funktion.';

  @override
  String get experiments => 'Experimente';

  @override
  String get ossLicenses => 'Quelloffene Lizenzen';

  @override
  String get language => 'Sprache';

  @override
  String get defaultLanguage => 'Standardsprache';

  @override
  String get mayMoveInPlacingPhase =>
      'Die Steine können sich in der Setzphase bewegen';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Es gibt keine getrennten Setz- und Zugphasen, d.h. die Spieler können bei jedem Zug entscheiden, ob sie einen Stein auf dem Brett setzen oder einen ihrer Steine bewegen wollen (solange sie noch Steine zum Setzen haben).';

  @override
  String get drawerColor => 'Menüfarbe';

  @override
  String get drawerTextColor => 'Menütextfarbe';

  @override
  String get drawerHighlightItemColor => 'Farbe des Menümarkierungselements';

  @override
  String get mainToolbarBackgroundColor =>
      'Hintergrundfarbe der Hauptsymbolleiste';

  @override
  String get mainToolbarIconColor => 'Symbolfarbe der Hauptsymbolleiste';

  @override
  String get navigationToolbarBackgroundColor =>
      'Hintergrundfarbe der Navigationsleiste';

  @override
  String get navigationToolbarIconColor =>
      'Symbolfarbe der Navigationssymbolleiste';

  @override
  String get autoHideToolbar => 'Symbolleiste automatisch ausblenden';

  @override
  String get toolbarLocationOnScreen =>
      'Position der Symbolleiste auf dem Bildschirm';

  @override
  String get top => 'Oben';

  @override
  String get bottom => 'Unterseite';

  @override
  String get center => 'Mitte';

  @override
  String get solidColor => 'Einfarbig';

  @override
  String get picture => 'Bild';

  @override
  String get chooseYourPicture => 'Wähle dein Bild';

  @override
  String get light => 'Hell';

  @override
  String get dark => 'Dunkel';

  @override
  String get themes => 'Themen';

  @override
  String get currentTheme => 'Aktuelles Thema';

  @override
  String get saveTheme => 'Thema speichern';

  @override
  String get showAnalysisGraph => 'Analysegrafik anzeigen';

  @override
  String get analysis => 'Analyse';

  @override
  String get saveGame => 'Spiel speichern';

  @override
  String get loadGame => 'Spiel laden';

  @override
  String get setupPosition => 'Aufstellungsposition';

  @override
  String get showLegalMoves => 'Legale Züge anzeigen';

  @override
  String get showLastMove => 'Letzten Zug anzeigen';

  @override
  String get showArrows => 'Pfeile zeigen';

  @override
  String get pieces => 'Stücke';

  @override
  String get showAnalysis => 'Analyse anzeigen';

  @override
  String get threads => 'Threads';

  @override
  String get getInvolved => 'Machen Sie mit';

  @override
  String get helpImproveTranslate =>
      'Helfen Sie mit, die Übersetzung zu verbessern';

  @override
  String get tutorial => 'Lernprogramm';

  @override
  String get classicMill => 'Klassische Mühle';

  @override
  String get mixedMill => 'Gemischte Mühle';

  @override
  String get ceylonMill => 'Ceylon-Mühle';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Mühle kann wiederholt gebrochen und neu hergestellt werden';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Wenn ein Spieler eine Mühle zerstört, um sofort eine neue Mühle zu bauen, kann dieser Spieler diesen Stein in seinem nächsten Zug zurück zur ursprünglichen Kreuzung bewegen, wenn er eine neue Mühle baut.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Das Spiel ist unentschieden, wenn ein Spieler drei Steine hat und nach zehn Zügen keiner der Spieler die Steine des Gegners entfernt remove';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Wenn ein Spieler nur noch drei Steine übrig hat und keiner der Spieler einen gegnerischen Stein innerhalb von zehn Zügen entfernen kann, ist das Spiel unentschieden.';

  @override
  String get close => 'Schließen Sie';

  @override
  String get whitePiece => 'Weißer Stein';

  @override
  String get blackPiece => 'Schwarzer Stein';

  @override
  String get emptyPoint => 'Leere Stelle';

  @override
  String get noPoint => 'Kein Punkt';

  @override
  String get placingPhase => 'Setzphase';

  @override
  String get movingPhase => 'Bewegungsphase';

  @override
  String get flyingPhase => 'Flugphase';

  @override
  String sideToMove(Object player) {
    return 'Seite zum Bewegen: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Letzter Zug: $move';
  }

  @override
  String get selected => 'Ausgewählt';

  @override
  String get accessibility => 'Barrierefreiheit';

  @override
  String get screenReaderSupport => 'Unterstützung für Bildschirmlesegeräte';

  @override
  String get isDraw => 'Es ist ein Unentschieden!';

  @override
  String get draw => 'Unentschieden';

  @override
  String get pieceHighlightColor => 'Farbe des Stein-Highlights';

  @override
  String get algorithm => 'Algorithmus';

  @override
  String get endgameNMoveRule => 'Endspiel N-Züge-Regel';

  @override
  String get endgameNMoveRule_Detail =>
      'Wenn einer der beiden Spieler nur drei Steine hat und keiner der beiden Spieler innerhalb eines bestimmten Zuges einen Stein entfernt, ist das Spiel unentschieden.';

  @override
  String get drawReasonEndgameRule50 =>
      'Jeder der beiden Spieler hat nur drei Steine und keiner der beiden Spieler entfernt einen Stein innerhalb eines bestimmten Zuges.';

  @override
  String get threefoldRepetitionRule => 'Dreifache Wiederholungsregel';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Das Spiel ist unentschieden, wenn eine Stellung zum dritten Mal auftritt.';

  @override
  String get continueToMakeMove => 'Mühle! Bewegen Sie sich weiter.';

  @override
  String get pointStyle => 'Punkt-Stil';

  @override
  String get pointWidth => 'Breite der Punkte';

  @override
  String get solid => 'Solide';

  @override
  String get hollow => 'Hohle';

  @override
  String get languageName => 'Deutsch';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Züge',
      one: '$count Zug',
      zero: 'Zug',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Laden fehlgeschlagen.';

  @override
  String get filename => 'Dateiname';

  @override
  String get browse => 'Durchsuchen…';

  @override
  String get gameFiles => 'Spiel-Dateien';

  @override
  String get gameSavedTo => 'Das Spiel wird gespeichert unter';

  @override
  String get empty => 'Leer';

  @override
  String get noMove => 'Keine Bewegung.';

  @override
  String get restoredPosition => 'Ausgangsposition wiederhergestellt.';

  @override
  String get clean => 'Leeren';

  @override
  String get cleanedUp => 'Aufgeräumt.';

  @override
  String get remove => 'Entfernen';

  @override
  String get noPiecesCanBeRemoved => 'Es können keine Teile entfernt werden.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Steine',
      one: '$count Stein',
      zero: 'Stein',
    );
    return '$_temp0 müssen entfernt werden.';
  }

  @override
  String placedCount(int count) {
    return 'Pzt ($count)';
  }

  @override
  String get placedPieceCount =>
      'Platzierte Stückzahl in der Platzierungsphase.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'Der aktuelle Spieler hat $count Steine platziert.';
  }

  @override
  String get notPlacingPhase =>
      'Nicht in der Platzierungsphase, kann nicht geändert werden.';

  @override
  String get paste => 'Einfügen';

  @override
  String get pasteDone => 'Einfügen abgeschlossen.';

  @override
  String get cannotPaste => 'Kann nicht einfügen.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Nicht platzierte und entfernte Steine anzeigen';

  @override
  String get fullScreen => 'Vollbild';

  @override
  String get reopenToTakeEffect =>
      'Die App beenden und erneut Öffnen, damit die Einstellungen wirksam werden.';

  @override
  String get forest => 'Wald';

  @override
  String get desktopImage => 'Desktop-Bild';

  @override
  String get invalidPosition => 'Ungültige Position.';

  @override
  String get shareGIF => 'GIF teilen';

  @override
  String get pixelRatio => 'Pixelverhältnis';

  @override
  String get duration => 'Dauer';

  @override
  String get gameScreenRecorder => 'Bildschirmrekorder für Spiele';

  @override
  String get previous => 'Vorherige';

  @override
  String get next => 'Nächste';

  @override
  String get skip => 'Überspringen';

  @override
  String get gotIt => 'Verstanden';

  @override
  String get youCanModifyRules =>
      'Du kannst die Spielregeln in den Regeleinstellungen ändern.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Du kannst den Wert in der Auswahl mit dem Mausrad ändern.';

  @override
  String get noTimeLimitForThinking =>
      'KI-Denkzeit auf 0 gesetzt bedeutet, dass es keine Zeitbegrenzung für das Denken gibt.';

  @override
  String get whatIsMtdf =>
      'MTD(f) ist eine modifizierte Form des Alpha-Beta-Suchalgorithmus, der darauf abzielt, die Effizienz zu verbessern, indem Zwischenergebnisse wiederverwendet werden und eine gute Anfangsschätzung verwendet wird, um den Suchraum einzugrenzen.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Bitte beachte, dass die Anpassung der KI-Denkzeit möglicherweise nicht ganz genau ist. Die tatsächliche Bedenkzeit kann kürzer sein, wenn der Schwierigkeitsgrad auf einen niedrigeren Wert eingestellt ist, und kann länger sein, wenn die KI mitten im Denken ist, wenn die Zeit abläuft.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Wenn Sie den Schwierigkeitsgrad hoch einstellen, aber die KI-Denkzeit nicht erhöhen, kann der tatsächliche Schwierigkeitsgrad aufgrund der Bedenkzeitbeschränkung auf einen niedrigeren Wert begrenzt werden. Der tatsächliche Wert kann je nach Leistung der Maschine variieren.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) ist ein Suchalgorithmus, um den besten Zug in einer bestimmten Stellung zu finden. Es ist eine Verbesserung des Alpha-Beta-Algorithmus und verwendet Null- oder Nullfenstersuchen, um zu bestätigen, dass ein Zug schlechter oder nicht schlechter ist als ein bereits sicheres Ergebnis aus der Hauptvariante. PVS konzentriert sich auf die vielversprechendsten Züge und vermeidet unnötige Suchen suboptimaler Verzweigungen, wodurch die Effizienz der Suche verbessert wird.';

  @override
  String get whatIsAlphaBeta =>
      'Der Alpha-Beta-Algorithmus ist ein Suchalgorithmus, um den besten Zug zu finden. Es verwendet das Mini-Max-Prinzip und zwei Werte, Alpha und Beta, um den Suchbaum zu verkürzen und die Effizienz zu steigern. Alpha stellt die minimale Punktzahl dar, die der Computer sicher erreichen kann, während Beta die maximale Punktzahl darstellt, die sein Gegner erzielen kann. Der Algorithmus hilft dem Computer, intelligente und effiziente Entscheidungen in einem Spiel zu treffen.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Nach menschlicher Erfahrung werden Sie verlieren, wenn Sie versuchen zu gewinnen. Wir empfehlen stattdessen ein Unentschieden als Ziel anzustreben und es zu vermeiden es, das Spiel zu verlieren. Beobachten Sie Ihren Gegner und locken Sie ihn sanft in eine Position, in der er Fehler machen kann. Wenn sie Schwäche zeigen, nutzen Sie die Gelegenheit und drängen Sie sanft auf den Sieg. Auf diese Weise können Sie das Spiel gewinnen.';

  @override
  String get firstMoveDetail =>
      'In diesem Spiel hat der zweite Spieler leichter die Chance zu gewinnen als der erste.';

  @override
  String get passiveDetail =>
      'Die Aktivierung der passiven Option bewirkt, dass sich die KI entspannt, wenn sie einen Vorteil in der Position hat, anstatt aggressiv zu versuchen, so schnell wie möglich zu gewinnen.';

  @override
  String get moveRandomlyDetail =>
      'Das Aktivieren dieser Option erhöht die Zufälligkeit und den Spaß des Spiels, während das Deaktivieren dazu beitragen kann, Wege zu finden, die KI zu schlagen.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Wenn die KI die Beweglichkeit ihrer Steine berücksichtigt, wird sie nicht nur versuchen, die Steine des Gegners so schnell wie möglich zu erobern, sondern auch die Bewegungen des Gegners blockieren und verhindern, dass dieser das Gleiche tut.';

  @override
  String get whenBoardIsFull => 'Wenn das Brett voll ist';

  @override
  String get whenBoardIsFull_Detail =>
      'Am Ende der Platzierungsphase, bevor die Bewegungsphase beginnt, folgt die Aktion, wenn der Spielplan voller Steine ist.';

  @override
  String get sideToMoveRemovePiece =>
      'Der Spieler, der sich in der Bewegungsphase zuerst bewegt, entfernt einen der Steine des Gegners.';

  @override
  String get agreeToDraw => 'Beide Seiten einigen sich auf ein Unentschieden.';

  @override
  String get takeOpponentsPiece => 'Nimm einen der Steine deines Gegners.';

  @override
  String get firstPlayerLose => 'Der erste Spieler verliert das Spiel.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Der erste und der zweite Spieler entfernen einen der Steine des Gegners.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Der zweite und der erste Spieler entfernen einen der Steine des Gegners.';

  @override
  String get enteredFlyingPhase =>
      'Jetzt in die Flugphase eingetreten, können die Figuren des Gegners zu jedem leeren Punkt auf dem Brett springen. Sie können die Flugregel in den \"Regeln\" deaktivieren.';

  @override
  String get whenStalemate => 'Bei Patt';

  @override
  String get whenStalemate_Detail =>
      'Was passiert, wenn kein Stein bewegt werden kann?';

  @override
  String get endWithStalemateLoss =>
      'Beenden Sie mit einem Pattverlust für die Seite, die blockiert ist.';

  @override
  String get changeSideToMove => 'Wechsle die Seite, um dich zu bewegen.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Entfernen Sie einen der Steine des Gegners und machen Sie den nächsten Zug.';

  @override
  String get endWithStalemateDraw =>
      'Beenden Sie mit einem Patt-Unentschieden.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Entferne einen der gegnerischen Steine und wechsle die Seite, um dich zu bewegen.';

  @override
  String get aiResponseDelayTime => 'KI-Antwortverzögerungszeit';

  @override
  String get aiIsDelaying =>
      'KI befindet sich derzeit in einer verzögerten Reaktionsphase. Bitte warten Sie eine Weile, bevor Sie fortfahren.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Sie können keinen nicht angrenzenden Stein entfernen.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'Bei einer Patt-Situation können die an deine angrenzenden Steine des Gegners unabhängig von der Mühlen-Formation entfernt werden.';

  @override
  String get whatIsMcts =>
      'MCTS ist ein anfängerfreundlicher Algorithmus, der Entscheidungen trifft, indem er verschiedene Bewegungen durch Simulationen untersucht und bewertet.';

  @override
  String get goldenJade => 'Goldene Jade';

  @override
  String get forestWood => 'Waldholz';

  @override
  String get darkMystery => 'Dunkles Geheimnis';

  @override
  String get midnightBlue => 'Mitternachtsblau';

  @override
  String get greenForest => 'Grüner Wald';

  @override
  String get greenMeadow => 'Grüne Wiese';

  @override
  String get stonyPath => 'Steiniger Weg';

  @override
  String get pastelPink => 'Pastellrosa';

  @override
  String get turquoiseSea => 'Türkises Meer';

  @override
  String get violetDream => 'Violetter Traum';

  @override
  String get mintChocolate => 'Minz-Schokolade';

  @override
  String get skyBlue => 'Himmelblau';

  @override
  String get playfulGarden => 'Verspielter Garten';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Der Retrograde-Analyse-Algorithmus verwendet eine mehrwertige Retrograde-Analyse, um eine Endspieldatenbank aus verschiedenen Startpositionen zu erstellen, und wendet diese Datenbank dann an, um das Gameplay zu optimieren. Dieser Ansatz fällt in die Kategorie der ultrastarken Lösungen.';

  @override
  String get viewAlgorithmGuide =>
      'Möchten Sie das Benutzerhandbuch für diesen Algorithmus anzeigen?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Anzeige des Positionsvorteilsindikators';

  @override
  String get usePerfectDatabase => 'Verwenden Sie die perfekte Datenbank';

  @override
  String get perfectDatabaseDescription =>
      'Aktivieren Sie diese Option, um eine fehlerfreie Spiel-Datenbank zu nutzen, die durch modernste Algorithmen generiert wurde. Diese Funktion integriert sowohl Eröffnungs- als auch Endspielstrategien, um optimale Züge vorzuschlagen. Sie ist die bevorzugte Wahl für Spieler, die das höchste Maß an Präzision im Spiel anstreben. Durch akribische Berechnungstechniken erstellt, ist die Datenbank darauf ausgelegt, nahezu perfekte Spiellösungen anzubieten.\n\nHinweis: Sollte die KI keinen Zugriff auf die Datenbank haben, wird sie auf herkömmliche Algorithmen für Spielentscheidungen zurückgreifen. Ist die Datenbank verfügbar, wird der \'Schwierigkeitsgrad\' praktisch unschlagbar und die \'Denkzeit der KI\' erheblich reduziert. Viele Einstellungen im Bereich \'Spielstil der KI\' werden überschrieben, da die Ergebnisse der Datenbank höchste Priorität haben.\n\nFür Anleitungen zur optimalen Nutzung dieser fehlerfreien Datenbank klicken Sie bitte hier.';

  @override
  String get backgroundImage => 'Hintergrundbild';

  @override
  String get whatIsRandom =>
      'Wenn die Option \'Perfekte Datenbank verwenden\' nicht aktiviert ist, bewirkt die Einstellung \'Zufällig\', dass die KI die Figuren zufällig bewegt, ohne Algorithmen für die Zugauswahl zu verwenden. Dies führt typischerweise zu deutlich schwächerem Spielverhalten. Im Gegensatz dazu verlässt sich die KI bei Aktivierung der Option \'Perfekte Datenbank verwenden\' ausschließlich auf die \'Perfekte Datenbank\' für Entscheidungen, anstatt sie mit traditionellen KI-Algorithmen zu kombinieren. In diesem Modus basieren die Züge der KI vollständig auf dem Inhalt der Datenbank und verzichten auf die Abhängigkeit von Echtzeitberechnungen oder Suchalgorithmen.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Entferne die Spielsteine des Gegners aus seiner Hand; dann ist der Gegner am Zug zum Platzieren.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Beim Bilden von Mühlen während der Platzierungsphase';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Entferne die Spielsteine des Gegners vom Spielbrett.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Entferne die Spielsteine des Gegners vom Spielbrett; dann ist der Gegner am Zug zum Platzieren.';

  @override
  String get opponentRemovesOwnPiece =>
      'Der Gegner entfernt seine eigenen Spielsteine vom Spielbrett.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Anstatt dass du handelst, wählt der Gegner seine eigenen Spielsteine aus und entfernt sie vom Spielbrett, was effektiv eine für ihn nachteilige Aktion ist.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Entferne die Spielsteine des Gegners aus seiner Hand; dann bist du am Zug.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Entferne Spielsteine aus der Hand des Gegners. Wenn gemäß der Einstellung für mehrfaches Entfernen mehrere Spielsteine entfernt werden müssen und der Gegner keine Spielsteine mehr in der Hand hat, fahre fort, die Spielsteine des Gegners vom Spielbrett zu entfernen. Dann bist du am Zug. Wenn du weiterhin Mühlen bildest, darfst du die Spielsteine des Gegners weiter entfernen.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Entferne Spielsteine aus der Hand des Gegners. Wenn gemäß der Einstellung für mehrfaches Entfernen mehrere Spielsteine entfernt werden müssen und der Gegner keine Spielsteine mehr in der Hand hat, fahre fort, die Spielsteine des Gegners vom Spielbrett zu entfernen. Dann ist der Gegner am Zug.';

  @override
  String get markAndDelayRemovingPieces =>
      'Markiere und verzögere das Entfernen von Spielsteinen.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Während der Platzierungsphase werden die zu entfernenden Spielsteine markiert, und für beide Spieler können auf diesen Punkten keine neuen Spielsteine platziert werden. Beim Eintritt in die Zugphase werden diese markierten Spielsteine zusammen entfernt, und die Spieler können dann ihre Spielsteine auf diese nun leeren Punkte setzen.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Die Maßnahmen, die beim Bilden von Mühlen in der Platzierungsphase ergriffen werden können.';

  @override
  String get marked => 'Markiert';

  @override
  String get menu => 'Menü';

  @override
  String get monochrome => 'Monochrom';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Sie können die Unterstützung für Screenreader in den Zugänglichkeitseinstellungen unter Allgemeine Einstellungen aktivieren.';

  @override
  String get showNumbersOnPieces => 'Zahlen auf Steinen anzeigen';

  @override
  String get saveImage => 'Bild speichern';

  @override
  String get isAnalysisToolbarShown => 'Analysetools anzeigen';

  @override
  String get analysisToolbarBackgroundColor =>
      'Hintergrundfarbe der Analysetools';

  @override
  String get analysisToolbarIconColor => 'Symbolfarbe der Analysetools';

  @override
  String get transformed => 'Transformiert.';

  @override
  String get cannotTransform => 'Kann nicht transformieren.';

  @override
  String get rotate => 'Rotieren';

  @override
  String get horizontalFlip => 'H Kippen';

  @override
  String get verticalFlip => 'V Kippen';

  @override
  String get innerOuterFlip => 'IO Kippen';

  @override
  String get transparentCanvas => 'Transparenter Hintergrund';

  @override
  String get restrictRepeatedMillsFormation =>
      'Wiederholte Mühlenbildung einschränken';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Ein Stein, der von einer Mühle zu einer anderen bewegt wurde, kann nicht sofort auf den ursprünglichen Punkt im nächsten Zug zurückkehren, um wieder eine Mühle zu bilden. Zuerst ist ein anderer Zug erforderlich.';

  @override
  String get oneTimeUseMill => 'Einmalige Verwendung Mühle';

  @override
  String get oneTimeUseMill_Detail =>
      'Jede Mühle kann nur ein gegnerisches Stück einmal entfernen. Sie können es erneut bilden, aber es kann nicht für zusätzliche Entfernungen verwendet werden.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Die aktuellen Regeln, die Sie festgelegt haben, haben keine entsprechende perfekte Datenbank. Für weitere Informationen zur perfekten Datenbank klicken Sie bitte hier.';

  @override
  String get focusOnBlockingPaths => 'Auf Wegblockierung fokussieren';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Während bestimmter Phasen des Spiels, priorisieren Sie das Blockieren der Bewegungen des Gegners über das Bilden von Mühlen. Anstatt sich darauf zu konzentrieren, Steine durch das Vervollständigen von Mühlen zu entfernen, zielt die KI während dieser Phasen darauf ab, den Gegner zu fangen, sodass er sich nicht bewegen kann und einen Sieg durch Abnutzung statt durch aggressives Spiel sichert. Diese phasenspezifische Strategie blockiert nicht aktiv die Mühlen des Gegners.';

  @override
  String get pieceImage => 'Figurenbild';

  @override
  String get importColorSettings => 'Farbeinstellungen importieren';

  @override
  String get exportColorSettings => 'Farbeinstellungen exportieren';

  @override
  String get import => 'Importieren';

  @override
  String get export => 'Exportieren';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Bitte kopieren Sie zuerst die JSON-Format-Einstellungen in die Zwischenablage.';

  @override
  String get copiedToClipboard => 'In die Zwischenablage kopiert.';

  @override
  String get imported => 'Importiert.';

  @override
  String get boardImage => 'Brettbild';

  @override
  String get autumnLeaves => 'Herbstblätter';

  @override
  String get legendaryLand => 'Legendäres Land';

  @override
  String get vignetteEffect => 'Vignettierungseffekt';

  @override
  String get promptMakeToolbarTransparent =>
      'Möchten Sie die Symbolleiste vollständig transparent machen, wenn ein Hintergrundbild für das Board festgelegt ist?';

  @override
  String get vibration => 'Vibration im Spiel aktivieren';

  @override
  String get soundTheme => 'Soundthema';

  @override
  String get ball => 'Ball';

  @override
  String get liquid => 'Flüssigkeit';

  @override
  String get wood => 'Holz';

  @override
  String get placeEffectAnimation =>
      'Animationseffekt beim Platzieren von Figuren';

  @override
  String get removeEffectAnimation =>
      'Animationseffekt beim Entfernen von Figuren';

  @override
  String get isToolbarAtBottom => 'Symbolleiste unten anzeigen';

  @override
  String get boardCornerRadius => 'Eckenradius des Boards';

  @override
  String get useOpeningBook => 'Eröffnungsbuch verwenden';

  @override
  String get currentRule => 'Aktuell';

  @override
  String get nineMensMorris => 'Mühle';

  @override
  String get twelveMensMorris => '12er-Mühle';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Regelsatz';

  @override
  String get laskerMorris => 'Lasker-Mühle';

  @override
  String get oneTimeMill => 'Einmal-Mühle';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'Lassen Sie die KI Eröffnungszüge verwenden, die üblicherweise von professionellen menschlichen Spielern im frühen Spiel verwendet werden. Hinweis: Diese Funktion ist derzeit nur für bestimmte Regelsets verfügbar.';

  @override
  String get showAdvantageGraph => 'Vorteilsdiagramm anzeigen';

  @override
  String get advantageGraphHint =>
      'Der Vorteilgraph wird nur gezeichnet, nachdem die KI einen Zug gemacht hat. Er wird nicht gezeichnet, wenn der menschliche Spieler einen Zug macht.';

  @override
  String get removalBasedOnMillCounts =>
      'Deaktiviere das Entfernen, bis alle Steine platziert sind, dann entferne Steine basierend auf der Anzahl der Mühlen.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Deaktiviere das Entfernen, bis alle Steine platziert sind, dann entferne Steine basierend auf der Anzahl der Mühlen: Sind sie gleich, entfernen beide die gleiche Anzahl. Hat einer mehr, entfernt er einen zusätzlichen Stein, um einen Unterschied von einem Stein beizubehalten. Bildet nur einer Mühlen, entfernt dieser zwei Steine und der andere einen. Bildet keiner Mühlen, entfernen beide jeweils einen Stein.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Wähle einen deiner Steine aus.';

  @override
  String get notYourTurn => 'Du bist nicht am Zug.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Hintergrundfarbe der Annotationswerkzeugleiste';

  @override
  String get annotationToolbarIconColor =>
      'Symbolfarbe der Annotationswerkzeugleiste';

  @override
  String get isAnnotationToolbarShown => 'Annotationswerkzeugleiste anzeigen';

  @override
  String get enterAnnotationMode => 'Annotationsmodus betreten';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Möchten Sie wirklich alle Anmerkungen löschen?';

  @override
  String get llmPromptCopiedToClipboard =>
      'LLM-Aufforderung in die Zwischenablage kopiert.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Verbindung verweigert, der Server ist möglicherweise ausgefallen.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Erkennung erfolgreich, warte auf Verbindung...';

  @override
  String get noLanConnection => 'Keine LAN-Verbindung';

  @override
  String get takeScreenshot => 'Screenshot erstellen';

  @override
  String get disconnectedFromOpponent => 'Vom Gegner getrennt.';

  @override
  String get takeBackRequest => 'Rücknahmeanforderung';

  @override
  String get nothingToShow => 'Nichts anzuzeigen.';

  @override
  String get stopHosting => 'Hosting beenden';

  @override
  String get connectionResetByPeer =>
      'Verbindung durch Gegenstelle zurückgesetzt.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Verbindung verloren durch Zeitüberschreitung (Heartbeat). Bitte erneut verbinden.';

  @override
  String get startHosting => 'Hosting starten';

  @override
  String get restartRequestRejected => 'Neustartanfrage abgelehnt.';

  @override
  String get notConnectedToLanOpponent => 'Nicht mit LAN-Gegner verbunden.';

  @override
  String get llmPrompt => 'LLM-Prompt';

  @override
  String get gameRestarted => 'Spiel neu gestartet.';

  @override
  String get takeBackRejected => 'Rücknahme abgelehnt.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Sind Sie sicher, dass Sie dieses Spiel aufgeben möchten?';

  @override
  String get opponentResignedYouWin => 'Gegner hat aufgegeben. Sie gewinnen!';

  @override
  String get clearAllAnnotations => 'Alle Anmerkungen löschen';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Verbunden, warte auf den Zug des Gegners...';

  @override
  String get networkStatusDisconnected => 'Netzwerkstatus: Getrennt';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Rücknahmeanforderung an den Gegner gesendet.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'Der Gegner hat das Spiel möglicherweise verlassen';

  @override
  String get connectedToHostSuccessfully => 'Erfolgreich mit Host verbunden.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Verbindung verloren: Zeitüberschreitung (Heartbeat)';

  @override
  String get noHostDiscovered => 'Kein Host gefunden.';

  @override
  String get confirmResignation => 'Aufgabe bestätigen';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Spielhosting gestartet, warte auf Beitritt von Spielern...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Zeitüberschreitung der Verbindung, Netzwerkverbindung instabil.';

  @override
  String get noLlmPromptAvailable => 'Keine LLM-Aufforderung verfügbar.';

  @override
  String get youResignedGameOver => 'Sie haben aufgegeben. Spiel beendet.';

  @override
  String get serverIp => 'Server-IP';

  @override
  String get confirmClear => 'Löschen bestätigen';

  @override
  String get opponentSTurn => 'Der Gegner ist am Zug.';

  @override
  String get waitingAClientConnection => 'Warte auf Client-Verbindung...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Rücknahmeanforderung wurde abgelehnt oder schlug fehl.';

  @override
  String get addText => 'Text hinzufügen';

  @override
  String get exitAnnotationMode => 'Annotationsmodus verlassen';

  @override
  String get typeYourAnnotation => 'Geben Sie Ihre Anmerkung ein';

  @override
  String get attemptingToReconnect => 'Versuche erneut zu verbinden...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Neustartanfrage gesendet. Warte auf die Antwort des Gegners...';

  @override
  String get serverIsStopped => 'Server ist gestoppt.';

  @override
  String get restartRequest => 'Neustartanfrage';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Eine Rücknahme kann nur angefordert werden, wenn Sie am Zug sind.';

  @override
  String get takeBackAccepted => 'Rücknahme akzeptiert.';

  @override
  String get localNetworkSettings => 'Lokale Netzwerkeinstellungen';

  @override
  String get reconnectedSuccessfully => 'Erfolgreich wieder verbunden!';

  @override
  String get failedToSaveImageToGallery =>
      'Bild konnte nicht in der Galerie gespeichert werden.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Der Gegner hat einen Neustart des Spiels angefordert. Akzeptieren Sie?';

  @override
  String get yourTurn => 'Sie sind am Zug.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Erneute Verbindung nicht möglich, bitte starten Sie das Spiel neu.';

  @override
  String get host => 'Host';

  @override
  String get join => 'Beitreten';

  @override
  String get port => 'Port';

  @override
  String get invalidIpAddress => 'Ungültige IP-Adresse.';

  @override
  String get invalidPort => 'Ungültiger Port.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Verbinde: Versuch $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Verbindung fehlgeschlagen: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Hosting konnte nicht gestartet werden: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Host gefunden: $ip:$port';
  }

  @override
  String get stop => 'Beenden';

  @override
  String get discover => 'Suchen';

  @override
  String get connect => 'Verbinden';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Client verbunden: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Suche: $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Wiederverbinden ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Verbunden';

  @override
  String get delete => 'Löschen';

  @override
  String get ancientEgypt => 'Germanisches Erbe';

  @override
  String get gothicIce => 'Alpen-Gletscher';

  @override
  String get riceField => 'Rapsfeld';

  @override
  String get chinesePorcelain => 'Meißener Porzellan';

  @override
  String get desertDusk => 'Heideabend';

  @override
  String get precisionCraft => 'Schweizer Präzision';

  @override
  String get folkEmbroidery => 'Trachtstickerei';

  @override
  String get carpathianHeritage => 'Alpines Erbe';

  @override
  String get imperialGrandeur => 'Wiener Kaiserglanz';

  @override
  String get bohemianCrystal => 'Tiroler Kristall';

  @override
  String get savannaSunrise => 'Alpenglühen';

  @override
  String get harmonyBalance => 'Gemütlicher Ausgleich';

  @override
  String get cinnamonSpice => 'Lebkuchengewürz';

  @override
  String get anatolianMosaic => 'Römisches Mosaik';

  @override
  String get carnivalSpirit => 'Rheinischer Karneval';

  @override
  String get custom => 'Brauch';

  @override
  String get spiceMarket => 'Weihnachtsmarkt';

  @override
  String get swipeToRevealTheDrawer => 'Wischen, um die Schublade anzuzeigen';

  @override
  String get showGameInfoOnScreenshots =>
      'Spielinformationen auf Screenshots anzeigen';

  @override
  String get humanMoveTime => 'Zeitlimit für menschlichen Zug';

  @override
  String get noTimeLimitForHumanMoves => 'Kein Zeitlimit für menschliche Züge';

  @override
  String get timeoutLoseWillBeApplied =>
      'Zeitüberschreitungsverlust wird für menschlichen Spieler angewendet';

  @override
  String get identifyingBoard => 'Spielbrett wird erkannt…';

  @override
  String get youCanEnterAnyModelName =>
      'Sie können einen beliebigen Modellnamen eingeben';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Brettstellung übernommen. FEN in die Zwischenablage kopiert.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Vorschlag: Machen Sie ein schärferes Foto des Spielbretts';

  @override
  String get llmPromptTemplate => 'LLM-Aufforderungsvorlage';

  @override
  String get noValidBoardDetected => 'Kein gültiges Spielbrett erkannt';

  @override
  String get selectingImageFromAlbum => 'Bild aus Album auswählen…';

  @override
  String get configurePromptTemplate => 'Aufforderungsvorlage konfigurieren';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Aufforderungsvorlage für LLM-Analyse bearbeiten';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Konnte kein FEN aus dem erkannten Spielbrett erzeugen';

  @override
  String get outputInCurrentLanguage => 'Ausgabe in aktueller Sprache';

  @override
  String get commonBaseUrls => 'Häufig genutzte Base URLs';

  @override
  String get viewCommonModels => 'Häufig genutzte Modelle anzeigen';

  @override
  String get recognitionParametersUpdated => 'Erkennungsparameter aktualisiert';

  @override
  String get whiteSMove => 'Zug von Weiß';

  @override
  String get resetToDefaults => 'Auf Standard zurücksetzen';

  @override
  String get photoShoot => 'Fotosession';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Konnte erkannte Brettstellung nicht übernehmen';

  @override
  String get llmPromptContent => 'LLM-Aufforderungsinhalt';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM nicht konfiguriert. Bitte prüfen Sie Ihre Einstellungen.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Anbieter, Modell, API Key und Base URL festlegen';

  @override
  String get llmConfiguration => 'LLM-Konfiguration';

  @override
  String get configureLlmProvider => 'LLM-Anbieter konfigurieren';

  @override
  String get llmPromptTemplateHeader => 'Header der LLM-Aufforderungsvorlage';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Keine Spielfiguren im Bild erkannt. Bitte erneut versuchen.';

  @override
  String get recognizeBoardFromImage => 'Spielbrett aus Bild erkennen';

  @override
  String get viewTips => 'Tipps anzeigen';

  @override
  String get applyToBoard => 'Auf Spielbrett anwenden';

  @override
  String get adjustBoardArea => 'Brettbereich anpassen';

  @override
  String get viewCommonUrls => 'Häufig genutzte URLs anzeigen';

  @override
  String get colorAnalysisFailed => 'Farbanalyse fehlgeschlagen!';

  @override
  String get analyzingGameBoardImage => 'Analyse des Spielbrettbilds…';

  @override
  String get selectFromAlbum => 'Aus Album auswählen';

  @override
  String get noBoardPointDetected => 'Kein Brettpunkt erkannt!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Wenn leer gelassen, wird die Standardvorlage verwendet';

  @override
  String get llmConfig => 'LLM-Konfiguration';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Möchten Sie die Aufforderungsvorlagen wirklich auf die Standardwerte zurücksetzen?';

  @override
  String get llmPromptTemplateFooter => 'Footer der LLM-Aufforderungsvorlage';

  @override
  String get loadingResponse => 'Antwort wird geladen…';

  @override
  String get applyThisResultToBoard =>
      'Dieses Ergebnis auf das Spielbrett anwenden';

  @override
  String get takingPicture => 'Fotoaufnahme…';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Bitte wählen Sie ein Bild des Spielbretts zur Erkennung aus';

  @override
  String get identificationResults => 'Erkennungsergebnisse';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Züge analysieren und Einsichten liefern.';

  @override
  String get getApiKey => 'API Key abrufen';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Der gesamte Erkennungsprozess konnte nicht abgeschlossen werden';

  @override
  String get boardRecognitionResult => 'Ergebnis der Spielbrett-Erkennung';

  @override
  String get askLlm => 'LLM fragen';

  @override
  String get boardDetectionFailed => 'Spielbrett-Erkennung fehlgeschlagen!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Kein Brettpunkt erkannt, Spielfigur kann nicht identifiziert werden!';

  @override
  String get copyFen => 'FEN kopieren';

  @override
  String get commonlyUsedModels => 'Häufig genutzte Modelle';

  @override
  String get apiKeyOptional => 'API Key (optional)';

  @override
  String get noImageSelected => 'Kein Bild ausgewählt';

  @override
  String get blackSMove => 'Zug von Schwarz';

  @override
  String get llm => 'Großes Sprachmodell';

  @override
  String get llmProvider => 'Anbieter';

  @override
  String get baseUrl => 'Basis-URL';

  @override
  String get model => 'Modell';

  @override
  String get temperature => 'Temperatur';

  @override
  String get llmCommandReceivedProcessing =>
      'Befehl empfangen! KI verarbeitet...';

  @override
  String get llmDeepThinkingWait => 'Tiefes Nachdenken läuft, bitte warten...';

  @override
  String get llmPresentingSoon => 'Wird in Kürze präsentiert...';

  @override
  String get recognitionParameters => 'Erkennungsparameter';

  @override
  String get adjustParamsDesc =>
      'Parameter anpassen, um die Erkennungsgenauigkeit zu verbessern';

  @override
  String get saveParameters => 'Parameter speichern';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Bilderkennung konnte nicht gestartet werden: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Bilderkennung fehlgeschlagen: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Angewendete Stellung mit $whiteCount weißen und $blackCount schwarzen Steinen';
  }

  @override
  String get fenCopiedToClipboard => '(FEN in die Zwischenablage kopiert)';

  @override
  String recognitionFailed(String error) {
    return 'Erkennung fehlgeschlagen: $error';
  }

  @override
  String get myRating => 'Meine Bewertung';

  @override
  String get gamesPlayed => 'Gespielte Spiele';

  @override
  String get wins => 'Siege';

  @override
  String get losses => 'Niederlagen';

  @override
  String get draws => 'Unentschieden';

  @override
  String get lastUpdated => 'Zuletzt aktualisiert';

  @override
  String get format => 'Format:';

  @override
  String get resetStatistics => 'Statistiken zurücksetzen';

  @override
  String get drawRate => 'Unentschiedenquote';

  @override
  String get lossRate => 'Niederlagenquote';

  @override
  String get aiStatistics => 'KI-Statistiken';

  @override
  String get enableStatistics => 'Statistiken aktivieren';

  @override
  String get enableStatistics_Detail =>
      'Wenn aktiviert, werden Spielergebnisse in den Statistiken erfasst. Spiele mit Zugrücknahmen werden jedoch nicht erfasst. Wenn deaktiviert, wird die Erfassung von Statistiken angehalten.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Dadurch werden alle Spielstatistiken zurückgesetzt. Diese Aktion kann nicht rückgängig gemacht werden.';

  @override
  String get boardInnerRingSize => 'Größe des inneren Rings des Brettes';

  @override
  String get boardShadowEnabled => 'Brettschatten';

  @override
  String get trapAwareness => 'Fallen-Erkennung';

  @override
  String get trapAwarenessDescription =>
      'Markiere Fallen-Züge während der Analyse mit fetten Kreisen und Pfeilen.';

  @override
  String trapExists(String trapMoves) {
    return 'Es gibt eine Falle. Fallen-Züge: $trapMoves';
  }

  @override
  String get custodianCapture => 'Flankierende Erfassung';

  @override
  String get custodianCaptureDescription =>
      'Schließen Sie eine der Stücke Ihres Gegners zwischen zwei Ihrer von Ihnen in einer geraden Linie ein, um ihn zu erfassen.';

  @override
  String get custodianCaptureEnable => 'Flankierende Erfassung erlauben';

  @override
  String get interventionCapture => 'Interventionserfassung';

  @override
  String get interventionCaptureDescription =>
      'Bewegen Sie sich in den leeren Punkt zwischen zwei der Stücke Ihres Gegners, um beide zu erfassen.';

  @override
  String get interventionCaptureEnable => 'Interventionserfassung erlauben';

  @override
  String get leapCapture => 'Sprungerfassung';

  @override
  String get leapCaptureDescription =>
      'Erfassen Sie, indem Sie über das Stück eines benachbarten Gegners in den leeren Punkt hinaus springen.';

  @override
  String get leapCaptureEnable => 'Sprungerfassung erlauben';

  @override
  String get captureApplicableLines => 'Anwendbare Linien';

  @override
  String get captureSquareEdges => 'Entlang der Ränder des Quadrats';

  @override
  String get captureCrossLines =>
      'Entlang orthogonaler Linien überqueren das Quadrat';

  @override
  String get captureDiagonalLines =>
      'Entlang diagonaler Linien überqueren das Quadrat';

  @override
  String get captureExecutionPhases => 'Ausführungsphasen';

  @override
  String get capturePiecesCondition =>
      'Verfügbarkeit während der Umzugsphase basierend auf verbleibenden Teilen';

  @override
  String get capturePiecesConditionUnlimited => 'Keine Einschränkung';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Erhältlich, wenn Sie drei oder weniger Stücke haben';
}

/// The translations for German, as used in Switzerland (`de_CH`).
class SDeCh extends SDe {
  SDeCh() : super('de_CH');

  @override
  String get appName => 'Mühle';

  @override
  String get welcome => 'Herzlich willkommen';

  @override
  String get yes => 'Ja';

  @override
  String get no => 'Nein';

  @override
  String get game => 'Spiel';

  @override
  String get humanVsAi => 'Mensch gegen Computer';

  @override
  String get humanVsHuman => 'Mensch gegen Mensch';

  @override
  String get aiVsAi => 'Computer gegen Computer';

  @override
  String get humanVsCloud => 'Mensch gegen Cloud';

  @override
  String get humanVsLAN => 'Mensch gegen LAN';

  @override
  String get testViaLAN => 'Test über LAN';

  @override
  String get move => 'Ziehen';

  @override
  String get showMoveList => 'Zugliste';

  @override
  String get moveList => 'Zugliste';

  @override
  String get noGameRecord => 'Keine Aufzeichnung';

  @override
  String get ok => 'OK';

  @override
  String get confirm => 'Bestätigen';

  @override
  String get cancel => 'Abbrechen';

  @override
  String get tipSelectWrong => 'Falscher Stein ausgewählt.';

  @override
  String get tipPlace => 'Setze deinen Stein.';

  @override
  String get tipBanPlace => 'Hier kannst du nicht hinsetzen.';

  @override
  String get tipPlaced => 'Platziert';

  @override
  String get tipRemove => 'Nimm einen Stein weg.';

  @override
  String get tipBanRemove => 'Kann nicht wegnehmen.';

  @override
  String get tipRemoved => 'Weggenommen.';

  @override
  String get tipMove => 'Ziehe einen Stein.';

  @override
  String get tipCannotPlace => 'Du kannst deinen Stein nicht dahin setzen.';

  @override
  String get tipCannotMove => 'Du kannst deinen Stein nicht dahin ziehen.';

  @override
  String get tipMill => 'Mühle! Nimm einen gegnerischen Stein.';

  @override
  String get tipContinueMill => 'Nimm noch einen gegnerischen Stein.';

  @override
  String get tipSelectOpponentsPiece => 'Wähle einen gegnerischen Stein.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Du kannst keinen Stein aus einer Mühle nehmen.';

  @override
  String get tipCanMoveOnePoint =>
      'Ein Stein kann nur 1 Feld weit gezogen werden.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Du kannst die gegnerischen Steine nicht bewegen.';

  @override
  String get tipSelectPieceToMove => 'Wähle deinen Stein zum Ziehen.';

  @override
  String get tipHaveThreePiecesLeft => 'Du hast noch 3 Steine übrig.';

  @override
  String get tipCanMoveToAnyPoint =>
      'Du kannst an jede beliebige Position springen.';

  @override
  String tipToMove(Object player) {
    return '$player ist an der Reihe zu ziehen.';
  }

  @override
  String get whiteWin => 'Spieler 1 gewinnt!';

  @override
  String get blackWin => 'Spieler 2 gewinnt!';

  @override
  String get won => 'Gewonnen';

  @override
  String get lost => 'Verloren';

  @override
  String get thinking => 'Denke nach…';

  @override
  String get newGame => 'Neues Spiel';

  @override
  String get importGame => 'Spiel importieren';

  @override
  String get exportGame => 'Spiel exportieren';

  @override
  String get gameImported => 'Spiel importiert.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Kann $invalidMove nicht importieren';
  }

  @override
  String get movesAndRulesNotMatch => 'Regeln und Züge stimmen nicht überein.';

  @override
  String get pleaseWait => 'Warten Sie mal...';

  @override
  String get restartGame => 'Spiel neu beginnen?';

  @override
  String get restart => 'Neustart';

  @override
  String get gameStarted => 'Spiel begonnen, bitte Stein platzieren.';

  @override
  String get analyzing => 'Analysiere…';

  @override
  String error(Object message) {
    return 'Fehler: $message';
  }

  @override
  String get winRate => 'Gewinnquote';

  @override
  String get score => 'Punkte:';

  @override
  String get white => 'Spieler 1';

  @override
  String get black => 'Spieler 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player Stückzahl ist kleiner als drei.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player hat aufgegeben.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player hat keine Möglichkeit zu gehen.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Das Board ist voll und $player hat keine Möglichkeit sich zu bewegen.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Die Zeit ist vorbei, $player hat verloren.';
  }

  @override
  String get drawReasonRule50 =>
      'In der Bewegungsphase wurde in der letzten bestimmten Anzahl von Zügen kein Stein entfernt.';

  @override
  String get drawReasonBoardIsFull => 'Unentschieden weil das Brett voll ist.';

  @override
  String get drawReasonThreefoldRepetition =>
      'Unentschieden wegen dreimaliger Wiederholung.';

  @override
  String get gameOverUnknownReason => 'Spiel vorbei! Unbekannter Grund.';

  @override
  String get gameOver => 'Spiel vorbei';

  @override
  String get youWin => 'Glückwunsch, du hast gewonnen!';

  @override
  String challengeHarderLevel(int level) {
    return 'Willst du ein schwierigeres Level wählen? Das neue Level wird Level $level sein!';
  }

  @override
  String get youLose => 'Du hast verloren!';

  @override
  String get analyze => 'Analysiere';

  @override
  String get about => 'Über';

  @override
  String version(Object versionNumber) {
    return 'Version: $versionNumber';
  }

  @override
  String get thanks => 'Danksagung';

  @override
  String get settings => 'Einstellungen';

  @override
  String get options => 'Optionen';

  @override
  String get generalSettings => 'Allgemeine Einstellungen';

  @override
  String get skillLevel => 'Schwierigkeitsstufe';

  @override
  String get moveTime => 'Bedenkzeit Computer';

  @override
  String get difficulty => 'Schwierigkeit';

  @override
  String get playSounds => 'Töne';

  @override
  String get playSoundsInTheGame => 'Töne beim Spielen abspielen';

  @override
  String get keepMuteWhenTakingBack => 'Beim Zurücknehmen stumm bleiben';

  @override
  String get tone => 'Ton';

  @override
  String get whoMovesFirst => 'Erster Zug';

  @override
  String get human => 'Mensch';

  @override
  String get ai => 'Computer';

  @override
  String get alternate => 'Abwechselnd';

  @override
  String get isAutoRestart => 'Nach Spielende automatisch neustarten';

  @override
  String get isAutoChangeFirstMove => 'Ersten Zug automatisch ändern';

  @override
  String get shufflingEnabled => 'Zufällige Züge';

  @override
  String get misc => 'Verschiedenes';

  @override
  String get rules => 'Regeln';

  @override
  String get piecesCount => 'Anzahl Steine für jeden Spieler';

  @override
  String get piecesCount_Detail => 'Wie viele Steine hat jeder Spieler?';

  @override
  String get flyPieceCount => 'Anzahl der fliegenden Steine';

  @override
  String get flyPieceCount_Detail =>
      'Wenn Fliegen aktiviert ist und ein Spieler auf eine bestimmte Steinzahl reduziert wird, können sich seine Steine frei zu jedem unbesetzten Punkt bewegen, anstatt wie im Rest des Spiels auf benachbarte Punkte beschränkt zu sein.';

  @override
  String get piecesAtLeastCount => 'Steine mindestens';

  @override
  String get hasDiagonalLines => 'Diagonale Linien';

  @override
  String get hasDiagonalLines_Detail =>
      'Vier diagonale Linien zum Brett hinzufügen.';

  @override
  String get isDefenderMoveFirst => 'Der zweite Spieler zieht zuerst';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Der in der Setzphase zweite Spieler zieht in der Zugphase zuerst.';

  @override
  String get mayRemoveMultiple => 'Mehrfaches Entfernen';

  @override
  String get mayRemoveMultiple_Detail =>
      'Wenn ein Spieler mehr als eine Mühle gleichzeitig schliesst, darf er entsprechend viele Steine entfernen.';

  @override
  String get mayRemoveFromMillsAlways => 'Mühlen zerstören';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Normalerweise müssen Spieler alle freien Steine entfernen, bevor Steine aus einer Mühle entfernt werden dürfen. Diese Option hebt diese Beschränkung auf.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Zweiter Spieler verliert wenn das Brett voll ist';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Wenn das Brett am Ende der Setzphase voll ist, verliert der Spieler, der zuerst gezogen hat. Sonst unentschieden.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Verlieren wenn kein Zug möglich ist';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Der Spieler verliert, wenn der Gegner ihn so blockiert, dass er keinen Steine mehr bewegen kann. Wenn die Option deaktiviert ist wird die Seite gewechselt.';

  @override
  String get mayFly => 'Fliegen';

  @override
  String get mayFly_Detail =>
      'Wenn ein Spieler nur noch drei Steine hat, darf ein Stein an beliebige Punkte gezogen werden.';

  @override
  String get nMoveRule => 'N-Züge-Regel';

  @override
  String get nMoveRule_Detail =>
      'Das Spiel ist unentschieden, wenn in einer bestimmten Anzahl von Zügen von jedem Spieler keine Entfernung erfolgt ist.';

  @override
  String get rollback => 'Zurücksetzen';

  @override
  String get pleaseSelect => 'Bitte auswählen';

  @override
  String get copy => 'Kopieren';

  @override
  String get moveHistoryCopied =>
      'Zugverlauf wurde in die Zwischenablage kopiert.';

  @override
  String get help => 'Hilfe';

  @override
  String get feedback => 'Rückmeldung';

  @override
  String get exit => 'Beenden';

  @override
  String get ruleSettings => 'Regeln';

  @override
  String get color => 'Farben';

  @override
  String get boardColor => 'Brettfarbe';

  @override
  String get pieceColor => 'Steinfarbe';

  @override
  String get backgroundColor => 'Hintergrundfarbe';

  @override
  String get lineColor => 'Linienfarbe';

  @override
  String get whitePieceColor => 'Steinfarbe Spieler 1';

  @override
  String get blackPieceColor => 'Steinfarbe Spieler 2';

  @override
  String get messageColor => 'Nachrichtenfarbe';

  @override
  String get isPieceCountInHandShown =>
      'Anzahl an Steinen auf der Hand anzeigen';

  @override
  String get isNotationsShown => 'Notizen auf dem Brett anzeigen';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Symbolleiste für die Verlaufsnavigation anzeigen';

  @override
  String get display => 'Darstellung';

  @override
  String get boardBorderLineWidth => 'Linienbreite Spielbrettrand';

  @override
  String get boardInnerLineWidth => 'Innere Linienbreite des Spielbrettes';

  @override
  String get pieceWidth => 'Steingrösse';

  @override
  String get fontSize => 'Schriftgrösse';

  @override
  String get standardNotation => 'WMD-Notation';

  @override
  String get restore => 'Wiederherstellen';

  @override
  String get restoreDefaultSettings => 'Standardeinstellungen wiederherstellen';

  @override
  String pick(Object element) {
    return '$element nehmen';
  }

  @override
  String get info => 'Info';

  @override
  String get hint => 'Hinweis';

  @override
  String get player => 'Spieler';

  @override
  String get player1 => 'Spieler 1';

  @override
  String get player2 => 'Spieler 2';

  @override
  String get howToPlay => 'Spielanleitung';

  @override
  String get toPlacePiece =>
      'Tippe auf einen freien Punkt, um den Stein zu setzen.';

  @override
  String get toSelectPiece => 'Tippe auf einen Stein, um ihn zu ziehen.';

  @override
  String get toMovePiece =>
      'Tippe auf einen mit einem Stein verbundenen Punkt, um ihn zu ziehen.';

  @override
  String get toRemovePiece =>
      'Tippe auf einen gegnerischen Stein, um ihn zu entfernen.';

  @override
  String get needToCreateMillFirst =>
      'Du musst erst eine Mühle machen, bevor du einen Stein entfernen kannst.';

  @override
  String get needToPlayWithOwnPieces =>
      'Du musst mit deinen eigenen Steinen spielen.';

  @override
  String get statistics => 'Statistiken';

  @override
  String get totalGames => 'Gesamtzahl Spiele';

  @override
  String get results => 'Ergebnisse';

  @override
  String get left => 'links';

  @override
  String get privacyPolicy => 'Datenschutzerklärung';

  @override
  String get privacyPolicy_Detail_1 =>
      'Bitte lies sorgfältig und stelle sicher, dass du alles verstanden hast und zustimmst ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Wenn du den Bestimmungen nicht zustimmst, darfst du diese App nicht benutzen. Die Benutzung der App impliziert, dass du diesen Bestimmungen zustimmst.';

  @override
  String get and => ' und ';

  @override
  String get accept => 'Akzeptieren';

  @override
  String get takeBack => 'Zurücknehmen';

  @override
  String get takingBack => 'Nehme zurück…';

  @override
  String get waiting => 'Warte…';

  @override
  String get stepForward => 'Schritt vorwärts';

  @override
  String get takeBackAll => 'Alles zurücknehmen';

  @override
  String get stepForwardAll => 'Alles wiederholen';

  @override
  String get moveNow => 'Jetzt ziehen';

  @override
  String get done => 'Fertig.';

  @override
  String get crackMill => 'Crack-Mühle';

  @override
  String get crackMill_Detail =>
      'Wenn ein Spieler nur Steine in Mühlen hat, können diese Steine entfernt werden.';

  @override
  String get animationDuration => 'Animationsdauer';

  @override
  String get none => 'Kein';

  @override
  String get theme => 'Thema';

  @override
  String get helpContent =>
      'Das Ziel des Spiels ist es, dass der Gegner weniger als drei Steine hat oder sich nicht mehr bewegen kann.\n\nDas Spiel endet automatisch unentschieden, wenn eine Spielposition das dritte Mal auftritt, oder wenn in den letzten 100 (konfigurierbar) Zügen kein Stein entfernt wurde.\n\nDas Spiel läuft in drei Phasen ab:\n\n1. Steine auf freie Punkte setzen\n2. Steine auf angrenzende Punkte schieben\n3. (optionale Phase) Steine auf beliebige freie Punkte setzen wenn der Spieler nur noch drei Steine hat\n\nSetzphase\n\nDas Spiel beginnt mit einem leeren Spielbrett, das aus einem Gitter mit vierundzwanzig Punkten besteht. Die Spieler setzen abwechselnd Steine auf freie Punkte, bis jeder Spieler alle Steine gesetzt hat. Wenn ein Spieler drei Steine in einer geraden Linie setzt, dann hat er eine „Mühle“ und darf einen gegnerischen Stein vom Spielbrett nehmen.\n\nIn einigen Regelvarianten müssen die Spieler alle anderen Steine entfernen, bevor ein Stein aus einer Mühle genommen werden kann.\n\nIn einigen Regelvarianten dürfen Steine in der Setzphase nicht wieder auf Punkte gesetzt werden, von denen bereits Steine genommen wurden.\n\nWenn alle Steine gesetzt worden sind, ziehen die Spieler abwechselnd einen Stein.\n\nZugphase\n\nBeim Ziehen bewegt ein Spieler einen seiner Steine entlang einer Linie zum nächsten freien Punkt. Wenn er das nicht kann, hat er verloren. Genau wie in der Setzphase führen drei Steine in einer Linie zu einer Mühle, und der Spieler darf einen der gegnerischen Steine entfernen. Ein Spieler mit nur zwei Steinen kann keine Mühlen mehr bekommen und verliert deshalb. Ein Spieler kann auch mit mehr als drei Steinen verlieren, wenn sein Gegner ihn so blockiert hat, dass er seine Steine nicht mehr bewegen kann.\n\nEndphase\n\nIn einigen Regelvarianten kann ein Spieler, dem nur noch drei Steine verbleiben, mit seinen Steinen auf jeden freien Punkt „fliegen“, „hüpfen“ oder „springen“, nicht nur auf benachbarte.\n';

  @override
  String get versionInfo => 'Versionsinformationen';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'Lizenz';

  @override
  String get sourceCode => 'Quellcode';

  @override
  String get appVersion => 'App-Version';

  @override
  String get general => 'Generell';

  @override
  String get advanced => 'Fortgeschritten';

  @override
  String get placing => 'Setze';

  @override
  String get moving => 'Bewege';

  @override
  String get removing => 'Entferne';

  @override
  String get gameOverCondition => 'Spielendebedingung';

  @override
  String get aisPlayStyle => 'Spielstil des Computers';

  @override
  String get passive => 'Passiv';

  @override
  String get timeout => 'Zeitlimit';

  @override
  String get appearance => 'Aussehen';

  @override
  String get drawOnHumanExperience => 'Auf menschliche Erfahrung zurückgreifen';

  @override
  String get considerMobility => 'Verbessern Sie die Beweglichkeit von Steinen';

  @override
  String get pieceCount => 'Anzahl Steine:';

  @override
  String inHand(Object player, int count) {
    return '$player in der Hand: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player auf dem Bord: $count';
  }

  @override
  String get boardTop => 'Abstand Spielbrett von oben';

  @override
  String get notAIsTurn => 'Der Computer ist nicht am Zug.';

  @override
  String get aiIsNotThinking => 'Computer denkt nicht.';

  @override
  String get atEnd => 'Am Ende der Spielzugliste.';

  @override
  String get tapBackAgainToLeave => 'Nochmal drücken, um zu beenden.';

  @override
  String get more => 'Mehr';

  @override
  String get experimental => 'Dies ist eine experimentelle Funktion.';

  @override
  String get experiments => 'Experimente';

  @override
  String get ossLicenses => 'Quelloffene Lizenzen';

  @override
  String get language => 'Sprache';

  @override
  String get defaultLanguage => 'Standardsprache';

  @override
  String get mayMoveInPlacingPhase =>
      'Die Steine können sich in der Setzphase bewegen';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Es gibt keine getrennten Setz- und Zugphasen, d.h. die Spieler können bei jedem Zug entscheiden, ob sie einen Stein auf dem Brett setzen oder einen ihrer Steine bewegen wollen (solange sie noch Steine zum Setzen haben).';

  @override
  String get drawerColor => 'Menüfarbe';

  @override
  String get drawerTextColor => 'Menütextfarbe';

  @override
  String get drawerHighlightItemColor => 'Farbe des Menümarkierungselements';

  @override
  String get mainToolbarBackgroundColor =>
      'Hintergrundfarbe der Hauptsymbolleiste';

  @override
  String get mainToolbarIconColor => 'Symbolfarbe der Hauptsymbolleiste';

  @override
  String get navigationToolbarBackgroundColor =>
      'Hintergrundfarbe der Navigationsleiste';

  @override
  String get navigationToolbarIconColor =>
      'Symbolfarbe der Navigationssymbolleiste';

  @override
  String get autoHideToolbar => 'Symbolleiste automatisch ausblenden';

  @override
  String get toolbarLocationOnScreen =>
      'Position der Symbolleiste auf dem Bildschirm';

  @override
  String get top => 'Oben';

  @override
  String get bottom => 'Unterseite';

  @override
  String get center => 'Mitte';

  @override
  String get solidColor => 'Einfarbig';

  @override
  String get picture => 'Bild';

  @override
  String get chooseYourPicture => 'Wähle dein Bild';

  @override
  String get light => 'Hell';

  @override
  String get dark => 'Dunkel';

  @override
  String get themes => 'Themen';

  @override
  String get currentTheme => 'Aktuelles Thema';

  @override
  String get saveTheme => 'Thema speichern';

  @override
  String get showAnalysisGraph => 'Analysegrafik anzeigen';

  @override
  String get analysis => 'Analyse';

  @override
  String get saveGame => 'Spiel speichern';

  @override
  String get loadGame => 'Spiel laden';

  @override
  String get setupPosition => 'Aufstellungsposition';

  @override
  String get showLegalMoves => 'Legale Züge anzeigen';

  @override
  String get showLastMove => 'Letzten Zug anzeigen';

  @override
  String get showArrows => 'Pfeile zeigen';

  @override
  String get pieces => 'Stücke';

  @override
  String get showAnalysis => 'Analyse anzeigen';

  @override
  String get threads => 'Threads';

  @override
  String get getInvolved => 'Machen Sie mit';

  @override
  String get helpImproveTranslate =>
      'Helfen Sie mit, die Übersetzung zu verbessern';

  @override
  String get tutorial => 'Lernprogramm';

  @override
  String get classicMill => 'Klassische Mühle';

  @override
  String get mixedMill => 'Gemischte Mühle';

  @override
  String get ceylonMill => 'Ceylon-Mühle';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Mühle kann wiederholt gebrochen und neu hergestellt werden';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Wenn ein Spieler eine Mühle zerstört, um sofort eine neue Mühle zu bauen, kann dieser Spieler diesen Stein in seinem nächsten Zug zurück zur ursprünglichen Kreuzung bewegen, wenn er eine neue Mühle baut.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Das Spiel ist unentschieden, wenn ein Spieler drei Steine hat und nach zehn Zügen keiner der Spieler die Steine des Gegners entfernt remove';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Wenn ein Spieler nur noch drei Steine übrig hat und keiner der Spieler einen gegnerischen Stein innerhalb von zehn Zügen entfernen kann, ist das Spiel unentschieden.';

  @override
  String get close => 'Schliessen Sie';

  @override
  String get whitePiece => 'Weisser Stein';

  @override
  String get blackPiece => 'Schwarzer Stein';

  @override
  String get emptyPoint => 'Leere Stelle';

  @override
  String get noPoint => 'Kein Punkt';

  @override
  String get placingPhase => 'Setzphase';

  @override
  String get movingPhase => 'Bewegungsphase';

  @override
  String get flyingPhase => 'Flugphase';

  @override
  String sideToMove(Object player) {
    return 'Seite zum Bewegen: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Letzter Zug: $move';
  }

  @override
  String get selected => 'Ausgewählt';

  @override
  String get accessibility => 'Barrierefreiheit';

  @override
  String get screenReaderSupport => 'Unterstützung für Bildschirmlesegeräte';

  @override
  String get isDraw => 'Es ist ein Unentschieden!';

  @override
  String get draw => 'Unentschieden';

  @override
  String get pieceHighlightColor => 'Farbe des Stein-Highlights';

  @override
  String get algorithm => 'Algorithmus';

  @override
  String get endgameNMoveRule => 'Endspiel N-Züge-Regel';

  @override
  String get endgameNMoveRule_Detail =>
      'Wenn einer der beiden Spieler nur drei Steine hat und keiner der beiden Spieler innerhalb eines bestimmten Zuges einen Stein entfernt, ist das Spiel unentschieden.';

  @override
  String get drawReasonEndgameRule50 =>
      'Jeder der beiden Spieler hat nur drei Steine und keiner der beiden Spieler entfernt einen Stein innerhalb eines bestimmten Zuges.';

  @override
  String get threefoldRepetitionRule => 'Dreifache Wiederholungsregel';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Das Spiel ist unentschieden, wenn eine Stellung zum dritten Mal auftritt.';

  @override
  String get continueToMakeMove => 'Mühle! Bewegen Sie sich weiter.';

  @override
  String get pointStyle => 'Punkt-Stil';

  @override
  String get pointWidth => 'Breite der Punkte';

  @override
  String get solid => 'Solide';

  @override
  String get hollow => 'Hohle';

  @override
  String get languageName => 'Schweizer Hochdeutsch';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Züge',
      one: '$count Zug',
      zero: 'Zug',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Laden fehlgeschlagen.';

  @override
  String get filename => 'Dateiname';

  @override
  String get browse => 'Durchsuchen…';

  @override
  String get gameFiles => 'Spiel-Dateien';

  @override
  String get gameSavedTo => 'Das Spiel wird gespeichert unter';

  @override
  String get empty => 'Leer';

  @override
  String get noMove => 'Keine Bewegung.';

  @override
  String get restoredPosition => 'Ausgangsposition wiederhergestellt.';

  @override
  String get clean => 'Leeren';

  @override
  String get cleanedUp => 'Aufgeräumt.';

  @override
  String get remove => 'Entfernen';

  @override
  String get noPiecesCanBeRemoved => 'Es können keine Teile entfernt werden.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Steine',
      one: '$count Stein',
      zero: 'Stein',
    );
    return '$_temp0 müssen entfernt werden.';
  }

  @override
  String placedCount(int count) {
    return 'Pzt ($count)';
  }

  @override
  String get placedPieceCount =>
      'Platzierte Stückzahl in der Platzierungsphase.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'Der aktuelle Spieler hat $count Steine platziert.';
  }

  @override
  String get notPlacingPhase =>
      'Nicht in der Platzierungsphase, kann nicht geändert werden.';

  @override
  String get paste => 'Einfügen';

  @override
  String get pasteDone => 'Einfügen abgeschlossen.';

  @override
  String get cannotPaste => 'Kann nicht einfügen.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Nicht platzierte und entfernte Steine anzeigen';

  @override
  String get fullScreen => 'Vollbild';

  @override
  String get reopenToTakeEffect =>
      'Die App beenden und erneut Öffnen, damit die Einstellungen wirksam werden.';

  @override
  String get forest => 'Wald';

  @override
  String get desktopImage => 'Desktop-Bild';

  @override
  String get invalidPosition => 'Ungültige Position.';

  @override
  String get shareGIF => 'GIF teilen';

  @override
  String get pixelRatio => 'Pixelverhältnis';

  @override
  String get duration => 'Dauer';

  @override
  String get gameScreenRecorder => 'Bildschirmrekorder für Spiele';

  @override
  String get previous => 'Vorherige';

  @override
  String get next => 'Nächste';

  @override
  String get skip => 'Überspringen';

  @override
  String get gotIt => 'Verstanden';

  @override
  String get youCanModifyRules =>
      'Du kannst die Spielregeln in den Regeleinstellungen ändern.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Du kannst den Wert in der Auswahl mit dem Mausrad ändern.';

  @override
  String get noTimeLimitForThinking =>
      'KI-Denkzeit auf 0 gesetzt bedeutet, dass es keine Zeitbegrenzung für das Denken gibt.';

  @override
  String get whatIsMtdf =>
      'MTD(f) ist eine modifizierte Form des Alpha-Beta-Suchalgorithmus, der darauf abzielt, die Effizienz zu verbessern, indem Zwischenergebnisse wiederverwendet werden und eine gute Anfangsschätzung verwendet wird, um den Suchraum einzugrenzen.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Bitte beachte, dass die Anpassung der KI-Denkzeit möglicherweise nicht ganz genau ist. Die tatsächliche Bedenkzeit kann kürzer sein, wenn der Schwierigkeitsgrad auf einen niedrigeren Wert eingestellt ist, und kann länger sein, wenn die KI mitten im Denken ist, wenn die Zeit abläuft.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Wenn Sie den Schwierigkeitsgrad hoch einstellen, aber die KI-Denkzeit nicht erhöhen, kann der tatsächliche Schwierigkeitsgrad aufgrund der Bedenkzeitbeschränkung auf einen niedrigeren Wert begrenzt werden. Der tatsächliche Wert kann je nach Leistung der Maschine variieren.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) ist ein Suchalgorithmus, um den besten Zug in einer bestimmten Stellung zu finden. Es ist eine Verbesserung des Alpha-Beta-Algorithmus und verwendet Null- oder Nullfenstersuchen, um zu bestätigen, dass ein Zug schlechter oder nicht schlechter ist als ein bereits sicheres Ergebnis aus der Hauptvariante. PVS konzentriert sich auf die vielversprechendsten Züge und vermeidet unnötige Suchen suboptimaler Verzweigungen, wodurch die Effizienz der Suche verbessert wird.';

  @override
  String get whatIsAlphaBeta =>
      'Der Alpha-Beta-Algorithmus ist ein Suchalgorithmus, um den besten Zug zu finden. Es verwendet das Mini-Max-Prinzip und zwei Werte, Alpha und Beta, um den Suchbaum zu verkürzen und die Effizienz zu steigern. Alpha stellt die minimale Punktzahl dar, die der Computer sicher erreichen kann, während Beta die maximale Punktzahl darstellt, die sein Gegner erzielen kann. Der Algorithmus hilft dem Computer, intelligente und effiziente Entscheidungen in einem Spiel zu treffen.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Nach menschlicher Erfahrung werden Sie verlieren, wenn Sie versuchen zu gewinnen. Wir empfehlen stattdessen ein Unentschieden als Ziel anzustreben und es zu vermeiden es, das Spiel zu verlieren. Beobachten Sie Ihren Gegner und locken Sie ihn sanft in eine Position, in der er Fehler machen kann. Wenn sie Schwäche zeigen, nutzen Sie die Gelegenheit und drängen Sie sanft auf den Sieg. Auf diese Weise können Sie das Spiel gewinnen.';

  @override
  String get firstMoveDetail =>
      'In diesem Spiel hat der zweite Spieler leichter die Chance zu gewinnen als der erste.';

  @override
  String get passiveDetail =>
      'Die Aktivierung der passiven Option bewirkt, dass sich die KI entspannt, wenn sie einen Vorteil in der Position hat, anstatt aggressiv zu versuchen, so schnell wie möglich zu gewinnen.';

  @override
  String get moveRandomlyDetail =>
      'Das Aktivieren dieser Option erhöht die Zufälligkeit und den Spass des Spiels, während das Deaktivieren dazu beitragen kann, Wege zu finden, die KI zu schlagen.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Wenn die KI die Beweglichkeit ihrer Steine berücksichtigt, wird sie nicht nur versuchen, die Steine des Gegners so schnell wie möglich zu erobern, sondern auch die Bewegungen des Gegners blockieren und verhindern, dass dieser das Gleiche tut.';

  @override
  String get whenBoardIsFull => 'Wenn das Brett voll ist';

  @override
  String get whenBoardIsFull_Detail =>
      'Am Ende der Platzierungsphase, bevor die Bewegungsphase beginnt, folgt die Aktion, wenn der Spielplan voller Steine ist.';

  @override
  String get sideToMoveRemovePiece =>
      'Der Spieler, der sich in der Bewegungsphase zuerst bewegt, entfernt einen der Steine des Gegners.';

  @override
  String get agreeToDraw => 'Beide Seiten einigen sich auf ein Unentschieden.';

  @override
  String get takeOpponentsPiece => 'Nimm einen der Steine deines Gegners.';

  @override
  String get firstPlayerLose => 'Der erste Spieler verliert das Spiel.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Der erste und der zweite Spieler entfernen einen der Steine des Gegners.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Der zweite und der erste Spieler entfernen einen der Steine des Gegners.';

  @override
  String get enteredFlyingPhase =>
      'Jetzt in die Flugphase eingetreten, können die Figuren des Gegners zu jedem leeren Punkt auf dem Brett springen. Sie können die Flugregel in den \"Regeln\" deaktivieren.';

  @override
  String get whenStalemate => 'Bei Patt';

  @override
  String get whenStalemate_Detail =>
      'Was passiert, wenn kein Stein bewegt werden kann?';

  @override
  String get endWithStalemateLoss =>
      'Beenden Sie mit einem Pattverlust für die Seite, die blockiert ist.';

  @override
  String get changeSideToMove => 'Wechsle die Seite, um dich zu bewegen.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Entfernen Sie einen der Steine des Gegners und machen Sie den nächsten Zug.';

  @override
  String get endWithStalemateDraw =>
      'Beenden Sie mit einem Patt-Unentschieden.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Entferne einen der gegnerischen Steine und wechsle die Seite, um dich zu bewegen.';

  @override
  String get aiResponseDelayTime => 'KI-Antwortverzögerungszeit';

  @override
  String get aiIsDelaying =>
      'KI befindet sich derzeit in einer verzögerten Reaktionsphase. Bitte warten Sie eine Weile, bevor Sie fortfahren.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Sie können keinen nicht angrenzenden Stein entfernen.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'Bei einer Patt-Situation können die an deine angrenzenden Steine des Gegners unabhängig von der Mühlen-Formation entfernt werden.';

  @override
  String get whatIsMcts =>
      'MCTS ist ein anfängerfreundlicher Algorithmus, der Entscheidungen trifft, indem er verschiedene Bewegungen durch Simulationen untersucht und bewertet.';

  @override
  String get goldenJade => 'Goldene Jade';

  @override
  String get forestWood => 'Waldholz';

  @override
  String get darkMystery => 'Dunkles Geheimnis';

  @override
  String get midnightBlue => 'Mitternachtsblau';

  @override
  String get greenForest => 'Grüner Wald';

  @override
  String get greenMeadow => 'Grüne Wiese';

  @override
  String get stonyPath => 'Steiniger Weg';

  @override
  String get pastelPink => 'Pastellrosa';

  @override
  String get turquoiseSea => 'Türkises Meer';

  @override
  String get violetDream => 'Violetter Traum';

  @override
  String get mintChocolate => 'Minz-Schokolade';

  @override
  String get skyBlue => 'Himmelblau';

  @override
  String get playfulGarden => 'Verspielter Garten';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Der Retrograde-Analyse-Algorithmus verwendet eine mehrwertige Retrograde-Analyse, um eine Endspieldatenbank aus verschiedenen Startpositionen zu erstellen, und wendet diese Datenbank dann an, um das Gameplay zu optimieren. Dieser Ansatz fällt in die Kategorie der ultrastarken Lösungen.';

  @override
  String get viewAlgorithmGuide =>
      'Möchten Sie das Benutzerhandbuch für diesen Algorithmus anzeigen?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Anzeige des Positionsvorteilsindikators';

  @override
  String get usePerfectDatabase => 'Verwenden Sie die perfekte Datenbank';

  @override
  String get perfectDatabaseDescription =>
      'Aktivieren Sie diese Option, um eine fehlerfreie Spiel-Datenbank zu nutzen, die durch modernste Algorithmen generiert wurde. Diese Funktion integriert sowohl Eröffnungs- als auch Endspielstrategien, um optimale Züge vorzuschlagen. Sie ist die bevorzugte Wahl für Spieler, die das höchste Mass an Präzision im Spiel anstreben. Durch akribische Berechnungstechniken erstellt, ist die Datenbank darauf ausgelegt, nahezu perfekte Spiellösungen anzubieten.\n\nHinweis: Sollte die KI keinen Zugriff auf die Datenbank haben, wird sie auf herkömmliche Algorithmen für Spielentscheidungen zurückgreifen. Ist die Datenbank verfügbar, wird der \'Schwierigkeitsgrad\' praktisch unschlagbar und die \'Denkzeit der KI\' erheblich reduziert. Viele Einstellungen im Bereich \'Spielstil der KI\' werden überschrieben, da die Ergebnisse der Datenbank höchste Priorität haben.\n\nFür Anleitungen zur optimalen Nutzung dieser fehlerfreien Datenbank klicken Sie bitte hier.';

  @override
  String get backgroundImage => 'Hintergrundbild';

  @override
  String get whatIsRandom =>
      'Wenn die Option \'Perfekte Datenbank verwenden\' nicht aktiviert ist, bewirkt die Einstellung \'Zufällig\', dass die KI die Figuren zufällig bewegt, ohne Algorithmen für die Zugauswahl zu verwenden. Dies führt typischerweise zu deutlich schwächerem Spielverhalten. Im Gegensatz dazu verlässt sich die KI bei Aktivierung der Option \'Perfekte Datenbank verwenden\' ausschliesslich auf die \'Perfekte Datenbank\' für Entscheidungen, anstatt sie mit traditionellen KI-Algorithmen zu kombinieren. In diesem Modus basieren die Züge der KI vollständig auf dem Inhalt der Datenbank und verzichten auf die Abhängigkeit von Echtzeitberechnungen oder Suchalgorithmen.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Nimm dem Gegner si Figur(e) us dr Hand; dänn isch es dr Gegner si Zug zum Setze.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Wenn Mühle bildet werdet während dr Platzierigsphase';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Nimm dem Gegner si Figur(e) vom Spiilbrett.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Nimm dem Gegner si Figur(e) vom Spiilbrett; dänn isch es dr Gegner si Zug zum Setze.';

  @override
  String get opponentRemovesOwnPiece =>
      'Dr Gegner nimmt sini eigene Figur(e) vom Spiilbrett.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Statt dass du en Zug machsch, wählt dr Gegner us und nimmt sini eigene Figur(e) vom Spiilbrett, was effektiv en Zug isch, wo ihm selber schadet.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Nimm dem Gegner si Figur(e) us dr Hand; dänn isch es diin Zug zum Bewege.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Nimm Figur(e) us dem Gegner si Hand. Wenn, gemäss dr Multi-Entfernigs-Iistellig, mehreri Figure solle entfernt werde und dr Gegner het kei Figure meh i dr Hand, fahre fort mit em Entferne vom Gegner si Figure vom Spiilbrett. Dänn isch es diin Zug zum Bewege. Wenn du witersch Mühle bildsch, chasch witersch dem Gegner si Figure entferne.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Nimm Figur(e) us dem Gegner si Hand. Wenn, gemäss dr Multi-Entfernigs-Iistellig, mehreri Figure solle entfernt werde und dr Gegner het kei Figure meh i dr Hand, fahre fort mit em Entferne vom Gegner si Figure vom Spiilbrett. Dänn isch es dr Gegner si Zug zum Bewege.';

  @override
  String get markAndDelayRemovingPieces =>
      'Markier und verzöger s Entferne vo de Figure.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Während dr Platzierigsphase werdet d Figure, wo entfernt werdet solle, markiert, und für beidi Spieler chöi kei neue Figure uf diese Punkt gsetzt werde. Wenn in d Bewegigsphase igtrete wird, werdet diese markierte Figure alli zäme entfernt, und d Spieler chönne denn ihri Figure uf diese jetz leere Punkte bewege.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Die Aktionen, die beim Formen von Mühlen während der Platzierungsphase unternommen werden können.';

  @override
  String get marked => 'Markiert';

  @override
  String get menu => 'Menü';

  @override
  String get monochrome => 'Monochrom';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Sie können die Unterstützung für den Bildschirmleser in den Barrierefreiheitseinstellungen unter Allgemeine Einstellungen aktivieren.';

  @override
  String get showNumbersOnPieces => 'Zahlen auf Steinen anzeigen';

  @override
  String get saveImage => 'Bild speichern';

  @override
  String get isAnalysisToolbarShown => 'Analysetools anzeigen';

  @override
  String get analysisToolbarBackgroundColor =>
      'Hintergrundfarbe der Analysetools';

  @override
  String get analysisToolbarIconColor => 'Symbolfarbe der Analysetools';

  @override
  String get transformed => 'Transformiert.';

  @override
  String get cannotTransform => 'Kann nicht transformiert werden.';

  @override
  String get rotate => 'Rotieren';

  @override
  String get horizontalFlip => 'H.S.';

  @override
  String get verticalFlip => 'V.S.';

  @override
  String get innerOuterFlip => 'I/A S.';

  @override
  String get transparentCanvas => 'Transparenter Hintergrund';

  @override
  String get restrictRepeatedMillsFormation =>
      'Wiederholte Mühlebildung einschränken';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Ein Spielstein, der von einer Mühle zu einer anderen verschoben wurde, kann nicht sofort auf den ursprünglichen Punkt im nächsten Zug zurückkehren, um wieder eine Mühle zu bilden. Zuerst ist ein anderer Zug erforderlich.';

  @override
  String get oneTimeUseMill => 'Einmalige Nutzung Mühle';

  @override
  String get oneTimeUseMill_Detail =>
      'Jede Mühle kann nur ein gegnerisches Teil einmal entfernen. Sie können es erneut formen, aber es kann nicht für zusätzliche Entfernungen verwendet werden.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Die aktuellen Regeln, die Sie festgelegt haben, haben keine entsprechende perfekte Datenbank. Für weitere Informationen zur perfekten Datenbank klicken Sie bitte hier.';

  @override
  String get focusOnBlockingPaths => 'Auf Wegblockierung fokussieren';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Während bestimmter Phasen des Spiels, priorisieren Sie das Blockieren der Bewegungen des Gegners über das Bilden von Mühlen. Anstatt sich darauf zu konzentrieren, Steine durch das Vervollständigen von Mühlen zu entfernen, zielt die KI während dieser Phasen darauf ab, den Gegner zu fangen, sodass er sich nicht bewegen kann und einen Sieg durch Abnutzung statt durch aggressives Spiel sichert. Diese phasenspezifische Strategie blockiert nicht aktiv die Mühlen des Gegners.';

  @override
  String get pieceImage => 'Figurenbild';

  @override
  String get importColorSettings => 'Farbeinstellungen importieren';

  @override
  String get exportColorSettings => 'Farbeinstellungen exportieren';

  @override
  String get import => 'Importieren';

  @override
  String get export => 'Exportieren';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Bitte kopieren Sie zuerst die JSON-Format-Einstellungen in die Zwischenablage.';

  @override
  String get copiedToClipboard => 'In die Zwischenablage kopiert.';

  @override
  String get imported => 'Importiert.';

  @override
  String get boardImage => 'Brettbild';

  @override
  String get autumnLeaves => 'Herbstblätter';

  @override
  String get legendaryLand => 'Legendäres Land';

  @override
  String get vignetteEffect => 'Vignettierungseffekt';

  @override
  String get promptMakeToolbarTransparent =>
      'Möchten Sie die Werkzeugleiste vollständig transparent machen, wenn ein Hintergrundbild für das Board festgelegt ist?';

  @override
  String get vibration => 'Vibration im Spiel aktivieren';

  @override
  String get soundTheme => 'Soundthema';

  @override
  String get ball => 'Ball';

  @override
  String get liquid => 'Flüssigkeit';

  @override
  String get wood => 'Holz';

  @override
  String get placeEffectAnimation =>
      'Animationseffekt beim Platzieren von Spielfiguren';

  @override
  String get removeEffectAnimation =>
      'Animationseffekt beim Entfernen von Spielfiguren';

  @override
  String get isToolbarAtBottom => 'Werkzeugleiste unten anzeigen';

  @override
  String get boardCornerRadius => 'Eckenradius des Boards';

  @override
  String get useOpeningBook => 'Eröffnungsbuch verwenden';

  @override
  String get currentRule => 'Aktuell';

  @override
  String get nineMensMorris => 'Nünistei';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Regelset';

  @override
  String get laskerMorris => 'Lasker-Mühle';

  @override
  String get oneTimeMill => 'Einmal-Mühle';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'Lassen Sie die KI Eröffnungszüge verwenden, die üblicherweise von professionellen menschlichen Spielern im frühen Spiel verwendet werden. Hinweis: Diese Funktion ist derzeit nur für bestimmte Regelsets verfügbar.';

  @override
  String get showAdvantageGraph => 'Vorteilsdiagramm anzeigen';

  @override
  String get advantageGraphHint =>
      'Der Vorteilgraph wird nur gezeichnet, nachdem die KI einen Zug gemacht hat. Er wird nicht gezeichnet, wenn der menschliche Spieler einen Zug macht.';

  @override
  String get removalBasedOnMillCounts =>
      'Deaktiviere das Entfernen, bis alle Steine platziert sind, dann entferne Steine basierend auf der Anzahl der Mühlen.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Deaktiviere das Entfernen, bis alle Steine platziert sind, dann entferne Steine basierend auf der Anzahl der Mühlen: Sind sie gleich, entfernen beide die gleiche Anzahl. Hat einer mehr, entfernt er einen zusätzlichen Stein, um einen Unterschied von einem Stein beizubehalten. Bildet nur einer Mühlen, entfernt dieser zwei Steine und der andere einen. Bildet keiner Mühlen, entfernen beide jeweils einen Stein.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Wähle einen deiner Steine aus.';

  @override
  String get notYourTurn => 'Du bist nicht am Zug.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Hintergrundfarbe der Annotationswerkzeugleiste';

  @override
  String get annotationToolbarIconColor =>
      'Symbolfarbe der Annotationswerkzeugleiste';

  @override
  String get isAnnotationToolbarShown => 'Annotationswerkzeugleiste anzeigen';

  @override
  String get enterAnnotationMode => 'Annotationsmodus betreten';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Möchten Sie wirklich alle Anmerkungen löschen?';

  @override
  String get llmPromptCopiedToClipboard =>
      'LLM-Aufforderung in die Zwischenablage kopiert.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Verbindung verweigert, der Server ist möglicherweise ausgefallen.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Erkennung erfolgreich, warte auf Verbindung...';

  @override
  String get noLanConnection => 'Keine LAN-Verbindung';

  @override
  String get takeScreenshot => 'Screenshot erstellen';

  @override
  String get disconnectedFromOpponent => 'Vom Gegner getrennt.';

  @override
  String get takeBackRequest => 'Rücknahmeanforderung';

  @override
  String get nothingToShow => 'Nichts anzuzeigen.';

  @override
  String get stopHosting => 'Hosting beenden';

  @override
  String get connectionResetByPeer =>
      'Verbindung durch Gegenstelle zurückgesetzt.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Verbindung verloren durch Zeitüberschreitung (Heartbeat). Bitte erneut verbinden.';

  @override
  String get startHosting => 'Hosting starten';

  @override
  String get restartRequestRejected => 'Neustartanfrage abgelehnt.';

  @override
  String get notConnectedToLanOpponent => 'Nicht mit LAN-Gegner verbunden.';

  @override
  String get llmPrompt => 'LLM-Prompt';

  @override
  String get gameRestarted => 'Spiel neu gestartet.';

  @override
  String get takeBackRejected => 'Rücknahme abgelehnt.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Sind Sie sicher, dass Sie dieses Spiel aufgeben möchten?';

  @override
  String get opponentResignedYouWin => 'Gegner hat aufgegeben. Sie gewinnen!';

  @override
  String get clearAllAnnotations => 'Alle Anmerkungen löschen';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Verbunden, warte auf den Zug des Gegners...';

  @override
  String get networkStatusDisconnected => 'Netzwerkstatus: Getrennt';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Rücknahmeanforderung an den Gegner gesendet.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'Der Gegner hat das Spiel möglicherweise verlassen';

  @override
  String get connectedToHostSuccessfully => 'Erfolgreich mit Host verbunden.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Verbindung verloren: Zeitüberschreitung (Heartbeat)';

  @override
  String get noHostDiscovered => 'Kein Host gefunden.';

  @override
  String get confirmResignation => 'Aufgabe bestätigen';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Spielhosting gestartet, warte auf Beitritt von Spielern...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Zeitüberschreitung der Verbindung, Netzwerkverbindung instabil.';

  @override
  String get noLlmPromptAvailable => 'Keine LLM-Aufforderung verfügbar.';

  @override
  String get youResignedGameOver => 'Sie haben aufgegeben. Spiel beendet.';

  @override
  String get serverIp => 'Server-IP';

  @override
  String get confirmClear => 'Löschen bestätigen';

  @override
  String get opponentSTurn => 'Der Gegner ist am Zug.';

  @override
  String get waitingAClientConnection => 'Warte auf Client-Verbindung...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Rücknahmeanforderung wurde abgelehnt oder schlug fehl.';

  @override
  String get addText => 'Text hinzufügen';

  @override
  String get exitAnnotationMode => 'Annotationsmodus verlassen';

  @override
  String get typeYourAnnotation => 'Geben Sie Ihre Anmerkung ein';

  @override
  String get attemptingToReconnect => 'Versuche erneut zu verbinden...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Neustartanfrage gesendet. Warte auf die Antwort des Gegners...';

  @override
  String get serverIsStopped => 'Server ist gestoppt.';

  @override
  String get restartRequest => 'Neustartanfrage';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Eine Rücknahme kann nur angefordert werden, wenn Sie am Zug sind.';

  @override
  String get takeBackAccepted => 'Rücknahme akzeptiert.';

  @override
  String get localNetworkSettings => 'Lokale Netzwerkeinstellungen';

  @override
  String get reconnectedSuccessfully => 'Erfolgreich wieder verbunden!';

  @override
  String get failedToSaveImageToGallery =>
      'Bild konnte nicht in der Galerie gespeichert werden.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Der Gegner hat einen Neustart des Spiels angefordert. Akzeptieren Sie?';

  @override
  String get yourTurn => 'Sie sind am Zug.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Erneute Verbindung nicht möglich, bitte starten Sie das Spiel neu.';

  @override
  String get host => 'Host';

  @override
  String get join => 'Beitreten';

  @override
  String get port => 'Port';

  @override
  String get invalidIpAddress => 'Ungültige IP-Adresse.';

  @override
  String get invalidPort => 'Ungültiger Port.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Verbinde: Versuch $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Verbindung fehlgeschlagen: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Hosting konnte nicht gestartet werden: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Host gefunden: $ip:$port';
  }

  @override
  String get stop => 'Beenden';

  @override
  String get discover => 'Suchen';

  @override
  String get connect => 'Verbinden';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Client verbunden: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Suche: $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Wiederverbinden ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Verbunden';

  @override
  String get delete => 'Löschen';

  @override
  String get ancientEgypt => 'Alpine Frühzeit';

  @override
  String get gothicIce => 'Gletschergotik';

  @override
  String get riceField => 'Alpenweide';

  @override
  String get chinesePorcelain => 'Langenthaler Porzellan';

  @override
  String get desertDusk => 'Alpenglühen';

  @override
  String get precisionCraft => 'Alpine Uhrmacherkunst';

  @override
  String get folkEmbroidery => 'St. Galler Stickerei';

  @override
  String get carpathianHeritage => 'Alpines Erbe';

  @override
  String get imperialGrandeur => 'Kaiserliche Pracht';

  @override
  String get bohemianCrystal => 'Hergiswiler Glas';

  @override
  String get savannaSunrise => 'Alpenaufgang';

  @override
  String get harmonyBalance => 'Harmonie und Balance';

  @override
  String get cinnamonSpice => 'Basler Läckerli';

  @override
  String get anatolianMosaic => 'Alpines Patchwork';

  @override
  String get carnivalSpirit => 'Karnevalsgeist';

  @override
  String get custom => 'Alpenbrauchtum';

  @override
  String get spiceMarket => 'Kräutermarkt';

  @override
  String get swipeToRevealTheDrawer => 'Wischen, um die Schublade anzuzeigen';

  @override
  String get showGameInfoOnScreenshots =>
      'Spielinformationen auf Screenshots anzeigen';

  @override
  String get humanMoveTime => 'Zeitlimit für menschlichen Zug';

  @override
  String get noTimeLimitForHumanMoves => 'Kein Zeitlimit für menschliche Züge';

  @override
  String get timeoutLoseWillBeApplied =>
      'Zeitüberschreitungsverlust wird für menschlichen Spieler angewendet';

  @override
  String get identifyingBoard => 'Spielbrett wird erkannt…';

  @override
  String get youCanEnterAnyModelName =>
      'Sie können einen beliebigen Modellnamen eingeben';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Brettstellung angewendet. FEN in die Zwischenablage kopiert.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Vorschlag: Versuchen Sie, ein klareres Bild des Spielbretts zu machen';

  @override
  String get llmPromptTemplate => 'LLM-Aufforderungsvorlage';

  @override
  String get noValidBoardDetected => 'Kein gültiges Spielbrett erkannt';

  @override
  String get selectingImageFromAlbum => 'Bild aus Album auswählen…';

  @override
  String get configurePromptTemplate => 'Aufforderungsvorlage konfigurieren';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Aufforderungsvorlage für LLM‑Analyse bearbeiten';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Konnte kein FEN aus dem erkannten Spielbrett erzeugen';

  @override
  String get outputInCurrentLanguage => 'Ausgabe in aktueller Sprache';

  @override
  String get commonBaseUrls => 'Häufig verwendete Base URLs';

  @override
  String get viewCommonModels => 'Häufig verwendete Modelle anzeigen';

  @override
  String get recognitionParametersUpdated => 'Erkennungsparameter aktualisiert';

  @override
  String get whiteSMove => 'Zug von Weiss';

  @override
  String get resetToDefaults => 'Auf Standard zurücksetzen';

  @override
  String get photoShoot => 'Fotoaufnahme';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Konnte die erkannte Brettstellung nicht anwenden';

  @override
  String get llmPromptContent => 'LLM‑Aufforderungsinhalt';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM nicht konfiguriert. Bitte überprüfen Sie Ihre Einstellungen.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Anbieter, Modell, API Key und Base URL festlegen';

  @override
  String get llmConfiguration => 'LLM‑Konfiguration';

  @override
  String get configureLlmProvider => 'LLM‑Anbieter konfigurieren';

  @override
  String get llmPromptTemplateHeader => 'Header der LLM‑Aufforderungsvorlage';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Keine Spielsteine im Bild erkannt. Bitte versuchen Sie es erneut.';

  @override
  String get recognizeBoardFromImage => 'Spielbrett aus Bild erkennen';

  @override
  String get viewTips => 'Tipps anzeigen';

  @override
  String get applyToBoard => 'Auf Spielbrett anwenden';

  @override
  String get adjustBoardArea => 'Brettbereich anpassen';

  @override
  String get viewCommonUrls => 'Häufig verwendete URLs anzeigen';

  @override
  String get colorAnalysisFailed => 'Farbanalyse fehlgeschlagen!';

  @override
  String get analyzingGameBoardImage => 'Analyse des Spielbrettbilds…';

  @override
  String get selectFromAlbum => 'Aus Album auswählen';

  @override
  String get noBoardPointDetected => 'Kein Brettpunkt erkannt!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Wenn leer gelassen, wird die Standardvorlage verwendet';

  @override
  String get llmConfig => 'LLM‑Konfiguration';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Möchten Sie die Aufforderungsvorlagen wirklich auf die Standardwerte zurücksetzen?';

  @override
  String get llmPromptTemplateFooter => 'Footer der LLM‑Aufforderungsvorlage';

  @override
  String get loadingResponse => 'Antwort wird geladen…';

  @override
  String get applyThisResultToBoard =>
      'Dieses Ergebnis auf das Spielbrett anwenden';

  @override
  String get takingPicture => 'Bild wird aufgenommen…';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Bitte wählen Sie ein Bild des Spielbretts zur Identifizierung aus';

  @override
  String get identificationResults => 'Identifikationsergebnisse';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Züge analysieren und Erkenntnisse bereitstellen.';

  @override
  String get getApiKey => 'API Key abrufen';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Gesamter Erkennungsprozess konnte nicht abgeschlossen werden';

  @override
  String get boardRecognitionResult => 'Ergebnis der Spielbrett‑Erkennung';

  @override
  String get askLlm => 'LLM fragen';

  @override
  String get boardDetectionFailed => 'Spielbrett‑Erkennung fehlgeschlagen!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Kein Brettpunkt erkannt, Spielstein kann nicht identifiziert werden!';

  @override
  String get copyFen => 'FEN kopieren';

  @override
  String get commonlyUsedModels => 'Häufig verwendete Modelle';

  @override
  String get apiKeyOptional => 'API Key (optional)';

  @override
  String get noImageSelected => 'Kein Bild ausgewählt';

  @override
  String get blackSMove => 'Zug von Schwarz';

  @override
  String get llm => 'Grosses Sprachmodell';

  @override
  String get llmProvider => 'Anbieter';

  @override
  String get baseUrl => 'Basis-URL';

  @override
  String get model => 'Modell';

  @override
  String get temperature => 'Temperatur';

  @override
  String get llmCommandReceivedProcessing =>
      'Befehl empfangen! KI verarbeitet...';

  @override
  String get llmDeepThinkingWait => 'Tiefes Nachdenken läuft, bitte warten...';

  @override
  String get llmPresentingSoon => 'Wird bald präsentiert...';

  @override
  String get recognitionParameters => 'Erkennungsparameter';

  @override
  String get adjustParamsDesc =>
      'Parameter anpassen, um die Erkennungsgenauigkeit zu verbessern';

  @override
  String get saveParameters => 'Parameter speichern';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Bilderkennung konnte nicht gestartet werden: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Bilderkennung fehlgeschlagen: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Angewendete Stellung mit $whiteCount weissen und $blackCount schwarzen Steinen';
  }

  @override
  String get fenCopiedToClipboard => '(FEN in die Zwischenablage kopiert)';

  @override
  String recognitionFailed(String error) {
    return 'Erkennung fehlgeschlagen: $error';
  }

  @override
  String get myRating => 'Mini Bewärtig';

  @override
  String get gamesPlayed => 'Gspielti Spiel';

  @override
  String get wins => 'Siig';

  @override
  String get losses => 'Niederlage';

  @override
  String get draws => 'Unentschiede';

  @override
  String get lastUpdated => 'Zletzt aktualisiert';

  @override
  String get format => 'Format:';

  @override
  String get resetStatistics => 'Statistike zruggsetze';

  @override
  String get drawRate => 'Unentschiedeqote';

  @override
  String get lossRate => 'Niederlageqote';

  @override
  String get aiStatistics => 'KI-Statistike';

  @override
  String get enableStatistics => 'Statistike aktiviere';

  @override
  String get enableStatistics_Detail =>
      'Wenn aktiviert, wärde Spielresultat i de Statistike erfasst. Spiel mit Zuggrücknahme wärde aber nöd erfasst. Wenn deaktiviert, wird d Erfassig vo Statistike pausiert.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Das setzt alli Spielstatistike zrugg. Die Aktion cha nöd rückgängig gmacht wärde.';

  @override
  String get boardInnerRingSize => 'Grösse des inneren Rings des Brettes';

  @override
  String get boardShadowEnabled => 'Brettschatten';

  @override
  String get trapAwareness => 'Fallen-Erkennung';

  @override
  String get trapAwarenessDescription =>
      'Markiere Fallen-Züge während der Analyse mit dicken Kreisen und Pfeilen.';

  @override
  String trapExists(String trapMoves) {
    return 'Es gibt eine Falle. Fallen-Züge: $trapMoves';
  }

  @override
  String get custodianCapture => 'Flankierende Erfassung';

  @override
  String get custodianCaptureDescription =>
      'Schliessen Sie eine der Stücke Ihres Gegners zwischen zwei Ihrer von Ihnen in einer geraden Linie ein, um ihn zu erfassen.';

  @override
  String get custodianCaptureEnable => 'Flankierende Erfassung erlauben';

  @override
  String get interventionCapture => 'Interventionserfassung';

  @override
  String get interventionCaptureDescription =>
      'Bewegen Sie sich in den leeren Punkt zwischen zwei der Stücke Ihres Gegners, um beide zu erfassen.';

  @override
  String get interventionCaptureEnable => 'Interventionserfassung erlauben';

  @override
  String get leapCapture => 'Sprungerfassung';

  @override
  String get leapCaptureDescription =>
      'Erfassen Sie, indem Sie über das Stück eines benachbarten Gegners in den leeren Punkt hinaus springen.';

  @override
  String get leapCaptureEnable => 'Sprungerfassung erlauben';

  @override
  String get captureApplicableLines => 'Anwendbare Linien';

  @override
  String get captureSquareEdges => 'Entlang der Ränder des Quadrats';

  @override
  String get captureCrossLines =>
      'Entlang orthogonaler Linien überqueren das Quadrat';

  @override
  String get captureDiagonalLines =>
      'Entlang diagonaler Linien überqueren das Quadrat';

  @override
  String get captureExecutionPhases => 'Ausführungsphasen';

  @override
  String get capturePiecesCondition =>
      'Verfügbarkeit während der Umzugsphase basierend auf verbleibenden Teilen';

  @override
  String get capturePiecesConditionUnlimited => 'Keine Einschränkung';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Erhältlich, wenn Sie drei oder weniger Stücke haben';
}
