// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Danish (`da`).
class SDa extends S {
  SDa([String locale = 'da']) : super(locale);

  @override
  String get appName => 'Mølle';

  @override
  String get welcome => 'Velkommen';

  @override
  String get yes => 'Ja';

  @override
  String get no => 'Nej';

  @override
  String get game => 'Spil';

  @override
  String get humanVsAi => 'Menneske Vs AI';

  @override
  String get humanVsHuman => 'Menneske Vs menneske';

  @override
  String get aiVsAi => 'AI Vs AI';

  @override
  String get humanVsCloud => 'Menneske mod sky';

  @override
  String get humanVsLAN => 'Menneske mod LAN';

  @override
  String get testViaLAN => 'Test via LAN';

  @override
  String get move => 'Flyt';

  @override
  String get showMoveList => 'Liste over flytninger';

  @override
  String get moveList => 'Liste over flytninger';

  @override
  String get noGameRecord => 'Ingen registrering';

  @override
  String get ok => 'OK';

  @override
  String get confirm => 'Bekræft';

  @override
  String get cancel => 'Annuller';

  @override
  String get tipSelectWrong => 'Du har valgt en forkert brik.';

  @override
  String get tipPlace => 'Placer dine brikker.';

  @override
  String get tipBanPlace => 'Du kan ikke placere den her.';

  @override
  String get tipPlaced => 'Du har placeret en brik.';

  @override
  String get tipRemove => 'Fjern en brik.';

  @override
  String get tipBanRemove => 'Du kan ikke fjerne den.';

  @override
  String get tipRemoved => 'Du har fjernet en brik.';

  @override
  String get tipMove => 'Flyt en brik.';

  @override
  String get tipCannotPlace => 'Du kan ikke placere din brik her.';

  @override
  String get tipCannotMove => 'Du kan ikke flytte din brik her.';

  @override
  String get tipMill => 'Mølle! Tag din modstanders brik.';

  @override
  String get tipContinueMill => 'Fortsæt med at tage din modstanders brik.';

  @override
  String get tipSelectOpponentsPiece => 'Vælg en af din modstanders brikker.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Du kan ikke fjerne en brik fra en mølle.';

  @override
  String get tipCanMoveOnePoint => 'En brik kan flytte 1 point.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Du kan ikke flytte din modstanders brikker.';

  @override
  String get tipSelectPieceToMove => 'Vælg din brik til at flytte.';

  @override
  String get tipHaveThreePiecesLeft => 'Du har tre brikker tilbage.';

  @override
  String get tipCanMoveToAnyPoint =>
      'Du kan flytte til et hvilket som helst punkt, du vil.';

  @override
  String tipToMove(Object player) {
    return '$player for at flytte.';
  }

  @override
  String get whiteWin => 'Spiller 1 vinder!';

  @override
  String get blackWin => 'Spiller 2 vinder!';

  @override
  String get won => 'Vundet';

  @override
  String get lost => 'Tabt';

  @override
  String get thinking => 'Tænker…';

  @override
  String get newGame => 'Nyt spil';

  @override
  String get importGame => 'Import af spil';

  @override
  String get exportGame => 'Eksportere spil';

  @override
  String get gameImported => 'Spil importeret.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Kan ikke importere $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch =>
      'Bevægelser og regler stemmer ikke overens.';

  @override
  String get pleaseWait => 'Vent venligst.';

  @override
  String get restartGame => 'Genstarter du det aktuelle spil?';

  @override
  String get restart => 'Genstart';

  @override
  String get gameStarted => 'Spillet er startet, placer venligst dine brikker.';

  @override
  String get analyzing => 'Analyserer…';

  @override
  String error(Object message) {
    return 'Fejl: $message';
  }

  @override
  String get winRate => 'Vinderrate';

  @override
  String get score => 'Score:';

  @override
  String get white => 'Spiller 1';

  @override
  String get black => 'Spiller 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return 'Antallet af ${player}s brikker er mindre end tre.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player har opgivet.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player har ingen mulige træk tilbage.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Brættet er fyldt, og $player har ingen mulige træk tilbage.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Tiden er forbi, $player tabt.';
  }

  @override
  String get drawReasonRule50 =>
      'I trækfasen er der ikke blevet fjernet nogen brik i det sidste bestemte antal træk.';

  @override
  String get drawReasonBoardIsFull =>
      'Det er uafgjort, fordi brættet er fuldt.';

  @override
  String get drawReasonThreefoldRepetition =>
      'Det er uafgjort på grund af tredobbelt gentagelse.';

  @override
  String get gameOverUnknownReason => 'Game Over! Ukendt årsag.';

  @override
  String get gameOver => 'Game over';

  @override
  String get youWin => 'Du vinder! Tillykke!';

  @override
  String challengeHarderLevel(int level) {
    return 'Udfordre hårdere niveau? Det nye niveau vil være niveau $level!';
  }

  @override
  String get youLose => 'Du taber!';

  @override
  String get analyze => 'Analyser';

  @override
  String get about => 'Om';

  @override
  String version(Object versionNumber) {
    return 'Version: $versionNumber';
  }

  @override
  String get thanks => 'Tak';

  @override
  String get settings => 'Indstillinger';

  @override
  String get options => 'Valg';

  @override
  String get generalSettings => 'Generelle indstillinger';

  @override
  String get skillLevel => 'Sværhedsgrad';

  @override
  String get moveTime => 'AI-tanketid';

  @override
  String get difficulty => 'Sværhedsgrad';

  @override
  String get playSounds => 'Lydeffekter';

  @override
  String get playSoundsInTheGame => 'Afspilning af lyde i spillet';

  @override
  String get keepMuteWhenTakingBack => 'Hold lydløs, når du tager tilbage';

  @override
  String get tone => 'Tone';

  @override
  String get whoMovesFirst => 'Første træk';

  @override
  String get human => 'Menneske';

  @override
  String get ai => 'AI';

  @override
  String get alternate => 'Alternativt';

  @override
  String get isAutoRestart =>
      'Automatisk genstart af spillet, når spillet er slut';

  @override
  String get isAutoChangeFirstMove => 'Automatisk ændring af første træk';

  @override
  String get shufflingEnabled => 'Tilfældigt træk';

  @override
  String get misc => 'Diverse';

  @override
  String get rules => 'Regler';

  @override
  String get piecesCount => 'Antallet af brikker, som hver spiller har';

  @override
  String get piecesCount_Detail => 'Hvor mange brikker har hver spiller?';

  @override
  String get flyPieceCount => 'Nummeret på den flyvende brik';

  @override
  String get flyPieceCount_Detail =>
      'Hvis flyvende er aktiveret, kan en spiller, når han er reduceret til et bestemt antal brikker, frit flytte sine brikker til et hvilket som helst ubesat punkt i stedet for at være begrænset til tilstødende punkter som i resten af spillet.';

  @override
  String get piecesAtLeastCount => 'Brikker Mindst';

  @override
  String get hasDiagonalLines => 'Diagonale linjer';

  @override
  String get hasDiagonalLines_Detail =>
      'Tilføj fire diagonale linjer til brættet.';

  @override
  String get isDefenderMoveFirst => 'Den anden spiller flytter først';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Den spiller, der flytter som den anden i placeringsfasen, flytter først i flyttefasen.';

  @override
  String get mayRemoveMultiple => 'Multi-fjern';

  @override
  String get mayRemoveMultiple_Detail =>
      'Hvis en spiller lukker mere end én mølle på én gang, fjerner hun det antal møller, hun har lukket.';

  @override
  String get mayRemoveFromMillsAlways => 'Ødelægge møller';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Som standard skal spillerne først fjerne alle andre brikker, før de fjerner en brik fra en dannet mølle. Aktiver denne indstilling for at deaktivere denne begrænsning.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Den anden spiller taber, når brættet er fuldt';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Når brættet er fuldt ved slutningen af placeringsfasen, taber den side, der placerer først, spillet. Ellers er spillet uafgjort.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Taber, når der ikke er nogen lovlige træk';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Spilleren taber, hvis hans modstander blokerer dem, så de ikke kan flyttes. Skift side til at flytte, hvis denne indstilling er deaktiveret.';

  @override
  String get mayFly => 'Flyvende';

  @override
  String get mayFly_Detail =>
      'Hvis en spiller kun har tre eller fire (konfigurerbar) brikker tilbage, kan han flytte brikken til et hvilket som helst frit punkt.';

  @override
  String get nMoveRule => 'N-træk-reglen';

  @override
  String get nMoveRule_Detail =>
      'Spillet er uafgjort, hvis der ikke har været nogen flytning i et bestemt antal træk af hver spiller.';

  @override
  String get rollback => 'Rul tilbage';

  @override
  String get pleaseSelect => 'Vælg venligst';

  @override
  String get copy => 'Kopier';

  @override
  String get moveHistoryCopied => 'Trækhistorik kopieres til udklipsholderen.';

  @override
  String get help => 'Hjælp';

  @override
  String get feedback => 'Feedback';

  @override
  String get exit => 'Afslut';

  @override
  String get ruleSettings => 'Regelindstillinger';

  @override
  String get color => 'Farve';

  @override
  String get boardColor => 'Farve på tavlen';

  @override
  String get pieceColor => 'Farve på brikker';

  @override
  String get backgroundColor => 'Baggrundsfarve';

  @override
  String get lineColor => 'Farve på brættets linje';

  @override
  String get whitePieceColor => 'Spiller 1 brik farve';

  @override
  String get blackPieceColor => 'Farve på brik til spiller 2';

  @override
  String get messageColor => 'Farve på besked';

  @override
  String get isPieceCountInHandShown => 'Vis antallet af brikker på hånden';

  @override
  String get isNotationsShown => 'Vis noteringer på brættet';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Vis historik navigationsværktøjslinje';

  @override
  String get display => 'Vis';

  @override
  String get boardBorderLineWidth => 'Bredde af brætgrænserne';

  @override
  String get boardInnerLineWidth => 'Bredden af den indre linje på brættet';

  @override
  String get pieceWidth => 'Stykkebredde';

  @override
  String get fontSize => 'Skriftstørrelse';

  @override
  String get standardNotation => 'WMD-notation';

  @override
  String get restore => 'Gendan';

  @override
  String get restoreDefaultSettings => 'Gendanner standardindstillingerne';

  @override
  String pick(Object element) {
    return 'Vælg $element';
  }

  @override
  String get info => 'Info';

  @override
  String get hint => 'Tip';

  @override
  String get player => 'spiller';

  @override
  String get player1 => 'Spiller 1';

  @override
  String get player2 => 'Spiller 2';

  @override
  String get howToPlay => 'Sådan spiller du';

  @override
  String get toPlacePiece =>
      'Tryk på et vilkårligt punkt for at placere brikken.';

  @override
  String get toSelectPiece => 'Tryk på en brik for at flytte den.';

  @override
  String get toMovePiece =>
      'Tryk på et punkt, der er forbundet med en brik, for at flytte den.';

  @override
  String get toRemovePiece =>
      'Tryk på en af modstanderens brikker for at fjerne den.';

  @override
  String get needToCreateMillFirst =>
      'Du skal først oprette en mølle, før du kan fjerne en brik.';

  @override
  String get needToPlayWithOwnPieces =>
      'Du er nødt til at spille med dine brikker.';

  @override
  String get statistics => 'Statistik';

  @override
  String get totalGames => 'Samlet antal spil';

  @override
  String get results => 'Resultater';

  @override
  String get left => 'venstre';

  @override
  String get privacyPolicy =>
      'Politik om beskyttelse af personlige oplysninger';

  @override
  String get privacyPolicy_Detail_1 =>
      'Læs venligst omhyggeligt og sørg for, at du fuldt ud forstår og accepterer dette ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Hvis du ikke accepterer denne politik, skal du ikke bruge denne app. Brug af appen indebærer, at du accepterer disse vilkår.';

  @override
  String get and => ' og ';

  @override
  String get accept => 'Accepter';

  @override
  String get takeBack => 'Tag tilbage';

  @override
  String get takingBack => 'Tilbageførsel…';

  @override
  String get waiting => 'Venter…';

  @override
  String get stepForward => 'Træd fremad';

  @override
  String get takeBackAll => 'Tag alt tilbage';

  @override
  String get stepForwardAll => 'Fremadgående alle';

  @override
  String get moveNow => 'Flyt dig nu';

  @override
  String get done => 'Færdig.';

  @override
  String get crackMill => 'Knæk-mølle';

  @override
  String get crackMill_Detail =>
      'Hvis en spiller kun har brikker i møller, vil brikkerne i møllerne ikke blive låst for at blive fjernet.';

  @override
  String get animationDuration => 'Animationens varighed';

  @override
  String get none => 'Ingen';

  @override
  String get theme => 'Tema';

  @override
  String get helpContent =>
      'Spillet har til formål at efterlade modstanderen med færre end tre brikker eller ingen lovlige træk.\n\nSpillet er automatisk uafgjort, hvis en stilling opstår for tredje gang eller ikke fjernes i de sidste 100 (konfigurerbare) træk.\n\nSpillet forløber i tre faser:\n\n1. Placering af brikker på ledige punkter\n2. Flytning af brikker til tilstødende punkter\n3. (valgfri fase) Flytning af brikker til et hvilket som helst ledigt punkt, når spilleren er reduceret til tre brikker\n\nPlacering af\n\nSpillet begynder med et tomt bræt, som består af et gitter med fireogtyve punkter. Spillerne skiftes til at placere deres brikker på de ledige punkter, indtil hver spiller har placeret alle brikker på brættet. Hvis en spiller kan placere tre af sine brikker lige, har han en \"mølle\" og kan fjerne en af sine modstanderes brikker fra brættet.\n\nI nogle regler skal spillerne først fjerne alle andre brikker, før de kan fjerne en brik fra en dannet mølle.\n\nI nogle regler kan man ikke placere brikkerne til de punkter, hvor brikkerne er fjernet, igen i placeringsfasen.\n\nNår alle brikker er placeret, skiftes spillerne til at flytte.\n\nFlytning\n\nFor at flytte flytter en spiller en af sine brikker langs en linje på brættet til et ledigt tilstødende punkt. Hvis han ikke kan gøre det, har han tabt spillet. Som i placeringsfasen har en spiller, der placerer tre af sine brikker på en brætlinje, en mølle og kan fjerne en af sine modstanderes brikker. En spiller, der reduceres til to brikker, har ikke mulighed for at danne nye møller og taber dermed spillet. En spiller kan også tabe, når han har mere end tre brikker, hvis hans modstander blokerer dem for at flytte dem.\n\nFlyvende\n\nI nogle varianter af reglerne kan en spiller, når han kun har tre brikker tilbage, flyve, hoppe eller springe til alle ledige punkter, ikke kun tilstødende punkter.';

  @override
  String get versionInfo => 'Version info';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'Licens';

  @override
  String get sourceCode => 'Kildekode';

  @override
  String get appVersion => 'App-version';

  @override
  String get general => 'Generelt';

  @override
  String get advanced => 'Avanceret';

  @override
  String get placing => 'Placering af';

  @override
  String get moving => 'Flytning af';

  @override
  String get removing => 'Fjernelse af';

  @override
  String get gameOverCondition => 'Game over-tilstand';

  @override
  String get aisPlayStyle => 'AI\'s spillestil';

  @override
  String get passive => 'Passiv';

  @override
  String get timeout => 'Tiden er gået';

  @override
  String get appearance => 'Udseende';

  @override
  String get drawOnHumanExperience => 'Udnyt den menneskelige erfaring';

  @override
  String get considerMobility => 'Overvej mobiliteten af dele';

  @override
  String get pieceCount => 'Antal stykker:';

  @override
  String inHand(Object player, int count) {
    return '$player i hånden: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player ombord: $count';
  }

  @override
  String get boardTop => 'Brættet er forskudt fra toppen';

  @override
  String get notAIsTurn => 'Det er ikke AI\'s tur.';

  @override
  String get aiIsNotThinking => 'AI tænker ikke.';

  @override
  String get atEnd => 'Du er i slutningen af træklisten.';

  @override
  String get tapBackAgainToLeave => 'Tryk tilbage igen for at gå.';

  @override
  String get more => 'Mere';

  @override
  String get experimental => 'Det er en eksperimentel funktion.';

  @override
  String get experiments => 'Eksperimenter';

  @override
  String get ossLicenses => 'Open source-licenser';

  @override
  String get language => 'Sprog';

  @override
  String get defaultLanguage => 'Standardsprog';

  @override
  String get mayMoveInPlacingPhase =>
      'Brikkerne kan bevæge sig i placeringsfasen';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Der er ingen særskilte placerings- og flyttefaser, dvs. spillerne kan ved hvert træk beslutte, om de vil placere en brik på brættet eller flytte en af deres brikker (så længe de har resterende brikker til at placere).';

  @override
  String get drawerColor => 'Menufarve';

  @override
  String get drawerTextColor => 'Menufarve på menuen';

  @override
  String get drawerHighlightItemColor => 'Menuhøjde elementfarve';

  @override
  String get mainToolbarBackgroundColor =>
      'Hovedværktøjslinjens baggrundsfarve';

  @override
  String get mainToolbarIconColor => 'Hovedværktøjslinjens ikonfarve';

  @override
  String get navigationToolbarBackgroundColor =>
      'Navigationsværktøjslinjens baggrundsfarve';

  @override
  String get navigationToolbarIconColor =>
      'Navigationsværktøjslinjens ikonfarve';

  @override
  String get autoHideToolbar => 'Skjul værktøjslinjen automatisk';

  @override
  String get toolbarLocationOnScreen => 'Værktøjslinjens placering på skærmen';

  @override
  String get top => 'Top';

  @override
  String get bottom => 'Bund';

  @override
  String get center => 'Centrum';

  @override
  String get solidColor => 'Solid farve';

  @override
  String get picture => 'Billede';

  @override
  String get chooseYourPicture => 'Vælg dit billede';

  @override
  String get light => 'Lys';

  @override
  String get dark => 'Mørk';

  @override
  String get themes => 'Temaer';

  @override
  String get currentTheme => 'Aktuelt tema';

  @override
  String get saveTheme => 'Gem tema';

  @override
  String get showAnalysisGraph => 'Vis analysegraf';

  @override
  String get analysis => 'Analyse';

  @override
  String get saveGame => 'Gem spil';

  @override
  String get loadGame => 'Indlæs spil';

  @override
  String get setupPosition => 'Opsætningsposition';

  @override
  String get showLegalMoves => 'Vis juridiske træk';

  @override
  String get showLastMove => 'Vis sidste træk';

  @override
  String get showArrows => 'Vis pile';

  @override
  String get pieces => 'Stykker';

  @override
  String get showAnalysis => 'Vis analyse';

  @override
  String get threads => 'Tråde';

  @override
  String get getInvolved => 'Bliv involveret';

  @override
  String get helpImproveTranslate => 'Hjælp med at forbedre oversættelsen';

  @override
  String get tutorial => 'Vejledning';

  @override
  String get classicMill => 'Klassisk mølle';

  @override
  String get mixedMill => 'Blandet mølle';

  @override
  String get ceylonMill => 'Ceylon Mølle';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Mølle kan blive brudt og genskabt gentagne gange';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Hvis en spiller bryder en mølle for at oprette en ny mølle med det samme, kan en sådan spiller flytte et sådant stykke tilbage til det oprindelige kryds i sit næste træk, hvis det opretter en ny mølle.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Spillet trækkes, hvis en spiller har tre brikker, og efter ti træk fjerner ingen spiller modstanderens brikker';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Når en spiller er nede i tre stykker, og ingen af spillerne kan fjerne en modstanders stykke inden for ti træk, er spillet uafgjort.';

  @override
  String get close => 'Tæt';

  @override
  String get whitePiece => 'Hvidt stykke';

  @override
  String get blackPiece => 'Sort stykke';

  @override
  String get emptyPoint => 'Tomt punkt';

  @override
  String get noPoint => 'Ingen pointe';

  @override
  String get placingPhase => 'Placeringsfase';

  @override
  String get movingPhase => 'Flyttefase';

  @override
  String get flyingPhase => 'Flyvende fase';

  @override
  String sideToMove(Object player) {
    return 'Side at flytte: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Sidste træk: $move';
  }

  @override
  String get selected => 'Valgte';

  @override
  String get accessibility => 'Tilgængelighed';

  @override
  String get screenReaderSupport => 'Understøttelse af skærmlæser';

  @override
  String get isDraw => 'Det er uafgjort!';

  @override
  String get draw => 'Tegne';

  @override
  String get pieceHighlightColor => 'Stykke fremhæve farve';

  @override
  String get algorithm => 'Algoritme';

  @override
  String get endgameNMoveRule => 'Slutspil N-Move-regel';

  @override
  String get endgameNMoveRule_Detail =>
      'Hvis en spiller kun har tre brikker, og ingen af spillerne fjerner en brik inden for et bestemt træk, trækkes spillet.';

  @override
  String get drawReasonEndgameRule50 =>
      'Hver spiller har kun tre brikker, og ingen af spillerne fjerner en brik inden for et bestemt træk.';

  @override
  String get threefoldRepetitionRule => 'Tredobbelt gentagelsesregel';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Spillet trækkes, hvis en position opstår for tredje gang.';

  @override
  String get continueToMakeMove => 'Mølle! Fortsæt med at gøre et træk.';

  @override
  String get pointStyle => 'Point stil';

  @override
  String get pointWidth => 'Punktbredde';

  @override
  String get solid => 'Solid';

  @override
  String get hollow => 'Hul';

  @override
  String get languageName => 'Dansk';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Flytter sig',
      one: '$count Bevæge sig',
      zero: 'Bevæge sig',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Indlæsning mislykkedes.';

  @override
  String get filename => 'Filnavn';

  @override
  String get browse => 'Gennemse…';

  @override
  String get gameFiles => 'Spil filer';

  @override
  String get gameSavedTo => 'Spillet er gemt til';

  @override
  String get empty => 'Tom';

  @override
  String get noMove => 'Ingen bevægelse.';

  @override
  String get restoredPosition => 'Gendannet udgangsposition.';

  @override
  String get clean => 'Ren';

  @override
  String get cleanedUp => 'Ryddet op.';

  @override
  String get remove => 'Fjerne';

  @override
  String get noPiecesCanBeRemoved => 'Ingen stykker kan fjernes.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count pieces',
      one: '$count piece',
      zero: 'Piece',
    );
    return '$_temp0 skal fjernes.';
  }

  @override
  String placedCount(int count) {
    return 'Placeret ($count)';
  }

  @override
  String get placedPieceCount => 'Placeret styktal i placeringsfasen.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'Den nuværende spiller har placeret $count brikker.';
  }

  @override
  String get notPlacingPhase => 'Ikke at placere fase, kan ikke ændre den.';

  @override
  String get paste => 'sæt ind';

  @override
  String get pasteDone => 'Pastaen er færdig.';

  @override
  String get cannotPaste => 'Kan ikke indsætte.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Vis uplacerede og fjernede brikker';

  @override
  String get fullScreen => 'Fuld skærm';

  @override
  String get reopenToTakeEffect =>
      'Afslut og genåbn appen, for at indstillingerne træder i kraft.';

  @override
  String get forest => 'Skov';

  @override
  String get desktopImage => 'Desktop billede';

  @override
  String get invalidPosition => 'Ugyldig stilling.';

  @override
  String get shareGIF => 'Del GIF';

  @override
  String get pixelRatio => 'Pixelforhold';

  @override
  String get duration => 'Varighed';

  @override
  String get gameScreenRecorder => 'Spil skærmoptager';

  @override
  String get previous => 'Tidligere';

  @override
  String get next => 'Næste';

  @override
  String get skip => 'Springe';

  @override
  String get gotIt => 'Forstået';

  @override
  String get youCanModifyRules =>
      'Du kan ændre spillets regler i regelindstillingerne.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Du kan bruge musehjulet til at ændre værdien i vælgeren.';

  @override
  String get noTimeLimitForThinking =>
      'AI Tænketid sat til 0 betyder, at der ikke er nogen tidsbegrænsning for tænkning.';

  @override
  String get whatIsMtdf =>
      'MTD(f) er en modificeret form af alfa-beta-søgealgoritmen, der har til formål at forbedre effektiviteten ved at genbruge mellemliggende søgeresultater og bruge et godt indledende gæt til at indsnævre søgerummet.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Vær opmærksom på, at AI-tænketidsjusteringen muligvis ikke er helt præcis. Den faktiske tænketid kan være kortere, når sværhedsgraden er sat til en lavere værdi og kan være længere, når AI\'en er midtvejs, når tiden løber ud.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Hvis du indstiller sværhedsgraden højt, men ikke øger AI-tænketiden, kan det faktiske sværhedsgrad være begrænset til en lavere værdi på grund af tænketidsbegrænsningen. Den faktiske værdi kan variere baseret på maskinens ydeevne.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) er en søgealgoritme til at finde det bedste træk i en given position. Det er en forbedring af alfa-beta-algoritmen og bruger nul- eller nul-vinduesøgninger til at bekræfte, at et træk er værre eller ikke værre end en allerede sikker score fra hovedvariationen. PVS fokuserer på de mest lovende træk og undgår unødvendige søgninger af suboptimale grene, hvilket er med til at forbedre effektiviteten af søgningen.';

  @override
  String get whatIsAlphaBeta =>
      'Alfa-beta-algoritmen er en søgealgoritme til at finde det bedste træk. Den bruger minimax-princippet og to værdier, alfa og beta, til at beskære søgetræet og øge effektiviteten. Alfa repræsenterer den mindste score, som computeren er sikker på, den kan få, mens beta repræsenterer den maksimale score, dens modstander kan få. Algoritmen hjælper computeren med at træffe smarte, effektive beslutninger i et spil.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Ifølge menneskelig erfaring, hvis du forsøger at vinde, vil du tabe. Sigt i stedet efter uafgjort som dit mål og undgå at tabe spillet. Observer din modstander og lok dem forsigtigt ind i en position, hvor de kan begå fejl. Når de viser svaghed, så gribe chancen og skub forsigtigt til sejren. På denne måde kan du vinde spillet.';

  @override
  String get firstMoveDetail =>
      'I dette spil er det lettere for den anden spiller at vinde sammenlignet med den første spiller.';

  @override
  String get passiveDetail =>
      'Aktivering af den passive mulighed vil få AI til at slappe af, når den har en fordel i positionen, i stedet for aggressivt at forsøge at vinde så hurtigt som muligt.';

  @override
  String get moveRandomlyDetail =>
      'Aktivering af denne mulighed øger tilfældigheden og sjovt ved spillet, mens deaktivering af det kan hjælpe med at studere måder at slå AI.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Hvis AI\'en overvejer mobiliteten af sine brikker, vil den ikke kun sigte mod at fange modstanderens brikker så hurtigt som muligt, men også overveje at blokere modstanderens bevægelser og forhindre dem i at gøre det samme.';

  @override
  String get whenBoardIsFull => 'Når bestyrelsen er fuld';

  @override
  String get whenBoardIsFull_Detail =>
      'Ved slutningen af placeringsfasen, før flyttefasen begynder, følger handlingen, hvis brættet er fyldt med brikker.';

  @override
  String get sideToMoveRemovePiece =>
      'Den spiller, der rykker først i flyttefasen, fjerner en af modstanderens brikker.';

  @override
  String get agreeToDraw => 'Begge sider er enige om uafgjort.';

  @override
  String get takeOpponentsPiece => 'Tag en af din modstanders brikker.';

  @override
  String get firstPlayerLose => 'Den første spiller taber spillet.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Den første og anden spiller fjerner en af modstanderens brikker.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Den anden og første spiller fjerner en af modstanderens brikker.';

  @override
  String get enteredFlyingPhase =>
      'Når du er kommet ind i flyvefasen, kan modstanderens brikker hoppe til et hvilket som helst tomt punkt på brættet. Du kan slå flyvereglen fra i \"Regelindstillinger\".';

  @override
  String get whenStalemate => 'Når dødvande';

  @override
  String get whenStalemate_Detail =>
      'Hvilken handling følger, når ingen brik kan flyttes?';

  @override
  String get endWithStalemateLoss => 'Slut med et dødvande tab.';

  @override
  String get changeSideToMove => 'Skift side for at flytte.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Fjern en af modstanderens brikker og lav det næste træk.';

  @override
  String get endWithStalemateDraw => 'Afslut med uafgjort uafgjort.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Fjern en af modstanderens brikker og skift side for at flytte.';

  @override
  String get aiResponseDelayTime => 'AI-svarforsinkelse';

  @override
  String get aiIsDelaying =>
      'AI er i øjeblikket i en forsinket responsfase. Vent venligst et stykke tid, før du fortsætter.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Du kan ikke fjerne et ikke-tilstødende stykke.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'Hvis det går i stå, kan modstanderens brikker, der støder op til din, fjernes, uanset mølleformationen.';

  @override
  String get whatIsMcts =>
      'MCTS er en begyndervenlig algoritme, der træffer beslutninger ved at udforske og evaluere forskellige bevægelser gennem simuleringer.';

  @override
  String get goldenJade => 'Golden Jade';

  @override
  String get forestWood => 'Skov Skov';

  @override
  String get darkMystery => 'Mørkt mysterium';

  @override
  String get midnightBlue => 'Midnatsblå';

  @override
  String get greenForest => 'Grøn Skov';

  @override
  String get greenMeadow => 'Grøn Eng';

  @override
  String get stonyPath => 'Stenet sti';

  @override
  String get pastelPink => 'Pastel Pink';

  @override
  String get turquoiseSea => 'Turkis hav';

  @override
  String get violetDream => 'Violet drøm';

  @override
  String get mintChocolate => 'Mint Chokolade';

  @override
  String get skyBlue => 'Himmelblå';

  @override
  String get playfulGarden => 'Legefuld have';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Retrogradanalysealgoritmen bruger retrogradanalyse med flere værdier til at bygge en slutspilsdatabase fra forskellige startpositioner og anvender derefter denne database til at optimere gameplayet. Denne tilgang falder ind under kategorien Ultra-Strong-løsninger.';

  @override
  String get viewAlgorithmGuide =>
      'Vil du se brugervejledningen til denne algoritme?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Vis positionel fordelsindikator';

  @override
  String get usePerfectDatabase => 'Brug perfekt database';

  @override
  String get perfectDatabaseDescription =>
      'Aktiver denne mulighed for at bruge en fejlfri spildatabase, der er genereret gennem banebrydende algoritmer. Denne funktion integrerer både åbnings- og slutspilsstrategier for at foreslå optimale træk. Dette er det foretrukne valg for spillere, der søger det højeste niveau af præcision i gameplay. Databasen er skabt gennem omhyggelige beregningsteknikker og er designet til at tilbyde næsten perfekte spilløsninger.\n\nBemærk: Hvis AI\'en ikke får adgang til databasen, vil den vende sig til konventionelle algoritmer til gameplay-beslutninger. Når databasen er tilgængelig, bliver \'Sværhedsgraden\' stort set uovertruffen, og \'AI Thinking Time\' oplever en drastisk reduktion. Mange indstillinger inden for \'AI\'s play style\' muligheder vil blive tilsidesat, da databaseresultaterne har højeste prioritet.\n\nFor vejledning om, hvordan du får mest muligt ud af denne fejlfri database, klik her.';

  @override
  String get backgroundImage => 'Baggrundsbillede';

  @override
  String get whatIsRandom =>
      'Når indstillingen \'Brug perfekt database\' ikke er aktiveret, får indstillingen \'Random\' AI\'en til at flytte brikker tilfældigt uden at bruge nogen algoritmer til trækvalg. Dette resulterer typisk i betydeligt svagere gameplay. Omvendt, når \'Brug perfekt database\' er aktiveret, er AI udelukkende afhængig af \'Perfect Database\' til at træffe beslutninger, i stedet for at blande den med traditionelle AI-algoritmer. I denne tilstand er AI\'ens bevægelser udelukkende baseret på databasens indhold, uden at stole på realtidsberegninger eller søgealgoritmer.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Fjern modstanderens brik(ker) fra deres hånd; så er det modstanderens tur til at placere.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Når der dannes møller under placeringsfasen';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Fjern modstanderens brik(ker) fra brættet.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Fjern modstanderens brik(ker) fra brættet; så er det modstanderens tur til at placere.';

  @override
  String get opponentRemovesOwnPiece =>
      'Modstanderen fjerner sine egne brik(ker) fra brættet.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'I stedet for at du foretager dig noget, vælger modstanderen at fjerne sine egne brik(ker) fra brættet, hvilket er en handling, der er skadelig for dem selv.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Fjern modstanderens brik(ker) fra deres hånd; så er det din tur til at flytte.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Fjern brik(ker) fra modstanderens hånd. Hvis der ifølge indstillingen Multi-fjernelse skal fjernes flere brikker, og modstanderen ikke har flere brikker tilbage på hånden, skal du fortsætte med at fjerne modstanderens brikker fra brættet. Derefter er det din tur til at flytte. Hvis du fortsætter med at danne møller, kan du blive ved med at fjerne modstanderens brikker.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Fjern brik(ker) fra modstanderens hånd. Hvis der ifølge indstillingen Multi-fjernelse skal fjernes flere brikker, og modstanderen ikke har flere brikker tilbage på hånden, skal du fortsætte med at fjerne modstanderens brikker fra brættet. Derefter er det modstanderens tur til at flytte.';

  @override
  String get markAndDelayRemovingPieces =>
      'Markér og udsæt fjernelse af brikker.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'I løbet af placeringsfasen markeres de brikker, der skal fjernes, og for begge spillere kan der ikke placeres nye brikker på disse felter. Når man går ind i flyttefasen, fjernes disse markerede brikker helt, og spillerne kan derefter flytte deres brikker til disse nu tomme felter.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'De handlinger, der kan træffes, når der dannes møller i placeringsfasen.';

  @override
  String get marked => 'Markeret';

  @override
  String get menu => 'Menu';

  @override
  String get monochrome => 'Monokrom';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Du kan aktivere skærmoplæserstøtte i indstillingerne for Generelle indstillinger under Tilgængelighed.';

  @override
  String get showNumbersOnPieces => 'Vis numre på brikker';

  @override
  String get saveImage => 'Gem billede';

  @override
  String get isAnalysisToolbarShown => 'Vis analyseværktøjslinje';

  @override
  String get analysisToolbarBackgroundColor =>
      'Baggrundsfarve for analyseværktøjslinje';

  @override
  String get analysisToolbarIconColor => 'Ikonfarve for analyseværktøjslinje';

  @override
  String get transformed => 'Transf.';

  @override
  String get cannotTransform => 'Kan ikke transformere.';

  @override
  String get rotate => 'Rotér';

  @override
  String get horizontalFlip => 'V.S.';

  @override
  String get verticalFlip => 'L.S.';

  @override
  String get innerOuterFlip => 'I/U S.';

  @override
  String get transparentCanvas => 'Gennemsigtigt Lærred';

  @override
  String get restrictRepeatedMillsFormation =>
      'Begræns gentagen mølle-formation';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'En brik flyttet fra en mølle til en anden kan ikke umiddelbart vende tilbage til det oprindelige punkt på næste tur for at danne en mølle igen. Et andet træk er først nødvendigt.';

  @override
  String get oneTimeUseMill => 'Engangsbrug mølle';

  @override
  String get oneTimeUseMill_Detail =>
      'Hver mølle kan kun fjerne en modstanders brik én gang. Du kan gendanne den igen, men den kan ikke bruges til yderligere fjernelser.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'De nuværende regler, du har indstillet, har ikke en tilsvarende perfekt database. For mere information om den perfekte database, klik her.';

  @override
  String get focusOnBlockingPaths => 'Fokuser på at blokere veje';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Prioriter at hindre modstanderens bevægelser over at danne møller. I stedet for at fokusere på at fjerne brikker ved at fuldføre møller, sigter AI på at fange modstanderen, så de ikke kan bevæge sig og sikre en sejr gennem udmattelse snarere end aggressivt spil. Denne strategi blokerer ikke aktivt modstanderens møller.';

  @override
  String get pieceImage => 'Brikbillede';

  @override
  String get importColorSettings => 'Importér farveindstillinger';

  @override
  String get exportColorSettings => 'Eksporter farveindstillinger';

  @override
  String get import => 'Importér';

  @override
  String get export => 'Eksportér';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Kopier venligst JSON-formatindstillingerne til udklipsholderen først.';

  @override
  String get copiedToClipboard => 'Kopieret til udklipsholder.';

  @override
  String get imported => 'Importeret.';

  @override
  String get boardImage => 'Bræt billede';

  @override
  String get autumnLeaves => 'Efterårsblade';

  @override
  String get legendaryLand => 'Legendarisk Land';

  @override
  String get vignetteEffect => 'Vignet effekt';

  @override
  String get promptMakeToolbarTransparent =>
      'Vil du gøre værktøjslinjen fuldstændig gennemsigtig, når et baggrundsbillede til tavlen er indstillet?';

  @override
  String get vibration => 'Aktiver vibration i spillet';

  @override
  String get soundTheme => 'Lydtema';

  @override
  String get ball => 'Bold';

  @override
  String get liquid => 'Væske';

  @override
  String get wood => 'Træ';

  @override
  String get placeEffectAnimation => 'Animations­effekt ved placering af brik';

  @override
  String get removeEffectAnimation => 'Animations­effekt ved fjernelse af brik';

  @override
  String get isToolbarAtBottom => 'Vis værktøjslinje i bunden';

  @override
  String get boardCornerRadius => 'Radius af bordhjørne';

  @override
  String get useOpeningBook => 'Brug åbningsbog';

  @override
  String get currentRule => 'Nuværende';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Regelsæt';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'One-Time Mill';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'Lad AI bruge åbningsflytninger, som er almindeligt anvendt af professionelle menneskelige spillere i det tidlige spil. Bemærk: Denne funktion er i øjeblikket kun tilgængelig for bestemte regelsæt.';

  @override
  String get showAdvantageGraph => 'Vis fordelsgraf';

  @override
  String get advantageGraphHint =>
      'Fordelsgrafen vil kun blive tegnet, efter at AI\'en foretager et træk. Den vil ikke blive tegnet, når den menneskelige spiller foretager et træk.';

  @override
  String get removalBasedOnMillCounts =>
      'Deaktiver fjernelse, indtil alle brikker er placeret. Spillerne fjerner brikker baseret på antallet af møller.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Deaktiver fjernelse, indtil alle brikker er placeret. Spillerne fjerner brikker baseret på antallet af møller: hvis antallet er det samme, fjerner begge spillere det samme antal brikker; hvis den ene har flere, fjerner han en ekstra brik for at opretholde en forskel på én brik. Hvis kun én spiller danner en mølle, fjerner denne to brikker, mens den anden fjerner én. Hvis ingen danner en mølle, fjerner begge en brik.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Vælg en af dine brikker.';

  @override
  String get notYourTurn => 'Det er ikke din tur.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Baggrundsfarve for annotationsværktøjslinje';

  @override
  String get annotationToolbarIconColor =>
      'Ikonfarve for annotationsværktøjslinje';

  @override
  String get isAnnotationToolbarShown => 'Vis annotationsværktøjslinje';

  @override
  String get enterAnnotationMode => 'Gå ind i annotations tilstand';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Er du sikker på, at du vil rydde alle annotationer?';

  @override
  String get llmPromptCopiedToClipboard =>
      'LLM prompt kopieret til udklipsholder.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Forbindelse nægtet, serveren kan være nede.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Opdagelse succesfuld, afventer forbindelse...';

  @override
  String get noLanConnection => 'Ingen LAN-forbindelse';

  @override
  String get takeScreenshot => 'Tag skærmbillede';

  @override
  String get disconnectedFromOpponent => 'Afbrudt fra modstander.';

  @override
  String get takeBackRequest => 'Anmodning om at tage tilbage';

  @override
  String get nothingToShow => 'Intet at vise.';

  @override
  String get stopHosting => 'Stop med at hoste';

  @override
  String get connectionResetByPeer => 'Forbindelse nulstillet af peer.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Forbindelse mistet på grund af heartbeat timeout. Venligst genopret forbindelse.';

  @override
  String get startHosting => 'Start med at hoste';

  @override
  String get restartRequestRejected => 'Genstarts anmodning afvist.';

  @override
  String get notConnectedToLanOpponent => 'Ikke forbundet til LAN modstander.';

  @override
  String get llmPrompt => 'LLM prompt';

  @override
  String get gameRestarted => 'Spil genstartet.';

  @override
  String get takeBackRejected => 'Tage tilbage afvist.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Er du sikker på, at du vil give op i dette spil?';

  @override
  String get opponentResignedYouWin => 'Modstander gav op. Du vinder!';

  @override
  String get clearAllAnnotations => 'Ryd alle annotationer';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Forbundet, venter på modstanderens træk...';

  @override
  String get networkStatusDisconnected => 'Netværksstatus: Afbrudt';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Anmodning om at tage tilbage sendt til modstanderen.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'Modstanderen har muligvis forladt spillet';

  @override
  String get connectedToHostSuccessfully => 'Forbundet til vært succesfuldt.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Forbindelse mistet: heartbeat timeout';

  @override
  String get noHostDiscovered => 'Ingen vært opdaget.';

  @override
  String get confirmResignation => 'Bekræft opgivelse';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Startet med at hoste spil, venter på spillere til at deltage...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Forbindelse timed out, netværksforbindelse ustabil.';

  @override
  String get noLlmPromptAvailable => 'Ingen LLM prompt tilgængelig.';

  @override
  String get youResignedGameOver => 'Du gav op. Spil over.';

  @override
  String get serverIp => 'Server IP';

  @override
  String get confirmClear => 'Bekræft rydning';

  @override
  String get opponentSTurn => 'Modstanderens tur.';

  @override
  String get waitingAClientConnection => 'Venter på en klientforbindelse...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Anmodning om at tage tilbage blev afvist eller mislykkedes.';

  @override
  String get addText => 'Tilføj tekst';

  @override
  String get exitAnnotationMode => 'Forlad annotations tilstand';

  @override
  String get typeYourAnnotation => 'Skriv din annotation';

  @override
  String get attemptingToReconnect => 'Forsøger at genoprette forbindelse...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Genstarts anmodning sendt. Venter på modstanderens svar...';

  @override
  String get serverIsStopped => 'Serveren er stoppet.';

  @override
  String get restartRequest => 'Genstarts anmodning';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Kan ikke anmode om at tage tilbage, når det ikke er din tur.';

  @override
  String get takeBackAccepted => 'Tage tilbage accepteret.';

  @override
  String get localNetworkSettings => 'Lokale netværksindstillinger';

  @override
  String get reconnectedSuccessfully => 'Genoprettet forbindelse succesfuldt!';

  @override
  String get failedToSaveImageToGallery =>
      'Kunne ikke gemme billede til galleri.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Modstanderen anmodede om at genstarte spillet. Accepterer du?';

  @override
  String get yourTurn => 'Din tur.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Kunne ikke genoprette forbindelse, venligst genstart spillet.';

  @override
  String get host => 'Vært';

  @override
  String get join => 'Deltag';

  @override
  String get port => 'Port';

  @override
  String get invalidIpAddress => 'Ugyldig IP-adresse.';

  @override
  String get invalidPort => 'Ugyldig port.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Forbinder: Forsøg $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Kunne ikke forbinde: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Kunne ikke starte hosting: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Vært opdaget: $ip:$port';
  }

  @override
  String get stop => 'Stop';

  @override
  String get discover => 'Opdag';

  @override
  String get connect => 'Forbind';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Klient forbundet: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Opdager: $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Genopretter forbindelse ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Forbundet';

  @override
  String get delete => 'Slet';

  @override
  String get ancientEgypt => 'Det Gamle Egypten';

  @override
  String get gothicIce => 'Gotisk Is';

  @override
  String get riceField => 'Rismark';

  @override
  String get chinesePorcelain => 'Kinesisk Porcelæn';

  @override
  String get desertDusk => 'Ørken Skumring';

  @override
  String get precisionCraft => 'Præcisionshåndværk';

  @override
  String get folkEmbroidery => 'Folkestikning';

  @override
  String get carpathianHeritage => 'Karpaternes Arv';

  @override
  String get imperialGrandeur => 'Kejserrigets Storhed';

  @override
  String get bohemianCrystal => 'Bøhmisk Krystal';

  @override
  String get savannaSunrise => 'Savanne Solopgang';

  @override
  String get harmonyBalance => 'Harmoni og Balance';

  @override
  String get cinnamonSpice => 'Kanel Krydderi';

  @override
  String get anatolianMosaic => 'Anatolsk Mosaik';

  @override
  String get carnivalSpirit => 'Karnevalsånd';

  @override
  String get custom => 'Brugerdefinerede';

  @override
  String get spiceMarket => 'Krydderimarked';

  @override
  String get swipeToRevealTheDrawer => 'Stryg for at afsløre skuffen';

  @override
  String get showGameInfoOnScreenshots =>
      'Vis spiloplysninger på skærmbilleder';

  @override
  String get humanMoveTime => 'Tidsgrænse for menneskeligt træk';

  @override
  String get noTimeLimitForHumanMoves =>
      'Ingen tidsgrænse for menneskelige træk';

  @override
  String get timeoutLoseWillBeApplied =>
      'Timeout-tab vil blive anvendt for den menneskelige spiller';

  @override
  String get identifyingBoard => 'Genkender spillebrættet...';

  @override
  String get youCanEnterAnyModelName => 'Du kan indtaste ethvert modelnavn';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Brætstilling anvendt. FEN kopieret til udklipsholderen.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Forslag: Prøv at tage et klarere billede af spillebrættet';

  @override
  String get llmPromptTemplate => 'LLM-promptskabelon';

  @override
  String get noValidBoardDetected => 'Intet gyldigt spillebræt fundet';

  @override
  String get selectingImageFromAlbum => 'Vælger billede fra album...';

  @override
  String get configurePromptTemplate => 'Konfigurer promptskabelon';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Rediger promptskabelon til LLM-analyse';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Kunne ikke generere FEN fra det genkendte spillebræt';

  @override
  String get outputInCurrentLanguage => 'Output på aktuelt sprog';

  @override
  String get commonBaseUrls => 'Almindelige Base URLs';

  @override
  String get viewCommonModels => 'Vis almindelige modeller';

  @override
  String get recognitionParametersUpdated => 'Genkendelsesparametre opdateret';

  @override
  String get whiteSMove => 'Hvids træk';

  @override
  String get resetToDefaults => 'Nulstil til standardindstillinger';

  @override
  String get photoShoot => 'Fotosession';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Kunne ikke anvende den genkendte brætstilling';

  @override
  String get llmPromptContent => 'LLM-promptindhold';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM ikke konfigureret. Tjek dine indstillinger.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Angiv udbyder, model, API Key og Base URL';

  @override
  String get llmConfiguration => 'LLM-konfiguration';

  @override
  String get configureLlmProvider => 'Konfigurer LLM-udbyder';

  @override
  String get llmPromptTemplateHeader => 'LLM-promptskabelonoverskrift';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Ingen brikker blev genkendt på billedet. Prøv igen.';

  @override
  String get recognizeBoardFromImage => 'Genkend spillebræt fra billede';

  @override
  String get viewTips => 'Vis tips';

  @override
  String get applyToBoard => 'Anvend på brættet';

  @override
  String get adjustBoardArea => 'Juster brætområdet';

  @override
  String get viewCommonUrls => 'Vis almindelige URLs';

  @override
  String get colorAnalysisFailed => 'Farveanalyse mislykkedes!';

  @override
  String get analyzingGameBoardImage => 'Analyserer billede af spillebræt...';

  @override
  String get selectFromAlbum => 'Vælg fra album';

  @override
  String get noBoardPointDetected => 'Ingen brætpunkt fundet!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Hvis feltet er tomt, bruges standardskabelonen';

  @override
  String get llmConfig => 'LLM-konfiguration';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Er du sikker på, at du vil nulstille promptskabelonerne til standardværdier?';

  @override
  String get llmPromptTemplateFooter => 'LLM-promptskabelonsidefod';

  @override
  String get loadingResponse => 'Indlæser svar...';

  @override
  String get applyThisResultToBoard => 'Anvend dette resultat på brættet';

  @override
  String get takingPicture => 'Tager billede...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Vælg venligst et billede af et spillebræt til identifikation';

  @override
  String get identificationResults => 'Identifikationsresultater';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Analyser træk og giv indsigter.';

  @override
  String get getApiKey => 'Få API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Hele genkendelsesprocessen kunne ikke fuldføres';

  @override
  String get boardRecognitionResult => 'Resultat af brætgenkendelse';

  @override
  String get askLlm => 'Spørg LLM';

  @override
  String get boardDetectionFailed => 'Brætdetektering mislykkedes!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Intet brætpunkt detekteret, kan ikke identificere brik!';

  @override
  String get copyFen => 'Kopier FEN';

  @override
  String get commonlyUsedModels => 'Almindeligt anvendte modeller';

  @override
  String get apiKeyOptional => 'API Key (valgfri)';

  @override
  String get noImageSelected => 'Intet billede valgt';

  @override
  String get blackSMove => 'Sorts træk';

  @override
  String get llm => 'Stort sprogmodel';

  @override
  String get llmProvider => 'Udbyder';

  @override
  String get baseUrl => 'Basis-URL';

  @override
  String get model => 'Model';

  @override
  String get temperature => 'Temperatur';

  @override
  String get llmCommandReceivedProcessing =>
      'Kommando modtaget! AI behandler...';

  @override
  String get llmDeepThinkingWait => 'Dyb tænkning i gang, vent venligst...';

  @override
  String get llmPresentingSoon => 'Præsenteres snart...';

  @override
  String get recognitionParameters => 'Genkendelsesparametre';

  @override
  String get adjustParamsDesc =>
      'Juster parametre for at forbedre genkendelsesnøjagtigheden';

  @override
  String get saveParameters => 'Gem parametre';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Kan ikke starte billedgenkendelse: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Billedgenkendelse mislykkedes: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Anvendt position med $whiteCount hvide og $blackCount sorte brikker';
  }

  @override
  String get fenCopiedToClipboard => '(FEN kopieret til udklipsholder)';

  @override
  String recognitionFailed(String error) {
    return 'Genkendelse mislykkedes: $error';
  }

  @override
  String get myRating => 'Min bedømmelse';

  @override
  String get gamesPlayed => 'Spillede spil';

  @override
  String get wins => 'Sejre';

  @override
  String get losses => 'Tab';

  @override
  String get draws => 'Uafgjorte';

  @override
  String get lastUpdated => 'Sidst opdateret';

  @override
  String get format => 'Format:';

  @override
  String get resetStatistics => 'Nulstil statistik';

  @override
  String get drawRate => 'Uafgjort rate';

  @override
  String get lossRate => 'Tab rate';

  @override
  String get aiStatistics => 'AI-statistik';

  @override
  String get enableStatistics => 'Aktiver statistik';

  @override
  String get enableStatistics_Detail =>
      'Når det er aktiveret, vil spilresultater blive registreret i statistikken. Spil, der involverer tilbagetrækninger, vil dog ikke blive registreret. Når det er deaktiveret, sættes statistikindsamlingen på pause.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Dette nulstiller al spilstatistik. Denne handling kan ikke fortrydes.';

  @override
  String get boardInnerRingSize => 'Størrelse på den indre ring på brættet';

  @override
  String get boardShadowEnabled => 'Brætskygge';

  @override
  String get trapAwareness => 'Fældedetektion';

  @override
  String get trapAwarenessDescription =>
      'Fremhæv fældetræk med tykke cirkler og pile under analysen.';

  @override
  String trapExists(String trapMoves) {
    return 'Der er en fælde. Fældetræk: $trapMoves';
  }

  @override
  String get custodianCapture => 'Flankerende fangst';

  @override
  String get custodianCaptureDescription =>
      'Luk en af dine modstanders stykker mellem to af dine i en lige linje for at fange den.';

  @override
  String get custodianCaptureEnable => 'Tillad flankerende indfangning';

  @override
  String get interventionCapture => 'Intervention Capture';

  @override
  String get interventionCaptureDescription =>
      'Gå ind i det tomme punkt mellem to af dine modstanders stykker for at fange dem begge.';

  @override
  String get interventionCaptureEnable => 'Tillad interventionsfangst';

  @override
  String get leapCapture => 'Fangst ved at hoppe';

  @override
  String get leapCaptureDescription =>
      'Fangst ved at hoppe over en tilstødende modstanders stykke ind i det tomme punkt ud over.';

  @override
  String get leapCaptureEnable => 'Tillad hoppindfangning';

  @override
  String get captureApplicableLines => 'Relevante linjer';

  @override
  String get captureSquareEdges => 'Langs firkantens kanter';

  @override
  String get captureCrossLines =>
      'Langs ortogonale linjer, der krydser firkanten';

  @override
  String get captureDiagonalLines =>
      'Langs diagonale linjer, der krydser firkanten';

  @override
  String get captureExecutionPhases => 'Henrettelsesfaser';

  @override
  String get capturePiecesCondition =>
      'Tilgængelighed i den bevægelige fase baseret på resterende stykker';

  @override
  String get capturePiecesConditionUnlimited => 'Ingen begrænsning';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Tilgængelig, når du har tre eller færre stykker';
}
