// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Czech (`cs`).
class SCs extends S {
  SCs([String locale = 'cs']) : super(locale);

  @override
  String get appName => 'Mlýn';

  @override
  String get welcome => 'Vítejte';

  @override
  String get yes => 'Ano';

  @override
  String get no => 'Ne';

  @override
  String get game => 'Hra';

  @override
  String get humanVsAi => 'Člověk vs. AI';

  @override
  String get humanVsHuman => 'Člověk Vs Člověk';

  @override
  String get aiVsAi => 'AI vs. AI';

  @override
  String get humanVsCloud => 'Člověk vs. Cloud';

  @override
  String get humanVsLAN => 'Člověk vs. LAN';

  @override
  String get testViaLAN => 'Test přes LAN';

  @override
  String get move => 'Tah';

  @override
  String get showMoveList => 'Seznam tahů';

  @override
  String get moveList => 'Seznam tahů';

  @override
  String get noGameRecord => 'Žádný záznam';

  @override
  String get ok => 'OK';

  @override
  String get confirm => 'Potvrdit';

  @override
  String get cancel => 'Zrušit';

  @override
  String get tipSelectWrong => 'Vybrali jste špatný kámen.';

  @override
  String get tipPlace => 'Umístěte své kameny.';

  @override
  String get tipBanPlace => 'Nelze jej sem umístit.';

  @override
  String get tipPlaced => 'Umístěno.';

  @override
  String get tipRemove => 'Odstraňte kámen.';

  @override
  String get tipBanRemove => 'Nelze odebrat.';

  @override
  String get tipRemoved => 'Odstraněno.';

  @override
  String get tipMove => 'Přesuňte kus.';

  @override
  String get tipCannotPlace => 'Sem nemůžete umístit svůj kousek.';

  @override
  String get tipCannotMove => 'Sem nemůžete přesunout svůj kousek.';

  @override
  String get tipMill => 'Mlýn! Vezměte soupeřovu figuru.';

  @override
  String get tipContinueMill => 'Pokračujte v získávání soupeřovy figurky.';

  @override
  String get tipSelectOpponentsPiece =>
      'Vyberte si jednu ze soupeřových figurek.';

  @override
  String get tipCannotRemovePieceFromMill => 'Kus nelze z mlýna odebrat.';

  @override
  String get tipCanMoveOnePoint => 'Kus se může pohybovat o 1 bod.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Nemůžete přesouvat kusy svého soupeře.';

  @override
  String get tipSelectPieceToMove => 'Vyberte kousek, který chcete přesunout.';

  @override
  String get tipHaveThreePiecesLeft => 'Zbývají vám 3 kameny.';

  @override
  String get tipCanMoveToAnyPoint =>
      'Můžete přesunout kámen na libovolné volné pole.';

  @override
  String tipToMove(Object player) {
    return '$player přesunout.';
  }

  @override
  String get whiteWin => 'Hráč 1 vyhrává!';

  @override
  String get blackWin => 'Hráč 2 vyhrává!';

  @override
  String get won => 'Vyhrál';

  @override
  String get lost => 'Prohrál';

  @override
  String get thinking => 'Přemýšlím...';

  @override
  String get newGame => 'Nová hra';

  @override
  String get importGame => 'Importovat hru';

  @override
  String get exportGame => 'Exportovat hru';

  @override
  String get gameImported => 'Hra byla importována.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Nelze importovat $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'Tahy a pravidla se neshodují.';

  @override
  String get pleaseWait => 'Prosím, čekejte...';

  @override
  String get restartGame => 'Restartovat aktuální hru?';

  @override
  String get restart => 'Restartujte';

  @override
  String get gameStarted => 'Hra začala, prosím, umístěte.';

  @override
  String get analyzing => 'Probíhá analýza…';

  @override
  String error(Object message) {
    return 'Chyba: $message';
  }

  @override
  String get winRate => 'Míra výhry';

  @override
  String get score => 'Skóre:';

  @override
  String get white => 'Hráč 1';

  @override
  String get black => 'Hráč 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player počet kusů je menší než tři.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player rezignoval.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player nemá kam jít.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Deska je plná a $player nemá kam jít.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Čas vypršel, $player prohrál.';
  }

  @override
  String get drawReasonRule50 =>
      'Ve fázi pohybu nebyl v posledním konkrétním počtu tahů odstraněn žádný kus.';

  @override
  String get drawReasonBoardIsFull =>
      'Jedná se o Draw, protože hrací deska je plná.';

  @override
  String get drawReasonThreefoldRepetition =>
      'Jedná se o Draw kvůli trojnásobnému opakování.';

  @override
  String get gameOverUnknownReason => 'Konec hry! Neznámý důvod.';

  @override
  String get gameOver => 'Konec hry';

  @override
  String get youWin => 'Vyhráváte! Gratulujeme!';

  @override
  String challengeHarderLevel(int level) {
    return 'Vyzvat těžší úroveň? Nová úroveň bude úroveň $level!';
  }

  @override
  String get youLose => 'Prohrál jsi!';

  @override
  String get analyze => 'Analyzovat';

  @override
  String get about => 'O';

  @override
  String version(Object versionNumber) {
    return 'Verze: $versionNumber';
  }

  @override
  String get thanks => 'dík';

  @override
  String get settings => 'Nastavení';

  @override
  String get options => 'Možnosti';

  @override
  String get generalSettings => 'Obecná nastavení';

  @override
  String get skillLevel => 'Stupeň obtížnosti';

  @override
  String get moveTime => 'Doba přemýšlení AI';

  @override
  String get difficulty => 'Obtížnost';

  @override
  String get playSounds => 'Zvukové efekty';

  @override
  String get playSoundsInTheGame => 'Přehrávat zvuky během hry';

  @override
  String get keepMuteWhenTakingBack => 'Zachovat ticho při vracení tahu';

  @override
  String get tone => 'Tón';

  @override
  String get whoMovesFirst => 'První tah';

  @override
  String get human => 'Člověk';

  @override
  String get ai => 'AI';

  @override
  String get alternate => 'Střídat';

  @override
  String get isAutoRestart => 'Automaticky restartovat hru po skončení hry';

  @override
  String get isAutoChangeFirstMove => 'Automatická změna prvního tahu';

  @override
  String get shufflingEnabled => 'Náhodné tahy';

  @override
  String get misc => 'Různé';

  @override
  String get rules => 'Pravidla';

  @override
  String get piecesCount => 'Počet figurek, které má každý hráč';

  @override
  String get piecesCount_Detail => 'Kolik figurek má každý hráč?';

  @override
  String get flyPieceCount => 'Číslo létajícího kusu';

  @override
  String get flyPieceCount_Detail =>
      'Pokud je povoleno létání, když je hráč snížen na konkrétní počet figurek, její figurky se mohou volně pohybovat do jakéhokoli neobsazeného bodu, místo aby byly omezeny na sousední body jako ve zbytku hry.';

  @override
  String get piecesAtLeastCount => 'Kusy nejméně';

  @override
  String get hasDiagonalLines => 'Diagonální čáry';

  @override
  String get hasDiagonalLines_Detail =>
      'Přidejte na desku čtyři diagonální čáry.';

  @override
  String get isDefenderMoveFirst => 'Druhý hráč se pohybuje jako první';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Hráč, který se ve fázi umístění pohybuje na druhém místě, se ve fázi pohybu pohybuje jako první.';

  @override
  String get mayRemoveMultiple => 'Vícenásobné odebrání';

  @override
  String get mayRemoveMultiple_Detail =>
      'Pokud hráč zavře více než jeden mlýn najednou, bude moci odebrat počet mlýnů, které uzavřela.';

  @override
  String get mayRemoveFromMillsAlways => 'Zničte mlýny';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Ve výchozím nastavení musí hráči nejprve odebrat všechny další figurky, než odeberou figurku z formovaného mlýna. Povolením této možnosti zakážete omezení.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Druhý hráč prohraje, když je hrací plocha plná';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Na konci fáze umístění, když je hrací deska plná, strana, která umístí první, prohrává hru, jinak je hra remízou.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Ztratit, když žádné legální pohyby';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Hráč ztratí, pokud je jeho protivník zablokuje, takže jimi nelze hýbat. Pokud je tato možnost zakázána, změňte stranu na pohyb.';

  @override
  String get mayFly => 'Létající';

  @override
  String get mayFly_Detail =>
      'Pokud hráči zbývají pouze tři nebo čtyři (konfigurovatelné) figurky, může figurku přesunout na libovolný volný bod.';

  @override
  String get nMoveRule => 'Pravidlo N-move';

  @override
  String get nMoveRule_Detail =>
      'Hra je losována, pokud nedošlo k odstranění v určitém počtu tahů každého hráče.';

  @override
  String get rollback => 'Vrátit zpět';

  @override
  String get pleaseSelect => 'Prosím vyberte';

  @override
  String get copy => 'kopírovat';

  @override
  String get moveHistoryCopied =>
      'Přesunout historii zkopírovanou do schránky.';

  @override
  String get help => 'Pomoc';

  @override
  String get feedback => 'Zpětná vazba';

  @override
  String get exit => 'Výstup';

  @override
  String get ruleSettings => 'Nastavení pravidel';

  @override
  String get color => 'Barva';

  @override
  String get boardColor => 'Barva desky';

  @override
  String get pieceColor => 'Barva kusu';

  @override
  String get backgroundColor => 'Barva pozadí';

  @override
  String get lineColor => 'Barva čáry desky';

  @override
  String get whitePieceColor => 'Barva kamenů hráče 1';

  @override
  String get blackPieceColor => 'Barva kamenů hráče 2';

  @override
  String get messageColor => 'Barva zprávy';

  @override
  String get isPieceCountInHandShown => 'Zobrazit počet kusů v ruce';

  @override
  String get isNotationsShown => 'Zobrazit notace na palubě';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Zobrazit panel nástrojů pro navigaci v historii';

  @override
  String get display => 'Zobrazit';

  @override
  String get boardBorderLineWidth => 'Šířka hranice desky';

  @override
  String get boardInnerLineWidth => 'Šířka vnitřní čáry desky';

  @override
  String get pieceWidth => 'Šířka kusu';

  @override
  String get fontSize => 'Velikost písma';

  @override
  String get standardNotation => 'Zápis WMD';

  @override
  String get restore => 'Obnovit';

  @override
  String get restoreDefaultSettings => 'Obnovit výchozí nastavení';

  @override
  String pick(Object element) {
    return 'Vyberte $element';
  }

  @override
  String get info => 'Info';

  @override
  String get hint => 'Náznak';

  @override
  String get player => 'hráč';

  @override
  String get player1 => 'Hráč 1';

  @override
  String get player2 => 'Hráč 2';

  @override
  String get howToPlay => 'Jak hrát';

  @override
  String get toPlacePiece =>
      'Klepnutím na libovolný dostupný bod umístíte díl.';

  @override
  String get toSelectPiece => 'Klepnutím na kus jej přesuňte.';

  @override
  String get toMovePiece => 'Klepnutím na bod připojený k dílu jej přesuňte.';

  @override
  String get toRemovePiece => 'Klepnutím na soupeřovu jednu figuru odeberete.';

  @override
  String get needToCreateMillFirst =>
      'Před odstraněním kusu musíte nejprve vytvořit mlýn.';

  @override
  String get needToPlayWithOwnPieces => 'Musíte si hrát se svými figurkami.';

  @override
  String get statistics => 'Statistika';

  @override
  String get totalGames => 'Celkem her';

  @override
  String get results => 'Výsledek';

  @override
  String get left => 'vlevo, odjet';

  @override
  String get privacyPolicy => 'Zásady ochrany osobních údajů';

  @override
  String get privacyPolicy_Detail_1 =>
      'Přečtěte si pozorně a ujistěte se, že tomu plně rozumíte a souhlasíte s tím ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Pokud s těmito zásadami nesouhlasíte, nepoužívejte tuto aplikaci. Používání aplikace znamená, že přijímáte tyto podmínky.';

  @override
  String get and => ' a ';

  @override
  String get accept => 'Akceptovat';

  @override
  String get takeBack => 'Vzít zpět';

  @override
  String get takingBack => 'Vzít zpět…';

  @override
  String get waiting => 'Čekání…';

  @override
  String get stepForward => 'Krok vpřed';

  @override
  String get takeBackAll => 'Vezměte zpět všechny';

  @override
  String get stepForwardAll => 'Krok vpřed všichni';

  @override
  String get moveNow => 'Přesun hned';

  @override
  String get done => 'Hotovo.';

  @override
  String get crackMill => 'Crack-mlýn';

  @override
  String get crackMill_Detail =>
      'Pokud má hráč pouze kousky v mlýnech, kousky v mlýnech se nezamknou a nebudou odstraněny.';

  @override
  String get animationDuration => 'Délka animace';

  @override
  String get none => 'Žádný';

  @override
  String get theme => 'Téma';

  @override
  String get helpContent =>
      'Cílem hry je nechat soupeře s méně než třemi kusy nebo bez legálních tahů.\n\nHra se automaticky losuje, pokud dojde k pozici již potřetí, nebo pokud během posledních 100 (konfigurovatelných) tahů nedošlo k odebrání.\n\nHra probíhá ve třech fázích:\n\n1. Ukládání dílků na volná místa\n2. Přesunutí kusů do sousedních bodů\n3. (volitelná fáze) Přesouvání figurek na libovolné volné místo, když byl hráč snížen na tři figurky\n\nUmístění\n\nHra začíná prázdnou deskou, kterou tvoří mřížka s dvaceti čtyřmi body. Hráči se střídají při umisťování svých figurek na volné body, dokud každý hráč neumístí všechny figurky na hrací plochu. Pokud hráč může umístit tři své figurky do přímky, má „mlýn“ a může odstranit jednu ze svých soupeřových figurek z hrací plochy.\n\nV některých variantách pravidel musí hráči nejprve odebrat všechny další figurky, než odeberou figurku z formovaného mlýna.\n\nV některých variantách pravidel nemusí být všechny body odstraněných figurek znovu umístěny do umisťovací fráze.\n\nJakmile jsou použity všechny figurky, hráči se střídají v pohybu.\n\nPohyb\n\nHráč se pohybuje jedním ze svých kamenů po palubní linii na volné sousední místo. Pokud tak nemůže učinit, prohrál hru. Stejně jako ve fázi umístění má hráč, který zarovná tři své figurky na hrací čáru, mlýn a může odstranit jednu ze svých soupeřových figurek. Každý hráč se sníží na dva kusy a nemá možnost vytvářet nové mlýny, a tak prohrává. Hráč může také prohrát s více než třemi kameny, pokud je jeho protivník zablokuje, takže jimi nelze hýbat.\n\nLétající\n\nV některých variantách pravidel, jakmile hráči zbývají pouze tři kameny, mohou jeho kameny „létat“, „skákat“ nebo „skákat“ na libovolná volná místa, nejen na sousední.\n';

  @override
  String get versionInfo => 'Informace o verzi';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'Licence';

  @override
  String get sourceCode => 'Zdrojový kód';

  @override
  String get appVersion => 'Verze aplikace';

  @override
  String get general => 'Všeobecné';

  @override
  String get advanced => 'Pokročilý';

  @override
  String get placing => 'Umístění';

  @override
  String get moving => 'Pohyb';

  @override
  String get removing => 'Odstraňování';

  @override
  String get gameOverCondition => 'Stav hry přes';

  @override
  String get aisPlayStyle => 'AI je herní styl';

  @override
  String get passive => 'Pasivní';

  @override
  String get timeout => 'Časový limit';

  @override
  String get appearance => 'Vzhled';

  @override
  String get drawOnHumanExperience => 'Čerpejte z lidské zkušenosti';

  @override
  String get considerMobility => 'Zvažte mobilitu kusů';

  @override
  String get pieceCount => 'Počet kusů:';

  @override
  String inHand(Object player, int count) {
    return '$player v ruce: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player na palubě: $count';
  }

  @override
  String get boardTop => 'Odsazení desky shora';

  @override
  String get notAIsTurn => 'Na řadě není AI.';

  @override
  String get aiIsNotThinking => 'AI nemyslí.';

  @override
  String get atEnd => 'Na konci seznamu přesunutí.';

  @override
  String get tapBackAgainToLeave => 'Opětovným klepnutím zpět odejdete.';

  @override
  String get more => 'Více';

  @override
  String get experimental => 'Toto je experimentální funkce.';

  @override
  String get experiments => 'Experimenty';

  @override
  String get ossLicenses => 'Licence open source';

  @override
  String get language => 'Jazyk';

  @override
  String get defaultLanguage => 'Základní jazyk';

  @override
  String get mayMoveInPlacingPhase =>
      'Figurky se mohou pohybovat ve fázi umísťování';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Fáze umisťování a fáze pohybu nejsou odděleny, tj. hráči se mohou v každém tahu rozhodnout, zda chtějí umístit figurku na hrací plochu, nebo zda chtějí některou ze svých figurek přemístit (pokud jim zbývají figurky k umístění).';

  @override
  String get drawerColor => 'Barva nabídky';

  @override
  String get drawerTextColor => 'Barva textu nabídky';

  @override
  String get drawerHighlightItemColor => 'Barva zvýraznění položky nabídky';

  @override
  String get mainToolbarBackgroundColor =>
      'Barva pozadí hlavního panelu nástrojů';

  @override
  String get mainToolbarIconColor => 'Barva ikony hlavního panelu nástrojů';

  @override
  String get navigationToolbarBackgroundColor =>
      'Barva pozadí navigačního panelu nástrojů';

  @override
  String get navigationToolbarIconColor =>
      'Barva ikony navigačního panelu nástrojů';

  @override
  String get autoHideToolbar => 'Automatické skrytí panelu nástrojů';

  @override
  String get toolbarLocationOnScreen => 'Umístění panelu nástrojů na obrazovce';

  @override
  String get top => 'Nahoru';

  @override
  String get bottom => 'Spodní část';

  @override
  String get center => 'Středisko';

  @override
  String get solidColor => 'Plná barva';

  @override
  String get picture => 'Obrázek';

  @override
  String get chooseYourPicture => 'Vyberte si obrázek';

  @override
  String get light => 'Světlo';

  @override
  String get dark => 'Temný';

  @override
  String get themes => 'Témata';

  @override
  String get currentTheme => 'Aktuální téma';

  @override
  String get saveTheme => 'Uložit téma';

  @override
  String get showAnalysisGraph => 'Zobrazit graf analýzy';

  @override
  String get analysis => 'Analýza';

  @override
  String get saveGame => 'Uložit hru';

  @override
  String get loadGame => 'Načtení hry';

  @override
  String get setupPosition => 'Pozice nastavení';

  @override
  String get showLegalMoves => 'Zobrazit legální pohyby';

  @override
  String get showLastMove => 'Zobrazit poslední tah';

  @override
  String get showArrows => 'Zobrazit šipky';

  @override
  String get pieces => 'Kusy';

  @override
  String get showAnalysis => 'Zobrazit analýzu';

  @override
  String get threads => 'Vlákna';

  @override
  String get getInvolved => 'Zapojte se';

  @override
  String get helpImproveTranslate => 'Pomozte zlepšit překlad';

  @override
  String get tutorial => 'Výukový program';

  @override
  String get classicMill => 'Klasický mlýn';

  @override
  String get mixedMill => 'Smíšený mlýn';

  @override
  String get ceylonMill => 'Cejlonský mlýn';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Mlýn může být opakovaně rozbit a znovu vyroben';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Pokud hráč rozbije mlýn, aby okamžitě vytvořil nový mlýn, může takovou figurku v dalším tahu přesunout zpět na původní křižovatku, pokud vytvoří nový mlýn.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Hra je nerozhodná, pokud má hráč tři figurky a po deseti tazích žádný z hráčů neodstraní soupeřovy figurky';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Když hráčům zbývají tři figury a žádný z nich nedokáže odstranit soupeřovu figuru do deseti tahů, hraje se nerozhodně.';

  @override
  String get close => 'Zavřít';

  @override
  String get whitePiece => 'Bílý kousek';

  @override
  String get blackPiece => 'Černý kousek';

  @override
  String get emptyPoint => 'Prázdný bod';

  @override
  String get noPoint => 'Nemá smysl';

  @override
  String get placingPhase => 'Fáze umístění';

  @override
  String get movingPhase => 'Pohybující se fáze';

  @override
  String get flyingPhase => 'Létající fáze';

  @override
  String sideToMove(Object player) {
    return 'Strana k pohybu: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Poslední tah: $move';
  }

  @override
  String get selected => 'Vybraný';

  @override
  String get accessibility => 'Přístupnost';

  @override
  String get screenReaderSupport => 'Podpora čtečky obrazovky';

  @override
  String get isDraw => 'Je to remíza!';

  @override
  String get draw => 'Remíza';

  @override
  String get pieceHighlightColor => 'Barva zvýraznění kusu';

  @override
  String get algorithm => 'Algoritmus';

  @override
  String get endgameNMoveRule => 'Pravidlo Endgame N-Move';

  @override
  String get endgameNMoveRule_Detail =>
      'Pokud má některý z hráčů pouze tři figurky a žádný z hráčů neodstraní figurku v rámci konkrétních tahů, hra se losuje.';

  @override
  String get drawReasonEndgameRule50 =>
      'Každý hráč má pouze tři figurky a žádný z hráčů neodstraní figurku v rámci konkrétních tahů.';

  @override
  String get threefoldRepetitionRule => 'Pravidlo trojnásobného opakování';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Hra se losuje, pokud se pozice objeví potřetí.';

  @override
  String get continueToMakeMove => 'Mlýn! Pokračujte v pohybu.';

  @override
  String get pointStyle => 'Bodový styl';

  @override
  String get pointWidth => 'Šířka bodu';

  @override
  String get solid => 'Pevný';

  @override
  String get hollow => 'Dutý';

  @override
  String get languageName => 'Čeština';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Pohyby',
      one: '$count Tah',
      zero: 'Tah',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Načtení se nezdařilo.';

  @override
  String get filename => 'Název souboru';

  @override
  String get browse => 'Procházet…';

  @override
  String get gameFiles => 'Herní soubory';

  @override
  String get gameSavedTo => 'Hra je uložena do';

  @override
  String get empty => 'Prázdný';

  @override
  String get noMove => 'Žádný pohyb.';

  @override
  String get restoredPosition => 'Obnovena výchozí pozice.';

  @override
  String get clean => 'Čistý';

  @override
  String get cleanedUp => 'Uklizený.';

  @override
  String get remove => 'Odstranit';

  @override
  String get noPiecesCanBeRemoved => 'Žádné kusy nelze odstranit.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count kusy',
      one: '$count kus',
      zero: 'Piece',
    );
    return '$_temp0 je třeba odstranit.';
  }

  @override
  String placedCount(int count) {
    return 'Umístě. ($count)';
  }

  @override
  String get placedPieceCount => 'Počet umístěných kusů ve fázi umístění.';

  @override
  String hasPlacedPieceCount(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Aktuální hráč umístil $count figurek.',
      many: 'Aktuální hráč umístil $count figurek.',
      few: 'Aktuální hráč umístil $count figurky.',
      one: 'Aktuální hráč umístil jednu figurku.',
      zero: 'Aktuální hráč neumístil žádné figurky.',
    );
    return '$_temp0';
  }

  @override
  String get notPlacingPhase => 'Fáze umístění, nelze ji změnit.';

  @override
  String get paste => 'Vložit';

  @override
  String get pasteDone => 'Pasta je hotová.';

  @override
  String get cannotPaste => 'Nelze vložit.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Zobrazit neumístěné a odstraněné kusy';

  @override
  String get fullScreen => 'Celá obrazovka';

  @override
  String get reopenToTakeEffect =>
      'Ukončete a znovu otevřete aplikaci, aby se nastavení projevila.';

  @override
  String get forest => 'Les';

  @override
  String get desktopImage => 'Obrázek pozadí';

  @override
  String get invalidPosition => 'Neplatná pozice.';

  @override
  String get shareGIF => 'Sdílet GIF';

  @override
  String get pixelRatio => 'Poměr pixelů';

  @override
  String get duration => 'Doba trvání';

  @override
  String get gameScreenRecorder => 'Záznamník herní obrazovky';

  @override
  String get previous => 'Předchozí';

  @override
  String get next => 'další';

  @override
  String get skip => 'Přeskočit';

  @override
  String get gotIt => 'Mám to';

  @override
  String get youCanModifyRules =>
      'Pravidla hry můžete upravit v nastavení pravidel.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Pomocí kolečka myši můžete změnit hodnotu ve výběru.';

  @override
  String get noTimeLimitForThinking =>
      'AI Doba myšlení nastavená na 0 znamená, že na přemýšlení není žádný časový limit.';

  @override
  String get whatIsMtdf =>
      'MTD(f) je upravená forma vyhledávacího algoritmu alfa-beta, jehož cílem je zlepšit efektivitu opakovaným použitím mezivýsledků vyhledávání a použitím dobrého počátečního odhadu k zúžení prostoru pro vyhledávání.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Uvědomte si prosím, že úprava doby myšlení AI nemusí být zcela přesná. Skutečná doba přemýšlení může být kratší, když je úroveň obtížnosti nastavena na nižší hodnotu, a může být delší, když je AI uprostřed myšlenky, když čas vyprší.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Pokud nastavíte vysokou úroveň obtížnosti, ale nezvýšíte dobu přemýšlení AI, může být skutečná úroveň obtížnosti omezena na nižší hodnotu kvůli časovému omezení. Skutečná hodnota se může lišit v závislosti na výkonu stroje.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) je vyhledávací algoritmus pro nalezení nejlepšího pohybu v dané pozici. Jedná se o vylepšení algoritmu alfa-beta a používá vyhledávání nulového nebo nulového okna k potvrzení, že tah je horší nebo ne horší než již bezpečné skóre z hlavní variace. PVS se zaměřuje na nejslibnější tahy a vyhýbá se zbytečnému prohledávání suboptimálních větví, což pomáhá zlepšit efektivitu vyhledávání.';

  @override
  String get whatIsAlphaBeta =>
      'Algoritmus alfa-beta je vyhledávací algoritmus k nalezení nejlepšího tahu. Využívá princip minimaxu a dvou hodnot, alfa a beta, k ořezávání vyhledávacího stromu a zvýšení efektivity. Alfa představuje minimální skóre, o kterém si je počítač jistý, že může získat, zatímco beta představuje maximální skóre, které může získat jeho soupeř. Algoritmus pomáhá počítači činit chytrá a efektivní rozhodnutí ve hře.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Podle lidských zkušeností, když se pokusíte vyhrát, prohrajete. Místo toho si dejte za cíl remízu a vyhněte se prohře. Pozorujte svého soupeře a jemně ho nalákejte do pozice, kde může dělat chyby. Když ukážou slabost, chopte se příležitosti a jemně zatlačte na vítězství. Tímto způsobem můžete hru vyhrát.';

  @override
  String get firstMoveDetail =>
      'V této hře je pro druhého hráče snazší vyhrát ve srovnání s prvním hráčem.';

  @override
  String get passiveDetail =>
      'Aktivace pasivní možnosti způsobí, že se AI uvolní, když má v pozici výhodu, než aby se agresivně snažila vyhrát co nejrychleji.';

  @override
  String get moveRandomlyDetail =>
      'Povolením této možnosti zvýšíte náhodnost a zábavu hry, zatímco její vypnutí může pomoci studovat způsoby, jak porazit AI.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Pokud AI zváží pohyblivost svých figurek, nebude se snažit pouze co nejrychleji zachytit soupeřovy figurky, ale také zvážit zablokování soupeřových pohybů a zabránění jim v tom, aby udělali totéž.';

  @override
  String get whenBoardIsFull => 'Když je deska plná';

  @override
  String get whenBoardIsFull_Detail =>
      'Na konci fáze umisťování, před začátkem fáze pohybu, následuje akce, pokud je deska plná figurek.';

  @override
  String get sideToMoveRemovePiece =>
      'Hráč, který se ve fázi pohybu pohne jako první, odstraní jednu ze soupeřových figurek.';

  @override
  String get agreeToDraw => 'Obě strany se dohodly na remíze.';

  @override
  String get takeOpponentsPiece => 'Vezměte si jednu ze soupeřových figurek.';

  @override
  String get firstPlayerLose => 'První hráč prohrává hru.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'První a druhý hráč odstraní jednu ze soupeřových figurek.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Druhý a první hráč odstraní jednu ze soupeřových figurek.';

  @override
  String get enteredFlyingPhase =>
      'Nyní vstoupila fáze létání, soupeřovy figurky mohou skákat na jakýkoli prázdný bod na desce. Pravidlo létání můžete vypnout v \"Nastavení pravidel\".';

  @override
  String get whenStalemate => 'Při patové situaci';

  @override
  String get whenStalemate_Detail =>
      'Jaká akce následuje, když nelze pohnout žádnou figurkou?';

  @override
  String get endWithStalemateLoss => 'Konec patovou prohrou.';

  @override
  String get changeSideToMove => 'Změňte stranu pro pohyb.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Odstraňte jednu ze soupeřových figurek a proveďte další tah.';

  @override
  String get endWithStalemateDraw => 'Končí patovou remízou.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Odstraňte jednu ze soupeřových figurek a změňte stranu pro pohyb.';

  @override
  String get aiResponseDelayTime => 'Doba zpoždění odezvy AI';

  @override
  String get aiIsDelaying =>
      'Umělá inteligence je momentálně ve fázi zpožděné odezvy. Než budete pokračovat, chvíli počkejte.';

  @override
  String get tipCanNotRemoveNonadjacent => 'Nesousedící kus nelze odstranit.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'V případě patové situace mohou být soupeřovy figurky sousedící s vašimi odstraněny, bez ohledu na formaci mlýna.';

  @override
  String get whatIsMcts =>
      'MCTS je pro začátečníky přívětivý algoritmus, který se rozhoduje na základě zkoumání a vyhodnocování různých pohybů prostřednictvím simulací.';

  @override
  String get goldenJade => 'Zlatý nefrit';

  @override
  String get forestWood => 'Lesní dřevo';

  @override
  String get darkMystery => 'Temná záhada';

  @override
  String get midnightBlue => 'Půlnoční modrá';

  @override
  String get greenForest => 'Zelený les';

  @override
  String get greenMeadow => 'Zelená louka';

  @override
  String get stonyPath => 'Kamenitá cesta';

  @override
  String get pastelPink => 'Pastelově růžová';

  @override
  String get turquoiseSea => 'Tyrkysové moře';

  @override
  String get violetDream => 'Fialový sen';

  @override
  String get mintChocolate => 'Mátová čokoláda';

  @override
  String get skyBlue => 'Modrá obloha';

  @override
  String get playfulGarden => 'Hravá zahrada';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Algoritmus retrográdní analýzy využívá retrográdní analýzu s více hodnotami k vytvoření databáze konce hry z různých počátečních pozic a poté tuto databázi použije k optimalizaci hry. Tento přístup spadá do kategorie Ultra-Strong řešení.';

  @override
  String get viewAlgorithmGuide =>
      'Chcete zobrazit uživatelskou příručku pro tento algoritmus?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Zobrazit indikátor poziční výhody';

  @override
  String get usePerfectDatabase => 'Použijte perfektní databázi';

  @override
  String get perfectDatabaseDescription =>
      'Povolte tuto možnost, chcete-li používat bezchybnou herní databázi generovanou pomocí nejmodernějších algoritmů. Tato funkce integruje strategie otevření i konce hry, aby navrhla optimální pohyby. Toto je preferovaná volba pro hráče, kteří hledají nejvyšší úroveň přesnosti při hraní. Databáze vytvořená pomocí pečlivých výpočetních technik je navržena tak, aby nabízela téměř dokonalá herní řešení.\n\nPoznámka: Pokud se AI nepodaří získat přístup k databázi, obrátí se při rozhodování o hře na konvenční algoritmy. Když je databáze dostupná, \'Úroveň obtížnosti\' se stává prakticky nepřekonatelnou a \'Doba myšlení AI\' zažívá drastické snížení. Mnoho nastavení v rámci možností „AI\'s play style“ bude přepsáno, protože výsledky databáze mají nejvyšší prioritu.\n\nPro návod, jak co nejlépe využít tuto bezchybnou databázi, klikněte sem.';

  @override
  String get backgroundImage => 'Pozadí obrazu';

  @override
  String get whatIsRandom =>
      'Když není povolena možnKdyž není povolena možnost \'Použít perfektní databázi\', nastavení \'Náhodný\' způsobí, že AI bude pohybovat figurkami náhodně bez použití jakýchkoliv algoritmů pro výběr pohybu. To obvykle vede k výrazně slabšímu hraní. Naopak, když je povoleno „Použít dokonalou databázi“, AI se při rozhodování spoléhá výhradně na „Dokonalou databázi“, místo aby ji mísila s tradičními algoritmy AI. V tomto režimu jsou pohyby umělé inteligence zcela založeny na obsahu databáze a vyhýbá se spoléhání na výpočty v reálném čase nebo vyhledávací algoritmy.ost \'Použít perfektní databázi\', nastavení \'Náhodný\' způsobí, že AI bude pohybovat figurkami náhodně bez použití jakýchkoliv algoritmů pro výběr pohybu. To obvykle vede k výrazně slabšímu hraní. Naopak, když je povoleno „Použít dokonalou databázi“, AI se při rozhodování spoléhá výhradně na „Dokonalou databázi“, místo aby ji mísila s tradičními algoritmy AI. V tomto režimu jsou pohyby umělé inteligence zcela založeny na obsahu databáze a vyhýbá se spoléhání na výpočty v reálném čase nebo vyhledávací algoritmy.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Odstraňte soupeřovy kameny z ruky; poté je na tahu soupeř, aby umístil.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Při vytváření mlýnů během fáze umisťování';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Odstraňte soupeřovy kameny z hrací plochy.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Odstraňte soupeřovy kameny z hrací plochy; poté je na tahu soupeř, aby umístil.';

  @override
  String get opponentRemovesOwnPiece =>
      'Soupeř odstraní své vlastní kameny z hrací plochy.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Místo toho, abyste podnikli akci, si soupeř vybere a odstraní své vlastní kameny z hrací plochy, čímž efektivně provede akci, která je pro něj samotného škodlivá.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Odstraňte soupeřovy kameny z ruky; poté jste na tahu vy.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Odstraňte kameny z ruky soupeře. Pokud má být podle nastavení Vícenásobného odebrání odstraněno více kamenů a soupeři nezbyly v ruce žádné kameny, pokračujte v odstraňování soupeřových kamenů z hrací plochy. Poté jste na tahu vy. Pokud budete pokračovat ve vytváření mlýnů, můžete pokračovat v odstraňování soupeřových kamenů.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Odstraňte kameny z ruky soupeře. Pokud má být podle nastavení Vícenásobného odebrání odstraněno více kamenů a soupeři nezbyly v ruce žádné kameny, pokračujte v odstraňování soupeřových kamenů z hrací plochy. Poté je na tahu soupeř.';

  @override
  String get markAndDelayRemovingPieces =>
      'Označit a odložit odstranění kamenů.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Během fáze umisťování se kameny, které mají být odstraněny, označí a žádný z hráčů nemůže na tato místa umístit nové kameny. Po vstupu do pohybové fáze jsou tyto označené kameny zcela odstraněny a hráči pak mohou své kameny přesunout na tato nyní prázdná místa.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Akce, které lze podniknout při tvorbě mlýnů ve fázi umisťování.';

  @override
  String get marked => 'Označeno';

  @override
  String get menu => 'Nabídka';

  @override
  String get monochrome => 'Monochromatický';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Ve Všeobecných nastaveních v nastavení Přístupnosti můžete zapnout podporu čtečky obrazovky.';

  @override
  String get showNumbersOnPieces => 'Zobrazit čísla na figurkách';

  @override
  String get saveImage => 'Uložit obrázek';

  @override
  String get isAnalysisToolbarShown => 'Zobrazit panel nástrojů pro analýzu';

  @override
  String get analysisToolbarBackgroundColor =>
      'Barva pozadí panelu nástrojů pro analýzu';

  @override
  String get analysisToolbarIconColor =>
      'Barva ikony panelu nástrojů pro analýzu';

  @override
  String get transformed => 'Transform.';

  @override
  String get cannotTransform => 'Nelze transformovat.';

  @override
  String get rotate => 'Rotace';

  @override
  String get horizontalFlip => 'Hor. Obrácení';

  @override
  String get verticalFlip => 'Vert. Obrácení';

  @override
  String get innerOuterFlip => 'IO Obrácení';

  @override
  String get transparentCanvas => 'Průhledné Plátno';

  @override
  String get restrictRepeatedMillsFormation =>
      'Zakázat opakované formování mlýnů';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Kus přesunutý z jednoho mlýna do druhého nemůže okamžitě vrátit na původní bod v dalším tahu, aby znovu vytvořil mlýn. Nejprve je vyžadován jiný tah.';

  @override
  String get oneTimeUseMill => 'Jednorázová mlýn';

  @override
  String get oneTimeUseMill_Detail =>
      'Každý mlýn může odstranit pouze jeden kus soupeře. Můžete jej znovu sestavit, ale nelze jej použít pro další odstranění.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Aktuální pravidla, která jste nastavili, nemají odpovídající dokonalou databázi. Pro více informací o dokonalé databázi klikněte zde.';

  @override
  String get focusOnBlockingPaths => 'Zaměřte se na blokování cest';

  @override
  String get focusOnBlockingPaths_Detail =>
      'V určitých fázích hry prioritizujte bránění pohybu soupeře před tvořením mlýnů. Místo zaměření se na odstraňování figurek dokončováním mlýnů, AI se v těchto fázích snaží chytit soupeře do pasti, znemožnit mu pohyb a zajistit vítězství opotřebováním místo agresivní hry. Tato strategie specifická pro dané fáze aktivně neblokuje soupeřovy mlýny.';

  @override
  String get pieceImage => 'Obraz figurky';

  @override
  String get importColorSettings => 'Importovat nastavení barev';

  @override
  String get exportColorSettings => 'Exportovat nastavení barev';

  @override
  String get import => 'Import';

  @override
  String get export => 'Export';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Nejprve prosím zkopírujte nastavení formátu JSON do schránky.';

  @override
  String get copiedToClipboard => 'Zkopírováno do schránky.';

  @override
  String get imported => 'Importováno.';

  @override
  String get boardImage => 'Obrázek desky';

  @override
  String get autumnLeaves => 'Podzimní listí';

  @override
  String get legendaryLand => 'Legendární Země';

  @override
  String get vignetteEffect => 'Efekt vinětace';

  @override
  String get promptMakeToolbarTransparent =>
      'Chcete, aby byla panel nástrojů plně průhledná, když je nastaven obrázek pozadí desky?';

  @override
  String get vibration => 'Povolit vibrace ve hře';

  @override
  String get soundTheme => 'Zvukové téma';

  @override
  String get ball => 'Míč';

  @override
  String get liquid => 'Tekutina';

  @override
  String get wood => 'Dřevo';

  @override
  String get placeEffectAnimation => 'Animace efektu umístění figurky';

  @override
  String get removeEffectAnimation => 'Animace efektu odstranění figurky';

  @override
  String get isToolbarAtBottom => 'Zobrazit nástrojovou lištu dole';

  @override
  String get boardCornerRadius => 'Poloměr rohu desky';

  @override
  String get useOpeningBook => 'Použijte úvodní knihu';

  @override
  String get currentRule => 'Aktuální';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Sada pravidel';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'One-Time Mill';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'Nechte AI používat otevírací tahy, které jsou běžně používány profesionálními hráči v rané fázi hry. Poznámka: Tato funkce je v současné době dostupná pouze pro konkrétní sady pravidel.';

  @override
  String get showAdvantageGraph => 'Zobrazit graf výhody';

  @override
  String get advantageGraphHint =>
      'Graf výhody bude vykreslen pouze poté, co udělá tah AI. Nebude vykreslen, když tah provede lidský hráč.';

  @override
  String get removalBasedOnMillCounts =>
      'Zakázat odstranění, dokud nejsou umístěny všechny kameny. Hráči odstraňují kameny na základě počtu mlýnů.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Zakázat odstranění, dokud nejsou umístěny všechny kameny. Hráči odstraňují kameny na základě počtu mlýnů: pokud je počet stejný, oba odstraní stejný počet; pokud má jeden více, odstraní o jeden navíc, aby zůstal rozdíl jednoho kamene. Pokud mlýn vytvoří pouze jeden hráč, odstraní dvě kameny, zatímco druhý odstraní jeden. Pokud žádný hráč nevytvoří mlýn, oba odstraní jeden kámen.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Vyberte jednu ze svých figurek.';

  @override
  String get notYourTurn => 'Není to váš tah.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Barva pozadí nástrojového panelu pro anotace';

  @override
  String get annotationToolbarIconColor =>
      'Barva ikon nástrojového panelu pro anotace';

  @override
  String get isAnnotationToolbarShown =>
      'Zobrazit nástrojový panel pro anotace';

  @override
  String get enterAnnotationMode => 'Přejít do režimu anotací';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Opravdu chcete vymazat všechny anotace?';

  @override
  String get llmPromptCopiedToClipboard => 'LLM prompt zkopírován do schránky.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Připojení odmítnuto, server může být nedostupný.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Vyhledávání úspěšné, čeká se na připojení...';

  @override
  String get noLanConnection => 'Žádné připojení v místní síti';

  @override
  String get takeScreenshot => 'Pořídit snímek obrazovky';

  @override
  String get disconnectedFromOpponent => 'Odpojeno od soupeře.';

  @override
  String get takeBackRequest => 'Žádost o vrácení tahu';

  @override
  String get nothingToShow => 'Nic k zobrazení.';

  @override
  String get stopHosting => 'Ukončit hostování';

  @override
  String get connectionResetByPeer => 'Připojení bylo resetováno protistranou.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Spojení ztraceno kvůli vypršení doby heartbeat. Prosím, znovu se připojte.';

  @override
  String get startHosting => 'Spustit hostování';

  @override
  String get restartRequestRejected => 'Žádost o restart zamítnuta.';

  @override
  String get notConnectedToLanOpponent =>
      'Nejste připojeni k soupeři v místní síti.';

  @override
  String get llmPrompt => 'LLM prompt';

  @override
  String get gameRestarted => 'Hra byla restartována.';

  @override
  String get takeBackRejected => 'Žádost o vrácení tahu zamítnuta.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Opravdu chcete vzdát tuto hru?';

  @override
  String get opponentResignedYouWin => 'Soupeř se vzdal. Vyhráváte!';

  @override
  String get clearAllAnnotations => 'Vymazat všechny anotace';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Připojeno, čeká se na soupeřův tah...';

  @override
  String get networkStatusDisconnected => 'Stav sítě: Odpojeno';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Žádost o vrácení tahu byla odeslána soupeři.';

  @override
  String get theOpponentMayHaveLeftTheGame => 'Soupeř možná opustil hru';

  @override
  String get connectedToHostSuccessfully => 'Úspěšně připojeno k hostiteli.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Spojení ztraceno: vypršel čas heartbeat';

  @override
  String get noHostDiscovered => 'Nebyl nalezen žádný hostitel.';

  @override
  String get confirmResignation => 'Potvrdit vzdání';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Spuštěno hostování hry, čeká se na připojení hráčů...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Čas spojení vypršel, síťové připojení je nestabilní.';

  @override
  String get noLlmPromptAvailable => 'Žádný LLM prompt není k dispozici.';

  @override
  String get youResignedGameOver => 'Vzdali jste se. Hra skončila.';

  @override
  String get serverIp => 'IP adresa serveru';

  @override
  String get confirmClear => 'Potvrdit vymazání';

  @override
  String get opponentSTurn => 'Tah soupeře.';

  @override
  String get waitingAClientConnection => 'Čeká se na připojení klienta...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Žádost o vrácení tahu byla zamítnuta nebo selhala.';

  @override
  String get addText => 'Přidat text';

  @override
  String get exitAnnotationMode => 'Ukončit režim anotací';

  @override
  String get typeYourAnnotation => 'Zadejte svoji anotaci';

  @override
  String get attemptingToReconnect => 'Probíhá pokus o znovupřipojení...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Žádost o restart odeslána. Čeká se na reakci soupeře...';

  @override
  String get serverIsStopped => 'Server je zastaven.';

  @override
  String get restartRequest => 'Žádost o restart';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Nelze žádat o vrácení tahu, když není váš tah.';

  @override
  String get takeBackAccepted => 'Žádost o vrácení tahu přijata.';

  @override
  String get localNetworkSettings => 'Nastavení místní sítě';

  @override
  String get reconnectedSuccessfully => 'Opětovné připojení bylo úspěšné!';

  @override
  String get failedToSaveImageToGallery =>
      'Nepodařilo se uložit obrázek do galerie.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Soupeř požádal o restart hry. Přijímáte?';

  @override
  String get yourTurn => 'Jste na tahu.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Nelze se znovu připojit, prosím restartujte hru.';

  @override
  String get host => 'Hostitel';

  @override
  String get join => 'Připojit se';

  @override
  String get port => 'Port';

  @override
  String get invalidIpAddress => 'Neplatná IP adresa.';

  @override
  String get invalidPort => 'Neplatný port.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Připojování: Pokus $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Nepodařilo se připojit: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Nepodařilo se spustit hostování: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Hostitel nalezen: $ip:$port';
  }

  @override
  String get stop => 'Zastavit';

  @override
  String get discover => 'Vyhledat';

  @override
  String get connect => 'Připojit';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Klient připojen: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Vyhledávám: $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Znovupřipojování ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Připojeno';

  @override
  String get delete => 'Smazat';

  @override
  String get ancientEgypt => 'Starověký Egypt';

  @override
  String get gothicIce => 'Gotický Led';

  @override
  String get riceField => 'Rýžové Pole';

  @override
  String get chinesePorcelain => 'Čínský Porcelán';

  @override
  String get desertDusk => 'Pouštní Soumrak';

  @override
  String get precisionCraft => 'Precizní Řemeslo';

  @override
  String get folkEmbroidery => 'Lidová Výšivka';

  @override
  String get carpathianHeritage => 'Karpatské Dědictví';

  @override
  String get imperialGrandeur => 'Císařská Velebnost';

  @override
  String get bohemianCrystal => 'Český Křišťál';

  @override
  String get savannaSunrise => 'Savanský Východ Slunce';

  @override
  String get harmonyBalance => 'Harmonie a Rovnováha';

  @override
  String get cinnamonSpice => 'Skořicové Koření';

  @override
  String get anatolianMosaic => 'Anatolská Mozaika';

  @override
  String get carnivalSpirit => 'Karnevalový Duch';

  @override
  String get custom => 'Zvyk';

  @override
  String get spiceMarket => 'Trh s kořením';

  @override
  String get swipeToRevealTheDrawer => 'Přejetím odhalte zásuvku';

  @override
  String get showGameInfoOnScreenshots =>
      'Zobrazit informace o hře na snímcích obrazovky';

  @override
  String get humanMoveTime => 'Časový limit pro lidský tah';

  @override
  String get noTimeLimitForHumanMoves => 'Žádný časový limit pro lidské tahy';

  @override
  String get timeoutLoseWillBeApplied =>
      'Pro lidského hráče bude uplatněna prohra z časového limitu';

  @override
  String get identifyingBoard => 'Identifikuji herní desku…';

  @override
  String get youCanEnterAnyModelName => 'Můžete zadat libovolný název modelu';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Pozice herní desky použita. FEN zkopírováno do schránky.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Tip: Zkuste pořídit ostřejší snímek herní desky';

  @override
  String get llmPromptTemplate => 'Šablona výzvy pro LLM';

  @override
  String get noValidBoardDetected =>
      'Nebyla detekována žádná platná herní deska';

  @override
  String get selectingImageFromAlbum => 'Výběr obrázku z alba…';

  @override
  String get configurePromptTemplate => 'Nastavit šablonu výzvy';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Upravit šablonu výzvy pro analýzu LLM';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Nepodařilo se vygenerovat FEN z rozpoznané desky';

  @override
  String get outputInCurrentLanguage => 'Výstup v aktuálním jazyce';

  @override
  String get commonBaseUrls => 'Běžné základní adresy URL';

  @override
  String get viewCommonModels => 'Zobrazit běžné modely';

  @override
  String get recognitionParametersUpdated =>
      'Parametry rozpoznávání aktualizovány';

  @override
  String get whiteSMove => 'Tah bílého';

  @override
  String get resetToDefaults => 'Obnovit výchozí nastavení';

  @override
  String get photoShoot => 'Fotografování';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Nepodařilo se použít rozpoznanou pozici desky';

  @override
  String get llmPromptContent => 'Obsah výzvy LLM';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM není nakonfigurován. Zkontrolujte, prosím, svá nastavení.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Nastavit poskytovatele, model, API Key a Base URL';

  @override
  String get llmConfiguration => 'Konfigurace LLM';

  @override
  String get configureLlmProvider => 'Nastavit poskytovatele LLM';

  @override
  String get llmPromptTemplateHeader => 'Záhlaví šablony výzvy LLM';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Na snímku nebyly rozpoznány žádné kameny. Zkuste to prosím znovu.';

  @override
  String get recognizeBoardFromImage => 'Rozpoznat desku ze snímku';

  @override
  String get viewTips => 'Zobrazit tipy';

  @override
  String get applyToBoard => 'Použít na desku';

  @override
  String get adjustBoardArea => 'Upravit oblast desky';

  @override
  String get viewCommonUrls => 'Zobrazit běžné URL';

  @override
  String get colorAnalysisFailed => 'Analýza barev selhala!';

  @override
  String get analyzingGameBoardImage => 'Analyzuji snímek herní desky…';

  @override
  String get selectFromAlbum => 'Vybrat z alba';

  @override
  String get noBoardPointDetected => 'Nebyl detekován žádný bod na desce!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Pokud bude prázdné, použije se výchozí šablona';

  @override
  String get llmConfig => 'Konfigurace LLM';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Opravdu chcete obnovit šablony výzev na výchozí hodnoty?';

  @override
  String get llmPromptTemplateFooter => 'Zápatí šablony výzvy LLM';

  @override
  String get loadingResponse => 'Načítám odpověď…';

  @override
  String get applyThisResultToBoard => 'Použít tento výsledek na desku';

  @override
  String get takingPicture => 'Pořizuji snímek…';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Vyberte prosím snímek herní desky k identifikaci';

  @override
  String get identificationResults => 'Výsledky identifikace';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Analyzujte tahy a poskytněte postřehy.';

  @override
  String get getApiKey => 'Získat API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Celý proces rozpoznávání se nepodařilo dokončit';

  @override
  String get boardRecognitionResult => 'Výsledek rozpoznání desky';

  @override
  String get askLlm => 'Zeptat se LLM';

  @override
  String get boardDetectionFailed => 'Detekce desky selhala!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Nebyl detekován žádný bod na desce, nelze identifikovat kámen!';

  @override
  String get copyFen => 'Kopírovat FEN';

  @override
  String get commonlyUsedModels => 'Často používané modely';

  @override
  String get apiKeyOptional => 'API Key (volitelné)';

  @override
  String get noImageSelected => 'Žádný obrázek nebyl vybrán';

  @override
  String get blackSMove => 'Tah černého';

  @override
  String get llm => 'Velký jazykový model';

  @override
  String get llmProvider => 'Poskytovatel';

  @override
  String get baseUrl => 'Základní URL';

  @override
  String get model => 'Model';

  @override
  String get temperature => 'Teplota';

  @override
  String get llmCommandReceivedProcessing => 'Příkaz přijat! AI zpracovává...';

  @override
  String get llmDeepThinkingWait =>
      'Probíhá hluboké přemýšlení, prosím čekejte...';

  @override
  String get llmPresentingSoon => 'Brzy bude představeno...';

  @override
  String get recognitionParameters => 'Parametry rozpoznávání';

  @override
  String get adjustParamsDesc =>
      'Upravte parametry pro zlepšení přesnosti rozpoznávání';

  @override
  String get saveParameters => 'Uložit parametry';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Nelze spustit rozpoznávání obrazu: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Rozpoznávání obrazu selhalo: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Použitá pozice s $whiteCount bílými a $blackCount černými kameny';
  }

  @override
  String get fenCopiedToClipboard => '(FEN zkopírováno do schránky)';

  @override
  String recognitionFailed(String error) {
    return 'Rozpoznávání selhalo: $error';
  }

  @override
  String get myRating => 'Moje hodnocení';

  @override
  String get gamesPlayed => 'Odehrané hry';

  @override
  String get wins => 'Výhry';

  @override
  String get losses => 'Prohry';

  @override
  String get draws => 'Remízy';

  @override
  String get lastUpdated => 'Poslední aktualizace';

  @override
  String get format => 'Formát:';

  @override
  String get resetStatistics => 'Resetovat statistiky';

  @override
  String get drawRate => 'Míra remíz';

  @override
  String get lossRate => 'Míra proher';

  @override
  String get aiStatistics => 'Statistiky UI';

  @override
  String get enableStatistics => 'Povolit statistiky';

  @override
  String get enableStatistics_Detail =>
      'Pokud je povoleno, výsledky her se budou zaznamenávat do statistik. Hry zahrnující vrácení tahu se však zaznamenávat nebudou. Pokud je zakázáno, sběr statistik je pozastaven.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Tímto resetujete všechny herní statistiky. Tuto akci nelze vrátit zpět.';

  @override
  String get boardInnerRingSize => 'Velikost vnitřního kroužku hrací desky';

  @override
  String get boardShadowEnabled => 'Stín desky';

  @override
  String get trapAwareness => 'Detekce pastí';

  @override
  String get trapAwarenessDescription =>
      'Zvýrazňuj tahy do pasti tučnými kruhy a šipkami během analýzy.';

  @override
  String trapExists(String trapMoves) {
    return 'Existuje past. Tahy do pasti: $trapMoves';
  }

  @override
  String get custodianCapture => 'Lemování zachycení';

  @override
  String get custodianCaptureDescription =>
      'Přiložte jeden z vašich soupeřových kusů mezi dvěma z vašich v přímé linii, abyste jej zachytili.';

  @override
  String get custodianCaptureEnable => 'Povolte zachycení lemu';

  @override
  String get interventionCapture => 'Zachycení intervence';

  @override
  String get interventionCaptureDescription =>
      'Přesuňte se do prázdného bodu mezi dvěma kousky soupeře, abyste je zachytili oba.';

  @override
  String get interventionCaptureEnable => 'Umožněte zachycení zásahu';

  @override
  String get leapCapture => 'Skok zachycení';

  @override
  String get leapCaptureDescription =>
      'Zachyťte skokem přes sousední soupeřovu kus do prázdného bodu za nimi.';

  @override
  String get leapCaptureEnable => 'Umožněte zachycení skoku';

  @override
  String get captureApplicableLines => 'Použitelné řádky';

  @override
  String get captureSquareEdges => 'Podél okrajů čtverce';

  @override
  String get captureCrossLines =>
      'Podél ortogonálních linií překračujících náměstí';

  @override
  String get captureDiagonalLines =>
      'Podél diagonálních linií přecházejících na náměstí';

  @override
  String get captureExecutionPhases => 'Fáze provádění';

  @override
  String get capturePiecesCondition =>
      'Dostupnost během pohyblivé fáze na základě zbývajících kusů';

  @override
  String get capturePiecesConditionUnlimited => 'Žádné omezení';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'K dispozici, když máte tři nebo méně kusů';
}
