// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Catalan Valencian (`ca`).
class SCa extends S {
  SCa([String locale = 'ca']) : super(locale);

  @override
  String get appName => 'Molí';

  @override
  String get welcome => 'Benvingut';

  @override
  String get yes => 'Sí';

  @override
  String get no => 'No';

  @override
  String get game => 'Joc';

  @override
  String get humanVsAi => 'Humà vs. IA';

  @override
  String get humanVsHuman => 'Humà vs. Humà';

  @override
  String get aiVsAi => 'IA vs. IA';

  @override
  String get humanVsCloud => 'Humà vs. Núvol';

  @override
  String get humanVsLAN => 'Humà vs. LAN';

  @override
  String get testViaLAN => 'Prova via LAN';

  @override
  String get move => 'Moviment';

  @override
  String get showMoveList => 'Llista de moviments';

  @override
  String get moveList => 'Llista de moviments';

  @override
  String get noGameRecord => 'Cap registre';

  @override
  String get ok => 'D\'acord';

  @override
  String get confirm => 'Confirma';

  @override
  String get cancel => 'Cancel·la';

  @override
  String get tipSelectWrong => 'Ha triat la peça equivocada.';

  @override
  String get tipPlace => 'Col·loqueu les peces.';

  @override
  String get tipBanPlace => 'No podeu col·locar-la aquí.';

  @override
  String get tipPlaced => 'Peça col·locada.';

  @override
  String get tipRemove => 'Retireu una peça.';

  @override
  String get tipBanRemove => 'No podeu retirar-la.';

  @override
  String get tipRemoved => 'Peça retirada.';

  @override
  String get tipMove => 'Moveu una peça.';

  @override
  String get tipCannotPlace => 'Aquí no podeu col·locar la peça.';

  @override
  String get tipCannotMove => 'No podeu moure la peça aquí.';

  @override
  String get tipMill => 'Molí! Preneu una peça de l\'oponent.';

  @override
  String get tipContinueMill => 'Continueu prenent una peça de l\'oponent.';

  @override
  String get tipSelectOpponentsPiece => 'Trieu una peça de l\'oponent.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'No podeu prendre una peça d\'un molí.';

  @override
  String get tipCanMoveOnePoint => 'Una peça es pot moure 1 punt.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'No podeu moure les peces de l\'oponent.';

  @override
  String get tipSelectPieceToMove => 'Trieu la peça a moure.';

  @override
  String get tipHaveThreePiecesLeft => 'Us queden 3 peces.';

  @override
  String get tipCanMoveToAnyPoint =>
      'Us podeu moure a qualsevol punt que vulgueu.';

  @override
  String tipToMove(Object player) {
    return 'És el torn del jugador $player.';
  }

  @override
  String get whiteWin => 'Guanya el jugador 1!';

  @override
  String get blackWin => 'Guanya el jugador 2!';

  @override
  String get won => 'Victòria';

  @override
  String get lost => 'Derrota';

  @override
  String get thinking => 'Pensant…';

  @override
  String get newGame => 'Partida nova';

  @override
  String get importGame => 'Importa una partida';

  @override
  String get exportGame => 'Exporta una partida';

  @override
  String get gameImported => 'S\'ha importat la partida.';

  @override
  String cannotImport(Object invalidMove) {
    return 'No es pot importar $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch =>
      'Els moviments i les regles no coincideixen.';

  @override
  String get pleaseWait => 'Espereu...';

  @override
  String get restartGame => 'Voleu reiniciar la partida actual?';

  @override
  String get restart => 'Reinicia';

  @override
  String get gameStarted => 'La partida ha començat, col·loqueu les peces.';

  @override
  String get analyzing => 'S\'està analitzant…';

  @override
  String error(Object message) {
    return 'Error: $message';
  }

  @override
  String get winRate => 'Taxa de victòries';

  @override
  String get score => 'Puntuació:';

  @override
  String get white => 'Jugador 1';

  @override
  String get black => 'Jugador 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player té menys de 3 peces.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player s\'ha rendit.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player no pot moure.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'El tauler és ple, i el $player no pot moure.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'S\'ha acabat el temps, $player ha perdut.';
  }

  @override
  String get drawReasonRule50 =>
      'En la fase de moviment, no s\'ha retirat cap peça en l\'últim nombre específic de torns.';

  @override
  String get drawReasonBoardIsFull => 'És un empat perquè el tauler és ple.';

  @override
  String get drawReasonThreefoldRepetition =>
      'És un empat perquè hi ha una repetició triple.';

  @override
  String get gameOverUnknownReason => 'Final de partida! Raó desconeguda.';

  @override
  String get gameOver => 'Final de partida';

  @override
  String get youWin => 'Heu guanyat! Enhorabona!';

  @override
  String challengeHarderLevel(int level) {
    return 'Voleu un nivell més difícil? El nivell nou serà $level!';
  }

  @override
  String get youLose => 'Heu perdut!';

  @override
  String get analyze => 'Analitza';

  @override
  String get about => 'Quant a';

  @override
  String version(Object versionNumber) {
    return 'Versió: $versionNumber';
  }

  @override
  String get thanks => 'Agraïments';

  @override
  String get settings => 'Configuració';

  @override
  String get options => 'Opcions';

  @override
  String get generalSettings => 'Paràmetres generals';

  @override
  String get skillLevel => 'Nivell de dificultat';

  @override
  String get moveTime => 'Temps de raonament de la IA';

  @override
  String get difficulty => 'Dificultat';

  @override
  String get playSounds => 'Efectes de so';

  @override
  String get playSoundsInTheGame => 'Reprodueix sons durant la partida';

  @override
  String get keepMuteWhenTakingBack => 'Silenci en anar enrere';

  @override
  String get tone => 'To';

  @override
  String get whoMovesFirst => 'Primer moviment';

  @override
  String get human => 'Humà';

  @override
  String get ai => 'IA';

  @override
  String get alternate => 'Alterna';

  @override
  String get isAutoRestart =>
      'Torna a començar automàticament en acabar la partida';

  @override
  String get isAutoChangeFirstMove =>
      'Canvia automàticament el primer moviment';

  @override
  String get shufflingEnabled => 'Moviment aleatori';

  @override
  String get misc => 'Miscel·lània';

  @override
  String get rules => 'Regles';

  @override
  String get piecesCount => 'El nombre de peces que té cada jugador';

  @override
  String get piecesCount_Detail => 'Quantes peces té cada jugador?';

  @override
  String get flyPieceCount => 'El nombre de peces voladores';

  @override
  String get flyPieceCount_Detail =>
      'Si l\'opció «vol» és activa, si el nombre de peces d\'un jugador és inferior a un nombre específic, i durant la resta del joc, les peces d\'aquest jugador es poden moure lliurement a qualsevol punt lliure en comptes d\'estar restringides als punts adjacents.';

  @override
  String get piecesAtLeastCount => 'Mínim de peces';

  @override
  String get hasDiagonalLines => 'Línies diagonals';

  @override
  String get hasDiagonalLines_Detail =>
      'Afegeix quatre línies diagonals en el tauler.';

  @override
  String get isDefenderMoveFirst => 'El segon jugador mou primer';

  @override
  String get isDefenderMoveFirst_Detail =>
      'El jugador que mou segon en la fase de col·locació mou primer en la fase de moviments.';

  @override
  String get mayRemoveMultiple => 'Supressió múltiple';

  @override
  String get mayRemoveMultiple_Detail =>
      'Si un jugador forma més d\'un molí a la vegada, prendrà tantes peces com molins ha format.';

  @override
  String get mayRemoveFromMillsAlways => 'Destrueix els molins';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Per defecte, els jugadors han de prendre qualsevol altra peça abans de poder prendre una peca d\'un molí format. Marqueu aquesta opció per a desactivar aquesta limitació.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'El segon jugador perd si el tauler és ple';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Si el tauler és ple al final de la fase de col·locació, el jugador que col·loca peces primer perd la partida. Altrament, la partia és un empat.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Perd si no hi ha cap moviment legal';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'El jugador perd si el seu oponent el bloca de manera que no pot moure cap peça. Si aquesta opció està desactivada, es canvia el torn en lloc de declarar la derrota.';

  @override
  String get mayFly => 'Vol';

  @override
  String get mayFly_Detail =>
      'Si a un jugador només li queden tres o quatre (segons la configuració) peces, pot moure la peça a qualsevol punt lliure.';

  @override
  String get nMoveRule => 'Regla de N moviments';

  @override
  String get nMoveRule_Detail =>
      'La partida és un empat si no s\'elimina cap peça en un nombre específic de moviments.';

  @override
  String get rollback => 'Enrere';

  @override
  String get pleaseSelect => 'Seleccioneu';

  @override
  String get copy => 'Copia';

  @override
  String get moveHistoryCopied =>
      'L\'historial de moviments s\'ha copiat al porta-retalls.';

  @override
  String get help => 'Ajuda';

  @override
  String get feedback => 'Comentaris';

  @override
  String get exit => 'Surt';

  @override
  String get ruleSettings => 'Configuració de les regles';

  @override
  String get color => 'Color';

  @override
  String get boardColor => 'Color del tauler';

  @override
  String get pieceColor => 'Color de les peces';

  @override
  String get backgroundColor => 'Color del fons';

  @override
  String get lineColor => 'Color de la línia del tauler';

  @override
  String get whitePieceColor => 'Color de les peces del jugador 1';

  @override
  String get blackPieceColor => 'Color de les peces del jugador 2';

  @override
  String get messageColor => 'Color del missatge';

  @override
  String get isPieceCountInHandShown =>
      'Mostra el nombre de peces sense col·locar';

  @override
  String get isNotationsShown => 'Mostra les anotacions en el tauler';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Mostra la barra d\'eines de l\'historial';

  @override
  String get display => 'Visualització';

  @override
  String get boardBorderLineWidth => 'Amplada de la vora del tauler';

  @override
  String get boardInnerLineWidth => 'Amplada de la línia interior del tauler';

  @override
  String get pieceWidth => 'Amplada de les peces';

  @override
  String get fontSize => 'Mida de lletra';

  @override
  String get standardNotation => 'Notació WMD';

  @override
  String get restore => 'Restaura';

  @override
  String get restoreDefaultSettings =>
      'Restaura la configuració predeterminada';

  @override
  String pick(Object element) {
    return 'Trieu $element';
  }

  @override
  String get info => 'Informació';

  @override
  String get hint => 'Suggeriment';

  @override
  String get player => 'jugador';

  @override
  String get player1 => 'Jugador 1';

  @override
  String get player2 => 'Jugador 2';

  @override
  String get howToPlay => 'Com es juga';

  @override
  String get toPlacePiece =>
      'Toqueu en qualsevol punt lliure per a col·locar la peça.';

  @override
  String get toSelectPiece => 'Toqueu en una peça per a moure-la.';

  @override
  String get toMovePiece =>
      'Toqueu en un punt connectat a una peça per a moure-la.';

  @override
  String get toRemovePiece =>
      'Toqueu en una de les peces de l\'oponent per a eliminar-la.';

  @override
  String get needToCreateMillFirst =>
      'Per a poder eliminar una peça, abans heu de crear un molí.';

  @override
  String get needToPlayWithOwnPieces => 'Heu de jugar amb les vostres peces.';

  @override
  String get statistics => 'Estadístiques';

  @override
  String get totalGames => 'Total de partides';

  @override
  String get results => 'Resultats';

  @override
  String get left => 'queden';

  @override
  String get privacyPolicy => 'Política de privadesa';

  @override
  String get privacyPolicy_Detail_1 =>
      'Llegiu-ho detingudament i assegureu-vos que enteneu i hi esteu d\'acord ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Si no hi esteu d\'acord, si us plau, no feu servir aquesta aplicació. Fer servir l\'aplicació implica que n\'accepteu aquestes condicions.';

  @override
  String get and => ' i ';

  @override
  String get accept => 'Accepto';

  @override
  String get takeBack => 'Enrere';

  @override
  String get takingBack => 'Ves enrere…';

  @override
  String get waiting => 'Espereu…';

  @override
  String get stepForward => 'Endavant';

  @override
  String get takeBackAll => 'Enrere del tot';

  @override
  String get stepForwardAll => 'Endavant del tot';

  @override
  String get moveNow => 'Mou ara';

  @override
  String get done => 'Fet.';

  @override
  String get crackMill => 'Molí esquerdat';

  @override
  String get crackMill_Detail =>
      'Si un jugador només té peces formant molins, aquestes peces no queden protegides de la retirada.';

  @override
  String get animationDuration => 'Durada de l\'animació';

  @override
  String get none => 'Cap';

  @override
  String get theme => 'Tema';

  @override
  String get helpContent =>
      'L\'objectiu del joc és deixar l\'oponent amb menys de tres peces o sense moviments legals.\n\nLa partida empata automàticament si una posició es repeteix per tercera vegada o si no s\'elimina cap peça en els darrers 100 (configurable) moviments.\n\nLa partida té tres fases:\n\n1. Col·locar peces en punts buits\n2. Moure peces a punts adjacents\n3. (fase opcional) Moure peces a qualsevol punt buit quan un jugador es queda amb tres peces\n\nCol·locació\n\nLa partida comença amb el tauler buit, que té vint-i-quatre punts. Els jugadors col·loquen les seves peces per torn en punts buits fins que totes les peces estiguin col·locades. Si un jugador aconsegueix fer una línia de tres peces, forma un «molí» i pot retirar del tauler una peça de l\'oponent.\n\nEn algunes variants, s\'ha de retirar primer qualsevol altra peça abans que no pas una peça que formi part d\'un molí.\n\nAmb algunes regles, no es poden tornar a col·locar peces en punts d\'on s\'han retirat.\n\nQuan totes les peces estan col·locades, els jugadors passen a moure-les.\n\nMoviment\n\nPer a moure, un jugador desplaça una de les seves peces al llarg d\'una línia del tauler fins a un punt adjacent buit. Si no pot moure cap peça, perd la partida. Un jugador que alineï tres peces en una línia del tauler fa un molí i pot retirar una peça de l\'oponent, igual que a la fase de col·locació. Si un jugador es queda amb dues peces, no pot formar nous molins i perd la partida. També pot perdre si l\'oponent el bloca completament.\n\nVol\n\nEn algunes variants, quan un jugador només té tres peces, aquestes poden «volar» o saltar a qualsevol punt buit, no només als punts adjacents.\n';

  @override
  String get versionInfo => 'Informació de la versió';

  @override
  String get eula => 'CLUF';

  @override
  String get license => 'Llicència';

  @override
  String get sourceCode => 'Codi font';

  @override
  String get appVersion => 'Versió de l\'aplicació';

  @override
  String get general => 'General';

  @override
  String get advanced => 'Avançat';

  @override
  String get placing => 'Col·locació';

  @override
  String get moving => 'Moviment';

  @override
  String get removing => 'Eliminació';

  @override
  String get gameOverCondition => 'Condició de final de partida';

  @override
  String get aisPlayStyle => 'Estil de joc de la IA';

  @override
  String get passive => 'Passiu';

  @override
  String get timeout => 'Temps límit';

  @override
  String get appearance => 'Aparença';

  @override
  String get drawOnHumanExperience => 'Basat en l\'experiència humana';

  @override
  String get considerMobility => 'Considera la mobilitat de les peces';

  @override
  String get pieceCount => 'Nombre de peces:';

  @override
  String inHand(Object player, int count) {
    return '$player a la mà: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return 'Tauler de $player: $count';
  }

  @override
  String get boardTop => 'Distància des de la part superior del tauler';

  @override
  String get notAIsTurn => 'No és el torn de la IA.';

  @override
  String get aiIsNotThinking => 'La IA no està pensant.';

  @override
  String get atEnd => 'Sou al final de la llista de moviments.';

  @override
  String get tapBackAgainToLeave => 'Torneu a prémer enrere per a sortir.';

  @override
  String get more => 'Més';

  @override
  String get experimental => 'Això és una funció experimental.';

  @override
  String get experiments => 'Experiments';

  @override
  String get ossLicenses => 'Llicències de codi obert';

  @override
  String get language => 'Llengua';

  @override
  String get defaultLanguage => 'Llengua per defecte';

  @override
  String get mayMoveInPlacingPhase =>
      'Les peces es poden moure en la fase de col·locació';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'No hi ha fases de col·locació i de moviment separades. És a dir, els jugadors poden decidir a cada torn si volen col·locar una peça al tauler o moure una de les seves peces (sempre que encara tinguin peces per col·locar).';

  @override
  String get drawerColor => 'Color del menú';

  @override
  String get drawerTextColor => 'Color del text del menú';

  @override
  String get drawerHighlightItemColor => 'Color de ressalt del menú';

  @override
  String get mainToolbarBackgroundColor =>
      'Color de fons de la barra principal';

  @override
  String get mainToolbarIconColor => 'Color de la icona de la barra principal';

  @override
  String get navigationToolbarBackgroundColor =>
      'Color de fons de la barra de navegació';

  @override
  String get navigationToolbarIconColor =>
      'Color de la icona de la barra de navegació';

  @override
  String get autoHideToolbar => 'Amaga automàticament la barra d\'eines';

  @override
  String get toolbarLocationOnScreen =>
      'Ubicació de la barra d\'eines en la pantalla';

  @override
  String get top => 'A dalt';

  @override
  String get bottom => 'A baix';

  @override
  String get center => 'Al centre';

  @override
  String get solidColor => 'Color sòlid';

  @override
  String get picture => 'Imatge';

  @override
  String get chooseYourPicture => 'Trieu la vostra imatge';

  @override
  String get light => 'Clar';

  @override
  String get dark => 'Fosc';

  @override
  String get themes => 'Temes';

  @override
  String get currentTheme => 'Tema actual';

  @override
  String get saveTheme => 'Desa el tema';

  @override
  String get showAnalysisGraph => 'Mostra el diagrama d\'anàlisi';

  @override
  String get analysis => 'Anàlisi';

  @override
  String get saveGame => 'Desa la partida';

  @override
  String get loadGame => 'Carrega una partida';

  @override
  String get setupPosition => 'Configura la posició';

  @override
  String get showLegalMoves => 'Mostra els moviments legals';

  @override
  String get showLastMove => 'Mostra l\'últim moviment';

  @override
  String get showArrows => 'Mostra les fletxes';

  @override
  String get pieces => 'Peces';

  @override
  String get showAnalysis => 'Mostra l\'anàlisi';

  @override
  String get threads => 'Fils';

  @override
  String get getInvolved => 'Col·laboració';

  @override
  String get helpImproveTranslate => 'Ajudeu a millorar la traducció';

  @override
  String get tutorial => 'Tutorial';

  @override
  String get classicMill => 'Marro de nou clàssic';

  @override
  String get mixedMill => 'Marro de nou combinat';

  @override
  String get ceylonMill => 'Marro de nou de Ceilan';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'El molí es pot trencar i refer repetidament';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Si un jugador trenca un molí per a formar-ne un de nou immediatament, pot tornar a moure la peça a la posició original en el seu següent torn si torna a formar un nou molí.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'La partida és un empat si un jugador té tres peces i després de deu moviments cap jugador elimina peces de l\'oponent.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Si un jugador té tres peces i cap dels dos jugadors aconsegueix eliminar cap peça de l\'oponent en deu moviments, la partida és un empat.';

  @override
  String get close => 'Tanca';

  @override
  String get whitePiece => 'Peça blanca';

  @override
  String get blackPiece => 'Peça negra';

  @override
  String get emptyPoint => 'Punt buit';

  @override
  String get noPoint => 'Cap punt';

  @override
  String get placingPhase => 'Fase de col·locació';

  @override
  String get movingPhase => 'Fase de moviment';

  @override
  String get flyingPhase => 'Fase de vol';

  @override
  String sideToMove(Object player) {
    return 'Torn de: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Últim moviment: $move';
  }

  @override
  String get selected => 'Seleccionat';

  @override
  String get accessibility => 'Accessibilitat';

  @override
  String get screenReaderSupport => 'Compatibilitat amb lector de pantalla';

  @override
  String get isDraw => 'És un empat!';

  @override
  String get draw => 'Empat';

  @override
  String get pieceHighlightColor => 'Color de ressalt de la peça';

  @override
  String get algorithm => 'Algorisme';

  @override
  String get endgameNMoveRule => 'Regla de N moviments en el final de partida';

  @override
  String get endgameNMoveRule_Detail =>
      'Si un jugador té només tres peces i cap jugador n\'elimina cap dins d\'un nombre específic de moviments, la partida és un empat.';

  @override
  String get drawReasonEndgameRule50 =>
      'Qualsevol dels jugadors té només tres peces, i en un nombre específic de moviments no s\'elimina cap peça.';

  @override
  String get threefoldRepetitionRule => 'Regla de la repetició triple';

  @override
  String get threefoldRepetitionRule_Detail =>
      'La partida és un empat si una posició es repeteix per tercera vegada.';

  @override
  String get continueToMakeMove => 'Molí! Continueu per a fer un moviment.';

  @override
  String get pointStyle => 'Estil dels punts';

  @override
  String get pointWidth => 'Amplada del punt';

  @override
  String get solid => 'Sòlid';

  @override
  String get hollow => 'Cercle buit';

  @override
  String get languageName => 'Català';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count moviments',
      one: '$count moviment',
      zero: 'moviment',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'No s\'ha pogut carregar.';

  @override
  String get filename => 'Nom del fitxer';

  @override
  String get browse => 'Navega…';

  @override
  String get gameFiles => 'Fitxers de partides';

  @override
  String get gameSavedTo => 'La partida es desa a';

  @override
  String get empty => 'Buit';

  @override
  String get noMove => 'No hi ha cap moviment.';

  @override
  String get restoredPosition => 'S\'ha restaurat a la posició inicial.';

  @override
  String get clean => 'Neteja';

  @override
  String get cleanedUp => 'S\'ha netejat.';

  @override
  String get remove => 'Elimina';

  @override
  String get noPiecesCanBeRemoved => 'No hi ha cap peça que es pugui eliminar.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count peces',
      one: '$count peça',
      zero: 'peces',
    );
    return '$_temp0 s\'han d\'eliminar.';
  }

  @override
  String placedCount(int count) {
    return 'Col·locades ($count)';
  }

  @override
  String get placedPieceCount =>
      'Nombre de peces col·locades en la fase de col·locació.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'El jugador actual ha col·locat $count peces.';
  }

  @override
  String get notPlacingPhase =>
      'No és la fase de col·locació, no es pot canviar.';

  @override
  String get paste => 'Enganxa';

  @override
  String get pasteDone => 'S\'ha enganxat.';

  @override
  String get cannotPaste => 'No es pot enganxar.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Mostra les peces no col·locades i les retirades';

  @override
  String get fullScreen => 'Pantalla completa';

  @override
  String get reopenToTakeEffect =>
      'Sortiu i torneu a obrir l\'aplicació perquè els canvis tinguin efecte.';

  @override
  String get forest => 'Bosc';

  @override
  String get desktopImage => 'Imatge d\'escriptori';

  @override
  String get invalidPosition => 'Posició no vàlida.';

  @override
  String get shareGIF => 'Comparteix un GIF';

  @override
  String get pixelRatio => 'Proporció dels píxels';

  @override
  String get duration => 'Durada';

  @override
  String get gameScreenRecorder => 'Enregistrador de pantalla de la partida';

  @override
  String get previous => 'Enrere';

  @override
  String get next => 'Endavant';

  @override
  String get skip => 'Omet';

  @override
  String get gotIt => 'Entès';

  @override
  String get youCanModifyRules =>
      'Podeu modificar les regles de la partida a la configuració de regles.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Podeu fer servir la roda del ratolí per a ajustar el valor en el selector.';

  @override
  String get noTimeLimitForThinking =>
      'Si establiu el temps de raonament de la IA a 0, no hi ha límit de temps per a pensar.';

  @override
  String get whatIsMtdf =>
      'MTD(f) és una variant de l\'algorisme de cerca alfa-beta que intenta aprofitar l\'eficiència reutilitzant els resultats de cerques intermèdies i fent ús d\'una bona estimació inicial per a limitar l\'espai de cerca.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Tingueu en compte que l\'ajust del temps de raonament de la IA pot no ser del tot precís. El temps real podria ser més curt en nivells de dificultat baixos o més llarg si la IA està en ple procés de càlcul.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Si establiu un nivell de dificultat molt alt, però no augmenteu el temps de raonament de la IA, és possible que el nivell real quedi limitat a un valor inferior a causa del temps disponible. El valor concret pot variar segons el rendiment de la màquina.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) és una millora de l\'algorisme alfa-beta que empra cerques amb finestres nul·les per a confirmar si un moviment és pitjor o no que un resultat ja conegut. Se centra en la variant principal i evita explorar branques subòptimes de manera innecessària.';

  @override
  String get whatIsAlphaBeta =>
      'L\'algorisme alfa-beta és un mètode de cerca per a trobar el millor moviment basat en el principi minimax i en dos valors, alfa i beta, per a retallar l\'arbre de cerca. Això permet al programa prendre decisions eficients.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Segons l\'experiència humana, si intenteu guanyar directament, potser perdreu. En lloc d\'això, intenteu aconseguir un empat i eviteu perdre. Observeu l\'oponent i induïu-lo subtilment a cometre errors. Quan mostri debilitat, aprofiteu-ho per a guanyar.';

  @override
  String get firstMoveDetail =>
      'En aquest joc, sovint és més fàcil que el segon jugador guanyi que no pas el primer.';

  @override
  String get passiveDetail =>
      'Si activeu l\'opció «Passiu», la IA no perseguirà la victòria de forma agressiva quan estigui en avantatge, sinó que s\'ho prendrà amb més calma.';

  @override
  String get moveRandomlyDetail =>
      'Activar aquesta opció augmenta l\'atzar i la diversió. Desactivar-la pot ajudar a estudiar com vèncer la IA.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Si la IA considera la mobilitat de les seves peces, no només buscarà eliminar peces de l\'oponent ràpidament, sinó que també s\'esforçarà a blocar els moviments de l\'oponent i evitar que faci el mateix.';

  @override
  String get whenBoardIsFull => 'Quan el tauler és ple';

  @override
  String get whenBoardIsFull_Detail =>
      'Al final de la fase de col·locació, abans de començar la fase de moviment, si el tauler és ple de peces, es duran a terme aquestes accions.';

  @override
  String get sideToMoveRemovePiece =>
      'El jugador que mou primer en la fase de moviment retira una de les peces de l\'oponent.';

  @override
  String get agreeToDraw => 'Tots dos jugadors acorden un empat.';

  @override
  String get takeOpponentsPiece => 'Preneu una de les peces de l\'oponent.';

  @override
  String get firstPlayerLose => 'El primer jugador perd la partida.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'El primer i el segon jugador retiren una peça de l\'oponent.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'El segon i el primer jugador retiren una peça de l\'oponent.';

  @override
  String get enteredFlyingPhase =>
      'Ara ha començat la fase de vol; les peces de l\'oponent poden saltar a qualsevol punt buit del tauler. Podeu desactivar aquesta regla a «Configuració de les regles».';

  @override
  String get whenStalemate => 'Quan hi ha ofegat';

  @override
  String get whenStalemate_Detail =>
      'Quina acció s\'aplica quan no es pot moure cap peça?';

  @override
  String get endWithStalemateLoss =>
      'Acaba amb derrota per ofegat per al costat blocat.';

  @override
  String get changeSideToMove => 'Canvia el torn a l\'oponent.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Retireu una peça de l\'oponent i feu el següent moviment.';

  @override
  String get endWithStalemateDraw => 'Acaba amb un empat per ofegat.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Retireu una peça de l\'oponent i canvia el torn a l\'altre jugador.';

  @override
  String get aiResponseDelayTime => 'Temps de retard en la resposta de la IA';

  @override
  String get aiIsDelaying =>
      'La IA està retardant la resposta. Espereu uns moments abans de continuar.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'No podeu eliminar una peça que no sigui adjacent.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'En un ofegat, podeu eliminar les peces de l\'oponent que siguin adjacents a les vostres, sense tenir en compte la formació d\'un molí.';

  @override
  String get whatIsMcts =>
      'MCTS és un algorisme orientat a principiants que pren decisions explorant i avaluant diferents moviments mitjançant simulacions.';

  @override
  String get goldenJade => 'Jade daurat';

  @override
  String get forestWood => 'Fusta del bosc';

  @override
  String get darkMystery => 'Misteri fosc';

  @override
  String get midnightBlue => 'Blau de mitjanit';

  @override
  String get greenForest => 'Bosc verd';

  @override
  String get greenMeadow => 'Prat verd';

  @override
  String get stonyPath => 'Camí pedregós';

  @override
  String get pastelPink => 'Rosa pastel';

  @override
  String get turquoiseSea => 'Mar turquesa';

  @override
  String get violetDream => 'Somni violeta';

  @override
  String get mintChocolate => 'Xocolata a la menta';

  @override
  String get skyBlue => 'Blau cel';

  @override
  String get playfulGarden => 'Jardí juganer';

  @override
  String get whatIsRetrogradeAnalysis =>
      'L\'algoritme d\'anàlisi retroactiva usa bases de dades de finals generades des de diferents posicions per a optimitzar el joc. Pertany a les anomenades solucions ultrafortes.';

  @override
  String get viewAlgorithmGuide =>
      'Voleu veure la guia d\'usuari per a aquest algorisme?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Mostra l\'indicador d\'avantatge posicional';

  @override
  String get usePerfectDatabase => 'Usa la base de dades perfecta';

  @override
  String get perfectDatabaseDescription =>
      'Activeu aquesta opció per a utilitzar una base de dades impecable generada mitjançant algoritmes d\'avantguarda. Aquesta funcionalitat integra estratègies tant d\'obertura com de final de partida per a suggerir moviments òptims. És l\'opció preferida dels jugadors que busquen el màxim nivell de precisió en les partides. Creada amb tècniques computacionals meticuloses, la base de dades està dissenyada per a oferir solucions pràcticament perfectes.\n\nNota: Si la IA no aconsegueix accedir a la base de dades, recorrerà als algoritmes convencionals per a prendre decisions durant la partida. Quan la base de dades està disponible, el «Nivell de dificultat» esdevé pràcticament imbatible, i el «Temps de raonament de la IA» es redueix dràsticament. Molts ajustos dins de les opcions d\'«Estil de joc de la IA» seran ignorats, ja que els resultats de la base de dades tenen la màxima prioritat.\n\nPer a obtenir informació sobre com aprofitar al màxim aquesta base de dades impecable, feu clic aquí.';

  @override
  String get backgroundImage => 'Imatge de fons';

  @override
  String get whatIsRandom =>
      'Quan «Utilitza la base de dades perfecta» no està habilitat, l\'opció «Aleatori» fa que la IA mogui peces sense usar cap algorisme de selecció de moviments. Això sol donar un joc molt feble. En canvi, si la base de dades perfecta està activada, la IA es basa exclusivament en aquesta, sense càlculs en temps real.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Retireu la peça (o peces) de la mà de l\'oponent i després serà el seu torn de col·locar.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Quan es formen molins durant la fase de col·locació';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Retireu la peça (o peces) de l\'oponent del tauler.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Retireu la peça (o peces) de l\'oponent del tauler; després serà el seu torn de col·locar.';

  @override
  String get opponentRemovesOwnPiece =>
      'L\'oponent retira les seves pròpies peces del tauler.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'En lloc que ho feu vosaltres, l\'oponent tria i retira la seva pròpia peça, fent-se mal ell mateix.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Retireu la peça (o peces) de la mà de l\'oponent i després és el vostre torn de moure.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Retireu la peça (o peces) de la mà de l\'oponent. Si, a causa de la configuració de supressió múltiple, s\'han de retirar més peces i l\'oponent ja no té peces a la mà, continueu retirant-ne del tauler. Després, és el vostre torn de moure. Si formeu més molins, podeu continuar retirant peces de l\'oponent.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Retireu la peça (o peces) de la mà de l\'oponent. Si, a causa de la supressió múltiple, cal retirar més peces i l\'oponent ja no en té a la mà, continueu retirant-ne del tauler. Després, és el torn de l\'oponent de moure.';

  @override
  String get markAndDelayRemovingPieces =>
      'Marca i retarda l\'eliminació de peces.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Durant la fase de col·locació, les peces que s\'han d\'eliminar queden marcades, i cap jugador pot tornar a col·locar-ne en aquests punts. Quan comença la fase de moviment, aquestes peces marcades s\'eliminen i els punts tornen a estar lliures.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Les accions que es poden fer en formar molins durant la fase de col·locació.';

  @override
  String get marked => 'Marcat';

  @override
  String get menu => 'Menú';

  @override
  String get monochrome => 'Monocrom';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Podeu habilitar l\'opció de compatibilitat amb el lector de pantalla a la configuració d\'accessibilitat en els paràmetres generals.';

  @override
  String get showNumbersOnPieces => 'Mostra nombres en les peces';

  @override
  String get saveImage => 'Desa la imatge';

  @override
  String get isAnalysisToolbarShown => 'Mostra la barra d\'eines d\'anàlisi';

  @override
  String get analysisToolbarBackgroundColor =>
      'Color de fons de la barra d\'eines d\'anàlisi';

  @override
  String get analysisToolbarIconColor =>
      'Color de la icona de la barra d\'eines d\'anàlisi';

  @override
  String get transformed => 'Transformat.';

  @override
  String get cannotTransform => 'No es pot transformar.';

  @override
  String get rotate => 'Gira';

  @override
  String get horizontalFlip => 'Inverteix horitzontalment';

  @override
  String get verticalFlip => 'Inverteix verticalment';

  @override
  String get innerOuterFlip => 'Inverteix interior-exterior';

  @override
  String get transparentCanvas => 'Llenç transparent';

  @override
  String get restrictRepeatedMillsFormation =>
      'Restringeix la formació repetida de molins';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Una peça que es mou des d\'un molí per formar-ne un altre no pot tornar immediatament a la posició original en el següent moviment per a formar un nou molí. Cal fer un moviment diferent abans.';

  @override
  String get oneTimeUseMill => 'Molí d\'un sol ús';

  @override
  String get oneTimeUseMill_Detail =>
      'Cada molí només pot eliminar una peça de l\'oponent una vegada. El podeu tornar a formar, però no serveix per a més eliminacions.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Les regles actuals que heu configurat no tenen una base de dades perfecta disponible. Per a més informació, feu clic aquí.';

  @override
  String get focusOnBlockingPaths => 'Centreu-vos a blocar els camins';

  @override
  String get focusOnBlockingPaths_Detail =>
      'En determinades fases de la partida, la IA prioritzarà blocar els moviments de l\'oponent per a aconseguir la victòria per ofegament, en lloc de formar molins directament.';

  @override
  String get pieceImage => 'Imatge de la peça';

  @override
  String get importColorSettings => 'Importa la configuració dels colors';

  @override
  String get exportColorSettings => 'Exporta la configuració dels colors';

  @override
  String get import => 'Importa';

  @override
  String get export => 'Exporta';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Copieu abans la configuració en format JSON al porta-retalls.';

  @override
  String get copiedToClipboard => 'S\'ha copiat al porta-retalls.';

  @override
  String get imported => 'S\'ha importat.';

  @override
  String get boardImage => 'Imatge del tauler';

  @override
  String get autumnLeaves => 'Fulles de tardor';

  @override
  String get legendaryLand => 'Terra llegendària';

  @override
  String get vignetteEffect => 'Efecte vinyeta';

  @override
  String get promptMakeToolbarTransparent =>
      'Voleu fer la barra d\'eines completament transparent quan s\'usa una imatge de fons al tauler?';

  @override
  String get vibration => 'Activa la vibració en el joc';

  @override
  String get soundTheme => 'Tema de so';

  @override
  String get ball => 'Pilota';

  @override
  String get liquid => 'Líquid';

  @override
  String get wood => 'Fusta';

  @override
  String get placeEffectAnimation => 'Efecte d\'animació en col·locar una peça';

  @override
  String get removeEffectAnimation => 'Efecte d\'animació en eliminar una peça';

  @override
  String get isToolbarAtBottom =>
      'Mostra la barra d\'eines en la part inferior';

  @override
  String get boardCornerRadius => 'Radi de les cantonades del tauler';

  @override
  String get useOpeningBook => 'Usa el llibre d\'obertures';

  @override
  String get currentRule => 'Actual';

  @override
  String get nineMensMorris => 'Marro de nou';

  @override
  String get twelveMensMorris => 'Marro de dotze';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Conjunt de regles';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'Molí d\'una vegada';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'Permet que la IA usi moviments d\'obertura habituals en jugadors professionals durant l\'inici de la partida. Nota: aquesta funció només està disponible per a alguns conjunts de regles.';

  @override
  String get showAdvantageGraph => 'Mostra el diagrama d\'avantatge';

  @override
  String get advantageGraphHint =>
      'El diagrama d\'avantatge només es mostrarà després que la IA faci un moviment. No es mostrarà en els moviments fets per un humà.';

  @override
  String get removalBasedOnMillCounts =>
      'Inhabilita l\'eliminació fins que totes les peces estiguin col·locades, després s\'eliminen peces basant-te en el nombre de molins fets.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'No s\'elimina cap peça fins que totes estiguin col·locades. Si tots dos formen el mateix nombre de molins, cadascun en retira el mateix nombre. Si un jugador en forma més, retira una peça extra per a mantenir la diferència d\'una peça. Si només un jugador forma molins, en retira dues, i l\'altre en retira una. Si cap dels dos en forma, tots dos es retiren una peça pròpia.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Trieu una de les vostres peces.';

  @override
  String get notYourTurn => 'No és el vostre torn.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Color de fons de la barra d\'eines d\'anotació';

  @override
  String get annotationToolbarIconColor =>
      'Color de la icona de la barra d\'eines d\'anotació';

  @override
  String get isAnnotationToolbarShown => 'Mostra la barra d\'eines d\'anotació';

  @override
  String get enterAnnotationMode => 'Entra en mode d\'anotació';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Segur que voleu suprimir totes les anotacions?';

  @override
  String get llmPromptCopiedToClipboard =>
      'S\'ha copiat la instrucció LLM al porta-retalls.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'S\'ha rebutjat la connexió. Potser el servidor està inactiu.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'S\'ha trobat el servidor, s\'està esperant la connexió...';

  @override
  String get noLanConnection => 'No hi ha connexió LAN';

  @override
  String get takeScreenshot => 'Fes una captura de pantalla';

  @override
  String get disconnectedFromOpponent => 'S\'ha desconnectat de l\'oponent.';

  @override
  String get takeBackRequest => 'Sol·licitud d\'anar enrere';

  @override
  String get nothingToShow => 'Res per mostrar.';

  @override
  String get stopHosting => 'Atura l\'allotjament';

  @override
  String get connectionResetByPeer =>
      'Un parell ha reinicialitzat la connexió.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'S\'ha perdut la connexió a causa del temps d\'espera del batec. Torneu a connectar-vos.';

  @override
  String get startHosting => 'Inicia l\'allotjament';

  @override
  String get restartRequestRejected =>
      'La sol·licitud de reinici s\'ha rebutjat.';

  @override
  String get notConnectedToLanOpponent =>
      'No esteu connectat a un oponent LAN.';

  @override
  String get llmPrompt => 'Petició LLM';

  @override
  String get gameRestarted => 'La partida s\'ha reiniciat.';

  @override
  String get takeBackRejected => 'S\'ha rebutjat l\'opció d\'anar enrere.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Segur que voleu abandonar aquesta partida?';

  @override
  String get opponentResignedYouWin => 'L\'oponent s\'ha rendit. Heu guanyat!';

  @override
  String get clearAllAnnotations => 'Suprimeix totes les anotacions';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Connectat, s\'està esperant el moviment de l\'oponent...';

  @override
  String get networkStatusDisconnected => 'Estat de la xarxa: desconnectat';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'S\'ha enviat la sol·licitud d\'anar enrere a l\'oponent.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'És possible que l\'oponent hagi abandonat la partida';

  @override
  String get connectedToHostSuccessfully =>
      'S\'ha connectat correctament a l\'amfitrió.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'S\'ha perdut la connexió: temps d\'espera del batec excedit';

  @override
  String get noHostDiscovered => 'No s\'ha trobat cap amfitrió.';

  @override
  String get confirmResignation => 'Confirmeu la rendició';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Heu començat a allotjar la partida, s\'està esperant que s\'hi uneixin jugadors...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Temps d\'espera exhaurit, la connexió de xarxa és inestable.';

  @override
  String get noLlmPromptAvailable => 'No hi ha cap petició LLM disponible.';

  @override
  String get youResignedGameOver => 'Us heu rendit. Final de partida.';

  @override
  String get serverIp => 'IP del servidor';

  @override
  String get confirmClear => 'Confirmeu l\'eliminació';

  @override
  String get opponentSTurn => 'Torn de l\'oponent.';

  @override
  String get waitingAClientConnection =>
      'S\'està esperant la connexió d\'un client...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'La sol·licitud d\'anar enrere ha estat rebutjada o ha fallat.';

  @override
  String get addText => 'Afegeix text';

  @override
  String get exitAnnotationMode => 'Surt del mode d\'anotació';

  @override
  String get typeYourAnnotation => 'Escriviu l\'anotació';

  @override
  String get attemptingToReconnect => 'S\'està intentant reconnectar...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'S\'ha enviat la sol·licitud de reinici. S\'està esperant la resposta de l\'oponent...';

  @override
  String get serverIsStopped => 'El servidor s\'ha aturat.';

  @override
  String get restartRequest => 'Sol·licitud de reinici';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'No podeu sol·licitar anar enrere si no és el vostre torn.';

  @override
  String get takeBackAccepted => 'S\'ha acceptat anar enrere.';

  @override
  String get localNetworkSettings => 'Configuració de xarxa local';

  @override
  String get reconnectedSuccessfully =>
      'S\'ha restablert la connexió amb èxit!';

  @override
  String get failedToSaveImageToGallery =>
      'No s\'ha pogut desar la imatge a la galeria.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'L\'oponent ha sol·licitat reiniciar la partida. Ho accepteu?';

  @override
  String get yourTurn => 'El vostre torn.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'No es pot restablir la connexió, reinicieu la partida.';

  @override
  String get host => 'Amfitrió';

  @override
  String get join => 'Entra';

  @override
  String get port => 'Port';

  @override
  String get invalidIpAddress => 'Adreça IP no vàlida.';

  @override
  String get invalidPort => 'Port no vàlid.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'S\'està connectant: intent $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'No s\'ha pogut connectar: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'No s\'ha pogut començar a allotjar: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Amfitrió trobat: $ip:$port';
  }

  @override
  String get stop => 'Atura';

  @override
  String get discover => 'Descobreix';

  @override
  String get connect => 'Connecta';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Client connectat: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'S\'està descobrint: $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Reconnexió ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Connectat';

  @override
  String get delete => 'Suprimeix';

  @override
  String get ancientEgypt => 'Antic Egipte';

  @override
  String get gothicIce => 'Gel gòtic';

  @override
  String get riceField => 'Camp d\'arròs';

  @override
  String get chinesePorcelain => 'Porcellana xinesa';

  @override
  String get desertDusk => 'Capvespre desèrtic';

  @override
  String get precisionCraft => 'Art precís';

  @override
  String get folkEmbroidery => 'Brodat popular';

  @override
  String get carpathianHeritage => 'Patrimoni dels Carpats';

  @override
  String get imperialGrandeur => 'Grandesa imperial';

  @override
  String get bohemianCrystal => 'Cristall de Bohèmia';

  @override
  String get savannaSunrise => 'Albada a la sabana';

  @override
  String get harmonyBalance => 'Harmonia i equilibri';

  @override
  String get cinnamonSpice => 'Espècia de canyella';

  @override
  String get anatolianMosaic => 'Mosaic anatoli';

  @override
  String get carnivalSpirit => 'Esperit de Carnaval';

  @override
  String get custom => 'Personalitzat';

  @override
  String get spiceMarket => 'Mercat d\'espècies';

  @override
  String get swipeToRevealTheDrawer =>
      'Feu lliscar per a mostrar el menú lateral';

  @override
  String get showGameInfoOnScreenshots =>
      'Mostra la informació de la partida en les captures de pantalla';

  @override
  String get humanMoveTime => 'Límit de temps humà';

  @override
  String get noTimeLimitForHumanMoves =>
      'Sense límit de temps per als moviments humans';

  @override
  String get timeoutLoseWillBeApplied =>
      'S\'aplicarà la pèrdua per temps d\'espera per al jugador humà';

  @override
  String get identifyingBoard => 'Identificant el tauler...';

  @override
  String get youCanEnterAnyModelName => 'Pots introduir qualsevol nom de model';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Posició del tauler aplicada. FEN copiat al porta-retalls.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Suggeriment: Prova a fer una foto més clara del tauler';

  @override
  String get llmPromptTemplate => 'Plantilla d\'indicació per a LLM';

  @override
  String get noValidBoardDetected => 'No s\'ha detectat cap tauler vàlid';

  @override
  String get selectingImageFromAlbum => 'Seleccionant imatge de l\'àlbum...';

  @override
  String get configurePromptTemplate => 'Configura la plantilla d\'indicació';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Edita la plantilla d\'indicació per a l\'anàlisi LLM';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'No s\'ha pogut generar el FEN a partir del tauler reconegut';

  @override
  String get outputInCurrentLanguage => 'Sortida en l\'idioma actual';

  @override
  String get commonBaseUrls => 'Base URLs comuns';

  @override
  String get viewCommonModels => 'Mostra els models comuns';

  @override
  String get recognitionParametersUpdated =>
      'Paràmetres de reconeixement actualitzats';

  @override
  String get whiteSMove => 'Torn de les blanques';

  @override
  String get resetToDefaults => 'Restableix els valors predeterminats';

  @override
  String get photoShoot => 'Fer foto';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'No s\'ha pogut aplicar la posició del tauler reconeguda';

  @override
  String get llmPromptContent => 'Contingut de la indicació LLM';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM no configurat. Comprova la configuració.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Defineix el proveïdor, el model, l\'API Key i la Base URL';

  @override
  String get llmConfiguration => 'Configuració de LLM';

  @override
  String get configureLlmProvider => 'Configura el proveïdor LLM';

  @override
  String get llmPromptTemplateHeader =>
      'Capçalera de la plantilla d\'indicació LLM';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'No s\'han reconegut peces a la imatge. Torna-ho a provar.';

  @override
  String get recognizeBoardFromImage =>
      'Reconeix el tauler a partir de la imatge';

  @override
  String get viewTips => 'Mostra consells';

  @override
  String get applyToBoard => 'Aplica al tauler';

  @override
  String get adjustBoardArea => 'Ajusta l\'àrea del tauler';

  @override
  String get viewCommonUrls => 'Mostra les URLs comunes';

  @override
  String get colorAnalysisFailed => 'L\'anàlisi de color ha fallat!';

  @override
  String get analyzingGameBoardImage =>
      'Analitzant la imatge del tauler de joc...';

  @override
  String get selectFromAlbum => 'Selecciona de l\'àlbum';

  @override
  String get noBoardPointDetected => 'No s\'ha detectat cap punt del tauler!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Si es deixa buit, s\'utilitzarà la plantilla predeterminada';

  @override
  String get llmConfig => 'Configuració LLM';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Estàs segur que vols restablir les plantilles d\'indicació als valors predeterminats?';

  @override
  String get llmPromptTemplateFooter =>
      'Peu de pàgina de la plantilla d\'indicació LLM';

  @override
  String get loadingResponse => 'Carregant resposta...';

  @override
  String get applyThisResultToBoard => 'Aplica aquest resultat al tauler';

  @override
  String get takingPicture => 'Fent foto...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Selecciona una imatge del tauler de joc per identificar';

  @override
  String get identificationResults => 'Resultats de la identificació';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Analitza les jugades i proporciona informació.';

  @override
  String get getApiKey => 'Obtenir API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'El procés de reconeixement complet no s\'ha pogut finalitzar';

  @override
  String get boardRecognitionResult => 'Resultat del reconeixement del tauler';

  @override
  String get askLlm => 'Pregunta a LLM';

  @override
  String get boardDetectionFailed => 'La detecció del tauler ha fallat!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'No s\'ha detectat cap punt del tauler, no es pot identificar la peça!';

  @override
  String get copyFen => 'Copia FEN';

  @override
  String get commonlyUsedModels => 'Models utilitzats habitualment';

  @override
  String get apiKeyOptional => 'API Key (Opcional)';

  @override
  String get noImageSelected => 'No s\'ha seleccionat cap imatge';

  @override
  String get blackSMove => 'Torn de les negres';

  @override
  String get llm => 'Model de Llenguatge Massiu';

  @override
  String get llmProvider => 'Proveïdor';

  @override
  String get baseUrl => 'URL base';

  @override
  String get model => 'Model';

  @override
  String get temperature => 'Temperatura';

  @override
  String get llmCommandReceivedProcessing =>
      'Comanda rebuda! La IA està processant...';

  @override
  String get llmDeepThinkingWait =>
      'Pensament profund en curs, si us plau, espereu...';

  @override
  String get llmPresentingSoon => 'Presentació en breu...';

  @override
  String get recognitionParameters => 'Paràmetres de reconeixement';

  @override
  String get adjustParamsDesc =>
      'Ajusta els paràmetres per millorar la precisió del reconeixement';

  @override
  String get saveParameters => 'Desa els paràmetres';

  @override
  String unableToStartImageRecognition(String error) {
    return 'No es pot iniciar el reconeixement d\'imatge: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'El reconeixement d\'imatge ha fallat: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'S\'ha aplicat la posició amb $whiteCount peces blanques i $blackCount peces negres';
  }

  @override
  String get fenCopiedToClipboard => '(FEN copiat al porta-retalls)';

  @override
  String recognitionFailed(String error) {
    return 'El reconeixement ha fallat: $error';
  }

  @override
  String get myRating => 'La meva puntuació';

  @override
  String get gamesPlayed => 'Partides jugades';

  @override
  String get wins => 'Victòries';

  @override
  String get losses => 'Derrotes';

  @override
  String get draws => 'Empats';

  @override
  String get lastUpdated => 'Darrera actualització';

  @override
  String get format => 'Format:';

  @override
  String get resetStatistics => 'Restableix les estadístiques';

  @override
  String get drawRate => 'Taxa d\'empats';

  @override
  String get lossRate => 'Taxa de derrotes';

  @override
  String get aiStatistics => 'Estadístiques de la IA';

  @override
  String get enableStatistics => 'Activa les estadístiques';

  @override
  String get enableStatistics_Detail =>
      'Quan estigui activat, els resultats de les partides es registraran a les estadístiques. No obstant això, les partides que impliquin retrocessos no es registraran. Quan estigui desactivat, la recollida d\'estadístiques s\'atura.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Això restablirà totes les estadístiques del joc. Aquesta acció no es pot desfer.';

  @override
  String get boardInnerRingSize => 'Mida de l\'anell interior del tauler';

  @override
  String get boardShadowEnabled => 'Ombra del tauler';

  @override
  String get trapAwareness => 'Detecció de paranys';

  @override
  String get trapAwarenessDescription =>
      'Ressalta els moviments de parany amb cercles i fletxes gruixuts durant l\'anàlisi.';

  @override
  String trapExists(String trapMoves) {
    return 'Hi ha un parany. Moviments de parany: $trapMoves';
  }

  @override
  String get custodianCapture => 'Captura de flanqueig';

  @override
  String get custodianCaptureDescription =>
      'Indiqueu una de les peces del vostre oponent entre dues de les vostres en una línia recta per capturar -la.';

  @override
  String get custodianCaptureEnable => 'Permet la captura de flanqueig';

  @override
  String get interventionCapture => 'Captura d\'intervenció';

  @override
  String get interventionCaptureDescription =>
      'Desplaceu -vos al punt buit entre dues de les peces del vostre oponent per capturar -les totes dues.';

  @override
  String get interventionCaptureEnable => 'Permetre la captura d’intervenció';

  @override
  String get leapCapture => 'Saltar captura';

  @override
  String get leapCaptureDescription =>
      'Captura saltant sobre la peça d’un oponent adjacent al punt buit més enllà.';

  @override
  String get leapCaptureEnable => 'Permet la captura de salt';

  @override
  String get captureApplicableLines => 'Línies aplicables';

  @override
  String get captureSquareEdges => 'Al llarg de les vores de la plaça';

  @override
  String get captureCrossLines =>
      'Al llarg de línies ortogonals creuant el quadrat';

  @override
  String get captureDiagonalLines =>
      'Al llarg de les línies en diagonal creuant el quadrat';

  @override
  String get captureExecutionPhases => 'Fases d\'execució';

  @override
  String get capturePiecesCondition =>
      'Disponibilitat durant la fase de moviment en funció de les peces restants';

  @override
  String get capturePiecesConditionUnlimited => 'Sense restricció';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Disponible quan tingueu tres o menys peces';
}
