// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Bosnian (`bs`).
class SBs extends S {
  SBs([String locale = 'bs']) : super(locale);

  @override
  String get appName => 'Mlin';

  @override
  String get welcome => 'Dobro došli';

  @override
  String get yes => 'Da';

  @override
  String get no => 'Ne';

  @override
  String get game => 'Igra';

  @override
  String get humanVsAi => 'Čovjek protiv UI-a';

  @override
  String get humanVsHuman => 'Čovjek protiv čovjeka';

  @override
  String get aiVsAi => 'UI protiv UI-a';

  @override
  String get humanVsCloud => 'Čovjek protiv oblaka';

  @override
  String get humanVsLAN => 'Čovjek protiv LAN-a';

  @override
  String get testViaLAN => 'Test putem LAN-a';

  @override
  String get move => 'Potezi';

  @override
  String get showMoveList => 'Popis poteza';

  @override
  String get moveList => 'Popis poteza';

  @override
  String get noGameRecord => 'Nema zapisa';

  @override
  String get ok => 'U redu';

  @override
  String get confirm => 'Potvrdi';

  @override
  String get cancel => 'Odustani';

  @override
  String get tipSelectWrong => 'Odaberite pogrešnu figuru.';

  @override
  String get tipPlace => 'Postavite svoje figure.';

  @override
  String get tipBanPlace => 'Ovdje je ne možete postaviti.';

  @override
  String get tipPlaced => 'Postavili ste.';

  @override
  String get tipRemove => 'Uklonite jednu figuru.';

  @override
  String get tipBanRemove => 'Ne možete je ukloniti.';

  @override
  String get tipRemoved => 'Uklonili ste.';

  @override
  String get tipMove => 'Pomaknite jednu figuru.';

  @override
  String get tipCannotPlace => 'Ovdje ne možete postaviti svoju figuru.';

  @override
  String get tipCannotMove => 'Ovamo ne možete pomaknuti svoju figuru.';

  @override
  String get tipMill => 'Mlin! Uzmite protivničku figuru.';

  @override
  String get tipContinueMill => 'Nastavite uzimati protivničku figuru.';

  @override
  String get tipSelectOpponentsPiece => 'Odaberite jednu protivničku figuru.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Ne možete ukloniti figuru iz mlina.';

  @override
  String get tipCanMoveOnePoint => 'Figura se može pomaknuti za jedno mjesto.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Ne možete pomicati protivničke figure.';

  @override
  String get tipSelectPieceToMove => 'Odaberite svoj figuru za pomicanje.';

  @override
  String get tipHaveThreePiecesLeft => 'Preostale su vam tri figure.';

  @override
  String get tipCanMoveToAnyPoint => 'Možete se pomaknuti na bilo koje mjesto.';

  @override
  String tipToMove(Object player) {
    return '$player je na potezu.';
  }

  @override
  String get whiteWin => 'Igrač 1 pobjeđuje!';

  @override
  String get blackWin => 'Igrač 2 pobjeđuje!';

  @override
  String get won => 'Pobijedio';

  @override
  String get lost => 'Izgubio';

  @override
  String get thinking => 'Razmišljam …';

  @override
  String get newGame => 'Nova igra';

  @override
  String get importGame => 'Uvezi igru';

  @override
  String get exportGame => 'Izvezi igru';

  @override
  String get gameImported => 'Igra uvezena.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Nije moguće uvesti $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'Potezi i pravila se ne podudaraju.';

  @override
  String get pleaseWait => 'Pričekajte.';

  @override
  String get restartGame => 'Ponovo pokrenuti trenutačnu igru?';

  @override
  String get restart => 'Pokreni ponovo';

  @override
  String get gameStarted => 'Igra je počela, postavite figuru.';

  @override
  String get analyzing => 'Analiziranje …';

  @override
  String error(Object message) {
    return 'Pogreška: $message';
  }

  @override
  String get winRate => 'Stopa pobjeda';

  @override
  String get score => 'Rezultat:';

  @override
  String get white => 'Igrač 1';

  @override
  String get black => 'Igrač 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player ima manje od tri figure.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player se predao.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player ne može pomaknuti nijednu figuru.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Ploča je puna i $player ne može pomaknuti nijednu figuru.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Vrijeme je prošlo, $player je izgubio.';
  }

  @override
  String get drawReasonRule50 =>
      'U fazi pomicanja nijedna figura nije uklonjena u zadnjih određenih broja poteza.';

  @override
  String get drawReasonBoardIsFull => 'Neodlučeno jer je ploča puna.';

  @override
  String get drawReasonThreefoldRepetition =>
      'Neodlučeno zbog trostrukog ponavljanja.';

  @override
  String get gameOverUnknownReason => 'Igra je gotova! Nepoznat razlog.';

  @override
  String get gameOver => 'Igra je gotova';

  @override
  String get youWin => 'Pobjedili ste! Čestitamo!';

  @override
  String challengeHarderLevel(int level) {
    return 'Odigrati težu razinu? Nova razina bit će razina $level!';
  }

  @override
  String get youLose => 'Izgubili ste!';

  @override
  String get analyze => 'Analizirajte';

  @override
  String get about => 'O aplikaciji';

  @override
  String version(Object versionNumber) {
    return 'Verzija: $versionNumber';
  }

  @override
  String get thanks => 'Hvala';

  @override
  String get settings => 'Postavke';

  @override
  String get options => 'Opcije';

  @override
  String get generalSettings => 'Opće postavke';

  @override
  String get skillLevel => 'Razina težine';

  @override
  String get moveTime => 'Vrijeme razmišljanja UI-a';

  @override
  String get difficulty => 'Težina';

  @override
  String get playSounds => 'Zvučni efekti';

  @override
  String get playSoundsInTheGame => 'Sviraj zvukove u igri';

  @override
  String get keepMuteWhenTakingBack =>
      'Bez zvuka pri vraćanju figure na prethodno mjesto';

  @override
  String get tone => 'Ton';

  @override
  String get whoMovesFirst => 'Prvi potez';

  @override
  String get human => 'Čovjek';

  @override
  String get ai => 'UI (umjetna inteligencija)';

  @override
  String get alternate => 'Naizmjence';

  @override
  String get isAutoRestart =>
      'Automatski ponovo pokreni igru kad je igra gotova';

  @override
  String get isAutoChangeFirstMove =>
      'Automatski zamijeni igrače s pravom prvog poteza';

  @override
  String get shufflingEnabled => 'Slučajno pomicanje';

  @override
  String get misc => 'Razno';

  @override
  String get rules => 'Pravila';

  @override
  String get piecesCount => 'Broj figura za svakog igrača';

  @override
  String get piecesCount_Detail => 'Koliko figura ima svaki igrač?';

  @override
  String get flyPieceCount => 'Broj figura za skakanje';

  @override
  String get flyPieceCount_Detail =>
      'Ako je skakanje aktivirano, kada igraču preostane određeni broj figura, one se mogu premjestiti na bilo koje neuzeto mjesto. Premještanje nije ograničeno samo na susjedna mjesta kao inače u igri.';

  @override
  String get piecesAtLeastCount => 'Najmanji broj figura';

  @override
  String get hasDiagonalLines => 'Dijagonalne linije';

  @override
  String get hasDiagonalLines_Detail =>
      'Ploči dodaj četiri dijagonalne linije.';

  @override
  String get isDefenderMoveFirst => 'Drugi igrač ima pravo prvog poteza';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Drugi igrač u fazi postavljanja je prvi na redu u fazi pomicanja.';

  @override
  String get mayRemoveMultiple => 'Višestruko uklanjanje';

  @override
  String get mayRemoveMultiple_Detail =>
      'Ako igrač zatvori više od jednog mlina odjednom, može ukloniti isti broj figura protivnika.';

  @override
  String get mayRemoveFromMillsAlways => 'Uništi mlinove';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Prema zadanim postavkama, igrači moraju najprije ukloniti bilo koje druge figure prije uklanjanja figura iz formiranog mlina. Aktivirajte ovu opciju da biste onemogućili ograničenje.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Drugi igrač gubi kada je ploča puna';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Kada je ploča na kraju faze postavljanja puna, igrač koji prvi postavlja figure gubi igru. Inače je igra neodlučena.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Izgubi kada ne postoji mogućnost pomicanja';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Igrač će izgubiti ako ga protivnik blokira tako da ne može pomaknuti figure. Promijeni stranu za pomicanje ako je ova opcija deaktivirana.';

  @override
  String get mayFly => 'Skakanje';

  @override
  String get mayFly_Detail =>
      'Ako igrač ima samo tri ili četiri (podesive) figure, igrač smije premjestiti figuru na bilo koje slobodno mjesto.';

  @override
  String get nMoveRule => 'Pravilo broja poteza';

  @override
  String get nMoveRule_Detail =>
      'Igra završava neodlučeno ako nijedna figura nije uklonjena u određenom broju poteza.';

  @override
  String get rollback => 'Vraćanje unatrag';

  @override
  String get pleaseSelect => 'Odaberite';

  @override
  String get copy => 'Kopiraj';

  @override
  String get moveHistoryCopied => 'Povijest poteza je kopirana u međuspremnik.';

  @override
  String get help => 'Pomoć';

  @override
  String get feedback => 'Povratne informacije';

  @override
  String get exit => 'Zatvori';

  @override
  String get ruleSettings => 'Postavke pravila';

  @override
  String get color => 'Boja';

  @override
  String get boardColor => 'Boja ploče';

  @override
  String get pieceColor => 'Boja figure';

  @override
  String get backgroundColor => 'Boja pozadine';

  @override
  String get lineColor => 'Boja linija ploče';

  @override
  String get whitePieceColor => 'Boja figura igrača 1';

  @override
  String get blackPieceColor => 'Boja figura igrača 2';

  @override
  String get messageColor => 'Boja poruka';

  @override
  String get isPieceCountInHandShown => 'Prikaži broj nepostavljenih figura';

  @override
  String get isNotationsShown => 'Prikaži notacije na ploči';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Prikaži alatnu traku za navigaciju kroz povijest';

  @override
  String get display => 'Prikaz';

  @override
  String get boardBorderLineWidth => 'Širina rubne linije ploče';

  @override
  String get boardInnerLineWidth => 'Širina unutarnjih linija ploče';

  @override
  String get pieceWidth => 'Širina figure';

  @override
  String get fontSize => 'Veličina fonta';

  @override
  String get standardNotation => 'WMD zapisi';

  @override
  String get restore => 'Obnovi';

  @override
  String get restoreDefaultSettings => 'Obnovi standardne postavke';

  @override
  String pick(Object element) {
    return 'Odaberite $element';
  }

  @override
  String get info => 'Info';

  @override
  String get hint => 'Savjet';

  @override
  String get player => 'igrač';

  @override
  String get player1 => 'Igrač 1';

  @override
  String get player2 => 'Igrač 2';

  @override
  String get howToPlay => 'Kako igrati';

  @override
  String get toPlacePiece =>
      'Dodirnite bilo koje dostupno mjesto za postavljanje figure.';

  @override
  String get toSelectPiece => 'Dodirnite figuru da biste je premjestili.';

  @override
  String get toMovePiece =>
      'Dodirnite susjedno slobodno mjesto da biste premjestili figuru.';

  @override
  String get toRemovePiece =>
      'Dodirnite protivničku figuru da biste je uklonili.';

  @override
  String get needToCreateMillFirst =>
      'Za uklanjanje figure najprije morate stvoriti mlin.';

  @override
  String get needToPlayWithOwnPieces => 'Morate igrati s vlastitim figurama.';

  @override
  String get statistics => 'Statistika';

  @override
  String get totalGames => 'Ukupni broj igri';

  @override
  String get results => 'Rezultati';

  @override
  String get left => 'lijevo';

  @override
  String get privacyPolicy => 'Politika privatnosti';

  @override
  String get privacyPolicy_Detail_1 =>
      'Pažljivo pročitajte i budite sigurni da u potpunosti razumijete te da se slažete se s ovom ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Ako se ne slažete s ovom politikom, nemojte koristiti ovu aplikaciju. Korištenje aplikacije podrazumijeva da prihvaćate ove uvjete.';

  @override
  String get and => ' i ';

  @override
  String get accept => 'Prihvati';

  @override
  String get takeBack => 'Vrati figuru na prethodno mjesto';

  @override
  String get takingBack => 'Vrati figure na prethodno mjesto …';

  @override
  String get waiting => 'Čekanje …';

  @override
  String get stepForward => 'Pomakni figuru naprijed';

  @override
  String get takeBackAll => 'Vrati sve figure na početak';

  @override
  String get stepForwardAll => 'Pomakni sve figure na kraj';

  @override
  String get moveNow => 'Pomakni sada';

  @override
  String get done => 'Gotovo.';

  @override
  String get crackMill => 'Razbijanje mlina';

  @override
  String get crackMill_Detail =>
      'Ako igrač ima figure samo u mlinovima, figure u mlinovima će se moći ukloniti.';

  @override
  String get animationDuration => 'Trajanje animacije';

  @override
  String get none => 'Ništa';

  @override
  String get theme => 'Tema';

  @override
  String get helpContent =>
      'Cilj igre je ostaviti protivnika s manje od tri figure ili mu onemogućiti pomicanje figura.\n\nIgra automatski završava neodlučeno ako se pozicija dogodi po treći put ili ako se nijedna figura ne ukloni u zadnjih 100 (podesivo) poteza.\n\nIgra se odvija u tri faze:\n\n1. Postavljanje figura na slobodna mjesta\n2. Pomicanje figura na susjedna mjesta\n3. (opcionalna faza) Premještanje figura na bilo koje slobodno mjesto kada igrač ima samo još tri figure\n\nPostavljanje\n\nIgra započinje praznom pločom koja se sastoji od rešetke s dvadeset četiri mjesta. Igrači naizmjence postavljaju svoje figure na slobodna mjesta sve dok svaki igrač ne postavi sve svoje figure na ploču. Igrač koji uspije postaviti tri figure u nizu ima „mlin” i smije ukloniti jednu protivničku figuru s ploče.\n\nU nekim pravilima igrači moraju najprije ukloniti bilo koji drugu figuru prije uklanjanja figura iz formiranog mlina.\n\nU nekim pravilima u fazi postavljanja se mjesta uklonjenih figura ne mogu ponovo zauzeti.\n\nNakon postavljanja svih figura igrači naizmjence pomiču svoje figure.\n\nPomicanje\n\nIgrač pomiče jednu od svojih figura duž linije na slobodno susjedno mjesto. Ako to ne može učiniti gubi partiju. Kao u fazi postavljanja, Igrač koji uspije postaviti tri figure u nizu ima „mlin” i smije ukloniti jednu protivničku figuru. Igrač koji ima samo još dvije figure ne može sastaviti novi mlin i gubi partiju. Igrač također gubi partiju kada ima više od tri figure, ako protivnik blokira njihovo pomicanje.\n\nSkakanje\n\nU nekim varijantama pravila, kada jednom igraču ostanu samo tri figure, igrač može skakati na bilo koja prazna mjesta, ne samo na susjedna.\n';

  @override
  String get versionInfo => 'Informacije o verziji';

  @override
  String get eula => 'Licencni ugovor (EULA)';

  @override
  String get license => 'Licenca';

  @override
  String get sourceCode => 'Izvorni kod';

  @override
  String get appVersion => 'Verzija aplikacije';

  @override
  String get general => 'Općenito';

  @override
  String get advanced => 'Napredno';

  @override
  String get placing => 'Postavljanje';

  @override
  String get moving => 'Pomicanje';

  @override
  String get removing => 'Uklanjanje';

  @override
  String get gameOverCondition => 'Uvjet kraja igre';

  @override
  String get aisPlayStyle => 'Stil igre UI-a';

  @override
  String get passive => 'Pasivno';

  @override
  String get timeout => 'Pauza';

  @override
  String get appearance => 'Izgled';

  @override
  String get drawOnHumanExperience => 'Koristi ljudsko iskustvo';

  @override
  String get considerMobility => 'Uzmi u obzir pokretljivost figura';

  @override
  String get pieceCount => 'Broj figura:';

  @override
  String inHand(Object player, int count) {
    return '$player u ruci: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player na ploči: $count';
  }

  @override
  String get boardTop => 'Gornji odmak ploče';

  @override
  String get notAIsTurn => 'UI nije na redu.';

  @override
  String get aiIsNotThinking => 'UI ne razmišlja.';

  @override
  String get atEnd => 'Dosegnuli ste kraj popisa poteza.';

  @override
  String get tapBackAgainToLeave =>
      'Za napuštanje igre ponovo dodirnite gumb za natrag.';

  @override
  String get more => 'Više';

  @override
  String get experimental => 'Ovo je eksperimentalna funkcija.';

  @override
  String get experiments => 'Eksperimenti';

  @override
  String get ossLicenses => 'Licence otvorenog koda';

  @override
  String get language => 'Jezik';

  @override
  String get defaultLanguage => 'Standardni jezik';

  @override
  String get mayMoveInPlacingPhase =>
      'Figure se mogu pomicati u fazi postavljanja';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Ne postoje zasebne faze postavljanja i pomicanja. To znači da igrači mogu pri svakom potezu odlučiti žele li postaviti figuru na ploču ili pomaknuti jednu od svojih figura (sve dok imaju figure za postavljanje).';

  @override
  String get drawerColor => 'Boja izbornika';

  @override
  String get drawerTextColor => 'Boja teksta izbornika';

  @override
  String get drawerHighlightItemColor => 'Boja isticanja elementa izbornika';

  @override
  String get mainToolbarBackgroundColor => 'Boja pozadine glavne alatne trake';

  @override
  String get mainToolbarIconColor => 'Boja ikona glavne alatne trake';

  @override
  String get navigationToolbarBackgroundColor =>
      'Boja pozadine alatne trake navigacije';

  @override
  String get navigationToolbarIconColor => 'Boja ikona alatne trake navigacije';

  @override
  String get autoHideToolbar => 'Automatski sakrij alatnu traku';

  @override
  String get toolbarLocationOnScreen => 'Mjesto alatne trake na ekranu';

  @override
  String get top => 'Gore';

  @override
  String get bottom => 'Dolje';

  @override
  String get center => 'Središte';

  @override
  String get solidColor => 'Puna boja';

  @override
  String get picture => 'Slika';

  @override
  String get chooseYourPicture => 'Odaberite svoju sliku';

  @override
  String get light => 'Svijetla';

  @override
  String get dark => 'Tamna';

  @override
  String get themes => 'Teme';

  @override
  String get currentTheme => 'Trenutna tema';

  @override
  String get saveTheme => 'Spremi temu';

  @override
  String get showAnalysisGraph => 'Prikaži grafikon analize';

  @override
  String get analysis => 'Analiza';

  @override
  String get saveGame => 'Spremi igru';

  @override
  String get loadGame => 'Učitaj igru';

  @override
  String get setupPosition => 'Položaj postave';

  @override
  String get showLegalMoves => 'Prikaži dozvoljene poteze';

  @override
  String get showLastMove => 'Prikaži zadnji potez';

  @override
  String get showArrows => 'Prikaži strelice';

  @override
  String get pieces => 'Figure';

  @override
  String get showAnalysis => 'Prikaži analizu';

  @override
  String get threads => 'Tematske poruke';

  @override
  String get getInvolved => 'Uključite se';

  @override
  String get helpImproveTranslate => 'Pomognite poboljšati prijevod';

  @override
  String get tutorial => 'Vježbe';

  @override
  String get classicMill => 'Klasični mlin';

  @override
  String get mixedMill => 'Miješani mlin';

  @override
  String get ceylonMill => 'Šri Lankanski mlin';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Mlin se može više puta pokvariti i prepravljati';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Ako igrač razbije mlin da bi odmah stvorio novi mlin, taj igrač može vratiti svoju figuru natrag na izvorni čvor u svom sljedećem potezu ako na taj način stvori novi mlin.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Igra završava neodlučeno ako jedan igrač ima tri figure i ako nakon deset poteza niti jedan igrač ne ukloni protivničke figure';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Kada jedan igrač ima samo još tri figure i ako nijedan igrač ne može ukloniti jednu protivničku figuru u deset poteza, igra završava neodlučeno.';

  @override
  String get close => 'Zatvori';

  @override
  String get whitePiece => 'Bijela figura';

  @override
  String get blackPiece => 'Crna figura';

  @override
  String get emptyPoint => 'Prazno mjesto';

  @override
  String get noPoint => 'Nema mjesta';

  @override
  String get placingPhase => 'Faza postavljanja';

  @override
  String get movingPhase => 'Faza pomicanja';

  @override
  String get flyingPhase => 'Faza skakanja';

  @override
  String sideToMove(Object player) {
    return 'Strana za pomicanje: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Zadnji potez: $move';
  }

  @override
  String get selected => 'Odabrano';

  @override
  String get accessibility => 'Pristupačnost';

  @override
  String get screenReaderSupport => 'Podrška čitača ekrana';

  @override
  String get isDraw => 'Neodlučeno!';

  @override
  String get draw => 'Neodlučeno';

  @override
  String get pieceHighlightColor => 'Boja isticanja figure';

  @override
  String get algorithm => 'Algoritam';

  @override
  String get endgameNMoveRule => 'Pravilo broja poteza za završavanje igre';

  @override
  String get endgameNMoveRule_Detail =>
      'Igra završava neodlučeno ako jedan od igrača ima tri figure i ako nijedan igrač ne ukloni jednu figuru unutar određenog broja poteza.';

  @override
  String get drawReasonEndgameRule50 =>
      'Jedan igrač ima samo tri figure i nijedan igrač ne uklanja figuru u određenom broju poteza.';

  @override
  String get threefoldRepetitionRule => 'Pravilo trostrukog ponavljanja';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Igra završava neodlučeno ako se pozicija pojavi po treći put.';

  @override
  String get continueToMakeMove => 'Mlin! Nastavite s pomicanjem.';

  @override
  String get pointStyle => 'Stil mjesta';

  @override
  String get pointWidth => 'Širina mjesta';

  @override
  String get solid => 'Obojeno';

  @override
  String get hollow => 'Šuplje';

  @override
  String get languageName => 'Bosanski';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count poteza',
      few: '$count poteza',
      one: '$count potez',
      zero: 'Move',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Učitavanje nije uspjelo.';

  @override
  String get filename => 'Ime datoteke';

  @override
  String get browse => 'Pretraži …';

  @override
  String get gameFiles => 'Datoteke igre';

  @override
  String get gameSavedTo => 'Igra je spremljena u';

  @override
  String get empty => 'Prazno';

  @override
  String get noMove => 'Nema pomaka.';

  @override
  String get restoredPosition => 'Obnovljen početni položaj.';

  @override
  String get clean => 'Očisti';

  @override
  String get cleanedUp => 'Očišćeno.';

  @override
  String get remove => 'Ukloni';

  @override
  String get noPiecesCanBeRemoved => 'Nijedna figura se ne može ukloniti.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count figura',
      few: '$count figure',
      one: '$count figura',
      zero: 'Piece',
    );
    return '$_temp0 treba ukloniti.';
  }

  @override
  String placedCount(int count) {
    return 'Postav. ($count)';
  }

  @override
  String get placedPieceCount =>
      'Broj postavljenih figura u fazi postavljanja.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'Trenutačni igrač je postavio $count figure.';
  }

  @override
  String get notPlacingPhase =>
      'Nije faza postavljanja, ne može se promijeniti.';

  @override
  String get paste => 'Zalijepi';

  @override
  String get pasteDone => 'Lijepljenje je gotovo.';

  @override
  String get cannotPaste => 'Nije moguće zalijepiti.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Prikaži nepostavljene i uklonjene figure';

  @override
  String get fullScreen => 'Cjeloekranski prikaz';

  @override
  String get reopenToTakeEffect =>
      'Zatvorite i ponovo otvorite aplikaciju kako bi postavke stupile na snagu.';

  @override
  String get forest => 'Šuma';

  @override
  String get desktopImage => 'Slika radne površine';

  @override
  String get invalidPosition => 'Nevažeći položaj.';

  @override
  String get shareGIF => 'Dijeli GIF';

  @override
  String get pixelRatio => 'Omjer piksela';

  @override
  String get duration => 'Trajanje';

  @override
  String get gameScreenRecorder => 'Snimač zaslona igre';

  @override
  String get previous => 'Prethodna';

  @override
  String get next => 'Sljedeća';

  @override
  String get skip => 'Preskoči';

  @override
  String get gotIt => 'Razumijem';

  @override
  String get youCanModifyRules =>
      'Pravila igre možeš mijenjati u postavkama pravila.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Za mijenjanje vrijednosti u biraču možeš koristiti kotačić miša.';

  @override
  String get noTimeLimitForThinking =>
      'Vrijeme razmišljanja UI-a postavljeno na 0 znači da nema vremenskog ograničenja za razmišljanje.';

  @override
  String get whatIsMtdf =>
      'MTD(f) je modificirani oblik alfa-beta algoritma pretraživanja koji ima za cilj poboljšati učinkovitost ponovnim korištenjem posrednih rezultata pretrage i korištenjem dobrog početnog pogađanja za sužavanje prostora pretrage.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Imajte na umu da prilagodba vremena razmišljanja umjetne inteligencije možda neće biti sasvim precizna. Stvarno vrijeme razmišljanja može biti kraće kada je razina težine postavljena na nižu vrijednost i može biti duže kada je AI u fazi razmišljanja kada vrijeme istekne.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Ako postaviš visoku razinu težine, ali ne povećaš vrijeme razmišljanja UI-a, stvarna razina težine može biti ograničena na nižu vrijednost zbog vremenskog ograničenja razmišljanja. Stvarna vrijednost može varirati ovisno o performansama stroja.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) je algoritam pretraživanja za pronalaženje najboljeg poteza u određenoj poziciji. To je poboljšanje alfa-beta algoritma i koristi nulte ili nulte pretrage prozora za potvrdu da je potez lošiji ili nije lošiji od već sigurnog rezultata iz glavne varijacije. PVS se fokusira na poteze koji najviše obećavaju i izbjegava nepotrebne pretrage suboptimalnih grana, što pomaže u poboljšanju učinkovitosti pretrage.';

  @override
  String get whatIsAlphaBeta =>
      'Alfa-beta algoritam je algoritam pretraživanja za pronalaženje najboljeg poteza. Koristi minimax princip i dvije vrijednosti, alfa i beta, za smanjenje stabla pretraživanja i povećanje učinkovitosti. Alpha predstavlja minimalni rezultat za koji je računalo sigurno da može dobiti, dok beta predstavlja maksimalni rezultat koji njegov protivnik može dobiti. Algoritam pomaže računalu donositi pametne i učinkovite odluke u igri.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Prema ljudskom iskustvu, ako pokušate pobijediti, izgubit ćete. Umjesto toga, ciljajte na remi kao svoj cilj i izbjegnite gubitak igre. Promatrajte svog protivnika i nježno ga namamite u poziciju u kojoj bi mogao pogriješiti. Kada pokaže slabost, zgrabite priliku i nježno gurnite za pobjedu. Na taj način možete pobijediti partiju.';

  @override
  String get firstMoveDetail =>
      'U ovoj igri drugi igrač lakše pobjeđuje nego prvi igrač.';

  @override
  String get passiveDetail =>
      'Omogućavanje pasivne opcije će uzrokovati da se AI opusti kada ima prednost u poziciji, umjesto da agresivno pokušava pobijediti što je brže moguće.';

  @override
  String get moveRandomlyDetail =>
      'Uključivanje ove opcije povećava nasumičnost i zabavu igre, dok njezino isključivanje može pomoći u proučavanju načina da se pobijedi AI.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Ako umjetna inteligencija uzme u obzir pokretljivost svojih figura, neće nastojati samo uzimati protivničke figure što je brže moguće, već će također razmotriti blokiranje protivničkih poteza i spriječiti da protivnik učini isto.';

  @override
  String get whenBoardIsFull => 'Kad je ploča puna';

  @override
  String get whenBoardIsFull_Detail =>
      'Na kraju faze postavljanja, prije početka faze pomicanja, slijedi akcija ako je ploča puna figura.';

  @override
  String get sideToMoveRemovePiece =>
      'Igrač koji prvi pomiče figure u fazi pomicanja uklanja jednu od protivničkih figura.';

  @override
  String get agreeToDraw => 'Obje strane pristaju na neodlučeno.';

  @override
  String get takeOpponentsPiece => 'Uzmite jednu od protivničkih figura.';

  @override
  String get firstPlayerLose => 'Prvi igrač gubi igru.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Prvi i drugi igrač uklanjaju jednu protivničku figuru.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Drugi i prvi igrač uklanjaju jednu protivničku figuru.';

  @override
  String get enteredFlyingPhase =>
      'Sada kada smo ušli u fazu skakanja, protivničke figure mogu skakati na bilo koje prazno mjesto na ploči. Pravilo skakanja se može isključiti u „Postavke pravila”.';

  @override
  String get whenStalemate => 'Pat situacija';

  @override
  String get whenStalemate_Detail =>
      'Koja radnja slijedi kada se nijedna figura ne može pomaknuti?';

  @override
  String get endWithStalemateLoss =>
      'Završite s izgubljenim patom za stranu koja je blokirana.';

  @override
  String get changeSideToMove => 'Promijenite stranu za pomicanje.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Uklonite jednu od protivničkih figura i napravite sljedeći potez.';

  @override
  String get endWithStalemateDraw =>
      'Završite igru neodlučeno zbog pat situacije.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Uklonite jednu od protivničkih figura i promijenite stranu kretanja.';

  @override
  String get aiResponseDelayTime => 'Vrijeme odgode odgovora za UI';

  @override
  String get aiIsDelaying =>
      'UI je trenutačno u fazi odgođenog odgovora. Pričekajte neko vrijeme prije nastavljanja.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Ne možeš ukloniti nesusjednu figuru.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'Ako dođe do pat pozicije, protivničke figure pored tvojih se mogu ukloniti bez obzira na formaciju mlina.';

  @override
  String get whatIsMcts =>
      'MCTS je algoritam prilagođen početnicima koji donosi odluke istražujući i procjenjujući različite poteze kroz simulacije.';

  @override
  String get goldenJade => 'Zlatni žad';

  @override
  String get forestWood => 'Šumsko drvo';

  @override
  String get darkMystery => 'Tamna misterija';

  @override
  String get midnightBlue => 'Ponoćno plava';

  @override
  String get greenForest => 'Zelena šuma';

  @override
  String get greenMeadow => 'Zelena livada';

  @override
  String get stonyPath => 'Kameniti put';

  @override
  String get pastelPink => 'Pastelno ružičasta';

  @override
  String get turquoiseSea => 'Tirkizno more';

  @override
  String get violetDream => 'Ljubičasti san';

  @override
  String get mintChocolate => 'Mint čokolada';

  @override
  String get skyBlue => 'Nebesko plava';

  @override
  String get playfulGarden => 'Razigrani vrt';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Algoritam retrogradne analize koristi viševrijednu retrogradnu analizu za izgradnju baze podataka o završnici s različitih početnih pozicija, a zatim primjenjuje tu bazu podataka za optimizaciju igranja. Ovaj pristup spada u kategoriju Ultra-Strong rješenja.';

  @override
  String get viewAlgorithmGuide =>
      'Želite li vidjeti korisnički priručnik za ovaj algoritam?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Prikaži indikator položajne prednosti';

  @override
  String get usePerfectDatabase => 'Koristi savršenu bazu podataka';

  @override
  String get perfectDatabaseDescription =>
      'Omogućite ovu opciju da koristite besprijekornu bazu podataka igara generiranu pomoću vrhunskih algoritama. Ova funkcija integrira i strategije otvaranja i završnice kako bi predložila optimalne poteze. Ovo je poželjan izbor za igrače koji traže najviši nivo preciznosti u igri. Kreirana kroz precizne računarske tehnike, baza podataka je dizajnirana da ponudi gotovo savršena rješenja za igre.\n\nNapomena: Ako AI ne uspije pristupiti bazi podataka, okrenut će se konvencionalnim algoritmima za donošenje odluka u igri. Kada je baza podataka dostupna, \'Nivo poteškoće\' postaje gotovo nepobjediv, a \'Vrijeme razmišljanja AI\' doživljava drastično smanjenje. Mnoga podešavanja unutar opcija \'AI\'s play style\' će biti poništena, jer rezultati baze podataka imaju najveći prioritet.\n\nZa upute o tome kako maksimalno iskoristiti ovu besprijekornu bazu podataka, kliknite ovdje.';

  @override
  String get backgroundImage => 'Pozadinska slika';

  @override
  String get whatIsRandom =>
      'Kada opcija \'Koristi savršenu bazu podataka\' nije omogućena, postavka \'Random\' uzrokuje da AI pomiče komade nasumično bez korištenja algoritama za odabir poteza. To obično rezultira znatno slabijim igranjem. Suprotno tome, kada je omogućeno \'Koristi savršenu bazu podataka\', AI se isključivo oslanja na \'Savršenu bazu podataka\' za donošenje odluka, umjesto da je miješa s tradicionalnim AI algoritmima. U ovom režimu, potezi veštačke inteligencije su u potpunosti zasnovani na sadržaju baze podataka, izbegavajući oslanjanje na proračune u realnom vremenu ili algoritme pretraživanja.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Uklonite protivničke figure iz njegove ruke; zatim je protivnik na redu da postavi figuru.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Kada se formiraju mlinovi tijekom faze postavljanja';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Uklonite protivničke figure s ploče.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Uklonite protivničku figure s ploče; zatim je protivnik na redu da postavi figuru.';

  @override
  String get opponentRemovesOwnPiece =>
      'Protivnik uklanja svoje figure s ploče.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Umjesto da vi poduzmete akciju, protivnik bira i uklanja svoje figure s ploče, čime poduzima akciju koja njemu šteti.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Uklonite protivničke figure iz njegove ruke; zatim ste vi na potezu.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Ukloni figure iz protivničke ruke. Ako prema postavci višestrukog uklanjanja treba ukloniti više figura, a protivnik nema više figura u ruci, nastavi uklanjati protivničke figure s ploče. Zatim si ti na potezu. Ako nastaviš formirati mlinove, možeš nastaviti uklanjati protivničke figure.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Ukloni figure iz protivničke ruke. Ako prema postavci višestrukog uklanjanja treba ukloniti više figura, a protivnik nema više figura u ruci, nastavi uklanjati protivničke figure s ploče. Zatim je protivnik na potezu.';

  @override
  String get markAndDelayRemovingPieces => 'Označi i odgodi uklanjanje figura.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Tijekom faze postavljanja, figure koje treba ukloniti se označavaju i nijedan jedan igrač ne može postaviti nove figure na ova mjesta. Po ulasku u fazu pomicanja, ove se označene figure potpuno uklanjaju, a igrači tada mogu svoje figure pomaknuti na ova sada prazna mjesta.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Radnje koje se mogu poduzeti prilikom formiranja mlinova u fazi postavljanja.';

  @override
  String get marked => 'Označeno';

  @override
  String get menu => 'Meni';

  @override
  String get monochrome => 'Jednobojno';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Možete uključiti podršku za čitač zaslona u postavkama pristupačnosti u „Opće postavke”.';

  @override
  String get showNumbersOnPieces => 'Prikaži brojeve na figurama';

  @override
  String get saveImage => 'Sačuvaj sliku';

  @override
  String get isAnalysisToolbarShown => 'Prikaži alatnu traku za analizu';

  @override
  String get analysisToolbarBackgroundColor => 'Boja pozadine trake za analizu';

  @override
  String get analysisToolbarIconColor => 'Boja ikone trake za analizu';

  @override
  String get transformed => 'Transform.';

  @override
  String get cannotTransform => 'Nije moguće transformirati.';

  @override
  String get rotate => 'Okreni';

  @override
  String get horizontalFlip => 'H okret.';

  @override
  String get verticalFlip => 'V okret.';

  @override
  String get innerOuterFlip => 'U/V okret.';

  @override
  String get transparentCanvas => 'Prozirno platno';

  @override
  String get restrictRepeatedMillsFormation =>
      'Ograniči ponavljano formiranje mlinova';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Figura koja se pomakne iz jednog mlina za formiranje jednog drugog mlina se ne može odmah vratiti na izvorno mjesto u sljedećem potezu kako bi ponovo formirala mlin. Najprije je mora odigrati jedan drugi potez.';

  @override
  String get oneTimeUseMill => 'Mlin za jednokratnu upotrebu';

  @override
  String get oneTimeUseMill_Detail =>
      'Svaki mlin može ukloniti samo jedan protivnički dio. Možete ga ponovno formirati, ali se ne može koristiti za dodatna uklanjanja.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Trenutačno postavljena pravila nemaju odgovarajuću savršenu bazu podataka. Za više informacija o savršenoj bazi podataka kliknite ovdje.';

  @override
  String get focusOnBlockingPaths => 'Prioriziraj blokiranje pomicanja';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Tijekom određenih faza igre prioriziraj ometanje protivnika u pomicanju figura umjesto formiranje mlinova. Umjesto da se usredotoči na uklanjanje figura sastavljanjem mlinova, UI nastoji uhvatiti protivnika u zamku, onemogućiti mu pomicanje figura i osigurati pobjedu iscrpljivanjem, a ne agresivnom igrom. Ova strategija ne blokira protivničke mlinove aktivno.';

  @override
  String get pieceImage => 'Slika figure';

  @override
  String get importColorSettings => 'Uvezi postavke boja';

  @override
  String get exportColorSettings => 'Izvezi postavke boja';

  @override
  String get import => 'Uvoz';

  @override
  String get export => 'Izvoz';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Molimo prvo kopirajte postavke JSON formata u međuspremnik.';

  @override
  String get copiedToClipboard => 'Kopirano u međuspremnik.';

  @override
  String get imported => 'Uvezeno.';

  @override
  String get boardImage => 'Slika ploče';

  @override
  String get autumnLeaves => 'Jesenje lišće';

  @override
  String get legendaryLand => 'Legendarna Zemlja';

  @override
  String get vignetteEffect => 'Vinjeta efekat';

  @override
  String get promptMakeToolbarTransparent =>
      'Želite li da alatna traka bude potpuno prozirna kada je postavljena pozadinska slika ploče?';

  @override
  String get vibration => 'Omogući vibraciju u igri';

  @override
  String get soundTheme => 'Zvučna tema';

  @override
  String get ball => 'Lopta';

  @override
  String get liquid => 'Tekućina';

  @override
  String get wood => 'Drvo';

  @override
  String get placeEffectAnimation => 'Animacijski efekt postavljanja figure';

  @override
  String get removeEffectAnimation => 'Animacijski efekt uklanjanja figure';

  @override
  String get isToolbarAtBottom => 'Prikaži alatnu traku na dnu';

  @override
  String get boardCornerRadius => 'Radijus ugla ploče';

  @override
  String get useOpeningBook => 'Koristite otvaranje knjige';

  @override
  String get currentRule => 'Trenutno';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Set pravila';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'One-Time Mill';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'Dopustite AI-u da koristi početne poteze koje često koriste profesionalni ljudski igrači u ranim fazama igre. Napomena: Ova funkcija trenutno je dostupna samo za određene setove pravila.';

  @override
  String get showAdvantageGraph => 'Prikaži grafikon prednosti';

  @override
  String get advantageGraphHint =>
      'Graf prednosti će biti iscrtan samo nakon što AI povuče potez. Neće biti iscrtan kada ljudski igrač povuče potez.';

  @override
  String get removalBasedOnMillCounts =>
      'Onemogućite uklanjanje dok svi dijelovi nisu postavljeni. Igrači uklanjaju dijelove na osnovu broja mlinova.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Onemogućite uklanjanje dok svi dijelovi nisu postavljeni. Igrači uklanjaju dijelove na osnovu broja mlinova: ako je broj jednak, oba uklanjaju isti broj dijelova; ako jedan ima više, uklanja dodatni dio i održava razliku od jednog dijela. Ako samo jedan formira mlin, uklanja dva dijela, a drugi uklanja jedan. Ako nijedan ne formira mlin, oba uklanjaju po jedan dio.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Odaberite jednu od svojih figura.';

  @override
  String get notYourTurn => 'Nije tvoj potez.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Boja pozadine alatne trake za bilješke';

  @override
  String get annotationToolbarIconColor =>
      'Boja ikone alatne trake za bilješke';

  @override
  String get isAnnotationToolbarShown => 'Prikaži alatnu traku za bilješke';

  @override
  String get enterAnnotationMode => 'Uđi u režim bilješki';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Da li si siguran da želiš obrisati sve bilješke?';

  @override
  String get llmPromptCopiedToClipboard =>
      'LLM upit je kopiran u međuspremnik.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Veza je odbijena, server možda nije dostupan.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Otkrivanje uspješno, čeka se veza...';

  @override
  String get noLanConnection => 'Nema LAN veze';

  @override
  String get takeScreenshot => 'Napravite snimak ekrana';

  @override
  String get disconnectedFromOpponent => 'Veza s protivnikom je prekinuta.';

  @override
  String get takeBackRequest => 'Zahtjev za vraćanje poteza';

  @override
  String get nothingToShow => 'Ništa za prikaz.';

  @override
  String get stopHosting => 'Prekini hostovanje';

  @override
  String get connectionResetByPeer =>
      'Veza je resetovana od strane druge strane.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Veza je izgubljena zbog isteka vremena za heartbeat. Molimo, ponovo se poveži.';

  @override
  String get startHosting => 'Započni hostovanje';

  @override
  String get restartRequestRejected =>
      'Zahtjev za ponovno pokretanje je odbijen.';

  @override
  String get notConnectedToLanOpponent => 'Nisi povezan s LAN protivnikom.';

  @override
  String get llmPrompt => 'LLM upit';

  @override
  String get gameRestarted => 'Igra je ponovo pokrenuta.';

  @override
  String get takeBackRejected => 'Vraćanje poteza je odbijeno.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Da li si siguran da želiš da se predaš u ovoj igri?';

  @override
  String get opponentResignedYouWin => 'Protivnik se predao. Pobeđuješ!';

  @override
  String get clearAllAnnotations => 'Obriši sve bilješke';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Povezano, čeka se potez protivnika...';

  @override
  String get networkStatusDisconnected => 'Status mreže: Veza prekinuta';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Zahtjev za vraćanje poteza poslan je protivniku.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'Protivnik je možda napustio igru';

  @override
  String get connectedToHostSuccessfully => 'Uspješno si povezan s domaćinom.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Veza izgubljena: istekao je vremenski rok za heartbeat.';

  @override
  String get noHostDiscovered => 'Nije pronađen nijedan domaćin.';

  @override
  String get confirmResignation => 'Potvrdi predaju';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Hostovanje igre je započelo, čeka se da se igrači pridruže...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Veza je istekla, mrežna veza je nestabilna.';

  @override
  String get noLlmPromptAvailable => 'Nema dostupnog LLM upita.';

  @override
  String get youResignedGameOver => 'Predao si se. Igra je završena.';

  @override
  String get serverIp => 'IP adresa servera';

  @override
  String get confirmClear => 'Potvrdi brisanje';

  @override
  String get opponentSTurn => 'Protivnikov potez.';

  @override
  String get waitingAClientConnection => 'Čeka se konekcija klijenta...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Zahtjev za vraćanje poteza je odbijen ili nije uspio.';

  @override
  String get addText => 'Dodaj tekst';

  @override
  String get exitAnnotationMode => 'Izađi iz režima bilješki';

  @override
  String get typeYourAnnotation => 'Unesi svoju bilješku';

  @override
  String get attemptingToReconnect => 'Pokušava se ponovo povezati...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Zahtjev za ponovno pokretanje poslan je. Čeka se odgovor protivnika...';

  @override
  String get serverIsStopped => 'Server je zaustavljen.';

  @override
  String get restartRequest => 'Zahtjev za ponovno pokretanje';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Ne možeš zatražiti vraćanje poteza kada nije tvoj potez.';

  @override
  String get takeBackAccepted => 'Vraćanje poteza je prihvaćeno.';

  @override
  String get localNetworkSettings => 'Postavke lokalne mreže';

  @override
  String get reconnectedSuccessfully => 'Uspješno si ponovo povezan!';

  @override
  String get failedToSaveImageToGallery =>
      'Spremanje slike u galeriju nije uspjelo.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Protivnik je zatražio ponovno pokretanje igre. Prihvaćaš li?';

  @override
  String get yourTurn => 'Tvoj potez.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Nije moguće ponovo se povezati, molim te ponovo pokreni igru.';

  @override
  String get host => 'Domaćin';

  @override
  String get join => 'Pridruži se';

  @override
  String get port => 'Port';

  @override
  String get invalidIpAddress => 'Nevažeća IP adresa.';

  @override
  String get invalidPort => 'Nevažeći port.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Povezivanje: pokušaj $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Povezivanje nije uspjelo: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Pokretanje hostovanja nije uspjelo: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Pronađen domaćin: $ip:$port';
  }

  @override
  String get stop => 'Zaustavi';

  @override
  String get discover => 'Otkrij';

  @override
  String get connect => 'Poveži se';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Klijent se povezao: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Otkrivanje: $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Pokušavam se ponovo povezati ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Povezano';

  @override
  String get delete => 'Izbriši';

  @override
  String get ancientEgypt => 'Drevni Egipat';

  @override
  String get gothicIce => 'Gotski Led';

  @override
  String get riceField => 'Rižino Polje';

  @override
  String get chinesePorcelain => 'Kineski Porculan';

  @override
  String get desertDusk => 'Pustinjski Sumrak';

  @override
  String get precisionCraft => 'Precizna Zanat';

  @override
  String get folkEmbroidery => 'Narodni Vez';

  @override
  String get carpathianHeritage => 'Karpatsko Naslijeđe';

  @override
  String get imperialGrandeur => 'Carigradska Veličina';

  @override
  String get bohemianCrystal => 'Boemski Kristal';

  @override
  String get savannaSunrise => 'Savanski Izlazak Sunca';

  @override
  String get harmonyBalance => 'Harmonija Ravnoteža';

  @override
  String get cinnamonSpice => 'Cimet Začin';

  @override
  String get anatolianMosaic => 'Anatolijski Mozaik';

  @override
  String get carnivalSpirit => 'Karnevalski Duh';

  @override
  String get custom => 'Običaj';

  @override
  String get spiceMarket => 'Tržnica začina';

  @override
  String get swipeToRevealTheDrawer => 'Prevucite da otkrijete ladicu';

  @override
  String get showGameInfoOnScreenshots =>
      'Prikaži informacije o igri na snimkama ekrana';

  @override
  String get humanMoveTime => 'Vremensko ograničenje za ljudski potez';

  @override
  String get noTimeLimitForHumanMoves =>
      'Nema vremenskog ograničenja za ljudske poteze';

  @override
  String get timeoutLoseWillBeApplied =>
      'Gubitak zbog isteka vremena će biti primijenjen za ljudskog igrača';

  @override
  String get identifyingBoard => 'Prepoznavanje table...';

  @override
  String get youCanEnterAnyModelName => 'Možete unijeti bilo koji naziv modela';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Pozicija table primijenjena. FEN je kopiran u međuspremnik.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Prijedlog: pokušajte napraviti jasniju fotografiju table';

  @override
  String get llmPromptTemplate => 'Predložak upita za LLM';

  @override
  String get noValidBoardDetected => 'Nije detektovana važeća tabla';

  @override
  String get selectingImageFromAlbum => 'Odabir slike iz albuma...';

  @override
  String get configurePromptTemplate => 'Konfiguriši predložak upita';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Uredi predložak upita za LLM analizu';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Neuspjelo generisanje FEN-a iz prepoznate table';

  @override
  String get outputInCurrentLanguage => 'Izlaz na trenutnom jeziku';

  @override
  String get commonBaseUrls => 'Uobičajeni Base URL-ovi';

  @override
  String get viewCommonModels => 'Prikaži uobičajene modele';

  @override
  String get recognitionParametersUpdated =>
      'Parametri prepoznavanja ažurirani';

  @override
  String get whiteSMove => 'Na potezu je bijeli';

  @override
  String get resetToDefaults => 'Vrati na zadane postavke';

  @override
  String get photoShoot => 'Fotografisanje';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Neuspjelo primjenjivanje prepoznate pozicije table';

  @override
  String get llmPromptContent => 'Sadržaj upita za LLM';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM nije konfigurisan. Molimo provjerite postavke.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Postavite davatelja, model, API Key i Base URL';

  @override
  String get llmConfiguration => 'Konfiguracija LLM-a';

  @override
  String get configureLlmProvider => 'Konfigurirajte davatelja LLM-a';

  @override
  String get llmPromptTemplateHeader => 'Zaglavlje predloška upita za LLM';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Nijedna figura nije prepoznata na slici. Molimo pokušajte ponovo.';

  @override
  String get recognizeBoardFromImage => 'Prepoznaj tablu sa slike';

  @override
  String get viewTips => 'Prikaži savjete';

  @override
  String get applyToBoard => 'Primijeni na tablu';

  @override
  String get adjustBoardArea => 'Prilagodi područje table';

  @override
  String get viewCommonUrls => 'Prikaži uobičajene URL-ove';

  @override
  String get colorAnalysisFailed => 'Analiza boja nije uspjela!';

  @override
  String get analyzingGameBoardImage => 'Analiziranje slike table...';

  @override
  String get selectFromAlbum => 'Odaberi iz albuma';

  @override
  String get noBoardPointDetected => 'Nijedna tačka table nije detektovana!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Ako ostane prazno, koristiće se zadani predložak';

  @override
  String get llmConfig => 'Konfiguracija LLM-a';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Jeste li sigurni da želite vratiti predloške upita na zadane vrijednosti?';

  @override
  String get llmPromptTemplateFooter => 'Podnožje predloška upita za LLM';

  @override
  String get loadingResponse => 'Učitavanje odgovora...';

  @override
  String get applyThisResultToBoard => 'Primijeni ovaj rezultat na tablu';

  @override
  String get takingPicture => 'Fotografisanje...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Molimo odaberite sliku table za prepoznavanje';

  @override
  String get identificationResults => 'Rezultati prepoznavanja';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Analizirajte poteze i pružite uvide.';

  @override
  String get getApiKey => 'Nabavite API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Cijeli proces prepoznavanja nije dovršen';

  @override
  String get boardRecognitionResult => 'Rezultat prepoznavanja table';

  @override
  String get askLlm => 'Pitaj LLM';

  @override
  String get boardDetectionFailed => 'Detekcija table nije uspjela!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Nijedna tačka table nije detektovana, nije moguće prepoznati figuru!';

  @override
  String get copyFen => 'Kopiraj FEN';

  @override
  String get commonlyUsedModels => 'Modeli koji se često koriste';

  @override
  String get apiKeyOptional => 'API Key (neobavezno)';

  @override
  String get noImageSelected => 'Nije odabrana nijedna slika';

  @override
  String get blackSMove => 'Na potezu je crni';

  @override
  String get llm => 'Veliki jezični model';

  @override
  String get llmProvider => 'Pružatelj';

  @override
  String get baseUrl => 'Osnovni URL';

  @override
  String get model => 'Model';

  @override
  String get temperature => 'Temperatura';

  @override
  String get llmCommandReceivedProcessing =>
      'Naredba primljena! AI obrađuje...';

  @override
  String get llmDeepThinkingWait =>
      'Duboko razmišljanje u toku, molimo pričekajte...';

  @override
  String get llmPresentingSoon => 'Uskoro prikazujemo...';

  @override
  String get recognitionParameters => 'Parametri prepoznavanja';

  @override
  String get adjustParamsDesc =>
      'Prilagodite parametre za poboljšanje tačnosti prepoznavanja';

  @override
  String get saveParameters => 'Sačuvaj parametre';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Nije moguće pokrenuti prepoznavanje slike: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Prepoznavanje slike nije uspjelo: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Primijenjena pozicija sa $whiteCount bijelih i $blackCount crnih figura';
  }

  @override
  String get fenCopiedToClipboard => '(FEN kopiran u međuspremnik)';

  @override
  String recognitionFailed(String error) {
    return 'Prepoznavanje nije uspjelo: $error';
  }

  @override
  String get myRating => 'Moj rejting';

  @override
  String get gamesPlayed => 'Odigrane igre';

  @override
  String get wins => 'Pobjede';

  @override
  String get losses => 'Porazi';

  @override
  String get draws => 'Neriješeno';

  @override
  String get lastUpdated => 'Posljednje ažuriranje';

  @override
  String get format => 'Format:';

  @override
  String get resetStatistics => 'Resetuj statistiku';

  @override
  String get drawRate => 'Stopa neriješenih';

  @override
  String get lossRate => 'Stopa poraza';

  @override
  String get aiStatistics => 'AI statistika';

  @override
  String get enableStatistics => 'Omogući statistiku';

  @override
  String get enableStatistics_Detail =>
      'Kada je omogućeno, rezultati igre će biti zabilježeni u statistici. Međutim, igre koje uključuju vraćanje poteza neće biti zabilježene. Kada je onemogućeno, prikupljanje statistike je pauzirano.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Ovo će resetovati svu statistiku igre. Ova radnja se ne može poništiti.';

  @override
  String get boardInnerRingSize => 'Veličina unutarnog prstena ploče';

  @override
  String get boardShadowEnabled => 'Sjenka ploče';

  @override
  String get trapAwareness => 'Prepoznavanje zamki';

  @override
  String get trapAwarenessDescription =>
      'Istakni poteze zamke podebljanim krugovima i strelicama tokom analize.';

  @override
  String trapExists(String trapMoves) {
    return 'Postoji zamka. Potezi zamke: $trapMoves';
  }

  @override
  String get custodianCapture => 'Flankeng Capture';

  @override
  String get custodianCaptureDescription =>
      'Obratite jedan od svojih protivničkih komada između vas dvoje u pravoj liniji da biste je uhvatili.';

  @override
  String get custodianCaptureEnable => 'Dopustite da se bočno snimanje';

  @override
  String get interventionCapture => 'Intervencija snimanje';

  @override
  String get interventionCaptureDescription =>
      'Pomaknite se u praznu točku između dva od vaših protivničkih komada da ih snimite oboje.';

  @override
  String get interventionCaptureEnable => 'Omogućite snimanje intervencije';

  @override
  String get leapCapture => 'Snimanje';

  @override
  String get leapCaptureDescription =>
      'Snimite preskakanje preko susednog protivničkog komada u praznu točku izvan.';

  @override
  String get leapCaptureEnable => 'Dopustite snimanje za snimanje';

  @override
  String get captureApplicableLines => 'Primjenjive linije';

  @override
  String get captureSquareEdges => 'Duž ivica kvadrata';

  @override
  String get captureCrossLines =>
      'Duž ortogonalnih linija koji prelaze kvadrat';

  @override
  String get captureDiagonalLines =>
      'Duž dijagonalnih linija koji prelaze kvadrat';

  @override
  String get captureExecutionPhases => 'Faze izvršenja';

  @override
  String get capturePiecesCondition =>
      'Dostupnost tokom pokretne faze na osnovu preostalih komada';

  @override
  String get capturePiecesConditionUnlimited => 'Nema ograničenja';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Dostupno kada imate tri ili manje komada';
}
