// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Tibetan (`bo`).
class SBo extends S {
  SBo([String locale = 'bo']) : super(locale);

  @override
  String get appName => 'ཅོ་འགྲིག';

  @override
  String get welcome => 'དགའ་བསུ་ཞུ།';

  @override
  String get yes => 'རེད།';

  @override
  String get no => 'མ་རེད།';

  @override
  String get game => 'རྩེད་མོ།';

  @override
  String get humanVsAi => 'མི་དང་ AI བར་འགྲན་བསྡུར།';

  @override
  String get humanVsHuman => 'མི་དང་མི་བར་འགྲན་བསྡུར།';

  @override
  String get aiVsAi => 'AI དང་ AI བར་འགྲན་བསྡུར།';

  @override
  String get humanVsCloud => 'མི་དང་སྤྲིན་བར་འགྲན་བསྡུར།';

  @override
  String get humanVsLAN => 'མི་དང་ LAN བར་འགྲན་བསྡུར།';

  @override
  String get testViaLAN => 'LAN བརྒྱུད་ཚོད་ལྟ།';

  @override
  String get move => 'སྤོ་འགུལ།';

  @override
  String get showMoveList => 'སྤོ་འགུལ་གྱི་ཐོ་གཞུང།';

  @override
  String get moveList => 'སྤོ་འགུལ་གྱི་ཐོ་གཞུང།';

  @override
  String get noGameRecord => 'ཟིན་ཐོ་མེད།';

  @override
  String get ok => 'ཆོག';

  @override
  String get confirm => 'བདེན་དཔང';

  @override
  String get cancel => 'འདོར་བ';

  @override
  String get tipSelectWrong => 'ནོར་འཁྲུལ་ཅན་འདེམས།';

  @override
  String get tipPlace => 'ཁྱེད་རང་གི་དུམ་བུ་དེ་བཞག་རོགས།';

  @override
  String get tipBanPlace => 'ཁྱོད་ཀྱིས་འདིར་འཇོག་མི་ཐུབ།';

  @override
  String get tipPlaced => 'ཁྱོད་ཀྱིས་བཞག་ཡོད།';

  @override
  String get tipRemove => 'དུམ་བུ་ཞིག་བཏོན་དགོས།';

  @override
  String get tipBanRemove => 'ཁྱོད་ཀྱིས་དེ་མེད་པར་བཟོ་མི་ཐུབ།';

  @override
  String get tipRemoved => 'ཁྱོད་ཀྱིས་མེད་པར་བཟོས།';

  @override
  String get tipMove => 'དུམ་བུ་ཞིག་སྤོ་རོགས།';

  @override
  String get tipCannotPlace => 'ཁྱེད་རང་གི་རྡེའུ་འདིར་འཇོག་མི་ཆོག';

  @override
  String get tipCannotMove => 'ཁྱེད་རང་གི་རྡེའུ་འདིར་སྤོ་མི་ཆོག';

  @override
  String get tipMill => 'རྫོང་བཙུགས་འདུག ཁྱེད་རང་གིས་ཁ་གཏད་ཀྱི་རྡེའུ་ལེན་ཆོག';

  @override
  String get tipContinueMill => 'ཁ་གཏད་ཀྱི་རྡེའུ་མུ་མཐུད་ལེན་པར་མཐུད་རྒྱུ།';

  @override
  String get tipSelectOpponentsPiece => 'ཁ་གཏད་ཀྱི་རྡེའུ་གཅིག་འདེམས་རོགས།';

  @override
  String get tipCannotRemovePieceFromMill => 'རྫོང་ནང་གི་རྡེའུ་ལེན་མི་ཆོག';

  @override
  String get tipCanMoveOnePoint => 'རྡེའུ་རེ་ས་ཚིགས་གཅིག་ལ་སྤོ་ཐུབ།';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'ཁྱེད་རང་གིས་ཁ་གཏད་ཀྱི་རྡེའུ་སྤོ་མི་ཆོག';

  @override
  String get tipSelectPieceToMove => 'སྤོ་འགུལ་གཏོང་དགོས་པའི་རྡེའུ་འདེམས་རོགས།';

  @override
  String get tipHaveThreePiecesLeft => 'ཁྱེད་རང་ལ་རྡེའུ་གསུམ་ལྷག་འདུག';

  @override
  String get tipCanMoveToAnyPoint =>
      'ཁྱེད་རང་གིས་རྡེའུ་རང་འདོད་ཀྱི་ས་ཚིགས་གང་རུང་ལ་སྤོ་ཐུབ།';

  @override
  String tipToMove(Object player) {
    return '$player སྤོ་འགུལ་བྱེད་རོགས།';
  }

  @override
  String get whiteWin => 'རྩེད་འགྲན་པ་ 1 རྒྱལ་ཁ་ཐོབ་པ།';

  @override
  String get blackWin => 'རྩེད་འགྲན་པ་ 2 རྒྱལ་ཁ་ཐོབ་པ།';

  @override
  String get won => 'རྒྱལ་ཁ་ཐོབ་པ།';

  @override
  String get lost => 'ཕམ་པ།';

  @override
  String get thinking => 'བསམ་བློ་བཏང་བཞིན་པ།';

  @override
  String get newGame => 'རྩེད་མོ་གསར་པ།';

  @override
  String get importGame => 'རྩེད་མོ་ནང་འདྲེན་པ།';

  @override
  String get exportGame => 'རྩེད་མོ་ཕྱིར་འདྲེན་པ།';

  @override
  String get gameImported => 'རྩེད་མོ་ནང་འདྲེན་བྱས་ཚར་པ།';

  @override
  String cannotImport(Object invalidMove) {
    return 'ནང་འདྲེན་བྱེད་མི་ཐུབ། $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'སྤོ་ཐབས་དང་སྒྲིག་གཞི་མི་མཐུན་པ།';

  @override
  String get pleaseWait => 'སྒུག་རོགས།';

  @override
  String get restartGame => 'ད་ལྟའི་རྩེད་མོ་དེ་བསྐྱར་དུ་འགོ་འཛུགས་དགོས་སམ།';

  @override
  String get restart => 'ཡང་བསྐྱར་འགོ་བཙུགས་པ།';

  @override
  String get gameStarted => 'རྩེད་མོ་འགོ་ཚུགས་སོང་། གནས་སྤོས།';

  @override
  String get analyzing => 'དབྱེ་ཞིབ་བྱེད་བཞིན་པ།';

  @override
  String error(Object message) {
    return 'ནོར་འཁྲུལ། $message';
  }

  @override
  String get winRate => 'རྒྱལ་ཁའི་བརྒྱ་ཆ།';

  @override
  String get score => 'ཐོབ་གྲངས:';

  @override
  String get white => 'རྩེད་འགྲན་པ་ 1';

  @override
  String get black => 'རྩེད་འགྲན་པ་ 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player རྡེལ་གྲངས་གསུམ་ལས་ཉུང་།';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player བསྐྱུར་བ།';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player འགྲོ་ས་མེད།';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'རྩེད་པང་ཁེངས་ཟིན་པ་དང་། $player འགྲོ་ས་མེད།';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'དུས་ཚོད་རྫོགས་སོ། $player ཕམ་པ།';
  }

  @override
  String get drawReasonRule50 =>
      'སྤོ་འགུལ་དུས་རིམ་ཁྲོད། རྡེལ་གང་ཡང་འདས་པའི་གཏན་འཁེལ་གྲངས་ཀའི་སྤོ་འགུལ་ནང་བསུབས་མེད།';

  @override
  String get drawReasonBoardIsFull =>
      'འདི་ནི་གྲུབ་འབྲས་མཉམ་པ་ཞིག་ཡིན་ཏེ། རྩེད་པང་ཁེངས་ཟིན་པའི་རྒྱུ་མཚན་གྱིས།';

  @override
  String get drawReasonThreefoldRepetition =>
      'འདི་ནི་གྲུབ་འབྲས་མཉམ་པ་ཞིག་ཡིན། རྒྱུ་མཚན་ནི་ཐེངས་གསུམ་བསྐྱར་ཟློས་བྱས་པའོ།';

  @override
  String get gameOverUnknownReason => 'རྩེད་མོ་རྫོགས་སོ།! རྒྱུ་མཚན་མི་ཤེས།';

  @override
  String get gameOver => 'རྩེད་མོ་རྫོགས་སོ།';

  @override
  String get youWin => 'ཁྱོད་ཀྱིས་རྒྱལ་ཁ་ཐོབ་པ་ཡིན།! བཀྲ་ཤིས་བདེ་ལེགས།';

  @override
  String challengeHarderLevel(int level) {
    return 'དཀའ་ཚད་མཐོ་བའི་རིམ་པར་འགྲན་སློང་བྱེད་པ། རིམ་པ་གསར་པ་ནི་ $level རིམ་པ་ཡིན།';
  }

  @override
  String get youLose => 'ཁྱོད་ཕམ་པ།';

  @override
  String get analyze => 'དབྱེ་ཞིབ།';

  @override
  String get about => 'སྐོར།';

  @override
  String version(Object versionNumber) {
    return 'ཐོན་རིམ། $versionNumber';
  }

  @override
  String get thanks => 'ཐུགས་རྗེ་ཆེ།';

  @override
  String get settings => 'འཛུགས་པ';

  @override
  String get options => 'གདམ་ག།';

  @override
  String get generalSettings => 'སྤྱིར་བཏང་སྒྲིག་སྟངས།';

  @override
  String get skillLevel => 'དཀའ་ཚད་ཀྱི་རིམ་པ།';

  @override
  String get moveTime => 'AI བསམ་བློའི་དུས་ཚོད།';

  @override
  String get difficulty => 'དཀའ་ཚད།';

  @override
  String get playSounds => 'སྒྲ་སྐད་ཀྱི་ནུས་པ།';

  @override
  String get playSoundsInTheGame => 'རྩེད་མོའི་ནང་སྒྲ་སྐད་གཏོང་བ།';

  @override
  String get keepMuteWhenTakingBack => 'ཕྱིར་ལེན་སྐབས་སྒྲ་མེད་ཉར་བ།';

  @override
  String get tone => 'སྒྲ་གདངས།';

  @override
  String get whoMovesFirst => 'སྔོན་འགུལ།';

  @override
  String get human => 'མི།';

  @override
  String get ai => 'AI';

  @override
  String get alternate => 'འཁོར་སྤྱོད།';

  @override
  String get isAutoRestart =>
      'རྩེད་མོ་མཇུག་སྒྲིལ་སྐབས་རང་འགུལ་ངང་ཡང་བསྐྱར་འགོ་བཙུགས།';

  @override
  String get isAutoChangeFirstMove => 'སྔོན་འགུལ་རང་འགུལ་ངང་བརྗེ་པོ་བྱེད།';

  @override
  String get shufflingEnabled => 'སྣ་ཚོགས་སྤོ་འགུལ།';

  @override
  String get misc => 'གཞན་པ།';

  @override
  String get rules => 'སྒྲིག་གཞི།';

  @override
  String get piecesCount => 'རྩེད་འགྲན་པ་རེའི་རྡེལ་གྲངས་ཀ';

  @override
  String get piecesCount_Detail => 'རྩེད་འགྲན་པ་རེ་རེར་རྡེལ་ག་ཚོད་ཡོད།';

  @override
  String get flyPieceCount => 'འཕུར་རྡེལ་གྱི་གྲངས་འབོར།';

  @override
  String get flyPieceCount_Detail =>
      'གལ་ཏེ་འཕུར་རྒྱུག་ཆོག་པའི་སྐབས་སུ། རྩེད་འགྲན་པ་གཅིག་གི་རྡེལ་གྲངས་གཏན་འཁེལ་གྱི་གྲངས་འབོར་ཞིག་ཏུ་ཉུང་དུ་ཕྱིན་ཚེ། ཁོ་མོའི་རྡེལ་རྣམས་རྩེད་མོའི་རིང་གི་དུས་མཚམས་གཞན་དག་ཏུ་མཐའ་འཁོར་གྱི་ས་ཚིགས་ཁོ་ནར་སྤོ་འགུལ་བྱེད་ཆོག་པའི་ཚོད་འཛིན་གྱི་འོག་ཏུ་མེད་པར་ས་ཚིགས་སྟོང་པ་གང་རུང་དུ་སྤོ་འགུལ་བྱེད་ཆོག་པ་ཡིན།';

  @override
  String get piecesAtLeastCount => 'ཉུང་མཐའི་རྡེལ་གྲངས་';

  @override
  String get hasDiagonalLines => 'གསེག་ཐིག';

  @override
  String get hasDiagonalLines_Detail =>
      'རྩེད་པང་དུ་བཞི་གསེག་ཐིག་ཁ་སྣོན་རྒྱག་པ།';

  @override
  String get isDefenderMoveFirst => 'རྩེད་འགྲན་པ་གཉིས་པ་སྔོན་འགུལ་བྱེད།';

  @override
  String get isDefenderMoveFirst_Detail =>
      'འཇོག་རིམ་ནང་གཉིས་པར་འགུལ་བ་རྩེད་འགྲན་པ་ནི་སྤོ་འགུལ་དུས་རིམ་ནང་སྔོན་འགུལ་བྱེད་མཁན་ཡིན།';

  @override
  String get mayRemoveMultiple => 'མང་བསུབ།';

  @override
  String get mayRemoveMultiple_Detail =>
      'གལ་ཏེ་རྩེད་འགྲན་པ་ཞིག་གིས་ཐེངས་གཅིག་ལ་གསུམ་ལས་མང་བ་ཁ་རྒྱག་ན་ཁོ་མོས་ཁ་རྒྱག་པའི་གསུམ་གྱི་ཨང་གྲངས་དེ་མེད་པར་བཟོ་ཐུབ།';

  @override
  String get mayRemoveFromMillsAlways => 'གསུམ་གཏོར་བ།';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'སྔོན་སྒྲིག་གི་རྣམ་པར་གཞིགས་ན། རྩེད་འགྲན་པ་རྣམས་ཀྱིས་གྲུབ་ཟིན་པའི་ གསུམ ནས་རྡེལ་གཅིག་བསུབ་སྔོན་དུ་རྡེལ་གཞན་དག་བསུབ་དགོས། ཚོད་འཛིན་འདི་ལས་ཐར་བའི་ཆེད་དུ་འདེམས་གཞི་འདི་ཤུགས་ལྡན་བཟོ།';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'རྩེད་པང་ཁེངས་དུས་རྩེད་འགྲན་པ་གཉིས་པ་ཕམ་པ།';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'འཇོག་རིམ་གྱི་མཇུག་ཏུ་རྩེད་པང་ཁེངས་ཚེ། སྔོན་ལ་འཇོག་མཁན་ཕྱོགས་ཀྱིས་རྩེད་མོ་ཕམ་པ། གལ་ཏེ་དེ་མིན་ཚེ། རྩེད་མོ་འདི་ནི་གྲུབ་འབྲས་མཉམ་པ་ཡིན།';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'ཁྲིམས་མཐུན་གྱི་སྤོ་འགུལ་མེད་པའི་སྐབས་ཕམ་པ།';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'གལ་ཏེ་ཁོའི་འགྲན་ཟླས་ཁོ་ལ་འགོག་རྐྱེན་བཟོས་ཏེ་ཁོ་ལ་སྤོ་འགུལ་མི་ཐུབ་པའི་སྐབས་སུ། རྩེད་འགྲན་པ་ཕམ་པར་འགྱུར། གལ་ཏེ་འདེམས་གཞི་འདི་ཤུགས་མེད་དུ་བཏང་ན་སྤོ་འགུལ་ཕྱོགས་བརྗེ།';

  @override
  String get mayFly => 'འཕུར་བསྐྱོད།';

  @override
  String get mayFly_Detail =>
      'གལ་ཏེ་རྩེད་འགྲན་པ་གཅིག་ལ་རྡེལ་གསུམ་མ་གཏོགས་མེད་ཚེ(སྒྲིག་སྦྱོར་བྱེད་རུང་)། ཁོ་མོས་རྡེལ་དེ་རང་དབང་གི་ས་ཚིགས་གང་རུང་དུ་སྤོ་བ་གནང་ཆོག';

  @override
  String get nMoveRule => 'N-སྤོ་འགུལ་སྒྲིག་གཞི།';

  @override
  String get nMoveRule_Detail =>
      'གལ་ཏེ་གཏན་འཁེལ་གྲངས་ཀའི་སྤོ་འགུལ་ནང་བསུབ་མེད་ཚེ། རྩེད་མོ་འདི་ནི་གྲུབ་འབྲས་མཉམ་པ་ཡིན།';

  @override
  String get rollback => 'ཕྱིར་ལོག';

  @override
  String get pleaseSelect => 'འདེམས་རོགས་གནང་།';

  @override
  String get copy => 'འདྲ་བཤུས།';

  @override
  String get moveHistoryCopied =>
      'སྤོ་འགུལ་ལོ་རྒྱུས་པང་ལེབ་གསོག་སྡེར་དུ་འདྲ་བཤུས་བྱས་ཟིན།';

  @override
  String get help => 'རོགས་རམ';

  @override
  String get feedback => 'ཡ་ལན';

  @override
  String get exit => 'ཐོན་སྒོ';

  @override
  String get ruleSettings => 'སྒྲིག་གཞི་སྒྲིག་སྟངས།';

  @override
  String get color => 'ཚོས།';

  @override
  String get boardColor => 'རྩེད་པང་གི་ཚོས།';

  @override
  String get pieceColor => 'རྡེལ་གྱི་ཚོས།';

  @override
  String get backgroundColor => 'རྒྱབ་ལྗོངས་ཀྱི་ཚོས།';

  @override
  String get lineColor => 'རྩེད་པང་ཐིག་གི་ཚོས།';

  @override
  String get whitePieceColor => 'རྩེད་འགྲན་པ་ 1 གྱི་རྡེལ་གྱི་ཚོས།';

  @override
  String get blackPieceColor => 'རྩེད་འགྲན་པ་ 2 གྱི་རྡེལ་གྱི་ཚོས།';

  @override
  String get messageColor => 'འཕྲིན་ཐུང་གི་ཚོས།';

  @override
  String get isPieceCountInHandShown => 'འཇོག་མེད་རྡེལ་གྱི་གྲངས་འབོར་སྟོན།';

  @override
  String get isNotationsShown => 'རྩེད་པང་ཐོག་མཆན་འགྲེལ་སྟོན།';

  @override
  String get isHistoryNavigationToolbarShown =>
      'ལོ་རྒྱུས་འགྲུལ་བསྐྱོད་ལག་ཆས་ཚང་སྟོན།';

  @override
  String get display => 'མངོན་པ།';

  @override
  String get boardBorderLineWidth => 'རྩེད་པང་མཐའ་མཚམས་ཐིག་གི་ཞེང་ཚད།';

  @override
  String get boardInnerLineWidth => 'རྩེད་པང་ནང་ཐིག་གི་ཞེང་ཚད།';

  @override
  String get pieceWidth => 'རྡེལ་གྱི་ཞེང་ཚད།';

  @override
  String get fontSize => 'ཡིག་གཟུགས་ཀྱི་ཆེ་ཆུང་།';

  @override
  String get standardNotation => 'ཚད་ལྡན་གྱི་མཚོན་རྟགས།';

  @override
  String get restore => 'སླར་གསོ།';

  @override
  String get restoreDefaultSettings => 'སྔོན་སྒྲིག་སྒྲིག་སྟངས་སླར་གསོ་བྱེད་པ།';

  @override
  String pick(Object element) {
    return '$element འདེམས་པ།';
  }

  @override
  String get info => 'གནས་ཚུལ།';

  @override
  String get hint => 'བརྡ་སྟོན།';

  @override
  String get player => 'རྩེད་འགྲན་པ།';

  @override
  String get player1 => 'རྩེད་འགྲན་པ་ 1';

  @override
  String get player2 => 'རྩེད་འགྲན་པ་ 2';

  @override
  String get howToPlay => 'རྩེད་སྟངས།';

  @override
  String get toPlacePiece =>
      'རྡེལ་འཇོག་ཆོག་པའི་ས་ཚིགས་གང་རུང་ཞིག་ལ་རྡེལ་འཇོག་ཆོག';

  @override
  String get toSelectPiece => 'རྡེལ་ཞིག་ལ་རྡེལ་སྤོ་བའི་ཆེད་དུ་རེག';

  @override
  String get toMovePiece => 'རྡེལ་ཞིག་དང་སྦྲེལ་བའི་ས་ཚིགས་ཤིག་ལ་རེག་ནས་སྤོ་བ།';

  @override
  String get toRemovePiece => 'ཁ་གཏད་རྩེད་འགྲན་པའི་རྡེལ་གཅིག་ལ་རེག་ནས་བསུབ་པ།';

  @override
  String get needToCreateMillFirst =>
      'ཁྱེད་རང་གིས་དངོས་པོ་གཅིག་བཏོན་མ་ཐག དང་པོ་གསུམ་བཟོ་དགོས།';

  @override
  String get needToPlayWithOwnPieces =>
      'ཁྱོད་ཀྱིས་རང་ཉིད་ཀྱི་རྡེལ་བེད་སྤྱད་ནས་རྩེ་བ།';

  @override
  String get statistics => 'བསྡོམས་རྩིས།';

  @override
  String get totalGames => 'རྩེད་མོའི་བསྡོམས་འབོར།';

  @override
  String get results => 'གྲུབ་འབྲས།';

  @override
  String get left => 'ལྷག་པ།';

  @override
  String get privacyPolicy => 'སྒེར་གྱི་གསང་དོན་སྲིད་ཇུས།';

  @override
  String get privacyPolicy_Detail_1 =>
      'སྐུ་མཁྱེན། \"བཀོལ་སྤྱོད་ཆིངས་ཡིག\" དང་ \"སྒེར་གྱི་སྲིད་ཇུས\" བཅས་ཀྱི་ཆ་རྐྱེན་ལ་གཟབ་ནན་གྱིས་ཀློག་ནས་གོ་བ་ལེན་དགོས།\nཁྱེད་རང་གི་ཆོག་མཆན་ལ་གཞི་བཅོལ་ནས་ང་ཚོས་ཁྱེད་ལ་མཁོ་སྤྲོད་བྱེད་པའི་ཞབས་ཞུ་ཡར་རྒྱས་གཏོང་ཆེད་དུ། ཁྱེད་རང་ལ་ཆོག་མཆན་ཁས་མི་ལེན་པའམ་ཡང་ན་ཆ་མེད་གཏོང་བའི་ཐོབ་ཐང་ཡོད། ང་ཚོས་ནད་རྟགས་གཏོང་བའི་རེ་འདུན་རེ་རེའི་སྔོན་ལ་སྒེའུ་ཁུངས་ཤིག་བརྒྱུད་ནས་ཁྱེད་ཀྱི་མོས་མཐུན་གསལ་པོ་ཐོབ་རྒྱུ་ཡིན།\nཁྱེད་ཀྱིས་ ཀློག་ཐུབ། ';

  @override
  String get privacyPolicy_Detail_2 =>
      'མང་པོ་ སྦྱོངས། གལ་ཏེ་ཁྱེད་རང་མོས་མཐུན་ཡོད་ན། མོས་མཐུན་ ཞེས་པ་དེ་ལ་སྣུན་ནས་ང་ཚོའི་ཞབས་ཞུ་ལེན་འགོ་ཚུགས་རོགས།';

  @override
  String get and => ' དང་ ';

  @override
  String get accept => 'མོས་མཐུན།';

  @override
  String get takeBack => 'ཕྱིར་ལེན།';

  @override
  String get takingBack => 'ཕྱིར་ལེན་བཞིན་པ།';

  @override
  String get waiting => 'སྒུག་བཞིན་པ།';

  @override
  String get stepForward => 'གོམ་གང་མདུན།';

  @override
  String get takeBackAll => 'ཚང་མ་ཕྱིར་ལེན།';

  @override
  String get stepForwardAll => 'ཚང་མ་གོམ་གང་མདུན།';

  @override
  String get moveNow => 'ད་ལྟ་སྤོ་འགུལ།';

  @override
  String get done => 'བྱས་ཚར།';

  @override
  String get crackMill => 'ཀྲེག་འཕྲུལ་ཆས།';

  @override
  String get crackMill_Detail =>
      'གལ་ཏེ་རྩེད་འགྲན་པ་གཅིག་ལ་ གསུམ ནང་གི་རྡེལ་མ་གཏོགས་མེད་ཚེ། གསུམ ནང་གི་རྡེལ་རྣམས་བསུབ་ཏུ་མི་བཀག་པར་འགྱུར།';

  @override
  String get animationDuration => 'བརྙན་འཕྲིན་གྱི་ཡུན་ཚད།';

  @override
  String get none => 'མེད།';

  @override
  String get theme => 'བརྗོད་བྱ།';

  @override
  String get helpContent =>
      'རྩེད་མོ་འདིའི་དམིགས་ཡུལ་ནི་ཁ་གཏད་ལ་ཆ་ཤས་གསུམ་ལས་ཉུང་བའམ་ཡང་ན་ཁྲིམས་མཐུན་གྱི་གཡོ་འགུལ་མེད་པར་བཞག་རྒྱུ་དེ་རེད།\n\nགལ་ཏེ་གནས་བབ་ཐེངས་གསུམ་པ་བྱུང་བའམ་ཡང་ན་མཐའ་མའི་འགུལ་སྐྱོད་༡༠༠ནང་ལ་མེད་པར་བཟོས་ན་རྩེད་མོ་དེ་རང་འགུལ་གྱིས་འབྲི་བ་རེད།\n\nརྩེད་མོ་དེ་དུས་རིམ་གསུམ་དུ་བགོས་ཡོད།\n\n1. སྟོང་ཆའི་སྟེང་དུམ་བུ་འཇོག་པ།\n2. ཆ་ཤས་ཉེ་འགྲམ་གྱི་ས་ཚིགས་ལ་སྤོ་བ།\n3. (འདམ་ཀའི་དུས་རིམ།) རྩེད་མོ་བ་དེ་ཆ་ཤས་གསུམ་ལ་མར་ཕབ་པའི་སྐབས་སྟོང་ཆ་གང་རུང་ཞིག་ལ་སྤོ་བ།\n\nའཇོག་པ།\n\nརྩེད་མོ་དེ་སྟོང་ཆ་ཞིག་ནས་འགོ་འཛུགས་པ་དང་། དེའི་ནང་དུ་སྐར་མ་ཉི་ཤུ་རྩ་བཞི་ཡོད་པའི་དྲ་མིག་ཅིག་ཡོད། རྩེད་འགྲན་པ་རེ་རེས་རྩེད་མོ་ཚང་མ་བང་ཁྲི་སྟེང་ལ་མ་བཞག་བར་དུ་རྩེད་མོ་བ་ཚོས་ཁོང་ཚོའི་རྩེད་མོ་དེ་སྟོང་ཆའི་སྟེང་ལ་འཇོག་དགོས། གལ་ཏེ་རྩེད་འགྲན་པ་ཞིག་གིས་ཁོ་རང་གི་རྩེད་མོ་གསུམ་ཐད་ཀར་འཇོག་ཐུབ་ན་ཁོ་ལ་\"འཕྲུལ་འཁོར་\"ཡོད་ཅིང་། ཁོ་རང་གི་ཁ་གཏད་ཀྱི་རྩེད་མོ་གཅིག་བང་ཁྲི་ནས་ཕྱིར་འཐེན་བྱེད་སྲིད།\n\nཁྲིམས་ལུགས་ཁ་ཤས་སུ་རྩེད་མོ་བ་ཚོས་བཟོས་ཟིན་པའི་འཕྲུལ་ཁང་ནས་ཆ་ཤས་ཤིག་མ་བཏོན་གོང་དུ་ཆ་ཤས་གཞན་པ་གང་རུང་ཞིག་བཏོན་དགོས།\n\nཁྱེད་ཀྱིས་སྒྲིག་གཞི་ཁ་ཤས་ནང་བཀོད་པའི་དུས་རིམ་ནང་ལ་ཆ་ཤས་དེ་དག་བཏོན་པའི་ཆ་ཤས་ཀྱི་ས་ཚིགས་ལ་ཡང་བསྐྱར་འཇོག་མི་ཐུབ།\n\nདངོས་པོ་ཚང་མ་བེད་སྤྱོད་བཏང་ཚར་རྗེས་རྩེད་མོ་བ་ཚོས་སྐོར་རེས་སྤོ་བར་བྱེད།\n\nའགུལ་བསྐྱོད་བྱེད་པ།\n\nསྤོ་བར་རྩེད་མོ་བ་ཞིག་གིས་ཁོ་རང་གི་རྩེད་མོ་གཅིག་བང་ཁྲི་བརྒྱུད་ནས་ཉེ་འགྲམ་གྱི་ས་སྟོང་སྟོང་པར་སྤོ་བར་བྱེད། གལ་ཏེ་ཁོས་དེ་ལྟར་བྱེད་མི་ཐུབ་ན་ཁོས་རྩེད་མོ་ཕམ་ཡོད། རྩེད་འགྲན་པ་ཞིག་གིས་ཁོ་རང་གི་རྩེད་མོ་གསུམ་བང་ཁྲི་སྟེང་ལ་ཕྲེང་བ་བཟོས་ན་དེ་ལ་འཕྲུལ་འཁོར་ཡོད་ཅིང་། དེས་ཁོ་རང་གི་ཁ་གཏད་ཀྱི་རྩེད་མོ་གཅིག་བཀོད་སྒྲིག་བྱེད་པའི་སྐབས་ལྟར་མེད་པར་བཟོ་ཐུབ། རྩེད་མོ་བ་གང་རུང་གིས་ཆ་ཤས་གཉིས་ལ་མར་ཕབ་ནས་འཕྲུལ་ཁང་གསར་པ་བཟོ་བའི་གདམ་ག་མེད་པས་རྩེད་མོ་དེ་ཕམ་གྱི་ཡོད། གལ་ཏེ་ཁོང་གི་ཁ་གཏད་ཀྱིས་ཁོང་ཚོ་འགུལ་སྐྱོད་བྱེད་པར་བཀག་འགོག་བྱས་ན། རྩེད་འགྲན་པ་ཞིག་གིས་རྩེད་མོ་གསུམ་ལས་མང་བ་ཐོབ་སྐབས་ཕམ་ཐུབ།\n\nའཕུར་བསྐྱོད་བྱེད་པ།\n\nཁྲིམས་ལུགས་ཀྱི་ཁྱད་པར་ཁ་ཤས་ནང་རྩེད་མོ་བ་ཞིག་ལ་རྩེད་མོ་གསུམ་ལས་ལྷག་མེད་ན། ཁོང་གི་རྩེད་མོ་དེ་ཚོ་འཕུར་ཐུབ་པ་དང་།\n';

  @override
  String get versionInfo => 'ཐོན་རིམ་གནས་ཚུལ།';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'ཆོག་འཐུས།';

  @override
  String get sourceCode => 'ཐོན་ཁུངས་ཨང་རྟགས།';

  @override
  String get appVersion => 'མཉེན་ཆས་ཐོན་རིམ།';

  @override
  String get general => 'སྤྱིར་བཏང་།';

  @override
  String get advanced => 'མཐོ་རིམ།';

  @override
  String get placing => 'འཇོག་པ།';

  @override
  String get moving => 'སྤོ་འགུལ།';

  @override
  String get removing => 'བསུབ་པ།';

  @override
  String get gameOverCondition => 'རྩེད་མོ་མཇུག་སྒྲིལ་ཆ་རྐྱེན།';

  @override
  String get aisPlayStyle => 'AI རྩེད་སྟངས།';

  @override
  String get passive => 'བྱ་སྤྱོད་མེད།';

  @override
  String get timeout => 'དུས་ཚོད་ཟད་པ།';

  @override
  String get appearance => 'ཕྱི་རྣམ་པ།';

  @override
  String get drawOnHumanExperience => 'མིའི་ཉམས་མྱོང་ལ་བརྟེན་ནས་དཔྱད་པ།';

  @override
  String get considerMobility => 'རྡེལ་གྱི་སྤོ་འགུལ་ལ་དོ་སྣང་བྱེད།';

  @override
  String get pieceCount => 'དུམ་བུའི་གྲངས་འབོར།:';

  @override
  String inHand(Object player, int count) {
    return '$player ལག་ཏུ་ཡོད་པ། $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player རྩེད་པང་ཐོག་ཡོད་པ། $count';
  }

  @override
  String get boardTop => 'རྩེད་པང་གི་སྟེང་ནས་བར་ཐག';

  @override
  String get notAIsTurn => 'ད་ལྟ་ AI འགུལ་རྒྱུའི་དུས་མིན་པ།';

  @override
  String get aiIsNotThinking => 'AI བསམ་བློ་བཏང་བཞིན་མེད།';

  @override
  String get atEnd => 'ཁྱོད་སྤོ་འགུལ་མིང་ཐོའི་མཇུག་ཏུ་སླེབས་པ།';

  @override
  String get tapBackAgainToLeave => 'ཡང་བསྐྱར་རྗེས་ལ་རེག་ནས་ཕྱིར་ཐོན།';

  @override
  String get more => 'དེ་མིན།';

  @override
  String get experimental => 'འདི་ནི་ཚོད་ལྟའི་བརྒྱུད་རིམ་ཞིག་ཡིན།';

  @override
  String get experiments => 'ཚོད་ལྟ།';

  @override
  String get ossLicenses => 'སྒོ་དབྱེའི་ཐོན་ཁུངས་ཆོག་འཐུས།';

  @override
  String get language => 'སྐད་རིགས།';

  @override
  String get defaultLanguage => 'སྔོན་སྒྲིག་སྐད་ཡིག';

  @override
  String get mayMoveInPlacingPhase => 'འཇོག་རིམ་ནང་རྡེལ་བརྗེ་སྤོར་ཆོག';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'འཇོག་རིམ་དང་སྤོ་འགུལ་དུས་རིམ་ཁ་གསལ་མེད། དཔེར་ན། རྩེད་འགྲན་པ་རྣམས་ཀྱིས་སྤོ་འགུལ་རེ་རེར་རྩེད་པང་ཐོག་རྡེལ་འཇོག་པའམ་རྡེལ་གཅིག་སྤོ་བའི་(འཇོག་རྒྱུའི་རྡེལ་ལྷག་ཡོད་ཚེ།)སྐོར་ཐག་གཅོད་བྱེད་ཆོག';

  @override
  String get drawerColor => 'དཀར་ཆག་གི་ཚོས།';

  @override
  String get drawerTextColor => 'དཀར་ཆག་ཡི་གེའི་ཚོས།';

  @override
  String get drawerHighlightItemColor => 'དཀར་ཆག་གཙོ་གནད་རྣམ་གྲངས་ཀྱི་ཚོས།';

  @override
  String get mainToolbarBackgroundColor =>
      'ལག་ཆས་ཚང་གཙོ་བོའི་རྒྱབ་ལྗོངས་ཀྱི་ཚོས།';

  @override
  String get mainToolbarIconColor => 'ལག་ཆས་ཚང་གཙོ་བོའི་རིས་རྟགས་ཀྱི་ཚོས།';

  @override
  String get navigationToolbarBackgroundColor =>
      'འགྲུལ་བསྐྱོད་ལག་ཆས་ཚང་གི་རྒྱབ་ལྗོངས་ཀྱི་ཚོས།';

  @override
  String get navigationToolbarIconColor =>
      'འགྲུལ་བསྐྱོད་ལག་ཆས་ཚང་གི་རིས་རྟགས་ཀྱི་ཚོས།';

  @override
  String get autoHideToolbar => 'རང་འགུལ་ངང་ལག་ཆས་ཚང་སྦ་བ།';

  @override
  String get toolbarLocationOnScreen => 'ལག་ཆས་ཚང་གི་གནས་ཡུལ་སྟོན་པ།';

  @override
  String get top => 'ཡར་ངོས།';

  @override
  String get bottom => 'མར་ངོས།';

  @override
  String get center => 'དབུས།';

  @override
  String get solidColor => 'ཁ་དོག་གཅིག་མཚུངས།';

  @override
  String get picture => 'པར་རིས།';

  @override
  String get chooseYourPicture => 'རང་གི་པར་རིས་འདེམས་པ།';

  @override
  String get light => 'འོད་མདངས།';

  @override
  String get dark => 'མུན་པ།';

  @override
  String get themes => 'བརྗོད་བྱ།';

  @override
  String get currentTheme => 'མིག་སྔའི་བརྗོད་བྱ།';

  @override
  String get saveTheme => 'བརྗོད་བྱ་ཉར་བ།';

  @override
  String get showAnalysisGraph => 'དབྱེ་ཞིབ་རི་མོ་སྟོན།';

  @override
  String get analysis => 'དབྱེ་ཞིབ།';

  @override
  String get saveGame => 'རྩེད་མོ་ཉར་བ།';

  @override
  String get loadGame => 'རྩེད་མོ་མངོན་པ།';

  @override
  String get setupPosition => 'གནས་སྒྲིག་འཛུགས་པ།';

  @override
  String get showLegalMoves => 'ཁྲིམས་མཐུན་གྱི་སྤོ་ཐབས་སྟོན།';

  @override
  String get showLastMove => 'མཇུག་མཐའི་སྤོ་འགུལ་སྟོན།';

  @override
  String get showArrows => 'མདའ་རྟགས་སྟོན།';

  @override
  String get pieces => 'རྡེལ།';

  @override
  String get showAnalysis => 'དབྱེ་ཞིབ་བརྙན་རིས་སྟོན།';

  @override
  String get threads => 'Threads';

  @override
  String get getInvolved => 'མཉམ་ཞུགས་བྱེད།';

  @override
  String get helpImproveTranslate => 'ཡིག་སྒྱུར་ལེགས་བཅོས་ལ་རོགས་བྱེད།';

  @override
  String get tutorial => 'སློབ་ཁྲིད།';

  @override
  String get classicMill => 'Classic Mill';

  @override
  String get mixedMill => 'Mixed Mill';

  @override
  String get ceylonMill => 'སེ་ལོན་འཕྲུལ་ཁང་།';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'ཡང་ནས་ཡང་དུ་བཤིག་པ་དང་བསྐྱར་སྐྲུན་བྱས་ཆོག';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'གལ་ཏེ་རྩེད་མོ་བ་ཞིག་གིས་གསུམ་གཅིག་བརྡུངས་ནས་དེ་མ་ཐག་གསུམ་གསར་པ་བཟོས་ན། རྩེད་མོ་བ་དེས་གསུམ་གསར་པ་བཟོས་ན་ཁོང་གི་འགུལ་སྐྱོད་རྗེས་མའི་ནང་དེ་ལྟའི་མཐུད་མཚམས་ཐོག་མར་སྤོ་ཐུབ།';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'རྩེད་འགྲན་པ་ཞིག་ལ་རྡེལ་གསུམ་ལས་མེད་པ་དང་སྤོ་འགུལ་ཐེངས་བཅུའི་རྗེས་སུ་རྩེད་འགྲན་པ་གཉིས་ཀྱི་གང་རུང་གིས་ཀྱང་ཁ་གཏད་རྩེད་འགྲན་པའི་རྡེལ་བསུབ་མེད་ཚེ། རྩེད་མོ་འདི་ནི་གྲུབ་འབྲས་མཉམ་པ་ཡིན།';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'རྩེད་འགྲན་པ་ཞིག་གི་རྡེལ་གསུམ་དུ་ཇེ་ཉུང་དུ་ཕྱིན་ནས། སྤོ་འགུལ་ཐེངས་བཅུའི་ནང་རྩེད་འགྲན་པ་གཉིས་ཀའི་གང་རུང་གིས་ཀྱང་ཁ་གཏད་རྩེད་འགྲན་པའི་རྡེལ་བསུབ་མི་ཐུབ་ཚེ། རྩེད་མོ་འདི་ནི་གྲུབ་འབྲས་མཉམ་པ་ཡིན།';

  @override
  String get close => 'ཁ་རྒྱག་པ།';

  @override
  String get whitePiece => 'དཀར་པོའི་རྡེལ།';

  @override
  String get blackPiece => 'ནག་པོའི་རྡེལ།';

  @override
  String get emptyPoint => 'སྟོང་པའི་ས་ཚིགས།';

  @override
  String get noPoint => 'ས་ཚིགས་མེད།';

  @override
  String get placingPhase => 'འཇོག་རིམ།';

  @override
  String get movingPhase => 'སྤོ་འགུལ་དུས་རིམ།';

  @override
  String get flyingPhase => 'འཕུར་རིམ།';

  @override
  String sideToMove(Object player) {
    return 'འགུལ་དགོས་པའི་ཕྱོགས། $player';
  }

  @override
  String lastMove(Object move) {
    return 'མཐའ་མའི་སྤོ་འགུལ། $move';
  }

  @override
  String get selected => 'འདེམས་ཟིན།';

  @override
  String get accessibility => 'སྤྱོད་སྟབས་';

  @override
  String get screenReaderSupport => 'དྲ་མིག་ཀློག་ཆས་ལ་རྒྱབ་སྐྱོར།';

  @override
  String get isDraw => 'གྲུབ་འབྲས་མཉམ་པ་རེད།';

  @override
  String get draw => 'གྲུབ་འབྲས་མཉམ།';

  @override
  String get pieceHighlightColor => 'རྡེལ་མངོན་གསལ་ཚོས།';

  @override
  String get algorithm => 'རྩིས་རྒྱག';

  @override
  String get endgameNMoveRule => 'མཇུག་མཐའི་ N-སྤོ་འགུལ་སྒྲིག་གཞི།';

  @override
  String get endgameNMoveRule_Detail =>
      'གལ་ཏེ་རྩེད་འགྲན་པ་གཉིས་ལ་རྡེལ་གསུམ་ལས་མེད་པ་དང་། ཡང་ན་རྩེད་འགྲན་པ་གཉིས་ཀྱིས་གཏན་འཁེལ་གྱི་སྤོ་འགུལ་ནང་རྡེལ་བསུབ་མེད་ཚེ། རྩེད་མོ་འདི་ནི་གྲུབ་འབྲས་མཉམ་པ་ཡིན།';

  @override
  String get drawReasonEndgameRule50 =>
      'རྩེད་འགྲན་པ་གཉིས་ལ་རྡེལ་གསུམ་ལས་མེད་པ་དང་། ཡང་ན་རྩེད་འགྲན་པ་གཉིས་ཀྱིས་གཏན་འཁེལ་གྱི་སྤོ་འགུལ་ནང་རྡེལ་བསུབ་མེད།';

  @override
  String get threefoldRepetitionRule => 'ཐེངས་གསུམ་བསྐྱར་ཟློས་སྒྲིག་གཞི།';

  @override
  String get threefoldRepetitionRule_Detail =>
      'གལ་སྲིད་གནས་ས་གཅིག་ཐེངས་གསུམ་དུ་འབྱུང་ཚེ། རྩེད་མོ་འདི་ནི་གྲུབ་འབྲས་མཉམ་པ་ཡིན།';

  @override
  String get continueToMakeMove => 'གསུམ! མུ་མཐུད་དུ་གོམ་པ་སྤོས་ཏེ།';

  @override
  String get pointStyle => 'ས་ཚིགས་ཀྱི་རྣམ་པ།';

  @override
  String get pointWidth => 'ས་ཚིགས་ཀྱི་ཞེང་ཚད།';

  @override
  String get solid => 'སྲ་གཟུགས།';

  @override
  String get hollow => 'སྟོང་གཟུགས།';

  @override
  String get languageName => 'བོད་སྐད་';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count འགུལ',
      one: '$count འགུལ',
      zero: 'འགུལ',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'མངོན་འཇུག་ཕམ་པ།';

  @override
  String get filename => 'ཡིག་ཆའི་མིང་།';

  @override
  String get browse => 'བཤེར་བ།…';

  @override
  String get gameFiles => 'རྩེད་མོའི་ཡིག་ཆ།';

  @override
  String get gameSavedTo => 'རྩེད་མོ་འདི་རུ་ཉར་ཚགས་བྱས་ཟིན།';

  @override
  String get empty => 'སྟོང་པ།';

  @override
  String get noMove => 'སྤོ་འགུལ་མེད།';

  @override
  String get restoredPosition => 'ཐོག་མའི་གནས་ས་སླར་གསོ་བྱས་ཟིན།';

  @override
  String get clean => 'གཙང་བཟོ།';

  @override
  String get cleanedUp => 'གཙང་བཟོ་བྱས་ཟིན།';

  @override
  String get remove => 'བསུབ་པ།';

  @override
  String get noPiecesCanBeRemoved => 'རྡེལ་གང་ཡང་བསུབ་མི་ཆོག';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count pieces',
      one: '$count piece',
      zero: 'Piece',
    );
    return '$_temp0 བསུབ་དགོས་པ།';
  }

  @override
  String placedCount(int count) {
    return 'འཇོག་ཚར། ($count)';
  }

  @override
  String get placedPieceCount => 'འཇོག་རིམ་ནང་རྡེལ་གྱི་འཇོག་གྲངས་བསྡོམས་རྩིས།';

  @override
  String hasPlacedPieceCount(int count) {
    return 'ད་ལྟའི་རྩེད་འགྲན་པས་རྡེལ་ $count འཇོག་ཚར།';
  }

  @override
  String get notPlacingPhase => 'འཇོག་རིམ་མ་ཡིན་པས། དེ་བརྗེ་མི་ཆོག';

  @override
  String get paste => 'སྦྱར་ནས།';

  @override
  String get pasteDone => 'སྦྱར་ཚར།';

  @override
  String get cannotPaste => 'སྦྱར་མི་ཐུབ།';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'འཇོག་མེད་དང་བསུབས་ཟིན་པའི་རྡེལ་སྟོན།';

  @override
  String get fullScreen => 'གསལ་སྟོན་ཆ་ཚང་།';

  @override
  String get reopenToTakeEffect =>
      'སྒྲིག་སྟངས་ལག་བསྟར་བྱེད་པར་མཉེན་ཆས་ཕྱིར་ཐོན་ནས་བསྐྱར་དུ་ཁ་ཕྱེ།';

  @override
  String get forest => 'ནགས་ཚལ།';

  @override
  String get desktopImage => 'ཌེག་སཀོབ་བརྙན་རིས།';

  @override
  String get invalidPosition => 'ནུས་མེད་གནས་ས།';

  @override
  String get shareGIF => 'GIF མཉམ་སྤྱོད།';

  @override
  String get pixelRatio => 'པིག་སེལ་གྱི་བསྡུར་ཚད།';

  @override
  String get duration => 'ཡུན་ཚད།';

  @override
  String get gameScreenRecorder => 'རྩེད་མོ་གསལ་སྟོན་པར་རྒྱག་བྱེད་མཁན།';

  @override
  String get previous => 'སྔོན་མ།';

  @override
  String get next => 'རྗེས་མ།';

  @override
  String get skip => 'མཆོང་རྒྱུག';

  @override
  String get gotIt => 'ཤེས་རྟོགས་བྱུང་།';

  @override
  String get youCanModifyRules =>
      'ཁྱོད་ཀྱིས་སྒྲིག་གཞི་སྒྲིག་འཛུགས་ནང་རྩེད་མོའི་སྒྲིག་གཞི་ལེགས་བཅོས་བྱེད་ཆོག';

  @override
  String get youCanUseMouseWheelInPicker =>
      'འདེམས་ཆས་ནང་གི་རིན་ཐང་བརྗེ་ཆོག་པའི་ཆེད་དུ་ཙི་གུའི་འཁོར་ལོ་བེད་སྤྱོད་བྱེད་ཆོག';

  @override
  String get noTimeLimitForThinking =>
      'AI བསམ་བློའི་དུས་ཚོད་ 0 ལ་སྒྲིག་འཛུགས་བྱས་པ་ནི་བསམ་བློའི་དུས་ཚོད་ལ་ཚོད་འཛིན་མེད་པ་མཚོན།';

  @override
  String get whatIsMtdf =>
      'MTD(f) ནི་ཨལ་ཕ་བེ་ཊ་འཚོལ་ཞིབ་རྩིས་གཞིའི་བསྒྱུར་བཅོས་བྱས་པའི་རྣམ་པ་ཞིག་རེད་།';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'AI བསམ་བློ་གཏོང་བའི་དུས་ཚོད་བསྒྱུར་བཅོས་དེ་ཡོངས་སུ་གཏན་འཁེལ་མིན་པ་ཤེས་དགོས། དཀའ་ངལ་གྱི་ཚད་གཞི་དེ་རིན་ཐང་དམའ་རུ་གཏོང་སྐབས་བསམ་བློ་གཏོང་བའི་དུས་ཚོད་ངོ་མ་དེ་ཐུང་བ་དང་།';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'གལ་ཏེ་ཁྱེད་ཀྱིས་དཀའ་ངལ་གྱི་ཚད་གཞི་མཐོ་པོ་བཟོས་ཡོད་ཀྱང་AI བསམ་བློ་གཏོང་བའི་དུས་ཚོད་འཕར་མ་བྱེད་ན། བསམ་བློ་གཏོང་བའི་དུས་ཚོད་ཀྱི་ཚད་གཞི་ལས་དཀའ་ངལ་གྱི་ཚད་གཞི་ངོ་མ་དེ་རིན་ཐང་དམའ་བར་ཚད་བཀག་བྱེད་སྲིད། རིན་ཐང་ངོ་མ་དེ་འཕྲུལ་ཆས་ཀྱི་བྱེད་ནུས་ལ་གཞིགས་ནས་མི་འདྲ་བ་ཆགས་སྲིད།';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) ནི་གནས་ཡུལ་གཅིག་གི་ནང་ལ་འགུལ་སྐྱོད་ཡག་ཤོས་འཚོལ་བའི་འཚོལ་ཞིབ་རྩིས་གཞི་ཞིག་ཡིན། དེ་ནི་ཨལ་ཕ་བེ་ཊ་རྩིས་གཞིའི་ཡར་རྒྱས་ཤིག་ཡིན་པ་དང་། སྒེའུ་ཁུང་ཀླད་ཀོར་གྱི་འཚོལ་ཞིབ་བེད་སྤྱད་དེ་འགུལ་སྐྱོད་དེ་འགྱུར་བ་གཙོ་བོ་ནས་བདེ་འཇགས་ལྡན་པའི་གྲངས་ཀ་ལས་ངན་པའམ་ཡང་ན་སྡུག་པོ་མེད་པ་གཏན་འཁེལ་བྱེད། མཐོ་རིམ་སློབ་གྲྭའི་ནང་སློབ་སྦྱོང་བྱེད་བཞིན་པའི་སློབ་མ་ཚོས་སློབ་སྦྱོང་བྱེད་པའི་སྐབས་སུ། མཐོ་རིམ་སློབ་གྲྭའི་སློབ་མ་ཚོས་སློབ་སྦྱོང་བྱེད་པའི་སྐབས་སུ།';

  @override
  String get whatIsAlphaBeta =>
      'ཨལ་ཕ་བྷེ་ཊ་རྩིས་གཞི་ནི་གཡོ་འགུལ་ཡག་ཤོས་འཚོལ་བའི་འཚོལ་ཞིབ་རྩིས་གཞི་ཞིག་ཡིན། དེས་འཚོལ་ཞིབ་ཤིང་སྡོང་གཅོད་པ་དང་ནུས་པ་ཆེ་རུ་གཏོང་བར་ཆུང་ཤོས་ཀྱི་གཞི་རྩ་དང་རིན་ཐང་གཉིས་སྟེ་ཨལ་ཕ་དང་བེ་ཊ་བེད་སྤྱོད་བྱེད་ཀྱི་ཡོད། གློག་ཀླད་ལ་ཐོབ་ཐུབ་པའི་གྲངས་ཀ་ཆུང་ཤོས་དེ་ཨལ་ཕ་ཡིས་མཚོན་པ་དང་། བེ་ཊ་ཡིས་ཁ་གཏད་ལ་ཐོབ་ཐུབ་པའི་གྲངས་ཀ་ཆེ་ཤོས་དེ་མཚོན་གྱི་ཡོད། རྩིས་གཞི་དེས་གློག་ཀླད་ལ་རྩེད་མོའི་ནང་ཐག་གཅོད་ཡག་པོ་དང་ཕན་ནུས་ལྡན་པ་བཟོ་བར་ཕན་ཐོགས།';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'འགྲོ་བ་མིའི་ཉམས་མྱོང་ལྟར་ན་རྒྱལ་ཁ་ཐོབ་པར་འབད་བརྩོན་བྱས་ན། དེ་ལས་ལྡོག་སྟེ་ཁྱེད་རང་གི་དམིགས་ཡུལ་དུ་འདྲ་མཉམ་ཡོང་རྒྱུ་དེ་དམིགས་ནས་རྩེད་མོ་ཕམ་རྒྱུ་ལས་གཡོལ་དགོས། ཁྱེད་རང་གི་ཁ་གཏད་ལ་དོ་སྣང་བྱས་ནས་ཁོ་ཚོས་ནོར་འཁྲུལ་བཟོ་སྲིད་པའི་གནས་བབ་ལ་དལ་བུས་ངང་ནས་བསླུ་བྲིད་གཏོང་དགོས། ཁོང་ཚོས་ཞན་ཆ་སྟོན་དུས་གོ་སྐབས་དམ་འཛིན་བྱས་ནས་རྒྱལ་ཁ་ཐོབ་པར་དལ་བུས་ངང་སྐུལ་འདེད་གཏོང་དགོས། དེ་ལྟར་བྱས་ན་རྒྱལ་ཁ་ཐོབ་ཐུབ།';

  @override
  String get firstMoveDetail =>
      'རྩེད་མོ་འདིའི་ནང་དུ་རྩེད་མོ་བ་དང་པོ་དང་བསྡུར་ན་རྩེད་མོ་བ་གཉིས་པ་ལ་རྒྱལ་ཁ་ཐོབ་སླ་བ་རེད།';

  @override
  String get passiveDetail =>
      'གདམ་ག་མེད་པའི་གདམ་ག་དེ་ལག་བསྟར་བྱེད་པ་དེས་མིས་བཟོས་རིག་ནུས་ལ་གནས་བབ་དེའི་ནང་ཁེ་ཕན་ཡོད་པའི་སྐབས་ལ་ལྷོད་པོ་ཆགས་རྒྱུ་ལས་གང་མགྱོགས་རྒྱལ་ཁ་ཐོབ་པར་དྲག་ཤུགས་ཀྱིས་འབད་བརྩོན་བྱེད་པ་ལས་ལྷག་པར་དུ་བདེ་འཇགས་ཡོང་བར་བྱེད།';

  @override
  String get moveRandomlyDetail =>
      'གདམ་ཁ་འདི་ལག་བསྟར་བྱེད་པ་དེས་རྩེད་མོའི་གང་བྱུང་དང་སྤྲོ་སྣང་ཆེ་རུ་གཏོང་བ་དང་།';

  @override
  String get considerMobilityOfPiecesDetail =>
      'གལ་ཏེ་མིས་བཟོས་རིག་ནུས་དེས་ཁོང་གི་ཕྲེང་བའི་འགུལ་སྐྱོད་ལ་བསམ་གཞིག་བྱས་ན། དེས་ཁ་གཏད་ཀྱི་ཕྲེང་བ་དེ་གང་མགྱོགས་འཛིན་ཐུབ་པའི་དམིགས་ཡུལ་བྱེད་པ་མ་ཟད།';

  @override
  String get whenBoardIsFull => 'རྩེད་པང་ཁེངས་པའི་སྐབས།';

  @override
  String get whenBoardIsFull_Detail =>
      'འཇོག་རིམ་མཇུག་སྒྲིལ་སྐབས། སྤོ་འགུལ་དུས་རིམ་འགོ་མ་ཚུགས་གོང་། རྩེད་པང་ཁེངས་ཚེ་གཤམ་གྱི་བྱ་སྤྱོད་སྤེལ།';

  @override
  String get sideToMoveRemovePiece =>
      'སྤོ་འགུལ་དུས་རིམ་ནང་སྔོན་ལ་འགུལ་མཁན་གྱིས་ཁ་གཏད་རྩེད་འགྲན་པའི་རྡེལ་གཅིག་བསུབ།';

  @override
  String get agreeToDraw => 'ཕྱོགས་གཉིས་ཀྱིས་གྲུབ་འབྲས་མཉམ་པར་མོས་མཐུན།';

  @override
  String get takeOpponentsPiece =>
      'ཁྱེད་ཀྱི་ཁ་གཏད་རྩེད་འགྲན་པའི་རྡེལ་གཅིག་ལེན།';

  @override
  String get firstPlayerLose => 'རྩེད་འགྲན་པ་དང་པོས་རྩེད་མོ་ཕམ།';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'རྩེད་འགྲན་པ་དང་པོ་དང་གཉིས་པས་ཁ་གཏད་རྩེད་འགྲན་པའི་རྡེལ་རེ་རེ་བསུབ།';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'རྩེད་འགྲན་པ་གཉིས་པ་དང་དང་པོས་ཁ་གཏད་རྩེད་འགྲན་པའི་རྡེལ་རེ་རེ་བསུབ།';

  @override
  String get enteredFlyingPhase =>
      'ད་ལྟ་འཕུར་རིམ་དུ་ཞུགས་པ་ཡིན། ཁ་གཏད་རྩེད་འགྲན་པའི་རྡེལ་རྣམས་རྩེད་པང་ཐོག་གི་སྟོང་ས་གང་རུང་དུ་མཆོང་ཐུབ། ཁྱོད་ཀྱིས་“སྒྲིག་སྲོལ་གཞི་སྒྲིག་”ནང་འཕུར་སྒྲིག་སྲོལ་སྒོ་རྒྱག་ཆོག';

  @override
  String get whenStalemate => 'འགུལ་མེད་སྐབས།';

  @override
  String get whenStalemate_Detail =>
      'རྡེལ་གང་ཡང་སྤོ་འགུལ་མི་ཐུབ་པའི་སྐབས་གཤམ་གྱི་བྱ་སྤྱོད་གང་སྤེལ།';

  @override
  String get endWithStalemateLoss =>
      'འགུལ་མེད་ཕམ་ཁ་ཞིག་གིས་འགོག་རྐྱེན་ཐེབས་པའི་ཕྱོགས་མཇུག་བསྡུ།';

  @override
  String get changeSideToMove => 'སྤོ་འགུལ་ཕྱོགས་བརྗེ།';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'ཁ་གཏད་རྩེད་འགྲན་པའི་རྡེལ་གཅིག་བསུབ་པ་དང་འགུལ་རྗེས་མ་སྤེལ།';

  @override
  String get endWithStalemateDraw => 'འགུལ་མེད་གྲུབ་འབྲས་མཉམ་པས་མཇུག་བསྡུ།';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'ཁ་གཏད་རྩེད་འགྲན་པའི་རྡེལ་གཅིག་བསུབ་པ་དང་སྤོ་འགུལ་ཕྱོགས་བརྗེ།';

  @override
  String get aiResponseDelayTime => 'AI ཡི་ཡ་ལན་འགོར་འགྱངས་དུས་ཚོད།';

  @override
  String get aiIsDelaying =>
      'AI ད་ལྟ་ཡ་ལན་འགོར་འགྱངས་དུས་རིམ་དུ་གནས། ဆက်လုပ်སྔོན་ལ་ཏོག་ཙམ་བསྒུག་རོགས།';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'ཁྱོད་ཀྱིས་མཐའ་འཁོར་མིན་པའི་རྡེལ་བསུབ་མི་ཆོག';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'གལ་ཏེ་ལམ་ལྷོང་མེད་ན། ཁྱེད་ཀྱི་ཉེ་འགྲམ་གྱི་ཁ་གཏད་ཀྱི་ཆ་ཤས་དེ་ཚོ་སྒྲིག་གཞི་གསུམ་ལ་མ་ལྟོས་པར་བཏོན་ཐུབ།';

  @override
  String get whatIsMcts =>
      'MCTS ནི་གསར་འགོ་རྩེད་མཁན་ལ་འཚམ་པའི་གཅིག་རྩིས་རྒྱུ་རྩལ་ཡིན་ཞིང་། འདྲ་སྐུའི་བརྒྱུད་ནས་སྤོ་འགུལ་སྣ་ཚོགས་ལ་འཚོལ་ཞིབ་དང་གདེང་འཇོག་བྱས་ཏེ་ཐག་གཅོད་གཏོང་།';

  @override
  String get goldenJade => 'གསེར་མདོག་བྱུ་རུ།';

  @override
  String get forestWood => 'ནགས་ཚལ་ཤིང་ནགས།';

  @override
  String get darkMystery => 'མུན་ནག་གི་གསང་བ།';

  @override
  String get midnightBlue => 'ནམ་ཕྱེད་མཚན་མོའི་སྔོན་པོ།';

  @override
  String get greenForest => 'ལྗང་མདོག་ནགས་ཚལ།';

  @override
  String get greenMeadow => 'ལྗང་མདོག་རྩྭ་ཐང་།';

  @override
  String get stonyPath => 'རྡོ་ལམ་ཁྲ་ཁྲ།';

  @override
  String get pastelPink => 'སྐྱ་མདོག་སོབ་སོབ།';

  @override
  String get turquoiseSea => 'གཡུ་མདོག་རྒྱ་མཚོ།';

  @override
  String get violetDream => 'སྨུག་སྤྲིན་གྱི་རྨི་ལམ།';

  @override
  String get mintChocolate => 'བོང་སྒྲོག་ཏོག་སྙོལ།';

  @override
  String get skyBlue => 'ནམ་མཁའི་སྔོན་པོ།';

  @override
  String get playfulGarden => 'རྩེད་འཇོའི་ལྡུམ་ར།';

  @override
  String get whatIsRetrogradeAnalysis =>
      'ཕྱིར་ལོག་དབྱེ་ཞིབ་རྩིས་གཞི་དེས་འགོ་འཛུགས་གནས་ཡུལ་མི་འདྲ་བ་ནས་མཇུག་མཐའི་རྩེད་མོའི་གནས་སྡུད་གཞི་གྲངས་བཟོ་བར་རིན་ཐང་སྣ་ཚོགས་ཀྱི་ཕྱིར་ལོག་དབྱེ་ཞིབ་བཀོལ་སྤྱོད་བྱེད་ཀྱི་ཡོད། ཐབས་ལམ་འདི་ཧ་ཅང་ཤུགས་ཆེ་བའི་ཐབས་ཤེས་ཀྱི་སྡེ་ཚན་འོག་ལ་ཚུད་ཡོད།';

  @override
  String get viewAlgorithmGuide =>
      'ཁྱེད་རང་རྩིས་གཞི་འདིའི་སྤྱོད་མཁན་གྱི་ལམ་སྟོན་ལ་ལྟ་འདོད་དམ།';

  @override
  String get showPositionalAdvantageIndicator => 'གོ་གནས་ཀྱི་དགེ་མཚན་སྟོན་པ།';

  @override
  String get usePerfectDatabase => 'གྲངས་མཛོད་ཡང་དག་པ་བེད་སྤྱོད་བྱེད་པ།';

  @override
  String get perfectDatabaseDescription =>
      'གདམ་ཁ་འདི་ཁ་ཕྱེ་ནས་རྩེད་མོའི་གནས་སྡུད་གཞི་གྲངས་ཡག་ཤོས་ཤིག་བེད་སྤྱོད་གཏོང་དགོས། ཁྱད་ཆོས་འདིས་རྩེད་མོའི་ཁ་ཕྱེ་བ་དང་མཇུག་སྒྲིལ་གྱི་ཐབས་ཤེས་མཉམ་དུ་བསྡུས་ནས་འགུལ་སྐྱོད་ཡག་ཤོས་བསྟན་པ་དང་། རྩེད་མོའི་ནང་དུ་གཏན་ཚིགས་མཐོ་ཤོས་འཚོལ་མཁན་གྱི་རྩེད་མོ་བ་ཚོའི་འདམ་ག་དང་པོ་ཡིན། གནས་སྡུད་གཞི་གྲངས་དེ་རྩེད་མོའི་ཐབས་ཤེས་ཡག་ཤོས་མཁོ་སྤྲོད་བྱེད་པའི་ཆེད་དུ་བཟོས་པའི་རྩིས་འཁོར་ལག་རྩལ་ཚད་ལྡན་བརྒྱུད་ནས་བཟོས་ཡོད།\n\nགལ་ཏེ་འཕྲུལ་ཆས་ལ་གནས་སྡུད་གཞི་གྲངས་ལ་འཛུལ་ཐུབ་ཀྱི་མེད་ན། སྲོལ་རྒྱུན་གྱི་རྩིས་གཞི་དེ་ཚོ་རྩེད་མོའི་ཐག་གཅོད་བྱེད་པར་བསྒྱུར་རྒྱུ་རེད། གནས་སྡུད་གཞི་གྲངས་ཡོད་པའི་སྐབས་དཀའ་ངལ་གྱི་ཚད་གཞི་དེ་དངོས་གནས་ཧ་ཅང་མཐོ་པོ་ཆགས་ནས་འཕྲུལ་ཆས་ཀྱི་བསམ་བློ་གཏོང་བའི་དུས་ཚོད་ཧ་ཅང་ཉུང་དུ་ཕྱིན་ཡོད། འཕྲུལ་ཆས་ཀྱི་མདའ་རྩེད་རྣམ་པའི་གདམ་ཁའི་སྒྲིག་སྟངས་མང་པོ་ཡང་བརྗེ་སྒྱུར་བྱེད་ཀྱི་ཡོད། རྒྱུ་མཚན་ནི་གནས་སྡུད་གཞི་གྲངས་ཀྱི་གྲུབ་འབྲས་ལ་གཙོ་གནད་ཆེ་ཤོས་ཡོད།\n\nགཞི་གྲངས་མཛོད་འདི་བེད་སྤྱོད་གཏོང་སྟངས་ཤེས་འདོད་ན། འདིར་སྣུན་རོགས།';

  @override
  String get backgroundImage => 'རྒྱབ་ལྗོངས་པར་རིས།';

  @override
  String get whatIsRandom =>
      'གཞི་གྲངས་མཛོད་ཡང་དག་པ་བེད་སྤྱོད་བྱེད་ གདམ་ཁ་འདི་ལྕོགས་ཅན་མེད་པའི་སྐབས་ གང་བྱུང་སྒྲིག་སྟངས་ཀྱིས་འཕྲུལ་ཆས་ཀྱིས་སྤོ་བཤུད་འདེམས་སྒྲུག་རྩིས་གཞི་གང་རུང་བཀོལ་སྤྱོད་མ་བྱེད་པར་གང་བྱུང་དུ་ཆ་ཤས་སྤོ་བཤུད་བྱེད། འདིས་རྒྱུན་དུ་རྩེད་མོའི་རྣམ་པ་མངོན་གསལ་དོད་པོས་ཞན་དུ་བཏང་བ་རེད། དེ་ལས་ལྡོག་སྟེ། གནས་སྡུད་གཞི་གྲངས་ཡང་དག་པ་བེད་སྤྱོད་གཏོང་སྐབས་མིས་བཟོས་རིག་སྟོབས་ཀྱིས་གནས་ཚུལ་གཞི་གྲངས་ཡང་དག་པ་ལ་བརྟེན་ནས་ཐག་གཅོད་བྱེད་ཀྱི་ཡོད། ཐབས་ལམ་འདིའི་ནང་མིས་བཟོས་རིག་སྟོབས་ཀྱི་བྱ་སྤྱོད་དེ་ཚོ་གནས་སྡུད་གཞི་གྲངས་ཀྱི་ནང་དོན་ལ་གཞི་བཅོལ་ནས་དུས་ཚོད་ངོ་མའི་རྩིས་རྒྱག་དང་འཚོལ་ཞིབ་ཀྱི་རྩིས་གཞི་ལ་རག་ལུས་པ་སྔོན་འགོག་བྱེད་ཀྱི་ཡོད།';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'ཁ་གཏད་ཀྱི་ལག་ནས་ཆ་ཤས་དེ་བཏོན་དགོས། དེ་ནས་ཁ་གཏད་ཀྱི་དུས་ཚོད་རེད།';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'འཇོག་པའི་སྐབས་སུ་འཕྲུལ་འཁོར་བཟོ་སྐབས།';

  @override
  String get removeOpponentsPieceFromBoard =>
      'ཁ་གཏད་ཀྱི་ཆ་ཤས་དེ་བང་ཁྲི་ནས་ཕྱིར་འཐེན་བྱེད་དགོས།';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'ཁ་གཏད་ཀྱི་ཆ་ཤས་དེ་བང་ཁྲི་ནས་ཕྱིར་འཐེན་བྱེད་དགོས། དེ་ནས་ཁ་གཏད་ཀྱི་དུས་ཚོད་རེད།';

  @override
  String get opponentRemovesOwnPiece =>
      'ཁ་གཏད་དེས་ཁོ་རང་གི་ཆ་ཤས་དེ་བང་ཁྲི་ནས་ཕྱིར་འཐེན་བྱེད་ཀྱི་ཡོད།';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'ཁྱེད་རང་གིས་བྱ་སྤྱོད་སྤེལ་བའི་ཚབ་ཏུ། ཁ་གཏད་དེས་ཁོ་རང་གི་ཆ་ཤས་འདེམས་ནས་བང་ཁྲི་ནས་ཕྱིར་འཐེན་བྱེད་པ་དེས་ཁོ་རང་ལ་གནོད་སྐྱོན་གཏོང་བའི་བྱ་སྤྱོད་དེ་ཕན་ནུས་ལྡན་པའི་སྒོ་ནས་སྤེལ་གྱི་ཡོད།';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'ཁ་གཏད་ཀྱི་ལག་ནས་ཆ་ཤས་དེ་བཏོན་ནས་དེ་ནས་ཁྱེད་རང་འགུལ་སྐྱོད་བྱེད་པའི་དུས་ཚོད་རེད།';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'ཁ་གཏད་ཀྱི་ལག་ནས་དུམ་བུ་བཏོན་དགོས། གལ་ཏེ་སྣ་མང་བཏོན་པའི་སྒྲིག་སྟངས་ལྟར་ན། ཆ་ཤས་མང་པོ་བཏོན་དགོས་པ་དང་ཁ་གཏད་ཀྱི་ལག་ཏུ་ཆ་ཤས་གང་ཡང་མ་ལྷག་ན། དེ་ནས་ཁྱེད་རང་འགུལ་སྐྱོད་བྱེད་པའི་དུས་ཚོད་རེད། གལ་ཏེ་ཁྱེད་ཀྱིས་མུ་མཐུད་དུ་འཕྲུལ་ཁང་བཟོས་ན། ཁྱེད་ཀྱིས་ཁ་གཏད་ཀྱི་ཆ་ཤས་དེ་དག་མུ་མཐུད་དུ་མེད་པར་བཟོ་སྲིད།';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'ཁ་གཏད་ཀྱི་ལག་ནས་དུམ་བུ་བཏོན་དགོས། གལ་ཏེ་སྣ་མང་བཏོན་པའི་སྒྲིག་སྟངས་ལྟར་ན། ཆ་ཤས་མང་པོ་བཏོན་དགོས་པ་དང་ཁ་གཏད་ཀྱི་ལག་ཏུ་ཆ་ཤས་གང་ཡང་མ་ལྷག་ན། དེ་ནས་ཁ་གཏད་གཡོ་འགུལ་བྱེད་པའི་དུས་ཚོད་རེད།';

  @override
  String get markAndDelayRemovingPieces =>
      'རྟགས་བཀོད་ནས་དུམ་བུ་མེད་པར་བཟོ་རྒྱུ་ཕྱིར་འགྱངས།';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'བཀོད་སྒྲིག་བྱེད་པའི་སྐབས་སུ་བཏོན་དགོས་པའི་དངོས་པོ་དེ་དག་ལ་རྟགས་བཀོད་ཡོད། རྩེད་མོ་བ་གཉིས་ཀའི་ཆེད་དུ་དངོས་པོ་གསར་པ་གང་ཡང་ས་ཚིགས་དེ་དག་ལ་འཇོག་མི་ཐུབ། འགུལ་སྐྱོད་ཀྱི་དུས་རིམ་ལ་འཛུལ་སྐབས་རྟགས་བཀོད་པའི་དངོས་པོ་དེ་དག་ཡོངས་སུ་མེད་པར་བཟོས་པ་དང་། དེ་ནས་རྩེད་མོ་བ་ཚོས་ཁོང་ཚོའི་དངོས་པོ་དེ་དག་ད་ལྟ་སྟོང་པའི་ས་ཚིགས་དེ་དག་ལ་སྤོ་ཐུབ།';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'བཙུགས་པའི་སྐབས་སུ་འཕྲུལ་ཁང་བཟོ་སྐབས་བྱེད་ཐུབ་པའི་བྱ་སྤྱོད།';

  @override
  String get marked => 'རྟགས་བཀོད་ཟིན་པ།';

  @override
  String get menu => 'དཀར་ཆག';

  @override
  String get monochrome => 'གཅིག་མདོག';

  @override
  String get youCanEnableScreenReaderSupport =>
      'ཁྱོད་ཀྱིས་སྤྱིར་བཏང་སྒྲིག་འཛུགས་ཀྱི་སྤྱོད་སྒོ་གསར་སྒྲིག ནང་འཆར་ཤེལ་ཀློག་ཆས་ལ་རྒྱབ་སྐྱོར་སྒོ་འབྱེད་ཆོག་པ།';

  @override
  String get showNumbersOnPieces => 'རྡེལ་ཐོག་ཨང་གྲངས་སྟོན།';

  @override
  String get saveImage => 'པར་རིས་ཉར་ཚགས།';

  @override
  String get isAnalysisToolbarShown => 'དབྱེ་ཞིབ་ལག་ཆས་ཚང་སྟོན།';

  @override
  String get analysisToolbarBackgroundColor =>
      'དབྱེ་ཞིབ་ལག་ཆས་ཚང་གི་རྒྱབ་ལྗོངས་ཚོས།';

  @override
  String get analysisToolbarIconColor => 'དབྱེ་ཞིབ་ལག་ཆས་ཚང་གི་རིས་རྟགས་ཚོས།';

  @override
  String get transformed => 'བཟོ་བཅོས་ཟིན་པ།';

  @override
  String get cannotTransform => 'བཟོ་བཅོས་བྱེད་མི་ཐུབ།';

  @override
  String get rotate => 'སྐོར་འཁོར།';

  @override
  String get horizontalFlip => 'H ཕྱོགས།';

  @override
  String get verticalFlip => 'V ཕྱོགས།';

  @override
  String get innerOuterFlip => 'IO ཕྱོགས།';

  @override
  String get transparentCanvas => 'དྭངས་གསལ་རི་མོ།';

  @override
  String get restrictRepeatedMillsFormation =>
      'བསྐྱར་ཟློས་གསུམ་གྱི་ཆགས་ཚུལ་ལ་ཚོད་འཛིན་བྱེད།';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'རྡེལ་གཅིག་ གསུམ གཅིག་ནས་སྤོས་ཏེ་ གསུམ གཞན་ཞིག་གྲུབ་པ་ཡིན་ཚེ། སྐོར་རྗེས་མའི་སྐབས་སུ་དེ་མ་ཐག་ཏུ་ཐོག་མའི་ས་ཚིགས་སུ་ལོག་ནས་ཡང་བསྐྱར་ གསུམ གྲུབ་པ་བཟོ་མི་ཆོག སྤོ་འགུལ་མི་འདྲ་བ་གཅིག་བྱེད་དགོས་པ་རེད།';

  @override
  String get oneTimeUseMill => 'ཐེངས་གཅིག་བེད་སྤྱོད་ mill';

  @override
  String get oneTimeUseMill_Detail =>
      'རེ་གཟིགས་སྡུད་ལ་ཁ་གཏད་རྩེད་འགྲན་པའི་རྡེལ་གཅིག་མ་གཏོགས་བསུབ་མི་ཆོག ཁྱོད་ཀྱིས་ཡང་བསྐྱར་བཟོ་ཐུབ། ཡིན་ནའང་དེ་ལ་གྲངས་མཐའ་མེད་རྡེའུ་བསུབ་ཏུ་བེད་སྤྱོད་མི་ཆོག।';

  @override
  String get currentRulesNoPerfectDatabase =>
      'ཁྱེད་ཀྱིས་གཏན་འབེབས་བྱས་པའི་ད་ལྟའི་ཁྲིམས་ལུགས་ལ་གནས་སྡུད་གཞི་གྲངས་ཡང་དག་པ་ཞིག་མེད། གཞི་གྲངས་མཛོད་ཀྱི་སྐོར་ལ་གནས་ཚུལ་མང་པོ་ཤེས་འདོད་ན། འདིར་སྣུན་རོགས།';

  @override
  String get focusOnBlockingPaths =>
      'འགུལ་སྐྱོད་བཀག་འགོག་ལ་དམིགས་འཛུགས་བྱེད་པ།';

  @override
  String get focusOnBlockingPaths_Detail =>
      'ཁྲོམ་གྲལ་བཟོ་བ་ལས་ཕ་རོལ་པོའི་འགུལ་སྐྱོད་བཀག་འགོག་བྱེད་པར་གཙོ་འདོན་བྱེད་པ། ཁྲོམ་གྲལ་བཟོས་ནས་རྡེའུ་ཕྱིར་འདོན་བྱེད་པར་དམིགས་འཛུགས་བྱེད་པའི་ཚབ་ཏུ། རིག་ནུས་ལྡན་པའི་འཕྲུལ་འཁོར་གྱིས་ཕ་རོལ་པོར་འཛིན་བཟུང་བྱེད་པ་དང་། དེ་ལ་བརྟེན་ནས་ཁོང་ཚོར་འགུལ་སྐྱོད་བྱེད་པའི་ནུས་པ་མེད་པ་བཟོས་ནས་བརྩེ་སེམས་ལྡན་པའི་རྩེད་མོའི་ཐོག་ནས་རྒྱལ་ཁ་ཐོབ་པར་བྱེད། བྱ་ཐབས་འདིས་ཕ་རོལ་པོའི་ཁྲོམ་གྲལ་བཀག་འགོག་བྱེད་པར་ཐད་ཀར་མི་དམིགས།।';

  @override
  String get pieceImage => 'ཆོ་གོག་པོང་།';

  @override
  String get importColorSettings => 'ཚོན་གཞིའི་སྒྲིག་སྟངས་ནང་འདྲེན་བྱོས།';

  @override
  String get exportColorSettings => 'ཚོན་གཞིའི་སྒྲིག་སྟངས་ཕྱིར་འདྲེན་བྱོས།';

  @override
  String get import => 'ནང་འདྲེན་བྱོས།';

  @override
  String get export => 'ཕྱིར་འདྲེན་བྱོས།';

  @override
  String get pleaseCopyJsonToClipboard =>
      'གཞི་སྒྲིག་ཀྱི་ཚོན་གྱི་གྲངས་སྒྲིག JSON དངོས་གཞིའི་སྒྲིག་སྟངས་ལག་ཆས་ནང་བརྡར་གནང་།';

  @override
  String get copiedToClipboard => 'ལག་ཆས་ནང་བརྡར་ཡོད།';

  @override
  String get imported => 'ནང་འདྲེན་ཡོད།';

  @override
  String get boardImage => 'བར་སྟོད་གྱི་རི་མོ།';

  @override
  String get autumnLeaves => 'དགུ་ཟླ་ཤིང་རིན';

  @override
  String get legendaryLand => 'གཏེར་མོ་རི་མོ';

  @override
  String get vignetteEffect => 'བི་ནེཊ་ཨེཕེགཊ།';

  @override
  String get promptMakeToolbarTransparent =>
      'གནས་སྟངས་སྒྲིག་གསར་བར་མཉམ་མཐུད་མཐོང་མཁན་གྱི་གྲུབ་སྒྲིག་སྒྲིག་གསར་བར་བསྒྱུར་བ་གྱིས་ཁྱོད་ལ་ཡོད་པས?';

  @override
  String get vibration => 'རྩིས་སྒྲིག་བྱས་ཟིན་པ།';

  @override
  String get soundTheme => 'སྒྲ་རྒྱུགས་ཀྱི་རྟེན་';

  @override
  String get ball => 'ནག';

  @override
  String get liquid => 'འཕེལ་བ';

  @override
  String get wood => 'འབྲུག';

  @override
  String get placeEffectAnimation => 'ཆ་འཇུག་རིག་བཟོ་བའི་བསྒྱུར་བཅོས';

  @override
  String get removeEffectAnimation => 'ཆ་སུབ་རིག་བཟོ་བའི་བསྒྱུར་བཅོས';

  @override
  String get isToolbarAtBottom => 'ལྕགས་སྒྲོན་སྤྱིར་བཤད་འོག་ཕྱོགས་སྟོན།';

  @override
  String get boardCornerRadius => 'གོ་རིམ་གྱི་གཡོན་ཚད།';

  @override
  String get useOpeningBook => 'འགོ་འཛུགས་ཡིག་ཆ་ལ་བཀོལ་པ།';

  @override
  String get currentRule => 'ད་ལྟ།';

  @override
  String get nineMensMorris => 'མི་དགུའི་མོར་རིས།';

  @override
  String get twelveMensMorris => 'སྐྱེས་པ་བཅུ་གཉིས།';

  @override
  String get morabaraba => 'མོ་ར་བ་ར་བ།';

  @override
  String get dooz => 'དུཛ';

  @override
  String get chamGonu => 'ཆམ་གོ་ནུ། ';

  @override
  String get zhiQi => 'ཅི་ཅི།';

  @override
  String get chengSanQi => 'ཆེན་སམ་ཅི།';

  @override
  String get mulMulan => 'མུལ་མུ་ལན།';

  @override
  String get nerenchi => 'ནེ་རེན་ཅི།';

  @override
  String get ruleSet => 'ཚད་བཟུམ།';

  @override
  String get laskerMorris => 'ལས་ཀར་མོ་རིས།';

  @override
  String get oneTimeMill => 'གཅིག་ཐར་རྒྱུ་འགེལ།';

  @override
  String get daSanQi => 'ད་སམ་ཅི།';

  @override
  String get useOpeningBook_Detail =>
      'རླུང་མཐུད་དཔར་ཆས་གཞི་ཁྲིད་དོན་ཐོག་ནས་མི་སྐྱོན་པའི་རེའུ་མིག་པ་སྔོན་ལམ་སྤྱིར་བཏང་གི་སྒྲིག་བརྒྱུད་དང་འབྲེལ་བཞིན་རྒྱུ་མཚན་འདི་ད་ལྟ་བུ་ཚད་ལྷག་མཐའ་གཞི་ཁྲིད་རྣམ་པ་རྣམས་ལ་རྩིས་ཐོག་མིན།';

  @override
  String get showAdvantageGraph => 'ངོས་ཕན་རི་མོ་སྟོན།';

  @override
  String get advantageGraphHint =>
      'དཔེ་དོན་གྲངས་ཀྱི་རི་མོ་ནི AI གིས་འགོ་བཙུགས་རྗེས་ཙམ་བྲི་བཏུབ་པར་འགྲུབ། མིའི་རྩོམ་པ་བྱེད་དུས་ནི རི་མོ་བྲི་མི་ཐུབ།';

  @override
  String get removalBasedOnMillCounts =>
      'དབྱེ་མི་གཉིས་ཀྱིས་གང་འདོགས་བཞིན་དུ་གཞི་བཙོད་མི་རུང་། སྤོ་བའི་ལག་ཁྱེད་ཀྱིས་མི་འདོགས་བརྗེད་རིས་གྱི་དོན་ལ་གཞི་བཙོད་བྱེད་པ་ཡིན་པས།';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'དབྱེ་མི་གཉིས་ཀྱིས་གང་འདོགས་བཞིན་དུ་གཞི་བཙོད་མི་རུང་། སྤོ་བའི་ལག་ཁྱེད་ཀྱིས་མི་འདོགས་བརྗེད་རིས་གྱི་དོན་ལ་གཞི་བཙོད་བྱེད་པ་ཡིན་པས། གང་གི་གར་གཅིག་གིས་ཨང་ཚད་མཐོ་དང་མཐུན་པ་ཡིན་ན་མཉམ་དུ་ཨང་གྲངས་གཅིག་ཏུ་གཞི་བཙོད་བྱེད་དགོས། གང་གི་གར་གཅིག་གིས་བརྡ་སྤྲོད་མི་ལས་མང་བ་ཚུགས་ན་ཁྱེད་ཀྱིས་དགུན་འདྲེན་ཞིག་གཅིག་ཤོམ་སོ། གང་གི་གར་གཅིག་གིས་མི་འདོགས་ཡོད་ན་ཁྱེད་ཀྱིས་གཉིས་པ་གཉིས་སུ་གཞི་བཙོད་པ་ཞིག་བྱུང་། གང་གི་གར་ཁོ་ན་གིས་མི་འདོགས་སྒྲིག་དགོས་ན་ཁྱེད་ཀྱིས་གཅིག་གྱི་ཚིག་ཆ་གཞི་བཙོད་མི།';

  @override
  String get elfilja => 'ཨེལ་ཧིལ་ཇ་';

  @override
  String get tipSelectOwnPiece => 'ཁྱོད་ཀྱི་རྩེ་ཆས་གཅིག་གདམ་ཐོག་རོགས་གནང་།';

  @override
  String get notYourTurn => 'ཁྱེད་ཀྱི་བདག་པོ་མིན།';

  @override
  String get annotationToolbarBackgroundColor =>
      'བརྗོད་གཞི་སྒྲོམ་གྱི་རྒྱབ་ལྗོངས་ཚོས།';

  @override
  String get annotationToolbarIconColor => 'བརྗོད་གཞི་སྒྲོམ་གྱི་རིས་རྟགས་ཚོས།';

  @override
  String get isAnnotationToolbarShown => 'བརྗོད་གཞི་སྒྲོམ་སྟོན་པ།';

  @override
  String get enterAnnotationMode => 'བརྗོད་གཞི་རྣམ་པ་ནང་འཛུལ།';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'ཁྱེད་ཀྱིས་བརྗོད་གཞི་ཡོངས་རྫོགས་བསུབ་འདོད་དམ།';

  @override
  String get llmPromptCopiedToClipboard =>
      'LLM བརྡ་སྐུལ་གྱི་སྦྱར་གནས་ནང་བཀོད་པ།';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'འབྲེལ་མཐུད་མི་ཆོག་པ། ཞབས་ཞུ་ཆས་ལས་མེད་པ་ཡིན་འདུག';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'མཐོང་རྒྱུ་ལེགས་གྲུབ། འབྲེལ་མཐུད་བསྒུག་པ།...';

  @override
  String get noLanConnection => 'LAN འབྲེལ་མཐུད་མེད།';

  @override
  String get takeScreenshot => 'དཔར་རིས་ལེན་པ།';

  @override
  String get disconnectedFromOpponent => 'མགྲོན་པོ་དང་འབྲེལ་མཐུད་བཅད་པ།';

  @override
  String get takeBackRequest => 'སླར་འཛུད་ཞུ་བ།';

  @override
  String get nothingToShow => 'སྟོན་རྒྱུ་མེད།';

  @override
  String get stopHosting => 'ཞབས་ཞུ་མཛད་པ་མཚམས་འཇོག';

  @override
  String get connectionResetByPeer => 'མགྲོན་པོས་འབྲེལ་མཐུད་སླར་གསོ་བྱས་པ།';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'སྙིང་སྤྱོད་སྐར་ཆ་མཚམས་འཇོག་པས་འབྲེལ་མཐུད་བརླག་པ། ཡང་བསྐྱར་འབྲེལ་མཐུད་བྱོས།';

  @override
  String get startHosting => 'ཞབས་ཞུ་མཛད་པ་འགོ་འཛུགས།';

  @override
  String get restartRequestRejected => 'སླར་འགོ་ཞུ་བ་མི་ཆོག་པ།';

  @override
  String get notConnectedToLanOpponent => 'LAN མགྲོན་པོ་དང་འབྲེལ་མཐུད་མེད།';

  @override
  String get llmPrompt => 'LLM བརྡ་སྐུལ།';

  @override
  String get gameRestarted => 'རྩེད་མོ་སླར་འགོ་བཙུགས་པ།';

  @override
  String get takeBackRejected => 'སླར་འཛུད་མི་ཆོག་པ།';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'ཁྱེད་ཀྱིས་རྩེད་མོ་འདི་བཀོད་འདོད་དམ།';

  @override
  String get opponentResignedYouWin => 'མགྲོན་པོས་བཀོད་པ། ཁྱེད་རྒྱལ་ལོ།';

  @override
  String get clearAllAnnotations => 'བརྗོད་གཞི་ཡོངས་རྫོགས་བསུབ་པ།';

  @override
  String get connectedWaitingForOpponentSMove =>
      'འབྲེལ་མཐུད་བྱས་པ། མགྲོན་པོའི་སྤོ་བཤུད་བསྒུག་པ།...';

  @override
  String get networkStatusDisconnected => 'དྲ་རྒྱའི་གནས་ཚུལ། འབྲེལ་མཐུད་བཅད་པ།';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'སླར་འཛུད་ཞུ་བ་མགྲོན་པོ་ལ་སྐུར་བ།';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'མགྲོན་པོས་རྩེད་མོ་ལས་ཕྱིར་ལོག་པ་ཡིན་འདུག';

  @override
  String get connectedToHostSuccessfully =>
      'ཞབས་ཞུ་ཆས་ལ་ལེགས་འགྲུབ་འབྲེལ་མཐུད་བྱས་པ།';

  @override
  String get connectionLostHeartbeatTimeout =>
      'འབྲེལ་མཐུད་བརླག་པ། སྙིང་སྤྱོད་སྐར་ཆ་མཚམས་འཇོག';

  @override
  String get noHostDiscovered => 'ཞབས་ཞུ་ཆས་མཐོང་རྒྱུ་མེད།';

  @override
  String get confirmResignation => 'བཀོད་པ་ངོས་ལེན།';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'རྩེད་མོ་ཞབས་ཞུ་མཛད་པ་འགོ་འཛུགས་པ། རྩེད་མོ་པ་ཚུ་ནང་འཛུལ་བསྒུག་པ།...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'འབྲེལ་མཐུད་སྐར་ཆ་མཚམས་འཇོག དྲ་རྒྱའི་འབྲེལ་མཐུད་མི་བརྟན་པ།';

  @override
  String get noLlmPromptAvailable => 'LLM བརྡ་སྐུལ་མེད།';

  @override
  String get youResignedGameOver => 'ཁྱེད་ཀྱིས་བཀོད་པ། རྩེད་མོ་མཇུག་སྒྲིལ།';

  @override
  String get serverIp => 'ཞབས་ཞུ་ཆས་ཀྱི IP';

  @override
  String get confirmClear => 'བསུབ་པ་ངོས་ལེན།';

  @override
  String get opponentSTurn => 'མགྲོན་པོའི་བདག་པོ།';

  @override
  String get waitingAClientConnection => 'ཞབས་ཞུ་ཆས་ཀྱི་འབྲེལ་མཐུད་བསྒུག་པ།...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'སླར་འཛུད་ཞུ་བ་མི་ཆོག་པ་ཡང་ན་ཕམ་པ།';

  @override
  String get addText => 'ཡིག་རྐྱང་ཁ་སྣོན།';

  @override
  String get exitAnnotationMode => 'བརྗོད་གཞི་རྣམ་པ་ལས་ཕྱིར་འབུད།';

  @override
  String get typeYourAnnotation => 'ཁྱེད་ཀྱི་བརྗོད་གཞི་བྲིས།';

  @override
  String get attemptingToReconnect => 'ཡང་བསྐྱར་འབྲེལ་མཐུད་བྱེད་བཞིན་པ།...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'སླར་འགོ་ཞུ་བ་སྐུར་བ། མགྲོན་པོའི་ལན་གསལ་བསྒུག་པ།...';

  @override
  String get serverIsStopped => 'ཞབས་ཞུ་ཆས་མཚམས་འཇོག་པ།';

  @override
  String get restartRequest => 'སླར་འགོ་ཞུ་བ།';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'ཁྱེད་ཀྱི་བདག་པོ་མིན་པའི་སྐབས་སུ་སླར་འཛུད་ཞུ་མི་ཆོག';

  @override
  String get takeBackAccepted => 'སླར་འཛུད་ཆོག་པ།';

  @override
  String get localNetworkSettings => 'ཉེ་འདབས་དྲ་རྒྱའི་སྒྲིག་འགོད།';

  @override
  String get reconnectedSuccessfully => 'ཡང་བསྐྱར་འབྲེལ་མཐུད་ལེགས་གྲུབ།';

  @override
  String get failedToSaveImageToGallery => 'དཔར་རིས་དཔེ་མཛོད་ནང་ཉར་མི་ཐུབ་པ།';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'མགྲོན་པོས་རྩེད་མོ་སླར་འགོ་ཞུ་བ་བྱས་པ། ཁྱེད་ཀྱིས་ཆོག་གམ།';

  @override
  String get yourTurn => 'ཁྱེད་ཀྱི་བདག་པོ།';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'ཡང་བསྐྱར་འབྲེལ་མཐུད་མི་ཐུབ། རྩེད་མོ་སླར་འགོ་བཙུགས་རོགས།';

  @override
  String get host => 'ཞབས་ཞུ་ཆས།';

  @override
  String get join => 'ནང་འཛུལ།';

  @override
  String get port => 'འདྲེད་སྒོ།';

  @override
  String get invalidIpAddress => 'ནུས་མེད IP ཁ་བྱང་།';

  @override
  String get invalidPort => 'ནུས་མེད་འདྲེད་སྒོ།';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'འབྲེལ་མཐུད་བྱེད་བཞིན་པ། ཚོད་ལྟ། $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'འབྲེལ་མཐུད་མི་ཐུབ་པ། $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'ཞབས་ཞུ་མཛད་པ་འགོ་འཛུགས་མི་ཐུབ་པ། $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'ཞབས་ཞུ་ཆས་མཐོང་རྒྱུ། $ip:$port';
  }

  @override
  String get stop => 'མཚམས་འཇོག';

  @override
  String get discover => 'མཐོང་རྒྱུ།';

  @override
  String get connect => 'འབྲེལ་མཐུད།';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'ཞབས་ཞུ་ཆས་འབྲེལ་཮ཐུད་བྱས་པ། $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'མཐོང་རྒྱུ་བྱེད་བཞིན་པ། $seconds སྐར་ཆ།';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'ཡང་བསྐྱར་འབྲེལ་཮ཐུད་བྱེད་བཞིན་པ། ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'འབྲེལ་཮ཐུད་བྱས་པ།';

  @override
  String get delete => 'བསུབ་པ།';

  @override
  String get ancientEgypt => 'ཨི་ཇིབཏ་ནང་དུས་རབས།';

  @override
  String get gothicIce => 'གོ་ཐིག་གངས།';

  @override
  String get riceField => 'འབྲུ་ས་ཞིང་།';

  @override
  String get chinesePorcelain => 'རྒྱ་ནག་གི་རྫ་རྫུན།';

  @override
  String get desertDusk => 'བྱེ་ཐང་གི་སྙིང་སྟོད།';

  @override
  String get precisionCraft => 'བྱང་ཆུབ་སྒྱུ་རྩལ།';

  @override
  String get folkEmbroidery => 'མི་དམངས་ཀྱི་འབུར་འབུར།';

  @override
  String get carpathianHeritage => 'ཀར་པ་ཐི་ཡན་གྱི་སྲོལ་རྒྱུད།';

  @override
  String get imperialGrandeur => 'རྒྱལ་པོའི་མངའ་ཐང་།';

  @override
  String get bohemianCrystal => 'བོ་ཧེ་མི་ཡན་གྱི་ཤེལ་སྒོ།';

  @override
  String get savannaSunrise => 'ས་ཝན་ནའི་ཉི་ཤར།';

  @override
  String get harmonyBalance => 'མཐུན་པའི་སྙོམས་པ།';

  @override
  String get cinnamonSpice => 'ཤིང་ཚེར་གྱི་སྦྱོར་བ།';

  @override
  String get anatolianMosaic => 'ཨ་ན་ཏོ་ལི་ཡན་གྱི་མོ་སེའི་ཀ།';

  @override
  String get carnivalSpirit => 'ཀར་ནི་ཝལ་གྱི་སེམས་ཉིད།';

  @override
  String get custom => 'རང་བཟོས་';

  @override
  String get spiceMarket => 'སྣུམ་ཉོ་བའི་བོད་ཀྱི་གསར་འགྱུར།';

  @override
  String get swipeToRevealTheDrawer => 'ཁ་ཤོག་བཀྲམ་ནས་ཤོག་བཤུད་བྱོས།';

  @override
  String get showGameInfoOnScreenshots =>
      'གནས་ཚུལ་གྱི་གྲོགས་མཐུད་སྐོར་ཁ་བྱང་ལ་མངོན་འཁོད་བྱེད།';

  @override
  String get humanMoveTime => 'མིའི་འགུལ་སྐྱོད་དུས་ཚོད་ཚད་བཀག';

  @override
  String get noTimeLimitForHumanMoves =>
      'མིའི་འགུལ་སྐྱོད་ལ་དུས་ཚོད་ཚད་བཀག་མེད།';

  @override
  String get timeoutLoseWillBeApplied =>
      'མིའི་རྩེད་མོ་བར་དུས་ཚོད་འདས་ན་ཕམ་ཁ་བརྩི་རྒྱུ་རེད།';

  @override
  String get identifyingBoard => 'གདོང་ལེན་བྱེད་གི་ཡིན…';

  @override
  String get youCanEnterAnyModelName =>
      'ཁྱེད་རང་གིས་གཞི་མེད་པའི་མོ་ཌེལ་མིང་གནང་རོགས་པ།';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'ས་ཁབ་འདི་རིས་མཐུད་བྱེད་ཡིན། FEN ང་ལག་ལེན་ཀླི་པར་ཕྱི་བཞག་ཡིན།';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'ཞུ་བ།: གདོང་ལ་རོགས་པོ་གྱི་ཡྙན་ཚིག་འཇོག་ཉོན།';

  @override
  String get llmPromptTemplate => 'LLM སྐུལ་བཤད་རིས་ཆ།';

  @override
  String get noValidBoardDetected => 'བདེན་པའི་ས་ཁབ་མེད།';

  @override
  String get selectingImageFromAlbum =>
      'ཨིག་མི་བརྙན་ལས་ཡྙན་ཚིག་གདངས་གཏོང་གི་ཡིན…';

  @override
  String get configurePromptTemplate => 'སྐུལ་བཤད་རིས་ཆ་གསར་བཟོ།';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'LLM བསྡུ་རིས་ཀྱིས་སྐུལ་བཤད་རིས་ཆ་གསར་བཟོ།';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'སྟོང་གདོང་ལས FEN བཟོ་མི་བཞག་ཡིན།';

  @override
  String get outputInCurrentLanguage => 'ད་ལོན་སྐད་ཡིག་ནང་འགྲུབ།';

  @override
  String get commonBaseUrls => 'མཐོང་གཏོགས་གྲིགས་པའི Base URLs';

  @override
  String get viewCommonModels => 'མཐོང་གཏོགས་གྲིགས་པའི་མོ་ཌེལ་མིང་ལྟ་བུ།';

  @override
  String get recognitionParametersUpdated => 'བརྒྱབ་གནང་ཁྲིད་སྟོང་བསྡུས་ཡོད།';

  @override
  String get whiteSMove => 'དཀྱིལ་དཀར་གི་འགུས་པ།';

  @override
  String get resetToDefaults => 'སྔོན་རིམ་ལ་གཏོང་བཞག།';

  @override
  String get photoShoot => 'ཡྙན་ཚིག་ཐབས་བཟོ།';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'སྟོང་གདོང་གིས་ས་ཁབ་རིས་མཐུད་བྱེད་མི་བཞག།';

  @override
  String get llmPromptContent => 'LLM སྐུལ་བཤད་ཐིག་ཡིག།';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM གཏོང་སྤྲོད་མི་བཟོ་ཡིན། ཁྱེད་རང་གི་སྒྲིག་སྒྲིག་ཚད་ལྟ་བཤེར་རོགས།';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'provider, model, API Key དང Base URL གཏོང་རོགས།';

  @override
  String get llmConfiguration => 'LLM སྒྲིག་སྒྲིག།';

  @override
  String get configureLlmProvider => 'LLM provider གཏོང་རོགས།';

  @override
  String get llmPromptTemplateHeader => 'LLM སྐུལ་བཤད་རིས་ཆའི་མགོ་འགྱུར།';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'ཡྙན་ཚིག་ནང་རྡོག་མི་བཙུགས། ལོག་གཏོང་རོགས།';

  @override
  String get recognizeBoardFromImage => 'ཡྙན་ཚིག་ནས་གདོང་ལེན་བྱེད།';

  @override
  String get viewTips => 'བསམ་ཚུལ་ལྟ།';

  @override
  String get applyToBoard => 'ས་ཁབ་ལ་རིས་མཐུད།';

  @override
  String get adjustBoardArea => 'ས་ཁབ་ཁ་སྐྱང་བྱེད།';

  @override
  String get viewCommonUrls => 'མཐོང་གཏོགས་གྲིགས་པའི URLs ལྟ།';

  @override
  String get colorAnalysisFailed => 'གར་བསྡུ་རིས་མི་བཞག།!';

  @override
  String get analyzingGameBoardImage => 'ས་ཁབ་ཡྙན་ཚིག་བསྡུ་རིས་གཏོང་གི་ཡིན…';

  @override
  String get selectFromAlbum => 'ཨིག་མི་བརྙན་ལས་གདངས།';

  @override
  String get noBoardPointDetected => 'གདོང་ཐག་ཚལ་མེད།!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'གང་གིས་གདོང་མེད་སྣུམ་ན་, སྔོན་རིམ་རིས་ཆ་གཏོགས་གྲུབ།';

  @override
  String get llmConfig => 'LLM སྒྲིག་སྒྲིག།';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'སྐུལ་བཤད་རིས་ཆ་སྔོན་རིམ་ལ་གཏོང་གི་རེད་པས།';

  @override
  String get llmPromptTemplateFooter => 'LLM སྐུལ་བཤད་རིས་ཆའི་མཚན་དོན།';

  @override
  String get loadingResponse => 'ལན་གཏོང་གི་ཡིན…';

  @override
  String get applyThisResultToBoard => 'གཏེར་འདི་ས་ཁབ་ལ་རིས་མཐུད།';

  @override
  String get takingPicture => 'ཡྙན་ཚིག་ཐབས་བཞག་གི་ཡིན…';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'འཕུར་གདོང་ལྡེབ་ཡྙན་ཚིག་བཀོད་གཏོང་རོགས།';

  @override
  String get identificationResults => 'གདོང་ལེན་བྱེད་གྲུབ་འབྱོར།';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'འགུས་པའི་ལམ་བསྡུ་རིས་བྱེད་དང་དོན་གསུམ་གནང་རོགས།';

  @override
  String get getApiKey => 'API Key ལེན་རོགས།';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'སྟོང་གདོང་གནང་བའི་ཆོས་ལ་བརྒྱབ་སྲུང་མི་ཡིན།';

  @override
  String get boardRecognitionResult => 'ས་ཁབ་གདོང་གནང་བའི་འབྱོར།';

  @override
  String get askLlm => 'LLM ལ་འདོན་གནང་རོགས།';

  @override
  String get boardDetectionFailed => 'ས་ཁབ་གཏོང་མི་འབྱུག།!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'གདོང་ཐག་ཚལ་མེད་དུས་རྡོག་མ་བརྒྱབ།!';

  @override
  String get copyFen => 'FEN མཐར་ཕྱི་བཞག།';

  @override
  String get commonlyUsedModels => 'མཐོང་གཏོགས་གྲིགས་པའི་མོ་ཌེལ་མིང་འདེམས་པ།';

  @override
  String get apiKeyOptional => 'API Key (དེ་ལ་འཇིགས་མེད)';

  @override
  String get noImageSelected => 'ཡྙན་ཚིག་བཀོད་མ་ཡིན།';

  @override
  String get blackSMove => 'དཀྱིལ་ནུབ་གི་འགུས་པ།';

  @override
  String get llm => 'ཆེན་པོའི་སྐད་ཡིག་མཛོད';

  @override
  String get llmProvider => 'བྱིན་སྤྲོད་པ་';

  @override
  String get baseUrl => 'གཞི་རྟགས URL';

  @override
  String get model => 'དཔེ་གཞི';

  @override
  String get temperature => 'སྤུ་དེབ';

  @override
  String get llmCommandReceivedProcessing =>
      'བཀོད་འདོད་བྱས་ཡོད! AI འགྲོ་སྒྲིག་བྱེད་པར་འཁོད...';

  @override
  String get llmDeepThinkingWait => 'ཞིབ་འཆད་འདུག གནང་བ་ལོག་ནས་གསོལ...';

  @override
  String get llmPresentingSoon => 'མགོན་མཐུད་དུས་ལྟར་བསྟན་རྒྱུ...';

  @override
  String get recognitionParameters => 'ངེས་འཛིན་གཞི་ཁུངས།';

  @override
  String get adjustParamsDesc =>
      'ངེས་འཛིན་ཡང་དག་པ་ལེགས་པར་བཟོ་ནས་གཞི་ཁུངས་བསྒྱུར་བཅོས།';

  @override
  String get saveParameters => 'གཞི་ཁུངས་ཉར་ཚགས།';

  @override
  String unableToStartImageRecognition(String error) {
    return 'པར་ངེས་འཛིན་འགོ་བཙུགས་ཐུབ་མེད་: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'པར་ངེས་འཛིན་ཕན་ཚུན་བྱས་མ་ཐུབ་: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'དཀར $whiteCount དང་ ནག $blackCount སྡོམ་ལ་གཞི་རིམ་བཙུགས་ཡོད།';
  }

  @override
  String get fenCopiedToClipboard => '(FEN ངོས་དེབ་ལ་འདྲ་བཤུས་ཡོད།)';

  @override
  String recognitionFailed(String error) {
    return 'ངེས་འཛིན་ཕན་ཚུན་བྱས་མ་ཐུབ་: $error';
  }

  @override
  String get myRating => 'ངའི་ ደረጃརྟགས།';

  @override
  String get gamesPlayed => 'རྩེད་ཡོད་པའི་རྩེད་ཐེངས།';

  @override
  String get wins => 'རྒྱལ་ཁ།';

  @override
  String get losses => 'ཕམ་པ།';

  @override
  String get draws => 'འདྲ་འདྲ།';

  @override
  String get lastUpdated => 'ཆེས་གསར་དུ་བསྐྱར་བཅོས་བྱས་པ།';

  @override
  String get format => 'རྣམ་བཞག:';

  @override
  String get resetStatistics => 'བསྡོམས་རྩིས་སླར་སྒྲིག་བྱེད་པ།';

  @override
  String get drawRate => 'འདྲ་འདྲའི་བརྒྱ་ཆ།';

  @override
  String get lossRate => 'ཕམ་པའི་བརྒྱ་ཆ།';

  @override
  String get aiStatistics => 'AI བསྡོམས་རྩིས།';

  @override
  String get enableStatistics => 'བསྡོམས་རྩིས་འགོ་འཛུགས་པ།';

  @override
  String get enableStatistics_Detail =>
      'འགོ་བཙུགས་ན་རྩེད་འབྲས་བསྡོམས་རྩིས་ནང་བཀོད་འཇུག་བྱེད་རྒྱུ་རེད། འོན་ཀྱང་ཕྱིར་འཐེན་བྱས་པའི་རྩེད་མོ་རྣམས་བཀོད་འཇུག་མི་བྱེད། གལ་ཏེ་སྤྱོད་མཚམས་བཞག་ན་བསྡོམས་རྩིས་བསྡུ་རུབ་བྱེད་མཚམས་འཇོག་རྒྱུ་རེད།';

  @override
  String get thisWillResetAllGameStatistics =>
      'འདིས་རྩེད་མོའི་བསྡོམས་རྩིས་ཡོད་ཚད་སླར་སྒྲིག་བྱེད་རྒྱུ་རེད། བྱ་སྤྱོད་འདི་ཕྱིར་འཐེན་བྱེད་མི་ཐུབ།';

  @override
  String get boardInnerRingSize => 'སྒོ་སྦེལ་ནང་འཁོར་ཚད';

  @override
  String get boardShadowEnabled => 'ཤོག་སྒོར་གྱི་གནམ་གྲིབ་';

  @override
  String get trapAwareness => 'Trap awareness';

  @override
  String get trapAwarenessDescription =>
      'Highlight trap moves with bold circles and arrows during analysis.';

  @override
  String trapExists(String trapMoves) {
    return 'Trap exists. Trap moves: $trapMoves';
  }

  @override
  String get custodianCapture => 'བར་ཐག་འཛིན་བཟུང་།';

  @override
  String get custodianCaptureDescription =>
      'ཁྱེད་རང་གི་ཁ་གཏད་ཀྱི་ཆ་ཤས་གཅིག་ཁྱེད་རང་གི་ཐིག་ཐད་ཀའི་ནང་དུ་བཀག་ནས་དེ་འཛིན་དགོས།';

  @override
  String get custodianCaptureEnable =>
      'ཕྱོགས་གཅིག་ནས་འཛིན་བཟུང་བྱེད་དུ་འཇུག་པ།';

  @override
  String get interventionCapture => 'བར་འདུམ་འཛིན་བཟུང་།';

  @override
  String get interventionCaptureDescription =>
      'ཁྱེད་རང་གི་ཁ་གཏད་ཀྱི་ཆ་ཤས་གཉིས་ཀྱི་བར་གྱི་སྟོང་ཆ་དེ་ལ་སྤོ་ནས་དེ་གཉིས་ཀ་འཛིན་ཐུབ།';

  @override
  String get interventionCaptureEnable => 'བར་འདུམ་བཀག་ཉར་བྱེད་ཆོག་པ།';

  @override
  String get leapCapture => 'མཆོང་རྒྱག་གི་འཛིན་བཟུང་།';

  @override
  String get leapCaptureDescription =>
      'ཉེ་འགྲམ་གྱི་ཁ་གཏད་ཅིག་གི་སྟེང་ནས་མཆོངས་ནས་དེ་ལས་ལྷག་པའི་སྟོང་ཆ་དེ་ལ་མཆོངས་ནས་འཛིན་བཟུང་བྱས།';

  @override
  String get leapCaptureEnable => 'མཆོང་སྐྱོད་ལ་འཛིན་བཟུང་བྱེད་དུ་འཇུག་པ།';

  @override
  String get captureApplicableLines => 'བཀོལ་སྤྱོད་བྱེད་ཐུབ་པའི་གྲལ་ཐིག་།';

  @override
  String get captureSquareEdges => 'ཐང་ཆེན་གྱི་མཐའ་མཚམས།';

  @override
  String get captureCrossLines => 'གྲུ་བཞི་བརྒལ་བའི་ཐིག་ལམ་བརྒྱུད་དེ།';

  @override
  String get captureDiagonalLines => 'གྲུ་བཞི་བརྒལ་བའི་ཟུར་ཐིག་བརྒྱུད་ནས།';

  @override
  String get captureExecutionPhases => 'ལག་བསྟར་དུས་རིམ།';

  @override
  String get capturePiecesCondition =>
      'ལྷག་མའི་དངོས་པོ་ལ་བརྟེན་ནས་འགུལ་སྐྱོད་བྱེད་པའི་དུས་རིམ་གྱི་སྐབས་སུ་ཡོད་ཚད།';

  @override
  String get capturePiecesConditionUnlimited => 'བཀག་སྡོམ་མེད་པ།';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'ཁྱེད་ལ་ཆ་ཤས་གསུམ་ཡང་ན་ཉུང་བའི་སྐབས་སུ་ཐོབ་ཐུབ།';
}
