// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Bengali Bangla (`bn`).
class SBn extends S {
  SBn([String locale = 'bn']) : super(locale);

  @override
  String get appName => 'মিল';

  @override
  String get welcome => 'স্বাগত';

  @override
  String get yes => 'হ্যাঁ';

  @override
  String get no => 'না';

  @override
  String get game => 'গেম';

  @override
  String get humanVsAi => 'হিউম্যান বনাম এআই';

  @override
  String get humanVsHuman => 'হিউম্যান বনাম মানব';

  @override
  String get aiVsAi => 'এআই বনাম এআই';

  @override
  String get humanVsCloud => 'হিউম্যান বনাম মেঘ';

  @override
  String get humanVsLAN => 'হিউম্যান বনাম ল্যান';

  @override
  String get testViaLAN => 'ল্যানের মাধ্যমে পরীক্ষা করুন';

  @override
  String get move => 'সরান';

  @override
  String get showMoveList => 'সরানো তালিকা';

  @override
  String get moveList => 'সরানো তালিকা';

  @override
  String get noGameRecord => 'কোন রেকর্ড নেই';

  @override
  String get ok => 'ঠিক আছে';

  @override
  String get confirm => 'কনফার্ম';

  @override
  String get cancel => 'বাতিল';

  @override
  String get tipSelectWrong => 'ভুল টুকরা নির্বাচন করুন।';

  @override
  String get tipPlace => 'আপনার টুকরা রাখুন।';

  @override
  String get tipBanPlace => 'আপনি এটি এখানে রাখতে পারবেন না।';

  @override
  String get tipPlaced => 'আপনি দাবার টুকরা স্থাপন.';

  @override
  String get tipRemove => 'একটি টুকরো সরান।';

  @override
  String get tipBanRemove => 'আপনি এটি অপসারণ করতে পারবেন না।';

  @override
  String get tipRemoved => 'আপনি প্রতিপক্ষের টুকরা মুছে ফেলা.';

  @override
  String get tipMove => 'এক টুকরো সরান।';

  @override
  String get tipCannotPlace => 'আপনি এখানে আপনার টুকরা রাখতে পারবেন না।';

  @override
  String get tipCannotMove => 'আপনি এখানে আপনার টুকরা সরাতে পারবেন না।';

  @override
  String get tipMill => 'মিল! আপনার প্রতিপক্ষের টুকরো নিন।';

  @override
  String get tipContinueMill => 'আপনার প্রতিপক্ষের অংশটি নেওয়া চালিয়ে যান।';

  @override
  String get tipSelectOpponentsPiece =>
      'আপনার প্রতিপক্ষের একটি অংশ নির্বাচন করুন।';

  @override
  String get tipCannotRemovePieceFromMill =>
      'আপনি কল থেকে কোনও টুকরো অপসারণ করতে পারবেন না।';

  @override
  String get tipCanMoveOnePoint => 'একটি টুকরা 1 পয়েন্ট সরানো যেতে পারে।';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'আপনি আপনার প্রতিপক্ষের টুকরো স্থানান্তর করতে পারবেন না।';

  @override
  String get tipSelectPieceToMove => 'সরানোর জন্য আপনার টুকরাটি নির্বাচন করুন।';

  @override
  String get tipHaveThreePiecesLeft => 'আপনার তিনটি টুকরা বাকি আছে।';

  @override
  String get tipCanMoveToAnyPoint =>
      'আপনি আপনার পছন্দের যে কোন পয়েন্টে যেতে পারেন।';

  @override
  String tipToMove(Object player) {
    return '$player সরাতে।';
  }

  @override
  String get whiteWin => 'প্লেয়ারের 1 জয়!';

  @override
  String get blackWin => 'খেলোয়াড়ের জয় 2!';

  @override
  String get won => 'জিতেছে';

  @override
  String get lost => 'নিখোঁজ';

  @override
  String get thinking => 'ভাবছে…';

  @override
  String get newGame => 'নতুন খেলা';

  @override
  String get importGame => 'গেম আমদানি করুন';

  @override
  String get exportGame => 'এক্সপোর্ট গেম';

  @override
  String get gameImported => 'গেম আমদানি করা হয়েছে।';

  @override
  String cannotImport(Object invalidMove) {
    return 'আমদানি করা যাবে না $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'চল এবং নিয়ম মেলে না।';

  @override
  String get pleaseWait => 'অনুগ্রহপূর্বক অপেক্ষা করুন.';

  @override
  String get restartGame => 'বর্তমান খেলা আবার চালু করবেন?';

  @override
  String get restart => 'আবার শুরু';

  @override
  String get gameStarted => 'গেমটি শুরু হয়েছে, দয়া করে রাখুন.';

  @override
  String get analyzing => 'বিশ্লেষণ করা হচ্ছে…';

  @override
  String error(Object message) {
    return 'ত্রুটি: $message';
  }

  @override
  String get winRate => 'উইন রেট';

  @override
  String get score => 'স্কোর:';

  @override
  String get white => 'খেলোয়াড় ঘ';

  @override
  String get black => 'প্লেয়ার 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player টুকরা সংখ্যা তিনের কম।';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player পদত্যাগ.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player যাওয়ার কোন উপায় নেই।';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'বোর্ড পূর্ণ, এবং $player যাওয়ার কোন উপায় নেই।';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'সময় শেষ, $player হারিয়ে গেছে।';
  }

  @override
  String get drawReasonRule50 =>
      'চলমান পর্যায়ে, শেষের নির্দিষ্ট সংখ্যাটিতে কোনও টুকরো সরানো হয়নি।';

  @override
  String get drawReasonBoardIsFull => 'বোর্ডটি পূর্ণ হওয়ায় এটি একটি অঙ্কন।';

  @override
  String get drawReasonThreefoldRepetition =>
      'ত্রিগুণ পুনরাবৃত্তি হওয়ার কারণে এটি একটি অঙ্কন।';

  @override
  String get gameOverUnknownReason => 'খেলা শেষ! অজানা কারন.';

  @override
  String get gameOver => 'খেলা শেষ';

  @override
  String get youWin => 'তুমি জিতেছ! অভিনন্দন!';

  @override
  String challengeHarderLevel(int level) {
    return 'কঠিন স্তর চ্যালেঞ্জ? নতুন লেভেল হবে লেভেল $level!';
  }

  @override
  String get youLose => 'তুমি হেরেছ!';

  @override
  String get analyze => 'বিশ্লেষণ করুন';

  @override
  String get about => 'সম্পর্কিত';

  @override
  String version(Object versionNumber) {
    return 'সংস্করণ: $versionNumber';
  }

  @override
  String get thanks => 'ধন্যবাদ';

  @override
  String get settings => 'সেটিংস';

  @override
  String get options => 'বিকল্পগুলি';

  @override
  String get generalSettings => 'সাধারণ সেটিংস';

  @override
  String get skillLevel => 'কাঠিন্যের মাত্রা';

  @override
  String get moveTime => 'এআই চিন্তা সময়';

  @override
  String get difficulty => 'অসুবিধা';

  @override
  String get playSounds => 'শব্দের প্রভাব';

  @override
  String get playSoundsInTheGame => 'গেমটিতে শব্দ বাজান';

  @override
  String get keepMuteWhenTakingBack => 'ফিরে যাওয়ার সময় নিঃশব্দ থাকুন';

  @override
  String get tone => 'টোন';

  @override
  String get whoMovesFirst => 'প্রথম পদক্ষেপ';

  @override
  String get human => 'মানব';

  @override
  String get ai => 'এআই';

  @override
  String get alternate => 'বিকল্প';

  @override
  String get isAutoRestart => 'গেম শেষ হয়ে গেলে গেমটি অটো-রিস্টার্ট';

  @override
  String get isAutoChangeFirstMove => 'অটো চেঞ্জ প্রথম পদক্ষেপ';

  @override
  String get shufflingEnabled => 'এলোমেলো পদক্ষেপ';

  @override
  String get misc => 'বিবিধ';

  @override
  String get rules => 'বিধি';

  @override
  String get piecesCount => 'প্রতিটি খেলোয়াড়ের টুকরো সংখ্যা';

  @override
  String get piecesCount_Detail => 'প্রতিটি খেলোয়াড় কত টুকরা আছে?';

  @override
  String get flyPieceCount => 'উড়ন্ত টুকরা সংখ্যা';

  @override
  String get flyPieceCount_Detail =>
      'ফ্লাইং সক্ষম করা থাকলে, যখন কোনও খেলোয়াড় নির্দিষ্ট টুকরো গণনায় কমে যায়, তার টুকরোটি খেলার বাকি অংশের মতো সংলগ্ন পয়েন্টগুলিতে সীমাবদ্ধ না রেখে যে কোনও অনাকাঙ্ক্ষিত বিন্দুতে চলে যেতে পারে।';

  @override
  String get piecesAtLeastCount => 'অন্তত টুকরা';

  @override
  String get hasDiagonalLines => 'তির্যক রেখা';

  @override
  String get hasDiagonalLines_Detail => 'বোর্ডে চারটি তির্যক লাইন যুক্ত করুন।';

  @override
  String get isDefenderMoveFirst => 'দ্বিতীয় খেলোয়াড় প্রথমে চলে আসে';

  @override
  String get isDefenderMoveFirst_Detail =>
      'খেলোয়াড় যিনি স্থাপনের পর্বে দ্বিতীয় স্থানান্তরিত হয় চলন্ত পর্বে প্রথম স্থানান্তরিত হয়।';

  @override
  String get mayRemoveMultiple => 'বহু-সরান';

  @override
  String get mayRemoveMultiple_Detail =>
      'যদি কোনও খেলোয়াড় একবারে একাধিক মিল বন্ধ করে দেয় তবে তিনি বন্ধ হওয়া মিলের সংখ্যা সরিয়ে ফেলবেন।';

  @override
  String get mayRemoveFromMillsAlways => 'মিলগুলি ধ্বংস করুন';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'ডিফল্টরূপে, খেলোয়াড়কে গঠিত মিল থেকে কোনও টুকরো অপসারণ করার আগে প্রথমে অন্য কোনও টুকরো অপসারণ করতে হবে। সীমাবদ্ধতা অক্ষম করতে এই বিকল্পটি সক্ষম করুন।';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'বোর্ড পূর্ণ হলে দ্বিতীয় প্লেয়ার হেরে যায়';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'বোর্ড স্থাপনের পর্ব শেষে যখন পূর্ণ থাকে, তখন যে পাশটি প্রথমে খেলাটি হারাবে। অন্যথায়, খেলাটি একটি ড্র।';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'কোনও আইনি পদক্ষেপ না হলে হারাবেন';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'খেলোয়াড় হারাবে যদি তার প্রতিপক্ষ তাদের আটকা দেয় যাতে তারা সরানো যায় না। এই বিকল্পটি অক্ষম থাকলে সরানোর জন্য পাশ পরিবর্তন করুন।';

  @override
  String get mayFly => 'উড়ন্ত';

  @override
  String get mayFly_Detail =>
      'যদি কোনও খেলোয়াড়ের কেবল তিন বা চারটি (কনফিগারযোগ্য) টুকরা থাকে তবে তিনি টুকরোটি যে কোনও ফ্রি পয়েন্টে স্থানান্তর করতে পারবেন।';

  @override
  String get nMoveRule => 'এন-মুভের নিয়ম';

  @override
  String get nMoveRule_Detail =>
      'গেমটি অঙ্কিত হয় যদি নির্দিষ্ট কয়েকটি পদক্ষেপে কোনও অপসারণ না ঘটে থাকে।';

  @override
  String get rollback => 'রোলব্যাক';

  @override
  String get pleaseSelect => 'অনুগ্রহ করে নির্বাচন করুন';

  @override
  String get copy => 'কপি';

  @override
  String get moveHistoryCopied => 'ক্লিপবোর্ডে অনুলিপি করা ইতিহাস.';

  @override
  String get help => 'সহায়তা';

  @override
  String get feedback => 'মতামত';

  @override
  String get exit => 'প্রস্থান';

  @override
  String get ruleSettings => 'নিয়ম সেটিংস';

  @override
  String get color => 'রঙ';

  @override
  String get boardColor => 'বোর্ডের রঙ';

  @override
  String get pieceColor => 'পিস রঙ';

  @override
  String get backgroundColor => 'পেছনের রঙ';

  @override
  String get lineColor => 'বোর্ড লাইনের রঙ';

  @override
  String get whitePieceColor => 'প্লেয়ার 1 পিস রঙ';

  @override
  String get blackPieceColor => 'খেলোয়াড় 2 টুকরা রঙ';

  @override
  String get messageColor => 'বার্তার রঙ';

  @override
  String get isPieceCountInHandShown => 'হাতে টুকরো গণনা দেখান';

  @override
  String get isNotationsShown => 'বোর্ডে স্বরলিপিগুলি দেখান';

  @override
  String get isHistoryNavigationToolbarShown =>
      'ইতিহাস নেভিগেশন সরঞ্জামদণ্ড প্রদর্শন করুন';

  @override
  String get display => 'প্রদর্শন';

  @override
  String get boardBorderLineWidth => 'বোর্ড সীমানা প্রস্থ';

  @override
  String get boardInnerLineWidth => 'বোর্ড অভ্যন্তরীণ লাইন প্রস্থ';

  @override
  String get pieceWidth => 'পিস প্রস্থ';

  @override
  String get fontSize => 'অক্ষরের আকার';

  @override
  String get standardNotation => 'ডাব্লুএমডি স্বরলিপি';

  @override
  String get restore => 'পুনরুদ্ধার করুন';

  @override
  String get restoreDefaultSettings => 'সেটিংটি পূর্বাবস্থায় ফিরিয়ে আনুন';

  @override
  String pick(Object element) {
    return 'বাছাই করুন $element';
  }

  @override
  String get info => 'তথ্য';

  @override
  String get hint => 'ইঙ্গিত';

  @override
  String get player => 'প্লেয়ার';

  @override
  String get player1 => 'খেলোয়াড় ঘ';

  @override
  String get player2 => 'প্লেয়ার 2';

  @override
  String get howToPlay => 'কিভাবে খেলতে হবে';

  @override
  String get toPlacePiece =>
      'টুকরোটি রাখার জন্য যে কোনও উপলভ্য বিন্দুতে আলতো চাপুন।';

  @override
  String get toSelectPiece => 'এটি সরানোর জন্য টুকরো ট্যাপ করুন।';

  @override
  String get toMovePiece => 'টুকরোটি সরানোর জন্য সংযুক্ত পয়েন্টে আলতো চাপুন।';

  @override
  String get toRemovePiece => 'অপসারণ করতে প্রতিপক্ষের এক টুকরো ট্যাপ করুন।';

  @override
  String get needToCreateMillFirst =>
      'আপনি একটি টুকরা অপসারণ করার আগে আপনাকে প্রথমে একটি মিল তৈরি করতে হবে।';

  @override
  String get needToPlayWithOwnPieces => 'আপনি আপনার টুকরা সঙ্গে খেলতে হবে।';

  @override
  String get statistics => 'পরিসংখ্যান';

  @override
  String get totalGames => 'মোট গেম';

  @override
  String get results => 'ফলাফল';

  @override
  String get left => 'বাম';

  @override
  String get privacyPolicy => 'গোপনীয়তা নীতি';

  @override
  String get privacyPolicy_Detail_1 =>
      'দয়া করে মনোযোগ সহকারে পড়ুন এবং নিশ্চিত হন যে আপনি এটির সাথে পুরোপুরি বুঝতে পেরেছেন এবং এতে সম্মত হন ';

  @override
  String get privacyPolicy_Detail_2 =>
      '। আপনি যদি এই নীতিতে সম্মত না হন তবে দয়া করে এই অ্যাপ্লিকেশনটি ব্যবহার করবেন না। অ্যাপ্লিকেশন ব্যবহার করে বোঝা যাচ্ছে যে আপনি এই শর্তাদি স্বীকার করেছেন।';

  @override
  String get and => ' এবং ';

  @override
  String get accept => 'গ্রহণ করুন';

  @override
  String get takeBack => 'প্রত্যাহার করা';

  @override
  String get takingBack => 'ফিরে গ্রহণ…';

  @override
  String get waiting => 'অপেক্ষা করছি…';

  @override
  String get stepForward => 'এগিয়ে যান';

  @override
  String get takeBackAll => 'সব ফিরিয়ে দাও';

  @override
  String get stepForwardAll => 'সব এগিয়ে যান';

  @override
  String get moveNow => 'এখনই সরানো';

  @override
  String get done => 'সম্পন্ন.';

  @override
  String get crackMill => 'ক্র্যাক-মিল';

  @override
  String get crackMill_Detail =>
      'যদি কোনও খেলোয়াড়ের মিলগুলিতে কেবল টুকরো থাকে তবে মিলগুলিতে থাকা টুকরোগুলি সরানোর জন্য লক হবে না।';

  @override
  String get animationDuration => 'অ্যানিমেশন সময়কাল';

  @override
  String get none => 'কিছুই না';

  @override
  String get theme => 'থিম';

  @override
  String get helpContent =>
      'গেমটির লক্ষ্য প্রতিপক্ষকে তিনটির চেয়ে কম টুকরো বা কোনও আইনী পদক্ষেপ না রেখেই ছেড়ে দেওয়া।\n\nতৃতীয়বারের মতো কোনও অবস্থান দেখা দিলে বা শেষ 100 (কনফিগারযোগ্য) পদক্ষেপে কোনও অপসারণ না করলে গেমটি স্বয়ংক্রিয়ভাবে টান।\n\nগেমটি তিন ধাপে এগিয়ে যায়:\n\n1. খালি পয়েন্টে টুকরা স্থাপন\n2. সংলগ্ন পয়েন্টগুলিতে টুকরোগুলি সরানো\n৩. (alচ্ছিক পর্ব) খেলোয়াড়কে তিন টুকরো করে হ্রাস করার সময় যে কোনও শূন্য পয়েন্টে টুকরো স্থানান্তর করা\n\nস্থাপন\n\nগেমটি খালি বোর্ডের সাথে শুরু হয়, যা চব্বিশ পয়েন্ট সহ একটি গ্রিড নিয়ে গঠিত। খেলোয়াড়রা তাদের পিসগুলি খালি পয়েন্টগুলিতে রেখে দেয় যতক্ষণ না প্রতিটি প্লেয়ার বোর্ডে সমস্ত টুকরো রাখে। যদি কোনও খেলোয়াড় তার তিনটি টুকরো সোজা রাখতে পারে তবে তার একটি \"মিল\" রয়েছে এবং বোর্ড থেকে তার প্রতিপক্ষের একটি টুকরো অপসারণ করতে পারে।\n\nকিছু নিয়মে খেলোয়াড়দের গঠিত মিল থেকে কোনও টুকরো অপসারণের আগে প্রথমে অন্য কোনও টুকরো অপসারণ করতে হবে।\n\nকিছু নিয়মে স্থাপনের পর্যায়ে আপনি পুনরায় সরানো টুকরোগুলির পয়েন্টগুলিতে টুকরো রাখতে পারবেন না।\n\nসমস্ত টুকরোগুলি একবার ব্যবহার করার পরে, খেলোয়াড়রা চলন্ত মোড় নেয়।\n\nচলন্ত\n\nস্থানান্তরিত করতে, একজন খেলোয়াড় বোর্ড লাইন বরাবর তার একটি টুকরো খালি সংলগ্ন বিন্দুতে সরান। তিনি যদি তা না করতে পারেন তবে তিনি খেলাটি হেরে গেছেন। যে খেলোয়াড় তার বোর্ডের লাইনে তার তিনটি টুকরো সারিবদ্ধ করে তার মিল রয়েছে এবং স্থাপনার পর্যায়ে যেমন তার প্রতিপক্ষের কোনও একটি টুকরো অপসারণ করতে পারে। যে কোনও খেলোয়াড়ের টুকরো টুকরো হয়ে যায়, নতুন কল তৈরির কোনও বিকল্প নেই এবং এইভাবে খেলাটি হেরে যায়। প্রতিপক্ষ যদি তাদের চলতে বাধা দেয় তবে তিন খেলার বেশি খেলোয়াড়ও হারাতে পারেন।\n\nউড়ন্ত\n\nনিয়মের কিছু বৈকল্পিকতায়, একবার কোনও খেলোয়াড়ের কেবল তিনটি টুকরো অবশিষ্ট থাকে, তার টুকরাগুলি কেবল সংলগ্নগুলিই নয়, খালি পয়েন্টগুলিতে উড়তে, হপ করতে বা লাফিয়ে উঠতে পারে।';

  @override
  String get versionInfo => 'ভার্সন সম্পর্কিত তথ্য';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'লাইসেন্স';

  @override
  String get sourceCode => 'সোর্স কোড';

  @override
  String get appVersion => 'অ্যাপ্লিকেশন সংস্করণ';

  @override
  String get general => 'সাধারণ';

  @override
  String get advanced => 'উন্নত';

  @override
  String get placing => 'স্থাপন';

  @override
  String get moving => 'চলন্ত';

  @override
  String get removing => 'সরানো হচ্ছে';

  @override
  String get gameOverCondition => 'গেম ওভার শর্ত';

  @override
  String get aisPlayStyle => 'এআই এর প্লে স্টাইল';

  @override
  String get passive => 'প্যাসিভ';

  @override
  String get timeout => 'সময় শেষ';

  @override
  String get appearance => 'চেহারা';

  @override
  String get drawOnHumanExperience => 'মানুষের অভিজ্ঞতা আঁকুন';

  @override
  String get considerMobility => 'টুকরো গতিশীলতা বিবেচনা করুন';

  @override
  String get pieceCount => 'টুকরো গণনা:';

  @override
  String inHand(Object player, int count) {
    return '$player হাতে: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return 'বোর্ডে $player: $count';
  }

  @override
  String get boardTop => 'উপরে থেকে বোর্ড অফসেট';

  @override
  String get notAIsTurn => 'এটি এআইয়ের পালা নয়।';

  @override
  String get aiIsNotThinking => 'এআই ভাবছে না।';

  @override
  String get atEnd => 'আপনি সরানো তালিকার শেষে রয়েছেন।';

  @override
  String get tapBackAgainToLeave => 'ছেড়ে যেতে আবার আলতো চাপুন।';

  @override
  String get more => 'আরও';

  @override
  String get experimental => 'এটি একটি পরীক্ষামূলক বৈশিষ্ট্য।';

  @override
  String get experiments => 'পরীক্ষা-নিরীক্ষা';

  @override
  String get ossLicenses => 'মুক্ত উত্স লাইসেন্স';

  @override
  String get language => 'ভাষা';

  @override
  String get defaultLanguage => 'নির্ধারিত ভাষা';

  @override
  String get mayMoveInPlacingPhase => 'টুকরা স্থাপনের পর্যায়ে যেতে পারে move';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'কোনও স্বতন্ত্র প্লেসিং এবং চলমান পর্যায় নেই, অর্থাৎ, খেলোয়াড়রা প্রতিটি পদক্ষেপে সিদ্ধান্ত নিতে পারে যে তারা বোর্ডে একটি টুকরো রাখতে চায় নাকি তাদের একটি টুকরো সরাতে চায় (যতক্ষণ পর্যন্ত তাদের বাকি টুকরোগুলি স্থাপন করতে হয়)।';

  @override
  String get drawerColor => 'মেনু রঙ';

  @override
  String get drawerTextColor => 'মেনু পাঠ্যের রঙ';

  @override
  String get drawerHighlightItemColor => 'মেনু হাইলাইট আইটেম রঙ';

  @override
  String get mainToolbarBackgroundColor => 'প্রধান সরঞ্জামদণ্ডের পটভূমির রঙ';

  @override
  String get mainToolbarIconColor => 'প্রধান সরঞ্জামদণ্ডের আইকন রঙ';

  @override
  String get navigationToolbarBackgroundColor =>
      'নেভিগেশন সরঞ্জামদণ্ডের পটভূমির রঙ';

  @override
  String get navigationToolbarIconColor => 'নেভিগেশন সরঞ্জামদণ্ডের আইকনের রঙ';

  @override
  String get autoHideToolbar => 'স্বয়ংক্রিয়ভাবে সরঞ্জামদণ্ডটি আড়াল করুন';

  @override
  String get toolbarLocationOnScreen => 'স্ক্রিনে সরঞ্জামদণ্ডের অবস্থান';

  @override
  String get top => 'শীর্ষ';

  @override
  String get bottom => 'নীচে';

  @override
  String get center => 'কেন্দ্র';

  @override
  String get solidColor => 'নিখাদ রং';

  @override
  String get picture => 'ছবি';

  @override
  String get chooseYourPicture => 'আপনার ছবি চয়ন করুন';

  @override
  String get light => 'আলো';

  @override
  String get dark => 'গা .়';

  @override
  String get themes => 'থিমস';

  @override
  String get currentTheme => 'বর্তমান থিম';

  @override
  String get saveTheme => 'থিম সংরক্ষণ করুন';

  @override
  String get showAnalysisGraph => 'বিশ্লেষণ গ্রাফ প্রদর্শন করুন';

  @override
  String get analysis => 'বিশ্লেষণ';

  @override
  String get saveGame => 'খেলা সংরক্ষণ';

  @override
  String get loadGame => 'লোড গেম';

  @override
  String get setupPosition => 'সেটআপ পজিশন';

  @override
  String get showLegalMoves => 'আইনী পদক্ষেপগুলি দেখান';

  @override
  String get showLastMove => 'শেষ পদক্ষেপ দেখান';

  @override
  String get showArrows => 'তীর দেখান';

  @override
  String get pieces => 'টুকরা';

  @override
  String get showAnalysis => 'বিশ্লেষণ দেখান';

  @override
  String get threads => 'থ্রেডস';

  @override
  String get getInvolved => 'জড়িত';

  @override
  String get helpImproveTranslate => 'অনুবাদ উন্নত করতে সহায়তা করুন';

  @override
  String get tutorial => 'টিউটোরিয়াল';

  @override
  String get classicMill => 'ক্লাসিক মিল';

  @override
  String get mixedMill => 'মিশ্র মিল';

  @override
  String get ceylonMill => 'সিলন মিল';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'মিলটি নষ্ট হয়ে গেছে এবং বারবার পুনরায় তৈরি করা যেতে পারে';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'যদি কোনও খেলোয়াড় তত্ক্ষণাত্ একটি নতুন মিল তৈরির জন্য কলটি ভেঙে দেয়, এই জাতীয় খেলোয়াড় যদি নতুন মিল তৈরি করে তবে তার পরবর্তী পদক্ষেপে এই জাতীয় টুকরোটি মূল জংশনে ফিরে যেতে পারে।';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'গেমটি টানা যদি কোনও খেলোয়াড়ের তিনটি টুকরা থাকে এবং দশটি চালনার পরে কোনও খেলোয়াড়ই প্রতিপক্ষের টুকরো অপসারণ করে না';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'যখন কোনও খেলোয়াড় তিন টুকরো হয়ে যায় এবং কোনও খেলোয়াড়ই প্রতিপক্ষের টুকরোটিকে দশটি চালের মধ্যে সরিয়ে ফেলতে পারে না, খেলাটি ড্র the.';

  @override
  String get close => 'বন্ধ';

  @override
  String get whitePiece => 'সাদা টুকরা';

  @override
  String get blackPiece => 'কালো টুকরা';

  @override
  String get emptyPoint => 'খালি বিন্দু';

  @override
  String get noPoint => 'বিন্দু নেই';

  @override
  String get placingPhase => 'স্থাপন পর্ব';

  @override
  String get movingPhase => 'চলন্ত পর্ব';

  @override
  String get flyingPhase => 'উড়ন্ত পর্ব';

  @override
  String sideToMove(Object player) {
    return 'পাশ সরানোর জন্য: $player';
  }

  @override
  String lastMove(Object move) {
    return 'শেষ পদক্ষেপ: $move';
  }

  @override
  String get selected => 'নির্বাচিত';

  @override
  String get accessibility => 'সহজলভ্যতা';

  @override
  String get screenReaderSupport => 'স্ক্রিন রিডার সমর্থন';

  @override
  String get isDraw => 'এটি একটি ড্র!';

  @override
  String get draw => 'আঁকা';

  @override
  String get pieceHighlightColor => 'পিস হাইলাইট কালার';

  @override
  String get algorithm => 'অ্যালগরিদম';

  @override
  String get endgameNMoveRule => 'এন্ডগেম এন-মুভ নিয়ম';

  @override
  String get endgameNMoveRule_Detail =>
      'যদি কোন খেলোয়াড়ের মাত্র তিনটি টুকরো থাকে এবং কোন খেলোয়াড় একটি নির্দিষ্ট চালের মধ্যে একটি টুকরো অপসারণ করে না, তবে খেলাটি ড্র হয়।';

  @override
  String get drawReasonEndgameRule50 =>
      'যেকোনো খেলোয়াড়ের মাত্র তিনটি টুকরো আছে এবং কোন খেলোয়াড় একটি নির্দিষ্ট চালের মধ্যে একটি টুকরো সরিয়ে দেয় না।';

  @override
  String get threefoldRepetitionRule => 'তিনগুণ পুনরাবৃত্তির নিয়ম';

  @override
  String get threefoldRepetitionRule_Detail =>
      'তৃতীয়বারের মতো কোনো অবস্থান হলে খেলাটি ড্র হয়।';

  @override
  String get continueToMakeMove => 'মিল! চলতে থাকুন।';

  @override
  String get pointStyle => 'বিন্দু শৈলী';

  @override
  String get pointWidth => 'পয়েন্ট প্রস্থ';

  @override
  String get solid => 'কঠিন';

  @override
  String get hollow => 'ফাঁপা';

  @override
  String get languageName => 'বাংলা';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count মুভস',
      one: '$count Move',
      zero: 'Move',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'লোড ব্যর্থ হয়েছে.';

  @override
  String get filename => 'ফাইলের নাম';

  @override
  String get browse => 'ব্রাউজ করুন…';

  @override
  String get gameFiles => 'গেম ফাইল';

  @override
  String get gameSavedTo => 'খেলা সংরক্ষিত হয়';

  @override
  String get empty => 'খালি';

  @override
  String get noMove => 'কোন নড়াচড়া নেই।';

  @override
  String get restoredPosition => 'প্রাথমিক অবস্থান পুনরুদ্ধার করা হয়েছে।';

  @override
  String get clean => 'পরিষ্কার';

  @override
  String get cleanedUp => 'পরিষ্কার করা হয়েছে।';

  @override
  String get remove => 'অপসারণ';

  @override
  String get noPiecesCanBeRemoved => 'কোন টুকরা অপসারণ করা যাবে না.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count টুকরা',
      one: '$count piece',
      zero: 'Piece',
    );
    return '$_temp0 সরাতে হবে৷';
  }

  @override
  String placedCount(int count) {
    return 'স্থাপন ($count)';
  }

  @override
  String get placedPieceCount => 'স্থাপন পর্বে স্থাপিত টুকরা গণনা.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'বর্তমান প্লেয়ারটি $count টুকরা রেখেছে।';
  }

  @override
  String get notPlacingPhase => 'ফেজ স্থাপন না, এটি পরিবর্তন করতে পারবেন না.';

  @override
  String get paste => 'পেস্ট করুন';

  @override
  String get pasteDone => 'পেস্ট করা হয়।';

  @override
  String get cannotPaste => 'পেস্ট করা যাবে না।';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'স্থানহীন এবং সরানো টুকরা দেখান';

  @override
  String get fullScreen => 'পূর্ণ পর্দা';

  @override
  String get reopenToTakeEffect =>
      'প্রস্থান করুন এবং সেটিংস কার্যকর করার জন্য অ্যাপ্লিকেশন পুনরায় খুলুন।';

  @override
  String get forest => 'বন। জংগল';

  @override
  String get desktopImage => 'ডেস্কটপ ছবি';

  @override
  String get invalidPosition => 'অবৈধ অবস্থান।';

  @override
  String get shareGIF => 'GIF শেয়ার করুন';

  @override
  String get pixelRatio => 'পিক্সেল অনুপাত';

  @override
  String get duration => 'সময়কাল';

  @override
  String get gameScreenRecorder => 'গেম স্ক্রিন রেকর্ডার';

  @override
  String get previous => 'আগে';

  @override
  String get next => 'পরবর্তী';

  @override
  String get skip => 'এড়িয়ে যান';

  @override
  String get gotIt => 'বুঝেছি';

  @override
  String get youCanModifyRules =>
      'আপনি নিয়ম সেটিংসে গেমের নিয়ম পরিবর্তন করতে পারেন।';

  @override
  String get youCanUseMouseWheelInPicker =>
      'পিকারে মান পরিবর্তন করতে আপনি মাউস হুইল ব্যবহার করতে পারেন।';

  @override
  String get noTimeLimitForThinking =>
      'AI চিন্তার সময় 0 এ সেট করা মানে চিন্তা করার জন্য কোন সময়সীমা নেই।';

  @override
  String get whatIsMtdf =>
      'MTD(f) হল আলফা-বিটা অনুসন্ধান অ্যালগরিদমের একটি পরিবর্তিত রূপ যার লক্ষ্য হল মধ্যবর্তী অনুসন্ধান ফলাফল পুনরায় ব্যবহার করে এবং অনুসন্ধানের স্থান সংকুচিত করার জন্য একটি ভাল প্রাথমিক অনুমান ব্যবহার করে দক্ষতা উন্নত করা।';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'অনুগ্রহ করে সচেতন থাকুন যে AI চিন্তার সময় সমন্বয় সম্পূর্ণরূপে সুনির্দিষ্ট নাও হতে পারে। প্রকৃত চিন্তার সময় কম হতে পারে যখন অসুবিধার মাত্রা কম মানের সেট করা হয় এবং সময় ফুরিয়ে গেলে AI মধ্য-চিন্তা করার সময় দীর্ঘ হতে পারে।';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'আপনি যদি অসুবিধার স্তরটি উচ্চ সেট করেন কিন্তু AI চিন্তার সময় না বাড়ান, তবে চিন্তার সময় সীমাবদ্ধতার কারণে প্রকৃত অসুবিধা স্তরটি কম মানের মধ্যে সীমাবদ্ধ হতে পারে। প্রকৃত মান মেশিনের কর্মক্ষমতা উপর ভিত্তি করে পরিবর্তিত হতে পারে.';

  @override
  String get whatIsPvs =>
      'PVS (প্রিন্সিপাল ভেরিয়েশন সার্চ) হল একটি সার্চ অ্যালগরিদম যা একটি প্রদত্ত অবস্থানে সেরা পদক্ষেপ খুঁজে বের করতে পারে। এটি আলফা-বিটা অ্যালগরিদমের একটি বর্ধিতকরণ এবং এটি নিশ্চিত করতে নাল বা শূন্য উইন্ডো অনুসন্ধানগুলি ব্যবহার করে যে মূল পরিবর্তন থেকে একটি পদক্ষেপ ইতিমধ্যে নিরাপদ স্কোরের চেয়ে খারাপ বা খারাপ নয়। PVS সবচেয়ে প্রতিশ্রুতিবদ্ধ পদক্ষেপগুলিতে ফোকাস করে এবং সাবঅপ্টিমাল শাখাগুলির অপ্রয়োজনীয় অনুসন্ধানগুলি এড়িয়ে যায়, যা অনুসন্ধানের কার্যকারিতা উন্নত করতে সহায়তা করে।';

  @override
  String get whatIsAlphaBeta =>
      'আলফা-বিটা অ্যালগরিদম হল একটি সার্চ অ্যালগরিদম যা সর্বোত্তম পদক্ষেপ খুঁজে পেতে পারে৷ এটি মিনিম্যাক্স নীতি এবং দুটি মান, আলফা এবং বিটা ব্যবহার করে, অনুসন্ধান গাছকে ছাঁটাই করতে এবং দক্ষতা বাড়াতে। আলফা ন্যূনতম স্কোর প্রতিনিধিত্ব করে যে কম্পিউটারটি নিশ্চিত যে এটি পেতে পারে, যখন বিটা তার প্রতিপক্ষের সর্বোচ্চ স্কোরের প্রতিনিধিত্ব করে। অ্যালগরিদম কম্পিউটারকে একটি গেমে স্মার্ট, দক্ষ সিদ্ধান্ত নিতে সাহায্য করে।';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'মানুষের অভিজ্ঞতা অনুযায়ী জেতার চেষ্টা করলে হেরে যাবে। পরিবর্তে, আপনার লক্ষ্য হিসাবে একটি ড্র করার লক্ষ্য রাখুন এবং খেলা হারানো এড়ান। আপনার প্রতিপক্ষকে পর্যবেক্ষণ করুন এবং তাদের এমন একটি অবস্থানে আলতোভাবে প্রলুব্ধ করুন যেখানে তারা ভুল করতে পারে। যখন তারা দুর্বলতা দেখায়, সুযোগটি কাজে লাগান এবং মৃদুভাবে জয়ের জন্য চাপ দিন। এই ভাবে, আপনি খেলা জিততে পারেন.';

  @override
  String get firstMoveDetail =>
      'এই খেলায়, প্রথম খেলোয়াড়ের তুলনায় দ্বিতীয় খেলোয়াড়ের পক্ষে জেতা সহজ।';

  @override
  String get passiveDetail =>
      'প্যাসিভ বিকল্পটি সক্রিয় করার ফলে AI শিথিল হবে যখন পজিশনে সুবিধা থাকবে, আক্রমণাত্মকভাবে যত তাড়াতাড়ি সম্ভব জেতার চেষ্টা করার পরিবর্তে।';

  @override
  String get moveRandomlyDetail =>
      'এই বিকল্পটি সক্ষম করা গেমটির এলোমেলোতা এবং মজা বাড়ায় এবং এটিকে নিষ্ক্রিয় করে AI কে হারানোর উপায়গুলি অধ্যয়ন করতে সহায়তা করতে পারে৷';

  @override
  String get considerMobilityOfPiecesDetail =>
      'যদি AI তার টুকরোগুলির গতিশীলতা বিবেচনা করে, তবে এটি শুধুমাত্র প্রতিপক্ষের টুকরাগুলিকে যত তাড়াতাড়ি সম্ভব ক্যাপচার করার লক্ষ্য রাখবে না, তবে প্রতিপক্ষের গতিবিধিকে অবরুদ্ধ করা এবং তাদের একই কাজ করা থেকে বাধা দেওয়ার কথাও বিবেচনা করবে।';

  @override
  String get whenBoardIsFull => 'বোর্ড পূর্ণ হলে';

  @override
  String get whenBoardIsFull_Detail =>
      'স্থাপন পর্বের শেষে, চলন্ত পর্ব শুরু হওয়ার আগে, বোর্ডটি টুকরো টুকরো হলে ক্রিয়াটি অনুসরণ করে।';

  @override
  String get sideToMoveRemovePiece =>
      'যে খেলোয়াড় চলমান পর্বে প্রথমে চলে যায় সে প্রতিপক্ষের একটি টুকরো সরিয়ে দেয়।';

  @override
  String get agreeToDraw => 'উভয় পক্ষই ড্র করতে রাজি।';

  @override
  String get takeOpponentsPiece => 'আপনার প্রতিপক্ষের একটি টুকরা নিন.';

  @override
  String get firstPlayerLose => 'প্রথম খেলোয়াড় খেলা হারায়।';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'প্রথম এবং দ্বিতীয় খেলোয়াড়রা প্রতিপক্ষের একটি টুকরো সরিয়ে দেয়।';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'দ্বিতীয় এবং প্রথম খেলোয়াড়রা প্রতিপক্ষের একটি টুকরো সরিয়ে দেয়।';

  @override
  String get enteredFlyingPhase =>
      'এখন উড়ন্ত পর্বে প্রবেশ করেছে, প্রতিপক্ষের টুকরো বোর্ডের যে কোনও খালি পয়েন্টে লাফ দিতে পারে। আপনি \"নিয়ম সেটিংস\" এ উড়ন্ত নিয়মটি বন্ধ করতে পারেন।';

  @override
  String get whenStalemate => 'যখন অচলাবস্থা';

  @override
  String get whenStalemate_Detail =>
      'কোন ক্রিয়াটি অনুসরণ করে যখন কোন অংশ সরানো যায় না?';

  @override
  String get endWithStalemateLoss => 'একটি অচলাবস্থা হার সঙ্গে শেষ.';

  @override
  String get changeSideToMove => 'সরানোর জন্য পাশ পরিবর্তন করুন।';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'প্রতিপক্ষের একটি টুকরা সরান এবং পরবর্তী পদক্ষেপ করুন।';

  @override
  String get endWithStalemateDraw => 'একটি অচলাবস্থা ড্র সঙ্গে শেষ.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'প্রতিপক্ষের একটি টুকরো সরান এবং সরানোর জন্য পাশ পরিবর্তন করুন।';

  @override
  String get aiResponseDelayTime => 'এআই প্রতিক্রিয়া বিলম্বের সময়';

  @override
  String get aiIsDelaying =>
      'এআই বর্তমানে একটি বিলম্বিত প্রতিক্রিয়া পর্যায়ে রয়েছে। এগিয়ে যাওয়ার আগে অনুগ্রহ করে কিছুক্ষণ অপেক্ষা করুন।';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'আপনি একটি অসংলগ্ন টুকরা অপসারণ করতে পারবেন না.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'অচলাবস্থা হলে, মিল গঠন নির্বিশেষে, আপনার সংলগ্ন প্রতিপক্ষের টুকরা সরানো যেতে পারে।';

  @override
  String get whatIsMcts =>
      'MCTS হল একটি শিক্ষানবিস-বান্ধব অ্যালগরিদম যা সিমুলেশনের মাধ্যমে বিভিন্ন চাল অন্বেষণ এবং মূল্যায়ন করে সিদ্ধান্ত নেয়।';

  @override
  String get goldenJade => 'গোল্ডেন জেড';

  @override
  String get forestWood => 'বন কাঠ';

  @override
  String get darkMystery => 'অন্ধকার রহস্য';

  @override
  String get midnightBlue => 'মধ্যরাত নীল';

  @override
  String get greenForest => 'সবুজ বনভূমি';

  @override
  String get greenMeadow => 'সবুজ তৃণভূমি';

  @override
  String get stonyPath => 'পাথুরে পথ';

  @override
  String get pastelPink => 'প্যাস্টেল গোলাপী';

  @override
  String get turquoiseSea => 'ফিরোজা সাগর';

  @override
  String get violetDream => 'ভায়োলেট ড্রিম';

  @override
  String get mintChocolate => 'পুদিনা চকোলেট';

  @override
  String get skyBlue => 'আকাশী নীল';

  @override
  String get playfulGarden => 'কৌতুকপূর্ণ বাগান';

  @override
  String get whatIsRetrogradeAnalysis =>
      'রেট্রোগ্রেড অ্যানালাইসিস অ্যালগরিদম বিভিন্ন স্টার্ট পজিশন থেকে একটি এন্ডগেম ডাটাবেস তৈরি করতে বহু-মূল্যবান রেট্রোগ্রেড বিশ্লেষণ ব্যবহার করে, তারপর গেমপ্লে অপ্টিমাইজ করতে এই ডাটাবেসটি প্রয়োগ করে। এই পদ্ধতিটি আল্ট্রা-স্ট্রং সমাধানের বিভাগে পড়ে।';

  @override
  String get viewAlgorithmGuide =>
      'আপনি কি এই অ্যালগরিদমের জন্য ব্যবহারকারীর নির্দেশিকা দেখতে চান?';

  @override
  String get showPositionalAdvantageIndicator =>
      'অবস্থানগত সুবিধা নির্দেশক দেখান';

  @override
  String get usePerfectDatabase => 'নিখুঁত ডাটাবেস ব্যবহার করুন';

  @override
  String get perfectDatabaseDescription =>
      'অত্যাধুনিক অ্যালগরিদমের মাধ্যমে তৈরি একটি ত্রুটিহীন গেম ডাটাবেস ব্যবহার করতে এই বিকল্পটি সক্ষম করুন৷ এই বৈশিষ্ট্যটি সর্বোত্তম পদক্ষেপের পরামর্শ দেওয়ার জন্য ওপেনিং এবং এন্ডগেম উভয় কৌশলকে সংহত করে। যারা গেমপ্লেতে সর্বোচ্চ স্তরের নির্ভুলতা খোঁজেন তাদের জন্য এটি পছন্দের পছন্দ। সূক্ষ্ম কম্পিউটেশনাল কৌশলগুলির মাধ্যমে তৈরি করা হয়েছে, ডাটাবেসটি প্রায় নিখুঁত গেম সমাধান দেওয়ার জন্য ডিজাইন করা হয়েছে।\n\nদ্রষ্টব্য: AI ডাটাবেস অ্যাক্সেস করতে ব্যর্থ হলে, এটি গেমপ্লে সিদ্ধান্তের জন্য প্রচলিত অ্যালগরিদমগুলিতে পরিণত হবে। ডাটাবেস উপলব্ধ হলে, \'কঠিন স্তর\' কার্যত অপরাজেয় হয়ে ওঠে এবং \'এআই থিংকিং টাইম\' একটি মারাত্মক হ্রাস অনুভব করে। \'AI এর প্লেস্টাইল\' বিকল্পগুলির মধ্যে অনেক সেটিংস ওভাররাইড করা হবে, কারণ ডাটাবেসের ফলাফলগুলি সর্বোচ্চ অগ্রাধিকার দেয়৷\n\nকিভাবে এই ত্রুটিহীন ডাটাবেসের সবচেয়ে বেশি ব্যবহার করা যায় তার নির্দেশনার জন্য, এখানে ক্লিক করুন।';

  @override
  String get backgroundImage => 'ব্যাকগ্রাউন্ড ইমেজ';

  @override
  String get whatIsRandom =>
      'যখন \'নিখুঁত ডাটাবেস ব্যবহার করুন\' বিকল্পটি সক্রিয় না থাকে, তখন \'র্যান্ডম\' সেটিং এআইকে সরানো নির্বাচনের জন্য কোনো অ্যালগরিদম ব্যবহার না করে এলোমেলোভাবে টুকরো টুকরো করে দেয়। এটি সাধারণত উল্লেখযোগ্যভাবে দুর্বল গেমপ্লে পরিণত হয়। বিপরীতভাবে, যখন \'নিখুঁত ডেটাবেস ব্যবহার করুন\' সক্ষম করা হয়, তখন AI একচেটিয়াভাবে সিদ্ধান্ত নেওয়ার জন্য \'পারফেক্ট ডেটাবেস\'-এর উপর নির্ভর করে, এটিকে ঐতিহ্যগত AI অ্যালগরিদমের সাথে মিশ্রিত করার পরিবর্তে। এই মোডে, AI এর চালগুলি সম্পূর্ণরূপে ডাটাবেসের বিষয়বস্তুর উপর ভিত্তি করে, রিয়েল-টাইম গণনা বা অনুসন্ধান অ্যালগরিদমের উপর নির্ভরতা পরিহার করে।';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'প্রতিপক্ষের হাত থেকে ঘুঁটি সরান; তারপর প্রতিপক্ষের পালা রাখার।';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'প্লেসিং ফেজের সময় মিল তৈরি করার সময়';

  @override
  String get removeOpponentsPieceFromBoard =>
      'বোর্ড থেকে প্রতিপক্ষের ঘুঁটি সরান।';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'বোর্ড থেকে প্রতিপক্ষের ঘুঁটি সরান; তারপর প্রতিপক্ষের পালা রাখার।';

  @override
  String get opponentRemovesOwnPiece =>
      'প্রতিপক্ষ বোর্ড থেকে নিজের ঘুঁটি সরিয়ে ফেলে।';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'আপনি ব্যবস্থা নেওয়ার পরিবর্তে, প্রতিপক্ষ নিজের ঘুঁটি বোর্ড থেকে বেছে নেয় এবং সরিয়ে ফেলে, কার্যকরভাবে এমন একটি পদক্ষেপ নেয় যা তাদের নিজেদের জন্য ক্ষতিকর।';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'প্রতিপক্ষের হাত থেকে ঘুঁটি সরান; তারপর আপনার পালা চলার।';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'প্রতিপক্ষের হাত থেকে ঘুঁটি সরিয়ে দিন। যদি, মাল্টি-রিমুভ সেটিং অনুযায়ী, একাধিক ঘুঁটি সরাতে হয় এবং প্রতিপক্ষের হাতে আর কোনো ঘুঁটি না থাকে, বোর্ড থেকে প্রতিপক্ষের ঘুঁটি সরাতে থাকুন। তারপর আপনার পালা চলার। আপনি যদি মিল তৈরি করা চালিয়ে যান, আপনি প্রতিপক্ষের ঘুঁটিগুলি সরিয়ে যেতে পারেন।';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'প্রতিপক্ষের হাত থেকে ঘুঁটি সরিয়ে দিন। যদি, মাল্টি-রিমুভ সেটিং অনুযায়ী, একাধিক ঘুঁটি সরাতে হয় এবং প্রতিপক্ষের হাতে আর কোনো ঘুঁটি না থাকে, বোর্ড থেকে প্রতিপক্ষের ঘুঁটিগুলি সরাতে থাকুন। তারপর প্রতিপক্ষের পালা চলার।';

  @override
  String get markAndDelayRemovingPieces =>
      'ঘুঁটি মার্ক করুন এবং অপসারণে বিলম্ব করুন।';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'প্লেসিং ফেজের সময়, সরানো যাবে এমন ঘুঁটিগুলি চিহ্নিত করা হয়, এবং উভয় খেলোয়াড়ের জন্য, এই পয়েন্টগুলিতে কোনও নতুন ঘুঁটি স্থাপন করা যায় না। চলন্ত ফেজে প্রবেশ করার পরে, এই চিহ্নিত ঘুঁটিগুলি একসাথে সরানো হয়, এবং খেলোয়াড়রা তাদের ঘুঁটিগুলি এই এখন-খালি পয়েন্টে সরাতে পারে।';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'স্থাপন পর্যায়ে মিল গঠনের সময় গৃহীত হতে পারে এমন ক্রিয়াকলাপ।';

  @override
  String get marked => 'চিহ্নিত';

  @override
  String get menu => 'মেনু';

  @override
  String get monochrome => 'মনোক্রোম';

  @override
  String get youCanEnableScreenReaderSupport =>
      'আপনি সাধারণ সেটিংসের অ্যাক্সেসিবিলিটি কনফিগারেশনে স্ক্রিন রিডার সাপোর্ট চালু করতে পারেন।';

  @override
  String get showNumbersOnPieces => 'টুকরোগুলিতে সংখ্যা প্রদর্শন';

  @override
  String get saveImage => 'চিত্র সংরক্ষণ করুন';

  @override
  String get isAnalysisToolbarShown => 'বিশ্লেষণ টুলবার দেখান';

  @override
  String get analysisToolbarBackgroundColor => 'বিশ্লেষণ টুলবারের পটভূমি রঙ';

  @override
  String get analysisToolbarIconColor => 'বিশ্লেষণ টুলবারের আইকন রঙ';

  @override
  String get transformed => 'পরিবর্তিত।';

  @override
  String get cannotTransform => 'পরিবর্তন করা যায় না।';

  @override
  String get rotate => 'ঘোরানো';

  @override
  String get horizontalFlip => 'হর. ফ্লি.';

  @override
  String get verticalFlip => 'ভার্ট. ফ্লি.';

  @override
  String get innerOuterFlip => 'আইও ফ্লিপ';

  @override
  String get transparentCanvas => 'স্বচ্ছ ক্যানভাস';

  @override
  String get restrictRepeatedMillsFormation => 'পুনরাবৃত্ত মিলস গঠন সীমিত করুন';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'একটি মিল থেকে অন্য মিলে সরানো একটি টুকরো পরবর্তী পালায় আবার মিল গঠনের জন্য অবিলম্বে মূল বিন্দুতে ফিরতে পারে না। প্রথমে অন্য একটি চাল প্রয়োজন।';

  @override
  String get oneTimeUseMill => 'একবারের জন্য ব্যবহার মিল';

  @override
  String get oneTimeUseMill_Detail =>
      'প্রতিটি মিল একবারই প্রতিদ্বন্দ্বীর একটি অংশ সরিয়ে ফেলতে পারে। আপনি এটি আবার গঠন করতে পারেন, তবে এটি অতিরিক্ত অপসারণের জন্য ব্যবহার করা যাবে না।';

  @override
  String get currentRulesNoPerfectDatabase =>
      'আপনি যে বর্তমান নিয়মগুলি সেট করেছেন তাদের কোনও উপযুক্ত নিখুঁত ডেটাবেস নেই। নিখুঁত ডেটাবেস সম্পর্কে আরও তথ্যের জন্য, এখানে ক্লিক করুন।';

  @override
  String get focusOnBlockingPaths => 'পথ আটকে দেওয়ায় মনোনিবেশ করুন';

  @override
  String get focusOnBlockingPaths_Detail =>
      'মিল তৈরি করার পরিবর্তে প্রতিপক্ষের গতিকে বাধা দেওয়ার উপর অগ্রাধিকার দিন। মিল সম্পূর্ণ করার মাধ্যমে টুকরোগুলি অপসারণের উপর মনোযোগ দেওয়ার পরিবর্তে, AI প্রতিপক্ষকে আটকে রাখার চেষ্টা করে, তাদের অক্ষম করে রাখে এবং আক্রমণাত্মক খেলার পরিবর্তে দীর্ঘমেয়াদী কৌশলে বিজয় নিশ্চিত করে। এই কৌশলটি প্রতিপক্ষের মিলগুলিকে সক্রিয়ভাবে ব্লক করে না।';

  @override
  String get pieceImage => 'ছবি টুকরা';

  @override
  String get importColorSettings => 'রঙের সেটিংস আমদানি করুন';

  @override
  String get exportColorSettings => 'রঙের সেটিংস রপ্তানি করুন';

  @override
  String get import => 'আমদানি';

  @override
  String get export => 'রপ্তানি';

  @override
  String get pleaseCopyJsonToClipboard =>
      'দয়া করে প্রথমে JSON ফরম্যাটের সেটিংসগুলো ক্লিপবোর্ডে কপি করুন।';

  @override
  String get copiedToClipboard => 'ক্লিপবোর্ডে কপি করা হয়েছে।';

  @override
  String get imported => 'আমদানি করা হয়েছে।';

  @override
  String get boardImage => 'বোর্ডের চিত্র';

  @override
  String get autumnLeaves => 'শরতের পাতা';

  @override
  String get legendaryLand => 'কিংবদন্তি জমি';

  @override
  String get vignetteEffect => 'ভিনিয়েট প্রভাব';

  @override
  String get promptMakeToolbarTransparent =>
      'বোর্ডের পটভূমি চিত্র সেট করা হলে টুলবার সম্পূর্ণ স্বচ্ছ করতে চান?';

  @override
  String get vibration => 'গেমে ভাইব্রেশন সক্ষম করুন';

  @override
  String get soundTheme => 'সাউন্ড থিম';

  @override
  String get ball => 'বল';

  @override
  String get liquid => 'তরল';

  @override
  String get wood => 'কাঠ';

  @override
  String get placeEffectAnimation => 'ঘুঁটি স্থাপনের অ্যানিমেশন প্রভাব';

  @override
  String get removeEffectAnimation => 'ঘুঁটি অপসারণের অ্যানিমেশন প্রভাব';

  @override
  String get isToolbarAtBottom => 'টুলবার নীচে দেখান';

  @override
  String get boardCornerRadius => 'বোর্ডের কোণের ব্যাসার্ধ';

  @override
  String get useOpeningBook => 'ওপেনিং বুক ব্যবহার করুন';

  @override
  String get currentRule => 'বর্তমান';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'মোরাবারাবা';

  @override
  String get dooz => 'দুজ';

  @override
  String get chamGonu => 'চামগোনু';

  @override
  String get zhiQi => 'ঝি চি';

  @override
  String get chengSanQi => 'চেং সান চি';

  @override
  String get mulMulan => 'মুল-মুলান';

  @override
  String get nerenchi => 'নেরেনচি';

  @override
  String get ruleSet => 'নিয়ম সেট';

  @override
  String get laskerMorris => 'লাস্কার মরিস';

  @override
  String get oneTimeMill => 'একবারের মিল';

  @override
  String get daSanQi => 'দা সান চি';

  @override
  String get useOpeningBook_Detail =>
      'প্রাথমিক খেলার সময় পেশাদার মানব প্লেয়ারদের দ্বারা প্রায়শই ব্যবহৃত ওপেনিং চালগুলি এআই ব্যবহার করতে দিন। দ্রষ্টব্য: এই বৈশিষ্ট্য বর্তমানে কেবল নির্দিষ্ট নিয়ম সেটগুলির জন্য উপলব্ধ।';

  @override
  String get showAdvantageGraph => 'সুবিধার গ্রাফ দেখান';

  @override
  String get advantageGraphHint =>
      'কৃত্রিম বুদ্ধিমত্তা চাল দেওয়ার পরেই কেবল অ্যাডভান্টেজ গ্রাফ আঁকা হবে। মানব খেলোয়াড় চাল দিলে এটি আঁকা হবে না।';

  @override
  String get removalBasedOnMillCounts =>
      'সমস্ত ঘুটি স্থাপন না হওয়া পর্যন্ত সরানো নিষ্ক্রিয় করুন। খেলোয়াড়রা মিলের সংখ্যার ভিত্তিতে ঘুটি সরিয়ে থাকে।';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'সমস্ত ঘুটি স্থাপন না হওয়া পর্যন্ত সরানো নিষ্ক্রিয় করুন। খেলোয়াড়রা মিলের সংখ্যার ভিত্তিতে ঘুটি সরিয়ে থাকে: যদি সংখ্যাগুলি সমান হয়, উভয়েই একই সংখ্যক ঘুটি সরায়; যদি একজনের বেশি থাকে, তিনি অতিরিক্ত একটি ঘুটি সরিয়ে এক ঘুটির পার্থক্য বজায় রাখেন। যদি কেবল একজন মিল তৈরি করে, তিনি দুটি ঘুটি সরাবেন এবং অন্যজন একটি ঘুটি সরাবে। যদি কেউই মিল তৈরি করতে না পারে, উভয়েই একটি করে ঘুটি সরাবে।';

  @override
  String get elfilja => 'এল ফিলজা';

  @override
  String get tipSelectOwnPiece => 'আপনার ঘুঁটিগুলির একটি নির্বাচন করুন।';

  @override
  String get notYourTurn => 'এটা আপনার পালা নয়।';

  @override
  String get annotationToolbarBackgroundColor => 'টীকা টুলবারের পটভূমির রঙ';

  @override
  String get annotationToolbarIconColor => 'টীকা টুলবারের আইকনের রঙ';

  @override
  String get isAnnotationToolbarShown => 'টীকা টুলবার দেখান';

  @override
  String get enterAnnotationMode => 'টীকা মোডে প্রবেশ করুন';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'আপনি কি নিশ্চিত যে আপনি সব টীকা মুছে ফেলতে চান?';

  @override
  String get llmPromptCopiedToClipboard =>
      'LLM প্রম্পট ক্লিপবোর্ডে অনুলিপি করা হয়েছে।';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'সংযোগ প্রত্যাখ্যান করা হয়েছে, সার্ভারটি হয়তো বন্ধ আছে।';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'আবিষ্কার সফল, সংযোগের অপেক্ষায়...';

  @override
  String get noLanConnection => 'কোনো LAN সংযোগ নেই';

  @override
  String get takeScreenshot => 'স্ক্রিনশট নিন';

  @override
  String get disconnectedFromOpponent => 'প্রতিপক্ষের সাথে সংযোগ বিচ্ছিন্ন।';

  @override
  String get takeBackRequest => 'পিছনে নেওয়ার অনুরোধ';

  @override
  String get nothingToShow => 'দেখানোর মতো কিছু নেই।';

  @override
  String get stopHosting => 'হোস্টিং বন্ধ করুন';

  @override
  String get connectionResetByPeer =>
      'পিয়ার দ্বারা সংযোগ পুনরায় সেট করা হয়েছে।';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'হার্টবিট টাইমআউটের কারণে সংযোগ হারিয়ে গেছে। অনুগ্রহ করে পুনরায় সংযোগ করুন।';

  @override
  String get startHosting => 'হোস্টিং শুরু করুন';

  @override
  String get restartRequestRejected =>
      'পুনরায় শুরু করার অনুরোধ প্রত্যাখ্যান করা হয়েছে।';

  @override
  String get notConnectedToLanOpponent => 'LAN প্রতিপক্ষের সাথে সংযুক্ত নয়।';

  @override
  String get llmPrompt => 'LLM প্রম্পট';

  @override
  String get gameRestarted => 'খেলা পুনরায় শুরু হয়েছে।';

  @override
  String get takeBackRejected => 'পিছনে নেওয়া প্রত্যাখ্যান করা হয়েছে।';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'আপনি কি নিশ্চিত যে আপনি এই খেলা থেকে পদত্যাগ করতে চান?';

  @override
  String get opponentResignedYouWin => 'প্রতিপক্ষ পদত্যাগ করেছে। আপনি জিতেছেন!';

  @override
  String get clearAllAnnotations => 'সব টীকা মুছে ফেলুন';

  @override
  String get connectedWaitingForOpponentSMove =>
      'সংযুক্ত, প্রতিপক্ষের চালের জন্য অপেক্ষা করছে...';

  @override
  String get networkStatusDisconnected => 'নেটওয়ার্ক স্থিতি: সংযোগ বিচ্ছিন্ন';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'পিছনে নেওয়ার অনুরোধ প্রতিপক্ষকে পাঠানো হয়েছে।';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'প্রতিপক্ষ হয়তো খেলা ছেড়ে চলে গেছে';

  @override
  String get connectedToHostSuccessfully => 'হোস্টের সাথে সফলভাবে সংযুক্ত।';

  @override
  String get connectionLostHeartbeatTimeout =>
      'সংযোগ হারিয়ে গেছে: হার্টবিট টাইমআউট';

  @override
  String get noHostDiscovered => 'কোনো হোস্ট আবিষ্কৃত হয়নি।';

  @override
  String get confirmResignation => 'পদত্যাগ নিশ্চিত করুন';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'খেলা হোস্টিং শুরু হয়েছে, খেলোয়াড়দের যোগদানের অপেক্ষায়...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'সংযোগের সময় শেষ, নেটওয়ার্ক সংযোগ অস্থির।';

  @override
  String get noLlmPromptAvailable => 'কোনো LLM প্রম্পট উপলব্ধ নেই।';

  @override
  String get youResignedGameOver => 'আপনি পদত্যাগ করেছেন। খেলা শেষ।';

  @override
  String get serverIp => 'সার্ভার IP';

  @override
  String get confirmClear => 'মুছে ফেলা নিশ্চিত করুন';

  @override
  String get opponentSTurn => 'প্রতিপক্ষের পালা।';

  @override
  String get waitingAClientConnection => 'একটি ক্লায়েন্ট সংযোগের অপেক্ষায়...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'পিছনে নেওয়ার অনুরোধ প্রত্যাখ্যান করা হয়েছে বা ব্যর্থ হয়েছে।';

  @override
  String get addText => 'টেক্সট যোগ করুন';

  @override
  String get exitAnnotationMode => 'টীকা মোড থেকে বের হন';

  @override
  String get typeYourAnnotation => 'আপনার টীকা টাইপ করুন';

  @override
  String get attemptingToReconnect => 'পুনরায় সংযোগের চেষ্টা করছে...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'পুনরায় শুরু করার অনুরোধ পাঠানো হয়েছে। প্রতিপক্ষের প্রতিক্রিয়ার অপেক্ষায়...';

  @override
  String get serverIsStopped => 'সার্ভার বন্ধ আছে।';

  @override
  String get restartRequest => 'পুনরায় শুরু করার অনুরোধ';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'যখন এটা আপনার পালা নয় তখন পিছনে নেওয়ার অনুরোধ করতে পারবেন না।';

  @override
  String get takeBackAccepted => 'পিছনে নেওয়া গ্রহণ করা হয়েছে।';

  @override
  String get localNetworkSettings => 'স্থানীয় নেটওয়ার্ক সেটিংস';

  @override
  String get reconnectedSuccessfully => 'সফলভাবে পুনরায় সংযুক্ত!';

  @override
  String get failedToSaveImageToGallery =>
      'গ্যালারিতে ছবি সংরক্ষণ করতে ব্যর্থ হয়েছে।';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'প্রতিপক্ষ খেলা পুনরায় শুরু করার অনুরোধ করেছে। আপনি কি গ্রহণ করেন?';

  @override
  String get yourTurn => 'আপনার পালা।';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'পুনরায় সংযোগ করতে অক্ষম, অনুগ্রহ করে খেলা পুনরায় শুরু করুন।';

  @override
  String get host => 'হোস্ট';

  @override
  String get join => 'যোগদান';

  @override
  String get port => 'পোর্ট';

  @override
  String get invalidIpAddress => 'অবৈধ IP ঠিকানা।';

  @override
  String get invalidPort => 'অবৈধ পোর্ট।';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'সংযোগ করছে: প্রচেষ্টা $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'সংযোগ করতে ব্যর্থ: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'হোস্টিং শুরু করতে ব্যর্থ: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'হোস্ট আবিষ্কৃত: $ip:$port';
  }

  @override
  String get stop => 'বন্ধ করুন';

  @override
  String get discover => 'আবিষ্কার করুন';

  @override
  String get connect => 'সংযোগ করুন';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'ক্লায়েন্ট সংযুক্ত: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'আবিষ্কার করছে: $seconds সেকেন্ড';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'পুনরায় সংযোগ করছে ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'সংযুক্ত';

  @override
  String get delete => 'মুছে ফেলুন';

  @override
  String get ancientEgypt => 'প্রাচীন মিশর';

  @override
  String get gothicIce => 'গথিক বরফ';

  @override
  String get riceField => 'ধানের ক্ষেত';

  @override
  String get chinesePorcelain => 'চীনা পোর্সেলিন';

  @override
  String get desertDusk => 'মরুভূমির সন্ধ্যা';

  @override
  String get precisionCraft => 'নির্ভুল কারুশিল্প';

  @override
  String get folkEmbroidery => 'লোকজ সূচিকর্ম';

  @override
  String get carpathianHeritage => 'কার্পেথিয়ান ঐতিহ্য';

  @override
  String get imperialGrandeur => 'সাম্রাজ্যিক মহিমা';

  @override
  String get bohemianCrystal => 'বোহেমিয়ান ক্রিস্টাল';

  @override
  String get savannaSunrise => 'সাভানার সূর্যোদয়';

  @override
  String get harmonyBalance => 'সামঞ্জস্য ভারসাম্য';

  @override
  String get cinnamonSpice => 'দারুচিনি মশলা';

  @override
  String get anatolianMosaic => 'আনাতোলিয়ান মোজাইক';

  @override
  String get carnivalSpirit => 'কার্নিভালের আত্মা';

  @override
  String get custom => 'কাস্টম';

  @override
  String get spiceMarket => 'মসলা বাজার';

  @override
  String get swipeToRevealTheDrawer => 'ড্রয়ার দেখতে সোয়াইপ করুন';

  @override
  String get showGameInfoOnScreenshots => 'স্ক্রীনশটে গেম তথ্য দেখান';

  @override
  String get humanMoveTime => 'মানুষের চালের সময়সীমা';

  @override
  String get noTimeLimitForHumanMoves => 'মানুষের চালের জন্য কোন সময়সীমা নেই';

  @override
  String get timeoutLoseWillBeApplied =>
      'মানুষ খেলোয়াড়ের জন্য টাইমআউট হার প্রয়োগ করা হবে';

  @override
  String get identifyingBoard => 'বোর্ড সনাক্ত করা হচ্ছে...';

  @override
  String get youCanEnterAnyModelName => 'আপনি যেকোনো মডেলের নাম লিখতে পারেন';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'বোর্ডের অবস্থা প্রয়োগ করা হয়েছে। FEN ক্লিপবোর্ডে অনুলিপি করা হয়েছে।';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'পরামর্শ: বোর্ডের একটি আরও স্পষ্ট ছবি তুলতে চেষ্টা করুন';

  @override
  String get llmPromptTemplate => 'LLM প্রম্পট টেমপ্লেট';

  @override
  String get noValidBoardDetected => 'কোনো বৈধ বোর্ড সনাক্ত করা যায়নি';

  @override
  String get selectingImageFromAlbum =>
      'অ্যালবাম থেকে ছবি নির্বাচন করা হচ্ছে...';

  @override
  String get configurePromptTemplate => 'প্রম্পট টেমপ্লেট কনফিগার করুন';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'LLM বিশ্লেষণের জন্য প্রম্পট টেমপ্লেট সম্পাদনা করুন';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'সনাক্তকৃত বোর্ড থেকে FEN তৈরি করা যায়নি';

  @override
  String get outputInCurrentLanguage => 'বর্তমান ভাষায় আউটপুট';

  @override
  String get commonBaseUrls => 'সাধারণ Base URLs';

  @override
  String get viewCommonModels => 'সাধারণ মডেল দেখুন';

  @override
  String get recognitionParametersUpdated =>
      'সনাক্তকরণ প্যারামিটার আপডেট হয়েছে';

  @override
  String get whiteSMove => 'সাদা খেলোয়াড়ের চাল';

  @override
  String get resetToDefaults => 'ডিফল্ট মানে রিসেট করুন';

  @override
  String get photoShoot => 'ছবি তোলা';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'সনাক্তকৃত বোর্ড অবস্থা প্রয়োগ করা যায়নি';

  @override
  String get llmPromptContent => 'LLM প্রম্পট সামগ্রী';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM কনফিগার করা হয়নি। অনুগ্রহ করে আপনার সেটিংস পরীক্ষা করুন।';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'প্রোভাইডার, মডেল, API Key এবং Base URL সেট করুন';

  @override
  String get llmConfiguration => 'LLM কনফিগারেশন';

  @override
  String get configureLlmProvider => 'LLM প্রোভাইডার কনফিগার করুন';

  @override
  String get llmPromptTemplateHeader => 'LLM প্রম্পট টেমপ্লেট হেডার';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'চিত্রে কোনো গুটি সনাক্ত করা যায়নি। দয়া করে পুনরায় চেষ্টা করুন।';

  @override
  String get recognizeBoardFromImage => 'ছবি থেকে বোর্ড সনাক্ত করুন';

  @override
  String get viewTips => 'টিপস দেখুন';

  @override
  String get applyToBoard => 'বোর্ডে প্রয়োগ করুন';

  @override
  String get adjustBoardArea => 'বোর্ড এলাকা সামঞ্জস্য করুন';

  @override
  String get viewCommonUrls => 'সাধারণ URLs দেখুন';

  @override
  String get colorAnalysisFailed => 'রঙ বিশ্লেষণ ব্যর্থ!';

  @override
  String get analyzingGameBoardImage => 'গেম বোর্ডের ছবি বিশ্লেষণ করা হচ্ছে...';

  @override
  String get selectFromAlbum => 'অ্যালবাম থেকে নির্বাচন করুন';

  @override
  String get noBoardPointDetected => 'কোনও বোর্ড বিন্দু শনাক্ত করা যায়নি!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'ফাঁকা রাখলে ডিফল্ট টেমপ্লেট ব্যবহার করা হবে';

  @override
  String get llmConfig => 'LLM কনফিগারেশন';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'আপনি কি নিশ্চিত যে প্রম্পট টেমপ্লেটগুলো ডিফল্ট মানে পুনরায় সেট করতে চান?';

  @override
  String get llmPromptTemplateFooter => 'LLM প্রম্পট টেমপ্লেট ফুটার';

  @override
  String get loadingResponse => 'উত্তর লোড হচ্ছে...';

  @override
  String get applyThisResultToBoard => 'এই ফলাফল বোর্ডে প্রয়োগ করুন';

  @override
  String get takingPicture => 'ছবি তোলা হচ্ছে...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'সনাক্তকরণের জন্য গেম বোর্ডের একটি ছবি নির্বাচন করুন';

  @override
  String get identificationResults => 'সনাক্তকরণের ফলাফল';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'চালগুলো বিশ্লেষণ করুন এবং অন্তর্দৃষ্টি প্রদান করুন।';

  @override
  String get getApiKey => 'API Key পান';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'সম্পূর্ণ সনাক্তকরণ প্রক্রিয়া সম্পন্ন করা যায়নি';

  @override
  String get boardRecognitionResult => 'বোর্ড সনাক্তকরণের ফলাফল';

  @override
  String get askLlm => 'LLM-কে জিজ্ঞাসা করুন';

  @override
  String get boardDetectionFailed => 'বোর্ড সনাক্তকরণ ব্যর্থ হয়েছে!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'কোনও বোর্ড বিন্দু শনাক্ত করা যায়নি, গুটি সনাক্ত করা সম্ভব নয়!';

  @override
  String get copyFen => 'FEN অনুলিপি করুন';

  @override
  String get commonlyUsedModels => 'সাধারণভাবে ব্যবহৃত মডেল';

  @override
  String get apiKeyOptional => 'API Key (ঐচ্ছিক)';

  @override
  String get noImageSelected => 'কোনও ছবি নির্বাচিত হয়নি';

  @override
  String get blackSMove => 'কালো খেলোয়াড়ের চাল';

  @override
  String get llm => 'বড় ভাষা মডেল';

  @override
  String get llmProvider => 'প্রদানকারী';

  @override
  String get baseUrl => 'বেস URL';

  @override
  String get model => 'মডেল';

  @override
  String get temperature => 'তাপমাত্রা';

  @override
  String get llmCommandReceivedProcessing =>
      'কমান্ড গৃহীত! এআই প্রক্রিয়াকরণ করছে...';

  @override
  String get llmDeepThinkingWait =>
      'গভীর চিন্তা চলছে, অনুগ্রহ করে অপেক্ষা করুন...';

  @override
  String get llmPresentingSoon => 'শীঘ্রই উপস্থাপন করা হবে...';

  @override
  String get recognitionParameters => 'সনাক্তকরণের পরামিতি';

  @override
  String get adjustParamsDesc =>
      'সনাক্তকরণের সঠিকতা বাড়াতে পরামিতি সমন্বয় করুন';

  @override
  String get saveParameters => 'পরামিতি সংরক্ষণ করুন';

  @override
  String unableToStartImageRecognition(String error) {
    return 'ছবি সনাক্তকরণ শুরু করা যাচ্ছে না: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'ছবি সনাক্তকরণ ব্যর্থ: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return '$whiteCount টি সাদা ও $blackCount টি কালো ঘুটি সহ অবস্থান প্রয়োগ করা হয়েছে';
  }

  @override
  String get fenCopiedToClipboard => '(FEN ক্লিপবোর্ডে কপি করা হয়েছে)';

  @override
  String recognitionFailed(String error) {
    return 'সনাক্তকরণ ব্যর্থ: $error';
  }

  @override
  String get myRating => 'আমার রেটিং';

  @override
  String get gamesPlayed => 'খেলা হয়েছে';

  @override
  String get wins => 'জয়';

  @override
  String get losses => 'পরাজয়';

  @override
  String get draws => 'ড্র';

  @override
  String get lastUpdated => 'সর্বশেষ আপডেট';

  @override
  String get format => 'ফরম্যাট:';

  @override
  String get resetStatistics => 'পরিসংখ্যান রিসেট করুন';

  @override
  String get drawRate => 'ড্র রেট';

  @override
  String get lossRate => 'পরাজয়ের হার';

  @override
  String get aiStatistics => 'এআই পরিসংখ্যান';

  @override
  String get enableStatistics => 'পরিসংখ্যান সক্রিয় করুন';

  @override
  String get enableStatistics_Detail =>
      'সক্রিয় করা হলে, খেলার ফলাফল পরিসংখ্যানে রেকর্ড করা হবে। তবে, টেক-ব্যাক জড়িত গেমগুলি রেকর্ড করা হবে না। নিষ্ক্রিয় করা হলে, পরিসংখ্যান সংগ্রহ সাময়িকভাবে বন্ধ হয়ে যায়।';

  @override
  String get thisWillResetAllGameStatistics =>
      'এটি সমস্ত খেলার পরিসংখ্যান রিসেট করবে। এই ক্রিয়াটি আর ফেরানো যাবে না।';

  @override
  String get boardInnerRingSize => 'বোর্ডের অভ্যন্তরীণ বৃত্তের আকার';

  @override
  String get boardShadowEnabled => 'বোর্ডের ছায়া';

  @override
  String get trapAwareness => 'ফাঁদ সচেতনতা';

  @override
  String get trapAwarenessDescription =>
      'বিশ্লেষণের সময় মোটা বৃত্ত ও তীর দিয়ে ফাঁদের চালগুলো হাইলাইট করুন।';

  @override
  String trapExists(String trapMoves) {
    return 'ফাঁদ রয়েছে। ফাঁদের চাল: $trapMoves';
  }

  @override
  String get custodianCapture => 'ফ্ল্যাঙ্কিং ক্যাপচার';

  @override
  String get custodianCaptureDescription =>
      'এটি ক্যাপচারের জন্য আপনার দু\'জনের মধ্যে আপনার প্রতিপক্ষের টুকরোগুলির মধ্যে একটিকে সংযুক্ত করুন।';

  @override
  String get custodianCaptureEnable => 'ফ্ল্যাঙ্কিং ক্যাপচারের অনুমতি দিন';

  @override
  String get interventionCapture => 'হস্তক্ষেপ ক্যাপচার';

  @override
  String get interventionCaptureDescription =>
      'উভয়কে ক্যাপচার করতে আপনার প্রতিপক্ষের দুটি টুকরোগুলির মধ্যে খালি পয়েন্টে যান।';

  @override
  String get interventionCaptureEnable => 'হস্তক্ষেপ ক্যাপচারের অনুমতি দিন';

  @override
  String get leapCapture => 'জাম্প ক্যাপচার';

  @override
  String get leapCaptureDescription =>
      'একটি সংলগ্ন প্রতিপক্ষের টুকরোটি খালি পয়েন্টের বাইরে লাফিয়ে ক্যাপচার করুন।';

  @override
  String get leapCaptureEnable => 'জাম্প ক্যাপচারের অনুমতি দিন';

  @override
  String get captureApplicableLines => 'প্রযোজ্য লাইন';

  @override
  String get captureSquareEdges => 'স্কোয়ারের প্রান্ত বরাবর';

  @override
  String get captureCrossLines => 'বর্গক্ষেত্র পেরিয়ে অরথোগোনাল লাইন বরাবর';

  @override
  String get captureDiagonalLines => 'স্কোয়ারটি অতিক্রমকারী তির্যক রেখা বরাবর';

  @override
  String get captureExecutionPhases => 'মৃত্যুদন্ডের পর্যায়গুলি';

  @override
  String get capturePiecesCondition =>
      'অবশিষ্ট টুকরা উপর ভিত্তি করে চলন্ত পর্যায়ে প্রাপ্যতা';

  @override
  String get capturePiecesConditionUnlimited => 'কোন বিধিনিষেধ';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'আপনার যখন তিন বা তার চেয়ে কম টুকরো থাকে তখন উপলব্ধ';
}
