// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Bulgarian (`bg`).
class SBg extends S {
  SBg([String locale = 'bg']) : super(locale);

  @override
  String get appName => 'Мелница';

  @override
  String get welcome => 'Добре дошли';

  @override
  String get yes => 'Да';

  @override
  String get no => 'Не';

  @override
  String get game => 'Игра';

  @override
  String get humanVsAi => 'Човек срещу AI';

  @override
  String get humanVsHuman => 'Човек срещу човек';

  @override
  String get aiVsAi => 'AI срещу AI';

  @override
  String get humanVsCloud => 'Човек срещу облак';

  @override
  String get humanVsLAN => 'Човек срещу LAN';

  @override
  String get testViaLAN => 'Тест чрез LAN';

  @override
  String get move => 'Преместване';

  @override
  String get showMoveList => 'Списък с ходове';

  @override
  String get moveList => 'Списък с ходове';

  @override
  String get noGameRecord => 'Няма запис';

  @override
  String get ok => 'OK';

  @override
  String get confirm => 'Потвърдете';

  @override
  String get cancel => 'Отказ';

  @override
  String get tipSelectWrong => 'Избрали сте неправилната фигура.';

  @override
  String get tipPlace => 'Поставете фигурите си.';

  @override
  String get tipBanPlace => 'Не можете да я поставите тук.';

  @override
  String get tipPlaced => 'Поставихте фигурите.';

  @override
  String get tipRemove => 'Премахнете фигура.';

  @override
  String get tipBanRemove => 'Не можете да я премахнете.';

  @override
  String get tipRemoved => 'Премахнахте фигурата.';

  @override
  String get tipMove => 'Преместване на фигура.';

  @override
  String get tipCannotPlace => 'Не можете да поставите фигура тук.';

  @override
  String get tipCannotMove => 'Не можете да преместите фигурата си тук.';

  @override
  String get tipMill => 'Мелница! Премахнете фигура на противника.';

  @override
  String get tipContinueMill =>
      'Продължете да премахвате фигурите на противника.';

  @override
  String get tipSelectOpponentsPiece =>
      'Изберете една от фигурите на противника си.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Не можете да премахнете фигура от мелница.';

  @override
  String get tipCanMoveOnePoint => 'Една фигура може да се премести с 1 поле.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Не можете да местите фигурите на противника си.';

  @override
  String get tipSelectPieceToMove => 'Изберете фигура, която да преместите.';

  @override
  String get tipHaveThreePiecesLeft => 'Остават ви три фигури.';

  @override
  String get tipCanMoveToAnyPoint =>
      'Можете да се преместите до всяко поле, което пожелаете.';

  @override
  String tipToMove(Object player) {
    return '$player за преместване.';
  }

  @override
  String get whiteWin => 'Играч 1 печели!';

  @override
  String get blackWin => 'Играч 2 печели!';

  @override
  String get won => 'Печели';

  @override
  String get lost => 'Загуба';

  @override
  String get thinking => 'Мислене…';

  @override
  String get newGame => 'Нова игра';

  @override
  String get importGame => 'Внесена игра';

  @override
  String get exportGame => 'Експорт на игра';

  @override
  String get gameImported => 'Играта е импортирана.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Не може да се импортира $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'Движенията и правилата не съвпадат.';

  @override
  String get pleaseWait => 'Моля, изчакайте.';

  @override
  String get restartGame => 'Да рестартирате текущата игра?';

  @override
  String get restart => 'Рестартирайте';

  @override
  String get gameStarted => 'Играта започна, моля, поставете.';

  @override
  String get analyzing => 'Анализиране на…';

  @override
  String error(Object message) {
    return 'Грешка: $message';
  }

  @override
  String get winRate => 'Степен на победа';

  @override
  String get score => 'Резултат:';

  @override
  String get white => 'Играч 1';

  @override
  String get black => 'Играч 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return 'Броят на $player е по-малък от три.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player отстъпва.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player няма как да отиде.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Платката е пълна и $player няма как да отиде.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Времето свърши, $player загубен.';
  }

  @override
  String get drawReasonRule50 =>
      'Във фазата на придвижване нито една фигура не е била премахната през последния определен брой ходове.';

  @override
  String get drawReasonBoardIsFull => 'Това е реми, защото дъската е пълна.';

  @override
  String get drawReasonThreefoldRepetition =>
      'Това е реми поради трикратното повторение.';

  @override
  String get gameOverUnknownReason => 'Играта свърши! Неизвестна причина.';

  @override
  String get gameOver => 'Играта свърши';

  @override
  String get youWin => 'Вие печелите! Поздравления!';

  @override
  String challengeHarderLevel(int level) {
    return 'Предизвикайте по-трудно ниво? Новото ниво ще бъде ниво $level!';
  }

  @override
  String get youLose => 'Загубихте!';

  @override
  String get analyze => 'Анализирайте';

  @override
  String get about => 'За';

  @override
  String version(Object versionNumber) {
    return 'Версия: $versionNumber';
  }

  @override
  String get thanks => 'Благодаря';

  @override
  String get settings => 'Настройки';

  @override
  String get options => 'Опции';

  @override
  String get generalSettings => 'Общи настройки';

  @override
  String get skillLevel => 'Ниво на трудност';

  @override
  String get moveTime => 'Време за мислене на AI';

  @override
  String get difficulty => 'Трудност';

  @override
  String get playSounds => 'Звукови ефекти';

  @override
  String get playSoundsInTheGame => 'Възпроизвеждане на звуци в играта';

  @override
  String get keepMuteWhenTakingBack => 'Запазване на звука при връщане';

  @override
  String get tone => 'Тон';

  @override
  String get whoMovesFirst => 'Първи ход';

  @override
  String get human => 'Човек';

  @override
  String get ai => 'AI';

  @override
  String get alternate => 'Алтернативен';

  @override
  String get isAutoRestart =>
      'Автоматично рестартиране на играта, когато играта приключи';

  @override
  String get isAutoChangeFirstMove => 'Автоматична промяна на първия ход';

  @override
  String get shufflingEnabled => 'Случаен ход';

  @override
  String get misc => 'Различни';

  @override
  String get rules => 'Правила';

  @override
  String get piecesCount => 'Броят на фигурите, с които разполага всеки играч';

  @override
  String get piecesCount_Detail => 'С колко фигури разполага всеки играч?';

  @override
  String get flyPieceCount => 'Номер на летящата фигура';

  @override
  String get flyPieceCount_Detail =>
      'Ако функцията \"Летяща фигура\" е активирана, когато броят на фигурите на даден играч е намален до определен брой, неговите фигури могат да се движат свободно до всяка незаета точка, вместо да бъдат ограничени до съседни точки, както е в останалата част от играта.';

  @override
  String get piecesAtLeastCount => 'Най-малко фигури';

  @override
  String get hasDiagonalLines => 'Диагонални линии';

  @override
  String get hasDiagonalLines_Detail =>
      'Добавете четири диагонални линии към дъската.';

  @override
  String get isDefenderMoveFirst => 'Вторият играч се движи първи';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Играчът, който се движи втори във фазата на поставяне, се движи първи във фазата на придвижване.';

  @override
  String get mayRemoveMultiple => 'Многократно преместване';

  @override
  String get mayRemoveMultiple_Detail =>
      'Ако играч затвори повече от една мелница наведнъж, той ще премахне броя на мелниците, които е затворил.';

  @override
  String get mayRemoveFromMillsAlways => 'Унищожаване на мелници';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'По подразбиране играчите трябва първо да премахнат всички други фигури, преди да премахнат фигура от образувана мелница. Активирайте тази опция, за да деактивирате ограничението.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Вторият играч губи, когато дъската е пълна';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Когато дъската е пълна в края на фазата на поставяне, страната, която постави първа, губи играта. В противен случай играта е реми.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Губи, когато няма законни ходове';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Играчът губи, ако противникът му ги блокира така, че да не могат да бъдат преместени. Променете страната за ход, ако тази опция е деактивирана.';

  @override
  String get mayFly => 'Летящ';

  @override
  String get mayFly_Detail =>
      'Ако на даден играч са му останали само три или четири (конфигурируеми) фигури, той може да премести фигура до всяка свободна точка.';

  @override
  String get nMoveRule => 'Правило за N ходове';

  @override
  String get nMoveRule_Detail =>
      'Играта се изтегля, ако няма премахване на фигури в определен брой ходове от всеки играч.';

  @override
  String get rollback => 'Връщане назад';

  @override
  String get pleaseSelect => 'Моля, изберете';

  @override
  String get copy => 'Копиране';

  @override
  String get moveHistoryCopied =>
      'Историята на ходовете се копира в клипборда.';

  @override
  String get help => 'Помощ';

  @override
  String get feedback => 'Обратна връзка';

  @override
  String get exit => 'Излизане от';

  @override
  String get ruleSettings => 'Правила';

  @override
  String get color => 'Цвят';

  @override
  String get boardColor => 'Цвят на дъската';

  @override
  String get pieceColor => 'Цвят на фигурата';

  @override
  String get backgroundColor => 'Цвят на фона';

  @override
  String get lineColor => 'Цвят на линията на дъската';

  @override
  String get whitePieceColor => 'Цвят на фигурата на играч 1';

  @override
  String get blackPieceColor => 'Цвят на фигурата на играч 2';

  @override
  String get messageColor => 'Цвят на съобщението';

  @override
  String get isPieceCountInHandShown =>
      'Показване на броя на фигурите в ръката';

  @override
  String get isNotationsShown => 'Показване на бележки на дъската';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Показване на лентата с инструменти за навигация в историята';

  @override
  String get display => 'Показване на';

  @override
  String get boardBorderLineWidth => 'Широчина на границите на дъската';

  @override
  String get boardInnerLineWidth => 'Ширина на вътрешната линия на дъската';

  @override
  String get pieceWidth => 'Широчина на парче';

  @override
  String get fontSize => 'Размер на шрифта';

  @override
  String get standardNotation => 'Нотация WMD';

  @override
  String get restore => 'Възстановяване на';

  @override
  String get restoreDefaultSettings =>
      'Възстановяване на настройките по подразбиране';

  @override
  String pick(Object element) {
    return 'Изберете $element';
  }

  @override
  String get info => 'Инф.';

  @override
  String get hint => 'Подсказка';

  @override
  String get player => 'Играч';

  @override
  String get player1 => 'Играч 1';

  @override
  String get player2 => 'Играч 2';

  @override
  String get howToPlay => 'Как се играе';

  @override
  String get toPlacePiece =>
      'Докоснете всяка налична точка, за да поставите фигурата.';

  @override
  String get toSelectPiece => 'Докоснете фигура, за да я преместите.';

  @override
  String get toMovePiece =>
      'Докоснете точка, свързана с фигура, за да я преместите.';

  @override
  String get toRemovePiece =>
      'Докоснете върху една от фигурите на противника, за да я премахнете.';

  @override
  String get needToCreateMillFirst =>
      'Първо трябва да създадете мелница, преди да можете да премахнете фигура.';

  @override
  String get needToPlayWithOwnPieces => 'Трябва да играете с фигурите си.';

  @override
  String get statistics => 'Статистика';

  @override
  String get totalGames => 'Общо игри';

  @override
  String get results => 'Резултати';

  @override
  String get left => 'вляво';

  @override
  String get privacyPolicy => 'Политика за поверителност';

  @override
  String get privacyPolicy_Detail_1 =>
      'Моля, прочетете внимателно и се уверете, че напълно разбирате и се съгласявате с нея ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Ако не сте съгласни с тази Политика, моля, не използвайте това приложение. Използването на приложението означава, че приемате тези условия.';

  @override
  String get and => ' и ';

  @override
  String get accept => 'Приемам';

  @override
  String get takeBack => 'Връщане назад';

  @override
  String get takingBack => 'Връщане назад…';

  @override
  String get waiting => 'Изчакване…';

  @override
  String get stepForward => 'Стъпка напред';

  @override
  String get takeBackAll => 'Върнете всичко';

  @override
  String get stepForwardAll => 'Стъпка напред всички';

  @override
  String get moveNow => 'Преместване сега';

  @override
  String get done => 'Готово.';

  @override
  String get crackMill => 'Крек-мелница';

  @override
  String get crackMill_Detail =>
      'Ако даден играч има само фигури в мелници, фигурите в мелниците няма да се заключат за премахване.';

  @override
  String get animationDuration => 'Продължителност на анимацията';

  @override
  String get none => 'Няма';

  @override
  String get theme => 'Тема';

  @override
  String get helpContent =>
      'Целта на играта е опонентът да остане с по-малко от три фигури или без позволени ходове.\n\nИграта автоматично се ремизира, ако дадена позиция се появи за трети път или не се премахне в последните 100 (конфигурируеми) хода.\n\nИграта протича в три фази:\n\n1. Поставяне на фигури на свободни точки\n2. Преместване на фигури в съседни точки\n3. (незадължителна фаза) Преместване на фигури в която и да е свободна точка, когато играчът е намалил броя на фигурите си до три\n\nПоставяне на\n\nИграта започва с празна дъска, която се състои от мрежа с двадесет и четири точки. Играчите се редуват да поставят фигурите си на свободните точки, докато всеки играч постави всички фигури на дъската. Ако даден играч успее да постави три от своите фигури направо, той има \"мелница\" и може да премахне една от фигурите на противника си от дъската.\n\nВ някои правила играчите трябва първо да премахнат всички други фигури, преди да премахнат фигура от образуваната мелница.\n\nВ някои правила не можете да поставяте фигури до точките на премахнатите фигури отново във фазата на поставяне.\n\nСлед като използвате всички фигури, играчите се редуват да се движат.\n\nПреместване\n\nЗа да се придвижи, играчът премества една от фигурите си по линия на дъската до свободна съседна точка. Ако не може да направи това, той е загубил играта. Както и във фазата на поставяне, играч, който подреди три от своите фигури на линия на дъската, има мелница и може да премахне една от фигурите на противника си. Всеки играч, който намали броя на фигурите си до две, няма възможност да образува нови мелници и по този начин губи играта. Играч може да загуби и когато има повече от три фигури, ако противникът му блокира движението им.\n\nЛетящ\n\nВ някои варианти на правилата, след като на даден играч са останали само три фигури, неговите фигури могат да летят, скачат или прескачат до всякакви свободни точки, а не само до съседни.';

  @override
  String get versionInfo => 'Информация за версията';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'Лиценз';

  @override
  String get sourceCode => 'Изходен код';

  @override
  String get appVersion => 'Версия на приложението';

  @override
  String get general => 'Общо';

  @override
  String get advanced => 'Разширени';

  @override
  String get placing => 'Пост.';

  @override
  String get moving => 'Прем.';

  @override
  String get removing => 'Премахване';

  @override
  String get gameOverCondition => 'Условие за край на играта';

  @override
  String get aisPlayStyle => 'Стил на игра на AI';

  @override
  String get passive => 'Пасивен';

  @override
  String get timeout => 'Прекъсване на времето';

  @override
  String get appearance => 'Външен вид';

  @override
  String get drawOnHumanExperience => 'Използвайте човешкия опит';

  @override
  String get considerMobility => 'Вземете предвид мобилността на частите';

  @override
  String get pieceCount => 'Брой парчета:';

  @override
  String inHand(Object player, int count) {
    return '$player в ръка: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player на борда: $count';
  }

  @override
  String get boardTop => 'Преместване на дъската отгоре';

  @override
  String get notAIsTurn => 'Не е ред на изкуствения интелект.';

  @override
  String get aiIsNotThinking => 'ИИ не мисли.';

  @override
  String get atEnd => 'Намирате се в края на списъка с ходове.';

  @override
  String get tapBackAgainToLeave => 'Докоснете отново назад, за да излезете.';

  @override
  String get more => 'Още';

  @override
  String get experimental => 'Това е експериментална функция.';

  @override
  String get experiments => 'Експерименти';

  @override
  String get ossLicenses => 'Лицензи с отворен код';

  @override
  String get language => 'Език';

  @override
  String get defaultLanguage => 'Език по подразбиране';

  @override
  String get mayMoveInPlacingPhase =>
      'Фигурите могат да се движат във фазата на поставяне';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Няма отделни фази на поставяне и преместване, т.е. играчите могат да решават при всеки ход дали искат да поставят фигура на дъската или да преместят някоя от своите фигури (стига да имат останали фигури за поставяне).';

  @override
  String get drawerColor => 'Цвят на менюто';

  @override
  String get drawerTextColor => 'Цвят на текста в менюто';

  @override
  String get drawerHighlightItemColor =>
      'Цвят на елемента за подчертаване на менюто';

  @override
  String get mainToolbarBackgroundColor =>
      'Основен цвят на фона на лентата с инструменти';

  @override
  String get mainToolbarIconColor =>
      'Ц вят на иконата на основната лента с инструменти';

  @override
  String get navigationToolbarBackgroundColor =>
      'Цвят на фона на лентата с инструменти за навигация';

  @override
  String get navigationToolbarIconColor =>
      'Цвят на иконата на лентата с инструменти за навигация';

  @override
  String get autoHideToolbar => 'Автоматично скриване на лентата с инструменти';

  @override
  String get toolbarLocationOnScreen =>
      'Местоположение на лентата с инструменти на екрана';

  @override
  String get top => 'Топ';

  @override
  String get bottom => 'Дъно';

  @override
  String get center => 'Център';

  @override
  String get solidColor => 'Плътен цвят';

  @override
  String get picture => 'Снимка';

  @override
  String get chooseYourPicture => 'Изберете своята снимка';

  @override
  String get light => 'Светлина';

  @override
  String get dark => 'Тъмно';

  @override
  String get themes => 'Теми';

  @override
  String get currentTheme => 'Текуща тема';

  @override
  String get saveTheme => 'Запазване на темата';

  @override
  String get showAnalysisGraph => 'Показване на графиката за анализ';

  @override
  String get analysis => 'Анализ';

  @override
  String get saveGame => 'Запазване на играта';

  @override
  String get loadGame => 'Зареждане на играта';

  @override
  String get setupPosition => 'Позиция за настройка';

  @override
  String get showLegalMoves => 'Показване на законни ходове';

  @override
  String get showLastMove => 'Показване на последния ход';

  @override
  String get showArrows => 'Показване на стрелките';

  @override
  String get pieces => 'Парчета';

  @override
  String get showAnalysis => 'Показване на анализ';

  @override
  String get threads => 'Нишки';

  @override
  String get getInvolved => 'Включете се';

  @override
  String get helpImproveTranslate => 'Помогнете за подобряване на превода';

  @override
  String get tutorial => 'Учебник';

  @override
  String get classicMill => 'Класическа мелница';

  @override
  String get mixedMill => 'Смесена мелница';

  @override
  String get ceylonMill => 'Цейлонска мелница';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Мелницата може да бъде счупена и преправена многократно';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Ако играч счупи мелница, за да създаде веднага нова мелница, той може да премести тази фигура обратно в оригиналния възел в следващия си ход, ако тя създава нова мелница.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Играта е реми, ако един от играчите има три фигури и след десет хода никой от тях не премахне фигурите на противника';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Когато един играч има само три фигури и никой от тях не може да отстрани противникова фигура в рамките на десет хода, играта е реми.';

  @override
  String get close => 'Близо';

  @override
  String get whitePiece => 'Бяло парче';

  @override
  String get blackPiece => 'Черно парче';

  @override
  String get emptyPoint => 'Празна точка';

  @override
  String get noPoint => 'Няма смисъл';

  @override
  String get placingPhase => 'Фаза на поставяне';

  @override
  String get movingPhase => 'Фаза на преместване';

  @override
  String get flyingPhase => 'Фаза на летене';

  @override
  String sideToMove(Object player) {
    return 'Страна за движение: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Последен ход: $move';
  }

  @override
  String get selected => 'Избрано';

  @override
  String get accessibility => 'Достъпност';

  @override
  String get screenReaderSupport => 'Поддръжка на екранен четец';

  @override
  String get isDraw => 'Това е равенство!';

  @override
  String get draw => 'Рисувам';

  @override
  String get pieceHighlightColor => 'Цвят за подчертаване на парче';

  @override
  String get algorithm => 'Алгоритъм';

  @override
  String get endgameNMoveRule => 'Правило N-Move на финала';

  @override
  String get endgameNMoveRule_Detail =>
      'Ако някой от играчите има само три фигури и нито един от тях не премахне фигурата в рамките на определени ходове, играта е равен.';

  @override
  String get drawReasonEndgameRule50 =>
      'Всеки играч има само три фигури и нито един играч не премахва фигура в рамките на определени ходове.';

  @override
  String get threefoldRepetitionRule => 'Правило за трикратно повторение';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Играта се тегли, ако позиция се появи за трети път.';

  @override
  String get continueToMakeMove => 'Мелница! Продължете да правите ход.';

  @override
  String get pointStyle => 'Точков стил';

  @override
  String get pointWidth => 'Ширина на точката';

  @override
  String get solid => 'Твърд';

  @override
  String get hollow => 'Куха';

  @override
  String get languageName => 'български';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Ходове',
      one: '$count Преместване',
      zero: 'Move',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Неуспешно зареждане.';

  @override
  String get filename => 'Име на файл';

  @override
  String get browse => 'Преглед…';

  @override
  String get gameFiles => 'Файлове за игри';

  @override
  String get gameSavedTo => 'Играта е запазена в';

  @override
  String get empty => 'Празна';

  @override
  String get noMove => 'Без движение.';

  @override
  String get restoredPosition => 'Възстановена първоначална позиция.';

  @override
  String get clean => 'Чисто';

  @override
  String get cleanedUp => 'Почистен.';

  @override
  String get remove => 'Премахване';

  @override
  String get noPiecesCanBeRemoved =>
      'Никакви парчета не могат да бъдат премахнати.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count piece',
      one: '$count piece',
      zero: 'Piece',
    );
    return '$_temp0 трябва да бъдат премахнати.';
  }

  @override
  String placedCount(int count) {
    return 'Пост. ($count)';
  }

  @override
  String get placedPieceCount =>
      'Броят поставени фигури във фазата на поставяне.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'Текущият играч е поставил $count фигури.';
  }

  @override
  String get notPlacingPhase => 'Не поставя фаза, не може да я промени.';

  @override
  String get paste => 'Залепете';

  @override
  String get pasteDone => 'Пастата е готова.';

  @override
  String get cannotPaste => 'Не може да се постави.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Показване на непоставени и премахнати фигури';

  @override
  String get fullScreen => 'Цял екран';

  @override
  String get reopenToTakeEffect =>
      'Излезте и отворете отново приложението, за да влязат в сила настройките.';

  @override
  String get forest => 'гора';

  @override
  String get desktopImage => 'Изображение на работния плот';

  @override
  String get invalidPosition => 'Невалидна позиция.';

  @override
  String get shareGIF => 'Споделете GIF';

  @override
  String get pixelRatio => 'Съотношение на пикселите';

  @override
  String get duration => 'Продължителност';

  @override
  String get gameScreenRecorder => 'Рекордер на екрана на играта';

  @override
  String get previous => 'Предишен';

  @override
  String get next => 'Следващия';

  @override
  String get skip => 'Пропускане';

  @override
  String get gotIt => 'Схванах го';

  @override
  String get youCanModifyRules =>
      'Можете да промените правилата на играта в настройките на правилата.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Можете да използвате колелцето на мишката, за да промените стойността в инструмента за избор.';

  @override
  String get noTimeLimitForThinking =>
      'Времето за мислене на AI, зададено на 0, означава, че няма ограничение във времето за мислене.';

  @override
  String get whatIsMtdf =>
      'MTD(f) е модифицирана форма на алфа-бета алгоритъма за търсене, който има за цел да подобри ефективността чрез повторно използване на междинни резултати от търсене и използване на добро първоначално предположение за стесняване на пространството за търсене.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Моля, имайте предвид, че настройката на времето за мислене на AI може да не е напълно точна. Действителното време за мислене може да е по-кратко, когато нивото на трудност е зададено на по-ниска стойност и може да е по-дълго, когато AI е в средата на мисленето, когато времето изтече.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Ако зададете високо ниво на трудност, но не увеличите времето за мислене на AI, действителното ниво на трудност може да бъде ограничено до по-ниска стойност поради ограничението във времето за мислене. Действителната стойност може да варира в зависимост от работата на машината.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) е алгоритъм за търсене за намиране на най-добрия ход в дадена позиция. Това е подобрение на алфа-бета алгоритъма и използва нулеви или нулеви търсения в прозореца, за да потвърди, че даден ход е по-лош или не по-лош от вече безопасен резултат от основната вариация. PVS се фокусира върху най-обещаващите ходове и избягва ненужните търсения на неоптимални разклонения, което спомага за подобряване на ефективността на търсенето.';

  @override
  String get whatIsAlphaBeta =>
      'Алфа-бета алгоритъмът е алгоритъм за търсене за намиране на най-добрия ход. Той използва принципа на минимакс и две стойности, алфа и бета, за съкращаване на дървото за търсене и повишаване на ефективността. Алфа представлява минималния резултат, който компютърът е сигурен, че може да получи, докато бета представлява максималния резултат, който неговият опонент може да получи. Алгоритъмът помага на компютъра да взема интелигентни и ефективни решения в игра.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Според човешкия опит, ако се опитате да спечелите, ще загубите. Вместо това се стремете към равенство като ваша цел и избягвайте загубата на играта. Наблюдавайте опонента си и внимателно го примамвайте в позиция, в която може да направи грешки. Когато покажат слабост, грабнете възможността и внимателно настоявайте за победата. По този начин можете да спечелите играта.';

  @override
  String get firstMoveDetail =>
      'В тази игра е по-лесно за втория играч да спечели в сравнение с първия играч.';

  @override
  String get passiveDetail =>
      'Активирането на опцията Passive ще накара AI да се отпусне, когато има предимство в позицията, вместо да се опитва агресивно да спечели възможно най-бързо.';

  @override
  String get moveRandomlyDetail =>
      'Активирането на тази опция увеличава произволността и забавлението на играта, докато деактивирането й може да помогне в изучаването на начини за победа над AI.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Ако AI вземе предвид мобилността на своите фигури, той не само ще се стреми да улови фигурите на противника възможно най-бързо, но също така ще обмисли блокиране на движенията на противника и предотвратяване на същото.';

  @override
  String get whenBoardIsFull => 'Когато дъската е пълна';

  @override
  String get whenBoardIsFull_Detail =>
      'В края на фазата на поставяне, преди да започне фазата на преместване, действието следва, ако дъската е пълна с фигури.';

  @override
  String get sideToMoveRemovePiece =>
      'Играчът, който се движи първи във фазата на движение, премахва една от фигурите на противника.';

  @override
  String get agreeToDraw => 'И двете страни се съгласяват на равенство.';

  @override
  String get takeOpponentsPiece => 'Вземете една от фигурите на опонента си.';

  @override
  String get firstPlayerLose => 'Първият играч губи играта.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Първият и вторият играч премахват една от фигурите на противника.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Вторият и първият играч премахват една от фигурите на противника.';

  @override
  String get enteredFlyingPhase =>
      'След навлизане във фазата на летене фигурите на противника могат да скочат до всяка празна точка на дъската. Можете да изключите правилото за летене в „Настройки на правилото“.';

  @override
  String get whenStalemate => 'При патова ситуация';

  @override
  String get whenStalemate_Detail =>
      'Какво действие следва, когато нито една фигура не може да бъде преместена?';

  @override
  String get endWithStalemateLoss => 'Край със загуба в безизходица.';

  @override
  String get changeSideToMove => 'Променете страната, за да се движите.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Премахнете една от фигурите на противника и направете следващия ход.';

  @override
  String get endWithStalemateDraw => 'Завършете с патово равенство.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Премахнете една от фигурите на противника и сменете страната, за да се движите.';

  @override
  String get aiResponseDelayTime => 'Време за забавяне на реакцията на AI';

  @override
  String get aiIsDelaying =>
      'AI в момента е във фаза на забавена реакция. Моля, изчакайте известно време, преди да продължите.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Не можете да премахнете несъседна част.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'Ако е безизходица, фигурите на противника, съседни на вашите, могат да бъдат премахнати, независимо от формацията на мелницата.';

  @override
  String get whatIsMcts =>
      'MCTS е удобен за начинаещи алгоритъм, който взема решения, като изследва и оценява различни ходове чрез симулации.';

  @override
  String get goldenJade => 'Златен нефрит';

  @override
  String get forestWood => 'Горско дърво';

  @override
  String get darkMystery => 'Тъмна мистерия';

  @override
  String get midnightBlue => 'Среднощно синьо';

  @override
  String get greenForest => 'Зелена гора';

  @override
  String get greenMeadow => 'Зелена поляна';

  @override
  String get stonyPath => 'Каменист път';

  @override
  String get pastelPink => 'Пастелно розово';

  @override
  String get turquoiseSea => 'Тюркоазено море';

  @override
  String get violetDream => 'Виолетова мечта';

  @override
  String get mintChocolate => 'Ментов шоколад';

  @override
  String get skyBlue => 'Небесно синьо';

  @override
  String get playfulGarden => 'Игрива градина';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Алгоритъмът за ретрограден анализ използва ретрограден анализ с множество стойности, за да изгради база данни за края на играта от различни начални позиции, след което прилага тази база данни за оптимизиране на играта. Този подход попада в категорията на Ultra-Strong решения.';

  @override
  String get viewAlgorithmGuide =>
      'Искате ли да видите ръководството за потребителя за този алгоритъм?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Показване на индикатор за позиционно предимство';

  @override
  String get usePerfectDatabase => 'Използвайте перфектна база данни';

  @override
  String get perfectDatabaseDescription =>
      'Активирайте тази опция, за да използвате безупречна база данни за игри, генерирана чрез авангардни алгоритми. Тази функция интегрира както начална, така и крайна стратегия, за да предложи оптимални ходове. Това е предпочитаният избор за играчи, които търсят най-високо ниво на прецизност в играта. Създадена чрез щателни изчислителни техники, базата данни е проектирана да предлага почти перфектни решения за игри.\n\nЗабележка: Ако изкуственият интелект не успее да получи достъп до базата данни, той ще се обърне към конвенционални алгоритми за решения в играта. Когато базата данни е достъпна, „Нивото на трудност“ става практически непобедимо, а „Времето за мислене на AI“ претърпява драстично намаление. Много настройки в опциите на „AI\'s play style“ ще бъдат заменени, тъй като резултатите от базата данни имат най-висок приоритет.\n\nЗа насоки как да се възползвате максимално от тази безупречна база данни, щракнете тук.';

  @override
  String get backgroundImage => 'Фоново изображение';

  @override
  String get whatIsRandom =>
      'Когато опцията „Използване на перфектна база данни“ не е активирана, настройката „Произволно“ кара AI да мести фигури произволно, без да използва никакви алгоритми за избор на ход. Това обикновено води до значително по-слаб геймплей. Обратно, когато „Използване на перфектната база данни“ е активирано, AI разчита изключително на „Перфектната база данни“ за вземане на решения, вместо да я смесва с традиционните алгоритми на AI. В този режим ходовете на AI са изцяло базирани на съдържанието на базата данни, като се избягва зависимостта от изчисления в реално време или алгоритми за търсене.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Премахнете фигурата(ите) на опонента от ръката му; след това е ред на опонента да постави.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'При образуване на мелници по време на фазата на поставяне';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Премахнете фигурата(ите) на опонента от дъската.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Премахнете фигурата(ите) на опонента от дъската; след това е ред на опонента да постави.';

  @override
  String get opponentRemovesOwnPiece =>
      'Опонентът премахва своята(ите) фигура(и) от дъската.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Вместо вие да предприемете действие, опонентът избира и премахва своята(ите) фигура(и) от дъската, ефективно предприемайки действие, което е в негова вреда.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Премахнете фигурата(ите) на опонента от ръката му; след това е ваш ред да се преместите.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Премахнете фигурата(ите) от ръката на опонента. Ако, според настройката за многократно премахване, трябва да се премахнат няколко фигури и опонентът няма останали фигури в ръката си, продължете да премахвате фигурите на опонента от дъската. След това е ваш ред да се преместите. Ако продължите да образувате мелници, можете да продължите да премахвате фигурите на опонента.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Премахнете фигурата(ите) от ръката на опонента. Ако, според настройката за многократно премахване, трябва да се премахнат няколко фигури и опонентът няма останали фигури в ръката си, продължете да премахвате фигурите на опонента от дъската. След това е ред на опонента да се премести.';

  @override
  String get markAndDelayRemovingPieces =>
      'Маркирайте и забавете премахването на фигурите.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'По време на фазата на поставяне, фигурите, които трябва да бъдат премахнати, се маркират и за двамата играчи не могат да се поставят нови фигури на тези точки. При влизане във фазата на преместване, тези маркирани фигури се премахват заедно и играчите могат да преместят своите фигури на тези вече празни точки.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Действията, които могат да бъдат предприети при формиране на мелници по време на фазата на поставяне.';

  @override
  String get marked => 'Маркирано';

  @override
  String get menu => 'Меню';

  @override
  String get monochrome => 'Монохром';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Можете да активирате поддръжката на екранен четец в настройките за достъпност в Общи настройки.';

  @override
  String get showNumbersOnPieces => 'Показване на номерата на фигурите';

  @override
  String get saveImage => 'Запази изображението';

  @override
  String get isAnalysisToolbarShown => 'Покажете лентата за анализ';

  @override
  String get analysisToolbarBackgroundColor =>
      'Цвят на фона на лентата за анализ';

  @override
  String get analysisToolbarIconColor => 'Цвят на иконата на лентата за анализ';

  @override
  String get transformed => 'Трансф.';

  @override
  String get cannotTransform => 'Невъзможно трансформиране.';

  @override
  String get rotate => 'Завъртане';

  @override
  String get horizontalFlip => 'Хор. Обр.';

  @override
  String get verticalFlip => 'Верт. Обр.';

  @override
  String get innerOuterFlip => 'ВВ Обр.';

  @override
  String get transparentCanvas => 'Прозрачно Платно';

  @override
  String get restrictRepeatedMillsFormation =>
      'Ограничаване на повторното образуване на мелници';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Пиеса, преместена от един мелничен кръг в друг, не може незабавно да се върне в оригиналната точка на следващия ход, за да образува отново мелничен кръг. Първо е необходимо друго движение.';

  @override
  String get oneTimeUseMill => 'Еднократна използване на мелница';

  @override
  String get oneTimeUseMill_Detail =>
      'Всяка мелница може да премахне само една част от противника. Можете да го реформирате отново, но не може да се използва за допълнителни премахвания.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Настоящите правила, които сте задали, нямат съответна перфектна база данни. За повече информация относно перфектната база данни, моля, кликнете тук.';

  @override
  String get focusOnBlockingPaths => 'Фокус върху блокиране на пътища';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Приоритизирайте блокирането на движението на противника вместо формирането на тройки. Вместо да се фокусирате върху премахването на фигури чрез завършване на тройки, AI цели да вкара противника в капан, като го направи неспособен да се движи и да осигури победа чрез изтощение, а не чрез агресивна игра. Тази стратегия не блокира активно тройките на противника.';

  @override
  String get pieceImage => 'Изображение на фигура';

  @override
  String get importColorSettings => 'Импортиране на настройки за цвят';

  @override
  String get exportColorSettings => 'Експортиране на настройки за цвят';

  @override
  String get import => 'Импорт';

  @override
  String get export => 'Експорт';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Моля, първо копирайте настройките за формат JSON в клипборда.';

  @override
  String get copiedToClipboard => 'Копирано в клипборда.';

  @override
  String get imported => 'Импортирано.';

  @override
  String get boardImage => 'Изображение на дъска';

  @override
  String get autumnLeaves => 'Есенни листа';

  @override
  String get legendaryLand => 'Легендарна земя';

  @override
  String get vignetteEffect => 'Ефект винетка';

  @override
  String get promptMakeToolbarTransparent =>
      'Бихте ли искали да направите лентата с инструменти напълно прозрачна, когато е зададена фоново изображение на дъската?';

  @override
  String get vibration => 'Активиране на вибрацията в играта';

  @override
  String get soundTheme => 'Тема на звука';

  @override
  String get ball => 'Топка';

  @override
  String get liquid => 'Течност';

  @override
  String get wood => 'Дърво';

  @override
  String get placeEffectAnimation =>
      'Анимационен ефект при поставяне на фигура';

  @override
  String get removeEffectAnimation =>
      'Анимационен ефект при премахване на фигура';

  @override
  String get isToolbarAtBottom =>
      'Показване на лентата с инструменти в долната част';

  @override
  String get boardCornerRadius => 'Радиус на ъгъла на дъската';

  @override
  String get useOpeningBook => 'Използвайте книга за откриване';

  @override
  String get currentRule => 'Текущи';

  @override
  String get nineMensMorris => 'Девет човека Мелница';

  @override
  String get twelveMensMorris => 'Дванадесет човека Мелница';

  @override
  String get morabaraba => 'Моарабараба';

  @override
  String get dooz => 'Дуз';

  @override
  String get chamGonu => 'Чамгоно';

  @override
  String get zhiQi => 'Джичи';

  @override
  String get chengSanQi => 'Ченгсанчи';

  @override
  String get mulMulan => 'Мул-Мулан';

  @override
  String get nerenchi => 'Неренчи';

  @override
  String get ruleSet => 'Комплект правила';

  @override
  String get laskerMorris => 'Ласкер Морис';

  @override
  String get oneTimeMill => 'Еднократна мелница';

  @override
  String get daSanQi => 'Да Санчи';

  @override
  String get useOpeningBook_Detail =>
      'Позволете на изкуствения интелект да използва начални ходове, често използвани от професионални човешки играчи по време на ранната игра. Забележка: Тази функция в момента е налична само за специфични комплекти правила.';

  @override
  String get showAdvantageGraph => 'Покажи графиката на предимството';

  @override
  String get advantageGraphHint =>
      'Графиката на предимството ще бъде изчертана само след като ИИ направи ход. Няма да бъде изчертана, когато човешкият играч направи ход.';

  @override
  String get removalBasedOnMillCounts =>
      'Изключете премахването, докато всички пулове не бъдат поставени. Играчите премахват пулове въз основа на броя мелници.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Изключете премахването, докато всички пулове не бъдат поставени. Играчите премахват пулове въз основа на броя мелници: ако броят е равен, и двамата премахват еднакъв брой; ако единият има повече, той премахва една допълнителна пулка, запазвайки разлика от една пулка. Ако само един образува мелница, той премахва две пулки, а другият – една. Ако нито един не образува мелница, и двамата премахват по една пулка.';

  @override
  String get elfilja => 'Ел Филджа';

  @override
  String get tipSelectOwnPiece => 'Изберете една от вашите фигури.';

  @override
  String get notYourTurn => 'Не е ваш ред.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Цвят на фона на лентата с инструменти за анотации';

  @override
  String get annotationToolbarIconColor =>
      'Цвят на иконите на лентата с инструменти за анотации';

  @override
  String get isAnnotationToolbarShown =>
      'Показване на лентата с инструменти за анотации';

  @override
  String get enterAnnotationMode => 'Влизане в режим на анотации';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Сигурни ли сте, че искате да изчистите всички анотации?';

  @override
  String get llmPromptCopiedToClipboard =>
      'Подкана за LLM копирана в клипборда.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Връзката е отказана, сървърът може да е изключен.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Откриването е успешно, очаква се връзка...';

  @override
  String get noLanConnection => 'Няма LAN връзка';

  @override
  String get takeScreenshot => 'Направи екранна снимка';

  @override
  String get disconnectedFromOpponent => 'Прекъсната връзка с опонента.';

  @override
  String get takeBackRequest => 'Заявка за връщане';

  @override
  String get nothingToShow => 'Няма нищо за показване.';

  @override
  String get stopHosting => 'Спиране на хостването';

  @override
  String get connectionResetByPeer => 'Връзката е нулирана от партньора.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Връзката е загубена поради изтичане на времето за heartbeat. Моля, свържете се отново.';

  @override
  String get startHosting => 'Стартиране на хостване';

  @override
  String get restartRequestRejected => 'Заявката за рестартиране е отхвърлена.';

  @override
  String get notConnectedToLanOpponent => 'Не е свързан с LAN опонент.';

  @override
  String get llmPrompt => 'Подкана за LLM';

  @override
  String get gameRestarted => 'Играта е рестартирана.';

  @override
  String get takeBackRejected => 'Връщането е отхвърлено.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Сигурни ли сте, че искате да се откажете от тази игра?';

  @override
  String get opponentResignedYouWin => 'Опонентът се отказа. Вие печелите!';

  @override
  String get clearAllAnnotations => 'Изчистване на всички анотации';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Свързан, очаква се ход на опонента...';

  @override
  String get networkStatusDisconnected => 'Състояние на мрежата: Прекъснато';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Заявка за връщане е изпратена до опонента.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'Опонентът може да е напуснал играта';

  @override
  String get connectedToHostSuccessfully => 'Свързан успешно с хоста.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Връзката е загубена: изтичане на времето за heartbeat';

  @override
  String get noHostDiscovered => 'Няма открит хост.';

  @override
  String get confirmResignation => 'Потвърдете отказването';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Започнато хостване на игра, очакват се играчи да се присъединят...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Връзката изтече, мрежовата връзка е нестабилна.';

  @override
  String get noLlmPromptAvailable => 'Няма налична подкана за LLM.';

  @override
  String get youResignedGameOver => 'Вие се отказахте. Играта приключи.';

  @override
  String get serverIp => 'IP на сървъра';

  @override
  String get confirmClear => 'Потвърдете изчистването';

  @override
  String get opponentSTurn => 'Ред на опонента.';

  @override
  String get waitingAClientConnection => 'Очаква се връзка с клиент...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Заявката за връщане е отхвърлена или неуспешна.';

  @override
  String get addText => 'Добавяне на текст';

  @override
  String get exitAnnotationMode => 'Излизане от режим на анотации';

  @override
  String get typeYourAnnotation => 'Въведете вашата анотация';

  @override
  String get attemptingToReconnect => 'Опит за повторно свързване...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Заявка за рестартиране е изпратена. Очаква се отговор от опонента...';

  @override
  String get serverIsStopped => 'Сървърът е спрян.';

  @override
  String get restartRequest => 'Заявка за рестартиране';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Не можете да заявите връщане, когато не е ваш ред.';

  @override
  String get takeBackAccepted => 'Връщането е прието.';

  @override
  String get localNetworkSettings => 'Настройки на локалната мрежа';

  @override
  String get reconnectedSuccessfully => 'Успешно повторно свързване!';

  @override
  String get failedToSaveImageToGallery =>
      'Неуспешно запазване на изображението в галерията.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Опонентът поиска рестартиране на играта. Приемате ли?';

  @override
  String get yourTurn => 'Ваш ред.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Не може да се свърже отново, моля, рестартирайте играта.';

  @override
  String get host => 'Хост';

  @override
  String get join => 'Присъединяване';

  @override
  String get port => 'Порт';

  @override
  String get invalidIpAddress => 'Невалиден IP адрес.';

  @override
  String get invalidPort => 'Невалиден порт.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Свързване: Опит $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Неуспешно свързване: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Неуспешно стартиране на хостване: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Открит хост: $ip:$port';
  }

  @override
  String get stop => 'Спри';

  @override
  String get discover => 'Открий';

  @override
  String get connect => 'Свържи се';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Клиентът е свързан: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Откриване: $seconds с';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Повторно свързване ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Свързан';

  @override
  String get delete => 'Изтрий';

  @override
  String get ancientEgypt => 'Древен Египет';

  @override
  String get gothicIce => 'Готически Лед';

  @override
  String get riceField => 'Оризово Поле';

  @override
  String get chinesePorcelain => 'Китайски Порцелан';

  @override
  String get desertDusk => 'Пустинен Здрач';

  @override
  String get precisionCraft => 'Прецизно Изкуство';

  @override
  String get folkEmbroidery => 'Народна Бродерия';

  @override
  String get carpathianHeritage => 'Карпатско Наследство';

  @override
  String get imperialGrandeur => 'Имперско Величие';

  @override
  String get bohemianCrystal => 'Бохемски Кристал';

  @override
  String get savannaSunrise => 'Саванен Изгрев';

  @override
  String get harmonyBalance => 'Хармония и Баланс';

  @override
  String get cinnamonSpice => 'Канелена Подправка';

  @override
  String get anatolianMosaic => 'Анатолийска Мозайка';

  @override
  String get carnivalSpirit => 'Карнавален Дух';

  @override
  String get custom => 'Персонализиран';

  @override
  String get spiceMarket => 'Пазар за подправки';

  @override
  String get swipeToRevealTheDrawer => 'Плъзнете, за да се покаже чекмеджето';

  @override
  String get showGameInfoOnScreenshots =>
      'Показвай информация за играта върху екранни снимки';

  @override
  String get humanMoveTime => 'Времеви лимит за човешки ход';

  @override
  String get noTimeLimitForHumanMoves => 'Няма времеви лимит за човешки ходове';

  @override
  String get timeoutLoseWillBeApplied =>
      'Загуба по време ще бъде приложена за човешкия играч';

  @override
  String get identifyingBoard => 'Идентифициране на игралната дъска...';

  @override
  String get youCanEnterAnyModelName =>
      'Можете да въведете произволно име на модел';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Позицията на дъската е приложена. FEN е копиран в клипборда.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Предложение: Опитайте да направите по-ясна снимка на дъската';

  @override
  String get llmPromptTemplate => 'Шаблон за подканата на LLM';

  @override
  String get noValidBoardDetected => 'Не е открита валидна дъска';

  @override
  String get selectingImageFromAlbum => 'Избиране на изображение от албума...';

  @override
  String get configurePromptTemplate => 'Конфигуриране на шаблон за подканата';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Редактиране на шаблона за подканата за LLM анализ';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Неуспешно генериране на FEN от разпознатата дъска';

  @override
  String get outputInCurrentLanguage => 'Резултат на текущия език';

  @override
  String get commonBaseUrls => 'Често използвани Base URL';

  @override
  String get viewCommonModels => 'Преглед на често използвани модели';

  @override
  String get recognitionParametersUpdated =>
      'Параметрите за разпознаване са актуализирани';

  @override
  String get whiteSMove => 'Ход на белите';

  @override
  String get resetToDefaults => 'Връщане към настройките по подразбиране';

  @override
  String get photoShoot => 'Заснемане';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Неуспешно прилагане на разпознатата позиция на дъската';

  @override
  String get llmPromptContent => 'Съдържание на подканата за LLM';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM не е конфигуриран. Моля, проверете настройките си.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Задайте доставчик, модел, API Key и Base URL';

  @override
  String get llmConfiguration => 'Конфигурация на LLM';

  @override
  String get configureLlmProvider => 'Конфигуриране на доставчик на LLM';

  @override
  String get llmPromptTemplateHeader =>
      'Заглавка на шаблона за подканата на LLM';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Не бяха разпознати фигури на изображението. Моля, опитайте отново.';

  @override
  String get recognizeBoardFromImage => 'Разпознай дъска от изображение';

  @override
  String get viewTips => 'Преглед на съвети';

  @override
  String get applyToBoard => 'Приложи към дъската';

  @override
  String get adjustBoardArea => 'Настрой зона на дъската';

  @override
  String get viewCommonUrls => 'Преглед на често използвани URL';

  @override
  String get colorAnalysisFailed => 'Анализът на цветовете неуспешен!';

  @override
  String get analyzingGameBoardImage =>
      'Анализ на изображението на игралната дъска...';

  @override
  String get selectFromAlbum => 'Избери от албума';

  @override
  String get noBoardPointDetected => 'Не е открита точка на дъската!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Ако е оставено празно, ще се използва шаблонът по подразбиране';

  @override
  String get llmConfig => 'Конфигурация на LLM';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Сигурни ли сте, че искате да върнете шаблоните за подканите към стойностите по подразбиране?';

  @override
  String get llmPromptTemplateFooter =>
      'Колонтитул на шаблона за подканата на LLM';

  @override
  String get loadingResponse => 'Зареждане на отговор...';

  @override
  String get applyThisResultToBoard => 'Приложи този резултат към дъската';

  @override
  String get takingPicture => 'Правене на снимка...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Моля, изберете изображение на игрална дъска за идентифициране';

  @override
  String get identificationResults => 'Резултати от идентификацията';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Анализирайте ходовете и предоставете анализ.';

  @override
  String get getApiKey => 'Вземи API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Целият процес на разпознаване не успя да завърши';

  @override
  String get boardRecognitionResult => 'Резултат от разпознаването на дъската';

  @override
  String get askLlm => 'Попитай LLM';

  @override
  String get boardDetectionFailed => 'Неуспешно откриване на дъската!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Не е открита точка на дъската, не може да бъде идентифицирана фигура!';

  @override
  String get copyFen => 'Копирай FEN';

  @override
  String get commonlyUsedModels => 'Често използвани модели';

  @override
  String get apiKeyOptional => 'API Key (по избор)';

  @override
  String get noImageSelected => 'Няма избрано изображение';

  @override
  String get blackSMove => 'Ход на черните';

  @override
  String get llm => 'Голям езиков модел';

  @override
  String get llmProvider => 'Доставчик';

  @override
  String get baseUrl => 'Базов URL';

  @override
  String get model => 'Модел';

  @override
  String get temperature => 'Температура';

  @override
  String get llmCommandReceivedProcessing =>
      'Командата е получена! AI обработва...';

  @override
  String get llmDeepThinkingWait => 'Тече дълбоко мислене, моля изчакайте...';

  @override
  String get llmPresentingSoon => 'Представяне скоро...';

  @override
  String get recognitionParameters => 'Параметри за разпознаване';

  @override
  String get adjustParamsDesc =>
      'Коригирайте параметрите, за да подобрите точността на разпознаване';

  @override
  String get saveParameters => 'Запази параметрите';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Не може да се стартира разпознаване на изображението: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Разпознаването на изображението неуспешно: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Приложена позиция с $whiteCount бели и $blackCount черни пулчета';
  }

  @override
  String get fenCopiedToClipboard => '(FEN е копирано в клипборда)';

  @override
  String recognitionFailed(String error) {
    return 'Разпознаването неуспешно: $error';
  }

  @override
  String get myRating => 'Моят рейтинг';

  @override
  String get gamesPlayed => 'Изиграни игри';

  @override
  String get wins => 'Победи';

  @override
  String get losses => 'Загуби';

  @override
  String get draws => 'Равенства';

  @override
  String get lastUpdated => 'Последно актуализирано';

  @override
  String get format => 'Формат:';

  @override
  String get resetStatistics => 'Нулиране на статистиката';

  @override
  String get drawRate => 'Процент на равенства';

  @override
  String get lossRate => 'Процент на загуби';

  @override
  String get aiStatistics => 'Статистика на ИИ';

  @override
  String get enableStatistics => 'Активиране на статистиката';

  @override
  String get enableStatistics_Detail =>
      'Когато е активирано, резултатите от игрите ще се записват в статистиката. Игрите, включващи връщане на ходове, обаче няма да се записват. Когато е деактивирано, събирането на статистика е на пауза.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Това ще нулира цялата статистика на играта. Това действие не може да бъде отменено.';

  @override
  String get boardInnerRingSize => 'Размер на вътрешния пръстен на дъската';

  @override
  String get boardShadowEnabled => 'Сянка на дъската';

  @override
  String get trapAwareness => 'Разпознаване на капани';

  @override
  String get trapAwarenessDescription =>
      'Подчертавай ходовете-капан с дебели кръгове и стрелки по време на анализа.';

  @override
  String trapExists(String trapMoves) {
    return 'Има капан. Ходове-капан: $trapMoves';
  }

  @override
  String get custodianCapture => 'Улавяне на фланки';

  @override
  String get custodianCaptureDescription =>
      'Приложете едно от парчетата на опонента си между две от вашите в права линия, за да го заснемете.';

  @override
  String get custodianCaptureEnable => 'Позволяват улавяне на фланки';

  @override
  String get interventionCapture => 'Улавяне на интервенция';

  @override
  String get interventionCaptureDescription =>
      'Преместете се в празната точка между две от парчетата на опонента ви, за да ги уловите и двете.';

  @override
  String get interventionCaptureEnable => 'Позволяват заснемане на интервенция';

  @override
  String get leapCapture => 'Заснемане на скок';

  @override
  String get leapCaptureDescription =>
      'Заснемайте, като прескочите над парчето на опонента в празната точка отвъд.';

  @override
  String get leapCaptureEnable => 'Позволете заснемане на скок';

  @override
  String get captureApplicableLines => 'Приложими линии';

  @override
  String get captureSquareEdges => 'По краищата на площада';

  @override
  String get captureCrossLines => 'По ортогонални линии, пресичащи площада';

  @override
  String get captureDiagonalLines => 'По диагонални линии, пресичащи квадрата';

  @override
  String get captureExecutionPhases => 'Фази на изпълнение';

  @override
  String get capturePiecesCondition =>
      'Наличност по време на фазата на преместване въз основа на останалите парчета';

  @override
  String get capturePiecesConditionUnlimited => 'Без ограничение';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Предлага се, когато имате три или по -малко парчета';
}
