// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Belarusian (`be`).
class SBe extends S {
  SBe([String locale = 'be']) : super(locale);

  @override
  String get appName => 'Млын';

  @override
  String get welcome => 'Сардэчна запрашаем';

  @override
  String get yes => 'так';

  @override
  String get no => 'няма';

  @override
  String get game => 'Гульня';

  @override
  String get humanVsAi => 'Чалавек супраць AI';

  @override
  String get humanVsHuman => 'Чалавек супраць Чалавечы';

  @override
  String get aiVsAi => 'ШІ супраць AI';

  @override
  String get humanVsCloud => 'Чалавек супраць Воблака';

  @override
  String get humanVsLAN => 'Чалавек супраць лакальная сетка';

  @override
  String get testViaLAN => 'Тэст праз лакальную сетку';

  @override
  String get move => 'Рухайцеся';

  @override
  String get showMoveList => 'Перамясціць спіс';

  @override
  String get moveList => 'Перамясціць спіс';

  @override
  String get noGameRecord => 'Няма запісу';

  @override
  String get ok => 'добра';

  @override
  String get confirm => 'Пацвердзіць';

  @override
  String get cancel => 'Адмяніць';

  @override
  String get tipSelectWrong => 'Выберыце няправільны кавалак.';

  @override
  String get tipPlace => 'Размесціце свае фігуры.';

  @override
  String get tipBanPlace => 'Вы не можаце размясціць яго тут.';

  @override
  String get tipPlaced => 'Вы размясцілі.';

  @override
  String get tipRemove => 'Выдаліць кавалак.';

  @override
  String get tipBanRemove => 'Вы не можаце выдаліць яго.';

  @override
  String get tipRemoved => 'Вы выдалілі.';

  @override
  String get tipMove => 'Перамясціць кавалак.';

  @override
  String get tipCannotPlace => 'Вы не можаце размясціць тут сваю частку.';

  @override
  String get tipCannotMove => 'Вы не можаце перанесці сваю фігуру сюды.';

  @override
  String get tipMill => 'Млын! Вазьміце фігуру суперніка.';

  @override
  String get tipContinueMill => 'Працягвайце браць фігуру суперніка.';

  @override
  String get tipSelectOpponentsPiece => 'Выберыце адну з фігур суперніка.';

  @override
  String get tipCannotRemovePieceFromMill => 'З млына кавалка не здымеш.';

  @override
  String get tipCanMoveOnePoint => 'Фігура можа рухацца на 1 ачко.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Вы не можаце рухаць фігурамі суперніка.';

  @override
  String get tipSelectPieceToMove => 'Выберыце сваю частку для перамяшчэння.';

  @override
  String get tipHaveThreePiecesLeft => 'У вас засталося тры штукі.';

  @override
  String get tipCanMoveToAnyPoint =>
      'Вы можаце рухацца ў любую кропку, якая вам падабаецца.';

  @override
  String tipToMove(Object player) {
    return '$player рухацца.';
  }

  @override
  String get whiteWin => 'Гулец 1 выйграў!';

  @override
  String get blackWin => 'Гулец 2 выйграў!';

  @override
  String get won => 'Выйграў';

  @override
  String get lost => 'Страчаны';

  @override
  String get thinking => 'Думаючы…';

  @override
  String get newGame => 'Новая гульня';

  @override
  String get importGame => 'Імпарт гульні';

  @override
  String get exportGame => 'Экспарт гульні';

  @override
  String get gameImported => 'Імпартная гульня.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Немагчыма імпартаваць $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'Хады і правілы не супадаюць.';

  @override
  String get pleaseWait => 'Калі ласка пачакай.';

  @override
  String get restartGame => 'Перазапусціць бягучую гульню?';

  @override
  String get restart => 'Перазапуск';

  @override
  String get gameStarted => 'Гульня пачалася, месца, калі ласка.';

  @override
  String get analyzing => 'Ідзе аналіз…';

  @override
  String error(Object message) {
    return 'Памылка: $message';
  }

  @override
  String get winRate => 'Стаўка перамог';

  @override
  String get score => 'Ацэнка:';

  @override
  String get white => 'Гулец 1';

  @override
  String get black => 'Гулец 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player колькасць штук менш за тры.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player падаў у адстаўку.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player не мае дарогі.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Дошка запоўненая, і $player не мае куды ісці.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Час скончыўся, $player страчана.';
  }

  @override
  String get drawReasonRule50 =>
      'У фазе руху ні адна фігура не была выдалена за апошнюю пэўную колькасць хадоў.';

  @override
  String get drawReasonBoardIsFull => 'Гэта нічыя, таму што дошка поўная.';

  @override
  String get drawReasonThreefoldRepetition =>
      'Гэта нічыя з-за трохразовага паўтарэння.';

  @override
  String get gameOverUnknownReason => 'Гульня скончана! Невядомая прычына.';

  @override
  String get gameOver => 'Гульня скончана';

  @override
  String get youWin => 'Вы выйгралі! Віншую!';

  @override
  String challengeHarderLevel(int level) {
    return 'Выклік больш складанага ўзроўню? Новы ўзровень будзе ўзроўнем $level!';
  }

  @override
  String get youLose => 'Ты прайграў!';

  @override
  String get analyze => 'Прааналізаваць';

  @override
  String get about => 'Аб';

  @override
  String version(Object versionNumber) {
    return 'Версія: $versionNumber';
  }

  @override
  String get thanks => 'дзякуй';

  @override
  String get settings => 'Налады';

  @override
  String get options => 'Параметры';

  @override
  String get generalSettings => 'Агульныя налады';

  @override
  String get skillLevel => 'Узровень складанасці';

  @override
  String get moveTime => 'Час разважанняў ІІ';

  @override
  String get difficulty => 'Цяжкасць';

  @override
  String get playSounds => 'Гукавыя эфекты';

  @override
  String get playSoundsInTheGame => 'Прайграванне гукаў у гульні';

  @override
  String get keepMuteWhenTakingBack => 'Пры вяртанні трымайце маўчанне';

  @override
  String get tone => 'Тон';

  @override
  String get whoMovesFirst => 'Першы ход';

  @override
  String get human => 'Чалавечы';

  @override
  String get ai => 'AI';

  @override
  String get alternate => 'Чаргаваць';

  @override
  String get isAutoRestart =>
      'Аўтаматычны перазапуск гульні пасля заканчэння гульні';

  @override
  String get isAutoChangeFirstMove => 'Аўтаматычнае змяненне першага ходу';

  @override
  String get shufflingEnabled => 'Рухайцеся выпадковым чынам';

  @override
  String get misc => 'Рознае';

  @override
  String get rules => 'правілы';

  @override
  String get piecesCount => 'Колькасць фігур у кожнага гульца';

  @override
  String get piecesCount_Detail => 'Колькі фігур у кожнага гульца?';

  @override
  String get flyPieceCount => 'Нумар лятаючай фігуры';

  @override
  String get flyPieceCount_Detail =>
      'Калі палёт уключаны, калі гулец зніжае колькасць фігур да пэўнай колькасці, яе фігуры могуць свабодна перамяшчацца ў любую незанятую кропку, а не абмежаваныя суседнімі кропкамі, як у астатняй частцы гульні.';

  @override
  String get piecesAtLeastCount => 'Прынамсі штук';

  @override
  String get hasDiagonalLines => 'Дыяганальныя лініі';

  @override
  String get hasDiagonalLines_Detail =>
      'Дадайце да дошкі чатыры дыяганальныя лініі.';

  @override
  String get isDefenderMoveFirst => 'Першым ходзіць другі гулец';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Гулец, які ідзе другім у фазе размяшчэння, ідзе першым у фазе перамяшчэння.';

  @override
  String get mayRemoveMultiple => 'Мульты-выдаліць';

  @override
  String get mayRemoveMultiple_Detail =>
      'Калі гулец закрывае больш за адзін млын адначасова, ён выдаляе колькасць млыноў, якія ён зачыніў.';

  @override
  String get mayRemoveFromMillsAlways => 'Разбурыць млыны';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Па змаўчанні гульцы павінны спачатку выдаліць любыя іншыя часткі, перш чым выдаліць частку са сфармаванага млына. Уключыце гэты параметр, каб адключыць абмежаванне.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Другі гулец прайграе, калі дошка поўная';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Калі дошка запоўнена ў канцы фазы размяшчэння, бок, які ставіць першым, прайграе гульню. У адваротным выпадку гульня нічыя.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Страта, калі няма законных крокаў';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Гулец прайграе, калі яго супернік заблакуе іх так, што іх немагчыма перасунуць. Змяніце бок, каб рухацца, калі гэты параметр адключаны.';

  @override
  String get mayFly => 'Палёт';

  @override
  String get mayFly_Detail =>
      'Калі ў гульца засталіся толькі тры ці чатыры (канфігуруемыя) фігуры, ён можа перамясціць фігуру ў любую вольную кропку.';

  @override
  String get nMoveRule => 'Правіла N-ходу';

  @override
  String get nMoveRule_Detail =>
      'Гульня лічыцца нічыёй, калі не было выдалення за пэўную колькасць хадоў.';

  @override
  String get rollback => 'Адкат';

  @override
  String get pleaseSelect => 'Выберыце, калі ласка';

  @override
  String get copy => 'Копія';

  @override
  String get moveHistoryCopied =>
      'Гісторыя перамяшчэння скапіравана ў буфер абмену.';

  @override
  String get help => 'Даведка';

  @override
  String get feedback => 'Зваротная сувязь';

  @override
  String get exit => 'Выхад';

  @override
  String get ruleSettings => 'Налады правілаў';

  @override
  String get color => 'Колер';

  @override
  String get boardColor => 'Колер дошкі';

  @override
  String get pieceColor => 'Колер кавалка';

  @override
  String get backgroundColor => 'Колер фону';

  @override
  String get lineColor => 'Колер лініі дошкі';

  @override
  String get whitePieceColor => 'Гулец 1 колер фігуры';

  @override
  String get blackPieceColor => 'Гулец 2 штукі колер';

  @override
  String get messageColor => 'Колер паведамлення';

  @override
  String get isPieceCountInHandShown =>
      'Паказаць колькасць неразмешчаных фігур';

  @override
  String get isNotationsShown => 'Пакажыце абазначэнні на дошцы';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Паказаць панэль інструментаў навігацыі па гісторыі';

  @override
  String get display => 'Дысплей';

  @override
  String get boardBorderLineWidth => 'Шырыня мяжы борта';

  @override
  String get boardInnerLineWidth => 'Шырыня ўнутранай лініі дошкі';

  @override
  String get pieceWidth => 'Шырыня кавалка';

  @override
  String get fontSize => 'Памер шрыфта';

  @override
  String get standardNotation => 'Абазначэнне ЗМЗ';

  @override
  String get restore => 'Аднавіць';

  @override
  String get restoreDefaultSettings => 'Аднавіць налады па змаўчанні';

  @override
  String pick(Object element) {
    return 'Выберыце $element';
  }

  @override
  String get info => 'Інф.';

  @override
  String get hint => 'Падказка';

  @override
  String get player => 'гулец';

  @override
  String get player1 => 'Гулец 1';

  @override
  String get player2 => 'Гулец 2';

  @override
  String get howToPlay => 'Як гуляць';

  @override
  String get toPlacePiece =>
      'Націсніце на любую даступную кропку, каб размясціць фігуру.';

  @override
  String get toSelectPiece => 'Націсніце на частку, каб перамясціць яе.';

  @override
  String get toMovePiece =>
      'Націсніце на кропку, злучаную з часткай, каб перамясціць яе.';

  @override
  String get toRemovePiece =>
      'Націсніце на адну фігуру суперніка, каб выдаліць.';

  @override
  String get needToCreateMillFirst =>
      'Вам трэба спачатку стварыць млын, перш чым вы зможаце выдаліць кавалак.';

  @override
  String get needToPlayWithOwnPieces => 'Вам трэба гуляць сваімі фігурамі.';

  @override
  String get statistics => 'Статыстыка';

  @override
  String get totalGames => 'Усяго гульняў';

  @override
  String get results => 'Вынікі';

  @override
  String get left => 'злева';

  @override
  String get privacyPolicy => 'Палітыка прыватнасці';

  @override
  String get privacyPolicy_Detail_1 =>
      'Калі ласка, прачытайце ўважліва і пераканайцеся, што вы цалкам разумееце і згодны з гэтым ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Калі вы не згодныя з гэтай Палітыкай, не выкарыстоўвайце гэта дадатак. Выкарыстанне праграмы азначае, што вы прымаеце гэтыя ўмовы.';

  @override
  String get and => ' і ';

  @override
  String get accept => 'Прыняць';

  @override
  String get takeBack => 'Забраць';

  @override
  String get takingBack => 'Вяртанне…';

  @override
  String get waiting => 'Чаканне…';

  @override
  String get stepForward => 'Крок наперад';

  @override
  String get takeBackAll => 'Вярнуць усё';

  @override
  String get stepForwardAll => 'Крочаць наперад усе';

  @override
  String get moveNow => 'Рухайцеся зараз';

  @override
  String get done => 'Гатова.';

  @override
  String get crackMill => 'Крэк-млын';

  @override
  String get crackMill_Detail =>
      'Калі ў гульца ёсць толькі фігуры ў млынах, фігуры ў млынах не будуць заблакіраваны для выдалення.';

  @override
  String get animationDuration => 'Працягласць анімацыі';

  @override
  String get none => 'Няма';

  @override
  String get theme => 'Тэма';

  @override
  String get helpContent =>
      'Гульня накіравана на тое, каб у суперніка было менш за тры фігуры або не было дазволеных хадоў.\n\nГульня аўтаматычна заканчваецца ўнічыю, калі пазіцыя ўзнікае ў трэці раз або не здымаецца за апошнія 100 (канфігуруемых) хадоў.\n\nГульня праходзіць у тры этапы:\n\n1. Размяшчэнне фігур на свабодных кропках\n2. Перасоўванне частак у суседнія кропкі\n3. (неабавязковая фаза) Перамяшчэнне фігур у любую вакантную кропку пры скарачэнні гульца да трох фігур\n\nРазмяшчэнне\n\nГульня пачынаецца з пустой дошкі, якая складаецца з сеткі з дваццаццю чатырма кропкамі. Гульцы па чарзе кладуць свае фігуры на пустыя кропкі, пакуль кожны гулец не раскладзе ўсе фігуры на дошцы. Калі гулец можа паставіць тры свае фігуры запар, ён мае «млын» і можа выдаліць адну з фігур суперніка з дошкі.\n\nУ некаторых правілах гульцы павінны спачатку выдаліць любыя іншыя часткі, перш чым выдаліць частку са сфармаванага млына.\n\nУ некаторых правілах вы не можаце зноў размясціць фігуры ў пунктах выдаленых фігур на этапе размяшчэння.\n\nПасля выкарыстання ўсіх фігур гульцы рухаюцца па чарзе.\n\nПераезд\n\nДля перамяшчэння гулец перамяшчае адну са сваіх фігур уздоўж лініі дошкі ў вольнае суседняе месца. Калі ён не можа гэтага зрабіць, ён прайграў гульню. Гулец, які выраўноўвае тры свае фігуры на лініі дошкі, мае млын і можа выдаліць адну з фігур суперніка, як у фазе размяшчэння. Любы гулец памяншаецца да дзвюх частак, не мае магчымасці фармаваць новыя млыны і, такім чынам, прайграе гульню. Гулец таксама можа прайграць, калі больш за тры фігуры, калі яго праціўнік блакуе іх рух.\n\nПалёт\n\nУ некаторых варыянтах правілаў, калі ў гульца засталося толькі тры фігуры, яго фігуры могуць лётаць, скакаць або скакаць на любыя свабодныя кропкі, а не толькі на суседнія.\n';

  @override
  String get versionInfo => 'Інфармацыя аб версіі';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'Ліцэнзія';

  @override
  String get sourceCode => 'Зыходны код';

  @override
  String get appVersion => 'Версія праграмы';

  @override
  String get general => 'Генерал';

  @override
  String get advanced => 'Пашыраны';

  @override
  String get placing => 'Размяшчэнне';

  @override
  String get moving => 'Пераезд';

  @override
  String get removing => 'Выдаленне';

  @override
  String get gameOverCondition => 'Умовы завяршэння гульні';

  @override
  String get aisPlayStyle => 'Стыль гульні AI';

  @override
  String get passive => 'Пасіўны';

  @override
  String get timeout => 'Тайм-аўт';

  @override
  String get appearance => 'Знешні выгляд';

  @override
  String get drawOnHumanExperience => 'Абапірайцеся на чалавечы вопыт';

  @override
  String get considerMobility => 'Улічвайце рухомасць частак';

  @override
  String get pieceCount => 'Колькасць штук:';

  @override
  String inHand(Object player, int count) {
    return '$player у руцэ: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player на борце: $count';
  }

  @override
  String get boardTop => 'Дошка са зрушэннем ад верху';

  @override
  String get notAIsTurn => 'Не дайшла чарга ІІ.';

  @override
  String get aiIsNotThinking => 'ШІ не думае.';

  @override
  String get atEnd => 'Вы знаходзіцеся ў канцы спісу пераездаў.';

  @override
  String get tapBackAgainToLeave => 'Націсніце назад яшчэ раз, каб выйсці.';

  @override
  String get more => 'больш';

  @override
  String get experimental => 'Гэта эксперыментальная функцыя.';

  @override
  String get experiments => 'Эксперыменты';

  @override
  String get ossLicenses => 'Ліцэнзіі з адкрытым зыходным кодам';

  @override
  String get language => 'Мова';

  @override
  String get defaultLanguage => 'Мова па змаўчанні';

  @override
  String get mayMoveInPlacingPhase =>
      'Фігуры могуць рухацца ў фазе размяшчэння';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Няма асобных фаз размяшчэння і перамяшчэння, г.зн. гульцы могуць вырашаць пры кожным ходзе, ці жадаюць яны размясціць фігуру на дошцы або перасунуць адну са сваіх фігур (пры ўмове, што ў іх ёсць астатнія фігуры).';

  @override
  String get drawerColor => 'Колер меню';

  @override
  String get drawerTextColor => 'Колер тэксту меню';

  @override
  String get drawerHighlightItemColor => 'Колер вылучэння пунктаў меню';

  @override
  String get mainToolbarBackgroundColor =>
      'Колер фону галоўнай панэлі інструментаў';

  @override
  String get mainToolbarIconColor =>
      'Колер значка галоўнай панэлі інструментаў';

  @override
  String get navigationToolbarBackgroundColor => 'Колер фону панэлі навігацыі';

  @override
  String get navigationToolbarIconColor => 'Колер значка панэлі навігацыі';

  @override
  String get autoHideToolbar => 'Аўтаматычна хаваць панэль інструментаў';

  @override
  String get toolbarLocationOnScreen =>
      'Размяшчэнне панэлі інструментаў на экране';

  @override
  String get top => 'Топ';

  @override
  String get bottom => 'Знізу';

  @override
  String get center => 'Цэнтр';

  @override
  String get solidColor => 'Суцэльны колер';

  @override
  String get picture => 'Малюнак';

  @override
  String get chooseYourPicture => 'Выберыце сваю карцінку';

  @override
  String get light => 'Святло';

  @override
  String get dark => 'Цёмны';

  @override
  String get themes => 'Тэмы';

  @override
  String get currentTheme => 'Актуальная тэма';

  @override
  String get saveTheme => 'Захаваць тэму';

  @override
  String get showAnalysisGraph => 'Паказаць графік аналізу';

  @override
  String get analysis => 'Аналіз';

  @override
  String get saveGame => 'Захаваць гульню';

  @override
  String get loadGame => 'Загрузіць гульню';

  @override
  String get setupPosition => 'Становішча ўстаноўкі';

  @override
  String get showLegalMoves => 'Пакажыце законныя хады';

  @override
  String get showLastMove => 'Паказаць апошні ход';

  @override
  String get showArrows => 'Паказаць стрэлкі';

  @override
  String get pieces => 'Кавалачкі';

  @override
  String get showAnalysis => 'Паказаць аналіз';

  @override
  String get threads => 'Ніткі';

  @override
  String get getInvolved => 'Прыняць удзел';

  @override
  String get helpImproveTranslate => 'Дапамажыце палепшыць пераклад';

  @override
  String get tutorial => 'Падручнік';

  @override
  String get classicMill => 'Класічны млын';

  @override
  String get mixedMill => 'Змешаны млын';

  @override
  String get ceylonMill => 'Цэйлонскі млын';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Млын можа ламацца і перарабляцца неаднаразова';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Калі гулец разбівае млын, каб неадкладна стварыць новы млын, такі гулец можа перамясціць такі кавалак назад да першапачатковага злучэння сваім наступным ходам, калі ён стварае новы млын.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Гульня лічыцца нічыёй, калі ў гульца ёсць тры фігуры і пасля дзесяці хадоў ні адзін з гульцоў не здымае фігуры суперніка';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Калі ў гульца застаецца тры фігуры і ні адзін з гульцоў не можа прыбраць фігуру суперніка на працягу дзесяці хадоў, гульня лічыцца нічыёй.';

  @override
  String get close => 'Блізка';

  @override
  String get whitePiece => 'Белы кавалак';

  @override
  String get blackPiece => 'Чорны кавалак';

  @override
  String get emptyPoint => 'Пустая кропка';

  @override
  String get noPoint => 'Няма сэнсу';

  @override
  String get placingPhase => 'Фаза размяшчэння';

  @override
  String get movingPhase => 'Рухомая фаза';

  @override
  String get flyingPhase => 'Фаза палёту';

  @override
  String sideToMove(Object player) {
    return 'Бок для перамяшчэння: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Апошні ход: $move';
  }

  @override
  String get selected => 'Выбранае';

  @override
  String get accessibility => 'Даступнасць';

  @override
  String get screenReaderSupport => 'Падтрымка праграмы чытання з экрана';

  @override
  String get isDraw => 'Гэта розыгрыш!';

  @override
  String get draw => 'маляваць';

  @override
  String get pieceHighlightColor => 'Колер вылучэння кавалка';

  @override
  String get algorithm => 'Алгарытм';

  @override
  String get endgameNMoveRule => 'Правіла N-ходу ў эндшпілі';

  @override
  String get endgameNMoveRule_Detail =>
      'Гульня залічваецца ўнічыю, калі ў любога з гульцоў ёсць толькі тры фігуры і ні адзін з гульцоў не выдаляе фігуру за пэўныя хады.';

  @override
  String get drawReasonEndgameRule50 =>
      'Любы гулец мае толькі тры фігуры, і ні адзін з гульцоў не выдаляе фігуру ў межах пэўных хадоў.';

  @override
  String get threefoldRepetitionRule => 'Правіла трохразовага паўтарэння';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Гульня лічыцца нічыёй, калі пазіцыя сустракаецца ў трэці раз.';

  @override
  String get continueToMakeMove => 'Млын! Працягвайце рабіць ход.';

  @override
  String get pointStyle => 'Стыль кропкі';

  @override
  String get pointWidth => 'Шырыня кропкі';

  @override
  String get solid => 'Цвёрды';

  @override
  String get hollow => 'Полая';

  @override
  String get languageName => 'Беларуская';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Ходаў',
      few: '$count Ходы',
      one: '$count Ход',
      zero: 'Ход',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Памылка загрузкі.';

  @override
  String get filename => 'Імя файла';

  @override
  String get browse => 'Прагляд…';

  @override
  String get gameFiles => 'Файлы гульні';

  @override
  String get gameSavedTo => 'Гульня захавана ў';

  @override
  String get empty => 'Пусты';

  @override
  String get noMove => 'Без руху.';

  @override
  String get restoredPosition => 'Адноўлены зыходнае становішча.';

  @override
  String get clean => 'Чыстая';

  @override
  String get cleanedUp => 'Пачысцілі.';

  @override
  String get remove => 'Выдаліць';

  @override
  String get noPiecesCanBeRemoved => 'Немагчыма выдаліць кавалкі.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count piece',
      one: '$count piece',
      zero: 'Piece',
    );
    return '$_temp0 трэба выдаліць.';
  }

  @override
  String placedCount(int count) {
    return 'Размеш. ($count)';
  }

  @override
  String get placedPieceCount =>
      'Размешчаныя фігуры падлічваюцца на этапе размяшчэння.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'Бягучы гулец размясціў $count фігур.';
  }

  @override
  String get notPlacingPhase => 'Не размяшчаючы фазу, нельга яе змяніць.';

  @override
  String get paste => 'Уставіць';

  @override
  String get pasteDone => 'Паста гатовая.';

  @override
  String get cannotPaste => 'Немагчыма ўставіць.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Паказаць неразмешчаныя і выдаленыя часткі';

  @override
  String get fullScreen => 'Поуны экран';

  @override
  String get reopenToTakeEffect =>
      'Выйдзіце і зноў адкрыйце праграму, каб налады ўступілі ў сілу.';

  @override
  String get forest => 'Лес';

  @override
  String get desktopImage => 'Выява працоўнага стала';

  @override
  String get invalidPosition => 'Няправільная пазіцыя.';

  @override
  String get shareGIF => 'Абагуліць GIF';

  @override
  String get pixelRatio => 'Суадносіны пікселяў';

  @override
  String get duration => 'Працягласць';

  @override
  String get gameScreenRecorder => 'Дыктафон экрана гульні';

  @override
  String get previous => 'Папярэдні';

  @override
  String get next => 'Далей';

  @override
  String get skip => 'Прапусціць';

  @override
  String get gotIt => 'Зразумела';

  @override
  String get youCanModifyRules =>
      'Вы можаце змяніць правілы гульні ў наладах правілаў.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Вы можаце выкарыстоўваць кола мышы, каб змяніць значэнне ў выбары.';

  @override
  String get noTimeLimitForThinking =>
      'Час AI Thinking, усталяваны на 0, азначае, што час для разважанняў не абмежаваны.';

  @override
  String get whatIsMtdf =>
      'MTD(f) - гэта мадыфікаваная форма альфа-бэта-алгарытму пошуку, якая накіравана на павышэнне эфектыўнасці шляхам паўторнага выкарыстання прамежкавых вынікаў пошуку і выкарыстання добрай першапачатковай здагадкі для звужэння прасторы пошуку.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Майце на ўвазе, што рэгуляванне часу мыслення штучным інтэлектам можа быць не зусім дакладным. Фактычны час абдумвання можа быць карацейшым, калі ўзровень складанасці ўсталяваны на больш нізкае значэнне, і можа быць большым, калі штучны інтэлектуальны інтэлект знаходзіцца ў сярэдзіне разважанняў, калі час скончыцца.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Калі вы ўсталюеце высокі ўзровень складанасці, але не павялічваеце час на разважанні штучнага інтэлекту, фактычны ўзровень складанасці можа быць абмежаваны меншым значэннем з-за абмежавання часу на разважанні. Фактычнае значэнне можа адрознівацца ў залежнасці ад прадукцыйнасці машыны.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) - гэта алгарытм пошуку для пошуку лепшага ходу ў дадзенай пазіцыі. Гэта ўдасканаленне альфа-бэта-алгарытму і выкарыстоўвае нулявы або нулявы пошук у вокнах, каб пацвердзіць, што ход горшы ці не горшы, чым ужо бяспечны бал з асноўнага варыянту. PVS факусуюць на найбольш перспектыўных хадах і пазбягаюць непатрэбных пошукаў неаптымальных галінак, што спрыяе павышэнню эфектыўнасці пошуку.';

  @override
  String get whatIsAlphaBeta =>
      'Алгарытм альфа-бэта - гэта алгарытм пошуку для пошуку лепшага ходу. Ён выкарыстоўвае прынцып мінімаксу і два значэнні, альфа і бэта, каб скараціць дрэва пошуку і павялічыць эфектыўнасць. Альфа ўяўляе сабой мінімальны бал, які камп\'ютар упэўнены, што можа атрымаць, у той час як бэта ўяўляе максімальны бал, які можа атрымаць яго праціўнік. Алгарытм дапамагае кампутару прымаць разумныя і эфектыўныя рашэнні ў гульні.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Як сведчыць чалавечы вопыт, калі вы спрабуеце выйграць, вы прайграеце. Замест гэтага пастаўце сваёй мэтай нічыю і пазбягайце пройгрышу. Назірайце за супернікам і асцярожна завабіце яго ў становішча, дзе ён можа зрабіць памылкі. Калі яны дэманструюць слабасць, скарыстайцеся магчымасцю і асцярожна дамагайцеся перамогі. Такім чынам, вы можаце выйграць гульню.';

  @override
  String get firstMoveDetail =>
      'У гэтай гульні другому гульцу лягчэй выйграць у параўнанні з першым.';

  @override
  String get passiveDetail =>
      'Уключэнне пасіўнай опцыі прымусіць ІІ расслабіцца, калі ён мае перавагу ў пазіцыі, а не агрэсіўна спрабаваць выйграць як мага хутчэй.';

  @override
  String get moveRandomlyDetail =>
      'Уключэнне гэтай опцыі павялічвае выпадковасць і задавальненне ад гульні, а адключэнне можа дапамагчы вывучыць спосабы перамагчы ІІ.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Калі штучны інтэлект улічвае рухомасць сваіх фігур, ён будзе імкнуцца не толькі захапіць фігуры суперніка як мага хутчэй, але таксама разгледзець пытанне аб блакаванні рухаў суперніка і не даць яму зрабіць тое ж самае.';

  @override
  String get whenBoardIsFull => 'Калі дошка поўная';

  @override
  String get whenBoardIsFull_Detail =>
      'У канцы фазы размяшчэння, перад пачаткам фазы перамяшчэння, дзеянне адбываецца, калі дошка поўная фігур.';

  @override
  String get sideToMoveRemovePiece =>
      'Гулец, які ідзе першым у фазе руху, здымае адну з фігур суперніка.';

  @override
  String get agreeToDraw => 'Абодва бакі згодныя на нічыю.';

  @override
  String get takeOpponentsPiece => 'Вазьміце адну з фігур суперніка.';

  @override
  String get firstPlayerLose => 'Першы гулец прайграе гульню.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Першы і другі гульцы здымаюць адну з фігур суперніка.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Другі і першы гульцы здымаюць адну з фігур суперніка.';

  @override
  String get enteredFlyingPhase =>
      'Цяпер у фазе палёту фігуры суперніка могуць скакаць у любую пустую кропку на дошцы. Вы можаце адключыць правіла палётаў у «Наладах правілаў».';

  @override
  String get whenStalemate => 'Калі тупік';

  @override
  String get whenStalemate_Detail =>
      'Якое дзеянне адбываецца, калі нельга перасунуць ні адну фігуру?';

  @override
  String get endWithStalemateLoss =>
      'Скончыцца паразай у тупік для заблакаванага боку.';

  @override
  String get changeSideToMove => 'Зменіце бок, каб рухацца.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Прыбярыце адну з фігур суперніка і зрабіце наступны ход.';

  @override
  String get endWithStalemateDraw => 'Скончыцца нічыёй у тупік.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Выдаліце адну з фігур суперніка і зменіце бок, каб рухацца.';

  @override
  String get aiResponseDelayTime => 'Час затрымкі адказу AI';

  @override
  String get aiIsDelaying =>
      'ШІ зараз знаходзіцца ў фазе адкладзенага рэагавання. Калі ласка, пачакайце некаторы час, перш чым працягваць.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Вы не можаце выдаліць несуседнюю частку.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'У тупіку фігуры праціўніка, якія знаходзяцца побач з вашымі, могуць быць выдалены, незалежна ад формы млына.';

  @override
  String get whatIsMcts =>
      'MCTS - гэта зручны для пачаткоўцаў алгарытм, які прымае рашэнні шляхам вывучэння і ацэнкі розных хадоў з дапамогай мадэлявання.';

  @override
  String get goldenJade => 'Залаты нефрыт';

  @override
  String get forestWood => 'Лясны лес';

  @override
  String get darkMystery => 'Цёмная таямніца';

  @override
  String get midnightBlue => 'Поўнач блакітная';

  @override
  String get greenForest => 'Зялёны лес';

  @override
  String get greenMeadow => 'Зялёны Луг';

  @override
  String get stonyPath => 'Камяністы шлях';

  @override
  String get pastelPink => 'Пастэльна-ружовы';

  @override
  String get turquoiseSea => 'Бірузовае мора';

  @override
  String get violetDream => 'Фіялетавы сон';

  @override
  String get mintChocolate => 'Мятный шакалад';

  @override
  String get skyBlue => 'Нябесна-блакітны';

  @override
  String get playfulGarden => 'Гуллівы сад';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Алгарытм рэтраграднага аналізу выкарыстоўвае шматзначны рэтраградны аналіз для стварэння базы дадзеных эндшпіля з розных стартавых пазіцый, а затым прымяняе гэтую базу дадзеных для аптымізацыі гульнявога працэсу. Такі падыход адносіцца да катэгорыі звыштрывалых рашэнняў.';

  @override
  String get viewAlgorithmGuide =>
      'Вы жадаеце прагледзець кіраўніцтва карыстальніка для гэтага алгарытму?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Паказаць індыкатар пазіцыйнай перавагі';

  @override
  String get usePerfectDatabase => 'Выкарыстоўвайце ідэальную базу дадзеных';

  @override
  String get perfectDatabaseDescription =>
      'Уключыце гэту опцыю, каб выкарыстоўваць бездакорную базу дадзеных гульняў, згенераваную з дапамогай перадавых алгарытмаў. Гэтая функцыя аб\'ядноўвае стратэгіі адкрыцця і эндшпіля, каб прапаноўваць аптымальныя хады. Гэта пераважны выбар для гульцоў, якія шукаюць найвышэйшы ўзровень дакладнасці ў гульні. База дадзеных, створаная з дапамогай дбайных вылічальных метадаў, прапануе амаль ідэальныя гульнявыя рашэнні.\n\nЗаўвага: калі штучнаму інтэлекту не атрымаецца атрымаць доступ да базы дадзеных, ён будзе звяртацца да звычайных алгарытмаў для прыняцця гульнявых рашэнняў. Калі база дадзеных даступная, «Узровень складанасці» становіцца практычна непераўзыдзеным, а «Час разважанняў AI» рэзка скарачаецца. Многія параметры ў параметрах «Стыль гульні штучнага інтэлекту» будуць перавызначаны, паколькі вынікі базы дадзеных маюць самы высокі прыярытэт.\n\nКаб атрымаць інструкцыі аб тым, як максімальна выкарыстоўваць гэтую бездакорную базу дадзеных, націсніце тут.';

  @override
  String get backgroundImage => 'Фонавы малюнак';

  @override
  String get whatIsRandom =>
      'Калі параметр «Выкарыстоўваць ідэальную базу дадзеных» не ўключаны, параметр «Выпадковы» прымушае штучны інтэлект перамяшчаць фігуры выпадковым чынам без выкарыстання якіх-небудзь алгарытмаў выбару хадоў. Гэта звычайна прыводзіць да значна слабейшага гульнявога працэсу. І наадварот, калі «Выкарыстоўваць ідэальную базу дадзеных» уключана, ШІ абапіраецца выключна на «Ідэальную базу дадзеных» для прыняцця рашэнняў замест таго, каб змешваць яе з традыцыйнымі алгарытмамі штучнага інтэлекту. У гэтым рэжыме дзеянні штучнага інтэлекту цалкам грунтуюцца на змесце базы дадзеных, пазбягаючы залежнасці ад вылічэнняў у рэальным часе або алгарытмаў пошуку.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Выдаліце фігуру(ы) праціўніка з рукі; затым ход праціўніка размясціць.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Пры фарміраванні млыноў падчас фазы размяшчэння';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Выдаліце фігуру(ы) праціўніка з дошкі.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Выдаліце фігуру(ы) праціўніка з дошкі; затым ход праціўніка размясціць.';

  @override
  String get opponentRemovesOwnPiece =>
      'Праціўнік выдаляе сваю фігуру(ы) з дошкі.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Замест таго, каб вы прынялі меры, апанент выбірае і выдаляе сваю фігуру(ы) з дошкі, фактычна робячы дзеянне, якое шкодзіць самому сабе.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Выдаліце фігуру(ы) праціўніка з рукі; затым ваша чарга рухацца.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Выдаліце фігуру(ы) з рукі праціўніка. Калі, у адпаведнасці з наладай Multi-remove, трэба выдаліць некалькі штук і ў суперніка не засталося фігур у руцэ, працягвайце выдаляць фігуры праціўніка з дошкі. Затым ваша чарга рухацца. Калі вы працягваеце фарміраваць млыны, вы можаце працягваць выдаляць фігуры праціўніка.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Выдаліце фігуру(ы) з рукі праціўніка. Калі, у адпаведнасці з наладай Multi-remove, трэба выдаліць некалькі штук і ў суперніка не засталося фігур у руцэ, працягвайце выдаляць фігуры праціўніка з дошкі. Затым ход праціўніка рухацца.';

  @override
  String get markAndDelayRemovingPieces =>
      'Пазначыць і адкласці выдаленне штук.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Падчас этапу размяшчэння фігуры, якія трэба выдаліць, пазначаюцца, і для абодвух гульцоў на гэтыя пункты нельга размяшчаць новыя фігуры. Пасля ўваходу ў фазу руху гэтыя пазначаныя фігуры выдаляюцца цалкам, а потым гульцы могуць перамяшчаць свае фігуры на гэтыя цяпер пустыя пункты.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Дзеянні, якія могуць быць прыняты пры фарміраванні млыноў на этапе размяшчэння.';

  @override
  String get marked => 'Пазначаны';

  @override
  String get menu => 'Меню';

  @override
  String get monochrome => 'Манахром';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Вы можаце ўключыць падтрымку экраннага чытальніка ў наладах даступнасці ў агульных наладах.';

  @override
  String get showNumbersOnPieces => 'Паказаць нумары на фігурах';

  @override
  String get saveImage => 'Захаваць малюнак';

  @override
  String get isAnalysisToolbarShown => 'Паказаць панэль аналізу';

  @override
  String get analysisToolbarBackgroundColor => 'Колер фону панэлі аналізу';

  @override
  String get analysisToolbarIconColor => 'Колер іконкі панэлі аналізу';

  @override
  String get transformed => 'Трансф.';

  @override
  String get cannotTransform => 'Немагчыма трансфармацыі.';

  @override
  String get rotate => 'Рухаць';

  @override
  String get horizontalFlip => 'Гарызонт.';

  @override
  String get verticalFlip => 'Верт.';

  @override
  String get innerOuterFlip => 'І/З Паварот';

  @override
  String get transparentCanvas => 'Празрыстае Палатно';

  @override
  String get restrictRepeatedMillsFormation =>
      'Абмежаваць паўторнае ўтварэнне млыноў';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Кавалак, які перамяшчаецца з аднаго млына ў іншы, не можа непасрэдна вярнуцца ў пачатковую кропку на наступны ход, каб зноў сфармаваць млын. Спачатку патрабуецца іншы рух.';

  @override
  String get oneTimeUseMill => 'Аднаразовая млын';

  @override
  String get oneTimeUseMill_Detail =>
      'Кожны млын можа выдаліць толькі адну частку суперніка. Вы можаце перафармаваць яго зноў, але яго нельга выкарыстоўваць для дадатковых выдаленняў.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Бягучыя правілы, якія вы ўсталявалі, не маюць адпаведнай ідэальнай базы даных. Для атрымання дадатковай інфармацыі аб ідэальнай базе даных націсніце тут.';

  @override
  String get focusOnBlockingPaths => 'Засяродзіце ўвагу на блакаванні шляхоў';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Перавага аддаецца перашкодзе руху суперніка, а не фарміраванню тройкі. Замест таго, каб засяродзіцца на выдаленні фігур шляхам завяршэння тройкі, ШІ імкнецца паставіць суперніка ў тупік, не дазваляючы яму рухацца і забяспечваючы перамогу праз стратэгію знясілення, а не агрэсіўную гульню. Гэтая стратэгія не блакуе актыўна тройкі суперніка.';

  @override
  String get pieceImage => 'Выява фігуры';

  @override
  String get importColorSettings => 'Імпартаваць налады колеру';

  @override
  String get exportColorSettings => 'Экспартаваць налады колеру';

  @override
  String get import => 'Імпарт';

  @override
  String get export => 'Экспарт';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Калі ласка, спачатку скапіруйце налады фармату JSON у буфер абмену.';

  @override
  String get copiedToClipboard => 'Скапіравана ў буфер абмену.';

  @override
  String get imported => 'Імпартавана.';

  @override
  String get boardImage => 'Вобраз дошкі';

  @override
  String get autumnLeaves => 'Восеньскія лісце';

  @override
  String get legendaryLand => 'Легендарная Зямля';

  @override
  String get vignetteEffect => 'Эфект віньеткі';

  @override
  String get promptMakeToolbarTransparent =>
      'Ці хацелі б вы зрабіць панэль інструментаў цалкам празрыстай, калі ўсталявана фонавая выявы для дошкі?';

  @override
  String get vibration => 'Уключыць вібрацыю ў гульні';

  @override
  String get soundTheme => 'Тэматыка гуку';

  @override
  String get ball => 'Мяч';

  @override
  String get liquid => 'Целавая';

  @override
  String get wood => 'Дрэва';

  @override
  String get placeEffectAnimation => 'Анімацыйны эфект размяшчэння фігуры';

  @override
  String get removeEffectAnimation => 'Анімацыйны эфект выдалення фігуры';

  @override
  String get isToolbarAtBottom => 'Паказаць панэль інструментаў унізе';

  @override
  String get boardCornerRadius => 'Радыюс кута дошкі';

  @override
  String get useOpeningBook => 'Выкарыстоўвайце кнігу адкрыццяў';

  @override
  String get currentRule => 'Цяперашні';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Набор правілаў';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'One-Time Mill';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'Дазвольце ШІ выкарыстоўваць стартавыя ходы, якія звычайна выкарыстоўваюцца прафесійнымі гульцамі на раннім этапе гульні. Заўвага: Гэтая функцыя на дадзены момант даступная толькі для канкрэтных набораў правілаў.';

  @override
  String get showAdvantageGraph => 'Паказаць графік перавагі';

  @override
  String get advantageGraphHint =>
      'Графік перавагі будзе намаляваны толькі пасля таго, як ШІ зробіць ход. Калі ход робіць чалавек-гулец, графік не будзе намаляваны.';

  @override
  String get removalBasedOnMillCounts =>
      'Выключыце выдаленне, пакуль усе фігуры не будуць расстаўлены. Гульцы выдаляюць фігуры на падставе колькасці млыноў.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Выключыце выдаленне, пакуль усе фігуры не будуць расстаўлены. Гульцы выдаляюць фігуры на падставе колькасці млыноў: калі колькасць аднолькавая, абодва выдаляюць аднолькавую колькасць; калі ў аднаго больш, ён выдаляе лішнюю фігуру, захоўваючы розніцу ў адну фігуру. Калі млын утварыў толькі адзін гульняр, ён выдаляе дзве фігуры, а другі — адну. Калі ніводны млын не ўтварыўся, абодва выдаляюць па адной фігуры.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Абярыце адну са сваіх фігур.';

  @override
  String get notYourTurn => 'Не ваш ход.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Колер фону панэлі інструментаў анатацый';

  @override
  String get annotationToolbarIconColor =>
      'Колер значкоў панэлі інструментаў анатацый';

  @override
  String get isAnnotationToolbarShown =>
      'Паказаць панэль інструментаў анатацый';

  @override
  String get enterAnnotationMode => 'Увайсці ў рэжым анатацый';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Вы ўпэўнены, што хочаце ачысціць усе анатацыі?';

  @override
  String get llmPromptCopiedToClipboard =>
      'Падказка LLM скапіяваная ў буфер абмену.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Злучэнне адхілена, сервер можа быць недаступны.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Выяўленне паспяховае, чакаем злучэння...';

  @override
  String get noLanConnection => 'Няма злучэння па лакальнай сетцы';

  @override
  String get takeScreenshot => 'Зрабіць здымак экрана';

  @override
  String get disconnectedFromOpponent => 'Адлучаны ад суперніка.';

  @override
  String get takeBackRequest => 'Запыт на вяртанне ходу';

  @override
  String get nothingToShow => 'Няма чаго паказваць.';

  @override
  String get stopHosting => 'Спыніць хостынг';

  @override
  String get connectionResetByPeer => 'Злучэнне скінутае аднолькай.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Злучэнне страчана з-за тайм-аўту сэрцабіцця. Калі ласка, перападключыцеся.';

  @override
  String get startHosting => 'Пачаць хостынг';

  @override
  String get restartRequestRejected => 'Запыт на перазапуск адхілены.';

  @override
  String get notConnectedToLanOpponent =>
      'Не падлучаны да суперніка па лакальнай сетцы.';

  @override
  String get llmPrompt => 'Падказка LLM';

  @override
  String get gameRestarted => 'Гульня перазапущена.';

  @override
  String get takeBackRejected => 'Вяртанне ходу адхілена.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Вы ўпэўнены, што хочаце здацца ў гэтай гульні?';

  @override
  String get opponentResignedYouWin => 'Супернік здаўся. Вы перамаглі!';

  @override
  String get clearAllAnnotations => 'Ачысціць усе анатацыі';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Падлучаны, чакаем ходу суперніка...';

  @override
  String get networkStatusDisconnected => 'Статус сеткі: Адлучаны';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Запыт на вяртанне ходу адпраўлены суперніку.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'Супернік, магчыма, пакінуў гульню';

  @override
  String get connectedToHostSuccessfully => 'Паспяхова падлучаны да хоста.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Злучэнне страчана: тайм-аўт сэрцабіцця';

  @override
  String get noHostDiscovered => 'Хост не выяўлены.';

  @override
  String get confirmResignation => 'Пацвердзіць здачу';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Пачаў хостынг гульні, чакаем далучэння гульцоў...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Злучэнне перарвана па тайм-аўту, сеткавае злучэнне нестабільнае.';

  @override
  String get noLlmPromptAvailable => 'Няма даступнай падказкі LLM.';

  @override
  String get youResignedGameOver => 'Вы здаліся. Гульня скончана.';

  @override
  String get serverIp => 'IP сервера';

  @override
  String get confirmClear => 'Пацвердзіць ачыстку';

  @override
  String get opponentSTurn => 'Ход суперніка.';

  @override
  String get waitingAClientConnection => 'Чакаем злучэння кліента...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Запыт на вяртанне ходу быў адхілены або не ўдаўся.';

  @override
  String get addText => 'Дадаць тэкст';

  @override
  String get exitAnnotationMode => 'Выйсці з рэжыму анатацый';

  @override
  String get typeYourAnnotation => 'Увядзіце вашу анатацыю';

  @override
  String get attemptingToReconnect => 'Спрабуем перападключыцца...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Запыт на перазапуск адпраўлены. Чакаем адказу суперніка...';

  @override
  String get serverIsStopped => 'Сервер спынены.';

  @override
  String get restartRequest => 'Запыт на перазапуск';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Немагчыма запытаць вяртанне ходу, калі не ваш ход.';

  @override
  String get takeBackAccepted => 'Вяртанне ходу прынята.';

  @override
  String get localNetworkSettings => 'Налады лакальнай сеткі';

  @override
  String get reconnectedSuccessfully => 'Паспяхова перападключаны!';

  @override
  String get failedToSaveImageToGallery =>
      'Не ўдалося захаваць выяву ў галерэю.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Супернік запытаў перазапуск гульні. Вы прымаеце?';

  @override
  String get yourTurn => 'Ваш ход.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Немагчыма перападключыцца, калі ласка, перазапусціце гульню.';

  @override
  String get host => 'Хост';

  @override
  String get join => 'Далучыцца';

  @override
  String get port => 'Порт';

  @override
  String get invalidIpAddress => 'Няправільны IP-адрас.';

  @override
  String get invalidPort => 'Няправільны порт.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Падлучэнне: Спроба $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Не ўдалося падлучыцца: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Не ўдалося пачаць хостынг: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Хост выяўлены: $ip:$port';
  }

  @override
  String get stop => 'Спыніць';

  @override
  String get discover => 'Выявіць';

  @override
  String get connect => 'Падлучыцца';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Кліент падлучаны: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Выяўленне: $seconds с';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Перападлучэнне ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Падлучаны';

  @override
  String get delete => 'Выдаліць';

  @override
  String get ancientEgypt => 'Старажытны Егіпет';

  @override
  String get gothicIce => 'Гатычны Лёд';

  @override
  String get riceField => 'Рысавае Поле';

  @override
  String get chinesePorcelain => 'Кітайскі Фарфор';

  @override
  String get desertDusk => 'Пустынны Змярканне';

  @override
  String get precisionCraft => 'Дакладнае Рамяство';

  @override
  String get folkEmbroidery => 'Народная Вышыўка';

  @override
  String get carpathianHeritage => 'Карпацкая Спадчына';

  @override
  String get imperialGrandeur => 'Імператарская Веліч';

  @override
  String get bohemianCrystal => 'Багемскі Крышталь';

  @override
  String get savannaSunrise => 'Саванны Ўсход Сонца';

  @override
  String get harmonyBalance => 'Гармонія Равнавага';

  @override
  String get cinnamonSpice => 'Карычная Спецыя';

  @override
  String get anatolianMosaic => 'Анаталійская Мазаіка';

  @override
  String get carnivalSpirit => 'Карнавальны Дух';

  @override
  String get custom => 'Звычай';

  @override
  String get spiceMarket => 'Рынак спецый';

  @override
  String get swipeToRevealTheDrawer => 'Правядзіце, каб адкрыць скрыню';

  @override
  String get showGameInfoOnScreenshots =>
      'Паказваць інфармацыю аб гульні на здымках экрана';

  @override
  String get humanMoveTime => 'Ліміт часу для ходу чалавека';

  @override
  String get noTimeLimitForHumanMoves =>
      'Няма абмежавання па часе для хадоў чалавека';

  @override
  String get timeoutLoseWillBeApplied =>
      'Для гульца-чалавека будзе прымяняцца пройгрыш па тайм-аўту';

  @override
  String get identifyingBoard => 'Вызначэнне гульнявой дошкі…';

  @override
  String get youCanEnterAnyModelName => 'Вы можаце ўвесці любую назву мадэлі';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Палажэнне гульнявой дошкі прымянілі. FEN скапіраваны ў буфер абмену.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Парада: паспрабуйце зрабіць больш якасную фатаграфію гульнявой дошкі';

  @override
  String get llmPromptTemplate => 'Шаблон запыту LLM';

  @override
  String get noValidBoardDetected => 'Не знойдзена прыдатнай гульнявой дошкі';

  @override
  String get selectingImageFromAlbum => 'Выбар выявы з альбома…';

  @override
  String get configurePromptTemplate => 'Наладзіць шаблон запыту';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Рэдагаванне шаблону запыту для аналізу LLM';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Не ўдалося згенераваць FEN з распазнанай дошкі';

  @override
  String get outputInCurrentLanguage => 'Выхад на бягучай мове';

  @override
  String get commonBaseUrls => 'Распаўсюджаныя Base URL';

  @override
  String get viewCommonModels => 'Прагляд распаўсюджаных мадэляў';

  @override
  String get recognitionParametersUpdated =>
      'Параметры распазнавання абноўлены';

  @override
  String get whiteSMove => 'Ход Белых';

  @override
  String get resetToDefaults => 'Скінуць да стандартных';

  @override
  String get photoShoot => 'Фотаздымка';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Не ўдалося прымяніць распазнанае становішча';

  @override
  String get llmPromptContent => 'Змест запыту LLM';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM не наладжаны. Праверце свае налады.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Вызначыце пастаўшчыка, мадэль, API Key і Base URL';

  @override
  String get llmConfiguration => 'Канфігурацыя LLM';

  @override
  String get configureLlmProvider => 'Наладзіць пастаўшчыка LLM';

  @override
  String get llmPromptTemplateHeader => 'Загаловак шаблону запыту LLM';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'На выяве не распазнаны ніводнай фігуры. Калі ласка, паспрабуйце яшчэ раз.';

  @override
  String get recognizeBoardFromImage => 'Распазнаць гульнявую дошку з выявы';

  @override
  String get viewTips => 'Паказаць парады';

  @override
  String get applyToBoard => 'Прыменіць да дошкі';

  @override
  String get adjustBoardArea => 'Адрэгуляваць зону дошкі';

  @override
  String get viewCommonUrls => 'Паказаць распаўсюджаныя URLs';

  @override
  String get colorAnalysisFailed => 'Аналіз колераў не ўдалося!';

  @override
  String get analyzingGameBoardImage => 'Аналіз выявы гульнявой дошкі…';

  @override
  String get selectFromAlbum => 'Выбраць з альбома';

  @override
  String get noBoardPointDetected => 'Не выяўлена ніводнага пункта дошкі!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Калі пакінуць пустым, будзе выкарыстоўвацца шаблон па змаўчанні';

  @override
  String get llmConfig => 'Налады LLM';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Вы ўпэўнены, што хочаце вярнуць шаблоны запытаў да значэнняў па змаўчанні?';

  @override
  String get llmPromptTemplateFooter => 'Падвал шаблону запыту LLM';

  @override
  String get loadingResponse => 'Загрузка адказу…';

  @override
  String get applyThisResultToBoard => 'Прыменіць гэты вынік да дошкі';

  @override
  String get takingPicture => 'Здымка…';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Калі ласка, абярыце выяву гульнявой дошкі для ідэнтыфікацыі';

  @override
  String get identificationResults => 'Вынікі ідэнтыфікацыі';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Прааналізуйце хады і дайце парады.';

  @override
  String get getApiKey => 'Атрымаць API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Уся працэдура распазнавання не выканалася';

  @override
  String get boardRecognitionResult => 'Вынік распазнавання дошкі';

  @override
  String get askLlm => 'Спытаць LLM';

  @override
  String get boardDetectionFailed => 'Не ўдалося выявіць дошку!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Не выяўлена ніводнага пункта дошкі, немагчыма ідэнтыфікаваць фігуру!';

  @override
  String get copyFen => 'Капіяваць FEN';

  @override
  String get commonlyUsedModels => 'Частавыкарыстоўваныя мадэлі';

  @override
  String get apiKeyOptional => 'API Key (Неабавязкова)';

  @override
  String get noImageSelected => 'Выява не абраная';

  @override
  String get blackSMove => 'Ход Чорных';

  @override
  String get llm => 'Вялікая моўная мадэль';

  @override
  String get llmProvider => 'Пастаўшчык';

  @override
  String get baseUrl => 'Базавы URL';

  @override
  String get model => 'Мадэль';

  @override
  String get temperature => 'Тэмпература';

  @override
  String get llmCommandReceivedProcessing =>
      'Каманда атрымана! ШІ апрацоўвае...';

  @override
  String get llmDeepThinkingWait =>
      'Працягваецца глыбокае мысленне, пачакайце, калі ласка...';

  @override
  String get llmPresentingSoon => 'Хутка будзе прадстаўлена...';

  @override
  String get recognitionParameters => 'Параметры распазнавання';

  @override
  String get adjustParamsDesc =>
      'Адкарэктуйце параметры, каб павысіць дакладнасць распазнавання';

  @override
  String get saveParameters => 'Захаваць параметры';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Не ўдалося запусціць распазнаванне выявы: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Распазнаванне выявы не атрымалася: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Прымяняецца пазіцыя з $whiteCount белымі і $blackCount чорнымі фішкамі';
  }

  @override
  String get fenCopiedToClipboard => '(FEN скапіяваны ў буфер абмену)';

  @override
  String recognitionFailed(String error) {
    return 'Распазнаванне не атрымалася: $error';
  }

  @override
  String get myRating => 'Мой рэйтынг';

  @override
  String get gamesPlayed => 'Згуляныя гульні';

  @override
  String get wins => 'Перамогі';

  @override
  String get losses => 'Паразы';

  @override
  String get draws => 'Нічыі';

  @override
  String get lastUpdated => 'Апошняе абнаўленне';

  @override
  String get format => 'Фармат:';

  @override
  String get resetStatistics => 'Скінуць статыстыку';

  @override
  String get drawRate => 'Працэнт нічыіх';

  @override
  String get lossRate => 'Працэнт паражэнняў';

  @override
  String get aiStatistics => 'Статыстыка ШІ';

  @override
  String get enableStatistics => 'Уключыць статыстыку';

  @override
  String get enableStatistics_Detail =>
      'Калі ўключана, вынікі гульняў будуць запісвацца ў статыстыку. Аднак гульні, якія ўключаюць вяртанне хадоў, не будуць запісвацца. Калі адключана, збор статыстыкі прыпыняецца.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Гэта скіне ўсю статыстыку гульні. Гэта дзеянне немагчыма адмяніць.';

  @override
  String get boardInnerRingSize => 'Памер унутранага кольца дошкі';

  @override
  String get boardShadowEnabled => 'Цень дошкі';

  @override
  String get trapAwareness => 'Вызначэнне пастак';

  @override
  String get trapAwarenessDescription =>
      'Падсвятляйце хады-пасткі тоўстымі коламі і стрэлкамі падчас аналізу.';

  @override
  String trapExists(String trapMoves) {
    return 'Ёсць пастка. Хады-пасткі: $trapMoves';
  }

  @override
  String get custodianCapture => 'Флангавы захоп';

  @override
  String get custodianCaptureDescription =>
      'Дадайце адзін з твораў суперніка паміж двума вашымі ў прамой лініі, каб захапіць яго.';

  @override
  String get custodianCaptureEnable => 'Дазвольце захопу фланга';

  @override
  String get interventionCapture => 'Захоп умяшання';

  @override
  String get interventionCaptureDescription =>
      'Перайдзіце ў пустую кропку паміж двума творамі суперніка, каб захапіць іх абодва.';

  @override
  String get interventionCaptureEnable => 'Дазволіць заход умяшання';

  @override
  String get leapCapture => 'Скачок захопу';

  @override
  String get leapCaptureDescription =>
      'Захопіце, пераскокваючы праз суседні супернік у пустую кропку за яе межамі.';

  @override
  String get leapCaptureEnable => 'Дазвольце захопу скачка';

  @override
  String get captureApplicableLines => 'Прыдатныя радкі';

  @override
  String get captureSquareEdges => 'Уздоўж краёў квадрата';

  @override
  String get captureCrossLines =>
      'Уздоўж артаганальных ліній, якія перасякаюць квадрат';

  @override
  String get captureDiagonalLines =>
      'Уздоўж дыяганальных ліній, якія перасякаюць квадрат';

  @override
  String get captureExecutionPhases => 'Фазы выканання';

  @override
  String get capturePiecesCondition =>
      'Наяўнасць на этапе перамяшчэння на аснове астатніх твораў';

  @override
  String get capturePiecesConditionUnlimited => 'Без абмежавання';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Даступна, калі ў вас ёсць тры ці менш штук';
}
