// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Azerbaijani (`az`).
class SAz extends S {
  SAz([String locale = 'az']) : super(locale);

  @override
  String get appName => 'Dəyirman';

  @override
  String get welcome => 'Xoş gəldiniz';

  @override
  String get yes => 'Bəli';

  @override
  String get no => 'Yox';

  @override
  String get game => 'Oyun';

  @override
  String get humanVsAi => 'İnsan Vs. AI';

  @override
  String get humanVsHuman => 'İnsan Vs. İnsan';

  @override
  String get aiVsAi => 'AI Vs. AI';

  @override
  String get humanVsCloud => 'İnsan Vs. Bulud';

  @override
  String get humanVsLAN => 'İnsan Vs. LAN';

  @override
  String get testViaLAN => 'LAN vasitəsilə test edin';

  @override
  String get move => 'Hərəkət';

  @override
  String get showMoveList => 'Siyahını köçürün';

  @override
  String get moveList => 'Siyahını köçürün';

  @override
  String get noGameRecord => 'Rekord yoxdur';

  @override
  String get ok => 'tamam';

  @override
  String get confirm => 'Təsdiq edin';

  @override
  String get cancel => 'Ləğv et';

  @override
  String get tipSelectWrong => 'Yanlış parça seçin.';

  @override
  String get tipPlace => 'Parçalarınızı yerləşdirin.';

  @override
  String get tipBanPlace => 'Siz onu burada yerləşdirə bilməzsiniz.';

  @override
  String get tipPlaced => 'yerləşdirdiniz.';

  @override
  String get tipRemove => 'Bir parça çıxarın.';

  @override
  String get tipBanRemove => 'Siz onu silə bilməzsiniz.';

  @override
  String get tipRemoved => 'sildiniz.';

  @override
  String get tipMove => 'Bir parça köçürün.';

  @override
  String get tipCannotPlace => 'Siz öz parçanızı bura yerləşdirə bilməzsiniz.';

  @override
  String get tipCannotMove => 'Parçanı bura köçürə bilməzsən.';

  @override
  String get tipMill => 'Mill! Rəqibinizin parçasını götürün.';

  @override
  String get tipContinueMill => 'Rəqibinizin parçasını almağa davam edin.';

  @override
  String get tipSelectOpponentsPiece =>
      'Rəqibinizin parçalarından birini seçin.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Siz dəyirmandan bir parça çıxara bilməzsiniz.';

  @override
  String get tipCanMoveOnePoint => 'Bir parça 1 nöqtə hərəkət edə bilər.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Rəqibinizin fiqurlarını hərəkət etdirə bilməzsiniz.';

  @override
  String get tipSelectPieceToMove => 'Hərəkət etmək üçün parçanızı seçin.';

  @override
  String get tipHaveThreePiecesLeft => 'Üç parçanız qalıb.';

  @override
  String get tipCanMoveToAnyPoint => 'İstədiyiniz nöqtəyə keçə bilərsiniz.';

  @override
  String tipToMove(Object player) {
    return 'hərəkət etmək üçün $player.';
  }

  @override
  String get whiteWin => 'Oyunçu 1 qalib gəlir!';

  @override
  String get blackWin => 'Oyunçu 2 qazanır!';

  @override
  String get won => 'Qazandı';

  @override
  String get lost => 'İtirilmiş';

  @override
  String get thinking => 'Düşünür…';

  @override
  String get newGame => 'Yeni oyun';

  @override
  String get importGame => 'İdxal oyun';

  @override
  String get exportGame => 'İxrac oyun';

  @override
  String get gameImported => 'Oyun idxal edilib.';

  @override
  String cannotImport(Object invalidMove) {
    return '$invalidMove idxal edilə bilməz';
  }

  @override
  String get movesAndRulesNotMatch => 'Hərəkətlər və qaydalar uyğun gəlmir.';

  @override
  String get pleaseWait => 'Zəhmət olmasa, gözləyin.';

  @override
  String get restartGame => 'Cari oyun yenidən başlasın?';

  @override
  String get restart => 'Yenidən başlamaq';

  @override
  String get gameStarted => 'Oyun başladı, yerləşdirin.';

  @override
  String get analyzing => 'Təhlil edilir…';

  @override
  String error(Object message) {
    return 'Xəta: $message';
  }

  @override
  String get winRate => 'Qazanma dərəcəsi';

  @override
  String get score => 'Xal:';

  @override
  String get white => 'Oyunçu 1';

  @override
  String get black => 'Oyunçu 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player parça sayı üçdən azdır.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player istefa verdi.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player-in getməyə yolu yoxdur.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Lövhə doludur və $player-in getməyə yolu yoxdur.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Vaxt bitdi, $player itirildi.';
  }

  @override
  String get drawReasonRule50 =>
      'Hərəkət mərhələsində, son konkret sayda hərəkətdə heç bir parça çıxarılmadı.';

  @override
  String get drawReasonBoardIsFull => 'Püşkatmadır, çünki lövhə doludur.';

  @override
  String get drawReasonThreefoldRepetition =>
      'Üç dəfə təkrarlandığı üçün heç-heçədir.';

  @override
  String get gameOverUnknownReason => 'Oyun bitdi! Naməlum səbəb.';

  @override
  String get gameOver => 'Oyun bitdi';

  @override
  String get youWin => 'Sən qalibsən! Təbrik edirik!';

  @override
  String challengeHarderLevel(int level) {
    return 'Daha çətin səviyyəyə meydan oxuyun? Yeni səviyyə $level səviyyəsi olacaq!';
  }

  @override
  String get youLose => 'Siz itirdiniz!';

  @override
  String get analyze => 'Təhlil edin';

  @override
  String get about => 'Haqqında';

  @override
  String version(Object versionNumber) {
    return 'Versiya: $versionNumber';
  }

  @override
  String get thanks => 'təşəkkürlər';

  @override
  String get settings => 'Parametrlər';

  @override
  String get options => 'Seçimlər';

  @override
  String get generalSettings => 'Ümumi Parametrlər';

  @override
  String get skillLevel => 'Çətinlik səviyyəsi';

  @override
  String get moveTime => 'AI düşünmə vaxtı';

  @override
  String get difficulty => 'Çətinlik';

  @override
  String get playSounds => 'Səs effektləri';

  @override
  String get playSoundsInTheGame => 'Oyunda səsləri çalın';

  @override
  String get keepMuteWhenTakingBack => 'Geri götürərkən səssiz saxlayın';

  @override
  String get tone => 'Ton';

  @override
  String get whoMovesFirst => 'İlk hərəkət';

  @override
  String get human => 'İnsan';

  @override
  String get ai => 'AI';

  @override
  String get alternate => 'Alternativ';

  @override
  String get isAutoRestart => 'Oyun bitdikdə oyunu avtomatik yenidən başladın';

  @override
  String get isAutoChangeFirstMove => 'İlk Hərəkəti avtomatik dəyişdirin';

  @override
  String get shufflingEnabled => 'Təsadüfi hərəkət edin';

  @override
  String get misc => 'Müxtəlif';

  @override
  String get rules => 'Qaydalar';

  @override
  String get piecesCount => 'Hər oyunçunun sahib olduğu ədədlərin sayı';

  @override
  String get piecesCount_Detail => 'Hər oyunçuda neçə ədəd var?';

  @override
  String get flyPieceCount => 'Uçan parçanın nömrəsi';

  @override
  String get flyPieceCount_Detail =>
      'Uçuş aktivləşdirilibsə, oyunçu müəyyən bir parça sayına endirildikdə, onun fiqurları oyunun qalan hissəsində olduğu kimi bitişik nöqtələrlə məhdudlaşdırılmaq əvəzinə istənilən boş nöqtəyə keçə bilər.';

  @override
  String get piecesAtLeastCount => 'Ən azı Parçalar';

  @override
  String get hasDiagonalLines => 'Diaqonal xətlər';

  @override
  String get hasDiagonalLines_Detail =>
      'Lövhəyə dörd diaqonal xətt əlavə edin.';

  @override
  String get isDefenderMoveFirst => 'İkinci oyunçu əvvəlcə hərəkət edir';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Yerləşdirmə mərhələsində ikinci hərəkət edən oyunçu hərəkət mərhələsində birinci olur.';

  @override
  String get mayRemoveMultiple => 'Çoxlu sil';

  @override
  String get mayRemoveMultiple_Detail =>
      'Oyunçu bir anda birdən çox dəyirmanı bağlasa, bağladığı dəyirmanların sayını siləcək.';

  @override
  String get mayRemoveFromMillsAlways => 'Dəyirmanları məhv edin';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Varsayılan olaraq, oyunçular formalaşmış dəyirmandan bir parça çıxarmazdan əvvəl hər hansı digər parçaları çıxarmalıdırlar. Məhdudiyyəti aradan qaldırmaq üçün bu seçimi aktivləşdirin.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Lövhə dolu olduqda ikinci oyunçu itirir';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Yerləşdirmə mərhələsinin sonunda lövhə dolu olduqda, ilk yeri tutan tərəf oyunu uduzur. Əks halda oyun heç-heçə olacaq.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Heç bir qanuni hərəkət olmadığı zaman itirmək';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Rəqibi onları hərəkət etdirə bilməmək üçün blok edərsə, oyunçu itirəcək. Bu seçim deaktivdirsə, hərəkət etmək üçün tərəfi dəyişdirin.';

  @override
  String get mayFly => 'Uçan';

  @override
  String get mayFly_Detail =>
      'Əgər oyunçuda yalnız üç və ya dörd (konfiqurasiya edilə bilən) parça qalırsa, o, parçanı istənilən boş nöqtəyə daşıya bilər.';

  @override
  String get nMoveRule => 'N-hərəkət qaydası';

  @override
  String get nMoveRule_Detail =>
      'Müəyyən sayda hərəkətdə heç bir silinmə olmadıqda oyun çəkilir.';

  @override
  String get rollback => 'Geriyə qaytarmaq';

  @override
  String get pleaseSelect => 'Zəhmət olmasa seçin';

  @override
  String get copy => 'Kopy';

  @override
  String get moveHistoryCopied => 'Tarixçəni mübadilə buferinə köçürün.';

  @override
  String get help => 'Kömək edin';

  @override
  String get feedback => 'Əlaqə';

  @override
  String get exit => 'Çıx';

  @override
  String get ruleSettings => 'Qayda Parametrləri';

  @override
  String get color => 'Rəng';

  @override
  String get boardColor => 'Lövhənin rəngi';

  @override
  String get pieceColor => 'Parça rəngi';

  @override
  String get backgroundColor => 'Fon rəngi';

  @override
  String get lineColor => 'Lövhə xətti rəngi';

  @override
  String get whitePieceColor => 'Oyunçu 1 ədəd rəng';

  @override
  String get blackPieceColor => 'Oyunçu 2 parça rəng';

  @override
  String get messageColor => 'Mesaj rəngi';

  @override
  String get isPieceCountInHandShown =>
      'Yerləşdirilməmiş parçaların sayını göstərin';

  @override
  String get isNotationsShown => 'Bortda qeydləri göstərin';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Tarixçə naviqasiya alətlər panelini göstərin';

  @override
  String get display => 'Ekran';

  @override
  String get boardBorderLineWidth => 'Lövhənin sərhəd xəttinin eni';

  @override
  String get boardInnerLineWidth => 'Lövhənin daxili xəttinin eni';

  @override
  String get pieceWidth => 'Parça eni';

  @override
  String get fontSize => 'Şrift ölçüsü';

  @override
  String get standardNotation => 'WMD qeydi';

  @override
  String get restore => 'Bərpa et';

  @override
  String get restoreDefaultSettings => 'Defolt parametrləri bərpa edin';

  @override
  String pick(Object element) {
    return '$element seçin';
  }

  @override
  String get info => 'Məlumat';

  @override
  String get hint => 'İpucu';

  @override
  String get player => 'oyunçu';

  @override
  String get player1 => 'Oyunçu 1';

  @override
  String get player2 => 'Oyunçu 2';

  @override
  String get howToPlay => 'Necə oynamalı';

  @override
  String get toPlacePiece =>
      'Parçanı yerləşdirmək üçün istənilən mövcud nöqtəyə toxunun.';

  @override
  String get toSelectPiece =>
      'Bir parçanı hərəkət etdirmək üçün üzərinə toxunun.';

  @override
  String get toMovePiece =>
      'Parçanı hərəkət etdirmək üçün ona qoşulmuş nöqtəyə toxunun.';

  @override
  String get toRemovePiece => 'Çıxarmaq üçün rəqibin bir parçasına toxunun.';

  @override
  String get needToCreateMillFirst =>
      'Bir parçanı çıxarmazdan əvvəl əvvəlcə dəyirman yaratmalısınız.';

  @override
  String get needToPlayWithOwnPieces => 'Parçalarınızla oynamaq lazımdır.';

  @override
  String get statistics => 'Statistika';

  @override
  String get totalGames => 'Ümumi oyunlar';

  @override
  String get results => 'Nəticələr';

  @override
  String get left => 'sol';

  @override
  String get privacyPolicy => 'Gizlilik Siyasəti';

  @override
  String get privacyPolicy_Detail_1 =>
      'Zəhmət olmasa diqqətlə oxuyun və bunu tam başa düşdüyünüzə və razılaşdığınızdan əmin olun ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Bu Siyasətlə razı deyilsinizsə, bu tətbiqdən istifadə etməyin. Tətbiqdən istifadə bu şərtləri qəbul etdiyiniz deməkdir.';

  @override
  String get and => ' və ';

  @override
  String get accept => 'Qəbul edin';

  @override
  String get takeBack => 'Geri götür';

  @override
  String get takingBack => 'Geri götürülür…';

  @override
  String get waiting => 'Gözlənir…';

  @override
  String get stepForward => 'İrəli addımlayın';

  @override
  String get takeBackAll => 'Hamısını geri götür';

  @override
  String get stepForwardAll => 'Hamısını irəli apar';

  @override
  String get moveNow => 'İndi köçün';

  @override
  String get done => 'Bitdi.';

  @override
  String get crackMill => 'Çatlayan dəyirman';

  @override
  String get crackMill_Detail =>
      'Əgər oyunçunun dəyirmanlarda yalnız parçaları varsa, dəyirmanlardakı parçalar çıxarmaq üçün kilidlənməyəcək.';

  @override
  String get animationDuration => 'Animasiya müddəti';

  @override
  String get none => 'Heç biri';

  @override
  String get theme => 'Mövzu';

  @override
  String get helpContent =>
      'Oyun üçdən az fiqurla və ya qanuni hərəkətsiz rəqibi tərk etmək məqsədi daşıyır.\n\nBir mövqe üçüncü dəfə baş verərsə və ya son 100 (konfiqurasiya edilə bilən) hərəkətdə heç bir silmə etməzsə, oyun avtomatik olaraq heç-heçə edir.\n\nOyun üç mərhələdə davam edir:\n\n1. Boş yerlərə parçaların yerləşdirilməsi\n2. Parçaların bitişik nöqtələrə köçürülməsi\n3. (isteğe bağlı mərhələ) Oyunçunu üç ədədə endirərkən parçaları istənilən boş yerə köçürmək\n\nYerləşdirmə\n\nOyun iyirmi dörd xal olan bir şəbəkədən ibarət boş bir lövhə ilə başlayır. Oyunçular növbə ilə öz hissələrini boş nöqtələrə yerləşdirirlər, ta ki hər bir oyunçu bütün parçaları lövhəyə yerləşdirənə qədər. Əgər oyunçu üç fiqurunu düz qoya bilirsə, onun \"dəyirmanı\" var və rəqibinin fiqurlarından birini lövhədən çıxara bilər.\n\nBəzi qaydalarda oyunçular formalaşmış dəyirmandan bir parça çıxarmazdan əvvəl hər hansı digər parçaları çıxarmalıdırlar.\n\nBəzi qaydalarda yerləşdirmə mərhələsində parçaları çıxarılan parçaların nöqtələrinə yenidən yerləşdirə bilməzsiniz.\n\nBütün parçaları istifadə etdikdən sonra oyunçular növbə ilə hərəkət edirlər.\n\nHərəkət edir\n\nHərəkət etmək üçün oyunçu öz parçalarından birini taxta xətti boyunca boş bitişik nöqtəyə aparır. Əgər bunu edə bilmirsə, oyunu uduzmuşdur. Üç fiqurunu taxta xəttinə düzən oyunçunun dəyirmanı var və yerləşdirmə mərhələsində olduğu kimi rəqibinin fiqurlarından birini çıxara bilər. İstənilən oyunçu iki hissəyə enir, yeni dəyirmanlar yaratmaq imkanı yoxdur və beləliklə oyunu itirir. Rəqibi onların hərəkətinə mane olarsa, oyunçu üçdən çox fiqur qazandıqda da itirə bilər.\n\nUçan\n\nQaydaların bəzi variantlarında, oyunçuda yalnız üç fiqur qaldıqdan sonra, onun fiqurları yalnız bitişik olanlara deyil, istənilən boş nöqtələrə uça, atlaya və ya atlaya bilər.\n';

  @override
  String get versionInfo => 'Versiya məlumatı';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'Lisenziya';

  @override
  String get sourceCode => 'Mənbə kodu';

  @override
  String get appVersion => 'Proqram Versiyası';

  @override
  String get general => 'General';

  @override
  String get advanced => 'Qabaqcıl';

  @override
  String get placing => 'Yerləşdirmə';

  @override
  String get moving => 'Hərəkət edir';

  @override
  String get removing => 'Silinir';

  @override
  String get gameOverCondition => 'Oyunun bitmə şərti';

  @override
  String get aisPlayStyle => 'AI-nin oyun tərzi';

  @override
  String get passive => 'Passiv';

  @override
  String get timeout => 'Vaxt';

  @override
  String get appearance => 'Görünüş';

  @override
  String get drawOnHumanExperience => 'İnsan təcrübəsindən istifadə edin';

  @override
  String get considerMobility => 'Parçaların hərəkətliliyini nəzərə alın';

  @override
  String get pieceCount => 'Parça sayı:';

  @override
  String inHand(Object player, int count) {
    return '$player əlində: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player göyərtədə: $count';
  }

  @override
  String get boardTop => 'Lövhə yuxarıdan ofset';

  @override
  String get notAIsTurn => 'Süni intellektin növbəsi deyil.';

  @override
  String get aiIsNotThinking => 'AI düşünmür.';

  @override
  String get atEnd => 'Siz köçürmə siyahısının sonundasınız.';

  @override
  String get tapBackAgainToLeave => 'Çıxmaq üçün yenidən klikləyin.';

  @override
  String get more => 'Daha çox';

  @override
  String get experimental => 'Bu eksperimental xüsusiyyətdir.';

  @override
  String get experiments => 'Təcrübələr';

  @override
  String get ossLicenses => 'Açıq mənbə lisenziyaları';

  @override
  String get language => 'Dil';

  @override
  String get defaultLanguage => 'Defolt dil';

  @override
  String get mayMoveInPlacingPhase =>
      'Parçalar yerləşdirmə mərhələsində hərəkət edə bilər';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Ayrı-ayrı yerləşdirmə və hərəkət mərhələləri yoxdur, yəni oyunçular hər bir hərəkətdə taxtaya bir parça yerləşdirmək və ya özlərindən birini hərəkət etdirmək (yerləşdirmək üçün qalan hissələri olduğu müddətcə) qərar verə bilərlər.';

  @override
  String get drawerColor => 'Menyu rəngi';

  @override
  String get drawerTextColor => 'Menyu mətn rəngi';

  @override
  String get drawerHighlightItemColor => 'Menyu elementinin rəngini vurğulamaq';

  @override
  String get mainToolbarBackgroundColor => 'Əsas alətlər panelinin fon rəngi';

  @override
  String get mainToolbarIconColor => 'Əsas alətlər panelinin ikona rəngi';

  @override
  String get navigationToolbarBackgroundColor =>
      'Naviqasiya alətlər paneli fon rəngi';

  @override
  String get navigationToolbarIconColor =>
      'Naviqasiya alətlər paneli işarəsi rəngi';

  @override
  String get autoHideToolbar => 'Alətlər panelini avtomatik gizlədin';

  @override
  String get toolbarLocationOnScreen => 'Ekranda alətlər panelinin yeri';

  @override
  String get top => 'Üst';

  @override
  String get bottom => 'Aşağı';

  @override
  String get center => 'Mərkəz';

  @override
  String get solidColor => 'Düz rəng';

  @override
  String get picture => 'Şəkil';

  @override
  String get chooseYourPicture => 'Şəkilinizi seçin';

  @override
  String get light => 'İşıq';

  @override
  String get dark => 'Qaranlıq';

  @override
  String get themes => 'Mövzular';

  @override
  String get currentTheme => 'Cari mövzu';

  @override
  String get saveTheme => 'Mövzunu yadda saxla';

  @override
  String get showAnalysisGraph => 'Təhlil qrafikini göstərin';

  @override
  String get analysis => 'Təhlil';

  @override
  String get saveGame => 'Oyun saxlamaq';

  @override
  String get loadGame => 'Oyun yükləyin';

  @override
  String get setupPosition => 'Quraşdırma mövqeyi';

  @override
  String get showLegalMoves => 'Qanuni hərəkətləri göstərin';

  @override
  String get showLastMove => 'Son hərəkəti göstərin';

  @override
  String get showArrows => 'Oxları göstərin';

  @override
  String get pieces => 'Parçalar';

  @override
  String get showAnalysis => 'Təhlil göstərin';

  @override
  String get threads => 'Qollu';

  @override
  String get getInvolved => 'İşə cəlb olun';

  @override
  String get helpImproveTranslate => 'Tərcüməni təkmilləşdirməyə kömək edin';

  @override
  String get tutorial => 'Dərslik';

  @override
  String get classicMill => 'Klassik dəyirman';

  @override
  String get mixedMill => 'Qarışıq dəyirman';

  @override
  String get ceylonMill => 'Seylon dəyirmanı';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Dəyirman dəfələrlə qırıla və yenidən düzəldilə bilər';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Əgər oyunçu dərhal yeni dəyirman yaratmaq üçün dəyirmanı sındırarsa, belə oyunçu yeni dəyirman edərsə, növbəti hərəkətində belə parçanı orijinal qovşağına köçürə bilər.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Əgər oyunçuda üç fiqur varsa və on hərəkətdən sonra heç bir oyunçu rəqibin fiqurlarını çıxarmazsa, oyun heç-heçə sayılır';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Əgər oyunçu üç fiqurdan az olarsa və heç bir oyunçu on hərəkət ərzində rəqibin fiqurunu çıxara bilmirsə, oyun heç-heçə sayılır.';

  @override
  String get close => 'Yaxın';

  @override
  String get whitePiece => 'Ağ parça';

  @override
  String get blackPiece => 'Qara parça';

  @override
  String get emptyPoint => 'Boş nöqtə';

  @override
  String get noPoint => 'Məntiq yoxdur';

  @override
  String get placingPhase => 'Yerləşdirmə mərhələsi';

  @override
  String get movingPhase => 'Hərəkət mərhələsi';

  @override
  String get flyingPhase => 'Uçuş mərhələsi';

  @override
  String sideToMove(Object player) {
    return 'Hərəkət ediləcək tərəf: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Son hərəkət: $move';
  }

  @override
  String get selected => 'Seçildi';

  @override
  String get accessibility => 'Əlçatanlıq';

  @override
  String get screenReaderSupport => 'Ekran oxuyucu dəstəyi';

  @override
  String get isDraw => 'Bu heç-heçədir!';

  @override
  String get draw => 'çəkmək';

  @override
  String get pieceHighlightColor => 'Parçanın vurğu rəngi';

  @override
  String get algorithm => 'Alqoritm';

  @override
  String get endgameNMoveRule => 'Endgame N-Move qaydası';

  @override
  String get endgameNMoveRule_Detail =>
      'Hər iki oyunçuda yalnız üç fiqur varsa və heç bir oyunçu müəyyən hərəkətlər çərçivəsində bir parça çıxarmazsa, oyun çəkilir.';

  @override
  String get drawReasonEndgameRule50 =>
      'Hər iki oyunçuda yalnız üç fiqur var və heç bir oyunçu müəyyən hərəkətlər çərçivəsində bir parça çıxarmır.';

  @override
  String get threefoldRepetitionRule => 'Üçqat təkrarlama qaydası';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Bir mövqe üçüncü dəfə baş verərsə, oyun heç-heçə sayılır.';

  @override
  String get continueToMakeMove => 'Mill! Hərəkət etməyə davam edin.';

  @override
  String get pointStyle => 'Nöqtə üslubu';

  @override
  String get pointWidth => 'Nöqtə eni';

  @override
  String get solid => 'Möhkəm';

  @override
  String get hollow => 'Boş dairə';

  @override
  String get languageName => 'Azərbaycanca';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Hərəkətlər',
      one: '$count Move',
      zero: 'Move',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Yükləmə uğursuz oldu.';

  @override
  String get filename => 'Fayl adı';

  @override
  String get browse => 'Baxın…';

  @override
  String get gameFiles => 'Oyun faylları';

  @override
  String get gameSavedTo => 'Oyun saxlanılır';

  @override
  String get empty => 'Boş nöqtə';

  @override
  String get noMove => 'Hərəkət yoxdur.';

  @override
  String get restoredPosition => 'İlkin mövqe bərpa edildi.';

  @override
  String get clean => 'Təmiz';

  @override
  String get cleanedUp => 'Təmizlənmiş.';

  @override
  String get remove => 'Sil';

  @override
  String get noPiecesCanBeRemoved => 'Heç bir parça çıxarıla bilməz.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ədəd',
      one: '$count parça',
      zero: 'Piece',
    );
    return '$_temp0 çıxarmaq lazımdır.';
  }

  @override
  String placedCount(int count) {
    return 'Yrlşd ($count)';
  }

  @override
  String get placedPieceCount =>
      'Yerləşdirmə mərhələsində yerləşdirilmiş parçaların sayı.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'Cari oyunçu $count fiqurları yerləşdirdi.';
  }

  @override
  String get notPlacingPhase => 'Faza yerləşdirməyin, onu dəyişdirə bilməz.';

  @override
  String get paste => 'Yapışdır';

  @override
  String get pasteDone => 'Pasta hazırdır.';

  @override
  String get cannotPaste => 'Yapışdırmaq mümkün deyil.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Yerləşdirilməmiş və çıxarılan parçaları göstərin';

  @override
  String get fullScreen => 'Tam ekran';

  @override
  String get reopenToTakeEffect =>
      'Parametrlərin qüvvəyə minməsi üçün proqramdan çıxın və yenidən açın.';

  @override
  String get forest => 'Meşə';

  @override
  String get desktopImage => 'Masaüstü Şəkli';

  @override
  String get invalidPosition => 'Yanlış mövqe.';

  @override
  String get shareGIF => 'GIF paylaşın';

  @override
  String get pixelRatio => 'Piksel nisbəti';

  @override
  String get duration => 'Müddət';

  @override
  String get gameScreenRecorder => 'Oyun ekran yazıcı';

  @override
  String get previous => 'Əvvəlki';

  @override
  String get next => 'Sonrakı';

  @override
  String get skip => 'Keç';

  @override
  String get gotIt => 'Anladım';

  @override
  String get youCanModifyRules =>
      'Oyunun qaydalarını qayda parametrlərində dəyişə bilərsiniz.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Seçicidəki dəyəri dəyişdirmək üçün siçan təkərindən istifadə edə bilərsiniz.';

  @override
  String get noTimeLimitForThinking =>
      'AI Düşünmə vaxtı 0 olaraq təyin olundu, o deməkdir ki, düşünmək üçün vaxt məhdudiyyəti yoxdur.';

  @override
  String get whatIsMtdf =>
      'MTD(f) alfa-beta axtarış alqoritminin dəyişdirilmiş formasıdır ki, onun məqsədi aralıq axtarış nəticələrindən təkrar istifadə etməklə və axtarış məkanını daraltmaq üçün yaxşı ilkin təxmindən istifadə etməklə səmərəliliyi artırmaqdır.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Nəzərə alın ki, AI düşünmə vaxtının tənzimlənməsi tamamilə dəqiq olmaya bilər. Çətinlik səviyyəsi aşağı qiymətə təyin edildikdə faktiki düşünmə vaxtı daha qısa ola bilər və vaxt bitdikdə AI orta hesabla olduqda daha uzun ola bilər.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Çətinlik səviyyəsini yüksək təyin etsəniz, lakin AI düşünmə vaxtını artırmasanız, düşünmə vaxtı məhdudiyyətinə görə faktiki çətinlik səviyyəsi aşağı qiymətlə məhdudlaşdırıla bilər. Faktiki dəyər maşının performansına görə dəyişə bilər.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) müəyyən bir mövqedə ən yaxşı hərəkəti tapmaq üçün axtarış alqoritmidir. Bu, alfa-beta alqoritminin təkmilləşdirilməsidir və hərəkətin əsas variasiyanın onsuz da təhlükəsiz hesabından daha pis və ya pis olmadığını təsdiqləmək üçün sıfır və ya sıfır pəncərə axtarışlarından istifadə edir. PVS ən perspektivli hərəkətlərə diqqət yetirir və axtarışın səmərəliliyini artırmağa kömək edən suboptimal filialların lazımsız axtarışlarının qarşısını alır.';

  @override
  String get whatIsAlphaBeta =>
      'Alfa-beta alqoritmi ən yaxşı hərəkəti tapmaq üçün axtarış alqoritmidir. Axtarış ağacını budamaq və səmərəliliyi artırmaq üçün minimax prinsipindən və iki dəyərdən, alfa və betadan istifadə edir. Alpha kompüterin əldə edə biləcəyi minimum balı, beta isə rəqibinin ala biləcəyi maksimum balı təmsil edir. Alqoritm kompüterə oyunda ağıllı, səmərəli qərarlar qəbul etməyə kömək edir.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'İnsan təcrübəsinə görə, qalib gəlməyə çalışsan, uduzacaqsan. Bunun əvəzinə, hədəfiniz kimi heç-heçəni hədəfləyin və oyunu uduzmaqdan çəkinin. Rəqibinizi müşahidə edin və yumşaq bir şəkildə səhv edə biləcəkləri bir vəziyyətə gətirin. Zəiflik göstərdikdə, fürsətdən istifadə edin və qələbə üçün yumşaq bir şəkildə itələyin. Bu şəkildə oyunda qalib gələ bilərsiniz.';

  @override
  String get firstMoveDetail =>
      'Bu oyunda birinci oyunçu ilə müqayisədə ikinci oyunçunun qalib gəlməsi daha asandır.';

  @override
  String get passiveDetail =>
      'Passiv seçimini aktivləşdirmək, aqressiv şəkildə mümkün qədər tez qalib gəlməyə çalışmaq əvəzinə, mövqedə üstünlüyə malik olduqda AI-nin rahatlamasına səbəb olacaq.';

  @override
  String get moveRandomlyDetail =>
      'Bu seçimi aktivləşdirmək oyunun təsadüfiliyini və əyləncəsini artırır, onu söndürmək isə süni intellektə qalib gəlməyin yollarını öyrənməyə kömək edə bilər.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Süni intellekt öz fiqurlarının hərəkətliliyini nəzərə alırsa, o, nəinki rəqibin fiqurlarını mümkün qədər tez tutmağı hədəfləyəcək, həm də rəqibin hərəkətlərinin qarşısını almağı və eyni şeyi etməsinə mane olmağı da düşünəcək.';

  @override
  String get whenBoardIsFull => 'Lövhə dolu olduqda';

  @override
  String get whenBoardIsFull_Detail =>
      'Yerləşdirmə mərhələsinin sonunda, hərəkət mərhələsi başlamazdan əvvəl, lövhə parçalarla doludursa, hərəkət davam edir.';

  @override
  String get sideToMoveRemovePiece =>
      'Hərəkət mərhələsində ilk hərəkət edən oyunçu rəqibin fiqurlarından birini çıxarır.';

  @override
  String get agreeToDraw => 'Hər iki tərəf heç-heçəyə razıdır.';

  @override
  String get takeOpponentsPiece => 'Rəqibinizin parçalarından birini götürün.';

  @override
  String get firstPlayerLose => 'İlk oyunçu oyunu itirir.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Birinci və ikinci oyunçular rəqibin fiqurlarından birini çıxarırlar.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'İkinci və birinci oyunçular rəqibin fiqurlarından birini çıxarırlar.';

  @override
  String get enteredFlyingPhase =>
      'İndi uçma mərhələsinə girdi, rəqibin fiqurları lövhədə istənilən boş nöqtəyə atlaya bilər. Uçuş qaydasını \"Qayda Parametrləri\"ndə söndürə bilərsiniz.';

  @override
  String get whenStalemate => 'Durğunlaşanda';

  @override
  String get whenStalemate_Detail =>
      'Heç bir parça köçürülə bilməyəndə hansı hərəkəti izləyir?';

  @override
  String get endWithStalemateLoss =>
      'Tıxanmış tərəf üçün çıxılmaz itki ilə başa çatın.';

  @override
  String get changeSideToMove => 'Hərəkət etmək üçün tərəfi dəyişdirin.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Rəqibin fiqurlarından birini çıxarın və növbəti hərəkəti edin.';

  @override
  String get endWithStalemateDraw => 'Durğun heç-heçə ilə bitir.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Rəqibin fiqurlarından birini çıxarın və hərəkət etmək üçün tərəfi dəyişdirin.';

  @override
  String get aiResponseDelayTime => 'AI cavab gecikmə vaxtı';

  @override
  String get aiIsDelaying =>
      'AI hazırda gecikmiş cavab mərhələsindədir. Davam etməzdən əvvəl bir az gözləyin.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Siz bitişik olmayan parçanı silə bilməzsiniz.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'Durğun olarsa, dəyirmanın formalaşmasından asılı olmayaraq, rəqibin sizə bitişik fiqurları çıxarıla bilər.';

  @override
  String get whatIsMcts =>
      'MCTS simulyasiyalar vasitəsilə müxtəlif hərəkətləri araşdıraraq və qiymətləndirərək qərarlar qəbul edən yeni başlayanlar üçün əlverişli alqoritmdir.';

  @override
  String get goldenJade => 'Qızıl Jade';

  @override
  String get forestWood => 'Meşə ağacı';

  @override
  String get darkMystery => 'Qaranlıq sirr';

  @override
  String get midnightBlue => 'Gecə yarısı Mavi';

  @override
  String get greenForest => 'Yaşıl Meşə';

  @override
  String get greenMeadow => 'Yaşıl çəmən';

  @override
  String get stonyPath => 'Daşlı yol';

  @override
  String get pastelPink => 'Pastel Çəhrayı';

  @override
  String get turquoiseSea => 'Firuzəyi dəniz';

  @override
  String get violetDream => 'Bənövşəyi yuxu';

  @override
  String get mintChocolate => 'Nanəli şokolad';

  @override
  String get skyBlue => 'Göy Mavi';

  @override
  String get playfulGarden => 'Oynaq bağçası';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Retrograd Analiz alqoritmi müxtəlif başlanğıc mövqelərindən oyun sonu verilənlər bazası yaratmaq üçün çox dəyərli retrograd analizdən istifadə edir, sonra oyunu optimallaşdırmaq üçün bu verilənlər bazasını tətbiq edir. Bu yanaşma Ultra Güclü həllər kateqoriyasına aiddir.';

  @override
  String get viewAlgorithmGuide =>
      'Bu alqoritm üçün istifadəçi təlimatına baxmaq istərdinizmi?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Mövqe üstünlüyü göstəricisini göstərin';

  @override
  String get usePerfectDatabase =>
      'Mükəmməl verilənlər bazasından istifadə edin';

  @override
  String get perfectDatabaseDescription =>
      'Ən müasir alqoritmlər vasitəsilə yaradılan qüsursuz oyun bazasından istifadə etmək üçün bu seçimi aktivləşdirin. Bu xüsusiyyət optimal hərəkətlər təklif etmək üçün həm açılış, həm də oyun sonu strategiyalarını birləşdirir. Bu, oyunda ən yüksək səviyyəli dəqiqliyə can atan oyunçular üçün üstünlük verilən seçimdir. Vasvası hesablama üsulları vasitəsilə yaradılmış verilənlər bazası mükəmməl oyun həlləri təklif etmək üçün nəzərdə tutulmuşdur.\n\nQeyd: Süni intellekt verilənlər bazasına daxil ola bilməsə, o, oyun qərarları üçün adi alqoritmlərə müraciət edəcək. Verilənlər bazası mövcud olduqda, \"Çətinlik Səviyyəsi\" faktiki olaraq məğlubedilməz olur və \"AI Thinking Time\" kəskin azalma ilə üzləşir. Verilənlər bazası nəticələri ən yüksək prioritetə malik olduğundan, \"AI-nin Playstyle\" seçimlərindəki bir çox parametr ləğv ediləcək.\n\nBu qüsursuz verilənlər bazasından maksimum yararlanmaq üçün bura klikləyin.';

  @override
  String get backgroundImage => 'Fon şəkili';

  @override
  String get whatIsRandom =>
      '\"Mükəmməl verilənlər bazasından istifadə et\" seçimi aktiv edilmədikdə, \"Təsadüfi\" parametri süni intellektin hərəkət seçimi üçün heç bir alqoritmdən istifadə etmədən parçaları təsadüfi şəkildə daşımasına səbəb olur. Bu, adətən əhəmiyyətli dərəcədə zəif oyunla nəticələnir. Əksinə, \"Mükəmməl verilənlər bazasından istifadə et\" aktiv olduqda, AI ənənəvi AI alqoritmləri ilə qarışdırmaq əvəzinə, qərar qəbul etmək üçün yalnız \"Mükəmməl verilənlər bazası\"na etibar edir. Bu rejimdə AI-nin hərəkətləri real vaxt hesablamalarına və ya axtarış alqoritmlərinə etibar etməkdən qaçaraq, tamamilə verilənlər bazasının məzmununa əsaslanır.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Rəqibin əlindəki daşları götürün; sonra rəqibin yerləşdirmə növbəsidir.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Yerləşdirmə fazasında dəyirmanlar qurarkən';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Rəqibin lövhədəki daşlarını götürün.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Rəqibin lövhədəki daşlarını götürün; sonra rəqibin yerləşdirmə növbəsidir.';

  @override
  String get opponentRemovesOwnPiece => 'Rəqib öz daşlarını lövhədən götürür.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Sizin hərəkət etməyiniz əvəzinə, rəqib öz daşlarını seçir və lövhədən götürür, effektiv olaraq özünə zərər verən bir hərəkət edir.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Rəqibin əlindəki daşları götürün; sonra sizin hərəkət etmə növbənizdir.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Rəqibin əlindəki daşları götürün. Çox sayda daş götürmə parametrinə görə, çoxlu daşlar götürülməlidirsə və rəqibin əlində daş qalmayıbsa, rəqibin lövhədəki daşlarını götürməyə davam edin. Sonra sizin hərəkət etmə növbənizdir. Dəyirmanlar qurmağa davam etsəniz, rəqibin daşlarını götürməyə davam edə bilərsiniz.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Rəqibin əlindəki daşları götürün. Çox sayda daş götürmə parametrinə görə, çoxlu daşlar götürülməlidirsə və rəqibin əlində daş qalmayıbsa, rəqibin lövhədəki daşlarını götürməyə davam edin. Sonra rəqibin hərəkət etmə növbəsidir.';

  @override
  String get markAndDelayRemovingPieces =>
      'Daşları işarələyin və götürməyi gecikdirin.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Yerləşdirmə fazasında götürüləcək daşlar işarələnir və hər iki oyunçu üçün bu nöqtələrə yeni daşlar qoyula bilməz. Hərəkət fazasına keçdikdə, bu işarələnmiş daşlar tamamilə götürülür və oyunçular öz daşlarını bu boş qalmış nöqtələrə hərəkət etdirə bilərlər.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Yerləşdirmə mərhələsində dəyirmanların formalaşdırılması zamanı həyata keçirilə bilən fəaliyyətlər.';

  @override
  String get marked => 'İşarələnib';

  @override
  String get menu => 'Menyu';

  @override
  String get monochrome => 'Monoxrom';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Siz Ümumi Ayarlar bölməsindəki Əlçatanlıq konfiqurasiyasında ekran oxuyucusu dəstəyini aktivləşdirə bilərsiniz.';

  @override
  String get showNumbersOnPieces => 'Fişlərdə nömrələri göstərin';

  @override
  String get saveImage => 'Şəkil saxla';

  @override
  String get isAnalysisToolbarShown => 'Analiz panelini göstər';

  @override
  String get analysisToolbarBackgroundColor =>
      'Analiz panelinin arxa fon rəngi';

  @override
  String get analysisToolbarIconColor => 'Analiz panelinin ikonu rəngi';

  @override
  String get transformed => 'Dönüşdürüldü.';

  @override
  String get cannotTransform => 'Dönüşdürmək mümkün deyil.';

  @override
  String get rotate => 'Döndür';

  @override
  String get horizontalFlip => 'Y-Fli';

  @override
  String get verticalFlip => 'D-Fli';

  @override
  String get innerOuterFlip => 'İ/O Fli';

  @override
  String get transparentCanvas => 'Şəffaf Kanvas';

  @override
  String get restrictRepeatedMillsFormation =>
      'Təkrarlanan Dəyirmanların Formalaşmasını Məhdudlaşdırın';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Bir dəyirmanından digərinə köçürülən bir fiqur dərhal növbəti növbədə ilk dəyirmanı yenidən formalaşdırmaq üçün əvvəlki nöqtəyə qayıda bilməz. İlk öncə fərqli bir hərəkət tələb olunur.';

  @override
  String get oneTimeUseMill => 'Bir dəfə istifadə olunan dəyirman';

  @override
  String get oneTimeUseMill_Detail =>
      'Hər dəyirman rəqibin bir hissəsini yalnız bir dəfə çıxara bilər. Onu yenidən formalaşdıra bilərsiniz, lakin əlavə çıxarma üçün istifadə edilə bilməz.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Təyin etdiyiniz cari qaydalar uyğun mükəmməl verilənlər bazasına malik deyil. Mükəmməl verilənlər bazası haqqında daha çox məlumat üçün bura klikləyin.';

  @override
  String get focusOnBlockingPaths => 'Bloklama yollarına diqqət yetirin';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Rəqibin hərəkətini maneə törətməyə üstünlük verin, üçlüyü formalaşdırmaqdan daha çox. Üçlü yaratmaqla parçaları çıxarmağa yönəlmək əvəzinə, AI rəqibi tələyə salmağa çalışır, onları hərəkətsiz vəziyyətə gətirir və aqressiv oyundan çox tükəndirməklə qalib gəlir. Bu strategiya rəqibin üçlü yaratmasına aktiv şəkildə mane olmur.';

  @override
  String get pieceImage => 'Fiqur şəkli';

  @override
  String get importColorSettings => 'Rəng ayarlarını idxal edin';

  @override
  String get exportColorSettings => 'Rəng ayarlarını ixrac edin';

  @override
  String get import => 'İdxal';

  @override
  String get export => 'İxrac';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Zəhmət olmasa əvvəlcə JSON formatlı parametrləri mübadilə buferinə kopyalayın.';

  @override
  String get copiedToClipboard => 'Mübadilə buferinə kopyalandı.';

  @override
  String get imported => 'İdxal edildi.';

  @override
  String get boardImage => 'Taxta şəkli';

  @override
  String get autumnLeaves => 'Payız yarpaqları';

  @override
  String get legendaryLand => 'Əfsanəvi Torpaq';

  @override
  String get vignetteEffect => 'Vinyet effekti';

  @override
  String get promptMakeToolbarTransparent =>
      'Bir taxta arxa plan şəkli təyin edildikdə alət çubuğunu tam şəffaf etmək istərdiniz?';

  @override
  String get vibration => 'Oyun içində vibrasiyanı aktiv edin';

  @override
  String get soundTheme => 'Səs mövzusu';

  @override
  String get ball => 'Top';

  @override
  String get liquid => 'Maye';

  @override
  String get wood => 'Taxta';

  @override
  String get placeEffectAnimation => 'Fiquru yerləşdirmə animasiya effekti';

  @override
  String get removeEffectAnimation => 'Fiquru çıxarma animasiya effekti';

  @override
  String get isToolbarAtBottom => 'Alətlər panelini aşağıda göstər';

  @override
  String get boardCornerRadius => 'Lövhənin bucaq radiusu';

  @override
  String get useOpeningBook => 'Açılış kitabı istifadə edin';

  @override
  String get currentRule => 'Cari';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Qayda dəsti';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'One-Time Mill';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'AI-ya oyunun əvvəlində peşəkar insan oyunçular tərəfindən geniş istifadə edilən açılış hərəkətlərini istifadə etməyə icazə ver. Qeyd: Bu xüsusiyyət hazırda yalnız müəyyən qayda dəstləri üçün mövcuddur.';

  @override
  String get showAdvantageGraph => 'Üstünlük qrafikini göstər';

  @override
  String get advantageGraphHint =>
      'Üstünlük qrafiki yalnız süni intellekt hərəkət etdikdən sonra çəkiləcək. İnsan oyunçu hərəkət edəndə o çəkilməyəcək.';

  @override
  String get removalBasedOnMillCounts =>
      'Bütün fişlər yerləşdirilənə qədər çıxarışı dayandırın. Oyunçular fişləri dəyirman sayına əsasən çıxarırlar.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Bütün fişlər yerləşdirilənə qədər çıxarışı dayandırın. Oyunçular fişləri dəyirman sayına əsasən çıxarırlar: əgər saylar bərabərdirsə, hər iki oyunçu eyni sayda fiş çıxarır; birinin sayı çoxdursa, o, əlavə bir fiş çıxararaq fərqi bir fiş səviyyəsində saxlayır. Yalnız bir oyunçu dəyirman yığıbsa, o, iki fiş çıxarır, digər oyunçu isə bir fiş çıxarır. Heç biri dəyirman yığmayıbsa, hər ikisi bir fiş çıxarır.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Fişlərinizdən birini seçin.';

  @override
  String get notYourTurn => 'Sizin növbəniz deyil.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Annotasiya alətlər panelinin fon rəngi';

  @override
  String get annotationToolbarIconColor =>
      'Annotasiya alətlər panelinin işarə rəngi';

  @override
  String get isAnnotationToolbarShown => 'Annotasiya alətlər panelini göstər';

  @override
  String get enterAnnotationMode => 'Annotasiya rejiminə daxil ol';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Bütün annotasiyaları silmək istədiyinizə əminsiniz?';

  @override
  String get llmPromptCopiedToClipboard => 'LLM sorğusu panoya kopyalandı.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Bağlantı rədd edildi, server işləməyə bilər.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Axtarış uğurlu oldu, bağlantı gözlənilir...';

  @override
  String get noLanConnection => 'LAN bağlantısı yoxdur.';

  @override
  String get takeScreenshot => 'Ekran görüntüsü al.';

  @override
  String get disconnectedFromOpponent => 'Rəqibdən ayrıldı.';

  @override
  String get takeBackRequest => 'Geri alma sorğusu.';

  @override
  String get nothingToShow => 'Göstəriləcək heç nə yoxdur.';

  @override
  String get stopHosting => 'Host etməyi dayandır.';

  @override
  String get connectionResetByPeer =>
      'Bağlantı digər tərəf tərəfindən sıfırlandı.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Heartbeat vaxtı bitdiyi üçün bağlantı kəsildi. Yenidən qoşulun.';

  @override
  String get startHosting => 'Host etməyə başla.';

  @override
  String get restartRequestRejected => 'Yenidən başlatma sorğusu rədd edildi.';

  @override
  String get notConnectedToLanOpponent => 'LAN rəqibinə qoşulmayıb.';

  @override
  String get llmPrompt => 'LLM sorğusu.';

  @override
  String get gameRestarted => 'Oyun yenidən başladı.';

  @override
  String get takeBackRejected => 'Geri alma rədd edildi.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Bu oyundan imtina etmək istədiyinizə əminsiniz?';

  @override
  String get opponentResignedYouWin => 'Rəqib imtina etdi. Siz qalib gəldiniz!';

  @override
  String get clearAllAnnotations => 'Bütün annotasiyaları sil.';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Qoşuldu, rəqibin hərəkətini gözləyir...';

  @override
  String get networkStatusDisconnected => 'Şəbəkə statusu: Ayrıldı.';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Geri alma sorğusu rəqibə göndərildi.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'Rəqib oyunu tərk etmiş ola bilər.';

  @override
  String get connectedToHostSuccessfully => 'Host\'a uğurla qoşuldu.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Bağlantı kəsildi: heartbeat vaxtı bitdi.';

  @override
  String get noHostDiscovered => 'Host tapılmadı.';

  @override
  String get confirmResignation => 'İmtina etməyi təsdiqlə.';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Oyun host edildi, oyunçuların qoşulması gözlənilir...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Bağlantı vaxtı bitdi, şəbəkə bağlantısı qeyri-sabitdir.';

  @override
  String get noLlmPromptAvailable => 'LLM sorğusu mövcud deyil.';

  @override
  String get youResignedGameOver => 'Siz imtina etdiniz. Oyun bitdi.';

  @override
  String get serverIp => 'Serverin IP ünvanı';

  @override
  String get confirmClear => 'Silinməni təsdiqlə.';

  @override
  String get opponentSTurn => 'Rəqibin növbəsi.';

  @override
  String get waitingAClientConnection => 'Müştəri bağlantısı gözlənilir...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Geri alma sorğusu rədd edildi və ya uğursuz oldu.';

  @override
  String get addText => 'Mətn əlavə et.';

  @override
  String get exitAnnotationMode => 'Annotasiya rejimindən çıx.';

  @override
  String get typeYourAnnotation => 'Annotasiyanızı yazın.';

  @override
  String get attemptingToReconnect => 'Yenidən qoşulmağa cəhd edilir...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Yenidən başlatma sorğusu göndərildi. Rəqibin cavabını gözləyir...';

  @override
  String get serverIsStopped => 'Server dayandırıldı.';

  @override
  String get restartRequest => 'Yenidən başlatma sorğusu.';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Növbəniz olmadığı halda geri alma sorğusu verə bilməzsiniz.';

  @override
  String get takeBackAccepted => 'Geri alma qəbul edildi.';

  @override
  String get localNetworkSettings => 'Yerli şəbəkə parametrləri.';

  @override
  String get reconnectedSuccessfully => 'Uğurla yenidən qoşuldu!';

  @override
  String get failedToSaveImageToGallery =>
      'Şəkil qalereyaya saxlanıla bilmədi.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Rəqib oyunu yenidən başlatmaq istəyir. Qəbul edirsiniz?';

  @override
  String get yourTurn => 'Sizin növbəniz.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Yenidən qoşulmaq mümkün olmadı, lütfən oyunu yenidən başladın.';

  @override
  String get host => 'Host et';

  @override
  String get join => 'Qoşul';

  @override
  String get port => 'Port nömrəsi';

  @override
  String get invalidIpAddress => 'Yanlış IP ünvanı.';

  @override
  String get invalidPort => 'Yanlış port.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Qoşulma: Cəhd $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Qoşulma uğursuz oldu: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Host etməyə başlamaq uğursuz oldu: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Host tapıldı: $ip:$port';
  }

  @override
  String get stop => 'Dayandır.';

  @override
  String get discover => 'Axtar.';

  @override
  String get connect => 'Qoşul.';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Müştəri qoşuldu: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Axtarılır: $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Yenidən qoşulur ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Qoşuldu.';

  @override
  String get delete => 'Sil.';

  @override
  String get ancientEgypt => 'Qədim Misir';

  @override
  String get gothicIce => 'Qotik Buz';

  @override
  String get riceField => 'Çəltik Tarlası';

  @override
  String get chinesePorcelain => 'Çin Porseleni';

  @override
  String get desertDusk => 'Çöl Alatoranı';

  @override
  String get precisionCraft => 'Dəqiq Sənətkarlıq';

  @override
  String get folkEmbroidery => 'Xalq Naxışı';

  @override
  String get carpathianHeritage => 'Karpat İrsi';

  @override
  String get imperialGrandeur => 'İmperator Əzəməti';

  @override
  String get bohemianCrystal => 'Bohem Kristalı';

  @override
  String get savannaSunrise => 'Savanna Günəş Doğuşu';

  @override
  String get harmonyBalance => 'Harmoniya Balansı';

  @override
  String get cinnamonSpice => 'Darçın Ədviyyatı';

  @override
  String get anatolianMosaic => 'Anadolu Mozaikası';

  @override
  String get carnivalSpirit => 'Karnaval Ruhu';

  @override
  String get custom => 'Adət';

  @override
  String get spiceMarket => 'Ədviyyat Bazarı';

  @override
  String get swipeToRevealTheDrawer => 'Çəkməni göstərmək üçün sürüşdürün';

  @override
  String get showGameInfoOnScreenshots =>
      'Ekran görüntülərində oyun məlumatlarını göstər';

  @override
  String get humanMoveTime => 'İnsan hərəkəti üçün vaxt məhdudiyyəti';

  @override
  String get noTimeLimitForHumanMoves =>
      'İnsan hərəkətləri üçün vaxt məhdudiyyəti yoxdur';

  @override
  String get timeoutLoseWillBeApplied =>
      'İnsan oyunçu üçün vaxt aşımı ilə məğlubiyyət tətbiq olunacaq';

  @override
  String get identifyingBoard => 'Oyun taxtası tanınır...';

  @override
  String get youCanEnterAnyModelName =>
      'Hər hansı model adını daxil edə bilərsiniz';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Oyun taxtası vəziyyəti tətbiq olundu. FEN panoya köçürüldü.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Təklif: Taxtanın daha aydın fotoşəkilini çəkin';

  @override
  String get llmPromptTemplate => 'LLM sorğu şablonu';

  @override
  String get noValidBoardDetected => 'Etibarlı oyun taxtası aşkarlanmadı';

  @override
  String get selectingImageFromAlbum => 'Albomdan şəkil seçilir...';

  @override
  String get configurePromptTemplate => 'Sorğu şablonunu konfiqurasiya et';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'LLM təhlili üçün sorğu şablonunu redaktə et';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Tanınmış oyun taxtasından FEN yaratmaq mümkün olmadı';

  @override
  String get outputInCurrentLanguage => 'Cari dildə çıxış';

  @override
  String get commonBaseUrls => 'Ümumi Base URL-lər';

  @override
  String get viewCommonModels => 'Ümumi modellərə bax';

  @override
  String get recognitionParametersUpdated => 'Tanıma parametrləri yeniləndi';

  @override
  String get whiteSMove => 'Ağın gedişi';

  @override
  String get resetToDefaults => 'Standartlara qaytar';

  @override
  String get photoShoot => 'Fotoşəkil çəkilişi';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Tanınmış oyun taxtası vəziyyətini tətbiq etmək mümkün olmadı';

  @override
  String get llmPromptContent => 'LLM sorğu məzmunu';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM konfiqurasiya olunmayıb. Zəhmət olmasa, parametrləri yoxlayın.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Provider, model, API Key və Base URL-i təyin edin';

  @override
  String get llmConfiguration => 'LLM konfiqurasiyası';

  @override
  String get configureLlmProvider => 'LLM provider-ini konfiqurasiya et';

  @override
  String get llmPromptTemplateHeader => 'LLM sorğu şablonunun başlığı';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Şəkildə heç bir fiqur tanınmadı. Zəhmət olmasa, yenidən cəhd edin.';

  @override
  String get recognizeBoardFromImage => 'Şəkildən taxtanı tanı';

  @override
  String get viewTips => 'Məsləhətlərə bax';

  @override
  String get applyToBoard => 'Oyun taxtasına tətbiq et';

  @override
  String get adjustBoardArea => 'Oyun taxtası sahəsini tənzimləyin';

  @override
  String get viewCommonUrls => 'Ümumi URL-lərə bax';

  @override
  String get colorAnalysisFailed => 'Rəng analizi alınmadı!';

  @override
  String get analyzingGameBoardImage =>
      'Oyun taxtasının şəkli analiz edilir...';

  @override
  String get selectFromAlbum => 'Albomdan seç';

  @override
  String get noBoardPointDetected => 'Heç bir oyun taxtası nöqtəsi tapılmadı!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Boş buraxılsa, standart şablon istifadə ediləcək';

  @override
  String get llmConfig => 'LLM konfiqurasiyası';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Sorğu şablonlarını standart dəyərlərə qaytarmaq istədiyinizə əminsiniz?';

  @override
  String get llmPromptTemplateFooter => 'LLM sorğu şablonu altbilgisi';

  @override
  String get loadingResponse => 'Cavab yüklənir...';

  @override
  String get applyThisResultToBoard => 'Bu nəticəni oyun taxtasına tətbiq et';

  @override
  String get takingPicture => 'Şəkil çəkilir...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Tanımaq üçün oyun taxtasının şəklini seçin';

  @override
  String get identificationResults => 'Tanıma nəticələri';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Gedişləri analiz edin və təhlillər verin.';

  @override
  String get getApiKey => 'API Key alın';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Bütün tanıma prosesi tamamlanmadı';

  @override
  String get boardRecognitionResult => 'Oyun taxtasının tanınma nəticəsi';

  @override
  String get askLlm => 'LLM-ə soruş';

  @override
  String get boardDetectionFailed => 'Oyun taxtasının aşkarlanması alınmadı!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Heç bir oyun taxtası nöqtəsi aşkarlanmadı, fiquru müəyyən etmək mümkün deyil!';

  @override
  String get copyFen => 'FEN-i kopyala';

  @override
  String get commonlyUsedModels => 'Tez-tez istifadə olunan modellər';

  @override
  String get apiKeyOptional => 'API Key (istəyə bağlı)';

  @override
  String get noImageSelected => 'Heç bir şəkil seçilməyib';

  @override
  String get blackSMove => 'Qaranın gedişi';

  @override
  String get llm => 'Böyük Dil Modeli';

  @override
  String get llmProvider => 'Təchizatçı';

  @override
  String get baseUrl => 'Əsas URL';

  @override
  String get model => 'Model';

  @override
  String get temperature => 'Temperatur';

  @override
  String get llmCommandReceivedProcessing =>
      'Əmr qəbul edildi! Süni intellekt emal edir...';

  @override
  String get llmDeepThinkingWait =>
      'Dərin düşünmə gedir, zəhmət olmasa gözləyin...';

  @override
  String get llmPresentingSoon => 'Yaxın zamanda təqdim olunacaq...';

  @override
  String get recognitionParameters => 'Tanınma parametrləri';

  @override
  String get adjustParamsDesc =>
      'Tanınmanın dəqiqliyini artırmaq üçün parametrləri tənzimləyin';

  @override
  String get saveParameters => 'Parametrləri yadda saxla';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Şəkil tanınmasını başlatmaq mümkün olmadı: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Şəkil tanınması uğursuz oldu: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return '$whiteCount ağ və $blackCount qara fiqurlu mövqe tətbiq edildi';
  }

  @override
  String get fenCopiedToClipboard => '(FEN mübadilə buferinə kopyalandı)';

  @override
  String recognitionFailed(String error) {
    return 'Tanınma uğursuz oldu: $error';
  }

  @override
  String get myRating => 'Mənim reytinqim';

  @override
  String get gamesPlayed => 'Oynanılan oyunlar';

  @override
  String get wins => 'Qələbələr';

  @override
  String get losses => 'Məğlubiyyətlər';

  @override
  String get draws => 'Heç-heçələr';

  @override
  String get lastUpdated => 'Son yenilənmə';

  @override
  String get format => 'Format:';

  @override
  String get resetStatistics => 'Statistikanı sıfırla';

  @override
  String get drawRate => 'Heç-heçə nisbəti';

  @override
  String get lossRate => 'Məğlubiyyət nisbəti';

  @override
  String get aiStatistics => 'Süni intellekt statistikası';

  @override
  String get enableStatistics => 'Statistikanı aktivləşdirin';

  @override
  String get enableStatistics_Detail =>
      'Aktivləşdirildikdə oyun nəticələri statistikada qeyd olunacaq. Lakin geri almaların olduğu oyunlar qeydə alınmayacaq. Deaktivləşdirildikdə statistika toplanması dayandırılır.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Bu, bütün oyun statistikasını sıfırlayacaq. Bu əməliyyat geri qaytarıla bilməz.';

  @override
  String get boardInnerRingSize => 'Taxtanın daxili halqanın ölçüsü';

  @override
  String get boardShadowEnabled => 'Taxta kölgəsi';

  @override
  String get trapAwareness => 'Tələ xəbərdarlığı';

  @override
  String get trapAwarenessDescription =>
      'Analiz zamanı tələ gedişlərini qalın dairələr və oxlarla vurğulayın.';

  @override
  String trapExists(String trapMoves) {
    return 'Tələ mövcuddur. Tələ gedişləri: $trapMoves';
  }

  @override
  String get custodianCapture => 'Sahil ələ keçirmə';

  @override
  String get custodianCaptureDescription =>
      'Rəqibinizin parçalarından birini ələ keçirmək üçün düz bir xəttdə ikiniz arasında əlavə edin.';

  @override
  String get custodianCaptureEnable => 'Flinging ələ keçirməyə icazə verin';

  @override
  String get interventionCapture => 'Müdaxilə tutulması';

  @override
  String get interventionCaptureDescription =>
      'Hər ikisini ələ keçirmək üçün rəqibinizin iki parçası arasındakı boş nöqtəyə keçin.';

  @override
  String get interventionCaptureEnable => 'Müdaxilə ələ keçirməyə icazə verin';

  @override
  String get leapCapture => 'Atlanmaq';

  @override
  String get leapCaptureDescription =>
      'Qonşu bir rəqib parçasının üstündən kənar nöqtəyə atlayaraq çəkin.';

  @override
  String get leapCaptureEnable => 'Atlama ələ keçirməyə icazə verin';

  @override
  String get captureApplicableLines => 'Tətbiq olunan xətlər';

  @override
  String get captureSquareEdges => 'Kvadrat kənarları boyunca';

  @override
  String get captureCrossLines => 'Meydanı keçən ortogonal xətlər boyunca';

  @override
  String get captureDiagonalLines => 'Meydanı keçən diaqonal xətlər boyunca';

  @override
  String get captureExecutionPhases => 'İcra mərhələləri';

  @override
  String get capturePiecesCondition =>
      'Qalan hissələrə əsaslanan hərəkət mərhələsində mövcudluq';

  @override
  String get capturePiecesConditionUnlimited => 'Heç bir məhdudiyyət yoxdur';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Üç və ya daha az hissədən olanda mövcuddur';
}
