// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Arabic (`ar`).
class SAr extends S {
  SAr([String locale = 'ar']) : super(locale);

  @override
  String get appName => 'المقطار';

  @override
  String get welcome => 'مرحبا';

  @override
  String get yes => 'نعم';

  @override
  String get no => 'لا';

  @override
  String get game => 'لعبة';

  @override
  String get humanVsAi => 'لاعب ضد الآلة';

  @override
  String get humanVsHuman => 'لاعب ضد لاعب';

  @override
  String get aiVsAi => 'آلة ضد آلة';

  @override
  String get humanVsCloud => 'الإنسان مقابل السحابة';

  @override
  String get humanVsLAN => 'تحدي الشبكة المحلية';

  @override
  String get testViaLAN => 'اختبار عبر الشبكة المحلية';

  @override
  String get move => 'الحركة';

  @override
  String get showMoveList => 'قائمة النقلات';

  @override
  String get moveList => 'قائمة النقلات';

  @override
  String get noGameRecord => 'لا توجد سجلات';

  @override
  String get ok => 'حسنا';

  @override
  String get confirm => 'تأكيد';

  @override
  String get cancel => 'إلغاء';

  @override
  String get tipSelectWrong => 'حدد القطعة الخاطئة.';

  @override
  String get tipPlace => 'ضع قطعك.';

  @override
  String get tipBanPlace => 'لا يمكنك وضعها هنا.';

  @override
  String get tipPlaced => 'تم وضعها.';

  @override
  String get tipRemove => 'أزِل قطعة.';

  @override
  String get tipBanRemove => 'لا يمكنك إزالتها.';

  @override
  String get tipRemoved => 'تمت الإزالة.';

  @override
  String get tipMove => 'حرك قطعة.';

  @override
  String get tipCannotPlace => 'لا يمكنك وضع قطعتك هنا.';

  @override
  String get tipCannotMove => 'لا يمكنك تحريك قطعتك إلى هنا.';

  @override
  String get tipMill => 'مطحنة! خذ قطعة خصمك.';

  @override
  String get tipContinueMill => 'استمر في أخذ قطعة خصمك.';

  @override
  String get tipSelectOpponentsPiece => 'اختر إحدى قطع خصمك.';

  @override
  String get tipCannotRemovePieceFromMill => 'لا يمكنك إزالة قطعة من المطحنة.';

  @override
  String get tipCanMoveOnePoint => 'يمكن أن تتحرك القطعة بمقدار نقطة واحدة.';

  @override
  String get tipCannotMoveOpponentsPieces => 'لا يمكنك تحريك قطع خصمك.';

  @override
  String get tipSelectPieceToMove => 'حدد قطعتك لتحريكها.';

  @override
  String get tipHaveThreePiecesLeft => 'لديك ٣ قطع متبقية.';

  @override
  String get tipCanMoveToAnyPoint => 'يمكنك الانتقال إلى أي نقطة تريدها.';

  @override
  String tipToMove(Object player) {
    return 'دور $player.';
  }

  @override
  String get whiteWin => 'اللاعب ١ يفوز!';

  @override
  String get blackWin => 'اللاعب ٢ يفوز!';

  @override
  String get won => 'فوز';

  @override
  String get lost => 'خسارة';

  @override
  String get thinking => 'يفكر الرجاء الانتظار …';

  @override
  String get newGame => 'لعبة جديدة';

  @override
  String get importGame => 'استيراد اللعبة';

  @override
  String get exportGame => 'تصدير اللعبة';

  @override
  String get gameImported => 'تم استيراد اللعبة من الحافظة.';

  @override
  String cannotImport(Object invalidMove) {
    return 'لا يمكن استيراد $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'النقلات والقواعد غير متطابقة.';

  @override
  String get pleaseWait => 'برجاء الإنتظار...';

  @override
  String get restartGame => 'إعادة تشغيل اللعبة الحالية؟';

  @override
  String get restart => 'إعادة تشغيل';

  @override
  String get gameStarted => 'بدأت اللعبة، من فضلك ضع القطع.';

  @override
  String get analyzing => 'جارٍ التحليل…';

  @override
  String error(Object message) {
    return 'خطأ: $message';
  }

  @override
  String get winRate => 'معدل الفوز';

  @override
  String get score => 'النتيجة:';

  @override
  String get white => 'اللاعب ١';

  @override
  String get black => 'اللاعب ٢';

  @override
  String loseReasonlessThanThree(Object player) {
    return 'خسر $player لأن عدد قطعه أقل من ثلاثة.';
  }

  @override
  String loseReasonResign(Object player) {
    return 'استسلم $player.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player ليس لديه نقلات ممكنة.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'اللوحة ممتلئة، و$player ليس لديه نقلات ممكنة.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'انتهى الوقت، خسر $player.';
  }

  @override
  String get drawReasonRule50 =>
      'في مرحلة الحركة ، لم تتم إزالة أي قطعة في آخر عدد محدد من الحركات.';

  @override
  String get drawReasonBoardIsFull => 'إنه تعادل لأن اللوحة ممتلئة.';

  @override
  String get drawReasonThreefoldRepetition => 'إنه تعادل بسبب التكرار الثلاثي.';

  @override
  String get gameOverUnknownReason => 'انتهت اللعبة! سببٌ غيرُ معلومٍ.';

  @override
  String get gameOver => 'انتهت اللعبة';

  @override
  String get youWin => 'فزت! تهانينا!';

  @override
  String challengeHarderLevel(int level) {
    return 'تحدي مستوى أصعب؟ المستوى الجديد سيكون المستوى $level!';
  }

  @override
  String get youLose => 'لقد خسرت!';

  @override
  String get analyze => 'حلل';

  @override
  String get about => 'حول';

  @override
  String version(Object versionNumber) {
    return 'الإصدار: $versionNumber';
  }

  @override
  String get thanks => 'شكرا';

  @override
  String get settings => 'الإعدادات';

  @override
  String get options => 'الخيارات';

  @override
  String get generalSettings => 'الإعدادات العامة';

  @override
  String get skillLevel => 'مستوى الصعوبة';

  @override
  String get moveTime => 'وقت التفكير للذكاء الاصطناعي';

  @override
  String get difficulty => 'الصعوبة';

  @override
  String get playSounds => 'مؤثرات صوتية';

  @override
  String get playSoundsInTheGame => 'تشغيل الأصوات في اللعبة';

  @override
  String get keepMuteWhenTakingBack => 'حافظ على الصمت عند التراجع';

  @override
  String get tone => 'نغمة';

  @override
  String get whoMovesFirst => 'الخطوة الأولى';

  @override
  String get human => 'لاعب';

  @override
  String get ai => 'آلة';

  @override
  String get alternate => 'بالتناوب';

  @override
  String get isAutoRestart => 'إعادة تشغيل اللعبة تلقائيًا عند انتهاء اللعبة';

  @override
  String get isAutoChangeFirstMove => 'تبديل اللاعب البادئ تلقائيًا';

  @override
  String get shufflingEnabled => 'حركة عشوائية';

  @override
  String get misc => 'متفرقات';

  @override
  String get rules => 'قواعد';

  @override
  String get piecesCount => 'عدد القطع التي يمتلكها كل لاعب';

  @override
  String get piecesCount_Detail => 'كم عدد القطع التي يمتلكها كل لاعب؟';

  @override
  String get flyPieceCount => 'عتبة الطيران';

  @override
  String get flyPieceCount_Detail =>
      'إذا تم تمكين الطيران ، عندما يقل عدد قطع اللاعب عن عتبة معينة ، فإن قطعه تكون حرة في الانتقال إلى أي نقطة غير مشغولة ، بدلاً من أن تكون مقيدة بالنقاط المجاورة كما هو الحال في بقية اللعبة.';

  @override
  String get piecesAtLeastCount => 'قطع على الأقل';

  @override
  String get hasDiagonalLines => 'خطوط قطرية';

  @override
  String get hasDiagonalLines_Detail => 'أضف أربعة خطوط قطرية إلى اللوحة.';

  @override
  String get isDefenderMoveFirst => 'اللاعب الثاني يتحرك أولاً';

  @override
  String get isDefenderMoveFirst_Detail =>
      'اللاعب الذي يلعب ثانياً في مرحلة الوضع يتحرك أولاً في مرحلة الحركة.';

  @override
  String get mayRemoveMultiple => 'متعدد الإزالة';

  @override
  String get mayRemoveMultiple_Detail =>
      'إذا أغلق اللاعب أكثر من مطحنة في وقت واحد ، فسيكون قادرًا على إزالة عدد المطاحن التي أغلقها.';

  @override
  String get mayRemoveFromMillsAlways => 'تدمير المطاحن';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'بشكل افتراضي ، يجب على اللاعبين إزالة أي قطع أخرى أولاً قبل إزالة قطعة من مطحنة مشكلة. قم بتمكين هذا الخيار لإلغاء هذا القيد.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'اللاعب الثاني يخسر عندما تكون اللوحة ممتلئة';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'في نهاية مرحلة الوضع، عندما تمتلئ اللوحة بالكامل، يخسر اللاعب الذي وضع قطعه أولًا اللعبة، وإلا فستكون النتيجة تعادلًا.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'تخسر عندما لا توجد حركات قانونية';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'سيخسر اللاعب إذا قام خصمه بحظرهم بحيث لا يمكن تحريكهم. يتم تبديل الدور إذا تم تعطيل هذا الخيار.';

  @override
  String get mayFly => 'طيران';

  @override
  String get mayFly_Detail =>
      'إذا كان لدى اللاعب ثلاث أو أربع قطع (قابلة لتخصيص) فقط ، فيمكنه تحريك القطعة إلى أي نقطة حرة.';

  @override
  String get nMoveRule => 'قاعدة الـ N نقلات';

  @override
  String get nMoveRule_Detail =>
      'يتم تعادُل اللعبة إذا لم تتم إزالة في عدد معين من النقلات من قبل كل لاعب.';

  @override
  String get rollback => 'عودة';

  @override
  String get pleaseSelect => 'الرجاء التحديد';

  @override
  String get copy => 'نسخ';

  @override
  String get moveHistoryCopied => 'تم نسخ سجل الحركات إلى الحافظة.';

  @override
  String get help => 'مساعدة';

  @override
  String get feedback => 'ملاحظات';

  @override
  String get exit => 'خروج';

  @override
  String get ruleSettings => 'إعدادات القواعد';

  @override
  String get color => 'اللون';

  @override
  String get boardColor => 'لون اللوحة';

  @override
  String get pieceColor => 'لون القطعة';

  @override
  String get backgroundColor => 'لون الخلفية';

  @override
  String get lineColor => 'لون خط اللوحة';

  @override
  String get whitePieceColor => 'لون قطعة اللاعب ١';

  @override
  String get blackPieceColor => 'لون قطعة اللاعب ٢';

  @override
  String get messageColor => 'لون الرسالة';

  @override
  String get isPieceCountInHandShown => 'عرض عدد القطع غير الموضوعة';

  @override
  String get isNotationsShown => 'عرض التدوين';

  @override
  String get isHistoryNavigationToolbarShown => 'إظهار شريط التنقل في السجل';

  @override
  String get display => 'عرض';

  @override
  String get boardBorderLineWidth => 'عرض حدود اللوحة';

  @override
  String get boardInnerLineWidth => 'عرض الخط الداخلي لللوحة';

  @override
  String get pieceWidth => 'عرض القطعة';

  @override
  String get fontSize => 'حجم الخط';

  @override
  String get standardNotation => 'التدوين القياسي';

  @override
  String get restore => 'استعادة';

  @override
  String get restoreDefaultSettings => 'استعادة الإعدادات الافتراضية';

  @override
  String pick(Object element) {
    return 'اختر $element';
  }

  @override
  String get info => 'معلومات';

  @override
  String get hint => 'تلميح';

  @override
  String get player => 'لاعب';

  @override
  String get player1 => 'اللاعب ١';

  @override
  String get player2 => 'اللاعب ٢';

  @override
  String get howToPlay => 'كيفية اللعب';

  @override
  String get toPlacePiece => 'انقر على أي نقطة متاحة لوضع القطعة.';

  @override
  String get toSelectPiece => 'انقر على قطعة لتحريكها.';

  @override
  String get toMovePiece => 'انقر على النقطة المتصلة بالقطعة لتحريكها.';

  @override
  String get toRemovePiece => 'انقر على قطعة الخصم لإزالتها.';

  @override
  String get needToCreateMillFirst =>
      'تحتاج إلى إنشاء طاحونة أولاً قبل أن تتمكن من إزالة قطعة.';

  @override
  String get needToPlayWithOwnPieces => 'أنت بحاجة للعب بالقطع الخاصة بك.';

  @override
  String get statistics => 'إحصائيات';

  @override
  String get totalGames => 'إجمالي الألعاب';

  @override
  String get results => 'نتائج';

  @override
  String get left => 'المتبقية';

  @override
  String get privacyPolicy => 'سياسة الخصوصية';

  @override
  String get privacyPolicy_Detail_1 =>
      'يرجى القراءة بعناية والتأكد من فهمك التام لهذا الأمر والموافقة عليه. ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. إذا كنت لا توافق على هذه السياسة ، يرجى عدم استخدام هذا التطبيق. استخدام التطبيق يعني قبولك لهذه الشروط.';

  @override
  String get and => ' و ';

  @override
  String get accept => 'قبول';

  @override
  String get takeBack => 'تراجع';

  @override
  String get takingBack => 'يتراجع…';

  @override
  String get waiting => 'الرجاء الانتظار…';

  @override
  String get stepForward => 'خطوة للأمام';

  @override
  String get takeBackAll => 'تراجع عن الكل';

  @override
  String get stepForwardAll => 'التقدم للكل';

  @override
  String get moveNow => 'تحرك الآن';

  @override
  String get done => 'تم.';

  @override
  String get crackMill => 'كسر حصانة الطاحونة';

  @override
  String get crackMill_Detail =>
      'إذا كان لدى اللاعب قطع فقط في المطاحن ، فلن يتم قفل القطع الموجودة في المطاحن لإزالتها.';

  @override
  String get animationDuration => 'مدة الرسوم المتحركة';

  @override
  String get none => 'لا شيء';

  @override
  String get theme => 'نسق';

  @override
  String get helpContent =>
      'تهدف اللعبة إلى ترك الخصم بأقل من ثلاث قطع أو عدم وجود حركات قانونية.\n\nيتم رسم اللعبة تلقائيًا في حالة حدوث مركز للمرة الثالثة ، أو إذا لم تتم إزالة في آخر 100 حركة (قابلة للتكوين).\n\nتستمر اللعبة على ثلاث مراحل:\n\n1. وضع القطع على النقاط الشاغرة\n2. تحريك القطع إلى النقاط المجاورة\n3. (مرحلة اختيارية) تحريك القطع إلى أي نقطة شاغرة عندما يتم تخفيض اللاعب إلى ثلاث قطع\n\nوضع\n\nتبدأ اللعبة بلوحة فارغة تتكون من شبكة بأربع وعشرين نقطة. يتناوب اللاعبون على وضع قطعهم على نقاط شاغرة حتى يضع كل لاعب كل القطع على اللوحة. إذا تمكن اللاعب من وضع ثلاث قطع من قطعه في خط مستقيم ، فسيكون لديه \"طاحونة\" ويمكنه إزالة إحدى قطع خصمه من اللوحة.\n\nفي بعض متغيرات القواعد ، يجب على اللاعبين إزالة أي قطع أخرى أولاً قبل إزالة قطعة من طاحونة مشكلة.\n\nفي بعض متغيرات القواعد ، قد لا يتم وضع جميع النقاط التي تمت إزالتها مرة أخرى في مرحلة الوضع.\n\nبمجرد استخدام جميع القطع ، يتناوب اللاعبون على التحرك.\n\nالتحريك\n\nللتحرك ، يقوم اللاعب بتحريك إحدى قطعه على طول خط اللوحة إلى نقطة مجاورة شاغرة. إذا لم يستطع فعل ذلك ، فسيخسر المباراة. كما هو الحال في مرحلة التسديد ، فإن اللاعب الذي يقوم بمحاذاة ثلاث من قطعه على خط لوح لديه مطحنة ويمكنه إزالة إحدى قطع خصمه. أي لاعب يتقلص إلى قطعتين وليس لديه خيار لتشكيل طواحين جديدة ، وبالتالي يخسر اللعبة. يمكن للاعب أيضًا أن يخسر بأكثر من ثلاث قطع إذا قام خصمه بحظرها بحيث لا يمكن نقلها.\n\nطيران\n\nفي بعض المتغيرات من القواعد ، بمجرد أن يتبقى للاعب ثلاث قطع فقط ، قد \"تطير\" قطعه أو \"تقفز\" أو \"تقفز\" إلى أي نقاط شاغرة ، وليس فقط النقاط المجاورة.\n';

  @override
  String get versionInfo => 'معلومات الإصدار';

  @override
  String get eula => 'اتفاقية المستخدم النهائي';

  @override
  String get license => 'رخصة';

  @override
  String get sourceCode => 'الشفرة المصدرية';

  @override
  String get appVersion => 'نسخة التطبيق';

  @override
  String get general => 'عام';

  @override
  String get advanced => 'متقدم';

  @override
  String get placing => 'وضع القطع';

  @override
  String get moving => 'تحريك';

  @override
  String get removing => 'الإزالة';

  @override
  String get gameOverCondition => 'شرط انتهاء اللعبة';

  @override
  String get aisPlayStyle => 'أسلوب لعب الذكاء الاصطناعي';

  @override
  String get passive => 'سلبي';

  @override
  String get timeout => 'انتهى الوقت';

  @override
  String get appearance => 'مظهر';

  @override
  String get drawOnHumanExperience => 'استفد من التجربة الإنسانية';

  @override
  String get considerMobility => 'مراعاة قابلية حركة القطع';

  @override
  String get pieceCount => 'عدد القطع:';

  @override
  String inHand(Object player, int count) {
    return '$player: قطع غير موضوعة: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player: قطع على اللوحة: $count';
  }

  @override
  String get boardTop => 'إزاحة اللوحة من الأعلى';

  @override
  String get notAIsTurn => 'لم يحن دور الآلة.';

  @override
  String get aiIsNotThinking => 'الذكاء الاصطناعي لا يفكر.';

  @override
  String get atEnd => 'في نهاية قائمة الحركة.';

  @override
  String get tapBackAgainToLeave => 'انقر مرة أخرى للمغادرة.';

  @override
  String get more => 'أكثر';

  @override
  String get experimental => 'هذه ميزة تجريبية.';

  @override
  String get experiments => 'التجارب';

  @override
  String get ossLicenses => 'تراخيص مفتوحة المصدر';

  @override
  String get language => 'اللغة';

  @override
  String get defaultLanguage => 'اللغة الافتراضية';

  @override
  String get mayMoveInPlacingPhase => 'يمكن أن تتحرك القطع في مرحلة الوضع';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'لا توجد مراحل وضع وتحريك مميزة ، أي يمكن للاعبين أن يقرروا في كل حركة ما إذا كانوا يريدون وضع قطعة على اللوحة أو نقل إحدى قطعهم (طالما أن لديهم قطعًا متبقية لوضعها).';

  @override
  String get drawerColor => 'لون القائمة';

  @override
  String get drawerTextColor => 'لون نص القائمة';

  @override
  String get drawerHighlightItemColor => 'لون عنصر تسليط الضوء على القائمة';

  @override
  String get mainToolbarBackgroundColor => 'لون خلفية شريط الأدوات الرئيسي';

  @override
  String get mainToolbarIconColor => 'لون رمز شريط الأدوات الرئيسي';

  @override
  String get navigationToolbarBackgroundColor => 'لون خلفية شريط أدوات التنقل';

  @override
  String get navigationToolbarIconColor => 'لون رمز شريط أدوات التنقل';

  @override
  String get autoHideToolbar => 'إخفاء شريط الأدوات تلقائيًا';

  @override
  String get toolbarLocationOnScreen => 'موقع شريط الأدوات على الشاشة';

  @override
  String get top => 'بالأعلى';

  @override
  String get bottom => 'بالأسفل';

  @override
  String get center => 'بالمنتصف';

  @override
  String get solidColor => 'لون خالص';

  @override
  String get picture => 'صورة';

  @override
  String get chooseYourPicture => 'اختر صورتك';

  @override
  String get light => 'فاتح';

  @override
  String get dark => 'داكن';

  @override
  String get themes => 'أنساق';

  @override
  String get currentTheme => 'النسق الحالي';

  @override
  String get saveTheme => 'حفظ النسق';

  @override
  String get showAnalysisGraph => 'إظهار الرسم البياني للتحليل';

  @override
  String get analysis => 'تحليل';

  @override
  String get saveGame => 'حفظ اللعبة';

  @override
  String get loadGame => 'تحميل لعبة';

  @override
  String get setupPosition => 'إعداد الوضع';

  @override
  String get showLegalMoves => 'إظهار التحركات القانونية';

  @override
  String get showLastMove => 'عرض الخطوة الأخيرة';

  @override
  String get showArrows => 'عرض الأسهم';

  @override
  String get pieces => 'القطع';

  @override
  String get showAnalysis => 'عرض التحليل';

  @override
  String get threads => 'مسارات';

  @override
  String get getInvolved => 'شارك';

  @override
  String get helpImproveTranslate => 'ساعد في تحسين الترجمة';

  @override
  String get tutorial => 'تعليمي';

  @override
  String get classicMill => 'المطحنة الكلاسيكية';

  @override
  String get mixedMill => 'مطحنة مختلطة';

  @override
  String get ceylonMill => 'مطحنة سيلان';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'قد يتم كسر المطحنة وإعادة صنعها بشكل متكرر';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'إذا كسر لاعب طاحونة لإنشاء طاحونة جديدة على الفور ، فيمكن لهذا اللاعب إعادة هذه القطعة إلى التقاطع الأصلي في حركته التالية إذا قام بعمل طاحونة جديدة.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'تُعادل اللعبة إذا كان للاعب ثلاث قطع وبعد عشر نقلات لا يزيل أي لاعب قطع الخصم';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'عندما ينخفض اللاعب إلى ثلاث قطع ، ولا يمكن لأي لاعب إزالة قطعة الخصم في غضون عشر نقلات ، تكون اللعبة بمثابة تعادل.';

  @override
  String get close => 'إغلاق';

  @override
  String get whitePiece => 'قطعة بيضاء';

  @override
  String get blackPiece => 'قطعة سوداء';

  @override
  String get emptyPoint => 'نقطة فارغة';

  @override
  String get noPoint => 'ليست نقطة';

  @override
  String get placingPhase => 'مرحلة الوضع';

  @override
  String get movingPhase => 'مرحلة الحركة';

  @override
  String get flyingPhase => 'مرحلة الطيران';

  @override
  String sideToMove(Object player) {
    return 'دور اللاعب: $player';
  }

  @override
  String lastMove(Object move) {
    return 'آخر حركة: $move';
  }

  @override
  String get selected => 'المحدد';

  @override
  String get accessibility => 'إمكانية الوصول';

  @override
  String get screenReaderSupport => 'دعم قارئ الشاشة';

  @override
  String get isDraw => 'إنه تعادل!';

  @override
  String get draw => 'تعادل';

  @override
  String get pieceHighlightColor => 'لون تسليط الضوء على قطعة';

  @override
  String get algorithm => 'الخوارزمية';

  @override
  String get endgameNMoveRule => 'قاعدة N-Move في نهاية اللعبة';

  @override
  String get endgameNMoveRule_Detail =>
      'إذا كان لدى أحد اللاعبين ثلاث قطع فقط ولم يقم أيٌّ من اللاعبين بإزالة أي قطعة خلال عدد محدد من النقلات، تنتهي اللعبة بالتعادل.';

  @override
  String get drawReasonEndgameRule50 =>
      'إذا كان لدى أحد اللاعبين ثلاث قطع فقط ولم يقم أي من اللاعبين بإزالة أي قطعة خلال عددٍ محددٍ من النقلات.';

  @override
  String get threefoldRepetitionRule => 'حكم التكرار الثلاثي';

  @override
  String get threefoldRepetitionRule_Detail =>
      'يتم تعادل اللعبة إذا حدث مركز للمرة الثالثة.';

  @override
  String get continueToMakeMove => 'مطحنة! استمر في اتخاذ خطوة.';

  @override
  String get pointStyle => 'نمط النقطة';

  @override
  String get pointWidth => 'عرض النقطة';

  @override
  String get solid => 'صلب';

  @override
  String get hollow => 'أجوف';

  @override
  String get languageName => 'العربية';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count نقلات',
      one: '1 نقلة',
      zero: '0 نقلات',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'فشل التحميل.';

  @override
  String get filename => 'اسم الملف';

  @override
  String get browse => 'تصفح…';

  @override
  String get gameFiles => 'ملفات اللعبة';

  @override
  String get gameSavedTo => 'تم حفظ اللعبة في';

  @override
  String get empty => 'فارغة';

  @override
  String get noMove => 'لا حركة.';

  @override
  String get restoredPosition => 'تمت استعادة الوضع الأولي.';

  @override
  String get clean => 'مسح';

  @override
  String get cleanedUp => 'تم المسح.';

  @override
  String get remove => 'إزالة';

  @override
  String get noPiecesCanBeRemoved => 'لا يمكن إزالة أي قطعة.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count قطع',
      many: '$count قطعة',
      few: '$count قطع',
      two: '$count قطعتان',
      one: '1 قطعة',
      zero: '0 قطعة',
    );
    return '$_temp0 تحتاج إلى إزالة.';
  }

  @override
  String placedCount(int count) {
    return 'تم وضعه ($count)';
  }

  @override
  String get placedPieceCount => 'عدد القطع الموضوعة في مرحلة الوضع.';

  @override
  String hasPlacedPieceCount(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'وضع اللاعب الحالي $count قطعة',
      one: 'وضع اللاعب الحالي قطعة واحدة',
      zero: 'لم يضع اللاعب الحالي أي قطعة',
    );
    return '$_temp0';
  }

  @override
  String get notPlacingPhase => 'ليست مرحلة الوضع، لا يمكن تغييرها.';

  @override
  String get paste => 'لصق';

  @override
  String get pasteDone => 'تم اللصق.';

  @override
  String get cannotPaste => 'لا يمكن اللصق.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'إظهار القطع غير الموضوعة والمزالة';

  @override
  String get fullScreen => 'شاشة كاملة';

  @override
  String get reopenToTakeEffect =>
      'اخرج من التطبيق وأعد فتحه لتصبح الإعدادات سارية المفعول.';

  @override
  String get forest => 'غابة';

  @override
  String get desktopImage => 'صورة سطح المكتب';

  @override
  String get invalidPosition => 'وضع غير صالح.';

  @override
  String get shareGIF => 'مشاركة صورة متحركة';

  @override
  String get pixelRatio => 'نسبة البكسل';

  @override
  String get duration => 'المدة';

  @override
  String get gameScreenRecorder => 'مسجل شاشة اللعبة';

  @override
  String get previous => 'السابق';

  @override
  String get next => 'التالي';

  @override
  String get skip => 'تخطي';

  @override
  String get gotIt => 'مفهوم';

  @override
  String get youCanModifyRules =>
      'يمكنك تعديل قواعد اللعبة في إعدادات القواعد.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'يمكنك استخدام عجلة الماوس لتغيير القيمة في المنتقي.';

  @override
  String get noTimeLimitForThinking =>
      'ضبط وقت التفكير بالذكاء الاصطناعي على ٠ يعني أنه لا يوجد حد زمني للتفكير.';

  @override
  String get whatIsMtdf =>
      'MTD (f) هو شكل معدل من خوارزمية بحث alpha-beta التي تهدف إلى تحسين الكفاءة عن طريق إعادة استخدام نتائج البحث الوسيطة واستخدام تخمين أولي جيد لتضييق مساحة البحث.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'يرجى الانتباه إلى أن تعديل وقت تفكير الذكاء الاصطناعي قد لا يكون دقيقًا تمامًا. قد يكون وقت التفكير الفعلي أقصر عندما يتم تعيين مستوى الصعوبة على قيمة أقل وقد يكون أطول عندما يكون الذكاء الاصطناعي في منتصف التفكير عندما ينفد الوقت.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'إذا قمت بتعيين مستوى الصعوبة عالياً ولكنك لم تقم بزيادة وقت التفكير في الذكاء الاصطناعي ، فقد يكون مستوى الصعوبة الفعلي مقيدًا بقيمة أقل بسبب ضيق وقت التفكير. قد تختلف القيمة الفعلية بناءً على أداء الجهاز.';

  @override
  String get whatIsPvs =>
      'PVS (بحث التباين الرئيسي) عبارة عن خوارزمية بحث للعثور على أفضل حركة في موضع معين. إنه تحسين لخوارزمية ألفا بيتا ويستخدم عمليات بحث نافذة خالية أو صفرية لتأكيد أن الخطوة أسوأ أو ليست أسوأ من النتيجة الآمنة بالفعل من الاختلاف الرئيسي. يركز PVS على الحركات الواعدة ويتجنب عمليات البحث غير الضرورية للفروع دون المستوى الأمثل ، مما يساعد على تحسين كفاءة البحث.';

  @override
  String get whatIsAlphaBeta =>
      'خوارزمية ألفا-بيتا هي خوارزمية بحث تُستخدم لإيجاد الحركة المثلى في الألعاب. تعتمد على مبدأ minimax وتستخدم قيمتين، ألفا و بيتا، لتقليم شجرة البحث، مما يقلل بشكل كبير من عدد العُقد التي تحتاج إلى تقييم ويزيد من كفاءة البحث.\nألفا: تمثل الحد الأدنى للنتيجة المؤكدة التي يمكن للطرف الذي يسعى لتعظيم النتيجة تحقيقها حتى الآن خلال البحث.\nبيتا: تمثل الحد الأعلى للنتيجة المؤكدة التي يمكن للطرف الذي يسعى لتقليل النتيجة تحقيقها حتى الآن خلال البحث.\nتساعد هذه الخوارزمية الكمبيوتر أو أي لاعب يستخدمها على اتخاذ قرارات لعب أكثر ذكاءً وفعالية من خلال استكشاف عدد أقل من الاحتمالات الممكنة.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'وفقًا للتجربة البشرية ، إذا حاولت الفوز ، فسوف تخسر. بدلاً من ذلك ، استهدف أن يكون التعادل هدفك وتجنب خسارة اللعبة. راقب خصمك وجذبه برفق إلى وضع قد يخطئ فيه. عندما يظهرون ضعفًا ، اغتنم الفرصة وادفع برفق لتحقيق الفوز. بهذه الطريقة ، يمكنك الفوز باللعبة.';

  @override
  String get firstMoveDetail =>
      'في هذه اللعبة، من الأسهل على اللاعب الثاني الفوز مقارنةً باللاعب الأول.';

  @override
  String get passiveDetail =>
      'سيؤدي تمكين الخيار السلبي إلى استرخاء الذكاء الاصطناعي عندما يكون لديه ميزة في المركز ، بدلاً من محاولة الفوز بقوة في أسرع وقت ممكن.';

  @override
  String get moveRandomlyDetail =>
      'يؤدي تمكين هذا الخيار إلى زيادة عشوائية اللعبة ومتعتها بينما يمكن أن يساعد تعطيلها في دراسة طرق التغلب على الذكاء الاصطناعي.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'إذا أخذ الذكاء الاصطناعي في الاعتبار إمكانية تحريك قطعه ، فلن يهدف فقط إلى التقاط قطع الخصم بأسرع ما يمكن ، ولكن أيضًا يفكر في منع تحركات الخصم ومنعهم من فعل الشيء نفسه.';

  @override
  String get whenBoardIsFull => 'عندما تكون اللوحة ممتلئة';

  @override
  String get whenBoardIsFull_Detail =>
      'في نهاية مرحلة الوضع ، قبل أن تبدأ مرحلة الحركة ، يتبع الإجراء إذا كانت اللوحة ممتلئة بالقطع.';

  @override
  String get sideToMoveRemovePiece =>
      'اللاعب الذي يتحرك أولاً في مرحلة الحركة يزيل إحدى قطع الخصم.';

  @override
  String get agreeToDraw => 'يتفق الطرفان على التعادل.';

  @override
  String get takeOpponentsPiece => 'خذ إحدى قطع خصمك.';

  @override
  String get firstPlayerLose => 'اللاعب الأول يخسر اللعبة.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'يقوم اللاعبان الأول والثاني بإزالة إحدى قطع الخصم.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'يقوم اللاعبان الثاني والأول بإزالة إحدى قطع الخصم.';

  @override
  String get enteredFlyingPhase =>
      'دخلت الآن مرحلة الطيران ، يمكن لقطع الخصم القفز إلى أي نقطة فارغة على اللوحة. يمكنك إيقاف تشغيل قاعدة الطيران في \"إعدادات القاعدة\".';

  @override
  String get whenStalemate => 'عند الجمود';

  @override
  String get whenStalemate_Detail =>
      'ما هو العمل الذي يتبع عندما لا يمكن تحريك أي قطعة؟';

  @override
  String get endWithStalemateLoss =>
      'إنهاء بخسارة بسبب الجمود للجانب الذي تم حظره.';

  @override
  String get changeSideToMove => 'تغيير الطرف الذي يتحرك.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'قم بإزالة إحدى قطع الخصم وقم بالحركة التالية.';

  @override
  String get endWithStalemateDraw => 'الانتهاء بتعادل بسبب الجمود.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'قم بإزالة إحدى قطع الخصم وقم بتغيير الجانب المراد تحريكه.';

  @override
  String get aiResponseDelayTime => 'وقت تأخير استجابة الذكاء الاصطناعي';

  @override
  String get aiIsDelaying =>
      'يمر الذكاء الاصطناعي حاليًا بمرحلة استجابة متأخرة. يرجى الانتظار لبعض الوقت قبل المتابعة.';

  @override
  String get tipCanNotRemoveNonadjacent => 'لا يمكنك إزالة قطعة غير مجاورة.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'في حالة الجمود، يمكن إزالة قطع الخصم المجاورة لقطعك، بغض النظر عن تشكيل الطاحونة.';

  @override
  String get whatIsMcts =>
      'MCTS هي خوارزمية صديقة للمبتدئين تتخذ القرارات من خلال استكشاف وتقييم الحركات المختلفة من خلال عمليات المحاكاة.';

  @override
  String get goldenJade => 'اليشم الذهبي';

  @override
  String get forestWood => 'خشب الغابة';

  @override
  String get darkMystery => 'لغز غامق';

  @override
  String get midnightBlue => 'منتصف الليل الأزرق';

  @override
  String get greenForest => 'غابة خضراء';

  @override
  String get greenMeadow => 'المرج الأخضر';

  @override
  String get stonyPath => 'ممر حجري';

  @override
  String get pastelPink => 'الباستيل الوردي';

  @override
  String get turquoiseSea => 'بحر الفيروز';

  @override
  String get violetDream => 'الحلم البنفسجي';

  @override
  String get mintChocolate => 'شوكولاتة النعناع';

  @override
  String get skyBlue => 'السماء الزرقاء';

  @override
  String get playfulGarden => 'حديقة مرحة';

  @override
  String get whatIsRetrogradeAnalysis =>
      'تستخدم خوارزمية التحليل الرجعي تحليلًا رجعيًا متعدد القيم لبناء قاعدة بيانات نهاية اللعبة من مواقع بدء مختلفة ، ثم تطبق قاعدة البيانات هذه لتحسين طريقة اللعب. يندرج هذا النهج ضمن فئة الحلول فائقة القوة.';

  @override
  String get viewAlgorithmGuide =>
      'هل ترغب في عرض دليل المستخدم لهذه الخوارزمية؟';

  @override
  String get showPositionalAdvantageIndicator => 'أظهر مؤشر الميزة الموضعية';

  @override
  String get usePerfectDatabase => 'استخدام قاعدة بيانات مثالية';

  @override
  String get perfectDatabaseDescription =>
      'قم بتمكين هذا الخيار لاستخدام قاعدة بيانات ألعاب خالية من العيوب تم إنشاؤها من خلال خوارزميات متطورة. تدمج هذه الميزة استراتيجيات الافتتاح ونهاية اللعبة لاقتراح التحركات المثالية. هذا هو الخيار المفضل للاعبين الذين يبحثون عن أعلى مستوى من الدقة في اللعب. تم إنشاء قاعدة البيانات من خلال تقنيات حسابية دقيقة، وهي مصممة لتقديم حلول ألعاب شبه مثالية.\n\nملحوظة: إذا فشل الذكاء الاصطناعي في الوصول إلى قاعدة البيانات، فسوف يلجأ إلى الخوارزميات التقليدية لاتخاذ قرارات اللعب. عندما تكون قاعدة البيانات متاحة، يصبح \"مستوى الصعوبة\" لا يمكن التغلب عليه فعليًا، ويشهد \"وقت تفكير الذكاء الاصطناعي\" انخفاضًا كبيرًا. سيتم تجاوز العديد من الإعدادات ضمن خيارات \"AI\'s play style\"، حيث أن نتائج قاعدة البيانات لها الأولوية القصوى.\n\nللحصول على إرشادات حول كيفية تحقيق أقصى استفادة من قاعدة البيانات الخالية من العيوب، انقر هنا.';

  @override
  String get backgroundImage => 'صورة الخلفية';

  @override
  String get whatIsRandom =>
      'عندما لا يتم تفعيل خيار \"استخدام قاعدة البيانات المثالية\"، يؤدي إعداد \"العشوائية\" إلى قيام الذكاء الاصطناعي بتحريك القطع بشكل عشوائي دون استخدام أي خوارزميات لاختيار الحركات. هذا يؤدي عادةً إلى ضعف كبير في أسلوب اللعب. على النقيض من ذلك، عند تفعيل خيار \"استخدام قاعدة البيانات المثالية\"، يعتمد الذكاء الاصطناعي حصريًا على \"قاعدة البيانات المثالية\" لاتخاذ القرارات، بدلاً من دمجها مع خوارزميات الذكاء الاصطناعي التقليدية. في هذا الوضع، تعتمد حركات الذكاء الاصطناعي بالكامل على محتوى قاعدة البيانات، متجنبة الاعتماد على الحسابات الفورية أو خوارزميات البحث.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'قم بإزالة قطع الخصم من يده؛ ثم حان دور الخصم للوضع.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'عند تشكيل الطواحين أثناء مرحلة الوضع';

  @override
  String get removeOpponentsPieceFromBoard => 'قم بإزالة قطع الخصم من اللوحة.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'قم بإزالة قطع الخصم من اللوحة؛ ثم حان دور الخصم للوضع.';

  @override
  String get opponentRemovesOwnPiece => 'يزيل الخصم قطعه الخاصة من اللوحة.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'بدلاً من اتخاذك للإجراء، يختار الخصم ويزيل قطعه الخاصة من اللوحة، مما يؤدي فعليًا إلى اتخاذ إجراء يضر بنفسه.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'قم بإزالة قطع الخصم من يده؛ ثم حان دورك للتحرك.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'قم بإزالة القطع من يد الخصم. إذا كان يجب إزالة قطع متعددة وفقًا لإعداد الإزالة المتعددة ولم يتبق لدى الخصم أي قطع في يده، فاستمر في إزالة قطع الخصم من اللوحة. ثم حان دورك للتحرك. إذا استمررت في تشكيل الطواحين، فيمكنك الاستمرار في إزالة قطع الخصم.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'قم بإزالة القطع من يد الخصم. إذا كان يجب إزالة قطع متعددة وفقًا لإعداد الإزالة المتعددة ولم يتبق لدى الخصم أي قطع في يده، فاستمر في إزالة قطع الخصم من اللوحة. ثم حان دور الخصم للتحرك.';

  @override
  String get markAndDelayRemovingPieces => 'ضع علامة على القطع وتأخير إزالتها.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'أثناء مرحلة الوضع، يتم وضع علامة على القطع المراد إزالتها، وبالنسبة لكلا اللاعبين، لا يمكن وضع قطع جديدة على هذه النقاط. عند الدخول في مرحلة التحرك، يتم إزالة هذه القطع المعلمة معًا، ويمكن للاعبين بعد ذلك تحريك قطعهم إلى هذه النقاط الفارغة الآن.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'الإجراءات التي يمكن اتخاذها عند تشكيل المطاحن خلال مرحلة الوضع.';

  @override
  String get marked => 'مُعلَم';

  @override
  String get menu => 'القائمة';

  @override
  String get monochrome => 'أحادي اللون';

  @override
  String get youCanEnableScreenReaderSupport =>
      'يمكنك تفعيل دعم قارئ الشاشة في إعدادات الوصول في الإعدادات العامة.';

  @override
  String get showNumbersOnPieces => 'عرض الأرقام على القطع';

  @override
  String get saveImage => 'حفظ الصورة';

  @override
  String get isAnalysisToolbarShown => 'إظهار شريط أدوات التحليل';

  @override
  String get analysisToolbarBackgroundColor => 'لون خلفية شريط أدوات التحليل';

  @override
  String get analysisToolbarIconColor => 'لون أيقونة شريط أدوات التحليل';

  @override
  String get transformed => 'تم التحويل.';

  @override
  String get cannotTransform => 'لا يمكن التحويل.';

  @override
  String get rotate => 'دوران';

  @override
  String get horizontalFlip => 'أفقي';

  @override
  String get verticalFlip => 'عمودي';

  @override
  String get innerOuterFlip => 'IO فليب';

  @override
  String get transparentCanvas => 'قماش شفاف';

  @override
  String get restrictRepeatedMillsFormation => 'تقييد تشكيل الطواحين المتكررة';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'لا يمكن للقطعة التي تحركت من طاحونة إلى أخرى أن تعود فورًا إلى النقطة الأصلية في الدور التالي لتكوين طاحونة مرة أخرى. يتطلب الأمر حركة مختلفة أولاً.';

  @override
  String get oneTimeUseMill => 'مطحنة للاستخدام مرة واحدة';

  @override
  String get oneTimeUseMill_Detail =>
      'يمكن لكل مطحنة إزالة قطعة واحدة فقط من خصمك. يمكنك إعادة تشكيلها مرة أخرى، ولكن لا يمكن استخدامها لعمليات إزالة إضافية.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'القواعد الحالية التي قمت بتعيينها ليس لها قاعدة بيانات مثالية مقابلة. لمزيد من المعلومات حول قاعدة البيانات المثالية، يرجى النقر هنا.';

  @override
  String get focusOnBlockingPaths => 'ركز على مسارات الحظر';

  @override
  String get focusOnBlockingPaths_Detail =>
      'خلال مراحل محددة من اللعبة، قدِّم الأولوية لإعاقة حركة الخصم على تشكيل الطواحين. بدلاً من التركيز على إزالة القطع عبر إكمال الطواحين، تهدف الذكاء الاصطناعي إلى محاصرة الخصم خلال هذه المراحل، مما يجعله غير قادر على التحرك وضمان الفوز من خلال الإنهاك بدلاً من اللعب العدواني. هذه الاستراتيجية المحددة بالمرحلة لا تعيق طواحين الخصم بنشاط.';

  @override
  String get pieceImage => 'صورة القطعة';

  @override
  String get importColorSettings => 'استيراد إعدادات الألوان';

  @override
  String get exportColorSettings => 'تصدير إعدادات الألوان';

  @override
  String get import => 'استيراد';

  @override
  String get export => 'تصدير';

  @override
  String get pleaseCopyJsonToClipboard =>
      'يرجى نسخ إعدادات تنسيق JSON إلى الحافظة أولاً.';

  @override
  String get copiedToClipboard => 'تم النسخ إلى الحافظة.';

  @override
  String get imported => 'تم الاستيراد.';

  @override
  String get boardImage => 'صورة اللوحة';

  @override
  String get autumnLeaves => 'أوراق الخريف';

  @override
  String get legendaryLand => 'الأرض الأسطورية';

  @override
  String get vignetteEffect => 'تأثير التظليل';

  @override
  String get promptMakeToolbarTransparent =>
      'هل تود جعل شريط الأدوات شفافًا بالكامل عندما يتم تعيين صورة خلفية للوحة؟';

  @override
  String get vibration => 'تمكين الاهتزاز في اللعبة';

  @override
  String get soundTheme => 'سمة الصوت';

  @override
  String get ball => 'كرة';

  @override
  String get liquid => 'سائل';

  @override
  String get wood => 'خشب';

  @override
  String get placeEffectAnimation => 'تأثير تحريك وضع القطعة';

  @override
  String get removeEffectAnimation => 'تأثير تحريك إزالة القطعة';

  @override
  String get isToolbarAtBottom => 'عرض شريط الأدوات في الأسفل';

  @override
  String get boardCornerRadius => 'نصف قُطر زوايا اللوح';

  @override
  String get useOpeningBook => 'استخدم كتاب الافتتاح';

  @override
  String get currentRule => 'الحالي';

  @override
  String get nineMensMorris => 'أم التسع';

  @override
  String get twelveMensMorris => 'أم الاثني عشر';

  @override
  String get morabaraba => 'مورابارابا';

  @override
  String get dooz => 'دوز';

  @override
  String get chamGonu => 'تشامغونو';

  @override
  String get zhiQi => 'جي تشي';

  @override
  String get chengSanQi => 'تشينغ سان تشي';

  @override
  String get mulMulan => 'مول-مولان';

  @override
  String get nerenchi => 'نيرينشي';

  @override
  String get ruleSet => 'مجموعة القواعد';

  @override
  String get laskerMorris => 'لاسكر موريس';

  @override
  String get oneTimeMill => 'مطحنة المرة الواحدة';

  @override
  String get daSanQi => 'دا سان تشي';

  @override
  String get useOpeningBook_Detail =>
      'دع الذكاء الاصطناعي يستخدم الافتتاحيات التي يستخدمها اللاعبون المحترفون في بداية اللعبة. ملاحظة: هذه الخاصية متاحة حاليًا لمجموعات قواعد محددة فقط.';

  @override
  String get showAdvantageGraph => 'إظهار الرسم البياني للأفضلية';

  @override
  String get advantageGraphHint =>
      'سيُرسَم مخططُ الأفضلية فقط بعد أن يُجري الذكاءُ الاصطناعيُّ حركةً، ولن يُرسم عندما يُجري اللاعبُ البشريُّ حركةً.';

  @override
  String get removalBasedOnMillCounts =>
      'ممنوع الإزالة حتى يتم الانتهاء من وضع جميع القطع، ثم يقوم اللاعبون بإزالة القطع وفقًا لعدد الطواحين المُشكَّلة.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'ممنوع الإزالة حتى يتم الانتهاء من وضع جميع القطع، ثم يقوم اللاعبون بإزالة القطع وفقًا لعدد الطواحين المُشكَّلة: إذا تساوى العدد، يزيل كلاهما العدد نفسه؛ وإذا كان أحدهما يمتلك عددًا أكبر من الطواحين، فإنه يزيل قطعة إضافية واحدة مع الحفاظ على فارق قطعة واحدة. إذا قام أحد اللاعبين فقط بتشكيل طواحين، فإنه يزيل قطعتين بينما يزيل الآخر واحدة. أما إذا لم يشكل أيٌّ منهما طواحين، فيزيل كلٌّ منهما قطعة واحدة من قطعه الخاصة.';

  @override
  String get elfilja => 'الفلجة';

  @override
  String get tipSelectOwnPiece => 'اختر إحدى قطعك.';

  @override
  String get notYourTurn => 'ليس دورك.';

  @override
  String get annotationToolbarBackgroundColor =>
      'لون خلفية شريط أدوات التعليقات';

  @override
  String get annotationToolbarIconColor => 'لون أيقونات شريط أدوات التعليقات';

  @override
  String get isAnnotationToolbarShown => 'عرض شريط أدوات التعليقات';

  @override
  String get enterAnnotationMode => 'دخول وضع التعليق';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'هل أنت متأكد من رغبتك في مسح جميع التعليقات؟';

  @override
  String get llmPromptCopiedToClipboard => 'تم نسخ مطالبة LLM إلى الحافظة.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'تم رفض الاتصال، ربما يكون الخادم متوقفاً.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'تم الاكتشاف بنجاح، في انتظار الاتصال...';

  @override
  String get noLanConnection => 'لا يوجد اتصال بالشبكة المحلية';

  @override
  String get takeScreenshot => 'التقاط لقطة شاشة';

  @override
  String get disconnectedFromOpponent => 'تم قطع الاتصال من الخصم.';

  @override
  String get takeBackRequest => 'طلب التراجع';

  @override
  String get nothingToShow => 'لا يوجد ما يمكن عرضه.';

  @override
  String get stopHosting => 'إيقاف الاستضافة';

  @override
  String get connectionResetByPeer => 'تم إعادة تعيين الاتصال من الطرف الآخر.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'انقطع الاتصال بسبب انتهاء مهلة نبض القلب. يرجى إعادة الاتصال.';

  @override
  String get startHosting => 'بدء الاستضافة';

  @override
  String get restartRequestRejected => 'تم رفض طلب إعادة التشغيل.';

  @override
  String get notConnectedToLanOpponent => 'غير متصل بالخصم على الشبكة المحلية.';

  @override
  String get llmPrompt => 'تعليمات LLM';

  @override
  String get gameRestarted => 'تم إعادة تشغيل اللعبة.';

  @override
  String get takeBackRejected => 'تم رفض طلب التراجع.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'هل أنت متأكد أنك تريد الاستسلام في هذه اللعبة؟';

  @override
  String get opponentResignedYouWin => 'استسلم الخصم. أنت الفائز!';

  @override
  String get clearAllAnnotations => 'مسح جميع التعليقات';

  @override
  String get connectedWaitingForOpponentSMove =>
      'متصل، في انتظار حركة الخصم...';

  @override
  String get networkStatusDisconnected => 'حالة الشبكة: غير متصل';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'تم إرسال طلب التراجع إلى الخصم.';

  @override
  String get theOpponentMayHaveLeftTheGame => 'قد يكون الخصم قد غادر اللعبة';

  @override
  String get connectedToHostSuccessfully => 'تم الاتصال بالمضيف بنجاح.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'انقطع الاتصال: انتهاء مهلة نبض القلب';

  @override
  String get noHostDiscovered => 'لم يتم اكتشاف أي خادم.';

  @override
  String get confirmResignation => 'تأكيد الاستسلام';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'تم بدء استضافة اللعبة، في انتظار انضمام اللاعبين...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'انتهت مهلة الاتصال، الشبكة غير مستقرة.';

  @override
  String get noLlmPromptAvailable => 'لا توجد تعليمات LLM متاحة.';

  @override
  String get youResignedGameOver => 'لقد استسلمت. انتهت اللعبة.';

  @override
  String get serverIp => 'عنوان IP للخادم';

  @override
  String get confirmClear => 'تأكيد المسح';

  @override
  String get opponentSTurn => 'دور الخصم.';

  @override
  String get waitingAClientConnection => 'في انتظار اتصال العميل...';

  @override
  String get takeBackRequestWasRejectedOrFailed => 'تم رفض طلب التراجع أو فشل.';

  @override
  String get addText => 'إضافة نص';

  @override
  String get exitAnnotationMode => 'الخروج من وضع التعليق';

  @override
  String get typeYourAnnotation => 'اكتب تعليقك';

  @override
  String get attemptingToReconnect => 'محاولة إعادة الاتصال...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'تم إرسال طلب إعادة التشغيل. في انتظار رد الخصم...';

  @override
  String get serverIsStopped => 'الخادم متوقف.';

  @override
  String get restartRequest => 'طلب إعادة التشغيل';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'لا يمكنك طلب التراجع عندما لا يكون دورك.';

  @override
  String get takeBackAccepted => 'تم قبول طلب التراجع.';

  @override
  String get localNetworkSettings => 'إعدادات الشبكة المحلية';

  @override
  String get reconnectedSuccessfully => 'تم إعادة الاتصال بنجاح!';

  @override
  String get failedToSaveImageToGallery => 'فشل في حفظ الصورة في المعرض.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'طلب الخصم إعادة تشغيل اللعبة. هل تقبل؟';

  @override
  String get yourTurn => 'دورك.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'غير قادر على إعادة الاتصال، يرجى إعادة تشغيل اللعبة.';

  @override
  String get host => 'المضيف';

  @override
  String get join => 'انضم';

  @override
  String get port => 'المنفذ';

  @override
  String get invalidIpAddress => 'عنوان IP غير صالح.';

  @override
  String get invalidPort => 'المنفذ غير صالح.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'جارٍ الاتصال: المحاولة $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'فشل الاتصال: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'فشل في بدء الاستضافة: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'تم اكتشاف المضيف: $ip:$port';
  }

  @override
  String get stop => 'إيقاف';

  @override
  String get discover => 'اكتشاف';

  @override
  String get connect => 'اتصل';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'تم الاتصال بالعميل: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'جارٍ الاكتشاف: $seconds ثوانٍ';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'إعادة الاتصال ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'متصل';

  @override
  String get delete => 'حذف';

  @override
  String get ancientEgypt => 'عبق الفراعنة';

  @override
  String get gothicIce => 'ثلوج الأطلس';

  @override
  String get riceField => 'حقول النيل';

  @override
  String get chinesePorcelain => 'البورسلان الصيني';

  @override
  String get desertDusk => 'غسق الصحراء';

  @override
  String get precisionCraft => 'إتقان الصنعة';

  @override
  String get folkEmbroidery => 'التطريز التراثي';

  @override
  String get carpathianHeritage => 'تراث الحجاز';

  @override
  String get imperialGrandeur => 'مجد الخلافة';

  @override
  String get bohemianCrystal => 'زجاج دمشق';

  @override
  String get savannaSunrise => 'شروق الواحة';

  @override
  String get harmonyBalance => 'تناغم وتوازن';

  @override
  String get cinnamonSpice => 'أريج القرفة';

  @override
  String get anatolianMosaic => 'الفسيفساء الأندلسية';

  @override
  String get carnivalSpirit => 'روح المهرجان';

  @override
  String get custom => 'مخصص';

  @override
  String get spiceMarket => 'سوق البهارات';

  @override
  String get swipeToRevealTheDrawer => 'اسحب للكشف عن الدرج';

  @override
  String get showGameInfoOnScreenshots => 'عرض معلومات اللعبة على لقطات الشاشة';

  @override
  String get humanMoveTime => 'حد الوقت للحركة البشرية';

  @override
  String get noTimeLimitForHumanMoves => 'لا يوجد حد زمني للحركات البشرية';

  @override
  String get timeoutLoseWillBeApplied => 'سيتم تطبيق خسارة المهلة للاعب البشري';

  @override
  String get identifyingBoard => 'جارٍ التعرف على لوحة اللعب...';

  @override
  String get youCanEnterAnyModelName => 'يمكنك إدخال أي اسم نموذج.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'تم تطبيق وضعية لوحة اللعب. تم نسخ FEN إلى الحافظة.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'اقتراح: حاول التقاط صورة أوضح للوحة اللعب.';

  @override
  String get llmPromptTemplate => 'قالب تعليمات LLM';

  @override
  String get noValidBoardDetected => 'لم يتم الكشف عن لوحة لعب صالحة.';

  @override
  String get selectingImageFromAlbum => 'جارٍ اختيار صورة من الألبوم...';

  @override
  String get configurePromptTemplate => 'تكوين قالب الموجه';

  @override
  String get editPromptTemplateForLlmAnalysis => 'تحرير قالب الموجه لتحليل LLM';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'فشل في إنشاء FEN من لوحة اللعب المعترف بها.';

  @override
  String get outputInCurrentLanguage => 'الإخراج باللغة الحالية';

  @override
  String get commonBaseUrls => 'عناوين Base URL الشائعة';

  @override
  String get viewCommonModels => 'عرض النماذج الشائعة';

  @override
  String get recognitionParametersUpdated => 'تم تحديث معلمات التعرف.';

  @override
  String get whiteSMove => 'دور الأبيض';

  @override
  String get resetToDefaults => 'إعادة الضبط إلى القيم الافتراضية';

  @override
  String get photoShoot => 'التقاط صورة';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'فشل في تطبيق وضعية لوحة اللعب المعترف بها.';

  @override
  String get llmPromptContent => 'محتوى موجه LLM';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'لم يتم تكوين LLM. يُرجى التحقق من الإعدادات.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'تعيين المزود، النموذج، API Key وBase URL';

  @override
  String get llmConfiguration => 'تكوين LLM';

  @override
  String get configureLlmProvider => 'تكوين مزود LLM';

  @override
  String get llmPromptTemplateHeader => 'رأس قالب موجه LLM';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'لم يتم التعرف على أي قطع في الصورة. يرجى المحاولة مرة أخرى.';

  @override
  String get recognizeBoardFromImage => 'التعرف على لوحة اللعب من الصورة';

  @override
  String get viewTips => 'عرض النصائح';

  @override
  String get applyToBoard => 'تطبيق على لوحة اللعب';

  @override
  String get adjustBoardArea => 'ضبط منطقة لوحة اللعب';

  @override
  String get viewCommonUrls => 'عرض عناوين URL الشائعة';

  @override
  String get colorAnalysisFailed => 'فشل تحليل الألوان!';

  @override
  String get analyzingGameBoardImage => 'جاري تحليل صورة لوحة اللعب...';

  @override
  String get selectFromAlbum => 'اختر من الألبوم';

  @override
  String get noBoardPointDetected => 'لم يتم الكشف عن أي نقطة على لوحة اللعب!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'إذا تُرك فارغًا، سيُستخدم القالب الافتراضي';

  @override
  String get llmConfig => 'إعدادات LLM';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'هل أنت متأكد من رغبتك في إعادة قوالب التعليمات إلى القيم الافتراضية؟';

  @override
  String get llmPromptTemplateFooter => 'تذييل قالب موجه LLM';

  @override
  String get loadingResponse => 'جارٍ تحميل الاستجابة...';

  @override
  String get applyThisResultToBoard => 'تطبيق هذه النتيجة على لوحة اللعب';

  @override
  String get takingPicture => 'جارٍ التقاط صورة...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'يرجى اختيار صورة لوحة اللعب للتعرف عليها';

  @override
  String get identificationResults => 'نتائج التعرف';

  @override
  String get analyzeTheMovesAndProvideInsights => 'حلل الحركات وقدّم رؤى.';

  @override
  String get getApiKey => 'الحصول على API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'لم تكتمل عملية التعرف بالكامل.';

  @override
  String get boardRecognitionResult => 'نتيجة التعرف على لوحة اللعب';

  @override
  String get askLlm => 'اسأل LLM';

  @override
  String get boardDetectionFailed => 'فشل اكتشاف لوحة اللعب!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'لم يتم الكشف عن أي نقطة على لوحة اللعب، لا يمكن تحديد القطعة!';

  @override
  String get copyFen => 'نسخ FEN';

  @override
  String get commonlyUsedModels => 'النماذج المستخدمة بشكل شائع';

  @override
  String get apiKeyOptional => 'API Key (اختياري)';

  @override
  String get noImageSelected => 'لم يتم اختيار صورة';

  @override
  String get blackSMove => 'دور الأسود';

  @override
  String get llm => 'نموذج لغوي ضخم';

  @override
  String get llmProvider => 'المزوّد';

  @override
  String get baseUrl => 'عنوان URL الأساسي';

  @override
  String get model => 'النموذج';

  @override
  String get temperature => 'درجة الحرارة';

  @override
  String get llmCommandReceivedProcessing =>
      'تم استلام الأمر! يجري معالجة الذكاء الاصطناعي...';

  @override
  String get llmDeepThinkingWait => 'تفكير عميق جارٍ، يرجى الانتظار...';

  @override
  String get llmPresentingSoon => 'سيتم العرض قريبًا...';

  @override
  String get recognitionParameters => 'معلمات التعرّف';

  @override
  String get adjustParamsDesc => 'اضبط المعلمات لتحسين دقة التعرّف';

  @override
  String get saveParameters => 'حفظ المعلمات';

  @override
  String unableToStartImageRecognition(String error) {
    return 'تعذّر بدء التعرّف على الصورة: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'فشل التعرّف على الصورة: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'تم تطبيق الوضع مع $whiteCount قطعة بيضاء و$blackCount قطعة سوداء';
  }

  @override
  String get fenCopiedToClipboard => '(تم نسخ FEN إلى الحافظة)';

  @override
  String recognitionFailed(String error) {
    return 'فشل التعرّف: $error';
  }

  @override
  String get myRating => 'تقييمي';

  @override
  String get gamesPlayed => 'الألعاب التي تم لعبها';

  @override
  String get wins => 'انتصارات';

  @override
  String get losses => 'خسائر';

  @override
  String get draws => 'تعادلات';

  @override
  String get lastUpdated => 'آخر تحديث';

  @override
  String get format => 'التنسيق:';

  @override
  String get resetStatistics => 'إعادة تعيين الإحصائيات';

  @override
  String get drawRate => 'معدل التعادل';

  @override
  String get lossRate => 'معدل الخسارة';

  @override
  String get aiStatistics => 'إحصائيات الذكاء الاصطناعي';

  @override
  String get enableStatistics => 'تمكين الإحصائيات';

  @override
  String get enableStatistics_Detail =>
      'عند التمكين، سيتم تسجيل نتائج اللعبة في الإحصائيات. ومع ذلك، لن يتم تسجيل الألعاب التي تتضمن عمليات تراجع. عند التعطيل، يتم إيقاف جمع الإحصائيات مؤقتًا.';

  @override
  String get thisWillResetAllGameStatistics =>
      'سيؤدي هذا إلى إعادة تعيين جميع إحصائيات اللعبة. لا يمكن التراجع عن هذا الإجراء.';

  @override
  String get boardInnerRingSize => 'حجم الحلقة الداخلية للوحة';

  @override
  String get boardShadowEnabled => 'ظل اللوحة';

  @override
  String get trapAwareness => 'الوعي بالفخاخ';

  @override
  String get trapAwarenessDescription =>
      'تسليط الضوء على نقلات الفخ بدوائر وسهام عريضة أثناء التحليل.';

  @override
  String trapExists(String trapMoves) {
    return 'يوجد فخ. نقلات الفخ: $trapMoves';
  }

  @override
  String get custodianCapture => 'الالتقاط المرافئ';

  @override
  String get custodianCaptureDescription =>
      'أرفق إحدى قطع خصمك بين اثنين منك في خط مستقيم لالتقاطها.';

  @override
  String get custodianCaptureEnable => 'السماح بالقبض على الإحالة';

  @override
  String get interventionCapture => 'التقاط التدخل';

  @override
  String get interventionCaptureDescription =>
      'انتقل إلى النقطة الفارغة بين قطعتين من خصمك لالتقاطهما على حد سواء.';

  @override
  String get interventionCaptureEnable => 'السماح بالتقاط التدخل';

  @override
  String get leapCapture => 'القفز';

  @override
  String get leapCaptureDescription =>
      'التقاط عن طريق القفز فوق قطعة الخصم المجاورة في النقطة الفارغة إلى ما بعد.';

  @override
  String get leapCaptureEnable => 'السماح بالتقاط القفز';

  @override
  String get captureApplicableLines => 'الخطوط المعمول بها';

  @override
  String get captureSquareEdges => 'على طول حواف المربع';

  @override
  String get captureCrossLines => 'على طول الخطوط المتعامدة التي تعبر المربع';

  @override
  String get captureDiagonalLines => 'على طول الخطوط القطرية التي تعبر المربع';

  @override
  String get captureExecutionPhases => 'مراحل التنفيذ';

  @override
  String get capturePiecesCondition =>
      'توافر خلال المرحلة المتحركة بناءً على القطع المتبقية';

  @override
  String get capturePiecesConditionUnlimited => 'لا تقييد';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'متاح عندما يكون لديك ثلاث قطع أو أقل';
}
