// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Amharic (`am`).
class SAm extends S {
  SAm([String locale = 'am']) : super(locale);

  @override
  String get appName => 'ሚል';

  @override
  String get welcome => 'እንኳን ደህና መጡ';

  @override
  String get yes => 'አዎ';

  @override
  String get no => 'አይ';

  @override
  String get game => 'ጨዋታ';

  @override
  String get humanVsAi => 'ሰው ከ AI';

  @override
  String get humanVsHuman => 'ሰው ከሰው';

  @override
  String get aiVsAi => 'AI ከ AI';

  @override
  String get humanVsCloud => 'ሰው ከክላውድ';

  @override
  String get humanVsLAN => 'ሰው ከ LAN';

  @override
  String get testViaLAN => 'በ LAN ተፈትን';

  @override
  String get move => 'እንቅስቃሴ';

  @override
  String get showMoveList => 'የእንቅስቃሴ ዝርዝር አሳይ';

  @override
  String get moveList => 'የእንቅስቃሴ ዝርዝር';

  @override
  String get noGameRecord => 'መዝገብ የለም';

  @override
  String get ok => 'እሺ';

  @override
  String get confirm => 'አረጋግጥ';

  @override
  String get cancel => 'ተወው';

  @override
  String get tipSelectWrong => 'ትክክል ያልሆነ ቁራጭ ተመርጧል።';

  @override
  String get tipPlace => 'ቁራጮችዎን ያስቀምጡ።';

  @override
  String get tipBanPlace => 'እዚህ ማስቀመጥ አይችሉም።';

  @override
  String get tipPlaced => 'አስቀምጠዋል።';

  @override
  String get tipRemove => 'አንድ ቁራጭ ያስወግዱ።';

  @override
  String get tipBanRemove => 'ማስወገድ አይችሉም።';

  @override
  String get tipRemoved => 'አስወግደዋል።';

  @override
  String get tipMove => 'አንድ ቁራጭ ያንቀሳቅሱ።';

  @override
  String get tipCannotPlace => 'ቁራጭዎን እዚህ ማስቀመጥ አይችሉም።';

  @override
  String get tipCannotMove => 'ቁራጭዎን እዚህ ማንቀሳቀስ አይችሉም።';

  @override
  String get tipMill => 'ሚል! የተቀናቃኝዎን ቁራጭ ይውሰዱ።';

  @override
  String get tipContinueMill => 'የተቀናቃኝዎን ቁራጭ መውሰድ ይቀጥሉ።';

  @override
  String get tipSelectOpponentsPiece => 'ከተቀናቃኝዎ ቁራጮች መካከል አንዱን ይምረጡ።';

  @override
  String get tipCannotRemovePieceFromMill => 'ከሚል ውስጥ ያለን ቁራጭ ማስወገድ አይችሉም።';

  @override
  String get tipCanMoveOnePoint => 'አንድ ቁራጭ 1 ነጥብ ሊንቀሳቀስ ይችላል።';

  @override
  String get tipCannotMoveOpponentsPieces => 'የተቀናቃኝዎን ቁራጮች ማንቀሳቀስ አይችሉም።';

  @override
  String get tipSelectPieceToMove => 'ለማንቀሳቀስ ቁራጭዎን ይምረጡ።';

  @override
  String get tipHaveThreePiecesLeft => 'ሶስት ቁራጮች ቀርተውዎታል።';

  @override
  String get tipCanMoveToAnyPoint => 'የፈለጉት ነጥብ ላይ ማንቀሳቀስ ይችላሉ።';

  @override
  String tipToMove(Object player) {
    return '$player ለማንቀሳቀስ።';
  }

  @override
  String get whiteWin => 'ተጫዋች 1 አሸነፈ!';

  @override
  String get blackWin => 'ተጫዋች 2 አሸነፈ!';

  @override
  String get won => 'አሸነፈ';

  @override
  String get lost => 'ተሸነፈ';

  @override
  String get thinking => 'በማሰብ ላይ…';

  @override
  String get newGame => 'አዲስ ጨዋታ';

  @override
  String get importGame => 'ጨዋታ አስገባ';

  @override
  String get exportGame => 'ጨዋታ ላክ';

  @override
  String get gameImported => 'ጨዋታ ገብቷል።';

  @override
  String cannotImport(Object invalidMove) {
    return 'ማስገባት አልተቻለም $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'እንቅስቃሴዎቹና ህጎቹ አይጣጣሙም።';

  @override
  String get pleaseWait => 'እባክዎን ይጠብቁ።';

  @override
  String get restartGame => 'አሁን ያለውን ጨዋታ ዳግም ማስጀመር ይፈልጋሉ?';

  @override
  String get restart => 'እንደገና ጀምር';

  @override
  String get gameStarted => 'ጨዋታው ተጀምሯል፣ እባክዎን ያስቀምጡ።';

  @override
  String get analyzing => 'በመተንተን ላይ…';

  @override
  String error(Object message) {
    return 'ስህተት፦ $message';
  }

  @override
  String get winRate => 'የማሸነፍ መጣኔ';

  @override
  String get score => 'ነጥብ:';

  @override
  String get white => 'ተጫዋች 1';

  @override
  String get black => 'ተጫዋች 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return 'የ$player ቁራጮች ብዛት ከሶስት በታች ነው።';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player ተወ።';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player የሚሄድበት መንገድ የለውም።';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'ሰሌዳው ሙሉ ነው፣ እና $player የሚሄድበት መንገድ የለውም።';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'ጊዜው አልቋል፣ $player ተሸንፏል።';
  }

  @override
  String get drawReasonRule50 =>
      'በማንቀሳቀሻ ደረጃ ላይ፣ በመጨረሻው የተወሰነ እንቅስቃሴዎች ብዛት ውስጥ ምንም ቁራጭ አልተወገደም።';

  @override
  String get drawReasonBoardIsFull => 'ሰሌዳው ሙሉ ስለሆነ እኩል ነው።';

  @override
  String get drawReasonThreefoldRepetition =>
      'ሶስት ጊዜ ተደጋጋሚ እንቅስቃሴ ስለተደረገ እኩል ነው።';

  @override
  String get gameOverUnknownReason => 'ጨዋታው አብቅቷል! ያልታወቀ ምክንያት።';

  @override
  String get gameOver => 'ጨዋታው አብቅቷል';

  @override
  String get youWin => 'አሸንፈዋል! እንኳን ደስ አለዎት!';

  @override
  String challengeHarderLevel(int level) {
    return 'የተጨማሪ ከባድ ደረጃ ለመፈተን ትፈልጋሉ? አዲሱ ደረጃ $level ይሆናል!';
  }

  @override
  String get youLose => 'ተሸንፈዋል!';

  @override
  String get analyze => 'ተንትን';

  @override
  String get about => 'ስለ';

  @override
  String version(Object versionNumber) {
    return 'ሥሪት፦ $versionNumber';
  }

  @override
  String get thanks => 'ምስጋና';

  @override
  String get settings => 'ቅንብሮች';

  @override
  String get options => 'አማራጮች';

  @override
  String get generalSettings => 'አጠቃላይ ቅንብሮች';

  @override
  String get skillLevel => 'የችሎታ ደረጃ';

  @override
  String get moveTime => 'የ AI አስተሳሰብ ጊዜ';

  @override
  String get difficulty => 'ችግረኛነት';

  @override
  String get playSounds => 'የድምጽ ተጽዕኖዎች';

  @override
  String get playSoundsInTheGame => 'በጨዋታው ውስጥ ድምጾችን አጫውት';

  @override
  String get keepMuteWhenTakingBack => 'በመመለስ ጊዜ ድምጽ አልባ ሁን';

  @override
  String get tone => 'ቃና';

  @override
  String get whoMovesFirst => 'የመጀመሪያ እንቅስቃሴ';

  @override
  String get human => 'ሰው';

  @override
  String get ai => 'AI';

  @override
  String get alternate => 'በተራ';

  @override
  String get isAutoRestart => 'ጨዋታው ሲያልቅ በራስ-ሰር እንደገና ጀምር';

  @override
  String get isAutoChangeFirstMove => 'የመጀመሪያ እንቅስቃሴን በራስ-ሰር ቀይር';

  @override
  String get shufflingEnabled => 'ራንደም እንቅስቃሴ';

  @override
  String get misc => 'ተጨማሪ';

  @override
  String get rules => 'ህጎች';

  @override
  String get piecesCount => 'እያንዳንዱ ተጫዋች ያለው የቁራጮች ብዛት';

  @override
  String get piecesCount_Detail => 'እያንዳንዱ ተጫዋች ስንት ቁራጮች አሉት?';

  @override
  String get flyPieceCount => 'የሚበርረው ቁራጭ ቁጥር';

  @override
  String get flyPieceCount_Detail =>
      'መብረር ካስችለ፣ አንድ ተጫዋች በተወሰነ የቁራጭ ቁጥር ሲቀንስ፣ ቁራጮቹ እንደ ጨዋታው ቀሪ ክፍል በጎን ነጥቦች አይገደቡም፣ ነገር ግን ወደ ማንኛውም ባዶ ነጥብ በነጻነት መንቀሳቀስ ይችላሉ።';

  @override
  String get piecesAtLeastCount => 'ቢያንስ ያሉ ቁራጮች';

  @override
  String get hasDiagonalLines => 'ሰያፍ መስመሮች';

  @override
  String get hasDiagonalLines_Detail => 'ለሰሌዳው አራት ሰያፍ መስመሮችን ጨምር።';

  @override
  String get isDefenderMoveFirst => 'ሁለተኛው ተጫዋች መጀመሪያ ይንቀሳቀሳል';

  @override
  String get isDefenderMoveFirst_Detail =>
      'በማስቀመጫ ደረጃ ሁለተኛ የሚንቀሳቀሰው ተጫዋች በማንቀሳቀሻ ደረጃ መጀመሪያ ይንቀሳቀሳል።';

  @override
  String get mayRemoveMultiple => 'ብዙ-ማስወገድ';

  @override
  String get mayRemoveMultiple_Detail =>
      'አንድ ተጫዋች ከአንድ በላይ ሚል በአንድ ጊዜ ከዘጋ፣ የዘጋቸውን የሚል ብዛት ያህል ያስወግዳል።';

  @override
  String get mayRemoveFromMillsAlways => 'ሚሎችን አፍርስ';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'በነባሪነት፣ ተጫዋቾች ከተመሰረተ ሚል ውስጥ ቁራጭ ከማስወገዳቸው በፊት ሌሎች ቁራጮችን መጀመሪያ ማስወገድ አለባቸው። ይህን አማራጭ በማንቃት ገደቡን ያሰናክሉ።';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull => 'ሰሌዳው ሲሞላ ሁለተኛው ተጫዋች ይሸነፋል';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'በማስቀመጫ ደረጃ መጨረሻ ላይ ሰሌዳው ሲሞላ፣ መጀመሪያ የሚያስቀምጠው ወገን ጨዋታውን ይሸነፋል። ካልሆነ፣ ጨዋታው እኩል ይሆናል።';

  @override
  String get isLoseButNotChangeSideWhenNoWay => 'ህጋዊ እንቅስቃሴ ሲያጣ ይሸነፋል';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'ተቃራኒው እንዳይንቀሳቀስ ከዘጋው ተጫዋቹ ይሸነፋል። ይህ አማራጭ ካልተነቃ፣ የመንቀሳቀሻ ጎን ይቀየራል።';

  @override
  String get mayFly => 'መብረር';

  @override
  String get mayFly_Detail =>
      'አንድ ተጫዋች ሶስት ወይም አራት (የሚለወጥ) ቁራጮች ብቻ ከቀሩት፣ ቁራጩን ወደ ማንኛውም ነጻ ነጥብ ማንቀሳቀስ ይችላል።';

  @override
  String get nMoveRule => 'N-እንቅስቃሴ ህግ';

  @override
  String get nMoveRule_Detail =>
      'በተወሰነ የእንቅስቃሴዎች ቁጥር ውስጥ ምንም ማስወገድ ከሌለ ጨዋታው እኩል ይሆናል።';

  @override
  String get rollback => 'ወደኋላ መመለስ';

  @override
  String get pleaseSelect => 'እባክዎን ይምረጡ';

  @override
  String get copy => 'ቅዳ';

  @override
  String get moveHistoryCopied => 'የእንቅስቃሴ ታሪክ ወደ ቅንጥብ ሰሌዳ ተገልብጧል።';

  @override
  String get help => 'እገዛ';

  @override
  String get feedback => 'አስተያየት';

  @override
  String get exit => 'ውጣ';

  @override
  String get ruleSettings => 'የህግ ቅንብሮች';

  @override
  String get color => 'ቀለም';

  @override
  String get boardColor => 'የሰሌዳ ቀለም';

  @override
  String get pieceColor => 'የቁራጭ ቀለም';

  @override
  String get backgroundColor => 'የበስተጀርባ ቀለም';

  @override
  String get lineColor => 'የሰሌዳ መስመር ቀለም';

  @override
  String get whitePieceColor => 'የተጫዋች 1 ቁራጭ ቀለም';

  @override
  String get blackPieceColor => 'የተጫዋች 2 ቁራጭ ቀለም';

  @override
  String get messageColor => 'የመልእክት ቀለም';

  @override
  String get isPieceCountInHandShown => 'ያልተቀመጡ ቁራጮች ቁጥርን አሳይ';

  @override
  String get isNotationsShown => 'በሰሌዳው ላይ ማስታወሻዎችን አሳይ';

  @override
  String get isHistoryNavigationToolbarShown => 'የታሪክ ዳሰሳ መሳሪያ አሞሌን አሳይ';

  @override
  String get display => 'ማሳያ';

  @override
  String get boardBorderLineWidth => 'የሰሌዳ ጠርዝ መስመር ስፋት';

  @override
  String get boardInnerLineWidth => 'የሰሌዳ ውስጣዊ መስመር ስፋት';

  @override
  String get pieceWidth => 'የቁራጭ ስፋት';

  @override
  String get fontSize => 'የፊደል መጠን';

  @override
  String get standardNotation => 'WMD ምልክት አደራደር';

  @override
  String get restore => 'እንደነበር መመለስ';

  @override
  String get restoreDefaultSettings => 'ነባሪ ቅንብሮችን እንደነበር መመለስ';

  @override
  String pick(Object element) {
    return '$elementን ምረጥ';
  }

  @override
  String get info => 'መረጃ';

  @override
  String get hint => 'ፍንጭ';

  @override
  String get player => 'ተጫዋች';

  @override
  String get player1 => 'ተጫዋች 1';

  @override
  String get player2 => 'ተጫዋች 2';

  @override
  String get howToPlay => 'እንዴት እንደሚጫወቱ';

  @override
  String get toPlacePiece => 'ቁራጩን ለማስቀመጥ በማንኛውም ዝግጁ ነጥብ ላይ መታ ያድርጉ።';

  @override
  String get toSelectPiece => 'ቁራጩን ለማንቀሳቀስ በቁራጩ ላይ መታ ያድርጉ።';

  @override
  String get toMovePiece => 'ቁራጩን ለማንቀሳቀስ ከቁራጩ ጋር በተገናኘ ነጥብ ላይ መታ ያድርጉ።';

  @override
  String get toRemovePiece => 'ለማስወገድ በተቃራኒው አንድ ቁራጭ ላይ መታ ያድርጉ።';

  @override
  String get needToCreateMillFirst => 'ቁራጭ ከማስወገድዎ በፊት መጀመሪያ ሚል መፍጠር አለብዎት።';

  @override
  String get needToPlayWithOwnPieces => 'በራስዎ ቁራጮች መጫወት አለብዎት።';

  @override
  String get statistics => 'ስታቲስቲክስ';

  @override
  String get totalGames => 'ጠቅላላ ጨዋታዎች';

  @override
  String get results => 'ውጤቶች';

  @override
  String get left => 'ቀረ';

  @override
  String get privacyPolicy => 'የግላዊነት ፖሊሲ';

  @override
  String get privacyPolicy_Detail_1 =>
      'እባክዎን በጥንቃቄ ያንብቡ እና ይህንን በሙሉ መገንዘብዎን እና መስማማትዎን ያረጋግጡ ';

  @override
  String get privacyPolicy_Detail_2 =>
      '። ከዚህ ፖሊሲ ጋር የማይስማሙ ከሆነ፣ እባክዎን ይህን መተግበሪያ አይጠቀሙ። መተግበሪያውን መጠቀም እነዚህን ውሎች እንደተቀበሉ ይቆጠራል።';

  @override
  String get and => ' እና ';

  @override
  String get accept => 'ተቀበል';

  @override
  String get takeBack => 'ወደኋላ መልስ';

  @override
  String get takingBack => 'ወደኋላ በመመለስ ላይ…';

  @override
  String get waiting => 'በመጠበቅ ላይ…';

  @override
  String get stepForward => 'ወደፊት እርምጃ';

  @override
  String get takeBackAll => 'ሁሉንም ወደኋላ መልስ';

  @override
  String get stepForwardAll => 'ሁሉንም ወደፊት አንቀሳቅስ';

  @override
  String get moveNow => 'አሁን ተንቀሳቀስ';

  @override
  String get done => 'ተጠናቅቋል።';

  @override
  String get crackMill => 'ሚል-መስበር';

  @override
  String get crackMill_Detail =>
      'አንድ ተጫዋች በሚሎች ውስጥ ብቻ ቁራጮች ካሉት፣ በሚሎች ውስጥ ያሉት ቁራጮች ለማስወገድ አይቆለፉም።';

  @override
  String get animationDuration => 'የእንቅስቃሴ ቆይታ ጊዜ';

  @override
  String get none => 'ምንም';

  @override
  String get theme => 'ጭብጥ';

  @override
  String get helpContent =>
      'የጨዋታው ዓላማ ተቃራኒውን ከሶስት ቁራጮች በታች ወይም ህጋዊ እንቅስቃሴ እንዳይኖረው ማድረግ ነው።\n\nአንድ አቀማመጥ ለሶስተኛ ጊዜ ከተከሰተ ወይም በመጨረሻው 100 (የሚለወጥ) እንቅስቃሴዎች ውስጥ ምንም ማስወገድ ከሌለ ጨዋታው በራስ-ሰር እኩል ይሆናል።\n\nጨዋታው በሶስት ደረጃዎች ይካሄዳል፦\n\n1. ቁራጮችን በባዶ ነጥቦች ላይ ማስቀመጥ\n2. ቁራጮችን ወደ አጎራባች ነጥቦች ማንቀሳቀስ\n3. (አማራጭ ደረጃ) ተጫዋቹን ወደ ሶስት ቁራጮች ሲቀንስ ቁራጮችን ወደ ማንኛውም ባዶ ነጥብ ማንቀሳቀስ\n\nማስቀመጥ\n\nጨዋታው በባዶ ሰሌዳ ላይ ይጀምራል፣ ይህም ሰሌዳ ሀያ አራት ነጥቦች ያሉት ፍርግርግ ነው። ተጫዋቾች በተራ ቁራጮቻቸውን በባዶ ነጥቦች ላይ እያንዳንዱ ተጫዋች ሁሉንም ቁራጮቹን በሰሌዳው ላይ እስኪያስቀምጥ ድረስ ያስቀምጣሉ። አንድ ተጫዋች ሶስት ቁራጮቹን በቀጥታ ማስቀመጥ ከቻለ፣ \"ሚል\" አለው እና አንድ የተቃራኒውን ቁራጭ ከሰሌዳው ላይ ሊያስወግድ ይችላል።\n\nበአንዳንድ ህጎች፣ ተጫዋቾች ከተመሰረተ ሚል ውስጥ ቁራጭ ከማስወገዳቸው በፊት ሌሎች ቁራጮችን መጀመሪያ ማስወገድ አለባቸው።\n\nበአንዳንድ ህጎች፣ በማስቀመጫ ደረጃ የተወገዱ ቁራጮች ነጥቦች ላይ እንደገና ቁራጮችን ማስቀመጥ አይችሉም።\n\nሁሉንም ቁራጮች ከተጠቀሙ በኋላ፣ ተጫዋቾች በተራ ይንቀሳቀሳሉ።\n\nማንቀሳቀስ\n\nለማንቀሳቀስ፣ አንድ ተጫዋች ከቁራጮቹ አንዱን በሰሌዳው መስመር ላይ ወደ ባዶ አጎራባች ነጥብ ያንቀሳቅሳል። ይህንን ማድረግ ካልቻለ፣ ጨዋታውን አጥቷል። ሶስት ቁራጮቹን በሰሌዳው መስመር ላይ ያሰለፈ ተጫዋች ሚል አለው እና በማስቀመጫ ደረጃ እንደሚደረገው አንድ የተቃራኒውን ቁራጭ ሊያስወገድ ይችላል። ማንኛውም ተጫዋች ወደ ሁለት ቁራጮች ከቀነሰ፣ አዲስ ሚሎችን የመፍጠር አማራጭ የለውም፣ ስለዚህም ጨዋታውን ያጣል። አንድ ተጫዋች ከሶስት ቁራጮች በላይ ሲኖሩትም ተቃራኒው እንዳይንቀሳቀሱ ከዘጋባቸው ሊያጣ ይችላል።\n\nመብረር\n\nበአንዳንድ የህግ ቅርጾች፣ አንድ ተጫዋች ሶስት ቁራጮች ብቻ ሲቀሩት፣ ቁራጮቹ መብረር፣ መዝለል ወይም መዝለል ይችላሉ፣ ወደ ማንኛውም ባዶ ነጥቦች፣ አጎራባች ብቻ ሳይሆን።\n';

  @override
  String get versionInfo => 'የሥሪት መረጃ';

  @override
  String get eula => 'የመጨረሻ ተጠቃሚ ፈቃድ ስምምነት';

  @override
  String get license => 'ፈቃድ';

  @override
  String get sourceCode => 'ምንጭ ኮድ';

  @override
  String get appVersion => 'የመተግበሪያ ሥሪት';

  @override
  String get general => 'አጠቃላይ';

  @override
  String get advanced => 'የላቀ';

  @override
  String get placing => 'መዋቀር';

  @override
  String get moving => 'ማንቀሳቀስ';

  @override
  String get removing => 'ማስወገድ';

  @override
  String get gameOverCondition => 'የጨዋታ መጨረሻ ሁኔታ';

  @override
  String get aisPlayStyle => 'የሰው ሰራሽ አዕምሮ የጨዋታ ዘዴ';

  @override
  String get passive => 'ተገዢ';

  @override
  String get timeout => 'ጊዜው አልቋል';

  @override
  String get appearance => 'መልክ';

  @override
  String get drawOnHumanExperience => 'በሰው ልምድ ላይ መሳል';

  @override
  String get considerMobility => 'የዕቃዎችን እንቅስቃሴ ማገናዘብ';

  @override
  String get pieceCount => 'የቁራጭ ብዛት:';

  @override
  String inHand(Object player, int count) {
    return '$player በእጅ: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player በሰሌዳ ላይ: $count';
  }

  @override
  String get boardTop => 'ሰሌዳው ከላይ ያለው ርቀት';

  @override
  String get notAIsTurn => 'የሰው ሰራሽ አዕምሮ ተራ አይደለም።';

  @override
  String get aiIsNotThinking => 'ሰው ሰራሽ አዕምሮ አያስብም።';

  @override
  String get atEnd => 'በእንቅስቃሴ ዝርዝሩ መጨረሻ ላይ ነዎት።';

  @override
  String get tapBackAgainToLeave => 'ለመውጣት እንደገና ወደኋላ ይንኩ።';

  @override
  String get more => 'ተጨማሪ';

  @override
  String get experimental => 'ይህ የሙከራ ባህሪ ነው።';

  @override
  String get experiments => 'ሙከራዎች';

  @override
  String get ossLicenses => 'ክፍት ምንጭ ፈቃዶች';

  @override
  String get language => 'ቋንቋ';

  @override
  String get defaultLanguage => 'ነባሪ ቋንቋ';

  @override
  String get mayMoveInPlacingPhase => 'ዕቃዎችን በማስቀመጫ ደረጃ ማንቀሳቀስ ይቻላል';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'የተለያዩ የማስቀመጫ እና የማንቀሳቀሻ ደረጃዎች የሉም፣ ይህም ማለት ተጫዋቾች በእያንዳንዱ እንቅስቃሴ ላይ አንድ ዕቃ በሰሌዳው ላይ ማስቀመጥ ወይም ከዕቃዎቻቸው አንዱን ማንቀሳቀስ እንደሚፈልጉ መወሰን ይችላሉ (ለማስቀመጥ የሚቀሩ ዕቃዎች እስካሏቸው ድረስ)።';

  @override
  String get drawerColor => 'የምናሌ ቀለም';

  @override
  String get drawerTextColor => 'የምናሌ ጽሑፍ ቀለም';

  @override
  String get drawerHighlightItemColor => 'የመሳቢያው ንጥል ማድመቂያ ቀለም';

  @override
  String get mainToolbarBackgroundColor => 'የዋና መሳሪያ መደብ የጀርባ ቀለም';

  @override
  String get mainToolbarIconColor => 'የዋና መሳሪያ መደብ አዶ ቀለም';

  @override
  String get navigationToolbarBackgroundColor => 'የአሰሳ መሳሪያ መደብ የጀርባ ቀለም';

  @override
  String get navigationToolbarIconColor => 'የአሰሳ መሳሪያ መደብ አዶ ቀለም';

  @override
  String get autoHideToolbar => 'መሳሪያ መደቡን በራስ-ሰር መደበቅ';

  @override
  String get toolbarLocationOnScreen => 'የመሳሪያ መደቡ የስክሪን ቦታ';

  @override
  String get top => 'ላይኛው';

  @override
  String get bottom => 'ታችኛው';

  @override
  String get center => 'መካከል';

  @override
  String get solidColor => 'ሙሉ ቀለም';

  @override
  String get picture => 'ስዕል';

  @override
  String get chooseYourPicture => 'ስዕልዎን ይምረጡ';

  @override
  String get light => 'ብርሃን';

  @override
  String get dark => 'ጨለማ';

  @override
  String get themes => 'ቴማዎች';

  @override
  String get currentTheme => 'አሁን ያለው ቴማ';

  @override
  String get saveTheme => 'ቴማውን አስቀምጥ';

  @override
  String get showAnalysisGraph => 'የትንተና ግራፍ አሳይ';

  @override
  String get analysis => 'ትንተና';

  @override
  String get saveGame => 'ጨዋታውን አስቀምጥ';

  @override
  String get loadGame => 'ጨዋታውን ጫን';

  @override
  String get setupPosition => 'ቦታን አዘጋጅ';

  @override
  String get showLegalMoves => 'ሕጋዊ እንቅስቃሴዎችን አሳይ';

  @override
  String get showLastMove => 'የመጨረሻውን እንቅስቃሴ አሳይ';

  @override
  String get showArrows => 'ቀስቶችን አሳይ';

  @override
  String get pieces => 'ዕቃዎች';

  @override
  String get showAnalysis => 'ትንተናውን አሳይ';

  @override
  String get threads => 'ጥሪዎች';

  @override
  String get getInvolved => 'ተሳተፍ';

  @override
  String get helpImproveTranslate => 'ትርጉሙን ለማሻሻል ይረዱ';

  @override
  String get tutorial => 'መምሪያ';

  @override
  String get classicMill => 'ክላሲክ ሚል';

  @override
  String get mixedMill => 'ተመንክራዊ ሚል';

  @override
  String get ceylonMill => 'ሲሎን ሚል';

  @override
  String get mayBreakAndRemakeMillRepeatedly => 'ሚል መሰብሰብና መስራት በዘዴ ይቻላል';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'ተጫዋች ቀንንዴን ቢሰብስብ እና አዲስ ቀንንዴ በዚያኑ ጊዜ ሲፈጥር፣ በሚቀጥለው እንቅስቃሴ ውስጥ ያንን ቁራጭ ወደ መጀመሪያው መስመር ሊመልስ ይችላል፣ እንደዚህ አዲስ ቀንንዴ ቢፈጥር።';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'ተጫዋች ሦስት ቁልፎች ከቀሩ በኋላ እና በአስር እንቅስቃሴዎች አንድ ተጫዋች የተቀናቃኙን ቁልፎች ካልነቀለ ጨዋታው ተንኮል ይሆናል';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'ተጫዋች ሦስት ቁራጭ ከቀሩ በኋላ እና በአስር እንቅስቃሴዎች አንድ ተጫዋች የተቀናቃኙን ቁራጭ ካልነቀለ ጨዋታው ተንኮል ይሆናል።';

  @override
  String get close => 'መዝጋት';

  @override
  String get whitePiece => 'ነጭ ቁራጭ';

  @override
  String get blackPiece => 'ጥቁር ቁራጭ';

  @override
  String get emptyPoint => 'ባዶ ነጥብ';

  @override
  String get noPoint => 'ምንም ነጥብ የለም';

  @override
  String get placingPhase => 'መዋቅር ዘመን';

  @override
  String get movingPhase => 'መንቀሳቀስ ዘመን';

  @override
  String get flyingPhase => 'መብረር ዘመን';

  @override
  String sideToMove(Object player) {
    return 'የሚንቀሳቀስ በኩል: $player';
  }

  @override
  String lastMove(Object move) {
    return 'የመጨረሻ እንቅስቃሴ: $move';
  }

  @override
  String get selected => 'ተመርጧል';

  @override
  String get accessibility => 'ተደራሽነት';

  @override
  String get screenReaderSupport => 'ማንበቢያ መሳሪያ መደገፍ';

  @override
  String get isDraw => 'ማሟያ ነው!';

  @override
  String get draw => 'ማሟያ';

  @override
  String get pieceHighlightColor => 'የቁራጭ መዳብ ቀለም';

  @override
  String get algorithm => 'አልጎርዘም';

  @override
  String get endgameNMoveRule => 'መጨረሻ የን እንቅስቃሴ ህግ';

  @override
  String get endgameNMoveRule_Detail =>
      'አንድ ተጫዋች ሦስት ቁራጭ ከቀረው እና በተወሰኑ እንቅስቃሴዎች ውስጥ ከተቀናቃኞቹ ቁራጭ ከተጠለፈ ጨዋታው ተንኮል ይሆናል።';

  @override
  String get drawReasonEndgameRule50 =>
      'አንድ ተጫዋች ሦስት ቁራጭ ከቀረው፣ እና በተወሰኑ እንቅስቃሴዎች ውስጥ ምንም ተጫዋች ቁራጭ ካልነቀለ።';

  @override
  String get threefoldRepetitionRule => 'ሦስት ድጋፍ ትንታኔ ህግ';

  @override
  String get threefoldRepetitionRule_Detail =>
      'አንድ ነጥብ ሦስተኛ ጊዜ ሲመጣ ጨዋታው ማሟያ ይሆናል።';

  @override
  String get continueToMakeMove => 'ሚል! መንቀሳቀስን ቀጥል።';

  @override
  String get pointStyle => 'የነጥብ ቅርጸት';

  @override
  String get pointWidth => 'የነጥብ ስፋት';

  @override
  String get solid => 'አጽንኦት';

  @override
  String get hollow => 'ከፋት';

  @override
  String get languageName => 'አማርኛ';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count እንቅስቃሴዎች',
      one: '$count እንቅስቃሴ',
      zero: 'እንቅስቃሴ',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'መጫን አልተካከለም።';

  @override
  String get filename => 'የፋይል ስም';

  @override
  String get browse => 'መመልከቻ…';

  @override
  String get gameFiles => 'የጨዋታ ፋይሎች';

  @override
  String get gameSavedTo => 'ጨዋታው በዚህ ተቀምጧል';

  @override
  String get empty => 'ባዶ';

  @override
  String get noMove => 'ምንም እንቅስቃሴ የለም።';

  @override
  String get restoredPosition => 'መነሻ ነጥብ ተመልሷል።';

  @override
  String get clean => 'ንጽህና';

  @override
  String get cleanedUp => 'ንጽህና ተፈጸመ።';

  @override
  String get remove => 'መውጣት';

  @override
  String get noPiecesCanBeRemoved => 'ምንም ቁራጭ አይወጣም።';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ቁራጭዎች',
      one: '$count ቁራጭ',
      zero: 'ቁራጭ',
    );
    return '$_temp0 ያስፈልጋል መውጣትን።';
  }

  @override
  String placedCount(int count) {
    return 'ተደርጓል ($count)';
  }

  @override
  String get placedPieceCount => 'በመዋቅር ዘመን የተደረገ ቁራጭ ብዛት።';

  @override
  String hasPlacedPieceCount(int count) {
    return 'አሁን ተጫዋቹ $count ቁራጭ አኖረዋል።';
  }

  @override
  String get notPlacingPhase => 'መዋቅር ዘመን አይደለም፣ ሊቀየር አይችልም።';

  @override
  String get paste => 'ማስቀመጥ';

  @override
  String get pasteDone => 'ማስቀመጥ ተከናወነ።';

  @override
  String get cannotPaste => 'ማስቀመጥ አይቻልም።';

  @override
  String get isUnplacedAndRemovedPiecesShown => 'ያልተደረጉና የተወገዱ ቁራጭን አሳይ';

  @override
  String get fullScreen => 'ሙሉ ማእከል';

  @override
  String get reopenToTakeEffect => 'አፕሊኬሽንን ለመዝጋትና እንደገና ለመክፈት ወጣና ውጣ።';

  @override
  String get forest => 'ጫካ';

  @override
  String get desktopImage => 'ዴስክቶፕ ምስል';

  @override
  String get invalidPosition => 'የተሳሳተ ነጥብ።';

  @override
  String get shareGIF => 'GIF አካፍል';

  @override
  String get pixelRatio => 'ፒክሰል እንክብካቤ';

  @override
  String get duration => 'ጊዜ ርዝመት';

  @override
  String get gameScreenRecorder => 'ጨዋታ መነሻ መቅዳት';

  @override
  String get previous => 'ቀዳሚ';

  @override
  String get next => 'ቀጣይ';

  @override
  String get skip => 'ተው';

  @override
  String get gotIt => 'ተረዳሁ';

  @override
  String get youCanModifyRules => 'የጨዋታውን ህጎች በህግ ቅንብሮች ማሻሻል ትችላላችሁ።';

  @override
  String get youCanUseMouseWheelInPicker =>
      'በመምረጥ መኪና ቁልፍ በቅዘት እሴትን መለወጥ ትችላላችሁ።';

  @override
  String get noTimeLimitForThinking =>
      'AI ማሰብ ጊዜ ማቅረብ ወደ 0 ማስቀመጥ ማለት ማሰብ ጊዜ መውሰድ የለም።';

  @override
  String get whatIsMtdf =>
      'MTD(f) የአልፋ-ቢታ ፍለጋ አልጎርዘም ተለዋዋጭ ቅንብር ነው የሚያተኮርና በመካከለኛ ፍለጋ ውጤቶችን በመጠቀም እና በጥሩ መጀመሪያ እሴት በማሳቀመጥ ፍለጋ ምንጮችን መደበኛ መቀነስ ለመቀላቀል የሚሻል።';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'AI ማሰብ ጊዜ ማቅረብ መሙላት ተክኖ አይደለም እባኮትን ተነቀው። አስልካከ ጊዜ ቀርቦ ከሆነ የተመነ ማሰብ ጊዜ አጭር ይሆናል በሚቀጥለው ከተከለከለ የአስተናጋጅ ደረጃ በመነሻ ጊዜ ሊያልፍ ትችላለች።';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'በመሀመል ችግር ደረጃን ከማሻሻል በማቅረቡ AI ማሰብ ጊዜ እንዳትጨመር ተነቀው። የትኛውም ማሰብ ጊዜ እና የማሽነሪያ እገንኛነት ተነቀው እንዳሉ ወስኖ ሊያስከትል ተነቀው።';

  @override
  String get whatIsPvs =>
      'PVS (ዋና እንቅስቃሴ ፍለጋ) የፍለጋ አልጎርዘም ነው፣ በተገለጸ ነጥብ አሻግሬ እንቅስቃሴን ለማግኘት የሚሰራ ነው። ይህ አልጎርዘም አልፋ-ቢታ አልጎርዘምን ይወስዳል እና ባዶ ወይም ዜሮ መስኮት ፍለጋን ለማጠናከር ለማድረግ እና ለማሻገር የተገለጸውን እንቅስቃሴ አይዘበልንም በማለት እንቅስቃሴ ላይ የእጅጉ ጥላቻ ይሰራል።';

  @override
  String get whatIsAlphaBeta =>
      'አልፋ-ቢታ አልጎርዘም ከተለያየ እንቅስቃሴ መካከል አሻግሬ እንቅስቃሴን ለማግኘት የሚሠራ አልጎርዘም ነው። በእንቅስቃሴ እንቅስቃሴ ላይ በሚነካና በቢታ ማኅበራዊ ዋጋ ላይ በመስቀል አልጎርዘም መተግበሪያን ተጠንካራ እና አግባብ እንዲሆን ይረዳል።';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'በሰው ታሪክ ላይ መመስከር ከፈለጉ መስቀል እንዲያሳልፍ ትችላላችሁ። በምትሳተፍበት እንደ ዋና ግብ መዋልን ይመክሩ እና በግልጽ ስህተት በማድረግ የተከናወነ መስቀል ይቻላል። በእንቅስቃሴ በኩል ስህተት ሲሆን የእጅጉ ብርቱ እንዲሆን መንቀጥቀጥ እንደሚያስፈልግ ተነቀው።';

  @override
  String get firstMoveDetail =>
      'በጨዋታው እንደ አንደኛ ተጫዋች በኩል ድል ለማድረግ ከእሁን ተጫዋቹ በኩል የሚያሳርፍ እና የሚበልጥ መንገድ ይመነጭል።';

  @override
  String get passiveDetail =>
      'በነጠላ እንቅስቃሴ ላይ የሚሳል ምርጫን ለመቀበል ከተወሰነ ቦታ እንቅስቃሴን እንደ ዋና ምልከታ ላይ እንዳልይ ተነቀው።';

  @override
  String get moveRandomlyDetail =>
      'ጨዋታውን እና እንቅስቃሴውን በማድረግ ከእርስዎ ምርጫ እንቅስቃሴ አነስተኛ እና የመድኃኒት መንገድ ይረዳል።';

  @override
  String get considerMobilityOfPiecesDetail =>
      'እንደ AI አንደኛ በኩል ከእርስዎ ተቀንካሪዎች እንቅስቃሴን ለመቀላቀል ሲል ከተመነ በኩል እንደ ዋና ማለት የተመነ ተጫዋቾች በተለያዩ መንገድ እንቅስቃሴ እንዳልሆነ ተነቀው።';

  @override
  String get whenBoardIsFull => 'የጨዋታ ቦርድ ሲሞላ';

  @override
  String get whenBoardIsFull_Detail =>
      'በማዋቀር ዘመን ማለት መጨረሻ ሲሆን በእንቅስቃሴ ዘመን በመጀመሪያ ማስፈራራት ከተመነ አንዳንድ የተጫዋች የጨዋታ ቦርድ ተጫዋች ተነቀው።';

  @override
  String get sideToMoveRemovePiece =>
      'በእንቅስቃሴ ዘመን መጀመሪያ የሚንቀሳቀስ ተጫዋች ተፃፊውን ተጫዋች ቁራጭ ይወጣል።';

  @override
  String get agreeToDraw => 'ሁለቱም በኩል ማሟያን ተስማምተዋል።';

  @override
  String get takeOpponentsPiece => 'ከተቀናቃኙ ተጫዋች ቁልፍ አንዱን ውሰድ።';

  @override
  String get firstPlayerLose => 'መጀመሪያው ተጫዋች ጨዋታውን አጥፋል።';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'መጀመሪያና ሁለተኛው ተጫዋች ከተቀናቃኙ ቁልፍ አንዱን ይወጣሉ።';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'ሁለተኛና መጀመሪያው ተጫዋች ከተቀናቃኙ ቁልፍ አንዱን ይወጣሉ።';

  @override
  String get enteredFlyingPhase =>
      'አሁን ወደ መብረር ዘመን ገብተዋል፤ ተጫዋች ቁልፎች በጨዋታ ቦርዱ ላይ ወደ አንዳንድ ባዶ ነጥቦች ሊዘላሉ ይችላሉ። መብረር ህግን በአማራጭ ከ \"ህግ ቅንብሮች\" ውስጥ መዝጋት ትችላላችሁ።';

  @override
  String get whenStalemate => 'በማጣበቅ ጊዜ';

  @override
  String get whenStalemate_Detail => 'አንድ ቁራጭ ቢታንክር ምን ይከተላል?';

  @override
  String get endWithStalemateLoss =>
      'ከተጠበየ በኩል ከታጣበቀው ተጫዋች ግራር ማጣበቅ ለመጨረሻ ሚዛን ተመኘ።';

  @override
  String get changeSideToMove => 'የእንቅስቃሴን በኩል ቀይር።';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'ከተቀናቃኙ ተጫዋች ቁልፍ አንዱን ውስድ እና ቀጣዩን እንቅስቃሴ አድርግ።';

  @override
  String get endWithStalemateDraw => 'በማጣበቅ ምንም አሸናፊ የሌለበት ምድብ መጨረሻ ይደርሳል።';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'ከተቀናቃኙ ተጫዋች ቁልፍ አንዱን ውስድ እና የእንቅስቃሴን በኩል ቀይር።';

  @override
  String get aiResponseDelayTime => 'AI ምላሽ የሚሳለው ጊዜ';

  @override
  String get aiIsDelaying =>
      'AI በዘጠነ ምላሽ ክስተት ውስጥ ነው። እባኮትን በሚቀጥለው መንገድ መቀጠል በመታገዝ አጥብቀው በርካታ ጊዜ ይጠብቁ።';

  @override
  String get tipCanNotRemoveNonadjacent => 'በቅርብ አይደለን ቁራጭ መውጣት አይቻልም።';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'በማጣበቅ ጊዜ ከአንተ በቅርብ የሆኑ ተቀናቃኞች ቁራጭዎች ተከናነበው ሆኑ ይወጣሉ፣ የምንኛንም ተምሳሌት መንግሥት ቢኖሩም ሆነ ቢሌለ።';

  @override
  String get whatIsMcts =>
      'MCTS አልጎርዘም በትንክል ለጀማሪዎች ተመን በሚሆን አልጎርዘም ነው። ምርጫዎችን በመለየትና በመመን ከተለያዩ እንቅስቃሴዎች ተነሳ መውሰን ላይ ማሰብ ይሻል።';

  @override
  String get goldenJade => 'ወርቅና እንቁላል ኢንደብ';

  @override
  String get forestWood => 'የጫካ እንጨት';

  @override
  String get darkMystery => 'ጨለማ ምስጢር';

  @override
  String get midnightBlue => 'ሌሊት ሰማያዊ';

  @override
  String get greenForest => 'አረንጓዴ ጫካ';

  @override
  String get greenMeadow => 'አረንጓዴ መሬት';

  @override
  String get stonyPath => 'የድንጋይ መንገድ';

  @override
  String get pastelPink => 'ፓስተል ሮዝ';

  @override
  String get turquoiseSea => 'ቱርኩዝ ባህር';

  @override
  String get violetDream => 'አረንጓዴ ሕልም';

  @override
  String get mintChocolate => 'ሚንት ቸኮላታ';

  @override
  String get skyBlue => 'ሰማያዊ';

  @override
  String get playfulGarden => 'እንጨት ግንባታ';

  @override
  String get whatIsRetrogradeAnalysis =>
      'ከምንም እንቅስቃሴ ሳይሆን በመጀመሪያ ከተለያዩ ስፍራዎች ላይ የመጨረሻ ዘመን መረጃ ቤት ይገነባል፣ ከዚህ መረጃ ቤት በማጠናከር ጨዋታውን ለማሻሻል ይረዳል። ይህ ሂደት በኩል እጅግ ብርቱ መፍትሄ ስር ይገኛል።';

  @override
  String get viewAlgorithmGuide => 'ይህን አልጎርዘም የተጠቃሚ መመሪያ መመልከት ትፈልጋሉ?';

  @override
  String get showPositionalAdvantageIndicator => 'በቦታ አቀጣጠል እንዲታይ አሳይ';

  @override
  String get usePerfectDatabase => 'ፍጹም መረጃ ቤት ተጠቀም';

  @override
  String get perfectDatabaseDescription =>
      'ይህንን አማራጭ ለመሰረዝ በሚላኩ አልጎርዘሚዎች አዲስ የተፈጠረ ፍጹም ጨዋታ መረጃ ቤት ተጠቀም። ይህ ባህሪ በመነሻ እና በመጨረሻ የጨዋታ ቅንብሮችን ማጠናከር ላይ አሻግሮ ተግባራዊ እንቅስቃሴዎችን ይመክራል። ይህ በጨዋታ ላይ በጣም የታነኸ ትክክለኛነትን የሚፈልጉ ተጫዋች ለምርጫ የተመኘ ነው። በትክክለኛ ኮምፒዩተር ቴክኖሎጂ የተፈጠረ መረጃ ቤቱ እጅግ ቅርብ ወደ ፍጹም የጨዋታ መፍትሄዎችን ሊያቀርብ ተደርጎአል።\n\nማስታወሻ፡ አነስተኛው እርምጃ ማንነት መረጃ ቤቱን ቢሳካ ካልተቻለ፣ ወደ ተለዋዋጭ አልጎርዘሚዎች ይመለሳል። መረጃ ቤቱ ቢኖር፣ \'የተቀናቃኙ አከባበር\' እንደማይመቻች ይሆናል እና \'AI ማሰብ ጊዜ\' በጣም ይቀንሳል። \'AI የማሰብ ቅንብሮች\' ውስጥ ብዙ ቅንብሮች በመረጃ ቤቱ የሚያስከተሉ ነገሮች ምክንያት ተከላካሊ ይሆናሉ።\n\nይህንን ፍጹም መረጃ ቤት እንዴት በሚሻሉ መንገድ ለመማር እዚህ ይጫኑ።';

  @override
  String get backgroundImage => 'የጀርባ ምስል';

  @override
  String get whatIsRandom =>
      'እንዲያህል በሚገኝና አስተካከላቸው እንቅስቃሴዎች ሳይሆን ራንደም እንቅስቃሴ እንዲሆን ይመክራል።';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'ተቀናቃኛውን ቁራጭ ከእጁ አውጣ እና ቀጣዩ ተጫዋች በማኖሩ ቦርዱ ላይ ቁራጭ እንዲያኖር ይሁን።';

  @override
  String get whenFormingMillsDuringPlacingPhase => 'በመዋቅር ዘመን በቀንንዴ እያስመሰሉ';

  @override
  String get removeOpponentsPieceFromBoard => 'ተቀናቃኙን ቁራጭ ከቦርድ አውጣ።';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'ተቀናቃኛውን ቁራጭ ከቦርድ አውጣ፤ ቀጣዩ ተጫዋች በማኖሩ ቦርዱ ላይ ቁራጭ እንዲያኖር ይሁን።';

  @override
  String get opponentRemovesOwnPiece => 'ተቀናቃኙ የራሱን ቁራጭ ከቦርድ ያወጣል።';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'በፋንክሻ እንደ እርስዎ ወደትም እሱ ተቀናቃኙ የራሱን ቁራጭ ከቦርድ ይወጣል፣ እንደዚህ እርሱ የራሱን ጥረት ይሰርዛል።';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'ተቀናቃኙን ቁራጭ ከእጁ አውጣ፣ ከዚያ የእርስዎ የሚከተል እንቅስቃሴ ይሆናል።';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'ተቀናቃኙን ቁራጭ ከእጁ አውጣ። ከተወሰነ ቅንብር መሠረት ብዙ ቁራጭዎች ሊወጡ እንደሚገባና ተቀናቃኙ እንደሌለ እጁ ላይ ቁራጭ ካልቀረበት በቦርድ ላይ ከእንቅስቃሴ እንቅስቃሴ አሻግር። ከዚያ እንቅስቃሴ እርስዎ ይሆናል። በቦርድ ላይ ቁራጭዎች ካሳመሰሉ ማሳመሻዎቹ የሚቀጥል ማወጅ ትክክለኛ መሆን እንዲቻል ትችላላችሁ።';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'ተቀናቃኙን ቁራጭ ከእጁ አውጣ። ከተወሰነ ቅንብር መሠረት ብዙ ቁራጭዎች ሊወጡ እንደሚገባና ተቀናቃኙ እንደሌለ እጁ ላይ ቁራጭ ካልቀረበት በቦርድ ላይ ከእንቅስቃሴ እንቅስቃሴ አሻግር። ከዚያ ተቀናቃኙ እንቅስቃሴ ይሆናል።';

  @override
  String get markAndDelayRemovingPieces => 'ቁራጭዎችን መለየት እና መወጣትን አብራክ።';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'በመዋቅር ዘመን ላይ ሊወጡ የሚገባቸው ቁራጭዎች መለየት ይሆናል፣ በሁለቱም ተጫዋች ለማንኛውም አዲስ ቁራጭ ቦርድ ላይ ማኖር አይችልም። ወደ እንቅስቃሴ ዘመን ሲገቡ እነዚህን ቁራጭዎች ሙሉ መወጣት ይሆናል፣ በመጨረሻም ተጫዋች በእነዚህ ባዶ ነጥቦች ላይ ቁራጭዎቻቸውን ሊንቀሳቅሱ ይችላሉ።';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'በመዋቅር ዘመን በቀንንዴ ሲፈጥሩ የሚቀርቡ እንቅስቃሴዎች።';

  @override
  String get marked => 'ተለየቷል';

  @override
  String get menu => 'ማእከል';

  @override
  String get monochrome => 'አንድ ቀለም';

  @override
  String get youCanEnableScreenReaderSupport =>
      'በመደበኛ ቅንብሮች ማቅረቢያ ውስጥ የማንበቢያ መሳሪያ መጠንክረ አማራጭን ማከናወን ትችላላችሁ።';

  @override
  String get showNumbersOnPieces => 'ቁጥሮችን በቁራጭ ላይ አሳይ';

  @override
  String get saveImage => 'ምስል አስቀምጥ';

  @override
  String get isAnalysisToolbarShown => 'ትክክለኛ መመሪያ መሣሪያ አሳይ';

  @override
  String get analysisToolbarBackgroundColor => 'የትክክለኛ መመሪያ መሣሪያ የጀርባ ቀለም';

  @override
  String get analysisToolbarIconColor => 'የትክክለኛ መመሪያ መሣሪያ አዶ ቀለም';

  @override
  String get transformed => 'ተለውጦ ተወሰነ።';

  @override
  String get cannotTransform => 'መለወጥ አይቻልም።';

  @override
  String get rotate => 'ገለብጥ';

  @override
  String get horizontalFlip => 'አጋጣሚ';

  @override
  String get verticalFlip => 'ተዛማጅ';

  @override
  String get innerOuterFlip => 'ው/ውጫ';

  @override
  String get transparentCanvas => 'ግልጽ ቅርጫፍ';

  @override
  String get restrictRepeatedMillsFormation => 'በድጋሚ ቀንንዴዎችን መፍጠር አስቀድም';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'ቁራጭ ከአንድ ቀንንዴ መንቀሳቀስ እና ከዚያ ሌላ አንድ አዲስ ቀንንዴ ማስመስል እና በሚቀጥለው እንቅስቃሴ ወደ መጀመሪያው ነጥብ መመለስ አይቻልም። ከመጀመሪያ ሌላ እንቅስቃሴ ይፈልጋል።';

  @override
  String get oneTimeUseMill => 'አንዴ ብቻ ሊጠቀሙ የሚችሉ ቀንንዴ';

  @override
  String get oneTimeUseMill_Detail =>
      'እያንዳንድ ቀንንዴ ከተቀናቃኙ ተጫዋች ቁራጭ አንድ ጊዜ ብቻ ሊወጣ ይችላል። ሁለተኛ ጊዜ ሊፈጥሩ ይችላሉ ነገር ግን ለተጨማሪ እንዲያወጣ አይችልም።';

  @override
  String get currentRulesNoPerfectDatabase =>
      'ያሉበትን የጨዋታ ህጎች የሚመሳሰሉት ፍጹም መረጃ ቤት የለም። ስለ ፍጹም መረጃ ቤት ለተጨማሪ መረጃ እዚህ ይጫኑ።';

  @override
  String get focusOnBlockingPaths => 'በመንገድ ማጒደፍ ላይ ተከናወን';

  @override
  String get focusOnBlockingPaths_Detail =>
      'በጨዋታው ዘመናት በማለፊያ ላይ በቀንንዴ ማሳመሻ እንደ ዋና ምልከታ ከሆነ የተጫዋች እንቅስቃሴን በማገድ እና በማገልገል እንዲሁም ከጨዋታ እንደሚተሸከም እንቅስቃሴው ማሰባሰብን አያደርግም።';

  @override
  String get pieceImage => 'የእቃዎች ምስል';

  @override
  String get importColorSettings => 'ቀለም ቅንብሮችን አስመጣ';

  @override
  String get exportColorSettings => 'ቀለም ቅንብሮችን አስገባ';

  @override
  String get import => 'አስመጣ';

  @override
  String get export => 'አስገባ';

  @override
  String get pleaseCopyJsonToClipboard =>
      'እባክዎ የJSON ቅንብሮችን ቅርጽ አስቀድሞ ወደ ቅንጥብ ሰሌዳ ይቅዱ።';

  @override
  String get copiedToClipboard => 'ወደ ቅንጥብ ሰሌዳ ተቀድቷል።';

  @override
  String get imported => 'ተመጥቷል።';

  @override
  String get boardImage => 'የሰሌዳ ምስል';

  @override
  String get autumnLeaves => 'አውጣዎቹ';

  @override
  String get legendaryLand => 'አስደናቂ ምድር';

  @override
  String get vignetteEffect => 'ቪንየት ተጽዕኖ';

  @override
  String get promptMakeToolbarTransparent =>
      'የቦርድ የጀርባ ምስል ተወስኗል በሆነ ጊዜ መሣሪያ ቁልፍ ፍጹም በግልጽ ማድረግ ትፈልጋለህ?';

  @override
  String get vibration => 'እንቅስቃሴ በጨዋታው ይክዋን';

  @override
  String get soundTheme => 'የድምጽ ገጽታ';

  @override
  String get ball => 'ኳስ';

  @override
  String get liquid => 'ፈሳሽ';

  @override
  String get wood => 'ዛፍ';

  @override
  String get placeEffectAnimation => 'ቁስ ማስቀመጥ አንድነት ተጽእኖ';

  @override
  String get removeEffectAnimation => 'ቁስ ማስወገድ አንድነት ተጽእኖ';

  @override
  String get isToolbarAtBottom => 'መሳሪያ መስመርን በታች አሳይ';

  @override
  String get boardCornerRadius => 'የሳህን ማዕዘን አካል ክብ አካል';

  @override
  String get useOpeningBook => 'መክፈቻ መጽሐፍ ይጠቀሙ';

  @override
  String get currentRule => 'አሁን';

  @override
  String get nineMensMorris => 'ዘጠኝ ሰዎች ሞሪስ';

  @override
  String get twelveMensMorris => 'የአስራ ሁለት ሰዎች ሞሪስ';

  @override
  String get morabaraba => 'ሞራባራባ';

  @override
  String get dooz => 'ዱዝ';

  @override
  String get chamGonu => 'ቻምጎኑ';

  @override
  String get zhiQi => 'ጂቺ';

  @override
  String get chengSanQi => 'ቼንሳንቺ';

  @override
  String get mulMulan => 'ሙል-ሙላን';

  @override
  String get nerenchi => 'ነሬንቺ';

  @override
  String get ruleSet => 'ደንብ ስብስብ';

  @override
  String get laskerMorris => 'ላስኬር ሞሪስ';

  @override
  String get oneTimeMill => 'መልኒ፣ጣ';

  @override
  String get daSanQi => 'ዳሳንቺ';

  @override
  String get useOpeningBook_Detail =>
      'በጀርባ ጨዋታ ላይ ባለሙያ ሰው ተጫዋቾች በሚጠቀሙበት ቀጥታ ተንቀሳቃሽ እንዲጠቀም AI ያስተውል። ማስታወሻ: ይህ ባህሪ አሁን ብቻ ለክነት ህጎች ስብስብ ተመድቦ ነው።';

  @override
  String get showAdvantageGraph => 'የጥቅም ግራፍን አሳይ';

  @override
  String get advantageGraphHint =>
      'አቋሙ ግራፊክ ከAI ተንቀሳቃሽ ከተደረገ በኋላ ብቻ ይሳምራል። የሰው ተጫዋች አንቀሳቃሽ ሲደረግ ግራፊኩ አይሳምርም።';

  @override
  String get removalBasedOnMillCounts =>
      'የማስወገድ ሂደቱን እስከ ሁሉም ቅዱሳት እንዲቀመጡ ድረስ አትቻል. ተጫዋቾች ቅዱሳትን በሚቆጣጠሩበት መሠረት ያስወግዳሉ።';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'የማስወገድ ሂደቱን እስከ ሁሉም ቅዱሳት እንዲቀመጡ ድረስ አትቻል። ተጫዋቾች ቅዱሳትን በሚቆጣጠሩበት መሠረት ያስወግዳሉ፡ ከሆነ ብዛት አንድ አይደለም ከሆነ፣ ብዛት በላዩ አንዱ ተጫዋች አንድ ተጨማሪ ያስወግዳል እና የተለየ አንድ ቅዱስ ልዩነት ይቆያል። ከሆነ አንድ ብቻ ከሚከናውነው የቅዱሳት ተውጣጥፋ ሂደት ጋር፣ ያ ተጫዋች ሁለት ቅዱሳት ያስወግዳል እና አስተማማኝ አድርጎ በወደቀው ተጫዋች አንድ ቅዱስ ይወጣል። ከሆነ ሁለቱም ቅዱሳት አይቆጣጠሩም ከሆነ፣ ሁለቱም አንድ ቅዱስ ይወጣሉ።';

  @override
  String get elfilja => 'ኢልፊልጃ';

  @override
  String get tipSelectOwnPiece => 'ከጨዋታ ቁሞችዎ አንዱን ይምረጡ።';

  @override
  String get notYourTurn => 'ይህ የእርስዎ ተከታታይ አይደለም።';

  @override
  String get annotationToolbarBackgroundColor => 'የማስታወቂያ መሣሪያ መስመር ኋላ ቀለም';

  @override
  String get annotationToolbarIconColor => 'የማስታወቂያ መሣሪያ አይኮን ቀለም';

  @override
  String get isAnnotationToolbarShown => 'የማስታወቂያ መሣሪያ መስመርን አሳይ';

  @override
  String get enterAnnotationMode => 'ወደ ማስታወቂያ ሁኔታ ግባ';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'ሁሉንም ማስታወቂያዎች ማጥፋት እርግጠኛ ነዎት?';

  @override
  String get llmPromptCopiedToClipboard => 'የLLM ጥያቄ ወደ ክሊፔርድ ተቀይሯል።';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'ግንኙነት ተከላክሏል፣ ሰርቨሩ ዝቅ ሊሆን ይችላል።';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'ማግኘት ተሳክቷል፣ ግንኙነትን በመጠባበቅ ላይ...';

  @override
  String get noLanConnection => 'የLAN ግንኙነት የለም።';

  @override
  String get takeScreenshot => 'ስክሪንሽት ውሰዱ';

  @override
  String get disconnectedFromOpponent => 'ከተወዳዳሪ ግንኙነት ተቋርጧል።';

  @override
  String get takeBackRequest => 'የተመለሰ ጥያቄ';

  @override
  String get nothingToShow => 'ለማሳየት ምንም የለም።';

  @override
  String get stopHosting => 'ማስተናገድን ይቁም';

  @override
  String get connectionResetByPeer => 'ግንኙነት በተወዳዳሪ ተመልሷል።';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'ግንኙነት ልብ ጣት ጊዜ አልቋል፣ እባክዎ ዳግም ይገናኙ።';

  @override
  String get startHosting => 'ማስተናገድ ይጀምሩ';

  @override
  String get restartRequestRejected => 'የእንደገና መጀመር ጥያቄ ተቀልቷል።';

  @override
  String get notConnectedToLanOpponent => 'ከLAN ተወዳዳሪ ግንኙነት የለም።';

  @override
  String get llmPrompt => 'የLLM ጥያቄ';

  @override
  String get gameRestarted => 'ጨዋታው እንደገና ጀምሯል።';

  @override
  String get takeBackRejected => 'የመቀለስ ጥያቄ ተቀልቷል።';

  @override
  String get areYouSureYouWantToResignThisGame => 'በዚህ ጨዋታ መልቀቅ እርግጠኛ ነዎት?';

  @override
  String get opponentResignedYouWin => 'ተወዳዳሪ ተሰርዟል። እርስዎ አሸናፊ ሆነዋል!';

  @override
  String get clearAllAnnotations => 'ሁሉንም ማስታወቂያዎች አጥፋ';

  @override
  String get connectedWaitingForOpponentSMove =>
      'ግንኙነት ተደርጓል፣ ተወዳዳሪ የሚከተለውን እንቅስቃሴ በመጠባበቅ ላይ...';

  @override
  String get networkStatusDisconnected => 'የኔትወርክ ሁኔታ፡ የተቋረጠ';

  @override
  String get takeBackRequestSentToTheOpponent => 'የመቀለስ ጥያቄ ወደ ተወዳዳሪ ተላክቷል።';

  @override
  String get theOpponentMayHaveLeftTheGame => 'ተወዳዳሪ ጨዋታውን ተውቶ ሊሄድ ይችላል።';

  @override
  String get connectedToHostSuccessfully => 'ከማስተናገድ በሚገባ ግንኙነት ተደርጓል።';

  @override
  String get connectionLostHeartbeatTimeout => 'ግንኙነት ጠፍቷል፡ ልብ ጣት ጊዜ አልቋል።';

  @override
  String get noHostDiscovered => 'ምንም ማስተናገድ አልተገኘም።';

  @override
  String get confirmResignation => 'መልቀቅ ይረጋገጡ';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'ጨዋታው ማስተናገድ ጀምሯል፣ ተጫዋቾች ይተባበሩ በመጠባበቅ ላይ...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'ግንኙነት ጊዜው አልቋል፣ የኔትወርክ ግንኙነት የተሰናከለ ነው።';

  @override
  String get noLlmPromptAvailable => 'የLLM ጥያቄ የለም።';

  @override
  String get youResignedGameOver => 'እርስዎ ተሰርዟል። ጨዋታ ተጠናቋል።';

  @override
  String get serverIp => 'የሰርቨር አይፒ';

  @override
  String get confirmClear => 'አጥፋን ይረጋገጡ';

  @override
  String get opponentSTurn => 'የተወዳዳሪ ተከታታይ ነው።';

  @override
  String get waitingAClientConnection => 'ከተጠቃሚ ግንኙነት በመጠባበቅ ላይ...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'የመቀለስ ጥያቄ ተቀልቷል ወይም አልተሳካም።';

  @override
  String get addText => 'ጽሑፍ ያክሉ';

  @override
  String get exitAnnotationMode => 'የማስታወቂያ ሁኔታ ውጡ';

  @override
  String get typeYourAnnotation => 'ማስታወቂያዎን ያስገቡ';

  @override
  String get attemptingToReconnect => 'ዳግም መገናኘት በሞክር ላይ...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'የእንደገና መጀመር ጥያቄ ተላክቷል። ተወዳዳሪ ምላሽ ይጠበቅ...';

  @override
  String get serverIsStopped => 'ሰርቨሩ ተቆምቷል።';

  @override
  String get restartRequest => 'የእንደገና መጀመር ጥያቄ';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'የመቀለስ ጥያቄ ማድረግ አይቻልም ምክንያቱም ይህ የእርስዎ ተከታታይ አይደለም።';

  @override
  String get takeBackAccepted => 'የመቀለስ ጥያቄ ተቀባ።';

  @override
  String get localNetworkSettings => 'የአካባቢ ኔትወርክ ቅንብሮች';

  @override
  String get reconnectedSuccessfully => 'በሚገባ ዳግም ተገናኝቷል!';

  @override
  String get failedToSaveImageToGallery => 'ምስል ወደ ጋሌሪ መቆረጥ አልተሳካም።';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'ተወዳዳሪ ጨዋታውን እንደገና መጀመር ጥያቄ ተላክቷል። ተቀባሉ?';

  @override
  String get yourTurn => 'የእርስዎ ተከታታይ ነው።';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'ዳግም መገናኘት አልቻልኩም፣ እባክዎ ጨዋታውን እንደገና ይጀምሩ።';

  @override
  String get host => 'ማስተናገድ';

  @override
  String get join => 'ተባብረው ይገናኙ';

  @override
  String get port => 'ፖርት';

  @override
  String get invalidIpAddress => 'የIP አድራሻ የተሳሳተ ነው።';

  @override
  String get invalidPort => 'ፖርት የተሳሳተ ነው።';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'በመገናኘት ላይ፡ ሙከራ $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'ግንኙነት ላይ መገናኘት አልተሳካም፡ $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'ማስተናገድ መጀመር አልተሳካም፡ $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'ማስተናገድ ተገኝቷል፡ $ip:$port';
  }

  @override
  String get stop => 'ቁም';

  @override
  String get discover => 'ያግኙ';

  @override
  String get connect => 'ግንኙን';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'ተጠቃሚ ግንኙነት ተደርጓል፡ $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'በሚገኙ ሰከንዶች: $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'ዳግም መገናኘት ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'ተገናኝቷል';

  @override
  String get delete => 'አስወግድ';

  @override
  String get ancientEgypt => 'ጥንታዊ ግብፅ';

  @override
  String get gothicIce => 'ጎቲክ በረዶ';

  @override
  String get riceField => 'ሩዝ መልከዓምድር';

  @override
  String get chinesePorcelain => 'የቻይና ፖርሲሊን';

  @override
  String get desertDusk => 'በረሃ ጨለማ';

  @override
  String get precisionCraft => 'ትክክለኛ ዕደ-ጥበብ';

  @override
  String get folkEmbroidery => 'የህዝብ ጥልፍ';

  @override
  String get carpathianHeritage => 'ካርፓቲያን ቅርስ';

  @override
  String get imperialGrandeur => 'ንጉሳዊ ግርማ';

  @override
  String get bohemianCrystal => 'ቦሄሚያን ክሪስታል';

  @override
  String get savannaSunrise => 'ሳቫና ፀሐይ መውጣት';

  @override
  String get harmonyBalance => 'ስምምነት ሚዛን';

  @override
  String get cinnamonSpice => 'ቀረፋ ቅመም';

  @override
  String get anatolianMosaic => 'አናቶሊያን ሞዛይክ';

  @override
  String get carnivalSpirit => 'ካርኒቫል መንፈስ';

  @override
  String get custom => 'ብጁ';

  @override
  String get spiceMarket => 'ቅመም ገበያ';

  @override
  String get swipeToRevealTheDrawer => 'መዝጊያውን ለማሳየት ያንኩ';

  @override
  String get showGameInfoOnScreenshots => 'የጨዋታ መረጃን በእስክሪንሹት ላይ አሳይ';

  @override
  String get humanMoveTime => 'የሰው እንቅስቃሴ ጊዜ ገደብ';

  @override
  String get noTimeLimitForHumanMoves => 'ለሰው እንቅስቃሴዎች ምንም የጊዜ ገደብ የለም';

  @override
  String get timeoutLoseWillBeApplied => 'ለሰው ተጫዋች የጊዜ ማብቂያ መሸነፍ ይተገበራል';

  @override
  String get identifyingBoard => 'የጨዋታ ቦርድን እየማወቅ ነው...';

  @override
  String get youCanEnterAnyModelName => 'ማንኛውንም ሞዴል ስም ማስገባት ይችላሉ።';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'የቦርድ ቦታ ተተግቷል። FEN ቅጂ ወደ ክሊፕቦርድ ተቀምጧል።';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'ምክር፡ ቦርድውን በግልጽ ፎቶ መውሰድ ይሞክሩ።';

  @override
  String get llmPromptTemplate => 'የLLM ጠየቃ አብያተ-ቅርጽ';

  @override
  String get noValidBoardDetected => 'ትክክለኛ ቦርድ አልተገኘም።';

  @override
  String get selectingImageFromAlbum => 'ከአልበም ውስጥ ምስል እየምረጥ ነው...';

  @override
  String get configurePromptTemplate => 'የጠየቃ አብያተ-ቅርጽ ቅኝት';

  @override
  String get editPromptTemplateForLlmAnalysis => 'ለLLM ትንተና የጠየቃ አብያተ-ቅርጽ አርትዕ';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'ከየተረጋገጠው ቦርድ FEN ማፍጠር አልተሳካም።';

  @override
  String get outputInCurrentLanguage => 'በአሁኑ ቋንቋ ውጤት';

  @override
  String get commonBaseUrls => 'የተለመዱ መሠረታዊ Base URL-ዎች';

  @override
  String get viewCommonModels => 'የተለመዱ ሞዴሎችን መመልከት';

  @override
  String get recognitionParametersUpdated => 'የማየት መለኪያዎች ተቀይረዋል።';

  @override
  String get whiteSMove => 'የነጭ ድርሻ';

  @override
  String get resetToDefaults => 'ወደ ቀደም ያለው ሁኔታ አስመለስ';

  @override
  String get photoShoot => 'ፎቶ መውሰድ';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'የታወቀው የቦርድ ቦታ ማተካት አልተሳካም።';

  @override
  String get llmPromptContent => 'የLLM ጠየቃ ይዘት';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM አልተተካ ነው። እባክዎ ቅንብሮቶችዎን ያረጋግጡ።';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'አቅራቢ፣ ሞዴል፣ API Key እና Base URL ያቀናብሩ።';

  @override
  String get llmConfiguration => 'የLLM ቅንብር';

  @override
  String get configureLlmProvider => 'የLLM አቅራቢ ማቀናበር';

  @override
  String get llmPromptTemplateHeader => 'የLLM ጠየቃ አብያተ-ራዕይ';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'በምስሉ ውስጥ የጨዋታው ብልፊቶች አልተረዱም። እባኮትን እንደገና ይሞክሩ።';

  @override
  String get recognizeBoardFromImage => 'ከምስሉ ቦርድ ማረጋገጥ';

  @override
  String get viewTips => 'ምክሮችን ይመልከቱ';

  @override
  String get applyToBoard => 'ወደ ቦርድ ላይ መተግበር';

  @override
  String get adjustBoardArea => 'የቦርድ አካባቢ መስተካከል';

  @override
  String get viewCommonUrls => 'የተለመዱ  URL-ዎችን ይመልከቱ';

  @override
  String get colorAnalysisFailed => 'የቀለም ትንተና አልተሳካም!';

  @override
  String get analyzingGameBoardImage => 'የጨዋታ ቦርድ ምስል እየተትንተነ ነው...';

  @override
  String get selectFromAlbum => 'ከአልበም ይመረጡ';

  @override
  String get noBoardPointDetected => 'የቦርድ ነጥብ አልተገኘም!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed => 'ባዶ ቢቀረ፣ ነባሪ ቅርጹ ይጠቀማል';

  @override
  String get llmConfig => 'LLM ቅንብር';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'የጠየቃ አብያተ-ቅርጾችን ወደ ነባሪ ዋጋዎች መመለስ እርግጠኛ ነዎት?';

  @override
  String get llmPromptTemplateFooter => 'የLLM ጠየቃ አብያተ-መጨረሻ';

  @override
  String get loadingResponse => 'መልስ እየጫነ ነው...';

  @override
  String get applyThisResultToBoard => 'ይህን ውጤት ወደ ቦርድ ያተክሉ';

  @override
  String get takingPicture => 'ፎቶ ይውሰድ ነው...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'እባክዎ ለመለየት የጨዋታ ቦርድ ምስል ይምረጡ።';

  @override
  String get identificationResults => 'የመለየት ውጤቶች';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'እንቅስቃሴዎችን ይትንተኑ እና አስተያየቶችን ያቀርቡ።';

  @override
  String get getApiKey => 'API Key ያግኙ';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'የሙሉ መለየት ሂደት በሙሉ አልተጠናቀቀም።';

  @override
  String get boardRecognitionResult => 'የቦርድ መለየት ውጤት';

  @override
  String get askLlm => 'ለLLM ጠይቁ';

  @override
  String get boardDetectionFailed => 'ቦርድ መያዝ አልተሳካም!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'የቦርድ ነጥብ አልተረደም፣ ብልፊት መለየት አልቻለም!';

  @override
  String get copyFen => 'FEN ያቅፉ';

  @override
  String get commonlyUsedModels => 'ብዙ ጊዜ የሚጠቀሙ ሞዴሎች';

  @override
  String get apiKeyOptional => 'API Key (አማራጭ)';

  @override
  String get noImageSelected => 'ምንም ምስል አልተመረጠም።';

  @override
  String get blackSMove => 'የጥቁር ድርሻ';

  @override
  String get llm => 'ትልቅ የቋንቋ ሞዴል';

  @override
  String get llmProvider => 'አቅራቢ';

  @override
  String get baseUrl => 'መሠረታዊ URL';

  @override
  String get model => 'ሞዴል';

  @override
  String get temperature => 'ሙቀት';

  @override
  String get llmCommandReceivedProcessing => 'ትዕዛዝ ተቀብሏል! የAI ሂደት በመፈጠር ላይ...';

  @override
  String get llmDeepThinkingWait => 'ጥልቅ ማሰብ በሂደት ላይ ነው፣ እባክዎ ይጠብቁ...';

  @override
  String get llmPresentingSoon => 'በቅርቡ ይቀርባል...';

  @override
  String get recognitionParameters => 'የማስታወቂያ መለኪያዎች';

  @override
  String get adjustParamsDesc => 'የማስታወቂያ ትክክለኛነትን ለማሻሻል መለኪያዎችን ያስተካክሉ';

  @override
  String get saveParameters => 'መለኪያዎችን ያስቀምጡ';

  @override
  String unableToStartImageRecognition(String error) {
    return 'የምስል አቀናጅ መጀመር አልተቻለም፦ $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'የምስል አቀናጅ አልተሳካም፦ $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return '$whiteCount ነጭ እና $blackCount ጥቁር ቁሳቁሶች ያሉበት ቦታ ተተግብሯል';
  }

  @override
  String get fenCopiedToClipboard => '(FEN ወደ ቅንጫፍ ተቋርጧል)';

  @override
  String recognitionFailed(String error) {
    return 'ማስታወቂያው አልተሳካም፦ $error';
  }

  @override
  String get myRating => 'የእኔ ደረጃ';

  @override
  String get gamesPlayed => 'የተጫወቱት ጨዋታዎች';

  @override
  String get wins => 'ያሸነፈ';

  @override
  String get losses => 'የተሸነፈ';

  @override
  String get draws => 'አቻ';

  @override
  String get lastUpdated => 'ለመጨረሻ ጊዜ የተሻሻለው';

  @override
  String get format => 'ቅርጸት፡';

  @override
  String get resetStatistics => 'ስታቲስቲክስን ዳግም አስጀምር';

  @override
  String get drawRate => 'አቻ የወጣበት መጠን';

  @override
  String get lossRate => 'የተሸነፈበት መጠን';

  @override
  String get aiStatistics => 'የ AI ስታቲስቲክስ';

  @override
  String get enableStatistics => 'ስታቲስቲክስን አንቃ';

  @override
  String get enableStatistics_Detail =>
      'ሲነቃ የጨዋታ ውጤቶች በስታቲስቲክስ ውስጥ ይመዘገባሉ። ሆኖም፣ ወደኋላ መመለስን የሚያካትቱ ጨዋታዎች አይመዘገቡም። ሲሰናከል የስታቲስቲክስ ስብስብ ይቆማል።';

  @override
  String get thisWillResetAllGameStatistics =>
      'ይህ ሁሉንም የጨዋTA ስታቲስቲክስ ዳግም ያስጀምራል። ይህ እርምጃ ሊቀለበስ አይችልም።';

  @override
  String get boardInnerRingSize => 'የቦርዱ ውስጣዊ ቀለበት መጠን';

  @override
  String get boardShadowEnabled => 'ሰሌዳ ጥላ';

  @override
  String get trapAwareness => 'የወጥመድ ግንዛቤ';

  @override
  String get trapAwarenessDescription =>
      'በትንታኔ ጊዜ የወጥመድ እንቅስቃሴዎችን በወፍራም ክብ እና ቀስቶች ያበራሩ.';

  @override
  String trapExists(String trapMoves) {
    return 'ወጥመድ አለ። የወጥመድ እንቅስቃሴዎች: $trapMoves';
  }

  @override
  String get custodianCapture => 'የሚጣፍጥ ቀረፃ';

  @override
  String get custodianCaptureDescription =>
      'ቀጥታ መስመርን ለመያዝ በሁለት መስመርዎ ውስጥ ከሁለት የአላላፊ ቁርጥራጮች መካከል አንዱን ይዝጉ.';

  @override
  String get custodianCaptureEnable => 'የሚጣፍጥ ቀረፃን ፍቀድ';

  @override
  String get interventionCapture => 'ጣልቃ ገብነት';

  @override
  String get interventionCaptureDescription =>
      'ሁለቱንም ለመያዝ በሁለቱ በተቃዋሚዎ ቁርጥራጮች መካከል ወደ ባዶ ቦታ ይሂዱ.';

  @override
  String get interventionCaptureEnable => 'ጣልቃ ገብነት መፍቀድ';

  @override
  String get leapCapture => 'የተደባለቀ';

  @override
  String get leapCaptureDescription =>
      'ከአቅራቢያው የተቃዋሚ ተቃዋሚ ቁራጭ ወደ ባዶ ቦታው በመዝለል ይያዙ.';

  @override
  String get leapCaptureEnable => 'የተዘበራረቀ የተቀረጸ';

  @override
  String get captureApplicableLines => 'የሚመለከታቸው መስመሮች';

  @override
  String get captureSquareEdges => 'ካሬዎቹ ጠርዞች ጋር';

  @override
  String get captureCrossLines => 'በካሬው ካሬ የሚያቋርጡ በኮሬጅ መስመር';

  @override
  String get captureDiagonalLines => 'ካሬውን የሚያቋርጡ ዲያግናል መስመር';

  @override
  String get captureExecutionPhases => 'የማስፈጸሚያ ደረጃዎች';

  @override
  String get capturePiecesCondition =>
      'በተቀራረቡ ቁርጥራጮች ላይ በመመርኮዝ በሚንቀሳቀሱበት ደረጃ ተገኝነት ተገኝነት';

  @override
  String get capturePiecesConditionUnlimited => 'ምንም ገደብ የለም';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'ሶስት ወይም ከዚያ ያነሱ ቁርጥራጮች ሲኖሩዎት ይገኛል';
}
