// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Afrikaans (`af`).
class SAf extends S {
  SAf([String locale = 'af']) : super(locale);

  @override
  String get appName => 'Morabaraba';

  @override
  String get welcome => 'Welkom';

  @override
  String get yes => 'Ja';

  @override
  String get no => 'Nee';

  @override
  String get game => 'Spel';

  @override
  String get humanVsAi => 'Mens vs. KI';

  @override
  String get humanVsHuman => 'Mens vs. Mens';

  @override
  String get aiVsAi => 'KI vs. KI';

  @override
  String get humanVsCloud => 'Mens vs. Wolk';

  @override
  String get humanVsLAN => 'Mens vs. LAN';

  @override
  String get testViaLAN => 'Toets via LAN';

  @override
  String get move => 'Trek';

  @override
  String get showMoveList => 'Skuiflys';

  @override
  String get moveList => 'Skuiflys';

  @override
  String get noGameRecord => 'Geen rekord nie';

  @override
  String get ok => 'OK';

  @override
  String get confirm => 'Bevestig';

  @override
  String get cancel => 'Kanselleer';

  @override
  String get tipSelectWrong => 'Jy het die verkeerde stuk gekies.';

  @override
  String get tipPlace => 'Plaas jou stukke.';

  @override
  String get tipBanPlace => 'Jy kan dit nie hier plaas nie.';

  @override
  String get tipPlaced => 'Jy het geplaas.';

  @override
  String get tipRemove => 'Verwyder \'n stuk.';

  @override
  String get tipBanRemove => 'Jy kan dit nie verwyder nie.';

  @override
  String get tipRemoved => 'Jy het verwyder.';

  @override
  String get tipMove => 'Skuif \'n stuk.';

  @override
  String get tipCannotPlace => 'Jy kan nie jou stuk hier plaas nie.';

  @override
  String get tipCannotMove => 'Jy kan nie jou stuk hierheen skuif nie.';

  @override
  String get tipMill => 'Meul! Neem jou teenstander se stuk.';

  @override
  String get tipContinueMill =>
      'Gaan voort om jou teenstander se stuk te neem.';

  @override
  String get tipSelectOpponentsPiece =>
      'Kies een van jou teenstander se stukke.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Jy kan nie \'n stuk uit \'n meule verwyder nie.';

  @override
  String get tipCanMoveOnePoint => '\'n Stuk kan 1 punt beweeg.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Jy kan nie jou teenstander se stukke skuif nie.';

  @override
  String get tipSelectPieceToMove => 'Kies jou stuk om te beweeg.';

  @override
  String get tipHaveThreePiecesLeft => 'Jy het drie stukke oor.';

  @override
  String get tipCanMoveToAnyPoint => 'Jy kan beweeg na enige punt wat jy wil.';

  @override
  String tipToMove(Object player) {
    return '$player om te beweeg.';
  }

  @override
  String get whiteWin => 'Speler 1 wen!';

  @override
  String get blackWin => 'Speler 2 wen!';

  @override
  String get won => 'Gewen';

  @override
  String get lost => 'Verlore';

  @override
  String get thinking => 'Dink…';

  @override
  String get newGame => 'Nuwe spel';

  @override
  String get importGame => 'Voer speletjie in';

  @override
  String get exportGame => 'Voer speletjie uit';

  @override
  String get gameImported => 'Speletjie ingevoer.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Kan nie invoer nie $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'Bewegings en reëls stem nie ooreen nie.';

  @override
  String get pleaseWait => 'Wag asseblief.';

  @override
  String get restartGame => 'Herbegin die huidige speletjie?';

  @override
  String get restart => 'Begin oor';

  @override
  String get gameStarted => 'Die wedstryd het begin, plaas asseblief.';

  @override
  String get analyzing => 'Ontleed tans …';

  @override
  String error(Object message) {
    return 'Fout: $message';
  }

  @override
  String get winRate => 'Wenkoers';

  @override
  String get score => 'Telling:';

  @override
  String get white => 'Speler 1';

  @override
  String get black => 'Speler 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player stuktelling is minder as drie.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player het opgegee.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player het geen skuif om te maak nie.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Die bord is vol, en $player het geen skuif om te maak nie.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Tyd is verby, $player verlore.';
  }

  @override
  String get drawReasonRule50 =>
      'In die bewegende fase is geen stuk verwyder in die laaste spesifieke aantal skuiwe nie.';

  @override
  String get drawReasonBoardIsFull =>
      'Dit is \'n trekking want die bord is vol.';

  @override
  String get drawReasonThreefoldRepetition =>
      'Dit is \'n trekking as gevolg van drievoudige herhaling.';

  @override
  String get gameOverUnknownReason => 'Spel verby! Onbekende rede.';

  @override
  String get gameOver => 'Spel verby';

  @override
  String get youWin => 'Jy wen! Baie geluk!';

  @override
  String challengeHarderLevel(int level) {
    return 'Daag moeiliker vlak uit? Die nuwe vlak sal vlak $level wees!';
  }

  @override
  String get youLose => 'Jy verloor!';

  @override
  String get analyze => 'Ontleed';

  @override
  String get about => 'Oor';

  @override
  String version(Object versionNumber) {
    return 'Weergawe: $versionNumber';
  }

  @override
  String get thanks => 'Dankie';

  @override
  String get settings => 'Instellings';

  @override
  String get options => 'Opsies';

  @override
  String get generalSettings => 'Algemene instellings';

  @override
  String get skillLevel => 'Moeilikheidsgraad';

  @override
  String get moveTime => 'KI-denktyd';

  @override
  String get difficulty => 'Moeilikheid';

  @override
  String get playSounds => 'Byklanke';

  @override
  String get playSoundsInTheGame => 'Speel klanke in die speletjie';

  @override
  String get keepMuteWhenTakingBack => 'Hou stil wanneer jy terugneem';

  @override
  String get tone => 'Toon';

  @override
  String get whoMovesFirst => 'Eerste skuif';

  @override
  String get human => 'Mens';

  @override
  String get ai => 'KI';

  @override
  String get alternate => 'Wissel af';

  @override
  String get isAutoRestart =>
      'Herbegin die speletjie outomaties wanneer die speletjie verby is';

  @override
  String get isAutoChangeFirstMove => 'Outo-verandering eerste skuif';

  @override
  String get shufflingEnabled => 'Beweeg willekeurig';

  @override
  String get misc => 'Diverse';

  @override
  String get rules => 'Reëls';

  @override
  String get piecesCount => 'Die aantal stukke wat elke speler het';

  @override
  String get piecesCount_Detail => 'Hoeveel stukke het elke speler?';

  @override
  String get flyPieceCount => 'Die nommer van die vlieënde stuk';

  @override
  String get flyPieceCount_Detail =>
      'As Vlieg geaktiveer is, wanneer \'n speler tot \'n spesifieke stuktelling verminder word, is haar stukke vry om na enige onbesette punt te skuif in plaas daarvan om beperk te word tot aangrensende punte soos in die res van die speletjie.';

  @override
  String get piecesAtLeastCount => 'Stukke Ten minste';

  @override
  String get hasDiagonalLines => 'Diagonale lyne';

  @override
  String get hasDiagonalLines_Detail => 'Voeg vier diagonale lyne by die bord.';

  @override
  String get isDefenderMoveFirst => 'Die tweede speler beweeg eerste';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Die speler wat tweede beweeg in die plasingsfase, beweeg eerste in die beweegfase.';

  @override
  String get mayRemoveMultiple => 'Multi-verwyder';

  @override
  String get mayRemoveMultiple_Detail =>
      'As \'n speler meer as een meule op een slag toemaak, sal sy die aantal meule wat sy gesluit het, verwyder.';

  @override
  String get mayRemoveFromMillsAlways => 'Vernietig meulens';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'By verstek moet spelers eers enige ander stukke verwyder voordat \'n stuk uit \'n gevormde meul verwyder word. Aktiveer hierdie opsie om die beperking te deaktiveer.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Die tweede speler verloor wanneer die bord vol is';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Wanneer die bord vol is aan die einde van die plasingsfase, verloor die kant wat eerste plaas die wedstryd. Andersins is die wedstryd gelykop.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Verloor wanneer geen wettige skuiwe nie';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Die speler sal verloor as sy teenstander hulle blokkeer sodat hulle nie geskuif kan word nie. Verander kant om te skuif as hierdie opsie gedeaktiveer is.';

  @override
  String get mayFly => 'Vlieg';

  @override
  String get mayFly_Detail =>
      'As \'n speler net drie of vier (konfigureerbare) stukke oor het, kan sy die stuk na enige vrypunt skuif.';

  @override
  String get nMoveRule => 'N-skuif reël';

  @override
  String get nMoveRule_Detail =>
      'Die wedstryd word gelykop gemaak as daar geen verwydering in \'n spesifieke aantal skuiwe was nie.';

  @override
  String get rollback => 'Terugrol';

  @override
  String get pleaseSelect => 'Kies asseblief';

  @override
  String get copy => 'Kopieer';

  @override
  String get moveHistoryCopied =>
      'Skuif geskiedenis wat na knipbord gekopieer is.';

  @override
  String get help => 'Help';

  @override
  String get feedback => 'Terugvoer';

  @override
  String get exit => 'Verlaat';

  @override
  String get ruleSettings => 'Reëlinstellings';

  @override
  String get color => 'Kleur';

  @override
  String get boardColor => 'Bord kleur';

  @override
  String get pieceColor => 'Stuk kleur';

  @override
  String get backgroundColor => 'Agtergrondkleur';

  @override
  String get lineColor => 'Bordlyn kleur';

  @override
  String get whitePieceColor => 'Speler 1 stuk kleur';

  @override
  String get blackPieceColor => 'Speler 2 stuk kleur';

  @override
  String get messageColor => 'Boodskap kleur';

  @override
  String get isPieceCountInHandShown => 'Toon telling van ongeplaasde stukke';

  @override
  String get isNotationsShown => 'Wys notasies aan boord';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Wys geskiedenisnavigasienutsbalk';

  @override
  String get display => 'Vertoon';

  @override
  String get boardBorderLineWidth => 'Borderlyn breedte';

  @override
  String get boardInnerLineWidth => 'Bord binnelyn breedte';

  @override
  String get pieceWidth => 'Stuk breedte';

  @override
  String get fontSize => 'Skrifgrootte';

  @override
  String get standardNotation => 'WMD-notasie';

  @override
  String get restore => 'Herstel';

  @override
  String get restoreDefaultSettings => 'Herstel verstekinstellings';

  @override
  String pick(Object element) {
    return 'Kies $element';
  }

  @override
  String get info => 'Inligting';

  @override
  String get hint => 'Wenk';

  @override
  String get player => 'speler';

  @override
  String get player1 => 'Speler 1';

  @override
  String get player2 => 'Speler 2';

  @override
  String get howToPlay => 'Hoe om te speel';

  @override
  String get toPlacePiece =>
      'Tik op enige beskikbare punt om die stuk te plaas.';

  @override
  String get toSelectPiece => 'Tik op \'n stuk om dit te skuif.';

  @override
  String get toMovePiece =>
      'Tik op \'n punt wat aan \'n stuk gekoppel is om dit te skuif.';

  @override
  String get toRemovePiece =>
      'Tik op die teenstander se een stuk om te verwyder.';

  @override
  String get needToCreateMillFirst =>
      'Jy moet eers \'n meul skep voordat jy \'n stuk kan verwyder.';

  @override
  String get needToPlayWithOwnPieces => 'Jy moet met jou stukke speel.';

  @override
  String get statistics => 'Statistiek';

  @override
  String get totalGames => 'Totale speletjies';

  @override
  String get results => 'Resultate';

  @override
  String get left => 'links';

  @override
  String get privacyPolicy => 'Privaatheidsbeleid';

  @override
  String get privacyPolicy_Detail_1 =>
      'Lees asseblief aandagtig deur en maak seker dat u dit ten volle verstaan en daarmee saamstem ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. As jy nie tot hierdie beleid instem nie, moet asseblief nie hierdie toepassing gebruik nie. Die gebruik van die toepassing impliseer dat u hierdie bepalings aanvaar.';

  @override
  String get and => ' en ';

  @override
  String get accept => 'Aanvaar';

  @override
  String get takeBack => 'Neem terug';

  @override
  String get takingBack => 'Neem tans terug …';

  @override
  String get waiting => 'Wag tans …';

  @override
  String get stepForward => 'Tree vorentoe';

  @override
  String get takeBackAll => 'Neem alles terug';

  @override
  String get stepForwardAll => 'Stap vorentoe almal';

  @override
  String get moveNow => 'Beweeg nou';

  @override
  String get done => 'Klaar.';

  @override
  String get crackMill => 'Kraak-meul';

  @override
  String get crackMill_Detail =>
      'As \'n speler net stukke in meule het, sal die stukke in die meule nie gesluit word om te verwyder nie.';

  @override
  String get animationDuration => 'Animasie duur';

  @override
  String get none => 'Geen';

  @override
  String get theme => 'Tema';

  @override
  String get helpContent =>
      'Die speletjie het ten doel om die teenstander met minder as drie stukke oor te laat of geen wettige bewegings oor te hê nie.\n\nDie speletjie verloop in drie fases:\n\nFase 1:\n\nElke speler begin met 12 tokens genoem \"koeie\".\n\nMet \'n skoon bord, plaas elke speler beurtegewys een koei op \'n tyd op \'n kruising (sirkel). Die doel is om rye van drie te vorm, hetsy vertikaal, diagonaal, of horisontaal. Koeie mag slegs op onbesette kruisings geplaas word.\n\nWanneer drie-in-\'n-ry bereik word, mag die speler een van die opponent se koeie skiet. \'n Speler mag nie \'n opponent se \"drie-in-\'n-ry\" koeie skiet as daar ander koeie op die bord is om te skiet nie.\n\nSlegs een van die opponent se koeie mag op \'n slag geskiet word, selfs al word twee (of meer) lyne van drie-in-\'n-ry met een skuif bereik.\n\nSodra \'n koei geskiet is, mag dit nie weer in die spel gebruik word nie.\n\nFase 2:\n\nWanneer al twaalf koeie van elke speler op die bord geplaas is, mag koeie van een kruising na \'n ander beweeg word. \'n Beweging bestaan daaruit om \'n koei van een kruising na \'n onbesette kruising wat onmiddellik daaraan gekoppel en aangrensend is, te skuif.\n\nSpelers mag hul eie rye van drie-in-\'n-ry breek om nuwe lyne te vorm, of bloot hul koeie herposisioneer.\n\nKoeie mag heen en weer tussen dieselfde twee kruisings herhaaldelik beweeg word. \'n Drie-in-\'n-ry mag gemaak, gebreek en herhaaldelik hervorm word.\n\nNieteenstaande die reël dat lyne herhaaldelik gebreek en hervorm mag word, as \'n speler \'n lyn breek om onmiddellik \'n nuwe lyn van drie \'koeie\' te skep, mag sodanige speler nie die koei terugbeweeg na die oorspronklike kruising in sy/haar volgende skuif nie, as dit \'n nuwe lyn skep.\n\nElke keer as \'n drie-in-\'n-ry hergemaak word, moet \'n opponent se koei geskiet word.\n\nFase 3:\n\nWanneer \'n speler al sy koeie behalwe drie verloor het, mag hy/sy \'n koei na enige vakante kruising op die bord skuif met elke beweging.\n\nDie wen van die spel:\n\nDie spel word gewen wanneer die opponent nie enige van sy koeie kan beweeg nie, of wanneer die opponent al sy koeie behalwe twee verloor het.\n\nWanneer \'n speler af is tot drie koeie, en geen speler \'n opponent se koei binne tien skuifbeurte kan skiet nie, is die spel \'n gelykop uitslag.\n';

  @override
  String get versionInfo => 'Weergawe inligting';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'Lisensie';

  @override
  String get sourceCode => 'Bronkode';

  @override
  String get appVersion => 'App weergawe';

  @override
  String get general => 'Algemeen';

  @override
  String get advanced => 'Gevorderd';

  @override
  String get placing => 'Plasing';

  @override
  String get moving => 'Skuiffase';

  @override
  String get removing => 'Verwydering';

  @override
  String get gameOverCondition => 'Game over toestand';

  @override
  String get aisPlayStyle => 'KI se speelstyl';

  @override
  String get passive => 'Passief';

  @override
  String get timeout => 'Uitteltyd';

  @override
  String get appearance => 'Voorkoms';

  @override
  String get drawOnHumanExperience => 'Gebruik die menslike ervaring';

  @override
  String get considerMobility => 'Oorweeg die beweeglikheid van stukke';

  @override
  String get pieceCount => 'Stukkie telling:';

  @override
  String inHand(Object player, int count) {
    return '$player in die hand: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player aan boord: $count';
  }

  @override
  String get boardTop => 'Bord verskuif van bo af';

  @override
  String get notAIsTurn => 'Dit is nie die KI se beurt nie.';

  @override
  String get aiIsNotThinking => 'KI dink nie.';

  @override
  String get atEnd => 'Jy is aan die einde van die skuiflys.';

  @override
  String get tapBackAgainToLeave => 'Tik weer terug om te vertrek.';

  @override
  String get more => 'Meer';

  @override
  String get experimental => 'Dit is \'n eksperimentele kenmerk.';

  @override
  String get experiments => 'Eksperimente';

  @override
  String get ossLicenses => 'Oopbron lisensies';

  @override
  String get language => 'Taal';

  @override
  String get defaultLanguage => 'Verstektaal';

  @override
  String get mayMoveInPlacingPhase =>
      'Die stukke kan in die plasingsfase beweeg';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Daar is geen duidelike plaas- en beweegfases nie, dit wil sê die spelers kan by elke beweging besluit of hulle \'n stuk op die bord wil plaas of een van hul stukke wil skuif (solank hulle oorblywende stukke het om te plaas).';

  @override
  String get drawerColor => 'Spyskaart kleur';

  @override
  String get drawerTextColor => 'Kieslys teks kleur';

  @override
  String get drawerHighlightItemColor => 'Kieslys beklemtoon item kleur';

  @override
  String get mainToolbarBackgroundColor => 'Hoofnutsbalk agtergrondkleur';

  @override
  String get mainToolbarIconColor => 'Hoofnutsbalkikoonkleur';

  @override
  String get navigationToolbarBackgroundColor =>
      'Navigasie-nutsbalk agtergrondkleur';

  @override
  String get navigationToolbarIconColor => 'Navigasienutsbalkikoonkleur';

  @override
  String get autoHideToolbar => 'Versteek die nutsbalk outomaties';

  @override
  String get toolbarLocationOnScreen => 'Nutsbalk se ligging op die skerm';

  @override
  String get top => 'Top';

  @override
  String get bottom => 'Onderkant';

  @override
  String get center => 'Sentrum';

  @override
  String get solidColor => 'Soliede kleur';

  @override
  String get picture => 'Prent';

  @override
  String get chooseYourPicture => 'Kies jou prentjie';

  @override
  String get light => 'Lig';

  @override
  String get dark => 'Donker';

  @override
  String get themes => 'Temas';

  @override
  String get currentTheme => 'Huidige tema';

  @override
  String get saveTheme => 'Stoor tema';

  @override
  String get showAnalysisGraph => 'Wys ontledingsgrafiek';

  @override
  String get analysis => 'Ontleding';

  @override
  String get saveGame => 'Stoor spel';

  @override
  String get loadGame => 'Laai speletjie';

  @override
  String get setupPosition => 'Opstel posisie';

  @override
  String get showLegalMoves => 'Wys wettige skuiwe';

  @override
  String get showLastMove => 'Wys laaste beweging';

  @override
  String get showArrows => 'Wys pyle';

  @override
  String get pieces => 'Stukke';

  @override
  String get showAnalysis => 'Wys ontleding';

  @override
  String get threads => 'Drade';

  @override
  String get getInvolved => 'Raak betrokke';

  @override
  String get helpImproveTranslate => 'Help om vertaal te verbeter';

  @override
  String get tutorial => 'Tutoriaal';

  @override
  String get classicMill => 'Klassieke Meul';

  @override
  String get mixedMill => 'Gemengde Meul';

  @override
  String get ceylonMill => 'Ceylon Meule';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Meul kan herhaaldelik gebreek en herbou word';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'As \'n speler \'n meul breek om dadelik \'n nuwe meul te skep, kan so speler so \'n stuk terugskuif na die oorspronklike aansluiting in sy volgende skuif as dit \'n nuwe meul maak.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Die wedstryd word gelykop gemaak as \'n speler drie stukke het en na tien skuiwe verwyder geen speler die teenstander se stukke';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Wanneer \'n speler af is op drie stukke, en nie een van die speler kan \'n teenstander se stuk binne tien skuiwe verwyder nie, is die wedstryd gelykop.';

  @override
  String get close => 'Sluit';

  @override
  String get whitePiece => 'Wit stuk';

  @override
  String get blackPiece => 'Swart stuk';

  @override
  String get emptyPoint => 'Leë punt';

  @override
  String get noPoint => 'Geen punt';

  @override
  String get placingPhase => 'Plaas fase';

  @override
  String get movingPhase => 'Bewegende fase';

  @override
  String get flyingPhase => 'Vliegfase';

  @override
  String sideToMove(Object player) {
    return 'Kant om te beweeg: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Laaste skuif: $move';
  }

  @override
  String get selected => 'Gekies';

  @override
  String get accessibility => 'Toeganklikheid';

  @override
  String get screenReaderSupport => 'Skermleser ondersteuning';

  @override
  String get isDraw => 'Dit is \'n trekking!';

  @override
  String get draw => 'Teken';

  @override
  String get pieceHighlightColor => 'Stuk hoogtepunt kleur';

  @override
  String get algorithm => 'Algoritme';

  @override
  String get endgameNMoveRule => 'Eindspel N-Move reël';

  @override
  String get endgameNMoveRule_Detail =>
      'Die wedstryd word getrek as een van die spelers slegs drie stukke het en nie een van die spelers \'n stuk binne spesifieke bewegings verwyder nie.';

  @override
  String get drawReasonEndgameRule50 =>
      'Enige speler het net drie stukke, en nie een speler verwyder \'n stuk binne spesifieke bewegings nie.';

  @override
  String get threefoldRepetitionRule => 'Drievoudige herhalingsreël';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Die wedstryd word gelykop as \'n posisie vir die derde keer voorkom.';

  @override
  String get continueToMakeMove => 'Meul! Gaan voort om \'n skuif te maak.';

  @override
  String get pointStyle => 'Punt styl';

  @override
  String get pointWidth => 'Punt breedte';

  @override
  String get solid => 'Solied';

  @override
  String get hollow => 'Hol';

  @override
  String get languageName => 'Afrikaans';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Bewegings',
      one: '$count Beweeg',
      zero: 'Beweeg',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Laai het misluk.';

  @override
  String get filename => 'Lêernaam';

  @override
  String get browse => 'Snuffel…';

  @override
  String get gameFiles => 'Spellêers';

  @override
  String get gameSavedTo => 'Die speletjie word gestoor na';

  @override
  String get empty => 'Leeg';

  @override
  String get noMove => 'Geen beweging nie.';

  @override
  String get restoredPosition => 'Herstel aanvanklike posisie.';

  @override
  String get clean => 'Skoon';

  @override
  String get cleanedUp => 'Opgeruim.';

  @override
  String get remove => 'Verwyder';

  @override
  String get noPiecesCanBeRemoved => 'Geen stukke kan verwyder word nie.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count stukke',
      one: '$count stuk',
      zero: 'Stuk',
    );
    return '$_temp0 moet verwyder word.';
  }

  @override
  String placedCount(int count) {
    return 'Gpl ($count)';
  }

  @override
  String get placedPieceCount => 'Geplaasde stuktelling in die plasingsfase.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'Die huidige speler het $count stukke geplaas.';
  }

  @override
  String get notPlacingPhase => 'Plaas nie fase nie, kan dit nie verander nie.';

  @override
  String get paste => 'Plak';

  @override
  String get pasteDone => 'Die pasta is klaar.';

  @override
  String get cannotPaste => 'Kan nie plak nie.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Wys ongeplaasde en verwyderde stukke';

  @override
  String get fullScreen => 'Volskerm';

  @override
  String get reopenToTakeEffect =>
      'Verlaat en heropen app vir instellings om in werking te tree.';

  @override
  String get forest => 'Bos';

  @override
  String get desktopImage => 'Werkskermbeeld';

  @override
  String get invalidPosition => 'Ongeldige posisie.';

  @override
  String get shareGIF => 'Deel GIF';

  @override
  String get pixelRatio => 'Pixel verhouding';

  @override
  String get duration => 'Duur';

  @override
  String get gameScreenRecorder => 'Speletjieskermopnemer';

  @override
  String get previous => 'Vorige';

  @override
  String get next => 'Volgende';

  @override
  String get skip => 'Huppel';

  @override
  String get gotIt => 'Het dit';

  @override
  String get youCanModifyRules =>
      'Jy kan die reëls van die spel verander in die reëlinstellings.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Jy kan die muiswiel gebruik om die waarde in die kieser te verander.';

  @override
  String get noTimeLimitForThinking =>
      'KI Dinktyd wat op 0 gestel is, beteken daar is geen tydsbeperking vir dink nie.';

  @override
  String get whatIsMtdf =>
      'MTD(f) is \'n gewysigde vorm van die alfa-beta-soekalgoritme wat daarop gemik is om doeltreffendheid te verbeter deur intermediêre soekresultate te hergebruik en \'n goeie aanvanklike raaiskoot te gebruik om die soekruimte te verklein.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Wees asseblief bewus daarvan dat die KI-denktydaanpassing dalk nie heeltemal presies is nie. Die werklike dinktyd kan korter wees wanneer die moeilikheidsgraad op \'n laer waarde gestel is en kan langer wees wanneer die KI halfgedink is wanneer die tyd uitloop.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'As jy die moeilikheidsgraad hoog stel, maar nie die KI-denktyd verhoog nie, kan die werklike moeilikheidsgraad beperk word tot \'n laer waarde as gevolg van die dinktydbeperking. Die werklike waarde kan verskil afhangende van die masjien se werkverrigting.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) is \'n soekalgoritme om die beste skuif in \'n gegewe posisie te vind. Dit is \'n verbetering van die alfa-beta-algoritme en gebruik nul- of nul-venstersoektogte om te bevestig dat \'n skuif slegter of nie slegter is as \'n reeds veilige telling van die hoofvariasie nie. PVS fokus op die mees belowende bewegings en vermy onnodige soektogte van suboptimale takke, wat help om die doeltreffendheid van die soektog te verbeter.';

  @override
  String get whatIsAlphaBeta =>
      'Die alfa-beta-algoritme is \'n soekalgoritme om die beste skuif te vind. Dit gebruik die minimax-beginsel en twee waardes, alfa en beta, om die soekboom te snoei en doeltreffendheid te verhoog. Alfa verteenwoordig die minimum telling wat die rekenaar seker is dat dit kan kry, terwyl beta die maksimum telling verteenwoordig wat sy teenstander kan kry. Die algoritme help die rekenaar om slim, doeltreffende besluite in \'n speletjie te neem.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Volgens menslike ervaring, as jy probeer wen, sal jy verloor. Streef eerder na \'n gelykop as jou doelwit en vermy om die wedstryd te verloor. Kyk na jou teenstander en lok hulle sagkens in \'n posisie waar hulle foute kan maak. Wanneer hulle swakheid toon, gryp die geleentheid aan en druk saggies vir die oorwinning. Op hierdie manier kan jy die wedstryd wen.';

  @override
  String get firstMoveDetail =>
      'In hierdie speletjie is dit makliker vir die tweede speler om te wen in vergelyking met die eerste speler.';

  @override
  String get passiveDetail =>
      'Deur die Passiewe opsie te aktiveer, sal die KI laat ontspan wanneer dit \'n voordeel in die posisie het, eerder as om so vinnig as moontlik aggressief te probeer wen.';

  @override
  String get moveRandomlyDetail =>
      'Deur hierdie opsie te aktiveer, verhoog die ewekansigheid en pret van die spel, terwyl die deaktivering daarvan kan help om maniere te bestudeer om die KI te klop.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'As die KI die beweeglikheid van sy stukke in ag neem, sal dit nie net daarop gemik wees om die opponent se stukke so vinnig as moontlik te vang nie, maar dit ook oorweeg om die opponent se bewegings te blokkeer en te verhoed dat hulle dieselfde doen.';

  @override
  String get whenBoardIsFull => 'Wanneer die bord vol is';

  @override
  String get whenBoardIsFull_Detail =>
      'Aan die einde van die plasingsfase, voordat die beweegfase begin, volg die aksie as die bord vol stukke is.';

  @override
  String get sideToMoveRemovePiece =>
      'Die speler wat eerste in die beweegfase beweeg, verwyder een van die opponent se stukke.';

  @override
  String get agreeToDraw => 'Albei kante stem in tot \'n gelykopuitslag.';

  @override
  String get takeOpponentsPiece => 'Neem een van jou teenstander se stukke.';

  @override
  String get firstPlayerLose => 'Die eerste speler verloor die wedstryd.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Die eerste en tweede speler verwyder een van die teenstander se stukke.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Die tweede en eerste speler verwyder een van die teenstander se stukke.';

  @override
  String get enteredFlyingPhase =>
      'Noudat die vliegfase begin het, kan die teenstander se stukke na enige leë punt op die bord spring. Jy kan die vlieënde reël afskakel in die \"Reëlinstellings\".';

  @override
  String get whenStalemate => 'Wanneer \'n dooiepunt bereik word';

  @override
  String get whenStalemate_Detail =>
      'Watter aksie volg wanneer geen stuk geskuif kan word nie?';

  @override
  String get endWithStalemateLoss =>
      'Eindig met \'n dooiepunt-verlies vir die span wat geblokkeer is.';

  @override
  String get changeSideToMove => 'Verander die kant om te beweeg.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Verwyder een van die teenstander se stukke en maak die volgende skuif.';

  @override
  String get endWithStalemateDraw => 'Eindig met \'n dooiepunt-trekking.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Verwyder een van die teenstander se stukke en verander die kant om te beweeg.';

  @override
  String get aiResponseDelayTime => 'KI reaksie vertraging tyd';

  @override
  String get aiIsDelaying =>
      'KI is tans in \'n vertraagde reaksiefase. Wag asseblief \'n rukkie voor jy voortgaan.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Jy kan nie \'n nie-aangrensende stuk verwyder nie.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'As dit doodloop, kan die teenstander se stukke langs joune verwyder word, ongeag die meulformasie.';

  @override
  String get whatIsMcts =>
      'MCTS is \'n beginnersvriendelike algoritme wat besluite neem deur verskillende bewegings deur simulasies te ondersoek en te evalueer.';

  @override
  String get goldenJade => 'Goue Jade';

  @override
  String get forestWood => 'Boshout';

  @override
  String get darkMystery => 'Donker misterie';

  @override
  String get midnightBlue => 'Middernagblou';

  @override
  String get greenForest => 'Groen Bos';

  @override
  String get greenMeadow => 'Groen Weide';

  @override
  String get stonyPath => 'Klippad';

  @override
  String get pastelPink => 'Pastelpienk';

  @override
  String get turquoiseSea => 'Turkooissee';

  @override
  String get violetDream => 'Violetdroom';

  @override
  String get mintChocolate => 'Munt Sjokolade';

  @override
  String get skyBlue => 'Lugblou';

  @override
  String get playfulGarden => 'Speelsetuin';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Die retrograde-analise-algoritme gebruik multi-waarde retrograde analise om \'n eindspeldatabasis vanaf verskillende beginposisies te bou, en pas dan hierdie databasis toe om spel te optimaliseer. Hierdie benadering val onder die kategorie van Ultra-Strong oplossings.';

  @override
  String get viewAlgorithmGuide =>
      'Wil jy die gebruikersgids vir hierdie algoritme sien?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Toon posisionele voordeel aanwyser';

  @override
  String get usePerfectDatabase => 'Gebruik perfekte databasis';

  @override
  String get perfectDatabaseDescription =>
      'Aktiveer hierdie opsie om \'n foutlose speletjiedatabasis te gebruik wat deur die nuutste algoritmes gegenereer word. Hierdie kenmerk integreer beide opening- en eindspelstrategieë om optimale bewegings voor te stel. Dit is die voorkeurkeuse vir spelers wat die hoogste vlak van akkuraatheid in spel soek. Geskep deur noukeurige berekeningstegnieke, is die databasis ontwerp om byna perfekte speloplossings te bied.\n\nLet wel: Indien die KI nie toegang tot die databasis kry nie, sal dit na konvensionele algoritmes wend vir spelbesluite. Wanneer die databasis beskikbaar is, word die \'Moeilikheidsgraad\' feitlik onverbeterlik, en \'KI-denktyd\' ervaar \'n drastiese vermindering. Baie instellings binne \'AI\'s play style\'-opsies sal tersyde gestel word, aangesien die databasisuitkomste die hoogste prioriteit het.\n\nVir leiding oor hoe om die meeste van hierdie foutlose databasis te maak, klik hier.';

  @override
  String get backgroundImage => 'Agtergrondbeeld';

  @override
  String get whatIsRandom =>
      'Wanneer die \'Gebruik perfekte databasis\' opsie nie geaktiveer is nie, veroorsaak die \'Ewekansige\' instelling dat die KI stukke ewekansig skuif sonder om enige algoritmes vir skuifseleksie te gebruik. Dit lei gewoonlik tot beduidend swakker spel. In teenstelling, wanneer \'Gebruik perfekte databasis\' geaktiveer is, steun die KI uitsluitlik op die \'Perfekte Databasis\' vir besluitneming, in plaas daarvan om dit te meng met tradisionele KI-algoritmes. In hierdie modus is die KI se skuifbewegings heeltemal gebaseer op die inhoud van die databasis, en vermy afhanklikheid van regstreekse berekeninge of soekalgoritmes.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Verwyder die opponent se stukke uit hul hand; dan is dit die opponent se beurt om te plaas.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Wanneer meulens gevorm word tydens die plasing fase';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Verwyder opponent se stukke van die bord af.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Verwyder die opponent se stukke van die bord af; dan is dit die opponent se beurt om te plaas.';

  @override
  String get opponentRemovesOwnPiece =>
      'Die opponent verwyder hul eie stukke van die bord af.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'In plaas daarvan dat jy optree, kies die opponent en verwyder hul eie stukke van die bord af, wat effektief \'n aksie neem wat nadelig vir hulself is.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Verwyder die opponent se stukke uit hul hand; dan is dit jou beurt om te skuif.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Verwyder stukke uit die opponent se hand. As daar volgens die Multi-verwyder instelling meervoudige stukke verwyder moet word en die opponent het geen stukke oor in hul hand nie, gaan voort om die opponent se stukke van die bord af te verwyder. Dan is dit jou beurt om te skuif. As jy aanhou om meulens te vorm, kan jy aanhou om die opponent se stukke te verwyder.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Verwyder stukke uit die opponent se hand. As daar volgens die Multi-verwyder instelling meervoudige stukke verwyder moet word en die opponent het geen stukke oor in hul hand nie, gaan voort om die opponent se stukke van die bord af te verwyder. Dan is dit die opponent se beurt om te skuif.';

  @override
  String get markAndDelayRemovingPieces =>
      'Merk en vertraag die verwydering van stukke.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Gedurende die plasing fase word die stukke wat verwyder moet word gemerk, en vir beide spelers kan geen nuwe stukke op hierdie punte geplaas word nie. Wanneer die skuif fase betree word, word hierdie gemerkte stukke heeltemal verwyder, en spelers kan dan hul stukke skuif na hierdie nou-leë punte.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Die aksies wat geneem kan word tydens die vorming van meulens in die plasingsfase.';

  @override
  String get marked => 'Gemarkeerd';

  @override
  String get menu => 'Kieslys';

  @override
  String get monochrome => 'Monochroom';

  @override
  String get youCanEnableScreenReaderSupport =>
      'U kan skermleserondersteuning inskakel in die toeganklikheidinstellings onder Algemene Instellings.';

  @override
  String get showNumbersOnPieces => 'Toon getalle op stukke';

  @override
  String get saveImage => 'Stoor beeld';

  @override
  String get isAnalysisToolbarShown => 'Wys ontledingsnutsbalk';

  @override
  String get analysisToolbarBackgroundColor =>
      'Agtergrondkleur van ontledingsnutsbalk';

  @override
  String get analysisToolbarIconColor => 'Ikoonkleur van ontledingsnutsbalk';

  @override
  String get transformed => 'Omskep.';

  @override
  String get cannotTransform => 'Kan nie omskep nie.';

  @override
  String get rotate => 'Draai';

  @override
  String get horizontalFlip => 'H Draai';

  @override
  String get verticalFlip => 'V Draai';

  @override
  String get innerOuterFlip => 'IO Draai';

  @override
  String get transparentCanvas => 'Deursigtige Doek';

  @override
  String get restrictRepeatedMillsFormation => 'Beperk Herhaalde Meulvorming';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      '\'n Stuk wat van een meul na \'n ander geskuif is, kan nie onmiddellik terugkeer na die oorspronklike punt op die volgende beurt om weer \'n meul te vorm nie. \'n Ander skuif is eers nodig.';

  @override
  String get oneTimeUseMill => 'Eenmalige gebruik meul';

  @override
  String get oneTimeUseMill_Detail =>
      'Elke meul kan slegs een keer \'n teenstander se stuk verwyder. Jy kan dit weer hervorm, maar dit kan nie vir bykomende verwyderings gebruik word nie.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Die huidige reëls wat u ingestel het, het nie \'n ooreenstemmende perfekte databasis nie. Vir meer inligting oor die perfekte databasis, klik asseblief hier.';

  @override
  String get focusOnBlockingPaths => 'Fokus op blokkeer paaie';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Tydens spesifieke fases van die spel, prioritiseer om die teenstander se beweging te belemmer eerder as om rye van drie te vorm. In plaas daarvan om te fokus op die verwydering van stukke deur rye van drie te voltooi, mik die KI daarna om die teenstander tydens hierdie fases vas te keer, sodat hulle nie kan beweeg nie en \'n oorwinning deur uitputting verseker. Hierdie fase-spesifieke strategie blokkeer nie aktief die teenstander se rye van drie nie.';

  @override
  String get pieceImage => 'Stukkieprentjie';

  @override
  String get importColorSettings => 'Kleurinstellings invoer';

  @override
  String get exportColorSettings => 'Kleurinstellings uitvoer';

  @override
  String get import => 'Invoer';

  @override
  String get export => 'Uitvoer';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Kopieer asseblief eers die JSON-formaatinstellings na die knipbord.';

  @override
  String get copiedToClipboard => 'Na knipbord gekopieer.';

  @override
  String get imported => 'Geïmporteer.';

  @override
  String get boardImage => 'Bordbeeld';

  @override
  String get autumnLeaves => 'Herfsblare';

  @override
  String get legendaryLand => 'Legendariese Land';

  @override
  String get vignetteEffect => 'Vignet-effek';

  @override
  String get promptMakeToolbarTransparent =>
      'Wil jy die werkbalk heeltemal deurskynend maak wanneer \'n bordanfronstoepasafbeelding ingestel is?';

  @override
  String get vibration => 'Skakel vibrasie in die spel aan';

  @override
  String get soundTheme => 'Klank tema';

  @override
  String get ball => 'Bal';

  @override
  String get liquid => 'Vloeistof';

  @override
  String get wood => 'Hout';

  @override
  String get placeEffectAnimation => 'Stuk plaas animasie-effek';

  @override
  String get removeEffectAnimation => 'Stuk verwydering animasie-effek';

  @override
  String get isToolbarAtBottom => 'Wys werkbalk onder';

  @override
  String get boardCornerRadius => 'Raadhoekradius van die bord';

  @override
  String get useOpeningBook => 'Gebruik openingsboek';

  @override
  String get currentRule => 'Huidig';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Reël stel';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'One-Time Mill';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'Laat die AI openingstrekke gebruik wat algemeen deur professionele menslike spelers tydens die vroeë spel gebruik word. Let wel: Hierdie funksie is tans slegs beskikbaar vir spesifieke reël stelle.';

  @override
  String get showAdvantageGraph => 'Wys voordeelgrafiek';

  @override
  String get advantageGraphHint =>
      'Voorspronggrafiek sal slegs geteken word nadat die KI \'n skuif maak. Dit sal nie geteken word wanneer die menslike speler \'n skuif maak nie.';

  @override
  String get removalBasedOnMillCounts =>
      'Skakel verwydering uit totdat alle stukke geplaas is. Spelers verwyder stukke op grond van Morabaraba-tellings.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Skakel verwydering uit totdat alle stukke geplaas is. Spelers verwyder stukke op grond van Morabaraba-tellings: as dit gelyk is, verwyder albei dieselfde aantal stukke; as een meer het, verwyder hy een ekstra, met ’n verskil van net één stuk. As slegs een Morabaraba vorm, verwyder daardie speler twee stukke en die ander speler een. As geen speler ’n Morabaraba vorm nie, verwyder albei een stuk.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Kies een van jou stukke.';

  @override
  String get notYourTurn => 'Dis nie jou beurt nie.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Annotasie-nutsbalk agtergrondkleur';

  @override
  String get annotationToolbarIconColor => 'Annotasie-nutsbalk ikoonkleur';

  @override
  String get isAnnotationToolbarShown => 'Wys annotasie-nutsbalk';

  @override
  String get enterAnnotationMode => 'Gaan annotasiemodus binne';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Is jy seker jy wil alle annotasies uitvee?';

  @override
  String get llmPromptCopiedToClipboard => 'LLM-prompt na knipbord gekopieer.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Verbinding geweier, die bediener is moontlik af.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Ontdekking suksesvol, wag vir verbinding...';

  @override
  String get noLanConnection => 'Geen LAN-verbinding';

  @override
  String get takeScreenshot => 'Neem screenshot';

  @override
  String get disconnectedFromOpponent => 'Van teenstander ontkoppel.';

  @override
  String get takeBackRequest => 'Terugneem versoek';

  @override
  String get nothingToShow => 'Niks om te wys.';

  @override
  String get stopHosting => 'Stop hosting';

  @override
  String get connectionResetByPeer =>
      'Verbinding teruggestel deur teenstander.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Verbinding verlore weens hartklop-tydverstreking. Koppel asseblief weer.';

  @override
  String get startHosting => 'Begin hosting';

  @override
  String get restartRequestRejected => 'Herbegin versoek verwerp.';

  @override
  String get notConnectedToLanOpponent =>
      'Nie gekoppel aan LAN-teenstander nie.';

  @override
  String get llmPrompt => 'LLM-prompt';

  @override
  String get gameRestarted => 'Spel herbegin.';

  @override
  String get takeBackRejected => 'Terugneem verwerp.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Is jy seker jy wil hierdie spel bedank?';

  @override
  String get opponentResignedYouWin => 'Teenstander het bedank. Jy wen!';

  @override
  String get clearAllAnnotations => 'Vee alle annotasies uit';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Gekoppel, wag vir teenstander se skuif...';

  @override
  String get networkStatusDisconnected => 'Netwerkstatus: Ontkoppel';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Terugneem versoek aan die teenstander gestuur.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'Die teenstander het dalk die spel verlaat';

  @override
  String get connectedToHostSuccessfully => 'Suksesvol aan gasheer gekoppel.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Verbinding verlore: hartklop-tydverstreking';

  @override
  String get noHostDiscovered => 'Geen gasheer ontdek nie.';

  @override
  String get confirmResignation => 'Bevestig bedanking';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Begin spel host, wag vir spelers om aan te sluit...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Verbinding het uitgetel, netwerkverbinding onstabiel.';

  @override
  String get noLlmPromptAvailable => 'Geen LLM-prompt beskikbaar nie.';

  @override
  String get youResignedGameOver => 'Jy het bedank. Spel verby.';

  @override
  String get serverIp => 'Bediener IP';

  @override
  String get confirmClear => 'Bevestig uitvee';

  @override
  String get opponentSTurn => 'Teenstander se beurt.';

  @override
  String get waitingAClientConnection => 'Wag vir \'n kliëntverbinding...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Terugneem versoek is verwerp of het misluk.';

  @override
  String get addText => 'Voeg teks by';

  @override
  String get exitAnnotationMode => 'Verlaat annotasiemodus';

  @override
  String get typeYourAnnotation => 'Tik jou annotasie';

  @override
  String get attemptingToReconnect => 'Probeer om weer te koppel...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Herbegin versoek gestuur. Wag vir teenstander se reaksie...';

  @override
  String get serverIsStopped => 'Bediener is gestop.';

  @override
  String get restartRequest => 'Herbegin versoek';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Kan nie \'n terugneem versoek indien as dit nie jou beurt is nie.';

  @override
  String get takeBackAccepted => 'Terugneem aanvaar.';

  @override
  String get localNetworkSettings => 'Plaaslike netwerk instellings';

  @override
  String get reconnectedSuccessfully => 'Suksesvol herkoppel!';

  @override
  String get failedToSaveImageToGallery =>
      'Misluk om beeld na Gallery te stoor.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Teenstander het versoek om die spel te herbegin. Aanvaar jy?';

  @override
  String get yourTurn => 'Jou beurt.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Kan nie herkoppel nie, herbegin asseblief die spel.';

  @override
  String get host => 'Gasheer';

  @override
  String get join => 'Sluit aan';

  @override
  String get port => 'Poort';

  @override
  String get invalidIpAddress => 'Ongeldige IP-adres.';

  @override
  String get invalidPort => 'Ongeldige poort.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Verbind: Poging $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Misluk om te koppel: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Misluk om hosting te begin: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Gasheer ontdek: $ip:$port';
  }

  @override
  String get stop => 'Stop';

  @override
  String get discover => 'Ontdek';

  @override
  String get connect => 'Koppel';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Kliënt gekoppel: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Ontdek: $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Herkoppel ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Gekoppel';

  @override
  String get delete => 'Vee uit';

  @override
  String get ancientEgypt => 'Antieke Egipte';

  @override
  String get gothicIce => 'Gotiese Ys';

  @override
  String get riceField => 'Rysveld';

  @override
  String get chinesePorcelain => 'Chinese Porselein';

  @override
  String get desertDusk => 'Woestynskemer';

  @override
  String get precisionCraft => 'Presisievakmanskap';

  @override
  String get folkEmbroidery => 'Volksborduurwerk';

  @override
  String get carpathianHeritage => 'Karpatiese Erfenis';

  @override
  String get imperialGrandeur => 'Keiserlike Grootheid';

  @override
  String get bohemianCrystal => 'Boheemse Kristal';

  @override
  String get savannaSunrise => 'Savanna Sonsopkoms';

  @override
  String get harmonyBalance => 'Harmonie Balans';

  @override
  String get cinnamonSpice => 'Kaneelspesery';

  @override
  String get anatolianMosaic => 'Anatoliese Mosaïek';

  @override
  String get carnivalSpirit => 'Karnavalgees';

  @override
  String get custom => 'Pasgemaak';

  @override
  String get spiceMarket => 'Speseryemark';

  @override
  String get swipeToRevealTheDrawer => 'Swiep om die laai te wys';

  @override
  String get showGameInfoOnScreenshots => 'Wys spelinligting op skermgrepe';

  @override
  String get humanMoveTime => 'Menslike tydsbeperking';

  @override
  String get noTimeLimitForHumanMoves =>
      'Geen tydsbeperking vir menslike skuiwe nie';

  @override
  String get timeoutLoseWillBeApplied =>
      'Tydsverlies sal toegepas word vir menslike speler';

  @override
  String get identifyingBoard => 'Speelbord word geïdentifiseer…';

  @override
  String get youCanEnterAnyModelName => 'Jy kan enige modelnaam invoer';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Speelbordposisie toegepas. FEN na knipbord gekopieer.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Voorstel: Probeer ’n skerpeler foto van die speelbord neem';

  @override
  String get llmPromptTemplate => 'LLM‑promptsjabloon';

  @override
  String get noValidBoardDetected => 'Geen geldige speelbord gevind nie';

  @override
  String get selectingImageFromAlbum => 'Beeld uit album word geselekteer…';

  @override
  String get configurePromptTemplate => 'Konfigureer promptsjabloon';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Wysig promptsjabloon vir LLM-ontleding';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Kon nie FEN vanaf herkende speelbord genereer nie';

  @override
  String get outputInCurrentLanguage => 'Uitset in huidige taal';

  @override
  String get commonBaseUrls => 'Algemene Base URLs';

  @override
  String get viewCommonModels => 'Kyk algemene modelle';

  @override
  String get recognitionParametersUpdated => 'Herkenningsparameters bygewerk';

  @override
  String get whiteSMove => 'Wit se skuif';

  @override
  String get resetToDefaults => 'Herstel na verstek';

  @override
  String get photoShoot => 'Fotosessie';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Kon nie herkende speelbordposisie toepas nie';

  @override
  String get llmPromptContent => 'LLM‑promptinhoud';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM nie gekonfigureer nie. Kontroleer asseblief jou instellings.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Stel verskaffer, model, API-sleutel en Base URL in';

  @override
  String get llmConfiguration => 'LLM‑konfigurasie';

  @override
  String get configureLlmProvider => 'Konfigureer LLM‑verskaffer';

  @override
  String get llmPromptTemplateHeader => 'LLM‑promptsjabloonopskrif';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Geen stukke is in die afbeelding herken nie. Probeer asseblief weer.';

  @override
  String get recognizeBoardFromImage => 'Herken speelbord vanaf afbeelding';

  @override
  String get viewTips => 'Kyk wenke';

  @override
  String get applyToBoard => 'Toepas op speelbord';

  @override
  String get adjustBoardArea => 'Pas speelbordarea aan';

  @override
  String get viewCommonUrls => 'Kyk algemene URL\'s';

  @override
  String get colorAnalysisFailed => 'Kleuranalise het misluk!';

  @override
  String get analyzingGameBoardImage => 'Besig om speelbordbeeld te ontleed…';

  @override
  String get selectFromAlbum => 'Selekteer uit album';

  @override
  String get noBoardPointDetected => 'Geen speelbordpunt gevind nie!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Indien leeg gelaat, word die versteksjabloon gebruik';

  @override
  String get llmConfig => 'LLM‑konfigurasie';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Is jy seker jy wil die promptsjablone na verstekwaardes terugstel?';

  @override
  String get llmPromptTemplateFooter => 'LLM‑promptsjabloonvoetstuk';

  @override
  String get loadingResponse => 'Laai reaksie…';

  @override
  String get applyThisResultToBoard =>
      'Pas hierdie resultaat op die speelbord toe';

  @override
  String get takingPicture => 'Neem foto…';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Kies asseblief ’n speelbordbeeld om te identifiseer';

  @override
  String get identificationResults => 'Identifikasie‑resultate';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Analiseer die skuife en verskaf insigte.';

  @override
  String get getApiKey => 'Kry API‑sleutel';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Hele herkenningsproses kon nie voltooi word nie';

  @override
  String get boardRecognitionResult => 'Speelbordherkenningsresultaat';

  @override
  String get askLlm => 'Vra LLM';

  @override
  String get boardDetectionFailed => 'Speelbordopsporing het misluk!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Geen speelbordpunt gevind nie, kan stuk nie identifiseer nie!';

  @override
  String get copyFen => 'Kopieer FEN';

  @override
  String get commonlyUsedModels => 'Wyd gebruikte modelle';

  @override
  String get apiKeyOptional => 'API‑sleutel (opsioneel)';

  @override
  String get noImageSelected => 'Geen beeld geselekteer nie';

  @override
  String get blackSMove => 'Swart se skuif';

  @override
  String get llm => 'Groot Taalmodel';

  @override
  String get llmProvider => 'Verskaffer';

  @override
  String get baseUrl => 'Basis-URL';

  @override
  String get model => 'Model';

  @override
  String get temperature => 'Temperatuur';

  @override
  String get llmCommandReceivedProcessing =>
      'Opdrag ontvang! KI besig om te verwerk...';

  @override
  String get llmDeepThinkingWait => 'Diep denke aan die gang, wag asseblief...';

  @override
  String get llmPresentingSoon => 'Bied binnekort aan...';

  @override
  String get recognitionParameters => 'Herkenningsparameters';

  @override
  String get adjustParamsDesc =>
      'Pas parameters aan om herkenningsakkuraatheid te verbeter';

  @override
  String get saveParameters => 'Stoor parameters';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Kan nie beeldherkenning begin nie: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Beeldherkenning het misluk: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Toegepaste posisie met $whiteCount wit en $blackCount swart stukke';
  }

  @override
  String get fenCopiedToClipboard => '(FEN na knipbord gekopieer)';

  @override
  String recognitionFailed(String error) {
    return 'Herkenning het misluk: $error';
  }

  @override
  String get myRating => 'My gradering';

  @override
  String get gamesPlayed => 'Speletjies gespeel';

  @override
  String get wins => 'Oorwinnings';

  @override
  String get losses => 'Verliese';

  @override
  String get draws => 'Gelykopuitslae';

  @override
  String get lastUpdated => 'Laas opgedateer';

  @override
  String get format => 'Formaat:';

  @override
  String get resetStatistics => 'Stel statistieke terug';

  @override
  String get drawRate => 'Gelykopkoers';

  @override
  String get lossRate => 'Verlieskoers';

  @override
  String get aiStatistics => 'KI-statistieke';

  @override
  String get enableStatistics => 'Aktiveer statistieke';

  @override
  String get enableStatistics_Detail =>
      'Wanneer geaktiveer, sal speletjie-uitslae in statistieke aangeteken word. Speletjies wat terugnames behels, sal egter nie aangeteken word nie. Wanneer gedeaktiveer, word die insameling van statistieke onderbreek.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Dit sal alle speletjiestatistieke terugstel. Hierdie aksie kan nie ongedaan gemaak word nie.';

  @override
  String get boardInnerRingSize => 'Binne-ringgrootte van die bord';

  @override
  String get boardShadowEnabled => 'Bordskadu';

  @override
  String get trapAwareness => 'Lokvalbewustheid';

  @override
  String get trapAwarenessDescription =>
      'Beklemtoon lokvalskuiwe met vet sirkels en pyle tydens ontleding.';

  @override
  String trapExists(String trapMoves) {
    return 'Lokval bestaan. Lokvalskuiwe: $trapMoves';
  }

  @override
  String get custodianCapture => 'Flankerende vangs';

  @override
  String get custodianCaptureDescription =>
      'Sluit een van u teenstanders se stukke tussen twee van u in \'n reguit lyn om dit vas te vang.';

  @override
  String get custodianCaptureEnable => 'Laat flankerende vaslegging toe';

  @override
  String get interventionCapture => 'Ingryping vaslegging';

  @override
  String get interventionCaptureDescription =>
      'Beweeg in die leë punt tussen twee van u teenstanders se stukke om albei vas te lê.';

  @override
  String get interventionCaptureEnable => 'Laat ingryping vaslegging toe';

  @override
  String get leapCapture => 'Vang deur te spring';

  @override
  String get leapCaptureDescription =>
      'Vang deur oor die stuk van \'n aangrensende teenstander in die leë punt verder te spring.';

  @override
  String get leapCaptureEnable => 'Laat springopvang';

  @override
  String get captureApplicableLines => 'Toepaslike lyne';

  @override
  String get captureSquareEdges => 'Langs die rande van die plein';

  @override
  String get captureCrossLines =>
      'Langs ortogonale lyne wat die vierkant kruis';

  @override
  String get captureDiagonalLines =>
      'Langs diagonale lyne wat die vierkant kruis';

  @override
  String get captureExecutionPhases => 'Uitvoeringsfases';

  @override
  String get capturePiecesCondition =>
      'Beskikbaarheid tydens die bewegende fase gebaseer op oorblywende stukke';

  @override
  String get capturePiecesConditionUnlimited => 'Geen beperking nie';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Beskikbaar as u drie of minder stukke het';
}
