import 'dart:async';

import 'package:flutter/foundation.dart';
import 'package:flutter/widgets.dart';
import 'package:flutter_localizations/flutter_localizations.dart';
import 'package:intl/intl.dart' as intl;

import 'l10n_af.dart';
import 'l10n_am.dart';
import 'l10n_ar.dart';
import 'l10n_az.dart';
import 'l10n_be.dart';
import 'l10n_bg.dart';
import 'l10n_bn.dart';
import 'l10n_bo.dart';
import 'l10n_bs.dart';
import 'l10n_ca.dart';
import 'l10n_cs.dart';
import 'l10n_da.dart';
import 'l10n_de.dart';
import 'l10n_el.dart';
import 'l10n_en.dart';
import 'l10n_es.dart';
import 'l10n_et.dart';
import 'l10n_fa.dart';
import 'l10n_fi.dart';
import 'l10n_fr.dart';
import 'l10n_gu.dart';
import 'l10n_he.dart';
import 'l10n_hi.dart';
import 'l10n_hr.dart';
import 'l10n_hu.dart';
import 'l10n_hy.dart';
import 'l10n_id.dart';
import 'l10n_is.dart';
import 'l10n_it.dart';
import 'l10n_ja.dart';
import 'l10n_km.dart';
import 'l10n_kn.dart';
import 'l10n_ko.dart';
import 'l10n_lt.dart';
import 'l10n_lv.dart';
import 'l10n_mk.dart';
import 'l10n_ms.dart';
import 'l10n_my.dart';
import 'l10n_nb.dart';
import 'l10n_nl.dart';
import 'l10n_pl.dart';
import 'l10n_pt.dart';
import 'l10n_ro.dart';
import 'l10n_ru.dart';
import 'l10n_si.dart';
import 'l10n_sk.dart';
import 'l10n_sl.dart';
import 'l10n_sq.dart';
import 'l10n_sr.dart';
import 'l10n_sv.dart';
import 'l10n_sw.dart';
import 'l10n_ta.dart';
import 'l10n_te.dart';
import 'l10n_th.dart';
import 'l10n_tr.dart';
import 'l10n_uk.dart';
import 'l10n_ur.dart';
import 'l10n_uz.dart';
import 'l10n_vi.dart';
import 'l10n_zh.dart';
import 'l10n_zu.dart';

// ignore_for_file: type=lint

/// Callers can lookup localized strings with an instance of S
/// returned by `S.of(context)`.
///
/// Applications need to include `S.delegate()` in their app's
/// `localizationDelegates` list, and the locales they support in the app's
/// `supportedLocales` list. For example:
///
/// ```dart
/// import 'intl/l10n.dart';
///
/// return MaterialApp(
///   localizationsDelegates: S.localizationsDelegates,
///   supportedLocales: S.supportedLocales,
///   home: MyApplicationHome(),
/// );
/// ```
///
/// ## Update pubspec.yaml
///
/// Please make sure to update your pubspec.yaml to include the following
/// packages:
///
/// ```yaml
/// dependencies:
///   # Internationalization support.
///   flutter_localizations:
///     sdk: flutter
///   intl: any # Use the pinned version from flutter_localizations
///
///   # Rest of dependencies
/// ```
///
/// ## iOS Applications
///
/// iOS applications define key application metadata, including supported
/// locales, in an Info.plist file that is built into the application bundle.
/// To configure the locales supported by your app, you’ll need to edit this
/// file.
///
/// First, open your project’s ios/Runner.xcworkspace Xcode workspace file.
/// Then, in the Project Navigator, open the Info.plist file under the Runner
/// project’s Runner folder.
///
/// Next, select the Information Property List item, select Add Item from the
/// Editor menu, then select Localizations from the pop-up menu.
///
/// Select and expand the newly-created Localizations item then, for each
/// locale your application supports, add a new item and select the locale
/// you wish to add from the pop-up menu in the Value field. This list should
/// be consistent with the languages listed in the S.supportedLocales
/// property.
abstract class S {
  S(String locale)
    : localeName = intl.Intl.canonicalizedLocale(locale.toString());

  final String localeName;

  static S of(BuildContext context) {
    return Localizations.of<S>(context, S)!;
  }

  static const LocalizationsDelegate<S> delegate = _SDelegate();

  /// A list of this localizations delegate along with the default localizations
  /// delegates.
  ///
  /// Returns a list of localizations delegates containing this delegate along with
  /// GlobalMaterialLocalizations.delegate, GlobalCupertinoLocalizations.delegate,
  /// and GlobalWidgetsLocalizations.delegate.
  ///
  /// Additional delegates can be added by appending to this list in
  /// MaterialApp. This list does not have to be used at all if a custom list
  /// of delegates is preferred or required.
  static const List<LocalizationsDelegate<dynamic>> localizationsDelegates =
      <LocalizationsDelegate<dynamic>>[
        delegate,
        GlobalMaterialLocalizations.delegate,
        GlobalCupertinoLocalizations.delegate,
        GlobalWidgetsLocalizations.delegate,
      ];

  /// A list of this localizations delegate's supported locales.
  static const List<Locale> supportedLocales = <Locale>[
    Locale('af'),
    Locale('am'),
    Locale('ar'),
    Locale('az'),
    Locale('be'),
    Locale('bg'),
    Locale('bn'),
    Locale('bo'),
    Locale('bs'),
    Locale('ca'),
    Locale('cs'),
    Locale('da'),
    Locale('de'),
    Locale('de', 'CH'),
    Locale('el'),
    Locale('en'),
    Locale('es'),
    Locale('et'),
    Locale('fa'),
    Locale('fi'),
    Locale('fr'),
    Locale('gu'),
    Locale('he'),
    Locale('hi'),
    Locale('hr'),
    Locale('hu'),
    Locale('hy'),
    Locale('id'),
    Locale('is'),
    Locale('it'),
    Locale('ja'),
    Locale('km'),
    Locale('kn'),
    Locale('ko'),
    Locale('lt'),
    Locale('lv'),
    Locale('mk'),
    Locale('ms'),
    Locale('my'),
    Locale('nb'),
    Locale('nl'),
    Locale('pl'),
    Locale('pt'),
    Locale('ro'),
    Locale('ru'),
    Locale('si'),
    Locale('sk'),
    Locale('sl'),
    Locale('sq'),
    Locale('sr'),
    Locale('sv'),
    Locale('sw'),
    Locale('ta'),
    Locale('te'),
    Locale('th'),
    Locale('tr'),
    Locale('uk'),
    Locale('ur'),
    Locale('uz'),
    Locale('vi'),
    Locale('zh'),
    Locale.fromSubtags(languageCode: 'zh', scriptCode: 'Hant'),
    Locale('zu'),
  ];

  /// The app name
  ///
  /// In en, this message translates to:
  /// **'Mill'**
  String get appName;

  /// Welcome
  ///
  /// In en, this message translates to:
  /// **'Welcome'**
  String get welcome;

  /// Yes
  ///
  /// In en, this message translates to:
  /// **'Yes'**
  String get yes;

  /// No
  ///
  /// In en, this message translates to:
  /// **'No'**
  String get no;

  /// Game
  ///
  /// In en, this message translates to:
  /// **'Game'**
  String get game;

  /// Human Vs AI
  ///
  /// In en, this message translates to:
  /// **'Human Vs. AI'**
  String get humanVsAi;

  /// Human Vs Human
  ///
  /// In en, this message translates to:
  /// **'Human Vs. Human'**
  String get humanVsHuman;

  /// AI Vs AI
  ///
  /// In en, this message translates to:
  /// **'AI Vs. AI'**
  String get aiVsAi;

  /// Human Vs Cloud
  ///
  /// In en, this message translates to:
  /// **'Human Vs. Cloud'**
  String get humanVsCloud;

  /// Human Vs LAN
  ///
  /// In en, this message translates to:
  /// **'Human Vs. LAN'**
  String get humanVsLAN;

  /// Test Via LAN
  ///
  /// In en, this message translates to:
  /// **'Test Via LAN'**
  String get testViaLAN;

  /// Move
  ///
  /// In en, this message translates to:
  /// **'Move'**
  String get move;

  /// Move list
  ///
  /// In en, this message translates to:
  /// **'Move list'**
  String get showMoveList;

  /// Move list
  ///
  /// In en, this message translates to:
  /// **'Move list'**
  String get moveList;

  /// No record
  ///
  /// In en, this message translates to:
  /// **'No record'**
  String get noGameRecord;

  /// OK
  ///
  /// In en, this message translates to:
  /// **'OK'**
  String get ok;

  /// Confirm
  ///
  /// In en, this message translates to:
  /// **'Confirm'**
  String get confirm;

  /// Cancel
  ///
  /// In en, this message translates to:
  /// **'Cancel'**
  String get cancel;

  /// Select the wrong piece.
  ///
  /// In en, this message translates to:
  /// **'Select the wrong piece.'**
  String get tipSelectWrong;

  /// Place your pieces.
  ///
  /// In en, this message translates to:
  /// **'Place your pieces.'**
  String get tipPlace;

  /// Cannot place it here.
  ///
  /// In en, this message translates to:
  /// **'You cannot place it here.'**
  String get tipBanPlace;

  /// Placed.
  ///
  /// In en, this message translates to:
  /// **'Piece placed.'**
  String get tipPlaced;

  /// Remove a piece.
  ///
  /// In en, this message translates to:
  /// **'Remove a piece.'**
  String get tipRemove;

  /// Cannot remove.
  ///
  /// In en, this message translates to:
  /// **'You cannot remove it.'**
  String get tipBanRemove;

  /// Removed.
  ///
  /// In en, this message translates to:
  /// **'Piece removed.'**
  String get tipRemoved;

  /// Move a piece.
  ///
  /// In en, this message translates to:
  /// **'Move a piece.'**
  String get tipMove;

  /// You can't place your piece here.
  ///
  /// In en, this message translates to:
  /// **'You can\'t place your piece here.'**
  String get tipCannotPlace;

  /// You can't move your piece here.
  ///
  /// In en, this message translates to:
  /// **'You can\'t move your piece here.'**
  String get tipCannotMove;

  /// Mill! Take your opponent's piece.
  ///
  /// In en, this message translates to:
  /// **'Mill! Take your opponent\'s piece.'**
  String get tipMill;

  /// Continue to take your opponent's piece.
  ///
  /// In en, this message translates to:
  /// **'Continue to take your opponent\'s piece.'**
  String get tipContinueMill;

  /// Select one of your opponent's pieces.
  ///
  /// In en, this message translates to:
  /// **'Select one of your opponent\'s pieces.'**
  String get tipSelectOpponentsPiece;

  /// You cannot remove a piece from a mill.
  ///
  /// In en, this message translates to:
  /// **'You cannot remove a piece from a mill.'**
  String get tipCannotRemovePieceFromMill;

  /// A piece can move 1 point.
  ///
  /// In en, this message translates to:
  /// **'A piece can move 1 point.'**
  String get tipCanMoveOnePoint;

  /// You can't move your opponent's pieces.
  ///
  /// In en, this message translates to:
  /// **'You can\'t move your opponent\'s pieces.'**
  String get tipCannotMoveOpponentsPieces;

  /// Select your piece to move.
  ///
  /// In en, this message translates to:
  /// **'Select your piece to move.'**
  String get tipSelectPieceToMove;

  /// You have 3 pieces left.
  ///
  /// In en, this message translates to:
  /// **'You have three pieces left.'**
  String get tipHaveThreePiecesLeft;

  /// You can move to any point you like.
  ///
  /// In en, this message translates to:
  /// **'You can move to any point you like.'**
  String get tipCanMoveToAnyPoint;

  /// The tip that the given player is to move.
  ///
  /// In en, this message translates to:
  /// **'{player} to move.'**
  String tipToMove(Object player);

  /// Player 1 wins!
  ///
  /// In en, this message translates to:
  /// **'Player 1 wins!'**
  String get whiteWin;

  /// Player 2 wins!
  ///
  /// In en, this message translates to:
  /// **'Player 2 wins!'**
  String get blackWin;

  /// Won
  ///
  /// In en, this message translates to:
  /// **'Won'**
  String get won;

  /// Lost
  ///
  /// In en, this message translates to:
  /// **'Lost'**
  String get lost;

  /// Thinking...
  ///
  /// In en, this message translates to:
  /// **'Thinking…'**
  String get thinking;

  /// New game
  ///
  /// In en, this message translates to:
  /// **'New game'**
  String get newGame;

  /// Import game
  ///
  /// In en, this message translates to:
  /// **'Import game'**
  String get importGame;

  /// Export game
  ///
  /// In en, this message translates to:
  /// **'Export game'**
  String get exportGame;

  /// Game imported from the clipboard.
  ///
  /// In en, this message translates to:
  /// **'Game imported.'**
  String get gameImported;

  /// Cannot import
  ///
  /// In en, this message translates to:
  /// **'Cannot import {invalidMove}'**
  String cannotImport(Object invalidMove);

  /// Rules and moves do not match.
  ///
  /// In en, this message translates to:
  /// **'Moves and rules do not match.'**
  String get movesAndRulesNotMatch;

  /// Please wait...
  ///
  /// In en, this message translates to:
  /// **'Please wait.'**
  String get pleaseWait;

  /// Restart current game?
  ///
  /// In en, this message translates to:
  /// **'Restart the current game?'**
  String get restartGame;

  /// Restart
  ///
  /// In en, this message translates to:
  /// **'Restart'**
  String get restart;

  /// Game started, please place
  ///
  /// In en, this message translates to:
  /// **'The game started, please place.'**
  String get gameStarted;

  /// Analyzing ...
  ///
  /// In en, this message translates to:
  /// **'Analyzing…'**
  String get analyzing;

  /// Error
  ///
  /// In en, this message translates to:
  /// **'Error: {message}'**
  String error(Object message);

  /// Win Rate
  ///
  /// In en, this message translates to:
  /// **'Win Rate'**
  String get winRate;

  /// Score
  ///
  /// In en, this message translates to:
  /// **'Score:'**
  String get score;

  /// Player 1
  ///
  /// In en, this message translates to:
  /// **'Player 1'**
  String get white;

  /// Player 2
  ///
  /// In en, this message translates to:
  /// **'Player 2'**
  String get black;

  /// Indicate that the player lost because they had less than three pieces left.
  ///
  /// In en, this message translates to:
  /// **'{player} piece count is less than three.'**
  String loseReasonlessThanThree(Object player);

  /// Indicate that the player resigned.
  ///
  /// In en, this message translates to:
  /// **'{player} resigned.'**
  String loseReasonResign(Object player);

  /// Indicate that the player has no way to go.
  ///
  /// In en, this message translates to:
  /// **'{player} has no way to go.'**
  String loseReasonNoWay(Object player);

  /// Indicate that the player has no way to go because the board is full.
  ///
  /// In en, this message translates to:
  /// **'The board is full, and {player} has no way to go.'**
  String loseReasonBoardIsFull(Object player);

  /// Time Over
  ///
  /// In en, this message translates to:
  /// **'Time is over, {player} lost.'**
  String loseReasonTimeOver(Object player);

  /// In the moving phase, no piece has been removed in the last specific number of moves.
  ///
  /// In en, this message translates to:
  /// **'In the moving phase, no piece has been removed in the last specific number of moves.'**
  String get drawReasonRule50;

  /// It is a Draw because the board is full
  ///
  /// In en, this message translates to:
  /// **'It is a Draw because the board is full.'**
  String get drawReasonBoardIsFull;

  /// It is a Draw because of threefold repetition.
  ///
  /// In en, this message translates to:
  /// **'It is a Draw because of threefold repetition.'**
  String get drawReasonThreefoldRepetition;

  /// Game Over! Unknown reason.
  ///
  /// In en, this message translates to:
  /// **'Game Over! Unknown reason.'**
  String get gameOverUnknownReason;

  /// Game Over
  ///
  /// In en, this message translates to:
  /// **'Game Over'**
  String get gameOver;

  /// You win! Congratulations!
  ///
  /// In en, this message translates to:
  /// **'You win! Congratulations!'**
  String get youWin;

  /// Challenge harder level?
  ///
  /// In en, this message translates to:
  /// **'Challenge harder level? The new level will be level {level}!'**
  String challengeHarderLevel(int level);

  /// You Lose!
  ///
  /// In en, this message translates to:
  /// **'You Lose!'**
  String get youLose;

  /// Analyze
  ///
  /// In en, this message translates to:
  /// **'Analyze'**
  String get analyze;

  /// About
  ///
  /// In en, this message translates to:
  /// **'About'**
  String get about;

  /// Version
  ///
  /// In en, this message translates to:
  /// **'Version: {versionNumber}'**
  String version(Object versionNumber);

  /// Thanks
  ///
  /// In en, this message translates to:
  /// **'Thanks'**
  String get thanks;

  /// Settings
  ///
  /// In en, this message translates to:
  /// **'Settings'**
  String get settings;

  /// Options
  ///
  /// In en, this message translates to:
  /// **'Options'**
  String get options;

  /// General Settings
  ///
  /// In en, this message translates to:
  /// **'General Settings'**
  String get generalSettings;

  /// Difficulty level
  ///
  /// In en, this message translates to:
  /// **'Difficulty level'**
  String get skillLevel;

  /// AI thinking time
  ///
  /// In en, this message translates to:
  /// **'AI thinking time'**
  String get moveTime;

  /// Difficulty
  ///
  /// In en, this message translates to:
  /// **'Difficulty'**
  String get difficulty;

  /// Sound effects
  ///
  /// In en, this message translates to:
  /// **'Sound effects'**
  String get playSounds;

  /// Play sounds in the game
  ///
  /// In en, this message translates to:
  /// **'Play sounds in the game'**
  String get playSoundsInTheGame;

  /// Keep mute when taking back
  ///
  /// In en, this message translates to:
  /// **'Keep mute when taking back'**
  String get keepMuteWhenTakingBack;

  /// Tone
  ///
  /// In en, this message translates to:
  /// **'Tone'**
  String get tone;

  /// First move
  ///
  /// In en, this message translates to:
  /// **'First move'**
  String get whoMovesFirst;

  /// Human
  ///
  /// In en, this message translates to:
  /// **'Human'**
  String get human;

  /// AI
  ///
  /// In en, this message translates to:
  /// **'AI'**
  String get ai;

  /// Alternate
  ///
  /// In en, this message translates to:
  /// **'Alternate'**
  String get alternate;

  /// Auto-restart game when game over
  ///
  /// In en, this message translates to:
  /// **'Auto-restart game when game over'**
  String get isAutoRestart;

  /// Auto Change First Move
  ///
  /// In en, this message translates to:
  /// **'Auto Change First Move'**
  String get isAutoChangeFirstMove;

  /// Random move
  ///
  /// In en, this message translates to:
  /// **'Move randomly'**
  String get shufflingEnabled;

  /// Miscellaneous
  ///
  /// In en, this message translates to:
  /// **'Miscellaneous'**
  String get misc;

  /// Rules
  ///
  /// In en, this message translates to:
  /// **'Rules'**
  String get rules;

  /// The number of pieces each player has
  ///
  /// In en, this message translates to:
  /// **'The number of pieces each player has'**
  String get piecesCount;

  /// How many pieces does each player have?
  ///
  /// In en, this message translates to:
  /// **'How many pieces does each player have?'**
  String get piecesCount_Detail;

  /// The number of the flying piece
  ///
  /// In en, this message translates to:
  /// **'The number of the flying piece'**
  String get flyPieceCount;

  /// If Flying is enabled, when a player's piece count falls below a certain threshold, their pieces are free to move to any unoccupied point, instead of being restricted to adjacent points as in the rest of the game.
  ///
  /// In en, this message translates to:
  /// **'If Flying is enabled, when a player\'s piece count falls below a certain threshold, their pieces are free to move to any unoccupied point instead of being restricted to adjacent points as in the rest of the game.'**
  String get flyPieceCount_Detail;

  /// Pieces At Least
  ///
  /// In en, this message translates to:
  /// **'Pieces At Least'**
  String get piecesAtLeastCount;

  /// Diagonal lines
  ///
  /// In en, this message translates to:
  /// **'Diagonal lines'**
  String get hasDiagonalLines;

  /// Add four diagonal lines to the board.
  ///
  /// In en, this message translates to:
  /// **'Add four diagonal lines to the board.'**
  String get hasDiagonalLines_Detail;

  /// The second player moves first
  ///
  /// In en, this message translates to:
  /// **'The second player moves first'**
  String get isDefenderMoveFirst;

  /// The player who moves second in the placing phase moves first in the moving phase.
  ///
  /// In en, this message translates to:
  /// **'The player who moves second in the placing phase moves first in the moving phase.'**
  String get isDefenderMoveFirst_Detail;

  /// Multi-remove
  ///
  /// In en, this message translates to:
  /// **'Multi-remove'**
  String get mayRemoveMultiple;

  /// If a player closes more than one mill at once, she will be able to remove the number of mills she closed.
  ///
  /// In en, this message translates to:
  /// **'If a player closes more than one mill at once, she will remove the number of mills she closed.'**
  String get mayRemoveMultiple_Detail;

  /// Destroy mills
  ///
  /// In en, this message translates to:
  /// **'Destroy mills'**
  String get mayRemoveFromMillsAlways;

  /// mayRemoveFromMillsAlways_Detail
  ///
  /// In en, this message translates to:
  /// **'By default, players must remove any other pieces first before removing a piece from a formed mill. Enable this option to disable the limitation.'**
  String get mayRemoveFromMillsAlways_Detail;

  /// The second player loses when the board is full
  ///
  /// In en, this message translates to:
  /// **'The second player loses when the board is full'**
  String get isWhiteLoseButNotDrawWhenBoardFull;

  /// At the end of the placing phase, when the board is full, the side that places first loses the game, otherwise, the game is a draw.
  ///
  /// In en, this message translates to:
  /// **'When the board is full at the end of the placing phase, the side that places first loses the game. Otherwise, the game is a draw.'**
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail;

  /// Lose when no legal moves
  ///
  /// In en, this message translates to:
  /// **'Lose when no legal moves'**
  String get isLoseButNotChangeSideWhenNoWay;

  /// The player will lose if his opponent blocks them so that they cannot be moved. If this option is disabled, switch the side to move instead of declaring a loss.
  ///
  /// In en, this message translates to:
  /// **'The player will lose if his opponent blocks them so that they cannot be moved. If this option is disabled, switch the side to move instead of declaring a loss.'**
  String get isLoseButNotChangeSideWhenNoWay_Detail;

  /// Flying
  ///
  /// In en, this message translates to:
  /// **'Flying'**
  String get mayFly;

  /// If a player has only three or four (configurable) pieces left, she can move the piece to any free point.
  ///
  /// In en, this message translates to:
  /// **'If a player has only three or four (configurable) pieces left, she can move the piece to any free point.'**
  String get mayFly_Detail;

  /// N-move rule
  ///
  /// In en, this message translates to:
  /// **'N-move rule'**
  String get nMoveRule;

  /// The game is drawn if there has been no removal in a specific number of moves by each player.
  ///
  /// In en, this message translates to:
  /// **'The game is drawn if there has been no removal in a specific number of moves.'**
  String get nMoveRule_Detail;

  /// Rollback
  ///
  /// In en, this message translates to:
  /// **'Rollback'**
  String get rollback;

  /// Please select
  ///
  /// In en, this message translates to:
  /// **'Please select'**
  String get pleaseSelect;

  /// Copy
  ///
  /// In en, this message translates to:
  /// **'Copy'**
  String get copy;

  /// Move history copied to clipboard
  ///
  /// In en, this message translates to:
  /// **'Move history copied to clipboard.'**
  String get moveHistoryCopied;

  /// Help
  ///
  /// In en, this message translates to:
  /// **'Help'**
  String get help;

  /// Feedback
  ///
  /// In en, this message translates to:
  /// **'Feedback'**
  String get feedback;

  /// Exit
  ///
  /// In en, this message translates to:
  /// **'Exit'**
  String get exit;

  /// Rule Settings
  ///
  /// In en, this message translates to:
  /// **'Rule Settings'**
  String get ruleSettings;

  /// Color
  ///
  /// In en, this message translates to:
  /// **'Color'**
  String get color;

  /// Board color
  ///
  /// In en, this message translates to:
  /// **'Board color'**
  String get boardColor;

  /// Piece color
  ///
  /// In en, this message translates to:
  /// **'Piece color'**
  String get pieceColor;

  /// Background color
  ///
  /// In en, this message translates to:
  /// **'Background color'**
  String get backgroundColor;

  /// Board line color
  ///
  /// In en, this message translates to:
  /// **'Board line color'**
  String get lineColor;

  /// Player 1 piece color
  ///
  /// In en, this message translates to:
  /// **'Player 1 piece color'**
  String get whitePieceColor;

  /// Player 2 piece color
  ///
  /// In en, this message translates to:
  /// **'Player 2 piece color'**
  String get blackPieceColor;

  /// Message color
  ///
  /// In en, this message translates to:
  /// **'Message color'**
  String get messageColor;

  /// Show count of pieces in hand
  ///
  /// In en, this message translates to:
  /// **'Show count of unplaced pieces'**
  String get isPieceCountInHandShown;

  /// Show notations on board
  ///
  /// In en, this message translates to:
  /// **'Show notations on board'**
  String get isNotationsShown;

  /// Show history navigation toolbar
  ///
  /// In en, this message translates to:
  /// **'Show history navigation toolbar'**
  String get isHistoryNavigationToolbarShown;

  /// Display
  ///
  /// In en, this message translates to:
  /// **'Display'**
  String get display;

  /// Board borderline width
  ///
  /// In en, this message translates to:
  /// **'Board borderline width'**
  String get boardBorderLineWidth;

  /// Board inner line width
  ///
  /// In en, this message translates to:
  /// **'Board inner line width'**
  String get boardInnerLineWidth;

  /// Piece width
  ///
  /// In en, this message translates to:
  /// **'Piece width'**
  String get pieceWidth;

  /// Font size
  ///
  /// In en, this message translates to:
  /// **'Font size'**
  String get fontSize;

  /// Standard notation
  ///
  /// In en, this message translates to:
  /// **'WMD notation'**
  String get standardNotation;

  /// Restore
  ///
  /// In en, this message translates to:
  /// **'Restore'**
  String get restore;

  /// Restore Default Settings
  ///
  /// In en, this message translates to:
  /// **'Restore default settings'**
  String get restoreDefaultSettings;

  /// Used in the color picker.
  ///
  /// In en, this message translates to:
  /// **'Pick {element}'**
  String pick(Object element);

  /// Info
  ///
  /// In en, this message translates to:
  /// **'Info'**
  String get info;

  /// Hint
  ///
  /// In en, this message translates to:
  /// **'Hint'**
  String get hint;

  /// player
  ///
  /// In en, this message translates to:
  /// **'player'**
  String get player;

  /// Player 1
  ///
  /// In en, this message translates to:
  /// **'Player 1'**
  String get player1;

  /// Player 2
  ///
  /// In en, this message translates to:
  /// **'Player 2'**
  String get player2;

  /// How to play
  ///
  /// In en, this message translates to:
  /// **'How to Play'**
  String get howToPlay;

  /// Tap on any available point to place the piece.
  ///
  /// In en, this message translates to:
  /// **'Tap on any available point to place the piece.'**
  String get toPlacePiece;

  /// Tap on a piece to move it.
  ///
  /// In en, this message translates to:
  /// **'Tap on a piece to move it.'**
  String get toSelectPiece;

  /// Tap on point connected to piece to move it.
  ///
  /// In en, this message translates to:
  /// **'Tap on a point connected to a piece to move it.'**
  String get toMovePiece;

  /// Tap on one of the opponent's pieces to remove it.
  ///
  /// In en, this message translates to:
  /// **'Tap on one of the opponent\'s pieces to remove it.'**
  String get toRemovePiece;

  /// You need to create a mill first before you can remove a piece.
  ///
  /// In en, this message translates to:
  /// **'You need to create a mill first before you can remove a piece.'**
  String get needToCreateMillFirst;

  /// You need to play with your pieces.
  ///
  /// In en, this message translates to:
  /// **'You need to play with your pieces.'**
  String get needToPlayWithOwnPieces;

  /// Statistics
  ///
  /// In en, this message translates to:
  /// **'Statistics'**
  String get statistics;

  /// Total games
  ///
  /// In en, this message translates to:
  /// **'Total games'**
  String get totalGames;

  /// Results
  ///
  /// In en, this message translates to:
  /// **'Results'**
  String get results;

  /// left
  ///
  /// In en, this message translates to:
  /// **'left'**
  String get left;

  /// Privacy Policy
  ///
  /// In en, this message translates to:
  /// **'Privacy Policy'**
  String get privacyPolicy;

  /// Privacy Policy Detail 1
  ///
  /// In en, this message translates to:
  /// **'Please read carefully and make sure you fully understand and agree with this '**
  String get privacyPolicy_Detail_1;

  /// Privacy Policy Detail 2
  ///
  /// In en, this message translates to:
  /// **'. If you do not agree to this Policy, please do not use this app. Using the app implies that you accept these terms.'**
  String get privacyPolicy_Detail_2;

  /// No description provided for @and.
  ///
  /// In en, this message translates to:
  /// **' and '**
  String get and;

  /// Accept
  ///
  /// In en, this message translates to:
  /// **'Accept'**
  String get accept;

  /// Take back
  ///
  /// In en, this message translates to:
  /// **'Take back'**
  String get takeBack;

  /// Taking back...
  ///
  /// In en, this message translates to:
  /// **'Taking back…'**
  String get takingBack;

  /// Waiting...
  ///
  /// In en, this message translates to:
  /// **'Waiting…'**
  String get waiting;

  /// Step forward
  ///
  /// In en, this message translates to:
  /// **'Step forward'**
  String get stepForward;

  /// Take back all
  ///
  /// In en, this message translates to:
  /// **'Take back all'**
  String get takeBackAll;

  /// Step forward all
  ///
  /// In en, this message translates to:
  /// **'Step forward all'**
  String get stepForwardAll;

  /// Move now
  ///
  /// In en, this message translates to:
  /// **'Move now'**
  String get moveNow;

  /// Done.
  ///
  /// In en, this message translates to:
  /// **'Done.'**
  String get done;

  /// Crack-mill
  ///
  /// In en, this message translates to:
  /// **'Crack-mill'**
  String get crackMill;

  /// If a player has only pieces in mills, the pieces in the mills will not lock to remove.
  ///
  /// In en, this message translates to:
  /// **'If a player has only pieces in mills, the pieces in the mills will not lock to remove.'**
  String get crackMill_Detail;

  /// Animation duration
  ///
  /// In en, this message translates to:
  /// **'Animation duration'**
  String get animationDuration;

  /// None
  ///
  /// In en, this message translates to:
  /// **'None'**
  String get none;

  /// Theme
  ///
  /// In en, this message translates to:
  /// **'Theme'**
  String get theme;

  /// Help Content
  ///
  /// In en, this message translates to:
  /// **'The game aims to leave the opponent with fewer than three pieces or no legal moves.\n\nThe game automatically draws if a position occurs for the third time or makes no remove in the last 100 (configurable) moves.\n\nThe game proceeds in three phases:\n\n1. Placing pieces on vacant points\n2. Moving pieces to adjacent points\n3. (optional phase) Moving pieces to any vacant point when reducing the player to three pieces\n\nPlacing\n\nThe game begins with an empty board, which consists of a grid with twenty-four points. Players take turns placing their pieces on vacant points until each player has placed all pieces on the board. If a player can put three of his pieces straight, he has a \"mill\" and may remove one of his opponent\'s pieces from the board.\n\nIn some rule sets, players must remove any other pieces first before removing a piece from a formed mill.\n\nUnder certain rules, you cannot place pieces again on points where pieces have been removed.\n\nOnce all pieces have been placed, players take turns moving them.\n\nMoving\n\nTo move, a player moves one of his pieces along a board line to a vacant adjacent point. If he cannot, he loses the game. A player who aligns three of his pieces on a board line has a mill and may remove one of his opponent\'s pieces as in the placing phase. If a player is reduced to two pieces, has no option to form new mills, and thus loses the game. A player can also lose when more than three pieces if his opponent blocks them from moving.\n\nFlying\n\nIn some variants of the rules, once a player has only three pieces left, their pieces can fly, hop, or jump to any vacant points, not only adjacent ones.\n'**
  String get helpContent;

  /// Version info
  ///
  /// In en, this message translates to:
  /// **'Version info'**
  String get versionInfo;

  /// EULA
  ///
  /// In en, this message translates to:
  /// **'EULA'**
  String get eula;

  /// License
  ///
  /// In en, this message translates to:
  /// **'License'**
  String get license;

  /// Source code
  ///
  /// In en, this message translates to:
  /// **'Source code'**
  String get sourceCode;

  /// App Version
  ///
  /// In en, this message translates to:
  /// **'App Version'**
  String get appVersion;

  /// General
  ///
  /// In en, this message translates to:
  /// **'General'**
  String get general;

  /// Advanced
  ///
  /// In en, this message translates to:
  /// **'Advanced'**
  String get advanced;

  /// Placing
  ///
  /// In en, this message translates to:
  /// **'Placing'**
  String get placing;

  /// Moving
  ///
  /// In en, this message translates to:
  /// **'Moving'**
  String get moving;

  /// Removing
  ///
  /// In en, this message translates to:
  /// **'Removing'**
  String get removing;

  /// Game over condition
  ///
  /// In en, this message translates to:
  /// **'Game over condition'**
  String get gameOverCondition;

  /// AI's play style
  ///
  /// In en, this message translates to:
  /// **'AI\'s play style'**
  String get aisPlayStyle;

  /// Passive
  ///
  /// In en, this message translates to:
  /// **'Passive'**
  String get passive;

  /// Timeout
  ///
  /// In en, this message translates to:
  /// **'Timeout'**
  String get timeout;

  /// Appearance
  ///
  /// In en, this message translates to:
  /// **'Appearance'**
  String get appearance;

  /// Draw on the human experience
  ///
  /// In en, this message translates to:
  /// **'Draw on the human experience'**
  String get drawOnHumanExperience;

  /// Consider mobility of pieces
  ///
  /// In en, this message translates to:
  /// **'Consider mobility of pieces'**
  String get considerMobility;

  /// Piece count
  ///
  /// In en, this message translates to:
  /// **'Piece count:'**
  String get pieceCount;

  /// The pieces a player has in his hand.
  ///
  /// In en, this message translates to:
  /// **'{player} in hand: {count}'**
  String inHand(Object player, int count);

  /// The pieces a player has on the board
  ///
  /// In en, this message translates to:
  /// **'{player} on board: {count}'**
  String onBoard(Object player, int count);

  /// Board offset from the top
  ///
  /// In en, this message translates to:
  /// **'Board offset from the top'**
  String get boardTop;

  /// It is not the AI's turn.
  ///
  /// In en, this message translates to:
  /// **'It is not the AI\'s turn.'**
  String get notAIsTurn;

  /// AI is not thinking.
  ///
  /// In en, this message translates to:
  /// **'AI is not thinking.'**
  String get aiIsNotThinking;

  /// At the end of the move list.
  ///
  /// In en, this message translates to:
  /// **'You are at the end of the move list.'**
  String get atEnd;

  /// Tap Back again to exit.
  ///
  /// In en, this message translates to:
  /// **'Tap Back again to exit.'**
  String get tapBackAgainToLeave;

  /// More
  ///
  /// In en, this message translates to:
  /// **'More'**
  String get more;

  /// This is an experimental feature.
  ///
  /// In en, this message translates to:
  /// **'It is an experimental feature.'**
  String get experimental;

  /// Experiments
  ///
  /// In en, this message translates to:
  /// **'Experiments'**
  String get experiments;

  /// Open source licenses
  ///
  /// In en, this message translates to:
  /// **'Open-source licenses'**
  String get ossLicenses;

  /// Languages
  ///
  /// In en, this message translates to:
  /// **'Language'**
  String get language;

  /// Default language
  ///
  /// In en, this message translates to:
  /// **'Default language'**
  String get defaultLanguage;

  /// The pieces can move in the placing phase
  ///
  /// In en, this message translates to:
  /// **'The pieces can move in the placing phase'**
  String get mayMoveInPlacingPhase;

  /// There are no distinct placing and moving phases, i.e. the players can decide at every move whether they want to place a piece on the board or move one of their pieces (as long as they have remaining pieces to place).
  ///
  /// In en, this message translates to:
  /// **'There are no distinct placing and moving phases, i.e., the players can decide at every move whether they want to place a piece on the board or move one of their pieces (as long as they have remaining pieces to place).'**
  String get mayMoveInPlacingPhase_Detail;

  /// Menu color
  ///
  /// In en, this message translates to:
  /// **'Menu color'**
  String get drawerColor;

  /// Menu text color
  ///
  /// In en, this message translates to:
  /// **'Menu text color'**
  String get drawerTextColor;

  /// Menu highlight item color
  ///
  /// In en, this message translates to:
  /// **'Menu highlight item color'**
  String get drawerHighlightItemColor;

  /// Main toolbar background color
  ///
  /// In en, this message translates to:
  /// **'Main toolbar background color'**
  String get mainToolbarBackgroundColor;

  /// main toolbar icon color
  ///
  /// In en, this message translates to:
  /// **'Main toolbar icon color'**
  String get mainToolbarIconColor;

  /// Navigation toolbar background color
  ///
  /// In en, this message translates to:
  /// **'Navigation toolbar background color'**
  String get navigationToolbarBackgroundColor;

  /// Navigation toolbar icon color
  ///
  /// In en, this message translates to:
  /// **'Navigation toolbar icon color'**
  String get navigationToolbarIconColor;

  /// Automatically hide the toolbar
  ///
  /// In en, this message translates to:
  /// **'Automatically hide the toolbar'**
  String get autoHideToolbar;

  /// Toolbar location on screen
  ///
  /// In en, this message translates to:
  /// **'Toolbar location on screen'**
  String get toolbarLocationOnScreen;

  /// Top
  ///
  /// In en, this message translates to:
  /// **'Top'**
  String get top;

  /// Bottom
  ///
  /// In en, this message translates to:
  /// **'Bottom'**
  String get bottom;

  /// Center
  ///
  /// In en, this message translates to:
  /// **'Center'**
  String get center;

  /// Solid color
  ///
  /// In en, this message translates to:
  /// **'Solid color'**
  String get solidColor;

  /// Picture
  ///
  /// In en, this message translates to:
  /// **'Picture'**
  String get picture;

  /// Choose your picture
  ///
  /// In en, this message translates to:
  /// **'Choose your picture'**
  String get chooseYourPicture;

  /// Light
  ///
  /// In en, this message translates to:
  /// **'Light'**
  String get light;

  /// Dark
  ///
  /// In en, this message translates to:
  /// **'Dark'**
  String get dark;

  /// Themes
  ///
  /// In en, this message translates to:
  /// **'Themes'**
  String get themes;

  /// Current theme
  ///
  /// In en, this message translates to:
  /// **'Current theme'**
  String get currentTheme;

  /// Save theme
  ///
  /// In en, this message translates to:
  /// **'Save theme'**
  String get saveTheme;

  /// Show analysis graph
  ///
  /// In en, this message translates to:
  /// **'Show analysis graph'**
  String get showAnalysisGraph;

  /// Analysis
  ///
  /// In en, this message translates to:
  /// **'Analysis'**
  String get analysis;

  /// Save game
  ///
  /// In en, this message translates to:
  /// **'Save game'**
  String get saveGame;

  /// Load game
  ///
  /// In en, this message translates to:
  /// **'Load game'**
  String get loadGame;

  /// Setup position
  ///
  /// In en, this message translates to:
  /// **'Setup Position'**
  String get setupPosition;

  /// Show legal moves
  ///
  /// In en, this message translates to:
  /// **'Show legal moves'**
  String get showLegalMoves;

  /// Show last move
  ///
  /// In en, this message translates to:
  /// **'Show last move'**
  String get showLastMove;

  /// Show arrows
  ///
  /// In en, this message translates to:
  /// **'Show arrows'**
  String get showArrows;

  /// Pieces
  ///
  /// In en, this message translates to:
  /// **'Pieces'**
  String get pieces;

  /// Show analysis
  ///
  /// In en, this message translates to:
  /// **'Show analysis'**
  String get showAnalysis;

  /// Threads
  ///
  /// In en, this message translates to:
  /// **'Threads'**
  String get threads;

  /// Get Involved
  ///
  /// In en, this message translates to:
  /// **'Get Involved'**
  String get getInvolved;

  /// Help improve translate
  ///
  /// In en, this message translates to:
  /// **'Help improve translate'**
  String get helpImproveTranslate;

  /// Tutorial
  ///
  /// In en, this message translates to:
  /// **'Tutorial'**
  String get tutorial;

  /// Classic Mill
  ///
  /// In en, this message translates to:
  /// **'Classic Mill'**
  String get classicMill;

  /// Mixed Mill
  ///
  /// In en, this message translates to:
  /// **'Mixed Mill'**
  String get mixedMill;

  /// Ceylon Mill
  ///
  /// In en, this message translates to:
  /// **'Ceylon Mill'**
  String get ceylonMill;

  /// Mill may be broken and remade repeatedly
  ///
  /// In en, this message translates to:
  /// **'Mill may be broken and remade repeatedly'**
  String get mayBreakAndRemakeMillRepeatedly;

  /// If a player breaks a mill to immediately form a new one, they can move that piece back to the original point in their next move if it forms another new mill.
  ///
  /// In en, this message translates to:
  /// **'If a player breaks a mill to immediately form a new one, they can move that piece back to the original point in their next move if it forms another new mill.'**
  String get mayBreakAndRemakeMillRepeatedly_Detail;

  /// The game is drawn if a player has three pieces and after ten moves neither player removes the opponent's pieces
  ///
  /// In en, this message translates to:
  /// **'The game is drawn if a player has three pieces and after ten moves neither player removes the opponent\'s pieces'**
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft;

  /// When a player is down to three pieces, and neither player can remove an opponent's piece within ten moves, the game is a draw.
  ///
  /// In en, this message translates to:
  /// **'When a player is down to three pieces, and neither player can remove an opponent\'s piece within ten moves, the game is a draw.'**
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail;

  /// Close
  ///
  /// In en, this message translates to:
  /// **'Close'**
  String get close;

  /// White piece
  ///
  /// In en, this message translates to:
  /// **'White piece'**
  String get whitePiece;

  /// Black piece
  ///
  /// In en, this message translates to:
  /// **'Black piece'**
  String get blackPiece;

  /// Empty point
  ///
  /// In en, this message translates to:
  /// **'Empty point'**
  String get emptyPoint;

  /// No point
  ///
  /// In en, this message translates to:
  /// **'No point'**
  String get noPoint;

  /// Placing phase
  ///
  /// In en, this message translates to:
  /// **'Placing phase'**
  String get placingPhase;

  /// Moving phase
  ///
  /// In en, this message translates to:
  /// **'Moving phase'**
  String get movingPhase;

  /// Flying phase
  ///
  /// In en, this message translates to:
  /// **'Flying phase'**
  String get flyingPhase;

  /// The player whose turn it is.
  ///
  /// In en, this message translates to:
  /// **'Side to move: {player}'**
  String sideToMove(Object player);

  /// Last move
  ///
  /// In en, this message translates to:
  /// **'Last move: {move}'**
  String lastMove(Object move);

  /// Selected
  ///
  /// In en, this message translates to:
  /// **'Selected'**
  String get selected;

  /// Accessibility
  ///
  /// In en, this message translates to:
  /// **'Accessibility'**
  String get accessibility;

  /// Screen reader support
  ///
  /// In en, this message translates to:
  /// **'Screen reader support'**
  String get screenReaderSupport;

  /// It is a Draw!
  ///
  /// In en, this message translates to:
  /// **'It is a Draw!'**
  String get isDraw;

  /// Draw
  ///
  /// In en, this message translates to:
  /// **'Draw'**
  String get draw;

  /// Piece highlight color
  ///
  /// In en, this message translates to:
  /// **'Piece highlight color'**
  String get pieceHighlightColor;

  /// Algorithm
  ///
  /// In en, this message translates to:
  /// **'Algorithm'**
  String get algorithm;

  /// Endgame N-Move rule
  ///
  /// In en, this message translates to:
  /// **'Endgame N-Move rule'**
  String get endgameNMoveRule;

  /// If either player has only three pieces and neither player removes a piece within a specific moves, the game is drawn.
  ///
  /// In en, this message translates to:
  /// **'The game is drawn if either player has only three pieces and neither player removes a piece within specific moves.'**
  String get endgameNMoveRule_Detail;

  /// Either player has only three pieces and neither player removes a piece within a specific moves.
  ///
  /// In en, this message translates to:
  /// **'Either player has only three pieces, and neither player removes a piece within specific moves.'**
  String get drawReasonEndgameRule50;

  /// Threefold repetition rule
  ///
  /// In en, this message translates to:
  /// **'Threefold repetition rule'**
  String get threefoldRepetitionRule;

  /// The game is drawn if a position occurs for the third time.
  ///
  /// In en, this message translates to:
  /// **'The game is drawn if a position occurs for the third time.'**
  String get threefoldRepetitionRule_Detail;

  /// Mill! Continue to make a move.
  ///
  /// In en, this message translates to:
  /// **'Mill! Continue to make a move.'**
  String get continueToMakeMove;

  /// Point style
  ///
  /// In en, this message translates to:
  /// **'Point style'**
  String get pointStyle;

  /// Point width
  ///
  /// In en, this message translates to:
  /// **'Point width'**
  String get pointWidth;

  /// Solid
  ///
  /// In en, this message translates to:
  /// **'Solid'**
  String get solid;

  /// Hollow
  ///
  /// In en, this message translates to:
  /// **'Hollow'**
  String get hollow;

  /// The name of the current language
  ///
  /// In en, this message translates to:
  /// **'English'**
  String get languageName;

  /// Moves to take back
  ///
  /// In en, this message translates to:
  /// **'{count,plural, =0{Move}=1{{count} Move}other{{count} Moves}}'**
  String moveNumber(int count);

  /// Load failed.
  ///
  /// In en, this message translates to:
  /// **'Load failed.'**
  String get loadFailed;

  /// File name
  ///
  /// In en, this message translates to:
  /// **'File name'**
  String get filename;

  /// Browse…
  ///
  /// In en, this message translates to:
  /// **'Browse…'**
  String get browse;

  /// Game files
  ///
  /// In en, this message translates to:
  /// **'Game files'**
  String get gameFiles;

  /// The game is saved to
  ///
  /// In en, this message translates to:
  /// **'The game is saved to'**
  String get gameSavedTo;

  /// Empty point, used in setup position toolbar.
  ///
  /// In en, this message translates to:
  /// **'Empty'**
  String get empty;

  /// No move.
  ///
  /// In en, this message translates to:
  /// **'No move.'**
  String get noMove;

  /// Restored initial position.
  ///
  /// In en, this message translates to:
  /// **'Restored initial position.'**
  String get restoredPosition;

  /// Clean
  ///
  /// In en, this message translates to:
  /// **'Clean'**
  String get clean;

  /// Cleaned up.
  ///
  /// In en, this message translates to:
  /// **'Cleaned up.'**
  String get cleanedUp;

  /// Remove
  ///
  /// In en, this message translates to:
  /// **'Remove'**
  String get remove;

  /// No pieces can be removed.
  ///
  /// In en, this message translates to:
  /// **'No pieces can be removed.'**
  String get noPiecesCanBeRemoved;

  /// Pieces need to remove.
  ///
  /// In en, this message translates to:
  /// **'{count,plural, =0{Piece}=1{{count} piece}other{{count} pieces}} need to remove.'**
  String pieceCountNeedToRemove(int count);

  /// Placed N pieces. Used in setup position toolbar.
  ///
  /// In en, this message translates to:
  /// **'Placed ({count})'**
  String placedCount(int count);

  /// Placed piece count in the placing phase. Used in Semantics.
  ///
  /// In en, this message translates to:
  /// **'Placed piece count in the placing phase.'**
  String get placedPieceCount;

  /// Message describing how many pieces the current player has placed, with support for pluralization.
  ///
  /// In en, this message translates to:
  /// **'{count, plural, =0{The current player has placed no pieces.} =1{The current player has placed one piece.} other{The current player has placed {count} pieces.}}'**
  String hasPlacedPieceCount(int count);

  /// Not placing phase, cannot change it.
  ///
  /// In en, this message translates to:
  /// **'Not placing phase, cannot change it.'**
  String get notPlacingPhase;

  /// Paste
  ///
  /// In en, this message translates to:
  /// **'Paste'**
  String get paste;

  /// The paste is done.
  ///
  /// In en, this message translates to:
  /// **'The paste is done.'**
  String get pasteDone;

  /// Cannot paste.
  ///
  /// In en, this message translates to:
  /// **'Cannot paste.'**
  String get cannotPaste;

  /// Show unplaced and removed pieces
  ///
  /// In en, this message translates to:
  /// **'Show unplaced and removed pieces'**
  String get isUnplacedAndRemovedPiecesShown;

  /// Full screen
  ///
  /// In en, this message translates to:
  /// **'Full screen'**
  String get fullScreen;

  /// Exit and reopen app for settings to take effect.
  ///
  /// In en, this message translates to:
  /// **'Exit and reopen app for settings to take effect.'**
  String get reopenToTakeEffect;

  /// No description provided for @forest.
  ///
  /// In en, this message translates to:
  /// **'Forest'**
  String get forest;

  /// No description provided for @desktopImage.
  ///
  /// In en, this message translates to:
  /// **'Desktop Image'**
  String get desktopImage;

  /// No description provided for @invalidPosition.
  ///
  /// In en, this message translates to:
  /// **'Invalid position.'**
  String get invalidPosition;

  /// No description provided for @shareGIF.
  ///
  /// In en, this message translates to:
  /// **'Share GIF'**
  String get shareGIF;

  /// No description provided for @pixelRatio.
  ///
  /// In en, this message translates to:
  /// **'Pixel ratio'**
  String get pixelRatio;

  /// No description provided for @duration.
  ///
  /// In en, this message translates to:
  /// **'Duration'**
  String get duration;

  /// No description provided for @gameScreenRecorder.
  ///
  /// In en, this message translates to:
  /// **'Game screen recorder'**
  String get gameScreenRecorder;

  /// No description provided for @previous.
  ///
  /// In en, this message translates to:
  /// **'Previous'**
  String get previous;

  /// No description provided for @next.
  ///
  /// In en, this message translates to:
  /// **'Next'**
  String get next;

  /// No description provided for @skip.
  ///
  /// In en, this message translates to:
  /// **'Skip'**
  String get skip;

  /// No description provided for @gotIt.
  ///
  /// In en, this message translates to:
  /// **'Got it'**
  String get gotIt;

  /// No description provided for @youCanModifyRules.
  ///
  /// In en, this message translates to:
  /// **'You can modify the rules of the game in the rule settings.'**
  String get youCanModifyRules;

  /// No description provided for @youCanUseMouseWheelInPicker.
  ///
  /// In en, this message translates to:
  /// **'You can use the mouse wheel to adjust the value in the picker.'**
  String get youCanUseMouseWheelInPicker;

  /// No description provided for @noTimeLimitForThinking.
  ///
  /// In en, this message translates to:
  /// **'AI Thinking time set to 0 means there is no time limit for thinking.'**
  String get noTimeLimitForThinking;

  /// No description provided for @whatIsMtdf.
  ///
  /// In en, this message translates to:
  /// **'MTD(f) is a modified form of the alpha-beta search algorithm that aims to improve efficiency by reusing intermediate search results and using a good initial guess to narrow the search space.'**
  String get whatIsMtdf;

  /// No description provided for @noteAiThinkingTimeMayNotBePrecise.
  ///
  /// In en, this message translates to:
  /// **'Please be aware that the AI thinking time adjustment may not be entirely precise. The actual thinking time may be shorter when the difficulty level is set to a lower value and may be longer when the AI is mid-thought when the time runs out.'**
  String get noteAiThinkingTimeMayNotBePrecise;

  /// No description provided for @noteActualDifficultyLevelMayBeLimited.
  ///
  /// In en, this message translates to:
  /// **'If you set the difficulty level high but do not increase the AI thinking time, the actual difficulty level may be limited to a lower value due to the thinking time constraint. The actual value may vary based on the machine\'s performance.'**
  String get noteActualDifficultyLevelMayBeLimited;

  /// No description provided for @whatIsPvs.
  ///
  /// In en, this message translates to:
  /// **'PVS (Principal Variation Search) is a search algorithm to find the best move in a given position. It is an enhancement of the alpha-beta algorithm and uses null or zero window searches to confirm that a move is worse or not worse than an already safe score from the principal variation. PVS focuses on the most promising moves and avoids unnecessary searches of suboptimal branches, which helps improve the efficiency of the search.'**
  String get whatIsPvs;

  /// No description provided for @whatIsAlphaBeta.
  ///
  /// In en, this message translates to:
  /// **'The alpha-beta algorithm is a search algorithm to find the best move. It uses the minimax principle and two values, alpha and beta, to prune the search tree and increase efficiency. Alpha represents the minimum score the computer is sure it can get, while beta represents the maximum score its opponent can get. The algorithm helps the computer make smart, efficient decisions in a game.'**
  String get whatIsAlphaBeta;

  /// No description provided for @drawOnTheHumanExperienceDetail.
  ///
  /// In en, this message translates to:
  /// **'According to human experience, if you try to win, you will lose. Instead, aim for a draw as your goal and avoid losing the game. Observe your opponent and gently lure them into a position where they may make mistakes. When they show weakness, seize the opportunity and gently push for the win. In this way, you can win the game.'**
  String get drawOnTheHumanExperienceDetail;

  /// No description provided for @firstMoveDetail.
  ///
  /// In en, this message translates to:
  /// **'In this game, it is easier for the second player to win compared to the first player.'**
  String get firstMoveDetail;

  /// No description provided for @passiveDetail.
  ///
  /// In en, this message translates to:
  /// **'Enabling the Passive option will cause the AI to relax when it has an advantage in the position, rather than aggressively trying to win as quickly as possible.'**
  String get passiveDetail;

  /// No description provided for @moveRandomlyDetail.
  ///
  /// In en, this message translates to:
  /// **'Enabling this option increases the randomness and fun of the game while disabling it can help study ways to beat the AI.'**
  String get moveRandomlyDetail;

  /// No description provided for @considerMobilityOfPiecesDetail.
  ///
  /// In en, this message translates to:
  /// **'If the AI considers the mobility of its pieces, it will not only aim to capture the opponent\'s pieces as quickly as possible, but also consider blocking the opponent\'s movements and preventing them from doing the same.'**
  String get considerMobilityOfPiecesDetail;

  /// No description provided for @whenBoardIsFull.
  ///
  /// In en, this message translates to:
  /// **'When the board is full'**
  String get whenBoardIsFull;

  /// No description provided for @whenBoardIsFull_Detail.
  ///
  /// In en, this message translates to:
  /// **'At the end of the placing phase, before the moving phase begins, the action follows if the board is full of pieces.'**
  String get whenBoardIsFull_Detail;

  /// No description provided for @sideToMoveRemovePiece.
  ///
  /// In en, this message translates to:
  /// **'The player who moves first in the moving phase removes one of the opponent\'s pieces.'**
  String get sideToMoveRemovePiece;

  /// No description provided for @agreeToDraw.
  ///
  /// In en, this message translates to:
  /// **'Both sides agree to a draw.'**
  String get agreeToDraw;

  /// No description provided for @takeOpponentsPiece.
  ///
  /// In en, this message translates to:
  /// **'Take one of your opponent\'s pieces.'**
  String get takeOpponentsPiece;

  /// No description provided for @firstPlayerLose.
  ///
  /// In en, this message translates to:
  /// **'The first player loses the game.'**
  String get firstPlayerLose;

  /// No description provided for @firstAndSecondPlayerRemovePiece.
  ///
  /// In en, this message translates to:
  /// **'The first and second players remove one of the opponent\'s pieces.'**
  String get firstAndSecondPlayerRemovePiece;

  /// No description provided for @secondAndFirstPlayerRemovePiece.
  ///
  /// In en, this message translates to:
  /// **'The second and first players remove one of the opponent\'s pieces.'**
  String get secondAndFirstPlayerRemovePiece;

  /// No description provided for @enteredFlyingPhase.
  ///
  /// In en, this message translates to:
  /// **'Now entered the flying phase, the opponent\'s pieces can jump to any empty point on the board. You can turn off the flying rule in the \"Rule Settings\".'**
  String get enteredFlyingPhase;

  /// No description provided for @whenStalemate.
  ///
  /// In en, this message translates to:
  /// **'When stalemate'**
  String get whenStalemate;

  /// No description provided for @whenStalemate_Detail.
  ///
  /// In en, this message translates to:
  /// **'What action follows when no piece can be moved?'**
  String get whenStalemate_Detail;

  /// No description provided for @endWithStalemateLoss.
  ///
  /// In en, this message translates to:
  /// **'End with a stalemate loss for the side that is blocked.'**
  String get endWithStalemateLoss;

  /// No description provided for @changeSideToMove.
  ///
  /// In en, this message translates to:
  /// **'Change the side to move.'**
  String get changeSideToMove;

  /// No description provided for @removeOpponentsPieceAndMakeNextMove.
  ///
  /// In en, this message translates to:
  /// **'Remove one of the opponent\'s pieces and make the next move.'**
  String get removeOpponentsPieceAndMakeNextMove;

  /// No description provided for @endWithStalemateDraw.
  ///
  /// In en, this message translates to:
  /// **'End with a stalemate draw.'**
  String get endWithStalemateDraw;

  /// No description provided for @removeOpponentsPieceAndChangeSideToMove.
  ///
  /// In en, this message translates to:
  /// **'Remove one of the opponent\'s pieces and change the side to move.'**
  String get removeOpponentsPieceAndChangeSideToMove;

  /// No description provided for @aiResponseDelayTime.
  ///
  /// In en, this message translates to:
  /// **'AI response delay time'**
  String get aiResponseDelayTime;

  /// No description provided for @aiIsDelaying.
  ///
  /// In en, this message translates to:
  /// **'AI is currently in a delayed response phase. Please wait for a while before proceeding.'**
  String get aiIsDelaying;

  /// No description provided for @tipCanNotRemoveNonadjacent.
  ///
  /// In en, this message translates to:
  /// **'You cannot remove a nonadjacent piece.'**
  String get tipCanNotRemoveNonadjacent;

  /// No description provided for @stalemateRemovalRegardlessOfMillFormation.
  ///
  /// In en, this message translates to:
  /// **'In a stalemate, you can remove the opponent\'s pieces adjacent to yours, regardless of mill formation.'**
  String get stalemateRemovalRegardlessOfMillFormation;

  /// No description provided for @whatIsMcts.
  ///
  /// In en, this message translates to:
  /// **'MCTS is a beginner-friendly algorithm that makes decisions by exploring and evaluating different moves through simulations.'**
  String get whatIsMcts;

  /// No description provided for @goldenJade.
  ///
  /// In en, this message translates to:
  /// **'Golden Jade'**
  String get goldenJade;

  /// No description provided for @forestWood.
  ///
  /// In en, this message translates to:
  /// **'Forest Wood'**
  String get forestWood;

  /// No description provided for @darkMystery.
  ///
  /// In en, this message translates to:
  /// **'Dark Mystery'**
  String get darkMystery;

  /// No description provided for @midnightBlue.
  ///
  /// In en, this message translates to:
  /// **'Midnight Blue'**
  String get midnightBlue;

  /// No description provided for @greenForest.
  ///
  /// In en, this message translates to:
  /// **'Green Forest'**
  String get greenForest;

  /// No description provided for @greenMeadow.
  ///
  /// In en, this message translates to:
  /// **'Green Meadow'**
  String get greenMeadow;

  /// No description provided for @stonyPath.
  ///
  /// In en, this message translates to:
  /// **'Stony Path'**
  String get stonyPath;

  /// No description provided for @pastelPink.
  ///
  /// In en, this message translates to:
  /// **'Pastel Pink'**
  String get pastelPink;

  /// No description provided for @turquoiseSea.
  ///
  /// In en, this message translates to:
  /// **'Turquoise Sea'**
  String get turquoiseSea;

  /// No description provided for @violetDream.
  ///
  /// In en, this message translates to:
  /// **'Violet Dream'**
  String get violetDream;

  /// No description provided for @mintChocolate.
  ///
  /// In en, this message translates to:
  /// **'Mint Chocolate'**
  String get mintChocolate;

  /// No description provided for @skyBlue.
  ///
  /// In en, this message translates to:
  /// **'Sky Blue'**
  String get skyBlue;

  /// No description provided for @playfulGarden.
  ///
  /// In en, this message translates to:
  /// **'Playful Garden'**
  String get playfulGarden;

  /// No description provided for @whatIsRetrogradeAnalysis.
  ///
  /// In en, this message translates to:
  /// **'The Retrograde Analysis algorithm uses multi-valued retrograde analysis to build an endgame database from different start positions, then applies this database to optimize gameplay. This approach falls under the category of Ultra-Strong solutions.'**
  String get whatIsRetrogradeAnalysis;

  /// No description provided for @viewAlgorithmGuide.
  ///
  /// In en, this message translates to:
  /// **'Would you like to view the user guide for this algorithm?'**
  String get viewAlgorithmGuide;

  /// No description provided for @showPositionalAdvantageIndicator.
  ///
  /// In en, this message translates to:
  /// **'Show positional advantage indicator'**
  String get showPositionalAdvantageIndicator;

  /// No description provided for @usePerfectDatabase.
  ///
  /// In en, this message translates to:
  /// **'Use perfect database'**
  String get usePerfectDatabase;

  /// No description provided for @perfectDatabaseDescription.
  ///
  /// In en, this message translates to:
  /// **'Enable this option to use a flawless game database generated through cutting-edge algorithms. This feature integrates both opening and endgame strategies to suggest optimal moves. This is the preferred choice for players who seek the highest level of precision in gameplay. Created through meticulous computational techniques, the database is designed to offer near-perfect game solutions.\n\nNote: Should the AI fail to access the database, it will turn to conventional algorithms for gameplay decisions. When the database is available, the \'Difficulty Level\' becomes virtually unbeatable, and \'AI Thinking Time\' experiences a drastic reduction. Many settings within \'AI\'s play style\' options will be overridden, as the database outcomes hold the highest priority.\n\nFor guidance on how to make the most of this flawless database, click here.'**
  String get perfectDatabaseDescription;

  /// No description provided for @backgroundImage.
  ///
  /// In en, this message translates to:
  /// **'Background image'**
  String get backgroundImage;

  /// No description provided for @whatIsRandom.
  ///
  /// In en, this message translates to:
  /// **'When the \'Use perfect database\' option is not enabled, the \'Random\' setting causes the AI to move pieces randomly without using any algorithms for move selection. This typically results in significantly weaker gameplay. Conversely, when \'Use perfect database\' is enabled, the AI exclusively relies on the \'Perfect Database\' for making decisions, instead of blending it with traditional AI algorithms. In this mode, the AI\'s moves are entirely based on the database\'s content, eschewing reliance on real-time calculations or search algorithms.'**
  String get whatIsRandom;

  /// No description provided for @removeOpponentsPieceFromHandThenOpponentsTurn.
  ///
  /// In en, this message translates to:
  /// **'Remove the opponent\'s piece(s) from their hand; then it\'s the opponent\'s turn to place.'**
  String get removeOpponentsPieceFromHandThenOpponentsTurn;

  /// No description provided for @whenFormingMillsDuringPlacingPhase.
  ///
  /// In en, this message translates to:
  /// **'When forming mills during the placing phase'**
  String get whenFormingMillsDuringPlacingPhase;

  /// No description provided for @removeOpponentsPieceFromBoard.
  ///
  /// In en, this message translates to:
  /// **'Remove opponent\'s piece(s) from the board.'**
  String get removeOpponentsPieceFromBoard;

  /// No description provided for @removeOpponentsPieceFromBoard_Detail.
  ///
  /// In en, this message translates to:
  /// **'Remove the opponent\'s piece(s) from the board; then it\'s the opponent\'s turn to place.'**
  String get removeOpponentsPieceFromBoard_Detail;

  /// No description provided for @opponentRemovesOwnPiece.
  ///
  /// In en, this message translates to:
  /// **'The opponent removes their own piece(s) from the board.'**
  String get opponentRemovesOwnPiece;

  /// No description provided for @opponentRemovesOwnPiece_Detail.
  ///
  /// In en, this message translates to:
  /// **'Instead of you taking action, the opponent chooses and removes their own piece(s) from the board, effectively taking an action that is detrimental to themselves.'**
  String get opponentRemovesOwnPiece_Detail;

  /// No description provided for @removeOpponentsPieceFromHandThenYourTurn.
  ///
  /// In en, this message translates to:
  /// **'Remove the opponent\'s piece(s) from their hand, then it\'s your turn to move.'**
  String get removeOpponentsPieceFromHandThenYourTurn;

  /// No description provided for @removeOpponentsPieceFromHandThenYourTurn_Detail.
  ///
  /// In en, this message translates to:
  /// **'Remove piece(s) from the opponent\'s hand. If, according to the Multi-remove setting, multiple pieces are to be removed and the opponent has no pieces left in hand, continue removing the opponent\'s pieces from the board. Then, it\'s your turn to move. If you continue to form mills, you may keep removing the opponent\'s pieces.'**
  String get removeOpponentsPieceFromHandThenYourTurn_Detail;

  /// No description provided for @removeOpponentsPieceFromHandThenOpponentsTurn_Detail.
  ///
  /// In en, this message translates to:
  /// **'Remove piece(s) from the opponent\'s hand. If, according to the Multi-remove setting, multiple pieces are to be removed and the opponent has no pieces left in hand, continue removing the opponent\'s pieces from the board. Then, it\'s the opponent\'s turn to move.'**
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail;

  /// No description provided for @markAndDelayRemovingPieces.
  ///
  /// In en, this message translates to:
  /// **'Mark and delay removing pieces.'**
  String get markAndDelayRemovingPieces;

  /// No description provided for @markAndDelayRemovingPieces_Detail.
  ///
  /// In en, this message translates to:
  /// **'During the placing phase, the pieces to be removed are marked, and for both players, no new pieces can be placed on these points. Upon entering the moving phase, these marked pieces are removed altogether, and players can then move their pieces to these now-empty points.'**
  String get markAndDelayRemovingPieces_Detail;

  /// No description provided for @whenFormingMillsDuringPlacingPhase_Detail.
  ///
  /// In en, this message translates to:
  /// **'The actions that can be taken when forming mills during the placing phase.'**
  String get whenFormingMillsDuringPlacingPhase_Detail;

  /// No description provided for @marked.
  ///
  /// In en, this message translates to:
  /// **'Marked'**
  String get marked;

  /// No description provided for @menu.
  ///
  /// In en, this message translates to:
  /// **'Menu'**
  String get menu;

  /// No description provided for @monochrome.
  ///
  /// In en, this message translates to:
  /// **'Monochrome'**
  String get monochrome;

  /// No description provided for @youCanEnableScreenReaderSupport.
  ///
  /// In en, this message translates to:
  /// **'You can enable the Screen reader support switch in the Accessibility configuration in General Settings.'**
  String get youCanEnableScreenReaderSupport;

  /// No description provided for @showNumbersOnPieces.
  ///
  /// In en, this message translates to:
  /// **'Show numbers on pieces'**
  String get showNumbersOnPieces;

  /// No description provided for @saveImage.
  ///
  /// In en, this message translates to:
  /// **'Save Image'**
  String get saveImage;

  /// No description provided for @isAnalysisToolbarShown.
  ///
  /// In en, this message translates to:
  /// **'Show analysis toolbar'**
  String get isAnalysisToolbarShown;

  /// No description provided for @analysisToolbarBackgroundColor.
  ///
  /// In en, this message translates to:
  /// **'Analysis toolbar background color'**
  String get analysisToolbarBackgroundColor;

  /// No description provided for @analysisToolbarIconColor.
  ///
  /// In en, this message translates to:
  /// **'Analysis toolbar icon color'**
  String get analysisToolbarIconColor;

  /// No description provided for @transformed.
  ///
  /// In en, this message translates to:
  /// **'Transformed.'**
  String get transformed;

  /// No description provided for @cannotTransform.
  ///
  /// In en, this message translates to:
  /// **'Cannot transform.'**
  String get cannotTransform;

  /// No description provided for @rotate.
  ///
  /// In en, this message translates to:
  /// **'Rotate'**
  String get rotate;

  /// No description provided for @horizontalFlip.
  ///
  /// In en, this message translates to:
  /// **'H Flip'**
  String get horizontalFlip;

  /// No description provided for @verticalFlip.
  ///
  /// In en, this message translates to:
  /// **'V Flip'**
  String get verticalFlip;

  /// No description provided for @innerOuterFlip.
  ///
  /// In en, this message translates to:
  /// **'IO Flip'**
  String get innerOuterFlip;

  /// No description provided for @transparentCanvas.
  ///
  /// In en, this message translates to:
  /// **'Transparent Canvas'**
  String get transparentCanvas;

  /// No description provided for @restrictRepeatedMillsFormation.
  ///
  /// In en, this message translates to:
  /// **'Restrict repeated mills formation'**
  String get restrictRepeatedMillsFormation;

  /// No description provided for @restrictRepeatedMillsFormation_Detail.
  ///
  /// In en, this message translates to:
  /// **'A piece moved from one mill to form another cannot immediately return to the original point on the next turn to form a mill again. A different move is required first.'**
  String get restrictRepeatedMillsFormation_Detail;

  /// No description provided for @oneTimeUseMill.
  ///
  /// In en, this message translates to:
  /// **'One-time use mill'**
  String get oneTimeUseMill;

  /// No description provided for @oneTimeUseMill_Detail.
  ///
  /// In en, this message translates to:
  /// **'Each mill can remove an opponent\'s piece only once. You can reform it again, but it cannot be used for additional removals.'**
  String get oneTimeUseMill_Detail;

  /// No description provided for @currentRulesNoPerfectDatabase.
  ///
  /// In en, this message translates to:
  /// **'The current rules you have set do not have a corresponding perfect database. For more information about the perfect database, please click here.'**
  String get currentRulesNoPerfectDatabase;

  /// No description provided for @focusOnBlockingPaths.
  ///
  /// In en, this message translates to:
  /// **'Focus on blocking paths'**
  String get focusOnBlockingPaths;

  /// No description provided for @focusOnBlockingPaths_Detail.
  ///
  /// In en, this message translates to:
  /// **'During specific phases of the game, prioritize obstructing the opponent\'s movement over forming mills. Instead of focusing on removing pieces by completing mills, the AI aims to trap the opponent during these phases, rendering them unable to move and securing a win through attrition rather than aggressive play. This phase-specific strategy does not actively block the opponent\'s mills.'**
  String get focusOnBlockingPaths_Detail;

  /// No description provided for @pieceImage.
  ///
  /// In en, this message translates to:
  /// **'Piece image'**
  String get pieceImage;

  /// No description provided for @importColorSettings.
  ///
  /// In en, this message translates to:
  /// **'Import color settings'**
  String get importColorSettings;

  /// No description provided for @exportColorSettings.
  ///
  /// In en, this message translates to:
  /// **'Export color settings'**
  String get exportColorSettings;

  /// No description provided for @import.
  ///
  /// In en, this message translates to:
  /// **'Import'**
  String get import;

  /// No description provided for @export.
  ///
  /// In en, this message translates to:
  /// **'Export'**
  String get export;

  /// No description provided for @pleaseCopyJsonToClipboard.
  ///
  /// In en, this message translates to:
  /// **'Please copy the JSON format settings to the clipboard first.'**
  String get pleaseCopyJsonToClipboard;

  /// No description provided for @copiedToClipboard.
  ///
  /// In en, this message translates to:
  /// **'Copied to clipboard.'**
  String get copiedToClipboard;

  /// No description provided for @imported.
  ///
  /// In en, this message translates to:
  /// **'Imported.'**
  String get imported;

  /// No description provided for @boardImage.
  ///
  /// In en, this message translates to:
  /// **'Board image'**
  String get boardImage;

  /// No description provided for @autumnLeaves.
  ///
  /// In en, this message translates to:
  /// **'Autumn Leaves'**
  String get autumnLeaves;

  /// No description provided for @legendaryLand.
  ///
  /// In en, this message translates to:
  /// **'Legendary Land'**
  String get legendaryLand;

  /// No description provided for @vignetteEffect.
  ///
  /// In en, this message translates to:
  /// **'Vignette effect'**
  String get vignetteEffect;

  /// No description provided for @promptMakeToolbarTransparent.
  ///
  /// In en, this message translates to:
  /// **'Would you like to make the toolbar fully transparent when a board background image is set?'**
  String get promptMakeToolbarTransparent;

  /// No description provided for @vibration.
  ///
  /// In en, this message translates to:
  /// **'Enable vibration in the game'**
  String get vibration;

  /// No description provided for @soundTheme.
  ///
  /// In en, this message translates to:
  /// **'Sound theme'**
  String get soundTheme;

  /// No description provided for @ball.
  ///
  /// In en, this message translates to:
  /// **'Ball'**
  String get ball;

  /// No description provided for @liquid.
  ///
  /// In en, this message translates to:
  /// **'Liquid'**
  String get liquid;

  /// No description provided for @wood.
  ///
  /// In en, this message translates to:
  /// **'Wood'**
  String get wood;

  /// No description provided for @placeEffectAnimation.
  ///
  /// In en, this message translates to:
  /// **'Piece placing animation effect'**
  String get placeEffectAnimation;

  /// No description provided for @removeEffectAnimation.
  ///
  /// In en, this message translates to:
  /// **'Piece removing animation effect'**
  String get removeEffectAnimation;

  /// No description provided for @isToolbarAtBottom.
  ///
  /// In en, this message translates to:
  /// **'Show toolbar at bottom'**
  String get isToolbarAtBottom;

  /// No description provided for @boardCornerRadius.
  ///
  /// In en, this message translates to:
  /// **'Board corner radius'**
  String get boardCornerRadius;

  /// No description provided for @useOpeningBook.
  ///
  /// In en, this message translates to:
  /// **'Use opening book'**
  String get useOpeningBook;

  /// No description provided for @currentRule.
  ///
  /// In en, this message translates to:
  /// **'Current'**
  String get currentRule;

  /// No description provided for @nineMensMorris.
  ///
  /// In en, this message translates to:
  /// **'Nine Men\'s Morris'**
  String get nineMensMorris;

  /// No description provided for @twelveMensMorris.
  ///
  /// In en, this message translates to:
  /// **'Twelve Men\'s Morris'**
  String get twelveMensMorris;

  /// No description provided for @morabaraba.
  ///
  /// In en, this message translates to:
  /// **'Morabaraba'**
  String get morabaraba;

  /// No description provided for @dooz.
  ///
  /// In en, this message translates to:
  /// **'Dooz'**
  String get dooz;

  /// No description provided for @chamGonu.
  ///
  /// In en, this message translates to:
  /// **'Cham Gonu'**
  String get chamGonu;

  /// No description provided for @zhiQi.
  ///
  /// In en, this message translates to:
  /// **'Zhi Qi'**
  String get zhiQi;

  /// No description provided for @chengSanQi.
  ///
  /// In en, this message translates to:
  /// **'Cheng San Qi'**
  String get chengSanQi;

  /// No description provided for @mulMulan.
  ///
  /// In en, this message translates to:
  /// **'Mul-Mulan'**
  String get mulMulan;

  /// No description provided for @nerenchi.
  ///
  /// In en, this message translates to:
  /// **'Nerenchi'**
  String get nerenchi;

  /// No description provided for @ruleSet.
  ///
  /// In en, this message translates to:
  /// **'Rule set'**
  String get ruleSet;

  /// No description provided for @laskerMorris.
  ///
  /// In en, this message translates to:
  /// **'Lasker Morris'**
  String get laskerMorris;

  /// No description provided for @oneTimeMill.
  ///
  /// In en, this message translates to:
  /// **'One-Time Mill'**
  String get oneTimeMill;

  /// No description provided for @daSanQi.
  ///
  /// In en, this message translates to:
  /// **'Da San Qi'**
  String get daSanQi;

  /// No description provided for @useOpeningBook_Detail.
  ///
  /// In en, this message translates to:
  /// **'Let the AI use opening moves commonly employed by professional human players during the early game. Note: This feature is currently available only for specific rule sets.'**
  String get useOpeningBook_Detail;

  /// No description provided for @showAdvantageGraph.
  ///
  /// In en, this message translates to:
  /// **'Show advantage graph'**
  String get showAdvantageGraph;

  /// No description provided for @advantageGraphHint.
  ///
  /// In en, this message translates to:
  /// **'Advantage graph will only be drawn after the AI makes a move. It will not be drawn when the human player makes a move.'**
  String get advantageGraphHint;

  /// No description provided for @removalBasedOnMillCounts.
  ///
  /// In en, this message translates to:
  /// **'Disable removal until all pieces have been placed, then remove pieces based on mill counts.'**
  String get removalBasedOnMillCounts;

  /// No description provided for @removalBasedOnMillCounts_Detail.
  ///
  /// In en, this message translates to:
  /// **'Disable removal until all pieces have been placed, then remove pieces based on mill counts: if they are equal, both remove the same number; if one has more, they remove one extra, keeping a one-piece difference. If only one forms mills, they remove two pieces, and the other removes one. If neither forms mills, both remove one of their own pieces.'**
  String get removalBasedOnMillCounts_Detail;

  /// No description provided for @elfilja.
  ///
  /// In en, this message translates to:
  /// **'El Filja'**
  String get elfilja;

  /// No description provided for @tipSelectOwnPiece.
  ///
  /// In en, this message translates to:
  /// **'Select one of your pieces.'**
  String get tipSelectOwnPiece;

  /// No description provided for @notYourTurn.
  ///
  /// In en, this message translates to:
  /// **'It\'s not your turn.'**
  String get notYourTurn;

  /// No description provided for @annotationToolbarBackgroundColor.
  ///
  /// In en, this message translates to:
  /// **'Annotation toolbar background color'**
  String get annotationToolbarBackgroundColor;

  /// No description provided for @annotationToolbarIconColor.
  ///
  /// In en, this message translates to:
  /// **'Annotation toolbar icon color'**
  String get annotationToolbarIconColor;

  /// No description provided for @isAnnotationToolbarShown.
  ///
  /// In en, this message translates to:
  /// **'Show annotation toolbar'**
  String get isAnnotationToolbarShown;

  /// No description provided for @enterAnnotationMode.
  ///
  /// In en, this message translates to:
  /// **'Enter annotation mode'**
  String get enterAnnotationMode;

  /// No description provided for @areYouSureYouWantToClearAllAnnotations.
  ///
  /// In en, this message translates to:
  /// **'Are you sure you want to clear all annotations?'**
  String get areYouSureYouWantToClearAllAnnotations;

  /// No description provided for @llmPromptCopiedToClipboard.
  ///
  /// In en, this message translates to:
  /// **'LLM prompt copied to clipboard.'**
  String get llmPromptCopiedToClipboard;

  /// No description provided for @connectionRefusedTheServerMayBeDown.
  ///
  /// In en, this message translates to:
  /// **'Connection refused, the server may be down.'**
  String get connectionRefusedTheServerMayBeDown;

  /// No description provided for @discoverySuccessfulAwaitingConnection.
  ///
  /// In en, this message translates to:
  /// **'Discovery successful, awaiting connection...'**
  String get discoverySuccessfulAwaitingConnection;

  /// No description provided for @noLanConnection.
  ///
  /// In en, this message translates to:
  /// **'No LAN connection'**
  String get noLanConnection;

  /// No description provided for @takeScreenshot.
  ///
  /// In en, this message translates to:
  /// **'Take Screenshot'**
  String get takeScreenshot;

  /// No description provided for @disconnectedFromOpponent.
  ///
  /// In en, this message translates to:
  /// **'Disconnected from opponent.'**
  String get disconnectedFromOpponent;

  /// No description provided for @takeBackRequest.
  ///
  /// In en, this message translates to:
  /// **'Take Back Request'**
  String get takeBackRequest;

  /// No description provided for @nothingToShow.
  ///
  /// In en, this message translates to:
  /// **'Nothing to show.'**
  String get nothingToShow;

  /// No description provided for @stopHosting.
  ///
  /// In en, this message translates to:
  /// **'Stop Hosting'**
  String get stopHosting;

  /// No description provided for @connectionResetByPeer.
  ///
  /// In en, this message translates to:
  /// **'Connection reset by peer.'**
  String get connectionResetByPeer;

  /// No description provided for @connectionLostDueToHeartbeatTimeoutPleaseReconnect.
  ///
  /// In en, this message translates to:
  /// **'Connection lost due to heartbeat timeout. Please reconnect.'**
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect;

  /// No description provided for @startHosting.
  ///
  /// In en, this message translates to:
  /// **'Start Hosting'**
  String get startHosting;

  /// No description provided for @restartRequestRejected.
  ///
  /// In en, this message translates to:
  /// **'Restart request rejected.'**
  String get restartRequestRejected;

  /// No description provided for @notConnectedToLanOpponent.
  ///
  /// In en, this message translates to:
  /// **'Not connected to LAN opponent.'**
  String get notConnectedToLanOpponent;

  /// No description provided for @llmPrompt.
  ///
  /// In en, this message translates to:
  /// **'LLM prompt'**
  String get llmPrompt;

  /// No description provided for @gameRestarted.
  ///
  /// In en, this message translates to:
  /// **'Game restarted.'**
  String get gameRestarted;

  /// No description provided for @takeBackRejected.
  ///
  /// In en, this message translates to:
  /// **'Take back rejected.'**
  String get takeBackRejected;

  /// No description provided for @areYouSureYouWantToResignThisGame.
  ///
  /// In en, this message translates to:
  /// **'Are you sure you want to resign this game?'**
  String get areYouSureYouWantToResignThisGame;

  /// No description provided for @opponentResignedYouWin.
  ///
  /// In en, this message translates to:
  /// **'Opponent resigned. You win!'**
  String get opponentResignedYouWin;

  /// No description provided for @clearAllAnnotations.
  ///
  /// In en, this message translates to:
  /// **'Clear all annotations'**
  String get clearAllAnnotations;

  /// No description provided for @connectedWaitingForOpponentSMove.
  ///
  /// In en, this message translates to:
  /// **'Connected, waiting for opponent\'s move...'**
  String get connectedWaitingForOpponentSMove;

  /// No description provided for @networkStatusDisconnected.
  ///
  /// In en, this message translates to:
  /// **'Network status: Disconnected'**
  String get networkStatusDisconnected;

  /// No description provided for @takeBackRequestSentToTheOpponent.
  ///
  /// In en, this message translates to:
  /// **'Take back request sent to the opponent.'**
  String get takeBackRequestSentToTheOpponent;

  /// No description provided for @theOpponentMayHaveLeftTheGame.
  ///
  /// In en, this message translates to:
  /// **'The opponent may have left the game'**
  String get theOpponentMayHaveLeftTheGame;

  /// No description provided for @connectedToHostSuccessfully.
  ///
  /// In en, this message translates to:
  /// **'Connected to host successfully.'**
  String get connectedToHostSuccessfully;

  /// No description provided for @connectionLostHeartbeatTimeout.
  ///
  /// In en, this message translates to:
  /// **'Connection lost: heartbeat timeout'**
  String get connectionLostHeartbeatTimeout;

  /// No description provided for @noHostDiscovered.
  ///
  /// In en, this message translates to:
  /// **'No host discovered.'**
  String get noHostDiscovered;

  /// No description provided for @confirmResignation.
  ///
  /// In en, this message translates to:
  /// **'Confirm resignation'**
  String get confirmResignation;

  /// No description provided for @startedHostingGameWaitingForPlayersToJoin.
  ///
  /// In en, this message translates to:
  /// **'Started hosting game, waiting for players to join...'**
  String get startedHostingGameWaitingForPlayersToJoin;

  /// No description provided for @connectionTimedOutNetworkConnectionUnstable.
  ///
  /// In en, this message translates to:
  /// **'Connection timed out, network connection unstable.'**
  String get connectionTimedOutNetworkConnectionUnstable;

  /// No description provided for @noLlmPromptAvailable.
  ///
  /// In en, this message translates to:
  /// **'No LLM prompt available.'**
  String get noLlmPromptAvailable;

  /// No description provided for @youResignedGameOver.
  ///
  /// In en, this message translates to:
  /// **'You resigned. Game over.'**
  String get youResignedGameOver;

  /// No description provided for @serverIp.
  ///
  /// In en, this message translates to:
  /// **'Server IP'**
  String get serverIp;

  /// No description provided for @confirmClear.
  ///
  /// In en, this message translates to:
  /// **'Confirm clear'**
  String get confirmClear;

  /// No description provided for @opponentSTurn.
  ///
  /// In en, this message translates to:
  /// **'Opponent\'s turn.'**
  String get opponentSTurn;

  /// No description provided for @waitingAClientConnection.
  ///
  /// In en, this message translates to:
  /// **'Waiting a client connection...'**
  String get waitingAClientConnection;

  /// No description provided for @takeBackRequestWasRejectedOrFailed.
  ///
  /// In en, this message translates to:
  /// **'Take back request was rejected or failed.'**
  String get takeBackRequestWasRejectedOrFailed;

  /// No description provided for @addText.
  ///
  /// In en, this message translates to:
  /// **'Add text'**
  String get addText;

  /// No description provided for @exitAnnotationMode.
  ///
  /// In en, this message translates to:
  /// **'Exit annotation mode'**
  String get exitAnnotationMode;

  /// No description provided for @typeYourAnnotation.
  ///
  /// In en, this message translates to:
  /// **'Type your annotation'**
  String get typeYourAnnotation;

  /// No description provided for @attemptingToReconnect.
  ///
  /// In en, this message translates to:
  /// **'Attempting to reconnect...'**
  String get attemptingToReconnect;

  /// No description provided for @restartRequestSentWaitingForOpponentSResponse.
  ///
  /// In en, this message translates to:
  /// **'Restart request sent. Waiting for opponent\'s response...'**
  String get restartRequestSentWaitingForOpponentSResponse;

  /// No description provided for @serverIsStopped.
  ///
  /// In en, this message translates to:
  /// **'Server is stopped.'**
  String get serverIsStopped;

  /// No description provided for @restartRequest.
  ///
  /// In en, this message translates to:
  /// **'Restart request'**
  String get restartRequest;

  /// No description provided for @cannotRequestATakeBackWhenItSNotYourTurn.
  ///
  /// In en, this message translates to:
  /// **'Cannot request a take back when it\'s not your turn.'**
  String get cannotRequestATakeBackWhenItSNotYourTurn;

  /// No description provided for @takeBackAccepted.
  ///
  /// In en, this message translates to:
  /// **'Take back accepted.'**
  String get takeBackAccepted;

  /// No description provided for @localNetworkSettings.
  ///
  /// In en, this message translates to:
  /// **'Local network settings'**
  String get localNetworkSettings;

  /// No description provided for @reconnectedSuccessfully.
  ///
  /// In en, this message translates to:
  /// **'Reconnected successfully!'**
  String get reconnectedSuccessfully;

  /// No description provided for @failedToSaveImageToGallery.
  ///
  /// In en, this message translates to:
  /// **'Failed to save image to Gallery.'**
  String get failedToSaveImageToGallery;

  /// No description provided for @opponentRequestedToRestartTheGameDoYouAccept.
  ///
  /// In en, this message translates to:
  /// **'Opponent requested to restart the game. Do you accept?'**
  String get opponentRequestedToRestartTheGameDoYouAccept;

  /// No description provided for @yourTurn.
  ///
  /// In en, this message translates to:
  /// **'Your turn.'**
  String get yourTurn;

  /// No description provided for @unableToReconnectPleaseRestartTheGame.
  ///
  /// In en, this message translates to:
  /// **'Unable to reconnect, please restart the game.'**
  String get unableToReconnectPleaseRestartTheGame;

  /// No description provided for @host.
  ///
  /// In en, this message translates to:
  /// **'Host'**
  String get host;

  /// No description provided for @join.
  ///
  /// In en, this message translates to:
  /// **'Join'**
  String get join;

  /// No description provided for @port.
  ///
  /// In en, this message translates to:
  /// **'Port'**
  String get port;

  /// No description provided for @invalidIpAddress.
  ///
  /// In en, this message translates to:
  /// **'Invalid IP address.'**
  String get invalidIpAddress;

  /// No description provided for @invalidPort.
  ///
  /// In en, this message translates to:
  /// **'Invalid port.'**
  String get invalidPort;

  /// No description provided for @connectingAttempt.
  ///
  /// In en, this message translates to:
  /// **'Connecting: Attempt {attempt}/{maxAttempt}'**
  String connectingAttempt(Object attempt, Object maxAttempt);

  /// No description provided for @failedToConnect.
  ///
  /// In en, this message translates to:
  /// **'Failed to connect: {error}'**
  String failedToConnect(Object error);

  /// No description provided for @failedToStartHosting.
  ///
  /// In en, this message translates to:
  /// **'Failed to start hosting: {error}'**
  String failedToStartHosting(Object error);

  /// No description provided for @hostDiscovered.
  ///
  /// In en, this message translates to:
  /// **'Host discovered: {ip}:{port}'**
  String hostDiscovered(Object ip, Object port);

  /// No description provided for @stop.
  ///
  /// In en, this message translates to:
  /// **'Stop'**
  String get stop;

  /// No description provided for @discover.
  ///
  /// In en, this message translates to:
  /// **'Discover'**
  String get discover;

  /// No description provided for @connect.
  ///
  /// In en, this message translates to:
  /// **'Connect'**
  String get connect;

  /// No description provided for @clientConnected.
  ///
  /// In en, this message translates to:
  /// **'Client connected: {clientIp}:{clientPort}'**
  String clientConnected(Object clientIp, Object clientPort);

  /// No description provided for @discoveringSeconds.
  ///
  /// In en, this message translates to:
  /// **'Discovering: {seconds} s'**
  String discoveringSeconds(Object seconds);

  /// No description provided for @reconnecting.
  ///
  /// In en, this message translates to:
  /// **'Reconnecting ({attempt}/{maxAttempts})'**
  String reconnecting(Object attempt, Object maxAttempts);

  /// No description provided for @connected.
  ///
  /// In en, this message translates to:
  /// **'Connected'**
  String get connected;

  /// No description provided for @delete.
  ///
  /// In en, this message translates to:
  /// **'Delete'**
  String get delete;

  /// No description provided for @ancientEgypt.
  ///
  /// In en, this message translates to:
  /// **'Ancient Egypt'**
  String get ancientEgypt;

  /// No description provided for @gothicIce.
  ///
  /// In en, this message translates to:
  /// **'Gothic Ice'**
  String get gothicIce;

  /// No description provided for @riceField.
  ///
  /// In en, this message translates to:
  /// **'Rice Field'**
  String get riceField;

  /// No description provided for @chinesePorcelain.
  ///
  /// In en, this message translates to:
  /// **'Chinese Porcelain'**
  String get chinesePorcelain;

  /// No description provided for @desertDusk.
  ///
  /// In en, this message translates to:
  /// **'Desert Dusk'**
  String get desertDusk;

  /// No description provided for @precisionCraft.
  ///
  /// In en, this message translates to:
  /// **'Precision Craft'**
  String get precisionCraft;

  /// No description provided for @folkEmbroidery.
  ///
  /// In en, this message translates to:
  /// **'Folk Embroidery'**
  String get folkEmbroidery;

  /// No description provided for @carpathianHeritage.
  ///
  /// In en, this message translates to:
  /// **'Carpathian Heritage'**
  String get carpathianHeritage;

  /// No description provided for @imperialGrandeur.
  ///
  /// In en, this message translates to:
  /// **'Imperial Grandeur'**
  String get imperialGrandeur;

  /// No description provided for @bohemianCrystal.
  ///
  /// In en, this message translates to:
  /// **'Bohemian Crystal'**
  String get bohemianCrystal;

  /// No description provided for @savannaSunrise.
  ///
  /// In en, this message translates to:
  /// **'Savanna Sunrise'**
  String get savannaSunrise;

  /// No description provided for @harmonyBalance.
  ///
  /// In en, this message translates to:
  /// **'Harmony Balance'**
  String get harmonyBalance;

  /// No description provided for @cinnamonSpice.
  ///
  /// In en, this message translates to:
  /// **'Cinnamon Spice'**
  String get cinnamonSpice;

  /// No description provided for @anatolianMosaic.
  ///
  /// In en, this message translates to:
  /// **'Anatolian Mosaic'**
  String get anatolianMosaic;

  /// No description provided for @carnivalSpirit.
  ///
  /// In en, this message translates to:
  /// **'Carnival Spirit'**
  String get carnivalSpirit;

  /// No description provided for @custom.
  ///
  /// In en, this message translates to:
  /// **'Custom'**
  String get custom;

  /// No description provided for @spiceMarket.
  ///
  /// In en, this message translates to:
  /// **'Spice Market'**
  String get spiceMarket;

  /// No description provided for @swipeToRevealTheDrawer.
  ///
  /// In en, this message translates to:
  /// **'Swipe to reveal the Drawer'**
  String get swipeToRevealTheDrawer;

  /// No description provided for @showGameInfoOnScreenshots.
  ///
  /// In en, this message translates to:
  /// **'Show game info on screenshots'**
  String get showGameInfoOnScreenshots;

  /// No description provided for @humanMoveTime.
  ///
  /// In en, this message translates to:
  /// **'Human time limit'**
  String get humanMoveTime;

  /// No description provided for @noTimeLimitForHumanMoves.
  ///
  /// In en, this message translates to:
  /// **'No time limit for human moves'**
  String get noTimeLimitForHumanMoves;

  /// No description provided for @timeoutLoseWillBeApplied.
  ///
  /// In en, this message translates to:
  /// **'Timeout lose will be applied for human player'**
  String get timeoutLoseWillBeApplied;

  /// No description provided for @identifyingBoard.
  ///
  /// In en, this message translates to:
  /// **'Identifying board...'**
  String get identifyingBoard;

  /// No description provided for @youCanEnterAnyModelName.
  ///
  /// In en, this message translates to:
  /// **'You can enter any model name.'**
  String get youCanEnterAnyModelName;

  /// No description provided for @boardPositionAppliedFenCopiedToClipboard.
  ///
  /// In en, this message translates to:
  /// **'Board position applied. FEN copied to clipboard.'**
  String get boardPositionAppliedFenCopiedToClipboard;

  /// No description provided for @suggestionTryTakingAClearerPictureOfTheBoard.
  ///
  /// In en, this message translates to:
  /// **'Suggestion: try taking a clearer picture of the board.'**
  String get suggestionTryTakingAClearerPictureOfTheBoard;

  /// No description provided for @llmPromptTemplate.
  ///
  /// In en, this message translates to:
  /// **'LLM prompt template'**
  String get llmPromptTemplate;

  /// No description provided for @noValidBoardDetected.
  ///
  /// In en, this message translates to:
  /// **'No valid board detected.'**
  String get noValidBoardDetected;

  /// No description provided for @selectingImageFromAlbum.
  ///
  /// In en, this message translates to:
  /// **'Selecting image from album...'**
  String get selectingImageFromAlbum;

  /// No description provided for @configurePromptTemplate.
  ///
  /// In en, this message translates to:
  /// **'Configure prompt template'**
  String get configurePromptTemplate;

  /// No description provided for @editPromptTemplateForLlmAnalysis.
  ///
  /// In en, this message translates to:
  /// **'Edit prompt template for LLM analysis'**
  String get editPromptTemplateForLlmAnalysis;

  /// No description provided for @failedToGenerateFenFromRecognizedBoard.
  ///
  /// In en, this message translates to:
  /// **'Failed to generate FEN from recognized board.'**
  String get failedToGenerateFenFromRecognizedBoard;

  /// No description provided for @outputInCurrentLanguage.
  ///
  /// In en, this message translates to:
  /// **'Output in current language'**
  String get outputInCurrentLanguage;

  /// No description provided for @commonBaseUrls.
  ///
  /// In en, this message translates to:
  /// **'Common base URLs'**
  String get commonBaseUrls;

  /// No description provided for @viewCommonModels.
  ///
  /// In en, this message translates to:
  /// **'View common models'**
  String get viewCommonModels;

  /// No description provided for @recognitionParametersUpdated.
  ///
  /// In en, this message translates to:
  /// **'Recognition parameters updated.'**
  String get recognitionParametersUpdated;

  /// No description provided for @whiteSMove.
  ///
  /// In en, this message translates to:
  /// **'White\'s move'**
  String get whiteSMove;

  /// No description provided for @resetToDefaults.
  ///
  /// In en, this message translates to:
  /// **'Reset to defaults'**
  String get resetToDefaults;

  /// No description provided for @photoShoot.
  ///
  /// In en, this message translates to:
  /// **'Photo shoot'**
  String get photoShoot;

  /// No description provided for @failedToApplyRecognizedBoardPosition.
  ///
  /// In en, this message translates to:
  /// **'Failed to apply recognized board position.'**
  String get failedToApplyRecognizedBoardPosition;

  /// No description provided for @llmPromptContent.
  ///
  /// In en, this message translates to:
  /// **'LLM prompt content'**
  String get llmPromptContent;

  /// No description provided for @llmNotConfiguredPleaseCheckYourSettings.
  ///
  /// In en, this message translates to:
  /// **'LLM not configured. Please check your settings.'**
  String get llmNotConfiguredPleaseCheckYourSettings;

  /// No description provided for @setProviderModelApiKeyAndBaseUrl.
  ///
  /// In en, this message translates to:
  /// **'Set provider, model, API Key, and Base URL'**
  String get setProviderModelApiKeyAndBaseUrl;

  /// No description provided for @llmConfiguration.
  ///
  /// In en, this message translates to:
  /// **'LLM configuration'**
  String get llmConfiguration;

  /// No description provided for @configureLlmProvider.
  ///
  /// In en, this message translates to:
  /// **'Configure LLM provider'**
  String get configureLlmProvider;

  /// No description provided for @llmPromptTemplateHeader.
  ///
  /// In en, this message translates to:
  /// **'LLM prompt template header'**
  String get llmPromptTemplateHeader;

  /// No description provided for @noPiecesWereRecognizedInTheImagePleaseTryAgain.
  ///
  /// In en, this message translates to:
  /// **'No pieces were recognized in the image. Please try again.'**
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain;

  /// No description provided for @recognizeBoardFromImage.
  ///
  /// In en, this message translates to:
  /// **'Recognize board from image'**
  String get recognizeBoardFromImage;

  /// No description provided for @viewTips.
  ///
  /// In en, this message translates to:
  /// **'View tips'**
  String get viewTips;

  /// No description provided for @applyToBoard.
  ///
  /// In en, this message translates to:
  /// **'Apply to board'**
  String get applyToBoard;

  /// No description provided for @adjustBoardArea.
  ///
  /// In en, this message translates to:
  /// **'Adjust board area'**
  String get adjustBoardArea;

  /// No description provided for @viewCommonUrls.
  ///
  /// In en, this message translates to:
  /// **'View common URLs'**
  String get viewCommonUrls;

  /// No description provided for @colorAnalysisFailed.
  ///
  /// In en, this message translates to:
  /// **'Color analysis failed!'**
  String get colorAnalysisFailed;

  /// No description provided for @analyzingGameBoardImage.
  ///
  /// In en, this message translates to:
  /// **'Analyzing game board image...'**
  String get analyzingGameBoardImage;

  /// No description provided for @selectFromAlbum.
  ///
  /// In en, this message translates to:
  /// **'Select from album'**
  String get selectFromAlbum;

  /// No description provided for @noBoardPointDetected.
  ///
  /// In en, this message translates to:
  /// **'No board point detected!'**
  String get noBoardPointDetected;

  /// No description provided for @ifLeftEmptyDefaultTemplateWillBeUsed.
  ///
  /// In en, this message translates to:
  /// **'If left empty, default template will be used'**
  String get ifLeftEmptyDefaultTemplateWillBeUsed;

  /// No description provided for @llmConfig.
  ///
  /// In en, this message translates to:
  /// **'LLM configuration'**
  String get llmConfig;

  /// No description provided for @areYouSureYouWantToResetThePromptTemplatesToDefaultValues.
  ///
  /// In en, this message translates to:
  /// **'Are you sure you want to reset the prompt templates to default values?'**
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues;

  /// No description provided for @llmPromptTemplateFooter.
  ///
  /// In en, this message translates to:
  /// **'LLM prompt template footer'**
  String get llmPromptTemplateFooter;

  /// No description provided for @loadingResponse.
  ///
  /// In en, this message translates to:
  /// **'Loading response...'**
  String get loadingResponse;

  /// No description provided for @applyThisResultToBoard.
  ///
  /// In en, this message translates to:
  /// **'Apply this result to board'**
  String get applyThisResultToBoard;

  /// No description provided for @takingPicture.
  ///
  /// In en, this message translates to:
  /// **'Taking picture...'**
  String get takingPicture;

  /// No description provided for @pleaseSelectAGameBoardImageToIdentify.
  ///
  /// In en, this message translates to:
  /// **'Please select a game board image to identify'**
  String get pleaseSelectAGameBoardImageToIdentify;

  /// No description provided for @identificationResults.
  ///
  /// In en, this message translates to:
  /// **'Identification results'**
  String get identificationResults;

  /// No description provided for @analyzeTheMovesAndProvideInsights.
  ///
  /// In en, this message translates to:
  /// **'Analyze the moves and provide insights.'**
  String get analyzeTheMovesAndProvideInsights;

  /// No description provided for @getApiKey.
  ///
  /// In en, this message translates to:
  /// **'Get API Key'**
  String get getApiKey;

  /// No description provided for @entireRecognitionProcessFailedToComplete.
  ///
  /// In en, this message translates to:
  /// **'Entire recognition process failed to complete.'**
  String get entireRecognitionProcessFailedToComplete;

  /// No description provided for @boardRecognitionResult.
  ///
  /// In en, this message translates to:
  /// **'Board recognition result'**
  String get boardRecognitionResult;

  /// No description provided for @askLlm.
  ///
  /// In en, this message translates to:
  /// **'Ask LLM'**
  String get askLlm;

  /// No description provided for @boardDetectionFailed.
  ///
  /// In en, this message translates to:
  /// **'Board detection failed!'**
  String get boardDetectionFailed;

  /// No description provided for @noBoardPointDetectedCannotIdentifyPiece.
  ///
  /// In en, this message translates to:
  /// **'No board point detected, cannot identify piece!'**
  String get noBoardPointDetectedCannotIdentifyPiece;

  /// No description provided for @copyFen.
  ///
  /// In en, this message translates to:
  /// **'Copy FEN'**
  String get copyFen;

  /// No description provided for @commonlyUsedModels.
  ///
  /// In en, this message translates to:
  /// **'Commonly used models'**
  String get commonlyUsedModels;

  /// No description provided for @apiKeyOptional.
  ///
  /// In en, this message translates to:
  /// **'API Key (optional)'**
  String get apiKeyOptional;

  /// No description provided for @noImageSelected.
  ///
  /// In en, this message translates to:
  /// **'No image selected'**
  String get noImageSelected;

  /// No description provided for @blackSMove.
  ///
  /// In en, this message translates to:
  /// **'Black\'s move'**
  String get blackSMove;

  /// No description provided for @llm.
  ///
  /// In en, this message translates to:
  /// **'Large Language Model'**
  String get llm;

  /// No description provided for @llmProvider.
  ///
  /// In en, this message translates to:
  /// **'Provider'**
  String get llmProvider;

  /// No description provided for @baseUrl.
  ///
  /// In en, this message translates to:
  /// **'Base URL'**
  String get baseUrl;

  /// No description provided for @model.
  ///
  /// In en, this message translates to:
  /// **'Model'**
  String get model;

  /// No description provided for @temperature.
  ///
  /// In en, this message translates to:
  /// **'Temperature'**
  String get temperature;

  /// No description provided for @llmCommandReceivedProcessing.
  ///
  /// In en, this message translates to:
  /// **'Command received! AI is processing...'**
  String get llmCommandReceivedProcessing;

  /// No description provided for @llmDeepThinkingWait.
  ///
  /// In en, this message translates to:
  /// **'Deep thinking in progress, please wait...'**
  String get llmDeepThinkingWait;

  /// No description provided for @llmPresentingSoon.
  ///
  /// In en, this message translates to:
  /// **'Presenting soon...'**
  String get llmPresentingSoon;

  /// No description provided for @recognitionParameters.
  ///
  /// In en, this message translates to:
  /// **'Recognition parameters'**
  String get recognitionParameters;

  /// No description provided for @adjustParamsDesc.
  ///
  /// In en, this message translates to:
  /// **'Adjust parameters to improve recognition accuracy'**
  String get adjustParamsDesc;

  /// No description provided for @saveParameters.
  ///
  /// In en, this message translates to:
  /// **'Save parameters'**
  String get saveParameters;

  /// No description provided for @unableToStartImageRecognition.
  ///
  /// In en, this message translates to:
  /// **'Unable to start image recognition: {error}'**
  String unableToStartImageRecognition(String error);

  /// No description provided for @imageRecognitionFailed.
  ///
  /// In en, this message translates to:
  /// **'Image recognition failed: {error}'**
  String imageRecognitionFailed(String error);

  /// No description provided for @appliedPositionDetails.
  ///
  /// In en, this message translates to:
  /// **'Applied position with {whiteCount} white and {blackCount} black pieces'**
  String appliedPositionDetails(int whiteCount, int blackCount);

  /// No description provided for @fenCopiedToClipboard.
  ///
  /// In en, this message translates to:
  /// **'(FEN copied to clipboard)'**
  String get fenCopiedToClipboard;

  /// No description provided for @recognitionFailed.
  ///
  /// In en, this message translates to:
  /// **'Recognition failed: {error}'**
  String recognitionFailed(String error);

  /// No description provided for @myRating.
  ///
  /// In en, this message translates to:
  /// **'My rating'**
  String get myRating;

  /// No description provided for @gamesPlayed.
  ///
  /// In en, this message translates to:
  /// **'Games played'**
  String get gamesPlayed;

  /// No description provided for @wins.
  ///
  /// In en, this message translates to:
  /// **'Wins'**
  String get wins;

  /// No description provided for @losses.
  ///
  /// In en, this message translates to:
  /// **'Losses'**
  String get losses;

  /// No description provided for @draws.
  ///
  /// In en, this message translates to:
  /// **'Draws'**
  String get draws;

  /// No description provided for @lastUpdated.
  ///
  /// In en, this message translates to:
  /// **'Last updated'**
  String get lastUpdated;

  /// No description provided for @format.
  ///
  /// In en, this message translates to:
  /// **'Format:'**
  String get format;

  /// No description provided for @resetStatistics.
  ///
  /// In en, this message translates to:
  /// **'Reset statistics'**
  String get resetStatistics;

  /// No description provided for @drawRate.
  ///
  /// In en, this message translates to:
  /// **'Draw rate'**
  String get drawRate;

  /// No description provided for @lossRate.
  ///
  /// In en, this message translates to:
  /// **'Loss rate'**
  String get lossRate;

  /// No description provided for @aiStatistics.
  ///
  /// In en, this message translates to:
  /// **'AI statistics'**
  String get aiStatistics;

  /// No description provided for @enableStatistics.
  ///
  /// In en, this message translates to:
  /// **'Enable statistics'**
  String get enableStatistics;

  /// No description provided for @enableStatistics_Detail.
  ///
  /// In en, this message translates to:
  /// **'When enabled, game results will be recorded in statistics. However, games involving take-backs will not be recorded. When disabled, statistics collection is paused.'**
  String get enableStatistics_Detail;

  /// No description provided for @thisWillResetAllGameStatistics.
  ///
  /// In en, this message translates to:
  /// **'This will reset all game statistics. This action cannot be undone.'**
  String get thisWillResetAllGameStatistics;

  /// No description provided for @boardInnerRingSize.
  ///
  /// In en, this message translates to:
  /// **'Board inner ring size'**
  String get boardInnerRingSize;

  /// No description provided for @boardShadowEnabled.
  ///
  /// In en, this message translates to:
  /// **'Board shadow'**
  String get boardShadowEnabled;

  /// No description provided for @trapAwareness.
  ///
  /// In en, this message translates to:
  /// **'Trap awareness'**
  String get trapAwareness;

  /// No description provided for @trapAwarenessDescription.
  ///
  /// In en, this message translates to:
  /// **'Highlight trap moves with bold circles and arrows during analysis.'**
  String get trapAwarenessDescription;

  /// No description provided for @trapExists.
  ///
  /// In en, this message translates to:
  /// **'Trap exists. Trap moves: {trapMoves}'**
  String trapExists(String trapMoves);

  /// No description provided for @custodianCapture.
  ///
  /// In en, this message translates to:
  /// **'Custodian capture'**
  String get custodianCapture;

  /// No description provided for @custodianCaptureDescription.
  ///
  /// In en, this message translates to:
  /// **'Bracket one of your opponent\'s pieces between two of yours along a line to remove it.'**
  String get custodianCaptureDescription;

  /// No description provided for @custodianCaptureEnable.
  ///
  /// In en, this message translates to:
  /// **'Allow custodian capture'**
  String get custodianCaptureEnable;

  /// No description provided for @interventionCapture.
  ///
  /// In en, this message translates to:
  /// **'Intervention capture'**
  String get interventionCapture;

  /// No description provided for @interventionCaptureDescription.
  ///
  /// In en, this message translates to:
  /// **'Move into the empty point between two of your opponent\'s pieces to remove them both.'**
  String get interventionCaptureDescription;

  /// No description provided for @interventionCaptureEnable.
  ///
  /// In en, this message translates to:
  /// **'Allow intervention capture'**
  String get interventionCaptureEnable;

  /// No description provided for @leapCapture.
  ///
  /// In en, this message translates to:
  /// **'Leap capture'**
  String get leapCapture;

  /// No description provided for @leapCaptureDescription.
  ///
  /// In en, this message translates to:
  /// **'Capture by leaping over an adjacent opponent\'s piece into the empty point beyond.'**
  String get leapCaptureDescription;

  /// No description provided for @leapCaptureEnable.
  ///
  /// In en, this message translates to:
  /// **'Allow leap capture'**
  String get leapCaptureEnable;

  /// No description provided for @captureApplicableLines.
  ///
  /// In en, this message translates to:
  /// **'Applicable lines'**
  String get captureApplicableLines;

  /// No description provided for @captureSquareEdges.
  ///
  /// In en, this message translates to:
  /// **'Along the square\'s edges'**
  String get captureSquareEdges;

  /// No description provided for @captureCrossLines.
  ///
  /// In en, this message translates to:
  /// **'Along orthogonal lines crossing the square'**
  String get captureCrossLines;

  /// No description provided for @captureDiagonalLines.
  ///
  /// In en, this message translates to:
  /// **'Along diagonal lines crossing the square'**
  String get captureDiagonalLines;

  /// No description provided for @captureExecutionPhases.
  ///
  /// In en, this message translates to:
  /// **'Execution phases'**
  String get captureExecutionPhases;

  /// No description provided for @capturePiecesCondition.
  ///
  /// In en, this message translates to:
  /// **'Piece-based availability during moving phase'**
  String get capturePiecesCondition;

  /// No description provided for @capturePiecesConditionUnlimited.
  ///
  /// In en, this message translates to:
  /// **'No restriction'**
  String get capturePiecesConditionUnlimited;

  /// No description provided for @capturePiecesConditionSelfLeqThree.
  ///
  /// In en, this message translates to:
  /// **'Available when you have 3 or fewer pieces'**
  String get capturePiecesConditionSelfLeqThree;
}

class _SDelegate extends LocalizationsDelegate<S> {
  const _SDelegate();

  @override
  Future<S> load(Locale locale) {
    return SynchronousFuture<S>(lookupS(locale));
  }

  @override
  bool isSupported(Locale locale) => <String>[
    'af',
    'am',
    'ar',
    'az',
    'be',
    'bg',
    'bn',
    'bo',
    'bs',
    'ca',
    'cs',
    'da',
    'de',
    'el',
    'en',
    'es',
    'et',
    'fa',
    'fi',
    'fr',
    'gu',
    'he',
    'hi',
    'hr',
    'hu',
    'hy',
    'id',
    'is',
    'it',
    'ja',
    'km',
    'kn',
    'ko',
    'lt',
    'lv',
    'mk',
    'ms',
    'my',
    'nb',
    'nl',
    'pl',
    'pt',
    'ro',
    'ru',
    'si',
    'sk',
    'sl',
    'sq',
    'sr',
    'sv',
    'sw',
    'ta',
    'te',
    'th',
    'tr',
    'uk',
    'ur',
    'uz',
    'vi',
    'zh',
    'zu',
  ].contains(locale.languageCode);

  @override
  bool shouldReload(_SDelegate old) => false;
}

S lookupS(Locale locale) {
  // Lookup logic when language+script codes are specified.
  switch (locale.languageCode) {
    case 'zh':
      {
        switch (locale.scriptCode) {
          case 'Hant':
            return SZhHant();
        }
        break;
      }
  }

  // Lookup logic when language+country codes are specified.
  switch (locale.languageCode) {
    case 'de':
      {
        switch (locale.countryCode) {
          case 'CH':
            return SDeCh();
        }
        break;
      }
  }

  // Lookup logic when only language code is specified.
  switch (locale.languageCode) {
    case 'af':
      return SAf();
    case 'am':
      return SAm();
    case 'ar':
      return SAr();
    case 'az':
      return SAz();
    case 'be':
      return SBe();
    case 'bg':
      return SBg();
    case 'bn':
      return SBn();
    case 'bo':
      return SBo();
    case 'bs':
      return SBs();
    case 'ca':
      return SCa();
    case 'cs':
      return SCs();
    case 'da':
      return SDa();
    case 'de':
      return SDe();
    case 'el':
      return SEl();
    case 'en':
      return SEn();
    case 'es':
      return SEs();
    case 'et':
      return SEt();
    case 'fa':
      return SFa();
    case 'fi':
      return SFi();
    case 'fr':
      return SFr();
    case 'gu':
      return SGu();
    case 'he':
      return SHe();
    case 'hi':
      return SHi();
    case 'hr':
      return SHr();
    case 'hu':
      return SHu();
    case 'hy':
      return SHy();
    case 'id':
      return SId();
    case 'is':
      return SIs();
    case 'it':
      return SIt();
    case 'ja':
      return SJa();
    case 'km':
      return SKm();
    case 'kn':
      return SKn();
    case 'ko':
      return SKo();
    case 'lt':
      return SLt();
    case 'lv':
      return SLv();
    case 'mk':
      return SMk();
    case 'ms':
      return SMs();
    case 'my':
      return SMy();
    case 'nb':
      return SNb();
    case 'nl':
      return SNl();
    case 'pl':
      return SPl();
    case 'pt':
      return SPt();
    case 'ro':
      return SRo();
    case 'ru':
      return SRu();
    case 'si':
      return SSi();
    case 'sk':
      return SSk();
    case 'sl':
      return SSl();
    case 'sq':
      return SSq();
    case 'sr':
      return SSr();
    case 'sv':
      return SSv();
    case 'sw':
      return SSw();
    case 'ta':
      return STa();
    case 'te':
      return STe();
    case 'th':
      return STh();
    case 'tr':
      return STr();
    case 'uk':
      return SUk();
    case 'ur':
      return SUr();
    case 'uz':
      return SUz();
    case 'vi':
      return SVi();
    case 'zh':
      return SZh();
    case 'zu':
      return SZu();
  }

  throw FlutterError(
    'S.delegate failed to load unsupported locale "$locale". This is likely '
    'an issue with the localizations generation tool. Please file an issue '
    'on GitHub with a reproducible sample app and the gen-l10n configuration '
    'that was used.',
  );
}
