// SPDX-License-Identifier: GPL-3.0-or-later
// Copyright (C) 2019-2025 The Sanmill developers (see AUTHORS file)

// zobrist.dart

part of '../mill.dart';

class _Zobrist {
  const _Zobrist._();

  static const int keyMiscBit = 2;
  static const List<List<int>> psq = <List<int>>[
    <int>[
      0x4E421A,
      0x3962FF,
      0x6DB6EE,
      0x219AE1,
      0x1F3DE2,
      0xD9AACB,
      0xD51733,
      0xD3F9EA,
      0xF5A7BB,
      0xDC4109,
      0xEE4319,
      0x7CDA7A,
      0xFD7B4D,
      0x4138BE,
      0xCCBB2D,
      0xDA6097,
      0x06D827,
      0xCBC16C,
      0x46F125,
      0xE29F22,
      0xCAAB94,
      0x5B02DB,
      0x877CD6,
      0x35E438,
      0x49FDAE,
      0xE68314,
      0xBE1664,
      0x1F49D3,
      0x50F5B1,
      0x149AAF,
      0xF509B9,
      0x47AEB5,
      0x18E993,
      0x76BB4F,
      0xFE1739,
      0xF87B87,
      0x0A8CD2,
      0x630C6B,
      0x88F5B4,
      0x0A583E,
    ],
    <int>[
      0xA0128E,
      0x6F2251,
      0x51E99D,
      0x6D35BF,
      0x66D6D9,
      0x87D366,
      0x75A57A,
      0x534FC4,
      0x1FE34B,
      0xAD6FB0,
      0xE5679D,
      0xF88AFF,
      0x0462DA,
      0x4BDE96,
      0xF28912,
      0x10537E,
      0x26D8EA,
      0x37E6E7,
      0x0871D9,
      0xCD5F4F,
      0xF4AFA1,
      0x44A51B,
      0x772656,
      0x8B7965,
      0xD8F17D,
      0x80F3D7,
      0x6B6206,
      0x19B8BB,
      0xFBC229,
      0x0FCAB4,
      0xFD7374,
      0xA647B9,
      0x296A8D,
      0xA3D742,
      0x624D6D,
      0x459FD4,
      0xCE8C26,
      0x965448,
      0x410171,
      0x1EDD7A,
    ],
    <int>[
      0x1FCF95,
      0xA5634E,
      0x21976A,
      0x32902D,
      0x55A27C,
      0x49EC5F,
      0x0176A1,
      0xCAAAEF,
      0x145886,
      0xB4C808,
      0x0153EE,
      0x7D78DF,
      0xE9C3C5,
      0x66B7A6,
      0x3CD930,
      0xDBBA23,
      0xF19841,
      0x6BEFDF,
      0xB979FE,
      0xBA4D06,
      0x96AECF,
      0x33B96E,
      0x76A99C,
      0x1B8762,
      0x747B20,
      0x0DEC24,
      0xA4E632,
      0xBA2442,
      0x59C91B,
      0x41482D,
      0xF2CD39,
      0x30E9C1,
      0x6B156D,
      0xC7F191,
      0x012D36,
      0xC66B36,
      0x631560,
      0xA891FC,
      0xF6C8AC,
      0xD80B94,
    ],
    <int>[
      0xF641E9,
      0xF164BF,
      0x2DBE4C,
      0xE2A40C,
      0x53FA06,
      0x4F3117,
      0x0ACA70,
      0x2C72F5,
      0xC81047,
      0x4B76AE,
      0xEB55C8,
      0x0DB6EF,
      0x7F57AB,
      0x22D060,
      0x390554,
      0xDE9A43,
      0x6583AF,
      0x41D141,
      0x9CBF92,
      0x7E528F,
      0x2BEFA1,
      0x5C5FDC,
      0x4DDAFA,
      0x7C98A1,
      0x65A13B,
      0x2953BF,
      0x8769A8,
      0xE6DCA1,
      0xD01A6E,
      0xBCD935,
      0x175659,
      0xAD5A73,
      0xB04E7D,
      0x815F53,
      0x12469A,
      0xB2F25C,
      0x564E4B,
      0xD19437,
      0xA4F63C,
      0x7169E5,
    ],
  ];

  static const List<List<int>> custodianTarget = <List<int>>[
    <int>[
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
    ],
    <int>[
      0xD18C0B,
      0x3971A7,
      0x8444F8,
      0x881B90,
      0xF716FA,
      0x30BBAD,
      0xE9899C,
      0x212CB9,
      0x23727B,
      0xDFA5EC,
      0x2C2B00,
      0x10BAF6,
      0xC9F3E3,
      0x764550,
      0xC18847,
      0x400C09,
      0x9AE26D,
      0x40BAC1,
      0x35D91B,
      0x65383C,
      0x5F13BA,
      0xC5EE40,
      0x66710C,
      0xCB5363,
      0x412086,
      0x509E77,
      0xA28643,
      0xDBAD3D,
      0x8AE041,
      0x2B2064,
      0x653E08,
      0xE21DFE,
    ],
    <int>[
      0x4457D3,
      0x519890,
      0xF09313,
      0xD07997,
      0x3EFF75,
      0x1BF9D3,
      0x87296C,
      0x1004E4,
      0xC84A24,
      0x41D5B9,
      0x482B8C,
      0x366263,
      0x61528A,
      0xCBA795,
      0x4C69A8,
      0x7B0929,
      0xAFFA29,
      0x36768A,
      0x443003,
      0x9D889C,
      0xA311D9,
      0xBD3630,
      0x9CAA4A,
      0x73F315,
      0xFF07C1,
      0x0949D0,
      0x156398,
      0x2F4CD2,
      0xC49599,
      0x88375E,
      0xA74700,
      0xA46058,
    ],
  ];

  static const List<List<int>> custodianCount = <List<int>>[
    <int>[0, 0, 0, 0, 0],
    <int>[0x3AB8E3, 0xAEC2FF, 0x59FE69, 0x7C3298, 0xA20BF0],
    <int>[0x30337E, 0x951936, 0x992396, 0xBC371E, 0x2A1778],
  ];

  static const List<List<int>> interventionTarget = <List<int>>[
    <int>[
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
      0x000000,
    ],
    <int>[
      0x5E02A1,
      0xA4D957,
      0x3F7C6E,
      0x12B9F4,
      0x89D214,
      0x6E4308,
      0xF0A6C3,
      0x7B9E12,
      0xC4578B,
      0x1E63FD,
      0x54AB08,
      0x9374C2,
      0x20D8AF,
      0xE14679,
      0x3AB5E1,
      0x7F0C52,
      0xD5E3A4,
      0x48BC17,
      0x9A04C6,
      0x6CF2D3,
      0xB1705A,
      0x2E39CF,
      0xC8A5B4,
      0x14567E,
      0xF92D01,
      0x8B73AC,
      0x31EF59,
      0xDA4682,
      0x5C9BD7,
      0x07E214,
      0xBE5836,
      0x4AD0F1,
    ],
    <int>[
      0x7C51E2,
      0x0FA943,
      0xE2D578,
      0x98B01F,
      0x467CDA,
      0x1AB5C0,
      0xD93F85,
      0x62E7FA,
      0x0B8C4D,
      0xF43197,
      0x2CD065,
      0xAE7B1C,
      0x5389F2,
      0x0D47BC,
      0x9146E8,
      0x3FAD21,
      0xC8E05B,
      0x74B932,
      0x8FD6AE,
      0x59C384,
      0xB7A210,
      0x261FDB,
      0xE98543,
      0x40C87A,
      0xA3F2D6,
      0x1C5AE9,
      0x6BED54,
      0xDF0893,
      0x85264F,
      0x39B1D0,
      0xF50E6A,
      0x12C497,
    ],
  ];

  static const List<List<int>> interventionCount = <List<int>>[
    <int>[0, 0, 0, 0, 0, 0, 0, 0, 0],
    <int>[
      0x51A2E9,
      0x83D45C,
      0x1BE790,
      0xA6C53F,
      0x7E08B1,
      0x3D9426,
      0xF250DA,
      0x4691FE,
      0x9C3074,
    ],
    <int>[
      0x6F1C83,
      0x24A5D7,
      0xBD4072,
      0x90E68F,
      0x58B13C,
      0x0ED5A8,
      0xC78159,
      0x3A4CEF,
      0xF9B026,
    ],
  ];

  static const int side = 0x201906;
}
