// SPDX-License-Identifier: GPL-3.0-or-later
// Copyright (C) 2019-2025 The Sanmill developers (see AUTHORS file)

// opening_book.dart

part of '../mill.dart';

// This map contains FEN (Forsyth-Edwards Notation) strings mapped to their best moves
// specifically for the Nine Men's Morris game.
// Note: The second-to-last field in the FEN string, referred to as `rule50`,
// represents the half-move clock (a rule used in chess to track draws by the 50-move rule).
// In this context, the `rule50` field must always be set to 0.
//
// First, complete the <String> list based on symmetry.
// Then use fen-to-board.py and input:
//
//   "********/@*O*O*@*/******** w p p 2 7 2 7 0 0 0 0 0 0 0 0 3": <String>[
//     "f2",
//     "d5",
//     "d7",
//     "c4",
//     "a4",
//     "b6"
//   ],
//
// Leave a blank line below, generate the output code, and paste it back here.
//
// Note: Replace the second and third last field of FEN string with '0'.
//
// Note: When removed a piece, FEN cannot be obtained through Setup Position, but must be obtained by normalizedFen during the code flow.

Map<String, List<String>> nineMensMorrisFenToBestMoves = <String, List<String>>{
  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/********/******** w p p 0 9 0 9 0 0 0 0 0 0 0 0 1": <String>[
    "d2",
    "b4",
    "d6",
    "f4",
    "b2",
    "b6",
    "f6",
    "f2",
  ],

  //////////////////////////////////////////////////////////////////////////////
  /////////////////////////////// Brilliant Mill ///////////////////////////////
  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/****O***/******** b p p 1 8 0 9 0 0 0 0 0 0 0 0 1": <String>[
    "d6",
    "f6",
    "b6",
    "f4",
    "b4",
    "b2",
    "f2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*******/******** b p p 1 8 0 9 0 0 0 0 0 0 0 0 1": <String>[
    "d2",
    "f2",
    "b2",
    "f4",
    "b4",
    "b6",
    "f6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/******O*/******** b p p 1 8 0 9 0 0 0 0 0 0 0 0 1": <String>[
    "f4",
    "f2",
    "f6",
    "d2",
    "d6",
    "b6",
    "b2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/**O*****/******** b p p 1 8 0 9 0 0 0 0 0 0 0 0 1": <String>[
    "b4",
    "b2",
    "b6",
    "d2",
    "d6",
    "f6",
    "f2",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/*****O**/******** b p p 1 8 0 9 0 0 0 0 0 0 0 0 1": <String>[
    "d6",
    "f4",
    "f6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/*******O/******** b p p 1 8 0 9 0 0 0 0 0 0 0 0 1": <String>[
    "d2",
    "f4",
    "f2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/***O****/******** b p p 1 8 0 9 0 0 0 0 0 0 0 0 1": <String>[
    "d6",
    "b4",
    "b6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/*O******/******** b p p 1 8 0 9 0 0 0 0 0 0 0 0 1": <String>[
    "d2",
    "b4",
    "b2",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@***O***/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "f4",
    "b4",
    "f6",
    "b6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O***@***/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "f4",
    "b4",
    "f2",
    "b2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/**@***O*/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "d2",
    "d6",
    "f2",
    "f6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/**O***@*/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "d2",
    "d6",
    "b2",
    "b6",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/*@**O***/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "b2",
    "f4",
    "b4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O**@****/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "b6",
    "f4",
    "b4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/****O**@/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "f2",
    "b4",
    "f4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O****@**/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "f6",
    "b4",
    "f4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/***@**O*/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "b6",
    "d2",
    "d6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/**O**@**/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "f6",
    "d2",
    "d6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/*@****O*/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "b2",
    "d6",
    "d2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/**O****@/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "f2",
    "d6",
    "d2",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/**@*O***/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>["d6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*@*****/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>["d2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/****O*@*/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>["d6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*****@*/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>["d2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/****@*O*/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>["f4"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/**O*@***/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>["b4"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*****O*/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>["f4"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*O*****/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>["b4"],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/****O@**/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>["f6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O******@/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>["f2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/***@O***/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>["b6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O@******/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>["b2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/******O@/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>["f2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/*@O*****/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>["b2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/*****@O*/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>["f6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/**O@****/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>["b6"],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@****O**/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>["f6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/****@**O/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>["f2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@**O****/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>["b6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/*O**@***/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>["b2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/**@****O/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>["f2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/*O****@*/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>["b2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/**@**O**/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>["f6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/***O**@*/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>["b6"],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*O*O***/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "b4",
    "f2",
    "b2",
    "f6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*O*@***/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "b4",
    "f6",
    "b6",
    "f2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@***O*O*/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "f4",
    "b2",
    "f2",
    "b6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O***@*O*/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "f4",
    "b6",
    "f6",
    "b2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/**@*O*O*/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "d6",
    "b2",
    "b6",
    "f2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/**O*O*@*/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "d6",
    "f2",
    "f6",
    "b2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*@***O*/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "d2",
    "b6",
    "b2",
    "f6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*O***@*/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "d2",
    "f6",
    "f2",
    "b6",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/*@O*O***/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>["b2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*O@****/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>["b6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/****O*O@/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>["f2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O****@O*/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>["f6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/***@O*O*/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>["b6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/**O*O@**/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>["f6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O@****O*/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>["b2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*O****@/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>["f2"],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/*@**O*O*/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>["b2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O**@**O*/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>["b6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/**O*O**@/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>["f2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*O**@**/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>["f6"],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*@*O***/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>["b4"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O***O*@*/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>["f4"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/**O*@*O*/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>["d6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*O***O*/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>["d2"],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@O***O**/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "b4",
    "f4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/***O@**O/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "b4",
    "f4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@**O***O/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "f4",
    "b4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/*O**@O**/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "f4",
    "b4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/**@O***O/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "d6",
    "d2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/*O***O@*/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "d6",
    "d2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/*O@**O**/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "d2",
    "d6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/***O**@O/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "d2",
    "d6",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*O*@*@*/******** w p p 2 7 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "f6",
    "d3",
    "d1",
    "c4",
    "a4",
    "b2",
    "e5", // Rainer Rosenberger
    "g7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*O*O*@*/******** w p p 2 7 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "f2",
    "d5",
    "d7",
    "c4",
    "a4",
    "b6",
    "e3",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*@*@*O*/******** w p p 2 7 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "b6",
    "d3",
    "d1",
    "e4",
    "g4",
    "f2",
    "c5",
    "a7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*@*O*O*/******** w p p 2 7 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "b2",
    "d5",
    "d7",
    "e4",
    "g4",
    "f6",
    "c3",
    "a1",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*OOO*@*/******** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "f6",
    "b2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OOO*@*@*/******** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "f2",
    "b6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*@*OOO*/******** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "b6",
    "f2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*@*@*OO/******** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "b2",
    "f6",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*******/@*O*O*@*/******** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>["b6"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*O*O*@*/O******* b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>["b6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****O***/O*O*@*@*/******** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>["b2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "********/O*O*@*@*/****O*** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>["b2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*******/@*@*O*O*/******** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>["f6"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*@*O*O*/O******* b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>["f6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****O***/O*@*@*O*/******** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>["f2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "********/O*@*@*O*/****O*** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>["f2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*****/@*@*O*O*/******** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>["f6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*@*O*O*/**O***** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>["f6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******O*/@*O*O*@*/******** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>["b6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*O*O*@*/******O* b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>["b6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*****/O*@*@*O*/******** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>["f2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*@*@*O*/**O***** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>["f2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******O*/O*O*@*@*/******** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>["b2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*O*@*@*/******O* b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>["b2"],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@@OOO*@*/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "b2",
    "b6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OOO@@*@*/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "b6",
    "b2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*@*OOO@/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "f2",
    "f6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*@*@@OO/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "f6",
    "f2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*@@OOO*/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "b6",
    "f6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*OOO@@*/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "f6",
    "b6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O@@*@*OO/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "b2",
    "f2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OOO*@*@@/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "f2",
    "b2",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@@OOOO@*/******** w p r 4 5 3 6 1 0 0 0 0 0 0 0 4": <String>["xf6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OOO@@*@O/******** w p r 4 5 3 6 1 0 0 0 0 0 0 0 4": <String>["xf2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*@OOOO@/******** w p r 4 5 3 6 1 0 0 0 0 0 0 0 4": <String>["xb6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OO@*@@OO/******** w p r 4 5 3 6 1 0 0 0 0 0 0 0 4": <String>["xb2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*@@OOOO/******** w p r 4 5 3 6 1 0 0 0 0 0 0 0 4": <String>["xf2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@OOOO@@*/******** w p r 4 5 3 6 1 0 0 0 0 0 0 0 4": <String>["xb2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O@@*@OOO/******** w p r 4 5 3 6 1 0 0 0 0 0 0 0 4": <String>["xf6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OOOO@*@@/******** w p r 4 5 3 6 1 0 0 0 0 0 0 0 4": <String>["xb6"],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*OOOO@*/******** b p p 4 5 2 6 0 0 0 0 0 0 0 0 4": <String>["f6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OOO*@*@O/******** b p p 4 5 2 6 0 0 0 0 0 0 0 0 4": <String>["f2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*@OOOO*/******** b p p 4 5 2 6 0 0 0 0 0 0 0 0 4": <String>["b6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OO@*@*OO/******** b p p 4 5 2 6 0 0 0 0 0 0 0 0 4": <String>["b2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*@*OOOO/******** b p p 4 5 2 6 0 0 0 0 0 0 0 0 4": <String>["f2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@OOOO*@*/******** b p p 4 5 2 6 0 0 0 0 0 0 0 0 4": <String>["b2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*@*@OOO/******** b p p 4 5 2 6 0 0 0 0 0 0 0 0 4": <String>["f6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OOOO@*@*/******** b p p 4 5 2 6 0 0 0 0 0 0 0 0 4": <String>["b6"],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@@OOO*@O/******** b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>["b2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OOO@@O@*/******** b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>["b6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@O@*OOO@/******** b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>["f2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*@O@@OO/******** b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>["f6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@O@@OOO*/******** b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>["b6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*OOO@@O/******** b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>["f6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O@@O@*OO/******** b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>["b2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OOO*@O@@/******** b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>["f2"],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*******/@*O*O*@@/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>["b2"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*O*O*@@/O******* w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>["b2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****O***/O*O*@@@*/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>["b6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "********/O*O*@@@*/****O*** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>["b6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*******/@@@*O*O*/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>["f2"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@@@*O*O*/O******* w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>["f2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****O***/O*@@@*O*/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>["f6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "********/O*@@@*O*/****O*** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>["f6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*****/@@@*O*O*/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>["b6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@@@*O*O*/**O***** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>["b6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******O*/@*O*O*@@/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>["f6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*O*O*@@/******O* w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>["f6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*****/O*@@@*O*/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>["b2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*@@@*O*/**O***** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>["b2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******O*/O*O*@@@*/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>["f2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*O*@@@*/******O* w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>["f2"],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*******/@*O*OO@@/******** b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "f2",
    "f6",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*O*OO@@/O******* b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "f2",
    "f6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****O***/O*O*@@@O/******** b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "f6",
    "f2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "********/O*O*@@@O/****O*** b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "f6",
    "f2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*******/@@@OO*O*/******** b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "b2",
    "b6",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@@@OO*O*/O******* b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "b2",
    "b6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****O***/OO@@@*O*/******** b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "b6",
    "b2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "********/OO@@@*O*/****O*** b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "b6",
    "b2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*****/@@@*O*OO/******** b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "b2",
    "f2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@@@*O*OO/**O***** b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "b2",
    "f2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******O*/@OO*O*@@/******** b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "f2",
    "b2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@OO*O*@@/******O* b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "f2",
    "b2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*****/O*@@@OO*/******** b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "b6",
    "f6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*@@@OO*/**O***** b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "b6",
    "f6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******O*/O*OO@@@*/******** b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "f6",
    "b6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*OO@@@*/******O* b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "f6",
    "b6",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*******/@@O*OO@@/******** b p r 4 5 4 5 0 1 0 0 0 0 0 0 4": <String>["xb2"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@@O*OO@@/O******* b p r 4 5 4 5 0 1 0 0 0 0 0 0 4": <String>["xb2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****O***/O*O@@@@O/******** b p r 4 5 4 5 0 1 0 0 0 0 0 0 4": <String>["xb6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "********/O*O@@@@O/****O*** b p r 4 5 4 5 0 1 0 0 0 0 0 0 4": <String>["xb6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*******/@@@OO*O@/******** b p r 4 5 4 5 0 1 0 0 0 0 0 0 4": <String>["xf2"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@@@OO*O@/O******* b p r 4 5 4 5 0 1 0 0 0 0 0 0 4": <String>["xf2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****O***/OO@@@@O*/******** b p r 4 5 4 5 0 1 0 0 0 0 0 0 4": <String>["xf6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "********/OO@@@@O*/****O*** b p r 4 5 4 5 0 1 0 0 0 0 0 0 4": <String>["xf6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*****/@@@@O*OO/******** b p r 4 5 4 5 0 1 0 0 0 0 0 0 4": <String>["xb6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@@@@O*OO/**O***** b p r 4 5 4 5 0 1 0 0 0 0 0 0 4": <String>["xb6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******O*/@OO*O@@@/******** b p r 4 5 4 5 0 1 0 0 0 0 0 0 4": <String>["xf6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@OO*O@@@/******O* b p r 4 5 4 5 0 1 0 0 0 0 0 0 4": <String>["xf6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*****/O@@@@OO*/******** b p r 4 5 4 5 0 1 0 0 0 0 0 0 4": <String>["xb2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O@@@@OO*/**O***** b p r 4 5 4 5 0 1 0 0 0 0 0 0 4": <String>["xb2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******O*/O*OO@@@@/******** b p r 4 5 4 5 0 1 0 0 0 0 0 0 4": <String>["xf2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*OO@@@@/******O* b p r 4 5 4 5 0 1 0 0 0 0 0 0 4": <String>["xf2"],

  //////////////////////////////////////////////////////////////////////////////

  // Z-Mill and variants

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OO@*@@OO/******** w p p 4 5 3 5 0 0 0 0 0 0 0 0 5": <String>[
    "f2",
    "c5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*@OOOO@/******** w p p 4 5 3 5 0 0 0 0 0 0 0 0 5": <String>[
    "f6",
    "c3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OOO@@*@O/******** w p p 4 5 3 5 0 0 0 0 0 0 0 0 5": <String>[
    "b2",
    "e5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@@OOOO@*/******** w p p 4 5 3 5 0 0 0 0 0 0 0 0 5": <String>[
    "b6",
    "e3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OOOO@*@@/******** w p p 4 5 3 5 0 0 0 0 0 0 0 0 5": <String>[
    "b2",
    "e5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O@@*@OOO/******** w p p 4 5 3 5 0 0 0 0 0 0 0 0 5": <String>[
    "f2",
    "c5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@OOOO@@*/******** w p p 4 5 3 5 0 0 0 0 0 0 0 0 5": <String>[
    "b6",
    "e3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*@@OOOO/******** w p p 4 5 3 5 0 0 0 0 0 0 0 0 5": <String>[
    "f6",
    "c3",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*******/@*O@OO@@/******** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["f6"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*O@OO@@/O******* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["f6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****O***/O@O*@@@O/******** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["f2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "********/O@O*@@@O/****O*** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["f2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*******/@@@OO@O*/******** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["b6"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@@@OO@O*/O******* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["b6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****O***/OO@@@*O@/******** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["b2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "********/OO@@@*O@/****O*** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["b2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*****/@@@*O@OO/******** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["f2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@@@*O@OO/**O***** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["f2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******O*/@OO@O*@@/******** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["b2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@OO@O*@@/******O* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["b2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*****/O*@@@OO@/******** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["f6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*@@@OO@/**O***** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["f6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******O*/O@OO@@@*/******** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["b6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O@OO@@@*/******O* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["b6"],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*******/@@O*O*@@/******** w p p 3 5 4 5 0 0 0 0 0 0 0 0 5": <String>["b2"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@@O*O*@@/O******* w p p 3 5 4 5 0 0 0 0 0 0 0 0 5": <String>["b2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****O***/O*O@@@@*/******** w p p 3 5 4 5 0 0 0 0 0 0 0 0 5": <String>["b6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "********/O*O@@@@*/****O*** w p p 3 5 4 5 0 0 0 0 0 0 0 0 5": <String>["b6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*******/@@@*O*O@/******** w p p 3 5 4 5 0 0 0 0 0 0 0 0 5": <String>["f2"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@@@*O*O@/O******* w p p 3 5 4 5 0 0 0 0 0 0 0 0 5": <String>["f2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****O***/O*@@@@O*/******** w p p 3 5 4 5 0 0 0 0 0 0 0 0 5": <String>["f6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "********/O*@@@@O*/****O*** w p p 3 5 4 5 0 0 0 0 0 0 0 0 5": <String>["f6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*****/@@@@O*O*/******** w p p 3 5 4 5 0 0 0 0 0 0 0 0 5": <String>["b6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@@@@O*O*/**O***** w p p 3 5 4 5 0 0 0 0 0 0 0 0 5": <String>["b6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******O*/@*O*O@@@/******** w p p 3 5 4 5 0 0 0 0 0 0 0 0 5": <String>["f6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*O*O@@@/******O* w p p 3 5 4 5 0 0 0 0 0 0 0 0 5": <String>["f6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*****/O@@@@*O*/******** w p p 3 5 4 5 0 0 0 0 0 0 0 0 5": <String>["b2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O@@@@*O*/**O***** w p p 3 5 4 5 0 0 0 0 0 0 0 0 5": <String>["b2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******O*/O*O*@@@@/******** w p p 3 5 4 5 0 0 0 0 0 0 0 0 5": <String>["f2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*O*@@@@/******O* w p p 3 5 4 5 0 0 0 0 0 0 0 0 5": <String>["f2"],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*******/@@O*OO@@/******** b p p 4 4 4 5 0 0 0 0 0 0 0 0 5": <String>["f2"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@@O*OO@@/O******* b p p 4 4 4 5 0 0 0 0 0 0 0 0 5": <String>["f2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****O***/O*O@@@@O/******** b p p 4 4 4 5 0 0 0 0 0 0 0 0 5": <String>["f6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "********/O*O@@@@O/****O*** b p p 4 4 4 5 0 0 0 0 0 0 0 0 5": <String>["f6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*******/@@@OO*O@/******** b p p 4 4 4 5 0 0 0 0 0 0 0 0 5": <String>["b2"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@@@OO*O@/O******* b p p 4 4 4 5 0 0 0 0 0 0 0 0 5": <String>["b2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****O***/OO@@@@O*/******** b p p 4 4 4 5 0 0 0 0 0 0 0 0 5": <String>["b6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "********/OO@@@@O*/****O*** b p p 4 4 4 5 0 0 0 0 0 0 0 0 5": <String>["b6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*****/@@@@O*OO/******** b p p 4 4 4 5 0 0 0 0 0 0 0 0 5": <String>["b2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@@@@O*OO/**O***** b p p 4 4 4 5 0 0 0 0 0 0 0 0 5": <String>["b2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******O*/@OO*O@@@/******** b p p 4 4 4 5 0 0 0 0 0 0 0 0 5": <String>["f2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@OO*O@@@/******O* b p p 4 4 4 5 0 0 0 0 0 0 0 0 5": <String>["f2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*****/O@@@@OO*/******** b p p 4 4 4 5 0 0 0 0 0 0 0 0 5": <String>["b6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O@@@@OO*/**O***** b p p 4 4 4 5 0 0 0 0 0 0 0 0 5": <String>["b6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******O*/O*OO@@@@/******** b p p 4 4 4 5 0 0 0 0 0 0 0 0 5": <String>["f6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*OO@@@@/******O* b p p 4 4 4 5 0 0 0 0 0 0 0 0 5": <String>["f6"],

  ///////////////////////////// Low Risk ///////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@O@**O**/******** w p p 2 7 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "d2",
    "b4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/**@O@**O/******** w p p 2 7 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "d6",
    "b4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@**O**@O/******** w p p 2 7 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "d2",
    "f4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/*O**@O@*/******** w p p 2 7 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "d6",
    "f4",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/*@**OO**/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>["f2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O**@***O/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>["f6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/***OO**@/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>["b2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OO***@**/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>["b6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/***@**OO/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>["b2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/*OO**@**/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>["f2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/*@***OO*/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>["b6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/**OO***@/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>["f6"],

  ////////////////////////////// Ignore no threat //////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/*@O@OO**/******** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "d1",
    "d3",
    "b4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O@O@***O/******** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "d7",
    "d5",
    "b4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/***OO@O@/******** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "d1",
    "d3",
    "f4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OO***@O@/******** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "d7",
    "d5",
    "f4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/***@O@OO/******** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "a4",
    "c4",
    "d6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/*OO@O@**/******** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "g4",
    "e4",
    "d6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O@***OO@/******** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "a4",
    "c4",
    "d2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O@OO***@/******** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "g4",
    "e4",
    "d2",
  ],

  ////////////////////////////////// Low Risk //////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/*O**O@**/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "b4",
    "f4",
    "d6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O**O***@/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "b4",
    "f4",
    "d2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/***@O**O/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "f4",
    "b4",
    "d6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O@***O**/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "f4",
    "b4",
    "d2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/***O**O@/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "d6",
    "d2",
    "f4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/*@O**O**/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "d6",
    "d2",
    "b4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/*O***@O*/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "d2",
    "d6",
    "f4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/**O@***O/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "d2",
    "d6",
    "b4",
  ],

  //////////////////////////////// Low Risk ////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@@OOO@@O/******** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "a4",
    "c4",
    "d5",
    "d7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OOO@@O@@/******** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "a4",
    "c4",
    "d3",
    "d1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@O@@OOO@/******** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "g4",
    "e4",
    "d5",
    "d7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O@@O@@OO/******** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "g4",
    "e4",
    "d3",
    "d1",
  ],

  ////////////////////////////// Ignore no threat //////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/*@O*O@**/******** w p p 2 7 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "b4",
    "d6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*O@***@/******** w p p 2 7 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "b4",
    "d2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/***@O*O@/******** w p p 2 7 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "f4",
    "d6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O@***@O*/******** w p p 2 7 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "f4",
    "d2",
  ],

  ////////////////////////////// Ignore no threat //////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/*@***O**/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "b4",
    "f4",
    "d6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/***@***O/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "b4",
    "f4",
    "d2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/***O***@/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "f4",
    "b4",
    "d6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/*O***@**/******** w p p 1 8 1 8 0 0 0 0 0 0 0 0 2": <String>[
    "f4",
    "b4",
    "d2",
  ],

  ////////////////////////////////// Low Risk //////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*@*O*@*/******** w p p 2 7 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "b2",
    "f2",
    "a4",
    "c4",
    "e4",
    "g4",
    "b6",
    "f6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*O*@*O*/******** w p p 2 7 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "b6",
    "b2",
    "d7",
    "d5",
    "d3",
    "d1",
    "f6",
    "f2",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*O*O*@O/******** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "a1",
    "d1",
    "g1",
    "b2",
    "f2",
    "c3",
    "d3",
    "e3",
    "a4",
    "c4",
    "e4",
    "g4",
    "c5",
    "d5",
    "e5",
    "f6",
    "a7",
    "d7",
    "g7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*O*@O@*/******** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "a7",
    "d7",
    "g7",
    "b6",
    "f6",
    "c5",
    "d5",
    "e5",
    "a4",
    "c4",
    "e4",
    "g4",
    "c3",
    "d3",
    "e3",
    "f2",
    "a1",
    "d1",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@O@*O*O*/******** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "g1",
    "d1",
    "a1",
    "f2",
    "b2",
    "e3",
    "d3",
    "c3",
    "g4",
    "e4",
    "c4",
    "a4",
    "e5",
    "d5",
    "c5",
    "b6",
    "g7",
    "d7",
    "a7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*@O@*O*/******** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "g7",
    "d7",
    "a7",
    "f6",
    "b6",
    "e5",
    "d5",
    "c5",
    "g4",
    "e4",
    "c4",
    "a4",
    "e3",
    "d3",
    "c3",
    "b2",
    "g1",
    "d1",
    "a1",
  ],

  ////////////////////////////////// Ignore no threat //////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@O**O***/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>["b4"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O**O@***/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>["b4"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@***O**O/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>["f4"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O***@O**/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>["f4"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/**@O**O*/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>["d6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/**O**O@*/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>["d6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/*O@***O*/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>["d2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/**O***@O/******** b p p 2 7 1 8 0 0 0 0 0 0 0 0 2": <String>["d2"],

  ///////////////////////////////// Low Risk ///////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*******/@OO@OO@@/******** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>["e3"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@OO@OO@@/O******* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>["g1"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****O***/O@OO@@@O/******** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>["e5"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "********/O@OO@@@O/****O*** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>["g7"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*******/@@@OO@OO/******** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>["c3"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@@@OO@OO/O******* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>["a1"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****O***/OO@@@OO@/******** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>["c5"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "********/OO@@@OO@/****O*** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>["a7"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*****/@@@OO@OO/******** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>["c3"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@@@OO@OO/**O***** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>["a1"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******O*/@OO@OO@@/******** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>["e3"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@OO@OO@@/******O* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>["g1"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*****/OO@@@OO@/******** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>["c5"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OO@@@OO@/**O***** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>["a7"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******O*/O@OO@@@O/******** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>["e5"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O@OO@@@O/******O* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>["g7"],

  //////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////  Z-Mill  /////////////////////////////////
  //////////////////////////////////////////////////////////////////////////////

  //////////////////////////////////////////////////////////////////////////////

  // No e3/g1 because no threat.

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OO@O@@OO/******** b p p 5 4 3 5 0 0 0 0 0 0 0 0 5": <String>[
    "a1",
    "d1",
    "c3",
    "d3",
    "a4",
    "c4",
    "e4",
    "g4",
    "c5",
    "d5",
    "e5",
    "a7",
    "d7",
    "g7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@O@OOOO@/******** b p p 5 4 3 5 0 0 0 0 0 0 0 0 5": <String>[
    "a7",
    "d7",
    "c5",
    "d5",
    "a4",
    "c4",
    "e4",
    "g4",
    "c3",
    "d3",
    "e3",
    "a1",
    "d1",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OOO@@O@O/******** b p p 5 4 3 5 0 0 0 0 0 0 0 0 5": <String>[
    "g1",
    "d1",
    "e3",
    "d3",
    "g4",
    "e4",
    "c4",
    "a4",
    "e5",
    "d5",
    "c5",
    "g7",
    "d7",
    "a7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@@OOOO@O/******** b p p 5 4 3 5 0 0 0 0 0 0 0 0 5": <String>[
    "g7",
    "d7",
    "e5",
    "d5",
    "g4",
    "e4",
    "c4",
    "a4",
    "e3",
    "d3",
    "c3",
    "g1",
    "d1",
    "a1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OOOO@O@@/******** b p p 5 4 3 5 0 0 0 0 0 0 0 0 5": <String>[
    "a7",
    "a4",
    "c5",
    "c4",
    "d7",
    "d5",
    "d3",
    "d1",
    "e5",
    "e4",
    "e3",
    "g7",
    "g4",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O@@O@OOO/******** b p p 5 4 3 5 0 0 0 0 0 0 0 0 5": <String>[
    "g7",
    "g4",
    "e5",
    "e4",
    "d7",
    "d5",
    "d3",
    "d1",
    "c5",
    "c4",
    "c3",
    "a7",
    "a4",
    "a1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@OOOO@@O/******** b p p 5 4 3 5 0 0 0 0 0 0 0 0 5": <String>[
    "a1",
    "a4",
    "c3",
    "c4",
    "d1",
    "d3",
    "d5",
    "d7",
    "e3",
    "e4",
    "e5",
    "g1",
    "g4",
    "g7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@O@@OOOO/******** b p p 5 4 3 5 0 0 0 0 0 0 0 0 5": <String>[
    "g1",
    "g4",
    "e3",
    "e4",
    "d1",
    "d3",
    "d5",
    "d7",
    "c3",
    "c4",
    "c5",
    "a1",
    "a4",
    "a7",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*******/OO@O@@OO/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "d1",
    "g1",
    "c3",
    "d3",
    "e3",
    "e4",
    "g4",
    "c5",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OO@O@@OO/@******* w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "d3",
    "e3",
    "a1",
    "d1",
    "g1",
    "g4",
    "e4",
    "a7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****@***/@O@OOOO@/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "d7",
    "g7",
    "c5",
    "d5",
    "e5",
    "e4",
    "g4",
    "c3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "********/@O@OOOO@/****@*** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "d5",
    "e5",
    "a7",
    "d7",
    "g7",
    "g4",
    "e4",
    "a1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*******/OOO@@O@O/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "d1",
    "a1",
    "e3",
    "d3",
    "c3",
    "c4",
    "a4",
    "e5",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OOO@@O@O/@******* w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "d3",
    "c3",
    "g1",
    "d1",
    "a1",
    "a4",
    "c4",
    "g7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****@***/@@OOOO@O/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "d7",
    "a7",
    "e5",
    "d5",
    "c5",
    "c4",
    "a4",
    "e3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "********/@@OOOO@O/****@*** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "d5",
    "c5",
    "g7",
    "d7",
    "a7",
    "a4",
    "c4",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@*****/OOOO@O@@/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "a4",
    "a1",
    "c5",
    "c4",
    "c3",
    "d3",
    "d1",
    "e5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OOOO@O@@/**@***** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "c4",
    "c3",
    "a7",
    "a4",
    "a1",
    "d1",
    "d3",
    "g7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******@*/O@@O@OOO/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "g4",
    "g1",
    "e5",
    "e4",
    "e3",
    "d3",
    "d1",
    "c5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O@@O@OOO/******@* w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "e4",
    "e3",
    "g7",
    "g4",
    "g1",
    "d1",
    "d3",
    "a7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@*****/@OOOO@@O/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "a4",
    "a7",
    "c3",
    "c4",
    "c5",
    "d5",
    "d7",
    "e3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@OOOO@@O/**@***** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "c4",
    "c5",
    "a1",
    "a4",
    "a7",
    "d7",
    "d5",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******@*/@O@@OOOO/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "g4",
    "g7",
    "e3",
    "e4",
    "e5",
    "d5",
    "d7",
    "c3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@O@@OOOO/******@* w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "e4",
    "e5",
    "g1",
    "g4",
    "g7",
    "d7",
    "d5",
    "a1",
  ],

  //////////////////////////////////////////////////////////////////////////////

  // g1 is the easiest to draw. (Rainer Rosenberger)

  /*
    a7 ----- d7 -----  @
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OO@O@@OO/*@****** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>["g1"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*@******/OO@O@@OO/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>["e3"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "********/@O@OOOO@/***@**** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>["g7"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "***@****/@O@OOOO@/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>["e5"],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OOO@@O@O/*******@ w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>["a1"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*******@/OOO@@O@O/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>["c3"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "********/@@OOOO@O/*****@** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>["a7"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*****@**/@@OOOO@O/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>["c5"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "********/OOOO@O@@/***@**** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>["a1"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "***@****/OOOO@O@@/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>["c3"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "********/O@@O@OOO/*****@** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>["g1"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*****@**/O@@O@OOO/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>["e3"],

  /*
    a7 ----- d7 -----  @
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@OOOO@@O/*@****** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>["a7"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*@******/@OOOO@@O/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>["c5"],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@O@@OOOO/*******@ w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>["g7"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*******@/@O@@OOOO/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>["e5"],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     @- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@*****/OO@O@@OO/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "a1",
    "c3",
    "a4",
    "c4",
    "c5",
    "e5",
    "a7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OO@O@@OO/**@***** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "c3",
    "a1",
    "c4",
    "a4",
    "a7",
    "g7",
    "c5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     @- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@*****/@O@OOOO@/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "a7",
    "c5",
    "a4",
    "c4",
    "c3",
    "e3",
    "a1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@O@OOOO@/**@***** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "c5",
    "a7",
    "c4",
    "a4",
    "a1",
    "g1",
    "c3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- @    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******@*/OOO@@O@O/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "g1",
    "e3",
    "g4",
    "e4",
    "e5",
    "c5",
    "g7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OOO@@O@O/******@* w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "e3",
    "g1",
    "e4",
    "g4",
    "g7",
    "a7",
    "e5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- @    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******@*/@@OOOO@O/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "g7",
    "e5",
    "g4",
    "e4",
    "e3",
    "c3",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@@OOOO@O/******@* w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "e5",
    "g7",
    "e4",
    "g4",
    "g1",
    "a1",
    "e3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****@***/OOOO@O@@/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "a7",
    "c5",
    "d7",
    "d5",
    "e5",
    "e3",
    "g7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "********/OOOO@O@@/****@*** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "c5",
    "a7",
    "d5",
    "d7",
    "g7",
    "g1",
    "e5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****@***/O@@O@OOO/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "g7",
    "e5",
    "d7",
    "d5",
    "c5",
    "c3",
    "a7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "********/O@@O@OOO/****@*** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "e5",
    "g7",
    "d5",
    "d7",
    "a7",
    "a1",
    "c5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*******/@OOOO@@O/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "a1",
    "c3",
    "d1",
    "d3",
    "e3",
    "e5",
    "g1",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@OOOO@@O/@******* w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "c3",
    "a1",
    "d3",
    "d1",
    "g1",
    "g7",
    "e3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*******/@O@@OOOO/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "g1",
    "e3",
    "d1",
    "d3",
    "c3",
    "c5",
    "a1",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@O@@OOOO/@******* w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "e3",
    "g1",
    "d3",
    "d1",
    "a1",
    "a7",
    "c3",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*****@**/OO@O@@OO/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "a1",
    "d1",
    "g1",
    "d3",
    "e3",
    "a4",
    "c4",
    "e4",
    "g4",
    "c5",
    "e5",
    "a7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "********/OO@O@@OO/*****@** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "c3",
    "d3",
    "e3",
    "d1",
    "g1",
    "c4",
    "a4",
    "g4",
    "e4",
    "a7",
    "g7",
    "c5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*******@/@O@OOOO@/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "a7",
    "d7",
    "g7",
    "d5",
    "e5",
    "a4",
    "c4",
    "e4",
    "g4",
    "c3",
    "e3",
    "a1",
  ],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@O@OOOO@/*******@ w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "c5",
    "d5",
    "e5",
    "d7",
    "g7",
    "c4",
    "a4",
    "g4",
    "e4",
    "a1",
    "g1",
    "c3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "***@****/OOO@@O@O/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "g1",
    "d1",
    "a1",
    "d3",
    "c3",
    "g4",
    "e4",
    "c4",
    "a4",
    "e5",
    "c5",
    "g7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "********/OOO@@O@O/***@**** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "e3",
    "d3",
    "c3",
    "d1",
    "a1",
    "e4",
    "g4",
    "a4",
    "c4",
    "g7",
    "a7",
    "e5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*@******/@@OOOO@O/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "g7",
    "d7",
    "a7",
    "d5",
    "c5",
    "g4",
    "e4",
    "c4",
    "a4",
    "e3",
    "c3",
    "g1",
  ],

  /*
    a7 ----- d7 -----  @
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@@OOOO@O/*@****** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "e5",
    "d5",
    "c5",
    "d7",
    "a7",
    "e4",
    "g4",
    "a4",
    "c4",
    "g1",
    "a1",
    "e3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*******@/OOOO@O@@/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "a7",
    "a4",
    "a1",
    "c4",
    "c3",
    "d7",
    "d5",
    "d3",
    "d1",
    "e5",
    "e3",
    "g7",
  ],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OOOO@O@@/*******@ w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "c5",
    "c4",
    "c3",
    "a4",
    "a1",
    "d5",
    "d7",
    "d1",
    "d3",
    "g7",
    "g1",
    "e5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*@******/O@@O@OOO/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "g7",
    "g4",
    "g1",
    "e4",
    "e3",
    "d7",
    "d5",
    "d3",
    "d1",
    "c5",
    "c3",
    "a7",
  ],

  /*
    a7 ----- d7 -----  @
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O@@O@OOO/*@****** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "e5",
    "e4",
    "e3",
    "g4",
    "g1",
    "d5",
    "d7",
    "d1",
    "d3",
    "a7",
    "a1",
    "c5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*****@**/@OOOO@@O/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "a1",
    "a4",
    "a7",
    "c4",
    "c5",
    "d1",
    "d3",
    "d5",
    "d7",
    "e3",
    "e5",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "********/@OOOO@@O/*****@** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "c3",
    "c4",
    "c5",
    "a4",
    "a7",
    "d3",
    "d1",
    "d7",
    "d5",
    "g1",
    "g7",
    "e3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "***@****/@O@@OOOO/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "g1",
    "g4",
    "g7",
    "e4",
    "e5",
    "d1",
    "d3",
    "d5",
    "d7",
    "c3",
    "c5",
    "a1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "********/@O@@OOOO/***@**** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "e3",
    "e4",
    "e5",
    "g4",
    "g7",
    "d3",
    "d1",
    "d7",
    "d5",
    "a1",
    "a7",
    "c3",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******@*/OO@O@@OO/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "d1",
    "g1",
    "c3",
    "d3",
    "e3",
    "e4",
    "g4",
    "c5",
    "e5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OO@O@@OO/******@* w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "d3",
    "e3",
    "a1",
    "d1",
    "g1",
    "g4",
    "e4",
    "a7",
    "g7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******@*/@O@OOOO@/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "d7",
    "g7",
    "c5",
    "d5",
    "e5",
    "e4",
    "g4",
    "c3",
    "e3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@O@OOOO@/******@* w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "d5",
    "e5",
    "a7",
    "d7",
    "g7",
    "g4",
    "e4",
    "a1",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@*****/OOO@@O@O/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "d1",
    "a1",
    "e3",
    "d3",
    "c3",
    "c4",
    "a4",
    "e5",
    "c5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OOO@@O@O/**@***** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "d3",
    "c3",
    "g1",
    "d1",
    "a1",
    "a4",
    "c4",
    "g7",
    "a7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@*****/@@OOOO@O/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "d7",
    "a7",
    "e5",
    "d5",
    "c5",
    "c4",
    "a4",
    "e3",
    "c3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@@OOOO@O/**@***** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "d5",
    "c5",
    "g7",
    "d7",
    "a7",
    "a4",
    "c4",
    "g1",
    "a1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*******/OOOO@O@@/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "a4",
    "a1",
    "c5",
    "c4",
    "c3",
    "d3",
    "d1",
    "e5",
    "e3",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OOOO@O@@/@******* w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "c4",
    "c3",
    "a7",
    "a4",
    "a1",
    "d1",
    "d3",
    "g7",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*******/O@@O@OOO/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "g4",
    "g1",
    "e5",
    "e4",
    "e3",
    "d3",
    "d1",
    "c5",
    "c3",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O@@O@OOO/@******* w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "e4",
    "e3",
    "g7",
    "g4",
    "g1",
    "d1",
    "d3",
    "a7",
    "a1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****@***/@OOOO@@O/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "a4",
    "a7",
    "c3",
    "c4",
    "c5",
    "d5",
    "d7",
    "e3",
    "e5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "********/@OOOO@@O/****@*** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "c4",
    "c5",
    "a1",
    "a4",
    "a7",
    "d7",
    "d5",
    "g1",
    "g7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****@***/@O@@OOOO/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "g4",
    "g7",
    "e3",
    "e4",
    "e5",
    "d5",
    "d7",
    "c3",
    "c5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "********/@O@@OOOO/****@*** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "e4",
    "e5",
    "g1",
    "g4",
    "g7",
    "d7",
    "d5",
    "a1",
    "a7",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*******@/OO@O@@OO/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "a1",
    "d1",
    "g1",
    "c3",
    "e3",
    "a4",
    "e4",
    "g4",
    "g7",
  ],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OO@O@@OO/*******@ w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "c3",
    "d3",
    "e3",
    "a1",
    "g1",
    "c4",
    "g4",
    "e4",
    "e5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*****@**/@O@OOOO@/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "a7",
    "d7",
    "g7",
    "c5",
    "e5",
    "a4",
    "e4",
    "g4",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "********/@O@OOOO@/*****@** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "c5",
    "d5",
    "e5",
    "a7",
    "g7",
    "c4",
    "g4",
    "e4",
    "e3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*@******/OOO@@O@O/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "g1",
    "d1",
    "a1",
    "e3",
    "c3",
    "g4",
    "c4",
    "a4",
    "a7",
  ],

  /*
    a7 ----- d7 -----  @
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OOO@@O@O/*@****** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "e3",
    "d3",
    "c3",
    "g1",
    "a1",
    "e4",
    "a4",
    "c4",
    "c5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "***@****/@@OOOO@O/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "g7",
    "d7",
    "a7",
    "e5",
    "c5",
    "g4",
    "c4",
    "a4",
    "a1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "********/@@OOOO@O/***@**** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "e5",
    "d5",
    "c5",
    "g7",
    "a7",
    "e4",
    "a4",
    "c4",
    "c3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*@******/OOOO@O@@/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "a7",
    "a4",
    "a1",
    "c5",
    "c3",
    "d7",
    "d3",
    "d1",
    "g1",
  ],

  /*
    a7 ----- d7 -----  @
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OOOO@O@@/*@****** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "c5",
    "c4",
    "c3",
    "a7",
    "a1",
    "d5",
    "d1",
    "d3",
    "e3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*******@/O@@O@OOO/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "g7",
    "g4",
    "g1",
    "e5",
    "e3",
    "d7",
    "d3",
    "d1",
    "a1",
  ],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O@@O@OOO/*******@ w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "e5",
    "e4",
    "e3",
    "g7",
    "g1",
    "d5",
    "d1",
    "d3",
    "c3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "***@****/@OOOO@@O/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "a1",
    "a4",
    "a7",
    "c3",
    "c5",
    "d1",
    "d5",
    "d7",
    "g7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "********/@OOOO@@O/***@**** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "c3",
    "c4",
    "c5",
    "a1",
    "a7",
    "d3",
    "d7",
    "d5",
    "e5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*****@**/@O@@OOOO/******** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "g1",
    "g4",
    "g7",
    "e3",
    "e5",
    "d1",
    "d5",
    "d7",
    "a7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "********/@O@@OOOO/*****@** w p p 5 4 4 4 0 0 0 0 0 0 0 0 6": <String>[
    "e3",
    "e4",
    "e5",
    "g1",
    "g7",
    "d3",
    "d7",
    "d5",
    "c5",
  ],

  //////////////////////////////////////////////////////////////////////////////
  ////////////////////////////  Rainer Rosenberger  ////////////////////////////
  //////////////////////////////////////////////////////////////////////////////

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |   O- @-e5  |  |
     @- O- O    e4- @-g4
    |  |   O-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@****OOO/OO@*@@OO/******@* w p p 7 2 5 2 0 0 0 0 0 0 0 0 9": <String>[
    "d1",
    "e3",
    "e4",
  ],

  /*
     O -----  @ ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- O- @    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ -- f2  |
    |         |        |
     O ----- d1 ----- g1
  */
  "******@*/OO@*@@OO/@****OOO w p p 7 2 5 2 0 0 0 0 0 0 0 0 9": <String>[
    "d3",
    "g1",
    "g4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ -- f6  |
    |  |      |     |  |
    |  |   O-d5-e5  |  |
     @- O- O    e4- @-g4
    |  |   O- @-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****@OOO/@*@OOOO@/******@* w p p 7 2 5 2 0 0 0 0 0 0 0 0 9": <String>[
    "d7",
    "e5",
    "e4",
  ],

  /*
     O ----- d7 ----- g7
    |         |        |
    |   @ --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- O- @    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
     O -----  @ ----- g1
  */
  "******@*/@*@OOOO@/****@OOO w p p 7 2 5 2 0 0 0 0 0 0 0 0 9": <String>[
    "d5",
    "g7",
    "g4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5- @- O  |  |
    a4- @-c4     O- O- @
    |  |  c3-d3- O  |  |
    |  |      |     |  |
    |  b2 --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@OOO****/OOO@@*@O/**@***** w p p 7 2 5 2 0 0 0 0 0 0 0 0 9": <String>[
    "d1",
    "c3",
    "c4",
  ],

  /*
    a7 -----  @ -----  O
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4     @- O- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  @  |
    |         |        |
    a1 ----- d1 -----  O
  */
  "**@*****/OOO@@*@O/@OOO**** w p p 7 2 5 2 0 0 0 0 0 0 0 0 9": <String>[
    "d3",
    "a1",
    "a4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5- O  |  |
    a4- @-c4     O- O- @
    |  |  c3- @- O  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*OOO@***/@@OOOO@*/**@***** w p p 7 2 5 2 0 0 0 0 0 0 0 0 9": <String>[
    "d7",
    "c5",
    "c4",
  ],

  /*
    a7 ----- d7 -----  O
    |         |        |
    |  b6 --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4     @- O- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 -----  @ -----  O
  */
  "**@*****/@@OOOO@*/*OOO@*** w p p 7 2 5 2 0 0 0 0 0 0 0 0 9": <String>[
    "d5",
    "a7",
    "a4",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |   O- O- O  |  |
    a4- @-c4     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "OO@****O/OOOO@*@@/@******* w p p 7 2 5 2 0 0 0 0 0 0 0 0 9": <String>[
    "a4",
    "c3",
    "d3",
  ],

  /*
     O -----  O -----  O
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @-c4    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*******/OOOO@*@@/OO@****O w p p 7 2 5 2 0 0 0 0 0 0 0 0 9": <String>[
    "c4",
    "a1",
    "d1",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |   O- O- O  |  |
    a4- O- @    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "OO****@O/O@@*@OOO/@******* w p p 7 2 5 2 0 0 0 0 0 0 0 0 9": <String>[
    "g4",
    "e3",
    "d3",
  ],

  /*
     O -----  O -----  O
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     @- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*******/O@@*@OOO/OO****@O w p p 7 2 5 2 0 0 0 0 0 0 0 0 9": <String>[
    "e4",
    "g1",
    "d1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4     @- O-g4
    |  |   O- O- O  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "**@OOO**/@OOOO@@*/****@*** w p p 7 2 5 2 0 0 0 0 0 0 0 0 9": <String>[
    "a4",
    "c5",
    "d5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O- @
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
     O -----  O -----  O
  */
  "****@***/@OOOO@@*/**@OOO** w p p 7 2 5 2 0 0 0 0 0 0 0 0 9": <String>[
    "c4",
    "a7",
    "d7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @    e4- @-g4
    |  |   O- O- O  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "***OOO@*/@*@@OOOO/****@*** w p p 7 2 5 2 0 0 0 0 0 0 0 0 9": <String>[
    "g4",
    "e5",
    "d5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4    e4- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
     O -----  O -----  O
  */
  "****@***/@*@@OOOO/***OOO@* w p p 7 2 5 2 0 0 0 0 0 0 0 0 9": <String>[
    "e4",
    "g7",
    "d7",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5- O  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*O******/O*O*@*@*/******** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "d5",
    "e4",
  ],

  /*
    a7 ----- d7 -----  O
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*O*@*@*/*O****** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "d7",
    "g4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3- O  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "***O****/@*O*O*@*/******** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "d3",
    "e4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 -----  O
  */
  "********/@*O*O*@*/***O**** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "d1",
    "g4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |   O-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*******O/O*@*@*O*/******** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "d5",
    "c4",
  ],

  /*
     O ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*@*@*O*/*******O b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "d7",
    "a4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |   O-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*****O**/@*@*O*O*/******** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "d3",
    "c4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
     O ----- d1 ----- g1
  */
  "********/@*@*O*O*/*****O** b p p 3 6 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "d1",
    "a4",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5- O  |  |
    a4- @-c4     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*O@*****/O*O*@*@*/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>["d5"],

  /*
    a7 ----- d7 -----  O
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*O*@*@*/*O@***** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>["d7"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4     @- O-g4
    |  |  c3-d3- O  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@O****/@*O*O*@*/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>["d3"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 -----  O
  */
  "********/@*O*O*@*/**@O**** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>["d1"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |   O-d5-e5  |  |
    a4- O- @    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******@O/O*@*@*O*/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>["d5"],

  /*
     O ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*@*@*O*/******@O w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>["d7"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @    e4- @-g4
    |  |   O-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*****O@*/@*@*O*O*/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>["d3"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
     O ----- d1 ----- g1
  */
  "********/@*@*O*O*/*****O@* w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>["d1"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3- @- O  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "***O@***/@*O*O*@*/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>["e4"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 -----  @ -----  O
  */
  "********/@*O*O*@*/***O@*** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>["g4"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |   O- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****@O**/@*@*O*O*/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>["c4"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
     O -----  @ ----- g1
  */
  "********/@*@*O*O*/****@O** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>["a4"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @- O  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@O******/O*O*@*@*/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>["e4"],

  /*
    a7 -----  @ -----  O
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*O*@*@*/@O****** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>["g4"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |   O- @-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@******O/O*@*@*O*/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>["c4"],

  /*
     O -----  @ ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*@*@*O*/@******O w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>["a4"],

  //////////////////////////////////////////////////////////////////////////////
  /////////////////////////////   Fix Bad Move    //////////////////////////////
  //////////////////////////////////////////////////////////////////////////////

  /////////////////////////////// Senior Cup 2021 //////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |   @-d5- @  |  |
    a4- @- O    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*@****O@/OOO@@O@O/******** w p p 6 3 5 3 0 0 0 0 0 0 0 0 7": <String>["d1"],

  /*
     @ ----- d7 -----  @
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OOO@@O@O/*@****O@ w p p 6 3 5 3 0 0 0 0 0 0 0 0 7": <String>["d3"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O    e4- O-g4
    |  |   @-d3- @  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "***@*@O*/@@OOOO@O/******** w p p 6 3 5 3 0 0 0 0 0 0 0 0 7": <String>["d7"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
     @ ----- d1 -----  @
  */
  "********/@@OOOO@O/***@*@O* w p p 6 3 5 3 0 0 0 0 0 0 0 0 7": <String>["d5"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |   @-d5- @  |  |
    a4- O-c4     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*@O****@/OO@O@@OO/******** w p p 6 3 5 3 0 0 0 0 0 0 0 0 7": <String>["d1"],

  /*
     @ ----- d7 -----  @
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OO@O@@OO/*@O****@ w p p 6 3 5 3 0 0 0 0 0 0 0 0 7": <String>["d3"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     O- @-g4
    |  |   @-d3- @  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O@*@**/@O@OOOO@/******** w p p 6 3 5 3 0 0 0 0 0 0 0 0 7": <String>["d7"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
     @ ----- d1 -----  @
  */
  "********/@O@OOOO@/**O@*@** w p p 6 3 5 3 0 0 0 0 0 0 0 0 7": <String>["d5"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O- @  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O@*@****/@OOOO@@O/******** w p p 6 3 5 3 0 0 0 0 0 0 0 0 7": <String>["a4"],

  /*
    a7 -----  O -----  @
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "********/@OOOO@@O/O@*@**** w p p 6 3 5 3 0 0 0 0 0 0 0 0 7": <String>["c4"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |   @- O-e5  |  |
    a4- O-c4    e4- @-g4
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O****@*@/@O@@OOOO/******** w p p 6 3 5 3 0 0 0 0 0 0 0 0 7": <String>["g4"],

  /*
     @ -----  O ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "********/@O@@OOOO/O****@*@ w p p 6 3 5 3 0 0 0 0 0 0 0 0 7": <String>["e4"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
    a4- @-c4    e4- O-g4
    |  |  c3- O- @  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*@*@O***/OOOO@O@@/******** w p p 6 3 5 3 0 0 0 0 0 0 0 0 7": <String>["a4"],

  /*
    a7 ----- d7 -----  @
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 -----  O -----  @
  */
  "********/OOOO@O@@/*@*@O*** w p p 6 3 5 3 0 0 0 0 0 0 0 0 7": <String>["c4"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |   @- O-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****O@*@/O@@O@OOO/******** w p p 6 3 5 3 0 0 0 0 0 0 0 0 7": <String>["g4"],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
     @ -----  O ----- g1
  */
  "********/O@@O@OOO/****O@*@ w p p 6 3 5 3 0 0 0 0 0 0 0 0 7": <String>["e4"],

  //////////////////////////////////////////////////////////////////////////////

  /*
     @ ----- d7 -----  @
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "**@***O*/OOO@@O@O/*@**O**@ w p p 7 2 6 2 0 0 0 0 0 0 0 0 8": <String>["a4"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |   @-d5- @  |  |
     O- @-c4    e4- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*@**O**@/OOO@@O@O/**@***O* w p p 7 2 6 2 0 0 0 0 0 0 0 0 8": <String>["c4"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
     @ ----- d1 -----  @
  */
  "**@***O*/@@OOOO@O/O**@*@** w p p 7 2 6 2 0 0 0 0 0 0 0 0 8": <String>["a4"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     O- @-c4    e4- O- @
    |  |   @-d3- @  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O**@*@**/@@OOOO@O/**@***O* w p p 7 2 6 2 0 0 0 0 0 0 0 0 8": <String>["c4"],

  /*
     @ ----- d7 -----  @
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "**O***@*/OO@O@@OO/*@**O**@ w p p 7 2 6 2 0 0 0 0 0 0 0 0 8": <String>["g4"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |   @-d5- @  |  |
     @- O-c4    e4- @- O
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*@**O**@/OO@O@@OO/**O***@* w p p 7 2 6 2 0 0 0 0 0 0 0 0 8": <String>["e4"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
     @ ----- d1 -----  @
  */
  "**O***@*/@O@OOOO@/O**@*@** w p p 7 2 6 2 0 0 0 0 0 0 0 0 8": <String>["g4"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O-c4    e4- @- O
    |  |   @-d3- @  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O**@*@**/@O@OOOO@/**O***@* w p p 7 2 6 2 0 0 0 0 0 0 0 0 8": <String>["e4"],

  /*
    a7 ----- d7 -----  @
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     O- @-c4    e4- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "O***@***/@OOOO@@O/*@*@**O* w p p 7 2 6 2 0 0 0 0 0 0 0 0 8": <String>["d7"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
    a4- @- O    e4- O-g4
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "*@*@**O*/@OOOO@@O/O***@*** w p p 7 2 6 2 0 0 0 0 0 0 0 0 8": <String>["d5"],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O-c4    e4- @- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "O***@***/@O@@OOOO/**O**@*@ w p p 7 2 6 2 0 0 0 0 0 0 0 0 8": <String>["d7"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
    a4- O-c4     O- @-g4
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "**O**@*@/@O@@OOOO/O***@*** w p p 7 2 6 2 0 0 0 0 0 0 0 0 8": <String>["d5"],

  /*
    a7 ----- d7 -----  @
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- @-c4    e4- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "@***O***/OOOO@O@@/*@*@**O* w p p 7 2 6 2 0 0 0 0 0 0 0 0 8": <String>["d1"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
    a4- @- O    e4- O-g4
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "*@*@**O*/OOOO@O@@/@***O*** w p p 7 2 6 2 0 0 0 0 0 0 0 0 8": <String>["d3"],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O-c4    e4- @- O
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "@***O***/O@@O@OOO/**O**@*@ w p p 7 2 6 2 0 0 0 0 0 0 0 0 8": <String>["d1"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
    a4- O-c4     O- @-g4
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "**O**@*@/O@@O@OOO/@***O*** w p p 7 2 6 2 0 0 0 0 0 0 0 0 8": <String>["d3"],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 -----  O
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "****O***/O*O*@*@*/*O@*@*O* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "a1",
    "b2",
    "f2",
    "c3",
    "e4",
    "c5",
    "d5",
    "e5",
    "b6",
    "f6",
    "d7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5- O  |  |
    a4- @- O     @- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "*O@*@*O*/O*O*@*@*/****O*** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "c3",
    "b2",
    "f2",
    "a1",
    "g4",
    "a7",
    "d7",
    "g7",
    "b6",
    "f6",
    "d5",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     O- @-c4    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 -----  O
  */
  "O*******/@*O*O*@*/@*@O**O* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "a7",
    "b6",
    "f6",
    "c5",
    "e4",
    "c3",
    "d3",
    "e3",
    "b2",
    "f2",
    "d1",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @- O     @- O-g4
    |  |  c3-d3- O  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*@O**O*/@*O*O*@*/O******* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "c5",
    "b6",
    "f6",
    "a7",
    "g4",
    "a1",
    "d1",
    "g1",
    "b2",
    "f2",
    "d3",
  ],

  /*
     O ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4    e4- @- O
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "****O***/O*@*@*O*/**O*@*@O b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "g1",
    "f2",
    "b2",
    "e3",
    "c4",
    "e5",
    "d5",
    "c5",
    "f6",
    "b6",
    "d7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |   O-d5-e5  |  |
    a4- O- @     O- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "**O*@*@O/O*@*@*O*/****O*** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "e3",
    "f2",
    "b2",
    "g1",
    "a4",
    "g7",
    "d7",
    "a7",
    "f6",
    "b6",
    "d5",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
     O ----- d1 ----- g1
  */
  "O*******/@*@*O*O*/@*O**O@* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "g7",
    "f6",
    "b6",
    "e5",
    "c4",
    "e3",
    "d3",
    "c3",
    "f2",
    "b2",
    "d1",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O- @     O- @-g4
    |  |   O-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*O**O@*/@*@*O*O*/O******* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "e5",
    "f6",
    "b6",
    "g7",
    "a4",
    "g1",
    "d1",
    "a1",
    "f2",
    "b2",
    "d3",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- @- O    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 -----  @ -----  O
  */
  "******O*/@*O*O*@*/O**O@*@* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "a7",
    "b6",
    "b2",
    "c5",
    "d3",
    "e5",
    "e4",
    "e3",
    "f6",
    "f2",
    "g4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     O- @- @    e4- O-g4
    |  |  c3- @- O  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O**O@*@*/@*O*O*@*/******O* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "c5",
    "b6",
    "b2",
    "a7",
    "d1",
    "g7",
    "g4",
    "g1",
    "f6",
    "f2",
    "e4",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     O- @- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
     O -----  @ ----- g1
  */
  "**O*****/@*@*O*O*/O*@*@O** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "g7",
    "f6",
    "f2",
    "e5",
    "d3",
    "c5",
    "c4",
    "c3",
    "b6",
    "b2",
    "a4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O-c4     @- @- O
    |  |   O- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*@*@O**/@*@*O*O*/**O***** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "e5",
    "f6",
    "f2",
    "g7",
    "d1",
    "a7",
    "a4",
    "a1",
    "b6",
    "b2",
    "c4",
  ],

  /*
    a7 -----  @ -----  O
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- @- O    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "******O*/O*O*@*@*/@O**O*@* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "a1",
    "b2",
    "b6",
    "c3",
    "d5",
    "e3",
    "e4",
    "e5",
    "f2",
    "f6",
    "g4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @- O  |  |
     O- @- @    e4- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@O**O*@*/O*O*@*@*/******O* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "c3",
    "b2",
    "b6",
    "a1",
    "d7",
    "g1",
    "g4",
    "g7",
    "f2",
    "f6",
    "e4",
  ],

  /*
     O -----  @ ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     O- @- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "**O*****/O*@*@*O*/@*@*O**O b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "g1",
    "f2",
    "f6",
    "e3",
    "d5",
    "c3",
    "c4",
    "c5",
    "b2",
    "b6",
    "a4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |   O- @-e5  |  |
    a4- O-c4     @- @- O
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*@*O**O/O*@*@*O*/**O***** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "e3",
    "f2",
    "f6",
    "g1",
    "d7",
    "a1",
    "a4",
    "a7",
    "b2",
    "b6",
    "c4",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     @- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@*****/@*@*O*O*/O*O***** b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "d1",
    "g1",
    "b2",
    "f2",
    "d3",
    "a4",
    "c4",
    "c5",
    "b6",
    "a7",
    "g7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O-c4     O- @- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*O*****/@*@*O*O*/**@***** b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "d3",
    "e3",
    "b2",
    "f2",
    "d1",
    "c4",
    "a4",
    "a7",
    "b6",
    "c5",
    "e5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     @- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "**@*****/O*@*@*O*/**O*O*** b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "d7",
    "g7",
    "b6",
    "f6",
    "d5",
    "a4",
    "c4",
    "c3",
    "b2",
    "a1",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     O- @- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*O***/O*@*@*O*/**@***** b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "d5",
    "e5",
    "b6",
    "f6",
    "d7",
    "c4",
    "a4",
    "a1",
    "b2",
    "c3",
    "e3",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @- @    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******@*/@*O*O*@*/O*****O* b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "d1",
    "a1",
    "f2",
    "b2",
    "d3",
    "g4",
    "e4",
    "e5",
    "f6",
    "g7",
    "a7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- @- O    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*****O*/@*O*O*@*/******@* b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "d3",
    "c3",
    "f2",
    "b2",
    "d1",
    "e4",
    "g4",
    "g7",
    "f6",
    "e5",
    "c5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @- @    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "******@*/O*O*@*@*/****O*O* b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "d7",
    "a7",
    "f6",
    "b6",
    "d5",
    "g4",
    "e4",
    "e3",
    "f2",
    "g1",
    "a1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- @- O    e4- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****O*O*/O*O*@*@*/******@* b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "d5",
    "c5",
    "f6",
    "b6",
    "d7",
    "e4",
    "g4",
    "g1",
    "f2",
    "e3",
    "c3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "****@***/O*@*@*O*/**O*O*** b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "a4",
    "a1",
    "b6",
    "b2",
    "c4",
    "d7",
    "d5",
    "e5",
    "f6",
    "g7",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     O- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "**O*O***/O*@*@*O*/****@*** b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "c4",
    "c3",
    "b6",
    "b2",
    "a4",
    "d5",
    "d7",
    "g7",
    "f6",
    "e5",
    "e3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "****@***/O*O*@*@*/****O*O* b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "g4",
    "g1",
    "f6",
    "f2",
    "e4",
    "d7",
    "d5",
    "c5",
    "b6",
    "a7",
    "a1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O    e4- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "****O*O*/O*O*@*@*/****@*** b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "e4",
    "e3",
    "f6",
    "f2",
    "g4",
    "d5",
    "d7",
    "a7",
    "b6",
    "c5",
    "c3",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*******/@*@*O*O*/O*O***** b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "a4",
    "a7",
    "b2",
    "b6",
    "c4",
    "d1",
    "d3",
    "e3",
    "f2",
    "g1",
    "g7",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O-c4     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*O*****/@*@*O*O*/@******* b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "c4",
    "c5",
    "b2",
    "b6",
    "a4",
    "d3",
    "d1",
    "g1",
    "f2",
    "e3",
    "e5",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*******/@*O*O*@*/O*****O* b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "g4",
    "g7",
    "f2",
    "f6",
    "e4",
    "d1",
    "d3",
    "c3",
    "b2",
    "a1",
    "a7",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @- O    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*****O*/@*O*O*@*/@******* b p p 4 5 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "e4",
    "e5",
    "f2",
    "f6",
    "g4",
    "d3",
    "d1",
    "a1",
    "b2",
    "c3",
    "c5",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "*******@/O*O*@*@*/****O*** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "a1",
    "g1",
    "b2",
    "f2",
    "c3",
    "d3",
    "e3",
    "a4",
    "c4",
    "e4",
    "g4",
    "d5",
    "e5",
    "b6",
    "f6",
    "a7",
    "g7",
  ],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****O***/O*O*@*@*/*******@ w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "c3",
    "e3",
    "b2",
    "f2",
    "a1",
    "d1",
    "g1",
    "c4",
    "a4",
    "g4",
    "e4",
    "d7",
    "g7",
    "b6",
    "f6",
    "c5",
    "e5",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*****@**/@*O*O*@*/O******* w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "a7",
    "g7",
    "b6",
    "f6",
    "c5",
    "d5",
    "e5",
    "a4",
    "c4",
    "e4",
    "g4",
    "d3",
    "e3",
    "b2",
    "f2",
    "a1",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "O*******/@*O*O*@*/*****@** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "c5",
    "e5",
    "b6",
    "f6",
    "a7",
    "d7",
    "g7",
    "c4",
    "a4",
    "g4",
    "e4",
    "d1",
    "g1",
    "b2",
    "f2",
    "c3",
    "e3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "*@******/O*@*@*O*/****O*** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "g1",
    "a1",
    "f2",
    "b2",
    "e3",
    "d3",
    "c3",
    "g4",
    "e4",
    "c4",
    "a4",
    "d5",
    "c5",
    "f6",
    "b6",
    "g7",
    "a7",
  ],

  /*
    a7 ----- d7 -----  @
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****O***/O*@*@*O*/*@****** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "e3",
    "c3",
    "f2",
    "b2",
    "g1",
    "d1",
    "a1",
    "e4",
    "g4",
    "a4",
    "c4",
    "d7",
    "a7",
    "f6",
    "b6",
    "e5",
    "c5",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "***@****/@*@*O*O*/O******* w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "g7",
    "a7",
    "f6",
    "b6",
    "e5",
    "d5",
    "c5",
    "g4",
    "e4",
    "c4",
    "a4",
    "d3",
    "c3",
    "f2",
    "b2",
    "g1",
    "a1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "O*******/@*@*O*O*/***@**** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "e5",
    "c5",
    "f6",
    "b6",
    "g7",
    "d7",
    "a7",
    "e4",
    "g4",
    "a4",
    "c4",
    "d1",
    "a1",
    "f2",
    "b2",
    "e3",
    "c3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
     O- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*@******/@*O*O*@*/******O* w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "a7",
    "a1",
    "b6",
    "b2",
    "c5",
    "c4",
    "c3",
    "d7",
    "d5",
    "d3",
    "d1",
    "e4",
    "e3",
    "f6",
    "f2",
    "g7",
    "g1",
  ],

  /*
    a7 ----- d7 -----  @
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******O*/@*O*O*@*/*@****** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "c5",
    "c3",
    "b6",
    "b2",
    "a7",
    "a4",
    "a1",
    "d5",
    "d7",
    "d1",
    "d3",
    "g4",
    "g1",
    "f6",
    "f2",
    "e5",
    "e3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
    a4- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*******@/@*@*O*O*/**O***** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "g7",
    "g1",
    "f6",
    "f2",
    "e5",
    "e4",
    "e3",
    "d7",
    "d5",
    "d3",
    "d1",
    "c4",
    "c3",
    "b6",
    "b2",
    "a7",
    "a1",
  ],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*****/@*@*O*O*/*******@ w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "e5",
    "e3",
    "f6",
    "f2",
    "g7",
    "g4",
    "g1",
    "d5",
    "d7",
    "d1",
    "d3",
    "a4",
    "a1",
    "b6",
    "b2",
    "c5",
    "c3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O-g4
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "***@****/O*O*@*@*/******O* w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "a1",
    "a7",
    "b2",
    "b6",
    "c3",
    "c4",
    "c5",
    "d1",
    "d3",
    "d5",
    "d7",
    "e4",
    "e5",
    "f2",
    "f6",
    "g1",
    "g7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "******O*/O*O*@*@*/***@**** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "c3",
    "c5",
    "b2",
    "b6",
    "a1",
    "a4",
    "a7",
    "d3",
    "d1",
    "d7",
    "d5",
    "g4",
    "g7",
    "f2",
    "f6",
    "e3",
    "e5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @- O
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*****@**/O*@*@*O*/**O***** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "g1",
    "g7",
    "f2",
    "f6",
    "e3",
    "e4",
    "e5",
    "d1",
    "d3",
    "d5",
    "d7",
    "c4",
    "c5",
    "b2",
    "b6",
    "a1",
    "a7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "**O*****/O*@*@*O*/*****@** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "e3",
    "e5",
    "f2",
    "f6",
    "g1",
    "g4",
    "g7",
    "d3",
    "d1",
    "d7",
    "d5",
    "a4",
    "a7",
    "b2",
    "b6",
    "c3",
    "c5",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "********/O@O*@*@*/**@*O*O* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "b2",
    "c3",
    "d3",
    "e3",
    "c4",
    "e4",
    "c5",
    "d5",
    "e5",
    "g7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O     @- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@*O*O*/O@O*@*@*/******** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "b2",
    "a1",
    "d1",
    "g1",
    "a4",
    "g4",
    "a7",
    "d7",
    "g7",
    "e5",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*O@O*@*/O*@***O* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "b6",
    "c5",
    "d5",
    "e5",
    "c4",
    "e4",
    "c3",
    "d3",
    "e3",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @- O     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*@***O*/@*O@O*@*/******** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "b6",
    "a7",
    "d7",
    "g7",
    "a4",
    "g4",
    "a1",
    "d1",
    "g1",
    "e3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "********/O*@*@*O@/**O*O*@* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "f2",
    "e3",
    "d3",
    "c3",
    "e4",
    "c4",
    "e5",
    "d5",
    "c5",
    "a7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @     O- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*O*@*/O*@*@*O@/******** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "f2",
    "g1",
    "d1",
    "a1",
    "g4",
    "a4",
    "g7",
    "d7",
    "a7",
    "c5",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*@*O@O*/O*O***@* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "f6",
    "e5",
    "d5",
    "c5",
    "e4",
    "c4",
    "e3",
    "d3",
    "c3",
    "a1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O- @     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*O***@*/@*@*O@O*/******** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "f6",
    "g7",
    "d7",
    "a7",
    "g4",
    "a4",
    "g1",
    "d1",
    "a1",
    "c3",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "********/@*O@O*@*/O***@*O* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "b6",
    "c5",
    "c4",
    "c3",
    "d5",
    "d3",
    "e5",
    "e4",
    "e3",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @- O    e4- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O***@*O*/@*O@O*@*/******** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "b6",
    "a7",
    "a4",
    "a1",
    "d7",
    "d1",
    "g7",
    "g4",
    "g1",
    "e3",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "********/@*@*O@O*/O*O*@*** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "f6",
    "e5",
    "e4",
    "e3",
    "d5",
    "d3",
    "c5",
    "c4",
    "c3",
    "a1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O-c4     O- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*O*@***/@*@*O@O*/******** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "f6",
    "g7",
    "g4",
    "g1",
    "d7",
    "d1",
    "a7",
    "a4",
    "a1",
    "c3",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "********/O@O*@*@*/@***O*O* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "b2",
    "c3",
    "c4",
    "c5",
    "d3",
    "d5",
    "e3",
    "e4",
    "e5",
    "g7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @- O    e4- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@***O*O*/O@O*@*@*/******** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "b2",
    "a1",
    "a4",
    "a7",
    "d1",
    "d7",
    "g1",
    "g4",
    "g7",
    "e5",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "********/O*@*@*O@/@*O*O*** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "f2",
    "e3",
    "e4",
    "e5",
    "d3",
    "d5",
    "c3",
    "c4",
    "c5",
    "a7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O-c4     O- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*O*O***/O*@*@*O@/******** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "f2",
    "g1",
    "g4",
    "g7",
    "d1",
    "d7",
    "a1",
    "a4",
    "a7",
    "c5",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
     O -----  O -----  @
  */
  "**@*****/O@O*@*O*/@**@OO** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["c5"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O-c4    e4- O- @
    |  |   O- O- @  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@**@OO**/O@O*@*O*/**@***** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["a7"],

  /*
     O -----  O -----  @
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "**@*****/@*O@O*O*/O@**@**O w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["c3"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |   O- O- @  |  |
    a4- O-c4    e4- O- @
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O@**@**O/@*O@O*O*/**@***** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["a1"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
     @ -----  O -----  O
  */
  "******@*/O*O*@*O@/@**OO@** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["e5"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     @- O-c4    e4- O-g4
    |  |   @- O- O  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@**OO@**/O*O*@*O@/******@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["g7"],

  /*
     @ -----  O -----  O
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "******@*/@*O*O@O*/OO**@**@ w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["e3"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |   @- O- O  |  |
     @- O-c4    e4- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "OO**@**@/@*O*O@O*/******@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["g1"],

  /*
     O ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O- @
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "****@***/O*O@O*@*/**@**@OO w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["e5"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |   O-d5-e5  |  |
    a4- @- O     @- O-g4
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "**@**@OO/O*O@O*@*/****@*** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["g7"],

  /*
    a7 ----- d7 -----  O
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4    e4- @- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "****@***/O*@*O@O*/*OO@**@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["c5"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5- O  |  |
    a4- O- @     O- @-g4
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "*OO@**@*/O*@*O@O*/****@*** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["a7"],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- @-c4    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
     O ----- d1 ----- g1
  */
  "@*******/O@O*O*@*/**@**OO@ w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["e3"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
    a4- @- O     @- O-g4
    |  |   O-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@**OO@/O@O*O*@*/@******* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["g1"],

  /*
    a7 ----- d7 -----  @
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     @- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 -----  O
  */
  "@*******/O*@*O*O@/*@OO**@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["c3"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
    a4- O- @     O- @-g4
    |  |  c3-d3- O  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*@OO**@*/O*@*O*O@/@******* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["a1"],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- O- @    e4- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****@*@*/@*@*O*O*/O*****O* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["c5"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O- O    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O*****O*/@*@*O*O*/****@*@* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["a7"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- O- @    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@*****@*/O*@*@*O*/****O*O* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["c3"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O- O    e4- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****O*O*/O*@*@*O*/@*****@* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["a1"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4     @- O- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@*@***/@*O*O*@*/O*O***** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["e5"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @-c4     O- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O*O*****/@*O*O*@*/**@*@*** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["g7"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @-c4     @- O- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@*@*****/O*O*@*@*/**O*O*** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["e3"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4     O- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*O***/O*O*@*@*/@*@***** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["g1"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O- @    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*****@*/O*@*@*O*/O*O***** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["e5"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O-c4     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*O*****/O*@*@*O*/@*****@* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["g7"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- @-c4     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*@*****/O*O*@*@*/O*****O* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["c5"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @- O    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*****O*/O*O*@*@*/@*@***** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["a7"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @    e4- @- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "****@*@*/@*@*O*O*/**O*O*** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["e3"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4     O- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "**O*O***/@*@*O*O*/****@*@* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["g1"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4     @- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "**@*@***/@*O*O*@*/****O*O* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["c3"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O    e4- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "****O*O*/@*O*O*@*/**@*@*** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["a1"],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 -----  @ -----  O
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4-b4- O     O- @- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "O*O***O*/@*@*****/@O@*O*** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "b2",
    "d2",
    "d3",
    "b4",
    "c5",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- @- O  |  |
     O-b4-c4     @- @- O
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@O@*O***/@*@*****/O*O***O* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "b2",
    "d2",
    "d1",
    "b4",
    "a7",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4- O     O- @- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  @ -----  O
  */
  "**O*O*O*/**@*@***/O*@O@*** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "b6",
    "d6",
    "d5",
    "b4",
    "c3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     O-b4-c4     @- @- O
    |  |  c3- @- O  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "O*@O@***/**@*@***/**O*O*O* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "b6",
    "d6",
    "d7",
    "b4",
    "a1",
  ],

  /*
     O -----  @ ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- @- O     O-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "O*O***O*/@*****@*/@***O*@O b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "f2",
    "d2",
    "d3",
    "f4",
    "e5",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |   O- @-e5  |  |
     O- @- @    e4-f4- O
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@***O*@O/@*****@*/O*O***O* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "f2",
    "d2",
    "d1",
    "f4",
    "g7",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- @- O     O-f4-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
     O -----  @ ----- g1
  */
  "**O*O*O*/****@*@*/O***@O@* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "f6",
    "d6",
    "d5",
    "f4",
    "e3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     O- @- @    e4-f4- O
    |  |   O- @-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "O***@O@*/****@*@*/**O*O*O* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "f6",
    "d6",
    "d7",
    "f4",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     O-b4-c4     O- @- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  @ -----  O
  */
  "O*O*O***/**@*@***/**@O@*O* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "b6",
    "b4",
    "c4",
    "d6",
    "e5",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4- O     @- @- O
    |  |  c3- @- O  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "**@O@*O*/**@*@***/O*O*O*** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "b6",
    "b4",
    "a4",
    "d6",
    "g7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- @- O    e4-f4- O
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
     O -----  @ ----- g1
  */
  "O***O*O*/****@*@*/**O*@O@* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "f6",
    "f4",
    "e4",
    "d6",
    "c5",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @- @     O-f4-g4
    |  |   O- @-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "**O*@O@*/****@*@*/O***O*O* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "f6",
    "f4",
    "g4",
    "d6",
    "a7",
  ],

  /*
    a7 -----  @ -----  O
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     O-b4-c4     O- @- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*O*O***/@*@*****/@O@***O* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "b2",
    "b4",
    "c4",
    "d2",
    "e3",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- @- O  |  |
    a4-b4- O     @- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@O@***O*/@*@*****/O*O*O*** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "b2",
    "b4",
    "a4",
    "d2",
    "g1",
  ],

  /*
     O -----  @ ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- @- O    e4-f4- O
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O***O*O*/@*****@*/@*O***@O b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "f2",
    "f4",
    "e4",
    "d2",
    "c3",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |   O- @-e5  |  |
     O- @- @     O-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@*O***@O/@*****@*/O***O*O* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "f2",
    "f4",
    "g4",
    "d2",
    "a1",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- @- O     O- O- @
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@*O*@*O*/O@OO@O@@/@*@*O*O* w p p 8 1 8 1 0 0 0 0 0 0 0 0 9": <String>[
    "g1",
    "g7",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- @- O     @- O- O
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "@*@*O*O*/O@OO@O@@/@*O*@*O* w p p 8 1 8 1 0 0 0 0 0 0 0 0 9": <String>[
    "e3",
    "e5",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- @- O     O- O- @
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "@*O*@*O*/@OO@O@@O/O*@*@*O* w p p 8 1 8 1 0 0 0 0 0 0 0 0 9": <String>[
    "g7",
    "g1",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     O- @- O     @- O- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O*@*@*O*/@OO@O@@O/@*O*@*O* w p p 8 1 8 1 0 0 0 0 0 0 0 0 9": <String>[
    "e5",
    "e3",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     @- O- O     O- @- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@*O*@*O*/O@@O@OO@/@*O*O*@* w p p 8 1 8 1 0 0 0 0 0 0 0 0 9": <String>[
    "a1",
    "a7",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- O- @     O- @- O
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "@*O*O*@*/O@@O@OO@/@*O*@*O* w p p 8 1 8 1 0 0 0 0 0 0 0 0 9": <String>[
    "c3",
    "c5",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     @- O- O     O- @- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "@*O*@*O*/@O@@O@OO/O*O*@*@* w p p 8 1 8 1 0 0 0 0 0 0 0 0 9": <String>[
    "a7",
    "a1",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     O- O- @     O- @- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O*O*@*@*/@O@@O@OO/@*O*@*O* w p p 8 1 8 1 0 0 0 0 0 0 0 0 9": <String>[
    "c5",
    "c3",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     O- @- @     @- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O*@*O*@*/@@O@OO@O/O*@*@*O* w p p 8 1 8 1 0 0 0 0 0 0 0 0 9": <String>[
    "a1",
    "g1",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- @- O     @- O- @
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "O*@*@*O*/@@O@OO@O/O*@*O*@* w p p 8 1 8 1 0 0 0 0 0 0 0 0 9": <String>[
    "c3",
    "e3",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O- @     @- @- O
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O*@*O*@*/@O@OO@O@/O*O*@*@* w p p 8 1 8 1 0 0 0 0 0 0 0 0 9": <String>[
    "g1",
    "a1",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O- @     O- @- @
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "O*O*@*@*/@O@OO@O@/O*@*O*@* w p p 8 1 8 1 0 0 0 0 0 0 0 0 9": <String>[
    "e3",
    "c3",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     O- @- @     @- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "O*@*O*@*/O@O@@O@O/@*@*O*O* w p p 8 1 8 1 0 0 0 0 0 0 0 0 9": <String>[
    "a7",
    "g7",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     @- @- O     @- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@*@*O*O*/O@O@@O@O/O*@*O*@* w p p 8 1 8 1 0 0 0 0 0 0 0 0 9": <String>[
    "c5",
    "e5",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O- @     @- @- O
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "O*@*O*@*/OO@O@@O@/@*O*O*@* w p p 8 1 8 1 0 0 0 0 0 0 0 0 9": <String>[
    "g7",
    "a7",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     @- O- @     O- @- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@*O*O*@*/OO@O@@O@/O*@*O*@* w p p 8 1 8 1 0 0 0 0 0 0 0 0 9": <String>[
    "e5",
    "c5",
  ],

  //////////////////////////////////////////////////////////////////////////////
  //////////////////////////////////   Trap    /////////////////////////////////
  //////////////////////////////////////////////////////////////////////////////

  /////////////////////////////// Senior Cup 2021 //////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
    a4- @- O    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******O@/OOO@@O@O/******** b p p 6 3 4 4 0 0 0 0 0 0 0 0 6": <String>["e5"],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OOO@@O@O/******O@ b p p 6 3 4 4 0 0 0 0 0 0 0 0 6": <String>["g7"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O    e4- O-g4
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*****@O*/@@OOOO@O/******** b p p 6 3 4 4 0 0 0 0 0 0 0 0 6": <String>["e3"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "********/@@OOOO@O/*****@O* b p p 6 3 4 4 0 0 0 0 0 0 0 0 6": <String>["g1"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
    a4- O-c4     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*@O*****/OO@O@@OO/******** b p p 6 3 4 4 0 0 0 0 0 0 0 0 6": <String>["c5"],

  /*
    a7 ----- d7 -----  @
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OO@O@@OO/*@O***** b p p 6 3 4 4 0 0 0 0 0 0 0 0 6": <String>["a7"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     O- @-g4
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O@****/@O@OOOO@/******** b p p 6 3 4 4 0 0 0 0 0 0 0 0 6": <String>["c3"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "********/@O@OOOO@/**O@**** b p p 6 3 4 4 0 0 0 0 0 0 0 0 6": <String>["a1"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O- @  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O@******/@OOOO@@O/******** b p p 6 3 4 4 0 0 0 0 0 0 0 0 6": <String>["e3"],

  /*
    a7 -----  O -----  @
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@OOOO@@O/O@****** b p p 6 3 4 4 0 0 0 0 0 0 0 0 6": <String>["g1"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |   @- O-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O******@/@O@@OOOO/******** b p p 6 3 4 4 0 0 0 0 0 0 0 0 6": <String>["c3"],

  /*
     @ -----  O ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@O@@OOOO/O******@ b p p 6 3 4 4 0 0 0 0 0 0 0 0 6": <String>["a1"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3- O- @  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "***@O***/OOOO@O@@/******** b p p 6 3 4 4 0 0 0 0 0 0 0 0 6": <String>["e5"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 -----  O -----  @
  */
  "********/OOOO@O@@/***@O*** b p p 6 3 4 4 0 0 0 0 0 0 0 0 6": <String>["g7"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |   @- O-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****O@**/O@@O@OOO/******** b p p 6 3 4 4 0 0 0 0 0 0 0 0 6": <String>["c5"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
     @ -----  O ----- g1
  */
  "********/O@@O@OOO/****O@** b p p 6 3 4 4 0 0 0 0 0 0 0 0 6": <String>["a7"],

  //////////////////////////////////////////////////////////////////////////////

  /*
     O -----  O -----  @
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 -----  O
  */
  "********/@*O*O*@*/O@@O***O b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>["d3"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |   O- O- @  |  |
    a4- @-c4     @- O-g4
    |  |  c3-d3- O  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O@@O***O/@*O*O*@*/******** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>["d1"],

  /*
    a7 ----- d7 -----  O
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
     O -----  O -----  @
  */
  "********/O*O*@*@*/*O@@OO** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>["d5"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5- O  |  |
    a4- @-c4     @- O-g4
    |  |   O- O- @  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*O@@OO**/O*O*@*@*/******** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>["d7"],

  /*
     @ -----  O -----  O
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
     O ----- d1 ----- g1
  */
  "********/@*@*O*O*/OO***O@@ b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>["d3"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |   @- O- O  |  |
    a4- O- @    e4- @-g4
    |  |   O-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "OO***O@@/@*@*O*O*/******** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>["d1"],

  /*
     O ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
     @ -----  O -----  O
  */
  "********/O*@*@*O*/***OO@@O b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>["d5"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |   O-d5-e5  |  |
    a4- O- @    e4- @-g4
    |  |   @- O- O  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "***OO@@O/O*@*@*O*/******** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>["d7"],

  /*
    a7 ----- d7 -----  O
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
     O -----  @ -----  @
  */
  "********/@*@*O*O*/*OO@@O** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>["c4"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5- O  |  |
    a4- O-c4     O- @-g4
    |  |   O- @- @  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*OO@@O**/@*@*O*O*/******** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>["a4"],

  /*
     O ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
     @ -----  @ -----  O
  */
  "********/@*O*O*@*/***O@@OO b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>["e4"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |   O-d5-e5  |  |
    a4- @- O    e4- O-g4
    |  |   @- @- O  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "***O@@OO/@*O*O*@*/******** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>["g4"],

  /*
     O -----  @ -----  @
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 -----  O
  */
  "********/O*@*@*O*/@@OO***O b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>["c4"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |   O- @- @  |  |
    a4- O-c4     O- @-g4
    |  |  c3-d3- O  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@@OO***O/O*@*@*O*/******** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>["a4"],

  /*
     @ -----  @ -----  O
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
     O ----- d1 ----- g1
  */
  "********/O*O*@*@*/@O***OO@ b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>["e4"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |   @- @- O  |  |
    a4- @- O    e4- O-g4
    |  |   O-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@O***OO@/O*O*@*@*/******** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>["g4"],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     @- O-c4     @- O- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@*@*****/O@O*@*O*/**O*O*@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["c3"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @     O- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*O*@*/O@O*@*O*/@*@***** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["a1"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4     @- O- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@*@***/@*O@O*O*/O*O***@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["c5"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O- @     O- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O*O***@*/@*O@O*O*/**@*@*** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["a7"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- O- @    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@*****@*/O*O*@*O@/**@*O*O* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["e3"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O- O     @- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@*O*O*/O*O*@*O@/@*****@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["g1"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- O- @    e4- O- @
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****@*@*/@*O*O@O*/O*@***O* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["e5"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O- O     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O*@***O*/@*O*O@O*/****@*@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["g7"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4     @- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "**@*@***/O*O@O*@*/@***O*O* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["c5"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @- O    e4- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "@***O*O*/O*O@O*@*/**@*@*** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["a7"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @    e4- @- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "****@*@*/O*@*O@O*/@*O*O*** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["e5"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     @- O-c4     O- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "@*O*O***/O*@*O@O*/****@*@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["g7"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- @-c4     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "@*@*****/O@O*O*@*/O***@*O* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["c3"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @- O    e4- O- @
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O***@*O*/O@O*O*@*/@*@***** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["a1"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O- @    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "@*****@*/O*@*O*O@/O*O*@*** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["e3"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O-c4     O- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*O*@***/O*@*O*O@/@*****@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["g1"],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- O- @     @- @- O
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*@*O*@*/O*@*@*O*/**O***O* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["f2"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O- O     O- @- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "**O***O*/O*@*@*O*/@*@*O*@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["f2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     O- O- @     @- @- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*@*@*@*/@*@*O*O*/**O***O* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["f6"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O- O     O- @- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "**O***O*/@*@*O*O*/O*@*@*@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["f6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- @- @     @- O- O
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*@*O*@*/O*O*@*@*/**O***O* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["b2"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- @- O     O- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "**O***O*/O*O*@*@*/@*@*O*@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["b2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     O- @- @     @- O- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*@*@*@*/@*O*O*@*/**O***O* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["b6"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- @- O     O- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "**O***O*/@*O*O*@*/O*@*@*@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["b6"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @- O     @- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@*@*@*O*/O*O*@*@*/O***O*** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["b2"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     O- @-c4    e4- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O***O***/O*O*@*@*/@*@*@*O* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["b2"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O- @     O- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@*O*@*@*/O*@*@*O*/O***O*** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["f2"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O-c4    e4- @- O
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O***O***/O*@*@*O*/@*O*@*@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["f2"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @- O     @- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@*@*@*O*/@*O*O*@*/O***O*** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["b6"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     O- @-c4    e4- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O***O***/@*O*O*@*/@*@*@*O* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["b6"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O- @     O- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@*O*@*@*/@*@*O*O*/O***O*** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["f6"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O-c4    e4- @- O
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O***O***/@*@*O*O*/@*O*@*@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["f6"],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @-c4     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*O*****/O@@OO@@O/******** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "g1",
    "g4",
    "g7",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O@@OO@@O/@*O***** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "e3",
    "e4",
    "e5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4     O- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*@***/OO@@OO@@/******** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "g7",
    "g4",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "********/OO@@OO@@/**O*@*** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "e5",
    "e4",
    "e3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @- O    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*****O*/OO@@OO@@/******** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "a1",
    "a4",
    "a7",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OO@@OO@@/@*****O* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "c3",
    "c4",
    "c5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O    e4- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****@*O*/O@@OO@@O/******** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "a7",
    "a4",
    "a1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "********/O@@OO@@O/****@*O* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "c5",
    "c4",
    "c3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     @- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@*O***/@OO@@OO@/******** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "a1",
    "d1",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "********/@OO@@OO@/**@*O*** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "c3",
    "d3",
    "e3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @    e4- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****O*@*/@@OO@@OO/******** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "g1",
    "d1",
    "a1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "********/@@OO@@OO/****O*@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "e3",
    "d3",
    "c3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O-c4     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*@*****/@@OO@@OO/******** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "a7",
    "d7",
    "g7",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@@OO@@OO/O*@***** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "c5",
    "d5",
    "e5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O- @    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*****@*/@OO@@OO@/******** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "g7",
    "d7",
    "a7",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@OO@@OO@/O*****@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "e5",
    "d5",
    "c5",
  ],

  //////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////   Self-Play    ///////////////////////////////
  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O -- d6 --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @-c4    e4- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O***O***/*@OO@*@O/@*@***** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "a1",
    "a4",
    "g1",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O -- d6 --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @-c4     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@*@*****/*@OO@*@O/O***O*** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "c3",
    "c4",
    "e3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @-c4    e4- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O -- d2 --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O***O***/@OO@*O@*/**@*@*** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "a7",
    "a4",
    "g7",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4     @- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O -- d2 --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "**@*@***/@OO@*O@*/O***O*** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "c5",
    "c4",
    "e5",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ -- d6 --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O-c4    e4- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O***O***/*O@*@OO@/@*****@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "g1",
    "g4",
    "a1",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ -- d6 --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O- @    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@*****@*/*O@*@OO@/O***O*** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "e3",
    "e4",
    "c3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O-c4    e4- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ -- d2 --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O***O***/@*@O*@OO/****@*@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "g7",
    "g4",
    "a7",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @    e4- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ -- d2 --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "****@*@*/@*@O*@OO/O***O*** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "e5",
    "e4",
    "c5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O     O-f4- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "**O***O*/@O*@OO@*/**@*@*** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "a7",
    "d7",
    "a1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4     @-f4- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@*@***/@O*@OO@*/**O***O* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "c5",
    "d5",
    "c3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @-b4- O     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "**O***O*/@*@OO@*O/****@*@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "g7",
    "d7",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O-b4- @    e4- @- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****@*@*/@*@OO@*O/**O***O* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "e5",
    "d5",
    "e3",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O     O-f4- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O***O*/O@*O@*@O/@*@***** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "a1",
    "d1",
    "a7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- @-c4     @-f4- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*@*****/O@*O@*@O/**O***O* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "c3",
    "d3",
    "c5",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @-b4- O     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O***O*/OO@*@O*@/@*****@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "g1",
    "d1",
    "g7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O-b4- @    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*****@*/OO@*@O*@/**O***O* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "e3",
    "d3",
    "e5",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O     @- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "**@*@*O*/@*O@O*@O/****O*** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "e3",
    "a4",
    "d5",
    "a7",
    "d7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "****O***/@*O@O*@O/**@*@*O* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "g1",
    "c4",
    "d7",
    "c5",
    "d5",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @- O     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*@***O*/O@O*@O@*/O******* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "e5",
    "a4",
    "d3",
    "a1",
    "d1",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     O- @-c4    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*******/O@O*@O@*/@*@***O* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "g7",
    "c4",
    "d1",
    "c3",
    "d3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @     O- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "**O*@*@*/@O@*O@O*/****O*** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "c3",
    "g4",
    "d5",
    "g7",
    "d7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4    e4- @- O
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "****O***/@O@*O@O*/**O*@*@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "a1",
    "e4",
    "d7",
    "e5",
    "d5",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O- @     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*O***@*/O*@O@*O@/O******* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "c5",
    "g4",
    "d3",
    "g1",
    "d1",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*******/O*@O@*O@/@*O***@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "a7",
    "e4",
    "d1",
    "e3",
    "d3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     O- O- @    e4- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O***@*@*/@O@*O@O*/******O* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "c3",
    "d7",
    "e4",
    "g7",
    "g4",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O- O    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "******O*/@O@*O@O*/O***@*@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "a1",
    "d5",
    "g4",
    "e5",
    "e4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @-c4     @- O- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*@*@***/@*O@O*@O/**O***** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "e3",
    "d7",
    "c4",
    "a7",
    "a4",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4     O- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "**O*****/@*O@O*@O/O*@*@*** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "g1",
    "d5",
    "a4",
    "c5",
    "c4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- O- @    e4- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@***O*@*/O*@O@*O@/******O* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "c5",
    "d1",
    "e4",
    "g1",
    "g4",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O- O    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "******O*/O*@O@*O@/@***O*@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "a7",
    "d3",
    "g4",
    "e3",
    "e4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @-c4     @- O- O
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*@*O***/O@O*@O@*/**O***** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "e5",
    "d1",
    "c4",
    "a1",
    "a4",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4     O- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "**O*****/O@O*@O@*/@*@*O*** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "g7",
    "d3",
    "a4",
    "c3",
    "c4",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O-c4    e4- @-g4
    |  |   O-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O****O**/@O@@OOO@/@******* b p p 6 3 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "g1",
    "d3",
    "a4",
    "c4",
    "e4",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
     O ----- d1 ----- g1
  */
  "@*******/@O@@OOO@/O****O** b p p 6 3 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "e3",
    "d1",
    "c4",
    "a4",
    "g4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |   O-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "****O**O/O@@O@@OO/****@*** b p p 6 3 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "g7",
    "d5",
    "a4",
    "c4",
    "e4",
  ],

  /*
     O ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "****@***/O@@O@@OO/****O**O b p p 6 3 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "e5",
    "d7",
    "c4",
    "a4",
    "g4",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3- O  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O**O****/@@OOO@@O/@******* b p p 6 3 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "a1",
    "d3",
    "g4",
    "e4",
    "c4",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 -----  O
  */
  "@*******/@@OOO@@O/O**O**** b p p 6 3 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "c3",
    "d1",
    "e4",
    "g4",
    "a4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5- O  |  |
    a4- @-c4    e4- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "*O**O***/OOO@@O@@/****@*** b p p 6 3 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "a7",
    "d5",
    "g4",
    "e4",
    "c4",
  ],

  /*
    a7 ----- d7 -----  O
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "****@***/OOO@@O@@/*O**O*** b p p 6 3 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "c5",
    "d7",
    "e4",
    "g4",
    "a4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |   O-d5-e5  |  |
    a4- O-c4     O- @- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O****O/O@@O@@OO/**@***** b p p 6 3 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "a1",
    "c4",
    "d7",
    "d5",
    "d3",
  ],

  /*
     O ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     @- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@*****/O@@O@@OO/**O****O b p p 6 3 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "c3",
    "a4",
    "d5",
    "d7",
    "d1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5- O  |  |
     @- @- O    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*O****O*/OOO@@O@@/******@* b p p 6 3 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "g1",
    "e4",
    "d7",
    "d5",
    "d3",
  ],

  /*
    a7 ----- d7 -----  O
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @- @    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******@*/OOO@@O@@/*O****O* b p p 6 3 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "e3",
    "g4",
    "d5",
    "d7",
    "d1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     O- @- @
    |  |   O-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O**O**/@O@@OOO@/**@***** b p p 6 3 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "a7",
    "c4",
    "d1",
    "d3",
    "d5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     @- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
     O ----- d1 ----- g1
  */
  "**@*****/@O@@OOO@/**O**O** b p p 6 3 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "c5",
    "a4",
    "d3",
    "d1",
    "d7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- @- O    e4- O-g4
    |  |  c3-d3- O  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "***O**O*/@@OOO@@O/******@* b p p 6 3 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "g7",
    "e4",
    "d1",
    "d3",
    "d5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @- @    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 -----  O
  */
  "******@*/@@OOO@@O/***O**O* b p p 6 3 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "e5",
    "g4",
    "d3",
    "d1",
    "d7",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |   O- O- @  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "***@OO**/O@@O@@OO/****@*** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e4",
    "g4",
    "c5",
    "d5",
    "d7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
     O -----  O -----  @
  */
  "****@***/O@@O@@OO/***@OO** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g4",
    "e4",
    "a7",
    "d7",
    "d5",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |   O- O- @  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O@*****O/@O@@OOO@/@******* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e4",
    "g4",
    "c3",
    "d3",
    "d1",
  ],

  /*
     O -----  O -----  @
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*******/@O@@OOO@/O@*****O w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g4",
    "e4",
    "a1",
    "d1",
    "d3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |   @- O- O  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "***OO@**/OOO@@O@@/****@*** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c4",
    "a4",
    "e5",
    "d5",
    "d7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
     @ -----  O -----  O
  */
  "****@***/OOO@@O@@/***OO@** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a4",
    "c4",
    "g7",
    "d7",
    "d5",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |   @- O- O  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "OO*****@/@@OOO@@O/@******* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c4",
    "a4",
    "e3",
    "d3",
    "d1",
  ],

  /*
     @ -----  O -----  O
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*******/@@OOO@@O/OO*****@ w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a4",
    "c4",
    "g1",
    "d1",
    "d3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |   O-d5-e5  |  |
     @- @- O    e4- O-g4
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*****@OO/OOO@@O@@/******@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "d3",
    "d1",
    "e5",
    "e4",
    "g4",
  ],

  /*
     O ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @- @    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "******@*/OOO@@O@@/*****@OO w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "d1",
    "d3",
    "g7",
    "g4",
    "e4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5- O  |  |
    a4- O-c4     O- @- @
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*OO@****/O@@O@@OO/**@***** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "d3",
    "d1",
    "c5",
    "c4",
    "a4",
  ],

  /*
    a7 ----- d7 -----  O
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     @- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "**@*****/O@@O@@OO/*OO@**** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "d1",
    "d3",
    "a7",
    "a4",
    "c4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
     @- @- O    e4- O-g4
    |  |   O-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*****OO@/@@OOO@@O/******@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "d5",
    "d7",
    "e3",
    "e4",
    "g4",
  ],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @- @    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
     O ----- d1 ----- g1
  */
  "******@*/@@OOO@@O/*****OO@ w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "d7",
    "d5",
    "g1",
    "g4",
    "e4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
    a4- O-c4     O- @- @
    |  |  c3-d3- O  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*@OO****/@O@@OOO@/**@***** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "d5",
    "d7",
    "c3",
    "c4",
    "a4",
  ],

  /*
    a7 ----- d7 -----  @
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     @- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 -----  O
  */
  "**@*****/@O@@OOO@/*@OO**** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "d7",
    "d5",
    "a1",
    "a4",
    "c4",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ -- d6 --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*******/*O@*@OO@/O******* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "d1",
    "d3",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ -- d6 --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*******/*O@*@OO@/@******* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "d3",
    "d1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ -- d2 --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "****@***/@*@O*@OO/****O*** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "d7",
    "d5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ -- d2 --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "****O***/@*@O*@OO/****@*** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "d5",
    "d7",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O -- d6 --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*******/*@OO@*@O/O******* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "d1",
    "d3",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O -- d6 --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*******/*@OO@*@O/@******* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "d3",
    "d1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O -- d2 --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "****@***/@OO@*O@*/****O*** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "d7",
    "d5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O -- d2 --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "****O***/@OO@*O@*/****@*** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "d5",
    "d7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4     @-f4- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@*****/O@*O@*@O/**O***** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "a4",
    "c4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4     O-f4- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*****/O@*O@*@O/**@***** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "c4",
    "a4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O-b4- @    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******@*/OO@*@O*@/******O* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "g4",
    "e4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @-b4- O    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******O*/OO@*@O*@/******@* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "e4",
    "g4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4     @-f4- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@*****/@O*@OO@*/**O***** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "a4",
    "c4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4     O-f4- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*****/@O*@OO@*/**@***** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "c4",
    "a4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O-b4- @    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******@*/@*@OO@*O/******O* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "g4",
    "e4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @-b4- O    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******O*/@*@OO@*O/******@* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "e4",
    "g4",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |   O- @-e5  |  |
    a4- O- O    e4- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "@***O*OO/O@@O@@OO/****@*** b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g1",
    "a4",
    "e4",
  ],

  /*
     O -----  @ ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- O-c4    e4- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "****@***/O@@O@@OO/@***O*OO b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e3",
    "c4",
    "g4",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O- O    e4- @-g4
    |  |   O- @-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O***@OO*/@O@@OOO@/@******* b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g7",
    "a4",
    "e4",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
     O -----  @ ----- g1
  */
  "@*******/@O@@OOO@/O***@OO* b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e5",
    "c4",
    "g4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5- @- O  |  |
    a4- @-c4     O- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "@OO*O***/OOO@@O@@/****@*** b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a1",
    "g4",
    "c4",
  ],

  /*
    a7 -----  @ -----  O
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "****@***/OOO@@O@@/@OO*O*** b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c3",
    "e4",
    "a4",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @-c4     O- O-g4
    |  |  c3- @- O  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*OO@***/@@OOO@@O/@******* b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a7",
    "g4",
    "c4",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @-c4    e4- O- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 -----  @ -----  O
  */
  "@*******/@@OOO@@O/O*OO@*** b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c5",
    "e4",
    "a4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5- O- O  |  |
     @- @- O     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "OO@***O*/OOO@@O@@/******@* b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a1",
    "d7",
    "d3",
  ],

  /*
    a7 -----  O -----  O
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @- @    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******@*/OOO@@O@@/OO@***O* b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c3",
    "d5",
    "d1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |   O- O-e5  |  |
    a4- O- @     O- @- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*O***@O/O@@O@@OO/**@***** b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g1",
    "d7",
    "d3",
  ],

  /*
     O -----  O ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4     @- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@*****/O@@O@@OO/O*O***@O b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e3",
    "d5",
    "d1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- @- O     @- O-g4
    |  |  c3- O- O  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@OO*O*/@@OOO@@O/******@* b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a7",
    "d1",
    "d5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @- @    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 -----  O -----  O
  */
  "******@*/@@OOO@@O/**@OO*O* b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c5",
    "d3",
    "d7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @     O- @- @
    |  |   O- O-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*OO@*/@O@@OOO@/**@***** b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g7",
    "d1",
    "d5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4     @- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
     O -----  O ----- g1
  */
  "**@*****/@O@@OOO@/**O*OO@* b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e5",
    "d3",
    "d7",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
     O ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O- @     @- O- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O*@*@*@*/@*O@O@OO/**O*@**O w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "c5",
    "e5",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |   O-d5-e5  |  |
     @- O-c4     O- O- @
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "**O*@**O/@*O@O@OO/O*@*@*@* w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "a7",
    "g7",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O- @     @- O- O
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
     O ----- d1 ----- g1
  */
  "@*@*O*@*/O@O*@OO@/@*O**O** w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "c3",
    "e3",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     @- O-c4     O- O- @
    |  |   O-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@*O**O**/O@O*@OO@/@*@*O*@* w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "a1",
    "g1",
  ],

  /*
    a7 ----- d7 -----  O
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     O- O- @     @- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O*@*@*@*/@OO@O@O*/*O**@*O* w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "e5",
    "c5",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5- O  |  |
     @- O- O    e4- O- @
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "*O**@*O*/@OO@O@O*/O*@*@*@* w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "g7",
    "a7",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- O- @     @- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 -----  O
  */
  "@*@*O*@*/O@OO@*O@/@**O**O* w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "e3",
    "c3",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     @- O- O    e4- O- @
    |  |  c3-d3- O  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@**O**O*/O@OO@*O@/@*@*O*@* w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "g1",
    "a1",
  ],

  /*
    a7 ----- d7 -----  O
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     @- O- @     O- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@*O*@*@*/OO@*O@O@/*O**O*@* w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "e5",
    "e3",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5- O  |  |
     @- O- @    e4- @- O
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "*O**O*@*/OO@*O@O@/@*O*@*@* w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "g7",
    "g1",
  ],

  /*
     O ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @- O     @- O- @
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@*@*@*O*/O@O@O*@O/**@*O**O w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "c5",
    "c3",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |   O-d5-e5  |  |
     O- @-c4     @- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "**@*O**O/O@O@O*@O/@*@*@*O* w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "a7",
    "a1",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     @- O- @     O- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 -----  O
  */
  "@*O*@*@*/O*@OO@O@/O**O**@* w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "e3",
    "e5",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O- @    e4- @- O
    |  |  c3-d3- O  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O**O**@*/O*@OO@O@/@*O*@*@* w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "g1",
    "g7",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @- O     @- O- @
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
     O ----- d1 ----- g1
  */
  "@*@*@*O*/O@O@OO@*/O*@**O** w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "c3",
    "c5",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     O- @-c4     @- O- @
    |  |   O-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O*@**O**/O@O@OO@*/@*@*@*O* w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "a1",
    "a7",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
     @- O-c4     @- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "*@@*O***/@OO*@OO@/O*@*O*@* w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "e3",
    "c5",
    "d5",
  ],

  /*
    a7 ----- d7 -----  @
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O- @     @- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "O*@*O*@*/@OO*@OO@/*@@*O*** w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "g1",
    "a7",
    "d7",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O-c4     @- O- @
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "O*@@****/@*OO@@OO/O*@*O*@* w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "e5",
    "c3",
    "d3",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O- @     @- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "O*@*O*@*/@*OO@@OO/O*@@**** w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "g7",
    "a1",
    "d1",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
     @- O- @    e4- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "****O*@@/@@OO@*OO/O*@*O*@* w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "c3",
    "e5",
    "d5",
  ],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O- @     @- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "O*@*O*@*/@@OO@*OO/****O*@@ w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "a1",
    "g7",
    "d7",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O- @    e4- O- @
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "O****@@*/@OO@@OO*/O*@*O*@* w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "c5",
    "e3",
    "d3",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O- @     @- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "O*@*O*@*/@OO@@OO*/O****@@* w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "a7",
    "g1",
    "d1",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @- O    e4- @- O
    |  |  c3- @- @  |  |
    |  |      |     |  |
    |  b2 --  O --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "***@@*O*/O@@OO*@O/@*O*@*O* w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "c3",
    "e5",
    "e4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- @- O     O- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  O  |
    |         |        |
    a1 -----  @ -----  @
  */
  "@*O*@*O*/O@@OO*@O/***@@*O* w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "a1",
    "g7",
    "g4",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4     O- @- O
    |  |   @- @-e3  |  |
    |  |      |     |  |
    |   O --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "**O*@@**/OO@*OO@@/@*O*@*O* w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "e3",
    "c5",
    "c4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @- O     O- @- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  O -- f2  |
    |         |        |
     @ -----  @ ----- g1
  */
  "@*O*@*O*/OO@*OO@@/**O*@@** w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "g1",
    "a7",
    "a4",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O --  O  |
    |  |      |     |  |
    |  |  c5- @- @  |  |
     O- @- O    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "@@****O*/OO@@OO@*/@*O*@*O* w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "c5",
    "e3",
    "e4",
  ],

  /*
    a7 -----  @ -----  @
    |         |        |
    |  b6 --  O --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- @- O     O- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*O*@*O*/OO@@OO@*/@@****O* w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "a7",
    "g1",
    "g4",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  O -- f6  |
    |  |      |     |  |
    |  |   @- @-e5  |  |
     O- @-c4     O- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "@*O****@/O*@OO@@O/@*O*@*O* w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "e5",
    "c3",
    "c4",
  ],

  /*
     @ -----  @ ----- g7
    |         |        |
    |   O --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @- O     O- @- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*O*@*O*/O*@OO@@O/@*O****@ w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "g7",
    "a1",
    "a4",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @- O    e4- O- @
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****@*O*/O@O@O*@O/@*@***O* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g1",
    "e3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- @- O     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "@*@***O*/O@O@O*@O/****@*O* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e3",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- @- O    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "@*****O*/O@O@OO@*/**@*@*O* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g7",
    "e5",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @- O     @- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@*@*O*/O@O@OO@*/@*****O* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e5",
    "g7",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4     O- @- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*@***/OO@*O@O@/@*O***@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a1",
    "c3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O- @     O- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "@*O***@*/OO@*O@O@/**O*@*** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c3",
    "a1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     @- O-c4     O- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "@*O*****/O*@OO@O@/**O*@*@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a7",
    "c5",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @     O- @- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*@*@*/O*@OO@O@/@*O***** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c5",
    "a7",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O- @    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O*****@*/@OO@O@O*/O*@*@*** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a1",
    "c3",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O-c4     @- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*@*@***/@OO@O@O*/O*****@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c3",
    "a1",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O-c4     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O*@*****/@*O@O@OO/O***@*@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g1",
    "e3",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O- @    e4- O- @
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O***@*@*/@*O@O@OO/O*@***** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e3",
    "g1",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @    e4- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "****O*@*/O@OO@*O@/@*@*O*** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a7",
    "c5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     @- O-c4     @- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@*@*O***/O@OO@*O@/****O*@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c5",
    "a7",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4     @- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "**@*O***/O@O*@OO@/@***O*@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g7",
    "e5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O- @    e4- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@***O*@*/O@O*@OO@/**@*O*** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e5",
    "g7",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @- O    e4- O-g4
    |  |   @- O- O  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "@**OO@O*/OOO@@O@@/****@*** w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "g1",
    "g4",
    "a7",
    "g7",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
     @ -----  O -----  O
  */
  "****@***/OOO@@O@@/@**OO@O* w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "e3",
    "e4",
    "c5",
    "e5",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |   @- O- O  |  |
    a4- @- O    e4- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "OO**@*O@/@@OOO@@O/@******* w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "g7",
    "g4",
    "a1",
    "g1",
  ],

  /*
     @ -----  O -----  O
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "@*******/@@OOO@@O/OO**@*O@ w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "e5",
    "e4",
    "c3",
    "e3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O-c4     O- @-g4
    |  |   O- O- @  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "@*O@OO**/O@@O@@OO/****@*** w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "a1",
    "a4",
    "g7",
    "a7",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
     O -----  O -----  @
  */
  "****@***/O@@O@@OO/@*O@OO** w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "c3",
    "c4",
    "e5",
    "c5",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |   O- O- @  |  |
    a4- O-c4     O- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O@O*@**O/@O@@OOO@/@******* w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "a7",
    "a4",
    "g1",
    "a1",
  ],

  /*
     O -----  O -----  @
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "@*******/@O@@OOO@/O@O*@**O w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "c5",
    "c4",
    "e3",
    "c3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |   @- O-e5  |  |
     @- @- O     @- O-g4
    |  |   O-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*@**OO@/@@OOO@@O/******@* w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "a1",
    "d1",
    "g7",
    "g1",
  ],

  /*
     @ -----  O ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @- @    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
     O ----- d1 ----- g1
  */
  "******@*/@@OOO@@O/O*@**OO@ w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "c3",
    "d3",
    "e5",
    "e3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O- @  |  |
    a4- O- @     O- @- @
    |  |  c3-d3- O  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O@OO**@*/@O@@OOO@/**@***** w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "g1",
    "d1",
    "a7",
    "a1",
  ],

  /*
    a7 -----  O -----  @
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4     @- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 -----  O
  */
  "**@*****/@O@@OOO@/O@OO**@* w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "e3",
    "d3",
    "c5",
    "c3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |   O-d5-e5  |  |
     @- @- O     @- O-g4
    |  |   @- O-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@*O@OO/OOO@@O@@/******@* w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "a7",
    "d7",
    "g1",
    "g7",
  ],

  /*
     O ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @- @    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
     @ -----  O ----- g1
  */
  "******@*/OOO@@O@@/**@*O@OO w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "c5",
    "d5",
    "e3",
    "e5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5- O  |  |
    a4- O- @     O- @- @
    |  |  c3- O- @  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*OO@O*@*/O@@O@@OO/**@***** w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "g7",
    "d7",
    "a1",
    "a7",
  ],

  /*
    a7 ----- d7 -----  O
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4     @- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 -----  O -----  @
  */
  "**@*****/O@@O@@OO/*OO@O*@* w p p 7 2 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "e5",
    "d5",
    "c3",
    "c5",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 -----  @ -----  O
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O- @     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  @ -----  O
  */
  "O*O***@*/OO@@O*O@/@O*O@*@* b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>["b2"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5- @- O  |  |
     @- O- @    e4- @- O
    |  |  c3- @- O  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@O*O@*@*/OO@@O*O@/O*O***@* b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>["b2"],

  /*
    a7 -----  @ -----  O
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O- @     O- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 -----  @ -----  O
  */
  "**O*O*@*/O@@OO@O*/@O*O@*@* b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>["b6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- @- O  |  |
     @- O- @    e4- @- O
    |  |  c3- @- O  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@O*O@*@*/O@@OO@O*/**O*O*@* b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>["b6"],

  /*
     O -----  @ ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @- O     @- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
     O -----  @ ----- g1
  */
  "O*@***O*/O@O*O@@O/@*@*@O*O b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>["f2"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |   O- @-e5  |  |
     O- @-c4     @- O- @
    |  |   O- @-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*@*@O*O/O@O*O@@O/O*@***O* b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>["f2"],

  /*
     O -----  @ ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O     @- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
     O -----  @ ----- g1
  */
  "**@*O*O*/O*O@OO@@/@*@*@O*O b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>["f6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |   O- @-e5  |  |
     O- @-c4     @- O- @
    |  |   O- @-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@*@*@O*O/O*O@OO@@/**@*O*O* b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>["f6"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     @- O-c4     O- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
     O ----- d1 -----  O
  */
  "@*O*O***/O@OO@@O*/@*@O*O@* b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>["b6"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O- @     @- O- O
    |  |   O-d3- O  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@*@O*O@*/O@OO@@O*/@*O*O*** b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>["b6"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     @- O- O    e4- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
     O ----- d1 -----  O
  */
  "@***O*O*/O*O@@OO@/@*@O*O@* b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>["f6"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- O- @     @- O-g4
    |  |   O-d3- O  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@*@O*O@*/O*O@@OO@/@***O*O* b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>["f6"],

  /*
     O ----- d7 -----  O
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O-c4     O- O- @
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O*O*@***/@OO@O*O@/*O@*@*@O b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>["b2"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |   O-d5- O  |  |
    a4- O- @     @- O- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "*O@*@*@O/@OO@O*O@/O*O*@*** b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>["b2"],

  /*
     O ----- d7 -----  O
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O- O    e4- O- @
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O***@*O*/@@O*O@OO/*O@*@*@O b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>["f2"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |   O-d5- O  |  |
     O- O- @     @- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "*O@*@*@O/@@O*O@OO/O***@*O* b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>["f2"],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O -- d2 --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@OO@*O@*/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "d1",
    "d3",
    "d5",
    "d7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O -- d6 --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/*@OO@*@O/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "d7",
    "d5",
    "d3",
    "d1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ -- d2 --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*@O*@OO/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "d1",
    "d3",
    "d5",
    "d7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ -- d6 --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/*O@*@OO@/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "d7",
    "d5",
    "d3",
    "d1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*@OO@*O/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "a4",
    "c4",
    "e4",
    "g4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@O*@OO@*/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "g4",
    "e4",
    "c4",
    "a4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OO@*@O*@/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "a4",
    "c4",
    "e4",
    "g4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O@*O@*@O/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "g4",
    "e4",
    "c4",
    "a4",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*O**O@*/******** w p p 2 7 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "d1",
    "d3",
    "a4",
    "c4",
    "c5",
    "d5",
    "e5",
    "f6",
    "a7",
    "d7",
    "g7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/**O*@*@O/******** w p p 2 7 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "d7",
    "d5",
    "a4",
    "c4",
    "c3",
    "d3",
    "e3",
    "f2",
    "a1",
    "d1",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*@O**O*/******** w p p 2 7 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "d1",
    "d3",
    "g4",
    "e4",
    "e5",
    "d5",
    "c5",
    "b6",
    "g7",
    "d7",
    "a7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/*O@*@*O*/******** w p p 2 7 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "d7",
    "d5",
    "g4",
    "e4",
    "e3",
    "d3",
    "c3",
    "b2",
    "g1",
    "d1",
    "a1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*@*O**O/******** w p p 2 7 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "a4",
    "c4",
    "d7",
    "d5",
    "e5",
    "e4",
    "e3",
    "f2",
    "g7",
    "g4",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@O**O*@*/******** w p p 2 7 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "g4",
    "e4",
    "d7",
    "d5",
    "c5",
    "c4",
    "c3",
    "b2",
    "a7",
    "a4",
    "a1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*@*@O**/******** w p p 2 7 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "a4",
    "c4",
    "d1",
    "d3",
    "e3",
    "e4",
    "e5",
    "f6",
    "g1",
    "g4",
    "g7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O**O@*@*/******** w p p 2 7 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "g4",
    "e4",
    "d1",
    "d3",
    "c3",
    "c4",
    "c5",
    "b6",
    "a1",
    "a4",
    "a7",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5- O  |  |
    a4- @-c4    e4- O- @
    |  |  c3- @- O  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*O*O@***/@@OOO@@O/**@***** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a1",
    "a4",
    "a7",
    "d7",
  ],

  /*
    a7 ----- d7 -----  O
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 -----  @ -----  O
  */
  "**@*****/@@OOO@@O/*O*O@*** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c3",
    "c4",
    "c5",
    "d5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5- @- O  |  |
    a4- @-c4    e4- O- @
    |  |  c3-d3- O  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@O*O****/OOO@@O@@/**@***** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a7",
    "a4",
    "a1",
    "d1",
  ],

  /*
    a7 -----  @ -----  O
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 -----  O
  */
  "**@*****/OOO@@O@@/@O*O**** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c5",
    "c4",
    "c3",
    "d3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |   O-d5-e5  |  |
     @- O-c4    e4- @-g4
    |  |   O- @-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****@O*O/@O@@OOO@/******@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g1",
    "g4",
    "g7",
    "d7",
  ],

  /*
     O ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
     O -----  @ ----- g1
  */
  "******@*/@O@@OOO@/****@O*O w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e3",
    "e4",
    "e5",
    "d5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |   O- @-e5  |  |
     @- O-c4    e4- @-g4
    |  |   O-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@****O*O/O@@O@@OO/******@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g7",
    "g4",
    "g1",
    "d1",
  ],

  /*
     O -----  @ ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
     O ----- d1 ----- g1
  */
  "******@*/O@@O@@OO/@****O*O w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e5",
    "e4",
    "e3",
    "d3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @    e4- @-g4
    |  |   O-d3- O  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "***O*O@*/@O@@OOO@/****@*** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a7",
    "d7",
    "g7",
    "g4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4    e4- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
     O ----- d1 -----  O
  */
  "****@***/@O@@OOO@/***O*O@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c5",
    "d5",
    "e5",
    "e4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4     @- O-g4
    |  |   O-d3- O  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "**@O*O**/@@OOO@@O/****@*** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g7",
    "d7",
    "a7",
    "a4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O- @
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
     O ----- d1 -----  O
  */
  "****@***/@@OOO@@O/**@O*O** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e5",
    "d5",
    "c5",
    "c4",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |   O-d5- O  |  |
    a4- O- @    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*O****@O/O@@O@@OO/@******* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a1",
    "d1",
    "g1",
    "g4",
  ],

  /*
     O ----- d7 -----  O
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     @- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*******/O@@O@@OO/*O****@O w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c3",
    "d3",
    "e3",
    "e4",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |   O-d5- O  |  |
    a4- @-c4     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*O@****O/OOO@@O@@/@******* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g1",
    "d1",
    "a1",
    "a4",
  ],

  /*
     O ----- d7 -----  O
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @-c4    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*******/OOO@@O@@/*O@****O w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e3",
    "d3",
    "c3",
    "c4",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |   O-d5-e5  |  |
    a4- @- O     @- O- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@*@*OO/@*O@O*@O/@*O***** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>["d5"],

  /*
     O ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- @-c4     O- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "@*O*****/@*O@O*@O/**@*@*OO w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>["d7"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @- O     @- O- O
    |  |   O-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "@*@**OO*/O@O*@O@*/**O*@*** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>["d3"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4     O- O- @
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
     O ----- d1 ----- g1
  */
  "**O*@***/O@O*@O@*/@*@**OO* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>["d1"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5- O  |  |
     O- O- @     O- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*OO*@*@*/@O@*O@O*/@*****O* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>["d5"],

  /*
    a7 ----- d7 -----  O
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     @- O- O    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "@*****O*/@O@*O@O*/*OO*@*@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>["d7"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- O- @     O- @-g4
    |  |  c3-d3- O  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "@*OO**@*/O*@O@*O@/****@*O* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>["d3"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O- O    e4- @- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 -----  O
  */
  "****@*O*/O*@O@*O@/@*OO**@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>["d1"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O- O  |  |
    a4- O- @    e4- @- @
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "OO**@*@*/@O@*O@O*/**@*O*** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>["e4"],

  /*
    a7 -----  O -----  O
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4     @- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "**@*O***/@O@*O@O*/OO**@*@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>["g4"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |   O- O-e5  |  |
     @- @-c4     @- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "O*@*@**O/@*O@O*@O/****O*@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>["c4"],

  /*
     O -----  O ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- @    e4- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "****O*@*/@*O@O*@O/O*@*@**O w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>["a4"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O- @    e4- @- @
    |  |  c3- O- O  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@**OO*@*/O*@O@*O@/O*@***** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>["e4"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O-c4     @- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 -----  O -----  O
  */
  "O*@*****/O*@O@*O@/@**OO*@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>["g4"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     @- @-c4     @- O-g4
    |  |   O- O-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*@*OO**/O@O*@O@*/O*****@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>["c4"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @- @    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
     O -----  O ----- g1
  */
  "O*****@*/O@O*@O@*/@*@*OO** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>["a4"],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @- O     O- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*O*@*O*/O*@*O*@*/******** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "a1",
    "g1",
    "b2",
    "f2",
    "a4",
    "g4",
    "b6",
    "f6",
    "a7",
    "g7",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "********/O*@*O*@*/@*O*@*O* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "c3",
    "e3",
    "b2",
    "f2",
    "c4",
    "e4",
    "b6",
    "f6",
    "c5",
    "e5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O- @     @- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*@*O*@*/@*O*@*O*/******** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "a7",
    "a1",
    "b6",
    "b2",
    "d7",
    "d1",
    "f6",
    "f2",
    "g7",
    "g1",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "********/@*O*@*O*/O*@*O*@* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "c5",
    "c3",
    "b6",
    "b2",
    "d5",
    "d3",
    "f6",
    "f2",
    "e5",
    "e3",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ -- d6 --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "******@*/*O@*@OO@/****O*** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "c3",
    "d7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ -- d6 --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4    e4- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****O***/*O@*@OO@/******@* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "a1",
    "d5",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ -- d2 --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******@*/@*@O*@OO/O******* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "c5",
    "d1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ -- d2 --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*******/@*@O*@OO/******@* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "a7",
    "d3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O -- d6 --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "**@*****/*@OO@*@O/****O*** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "e3",
    "d7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O -- d6 --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****O***/*@OO@*@O/**@***** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "g1",
    "d5",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O -- d2 --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@*****/@OO@*O@*/O******* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "e5",
    "d1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @-c4    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O -- d2 --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*******/@OO@*O@*/**@***** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "g7",
    "d3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- @-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*******/O@*O@*@O/******O* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "c5",
    "g4",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******O*/O@*O@*@O/@******* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "a7",
    "e4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4-b4-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*******/OO@*@O*@/**O***** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "e5",
    "a4",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*****/OO@*@O*@/@******* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "g7",
    "c4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4-f4-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****@***/@O*@OO@*/******O* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "c3",
    "g4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "******O*/@O*@OO@*/****@*** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "a1",
    "e4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- @- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****@***/@*@OO@*O/**O***** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "e3",
    "a4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "**O*****/@*@OO@*O/****@*** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "g1",
    "c4",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O -- d6 --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @-c4    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@*******/*@OO@*@O/O*@*O*** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["c3"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O -- d6 --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @-c4     @- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*@*O***/*@OO@*@O/@******* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["a1"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O- @
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O -- d2 --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "****@***/@OO@*O@*/O*@*O*** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["c5"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @-c4     @- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O -- d2 --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O*@*O***/@OO@*O@*/****@*** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["a7"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ -- d6 --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     @- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@*******/*O@*@OO@/O***O*@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["e3"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ -- d6 --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O- @    e4- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O***O*@*/*O@*@OO@/@******* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["g1"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4    e4- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ -- d2 --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "****@***/@*@O*@OO/O***O*@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["e5"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O- @    e4- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ -- d2 --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O***O*@*/@*@O*@OO/****@*** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["g7"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4     @-f4- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "**@*****/@O*@OO@*/**O*@*O* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["c5"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O     O-f4- @
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*@*O*/@O*@OO@*/**@***** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["a7"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O-b4- @    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "******@*/@*@OO@*O/**O*@*O* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["e5"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @-b4- O     O- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*@*O*/@*@OO@*O/******@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["g7"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4     @-f4- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@*****/O@*O@*@O/@*O***O* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["c3"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @- O     O-f4- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*O***O*/O@*O@*@O/**@***** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["a1"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O-b4- @    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******@*/OO@*@O*@/@*O***O* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["e3"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     @-b4- O     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*O***O*/OO@*@O*@/******@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["g1"],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 -----  @ -----  O
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O- @    e4- @- O
    |  |   O- @- O  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "***O@O@*/OO@*O@O@/@OO*@*@* w p p 8 1 8 1 0 0 0 0 0 0 0 0 9": <String>["a1"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5- @- O  |  |
     @- O- @     O- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
     O -----  @ -----  O
  */
  "@OO*@*@*/OO@*O@O@/***O@O@* w p p 8 1 8 1 0 0 0 0 0 0 0 0 9": <String>["c3"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |   O- @- O  |  |
     @- O- @    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 -----  @ -----  O
  */
  "@O****@O/O*@OO@O@/@*OO@*@* w p p 8 1 8 1 0 0 0 0 0 0 0 0 9": <String>["a7"],

  /*
     O -----  @ -----  O
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     @- O- @     O- @-g4
    |  |  c3- @- O  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*OO@*@*/O*@OO@O@/@O****@O w p p 8 1 8 1 0 0 0 0 0 0 0 0 9": <String>["c5"],

  /*
     O -----  @ ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4     @- O- @
    |  |   O- @- O  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "**@O@O**/O@O@O*@O/@*@*@*OO w p p 8 1 8 1 0 0 0 0 0 0 0 0 9": <String>["g1"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |   O- @-e5  |  |
    a4- @- O     @- O- @
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
     O -----  @ -----  O
  */
  "@*@*@*OO/O@O@O*@O/**@O@O** w p p 8 1 8 1 0 0 0 0 0 0 0 0 9": <String>["e3"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |   O- @- O  |  |
     O- @-c4     @- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
     O -----  @ ----- g1
  */
  "@O@****O/O@O@OO@*/@*@*@OO* w p p 8 1 8 1 0 0 0 0 0 0 0 0 9": <String>["g7"],

  /*
     O -----  @ -----  O
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @- O     @- O- @
    |  |   O- @-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*@*@OO*/O@O@OO@*/@O@****O w p p 8 1 8 1 0 0 0 0 0 0 0 0 9": <String>["e5"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |   O- @-e5  |  |
     @- O- @    e4- O- @
    |  |   O-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 -----  O -----  O
  */
  "@****O@O/O@OO@*O@/@*@OO*@* w p p 8 1 8 1 0 0 0 0 0 0 0 0 9": <String>["a7"],

  /*
     O -----  @ ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     @- O- @     @- O-g4
    |  |  c3- O- O  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
     O ----- d1 ----- g1
  */
  "@*@OO*@*/O@OO@*O@/@****O@O w p p 8 1 8 1 0 0 0 0 0 0 0 0 9": <String>["c5"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5- @- O  |  |
     @- O-c4     @- O- @
    |  |  c3-d3- O  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
     O -----  O ----- g1
  */
  "@O@O****/O@O*@OO@/@*@*OO@* w p p 8 1 8 1 0 0 0 0 0 0 0 0 9": <String>["g7"],

  /*
    a7 -----  @ -----  O
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O- @     @- O- @
    |  |   O- O-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 -----  O
  */
  "@*@*OO@*/O@O*@OO@/@O@O**** w p p 8 1 8 1 0 0 0 0 0 0 0 0 9": <String>["e5"],

  /*
    a7 -----  O -----  O
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |   O-d5-e5  |  |
     @- O- @    e4- O- @
    |  |   O- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "****@O@O/@OO@O@O*/OO@*@*@* w p p 8 1 8 1 0 0 0 0 0 0 0 0 9": <String>["a1"],

  /*
     O ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O- O  |  |
     @- O- @     @- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
     O -----  @ ----- g1
  */
  "OO@*@*@*/@OO@O@O*/****@O@O w p p 8 1 8 1 0 0 0 0 0 0 0 0 9": <String>["c3"],

  /*
     O -----  O ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5- O  |  |
     @- O-c4     @- O- @
    |  |  c3- @- O  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "*O@O@***/@*O@O@OO/O*@*@*@O w p p 8 1 8 1 0 0 0 0 0 0 0 0 9": <String>["g1"],

  /*
    a7 ----- d7 -----  O
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |   O- O-e5  |  |
    a4- O- @     @- O- @
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 -----  @ -----  O
  */
  "O*@*@*@O/@*O@O@OO/*O@O@*** w p p 8 1 8 1 0 0 0 0 0 0 0 0 9": <String>["e3"],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O    e4- O-g4
    |  |   @-d3- @  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "***@*@O*/@@OOOO@O/******** w p p 6 3 5 3 0 0 0 0 0 0 0 0 8": <String>["d7"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
     @ ----- d1 -----  @
  */
  "********/@@OOOO@O/***@*@O* w p p 6 3 5 3 0 0 0 0 0 0 0 0 8": <String>["d5"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |   @-d5- @  |  |
    a4- @- O    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*@****O@/OOO@@O@O/******** w p p 6 3 5 3 0 0 0 0 0 0 0 0 8": <String>["d1"],

  /*
     @ ----- d7 -----  @
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OOO@@O@O/*@****O@ w p p 6 3 5 3 0 0 0 0 0 0 0 0 8": <String>["d3"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     O- @-g4
    |  |   @-d3- @  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O@*@**/@O@OOOO@/******** w p p 6 3 5 3 0 0 0 0 0 0 0 0 8": <String>["d7"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  O  |
    |         |        |
     @ ----- d1 -----  @
  */
  "********/@O@OOOO@/**O@*@** w p p 6 3 5 3 0 0 0 0 0 0 0 0 8": <String>["d5"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |   @-d5- @  |  |
    a4- O-c4     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*@O****@/OO@O@@OO/******** w p p 6 3 5 3 0 0 0 0 0 0 0 0 8": <String>["d1"],

  /*
     @ ----- d7 -----  @
    |         |        |
    |   O --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OO@O@@OO/*@O****@ w p p 6 3 5 3 0 0 0 0 0 0 0 0 8": <String>["d3"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |   @- O-e5  |  |
    a4- O-c4    e4- @-g4
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O****@*@/@O@@OOOO/******** w p p 6 3 5 3 0 0 0 0 0 0 0 0 8": <String>["g4"],

  /*
     @ -----  O ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "********/@O@@OOOO/O****@*@ w p p 6 3 5 3 0 0 0 0 0 0 0 0 8": <String>["e4"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O- @  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O@*@****/@OOOO@@O/******** w p p 6 3 5 3 0 0 0 0 0 0 0 0 8": <String>["a4"],

  /*
    a7 -----  O -----  @
    |         |        |
    |   O --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "********/@OOOO@@O/O@*@**** w p p 6 3 5 3 0 0 0 0 0 0 0 0 8": <String>["c4"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |   @- O-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****O@*@/O@@O@OOO/******** w p p 6 3 5 3 0 0 0 0 0 0 0 0 8": <String>["g4"],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
     @ -----  O ----- g1
  */
  "********/O@@O@OOO/****O@*@ w p p 6 3 5 3 0 0 0 0 0 0 0 0 8": <String>["e4"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
    a4- @-c4    e4- O-g4
    |  |  c3- O- @  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*@*@O***/OOOO@O@@/******** w p p 6 3 5 3 0 0 0 0 0 0 0 0 8": <String>["a4"],

  /*
    a7 ----- d7 -----  @
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  O  |
    |         |        |
    a1 -----  O -----  @
  */
  "********/OOOO@O@@/*@*@O*** w p p 6 3 5 3 0 0 0 0 0 0 0 0 8": <String>["c4"],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @-b4- O    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******O*/OO@*@O*@/@*O***@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "e3",
    "e5",
    "a7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O-b4- @     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*O***@*/OO@*@O*@/******O* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "g1",
    "g7",
    "c5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @-b4- O    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "******O*/@*@OO@*O/**O*@*@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "e5",
    "e3",
    "a1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O-b4- @     O- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*@*@*/@*@OO@*O/******O* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "g7",
    "g1",
    "c3",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4     O-f4- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*****/O@*O@*@O/@*@***O* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "c3",
    "c5",
    "g7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @- O     @-f4- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*@***O*/O@*O@*@O/**O***** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "a1",
    "a7",
    "e5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4     O-f4- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "**O*****/@O*@OO@*/**@*@*O* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "c5",
    "c3",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O     @-f4- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@*@*O*/@O*@OO@*/**O***** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "a7",
    "a1",
    "e3",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O -- d6 --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @-c4    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "O*******/*@OO@*@O/@*@*O*** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "c3",
    "e3",
    "g7",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O -- d6 --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @-c4     @- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*@*O***/*@OO@*@O/O******* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "a1",
    "g1",
    "e5",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ -- d6 --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "O*******/*O@*@OO@/@***O*@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "e3",
    "c3",
    "a7",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ -- d6 --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O- @    e4- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@***O*@*/*O@*@OO@/O******* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "g1",
    "a1",
    "c5",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O -- d2 --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "****O***/@OO@*O@*/O*@*@*** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "c5",
    "e5",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @-c4     @- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O -- d2 --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "O*@*@***/@OO@*O@*/****O*** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "a7",
    "g7",
    "e3",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4    e4- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ -- d2 --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "****O***/@*@O*@OO/O***@*@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "e5",
    "c5",
    "a1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O- @    e4- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ -- d2 --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "O***@*@*/@*@O*@OO/****O*** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "g7",
    "a7",
    "c3",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |   @- O- O  |  |
     @- O- @    e4- @- O
    |  |   O- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "OO**@O@@/@O@@O*O*/**O*O*@* b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "a1",
    "g1",
    "g7",
  ],

  /*
     @ -----  O -----  O
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O- @     O- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
     O -----  @ ----- g1
  */
  "**O*O*@*/@O@@O*O*/OO**@O@@ b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "c3",
    "e3",
    "e5",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |   O- @-e5  |  |
     @- O- @    e4- @- O
    |  |   @- O- O  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@**OO@@O/O@@O@*O*/O*O***@* b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "a7",
    "g7",
    "g1",
  ],

  /*
     O -----  @ ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O- @     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
     @ -----  O -----  O
  */
  "O*O***@*/O@@O@*O*/@**OO@@O b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "c5",
    "e5",
    "e3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |   O- O- @  |  |
     O- @-c4     @- O- @
    |  |  c3- @- O  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "O@@O@**O/@*O*O@@O/**@*O*O* b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "g1",
    "a1",
    "a7",
  ],

  /*
     O -----  O -----  @
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O     @- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  @ -----  O
  */
  "**@*O*O*/@*O*O@@O/O@@O@**O b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "e3",
    "c3",
    "c5",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @- O  |  |
     O- @-c4     @- O- @
    |  |   O- O- @  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@O@@OO**/O*O*@O@@/O*@***O* b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "g7",
    "a7",
    "a1",
  ],

  /*
    a7 -----  @ -----  O
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @- O     @- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
     O -----  O -----  @
  */
  "O*@***O*/O*O*@O@@/@O@@OO** b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "e5",
    "c5",
    "c3",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |   O- @- @  |  |
     O- O- @     O- @-g4
    |  |  c3-d3- O  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@@OO**@O/O*@O@@O*/@***O*O* b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "a7",
    "a1",
    "g1",
  ],

  /*
     O -----  @ -----  @
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     @- O- O    e4- @- O
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 -----  O
  */
  "@***O*O*/O*@O@@O*/@@OO**@O b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "c5",
    "c3",
    "e3",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |   @- @- O  |  |
    a4- @- O     @- O- O
    |  |   O-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@O@**OO@/O*O@@O@*/@*O*O*** b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "g7",
    "g1",
    "a1",
  ],

  /*
     @ -----  @ -----  O
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- @-c4     O- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
     O ----- d1 ----- g1
  */
  "@*O*O***/O*O@@O@*/@O@**OO@ b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "e5",
    "e3",
    "c3",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5- O  |  |
     O- O- @     O- @-g4
    |  |   O- @- @  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "*OO@@O@*/@O@*O*O@/O***@*O* b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "a1",
    "a7",
    "g7",
  ],

  /*
    a7 ----- d7 -----  O
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O- O    e4- @- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
     O -----  @ -----  @
  */
  "O***@*O*/@O@*O*O@/*OO@@O@* b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "c3",
    "c5",
    "e5",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |   O-d5-e5  |  |
    a4- @- O     @- O- O
    |  |   @- @- O  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "**@O@@OO/@@O*O*@O/O*O*@*** b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "g1",
    "g7",
    "a7",
  ],

  /*
     O ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     O- @-c4     O- O- @
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
     @ -----  @ -----  O
  */
  "O*O*@***/@@O*O*@O/**@O@@OO b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>[
    "e3",
    "e5",
    "c5",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- @-c4     O- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
     @ ----- d1 -----  O
  */
  "@*O*O***/O@O*@O@*/**@O*@O* b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "d1",
    "f2",
    "c3",
    "e3",
    "c4",
    "e5",
    "b6",
    "a7",
    "d7",
    "g7",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O     @- O- O
    |  |   @-d3- O  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "**@O*@O*/O@O*@O@*/@*O*O*** b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "d3",
    "f2",
    "a1",
    "g1",
    "a4",
    "g7",
    "b6",
    "c5",
    "d5",
    "e5",
  ],

  /*
     @ ----- d7 -----  O
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     O- @-c4     O- O- @
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*O*@***/@*O@O*@O/*O@***O@ b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "d7",
    "f6",
    "c5",
    "e5",
    "c4",
    "e3",
    "b2",
    "a1",
    "d1",
    "g1",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |   @-d5- O  |  |
    a4- @- O     @- O- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "*O@***O@/@*O@O*@O/O*O*@*** b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "d5",
    "f6",
    "a7",
    "g7",
    "a4",
    "g1",
    "b2",
    "c3",
    "d3",
    "e3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     @- O- O    e4- @- O
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
     O ----- d1 -----  @
  */
  "@***O*O*/O*@O@*O@/**O@*O@* b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "d1",
    "b2",
    "e3",
    "c3",
    "e4",
    "c5",
    "f6",
    "g7",
    "d7",
    "a7",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- O- @     O- @-g4
    |  |   O-d3- @  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "**O@*O@*/O*@O@*O@/@***O*O* b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "d3",
    "b2",
    "g1",
    "a1",
    "g4",
    "a7",
    "f6",
    "e5",
    "d5",
    "c5",
  ],

  /*
     O ----- d7 -----  @
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O- O    e4- @- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O***@*O*/@O@*O@O*/*@O***@O b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "d7",
    "b6",
    "e5",
    "c5",
    "e4",
    "c3",
    "f2",
    "g1",
    "d1",
    "a1",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |   O-d5- @  |  |
     O- O- @     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "*@O***@O/@O@*O@O*/O***@*O* b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "d5",
    "b6",
    "g7",
    "a7",
    "g4",
    "a1",
    "f2",
    "e3",
    "d3",
    "c3",
  ],

  /*
     @ -----  O ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O     @- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
     O -----  @ ----- g1
  */
  "**@*O*O*/@*O@O*@O/O***@O*@ b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a4",
    "b2",
    "c5",
    "c3",
    "d5",
    "e3",
    "f6",
    "g7",
    "g4",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |   @- O-e5  |  |
     O- @-c4    e4- O- @
    |  |   O- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "O***@O*@/@*O@O*@O/**@*O*O* b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c4",
    "b2",
    "a7",
    "a1",
    "d7",
    "g1",
    "f6",
    "e5",
    "e4",
    "e3",
  ],

  /*
    a7 -----  O -----  @
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @     O- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  @ -----  O
  */
  "**O*O*@*/@O@*O@O*/O@*O@*** b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g4",
    "f2",
    "e5",
    "e3",
    "d5",
    "c3",
    "b6",
    "a7",
    "a4",
    "a1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O- @  |  |
     @- O-c4    e4- @- O
    |  |  c3- @- O  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "O@*O@***/@O@*O@O*/**O*O*@* b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e4",
    "f2",
    "g7",
    "g1",
    "d7",
    "a1",
    "b6",
    "c5",
    "c4",
    "c3",
  ],

  /*
     O -----  @ ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @- O     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
     @ -----  O ----- g1
  */
  "O*@***O*/O@O*@O@*/@***O@*O b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a4",
    "b6",
    "c3",
    "c5",
    "d3",
    "e5",
    "f2",
    "g1",
    "g4",
    "g7",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |   O- @-e5  |  |
     O- @-c4    e4- O- @
    |  |   @- O-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@***O@*O/O@O*@O@*/O*@***O* b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c4",
    "b6",
    "a1",
    "a7",
    "d1",
    "g7",
    "f2",
    "e3",
    "e4",
    "e5",
  ],

  /*
    a7 -----  @ -----  O
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O- @     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 -----  O -----  @
  */
  "O*O***@*/O*@O@*O@/@O*@O*** b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g4",
    "f6",
    "e3",
    "e5",
    "d3",
    "c5",
    "b2",
    "a1",
    "a4",
    "a7",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @- O  |  |
     @- O-c4    e4- @- O
    |  |  c3- O- @  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@O*@O***/O*@O@*O@/O*O***@* b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e4",
    "f6",
    "g1",
    "g7",
    "d1",
    "a7",
    "b2",
    "c3",
    "c4",
    "c5",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @-c4     @- O- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "O*@*@***/@*O@O*@O/O*O@**** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>["a7"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @-c4     O- O- @
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O*O@****/@*O@O*@O/O*@*@*** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>["c5"],

  /*
    a7 ----- d7 -----  @
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @-c4     @- O- O
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@*@*O***/O@O*@O@*/*@O*O*** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>["a1"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
    a4- @-c4     O- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "*@O*O***/O@O*@O@*/@*@*O*** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>["c3"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     O- O- @    e4- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "O***@*@*/@O@*O@O*/O****@O* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>["g7"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O- O    e4- @-g4
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O****@O*/@O@*O@O*/O***@*@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>["e5"],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- O- @    e4- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@***O*@*/O*@O@*O@/****O*O@ w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>["g1"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
     @- O- O    e4- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "****O*O@/O*@O@*O@/@***O*@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>["e3"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @     O- @- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
     @ -----  O ----- g1
  */
  "**O*@*@*/@O@*O@O*/**O*O@** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>["g7"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4     O- @- O
    |  |   @- O-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "**O*O@**/@O@*O@O*/**O*@*@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>["e5"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @- O     @- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  O -----  @
  */
  "**@*@*O*/@*O@O*@O/***@O*O* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>["a7"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @- O    e4- O- @
    |  |  c3- O- @  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "***@O*O*/@*O@O*@O/**@*@*O* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>["c5"],

  /*
     @ -----  O ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O- @     O- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*O***@*/O*@O@*O@/O*O****@ w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>["g1"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |   @- O-e5  |  |
     @- O-c4     O- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*O****@/O*@O@*O@/@*O***@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>["e3"],

  /*
    a7 -----  O -----  @
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- @- O     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*@***O*/O@O*@O@*/O@****O* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>["a1"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- O- @  |  |
     O- @- O    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O@****O*/O@O*@O@*/@*@***O* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>["c3"],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 -----  @
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     O- @-c4     @- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "O*@*@***/@*O@O*@O/*@**O*O* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e5",
    "a7",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
    a4- @- O    e4- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "*@**O*O*/@*O@O*@O/O*@*@*** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g7",
    "c5",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- @-c4     @- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "@*@*O***/O@O*@O@*/O**@**O* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e3",
    "a1",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @- O    e4- O- @
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "O**@**O*/O@O*@O@*/@*@*O*** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g1",
    "c3",
  ],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O- @    e4- @- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "O***@*@*/@O@*O@O*/**O*O**@ w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c5",
    "g7",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
     @- O-c4     O- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "**O*O**@/@O@*O@O*/O***@*@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a7",
    "e5",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O- @    e4- @- O
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "@***O*@*/O*@O@*O@/O*O**@** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c3",
    "g1",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O-c4     O- @-g4
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "O*O**@**/O*@O@*O@/@***O*@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a1",
    "e3",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- O- @     O- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "**O*@*@*/@O@*O@O*/O**@**O* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e3",
    "g7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O- O    e4- @- O
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O**@**O*/@O@*O@O*/**O*@*@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g1",
    "e5",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O     @- O- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "**@*@*O*/@*O@O*@O/O*O**@** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c3",
    "a7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     O- @-c4     O- O- @
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O*O**@**/@*O@O*@O/**@*@*O* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a1",
    "c5",
  ],

  /*
    a7 ----- d7 -----  @
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- O- @     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@*O***@*/O*@O@*O@/*@**O*O* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e5",
    "g1",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
     @- O- O    e4- @- O
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*@**O*O*/O*@O@*O@/@*O***@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g7",
    "e3",
  ],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @- O     @- O- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@*@***O*/O@O*@O@*/**O*O**@ w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c5",
    "a1",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
     O- @-c4     O- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*O**@/O@O*@O@*/@*@***O* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a7",
    "c3",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @- O     @- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*@*@*O*/O@O@OO@*/O******* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a1",
    "g1",
    "c3",
    "e3",
    "a4",
    "c5",
    "a7",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     O- @-c4    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O*******/O@O@OO@*/@*@*@*O* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c3",
    "e3",
    "a1",
    "g1",
    "c4",
    "a7",
    "c5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @- O     @- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@*@*@*O*/O@O@O*@O/****O*** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a7",
    "g7",
    "c5",
    "e5",
    "a4",
    "c3",
    "a1",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "****O***/O@O@O*@O/@*@*@*O* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c5",
    "e5",
    "a7",
    "g7",
    "c4",
    "a1",
    "c3",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O- @     O- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*O*@*@*/O*@OO@O@/O******* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g1",
    "a1",
    "e3",
    "c3",
    "g4",
    "e5",
    "g7",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O*******/O*@OO@O@/@*O*@*@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e3",
    "c3",
    "g1",
    "a1",
    "e4",
    "g7",
    "e5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O- @     O- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@*O*@*@*/OO@*O@O@/****O*** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g7",
    "a7",
    "e5",
    "c5",
    "g4",
    "e3",
    "g1",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4    e4- @- O
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "****O***/OO@*O@O@/@*O*@*@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e5",
    "c5",
    "g7",
    "a7",
    "e4",
    "g1",
    "e3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O- @     @- O- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*@*@*@*/@*O@O@OO/**O***** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a7",
    "a1",
    "c5",
    "c3",
    "d7",
    "e5",
    "g7",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4     O- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "**O*****/@*O@O@OO/O*@*@*@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c5",
    "c3",
    "a7",
    "a1",
    "d5",
    "g7",
    "e5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     O- O- @     @- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*@*@*@*/@OO@O@O*/******O* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g7",
    "g1",
    "e5",
    "e3",
    "d7",
    "c5",
    "a7",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O- O    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "******O*/@OO@O@O*/O*@*@*@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e5",
    "e3",
    "g7",
    "g1",
    "d5",
    "a7",
    "c5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O- @     @- O- O
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*@*O*@*/O@O*@OO@/**O***** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a1",
    "a7",
    "c3",
    "c5",
    "d1",
    "e3",
    "g1",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4     O- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "**O*****/O@O*@OO@/@*@*O*@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c3",
    "c5",
    "a1",
    "a7",
    "d3",
    "g1",
    "e3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- O- @     @- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*@*O*@*/O@OO@*O@/******O* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g1",
    "g7",
    "e3",
    "e5",
    "d1",
    "c3",
    "a1",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O- O    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "******O*/O@OO@*O@/@*@*O*@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e3",
    "e5",
    "g1",
    "g7",
    "d3",
    "a1",
    "c3",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- O- @     O- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*@*@*/O*@OO@O@/@*****O* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e5",
    "g7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     @- O- O    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "@*****O*/O*@OO@O@/**O*@*@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g7",
    "e5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- O- @     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "@*O***@*/OO@*O@O@/****@*O* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e3",
    "g1",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O- O    e4- @- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****@*O*/OO@*O@O@/@*O***@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g1",
    "e3",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O     @- O- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@*@*O*/O@O@OO@*/@*O***** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c5",
    "a7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- @-c4     O- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "@*O*****/O@O@OO@*/**@*@*O* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a7",
    "c5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @- O     @- O- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "@*@***O*/O@O@O*@O/**O*@*** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c3",
    "a1",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4     O- O- @
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*@***/O@O@O*@O/@*@***O* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a1",
    "c3",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O- @    e4- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@***O*@*/O@O*@OO@/O*@***** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e3",
    "g1",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O-c4     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "O*@*****/O@O*@OO@/@***O*@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g1",
    "e3",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     @- O-c4     @- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*@*O***/O@OO@*O@/O*****@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c3",
    "a1",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O- @    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "O*****@*/O@OO@*O@/@*@*O*** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a1",
    "c3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O- @    e4- O- @
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "O***@*@*/@*O@O@OO/**@*O*** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e5",
    "g7",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4     @- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "**@*O***/@*O@O@OO/O***@*@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g7",
    "e5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O-c4     @- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "O*@*@***/@OO@O@O*/****O*@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c5",
    "a7",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @    e4- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "****O*@*/@OO@O@O*/O*@*@*** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a7",
    "c5",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @- O    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O*****O*/O*@*O*@*/@***@*** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["g4"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- @-c4    e4- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@***@***/O*@*O*@*/O*****O* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["e4"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O    e4- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "****O*O*/O*@*O*@*/@***@*** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["g4"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- @-c4    e4- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@***@***/O*@*O*@*/****O*O* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["e4"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @-c4     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O*O*****/O*@*O*@*/@***@*** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["a4"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @-c4    e4- @- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@***@***/O*@*O*@*/O*O***** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["c4"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4     O- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "**O*O***/O*@*O*@*/@***@*** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["a4"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @-c4    e4- @- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@***@***/O*@*O*@*/**O*O*** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["c4"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O-c4     O- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*O*****/@*O*@*O*/**@***@* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["d1"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @     @- O- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@***@*/@*O*@*O*/O*O***** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["d3"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O- O    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*****O*/@*O*@*O*/**@***@* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["d1"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- O- @     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@***@*/@*O*@*O*/O*****O* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["d3"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4     O- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*O***/@*O*@*O*/**@***@* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["d7"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @     @- O- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "**@***@*/@*O*@*O*/**O*O*** w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["d5"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O- O    e4- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****O*O*/@*O*@*O*/**@***@* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["d7"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- O- @     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "**@***@*/@*O*@*O*/****O*O* w p p 4 5 4 5 0 0 0 0 0 0 0 0 5": <String>["d5"],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/OO@*@O@*/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "a1",
    "d1",
    "c3",
    "d3",
    "a4",
    "c4",
    "e4",
    "g4",
    "e5",
    "g7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*@OO*@O/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "a7",
    "d7",
    "c5",
    "d5",
    "a4",
    "c4",
    "e4",
    "g4",
    "e3",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*@O@*@O/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "g1",
    "d1",
    "e3",
    "d3",
    "g4",
    "e4",
    "c4",
    "a4",
    "c5",
    "a7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@O@*OO@*/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "g7",
    "d7",
    "e5",
    "d5",
    "g4",
    "e4",
    "c4",
    "a4",
    "c3",
    "a1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*OO@*@O/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "a7",
    "a4",
    "c5",
    "c4",
    "d7",
    "d5",
    "d3",
    "d1",
    "e3",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@O@*@OO*/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "g7",
    "g4",
    "e5",
    "e4",
    "d7",
    "d5",
    "d3",
    "d1",
    "c3",
    "a1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@OO*@O@*/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "a1",
    "a4",
    "c3",
    "c4",
    "d1",
    "d3",
    "d5",
    "d7",
    "e5",
    "g7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*@O@*OO/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "g1",
    "g4",
    "e3",
    "e4",
    "d1",
    "d3",
    "d5",
    "d7",
    "c5",
    "a7",
  ],

  /////////////////////////////// Low Risk /////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/*O@*@O**/******** w p p 2 7 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "b4",
    "d6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*@O***O/******** w p p 2 7 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "b4",
    "d2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/***O@*@O/******** w p p 2 7 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "f4",
    "d6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@O***O@*/******** w p p 2 7 2 7 0 0 0 0 0 0 0 0 3": <String>[
    "f4",
    "d2",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*******/O**@**O@/@******* w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "a1",
    "d1",
    "g1",
    "d2",
    "c3",
    "d3",
    "e3",
    "e4",
    "f4",
    "g4",
    "a7",
    "g7",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*******/O**@**O@/O******* w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "c3",
    "d3",
    "e3",
    "d2",
    "a1",
    "d1",
    "g1",
    "g4",
    "f4",
    "e4",
    "c5",
    "e5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "****O***/*@**O@O*/****@*** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "a7",
    "d7",
    "g7",
    "d6",
    "c5",
    "d5",
    "e5",
    "e4",
    "f4",
    "g4",
    "a1",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "****@***/*@**O@O*/****O*** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "c5",
    "d5",
    "e5",
    "d6",
    "a7",
    "d7",
    "g7",
    "g4",
    "f4",
    "e4",
    "c3",
    "e3",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*******/O@O**@**/@******* w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "g1",
    "d1",
    "a1",
    "d2",
    "e3",
    "d3",
    "c3",
    "c4",
    "b4",
    "a4",
    "g7",
    "a7",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*******/O@O**@**/O******* w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "e3",
    "d3",
    "c3",
    "d2",
    "g1",
    "d1",
    "a1",
    "a4",
    "b4",
    "c4",
    "e5",
    "c5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "****O***/**O@O**@/****@*** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "g7",
    "d7",
    "a7",
    "d6",
    "e5",
    "d5",
    "c5",
    "c4",
    "b4",
    "a4",
    "g1",
    "a1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "****@***/**O@O**@/****O*** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "e5",
    "d5",
    "c5",
    "d6",
    "g7",
    "d7",
    "a7",
    "a4",
    "b4",
    "c4",
    "e3",
    "c3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4     O- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*****/O@O**@**/**@***** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "a7",
    "a4",
    "a1",
    "b4",
    "c5",
    "c4",
    "c3",
    "d3",
    "d2",
    "d1",
    "g7",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4     @- O- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@*****/O@O**@**/**O***** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "c5",
    "c4",
    "c3",
    "b4",
    "a7",
    "a4",
    "a1",
    "d1",
    "d2",
    "d3",
    "e5",
    "e3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O- O    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******O*/O**@**O@/******@* w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "g7",
    "g4",
    "g1",
    "f4",
    "e5",
    "e4",
    "e3",
    "d3",
    "d2",
    "d1",
    "a7",
    "a1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- O- @    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******@*/O**@**O@/******O* w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "e5",
    "e4",
    "e3",
    "f4",
    "g7",
    "g4",
    "g1",
    "d1",
    "d2",
    "d3",
    "c5",
    "c3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4     O- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*****/**O@O**@/**@***** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "a1",
    "a4",
    "a7",
    "b4",
    "c3",
    "c4",
    "c5",
    "d5",
    "d6",
    "d7",
    "g1",
    "g7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4     @- O- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@*****/**O@O**@/**O***** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "c3",
    "c4",
    "c5",
    "b4",
    "a1",
    "a4",
    "a7",
    "d7",
    "d6",
    "d5",
    "e3",
    "e5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O- O    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******O*/*@**O@O*/******@* w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "g1",
    "g4",
    "g7",
    "f4",
    "e3",
    "e4",
    "e5",
    "d5",
    "d6",
    "d7",
    "a1",
    "a7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- O- @    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******@*/*@**O@O*/******O* w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "e3",
    "e4",
    "e5",
    "f4",
    "g1",
    "g4",
    "g7",
    "d7",
    "d6",
    "d5",
    "c3",
    "c5",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- @-c4     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*@*****/@*O*O*@O/O*****O* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "d1",
    "f2",
    "c3",
    "d3",
    "e3",
    "c4",
    "g4",
    "a7",
    "g7",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @- O    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*****O*/@*O*O*@O/@*@***** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "d3",
    "f2",
    "a1",
    "d1",
    "g1",
    "a4",
    "e4",
    "c5",
    "e5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4     @- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "**@*@***/O*O*@O@*/****O*O* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "d7",
    "f6",
    "c5",
    "d5",
    "e5",
    "c4",
    "g4",
    "a1",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O    e4- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "****O*O*/O*O*@O@*/**@*@*** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "d5",
    "f6",
    "a7",
    "d7",
    "g7",
    "a4",
    "e4",
    "c3",
    "e3",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O- @    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*****@*/@O@*O*O*/O*O***** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "d1",
    "b2",
    "e3",
    "d3",
    "c3",
    "e4",
    "a4",
    "g7",
    "a7",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O-c4     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*O*****/@O@*O*O*/@*****@* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "d3",
    "b2",
    "g1",
    "d1",
    "a1",
    "g4",
    "c4",
    "e5",
    "c5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @    e4- @- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "****@*@*/O*@O@*O*/**O*O*** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "d7",
    "b6",
    "e5",
    "d5",
    "c5",
    "e4",
    "a4",
    "g1",
    "a1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4     O- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "**O*O***/O*@O@*O*/****@*@* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "d5",
    "b6",
    "g7",
    "d7",
    "a7",
    "g4",
    "c4",
    "e3",
    "c3",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     @- @- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@*@***/@O@*O*O*/O*O***** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "a4",
    "b2",
    "c5",
    "c4",
    "c3",
    "d5",
    "d1",
    "g7",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O-c4     O- @- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O*O*****/@O@*O*O*/**@*@*** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "c4",
    "b2",
    "a7",
    "a4",
    "a1",
    "d7",
    "d3",
    "e5",
    "e3",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @- @    e4- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****@*@*/@*O*O*@O/O*****O* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "g4",
    "f2",
    "e5",
    "e4",
    "e3",
    "d5",
    "d1",
    "a7",
    "a1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- @- O    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O*****O*/@*O*O*@O/****@*@* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "e4",
    "f2",
    "g7",
    "g4",
    "g1",
    "d7",
    "d3",
    "c5",
    "c3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O-c4     @- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@*@*****/O*@O@*O*/**O*O*** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "a4",
    "b6",
    "c3",
    "c4",
    "c5",
    "d3",
    "d7",
    "g1",
    "g7",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     O- @- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*O***/O*@O@*O*/@*@***** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "c4",
    "b6",
    "a1",
    "a4",
    "a7",
    "d1",
    "d5",
    "e3",
    "e5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- @- @    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@*****@*/O*O*@O@*/****O*O* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "g4",
    "f6",
    "e3",
    "e4",
    "e5",
    "d3",
    "d7",
    "a1",
    "a7",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- @- O    e4- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****O*O*/O*O*@O@*/@*****@* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "e4",
    "f6",
    "g1",
    "g4",
    "g7",
    "d1",
    "d5",
    "c3",
    "c5",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 -----  O
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4- @     @- O- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
     @ -----  O -----  O
  */
  "**@*@*@*/OOO@@O*@/*OOOO@** w p p 8 1 7 1 0 0 0 0 0 0 0 0 9": <String>[
    "c3",
    "e3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5- O  |  |
     @-b4-c4     O- O- @
    |  |   @- O- O  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "*OOOO@**/OOO@@O*@/**@*@*@* w p p 8 1 7 1 0 0 0 0 0 0 0 0 9": <String>[
    "a1",
    "g1",
  ],

  /*
     @ -----  O -----  O
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4-b4- @     @- O- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 -----  O
  */
  "@*@***@*/@@OOO@*O/OOOO***@ w p p 8 1 7 1 0 0 0 0 0 0 0 0 9": <String>[
    "c5",
    "e5",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |   @- O- O  |  |
     @-b4-c4     O- O- @
    |  |  c3-d3- O  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "OOOO***@/@@OOO@*O/@*@***@* w p p 8 1 7 1 0 0 0 0 0 0 0 0 9": <String>[
    "a7",
    "g7",
  ],

  /*
     O ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- O- @     @-f4-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
     O -----  O -----  @
  */
  "**@*@*@*/O@*O@@OO/***@OOOO w p p 8 1 7 1 0 0 0 0 0 0 0 0 9": <String>[
    "e3",
    "c3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |   O-d5-e5  |  |
     @- O- O    e4-f4- @
    |  |   O- O- @  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "***@OOOO/O@*O@@OO/**@*@*@* w p p 8 1 7 1 0 0 0 0 0 0 0 0 9": <String>[
    "g1",
    "a1",
  ],

  /*
     O -----  O -----  @
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- O- @     @-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
     O ----- d1 ----- g1
  */
  "@*@***@*/@O*@OOO@/O@***OOO w p p 8 1 7 1 0 0 0 0 0 0 0 0 9": <String>[
    "e5",
    "c5",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |   O- O- @  |  |
     @- O- O    e4-f4- @
    |  |   O-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O@***OOO/@O*@OOO@/@*@***@* w p p 8 1 7 1 0 0 0 0 0 0 0 0 9": <String>[
    "g7",
    "a7",
  ],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |   O -- d6 --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- @- @    e4- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
     O -----  O -----  O
  */
  "@***@*@*/*@OOO@@O/***OOOO@ w p p 8 1 7 1 0 0 0 0 0 0 0 0 9": <String>[
    "c5",
    "c3",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O -- d6 --  @  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
     @- @- O    e4- O-g4
    |  |   O- O- O  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "***OOOO@/*@OOO@@O/@***@*@* w p p 8 1 7 1 0 0 0 0 0 0 0 0 9": <String>[
    "a7",
    "a1",
  ],

  /*
    a7 ----- d7 -----  @
    |         |        |
    |   @ -- d6 --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O-c4     @- @- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
     O -----  O -----  O
  */
  "@*@*@***/*O@@OOO@/*@OOOO** w p p 8 1 7 1 0 0 0 0 0 0 0 0 9": <String>[
    "e5",
    "e3",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ -- d6 --  O  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
    a4- O-c4     O- @- @
    |  |   O- O- O  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "*@OOOO**/*O@@OOO@/@*@*@*** w p p 8 1 7 1 0 0 0 0 0 0 0 0 9": <String>[
    "g7",
    "g1",
  ],

  /*
     O -----  O -----  O
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- @- @    e4- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O -- d2 --  @  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "@***@*@*/OOO@*O@@/OO***@OO w p p 8 1 7 1 0 0 0 0 0 0 0 0 9": <String>[
    "c3",
    "c5",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |   O- O- O  |  |
     @- @- O    e4- O-g4
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |   O -- d2 --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "OO***@OO/OOO@*O@@/@***@*@* w p p 8 1 7 1 0 0 0 0 0 0 0 0 9": <String>[
    "a1",
    "a7",
  ],

  /*
     O -----  O -----  O
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O-c4     @- @- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ -- d2 --  O  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "@*@*@***/O@@O*@OO/OOO@***O w p p 8 1 7 1 0 0 0 0 0 0 0 0 9": <String>[
    "e3",
    "e5",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |   O- O- O  |  |
    a4- O-c4     O- @- @
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |   @ -- d2 --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "OOO@***O/O@@O*@OO/@*@*@*** w p p 8 1 7 1 0 0 0 0 0 0 0 0 9": <String>[
    "g1",
    "g7",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4- O    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******O*/@O@*@O**/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "a1",
    "d1",
    "d3",
    "a1",
    "e4",
    "g4",
    "d5",
    "d7",
    "g7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O-b4-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@O@*@O**/******O* w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "c3",
    "d3",
    "d1",
    "c3",
    "g4",
    "e4",
    "d7",
    "d5",
    "e5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4- O    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******O*/@*@O@**O/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "a7",
    "d7",
    "d5",
    "a7",
    "e4",
    "g4",
    "d3",
    "d1",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O-b4-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*@O@**O/******O* w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "c5",
    "d5",
    "d7",
    "c5",
    "g4",
    "e4",
    "d1",
    "d3",
    "e3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4     O-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*****/@**O@*@O/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "g1",
    "d1",
    "d3",
    "g1",
    "c4",
    "a4",
    "d5",
    "d7",
    "a7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4-f4- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@**O@*@O/**O***** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "e3",
    "d3",
    "d1",
    "e3",
    "a4",
    "c4",
    "d7",
    "d5",
    "c5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4     O-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*****/@O**@O@*/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "g7",
    "d7",
    "d5",
    "g7",
    "c4",
    "a4",
    "d3",
    "d1",
    "a1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4-f4- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@O**@O@*/**O***** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "e5",
    "d5",
    "d7",
    "e5",
    "a4",
    "c4",
    "d1",
    "d3",
    "c3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*******/**@O@*@O/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "a7",
    "a4",
    "c4",
    "a7",
    "d3",
    "d1",
    "e4",
    "g4",
    "g1",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/**@O@*@O/O******* w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "c5",
    "c4",
    "a4",
    "c5",
    "d1",
    "d3",
    "g4",
    "e4",
    "e3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*******/*O@*@O@*/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "g7",
    "g4",
    "e4",
    "g7",
    "d3",
    "d1",
    "c4",
    "a4",
    "a1",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 -- d6 --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/*O@*@O@*/O******* w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "e5",
    "e4",
    "g4",
    "e5",
    "d1",
    "d3",
    "a4",
    "c4",
    "c3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****O***/@O@**O@*/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "a1",
    "a4",
    "c4",
    "a1",
    "d5",
    "d7",
    "e4",
    "g4",
    "g7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O -- d2 -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "********/@O@**O@*/****O*** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "c3",
    "c4",
    "a4",
    "c3",
    "d7",
    "d5",
    "g4",
    "e4",
    "e5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****O***/@*@O**@O/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "g1",
    "g4",
    "e4",
    "g1",
    "d5",
    "d7",
    "c4",
    "a4",
    "a7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "********/@*@O**@O/****O*** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "e3",
    "e4",
    "g4",
    "e3",
    "d7",
    "d5",
    "a4",
    "c4",
    "c5",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |   O-d5-e5  |  |
    a4- @-c4    e4- @- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "****@**O/@*@OO@@O/O*O**@** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a4",
    "d5",
    "a7",
    "g7",
  ],

  /*
     O ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @-c4     O- @-g4
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O*O**@**/@*@OO@@O/****@**O w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c4",
    "d7",
    "c5",
    "e5",
  ],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @-c4    e4- @- O
    |  |   O-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@****O**/OO@*@O@@/**O*O**@ w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a4",
    "d3",
    "a1",
    "g1",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
    a4- @-c4     O- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
     O ----- d1 ----- g1
  */
  "**O*O**@/OO@*@O@@/@****O** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c4",
    "d1",
    "c3",
    "e3",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5- O  |  |
     O- @-c4    e4- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "*O**@***/@O@@OO@*/O**@**O* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g4",
    "d5",
    "g7",
    "a7",
  ],

  /*
    a7 ----- d7 -----  O
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @- O    e4- @-g4
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O**@**O*/@O@@OO@*/*O**@*** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e4",
    "d7",
    "e5",
    "c5",
  ],

  /*
    a7 ----- d7 -----  @
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- @-c4    e4- @-g4
    |  |  c3-d3- O  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@**O****/O@@O@*@O/*@**O*O* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g4",
    "d3",
    "g1",
    "a1",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
    a4- @- O    e4- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 -----  O
  */
  "*@**O*O*/O@@O@*@O/@**O**** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e4",
    "d1",
    "e3",
    "c3",
  ],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5- O  |  |
    a4- O- @    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "*O****@*/@O@*@OO@/**O*O**@ w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "d7",
    "e4",
    "g7",
    "g1",
  ],

  /*
    a7 ----- d7 -----  O
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
     @- O-c4     O- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*O**@/@O@*@OO@/*O****@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "d5",
    "g4",
    "e5",
    "e3",
  ],

  /*
    a7 ----- d7 -----  @
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |   O-d5-e5  |  |
     O- @-c4     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "**@****O/@@OO@*@O/*@**O*O* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "d7",
    "c4",
    "a7",
    "a1",
  ],

  /*
     O ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
    a4- @- O    e4- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*@**O*O*/@@OO@*@O/**@****O w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "d5",
    "a4",
    "c5",
    "c3",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @    e4- @- O
    |  |  c3-d3- O  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "***O**@*/@*@O@@OO/O*O**@** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "d1",
    "e4",
    "g1",
    "g7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O-c4     O- @-g4
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 -----  O
  */
  "O*O**@**/@*@O@@OO/***O**@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "d3",
    "g4",
    "e3",
    "e5",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4     @- O-g4
    |  |   O-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "**@**O**/@OO@@O@*/O**@**O* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "d1",
    "c4",
    "a1",
    "a7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @- O    e4- O- @
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
     O ----- d1 ----- g1
  */
  "O**@**O*/@OO@@O@*/**@**O** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "d3",
    "a4",
    "c3",
    "c5",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 -----  O
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O-c4     @- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "O*@*****/@O@*@OO@/*OO@**** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "d1",
    "d3",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5- O  |  |
    a4- O-c4     O- @- @
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*OO@****/@O@*@OO@/O*@***** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "d3",
    "d1",
  ],

  /*
    a7 ----- d7 -----  @
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     @- @- O
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 ----- d1 -----  O
  */
  "**@*O***/@*@O@@OO/*@OO**** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "d7",
    "d5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
    a4- O-c4     O- @- @
    |  |  c3-d3- O  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "*@OO****/@*@O@@OO/**@*O*** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "d5",
    "d7",
  ],

  /*
     O ----- d7 ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     O- @- @    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "O*****@*/@@OO@*@O/*****@OO w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "d1",
    "d3",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |   O-d5-e5  |  |
     @- @- O    e4- O-g4
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*****@OO/@@OO@*@O/O*****@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "d3",
    "d1",
  ],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @- @    e4- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
     O ----- d1 ----- g1
  */
  "****O*@*/@OO@@O@*/*****OO@ w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "d7",
    "d5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
     @- @- O    e4- O-g4
    |  |   O-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "*****OO@/@OO@@O@*/****O*@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "d5",
    "d7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4     O- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
     @ -----  O -----  O
  */
  "**O*@***/O@@O@*@O/***OO@** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a4",
    "c4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- @- O
    |  |   @- O- O  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "***OO@**/O@@O@*@O/**O*@*** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c4",
    "a4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O    e4- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
     O -----  O -----  @
  */
  "****@*O*/OO@*@O@@/***@OO** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g4",
    "e4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- @-g4
    |  |   O- O- @  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "***@OO**/OO@*@O@@/****@*O* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e4",
    "g4",
  ],

  /*
     @ -----  O -----  O
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @-c4     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*O*****/@O@@OO@*/OO*****@ w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a4",
    "c4",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |   @- O- O  |  |
    a4- @-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "OO*****@/@O@@OO@*/@*O***** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c4",
    "a4",
  ],

  /*
     O -----  O -----  @
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @- O    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*****O*/@*@OO@@O/O@*****O w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g4",
    "e4",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |   O- O- @  |  |
     O- @-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O@*****O/@*@OO@@O/@*****O* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e4",
    "g4",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |   @- O- O  |  |
     O- @-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "OO*****@/@*@*O*@O/@*****O* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["f2"],

  /*
     @ -----  O -----  O
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @- O    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*****O*/@*@*O*@O/OO*****@ w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["f2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- @-g4
    |  |   @- O- O  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "***OO@**/O*@*@O@*/****@*O* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["f6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O    e4- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
     @ -----  O -----  O
  */
  "****@*O*/O*@*@O@*/***OO@** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["f6"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |   O- O- @  |  |
    a4- @-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O@*****O/@O@*O*@*/@*O***** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["b2"],

  /*
     O -----  O -----  @
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @-c4     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*O*****/@O@*O*@*/O@*****O w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["b2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- @- O
    |  |   O- O- @  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "***@OO**/O*@O@*@*/**O*@*** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["b6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4     O- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
     O -----  O -----  @
  */
  "**O*@***/O*@O@*@*/***@OO** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["b6"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
    a4- O-c4     O- @- @
    |  |  c3-d3- O  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*@OO****/@O@*@*O*/O*@***** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["b2"],

  /*
    a7 ----- d7 -----  @
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O-c4     @- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 -----  O
  */
  "O*@*****/@O@*@*O*/*@OO**** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["b2"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
     @- @- O    e4- O-g4
    |  |   O-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*****OO@/@*O*@*@O/O*****@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["f2"],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     O- @- @    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
     O ----- d1 ----- g1
  */
  "O*****@*/@*O*@*@O/*****OO@ w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["f2"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5- O  |  |
    a4- O-c4     O- @- @
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "*OO@****/@*@O@*O*/**@*O*** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["b6"],

  /*
    a7 ----- d7 -----  O
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     @- @- O
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "**@*O***/@*@O@*O*/*OO@**** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["b6"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |   O-d5-e5  |  |
     @- @- O    e4- O-g4
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "*****@OO/@*O*@O@*/****O*@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["f6"],

  /*
     O ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @- @    e4- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "****O*@*/@*O*@O@*/*****@OO w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>["f6"],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- @-g4
    |  |  c3-d3- O  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "***O****/@O@*@O**/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "d1",
    "g4",
    "d7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 -----  O
  */
  "********/@O@*@O**/***O**** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "d3",
    "e4",
    "d5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5- O  |  |
    a4-b4-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*O******/@*@O@**O/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "d7",
    "g4",
    "d1",
  ],

  /*
    a7 ----- d7 -----  O
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*@O@**O/*O****** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "d5",
    "e4",
    "d3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4-f4-g4
    |  |   O-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*****O**/@**O@*@O/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "d1",
    "a4",
    "d7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
     O ----- d1 ----- g1
  */
  "********/@**O@*@O/*****O** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "d3",
    "c4",
    "d5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |   O-d5-e5  |  |
    a4- @-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*******O/@O**@O@*/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "d7",
    "a4",
    "d1",
  ],

  /*
     O ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@O**@O@*/*******O w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "d5",
    "c4",
    "d3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- @-g4
    |  |   O-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*****O**/**@O@*@O/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "a4",
    "d1",
    "g4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
     O ----- d1 ----- g1
  */
  "********/**@O@*@O/*****O** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "c4",
    "d3",
    "e4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- @-g4
    |  |  c3-d3- O  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "***O****/*O@*@O@*/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "g4",
    "d1",
    "a4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 -----  O
  */
  "********/*O@*@O@*/***O**** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "e4",
    "d3",
    "c4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |   O-d5-e5  |  |
    a4- @-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*******O/@O@**O@*/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "a4",
    "d7",
    "g4",
  ],

  /*
     O ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@O@**O@*/*******O w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "c4",
    "d5",
    "e4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5- O  |  |
    a4- @-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*O******/@*@O**@O/******** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "g4",
    "d7",
    "a4",
  ],

  /*
    a7 ----- d7 -----  O
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*@O**@O/*O****** w p p 3 6 3 6 0 0 0 0 0 0 0 0 4": <String>[
    "e4",
    "d5",
    "c4",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 -----  @ -----  O
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "********/O@O*@O@*/@O@*O*** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "c3",
    "d3",
    "e3",
    "a4",
    "c4",
    "e4",
    "c5",
    "d5",
    "e5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- @- O  |  |
    a4- @-c4     @- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@O@*O***/O@O*@O@*/******** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "a1",
    "d1",
    "g1",
    "c4",
    "a4",
    "g4",
    "a7",
    "d7",
    "g7",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  @ -----  O
  */
  "********/@*O@O*@O/O*@O@*** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "c5",
    "d5",
    "e5",
    "a4",
    "c4",
    "e4",
    "c3",
    "d3",
    "e3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- @-c4     @- O-g4
    |  |  c3- @- O  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*@O@***/@*O@O*@O/******** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "a7",
    "d7",
    "g7",
    "c4",
    "a4",
    "g4",
    "a1",
    "d1",
    "g1",
  ],

  /*
     O -----  @ ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "********/O*@O@*O@/@***O*@O w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "e3",
    "d3",
    "c3",
    "g4",
    "e4",
    "c4",
    "e5",
    "d5",
    "c5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |   O- @-e5  |  |
    a4- O- @    e4- @-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@***O*@O/O*@O@*O@/******** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "g1",
    "d1",
    "a1",
    "e4",
    "g4",
    "a4",
    "g7",
    "d7",
    "a7",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
     O -----  @ ----- g1
  */
  "********/@O@*O@O*/O***@O@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "e5",
    "d5",
    "c5",
    "g4",
    "e4",
    "c4",
    "e3",
    "d3",
    "c3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O- @    e4- @-g4
    |  |   O- @-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O***@O@*/@O@*O@O*/******** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "g7",
    "d7",
    "a7",
    "e4",
    "g4",
    "a4",
    "g1",
    "d1",
    "a1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  @ -----  O
  */
  "********/@*O@O*@O/**@O@*O* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "c5",
    "c4",
    "c3",
    "d7",
    "d5",
    "d3",
    "e5",
    "e4",
    "e3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- O     @- O-g4
    |  |  c3- @- O  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@O@*O*/@*O@O*@O/******** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "a7",
    "a4",
    "a1",
    "d5",
    "d7",
    "d1",
    "g7",
    "g4",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
     O -----  @ ----- g1
  */
  "********/@O@*O@O*/**O*@O@* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "e5",
    "e4",
    "e3",
    "d7",
    "d5",
    "d3",
    "c5",
    "c4",
    "c3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @     O- @-g4
    |  |   O- @-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**O*@O@*/@O@*O@O*/******** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "g7",
    "g4",
    "g1",
    "d5",
    "d7",
    "d1",
    "a7",
    "a4",
    "a1",
  ],

  /*
    a7 -----  @ -----  O
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O@O*@O@*/@O@***O* w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "c3",
    "c4",
    "c5",
    "d1",
    "d3",
    "d5",
    "e3",
    "e4",
    "e5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- @- O  |  |
    a4- @- O     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@O@***O*/O@O*@O@*/******** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "a1",
    "a4",
    "a7",
    "d3",
    "d1",
    "d7",
    "g1",
    "g4",
    "g7",
  ],

  /*
     O -----  @ ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*@O@*O@/@*O***@O w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "e3",
    "e4",
    "e5",
    "d1",
    "d3",
    "d5",
    "c3",
    "c4",
    "c5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |   O- @-e5  |  |
    a4- O- @     O- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*O***@O/O*@O@*O@/******** w p p 5 4 5 4 0 0 0 0 0 0 0 0 6": <String>[
    "g1",
    "g4",
    "g7",
    "d3",
    "d1",
    "d7",
    "a1",
    "a4",
    "a7",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @     @- O-g4
    |  |  c3-d3- O  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@O**@*/O@O@OOO@/@******* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a1",
    "d1",
    "g1",
    "c3",
    "c5",
    "d5",
    "a7",
    "g7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     @- O-c4    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 -----  O
  */
  "@*******/O@O@OOO@/**@O**@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c3",
    "d3",
    "e3",
    "a1",
    "a7",
    "d7",
    "c5",
    "e5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5- O  |  |
    a4- O- @     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "*O@***@*/O@O@O@OO/****@*** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a7",
    "d7",
    "g7",
    "c5",
    "c3",
    "d3",
    "a1",
    "g1",
  ],

  /*
    a7 ----- d7 -----  O
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4    e4- O- @
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****@***/O@O@O@OO/*O@***@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c5",
    "d5",
    "e5",
    "a7",
    "a1",
    "d1",
    "c3",
    "e3",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @     @- O-g4
    |  |   O-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@**O@*/O@OOO@O@/@******* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g1",
    "d1",
    "a1",
    "e3",
    "e5",
    "d5",
    "g7",
    "a7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     @- O-c4    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
     O ----- d1 ----- g1
  */
  "@*******/O@OOO@O@/**@**O@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e3",
    "d3",
    "c3",
    "g1",
    "g7",
    "d7",
    "e5",
    "c5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |   O-d5-e5  |  |
    a4- O- @     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "**@***@O/OOO@O@O@/****@*** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g7",
    "d7",
    "a7",
    "e5",
    "e3",
    "d3",
    "g1",
    "a1",
  ],

  /*
     O ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4    e4- O- @
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****@***/OOO@O@O@/**@***@O w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e5",
    "d5",
    "c5",
    "g7",
    "g1",
    "d1",
    "e3",
    "c3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O-c4    e4- O- @
    |  |   O- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@***@O**/O@O@O@OO/**@***** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a7",
    "a4",
    "a1",
    "c5",
    "e5",
    "e4",
    "g7",
    "g1",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
     O -----  @ ----- g1
  */
  "**@*****/O@O@O@OO/@***@O** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c5",
    "c4",
    "c3",
    "a7",
    "g7",
    "g4",
    "e5",
    "e3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     @- O-c4    e4- O-g4
    |  |  c3- @- O  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@**O@***/OOO@O@O@/******@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g7",
    "g4",
    "g1",
    "e5",
    "c5",
    "c4",
    "a7",
    "a1",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 -----  @ -----  O
  */
  "******@*/OOO@O@O@/@**O@*** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e5",
    "e4",
    "e3",
    "g7",
    "a7",
    "a4",
    "c5",
    "c3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |   O- @-e5  |  |
    a4- O-c4    e4- O- @
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@***@**O/O@O@OOO@/**@***** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a1",
    "a4",
    "a7",
    "c3",
    "e3",
    "e4",
    "g1",
    "g7",
  ],

  /*
     O -----  @ ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "**@*****/O@O@OOO@/@***@**O w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c3",
    "c4",
    "c5",
    "a1",
    "g1",
    "g4",
    "e3",
    "e5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5- @- O  |  |
     @- O-c4    e4- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@O**@***/O@OOO@O@/******@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g1",
    "g4",
    "g7",
    "e3",
    "c3",
    "c4",
    "a1",
    "a7",
  ],

  /*
    a7 -----  @ -----  O
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "******@*/O@OOO@O@/@O**@*** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e3",
    "e4",
    "e5",
    "g1",
    "a1",
    "a4",
    "c3",
    "c5",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5- O  |  |
     @- O-c4     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "*O@*****/O@O@O@OO/****@*@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a1",
    "g1",
    "c3",
    "c4",
    "g4",
    "c5",
    "a7",
    "d7",
    "g7",
  ],

  /*
    a7 ----- d7 -----  O
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @    e4- O- @
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****@*@*/O@O@O@OO/*O@***** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c3",
    "e3",
    "a1",
    "a4",
    "e4",
    "a7",
    "c5",
    "d5",
    "e5",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4     @- O-g4
    |  |  c3-d3- O  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@O****/O@O@OOO@/@*****@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a7",
    "g7",
    "c5",
    "c4",
    "g4",
    "c3",
    "a1",
    "d1",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O- @    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 -----  O
  */
  "@*****@*/O@O@OOO@/**@O**** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c5",
    "e5",
    "a7",
    "a4",
    "e4",
    "a1",
    "c3",
    "d3",
    "e3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |   O-d5-e5  |  |
    a4- O- @    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "******@O/OOO@O@O@/**@*@*** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g1",
    "a1",
    "e3",
    "e4",
    "a4",
    "e5",
    "g7",
    "d7",
    "a7",
  ],

  /*
     O ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4     @- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@*@***/OOO@O@O@/******@O w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e3",
    "c3",
    "g1",
    "g4",
    "c4",
    "g7",
    "e5",
    "d5",
    "c5",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @    e4- O- @
    |  |   O-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*****O@*/O@OOO@O@/@*@***** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g7",
    "a7",
    "e5",
    "e4",
    "a4",
    "e3",
    "g1",
    "d1",
    "a1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     @- O-c4     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
     O ----- d1 ----- g1
  */
  "@*@*****/O@OOO@O@/*****O@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e5",
    "c5",
    "g7",
    "g4",
    "c4",
    "g1",
    "e3",
    "d3",
    "c3",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4    e4- O-g4
    |  |  c3- @- O  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "***O@***/OOO@O@O@/@*****@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a7",
    "a1",
    "c5",
    "d5",
    "d1",
    "e5",
    "g7",
    "g4",
    "g1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O- @    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 -----  @ -----  O
  */
  "@*****@*/OOO@O@O@/***O@*** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c5",
    "c3",
    "a7",
    "d7",
    "d3",
    "g7",
    "e5",
    "e4",
    "e3",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- O- @
    |  |   O- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****@O**/O@O@O@OO/@*@***** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g7",
    "g1",
    "e5",
    "d5",
    "d1",
    "c5",
    "a7",
    "a4",
    "a1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O-c4     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
     O -----  @ ----- g1
  */
  "@*@*****/O@O@O@OO/****@O** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e5",
    "e3",
    "g7",
    "d7",
    "d3",
    "a7",
    "c5",
    "c4",
    "c3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5- @- O  |  |
     @- O-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "@O******/O@OOO@O@/****@*@* w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a1",
    "a7",
    "c3",
    "d3",
    "d7",
    "e3",
    "g1",
    "g4",
    "g7",
  ],

  /*
    a7 -----  @ -----  O
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @    e4- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****@*@*/O@OOO@O@/@O****** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c3",
    "c5",
    "a1",
    "d1",
    "d5",
    "g1",
    "e3",
    "e4",
    "e5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |   O- @-e5  |  |
    a4- O-c4    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "@******O/O@O@OOO@/**@*@*** w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g1",
    "g7",
    "e3",
    "d3",
    "d7",
    "c3",
    "a1",
    "a4",
    "a7",
  ],

  /*
     O -----  @ ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     @- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@*@***/O@O@OOO@/@******O w p p 6 3 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e3",
    "e5",
    "g1",
    "d1",
    "d5",
    "a1",
    "c3",
    "c4",
    "c5",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 -----  O ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |   O-d5- O  |  |
     @- @- O    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "*O****OO/O@O@O*@O/O*@@**@* b p p 8 1 6 2 0 0 0 0 0 0 0 0 8": <String>["c5"],

  /*
     O ----- d7 -----  O
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     O- @- @     @- O-g4
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*@@**@*/O@O@O*@O/*O****OO b p p 8 1 6 2 0 0 0 0 0 0 0 0 8": <String>["a7"],

  /*
    a7 ----- d7 -----  @
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- @- O    e4- O- @
    |  |   O-d3- O  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "***O*OO*/O@O@OO@*/*@@*O*@* b p p 8 1 6 2 0 0 0 0 0 0 0 0 8": <String>["c3"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
     O- @- @     @- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
     O ----- d1 -----  O
  */
  "*@@*O*@*/O@O@OO@*/***O*OO* b p p 8 1 6 2 0 0 0 0 0 0 0 0 8": <String>["a1"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |   O-d5- O  |  |
     @- O-c4     O- @- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "*OO****O/OO@*O@O@/O*@**@@* b p p 8 1 6 2 0 0 0 0 0 0 0 0 8": <String>["e5"],

  /*
     O ----- d7 -----  O
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O- @     @- @- O
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*@**@@*/OO@*O@O@/*OO****O b p p 8 1 6 2 0 0 0 0 0 0 0 0 8": <String>["g7"],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4     O- @- @
    |  |   O-d3- O  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 -----  O ----- g1
  */
  "**OO*O**/O*@OO@O@/**@*O*@@ b p p 8 1 6 2 0 0 0 0 0 0 0 0 8": <String>["e3"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
    a4- O- @     @- @- O
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
     O ----- d1 -----  O
  */
  "**@*O*@@/O*@OO@O@/**OO*O** b p p 8 1 6 2 0 0 0 0 0 0 0 0 8": <String>["g1"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5- O- O  |  |
    a4- O-c4    e4- O- O
    |  |  c3-d3- O  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
     @ -----  @ ----- g1
  */
  "OO*O****/@OO@O@O*/@*O*@@** b p p 8 1 6 2 0 0 0 0 0 0 0 0 8": <String>["e5"],

  /*
    a7 -----  O -----  O
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O-c4     O- O-g4
    |  |   @- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 ----- d1 -----  O
  */
  "@*O*@@**/@OO@O@O*/OO*O**** b p p 8 1 6 2 0 0 0 0 0 0 0 0 8": <String>["g7"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |   O- O-e5  |  |
     O- O-c4    e4- O-g4
    |  |   O-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 -----  @ -----  @
  */
  "O****O*O/@*O@O@OO/@**@@*O* b p p 8 1 6 2 0 0 0 0 0 0 0 0 8": <String>["c5"],

  /*
     O -----  O ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O- O    e4- O-g4
    |  |  c3- @- @  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
     O ----- d1 ----- g1
  */
  "@**@@*O*/@*O@O@OO/O****O*O b p p 8 1 6 2 0 0 0 0 0 0 0 0 8": <String>["a7"],

  /*
     @ -----  @ ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5- O  |  |
    a4- O-c4    e4- O- O
    |  |  c3- O- O  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "*O*OO***/O@OO@*O@/@*O*@**@ b p p 8 1 6 2 0 0 0 0 0 0 0 0 8": <String>["e3"],

  /*
    a7 ----- d7 -----  O
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |   @- @-e5  |  |
    a4- O-c4     O- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 -----  O -----  O
  */
  "@*O*@**@/O@OO@*O@/*O*OO*** b p p 8 1 6 2 0 0 0 0 0 0 0 0 8": <String>["g1"],

  /*
    a7 -----  @ -----  @
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |   O-d5-e5  |  |
     O- O-c4    e4- O-g4
    |  |   O- O-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "****OO*O/O@O*@OO@/@@**@*O* b p p 8 1 6 2 0 0 0 0 0 0 0 0 8": <String>["c3"],

  /*
     O ----- d7 ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5- @- @  |  |
    a4- O- O    e4- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
     O -----  O ----- g1
  */
  "@@**@*O*/O@O*@OO@/****OO*O b p p 8 1 6 2 0 0 0 0 0 0 0 0 8": <String>["a1"],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- O-g4
    |  |   O-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "*****O**/O@O*@OO@/****@*** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "c4",
    "e4",
    "d5",
    "d7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
     O ----- d1 ----- g1
  */
  "****@***/O@O*@OO@/*****O** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "a4",
    "g4",
    "d7",
    "d5",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |   O-d5-e5  |  |
    a4- O-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*******O/@*O@O@OO/@******* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "c4",
    "e4",
    "d3",
    "d1",
  ],

  /*
     O ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*******/@*O@O@OO/*******O b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "a4",
    "g4",
    "d1",
    "d3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- O-g4
    |  |  c3-d3- O  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "***O****/O@OO@*O@/****@*** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "e4",
    "c4",
    "d5",
    "d7",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 -----  O
  */
  "****@***/O@OO@*O@/***O**** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "g4",
    "a4",
    "d7",
    "d5",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5- O  |  |
    a4- O-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*O******/@OO@O@O*/@******* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "e4",
    "c4",
    "d3",
    "d1",
  ],

  /*
    a7 ----- d7 -----  O
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*******/@OO@O@O*/*O****** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "g4",
    "a4",
    "d1",
    "d3",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |   O-d5-e5  |  |
     @- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*******O/O@O@O*@O/******@* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "d5",
    "d3",
    "e4",
    "g4",
  ],

  /*
     O ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- @    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******@*/O@O@O*@O/*******O b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "d7",
    "d1",
    "g4",
    "e4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5- O  |  |
    a4- O-c4    e4- @- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*O******/OO@*O@O@/**@***** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "d5",
    "d3",
    "c4",
    "a4",
  ],

  /*
    a7 ----- d7 -----  O
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     @- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@*****/OO@*O@O@/*O****** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "d7",
    "d1",
    "a4",
    "c4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- @-c4    e4- O-g4
    |  |   O-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*****O**/O@O@OO@*/******@* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "d3",
    "d5",
    "e4",
    "g4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- @    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
     O ----- d1 ----- g1
  */
  "******@*/O@O@OO@*/*****O** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "d1",
    "d7",
    "g4",
    "e4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @- @
    |  |  c3-d3- O  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "***O****/O*@OO@O@/**@***** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "d3",
    "d5",
    "c4",
    "a4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     @- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 -----  O
  */
  "**@*****/O*@OO@O@/***O**** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "d1",
    "d7",
    "a4",
    "c4",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5- @- O  |  |
    a4- O- @     @- O- O
    |  |  c3- O- @  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@O@@O*@*/O@O*@OO@/O*O***** b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>["g7"],

  /*
    a7 -----  @ -----  O
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O-c4     O- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 -----  O -----  @
  */
  "O*O*****/O@O*@OO@/@O@@O*@* b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>["e5"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- O- @  |  |
    a4- O- @     @- O- O
    |  |  c3- @- O  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "O@@O@*@*/@*O@O@OO/**O*O*** b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>["g1"],

  /*
    a7 -----  O -----  @
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O-c4     O- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 -----  @ -----  O
  */
  "**O*O***/@*O@O@OO/O@@O@*@* b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>["e3"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |   O- @-e5  |  |
     O- O- @     @- O-g4
    |  |   @- O-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@*@*O@@O/O@OO@*O@/O*****O* b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>["a7"],

  /*
     O -----  @ ----- g7
    |         |        |
    |   @ --  O --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O- O    e4- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
     @ -----  O ----- g1
  */
  "O*****O*/O@OO@*O@/@*@*O@@O b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>["c5"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |   @- O-e5  |  |
     O- O- @     @- O-g4
    |  |   O- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "O*@*@O@@/@OO@O@O*/****O*O* b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>["a1"],

  /*
     @ -----  O ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O- O    e4- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  O --  @  |
    |         |        |
     O -----  @ ----- g1
  */
  "****O*O*/@OO@O@O*/O*@*@O@@ b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>["c3"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @- O     @- O- O
    |  |   @- @- O  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@*@O@@O*/O@O@O*@O/**O*O*** b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>["g1"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4     O- O- @
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
     @ -----  @ -----  O
  */
  "**O*O***/O@O@O*@O/@*@O@@O* b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>["e3"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- O- @     O- @-g4
    |  |   O- @- @  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "@*O@@O@*/OO@*O@O@/****O*O* b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>["a1"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O- O    e4- @- O
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
     O -----  @ -----  @
  */
  "****O*O*/OO@*O@O@/@*O@@O@* b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>["c3"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |   @- @- O  |  |
    a4- @- O     @- O- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@O@*@*O@/O@O@OO@*/O*O***** b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>["g7"],

  /*
     @ -----  @ -----  O
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     O- @-c4     O- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O*O*****/O@O@OO@*/@O@*@*O@ b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>["e5"],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |   O- @- @  |  |
     O- O- @     O- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@@O*@*@O/O*@OO@O@/O*****O* b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>["a7"],

  /*
     O -----  @ -----  @
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
     @- O- O    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O*****O*/O*@OO@O@/@@O*@*@O b p p 8 1 7 2 0 0 0 0 0 0 0 0 8": <String>["c5"],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |   @- @- O  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  O ----- g1
  */
  "***O@@**/@*O@O**O/****O*** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "b4",
    "g4",
    "d5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
     @ -----  @ -----  O
  */
  "****O***/@*O@O**O/***O@@** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "b4",
    "e4",
    "d7",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |   @- @- O  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@O*****@/O@O*@O**/O******* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "b4",
    "g4",
    "d3",
  ],

  /*
     @ -----  @ -----  O
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*******/O@O*@O**/@O*****@ b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "b4",
    "e4",
    "d1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |   O- @- @  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  O ----- g1
  */
  "***@@O**/@O**O@O*/****O*** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "f4",
    "a4",
    "d5",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3- O-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
     O -----  @ -----  @
  */
  "****O***/@O**O@O*/***@@O** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "f4",
    "c4",
    "d7",
  ],

  /*
    a7 -----  O ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |   O- @- @  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@@*****O/O**O@*O@/O******* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "f4",
    "a4",
    "d3",
  ],

  /*
     O -----  @ -----  @
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- O-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O*******/O**O@*O@/@@*****O b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "f4",
    "c4",
    "d1",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  O  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
     O- O- @    e4- @-g4
    |  |   O-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*****O@@/*O@*O@O*/******O* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "d6",
    "d1",
    "e4",
  ],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O- O    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
     O ----- d1 ----- g1
  */
  "******O*/*O@*O@O*/*****O@@ b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "d6",
    "d3",
    "g4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
    a4- @-c4     @- O- O
    |  |  c3-d3- O  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*@@O****/**O@O*@O/**O***** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "d6",
    "d1",
    "c4",
  ],

  /*
    a7 ----- d7 -----  @
    |         |        |
    |   O -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4     O- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 -----  O
  */
  "**O*****/**O@O*@O/*@@O**** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "d6",
    "d3",
    "a4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |   O-d5-e5  |  |
     O- O- @    e4- @-g4
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*****@@O/O*@O**O@/******O* b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "d2",
    "d7",
    "e4",
  ],

  /*
     O ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- O- O    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 --  O  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "******O*/O*@O**O@/*****@@O b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "d2",
    "d5",
    "g4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5- O  |  |
    a4- @-c4     @- O- O
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |   O -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*O@@****/O@O**O@*/**O***** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "d2",
    "d7",
    "c4",
  ],

  /*
    a7 ----- d7 -----  O
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4     O- O- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O -- d2 -- f2  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "**O*****/O@O**O@*/*O@@**** b p p 5 4 4 5 0 0 0 0 0 0 0 0 5": <String>[
    "d2",
    "d5",
    "a4",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |   O- O- @  |  |
     @- O- O    e4- O-g4
    |  |   O-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O@***OOO/@*O*@*O*/@*****@* w p p 6 3 5 3 0 0 0 0 0 0 0 0 7": <String>["g4"],

  /*
     O -----  O -----  @
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- O- @    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
     O ----- d1 ----- g1
  */
  "@*****@*/@*O*@*O*/O@***OOO w p p 6 3 5 3 0 0 0 0 0 0 0 0 7": <String>["e4"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |   O-d5-e5  |  |
     @- O- O    e4- O-g4
    |  |   O- O- @  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "***@OOOO/@*O*@*O*/****@*@* w p p 6 3 5 3 0 0 0 0 0 0 0 0 7": <String>["g4"],

  /*
     O ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- O- @    e4- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
     O -----  O -----  @
  */
  "****@*@*/@*O*@*O*/***@OOOO w p p 6 3 5 3 0 0 0 0 0 0 0 0 7": <String>["e4"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |   @- O- O  |  |
    a4- O-c4     O- O- @
    |  |  c3-d3- O  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "OOOO***@/@*O*@*O*/@*@***** w p p 6 3 5 3 0 0 0 0 0 0 0 0 7": <String>["a4"],

  /*
     @ -----  O -----  O
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O-c4     @- O- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 -----  O
  */
  "@*@*****/@*O*@*O*/OOOO***@ w p p 6 3 5 3 0 0 0 0 0 0 0 0 7": <String>["c4"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5- O  |  |
    a4- O-c4     O- O- @
    |  |   @- O- O  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "*OOOO@**/@*O*@*O*/**@*@*** w p p 6 3 5 3 0 0 0 0 0 0 0 0 7": <String>["a4"],

  /*
    a7 ----- d7 -----  O
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     @- O- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
     @ -----  O -----  O
  */
  "**@*@***/@*O*@*O*/*OOOO@** w p p 6 3 5 3 0 0 0 0 0 0 0 0 7": <String>["c4"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |   O- O- O  |  |
    a4- @-c4     O- @- @
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "OOO@***O/O*@*O*@*/@*@***** w p p 6 3 5 3 0 0 0 0 0 0 0 0 7": <String>["d1"],

  /*
     O -----  O -----  O
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- @-c4     @- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "@*@*****/O*@*O*@*/OOO@***O w p p 6 3 5 3 0 0 0 0 0 0 0 0 7": <String>["d3"],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |   O- O- O  |  |
     @- @- O    e4- @-g4
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "OO***@OO/O*@*O*@*/@*****@* w p p 6 3 5 3 0 0 0 0 0 0 0 0 7": <String>["d1"],

  /*
     O -----  O -----  O
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- @- @    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "@*****@*/O*@*O*@*/OO***@OO w p p 6 3 5 3 0 0 0 0 0 0 0 0 7": <String>["d3"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
    a4- @-c4     O- @- @
    |  |   O- O- O  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "*@OOOO**/O*@*O*@*/**@*@*** w p p 6 3 5 3 0 0 0 0 0 0 0 0 7": <String>["d7"],

  /*
    a7 ----- d7 -----  @
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4     @- @- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
     O -----  O -----  O
  */
  "**@*@***/O*@*O*@*/*@OOOO** w p p 6 3 5 3 0 0 0 0 0 0 0 0 7": <String>["d5"],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
     @- @- O    e4- @-g4
    |  |   O- O- O  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "***OOOO@/O*@*O*@*/****@*@* w p p 6 3 5 3 0 0 0 0 0 0 0 0 7": <String>["d7"],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @- @    e4- @-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
     O -----  O -----  O
  */
  "****@*@*/O*@*O*@*/***OOOO@ w p p 6 3 5 3 0 0 0 0 0 0 0 0 7": <String>["d5"],

  /////////////////////////////////// Ben //////////////////////////////////////

  /*
    a7 ----- d7 -----  @
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- @    e4- @- O
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  O -----  O
  */
  "***@**@*/OO@@O*O@/*@OOO*** b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a7",
    "d7",
    "c5",
    "d5",
    "e5",
    "e4",
    "c3",
    "b2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O --  O  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
     @- O-c4     O- @-g4
    |  |  c3- O- O  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "*@OOO***/OO@@O*O@/***@**@* b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c5",
    "d5",
    "a7",
    "d7",
    "g7",
    "g4",
    "a1",
    "b2",
  ],

  /*
    a7 -----  O -----  O
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
    a4- O- @    e4- @- O
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "*@****@*/O@@OO@O*/OOO@**** b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a1",
    "d1",
    "c3",
    "d3",
    "e3",
    "e4",
    "c5",
    "b6",
  ],

  /*
    a7 ----- d7 -----  @
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- O- O  |  |
     @- O-c4     O- @-g4
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |   @ --  O --  O  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "OOO@****/O@@OO@O*/*@****@* b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c3",
    "d3",
    "a1",
    "d1",
    "g1",
    "g4",
    "a7",
    "b6",
  ],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     O- @-c4     @- O-g4
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
     O -----  O ----- g1
  */
  "**@**@**/O@O*O@@O/****OOO@ b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g7",
    "d7",
    "e5",
    "d5",
    "c5",
    "c4",
    "e3",
    "f2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   O --  O --  @  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
    a4- @- O    e4- O- @
    |  |   O- O-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "****OOO@/O@O*O@@O/**@**@** b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e5",
    "d5",
    "g7",
    "d7",
    "a7",
    "a4",
    "g1",
    "f2",
  ],

  /*
     O -----  O ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
     O- @-c4     @- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "**@****@/O*O@OO@@/O****@OO b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g1",
    "d1",
    "e3",
    "d3",
    "c3",
    "c4",
    "e5",
    "f6",
  ],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |   O- O-e5  |  |
    a4- @- O    e4- O- @
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |   O --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "O****@OO/O*O@OO@@/**@****@ b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e3",
    "d3",
    "g1",
    "d1",
    "a1",
    "a4",
    "g7",
    "f6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
     O- O-c4    e4- O-g4
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
     O -----  O -----  @
  */
  "@****@**/O@OO@@O*/***@OOO* b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g7",
    "g4",
    "e5",
    "e4",
    "e3",
    "d3",
    "c5",
    "b6",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |  b6 --  O --  @  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O- O    e4- O-g4
    |  |   O- O- @  |  |
    |  |      |     |  |
    |   @ --  @ --  O  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "***@OOO*/O@OO@@O*/@****@** b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e5",
    "e4",
    "g7",
    "g4",
    "g1",
    "d1",
    "a7",
    "b6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5- @-e5  |  |
    a4- O-c4    e4- O- O
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
     @ -----  O -----  O
  */
  "@**@****/O*O@@OO@/**OOO@** b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a7",
    "a4",
    "c5",
    "c4",
    "c3",
    "d3",
    "e5",
    "f6",
  ],

  /*
    a7 -----  @ ----- g7
    |         |        |
    |   @ --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     O- O-g4
    |  |   @- O- O  |  |
    |  |      |     |  |
    |   O --  @ --  @  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "**OOO@**/O*O@@OO@/@**@**** b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c5",
    "c4",
    "a7",
    "a4",
    "a1",
    "d1",
    "g7",
    "f6",
  ],

  /*
     O -----  O -----  @
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
     O- O-c4    e4- O-g4
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****@**@/@OO@O*O@/O@****OO b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "g1",
    "g4",
    "e3",
    "e4",
    "e5",
    "d5",
    "c3",
    "b2",
  ],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |   @ --  @ --  O  |
    |  |      |     |  |
    |  |   O- O- @  |  |
    a4- O- O    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O --  @  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "O@****OO/@OO@O*O@/****@**@ b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "e3",
    "e4",
    "g1",
    "g4",
    "g7",
    "d7",
    "a1",
    "b2",
  ],

  /*
     @ -----  O -----  O
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
    a4- O-c4    e4- O- O
    |  |  c3- @-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*@**@***/@@O*O@OO/OOO****@ b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "a1",
    "a4",
    "c3",
    "c4",
    "c5",
    "d5",
    "e3",
    "f2",
  ],

  /*
    a7 ----- d7 -----  @
    |         |        |
    |   O --  @ --  @  |
    |  |      |     |  |
    |  |   @- O- O  |  |
    a4- O-c4     O- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |   @ --  O -- f2  |
    |         |        |
    a1 -----  @ ----- g1
  */
  "OOO****@/@@O*O@OO/*@**@*** b p p 7 2 6 3 0 0 0 0 0 0 0 0 7": <String>[
    "c3",
    "c4",
    "a1",
    "a4",
    "a7",
    "d7",
    "g1",
    "f2",
  ],
};

Map<String, List<String>> elFiljaFenToBestMoves = <String, List<String>>{
  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/********/******** w p p 0 12 0 12 0 0 0 0 0 0 0 0 1": <String>[
    "d2",
    "b4",
    "d6",
    "f4",
    "b2",
    "b6",
    "f6",
    "f2",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- @-g4
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "***@****/O*@*O***/******** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "e4",
    "g4",
    "e5",
    "b6",
    "f6",
    "b2",
    "f2",
    "d3",
    "d5",
    "d7",
    "b4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "********/O*@*O***/***@**** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "g4",
    "e4",
    "g7",
    "b6",
    "f6",
    "b2",
    "f2",
    "d1",
    "d7",
    "d5",
    "b4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
    a4-b4-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*@******/O*@*O***/******** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "e4",
    "g4",
    "e3",
    "b2",
    "f2",
    "b6",
    "f6",
    "d5",
    "d3",
    "d1",
    "b4",
  ],

  /*
    a7 ----- d7 -----  @
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*@*O***/*@****** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "g4",
    "e4",
    "g1",
    "b2",
    "f2",
    "b6",
    "f6",
    "d7",
    "d1",
    "d3",
    "b4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4-f4-g4
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*****@**/O***O*@*/******** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "c4",
    "a4",
    "c5",
    "f6",
    "b6",
    "f2",
    "b2",
    "d3",
    "d5",
    "d7",
    "f4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "********/O***O*@*/*****@** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "a4",
    "c4",
    "a7",
    "f6",
    "b6",
    "f2",
    "b2",
    "d1",
    "d7",
    "d5",
    "f4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
    a4- @-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*******@/O***O*@*/******** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "c4",
    "a4",
    "c3",
    "f2",
    "b2",
    "f6",
    "b6",
    "d5",
    "d3",
    "d1",
    "f4",
  ],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O***O*@*/*******@ w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "a4",
    "c4",
    "a1",
    "f2",
    "b2",
    "f6",
    "b6",
    "d7",
    "d1",
    "d3",
    "f4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- O-g4
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*****@**/**O*@*O*/******** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "d3",
    "d1",
    "e3",
    "f6",
    "f2",
    "b6",
    "b2",
    "c4",
    "e4",
    "g4",
    "d6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "********/**O*@*O*/*****@** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "d1",
    "d3",
    "g1",
    "f6",
    "f2",
    "b6",
    "b2",
    "a4",
    "g4",
    "e4",
    "d6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- O-g4
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "***@****/**O*@*O*/******** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "d3",
    "d1",
    "c3",
    "b6",
    "b2",
    "f6",
    "f2",
    "e4",
    "c4",
    "a4",
    "d6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "********/**O*@*O*/***@**** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "d1",
    "d3",
    "a1",
    "b6",
    "b2",
    "f6",
    "f2",
    "g4",
    "a4",
    "c4",
    "d6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
    a4- O-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*******@/@*O***O*/******** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "d5",
    "d7",
    "e5",
    "f2",
    "f6",
    "b2",
    "b6",
    "c4",
    "e4",
    "g4",
    "d2",
  ],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*O***O*/*******@ w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "d7",
    "d5",
    "g7",
    "f2",
    "f6",
    "b2",
    "b6",
    "a4",
    "g4",
    "e4",
    "d2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
    a4- O-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*@******/@*O***O*/******** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "d5",
    "d7",
    "c5",
    "b2",
    "b6",
    "f2",
    "f6",
    "e4",
    "c4",
    "a4",
    "d2",
  ],

  /*
    a7 ----- d7 -----  @
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*O***O*/*@****** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "d7",
    "d5",
    "a7",
    "b2",
    "b6",
    "f2",
    "f6",
    "g4",
    "a4",
    "c4",
    "d2",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4     @- @-g4
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "**@@****/O*@*O*O*/******** w p p 3 9 3 9 0 0 0 0 0 0 0 0 4": <String>[
    "b2",
    "b6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "********/O*@*O*O*/**@@**** w p p 3 9 3 9 0 0 0 0 0 0 0 0 4": <String>[
    "b2",
    "b6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
    a4- O-c4     @- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*@@*****/O*@*O*O*/******** w p p 3 9 3 9 0 0 0 0 0 0 0 0 4": <String>[
    "b6",
    "b2",
  ],

  /*
    a7 ----- d7 -----  @
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @- @
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*@*O*O*/*@@***** w p p 3 9 3 9 0 0 0 0 0 0 0 0 4": <String>[
    "b6",
    "b2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @- @    e4- O-g4
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*****@@*/O*O*O*@*/******** w p p 3 9 3 9 0 0 0 0 0 0 0 0 4": <String>[
    "f2",
    "f6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "********/O*O*O*@*/*****@@* w p p 3 9 3 9 0 0 0 0 0 0 0 0 4": <String>[
    "f2",
    "f6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
    a4- @- @    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "******@@/O*O*O*@*/******** w p p 3 9 3 9 0 0 0 0 0 0 0 0 4": <String>[
    "f6",
    "f2",
  ],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
     @- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*O*O*@*/******@@ w p p 3 9 3 9 0 0 0 0 0 0 0 0 4": <String>[
    "f6",
    "f2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- O-g4
    |  |   @- @-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "****@@**/O*O*@*O*/******** w p p 3 9 3 9 0 0 0 0 0 0 0 0 4": <String>[
    "b6",
    "f6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
     @ -----  @ ----- g1
  */
  "********/O*O*@*O*/****@@** w p p 3 9 3 9 0 0 0 0 0 0 0 0 4": <String>[
    "b6",
    "f6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- O-g4
    |  |  c3- @- @  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "***@@***/O*O*@*O*/******** w p p 3 9 3 9 0 0 0 0 0 0 0 0 4": <String>[
    "f6",
    "b6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 -----  @ -----  @
  */
  "********/O*O*@*O*/***@@*** w p p 3 9 3 9 0 0 0 0 0 0 0 0 4": <String>[
    "f6",
    "b6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |   @- @-e5  |  |
    a4- O-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@******@/@*O*O*O*/******** w p p 3 9 3 9 0 0 0 0 0 0 0 0 4": <String>[
    "b2",
    "f2",
  ],

  /*
     @ -----  @ ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*O*O*O*/@******@ w p p 3 9 3 9 0 0 0 0 0 0 0 0 4": <String>[
    "b2",
    "f2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5- @- @  |  |
    a4- O-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "@@******/@*O*O*O*/******** w p p 3 9 3 9 0 0 0 0 0 0 0 0 4": <String>[
    "f2",
    "b2",
  ],

  /*
    a7 -----  @ -----  @
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*O*O*O*/@@****** w p p 3 9 3 9 0 0 0 0 0 0 0 0 4": <String>[
    "f2",
    "b2",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*@******/@*O*O***/******** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "d1",
    "d3",
    "e4",
    "g4",
    "c5",
    "d5",
    "d7",
    "b2",
    "f2",
    "f6",
    "b4",
  ],

  /*
    a7 ----- d7 -----  @
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*O*O***/*@****** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "d3",
    "d1",
    "g4",
    "e4",
    "a7",
    "d7",
    "d5",
    "b2",
    "f2",
    "f6",
    "b4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "***@****/O*O*@***/******** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "d7",
    "d5",
    "e4",
    "g4",
    "c3",
    "d3",
    "d1",
    "b6",
    "f6",
    "f2",
    "b4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "********/O*O*@***/***@**** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "d5",
    "d7",
    "g4",
    "e4",
    "a1",
    "d1",
    "d3",
    "b6",
    "f6",
    "f2",
    "b4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*******@/@***O*O*/******** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "d1",
    "d3",
    "c4",
    "a4",
    "e5",
    "d5",
    "d7",
    "f2",
    "b2",
    "b6",
    "f4",
  ],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@***O*O*/*******@ w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "d3",
    "d1",
    "a4",
    "c4",
    "g7",
    "d7",
    "d5",
    "f2",
    "b2",
    "b6",
    "f4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*****@**/O***@*O*/******** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "d7",
    "d5",
    "c4",
    "a4",
    "e3",
    "d3",
    "d1",
    "f6",
    "b6",
    "b2",
    "f4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "********/O***@*O*/*****@** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "d5",
    "d7",
    "a4",
    "c4",
    "g1",
    "d1",
    "d3",
    "f6",
    "b6",
    "b2",
    "f4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "***@****/**@*O*O*/******** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "a4",
    "c4",
    "d3",
    "d1",
    "e5",
    "e4",
    "g4",
    "b6",
    "b2",
    "f2",
    "d6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "********/**@*O*O*/***@**** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "c4",
    "a4",
    "d1",
    "d3",
    "g7",
    "g4",
    "e4",
    "b6",
    "b2",
    "f2",
    "d6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*****@**/**O*O*@*/******** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "g4",
    "e4",
    "d3",
    "d1",
    "c5",
    "c4",
    "a4",
    "f6",
    "f2",
    "b2",
    "d6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "********/**O*O*@*/*****@** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "e4",
    "g4",
    "d1",
    "d3",
    "a7",
    "a4",
    "c4",
    "f6",
    "f2",
    "b2",
    "d6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*@******/O*@***O*/******** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "a4",
    "c4",
    "d5",
    "d7",
    "e3",
    "e4",
    "g4",
    "b2",
    "b6",
    "f6",
    "d2",
  ],

  /*
    a7 ----- d7 -----  @
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*@***O*/*@****** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "c4",
    "a4",
    "d7",
    "d5",
    "g1",
    "g4",
    "e4",
    "b2",
    "b6",
    "f6",
    "d2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*******@/O*O***@*/******** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "g4",
    "e4",
    "d5",
    "d7",
    "c3",
    "c4",
    "a4",
    "f2",
    "f6",
    "b6",
    "d2",
  ],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/O*O***@*/*******@ w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "e4",
    "g4",
    "d7",
    "d5",
    "a1",
    "a4",
    "c4",
    "f2",
    "f6",
    "b6",
    "d2",
  ],

  //////////////////////////////////////////////////////////////////////////////

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*******@/@*O*O***/******** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "d1",
    "b2",
    "f2",
    "d3",
    "e4",
    "g4",
    "d5",
    "e5",
    "d7",
    "b4",
  ],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@*O*O***/*******@ w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "d3",
    "b2",
    "f2",
    "d1",
    "g4",
    "e4",
    "d7",
    "g7",
    "d5",
    "b4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*****@**/O*O*@***/******** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "d7",
    "b6",
    "f6",
    "d5",
    "e4",
    "g4",
    "d3",
    "e3",
    "d1",
    "b4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4-b4-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "********/O*O*@***/*****@** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "d5",
    "b6",
    "f6",
    "d7",
    "g4",
    "e4",
    "d1",
    "g1",
    "d3",
    "b4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*@******/@***O*O*/******** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "d1",
    "f2",
    "b2",
    "d3",
    "c4",
    "a4",
    "d5",
    "c5",
    "d7",
    "f4",
  ],

  /*
    a7 ----- d7 -----  @
    |         |        |
    |  b6 --  @ -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/@***O*O*/*@****** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "d3",
    "f2",
    "b2",
    "d1",
    "a4",
    "c4",
    "d7",
    "a7",
    "d5",
    "f4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "***@****/O***@*O*/******** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "d7",
    "f6",
    "b6",
    "d5",
    "c4",
    "a4",
    "d3",
    "c3",
    "d1",
    "f4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4-f4-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  @ -- f2  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "********/O***@*O*/***@**** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "d5",
    "f6",
    "b6",
    "d7",
    "a4",
    "c4",
    "d1",
    "a1",
    "d3",
    "f4",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5- @  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*@******/**@*O*O*/******** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "a4",
    "b6",
    "b2",
    "c4",
    "d3",
    "d1",
    "e4",
    "e3",
    "g4",
    "d6",
  ],

  /*
    a7 ----- d7 -----  @
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/**@*O*O*/*@****** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "c4",
    "b6",
    "b2",
    "a4",
    "d1",
    "d3",
    "g4",
    "g1",
    "e4",
    "d6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |   @-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*******@/**O*O*@*/******** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "g4",
    "f6",
    "f2",
    "e4",
    "d3",
    "d1",
    "c4",
    "c3",
    "a4",
    "d6",
  ],

  /*
     @ ----- d7 ----- g7
    |         |        |
    |  b6 -- d6 -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 --  O -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "********/**O*O*@*/*******@ w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "e4",
    "f6",
    "f2",
    "g4",
    "d1",
    "d3",
    "a4",
    "a1",
    "c4",
    "d6",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3- @  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "***@****/O*@***O*/******** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "a4",
    "b2",
    "b6",
    "c4",
    "d5",
    "d7",
    "e4",
    "e5",
    "g4",
    "d2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- O-c4    e4- @-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 -----  @
  */
  "********/O*@***O*/***@**** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "c4",
    "b2",
    "b6",
    "a4",
    "d7",
    "d5",
    "g4",
    "g7",
    "e4",
    "d2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |   @-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
    a1 ----- d1 ----- g1
  */
  "*****@**/O*O***@*/******** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "g4",
    "f2",
    "f6",
    "e4",
    "d5",
    "d7",
    "c4",
    "c5",
    "a4",
    "d2",
  ],

  /*
    a7 ----- d7 ----- g7
    |         |        |
    |  b6 --  O -- f6  |
    |  |      |     |  |
    |  |  c5-d5-e5  |  |
    a4- @-c4    e4- O-g4
    |  |  c3-d3-e3  |  |
    |  |      |     |  |
    |  b2 -- d2 -- f2  |
    |         |        |
     @ ----- d1 ----- g1
  */
  "********/O*O***@*/*****@** w p p 2 10 2 10 0 0 0 0 0 0 0 0 3": <String>[
    "e4",
    "f2",
    "f6",
    "g4",
    "d7",
    "d5",
    "a4",
    "a7",
    "c4",
    "d2",
  ],
};
