// SPDX-License-Identifier: GPL-3.0-or-later
// Copyright (C) 2019-2025 The Sanmill developers (see AUTHORS file)

// custom_drawer.dart

/// Although marked as a library this package is tightly integrated into the app

library;

import 'package:animated_text_kit/animated_text_kit.dart';
import 'package:extended_sliver/extended_sliver.dart';
import 'package:flutter/material.dart';
import 'package:marquee/marquee.dart';

import '../generated/intl/l10n.dart';
import '../shared/config/constants.dart';
import '../shared/database/database.dart';
import '../shared/themes/app_theme.dart';
import '../shared/utils/helpers/text_helpers/text_size_helper.dart';

part 'widgets/custom_drawer_controller.dart';
part 'widgets/custom_drawer_header.dart';
part 'widgets/custom_drawer_icon.dart';
part 'widgets/custom_drawer_item.dart';
part 'widgets/custom_drawer_value.dart';
part 'widgets/custom_drawer_widget.dart';
