// coverage:ignore-file
// GENERATED CODE - DO NOT MODIFY BY HAND
// ignore_for_file: type=lint
// ignore_for_file: invalid_annotation_target
part of open_a_i_schema;

// ==========================================
// CLASS: CreateImageRequest
// ==========================================

/// Request object for the Create image endpoint.
@freezed
abstract class CreateImageRequest with _$CreateImageRequest {
  const CreateImageRequest._();

  /// Factory constructor for CreateImageRequest
  const factory CreateImageRequest({
    /// A text description of the desired image(s). The maximum length is 1000 characters for `dall-e-2` and 4000 characters for `dall-e-3`.
    required String prompt,

    /// The model to use for image generation. One of `dall-e-2`, `dall-e-3`, or `gpt-image-1`. Defaults to `dall-e-2` unless a parameter specific to `gpt-image-1` is used.
    @_CreateImageRequestModelConverter()
    @JsonKey(includeIfNull: false)
    CreateImageRequestModel? model,

    /// The number of images to generate. Must be between 1 and 10. For `dall-e-3`, only `n=1` is supported.
    @JsonKey(includeIfNull: false) int? n,

    /// The quality of the image that will be generated.
    ///
    /// - `auto` (default value) will automatically select the best quality for the given model.
    /// - `high`, `medium` and `low` are supported for `gpt-image-1`.
    /// - `hd` and `standard` are supported for `dall-e-3`.
    /// - `standard` is the only option for `dall-e-2`.
    @JsonKey(
      includeIfNull: false,
      unknownEnumValue: JsonKey.nullForUndefinedEnumValue,
    )
    ImageQuality? quality,

    /// The format in which generated images with `dall-e-2` and `dall-e-3` are returned. Must be one of `url` or `b64_json`. URLs are only valid for 60 minutes after the image has been generated. This parameter isn't supported for `gpt-image-1` which will always return base64-encoded images.
    @JsonKey(
      name: 'response_format',
      includeIfNull: false,
      unknownEnumValue: JsonKey.nullForUndefinedEnumValue,
    )
    ImageResponseFormat? responseFormat,

    /// The format in which the generated images are returned. This parameter is only supported for `gpt-image-1`. Must be one of `png`, `jpeg`, or `webp`.
    @JsonKey(
      name: 'output_format',
      includeIfNull: false,
      unknownEnumValue: JsonKey.nullForUndefinedEnumValue,
    )
    ImageOutputFormat? outputFormat,

    /// The compression level (0-100%) for the generated images. This parameter is only supported for `gpt-image-1` with the `webp` or `jpeg` output formats, and defaults to 100.
    @JsonKey(name: 'output_compression', includeIfNull: false)
    int? outputCompression,

    /// The size of the generated images. Must be one of `1024x1024`, `1536x1024` (landscape), `1024x1536` (portrait), or `auto` (default value) for `gpt-image-1`, one of `256x256`, `512x512`, or `1024x1024` for `dall-e-2`, and one of `1024x1024`, `1792x1024`, or `1024x1792` for `dall-e-3`.
    @JsonKey(
      includeIfNull: false,
      unknownEnumValue: JsonKey.nullForUndefinedEnumValue,
    )
    ImageSize? size,

    /// Control the content-moderation level for images generated by `gpt-image-1`. Must be either `low` for less restrictive filtering or `auto` (default value).
    @JsonKey(
      includeIfNull: false,
      unknownEnumValue: JsonKey.nullForUndefinedEnumValue,
    )
    ImageModeration? moderation,

    /// Allows to set transparency for the background of the generated image(s).
    /// This parameter is only supported for `gpt-image-1`. Must be one of
    /// `transparent`, `opaque` or `auto` (default value). When `auto` is used, the
    /// model will automatically determine the best background for the image.
    ///
    /// If `transparent`, the output format needs to support transparency, so it
    /// should be set to either `png` (default value) or `webp`.
    @JsonKey(
      includeIfNull: false,
      unknownEnumValue: JsonKey.nullForUndefinedEnumValue,
    )
    ImageBackground? background,

    /// The style of the generated images. This parameter is only supported for `dall-e-3`. Must be one of `vivid` or `natural`. Vivid causes the model to lean towards generating hyper-real and dramatic images. Natural causes the model to produce more natural, less hyper-real looking images.
    @JsonKey(
      includeIfNull: false,
      unknownEnumValue: JsonKey.nullForUndefinedEnumValue,
    )
    ImageStyle? style,

    /// A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](https://platform.openai.com/docs/guides/safety-best-practices#end-user-ids).
    @JsonKey(includeIfNull: false) String? user,
  }) = _CreateImageRequest;

  /// Object construction from a JSON representation
  factory CreateImageRequest.fromJson(Map<String, dynamic> json) =>
      _$CreateImageRequestFromJson(json);

  /// List of all property names of schema
  static const List<String> propertyNames = [
    'prompt',
    'model',
    'n',
    'quality',
    'response_format',
    'output_format',
    'output_compression',
    'size',
    'moderation',
    'background',
    'style',
    'user'
  ];

  /// Validation constants
  static const nMinValue = 1;
  static const nMaxValue = 10;

  /// Perform validations on the schema property values
  String? validateSchema() {
    if (n != null && n! < nMinValue) {
      return "The value of 'n' cannot be < $nMinValue";
    }
    if (n != null && n! > nMaxValue) {
      return "The value of 'n' cannot be > $nMaxValue";
    }
    return null;
  }

  /// Map representation of object (not serialized)
  Map<String, dynamic> toMap() {
    return {
      'prompt': prompt,
      'model': model,
      'n': n,
      'quality': quality,
      'response_format': responseFormat,
      'output_format': outputFormat,
      'output_compression': outputCompression,
      'size': size,
      'moderation': moderation,
      'background': background,
      'style': style,
      'user': user,
    };
  }
}

// ==========================================
// ENUM: ImageModels
// ==========================================

/// Available models for image generation. Mind that the list may not be exhaustive nor up-to-date.
enum ImageModels {
  @JsonValue('dall-e-2')
  dallE2,
  @JsonValue('dall-e-3')
  dallE3,
  @JsonValue('gpt-image-1')
  gptImage1,
}

// ==========================================
// CLASS: CreateImageRequestModel
// ==========================================

/// The model to use for image generation. One of `dall-e-2`, `dall-e-3`, or `gpt-image-1`. Defaults to `dall-e-2` unless a parameter specific to `gpt-image-1` is used.
@freezed
sealed class CreateImageRequestModel with _$CreateImageRequestModel {
  const CreateImageRequestModel._();

  /// Available models for image generation. Mind that the list may not be exhaustive nor up-to-date.
  const factory CreateImageRequestModel.model(
    ImageModels value,
  ) = CreateImageRequestModelEnumeration;

  /// The ID of the model to use for this request.
  const factory CreateImageRequestModel.modelId(
    String value,
  ) = CreateImageRequestModelString;

  /// Object construction from a JSON representation
  factory CreateImageRequestModel.fromJson(Map<String, dynamic> json) =>
      _$CreateImageRequestModelFromJson(json);
}

/// Custom JSON converter for [CreateImageRequestModel]
class _CreateImageRequestModelConverter
    implements JsonConverter<CreateImageRequestModel?, Object?> {
  const _CreateImageRequestModelConverter();

  @override
  CreateImageRequestModel? fromJson(Object? data) {
    if (data == null) {
      return null;
    }
    if (data is String && _$ImageModelsEnumMap.values.contains(data)) {
      return CreateImageRequestModelEnumeration(
        _$ImageModelsEnumMap.keys.elementAt(
          _$ImageModelsEnumMap.values.toList().indexOf(data),
        ),
      );
    }
    if (data is String) {
      return CreateImageRequestModelString(data);
    }
    throw Exception(
      'Unexpected value for CreateImageRequestModel: $data',
    );
  }

  @override
  Object? toJson(CreateImageRequestModel? data) {
    return switch (data) {
      CreateImageRequestModelEnumeration(value: final v) =>
        _$ImageModelsEnumMap[v]!,
      CreateImageRequestModelString(value: final v) => v,
      null => null,
    };
  }
}

// ==========================================
// ENUM: ImageQuality
// ==========================================

/// The quality of the image that will be generated.
///
/// - `auto` (default value) will automatically select the best quality for the given model.
/// - `high`, `medium` and `low` are supported for `gpt-image-1`.
/// - `hd` and `standard` are supported for `dall-e-3`.
/// - `standard` is the only option for `dall-e-2`.
enum ImageQuality {
  @JsonValue('standard')
  standard,
  @JsonValue('hd')
  hd,
  @JsonValue('low')
  low,
  @JsonValue('medium')
  medium,
  @JsonValue('high')
  high,
  @JsonValue('auto')
  auto,
}

// ==========================================
// ENUM: ImageResponseFormat
// ==========================================

/// The format in which generated images with `dall-e-2` and `dall-e-3` are returned. Must be one of `url` or `b64_json`. URLs are only valid for 60 minutes after the image has been generated. This parameter isn't supported for `gpt-image-1` which will always return base64-encoded images.
enum ImageResponseFormat {
  @JsonValue('url')
  url,
  @JsonValue('b64_json')
  b64Json,
}

// ==========================================
// ENUM: ImageOutputFormat
// ==========================================

/// The format in which the generated images are returned. This parameter is only supported for `gpt-image-1`. Must be one of `png`, `jpeg`, or `webp`.
enum ImageOutputFormat {
  @JsonValue('png')
  png,
  @JsonValue('jpeg')
  jpeg,
  @JsonValue('webp')
  webp,
}

// ==========================================
// ENUM: ImageSize
// ==========================================

/// The size of the generated images. Must be one of `1024x1024`, `1536x1024` (landscape), `1024x1536` (portrait), or `auto` (default value) for `gpt-image-1`, one of `256x256`, `512x512`, or `1024x1024` for `dall-e-2`, and one of `1024x1024`, `1792x1024`, or `1024x1792` for `dall-e-3`.
enum ImageSize {
  @JsonValue('auto')
  auto,
  @JsonValue('1024x1024')
  v1024x1024,
  @JsonValue('1536x1024')
  v1536x1024,
  @JsonValue('1024x1536')
  v1024x1536,
  @JsonValue('256x256')
  v256x256,
  @JsonValue('512x512')
  v512x512,
  @JsonValue('1792x1024')
  v1792x1024,
  @JsonValue('1024x1792')
  v1024x1792,
}

// ==========================================
// ENUM: ImageModeration
// ==========================================

/// Control the content-moderation level for images generated by `gpt-image-1`. Must be either `low` for less restrictive filtering or `auto` (default value).
enum ImageModeration {
  @JsonValue('low')
  low,
  @JsonValue('auto')
  auto,
}

// ==========================================
// ENUM: ImageBackground
// ==========================================

/// Allows to set transparency for the background of the generated image(s).
/// This parameter is only supported for `gpt-image-1`. Must be one of
/// `transparent`, `opaque` or `auto` (default value). When `auto` is used, the
/// model will automatically determine the best background for the image.
///
/// If `transparent`, the output format needs to support transparency, so it
/// should be set to either `png` (default value) or `webp`.
enum ImageBackground {
  @JsonValue('transparent')
  transparent,
  @JsonValue('opaque')
  opaque,
  @JsonValue('auto')
  auto,
}

// ==========================================
// ENUM: ImageStyle
// ==========================================

/// The style of the generated images. This parameter is only supported for `dall-e-3`. Must be one of `vivid` or `natural`. Vivid causes the model to lean towards generating hyper-real and dramatic images. Natural causes the model to produce more natural, less hyper-real looking images.
enum ImageStyle {
  @JsonValue('vivid')
  vivid,
  @JsonValue('natural')
  natural,
}
