// coverage:ignore-file
// GENERATED CODE - DO NOT MODIFY BY HAND
// ignore_for_file: type=lint
// ignore_for_file: invalid_annotation_target
part of open_a_i_schema;

// ==========================================
// CLASS: CreateAssistantRequest
// ==========================================

/// Request object for the Create assistant endpoint.
@freezed
abstract class CreateAssistantRequest with _$CreateAssistantRequest {
  const CreateAssistantRequest._();

  /// Factory constructor for CreateAssistantRequest
  const factory CreateAssistantRequest({
    /// ID of the model to use. You can use the [List models](https://platform.openai.com/docs/api-reference/models/list)
    /// API to see all of your available models, or see our [Model overview](https://platform.openai.com/docs/models) for
    /// descriptions of them.
    @_AssistantModelConverter() required AssistantModel model,

    /// The name of the assistant. The maximum length is 256 characters.
    @JsonKey(includeIfNull: false) String? name,

    /// The description of the assistant. The maximum length is 512 characters.
    @JsonKey(includeIfNull: false) String? description,

    /// The system instructions that the assistant uses. The maximum length is 256,000 characters.
    @JsonKey(includeIfNull: false) String? instructions,

    /// A list of tool enabled on the assistant. There can be a maximum of 128 tools per assistant. Tools can be of
    /// types `code_interpreter`, `file_search`, or `function`.
    @Default([]) List<AssistantTools> tools,

    /// A set of resources that are made available to the assistant's tools in this thread. The resources are specific
    /// to the type of tool. For example, the `code_interpreter` tool requires a list of file IDs, while the
    /// `file_search` tool requires a list of vector store IDs.
    @JsonKey(name: 'tool_resources', includeIfNull: false)
    ToolResources? toolResources,

    /// Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional
    /// information about the object in a structured format. Keys can be a maximum of 64 characters long and values
    /// can be a maximum of 512 characters long.
    @JsonKey(includeIfNull: false) Map<String, dynamic>? metadata,

    /// What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random,
    /// while lower values like 0.2 will make it more focused and deterministic.
    @JsonKey(includeIfNull: false) @Default(1.0) double? temperature,

    /// An alternative to sampling with temperature, called nucleus sampling, where the model considers the results
    /// of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability
    /// mass are considered.
    ///
    /// We generally recommend altering this or temperature but not both.
    @JsonKey(name: 'top_p', includeIfNull: false) @Default(1.0) double? topP,

    /// Specifies the format that the model must output. Compatible with
    /// [GPT-4o](https://platform.openai.com/docs/models#gpt-4o),
    /// [GPT-4 Turbo](https://platform.openai.com/docs/models#gpt-4-turbo-and-gpt-4), and all GPT-3.5 Turbo models
    /// since `gpt-3.5-turbo-1106`.
    ///
    /// Setting to `{ "type": "json_schema", "json_schema": {...} }` enables Structured Outputs which ensures
    /// the model will match your supplied JSON schema. Learn more in the
    /// [Structured Outputs guide](https://platform.openai.com/docs/guides/structured-outputs).
    ///
    /// Setting to `{ "type": "json_object" }` enables JSON mode, which ensures the message the model generates
    /// is valid JSON.
    ///
    /// **Important:** when using JSON mode, you **must** also instruct the model to produce JSON yourself via a
    /// system or user message. Without this, the model may generate an unending stream of whitespace until the
    /// generation reaches the token limit, resulting in a long-running and seemingly "stuck" request. Also note
    /// that the message content may be partially cut off if `finish_reason="length"`, which indicates the
    /// generation exceeded `max_tokens` or the conversation exceeded the max context length.
    @_CreateAssistantRequestResponseFormatConverter()
    @JsonKey(name: 'response_format', includeIfNull: false)
    CreateAssistantRequestResponseFormat? responseFormat,
  }) = _CreateAssistantRequest;

  /// Object construction from a JSON representation
  factory CreateAssistantRequest.fromJson(Map<String, dynamic> json) =>
      _$CreateAssistantRequestFromJson(json);

  /// List of all property names of schema
  static const List<String> propertyNames = [
    'model',
    'name',
    'description',
    'instructions',
    'tools',
    'tool_resources',
    'metadata',
    'temperature',
    'top_p',
    'response_format'
  ];

  /// Validation constants
  static const nameMaxLengthValue = 256;
  static const descriptionMaxLengthValue = 512;
  static const instructionsMaxLengthValue = 256000;
  static const temperatureDefaultValue = 1.0;
  static const temperatureMinValue = 0.0;
  static const temperatureMaxValue = 2.0;
  static const topPDefaultValue = 1.0;
  static const topPMinValue = 0.0;
  static const topPMaxValue = 1.0;

  /// Perform validations on the schema property values
  String? validateSchema() {
    if (name != null && name!.length > nameMaxLengthValue) {
      return "The length of 'name' cannot be > $nameMaxLengthValue characters";
    }
    if (description != null &&
        description!.length > descriptionMaxLengthValue) {
      return "The length of 'description' cannot be > $descriptionMaxLengthValue characters";
    }
    if (instructions != null &&
        instructions!.length > instructionsMaxLengthValue) {
      return "The length of 'instructions' cannot be > $instructionsMaxLengthValue characters";
    }
    if (temperature != null && temperature! < temperatureMinValue) {
      return "The value of 'temperature' cannot be < $temperatureMinValue";
    }
    if (temperature != null && temperature! > temperatureMaxValue) {
      return "The value of 'temperature' cannot be > $temperatureMaxValue";
    }
    if (topP != null && topP! < topPMinValue) {
      return "The value of 'topP' cannot be < $topPMinValue";
    }
    if (topP != null && topP! > topPMaxValue) {
      return "The value of 'topP' cannot be > $topPMaxValue";
    }
    return null;
  }

  /// Map representation of object (not serialized)
  Map<String, dynamic> toMap() {
    return {
      'model': model,
      'name': name,
      'description': description,
      'instructions': instructions,
      'tools': tools,
      'tool_resources': toolResources,
      'metadata': metadata,
      'temperature': temperature,
      'top_p': topP,
      'response_format': responseFormat,
    };
  }
}

// ==========================================
// ENUM: AssistantModels
// ==========================================

/// Available assistant models. Mind that the list may not be exhaustive nor up-to-date.
enum AssistantModels {
  @JsonValue('gpt-5')
  gpt5,
  @JsonValue('gpt-5-mini')
  gpt5Mini,
  @JsonValue('gpt-5-nano')
  gpt5Nano,
  @JsonValue('gpt-5-2025-08-07')
  gpt520250807,
  @JsonValue('gpt-5-mini-2025-08-07')
  gpt5Mini20250807,
  @JsonValue('gpt-5-nano-2025-08-07')
  gpt5Nano20250807,
  @JsonValue('gpt-5-chat-latest')
  gpt5ChatLatest,
  @JsonValue('gpt-4.1')
  gpt41,
  @JsonValue('gpt-4.1-mini')
  gpt41Mini,
  @JsonValue('gpt-4.1-nano')
  gpt41Nano,
  @JsonValue('gpt-4.1-2025-04-14')
  gpt4120250414,
  @JsonValue('gpt-4.1-mini-2025-04-14')
  gpt41Mini20250414,
  @JsonValue('gpt-4.1-nano-2025-04-14')
  gpt41Nano20250414,
  @JsonValue('o4-mini')
  o4Mini,
  @JsonValue('o4-mini-2025-04-16')
  o4Mini20250416,
  @JsonValue('o3')
  o3,
  @JsonValue('o3-2025-04-16')
  o320250416,
  @JsonValue('o3-mini')
  o3Mini,
  @JsonValue('o3-mini-2025-01-31')
  o3Mini20250131,
  @JsonValue('o1')
  o1,
  @JsonValue('o1-2024-12-17')
  o120241217,
  @JsonValue('o1-preview')
  o1Preview,
  @JsonValue('o1-preview-2024-09-12')
  o1Preview20240912,
  @JsonValue('o1-mini')
  o1Mini,
  @JsonValue('o1-mini-2024-09-12')
  o1Mini20240912,
  @JsonValue('gpt-4o')
  gpt4o,
  @JsonValue('gpt-4o-2024-11-20')
  gpt4o20241120,
  @JsonValue('gpt-4o-2024-08-06')
  gpt4o20240806,
  @JsonValue('gpt-4o-2024-05-13')
  gpt4o20240513,
  @JsonValue('gpt-4o-audio-preview')
  gpt4oAudioPreview,
  @JsonValue('gpt-4o-audio-preview-2024-10-01')
  gpt4oAudioPreview20241001,
  @JsonValue('gpt-4o-audio-preview-2024-12-17')
  gpt4oAudioPreview20241217,
  @JsonValue('gpt-4o-audio-preview-2025-06-03')
  gpt4oAudioPreview20250603,
  @JsonValue('gpt-4o-mini-audio-preview')
  gpt4oMiniAudioPreview,
  @JsonValue('gpt-4o-mini-audio-preview-2024-12-17')
  gpt4oMiniAudioPreview20241217,
  @JsonValue('gpt-4o-search-preview')
  gpt4oSearchPreview,
  @JsonValue('gpt-4o-mini-search-preview')
  gpt4oMiniSearchPreview,
  @JsonValue('gpt-4o-search-preview-2025-03-11')
  gpt4oSearchPreview20250311,
  @JsonValue('gpt-4o-mini-search-preview-2025-03-11')
  gpt4oMiniSearchPreview20250311,
  @JsonValue('chatgpt-4o-latest')
  chatgpt4oLatest,
  @JsonValue('codex-mini-latest')
  codexMiniLatest,
  @JsonValue('gpt-4o-mini')
  gpt4oMini,
  @JsonValue('gpt-4o-mini-2024-07-18')
  gpt4oMini20240718,
  @JsonValue('gpt-4.5-preview')
  gpt45Preview,
  @JsonValue('gpt-4.5-preview-2025-02-27')
  gpt45Preview20250227,
  @JsonValue('gpt-4-turbo')
  gpt4Turbo,
  @JsonValue('gpt-4-turbo-2024-04-09')
  gpt4Turbo20240409,
  @JsonValue('gpt-4-0125-preview')
  gpt40125Preview,
  @JsonValue('gpt-4-turbo-preview')
  gpt4TurboPreview,
  @JsonValue('gpt-4-1106-preview')
  gpt41106Preview,
  @JsonValue('gpt-4-vision-preview')
  gpt4VisionPreview,
  @JsonValue('gpt-4')
  gpt4,
  @JsonValue('gpt-4-0314')
  gpt40314,
  @JsonValue('gpt-4-0613')
  gpt40613,
  @JsonValue('gpt-4-32k')
  gpt432k,
  @JsonValue('gpt-4-32k-0314')
  gpt432k0314,
  @JsonValue('gpt-4-32k-0613')
  gpt432k0613,
  @JsonValue('gpt-3.5-turbo')
  gpt35Turbo,
  @JsonValue('gpt-3.5-turbo-16k')
  gpt35Turbo16k,
  @JsonValue('gpt-3.5-turbo-0301')
  gpt35Turbo0301,
  @JsonValue('gpt-3.5-turbo-0613')
  gpt35Turbo0613,
  @JsonValue('gpt-3.5-turbo-1106')
  gpt35Turbo1106,
  @JsonValue('gpt-3.5-turbo-0125')
  gpt35Turbo0125,
  @JsonValue('gpt-3.5-turbo-16k-0613')
  gpt35Turbo16k0613,
}

// ==========================================
// CLASS: AssistantModel
// ==========================================

/// ID of the model to use. You can use the [List models](https://platform.openai.com/docs/api-reference/models/list)
/// API to see all of your available models, or see our [Model overview](https://platform.openai.com/docs/models) for
/// descriptions of them.
@freezed
sealed class AssistantModel with _$AssistantModel {
  const AssistantModel._();

  /// Available assistant models. Mind that the list may not be exhaustive nor up-to-date.
  const factory AssistantModel.model(
    AssistantModels value,
  ) = AssistantModelEnumeration;

  /// The ID of the model to use.
  const factory AssistantModel.modelId(
    String value,
  ) = AssistantModelString;

  /// Object construction from a JSON representation
  factory AssistantModel.fromJson(Map<String, dynamic> json) =>
      _$AssistantModelFromJson(json);
}

/// Custom JSON converter for [AssistantModel]
class _AssistantModelConverter
    implements JsonConverter<AssistantModel, Object?> {
  const _AssistantModelConverter();

  @override
  AssistantModel fromJson(Object? data) {
    if (data is String && _$AssistantModelsEnumMap.values.contains(data)) {
      return AssistantModelEnumeration(
        _$AssistantModelsEnumMap.keys.elementAt(
          _$AssistantModelsEnumMap.values.toList().indexOf(data),
        ),
      );
    }
    if (data is String) {
      return AssistantModelString(data);
    }
    throw Exception(
      'Unexpected value for AssistantModel: $data',
    );
  }

  @override
  Object? toJson(AssistantModel data) {
    return switch (data) {
      AssistantModelEnumeration(value: final v) => _$AssistantModelsEnumMap[v]!,
      AssistantModelString(value: final v) => v,
    };
  }
}

// ==========================================
// ENUM: CreateAssistantResponseFormatMode
// ==========================================

/// `auto` is the default value
enum CreateAssistantResponseFormatMode {
  @JsonValue('auto')
  auto,
}

// ==========================================
// CLASS: CreateAssistantRequestResponseFormat
// ==========================================

/// Specifies the format that the model must output. Compatible with
/// [GPT-4o](https://platform.openai.com/docs/models#gpt-4o),
/// [GPT-4 Turbo](https://platform.openai.com/docs/models#gpt-4-turbo-and-gpt-4), and all GPT-3.5 Turbo models
/// since `gpt-3.5-turbo-1106`.
///
/// Setting to `{ "type": "json_schema", "json_schema": {...} }` enables Structured Outputs which ensures
/// the model will match your supplied JSON schema. Learn more in the
/// [Structured Outputs guide](https://platform.openai.com/docs/guides/structured-outputs).
///
/// Setting to `{ "type": "json_object" }` enables JSON mode, which ensures the message the model generates
/// is valid JSON.
///
/// **Important:** when using JSON mode, you **must** also instruct the model to produce JSON yourself via a
/// system or user message. Without this, the model may generate an unending stream of whitespace until the
/// generation reaches the token limit, resulting in a long-running and seemingly "stuck" request. Also note
/// that the message content may be partially cut off if `finish_reason="length"`, which indicates the
/// generation exceeded `max_tokens` or the conversation exceeded the max context length.
@freezed
sealed class CreateAssistantRequestResponseFormat
    with _$CreateAssistantRequestResponseFormat {
  const CreateAssistantRequestResponseFormat._();

  /// `auto` is the default value
  const factory CreateAssistantRequestResponseFormat.mode(
    CreateAssistantResponseFormatMode value,
  ) = CreateAssistantRequestResponseFormatEnumeration;

  /// No Description
  const factory CreateAssistantRequestResponseFormat.responseFormat(
    ResponseFormat value,
  ) = CreateAssistantRequestResponseFormatResponseFormat;

  /// Object construction from a JSON representation
  factory CreateAssistantRequestResponseFormat.fromJson(
          Map<String, dynamic> json) =>
      _$CreateAssistantRequestResponseFormatFromJson(json);
}

/// Custom JSON converter for [CreateAssistantRequestResponseFormat]
class _CreateAssistantRequestResponseFormatConverter
    implements JsonConverter<CreateAssistantRequestResponseFormat?, Object?> {
  const _CreateAssistantRequestResponseFormatConverter();

  @override
  CreateAssistantRequestResponseFormat? fromJson(Object? data) {
    if (data == null) {
      return null;
    }
    if (data is String &&
        _$CreateAssistantResponseFormatModeEnumMap.values.contains(data)) {
      return CreateAssistantRequestResponseFormatEnumeration(
        _$CreateAssistantResponseFormatModeEnumMap.keys.elementAt(
          _$CreateAssistantResponseFormatModeEnumMap.values
              .toList()
              .indexOf(data),
        ),
      );
    }
    if (data is Map<String, dynamic>) {
      try {
        return CreateAssistantRequestResponseFormatResponseFormat(
          ResponseFormat.fromJson(data),
        );
      } catch (e) {}
    }
    throw Exception(
      'Unexpected value for CreateAssistantRequestResponseFormat: $data',
    );
  }

  @override
  Object? toJson(CreateAssistantRequestResponseFormat? data) {
    return switch (data) {
      CreateAssistantRequestResponseFormatEnumeration(value: final v) =>
        _$CreateAssistantResponseFormatModeEnumMap[v]!,
      CreateAssistantRequestResponseFormatResponseFormat(value: final v) =>
        v.toJson(),
      null => null,
    };
  }
}
