// coverage:ignore-file
// GENERATED CODE - DO NOT MODIFY BY HAND
// ignore_for_file: type=lint
// ignore_for_file: invalid_annotation_target
part of open_a_i_schema;

// ==========================================
// CLASS: ChatCompletionStreamResponseDelta
// ==========================================

/// A chat completion delta generated by streamed model responses.
@freezed
abstract class ChatCompletionStreamResponseDelta
    with _$ChatCompletionStreamResponseDelta {
  const ChatCompletionStreamResponseDelta._();

  /// Factory constructor for ChatCompletionStreamResponseDelta
  const factory ChatCompletionStreamResponseDelta({
    /// The role of the messages author.
    /// One of `developer`, `user`, `assistant`, or `tool` (`function` and `system` are deprecated).
    @JsonKey(
      includeIfNull: false,
      unknownEnumValue: JsonKey.nullForUndefinedEnumValue,
    )
    ChatCompletionMessageRole? role,

    /// The contents of the chunk message.
    @JsonKey(includeIfNull: false) String? content,

    /// The refusal message generated by the model.
    @JsonKey(includeIfNull: false) String? refusal,

    /// No Description
    @JsonKey(name: 'tool_calls', includeIfNull: false)
    List<ChatCompletionStreamMessageToolCallChunk>? toolCalls,

    /// The name and arguments of a function that should be called, as generated by the model.
    @JsonKey(name: 'function_call', includeIfNull: false)
    ChatCompletionStreamMessageFunctionCall? functionCall,

    /// If the audio output modality is requested, this object contains data about the audio response from the model.
    /// [Learn more](https://platform.openai.com/docs/guides/audio).
    @JsonKey(includeIfNull: false)
    ChatCompletionStreamResponseDeltaAudio? audio,
  }) = _ChatCompletionStreamResponseDelta;

  /// Object construction from a JSON representation
  factory ChatCompletionStreamResponseDelta.fromJson(
          Map<String, dynamic> json) =>
      _$ChatCompletionStreamResponseDeltaFromJson(json);

  /// List of all property names of schema
  static const List<String> propertyNames = [
    'role',
    'content',
    'refusal',
    'tool_calls',
    'function_call',
    'audio'
  ];

  /// Perform validations on the schema property values
  String? validateSchema() {
    return null;
  }

  /// Map representation of object (not serialized)
  Map<String, dynamic> toMap() {
    return {
      'role': role,
      'content': content,
      'refusal': refusal,
      'tool_calls': toolCalls,
      'function_call': functionCall,
      'audio': audio,
    };
  }
}

// ==========================================
// CLASS: ChatCompletionStreamResponseDeltaAudio
// ==========================================

/// If the audio output modality is requested, this object contains data about the audio response from the model.
/// [Learn more](https://platform.openai.com/docs/guides/audio).
@freezed
abstract class ChatCompletionStreamResponseDeltaAudio
    with _$ChatCompletionStreamResponseDeltaAudio {
  const ChatCompletionStreamResponseDeltaAudio._();

  /// Factory constructor for ChatCompletionStreamResponseDeltaAudio
  const factory ChatCompletionStreamResponseDeltaAudio({
    /// Unique identifier for this audio response.
    @JsonKey(includeIfNull: false) String? id,

    /// The Unix timestamp (in seconds) for when this audio response will no longer be accessible on the server
    /// for use in multi-turn conversations.
    @JsonKey(name: 'expires_at', includeIfNull: false) int? expiresAt,

    /// Base64 encoded audio bytes generated by the model, in the format specified in the request.
    @JsonKey(includeIfNull: false) String? data,

    /// Transcript of the audio generated by the model.
    @JsonKey(includeIfNull: false) String? transcript,
  }) = _ChatCompletionStreamResponseDeltaAudio;

  /// Object construction from a JSON representation
  factory ChatCompletionStreamResponseDeltaAudio.fromJson(
          Map<String, dynamic> json) =>
      _$ChatCompletionStreamResponseDeltaAudioFromJson(json);

  /// List of all property names of schema
  static const List<String> propertyNames = [
    'id',
    'expires_at',
    'data',
    'transcript'
  ];

  /// Perform validations on the schema property values
  String? validateSchema() {
    return null;
  }

  /// Map representation of object (not serialized)
  Map<String, dynamic> toMap() {
    return {
      'id': id,
      'expires_at': expiresAt,
      'data': data,
      'transcript': transcript,
    };
  }
}
