// coverage:ignore-file
// GENERATED CODE - DO NOT MODIFY BY HAND
// ignore_for_file: type=lint
// ignore_for_file: invalid_annotation_target
part of open_a_i_schema;

// ==========================================
// CLASS: ChatCompletionMessage
// ==========================================

/// A message in a chat conversation.
@Freezed(unionKey: 'role', unionValueCase: FreezedUnionCase.snake)
sealed class ChatCompletionMessage with _$ChatCompletionMessage {
  const ChatCompletionMessage._();

  // ------------------------------------------
  // UNION: ChatCompletionDeveloperMessage
  // ------------------------------------------

  /// Developer-provided instructions that the model should follow, regardless of
  /// messages sent by the user. With o1 models and newer, `developer` messages
  /// replace the previous `system` messages.

  @FreezedUnionValue('developer')
  const factory ChatCompletionMessage.developer({
    /// The role of the messages author, in this case `developer`.
    @Default(ChatCompletionMessageRole.developer)
    ChatCompletionMessageRole role,

    /// The contents of the developer message.
    @_ChatCompletionDeveloperMessageContentConverter()
    required ChatCompletionDeveloperMessageContent content,

    /// An optional name for the participant. Provides the model information to differentiate between participants of the same role.
    @JsonKey(includeIfNull: false) String? name,
  }) = ChatCompletionDeveloperMessage;

  // ------------------------------------------
  // UNION: ChatCompletionSystemMessage
  // ------------------------------------------

  /// Developer-provided instructions that the model should follow, regardless of
  /// messages sent by the user. With o1 models and newer, use `developer` messages
  /// for this purpose instead.

  @FreezedUnionValue('system')
  const factory ChatCompletionMessage.system({
    /// The role of the messages author, in this case `system`.
    @Default(ChatCompletionMessageRole.system) ChatCompletionMessageRole role,

    /// The contents of the system message.
    required String content,

    /// An optional name for the participant. Provides the model information to differentiate between participants of the same role.
    @JsonKey(includeIfNull: false) String? name,
  }) = ChatCompletionSystemMessage;

  // ------------------------------------------
  // UNION: ChatCompletionUserMessage
  // ------------------------------------------

  /// Messages sent by an end user, containing prompts or additional context
  /// information.

  @FreezedUnionValue('user')
  const factory ChatCompletionMessage.user({
    /// The role of the messages author, in this case `user`.
    @Default(ChatCompletionMessageRole.user) ChatCompletionMessageRole role,

    /// The contents of the user message.
    @_ChatCompletionUserMessageContentConverter()
    required ChatCompletionUserMessageContent content,

    /// An optional name for the participant. Provides the model information to differentiate between participants of the same role.
    @JsonKey(includeIfNull: false) String? name,
  }) = ChatCompletionUserMessage;

  // ------------------------------------------
  // UNION: ChatCompletionAssistantMessage
  // ------------------------------------------

  /// An assistant message in a chat conversation.

  @FreezedUnionValue('assistant')
  const factory ChatCompletionMessage.assistant({
    /// The role of the messages author, in this case `assistant`.
    @Default(ChatCompletionMessageRole.assistant)
    ChatCompletionMessageRole role,

    /// The contents of the assistant message. Required unless `tool_calls` or `function_call` is specified.
    @JsonKey(includeIfNull: false) String? content,

    /// The refusal message by the assistant.
    @JsonKey(includeIfNull: false) String? refusal,

    /// An optional name for the participant. Provides the model information to differentiate between participants of the same role.
    @JsonKey(includeIfNull: false) String? name,

    /// No Description
    @JsonKey(name: 'tool_calls', includeIfNull: false)
    ChatCompletionMessageToolCalls? toolCalls,

    /// Annotations for the message, when applicable, as when using the
    /// [web search tool](https://platform.openai.com/docs/guides/tools-web-search?api-mode=chat).
    @JsonKey(includeIfNull: false) List<Annotation>? annotations,

    /// Deprecated and replaced by `tool_calls`. The name and arguments of a function that should be called, as generated by the model.
    @JsonKey(name: 'function_call', includeIfNull: false)
    ChatCompletionMessageFunctionCall? functionCall,

    /// If the audio output modality is requested, this object contains data about the audio response from the model.
    /// [Learn more](https://platform.openai.com/docs/guides/audio).
    @JsonKey(includeIfNull: false) ChatCompletionAssistantMessageAudio? audio,
  }) = ChatCompletionAssistantMessage;

  // ------------------------------------------
  // UNION: ChatCompletionToolMessage
  // ------------------------------------------

  /// A tool message in a chat conversation.

  @FreezedUnionValue('tool')
  const factory ChatCompletionMessage.tool({
    /// The role of the messages author, in this case `tool`.
    @Default(ChatCompletionMessageRole.tool) ChatCompletionMessageRole role,

    /// The contents of the tool message.
    required String content,

    /// Tool call that this message is responding to.
    @JsonKey(name: 'tool_call_id') required String toolCallId,
  }) = ChatCompletionToolMessage;

  // ------------------------------------------
  // UNION: ChatCompletionFunctionMessage
  // ------------------------------------------

  /// A function message in a chat conversation.

  @FreezedUnionValue('function')
  const factory ChatCompletionMessage.function({
    /// The role of the messages author, in this case `function`.
    @Default(ChatCompletionMessageRole.function) ChatCompletionMessageRole role,

    /// The contents of the function message.
    required String? content,

    /// The name of the function to call.
    required String name,
  }) = ChatCompletionFunctionMessage;

  /// Object construction from a JSON representation
  factory ChatCompletionMessage.fromJson(Map<String, dynamic> json) =>
      _$ChatCompletionMessageFromJson(json);
}

// ==========================================
// ENUM: ChatCompletionMessageEnumType
// ==========================================

enum ChatCompletionMessageEnumType {
  @JsonValue('developer')
  developer,
  @JsonValue('system')
  system,
  @JsonValue('user')
  user,
  @JsonValue('assistant')
  assistant,
  @JsonValue('tool')
  tool,
  @JsonValue('function')
  function,
}

// ==========================================
// CLASS: ChatCompletionDeveloperMessageContent
// ==========================================

/// The contents of the developer message.
@freezed
sealed class ChatCompletionDeveloperMessageContent
    with _$ChatCompletionDeveloperMessageContent {
  const ChatCompletionDeveloperMessageContent._();

  /// An array of content parts with a defined type. For developer messages, only type `text` is supported.
  const factory ChatCompletionDeveloperMessageContent.parts(
    List<ChatCompletionMessageContentPart> value,
  ) = ChatCompletionDeveloperMessageContentParts;

  /// The text contents of the developer message.
  const factory ChatCompletionDeveloperMessageContent.text(
    String value,
  ) = ChatCompletionDeveloperMessageContentString;

  /// Object construction from a JSON representation
  factory ChatCompletionDeveloperMessageContent.fromJson(
          Map<String, dynamic> json) =>
      _$ChatCompletionDeveloperMessageContentFromJson(json);
}

/// Custom JSON converter for [ChatCompletionDeveloperMessageContent]
class _ChatCompletionDeveloperMessageContentConverter
    implements JsonConverter<ChatCompletionDeveloperMessageContent, Object?> {
  const _ChatCompletionDeveloperMessageContentConverter();

  @override
  ChatCompletionDeveloperMessageContent fromJson(Object? data) {
    if (data is List && data.every((item) => item is Map)) {
      return ChatCompletionDeveloperMessageContentParts(data
          .map((i) => ChatCompletionMessageContentPart.fromJson(
              i as Map<String, dynamic>))
          .toList(growable: false));
    }
    if (data is String) {
      return ChatCompletionDeveloperMessageContentString(data);
    }
    throw Exception(
      'Unexpected value for ChatCompletionDeveloperMessageContent: $data',
    );
  }

  @override
  Object? toJson(ChatCompletionDeveloperMessageContent data) {
    return switch (data) {
      ChatCompletionDeveloperMessageContentParts(value: final v) => v,
      ChatCompletionDeveloperMessageContentString(value: final v) => v,
    };
  }
}

// ==========================================
// CLASS: ChatCompletionUserMessageContent
// ==========================================

/// The contents of the user message.
@freezed
sealed class ChatCompletionUserMessageContent
    with _$ChatCompletionUserMessageContent {
  const ChatCompletionUserMessageContent._();

  /// An array of content parts with a defined type. Supported options differ based on the
  /// [model](https://platform.openai.com/docs/models)
  /// being used to generate the response. Can contain text, image, or audio inputs.
  const factory ChatCompletionUserMessageContent.parts(
    List<ChatCompletionMessageContentPart> value,
  ) = ChatCompletionMessageContentParts;

  /// The text contents of the user message.
  const factory ChatCompletionUserMessageContent.string(
    String value,
  ) = ChatCompletionUserMessageContentString;

  /// Object construction from a JSON representation
  factory ChatCompletionUserMessageContent.fromJson(
          Map<String, dynamic> json) =>
      _$ChatCompletionUserMessageContentFromJson(json);
}

/// Custom JSON converter for [ChatCompletionUserMessageContent]
class _ChatCompletionUserMessageContentConverter
    implements JsonConverter<ChatCompletionUserMessageContent, Object?> {
  const _ChatCompletionUserMessageContentConverter();

  @override
  ChatCompletionUserMessageContent fromJson(Object? data) {
    if (data is List && data.every((item) => item is Map)) {
      return ChatCompletionMessageContentParts(data
          .map((i) => ChatCompletionMessageContentPart.fromJson(
              i as Map<String, dynamic>))
          .toList(growable: false));
    }
    if (data is String) {
      return ChatCompletionUserMessageContentString(data);
    }
    throw Exception(
      'Unexpected value for ChatCompletionUserMessageContent: $data',
    );
  }

  @override
  Object? toJson(ChatCompletionUserMessageContent data) {
    return switch (data) {
      ChatCompletionMessageContentParts(value: final v) => v,
      ChatCompletionUserMessageContentString(value: final v) => v,
    };
  }
}

// ==========================================
// CLASS: ChatCompletionAssistantMessageAudio
// ==========================================

/// If the audio output modality is requested, this object contains data about the audio response from the model.
/// [Learn more](https://platform.openai.com/docs/guides/audio).
@freezed
abstract class ChatCompletionAssistantMessageAudio
    with _$ChatCompletionAssistantMessageAudio {
  const ChatCompletionAssistantMessageAudio._();

  /// Factory constructor for ChatCompletionAssistantMessageAudio
  const factory ChatCompletionAssistantMessageAudio({
    /// Unique identifier for this audio response.
    required String id,

    /// The Unix timestamp (in seconds) for when this audio response will no longer be accessible on the server
    /// for use in multi-turn conversations.
    @JsonKey(name: 'expires_at') required int expiresAt,

    /// Base64 encoded audio bytes generated by the model, in the format specified in the request.
    required String data,

    /// Transcript of the audio generated by the model.
    required String transcript,
  }) = _ChatCompletionAssistantMessageAudio;

  /// Object construction from a JSON representation
  factory ChatCompletionAssistantMessageAudio.fromJson(
          Map<String, dynamic> json) =>
      _$ChatCompletionAssistantMessageAudioFromJson(json);

  /// List of all property names of schema
  static const List<String> propertyNames = [
    'id',
    'expires_at',
    'data',
    'transcript'
  ];

  /// Perform validations on the schema property values
  String? validateSchema() {
    return null;
  }

  /// Map representation of object (not serialized)
  Map<String, dynamic> toMap() {
    return {
      'id': id,
      'expires_at': expiresAt,
      'data': data,
      'transcript': transcript,
    };
  }
}
