// This is a generated file (see the discoveryapis_generator project).

// ignore_for_file: camel_case_types
// ignore_for_file: comment_references
// ignore_for_file: deprecated_member_use_from_same_package
// ignore_for_file: doc_directive_unknown
// ignore_for_file: lines_longer_than_80_chars
// ignore_for_file: non_constant_identifier_names
// ignore_for_file: prefer_interpolation_to_compose_strings
// ignore_for_file: unintended_html_in_doc_comment
// ignore_for_file: unnecessary_brace_in_string_interps
// ignore_for_file: unnecessary_lambdas
// ignore_for_file: unnecessary_string_interpolations

/// Cloud Dataplex API - v1
///
/// Dataplex API is used to manage the lifecycle of data lakes.
///
/// For more information, see <https://cloud.google.com/dataplex/docs>
///
/// Create an instance of [CloudDataplexApi] to access these resources:
///
/// - [OrganizationsResource]
///   - [OrganizationsLocationsResource]
///     - [OrganizationsLocationsEncryptionConfigsResource]
///     - [OrganizationsLocationsOperationsResource]
/// - [ProjectsResource]
///   - [ProjectsLocationsResource]
///     - [ProjectsLocationsAspectTypesResource]
///     - [ProjectsLocationsDataAttributeBindingsResource]
///     - [ProjectsLocationsDataScansResource]
///       - [ProjectsLocationsDataScansJobsResource]
///     - [ProjectsLocationsDataTaxonomiesResource]
///       - [ProjectsLocationsDataTaxonomiesAttributesResource]
///     - [ProjectsLocationsEntryGroupsResource]
///       - [ProjectsLocationsEntryGroupsEntriesResource]
///     - [ProjectsLocationsEntryLinkTypesResource]
///     - [ProjectsLocationsEntryTypesResource]
///     - [ProjectsLocationsGlossariesResource]
///       - [ProjectsLocationsGlossariesCategoriesResource]
///       - [ProjectsLocationsGlossariesTermsResource]
///     - [ProjectsLocationsGovernanceRulesResource]
///     - [ProjectsLocationsLakesResource]
///       - [ProjectsLocationsLakesActionsResource]
///       - [ProjectsLocationsLakesContentResource]
///       - [ProjectsLocationsLakesContentitemsResource]
///       - [ProjectsLocationsLakesEnvironmentsResource]
///         - [ProjectsLocationsLakesEnvironmentsSessionsResource]
///       - [ProjectsLocationsLakesTasksResource]
///         - [ProjectsLocationsLakesTasksJobsResource]
///       - [ProjectsLocationsLakesZonesResource]
///         - [ProjectsLocationsLakesZonesActionsResource]
///         - [ProjectsLocationsLakesZonesAssetsResource]
///           - [ProjectsLocationsLakesZonesAssetsActionsResource]
///         - [ProjectsLocationsLakesZonesEntitiesResource]
///           - [ProjectsLocationsLakesZonesEntitiesPartitionsResource]
///     - [ProjectsLocationsMetadataJobsResource]
///     - [ProjectsLocationsOperationsResource]
library;

import 'dart:async' as async;
import 'dart:convert' as convert;
import 'dart:core' as core;

import 'package:_discoveryapis_commons/_discoveryapis_commons.dart' as commons;
import 'package:http/http.dart' as http;

import '../shared.dart';
import '../src/user_agent.dart';

export 'package:_discoveryapis_commons/_discoveryapis_commons.dart'
    show ApiRequestError, DetailedApiRequestError;

/// Dataplex API is used to manage the lifecycle of data lakes.
class CloudDataplexApi {
  /// See, edit, configure, and delete your Google Cloud data and see the email
  /// address for your Google Account.
  static const cloudPlatformScope =
      'https://www.googleapis.com/auth/cloud-platform';

  final commons.ApiRequester _requester;

  OrganizationsResource get organizations => OrganizationsResource(_requester);
  ProjectsResource get projects => ProjectsResource(_requester);

  CloudDataplexApi(http.Client client,
      {core.String rootUrl = 'https://dataplex.googleapis.com/',
      core.String servicePath = ''})
      : _requester =
            commons.ApiRequester(client, rootUrl, servicePath, requestHeaders);
}

class OrganizationsResource {
  final commons.ApiRequester _requester;

  OrganizationsLocationsResource get locations =>
      OrganizationsLocationsResource(_requester);

  OrganizationsResource(commons.ApiRequester client) : _requester = client;
}

class OrganizationsLocationsResource {
  final commons.ApiRequester _requester;

  OrganizationsLocationsEncryptionConfigsResource get encryptionConfigs =>
      OrganizationsLocationsEncryptionConfigsResource(_requester);
  OrganizationsLocationsOperationsResource get operations =>
      OrganizationsLocationsOperationsResource(_requester);

  OrganizationsLocationsResource(commons.ApiRequester client)
      : _requester = client;
}

class OrganizationsLocationsEncryptionConfigsResource {
  final commons.ApiRequester _requester;

  OrganizationsLocationsEncryptionConfigsResource(commons.ApiRequester client)
      : _requester = client;

  /// Gets the access control policy for a resource.
  ///
  /// Returns an empty policy if the resource exists and does not have a policy
  /// set.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^organizations/\[^/\]+/locations/\[^/\]+/encryptionConfigs/\[^/\]+$`.
  ///
  /// [options_requestedPolicyVersion] - Optional. The maximum policy version
  /// that will be used to format the policy.Valid values are 0, 1, and 3.
  /// Requests specifying an invalid value will be rejected.Requests for
  /// policies with any conditional role bindings must specify version 3.
  /// Policies with no conditional role bindings may specify any valid value or
  /// leave the field unset.The policy in the response might use the policy
  /// version that you specified, or it might use a lower policy version. For
  /// example, if you specify version 3, but the policy has no conditional role
  /// bindings, the response uses version 1.To learn which resources support
  /// conditions in their IAM policies, see the IAM documentation
  /// (https://cloud.google.com/iam/help/conditions/resource-policies).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> getIamPolicy(
    core.String resource, {
    core.int? options_requestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (options_requestedPolicyVersion != null)
        'options.requestedPolicyVersion': ['${options_requestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified resource.
  ///
  /// Replaces any existing policy.Can return NOT_FOUND, INVALID_ARGUMENT, and
  /// PERMISSION_DENIED errors.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// specified. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^organizations/\[^/\]+/locations/\[^/\]+/encryptionConfigs/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> setIamPolicy(
    GoogleIamV1SetIamPolicyRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// If the resource does not exist, this will return an empty set of
  /// permissions, not a NOT_FOUND error.Note: This operation is designed to be
  /// used for building permission-aware UIs and command-line tools, not for
  /// authorization checking. This operation may "fail open" without warning.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy detail is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^organizations/\[^/\]+/locations/\[^/\]+/encryptionConfigs/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1TestIamPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1TestIamPermissionsResponse> testIamPermissions(
    GoogleIamV1TestIamPermissionsRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$resource') + ':testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1TestIamPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class OrganizationsLocationsOperationsResource {
  final commons.ApiRequester _requester;

  OrganizationsLocationsOperationsResource(commons.ApiRequester client)
      : _requester = client;

  /// Starts asynchronous cancellation on a long-running operation.
  ///
  /// The server makes a best effort to cancel the operation, but success is not
  /// guaranteed. If the server doesn't support this method, it returns
  /// google.rpc.Code.UNIMPLEMENTED. Clients can use Operations.GetOperation or
  /// other methods to check whether the cancellation succeeded or whether the
  /// operation completed despite cancellation. On successful cancellation, the
  /// operation is not deleted; instead, it becomes an operation with an
  /// Operation.error value with a google.rpc.Status.code of 1, corresponding to
  /// Code.CANCELLED.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be cancelled.
  /// Value must have pattern
  /// `^organizations/\[^/\]+/locations/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Empty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Empty> cancel(
    GoogleLongrunningCancelOperationRequest request,
    core.String name, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Empty.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns google.rpc.Code.UNIMPLEMENTED.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^organizations/\[^/\]+/locations/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Empty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Empty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Empty.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^organizations/\[^/\]+/locations/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns UNIMPLEMENTED.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern
  /// `^organizations/\[^/\]+/locations/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> listOperations(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsResource get locations =>
      ProjectsLocationsResource(_requester);

  ProjectsResource(commons.ApiRequester client) : _requester = client;
}

class ProjectsLocationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsAspectTypesResource get aspectTypes =>
      ProjectsLocationsAspectTypesResource(_requester);
  ProjectsLocationsDataAttributeBindingsResource get dataAttributeBindings =>
      ProjectsLocationsDataAttributeBindingsResource(_requester);
  ProjectsLocationsDataScansResource get dataScans =>
      ProjectsLocationsDataScansResource(_requester);
  ProjectsLocationsDataTaxonomiesResource get dataTaxonomies =>
      ProjectsLocationsDataTaxonomiesResource(_requester);
  ProjectsLocationsEntryGroupsResource get entryGroups =>
      ProjectsLocationsEntryGroupsResource(_requester);
  ProjectsLocationsEntryLinkTypesResource get entryLinkTypes =>
      ProjectsLocationsEntryLinkTypesResource(_requester);
  ProjectsLocationsEntryTypesResource get entryTypes =>
      ProjectsLocationsEntryTypesResource(_requester);
  ProjectsLocationsGlossariesResource get glossaries =>
      ProjectsLocationsGlossariesResource(_requester);
  ProjectsLocationsGovernanceRulesResource get governanceRules =>
      ProjectsLocationsGovernanceRulesResource(_requester);
  ProjectsLocationsLakesResource get lakes =>
      ProjectsLocationsLakesResource(_requester);
  ProjectsLocationsMetadataJobsResource get metadataJobs =>
      ProjectsLocationsMetadataJobsResource(_requester);
  ProjectsLocationsOperationsResource get operations =>
      ProjectsLocationsOperationsResource(_requester);

  ProjectsLocationsResource(commons.ApiRequester client) : _requester = client;

  /// Gets information about a location.
  ///
  /// Request parameters:
  ///
  /// [name] - Resource name for the location.
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudLocationLocation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudLocationLocation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudLocationLocation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists information about the supported locations for this service.
  ///
  /// Request parameters:
  ///
  /// [name] - The resource that owns the locations collection, if applicable.
  /// Value must have pattern `^projects/\[^/\]+$`.
  ///
  /// [filter] - A filter to narrow down results to a preferred subset. The
  /// filtering language accepts strings like "displayName=tokyo", and is
  /// documented in more detail in AIP-160 (https://google.aip.dev/160).
  ///
  /// [pageSize] - The maximum number of results to return. If not set, the
  /// service selects a default.
  ///
  /// [pageToken] - A page token received from the next_page_token field in the
  /// response. Send that page token to receive the subsequent page.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudLocationListLocationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudLocationListLocationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/locations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudLocationListLocationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Looks up an entry by name using the permission on the source system.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The project to which the request should be attributed
  /// in the following form: projects/{project}/locations/{location}.
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [aspectTypes_1] - Optional. Limits the aspects returned to the provided
  /// aspect types. It only works for CUSTOM view.
  ///
  /// [entry] - Required. The resource name of the Entry:
  /// projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}.
  ///
  /// [paths] - Optional. Limits the aspects returned to those associated with
  /// the provided paths within the Entry. It only works for CUSTOM view.
  ///
  /// [view] - Optional. View to control which parts of an entry the service
  /// should return.
  /// Possible string values are:
  /// - "ENTRY_VIEW_UNSPECIFIED" : Unspecified EntryView. Defaults to FULL.
  /// - "BASIC" : Returns entry only, without aspects.
  /// - "FULL" : Returns all required aspects as well as the keys of all
  /// non-required aspects.
  /// - "CUSTOM" : Returns aspects matching custom fields in GetEntryRequest. If
  /// the number of aspects exceeds 100, the first 100 will be returned.
  /// - "ALL" : Returns all aspects. If the number of aspects exceeds 100, the
  /// first 100 will be returned.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1Entry].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1Entry> lookupEntry(
    core.String name, {
    core.List<core.String>? aspectTypes_1,
    core.String? entry,
    core.List<core.String>? paths,
    core.String? view,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (aspectTypes_1 != null) 'aspectTypes': aspectTypes_1,
      if (entry != null) 'entry': [entry],
      if (paths != null) 'paths': paths,
      if (view != null) 'view': [view],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':lookupEntry';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1Entry.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Searches for Entries matching the given query and scope.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The project to which the request should be attributed
  /// in the following form: projects/{project}/locations/{location}.
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [orderBy] - Optional. Specifies the ordering of results. Supported values
  /// are: relevance (default) last_modified_timestamp last_modified_timestamp
  /// asc
  ///
  /// [pageSize] - Optional. Number of results in the search page. If \<=0, then
  /// defaults to 10. Max limit for page_size is 1000. Throws an invalid
  /// argument for page_size \> 1000.
  ///
  /// [pageToken] - Optional. Page token received from a previous SearchEntries
  /// call. Provide this to retrieve the subsequent page.
  ///
  /// [query] - Required. The query against which entries in scope should be
  /// matched. The query syntax is defined in Search syntax for Dataplex Catalog
  /// (https://cloud.google.com/dataplex/docs/search-syntax).
  ///
  /// [scope] - Optional. The scope under which the search should be operating.
  /// It must either be organizations/ or projects/. If it is unspecified, it
  /// defaults to the organization where the project provided in name is
  /// located.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1SearchEntriesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1SearchEntriesResponse> searchEntries(
    core.String name, {
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? query,
    core.String? scope,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (query != null) 'query': [query],
      if (scope != null) 'scope': [scope],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':searchEntries';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1SearchEntriesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsAspectTypesResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsAspectTypesResource(commons.ApiRequester client)
      : _requester = client;

  /// Creates an AspectType.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the AspectType, of the form:
  /// projects/{project_number}/locations/{location_id} where location_id refers
  /// to a Google Cloud region.
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [aspectTypeId] - Required. AspectType identifier.
  ///
  /// [validateOnly] - Optional. The service validates the request without
  /// performing any mutations. The default is false.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> create(
    GoogleCloudDataplexV1AspectType request,
    core.String parent, {
    core.String? aspectTypeId,
    core.bool? validateOnly,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (aspectTypeId != null) 'aspectTypeId': [aspectTypeId],
      if (validateOnly != null) 'validateOnly': ['${validateOnly}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/aspectTypes';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes an AspectType.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the AspectType:
  /// projects/{project_number}/locations/{location_id}/aspectTypes/{aspect_type_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/aspectTypes/\[^/\]+$`.
  ///
  /// [etag] - Optional. If the client provided etag value does not match the
  /// current etag value, the DeleteAspectTypeRequest method returns an ABORTED
  /// error response.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? etag,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (etag != null) 'etag': [etag],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets an AspectType.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the AspectType:
  /// projects/{project_number}/locations/{location_id}/aspectTypes/{aspect_type_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/aspectTypes/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1AspectType].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1AspectType> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1AspectType.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the access control policy for a resource.
  ///
  /// Returns an empty policy if the resource exists and does not have a policy
  /// set.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/aspectTypes/\[^/\]+$`.
  ///
  /// [options_requestedPolicyVersion] - Optional. The maximum policy version
  /// that will be used to format the policy.Valid values are 0, 1, and 3.
  /// Requests specifying an invalid value will be rejected.Requests for
  /// policies with any conditional role bindings must specify version 3.
  /// Policies with no conditional role bindings may specify any valid value or
  /// leave the field unset.The policy in the response might use the policy
  /// version that you specified, or it might use a lower policy version. For
  /// example, if you specify version 3, but the policy has no conditional role
  /// bindings, the response uses version 1.To learn which resources support
  /// conditions in their IAM policies, see the IAM documentation
  /// (https://cloud.google.com/iam/help/conditions/resource-policies).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> getIamPolicy(
    core.String resource, {
    core.int? options_requestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (options_requestedPolicyVersion != null)
        'options.requestedPolicyVersion': ['${options_requestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists AspectType resources in a project and location.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the AspectType location, of the
  /// form: projects/{project_number}/locations/{location_id} where location_id
  /// refers to a Google Cloud region.
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [filter] - Optional. Filter request. Filters are case-sensitive. The
  /// service supports the following formats: labels.key1 = "value1" labels:key1
  /// name = "value"These restrictions can be conjoined with AND, OR, and NOT
  /// conjunctions.
  ///
  /// [orderBy] - Optional. Orders the result by name or create_time fields. If
  /// not specified, the ordering is undefined.
  ///
  /// [pageSize] - Optional. Maximum number of AspectTypes to return. The
  /// service may return fewer than this value. If unspecified, the service
  /// returns at most 10 AspectTypes. The maximum value is 1000; values above
  /// 1000 will be coerced to 1000.
  ///
  /// [pageToken] - Optional. Page token received from a previous
  /// ListAspectTypes call. Provide this to retrieve the subsequent page. When
  /// paginating, all other parameters you provide to ListAspectTypes must match
  /// the call that provided the page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1ListAspectTypesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1ListAspectTypesResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/aspectTypes';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1ListAspectTypesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates an AspectType.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Output only. The relative resource name of the AspectType, of the
  /// form:
  /// projects/{project_number}/locations/{location_id}/aspectTypes/{aspect_type_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/aspectTypes/\[^/\]+$`.
  ///
  /// [updateMask] - Required. Mask of fields to update.
  ///
  /// [validateOnly] - Optional. Only validate the request, but do not perform
  /// mutations. The default is false.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> patch(
    GoogleCloudDataplexV1AspectType request,
    core.String name, {
    core.String? updateMask,
    core.bool? validateOnly,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if (validateOnly != null) 'validateOnly': ['${validateOnly}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified resource.
  ///
  /// Replaces any existing policy.Can return NOT_FOUND, INVALID_ARGUMENT, and
  /// PERMISSION_DENIED errors.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// specified. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/aspectTypes/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> setIamPolicy(
    GoogleIamV1SetIamPolicyRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// If the resource does not exist, this will return an empty set of
  /// permissions, not a NOT_FOUND error.Note: This operation is designed to be
  /// used for building permission-aware UIs and command-line tools, not for
  /// authorization checking. This operation may "fail open" without warning.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy detail is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/aspectTypes/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1TestIamPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1TestIamPermissionsResponse> testIamPermissions(
    GoogleIamV1TestIamPermissionsRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$resource') + ':testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1TestIamPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsDataAttributeBindingsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsDataAttributeBindingsResource(commons.ApiRequester client)
      : _requester = client;

  /// Create a DataAttributeBinding resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the parent data taxonomy
  /// projects/{project_number}/locations/{location_id}
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [dataAttributeBindingId] - Required. DataAttributeBinding identifier. *
  /// Must contain only lowercase letters, numbers and hyphens. * Must start
  /// with a letter. * Must be between 1-63 characters. * Must end with a number
  /// or a letter. * Must be unique within the Location.
  ///
  /// [validateOnly] - Optional. Only validate the request, but do not perform
  /// mutations. The default is false.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  @core.Deprecated(
    'Not supported. Member documentation may have more information.',
  )
  async.Future<GoogleLongrunningOperation> create(
    GoogleCloudDataplexV1DataAttributeBinding request,
    core.String parent, {
    core.String? dataAttributeBindingId,
    core.bool? validateOnly,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (dataAttributeBindingId != null)
        'dataAttributeBindingId': [dataAttributeBindingId],
      if (validateOnly != null) 'validateOnly': ['${validateOnly}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$parent') + '/dataAttributeBindings';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a DataAttributeBinding resource.
  ///
  /// All attributes within the DataAttributeBinding must be deleted before the
  /// DataAttributeBinding can be deleted.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the DataAttributeBinding:
  /// projects/{project_number}/locations/{location_id}/dataAttributeBindings/{data_attribute_binding_id}
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataAttributeBindings/\[^/\]+$`.
  ///
  /// [etag] - Required. If the client provided etag value does not match the
  /// current etag value, the DeleteDataAttributeBindingRequest method returns
  /// an ABORTED error response. Etags must be used when calling the
  /// DeleteDataAttributeBinding.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  @core.Deprecated(
    'Not supported. Member documentation may have more information.',
  )
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? etag,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (etag != null) 'etag': [etag],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves a DataAttributeBinding resource.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the DataAttributeBinding:
  /// projects/{project_number}/locations/{location_id}/dataAttributeBindings/{data_attribute_binding_id}
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataAttributeBindings/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1DataAttributeBinding].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  @core.Deprecated(
    'Not supported. Member documentation may have more information.',
  )
  async.Future<GoogleCloudDataplexV1DataAttributeBinding> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1DataAttributeBinding.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the access control policy for a resource.
  ///
  /// Returns an empty policy if the resource exists and does not have a policy
  /// set.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataAttributeBindings/\[^/\]+$`.
  ///
  /// [options_requestedPolicyVersion] - Optional. The maximum policy version
  /// that will be used to format the policy.Valid values are 0, 1, and 3.
  /// Requests specifying an invalid value will be rejected.Requests for
  /// policies with any conditional role bindings must specify version 3.
  /// Policies with no conditional role bindings may specify any valid value or
  /// leave the field unset.The policy in the response might use the policy
  /// version that you specified, or it might use a lower policy version. For
  /// example, if you specify version 3, but the policy has no conditional role
  /// bindings, the response uses version 1.To learn which resources support
  /// conditions in their IAM policies, see the IAM documentation
  /// (https://cloud.google.com/iam/help/conditions/resource-policies).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> getIamPolicy(
    core.String resource, {
    core.int? options_requestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (options_requestedPolicyVersion != null)
        'options.requestedPolicyVersion': ['${options_requestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists DataAttributeBinding resources in a project and location.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location:
  /// projects/{project_number}/locations/{location_id}
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [filter] - Optional. Filter request. Filter using resource:
  /// filter=resource:"resource-name" Filter using attribute:
  /// filter=attributes:"attribute-name" Filter using attribute in paths list:
  /// filter=paths.attributes:"attribute-name"
  ///
  /// [orderBy] - Optional. Order by fields for the result.
  ///
  /// [pageSize] - Optional. Maximum number of DataAttributeBindings to return.
  /// The service may return fewer than this value. If unspecified, at most 10
  /// DataAttributeBindings will be returned. The maximum value is 1000; values
  /// above 1000 will be coerced to 1000.
  ///
  /// [pageToken] - Optional. Page token received from a previous
  /// ListDataAttributeBindings call. Provide this to retrieve the subsequent
  /// page. When paginating, all other parameters provided to
  /// ListDataAttributeBindings must match the call that provided the page
  /// token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1ListDataAttributeBindingsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  @core.Deprecated(
    'Not supported. Member documentation may have more information.',
  )
  async.Future<GoogleCloudDataplexV1ListDataAttributeBindingsResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$parent') + '/dataAttributeBindings';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1ListDataAttributeBindingsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates a DataAttributeBinding resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Output only. The relative resource name of the Data Attribute
  /// Binding, of the form:
  /// projects/{project_number}/locations/{location}/dataAttributeBindings/{data_attribute_binding_id}
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataAttributeBindings/\[^/\]+$`.
  ///
  /// [updateMask] - Required. Mask of fields to update.
  ///
  /// [validateOnly] - Optional. Only validate the request, but do not perform
  /// mutations. The default is false.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  @core.Deprecated(
    'Not supported. Member documentation may have more information.',
  )
  async.Future<GoogleLongrunningOperation> patch(
    GoogleCloudDataplexV1DataAttributeBinding request,
    core.String name, {
    core.String? updateMask,
    core.bool? validateOnly,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if (validateOnly != null) 'validateOnly': ['${validateOnly}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified resource.
  ///
  /// Replaces any existing policy.Can return NOT_FOUND, INVALID_ARGUMENT, and
  /// PERMISSION_DENIED errors.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// specified. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataAttributeBindings/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> setIamPolicy(
    GoogleIamV1SetIamPolicyRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// If the resource does not exist, this will return an empty set of
  /// permissions, not a NOT_FOUND error.Note: This operation is designed to be
  /// used for building permission-aware UIs and command-line tools, not for
  /// authorization checking. This operation may "fail open" without warning.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy detail is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataAttributeBindings/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1TestIamPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1TestIamPermissionsResponse> testIamPermissions(
    GoogleIamV1TestIamPermissionsRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$resource') + ':testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1TestIamPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsDataScansResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsDataScansJobsResource get jobs =>
      ProjectsLocationsDataScansJobsResource(_requester);

  ProjectsLocationsDataScansResource(commons.ApiRequester client)
      : _requester = client;

  /// Creates a DataScan resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the parent location:
  /// projects/{project}/locations/{location_id} where project refers to a
  /// project_id or project_number and location_id refers to a GCP region.
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [dataScanId] - Required. DataScan identifier. Must contain only lowercase
  /// letters, numbers and hyphens. Must start with a letter. Must end with a
  /// number or a letter. Must be between 1-63 characters. Must be unique within
  /// the customer project / location.
  ///
  /// [validateOnly] - Optional. Only validate the request, but do not perform
  /// mutations. The default is false.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> create(
    GoogleCloudDataplexV1DataScan request,
    core.String parent, {
    core.String? dataScanId,
    core.bool? validateOnly,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (dataScanId != null) 'dataScanId': [dataScanId],
      if (validateOnly != null) 'validateOnly': ['${validateOnly}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/dataScans';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a DataScan resource.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the dataScan:
  /// projects/{project}/locations/{location_id}/dataScans/{data_scan_id} where
  /// project refers to a project_id or project_number and location_id refers to
  /// a GCP region.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataScans/\[^/\]+$`.
  ///
  /// [force] - Optional. If set to true, any child resources of this data scan
  /// will also be deleted. (Otherwise, the request will only work if the data
  /// scan has no child resources.)
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.bool? force,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (force != null) 'force': ['${force}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Generates recommended data quality rules based on the results of a data
  /// profiling scan.Use the recommendations to build rules for a data quality
  /// scan.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name must be one of the following: The name of a
  /// data scan with at least one successful, completed data profiling job The
  /// name of a successful, completed data profiling job (a data scan job where
  /// the job type is data profiling)
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataScans/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1GenerateDataQualityRulesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1GenerateDataQualityRulesResponse>
      generateDataQualityRules(
    GoogleCloudDataplexV1GenerateDataQualityRulesRequest request,
    core.String name, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$name') + ':generateDataQualityRules';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1GenerateDataQualityRulesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets a DataScan resource.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the dataScan:
  /// projects/{project}/locations/{location_id}/dataScans/{data_scan_id} where
  /// project refers to a project_id or project_number and location_id refers to
  /// a GCP region.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataScans/\[^/\]+$`.
  ///
  /// [view] - Optional. Select the DataScan view to return. Defaults to BASIC.
  /// Possible string values are:
  /// - "DATA_SCAN_VIEW_UNSPECIFIED" : The API will default to the BASIC view.
  /// - "BASIC" : Basic view that does not include spec and result.
  /// - "FULL" : Include everything.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1DataScan].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1DataScan> get(
    core.String name, {
    core.String? view,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (view != null) 'view': [view],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1DataScan.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the access control policy for a resource.
  ///
  /// Returns an empty policy if the resource exists and does not have a policy
  /// set.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataScans/\[^/\]+$`.
  ///
  /// [options_requestedPolicyVersion] - Optional. The maximum policy version
  /// that will be used to format the policy.Valid values are 0, 1, and 3.
  /// Requests specifying an invalid value will be rejected.Requests for
  /// policies with any conditional role bindings must specify version 3.
  /// Policies with no conditional role bindings may specify any valid value or
  /// leave the field unset.The policy in the response might use the policy
  /// version that you specified, or it might use a lower policy version. For
  /// example, if you specify version 3, but the policy has no conditional role
  /// bindings, the response uses version 1.To learn which resources support
  /// conditions in their IAM policies, see the IAM documentation
  /// (https://cloud.google.com/iam/help/conditions/resource-policies).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> getIamPolicy(
    core.String resource, {
    core.int? options_requestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (options_requestedPolicyVersion != null)
        'options.requestedPolicyVersion': ['${options_requestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists DataScans.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the parent location:
  /// projects/{project}/locations/{location_id} where project refers to a
  /// project_id or project_number and location_id refers to a GCP region.
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [filter] - Optional. Filter request.
  ///
  /// [orderBy] - Optional. Order by fields (name or create_time) for the
  /// result. If not specified, the ordering is undefined.
  ///
  /// [pageSize] - Optional. Maximum number of dataScans to return. The service
  /// may return fewer than this value. If unspecified, at most 500 scans will
  /// be returned. The maximum value is 1000; values above 1000 will be coerced
  /// to 1000.
  ///
  /// [pageToken] - Optional. Page token received from a previous ListDataScans
  /// call. Provide this to retrieve the subsequent page. When paginating, all
  /// other parameters provided to ListDataScans must match the call that
  /// provided the page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1ListDataScansResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1ListDataScansResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/dataScans';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1ListDataScansResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates a DataScan resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Output only. Identifier. The relative resource name of the scan,
  /// of the form:
  /// projects/{project}/locations/{location_id}/dataScans/{datascan_id}, where
  /// project refers to a project_id or project_number and location_id refers to
  /// a GCP region.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataScans/\[^/\]+$`.
  ///
  /// [updateMask] - Optional. Mask of fields to update.
  ///
  /// [validateOnly] - Optional. Only validate the request, but do not perform
  /// mutations. The default is false.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> patch(
    GoogleCloudDataplexV1DataScan request,
    core.String name, {
    core.String? updateMask,
    core.bool? validateOnly,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if (validateOnly != null) 'validateOnly': ['${validateOnly}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Runs an on-demand execution of a DataScan
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the DataScan:
  /// projects/{project}/locations/{location_id}/dataScans/{data_scan_id}. where
  /// project refers to a project_id or project_number and location_id refers to
  /// a GCP region.Only OnDemand data scans are allowed.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataScans/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1RunDataScanResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1RunDataScanResponse> run(
    GoogleCloudDataplexV1RunDataScanRequest request,
    core.String name, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':run';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1RunDataScanResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified resource.
  ///
  /// Replaces any existing policy.Can return NOT_FOUND, INVALID_ARGUMENT, and
  /// PERMISSION_DENIED errors.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// specified. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataScans/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> setIamPolicy(
    GoogleIamV1SetIamPolicyRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// If the resource does not exist, this will return an empty set of
  /// permissions, not a NOT_FOUND error.Note: This operation is designed to be
  /// used for building permission-aware UIs and command-line tools, not for
  /// authorization checking. This operation may "fail open" without warning.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy detail is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataScans/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1TestIamPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1TestIamPermissionsResponse> testIamPermissions(
    GoogleIamV1TestIamPermissionsRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$resource') + ':testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1TestIamPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsDataScansJobsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsDataScansJobsResource(commons.ApiRequester client)
      : _requester = client;

  /// Generates recommended data quality rules based on the results of a data
  /// profiling scan.Use the recommendations to build rules for a data quality
  /// scan.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name must be one of the following: The name of a
  /// data scan with at least one successful, completed data profiling job The
  /// name of a successful, completed data profiling job (a data scan job where
  /// the job type is data profiling)
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataScans/\[^/\]+/jobs/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1GenerateDataQualityRulesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1GenerateDataQualityRulesResponse>
      generateDataQualityRules(
    GoogleCloudDataplexV1GenerateDataQualityRulesRequest request,
    core.String name, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$name') + ':generateDataQualityRules';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1GenerateDataQualityRulesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets a DataScanJob resource.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the DataScanJob:
  /// projects/{project}/locations/{location_id}/dataScans/{data_scan_id}/jobs/{data_scan_job_id}
  /// where project refers to a project_id or project_number and location_id
  /// refers to a GCP region.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataScans/\[^/\]+/jobs/\[^/\]+$`.
  ///
  /// [view] - Optional. Select the DataScanJob view to return. Defaults to
  /// BASIC.
  /// Possible string values are:
  /// - "DATA_SCAN_JOB_VIEW_UNSPECIFIED" : The API will default to the BASIC
  /// view.
  /// - "BASIC" : Basic view that does not include spec and result.
  /// - "FULL" : Include everything.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1DataScanJob].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1DataScanJob> get(
    core.String name, {
    core.String? view,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (view != null) 'view': [view],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1DataScanJob.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists DataScanJobs under the given DataScan.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the parent environment:
  /// projects/{project}/locations/{location_id}/dataScans/{data_scan_id} where
  /// project refers to a project_id or project_number and location_id refers to
  /// a GCP region.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataScans/\[^/\]+$`.
  ///
  /// [filter] - Optional. An expression for filtering the results of the
  /// ListDataScanJobs request.If unspecified, all datascan jobs will be
  /// returned. Multiple filters can be applied (with AND, OR logical
  /// operators). Filters are case-sensitive.Allowed fields are: start_time
  /// end_timestart_time and end_time expect RFC-3339 formatted strings (e.g.
  /// 2018-10-08T18:30:00-07:00).For instance, 'start_time \>
  /// 2018-10-08T00:00:00.123456789Z AND end_time \<
  /// 2018-10-09T00:00:00.123456789Z' limits results to DataScanJobs between
  /// specified start and end times.
  ///
  /// [pageSize] - Optional. Maximum number of DataScanJobs to return. The
  /// service may return fewer than this value. If unspecified, at most 10
  /// DataScanJobs will be returned. The maximum value is 1000; values above
  /// 1000 will be coerced to 1000.
  ///
  /// [pageToken] - Optional. Page token received from a previous
  /// ListDataScanJobs call. Provide this to retrieve the subsequent page. When
  /// paginating, all other parameters provided to ListDataScanJobs must match
  /// the call that provided the page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1ListDataScanJobsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1ListDataScanJobsResponse> list(
    core.String parent, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/jobs';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1ListDataScanJobsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsDataTaxonomiesResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsDataTaxonomiesAttributesResource get attributes =>
      ProjectsLocationsDataTaxonomiesAttributesResource(_requester);

  ProjectsLocationsDataTaxonomiesResource(commons.ApiRequester client)
      : _requester = client;

  /// Create a DataTaxonomy resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - null
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [dataTaxonomyId] - Required. DataTaxonomy identifier. * Must contain only
  /// lowercase letters, numbers and hyphens. * Must start with a letter. * Must
  /// be between 1-63 characters. * Must end with a number or a letter. * Must
  /// be unique within the Project.
  ///
  /// [validateOnly] - Optional. Only validate the request, but do not perform
  /// mutations. The default is false.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  @core.Deprecated(
    'Not supported. Member documentation may have more information.',
  )
  async.Future<GoogleLongrunningOperation> create(
    GoogleCloudDataplexV1DataTaxonomy request,
    core.String parent, {
    core.String? dataTaxonomyId,
    core.bool? validateOnly,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (dataTaxonomyId != null) 'dataTaxonomyId': [dataTaxonomyId],
      if (validateOnly != null) 'validateOnly': ['${validateOnly}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/dataTaxonomies';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a DataTaxonomy resource.
  ///
  /// All attributes within the DataTaxonomy must be deleted before the
  /// DataTaxonomy can be deleted.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the DataTaxonomy:
  /// projects/{project_number}/locations/{location_id}/dataTaxonomies/{data_taxonomy_id}
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataTaxonomies/\[^/\]+$`.
  ///
  /// [etag] - Optional. If the client provided etag value does not match the
  /// current etag value,the DeleteDataTaxonomy method returns an ABORTED error.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  @core.Deprecated(
    'Not supported. Member documentation may have more information.',
  )
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? etag,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (etag != null) 'etag': [etag],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves a DataTaxonomy resource.
  ///
  /// Request parameters:
  ///
  /// [name] - null
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataTaxonomies/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1DataTaxonomy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  @core.Deprecated(
    'Not supported. Member documentation may have more information.',
  )
  async.Future<GoogleCloudDataplexV1DataTaxonomy> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1DataTaxonomy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the access control policy for a resource.
  ///
  /// Returns an empty policy if the resource exists and does not have a policy
  /// set.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataTaxonomies/\[^/\]+$`.
  ///
  /// [options_requestedPolicyVersion] - Optional. The maximum policy version
  /// that will be used to format the policy.Valid values are 0, 1, and 3.
  /// Requests specifying an invalid value will be rejected.Requests for
  /// policies with any conditional role bindings must specify version 3.
  /// Policies with no conditional role bindings may specify any valid value or
  /// leave the field unset.The policy in the response might use the policy
  /// version that you specified, or it might use a lower policy version. For
  /// example, if you specify version 3, but the policy has no conditional role
  /// bindings, the response uses version 1.To learn which resources support
  /// conditions in their IAM policies, see the IAM documentation
  /// (https://cloud.google.com/iam/help/conditions/resource-policies).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> getIamPolicy(
    core.String resource, {
    core.int? options_requestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (options_requestedPolicyVersion != null)
        'options.requestedPolicyVersion': ['${options_requestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists DataTaxonomy resources in a project and location.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the DataTaxonomy location, of
  /// the form: projects/{project_number}/locations/{location_id} where
  /// location_id refers to a GCP region.
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [filter] - Optional. Filter request.
  ///
  /// [orderBy] - Optional. Order by fields for the result.
  ///
  /// [pageSize] - Optional. Maximum number of DataTaxonomies to return. The
  /// service may return fewer than this value. If unspecified, at most 10
  /// DataTaxonomies will be returned. The maximum value is 1000; values above
  /// 1000 will be coerced to 1000.
  ///
  /// [pageToken] - Optional. Page token received from a previous
  /// ListDataTaxonomies call. Provide this to retrieve the subsequent page.
  /// When paginating, all other parameters provided to ListDataTaxonomies must
  /// match the call that provided the page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1ListDataTaxonomiesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  @core.Deprecated(
    'Not supported. Member documentation may have more information.',
  )
  async.Future<GoogleCloudDataplexV1ListDataTaxonomiesResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/dataTaxonomies';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1ListDataTaxonomiesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates a DataTaxonomy resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Output only. The relative resource name of the DataTaxonomy, of
  /// the form:
  /// projects/{project_number}/locations/{location_id}/dataTaxonomies/{data_taxonomy_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataTaxonomies/\[^/\]+$`.
  ///
  /// [updateMask] - Required. Mask of fields to update.
  ///
  /// [validateOnly] - Optional. Only validate the request, but do not perform
  /// mutations. The default is false.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  @core.Deprecated(
    'Not supported. Member documentation may have more information.',
  )
  async.Future<GoogleLongrunningOperation> patch(
    GoogleCloudDataplexV1DataTaxonomy request,
    core.String name, {
    core.String? updateMask,
    core.bool? validateOnly,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if (validateOnly != null) 'validateOnly': ['${validateOnly}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified resource.
  ///
  /// Replaces any existing policy.Can return NOT_FOUND, INVALID_ARGUMENT, and
  /// PERMISSION_DENIED errors.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// specified. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataTaxonomies/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> setIamPolicy(
    GoogleIamV1SetIamPolicyRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// If the resource does not exist, this will return an empty set of
  /// permissions, not a NOT_FOUND error.Note: This operation is designed to be
  /// used for building permission-aware UIs and command-line tools, not for
  /// authorization checking. This operation may "fail open" without warning.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy detail is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataTaxonomies/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1TestIamPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1TestIamPermissionsResponse> testIamPermissions(
    GoogleIamV1TestIamPermissionsRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$resource') + ':testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1TestIamPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsDataTaxonomiesAttributesResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsDataTaxonomiesAttributesResource(commons.ApiRequester client)
      : _requester = client;

  /// Create a DataAttribute resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the parent data taxonomy
  /// projects/{project_number}/locations/{location_id}/dataTaxonomies/{data_taxonomy_id}
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataTaxonomies/\[^/\]+$`.
  ///
  /// [dataAttributeId] - Required. DataAttribute identifier. * Must contain
  /// only lowercase letters, numbers and hyphens. * Must start with a letter. *
  /// Must be between 1-63 characters. * Must end with a number or a letter. *
  /// Must be unique within the DataTaxonomy.
  ///
  /// [validateOnly] - Optional. Only validate the request, but do not perform
  /// mutations. The default is false.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  @core.Deprecated(
    'Not supported. Member documentation may have more information.',
  )
  async.Future<GoogleLongrunningOperation> create(
    GoogleCloudDataplexV1DataAttribute request,
    core.String parent, {
    core.String? dataAttributeId,
    core.bool? validateOnly,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (dataAttributeId != null) 'dataAttributeId': [dataAttributeId],
      if (validateOnly != null) 'validateOnly': ['${validateOnly}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/attributes';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a Data Attribute resource.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the DataAttribute:
  /// projects/{project_number}/locations/{location_id}/dataTaxonomies/{dataTaxonomy}/attributes/{data_attribute_id}
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataTaxonomies/\[^/\]+/attributes/\[^/\]+$`.
  ///
  /// [etag] - Optional. If the client provided etag value does not match the
  /// current etag value, the DeleteDataAttribute method returns an ABORTED
  /// error response.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  @core.Deprecated(
    'Not supported. Member documentation may have more information.',
  )
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? etag,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (etag != null) 'etag': [etag],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves a Data Attribute resource.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the dataAttribute:
  /// projects/{project_number}/locations/{location_id}/dataTaxonomies/{dataTaxonomy}/attributes/{data_attribute_id}
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataTaxonomies/\[^/\]+/attributes/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1DataAttribute].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  @core.Deprecated(
    'Not supported. Member documentation may have more information.',
  )
  async.Future<GoogleCloudDataplexV1DataAttribute> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1DataAttribute.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the access control policy for a resource.
  ///
  /// Returns an empty policy if the resource exists and does not have a policy
  /// set.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataTaxonomies/\[^/\]+/attributes/\[^/\]+$`.
  ///
  /// [options_requestedPolicyVersion] - Optional. The maximum policy version
  /// that will be used to format the policy.Valid values are 0, 1, and 3.
  /// Requests specifying an invalid value will be rejected.Requests for
  /// policies with any conditional role bindings must specify version 3.
  /// Policies with no conditional role bindings may specify any valid value or
  /// leave the field unset.The policy in the response might use the policy
  /// version that you specified, or it might use a lower policy version. For
  /// example, if you specify version 3, but the policy has no conditional role
  /// bindings, the response uses version 1.To learn which resources support
  /// conditions in their IAM policies, see the IAM documentation
  /// (https://cloud.google.com/iam/help/conditions/resource-policies).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> getIamPolicy(
    core.String resource, {
    core.int? options_requestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (options_requestedPolicyVersion != null)
        'options.requestedPolicyVersion': ['${options_requestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists Data Attribute resources in a DataTaxonomy.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the DataTaxonomy:
  /// projects/{project_number}/locations/{location_id}/dataTaxonomies/{data_taxonomy_id}
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataTaxonomies/\[^/\]+$`.
  ///
  /// [filter] - Optional. Filter request.
  ///
  /// [orderBy] - Optional. Order by fields for the result.
  ///
  /// [pageSize] - Optional. Maximum number of DataAttributes to return. The
  /// service may return fewer than this value. If unspecified, at most 10
  /// dataAttributes will be returned. The maximum value is 1000; values above
  /// 1000 will be coerced to 1000.
  ///
  /// [pageToken] - Optional. Page token received from a previous
  /// ListDataAttributes call. Provide this to retrieve the subsequent page.
  /// When paginating, all other parameters provided to ListDataAttributes must
  /// match the call that provided the page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1ListDataAttributesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  @core.Deprecated(
    'Not supported. Member documentation may have more information.',
  )
  async.Future<GoogleCloudDataplexV1ListDataAttributesResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/attributes';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1ListDataAttributesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates a DataAttribute resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Output only. The relative resource name of the dataAttribute, of
  /// the form:
  /// projects/{project_number}/locations/{location_id}/dataTaxonomies/{dataTaxonomy}/attributes/{data_attribute_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataTaxonomies/\[^/\]+/attributes/\[^/\]+$`.
  ///
  /// [updateMask] - Required. Mask of fields to update.
  ///
  /// [validateOnly] - Optional. Only validate the request, but do not perform
  /// mutations. The default is false.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  @core.Deprecated(
    'Not supported. Member documentation may have more information.',
  )
  async.Future<GoogleLongrunningOperation> patch(
    GoogleCloudDataplexV1DataAttribute request,
    core.String name, {
    core.String? updateMask,
    core.bool? validateOnly,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if (validateOnly != null) 'validateOnly': ['${validateOnly}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified resource.
  ///
  /// Replaces any existing policy.Can return NOT_FOUND, INVALID_ARGUMENT, and
  /// PERMISSION_DENIED errors.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// specified. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataTaxonomies/\[^/\]+/attributes/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> setIamPolicy(
    GoogleIamV1SetIamPolicyRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// If the resource does not exist, this will return an empty set of
  /// permissions, not a NOT_FOUND error.Note: This operation is designed to be
  /// used for building permission-aware UIs and command-line tools, not for
  /// authorization checking. This operation may "fail open" without warning.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy detail is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataTaxonomies/\[^/\]+/attributes/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1TestIamPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1TestIamPermissionsResponse> testIamPermissions(
    GoogleIamV1TestIamPermissionsRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$resource') + ':testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1TestIamPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsEntryGroupsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsEntryGroupsEntriesResource get entries =>
      ProjectsLocationsEntryGroupsEntriesResource(_requester);

  ProjectsLocationsEntryGroupsResource(commons.ApiRequester client)
      : _requester = client;

  /// Creates an EntryGroup.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the entryGroup, of the form:
  /// projects/{project_number}/locations/{location_id} where location_id refers
  /// to a GCP region.
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [entryGroupId] - Required. EntryGroup identifier.
  ///
  /// [validateOnly] - Optional. The service validates the request without
  /// performing any mutations. The default is false.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> create(
    GoogleCloudDataplexV1EntryGroup request,
    core.String parent, {
    core.String? entryGroupId,
    core.bool? validateOnly,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (entryGroupId != null) 'entryGroupId': [entryGroupId],
      if (validateOnly != null) 'validateOnly': ['${validateOnly}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/entryGroups';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes an EntryGroup.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the EntryGroup:
  /// projects/{project_number}/locations/{location_id}/entryGroups/{entry_group_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/entryGroups/\[^/\]+$`.
  ///
  /// [etag] - Optional. If the client provided etag value does not match the
  /// current etag value, the DeleteEntryGroupRequest method returns an ABORTED
  /// error response.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? etag,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (etag != null) 'etag': [etag],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets an EntryGroup.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the EntryGroup:
  /// projects/{project_number}/locations/{location_id}/entryGroups/{entry_group_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/entryGroups/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1EntryGroup].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1EntryGroup> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1EntryGroup.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the access control policy for a resource.
  ///
  /// Returns an empty policy if the resource exists and does not have a policy
  /// set.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/entryGroups/\[^/\]+$`.
  ///
  /// [options_requestedPolicyVersion] - Optional. The maximum policy version
  /// that will be used to format the policy.Valid values are 0, 1, and 3.
  /// Requests specifying an invalid value will be rejected.Requests for
  /// policies with any conditional role bindings must specify version 3.
  /// Policies with no conditional role bindings may specify any valid value or
  /// leave the field unset.The policy in the response might use the policy
  /// version that you specified, or it might use a lower policy version. For
  /// example, if you specify version 3, but the policy has no conditional role
  /// bindings, the response uses version 1.To learn which resources support
  /// conditions in their IAM policies, see the IAM documentation
  /// (https://cloud.google.com/iam/help/conditions/resource-policies).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> getIamPolicy(
    core.String resource, {
    core.int? options_requestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (options_requestedPolicyVersion != null)
        'options.requestedPolicyVersion': ['${options_requestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists EntryGroup resources in a project and location.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the entryGroup location, of the
  /// form: projects/{project_number}/locations/{location_id} where location_id
  /// refers to a Google Cloud region.
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [filter] - Optional. Filter request.
  ///
  /// [orderBy] - Optional. Order by fields for the result.
  ///
  /// [pageSize] - Optional. Maximum number of EntryGroups to return. The
  /// service may return fewer than this value. If unspecified, the service
  /// returns at most 10 EntryGroups. The maximum value is 1000; values above
  /// 1000 will be coerced to 1000.
  ///
  /// [pageToken] - Optional. Page token received from a previous
  /// ListEntryGroups call. Provide this to retrieve the subsequent page. When
  /// paginating, all other parameters you provide to ListEntryGroups must match
  /// the call that provided the page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1ListEntryGroupsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1ListEntryGroupsResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/entryGroups';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1ListEntryGroupsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates an EntryGroup.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Output only. The relative resource name of the EntryGroup, in the
  /// format
  /// projects/{project_id_or_number}/locations/{location_id}/entryGroups/{entry_group_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/entryGroups/\[^/\]+$`.
  ///
  /// [updateMask] - Required. Mask of fields to update.
  ///
  /// [validateOnly] - Optional. The service validates the request, without
  /// performing any mutations. The default is false.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> patch(
    GoogleCloudDataplexV1EntryGroup request,
    core.String name, {
    core.String? updateMask,
    core.bool? validateOnly,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if (validateOnly != null) 'validateOnly': ['${validateOnly}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified resource.
  ///
  /// Replaces any existing policy.Can return NOT_FOUND, INVALID_ARGUMENT, and
  /// PERMISSION_DENIED errors.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// specified. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/entryGroups/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> setIamPolicy(
    GoogleIamV1SetIamPolicyRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// If the resource does not exist, this will return an empty set of
  /// permissions, not a NOT_FOUND error.Note: This operation is designed to be
  /// used for building permission-aware UIs and command-line tools, not for
  /// authorization checking. This operation may "fail open" without warning.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy detail is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/entryGroups/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1TestIamPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1TestIamPermissionsResponse> testIamPermissions(
    GoogleIamV1TestIamPermissionsRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$resource') + ':testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1TestIamPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsEntryGroupsEntriesResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsEntryGroupsEntriesResource(commons.ApiRequester client)
      : _requester = client;

  /// Creates an Entry.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the parent Entry Group:
  /// projects/{project}/locations/{location}/entryGroups/{entry_group}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/entryGroups/\[^/\]+$`.
  ///
  /// [entryId] - Required. Entry identifier. It has to be unique within an
  /// Entry Group.Entries corresponding to Google Cloud resources use an Entry
  /// ID format based on full resource names
  /// (https://cloud.google.com/apis/design/resource_names#full_resource_name).
  /// The format is a full resource name of the resource without the prefix
  /// double slashes in the API service name part of the full resource name.
  /// This allows retrieval of entries using their associated resource name.For
  /// example, if the full resource name of a resource is
  /// //library.googleapis.com/shelves/shelf1/books/book2, then the suggested
  /// entry_id is library.googleapis.com/shelves/shelf1/books/book2.It is also
  /// suggested to follow the same convention for entries corresponding to
  /// resources from providers or systems other than Google Cloud.The maximum
  /// size of the field is 4000 characters.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1Entry].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1Entry> create(
    GoogleCloudDataplexV1Entry request,
    core.String parent, {
    core.String? entryId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (entryId != null) 'entryId': [entryId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/entries';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1Entry.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes an Entry.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the Entry:
  /// projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/entryGroups/\[^/\]+/entries/.*$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1Entry].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1Entry> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1Entry.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets an Entry.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the Entry:
  /// projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/entryGroups/\[^/\]+/entries/.*$`.
  ///
  /// [aspectTypes] - Optional. Limits the aspects returned to the provided
  /// aspect types. It only works for CUSTOM view.
  ///
  /// [paths] - Optional. Limits the aspects returned to those associated with
  /// the provided paths within the Entry. It only works for CUSTOM view.
  ///
  /// [view] - Optional. View to control which parts of an entry the service
  /// should return.
  /// Possible string values are:
  /// - "ENTRY_VIEW_UNSPECIFIED" : Unspecified EntryView. Defaults to FULL.
  /// - "BASIC" : Returns entry only, without aspects.
  /// - "FULL" : Returns all required aspects as well as the keys of all
  /// non-required aspects.
  /// - "CUSTOM" : Returns aspects matching custom fields in GetEntryRequest. If
  /// the number of aspects exceeds 100, the first 100 will be returned.
  /// - "ALL" : Returns all aspects. If the number of aspects exceeds 100, the
  /// first 100 will be returned.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1Entry].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1Entry> get(
    core.String name, {
    core.List<core.String>? aspectTypes,
    core.List<core.String>? paths,
    core.String? view,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (aspectTypes != null) 'aspectTypes': aspectTypes,
      if (paths != null) 'paths': paths,
      if (view != null) 'view': [view],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1Entry.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists Entries within an EntryGroup.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the parent Entry Group:
  /// projects/{project}/locations/{location}/entryGroups/{entry_group}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/entryGroups/\[^/\]+$`.
  ///
  /// [filter] - Optional. A filter on the entries to return. Filters are
  /// case-sensitive. You can filter the request by the following fields:
  /// entry_type entry_source.display_nameThe comparison operators are =, !=,
  /// \<, \>, \<=, \>=. The service compares strings according to lexical
  /// order.You can use the logical operators AND, OR, NOT in the filter.You can
  /// use Wildcard "*", but for entry_type you need to provide the full project
  /// id or number.Example filter expressions:
  /// "entry_source.display_name=AnExampleDisplayName"
  /// "entry_type=projects/example-project/locations/global/entryTypes/example-entry_type"
  /// "entry_type=projects/example-project/locations/us/entryTypes/a* OR
  /// entry_type=projects/another-project/locations / * " "NOT
  /// entry_source.display_name=AnotherExampleDisplayName"
  ///
  /// [pageSize] - Optional. Number of items to return per page. If there are
  /// remaining results, the service returns a next_page_token. If unspecified,
  /// the service returns at most 10 Entries. The maximum value is 100; values
  /// above 100 will be coerced to 100.
  ///
  /// [pageToken] - Optional. Page token received from a previous ListEntries
  /// call. Provide this to retrieve the subsequent page.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1ListEntriesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1ListEntriesResponse> list(
    core.String parent, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/entries';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1ListEntriesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates an Entry.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Identifier. The relative resource name of the entry, in the
  /// format
  /// projects/{project_id_or_number}/locations/{location_id}/entryGroups/{entry_group_id}/entries/{entry_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/entryGroups/\[^/\]+/entries/.*$`.
  ///
  /// [allowMissing] - Optional. If set to true and the entry doesn't exist, the
  /// service will create it.
  ///
  /// [aspectKeys] - Optional. The map keys of the Aspects which the service
  /// should modify. It supports the following syntaxes: - matches an aspect of
  /// the given type and empty path. @path - matches an aspect of the given type
  /// and specified path. For example, to attach an aspect to a field that is
  /// specified by the schema aspect, the path should have the format Schema..
  /// @* - matches aspects of the given type for all paths. *@path - matches
  /// aspects of all types on the given path.The service will not remove
  /// existing aspects matching the syntax unless delete_missing_aspects is set
  /// to true.If this field is left empty, the service treats it as specifying
  /// exactly those Aspects present in the request.
  ///
  /// [deleteMissingAspects] - Optional. If set to true and the aspect_keys
  /// specify aspect ranges, the service deletes any existing aspects from that
  /// range that weren't provided in the request.
  ///
  /// [updateMask] - Optional. Mask of fields to update. To update Aspects, the
  /// update_mask must contain the value "aspects".If the update_mask is empty,
  /// the service will update all modifiable fields present in the request.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1Entry].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1Entry> patch(
    GoogleCloudDataplexV1Entry request,
    core.String name, {
    core.bool? allowMissing,
    core.List<core.String>? aspectKeys,
    core.bool? deleteMissingAspects,
    core.String? updateMask,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (allowMissing != null) 'allowMissing': ['${allowMissing}'],
      if (aspectKeys != null) 'aspectKeys': aspectKeys,
      if (deleteMissingAspects != null)
        'deleteMissingAspects': ['${deleteMissingAspects}'],
      if (updateMask != null) 'updateMask': [updateMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1Entry.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsEntryLinkTypesResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsEntryLinkTypesResource(commons.ApiRequester client)
      : _requester = client;

  /// Gets the access control policy for a resource.
  ///
  /// Returns an empty policy if the resource exists and does not have a policy
  /// set.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/entryLinkTypes/\[^/\]+$`.
  ///
  /// [options_requestedPolicyVersion] - Optional. The maximum policy version
  /// that will be used to format the policy.Valid values are 0, 1, and 3.
  /// Requests specifying an invalid value will be rejected.Requests for
  /// policies with any conditional role bindings must specify version 3.
  /// Policies with no conditional role bindings may specify any valid value or
  /// leave the field unset.The policy in the response might use the policy
  /// version that you specified, or it might use a lower policy version. For
  /// example, if you specify version 3, but the policy has no conditional role
  /// bindings, the response uses version 1.To learn which resources support
  /// conditions in their IAM policies, see the IAM documentation
  /// (https://cloud.google.com/iam/help/conditions/resource-policies).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> getIamPolicy(
    core.String resource, {
    core.int? options_requestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (options_requestedPolicyVersion != null)
        'options.requestedPolicyVersion': ['${options_requestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified resource.
  ///
  /// Replaces any existing policy.Can return NOT_FOUND, INVALID_ARGUMENT, and
  /// PERMISSION_DENIED errors.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// specified. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/entryLinkTypes/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> setIamPolicy(
    GoogleIamV1SetIamPolicyRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// If the resource does not exist, this will return an empty set of
  /// permissions, not a NOT_FOUND error.Note: This operation is designed to be
  /// used for building permission-aware UIs and command-line tools, not for
  /// authorization checking. This operation may "fail open" without warning.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy detail is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/entryLinkTypes/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1TestIamPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1TestIamPermissionsResponse> testIamPermissions(
    GoogleIamV1TestIamPermissionsRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$resource') + ':testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1TestIamPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsEntryTypesResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsEntryTypesResource(commons.ApiRequester client)
      : _requester = client;

  /// Creates an EntryType.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the EntryType, of the form:
  /// projects/{project_number}/locations/{location_id} where location_id refers
  /// to a Google Cloud region.
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [entryTypeId] - Required. EntryType identifier.
  ///
  /// [validateOnly] - Optional. The service validates the request without
  /// performing any mutations. The default is false.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> create(
    GoogleCloudDataplexV1EntryType request,
    core.String parent, {
    core.String? entryTypeId,
    core.bool? validateOnly,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (entryTypeId != null) 'entryTypeId': [entryTypeId],
      if (validateOnly != null) 'validateOnly': ['${validateOnly}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/entryTypes';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes an EntryType.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the EntryType:
  /// projects/{project_number}/locations/{location_id}/entryTypes/{entry_type_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/entryTypes/\[^/\]+$`.
  ///
  /// [etag] - Optional. If the client provided etag value does not match the
  /// current etag value, the DeleteEntryTypeRequest method returns an ABORTED
  /// error response.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? etag,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (etag != null) 'etag': [etag],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets an EntryType.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the EntryType:
  /// projects/{project_number}/locations/{location_id}/entryTypes/{entry_type_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/entryTypes/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1EntryType].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1EntryType> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1EntryType.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the access control policy for a resource.
  ///
  /// Returns an empty policy if the resource exists and does not have a policy
  /// set.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/entryTypes/\[^/\]+$`.
  ///
  /// [options_requestedPolicyVersion] - Optional. The maximum policy version
  /// that will be used to format the policy.Valid values are 0, 1, and 3.
  /// Requests specifying an invalid value will be rejected.Requests for
  /// policies with any conditional role bindings must specify version 3.
  /// Policies with no conditional role bindings may specify any valid value or
  /// leave the field unset.The policy in the response might use the policy
  /// version that you specified, or it might use a lower policy version. For
  /// example, if you specify version 3, but the policy has no conditional role
  /// bindings, the response uses version 1.To learn which resources support
  /// conditions in their IAM policies, see the IAM documentation
  /// (https://cloud.google.com/iam/help/conditions/resource-policies).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> getIamPolicy(
    core.String resource, {
    core.int? options_requestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (options_requestedPolicyVersion != null)
        'options.requestedPolicyVersion': ['${options_requestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists EntryType resources in a project and location.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the EntryType location, of the
  /// form: projects/{project_number}/locations/{location_id} where location_id
  /// refers to a Google Cloud region.
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [filter] - Optional. Filter request. Filters are case-sensitive. The
  /// service supports the following formats: labels.key1 = "value1" labels:key1
  /// name = "value"These restrictions can be conjoined with AND, OR, and NOT
  /// conjunctions.
  ///
  /// [orderBy] - Optional. Orders the result by name or create_time fields. If
  /// not specified, the ordering is undefined.
  ///
  /// [pageSize] - Optional. Maximum number of EntryTypes to return. The service
  /// may return fewer than this value. If unspecified, the service returns at
  /// most 10 EntryTypes. The maximum value is 1000; values above 1000 will be
  /// coerced to 1000.
  ///
  /// [pageToken] - Optional. Page token received from a previous ListEntryTypes
  /// call. Provide this to retrieve the subsequent page. When paginating, all
  /// other parameters you provided to ListEntryTypes must match the call that
  /// provided the page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1ListEntryTypesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1ListEntryTypesResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/entryTypes';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1ListEntryTypesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates an EntryType.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Output only. The relative resource name of the EntryType, of the
  /// form:
  /// projects/{project_number}/locations/{location_id}/entryTypes/{entry_type_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/entryTypes/\[^/\]+$`.
  ///
  /// [updateMask] - Required. Mask of fields to update.
  ///
  /// [validateOnly] - Optional. The service validates the request without
  /// performing any mutations. The default is false.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> patch(
    GoogleCloudDataplexV1EntryType request,
    core.String name, {
    core.String? updateMask,
    core.bool? validateOnly,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if (validateOnly != null) 'validateOnly': ['${validateOnly}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified resource.
  ///
  /// Replaces any existing policy.Can return NOT_FOUND, INVALID_ARGUMENT, and
  /// PERMISSION_DENIED errors.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// specified. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/entryTypes/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> setIamPolicy(
    GoogleIamV1SetIamPolicyRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// If the resource does not exist, this will return an empty set of
  /// permissions, not a NOT_FOUND error.Note: This operation is designed to be
  /// used for building permission-aware UIs and command-line tools, not for
  /// authorization checking. This operation may "fail open" without warning.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy detail is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/entryTypes/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1TestIamPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1TestIamPermissionsResponse> testIamPermissions(
    GoogleIamV1TestIamPermissionsRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$resource') + ':testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1TestIamPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsGlossariesResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsGlossariesCategoriesResource get categories =>
      ProjectsLocationsGlossariesCategoriesResource(_requester);
  ProjectsLocationsGlossariesTermsResource get terms =>
      ProjectsLocationsGlossariesTermsResource(_requester);

  ProjectsLocationsGlossariesResource(commons.ApiRequester client)
      : _requester = client;

  /// Gets the access control policy for a resource.
  ///
  /// Returns an empty policy if the resource exists and does not have a policy
  /// set.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/glossaries/\[^/\]+$`.
  ///
  /// [options_requestedPolicyVersion] - Optional. The maximum policy version
  /// that will be used to format the policy.Valid values are 0, 1, and 3.
  /// Requests specifying an invalid value will be rejected.Requests for
  /// policies with any conditional role bindings must specify version 3.
  /// Policies with no conditional role bindings may specify any valid value or
  /// leave the field unset.The policy in the response might use the policy
  /// version that you specified, or it might use a lower policy version. For
  /// example, if you specify version 3, but the policy has no conditional role
  /// bindings, the response uses version 1.To learn which resources support
  /// conditions in their IAM policies, see the IAM documentation
  /// (https://cloud.google.com/iam/help/conditions/resource-policies).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> getIamPolicy(
    core.String resource, {
    core.int? options_requestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (options_requestedPolicyVersion != null)
        'options.requestedPolicyVersion': ['${options_requestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified resource.
  ///
  /// Replaces any existing policy.Can return NOT_FOUND, INVALID_ARGUMENT, and
  /// PERMISSION_DENIED errors.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// specified. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/glossaries/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> setIamPolicy(
    GoogleIamV1SetIamPolicyRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// If the resource does not exist, this will return an empty set of
  /// permissions, not a NOT_FOUND error.Note: This operation is designed to be
  /// used for building permission-aware UIs and command-line tools, not for
  /// authorization checking. This operation may "fail open" without warning.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy detail is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/glossaries/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1TestIamPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1TestIamPermissionsResponse> testIamPermissions(
    GoogleIamV1TestIamPermissionsRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$resource') + ':testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1TestIamPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsGlossariesCategoriesResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsGlossariesCategoriesResource(commons.ApiRequester client)
      : _requester = client;

  /// Gets the access control policy for a resource.
  ///
  /// Returns an empty policy if the resource exists and does not have a policy
  /// set.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/glossaries/\[^/\]+/categories/\[^/\]+$`.
  ///
  /// [options_requestedPolicyVersion] - Optional. The maximum policy version
  /// that will be used to format the policy.Valid values are 0, 1, and 3.
  /// Requests specifying an invalid value will be rejected.Requests for
  /// policies with any conditional role bindings must specify version 3.
  /// Policies with no conditional role bindings may specify any valid value or
  /// leave the field unset.The policy in the response might use the policy
  /// version that you specified, or it might use a lower policy version. For
  /// example, if you specify version 3, but the policy has no conditional role
  /// bindings, the response uses version 1.To learn which resources support
  /// conditions in their IAM policies, see the IAM documentation
  /// (https://cloud.google.com/iam/help/conditions/resource-policies).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> getIamPolicy(
    core.String resource, {
    core.int? options_requestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (options_requestedPolicyVersion != null)
        'options.requestedPolicyVersion': ['${options_requestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified resource.
  ///
  /// Replaces any existing policy.Can return NOT_FOUND, INVALID_ARGUMENT, and
  /// PERMISSION_DENIED errors.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// specified. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/glossaries/\[^/\]+/categories/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> setIamPolicy(
    GoogleIamV1SetIamPolicyRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// If the resource does not exist, this will return an empty set of
  /// permissions, not a NOT_FOUND error.Note: This operation is designed to be
  /// used for building permission-aware UIs and command-line tools, not for
  /// authorization checking. This operation may "fail open" without warning.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy detail is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/glossaries/\[^/\]+/categories/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1TestIamPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1TestIamPermissionsResponse> testIamPermissions(
    GoogleIamV1TestIamPermissionsRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$resource') + ':testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1TestIamPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsGlossariesTermsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsGlossariesTermsResource(commons.ApiRequester client)
      : _requester = client;

  /// Gets the access control policy for a resource.
  ///
  /// Returns an empty policy if the resource exists and does not have a policy
  /// set.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/glossaries/\[^/\]+/terms/\[^/\]+$`.
  ///
  /// [options_requestedPolicyVersion] - Optional. The maximum policy version
  /// that will be used to format the policy.Valid values are 0, 1, and 3.
  /// Requests specifying an invalid value will be rejected.Requests for
  /// policies with any conditional role bindings must specify version 3.
  /// Policies with no conditional role bindings may specify any valid value or
  /// leave the field unset.The policy in the response might use the policy
  /// version that you specified, or it might use a lower policy version. For
  /// example, if you specify version 3, but the policy has no conditional role
  /// bindings, the response uses version 1.To learn which resources support
  /// conditions in their IAM policies, see the IAM documentation
  /// (https://cloud.google.com/iam/help/conditions/resource-policies).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> getIamPolicy(
    core.String resource, {
    core.int? options_requestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (options_requestedPolicyVersion != null)
        'options.requestedPolicyVersion': ['${options_requestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified resource.
  ///
  /// Replaces any existing policy.Can return NOT_FOUND, INVALID_ARGUMENT, and
  /// PERMISSION_DENIED errors.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// specified. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/glossaries/\[^/\]+/terms/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> setIamPolicy(
    GoogleIamV1SetIamPolicyRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// If the resource does not exist, this will return an empty set of
  /// permissions, not a NOT_FOUND error.Note: This operation is designed to be
  /// used for building permission-aware UIs and command-line tools, not for
  /// authorization checking. This operation may "fail open" without warning.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy detail is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/glossaries/\[^/\]+/terms/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1TestIamPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1TestIamPermissionsResponse> testIamPermissions(
    GoogleIamV1TestIamPermissionsRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$resource') + ':testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1TestIamPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsGovernanceRulesResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsGovernanceRulesResource(commons.ApiRequester client)
      : _requester = client;

  /// Gets the access control policy for a resource.
  ///
  /// Returns an empty policy if the resource exists and does not have a policy
  /// set.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/governanceRules/\[^/\]+$`.
  ///
  /// [options_requestedPolicyVersion] - Optional. The maximum policy version
  /// that will be used to format the policy.Valid values are 0, 1, and 3.
  /// Requests specifying an invalid value will be rejected.Requests for
  /// policies with any conditional role bindings must specify version 3.
  /// Policies with no conditional role bindings may specify any valid value or
  /// leave the field unset.The policy in the response might use the policy
  /// version that you specified, or it might use a lower policy version. For
  /// example, if you specify version 3, but the policy has no conditional role
  /// bindings, the response uses version 1.To learn which resources support
  /// conditions in their IAM policies, see the IAM documentation
  /// (https://cloud.google.com/iam/help/conditions/resource-policies).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> getIamPolicy(
    core.String resource, {
    core.int? options_requestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (options_requestedPolicyVersion != null)
        'options.requestedPolicyVersion': ['${options_requestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified resource.
  ///
  /// Replaces any existing policy.Can return NOT_FOUND, INVALID_ARGUMENT, and
  /// PERMISSION_DENIED errors.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// specified. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/governanceRules/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> setIamPolicy(
    GoogleIamV1SetIamPolicyRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// If the resource does not exist, this will return an empty set of
  /// permissions, not a NOT_FOUND error.Note: This operation is designed to be
  /// used for building permission-aware UIs and command-line tools, not for
  /// authorization checking. This operation may "fail open" without warning.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy detail is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/governanceRules/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1TestIamPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1TestIamPermissionsResponse> testIamPermissions(
    GoogleIamV1TestIamPermissionsRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$resource') + ':testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1TestIamPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsLakesResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsLakesActionsResource get actions =>
      ProjectsLocationsLakesActionsResource(_requester);
  ProjectsLocationsLakesContentResource get content =>
      ProjectsLocationsLakesContentResource(_requester);
  ProjectsLocationsLakesContentitemsResource get contentitems =>
      ProjectsLocationsLakesContentitemsResource(_requester);
  ProjectsLocationsLakesEnvironmentsResource get environments =>
      ProjectsLocationsLakesEnvironmentsResource(_requester);
  ProjectsLocationsLakesTasksResource get tasks =>
      ProjectsLocationsLakesTasksResource(_requester);
  ProjectsLocationsLakesZonesResource get zones =>
      ProjectsLocationsLakesZonesResource(_requester);

  ProjectsLocationsLakesResource(commons.ApiRequester client)
      : _requester = client;

  /// Creates a lake resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the lake location, of the form:
  /// projects/{project_number}/locations/{location_id} where location_id refers
  /// to a GCP region.
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [lakeId] - Required. Lake identifier. This ID will be used to generate
  /// names such as database and dataset names when publishing metadata to Hive
  /// Metastore and BigQuery. * Must contain only lowercase letters, numbers and
  /// hyphens. * Must start with a letter. * Must end with a number or a letter.
  /// * Must be between 1-63 characters. * Must be unique within the customer
  /// project / location.
  ///
  /// [validateOnly] - Optional. Only validate the request, but do not perform
  /// mutations. The default is false.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> create(
    GoogleCloudDataplexV1Lake request,
    core.String parent, {
    core.String? lakeId,
    core.bool? validateOnly,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (lakeId != null) 'lakeId': [lakeId],
      if (validateOnly != null) 'validateOnly': ['${validateOnly}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/lakes';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a lake resource.
  ///
  /// All zones within the lake must be deleted before the lake can be deleted.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the lake:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves a lake resource.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the lake:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1Lake].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1Lake> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1Lake.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the access control policy for a resource.
  ///
  /// Returns an empty policy if the resource exists and does not have a policy
  /// set.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+$`.
  ///
  /// [options_requestedPolicyVersion] - Optional. The maximum policy version
  /// that will be used to format the policy.Valid values are 0, 1, and 3.
  /// Requests specifying an invalid value will be rejected.Requests for
  /// policies with any conditional role bindings must specify version 3.
  /// Policies with no conditional role bindings may specify any valid value or
  /// leave the field unset.The policy in the response might use the policy
  /// version that you specified, or it might use a lower policy version. For
  /// example, if you specify version 3, but the policy has no conditional role
  /// bindings, the response uses version 1.To learn which resources support
  /// conditions in their IAM policies, see the IAM documentation
  /// (https://cloud.google.com/iam/help/conditions/resource-policies).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> getIamPolicy(
    core.String resource, {
    core.int? options_requestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (options_requestedPolicyVersion != null)
        'options.requestedPolicyVersion': ['${options_requestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists lake resources in a project and location.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the lake location, of the form:
  /// projects/{project_number}/locations/{location_id} where location_id refers
  /// to a GCP region.
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [filter] - Optional. Filter request.
  ///
  /// [orderBy] - Optional. Order by fields for the result.
  ///
  /// [pageSize] - Optional. Maximum number of Lakes to return. The service may
  /// return fewer than this value. If unspecified, at most 10 lakes will be
  /// returned. The maximum value is 1000; values above 1000 will be coerced to
  /// 1000.
  ///
  /// [pageToken] - Optional. Page token received from a previous ListLakes
  /// call. Provide this to retrieve the subsequent page. When paginating, all
  /// other parameters provided to ListLakes must match the call that provided
  /// the page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1ListLakesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1ListLakesResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/lakes';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1ListLakesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates a lake resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Output only. The relative resource name of the lake, of the form:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+$`.
  ///
  /// [updateMask] - Required. Mask of fields to update.
  ///
  /// [validateOnly] - Optional. Only validate the request, but do not perform
  /// mutations. The default is false.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> patch(
    GoogleCloudDataplexV1Lake request,
    core.String name, {
    core.String? updateMask,
    core.bool? validateOnly,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if (validateOnly != null) 'validateOnly': ['${validateOnly}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified resource.
  ///
  /// Replaces any existing policy.Can return NOT_FOUND, INVALID_ARGUMENT, and
  /// PERMISSION_DENIED errors.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// specified. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> setIamPolicy(
    GoogleIamV1SetIamPolicyRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// If the resource does not exist, this will return an empty set of
  /// permissions, not a NOT_FOUND error.Note: This operation is designed to be
  /// used for building permission-aware UIs and command-line tools, not for
  /// authorization checking. This operation may "fail open" without warning.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy detail is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1TestIamPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1TestIamPermissionsResponse> testIamPermissions(
    GoogleIamV1TestIamPermissionsRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$resource') + ':testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1TestIamPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsLakesActionsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsLakesActionsResource(commons.ApiRequester client)
      : _requester = client;

  /// Lists action resources in a lake.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the parent lake:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+$`.
  ///
  /// [pageSize] - Optional. Maximum number of actions to return. The service
  /// may return fewer than this value. If unspecified, at most 10 actions will
  /// be returned. The maximum value is 1000; values above 1000 will be coerced
  /// to 1000.
  ///
  /// [pageToken] - Optional. Page token received from a previous
  /// ListLakeActions call. Provide this to retrieve the subsequent page. When
  /// paginating, all other parameters provided to ListLakeActions must match
  /// the call that provided the page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1ListActionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1ListActionsResponse> list(
    core.String parent, {
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/actions';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1ListActionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsLakesContentResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsLakesContentResource(commons.ApiRequester client)
      : _requester = client;

  /// Create a content.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the parent lake:
  /// projects/{project_id}/locations/{location_id}/lakes/{lake_id}
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+$`.
  ///
  /// [validateOnly] - Optional. Only validate the request, but do not perform
  /// mutations. The default is false.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1Content].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1Content> create(
    GoogleCloudDataplexV1Content request,
    core.String parent, {
    core.bool? validateOnly,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (validateOnly != null) 'validateOnly': ['${validateOnly}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/content';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1Content.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Delete a content.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the content:
  /// projects/{project_id}/locations/{location_id}/lakes/{lake_id}/content/{content_id}
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/content/.*$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Empty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Empty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Empty.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Get a content resource.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the content:
  /// projects/{project_id}/locations/{location_id}/lakes/{lake_id}/content/{content_id}
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/content/.*$`.
  ///
  /// [view] - Optional. Specify content view to make a partial request.
  /// Possible string values are:
  /// - "CONTENT_VIEW_UNSPECIFIED" : Content view not specified. Defaults to
  /// BASIC. The API will default to the BASIC view.
  /// - "BASIC" : Will not return the data_text field.
  /// - "FULL" : Returns the complete proto.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1Content].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1Content> get(
    core.String name, {
    core.String? view,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (view != null) 'view': [view],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1Content.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the access control policy for a contentitem resource.
  ///
  /// A NOT_FOUND error is returned if the resource does not exist. An empty
  /// policy is returned if the resource exists but does not have a policy set
  /// on it.Caller must have Google IAM dataplex.content.getIamPolicy permission
  /// on the resource.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/content/.*$`.
  ///
  /// [options_requestedPolicyVersion] - Optional. The maximum policy version
  /// that will be used to format the policy.Valid values are 0, 1, and 3.
  /// Requests specifying an invalid value will be rejected.Requests for
  /// policies with any conditional role bindings must specify version 3.
  /// Policies with no conditional role bindings may specify any valid value or
  /// leave the field unset.The policy in the response might use the policy
  /// version that you specified, or it might use a lower policy version. For
  /// example, if you specify version 3, but the policy has no conditional role
  /// bindings, the response uses version 1.To learn which resources support
  /// conditions in their IAM policies, see the IAM documentation
  /// (https://cloud.google.com/iam/help/conditions/resource-policies).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> getIamPolicy(
    core.String resource, {
    core.int? options_requestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (options_requestedPolicyVersion != null)
        'options.requestedPolicyVersion': ['${options_requestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// List content.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the parent lake:
  /// projects/{project_id}/locations/{location_id}/lakes/{lake_id}
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+$`.
  ///
  /// [filter] - Optional. Filter request. Filters are case-sensitive. The
  /// following formats are supported:labels.key1 = "value1" labels:key1 type =
  /// "NOTEBOOK" type = "SQL_SCRIPT"These restrictions can be coinjoined with
  /// AND, OR and NOT conjunctions.
  ///
  /// [pageSize] - Optional. Maximum number of content to return. The service
  /// may return fewer than this value. If unspecified, at most 10 content will
  /// be returned. The maximum value is 1000; values above 1000 will be coerced
  /// to 1000.
  ///
  /// [pageToken] - Optional. Page token received from a previous ListContent
  /// call. Provide this to retrieve the subsequent page. When paginating, all
  /// other parameters provided to ListContent must match the call that provided
  /// the page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1ListContentResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1ListContentResponse> list(
    core.String parent, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/content';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1ListContentResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Update a content.
  ///
  /// Only supports full resource update.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Output only. The relative resource name of the content, of the
  /// form:
  /// projects/{project_id}/locations/{location_id}/lakes/{lake_id}/content/{content_id}
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/content/.*$`.
  ///
  /// [updateMask] - Required. Mask of fields to update.
  ///
  /// [validateOnly] - Optional. Only validate the request, but do not perform
  /// mutations. The default is false.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1Content].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1Content> patch(
    GoogleCloudDataplexV1Content request,
    core.String name, {
    core.String? updateMask,
    core.bool? validateOnly,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if (validateOnly != null) 'validateOnly': ['${validateOnly}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1Content.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified contentitem resource.
  ///
  /// Replaces any existing policy.Caller must have Google IAM
  /// dataplex.content.setIamPolicy permission on the resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// specified. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/content/.*$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> setIamPolicy(
    GoogleIamV1SetIamPolicyRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the caller's permissions on a resource.
  ///
  /// If the resource does not exist, an empty set of permissions is returned (a
  /// NOT_FOUND error is not returned).A caller is not required to have Google
  /// IAM permission to make this request.Note: This operation is designed to be
  /// used for building permission-aware UIs and command-line tools, not for
  /// authorization checking. This operation may "fail open" without warning.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy detail is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/content/.*$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1TestIamPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1TestIamPermissionsResponse> testIamPermissions(
    GoogleIamV1TestIamPermissionsRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$resource') + ':testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1TestIamPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsLakesContentitemsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsLakesContentitemsResource(commons.ApiRequester client)
      : _requester = client;

  /// Create a content.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the parent lake:
  /// projects/{project_id}/locations/{location_id}/lakes/{lake_id}
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+$`.
  ///
  /// [validateOnly] - Optional. Only validate the request, but do not perform
  /// mutations. The default is false.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1Content].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1Content> create(
    GoogleCloudDataplexV1Content request,
    core.String parent, {
    core.bool? validateOnly,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (validateOnly != null) 'validateOnly': ['${validateOnly}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/contentitems';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1Content.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Delete a content.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the content:
  /// projects/{project_id}/locations/{location_id}/lakes/{lake_id}/content/{content_id}
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/contentitems/.*$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Empty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Empty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Empty.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Get a content resource.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the content:
  /// projects/{project_id}/locations/{location_id}/lakes/{lake_id}/content/{content_id}
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/contentitems/.*$`.
  ///
  /// [view] - Optional. Specify content view to make a partial request.
  /// Possible string values are:
  /// - "CONTENT_VIEW_UNSPECIFIED" : Content view not specified. Defaults to
  /// BASIC. The API will default to the BASIC view.
  /// - "BASIC" : Will not return the data_text field.
  /// - "FULL" : Returns the complete proto.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1Content].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1Content> get(
    core.String name, {
    core.String? view,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (view != null) 'view': [view],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1Content.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the access control policy for a contentitem resource.
  ///
  /// A NOT_FOUND error is returned if the resource does not exist. An empty
  /// policy is returned if the resource exists but does not have a policy set
  /// on it.Caller must have Google IAM dataplex.content.getIamPolicy permission
  /// on the resource.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/contentitems/.*$`.
  ///
  /// [options_requestedPolicyVersion] - Optional. The maximum policy version
  /// that will be used to format the policy.Valid values are 0, 1, and 3.
  /// Requests specifying an invalid value will be rejected.Requests for
  /// policies with any conditional role bindings must specify version 3.
  /// Policies with no conditional role bindings may specify any valid value or
  /// leave the field unset.The policy in the response might use the policy
  /// version that you specified, or it might use a lower policy version. For
  /// example, if you specify version 3, but the policy has no conditional role
  /// bindings, the response uses version 1.To learn which resources support
  /// conditions in their IAM policies, see the IAM documentation
  /// (https://cloud.google.com/iam/help/conditions/resource-policies).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> getIamPolicy(
    core.String resource, {
    core.int? options_requestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (options_requestedPolicyVersion != null)
        'options.requestedPolicyVersion': ['${options_requestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// List content.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the parent lake:
  /// projects/{project_id}/locations/{location_id}/lakes/{lake_id}
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+$`.
  ///
  /// [filter] - Optional. Filter request. Filters are case-sensitive. The
  /// following formats are supported:labels.key1 = "value1" labels:key1 type =
  /// "NOTEBOOK" type = "SQL_SCRIPT"These restrictions can be coinjoined with
  /// AND, OR and NOT conjunctions.
  ///
  /// [pageSize] - Optional. Maximum number of content to return. The service
  /// may return fewer than this value. If unspecified, at most 10 content will
  /// be returned. The maximum value is 1000; values above 1000 will be coerced
  /// to 1000.
  ///
  /// [pageToken] - Optional. Page token received from a previous ListContent
  /// call. Provide this to retrieve the subsequent page. When paginating, all
  /// other parameters provided to ListContent must match the call that provided
  /// the page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1ListContentResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1ListContentResponse> list(
    core.String parent, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/contentitems';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1ListContentResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Update a content.
  ///
  /// Only supports full resource update.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Output only. The relative resource name of the content, of the
  /// form:
  /// projects/{project_id}/locations/{location_id}/lakes/{lake_id}/content/{content_id}
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/contentitems/.*$`.
  ///
  /// [updateMask] - Required. Mask of fields to update.
  ///
  /// [validateOnly] - Optional. Only validate the request, but do not perform
  /// mutations. The default is false.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1Content].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1Content> patch(
    GoogleCloudDataplexV1Content request,
    core.String name, {
    core.String? updateMask,
    core.bool? validateOnly,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if (validateOnly != null) 'validateOnly': ['${validateOnly}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1Content.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified contentitem resource.
  ///
  /// Replaces any existing policy.Caller must have Google IAM
  /// dataplex.content.setIamPolicy permission on the resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// specified. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/contentitems/.*$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> setIamPolicy(
    GoogleIamV1SetIamPolicyRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the caller's permissions on a resource.
  ///
  /// If the resource does not exist, an empty set of permissions is returned (a
  /// NOT_FOUND error is not returned).A caller is not required to have Google
  /// IAM permission to make this request.Note: This operation is designed to be
  /// used for building permission-aware UIs and command-line tools, not for
  /// authorization checking. This operation may "fail open" without warning.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy detail is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/contentitems/.*$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1TestIamPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1TestIamPermissionsResponse> testIamPermissions(
    GoogleIamV1TestIamPermissionsRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$resource') + ':testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1TestIamPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsLakesEnvironmentsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsLakesEnvironmentsSessionsResource get sessions =>
      ProjectsLocationsLakesEnvironmentsSessionsResource(_requester);

  ProjectsLocationsLakesEnvironmentsResource(commons.ApiRequester client)
      : _requester = client;

  /// Create an environment resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the parent lake:
  /// projects/{project_id}/locations/{location_id}/lakes/{lake_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+$`.
  ///
  /// [environmentId] - Required. Environment identifier. * Must contain only
  /// lowercase letters, numbers and hyphens. * Must start with a letter. * Must
  /// be between 1-63 characters. * Must end with a number or a letter. * Must
  /// be unique within the lake.
  ///
  /// [validateOnly] - Optional. Only validate the request, but do not perform
  /// mutations. The default is false.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> create(
    GoogleCloudDataplexV1Environment request,
    core.String parent, {
    core.String? environmentId,
    core.bool? validateOnly,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (environmentId != null) 'environmentId': [environmentId],
      if (validateOnly != null) 'validateOnly': ['${validateOnly}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/environments';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Delete the environment resource.
  ///
  /// All the child resources must have been deleted before environment deletion
  /// can be initiated.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the environment:
  /// projects/{project_id}/locations/{location_id}/lakes/{lake_id}/environments/{environment_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/environments/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Get environment resource.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the environment:
  /// projects/{project_id}/locations/{location_id}/lakes/{lake_id}/environments/{environment_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/environments/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1Environment].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1Environment> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1Environment.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the access control policy for a resource.
  ///
  /// Returns an empty policy if the resource exists and does not have a policy
  /// set.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/environments/\[^/\]+$`.
  ///
  /// [options_requestedPolicyVersion] - Optional. The maximum policy version
  /// that will be used to format the policy.Valid values are 0, 1, and 3.
  /// Requests specifying an invalid value will be rejected.Requests for
  /// policies with any conditional role bindings must specify version 3.
  /// Policies with no conditional role bindings may specify any valid value or
  /// leave the field unset.The policy in the response might use the policy
  /// version that you specified, or it might use a lower policy version. For
  /// example, if you specify version 3, but the policy has no conditional role
  /// bindings, the response uses version 1.To learn which resources support
  /// conditions in their IAM policies, see the IAM documentation
  /// (https://cloud.google.com/iam/help/conditions/resource-policies).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> getIamPolicy(
    core.String resource, {
    core.int? options_requestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (options_requestedPolicyVersion != null)
        'options.requestedPolicyVersion': ['${options_requestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists environments under the given lake.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the parent lake:
  /// projects/{project_id}/locations/{location_id}/lakes/{lake_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+$`.
  ///
  /// [filter] - Optional. Filter request.
  ///
  /// [orderBy] - Optional. Order by fields for the result.
  ///
  /// [pageSize] - Optional. Maximum number of environments to return. The
  /// service may return fewer than this value. If unspecified, at most 10
  /// environments will be returned. The maximum value is 1000; values above
  /// 1000 will be coerced to 1000.
  ///
  /// [pageToken] - Optional. Page token received from a previous
  /// ListEnvironments call. Provide this to retrieve the subsequent page. When
  /// paginating, all other parameters provided to ListEnvironments must match
  /// the call that provided the page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1ListEnvironmentsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1ListEnvironmentsResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/environments';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1ListEnvironmentsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Update the environment resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Output only. The relative resource name of the environment, of
  /// the form:
  /// projects/{project_id}/locations/{location_id}/lakes/{lake_id}/environment/{environment_id}
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/environments/\[^/\]+$`.
  ///
  /// [updateMask] - Required. Mask of fields to update.
  ///
  /// [validateOnly] - Optional. Only validate the request, but do not perform
  /// mutations. The default is false.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> patch(
    GoogleCloudDataplexV1Environment request,
    core.String name, {
    core.String? updateMask,
    core.bool? validateOnly,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if (validateOnly != null) 'validateOnly': ['${validateOnly}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified resource.
  ///
  /// Replaces any existing policy.Can return NOT_FOUND, INVALID_ARGUMENT, and
  /// PERMISSION_DENIED errors.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// specified. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/environments/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> setIamPolicy(
    GoogleIamV1SetIamPolicyRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// If the resource does not exist, this will return an empty set of
  /// permissions, not a NOT_FOUND error.Note: This operation is designed to be
  /// used for building permission-aware UIs and command-line tools, not for
  /// authorization checking. This operation may "fail open" without warning.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy detail is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/environments/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1TestIamPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1TestIamPermissionsResponse> testIamPermissions(
    GoogleIamV1TestIamPermissionsRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$resource') + ':testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1TestIamPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsLakesEnvironmentsSessionsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsLakesEnvironmentsSessionsResource(
      commons.ApiRequester client)
      : _requester = client;

  /// Lists session resources in an environment.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the parent environment:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/environment/{environment_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/environments/\[^/\]+$`.
  ///
  /// [filter] - Optional. Filter request. The following mode filter is
  /// supported to return only the sessions belonging to the requester when the
  /// mode is USER and return sessions of all the users when the mode is ADMIN.
  /// When no filter is sent default to USER mode. NOTE: When the mode is ADMIN,
  /// the requester should have dataplex.environments.listAllSessions permission
  /// to list all sessions, in absence of the permission, the request fails.mode
  /// = ADMIN | USER
  ///
  /// [pageSize] - Optional. Maximum number of sessions to return. The service
  /// may return fewer than this value. If unspecified, at most 10 sessions will
  /// be returned. The maximum value is 1000; values above 1000 will be coerced
  /// to 1000.
  ///
  /// [pageToken] - Optional. Page token received from a previous ListSessions
  /// call. Provide this to retrieve the subsequent page. When paginating, all
  /// other parameters provided to ListSessions must match the call that
  /// provided the page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1ListSessionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1ListSessionsResponse> list(
    core.String parent, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/sessions';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1ListSessionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsLakesTasksResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsLakesTasksJobsResource get jobs =>
      ProjectsLocationsLakesTasksJobsResource(_requester);

  ProjectsLocationsLakesTasksResource(commons.ApiRequester client)
      : _requester = client;

  /// Creates a task resource within a lake.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the parent lake:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+$`.
  ///
  /// [taskId] - Required. Task identifier.
  ///
  /// [validateOnly] - Optional. Only validate the request, but do not perform
  /// mutations. The default is false.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> create(
    GoogleCloudDataplexV1Task request,
    core.String parent, {
    core.String? taskId,
    core.bool? validateOnly,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (taskId != null) 'taskId': [taskId],
      if (validateOnly != null) 'validateOnly': ['${validateOnly}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/tasks';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Delete the task resource.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the task:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/task/{task_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/tasks/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Get task resource.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the task:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/tasks/{tasks_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/tasks/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1Task].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1Task> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1Task.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the access control policy for a resource.
  ///
  /// Returns an empty policy if the resource exists and does not have a policy
  /// set.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/tasks/\[^/\]+$`.
  ///
  /// [options_requestedPolicyVersion] - Optional. The maximum policy version
  /// that will be used to format the policy.Valid values are 0, 1, and 3.
  /// Requests specifying an invalid value will be rejected.Requests for
  /// policies with any conditional role bindings must specify version 3.
  /// Policies with no conditional role bindings may specify any valid value or
  /// leave the field unset.The policy in the response might use the policy
  /// version that you specified, or it might use a lower policy version. For
  /// example, if you specify version 3, but the policy has no conditional role
  /// bindings, the response uses version 1.To learn which resources support
  /// conditions in their IAM policies, see the IAM documentation
  /// (https://cloud.google.com/iam/help/conditions/resource-policies).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> getIamPolicy(
    core.String resource, {
    core.int? options_requestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (options_requestedPolicyVersion != null)
        'options.requestedPolicyVersion': ['${options_requestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists tasks under the given lake.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the parent lake:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+$`.
  ///
  /// [filter] - Optional. Filter request.
  ///
  /// [orderBy] - Optional. Order by fields for the result.
  ///
  /// [pageSize] - Optional. Maximum number of tasks to return. The service may
  /// return fewer than this value. If unspecified, at most 10 tasks will be
  /// returned. The maximum value is 1000; values above 1000 will be coerced to
  /// 1000.
  ///
  /// [pageToken] - Optional. Page token received from a previous ListZones
  /// call. Provide this to retrieve the subsequent page. When paginating, all
  /// other parameters provided to ListZones must match the call that provided
  /// the page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1ListTasksResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1ListTasksResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/tasks';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1ListTasksResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Update the task resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Output only. The relative resource name of the task, of the form:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/
  /// tasks/{task_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/tasks/\[^/\]+$`.
  ///
  /// [updateMask] - Required. Mask of fields to update.
  ///
  /// [validateOnly] - Optional. Only validate the request, but do not perform
  /// mutations. The default is false.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> patch(
    GoogleCloudDataplexV1Task request,
    core.String name, {
    core.String? updateMask,
    core.bool? validateOnly,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if (validateOnly != null) 'validateOnly': ['${validateOnly}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Run an on demand execution of a Task.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the task:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/tasks/{task_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/tasks/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1RunTaskResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1RunTaskResponse> run(
    GoogleCloudDataplexV1RunTaskRequest request,
    core.String name, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':run';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1RunTaskResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified resource.
  ///
  /// Replaces any existing policy.Can return NOT_FOUND, INVALID_ARGUMENT, and
  /// PERMISSION_DENIED errors.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// specified. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/tasks/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> setIamPolicy(
    GoogleIamV1SetIamPolicyRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// If the resource does not exist, this will return an empty set of
  /// permissions, not a NOT_FOUND error.Note: This operation is designed to be
  /// used for building permission-aware UIs and command-line tools, not for
  /// authorization checking. This operation may "fail open" without warning.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy detail is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/tasks/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1TestIamPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1TestIamPermissionsResponse> testIamPermissions(
    GoogleIamV1TestIamPermissionsRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$resource') + ':testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1TestIamPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsLakesTasksJobsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsLakesTasksJobsResource(commons.ApiRequester client)
      : _requester = client;

  /// Cancel jobs running for the task resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the job:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/task/{task_id}/job/{job_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/tasks/\[^/\]+/jobs/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Empty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Empty> cancel(
    GoogleCloudDataplexV1CancelJobRequest request,
    core.String name, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Empty.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Get job resource.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the job:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/tasks/{task_id}/jobs/{job_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/tasks/\[^/\]+/jobs/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1Job].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1Job> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1Job.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists Jobs under the given task.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the parent environment:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/tasks/{task_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/tasks/\[^/\]+$`.
  ///
  /// [pageSize] - Optional. Maximum number of jobs to return. The service may
  /// return fewer than this value. If unspecified, at most 10 jobs will be
  /// returned. The maximum value is 1000; values above 1000 will be coerced to
  /// 1000.
  ///
  /// [pageToken] - Optional. Page token received from a previous ListJobs call.
  /// Provide this to retrieve the subsequent page. When paginating, all other
  /// parameters provided to ListJobs must match the call that provided the page
  /// token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1ListJobsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1ListJobsResponse> list(
    core.String parent, {
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/jobs';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1ListJobsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsLakesZonesResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsLakesZonesActionsResource get actions =>
      ProjectsLocationsLakesZonesActionsResource(_requester);
  ProjectsLocationsLakesZonesAssetsResource get assets =>
      ProjectsLocationsLakesZonesAssetsResource(_requester);
  ProjectsLocationsLakesZonesEntitiesResource get entities =>
      ProjectsLocationsLakesZonesEntitiesResource(_requester);

  ProjectsLocationsLakesZonesResource(commons.ApiRequester client)
      : _requester = client;

  /// Creates a zone resource within a lake.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the parent lake:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+$`.
  ///
  /// [validateOnly] - Optional. Only validate the request, but do not perform
  /// mutations. The default is false.
  ///
  /// [zoneId] - Required. Zone identifier. This ID will be used to generate
  /// names such as database and dataset names when publishing metadata to Hive
  /// Metastore and BigQuery. * Must contain only lowercase letters, numbers and
  /// hyphens. * Must start with a letter. * Must end with a number or a letter.
  /// * Must be between 1-63 characters. * Must be unique across all lakes from
  /// all locations in a project. * Must not be one of the reserved IDs (i.e.
  /// "default", "global-temp")
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> create(
    GoogleCloudDataplexV1Zone request,
    core.String parent, {
    core.bool? validateOnly,
    core.String? zoneId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (validateOnly != null) 'validateOnly': ['${validateOnly}'],
      if (zoneId != null) 'zoneId': [zoneId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/zones';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a zone resource.
  ///
  /// All assets within a zone must be deleted before the zone can be deleted.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the zone:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/zones/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves a zone resource.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the zone:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/zones/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1Zone].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1Zone> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1Zone.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the access control policy for a resource.
  ///
  /// Returns an empty policy if the resource exists and does not have a policy
  /// set.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/zones/\[^/\]+$`.
  ///
  /// [options_requestedPolicyVersion] - Optional. The maximum policy version
  /// that will be used to format the policy.Valid values are 0, 1, and 3.
  /// Requests specifying an invalid value will be rejected.Requests for
  /// policies with any conditional role bindings must specify version 3.
  /// Policies with no conditional role bindings may specify any valid value or
  /// leave the field unset.The policy in the response might use the policy
  /// version that you specified, or it might use a lower policy version. For
  /// example, if you specify version 3, but the policy has no conditional role
  /// bindings, the response uses version 1.To learn which resources support
  /// conditions in their IAM policies, see the IAM documentation
  /// (https://cloud.google.com/iam/help/conditions/resource-policies).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> getIamPolicy(
    core.String resource, {
    core.int? options_requestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (options_requestedPolicyVersion != null)
        'options.requestedPolicyVersion': ['${options_requestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists zone resources in a lake.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the parent lake:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+$`.
  ///
  /// [filter] - Optional. Filter request.
  ///
  /// [orderBy] - Optional. Order by fields for the result.
  ///
  /// [pageSize] - Optional. Maximum number of zones to return. The service may
  /// return fewer than this value. If unspecified, at most 10 zones will be
  /// returned. The maximum value is 1000; values above 1000 will be coerced to
  /// 1000.
  ///
  /// [pageToken] - Optional. Page token received from a previous ListZones
  /// call. Provide this to retrieve the subsequent page. When paginating, all
  /// other parameters provided to ListZones must match the call that provided
  /// the page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1ListZonesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1ListZonesResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/zones';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1ListZonesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates a zone resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Output only. The relative resource name of the zone, of the form:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/zones/\[^/\]+$`.
  ///
  /// [updateMask] - Required. Mask of fields to update.
  ///
  /// [validateOnly] - Optional. Only validate the request, but do not perform
  /// mutations. The default is false.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> patch(
    GoogleCloudDataplexV1Zone request,
    core.String name, {
    core.String? updateMask,
    core.bool? validateOnly,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if (validateOnly != null) 'validateOnly': ['${validateOnly}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified resource.
  ///
  /// Replaces any existing policy.Can return NOT_FOUND, INVALID_ARGUMENT, and
  /// PERMISSION_DENIED errors.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// specified. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/zones/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> setIamPolicy(
    GoogleIamV1SetIamPolicyRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// If the resource does not exist, this will return an empty set of
  /// permissions, not a NOT_FOUND error.Note: This operation is designed to be
  /// used for building permission-aware UIs and command-line tools, not for
  /// authorization checking. This operation may "fail open" without warning.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy detail is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/zones/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1TestIamPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1TestIamPermissionsResponse> testIamPermissions(
    GoogleIamV1TestIamPermissionsRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$resource') + ':testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1TestIamPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsLakesZonesActionsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsLakesZonesActionsResource(commons.ApiRequester client)
      : _requester = client;

  /// Lists action resources in a zone.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the parent zone:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/zones/\[^/\]+$`.
  ///
  /// [pageSize] - Optional. Maximum number of actions to return. The service
  /// may return fewer than this value. If unspecified, at most 10 actions will
  /// be returned. The maximum value is 1000; values above 1000 will be coerced
  /// to 1000.
  ///
  /// [pageToken] - Optional. Page token received from a previous
  /// ListZoneActions call. Provide this to retrieve the subsequent page. When
  /// paginating, all other parameters provided to ListZoneActions must match
  /// the call that provided the page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1ListActionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1ListActionsResponse> list(
    core.String parent, {
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/actions';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1ListActionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsLakesZonesAssetsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsLakesZonesAssetsActionsResource get actions =>
      ProjectsLocationsLakesZonesAssetsActionsResource(_requester);

  ProjectsLocationsLakesZonesAssetsResource(commons.ApiRequester client)
      : _requester = client;

  /// Creates an asset resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the parent zone:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/zones/\[^/\]+$`.
  ///
  /// [assetId] - Required. Asset identifier. This ID will be used to generate
  /// names such as table names when publishing metadata to Hive Metastore and
  /// BigQuery. * Must contain only lowercase letters, numbers and hyphens. *
  /// Must start with a letter. * Must end with a number or a letter. * Must be
  /// between 1-63 characters. * Must be unique within the zone.
  ///
  /// [validateOnly] - Optional. Only validate the request, but do not perform
  /// mutations. The default is false.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> create(
    GoogleCloudDataplexV1Asset request,
    core.String parent, {
    core.String? assetId,
    core.bool? validateOnly,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (assetId != null) 'assetId': [assetId],
      if (validateOnly != null) 'validateOnly': ['${validateOnly}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/assets';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes an asset resource.
  ///
  /// The referenced storage resource is detached (default) or deleted based on
  /// the associated Lifecycle policy.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the asset:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/assets/{asset_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/zones/\[^/\]+/assets/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves an asset resource.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the asset:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/assets/{asset_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/zones/\[^/\]+/assets/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1Asset].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1Asset> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1Asset.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the access control policy for a resource.
  ///
  /// Returns an empty policy if the resource exists and does not have a policy
  /// set.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/zones/\[^/\]+/assets/\[^/\]+$`.
  ///
  /// [options_requestedPolicyVersion] - Optional. The maximum policy version
  /// that will be used to format the policy.Valid values are 0, 1, and 3.
  /// Requests specifying an invalid value will be rejected.Requests for
  /// policies with any conditional role bindings must specify version 3.
  /// Policies with no conditional role bindings may specify any valid value or
  /// leave the field unset.The policy in the response might use the policy
  /// version that you specified, or it might use a lower policy version. For
  /// example, if you specify version 3, but the policy has no conditional role
  /// bindings, the response uses version 1.To learn which resources support
  /// conditions in their IAM policies, see the IAM documentation
  /// (https://cloud.google.com/iam/help/conditions/resource-policies).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> getIamPolicy(
    core.String resource, {
    core.int? options_requestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (options_requestedPolicyVersion != null)
        'options.requestedPolicyVersion': ['${options_requestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists asset resources in a zone.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the parent zone:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/zones/\[^/\]+$`.
  ///
  /// [filter] - Optional. Filter request.
  ///
  /// [orderBy] - Optional. Order by fields for the result.
  ///
  /// [pageSize] - Optional. Maximum number of asset to return. The service may
  /// return fewer than this value. If unspecified, at most 10 assets will be
  /// returned. The maximum value is 1000; values above 1000 will be coerced to
  /// 1000.
  ///
  /// [pageToken] - Optional. Page token received from a previous ListAssets
  /// call. Provide this to retrieve the subsequent page. When paginating, all
  /// other parameters provided to ListAssets must match the call that provided
  /// the page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1ListAssetsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1ListAssetsResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/assets';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1ListAssetsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates an asset resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Output only. The relative resource name of the asset, of the
  /// form:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/assets/{asset_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/zones/\[^/\]+/assets/\[^/\]+$`.
  ///
  /// [updateMask] - Required. Mask of fields to update.
  ///
  /// [validateOnly] - Optional. Only validate the request, but do not perform
  /// mutations. The default is false.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> patch(
    GoogleCloudDataplexV1Asset request,
    core.String name, {
    core.String? updateMask,
    core.bool? validateOnly,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if (validateOnly != null) 'validateOnly': ['${validateOnly}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified resource.
  ///
  /// Replaces any existing policy.Can return NOT_FOUND, INVALID_ARGUMENT, and
  /// PERMISSION_DENIED errors.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// specified. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/zones/\[^/\]+/assets/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> setIamPolicy(
    GoogleIamV1SetIamPolicyRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// If the resource does not exist, this will return an empty set of
  /// permissions, not a NOT_FOUND error.Note: This operation is designed to be
  /// used for building permission-aware UIs and command-line tools, not for
  /// authorization checking. This operation may "fail open" without warning.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy detail is being
  /// requested. See Resource names
  /// (https://cloud.google.com/apis/design/resource_names) for the appropriate
  /// value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/zones/\[^/\]+/assets/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1TestIamPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1TestIamPermissionsResponse> testIamPermissions(
    GoogleIamV1TestIamPermissionsRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$resource') + ':testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1TestIamPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsLakesZonesAssetsActionsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsLakesZonesAssetsActionsResource(commons.ApiRequester client)
      : _requester = client;

  /// Lists action resources in an asset.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the parent asset:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/assets/{asset_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/zones/\[^/\]+/assets/\[^/\]+$`.
  ///
  /// [pageSize] - Optional. Maximum number of actions to return. The service
  /// may return fewer than this value. If unspecified, at most 10 actions will
  /// be returned. The maximum value is 1000; values above 1000 will be coerced
  /// to 1000.
  ///
  /// [pageToken] - Optional. Page token received from a previous
  /// ListAssetActions call. Provide this to retrieve the subsequent page. When
  /// paginating, all other parameters provided to ListAssetActions must match
  /// the call that provided the page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1ListActionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1ListActionsResponse> list(
    core.String parent, {
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/actions';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1ListActionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsLakesZonesEntitiesResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsLakesZonesEntitiesPartitionsResource get partitions =>
      ProjectsLocationsLakesZonesEntitiesPartitionsResource(_requester);

  ProjectsLocationsLakesZonesEntitiesResource(commons.ApiRequester client)
      : _requester = client;

  /// Create a metadata entity.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the parent zone:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/zones/\[^/\]+$`.
  ///
  /// [validateOnly] - Optional. Only validate the request, but do not perform
  /// mutations. The default is false.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1Entity].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1Entity> create(
    GoogleCloudDataplexV1Entity request,
    core.String parent, {
    core.bool? validateOnly,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (validateOnly != null) 'validateOnly': ['${validateOnly}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/entities';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1Entity.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Delete a metadata entity.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the entity:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{entity_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/zones/\[^/\]+/entities/\[^/\]+$`.
  ///
  /// [etag] - Required. The etag associated with the entity, which can be
  /// retrieved with a GetEntity request.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Empty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Empty> delete(
    core.String name, {
    core.String? etag,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (etag != null) 'etag': [etag],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Empty.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Get a metadata entity.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the entity:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{entity_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/zones/\[^/\]+/entities/\[^/\]+$`.
  ///
  /// [view] - Optional. Used to select the subset of entity information to
  /// return. Defaults to BASIC.
  /// Possible string values are:
  /// - "ENTITY_VIEW_UNSPECIFIED" : The API will default to the BASIC view.
  /// - "BASIC" : Minimal view that does not include the schema.
  /// - "SCHEMA" : Include basic information and schema.
  /// - "FULL" : Include everything. Currently, this is the same as the SCHEMA
  /// view.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1Entity].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1Entity> get(
    core.String name, {
    core.String? view,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (view != null) 'view': [view],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1Entity.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// List metadata entities in a zone.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the parent zone:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/zones/\[^/\]+$`.
  ///
  /// [filter] - Optional. The following filter parameters can be added to the
  /// URL to limit the entities returned by the API: Entity ID:
  /// ?filter="id=entityID" Asset ID: ?filter="asset=assetID" Data path
  /// ?filter="data_path=gs://my-bucket" Is HIVE compatible:
  /// ?filter="hive_compatible=true" Is BigQuery compatible:
  /// ?filter="bigquery_compatible=true"
  ///
  /// [pageSize] - Optional. Maximum number of entities to return. The service
  /// may return fewer than this value. If unspecified, 100 entities will be
  /// returned by default. The maximum value is 500; larger values will will be
  /// truncated to 500.
  ///
  /// [pageToken] - Optional. Page token received from a previous ListEntities
  /// call. Provide this to retrieve the subsequent page. When paginating, all
  /// other parameters provided to ListEntities must match the call that
  /// provided the page token.
  ///
  /// [view] - Required. Specify the entity view to make a partial list request.
  /// Possible string values are:
  /// - "ENTITY_VIEW_UNSPECIFIED" : The default unset value. Return both table
  /// and fileset entities if unspecified.
  /// - "TABLES" : Only list table entities.
  /// - "FILESETS" : Only list fileset entities.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1ListEntitiesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1ListEntitiesResponse> list(
    core.String parent, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? view,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (view != null) 'view': [view],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/entities';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1ListEntitiesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Update a metadata entity.
  ///
  /// Only supports full resource update.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Output only. The resource name of the entity, of the form:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/zones/\[^/\]+/entities/\[^/\]+$`.
  ///
  /// [validateOnly] - Optional. Only validate the request, but do not perform
  /// mutations. The default is false.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1Entity].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1Entity> update(
    GoogleCloudDataplexV1Entity request,
    core.String name, {
    core.bool? validateOnly,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (validateOnly != null) 'validateOnly': ['${validateOnly}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PUT',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1Entity.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsLakesZonesEntitiesPartitionsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsLakesZonesEntitiesPartitionsResource(
      commons.ApiRequester client)
      : _requester = client;

  /// Create a metadata partition.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the parent zone:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{entity_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/zones/\[^/\]+/entities/\[^/\]+$`.
  ///
  /// [validateOnly] - Optional. Only validate the request, but do not perform
  /// mutations. The default is false.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1Partition].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1Partition> create(
    GoogleCloudDataplexV1Partition request,
    core.String parent, {
    core.bool? validateOnly,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (validateOnly != null) 'validateOnly': ['${validateOnly}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/partitions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1Partition.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Delete a metadata partition.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the partition. format:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{entity_id}/partitions/{partition_value_path}.
  /// The {partition_value_path} segment consists of an ordered sequence of
  /// partition values separated by "/". All values must be provided.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/zones/\[^/\]+/entities/\[^/\]+/partitions/.*$`.
  ///
  /// [etag] - Optional. The etag associated with the partition.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Empty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Empty> delete(
    core.String name, {
    core.String? etag,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (etag != null) 'etag': [etag],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Empty.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Get a metadata partition of an entity.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the partition:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{entity_id}/partitions/{partition_value_path}.
  /// The {partition_value_path} segment consists of an ordered sequence of
  /// partition values separated by "/". All values must be provided.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/zones/\[^/\]+/entities/\[^/\]+/partitions/.*$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1Partition].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1Partition> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1Partition.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// List metadata partitions of an entity.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the parent entity:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{entity_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/lakes/\[^/\]+/zones/\[^/\]+/entities/\[^/\]+$`.
  ///
  /// [filter] - Optional. Filter the partitions returned to the caller using a
  /// key value pair expression. Supported operators and syntax: logic
  /// operators: AND, OR comparison operators: \<, \>, \>=, \<= ,=, != LIKE
  /// operators: The right hand of a LIKE operator supports "." and "*" for
  /// wildcard searches, for example "value1 LIKE ".*oo.*" parenthetical
  /// grouping: ( )Sample filter expression: \`?filter="key1 \< value1 OR key2
  /// \> value2"Notes: Keys to the left of operators are case insensitive.
  /// Partition results are sorted first by creation time, then by lexicographic
  /// order. Up to 20 key value filter pairs are allowed, but due to performance
  /// considerations, only the first 10 will be used as a filter.
  ///
  /// [pageSize] - Optional. Maximum number of partitions to return. The service
  /// may return fewer than this value. If unspecified, 100 partitions will be
  /// returned by default. The maximum page size is 500; larger values will will
  /// be truncated to 500.
  ///
  /// [pageToken] - Optional. Page token received from a previous ListPartitions
  /// call. Provide this to retrieve the subsequent page. When paginating, all
  /// other parameters provided to ListPartitions must match the call that
  /// provided the page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1ListPartitionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1ListPartitionsResponse> list(
    core.String parent, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/partitions';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1ListPartitionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsMetadataJobsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsMetadataJobsResource(commons.ApiRequester client)
      : _requester = client;

  /// Cancels a metadata job.If you cancel a metadata import job that is in
  /// progress, the changes in the job might be partially applied.
  ///
  /// We recommend that you reset the state of the entry groups in your project
  /// by running another metadata job that reverts the changes from the canceled
  /// job.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the job, in the format
  /// projects/{project_id_or_number}/locations/{location_id}/metadataJobs/{metadata_job_id}
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/metadataJobs/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Empty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Empty> cancel(
    GoogleCloudDataplexV1CancelMetadataJobRequest request,
    core.String name, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Empty.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates a metadata job.
  ///
  /// For example, use a metadata job to import Dataplex Catalog entries and
  /// aspects from a third-party system into Dataplex.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the parent location, in the
  /// format projects/{project_id_or_number}/locations/{location_id}
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [metadataJobId] - Optional. The metadata job ID. If not provided, a unique
  /// ID is generated with the prefix metadata-job-.
  ///
  /// [validateOnly] - Optional. The service validates the request without
  /// performing any mutations. The default is false.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> create(
    GoogleCloudDataplexV1MetadataJob request,
    core.String parent, {
    core.String? metadataJobId,
    core.bool? validateOnly,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (metadataJobId != null) 'metadataJobId': [metadataJobId],
      if (validateOnly != null) 'validateOnly': ['${validateOnly}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/metadataJobs';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets a metadata job.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the metadata job, in the format
  /// projects/{project_id_or_number}/locations/{location_id}/metadataJobs/{metadata_job_id}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/metadataJobs/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1MetadataJob].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1MetadataJob> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1MetadataJob.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists metadata jobs.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the parent location, in the
  /// format projects/{project_id_or_number}/locations/{location_id}
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [filter] - Optional. Filter request. Filters are case-sensitive. The
  /// service supports the following formats: labels.key1 = "value1" labels:key1
  /// name = "value"You can combine filters with AND, OR, and NOT operators.
  ///
  /// [orderBy] - Optional. The field to sort the results by, either name or
  /// create_time. If not specified, the ordering is undefined.
  ///
  /// [pageSize] - Optional. The maximum number of metadata jobs to return. The
  /// service might return fewer jobs than this value. If unspecified, at most
  /// 10 jobs are returned. The maximum value is 1,000.
  ///
  /// [pageToken] - Optional. The page token received from a previous
  /// ListMetadataJobs call. Provide this token to retrieve the subsequent page
  /// of results. When paginating, all other parameters that are provided to the
  /// ListMetadataJobs request must match the call that provided the page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudDataplexV1ListMetadataJobsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudDataplexV1ListMetadataJobsResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/metadataJobs';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudDataplexV1ListMetadataJobsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsOperationsResource(commons.ApiRequester client)
      : _requester = client;

  /// Starts asynchronous cancellation on a long-running operation.
  ///
  /// The server makes a best effort to cancel the operation, but success is not
  /// guaranteed. If the server doesn't support this method, it returns
  /// google.rpc.Code.UNIMPLEMENTED. Clients can use Operations.GetOperation or
  /// other methods to check whether the cancellation succeeded or whether the
  /// operation completed despite cancellation. On successful cancellation, the
  /// operation is not deleted; instead, it becomes an operation with an
  /// Operation.error value with a google.rpc.Status.code of 1, corresponding to
  /// Code.CANCELLED.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be cancelled.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Empty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Empty> cancel(
    GoogleLongrunningCancelOperationRequest request,
    core.String name, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Empty.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns google.rpc.Code.UNIMPLEMENTED.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Empty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Empty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Empty.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns UNIMPLEMENTED.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

/// A generic empty message that you can re-use to avoid defining duplicated
/// empty messages in your APIs.
///
/// A typical example is to use it as the request or the response type of an API
/// method. For instance: service Foo { rpc Bar(google.protobuf.Empty) returns
/// (google.protobuf.Empty); }
typedef Empty = $Empty;

/// Action represents an issue requiring administrator action for resolution.
class GoogleCloudDataplexV1Action {
  /// The relative resource name of the asset, of the form:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/assets/{asset_id}.
  ///
  /// Output only.
  core.String? asset;

  /// The category of issue associated with the action.
  /// Possible string values are:
  /// - "CATEGORY_UNSPECIFIED" : Unspecified category.
  /// - "RESOURCE_MANAGEMENT" : Resource management related issues.
  /// - "SECURITY_POLICY" : Security policy related issues.
  /// - "DATA_DISCOVERY" : Data and discovery related issues.
  core.String? category;

  /// The list of data locations associated with this action.
  ///
  /// Cloud Storage locations are represented as URI paths(E.g.
  /// gs://bucket/table1/year=2020/month=Jan/). BigQuery locations refer to
  /// resource names(E.g.
  /// bigquery.googleapis.com/projects/project-id/datasets/dataset-id).
  core.List<core.String>? dataLocations;

  /// The time that the issue was detected.
  core.String? detectTime;

  /// Details for issues related to applying security policy.
  GoogleCloudDataplexV1ActionFailedSecurityPolicyApply?
      failedSecurityPolicyApply;

  /// Details for issues related to incompatible schemas detected within data.
  GoogleCloudDataplexV1ActionIncompatibleDataSchema? incompatibleDataSchema;

  /// Details for issues related to invalid or unsupported data formats.
  GoogleCloudDataplexV1ActionInvalidDataFormat? invalidDataFormat;

  /// Details for issues related to invalid data arrangement.
  GoogleCloudDataplexV1ActionInvalidDataOrganization? invalidDataOrganization;

  /// Details for issues related to invalid or unsupported data partition
  /// structure.
  GoogleCloudDataplexV1ActionInvalidDataPartition? invalidDataPartition;

  /// Detailed description of the issue requiring action.
  core.String? issue;

  /// The relative resource name of the lake, of the form:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}.
  ///
  /// Output only.
  core.String? lake;

  /// Details for issues related to absence of data within managed resources.
  GoogleCloudDataplexV1ActionMissingData? missingData;

  /// Details for issues related to absence of a managed resource.
  GoogleCloudDataplexV1ActionMissingResource? missingResource;

  /// The relative resource name of the action, of the form:
  /// projects/{project}/locations/{location}/lakes/{lake}/actions/{action}
  /// projects/{project}/locations/{location}/lakes/{lake}/zones/{zone}/actions/{action}
  /// projects/{project}/locations/{location}/lakes/{lake}/zones/{zone}/assets/{asset}/actions/{action}.
  ///
  /// Output only.
  core.String? name;

  /// Details for issues related to lack of permissions to access data
  /// resources.
  GoogleCloudDataplexV1ActionUnauthorizedResource? unauthorizedResource;

  /// The relative resource name of the zone, of the form:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}.
  ///
  /// Output only.
  core.String? zone;

  GoogleCloudDataplexV1Action({
    this.asset,
    this.category,
    this.dataLocations,
    this.detectTime,
    this.failedSecurityPolicyApply,
    this.incompatibleDataSchema,
    this.invalidDataFormat,
    this.invalidDataOrganization,
    this.invalidDataPartition,
    this.issue,
    this.lake,
    this.missingData,
    this.missingResource,
    this.name,
    this.unauthorizedResource,
    this.zone,
  });

  GoogleCloudDataplexV1Action.fromJson(core.Map json_)
      : this(
          asset: json_['asset'] as core.String?,
          category: json_['category'] as core.String?,
          dataLocations: (json_['dataLocations'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
          detectTime: json_['detectTime'] as core.String?,
          failedSecurityPolicyApply: json_
                  .containsKey('failedSecurityPolicyApply')
              ? GoogleCloudDataplexV1ActionFailedSecurityPolicyApply.fromJson(
                  json_['failedSecurityPolicyApply']
                      as core.Map<core.String, core.dynamic>)
              : null,
          incompatibleDataSchema: json_.containsKey('incompatibleDataSchema')
              ? GoogleCloudDataplexV1ActionIncompatibleDataSchema.fromJson(
                  json_['incompatibleDataSchema']
                      as core.Map<core.String, core.dynamic>)
              : null,
          invalidDataFormat: json_.containsKey('invalidDataFormat')
              ? GoogleCloudDataplexV1ActionInvalidDataFormat.fromJson(
                  json_['invalidDataFormat']
                      as core.Map<core.String, core.dynamic>)
              : null,
          invalidDataOrganization: json_.containsKey('invalidDataOrganization')
              ? GoogleCloudDataplexV1ActionInvalidDataOrganization.fromJson(
                  json_['invalidDataOrganization']
                      as core.Map<core.String, core.dynamic>)
              : null,
          invalidDataPartition: json_.containsKey('invalidDataPartition')
              ? GoogleCloudDataplexV1ActionInvalidDataPartition.fromJson(
                  json_['invalidDataPartition']
                      as core.Map<core.String, core.dynamic>)
              : null,
          issue: json_['issue'] as core.String?,
          lake: json_['lake'] as core.String?,
          missingData: json_.containsKey('missingData')
              ? GoogleCloudDataplexV1ActionMissingData.fromJson(
                  json_['missingData'] as core.Map<core.String, core.dynamic>)
              : null,
          missingResource: json_.containsKey('missingResource')
              ? GoogleCloudDataplexV1ActionMissingResource.fromJson(
                  json_['missingResource']
                      as core.Map<core.String, core.dynamic>)
              : null,
          name: json_['name'] as core.String?,
          unauthorizedResource: json_.containsKey('unauthorizedResource')
              ? GoogleCloudDataplexV1ActionUnauthorizedResource.fromJson(
                  json_['unauthorizedResource']
                      as core.Map<core.String, core.dynamic>)
              : null,
          zone: json_['zone'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (asset != null) 'asset': asset!,
        if (category != null) 'category': category!,
        if (dataLocations != null) 'dataLocations': dataLocations!,
        if (detectTime != null) 'detectTime': detectTime!,
        if (failedSecurityPolicyApply != null)
          'failedSecurityPolicyApply': failedSecurityPolicyApply!,
        if (incompatibleDataSchema != null)
          'incompatibleDataSchema': incompatibleDataSchema!,
        if (invalidDataFormat != null) 'invalidDataFormat': invalidDataFormat!,
        if (invalidDataOrganization != null)
          'invalidDataOrganization': invalidDataOrganization!,
        if (invalidDataPartition != null)
          'invalidDataPartition': invalidDataPartition!,
        if (issue != null) 'issue': issue!,
        if (lake != null) 'lake': lake!,
        if (missingData != null) 'missingData': missingData!,
        if (missingResource != null) 'missingResource': missingResource!,
        if (name != null) 'name': name!,
        if (unauthorizedResource != null)
          'unauthorizedResource': unauthorizedResource!,
        if (zone != null) 'zone': zone!,
      };
}

/// Failed to apply security policy to the managed resource(s) under a lake,
/// zone or an asset.
///
/// For a lake or zone resource, one or more underlying assets has a failure
/// applying security policy to the associated managed resource.
class GoogleCloudDataplexV1ActionFailedSecurityPolicyApply {
  /// Resource name of one of the assets with failing security policy
  /// application.
  ///
  /// Populated for a lake or zone resource only.
  core.String? asset;

  GoogleCloudDataplexV1ActionFailedSecurityPolicyApply({
    this.asset,
  });

  GoogleCloudDataplexV1ActionFailedSecurityPolicyApply.fromJson(core.Map json_)
      : this(
          asset: json_['asset'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (asset != null) 'asset': asset!,
      };
}

/// Action details for incompatible schemas detected by discovery.
class GoogleCloudDataplexV1ActionIncompatibleDataSchema {
  /// The existing and expected schema of the table.
  ///
  /// The schema is provided as a JSON formatted structure listing columns and
  /// data types.
  core.String? existingSchema;

  /// The new and incompatible schema within the table.
  ///
  /// The schema is provided as a JSON formatted structured listing columns and
  /// data types.
  core.String? newSchema;

  /// The list of data locations sampled and used for format/schema inference.
  core.List<core.String>? sampledDataLocations;

  /// Whether the action relates to a schema that is incompatible or modified.
  /// Possible string values are:
  /// - "SCHEMA_CHANGE_UNSPECIFIED" : Schema change unspecified.
  /// - "INCOMPATIBLE" : Newly discovered schema is incompatible with existing
  /// schema.
  /// - "MODIFIED" : Newly discovered schema has changed from existing schema
  /// for data in a curated zone.
  core.String? schemaChange;

  /// The name of the table containing invalid data.
  core.String? table;

  GoogleCloudDataplexV1ActionIncompatibleDataSchema({
    this.existingSchema,
    this.newSchema,
    this.sampledDataLocations,
    this.schemaChange,
    this.table,
  });

  GoogleCloudDataplexV1ActionIncompatibleDataSchema.fromJson(core.Map json_)
      : this(
          existingSchema: json_['existingSchema'] as core.String?,
          newSchema: json_['newSchema'] as core.String?,
          sampledDataLocations: (json_['sampledDataLocations'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
          schemaChange: json_['schemaChange'] as core.String?,
          table: json_['table'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (existingSchema != null) 'existingSchema': existingSchema!,
        if (newSchema != null) 'newSchema': newSchema!,
        if (sampledDataLocations != null)
          'sampledDataLocations': sampledDataLocations!,
        if (schemaChange != null) 'schemaChange': schemaChange!,
        if (table != null) 'table': table!,
      };
}

/// Action details for invalid or unsupported data files detected by discovery.
class GoogleCloudDataplexV1ActionInvalidDataFormat {
  /// The expected data format of the entity.
  core.String? expectedFormat;

  /// The new unexpected data format within the entity.
  core.String? newFormat;

  /// The list of data locations sampled and used for format/schema inference.
  core.List<core.String>? sampledDataLocations;

  GoogleCloudDataplexV1ActionInvalidDataFormat({
    this.expectedFormat,
    this.newFormat,
    this.sampledDataLocations,
  });

  GoogleCloudDataplexV1ActionInvalidDataFormat.fromJson(core.Map json_)
      : this(
          expectedFormat: json_['expectedFormat'] as core.String?,
          newFormat: json_['newFormat'] as core.String?,
          sampledDataLocations: (json_['sampledDataLocations'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (expectedFormat != null) 'expectedFormat': expectedFormat!,
        if (newFormat != null) 'newFormat': newFormat!,
        if (sampledDataLocations != null)
          'sampledDataLocations': sampledDataLocations!,
      };
}

/// Action details for invalid data arrangement.
typedef GoogleCloudDataplexV1ActionInvalidDataOrganization = $Empty;

/// Action details for invalid or unsupported partitions detected by discovery.
class GoogleCloudDataplexV1ActionInvalidDataPartition {
  /// The issue type of InvalidDataPartition.
  /// Possible string values are:
  /// - "PARTITION_STRUCTURE_UNSPECIFIED" : PartitionStructure unspecified.
  /// - "CONSISTENT_KEYS" : Consistent hive-style partition definition (both raw
  /// and curated zone).
  /// - "HIVE_STYLE_KEYS" : Hive style partition definition (curated zone only).
  core.String? expectedStructure;

  GoogleCloudDataplexV1ActionInvalidDataPartition({
    this.expectedStructure,
  });

  GoogleCloudDataplexV1ActionInvalidDataPartition.fromJson(core.Map json_)
      : this(
          expectedStructure: json_['expectedStructure'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (expectedStructure != null) 'expectedStructure': expectedStructure!,
      };
}

/// Action details for absence of data detected by discovery.
typedef GoogleCloudDataplexV1ActionMissingData = $Empty;

/// Action details for resource references in assets that cannot be located.
typedef GoogleCloudDataplexV1ActionMissingResource = $Empty;

/// Action details for unauthorized resource issues raised to indicate that the
/// service account associated with the lake instance is not authorized to
/// access or manage the resource associated with an asset.
typedef GoogleCloudDataplexV1ActionUnauthorizedResource = $Empty;

/// An aspect is a single piece of metadata describing an entry.
class GoogleCloudDataplexV1Aspect {
  /// Information related to the source system of the aspect.
  ///
  /// Optional.
  GoogleCloudDataplexV1AspectSource? aspectSource;

  /// The resource name of the type used to create this Aspect.
  ///
  /// Output only.
  core.String? aspectType;

  /// The time when the Aspect was created.
  ///
  /// Output only.
  core.String? createTime;

  /// The content of the aspect, according to its aspect type schema.
  ///
  /// The maximum size of the field is 120KB (encoded as UTF-8).
  ///
  /// Required.
  ///
  /// The values for Object must be JSON objects. It can consist of `num`,
  /// `String`, `bool` and `null` as well as `Map` and `List` values.
  core.Map<core.String, core.Object?>? data;

  /// The path in the entry under which the aspect is attached.
  ///
  /// Output only.
  core.String? path;

  /// The time when the Aspect was last updated.
  ///
  /// Output only.
  core.String? updateTime;

  GoogleCloudDataplexV1Aspect({
    this.aspectSource,
    this.aspectType,
    this.createTime,
    this.data,
    this.path,
    this.updateTime,
  });

  GoogleCloudDataplexV1Aspect.fromJson(core.Map json_)
      : this(
          aspectSource: json_.containsKey('aspectSource')
              ? GoogleCloudDataplexV1AspectSource.fromJson(
                  json_['aspectSource'] as core.Map<core.String, core.dynamic>)
              : null,
          aspectType: json_['aspectType'] as core.String?,
          createTime: json_['createTime'] as core.String?,
          data: json_.containsKey('data')
              ? json_['data'] as core.Map<core.String, core.dynamic>
              : null,
          path: json_['path'] as core.String?,
          updateTime: json_['updateTime'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (aspectSource != null) 'aspectSource': aspectSource!,
        if (aspectType != null) 'aspectType': aspectType!,
        if (createTime != null) 'createTime': createTime!,
        if (data != null) 'data': data!,
        if (path != null) 'path': path!,
        if (updateTime != null) 'updateTime': updateTime!,
      };
}

/// Information related to the source system of the aspect.
class GoogleCloudDataplexV1AspectSource {
  /// The time the aspect was created in the source system.
  core.String? createTime;

  /// The version of the data format used to produce this data.
  ///
  /// This field is used to indicated when the underlying data format changes
  /// (e.g., schema modifications, changes to the source URL format definition,
  /// etc).
  core.String? dataVersion;

  /// The time the aspect was last updated in the source system.
  core.String? updateTime;

  GoogleCloudDataplexV1AspectSource({
    this.createTime,
    this.dataVersion,
    this.updateTime,
  });

  GoogleCloudDataplexV1AspectSource.fromJson(core.Map json_)
      : this(
          createTime: json_['createTime'] as core.String?,
          dataVersion: json_['dataVersion'] as core.String?,
          updateTime: json_['updateTime'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (createTime != null) 'createTime': createTime!,
        if (dataVersion != null) 'dataVersion': dataVersion!,
        if (updateTime != null) 'updateTime': updateTime!,
      };
}

/// AspectType is a template for creating Aspects, and represents the
/// JSON-schema for a given Entry, for example, BigQuery Table Schema.
class GoogleCloudDataplexV1AspectType {
  /// Defines the Authorization for this type.
  ///
  /// Immutable.
  GoogleCloudDataplexV1AspectTypeAuthorization? authorization;

  /// The time when the AspectType was created.
  ///
  /// Output only.
  core.String? createTime;

  /// Description of the AspectType.
  ///
  /// Optional.
  core.String? description;

  /// User friendly display name.
  ///
  /// Optional.
  core.String? displayName;

  /// The service computes this checksum.
  ///
  /// The client may send it on update and delete requests to ensure it has an
  /// up-to-date value before proceeding.
  core.String? etag;

  /// User-defined labels for the AspectType.
  ///
  /// Optional.
  core.Map<core.String, core.String>? labels;

  /// MetadataTemplate of the aspect.
  ///
  /// Required.
  GoogleCloudDataplexV1AspectTypeMetadataTemplate? metadataTemplate;

  /// The relative resource name of the AspectType, of the form:
  /// projects/{project_number}/locations/{location_id}/aspectTypes/{aspect_type_id}.
  ///
  /// Output only.
  core.String? name;

  /// Denotes the transfer status of the Aspect Type.
  ///
  /// It is unspecified for Aspect Types created from Dataplex API.
  ///
  /// Output only.
  /// Possible string values are:
  /// - "TRANSFER_STATUS_UNSPECIFIED" : The default value. It is set for
  /// resources that were not subject for migration from Data Catalog service.
  /// - "TRANSFER_STATUS_MIGRATED" : Indicates that a resource was migrated from
  /// Data Catalog service but it hasn't been transferred yet. In particular the
  /// resource cannot be updated from Dataplex API.
  /// - "TRANSFER_STATUS_TRANSFERRED" : Indicates that a resource was
  /// transferred from Data Catalog service. The resource can only be updated
  /// from Dataplex API.
  core.String? transferStatus;

  /// System generated globally unique ID for the AspectType.
  ///
  /// If you delete and recreate the AspectType with the same name, then this ID
  /// will be different.
  ///
  /// Output only.
  core.String? uid;

  /// The time when the AspectType was last updated.
  ///
  /// Output only.
  core.String? updateTime;

  GoogleCloudDataplexV1AspectType({
    this.authorization,
    this.createTime,
    this.description,
    this.displayName,
    this.etag,
    this.labels,
    this.metadataTemplate,
    this.name,
    this.transferStatus,
    this.uid,
    this.updateTime,
  });

  GoogleCloudDataplexV1AspectType.fromJson(core.Map json_)
      : this(
          authorization: json_.containsKey('authorization')
              ? GoogleCloudDataplexV1AspectTypeAuthorization.fromJson(
                  json_['authorization'] as core.Map<core.String, core.dynamic>)
              : null,
          createTime: json_['createTime'] as core.String?,
          description: json_['description'] as core.String?,
          displayName: json_['displayName'] as core.String?,
          etag: json_['etag'] as core.String?,
          labels:
              (json_['labels'] as core.Map<core.String, core.dynamic>?)?.map(
            (key, value) => core.MapEntry(
              key,
              value as core.String,
            ),
          ),
          metadataTemplate: json_.containsKey('metadataTemplate')
              ? GoogleCloudDataplexV1AspectTypeMetadataTemplate.fromJson(
                  json_['metadataTemplate']
                      as core.Map<core.String, core.dynamic>)
              : null,
          name: json_['name'] as core.String?,
          transferStatus: json_['transferStatus'] as core.String?,
          uid: json_['uid'] as core.String?,
          updateTime: json_['updateTime'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (authorization != null) 'authorization': authorization!,
        if (createTime != null) 'createTime': createTime!,
        if (description != null) 'description': description!,
        if (displayName != null) 'displayName': displayName!,
        if (etag != null) 'etag': etag!,
        if (labels != null) 'labels': labels!,
        if (metadataTemplate != null) 'metadataTemplate': metadataTemplate!,
        if (name != null) 'name': name!,
        if (transferStatus != null) 'transferStatus': transferStatus!,
        if (uid != null) 'uid': uid!,
        if (updateTime != null) 'updateTime': updateTime!,
      };
}

/// Autorization for an AspectType.
class GoogleCloudDataplexV1AspectTypeAuthorization {
  /// The IAM permission grantable on the EntryGroup to allow access to
  /// instantiate Aspects of Dataplex owned AspectTypes, only settable for
  /// Dataplex owned Types.
  ///
  /// Immutable.
  core.String? alternateUsePermission;

  GoogleCloudDataplexV1AspectTypeAuthorization({
    this.alternateUsePermission,
  });

  GoogleCloudDataplexV1AspectTypeAuthorization.fromJson(core.Map json_)
      : this(
          alternateUsePermission:
              json_['alternateUsePermission'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (alternateUsePermission != null)
          'alternateUsePermission': alternateUsePermission!,
      };
}

/// MetadataTemplate definition for an AspectType.
class GoogleCloudDataplexV1AspectTypeMetadataTemplate {
  /// Specifies annotations on this field.
  ///
  /// Optional.
  GoogleCloudDataplexV1AspectTypeMetadataTemplateAnnotations? annotations;

  /// If the type is array, set array_items.
  ///
  /// array_items can refer to a primitive field or a complex (record only)
  /// field. To specify a primitive field, you only need to set name and type in
  /// the nested MetadataTemplate. The recommended value for the name field is
  /// item, as this isn't used in the actual payload.
  ///
  /// Optional.
  GoogleCloudDataplexV1AspectTypeMetadataTemplate? arrayItems;

  /// Specifies the constraints on this field.
  ///
  /// Optional.
  GoogleCloudDataplexV1AspectTypeMetadataTemplateConstraints? constraints;

  /// The list of values for an enum type.
  ///
  /// You must define it if the type is enum.
  ///
  /// Optional.
  core.List<GoogleCloudDataplexV1AspectTypeMetadataTemplateEnumValue>?
      enumValues;

  /// Index is used to encode Template messages.
  ///
  /// The value of index can range between 1 and 2,147,483,647. Index must be
  /// unique within all fields in a Template. (Nested Templates can reuse
  /// indexes). Once a Template is defined, the index cannot be changed, because
  /// it identifies the field in the actual storage format. Index is a mandatory
  /// field, but it is optional for top level fields, and map/array "values"
  /// definitions.
  ///
  /// Optional.
  core.int? index;

  /// If the type is map, set map_items.
  ///
  /// map_items can refer to a primitive field or a complex (record only) field.
  /// To specify a primitive field, you only need to set name and type in the
  /// nested MetadataTemplate. The recommended value for the name field is item,
  /// as this isn't used in the actual payload.
  ///
  /// Optional.
  GoogleCloudDataplexV1AspectTypeMetadataTemplate? mapItems;

  /// The name of the field.
  ///
  /// Required.
  core.String? name;

  /// Field definition.
  ///
  /// You must specify it if the type is record. It defines the nested fields.
  ///
  /// Optional.
  core.List<GoogleCloudDataplexV1AspectTypeMetadataTemplate>? recordFields;

  /// The datatype of this field.
  ///
  /// The following values are supported:Primitive types: string integer boolean
  /// double datetime. Must be of the format RFC3339 UTC "Zulu" (Examples:
  /// "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z").Complex
  /// types: enum array map record
  ///
  /// Required.
  core.String? type;

  /// You can use type id if this definition of the field needs to be reused
  /// later.
  ///
  /// The type id must be unique across the entire template. You can only
  /// specify it if the field type is record.
  ///
  /// Optional.
  core.String? typeId;

  /// A reference to another field definition (not an inline definition).
  ///
  /// The value must be equal to the value of an id field defined elsewhere in
  /// the MetadataTemplate. Only fields with record type can refer to other
  /// fields.
  ///
  /// Optional.
  core.String? typeRef;

  GoogleCloudDataplexV1AspectTypeMetadataTemplate({
    this.annotations,
    this.arrayItems,
    this.constraints,
    this.enumValues,
    this.index,
    this.mapItems,
    this.name,
    this.recordFields,
    this.type,
    this.typeId,
    this.typeRef,
  });

  GoogleCloudDataplexV1AspectTypeMetadataTemplate.fromJson(core.Map json_)
      : this(
          annotations: json_.containsKey('annotations')
              ? GoogleCloudDataplexV1AspectTypeMetadataTemplateAnnotations
                  .fromJson(json_['annotations']
                      as core.Map<core.String, core.dynamic>)
              : null,
          arrayItems: json_.containsKey('arrayItems')
              ? GoogleCloudDataplexV1AspectTypeMetadataTemplate.fromJson(
                  json_['arrayItems'] as core.Map<core.String, core.dynamic>)
              : null,
          constraints: json_.containsKey('constraints')
              ? GoogleCloudDataplexV1AspectTypeMetadataTemplateConstraints
                  .fromJson(json_['constraints']
                      as core.Map<core.String, core.dynamic>)
              : null,
          enumValues: (json_['enumValues'] as core.List?)
              ?.map((value) =>
                  GoogleCloudDataplexV1AspectTypeMetadataTemplateEnumValue
                      .fromJson(value as core.Map<core.String, core.dynamic>))
              .toList(),
          index: json_['index'] as core.int?,
          mapItems: json_.containsKey('mapItems')
              ? GoogleCloudDataplexV1AspectTypeMetadataTemplate.fromJson(
                  json_['mapItems'] as core.Map<core.String, core.dynamic>)
              : null,
          name: json_['name'] as core.String?,
          recordFields: (json_['recordFields'] as core.List?)
              ?.map((value) =>
                  GoogleCloudDataplexV1AspectTypeMetadataTemplate.fromJson(
                      value as core.Map<core.String, core.dynamic>))
              .toList(),
          type: json_['type'] as core.String?,
          typeId: json_['typeId'] as core.String?,
          typeRef: json_['typeRef'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (annotations != null) 'annotations': annotations!,
        if (arrayItems != null) 'arrayItems': arrayItems!,
        if (constraints != null) 'constraints': constraints!,
        if (enumValues != null) 'enumValues': enumValues!,
        if (index != null) 'index': index!,
        if (mapItems != null) 'mapItems': mapItems!,
        if (name != null) 'name': name!,
        if (recordFields != null) 'recordFields': recordFields!,
        if (type != null) 'type': type!,
        if (typeId != null) 'typeId': typeId!,
        if (typeRef != null) 'typeRef': typeRef!,
      };
}

/// Definition of the annotations of a field.
class GoogleCloudDataplexV1AspectTypeMetadataTemplateAnnotations {
  /// Marks a field as deprecated.
  ///
  /// You can include a deprecation message.
  ///
  /// Optional.
  core.String? deprecated;

  /// Description for a field.
  ///
  /// Optional.
  core.String? description;

  /// Display name for a field.
  ///
  /// Optional.
  core.String? displayName;

  /// Display order for a field.
  ///
  /// You can use this to reorder where a field is rendered.
  ///
  /// Optional.
  core.int? displayOrder;

  /// You can use String Type annotations to specify special meaning to string
  /// fields.
  ///
  /// The following values are supported: richText: The field must be
  /// interpreted as a rich text field. url: A fully qualified URL link.
  /// resource: A service qualified resource reference.
  ///
  /// Optional.
  core.String? stringType;

  /// Suggested hints for string fields.
  ///
  /// You can use them to suggest values to users through console.
  ///
  /// Optional.
  core.List<core.String>? stringValues;

  GoogleCloudDataplexV1AspectTypeMetadataTemplateAnnotations({
    this.deprecated,
    this.description,
    this.displayName,
    this.displayOrder,
    this.stringType,
    this.stringValues,
  });

  GoogleCloudDataplexV1AspectTypeMetadataTemplateAnnotations.fromJson(
      core.Map json_)
      : this(
          deprecated: json_['deprecated'] as core.String?,
          description: json_['description'] as core.String?,
          displayName: json_['displayName'] as core.String?,
          displayOrder: json_['displayOrder'] as core.int?,
          stringType: json_['stringType'] as core.String?,
          stringValues: (json_['stringValues'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (deprecated != null) 'deprecated': deprecated!,
        if (description != null) 'description': description!,
        if (displayName != null) 'displayName': displayName!,
        if (displayOrder != null) 'displayOrder': displayOrder!,
        if (stringType != null) 'stringType': stringType!,
        if (stringValues != null) 'stringValues': stringValues!,
      };
}

/// Definition of the constraints of a field.
class GoogleCloudDataplexV1AspectTypeMetadataTemplateConstraints {
  /// Marks this field as optional or required.
  ///
  /// Optional.
  core.bool? required;

  GoogleCloudDataplexV1AspectTypeMetadataTemplateConstraints({
    this.required,
  });

  GoogleCloudDataplexV1AspectTypeMetadataTemplateConstraints.fromJson(
      core.Map json_)
      : this(
          required: json_['required'] as core.bool?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (required != null) 'required': required!,
      };
}

/// Definition of Enumvalue, to be used for enum fields.
class GoogleCloudDataplexV1AspectTypeMetadataTemplateEnumValue {
  /// You can set this message if you need to deprecate an enum value.
  ///
  /// Optional.
  core.String? deprecated;

  /// Index for the enum value.
  ///
  /// It can't be modified.
  ///
  /// Required.
  core.int? index;

  /// Name of the enumvalue.
  ///
  /// This is the actual value that the aspect can contain.
  ///
  /// Required.
  core.String? name;

  GoogleCloudDataplexV1AspectTypeMetadataTemplateEnumValue({
    this.deprecated,
    this.index,
    this.name,
  });

  GoogleCloudDataplexV1AspectTypeMetadataTemplateEnumValue.fromJson(
      core.Map json_)
      : this(
          deprecated: json_['deprecated'] as core.String?,
          index: json_['index'] as core.int?,
          name: json_['name'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (deprecated != null) 'deprecated': deprecated!,
        if (index != null) 'index': index!,
        if (name != null) 'name': name!,
      };
}

/// An asset represents a cloud resource that is being managed within a lake as
/// a member of a zone.
class GoogleCloudDataplexV1Asset {
  /// The time when the asset was created.
  ///
  /// Output only.
  core.String? createTime;

  /// Description of the asset.
  ///
  /// Optional.
  core.String? description;

  /// Specification of the discovery feature applied to data referenced by this
  /// asset.
  ///
  /// When this spec is left unset, the asset will use the spec set on the
  /// parent zone.
  ///
  /// Optional.
  GoogleCloudDataplexV1AssetDiscoverySpec? discoverySpec;

  /// Status of the discovery feature applied to data referenced by this asset.
  ///
  /// Output only.
  GoogleCloudDataplexV1AssetDiscoveryStatus? discoveryStatus;

  /// User friendly display name.
  ///
  /// Optional.
  core.String? displayName;

  /// User defined labels for the asset.
  ///
  /// Optional.
  core.Map<core.String, core.String>? labels;

  /// The relative resource name of the asset, of the form:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/assets/{asset_id}.
  ///
  /// Output only.
  core.String? name;

  /// Specification of the resource that is referenced by this asset.
  ///
  /// Required.
  GoogleCloudDataplexV1AssetResourceSpec? resourceSpec;

  /// Status of the resource referenced by this asset.
  ///
  /// Output only.
  GoogleCloudDataplexV1AssetResourceStatus? resourceStatus;

  /// Status of the security policy applied to resource referenced by this
  /// asset.
  ///
  /// Output only.
  GoogleCloudDataplexV1AssetSecurityStatus? securityStatus;

  /// Current state of the asset.
  ///
  /// Output only.
  /// Possible string values are:
  /// - "STATE_UNSPECIFIED" : State is not specified.
  /// - "ACTIVE" : Resource is active, i.e., ready to use.
  /// - "CREATING" : Resource is under creation.
  /// - "DELETING" : Resource is under deletion.
  /// - "ACTION_REQUIRED" : Resource is active but has unresolved actions.
  core.String? state;

  /// System generated globally unique ID for the asset.
  ///
  /// This ID will be different if the asset is deleted and re-created with the
  /// same name.
  ///
  /// Output only.
  core.String? uid;

  /// The time when the asset was last updated.
  ///
  /// Output only.
  core.String? updateTime;

  GoogleCloudDataplexV1Asset({
    this.createTime,
    this.description,
    this.discoverySpec,
    this.discoveryStatus,
    this.displayName,
    this.labels,
    this.name,
    this.resourceSpec,
    this.resourceStatus,
    this.securityStatus,
    this.state,
    this.uid,
    this.updateTime,
  });

  GoogleCloudDataplexV1Asset.fromJson(core.Map json_)
      : this(
          createTime: json_['createTime'] as core.String?,
          description: json_['description'] as core.String?,
          discoverySpec: json_.containsKey('discoverySpec')
              ? GoogleCloudDataplexV1AssetDiscoverySpec.fromJson(
                  json_['discoverySpec'] as core.Map<core.String, core.dynamic>)
              : null,
          discoveryStatus: json_.containsKey('discoveryStatus')
              ? GoogleCloudDataplexV1AssetDiscoveryStatus.fromJson(
                  json_['discoveryStatus']
                      as core.Map<core.String, core.dynamic>)
              : null,
          displayName: json_['displayName'] as core.String?,
          labels:
              (json_['labels'] as core.Map<core.String, core.dynamic>?)?.map(
            (key, value) => core.MapEntry(
              key,
              value as core.String,
            ),
          ),
          name: json_['name'] as core.String?,
          resourceSpec: json_.containsKey('resourceSpec')
              ? GoogleCloudDataplexV1AssetResourceSpec.fromJson(
                  json_['resourceSpec'] as core.Map<core.String, core.dynamic>)
              : null,
          resourceStatus: json_.containsKey('resourceStatus')
              ? GoogleCloudDataplexV1AssetResourceStatus.fromJson(
                  json_['resourceStatus']
                      as core.Map<core.String, core.dynamic>)
              : null,
          securityStatus: json_.containsKey('securityStatus')
              ? GoogleCloudDataplexV1AssetSecurityStatus.fromJson(
                  json_['securityStatus']
                      as core.Map<core.String, core.dynamic>)
              : null,
          state: json_['state'] as core.String?,
          uid: json_['uid'] as core.String?,
          updateTime: json_['updateTime'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (createTime != null) 'createTime': createTime!,
        if (description != null) 'description': description!,
        if (discoverySpec != null) 'discoverySpec': discoverySpec!,
        if (discoveryStatus != null) 'discoveryStatus': discoveryStatus!,
        if (displayName != null) 'displayName': displayName!,
        if (labels != null) 'labels': labels!,
        if (name != null) 'name': name!,
        if (resourceSpec != null) 'resourceSpec': resourceSpec!,
        if (resourceStatus != null) 'resourceStatus': resourceStatus!,
        if (securityStatus != null) 'securityStatus': securityStatus!,
        if (state != null) 'state': state!,
        if (uid != null) 'uid': uid!,
        if (updateTime != null) 'updateTime': updateTime!,
      };
}

/// Settings to manage the metadata discovery and publishing for an asset.
class GoogleCloudDataplexV1AssetDiscoverySpec {
  /// Configuration for CSV data.
  ///
  /// Optional.
  GoogleCloudDataplexV1AssetDiscoverySpecCsvOptions? csvOptions;

  /// Whether discovery is enabled.
  ///
  /// Optional.
  core.bool? enabled;

  /// The list of patterns to apply for selecting data to exclude during
  /// discovery.
  ///
  /// For Cloud Storage bucket assets, these are interpreted as glob patterns
  /// used to match object names. For BigQuery dataset assets, these are
  /// interpreted as patterns to match table names.
  ///
  /// Optional.
  core.List<core.String>? excludePatterns;

  /// The list of patterns to apply for selecting data to include during
  /// discovery if only a subset of the data should considered.
  ///
  /// For Cloud Storage bucket assets, these are interpreted as glob patterns
  /// used to match object names. For BigQuery dataset assets, these are
  /// interpreted as patterns to match table names.
  ///
  /// Optional.
  core.List<core.String>? includePatterns;

  /// Configuration for Json data.
  ///
  /// Optional.
  GoogleCloudDataplexV1AssetDiscoverySpecJsonOptions? jsonOptions;

  /// Cron schedule (https://en.wikipedia.org/wiki/Cron) for running discovery
  /// periodically.
  ///
  /// Successive discovery runs must be scheduled at least 60 minutes apart. The
  /// default value is to run discovery every 60 minutes. To explicitly set a
  /// timezone to the cron tab, apply a prefix in the cron tab:
  /// "CRON_TZ=${IANA_TIME_ZONE}" or TZ=${IANA_TIME_ZONE}". The
  /// ${IANA_TIME_ZONE} may only be a valid string from IANA time zone database.
  /// For example, CRON_TZ=America/New_York 1 * * * *, or TZ=America/New_York 1
  /// * * * *.
  ///
  /// Optional.
  core.String? schedule;

  GoogleCloudDataplexV1AssetDiscoverySpec({
    this.csvOptions,
    this.enabled,
    this.excludePatterns,
    this.includePatterns,
    this.jsonOptions,
    this.schedule,
  });

  GoogleCloudDataplexV1AssetDiscoverySpec.fromJson(core.Map json_)
      : this(
          csvOptions: json_.containsKey('csvOptions')
              ? GoogleCloudDataplexV1AssetDiscoverySpecCsvOptions.fromJson(
                  json_['csvOptions'] as core.Map<core.String, core.dynamic>)
              : null,
          enabled: json_['enabled'] as core.bool?,
          excludePatterns: (json_['excludePatterns'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
          includePatterns: (json_['includePatterns'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
          jsonOptions: json_.containsKey('jsonOptions')
              ? GoogleCloudDataplexV1AssetDiscoverySpecJsonOptions.fromJson(
                  json_['jsonOptions'] as core.Map<core.String, core.dynamic>)
              : null,
          schedule: json_['schedule'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (csvOptions != null) 'csvOptions': csvOptions!,
        if (enabled != null) 'enabled': enabled!,
        if (excludePatterns != null) 'excludePatterns': excludePatterns!,
        if (includePatterns != null) 'includePatterns': includePatterns!,
        if (jsonOptions != null) 'jsonOptions': jsonOptions!,
        if (schedule != null) 'schedule': schedule!,
      };
}

/// Describe CSV and similar semi-structured data formats.
typedef GoogleCloudDataplexV1AssetDiscoverySpecCsvOptions
    = $DiscoverySpecCsvOptions;

/// Describe JSON data format.
typedef GoogleCloudDataplexV1AssetDiscoverySpecJsonOptions
    = $DiscoverySpecJsonOptions;

/// Status of discovery for an asset.
class GoogleCloudDataplexV1AssetDiscoveryStatus {
  /// The duration of the last discovery run.
  core.String? lastRunDuration;

  /// The start time of the last discovery run.
  core.String? lastRunTime;

  /// Additional information about the current state.
  core.String? message;

  /// The current status of the discovery feature.
  /// Possible string values are:
  /// - "STATE_UNSPECIFIED" : State is unspecified.
  /// - "SCHEDULED" : Discovery for the asset is scheduled.
  /// - "IN_PROGRESS" : Discovery for the asset is running.
  /// - "PAUSED" : Discovery for the asset is currently paused (e.g. due to a
  /// lack of available resources). It will be automatically resumed.
  /// - "DISABLED" : Discovery for the asset is disabled.
  core.String? state;

  /// Data Stats of the asset reported by discovery.
  GoogleCloudDataplexV1AssetDiscoveryStatusStats? stats;

  /// Last update time of the status.
  core.String? updateTime;

  GoogleCloudDataplexV1AssetDiscoveryStatus({
    this.lastRunDuration,
    this.lastRunTime,
    this.message,
    this.state,
    this.stats,
    this.updateTime,
  });

  GoogleCloudDataplexV1AssetDiscoveryStatus.fromJson(core.Map json_)
      : this(
          lastRunDuration: json_['lastRunDuration'] as core.String?,
          lastRunTime: json_['lastRunTime'] as core.String?,
          message: json_['message'] as core.String?,
          state: json_['state'] as core.String?,
          stats: json_.containsKey('stats')
              ? GoogleCloudDataplexV1AssetDiscoveryStatusStats.fromJson(
                  json_['stats'] as core.Map<core.String, core.dynamic>)
              : null,
          updateTime: json_['updateTime'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (lastRunDuration != null) 'lastRunDuration': lastRunDuration!,
        if (lastRunTime != null) 'lastRunTime': lastRunTime!,
        if (message != null) 'message': message!,
        if (state != null) 'state': state!,
        if (stats != null) 'stats': stats!,
        if (updateTime != null) 'updateTime': updateTime!,
      };
}

/// The aggregated data statistics for the asset reported by discovery.
class GoogleCloudDataplexV1AssetDiscoveryStatusStats {
  /// The count of data items within the referenced resource.
  core.String? dataItems;

  /// The number of stored data bytes within the referenced resource.
  core.String? dataSize;

  /// The count of fileset entities within the referenced resource.
  core.String? filesets;

  /// The count of table entities within the referenced resource.
  core.String? tables;

  GoogleCloudDataplexV1AssetDiscoveryStatusStats({
    this.dataItems,
    this.dataSize,
    this.filesets,
    this.tables,
  });

  GoogleCloudDataplexV1AssetDiscoveryStatusStats.fromJson(core.Map json_)
      : this(
          dataItems: json_['dataItems'] as core.String?,
          dataSize: json_['dataSize'] as core.String?,
          filesets: json_['filesets'] as core.String?,
          tables: json_['tables'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (dataItems != null) 'dataItems': dataItems!,
        if (dataSize != null) 'dataSize': dataSize!,
        if (filesets != null) 'filesets': filesets!,
        if (tables != null) 'tables': tables!,
      };
}

/// Identifies the cloud resource that is referenced by this asset.
class GoogleCloudDataplexV1AssetResourceSpec {
  /// Relative name of the cloud resource that contains the data that is being
  /// managed within a lake.
  ///
  /// For example: projects/{project_number}/buckets/{bucket_id}
  /// projects/{project_number}/datasets/{dataset_id}
  ///
  /// Immutable.
  core.String? name;

  /// Determines how read permissions are handled for each asset and their
  /// associated tables.
  ///
  /// Only available to storage buckets assets.
  ///
  /// Optional.
  /// Possible string values are:
  /// - "ACCESS_MODE_UNSPECIFIED" : Access mode unspecified.
  /// - "DIRECT" : Default. Data is accessed directly using storage APIs.
  /// - "MANAGED" : Data is accessed through a managed interface using BigQuery
  /// APIs.
  core.String? readAccessMode;

  /// Type of resource.
  ///
  /// Required. Immutable.
  /// Possible string values are:
  /// - "TYPE_UNSPECIFIED" : Type not specified.
  /// - "STORAGE_BUCKET" : Cloud Storage bucket.
  /// - "BIGQUERY_DATASET" : BigQuery dataset.
  core.String? type;

  GoogleCloudDataplexV1AssetResourceSpec({
    this.name,
    this.readAccessMode,
    this.type,
  });

  GoogleCloudDataplexV1AssetResourceSpec.fromJson(core.Map json_)
      : this(
          name: json_['name'] as core.String?,
          readAccessMode: json_['readAccessMode'] as core.String?,
          type: json_['type'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (name != null) 'name': name!,
        if (readAccessMode != null) 'readAccessMode': readAccessMode!,
        if (type != null) 'type': type!,
      };
}

/// Status of the resource referenced by an asset.
class GoogleCloudDataplexV1AssetResourceStatus {
  /// Service account associated with the BigQuery Connection.
  ///
  /// Output only.
  core.String? managedAccessIdentity;

  /// Additional information about the current state.
  core.String? message;

  /// The current state of the managed resource.
  /// Possible string values are:
  /// - "STATE_UNSPECIFIED" : State unspecified.
  /// - "READY" : Resource does not have any errors.
  /// - "ERROR" : Resource has errors.
  core.String? state;

  /// Last update time of the status.
  core.String? updateTime;

  GoogleCloudDataplexV1AssetResourceStatus({
    this.managedAccessIdentity,
    this.message,
    this.state,
    this.updateTime,
  });

  GoogleCloudDataplexV1AssetResourceStatus.fromJson(core.Map json_)
      : this(
          managedAccessIdentity: json_['managedAccessIdentity'] as core.String?,
          message: json_['message'] as core.String?,
          state: json_['state'] as core.String?,
          updateTime: json_['updateTime'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (managedAccessIdentity != null)
          'managedAccessIdentity': managedAccessIdentity!,
        if (message != null) 'message': message!,
        if (state != null) 'state': state!,
        if (updateTime != null) 'updateTime': updateTime!,
      };
}

/// Security policy status of the asset.
///
/// Data security policy, i.e., readers, writers & owners, should be specified
/// in the lake/zone/asset IAM policy.
class GoogleCloudDataplexV1AssetSecurityStatus {
  /// Additional information about the current state.
  core.String? message;

  /// The current state of the security policy applied to the attached resource.
  /// Possible string values are:
  /// - "STATE_UNSPECIFIED" : State unspecified.
  /// - "READY" : Security policy has been successfully applied to the attached
  /// resource.
  /// - "APPLYING" : Security policy is in the process of being applied to the
  /// attached resource.
  /// - "ERROR" : Security policy could not be applied to the attached resource
  /// due to errors.
  core.String? state;

  /// Last update time of the status.
  core.String? updateTime;

  GoogleCloudDataplexV1AssetSecurityStatus({
    this.message,
    this.state,
    this.updateTime,
  });

  GoogleCloudDataplexV1AssetSecurityStatus.fromJson(core.Map json_)
      : this(
          message: json_['message'] as core.String?,
          state: json_['state'] as core.String?,
          updateTime: json_['updateTime'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (message != null) 'message': message!,
        if (state != null) 'state': state!,
        if (updateTime != null) 'updateTime': updateTime!,
      };
}

/// Aggregated status of the underlying assets of a lake or zone.
class GoogleCloudDataplexV1AssetStatus {
  /// Number of active assets.
  core.int? activeAssets;

  /// Number of assets that are in process of updating the security policy on
  /// attached resources.
  core.int? securityPolicyApplyingAssets;

  /// Last update time of the status.
  core.String? updateTime;

  GoogleCloudDataplexV1AssetStatus({
    this.activeAssets,
    this.securityPolicyApplyingAssets,
    this.updateTime,
  });

  GoogleCloudDataplexV1AssetStatus.fromJson(core.Map json_)
      : this(
          activeAssets: json_['activeAssets'] as core.int?,
          securityPolicyApplyingAssets:
              json_['securityPolicyApplyingAssets'] as core.int?,
          updateTime: json_['updateTime'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (activeAssets != null) 'activeAssets': activeAssets!,
        if (securityPolicyApplyingAssets != null)
          'securityPolicyApplyingAssets': securityPolicyApplyingAssets!,
        if (updateTime != null) 'updateTime': updateTime!,
      };
}

/// Cancel task jobs.
typedef GoogleCloudDataplexV1CancelJobRequest = $Empty;

/// Cancel metadata job request.
typedef GoogleCloudDataplexV1CancelMetadataJobRequest = $Empty;

/// Content represents a user-visible notebook or a sql script
class GoogleCloudDataplexV1Content {
  /// Content creation time.
  ///
  /// Output only.
  core.String? createTime;

  /// Content data in string format.
  ///
  /// Required.
  core.String? dataText;

  /// Description of the content.
  ///
  /// Optional.
  core.String? description;

  /// User defined labels for the content.
  ///
  /// Optional.
  core.Map<core.String, core.String>? labels;

  /// The relative resource name of the content, of the form:
  /// projects/{project_id}/locations/{location_id}/lakes/{lake_id}/content/{content_id}
  ///
  /// Output only.
  core.String? name;

  /// Notebook related configurations.
  GoogleCloudDataplexV1ContentNotebook? notebook;

  /// The path for the Content file, represented as directory structure.
  ///
  /// Unique within a lake. Limited to alphanumerics, hyphens, underscores, dots
  /// and slashes.
  ///
  /// Required.
  core.String? path;

  /// Sql Script related configurations.
  GoogleCloudDataplexV1ContentSqlScript? sqlScript;

  /// System generated globally unique ID for the content.
  ///
  /// This ID will be different if the content is deleted and re-created with
  /// the same name.
  ///
  /// Output only.
  core.String? uid;

  /// The time when the content was last updated.
  ///
  /// Output only.
  core.String? updateTime;

  GoogleCloudDataplexV1Content({
    this.createTime,
    this.dataText,
    this.description,
    this.labels,
    this.name,
    this.notebook,
    this.path,
    this.sqlScript,
    this.uid,
    this.updateTime,
  });

  GoogleCloudDataplexV1Content.fromJson(core.Map json_)
      : this(
          createTime: json_['createTime'] as core.String?,
          dataText: json_['dataText'] as core.String?,
          description: json_['description'] as core.String?,
          labels:
              (json_['labels'] as core.Map<core.String, core.dynamic>?)?.map(
            (key, value) => core.MapEntry(
              key,
              value as core.String,
            ),
          ),
          name: json_['name'] as core.String?,
          notebook: json_.containsKey('notebook')
              ? GoogleCloudDataplexV1ContentNotebook.fromJson(
                  json_['notebook'] as core.Map<core.String, core.dynamic>)
              : null,
          path: json_['path'] as core.String?,
          sqlScript: json_.containsKey('sqlScript')
              ? GoogleCloudDataplexV1ContentSqlScript.fromJson(
                  json_['sqlScript'] as core.Map<core.String, core.dynamic>)
              : null,
          uid: json_['uid'] as core.String?,
          updateTime: json_['updateTime'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (createTime != null) 'createTime': createTime!,
        if (dataText != null) 'dataText': dataText!,
        if (description != null) 'description': description!,
        if (labels != null) 'labels': labels!,
        if (name != null) 'name': name!,
        if (notebook != null) 'notebook': notebook!,
        if (path != null) 'path': path!,
        if (sqlScript != null) 'sqlScript': sqlScript!,
        if (uid != null) 'uid': uid!,
        if (updateTime != null) 'updateTime': updateTime!,
      };
}

/// Configuration for Notebook content.
class GoogleCloudDataplexV1ContentNotebook {
  /// Kernel Type of the notebook.
  ///
  /// Required.
  /// Possible string values are:
  /// - "KERNEL_TYPE_UNSPECIFIED" : Kernel Type unspecified.
  /// - "PYTHON3" : Python 3 Kernel.
  core.String? kernelType;

  GoogleCloudDataplexV1ContentNotebook({
    this.kernelType,
  });

  GoogleCloudDataplexV1ContentNotebook.fromJson(core.Map json_)
      : this(
          kernelType: json_['kernelType'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (kernelType != null) 'kernelType': kernelType!,
      };
}

/// Configuration for the Sql Script content.
class GoogleCloudDataplexV1ContentSqlScript {
  /// Query Engine to be used for the Sql Query.
  ///
  /// Required.
  /// Possible string values are:
  /// - "QUERY_ENGINE_UNSPECIFIED" : Value was unspecified.
  /// - "SPARK" : Spark SQL Query.
  core.String? engine;

  GoogleCloudDataplexV1ContentSqlScript({
    this.engine,
  });

  GoogleCloudDataplexV1ContentSqlScript.fromJson(core.Map json_)
      : this(
          engine: json_['engine'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (engine != null) 'engine': engine!,
      };
}

/// DataAccessSpec holds the access control configuration to be enforced on data
/// stored within resources (eg: rows, columns in BigQuery Tables).
///
/// When associated with data, the data is only accessible to principals
/// explicitly granted access through the DataAccessSpec. Principals with access
/// to the containing resource are not implicitly granted access.
class GoogleCloudDataplexV1DataAccessSpec {
  /// The format of strings follows the pattern followed by IAM in the bindings.
  ///
  /// user:{email}, serviceAccount:{email} group:{email}. The set of principals
  /// to be granted reader role on data stored within resources.
  ///
  /// Optional.
  core.List<core.String>? readers;

  GoogleCloudDataplexV1DataAccessSpec({
    this.readers,
  });

  GoogleCloudDataplexV1DataAccessSpec.fromJson(core.Map json_)
      : this(
          readers: (json_['readers'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (readers != null) 'readers': readers!,
      };
}

/// Denotes one dataAttribute in a dataTaxonomy, for example, PII.
///
/// DataAttribute resources can be defined in a hierarchy. A single
/// dataAttribute resource can contain specs of multiple types PII -
/// ResourceAccessSpec : - readers :foo@bar.com - DataAccessSpec : - readers
/// :bar@foo.com
class GoogleCloudDataplexV1DataAttribute {
  /// The number of child attributes present for this attribute.
  ///
  /// Output only.
  core.int? attributeCount;

  /// The time when the DataAttribute was created.
  ///
  /// Output only.
  core.String? createTime;

  /// Specified when applied to data stored on the resource (eg: rows, columns
  /// in BigQuery Tables).
  ///
  /// Optional.
  GoogleCloudDataplexV1DataAccessSpec? dataAccessSpec;

  /// Description of the DataAttribute.
  ///
  /// Optional.
  core.String? description;

  /// User friendly display name.
  ///
  /// Optional.
  core.String? displayName;

  /// This checksum is computed by the server based on the value of other
  /// fields, and may be sent on update and delete requests to ensure the client
  /// has an up-to-date value before proceeding.
  core.String? etag;

  /// User-defined labels for the DataAttribute.
  ///
  /// Optional.
  core.Map<core.String, core.String>? labels;

  /// The relative resource name of the dataAttribute, of the form:
  /// projects/{project_number}/locations/{location_id}/dataTaxonomies/{dataTaxonomy}/attributes/{data_attribute_id}.
  ///
  /// Output only.
  core.String? name;

  /// The ID of the parent DataAttribute resource, should belong to the same
  /// data taxonomy.
  ///
  /// Circular dependency in parent chain is not valid. Maximum depth of the
  /// hierarchy allowed is 4. a -\> b -\> c -\> d -\> e, depth = 4
  ///
  /// Optional.
  core.String? parentId;

  /// Specified when applied to a resource (eg: Cloud Storage bucket, BigQuery
  /// dataset, BigQuery table).
  ///
  /// Optional.
  GoogleCloudDataplexV1ResourceAccessSpec? resourceAccessSpec;

  /// System generated globally unique ID for the DataAttribute.
  ///
  /// This ID will be different if the DataAttribute is deleted and re-created
  /// with the same name.
  ///
  /// Output only.
  core.String? uid;

  /// The time when the DataAttribute was last updated.
  ///
  /// Output only.
  core.String? updateTime;

  GoogleCloudDataplexV1DataAttribute({
    this.attributeCount,
    this.createTime,
    this.dataAccessSpec,
    this.description,
    this.displayName,
    this.etag,
    this.labels,
    this.name,
    this.parentId,
    this.resourceAccessSpec,
    this.uid,
    this.updateTime,
  });

  GoogleCloudDataplexV1DataAttribute.fromJson(core.Map json_)
      : this(
          attributeCount: json_['attributeCount'] as core.int?,
          createTime: json_['createTime'] as core.String?,
          dataAccessSpec: json_.containsKey('dataAccessSpec')
              ? GoogleCloudDataplexV1DataAccessSpec.fromJson(
                  json_['dataAccessSpec']
                      as core.Map<core.String, core.dynamic>)
              : null,
          description: json_['description'] as core.String?,
          displayName: json_['displayName'] as core.String?,
          etag: json_['etag'] as core.String?,
          labels:
              (json_['labels'] as core.Map<core.String, core.dynamic>?)?.map(
            (key, value) => core.MapEntry(
              key,
              value as core.String,
            ),
          ),
          name: json_['name'] as core.String?,
          parentId: json_['parentId'] as core.String?,
          resourceAccessSpec: json_.containsKey('resourceAccessSpec')
              ? GoogleCloudDataplexV1ResourceAccessSpec.fromJson(
                  json_['resourceAccessSpec']
                      as core.Map<core.String, core.dynamic>)
              : null,
          uid: json_['uid'] as core.String?,
          updateTime: json_['updateTime'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (attributeCount != null) 'attributeCount': attributeCount!,
        if (createTime != null) 'createTime': createTime!,
        if (dataAccessSpec != null) 'dataAccessSpec': dataAccessSpec!,
        if (description != null) 'description': description!,
        if (displayName != null) 'displayName': displayName!,
        if (etag != null) 'etag': etag!,
        if (labels != null) 'labels': labels!,
        if (name != null) 'name': name!,
        if (parentId != null) 'parentId': parentId!,
        if (resourceAccessSpec != null)
          'resourceAccessSpec': resourceAccessSpec!,
        if (uid != null) 'uid': uid!,
        if (updateTime != null) 'updateTime': updateTime!,
      };
}

/// DataAttributeBinding represents binding of attributes to resources.
///
/// Eg: Bind 'CustomerInfo' entity with 'PII' attribute.
class GoogleCloudDataplexV1DataAttributeBinding {
  /// List of attributes to be associated with the resource, provided in the
  /// form:
  /// projects/{project}/locations/{location}/dataTaxonomies/{dataTaxonomy}/attributes/{data_attribute_id}
  ///
  /// Optional.
  core.List<core.String>? attributes;

  /// The time when the DataAttributeBinding was created.
  ///
  /// Output only.
  core.String? createTime;

  /// Description of the DataAttributeBinding.
  ///
  /// Optional.
  core.String? description;

  /// User friendly display name.
  ///
  /// Optional.
  core.String? displayName;

  /// This checksum is computed by the server based on the value of other
  /// fields, and may be sent on update and delete requests to ensure the client
  /// has an up-to-date value before proceeding.
  ///
  /// Etags must be used when calling the DeleteDataAttributeBinding and the
  /// UpdateDataAttributeBinding method.
  core.String? etag;

  /// User-defined labels for the DataAttributeBinding.
  ///
  /// Optional.
  core.Map<core.String, core.String>? labels;

  /// The relative resource name of the Data Attribute Binding, of the form:
  /// projects/{project_number}/locations/{location}/dataAttributeBindings/{data_attribute_binding_id}
  ///
  /// Output only.
  core.String? name;

  /// The list of paths for items within the associated resource (eg.
  ///
  /// columns and partitions within a table) along with attribute bindings.
  ///
  /// Optional.
  core.List<GoogleCloudDataplexV1DataAttributeBindingPath>? paths;

  /// The resource name of the resource that is associated to attributes.
  ///
  /// Presently, only entity resource is supported in the form:
  /// projects/{project}/locations/{location}/lakes/{lake}/zones/{zone}/entities/{entity_id}
  /// Must belong in the same project and region as the attribute binding, and
  /// there can only exist one active binding for a resource.
  ///
  /// Optional. Immutable.
  core.String? resource;

  /// System generated globally unique ID for the DataAttributeBinding.
  ///
  /// This ID will be different if the DataAttributeBinding is deleted and
  /// re-created with the same name.
  ///
  /// Output only.
  core.String? uid;

  /// The time when the DataAttributeBinding was last updated.
  ///
  /// Output only.
  core.String? updateTime;

  GoogleCloudDataplexV1DataAttributeBinding({
    this.attributes,
    this.createTime,
    this.description,
    this.displayName,
    this.etag,
    this.labels,
    this.name,
    this.paths,
    this.resource,
    this.uid,
    this.updateTime,
  });

  GoogleCloudDataplexV1DataAttributeBinding.fromJson(core.Map json_)
      : this(
          attributes: (json_['attributes'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
          createTime: json_['createTime'] as core.String?,
          description: json_['description'] as core.String?,
          displayName: json_['displayName'] as core.String?,
          etag: json_['etag'] as core.String?,
          labels:
              (json_['labels'] as core.Map<core.String, core.dynamic>?)?.map(
            (key, value) => core.MapEntry(
              key,
              value as core.String,
            ),
          ),
          name: json_['name'] as core.String?,
          paths: (json_['paths'] as core.List?)
              ?.map((value) =>
                  GoogleCloudDataplexV1DataAttributeBindingPath.fromJson(
                      value as core.Map<core.String, core.dynamic>))
              .toList(),
          resource: json_['resource'] as core.String?,
          uid: json_['uid'] as core.String?,
          updateTime: json_['updateTime'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (attributes != null) 'attributes': attributes!,
        if (createTime != null) 'createTime': createTime!,
        if (description != null) 'description': description!,
        if (displayName != null) 'displayName': displayName!,
        if (etag != null) 'etag': etag!,
        if (labels != null) 'labels': labels!,
        if (name != null) 'name': name!,
        if (paths != null) 'paths': paths!,
        if (resource != null) 'resource': resource!,
        if (uid != null) 'uid': uid!,
        if (updateTime != null) 'updateTime': updateTime!,
      };
}

/// Represents a subresource of the given resource, and associated bindings with
/// it.
///
/// Currently supported subresources are column and partition schema fields
/// within a table.
class GoogleCloudDataplexV1DataAttributeBindingPath {
  /// List of attributes to be associated with the path of the resource,
  /// provided in the form:
  /// projects/{project}/locations/{location}/dataTaxonomies/{dataTaxonomy}/attributes/{data_attribute_id}
  ///
  /// Optional.
  core.List<core.String>? attributes;

  /// The name identifier of the path.
  ///
  /// Nested columns should be of the form: 'address.city'.
  ///
  /// Required.
  core.String? name;

  GoogleCloudDataplexV1DataAttributeBindingPath({
    this.attributes,
    this.name,
  });

  GoogleCloudDataplexV1DataAttributeBindingPath.fromJson(core.Map json_)
      : this(
          attributes: (json_['attributes'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
          name: json_['name'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (attributes != null) 'attributes': attributes!,
        if (name != null) 'name': name!,
      };
}

/// The output of a data discovery scan.
class GoogleCloudDataplexV1DataDiscoveryResult {
  /// Configuration for metadata publishing.
  ///
  /// Output only.
  GoogleCloudDataplexV1DataDiscoveryResultBigQueryPublishing?
      bigqueryPublishing;

  GoogleCloudDataplexV1DataDiscoveryResult({
    this.bigqueryPublishing,
  });

  GoogleCloudDataplexV1DataDiscoveryResult.fromJson(core.Map json_)
      : this(
          bigqueryPublishing: json_.containsKey('bigqueryPublishing')
              ? GoogleCloudDataplexV1DataDiscoveryResultBigQueryPublishing
                  .fromJson(json_['bigqueryPublishing']
                      as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (bigqueryPublishing != null)
          'bigqueryPublishing': bigqueryPublishing!,
      };
}

/// Describes BigQuery publishing configurations.
class GoogleCloudDataplexV1DataDiscoveryResultBigQueryPublishing {
  /// The BigQuery dataset to publish to.
  ///
  /// It takes the form projects/{project_id}/datasets/{dataset_id}. If not set,
  /// the service creates a default publishing dataset.
  ///
  /// Output only.
  core.String? dataset;

  GoogleCloudDataplexV1DataDiscoveryResultBigQueryPublishing({
    this.dataset,
  });

  GoogleCloudDataplexV1DataDiscoveryResultBigQueryPublishing.fromJson(
      core.Map json_)
      : this(
          dataset: json_['dataset'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (dataset != null) 'dataset': dataset!,
      };
}

/// Spec for a data discovery scan.
class GoogleCloudDataplexV1DataDiscoverySpec {
  /// Configuration for metadata publishing.
  ///
  /// Optional.
  GoogleCloudDataplexV1DataDiscoverySpecBigQueryPublishingConfig?
      bigqueryPublishingConfig;

  /// Cloud Storage related configurations.
  GoogleCloudDataplexV1DataDiscoverySpecStorageConfig? storageConfig;

  GoogleCloudDataplexV1DataDiscoverySpec({
    this.bigqueryPublishingConfig,
    this.storageConfig,
  });

  GoogleCloudDataplexV1DataDiscoverySpec.fromJson(core.Map json_)
      : this(
          bigqueryPublishingConfig: json_
                  .containsKey('bigqueryPublishingConfig')
              ? GoogleCloudDataplexV1DataDiscoverySpecBigQueryPublishingConfig
                  .fromJson(json_['bigqueryPublishingConfig']
                      as core.Map<core.String, core.dynamic>)
              : null,
          storageConfig: json_.containsKey('storageConfig')
              ? GoogleCloudDataplexV1DataDiscoverySpecStorageConfig.fromJson(
                  json_['storageConfig'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (bigqueryPublishingConfig != null)
          'bigqueryPublishingConfig': bigqueryPublishingConfig!,
        if (storageConfig != null) 'storageConfig': storageConfig!,
      };
}

/// Describes BigQuery publishing configurations.
class GoogleCloudDataplexV1DataDiscoverySpecBigQueryPublishingConfig {
  /// The BigQuery connection used to create BigLake tables.
  ///
  /// Must be in the form
  /// projects/{project_id}/locations/{location_id}/connections/{connection_id}
  ///
  /// Optional.
  core.String? connection;

  /// The location of the BigQuery dataset to publish BigLake external or
  /// non-BigLake external tables to.
  ///
  /// 1. If the Cloud Storage bucket is located in a multi-region bucket, then
  /// BigQuery dataset can be in the same multi-region bucket or any single
  /// region that is included in the same multi-region bucket. The datascan can
  /// be created in any single region that is included in the same multi-region
  /// bucket 2. If the Cloud Storage bucket is located in a dual-region bucket,
  /// then BigQuery dataset can be located in regions that are included in the
  /// dual-region bucket, or in a multi-region that includes the dual-region.
  /// The datascan can be created in any single region that is included in the
  /// same dual-region bucket. 3. If the Cloud Storage bucket is located in a
  /// single region, then BigQuery dataset can be in the same single region or
  /// any multi-region bucket that includes the same single region. The datascan
  /// will be created in the same single region as the bucket. 4. If the
  /// BigQuery dataset is in single region, it must be in the same single region
  /// as the datascan.For supported values, refer to
  /// https://cloud.google.com/bigquery/docs/locations#supported_locations.
  ///
  /// Optional.
  core.String? location;

  /// Determines whether to publish discovered tables as BigLake external tables
  /// or non-BigLake external tables.
  ///
  /// Optional.
  /// Possible string values are:
  /// - "TABLE_TYPE_UNSPECIFIED" : Table type unspecified.
  /// - "EXTERNAL" : Default. Discovered tables are published as BigQuery
  /// external tables whose data is accessed using the credentials of the user
  /// querying the table.
  /// - "BIGLAKE" : Discovered tables are published as BigLake external tables
  /// whose data is accessed using the credentials of the associated BigQuery
  /// connection.
  core.String? tableType;

  GoogleCloudDataplexV1DataDiscoverySpecBigQueryPublishingConfig({
    this.connection,
    this.location,
    this.tableType,
  });

  GoogleCloudDataplexV1DataDiscoverySpecBigQueryPublishingConfig.fromJson(
      core.Map json_)
      : this(
          connection: json_['connection'] as core.String?,
          location: json_['location'] as core.String?,
          tableType: json_['tableType'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (connection != null) 'connection': connection!,
        if (location != null) 'location': location!,
        if (tableType != null) 'tableType': tableType!,
      };
}

/// Configurations related to Cloud Storage as the data source.
class GoogleCloudDataplexV1DataDiscoverySpecStorageConfig {
  /// Configuration for CSV data.
  ///
  /// Optional.
  GoogleCloudDataplexV1DataDiscoverySpecStorageConfigCsvOptions? csvOptions;

  /// Defines the data to exclude during discovery.
  ///
  /// Provide a list of patterns that identify the data to exclude. For Cloud
  /// Storage bucket assets, these patterns are interpreted as glob patterns
  /// used to match object names. For BigQuery dataset assets, these patterns
  /// are interpreted as patterns to match table names.
  ///
  /// Optional.
  core.List<core.String>? excludePatterns;

  /// Defines the data to include during discovery when only a subset of the
  /// data should be considered.
  ///
  /// Provide a list of patterns that identify the data to include. For Cloud
  /// Storage bucket assets, these patterns are interpreted as glob patterns
  /// used to match object names. For BigQuery dataset assets, these patterns
  /// are interpreted as patterns to match table names.
  ///
  /// Optional.
  core.List<core.String>? includePatterns;

  /// Configuration for JSON data.
  ///
  /// Optional.
  GoogleCloudDataplexV1DataDiscoverySpecStorageConfigJsonOptions? jsonOptions;

  GoogleCloudDataplexV1DataDiscoverySpecStorageConfig({
    this.csvOptions,
    this.excludePatterns,
    this.includePatterns,
    this.jsonOptions,
  });

  GoogleCloudDataplexV1DataDiscoverySpecStorageConfig.fromJson(core.Map json_)
      : this(
          csvOptions: json_.containsKey('csvOptions')
              ? GoogleCloudDataplexV1DataDiscoverySpecStorageConfigCsvOptions
                  .fromJson(json_['csvOptions']
                      as core.Map<core.String, core.dynamic>)
              : null,
          excludePatterns: (json_['excludePatterns'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
          includePatterns: (json_['includePatterns'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
          jsonOptions: json_.containsKey('jsonOptions')
              ? GoogleCloudDataplexV1DataDiscoverySpecStorageConfigJsonOptions
                  .fromJson(json_['jsonOptions']
                      as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (csvOptions != null) 'csvOptions': csvOptions!,
        if (excludePatterns != null) 'excludePatterns': excludePatterns!,
        if (includePatterns != null) 'includePatterns': includePatterns!,
        if (jsonOptions != null) 'jsonOptions': jsonOptions!,
      };
}

/// Describes CSV and similar semi-structured data formats.
class GoogleCloudDataplexV1DataDiscoverySpecStorageConfigCsvOptions {
  /// The delimiter that is used to separate values.
  ///
  /// The default is , (comma).
  ///
  /// Optional.
  core.String? delimiter;

  /// The character encoding of the data.
  ///
  /// The default is UTF-8.
  ///
  /// Optional.
  core.String? encoding;

  /// The number of rows to interpret as header rows that should be skipped when
  /// reading data rows.
  ///
  /// Optional.
  core.int? headerRows;

  /// The character used to quote column values.
  ///
  /// Accepts " (double quotation mark) or ' (single quotation mark). If
  /// unspecified, defaults to " (double quotation mark).
  ///
  /// Optional.
  core.String? quote;

  /// Whether to disable the inference of data types for CSV data.
  ///
  /// If true, all columns are registered as strings.
  ///
  /// Optional.
  core.bool? typeInferenceDisabled;

  GoogleCloudDataplexV1DataDiscoverySpecStorageConfigCsvOptions({
    this.delimiter,
    this.encoding,
    this.headerRows,
    this.quote,
    this.typeInferenceDisabled,
  });

  GoogleCloudDataplexV1DataDiscoverySpecStorageConfigCsvOptions.fromJson(
      core.Map json_)
      : this(
          delimiter: json_['delimiter'] as core.String?,
          encoding: json_['encoding'] as core.String?,
          headerRows: json_['headerRows'] as core.int?,
          quote: json_['quote'] as core.String?,
          typeInferenceDisabled: json_['typeInferenceDisabled'] as core.bool?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (delimiter != null) 'delimiter': delimiter!,
        if (encoding != null) 'encoding': encoding!,
        if (headerRows != null) 'headerRows': headerRows!,
        if (quote != null) 'quote': quote!,
        if (typeInferenceDisabled != null)
          'typeInferenceDisabled': typeInferenceDisabled!,
      };
}

/// Describes JSON data format.
class GoogleCloudDataplexV1DataDiscoverySpecStorageConfigJsonOptions {
  /// The character encoding of the data.
  ///
  /// The default is UTF-8.
  ///
  /// Optional.
  core.String? encoding;

  /// Whether to disable the inference of data types for JSON data.
  ///
  /// If true, all columns are registered as their primitive types (strings,
  /// number, or boolean).
  ///
  /// Optional.
  core.bool? typeInferenceDisabled;

  GoogleCloudDataplexV1DataDiscoverySpecStorageConfigJsonOptions({
    this.encoding,
    this.typeInferenceDisabled,
  });

  GoogleCloudDataplexV1DataDiscoverySpecStorageConfigJsonOptions.fromJson(
      core.Map json_)
      : this(
          encoding: json_['encoding'] as core.String?,
          typeInferenceDisabled: json_['typeInferenceDisabled'] as core.bool?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (encoding != null) 'encoding': encoding!,
        if (typeInferenceDisabled != null)
          'typeInferenceDisabled': typeInferenceDisabled!,
      };
}

/// DataProfileResult defines the output of DataProfileScan.
///
/// Each field of the table will have field type specific profile result.
class GoogleCloudDataplexV1DataProfileResult {
  /// The result of post scan actions.
  ///
  /// Output only.
  GoogleCloudDataplexV1DataProfileResultPostScanActionsResult?
      postScanActionsResult;

  /// The profile information per field.
  GoogleCloudDataplexV1DataProfileResultProfile? profile;

  /// The count of rows scanned.
  core.String? rowCount;

  /// The data scanned for this result.
  GoogleCloudDataplexV1ScannedData? scannedData;

  GoogleCloudDataplexV1DataProfileResult({
    this.postScanActionsResult,
    this.profile,
    this.rowCount,
    this.scannedData,
  });

  GoogleCloudDataplexV1DataProfileResult.fromJson(core.Map json_)
      : this(
          postScanActionsResult: json_.containsKey('postScanActionsResult')
              ? GoogleCloudDataplexV1DataProfileResultPostScanActionsResult
                  .fromJson(json_['postScanActionsResult']
                      as core.Map<core.String, core.dynamic>)
              : null,
          profile: json_.containsKey('profile')
              ? GoogleCloudDataplexV1DataProfileResultProfile.fromJson(
                  json_['profile'] as core.Map<core.String, core.dynamic>)
              : null,
          rowCount: json_['rowCount'] as core.String?,
          scannedData: json_.containsKey('scannedData')
              ? GoogleCloudDataplexV1ScannedData.fromJson(
                  json_['scannedData'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (postScanActionsResult != null)
          'postScanActionsResult': postScanActionsResult!,
        if (profile != null) 'profile': profile!,
        if (rowCount != null) 'rowCount': rowCount!,
        if (scannedData != null) 'scannedData': scannedData!,
      };
}

/// The result of post scan actions of DataProfileScan job.
class GoogleCloudDataplexV1DataProfileResultPostScanActionsResult {
  /// The result of BigQuery export post scan action.
  ///
  /// Output only.
  GoogleCloudDataplexV1DataProfileResultPostScanActionsResultBigQueryExportResult?
      bigqueryExportResult;

  GoogleCloudDataplexV1DataProfileResultPostScanActionsResult({
    this.bigqueryExportResult,
  });

  GoogleCloudDataplexV1DataProfileResultPostScanActionsResult.fromJson(
      core.Map json_)
      : this(
          bigqueryExportResult: json_.containsKey('bigqueryExportResult')
              ? GoogleCloudDataplexV1DataProfileResultPostScanActionsResultBigQueryExportResult
                  .fromJson(json_['bigqueryExportResult']
                      as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (bigqueryExportResult != null)
          'bigqueryExportResult': bigqueryExportResult!,
      };
}

/// The result of BigQuery export post scan action.
typedef GoogleCloudDataplexV1DataProfileResultPostScanActionsResultBigQueryExportResult
    = $ResultPostScanActionsResultBigQueryExportResult;

/// Contains name, type, mode and field type specific profile information.
class GoogleCloudDataplexV1DataProfileResultProfile {
  /// List of fields with structural and profile information for each field.
  core.List<GoogleCloudDataplexV1DataProfileResultProfileField>? fields;

  GoogleCloudDataplexV1DataProfileResultProfile({
    this.fields,
  });

  GoogleCloudDataplexV1DataProfileResultProfile.fromJson(core.Map json_)
      : this(
          fields: (json_['fields'] as core.List?)
              ?.map((value) =>
                  GoogleCloudDataplexV1DataProfileResultProfileField.fromJson(
                      value as core.Map<core.String, core.dynamic>))
              .toList(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (fields != null) 'fields': fields!,
      };
}

/// A field within a table.
class GoogleCloudDataplexV1DataProfileResultProfileField {
  /// The mode of the field.
  ///
  /// Possible values include: REQUIRED, if it is a required field. NULLABLE, if
  /// it is an optional field. REPEATED, if it is a repeated field.
  core.String? mode;

  /// The name of the field.
  core.String? name;

  /// Profile information for the corresponding field.
  GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfo? profile;

  /// The data type retrieved from the schema of the data source.
  ///
  /// For instance, for a BigQuery native table, it is the BigQuery Table Schema
  /// (https://cloud.google.com/bigquery/docs/reference/rest/v2/tables#tablefieldschema).
  /// For a Dataplex Entity, it is the Entity Schema
  /// (https://cloud.google.com/dataplex/docs/reference/rpc/google.cloud.dataplex.v1#type_3).
  core.String? type;

  GoogleCloudDataplexV1DataProfileResultProfileField({
    this.mode,
    this.name,
    this.profile,
    this.type,
  });

  GoogleCloudDataplexV1DataProfileResultProfileField.fromJson(core.Map json_)
      : this(
          mode: json_['mode'] as core.String?,
          name: json_['name'] as core.String?,
          profile: json_.containsKey('profile')
              ? GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfo
                  .fromJson(
                      json_['profile'] as core.Map<core.String, core.dynamic>)
              : null,
          type: json_['type'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (mode != null) 'mode': mode!,
        if (name != null) 'name': name!,
        if (profile != null) 'profile': profile!,
        if (type != null) 'type': type!,
      };
}

/// The profile information for each field type.
class GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfo {
  /// Ratio of rows with distinct values against total scanned rows.
  ///
  /// Not available for complex non-groupable field type, including RECORD,
  /// ARRAY, GEOGRAPHY, and JSON, as well as fields with REPEATABLE mode.
  core.double? distinctRatio;

  /// Double type field information.
  GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoDoubleFieldInfo?
      doubleProfile;

  /// Integer type field information.
  GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoIntegerFieldInfo?
      integerProfile;

  /// Ratio of rows with null value against total scanned rows.
  core.double? nullRatio;

  /// String type field information.
  GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoStringFieldInfo?
      stringProfile;

  /// The list of top N non-null values, frequency and ratio with which they
  /// occur in the scanned data.
  ///
  /// N is 10 or equal to the number of distinct values in the field, whichever
  /// is smaller. Not available for complex non-groupable field type, including
  /// RECORD, ARRAY, GEOGRAPHY, and JSON, as well as fields with REPEATABLE
  /// mode.
  core.List<
          GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoTopNValue>?
      topNValues;

  GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfo({
    this.distinctRatio,
    this.doubleProfile,
    this.integerProfile,
    this.nullRatio,
    this.stringProfile,
    this.topNValues,
  });

  GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfo.fromJson(
      core.Map json_)
      : this(
          distinctRatio: (json_['distinctRatio'] as core.num?)?.toDouble(),
          doubleProfile: json_.containsKey('doubleProfile')
              ? GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoDoubleFieldInfo
                  .fromJson(json_['doubleProfile']
                      as core.Map<core.String, core.dynamic>)
              : null,
          integerProfile: json_.containsKey('integerProfile')
              ? GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoIntegerFieldInfo
                  .fromJson(json_['integerProfile']
                      as core.Map<core.String, core.dynamic>)
              : null,
          nullRatio: (json_['nullRatio'] as core.num?)?.toDouble(),
          stringProfile: json_.containsKey('stringProfile')
              ? GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoStringFieldInfo
                  .fromJson(json_['stringProfile']
                      as core.Map<core.String, core.dynamic>)
              : null,
          topNValues: (json_['topNValues'] as core.List?)
              ?.map((value) =>
                  GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoTopNValue
                      .fromJson(value as core.Map<core.String, core.dynamic>))
              .toList(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (distinctRatio != null) 'distinctRatio': distinctRatio!,
        if (doubleProfile != null) 'doubleProfile': doubleProfile!,
        if (integerProfile != null) 'integerProfile': integerProfile!,
        if (nullRatio != null) 'nullRatio': nullRatio!,
        if (stringProfile != null) 'stringProfile': stringProfile!,
        if (topNValues != null) 'topNValues': topNValues!,
      };
}

/// The profile information for a double type field.
class GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoDoubleFieldInfo {
  /// Average of non-null values in the scanned data.
  ///
  /// NaN, if the field has a NaN.
  core.double? average;

  /// Maximum of non-null values in the scanned data.
  ///
  /// NaN, if the field has a NaN.
  core.double? max;

  /// Minimum of non-null values in the scanned data.
  ///
  /// NaN, if the field has a NaN.
  core.double? min;

  /// A quartile divides the number of data points into four parts, or quarters,
  /// of more-or-less equal size.
  ///
  /// Three main quartiles used are: The first quartile (Q1) splits off the
  /// lowest 25% of data from the highest 75%. It is also known as the lower or
  /// 25th empirical quartile, as 25% of the data is below this point. The
  /// second quartile (Q2) is the median of a data set. So, 50% of the data lies
  /// below this point. The third quartile (Q3) splits off the highest 25% of
  /// data from the lowest 75%. It is known as the upper or 75th empirical
  /// quartile, as 75% of the data lies below this point. Here, the quartiles is
  /// provided as an ordered list of quartile values for the scanned data,
  /// occurring in order Q1, median, Q3.
  core.List<core.double>? quartiles;

  /// Standard deviation of non-null values in the scanned data.
  ///
  /// NaN, if the field has a NaN.
  core.double? standardDeviation;

  GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoDoubleFieldInfo({
    this.average,
    this.max,
    this.min,
    this.quartiles,
    this.standardDeviation,
  });

  GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoDoubleFieldInfo.fromJson(
      core.Map json_)
      : this(
          average: (json_['average'] as core.num?)?.toDouble(),
          max: (json_['max'] as core.num?)?.toDouble(),
          min: (json_['min'] as core.num?)?.toDouble(),
          quartiles: (json_['quartiles'] as core.List?)
              ?.map((value) => (value as core.num).toDouble())
              .toList(),
          standardDeviation:
              (json_['standardDeviation'] as core.num?)?.toDouble(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (average != null) 'average': average!,
        if (max != null) 'max': max!,
        if (min != null) 'min': min!,
        if (quartiles != null) 'quartiles': quartiles!,
        if (standardDeviation != null) 'standardDeviation': standardDeviation!,
      };
}

/// The profile information for an integer type field.
class GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoIntegerFieldInfo {
  /// Average of non-null values in the scanned data.
  ///
  /// NaN, if the field has a NaN.
  core.double? average;

  /// Maximum of non-null values in the scanned data.
  ///
  /// NaN, if the field has a NaN.
  core.String? max;

  /// Minimum of non-null values in the scanned data.
  ///
  /// NaN, if the field has a NaN.
  core.String? min;

  /// A quartile divides the number of data points into four parts, or quarters,
  /// of more-or-less equal size.
  ///
  /// Three main quartiles used are: The first quartile (Q1) splits off the
  /// lowest 25% of data from the highest 75%. It is also known as the lower or
  /// 25th empirical quartile, as 25% of the data is below this point. The
  /// second quartile (Q2) is the median of a data set. So, 50% of the data lies
  /// below this point. The third quartile (Q3) splits off the highest 25% of
  /// data from the lowest 75%. It is known as the upper or 75th empirical
  /// quartile, as 75% of the data lies below this point. Here, the quartiles is
  /// provided as an ordered list of approximate quartile values for the scanned
  /// data, occurring in order Q1, median, Q3.
  core.List<core.String>? quartiles;

  /// Standard deviation of non-null values in the scanned data.
  ///
  /// NaN, if the field has a NaN.
  core.double? standardDeviation;

  GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoIntegerFieldInfo({
    this.average,
    this.max,
    this.min,
    this.quartiles,
    this.standardDeviation,
  });

  GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoIntegerFieldInfo.fromJson(
      core.Map json_)
      : this(
          average: (json_['average'] as core.num?)?.toDouble(),
          max: json_['max'] as core.String?,
          min: json_['min'] as core.String?,
          quartiles: (json_['quartiles'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
          standardDeviation:
              (json_['standardDeviation'] as core.num?)?.toDouble(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (average != null) 'average': average!,
        if (max != null) 'max': max!,
        if (min != null) 'min': min!,
        if (quartiles != null) 'quartiles': quartiles!,
        if (standardDeviation != null) 'standardDeviation': standardDeviation!,
      };
}

/// The profile information for a string type field.
class GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoStringFieldInfo {
  /// Average length of non-null values in the scanned data.
  core.double? averageLength;

  /// Maximum length of non-null values in the scanned data.
  core.String? maxLength;

  /// Minimum length of non-null values in the scanned data.
  core.String? minLength;

  GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoStringFieldInfo({
    this.averageLength,
    this.maxLength,
    this.minLength,
  });

  GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoStringFieldInfo.fromJson(
      core.Map json_)
      : this(
          averageLength: (json_['averageLength'] as core.num?)?.toDouble(),
          maxLength: json_['maxLength'] as core.String?,
          minLength: json_['minLength'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (averageLength != null) 'averageLength': averageLength!,
        if (maxLength != null) 'maxLength': maxLength!,
        if (minLength != null) 'minLength': minLength!,
      };
}

/// Top N non-null values in the scanned data.
class GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoTopNValue {
  /// Count of the corresponding value in the scanned data.
  core.String? count;

  /// Ratio of the corresponding value in the field against the total number of
  /// rows in the scanned data.
  core.double? ratio;

  /// String value of a top N non-null value.
  core.String? value;

  GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoTopNValue({
    this.count,
    this.ratio,
    this.value,
  });

  GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoTopNValue.fromJson(
      core.Map json_)
      : this(
          count: json_['count'] as core.String?,
          ratio: (json_['ratio'] as core.num?)?.toDouble(),
          value: json_['value'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (count != null) 'count': count!,
        if (ratio != null) 'ratio': ratio!,
        if (value != null) 'value': value!,
      };
}

/// DataProfileScan related setting.
class GoogleCloudDataplexV1DataProfileSpec {
  /// The fields to exclude from data profile.If specified, the fields will be
  /// excluded from data profile, regardless of include_fields value.
  ///
  /// Optional.
  GoogleCloudDataplexV1DataProfileSpecSelectedFields? excludeFields;

  /// The fields to include in data profile.If not specified, all fields at the
  /// time of profile scan job execution are included, except for ones listed in
  /// exclude_fields.
  ///
  /// Optional.
  GoogleCloudDataplexV1DataProfileSpecSelectedFields? includeFields;

  /// Actions to take upon job completion..
  ///
  /// Optional.
  GoogleCloudDataplexV1DataProfileSpecPostScanActions? postScanActions;

  /// A filter applied to all rows in a single DataScan job.
  ///
  /// The filter needs to be a valid SQL expression for a WHERE clause in
  /// GoogleSQL syntax
  /// (https://cloud.google.com/bigquery/docs/reference/standard-sql/query-syntax#where_clause).Example:
  /// col1 \>= 0 AND col2 \< 10
  ///
  /// Optional.
  core.String? rowFilter;

  /// The percentage of the records to be selected from the dataset for
  /// DataScan.
  ///
  /// Value can range between 0.0 and 100.0 with up to 3 significant decimal
  /// digits. Sampling is not applied if sampling_percent is not specified, 0 or
  /// 100.
  ///
  /// Optional.
  core.double? samplingPercent;

  GoogleCloudDataplexV1DataProfileSpec({
    this.excludeFields,
    this.includeFields,
    this.postScanActions,
    this.rowFilter,
    this.samplingPercent,
  });

  GoogleCloudDataplexV1DataProfileSpec.fromJson(core.Map json_)
      : this(
          excludeFields: json_.containsKey('excludeFields')
              ? GoogleCloudDataplexV1DataProfileSpecSelectedFields.fromJson(
                  json_['excludeFields'] as core.Map<core.String, core.dynamic>)
              : null,
          includeFields: json_.containsKey('includeFields')
              ? GoogleCloudDataplexV1DataProfileSpecSelectedFields.fromJson(
                  json_['includeFields'] as core.Map<core.String, core.dynamic>)
              : null,
          postScanActions: json_.containsKey('postScanActions')
              ? GoogleCloudDataplexV1DataProfileSpecPostScanActions.fromJson(
                  json_['postScanActions']
                      as core.Map<core.String, core.dynamic>)
              : null,
          rowFilter: json_['rowFilter'] as core.String?,
          samplingPercent: (json_['samplingPercent'] as core.num?)?.toDouble(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (excludeFields != null) 'excludeFields': excludeFields!,
        if (includeFields != null) 'includeFields': includeFields!,
        if (postScanActions != null) 'postScanActions': postScanActions!,
        if (rowFilter != null) 'rowFilter': rowFilter!,
        if (samplingPercent != null) 'samplingPercent': samplingPercent!,
      };
}

/// The configuration of post scan actions of DataProfileScan job.
class GoogleCloudDataplexV1DataProfileSpecPostScanActions {
  /// If set, results will be exported to the provided BigQuery table.
  ///
  /// Optional.
  GoogleCloudDataplexV1DataProfileSpecPostScanActionsBigQueryExport?
      bigqueryExport;

  GoogleCloudDataplexV1DataProfileSpecPostScanActions({
    this.bigqueryExport,
  });

  GoogleCloudDataplexV1DataProfileSpecPostScanActions.fromJson(core.Map json_)
      : this(
          bigqueryExport: json_.containsKey('bigqueryExport')
              ? GoogleCloudDataplexV1DataProfileSpecPostScanActionsBigQueryExport
                  .fromJson(json_['bigqueryExport']
                      as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (bigqueryExport != null) 'bigqueryExport': bigqueryExport!,
      };
}

/// The configuration of BigQuery export post scan action.
class GoogleCloudDataplexV1DataProfileSpecPostScanActionsBigQueryExport {
  /// The BigQuery table to export DataProfileScan results to.
  ///
  /// Format:
  /// //bigquery.googleapis.com/projects/PROJECT_ID/datasets/DATASET_ID/tables/TABLE_ID
  ///
  /// Optional.
  core.String? resultsTable;

  GoogleCloudDataplexV1DataProfileSpecPostScanActionsBigQueryExport({
    this.resultsTable,
  });

  GoogleCloudDataplexV1DataProfileSpecPostScanActionsBigQueryExport.fromJson(
      core.Map json_)
      : this(
          resultsTable: json_['resultsTable'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (resultsTable != null) 'resultsTable': resultsTable!,
      };
}

/// The specification for fields to include or exclude in data profile scan.
class GoogleCloudDataplexV1DataProfileSpecSelectedFields {
  /// Expected input is a list of fully qualified names of fields as in the
  /// schema.Only top-level field names for nested fields are supported.
  ///
  /// For instance, if 'x' is of nested field type, listing 'x' is supported but
  /// 'x.y.z' is not supported. Here 'y' and 'y.z' are nested fields of 'x'.
  ///
  /// Optional.
  core.List<core.String>? fieldNames;

  GoogleCloudDataplexV1DataProfileSpecSelectedFields({
    this.fieldNames,
  });

  GoogleCloudDataplexV1DataProfileSpecSelectedFields.fromJson(core.Map json_)
      : this(
          fieldNames: (json_['fieldNames'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (fieldNames != null) 'fieldNames': fieldNames!,
      };
}

/// DataQualityColumnResult provides a more detailed, per-column view of the
/// results.
class GoogleCloudDataplexV1DataQualityColumnResult {
  /// The column specified in the DataQualityRule.
  ///
  /// Output only.
  core.String? column;

  /// The column-level data quality score for this data scan job if and only if
  /// the 'column' field is set.The score ranges between between 0, 100 (up to
  /// two decimal points).
  ///
  /// Output only.
  core.double? score;

  GoogleCloudDataplexV1DataQualityColumnResult({
    this.column,
    this.score,
  });

  GoogleCloudDataplexV1DataQualityColumnResult.fromJson(core.Map json_)
      : this(
          column: json_['column'] as core.String?,
          score: (json_['score'] as core.num?)?.toDouble(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (column != null) 'column': column!,
        if (score != null) 'score': score!,
      };
}

/// A dimension captures data quality intent about a defined subset of the rules
/// specified.
class GoogleCloudDataplexV1DataQualityDimension {
  /// The dimension name a rule belongs to.
  ///
  /// Supported dimensions are "COMPLETENESS", "ACCURACY", "CONSISTENCY",
  /// "VALIDITY", "UNIQUENESS", "FRESHNESS", "VOLUME"
  core.String? name;

  GoogleCloudDataplexV1DataQualityDimension({
    this.name,
  });

  GoogleCloudDataplexV1DataQualityDimension.fromJson(core.Map json_)
      : this(
          name: json_['name'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (name != null) 'name': name!,
      };
}

/// DataQualityDimensionResult provides a more detailed, per-dimension view of
/// the results.
class GoogleCloudDataplexV1DataQualityDimensionResult {
  /// The dimension config specified in the DataQualitySpec, as is.
  ///
  /// Output only.
  GoogleCloudDataplexV1DataQualityDimension? dimension;

  /// Whether the dimension passed or failed.
  core.bool? passed;

  /// The dimension-level data quality score for this data scan job if and only
  /// if the 'dimension' field is set.The score ranges between 0, 100 (up to two
  /// decimal points).
  ///
  /// Output only.
  core.double? score;

  GoogleCloudDataplexV1DataQualityDimensionResult({
    this.dimension,
    this.passed,
    this.score,
  });

  GoogleCloudDataplexV1DataQualityDimensionResult.fromJson(core.Map json_)
      : this(
          dimension: json_.containsKey('dimension')
              ? GoogleCloudDataplexV1DataQualityDimension.fromJson(
                  json_['dimension'] as core.Map<core.String, core.dynamic>)
              : null,
          passed: json_['passed'] as core.bool?,
          score: (json_['score'] as core.num?)?.toDouble(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (dimension != null) 'dimension': dimension!,
        if (passed != null) 'passed': passed!,
        if (score != null) 'score': score!,
      };
}

/// The output of a DataQualityScan.
class GoogleCloudDataplexV1DataQualityResult {
  /// A list of results at the column level.A column will have a corresponding
  /// DataQualityColumnResult if and only if there is at least one rule with the
  /// 'column' field set to it.
  ///
  /// Output only.
  core.List<GoogleCloudDataplexV1DataQualityColumnResult>? columns;

  /// A list of results at the dimension level.A dimension will have a
  /// corresponding DataQualityDimensionResult if and only if there is at least
  /// one rule with the 'dimension' field set to it.
  core.List<GoogleCloudDataplexV1DataQualityDimensionResult>? dimensions;

  /// Overall data quality result -- true if all rules passed.
  core.bool? passed;

  /// The result of post scan actions.
  ///
  /// Output only.
  GoogleCloudDataplexV1DataQualityResultPostScanActionsResult?
      postScanActionsResult;

  /// The count of rows processed.
  core.String? rowCount;

  /// A list of all the rules in a job, and their results.
  core.List<GoogleCloudDataplexV1DataQualityRuleResult>? rules;

  /// The data scanned for this result.
  GoogleCloudDataplexV1ScannedData? scannedData;

  /// The overall data quality score.The score ranges between 0, 100 (up to two
  /// decimal points).
  ///
  /// Output only.
  core.double? score;

  GoogleCloudDataplexV1DataQualityResult({
    this.columns,
    this.dimensions,
    this.passed,
    this.postScanActionsResult,
    this.rowCount,
    this.rules,
    this.scannedData,
    this.score,
  });

  GoogleCloudDataplexV1DataQualityResult.fromJson(core.Map json_)
      : this(
          columns: (json_['columns'] as core.List?)
              ?.map((value) =>
                  GoogleCloudDataplexV1DataQualityColumnResult.fromJson(
                      value as core.Map<core.String, core.dynamic>))
              .toList(),
          dimensions: (json_['dimensions'] as core.List?)
              ?.map((value) =>
                  GoogleCloudDataplexV1DataQualityDimensionResult.fromJson(
                      value as core.Map<core.String, core.dynamic>))
              .toList(),
          passed: json_['passed'] as core.bool?,
          postScanActionsResult: json_.containsKey('postScanActionsResult')
              ? GoogleCloudDataplexV1DataQualityResultPostScanActionsResult
                  .fromJson(json_['postScanActionsResult']
                      as core.Map<core.String, core.dynamic>)
              : null,
          rowCount: json_['rowCount'] as core.String?,
          rules: (json_['rules'] as core.List?)
              ?.map((value) =>
                  GoogleCloudDataplexV1DataQualityRuleResult.fromJson(
                      value as core.Map<core.String, core.dynamic>))
              .toList(),
          scannedData: json_.containsKey('scannedData')
              ? GoogleCloudDataplexV1ScannedData.fromJson(
                  json_['scannedData'] as core.Map<core.String, core.dynamic>)
              : null,
          score: (json_['score'] as core.num?)?.toDouble(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (columns != null) 'columns': columns!,
        if (dimensions != null) 'dimensions': dimensions!,
        if (passed != null) 'passed': passed!,
        if (postScanActionsResult != null)
          'postScanActionsResult': postScanActionsResult!,
        if (rowCount != null) 'rowCount': rowCount!,
        if (rules != null) 'rules': rules!,
        if (scannedData != null) 'scannedData': scannedData!,
        if (score != null) 'score': score!,
      };
}

/// The result of post scan actions of DataQualityScan job.
class GoogleCloudDataplexV1DataQualityResultPostScanActionsResult {
  /// The result of BigQuery export post scan action.
  ///
  /// Output only.
  GoogleCloudDataplexV1DataQualityResultPostScanActionsResultBigQueryExportResult?
      bigqueryExportResult;

  GoogleCloudDataplexV1DataQualityResultPostScanActionsResult({
    this.bigqueryExportResult,
  });

  GoogleCloudDataplexV1DataQualityResultPostScanActionsResult.fromJson(
      core.Map json_)
      : this(
          bigqueryExportResult: json_.containsKey('bigqueryExportResult')
              ? GoogleCloudDataplexV1DataQualityResultPostScanActionsResultBigQueryExportResult
                  .fromJson(json_['bigqueryExportResult']
                      as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (bigqueryExportResult != null)
          'bigqueryExportResult': bigqueryExportResult!,
      };
}

/// The result of BigQuery export post scan action.
typedef GoogleCloudDataplexV1DataQualityResultPostScanActionsResultBigQueryExportResult
    = $ResultPostScanActionsResultBigQueryExportResult;

/// A rule captures data quality intent about a data source.
class GoogleCloudDataplexV1DataQualityRule {
  /// The unnested column which this rule is evaluated against.
  ///
  /// Optional.
  core.String? column;

  /// Description of the rule.
  ///
  /// The maximum length is 1,024 characters.
  ///
  /// Optional.
  core.String? description;

  /// The dimension a rule belongs to.
  ///
  /// Results are also aggregated at the dimension level. Supported dimensions
  /// are "COMPLETENESS", "ACCURACY", "CONSISTENCY", "VALIDITY", "UNIQUENESS",
  /// "FRESHNESS", "VOLUME"
  ///
  /// Required.
  core.String? dimension;

  /// Rows with null values will automatically fail a rule, unless ignore_null
  /// is true.
  ///
  /// In that case, such null rows are trivially considered passing.This field
  /// is only valid for the following type of rules: RangeExpectation
  /// RegexExpectation SetExpectation UniquenessExpectation
  ///
  /// Optional.
  core.bool? ignoreNull;

  /// A mutable name for the rule.
  ///
  /// The name must contain only letters (a-z, A-Z), numbers (0-9), or hyphens
  /// (-). The maximum length is 63 characters. Must start with a letter. Must
  /// end with a number or a letter.
  ///
  /// Optional.
  core.String? name;

  /// Row-level rule which evaluates whether each column value is null.
  GoogleCloudDataplexV1DataQualityRuleNonNullExpectation? nonNullExpectation;

  /// Row-level rule which evaluates whether each column value lies between a
  /// specified range.
  GoogleCloudDataplexV1DataQualityRuleRangeExpectation? rangeExpectation;

  /// Row-level rule which evaluates whether each column value matches a
  /// specified regex.
  GoogleCloudDataplexV1DataQualityRuleRegexExpectation? regexExpectation;

  /// Row-level rule which evaluates whether each row in a table passes the
  /// specified condition.
  GoogleCloudDataplexV1DataQualityRuleRowConditionExpectation?
      rowConditionExpectation;

  /// Row-level rule which evaluates whether each column value is contained by a
  /// specified set.
  GoogleCloudDataplexV1DataQualityRuleSetExpectation? setExpectation;

  /// Aggregate rule which evaluates the number of rows returned for the
  /// provided statement.
  ///
  /// If any rows are returned, this rule fails.
  GoogleCloudDataplexV1DataQualityRuleSqlAssertion? sqlAssertion;

  /// Aggregate rule which evaluates whether the column aggregate statistic lies
  /// between a specified range.
  GoogleCloudDataplexV1DataQualityRuleStatisticRangeExpectation?
      statisticRangeExpectation;

  /// Whether the Rule is active or suspended.
  ///
  /// Default is false.
  ///
  /// Optional.
  core.bool? suspended;

  /// Aggregate rule which evaluates whether the provided expression is true for
  /// a table.
  GoogleCloudDataplexV1DataQualityRuleTableConditionExpectation?
      tableConditionExpectation;

  /// The minimum ratio of passing_rows / total_rows required to pass this rule,
  /// with a range of 0.0, 1.0.0 indicates default value (i.e. 1.0).This field
  /// is only valid for row-level type rules.
  ///
  /// Optional.
  core.double? threshold;

  /// Row-level rule which evaluates whether each column value is unique.
  GoogleCloudDataplexV1DataQualityRuleUniquenessExpectation?
      uniquenessExpectation;

  GoogleCloudDataplexV1DataQualityRule({
    this.column,
    this.description,
    this.dimension,
    this.ignoreNull,
    this.name,
    this.nonNullExpectation,
    this.rangeExpectation,
    this.regexExpectation,
    this.rowConditionExpectation,
    this.setExpectation,
    this.sqlAssertion,
    this.statisticRangeExpectation,
    this.suspended,
    this.tableConditionExpectation,
    this.threshold,
    this.uniquenessExpectation,
  });

  GoogleCloudDataplexV1DataQualityRule.fromJson(core.Map json_)
      : this(
          column: json_['column'] as core.String?,
          description: json_['description'] as core.String?,
          dimension: json_['dimension'] as core.String?,
          ignoreNull: json_['ignoreNull'] as core.bool?,
          name: json_['name'] as core.String?,
          nonNullExpectation: json_.containsKey('nonNullExpectation')
              ? GoogleCloudDataplexV1DataQualityRuleNonNullExpectation.fromJson(
                  json_['nonNullExpectation']
                      as core.Map<core.String, core.dynamic>)
              : null,
          rangeExpectation: json_.containsKey('rangeExpectation')
              ? GoogleCloudDataplexV1DataQualityRuleRangeExpectation.fromJson(
                  json_['rangeExpectation']
                      as core.Map<core.String, core.dynamic>)
              : null,
          regexExpectation: json_.containsKey('regexExpectation')
              ? GoogleCloudDataplexV1DataQualityRuleRegexExpectation.fromJson(
                  json_['regexExpectation']
                      as core.Map<core.String, core.dynamic>)
              : null,
          rowConditionExpectation: json_.containsKey('rowConditionExpectation')
              ? GoogleCloudDataplexV1DataQualityRuleRowConditionExpectation
                  .fromJson(json_['rowConditionExpectation']
                      as core.Map<core.String, core.dynamic>)
              : null,
          setExpectation: json_.containsKey('setExpectation')
              ? GoogleCloudDataplexV1DataQualityRuleSetExpectation.fromJson(
                  json_['setExpectation']
                      as core.Map<core.String, core.dynamic>)
              : null,
          sqlAssertion: json_.containsKey('sqlAssertion')
              ? GoogleCloudDataplexV1DataQualityRuleSqlAssertion.fromJson(
                  json_['sqlAssertion'] as core.Map<core.String, core.dynamic>)
              : null,
          statisticRangeExpectation: json_
                  .containsKey('statisticRangeExpectation')
              ? GoogleCloudDataplexV1DataQualityRuleStatisticRangeExpectation
                  .fromJson(json_['statisticRangeExpectation']
                      as core.Map<core.String, core.dynamic>)
              : null,
          suspended: json_['suspended'] as core.bool?,
          tableConditionExpectation: json_
                  .containsKey('tableConditionExpectation')
              ? GoogleCloudDataplexV1DataQualityRuleTableConditionExpectation
                  .fromJson(json_['tableConditionExpectation']
                      as core.Map<core.String, core.dynamic>)
              : null,
          threshold: (json_['threshold'] as core.num?)?.toDouble(),
          uniquenessExpectation: json_.containsKey('uniquenessExpectation')
              ? GoogleCloudDataplexV1DataQualityRuleUniquenessExpectation
                  .fromJson(json_['uniquenessExpectation']
                      as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (column != null) 'column': column!,
        if (description != null) 'description': description!,
        if (dimension != null) 'dimension': dimension!,
        if (ignoreNull != null) 'ignoreNull': ignoreNull!,
        if (name != null) 'name': name!,
        if (nonNullExpectation != null)
          'nonNullExpectation': nonNullExpectation!,
        if (rangeExpectation != null) 'rangeExpectation': rangeExpectation!,
        if (regexExpectation != null) 'regexExpectation': regexExpectation!,
        if (rowConditionExpectation != null)
          'rowConditionExpectation': rowConditionExpectation!,
        if (setExpectation != null) 'setExpectation': setExpectation!,
        if (sqlAssertion != null) 'sqlAssertion': sqlAssertion!,
        if (statisticRangeExpectation != null)
          'statisticRangeExpectation': statisticRangeExpectation!,
        if (suspended != null) 'suspended': suspended!,
        if (tableConditionExpectation != null)
          'tableConditionExpectation': tableConditionExpectation!,
        if (threshold != null) 'threshold': threshold!,
        if (uniquenessExpectation != null)
          'uniquenessExpectation': uniquenessExpectation!,
      };
}

/// Evaluates whether each column value is null.
typedef GoogleCloudDataplexV1DataQualityRuleNonNullExpectation = $Empty;

/// Evaluates whether each column value lies between a specified range.
class GoogleCloudDataplexV1DataQualityRuleRangeExpectation {
  /// The maximum column value allowed for a row to pass this validation.
  ///
  /// At least one of min_value and max_value need to be provided.
  ///
  /// Optional.
  core.String? maxValue;

  /// The minimum column value allowed for a row to pass this validation.
  ///
  /// At least one of min_value and max_value need to be provided.
  ///
  /// Optional.
  core.String? minValue;

  /// Whether each value needs to be strictly lesser than ('\<') the maximum, or
  /// if equality is allowed.Only relevant if a max_value has been defined.
  ///
  /// Default = false.
  ///
  /// Optional.
  core.bool? strictMaxEnabled;

  /// Whether each value needs to be strictly greater than ('\>') the minimum,
  /// or if equality is allowed.Only relevant if a min_value has been defined.
  ///
  /// Default = false.
  ///
  /// Optional.
  core.bool? strictMinEnabled;

  GoogleCloudDataplexV1DataQualityRuleRangeExpectation({
    this.maxValue,
    this.minValue,
    this.strictMaxEnabled,
    this.strictMinEnabled,
  });

  GoogleCloudDataplexV1DataQualityRuleRangeExpectation.fromJson(core.Map json_)
      : this(
          maxValue: json_['maxValue'] as core.String?,
          minValue: json_['minValue'] as core.String?,
          strictMaxEnabled: json_['strictMaxEnabled'] as core.bool?,
          strictMinEnabled: json_['strictMinEnabled'] as core.bool?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (maxValue != null) 'maxValue': maxValue!,
        if (minValue != null) 'minValue': minValue!,
        if (strictMaxEnabled != null) 'strictMaxEnabled': strictMaxEnabled!,
        if (strictMinEnabled != null) 'strictMinEnabled': strictMinEnabled!,
      };
}

/// Evaluates whether each column value matches a specified regex.
class GoogleCloudDataplexV1DataQualityRuleRegexExpectation {
  /// A regular expression the column value is expected to match.
  ///
  /// Optional.
  core.String? regex;

  GoogleCloudDataplexV1DataQualityRuleRegexExpectation({
    this.regex,
  });

  GoogleCloudDataplexV1DataQualityRuleRegexExpectation.fromJson(core.Map json_)
      : this(
          regex: json_['regex'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (regex != null) 'regex': regex!,
      };
}

/// DataQualityRuleResult provides a more detailed, per-rule view of the
/// results.
class GoogleCloudDataplexV1DataQualityRuleResult {
  /// The number of rows returned by the SQL statement in a SQL assertion
  /// rule.This field is only valid for SQL assertion rules.
  ///
  /// Output only.
  core.String? assertionRowCount;

  /// The number of rows a rule was evaluated against.This field is only valid
  /// for row-level type rules.Evaluated count can be configured to either
  /// include all rows (default) - with null rows automatically failing rule
  /// evaluation, or exclude null rows from the evaluated_count, by setting
  /// ignore_nulls = true.This field is not set for rule SqlAssertion.
  core.String? evaluatedCount;

  /// The query to find rows that did not pass this rule.This field is only
  /// valid for row-level type rules.
  core.String? failingRowsQuery;

  /// The number of rows with null values in the specified column.
  core.String? nullCount;

  /// The ratio of passed_count / evaluated_count.This field is only valid for
  /// row-level type rules.
  core.double? passRatio;

  /// Whether the rule passed or failed.
  core.bool? passed;

  /// This field is not set for rule SqlAssertion.
  core.String? passedCount;

  /// The rule specified in the DataQualitySpec, as is.
  GoogleCloudDataplexV1DataQualityRule? rule;

  GoogleCloudDataplexV1DataQualityRuleResult({
    this.assertionRowCount,
    this.evaluatedCount,
    this.failingRowsQuery,
    this.nullCount,
    this.passRatio,
    this.passed,
    this.passedCount,
    this.rule,
  });

  GoogleCloudDataplexV1DataQualityRuleResult.fromJson(core.Map json_)
      : this(
          assertionRowCount: json_['assertionRowCount'] as core.String?,
          evaluatedCount: json_['evaluatedCount'] as core.String?,
          failingRowsQuery: json_['failingRowsQuery'] as core.String?,
          nullCount: json_['nullCount'] as core.String?,
          passRatio: (json_['passRatio'] as core.num?)?.toDouble(),
          passed: json_['passed'] as core.bool?,
          passedCount: json_['passedCount'] as core.String?,
          rule: json_.containsKey('rule')
              ? GoogleCloudDataplexV1DataQualityRule.fromJson(
                  json_['rule'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (assertionRowCount != null) 'assertionRowCount': assertionRowCount!,
        if (evaluatedCount != null) 'evaluatedCount': evaluatedCount!,
        if (failingRowsQuery != null) 'failingRowsQuery': failingRowsQuery!,
        if (nullCount != null) 'nullCount': nullCount!,
        if (passRatio != null) 'passRatio': passRatio!,
        if (passed != null) 'passed': passed!,
        if (passedCount != null) 'passedCount': passedCount!,
        if (rule != null) 'rule': rule!,
      };
}

/// Evaluates whether each row passes the specified condition.The SQL expression
/// needs to use GoogleSQL syntax
/// (https://cloud.google.com/bigquery/docs/reference/standard-sql/query-syntax)
/// and should produce a boolean value per row as the result.Example: col1 \>= 0
/// AND col2 \< 10
typedef GoogleCloudDataplexV1DataQualityRuleRowConditionExpectation
    = $ConditionExpectation;

/// Evaluates whether each column value is contained by a specified set.
class GoogleCloudDataplexV1DataQualityRuleSetExpectation {
  /// Expected values for the column value.
  ///
  /// Optional.
  core.List<core.String>? values;

  GoogleCloudDataplexV1DataQualityRuleSetExpectation({
    this.values,
  });

  GoogleCloudDataplexV1DataQualityRuleSetExpectation.fromJson(core.Map json_)
      : this(
          values: (json_['values'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (values != null) 'values': values!,
      };
}

/// A SQL statement that is evaluated to return rows that match an invalid
/// state.
///
/// If any rows are are returned, this rule fails.The SQL statement must use
/// GoogleSQL syntax
/// (https://cloud.google.com/bigquery/docs/reference/standard-sql/query-syntax),
/// and must not contain any semicolons.You can use the data reference parameter
/// ${data()} to reference the source table with all of its precondition filters
/// applied. Examples of precondition filters include row filters, incremental
/// data filters, and sampling. For more information, see Data reference
/// parameter
/// (https://cloud.google.com/dataplex/docs/auto-data-quality-overview#data-reference-parameter).Example:
/// SELECT * FROM ${data()} WHERE price \< 0
class GoogleCloudDataplexV1DataQualityRuleSqlAssertion {
  /// The SQL statement.
  ///
  /// Optional.
  core.String? sqlStatement;

  GoogleCloudDataplexV1DataQualityRuleSqlAssertion({
    this.sqlStatement,
  });

  GoogleCloudDataplexV1DataQualityRuleSqlAssertion.fromJson(core.Map json_)
      : this(
          sqlStatement: json_['sqlStatement'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (sqlStatement != null) 'sqlStatement': sqlStatement!,
      };
}

/// Evaluates whether the column aggregate statistic lies between a specified
/// range.
class GoogleCloudDataplexV1DataQualityRuleStatisticRangeExpectation {
  /// The maximum column statistic value allowed for a row to pass this
  /// validation.At least one of min_value and max_value need to be provided.
  ///
  /// Optional.
  core.String? maxValue;

  /// The minimum column statistic value allowed for a row to pass this
  /// validation.At least one of min_value and max_value need to be provided.
  ///
  /// Optional.
  core.String? minValue;

  /// The aggregate metric to evaluate.
  ///
  /// Optional.
  /// Possible string values are:
  /// - "STATISTIC_UNDEFINED" : Unspecified statistic type
  /// - "MEAN" : Evaluate the column mean
  /// - "MIN" : Evaluate the column min
  /// - "MAX" : Evaluate the column max
  core.String? statistic;

  /// Whether column statistic needs to be strictly lesser than ('\<') the
  /// maximum, or if equality is allowed.Only relevant if a max_value has been
  /// defined.
  ///
  /// Default = false.
  ///
  /// Optional.
  core.bool? strictMaxEnabled;

  /// Whether column statistic needs to be strictly greater than ('\>') the
  /// minimum, or if equality is allowed.Only relevant if a min_value has been
  /// defined.
  ///
  /// Default = false.
  ///
  /// Optional.
  core.bool? strictMinEnabled;

  GoogleCloudDataplexV1DataQualityRuleStatisticRangeExpectation({
    this.maxValue,
    this.minValue,
    this.statistic,
    this.strictMaxEnabled,
    this.strictMinEnabled,
  });

  GoogleCloudDataplexV1DataQualityRuleStatisticRangeExpectation.fromJson(
      core.Map json_)
      : this(
          maxValue: json_['maxValue'] as core.String?,
          minValue: json_['minValue'] as core.String?,
          statistic: json_['statistic'] as core.String?,
          strictMaxEnabled: json_['strictMaxEnabled'] as core.bool?,
          strictMinEnabled: json_['strictMinEnabled'] as core.bool?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (maxValue != null) 'maxValue': maxValue!,
        if (minValue != null) 'minValue': minValue!,
        if (statistic != null) 'statistic': statistic!,
        if (strictMaxEnabled != null) 'strictMaxEnabled': strictMaxEnabled!,
        if (strictMinEnabled != null) 'strictMinEnabled': strictMinEnabled!,
      };
}

/// Evaluates whether the provided expression is true.The SQL expression needs
/// to use GoogleSQL syntax
/// (https://cloud.google.com/bigquery/docs/reference/standard-sql/query-syntax)
/// and should produce a scalar boolean result.Example: MIN(col1) \>= 0
typedef GoogleCloudDataplexV1DataQualityRuleTableConditionExpectation
    = $ConditionExpectation;

/// Evaluates whether the column has duplicates.
typedef GoogleCloudDataplexV1DataQualityRuleUniquenessExpectation = $Empty;

/// DataQualityScan related setting.
class GoogleCloudDataplexV1DataQualitySpec {
  /// Actions to take upon job completion.
  ///
  /// Optional.
  GoogleCloudDataplexV1DataQualitySpecPostScanActions? postScanActions;

  /// A filter applied to all rows in a single DataScan job.
  ///
  /// The filter needs to be a valid SQL expression for a WHERE clause in
  /// GoogleSQL syntax
  /// (https://cloud.google.com/bigquery/docs/reference/standard-sql/query-syntax#where_clause).Example:
  /// col1 \>= 0 AND col2 \< 10
  ///
  /// Optional.
  core.String? rowFilter;

  /// The list of rules to evaluate against a data source.
  ///
  /// At least one rule is required.
  ///
  /// Required.
  core.List<GoogleCloudDataplexV1DataQualityRule>? rules;

  /// The percentage of the records to be selected from the dataset for
  /// DataScan.
  ///
  /// Value can range between 0.0 and 100.0 with up to 3 significant decimal
  /// digits. Sampling is not applied if sampling_percent is not specified, 0 or
  /// 100.
  ///
  /// Optional.
  core.double? samplingPercent;

  GoogleCloudDataplexV1DataQualitySpec({
    this.postScanActions,
    this.rowFilter,
    this.rules,
    this.samplingPercent,
  });

  GoogleCloudDataplexV1DataQualitySpec.fromJson(core.Map json_)
      : this(
          postScanActions: json_.containsKey('postScanActions')
              ? GoogleCloudDataplexV1DataQualitySpecPostScanActions.fromJson(
                  json_['postScanActions']
                      as core.Map<core.String, core.dynamic>)
              : null,
          rowFilter: json_['rowFilter'] as core.String?,
          rules: (json_['rules'] as core.List?)
              ?.map((value) => GoogleCloudDataplexV1DataQualityRule.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
          samplingPercent: (json_['samplingPercent'] as core.num?)?.toDouble(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (postScanActions != null) 'postScanActions': postScanActions!,
        if (rowFilter != null) 'rowFilter': rowFilter!,
        if (rules != null) 'rules': rules!,
        if (samplingPercent != null) 'samplingPercent': samplingPercent!,
      };
}

/// The configuration of post scan actions of DataQualityScan.
class GoogleCloudDataplexV1DataQualitySpecPostScanActions {
  /// If set, results will be exported to the provided BigQuery table.
  ///
  /// Optional.
  GoogleCloudDataplexV1DataQualitySpecPostScanActionsBigQueryExport?
      bigqueryExport;

  /// If set, results will be sent to the provided notification receipts upon
  /// triggers.
  ///
  /// Optional.
  GoogleCloudDataplexV1DataQualitySpecPostScanActionsNotificationReport?
      notificationReport;

  GoogleCloudDataplexV1DataQualitySpecPostScanActions({
    this.bigqueryExport,
    this.notificationReport,
  });

  GoogleCloudDataplexV1DataQualitySpecPostScanActions.fromJson(core.Map json_)
      : this(
          bigqueryExport: json_.containsKey('bigqueryExport')
              ? GoogleCloudDataplexV1DataQualitySpecPostScanActionsBigQueryExport
                  .fromJson(json_['bigqueryExport']
                      as core.Map<core.String, core.dynamic>)
              : null,
          notificationReport: json_.containsKey('notificationReport')
              ? GoogleCloudDataplexV1DataQualitySpecPostScanActionsNotificationReport
                  .fromJson(json_['notificationReport']
                      as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (bigqueryExport != null) 'bigqueryExport': bigqueryExport!,
        if (notificationReport != null)
          'notificationReport': notificationReport!,
      };
}

/// The configuration of BigQuery export post scan action.
class GoogleCloudDataplexV1DataQualitySpecPostScanActionsBigQueryExport {
  /// The BigQuery table to export DataQualityScan results to.
  ///
  /// Format:
  /// //bigquery.googleapis.com/projects/PROJECT_ID/datasets/DATASET_ID/tables/TABLE_ID
  ///
  /// Optional.
  core.String? resultsTable;

  GoogleCloudDataplexV1DataQualitySpecPostScanActionsBigQueryExport({
    this.resultsTable,
  });

  GoogleCloudDataplexV1DataQualitySpecPostScanActionsBigQueryExport.fromJson(
      core.Map json_)
      : this(
          resultsTable: json_['resultsTable'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (resultsTable != null) 'resultsTable': resultsTable!,
      };
}

/// This trigger is triggered whenever a scan job run ends, regardless of the
/// result.
typedef GoogleCloudDataplexV1DataQualitySpecPostScanActionsJobEndTrigger
    = $Empty;

/// This trigger is triggered when the scan job itself fails, regardless of the
/// result.
typedef GoogleCloudDataplexV1DataQualitySpecPostScanActionsJobFailureTrigger
    = $Empty;

/// The configuration of notification report post scan action.
class GoogleCloudDataplexV1DataQualitySpecPostScanActionsNotificationReport {
  /// If set, report will be sent when a scan job ends.
  ///
  /// Optional.
  GoogleCloudDataplexV1DataQualitySpecPostScanActionsJobEndTrigger?
      jobEndTrigger;

  /// If set, report will be sent when a scan job fails.
  ///
  /// Optional.
  GoogleCloudDataplexV1DataQualitySpecPostScanActionsJobFailureTrigger?
      jobFailureTrigger;

  /// The recipients who will receive the notification report.
  ///
  /// Required.
  GoogleCloudDataplexV1DataQualitySpecPostScanActionsRecipients? recipients;

  /// If set, report will be sent when score threshold is met.
  ///
  /// Optional.
  GoogleCloudDataplexV1DataQualitySpecPostScanActionsScoreThresholdTrigger?
      scoreThresholdTrigger;

  GoogleCloudDataplexV1DataQualitySpecPostScanActionsNotificationReport({
    this.jobEndTrigger,
    this.jobFailureTrigger,
    this.recipients,
    this.scoreThresholdTrigger,
  });

  GoogleCloudDataplexV1DataQualitySpecPostScanActionsNotificationReport.fromJson(
      core.Map json_)
      : this(
          jobEndTrigger: json_.containsKey('jobEndTrigger')
              ? GoogleCloudDataplexV1DataQualitySpecPostScanActionsJobEndTrigger
                  .fromJson(json_['jobEndTrigger']
                      as core.Map<core.String, core.dynamic>)
              : null,
          jobFailureTrigger: json_.containsKey('jobFailureTrigger')
              ? GoogleCloudDataplexV1DataQualitySpecPostScanActionsJobFailureTrigger
                  .fromJson(json_['jobFailureTrigger']
                      as core.Map<core.String, core.dynamic>)
              : null,
          recipients: json_.containsKey('recipients')
              ? GoogleCloudDataplexV1DataQualitySpecPostScanActionsRecipients
                  .fromJson(json_['recipients']
                      as core.Map<core.String, core.dynamic>)
              : null,
          scoreThresholdTrigger: json_.containsKey('scoreThresholdTrigger')
              ? GoogleCloudDataplexV1DataQualitySpecPostScanActionsScoreThresholdTrigger
                  .fromJson(json_['scoreThresholdTrigger']
                      as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (jobEndTrigger != null) 'jobEndTrigger': jobEndTrigger!,
        if (jobFailureTrigger != null) 'jobFailureTrigger': jobFailureTrigger!,
        if (recipients != null) 'recipients': recipients!,
        if (scoreThresholdTrigger != null)
          'scoreThresholdTrigger': scoreThresholdTrigger!,
      };
}

/// The individuals or groups who are designated to receive notifications upon
/// triggers.
class GoogleCloudDataplexV1DataQualitySpecPostScanActionsRecipients {
  /// The email recipients who will receive the DataQualityScan results report.
  ///
  /// Optional.
  core.List<core.String>? emails;

  GoogleCloudDataplexV1DataQualitySpecPostScanActionsRecipients({
    this.emails,
  });

  GoogleCloudDataplexV1DataQualitySpecPostScanActionsRecipients.fromJson(
      core.Map json_)
      : this(
          emails: (json_['emails'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (emails != null) 'emails': emails!,
      };
}

/// This trigger is triggered when the DQ score in the job result is less than a
/// specified input score.
class GoogleCloudDataplexV1DataQualitySpecPostScanActionsScoreThresholdTrigger {
  /// The score range is in 0,100.
  ///
  /// Optional.
  core.double? scoreThreshold;

  GoogleCloudDataplexV1DataQualitySpecPostScanActionsScoreThresholdTrigger({
    this.scoreThreshold,
  });

  GoogleCloudDataplexV1DataQualitySpecPostScanActionsScoreThresholdTrigger.fromJson(
      core.Map json_)
      : this(
          scoreThreshold: (json_['scoreThreshold'] as core.num?)?.toDouble(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (scoreThreshold != null) 'scoreThreshold': scoreThreshold!,
      };
}

/// Represents a user-visible job which provides the insights for the related
/// data source.For example: Data quality: generates queries based on the rules
/// and runs against the data to get data quality check results.
///
/// For more information, see Auto data quality overview
/// (https://cloud.google.com/dataplex/docs/auto-data-quality-overview). Data
/// profile: analyzes the data in tables and generates insights about the
/// structure, content and relationships (such as null percent, cardinality,
/// min/max/mean, etc). For more information, see About data profiling
/// (https://cloud.google.com/dataplex/docs/data-profiling-overview). Data
/// discovery: scans data in Cloud Storage buckets to extract and then catalog
/// metadata. For more information, see Discover and catalog Cloud Storage data
/// (https://cloud.google.com/bigquery/docs/automatic-discovery).
class GoogleCloudDataplexV1DataScan {
  /// The time when the scan was created.
  ///
  /// Output only.
  core.String? createTime;

  /// The data source for DataScan.
  ///
  /// Required.
  GoogleCloudDataplexV1DataSource? data;

  /// The result of a data discovery scan.
  ///
  /// Output only.
  GoogleCloudDataplexV1DataDiscoveryResult? dataDiscoveryResult;

  /// Settings for a data discovery scan.
  GoogleCloudDataplexV1DataDiscoverySpec? dataDiscoverySpec;

  /// The result of a data profile scan.
  ///
  /// Output only.
  GoogleCloudDataplexV1DataProfileResult? dataProfileResult;

  /// Settings for a data profile scan.
  GoogleCloudDataplexV1DataProfileSpec? dataProfileSpec;

  /// The result of a data quality scan.
  ///
  /// Output only.
  GoogleCloudDataplexV1DataQualityResult? dataQualityResult;

  /// Settings for a data quality scan.
  GoogleCloudDataplexV1DataQualitySpec? dataQualitySpec;

  /// Description of the scan.
  ///
  /// Must be between 1-1024 characters.
  ///
  /// Optional.
  core.String? description;

  /// User friendly display name.
  ///
  /// Must be between 1-256 characters.
  ///
  /// Optional.
  core.String? displayName;

  /// DataScan execution settings.If not specified, the fields in it will use
  /// their default values.
  ///
  /// Optional.
  GoogleCloudDataplexV1DataScanExecutionSpec? executionSpec;

  /// Status of the data scan execution.
  ///
  /// Output only.
  GoogleCloudDataplexV1DataScanExecutionStatus? executionStatus;

  /// User-defined labels for the scan.
  ///
  /// Optional.
  core.Map<core.String, core.String>? labels;

  /// Identifier.
  ///
  /// The relative resource name of the scan, of the form:
  /// projects/{project}/locations/{location_id}/dataScans/{datascan_id}, where
  /// project refers to a project_id or project_number and location_id refers to
  /// a GCP region.
  ///
  /// Output only.
  core.String? name;

  /// Current state of the DataScan.
  ///
  /// Output only.
  /// Possible string values are:
  /// - "STATE_UNSPECIFIED" : State is not specified.
  /// - "ACTIVE" : Resource is active, i.e., ready to use.
  /// - "CREATING" : Resource is under creation.
  /// - "DELETING" : Resource is under deletion.
  /// - "ACTION_REQUIRED" : Resource is active but has unresolved actions.
  core.String? state;

  /// The type of DataScan.
  ///
  /// Output only.
  /// Possible string values are:
  /// - "DATA_SCAN_TYPE_UNSPECIFIED" : The data scan type is unspecified.
  /// - "DATA_QUALITY" : Data quality scan.
  /// - "DATA_PROFILE" : Data profile scan.
  /// - "DATA_DISCOVERY" : Data discovery scan.
  core.String? type;

  /// System generated globally unique ID for the scan.
  ///
  /// This ID will be different if the scan is deleted and re-created with the
  /// same name.
  ///
  /// Output only.
  core.String? uid;

  /// The time when the scan was last updated.
  ///
  /// Output only.
  core.String? updateTime;

  GoogleCloudDataplexV1DataScan({
    this.createTime,
    this.data,
    this.dataDiscoveryResult,
    this.dataDiscoverySpec,
    this.dataProfileResult,
    this.dataProfileSpec,
    this.dataQualityResult,
    this.dataQualitySpec,
    this.description,
    this.displayName,
    this.executionSpec,
    this.executionStatus,
    this.labels,
    this.name,
    this.state,
    this.type,
    this.uid,
    this.updateTime,
  });

  GoogleCloudDataplexV1DataScan.fromJson(core.Map json_)
      : this(
          createTime: json_['createTime'] as core.String?,
          data: json_.containsKey('data')
              ? GoogleCloudDataplexV1DataSource.fromJson(
                  json_['data'] as core.Map<core.String, core.dynamic>)
              : null,
          dataDiscoveryResult: json_.containsKey('dataDiscoveryResult')
              ? GoogleCloudDataplexV1DataDiscoveryResult.fromJson(
                  json_['dataDiscoveryResult']
                      as core.Map<core.String, core.dynamic>)
              : null,
          dataDiscoverySpec: json_.containsKey('dataDiscoverySpec')
              ? GoogleCloudDataplexV1DataDiscoverySpec.fromJson(
                  json_['dataDiscoverySpec']
                      as core.Map<core.String, core.dynamic>)
              : null,
          dataProfileResult: json_.containsKey('dataProfileResult')
              ? GoogleCloudDataplexV1DataProfileResult.fromJson(
                  json_['dataProfileResult']
                      as core.Map<core.String, core.dynamic>)
              : null,
          dataProfileSpec: json_.containsKey('dataProfileSpec')
              ? GoogleCloudDataplexV1DataProfileSpec.fromJson(
                  json_['dataProfileSpec']
                      as core.Map<core.String, core.dynamic>)
              : null,
          dataQualityResult: json_.containsKey('dataQualityResult')
              ? GoogleCloudDataplexV1DataQualityResult.fromJson(
                  json_['dataQualityResult']
                      as core.Map<core.String, core.dynamic>)
              : null,
          dataQualitySpec: json_.containsKey('dataQualitySpec')
              ? GoogleCloudDataplexV1DataQualitySpec.fromJson(
                  json_['dataQualitySpec']
                      as core.Map<core.String, core.dynamic>)
              : null,
          description: json_['description'] as core.String?,
          displayName: json_['displayName'] as core.String?,
          executionSpec: json_.containsKey('executionSpec')
              ? GoogleCloudDataplexV1DataScanExecutionSpec.fromJson(
                  json_['executionSpec'] as core.Map<core.String, core.dynamic>)
              : null,
          executionStatus: json_.containsKey('executionStatus')
              ? GoogleCloudDataplexV1DataScanExecutionStatus.fromJson(
                  json_['executionStatus']
                      as core.Map<core.String, core.dynamic>)
              : null,
          labels:
              (json_['labels'] as core.Map<core.String, core.dynamic>?)?.map(
            (key, value) => core.MapEntry(
              key,
              value as core.String,
            ),
          ),
          name: json_['name'] as core.String?,
          state: json_['state'] as core.String?,
          type: json_['type'] as core.String?,
          uid: json_['uid'] as core.String?,
          updateTime: json_['updateTime'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (createTime != null) 'createTime': createTime!,
        if (data != null) 'data': data!,
        if (dataDiscoveryResult != null)
          'dataDiscoveryResult': dataDiscoveryResult!,
        if (dataDiscoverySpec != null) 'dataDiscoverySpec': dataDiscoverySpec!,
        if (dataProfileResult != null) 'dataProfileResult': dataProfileResult!,
        if (dataProfileSpec != null) 'dataProfileSpec': dataProfileSpec!,
        if (dataQualityResult != null) 'dataQualityResult': dataQualityResult!,
        if (dataQualitySpec != null) 'dataQualitySpec': dataQualitySpec!,
        if (description != null) 'description': description!,
        if (displayName != null) 'displayName': displayName!,
        if (executionSpec != null) 'executionSpec': executionSpec!,
        if (executionStatus != null) 'executionStatus': executionStatus!,
        if (labels != null) 'labels': labels!,
        if (name != null) 'name': name!,
        if (state != null) 'state': state!,
        if (type != null) 'type': type!,
        if (uid != null) 'uid': uid!,
        if (updateTime != null) 'updateTime': updateTime!,
      };
}

/// DataScan execution settings.
class GoogleCloudDataplexV1DataScanExecutionSpec {
  /// The unnested field (of type Date or Timestamp) that contains values which
  /// monotonically increase over time.If not specified, a data scan will run
  /// for all data in the table.
  ///
  /// Immutable.
  core.String? field;

  /// Spec related to how often and when a scan should be triggered.If not
  /// specified, the default is OnDemand, which means the scan will not run
  /// until the user calls RunDataScan API.
  ///
  /// Optional.
  GoogleCloudDataplexV1Trigger? trigger;

  GoogleCloudDataplexV1DataScanExecutionSpec({
    this.field,
    this.trigger,
  });

  GoogleCloudDataplexV1DataScanExecutionSpec.fromJson(core.Map json_)
      : this(
          field: json_['field'] as core.String?,
          trigger: json_.containsKey('trigger')
              ? GoogleCloudDataplexV1Trigger.fromJson(
                  json_['trigger'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (field != null) 'field': field!,
        if (trigger != null) 'trigger': trigger!,
      };
}

/// Status of the data scan execution.
class GoogleCloudDataplexV1DataScanExecutionStatus {
  /// The time when the DataScanJob execution was created.
  ///
  /// Optional.
  core.String? latestJobCreateTime;

  /// The time when the latest DataScanJob ended.
  ///
  /// Optional.
  core.String? latestJobEndTime;

  /// The time when the latest DataScanJob started.
  ///
  /// Optional.
  core.String? latestJobStartTime;

  GoogleCloudDataplexV1DataScanExecutionStatus({
    this.latestJobCreateTime,
    this.latestJobEndTime,
    this.latestJobStartTime,
  });

  GoogleCloudDataplexV1DataScanExecutionStatus.fromJson(core.Map json_)
      : this(
          latestJobCreateTime: json_['latestJobCreateTime'] as core.String?,
          latestJobEndTime: json_['latestJobEndTime'] as core.String?,
          latestJobStartTime: json_['latestJobStartTime'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (latestJobCreateTime != null)
          'latestJobCreateTime': latestJobCreateTime!,
        if (latestJobEndTime != null) 'latestJobEndTime': latestJobEndTime!,
        if (latestJobStartTime != null)
          'latestJobStartTime': latestJobStartTime!,
      };
}

/// A DataScanJob represents an instance of DataScan execution.
class GoogleCloudDataplexV1DataScanJob {
  /// The time when the DataScanJob was created.
  ///
  /// Output only.
  core.String? createTime;

  /// The result of a data discovery scan.
  ///
  /// Output only.
  GoogleCloudDataplexV1DataDiscoveryResult? dataDiscoveryResult;

  /// Settings for a data discovery scan.
  ///
  /// Output only.
  GoogleCloudDataplexV1DataDiscoverySpec? dataDiscoverySpec;

  /// The result of a data profile scan.
  ///
  /// Output only.
  GoogleCloudDataplexV1DataProfileResult? dataProfileResult;

  /// Settings for a data profile scan.
  ///
  /// Output only.
  GoogleCloudDataplexV1DataProfileSpec? dataProfileSpec;

  /// The result of a data quality scan.
  ///
  /// Output only.
  GoogleCloudDataplexV1DataQualityResult? dataQualityResult;

  /// Settings for a data quality scan.
  ///
  /// Output only.
  GoogleCloudDataplexV1DataQualitySpec? dataQualitySpec;

  /// The time when the DataScanJob ended.
  ///
  /// Output only.
  core.String? endTime;

  /// Additional information about the current state.
  ///
  /// Output only.
  core.String? message;

  /// Identifier.
  ///
  /// The relative resource name of the DataScanJob, of the form:
  /// projects/{project}/locations/{location_id}/dataScans/{datascan_id}/jobs/{job_id},
  /// where project refers to a project_id or project_number and location_id
  /// refers to a GCP region.
  ///
  /// Output only.
  core.String? name;

  /// The time when the DataScanJob was started.
  ///
  /// Output only.
  core.String? startTime;

  /// Execution state for the DataScanJob.
  ///
  /// Output only.
  /// Possible string values are:
  /// - "STATE_UNSPECIFIED" : The DataScanJob state is unspecified.
  /// - "RUNNING" : The DataScanJob is running.
  /// - "CANCELING" : The DataScanJob is canceling.
  /// - "CANCELLED" : The DataScanJob cancellation was successful.
  /// - "SUCCEEDED" : The DataScanJob completed successfully.
  /// - "FAILED" : The DataScanJob is no longer running due to an error.
  /// - "PENDING" : The DataScanJob has been created but not started to run yet.
  core.String? state;

  /// The type of the parent DataScan.
  ///
  /// Output only.
  /// Possible string values are:
  /// - "DATA_SCAN_TYPE_UNSPECIFIED" : The data scan type is unspecified.
  /// - "DATA_QUALITY" : Data quality scan.
  /// - "DATA_PROFILE" : Data profile scan.
  /// - "DATA_DISCOVERY" : Data discovery scan.
  core.String? type;

  /// System generated globally unique ID for the DataScanJob.
  ///
  /// Output only.
  core.String? uid;

  GoogleCloudDataplexV1DataScanJob({
    this.createTime,
    this.dataDiscoveryResult,
    this.dataDiscoverySpec,
    this.dataProfileResult,
    this.dataProfileSpec,
    this.dataQualityResult,
    this.dataQualitySpec,
    this.endTime,
    this.message,
    this.name,
    this.startTime,
    this.state,
    this.type,
    this.uid,
  });

  GoogleCloudDataplexV1DataScanJob.fromJson(core.Map json_)
      : this(
          createTime: json_['createTime'] as core.String?,
          dataDiscoveryResult: json_.containsKey('dataDiscoveryResult')
              ? GoogleCloudDataplexV1DataDiscoveryResult.fromJson(
                  json_['dataDiscoveryResult']
                      as core.Map<core.String, core.dynamic>)
              : null,
          dataDiscoverySpec: json_.containsKey('dataDiscoverySpec')
              ? GoogleCloudDataplexV1DataDiscoverySpec.fromJson(
                  json_['dataDiscoverySpec']
                      as core.Map<core.String, core.dynamic>)
              : null,
          dataProfileResult: json_.containsKey('dataProfileResult')
              ? GoogleCloudDataplexV1DataProfileResult.fromJson(
                  json_['dataProfileResult']
                      as core.Map<core.String, core.dynamic>)
              : null,
          dataProfileSpec: json_.containsKey('dataProfileSpec')
              ? GoogleCloudDataplexV1DataProfileSpec.fromJson(
                  json_['dataProfileSpec']
                      as core.Map<core.String, core.dynamic>)
              : null,
          dataQualityResult: json_.containsKey('dataQualityResult')
              ? GoogleCloudDataplexV1DataQualityResult.fromJson(
                  json_['dataQualityResult']
                      as core.Map<core.String, core.dynamic>)
              : null,
          dataQualitySpec: json_.containsKey('dataQualitySpec')
              ? GoogleCloudDataplexV1DataQualitySpec.fromJson(
                  json_['dataQualitySpec']
                      as core.Map<core.String, core.dynamic>)
              : null,
          endTime: json_['endTime'] as core.String?,
          message: json_['message'] as core.String?,
          name: json_['name'] as core.String?,
          startTime: json_['startTime'] as core.String?,
          state: json_['state'] as core.String?,
          type: json_['type'] as core.String?,
          uid: json_['uid'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (createTime != null) 'createTime': createTime!,
        if (dataDiscoveryResult != null)
          'dataDiscoveryResult': dataDiscoveryResult!,
        if (dataDiscoverySpec != null) 'dataDiscoverySpec': dataDiscoverySpec!,
        if (dataProfileResult != null) 'dataProfileResult': dataProfileResult!,
        if (dataProfileSpec != null) 'dataProfileSpec': dataProfileSpec!,
        if (dataQualityResult != null) 'dataQualityResult': dataQualityResult!,
        if (dataQualitySpec != null) 'dataQualitySpec': dataQualitySpec!,
        if (endTime != null) 'endTime': endTime!,
        if (message != null) 'message': message!,
        if (name != null) 'name': name!,
        if (startTime != null) 'startTime': startTime!,
        if (state != null) 'state': state!,
        if (type != null) 'type': type!,
        if (uid != null) 'uid': uid!,
      };
}

/// The data source for DataScan.
class GoogleCloudDataplexV1DataSource {
  /// The Dataplex entity that represents the data source (e.g. BigQuery table)
  /// for DataScan, of the form:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{entity_id}.
  ///
  /// Immutable.
  core.String? entity;

  /// The service-qualified full resource name of the cloud resource for a
  /// DataScan job to scan against.
  ///
  /// The field could be: BigQuery table of type "TABLE" for
  /// DataProfileScan/DataQualityScan Format:
  /// //bigquery.googleapis.com/projects/PROJECT_ID/datasets/DATASET_ID/tables/TABLE_ID
  ///
  /// Immutable.
  core.String? resource;

  GoogleCloudDataplexV1DataSource({
    this.entity,
    this.resource,
  });

  GoogleCloudDataplexV1DataSource.fromJson(core.Map json_)
      : this(
          entity: json_['entity'] as core.String?,
          resource: json_['resource'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (entity != null) 'entity': entity!,
        if (resource != null) 'resource': resource!,
      };
}

/// DataTaxonomy represents a set of hierarchical DataAttributes resources,
/// grouped with a common theme Eg: 'SensitiveDataTaxonomy' can have attributes
/// to manage PII data.
///
/// It is defined at project level.
class GoogleCloudDataplexV1DataTaxonomy {
  /// The number of attributes in the DataTaxonomy.
  ///
  /// Output only.
  core.int? attributeCount;

  /// The number of classes in the DataTaxonomy.
  ///
  /// Output only.
  core.int? classCount;

  /// The time when the DataTaxonomy was created.
  ///
  /// Output only.
  core.String? createTime;

  /// Description of the DataTaxonomy.
  ///
  /// Optional.
  core.String? description;

  /// User friendly display name.
  ///
  /// Optional.
  core.String? displayName;

  /// This checksum is computed by the server based on the value of other
  /// fields, and may be sent on update and delete requests to ensure the client
  /// has an up-to-date value before proceeding.
  core.String? etag;

  /// User-defined labels for the DataTaxonomy.
  ///
  /// Optional.
  core.Map<core.String, core.String>? labels;

  /// The relative resource name of the DataTaxonomy, of the form:
  /// projects/{project_number}/locations/{location_id}/dataTaxonomies/{data_taxonomy_id}.
  ///
  /// Output only.
  core.String? name;

  /// System generated globally unique ID for the dataTaxonomy.
  ///
  /// This ID will be different if the DataTaxonomy is deleted and re-created
  /// with the same name.
  ///
  /// Output only.
  core.String? uid;

  /// The time when the DataTaxonomy was last updated.
  ///
  /// Output only.
  core.String? updateTime;

  GoogleCloudDataplexV1DataTaxonomy({
    this.attributeCount,
    this.classCount,
    this.createTime,
    this.description,
    this.displayName,
    this.etag,
    this.labels,
    this.name,
    this.uid,
    this.updateTime,
  });

  GoogleCloudDataplexV1DataTaxonomy.fromJson(core.Map json_)
      : this(
          attributeCount: json_['attributeCount'] as core.int?,
          classCount: json_['classCount'] as core.int?,
          createTime: json_['createTime'] as core.String?,
          description: json_['description'] as core.String?,
          displayName: json_['displayName'] as core.String?,
          etag: json_['etag'] as core.String?,
          labels:
              (json_['labels'] as core.Map<core.String, core.dynamic>?)?.map(
            (key, value) => core.MapEntry(
              key,
              value as core.String,
            ),
          ),
          name: json_['name'] as core.String?,
          uid: json_['uid'] as core.String?,
          updateTime: json_['updateTime'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (attributeCount != null) 'attributeCount': attributeCount!,
        if (classCount != null) 'classCount': classCount!,
        if (createTime != null) 'createTime': createTime!,
        if (description != null) 'description': description!,
        if (displayName != null) 'displayName': displayName!,
        if (etag != null) 'etag': etag!,
        if (labels != null) 'labels': labels!,
        if (name != null) 'name': name!,
        if (uid != null) 'uid': uid!,
        if (updateTime != null) 'updateTime': updateTime!,
      };
}

/// Represents tables and fileset metadata contained within a zone.
class GoogleCloudDataplexV1Entity {
  /// Identifies the access mechanism to the entity.
  ///
  /// Not user settable.
  ///
  /// Output only.
  GoogleCloudDataplexV1StorageAccess? access;

  /// The ID of the asset associated with the storage location containing the
  /// entity data.
  ///
  /// The entity must be with in the same zone with the asset.
  ///
  /// Required. Immutable.
  core.String? asset;

  /// The name of the associated Data Catalog entry.
  ///
  /// Output only.
  core.String? catalogEntry;

  /// Metadata stores that the entity is compatible with.
  ///
  /// Output only.
  GoogleCloudDataplexV1EntityCompatibilityStatus? compatibility;

  /// The time when the entity was created.
  ///
  /// Output only.
  core.String? createTime;

  /// The storage path of the entity data.
  ///
  /// For Cloud Storage data, this is the fully-qualified path to the entity,
  /// such as gs://bucket/path/to/data. For BigQuery data, this is the name of
  /// the table resource, such as
  /// projects/project_id/datasets/dataset_id/tables/table_id.
  ///
  /// Required. Immutable.
  core.String? dataPath;

  /// The set of items within the data path constituting the data in the entity,
  /// represented as a glob path.
  ///
  /// Example: gs://bucket/path/to/data / * * / * .csv.
  ///
  /// Optional.
  core.String? dataPathPattern;

  /// User friendly longer description text.
  ///
  /// Must be shorter than or equal to 1024 characters.
  ///
  /// Optional.
  core.String? description;

  /// Display name must be shorter than or equal to 256 characters.
  ///
  /// Optional.
  core.String? displayName;

  /// The etag associated with the entity, which can be retrieved with a
  /// GetEntity request.
  ///
  /// Required for update and delete requests.
  ///
  /// Optional.
  core.String? etag;

  /// Identifies the storage format of the entity data.
  ///
  /// It does not apply to entities with data stored in BigQuery.
  ///
  /// Required.
  GoogleCloudDataplexV1StorageFormat? format;

  /// A user-provided entity ID.
  ///
  /// It is mutable, and will be used as the published table name. Specifying a
  /// new ID in an update entity request will override the existing value. The
  /// ID must contain only letters (a-z, A-Z), numbers (0-9), and underscores,
  /// and consist of 256 or fewer characters.
  ///
  /// Required.
  core.String? id;

  /// The resource name of the entity, of the form:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{id}.
  ///
  /// Output only.
  core.String? name;

  /// The description of the data structure and layout.
  ///
  /// The schema is not included in list responses. It is only included in
  /// SCHEMA and FULL entity views of a GetEntity response.
  ///
  /// Required.
  GoogleCloudDataplexV1Schema? schema;

  /// Identifies the storage system of the entity data.
  ///
  /// Required. Immutable.
  /// Possible string values are:
  /// - "STORAGE_SYSTEM_UNSPECIFIED" : Storage system unspecified.
  /// - "CLOUD_STORAGE" : The entity data is contained within a Cloud Storage
  /// bucket.
  /// - "BIGQUERY" : The entity data is contained within a BigQuery dataset.
  core.String? system;

  /// The type of entity.
  ///
  /// Required. Immutable.
  /// Possible string values are:
  /// - "TYPE_UNSPECIFIED" : Type unspecified.
  /// - "TABLE" : Structured and semi-structured data.
  /// - "FILESET" : Unstructured data.
  core.String? type;

  /// System generated unique ID for the Entity.
  ///
  /// This ID will be different if the Entity is deleted and re-created with the
  /// same name.
  ///
  /// Output only.
  core.String? uid;

  /// The time when the entity was last updated.
  ///
  /// Output only.
  core.String? updateTime;

  GoogleCloudDataplexV1Entity({
    this.access,
    this.asset,
    this.catalogEntry,
    this.compatibility,
    this.createTime,
    this.dataPath,
    this.dataPathPattern,
    this.description,
    this.displayName,
    this.etag,
    this.format,
    this.id,
    this.name,
    this.schema,
    this.system,
    this.type,
    this.uid,
    this.updateTime,
  });

  GoogleCloudDataplexV1Entity.fromJson(core.Map json_)
      : this(
          access: json_.containsKey('access')
              ? GoogleCloudDataplexV1StorageAccess.fromJson(
                  json_['access'] as core.Map<core.String, core.dynamic>)
              : null,
          asset: json_['asset'] as core.String?,
          catalogEntry: json_['catalogEntry'] as core.String?,
          compatibility: json_.containsKey('compatibility')
              ? GoogleCloudDataplexV1EntityCompatibilityStatus.fromJson(
                  json_['compatibility'] as core.Map<core.String, core.dynamic>)
              : null,
          createTime: json_['createTime'] as core.String?,
          dataPath: json_['dataPath'] as core.String?,
          dataPathPattern: json_['dataPathPattern'] as core.String?,
          description: json_['description'] as core.String?,
          displayName: json_['displayName'] as core.String?,
          etag: json_['etag'] as core.String?,
          format: json_.containsKey('format')
              ? GoogleCloudDataplexV1StorageFormat.fromJson(
                  json_['format'] as core.Map<core.String, core.dynamic>)
              : null,
          id: json_['id'] as core.String?,
          name: json_['name'] as core.String?,
          schema: json_.containsKey('schema')
              ? GoogleCloudDataplexV1Schema.fromJson(
                  json_['schema'] as core.Map<core.String, core.dynamic>)
              : null,
          system: json_['system'] as core.String?,
          type: json_['type'] as core.String?,
          uid: json_['uid'] as core.String?,
          updateTime: json_['updateTime'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (access != null) 'access': access!,
        if (asset != null) 'asset': asset!,
        if (catalogEntry != null) 'catalogEntry': catalogEntry!,
        if (compatibility != null) 'compatibility': compatibility!,
        if (createTime != null) 'createTime': createTime!,
        if (dataPath != null) 'dataPath': dataPath!,
        if (dataPathPattern != null) 'dataPathPattern': dataPathPattern!,
        if (description != null) 'description': description!,
        if (displayName != null) 'displayName': displayName!,
        if (etag != null) 'etag': etag!,
        if (format != null) 'format': format!,
        if (id != null) 'id': id!,
        if (name != null) 'name': name!,
        if (schema != null) 'schema': schema!,
        if (system != null) 'system': system!,
        if (type != null) 'type': type!,
        if (uid != null) 'uid': uid!,
        if (updateTime != null) 'updateTime': updateTime!,
      };
}

/// Provides compatibility information for various metadata stores.
class GoogleCloudDataplexV1EntityCompatibilityStatus {
  /// Whether this entity is compatible with BigQuery.
  ///
  /// Output only.
  GoogleCloudDataplexV1EntityCompatibilityStatusCompatibility? bigquery;

  /// Whether this entity is compatible with Hive Metastore.
  ///
  /// Output only.
  GoogleCloudDataplexV1EntityCompatibilityStatusCompatibility? hiveMetastore;

  GoogleCloudDataplexV1EntityCompatibilityStatus({
    this.bigquery,
    this.hiveMetastore,
  });

  GoogleCloudDataplexV1EntityCompatibilityStatus.fromJson(core.Map json_)
      : this(
          bigquery: json_.containsKey('bigquery')
              ? GoogleCloudDataplexV1EntityCompatibilityStatusCompatibility
                  .fromJson(
                      json_['bigquery'] as core.Map<core.String, core.dynamic>)
              : null,
          hiveMetastore: json_.containsKey('hiveMetastore')
              ? GoogleCloudDataplexV1EntityCompatibilityStatusCompatibility
                  .fromJson(json_['hiveMetastore']
                      as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (bigquery != null) 'bigquery': bigquery!,
        if (hiveMetastore != null) 'hiveMetastore': hiveMetastore!,
      };
}

/// Provides compatibility information for a specific metadata store.
class GoogleCloudDataplexV1EntityCompatibilityStatusCompatibility {
  /// Whether the entity is compatible and can be represented in the metadata
  /// store.
  ///
  /// Output only.
  core.bool? compatible;

  /// Provides additional detail if the entity is incompatible with the metadata
  /// store.
  ///
  /// Output only.
  core.String? reason;

  GoogleCloudDataplexV1EntityCompatibilityStatusCompatibility({
    this.compatible,
    this.reason,
  });

  GoogleCloudDataplexV1EntityCompatibilityStatusCompatibility.fromJson(
      core.Map json_)
      : this(
          compatible: json_['compatible'] as core.bool?,
          reason: json_['reason'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (compatible != null) 'compatible': compatible!,
        if (reason != null) 'reason': reason!,
      };
}

/// An entry is a representation of a data resource that can be described by
/// various metadata.
class GoogleCloudDataplexV1Entry {
  /// The aspects that are attached to the entry.
  ///
  /// Depending on how the aspect is attached to the entry, the format of the
  /// aspect key can be one of the following: If the aspect is attached directly
  /// to the entry: {project_id_or_number}.{location_id}.{aspect_type_id} If the
  /// aspect is attached to an entry's path:
  /// {project_id_or_number}.{location_id}.{aspect_type_id}@{path}
  ///
  /// Optional.
  core.Map<core.String, GoogleCloudDataplexV1Aspect>? aspects;

  /// The time when the entry was created in Dataplex.
  ///
  /// Output only.
  core.String? createTime;

  /// Information related to the source system of the data resource that is
  /// represented by the entry.
  ///
  /// Optional.
  GoogleCloudDataplexV1EntrySource? entrySource;

  /// The relative resource name of the entry type that was used to create this
  /// entry, in the format
  /// projects/{project_id_or_number}/locations/{location_id}/entryTypes/{entry_type_id}.
  ///
  /// Required. Immutable.
  core.String? entryType;

  /// A name for the entry that can be referenced by an external system.
  ///
  /// For more information, see Fully qualified names
  /// (https://cloud.google.com/data-catalog/docs/fully-qualified-names). The
  /// maximum size of the field is 4000 characters.
  ///
  /// Optional.
  core.String? fullyQualifiedName;

  /// Identifier.
  ///
  /// The relative resource name of the entry, in the format
  /// projects/{project_id_or_number}/locations/{location_id}/entryGroups/{entry_group_id}/entries/{entry_id}.
  core.String? name;

  /// The resource name of the parent entry, in the format
  /// projects/{project_id_or_number}/locations/{location_id}/entryGroups/{entry_group_id}/entries/{entry_id}.
  ///
  /// Optional. Immutable.
  core.String? parentEntry;

  /// The time when the entry was last updated in Dataplex.
  ///
  /// Output only.
  core.String? updateTime;

  GoogleCloudDataplexV1Entry({
    this.aspects,
    this.createTime,
    this.entrySource,
    this.entryType,
    this.fullyQualifiedName,
    this.name,
    this.parentEntry,
    this.updateTime,
  });

  GoogleCloudDataplexV1Entry.fromJson(core.Map json_)
      : this(
          aspects:
              (json_['aspects'] as core.Map<core.String, core.dynamic>?)?.map(
            (key, value) => core.MapEntry(
              key,
              GoogleCloudDataplexV1Aspect.fromJson(
                  value as core.Map<core.String, core.dynamic>),
            ),
          ),
          createTime: json_['createTime'] as core.String?,
          entrySource: json_.containsKey('entrySource')
              ? GoogleCloudDataplexV1EntrySource.fromJson(
                  json_['entrySource'] as core.Map<core.String, core.dynamic>)
              : null,
          entryType: json_['entryType'] as core.String?,
          fullyQualifiedName: json_['fullyQualifiedName'] as core.String?,
          name: json_['name'] as core.String?,
          parentEntry: json_['parentEntry'] as core.String?,
          updateTime: json_['updateTime'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (aspects != null) 'aspects': aspects!,
        if (createTime != null) 'createTime': createTime!,
        if (entrySource != null) 'entrySource': entrySource!,
        if (entryType != null) 'entryType': entryType!,
        if (fullyQualifiedName != null)
          'fullyQualifiedName': fullyQualifiedName!,
        if (name != null) 'name': name!,
        if (parentEntry != null) 'parentEntry': parentEntry!,
        if (updateTime != null) 'updateTime': updateTime!,
      };
}

/// An Entry Group represents a logical grouping of one or more Entries.
class GoogleCloudDataplexV1EntryGroup {
  /// The time when the EntryGroup was created.
  ///
  /// Output only.
  core.String? createTime;

  /// Description of the EntryGroup.
  ///
  /// Optional.
  core.String? description;

  /// User friendly display name.
  ///
  /// Optional.
  core.String? displayName;

  /// This checksum is computed by the service, and might be sent on update and
  /// delete requests to ensure the client has an up-to-date value before
  /// proceeding.
  core.String? etag;

  /// User-defined labels for the EntryGroup.
  ///
  /// Optional.
  core.Map<core.String, core.String>? labels;

  /// The relative resource name of the EntryGroup, in the format
  /// projects/{project_id_or_number}/locations/{location_id}/entryGroups/{entry_group_id}.
  ///
  /// Output only.
  core.String? name;

  /// Denotes the transfer status of the Entry Group.
  ///
  /// It is unspecified for Entry Group created from Dataplex API.
  ///
  /// Output only.
  /// Possible string values are:
  /// - "TRANSFER_STATUS_UNSPECIFIED" : The default value. It is set for
  /// resources that were not subject for migration from Data Catalog service.
  /// - "TRANSFER_STATUS_MIGRATED" : Indicates that a resource was migrated from
  /// Data Catalog service but it hasn't been transferred yet. In particular the
  /// resource cannot be updated from Dataplex API.
  /// - "TRANSFER_STATUS_TRANSFERRED" : Indicates that a resource was
  /// transferred from Data Catalog service. The resource can only be updated
  /// from Dataplex API.
  core.String? transferStatus;

  /// System generated globally unique ID for the EntryGroup.
  ///
  /// If you delete and recreate the EntryGroup with the same name, this ID will
  /// be different.
  ///
  /// Output only.
  core.String? uid;

  /// The time when the EntryGroup was last updated.
  ///
  /// Output only.
  core.String? updateTime;

  GoogleCloudDataplexV1EntryGroup({
    this.createTime,
    this.description,
    this.displayName,
    this.etag,
    this.labels,
    this.name,
    this.transferStatus,
    this.uid,
    this.updateTime,
  });

  GoogleCloudDataplexV1EntryGroup.fromJson(core.Map json_)
      : this(
          createTime: json_['createTime'] as core.String?,
          description: json_['description'] as core.String?,
          displayName: json_['displayName'] as core.String?,
          etag: json_['etag'] as core.String?,
          labels:
              (json_['labels'] as core.Map<core.String, core.dynamic>?)?.map(
            (key, value) => core.MapEntry(
              key,
              value as core.String,
            ),
          ),
          name: json_['name'] as core.String?,
          transferStatus: json_['transferStatus'] as core.String?,
          uid: json_['uid'] as core.String?,
          updateTime: json_['updateTime'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (createTime != null) 'createTime': createTime!,
        if (description != null) 'description': description!,
        if (displayName != null) 'displayName': displayName!,
        if (etag != null) 'etag': etag!,
        if (labels != null) 'labels': labels!,
        if (name != null) 'name': name!,
        if (transferStatus != null) 'transferStatus': transferStatus!,
        if (uid != null) 'uid': uid!,
        if (updateTime != null) 'updateTime': updateTime!,
      };
}

/// Information related to the source system of the data resource that is
/// represented by the entry.
class GoogleCloudDataplexV1EntrySource {
  /// The entries representing the ancestors of the data resource in the source
  /// system.
  ///
  /// Immutable.
  core.List<GoogleCloudDataplexV1EntrySourceAncestor>? ancestors;

  /// The time when the resource was created in the source system.
  core.String? createTime;

  /// A description of the data resource.
  ///
  /// Maximum length is 2,000 characters.
  core.String? description;

  /// A user-friendly display name.
  ///
  /// Maximum length is 500 characters.
  core.String? displayName;

  /// User-defined labels.
  ///
  /// The maximum size of keys and values is 128 characters each.
  core.Map<core.String, core.String>? labels;

  /// Location of the resource in the source system.
  ///
  /// You can search the entry by this location. By default, this should match
  /// the location of the entry group containing this entry. A different value
  /// allows capturing the source location for data external to Google Cloud.
  ///
  /// Output only.
  core.String? location;

  /// The platform containing the source system.
  ///
  /// Maximum length is 64 characters.
  core.String? platform;

  /// The name of the resource in the source system.
  ///
  /// Maximum length is 4,000 characters.
  core.String? resource;

  /// The name of the source system.
  ///
  /// Maximum length is 64 characters.
  core.String? system;

  /// The time when the resource was last updated in the source system.
  ///
  /// If the entry exists in the system and its EntrySource has update_time
  /// populated, further updates to the EntrySource of the entry must provide
  /// incremental updates to its update_time.
  core.String? updateTime;

  GoogleCloudDataplexV1EntrySource({
    this.ancestors,
    this.createTime,
    this.description,
    this.displayName,
    this.labels,
    this.location,
    this.platform,
    this.resource,
    this.system,
    this.updateTime,
  });

  GoogleCloudDataplexV1EntrySource.fromJson(core.Map json_)
      : this(
          ancestors: (json_['ancestors'] as core.List?)
              ?.map((value) =>
                  GoogleCloudDataplexV1EntrySourceAncestor.fromJson(
                      value as core.Map<core.String, core.dynamic>))
              .toList(),
          createTime: json_['createTime'] as core.String?,
          description: json_['description'] as core.String?,
          displayName: json_['displayName'] as core.String?,
          labels:
              (json_['labels'] as core.Map<core.String, core.dynamic>?)?.map(
            (key, value) => core.MapEntry(
              key,
              value as core.String,
            ),
          ),
          location: json_['location'] as core.String?,
          platform: json_['platform'] as core.String?,
          resource: json_['resource'] as core.String?,
          system: json_['system'] as core.String?,
          updateTime: json_['updateTime'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (ancestors != null) 'ancestors': ancestors!,
        if (createTime != null) 'createTime': createTime!,
        if (description != null) 'description': description!,
        if (displayName != null) 'displayName': displayName!,
        if (labels != null) 'labels': labels!,
        if (location != null) 'location': location!,
        if (platform != null) 'platform': platform!,
        if (resource != null) 'resource': resource!,
        if (system != null) 'system': system!,
        if (updateTime != null) 'updateTime': updateTime!,
      };
}

/// Information about individual items in the hierarchy that is associated with
/// the data resource.
class GoogleCloudDataplexV1EntrySourceAncestor {
  /// The name of the ancestor resource.
  ///
  /// Optional.
  core.String? name;

  /// The type of the ancestor resource.
  ///
  /// Optional.
  core.String? type;

  GoogleCloudDataplexV1EntrySourceAncestor({
    this.name,
    this.type,
  });

  GoogleCloudDataplexV1EntrySourceAncestor.fromJson(core.Map json_)
      : this(
          name: json_['name'] as core.String?,
          type: json_['type'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (name != null) 'name': name!,
        if (type != null) 'type': type!,
      };
}

/// Entry Type is a template for creating Entries.
class GoogleCloudDataplexV1EntryType {
  /// Authorization defined for this type.
  ///
  /// Immutable.
  GoogleCloudDataplexV1EntryTypeAuthorization? authorization;

  /// The time when the EntryType was created.
  ///
  /// Output only.
  core.String? createTime;

  /// Description of the EntryType.
  ///
  /// Optional.
  core.String? description;

  /// User friendly display name.
  ///
  /// Optional.
  core.String? displayName;

  /// This checksum is computed by the service, and might be sent on update and
  /// delete requests to ensure the client has an up-to-date value before
  /// proceeding.
  ///
  /// Optional.
  core.String? etag;

  /// User-defined labels for the EntryType.
  ///
  /// Optional.
  core.Map<core.String, core.String>? labels;

  /// The relative resource name of the EntryType, of the form:
  /// projects/{project_number}/locations/{location_id}/entryTypes/{entry_type_id}.
  ///
  /// Output only.
  core.String? name;

  /// The platform that Entries of this type belongs to.
  ///
  /// Optional.
  core.String? platform;

  /// AspectInfo for the entry type.
  core.List<GoogleCloudDataplexV1EntryTypeAspectInfo>? requiredAspects;

  /// The system that Entries of this type belongs to.
  ///
  /// Examples include CloudSQL, MariaDB etc
  ///
  /// Optional.
  core.String? system;

  /// Indicates the classes this Entry Type belongs to, for example, TABLE,
  /// DATABASE, MODEL.
  ///
  /// Optional.
  core.List<core.String>? typeAliases;

  /// System generated globally unique ID for the EntryType.
  ///
  /// This ID will be different if the EntryType is deleted and re-created with
  /// the same name.
  ///
  /// Output only.
  core.String? uid;

  /// The time when the EntryType was last updated.
  ///
  /// Output only.
  core.String? updateTime;

  GoogleCloudDataplexV1EntryType({
    this.authorization,
    this.createTime,
    this.description,
    this.displayName,
    this.etag,
    this.labels,
    this.name,
    this.platform,
    this.requiredAspects,
    this.system,
    this.typeAliases,
    this.uid,
    this.updateTime,
  });

  GoogleCloudDataplexV1EntryType.fromJson(core.Map json_)
      : this(
          authorization: json_.containsKey('authorization')
              ? GoogleCloudDataplexV1EntryTypeAuthorization.fromJson(
                  json_['authorization'] as core.Map<core.String, core.dynamic>)
              : null,
          createTime: json_['createTime'] as core.String?,
          description: json_['description'] as core.String?,
          displayName: json_['displayName'] as core.String?,
          etag: json_['etag'] as core.String?,
          labels:
              (json_['labels'] as core.Map<core.String, core.dynamic>?)?.map(
            (key, value) => core.MapEntry(
              key,
              value as core.String,
            ),
          ),
          name: json_['name'] as core.String?,
          platform: json_['platform'] as core.String?,
          requiredAspects: (json_['requiredAspects'] as core.List?)
              ?.map((value) =>
                  GoogleCloudDataplexV1EntryTypeAspectInfo.fromJson(
                      value as core.Map<core.String, core.dynamic>))
              .toList(),
          system: json_['system'] as core.String?,
          typeAliases: (json_['typeAliases'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
          uid: json_['uid'] as core.String?,
          updateTime: json_['updateTime'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (authorization != null) 'authorization': authorization!,
        if (createTime != null) 'createTime': createTime!,
        if (description != null) 'description': description!,
        if (displayName != null) 'displayName': displayName!,
        if (etag != null) 'etag': etag!,
        if (labels != null) 'labels': labels!,
        if (name != null) 'name': name!,
        if (platform != null) 'platform': platform!,
        if (requiredAspects != null) 'requiredAspects': requiredAspects!,
        if (system != null) 'system': system!,
        if (typeAliases != null) 'typeAliases': typeAliases!,
        if (uid != null) 'uid': uid!,
        if (updateTime != null) 'updateTime': updateTime!,
      };
}

class GoogleCloudDataplexV1EntryTypeAspectInfo {
  /// Required aspect type for the entry type.
  core.String? type;

  GoogleCloudDataplexV1EntryTypeAspectInfo({
    this.type,
  });

  GoogleCloudDataplexV1EntryTypeAspectInfo.fromJson(core.Map json_)
      : this(
          type: json_['type'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (type != null) 'type': type!,
      };
}

/// Authorization for an Entry Type.
class GoogleCloudDataplexV1EntryTypeAuthorization {
  /// The IAM permission grantable on the Entry Group to allow access to
  /// instantiate Entries of Dataplex owned Entry Types, only settable for
  /// Dataplex owned Types.
  ///
  /// Immutable.
  core.String? alternateUsePermission;

  GoogleCloudDataplexV1EntryTypeAuthorization({
    this.alternateUsePermission,
  });

  GoogleCloudDataplexV1EntryTypeAuthorization.fromJson(core.Map json_)
      : this(
          alternateUsePermission:
              json_['alternateUsePermission'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (alternateUsePermission != null)
          'alternateUsePermission': alternateUsePermission!,
      };
}

/// Environment represents a user-visible compute infrastructure for analytics
/// within a lake.
class GoogleCloudDataplexV1Environment {
  /// Environment creation time.
  ///
  /// Output only.
  core.String? createTime;

  /// Description of the environment.
  ///
  /// Optional.
  core.String? description;

  /// User friendly display name.
  ///
  /// Optional.
  core.String? displayName;

  /// URI Endpoints to access sessions associated with the Environment.
  ///
  /// Output only.
  GoogleCloudDataplexV1EnvironmentEndpoints? endpoints;

  /// Infrastructure specification for the Environment.
  ///
  /// Required.
  GoogleCloudDataplexV1EnvironmentInfrastructureSpec? infrastructureSpec;

  /// User defined labels for the environment.
  ///
  /// Optional.
  core.Map<core.String, core.String>? labels;

  /// The relative resource name of the environment, of the form:
  /// projects/{project_id}/locations/{location_id}/lakes/{lake_id}/environment/{environment_id}
  ///
  /// Output only.
  core.String? name;

  /// Configuration for sessions created for this environment.
  ///
  /// Optional.
  GoogleCloudDataplexV1EnvironmentSessionSpec? sessionSpec;

  /// Status of sessions created for this environment.
  ///
  /// Output only.
  GoogleCloudDataplexV1EnvironmentSessionStatus? sessionStatus;

  /// Current state of the environment.
  ///
  /// Output only.
  /// Possible string values are:
  /// - "STATE_UNSPECIFIED" : State is not specified.
  /// - "ACTIVE" : Resource is active, i.e., ready to use.
  /// - "CREATING" : Resource is under creation.
  /// - "DELETING" : Resource is under deletion.
  /// - "ACTION_REQUIRED" : Resource is active but has unresolved actions.
  core.String? state;

  /// System generated globally unique ID for the environment.
  ///
  /// This ID will be different if the environment is deleted and re-created
  /// with the same name.
  ///
  /// Output only.
  core.String? uid;

  /// The time when the environment was last updated.
  ///
  /// Output only.
  core.String? updateTime;

  GoogleCloudDataplexV1Environment({
    this.createTime,
    this.description,
    this.displayName,
    this.endpoints,
    this.infrastructureSpec,
    this.labels,
    this.name,
    this.sessionSpec,
    this.sessionStatus,
    this.state,
    this.uid,
    this.updateTime,
  });

  GoogleCloudDataplexV1Environment.fromJson(core.Map json_)
      : this(
          createTime: json_['createTime'] as core.String?,
          description: json_['description'] as core.String?,
          displayName: json_['displayName'] as core.String?,
          endpoints: json_.containsKey('endpoints')
              ? GoogleCloudDataplexV1EnvironmentEndpoints.fromJson(
                  json_['endpoints'] as core.Map<core.String, core.dynamic>)
              : null,
          infrastructureSpec: json_.containsKey('infrastructureSpec')
              ? GoogleCloudDataplexV1EnvironmentInfrastructureSpec.fromJson(
                  json_['infrastructureSpec']
                      as core.Map<core.String, core.dynamic>)
              : null,
          labels:
              (json_['labels'] as core.Map<core.String, core.dynamic>?)?.map(
            (key, value) => core.MapEntry(
              key,
              value as core.String,
            ),
          ),
          name: json_['name'] as core.String?,
          sessionSpec: json_.containsKey('sessionSpec')
              ? GoogleCloudDataplexV1EnvironmentSessionSpec.fromJson(
                  json_['sessionSpec'] as core.Map<core.String, core.dynamic>)
              : null,
          sessionStatus: json_.containsKey('sessionStatus')
              ? GoogleCloudDataplexV1EnvironmentSessionStatus.fromJson(
                  json_['sessionStatus'] as core.Map<core.String, core.dynamic>)
              : null,
          state: json_['state'] as core.String?,
          uid: json_['uid'] as core.String?,
          updateTime: json_['updateTime'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (createTime != null) 'createTime': createTime!,
        if (description != null) 'description': description!,
        if (displayName != null) 'displayName': displayName!,
        if (endpoints != null) 'endpoints': endpoints!,
        if (infrastructureSpec != null)
          'infrastructureSpec': infrastructureSpec!,
        if (labels != null) 'labels': labels!,
        if (name != null) 'name': name!,
        if (sessionSpec != null) 'sessionSpec': sessionSpec!,
        if (sessionStatus != null) 'sessionStatus': sessionStatus!,
        if (state != null) 'state': state!,
        if (uid != null) 'uid': uid!,
        if (updateTime != null) 'updateTime': updateTime!,
      };
}

/// URI Endpoints to access sessions associated with the Environment.
class GoogleCloudDataplexV1EnvironmentEndpoints {
  /// URI to serve notebook APIs
  ///
  /// Output only.
  core.String? notebooks;

  /// URI to serve SQL APIs
  ///
  /// Output only.
  core.String? sql;

  GoogleCloudDataplexV1EnvironmentEndpoints({
    this.notebooks,
    this.sql,
  });

  GoogleCloudDataplexV1EnvironmentEndpoints.fromJson(core.Map json_)
      : this(
          notebooks: json_['notebooks'] as core.String?,
          sql: json_['sql'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (notebooks != null) 'notebooks': notebooks!,
        if (sql != null) 'sql': sql!,
      };
}

/// Configuration for the underlying infrastructure used to run workloads.
class GoogleCloudDataplexV1EnvironmentInfrastructureSpec {
  /// Compute resources needed for analyze interactive workloads.
  ///
  /// Optional.
  GoogleCloudDataplexV1EnvironmentInfrastructureSpecComputeResources? compute;

  /// Software Runtime Configuration for analyze interactive workloads.
  ///
  /// Required.
  GoogleCloudDataplexV1EnvironmentInfrastructureSpecOsImageRuntime? osImage;

  GoogleCloudDataplexV1EnvironmentInfrastructureSpec({
    this.compute,
    this.osImage,
  });

  GoogleCloudDataplexV1EnvironmentInfrastructureSpec.fromJson(core.Map json_)
      : this(
          compute: json_.containsKey('compute')
              ? GoogleCloudDataplexV1EnvironmentInfrastructureSpecComputeResources
                  .fromJson(
                      json_['compute'] as core.Map<core.String, core.dynamic>)
              : null,
          osImage: json_.containsKey('osImage')
              ? GoogleCloudDataplexV1EnvironmentInfrastructureSpecOsImageRuntime
                  .fromJson(
                      json_['osImage'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (compute != null) 'compute': compute!,
        if (osImage != null) 'osImage': osImage!,
      };
}

/// Compute resources associated with the analyze interactive workloads.
class GoogleCloudDataplexV1EnvironmentInfrastructureSpecComputeResources {
  /// Size in GB of the disk.
  ///
  /// Default is 100 GB.
  ///
  /// Optional.
  core.int? diskSizeGb;

  /// Max configurable nodes.
  ///
  /// If max_node_count \> node_count, then auto-scaling is enabled.
  ///
  /// Optional.
  core.int? maxNodeCount;

  /// Total number of nodes in the sessions created for this environment.
  ///
  /// Optional.
  core.int? nodeCount;

  GoogleCloudDataplexV1EnvironmentInfrastructureSpecComputeResources({
    this.diskSizeGb,
    this.maxNodeCount,
    this.nodeCount,
  });

  GoogleCloudDataplexV1EnvironmentInfrastructureSpecComputeResources.fromJson(
      core.Map json_)
      : this(
          diskSizeGb: json_['diskSizeGb'] as core.int?,
          maxNodeCount: json_['maxNodeCount'] as core.int?,
          nodeCount: json_['nodeCount'] as core.int?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (diskSizeGb != null) 'diskSizeGb': diskSizeGb!,
        if (maxNodeCount != null) 'maxNodeCount': maxNodeCount!,
        if (nodeCount != null) 'nodeCount': nodeCount!,
      };
}

/// Software Runtime Configuration to run Analyze.
class GoogleCloudDataplexV1EnvironmentInfrastructureSpecOsImageRuntime {
  /// Dataplex Image version.
  ///
  /// Required.
  core.String? imageVersion;

  /// List of Java jars to be included in the runtime environment.
  ///
  /// Valid input includes Cloud Storage URIs to Jar binaries. For example,
  /// gs://bucket-name/my/path/to/file.jar
  ///
  /// Optional.
  core.List<core.String>? javaLibraries;

  /// Spark properties to provide configuration for use in sessions created for
  /// this environment.
  ///
  /// The properties to set on daemon config files. Property keys are specified
  /// in prefix:property format. The prefix must be "spark".
  ///
  /// Optional.
  core.Map<core.String, core.String>? properties;

  /// A list of python packages to be installed.
  ///
  /// Valid formats include Cloud Storage URI to a PIP installable library. For
  /// example, gs://bucket-name/my/path/to/lib.tar.gz
  ///
  /// Optional.
  core.List<core.String>? pythonPackages;

  GoogleCloudDataplexV1EnvironmentInfrastructureSpecOsImageRuntime({
    this.imageVersion,
    this.javaLibraries,
    this.properties,
    this.pythonPackages,
  });

  GoogleCloudDataplexV1EnvironmentInfrastructureSpecOsImageRuntime.fromJson(
      core.Map json_)
      : this(
          imageVersion: json_['imageVersion'] as core.String?,
          javaLibraries: (json_['javaLibraries'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
          properties:
              (json_['properties'] as core.Map<core.String, core.dynamic>?)
                  ?.map(
            (key, value) => core.MapEntry(
              key,
              value as core.String,
            ),
          ),
          pythonPackages: (json_['pythonPackages'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (imageVersion != null) 'imageVersion': imageVersion!,
        if (javaLibraries != null) 'javaLibraries': javaLibraries!,
        if (properties != null) 'properties': properties!,
        if (pythonPackages != null) 'pythonPackages': pythonPackages!,
      };
}

/// Configuration for sessions created for this environment.
class GoogleCloudDataplexV1EnvironmentSessionSpec {
  /// If True, this causes sessions to be pre-created and available for faster
  /// startup to enable interactive exploration use-cases.
  ///
  /// This defaults to False to avoid additional billed charges. These can only
  /// be set to True for the environment with name set to "default", and with
  /// default configuration.
  ///
  /// Optional.
  core.bool? enableFastStartup;

  /// The idle time configuration of the session.
  ///
  /// The session will be auto-terminated at the end of this period.
  ///
  /// Optional.
  core.String? maxIdleDuration;

  GoogleCloudDataplexV1EnvironmentSessionSpec({
    this.enableFastStartup,
    this.maxIdleDuration,
  });

  GoogleCloudDataplexV1EnvironmentSessionSpec.fromJson(core.Map json_)
      : this(
          enableFastStartup: json_['enableFastStartup'] as core.bool?,
          maxIdleDuration: json_['maxIdleDuration'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (enableFastStartup != null) 'enableFastStartup': enableFastStartup!,
        if (maxIdleDuration != null) 'maxIdleDuration': maxIdleDuration!,
      };
}

/// Status of sessions created for this environment.
class GoogleCloudDataplexV1EnvironmentSessionStatus {
  /// Queries over sessions to mark whether the environment is currently active
  /// or not
  ///
  /// Output only.
  core.bool? active;

  GoogleCloudDataplexV1EnvironmentSessionStatus({
    this.active,
  });

  GoogleCloudDataplexV1EnvironmentSessionStatus.fromJson(core.Map json_)
      : this(
          active: json_['active'] as core.bool?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (active != null) 'active': active!,
      };
}

/// Request details for generating data quality rule recommendations.
typedef GoogleCloudDataplexV1GenerateDataQualityRulesRequest = $Empty;

/// Response details for data quality rule recommendations.
class GoogleCloudDataplexV1GenerateDataQualityRulesResponse {
  /// The data quality rules that Dataplex generates based on the results of a
  /// data profiling scan.
  core.List<GoogleCloudDataplexV1DataQualityRule>? rule;

  GoogleCloudDataplexV1GenerateDataQualityRulesResponse({
    this.rule,
  });

  GoogleCloudDataplexV1GenerateDataQualityRulesResponse.fromJson(core.Map json_)
      : this(
          rule: (json_['rule'] as core.List?)
              ?.map((value) => GoogleCloudDataplexV1DataQualityRule.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (rule != null) 'rule': rule!,
      };
}

/// A job represents an instance of a task.
class GoogleCloudDataplexV1Job {
  /// The time when the job ended.
  ///
  /// Output only.
  core.String? endTime;

  /// Spec related to how a task is executed.
  ///
  /// Output only.
  GoogleCloudDataplexV1TaskExecutionSpec? executionSpec;

  /// User-defined labels for the task.
  ///
  /// Output only.
  core.Map<core.String, core.String>? labels;

  /// Additional information about the current state.
  ///
  /// Output only.
  core.String? message;

  /// The relative resource name of the job, of the form:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/tasks/{task_id}/jobs/{job_id}.
  ///
  /// Output only.
  core.String? name;

  /// The number of times the job has been retried (excluding the initial
  /// attempt).
  ///
  /// Output only.
  core.int? retryCount;

  /// The underlying service running a job.
  ///
  /// Output only.
  /// Possible string values are:
  /// - "SERVICE_UNSPECIFIED" : Service used to run the job is unspecified.
  /// - "DATAPROC" : Dataproc service is used to run this job.
  core.String? service;

  /// The full resource name for the job run under a particular service.
  ///
  /// Output only.
  core.String? serviceJob;

  /// The time when the job was started.
  ///
  /// Output only.
  core.String? startTime;

  /// Execution state for the job.
  ///
  /// Output only.
  /// Possible string values are:
  /// - "STATE_UNSPECIFIED" : The job state is unknown.
  /// - "RUNNING" : The job is running.
  /// - "CANCELLING" : The job is cancelling.
  /// - "CANCELLED" : The job cancellation was successful.
  /// - "SUCCEEDED" : The job completed successfully.
  /// - "FAILED" : The job is no longer running due to an error.
  /// - "ABORTED" : The job was cancelled outside of Dataplex.
  core.String? state;

  /// Job execution trigger.
  ///
  /// Output only.
  /// Possible string values are:
  /// - "TRIGGER_UNSPECIFIED" : The trigger is unspecified.
  /// - "TASK_CONFIG" : The job was triggered by Dataplex based on trigger spec
  /// from task definition.
  /// - "RUN_REQUEST" : The job was triggered by the explicit call of Task API.
  core.String? trigger;

  /// System generated globally unique ID for the job.
  ///
  /// Output only.
  core.String? uid;

  GoogleCloudDataplexV1Job({
    this.endTime,
    this.executionSpec,
    this.labels,
    this.message,
    this.name,
    this.retryCount,
    this.service,
    this.serviceJob,
    this.startTime,
    this.state,
    this.trigger,
    this.uid,
  });

  GoogleCloudDataplexV1Job.fromJson(core.Map json_)
      : this(
          endTime: json_['endTime'] as core.String?,
          executionSpec: json_.containsKey('executionSpec')
              ? GoogleCloudDataplexV1TaskExecutionSpec.fromJson(
                  json_['executionSpec'] as core.Map<core.String, core.dynamic>)
              : null,
          labels:
              (json_['labels'] as core.Map<core.String, core.dynamic>?)?.map(
            (key, value) => core.MapEntry(
              key,
              value as core.String,
            ),
          ),
          message: json_['message'] as core.String?,
          name: json_['name'] as core.String?,
          retryCount: json_['retryCount'] as core.int?,
          service: json_['service'] as core.String?,
          serviceJob: json_['serviceJob'] as core.String?,
          startTime: json_['startTime'] as core.String?,
          state: json_['state'] as core.String?,
          trigger: json_['trigger'] as core.String?,
          uid: json_['uid'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (endTime != null) 'endTime': endTime!,
        if (executionSpec != null) 'executionSpec': executionSpec!,
        if (labels != null) 'labels': labels!,
        if (message != null) 'message': message!,
        if (name != null) 'name': name!,
        if (retryCount != null) 'retryCount': retryCount!,
        if (service != null) 'service': service!,
        if (serviceJob != null) 'serviceJob': serviceJob!,
        if (startTime != null) 'startTime': startTime!,
        if (state != null) 'state': state!,
        if (trigger != null) 'trigger': trigger!,
        if (uid != null) 'uid': uid!,
      };
}

/// A lake is a centralized repository for managing enterprise data across the
/// organization distributed across many cloud projects, and stored in a variety
/// of storage services such as Google Cloud Storage and BigQuery.
///
/// The resources attached to a lake are referred to as managed resources. Data
/// within these managed resources can be structured or unstructured. A lake
/// provides data admins with tools to organize, secure and manage their data at
/// scale, and provides data scientists and data engineers an integrated
/// experience to easily search, discover, analyze and transform data and
/// associated metadata.
class GoogleCloudDataplexV1Lake {
  /// Aggregated status of the underlying assets of the lake.
  ///
  /// Output only.
  GoogleCloudDataplexV1AssetStatus? assetStatus;

  /// The time when the lake was created.
  ///
  /// Output only.
  core.String? createTime;

  /// Description of the lake.
  ///
  /// Optional.
  core.String? description;

  /// User friendly display name.
  ///
  /// Optional.
  core.String? displayName;

  /// User-defined labels for the lake.
  ///
  /// Optional.
  core.Map<core.String, core.String>? labels;

  /// Settings to manage lake and Dataproc Metastore service instance
  /// association.
  ///
  /// Optional.
  GoogleCloudDataplexV1LakeMetastore? metastore;

  /// Metastore status of the lake.
  ///
  /// Output only.
  GoogleCloudDataplexV1LakeMetastoreStatus? metastoreStatus;

  /// The relative resource name of the lake, of the form:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}.
  ///
  /// Output only.
  core.String? name;

  /// Service account associated with this lake.
  ///
  /// This service account must be authorized to access or operate on resources
  /// managed by the lake.
  ///
  /// Output only.
  core.String? serviceAccount;

  /// Current state of the lake.
  ///
  /// Output only.
  /// Possible string values are:
  /// - "STATE_UNSPECIFIED" : State is not specified.
  /// - "ACTIVE" : Resource is active, i.e., ready to use.
  /// - "CREATING" : Resource is under creation.
  /// - "DELETING" : Resource is under deletion.
  /// - "ACTION_REQUIRED" : Resource is active but has unresolved actions.
  core.String? state;

  /// System generated globally unique ID for the lake.
  ///
  /// This ID will be different if the lake is deleted and re-created with the
  /// same name.
  ///
  /// Output only.
  core.String? uid;

  /// The time when the lake was last updated.
  ///
  /// Output only.
  core.String? updateTime;

  GoogleCloudDataplexV1Lake({
    this.assetStatus,
    this.createTime,
    this.description,
    this.displayName,
    this.labels,
    this.metastore,
    this.metastoreStatus,
    this.name,
    this.serviceAccount,
    this.state,
    this.uid,
    this.updateTime,
  });

  GoogleCloudDataplexV1Lake.fromJson(core.Map json_)
      : this(
          assetStatus: json_.containsKey('assetStatus')
              ? GoogleCloudDataplexV1AssetStatus.fromJson(
                  json_['assetStatus'] as core.Map<core.String, core.dynamic>)
              : null,
          createTime: json_['createTime'] as core.String?,
          description: json_['description'] as core.String?,
          displayName: json_['displayName'] as core.String?,
          labels:
              (json_['labels'] as core.Map<core.String, core.dynamic>?)?.map(
            (key, value) => core.MapEntry(
              key,
              value as core.String,
            ),
          ),
          metastore: json_.containsKey('metastore')
              ? GoogleCloudDataplexV1LakeMetastore.fromJson(
                  json_['metastore'] as core.Map<core.String, core.dynamic>)
              : null,
          metastoreStatus: json_.containsKey('metastoreStatus')
              ? GoogleCloudDataplexV1LakeMetastoreStatus.fromJson(
                  json_['metastoreStatus']
                      as core.Map<core.String, core.dynamic>)
              : null,
          name: json_['name'] as core.String?,
          serviceAccount: json_['serviceAccount'] as core.String?,
          state: json_['state'] as core.String?,
          uid: json_['uid'] as core.String?,
          updateTime: json_['updateTime'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (assetStatus != null) 'assetStatus': assetStatus!,
        if (createTime != null) 'createTime': createTime!,
        if (description != null) 'description': description!,
        if (displayName != null) 'displayName': displayName!,
        if (labels != null) 'labels': labels!,
        if (metastore != null) 'metastore': metastore!,
        if (metastoreStatus != null) 'metastoreStatus': metastoreStatus!,
        if (name != null) 'name': name!,
        if (serviceAccount != null) 'serviceAccount': serviceAccount!,
        if (state != null) 'state': state!,
        if (uid != null) 'uid': uid!,
        if (updateTime != null) 'updateTime': updateTime!,
      };
}

/// Settings to manage association of Dataproc Metastore with a lake.
class GoogleCloudDataplexV1LakeMetastore {
  /// A relative reference to the Dataproc Metastore
  /// (https://cloud.google.com/dataproc-metastore/docs) service associated with
  /// the lake:
  /// projects/{project_id}/locations/{location_id}/services/{service_id}
  ///
  /// Optional.
  core.String? service;

  GoogleCloudDataplexV1LakeMetastore({
    this.service,
  });

  GoogleCloudDataplexV1LakeMetastore.fromJson(core.Map json_)
      : this(
          service: json_['service'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (service != null) 'service': service!,
      };
}

/// Status of Lake and Dataproc Metastore service instance association.
class GoogleCloudDataplexV1LakeMetastoreStatus {
  /// The URI of the endpoint used to access the Metastore service.
  core.String? endpoint;

  /// Additional information about the current status.
  core.String? message;

  /// Current state of association.
  /// Possible string values are:
  /// - "STATE_UNSPECIFIED" : Unspecified.
  /// - "NONE" : A Metastore service instance is not associated with the lake.
  /// - "READY" : A Metastore service instance is attached to the lake.
  /// - "UPDATING" : Attach/detach is in progress.
  /// - "ERROR" : Attach/detach could not be done due to errors.
  core.String? state;

  /// Last update time of the metastore status of the lake.
  core.String? updateTime;

  GoogleCloudDataplexV1LakeMetastoreStatus({
    this.endpoint,
    this.message,
    this.state,
    this.updateTime,
  });

  GoogleCloudDataplexV1LakeMetastoreStatus.fromJson(core.Map json_)
      : this(
          endpoint: json_['endpoint'] as core.String?,
          message: json_['message'] as core.String?,
          state: json_['state'] as core.String?,
          updateTime: json_['updateTime'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (endpoint != null) 'endpoint': endpoint!,
        if (message != null) 'message': message!,
        if (state != null) 'state': state!,
        if (updateTime != null) 'updateTime': updateTime!,
      };
}

/// List actions response.
class GoogleCloudDataplexV1ListActionsResponse {
  /// Actions under the given parent lake/zone/asset.
  core.List<GoogleCloudDataplexV1Action>? actions;

  /// Token to retrieve the next page of results, or empty if there are no more
  /// results in the list.
  core.String? nextPageToken;

  GoogleCloudDataplexV1ListActionsResponse({
    this.actions,
    this.nextPageToken,
  });

  GoogleCloudDataplexV1ListActionsResponse.fromJson(core.Map json_)
      : this(
          actions: (json_['actions'] as core.List?)
              ?.map((value) => GoogleCloudDataplexV1Action.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
          nextPageToken: json_['nextPageToken'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (actions != null) 'actions': actions!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
      };
}

/// List AspectTypes response.
class GoogleCloudDataplexV1ListAspectTypesResponse {
  /// AspectTypes under the given parent location.
  core.List<GoogleCloudDataplexV1AspectType>? aspectTypes;

  /// Token to retrieve the next page of results, or empty if there are no more
  /// results in the list.
  core.String? nextPageToken;

  /// Locations that the service couldn't reach.
  core.List<core.String>? unreachableLocations;

  GoogleCloudDataplexV1ListAspectTypesResponse({
    this.aspectTypes,
    this.nextPageToken,
    this.unreachableLocations,
  });

  GoogleCloudDataplexV1ListAspectTypesResponse.fromJson(core.Map json_)
      : this(
          aspectTypes: (json_['aspectTypes'] as core.List?)
              ?.map((value) => GoogleCloudDataplexV1AspectType.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
          nextPageToken: json_['nextPageToken'] as core.String?,
          unreachableLocations: (json_['unreachableLocations'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (aspectTypes != null) 'aspectTypes': aspectTypes!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (unreachableLocations != null)
          'unreachableLocations': unreachableLocations!,
      };
}

/// List assets response.
class GoogleCloudDataplexV1ListAssetsResponse {
  /// Asset under the given parent zone.
  core.List<GoogleCloudDataplexV1Asset>? assets;

  /// Token to retrieve the next page of results, or empty if there are no more
  /// results in the list.
  core.String? nextPageToken;

  GoogleCloudDataplexV1ListAssetsResponse({
    this.assets,
    this.nextPageToken,
  });

  GoogleCloudDataplexV1ListAssetsResponse.fromJson(core.Map json_)
      : this(
          assets: (json_['assets'] as core.List?)
              ?.map((value) => GoogleCloudDataplexV1Asset.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
          nextPageToken: json_['nextPageToken'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (assets != null) 'assets': assets!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
      };
}

/// List content response.
class GoogleCloudDataplexV1ListContentResponse {
  /// Content under the given parent lake.
  core.List<GoogleCloudDataplexV1Content>? content;

  /// Token to retrieve the next page of results, or empty if there are no more
  /// results in the list.
  core.String? nextPageToken;

  GoogleCloudDataplexV1ListContentResponse({
    this.content,
    this.nextPageToken,
  });

  GoogleCloudDataplexV1ListContentResponse.fromJson(core.Map json_)
      : this(
          content: (json_['content'] as core.List?)
              ?.map((value) => GoogleCloudDataplexV1Content.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
          nextPageToken: json_['nextPageToken'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (content != null) 'content': content!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
      };
}

/// List DataAttributeBindings response.
class GoogleCloudDataplexV1ListDataAttributeBindingsResponse {
  /// DataAttributeBindings under the given parent Location.
  core.List<GoogleCloudDataplexV1DataAttributeBinding>? dataAttributeBindings;

  /// Token to retrieve the next page of results, or empty if there are no more
  /// results in the list.
  core.String? nextPageToken;

  /// Locations that could not be reached.
  core.List<core.String>? unreachableLocations;

  GoogleCloudDataplexV1ListDataAttributeBindingsResponse({
    this.dataAttributeBindings,
    this.nextPageToken,
    this.unreachableLocations,
  });

  GoogleCloudDataplexV1ListDataAttributeBindingsResponse.fromJson(
      core.Map json_)
      : this(
          dataAttributeBindings: (json_['dataAttributeBindings'] as core.List?)
              ?.map((value) =>
                  GoogleCloudDataplexV1DataAttributeBinding.fromJson(
                      value as core.Map<core.String, core.dynamic>))
              .toList(),
          nextPageToken: json_['nextPageToken'] as core.String?,
          unreachableLocations: (json_['unreachableLocations'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (dataAttributeBindings != null)
          'dataAttributeBindings': dataAttributeBindings!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (unreachableLocations != null)
          'unreachableLocations': unreachableLocations!,
      };
}

/// List DataAttributes response.
class GoogleCloudDataplexV1ListDataAttributesResponse {
  /// DataAttributes under the given parent DataTaxonomy.
  core.List<GoogleCloudDataplexV1DataAttribute>? dataAttributes;

  /// Token to retrieve the next page of results, or empty if there are no more
  /// results in the list.
  core.String? nextPageToken;

  /// Locations that could not be reached.
  core.List<core.String>? unreachableLocations;

  GoogleCloudDataplexV1ListDataAttributesResponse({
    this.dataAttributes,
    this.nextPageToken,
    this.unreachableLocations,
  });

  GoogleCloudDataplexV1ListDataAttributesResponse.fromJson(core.Map json_)
      : this(
          dataAttributes: (json_['dataAttributes'] as core.List?)
              ?.map((value) => GoogleCloudDataplexV1DataAttribute.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
          nextPageToken: json_['nextPageToken'] as core.String?,
          unreachableLocations: (json_['unreachableLocations'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (dataAttributes != null) 'dataAttributes': dataAttributes!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (unreachableLocations != null)
          'unreachableLocations': unreachableLocations!,
      };
}

/// List DataScanJobs response.
class GoogleCloudDataplexV1ListDataScanJobsResponse {
  /// DataScanJobs (BASIC view only) under a given dataScan.
  core.List<GoogleCloudDataplexV1DataScanJob>? dataScanJobs;

  /// Token to retrieve the next page of results, or empty if there are no more
  /// results in the list.
  core.String? nextPageToken;

  GoogleCloudDataplexV1ListDataScanJobsResponse({
    this.dataScanJobs,
    this.nextPageToken,
  });

  GoogleCloudDataplexV1ListDataScanJobsResponse.fromJson(core.Map json_)
      : this(
          dataScanJobs: (json_['dataScanJobs'] as core.List?)
              ?.map((value) => GoogleCloudDataplexV1DataScanJob.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
          nextPageToken: json_['nextPageToken'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (dataScanJobs != null) 'dataScanJobs': dataScanJobs!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
      };
}

/// List dataScans response.
class GoogleCloudDataplexV1ListDataScansResponse {
  /// DataScans (BASIC view only) under the given parent location.
  core.List<GoogleCloudDataplexV1DataScan>? dataScans;

  /// Token to retrieve the next page of results, or empty if there are no more
  /// results in the list.
  core.String? nextPageToken;

  /// Locations that could not be reached.
  core.List<core.String>? unreachable;

  GoogleCloudDataplexV1ListDataScansResponse({
    this.dataScans,
    this.nextPageToken,
    this.unreachable,
  });

  GoogleCloudDataplexV1ListDataScansResponse.fromJson(core.Map json_)
      : this(
          dataScans: (json_['dataScans'] as core.List?)
              ?.map((value) => GoogleCloudDataplexV1DataScan.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
          nextPageToken: json_['nextPageToken'] as core.String?,
          unreachable: (json_['unreachable'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (dataScans != null) 'dataScans': dataScans!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (unreachable != null) 'unreachable': unreachable!,
      };
}

/// List DataTaxonomies response.
class GoogleCloudDataplexV1ListDataTaxonomiesResponse {
  /// DataTaxonomies under the given parent location.
  core.List<GoogleCloudDataplexV1DataTaxonomy>? dataTaxonomies;

  /// Token to retrieve the next page of results, or empty if there are no more
  /// results in the list.
  core.String? nextPageToken;

  /// Locations that could not be reached.
  core.List<core.String>? unreachableLocations;

  GoogleCloudDataplexV1ListDataTaxonomiesResponse({
    this.dataTaxonomies,
    this.nextPageToken,
    this.unreachableLocations,
  });

  GoogleCloudDataplexV1ListDataTaxonomiesResponse.fromJson(core.Map json_)
      : this(
          dataTaxonomies: (json_['dataTaxonomies'] as core.List?)
              ?.map((value) => GoogleCloudDataplexV1DataTaxonomy.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
          nextPageToken: json_['nextPageToken'] as core.String?,
          unreachableLocations: (json_['unreachableLocations'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (dataTaxonomies != null) 'dataTaxonomies': dataTaxonomies!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (unreachableLocations != null)
          'unreachableLocations': unreachableLocations!,
      };
}

/// List metadata entities response.
class GoogleCloudDataplexV1ListEntitiesResponse {
  /// Entities in the specified parent zone.
  core.List<GoogleCloudDataplexV1Entity>? entities;

  /// Token to retrieve the next page of results, or empty if there are no
  /// remaining results in the list.
  core.String? nextPageToken;

  GoogleCloudDataplexV1ListEntitiesResponse({
    this.entities,
    this.nextPageToken,
  });

  GoogleCloudDataplexV1ListEntitiesResponse.fromJson(core.Map json_)
      : this(
          entities: (json_['entities'] as core.List?)
              ?.map((value) => GoogleCloudDataplexV1Entity.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
          nextPageToken: json_['nextPageToken'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (entities != null) 'entities': entities!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
      };
}

/// List Entries response.
class GoogleCloudDataplexV1ListEntriesResponse {
  /// The list of entries under the given parent location.
  core.List<GoogleCloudDataplexV1Entry>? entries;

  /// Token to retrieve the next page of results, or empty if there are no more
  /// results in the list.
  core.String? nextPageToken;

  GoogleCloudDataplexV1ListEntriesResponse({
    this.entries,
    this.nextPageToken,
  });

  GoogleCloudDataplexV1ListEntriesResponse.fromJson(core.Map json_)
      : this(
          entries: (json_['entries'] as core.List?)
              ?.map((value) => GoogleCloudDataplexV1Entry.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
          nextPageToken: json_['nextPageToken'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (entries != null) 'entries': entries!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
      };
}

/// List entry groups response.
class GoogleCloudDataplexV1ListEntryGroupsResponse {
  /// Entry groups under the given parent location.
  core.List<GoogleCloudDataplexV1EntryGroup>? entryGroups;

  /// Token to retrieve the next page of results, or empty if there are no more
  /// results in the list.
  core.String? nextPageToken;

  /// Locations that the service couldn't reach.
  core.List<core.String>? unreachableLocations;

  GoogleCloudDataplexV1ListEntryGroupsResponse({
    this.entryGroups,
    this.nextPageToken,
    this.unreachableLocations,
  });

  GoogleCloudDataplexV1ListEntryGroupsResponse.fromJson(core.Map json_)
      : this(
          entryGroups: (json_['entryGroups'] as core.List?)
              ?.map((value) => GoogleCloudDataplexV1EntryGroup.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
          nextPageToken: json_['nextPageToken'] as core.String?,
          unreachableLocations: (json_['unreachableLocations'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (entryGroups != null) 'entryGroups': entryGroups!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (unreachableLocations != null)
          'unreachableLocations': unreachableLocations!,
      };
}

/// List EntryTypes response.
class GoogleCloudDataplexV1ListEntryTypesResponse {
  /// EntryTypes under the given parent location.
  core.List<GoogleCloudDataplexV1EntryType>? entryTypes;

  /// Token to retrieve the next page of results, or empty if there are no more
  /// results in the list.
  core.String? nextPageToken;

  /// Locations that the service couldn't reach.
  core.List<core.String>? unreachableLocations;

  GoogleCloudDataplexV1ListEntryTypesResponse({
    this.entryTypes,
    this.nextPageToken,
    this.unreachableLocations,
  });

  GoogleCloudDataplexV1ListEntryTypesResponse.fromJson(core.Map json_)
      : this(
          entryTypes: (json_['entryTypes'] as core.List?)
              ?.map((value) => GoogleCloudDataplexV1EntryType.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
          nextPageToken: json_['nextPageToken'] as core.String?,
          unreachableLocations: (json_['unreachableLocations'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (entryTypes != null) 'entryTypes': entryTypes!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (unreachableLocations != null)
          'unreachableLocations': unreachableLocations!,
      };
}

/// List environments response.
class GoogleCloudDataplexV1ListEnvironmentsResponse {
  /// Environments under the given parent lake.
  core.List<GoogleCloudDataplexV1Environment>? environments;

  /// Token to retrieve the next page of results, or empty if there are no more
  /// results in the list.
  core.String? nextPageToken;

  GoogleCloudDataplexV1ListEnvironmentsResponse({
    this.environments,
    this.nextPageToken,
  });

  GoogleCloudDataplexV1ListEnvironmentsResponse.fromJson(core.Map json_)
      : this(
          environments: (json_['environments'] as core.List?)
              ?.map((value) => GoogleCloudDataplexV1Environment.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
          nextPageToken: json_['nextPageToken'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (environments != null) 'environments': environments!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
      };
}

/// List jobs response.
class GoogleCloudDataplexV1ListJobsResponse {
  /// Jobs under a given task.
  core.List<GoogleCloudDataplexV1Job>? jobs;

  /// Token to retrieve the next page of results, or empty if there are no more
  /// results in the list.
  core.String? nextPageToken;

  GoogleCloudDataplexV1ListJobsResponse({
    this.jobs,
    this.nextPageToken,
  });

  GoogleCloudDataplexV1ListJobsResponse.fromJson(core.Map json_)
      : this(
          jobs: (json_['jobs'] as core.List?)
              ?.map((value) => GoogleCloudDataplexV1Job.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
          nextPageToken: json_['nextPageToken'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (jobs != null) 'jobs': jobs!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
      };
}

/// List lakes response.
class GoogleCloudDataplexV1ListLakesResponse {
  /// Lakes under the given parent location.
  core.List<GoogleCloudDataplexV1Lake>? lakes;

  /// Token to retrieve the next page of results, or empty if there are no more
  /// results in the list.
  core.String? nextPageToken;

  /// Locations that could not be reached.
  core.List<core.String>? unreachableLocations;

  GoogleCloudDataplexV1ListLakesResponse({
    this.lakes,
    this.nextPageToken,
    this.unreachableLocations,
  });

  GoogleCloudDataplexV1ListLakesResponse.fromJson(core.Map json_)
      : this(
          lakes: (json_['lakes'] as core.List?)
              ?.map((value) => GoogleCloudDataplexV1Lake.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
          nextPageToken: json_['nextPageToken'] as core.String?,
          unreachableLocations: (json_['unreachableLocations'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (lakes != null) 'lakes': lakes!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (unreachableLocations != null)
          'unreachableLocations': unreachableLocations!,
      };
}

/// List metadata jobs response.
class GoogleCloudDataplexV1ListMetadataJobsResponse {
  /// Metadata jobs under the specified parent location.
  core.List<GoogleCloudDataplexV1MetadataJob>? metadataJobs;

  /// A token to retrieve the next page of results.
  ///
  /// If there are no more results in the list, the value is empty.
  core.String? nextPageToken;

  /// Locations that the service couldn't reach.
  core.List<core.String>? unreachableLocations;

  GoogleCloudDataplexV1ListMetadataJobsResponse({
    this.metadataJobs,
    this.nextPageToken,
    this.unreachableLocations,
  });

  GoogleCloudDataplexV1ListMetadataJobsResponse.fromJson(core.Map json_)
      : this(
          metadataJobs: (json_['metadataJobs'] as core.List?)
              ?.map((value) => GoogleCloudDataplexV1MetadataJob.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
          nextPageToken: json_['nextPageToken'] as core.String?,
          unreachableLocations: (json_['unreachableLocations'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (metadataJobs != null) 'metadataJobs': metadataJobs!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (unreachableLocations != null)
          'unreachableLocations': unreachableLocations!,
      };
}

/// List metadata partitions response.
class GoogleCloudDataplexV1ListPartitionsResponse {
  /// Token to retrieve the next page of results, or empty if there are no
  /// remaining results in the list.
  core.String? nextPageToken;

  /// Partitions under the specified parent entity.
  core.List<GoogleCloudDataplexV1Partition>? partitions;

  GoogleCloudDataplexV1ListPartitionsResponse({
    this.nextPageToken,
    this.partitions,
  });

  GoogleCloudDataplexV1ListPartitionsResponse.fromJson(core.Map json_)
      : this(
          nextPageToken: json_['nextPageToken'] as core.String?,
          partitions: (json_['partitions'] as core.List?)
              ?.map((value) => GoogleCloudDataplexV1Partition.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (partitions != null) 'partitions': partitions!,
      };
}

/// List sessions response.
class GoogleCloudDataplexV1ListSessionsResponse {
  /// Token to retrieve the next page of results, or empty if there are no more
  /// results in the list.
  core.String? nextPageToken;

  /// Sessions under a given environment.
  core.List<GoogleCloudDataplexV1Session>? sessions;

  GoogleCloudDataplexV1ListSessionsResponse({
    this.nextPageToken,
    this.sessions,
  });

  GoogleCloudDataplexV1ListSessionsResponse.fromJson(core.Map json_)
      : this(
          nextPageToken: json_['nextPageToken'] as core.String?,
          sessions: (json_['sessions'] as core.List?)
              ?.map((value) => GoogleCloudDataplexV1Session.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (sessions != null) 'sessions': sessions!,
      };
}

/// List tasks response.
class GoogleCloudDataplexV1ListTasksResponse {
  /// Token to retrieve the next page of results, or empty if there are no more
  /// results in the list.
  core.String? nextPageToken;

  /// Tasks under the given parent lake.
  core.List<GoogleCloudDataplexV1Task>? tasks;

  /// Locations that could not be reached.
  core.List<core.String>? unreachableLocations;

  GoogleCloudDataplexV1ListTasksResponse({
    this.nextPageToken,
    this.tasks,
    this.unreachableLocations,
  });

  GoogleCloudDataplexV1ListTasksResponse.fromJson(core.Map json_)
      : this(
          nextPageToken: json_['nextPageToken'] as core.String?,
          tasks: (json_['tasks'] as core.List?)
              ?.map((value) => GoogleCloudDataplexV1Task.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
          unreachableLocations: (json_['unreachableLocations'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (tasks != null) 'tasks': tasks!,
        if (unreachableLocations != null)
          'unreachableLocations': unreachableLocations!,
      };
}

/// List zones response.
class GoogleCloudDataplexV1ListZonesResponse {
  /// Token to retrieve the next page of results, or empty if there are no more
  /// results in the list.
  core.String? nextPageToken;

  /// Zones under the given parent lake.
  core.List<GoogleCloudDataplexV1Zone>? zones;

  GoogleCloudDataplexV1ListZonesResponse({
    this.nextPageToken,
    this.zones,
  });

  GoogleCloudDataplexV1ListZonesResponse.fromJson(core.Map json_)
      : this(
          nextPageToken: json_['nextPageToken'] as core.String?,
          zones: (json_['zones'] as core.List?)
              ?.map((value) => GoogleCloudDataplexV1Zone.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (zones != null) 'zones': zones!,
      };
}

/// A metadata job resource.
class GoogleCloudDataplexV1MetadataJob {
  /// The time when the metadata job was created.
  ///
  /// Output only.
  core.String? createTime;

  /// Import job result.
  ///
  /// Output only.
  GoogleCloudDataplexV1MetadataJobImportJobResult? importResult;

  /// Import job specification.
  GoogleCloudDataplexV1MetadataJobImportJobSpec? importSpec;

  /// User-defined labels.
  ///
  /// Optional.
  core.Map<core.String, core.String>? labels;

  /// Identifier.
  ///
  /// The name of the resource that the configuration is applied to, in the
  /// format
  /// projects/{project_number}/locations/{location_id}/metadataJobs/{metadata_job_id}.
  ///
  /// Output only.
  core.String? name;

  /// Metadata job status.
  ///
  /// Output only.
  GoogleCloudDataplexV1MetadataJobStatus? status;

  /// Metadata job type.
  ///
  /// Required.
  /// Possible string values are:
  /// - "TYPE_UNSPECIFIED" : Unspecified.
  /// - "IMPORT" : Import job.
  core.String? type;

  /// A system-generated, globally unique ID for the metadata job.
  ///
  /// If the metadata job is deleted and then re-created with the same name,
  /// this ID is different.
  ///
  /// Output only.
  core.String? uid;

  /// The time when the metadata job was updated.
  ///
  /// Output only.
  core.String? updateTime;

  GoogleCloudDataplexV1MetadataJob({
    this.createTime,
    this.importResult,
    this.importSpec,
    this.labels,
    this.name,
    this.status,
    this.type,
    this.uid,
    this.updateTime,
  });

  GoogleCloudDataplexV1MetadataJob.fromJson(core.Map json_)
      : this(
          createTime: json_['createTime'] as core.String?,
          importResult: json_.containsKey('importResult')
              ? GoogleCloudDataplexV1MetadataJobImportJobResult.fromJson(
                  json_['importResult'] as core.Map<core.String, core.dynamic>)
              : null,
          importSpec: json_.containsKey('importSpec')
              ? GoogleCloudDataplexV1MetadataJobImportJobSpec.fromJson(
                  json_['importSpec'] as core.Map<core.String, core.dynamic>)
              : null,
          labels:
              (json_['labels'] as core.Map<core.String, core.dynamic>?)?.map(
            (key, value) => core.MapEntry(
              key,
              value as core.String,
            ),
          ),
          name: json_['name'] as core.String?,
          status: json_.containsKey('status')
              ? GoogleCloudDataplexV1MetadataJobStatus.fromJson(
                  json_['status'] as core.Map<core.String, core.dynamic>)
              : null,
          type: json_['type'] as core.String?,
          uid: json_['uid'] as core.String?,
          updateTime: json_['updateTime'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (createTime != null) 'createTime': createTime!,
        if (importResult != null) 'importResult': importResult!,
        if (importSpec != null) 'importSpec': importSpec!,
        if (labels != null) 'labels': labels!,
        if (name != null) 'name': name!,
        if (status != null) 'status': status!,
        if (type != null) 'type': type!,
        if (uid != null) 'uid': uid!,
        if (updateTime != null) 'updateTime': updateTime!,
      };
}

/// Results from a metadata import job.
class GoogleCloudDataplexV1MetadataJobImportJobResult {
  /// The total number of entries that were created.
  ///
  /// Output only.
  core.String? createdEntries;

  /// The total number of entries that were deleted.
  ///
  /// Output only.
  core.String? deletedEntries;

  /// The total number of entries that were recreated.
  ///
  /// Output only.
  core.String? recreatedEntries;

  /// The total number of entries that were unchanged.
  ///
  /// Output only.
  core.String? unchangedEntries;

  /// The time when the status was updated.
  ///
  /// Output only.
  core.String? updateTime;

  /// The total number of entries that were updated.
  ///
  /// Output only.
  core.String? updatedEntries;

  GoogleCloudDataplexV1MetadataJobImportJobResult({
    this.createdEntries,
    this.deletedEntries,
    this.recreatedEntries,
    this.unchangedEntries,
    this.updateTime,
    this.updatedEntries,
  });

  GoogleCloudDataplexV1MetadataJobImportJobResult.fromJson(core.Map json_)
      : this(
          createdEntries: json_['createdEntries'] as core.String?,
          deletedEntries: json_['deletedEntries'] as core.String?,
          recreatedEntries: json_['recreatedEntries'] as core.String?,
          unchangedEntries: json_['unchangedEntries'] as core.String?,
          updateTime: json_['updateTime'] as core.String?,
          updatedEntries: json_['updatedEntries'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (createdEntries != null) 'createdEntries': createdEntries!,
        if (deletedEntries != null) 'deletedEntries': deletedEntries!,
        if (recreatedEntries != null) 'recreatedEntries': recreatedEntries!,
        if (unchangedEntries != null) 'unchangedEntries': unchangedEntries!,
        if (updateTime != null) 'updateTime': updateTime!,
        if (updatedEntries != null) 'updatedEntries': updatedEntries!,
      };
}

/// Job specification for a metadata import job.You can run the following kinds
/// of metadata import jobs: Full sync of entries with incremental import of
/// their aspects.
///
/// Supported for custom entries. Incremental import of aspects only. Supported
/// for aspects that belong to custom entries and system entries. For custom
/// entries, you can modify both optional aspects and required aspects. For
/// system entries, you can modify optional aspects.
class GoogleCloudDataplexV1MetadataJobImportJobSpec {
  /// The sync mode for aspects.
  ///
  /// Required.
  /// Possible string values are:
  /// - "SYNC_MODE_UNSPECIFIED" : Sync mode unspecified.
  /// - "FULL" : All resources in the job's scope are modified. If a resource
  /// exists in Dataplex but isn't included in the metadata import file, the
  /// resource is deleted when you run the metadata job. Use this mode to
  /// perform a full sync of the set of entries in the job scope.This sync mode
  /// is supported for entries.
  /// - "INCREMENTAL" : Only the resources that are explicitly included in the
  /// metadata import file are modified. Use this mode to modify a subset of
  /// resources while leaving unreferenced resources unchanged.This sync mode is
  /// supported for aspects.
  /// - "NONE" : If entry sync mode is NONE, then aspects are modified according
  /// to the aspect sync mode. Other metadata that belongs to entries in the
  /// job's scope isn't modified.This sync mode is supported for entries.
  core.String? aspectSyncMode;

  /// The sync mode for entries.
  ///
  /// Required.
  /// Possible string values are:
  /// - "SYNC_MODE_UNSPECIFIED" : Sync mode unspecified.
  /// - "FULL" : All resources in the job's scope are modified. If a resource
  /// exists in Dataplex but isn't included in the metadata import file, the
  /// resource is deleted when you run the metadata job. Use this mode to
  /// perform a full sync of the set of entries in the job scope.This sync mode
  /// is supported for entries.
  /// - "INCREMENTAL" : Only the resources that are explicitly included in the
  /// metadata import file are modified. Use this mode to modify a subset of
  /// resources while leaving unreferenced resources unchanged.This sync mode is
  /// supported for aspects.
  /// - "NONE" : If entry sync mode is NONE, then aspects are modified according
  /// to the aspect sync mode. Other metadata that belongs to entries in the
  /// job's scope isn't modified.This sync mode is supported for entries.
  core.String? entrySyncMode;

  /// The level of logs to write to Cloud Logging for this job.Debug-level logs
  /// provide highly-detailed information for troubleshooting, but their
  /// increased verbosity could incur additional costs
  /// (https://cloud.google.com/stackdriver/pricing) that might not be merited
  /// for all jobs.If unspecified, defaults to INFO.
  ///
  /// Optional.
  /// Possible string values are:
  /// - "LOG_LEVEL_UNSPECIFIED" : Log level unspecified.
  /// - "DEBUG" : Debug-level logging. Captures detailed logs for each import
  /// item. Use debug-level logging to troubleshoot issues with specific import
  /// items. For example, use debug-level logging to identify resources that are
  /// missing from the job scope, entries or aspects that don't conform to the
  /// associated entry type or aspect type, or other misconfigurations with the
  /// metadata import file.Depending on the size of your metadata job and the
  /// number of logs that are generated, debug-level logging might incur
  /// additional costs (https://cloud.google.com/stackdriver/pricing).
  /// - "INFO" : Info-level logging. Captures logs at the overall job level.
  /// Includes aggregate logs about import items, but doesn't specify which
  /// import item has an error.
  core.String? logLevel;

  /// A boundary on the scope of impact that the metadata import job can have.
  ///
  /// Required.
  GoogleCloudDataplexV1MetadataJobImportJobSpecImportJobScope? scope;

  /// The time when the process that created the metadata import files began.
  ///
  /// Optional.
  core.String? sourceCreateTime;

  /// The URI of a Cloud Storage bucket or folder (beginning with gs:// and
  /// ending with /) that contains the metadata import files for this job.A
  /// metadata import file defines the values to set for each of the entries and
  /// aspects in a metadata job.
  ///
  /// For more information about how to create a metadata import file and the
  /// file requirements, see Metadata import file
  /// (https://cloud.google.com/dataplex/docs/import-metadata#metadata-import-file).You
  /// can provide multiple metadata import files in the same metadata job. The
  /// bucket or folder must contain at least one metadata import file, in JSON
  /// Lines format (either .json or .jsonl file extension).In FULL entry sync
  /// mode, don't save the metadata import file in a folder named
  /// SOURCE_STORAGE_URI/deletions/.Caution: If the metadata import file
  /// contains no data, all entries and aspects that belong to the job's scope
  /// are deleted.
  ///
  /// Optional.
  core.String? sourceStorageUri;

  GoogleCloudDataplexV1MetadataJobImportJobSpec({
    this.aspectSyncMode,
    this.entrySyncMode,
    this.logLevel,
    this.scope,
    this.sourceCreateTime,
    this.sourceStorageUri,
  });

  GoogleCloudDataplexV1MetadataJobImportJobSpec.fromJson(core.Map json_)
      : this(
          aspectSyncMode: json_['aspectSyncMode'] as core.String?,
          entrySyncMode: json_['entrySyncMode'] as core.String?,
          logLevel: json_['logLevel'] as core.String?,
          scope: json_.containsKey('scope')
              ? GoogleCloudDataplexV1MetadataJobImportJobSpecImportJobScope
                  .fromJson(
                      json_['scope'] as core.Map<core.String, core.dynamic>)
              : null,
          sourceCreateTime: json_['sourceCreateTime'] as core.String?,
          sourceStorageUri: json_['sourceStorageUri'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (aspectSyncMode != null) 'aspectSyncMode': aspectSyncMode!,
        if (entrySyncMode != null) 'entrySyncMode': entrySyncMode!,
        if (logLevel != null) 'logLevel': logLevel!,
        if (scope != null) 'scope': scope!,
        if (sourceCreateTime != null) 'sourceCreateTime': sourceCreateTime!,
        if (sourceStorageUri != null) 'sourceStorageUri': sourceStorageUri!,
      };
}

/// A boundary on the scope of impact that the metadata import job can have.
class GoogleCloudDataplexV1MetadataJobImportJobSpecImportJobScope {
  /// The aspect types that are in scope for the import job, specified as
  /// relative resource names in the format
  /// projects/{project_number_or_id}/locations/{location_id}/aspectTypes/{aspect_type_id}.
  ///
  /// The job modifies only the aspects that belong to these aspect types.This
  /// field is required when creating an aspect-only import job.If the metadata
  /// import file attempts to modify an aspect whose type isn't included in this
  /// list, the import job is halted before modifying any entries or aspects.The
  /// location of an aspect type must either match the location of the job, or
  /// the aspect type must be global.
  ///
  /// Optional.
  core.List<core.String>? aspectTypes;

  /// The entry group that is in scope for the import job, specified as a
  /// relative resource name in the format
  /// projects/{project_number_or_id}/locations/{location_id}/entryGroups/{entry_group_id}.
  ///
  /// Only entries and aspects that belong to the specified entry group are
  /// affected by the job.Must contain exactly one element. The entry group and
  /// the job must be in the same location.
  ///
  /// Required.
  core.List<core.String>? entryGroups;

  /// The entry types that are in scope for the import job, specified as
  /// relative resource names in the format
  /// projects/{project_number_or_id}/locations/{location_id}/entryTypes/{entry_type_id}.
  ///
  /// The job modifies only the entries and aspects that belong to these entry
  /// types.If the metadata import file attempts to modify an entry whose type
  /// isn't included in this list, the import job is halted before modifying any
  /// entries or aspects.The location of an entry type must either match the
  /// location of the job, or the entry type must be global.
  ///
  /// Required.
  core.List<core.String>? entryTypes;

  GoogleCloudDataplexV1MetadataJobImportJobSpecImportJobScope({
    this.aspectTypes,
    this.entryGroups,
    this.entryTypes,
  });

  GoogleCloudDataplexV1MetadataJobImportJobSpecImportJobScope.fromJson(
      core.Map json_)
      : this(
          aspectTypes: (json_['aspectTypes'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
          entryGroups: (json_['entryGroups'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
          entryTypes: (json_['entryTypes'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (aspectTypes != null) 'aspectTypes': aspectTypes!,
        if (entryGroups != null) 'entryGroups': entryGroups!,
        if (entryTypes != null) 'entryTypes': entryTypes!,
      };
}

/// Metadata job status.
class GoogleCloudDataplexV1MetadataJobStatus {
  /// Progress tracking.
  ///
  /// Output only.
  core.int? completionPercent;

  /// Message relating to the progression of a metadata job.
  ///
  /// Output only.
  core.String? message;

  /// State of the metadata job.
  ///
  /// Output only.
  /// Possible string values are:
  /// - "STATE_UNSPECIFIED" : State unspecified.
  /// - "QUEUED" : The job is queued.
  /// - "RUNNING" : The job is running.
  /// - "CANCELING" : The job is being canceled.
  /// - "CANCELED" : The job is canceled.
  /// - "SUCCEEDED" : The job succeeded.
  /// - "FAILED" : The job failed.
  /// - "SUCCEEDED_WITH_ERRORS" : The job completed with some errors.
  core.String? state;

  /// The time when the status was updated.
  ///
  /// Output only.
  core.String? updateTime;

  GoogleCloudDataplexV1MetadataJobStatus({
    this.completionPercent,
    this.message,
    this.state,
    this.updateTime,
  });

  GoogleCloudDataplexV1MetadataJobStatus.fromJson(core.Map json_)
      : this(
          completionPercent: json_['completionPercent'] as core.int?,
          message: json_['message'] as core.String?,
          state: json_['state'] as core.String?,
          updateTime: json_['updateTime'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (completionPercent != null) 'completionPercent': completionPercent!,
        if (message != null) 'message': message!,
        if (state != null) 'state': state!,
        if (updateTime != null) 'updateTime': updateTime!,
      };
}

/// Represents partition metadata contained within entity instances.
class GoogleCloudDataplexV1Partition {
  /// The etag for this partition.
  ///
  /// Optional.
  @core.Deprecated(
    'Not supported. Member documentation may have more information.',
  )
  core.String? etag;

  /// The location of the entity data within the partition, for example,
  /// gs://bucket/path/to/entity/key1=value1/key2=value2.
  ///
  /// Or projects//datasets//tables/
  ///
  /// Required. Immutable.
  core.String? location;

  /// Partition values used in the HTTP URL must be double encoded.
  ///
  /// For example, url_encode(url_encode(value)) can be used to encode
  /// "US:CA/CA#Sunnyvale so that the request URL ends with
  /// "/partitions/US%253ACA/CA%2523Sunnyvale". The name field in the response
  /// retains the encoded format.
  ///
  /// Output only.
  core.String? name;

  /// The set of values representing the partition, which correspond to the
  /// partition schema defined in the parent entity.
  ///
  /// Required. Immutable.
  core.List<core.String>? values;

  GoogleCloudDataplexV1Partition({
    this.etag,
    this.location,
    this.name,
    this.values,
  });

  GoogleCloudDataplexV1Partition.fromJson(core.Map json_)
      : this(
          etag: json_['etag'] as core.String?,
          location: json_['location'] as core.String?,
          name: json_['name'] as core.String?,
          values: (json_['values'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (etag != null) 'etag': etag!,
        if (location != null) 'location': location!,
        if (name != null) 'name': name!,
        if (values != null) 'values': values!,
      };
}

/// ResourceAccessSpec holds the access control configuration to be enforced on
/// the resources, for example, Cloud Storage bucket, BigQuery dataset, BigQuery
/// table.
class GoogleCloudDataplexV1ResourceAccessSpec {
  /// The set of principals to be granted owner role on the resource.
  ///
  /// Optional.
  core.List<core.String>? owners;

  /// The format of strings follows the pattern followed by IAM in the bindings.
  ///
  /// user:{email}, serviceAccount:{email} group:{email}. The set of principals
  /// to be granted reader role on the resource.
  ///
  /// Optional.
  core.List<core.String>? readers;

  /// The set of principals to be granted writer role on the resource.
  ///
  /// Optional.
  core.List<core.String>? writers;

  GoogleCloudDataplexV1ResourceAccessSpec({
    this.owners,
    this.readers,
    this.writers,
  });

  GoogleCloudDataplexV1ResourceAccessSpec.fromJson(core.Map json_)
      : this(
          owners: (json_['owners'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
          readers: (json_['readers'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
          writers: (json_['writers'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (owners != null) 'owners': owners!,
        if (readers != null) 'readers': readers!,
        if (writers != null) 'writers': writers!,
      };
}

/// Run DataScan Request
typedef GoogleCloudDataplexV1RunDataScanRequest = $Empty;

/// Run DataScan Response.
class GoogleCloudDataplexV1RunDataScanResponse {
  /// DataScanJob created by RunDataScan request.
  GoogleCloudDataplexV1DataScanJob? job;

  GoogleCloudDataplexV1RunDataScanResponse({
    this.job,
  });

  GoogleCloudDataplexV1RunDataScanResponse.fromJson(core.Map json_)
      : this(
          job: json_.containsKey('job')
              ? GoogleCloudDataplexV1DataScanJob.fromJson(
                  json_['job'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (job != null) 'job': job!,
      };
}

class GoogleCloudDataplexV1RunTaskRequest {
  /// Execution spec arguments.
  ///
  /// If the map is left empty, the task will run with existing execution spec
  /// args from task definition. If the map contains an entry with a new key,
  /// the same will be added to existing set of args. If the map contains an
  /// entry with an existing arg key in task definition, the task will run with
  /// new arg value for that entry. Clearing an existing arg will require arg
  /// value to be explicitly set to a hyphen "-". The arg value cannot be empty.
  ///
  /// Optional.
  core.Map<core.String, core.String>? args;

  /// User-defined labels for the task.
  ///
  /// If the map is left empty, the task will run with existing labels from task
  /// definition. If the map contains an entry with a new key, the same will be
  /// added to existing set of labels. If the map contains an entry with an
  /// existing label key in task definition, the task will run with new label
  /// value for that entry. Clearing an existing label will require label value
  /// to be explicitly set to a hyphen "-". The label value cannot be empty.
  ///
  /// Optional.
  core.Map<core.String, core.String>? labels;

  GoogleCloudDataplexV1RunTaskRequest({
    this.args,
    this.labels,
  });

  GoogleCloudDataplexV1RunTaskRequest.fromJson(core.Map json_)
      : this(
          args: (json_['args'] as core.Map<core.String, core.dynamic>?)?.map(
            (key, value) => core.MapEntry(
              key,
              value as core.String,
            ),
          ),
          labels:
              (json_['labels'] as core.Map<core.String, core.dynamic>?)?.map(
            (key, value) => core.MapEntry(
              key,
              value as core.String,
            ),
          ),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (args != null) 'args': args!,
        if (labels != null) 'labels': labels!,
      };
}

class GoogleCloudDataplexV1RunTaskResponse {
  /// Jobs created by RunTask API.
  GoogleCloudDataplexV1Job? job;

  GoogleCloudDataplexV1RunTaskResponse({
    this.job,
  });

  GoogleCloudDataplexV1RunTaskResponse.fromJson(core.Map json_)
      : this(
          job: json_.containsKey('job')
              ? GoogleCloudDataplexV1Job.fromJson(
                  json_['job'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (job != null) 'job': job!,
      };
}

/// The data scanned during processing (e.g. in incremental DataScan)
class GoogleCloudDataplexV1ScannedData {
  /// The range denoted by values of an incremental field
  GoogleCloudDataplexV1ScannedDataIncrementalField? incrementalField;

  GoogleCloudDataplexV1ScannedData({
    this.incrementalField,
  });

  GoogleCloudDataplexV1ScannedData.fromJson(core.Map json_)
      : this(
          incrementalField: json_.containsKey('incrementalField')
              ? GoogleCloudDataplexV1ScannedDataIncrementalField.fromJson(
                  json_['incrementalField']
                      as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (incrementalField != null) 'incrementalField': incrementalField!,
      };
}

/// A data range denoted by a pair of start/end values of a field.
class GoogleCloudDataplexV1ScannedDataIncrementalField {
  /// Value that marks the end of the range.
  core.String? end;

  /// The field that contains values which monotonically increases over time
  /// (e.g. a timestamp column).
  core.String? field;

  /// Value that marks the start of the range.
  core.String? start;

  GoogleCloudDataplexV1ScannedDataIncrementalField({
    this.end,
    this.field,
    this.start,
  });

  GoogleCloudDataplexV1ScannedDataIncrementalField.fromJson(core.Map json_)
      : this(
          end: json_['end'] as core.String?,
          field: json_['field'] as core.String?,
          start: json_['start'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (end != null) 'end': end!,
        if (field != null) 'field': field!,
        if (start != null) 'start': start!,
      };
}

/// Schema information describing the structure and layout of the data.
class GoogleCloudDataplexV1Schema {
  /// The sequence of fields describing data in table entities.
  ///
  /// Note: BigQuery SchemaFields are immutable.
  ///
  /// Optional.
  core.List<GoogleCloudDataplexV1SchemaSchemaField>? fields;

  /// The sequence of fields describing the partition structure in entities.
  ///
  /// If this field is empty, there are no partitions within the data.
  ///
  /// Optional.
  core.List<GoogleCloudDataplexV1SchemaPartitionField>? partitionFields;

  /// The structure of paths containing partition data within the entity.
  ///
  /// Optional.
  /// Possible string values are:
  /// - "PARTITION_STYLE_UNSPECIFIED" : PartitionStyle unspecified
  /// - "HIVE_COMPATIBLE" : Partitions are hive-compatible. Examples:
  /// gs://bucket/path/to/table/dt=2019-10-31/lang=en,
  /// gs://bucket/path/to/table/dt=2019-10-31/lang=en/late.
  core.String? partitionStyle;

  /// Set to true if user-managed or false if managed by Dataplex.
  ///
  /// The default is false (managed by Dataplex). Set to falseto enable Dataplex
  /// discovery to update the schema. including new data discovery, schema
  /// inference, and schema evolution. Users retain the ability to input and
  /// edit the schema. Dataplex treats schema input by the user as though
  /// produced by a previous Dataplex discovery operation, and it will evolve
  /// the schema and take action based on that treatment. Set to true to fully
  /// manage the entity schema. This setting guarantees that Dataplex will not
  /// change schema fields.
  ///
  /// Required.
  core.bool? userManaged;

  GoogleCloudDataplexV1Schema({
    this.fields,
    this.partitionFields,
    this.partitionStyle,
    this.userManaged,
  });

  GoogleCloudDataplexV1Schema.fromJson(core.Map json_)
      : this(
          fields: (json_['fields'] as core.List?)
              ?.map((value) => GoogleCloudDataplexV1SchemaSchemaField.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
          partitionFields: (json_['partitionFields'] as core.List?)
              ?.map((value) =>
                  GoogleCloudDataplexV1SchemaPartitionField.fromJson(
                      value as core.Map<core.String, core.dynamic>))
              .toList(),
          partitionStyle: json_['partitionStyle'] as core.String?,
          userManaged: json_['userManaged'] as core.bool?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (fields != null) 'fields': fields!,
        if (partitionFields != null) 'partitionFields': partitionFields!,
        if (partitionStyle != null) 'partitionStyle': partitionStyle!,
        if (userManaged != null) 'userManaged': userManaged!,
      };
}

/// Represents a key field within the entity's partition structure.
///
/// You could have up to 20 partition fields, but only the first 10 partitions
/// have the filtering ability due to performance consideration. Note: Partition
/// fields are immutable.
class GoogleCloudDataplexV1SchemaPartitionField {
  /// Partition field name must consist of letters, numbers, and underscores
  /// only, with a maximum of length of 256 characters, and must begin with a
  /// letter or underscore..
  ///
  /// Required.
  core.String? name;

  /// The type of field.
  ///
  /// Required. Immutable.
  /// Possible string values are:
  /// - "TYPE_UNSPECIFIED" : SchemaType unspecified.
  /// - "BOOLEAN" : Boolean field.
  /// - "BYTE" : Single byte numeric field.
  /// - "INT16" : 16-bit numeric field.
  /// - "INT32" : 32-bit numeric field.
  /// - "INT64" : 64-bit numeric field.
  /// - "FLOAT" : Floating point numeric field.
  /// - "DOUBLE" : Double precision numeric field.
  /// - "DECIMAL" : Real value numeric field.
  /// - "STRING" : Sequence of characters field.
  /// - "BINARY" : Sequence of bytes field.
  /// - "TIMESTAMP" : Date and time field.
  /// - "DATE" : Date field.
  /// - "TIME" : Time field.
  /// - "RECORD" : Structured field. Nested fields that define the structure of
  /// the map. If all nested fields are nullable, this field represents a union.
  /// - "NULL" : Null field that does not have values.
  core.String? type;

  GoogleCloudDataplexV1SchemaPartitionField({
    this.name,
    this.type,
  });

  GoogleCloudDataplexV1SchemaPartitionField.fromJson(core.Map json_)
      : this(
          name: json_['name'] as core.String?,
          type: json_['type'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (name != null) 'name': name!,
        if (type != null) 'type': type!,
      };
}

/// Represents a column field within a table schema.
class GoogleCloudDataplexV1SchemaSchemaField {
  /// User friendly field description.
  ///
  /// Must be less than or equal to 1024 characters.
  ///
  /// Optional.
  core.String? description;

  /// Any nested field for complex types.
  ///
  /// Optional.
  core.List<GoogleCloudDataplexV1SchemaSchemaField>? fields;

  /// Additional field semantics.
  ///
  /// Required.
  /// Possible string values are:
  /// - "MODE_UNSPECIFIED" : Mode unspecified.
  /// - "REQUIRED" : The field has required semantics.
  /// - "NULLABLE" : The field has optional semantics, and may be null.
  /// - "REPEATED" : The field has repeated (0 or more) semantics, and is a list
  /// of values.
  core.String? mode;

  /// The name of the field.
  ///
  /// Must contain only letters, numbers and underscores, with a maximum length
  /// of 767 characters, and must begin with a letter or underscore.
  ///
  /// Required.
  core.String? name;

  /// The type of field.
  ///
  /// Required.
  /// Possible string values are:
  /// - "TYPE_UNSPECIFIED" : SchemaType unspecified.
  /// - "BOOLEAN" : Boolean field.
  /// - "BYTE" : Single byte numeric field.
  /// - "INT16" : 16-bit numeric field.
  /// - "INT32" : 32-bit numeric field.
  /// - "INT64" : 64-bit numeric field.
  /// - "FLOAT" : Floating point numeric field.
  /// - "DOUBLE" : Double precision numeric field.
  /// - "DECIMAL" : Real value numeric field.
  /// - "STRING" : Sequence of characters field.
  /// - "BINARY" : Sequence of bytes field.
  /// - "TIMESTAMP" : Date and time field.
  /// - "DATE" : Date field.
  /// - "TIME" : Time field.
  /// - "RECORD" : Structured field. Nested fields that define the structure of
  /// the map. If all nested fields are nullable, this field represents a union.
  /// - "NULL" : Null field that does not have values.
  core.String? type;

  GoogleCloudDataplexV1SchemaSchemaField({
    this.description,
    this.fields,
    this.mode,
    this.name,
    this.type,
  });

  GoogleCloudDataplexV1SchemaSchemaField.fromJson(core.Map json_)
      : this(
          description: json_['description'] as core.String?,
          fields: (json_['fields'] as core.List?)
              ?.map((value) => GoogleCloudDataplexV1SchemaSchemaField.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
          mode: json_['mode'] as core.String?,
          name: json_['name'] as core.String?,
          type: json_['type'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (description != null) 'description': description!,
        if (fields != null) 'fields': fields!,
        if (mode != null) 'mode': mode!,
        if (name != null) 'name': name!,
        if (type != null) 'type': type!,
      };
}

class GoogleCloudDataplexV1SearchEntriesResponse {
  /// Token to retrieve the next page of results, or empty if there are no more
  /// results in the list.
  core.String? nextPageToken;

  /// The results matching the search query.
  core.List<GoogleCloudDataplexV1SearchEntriesResult>? results;

  /// The estimated total number of matching entries.
  ///
  /// This number isn't guaranteed to be accurate.
  core.int? totalSize;

  /// Locations that the service couldn't reach.
  ///
  /// Search results don't include data from these locations.
  core.List<core.String>? unreachable;

  GoogleCloudDataplexV1SearchEntriesResponse({
    this.nextPageToken,
    this.results,
    this.totalSize,
    this.unreachable,
  });

  GoogleCloudDataplexV1SearchEntriesResponse.fromJson(core.Map json_)
      : this(
          nextPageToken: json_['nextPageToken'] as core.String?,
          results: (json_['results'] as core.List?)
              ?.map((value) =>
                  GoogleCloudDataplexV1SearchEntriesResult.fromJson(
                      value as core.Map<core.String, core.dynamic>))
              .toList(),
          totalSize: json_['totalSize'] as core.int?,
          unreachable: (json_['unreachable'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (results != null) 'results': results!,
        if (totalSize != null) 'totalSize': totalSize!,
        if (unreachable != null) 'unreachable': unreachable!,
      };
}

/// A single result of a SearchEntries request.
class GoogleCloudDataplexV1SearchEntriesResult {
  GoogleCloudDataplexV1Entry? dataplexEntry;

  /// Linked resource name.
  @core.Deprecated(
    'Not supported. Member documentation may have more information.',
  )
  core.String? linkedResource;

  /// Snippets.
  @core.Deprecated(
    'Not supported. Member documentation may have more information.',
  )
  GoogleCloudDataplexV1SearchEntriesResultSnippets? snippets;

  GoogleCloudDataplexV1SearchEntriesResult({
    this.dataplexEntry,
    this.linkedResource,
    this.snippets,
  });

  GoogleCloudDataplexV1SearchEntriesResult.fromJson(core.Map json_)
      : this(
          dataplexEntry: json_.containsKey('dataplexEntry')
              ? GoogleCloudDataplexV1Entry.fromJson(
                  json_['dataplexEntry'] as core.Map<core.String, core.dynamic>)
              : null,
          linkedResource: json_['linkedResource'] as core.String?,
          snippets: json_.containsKey('snippets')
              ? GoogleCloudDataplexV1SearchEntriesResultSnippets.fromJson(
                  json_['snippets'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (dataplexEntry != null) 'dataplexEntry': dataplexEntry!,
        if (linkedResource != null) 'linkedResource': linkedResource!,
        if (snippets != null) 'snippets': snippets!,
      };
}

/// Snippets for the entry, contains HTML-style highlighting for matched tokens,
/// will be used in UI.
class GoogleCloudDataplexV1SearchEntriesResultSnippets {
  /// Entry
  @core.Deprecated(
    'Not supported. Member documentation may have more information.',
  )
  GoogleCloudDataplexV1Entry? dataplexEntry;

  GoogleCloudDataplexV1SearchEntriesResultSnippets({
    this.dataplexEntry,
  });

  GoogleCloudDataplexV1SearchEntriesResultSnippets.fromJson(core.Map json_)
      : this(
          dataplexEntry: json_.containsKey('dataplexEntry')
              ? GoogleCloudDataplexV1Entry.fromJson(
                  json_['dataplexEntry'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (dataplexEntry != null) 'dataplexEntry': dataplexEntry!,
      };
}

/// Represents an active analyze session running for a user.
class GoogleCloudDataplexV1Session {
  /// Session start time.
  ///
  /// Output only.
  core.String? createTime;

  /// The relative resource name of the content, of the form:
  /// projects/{project_id}/locations/{location_id}/lakes/{lake_id}/environment/{environment_id}/sessions/{session_id}
  ///
  /// Output only.
  core.String? name;

  /// State of Session
  ///
  /// Output only.
  /// Possible string values are:
  /// - "STATE_UNSPECIFIED" : State is not specified.
  /// - "ACTIVE" : Resource is active, i.e., ready to use.
  /// - "CREATING" : Resource is under creation.
  /// - "DELETING" : Resource is under deletion.
  /// - "ACTION_REQUIRED" : Resource is active but has unresolved actions.
  core.String? state;

  /// Email of user running the session.
  ///
  /// Output only.
  core.String? userId;

  GoogleCloudDataplexV1Session({
    this.createTime,
    this.name,
    this.state,
    this.userId,
  });

  GoogleCloudDataplexV1Session.fromJson(core.Map json_)
      : this(
          createTime: json_['createTime'] as core.String?,
          name: json_['name'] as core.String?,
          state: json_['state'] as core.String?,
          userId: json_['userId'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (createTime != null) 'createTime': createTime!,
        if (name != null) 'name': name!,
        if (state != null) 'state': state!,
        if (userId != null) 'userId': userId!,
      };
}

/// Describes the access mechanism of the data within its storage location.
class GoogleCloudDataplexV1StorageAccess {
  /// Describes the read access mechanism of the data.
  ///
  /// Not user settable.
  ///
  /// Output only.
  /// Possible string values are:
  /// - "ACCESS_MODE_UNSPECIFIED" : Access mode unspecified.
  /// - "DIRECT" : Default. Data is accessed directly using storage APIs.
  /// - "MANAGED" : Data is accessed through a managed interface using BigQuery
  /// APIs.
  core.String? read;

  GoogleCloudDataplexV1StorageAccess({
    this.read,
  });

  GoogleCloudDataplexV1StorageAccess.fromJson(core.Map json_)
      : this(
          read: json_['read'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (read != null) 'read': read!,
      };
}

/// Describes the format of the data within its storage location.
class GoogleCloudDataplexV1StorageFormat {
  /// The compression type associated with the stored data.
  ///
  /// If unspecified, the data is uncompressed.
  ///
  /// Optional.
  /// Possible string values are:
  /// - "COMPRESSION_FORMAT_UNSPECIFIED" : CompressionFormat unspecified.
  /// Implies uncompressed data.
  /// - "GZIP" : GZip compressed set of files.
  /// - "BZIP2" : BZip2 compressed set of files.
  core.String? compressionFormat;

  /// Additional information about CSV formatted data.
  ///
  /// Optional.
  GoogleCloudDataplexV1StorageFormatCsvOptions? csv;

  /// The data format associated with the stored data, which represents content
  /// type values.
  ///
  /// The value is inferred from mime type.
  ///
  /// Output only.
  /// Possible string values are:
  /// - "FORMAT_UNSPECIFIED" : Format unspecified.
  /// - "PARQUET" : Parquet-formatted structured data.
  /// - "AVRO" : Avro-formatted structured data.
  /// - "ORC" : Orc-formatted structured data.
  /// - "CSV" : Csv-formatted semi-structured data.
  /// - "JSON" : Json-formatted semi-structured data.
  /// - "IMAGE" : Image data formats (such as jpg and png).
  /// - "AUDIO" : Audio data formats (such as mp3, and wav).
  /// - "VIDEO" : Video data formats (such as mp4 and mpg).
  /// - "TEXT" : Textual data formats (such as txt and xml).
  /// - "TFRECORD" : TensorFlow record format.
  /// - "OTHER" : Data that doesn't match a specific format.
  /// - "UNKNOWN" : Data of an unknown format.
  core.String? format;

  /// Additional information about iceberg tables.
  ///
  /// Optional.
  GoogleCloudDataplexV1StorageFormatIcebergOptions? iceberg;

  /// Additional information about CSV formatted data.
  ///
  /// Optional.
  GoogleCloudDataplexV1StorageFormatJsonOptions? json;

  /// The mime type descriptor for the data.
  ///
  /// Must match the pattern {type}/{subtype}. Supported values:
  /// application/x-parquet application/x-avro application/x-orc
  /// application/x-tfrecord application/x-parquet+iceberg
  /// application/x-avro+iceberg application/x-orc+iceberg application/json
  /// application/{subtypes} text/csv text/ image/{image subtype} video/{video
  /// subtype} audio/{audio subtype}
  ///
  /// Required.
  core.String? mimeType;

  GoogleCloudDataplexV1StorageFormat({
    this.compressionFormat,
    this.csv,
    this.format,
    this.iceberg,
    this.json,
    this.mimeType,
  });

  GoogleCloudDataplexV1StorageFormat.fromJson(core.Map json_)
      : this(
          compressionFormat: json_['compressionFormat'] as core.String?,
          csv: json_.containsKey('csv')
              ? GoogleCloudDataplexV1StorageFormatCsvOptions.fromJson(
                  json_['csv'] as core.Map<core.String, core.dynamic>)
              : null,
          format: json_['format'] as core.String?,
          iceberg: json_.containsKey('iceberg')
              ? GoogleCloudDataplexV1StorageFormatIcebergOptions.fromJson(
                  json_['iceberg'] as core.Map<core.String, core.dynamic>)
              : null,
          json: json_.containsKey('json')
              ? GoogleCloudDataplexV1StorageFormatJsonOptions.fromJson(
                  json_['json'] as core.Map<core.String, core.dynamic>)
              : null,
          mimeType: json_['mimeType'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (compressionFormat != null) 'compressionFormat': compressionFormat!,
        if (csv != null) 'csv': csv!,
        if (format != null) 'format': format!,
        if (iceberg != null) 'iceberg': iceberg!,
        if (json != null) 'json': json!,
        if (mimeType != null) 'mimeType': mimeType!,
      };
}

/// Describes CSV and similar semi-structured data formats.
class GoogleCloudDataplexV1StorageFormatCsvOptions {
  /// The delimiter used to separate values.
  ///
  /// Defaults to ','.
  ///
  /// Optional.
  core.String? delimiter;

  /// The character encoding of the data.
  ///
  /// Accepts "US-ASCII", "UTF-8", and "ISO-8859-1". Defaults to UTF-8 if
  /// unspecified.
  ///
  /// Optional.
  core.String? encoding;

  /// The number of rows to interpret as header rows that should be skipped when
  /// reading data rows.
  ///
  /// Defaults to 0.
  ///
  /// Optional.
  core.int? headerRows;

  /// The character used to quote column values.
  ///
  /// Accepts '"' (double quotation mark) or ''' (single quotation mark).
  /// Defaults to '"' (double quotation mark) if unspecified.
  ///
  /// Optional.
  core.String? quote;

  GoogleCloudDataplexV1StorageFormatCsvOptions({
    this.delimiter,
    this.encoding,
    this.headerRows,
    this.quote,
  });

  GoogleCloudDataplexV1StorageFormatCsvOptions.fromJson(core.Map json_)
      : this(
          delimiter: json_['delimiter'] as core.String?,
          encoding: json_['encoding'] as core.String?,
          headerRows: json_['headerRows'] as core.int?,
          quote: json_['quote'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (delimiter != null) 'delimiter': delimiter!,
        if (encoding != null) 'encoding': encoding!,
        if (headerRows != null) 'headerRows': headerRows!,
        if (quote != null) 'quote': quote!,
      };
}

/// Describes Iceberg data format.
class GoogleCloudDataplexV1StorageFormatIcebergOptions {
  /// The location of where the iceberg metadata is present, must be within the
  /// table path
  ///
  /// Optional.
  core.String? metadataLocation;

  GoogleCloudDataplexV1StorageFormatIcebergOptions({
    this.metadataLocation,
  });

  GoogleCloudDataplexV1StorageFormatIcebergOptions.fromJson(core.Map json_)
      : this(
          metadataLocation: json_['metadataLocation'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (metadataLocation != null) 'metadataLocation': metadataLocation!,
      };
}

/// Describes JSON data format.
class GoogleCloudDataplexV1StorageFormatJsonOptions {
  /// The character encoding of the data.
  ///
  /// Accepts "US-ASCII", "UTF-8" and "ISO-8859-1". Defaults to UTF-8 if not
  /// specified.
  ///
  /// Optional.
  core.String? encoding;

  GoogleCloudDataplexV1StorageFormatJsonOptions({
    this.encoding,
  });

  GoogleCloudDataplexV1StorageFormatJsonOptions.fromJson(core.Map json_)
      : this(
          encoding: json_['encoding'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (encoding != null) 'encoding': encoding!,
      };
}

/// A task represents a user-visible job.
class GoogleCloudDataplexV1Task {
  /// The time when the task was created.
  ///
  /// Output only.
  core.String? createTime;

  /// Description of the task.
  ///
  /// Optional.
  core.String? description;

  /// User friendly display name.
  ///
  /// Optional.
  core.String? displayName;

  /// Spec related to how a task is executed.
  ///
  /// Required.
  GoogleCloudDataplexV1TaskExecutionSpec? executionSpec;

  /// Status of the latest task executions.
  ///
  /// Output only.
  GoogleCloudDataplexV1TaskExecutionStatus? executionStatus;

  /// User-defined labels for the task.
  ///
  /// Optional.
  core.Map<core.String, core.String>? labels;

  /// The relative resource name of the task, of the form:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/
  /// tasks/{task_id}.
  ///
  /// Output only.
  core.String? name;

  /// Config related to running scheduled Notebooks.
  GoogleCloudDataplexV1TaskNotebookTaskConfig? notebook;

  /// Config related to running custom Spark tasks.
  GoogleCloudDataplexV1TaskSparkTaskConfig? spark;

  /// Current state of the task.
  ///
  /// Output only.
  /// Possible string values are:
  /// - "STATE_UNSPECIFIED" : State is not specified.
  /// - "ACTIVE" : Resource is active, i.e., ready to use.
  /// - "CREATING" : Resource is under creation.
  /// - "DELETING" : Resource is under deletion.
  /// - "ACTION_REQUIRED" : Resource is active but has unresolved actions.
  core.String? state;

  /// Spec related to how often and when a task should be triggered.
  ///
  /// Required.
  GoogleCloudDataplexV1TaskTriggerSpec? triggerSpec;

  /// System generated globally unique ID for the task.
  ///
  /// This ID will be different if the task is deleted and re-created with the
  /// same name.
  ///
  /// Output only.
  core.String? uid;

  /// The time when the task was last updated.
  ///
  /// Output only.
  core.String? updateTime;

  GoogleCloudDataplexV1Task({
    this.createTime,
    this.description,
    this.displayName,
    this.executionSpec,
    this.executionStatus,
    this.labels,
    this.name,
    this.notebook,
    this.spark,
    this.state,
    this.triggerSpec,
    this.uid,
    this.updateTime,
  });

  GoogleCloudDataplexV1Task.fromJson(core.Map json_)
      : this(
          createTime: json_['createTime'] as core.String?,
          description: json_['description'] as core.String?,
          displayName: json_['displayName'] as core.String?,
          executionSpec: json_.containsKey('executionSpec')
              ? GoogleCloudDataplexV1TaskExecutionSpec.fromJson(
                  json_['executionSpec'] as core.Map<core.String, core.dynamic>)
              : null,
          executionStatus: json_.containsKey('executionStatus')
              ? GoogleCloudDataplexV1TaskExecutionStatus.fromJson(
                  json_['executionStatus']
                      as core.Map<core.String, core.dynamic>)
              : null,
          labels:
              (json_['labels'] as core.Map<core.String, core.dynamic>?)?.map(
            (key, value) => core.MapEntry(
              key,
              value as core.String,
            ),
          ),
          name: json_['name'] as core.String?,
          notebook: json_.containsKey('notebook')
              ? GoogleCloudDataplexV1TaskNotebookTaskConfig.fromJson(
                  json_['notebook'] as core.Map<core.String, core.dynamic>)
              : null,
          spark: json_.containsKey('spark')
              ? GoogleCloudDataplexV1TaskSparkTaskConfig.fromJson(
                  json_['spark'] as core.Map<core.String, core.dynamic>)
              : null,
          state: json_['state'] as core.String?,
          triggerSpec: json_.containsKey('triggerSpec')
              ? GoogleCloudDataplexV1TaskTriggerSpec.fromJson(
                  json_['triggerSpec'] as core.Map<core.String, core.dynamic>)
              : null,
          uid: json_['uid'] as core.String?,
          updateTime: json_['updateTime'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (createTime != null) 'createTime': createTime!,
        if (description != null) 'description': description!,
        if (displayName != null) 'displayName': displayName!,
        if (executionSpec != null) 'executionSpec': executionSpec!,
        if (executionStatus != null) 'executionStatus': executionStatus!,
        if (labels != null) 'labels': labels!,
        if (name != null) 'name': name!,
        if (notebook != null) 'notebook': notebook!,
        if (spark != null) 'spark': spark!,
        if (state != null) 'state': state!,
        if (triggerSpec != null) 'triggerSpec': triggerSpec!,
        if (uid != null) 'uid': uid!,
        if (updateTime != null) 'updateTime': updateTime!,
      };
}

/// Execution related settings, like retry and service_account.
class GoogleCloudDataplexV1TaskExecutionSpec {
  /// The arguments to pass to the task.
  ///
  /// The args can use placeholders of the format ${placeholder} as part of
  /// key/value string. These will be interpolated before passing the args to
  /// the driver. Currently supported placeholders: - ${task_id} - ${job_time}
  /// To pass positional args, set the key as TASK_ARGS. The value should be a
  /// comma-separated string of all the positional arguments. To use a delimiter
  /// other than comma, refer to
  /// https://cloud.google.com/sdk/gcloud/reference/topic/escaping. In case of
  /// other keys being present in the args, then TASK_ARGS will be passed as the
  /// last argument.
  ///
  /// Optional.
  core.Map<core.String, core.String>? args;

  /// The Cloud KMS key to use for encryption, of the form:
  /// projects/{project_number}/locations/{location_id}/keyRings/{key-ring-name}/cryptoKeys/{key-name}.
  ///
  /// Optional.
  core.String? kmsKey;

  /// The maximum duration after which the job execution is expired.
  ///
  /// Optional.
  core.String? maxJobExecutionLifetime;

  /// The project in which jobs are run.
  ///
  /// By default, the project containing the Lake is used. If a project is
  /// provided, the ExecutionSpec.service_account must belong to this project.
  ///
  /// Optional.
  core.String? project;

  /// Service account to use to execute a task.
  ///
  /// If not provided, the default Compute service account for the project is
  /// used.
  ///
  /// Required.
  core.String? serviceAccount;

  GoogleCloudDataplexV1TaskExecutionSpec({
    this.args,
    this.kmsKey,
    this.maxJobExecutionLifetime,
    this.project,
    this.serviceAccount,
  });

  GoogleCloudDataplexV1TaskExecutionSpec.fromJson(core.Map json_)
      : this(
          args: (json_['args'] as core.Map<core.String, core.dynamic>?)?.map(
            (key, value) => core.MapEntry(
              key,
              value as core.String,
            ),
          ),
          kmsKey: json_['kmsKey'] as core.String?,
          maxJobExecutionLifetime:
              json_['maxJobExecutionLifetime'] as core.String?,
          project: json_['project'] as core.String?,
          serviceAccount: json_['serviceAccount'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (args != null) 'args': args!,
        if (kmsKey != null) 'kmsKey': kmsKey!,
        if (maxJobExecutionLifetime != null)
          'maxJobExecutionLifetime': maxJobExecutionLifetime!,
        if (project != null) 'project': project!,
        if (serviceAccount != null) 'serviceAccount': serviceAccount!,
      };
}

/// Status of the task execution (e.g. Jobs).
class GoogleCloudDataplexV1TaskExecutionStatus {
  /// latest job execution
  ///
  /// Output only.
  GoogleCloudDataplexV1Job? latestJob;

  /// Last update time of the status.
  ///
  /// Output only.
  core.String? updateTime;

  GoogleCloudDataplexV1TaskExecutionStatus({
    this.latestJob,
    this.updateTime,
  });

  GoogleCloudDataplexV1TaskExecutionStatus.fromJson(core.Map json_)
      : this(
          latestJob: json_.containsKey('latestJob')
              ? GoogleCloudDataplexV1Job.fromJson(
                  json_['latestJob'] as core.Map<core.String, core.dynamic>)
              : null,
          updateTime: json_['updateTime'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (latestJob != null) 'latestJob': latestJob!,
        if (updateTime != null) 'updateTime': updateTime!,
      };
}

/// Configuration for the underlying infrastructure used to run workloads.
class GoogleCloudDataplexV1TaskInfrastructureSpec {
  /// Compute resources needed for a Task when using Dataproc Serverless.
  GoogleCloudDataplexV1TaskInfrastructureSpecBatchComputeResources? batch;

  /// Container Image Runtime Configuration.
  GoogleCloudDataplexV1TaskInfrastructureSpecContainerImageRuntime?
      containerImage;

  /// Vpc network.
  GoogleCloudDataplexV1TaskInfrastructureSpecVpcNetwork? vpcNetwork;

  GoogleCloudDataplexV1TaskInfrastructureSpec({
    this.batch,
    this.containerImage,
    this.vpcNetwork,
  });

  GoogleCloudDataplexV1TaskInfrastructureSpec.fromJson(core.Map json_)
      : this(
          batch: json_.containsKey('batch')
              ? GoogleCloudDataplexV1TaskInfrastructureSpecBatchComputeResources
                  .fromJson(
                      json_['batch'] as core.Map<core.String, core.dynamic>)
              : null,
          containerImage: json_.containsKey('containerImage')
              ? GoogleCloudDataplexV1TaskInfrastructureSpecContainerImageRuntime
                  .fromJson(json_['containerImage']
                      as core.Map<core.String, core.dynamic>)
              : null,
          vpcNetwork: json_.containsKey('vpcNetwork')
              ? GoogleCloudDataplexV1TaskInfrastructureSpecVpcNetwork.fromJson(
                  json_['vpcNetwork'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (batch != null) 'batch': batch!,
        if (containerImage != null) 'containerImage': containerImage!,
        if (vpcNetwork != null) 'vpcNetwork': vpcNetwork!,
      };
}

/// Batch compute resources associated with the task.
class GoogleCloudDataplexV1TaskInfrastructureSpecBatchComputeResources {
  /// Total number of job executors.
  ///
  /// Executor Count should be between 2 and 100. Default=2
  ///
  /// Optional.
  core.int? executorsCount;

  /// Max configurable executors.
  ///
  /// If max_executors_count \> executors_count, then auto-scaling is enabled.
  /// Max Executor Count should be between 2 and 1000. Default=1000
  ///
  /// Optional.
  core.int? maxExecutorsCount;

  GoogleCloudDataplexV1TaskInfrastructureSpecBatchComputeResources({
    this.executorsCount,
    this.maxExecutorsCount,
  });

  GoogleCloudDataplexV1TaskInfrastructureSpecBatchComputeResources.fromJson(
      core.Map json_)
      : this(
          executorsCount: json_['executorsCount'] as core.int?,
          maxExecutorsCount: json_['maxExecutorsCount'] as core.int?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (executorsCount != null) 'executorsCount': executorsCount!,
        if (maxExecutorsCount != null) 'maxExecutorsCount': maxExecutorsCount!,
      };
}

/// Container Image Runtime Configuration used with Batch execution.
class GoogleCloudDataplexV1TaskInfrastructureSpecContainerImageRuntime {
  /// Container image to use.
  ///
  /// Optional.
  core.String? image;

  /// A list of Java JARS to add to the classpath.
  ///
  /// Valid input includes Cloud Storage URIs to Jar binaries. For example,
  /// gs://bucket-name/my/path/to/file.jar
  ///
  /// Optional.
  core.List<core.String>? javaJars;

  /// Override to common configuration of open source components installed on
  /// the Dataproc cluster.
  ///
  /// The properties to set on daemon config files. Property keys are specified
  /// in prefix:property format, for example core:hadoop.tmp.dir. For more
  /// information, see Cluster properties
  /// (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
  ///
  /// Optional.
  core.Map<core.String, core.String>? properties;

  /// A list of python packages to be installed.
  ///
  /// Valid formats include Cloud Storage URI to a PIP installable library. For
  /// example, gs://bucket-name/my/path/to/lib.tar.gz
  ///
  /// Optional.
  core.List<core.String>? pythonPackages;

  GoogleCloudDataplexV1TaskInfrastructureSpecContainerImageRuntime({
    this.image,
    this.javaJars,
    this.properties,
    this.pythonPackages,
  });

  GoogleCloudDataplexV1TaskInfrastructureSpecContainerImageRuntime.fromJson(
      core.Map json_)
      : this(
          image: json_['image'] as core.String?,
          javaJars: (json_['javaJars'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
          properties:
              (json_['properties'] as core.Map<core.String, core.dynamic>?)
                  ?.map(
            (key, value) => core.MapEntry(
              key,
              value as core.String,
            ),
          ),
          pythonPackages: (json_['pythonPackages'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (image != null) 'image': image!,
        if (javaJars != null) 'javaJars': javaJars!,
        if (properties != null) 'properties': properties!,
        if (pythonPackages != null) 'pythonPackages': pythonPackages!,
      };
}

/// Cloud VPC Network used to run the infrastructure.
class GoogleCloudDataplexV1TaskInfrastructureSpecVpcNetwork {
  /// The Cloud VPC network in which the job is run.
  ///
  /// By default, the Cloud VPC network named Default within the project is
  /// used.
  ///
  /// Optional.
  core.String? network;

  /// List of network tags to apply to the job.
  ///
  /// Optional.
  core.List<core.String>? networkTags;

  /// The Cloud VPC sub-network in which the job is run.
  ///
  /// Optional.
  core.String? subNetwork;

  GoogleCloudDataplexV1TaskInfrastructureSpecVpcNetwork({
    this.network,
    this.networkTags,
    this.subNetwork,
  });

  GoogleCloudDataplexV1TaskInfrastructureSpecVpcNetwork.fromJson(core.Map json_)
      : this(
          network: json_['network'] as core.String?,
          networkTags: (json_['networkTags'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
          subNetwork: json_['subNetwork'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (network != null) 'network': network!,
        if (networkTags != null) 'networkTags': networkTags!,
        if (subNetwork != null) 'subNetwork': subNetwork!,
      };
}

/// Config for running scheduled notebooks.
class GoogleCloudDataplexV1TaskNotebookTaskConfig {
  /// Cloud Storage URIs of archives to be extracted into the working directory
  /// of each executor.
  ///
  /// Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
  ///
  /// Optional.
  core.List<core.String>? archiveUris;

  /// Cloud Storage URIs of files to be placed in the working directory of each
  /// executor.
  ///
  /// Optional.
  core.List<core.String>? fileUris;

  /// Infrastructure specification for the execution.
  ///
  /// Optional.
  GoogleCloudDataplexV1TaskInfrastructureSpec? infrastructureSpec;

  /// Path to input notebook.
  ///
  /// This can be the Cloud Storage URI of the notebook file or the path to a
  /// Notebook Content. The execution args are accessible as environment
  /// variables (TASK_key=value).
  ///
  /// Required.
  core.String? notebook;

  GoogleCloudDataplexV1TaskNotebookTaskConfig({
    this.archiveUris,
    this.fileUris,
    this.infrastructureSpec,
    this.notebook,
  });

  GoogleCloudDataplexV1TaskNotebookTaskConfig.fromJson(core.Map json_)
      : this(
          archiveUris: (json_['archiveUris'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
          fileUris: (json_['fileUris'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
          infrastructureSpec: json_.containsKey('infrastructureSpec')
              ? GoogleCloudDataplexV1TaskInfrastructureSpec.fromJson(
                  json_['infrastructureSpec']
                      as core.Map<core.String, core.dynamic>)
              : null,
          notebook: json_['notebook'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (archiveUris != null) 'archiveUris': archiveUris!,
        if (fileUris != null) 'fileUris': fileUris!,
        if (infrastructureSpec != null)
          'infrastructureSpec': infrastructureSpec!,
        if (notebook != null) 'notebook': notebook!,
      };
}

/// User-specified config for running a Spark task.
class GoogleCloudDataplexV1TaskSparkTaskConfig {
  /// Cloud Storage URIs of archives to be extracted into the working directory
  /// of each executor.
  ///
  /// Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
  ///
  /// Optional.
  core.List<core.String>? archiveUris;

  /// Cloud Storage URIs of files to be placed in the working directory of each
  /// executor.
  ///
  /// Optional.
  core.List<core.String>? fileUris;

  /// Infrastructure specification for the execution.
  ///
  /// Optional.
  GoogleCloudDataplexV1TaskInfrastructureSpec? infrastructureSpec;

  /// The name of the driver's main class.
  ///
  /// The jar file that contains the class must be in the default CLASSPATH or
  /// specified in jar_file_uris. The execution args are passed in as a sequence
  /// of named process arguments (--key=value).
  core.String? mainClass;

  /// The Cloud Storage URI of the jar file that contains the main class.
  ///
  /// The execution args are passed in as a sequence of named process arguments
  /// (--key=value).
  core.String? mainJarFileUri;

  /// The Gcloud Storage URI of the main Python file to use as the driver.
  ///
  /// Must be a .py file. The execution args are passed in as a sequence of
  /// named process arguments (--key=value).
  core.String? pythonScriptFile;

  /// The query text.
  ///
  /// The execution args are used to declare a set of script variables (set
  /// key="value";).
  core.String? sqlScript;

  /// A reference to a query file.
  ///
  /// This should be the Cloud Storage URI of the query file. The execution args
  /// are used to declare a set of script variables (set key="value";).
  core.String? sqlScriptFile;

  GoogleCloudDataplexV1TaskSparkTaskConfig({
    this.archiveUris,
    this.fileUris,
    this.infrastructureSpec,
    this.mainClass,
    this.mainJarFileUri,
    this.pythonScriptFile,
    this.sqlScript,
    this.sqlScriptFile,
  });

  GoogleCloudDataplexV1TaskSparkTaskConfig.fromJson(core.Map json_)
      : this(
          archiveUris: (json_['archiveUris'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
          fileUris: (json_['fileUris'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
          infrastructureSpec: json_.containsKey('infrastructureSpec')
              ? GoogleCloudDataplexV1TaskInfrastructureSpec.fromJson(
                  json_['infrastructureSpec']
                      as core.Map<core.String, core.dynamic>)
              : null,
          mainClass: json_['mainClass'] as core.String?,
          mainJarFileUri: json_['mainJarFileUri'] as core.String?,
          pythonScriptFile: json_['pythonScriptFile'] as core.String?,
          sqlScript: json_['sqlScript'] as core.String?,
          sqlScriptFile: json_['sqlScriptFile'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (archiveUris != null) 'archiveUris': archiveUris!,
        if (fileUris != null) 'fileUris': fileUris!,
        if (infrastructureSpec != null)
          'infrastructureSpec': infrastructureSpec!,
        if (mainClass != null) 'mainClass': mainClass!,
        if (mainJarFileUri != null) 'mainJarFileUri': mainJarFileUri!,
        if (pythonScriptFile != null) 'pythonScriptFile': pythonScriptFile!,
        if (sqlScript != null) 'sqlScript': sqlScript!,
        if (sqlScriptFile != null) 'sqlScriptFile': sqlScriptFile!,
      };
}

/// Task scheduling and trigger settings.
class GoogleCloudDataplexV1TaskTriggerSpec {
  /// Prevent the task from executing.
  ///
  /// This does not cancel already running tasks. It is intended to temporarily
  /// disable RECURRING tasks.
  ///
  /// Optional.
  core.bool? disabled;

  /// Number of retry attempts before aborting.
  ///
  /// Set to zero to never attempt to retry a failed task.
  ///
  /// Optional.
  core.int? maxRetries;

  /// Cron schedule (https://en.wikipedia.org/wiki/Cron) for running tasks
  /// periodically.
  ///
  /// To explicitly set a timezone to the cron tab, apply a prefix in the cron
  /// tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}". The
  /// ${IANA_TIME_ZONE} may only be a valid string from IANA time zone database.
  /// For example, CRON_TZ=America/New_York 1 * * * *, or TZ=America/New_York 1
  /// * * * *. This field is required for RECURRING tasks.
  ///
  /// Optional.
  core.String? schedule;

  /// The first run of the task will be after this time.
  ///
  /// If not specified, the task will run shortly after being submitted if
  /// ON_DEMAND and based on the schedule if RECURRING.
  ///
  /// Optional.
  core.String? startTime;

  /// Trigger type of the user-specified Task.
  ///
  /// Required. Immutable.
  /// Possible string values are:
  /// - "TYPE_UNSPECIFIED" : Unspecified trigger type.
  /// - "ON_DEMAND" : The task runs one-time shortly after Task Creation.
  /// - "RECURRING" : The task is scheduled to run periodically.
  core.String? type;

  GoogleCloudDataplexV1TaskTriggerSpec({
    this.disabled,
    this.maxRetries,
    this.schedule,
    this.startTime,
    this.type,
  });

  GoogleCloudDataplexV1TaskTriggerSpec.fromJson(core.Map json_)
      : this(
          disabled: json_['disabled'] as core.bool?,
          maxRetries: json_['maxRetries'] as core.int?,
          schedule: json_['schedule'] as core.String?,
          startTime: json_['startTime'] as core.String?,
          type: json_['type'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (disabled != null) 'disabled': disabled!,
        if (maxRetries != null) 'maxRetries': maxRetries!,
        if (schedule != null) 'schedule': schedule!,
        if (startTime != null) 'startTime': startTime!,
        if (type != null) 'type': type!,
      };
}

/// DataScan scheduling and trigger settings.
class GoogleCloudDataplexV1Trigger {
  /// The scan runs once via RunDataScan API.
  GoogleCloudDataplexV1TriggerOnDemand? onDemand;

  /// The scan is scheduled to run periodically.
  GoogleCloudDataplexV1TriggerSchedule? schedule;

  GoogleCloudDataplexV1Trigger({
    this.onDemand,
    this.schedule,
  });

  GoogleCloudDataplexV1Trigger.fromJson(core.Map json_)
      : this(
          onDemand: json_.containsKey('onDemand')
              ? GoogleCloudDataplexV1TriggerOnDemand.fromJson(
                  json_['onDemand'] as core.Map<core.String, core.dynamic>)
              : null,
          schedule: json_.containsKey('schedule')
              ? GoogleCloudDataplexV1TriggerSchedule.fromJson(
                  json_['schedule'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (onDemand != null) 'onDemand': onDemand!,
        if (schedule != null) 'schedule': schedule!,
      };
}

/// The scan runs once via RunDataScan API.
typedef GoogleCloudDataplexV1TriggerOnDemand = $Empty;

/// The scan is scheduled to run periodically.
class GoogleCloudDataplexV1TriggerSchedule {
  /// Cron (https://en.wikipedia.org/wiki/Cron) schedule for running scans
  /// periodically.To explicitly set a timezone in the cron tab, apply a prefix
  /// in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}".
  ///
  /// The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone
  /// database (wikipedia
  /// (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones#List)). For
  /// example, CRON_TZ=America/New_York 1 * * * *, or TZ=America/New_York 1 * *
  /// * *.This field is required for Schedule scans.
  ///
  /// Required.
  core.String? cron;

  GoogleCloudDataplexV1TriggerSchedule({
    this.cron,
  });

  GoogleCloudDataplexV1TriggerSchedule.fromJson(core.Map json_)
      : this(
          cron: json_['cron'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (cron != null) 'cron': cron!,
      };
}

/// A zone represents a logical group of related assets within a lake.
///
/// A zone can be used to map to organizational structure or represent stages of
/// data readiness from raw to curated. It provides managing behavior that is
/// shared or inherited by all contained assets.
class GoogleCloudDataplexV1Zone {
  /// Aggregated status of the underlying assets of the zone.
  ///
  /// Output only.
  GoogleCloudDataplexV1AssetStatus? assetStatus;

  /// The time when the zone was created.
  ///
  /// Output only.
  core.String? createTime;

  /// Description of the zone.
  ///
  /// Optional.
  core.String? description;

  /// Specification of the discovery feature applied to data in this zone.
  ///
  /// Optional.
  GoogleCloudDataplexV1ZoneDiscoverySpec? discoverySpec;

  /// User friendly display name.
  ///
  /// Optional.
  core.String? displayName;

  /// User defined labels for the zone.
  ///
  /// Optional.
  core.Map<core.String, core.String>? labels;

  /// The relative resource name of the zone, of the form:
  /// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}.
  ///
  /// Output only.
  core.String? name;

  /// Specification of the resources that are referenced by the assets within
  /// this zone.
  ///
  /// Required.
  GoogleCloudDataplexV1ZoneResourceSpec? resourceSpec;

  /// Current state of the zone.
  ///
  /// Output only.
  /// Possible string values are:
  /// - "STATE_UNSPECIFIED" : State is not specified.
  /// - "ACTIVE" : Resource is active, i.e., ready to use.
  /// - "CREATING" : Resource is under creation.
  /// - "DELETING" : Resource is under deletion.
  /// - "ACTION_REQUIRED" : Resource is active but has unresolved actions.
  core.String? state;

  /// The type of the zone.
  ///
  /// Required. Immutable.
  /// Possible string values are:
  /// - "TYPE_UNSPECIFIED" : Zone type not specified.
  /// - "RAW" : A zone that contains data that needs further processing before
  /// it is considered generally ready for consumption and analytics workloads.
  /// - "CURATED" : A zone that contains data that is considered to be ready for
  /// broader consumption and analytics workloads. Curated structured data
  /// stored in Cloud Storage must conform to certain file formats (parquet,
  /// avro and orc) and organized in a hive-compatible directory layout.
  core.String? type;

  /// System generated globally unique ID for the zone.
  ///
  /// This ID will be different if the zone is deleted and re-created with the
  /// same name.
  ///
  /// Output only.
  core.String? uid;

  /// The time when the zone was last updated.
  ///
  /// Output only.
  core.String? updateTime;

  GoogleCloudDataplexV1Zone({
    this.assetStatus,
    this.createTime,
    this.description,
    this.discoverySpec,
    this.displayName,
    this.labels,
    this.name,
    this.resourceSpec,
    this.state,
    this.type,
    this.uid,
    this.updateTime,
  });

  GoogleCloudDataplexV1Zone.fromJson(core.Map json_)
      : this(
          assetStatus: json_.containsKey('assetStatus')
              ? GoogleCloudDataplexV1AssetStatus.fromJson(
                  json_['assetStatus'] as core.Map<core.String, core.dynamic>)
              : null,
          createTime: json_['createTime'] as core.String?,
          description: json_['description'] as core.String?,
          discoverySpec: json_.containsKey('discoverySpec')
              ? GoogleCloudDataplexV1ZoneDiscoverySpec.fromJson(
                  json_['discoverySpec'] as core.Map<core.String, core.dynamic>)
              : null,
          displayName: json_['displayName'] as core.String?,
          labels:
              (json_['labels'] as core.Map<core.String, core.dynamic>?)?.map(
            (key, value) => core.MapEntry(
              key,
              value as core.String,
            ),
          ),
          name: json_['name'] as core.String?,
          resourceSpec: json_.containsKey('resourceSpec')
              ? GoogleCloudDataplexV1ZoneResourceSpec.fromJson(
                  json_['resourceSpec'] as core.Map<core.String, core.dynamic>)
              : null,
          state: json_['state'] as core.String?,
          type: json_['type'] as core.String?,
          uid: json_['uid'] as core.String?,
          updateTime: json_['updateTime'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (assetStatus != null) 'assetStatus': assetStatus!,
        if (createTime != null) 'createTime': createTime!,
        if (description != null) 'description': description!,
        if (discoverySpec != null) 'discoverySpec': discoverySpec!,
        if (displayName != null) 'displayName': displayName!,
        if (labels != null) 'labels': labels!,
        if (name != null) 'name': name!,
        if (resourceSpec != null) 'resourceSpec': resourceSpec!,
        if (state != null) 'state': state!,
        if (type != null) 'type': type!,
        if (uid != null) 'uid': uid!,
        if (updateTime != null) 'updateTime': updateTime!,
      };
}

/// Settings to manage the metadata discovery and publishing in a zone.
class GoogleCloudDataplexV1ZoneDiscoverySpec {
  /// Configuration for CSV data.
  ///
  /// Optional.
  GoogleCloudDataplexV1ZoneDiscoverySpecCsvOptions? csvOptions;

  /// Whether discovery is enabled.
  ///
  /// Required.
  core.bool? enabled;

  /// The list of patterns to apply for selecting data to exclude during
  /// discovery.
  ///
  /// For Cloud Storage bucket assets, these are interpreted as glob patterns
  /// used to match object names. For BigQuery dataset assets, these are
  /// interpreted as patterns to match table names.
  ///
  /// Optional.
  core.List<core.String>? excludePatterns;

  /// The list of patterns to apply for selecting data to include during
  /// discovery if only a subset of the data should considered.
  ///
  /// For Cloud Storage bucket assets, these are interpreted as glob patterns
  /// used to match object names. For BigQuery dataset assets, these are
  /// interpreted as patterns to match table names.
  ///
  /// Optional.
  core.List<core.String>? includePatterns;

  /// Configuration for Json data.
  ///
  /// Optional.
  GoogleCloudDataplexV1ZoneDiscoverySpecJsonOptions? jsonOptions;

  /// Cron schedule (https://en.wikipedia.org/wiki/Cron) for running discovery
  /// periodically.
  ///
  /// Successive discovery runs must be scheduled at least 60 minutes apart. The
  /// default value is to run discovery every 60 minutes. To explicitly set a
  /// timezone to the cron tab, apply a prefix in the cron tab:
  /// "CRON_TZ=${IANA_TIME_ZONE}" or TZ=${IANA_TIME_ZONE}". The
  /// ${IANA_TIME_ZONE} may only be a valid string from IANA time zone database.
  /// For example, CRON_TZ=America/New_York 1 * * * *, or TZ=America/New_York 1
  /// * * * *.
  ///
  /// Optional.
  core.String? schedule;

  GoogleCloudDataplexV1ZoneDiscoverySpec({
    this.csvOptions,
    this.enabled,
    this.excludePatterns,
    this.includePatterns,
    this.jsonOptions,
    this.schedule,
  });

  GoogleCloudDataplexV1ZoneDiscoverySpec.fromJson(core.Map json_)
      : this(
          csvOptions: json_.containsKey('csvOptions')
              ? GoogleCloudDataplexV1ZoneDiscoverySpecCsvOptions.fromJson(
                  json_['csvOptions'] as core.Map<core.String, core.dynamic>)
              : null,
          enabled: json_['enabled'] as core.bool?,
          excludePatterns: (json_['excludePatterns'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
          includePatterns: (json_['includePatterns'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
          jsonOptions: json_.containsKey('jsonOptions')
              ? GoogleCloudDataplexV1ZoneDiscoverySpecJsonOptions.fromJson(
                  json_['jsonOptions'] as core.Map<core.String, core.dynamic>)
              : null,
          schedule: json_['schedule'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (csvOptions != null) 'csvOptions': csvOptions!,
        if (enabled != null) 'enabled': enabled!,
        if (excludePatterns != null) 'excludePatterns': excludePatterns!,
        if (includePatterns != null) 'includePatterns': includePatterns!,
        if (jsonOptions != null) 'jsonOptions': jsonOptions!,
        if (schedule != null) 'schedule': schedule!,
      };
}

/// Describe CSV and similar semi-structured data formats.
typedef GoogleCloudDataplexV1ZoneDiscoverySpecCsvOptions
    = $DiscoverySpecCsvOptions;

/// Describe JSON data format.
typedef GoogleCloudDataplexV1ZoneDiscoverySpecJsonOptions
    = $DiscoverySpecJsonOptions;

/// Settings for resources attached as assets within a zone.
class GoogleCloudDataplexV1ZoneResourceSpec {
  /// The location type of the resources that are allowed to be attached to the
  /// assets within this zone.
  ///
  /// Required. Immutable.
  /// Possible string values are:
  /// - "LOCATION_TYPE_UNSPECIFIED" : Unspecified location type.
  /// - "SINGLE_REGION" : Resources that are associated with a single region.
  /// - "MULTI_REGION" : Resources that are associated with a multi-region
  /// location.
  core.String? locationType;

  GoogleCloudDataplexV1ZoneResourceSpec({
    this.locationType,
  });

  GoogleCloudDataplexV1ZoneResourceSpec.fromJson(core.Map json_)
      : this(
          locationType: json_['locationType'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (locationType != null) 'locationType': locationType!,
      };
}

/// The response message for Locations.ListLocations.
class GoogleCloudLocationListLocationsResponse {
  /// A list of locations that matches the specified filter in the request.
  core.List<GoogleCloudLocationLocation>? locations;

  /// The standard List next-page token.
  core.String? nextPageToken;

  GoogleCloudLocationListLocationsResponse({
    this.locations,
    this.nextPageToken,
  });

  GoogleCloudLocationListLocationsResponse.fromJson(core.Map json_)
      : this(
          locations: (json_['locations'] as core.List?)
              ?.map((value) => GoogleCloudLocationLocation.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
          nextPageToken: json_['nextPageToken'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (locations != null) 'locations': locations!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
      };
}

/// A resource that represents a Google Cloud location.
typedef GoogleCloudLocationLocation = $Location01;

/// Specifies the audit configuration for a service.
///
/// The configuration determines which permission types are logged, and what
/// identities, if any, are exempted from logging. An AuditConfig must have one
/// or more AuditLogConfigs.If there are AuditConfigs for both allServices and a
/// specific service, the union of the two AuditConfigs is used for that
/// service: the log_types specified in each AuditConfig are enabled, and the
/// exempted_members in each AuditLogConfig are exempted.Example Policy with
/// multiple AuditConfigs: { "audit_configs": \[ { "service": "allServices",
/// "audit_log_configs": \[ { "log_type": "DATA_READ", "exempted_members": \[
/// "user:jose@example.com" \] }, { "log_type": "DATA_WRITE" }, { "log_type":
/// "ADMIN_READ" } \] }, { "service": "sampleservice.googleapis.com",
/// "audit_log_configs": \[ { "log_type": "DATA_READ" }, { "log_type":
/// "DATA_WRITE", "exempted_members": \[ "user:aliya@example.com" \] } \] } \] }
/// For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
/// logging. It also exempts jose@example.com from DATA_READ logging, and
/// aliya@example.com from DATA_WRITE logging.
class GoogleIamV1AuditConfig {
  /// The configuration for logging of each type of permission.
  core.List<GoogleIamV1AuditLogConfig>? auditLogConfigs;

  /// Specifies a service that will be enabled for audit logging.
  ///
  /// For example, storage.googleapis.com, cloudsql.googleapis.com. allServices
  /// is a special value that covers all services.
  core.String? service;

  GoogleIamV1AuditConfig({
    this.auditLogConfigs,
    this.service,
  });

  GoogleIamV1AuditConfig.fromJson(core.Map json_)
      : this(
          auditLogConfigs: (json_['auditLogConfigs'] as core.List?)
              ?.map((value) => GoogleIamV1AuditLogConfig.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
          service: json_['service'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (auditLogConfigs != null) 'auditLogConfigs': auditLogConfigs!,
        if (service != null) 'service': service!,
      };
}

/// Provides the configuration for logging a type of permissions.
///
/// Example: { "audit_log_configs": \[ { "log_type": "DATA_READ",
/// "exempted_members": \[ "user:jose@example.com" \] }, { "log_type":
/// "DATA_WRITE" } \] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while
/// exempting jose@example.com from DATA_READ logging.
typedef GoogleIamV1AuditLogConfig = $AuditLogConfig;

/// Associates members, or principals, with a role.
class GoogleIamV1Binding {
  /// The condition that is associated with this binding.If the condition
  /// evaluates to true, then this binding applies to the current request.If the
  /// condition evaluates to false, then this binding does not apply to the
  /// current request.
  ///
  /// However, a different role binding might grant the same role to one or more
  /// of the principals in this binding.To learn which resources support
  /// conditions in their IAM policies, see the IAM documentation
  /// (https://cloud.google.com/iam/help/conditions/resource-policies).
  GoogleTypeExpr? condition;

  /// Specifies the principals requesting access for a Google Cloud resource.
  ///
  /// members can have the following values: allUsers: A special identifier that
  /// represents anyone who is on the internet; with or without a Google
  /// account. allAuthenticatedUsers: A special identifier that represents
  /// anyone who is authenticated with a Google account or a service account.
  /// Does not include identities that come from external identity providers
  /// (IdPs) through identity federation. user:{emailid}: An email address that
  /// represents a specific Google account. For example, alice@example.com .
  /// serviceAccount:{emailid}: An email address that represents a Google
  /// service account. For example, my-other-app@appspot.gserviceaccount.com.
  /// serviceAccount:{projectid}.svc.id.goog\[{namespace}/{kubernetes-sa}\]: An
  /// identifier for a Kubernetes service account
  /// (https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts).
  /// For example, my-project.svc.id.goog\[my-namespace/my-kubernetes-sa\].
  /// group:{emailid}: An email address that represents a Google group. For
  /// example, admins@example.com. domain:{domain}: The G Suite domain (primary)
  /// that represents all the users of that domain. For example, google.com or
  /// example.com.
  /// principal://iam.googleapis.com/locations/global/workforcePools/{pool_id}/subject/{subject_attribute_value}:
  /// A single identity in a workforce identity pool.
  /// principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/group/{group_id}:
  /// All workforce identities in a group.
  /// principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/attribute.{attribute_name}/{attribute_value}:
  /// All workforce identities with a specific attribute value.
  /// principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}
  /// / * : All identities in a workforce identity pool.
  /// principal://iam.googleapis.com/projects/{project_number}/locations/global/workloadIdentityPools/{pool_id}/subject/{subject_attribute_value}:
  /// A single identity in a workload identity pool.
  /// principalSet://iam.googleapis.com/projects/{project_number}/locations/global/workloadIdentityPools/{pool_id}/group/{group_id}:
  /// A workload identity pool group.
  /// principalSet://iam.googleapis.com/projects/{project_number}/locations/global/workloadIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}:
  /// All identities in a workload identity pool with a certain attribute.
  /// principalSet://iam.googleapis.com/projects/{project_number}/locations/global/workloadIdentityPools/{pool_id}
  /// / * : All identities in a workload identity pool.
  /// deleted:user:{emailid}?uid={uniqueid}: An email address (plus unique
  /// identifier) representing a user that has been recently deleted. For
  /// example, alice@example.com?uid=123456789012345678901. If the user is
  /// recovered, this value reverts to user:{emailid} and the recovered user
  /// retains the role in the binding.
  /// deleted:serviceAccount:{emailid}?uid={uniqueid}: An email address (plus
  /// unique identifier) representing a service account that has been recently
  /// deleted. For example,
  /// my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901. If the
  /// service account is undeleted, this value reverts to
  /// serviceAccount:{emailid} and the undeleted service account retains the
  /// role in the binding. deleted:group:{emailid}?uid={uniqueid}: An email
  /// address (plus unique identifier) representing a Google group that has been
  /// recently deleted. For example,
  /// admins@example.com?uid=123456789012345678901. If the group is recovered,
  /// this value reverts to group:{emailid} and the recovered group retains the
  /// role in the binding.
  /// deleted:principal://iam.googleapis.com/locations/global/workforcePools/{pool_id}/subject/{subject_attribute_value}:
  /// Deleted single identity in a workforce identity pool. For example,
  /// deleted:principal://iam.googleapis.com/locations/global/workforcePools/my-pool-id/subject/my-subject-attribute-value.
  core.List<core.String>? members;

  /// Role that is assigned to the list of members, or principals.
  ///
  /// For example, roles/viewer, roles/editor, or roles/owner.For an overview of
  /// the IAM roles and permissions, see the IAM documentation
  /// (https://cloud.google.com/iam/docs/roles-overview). For a list of the
  /// available pre-defined roles, see here
  /// (https://cloud.google.com/iam/docs/understanding-roles).
  core.String? role;

  GoogleIamV1Binding({
    this.condition,
    this.members,
    this.role,
  });

  GoogleIamV1Binding.fromJson(core.Map json_)
      : this(
          condition: json_.containsKey('condition')
              ? GoogleTypeExpr.fromJson(
                  json_['condition'] as core.Map<core.String, core.dynamic>)
              : null,
          members: (json_['members'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
          role: json_['role'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (condition != null) 'condition': condition!,
        if (members != null) 'members': members!,
        if (role != null) 'role': role!,
      };
}

/// An Identity and Access Management (IAM) policy, which specifies access
/// controls for Google Cloud resources.A Policy is a collection of bindings.
///
/// A binding binds one or more members, or principals, to a single role.
/// Principals can be user accounts, service accounts, Google groups, and
/// domains (such as G Suite). A role is a named list of permissions; each role
/// can be an IAM predefined role or a user-created custom role.For some types
/// of Google Cloud resources, a binding can also specify a condition, which is
/// a logical expression that allows access to a resource only if the expression
/// evaluates to true. A condition can add constraints based on attributes of
/// the request, the resource, or both. To learn which resources support
/// conditions in their IAM policies, see the IAM documentation
/// (https://cloud.google.com/iam/help/conditions/resource-policies).JSON
/// example: { "bindings": \[ { "role":
/// "roles/resourcemanager.organizationAdmin", "members": \[
/// "user:mike@example.com", "group:admins@example.com", "domain:google.com",
/// "serviceAccount:my-project-id@appspot.gserviceaccount.com" \] }, { "role":
/// "roles/resourcemanager.organizationViewer", "members": \[
/// "user:eve@example.com" \], "condition": { "title": "expirable access",
/// "description": "Does not grant access after Sep 2020", "expression":
/// "request.time \< timestamp('2020-10-01T00:00:00.000Z')", } } \], "etag":
/// "BwWWja0YfJA=", "version": 3 } YAML example: bindings: - members: -
/// user:mike@example.com - group:admins@example.com - domain:google.com -
/// serviceAccount:my-project-id@appspot.gserviceaccount.com role:
/// roles/resourcemanager.organizationAdmin - members: - user:eve@example.com
/// role: roles/resourcemanager.organizationViewer condition: title: expirable
/// access description: Does not grant access after Sep 2020 expression:
/// request.time \< timestamp('2020-10-01T00:00:00.000Z') etag: BwWWja0YfJA=
/// version: 3 For a description of IAM and its features, see the IAM
/// documentation (https://cloud.google.com/iam/docs/).
class GoogleIamV1Policy {
  /// Specifies cloud audit logging configuration for this policy.
  core.List<GoogleIamV1AuditConfig>? auditConfigs;

  /// Associates a list of members, or principals, with a role.
  ///
  /// Optionally, may specify a condition that determines how and when the
  /// bindings are applied. Each of the bindings must contain at least one
  /// principal.The bindings in a Policy can refer to up to 1,500 principals; up
  /// to 250 of these principals can be Google groups. Each occurrence of a
  /// principal counts towards these limits. For example, if the bindings grant
  /// 50 different roles to user:alice@example.com, and not to any other
  /// principal, then you can add another 1,450 principals to the bindings in
  /// the Policy.
  core.List<GoogleIamV1Binding>? bindings;

  /// etag is used for optimistic concurrency control as a way to help prevent
  /// simultaneous updates of a policy from overwriting each other.
  ///
  /// It is strongly suggested that systems make use of the etag in the
  /// read-modify-write cycle to perform policy updates in order to avoid race
  /// conditions: An etag is returned in the response to getIamPolicy, and
  /// systems are expected to put that etag in the request to setIamPolicy to
  /// ensure that their change will be applied to the same version of the
  /// policy.Important: If you use IAM Conditions, you must include the etag
  /// field whenever you call setIamPolicy. If you omit this field, then IAM
  /// allows you to overwrite a version 3 policy with a version 1 policy, and
  /// all of the conditions in the version 3 policy are lost.
  core.String? etag;
  core.List<core.int> get etagAsBytes => convert.base64.decode(etag!);

  set etagAsBytes(core.List<core.int> bytes_) {
    etag =
        convert.base64.encode(bytes_).replaceAll('/', '_').replaceAll('+', '-');
  }

  /// Specifies the format of the policy.Valid values are 0, 1, and 3.
  ///
  /// Requests that specify an invalid value are rejected.Any operation that
  /// affects conditional role bindings must specify version 3. This requirement
  /// applies to the following operations: Getting a policy that includes a
  /// conditional role binding Adding a conditional role binding to a policy
  /// Changing a conditional role binding in a policy Removing any role binding,
  /// with or without a condition, from a policy that includes
  /// conditionsImportant: If you use IAM Conditions, you must include the etag
  /// field whenever you call setIamPolicy. If you omit this field, then IAM
  /// allows you to overwrite a version 3 policy with a version 1 policy, and
  /// all of the conditions in the version 3 policy are lost.If a policy does
  /// not include any conditions, operations on that policy may specify any
  /// valid version or leave the field unset.To learn which resources support
  /// conditions in their IAM policies, see the IAM documentation
  /// (https://cloud.google.com/iam/help/conditions/resource-policies).
  core.int? version;

  GoogleIamV1Policy({
    this.auditConfigs,
    this.bindings,
    this.etag,
    this.version,
  });

  GoogleIamV1Policy.fromJson(core.Map json_)
      : this(
          auditConfigs: (json_['auditConfigs'] as core.List?)
              ?.map((value) => GoogleIamV1AuditConfig.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
          bindings: (json_['bindings'] as core.List?)
              ?.map((value) => GoogleIamV1Binding.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
          etag: json_['etag'] as core.String?,
          version: json_['version'] as core.int?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (auditConfigs != null) 'auditConfigs': auditConfigs!,
        if (bindings != null) 'bindings': bindings!,
        if (etag != null) 'etag': etag!,
        if (version != null) 'version': version!,
      };
}

/// Request message for SetIamPolicy method.
class GoogleIamV1SetIamPolicyRequest {
  /// REQUIRED: The complete policy to be applied to the resource.
  ///
  /// The size of the policy is limited to a few 10s of KB. An empty policy is a
  /// valid policy but certain Google Cloud services (such as Projects) might
  /// reject them.
  GoogleIamV1Policy? policy;

  /// OPTIONAL: A FieldMask specifying which fields of the policy to modify.
  ///
  /// Only the fields in the mask will be modified. If no mask is provided, the
  /// following default mask is used:paths: "bindings, etag"
  core.String? updateMask;

  GoogleIamV1SetIamPolicyRequest({
    this.policy,
    this.updateMask,
  });

  GoogleIamV1SetIamPolicyRequest.fromJson(core.Map json_)
      : this(
          policy: json_.containsKey('policy')
              ? GoogleIamV1Policy.fromJson(
                  json_['policy'] as core.Map<core.String, core.dynamic>)
              : null,
          updateMask: json_['updateMask'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (policy != null) 'policy': policy!,
        if (updateMask != null) 'updateMask': updateMask!,
      };
}

/// Request message for TestIamPermissions method.
typedef GoogleIamV1TestIamPermissionsRequest = $TestIamPermissionsRequest01;

/// Response message for TestIamPermissions method.
typedef GoogleIamV1TestIamPermissionsResponse = $TestIamPermissionsResponse;

/// The request message for Operations.CancelOperation.
typedef GoogleLongrunningCancelOperationRequest = $Empty;

/// The response message for Operations.ListOperations.
class GoogleLongrunningListOperationsResponse {
  /// The standard List next-page token.
  core.String? nextPageToken;

  /// A list of operations that matches the specified filter in the request.
  core.List<GoogleLongrunningOperation>? operations;

  GoogleLongrunningListOperationsResponse({
    this.nextPageToken,
    this.operations,
  });

  GoogleLongrunningListOperationsResponse.fromJson(core.Map json_)
      : this(
          nextPageToken: json_['nextPageToken'] as core.String?,
          operations: (json_['operations'] as core.List?)
              ?.map((value) => GoogleLongrunningOperation.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (operations != null) 'operations': operations!,
      };
}

/// This resource represents a long-running operation that is the result of a
/// network API call.
class GoogleLongrunningOperation {
  /// If the value is false, it means the operation is still in progress.
  ///
  /// If true, the operation is completed, and either error or response is
  /// available.
  core.bool? done;

  /// The error result of the operation in case of failure or cancellation.
  GoogleRpcStatus? error;

  /// Service-specific metadata associated with the operation.
  ///
  /// It typically contains progress information and common metadata such as
  /// create time. Some services might not provide such metadata. Any method
  /// that returns a long-running operation should document the metadata type,
  /// if any.
  ///
  /// The values for Object must be JSON objects. It can consist of `num`,
  /// `String`, `bool` and `null` as well as `Map` and `List` values.
  core.Map<core.String, core.Object?>? metadata;

  /// The server-assigned name, which is only unique within the same service
  /// that originally returns it.
  ///
  /// If you use the default HTTP mapping, the name should be a resource name
  /// ending with operations/{unique_id}.
  core.String? name;

  /// The normal, successful response of the operation.
  ///
  /// If the original method returns no data on success, such as Delete, the
  /// response is google.protobuf.Empty. If the original method is standard
  /// Get/Create/Update, the response should be the resource. For other methods,
  /// the response should have the type XxxResponse, where Xxx is the original
  /// method name. For example, if the original method name is TakeSnapshot(),
  /// the inferred response type is TakeSnapshotResponse.
  ///
  /// The values for Object must be JSON objects. It can consist of `num`,
  /// `String`, `bool` and `null` as well as `Map` and `List` values.
  core.Map<core.String, core.Object?>? response;

  GoogleLongrunningOperation({
    this.done,
    this.error,
    this.metadata,
    this.name,
    this.response,
  });

  GoogleLongrunningOperation.fromJson(core.Map json_)
      : this(
          done: json_['done'] as core.bool?,
          error: json_.containsKey('error')
              ? GoogleRpcStatus.fromJson(
                  json_['error'] as core.Map<core.String, core.dynamic>)
              : null,
          metadata: json_.containsKey('metadata')
              ? json_['metadata'] as core.Map<core.String, core.dynamic>
              : null,
          name: json_['name'] as core.String?,
          response: json_.containsKey('response')
              ? json_['response'] as core.Map<core.String, core.dynamic>
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (done != null) 'done': done!,
        if (error != null) 'error': error!,
        if (metadata != null) 'metadata': metadata!,
        if (name != null) 'name': name!,
        if (response != null) 'response': response!,
      };
}

/// The Status type defines a logical error model that is suitable for different
/// programming environments, including REST APIs and RPC APIs.
///
/// It is used by gRPC (https://github.com/grpc). Each Status message contains
/// three pieces of data: error code, error message, and error details.You can
/// find out more about this error model and how to work with it in the API
/// Design Guide (https://cloud.google.com/apis/design/errors).
typedef GoogleRpcStatus = $Status00;

/// Represents a textual expression in the Common Expression Language (CEL)
/// syntax.
///
/// CEL is a C-like expression language. The syntax and semantics of CEL are
/// documented at https://github.com/google/cel-spec.Example (Comparison):
/// title: "Summary size limit" description: "Determines if a summary is less
/// than 100 chars" expression: "document.summary.size() \< 100" Example
/// (Equality): title: "Requestor is owner" description: "Determines if
/// requestor is the document owner" expression: "document.owner ==
/// request.auth.claims.email" Example (Logic): title: "Public documents"
/// description: "Determine whether the document should be publicly visible"
/// expression: "document.type != 'private' && document.type != 'internal'"
/// Example (Data Manipulation): title: "Notification string" description:
/// "Create a notification string with a timestamp." expression: "'New message
/// received at ' + string(document.create_time)" The exact variables and
/// functions that may be referenced within an expression are determined by the
/// service that evaluates it. See the service documentation for additional
/// information.
typedef GoogleTypeExpr = $Expr;
