// This is a generated file (see the discoveryapis_generator project).

// ignore_for_file: camel_case_types
// ignore_for_file: comment_references
// ignore_for_file: deprecated_member_use_from_same_package
// ignore_for_file: doc_directive_unknown
// ignore_for_file: lines_longer_than_80_chars
// ignore_for_file: non_constant_identifier_names
// ignore_for_file: prefer_interpolation_to_compose_strings
// ignore_for_file: unintended_html_in_doc_comment
// ignore_for_file: unnecessary_brace_in_string_interps
// ignore_for_file: unnecessary_lambdas
// ignore_for_file: unnecessary_string_interpolations

/// Cloud Data Fusion API - v1
///
/// Cloud Data Fusion is a fully-managed, cloud native, enterprise data
/// integration service for quickly building and managing data pipelines. It
/// provides a graphical interface to increase time efficiency and reduce
/// complexity, and allows business users, developers, and data scientists to
/// easily and reliably build scalable data integration solutions to cleanse,
/// prepare, blend, transfer and transform data without having to wrestle with
/// infrastructure.
///
/// For more information, see <https://cloud.google.com/data-fusion/docs>
///
/// Create an instance of [DataFusionApi] to access these resources:
///
/// - [ProjectsResource]
///   - [ProjectsLocationsResource]
///     - [ProjectsLocationsInstancesResource]
///       - [ProjectsLocationsInstancesDnsPeeringsResource]
///     - [ProjectsLocationsOperationsResource]
///     - [ProjectsLocationsVersionsResource]
library;

import 'dart:async' as async;
import 'dart:convert' as convert;
import 'dart:core' as core;

import 'package:_discoveryapis_commons/_discoveryapis_commons.dart' as commons;
import 'package:http/http.dart' as http;

import '../shared.dart';
import '../src/user_agent.dart';

export 'package:_discoveryapis_commons/_discoveryapis_commons.dart'
    show ApiRequestError, DetailedApiRequestError;

/// Cloud Data Fusion is a fully-managed, cloud native, enterprise data
/// integration service for quickly building and managing data pipelines.
///
/// It provides a graphical interface to increase time efficiency and reduce
/// complexity, and allows business users, developers, and data scientists to
/// easily and reliably build scalable data integration solutions to cleanse,
/// prepare, blend, transfer and transform data without having to wrestle with
/// infrastructure.
class DataFusionApi {
  /// See, edit, configure, and delete your Google Cloud data and see the email
  /// address for your Google Account.
  static const cloudPlatformScope =
      'https://www.googleapis.com/auth/cloud-platform';

  final commons.ApiRequester _requester;

  ProjectsResource get projects => ProjectsResource(_requester);

  DataFusionApi(http.Client client,
      {core.String rootUrl = 'https://datafusion.googleapis.com/',
      core.String servicePath = ''})
      : _requester =
            commons.ApiRequester(client, rootUrl, servicePath, requestHeaders);
}

class ProjectsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsResource get locations =>
      ProjectsLocationsResource(_requester);

  ProjectsResource(commons.ApiRequester client) : _requester = client;
}

class ProjectsLocationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsInstancesResource get instances =>
      ProjectsLocationsInstancesResource(_requester);
  ProjectsLocationsOperationsResource get operations =>
      ProjectsLocationsOperationsResource(_requester);
  ProjectsLocationsVersionsResource get versions =>
      ProjectsLocationsVersionsResource(_requester);

  ProjectsLocationsResource(commons.ApiRequester client) : _requester = client;

  /// Gets information about a location.
  ///
  /// Request parameters:
  ///
  /// [name] - Resource name for the location.
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Location].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Location> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Location.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists information about the supported locations for this service.
  ///
  /// Request parameters:
  ///
  /// [name] - The resource that owns the locations collection, if applicable.
  /// Value must have pattern `^projects/\[^/\]+$`.
  ///
  /// [filter] - A filter to narrow down results to a preferred subset. The
  /// filtering language accepts strings like `"displayName=tokyo"`, and is
  /// documented in more detail in \[AIP-160\](https://google.aip.dev/160).
  ///
  /// [pageSize] - The maximum number of results to return. If not set, the
  /// service selects a default.
  ///
  /// [pageToken] - A page token received from the `next_page_token` field in
  /// the response. Send that page token to receive the subsequent page.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ListLocationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ListLocationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/locations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ListLocationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsInstancesResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsInstancesDnsPeeringsResource get dnsPeerings =>
      ProjectsLocationsInstancesDnsPeeringsResource(_requester);

  ProjectsLocationsInstancesResource(commons.ApiRequester client)
      : _requester = client;

  /// Creates a new Data Fusion instance in the specified project and location.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The instance's project and location in the format
  /// projects/{project}/locations/{location}.
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [instanceId] - Required. The name of the instance to create. Instance name
  /// can only contain lowercase alphanumeric characters and hyphens. It must
  /// start with a letter and must not end with a hyphen. It can have a maximum
  /// of 30 characters.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> create(
    Instance request,
    core.String parent, {
    core.String? instanceId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (instanceId != null) 'instanceId': [instanceId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/instances';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a single Date Fusion instance.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The instance resource name in the format
  /// projects/{project}/locations/{location}/instances/{instance}
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/instances/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets details of a single Data Fusion instance.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The instance resource name in the format
  /// projects/{project}/locations/{location}/instances/{instance}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/instances/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Instance].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Instance> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Instance.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the access control policy for a resource.
  ///
  /// Returns an empty policy if the resource exists and does not have a policy
  /// set.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// requested. See
  /// [Resource names](https://cloud.google.com/apis/design/resource_names) for
  /// the appropriate value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/instances/\[^/\]+$`.
  ///
  /// [options_requestedPolicyVersion] - Optional. The maximum policy version
  /// that will be used to format the policy. Valid values are 0, 1, and 3.
  /// Requests specifying an invalid value will be rejected. Requests for
  /// policies with any conditional role bindings must specify version 3.
  /// Policies with no conditional role bindings may specify any valid value or
  /// leave the field unset. The policy in the response might use the policy
  /// version that you specified, or it might use a lower policy version. For
  /// example, if you specify version 3, but the policy has no conditional role
  /// bindings, the response uses version 1. To learn which resources support
  /// conditions in their IAM policies, see the
  /// [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> getIamPolicy(
    core.String resource, {
    core.int? options_requestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (options_requestedPolicyVersion != null)
        'options.requestedPolicyVersion': ['${options_requestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Policy.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists Data Fusion instances in the specified project and location.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The project and location for which to retrieve
  /// instance information in the format
  /// projects/{project}/locations/{location}. If the location is specified as
  /// '-' (wildcard), then all regions available to the project are queried, and
  /// the results are aggregated.
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [filter] - List filter.
  ///
  /// [orderBy] - Sort results. Supported values are "name", "name desc", or ""
  /// (unsorted).
  ///
  /// [pageSize] - The maximum number of items to return.
  ///
  /// [pageToken] - The next_page_token value to use if there are additional
  /// results to retrieve for this list request.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ListInstancesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ListInstancesResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/instances';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ListInstancesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates a single Data Fusion instance.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Output only. The name of this instance is in the form of
  /// projects/{project}/locations/{location}/instances/{instance}.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/instances/\[^/\]+$`.
  ///
  /// [updateMask] - Field mask is used to specify the fields that the update
  /// will overwrite in an instance resource. The fields specified in the
  /// update_mask are relative to the resource, not the full request. A field
  /// will be overwritten if it is in the mask. If the user does not provide a
  /// mask, the label field will be overwritten.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> patch(
    Instance request,
    core.String name, {
    core.String? updateMask,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Restart a single Data Fusion instance.
  ///
  /// At the end of an operation instance is fully restarted.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. Name of the Data Fusion instance which need to be
  /// restarted in the form of
  /// projects/{project}/locations/{location}/instances/{instance}
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/instances/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> restart(
    RestartInstanceRequest request,
    core.String name, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':restart';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified resource.
  ///
  /// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
  /// and `PERMISSION_DENIED` errors.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// specified. See
  /// [Resource names](https://cloud.google.com/apis/design/resource_names) for
  /// the appropriate value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/instances/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> setIamPolicy(
    SetIamPolicyRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Policy.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// If the resource does not exist, this will return an empty set of
  /// permissions, not a `NOT_FOUND` error. Note: This operation is designed to
  /// be used for building permission-aware UIs and command-line tools, not for
  /// authorization checking. This operation may "fail open" without warning.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy detail is being
  /// requested. See
  /// [Resource names](https://cloud.google.com/apis/design/resource_names) for
  /// the appropriate value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/instances/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [TestIamPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<TestIamPermissionsResponse> testIamPermissions(
    TestIamPermissionsRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$resource') + ':testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return TestIamPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsInstancesDnsPeeringsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsInstancesDnsPeeringsResource(commons.ApiRequester client)
      : _requester = client;

  /// Creates DNS peering on the given resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource on which DNS peering will be created.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/instances/\[^/\]+$`.
  ///
  /// [dnsPeeringId] - Required. The name of the peering to create.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [DnsPeering].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<DnsPeering> create(
    DnsPeering request,
    core.String parent, {
    core.String? dnsPeeringId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (dnsPeeringId != null) 'dnsPeeringId': [dnsPeeringId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/dnsPeerings';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return DnsPeering.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes DNS peering on the given resource.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the DNS peering zone to delete. Format:
  /// projects/{project}/locations/{location}/instances/{instance}/dnsPeerings/{dns_peering}
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/instances/\[^/\]+/dnsPeerings/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Empty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Empty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Empty.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists DNS peerings for a given resource.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The parent, which owns this collection of dns
  /// peerings. Format:
  /// projects/{project}/locations/{location}/instances/{instance}
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/instances/\[^/\]+$`.
  ///
  /// [pageSize] - The maximum number of dns peerings to return. The service may
  /// return fewer than this value. If unspecified, at most 50 dns peerings will
  /// be returned. The maximum value is 200; values above 200 will be coerced to
  /// 200.
  ///
  /// [pageToken] - A page token, received from a previous `ListDnsPeerings`
  /// call. Provide this to retrieve the subsequent page. When paginating, all
  /// other parameters provided to `ListDnsPeerings` must match the call that
  /// provided the page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ListDnsPeeringsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ListDnsPeeringsResponse> list(
    core.String parent, {
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/dnsPeerings';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ListDnsPeeringsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsOperationsResource(commons.ApiRequester client)
      : _requester = client;

  /// Starts asynchronous cancellation on a long-running operation.
  ///
  /// The server makes a best effort to cancel the operation, but success is not
  /// guaranteed. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation
  /// or other methods to check whether the cancellation succeeded or whether
  /// the operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with an
  /// Operation.error value with a google.rpc.Status.code of `1`, corresponding
  /// to `Code.CANCELLED`.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be cancelled.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Empty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Empty> cancel(
    CancelOperationRequest request,
    core.String name, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Empty.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Empty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Empty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Empty.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ListOperationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsVersionsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsVersionsResource(commons.ApiRequester client)
      : _requester = client;

  /// Lists possible versions for Data Fusion instances in the specified project
  /// and location.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The project and location for which to retrieve
  /// instance information in the format
  /// projects/{project}/locations/{location}.
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [latestPatchOnly] - Whether or not to return the latest patch of every
  /// available minor version. If true, only the latest patch will be returned.
  /// Ex. if allowed versions is \[6.1.1, 6.1.2, 6.2.0\] then response will be
  /// \[6.1.2, 6.2.0\]
  ///
  /// [pageSize] - The maximum number of items to return.
  ///
  /// [pageToken] - The next_page_token value to use if there are additional
  /// results to retrieve for this list request.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ListAvailableVersionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ListAvailableVersionsResponse> list(
    core.String parent, {
    core.bool? latestPatchOnly,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (latestPatchOnly != null) 'latestPatchOnly': ['${latestPatchOnly}'],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/versions';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ListAvailableVersionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

/// Identifies Data Fusion accelerators for an instance.
class Accelerator {
  /// The type of an accelator for a Cloud Data Fusion instance.
  ///
  /// Optional.
  /// Possible string values are:
  /// - "ACCELERATOR_TYPE_UNSPECIFIED" : Default value, if unspecified.
  /// - "CDC" : Change Data Capture accelerator for Cloud Data Fusion.
  /// - "HEALTHCARE" : Reserved for internal use.
  /// - "CCAI_INSIGHTS" : Contact Center AI Insights This accelerator is used to
  /// enable import and export pipelines custom built to streamline CCAI
  /// Insights processing.
  /// - "CLOUDSEARCH" : Reserved for internal use.
  core.String? acceleratorType;

  /// The state of the accelerator.
  ///
  /// Output only.
  /// Possible string values are:
  /// - "STATE_UNSPECIFIED" : Default value, do not use.
  /// - "ENABLED" : Indicates that the accelerator is enabled and available to
  /// use.
  /// - "DISABLED" : Indicates that the accelerator is disabled and not
  /// available to use.
  /// - "UNKNOWN" : Indicates that accelerator state is currently unknown.
  /// Requests for enable, disable could be retried while in this state.
  core.String? state;

  Accelerator({
    this.acceleratorType,
    this.state,
  });

  Accelerator.fromJson(core.Map json_)
      : this(
          acceleratorType: json_['acceleratorType'] as core.String?,
          state: json_['state'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (acceleratorType != null) 'acceleratorType': acceleratorType!,
        if (state != null) 'state': state!,
      };
}

/// Specifies the audit configuration for a service.
///
/// The configuration determines which permission types are logged, and what
/// identities, if any, are exempted from logging. An AuditConfig must have one
/// or more AuditLogConfigs. If there are AuditConfigs for both `allServices`
/// and a specific service, the union of the two AuditConfigs is used for that
/// service: the log_types specified in each AuditConfig are enabled, and the
/// exempted_members in each AuditLogConfig are exempted. Example Policy with
/// multiple AuditConfigs: { "audit_configs": \[ { "service": "allServices",
/// "audit_log_configs": \[ { "log_type": "DATA_READ", "exempted_members": \[
/// "user:jose@example.com" \] }, { "log_type": "DATA_WRITE" }, { "log_type":
/// "ADMIN_READ" } \] }, { "service": "sampleservice.googleapis.com",
/// "audit_log_configs": \[ { "log_type": "DATA_READ" }, { "log_type":
/// "DATA_WRITE", "exempted_members": \[ "user:aliya@example.com" \] } \] } \] }
/// For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
/// logging. It also exempts `jose@example.com` from DATA_READ logging, and
/// `aliya@example.com` from DATA_WRITE logging.
class AuditConfig {
  /// The configuration for logging of each type of permission.
  core.List<AuditLogConfig>? auditLogConfigs;

  /// Specifies a service that will be enabled for audit logging.
  ///
  /// For example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
  /// `allServices` is a special value that covers all services.
  core.String? service;

  AuditConfig({
    this.auditLogConfigs,
    this.service,
  });

  AuditConfig.fromJson(core.Map json_)
      : this(
          auditLogConfigs: (json_['auditLogConfigs'] as core.List?)
              ?.map((value) => AuditLogConfig.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
          service: json_['service'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (auditLogConfigs != null) 'auditLogConfigs': auditLogConfigs!,
        if (service != null) 'service': service!,
      };
}

/// Provides the configuration for logging a type of permissions.
///
/// Example: { "audit_log_configs": \[ { "log_type": "DATA_READ",
/// "exempted_members": \[ "user:jose@example.com" \] }, { "log_type":
/// "DATA_WRITE" } \] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while
/// exempting jose@example.com from DATA_READ logging.
typedef AuditLogConfig = $AuditLogConfig;

/// Associates `members`, or principals, with a `role`.
class Binding {
  /// The condition that is associated with this binding.
  ///
  /// If the condition evaluates to `true`, then this binding applies to the
  /// current request. If the condition evaluates to `false`, then this binding
  /// does not apply to the current request. However, a different role binding
  /// might grant the same role to one or more of the principals in this
  /// binding. To learn which resources support conditions in their IAM
  /// policies, see the
  /// [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
  Expr? condition;

  /// Specifies the principals requesting access for a Google Cloud resource.
  ///
  /// `members` can have the following values: * `allUsers`: A special
  /// identifier that represents anyone who is on the internet; with or without
  /// a Google account. * `allAuthenticatedUsers`: A special identifier that
  /// represents anyone who is authenticated with a Google account or a service
  /// account. Does not include identities that come from external identity
  /// providers (IdPs) through identity federation. * `user:{emailid}`: An email
  /// address that represents a specific Google account. For example,
  /// `alice@example.com` . * `serviceAccount:{emailid}`: An email address that
  /// represents a Google service account. For example,
  /// `my-other-app@appspot.gserviceaccount.com`. *
  /// `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An
  /// identifier for a
  /// [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts).
  /// For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
  /// `group:{emailid}`: An email address that represents a Google group. For
  /// example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
  /// (primary) that represents all the users of that domain. For example,
  /// `google.com` or `example.com`. *
  /// `principal://iam.googleapis.com/locations/global/workforcePools/{pool_id}/subject/{subject_attribute_value}`:
  /// A single identity in a workforce identity pool. *
  /// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/group/{group_id}`:
  /// All workforce identities in a group. *
  /// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/attribute.{attribute_name}/{attribute_value}`:
  /// All workforce identities with a specific attribute value. *
  /// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}
  /// / * `: All identities in a workforce identity pool. *
  /// `principal://iam.googleapis.com/projects/{project_number}/locations/global/workloadIdentityPools/{pool_id}/subject/{subject_attribute_value}`:
  /// A single identity in a workload identity pool. *
  /// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global/workloadIdentityPools/{pool_id}/group/{group_id}`:
  /// A workload identity pool group. *
  /// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global/workloadIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}`:
  /// All identities in a workload identity pool with a certain attribute. *
  /// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global/workloadIdentityPools/{pool_id}
  /// / * `: All identities in a workload identity pool. *
  /// `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
  /// identifier) representing a user that has been recently deleted. For
  /// example, `alice@example.com?uid=123456789012345678901`. If the user is
  /// recovered, this value reverts to `user:{emailid}` and the recovered user
  /// retains the role in the binding. *
  /// `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus
  /// unique identifier) representing a service account that has been recently
  /// deleted. For example,
  /// `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If
  /// the service account is undeleted, this value reverts to
  /// `serviceAccount:{emailid}` and the undeleted service account retains the
  /// role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email
  /// address (plus unique identifier) representing a Google group that has been
  /// recently deleted. For example,
  /// `admins@example.com?uid=123456789012345678901`. If the group is recovered,
  /// this value reverts to `group:{emailid}` and the recovered group retains
  /// the role in the binding. *
  /// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/{pool_id}/subject/{subject_attribute_value}`:
  /// Deleted single identity in a workforce identity pool. For example,
  /// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/my-pool-id/subject/my-subject-attribute-value`.
  core.List<core.String>? members;

  /// Role that is assigned to the list of `members`, or principals.
  ///
  /// For example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an
  /// overview of the IAM roles and permissions, see the
  /// [IAM documentation](https://cloud.google.com/iam/docs/roles-overview). For
  /// a list of the available pre-defined roles, see
  /// [here](https://cloud.google.com/iam/docs/understanding-roles).
  core.String? role;

  Binding({
    this.condition,
    this.members,
    this.role,
  });

  Binding.fromJson(core.Map json_)
      : this(
          condition: json_.containsKey('condition')
              ? Expr.fromJson(
                  json_['condition'] as core.Map<core.String, core.dynamic>)
              : null,
          members: (json_['members'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
          role: json_['role'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (condition != null) 'condition': condition!,
        if (members != null) 'members': members!,
        if (role != null) 'role': role!,
      };
}

/// The request message for Operations.CancelOperation.
typedef CancelOperationRequest = $Empty;

/// The crypto key configuration.
///
/// This field is used by the Customer-managed encryption keys (CMEK) feature.
class CryptoKeyConfig {
  /// The name of the key which is used to encrypt/decrypt customer data.
  ///
  /// For key in Cloud KMS, the key should be in the format of `projects / *
  /// /locations / * /keyRings / * /cryptoKeys / * `.
  ///
  /// Optional.
  core.String? keyReference;

  CryptoKeyConfig({
    this.keyReference,
  });

  CryptoKeyConfig.fromJson(core.Map json_)
      : this(
          keyReference: json_['keyReference'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (keyReference != null) 'keyReference': keyReference!,
      };
}

/// DNS peering configuration.
///
/// These configurations are used to create DNS peering with the customer Cloud
/// DNS.
class DnsPeering {
  /// Optional description of the dns zone.
  ///
  /// Optional.
  core.String? description;

  /// The dns name suffix of the zone.
  ///
  /// Required.
  core.String? domain;

  /// Identifier.
  ///
  /// The resource name of the dns peering zone. Format:
  /// projects/{project}/locations/{location}/instances/{instance}/dnsPeerings/{dns_peering}
  core.String? name;

  /// Optional target network to which dns peering should happen.
  ///
  /// Optional.
  core.String? targetNetwork;

  /// Optional target project to which dns peering should happen.
  ///
  /// Optional.
  core.String? targetProject;

  DnsPeering({
    this.description,
    this.domain,
    this.name,
    this.targetNetwork,
    this.targetProject,
  });

  DnsPeering.fromJson(core.Map json_)
      : this(
          description: json_['description'] as core.String?,
          domain: json_['domain'] as core.String?,
          name: json_['name'] as core.String?,
          targetNetwork: json_['targetNetwork'] as core.String?,
          targetProject: json_['targetProject'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (description != null) 'description': description!,
        if (domain != null) 'domain': domain!,
        if (name != null) 'name': name!,
        if (targetNetwork != null) 'targetNetwork': targetNetwork!,
        if (targetProject != null) 'targetProject': targetProject!,
      };
}

/// A generic empty message that you can re-use to avoid defining duplicated
/// empty messages in your APIs.
///
/// A typical example is to use it as the request or the response type of an API
/// method. For instance: service Foo { rpc Bar(google.protobuf.Empty) returns
/// (google.protobuf.Empty); }
typedef Empty = $Empty;

/// Confirguration of PubSubEventWriter.
class EventPublishConfig {
  /// Option to enable Event Publishing.
  ///
  /// Required.
  core.bool? enabled;

  /// The resource name of the Pub/Sub topic.
  ///
  /// Format: projects/{project_id}/topics/{topic_id}
  ///
  /// Required.
  core.String? topic;

  EventPublishConfig({
    this.enabled,
    this.topic,
  });

  EventPublishConfig.fromJson(core.Map json_)
      : this(
          enabled: json_['enabled'] as core.bool?,
          topic: json_['topic'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (enabled != null) 'enabled': enabled!,
        if (topic != null) 'topic': topic!,
      };
}

/// Represents a textual expression in the Common Expression Language (CEL)
/// syntax.
///
/// CEL is a C-like expression language. The syntax and semantics of CEL are
/// documented at https://github.com/google/cel-spec. Example (Comparison):
/// title: "Summary size limit" description: "Determines if a summary is less
/// than 100 chars" expression: "document.summary.size() \< 100" Example
/// (Equality): title: "Requestor is owner" description: "Determines if
/// requestor is the document owner" expression: "document.owner ==
/// request.auth.claims.email" Example (Logic): title: "Public documents"
/// description: "Determine whether the document should be publicly visible"
/// expression: "document.type != 'private' && document.type != 'internal'"
/// Example (Data Manipulation): title: "Notification string" description:
/// "Create a notification string with a timestamp." expression: "'New message
/// received at ' + string(document.create_time)" The exact variables and
/// functions that may be referenced within an expression are determined by the
/// service that evaluates it. See the service documentation for additional
/// information.
typedef Expr = $Expr;

/// Represents a Data Fusion instance.
class Instance {
  /// List of accelerators enabled for this CDF instance.
  ///
  /// Output only.
  core.List<Accelerator>? accelerators;

  /// Endpoint on which the REST APIs is accessible.
  ///
  /// Output only.
  core.String? apiEndpoint;

  /// Available versions that the instance can be upgraded to using
  /// UpdateInstanceRequest.
  ///
  /// Output only.
  core.List<Version>? availableVersion;

  /// The time the instance was created.
  ///
  /// Output only.
  core.String? createTime;

  /// The crypto key configuration.
  ///
  /// This field is used by the Customer-Managed Encryption Keys (CMEK) feature.
  ///
  /// Optional.
  CryptoKeyConfig? cryptoKeyConfig;

  /// Option to enable the Dataplex Lineage Integration feature.
  ///
  /// Optional.
  core.bool? dataplexDataLineageIntegrationEnabled;

  /// User-managed service account to set on Dataproc when Cloud Data Fusion
  /// creates Dataproc to run data processing pipelines.
  ///
  /// This allows users to have fine-grained access control on Dataproc's
  /// accesses to cloud resources.
  ///
  /// Optional.
  core.String? dataprocServiceAccount;

  /// A description of this instance.
  ///
  /// Optional.
  core.String? description;

  /// If the instance state is DISABLED, the reason for disabling the instance.
  ///
  /// Output only.
  core.List<core.String>? disabledReason;

  /// Display name for an instance.
  ///
  /// Optional.
  core.String? displayName;

  /// Option to enable granular role-based access control.
  ///
  /// Optional.
  core.bool? enableRbac;

  /// Option to enable Dataproc Stackdriver Logging.
  ///
  /// Optional.
  core.bool? enableStackdriverLogging;

  /// Option to enable Stackdriver Monitoring.
  ///
  /// Optional.
  core.bool? enableStackdriverMonitoring;

  /// Option to enable granular zone separation.
  ///
  /// Output only.
  core.bool? enableZoneSeparation;

  /// Option to enable and pass metadata for event publishing.
  ///
  /// Optional.
  EventPublishConfig? eventPublishConfig;

  /// Cloud Storage bucket generated by Data Fusion in the customer project.
  ///
  /// Output only.
  core.String? gcsBucket;

  /// The resource labels for instance to use to annotate any related underlying
  /// resources such as Compute Engine VMs.
  ///
  /// The character '=' is not allowed to be used within the labels.
  core.Map<core.String, core.String>? labels;

  /// The logging configuration for this instance.
  ///
  /// This field is supported only in CDF versions 6.11.0 and above.
  ///
  /// Optional.
  LoggingConfig? loggingConfig;

  /// The maintenance events for this instance.
  ///
  /// Output only.
  core.List<MaintenanceEvent>? maintenanceEvents;

  /// Configure the maintenance policy for this instance.
  ///
  /// Optional.
  MaintenancePolicy? maintenancePolicy;

  /// The name of this instance is in the form of
  /// projects/{project}/locations/{location}/instances/{instance}.
  ///
  /// Output only.
  core.String? name;

  /// Network configuration options.
  ///
  /// These are required when a private Data Fusion instance is to be created.
  ///
  /// Optional.
  NetworkConfig? networkConfig;

  /// Map of additional options used to configure the behavior of Data Fusion
  /// instance.
  ///
  /// Optional.
  core.Map<core.String, core.String>? options;

  /// Service agent for the customer project.
  ///
  /// Output only.
  core.String? p4ServiceAccount;

  /// Current patch revision of the Data Fusion.
  ///
  /// Optional.
  core.String? patchRevision;

  /// Specifies whether the Data Fusion instance should be private.
  ///
  /// If set to true, all Data Fusion nodes will have private IP addresses and
  /// will not be able to access the public internet.
  ///
  /// Optional.
  core.bool? privateInstance;

  /// Reserved for future use.
  ///
  /// Output only.
  core.bool? satisfiesPzi;

  /// Reserved for future use.
  ///
  /// Output only.
  core.bool? satisfiesPzs;

  /// Use tenant_project_id instead to extract the tenant project ID.
  ///
  /// Output only. Deprecated.
  @core.Deprecated(
    'Not supported. Member documentation may have more information.',
  )
  core.String? serviceAccount;

  /// Endpoint on which the Data Fusion UI is accessible.
  ///
  /// Output only.
  core.String? serviceEndpoint;

  /// The current state of this Data Fusion instance.
  ///
  /// Output only.
  /// Possible string values are:
  /// - "STATE_UNSPECIFIED" : Instance does not have a state yet
  /// - "CREATING" : Instance is being created
  /// - "ACTIVE" : Instance is active and ready for requests. This corresponds
  /// to 'RUNNING' in datafusion.v1beta1.
  /// - "FAILED" : Instance creation failed
  /// - "DELETING" : Instance is being deleted
  /// - "UPGRADING" : Instance is being upgraded
  /// - "RESTARTING" : Instance is being restarted
  /// - "UPDATING" : Instance is being updated on customer request
  /// - "AUTO_UPDATING" : Instance is being auto-updated
  /// - "AUTO_UPGRADING" : Instance is being auto-upgraded
  /// - "DISABLED" : Instance is disabled
  core.String? state;

  /// Additional information about the current state of this Data Fusion
  /// instance if available.
  ///
  /// Output only.
  core.String? stateMessage;

  /// The name of the tenant project.
  ///
  /// Output only.
  core.String? tenantProjectId;

  /// Instance type.
  ///
  /// Required.
  /// Possible string values are:
  /// - "TYPE_UNSPECIFIED" : No type specified. The instance creation will fail.
  /// - "BASIC" : Basic Data Fusion instance. In Basic type, the user will be
  /// able to create data pipelines using point and click UI. However, there are
  /// certain limitations, such as fewer number of concurrent pipelines, no
  /// support for streaming pipelines, etc.
  /// - "ENTERPRISE" : Enterprise Data Fusion instance. In Enterprise type, the
  /// user will have all features available, such as support for streaming
  /// pipelines, higher number of concurrent pipelines, etc.
  /// - "DEVELOPER" : Developer Data Fusion instance. In Developer type, the
  /// user will have all features available but with restrictive capabilities.
  /// This is to help enterprises design and develop their data ingestion and
  /// integration pipelines at low cost.
  core.String? type;

  /// The time the instance was last updated.
  ///
  /// Output only.
  core.String? updateTime;

  /// Current version of the Data Fusion.
  ///
  /// Only specifiable in Update.
  ///
  /// Optional.
  core.String? version;

  /// Endpoint on which the Data Fusion UI is accessible to third-party users
  ///
  /// Output only.
  core.String? workforceIdentityServiceEndpoint;

  /// Name of the zone in which the Data Fusion instance will be created.
  ///
  /// Only DEVELOPER instances use this field.
  ///
  /// Optional.
  core.String? zone;

  Instance({
    this.accelerators,
    this.apiEndpoint,
    this.availableVersion,
    this.createTime,
    this.cryptoKeyConfig,
    this.dataplexDataLineageIntegrationEnabled,
    this.dataprocServiceAccount,
    this.description,
    this.disabledReason,
    this.displayName,
    this.enableRbac,
    this.enableStackdriverLogging,
    this.enableStackdriverMonitoring,
    this.enableZoneSeparation,
    this.eventPublishConfig,
    this.gcsBucket,
    this.labels,
    this.loggingConfig,
    this.maintenanceEvents,
    this.maintenancePolicy,
    this.name,
    this.networkConfig,
    this.options,
    this.p4ServiceAccount,
    this.patchRevision,
    this.privateInstance,
    this.satisfiesPzi,
    this.satisfiesPzs,
    this.serviceAccount,
    this.serviceEndpoint,
    this.state,
    this.stateMessage,
    this.tenantProjectId,
    this.type,
    this.updateTime,
    this.version,
    this.workforceIdentityServiceEndpoint,
    this.zone,
  });

  Instance.fromJson(core.Map json_)
      : this(
          accelerators: (json_['accelerators'] as core.List?)
              ?.map((value) => Accelerator.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
          apiEndpoint: json_['apiEndpoint'] as core.String?,
          availableVersion: (json_['availableVersion'] as core.List?)
              ?.map((value) => Version.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
          createTime: json_['createTime'] as core.String?,
          cryptoKeyConfig: json_.containsKey('cryptoKeyConfig')
              ? CryptoKeyConfig.fromJson(json_['cryptoKeyConfig']
                  as core.Map<core.String, core.dynamic>)
              : null,
          dataplexDataLineageIntegrationEnabled:
              json_['dataplexDataLineageIntegrationEnabled'] as core.bool?,
          dataprocServiceAccount:
              json_['dataprocServiceAccount'] as core.String?,
          description: json_['description'] as core.String?,
          disabledReason: (json_['disabledReason'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
          displayName: json_['displayName'] as core.String?,
          enableRbac: json_['enableRbac'] as core.bool?,
          enableStackdriverLogging:
              json_['enableStackdriverLogging'] as core.bool?,
          enableStackdriverMonitoring:
              json_['enableStackdriverMonitoring'] as core.bool?,
          enableZoneSeparation: json_['enableZoneSeparation'] as core.bool?,
          eventPublishConfig: json_.containsKey('eventPublishConfig')
              ? EventPublishConfig.fromJson(json_['eventPublishConfig']
                  as core.Map<core.String, core.dynamic>)
              : null,
          gcsBucket: json_['gcsBucket'] as core.String?,
          labels:
              (json_['labels'] as core.Map<core.String, core.dynamic>?)?.map(
            (key, value) => core.MapEntry(
              key,
              value as core.String,
            ),
          ),
          loggingConfig: json_.containsKey('loggingConfig')
              ? LoggingConfig.fromJson(
                  json_['loggingConfig'] as core.Map<core.String, core.dynamic>)
              : null,
          maintenanceEvents: (json_['maintenanceEvents'] as core.List?)
              ?.map((value) => MaintenanceEvent.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
          maintenancePolicy: json_.containsKey('maintenancePolicy')
              ? MaintenancePolicy.fromJson(json_['maintenancePolicy']
                  as core.Map<core.String, core.dynamic>)
              : null,
          name: json_['name'] as core.String?,
          networkConfig: json_.containsKey('networkConfig')
              ? NetworkConfig.fromJson(
                  json_['networkConfig'] as core.Map<core.String, core.dynamic>)
              : null,
          options:
              (json_['options'] as core.Map<core.String, core.dynamic>?)?.map(
            (key, value) => core.MapEntry(
              key,
              value as core.String,
            ),
          ),
          p4ServiceAccount: json_['p4ServiceAccount'] as core.String?,
          patchRevision: json_['patchRevision'] as core.String?,
          privateInstance: json_['privateInstance'] as core.bool?,
          satisfiesPzi: json_['satisfiesPzi'] as core.bool?,
          satisfiesPzs: json_['satisfiesPzs'] as core.bool?,
          serviceAccount: json_['serviceAccount'] as core.String?,
          serviceEndpoint: json_['serviceEndpoint'] as core.String?,
          state: json_['state'] as core.String?,
          stateMessage: json_['stateMessage'] as core.String?,
          tenantProjectId: json_['tenantProjectId'] as core.String?,
          type: json_['type'] as core.String?,
          updateTime: json_['updateTime'] as core.String?,
          version: json_['version'] as core.String?,
          workforceIdentityServiceEndpoint:
              json_['workforceIdentityServiceEndpoint'] as core.String?,
          zone: json_['zone'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (accelerators != null) 'accelerators': accelerators!,
        if (apiEndpoint != null) 'apiEndpoint': apiEndpoint!,
        if (availableVersion != null) 'availableVersion': availableVersion!,
        if (createTime != null) 'createTime': createTime!,
        if (cryptoKeyConfig != null) 'cryptoKeyConfig': cryptoKeyConfig!,
        if (dataplexDataLineageIntegrationEnabled != null)
          'dataplexDataLineageIntegrationEnabled':
              dataplexDataLineageIntegrationEnabled!,
        if (dataprocServiceAccount != null)
          'dataprocServiceAccount': dataprocServiceAccount!,
        if (description != null) 'description': description!,
        if (disabledReason != null) 'disabledReason': disabledReason!,
        if (displayName != null) 'displayName': displayName!,
        if (enableRbac != null) 'enableRbac': enableRbac!,
        if (enableStackdriverLogging != null)
          'enableStackdriverLogging': enableStackdriverLogging!,
        if (enableStackdriverMonitoring != null)
          'enableStackdriverMonitoring': enableStackdriverMonitoring!,
        if (enableZoneSeparation != null)
          'enableZoneSeparation': enableZoneSeparation!,
        if (eventPublishConfig != null)
          'eventPublishConfig': eventPublishConfig!,
        if (gcsBucket != null) 'gcsBucket': gcsBucket!,
        if (labels != null) 'labels': labels!,
        if (loggingConfig != null) 'loggingConfig': loggingConfig!,
        if (maintenanceEvents != null) 'maintenanceEvents': maintenanceEvents!,
        if (maintenancePolicy != null) 'maintenancePolicy': maintenancePolicy!,
        if (name != null) 'name': name!,
        if (networkConfig != null) 'networkConfig': networkConfig!,
        if (options != null) 'options': options!,
        if (p4ServiceAccount != null) 'p4ServiceAccount': p4ServiceAccount!,
        if (patchRevision != null) 'patchRevision': patchRevision!,
        if (privateInstance != null) 'privateInstance': privateInstance!,
        if (satisfiesPzi != null) 'satisfiesPzi': satisfiesPzi!,
        if (satisfiesPzs != null) 'satisfiesPzs': satisfiesPzs!,
        if (serviceAccount != null) 'serviceAccount': serviceAccount!,
        if (serviceEndpoint != null) 'serviceEndpoint': serviceEndpoint!,
        if (state != null) 'state': state!,
        if (stateMessage != null) 'stateMessage': stateMessage!,
        if (tenantProjectId != null) 'tenantProjectId': tenantProjectId!,
        if (type != null) 'type': type!,
        if (updateTime != null) 'updateTime': updateTime!,
        if (version != null) 'version': version!,
        if (workforceIdentityServiceEndpoint != null)
          'workforceIdentityServiceEndpoint': workforceIdentityServiceEndpoint!,
        if (zone != null) 'zone': zone!,
      };
}

/// Response message for the list available versions request.
class ListAvailableVersionsResponse {
  /// Represents a list of versions that are supported.
  ///
  /// Deprecated: Use versions field instead.
  @core.Deprecated(
    'Not supported. Member documentation may have more information.',
  )
  core.List<Version>? availableVersions;

  /// Token to retrieve the next page of results or empty if there are no more
  /// results in the list.
  core.String? nextPageToken;

  /// Represents a list of all versions.
  core.List<Version>? versions;

  ListAvailableVersionsResponse({
    this.availableVersions,
    this.nextPageToken,
    this.versions,
  });

  ListAvailableVersionsResponse.fromJson(core.Map json_)
      : this(
          availableVersions: (json_['availableVersions'] as core.List?)
              ?.map((value) => Version.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
          nextPageToken: json_['nextPageToken'] as core.String?,
          versions: (json_['versions'] as core.List?)
              ?.map((value) => Version.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (availableVersions != null) 'availableVersions': availableVersions!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (versions != null) 'versions': versions!,
      };
}

/// Response message for list DNS peerings.
class ListDnsPeeringsResponse {
  /// List of dns peering.
  core.List<DnsPeering>? dnsPeerings;

  /// A token, which can be sent as `page_token` to retrieve the next page.
  ///
  /// If this field is omitted, there are no subsequent pages.
  core.String? nextPageToken;

  ListDnsPeeringsResponse({
    this.dnsPeerings,
    this.nextPageToken,
  });

  ListDnsPeeringsResponse.fromJson(core.Map json_)
      : this(
          dnsPeerings: (json_['dnsPeerings'] as core.List?)
              ?.map((value) => DnsPeering.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
          nextPageToken: json_['nextPageToken'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (dnsPeerings != null) 'dnsPeerings': dnsPeerings!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
      };
}

/// Response message for the list instance request.
class ListInstancesResponse {
  /// Represents a list of Data Fusion instances.
  core.List<Instance>? instances;

  /// Token to retrieve the next page of results or empty if there are no more
  /// results in the list.
  core.String? nextPageToken;

  /// Locations that could not be reached.
  core.List<core.String>? unreachable;

  ListInstancesResponse({
    this.instances,
    this.nextPageToken,
    this.unreachable,
  });

  ListInstancesResponse.fromJson(core.Map json_)
      : this(
          instances: (json_['instances'] as core.List?)
              ?.map((value) => Instance.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
          nextPageToken: json_['nextPageToken'] as core.String?,
          unreachable: (json_['unreachable'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (instances != null) 'instances': instances!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (unreachable != null) 'unreachable': unreachable!,
      };
}

/// The response message for Locations.ListLocations.
class ListLocationsResponse {
  /// A list of locations that matches the specified filter in the request.
  core.List<Location>? locations;

  /// The standard List next-page token.
  core.String? nextPageToken;

  ListLocationsResponse({
    this.locations,
    this.nextPageToken,
  });

  ListLocationsResponse.fromJson(core.Map json_)
      : this(
          locations: (json_['locations'] as core.List?)
              ?.map((value) => Location.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
          nextPageToken: json_['nextPageToken'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (locations != null) 'locations': locations!,
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
      };
}

/// The response message for Operations.ListOperations.
class ListOperationsResponse {
  /// The standard List next-page token.
  core.String? nextPageToken;

  /// A list of operations that matches the specified filter in the request.
  core.List<Operation>? operations;

  ListOperationsResponse({
    this.nextPageToken,
    this.operations,
  });

  ListOperationsResponse.fromJson(core.Map json_)
      : this(
          nextPageToken: json_['nextPageToken'] as core.String?,
          operations: (json_['operations'] as core.List?)
              ?.map((value) => Operation.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (nextPageToken != null) 'nextPageToken': nextPageToken!,
        if (operations != null) 'operations': operations!,
      };
}

/// A resource that represents a Google Cloud location.
typedef Location = $Location00;

/// Logging configuration for a Data Fusion instance.
class LoggingConfig {
  /// Option to determine whether instance logs should be written to Cloud
  /// Logging.
  ///
  /// By default, instance logs are written to Cloud Logging.
  ///
  /// Optional.
  core.bool? instanceCloudLoggingDisabled;

  LoggingConfig({
    this.instanceCloudLoggingDisabled,
  });

  LoggingConfig.fromJson(core.Map json_)
      : this(
          instanceCloudLoggingDisabled:
              json_['instanceCloudLoggingDisabled'] as core.bool?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (instanceCloudLoggingDisabled != null)
          'instanceCloudLoggingDisabled': instanceCloudLoggingDisabled!,
      };
}

/// Represents a maintenance event.
class MaintenanceEvent {
  /// The end time of the maintenance event provided in
  /// [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) format.
  ///
  /// Example: "2024-01-02T12:04:06-06:00" This field will be empty if the
  /// maintenance event is not yet complete.
  ///
  /// Output only.
  core.String? endTime;

  /// The start time of the maintenance event provided in
  /// [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) format.
  ///
  /// Example: "2024-01-01T12:04:06-04:00"
  ///
  /// Output only.
  core.String? startTime;

  /// The state of the maintenance event.
  ///
  /// Output only.
  /// Possible string values are:
  /// - "STATE_UNSPECIFIED" : The state of the maintenance event is unspecified.
  /// - "SCHEDULED" : The maintenance is scheduled but has not started.
  /// - "STARTED" : The maintenance has been started.
  /// - "COMPLETED" : The maintenance has been completed.
  core.String? state;

  MaintenanceEvent({
    this.endTime,
    this.startTime,
    this.state,
  });

  MaintenanceEvent.fromJson(core.Map json_)
      : this(
          endTime: json_['endTime'] as core.String?,
          startTime: json_['startTime'] as core.String?,
          state: json_['state'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (endTime != null) 'endTime': endTime!,
        if (startTime != null) 'startTime': startTime!,
        if (state != null) 'state': state!,
      };
}

/// Maintenance policy of the instance.
class MaintenancePolicy {
  /// The maintenance exclusion window of the instance.
  ///
  /// Optional.
  TimeWindow? maintenanceExclusionWindow;

  /// The maintenance window of the instance.
  ///
  /// Optional.
  MaintenanceWindow? maintenanceWindow;

  MaintenancePolicy({
    this.maintenanceExclusionWindow,
    this.maintenanceWindow,
  });

  MaintenancePolicy.fromJson(core.Map json_)
      : this(
          maintenanceExclusionWindow:
              json_.containsKey('maintenanceExclusionWindow')
                  ? TimeWindow.fromJson(json_['maintenanceExclusionWindow']
                      as core.Map<core.String, core.dynamic>)
                  : null,
          maintenanceWindow: json_.containsKey('maintenanceWindow')
              ? MaintenanceWindow.fromJson(json_['maintenanceWindow']
                  as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (maintenanceExclusionWindow != null)
          'maintenanceExclusionWindow': maintenanceExclusionWindow!,
        if (maintenanceWindow != null) 'maintenanceWindow': maintenanceWindow!,
      };
}

/// Maintenance window of the instance.
class MaintenanceWindow {
  /// The recurring time window of the maintenance window.
  ///
  /// Required.
  RecurringTimeWindow? recurringTimeWindow;

  MaintenanceWindow({
    this.recurringTimeWindow,
  });

  MaintenanceWindow.fromJson(core.Map json_)
      : this(
          recurringTimeWindow: json_.containsKey('recurringTimeWindow')
              ? RecurringTimeWindow.fromJson(json_['recurringTimeWindow']
                  as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (recurringTimeWindow != null)
          'recurringTimeWindow': recurringTimeWindow!,
      };
}

/// Network configuration for a Data Fusion instance.
///
/// These configurations are used for peering with the customer network.
/// Configurations are optional when a public Data Fusion instance is to be
/// created. However, providing these configurations allows several benefits,
/// such as reduced network latency while accessing the customer resources from
/// managed Data Fusion instance nodes, as well as access to the customer
/// on-prem resources.
class NetworkConfig {
  /// Type of connection for establishing private IP connectivity between the
  /// Data Fusion customer project VPC and the corresponding tenant project from
  /// a predefined list of available connection modes.
  ///
  /// If this field is unspecified for a private instance, VPC peering is used.
  ///
  /// Optional.
  /// Possible string values are:
  /// - "CONNECTION_TYPE_UNSPECIFIED" : No specific connection type was
  /// requested, the default value of VPC_PEERING is chosen.
  /// - "VPC_PEERING" : Requests the use of VPC peerings for connecting the
  /// consumer and tenant projects.
  /// - "PRIVATE_SERVICE_CONNECT_INTERFACES" : Requests the use of Private
  /// Service Connect Interfaces for connecting the consumer and tenant
  /// projects.
  core.String? connectionType;

  /// The IP range in CIDR notation to use for the managed Data Fusion instance
  /// nodes.
  ///
  /// This range must not overlap with any other ranges used in the Data Fusion
  /// instance network. This is required only when using connection type
  /// VPC_PEERING. Format: a.b.c.d/22 Example: 192.168.0.0/22
  ///
  /// Optional.
  core.String? ipAllocation;

  /// Name of the network in the customer project with which the Tenant Project
  /// will be peered for executing pipelines.
  ///
  /// In case of shared VPC where the network resides in another host project
  /// the network should specified in the form of
  /// projects/{host-project-id}/global/networks/{network}. This is only
  /// required for connectivity type VPC_PEERING.
  ///
  /// Optional.
  core.String? network;

  /// Configuration for Private Service Connect.
  ///
  /// This is required only when using connection type
  /// PRIVATE_SERVICE_CONNECT_INTERFACES.
  ///
  /// Optional.
  PrivateServiceConnectConfig? privateServiceConnectConfig;

  NetworkConfig({
    this.connectionType,
    this.ipAllocation,
    this.network,
    this.privateServiceConnectConfig,
  });

  NetworkConfig.fromJson(core.Map json_)
      : this(
          connectionType: json_['connectionType'] as core.String?,
          ipAllocation: json_['ipAllocation'] as core.String?,
          network: json_['network'] as core.String?,
          privateServiceConnectConfig:
              json_.containsKey('privateServiceConnectConfig')
                  ? PrivateServiceConnectConfig.fromJson(
                      json_['privateServiceConnectConfig']
                          as core.Map<core.String, core.dynamic>)
                  : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (connectionType != null) 'connectionType': connectionType!,
        if (ipAllocation != null) 'ipAllocation': ipAllocation!,
        if (network != null) 'network': network!,
        if (privateServiceConnectConfig != null)
          'privateServiceConnectConfig': privateServiceConnectConfig!,
      };
}

/// This resource represents a long-running operation that is the result of a
/// network API call.
class Operation {
  /// If the value is `false`, it means the operation is still in progress.
  ///
  /// If `true`, the operation is completed, and either `error` or `response` is
  /// available.
  core.bool? done;

  /// The error result of the operation in case of failure or cancellation.
  Status? error;

  /// Service-specific metadata associated with the operation.
  ///
  /// It typically contains progress information and common metadata such as
  /// create time. Some services might not provide such metadata. Any method
  /// that returns a long-running operation should document the metadata type,
  /// if any.
  ///
  /// The values for Object must be JSON objects. It can consist of `num`,
  /// `String`, `bool` and `null` as well as `Map` and `List` values.
  core.Map<core.String, core.Object?>? metadata;

  /// The server-assigned name, which is only unique within the same service
  /// that originally returns it.
  ///
  /// If you use the default HTTP mapping, the `name` should be a resource name
  /// ending with `operations/{unique_id}`.
  core.String? name;

  /// The normal, successful response of the operation.
  ///
  /// If the original method returns no data on success, such as `Delete`, the
  /// response is `google.protobuf.Empty`. If the original method is standard
  /// `Get`/`Create`/`Update`, the response should be the resource. For other
  /// methods, the response should have the type `XxxResponse`, where `Xxx` is
  /// the original method name. For example, if the original method name is
  /// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  ///
  /// The values for Object must be JSON objects. It can consist of `num`,
  /// `String`, `bool` and `null` as well as `Map` and `List` values.
  core.Map<core.String, core.Object?>? response;

  Operation({
    this.done,
    this.error,
    this.metadata,
    this.name,
    this.response,
  });

  Operation.fromJson(core.Map json_)
      : this(
          done: json_['done'] as core.bool?,
          error: json_.containsKey('error')
              ? Status.fromJson(
                  json_['error'] as core.Map<core.String, core.dynamic>)
              : null,
          metadata: json_.containsKey('metadata')
              ? json_['metadata'] as core.Map<core.String, core.dynamic>
              : null,
          name: json_['name'] as core.String?,
          response: json_.containsKey('response')
              ? json_['response'] as core.Map<core.String, core.dynamic>
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (done != null) 'done': done!,
        if (error != null) 'error': error!,
        if (metadata != null) 'metadata': metadata!,
        if (name != null) 'name': name!,
        if (response != null) 'response': response!,
      };
}

/// An Identity and Access Management (IAM) policy, which specifies access
/// controls for Google Cloud resources.
///
/// A `Policy` is a collection of `bindings`. A `binding` binds one or more
/// `members`, or principals, to a single `role`. Principals can be user
/// accounts, service accounts, Google groups, and domains (such as G Suite). A
/// `role` is a named list of permissions; each `role` can be an IAM predefined
/// role or a user-created custom role. For some types of Google Cloud
/// resources, a `binding` can also specify a `condition`, which is a logical
/// expression that allows access to a resource only if the expression evaluates
/// to `true`. A condition can add constraints based on attributes of the
/// request, the resource, or both. To learn which resources support conditions
/// in their IAM policies, see the
/// [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
/// **JSON example:** ``` { "bindings": [ { "role":
/// "roles/resourcemanager.organizationAdmin", "members": [
/// "user:mike@example.com", "group:admins@example.com", "domain:google.com",
/// "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
/// "roles/resourcemanager.organizationViewer", "members": [
/// "user:eve@example.com" ], "condition": { "title": "expirable access",
/// "description": "Does not grant access after Sep 2020", "expression":
/// "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
/// "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
/// members: - user:mike@example.com - group:admins@example.com -
/// domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
/// role: roles/resourcemanager.organizationAdmin - members: -
/// user:eve@example.com role: roles/resourcemanager.organizationViewer
/// condition: title: expirable access description: Does not grant access after
/// Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
/// etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
/// see the [IAM documentation](https://cloud.google.com/iam/docs/).
class Policy {
  /// Specifies cloud audit logging configuration for this policy.
  core.List<AuditConfig>? auditConfigs;

  /// Associates a list of `members`, or principals, with a `role`.
  ///
  /// Optionally, may specify a `condition` that determines how and when the
  /// `bindings` are applied. Each of the `bindings` must contain at least one
  /// principal. The `bindings` in a `Policy` can refer to up to 1,500
  /// principals; up to 250 of these principals can be Google groups. Each
  /// occurrence of a principal counts towards these limits. For example, if the
  /// `bindings` grant 50 different roles to `user:alice@example.com`, and not
  /// to any other principal, then you can add another 1,450 principals to the
  /// `bindings` in the `Policy`.
  core.List<Binding>? bindings;

  /// `etag` is used for optimistic concurrency control as a way to help prevent
  /// simultaneous updates of a policy from overwriting each other.
  ///
  /// It is strongly suggested that systems make use of the `etag` in the
  /// read-modify-write cycle to perform policy updates in order to avoid race
  /// conditions: An `etag` is returned in the response to `getIamPolicy`, and
  /// systems are expected to put that etag in the request to `setIamPolicy` to
  /// ensure that their change will be applied to the same version of the
  /// policy. **Important:** If you use IAM Conditions, you must include the
  /// `etag` field whenever you call `setIamPolicy`. If you omit this field,
  /// then IAM allows you to overwrite a version `3` policy with a version `1`
  /// policy, and all of the conditions in the version `3` policy are lost.
  core.String? etag;
  core.List<core.int> get etagAsBytes => convert.base64.decode(etag!);

  set etagAsBytes(core.List<core.int> bytes_) {
    etag =
        convert.base64.encode(bytes_).replaceAll('/', '_').replaceAll('+', '-');
  }

  /// Specifies the format of the policy.
  ///
  /// Valid values are `0`, `1`, and `3`. Requests that specify an invalid value
  /// are rejected. Any operation that affects conditional role bindings must
  /// specify version `3`. This requirement applies to the following operations:
  /// * Getting a policy that includes a conditional role binding * Adding a
  /// conditional role binding to a policy * Changing a conditional role binding
  /// in a policy * Removing any role binding, with or without a condition, from
  /// a policy that includes conditions **Important:** If you use IAM
  /// Conditions, you must include the `etag` field whenever you call
  /// `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a
  /// version `3` policy with a version `1` policy, and all of the conditions in
  /// the version `3` policy are lost. If a policy does not include any
  /// conditions, operations on that policy may specify any valid version or
  /// leave the field unset. To learn which resources support conditions in
  /// their IAM policies, see the
  /// [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
  core.int? version;

  Policy({
    this.auditConfigs,
    this.bindings,
    this.etag,
    this.version,
  });

  Policy.fromJson(core.Map json_)
      : this(
          auditConfigs: (json_['auditConfigs'] as core.List?)
              ?.map((value) => AuditConfig.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
          bindings: (json_['bindings'] as core.List?)
              ?.map((value) => Binding.fromJson(
                  value as core.Map<core.String, core.dynamic>))
              .toList(),
          etag: json_['etag'] as core.String?,
          version: json_['version'] as core.int?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (auditConfigs != null) 'auditConfigs': auditConfigs!,
        if (bindings != null) 'bindings': bindings!,
        if (etag != null) 'etag': etag!,
        if (version != null) 'version': version!,
      };
}

/// Configuration for using Private Service Connect to establish connectivity
/// between the Data Fusion consumer project and the corresponding tenant
/// project.
class PrivateServiceConnectConfig {
  /// The CIDR block to which the CDF instance can't route traffic to in the
  /// consumer project VPC.
  ///
  /// The size of this block is /25. The format of this field is governed by RFC
  /// 4632. Example: 240.0.0.0/25
  ///
  /// Output only.
  core.String? effectiveUnreachableCidrBlock;

  /// The reference to the network attachment used to establish private
  /// connectivity.
  ///
  /// It will be of the form
  /// projects/{project-id}/regions/{region}/networkAttachments/{network-attachment-id}.
  ///
  /// Required.
  core.String? networkAttachment;

  /// Input only.
  ///
  /// The CIDR block to which the CDF instance can't route traffic to in the
  /// consumer project VPC. The size of this block should be at least /25. This
  /// range should not overlap with the primary address range of any subnetwork
  /// used by the network attachment. This range can be used for other purposes
  /// in the consumer VPC as long as there is no requirement for CDF to reach
  /// destinations using these addresses. If this value is not provided, the
  /// server chooses a non RFC 1918 address range. The format of this field is
  /// governed by RFC 4632. Example: 192.168.0.0/25
  ///
  /// Optional.
  core.String? unreachableCidrBlock;

  PrivateServiceConnectConfig({
    this.effectiveUnreachableCidrBlock,
    this.networkAttachment,
    this.unreachableCidrBlock,
  });

  PrivateServiceConnectConfig.fromJson(core.Map json_)
      : this(
          effectiveUnreachableCidrBlock:
              json_['effectiveUnreachableCidrBlock'] as core.String?,
          networkAttachment: json_['networkAttachment'] as core.String?,
          unreachableCidrBlock: json_['unreachableCidrBlock'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (effectiveUnreachableCidrBlock != null)
          'effectiveUnreachableCidrBlock': effectiveUnreachableCidrBlock!,
        if (networkAttachment != null) 'networkAttachment': networkAttachment!,
        if (unreachableCidrBlock != null)
          'unreachableCidrBlock': unreachableCidrBlock!,
      };
}

/// Represents an arbitrary window of time that recurs.
class RecurringTimeWindow {
  /// An RRULE with format
  /// \[RFC-5545\](https://tools.ietf.org/html/rfc5545#section-3.8.5.3) for how
  /// this window reccurs.
  ///
  /// They go on for the span of time between the start and end time. The only
  /// supported FREQ value is "WEEKLY". To have something repeat every weekday,
  /// use: "FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR". This specifies how frequently the
  /// window starts. To have a 9 am - 5 pm UTC-4 window every weekday, use
  /// something like: ``` start time = 2019-01-01T09:00:00-0400 end time =
  /// 2019-01-01T17:00:00-0400 recurrence = FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR ```
  ///
  /// Required.
  core.String? recurrence;

  /// The window representing the start and end time of recurrences.
  ///
  /// This field ignores the date components of the provided timestamps. Only
  /// the time of day and duration between start and end time are relevant.
  ///
  /// Required.
  TimeWindow? window;

  RecurringTimeWindow({
    this.recurrence,
    this.window,
  });

  RecurringTimeWindow.fromJson(core.Map json_)
      : this(
          recurrence: json_['recurrence'] as core.String?,
          window: json_.containsKey('window')
              ? TimeWindow.fromJson(
                  json_['window'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (recurrence != null) 'recurrence': recurrence!,
        if (window != null) 'window': window!,
      };
}

/// Request message for restarting a Data Fusion instance.
typedef RestartInstanceRequest = $Empty;

/// Request message for `SetIamPolicy` method.
class SetIamPolicyRequest {
  /// REQUIRED: The complete policy to be applied to the `resource`.
  ///
  /// The size of the policy is limited to a few 10s of KB. An empty policy is a
  /// valid policy but certain Google Cloud services (such as Projects) might
  /// reject them.
  Policy? policy;

  /// OPTIONAL: A FieldMask specifying which fields of the policy to modify.
  ///
  /// Only the fields in the mask will be modified. If no mask is provided, the
  /// following default mask is used: `paths: "bindings, etag"`
  core.String? updateMask;

  SetIamPolicyRequest({
    this.policy,
    this.updateMask,
  });

  SetIamPolicyRequest.fromJson(core.Map json_)
      : this(
          policy: json_.containsKey('policy')
              ? Policy.fromJson(
                  json_['policy'] as core.Map<core.String, core.dynamic>)
              : null,
          updateMask: json_['updateMask'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (policy != null) 'policy': policy!,
        if (updateMask != null) 'updateMask': updateMask!,
      };
}

/// The `Status` type defines a logical error model that is suitable for
/// different programming environments, including REST APIs and RPC APIs.
///
/// It is used by [gRPC](https://github.com/grpc). Each `Status` message
/// contains three pieces of data: error code, error message, and error details.
/// You can find out more about this error model and how to work with it in the
/// [API Design Guide](https://cloud.google.com/apis/design/errors).
typedef Status = $Status00;

/// Request message for `TestIamPermissions` method.
typedef TestIamPermissionsRequest = $TestIamPermissionsRequest00;

/// Response message for `TestIamPermissions` method.
typedef TestIamPermissionsResponse = $PermissionsResponse;

/// Represents an arbitrary window of time.
class TimeWindow {
  /// The end time of the time window provided in
  /// [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) format.
  ///
  /// The end time should take place after the start time. Example:
  /// "2024-01-02T12:04:06-06:00"
  ///
  /// Required.
  core.String? endTime;

  /// The start time of the time window provided in
  /// [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) format.
  ///
  /// Example: "2024-01-01T12:04:06-04:00"
  ///
  /// Required.
  core.String? startTime;

  TimeWindow({
    this.endTime,
    this.startTime,
  });

  TimeWindow.fromJson(core.Map json_)
      : this(
          endTime: json_['endTime'] as core.String?,
          startTime: json_['startTime'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (endTime != null) 'endTime': endTime!,
        if (startTime != null) 'startTime': startTime!,
      };
}

/// The Data Fusion version.
///
/// This proto message stores information about certain Data Fusion version,
/// which is used for Data Fusion version upgrade.
class Version {
  /// Represents a list of available feature names for a given version.
  core.List<core.String>? availableFeatures;

  /// Whether this is currently the default version for Cloud Data Fusion
  core.bool? defaultVersion;

  /// Type represents the release availability of the version
  /// Possible string values are:
  /// - "TYPE_UNSPECIFIED" : Version does not have availability yet
  /// - "TYPE_PREVIEW" : Version is under development and not considered stable
  /// - "TYPE_GENERAL_AVAILABILITY" : Version is available for public use
  /// - "TYPE_DEPRECATED" : Version is no longer supported.
  core.String? type;

  /// The version number of the Data Fusion instance, such as '6.0.1.0'.
  core.String? versionNumber;

  Version({
    this.availableFeatures,
    this.defaultVersion,
    this.type,
    this.versionNumber,
  });

  Version.fromJson(core.Map json_)
      : this(
          availableFeatures: (json_['availableFeatures'] as core.List?)
              ?.map((value) => value as core.String)
              .toList(),
          defaultVersion: json_['defaultVersion'] as core.bool?,
          type: json_['type'] as core.String?,
          versionNumber: json_['versionNumber'] as core.String?,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (availableFeatures != null) 'availableFeatures': availableFeatures!,
        if (defaultVersion != null) 'defaultVersion': defaultVersion!,
        if (type != null) 'type': type!,
        if (versionNumber != null) 'versionNumber': versionNumber!,
      };
}
