// This is a generated file (see the discoveryapis_generator project).

// ignore_for_file: camel_case_types
// ignore_for_file: comment_references
// ignore_for_file: deprecated_member_use_from_same_package
// ignore_for_file: doc_directive_unknown
// ignore_for_file: lines_longer_than_80_chars
// ignore_for_file: non_constant_identifier_names
// ignore_for_file: prefer_interpolation_to_compose_strings
// ignore_for_file: unintended_html_in_doc_comment
// ignore_for_file: unnecessary_brace_in_string_interps
// ignore_for_file: unnecessary_lambdas
// ignore_for_file: unnecessary_string_interpolations

/// Compute Engine API - v1
///
/// Creates and runs virtual machines on Google Cloud Platform.
///
/// For more information, see <https://cloud.google.com/compute/>
///
/// Create an instance of [ComputeApi] to access these resources:
///
/// - [AcceleratorTypesResource]
/// - [AddressesResource]
/// - [AutoscalersResource]
/// - [BackendBucketsResource]
/// - [BackendServicesResource]
/// - [DiskTypesResource]
/// - [DisksResource]
/// - [ExternalVpnGatewaysResource]
/// - [FirewallPoliciesResource]
/// - [FirewallsResource]
/// - [ForwardingRulesResource]
/// - [GlobalAddressesResource]
/// - [GlobalForwardingRulesResource]
/// - [GlobalNetworkEndpointGroupsResource]
/// - [GlobalOperationsResource]
/// - [GlobalOrganizationOperationsResource]
/// - [GlobalPublicDelegatedPrefixesResource]
/// - [HealthChecksResource]
/// - [HttpHealthChecksResource]
/// - [HttpsHealthChecksResource]
/// - [ImageFamilyViewsResource]
/// - [ImagesResource]
/// - [InstanceGroupManagerResizeRequestsResource]
/// - [InstanceGroupManagersResource]
/// - [InstanceGroupsResource]
/// - [InstanceSettingsResource]
/// - [InstanceTemplatesResource]
/// - [InstancesResource]
/// - [InstantSnapshotsResource]
/// - [InterconnectAttachmentsResource]
/// - [InterconnectLocationsResource]
/// - [InterconnectRemoteLocationsResource]
/// - [InterconnectsResource]
/// - [LicenseCodesResource]
/// - [LicensesResource]
/// - [MachineImagesResource]
/// - [MachineTypesResource]
/// - [NetworkAttachmentsResource]
/// - [NetworkEdgeSecurityServicesResource]
/// - [NetworkEndpointGroupsResource]
/// - [NetworkFirewallPoliciesResource]
/// - [NetworkProfilesResource]
/// - [NetworksResource]
/// - [NodeGroupsResource]
/// - [NodeTemplatesResource]
/// - [NodeTypesResource]
/// - [PacketMirroringsResource]
/// - [ProjectsResource]
/// - [PublicAdvertisedPrefixesResource]
/// - [PublicDelegatedPrefixesResource]
/// - [RegionAutoscalersResource]
/// - [RegionBackendServicesResource]
/// - [RegionCommitmentsResource]
/// - [RegionDiskTypesResource]
/// - [RegionDisksResource]
/// - [RegionHealthCheckServicesResource]
/// - [RegionHealthChecksResource]
/// - [RegionInstanceGroupManagersResource]
/// - [RegionInstanceGroupsResource]
/// - [RegionInstanceTemplatesResource]
/// - [RegionInstancesResource]
/// - [RegionInstantSnapshotsResource]
/// - [RegionNetworkEndpointGroupsResource]
/// - [RegionNetworkFirewallPoliciesResource]
/// - [RegionNotificationEndpointsResource]
/// - [RegionOperationsResource]
/// - [RegionSecurityPoliciesResource]
/// - [RegionSslCertificatesResource]
/// - [RegionSslPoliciesResource]
/// - [RegionTargetHttpProxiesResource]
/// - [RegionTargetHttpsProxiesResource]
/// - [RegionTargetTcpProxiesResource]
/// - [RegionUrlMapsResource]
/// - [RegionZonesResource]
/// - [RegionsResource]
/// - [ReservationsResource]
/// - [ResourcePoliciesResource]
/// - [RoutersResource]
/// - [RoutesResource]
/// - [SecurityPoliciesResource]
/// - [ServiceAttachmentsResource]
/// - [SnapshotSettingsResource]
/// - [SnapshotsResource]
/// - [SslCertificatesResource]
/// - [SslPoliciesResource]
/// - [StoragePoolTypesResource]
/// - [StoragePoolsResource]
/// - [SubnetworksResource]
/// - [TargetGrpcProxiesResource]
/// - [TargetHttpProxiesResource]
/// - [TargetHttpsProxiesResource]
/// - [TargetInstancesResource]
/// - [TargetPoolsResource]
/// - [TargetSslProxiesResource]
/// - [TargetTcpProxiesResource]
/// - [TargetVpnGatewaysResource]
/// - [UrlMapsResource]
/// - [VpnGatewaysResource]
/// - [VpnTunnelsResource]
/// - [ZoneOperationsResource]
/// - [ZonesResource]
library;

import 'dart:async' as async;
import 'dart:convert' as convert;
import 'dart:core' as core;

import 'package:_discoveryapis_commons/_discoveryapis_commons.dart' as commons;
import 'package:http/http.dart' as http;

import '../shared.dart';
import '../src/user_agent.dart';

export 'package:_discoveryapis_commons/_discoveryapis_commons.dart'
    show ApiRequestError, DetailedApiRequestError;

/// Creates and runs virtual machines on Google Cloud Platform.
class ComputeApi {
  /// See, edit, configure, and delete your Google Cloud data and see the email
  /// address for your Google Account.
  static const cloudPlatformScope =
      'https://www.googleapis.com/auth/cloud-platform';

  /// View and manage your Google Compute Engine resources
  static const computeScope = 'https://www.googleapis.com/auth/compute';

  /// View your Google Compute Engine resources
  static const computeReadonlyScope =
      'https://www.googleapis.com/auth/compute.readonly';

  /// Manage your data and permissions in Cloud Storage and see the email
  /// address for your Google Account
  static const devstorageFullControlScope =
      'https://www.googleapis.com/auth/devstorage.full_control';

  /// View your data in Google Cloud Storage
  static const devstorageReadOnlyScope =
      'https://www.googleapis.com/auth/devstorage.read_only';

  /// Manage your data in Cloud Storage and see the email address of your Google
  /// Account
  static const devstorageReadWriteScope =
      'https://www.googleapis.com/auth/devstorage.read_write';

  final commons.ApiRequester _requester;

  AcceleratorTypesResource get acceleratorTypes =>
      AcceleratorTypesResource(_requester);
  AddressesResource get addresses => AddressesResource(_requester);
  AutoscalersResource get autoscalers => AutoscalersResource(_requester);
  BackendBucketsResource get backendBuckets =>
      BackendBucketsResource(_requester);
  BackendServicesResource get backendServices =>
      BackendServicesResource(_requester);
  DiskTypesResource get diskTypes => DiskTypesResource(_requester);
  DisksResource get disks => DisksResource(_requester);
  ExternalVpnGatewaysResource get externalVpnGateways =>
      ExternalVpnGatewaysResource(_requester);
  FirewallPoliciesResource get firewallPolicies =>
      FirewallPoliciesResource(_requester);
  FirewallsResource get firewalls => FirewallsResource(_requester);
  ForwardingRulesResource get forwardingRules =>
      ForwardingRulesResource(_requester);
  GlobalAddressesResource get globalAddresses =>
      GlobalAddressesResource(_requester);
  GlobalForwardingRulesResource get globalForwardingRules =>
      GlobalForwardingRulesResource(_requester);
  GlobalNetworkEndpointGroupsResource get globalNetworkEndpointGroups =>
      GlobalNetworkEndpointGroupsResource(_requester);
  GlobalOperationsResource get globalOperations =>
      GlobalOperationsResource(_requester);
  GlobalOrganizationOperationsResource get globalOrganizationOperations =>
      GlobalOrganizationOperationsResource(_requester);
  GlobalPublicDelegatedPrefixesResource get globalPublicDelegatedPrefixes =>
      GlobalPublicDelegatedPrefixesResource(_requester);
  HealthChecksResource get healthChecks => HealthChecksResource(_requester);
  HttpHealthChecksResource get httpHealthChecks =>
      HttpHealthChecksResource(_requester);
  HttpsHealthChecksResource get httpsHealthChecks =>
      HttpsHealthChecksResource(_requester);
  ImageFamilyViewsResource get imageFamilyViews =>
      ImageFamilyViewsResource(_requester);
  ImagesResource get images => ImagesResource(_requester);
  InstanceGroupManagerResizeRequestsResource
      get instanceGroupManagerResizeRequests =>
          InstanceGroupManagerResizeRequestsResource(_requester);
  InstanceGroupManagersResource get instanceGroupManagers =>
      InstanceGroupManagersResource(_requester);
  InstanceGroupsResource get instanceGroups =>
      InstanceGroupsResource(_requester);
  InstanceSettingsResource get instanceSettings =>
      InstanceSettingsResource(_requester);
  InstanceTemplatesResource get instanceTemplates =>
      InstanceTemplatesResource(_requester);
  InstancesResource get instances => InstancesResource(_requester);
  InstantSnapshotsResource get instantSnapshots =>
      InstantSnapshotsResource(_requester);
  InterconnectAttachmentsResource get interconnectAttachments =>
      InterconnectAttachmentsResource(_requester);
  InterconnectLocationsResource get interconnectLocations =>
      InterconnectLocationsResource(_requester);
  InterconnectRemoteLocationsResource get interconnectRemoteLocations =>
      InterconnectRemoteLocationsResource(_requester);
  InterconnectsResource get interconnects => InterconnectsResource(_requester);
  LicenseCodesResource get licenseCodes => LicenseCodesResource(_requester);
  LicensesResource get licenses => LicensesResource(_requester);
  MachineImagesResource get machineImages => MachineImagesResource(_requester);
  MachineTypesResource get machineTypes => MachineTypesResource(_requester);
  NetworkAttachmentsResource get networkAttachments =>
      NetworkAttachmentsResource(_requester);
  NetworkEdgeSecurityServicesResource get networkEdgeSecurityServices =>
      NetworkEdgeSecurityServicesResource(_requester);
  NetworkEndpointGroupsResource get networkEndpointGroups =>
      NetworkEndpointGroupsResource(_requester);
  NetworkFirewallPoliciesResource get networkFirewallPolicies =>
      NetworkFirewallPoliciesResource(_requester);
  NetworkProfilesResource get networkProfiles =>
      NetworkProfilesResource(_requester);
  NetworksResource get networks => NetworksResource(_requester);
  NodeGroupsResource get nodeGroups => NodeGroupsResource(_requester);
  NodeTemplatesResource get nodeTemplates => NodeTemplatesResource(_requester);
  NodeTypesResource get nodeTypes => NodeTypesResource(_requester);
  PacketMirroringsResource get packetMirrorings =>
      PacketMirroringsResource(_requester);
  ProjectsResource get projects => ProjectsResource(_requester);
  PublicAdvertisedPrefixesResource get publicAdvertisedPrefixes =>
      PublicAdvertisedPrefixesResource(_requester);
  PublicDelegatedPrefixesResource get publicDelegatedPrefixes =>
      PublicDelegatedPrefixesResource(_requester);
  RegionAutoscalersResource get regionAutoscalers =>
      RegionAutoscalersResource(_requester);
  RegionBackendServicesResource get regionBackendServices =>
      RegionBackendServicesResource(_requester);
  RegionCommitmentsResource get regionCommitments =>
      RegionCommitmentsResource(_requester);
  RegionDiskTypesResource get regionDiskTypes =>
      RegionDiskTypesResource(_requester);
  RegionDisksResource get regionDisks => RegionDisksResource(_requester);
  RegionHealthCheckServicesResource get regionHealthCheckServices =>
      RegionHealthCheckServicesResource(_requester);
  RegionHealthChecksResource get regionHealthChecks =>
      RegionHealthChecksResource(_requester);
  RegionInstanceGroupManagersResource get regionInstanceGroupManagers =>
      RegionInstanceGroupManagersResource(_requester);
  RegionInstanceGroupsResource get regionInstanceGroups =>
      RegionInstanceGroupsResource(_requester);
  RegionInstanceTemplatesResource get regionInstanceTemplates =>
      RegionInstanceTemplatesResource(_requester);
  RegionInstancesResource get regionInstances =>
      RegionInstancesResource(_requester);
  RegionInstantSnapshotsResource get regionInstantSnapshots =>
      RegionInstantSnapshotsResource(_requester);
  RegionNetworkEndpointGroupsResource get regionNetworkEndpointGroups =>
      RegionNetworkEndpointGroupsResource(_requester);
  RegionNetworkFirewallPoliciesResource get regionNetworkFirewallPolicies =>
      RegionNetworkFirewallPoliciesResource(_requester);
  RegionNotificationEndpointsResource get regionNotificationEndpoints =>
      RegionNotificationEndpointsResource(_requester);
  RegionOperationsResource get regionOperations =>
      RegionOperationsResource(_requester);
  RegionSecurityPoliciesResource get regionSecurityPolicies =>
      RegionSecurityPoliciesResource(_requester);
  RegionSslCertificatesResource get regionSslCertificates =>
      RegionSslCertificatesResource(_requester);
  RegionSslPoliciesResource get regionSslPolicies =>
      RegionSslPoliciesResource(_requester);
  RegionTargetHttpProxiesResource get regionTargetHttpProxies =>
      RegionTargetHttpProxiesResource(_requester);
  RegionTargetHttpsProxiesResource get regionTargetHttpsProxies =>
      RegionTargetHttpsProxiesResource(_requester);
  RegionTargetTcpProxiesResource get regionTargetTcpProxies =>
      RegionTargetTcpProxiesResource(_requester);
  RegionUrlMapsResource get regionUrlMaps => RegionUrlMapsResource(_requester);
  RegionZonesResource get regionZones => RegionZonesResource(_requester);
  RegionsResource get regions => RegionsResource(_requester);
  ReservationsResource get reservations => ReservationsResource(_requester);
  ResourcePoliciesResource get resourcePolicies =>
      ResourcePoliciesResource(_requester);
  RoutersResource get routers => RoutersResource(_requester);
  RoutesResource get routes => RoutesResource(_requester);
  SecurityPoliciesResource get securityPolicies =>
      SecurityPoliciesResource(_requester);
  ServiceAttachmentsResource get serviceAttachments =>
      ServiceAttachmentsResource(_requester);
  SnapshotSettingsResource get snapshotSettings =>
      SnapshotSettingsResource(_requester);
  SnapshotsResource get snapshots => SnapshotsResource(_requester);
  SslCertificatesResource get sslCertificates =>
      SslCertificatesResource(_requester);
  SslPoliciesResource get sslPolicies => SslPoliciesResource(_requester);
  StoragePoolTypesResource get storagePoolTypes =>
      StoragePoolTypesResource(_requester);
  StoragePoolsResource get storagePools => StoragePoolsResource(_requester);
  SubnetworksResource get subnetworks => SubnetworksResource(_requester);
  TargetGrpcProxiesResource get targetGrpcProxies =>
      TargetGrpcProxiesResource(_requester);
  TargetHttpProxiesResource get targetHttpProxies =>
      TargetHttpProxiesResource(_requester);
  TargetHttpsProxiesResource get targetHttpsProxies =>
      TargetHttpsProxiesResource(_requester);
  TargetInstancesResource get targetInstances =>
      TargetInstancesResource(_requester);
  TargetPoolsResource get targetPools => TargetPoolsResource(_requester);
  TargetSslProxiesResource get targetSslProxies =>
      TargetSslProxiesResource(_requester);
  TargetTcpProxiesResource get targetTcpProxies =>
      TargetTcpProxiesResource(_requester);
  TargetVpnGatewaysResource get targetVpnGateways =>
      TargetVpnGatewaysResource(_requester);
  UrlMapsResource get urlMaps => UrlMapsResource(_requester);
  VpnGatewaysResource get vpnGateways => VpnGatewaysResource(_requester);
  VpnTunnelsResource get vpnTunnels => VpnTunnelsResource(_requester);
  ZoneOperationsResource get zoneOperations =>
      ZoneOperationsResource(_requester);
  ZonesResource get zones => ZonesResource(_requester);

  ComputeApi(http.Client client,
      {core.String rootUrl = 'https://compute.googleapis.com/',
      core.String servicePath = 'compute/v1/'})
      : _requester =
            commons.ApiRequester(client, rootUrl, servicePath, requestHeaders);
}

class AcceleratorTypesResource {
  final commons.ApiRequester _requester;

  AcceleratorTypesResource(commons.ApiRequester client) : _requester = client;

  /// Retrieves an aggregated list of accelerator types.
  ///
  /// To prevent failure, Google recommends that you set the
  /// `returnPartialSuccess` parameter to `true`.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [includeAllScopes] - Indicates whether every visible scope for each scope
  /// type (zone, region, global) should be included in the response. For new
  /// resource types added after this field, the flag has no effect as new
  /// resource types will always include every visible scope for each scope type
  /// in response. For resource types which predate this field, if this flag is
  /// omitted or false, only scopes of the scope types where the resource type
  /// is expected to be found will be included.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [serviceProjectNumber] - The Shared VPC service project id or service
  /// project number for which aggregated list request is invoked for
  /// subnetworks list-usable api.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AcceleratorTypeAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AcceleratorTypeAggregatedList> aggregatedList(
    core.String project, {
    core.String? filter,
    core.bool? includeAllScopes,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? serviceProjectNumber,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (includeAllScopes != null) 'includeAllScopes': ['${includeAllScopes}'],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if (serviceProjectNumber != null)
        'serviceProjectNumber': [serviceProjectNumber],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/aggregated/acceleratorTypes';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return AcceleratorTypeAggregatedList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the specified accelerator type.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [acceleratorType] - Name of the accelerator type to return.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AcceleratorType].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AcceleratorType> get(
    core.String project,
    core.String zone,
    core.String acceleratorType, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/acceleratorTypes/' +
        commons.escapeVariable('$acceleratorType');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return AcceleratorType.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves a list of accelerator types that are available to the specified
  /// project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AcceleratorTypeList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AcceleratorTypeList> list(
    core.String project,
    core.String zone, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/acceleratorTypes';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return AcceleratorTypeList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class AddressesResource {
  final commons.ApiRequester _requester;

  AddressesResource(commons.ApiRequester client) : _requester = client;

  /// Retrieves an aggregated list of addresses.
  ///
  /// To prevent failure, Google recommends that you set the
  /// `returnPartialSuccess` parameter to `true`.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [includeAllScopes] - Indicates whether every visible scope for each scope
  /// type (zone, region, global) should be included in the response. For new
  /// resource types added after this field, the flag has no effect as new
  /// resource types will always include every visible scope for each scope type
  /// in response. For resource types which predate this field, if this flag is
  /// omitted or false, only scopes of the scope types where the resource type
  /// is expected to be found will be included.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [serviceProjectNumber] - The Shared VPC service project id or service
  /// project number for which aggregated list request is invoked for
  /// subnetworks list-usable api.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AddressAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AddressAggregatedList> aggregatedList(
    core.String project, {
    core.String? filter,
    core.bool? includeAllScopes,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? serviceProjectNumber,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (includeAllScopes != null) 'includeAllScopes': ['${includeAllScopes}'],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if (serviceProjectNumber != null)
        'serviceProjectNumber': [serviceProjectNumber],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/aggregated/addresses';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return AddressAggregatedList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes the specified address resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [region] - Name of the region for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [address] - Name of the address resource to delete.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
    core.String project,
    core.String region,
    core.String address, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/regions/' +
        commons.escapeVariable('$region') +
        '/addresses/' +
        commons.escapeVariable('$address');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the specified address resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [region] - Name of the region for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [address] - Name of the address resource to return.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Address].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Address> get(
    core.String project,
    core.String region,
    core.String address, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/regions/' +
        commons.escapeVariable('$region') +
        '/addresses/' +
        commons.escapeVariable('$address');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Address.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates an address resource in the specified project by using the data
  /// included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [region] - Name of the region for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
    Address request,
    core.String project,
    core.String region, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/regions/' +
        commons.escapeVariable('$region') +
        '/addresses';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves a list of addresses contained within the specified region.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [region] - Name of the region for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AddressList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AddressList> list(
    core.String project,
    core.String region, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/regions/' +
        commons.escapeVariable('$region') +
        '/addresses';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return AddressList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Moves the specified address resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Source project ID which the Address is moved from.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [region] - Name of the region for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [address] - Name of the address resource to move.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> move(
    RegionAddressesMoveRequest request,
    core.String project,
    core.String region,
    core.String address, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/regions/' +
        commons.escapeVariable('$region') +
        '/addresses/' +
        commons.escapeVariable('$address') +
        '/move';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the labels on an Address.
  ///
  /// To learn more about labels, read the Labeling Resources documentation.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [region] - The region for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setLabels(
    RegionSetLabelsRequest request,
    core.String project,
    core.String region,
    core.String resource, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/regions/' +
        commons.escapeVariable('$region') +
        '/addresses/' +
        commons.escapeVariable('$resource') +
        '/setLabels';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }
}

class AutoscalersResource {
  final commons.ApiRequester _requester;

  AutoscalersResource(commons.ApiRequester client) : _requester = client;

  /// Retrieves an aggregated list of autoscalers.
  ///
  /// To prevent failure, Google recommends that you set the
  /// `returnPartialSuccess` parameter to `true`.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [includeAllScopes] - Indicates whether every visible scope for each scope
  /// type (zone, region, global) should be included in the response. For new
  /// resource types added after this field, the flag has no effect as new
  /// resource types will always include every visible scope for each scope type
  /// in response. For resource types which predate this field, if this flag is
  /// omitted or false, only scopes of the scope types where the resource type
  /// is expected to be found will be included.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [serviceProjectNumber] - The Shared VPC service project id or service
  /// project number for which aggregated list request is invoked for
  /// subnetworks list-usable api.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AutoscalerAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AutoscalerAggregatedList> aggregatedList(
    core.String project, {
    core.String? filter,
    core.bool? includeAllScopes,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? serviceProjectNumber,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (includeAllScopes != null) 'includeAllScopes': ['${includeAllScopes}'],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if (serviceProjectNumber != null)
        'serviceProjectNumber': [serviceProjectNumber],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/aggregated/autoscalers';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return AutoscalerAggregatedList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes the specified autoscaler.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - Name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [autoscaler] - Name of the autoscaler to delete.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
    core.String project,
    core.String zone,
    core.String autoscaler, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/autoscalers/' +
        commons.escapeVariable('$autoscaler');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the specified autoscaler resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - Name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [autoscaler] - Name of the autoscaler to return.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Autoscaler].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Autoscaler> get(
    core.String project,
    core.String zone,
    core.String autoscaler, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/autoscalers/' +
        commons.escapeVariable('$autoscaler');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Autoscaler.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates an autoscaler in the specified project using the data included in
  /// the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - Name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
    Autoscaler request,
    core.String project,
    core.String zone, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/autoscalers';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves a list of autoscalers contained within the specified zone.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - Name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AutoscalerList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AutoscalerList> list(
    core.String project,
    core.String zone, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/autoscalers';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return AutoscalerList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates an autoscaler in the specified project using the data included in
  /// the request.
  ///
  /// This method supports PATCH semantics and uses the JSON merge patch format
  /// and processing rules.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - Name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [autoscaler] - Name of the autoscaler to patch.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> patch(
    Autoscaler request,
    core.String project,
    core.String zone, {
    core.String? autoscaler,
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (autoscaler != null) 'autoscaler': [autoscaler],
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/autoscalers';

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates an autoscaler in the specified project using the data included in
  /// the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - Name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [autoscaler] - Name of the autoscaler to update.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> update(
    Autoscaler request,
    core.String project,
    core.String zone, {
    core.String? autoscaler,
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (autoscaler != null) 'autoscaler': [autoscaler],
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/autoscalers';

    final response_ = await _requester.request(
      url_,
      'PUT',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }
}

class BackendBucketsResource {
  final commons.ApiRequester _requester;

  BackendBucketsResource(commons.ApiRequester client) : _requester = client;

  /// Adds a key for validating requests with signed URLs for this backend
  /// bucket.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [backendBucket] - Name of the BackendBucket resource to which the Signed
  /// URL Key should be added. The name should conform to RFC1035.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> addSignedUrlKey(
    SignedUrlKey request,
    core.String project,
    core.String backendBucket, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/backendBuckets/' +
        commons.escapeVariable('$backendBucket') +
        '/addSignedUrlKey';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes the specified BackendBucket resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [backendBucket] - Name of the BackendBucket resource to delete.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
    core.String project,
    core.String backendBucket, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/backendBuckets/' +
        commons.escapeVariable('$backendBucket');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a key for validating requests with signed URLs for this backend
  /// bucket.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [backendBucket] - Name of the BackendBucket resource to which the Signed
  /// URL Key should be added. The name should conform to RFC1035.
  ///
  /// [keyName] - The name of the Signed URL Key to delete.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> deleteSignedUrlKey(
    core.String project,
    core.String backendBucket,
    core.String keyName, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      'keyName': [keyName],
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/backendBuckets/' +
        commons.escapeVariable('$backendBucket') +
        '/deleteSignedUrlKey';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the specified BackendBucket resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [backendBucket] - Name of the BackendBucket resource to return.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [BackendBucket].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<BackendBucket> get(
    core.String project,
    core.String backendBucket, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/backendBuckets/' +
        commons.escapeVariable('$backendBucket');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return BackendBucket.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the access control policy for a resource.
  ///
  /// May be empty if no such policy or resource exists.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9_\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [optionsRequestedPolicyVersion] - Requested IAM Policy version.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> getIamPolicy(
    core.String project,
    core.String resource, {
    core.int? optionsRequestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (optionsRequestedPolicyVersion != null)
        'optionsRequestedPolicyVersion': ['${optionsRequestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/backendBuckets/' +
        commons.escapeVariable('$resource') +
        '/getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Policy.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates a BackendBucket resource in the specified project using the data
  /// included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
    BackendBucket request,
    core.String project, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/backendBuckets';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves the list of BackendBucket resources available to the specified
  /// project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [BackendBucketList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<BackendBucketList> list(
    core.String project, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/backendBuckets';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return BackendBucketList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates the specified BackendBucket resource with the data included in the
  /// request.
  ///
  /// This method supports PATCH semantics and uses the JSON merge patch format
  /// and processing rules.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [backendBucket] - Name of the BackendBucket resource to patch.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> patch(
    BackendBucket request,
    core.String project,
    core.String backendBucket, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/backendBuckets/' +
        commons.escapeVariable('$backendBucket');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the edge security policy for the specified backend bucket.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [backendBucket] - Name of the BackendBucket resource to which the security
  /// policy should be set. The name should conform to RFC1035.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setEdgeSecurityPolicy(
    SecurityPolicyReference request,
    core.String project,
    core.String backendBucket, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/backendBuckets/' +
        commons.escapeVariable('$backendBucket') +
        '/setEdgeSecurityPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified resource.
  ///
  /// Replaces any existing policy.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9_\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> setIamPolicy(
    GlobalSetPolicyRequest request,
    core.String project,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/backendBuckets/' +
        commons.escapeVariable('$resource') +
        '/setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Policy.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9_\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [TestPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<TestPermissionsResponse> testIamPermissions(
    TestPermissionsRequest request,
    core.String project,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/backendBuckets/' +
        commons.escapeVariable('$resource') +
        '/testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return TestPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates the specified BackendBucket resource with the data included in the
  /// request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [backendBucket] - Name of the BackendBucket resource to update.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> update(
    BackendBucket request,
    core.String project,
    core.String backendBucket, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/backendBuckets/' +
        commons.escapeVariable('$backendBucket');

    final response_ = await _requester.request(
      url_,
      'PUT',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }
}

class BackendServicesResource {
  final commons.ApiRequester _requester;

  BackendServicesResource(commons.ApiRequester client) : _requester = client;

  /// Adds a key for validating requests with signed URLs for this backend
  /// service.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [backendService] - Name of the BackendService resource to which the Signed
  /// URL Key should be added. The name should conform to RFC1035.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> addSignedUrlKey(
    SignedUrlKey request,
    core.String project,
    core.String backendService, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/backendServices/' +
        commons.escapeVariable('$backendService') +
        '/addSignedUrlKey';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves the list of all BackendService resources, regional and global,
  /// available to the specified project.
  ///
  /// To prevent failure, Google recommends that you set the
  /// `returnPartialSuccess` parameter to `true`.
  ///
  /// Request parameters:
  ///
  /// [project] - Name of the project scoping this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [includeAllScopes] - Indicates whether every visible scope for each scope
  /// type (zone, region, global) should be included in the response. For new
  /// resource types added after this field, the flag has no effect as new
  /// resource types will always include every visible scope for each scope type
  /// in response. For resource types which predate this field, if this flag is
  /// omitted or false, only scopes of the scope types where the resource type
  /// is expected to be found will be included.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [serviceProjectNumber] - The Shared VPC service project id or service
  /// project number for which aggregated list request is invoked for
  /// subnetworks list-usable api.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [BackendServiceAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<BackendServiceAggregatedList> aggregatedList(
    core.String project, {
    core.String? filter,
    core.bool? includeAllScopes,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? serviceProjectNumber,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (includeAllScopes != null) 'includeAllScopes': ['${includeAllScopes}'],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if (serviceProjectNumber != null)
        'serviceProjectNumber': [serviceProjectNumber],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/aggregated/backendServices';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return BackendServiceAggregatedList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes the specified BackendService resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [backendService] - Name of the BackendService resource to delete.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
    core.String project,
    core.String backendService, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/backendServices/' +
        commons.escapeVariable('$backendService');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a key for validating requests with signed URLs for this backend
  /// service.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [backendService] - Name of the BackendService resource to which the Signed
  /// URL Key should be added. The name should conform to RFC1035.
  ///
  /// [keyName] - The name of the Signed URL Key to delete.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> deleteSignedUrlKey(
    core.String project,
    core.String backendService,
    core.String keyName, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      'keyName': [keyName],
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/backendServices/' +
        commons.escapeVariable('$backendService') +
        '/deleteSignedUrlKey';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the specified BackendService resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [backendService] - Name of the BackendService resource to return.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [BackendService].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<BackendService> get(
    core.String project,
    core.String backendService, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/backendServices/' +
        commons.escapeVariable('$backendService');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return BackendService.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the most recent health check results for this BackendService.
  ///
  /// Example request body: { "group":
  /// "/zones/us-east1-b/instanceGroups/lb-backend-example" }
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - null
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [backendService] - Name of the BackendService resource to which the
  /// queried instance belongs.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [BackendServiceGroupHealth].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<BackendServiceGroupHealth> getHealth(
    ResourceGroupReference request,
    core.String project,
    core.String backendService, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/backendServices/' +
        commons.escapeVariable('$backendService') +
        '/getHealth';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return BackendServiceGroupHealth.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the access control policy for a resource.
  ///
  /// May be empty if no such policy or resource exists.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9_\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [optionsRequestedPolicyVersion] - Requested IAM Policy version.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> getIamPolicy(
    core.String project,
    core.String resource, {
    core.int? optionsRequestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (optionsRequestedPolicyVersion != null)
        'optionsRequestedPolicyVersion': ['${optionsRequestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/backendServices/' +
        commons.escapeVariable('$resource') +
        '/getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Policy.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates a BackendService resource in the specified project using the data
  /// included in the request.
  ///
  /// For more information, see Backend services overview .
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
    BackendService request,
    core.String project, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/backendServices';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves the list of BackendService resources available to the specified
  /// project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [BackendServiceList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<BackendServiceList> list(
    core.String project, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/backendServices';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return BackendServiceList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves a list of all usable backend services in the specified project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [BackendServiceListUsable].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<BackendServiceListUsable> listUsable(
    core.String project, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/backendServices/listUsable';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return BackendServiceListUsable.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Patches the specified BackendService resource with the data included in
  /// the request.
  ///
  /// For more information, see Backend services overview. This method supports
  /// PATCH semantics and uses the JSON merge patch format and processing rules.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [backendService] - Name of the BackendService resource to patch.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> patch(
    BackendService request,
    core.String project,
    core.String backendService, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/backendServices/' +
        commons.escapeVariable('$backendService');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the edge security policy for the specified backend service.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [backendService] - Name of the BackendService resource to which the edge
  /// security policy should be set. The name should conform to RFC1035.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setEdgeSecurityPolicy(
    SecurityPolicyReference request,
    core.String project,
    core.String backendService, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/backendServices/' +
        commons.escapeVariable('$backendService') +
        '/setEdgeSecurityPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified resource.
  ///
  /// Replaces any existing policy.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9_\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> setIamPolicy(
    GlobalSetPolicyRequest request,
    core.String project,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/backendServices/' +
        commons.escapeVariable('$resource') +
        '/setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Policy.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the Google Cloud Armor security policy for the specified backend
  /// service.
  ///
  /// For more information, see Google Cloud Armor Overview
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [backendService] - Name of the BackendService resource to which the
  /// security policy should be set. The name should conform to RFC1035.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setSecurityPolicy(
    SecurityPolicyReference request,
    core.String project,
    core.String backendService, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/backendServices/' +
        commons.escapeVariable('$backendService') +
        '/setSecurityPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9_\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [TestPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<TestPermissionsResponse> testIamPermissions(
    TestPermissionsRequest request,
    core.String project,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/backendServices/' +
        commons.escapeVariable('$resource') +
        '/testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return TestPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates the specified BackendService resource with the data included in
  /// the request.
  ///
  /// For more information, see Backend services overview.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [backendService] - Name of the BackendService resource to update.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> update(
    BackendService request,
    core.String project,
    core.String backendService, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/backendServices/' +
        commons.escapeVariable('$backendService');

    final response_ = await _requester.request(
      url_,
      'PUT',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }
}

class DiskTypesResource {
  final commons.ApiRequester _requester;

  DiskTypesResource(commons.ApiRequester client) : _requester = client;

  /// Retrieves an aggregated list of disk types.
  ///
  /// To prevent failure, Google recommends that you set the
  /// `returnPartialSuccess` parameter to `true`.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [includeAllScopes] - Indicates whether every visible scope for each scope
  /// type (zone, region, global) should be included in the response. For new
  /// resource types added after this field, the flag has no effect as new
  /// resource types will always include every visible scope for each scope type
  /// in response. For resource types which predate this field, if this flag is
  /// omitted or false, only scopes of the scope types where the resource type
  /// is expected to be found will be included.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [serviceProjectNumber] - The Shared VPC service project id or service
  /// project number for which aggregated list request is invoked for
  /// subnetworks list-usable api.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [DiskTypeAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<DiskTypeAggregatedList> aggregatedList(
    core.String project, {
    core.String? filter,
    core.bool? includeAllScopes,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? serviceProjectNumber,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (includeAllScopes != null) 'includeAllScopes': ['${includeAllScopes}'],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if (serviceProjectNumber != null)
        'serviceProjectNumber': [serviceProjectNumber],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/aggregated/diskTypes';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return DiskTypeAggregatedList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the specified disk type.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [diskType] - Name of the disk type to return.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [DiskType].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<DiskType> get(
    core.String project,
    core.String zone,
    core.String diskType, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/diskTypes/' +
        commons.escapeVariable('$diskType');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return DiskType.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves a list of disk types available to the specified project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [DiskTypeList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<DiskTypeList> list(
    core.String project,
    core.String zone, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/diskTypes';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return DiskTypeList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class DisksResource {
  final commons.ApiRequester _requester;

  DisksResource(commons.ApiRequester client) : _requester = client;

  /// Adds existing resource policies to a disk.
  ///
  /// You can only add one policy which will be applied to this disk for
  /// scheduling snapshot creation.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [disk] - The disk name for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> addResourcePolicies(
    DisksAddResourcePoliciesRequest request,
    core.String project,
    core.String zone,
    core.String disk, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/disks/' +
        commons.escapeVariable('$disk') +
        '/addResourcePolicies';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves an aggregated list of persistent disks.
  ///
  /// To prevent failure, Google recommends that you set the
  /// `returnPartialSuccess` parameter to `true`.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [includeAllScopes] - Indicates whether every visible scope for each scope
  /// type (zone, region, global) should be included in the response. For new
  /// resource types added after this field, the flag has no effect as new
  /// resource types will always include every visible scope for each scope type
  /// in response. For resource types which predate this field, if this flag is
  /// omitted or false, only scopes of the scope types where the resource type
  /// is expected to be found will be included.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [serviceProjectNumber] - The Shared VPC service project id or service
  /// project number for which aggregated list request is invoked for
  /// subnetworks list-usable api.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [DiskAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<DiskAggregatedList> aggregatedList(
    core.String project, {
    core.String? filter,
    core.bool? includeAllScopes,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? serviceProjectNumber,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (includeAllScopes != null) 'includeAllScopes': ['${includeAllScopes}'],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if (serviceProjectNumber != null)
        'serviceProjectNumber': [serviceProjectNumber],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'projects/' + commons.escapeVariable('$project') + '/aggregated/disks';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return DiskAggregatedList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Bulk create a set of disks.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> bulkInsert(
    BulkInsertDiskResource request,
    core.String project,
    core.String zone, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/disks/bulkInsert';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates a snapshot of a specified persistent disk.
  ///
  /// For regular snapshot creation, consider using snapshots.insert instead, as
  /// that method supports more features, such as creating snapshots in a
  /// project different from the source disk project.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [disk] - Name of the persistent disk to snapshot.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [guestFlush] - \[Input Only\] Whether to attempt an application consistent
  /// snapshot by informing the OS to prepare for the snapshot process.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> createSnapshot(
    Snapshot request,
    core.String project,
    core.String zone,
    core.String disk, {
    core.bool? guestFlush,
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (guestFlush != null) 'guestFlush': ['${guestFlush}'],
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/disks/' +
        commons.escapeVariable('$disk') +
        '/createSnapshot';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes the specified persistent disk.
  ///
  /// Deleting a disk removes its data permanently and is irreversible. However,
  /// deleting a disk does not delete any snapshots previously made from the
  /// disk. You must separately delete snapshots.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [disk] - Name of the persistent disk to delete.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
    core.String project,
    core.String zone,
    core.String disk, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/disks/' +
        commons.escapeVariable('$disk');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the specified persistent disk.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [disk] - Name of the persistent disk to return.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Disk].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Disk> get(
    core.String project,
    core.String zone,
    core.String disk, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/disks/' +
        commons.escapeVariable('$disk');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Disk.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the access control policy for a resource.
  ///
  /// May be empty if no such policy or resource exists.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [optionsRequestedPolicyVersion] - Requested IAM Policy version.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> getIamPolicy(
    core.String project,
    core.String zone,
    core.String resource, {
    core.int? optionsRequestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (optionsRequestedPolicyVersion != null)
        'optionsRequestedPolicyVersion': ['${optionsRequestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/disks/' +
        commons.escapeVariable('$resource') +
        '/getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Policy.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates a persistent disk in the specified project using the data in the
  /// request.
  ///
  /// You can create a disk from a source (sourceImage, sourceSnapshot, or
  /// sourceDisk) or create an empty 500 GB data disk by omitting all
  /// properties. You can also create a disk that is larger than the default
  /// size by specifying the sizeGb property.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [sourceImage] - Source image to restore onto a disk. This field is
  /// optional.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
    Disk request,
    core.String project,
    core.String zone, {
    core.String? requestId,
    core.String? sourceImage,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if (sourceImage != null) 'sourceImage': [sourceImage],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/disks';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves a list of persistent disks contained within the specified zone.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [DiskList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<DiskList> list(
    core.String project,
    core.String zone, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/disks';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return DiskList.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Removes resource policies from a disk.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [disk] - The disk name for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> removeResourcePolicies(
    DisksRemoveResourcePoliciesRequest request,
    core.String project,
    core.String zone,
    core.String disk, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/disks/' +
        commons.escapeVariable('$disk') +
        '/removeResourcePolicies';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Resizes the specified persistent disk.
  ///
  /// You can only increase the size of the disk.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [disk] - The name of the persistent disk.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> resize(
    DisksResizeRequest request,
    core.String project,
    core.String zone,
    core.String disk, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/disks/' +
        commons.escapeVariable('$disk') +
        '/resize';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified resource.
  ///
  /// Replaces any existing policy.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> setIamPolicy(
    ZoneSetPolicyRequest request,
    core.String project,
    core.String zone,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/disks/' +
        commons.escapeVariable('$resource') +
        '/setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Policy.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the labels on a disk.
  ///
  /// To learn more about labels, read the Labeling Resources documentation.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setLabels(
    ZoneSetLabelsRequest request,
    core.String project,
    core.String zone,
    core.String resource, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/disks/' +
        commons.escapeVariable('$resource') +
        '/setLabels';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Starts asynchronous replication.
  ///
  /// Must be invoked on the primary disk.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [disk] - The name of the persistent disk.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> startAsyncReplication(
    DisksStartAsyncReplicationRequest request,
    core.String project,
    core.String zone,
    core.String disk, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/disks/' +
        commons.escapeVariable('$disk') +
        '/startAsyncReplication';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Stops asynchronous replication.
  ///
  /// Can be invoked either on the primary or on the secondary disk.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [disk] - The name of the persistent disk.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> stopAsyncReplication(
    core.String project,
    core.String zone,
    core.String disk, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/disks/' +
        commons.escapeVariable('$disk') +
        '/stopAsyncReplication';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Stops asynchronous replication for a consistency group of disks.
  ///
  /// Can be invoked either in the primary or secondary scope.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request. This must be the zone of
  /// the primary or secondary disks in the consistency group.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> stopGroupAsyncReplication(
    DisksStopGroupAsyncReplicationResource request,
    core.String project,
    core.String zone, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/disks/stopGroupAsyncReplication';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [TestPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<TestPermissionsResponse> testIamPermissions(
    TestPermissionsRequest request,
    core.String project,
    core.String zone,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/disks/' +
        commons.escapeVariable('$resource') +
        '/testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return TestPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates the specified disk with the data included in the request.
  ///
  /// The update is performed only on selected fields included as part of
  /// update-mask. Only the following fields can be modified: user_license.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [disk] - The disk name for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [paths] - null
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [updateMask] - update_mask indicates fields to be updated as part of this
  /// request.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> update(
    Disk request,
    core.String project,
    core.String zone,
    core.String disk, {
    core.List<core.String>? paths,
    core.String? requestId,
    core.String? updateMask,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (paths != null) 'paths': paths,
      if (requestId != null) 'requestId': [requestId],
      if (updateMask != null) 'updateMask': [updateMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/disks/' +
        commons.escapeVariable('$disk');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }
}

class ExternalVpnGatewaysResource {
  final commons.ApiRequester _requester;

  ExternalVpnGatewaysResource(commons.ApiRequester client)
      : _requester = client;

  /// Deletes the specified externalVpnGateway.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [externalVpnGateway] - Name of the externalVpnGateways to delete.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
    core.String project,
    core.String externalVpnGateway, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/externalVpnGateways/' +
        commons.escapeVariable('$externalVpnGateway');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the specified externalVpnGateway.
  ///
  /// Get a list of available externalVpnGateways by making a list() request.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [externalVpnGateway] - Name of the externalVpnGateway to return.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ExternalVpnGateway].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ExternalVpnGateway> get(
    core.String project,
    core.String externalVpnGateway, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/externalVpnGateways/' +
        commons.escapeVariable('$externalVpnGateway');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ExternalVpnGateway.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates a ExternalVpnGateway in the specified project using the data
  /// included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
    ExternalVpnGateway request,
    core.String project, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/externalVpnGateways';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves the list of ExternalVpnGateway available to the specified
  /// project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ExternalVpnGatewayList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ExternalVpnGatewayList> list(
    core.String project, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/externalVpnGateways';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ExternalVpnGatewayList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the labels on an ExternalVpnGateway.
  ///
  /// To learn more about labels, read the Labeling Resources documentation.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9_\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setLabels(
    GlobalSetLabelsRequest request,
    core.String project,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/externalVpnGateways/' +
        commons.escapeVariable('$resource') +
        '/setLabels';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9_\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [TestPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<TestPermissionsResponse> testIamPermissions(
    TestPermissionsRequest request,
    core.String project,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/externalVpnGateways/' +
        commons.escapeVariable('$resource') +
        '/testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return TestPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class FirewallPoliciesResource {
  final commons.ApiRequester _requester;

  FirewallPoliciesResource(commons.ApiRequester client) : _requester = client;

  /// Inserts an association for the specified firewall policy.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [firewallPolicy] - Name of the firewall policy to update.
  /// Value must have pattern `(firewallPolicies/)?\[0-9\]{0,20}`.
  ///
  /// [replaceExistingAssociation] - Indicates whether or not to replace it if
  /// an association of the attachment already exists. This is false by default,
  /// in which case an error will be returned if an association already exists.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> addAssociation(
    FirewallPolicyAssociation request,
    core.String firewallPolicy, {
    core.bool? replaceExistingAssociation,
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (replaceExistingAssociation != null)
        'replaceExistingAssociation': ['${replaceExistingAssociation}'],
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'locations/global/firewallPolicies/' +
        commons.escapeVariable('$firewallPolicy') +
        '/addAssociation';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Inserts a rule into a firewall policy.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [firewallPolicy] - Name of the firewall policy to update.
  /// Value must have pattern `(firewallPolicies/)?\[0-9\]{0,20}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> addRule(
    FirewallPolicyRule request,
    core.String firewallPolicy, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'locations/global/firewallPolicies/' +
        commons.escapeVariable('$firewallPolicy') +
        '/addRule';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Copies rules to the specified firewall policy.
  ///
  /// Request parameters:
  ///
  /// [firewallPolicy] - Name of the firewall policy to update.
  /// Value must have pattern `(firewallPolicies/)?\[0-9\]{0,20}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [sourceFirewallPolicy] - The firewall policy from which to copy rules.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> cloneRules(
    core.String firewallPolicy, {
    core.String? requestId,
    core.String? sourceFirewallPolicy,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if (sourceFirewallPolicy != null)
        'sourceFirewallPolicy': [sourceFirewallPolicy],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'locations/global/firewallPolicies/' +
        commons.escapeVariable('$firewallPolicy') +
        '/cloneRules';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes the specified policy.
  ///
  /// Request parameters:
  ///
  /// [firewallPolicy] - Name of the firewall policy to delete.
  /// Value must have pattern `(firewallPolicies/)?\[0-9\]{0,20}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
    core.String firewallPolicy, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'locations/global/firewallPolicies/' +
        commons.escapeVariable('$firewallPolicy');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the specified firewall policy.
  ///
  /// Request parameters:
  ///
  /// [firewallPolicy] - Name of the firewall policy to get.
  /// Value must have pattern `(firewallPolicies/)?\[0-9\]{0,20}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [FirewallPolicy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<FirewallPolicy> get(
    core.String firewallPolicy, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'locations/global/firewallPolicies/' +
        commons.escapeVariable('$firewallPolicy');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return FirewallPolicy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets an association with the specified name.
  ///
  /// Request parameters:
  ///
  /// [firewallPolicy] - Name of the firewall policy to which the queried rule
  /// belongs.
  /// Value must have pattern `(firewallPolicies/)?\[0-9\]{0,20}`.
  ///
  /// [name] - The name of the association to get from the firewall policy.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [FirewallPolicyAssociation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<FirewallPolicyAssociation> getAssociation(
    core.String firewallPolicy, {
    core.String? name,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (name != null) 'name': [name],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'locations/global/firewallPolicies/' +
        commons.escapeVariable('$firewallPolicy') +
        '/getAssociation';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return FirewallPolicyAssociation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the access control policy for a resource.
  ///
  /// May be empty if no such policy or resource exists.
  ///
  /// Request parameters:
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern `(firewallPolicies/)?\[0-9\]{0,20}`.
  ///
  /// [optionsRequestedPolicyVersion] - Requested IAM Policy version.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> getIamPolicy(
    core.String resource, {
    core.int? optionsRequestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (optionsRequestedPolicyVersion != null)
        'optionsRequestedPolicyVersion': ['${optionsRequestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'locations/global/firewallPolicies/' +
        commons.escapeVariable('$resource') +
        '/getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Policy.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets a rule of the specified priority.
  ///
  /// Request parameters:
  ///
  /// [firewallPolicy] - Name of the firewall policy to which the queried rule
  /// belongs.
  /// Value must have pattern `(firewallPolicies/)?\[0-9\]{0,20}`.
  ///
  /// [priority] - The priority of the rule to get from the firewall policy.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [FirewallPolicyRule].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<FirewallPolicyRule> getRule(
    core.String firewallPolicy, {
    core.int? priority,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (priority != null) 'priority': ['${priority}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'locations/global/firewallPolicies/' +
        commons.escapeVariable('$firewallPolicy') +
        '/getRule';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return FirewallPolicyRule.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates a new policy in the specified project using the data included in
  /// the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parentId] - Parent ID for this request. The ID can be either be
  /// "folders/\[FOLDER_ID\]" if the parent is a folder or
  /// "organizations/\[ORGANIZATION_ID\]" if the parent is an organization.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
    FirewallPolicy request, {
    core.String? parentId,
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (parentId != null) 'parentId': [parentId],
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    const url_ = 'locations/global/firewallPolicies';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists all the policies that have been configured for the specified folder
  /// or organization.
  ///
  /// Request parameters:
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [parentId] - Parent ID for this request. The ID can be either be
  /// "folders/\[FOLDER_ID\]" if the parent is a folder or
  /// "organizations/\[ORGANIZATION_ID\]" if the parent is an organization.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [FirewallPolicyList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<FirewallPolicyList> list({
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.String? parentId,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (parentId != null) 'parentId': [parentId],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    const url_ = 'locations/global/firewallPolicies';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return FirewallPolicyList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists associations of a specified target, i.e., organization or folder.
  ///
  /// Request parameters:
  ///
  /// [targetResource] - The target resource to list associations. It is an
  /// organization, or a folder.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [FirewallPoliciesListAssociationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<FirewallPoliciesListAssociationsResponse> listAssociations({
    core.String? targetResource,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (targetResource != null) 'targetResource': [targetResource],
      if ($fields != null) 'fields': [$fields],
    };

    const url_ = 'locations/global/firewallPolicies/listAssociations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return FirewallPoliciesListAssociationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Moves the specified firewall policy.
  ///
  /// Request parameters:
  ///
  /// [firewallPolicy] - Name of the firewall policy to update.
  /// Value must have pattern `(firewallPolicies/)?\[0-9\]{0,20}`.
  ///
  /// [parentId] - The new parent of the firewall policy. The ID can be either
  /// be "folders/\[FOLDER_ID\]" if the parent is a folder or
  /// "organizations/\[ORGANIZATION_ID\]" if the parent is an organization.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> move(
    core.String firewallPolicy, {
    core.String? parentId,
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (parentId != null) 'parentId': [parentId],
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'locations/global/firewallPolicies/' +
        commons.escapeVariable('$firewallPolicy') +
        '/move';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Patches the specified policy with the data included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [firewallPolicy] - Name of the firewall policy to update.
  /// Value must have pattern `(firewallPolicies/)?\[0-9\]{0,20}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> patch(
    FirewallPolicy request,
    core.String firewallPolicy, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'locations/global/firewallPolicies/' +
        commons.escapeVariable('$firewallPolicy');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Patches a rule of the specified priority.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [firewallPolicy] - Name of the firewall policy to update.
  /// Value must have pattern `(firewallPolicies/)?\[0-9\]{0,20}`.
  ///
  /// [priority] - The priority of the rule to patch.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> patchRule(
    FirewallPolicyRule request,
    core.String firewallPolicy, {
    core.int? priority,
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (priority != null) 'priority': ['${priority}'],
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'locations/global/firewallPolicies/' +
        commons.escapeVariable('$firewallPolicy') +
        '/patchRule';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Removes an association for the specified firewall policy.
  ///
  /// Request parameters:
  ///
  /// [firewallPolicy] - Name of the firewall policy to update.
  /// Value must have pattern `(firewallPolicies/)?\[0-9\]{0,20}`.
  ///
  /// [name] - Name for the attachment that will be removed.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> removeAssociation(
    core.String firewallPolicy, {
    core.String? name,
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (name != null) 'name': [name],
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'locations/global/firewallPolicies/' +
        commons.escapeVariable('$firewallPolicy') +
        '/removeAssociation';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a rule of the specified priority.
  ///
  /// Request parameters:
  ///
  /// [firewallPolicy] - Name of the firewall policy to update.
  /// Value must have pattern `(firewallPolicies/)?\[0-9\]{0,20}`.
  ///
  /// [priority] - The priority of the rule to remove from the firewall policy.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> removeRule(
    core.String firewallPolicy, {
    core.int? priority,
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (priority != null) 'priority': ['${priority}'],
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'locations/global/firewallPolicies/' +
        commons.escapeVariable('$firewallPolicy') +
        '/removeRule';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified resource.
  ///
  /// Replaces any existing policy.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern `(firewallPolicies/)?\[0-9\]{0,20}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> setIamPolicy(
    GlobalOrganizationSetPolicyRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'locations/global/firewallPolicies/' +
        commons.escapeVariable('$resource') +
        '/setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Policy.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern `(firewallPolicies/)?\[0-9\]{0,20}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [TestPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<TestPermissionsResponse> testIamPermissions(
    TestPermissionsRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'locations/global/firewallPolicies/' +
        commons.escapeVariable('$resource') +
        '/testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return TestPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class FirewallsResource {
  final commons.ApiRequester _requester;

  FirewallsResource(commons.ApiRequester client) : _requester = client;

  /// Deletes the specified firewall.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [firewall] - Name of the firewall rule to delete.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
    core.String project,
    core.String firewall, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/firewalls/' +
        commons.escapeVariable('$firewall');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the specified firewall.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [firewall] - Name of the firewall rule to return.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Firewall].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Firewall> get(
    core.String project,
    core.String firewall, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/firewalls/' +
        commons.escapeVariable('$firewall');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Firewall.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates a firewall rule in the specified project using the data included
  /// in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
    Firewall request,
    core.String project, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'projects/' + commons.escapeVariable('$project') + '/global/firewalls';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves the list of firewall rules available to the specified project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [FirewallList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<FirewallList> list(
    core.String project, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'projects/' + commons.escapeVariable('$project') + '/global/firewalls';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return FirewallList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates the specified firewall rule with the data included in the request.
  ///
  /// This method supports PATCH semantics and uses the JSON merge patch format
  /// and processing rules.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [firewall] - Name of the firewall rule to patch.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> patch(
    Firewall request,
    core.String project,
    core.String firewall, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/firewalls/' +
        commons.escapeVariable('$firewall');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates the specified firewall rule with the data included in the request.
  ///
  /// Note that all fields will be updated if using PUT, even fields that are
  /// not specified. To update individual fields, please use PATCH instead.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [firewall] - Name of the firewall rule to update.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> update(
    Firewall request,
    core.String project,
    core.String firewall, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/firewalls/' +
        commons.escapeVariable('$firewall');

    final response_ = await _requester.request(
      url_,
      'PUT',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }
}

class ForwardingRulesResource {
  final commons.ApiRequester _requester;

  ForwardingRulesResource(commons.ApiRequester client) : _requester = client;

  /// Retrieves an aggregated list of forwarding rules.
  ///
  /// To prevent failure, Google recommends that you set the
  /// `returnPartialSuccess` parameter to `true`.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [includeAllScopes] - Indicates whether every visible scope for each scope
  /// type (zone, region, global) should be included in the response. For new
  /// resource types added after this field, the flag has no effect as new
  /// resource types will always include every visible scope for each scope type
  /// in response. For resource types which predate this field, if this flag is
  /// omitted or false, only scopes of the scope types where the resource type
  /// is expected to be found will be included.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [serviceProjectNumber] - The Shared VPC service project id or service
  /// project number for which aggregated list request is invoked for
  /// subnetworks list-usable api.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ForwardingRuleAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ForwardingRuleAggregatedList> aggregatedList(
    core.String project, {
    core.String? filter,
    core.bool? includeAllScopes,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? serviceProjectNumber,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (includeAllScopes != null) 'includeAllScopes': ['${includeAllScopes}'],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if (serviceProjectNumber != null)
        'serviceProjectNumber': [serviceProjectNumber],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/aggregated/forwardingRules';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ForwardingRuleAggregatedList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes the specified ForwardingRule resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [region] - Name of the region scoping this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [forwardingRule] - Name of the ForwardingRule resource to delete.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
    core.String project,
    core.String region,
    core.String forwardingRule, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/regions/' +
        commons.escapeVariable('$region') +
        '/forwardingRules/' +
        commons.escapeVariable('$forwardingRule');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the specified ForwardingRule resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [region] - Name of the region scoping this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [forwardingRule] - Name of the ForwardingRule resource to return.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ForwardingRule].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ForwardingRule> get(
    core.String project,
    core.String region,
    core.String forwardingRule, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/regions/' +
        commons.escapeVariable('$region') +
        '/forwardingRules/' +
        commons.escapeVariable('$forwardingRule');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ForwardingRule.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates a ForwardingRule resource in the specified project and region
  /// using the data included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [region] - Name of the region scoping this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
    ForwardingRule request,
    core.String project,
    core.String region, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/regions/' +
        commons.escapeVariable('$region') +
        '/forwardingRules';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves a list of ForwardingRule resources available to the specified
  /// project and region.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [region] - Name of the region scoping this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ForwardingRuleList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ForwardingRuleList> list(
    core.String project,
    core.String region, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/regions/' +
        commons.escapeVariable('$region') +
        '/forwardingRules';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ForwardingRuleList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates the specified forwarding rule with the data included in the
  /// request.
  ///
  /// This method supports PATCH semantics and uses the JSON merge patch format
  /// and processing rules. Currently, you can only patch the network_tier
  /// field.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [region] - Name of the region scoping this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [forwardingRule] - Name of the ForwardingRule resource to patch.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> patch(
    ForwardingRule request,
    core.String project,
    core.String region,
    core.String forwardingRule, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/regions/' +
        commons.escapeVariable('$region') +
        '/forwardingRules/' +
        commons.escapeVariable('$forwardingRule');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the labels on the specified resource.
  ///
  /// To learn more about labels, read the Labeling Resources documentation.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [region] - The region for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setLabels(
    RegionSetLabelsRequest request,
    core.String project,
    core.String region,
    core.String resource, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/regions/' +
        commons.escapeVariable('$region') +
        '/forwardingRules/' +
        commons.escapeVariable('$resource') +
        '/setLabels';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Changes target URL for forwarding rule.
  ///
  /// The new target should be of the same type as the old target.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [region] - Name of the region scoping this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [forwardingRule] - Name of the ForwardingRule resource in which target is
  /// to be set.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setTarget(
    TargetReference request,
    core.String project,
    core.String region,
    core.String forwardingRule, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/regions/' +
        commons.escapeVariable('$region') +
        '/forwardingRules/' +
        commons.escapeVariable('$forwardingRule') +
        '/setTarget';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }
}

class GlobalAddressesResource {
  final commons.ApiRequester _requester;

  GlobalAddressesResource(commons.ApiRequester client) : _requester = client;

  /// Deletes the specified address resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [address] - Name of the address resource to delete.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
    core.String project,
    core.String address, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/addresses/' +
        commons.escapeVariable('$address');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the specified address resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [address] - Name of the address resource to return.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Address].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Address> get(
    core.String project,
    core.String address, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/addresses/' +
        commons.escapeVariable('$address');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Address.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates an address resource in the specified project by using the data
  /// included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
    Address request,
    core.String project, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'projects/' + commons.escapeVariable('$project') + '/global/addresses';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves a list of global addresses.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [AddressList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<AddressList> list(
    core.String project, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'projects/' + commons.escapeVariable('$project') + '/global/addresses';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return AddressList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Moves the specified address resource from one project to another project.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Source project ID which the Address is moved from.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [address] - Name of the address resource to move.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> move(
    GlobalAddressesMoveRequest request,
    core.String project,
    core.String address, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/addresses/' +
        commons.escapeVariable('$address') +
        '/move';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the labels on a GlobalAddress.
  ///
  /// To learn more about labels, read the Labeling Resources documentation.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9_\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setLabels(
    GlobalSetLabelsRequest request,
    core.String project,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/addresses/' +
        commons.escapeVariable('$resource') +
        '/setLabels';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }
}

class GlobalForwardingRulesResource {
  final commons.ApiRequester _requester;

  GlobalForwardingRulesResource(commons.ApiRequester client)
      : _requester = client;

  /// Deletes the specified GlobalForwardingRule resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [forwardingRule] - Name of the ForwardingRule resource to delete.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
    core.String project,
    core.String forwardingRule, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/forwardingRules/' +
        commons.escapeVariable('$forwardingRule');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the specified GlobalForwardingRule resource.
  ///
  /// Gets a list of available forwarding rules by making a list() request.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [forwardingRule] - Name of the ForwardingRule resource to return.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ForwardingRule].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ForwardingRule> get(
    core.String project,
    core.String forwardingRule, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/forwardingRules/' +
        commons.escapeVariable('$forwardingRule');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ForwardingRule.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates a GlobalForwardingRule resource in the specified project using the
  /// data included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
    ForwardingRule request,
    core.String project, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/forwardingRules';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves a list of GlobalForwardingRule resources available to the
  /// specified project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ForwardingRuleList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ForwardingRuleList> list(
    core.String project, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/forwardingRules';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ForwardingRuleList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates the specified forwarding rule with the data included in the
  /// request.
  ///
  /// This method supports PATCH semantics and uses the JSON merge patch format
  /// and processing rules. Currently, you can only patch the network_tier
  /// field.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [forwardingRule] - Name of the ForwardingRule resource to patch.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> patch(
    ForwardingRule request,
    core.String project,
    core.String forwardingRule, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/forwardingRules/' +
        commons.escapeVariable('$forwardingRule');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the labels on the specified resource.
  ///
  /// To learn more about labels, read the Labeling resources documentation.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9_\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setLabels(
    GlobalSetLabelsRequest request,
    core.String project,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/forwardingRules/' +
        commons.escapeVariable('$resource') +
        '/setLabels';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Changes target URL for the GlobalForwardingRule resource.
  ///
  /// The new target should be of the same type as the old target.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [forwardingRule] - Name of the ForwardingRule resource in which target is
  /// to be set.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setTarget(
    TargetReference request,
    core.String project,
    core.String forwardingRule, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/forwardingRules/' +
        commons.escapeVariable('$forwardingRule') +
        '/setTarget';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }
}

class GlobalNetworkEndpointGroupsResource {
  final commons.ApiRequester _requester;

  GlobalNetworkEndpointGroupsResource(commons.ApiRequester client)
      : _requester = client;

  /// Attach a network endpoint to the specified network endpoint group.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [networkEndpointGroup] - The name of the network endpoint group where you
  /// are attaching network endpoints to. It should comply with RFC1035.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> attachNetworkEndpoints(
    GlobalNetworkEndpointGroupsAttachEndpointsRequest request,
    core.String project,
    core.String networkEndpointGroup, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/networkEndpointGroups/' +
        commons.escapeVariable('$networkEndpointGroup') +
        '/attachNetworkEndpoints';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes the specified network endpoint group.Note that the NEG cannot be
  /// deleted if there are backend services referencing it.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [networkEndpointGroup] - The name of the network endpoint group to delete.
  /// It should comply with RFC1035.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
    core.String project,
    core.String networkEndpointGroup, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/networkEndpointGroups/' +
        commons.escapeVariable('$networkEndpointGroup');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Detach the network endpoint from the specified network endpoint group.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [networkEndpointGroup] - The name of the network endpoint group where you
  /// are removing network endpoints. It should comply with RFC1035.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> detachNetworkEndpoints(
    GlobalNetworkEndpointGroupsDetachEndpointsRequest request,
    core.String project,
    core.String networkEndpointGroup, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/networkEndpointGroups/' +
        commons.escapeVariable('$networkEndpointGroup') +
        '/detachNetworkEndpoints';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the specified network endpoint group.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [networkEndpointGroup] - The name of the network endpoint group. It should
  /// comply with RFC1035.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [NetworkEndpointGroup].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<NetworkEndpointGroup> get(
    core.String project,
    core.String networkEndpointGroup, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/networkEndpointGroups/' +
        commons.escapeVariable('$networkEndpointGroup');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return NetworkEndpointGroup.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates a network endpoint group in the specified project using the
  /// parameters that are included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
    NetworkEndpointGroup request,
    core.String project, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/networkEndpointGroups';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves the list of network endpoint groups that are located in the
  /// specified project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [NetworkEndpointGroupList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<NetworkEndpointGroupList> list(
    core.String project, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/networkEndpointGroups';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return NetworkEndpointGroupList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists the network endpoints in the specified network endpoint group.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [networkEndpointGroup] - The name of the network endpoint group from which
  /// you want to generate a list of included network endpoints. It should
  /// comply with RFC1035.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [NetworkEndpointGroupsListNetworkEndpoints].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<NetworkEndpointGroupsListNetworkEndpoints> listNetworkEndpoints(
    core.String project,
    core.String networkEndpointGroup, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/networkEndpointGroups/' +
        commons.escapeVariable('$networkEndpointGroup') +
        '/listNetworkEndpoints';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return NetworkEndpointGroupsListNetworkEndpoints.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class GlobalOperationsResource {
  final commons.ApiRequester _requester;

  GlobalOperationsResource(commons.ApiRequester client) : _requester = client;

  /// Retrieves an aggregated list of all operations.
  ///
  /// To prevent failure, Google recommends that you set the
  /// `returnPartialSuccess` parameter to `true`.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [includeAllScopes] - Indicates whether every visible scope for each scope
  /// type (zone, region, global) should be included in the response. For new
  /// resource types added after this field, the flag has no effect as new
  /// resource types will always include every visible scope for each scope type
  /// in response. For resource types which predate this field, if this flag is
  /// omitted or false, only scopes of the scope types where the resource type
  /// is expected to be found will be included.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [serviceProjectNumber] - The Shared VPC service project id or service
  /// project number for which aggregated list request is invoked for
  /// subnetworks list-usable api.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OperationAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OperationAggregatedList> aggregatedList(
    core.String project, {
    core.String? filter,
    core.bool? includeAllScopes,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? serviceProjectNumber,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (includeAllScopes != null) 'includeAllScopes': ['${includeAllScopes}'],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if (serviceProjectNumber != null)
        'serviceProjectNumber': [serviceProjectNumber],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/aggregated/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return OperationAggregatedList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes the specified Operations resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [operation] - Name of the Operations resource to delete, or its unique
  /// numeric identifier.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<void> delete(
    core.String project,
    core.String operation, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/operations/' +
        commons.escapeVariable('$operation');

    await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
      downloadOptions: null,
    );
  }

  /// Retrieves the specified Operations resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [operation] - Name of the Operations resource to return, or its unique
  /// numeric identifier.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> get(
    core.String project,
    core.String operation, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/operations/' +
        commons.escapeVariable('$operation');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves a list of Operation resources contained within the specified
  /// project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OperationList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OperationList> list(
    core.String project, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'projects/' + commons.escapeVariable('$project') + '/global/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return OperationList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits for the specified Operation resource to return as `DONE` or for the
  /// request to approach the 2 minute deadline, and retrieves the specified
  /// Operation resource.
  ///
  /// This method differs from the `GET` method in that it waits for no more
  /// than the default deadline (2 minutes) and then returns the current state
  /// of the operation, which might be `DONE` or still in progress. This method
  /// is called on a best-effort basis. Specifically: - In uncommon cases, when
  /// the server is overloaded, the request might return before the default
  /// deadline is reached, or might return after zero seconds. - If the default
  /// deadline is reached, there is no guarantee that the operation is actually
  /// done when the method returns. Be prepared to retry if the operation is not
  /// `DONE`.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [operation] - Name of the Operations resource to return, or its unique
  /// numeric identifier.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> wait(
    core.String project,
    core.String operation, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/operations/' +
        commons.escapeVariable('$operation') +
        '/wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }
}

class GlobalOrganizationOperationsResource {
  final commons.ApiRequester _requester;

  GlobalOrganizationOperationsResource(commons.ApiRequester client)
      : _requester = client;

  /// Deletes the specified Operations resource.
  ///
  /// Request parameters:
  ///
  /// [operation] - Name of the Operations resource to delete, or its unique
  /// numeric identifier.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [parentId] - Parent ID for this request.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<void> delete(
    core.String operation, {
    core.String? parentId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (parentId != null) 'parentId': [parentId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'locations/global/operations/' + commons.escapeVariable('$operation');

    await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
      downloadOptions: null,
    );
  }

  /// Retrieves the specified Operations resource.
  ///
  /// Gets a list of operations by making a `list()` request.
  ///
  /// Request parameters:
  ///
  /// [operation] - Name of the Operations resource to return, or its unique
  /// numeric identifier.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [parentId] - Parent ID for this request.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> get(
    core.String operation, {
    core.String? parentId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (parentId != null) 'parentId': [parentId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'locations/global/operations/' + commons.escapeVariable('$operation');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves a list of Operation resources contained within the specified
  /// organization.
  ///
  /// Request parameters:
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [parentId] - Parent ID for this request.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [OperationList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<OperationList> list({
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.String? parentId,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (parentId != null) 'parentId': [parentId],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    const url_ = 'locations/global/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return OperationList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class GlobalPublicDelegatedPrefixesResource {
  final commons.ApiRequester _requester;

  GlobalPublicDelegatedPrefixesResource(commons.ApiRequester client)
      : _requester = client;

  /// Deletes the specified global PublicDelegatedPrefix.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [publicDelegatedPrefix] - Name of the PublicDelegatedPrefix resource to
  /// delete.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
    core.String project,
    core.String publicDelegatedPrefix, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/publicDelegatedPrefixes/' +
        commons.escapeVariable('$publicDelegatedPrefix');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the specified global PublicDelegatedPrefix resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [publicDelegatedPrefix] - Name of the PublicDelegatedPrefix resource to
  /// return.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [PublicDelegatedPrefix].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<PublicDelegatedPrefix> get(
    core.String project,
    core.String publicDelegatedPrefix, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/publicDelegatedPrefixes/' +
        commons.escapeVariable('$publicDelegatedPrefix');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return PublicDelegatedPrefix.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates a global PublicDelegatedPrefix in the specified project using the
  /// parameters that are included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
    PublicDelegatedPrefix request,
    core.String project, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/publicDelegatedPrefixes';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists the global PublicDelegatedPrefixes for a project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [PublicDelegatedPrefixList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<PublicDelegatedPrefixList> list(
    core.String project, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/publicDelegatedPrefixes';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return PublicDelegatedPrefixList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Patches the specified global PublicDelegatedPrefix resource with the data
  /// included in the request.
  ///
  /// This method supports PATCH semantics and uses JSON merge patch format and
  /// processing rules.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [publicDelegatedPrefix] - Name of the PublicDelegatedPrefix resource to
  /// patch.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> patch(
    PublicDelegatedPrefix request,
    core.String project,
    core.String publicDelegatedPrefix, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/publicDelegatedPrefixes/' +
        commons.escapeVariable('$publicDelegatedPrefix');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }
}

class HealthChecksResource {
  final commons.ApiRequester _requester;

  HealthChecksResource(commons.ApiRequester client) : _requester = client;

  /// Retrieves the list of all HealthCheck resources, regional and global,
  /// available to the specified project.
  ///
  /// To prevent failure, Google recommends that you set the
  /// `returnPartialSuccess` parameter to `true`.
  ///
  /// Request parameters:
  ///
  /// [project] - Name of the project scoping this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [includeAllScopes] - Indicates whether every visible scope for each scope
  /// type (zone, region, global) should be included in the response. For new
  /// resource types added after this field, the flag has no effect as new
  /// resource types will always include every visible scope for each scope type
  /// in response. For resource types which predate this field, if this flag is
  /// omitted or false, only scopes of the scope types where the resource type
  /// is expected to be found will be included.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [serviceProjectNumber] - The Shared VPC service project id or service
  /// project number for which aggregated list request is invoked for
  /// subnetworks list-usable api.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [HealthChecksAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<HealthChecksAggregatedList> aggregatedList(
    core.String project, {
    core.String? filter,
    core.bool? includeAllScopes,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? serviceProjectNumber,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (includeAllScopes != null) 'includeAllScopes': ['${includeAllScopes}'],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if (serviceProjectNumber != null)
        'serviceProjectNumber': [serviceProjectNumber],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/aggregated/healthChecks';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return HealthChecksAggregatedList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes the specified HealthCheck resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [healthCheck] - Name of the HealthCheck resource to delete.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
    core.String project,
    core.String healthCheck, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/healthChecks/' +
        commons.escapeVariable('$healthCheck');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the specified HealthCheck resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [healthCheck] - Name of the HealthCheck resource to return.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [HealthCheck].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<HealthCheck> get(
    core.String project,
    core.String healthCheck, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/healthChecks/' +
        commons.escapeVariable('$healthCheck');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return HealthCheck.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates a HealthCheck resource in the specified project using the data
  /// included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
    HealthCheck request,
    core.String project, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/healthChecks';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves the list of HealthCheck resources available to the specified
  /// project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [HealthCheckList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<HealthCheckList> list(
    core.String project, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/healthChecks';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return HealthCheckList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates a HealthCheck resource in the specified project using the data
  /// included in the request.
  ///
  /// This method supports PATCH semantics and uses the JSON merge patch format
  /// and processing rules.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [healthCheck] - Name of the HealthCheck resource to patch.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> patch(
    HealthCheck request,
    core.String project,
    core.String healthCheck, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/healthChecks/' +
        commons.escapeVariable('$healthCheck');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates a HealthCheck resource in the specified project using the data
  /// included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [healthCheck] - Name of the HealthCheck resource to update.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> update(
    HealthCheck request,
    core.String project,
    core.String healthCheck, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/healthChecks/' +
        commons.escapeVariable('$healthCheck');

    final response_ = await _requester.request(
      url_,
      'PUT',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }
}

class HttpHealthChecksResource {
  final commons.ApiRequester _requester;

  HttpHealthChecksResource(commons.ApiRequester client) : _requester = client;

  /// Deletes the specified HttpHealthCheck resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [httpHealthCheck] - Name of the HttpHealthCheck resource to delete.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
    core.String project,
    core.String httpHealthCheck, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/httpHealthChecks/' +
        commons.escapeVariable('$httpHealthCheck');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the specified HttpHealthCheck resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [httpHealthCheck] - Name of the HttpHealthCheck resource to return.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [HttpHealthCheck].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<HttpHealthCheck> get(
    core.String project,
    core.String httpHealthCheck, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/httpHealthChecks/' +
        commons.escapeVariable('$httpHealthCheck');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return HttpHealthCheck.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates a HttpHealthCheck resource in the specified project using the data
  /// included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
    HttpHealthCheck request,
    core.String project, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/httpHealthChecks';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves the list of HttpHealthCheck resources available to the specified
  /// project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [HttpHealthCheckList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<HttpHealthCheckList> list(
    core.String project, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/httpHealthChecks';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return HttpHealthCheckList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates a HttpHealthCheck resource in the specified project using the data
  /// included in the request.
  ///
  /// This method supports PATCH semantics and uses the JSON merge patch format
  /// and processing rules.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [httpHealthCheck] - Name of the HttpHealthCheck resource to patch.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> patch(
    HttpHealthCheck request,
    core.String project,
    core.String httpHealthCheck, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/httpHealthChecks/' +
        commons.escapeVariable('$httpHealthCheck');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates a HttpHealthCheck resource in the specified project using the data
  /// included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [httpHealthCheck] - Name of the HttpHealthCheck resource to update.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> update(
    HttpHealthCheck request,
    core.String project,
    core.String httpHealthCheck, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/httpHealthChecks/' +
        commons.escapeVariable('$httpHealthCheck');

    final response_ = await _requester.request(
      url_,
      'PUT',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }
}

class HttpsHealthChecksResource {
  final commons.ApiRequester _requester;

  HttpsHealthChecksResource(commons.ApiRequester client) : _requester = client;

  /// Deletes the specified HttpsHealthCheck resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [httpsHealthCheck] - Name of the HttpsHealthCheck resource to delete.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
    core.String project,
    core.String httpsHealthCheck, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/httpsHealthChecks/' +
        commons.escapeVariable('$httpsHealthCheck');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the specified HttpsHealthCheck resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [httpsHealthCheck] - Name of the HttpsHealthCheck resource to return.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [HttpsHealthCheck].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<HttpsHealthCheck> get(
    core.String project,
    core.String httpsHealthCheck, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/httpsHealthChecks/' +
        commons.escapeVariable('$httpsHealthCheck');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return HttpsHealthCheck.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates a HttpsHealthCheck resource in the specified project using the
  /// data included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
    HttpsHealthCheck request,
    core.String project, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/httpsHealthChecks';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves the list of HttpsHealthCheck resources available to the
  /// specified project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [HttpsHealthCheckList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<HttpsHealthCheckList> list(
    core.String project, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/httpsHealthChecks';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return HttpsHealthCheckList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates a HttpsHealthCheck resource in the specified project using the
  /// data included in the request.
  ///
  /// This method supports PATCH semantics and uses the JSON merge patch format
  /// and processing rules.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [httpsHealthCheck] - Name of the HttpsHealthCheck resource to patch.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> patch(
    HttpsHealthCheck request,
    core.String project,
    core.String httpsHealthCheck, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/httpsHealthChecks/' +
        commons.escapeVariable('$httpsHealthCheck');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates a HttpsHealthCheck resource in the specified project using the
  /// data included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [httpsHealthCheck] - Name of the HttpsHealthCheck resource to update.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> update(
    HttpsHealthCheck request,
    core.String project,
    core.String httpsHealthCheck, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/httpsHealthChecks/' +
        commons.escapeVariable('$httpsHealthCheck');

    final response_ = await _requester.request(
      url_,
      'PUT',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }
}

class ImageFamilyViewsResource {
  final commons.ApiRequester _requester;

  ImageFamilyViewsResource(commons.ApiRequester client) : _requester = client;

  /// Returns the latest image that is part of an image family, is not
  /// deprecated and is rolled out in the specified zone.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [family] - Name of the image family to search for.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ImageFamilyView].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ImageFamilyView> get(
    core.String project,
    core.String zone,
    core.String family, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/imageFamilyViews/' +
        commons.escapeVariable('$family');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ImageFamilyView.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ImagesResource {
  final commons.ApiRequester _requester;

  ImagesResource(commons.ApiRequester client) : _requester = client;

  /// Deletes the specified image.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [image] - Name of the image resource to delete.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
    core.String project,
    core.String image, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/images/' +
        commons.escapeVariable('$image');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the deprecation status of an image.
  ///
  /// If an empty request body is given, clears the deprecation status instead.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [image] - Image name.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> deprecate(
    DeprecationStatus request,
    core.String project,
    core.String image, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/images/' +
        commons.escapeVariable('$image') +
        '/deprecate';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the specified image.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [image] - Name of the image resource to return.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Image].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Image> get(
    core.String project,
    core.String image, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/images/' +
        commons.escapeVariable('$image');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Image.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the latest image that is part of an image family and is not
  /// deprecated.
  ///
  /// For more information on image families, see Public image families
  /// documentation.
  ///
  /// Request parameters:
  ///
  /// [project] - The image project that the image belongs to. For example, to
  /// get a CentOS image, specify centos-cloud as the image project.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [family] - Name of the image family to search for.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Image].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Image> getFromFamily(
    core.String project,
    core.String family, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/images/family/' +
        commons.escapeVariable('$family');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Image.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the access control policy for a resource.
  ///
  /// May be empty if no such policy or resource exists.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9_\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [optionsRequestedPolicyVersion] - Requested IAM Policy version.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> getIamPolicy(
    core.String project,
    core.String resource, {
    core.int? optionsRequestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (optionsRequestedPolicyVersion != null)
        'optionsRequestedPolicyVersion': ['${optionsRequestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/images/' +
        commons.escapeVariable('$resource') +
        '/getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Policy.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates an image in the specified project using the data included in the
  /// request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [forceCreate] - Force image creation if true.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
    Image request,
    core.String project, {
    core.bool? forceCreate,
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (forceCreate != null) 'forceCreate': ['${forceCreate}'],
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'projects/' + commons.escapeVariable('$project') + '/global/images';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves the list of custom images available to the specified project.
  ///
  /// Custom images are images you create that belong to your project. This
  /// method does not get any images that belong to other projects, including
  /// publicly-available images, like Debian 8. If you want to get a list of
  /// publicly-available images, use this method to make a request to the
  /// respective image project, such as debian-cloud or windows-cloud.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ImageList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ImageList> list(
    core.String project, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'projects/' + commons.escapeVariable('$project') + '/global/images';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ImageList.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Patches the specified image with the data included in the request.
  ///
  /// Only the following fields can be modified: family, description,
  /// deprecation status.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [image] - Name of the image resource to patch.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> patch(
    Image request,
    core.String project,
    core.String image, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/images/' +
        commons.escapeVariable('$image');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified resource.
  ///
  /// Replaces any existing policy.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9_\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> setIamPolicy(
    GlobalSetPolicyRequest request,
    core.String project,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/images/' +
        commons.escapeVariable('$resource') +
        '/setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Policy.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the labels on an image.
  ///
  /// To learn more about labels, read the Labeling Resources documentation.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9_\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setLabels(
    GlobalSetLabelsRequest request,
    core.String project,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/images/' +
        commons.escapeVariable('$resource') +
        '/setLabels';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9_\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [TestPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<TestPermissionsResponse> testIamPermissions(
    TestPermissionsRequest request,
    core.String project,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/images/' +
        commons.escapeVariable('$resource') +
        '/testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return TestPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class InstanceGroupManagerResizeRequestsResource {
  final commons.ApiRequester _requester;

  InstanceGroupManagerResizeRequestsResource(commons.ApiRequester client)
      : _requester = client;

  /// Cancels the specified resize request and removes it from the queue.
  ///
  /// Cancelled resize request does no longer wait for the resources to be
  /// provisioned. Cancel is only possible for requests that are accepted in the
  /// queue.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where the managed instance group is located.
  /// The name should conform to RFC1035.
  ///
  /// [instanceGroupManager] - The name of the managed instance group. The name
  /// should conform to RFC1035 or be a resource ID.
  ///
  /// [resizeRequest] - The name of the resize request to cancel. The name
  /// should conform to RFC1035 or be a resource ID.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> cancel(
    core.String project,
    core.String zone,
    core.String instanceGroupManager,
    core.String resizeRequest, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.escapeVariable('$instanceGroupManager') +
        '/resizeRequests/' +
        commons.escapeVariable('$resizeRequest') +
        '/cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes the specified, inactive resize request.
  ///
  /// Requests that are still active cannot be deleted. Deleting request does
  /// not delete instances that were provisioned previously.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where the managed instance group is located.
  /// The name should conform to RFC1035.
  ///
  /// [instanceGroupManager] - The name of the managed instance group. The name
  /// should conform to RFC1035 or be a resource ID.
  ///
  /// [resizeRequest] - The name of the resize request to delete. The name
  /// should conform to RFC1035 or be a resource ID.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
    core.String project,
    core.String zone,
    core.String instanceGroupManager,
    core.String resizeRequest, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.escapeVariable('$instanceGroupManager') +
        '/resizeRequests/' +
        commons.escapeVariable('$resizeRequest');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns all of the details about the specified resize request.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - Name of the href="/compute/docs/regions-zones/#available"\>zone
  /// scoping this request. Name should conform to RFC1035.
  ///
  /// [instanceGroupManager] - The name of the managed instance group. Name
  /// should conform to RFC1035 or be a resource ID.
  ///
  /// [resizeRequest] - The name of the resize request. Name should conform to
  /// RFC1035 or be a resource ID.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstanceGroupManagerResizeRequest].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstanceGroupManagerResizeRequest> get(
    core.String project,
    core.String zone,
    core.String instanceGroupManager,
    core.String resizeRequest, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.escapeVariable('$instanceGroupManager') +
        '/resizeRequests/' +
        commons.escapeVariable('$resizeRequest');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return InstanceGroupManagerResizeRequest.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates a new resize request that starts provisioning VMs immediately or
  /// queues VM creation.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where the managed instance group is located
  /// and where the resize request will be created. Name should conform to
  /// RFC1035.
  ///
  /// [instanceGroupManager] - The name of the managed instance group to which
  /// the resize request will be added. Name should conform to RFC1035 or be a
  /// resource ID.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
    InstanceGroupManagerResizeRequest request,
    core.String project,
    core.String zone,
    core.String instanceGroupManager, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.escapeVariable('$instanceGroupManager') +
        '/resizeRequests';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves a list of resize requests that are contained in the managed
  /// instance group.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where the managed instance group is located.
  /// The name should conform to RFC1035.
  ///
  /// [instanceGroupManager] - The name of the managed instance group. The name
  /// should conform to RFC1035.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstanceGroupManagerResizeRequestsListResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstanceGroupManagerResizeRequestsListResponse> list(
    core.String project,
    core.String zone,
    core.String instanceGroupManager, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.escapeVariable('$instanceGroupManager') +
        '/resizeRequests';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return InstanceGroupManagerResizeRequestsListResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class InstanceGroupManagersResource {
  final commons.ApiRequester _requester;

  InstanceGroupManagersResource(commons.ApiRequester client)
      : _requester = client;

  /// Flags the specified instances to be removed from the managed instance
  /// group.
  ///
  /// Abandoning an instance does not delete the instance, but it does remove
  /// the instance from any target pools that are applied by the managed
  /// instance group. This method reduces the targetSize of the managed instance
  /// group by the number of instances that you abandon. This operation is
  /// marked as DONE when the action is scheduled even if the instances have not
  /// yet been removed from the group. You must separately verify the status of
  /// the abandoning action with the listmanagedinstances method. If the group
  /// is part of a backend service that has enabled connection draining, it can
  /// take up to 60 seconds after the connection draining duration has elapsed
  /// before the VM instance is removed or deleted. You can specify a maximum of
  /// 1000 instances with this method per request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where the managed instance group is located.
  ///
  /// [instanceGroupManager] - The name of the managed instance group.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> abandonInstances(
    InstanceGroupManagersAbandonInstancesRequest request,
    core.String project,
    core.String zone,
    core.String instanceGroupManager, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.escapeVariable('$instanceGroupManager') +
        '/abandonInstances';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves the list of managed instance groups and groups them by zone.
  ///
  /// To prevent failure, Google recommends that you set the
  /// `returnPartialSuccess` parameter to `true`.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [includeAllScopes] - Indicates whether every visible scope for each scope
  /// type (zone, region, global) should be included in the response. For new
  /// resource types added after this field, the flag has no effect as new
  /// resource types will always include every visible scope for each scope type
  /// in response. For resource types which predate this field, if this flag is
  /// omitted or false, only scopes of the scope types where the resource type
  /// is expected to be found will be included.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [serviceProjectNumber] - The Shared VPC service project id or service
  /// project number for which aggregated list request is invoked for
  /// subnetworks list-usable api.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstanceGroupManagerAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstanceGroupManagerAggregatedList> aggregatedList(
    core.String project, {
    core.String? filter,
    core.bool? includeAllScopes,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? serviceProjectNumber,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (includeAllScopes != null) 'includeAllScopes': ['${includeAllScopes}'],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if (serviceProjectNumber != null)
        'serviceProjectNumber': [serviceProjectNumber],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/aggregated/instanceGroupManagers';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return InstanceGroupManagerAggregatedList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Applies changes to selected instances on the managed instance group.
  ///
  /// This method can be used to apply new overrides and/or new versions.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where the managed instance group is located.
  /// Should conform to RFC1035.
  ///
  /// [instanceGroupManager] - The name of the managed instance group, should
  /// conform to RFC1035.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> applyUpdatesToInstances(
    InstanceGroupManagersApplyUpdatesRequest request,
    core.String project,
    core.String zone,
    core.String instanceGroupManager, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.escapeVariable('$instanceGroupManager') +
        '/applyUpdatesToInstances';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates instances with per-instance configurations in this managed
  /// instance group.
  ///
  /// Instances are created using the current instance template. The create
  /// instances operation is marked DONE if the createInstances request is
  /// successful. The underlying actions take additional time. You must
  /// separately verify the status of the creating or actions with the
  /// listmanagedinstances method.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where the managed instance group is located.
  /// It should conform to RFC1035.
  ///
  /// [instanceGroupManager] - The name of the managed instance group. It should
  /// conform to RFC1035.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. The request ID must
  /// be a valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> createInstances(
    InstanceGroupManagersCreateInstancesRequest request,
    core.String project,
    core.String zone,
    core.String instanceGroupManager, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.escapeVariable('$instanceGroupManager') +
        '/createInstances';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes the specified managed instance group and all of the instances in
  /// that group.
  ///
  /// Note that the instance group must not belong to a backend service. Read
  /// Deleting an instance group for more information.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where the managed instance group is located.
  ///
  /// [instanceGroupManager] - The name of the managed instance group to delete.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
    core.String project,
    core.String zone,
    core.String instanceGroupManager, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.escapeVariable('$instanceGroupManager');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Flags the specified instances in the managed instance group for immediate
  /// deletion.
  ///
  /// The instances are also removed from any target pools of which they were a
  /// member. This method reduces the targetSize of the managed instance group
  /// by the number of instances that you delete. This operation is marked as
  /// DONE when the action is scheduled even if the instances are still being
  /// deleted. You must separately verify the status of the deleting action with
  /// the listmanagedinstances method. If the group is part of a backend service
  /// that has enabled connection draining, it can take up to 60 seconds after
  /// the connection draining duration has elapsed before the VM instance is
  /// removed or deleted. You can specify a maximum of 1000 instances with this
  /// method per request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where the managed instance group is located.
  ///
  /// [instanceGroupManager] - The name of the managed instance group.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> deleteInstances(
    InstanceGroupManagersDeleteInstancesRequest request,
    core.String project,
    core.String zone,
    core.String instanceGroupManager, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.escapeVariable('$instanceGroupManager') +
        '/deleteInstances';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes selected per-instance configurations for the managed instance
  /// group.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where the managed instance group is located.
  /// It should conform to RFC1035.
  ///
  /// [instanceGroupManager] - The name of the managed instance group. It should
  /// conform to RFC1035.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> deletePerInstanceConfigs(
    InstanceGroupManagersDeletePerInstanceConfigsReq request,
    core.String project,
    core.String zone,
    core.String instanceGroupManager, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.escapeVariable('$instanceGroupManager') +
        '/deletePerInstanceConfigs';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns all of the details about the specified managed instance group.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where the managed instance group is located.
  ///
  /// [instanceGroupManager] - The name of the managed instance group.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstanceGroupManager].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstanceGroupManager> get(
    core.String project,
    core.String zone,
    core.String instanceGroupManager, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.escapeVariable('$instanceGroupManager');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return InstanceGroupManager.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates a managed instance group using the information that you specify in
  /// the request.
  ///
  /// After the group is created, instances in the group are created using the
  /// specified instance template. This operation is marked as DONE when the
  /// group is created even if the instances in the group have not yet been
  /// created. You must separately verify the status of the individual instances
  /// with the listmanagedinstances method. A managed instance group can have up
  /// to 1000 VM instances per group. Please contact Cloud Support if you need
  /// an increase in this limit.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where you want to create the managed
  /// instance group.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
    InstanceGroupManager request,
    core.String project,
    core.String zone, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroupManagers';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves a list of managed instance groups that are contained within the
  /// specified project and zone.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where the managed instance group is located.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstanceGroupManagerList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstanceGroupManagerList> list(
    core.String project,
    core.String zone, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroupManagers';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return InstanceGroupManagerList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists all errors thrown by actions on instances for a given managed
  /// instance group.
  ///
  /// The filter and orderBy query parameters are not supported.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where the managed instance group is located.
  /// It should conform to RFC1035.
  ///
  /// [instanceGroupManager] - The name of the managed instance group. It must
  /// be a string that meets the requirements in RFC1035, or an unsigned long
  /// integer: must match regexp pattern:
  /// (?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?)|1-9{0,19}.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstanceGroupManagersListErrorsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstanceGroupManagersListErrorsResponse> listErrors(
    core.String project,
    core.String zone,
    core.String instanceGroupManager, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.escapeVariable('$instanceGroupManager') +
        '/listErrors';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return InstanceGroupManagersListErrorsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists all of the instances in the managed instance group.
  ///
  /// Each instance in the list has a currentAction, which indicates the action
  /// that the managed instance group is performing on the instance. For
  /// example, if the group is still creating an instance, the currentAction is
  /// CREATING. If a previous action failed, the list displays the errors for
  /// that failed action. The orderBy query parameter is not supported. The
  /// `pageToken` query parameter is supported only if the group's
  /// `listManagedInstancesResults` field is set to `PAGINATED`.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where the managed instance group is located.
  ///
  /// [instanceGroupManager] - The name of the managed instance group.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstanceGroupManagersListManagedInstancesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstanceGroupManagersListManagedInstancesResponse>
      listManagedInstances(
    core.String project,
    core.String zone,
    core.String instanceGroupManager, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.escapeVariable('$instanceGroupManager') +
        '/listManagedInstances';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return InstanceGroupManagersListManagedInstancesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists all of the per-instance configurations defined for the managed
  /// instance group.
  ///
  /// The orderBy query parameter is not supported.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where the managed instance group is located.
  /// It should conform to RFC1035.
  ///
  /// [instanceGroupManager] - The name of the managed instance group. It should
  /// conform to RFC1035.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstanceGroupManagersListPerInstanceConfigsResp].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstanceGroupManagersListPerInstanceConfigsResp>
      listPerInstanceConfigs(
    core.String project,
    core.String zone,
    core.String instanceGroupManager, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.escapeVariable('$instanceGroupManager') +
        '/listPerInstanceConfigs';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return InstanceGroupManagersListPerInstanceConfigsResp.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates a managed instance group using the information that you specify in
  /// the request.
  ///
  /// This operation is marked as DONE when the group is patched even if the
  /// instances in the group are still in the process of being patched. You must
  /// separately verify the status of the individual instances with the
  /// listManagedInstances method. This method supports PATCH semantics and uses
  /// the JSON merge patch format and processing rules. If you update your group
  /// to specify a new template or instance configuration, it's possible that
  /// your intended specification for each VM in the group is different from the
  /// current state of that VM. To learn how to apply an updated configuration
  /// to the VMs in a MIG, see Updating instances in a MIG.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where you want to create the managed
  /// instance group.
  ///
  /// [instanceGroupManager] - The name of the instance group manager.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> patch(
    InstanceGroupManager request,
    core.String project,
    core.String zone,
    core.String instanceGroupManager, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.escapeVariable('$instanceGroupManager');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Inserts or patches per-instance configurations for the managed instance
  /// group.
  ///
  /// perInstanceConfig.name serves as a key used to distinguish whether to
  /// perform insert or patch.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where the managed instance group is located.
  /// It should conform to RFC1035.
  ///
  /// [instanceGroupManager] - The name of the managed instance group. It should
  /// conform to RFC1035.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> patchPerInstanceConfigs(
    InstanceGroupManagersPatchPerInstanceConfigsReq request,
    core.String project,
    core.String zone,
    core.String instanceGroupManager, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.escapeVariable('$instanceGroupManager') +
        '/patchPerInstanceConfigs';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Flags the specified VM instances in the managed instance group to be
  /// immediately recreated.
  ///
  /// Each instance is recreated using the group's current configuration. This
  /// operation is marked as DONE when the flag is set even if the instances
  /// have not yet been recreated. You must separately verify the status of each
  /// instance by checking its currentAction field; for more information, see
  /// Checking the status of managed instances. If the group is part of a
  /// backend service that has enabled connection draining, it can take up to 60
  /// seconds after the connection draining duration has elapsed before the VM
  /// instance is removed or deleted. You can specify a maximum of 1000
  /// instances with this method per request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where the managed instance group is located.
  ///
  /// [instanceGroupManager] - The name of the managed instance group.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> recreateInstances(
    InstanceGroupManagersRecreateInstancesRequest request,
    core.String project,
    core.String zone,
    core.String instanceGroupManager, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.escapeVariable('$instanceGroupManager') +
        '/recreateInstances';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Resizes the managed instance group.
  ///
  /// If you increase the size, the group creates new instances using the
  /// current instance template. If you decrease the size, the group deletes
  /// instances. The resize operation is marked DONE when the resize actions are
  /// scheduled even if the group has not yet added or deleted any instances.
  /// You must separately verify the status of the creating or deleting actions
  /// with the listmanagedinstances method. When resizing down, the instance
  /// group arbitrarily chooses the order in which VMs are deleted. The group
  /// takes into account some VM attributes when making the selection including:
  /// + The status of the VM instance. + The health of the VM instance. + The
  /// instance template version the VM is based on. + For regional managed
  /// instance groups, the location of the VM instance. This list is subject to
  /// change. If the group is part of a backend service that has enabled
  /// connection draining, it can take up to 60 seconds after the connection
  /// draining duration has elapsed before the VM instance is removed or
  /// deleted.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where the managed instance group is located.
  ///
  /// [instanceGroupManager] - The name of the managed instance group.
  ///
  /// [size] - The number of running instances that the managed instance group
  /// should maintain at any given time. The group automatically adds or removes
  /// instances to maintain the number of instances specified by this parameter.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> resize(
    core.String project,
    core.String zone,
    core.String instanceGroupManager,
    core.int size, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      'size': ['${size}'],
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.escapeVariable('$instanceGroupManager') +
        '/resize';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Flags the specified instances in the managed instance group to be resumed.
  ///
  /// This method increases the targetSize and decreases the targetSuspendedSize
  /// of the managed instance group by the number of instances that you resume.
  /// The resumeInstances operation is marked DONE if the resumeInstances
  /// request is successful. The underlying actions take additional time. You
  /// must separately verify the status of the RESUMING action with the
  /// listmanagedinstances method. In this request, you can only specify
  /// instances that are suspended. For example, if an instance was previously
  /// suspended using the suspendInstances method, it can be resumed using the
  /// resumeInstances method. If a health check is attached to the managed
  /// instance group, the specified instances will be verified as healthy after
  /// they are resumed. You can specify a maximum of 1000 instances with this
  /// method per request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where the managed instance group is located.
  ///
  /// [instanceGroupManager] - The name of the managed instance group.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> resumeInstances(
    InstanceGroupManagersResumeInstancesRequest request,
    core.String project,
    core.String zone,
    core.String instanceGroupManager, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.escapeVariable('$instanceGroupManager') +
        '/resumeInstances';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Specifies the instance template to use when creating new instances in this
  /// group.
  ///
  /// The templates for existing instances in the group do not change unless you
  /// run recreateInstances, run applyUpdatesToInstances, or set the group's
  /// updatePolicy.type to PROACTIVE.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where the managed instance group is located.
  ///
  /// [instanceGroupManager] - The name of the managed instance group.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setInstanceTemplate(
    InstanceGroupManagersSetInstanceTemplateRequest request,
    core.String project,
    core.String zone,
    core.String instanceGroupManager, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.escapeVariable('$instanceGroupManager') +
        '/setInstanceTemplate';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Modifies the target pools to which all instances in this managed instance
  /// group are assigned.
  ///
  /// The target pools automatically apply to all of the instances in the
  /// managed instance group. This operation is marked DONE when you make the
  /// request even if the instances have not yet been added to their target
  /// pools. The change might take some time to apply to all of the instances in
  /// the group depending on the size of the group.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where the managed instance group is located.
  ///
  /// [instanceGroupManager] - The name of the managed instance group.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setTargetPools(
    InstanceGroupManagersSetTargetPoolsRequest request,
    core.String project,
    core.String zone,
    core.String instanceGroupManager, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.escapeVariable('$instanceGroupManager') +
        '/setTargetPools';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Flags the specified instances in the managed instance group to be started.
  ///
  /// This method increases the targetSize and decreases the targetStoppedSize
  /// of the managed instance group by the number of instances that you start.
  /// The startInstances operation is marked DONE if the startInstances request
  /// is successful. The underlying actions take additional time. You must
  /// separately verify the status of the STARTING action with the
  /// listmanagedinstances method. In this request, you can only specify
  /// instances that are stopped. For example, if an instance was previously
  /// stopped using the stopInstances method, it can be started using the
  /// startInstances method. If a health check is attached to the managed
  /// instance group, the specified instances will be verified as healthy after
  /// they are started. You can specify a maximum of 1000 instances with this
  /// method per request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where the managed instance group is located.
  ///
  /// [instanceGroupManager] - The name of the managed instance group.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> startInstances(
    InstanceGroupManagersStartInstancesRequest request,
    core.String project,
    core.String zone,
    core.String instanceGroupManager, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.escapeVariable('$instanceGroupManager') +
        '/startInstances';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Flags the specified instances in the managed instance group to be
  /// immediately stopped.
  ///
  /// You can only specify instances that are running in this request. This
  /// method reduces the targetSize and increases the targetStoppedSize of the
  /// managed instance group by the number of instances that you stop. The
  /// stopInstances operation is marked DONE if the stopInstances request is
  /// successful. The underlying actions take additional time. You must
  /// separately verify the status of the STOPPING action with the
  /// listmanagedinstances method. If the standbyPolicy.initialDelaySec field is
  /// set, the group delays stopping the instances until initialDelaySec have
  /// passed from instance.creationTimestamp (that is, when the instance was
  /// created). This delay gives your application time to set itself up and
  /// initialize on the instance. If more than initialDelaySec seconds have
  /// passed since instance.creationTimestamp when this method is called, there
  /// will be zero delay. If the group is part of a backend service that has
  /// enabled connection draining, it can take up to 60 seconds after the
  /// connection draining duration has elapsed before the VM instance is
  /// stopped. Stopped instances can be started using the startInstances method.
  /// You can specify a maximum of 1000 instances with this method per request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where the managed instance group is located.
  ///
  /// [instanceGroupManager] - The name of the managed instance group.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> stopInstances(
    InstanceGroupManagersStopInstancesRequest request,
    core.String project,
    core.String zone,
    core.String instanceGroupManager, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.escapeVariable('$instanceGroupManager') +
        '/stopInstances';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Flags the specified instances in the managed instance group to be
  /// immediately suspended.
  ///
  /// You can only specify instances that are running in this request. This
  /// method reduces the targetSize and increases the targetSuspendedSize of the
  /// managed instance group by the number of instances that you suspend. The
  /// suspendInstances operation is marked DONE if the suspendInstances request
  /// is successful. The underlying actions take additional time. You must
  /// separately verify the status of the SUSPENDING action with the
  /// listmanagedinstances method. If the standbyPolicy.initialDelaySec field is
  /// set, the group delays suspension of the instances until initialDelaySec
  /// have passed from instance.creationTimestamp (that is, when the instance
  /// was created). This delay gives your application time to set itself up and
  /// initialize on the instance. If more than initialDelaySec seconds have
  /// passed since instance.creationTimestamp when this method is called, there
  /// will be zero delay. If the group is part of a backend service that has
  /// enabled connection draining, it can take up to 60 seconds after the
  /// connection draining duration has elapsed before the VM instance is
  /// suspended. Suspended instances can be resumed using the resumeInstances
  /// method. You can specify a maximum of 1000 instances with this method per
  /// request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where the managed instance group is located.
  ///
  /// [instanceGroupManager] - The name of the managed instance group.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> suspendInstances(
    InstanceGroupManagersSuspendInstancesRequest request,
    core.String project,
    core.String zone,
    core.String instanceGroupManager, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.escapeVariable('$instanceGroupManager') +
        '/suspendInstances';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Inserts or updates per-instance configurations for the managed instance
  /// group.
  ///
  /// perInstanceConfig.name serves as a key used to distinguish whether to
  /// perform insert or patch.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where the managed instance group is located.
  /// It should conform to RFC1035.
  ///
  /// [instanceGroupManager] - The name of the managed instance group. It should
  /// conform to RFC1035.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> updatePerInstanceConfigs(
    InstanceGroupManagersUpdatePerInstanceConfigsReq request,
    core.String project,
    core.String zone,
    core.String instanceGroupManager, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroupManagers/' +
        commons.escapeVariable('$instanceGroupManager') +
        '/updatePerInstanceConfigs';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }
}

class InstanceGroupsResource {
  final commons.ApiRequester _requester;

  InstanceGroupsResource(commons.ApiRequester client) : _requester = client;

  /// Adds a list of instances to the specified instance group.
  ///
  /// All of the instances in the instance group must be in the same
  /// network/subnetwork. Read Adding instances for more information.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where the instance group is located.
  ///
  /// [instanceGroup] - The name of the instance group where you are adding
  /// instances.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> addInstances(
    InstanceGroupsAddInstancesRequest request,
    core.String project,
    core.String zone,
    core.String instanceGroup, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroups/' +
        commons.escapeVariable('$instanceGroup') +
        '/addInstances';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves the list of instance groups and sorts them by zone.
  ///
  /// To prevent failure, Google recommends that you set the
  /// `returnPartialSuccess` parameter to `true`.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [includeAllScopes] - Indicates whether every visible scope for each scope
  /// type (zone, region, global) should be included in the response. For new
  /// resource types added after this field, the flag has no effect as new
  /// resource types will always include every visible scope for each scope type
  /// in response. For resource types which predate this field, if this flag is
  /// omitted or false, only scopes of the scope types where the resource type
  /// is expected to be found will be included.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [serviceProjectNumber] - The Shared VPC service project id or service
  /// project number for which aggregated list request is invoked for
  /// subnetworks list-usable api.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstanceGroupAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstanceGroupAggregatedList> aggregatedList(
    core.String project, {
    core.String? filter,
    core.bool? includeAllScopes,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? serviceProjectNumber,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (includeAllScopes != null) 'includeAllScopes': ['${includeAllScopes}'],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if (serviceProjectNumber != null)
        'serviceProjectNumber': [serviceProjectNumber],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/aggregated/instanceGroups';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return InstanceGroupAggregatedList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes the specified instance group.
  ///
  /// The instances in the group are not deleted. Note that instance group must
  /// not belong to a backend service. Read Deleting an instance group for more
  /// information.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where the instance group is located.
  ///
  /// [instanceGroup] - The name of the instance group to delete.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
    core.String project,
    core.String zone,
    core.String instanceGroup, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroups/' +
        commons.escapeVariable('$instanceGroup');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the specified zonal instance group.
  ///
  /// Get a list of available zonal instance groups by making a list() request.
  /// For managed instance groups, use the instanceGroupManagers or
  /// regionInstanceGroupManagers methods instead.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where the instance group is located.
  ///
  /// [instanceGroup] - The name of the instance group.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstanceGroup].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstanceGroup> get(
    core.String project,
    core.String zone,
    core.String instanceGroup, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroups/' +
        commons.escapeVariable('$instanceGroup');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return InstanceGroup.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates an instance group in the specified project using the parameters
  /// that are included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where you want to create the instance group.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
    InstanceGroup request,
    core.String project,
    core.String zone, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroups';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves the list of zonal instance group resources contained within the
  /// specified zone.
  ///
  /// For managed instance groups, use the instanceGroupManagers or
  /// regionInstanceGroupManagers methods instead.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where the instance group is located.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstanceGroupList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstanceGroupList> list(
    core.String project,
    core.String zone, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroups';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return InstanceGroupList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists the instances in the specified instance group.
  ///
  /// The orderBy query parameter is not supported. The filter query parameter
  /// is supported, but only for expressions that use `eq` (equal) or `ne` (not
  /// equal) operators.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where the instance group is located.
  ///
  /// [instanceGroup] - The name of the instance group from which you want to
  /// generate a list of included instances.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstanceGroupsListInstances].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstanceGroupsListInstances> listInstances(
    InstanceGroupsListInstancesRequest request,
    core.String project,
    core.String zone,
    core.String instanceGroup, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroups/' +
        commons.escapeVariable('$instanceGroup') +
        '/listInstances';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return InstanceGroupsListInstances.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Removes one or more instances from the specified instance group, but does
  /// not delete those instances.
  ///
  /// If the group is part of a backend service that has enabled connection
  /// draining, it can take up to 60 seconds after the connection draining
  /// duration before the VM instance is removed or deleted.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where the instance group is located.
  ///
  /// [instanceGroup] - The name of the instance group where the specified
  /// instances will be removed.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> removeInstances(
    InstanceGroupsRemoveInstancesRequest request,
    core.String project,
    core.String zone,
    core.String instanceGroup, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroups/' +
        commons.escapeVariable('$instanceGroup') +
        '/removeInstances';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the named ports for the specified instance group.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone where the instance group is located.
  ///
  /// [instanceGroup] - The name of the instance group where the named ports are
  /// updated.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setNamedPorts(
    InstanceGroupsSetNamedPortsRequest request,
    core.String project,
    core.String zone,
    core.String instanceGroup, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceGroups/' +
        commons.escapeVariable('$instanceGroup') +
        '/setNamedPorts';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }
}

class InstanceSettingsResource {
  final commons.ApiRequester _requester;

  InstanceSettingsResource(commons.ApiRequester client) : _requester = client;

  /// Get Instance settings.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - Name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstanceSettings].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstanceSettings> get(
    core.String project,
    core.String zone, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceSettings';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return InstanceSettings.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Patch Instance settings
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The zone scoping this request. It should conform to RFC1035.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [updateMask] - update_mask indicates fields to be updated as part of this
  /// request.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> patch(
    InstanceSettings request,
    core.String project,
    core.String zone, {
    core.String? requestId,
    core.String? updateMask,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if (updateMask != null) 'updateMask': [updateMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instanceSettings';

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }
}

class InstanceTemplatesResource {
  final commons.ApiRequester _requester;

  InstanceTemplatesResource(commons.ApiRequester client) : _requester = client;

  /// Retrieves the list of all InstanceTemplates resources, regional and
  /// global, available to the specified project.
  ///
  /// To prevent failure, Google recommends that you set the
  /// `returnPartialSuccess` parameter to `true`.
  ///
  /// Request parameters:
  ///
  /// [project] - Name of the project scoping this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [includeAllScopes] - Indicates whether every visible scope for each scope
  /// type (zone, region, global) should be included in the response. For new
  /// resource types added after this field, the flag has no effect as new
  /// resource types will always include every visible scope for each scope type
  /// in response. For resource types which predate this field, if this flag is
  /// omitted or false, only scopes of the scope types where the resource type
  /// is expected to be found will be included.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [serviceProjectNumber] - The Shared VPC service project id or service
  /// project number for which aggregated list request is invoked for
  /// subnetworks list-usable api.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstanceTemplateAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstanceTemplateAggregatedList> aggregatedList(
    core.String project, {
    core.String? filter,
    core.bool? includeAllScopes,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? serviceProjectNumber,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (includeAllScopes != null) 'includeAllScopes': ['${includeAllScopes}'],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if (serviceProjectNumber != null)
        'serviceProjectNumber': [serviceProjectNumber],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/aggregated/instanceTemplates';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return InstanceTemplateAggregatedList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes the specified instance template.
  ///
  /// Deleting an instance template is permanent and cannot be undone. It is not
  /// possible to delete templates that are already in use by a managed instance
  /// group.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [instanceTemplate] - The name of the instance template to delete.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
    core.String project,
    core.String instanceTemplate, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/instanceTemplates/' +
        commons.escapeVariable('$instanceTemplate');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the specified instance template.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [instanceTemplate] - The name of the instance template.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstanceTemplate].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstanceTemplate> get(
    core.String project,
    core.String instanceTemplate, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/instanceTemplates/' +
        commons.escapeVariable('$instanceTemplate');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return InstanceTemplate.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the access control policy for a resource.
  ///
  /// May be empty if no such policy or resource exists.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9_\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [optionsRequestedPolicyVersion] - Requested IAM Policy version.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> getIamPolicy(
    core.String project,
    core.String resource, {
    core.int? optionsRequestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (optionsRequestedPolicyVersion != null)
        'optionsRequestedPolicyVersion': ['${optionsRequestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/instanceTemplates/' +
        commons.escapeVariable('$resource') +
        '/getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Policy.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates an instance template in the specified project using the data that
  /// is included in the request.
  ///
  /// If you are creating a new template to update an existing instance group,
  /// your new instance template must use the same network or, if applicable,
  /// the same subnetwork as the original template.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
    InstanceTemplate request,
    core.String project, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/instanceTemplates';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves a list of instance templates that are contained within the
  /// specified project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstanceTemplateList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstanceTemplateList> list(
    core.String project, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/instanceTemplates';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return InstanceTemplateList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified resource.
  ///
  /// Replaces any existing policy.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9_\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> setIamPolicy(
    GlobalSetPolicyRequest request,
    core.String project,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/instanceTemplates/' +
        commons.escapeVariable('$resource') +
        '/setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Policy.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9_\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [TestPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<TestPermissionsResponse> testIamPermissions(
    TestPermissionsRequest request,
    core.String project,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/instanceTemplates/' +
        commons.escapeVariable('$resource') +
        '/testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return TestPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class InstancesResource {
  final commons.ApiRequester _requester;

  InstancesResource(commons.ApiRequester client) : _requester = client;

  /// Adds an access config to an instance's network interface.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - The instance name for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [networkInterface] - The name of the network interface to add to this
  /// instance.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> addAccessConfig(
    AccessConfig request,
    core.String project,
    core.String zone,
    core.String instance,
    core.String networkInterface, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      'networkInterface': [networkInterface],
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/addAccessConfig';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Adds existing resource policies to an instance.
  ///
  /// You can only add one policy right now which will be applied to this
  /// instance for scheduling live migrations.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - The instance name for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> addResourcePolicies(
    InstancesAddResourcePoliciesRequest request,
    core.String project,
    core.String zone,
    core.String instance, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/addResourcePolicies';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves an aggregated list of all of the instances in your project
  /// across all regions and zones.
  ///
  /// The performance of this method degrades when a filter is specified on a
  /// project that has a very large number of instances. To prevent failure,
  /// Google recommends that you set the `returnPartialSuccess` parameter to
  /// `true`.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [includeAllScopes] - Indicates whether every visible scope for each scope
  /// type (zone, region, global) should be included in the response. For new
  /// resource types added after this field, the flag has no effect as new
  /// resource types will always include every visible scope for each scope type
  /// in response. For resource types which predate this field, if this flag is
  /// omitted or false, only scopes of the scope types where the resource type
  /// is expected to be found will be included.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [serviceProjectNumber] - The Shared VPC service project id or service
  /// project number for which aggregated list request is invoked for
  /// subnetworks list-usable api.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstanceAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstanceAggregatedList> aggregatedList(
    core.String project, {
    core.String? filter,
    core.bool? includeAllScopes,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? serviceProjectNumber,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (includeAllScopes != null) 'includeAllScopes': ['${includeAllScopes}'],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if (serviceProjectNumber != null)
        'serviceProjectNumber': [serviceProjectNumber],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/aggregated/instances';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return InstanceAggregatedList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Attaches an existing Disk resource to an instance.
  ///
  /// You must first create the disk before you can attach it. It is not
  /// possible to create and attach a disk at the same time. For more
  /// information, read Adding a persistent disk to your instance.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - The instance name for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [forceAttach] - Whether to force attach the regional disk even if it's
  /// currently attached to another instance. If you try to force attach a zonal
  /// disk to an instance, you will receive an error.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> attachDisk(
    AttachedDisk request,
    core.String project,
    core.String zone,
    core.String instance, {
    core.bool? forceAttach,
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (forceAttach != null) 'forceAttach': ['${forceAttach}'],
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/attachDisk';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates multiple instances.
  ///
  /// Count specifies the number of instances to create. For more information,
  /// see About bulk creation of VMs.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> bulkInsert(
    BulkInsertInstanceResource request,
    core.String project,
    core.String zone, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/bulkInsert';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes the specified Instance resource.
  ///
  /// For more information, see Deleting an instance.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - Name of the instance resource to delete.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
    core.String project,
    core.String zone,
    core.String instance, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes an access config from an instance's network interface.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - The instance name for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [accessConfig] - The name of the access config to delete.
  ///
  /// [networkInterface] - The name of the network interface.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> deleteAccessConfig(
    core.String project,
    core.String zone,
    core.String instance,
    core.String accessConfig,
    core.String networkInterface, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      'accessConfig': [accessConfig],
      'networkInterface': [networkInterface],
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/deleteAccessConfig';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Detaches a disk from an instance.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - Instance name for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [deviceName] - The device name of the disk to detach. Make a get() request
  /// on the instance to view currently attached disks and device names.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> detachDisk(
    core.String project,
    core.String zone,
    core.String instance,
    core.String deviceName, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      'deviceName': [deviceName],
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/detachDisk';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the specified Instance resource.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - Name of the instance resource to return.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Instance].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Instance> get(
    core.String project,
    core.String zone,
    core.String instance, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Instance.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns effective firewalls applied to an interface of the instance.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - Name of the instance scoping this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [networkInterface] - The name of the network interface to get the
  /// effective firewalls.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstancesGetEffectiveFirewallsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstancesGetEffectiveFirewallsResponse> getEffectiveFirewalls(
    core.String project,
    core.String zone,
    core.String instance,
    core.String networkInterface, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      'networkInterface': [networkInterface],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/getEffectiveFirewalls';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return InstancesGetEffectiveFirewallsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the specified guest attributes entry.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - Name of the instance scoping this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [queryPath] - Specifies the guest attributes path to be queried.
  ///
  /// [variableKey] - Specifies the key for the guest attributes entry.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GuestAttributes].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GuestAttributes> getGuestAttributes(
    core.String project,
    core.String zone,
    core.String instance, {
    core.String? queryPath,
    core.String? variableKey,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (queryPath != null) 'queryPath': [queryPath],
      if (variableKey != null) 'variableKey': [variableKey],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/getGuestAttributes';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GuestAttributes.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the access control policy for a resource.
  ///
  /// May be empty if no such policy or resource exists.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [optionsRequestedPolicyVersion] - Requested IAM Policy version.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> getIamPolicy(
    core.String project,
    core.String zone,
    core.String resource, {
    core.int? optionsRequestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (optionsRequestedPolicyVersion != null)
        'optionsRequestedPolicyVersion': ['${optionsRequestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$resource') +
        '/getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Policy.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the screenshot from the specified instance.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - Name of the instance scoping this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Screenshot].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Screenshot> getScreenshot(
    core.String project,
    core.String zone,
    core.String instance, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/screenshot';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Screenshot.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the last 1 MB of serial port output from the specified instance.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - Name of the instance for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [port] - Specifies which COM or serial port to retrieve data from.
  /// Value must be between "1" and "4".
  ///
  /// [start_1] - Specifies the starting byte position of the output to return.
  /// To start with the first byte of output to the specified port, omit this
  /// field or set it to `0`. If the output for that byte position is available,
  /// this field matches the `start` parameter sent with the request. If the
  /// amount of serial console output exceeds the size of the buffer (1 MB), the
  /// oldest output is discarded and is no longer available. If the requested
  /// start position refers to discarded output, the start position is adjusted
  /// to the oldest output still available, and the adjusted start position is
  /// returned as the `start` property value. You can also provide a negative
  /// start position, which translates to the most recent number of bytes
  /// written to the serial port. For example, -3 is interpreted as the most
  /// recent 3 bytes written to the serial console. Note that the negative start
  /// is bounded by the retained buffer size, and the returned serial console
  /// output will not exceed the max buffer size.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [SerialPortOutput].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<SerialPortOutput> getSerialPortOutput(
    core.String project,
    core.String zone,
    core.String instance, {
    core.int? port,
    core.String? start_1,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (port != null) 'port': ['${port}'],
      if (start_1 != null) 'start': [start_1],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/serialPort';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return SerialPortOutput.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the Shielded Instance Identity of an instance
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - Name or id of the instance scoping this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [ShieldedInstanceIdentity].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<ShieldedInstanceIdentity> getShieldedInstanceIdentity(
    core.String project,
    core.String zone,
    core.String instance, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/getShieldedInstanceIdentity';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return ShieldedInstanceIdentity.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates an instance resource in the specified project using the data
  /// included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [sourceInstanceTemplate] - Specifies instance template to create the
  /// instance. This field is optional. It can be a full or partial URL. For
  /// example, the following are all valid URLs to an instance template: -
  /// https://www.googleapis.com/compute/v1/projects/project
  /// /global/instanceTemplates/instanceTemplate -
  /// projects/project/global/instanceTemplates/instanceTemplate -
  /// global/instanceTemplates/instanceTemplate
  ///
  /// [sourceMachineImage] - Specifies the machine image to use to create the
  /// instance. This field is optional. It can be a full or partial URL. For
  /// example, the following are all valid URLs to a machine image: -
  /// https://www.googleapis.com/compute/v1/projects/project/global/global
  /// /machineImages/machineImage -
  /// projects/project/global/global/machineImages/machineImage -
  /// global/machineImages/machineImage
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
    Instance request,
    core.String project,
    core.String zone, {
    core.String? requestId,
    core.String? sourceInstanceTemplate,
    core.String? sourceMachineImage,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if (sourceInstanceTemplate != null)
        'sourceInstanceTemplate': [sourceInstanceTemplate],
      if (sourceMachineImage != null)
        'sourceMachineImage': [sourceMachineImage],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves the list of instances contained within the specified zone.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstanceList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstanceList> list(
    core.String project,
    core.String zone, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return InstanceList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves a list of resources that refer to the VM instance specified in
  /// the request.
  ///
  /// For example, if the VM instance is part of a managed or unmanaged instance
  /// group, the referrers list includes the instance group. For more
  /// information, read Viewing referrers to VM instances.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - Name of the target instance scoping this request, or '-' if
  /// the request should span over all instances in the container.
  /// Value must have pattern
  /// `-|\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstanceListReferrers].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstanceListReferrers> listReferrers(
    core.String project,
    core.String zone,
    core.String instance, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/referrers';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return InstanceListReferrers.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Perform a manual maintenance on the instance.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - Name of the instance scoping this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> performMaintenance(
    core.String project,
    core.String zone,
    core.String instance, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/performMaintenance';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Removes resource policies from an instance.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - The instance name for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> removeResourcePolicies(
    InstancesRemoveResourcePoliciesRequest request,
    core.String project,
    core.String zone,
    core.String instance, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/removeResourcePolicies';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Mark the host as faulty and try to restart the instance on a new host.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - Name of the instance scoping this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> reportHostAsFaulty(
    InstancesReportHostAsFaultyRequest request,
    core.String project,
    core.String zone,
    core.String instance, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/reportHostAsFaulty';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Performs a reset on the instance.
  ///
  /// This is a hard reset. The VM does not do a graceful shutdown. For more
  /// information, see Resetting an instance.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - Name of the instance scoping this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> reset(
    core.String project,
    core.String zone,
    core.String instance, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/reset';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Resumes an instance that was suspended using the instances().suspend
  /// method.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - Name of the instance resource to resume.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> resume(
    core.String project,
    core.String zone,
    core.String instance, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/resume';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sends diagnostic interrupt to the instance.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - Name of the instance scoping this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<void> sendDiagnosticInterrupt(
    core.String project,
    core.String zone,
    core.String instance, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/sendDiagnosticInterrupt';

    await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
      downloadOptions: null,
    );
  }

  /// Sets deletion protection on the instance.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [deletionProtection] - Whether the resource should be protected against
  /// deletion.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setDeletionProtection(
    core.String project,
    core.String zone,
    core.String resource, {
    core.bool? deletionProtection,
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (deletionProtection != null)
        'deletionProtection': ['${deletionProtection}'],
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$resource') +
        '/setDeletionProtection';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the auto-delete flag for a disk attached to an instance.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - The instance name for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [autoDelete] - Whether to auto-delete the disk when the instance is
  /// deleted.
  ///
  /// [deviceName] - The device name of the disk to modify. Make a get() request
  /// on the instance to view currently attached disks and device names.
  /// Value must have pattern `\w\[\w.-\]{0,254}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setDiskAutoDelete(
    core.String project,
    core.String zone,
    core.String instance,
    core.bool autoDelete,
    core.String deviceName, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      'autoDelete': ['${autoDelete}'],
      'deviceName': [deviceName],
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/setDiskAutoDelete';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified resource.
  ///
  /// Replaces any existing policy.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> setIamPolicy(
    ZoneSetPolicyRequest request,
    core.String project,
    core.String zone,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$resource') +
        '/setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Policy.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets labels on an instance.
  ///
  /// To learn more about labels, read the Labeling Resources documentation.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - Name of the instance scoping this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setLabels(
    InstancesSetLabelsRequest request,
    core.String project,
    core.String zone,
    core.String instance, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/setLabels';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Changes the number and/or type of accelerator for a stopped instance to
  /// the values specified in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - Name of the instance scoping this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setMachineResources(
    InstancesSetMachineResourcesRequest request,
    core.String project,
    core.String zone,
    core.String instance, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/setMachineResources';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Changes the machine type for a stopped instance to the machine type
  /// specified in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - Name of the instance scoping this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setMachineType(
    InstancesSetMachineTypeRequest request,
    core.String project,
    core.String zone,
    core.String instance, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/setMachineType';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets metadata for the specified instance to the data included in the
  /// request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - Name of the instance scoping this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setMetadata(
    Metadata request,
    core.String project,
    core.String zone,
    core.String instance, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/setMetadata';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Changes the minimum CPU platform that this instance should use.
  ///
  /// This method can only be called on a stopped instance. For more
  /// information, read Specifying a Minimum CPU Platform.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - Name of the instance scoping this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setMinCpuPlatform(
    InstancesSetMinCpuPlatformRequest request,
    core.String project,
    core.String zone,
    core.String instance, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/setMinCpuPlatform';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets name of an instance.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - The instance name for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setName(
    InstancesSetNameRequest request,
    core.String project,
    core.String zone,
    core.String instance, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/setName';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets an instance's scheduling options.
  ///
  /// You can only call this method on a stopped instance, that is, a VM
  /// instance that is in a `TERMINATED` state. See Instance Life Cycle for more
  /// information on the possible instance states. For more information about
  /// setting scheduling options for a VM, see Set VM host maintenance policy.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - Instance name for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setScheduling(
    Scheduling request,
    core.String project,
    core.String zone,
    core.String instance, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/setScheduling';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the Google Cloud Armor security policy for the specified instance.
  ///
  /// For more information, see Google Cloud Armor Overview
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - Name of the zone scoping this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - Name of the Instance resource to which the security policy
  /// should be set. The name should conform to RFC1035.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setSecurityPolicy(
    InstancesSetSecurityPolicyRequest request,
    core.String project,
    core.String zone,
    core.String instance, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/setSecurityPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the service account on the instance.
  ///
  /// For more information, read Changing the service account and access scopes
  /// for an instance.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - Name of the instance resource to start.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setServiceAccount(
    InstancesSetServiceAccountRequest request,
    core.String project,
    core.String zone,
    core.String instance, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/setServiceAccount';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the Shielded Instance integrity policy for an instance.
  ///
  /// You can only use this method on a running instance. This method supports
  /// PATCH semantics and uses the JSON merge patch format and processing rules.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - Name or id of the instance scoping this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setShieldedInstanceIntegrityPolicy(
    ShieldedInstanceIntegrityPolicy request,
    core.String project,
    core.String zone,
    core.String instance, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/setShieldedInstanceIntegrityPolicy';

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets network tags for the specified instance to the data included in the
  /// request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - Name of the instance scoping this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setTags(
    Tags request,
    core.String project,
    core.String zone,
    core.String instance, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/setTags';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Simulates a host maintenance event on a VM.
  ///
  /// For more information, see Simulate a host maintenance event.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - Name of the instance scoping this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [withExtendedNotifications] - Determines whether the customers receive
  /// notifications before migration. Only applicable to SF vms.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> simulateMaintenanceEvent(
    core.String project,
    core.String zone,
    core.String instance, {
    core.String? requestId,
    core.bool? withExtendedNotifications,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if (withExtendedNotifications != null)
        'withExtendedNotifications': ['${withExtendedNotifications}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/simulateMaintenanceEvent';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Starts an instance that was stopped using the instances().stop method.
  ///
  /// For more information, see Restart an instance.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - Name of the instance resource to start.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> start(
    core.String project,
    core.String zone,
    core.String instance, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/start';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Starts an instance that was stopped using the instances().stop method.
  ///
  /// For more information, see Restart an instance.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - Name of the instance resource to start.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> startWithEncryptionKey(
    InstancesStartWithEncryptionKeyRequest request,
    core.String project,
    core.String zone,
    core.String instance, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/startWithEncryptionKey';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Stops a running instance, shutting it down cleanly, and allows you to
  /// restart the instance at a later time.
  ///
  /// Stopped instances do not incur VM usage charges while they are stopped.
  /// However, resources that the VM is using, such as persistent disks and
  /// static IP addresses, will continue to be charged until they are deleted.
  /// For more information, see Stopping an instance.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - Name of the instance resource to stop.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [discardLocalSsd] - This property is required if the instance has any
  /// attached Local SSD disks. If false, Local SSD data will be preserved when
  /// the instance is suspended. If true, the contents of any attached Local SSD
  /// disks will be discarded.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> stop(
    core.String project,
    core.String zone,
    core.String instance, {
    core.bool? discardLocalSsd,
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (discardLocalSsd != null) 'discardLocalSsd': ['${discardLocalSsd}'],
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/stop';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// This method suspends a running instance, saving its state to persistent
  /// storage, and allows you to resume the instance at a later time.
  ///
  /// Suspended instances have no compute costs (cores or RAM), and incur only
  /// storage charges for the saved VM memory and localSSD data. Any charged
  /// resources the virtual machine was using, such as persistent disks and
  /// static IP addresses, will continue to be charged while the instance is
  /// suspended. For more information, see Suspending and resuming an instance.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - Name of the instance resource to suspend.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [discardLocalSsd] - This property is required if the instance has any
  /// attached Local SSD disks. If false, Local SSD data will be preserved when
  /// the instance is suspended. If true, the contents of any attached Local SSD
  /// disks will be discarded.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> suspend(
    core.String project,
    core.String zone,
    core.String instance, {
    core.bool? discardLocalSsd,
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (discardLocalSsd != null) 'discardLocalSsd': ['${discardLocalSsd}'],
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/suspend';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [TestPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<TestPermissionsResponse> testIamPermissions(
    TestPermissionsRequest request,
    core.String project,
    core.String zone,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$resource') +
        '/testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return TestPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates an instance only if the necessary resources are available.
  ///
  /// This method can update only a specific set of instance properties. See
  /// Updating a running instance for a list of updatable instance properties.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - Name of the instance resource to update.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [minimalAction] - Specifies the action to take when updating an instance
  /// even if the updated properties do not require it. If not specified, then
  /// Compute Engine acts based on the minimum action that the updated
  /// properties require.
  /// Possible string values are:
  /// - "INVALID"
  /// - "NO_EFFECT" : No changes can be made to the instance.
  /// - "REFRESH" : The instance will not restart.
  /// - "RESTART" : The instance will restart.
  ///
  /// [mostDisruptiveAllowedAction] - Specifies the most disruptive action that
  /// can be taken on the instance as part of the update. Compute Engine returns
  /// an error if the instance properties require a more disruptive action as
  /// part of the instance update. Valid options from lowest to highest are
  /// NO_EFFECT, REFRESH, and RESTART.
  /// Possible string values are:
  /// - "INVALID"
  /// - "NO_EFFECT" : No changes can be made to the instance.
  /// - "REFRESH" : The instance will not restart.
  /// - "RESTART" : The instance will restart.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> update(
    Instance request,
    core.String project,
    core.String zone,
    core.String instance, {
    core.String? minimalAction,
    core.String? mostDisruptiveAllowedAction,
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (minimalAction != null) 'minimalAction': [minimalAction],
      if (mostDisruptiveAllowedAction != null)
        'mostDisruptiveAllowedAction': [mostDisruptiveAllowedAction],
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance');

    final response_ = await _requester.request(
      url_,
      'PUT',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates the specified access config from an instance's network interface
  /// with the data included in the request.
  ///
  /// This method supports PATCH semantics and uses the JSON merge patch format
  /// and processing rules.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - The instance name for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [networkInterface] - The name of the network interface where the access
  /// config is attached.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> updateAccessConfig(
    AccessConfig request,
    core.String project,
    core.String zone,
    core.String instance,
    core.String networkInterface, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      'networkInterface': [networkInterface],
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/updateAccessConfig';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates the Display config for a VM instance.
  ///
  /// You can only use this method on a stopped VM instance. This method
  /// supports PATCH semantics and uses the JSON merge patch format and
  /// processing rules.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - Name of the instance scoping this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> updateDisplayDevice(
    DisplayDevice request,
    core.String project,
    core.String zone,
    core.String instance, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/updateDisplayDevice';

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates an instance's network interface.
  ///
  /// This method can only update an interface's alias IP range and attached
  /// network. See Modifying alias IP ranges for an existing instance for
  /// instructions on changing alias IP ranges. See Migrating a VM between
  /// networks for instructions on migrating an interface. This method follows
  /// PATCH semantics.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - The instance name for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [networkInterface] - The name of the network interface to update.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> updateNetworkInterface(
    NetworkInterface request,
    core.String project,
    core.String zone,
    core.String instance,
    core.String networkInterface, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      'networkInterface': [networkInterface],
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/updateNetworkInterface';

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates the Shielded Instance config for an instance.
  ///
  /// You can only use this method on a stopped instance. This method supports
  /// PATCH semantics and uses the JSON merge patch format and processing rules.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instance] - Name or id of the instance scoping this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> updateShieldedInstanceConfig(
    ShieldedInstanceConfig request,
    core.String project,
    core.String zone,
    core.String instance, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instances/' +
        commons.escapeVariable('$instance') +
        '/updateShieldedInstanceConfig';

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }
}

class InstantSnapshotsResource {
  final commons.ApiRequester _requester;

  InstantSnapshotsResource(commons.ApiRequester client) : _requester = client;

  /// Retrieves an aggregated list of instantSnapshots.
  ///
  /// To prevent failure, Google recommends that you set the
  /// `returnPartialSuccess` parameter to `true`.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [includeAllScopes] - Indicates whether every visible scope for each scope
  /// type (zone, region, global) should be included in the response. For new
  /// resource types added after this field, the flag has no effect as new
  /// resource types will always include every visible scope for each scope type
  /// in response. For resource types which predate this field, if this flag is
  /// omitted or false, only scopes of the scope types where the resource type
  /// is expected to be found will be included.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [serviceProjectNumber] - The Shared VPC service project id or service
  /// project number for which aggregated list request is invoked for
  /// subnetworks list-usable api.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstantSnapshotAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstantSnapshotAggregatedList> aggregatedList(
    core.String project, {
    core.String? filter,
    core.bool? includeAllScopes,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? serviceProjectNumber,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (includeAllScopes != null) 'includeAllScopes': ['${includeAllScopes}'],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if (serviceProjectNumber != null)
        'serviceProjectNumber': [serviceProjectNumber],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/aggregated/instantSnapshots';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return InstantSnapshotAggregatedList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes the specified InstantSnapshot resource.
  ///
  /// Keep in mind that deleting a single instantSnapshot might not necessarily
  /// delete all the data on that instantSnapshot. If any data on the
  /// instantSnapshot that is marked for deletion is needed for subsequent
  /// instantSnapshots, the data will be moved to the next corresponding
  /// instantSnapshot. For more information, see Deleting instantSnapshots.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instantSnapshot] - Name of the InstantSnapshot resource to delete.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
    core.String project,
    core.String zone,
    core.String instantSnapshot, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instantSnapshots/' +
        commons.escapeVariable('$instantSnapshot');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the specified InstantSnapshot resource in the specified zone.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [instantSnapshot] - Name of the InstantSnapshot resource to return.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstantSnapshot].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstantSnapshot> get(
    core.String project,
    core.String zone,
    core.String instantSnapshot, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instantSnapshots/' +
        commons.escapeVariable('$instantSnapshot');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return InstantSnapshot.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the access control policy for a resource.
  ///
  /// May be empty if no such policy or resource exists.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [optionsRequestedPolicyVersion] - Requested IAM Policy version.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> getIamPolicy(
    core.String project,
    core.String zone,
    core.String resource, {
    core.int? optionsRequestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (optionsRequestedPolicyVersion != null)
        'optionsRequestedPolicyVersion': ['${optionsRequestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instantSnapshots/' +
        commons.escapeVariable('$resource') +
        '/getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Policy.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates an instant snapshot in the specified zone.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - Name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
    InstantSnapshot request,
    core.String project,
    core.String zone, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instantSnapshots';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves the list of InstantSnapshot resources contained within the
  /// specified zone.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InstantSnapshotList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InstantSnapshotList> list(
    core.String project,
    core.String zone, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instantSnapshots';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return InstantSnapshotList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified resource.
  ///
  /// Replaces any existing policy.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> setIamPolicy(
    ZoneSetPolicyRequest request,
    core.String project,
    core.String zone,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instantSnapshots/' +
        commons.escapeVariable('$resource') +
        '/setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Policy.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the labels on a instantSnapshot in the given zone.
  ///
  /// To learn more about labels, read the Labeling Resources documentation.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setLabels(
    ZoneSetLabelsRequest request,
    core.String project,
    core.String zone,
    core.String resource, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instantSnapshots/' +
        commons.escapeVariable('$resource') +
        '/setLabels';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [TestPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<TestPermissionsResponse> testIamPermissions(
    TestPermissionsRequest request,
    core.String project,
    core.String zone,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/instantSnapshots/' +
        commons.escapeVariable('$resource') +
        '/testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return TestPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class InterconnectAttachmentsResource {
  final commons.ApiRequester _requester;

  InterconnectAttachmentsResource(commons.ApiRequester client)
      : _requester = client;

  /// Retrieves an aggregated list of interconnect attachments.
  ///
  /// To prevent failure, Google recommends that you set the
  /// `returnPartialSuccess` parameter to `true`.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [includeAllScopes] - Indicates whether every visible scope for each scope
  /// type (zone, region, global) should be included in the response. For new
  /// resource types added after this field, the flag has no effect as new
  /// resource types will always include every visible scope for each scope type
  /// in response. For resource types which predate this field, if this flag is
  /// omitted or false, only scopes of the scope types where the resource type
  /// is expected to be found will be included.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [serviceProjectNumber] - The Shared VPC service project id or service
  /// project number for which aggregated list request is invoked for
  /// subnetworks list-usable api.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InterconnectAttachmentAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InterconnectAttachmentAggregatedList> aggregatedList(
    core.String project, {
    core.String? filter,
    core.bool? includeAllScopes,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? serviceProjectNumber,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (includeAllScopes != null) 'includeAllScopes': ['${includeAllScopes}'],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if (serviceProjectNumber != null)
        'serviceProjectNumber': [serviceProjectNumber],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/aggregated/interconnectAttachments';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return InterconnectAttachmentAggregatedList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes the specified interconnect attachment.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [region] - Name of the region for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [interconnectAttachment] - Name of the interconnect attachment to delete.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
    core.String project,
    core.String region,
    core.String interconnectAttachment, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/regions/' +
        commons.escapeVariable('$region') +
        '/interconnectAttachments/' +
        commons.escapeVariable('$interconnectAttachment');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the specified interconnect attachment.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [region] - Name of the region for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [interconnectAttachment] - Name of the interconnect attachment to return.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InterconnectAttachment].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InterconnectAttachment> get(
    core.String project,
    core.String region,
    core.String interconnectAttachment, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/regions/' +
        commons.escapeVariable('$region') +
        '/interconnectAttachments/' +
        commons.escapeVariable('$interconnectAttachment');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return InterconnectAttachment.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates an InterconnectAttachment in the specified project using the data
  /// included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [region] - Name of the region for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [validateOnly] - If true, the request will not be committed.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
    InterconnectAttachment request,
    core.String project,
    core.String region, {
    core.String? requestId,
    core.bool? validateOnly,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if (validateOnly != null) 'validateOnly': ['${validateOnly}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/regions/' +
        commons.escapeVariable('$region') +
        '/interconnectAttachments';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves the list of interconnect attachments contained within the
  /// specified region.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [region] - Name of the region for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InterconnectAttachmentList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InterconnectAttachmentList> list(
    core.String project,
    core.String region, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/regions/' +
        commons.escapeVariable('$region') +
        '/interconnectAttachments';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return InterconnectAttachmentList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates the specified interconnect attachment with the data included in
  /// the request.
  ///
  /// This method supports PATCH semantics and uses the JSON merge patch format
  /// and processing rules.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [region] - Name of the region scoping this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [interconnectAttachment] - Name of the interconnect attachment to patch.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> patch(
    InterconnectAttachment request,
    core.String project,
    core.String region,
    core.String interconnectAttachment, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/regions/' +
        commons.escapeVariable('$region') +
        '/interconnectAttachments/' +
        commons.escapeVariable('$interconnectAttachment');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the labels on an InterconnectAttachment.
  ///
  /// To learn more about labels, read the Labeling Resources documentation.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [region] - The region for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setLabels(
    RegionSetLabelsRequest request,
    core.String project,
    core.String region,
    core.String resource, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/regions/' +
        commons.escapeVariable('$region') +
        '/interconnectAttachments/' +
        commons.escapeVariable('$resource') +
        '/setLabels';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }
}

class InterconnectLocationsResource {
  final commons.ApiRequester _requester;

  InterconnectLocationsResource(commons.ApiRequester client)
      : _requester = client;

  /// Returns the details for the specified interconnect location.
  ///
  /// Gets a list of available interconnect locations by making a list()
  /// request.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [interconnectLocation] - Name of the interconnect location to return.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InterconnectLocation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InterconnectLocation> get(
    core.String project,
    core.String interconnectLocation, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/interconnectLocations/' +
        commons.escapeVariable('$interconnectLocation');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return InterconnectLocation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves the list of interconnect locations available to the specified
  /// project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InterconnectLocationList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InterconnectLocationList> list(
    core.String project, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/interconnectLocations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return InterconnectLocationList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class InterconnectRemoteLocationsResource {
  final commons.ApiRequester _requester;

  InterconnectRemoteLocationsResource(commons.ApiRequester client)
      : _requester = client;

  /// Returns the details for the specified interconnect remote location.
  ///
  /// Gets a list of available interconnect remote locations by making a list()
  /// request.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [interconnectRemoteLocation] - Name of the interconnect remote location to
  /// return.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InterconnectRemoteLocation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InterconnectRemoteLocation> get(
    core.String project,
    core.String interconnectRemoteLocation, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/interconnectRemoteLocations/' +
        commons.escapeVariable('$interconnectRemoteLocation');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return InterconnectRemoteLocation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves the list of interconnect remote locations available to the
  /// specified project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InterconnectRemoteLocationList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InterconnectRemoteLocationList> list(
    core.String project, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/interconnectRemoteLocations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return InterconnectRemoteLocationList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class InterconnectsResource {
  final commons.ApiRequester _requester;

  InterconnectsResource(commons.ApiRequester client) : _requester = client;

  /// Deletes the specified Interconnect.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [interconnect] - Name of the interconnect to delete.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
    core.String project,
    core.String interconnect, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/interconnects/' +
        commons.escapeVariable('$interconnect');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the specified Interconnect.
  ///
  /// Get a list of available Interconnects by making a list() request.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [interconnect] - Name of the interconnect to return.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Interconnect].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Interconnect> get(
    core.String project,
    core.String interconnect, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/interconnects/' +
        commons.escapeVariable('$interconnect');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Interconnect.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the interconnectDiagnostics for the specified Interconnect.
  ///
  /// In the event of a global outage, do not use this API to make decisions
  /// about where to redirect your network traffic. Unlike a VLAN attachment,
  /// which is regional, a Cloud Interconnect connection is a global resource. A
  /// global outage can prevent this API from functioning properly.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [interconnect] - Name of the interconnect resource to query.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InterconnectsGetDiagnosticsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InterconnectsGetDiagnosticsResponse> getDiagnostics(
    core.String project,
    core.String interconnect, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/interconnects/' +
        commons.escapeVariable('$interconnect') +
        '/getDiagnostics';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return InterconnectsGetDiagnosticsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the interconnectMacsecConfig for the specified Interconnect.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [interconnect] - Name of the interconnect resource to query.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InterconnectsGetMacsecConfigResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InterconnectsGetMacsecConfigResponse> getMacsecConfig(
    core.String project,
    core.String interconnect, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/interconnects/' +
        commons.escapeVariable('$interconnect') +
        '/getMacsecConfig';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return InterconnectsGetMacsecConfigResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates an Interconnect in the specified project using the data included
  /// in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
    Interconnect request,
    core.String project, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/interconnects';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves the list of Interconnects available to the specified project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [InterconnectList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<InterconnectList> list(
    core.String project, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/interconnects';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return InterconnectList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates the specified Interconnect with the data included in the request.
  ///
  /// This method supports PATCH semantics and uses the JSON merge patch format
  /// and processing rules.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [interconnect] - Name of the interconnect to update.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> patch(
    Interconnect request,
    core.String project,
    core.String interconnect, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/interconnects/' +
        commons.escapeVariable('$interconnect');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the labels on an Interconnect.
  ///
  /// To learn more about labels, read the Labeling Resources documentation.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9_\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> setLabels(
    GlobalSetLabelsRequest request,
    core.String project,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/interconnects/' +
        commons.escapeVariable('$resource') +
        '/setLabels';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }
}

class LicenseCodesResource {
  final commons.ApiRequester _requester;

  LicenseCodesResource(commons.ApiRequester client) : _requester = client;

  /// Return a specified license code.
  ///
  /// License codes are mirrored across all projects that have permissions to
  /// read the License Code. *Caution* This resource is intended for use only by
  /// third-party partners who are creating Cloud Marketplace images.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [licenseCode] - Number corresponding to the License code resource to
  /// return.
  /// Value must have pattern `\[0-9\]{0,61}?`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [LicenseCode].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<LicenseCode> get(
    core.String project,
    core.String licenseCode, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/licenseCodes/' +
        commons.escapeVariable('$licenseCode');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return LicenseCode.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// *Caution* This resource is intended for use only by third-party partners
  /// who are creating Cloud Marketplace images.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9_\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [TestPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<TestPermissionsResponse> testIamPermissions(
    TestPermissionsRequest request,
    core.String project,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/licenseCodes/' +
        commons.escapeVariable('$resource') +
        '/testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return TestPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class LicensesResource {
  final commons.ApiRequester _requester;

  LicensesResource(commons.ApiRequester client) : _requester = client;

  /// Deletes the specified license.
  ///
  /// *Caution* This resource is intended for use only by third-party partners
  /// who are creating Cloud Marketplace images.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [license] - Name of the license resource to delete.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
    core.String project,
    core.String license, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/licenses/' +
        commons.escapeVariable('$license');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the specified License resource.
  ///
  /// *Caution* This resource is intended for use only by third-party partners
  /// who are creating Cloud Marketplace images.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [license] - Name of the License resource to return.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [License].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<License> get(
    core.String project,
    core.String license, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/licenses/' +
        commons.escapeVariable('$license');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return License.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the access control policy for a resource.
  ///
  /// May be empty if no such policy or resource exists. *Caution* This resource
  /// is intended for use only by third-party partners who are creating Cloud
  /// Marketplace images.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9_\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [optionsRequestedPolicyVersion] - Requested IAM Policy version.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> getIamPolicy(
    core.String project,
    core.String resource, {
    core.int? optionsRequestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (optionsRequestedPolicyVersion != null)
        'optionsRequestedPolicyVersion': ['${optionsRequestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/licenses/' +
        commons.escapeVariable('$resource') +
        '/getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Policy.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Create a License resource in the specified project.
  ///
  /// *Caution* This resource is intended for use only by third-party partners
  /// who are creating Cloud Marketplace images.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
    License request,
    core.String project, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'projects/' + commons.escapeVariable('$project') + '/global/licenses';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves the list of licenses available in the specified project.
  ///
  /// This method does not get any licenses that belong to other projects,
  /// including licenses attached to publicly-available images, like Debian 9.
  /// If you want to get a list of publicly-available licenses, use this method
  /// to make a request to the respective image project, such as debian-cloud or
  /// windows-cloud. *Caution* This resource is intended for use only by
  /// third-party partners who are creating Cloud Marketplace images.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [LicensesListResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<LicensesListResponse> list(
    core.String project, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'projects/' + commons.escapeVariable('$project') + '/global/licenses';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return LicensesListResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified resource.
  ///
  /// Replaces any existing policy. *Caution* This resource is intended for use
  /// only by third-party partners who are creating Cloud Marketplace images.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9_\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> setIamPolicy(
    GlobalSetPolicyRequest request,
    core.String project,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/licenses/' +
        commons.escapeVariable('$resource') +
        '/setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Policy.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// *Caution* This resource is intended for use only by third-party partners
  /// who are creating Cloud Marketplace images.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9_\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [TestPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<TestPermissionsResponse> testIamPermissions(
    TestPermissionsRequest request,
    core.String project,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/licenses/' +
        commons.escapeVariable('$resource') +
        '/testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return TestPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class MachineImagesResource {
  final commons.ApiRequester _requester;

  MachineImagesResource(commons.ApiRequester client) : _requester = client;

  /// Deletes the specified machine image.
  ///
  /// Deleting a machine image is permanent and cannot be undone.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [machineImage] - The name of the machine image to delete.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
    core.String project,
    core.String machineImage, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/machineImages/' +
        commons.escapeVariable('$machineImage');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the specified machine image.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [machineImage] - The name of the machine image.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [MachineImage].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<MachineImage> get(
    core.String project,
    core.String machineImage, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/machineImages/' +
        commons.escapeVariable('$machineImage');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return MachineImage.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the access control policy for a resource.
  ///
  /// May be empty if no such policy or resource exists.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9_\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [optionsRequestedPolicyVersion] - Requested IAM Policy version.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> getIamPolicy(
    core.String project,
    core.String resource, {
    core.int? optionsRequestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (optionsRequestedPolicyVersion != null)
        'optionsRequestedPolicyVersion': ['${optionsRequestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/machineImages/' +
        commons.escapeVariable('$resource') +
        '/getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Policy.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates a machine image in the specified project using the data that is
  /// included in the request.
  ///
  /// If you are creating a new machine image to update an existing instance,
  /// your new machine image should use the same network or, if applicable, the
  /// same subnetwork as the original instance.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000).
  ///
  /// [sourceInstance] - Required. Source instance that is used to create the
  /// machine image from.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
    MachineImage request,
    core.String project, {
    core.String? requestId,
    core.String? sourceInstance,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if (sourceInstance != null) 'sourceInstance': [sourceInstance],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/machineImages';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves a list of machine images that are contained within the specified
  /// project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [MachineImageList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<MachineImageList> list(
    core.String project, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/machineImages';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return MachineImageList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified resource.
  ///
  /// Replaces any existing policy.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9_\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> setIamPolicy(
    GlobalSetPolicyRequest request,
    core.String project,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/machineImages/' +
        commons.escapeVariable('$resource') +
        '/setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Policy.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9_\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [TestPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<TestPermissionsResponse> testIamPermissions(
    TestPermissionsRequest request,
    core.String project,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/global/machineImages/' +
        commons.escapeVariable('$resource') +
        '/testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return TestPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class MachineTypesResource {
  final commons.ApiRequester _requester;

  MachineTypesResource(commons.ApiRequester client) : _requester = client;

  /// Retrieves an aggregated list of machine types.
  ///
  /// To prevent failure, Google recommends that you set the
  /// `returnPartialSuccess` parameter to `true`.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [includeAllScopes] - Indicates whether every visible scope for each scope
  /// type (zone, region, global) should be included in the response. For new
  /// resource types added after this field, the flag has no effect as new
  /// resource types will always include every visible scope for each scope type
  /// in response. For resource types which predate this field, if this flag is
  /// omitted or false, only scopes of the scope types where the resource type
  /// is expected to be found will be included.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [serviceProjectNumber] - The Shared VPC service project id or service
  /// project number for which aggregated list request is invoked for
  /// subnetworks list-usable api.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [MachineTypeAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<MachineTypeAggregatedList> aggregatedList(
    core.String project, {
    core.String? filter,
    core.bool? includeAllScopes,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? serviceProjectNumber,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (includeAllScopes != null) 'includeAllScopes': ['${includeAllScopes}'],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if (serviceProjectNumber != null)
        'serviceProjectNumber': [serviceProjectNumber],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/aggregated/machineTypes';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return MachineTypeAggregatedList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the specified machine type.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [machineType] - Name of the machine type to return.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [MachineType].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<MachineType> get(
    core.String project,
    core.String zone,
    core.String machineType, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/machineTypes/' +
        commons.escapeVariable('$machineType');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return MachineType.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves a list of machine types available to the specified project.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [zone] - The name of the zone for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [MachineTypeList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<MachineTypeList> list(
    core.String project,
    core.String zone, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/zones/' +
        commons.escapeVariable('$zone') +
        '/machineTypes';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return MachineTypeList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class NetworkAttachmentsResource {
  final commons.ApiRequester _requester;

  NetworkAttachmentsResource(commons.ApiRequester client) : _requester = client;

  /// Retrieves the list of all NetworkAttachment resources, regional and
  /// global, available to the specified project.
  ///
  /// To prevent failure, Google recommends that you set the
  /// `returnPartialSuccess` parameter to `true`.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [includeAllScopes] - Indicates whether every visible scope for each scope
  /// type (zone, region, global) should be included in the response. For new
  /// resource types added after this field, the flag has no effect as new
  /// resource types will always include every visible scope for each scope type
  /// in response. For resource types which predate this field, if this flag is
  /// omitted or false, only scopes of the scope types where the resource type
  /// is expected to be found will be included.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [serviceProjectNumber] - The Shared VPC service project id or service
  /// project number for which aggregated list request is invoked for
  /// subnetworks list-usable api.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [NetworkAttachmentAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<NetworkAttachmentAggregatedList> aggregatedList(
    core.String project, {
    core.String? filter,
    core.bool? includeAllScopes,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? serviceProjectNumber,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (includeAllScopes != null) 'includeAllScopes': ['${includeAllScopes}'],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if (serviceProjectNumber != null)
        'serviceProjectNumber': [serviceProjectNumber],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/aggregated/networkAttachments';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return NetworkAttachmentAggregatedList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes the specified NetworkAttachment in the given scope
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [region] - Name of the region of this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [networkAttachment] - Name of the NetworkAttachment resource to delete.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000). end_interface:
  /// MixerMutationRequestBuilder
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> delete(
    core.String project,
    core.String region,
    core.String networkAttachment, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/regions/' +
        commons.escapeVariable('$region') +
        '/networkAttachments/' +
        commons.escapeVariable('$networkAttachment');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the specified NetworkAttachment resource in the given scope.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [region] - Name of the region of this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [networkAttachment] - Name of the NetworkAttachment resource to return.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [NetworkAttachment].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<NetworkAttachment> get(
    core.String project,
    core.String region,
    core.String networkAttachment, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/regions/' +
        commons.escapeVariable('$region') +
        '/networkAttachments/' +
        commons.escapeVariable('$networkAttachment');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return NetworkAttachment.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the access control policy for a resource.
  ///
  /// May be empty if no such policy or resource exists.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [region] - The name of the region for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [optionsRequestedPolicyVersion] - Requested IAM Policy version.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> getIamPolicy(
    core.String project,
    core.String region,
    core.String resource, {
    core.int? optionsRequestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (optionsRequestedPolicyVersion != null)
        'optionsRequestedPolicyVersion': ['${optionsRequestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/regions/' +
        commons.escapeVariable('$region') +
        '/networkAttachments/' +
        commons.escapeVariable('$resource') +
        '/getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return Policy.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates a NetworkAttachment in the specified project in the given scope
  /// using the parameters that are included in the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [region] - Name of the region of this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000). end_interface:
  /// MixerMutationRequestBuilder
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> insert(
    NetworkAttachment request,
    core.String project,
    core.String region, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/regions/' +
        commons.escapeVariable('$region') +
        '/networkAttachments';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists the NetworkAttachments for a project in the given scope.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [region] - Name of the region of this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [NetworkAttachmentList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<NetworkAttachmentList> list(
    core.String project,
    core.String region, {
    core.String? filter,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/regions/' +
        commons.escapeVariable('$region') +
        '/networkAttachments';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return NetworkAttachmentList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Patches the specified NetworkAttachment resource with the data included in
  /// the request.
  ///
  /// This method supports PATCH semantics and uses JSON merge patch format and
  /// processing rules.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [region] - Name of the region for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [networkAttachment] - Name of the NetworkAttachment resource to patch.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [requestId] - An optional request ID to identify requests. Specify a
  /// unique request ID so that if you must retry your request, the server will
  /// know to ignore the request if it has already been completed. For example,
  /// consider a situation where you make an initial request and the request
  /// times out. If you make the request again with the same request ID, the
  /// server can check if original operation with the same request ID was
  /// received, and if so, will ignore the second request. This prevents clients
  /// from accidentally creating duplicate commitments. The request ID must be a
  /// valid UUID with the exception that zero UUID is not supported (
  /// 00000000-0000-0000-0000-000000000000). end_interface:
  /// MixerMutationRequestBuilder
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Operation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Operation> patch(
    NetworkAttachment request,
    core.String project,
    core.String region,
    core.String networkAttachment, {
    core.String? requestId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (requestId != null) 'requestId': [requestId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/regions/' +
        commons.escapeVariable('$region') +
        '/networkAttachments/' +
        commons.escapeVariable('$networkAttachment');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return Operation.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified resource.
  ///
  /// Replaces any existing policy.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [region] - The name of the region for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<Policy> setIamPolicy(
    RegionSetPolicyRequest request,
    core.String project,
    core.String region,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/regions/' +
        commons.escapeVariable('$region') +
        '/networkAttachments/' +
        commons.escapeVariable('$resource') +
        '/setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return Policy.fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [region] - The name of the region for this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [resource] - Name or id of the resource for this request.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?|\[1-9\]\[0-9\]{0,19}`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [TestPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<TestPermissionsResponse> testIamPermissions(
    TestPermissionsRequest request,
    core.String project,
    core.String region,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/regions/' +
        commons.escapeVariable('$region') +
        '/networkAttachments/' +
        commons.escapeVariable('$resource') +
        '/testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return TestPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class NetworkEdgeSecurityServicesResource {
  final commons.ApiRequester _requester;

  NetworkEdgeSecurityServicesResource(commons.ApiRequester client)
      : _requester = client;

  /// Retrieves the list of all NetworkEdgeSecurityService resources available
  /// to the specified project.
  ///
  /// To prevent failure, Google recommends that you set the
  /// `returnPartialSuccess` parameter to `true`.
  ///
  /// Request parameters:
  ///
  /// [project] - Name of the project scoping this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [filter] - A filter expression that filters resources listed in the
  /// response. Most Compute resources support two types of filter expressions:
  /// expressions that support regular expressions and expressions that follow
  /// API improvement proposal AIP-160. These two types of filter expressions
  /// cannot be mixed in one request. If you want to use AIP-160, your
  /// expression must specify the field name, an operator, and the value that
  /// you want to use for filtering. The value must be a string, a number, or a
  /// boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or
  /// `:`. For example, if you are filtering Compute Engine instances, you can
  /// exclude instances named `example-instance` by specifying `name !=
  /// example-instance`. The `:*` comparison can be used to test whether a key
  /// has been defined. For example, to find all objects with `owner` label use:
  /// ``` labels.owner:* ``` You can also filter nested fields. For example, you
  /// could specify `scheduling.automaticRestart = false` to include instances
  /// only if they are not scheduled for automatic restarts. You can use
  /// filtering on nested fields to filter based on resource labels. To filter
  /// on multiple expressions, provide each separate expression within
  /// parentheses. For example: ``` (scheduling.automaticRestart = true)
  /// (cpuPlatform = "Intel Skylake") ``` By default, each expression is an
  /// `AND` expression. However, you can include `AND` and `OR` expressions
  /// explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
  /// (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)
  /// ``` If you want to use a regular expression, use the `eq` (equal) or `ne`
  /// (not equal) operator against a single un-parenthesized expression with or
  /// without quotes or against multiple parenthesized expressions. Examples:
  /// `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'`
  /// `fieldname eq "double quoted literal"` `(fieldname1 eq literal)
  /// (fieldname2 ne "literal")` The literal value is interpreted as a regular
  /// expression using Google RE2 library syntax. The literal value must match
  /// the entire field. For example, to filter for instances that do not end
  /// with name "instance", you would use `name ne .*instance`. You cannot
  /// combine constraints on multiple fields using regular expressions.
  ///
  /// [includeAllScopes] - Indicates whether every visible scope for each scope
  /// type (zone, region, global) should be included in the response. For new
  /// resource types added after this field, the flag has no effect as new
  /// resource types will always include every visible scope for each scope type
  /// in response. For resource types which predate this field, if this flag is
  /// omitted or false, only scopes of the scope types where the resource type
  /// is expected to be found will be included.
  ///
  /// [maxResults] - The maximum number of results per page that should be
  /// returned. If the number of available results is larger than `maxResults`,
  /// Compute Engine returns a `nextPageToken` that can be used to get the next
  /// page of results in subsequent list requests. Acceptable values are `0` to
  /// `500`, inclusive. (Default: `500`)
  ///
  /// [orderBy] - Sorts list results by a certain order. By default, results are
  /// returned in alphanumerical order based on the resource name. You can also
  /// sort results in descending order based on the creation timestamp using
  /// `orderBy="creationTimestamp desc"`. This sorts results based on the
  /// `creationTimestamp` field in reverse chronological order (newest result
  /// first). Use this to sort resources like operations so that the newest
  /// operation is returned first. Currently, only sorting by `name` or
  /// `creationTimestamp desc` is supported.
  ///
  /// [pageToken] - Specifies a page token to use. Set `pageToken` to the
  /// `nextPageToken` returned by a previous list request to get the next page
  /// of results.
  ///
  /// [returnPartialSuccess] - Opt-in for partial success behavior which
  /// provides partial results in case of failure. The default value is false.
  /// For example, when partial success behavior is enabled, aggregatedList for
  /// a single zone scope either returns all resources in the zone or no
  /// resources, with an error code.
  ///
  /// [serviceProjectNumber] - The Shared VPC service project id or service
  /// project number for which aggregated list request is invoked for
  /// subnetworks list-usable api.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [NetworkEdgeSecurityServiceAggregatedList].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<NetworkEdgeSecurityServiceAggregatedList> aggregatedList(
    core.String project, {
    core.String? filter,
    core.bool? includeAllScopes,
    core.int? maxResults,
    core.String? orderBy,
    core.String? pageToken,
    core.bool? returnPartialSuccess,
    core.String? serviceProjectNumber,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (includeAllScopes != null) 'includeAllScopes': ['${includeAllScopes}'],
      if (maxResults != null) 'maxResults': ['${maxResults}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageToken != null) 'pageToken': [pageToken],
      if (returnPartialSuccess != null)
        'returnPartialSuccess': ['${returnPartialSuccess}'],
      if (serviceProjectNumber != null)
        'serviceProjectNumber': [serviceProjectNumber],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'projects/' +
        commons.escapeVariable('$project') +
        '/aggregated/networkEdgeSecurityServices';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return NetworkEdgeSecurityServiceAggregatedList.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes the specified service.
  ///
  /// Request parameters:
  ///
  /// [project] - Project ID for this request.
  /// Value must have pattern
  /// `(?:(?:\[-a-z0-9\]{1,63}\.)*(?:\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?):)?(?:\[0-9\]{1,19}|(?:\[a-z0-9\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?))`.
  ///
  /// [region] - Name of the region scoping this request.
  /// Value must have pattern `\[a-z\](?:\[-a-z0-9\]{0,61}\[a-z0-9\])?`.
  ///
  /// [networkEdgeSecurityService] - Name of the network edge security service
  /// to delete.
  /// Value must have pattern
  /// `\[a-z\](?:\[-a-z0-9\]{0,61}