package com.bringyour.network.ui.theme

import androidx.compose.ui.graphics.Color
import com.bringyour.network.utils.lighten

// URNetwork Color Pallets
val Blue100 = Color(0xFFE5F2FD)
val Blue200 = Color(0xFFD6E6F4)
val Blue300 = Color(0xFFA4C4F4)
val Blue400 = Color(0xFF638BFC)
val Blue500 = Color(0xFF2A60FF)
val Blue600 = Color(0xFF0039DE)
val Blue700 = Color(0xFF1000CD)
val Blue800 = Color(0xFF1B119A)
val Blue900 = Color(0xFF1A1460)

val Pink100 = Color(0xFFFAE7FF)
val Pink200 = Color(0xFFF5CEFF)
val Pink300 = Color(0xFFED8FFF)
val Pink400 = Color(0xFFE974FE)
val Pink500 = Color(0xFFDC40F5)
val Pink600 = Color(0xFFC320D9)
val Pink700 = Color(0xFFA417B4)
val Pink800 = Color(0xFF721778)
val Pink900 = Color(0xFF4B0151)

val Red100 = Color(0xFFFFE5E1)
val Red200 = Color(0xFFFFCEC7)
val Red300 = Color(0xFFFFABA0)
val Red400 = Color(0xFFFF6C58)
val Red500 = Color(0xFFF8523B)
val Red600 = Color(0xFFE5351D)
val Red700 = Color(0xFFC12914)
val Red800 = Color(0xFF7B2215)
val Red900 = Color(0xFF421006)

val Yellow100 = Color(0xFFF9FFCF)
val Yellow200 = Color(0xFFEFF7BB)
val Yellow300 = Color(0xFFE9F37D)
val Yellow400 = Color(0xFFE6EA23)
val Yellow500 = Color(0xFFD7DC00)
val Yellow600 = Color(0xFFBFC300)
val Yellow700 = Color(0xFF9B9E00)
val Yellow800 = Color(0xFF797C00)
val Yellow900 = Color(0xFF444600)

val Green100 = Color(0xFFD6FFC8)
val Green200 = Color(0xFFB0FF97)
val Green300 = Color(0xFF87FB67)
val Green400 = Color(0xFF53F12A)
val Green500 = Color(0xFF31D70B)
val Green600 = Color(0xFF21AC04)
val Green700 = Color(0xFF1B8308)
val Green800 = Color(0xFF185710)
val Green900 = Color(0xFF063102)

// URnetwork Color Theme

val BlueDark = Blue900
val BlueMedium = Blue400
val BlueLight = Blue200
val Pink = Pink300
val RedDark = Red900
val Red = Red400
val Yellow = Yellow200
val Green = Green300

val MainBorderBase = Color(0x1FFFFFFF)

// text
val TextMuted = Color(0xFF989898)
val TextFaint = Color(0xFF5A5A5A)
val TextDanger = Red500
val MainTextBase = Color.White
val MainTintedBackgroundBase = Color(0xFF1C1C1C)

val OffWhite = Color(0xFFF8F8F8)
val Black = Color(0xFF101010)
val OffBlack = Color(0xFF1C1C1C)
val SheetBlack = Black.lighten(0.03f)