"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CryptoAccount = void 0;
const _1 = require(".");
const lib_1 = require("./lib");
const RegistryItem_1 = require("./RegistryItem");
const RegistryType_1 = require("./RegistryType");
var Keys;
(function (Keys) {
    Keys[Keys["masterFingerprint"] = 1] = "masterFingerprint";
    Keys[Keys["outputDescriptors"] = 2] = "outputDescriptors";
})(Keys || (Keys = {}));
class CryptoAccount extends RegistryItem_1.RegistryItem {
    constructor(masterFingerprint, outputDescriptors) {
        super();
        this.masterFingerprint = masterFingerprint;
        this.outputDescriptors = outputDescriptors;
        this.getRegistryType = () => {
            return RegistryType_1.RegistryTypes.CRYPTO_ACCOUNT;
        };
        this.getMasterFingerprint = () => this.masterFingerprint;
        this.getOutputDescriptors = () => this.outputDescriptors;
        this.toDataItem = () => {
            const map = {};
            if (this.masterFingerprint) {
                map[Keys.masterFingerprint] = this.masterFingerprint.readUInt32BE(0);
            }
            if (this.outputDescriptors) {
                map[Keys.outputDescriptors] = this.outputDescriptors.map((item) => item.toDataItem());
            }
            return new lib_1.DataItem(map);
        };
    }
}
exports.CryptoAccount = CryptoAccount;
CryptoAccount.fromDataItem = (dataItem) => {
    const map = dataItem.getData();
    const masterFingerprint = Buffer.alloc(4);
    const _masterFingerprint = map[Keys.masterFingerprint];
    if (_masterFingerprint) {
        masterFingerprint.writeUInt32BE(_masterFingerprint, 0);
    }
    const outputDescriptors = map[Keys.outputDescriptors];
    const cryptoOutputs = outputDescriptors.map((item) => _1.CryptoOutput.fromDataItem(item));
    return new CryptoAccount(masterFingerprint, cryptoOutputs);
};
CryptoAccount.fromCBOR = (_cborPayload) => {
    const dataItem = (0, lib_1.decodeToDataItem)(_cborPayload);
    return CryptoAccount.fromDataItem(dataItem);
};
//# sourceMappingURL=CryptoAccount.js.map