/// <reference types="node" />
import { DataItem, RegistryItem } from "@keystonehq/bc-ur-registry";
export declare class BtcSignature extends RegistryItem {
    private requestId;
    private signature;
    private publicKey;
    getRegistryType: () => import("@keystonehq/bc-ur-registry").RegistryType;
    constructor(signature: Buffer, requestId: Buffer, publicKey: Buffer);
    getRequestId: () => Buffer;
    getSignature: () => Buffer;
    getPublicKey: () => Buffer;
    toDataItem: () => DataItem;
    static fromDataItem: (dataItem: DataItem) => BtcSignature;
    static fromCBOR: (_cborPayload: Buffer) => BtcSignature;
}
