import type { ColorValue } from 'react-native';
import type { DirectEventHandler, Float, Int32, WithDefault } from 'react-native/Libraries/Types/CodegenTypes';
import type { ViewProps } from './utils';
import type { UnsafeMixed } from './codegenUtils';
import { NumberProp } from '../lib/extract/types';
interface SvgNodeCommonProps {
    name?: string;
    opacity?: WithDefault<Float, 1.0>;
    matrix?: ReadonlyArray<Float>;
    mask?: string;
    markerStart?: string;
    markerMid?: string;
    markerEnd?: string;
    clipPath?: string;
    clipRule?: WithDefault<Int32, 0>;
    responsible?: boolean;
    display?: string;
    pointerEvents?: string;
}
type ColorStruct = Readonly<{
    type?: WithDefault<Int32, -1>;
    payload?: ColorValue;
    brushRef?: string;
}>;
type OnSvgLayoutEvent = Readonly<{
    layout: {
        x: Int32;
        y: Int32;
        width: Int32;
        height: Int32;
    };
}>;
interface SvgRenderableCommonProps {
    color?: ColorValue;
    fill?: UnsafeMixed<ColorValue | ColorStruct>;
    fillOpacity?: WithDefault<Float, 1.0>;
    fillRule?: WithDefault<Int32, 1>;
    stroke?: UnsafeMixed<ColorValue | ColorStruct>;
    strokeOpacity?: WithDefault<Float, 1.0>;
    strokeWidth?: UnsafeMixed<NumberProp>;
    strokeLinecap?: WithDefault<Int32, 0>;
    strokeLinejoin?: WithDefault<Int32, 0>;
    strokeDasharray?: UnsafeMixed<ReadonlyArray<NumberProp> | NumberProp>;
    strokeDashoffset?: Float;
    strokeMiterlimit?: Float;
    vectorEffect?: WithDefault<Int32, 0>;
    propList?: ReadonlyArray<string>;
    filter?: string;
}
interface NativeProps extends ViewProps, SvgNodeCommonProps, SvgRenderableCommonProps {
    href?: string;
    x?: UnsafeMixed<NumberProp>;
    y?: UnsafeMixed<NumberProp>;
    height?: UnsafeMixed<NumberProp>;
    width?: UnsafeMixed<NumberProp>;
    onSvgLayout?: DirectEventHandler<OnSvgLayoutEvent>;
}
declare const _default: import("react-native/Libraries/Utilities/codegenNativeComponent").NativeComponentType<NativeProps>;
export default _default;
//# sourceMappingURL=UseNativeComponent.d.ts.map